/* This file is generated by venus-protocol git-2564dba1. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_COMMAND_BUFFER_H
#define VN_PROTOCOL_DRIVER_COMMAND_BUFFER_H

#include "vn_device.h"
#include "vn_protocol_driver_structs.h"

/* struct VkCommandBufferAllocateInfo chain */

static inline size_t
vn_sizeof_VkCommandBufferAllocateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCommandBufferAllocateInfo_self(const VkCommandBufferAllocateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkCommandPool(&val->commandPool);
    size += vn_sizeof_VkCommandBufferLevel(&val->level);
    size += vn_sizeof_uint32_t(&val->commandBufferCount);
    return size;
}

static inline size_t
vn_sizeof_VkCommandBufferAllocateInfo(const VkCommandBufferAllocateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCommandBufferAllocateInfo_pnext(val->pNext);
    size += vn_sizeof_VkCommandBufferAllocateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkCommandBufferAllocateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCommandBufferAllocateInfo_self(struct vn_cs_encoder *enc, const VkCommandBufferAllocateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkCommandPool(enc, &val->commandPool);
    vn_encode_VkCommandBufferLevel(enc, &val->level);
    vn_encode_uint32_t(enc, &val->commandBufferCount);
}

static inline void
vn_encode_VkCommandBufferAllocateInfo(struct vn_cs_encoder *enc, const VkCommandBufferAllocateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO });
    vn_encode_VkCommandBufferAllocateInfo_pnext(enc, val->pNext);
    vn_encode_VkCommandBufferAllocateInfo_self(enc, val);
}

/* struct VkCommandBufferInheritanceInfo chain */

static inline size_t
vn_sizeof_VkCommandBufferInheritanceInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCommandBufferInheritanceInfo_self(const VkCommandBufferInheritanceInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkRenderPass(&val->renderPass);
    size += vn_sizeof_uint32_t(&val->subpass);
    size += vn_sizeof_VkFramebuffer(&val->framebuffer);
    size += vn_sizeof_VkBool32(&val->occlusionQueryEnable);
    size += vn_sizeof_VkFlags(&val->queryFlags);
    size += vn_sizeof_VkFlags(&val->pipelineStatistics);
    return size;
}

static inline size_t
vn_sizeof_VkCommandBufferInheritanceInfo(const VkCommandBufferInheritanceInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCommandBufferInheritanceInfo_pnext(val->pNext);
    size += vn_sizeof_VkCommandBufferInheritanceInfo_self(val);

    return size;
}

static inline void
vn_encode_VkCommandBufferInheritanceInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCommandBufferInheritanceInfo_self(struct vn_cs_encoder *enc, const VkCommandBufferInheritanceInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkRenderPass(enc, &val->renderPass);
    vn_encode_uint32_t(enc, &val->subpass);
    vn_encode_VkFramebuffer(enc, &val->framebuffer);
    vn_encode_VkBool32(enc, &val->occlusionQueryEnable);
    vn_encode_VkFlags(enc, &val->queryFlags);
    vn_encode_VkFlags(enc, &val->pipelineStatistics);
}

static inline void
vn_encode_VkCommandBufferInheritanceInfo(struct vn_cs_encoder *enc, const VkCommandBufferInheritanceInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO });
    vn_encode_VkCommandBufferInheritanceInfo_pnext(enc, val->pNext);
    vn_encode_VkCommandBufferInheritanceInfo_self(enc, val);
}

static inline void
vn_decode_VkCommandBufferInheritanceInfo_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkCommandBufferInheritanceInfo_self(struct vn_cs_decoder *dec, VkCommandBufferInheritanceInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkRenderPass(dec, &val->renderPass);
    vn_decode_uint32_t(dec, &val->subpass);
    vn_decode_VkFramebuffer(dec, &val->framebuffer);
    vn_decode_VkBool32(dec, &val->occlusionQueryEnable);
    vn_decode_VkFlags(dec, &val->queryFlags);
    vn_decode_VkFlags(dec, &val->pipelineStatistics);
}

static inline void
vn_decode_VkCommandBufferInheritanceInfo(struct vn_cs_decoder *dec, VkCommandBufferInheritanceInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO);

    assert(val->sType == stype);
    vn_decode_VkCommandBufferInheritanceInfo_pnext(dec, val->pNext);
    vn_decode_VkCommandBufferInheritanceInfo_self(dec, val);
}

/* struct VkDeviceGroupCommandBufferBeginInfo chain */

static inline size_t
vn_sizeof_VkDeviceGroupCommandBufferBeginInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceGroupCommandBufferBeginInfo_self(const VkDeviceGroupCommandBufferBeginInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->deviceMask);
    return size;
}

static inline size_t
vn_sizeof_VkDeviceGroupCommandBufferBeginInfo(const VkDeviceGroupCommandBufferBeginInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceGroupCommandBufferBeginInfo_pnext(val->pNext);
    size += vn_sizeof_VkDeviceGroupCommandBufferBeginInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceGroupCommandBufferBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceGroupCommandBufferBeginInfo_self(struct vn_cs_encoder *enc, const VkDeviceGroupCommandBufferBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->deviceMask);
}

static inline void
vn_encode_VkDeviceGroupCommandBufferBeginInfo(struct vn_cs_encoder *enc, const VkDeviceGroupCommandBufferBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO });
    vn_encode_VkDeviceGroupCommandBufferBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkDeviceGroupCommandBufferBeginInfo_self(enc, val);
}

static inline void
vn_decode_VkDeviceGroupCommandBufferBeginInfo_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkDeviceGroupCommandBufferBeginInfo_self(struct vn_cs_decoder *dec, VkDeviceGroupCommandBufferBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->deviceMask);
}

static inline void
vn_decode_VkDeviceGroupCommandBufferBeginInfo(struct vn_cs_decoder *dec, VkDeviceGroupCommandBufferBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO);

    assert(val->sType == stype);
    vn_decode_VkDeviceGroupCommandBufferBeginInfo_pnext(dec, val->pNext);
    vn_decode_VkDeviceGroupCommandBufferBeginInfo_self(dec, val);
}

/* struct VkCommandBufferBeginInfo chain */

static inline size_t
vn_sizeof_VkCommandBufferBeginInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkCommandBufferBeginInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkDeviceGroupCommandBufferBeginInfo_self((const VkDeviceGroupCommandBufferBeginInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkCommandBufferBeginInfo_self(const VkCommandBufferBeginInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_simple_pointer(val->pInheritanceInfo);
    if (val->pInheritanceInfo)
        size += vn_sizeof_VkCommandBufferInheritanceInfo(val->pInheritanceInfo);
    return size;
}

static inline size_t
vn_sizeof_VkCommandBufferBeginInfo(const VkCommandBufferBeginInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkCommandBufferBeginInfo_pnext(val->pNext);
    size += vn_sizeof_VkCommandBufferBeginInfo_self(val);

    return size;
}

static inline void
vn_encode_VkCommandBufferBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkCommandBufferBeginInfo_pnext(enc, pnext->pNext);
            vn_encode_VkDeviceGroupCommandBufferBeginInfo_self(enc, (const VkDeviceGroupCommandBufferBeginInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkCommandBufferBeginInfo_self(struct vn_cs_encoder *enc, const VkCommandBufferBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    if (vn_encode_simple_pointer(enc, val->pInheritanceInfo))
        vn_encode_VkCommandBufferInheritanceInfo(enc, val->pInheritanceInfo);
}

static inline void
vn_encode_VkCommandBufferBeginInfo(struct vn_cs_encoder *enc, const VkCommandBufferBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO });
    vn_encode_VkCommandBufferBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkCommandBufferBeginInfo_self(enc, val);
}

static inline void
vn_decode_VkCommandBufferBeginInfo_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO:
        vn_decode_VkCommandBufferBeginInfo_pnext(dec, pnext->pNext);
        vn_decode_VkDeviceGroupCommandBufferBeginInfo_self(dec, (VkDeviceGroupCommandBufferBeginInfo *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkCommandBufferBeginInfo_self(struct vn_cs_decoder *dec, VkCommandBufferBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    if (vn_decode_simple_pointer(dec)) {
        vn_decode_VkCommandBufferInheritanceInfo(dec, (VkCommandBufferInheritanceInfo *)val->pInheritanceInfo);
    } else {
        val->pInheritanceInfo = NULL;
    }
}

static inline void
vn_decode_VkCommandBufferBeginInfo(struct vn_cs_decoder *dec, VkCommandBufferBeginInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO);

    assert(val->sType == stype);
    vn_decode_VkCommandBufferBeginInfo_pnext(dec, val->pNext);
    vn_decode_VkCommandBufferBeginInfo_self(dec, val);
}

/* struct VkBufferCopy */

static inline size_t
vn_sizeof_VkBufferCopy(const VkBufferCopy *val)
{
    size_t size = 0;
    size += vn_sizeof_VkDeviceSize(&val->srcOffset);
    size += vn_sizeof_VkDeviceSize(&val->dstOffset);
    size += vn_sizeof_VkDeviceSize(&val->size);
    return size;
}

static inline void
vn_encode_VkBufferCopy(struct vn_cs_encoder *enc, const VkBufferCopy *val)
{
    vn_encode_VkDeviceSize(enc, &val->srcOffset);
    vn_encode_VkDeviceSize(enc, &val->dstOffset);
    vn_encode_VkDeviceSize(enc, &val->size);
}

/* struct VkImageSubresourceLayers */

static inline size_t
vn_sizeof_VkImageSubresourceLayers(const VkImageSubresourceLayers *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->aspectMask);
    size += vn_sizeof_uint32_t(&val->mipLevel);
    size += vn_sizeof_uint32_t(&val->baseArrayLayer);
    size += vn_sizeof_uint32_t(&val->layerCount);
    return size;
}

static inline void
vn_encode_VkImageSubresourceLayers(struct vn_cs_encoder *enc, const VkImageSubresourceLayers *val)
{
    vn_encode_VkFlags(enc, &val->aspectMask);
    vn_encode_uint32_t(enc, &val->mipLevel);
    vn_encode_uint32_t(enc, &val->baseArrayLayer);
    vn_encode_uint32_t(enc, &val->layerCount);
}

/* struct VkImageCopy */

static inline size_t
vn_sizeof_VkImageCopy(const VkImageCopy *val)
{
    size_t size = 0;
    size += vn_sizeof_VkImageSubresourceLayers(&val->srcSubresource);
    size += vn_sizeof_VkOffset3D(&val->srcOffset);
    size += vn_sizeof_VkImageSubresourceLayers(&val->dstSubresource);
    size += vn_sizeof_VkOffset3D(&val->dstOffset);
    size += vn_sizeof_VkExtent3D(&val->extent);
    return size;
}

static inline void
vn_encode_VkImageCopy(struct vn_cs_encoder *enc, const VkImageCopy *val)
{
    vn_encode_VkImageSubresourceLayers(enc, &val->srcSubresource);
    vn_encode_VkOffset3D(enc, &val->srcOffset);
    vn_encode_VkImageSubresourceLayers(enc, &val->dstSubresource);
    vn_encode_VkOffset3D(enc, &val->dstOffset);
    vn_encode_VkExtent3D(enc, &val->extent);
}

/* struct VkImageBlit */

static inline size_t
vn_sizeof_VkImageBlit(const VkImageBlit *val)
{
    size_t size = 0;
    size += vn_sizeof_VkImageSubresourceLayers(&val->srcSubresource);
    size += vn_sizeof_array_size(2);
    for (uint32_t i = 0; i < 2; i++)
        size += vn_sizeof_VkOffset3D(&val->srcOffsets[i]);
    size += vn_sizeof_VkImageSubresourceLayers(&val->dstSubresource);
    size += vn_sizeof_array_size(2);
    for (uint32_t i = 0; i < 2; i++)
        size += vn_sizeof_VkOffset3D(&val->dstOffsets[i]);
    return size;
}

static inline void
vn_encode_VkImageBlit(struct vn_cs_encoder *enc, const VkImageBlit *val)
{
    vn_encode_VkImageSubresourceLayers(enc, &val->srcSubresource);
    vn_encode_array_size(enc, 2);
    for (uint32_t i = 0; i < 2; i++)
        vn_encode_VkOffset3D(enc, &val->srcOffsets[i]);
    vn_encode_VkImageSubresourceLayers(enc, &val->dstSubresource);
    vn_encode_array_size(enc, 2);
    for (uint32_t i = 0; i < 2; i++)
        vn_encode_VkOffset3D(enc, &val->dstOffsets[i]);
}

/* struct VkBufferImageCopy */

static inline size_t
vn_sizeof_VkBufferImageCopy(const VkBufferImageCopy *val)
{
    size_t size = 0;
    size += vn_sizeof_VkDeviceSize(&val->bufferOffset);
    size += vn_sizeof_uint32_t(&val->bufferRowLength);
    size += vn_sizeof_uint32_t(&val->bufferImageHeight);
    size += vn_sizeof_VkImageSubresourceLayers(&val->imageSubresource);
    size += vn_sizeof_VkOffset3D(&val->imageOffset);
    size += vn_sizeof_VkExtent3D(&val->imageExtent);
    return size;
}

static inline void
vn_encode_VkBufferImageCopy(struct vn_cs_encoder *enc, const VkBufferImageCopy *val)
{
    vn_encode_VkDeviceSize(enc, &val->bufferOffset);
    vn_encode_uint32_t(enc, &val->bufferRowLength);
    vn_encode_uint32_t(enc, &val->bufferImageHeight);
    vn_encode_VkImageSubresourceLayers(enc, &val->imageSubresource);
    vn_encode_VkOffset3D(enc, &val->imageOffset);
    vn_encode_VkExtent3D(enc, &val->imageExtent);
}

/* union VkClearColorValue */

static inline size_t
vn_sizeof_VkClearColorValue_tag(const VkClearColorValue *val, uint32_t tag)
{
    size_t size = vn_sizeof_uint32_t(&tag);
    switch (tag) {
    case 0:
        size += vn_sizeof_array_size(4);
    size += vn_sizeof_float_array(val->float32, 4);
        break;
    case 1:
        size += vn_sizeof_array_size(4);
    size += vn_sizeof_int32_t_array(val->int32, 4);
        break;
    case 2:
        size += vn_sizeof_array_size(4);
    size += vn_sizeof_uint32_t_array(val->uint32, 4);
        break;
    default:
        assert(false);
        break;
    }
    return size;
}

static inline size_t
vn_sizeof_VkClearColorValue(const VkClearColorValue *val)
{
    return vn_sizeof_VkClearColorValue_tag(val, 2);
}

static inline void
vn_encode_VkClearColorValue_tag(struct vn_cs_encoder *enc, const VkClearColorValue *val, uint32_t tag)
{
    vn_encode_uint32_t(enc, &tag);
    switch (tag) {
    case 0:
        vn_encode_array_size(enc, 4);
    vn_encode_float_array(enc, val->float32, 4);
        break;
    case 1:
        vn_encode_array_size(enc, 4);
    vn_encode_int32_t_array(enc, val->int32, 4);
        break;
    case 2:
        vn_encode_array_size(enc, 4);
    vn_encode_uint32_t_array(enc, val->uint32, 4);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_encode_VkClearColorValue(struct vn_cs_encoder *enc, const VkClearColorValue *val)
{
    vn_encode_VkClearColorValue_tag(enc, val, 2); /* union with default tag */
}

/* struct VkClearDepthStencilValue */

static inline size_t
vn_sizeof_VkClearDepthStencilValue(const VkClearDepthStencilValue *val)
{
    size_t size = 0;
    size += vn_sizeof_float(&val->depth);
    size += vn_sizeof_uint32_t(&val->stencil);
    return size;
}

static inline void
vn_encode_VkClearDepthStencilValue(struct vn_cs_encoder *enc, const VkClearDepthStencilValue *val)
{
    vn_encode_float(enc, &val->depth);
    vn_encode_uint32_t(enc, &val->stencil);
}

/* union VkClearValue */

static inline size_t
vn_sizeof_VkClearValue_tag(const VkClearValue *val, uint32_t tag)
{
    size_t size = vn_sizeof_uint32_t(&tag);
    switch (tag) {
    case 0:
        size += vn_sizeof_VkClearColorValue(&val->color);
        break;
    case 1:
        size += vn_sizeof_VkClearDepthStencilValue(&val->depthStencil);
        break;
    default:
        assert(false);
        break;
    }
    return size;
}

static inline size_t
vn_sizeof_VkClearValue(const VkClearValue *val)
{
    return vn_sizeof_VkClearValue_tag(val, 0);
}

static inline void
vn_encode_VkClearValue_tag(struct vn_cs_encoder *enc, const VkClearValue *val, uint32_t tag)
{
    vn_encode_uint32_t(enc, &tag);
    switch (tag) {
    case 0:
        vn_encode_VkClearColorValue(enc, &val->color);
        break;
    case 1:
        vn_encode_VkClearDepthStencilValue(enc, &val->depthStencil);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_encode_VkClearValue(struct vn_cs_encoder *enc, const VkClearValue *val)
{
    vn_encode_VkClearValue_tag(enc, val, 0); /* union with default tag */
}

/* struct VkClearAttachment */

static inline size_t
vn_sizeof_VkClearAttachment(const VkClearAttachment *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->aspectMask);
    size += vn_sizeof_uint32_t(&val->colorAttachment);
    size += vn_sizeof_VkClearValue(&val->clearValue);
    return size;
}

static inline void
vn_encode_VkClearAttachment(struct vn_cs_encoder *enc, const VkClearAttachment *val)
{
    vn_encode_VkFlags(enc, &val->aspectMask);
    vn_encode_uint32_t(enc, &val->colorAttachment);
    vn_encode_VkClearValue(enc, &val->clearValue);
}

/* struct VkClearRect */

static inline size_t
vn_sizeof_VkClearRect(const VkClearRect *val)
{
    size_t size = 0;
    size += vn_sizeof_VkRect2D(&val->rect);
    size += vn_sizeof_uint32_t(&val->baseArrayLayer);
    size += vn_sizeof_uint32_t(&val->layerCount);
    return size;
}

static inline void
vn_encode_VkClearRect(struct vn_cs_encoder *enc, const VkClearRect *val)
{
    vn_encode_VkRect2D(enc, &val->rect);
    vn_encode_uint32_t(enc, &val->baseArrayLayer);
    vn_encode_uint32_t(enc, &val->layerCount);
}

/* struct VkImageResolve */

static inline size_t
vn_sizeof_VkImageResolve(const VkImageResolve *val)
{
    size_t size = 0;
    size += vn_sizeof_VkImageSubresourceLayers(&val->srcSubresource);
    size += vn_sizeof_VkOffset3D(&val->srcOffset);
    size += vn_sizeof_VkImageSubresourceLayers(&val->dstSubresource);
    size += vn_sizeof_VkOffset3D(&val->dstOffset);
    size += vn_sizeof_VkExtent3D(&val->extent);
    return size;
}

static inline void
vn_encode_VkImageResolve(struct vn_cs_encoder *enc, const VkImageResolve *val)
{
    vn_encode_VkImageSubresourceLayers(enc, &val->srcSubresource);
    vn_encode_VkOffset3D(enc, &val->srcOffset);
    vn_encode_VkImageSubresourceLayers(enc, &val->dstSubresource);
    vn_encode_VkOffset3D(enc, &val->dstOffset);
    vn_encode_VkExtent3D(enc, &val->extent);
}

/* struct VkMemoryBarrier chain */

static inline size_t
vn_sizeof_VkMemoryBarrier_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkMemoryBarrier_self(const VkMemoryBarrier *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->srcAccessMask);
    size += vn_sizeof_VkFlags(&val->dstAccessMask);
    return size;
}

static inline size_t
vn_sizeof_VkMemoryBarrier(const VkMemoryBarrier *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkMemoryBarrier_pnext(val->pNext);
    size += vn_sizeof_VkMemoryBarrier_self(val);

    return size;
}

static inline void
vn_encode_VkMemoryBarrier_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkMemoryBarrier_self(struct vn_cs_encoder *enc, const VkMemoryBarrier *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->srcAccessMask);
    vn_encode_VkFlags(enc, &val->dstAccessMask);
}

static inline void
vn_encode_VkMemoryBarrier(struct vn_cs_encoder *enc, const VkMemoryBarrier *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_MEMORY_BARRIER);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_MEMORY_BARRIER });
    vn_encode_VkMemoryBarrier_pnext(enc, val->pNext);
    vn_encode_VkMemoryBarrier_self(enc, val);
}

/* struct VkBufferMemoryBarrier chain */

static inline size_t
vn_sizeof_VkBufferMemoryBarrier_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkBufferMemoryBarrier_self(const VkBufferMemoryBarrier *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->srcAccessMask);
    size += vn_sizeof_VkFlags(&val->dstAccessMask);
    size += vn_sizeof_uint32_t(&val->srcQueueFamilyIndex);
    size += vn_sizeof_uint32_t(&val->dstQueueFamilyIndex);
    size += vn_sizeof_VkBuffer(&val->buffer);
    size += vn_sizeof_VkDeviceSize(&val->offset);
    size += vn_sizeof_VkDeviceSize(&val->size);
    return size;
}

static inline size_t
vn_sizeof_VkBufferMemoryBarrier(const VkBufferMemoryBarrier *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkBufferMemoryBarrier_pnext(val->pNext);
    size += vn_sizeof_VkBufferMemoryBarrier_self(val);

    return size;
}

static inline void
vn_encode_VkBufferMemoryBarrier_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkBufferMemoryBarrier_self(struct vn_cs_encoder *enc, const VkBufferMemoryBarrier *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->srcAccessMask);
    vn_encode_VkFlags(enc, &val->dstAccessMask);
    vn_encode_uint32_t(enc, &val->srcQueueFamilyIndex);
    vn_encode_uint32_t(enc, &val->dstQueueFamilyIndex);
    vn_encode_VkBuffer(enc, &val->buffer);
    vn_encode_VkDeviceSize(enc, &val->offset);
    vn_encode_VkDeviceSize(enc, &val->size);
}

static inline void
vn_encode_VkBufferMemoryBarrier(struct vn_cs_encoder *enc, const VkBufferMemoryBarrier *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER });
    vn_encode_VkBufferMemoryBarrier_pnext(enc, val->pNext);
    vn_encode_VkBufferMemoryBarrier_self(enc, val);
}

/* struct VkImageMemoryBarrier chain */

static inline size_t
vn_sizeof_VkImageMemoryBarrier_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageMemoryBarrier_self(const VkImageMemoryBarrier *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->srcAccessMask);
    size += vn_sizeof_VkFlags(&val->dstAccessMask);
    size += vn_sizeof_VkImageLayout(&val->oldLayout);
    size += vn_sizeof_VkImageLayout(&val->newLayout);
    size += vn_sizeof_uint32_t(&val->srcQueueFamilyIndex);
    size += vn_sizeof_uint32_t(&val->dstQueueFamilyIndex);
    size += vn_sizeof_VkImage(&val->image);
    size += vn_sizeof_VkImageSubresourceRange(&val->subresourceRange);
    return size;
}

static inline size_t
vn_sizeof_VkImageMemoryBarrier(const VkImageMemoryBarrier *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageMemoryBarrier_pnext(val->pNext);
    size += vn_sizeof_VkImageMemoryBarrier_self(val);

    return size;
}

static inline void
vn_encode_VkImageMemoryBarrier_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageMemoryBarrier_self(struct vn_cs_encoder *enc, const VkImageMemoryBarrier *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->srcAccessMask);
    vn_encode_VkFlags(enc, &val->dstAccessMask);
    vn_encode_VkImageLayout(enc, &val->oldLayout);
    vn_encode_VkImageLayout(enc, &val->newLayout);
    vn_encode_uint32_t(enc, &val->srcQueueFamilyIndex);
    vn_encode_uint32_t(enc, &val->dstQueueFamilyIndex);
    vn_encode_VkImage(enc, &val->image);
    vn_encode_VkImageSubresourceRange(enc, &val->subresourceRange);
}

static inline void
vn_encode_VkImageMemoryBarrier(struct vn_cs_encoder *enc, const VkImageMemoryBarrier *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER });
    vn_encode_VkImageMemoryBarrier_pnext(enc, val->pNext);
    vn_encode_VkImageMemoryBarrier_self(enc, val);
}

/* struct VkDeviceGroupRenderPassBeginInfo chain */

static inline size_t
vn_sizeof_VkDeviceGroupRenderPassBeginInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceGroupRenderPassBeginInfo_self(const VkDeviceGroupRenderPassBeginInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->deviceMask);
    size += vn_sizeof_uint32_t(&val->deviceRenderAreaCount);
    if (val->pDeviceRenderAreas) {
        size += vn_sizeof_array_size(val->deviceRenderAreaCount);
        for (uint32_t i = 0; i < val->deviceRenderAreaCount; i++)
            size += vn_sizeof_VkRect2D(&val->pDeviceRenderAreas[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDeviceGroupRenderPassBeginInfo(const VkDeviceGroupRenderPassBeginInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceGroupRenderPassBeginInfo_pnext(val->pNext);
    size += vn_sizeof_VkDeviceGroupRenderPassBeginInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceGroupRenderPassBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceGroupRenderPassBeginInfo_self(struct vn_cs_encoder *enc, const VkDeviceGroupRenderPassBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->deviceMask);
    vn_encode_uint32_t(enc, &val->deviceRenderAreaCount);
    if (val->pDeviceRenderAreas) {
        vn_encode_array_size(enc, val->deviceRenderAreaCount);
        for (uint32_t i = 0; i < val->deviceRenderAreaCount; i++)
            vn_encode_VkRect2D(enc, &val->pDeviceRenderAreas[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDeviceGroupRenderPassBeginInfo(struct vn_cs_encoder *enc, const VkDeviceGroupRenderPassBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO });
    vn_encode_VkDeviceGroupRenderPassBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkDeviceGroupRenderPassBeginInfo_self(enc, val);
}

/* struct VkRenderPassAttachmentBeginInfo chain */

static inline size_t
vn_sizeof_VkRenderPassAttachmentBeginInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkRenderPassAttachmentBeginInfo_self(const VkRenderPassAttachmentBeginInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->attachmentCount);
    if (val->pAttachments) {
        size += vn_sizeof_array_size(val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            size += vn_sizeof_VkImageView(&val->pAttachments[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkRenderPassAttachmentBeginInfo(const VkRenderPassAttachmentBeginInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkRenderPassAttachmentBeginInfo_pnext(val->pNext);
    size += vn_sizeof_VkRenderPassAttachmentBeginInfo_self(val);

    return size;
}

static inline void
vn_encode_VkRenderPassAttachmentBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkRenderPassAttachmentBeginInfo_self(struct vn_cs_encoder *enc, const VkRenderPassAttachmentBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->attachmentCount);
    if (val->pAttachments) {
        vn_encode_array_size(enc, val->attachmentCount);
        for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_encode_VkImageView(enc, &val->pAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkRenderPassAttachmentBeginInfo(struct vn_cs_encoder *enc, const VkRenderPassAttachmentBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO });
    vn_encode_VkRenderPassAttachmentBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkRenderPassAttachmentBeginInfo_self(enc, val);
}

/* struct VkRenderPassBeginInfo chain */

static inline size_t
vn_sizeof_VkRenderPassBeginInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkRenderPassBeginInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkDeviceGroupRenderPassBeginInfo_self((const VkDeviceGroupRenderPassBeginInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkRenderPassBeginInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkRenderPassAttachmentBeginInfo_self((const VkRenderPassAttachmentBeginInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkRenderPassBeginInfo_self(const VkRenderPassBeginInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkRenderPass(&val->renderPass);
    size += vn_sizeof_VkFramebuffer(&val->framebuffer);
    size += vn_sizeof_VkRect2D(&val->renderArea);
    size += vn_sizeof_uint32_t(&val->clearValueCount);
    if (val->pClearValues) {
        size += vn_sizeof_array_size(val->clearValueCount);
        for (uint32_t i = 0; i < val->clearValueCount; i++)
            size += vn_sizeof_VkClearValue(&val->pClearValues[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkRenderPassBeginInfo(const VkRenderPassBeginInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkRenderPassBeginInfo_pnext(val->pNext);
    size += vn_sizeof_VkRenderPassBeginInfo_self(val);

    return size;
}

static inline void
vn_encode_VkRenderPassBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkRenderPassBeginInfo_pnext(enc, pnext->pNext);
            vn_encode_VkDeviceGroupRenderPassBeginInfo_self(enc, (const VkDeviceGroupRenderPassBeginInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkRenderPassBeginInfo_pnext(enc, pnext->pNext);
            vn_encode_VkRenderPassAttachmentBeginInfo_self(enc, (const VkRenderPassAttachmentBeginInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkRenderPassBeginInfo_self(struct vn_cs_encoder *enc, const VkRenderPassBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkRenderPass(enc, &val->renderPass);
    vn_encode_VkFramebuffer(enc, &val->framebuffer);
    vn_encode_VkRect2D(enc, &val->renderArea);
    vn_encode_uint32_t(enc, &val->clearValueCount);
    if (val->pClearValues) {
        vn_encode_array_size(enc, val->clearValueCount);
        for (uint32_t i = 0; i < val->clearValueCount; i++)
            vn_encode_VkClearValue(enc, &val->pClearValues[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkRenderPassBeginInfo(struct vn_cs_encoder *enc, const VkRenderPassBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO });
    vn_encode_VkRenderPassBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkRenderPassBeginInfo_self(enc, val);
}

/* struct VkSubpassBeginInfo chain */

static inline size_t
vn_sizeof_VkSubpassBeginInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSubpassBeginInfo_self(const VkSubpassBeginInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkSubpassContents(&val->contents);
    return size;
}

static inline size_t
vn_sizeof_VkSubpassBeginInfo(const VkSubpassBeginInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSubpassBeginInfo_pnext(val->pNext);
    size += vn_sizeof_VkSubpassBeginInfo_self(val);

    return size;
}

static inline void
vn_encode_VkSubpassBeginInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSubpassBeginInfo_self(struct vn_cs_encoder *enc, const VkSubpassBeginInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkSubpassContents(enc, &val->contents);
}

static inline void
vn_encode_VkSubpassBeginInfo(struct vn_cs_encoder *enc, const VkSubpassBeginInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO });
    vn_encode_VkSubpassBeginInfo_pnext(enc, val->pNext);
    vn_encode_VkSubpassBeginInfo_self(enc, val);
}

/* struct VkSubpassEndInfo chain */

static inline size_t
vn_sizeof_VkSubpassEndInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSubpassEndInfo_self(const VkSubpassEndInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    return size;
}

static inline size_t
vn_sizeof_VkSubpassEndInfo(const VkSubpassEndInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSubpassEndInfo_pnext(val->pNext);
    size += vn_sizeof_VkSubpassEndInfo_self(val);

    return size;
}

static inline void
vn_encode_VkSubpassEndInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSubpassEndInfo_self(struct vn_cs_encoder *enc, const VkSubpassEndInfo *val)
{
    /* skip val->{sType,pNext} */
}

static inline void
vn_encode_VkSubpassEndInfo(struct vn_cs_encoder *enc, const VkSubpassEndInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SUBPASS_END_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SUBPASS_END_INFO });
    vn_encode_VkSubpassEndInfo_pnext(enc, val->pNext);
    vn_encode_VkSubpassEndInfo_self(enc, val);
}

static inline size_t vn_sizeof_vkAllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkAllocateCommandBuffers_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_simple_pointer(pAllocateInfo);
    if (pAllocateInfo)
        cmd_size += vn_sizeof_VkCommandBufferAllocateInfo(pAllocateInfo);
    if (pCommandBuffers) {
        cmd_size += vn_sizeof_array_size(pAllocateInfo->commandBufferCount);
        for (uint32_t i = 0; i < pAllocateInfo->commandBufferCount; i++)
            cmd_size += vn_sizeof_VkCommandBuffer(&pCommandBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkAllocateCommandBuffers(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkAllocateCommandBuffers_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    if (vn_encode_simple_pointer(enc, pAllocateInfo))
        vn_encode_VkCommandBufferAllocateInfo(enc, pAllocateInfo);
    if (pCommandBuffers) {
        vn_encode_array_size(enc, pAllocateInfo->commandBufferCount);
        for (uint32_t i = 0; i < pAllocateInfo->commandBufferCount; i++)
            vn_encode_VkCommandBuffer(enc, &pCommandBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkAllocateCommandBuffers_reply(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkAllocateCommandBuffers_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip device */
    /* skip pAllocateInfo */
    if (pCommandBuffers) {
        cmd_size += vn_sizeof_array_size(pAllocateInfo->commandBufferCount);
        for (uint32_t i = 0; i < pAllocateInfo->commandBufferCount; i++)
            cmd_size += vn_sizeof_VkCommandBuffer(&pCommandBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline VkResult vn_decode_vkAllocateCommandBuffers_reply(struct vn_cs_decoder *dec, VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkAllocateCommandBuffers_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip device */
    /* skip pAllocateInfo */
    if (vn_peek_array_size(dec)) {
        vn_decode_array_size(dec, pAllocateInfo->commandBufferCount);
        for (uint32_t i = 0; i < pAllocateInfo->commandBufferCount; i++)
            vn_decode_VkCommandBuffer(dec, &pCommandBuffers[i]);
    } else {
        vn_decode_array_size(dec, 0);
        pCommandBuffers = NULL;
    }

    return ret;
}

static inline size_t vn_sizeof_vkFreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkFreeCommandBuffers_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkDevice(&device);
    cmd_size += vn_sizeof_VkCommandPool(&commandPool);
    cmd_size += vn_sizeof_uint32_t(&commandBufferCount);
    if (pCommandBuffers) {
        cmd_size += vn_sizeof_array_size(commandBufferCount);
        for (uint32_t i = 0; i < commandBufferCount; i++)
            cmd_size += vn_sizeof_VkCommandBuffer(&pCommandBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkFreeCommandBuffers(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkFreeCommandBuffers_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkDevice(enc, &device);
    vn_encode_VkCommandPool(enc, &commandPool);
    vn_encode_uint32_t(enc, &commandBufferCount);
    if (pCommandBuffers) {
        vn_encode_array_size(enc, commandBufferCount);
        for (uint32_t i = 0; i < commandBufferCount; i++)
            vn_encode_VkCommandBuffer(enc, &pCommandBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkFreeCommandBuffers_reply(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkFreeCommandBuffers_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip device */
    /* skip commandPool */
    /* skip commandBufferCount */
    /* skip pCommandBuffers */

    return cmd_size;
}

static inline void vn_decode_vkFreeCommandBuffers_reply(struct vn_cs_decoder *dec, VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkFreeCommandBuffers_EXT);

    /* skip device */
    /* skip commandPool */
    /* skip commandBufferCount */
    /* skip pCommandBuffers */
}

static inline size_t vn_sizeof_vkBeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBeginCommandBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pBeginInfo);
    if (pBeginInfo)
        cmd_size += vn_sizeof_VkCommandBufferBeginInfo(pBeginInfo);

    return cmd_size;
}

static inline void vn_encode_vkBeginCommandBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBeginCommandBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pBeginInfo))
        vn_encode_VkCommandBufferBeginInfo(enc, pBeginInfo);
}

static inline size_t vn_sizeof_vkBeginCommandBuffer_reply(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkBeginCommandBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip commandBuffer */
    /* skip pBeginInfo */

    return cmd_size;
}

static inline VkResult vn_decode_vkBeginCommandBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkBeginCommandBuffer_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip commandBuffer */
    /* skip pBeginInfo */

    return ret;
}

static inline size_t vn_sizeof_vkEndCommandBuffer(VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEndCommandBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);

    return cmd_size;
}

static inline void vn_encode_vkEndCommandBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEndCommandBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
}

static inline size_t vn_sizeof_vkEndCommandBuffer_reply(VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkEndCommandBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip commandBuffer */

    return cmd_size;
}

static inline VkResult vn_decode_vkEndCommandBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkEndCommandBuffer_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip commandBuffer */

    return ret;
}

static inline size_t vn_sizeof_vkResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkResetCommandBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFlags(&flags);

    return cmd_size;
}

static inline void vn_encode_vkResetCommandBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkResetCommandBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFlags(enc, &flags);
}

static inline size_t vn_sizeof_vkResetCommandBuffer_reply(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkResetCommandBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    VkResult ret;
    cmd_size += vn_sizeof_VkResult(&ret);
    /* skip commandBuffer */
    /* skip flags */

    return cmd_size;
}

static inline VkResult vn_decode_vkResetCommandBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkResetCommandBuffer_EXT);

    VkResult ret;
    vn_decode_VkResult(dec, &ret);
    /* skip commandBuffer */
    /* skip flags */

    return ret;
}

static inline size_t vn_sizeof_vkCmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindPipeline_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkPipelineBindPoint(&pipelineBindPoint);
    cmd_size += vn_sizeof_VkPipeline(&pipeline);

    return cmd_size;
}

static inline void vn_encode_vkCmdBindPipeline(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindPipeline_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkPipelineBindPoint(enc, &pipelineBindPoint);
    vn_encode_VkPipeline(enc, &pipeline);
}

static inline size_t vn_sizeof_vkCmdBindPipeline_reply(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindPipeline_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pipelineBindPoint */
    /* skip pipeline */

    return cmd_size;
}

static inline void vn_decode_vkCmdBindPipeline_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBindPipeline_EXT);

    /* skip commandBuffer */
    /* skip pipelineBindPoint */
    /* skip pipeline */
}

static inline size_t vn_sizeof_vkCmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetViewport_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstViewport);
    cmd_size += vn_sizeof_uint32_t(&viewportCount);
    if (pViewports) {
        cmd_size += vn_sizeof_array_size(viewportCount);
        for (uint32_t i = 0; i < viewportCount; i++)
            cmd_size += vn_sizeof_VkViewport(&pViewports[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdSetViewport(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetViewport_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstViewport);
    vn_encode_uint32_t(enc, &viewportCount);
    if (pViewports) {
        vn_encode_array_size(enc, viewportCount);
        for (uint32_t i = 0; i < viewportCount; i++)
            vn_encode_VkViewport(enc, &pViewports[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdSetViewport_reply(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetViewport_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstViewport */
    /* skip viewportCount */
    /* skip pViewports */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetViewport_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetViewport_EXT);

    /* skip commandBuffer */
    /* skip firstViewport */
    /* skip viewportCount */
    /* skip pViewports */
}

static inline size_t vn_sizeof_vkCmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetScissor_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstScissor);
    cmd_size += vn_sizeof_uint32_t(&scissorCount);
    if (pScissors) {
        cmd_size += vn_sizeof_array_size(scissorCount);
        for (uint32_t i = 0; i < scissorCount; i++)
            cmd_size += vn_sizeof_VkRect2D(&pScissors[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdSetScissor(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetScissor_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstScissor);
    vn_encode_uint32_t(enc, &scissorCount);
    if (pScissors) {
        vn_encode_array_size(enc, scissorCount);
        for (uint32_t i = 0; i < scissorCount; i++)
            vn_encode_VkRect2D(enc, &pScissors[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdSetScissor_reply(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetScissor_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstScissor */
    /* skip scissorCount */
    /* skip pScissors */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetScissor_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetScissor_EXT);

    /* skip commandBuffer */
    /* skip firstScissor */
    /* skip scissorCount */
    /* skip pScissors */
}

static inline size_t vn_sizeof_vkCmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineWidth_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_float(&lineWidth);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetLineWidth(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float lineWidth)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineWidth_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_float(enc, &lineWidth);
}

static inline size_t vn_sizeof_vkCmdSetLineWidth_reply(VkCommandBuffer commandBuffer, float lineWidth)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetLineWidth_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip lineWidth */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetLineWidth_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, float lineWidth)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetLineWidth_EXT);

    /* skip commandBuffer */
    /* skip lineWidth */
}

static inline size_t vn_sizeof_vkCmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBias_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_float(&depthBiasConstantFactor);
    cmd_size += vn_sizeof_float(&depthBiasClamp);
    cmd_size += vn_sizeof_float(&depthBiasSlopeFactor);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDepthBias(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBias_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_float(enc, &depthBiasConstantFactor);
    vn_encode_float(enc, &depthBiasClamp);
    vn_encode_float(enc, &depthBiasSlopeFactor);
}

static inline size_t vn_sizeof_vkCmdSetDepthBias_reply(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBias_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip depthBiasConstantFactor */
    /* skip depthBiasClamp */
    /* skip depthBiasSlopeFactor */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDepthBias_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDepthBias_EXT);

    /* skip commandBuffer */
    /* skip depthBiasConstantFactor */
    /* skip depthBiasClamp */
    /* skip depthBiasSlopeFactor */
}

static inline size_t vn_sizeof_vkCmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetBlendConstants_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_array_size(4);
    cmd_size += vn_sizeof_float_array(blendConstants, 4);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetBlendConstants(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetBlendConstants_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_array_size(enc, 4);
    vn_encode_float_array(enc, blendConstants, 4);
}

static inline size_t vn_sizeof_vkCmdSetBlendConstants_reply(VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetBlendConstants_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip blendConstants */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetBlendConstants_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetBlendConstants_EXT);

    /* skip commandBuffer */
    /* skip blendConstants */
}

static inline size_t vn_sizeof_vkCmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBounds_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_float(&minDepthBounds);
    cmd_size += vn_sizeof_float(&maxDepthBounds);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDepthBounds(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBounds_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_float(enc, &minDepthBounds);
    vn_encode_float(enc, &maxDepthBounds);
}

static inline size_t vn_sizeof_vkCmdSetDepthBounds_reply(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDepthBounds_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip minDepthBounds */
    /* skip maxDepthBounds */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDepthBounds_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDepthBounds_EXT);

    /* skip commandBuffer */
    /* skip minDepthBounds */
    /* skip maxDepthBounds */
}

static inline size_t vn_sizeof_vkCmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilCompareMask_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFlags(&faceMask);
    cmd_size += vn_sizeof_uint32_t(&compareMask);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetStencilCompareMask(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilCompareMask_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFlags(enc, &faceMask);
    vn_encode_uint32_t(enc, &compareMask);
}

static inline size_t vn_sizeof_vkCmdSetStencilCompareMask_reply(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilCompareMask_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip compareMask */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetStencilCompareMask_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetStencilCompareMask_EXT);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip compareMask */
}

static inline size_t vn_sizeof_vkCmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilWriteMask_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFlags(&faceMask);
    cmd_size += vn_sizeof_uint32_t(&writeMask);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetStencilWriteMask(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilWriteMask_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFlags(enc, &faceMask);
    vn_encode_uint32_t(enc, &writeMask);
}

static inline size_t vn_sizeof_vkCmdSetStencilWriteMask_reply(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilWriteMask_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip writeMask */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetStencilWriteMask_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetStencilWriteMask_EXT);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip writeMask */
}

static inline size_t vn_sizeof_vkCmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilReference_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFlags(&faceMask);
    cmd_size += vn_sizeof_uint32_t(&reference);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetStencilReference(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilReference_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFlags(enc, &faceMask);
    vn_encode_uint32_t(enc, &reference);
}

static inline size_t vn_sizeof_vkCmdSetStencilReference_reply(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetStencilReference_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip reference */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetStencilReference_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetStencilReference_EXT);

    /* skip commandBuffer */
    /* skip faceMask */
    /* skip reference */
}

static inline size_t vn_sizeof_vkCmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindDescriptorSets_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkPipelineBindPoint(&pipelineBindPoint);
    cmd_size += vn_sizeof_VkPipelineLayout(&layout);
    cmd_size += vn_sizeof_uint32_t(&firstSet);
    cmd_size += vn_sizeof_uint32_t(&descriptorSetCount);
    if (pDescriptorSets) {
        cmd_size += vn_sizeof_array_size(descriptorSetCount);
        for (uint32_t i = 0; i < descriptorSetCount; i++)
            cmd_size += vn_sizeof_VkDescriptorSet(&pDescriptorSets[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&dynamicOffsetCount);
    if (pDynamicOffsets) {
        cmd_size += vn_sizeof_array_size(dynamicOffsetCount);
        cmd_size += vn_sizeof_uint32_t_array(pDynamicOffsets, dynamicOffsetCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdBindDescriptorSets(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindDescriptorSets_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkPipelineBindPoint(enc, &pipelineBindPoint);
    vn_encode_VkPipelineLayout(enc, &layout);
    vn_encode_uint32_t(enc, &firstSet);
    vn_encode_uint32_t(enc, &descriptorSetCount);
    if (pDescriptorSets) {
        vn_encode_array_size(enc, descriptorSetCount);
        for (uint32_t i = 0; i < descriptorSetCount; i++)
            vn_encode_VkDescriptorSet(enc, &pDescriptorSets[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &dynamicOffsetCount);
    if (pDynamicOffsets) {
        vn_encode_array_size(enc, dynamicOffsetCount);
        vn_encode_uint32_t_array(enc, pDynamicOffsets, dynamicOffsetCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdBindDescriptorSets_reply(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindDescriptorSets_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pipelineBindPoint */
    /* skip layout */
    /* skip firstSet */
    /* skip descriptorSetCount */
    /* skip pDescriptorSets */
    /* skip dynamicOffsetCount */
    /* skip pDynamicOffsets */

    return cmd_size;
}

static inline void vn_decode_vkCmdBindDescriptorSets_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBindDescriptorSets_EXT);

    /* skip commandBuffer */
    /* skip pipelineBindPoint */
    /* skip layout */
    /* skip firstSet */
    /* skip descriptorSetCount */
    /* skip pDescriptorSets */
    /* skip dynamicOffsetCount */
    /* skip pDynamicOffsets */
}

static inline size_t vn_sizeof_vkCmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindIndexBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceSize(&offset);
    cmd_size += vn_sizeof_VkIndexType(&indexType);

    return cmd_size;
}

static inline void vn_encode_vkCmdBindIndexBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindIndexBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceSize(enc, &offset);
    vn_encode_VkIndexType(enc, &indexType);
}

static inline size_t vn_sizeof_vkCmdBindIndexBuffer_reply(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindIndexBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip indexType */

    return cmd_size;
}

static inline void vn_decode_vkCmdBindIndexBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBindIndexBuffer_EXT);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip indexType */
}

static inline size_t vn_sizeof_vkCmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindVertexBuffers_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstBinding);
    cmd_size += vn_sizeof_uint32_t(&bindingCount);
    if (pBuffers) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        for (uint32_t i = 0; i < bindingCount; i++)
            cmd_size += vn_sizeof_VkBuffer(&pBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pOffsets) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        cmd_size += vn_sizeof_VkDeviceSize_array(pOffsets, bindingCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdBindVertexBuffers(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindVertexBuffers_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstBinding);
    vn_encode_uint32_t(enc, &bindingCount);
    if (pBuffers) {
        vn_encode_array_size(enc, bindingCount);
        for (uint32_t i = 0; i < bindingCount; i++)
            vn_encode_VkBuffer(enc, &pBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pOffsets) {
        vn_encode_array_size(enc, bindingCount);
        vn_encode_VkDeviceSize_array(enc, pOffsets, bindingCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdBindVertexBuffers_reply(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindVertexBuffers_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstBinding */
    /* skip bindingCount */
    /* skip pBuffers */
    /* skip pOffsets */

    return cmd_size;
}

static inline void vn_decode_vkCmdBindVertexBuffers_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBindVertexBuffers_EXT);

    /* skip commandBuffer */
    /* skip firstBinding */
    /* skip bindingCount */
    /* skip pBuffers */
    /* skip pOffsets */
}

static inline size_t vn_sizeof_vkCmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDraw_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&vertexCount);
    cmd_size += vn_sizeof_uint32_t(&instanceCount);
    cmd_size += vn_sizeof_uint32_t(&firstVertex);
    cmd_size += vn_sizeof_uint32_t(&firstInstance);

    return cmd_size;
}

static inline void vn_encode_vkCmdDraw(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDraw_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &vertexCount);
    vn_encode_uint32_t(enc, &instanceCount);
    vn_encode_uint32_t(enc, &firstVertex);
    vn_encode_uint32_t(enc, &firstInstance);
}

static inline size_t vn_sizeof_vkCmdDraw_reply(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDraw_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip vertexCount */
    /* skip instanceCount */
    /* skip firstVertex */
    /* skip firstInstance */

    return cmd_size;
}

static inline void vn_decode_vkCmdDraw_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDraw_EXT);

    /* skip commandBuffer */
    /* skip vertexCount */
    /* skip instanceCount */
    /* skip firstVertex */
    /* skip firstInstance */
}

static inline size_t vn_sizeof_vkCmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexed_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&indexCount);
    cmd_size += vn_sizeof_uint32_t(&instanceCount);
    cmd_size += vn_sizeof_uint32_t(&firstIndex);
    cmd_size += vn_sizeof_int32_t(&vertexOffset);
    cmd_size += vn_sizeof_uint32_t(&firstInstance);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawIndexed(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexed_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &indexCount);
    vn_encode_uint32_t(enc, &instanceCount);
    vn_encode_uint32_t(enc, &firstIndex);
    vn_encode_int32_t(enc, &vertexOffset);
    vn_encode_uint32_t(enc, &firstInstance);
}

static inline size_t vn_sizeof_vkCmdDrawIndexed_reply(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexed_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip indexCount */
    /* skip instanceCount */
    /* skip firstIndex */
    /* skip vertexOffset */
    /* skip firstInstance */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawIndexed_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawIndexed_EXT);

    /* skip commandBuffer */
    /* skip indexCount */
    /* skip instanceCount */
    /* skip firstIndex */
    /* skip vertexOffset */
    /* skip firstInstance */
}

static inline size_t vn_sizeof_vkCmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirect_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceSize(&offset);
    cmd_size += vn_sizeof_uint32_t(&drawCount);
    cmd_size += vn_sizeof_uint32_t(&stride);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawIndirect(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirect_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceSize(enc, &offset);
    vn_encode_uint32_t(enc, &drawCount);
    vn_encode_uint32_t(enc, &stride);
}

static inline size_t vn_sizeof_vkCmdDrawIndirect_reply(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirect_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip drawCount */
    /* skip stride */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawIndirect_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawIndirect_EXT);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip drawCount */
    /* skip stride */
}

static inline size_t vn_sizeof_vkCmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexedIndirect_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceSize(&offset);
    cmd_size += vn_sizeof_uint32_t(&drawCount);
    cmd_size += vn_sizeof_uint32_t(&stride);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawIndexedIndirect(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexedIndirect_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceSize(enc, &offset);
    vn_encode_uint32_t(enc, &drawCount);
    vn_encode_uint32_t(enc, &stride);
}

static inline size_t vn_sizeof_vkCmdDrawIndexedIndirect_reply(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexedIndirect_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip drawCount */
    /* skip stride */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawIndexedIndirect_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawIndexedIndirect_EXT);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip drawCount */
    /* skip stride */
}

static inline size_t vn_sizeof_vkCmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatch_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&groupCountX);
    cmd_size += vn_sizeof_uint32_t(&groupCountY);
    cmd_size += vn_sizeof_uint32_t(&groupCountZ);

    return cmd_size;
}

static inline void vn_encode_vkCmdDispatch(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatch_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &groupCountX);
    vn_encode_uint32_t(enc, &groupCountY);
    vn_encode_uint32_t(enc, &groupCountZ);
}

static inline size_t vn_sizeof_vkCmdDispatch_reply(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatch_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip groupCountX */
    /* skip groupCountY */
    /* skip groupCountZ */

    return cmd_size;
}

static inline void vn_decode_vkCmdDispatch_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDispatch_EXT);

    /* skip commandBuffer */
    /* skip groupCountX */
    /* skip groupCountY */
    /* skip groupCountZ */
}

static inline size_t vn_sizeof_vkCmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatchIndirect_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceSize(&offset);

    return cmd_size;
}

static inline void vn_encode_vkCmdDispatchIndirect(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatchIndirect_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceSize(enc, &offset);
}

static inline size_t vn_sizeof_vkCmdDispatchIndirect_reply(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatchIndirect_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */

    return cmd_size;
}

static inline void vn_decode_vkCmdDispatchIndirect_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDispatchIndirect_EXT);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
}

static inline size_t vn_sizeof_vkCmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&srcBuffer);
    cmd_size += vn_sizeof_VkBuffer(&dstBuffer);
    cmd_size += vn_sizeof_uint32_t(&regionCount);
    if (pRegions) {
        cmd_size += vn_sizeof_array_size(regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            cmd_size += vn_sizeof_VkBufferCopy(&pRegions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &srcBuffer);
    vn_encode_VkBuffer(enc, &dstBuffer);
    vn_encode_uint32_t(enc, &regionCount);
    if (pRegions) {
        vn_encode_array_size(enc, regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            vn_encode_VkBufferCopy(enc, &pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdCopyBuffer_reply(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcBuffer */
    /* skip dstBuffer */
    /* skip regionCount */
    /* skip pRegions */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyBuffer_EXT);

    /* skip commandBuffer */
    /* skip srcBuffer */
    /* skip dstBuffer */
    /* skip regionCount */
    /* skip pRegions */
}

static inline size_t vn_sizeof_vkCmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkImage(&srcImage);
    cmd_size += vn_sizeof_VkImageLayout(&srcImageLayout);
    cmd_size += vn_sizeof_VkImage(&dstImage);
    cmd_size += vn_sizeof_VkImageLayout(&dstImageLayout);
    cmd_size += vn_sizeof_uint32_t(&regionCount);
    if (pRegions) {
        cmd_size += vn_sizeof_array_size(regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            cmd_size += vn_sizeof_VkImageCopy(&pRegions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkImage(enc, &srcImage);
    vn_encode_VkImageLayout(enc, &srcImageLayout);
    vn_encode_VkImage(enc, &dstImage);
    vn_encode_VkImageLayout(enc, &dstImageLayout);
    vn_encode_uint32_t(enc, &regionCount);
    if (pRegions) {
        vn_encode_array_size(enc, regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            vn_encode_VkImageCopy(enc, &pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdCopyImage_reply(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyImage_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyImage_EXT);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */
}

static inline size_t vn_sizeof_vkCmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBlitImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkImage(&srcImage);
    cmd_size += vn_sizeof_VkImageLayout(&srcImageLayout);
    cmd_size += vn_sizeof_VkImage(&dstImage);
    cmd_size += vn_sizeof_VkImageLayout(&dstImageLayout);
    cmd_size += vn_sizeof_uint32_t(&regionCount);
    if (pRegions) {
        cmd_size += vn_sizeof_array_size(regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            cmd_size += vn_sizeof_VkImageBlit(&pRegions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_VkFilter(&filter);

    return cmd_size;
}

static inline void vn_encode_vkCmdBlitImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBlitImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkImage(enc, &srcImage);
    vn_encode_VkImageLayout(enc, &srcImageLayout);
    vn_encode_VkImage(enc, &dstImage);
    vn_encode_VkImageLayout(enc, &dstImageLayout);
    vn_encode_uint32_t(enc, &regionCount);
    if (pRegions) {
        vn_encode_array_size(enc, regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            vn_encode_VkImageBlit(enc, &pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_VkFilter(enc, &filter);
}

static inline size_t vn_sizeof_vkCmdBlitImage_reply(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBlitImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */
    /* skip filter */

    return cmd_size;
}

static inline void vn_decode_vkCmdBlitImage_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBlitImage_EXT);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */
    /* skip filter */
}

static inline size_t vn_sizeof_vkCmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBufferToImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&srcBuffer);
    cmd_size += vn_sizeof_VkImage(&dstImage);
    cmd_size += vn_sizeof_VkImageLayout(&dstImageLayout);
    cmd_size += vn_sizeof_uint32_t(&regionCount);
    if (pRegions) {
        cmd_size += vn_sizeof_array_size(regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            cmd_size += vn_sizeof_VkBufferImageCopy(&pRegions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyBufferToImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBufferToImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &srcBuffer);
    vn_encode_VkImage(enc, &dstImage);
    vn_encode_VkImageLayout(enc, &dstImageLayout);
    vn_encode_uint32_t(enc, &regionCount);
    if (pRegions) {
        vn_encode_array_size(enc, regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            vn_encode_VkBufferImageCopy(enc, &pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdCopyBufferToImage_reply(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyBufferToImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcBuffer */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyBufferToImage_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyBufferToImage_EXT);

    /* skip commandBuffer */
    /* skip srcBuffer */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */
}

static inline size_t vn_sizeof_vkCmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImageToBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkImage(&srcImage);
    cmd_size += vn_sizeof_VkImageLayout(&srcImageLayout);
    cmd_size += vn_sizeof_VkBuffer(&dstBuffer);
    cmd_size += vn_sizeof_uint32_t(&regionCount);
    if (pRegions) {
        cmd_size += vn_sizeof_array_size(regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            cmd_size += vn_sizeof_VkBufferImageCopy(&pRegions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyImageToBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImageToBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkImage(enc, &srcImage);
    vn_encode_VkImageLayout(enc, &srcImageLayout);
    vn_encode_VkBuffer(enc, &dstBuffer);
    vn_encode_uint32_t(enc, &regionCount);
    if (pRegions) {
        vn_encode_array_size(enc, regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            vn_encode_VkBufferImageCopy(enc, &pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdCopyImageToBuffer_reply(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyImageToBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstBuffer */
    /* skip regionCount */
    /* skip pRegions */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyImageToBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyImageToBuffer_EXT);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstBuffer */
    /* skip regionCount */
    /* skip pRegions */
}

static inline size_t vn_sizeof_vkCmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdUpdateBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&dstBuffer);
    cmd_size += vn_sizeof_VkDeviceSize(&dstOffset);
    cmd_size += vn_sizeof_VkDeviceSize(&dataSize);
    if (pData) {
        cmd_size += vn_sizeof_array_size(dataSize);
        cmd_size += vn_sizeof_blob_array(pData, dataSize);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdUpdateBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdUpdateBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &dstBuffer);
    vn_encode_VkDeviceSize(enc, &dstOffset);
    vn_encode_VkDeviceSize(enc, &dataSize);
    if (pData) {
        vn_encode_array_size(enc, dataSize);
        vn_encode_blob_array(enc, pData, dataSize);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdUpdateBuffer_reply(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdUpdateBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip dstBuffer */
    /* skip dstOffset */
    /* skip dataSize */
    /* skip pData */

    return cmd_size;
}

static inline void vn_decode_vkCmdUpdateBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdUpdateBuffer_EXT);

    /* skip commandBuffer */
    /* skip dstBuffer */
    /* skip dstOffset */
    /* skip dataSize */
    /* skip pData */
}

static inline size_t vn_sizeof_vkCmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdFillBuffer_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&dstBuffer);
    cmd_size += vn_sizeof_VkDeviceSize(&dstOffset);
    cmd_size += vn_sizeof_VkDeviceSize(&size);
    cmd_size += vn_sizeof_uint32_t(&data);

    return cmd_size;
}

static inline void vn_encode_vkCmdFillBuffer(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdFillBuffer_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &dstBuffer);
    vn_encode_VkDeviceSize(enc, &dstOffset);
    vn_encode_VkDeviceSize(enc, &size);
    vn_encode_uint32_t(enc, &data);
}

static inline size_t vn_sizeof_vkCmdFillBuffer_reply(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdFillBuffer_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip dstBuffer */
    /* skip dstOffset */
    /* skip size */
    /* skip data */

    return cmd_size;
}

static inline void vn_decode_vkCmdFillBuffer_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdFillBuffer_EXT);

    /* skip commandBuffer */
    /* skip dstBuffer */
    /* skip dstOffset */
    /* skip size */
    /* skip data */
}

static inline size_t vn_sizeof_vkCmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearColorImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkImage(&image);
    cmd_size += vn_sizeof_VkImageLayout(&imageLayout);
    cmd_size += vn_sizeof_simple_pointer(pColor);
    if (pColor)
        cmd_size += vn_sizeof_VkClearColorValue(pColor);
    cmd_size += vn_sizeof_uint32_t(&rangeCount);
    if (pRanges) {
        cmd_size += vn_sizeof_array_size(rangeCount);
        for (uint32_t i = 0; i < rangeCount; i++)
            cmd_size += vn_sizeof_VkImageSubresourceRange(&pRanges[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdClearColorImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearColorImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkImage(enc, &image);
    vn_encode_VkImageLayout(enc, &imageLayout);
    if (vn_encode_simple_pointer(enc, pColor))
        vn_encode_VkClearColorValue(enc, pColor);
    vn_encode_uint32_t(enc, &rangeCount);
    if (pRanges) {
        vn_encode_array_size(enc, rangeCount);
        for (uint32_t i = 0; i < rangeCount; i++)
            vn_encode_VkImageSubresourceRange(enc, &pRanges[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdClearColorImage_reply(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearColorImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip image */
    /* skip imageLayout */
    /* skip pColor */
    /* skip rangeCount */
    /* skip pRanges */

    return cmd_size;
}

static inline void vn_decode_vkCmdClearColorImage_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdClearColorImage_EXT);

    /* skip commandBuffer */
    /* skip image */
    /* skip imageLayout */
    /* skip pColor */
    /* skip rangeCount */
    /* skip pRanges */
}

static inline size_t vn_sizeof_vkCmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearDepthStencilImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkImage(&image);
    cmd_size += vn_sizeof_VkImageLayout(&imageLayout);
    cmd_size += vn_sizeof_simple_pointer(pDepthStencil);
    if (pDepthStencil)
        cmd_size += vn_sizeof_VkClearDepthStencilValue(pDepthStencil);
    cmd_size += vn_sizeof_uint32_t(&rangeCount);
    if (pRanges) {
        cmd_size += vn_sizeof_array_size(rangeCount);
        for (uint32_t i = 0; i < rangeCount; i++)
            cmd_size += vn_sizeof_VkImageSubresourceRange(&pRanges[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdClearDepthStencilImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearDepthStencilImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkImage(enc, &image);
    vn_encode_VkImageLayout(enc, &imageLayout);
    if (vn_encode_simple_pointer(enc, pDepthStencil))
        vn_encode_VkClearDepthStencilValue(enc, pDepthStencil);
    vn_encode_uint32_t(enc, &rangeCount);
    if (pRanges) {
        vn_encode_array_size(enc, rangeCount);
        for (uint32_t i = 0; i < rangeCount; i++)
            vn_encode_VkImageSubresourceRange(enc, &pRanges[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdClearDepthStencilImage_reply(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearDepthStencilImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip image */
    /* skip imageLayout */
    /* skip pDepthStencil */
    /* skip rangeCount */
    /* skip pRanges */

    return cmd_size;
}

static inline void vn_decode_vkCmdClearDepthStencilImage_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdClearDepthStencilImage_EXT);

    /* skip commandBuffer */
    /* skip image */
    /* skip imageLayout */
    /* skip pDepthStencil */
    /* skip rangeCount */
    /* skip pRanges */
}

static inline size_t vn_sizeof_vkCmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearAttachments_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&attachmentCount);
    if (pAttachments) {
        cmd_size += vn_sizeof_array_size(attachmentCount);
        for (uint32_t i = 0; i < attachmentCount; i++)
            cmd_size += vn_sizeof_VkClearAttachment(&pAttachments[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&rectCount);
    if (pRects) {
        cmd_size += vn_sizeof_array_size(rectCount);
        for (uint32_t i = 0; i < rectCount; i++)
            cmd_size += vn_sizeof_VkClearRect(&pRects[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdClearAttachments(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearAttachments_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &attachmentCount);
    if (pAttachments) {
        vn_encode_array_size(enc, attachmentCount);
        for (uint32_t i = 0; i < attachmentCount; i++)
            vn_encode_VkClearAttachment(enc, &pAttachments[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &rectCount);
    if (pRects) {
        vn_encode_array_size(enc, rectCount);
        for (uint32_t i = 0; i < rectCount; i++)
            vn_encode_VkClearRect(enc, &pRects[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdClearAttachments_reply(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdClearAttachments_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip attachmentCount */
    /* skip pAttachments */
    /* skip rectCount */
    /* skip pRects */

    return cmd_size;
}

static inline void vn_decode_vkCmdClearAttachments_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdClearAttachments_EXT);

    /* skip commandBuffer */
    /* skip attachmentCount */
    /* skip pAttachments */
    /* skip rectCount */
    /* skip pRects */
}

static inline size_t vn_sizeof_vkCmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResolveImage_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkImage(&srcImage);
    cmd_size += vn_sizeof_VkImageLayout(&srcImageLayout);
    cmd_size += vn_sizeof_VkImage(&dstImage);
    cmd_size += vn_sizeof_VkImageLayout(&dstImageLayout);
    cmd_size += vn_sizeof_uint32_t(&regionCount);
    if (pRegions) {
        cmd_size += vn_sizeof_array_size(regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            cmd_size += vn_sizeof_VkImageResolve(&pRegions[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdResolveImage(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResolveImage_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkImage(enc, &srcImage);
    vn_encode_VkImageLayout(enc, &srcImageLayout);
    vn_encode_VkImage(enc, &dstImage);
    vn_encode_VkImageLayout(enc, &dstImageLayout);
    vn_encode_uint32_t(enc, &regionCount);
    if (pRegions) {
        vn_encode_array_size(enc, regionCount);
        for (uint32_t i = 0; i < regionCount; i++)
            vn_encode_VkImageResolve(enc, &pRegions[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdResolveImage_reply(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResolveImage_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */

    return cmd_size;
}

static inline void vn_decode_vkCmdResolveImage_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdResolveImage_EXT);

    /* skip commandBuffer */
    /* skip srcImage */
    /* skip srcImageLayout */
    /* skip dstImage */
    /* skip dstImageLayout */
    /* skip regionCount */
    /* skip pRegions */
}

static inline size_t vn_sizeof_vkCmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetEvent_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkEvent(&event);
    cmd_size += vn_sizeof_VkFlags(&stageMask);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetEvent(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetEvent_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkEvent(enc, &event);
    vn_encode_VkFlags(enc, &stageMask);
}

static inline size_t vn_sizeof_vkCmdSetEvent_reply(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetEvent_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip event */
    /* skip stageMask */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetEvent_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetEvent_EXT);

    /* skip commandBuffer */
    /* skip event */
    /* skip stageMask */
}

static inline size_t vn_sizeof_vkCmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetEvent_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkEvent(&event);
    cmd_size += vn_sizeof_VkFlags(&stageMask);

    return cmd_size;
}

static inline void vn_encode_vkCmdResetEvent(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetEvent_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkEvent(enc, &event);
    vn_encode_VkFlags(enc, &stageMask);
}

static inline size_t vn_sizeof_vkCmdResetEvent_reply(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetEvent_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip event */
    /* skip stageMask */

    return cmd_size;
}

static inline void vn_decode_vkCmdResetEvent_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdResetEvent_EXT);

    /* skip commandBuffer */
    /* skip event */
    /* skip stageMask */
}

static inline size_t vn_sizeof_vkCmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWaitEvents_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&eventCount);
    if (pEvents) {
        cmd_size += vn_sizeof_array_size(eventCount);
        for (uint32_t i = 0; i < eventCount; i++)
            cmd_size += vn_sizeof_VkEvent(&pEvents[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_VkFlags(&srcStageMask);
    cmd_size += vn_sizeof_VkFlags(&dstStageMask);
    cmd_size += vn_sizeof_uint32_t(&memoryBarrierCount);
    if (pMemoryBarriers) {
        cmd_size += vn_sizeof_array_size(memoryBarrierCount);
        for (uint32_t i = 0; i < memoryBarrierCount; i++)
            cmd_size += vn_sizeof_VkMemoryBarrier(&pMemoryBarriers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&bufferMemoryBarrierCount);
    if (pBufferMemoryBarriers) {
        cmd_size += vn_sizeof_array_size(bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; i++)
            cmd_size += vn_sizeof_VkBufferMemoryBarrier(&pBufferMemoryBarriers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&imageMemoryBarrierCount);
    if (pImageMemoryBarriers) {
        cmd_size += vn_sizeof_array_size(imageMemoryBarrierCount);
        for (uint32_t i = 0; i < imageMemoryBarrierCount; i++)
            cmd_size += vn_sizeof_VkImageMemoryBarrier(&pImageMemoryBarriers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdWaitEvents(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWaitEvents_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &eventCount);
    if (pEvents) {
        vn_encode_array_size(enc, eventCount);
        for (uint32_t i = 0; i < eventCount; i++)
            vn_encode_VkEvent(enc, &pEvents[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_VkFlags(enc, &srcStageMask);
    vn_encode_VkFlags(enc, &dstStageMask);
    vn_encode_uint32_t(enc, &memoryBarrierCount);
    if (pMemoryBarriers) {
        vn_encode_array_size(enc, memoryBarrierCount);
        for (uint32_t i = 0; i < memoryBarrierCount; i++)
            vn_encode_VkMemoryBarrier(enc, &pMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &bufferMemoryBarrierCount);
    if (pBufferMemoryBarriers) {
        vn_encode_array_size(enc, bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; i++)
            vn_encode_VkBufferMemoryBarrier(enc, &pBufferMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &imageMemoryBarrierCount);
    if (pImageMemoryBarriers) {
        vn_encode_array_size(enc, imageMemoryBarrierCount);
        for (uint32_t i = 0; i < imageMemoryBarrierCount; i++)
            vn_encode_VkImageMemoryBarrier(enc, &pImageMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdWaitEvents_reply(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWaitEvents_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip eventCount */
    /* skip pEvents */
    /* skip srcStageMask */
    /* skip dstStageMask */
    /* skip memoryBarrierCount */
    /* skip pMemoryBarriers */
    /* skip bufferMemoryBarrierCount */
    /* skip pBufferMemoryBarriers */
    /* skip imageMemoryBarrierCount */
    /* skip pImageMemoryBarriers */

    return cmd_size;
}

static inline void vn_decode_vkCmdWaitEvents_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdWaitEvents_EXT);

    /* skip commandBuffer */
    /* skip eventCount */
    /* skip pEvents */
    /* skip srcStageMask */
    /* skip dstStageMask */
    /* skip memoryBarrierCount */
    /* skip pMemoryBarriers */
    /* skip bufferMemoryBarrierCount */
    /* skip pBufferMemoryBarriers */
    /* skip imageMemoryBarrierCount */
    /* skip pImageMemoryBarriers */
}

static inline size_t vn_sizeof_vkCmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPipelineBarrier_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkFlags(&srcStageMask);
    cmd_size += vn_sizeof_VkFlags(&dstStageMask);
    cmd_size += vn_sizeof_VkFlags(&dependencyFlags);
    cmd_size += vn_sizeof_uint32_t(&memoryBarrierCount);
    if (pMemoryBarriers) {
        cmd_size += vn_sizeof_array_size(memoryBarrierCount);
        for (uint32_t i = 0; i < memoryBarrierCount; i++)
            cmd_size += vn_sizeof_VkMemoryBarrier(&pMemoryBarriers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&bufferMemoryBarrierCount);
    if (pBufferMemoryBarriers) {
        cmd_size += vn_sizeof_array_size(bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; i++)
            cmd_size += vn_sizeof_VkBufferMemoryBarrier(&pBufferMemoryBarriers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    cmd_size += vn_sizeof_uint32_t(&imageMemoryBarrierCount);
    if (pImageMemoryBarriers) {
        cmd_size += vn_sizeof_array_size(imageMemoryBarrierCount);
        for (uint32_t i = 0; i < imageMemoryBarrierCount; i++)
            cmd_size += vn_sizeof_VkImageMemoryBarrier(&pImageMemoryBarriers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdPipelineBarrier(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPipelineBarrier_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkFlags(enc, &srcStageMask);
    vn_encode_VkFlags(enc, &dstStageMask);
    vn_encode_VkFlags(enc, &dependencyFlags);
    vn_encode_uint32_t(enc, &memoryBarrierCount);
    if (pMemoryBarriers) {
        vn_encode_array_size(enc, memoryBarrierCount);
        for (uint32_t i = 0; i < memoryBarrierCount; i++)
            vn_encode_VkMemoryBarrier(enc, &pMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &bufferMemoryBarrierCount);
    if (pBufferMemoryBarriers) {
        vn_encode_array_size(enc, bufferMemoryBarrierCount);
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; i++)
            vn_encode_VkBufferMemoryBarrier(enc, &pBufferMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &imageMemoryBarrierCount);
    if (pImageMemoryBarriers) {
        vn_encode_array_size(enc, imageMemoryBarrierCount);
        for (uint32_t i = 0; i < imageMemoryBarrierCount; i++)
            vn_encode_VkImageMemoryBarrier(enc, &pImageMemoryBarriers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdPipelineBarrier_reply(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPipelineBarrier_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip srcStageMask */
    /* skip dstStageMask */
    /* skip dependencyFlags */
    /* skip memoryBarrierCount */
    /* skip pMemoryBarriers */
    /* skip bufferMemoryBarrierCount */
    /* skip pBufferMemoryBarriers */
    /* skip imageMemoryBarrierCount */
    /* skip pImageMemoryBarriers */

    return cmd_size;
}

static inline void vn_decode_vkCmdPipelineBarrier_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdPipelineBarrier_EXT);

    /* skip commandBuffer */
    /* skip srcStageMask */
    /* skip dstStageMask */
    /* skip dependencyFlags */
    /* skip memoryBarrierCount */
    /* skip pMemoryBarriers */
    /* skip bufferMemoryBarrierCount */
    /* skip pBufferMemoryBarriers */
    /* skip imageMemoryBarrierCount */
    /* skip pImageMemoryBarriers */
}

static inline size_t vn_sizeof_vkCmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginQuery_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&query);
    cmd_size += vn_sizeof_VkFlags(&flags);

    return cmd_size;
}

static inline void vn_encode_vkCmdBeginQuery(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginQuery_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &query);
    vn_encode_VkFlags(enc, &flags);
}

static inline size_t vn_sizeof_vkCmdBeginQuery_reply(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginQuery_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
    /* skip flags */

    return cmd_size;
}

static inline void vn_decode_vkCmdBeginQuery_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBeginQuery_EXT);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
    /* skip flags */
}

static inline size_t vn_sizeof_vkCmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndQuery_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&query);

    return cmd_size;
}

static inline void vn_encode_vkCmdEndQuery(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndQuery_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &query);
}

static inline size_t vn_sizeof_vkCmdEndQuery_reply(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndQuery_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */

    return cmd_size;
}

static inline void vn_decode_vkCmdEndQuery_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdEndQuery_EXT);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
}

static inline size_t vn_sizeof_vkCmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetQueryPool_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&firstQuery);
    cmd_size += vn_sizeof_uint32_t(&queryCount);

    return cmd_size;
}

static inline void vn_encode_vkCmdResetQueryPool(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetQueryPool_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &firstQuery);
    vn_encode_uint32_t(enc, &queryCount);
}

static inline size_t vn_sizeof_vkCmdResetQueryPool_reply(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdResetQueryPool_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip firstQuery */
    /* skip queryCount */

    return cmd_size;
}

static inline void vn_decode_vkCmdResetQueryPool_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdResetQueryPool_EXT);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip firstQuery */
    /* skip queryCount */
}

static inline size_t vn_sizeof_vkCmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWriteTimestamp_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkPipelineStageFlagBits(&pipelineStage);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&query);

    return cmd_size;
}

static inline void vn_encode_vkCmdWriteTimestamp(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWriteTimestamp_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkPipelineStageFlagBits(enc, &pipelineStage);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &query);
}

static inline size_t vn_sizeof_vkCmdWriteTimestamp_reply(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdWriteTimestamp_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pipelineStage */
    /* skip queryPool */
    /* skip query */

    return cmd_size;
}

static inline void vn_decode_vkCmdWriteTimestamp_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdWriteTimestamp_EXT);

    /* skip commandBuffer */
    /* skip pipelineStage */
    /* skip queryPool */
    /* skip query */
}

static inline size_t vn_sizeof_vkCmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyQueryPoolResults_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&firstQuery);
    cmd_size += vn_sizeof_uint32_t(&queryCount);
    cmd_size += vn_sizeof_VkBuffer(&dstBuffer);
    cmd_size += vn_sizeof_VkDeviceSize(&dstOffset);
    cmd_size += vn_sizeof_VkDeviceSize(&stride);
    cmd_size += vn_sizeof_VkFlags(&flags);

    return cmd_size;
}

static inline void vn_encode_vkCmdCopyQueryPoolResults(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyQueryPoolResults_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &firstQuery);
    vn_encode_uint32_t(enc, &queryCount);
    vn_encode_VkBuffer(enc, &dstBuffer);
    vn_encode_VkDeviceSize(enc, &dstOffset);
    vn_encode_VkDeviceSize(enc, &stride);
    vn_encode_VkFlags(enc, &flags);
}

static inline size_t vn_sizeof_vkCmdCopyQueryPoolResults_reply(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdCopyQueryPoolResults_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip firstQuery */
    /* skip queryCount */
    /* skip dstBuffer */
    /* skip dstOffset */
    /* skip stride */
    /* skip flags */

    return cmd_size;
}

static inline void vn_decode_vkCmdCopyQueryPoolResults_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdCopyQueryPoolResults_EXT);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip firstQuery */
    /* skip queryCount */
    /* skip dstBuffer */
    /* skip dstOffset */
    /* skip stride */
    /* skip flags */
}

static inline size_t vn_sizeof_vkCmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushConstants_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkPipelineLayout(&layout);
    cmd_size += vn_sizeof_VkFlags(&stageFlags);
    cmd_size += vn_sizeof_uint32_t(&offset);
    cmd_size += vn_sizeof_uint32_t(&size);
    if (pValues) {
        cmd_size += vn_sizeof_array_size(size);
        cmd_size += vn_sizeof_blob_array(pValues, size);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdPushConstants(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushConstants_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkPipelineLayout(enc, &layout);
    vn_encode_VkFlags(enc, &stageFlags);
    vn_encode_uint32_t(enc, &offset);
    vn_encode_uint32_t(enc, &size);
    if (pValues) {
        vn_encode_array_size(enc, size);
        vn_encode_blob_array(enc, pValues, size);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdPushConstants_reply(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdPushConstants_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip layout */
    /* skip stageFlags */
    /* skip offset */
    /* skip size */
    /* skip pValues */

    return cmd_size;
}

static inline void vn_decode_vkCmdPushConstants_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdPushConstants_EXT);

    /* skip commandBuffer */
    /* skip layout */
    /* skip stageFlags */
    /* skip offset */
    /* skip size */
    /* skip pValues */
}

static inline size_t vn_sizeof_vkCmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRenderPass_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pRenderPassBegin);
    if (pRenderPassBegin)
        cmd_size += vn_sizeof_VkRenderPassBeginInfo(pRenderPassBegin);
    cmd_size += vn_sizeof_VkSubpassContents(&contents);

    return cmd_size;
}

static inline void vn_encode_vkCmdBeginRenderPass(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRenderPass_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pRenderPassBegin))
        vn_encode_VkRenderPassBeginInfo(enc, pRenderPassBegin);
    vn_encode_VkSubpassContents(enc, &contents);
}

static inline size_t vn_sizeof_vkCmdBeginRenderPass_reply(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRenderPass_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pRenderPassBegin */
    /* skip contents */

    return cmd_size;
}

static inline void vn_decode_vkCmdBeginRenderPass_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBeginRenderPass_EXT);

    /* skip commandBuffer */
    /* skip pRenderPassBegin */
    /* skip contents */
}

static inline size_t vn_sizeof_vkCmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdNextSubpass_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkSubpassContents(&contents);

    return cmd_size;
}

static inline void vn_encode_vkCmdNextSubpass(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdNextSubpass_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkSubpassContents(enc, &contents);
}

static inline size_t vn_sizeof_vkCmdNextSubpass_reply(VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdNextSubpass_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip contents */

    return cmd_size;
}

static inline void vn_decode_vkCmdNextSubpass_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdNextSubpass_EXT);

    /* skip commandBuffer */
    /* skip contents */
}

static inline size_t vn_sizeof_vkCmdEndRenderPass(VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRenderPass_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);

    return cmd_size;
}

static inline void vn_encode_vkCmdEndRenderPass(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRenderPass_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
}

static inline size_t vn_sizeof_vkCmdEndRenderPass_reply(VkCommandBuffer commandBuffer)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRenderPass_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */

    return cmd_size;
}

static inline void vn_decode_vkCmdEndRenderPass_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdEndRenderPass_EXT);

    /* skip commandBuffer */
}

static inline size_t vn_sizeof_vkCmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdExecuteCommands_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&commandBufferCount);
    if (pCommandBuffers) {
        cmd_size += vn_sizeof_array_size(commandBufferCount);
        for (uint32_t i = 0; i < commandBufferCount; i++)
            cmd_size += vn_sizeof_VkCommandBuffer(&pCommandBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdExecuteCommands(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdExecuteCommands_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &commandBufferCount);
    if (pCommandBuffers) {
        vn_encode_array_size(enc, commandBufferCount);
        for (uint32_t i = 0; i < commandBufferCount; i++)
            vn_encode_VkCommandBuffer(enc, &pCommandBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdExecuteCommands_reply(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdExecuteCommands_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip commandBufferCount */
    /* skip pCommandBuffers */

    return cmd_size;
}

static inline void vn_decode_vkCmdExecuteCommands_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdExecuteCommands_EXT);

    /* skip commandBuffer */
    /* skip commandBufferCount */
    /* skip pCommandBuffers */
}

static inline size_t vn_sizeof_vkCmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDeviceMask_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&deviceMask);

    return cmd_size;
}

static inline void vn_encode_vkCmdSetDeviceMask(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDeviceMask_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &deviceMask);
}

static inline size_t vn_sizeof_vkCmdSetDeviceMask_reply(VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdSetDeviceMask_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip deviceMask */

    return cmd_size;
}

static inline void vn_decode_vkCmdSetDeviceMask_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdSetDeviceMask_EXT);

    /* skip commandBuffer */
    /* skip deviceMask */
}

static inline size_t vn_sizeof_vkCmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatchBase_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&baseGroupX);
    cmd_size += vn_sizeof_uint32_t(&baseGroupY);
    cmd_size += vn_sizeof_uint32_t(&baseGroupZ);
    cmd_size += vn_sizeof_uint32_t(&groupCountX);
    cmd_size += vn_sizeof_uint32_t(&groupCountY);
    cmd_size += vn_sizeof_uint32_t(&groupCountZ);

    return cmd_size;
}

static inline void vn_encode_vkCmdDispatchBase(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatchBase_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &baseGroupX);
    vn_encode_uint32_t(enc, &baseGroupY);
    vn_encode_uint32_t(enc, &baseGroupZ);
    vn_encode_uint32_t(enc, &groupCountX);
    vn_encode_uint32_t(enc, &groupCountY);
    vn_encode_uint32_t(enc, &groupCountZ);
}

static inline size_t vn_sizeof_vkCmdDispatchBase_reply(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDispatchBase_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip baseGroupX */
    /* skip baseGroupY */
    /* skip baseGroupZ */
    /* skip groupCountX */
    /* skip groupCountY */
    /* skip groupCountZ */

    return cmd_size;
}

static inline void vn_decode_vkCmdDispatchBase_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDispatchBase_EXT);

    /* skip commandBuffer */
    /* skip baseGroupX */
    /* skip baseGroupY */
    /* skip baseGroupZ */
    /* skip groupCountX */
    /* skip groupCountY */
    /* skip groupCountZ */
}

static inline size_t vn_sizeof_vkCmdBeginRenderPass2(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRenderPass2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pRenderPassBegin);
    if (pRenderPassBegin)
        cmd_size += vn_sizeof_VkRenderPassBeginInfo(pRenderPassBegin);
    cmd_size += vn_sizeof_simple_pointer(pSubpassBeginInfo);
    if (pSubpassBeginInfo)
        cmd_size += vn_sizeof_VkSubpassBeginInfo(pSubpassBeginInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdBeginRenderPass2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRenderPass2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pRenderPassBegin))
        vn_encode_VkRenderPassBeginInfo(enc, pRenderPassBegin);
    if (vn_encode_simple_pointer(enc, pSubpassBeginInfo))
        vn_encode_VkSubpassBeginInfo(enc, pSubpassBeginInfo);
}

static inline size_t vn_sizeof_vkCmdBeginRenderPass2_reply(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginRenderPass2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pRenderPassBegin */
    /* skip pSubpassBeginInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdBeginRenderPass2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBeginRenderPass2_EXT);

    /* skip commandBuffer */
    /* skip pRenderPassBegin */
    /* skip pSubpassBeginInfo */
}

static inline size_t vn_sizeof_vkCmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdNextSubpass2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pSubpassBeginInfo);
    if (pSubpassBeginInfo)
        cmd_size += vn_sizeof_VkSubpassBeginInfo(pSubpassBeginInfo);
    cmd_size += vn_sizeof_simple_pointer(pSubpassEndInfo);
    if (pSubpassEndInfo)
        cmd_size += vn_sizeof_VkSubpassEndInfo(pSubpassEndInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdNextSubpass2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdNextSubpass2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pSubpassBeginInfo))
        vn_encode_VkSubpassBeginInfo(enc, pSubpassBeginInfo);
    if (vn_encode_simple_pointer(enc, pSubpassEndInfo))
        vn_encode_VkSubpassEndInfo(enc, pSubpassEndInfo);
}

static inline size_t vn_sizeof_vkCmdNextSubpass2_reply(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdNextSubpass2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pSubpassBeginInfo */
    /* skip pSubpassEndInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdNextSubpass2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdNextSubpass2_EXT);

    /* skip commandBuffer */
    /* skip pSubpassBeginInfo */
    /* skip pSubpassEndInfo */
}

static inline size_t vn_sizeof_vkCmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRenderPass2_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_simple_pointer(pSubpassEndInfo);
    if (pSubpassEndInfo)
        cmd_size += vn_sizeof_VkSubpassEndInfo(pSubpassEndInfo);

    return cmd_size;
}

static inline void vn_encode_vkCmdEndRenderPass2(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRenderPass2_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    if (vn_encode_simple_pointer(enc, pSubpassEndInfo))
        vn_encode_VkSubpassEndInfo(enc, pSubpassEndInfo);
}

static inline size_t vn_sizeof_vkCmdEndRenderPass2_reply(VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndRenderPass2_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip pSubpassEndInfo */

    return cmd_size;
}

static inline void vn_decode_vkCmdEndRenderPass2_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdEndRenderPass2_EXT);

    /* skip commandBuffer */
    /* skip pSubpassEndInfo */
}

static inline size_t vn_sizeof_vkCmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirectCount_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceSize(&offset);
    cmd_size += vn_sizeof_VkBuffer(&countBuffer);
    cmd_size += vn_sizeof_VkDeviceSize(&countBufferOffset);
    cmd_size += vn_sizeof_uint32_t(&maxDrawCount);
    cmd_size += vn_sizeof_uint32_t(&stride);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawIndirectCount(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirectCount_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceSize(enc, &offset);
    vn_encode_VkBuffer(enc, &countBuffer);
    vn_encode_VkDeviceSize(enc, &countBufferOffset);
    vn_encode_uint32_t(enc, &maxDrawCount);
    vn_encode_uint32_t(enc, &stride);
}

static inline size_t vn_sizeof_vkCmdDrawIndirectCount_reply(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirectCount_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip countBuffer */
    /* skip countBufferOffset */
    /* skip maxDrawCount */
    /* skip stride */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawIndirectCount_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawIndirectCount_EXT);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip countBuffer */
    /* skip countBufferOffset */
    /* skip maxDrawCount */
    /* skip stride */
}

static inline size_t vn_sizeof_vkCmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexedIndirectCount_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkBuffer(&buffer);
    cmd_size += vn_sizeof_VkDeviceSize(&offset);
    cmd_size += vn_sizeof_VkBuffer(&countBuffer);
    cmd_size += vn_sizeof_VkDeviceSize(&countBufferOffset);
    cmd_size += vn_sizeof_uint32_t(&maxDrawCount);
    cmd_size += vn_sizeof_uint32_t(&stride);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawIndexedIndirectCount(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexedIndirectCount_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkBuffer(enc, &buffer);
    vn_encode_VkDeviceSize(enc, &offset);
    vn_encode_VkBuffer(enc, &countBuffer);
    vn_encode_VkDeviceSize(enc, &countBufferOffset);
    vn_encode_uint32_t(enc, &maxDrawCount);
    vn_encode_uint32_t(enc, &stride);
}

static inline size_t vn_sizeof_vkCmdDrawIndexedIndirectCount_reply(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndexedIndirectCount_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip countBuffer */
    /* skip countBufferOffset */
    /* skip maxDrawCount */
    /* skip stride */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawIndexedIndirectCount_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawIndexedIndirectCount_EXT);

    /* skip commandBuffer */
    /* skip buffer */
    /* skip offset */
    /* skip countBuffer */
    /* skip countBufferOffset */
    /* skip maxDrawCount */
    /* skip stride */
}

static inline size_t vn_sizeof_vkCmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindTransformFeedbackBuffersEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstBinding);
    cmd_size += vn_sizeof_uint32_t(&bindingCount);
    if (pBuffers) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        for (uint32_t i = 0; i < bindingCount; i++)
            cmd_size += vn_sizeof_VkBuffer(&pBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pOffsets) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        cmd_size += vn_sizeof_VkDeviceSize_array(pOffsets, bindingCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pSizes) {
        cmd_size += vn_sizeof_array_size(bindingCount);
        cmd_size += vn_sizeof_VkDeviceSize_array(pSizes, bindingCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdBindTransformFeedbackBuffersEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindTransformFeedbackBuffersEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstBinding);
    vn_encode_uint32_t(enc, &bindingCount);
    if (pBuffers) {
        vn_encode_array_size(enc, bindingCount);
        for (uint32_t i = 0; i < bindingCount; i++)
            vn_encode_VkBuffer(enc, &pBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pOffsets) {
        vn_encode_array_size(enc, bindingCount);
        vn_encode_VkDeviceSize_array(enc, pOffsets, bindingCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pSizes) {
        vn_encode_array_size(enc, bindingCount);
        vn_encode_VkDeviceSize_array(enc, pSizes, bindingCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdBindTransformFeedbackBuffersEXT_reply(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBindTransformFeedbackBuffersEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstBinding */
    /* skip bindingCount */
    /* skip pBuffers */
    /* skip pOffsets */
    /* skip pSizes */

    return cmd_size;
}

static inline void vn_decode_vkCmdBindTransformFeedbackBuffersEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBindTransformFeedbackBuffersEXT_EXT);

    /* skip commandBuffer */
    /* skip firstBinding */
    /* skip bindingCount */
    /* skip pBuffers */
    /* skip pOffsets */
    /* skip pSizes */
}

static inline size_t vn_sizeof_vkCmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginTransformFeedbackEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstCounterBuffer);
    cmd_size += vn_sizeof_uint32_t(&counterBufferCount);
    if (pCounterBuffers) {
        cmd_size += vn_sizeof_array_size(counterBufferCount);
        for (uint32_t i = 0; i < counterBufferCount; i++)
            cmd_size += vn_sizeof_VkBuffer(&pCounterBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pCounterBufferOffsets) {
        cmd_size += vn_sizeof_array_size(counterBufferCount);
        cmd_size += vn_sizeof_VkDeviceSize_array(pCounterBufferOffsets, counterBufferCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdBeginTransformFeedbackEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginTransformFeedbackEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstCounterBuffer);
    vn_encode_uint32_t(enc, &counterBufferCount);
    if (pCounterBuffers) {
        vn_encode_array_size(enc, counterBufferCount);
        for (uint32_t i = 0; i < counterBufferCount; i++)
            vn_encode_VkBuffer(enc, &pCounterBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pCounterBufferOffsets) {
        vn_encode_array_size(enc, counterBufferCount);
        vn_encode_VkDeviceSize_array(enc, pCounterBufferOffsets, counterBufferCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdBeginTransformFeedbackEXT_reply(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginTransformFeedbackEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstCounterBuffer */
    /* skip counterBufferCount */
    /* skip pCounterBuffers */
    /* skip pCounterBufferOffsets */

    return cmd_size;
}

static inline void vn_decode_vkCmdBeginTransformFeedbackEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBeginTransformFeedbackEXT_EXT);

    /* skip commandBuffer */
    /* skip firstCounterBuffer */
    /* skip counterBufferCount */
    /* skip pCounterBuffers */
    /* skip pCounterBufferOffsets */
}

static inline size_t vn_sizeof_vkCmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndTransformFeedbackEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&firstCounterBuffer);
    cmd_size += vn_sizeof_uint32_t(&counterBufferCount);
    if (pCounterBuffers) {
        cmd_size += vn_sizeof_array_size(counterBufferCount);
        for (uint32_t i = 0; i < counterBufferCount; i++)
            cmd_size += vn_sizeof_VkBuffer(&pCounterBuffers[i]);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }
    if (pCounterBufferOffsets) {
        cmd_size += vn_sizeof_array_size(counterBufferCount);
        cmd_size += vn_sizeof_VkDeviceSize_array(pCounterBufferOffsets, counterBufferCount);
    } else {
        cmd_size += vn_sizeof_array_size(0);
    }

    return cmd_size;
}

static inline void vn_encode_vkCmdEndTransformFeedbackEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndTransformFeedbackEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &firstCounterBuffer);
    vn_encode_uint32_t(enc, &counterBufferCount);
    if (pCounterBuffers) {
        vn_encode_array_size(enc, counterBufferCount);
        for (uint32_t i = 0; i < counterBufferCount; i++)
            vn_encode_VkBuffer(enc, &pCounterBuffers[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (pCounterBufferOffsets) {
        vn_encode_array_size(enc, counterBufferCount);
        vn_encode_VkDeviceSize_array(enc, pCounterBufferOffsets, counterBufferCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline size_t vn_sizeof_vkCmdEndTransformFeedbackEXT_reply(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndTransformFeedbackEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip firstCounterBuffer */
    /* skip counterBufferCount */
    /* skip pCounterBuffers */
    /* skip pCounterBufferOffsets */

    return cmd_size;
}

static inline void vn_decode_vkCmdEndTransformFeedbackEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdEndTransformFeedbackEXT_EXT);

    /* skip commandBuffer */
    /* skip firstCounterBuffer */
    /* skip counterBufferCount */
    /* skip pCounterBuffers */
    /* skip pCounterBufferOffsets */
}

static inline size_t vn_sizeof_vkCmdBeginQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginQueryIndexedEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&query);
    cmd_size += vn_sizeof_VkFlags(&flags);
    cmd_size += vn_sizeof_uint32_t(&index);

    return cmd_size;
}

static inline void vn_encode_vkCmdBeginQueryIndexedEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginQueryIndexedEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &query);
    vn_encode_VkFlags(enc, &flags);
    vn_encode_uint32_t(enc, &index);
}

static inline size_t vn_sizeof_vkCmdBeginQueryIndexedEXT_reply(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdBeginQueryIndexedEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
    /* skip flags */
    /* skip index */

    return cmd_size;
}

static inline void vn_decode_vkCmdBeginQueryIndexedEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdBeginQueryIndexedEXT_EXT);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
    /* skip flags */
    /* skip index */
}

static inline size_t vn_sizeof_vkCmdEndQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndQueryIndexedEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_VkQueryPool(&queryPool);
    cmd_size += vn_sizeof_uint32_t(&query);
    cmd_size += vn_sizeof_uint32_t(&index);

    return cmd_size;
}

static inline void vn_encode_vkCmdEndQueryIndexedEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndQueryIndexedEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_VkQueryPool(enc, &queryPool);
    vn_encode_uint32_t(enc, &query);
    vn_encode_uint32_t(enc, &index);
}

static inline size_t vn_sizeof_vkCmdEndQueryIndexedEXT_reply(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdEndQueryIndexedEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
    /* skip index */

    return cmd_size;
}

static inline void vn_decode_vkCmdEndQueryIndexedEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdEndQueryIndexedEXT_EXT);

    /* skip commandBuffer */
    /* skip queryPool */
    /* skip query */
    /* skip index */
}

static inline size_t vn_sizeof_vkCmdDrawIndirectByteCountEXT(VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirectByteCountEXT_EXT;
    const VkFlags cmd_flags = 0;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type) + vn_sizeof_VkFlags(&cmd_flags);

    cmd_size += vn_sizeof_VkCommandBuffer(&commandBuffer);
    cmd_size += vn_sizeof_uint32_t(&instanceCount);
    cmd_size += vn_sizeof_uint32_t(&firstInstance);
    cmd_size += vn_sizeof_VkBuffer(&counterBuffer);
    cmd_size += vn_sizeof_VkDeviceSize(&counterBufferOffset);
    cmd_size += vn_sizeof_uint32_t(&counterOffset);
    cmd_size += vn_sizeof_uint32_t(&vertexStride);

    return cmd_size;
}

static inline void vn_encode_vkCmdDrawIndirectByteCountEXT(struct vn_cs_encoder *enc, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirectByteCountEXT_EXT;

    vn_encode_VkCommandTypeEXT(enc, &cmd_type);
    vn_encode_VkFlags(enc, &cmd_flags);

    vn_encode_VkCommandBuffer(enc, &commandBuffer);
    vn_encode_uint32_t(enc, &instanceCount);
    vn_encode_uint32_t(enc, &firstInstance);
    vn_encode_VkBuffer(enc, &counterBuffer);
    vn_encode_VkDeviceSize(enc, &counterBufferOffset);
    vn_encode_uint32_t(enc, &counterOffset);
    vn_encode_uint32_t(enc, &vertexStride);
}

static inline size_t vn_sizeof_vkCmdDrawIndirectByteCountEXT_reply(VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride)
{
    const VkCommandTypeEXT cmd_type = VK_COMMAND_TYPE_vkCmdDrawIndirectByteCountEXT_EXT;
    size_t cmd_size = vn_sizeof_VkCommandTypeEXT(&cmd_type);

    /* skip commandBuffer */
    /* skip instanceCount */
    /* skip firstInstance */
    /* skip counterBuffer */
    /* skip counterBufferOffset */
    /* skip counterOffset */
    /* skip vertexStride */

    return cmd_size;
}

static inline void vn_decode_vkCmdDrawIndirectByteCountEXT_reply(struct vn_cs_decoder *dec, VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride)
{
    VkCommandTypeEXT command_type;
    vn_decode_VkCommandTypeEXT(dec, &command_type);
    assert(command_type == VK_COMMAND_TYPE_vkCmdDrawIndirectByteCountEXT_EXT);

    /* skip commandBuffer */
    /* skip instanceCount */
    /* skip firstInstance */
    /* skip counterBuffer */
    /* skip counterBufferOffset */
    /* skip counterOffset */
    /* skip vertexStride */
}

static inline void vn_submit_vkAllocateCommandBuffers(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkAllocateCommandBuffers(device, pAllocateInfo, pCommandBuffers);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkAllocateCommandBuffers(&submit->command, cmd_flags, device, pAllocateInfo, pCommandBuffers);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkAllocateCommandBuffers_reply(device, pAllocateInfo, pCommandBuffers) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkFreeCommandBuffers(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkFreeCommandBuffers(device, commandPool, commandBufferCount, pCommandBuffers);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkFreeCommandBuffers(&submit->command, cmd_flags, device, commandPool, commandBufferCount, pCommandBuffers);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkFreeCommandBuffers_reply(device, commandPool, commandBufferCount, pCommandBuffers) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkBeginCommandBuffer(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkBeginCommandBuffer(commandBuffer, pBeginInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkBeginCommandBuffer(&submit->command, cmd_flags, commandBuffer, pBeginInfo);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkBeginCommandBuffer_reply(commandBuffer, pBeginInfo) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkEndCommandBuffer(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkEndCommandBuffer(commandBuffer);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkEndCommandBuffer(&submit->command, cmd_flags, commandBuffer);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkEndCommandBuffer_reply(commandBuffer) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkResetCommandBuffer(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkResetCommandBuffer(commandBuffer, flags);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkResetCommandBuffer(&submit->command, cmd_flags, commandBuffer, flags);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkResetCommandBuffer_reply(commandBuffer, flags) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdBindPipeline(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBindPipeline(commandBuffer, pipelineBindPoint, pipeline);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdBindPipeline(&submit->command, cmd_flags, commandBuffer, pipelineBindPoint, pipeline);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBindPipeline_reply(commandBuffer, pipelineBindPoint, pipeline) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdSetViewport(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdSetViewport(&submit->command, cmd_flags, commandBuffer, firstViewport, viewportCount, pViewports);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetViewport_reply(commandBuffer, firstViewport, viewportCount, pViewports) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdSetScissor(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdSetScissor(&submit->command, cmd_flags, commandBuffer, firstScissor, scissorCount, pScissors);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetScissor_reply(commandBuffer, firstScissor, scissorCount, pScissors) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdSetLineWidth(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float lineWidth, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetLineWidth(commandBuffer, lineWidth);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdSetLineWidth(&submit->command, cmd_flags, commandBuffer, lineWidth);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetLineWidth_reply(commandBuffer, lineWidth) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdSetDepthBias(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDepthBias(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdSetDepthBias(&submit->command, cmd_flags, commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDepthBias_reply(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdSetBlendConstants(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const float blendConstants[4], struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetBlendConstants(commandBuffer, blendConstants);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdSetBlendConstants(&submit->command, cmd_flags, commandBuffer, blendConstants);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetBlendConstants_reply(commandBuffer, blendConstants) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdSetDepthBounds(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDepthBounds(commandBuffer, minDepthBounds, maxDepthBounds);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdSetDepthBounds(&submit->command, cmd_flags, commandBuffer, minDepthBounds, maxDepthBounds);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDepthBounds_reply(commandBuffer, minDepthBounds, maxDepthBounds) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdSetStencilCompareMask(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetStencilCompareMask(commandBuffer, faceMask, compareMask);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdSetStencilCompareMask(&submit->command, cmd_flags, commandBuffer, faceMask, compareMask);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetStencilCompareMask_reply(commandBuffer, faceMask, compareMask) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdSetStencilWriteMask(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetStencilWriteMask(commandBuffer, faceMask, writeMask);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdSetStencilWriteMask(&submit->command, cmd_flags, commandBuffer, faceMask, writeMask);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetStencilWriteMask_reply(commandBuffer, faceMask, writeMask) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdSetStencilReference(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetStencilReference(commandBuffer, faceMask, reference);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdSetStencilReference(&submit->command, cmd_flags, commandBuffer, faceMask, reference);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetStencilReference_reply(commandBuffer, faceMask, reference) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdBindDescriptorSets(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBindDescriptorSets(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdBindDescriptorSets(&submit->command, cmd_flags, commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBindDescriptorSets_reply(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdBindIndexBuffer(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBindIndexBuffer(commandBuffer, buffer, offset, indexType);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdBindIndexBuffer(&submit->command, cmd_flags, commandBuffer, buffer, offset, indexType);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBindIndexBuffer_reply(commandBuffer, buffer, offset, indexType) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdBindVertexBuffers(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdBindVertexBuffers(&submit->command, cmd_flags, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBindVertexBuffers_reply(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdDraw(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDraw(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdDraw(&submit->command, cmd_flags, commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDraw_reply(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdDrawIndexed(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawIndexed(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdDrawIndexed(&submit->command, cmd_flags, commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawIndexed_reply(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdDrawIndirect(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawIndirect(commandBuffer, buffer, offset, drawCount, stride);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdDrawIndirect(&submit->command, cmd_flags, commandBuffer, buffer, offset, drawCount, stride);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawIndirect_reply(commandBuffer, buffer, offset, drawCount, stride) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdDrawIndexedIndirect(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawIndexedIndirect(commandBuffer, buffer, offset, drawCount, stride);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdDrawIndexedIndirect(&submit->command, cmd_flags, commandBuffer, buffer, offset, drawCount, stride);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawIndexedIndirect_reply(commandBuffer, buffer, offset, drawCount, stride) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdDispatch(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDispatch(commandBuffer, groupCountX, groupCountY, groupCountZ);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdDispatch(&submit->command, cmd_flags, commandBuffer, groupCountX, groupCountY, groupCountZ);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDispatch_reply(commandBuffer, groupCountX, groupCountY, groupCountZ) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdDispatchIndirect(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDispatchIndirect(commandBuffer, buffer, offset);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdDispatchIndirect(&submit->command, cmd_flags, commandBuffer, buffer, offset);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDispatchIndirect_reply(commandBuffer, buffer, offset) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdCopyBuffer(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdCopyBuffer(&submit->command, cmd_flags, commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyBuffer_reply(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdCopyImage(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdCopyImage(&submit->command, cmd_flags, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyImage_reply(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdBlitImage(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBlitImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdBlitImage(&submit->command, cmd_flags, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBlitImage_reply(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdCopyBufferToImage(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyBufferToImage(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdCopyBufferToImage(&submit->command, cmd_flags, commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyBufferToImage_reply(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdCopyImageToBuffer(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyImageToBuffer(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdCopyImageToBuffer(&submit->command, cmd_flags, commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyImageToBuffer_reply(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdUpdateBuffer(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdUpdateBuffer(&submit->command, cmd_flags, commandBuffer, dstBuffer, dstOffset, dataSize, pData);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdUpdateBuffer_reply(commandBuffer, dstBuffer, dstOffset, dataSize, pData) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdFillBuffer(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdFillBuffer(&submit->command, cmd_flags, commandBuffer, dstBuffer, dstOffset, size, data);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdFillBuffer_reply(commandBuffer, dstBuffer, dstOffset, size, data) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdClearColorImage(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdClearColorImage(&submit->command, cmd_flags, commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdClearColorImage_reply(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdClearDepthStencilImage(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdClearDepthStencilImage(commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdClearDepthStencilImage(&submit->command, cmd_flags, commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdClearDepthStencilImage_reply(commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdClearAttachments(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdClearAttachments(&submit->command, cmd_flags, commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdClearAttachments_reply(commandBuffer, attachmentCount, pAttachments, rectCount, pRects) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdResolveImage(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdResolveImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdResolveImage(&submit->command, cmd_flags, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdResolveImage_reply(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdSetEvent(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetEvent(commandBuffer, event, stageMask);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdSetEvent(&submit->command, cmd_flags, commandBuffer, event, stageMask);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetEvent_reply(commandBuffer, event, stageMask) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdResetEvent(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdResetEvent(commandBuffer, event, stageMask);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdResetEvent(&submit->command, cmd_flags, commandBuffer, event, stageMask);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdResetEvent_reply(commandBuffer, event, stageMask) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdWaitEvents(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdWaitEvents(commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdWaitEvents(&submit->command, cmd_flags, commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdWaitEvents_reply(commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdPipelineBarrier(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdPipelineBarrier(commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdPipelineBarrier(&submit->command, cmd_flags, commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdPipelineBarrier_reply(commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdBeginQuery(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBeginQuery(commandBuffer, queryPool, query, flags);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdBeginQuery(&submit->command, cmd_flags, commandBuffer, queryPool, query, flags);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBeginQuery_reply(commandBuffer, queryPool, query, flags) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdEndQuery(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdEndQuery(commandBuffer, queryPool, query);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdEndQuery(&submit->command, cmd_flags, commandBuffer, queryPool, query);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdEndQuery_reply(commandBuffer, queryPool, query) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdResetQueryPool(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdResetQueryPool(commandBuffer, queryPool, firstQuery, queryCount);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdResetQueryPool(&submit->command, cmd_flags, commandBuffer, queryPool, firstQuery, queryCount);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdResetQueryPool_reply(commandBuffer, queryPool, firstQuery, queryCount) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdWriteTimestamp(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdWriteTimestamp(commandBuffer, pipelineStage, queryPool, query);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdWriteTimestamp(&submit->command, cmd_flags, commandBuffer, pipelineStage, queryPool, query);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdWriteTimestamp_reply(commandBuffer, pipelineStage, queryPool, query) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdCopyQueryPoolResults(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdCopyQueryPoolResults(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdCopyQueryPoolResults(&submit->command, cmd_flags, commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdCopyQueryPoolResults_reply(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdPushConstants(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdPushConstants(&submit->command, cmd_flags, commandBuffer, layout, stageFlags, offset, size, pValues);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdPushConstants_reply(commandBuffer, layout, stageFlags, offset, size, pValues) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdBeginRenderPass(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdBeginRenderPass(&submit->command, cmd_flags, commandBuffer, pRenderPassBegin, contents);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBeginRenderPass_reply(commandBuffer, pRenderPassBegin, contents) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdNextSubpass(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkSubpassContents contents, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdNextSubpass(commandBuffer, contents);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdNextSubpass(&submit->command, cmd_flags, commandBuffer, contents);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdNextSubpass_reply(commandBuffer, contents) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdEndRenderPass(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdEndRenderPass(commandBuffer);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdEndRenderPass(&submit->command, cmd_flags, commandBuffer);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdEndRenderPass_reply(commandBuffer) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdExecuteCommands(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdExecuteCommands(commandBuffer, commandBufferCount, pCommandBuffers);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdExecuteCommands(&submit->command, cmd_flags, commandBuffer, commandBufferCount, pCommandBuffers);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdExecuteCommands_reply(commandBuffer, commandBufferCount, pCommandBuffers) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdSetDeviceMask(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t deviceMask, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdSetDeviceMask(commandBuffer, deviceMask);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdSetDeviceMask(&submit->command, cmd_flags, commandBuffer, deviceMask);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdSetDeviceMask_reply(commandBuffer, deviceMask) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdDispatchBase(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDispatchBase(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdDispatchBase(&submit->command, cmd_flags, commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDispatchBase_reply(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdBeginRenderPass2(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdBeginRenderPass2(&submit->command, cmd_flags, commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBeginRenderPass2_reply(commandBuffer, pRenderPassBegin, pSubpassBeginInfo) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdNextSubpass2(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdNextSubpass2(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdNextSubpass2(&submit->command, cmd_flags, commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdNextSubpass2_reply(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdEndRenderPass2(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdEndRenderPass2(commandBuffer, pSubpassEndInfo);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdEndRenderPass2(&submit->command, cmd_flags, commandBuffer, pSubpassEndInfo);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdEndRenderPass2_reply(commandBuffer, pSubpassEndInfo) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdDrawIndirectCount(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdDrawIndirectCount(&submit->command, cmd_flags, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawIndirectCount_reply(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdDrawIndexedIndirectCount(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawIndexedIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdDrawIndexedIndirectCount(&submit->command, cmd_flags, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawIndexedIndirectCount_reply(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdBindTransformFeedbackBuffersEXT(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBindTransformFeedbackBuffersEXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdBindTransformFeedbackBuffersEXT(&submit->command, cmd_flags, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBindTransformFeedbackBuffersEXT_reply(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdBeginTransformFeedbackEXT(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBeginTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdBeginTransformFeedbackEXT(&submit->command, cmd_flags, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBeginTransformFeedbackEXT_reply(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdEndTransformFeedbackEXT(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdEndTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdEndTransformFeedbackEXT(&submit->command, cmd_flags, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdEndTransformFeedbackEXT_reply(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdBeginQueryIndexedEXT(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdBeginQueryIndexedEXT(commandBuffer, queryPool, query, flags, index);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdBeginQueryIndexedEXT(&submit->command, cmd_flags, commandBuffer, queryPool, query, flags, index);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdBeginQueryIndexedEXT_reply(commandBuffer, queryPool, query, flags, index) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdEndQueryIndexedEXT(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdEndQueryIndexedEXT(commandBuffer, queryPool, query, index);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdEndQueryIndexedEXT(&submit->command, cmd_flags, commandBuffer, queryPool, query, index);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdEndQueryIndexedEXT_reply(commandBuffer, queryPool, query, index) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline void vn_submit_vkCmdDrawIndirectByteCountEXT(struct vn_instance *vn_instance, VkCommandFlagsEXT cmd_flags, VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride, struct vn_instance_submit_command *submit)
{
    uint8_t local_cmd_data[VN_SUBMIT_LOCAL_CMD_SIZE];
    void *cmd_data = local_cmd_data;
    size_t cmd_size = vn_sizeof_vkCmdDrawIndirectByteCountEXT(commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride);
    if (cmd_size > sizeof(local_cmd_data)) {
        cmd_data = malloc(cmd_size);
        if (!cmd_data)
            cmd_size = 0;
    }

    submit->command = VN_CS_ENCODER_INITIALIZER(cmd_data, cmd_size);
    if (cmd_size)
        vn_encode_vkCmdDrawIndirectByteCountEXT(&submit->command, cmd_flags, commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride);
    submit->reply_size = cmd_flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT ? vn_sizeof_vkCmdDrawIndirectByteCountEXT_reply(commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride) : 0;
    vn_instance_submit_command(vn_instance, submit);

    if (cmd_data != local_cmd_data)
        free(cmd_data);
}

static inline VkResult vn_call_vkAllocateCommandBuffers(struct vn_instance *vn_instance, VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkAllocateCommandBuffers(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, pAllocateInfo, pCommandBuffers, &submit);
    if (submit.reply_bo) {
        const VkResult ret = vn_decode_vkAllocateCommandBuffers_reply(&submit.reply, device, pAllocateInfo, pCommandBuffers);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkAllocateCommandBuffers(struct vn_instance *vn_instance, VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkAllocateCommandBuffers(vn_instance, 0, device, pAllocateInfo, pCommandBuffers, &submit);
}

static inline void vn_call_vkFreeCommandBuffers(struct vn_instance *vn_instance, VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkFreeCommandBuffers(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, device, commandPool, commandBufferCount, pCommandBuffers, &submit);
    if (submit.reply_bo) {
        vn_decode_vkFreeCommandBuffers_reply(&submit.reply, device, commandPool, commandBufferCount, pCommandBuffers);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkFreeCommandBuffers(struct vn_instance *vn_instance, VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkFreeCommandBuffers(vn_instance, 0, device, commandPool, commandBufferCount, pCommandBuffers, &submit);
}

static inline VkResult vn_call_vkBeginCommandBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkBeginCommandBuffer(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pBeginInfo, &submit);
    if (submit.reply_bo) {
        const VkResult ret = vn_decode_vkBeginCommandBuffer_reply(&submit.reply, commandBuffer, pBeginInfo);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkBeginCommandBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkBeginCommandBuffer(vn_instance, 0, commandBuffer, pBeginInfo, &submit);
}

static inline VkResult vn_call_vkEndCommandBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkEndCommandBuffer(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, &submit);
    if (submit.reply_bo) {
        const VkResult ret = vn_decode_vkEndCommandBuffer_reply(&submit.reply, commandBuffer);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkEndCommandBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkEndCommandBuffer(vn_instance, 0, commandBuffer, &submit);
}

static inline VkResult vn_call_vkResetCommandBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkResetCommandBuffer(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, flags, &submit);
    if (submit.reply_bo) {
        const VkResult ret = vn_decode_vkResetCommandBuffer_reply(&submit.reply, commandBuffer, flags);
        vn_renderer_bo_unref(submit.reply_bo);
        return ret;
    } else {
        return VK_ERROR_OUT_OF_HOST_MEMORY;
    }
}

static inline void vn_async_vkResetCommandBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkResetCommandBuffer(vn_instance, 0, commandBuffer, flags, &submit);
}

static inline void vn_call_vkCmdBindPipeline(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBindPipeline(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pipelineBindPoint, pipeline, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdBindPipeline_reply(&submit.reply, commandBuffer, pipelineBindPoint, pipeline);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdBindPipeline(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBindPipeline(vn_instance, 0, commandBuffer, pipelineBindPoint, pipeline, &submit);
}

static inline void vn_call_vkCmdSetViewport(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetViewport(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstViewport, viewportCount, pViewports, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdSetViewport_reply(&submit.reply, commandBuffer, firstViewport, viewportCount, pViewports);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdSetViewport(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetViewport(vn_instance, 0, commandBuffer, firstViewport, viewportCount, pViewports, &submit);
}

static inline void vn_call_vkCmdSetScissor(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetScissor(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstScissor, scissorCount, pScissors, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdSetScissor_reply(&submit.reply, commandBuffer, firstScissor, scissorCount, pScissors);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdSetScissor(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetScissor(vn_instance, 0, commandBuffer, firstScissor, scissorCount, pScissors, &submit);
}

static inline void vn_call_vkCmdSetLineWidth(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, float lineWidth)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetLineWidth(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, lineWidth, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdSetLineWidth_reply(&submit.reply, commandBuffer, lineWidth);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdSetLineWidth(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, float lineWidth)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetLineWidth(vn_instance, 0, commandBuffer, lineWidth, &submit);
}

static inline void vn_call_vkCmdSetDepthBias(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetDepthBias(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdSetDepthBias_reply(&submit.reply, commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdSetDepthBias(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetDepthBias(vn_instance, 0, commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor, &submit);
}

static inline void vn_call_vkCmdSetBlendConstants(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetBlendConstants(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, blendConstants, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdSetBlendConstants_reply(&submit.reply, commandBuffer, blendConstants);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdSetBlendConstants(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, const float blendConstants[4])
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetBlendConstants(vn_instance, 0, commandBuffer, blendConstants, &submit);
}

static inline void vn_call_vkCmdSetDepthBounds(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetDepthBounds(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, minDepthBounds, maxDepthBounds, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdSetDepthBounds_reply(&submit.reply, commandBuffer, minDepthBounds, maxDepthBounds);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdSetDepthBounds(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetDepthBounds(vn_instance, 0, commandBuffer, minDepthBounds, maxDepthBounds, &submit);
}

static inline void vn_call_vkCmdSetStencilCompareMask(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetStencilCompareMask(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, faceMask, compareMask, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdSetStencilCompareMask_reply(&submit.reply, commandBuffer, faceMask, compareMask);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdSetStencilCompareMask(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetStencilCompareMask(vn_instance, 0, commandBuffer, faceMask, compareMask, &submit);
}

static inline void vn_call_vkCmdSetStencilWriteMask(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetStencilWriteMask(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, faceMask, writeMask, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdSetStencilWriteMask_reply(&submit.reply, commandBuffer, faceMask, writeMask);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdSetStencilWriteMask(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetStencilWriteMask(vn_instance, 0, commandBuffer, faceMask, writeMask, &submit);
}

static inline void vn_call_vkCmdSetStencilReference(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetStencilReference(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, faceMask, reference, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdSetStencilReference_reply(&submit.reply, commandBuffer, faceMask, reference);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdSetStencilReference(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetStencilReference(vn_instance, 0, commandBuffer, faceMask, reference, &submit);
}

static inline void vn_call_vkCmdBindDescriptorSets(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBindDescriptorSets(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdBindDescriptorSets_reply(&submit.reply, commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdBindDescriptorSets(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBindDescriptorSets(vn_instance, 0, commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount, pDescriptorSets, dynamicOffsetCount, pDynamicOffsets, &submit);
}

static inline void vn_call_vkCmdBindIndexBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBindIndexBuffer(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, buffer, offset, indexType, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdBindIndexBuffer_reply(&submit.reply, commandBuffer, buffer, offset, indexType);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdBindIndexBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBindIndexBuffer(vn_instance, 0, commandBuffer, buffer, offset, indexType, &submit);
}

static inline void vn_call_vkCmdBindVertexBuffers(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBindVertexBuffers(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdBindVertexBuffers_reply(&submit.reply, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdBindVertexBuffers(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBindVertexBuffers(vn_instance, 0, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, &submit);
}

static inline void vn_call_vkCmdDraw(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDraw(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdDraw_reply(&submit.reply, commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdDraw(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDraw(vn_instance, 0, commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance, &submit);
}

static inline void vn_call_vkCmdDrawIndexed(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDrawIndexed(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdDrawIndexed_reply(&submit.reply, commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdDrawIndexed(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDrawIndexed(vn_instance, 0, commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance, &submit);
}

static inline void vn_call_vkCmdDrawIndirect(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDrawIndirect(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, buffer, offset, drawCount, stride, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdDrawIndirect_reply(&submit.reply, commandBuffer, buffer, offset, drawCount, stride);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdDrawIndirect(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDrawIndirect(vn_instance, 0, commandBuffer, buffer, offset, drawCount, stride, &submit);
}

static inline void vn_call_vkCmdDrawIndexedIndirect(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDrawIndexedIndirect(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, buffer, offset, drawCount, stride, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdDrawIndexedIndirect_reply(&submit.reply, commandBuffer, buffer, offset, drawCount, stride);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdDrawIndexedIndirect(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDrawIndexedIndirect(vn_instance, 0, commandBuffer, buffer, offset, drawCount, stride, &submit);
}

static inline void vn_call_vkCmdDispatch(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDispatch(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, groupCountX, groupCountY, groupCountZ, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdDispatch_reply(&submit.reply, commandBuffer, groupCountX, groupCountY, groupCountZ);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdDispatch(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDispatch(vn_instance, 0, commandBuffer, groupCountX, groupCountY, groupCountZ, &submit);
}

static inline void vn_call_vkCmdDispatchIndirect(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDispatchIndirect(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, buffer, offset, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdDispatchIndirect_reply(&submit.reply, commandBuffer, buffer, offset);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdDispatchIndirect(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDispatchIndirect(vn_instance, 0, commandBuffer, buffer, offset, &submit);
}

static inline void vn_call_vkCmdCopyBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdCopyBuffer(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdCopyBuffer_reply(&submit.reply, commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdCopyBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdCopyBuffer(vn_instance, 0, commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions, &submit);
}

static inline void vn_call_vkCmdCopyImage(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdCopyImage(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdCopyImage_reply(&submit.reply, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdCopyImage(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdCopyImage(vn_instance, 0, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, &submit);
}

static inline void vn_call_vkCmdBlitImage(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBlitImage(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdBlitImage_reply(&submit.reply, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdBlitImage(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBlitImage(vn_instance, 0, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, filter, &submit);
}

static inline void vn_call_vkCmdCopyBufferToImage(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdCopyBufferToImage(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdCopyBufferToImage_reply(&submit.reply, commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdCopyBufferToImage(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdCopyBufferToImage(vn_instance, 0, commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions, &submit);
}

static inline void vn_call_vkCmdCopyImageToBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdCopyImageToBuffer(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdCopyImageToBuffer_reply(&submit.reply, commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdCopyImageToBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdCopyImageToBuffer(vn_instance, 0, commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions, &submit);
}

static inline void vn_call_vkCmdUpdateBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdUpdateBuffer(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, dstBuffer, dstOffset, dataSize, pData, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdUpdateBuffer_reply(&submit.reply, commandBuffer, dstBuffer, dstOffset, dataSize, pData);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdUpdateBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdUpdateBuffer(vn_instance, 0, commandBuffer, dstBuffer, dstOffset, dataSize, pData, &submit);
}

static inline void vn_call_vkCmdFillBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdFillBuffer(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, dstBuffer, dstOffset, size, data, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdFillBuffer_reply(&submit.reply, commandBuffer, dstBuffer, dstOffset, size, data);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdFillBuffer(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdFillBuffer(vn_instance, 0, commandBuffer, dstBuffer, dstOffset, size, data, &submit);
}

static inline void vn_call_vkCmdClearColorImage(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdClearColorImage(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, image, imageLayout, pColor, rangeCount, pRanges, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdClearColorImage_reply(&submit.reply, commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdClearColorImage(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdClearColorImage(vn_instance, 0, commandBuffer, image, imageLayout, pColor, rangeCount, pRanges, &submit);
}

static inline void vn_call_vkCmdClearDepthStencilImage(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdClearDepthStencilImage(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdClearDepthStencilImage_reply(&submit.reply, commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdClearDepthStencilImage(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdClearDepthStencilImage(vn_instance, 0, commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges, &submit);
}

static inline void vn_call_vkCmdClearAttachments(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdClearAttachments(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, attachmentCount, pAttachments, rectCount, pRects, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdClearAttachments_reply(&submit.reply, commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdClearAttachments(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdClearAttachments(vn_instance, 0, commandBuffer, attachmentCount, pAttachments, rectCount, pRects, &submit);
}

static inline void vn_call_vkCmdResolveImage(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdResolveImage(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdResolveImage_reply(&submit.reply, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdResolveImage(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdResolveImage(vn_instance, 0, commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions, &submit);
}

static inline void vn_call_vkCmdSetEvent(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetEvent(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, event, stageMask, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdSetEvent_reply(&submit.reply, commandBuffer, event, stageMask);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdSetEvent(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetEvent(vn_instance, 0, commandBuffer, event, stageMask, &submit);
}

static inline void vn_call_vkCmdResetEvent(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdResetEvent(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, event, stageMask, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdResetEvent_reply(&submit.reply, commandBuffer, event, stageMask);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdResetEvent(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdResetEvent(vn_instance, 0, commandBuffer, event, stageMask, &submit);
}

static inline void vn_call_vkCmdWaitEvents(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdWaitEvents(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdWaitEvents_reply(&submit.reply, commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdWaitEvents(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdWaitEvents(vn_instance, 0, commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers, &submit);
}

static inline void vn_call_vkCmdPipelineBarrier(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdPipelineBarrier(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdPipelineBarrier_reply(&submit.reply, commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdPipelineBarrier(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdPipelineBarrier(vn_instance, 0, commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers, &submit);
}

static inline void vn_call_vkCmdBeginQuery(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBeginQuery(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, queryPool, query, flags, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdBeginQuery_reply(&submit.reply, commandBuffer, queryPool, query, flags);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdBeginQuery(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBeginQuery(vn_instance, 0, commandBuffer, queryPool, query, flags, &submit);
}

static inline void vn_call_vkCmdEndQuery(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdEndQuery(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, queryPool, query, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdEndQuery_reply(&submit.reply, commandBuffer, queryPool, query);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdEndQuery(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdEndQuery(vn_instance, 0, commandBuffer, queryPool, query, &submit);
}

static inline void vn_call_vkCmdResetQueryPool(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdResetQueryPool(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, queryPool, firstQuery, queryCount, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdResetQueryPool_reply(&submit.reply, commandBuffer, queryPool, firstQuery, queryCount);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdResetQueryPool(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdResetQueryPool(vn_instance, 0, commandBuffer, queryPool, firstQuery, queryCount, &submit);
}

static inline void vn_call_vkCmdWriteTimestamp(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdWriteTimestamp(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pipelineStage, queryPool, query, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdWriteTimestamp_reply(&submit.reply, commandBuffer, pipelineStage, queryPool, query);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdWriteTimestamp(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdWriteTimestamp(vn_instance, 0, commandBuffer, pipelineStage, queryPool, query, &submit);
}

static inline void vn_call_vkCmdCopyQueryPoolResults(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdCopyQueryPoolResults(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdCopyQueryPoolResults_reply(&submit.reply, commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdCopyQueryPoolResults(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdCopyQueryPoolResults(vn_instance, 0, commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride, flags, &submit);
}

static inline void vn_call_vkCmdPushConstants(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdPushConstants(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, layout, stageFlags, offset, size, pValues, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdPushConstants_reply(&submit.reply, commandBuffer, layout, stageFlags, offset, size, pValues);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdPushConstants(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdPushConstants(vn_instance, 0, commandBuffer, layout, stageFlags, offset, size, pValues, &submit);
}

static inline void vn_call_vkCmdBeginRenderPass(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBeginRenderPass(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pRenderPassBegin, contents, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdBeginRenderPass_reply(&submit.reply, commandBuffer, pRenderPassBegin, contents);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdBeginRenderPass(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBeginRenderPass(vn_instance, 0, commandBuffer, pRenderPassBegin, contents, &submit);
}

static inline void vn_call_vkCmdNextSubpass(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdNextSubpass(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, contents, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdNextSubpass_reply(&submit.reply, commandBuffer, contents);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdNextSubpass(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkSubpassContents contents)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdNextSubpass(vn_instance, 0, commandBuffer, contents, &submit);
}

static inline void vn_call_vkCmdEndRenderPass(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdEndRenderPass(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdEndRenderPass_reply(&submit.reply, commandBuffer);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdEndRenderPass(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdEndRenderPass(vn_instance, 0, commandBuffer, &submit);
}

static inline void vn_call_vkCmdExecuteCommands(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdExecuteCommands(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, commandBufferCount, pCommandBuffers, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdExecuteCommands_reply(&submit.reply, commandBuffer, commandBufferCount, pCommandBuffers);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdExecuteCommands(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdExecuteCommands(vn_instance, 0, commandBuffer, commandBufferCount, pCommandBuffers, &submit);
}

static inline void vn_call_vkCmdSetDeviceMask(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetDeviceMask(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, deviceMask, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdSetDeviceMask_reply(&submit.reply, commandBuffer, deviceMask);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdSetDeviceMask(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t deviceMask)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdSetDeviceMask(vn_instance, 0, commandBuffer, deviceMask, &submit);
}

static inline void vn_call_vkCmdDispatchBase(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDispatchBase(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdDispatchBase_reply(&submit.reply, commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdDispatchBase(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDispatchBase(vn_instance, 0, commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ, &submit);
}

static inline void vn_call_vkCmdBeginRenderPass2(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBeginRenderPass2(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pRenderPassBegin, pSubpassBeginInfo, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdBeginRenderPass2_reply(&submit.reply, commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdBeginRenderPass2(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, const VkSubpassBeginInfo* pSubpassBeginInfo)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBeginRenderPass2(vn_instance, 0, commandBuffer, pRenderPassBegin, pSubpassBeginInfo, &submit);
}

static inline void vn_call_vkCmdNextSubpass2(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdNextSubpass2(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdNextSubpass2_reply(&submit.reply, commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdNextSubpass2(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo, const VkSubpassEndInfo* pSubpassEndInfo)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdNextSubpass2(vn_instance, 0, commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, &submit);
}

static inline void vn_call_vkCmdEndRenderPass2(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdEndRenderPass2(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, pSubpassEndInfo, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdEndRenderPass2_reply(&submit.reply, commandBuffer, pSubpassEndInfo);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdEndRenderPass2(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdEndRenderPass2(vn_instance, 0, commandBuffer, pSubpassEndInfo, &submit);
}

static inline void vn_call_vkCmdDrawIndirectCount(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDrawIndirectCount(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdDrawIndirectCount_reply(&submit.reply, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdDrawIndirectCount(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDrawIndirectCount(vn_instance, 0, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride, &submit);
}

static inline void vn_call_vkCmdDrawIndexedIndirectCount(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDrawIndexedIndirectCount(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdDrawIndexedIndirectCount_reply(&submit.reply, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdDrawIndexedIndirectCount(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDrawIndexedIndirectCount(vn_instance, 0, commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride, &submit);
}

static inline void vn_call_vkCmdBindTransformFeedbackBuffersEXT(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBindTransformFeedbackBuffersEXT(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdBindTransformFeedbackBuffersEXT_reply(&submit.reply, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdBindTransformFeedbackBuffersEXT(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBindTransformFeedbackBuffersEXT(vn_instance, 0, commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, &submit);
}

static inline void vn_call_vkCmdBeginTransformFeedbackEXT(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBeginTransformFeedbackEXT(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdBeginTransformFeedbackEXT_reply(&submit.reply, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdBeginTransformFeedbackEXT(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBeginTransformFeedbackEXT(vn_instance, 0, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets, &submit);
}

static inline void vn_call_vkCmdEndTransformFeedbackEXT(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdEndTransformFeedbackEXT(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdEndTransformFeedbackEXT_reply(&submit.reply, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdEndTransformFeedbackEXT(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdEndTransformFeedbackEXT(vn_instance, 0, commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers, pCounterBufferOffsets, &submit);
}

static inline void vn_call_vkCmdBeginQueryIndexedEXT(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBeginQueryIndexedEXT(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, queryPool, query, flags, index, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdBeginQueryIndexedEXT_reply(&submit.reply, commandBuffer, queryPool, query, flags, index);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdBeginQueryIndexedEXT(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdBeginQueryIndexedEXT(vn_instance, 0, commandBuffer, queryPool, query, flags, index, &submit);
}

static inline void vn_call_vkCmdEndQueryIndexedEXT(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdEndQueryIndexedEXT(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, queryPool, query, index, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdEndQueryIndexedEXT_reply(&submit.reply, commandBuffer, queryPool, query, index);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdEndQueryIndexedEXT(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdEndQueryIndexedEXT(vn_instance, 0, commandBuffer, queryPool, query, index, &submit);
}

static inline void vn_call_vkCmdDrawIndirectByteCountEXT(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDrawIndirectByteCountEXT(vn_instance, VK_COMMAND_GENERATE_REPLY_BIT_EXT, commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride, &submit);
    if (submit.reply_bo) {
        vn_decode_vkCmdDrawIndirectByteCountEXT_reply(&submit.reply, commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride);
        vn_renderer_bo_unref(submit.reply_bo);
    }
}

static inline void vn_async_vkCmdDrawIndirectByteCountEXT(struct vn_instance *vn_instance, VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride)
{
    struct vn_instance_submit_command submit;
    vn_submit_vkCmdDrawIndirectByteCountEXT(vn_instance, 0, commandBuffer, instanceCount, firstInstance, counterBuffer, counterBufferOffset, counterOffset, vertexStride, &submit);
}

#endif /* VN_PROTOCOL_DRIVER_COMMAND_BUFFER_H */
