/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_OCCLUSION_QUERY},
	{93, PKT3_SET_PREDICATION},
	{109, PKT3_COND_EXEC},
	{119, PKT3_PRED_EXEC},
	{129, PKT3_DRAW_INDIRECT},
	{143, PKT3_DRAW_INDEX_INDIRECT},
	{163, PKT3_INDEX_BASE},
	{174, PKT3_DRAW_INDEX_2},
	{187, PKT3_CONTEXT_CONTROL},
	{203, PKT3_INDEX_TYPE},
	{214, PKT3_DRAW_INDIRECT_MULTI},
	{234, PKT3_DRAW_INDEX_AUTO},
	{250, PKT3_DRAW_INDEX_IMMD},
	{266, PKT3_NUM_INSTANCES},
	{280, PKT3_DRAW_INDEX_MULTI_AUTO},
	{302, PKT3_INDIRECT_BUFFER_SI},
	{321, PKT3_INDIRECT_BUFFER_CONST},
	{343, PKT3_STRMOUT_BUFFER_UPDATE},
	{365, PKT3_DRAW_INDEX_OFFSET_2},
	{385, PKT3_WRITE_DATA},
	{396, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{422, PKT3_MEM_SEMAPHORE},
	{436, PKT3_MPEG_INDEX},
	{447, PKT3_WAIT_REG_MEM},
	{460, PKT3_MEM_WRITE},
	{470, PKT3_INDIRECT_BUFFER_CIK},
	{490, PKT3_COPY_DATA},
	{500, PKT3_PFP_SYNC_ME},
	{512, PKT3_SURFACE_SYNC},
	{525, PKT3_ME_INITIALIZE},
	{539, PKT3_COND_WRITE},
	{550, PKT3_EVENT_WRITE},
	{562, PKT3_EVENT_WRITE_EOP},
	{578, PKT3_RELEASE_MEM},
	{590, PKT3_ONE_REG_WRITE},
	{604, PKT3_ACQUIRE_MEM},
	{616, PKT3_SET_CONFIG_REG},
	{631, PKT3_SET_CONTEXT_REG},
	{647, PKT3_SET_SH_REG},
	{658, PKT3_SET_SH_REG_OFFSET},
	{676, PKT3_SET_UCONFIG_REG},
	{692, PKT3_LOAD_CONST_RAM},
	{707, PKT3_WRITE_CONST_RAM},
	{723, PKT3_DUMP_CONST_RAM},
	{738, PKT3_INCREMENT_CE_COUNTER},
	{759, PKT3_INCREMENT_DE_COUNTER},
	{780, PKT3_WAIT_ON_CE_COUNTER},
	{799, PKT3_IT_OPCODE_C},
	{811, PKT3_CP_DMA},
	{818, PKT3_DMA_DATA},
};

static const struct si_reg sid_reg_table[] = {
	{827, R_2C3_DRAW_INDEX_LOC, 2, 0},
	{195, R_370_CONTROL, 4, 2},
	{842, R_371_DST_ADDR_LO},
	{854, R_372_DST_ADDR_HI},
	{866, R_3F0_IB_BASE_LO},
	{877, R_3F1_IB_BASE_HI},
	{195, R_3F2_CONTROL, 3, 6},
	{888, R_410_CP_DMA_WORD0, 1, 9},
	{901, R_411_CP_DMA_WORD1, 5, 10},
	{914, R_412_CP_DMA_WORD2, 1, 15},
	{927, R_413_CP_DMA_WORD3, 1, 16},
	{940, R_414_COMMAND, 11, 17},
	{948, R_500_DMA_DATA_WORD0, 4, 28},
	{963, R_501_SRC_ADDR_LO},
	{975, R_502_SRC_ADDR_HI},
	{842, R_503_DST_ADDR_LO},
	{854, R_504_DST_ADDR_HI},
	{987, R_000E4C_SRBM_STATUS2, 21, 32},
	{1000, R_000E50_SRBM_STATUS, 20, 53},
	{1012, R_000E54_SRBM_STATUS3, 16, 73},
	{1025, R_00D034_SDMA0_STATUS_REG, 29, 89},
	{1042, R_00D834_SDMA1_STATUS_REG, 29, 89},
	{1059, R_008008_GRBM_STATUS2, 18, 118},
	{1072, R_008010_GRBM_STATUS, 24, 136},
	{1084, R_00802C_GRBM_GFX_INDEX, 6, 160},
	{1099, R_0084FC_CP_STRMOUT_CNTL, 1, 166},
	{1115, R_0085F0_CP_COHER_CNTL, 19, 167},
	{1129, R_0085F4_CP_COHER_SIZE},
	{1143, R_0085F8_CP_COHER_BASE},
	{1157, R_008014_GRBM_STATUS_SE0, 11, 186},
	{1173, R_008018_GRBM_STATUS_SE1, 11, 197},
	{1189, R_008038_GRBM_STATUS_SE2, 11, 208},
	{1205, R_00803C_GRBM_STATUS_SE3, 11, 219},
	{1099, R_0300FC_CP_STRMOUT_CNTL, 1, 230},
	{1221, R_0301E4_CP_COHER_BASE_HI, 1, 231},
	{1238, R_0301EC_CP_COHER_START_DELAY, 1, 232},
	{1115, R_0301F0_CP_COHER_CNTL, 27, 233},
	{1129, R_0301F4_CP_COHER_SIZE},
	{1143, R_0301F8_CP_COHER_BASE},
	{1259, R_0301FC_CP_COHER_STATUS, 4, 260},
	{1275, R_008210_CP_CPC_STATUS, 15, 264},
	{1289, R_008214_CP_CPC_BUSY_STAT, 28, 279},
	{1306, R_008218_CP_CPC_STALLED_STAT1, 14, 307},
	{1327, R_00821C_CP_CPF_STATUS, 21, 321},
	{1341, R_008220_CP_CPF_BUSY_STAT, 31, 342},
	{1358, R_008224_CP_CPF_STALLED_STAT1, 9, 373},
	{1379, R_030230_CP_COHER_SIZE_HI, 1, 382},
	{1396, R_0088B0_VGT_VTX_VECT_EJECT_REG, 1, 383},
	{1419, R_0088C4_VGT_CACHE_INVALIDATION, 3, 384},
	{1442, R_0088C8_VGT_ESGS_RING_SIZE},
	{1461, R_0088CC_VGT_GSVS_RING_SIZE},
	{1480, R_0088D4_VGT_GS_VERTEX_REUSE, 1, 387},
	{1500, R_008958_VGT_PRIMITIVE_TYPE, 1, 388},
	{1519, R_00895C_VGT_INDEX_TYPE, 1, 389},
	{1534, R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{1567, R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{1600, R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{1633, R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{1666, R_008970_VGT_NUM_INDICES},
	{1682, R_008974_VGT_NUM_INSTANCES},
	{1700, R_008988_VGT_TF_RING_SIZE, 1, 390},
	{1717, R_0089B0_VGT_HS_OFFCHIP_PARAM, 1, 391},
	{1738, R_0089B8_VGT_TF_MEMORY_BASE},
	{1757, R_008A14_PA_CL_ENHANCE, 4, 392},
	{1771, R_008A60_PA_SU_LINE_STIPPLE_VALUE, 1, 396},
	{1796, R_008B10_PA_SC_LINE_STIPPLE_STATE, 2, 397},
	{1821, R_008670_CP_STALLED_STAT3, 19, 399},
	{1838, R_008674_CP_STALLED_STAT1, 16, 418},
	{1855, R_008678_CP_STALLED_STAT2, 29, 434},
	{1872, R_008680_CP_STAT, 23, 463},
	{1084, R_030800_GRBM_GFX_INDEX, 6, 486},
	{1442, R_030900_VGT_ESGS_RING_SIZE},
	{1461, R_030904_VGT_GSVS_RING_SIZE},
	{1500, R_030908_VGT_PRIMITIVE_TYPE, 1, 492},
	{1519, R_03090C_VGT_INDEX_TYPE, 1, 493},
	{1534, R_030910_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{1567, R_030914_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{1600, R_030918_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{1633, R_03091C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{1666, R_030930_VGT_NUM_INDICES},
	{1682, R_030934_VGT_NUM_INSTANCES},
	{1700, R_030938_VGT_TF_RING_SIZE, 1, 494},
	{1717, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 495},
	{1738, R_030940_VGT_TF_MEMORY_BASE},
	{1771, R_030A00_PA_SU_LINE_STIPPLE_VALUE, 1, 497},
	{1796, R_030A04_PA_SC_LINE_STIPPLE_STATE, 2, 498},
	{1880, R_030A10_PA_SC_SCREEN_EXTENT_MIN_0, 2, 500},
	{1906, R_030A14_PA_SC_SCREEN_EXTENT_MAX_0, 2, 502},
	{1932, R_030A18_PA_SC_SCREEN_EXTENT_MIN_1, 2, 504},
	{1958, R_030A2C_PA_SC_SCREEN_EXTENT_MAX_1, 2, 506},
	{1984, R_008BF0_PA_SC_ENHANCE, 9, 508},
	{1998, R_008C08_SQC_CACHES, 2, 517},
	{1998, R_030D20_SQC_CACHES, 3, 519},
	{2009, R_008C0C_SQ_RANDOM_WAVE_PRI, 3, 522},
	{2028, R_008DFC_SQ_EXP_0, 6, 525},
	{2037, R_030E00_TA_CS_BC_BASE_ADDR},
	{2056, R_030E04_TA_CS_BC_BASE_ADDR_HI, 1, 531},
	{2078, R_030F00_DB_OCCLUSION_COUNT0_LOW},
	{2102, R_030F04_DB_OCCLUSION_COUNT0_HI, 1, 532},
	{2125, R_008F00_SQ_BUF_RSRC_WORD0},
	{2143, R_008F04_SQ_BUF_RSRC_WORD1, 4, 533},
	{2161, R_030F08_DB_OCCLUSION_COUNT1_LOW},
	{2185, R_008F08_SQ_BUF_RSRC_WORD2},
	{2203, R_030F0C_DB_OCCLUSION_COUNT1_HI, 1, 537},
	{2226, R_008F0C_SQ_BUF_RSRC_WORD3, 14, 538},
	{2244, R_030F10_DB_OCCLUSION_COUNT2_LOW},
	{2268, R_008F10_SQ_IMG_RSRC_WORD0},
	{2286, R_030F14_DB_OCCLUSION_COUNT2_HI, 1, 552},
	{2309, R_008F14_SQ_IMG_RSRC_WORD1, 5, 553},
	{2327, R_030F18_DB_OCCLUSION_COUNT3_LOW},
	{2351, R_008F18_SQ_IMG_RSRC_WORD2, 4, 558},
	{2369, R_030F1C_DB_OCCLUSION_COUNT3_HI, 1, 562},
	{2392, R_008F1C_SQ_IMG_RSRC_WORD3, 11, 563},
	{2410, R_008F20_SQ_IMG_RSRC_WORD4, 2, 574},
	{2428, R_008F24_SQ_IMG_RSRC_WORD5, 2, 576},
	{2446, R_008F28_SQ_IMG_RSRC_WORD6, 8, 578},
	{2464, R_008F2C_SQ_IMG_RSRC_WORD7},
	{2482, R_008F30_SQ_IMG_SAMP_WORD0, 14, 586},
	{2500, R_008F34_SQ_IMG_SAMP_WORD1, 4, 600},
	{2518, R_008F38_SQ_IMG_SAMP_WORD2, 10, 604},
	{2536, R_008F3C_SQ_IMG_SAMP_WORD3, 3, 614},
	{2554, R_0090DC_SPI_DYN_GPR_LOCK_EN, 5, 617},
	{2574, R_0090E0_SPI_STATIC_THREAD_MGMT_1, 2, 622},
	{2599, R_0090E4_SPI_STATIC_THREAD_MGMT_2, 2, 624},
	{2624, R_0090E8_SPI_STATIC_THREAD_MGMT_3, 1, 626},
	{2649, R_0090EC_SPI_PS_MAX_WAVE_ID, 1, 627},
	{2649, R_0090E8_SPI_PS_MAX_WAVE_ID, 1, 628},
	{2668, R_0090F0_SPI_ARB_PRIORITY, 3, 629},
	{2668, R_00C700_SPI_ARB_PRIORITY, 8, 632},
	{2685, R_0090F4_SPI_ARB_CYCLES_0, 2, 640},
	{2702, R_0090F8_SPI_ARB_CYCLES_1, 1, 642},
	{2719, R_008F40_SQ_FLAT_SCRATCH_WORD0, 1, 643},
	{2741, R_008F44_SQ_FLAT_SCRATCH_WORD1, 1, 644},
	{2763, R_030FF8_DB_ZPASS_COUNT_LOW},
	{2782, R_030FFC_DB_ZPASS_COUNT_HI, 1, 645},
	{2800, R_009100_SPI_CONFIG_CNTL, 5, 646},
	{2816, R_00913C_SPI_CONFIG_CNTL_1, 5, 651},
	{2834, R_00936C_SPI_RESOURCE_RESERVE_CU_AB_0, 12, 656},
	{2037, R_00950C_TA_CS_BC_BASE_ADDR},
	{2863, R_009858_DB_SUBTILE_CONTROL, 10, 668},
	{2882, R_0098F8_GB_ADDR_CONFIG, 9, 678},
	{2897, R_009910_GB_TILE_MODE0, 10, 687},
	{2911, R_009914_GB_TILE_MODE1, 10, 687},
	{2925, R_009918_GB_TILE_MODE2, 10, 687},
	{2939, R_00991C_GB_TILE_MODE3, 10, 687},
	{2953, R_009920_GB_TILE_MODE4, 10, 687},
	{2967, R_009924_GB_TILE_MODE5, 10, 687},
	{2981, R_009928_GB_TILE_MODE6, 10, 687},
	{2995, R_00992C_GB_TILE_MODE7, 10, 687},
	{3009, R_009930_GB_TILE_MODE8, 10, 687},
	{3023, R_009934_GB_TILE_MODE9, 10, 687},
	{3037, R_009938_GB_TILE_MODE10, 10, 687},
	{3052, R_00993C_GB_TILE_MODE11, 10, 687},
	{3067, R_009940_GB_TILE_MODE12, 10, 687},
	{3082, R_009944_GB_TILE_MODE13, 10, 687},
	{3097, R_009948_GB_TILE_MODE14, 10, 687},
	{3112, R_00994C_GB_TILE_MODE15, 10, 687},
	{3127, R_009950_GB_TILE_MODE16, 10, 687},
	{3142, R_009954_GB_TILE_MODE17, 10, 687},
	{3157, R_009958_GB_TILE_MODE18, 10, 687},
	{3172, R_00995C_GB_TILE_MODE19, 10, 687},
	{3187, R_009960_GB_TILE_MODE20, 10, 687},
	{3202, R_009964_GB_TILE_MODE21, 10, 687},
	{3217, R_009968_GB_TILE_MODE22, 10, 687},
	{3232, R_00996C_GB_TILE_MODE23, 10, 687},
	{3247, R_009970_GB_TILE_MODE24, 10, 687},
	{3262, R_009974_GB_TILE_MODE25, 10, 687},
	{3277, R_009978_GB_TILE_MODE26, 10, 687},
	{3292, R_00997C_GB_TILE_MODE27, 10, 687},
	{3307, R_009980_GB_TILE_MODE28, 10, 687},
	{3322, R_009984_GB_TILE_MODE29, 10, 687},
	{3337, R_009988_GB_TILE_MODE30, 10, 687},
	{3352, R_00998C_GB_TILE_MODE31, 10, 687},
	{3367, R_009990_GB_MACROTILE_MODE0, 4, 697},
	{3386, R_009994_GB_MACROTILE_MODE1, 4, 697},
	{3405, R_009998_GB_MACROTILE_MODE2, 4, 697},
	{3424, R_00999C_GB_MACROTILE_MODE3, 4, 697},
	{3443, R_0099A0_GB_MACROTILE_MODE4, 4, 697},
	{3462, R_0099A4_GB_MACROTILE_MODE5, 4, 697},
	{3481, R_0099A8_GB_MACROTILE_MODE6, 4, 697},
	{3500, R_0099AC_GB_MACROTILE_MODE7, 4, 697},
	{3519, R_0099B0_GB_MACROTILE_MODE8, 4, 697},
	{3538, R_0099B4_GB_MACROTILE_MODE9, 4, 697},
	{3557, R_0099B8_GB_MACROTILE_MODE10, 4, 697},
	{3577, R_0099BC_GB_MACROTILE_MODE11, 4, 697},
	{3597, R_0099C0_GB_MACROTILE_MODE12, 4, 697},
	{3617, R_0099C4_GB_MACROTILE_MODE13, 4, 697},
	{3637, R_0099C8_GB_MACROTILE_MODE14, 4, 697},
	{3657, R_0099CC_GB_MACROTILE_MODE15, 4, 697},
	{3677, R_00B000_SPI_SHADER_TBA_LO_PS},
	{3698, R_00B004_SPI_SHADER_TBA_HI_PS, 1, 701},
	{3719, R_00B008_SPI_SHADER_TMA_LO_PS},
	{3740, R_00B00C_SPI_SHADER_TMA_HI_PS, 1, 702},
	{3761, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 3, 703},
	{3785, R_00B020_SPI_SHADER_PGM_LO_PS},
	{3806, R_00B024_SPI_SHADER_PGM_HI_PS, 1, 706},
	{3827, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 707},
	{3851, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 7, 718},
	{3875, R_00B030_SPI_SHADER_USER_DATA_PS_0},
	{3901, R_00B034_SPI_SHADER_USER_DATA_PS_1},
	{3927, R_00B038_SPI_SHADER_USER_DATA_PS_2},
	{3953, R_00B03C_SPI_SHADER_USER_DATA_PS_3},
	{3979, R_00B040_SPI_SHADER_USER_DATA_PS_4},
	{4005, R_00B044_SPI_SHADER_USER_DATA_PS_5},
	{4031, R_00B048_SPI_SHADER_USER_DATA_PS_6},
	{4057, R_00B04C_SPI_SHADER_USER_DATA_PS_7},
	{4083, R_00B050_SPI_SHADER_USER_DATA_PS_8},
	{4109, R_00B054_SPI_SHADER_USER_DATA_PS_9},
	{4135, R_00B058_SPI_SHADER_USER_DATA_PS_10},
	{4162, R_00B05C_SPI_SHADER_USER_DATA_PS_11},
	{4189, R_00B060_SPI_SHADER_USER_DATA_PS_12},
	{4216, R_00B064_SPI_SHADER_USER_DATA_PS_13},
	{4243, R_00B068_SPI_SHADER_USER_DATA_PS_14},
	{4270, R_00B06C_SPI_SHADER_USER_DATA_PS_15},
	{4297, R_00B100_SPI_SHADER_TBA_LO_VS},
	{4318, R_00B104_SPI_SHADER_TBA_HI_VS, 1, 725},
	{4339, R_00B108_SPI_SHADER_TMA_LO_VS},
	{4360, R_00B10C_SPI_SHADER_TMA_HI_VS, 1, 726},
	{4381, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 3, 727},
	{4405, R_00B11C_SPI_SHADER_LATE_ALLOC_VS, 1, 730},
	{4430, R_00B120_SPI_SHADER_PGM_LO_VS},
	{4451, R_00B124_SPI_SHADER_PGM_HI_VS, 1, 731},
	{4472, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 732},
	{4496, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 12, 744},
	{4520, R_00B130_SPI_SHADER_USER_DATA_VS_0},
	{4546, R_00B134_SPI_SHADER_USER_DATA_VS_1},
	{4572, R_00B138_SPI_SHADER_USER_DATA_VS_2},
	{4598, R_00B13C_SPI_SHADER_USER_DATA_VS_3},
	{4624, R_00B140_SPI_SHADER_USER_DATA_VS_4},
	{4650, R_00B144_SPI_SHADER_USER_DATA_VS_5},
	{4676, R_00B148_SPI_SHADER_USER_DATA_VS_6},
	{4702, R_00B14C_SPI_SHADER_USER_DATA_VS_7},
	{4728, R_00B150_SPI_SHADER_USER_DATA_VS_8},
	{4754, R_00B154_SPI_SHADER_USER_DATA_VS_9},
	{4780, R_00B158_SPI_SHADER_USER_DATA_VS_10},
	{4807, R_00B15C_SPI_SHADER_USER_DATA_VS_11},
	{4834, R_00B160_SPI_SHADER_USER_DATA_VS_12},
	{4861, R_00B164_SPI_SHADER_USER_DATA_VS_13},
	{4888, R_00B168_SPI_SHADER_USER_DATA_VS_14},
	{4915, R_00B16C_SPI_SHADER_USER_DATA_VS_15},
	{4942, R_00B200_SPI_SHADER_TBA_LO_GS},
	{4963, R_00B204_SPI_SHADER_TBA_HI_GS, 1, 756},
	{4984, R_00B208_SPI_SHADER_TMA_LO_GS},
	{5005, R_00B20C_SPI_SHADER_TMA_HI_GS, 1, 757},
	{5026, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 758},
	{5050, R_00B220_SPI_SHADER_PGM_LO_GS},
	{5071, R_00B224_SPI_SHADER_PGM_HI_GS, 1, 762},
	{5092, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 11, 763},
	{5116, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 5, 774},
	{5140, R_00B230_SPI_SHADER_USER_DATA_GS_0},
	{5166, R_00B234_SPI_SHADER_USER_DATA_GS_1},
	{5192, R_00B238_SPI_SHADER_USER_DATA_GS_2},
	{5218, R_00B23C_SPI_SHADER_USER_DATA_GS_3},
	{5244, R_00B240_SPI_SHADER_USER_DATA_GS_4},
	{5270, R_00B244_SPI_SHADER_USER_DATA_GS_5},
	{5296, R_00B248_SPI_SHADER_USER_DATA_GS_6},
	{5322, R_00B24C_SPI_SHADER_USER_DATA_GS_7},
	{5348, R_00B250_SPI_SHADER_USER_DATA_GS_8},
	{5374, R_00B254_SPI_SHADER_USER_DATA_GS_9},
	{5400, R_00B258_SPI_SHADER_USER_DATA_GS_10},
	{5427, R_00B25C_SPI_SHADER_USER_DATA_GS_11},
	{5454, R_00B260_SPI_SHADER_USER_DATA_GS_12},
	{5481, R_00B264_SPI_SHADER_USER_DATA_GS_13},
	{5508, R_00B268_SPI_SHADER_USER_DATA_GS_14},
	{5535, R_00B26C_SPI_SHADER_USER_DATA_GS_15},
	{5562, R_00B300_SPI_SHADER_TBA_LO_ES},
	{5583, R_00B304_SPI_SHADER_TBA_HI_ES, 1, 779},
	{5604, R_00B308_SPI_SHADER_TMA_LO_ES},
	{5625, R_00B30C_SPI_SHADER_TMA_HI_ES, 1, 780},
	{5646, R_00B31C_SPI_SHADER_PGM_RSRC3_ES, 4, 781},
	{5670, R_00B320_SPI_SHADER_PGM_LO_ES},
	{5691, R_00B324_SPI_SHADER_PGM_HI_ES, 1, 785},
	{5712, R_00B328_SPI_SHADER_PGM_RSRC1_ES, 12, 786},
	{5736, R_00B32C_SPI_SHADER_PGM_RSRC2_ES, 7, 798},
	{5760, R_00B330_SPI_SHADER_USER_DATA_ES_0},
	{5786, R_00B334_SPI_SHADER_USER_DATA_ES_1},
	{5812, R_00B338_SPI_SHADER_USER_DATA_ES_2},
	{5838, R_00B33C_SPI_SHADER_USER_DATA_ES_3},
	{5864, R_00B340_SPI_SHADER_USER_DATA_ES_4},
	{5890, R_00B344_SPI_SHADER_USER_DATA_ES_5},
	{5916, R_00B348_SPI_SHADER_USER_DATA_ES_6},
	{5942, R_00B34C_SPI_SHADER_USER_DATA_ES_7},
	{5968, R_00B350_SPI_SHADER_USER_DATA_ES_8},
	{5994, R_00B354_SPI_SHADER_USER_DATA_ES_9},
	{6020, R_00B358_SPI_SHADER_USER_DATA_ES_10},
	{6047, R_00B35C_SPI_SHADER_USER_DATA_ES_11},
	{6074, R_00B360_SPI_SHADER_USER_DATA_ES_12},
	{6101, R_00B364_SPI_SHADER_USER_DATA_ES_13},
	{6128, R_00B368_SPI_SHADER_USER_DATA_ES_14},
	{6155, R_00B36C_SPI_SHADER_USER_DATA_ES_15},
	{6182, R_00B400_SPI_SHADER_TBA_LO_HS},
	{6203, R_00B404_SPI_SHADER_TBA_HI_HS, 1, 805},
	{6224, R_00B408_SPI_SHADER_TMA_LO_HS},
	{6245, R_00B40C_SPI_SHADER_TMA_HI_HS, 1, 806},
	{6266, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 3, 807},
	{6290, R_00B420_SPI_SHADER_PGM_LO_HS},
	{6311, R_00B424_SPI_SHADER_PGM_HI_HS, 1, 810},
	{6332, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 10, 811},
	{6356, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 7, 821},
	{6380, R_00B430_SPI_SHADER_USER_DATA_HS_0},
	{6406, R_00B434_SPI_SHADER_USER_DATA_HS_1},
	{6432, R_00B438_SPI_SHADER_USER_DATA_HS_2},
	{6458, R_00B43C_SPI_SHADER_USER_DATA_HS_3},
	{6484, R_00B440_SPI_SHADER_USER_DATA_HS_4},
	{6510, R_00B444_SPI_SHADER_USER_DATA_HS_5},
	{6536, R_00B448_SPI_SHADER_USER_DATA_HS_6},
	{6562, R_00B44C_SPI_SHADER_USER_DATA_HS_7},
	{6588, R_00B450_SPI_SHADER_USER_DATA_HS_8},
	{6614, R_00B454_SPI_SHADER_USER_DATA_HS_9},
	{6640, R_00B458_SPI_SHADER_USER_DATA_HS_10},
	{6667, R_00B45C_SPI_SHADER_USER_DATA_HS_11},
	{6694, R_00B460_SPI_SHADER_USER_DATA_HS_12},
	{6721, R_00B464_SPI_SHADER_USER_DATA_HS_13},
	{6748, R_00B468_SPI_SHADER_USER_DATA_HS_14},
	{6775, R_00B46C_SPI_SHADER_USER_DATA_HS_15},
	{6802, R_00B500_SPI_SHADER_TBA_LO_LS},
	{6823, R_00B504_SPI_SHADER_TBA_HI_LS, 1, 828},
	{6844, R_00B508_SPI_SHADER_TMA_LO_LS},
	{6865, R_00B50C_SPI_SHADER_TMA_HI_LS, 1, 829},
	{6886, R_00B51C_SPI_SHADER_PGM_RSRC3_LS, 4, 830},
	{6910, R_00B520_SPI_SHADER_PGM_LO_LS},
	{6931, R_00B524_SPI_SHADER_PGM_HI_LS, 1, 834},
	{6952, R_00B528_SPI_SHADER_PGM_RSRC1_LS, 11, 835},
	{6976, R_00B52C_SPI_SHADER_PGM_RSRC2_LS, 6, 846},
	{7000, R_00B530_SPI_SHADER_USER_DATA_LS_0},
	{7026, R_00B534_SPI_SHADER_USER_DATA_LS_1},
	{7052, R_00B538_SPI_SHADER_USER_DATA_LS_2},
	{7078, R_00B53C_SPI_SHADER_USER_DATA_LS_3},
	{7104, R_00B540_SPI_SHADER_USER_DATA_LS_4},
	{7130, R_00B544_SPI_SHADER_USER_DATA_LS_5},
	{7156, R_00B548_SPI_SHADER_USER_DATA_LS_6},
	{7182, R_00B54C_SPI_SHADER_USER_DATA_LS_7},
	{7208, R_00B550_SPI_SHADER_USER_DATA_LS_8},
	{7234, R_00B554_SPI_SHADER_USER_DATA_LS_9},
	{7260, R_00B558_SPI_SHADER_USER_DATA_LS_10},
	{7287, R_00B55C_SPI_SHADER_USER_DATA_LS_11},
	{7314, R_00B560_SPI_SHADER_USER_DATA_LS_12},
	{7341, R_00B564_SPI_SHADER_USER_DATA_LS_13},
	{7368, R_00B568_SPI_SHADER_USER_DATA_LS_14},
	{7395, R_00B56C_SPI_SHADER_USER_DATA_LS_15},
	{7422, R_00B800_COMPUTE_DISPATCH_INITIATOR, 12, 852},
	{7449, R_00B804_COMPUTE_DIM_X},
	{7463, R_00B808_COMPUTE_DIM_Y},
	{7477, R_00B80C_COMPUTE_DIM_Z},
	{7491, R_00B810_COMPUTE_START_X},
	{7507, R_00B814_COMPUTE_START_Y},
	{7523, R_00B818_COMPUTE_START_Z},
	{7539, R_00B81C_COMPUTE_NUM_THREAD_X, 2, 864},
	{7560, R_00B820_COMPUTE_NUM_THREAD_Y, 2, 866},
	{7581, R_00B824_COMPUTE_NUM_THREAD_Z, 2, 868},
	{7602, R_00B82C_COMPUTE_MAX_WAVE_ID, 1, 870},
	{7622, R_00B828_COMPUTE_PIPELINESTAT_ENABLE, 1, 871},
	{7650, R_00B82C_COMPUTE_PERFCOUNT_ENABLE, 1, 872},
	{7675, R_00B830_COMPUTE_PGM_LO},
	{7690, R_00B834_COMPUTE_PGM_HI, 2, 873},
	{7705, R_00B838_COMPUTE_TBA_LO},
	{7720, R_00B83C_COMPUTE_TBA_HI, 1, 875},
	{7735, R_00B840_COMPUTE_TMA_LO},
	{7750, R_00B844_COMPUTE_TMA_HI, 1, 876},
	{7765, R_00B848_COMPUTE_PGM_RSRC1, 10, 877},
	{7783, R_00B84C_COMPUTE_PGM_RSRC2, 11, 887},
	{7801, R_00B850_COMPUTE_VMID, 1, 898},
	{7814, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 899},
	{7838, R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0, 2, 906},
	{7869, R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1, 2, 908},
	{7900, R_00B860_COMPUTE_TMPRING_SIZE, 2, 910},
	{7921, R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2, 2, 912},
	{7952, R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3, 2, 914},
	{7983, R_00B86C_COMPUTE_RESTART_X},
	{8001, R_00B870_COMPUTE_RESTART_Y},
	{8019, R_00B874_COMPUTE_RESTART_Z},
	{8037, R_00B87C_COMPUTE_MISC_RESERVED, 5, 916},
	{8059, R_00B880_COMPUTE_DISPATCH_ID},
	{8079, R_00B884_COMPUTE_THREADGROUP_ID},
	{8102, R_00B888_COMPUTE_RELAUNCH, 3, 921},
	{8119, R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO},
	{8148, R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI, 1, 924},
	{8177, R_00B894_COMPUTE_WAVE_RESTORE_CONTROL, 2, 925},
	{8206, R_00B900_COMPUTE_USER_DATA_0},
	{8226, R_00B904_COMPUTE_USER_DATA_1},
	{8246, R_00B908_COMPUTE_USER_DATA_2},
	{8266, R_00B90C_COMPUTE_USER_DATA_3},
	{8286, R_00B910_COMPUTE_USER_DATA_4},
	{8306, R_00B914_COMPUTE_USER_DATA_5},
	{8326, R_00B918_COMPUTE_USER_DATA_6},
	{8346, R_00B91C_COMPUTE_USER_DATA_7},
	{8366, R_00B920_COMPUTE_USER_DATA_8},
	{8386, R_00B924_COMPUTE_USER_DATA_9},
	{8406, R_00B928_COMPUTE_USER_DATA_10},
	{8427, R_00B92C_COMPUTE_USER_DATA_11},
	{8448, R_00B930_COMPUTE_USER_DATA_12},
	{8469, R_00B934_COMPUTE_USER_DATA_13},
	{8490, R_00B938_COMPUTE_USER_DATA_14},
	{8511, R_00B93C_COMPUTE_USER_DATA_15},
	{8532, R_00B9FC_COMPUTE_NOWHERE},
	{8548, R_034000_CPG_PERFCOUNTER1_LO},
	{8568, R_034004_CPG_PERFCOUNTER1_HI},
	{8588, R_034008_CPG_PERFCOUNTER0_LO},
	{8608, R_03400C_CPG_PERFCOUNTER0_HI},
	{8628, R_034010_CPC_PERFCOUNTER1_LO},
	{8648, R_034014_CPC_PERFCOUNTER1_HI},
	{8668, R_034018_CPC_PERFCOUNTER0_LO},
	{8688, R_03401C_CPC_PERFCOUNTER0_HI},
	{8708, R_034020_CPF_PERFCOUNTER1_LO},
	{8728, R_034024_CPF_PERFCOUNTER1_HI},
	{8748, R_034028_CPF_PERFCOUNTER0_LO},
	{8768, R_03402C_CPF_PERFCOUNTER0_HI},
	{8788, R_034100_GRBM_PERFCOUNTER0_LO},
	{8809, R_034104_GRBM_PERFCOUNTER0_HI},
	{8830, R_03410C_GRBM_PERFCOUNTER1_LO},
	{8851, R_034110_GRBM_PERFCOUNTER1_HI},
	{8872, R_034114_GRBM_SE0_PERFCOUNTER_LO},
	{8896, R_034118_GRBM_SE0_PERFCOUNTER_HI},
	{8920, R_03411C_GRBM_SE1_PERFCOUNTER_LO},
	{8944, R_034120_GRBM_SE1_PERFCOUNTER_HI},
	{8968, R_034124_GRBM_SE2_PERFCOUNTER_LO},
	{8992, R_034128_GRBM_SE2_PERFCOUNTER_HI},
	{9016, R_03412C_GRBM_SE3_PERFCOUNTER_LO},
	{9040, R_034130_GRBM_SE3_PERFCOUNTER_HI},
	{9064, R_034200_WD_PERFCOUNTER0_LO},
	{9083, R_034204_WD_PERFCOUNTER0_HI},
	{9102, R_034208_WD_PERFCOUNTER1_LO},
	{9121, R_03420C_WD_PERFCOUNTER1_HI},
	{9140, R_034210_WD_PERFCOUNTER2_LO},
	{9159, R_034214_WD_PERFCOUNTER2_HI},
	{9178, R_034218_WD_PERFCOUNTER3_LO},
	{9197, R_03421C_WD_PERFCOUNTER3_HI},
	{9216, R_034220_IA_PERFCOUNTER0_LO},
	{9235, R_034224_IA_PERFCOUNTER0_HI},
	{9254, R_034228_IA_PERFCOUNTER1_LO},
	{9273, R_03422C_IA_PERFCOUNTER1_HI},
	{9292, R_034230_IA_PERFCOUNTER2_LO},
	{9311, R_034234_IA_PERFCOUNTER2_HI},
	{9330, R_034238_IA_PERFCOUNTER3_LO},
	{9349, R_03423C_IA_PERFCOUNTER3_HI},
	{9368, R_034240_VGT_PERFCOUNTER0_LO},
	{9388, R_034244_VGT_PERFCOUNTER0_HI},
	{9408, R_034248_VGT_PERFCOUNTER1_LO},
	{9428, R_03424C_VGT_PERFCOUNTER1_HI},
	{9448, R_034250_VGT_PERFCOUNTER2_LO},
	{9468, R_034254_VGT_PERFCOUNTER2_HI},
	{9488, R_034258_VGT_PERFCOUNTER3_LO},
	{9508, R_03425C_VGT_PERFCOUNTER3_HI},
	{9528, R_034400_PA_SU_PERFCOUNTER0_LO},
	{9550, R_034404_PA_SU_PERFCOUNTER0_HI, 1, 927},
	{9572, R_034408_PA_SU_PERFCOUNTER1_LO},
	{9594, R_03440C_PA_SU_PERFCOUNTER1_HI, 1, 927},
	{9616, R_034410_PA_SU_PERFCOUNTER2_LO},
	{9638, R_034414_PA_SU_PERFCOUNTER2_HI, 1, 927},
	{9660, R_034418_PA_SU_PERFCOUNTER3_LO},
	{9682, R_03441C_PA_SU_PERFCOUNTER3_HI, 1, 927},
	{9704, R_034500_PA_SC_PERFCOUNTER0_LO},
	{9726, R_034504_PA_SC_PERFCOUNTER0_HI},
	{9748, R_034508_PA_SC_PERFCOUNTER1_LO},
	{9770, R_03450C_PA_SC_PERFCOUNTER1_HI},
	{9792, R_034510_PA_SC_PERFCOUNTER2_LO},
	{9814, R_034514_PA_SC_PERFCOUNTER2_HI},
	{9836, R_034518_PA_SC_PERFCOUNTER3_LO},
	{9858, R_03451C_PA_SC_PERFCOUNTER3_HI},
	{9880, R_034520_PA_SC_PERFCOUNTER4_LO},
	{9902, R_034524_PA_SC_PERFCOUNTER4_HI},
	{9924, R_034528_PA_SC_PERFCOUNTER5_LO},
	{9946, R_03452C_PA_SC_PERFCOUNTER5_HI},
	{9968, R_034530_PA_SC_PERFCOUNTER6_LO},
	{9990, R_034534_PA_SC_PERFCOUNTER6_HI},
	{10012, R_034538_PA_SC_PERFCOUNTER7_LO},
	{10034, R_03453C_PA_SC_PERFCOUNTER7_HI},
	{10056, R_034600_SPI_PERFCOUNTER0_HI},
	{10076, R_034604_SPI_PERFCOUNTER0_LO},
	{10096, R_034608_SPI_PERFCOUNTER1_HI},
	{10116, R_03460C_SPI_PERFCOUNTER1_LO},
	{10136, R_034610_SPI_PERFCOUNTER2_HI},
	{10156, R_034614_SPI_PERFCOUNTER2_LO},
	{10176, R_034618_SPI_PERFCOUNTER3_HI},
	{10196, R_03461C_SPI_PERFCOUNTER3_LO},
	{10216, R_034620_SPI_PERFCOUNTER4_HI},
	{10236, R_034624_SPI_PERFCOUNTER4_LO},
	{10256, R_034628_SPI_PERFCOUNTER5_HI},
	{10276, R_03462C_SPI_PERFCOUNTER5_LO},
	{10296, R_034700_SQ_PERFCOUNTER0_LO},
	{10315, R_034704_SQ_PERFCOUNTER0_HI},
	{10334, R_034708_SQ_PERFCOUNTER1_LO},
	{10353, R_03470C_SQ_PERFCOUNTER1_HI},
	{10372, R_034710_SQ_PERFCOUNTER2_LO},
	{10391, R_034714_SQ_PERFCOUNTER2_HI},
	{10410, R_034718_SQ_PERFCOUNTER3_LO},
	{10429, R_03471C_SQ_PERFCOUNTER3_HI},
	{10448, R_034720_SQ_PERFCOUNTER4_LO},
	{10467, R_034724_SQ_PERFCOUNTER4_HI},
	{10486, R_034728_SQ_PERFCOUNTER5_LO},
	{10505, R_03472C_SQ_PERFCOUNTER5_HI},
	{10524, R_034730_SQ_PERFCOUNTER6_LO},
	{10543, R_034734_SQ_PERFCOUNTER6_HI},
	{10562, R_034738_SQ_PERFCOUNTER7_LO},
	{10581, R_03473C_SQ_PERFCOUNTER7_HI},
	{10600, R_034740_SQ_PERFCOUNTER8_LO},
	{10619, R_034744_SQ_PERFCOUNTER8_HI},
	{10638, R_034748_SQ_PERFCOUNTER9_LO},
	{10657, R_03474C_SQ_PERFCOUNTER9_HI},
	{10676, R_034750_SQ_PERFCOUNTER10_LO},
	{10696, R_034754_SQ_PERFCOUNTER10_HI},
	{10716, R_034758_SQ_PERFCOUNTER11_LO},
	{10736, R_03475C_SQ_PERFCOUNTER11_HI},
	{10756, R_034760_SQ_PERFCOUNTER12_LO},
	{10776, R_034764_SQ_PERFCOUNTER12_HI},
	{10796, R_034768_SQ_PERFCOUNTER13_LO},
	{10816, R_03476C_SQ_PERFCOUNTER13_HI},
	{10836, R_034770_SQ_PERFCOUNTER14_LO},
	{10856, R_034774_SQ_PERFCOUNTER14_HI},
	{10876, R_034778_SQ_PERFCOUNTER15_LO},
	{10896, R_03477C_SQ_PERFCOUNTER15_HI},
	{10916, R_034900_SX_PERFCOUNTER0_LO},
	{10935, R_034904_SX_PERFCOUNTER0_HI},
	{10954, R_034908_SX_PERFCOUNTER1_LO},
	{10973, R_03490C_SX_PERFCOUNTER1_HI},
	{10992, R_034910_SX_PERFCOUNTER2_LO},
	{11011, R_034914_SX_PERFCOUNTER2_HI},
	{11030, R_034918_SX_PERFCOUNTER3_LO},
	{11049, R_03491C_SX_PERFCOUNTER3_HI},
	{11068, R_034A00_GDS_PERFCOUNTER0_LO},
	{11088, R_034A04_GDS_PERFCOUNTER0_HI},
	{11108, R_034A08_GDS_PERFCOUNTER1_LO},
	{11128, R_034A0C_GDS_PERFCOUNTER1_HI},
	{11148, R_034A10_GDS_PERFCOUNTER2_LO},
	{11168, R_034A14_GDS_PERFCOUNTER2_HI},
	{11188, R_034A18_GDS_PERFCOUNTER3_LO},
	{11208, R_034A1C_GDS_PERFCOUNTER3_HI},
	{11228, R_034B00_TA_PERFCOUNTER0_LO},
	{11247, R_034B04_TA_PERFCOUNTER0_HI},
	{11266, R_034B08_TA_PERFCOUNTER1_LO},
	{11285, R_034B0C_TA_PERFCOUNTER1_HI},
	{11304, R_034C00_TD_PERFCOUNTER0_LO},
	{11323, R_034C04_TD_PERFCOUNTER0_HI},
	{11342, R_034C08_TD_PERFCOUNTER1_LO},
	{11361, R_034C0C_TD_PERFCOUNTER1_HI},
	{11380, R_034D00_TCP_PERFCOUNTER0_LO},
	{11400, R_034D04_TCP_PERFCOUNTER0_HI},
	{11420, R_034D08_TCP_PERFCOUNTER1_LO},
	{11440, R_034D0C_TCP_PERFCOUNTER1_HI},
	{11460, R_034D10_TCP_PERFCOUNTER2_LO},
	{11480, R_034D14_TCP_PERFCOUNTER2_HI},
	{11500, R_034D18_TCP_PERFCOUNTER3_LO},
	{11520, R_034D1C_TCP_PERFCOUNTER3_HI},
	{11540, R_034E00_TCC_PERFCOUNTER0_LO},
	{11560, R_034E04_TCC_PERFCOUNTER0_HI},
	{11580, R_034E08_TCC_PERFCOUNTER1_LO},
	{11600, R_034E0C_TCC_PERFCOUNTER1_HI},
	{11620, R_034E10_TCC_PERFCOUNTER2_LO},
	{11640, R_034E14_TCC_PERFCOUNTER2_HI},
	{11660, R_034E18_TCC_PERFCOUNTER3_LO},
	{11680, R_034E1C_TCC_PERFCOUNTER3_HI},
	{11700, R_034E40_TCA_PERFCOUNTER0_LO},
	{11720, R_034E44_TCA_PERFCOUNTER0_HI},
	{11740, R_034E48_TCA_PERFCOUNTER1_LO},
	{11760, R_034E4C_TCA_PERFCOUNTER1_HI},
	{11780, R_034E50_TCA_PERFCOUNTER2_LO},
	{11800, R_034E54_TCA_PERFCOUNTER2_HI},
	{11820, R_034E58_TCA_PERFCOUNTER3_LO},
	{11840, R_034E5C_TCA_PERFCOUNTER3_HI},
	{11860, R_035018_CB_PERFCOUNTER0_LO},
	{11879, R_03501C_CB_PERFCOUNTER0_HI},
	{11898, R_035020_CB_PERFCOUNTER1_LO},
	{11917, R_035024_CB_PERFCOUNTER1_HI},
	{11936, R_035028_CB_PERFCOUNTER2_LO},
	{11955, R_03502C_CB_PERFCOUNTER2_HI},
	{11974, R_035030_CB_PERFCOUNTER3_LO},
	{11993, R_035034_CB_PERFCOUNTER3_HI},
	{12012, R_035100_DB_PERFCOUNTER0_LO},
	{12031, R_035104_DB_PERFCOUNTER0_HI},
	{12050, R_035108_DB_PERFCOUNTER1_LO},
	{12069, R_03510C_DB_PERFCOUNTER1_HI},
	{12088, R_035110_DB_PERFCOUNTER2_LO},
	{12107, R_035114_DB_PERFCOUNTER2_HI},
	{12126, R_035118_DB_PERFCOUNTER3_LO},
	{12145, R_03511C_DB_PERFCOUNTER3_HI},
	{12164, R_035200_RLC_PERFCOUNTER0_LO},
	{12184, R_035204_RLC_PERFCOUNTER0_HI},
	{12204, R_035208_RLC_PERFCOUNTER1_LO},
	{12224, R_03520C_RLC_PERFCOUNTER1_HI},
	{12244, R_036000_CPG_PERFCOUNTER1_SELECT, 3, 928},
	{12268, R_036004_CPG_PERFCOUNTER0_SELECT1, 2, 931},
	{12293, R_036008_CPG_PERFCOUNTER0_SELECT, 3, 928},
	{12317, R_03600C_CPC_PERFCOUNTER1_SELECT, 3, 933},
	{12341, R_036010_CPC_PERFCOUNTER0_SELECT1, 2, 936},
	{12366, R_036014_CPF_PERFCOUNTER1_SELECT, 3, 938},
	{12390, R_036018_CPF_PERFCOUNTER0_SELECT1, 2, 941},
	{12415, R_03601C_CPF_PERFCOUNTER0_SELECT, 3, 938},
	{12439, R_036020_CP_PERFMON_CNTL, 4, 943},
	{12455, R_036024_CPC_PERFCOUNTER0_SELECT, 3, 933},
	{12479, R_036100_GRBM_PERFCOUNTER0_SELECT, 19, 947},
	{12504, R_036104_GRBM_PERFCOUNTER1_SELECT, 19, 947},
	{12529, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 12, 966},
	{12557, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 12, 978},
	{12585, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 12, 990},
	{12613, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 12, 1002},
	{12641, R_036200_WD_PERFCOUNTER0_SELECT, 2, 1014},
	{12664, R_036204_WD_PERFCOUNTER1_SELECT, 2, 1014},
	{12687, R_036208_WD_PERFCOUNTER2_SELECT, 2, 1014},
	{12710, R_03620C_WD_PERFCOUNTER3_SELECT, 2, 1014},
	{12733, R_036210_IA_PERFCOUNTER0_SELECT, 5, 1016},
	{12756, R_036214_IA_PERFCOUNTER1_SELECT, 5, 1016},
	{12779, R_036218_IA_PERFCOUNTER2_SELECT, 5, 1016},
	{12802, R_03621C_IA_PERFCOUNTER3_SELECT, 5, 1016},
	{12825, R_036220_IA_PERFCOUNTER0_SELECT1, 4, 1021},
	{12849, R_036230_VGT_PERFCOUNTER0_SELECT, 5, 1025},
	{12873, R_036234_VGT_PERFCOUNTER1_SELECT, 5, 1025},
	{12897, R_036238_VGT_PERFCOUNTER2_SELECT, 5, 1025},
	{12921, R_03623C_VGT_PERFCOUNTER3_SELECT, 5, 1025},
	{12945, R_036240_VGT_PERFCOUNTER0_SELECT1, 4, 1030},
	{12970, R_036244_VGT_PERFCOUNTER1_SELECT1},
	{12995, R_036250_VGT_PERFCOUNTER_SEID_MASK, 1, 1034},
	{13021, R_036400_PA_SU_PERFCOUNTER0_SELECT, 3, 1035},
	{13047, R_036404_PA_SU_PERFCOUNTER0_SELECT1, 2, 1038},
	{13074, R_036408_PA_SU_PERFCOUNTER1_SELECT, 3, 1035},
	{13100, R_03640C_PA_SU_PERFCOUNTER1_SELECT1},
	{13127, R_036410_PA_SU_PERFCOUNTER2_SELECT, 3, 1035},
	{13153, R_036414_PA_SU_PERFCOUNTER3_SELECT, 3, 1035},
	{13179, R_036500_PA_SC_PERFCOUNTER0_SELECT, 3, 1040},
	{13205, R_036504_PA_SC_PERFCOUNTER0_SELECT1, 2, 1043},
	{13232, R_036508_PA_SC_PERFCOUNTER1_SELECT, 3, 1040},
	{13258, R_03650C_PA_SC_PERFCOUNTER2_SELECT, 3, 1040},
	{13284, R_036510_PA_SC_PERFCOUNTER3_SELECT, 3, 1040},
	{13310, R_036514_PA_SC_PERFCOUNTER4_SELECT, 3, 1040},
	{13336, R_036518_PA_SC_PERFCOUNTER5_SELECT, 3, 1040},
	{13362, R_03651C_PA_SC_PERFCOUNTER6_SELECT, 3, 1040},
	{13388, R_036520_PA_SC_PERFCOUNTER7_SELECT, 3, 1040},
	{13414, R_036600_SPI_PERFCOUNTER0_SELECT, 3, 1045},
	{13438, R_036604_SPI_PERFCOUNTER1_SELECT, 3, 1045},
	{13462, R_036608_SPI_PERFCOUNTER2_SELECT, 3, 1045},
	{13486, R_03660C_SPI_PERFCOUNTER3_SELECT, 3, 1045},
	{13510, R_036610_SPI_PERFCOUNTER0_SELECT1, 2, 1048},
	{13535, R_036614_SPI_PERFCOUNTER1_SELECT1},
	{13560, R_036618_SPI_PERFCOUNTER2_SELECT1},
	{13585, R_03661C_SPI_PERFCOUNTER3_SELECT1},
	{13610, R_036620_SPI_PERFCOUNTER4_SELECT, 3, 1045},
	{13634, R_036624_SPI_PERFCOUNTER5_SELECT, 3, 1045},
	{13658, R_036628_SPI_PERFCOUNTER_BINS, 8, 1050},
	{13679, R_036700_SQ_PERFCOUNTER0_SELECT, 6, 1058},
	{13702, R_036704_SQ_PERFCOUNTER1_SELECT, 6, 1058},
	{13725, R_036708_SQ_PERFCOUNTER2_SELECT, 6, 1058},
	{13748, R_03670C_SQ_PERFCOUNTER3_SELECT, 6, 1058},
	{13771, R_036710_SQ_PERFCOUNTER4_SELECT, 6, 1058},
	{13794, R_036714_SQ_PERFCOUNTER5_SELECT, 6, 1058},
	{13817, R_036718_SQ_PERFCOUNTER6_SELECT, 6, 1058},
	{13840, R_03671C_SQ_PERFCOUNTER7_SELECT, 6, 1058},
	{13863, R_036720_SQ_PERFCOUNTER8_SELECT, 6, 1058},
	{13886, R_036724_SQ_PERFCOUNTER9_SELECT, 6, 1058},
	{13909, R_036728_SQ_PERFCOUNTER10_SELECT, 6, 1058},
	{13933, R_03672C_SQ_PERFCOUNTER11_SELECT, 6, 1058},
	{13957, R_036730_SQ_PERFCOUNTER12_SELECT, 6, 1058},
	{13981, R_036734_SQ_PERFCOUNTER13_SELECT, 6, 1058},
	{14005, R_036738_SQ_PERFCOUNTER14_SELECT, 6, 1058},
	{14029, R_03673C_SQ_PERFCOUNTER15_SELECT, 6, 1058},
	{14053, R_036780_SQ_PERFCOUNTER_CTRL, 9, 1064},
	{14073, R_036784_SQ_PERFCOUNTER_MASK, 2, 1073},
	{14093, R_036788_SQ_PERFCOUNTER_CTRL2, 1, 1075},
	{14114, R_036900_SX_PERFCOUNTER0_SELECT, 3, 1076},
	{14137, R_036904_SX_PERFCOUNTER1_SELECT, 3, 1076},
	{14160, R_036908_SX_PERFCOUNTER2_SELECT, 3, 1076},
	{14183, R_03690C_SX_PERFCOUNTER3_SELECT, 3, 1076},
	{14206, R_036910_SX_PERFCOUNTER0_SELECT1, 2, 1079},
	{14230, R_036914_SX_PERFCOUNTER1_SELECT1},
	{14254, R_036A00_GDS_PERFCOUNTER0_SELECT, 3, 1081},
	{14278, R_036A04_GDS_PERFCOUNTER1_SELECT, 3, 1081},
	{14302, R_036A08_GDS_PERFCOUNTER2_SELECT, 3, 1081},
	{14326, R_036A0C_GDS_PERFCOUNTER3_SELECT, 3, 1081},
	{14350, R_036A10_GDS_PERFCOUNTER0_SELECT1, 2, 1084},
	{14375, R_036B00_TA_PERFCOUNTER0_SELECT, 5, 1086},
	{14398, R_036B04_TA_PERFCOUNTER0_SELECT1, 4, 1091},
	{14422, R_036B08_TA_PERFCOUNTER1_SELECT, 5, 1086},
	{14445, R_036C00_TD_PERFCOUNTER0_SELECT, 5, 1095},
	{14468, R_036C04_TD_PERFCOUNTER0_SELECT1, 4, 1100},
	{14492, R_036C08_TD_PERFCOUNTER1_SELECT, 5, 1095},
	{14515, R_036D00_TCP_PERFCOUNTER0_SELECT, 5, 1104},
	{14539, R_036D04_TCP_PERFCOUNTER0_SELECT1, 4, 1109},
	{14564, R_036D08_TCP_PERFCOUNTER1_SELECT, 5, 1104},
	{14588, R_036D0C_TCP_PERFCOUNTER1_SELECT1},
	{14613, R_036D10_TCP_PERFCOUNTER2_SELECT, 5, 1104},
	{14637, R_036D14_TCP_PERFCOUNTER3_SELECT, 5, 1104},
	{14661, R_036E00_TCC_PERFCOUNTER0_SELECT, 5, 1113},
	{14685, R_036E04_TCC_PERFCOUNTER0_SELECT1, 4, 1118},
	{14710, R_036E08_TCC_PERFCOUNTER1_SELECT, 5, 1113},
	{14734, R_036E0C_TCC_PERFCOUNTER1_SELECT1},
	{14759, R_036E10_TCC_PERFCOUNTER2_SELECT, 5, 1113},
	{14783, R_036E14_TCC_PERFCOUNTER3_SELECT, 5, 1113},
	{14807, R_036E40_TCA_PERFCOUNTER0_SELECT, 5, 1122},
	{14831, R_036E44_TCA_PERFCOUNTER0_SELECT1, 4, 1127},
	{14856, R_036E48_TCA_PERFCOUNTER1_SELECT, 5, 1122},
	{14880, R_036E4C_TCA_PERFCOUNTER1_SELECT1},
	{14905, R_036E50_TCA_PERFCOUNTER2_SELECT, 5, 1122},
	{14929, R_036E54_TCA_PERFCOUNTER3_SELECT, 5, 1122},
	{14953, R_037000_CB_PERFCOUNTER_FILTER, 12, 1131},
	{14975, R_037004_CB_PERFCOUNTER0_SELECT, 5, 1143},
	{14998, R_037008_CB_PERFCOUNTER0_SELECT1, 4, 1148},
	{15022, R_03700C_CB_PERFCOUNTER1_SELECT, 5, 1143},
	{15045, R_037010_CB_PERFCOUNTER2_SELECT, 5, 1143},
	{15068, R_037014_CB_PERFCOUNTER3_SELECT, 5, 1143},
	{15091, R_037100_DB_PERFCOUNTER0_SELECT, 5, 1152},
	{15114, R_037104_DB_PERFCOUNTER0_SELECT1, 4, 1157},
	{15138, R_037108_DB_PERFCOUNTER1_SELECT, 5, 1152},
	{15161, R_03710C_DB_PERFCOUNTER1_SELECT1},
	{15185, R_037110_DB_PERFCOUNTER2_SELECT, 5, 1152},
	{15208, R_037118_DB_PERFCOUNTER3_SELECT, 5, 1152},
	{15231, R_028000_DB_RENDER_CONTROL, 10, 1161},
	{15249, R_028004_DB_COUNT_CONTROL, 9, 1171},
	{15266, R_028008_DB_DEPTH_VIEW, 4, 1180},
	{15280, R_02800C_DB_RENDER_OVERRIDE, 23, 1184},
	{15299, R_028010_DB_RENDER_OVERRIDE2, 15, 1207},
	{15319, R_028014_DB_HTILE_DATA_BASE},
	{15338, R_028020_DB_DEPTH_BOUNDS_MIN},
	{15358, R_028024_DB_DEPTH_BOUNDS_MAX},
	{15378, R_028028_DB_STENCIL_CLEAR, 1, 1222},
	{15395, R_02802C_DB_DEPTH_CLEAR},
	{15410, R_028030_PA_SC_SCREEN_SCISSOR_TL, 2, 1223},
	{15434, R_028034_PA_SC_SCREEN_SCISSOR_BR, 2, 1225},
	{15458, R_02803C_DB_DEPTH_INFO, 7, 1227},
	{15472, R_028040_DB_Z_INFO, 10, 1234},
	{15482, R_028044_DB_STENCIL_INFO, 6, 1244},
	{15498, R_028048_DB_Z_READ_BASE},
	{15513, R_02804C_DB_STENCIL_READ_BASE},
	{15534, R_028050_DB_Z_WRITE_BASE},
	{15550, R_028054_DB_STENCIL_WRITE_BASE},
	{15572, R_028058_DB_DEPTH_SIZE, 2, 1250},
	{15586, R_02805C_DB_DEPTH_SLICE, 1, 1252},
	{15601, R_028080_TA_BC_BASE_ADDR},
	{15617, R_028084_TA_BC_BASE_ADDR_HI, 1, 1253},
	{15636, R_0281E8_COHER_DEST_BASE_HI_0},
	{15657, R_0281EC_COHER_DEST_BASE_HI_1},
	{15678, R_0281F0_COHER_DEST_BASE_HI_2},
	{15699, R_0281F4_COHER_DEST_BASE_HI_3},
	{15720, R_0281F8_COHER_DEST_BASE_2},
	{15738, R_0281FC_COHER_DEST_BASE_3},
	{15756, R_028200_PA_SC_WINDOW_OFFSET, 2, 1254},
	{15776, R_028204_PA_SC_WINDOW_SCISSOR_TL, 3, 1256},
	{15800, R_028208_PA_SC_WINDOW_SCISSOR_BR, 2, 1259},
	{15824, R_02820C_PA_SC_CLIPRECT_RULE, 1, 1261},
	{15844, R_028210_PA_SC_CLIPRECT_0_TL, 2, 1262},
	{15864, R_028214_PA_SC_CLIPRECT_0_BR, 2, 1264},
	{15884, R_028218_PA_SC_CLIPRECT_1_TL, 2, 1262},
	{15904, R_02821C_PA_SC_CLIPRECT_1_BR, 2, 1264},
	{15924, R_028220_PA_SC_CLIPRECT_2_TL, 2, 1262},
	{15944, R_028224_PA_SC_CLIPRECT_2_BR, 2, 1264},
	{15964, R_028228_PA_SC_CLIPRECT_3_TL, 2, 1262},
	{15984, R_02822C_PA_SC_CLIPRECT_3_BR, 2, 1264},
	{16004, R_028230_PA_SC_EDGERULE, 7, 1266},
	{16019, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, 2, 1273},
	{16048, R_028238_CB_TARGET_MASK, 8, 1275},
	{16063, R_02823C_CB_SHADER_MASK, 8, 1283},
	{16078, R_028240_PA_SC_GENERIC_SCISSOR_TL, 3, 1291},
	{16103, R_028244_PA_SC_GENERIC_SCISSOR_BR, 2, 1294},
	{16128, R_028248_COHER_DEST_BASE_0},
	{16146, R_02824C_COHER_DEST_BASE_1},
	{16164, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 3, 1296},
	{16189, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 2, 1299},
	{16214, R_028258_PA_SC_VPORT_SCISSOR_1_TL, 3, 1296},
	{16239, R_02825C_PA_SC_VPORT_SCISSOR_1_BR, 2, 1299},
	{16264, R_028260_PA_SC_VPORT_SCISSOR_2_TL, 3, 1296},
	{16289, R_028264_PA_SC_VPORT_SCISSOR_2_BR, 2, 1299},
	{16314, R_028268_PA_SC_VPORT_SCISSOR_3_TL, 3, 1296},
	{16339, R_02826C_PA_SC_VPORT_SCISSOR_3_BR, 2, 1299},
	{16364, R_028270_PA_SC_VPORT_SCISSOR_4_TL, 3, 1296},
	{16389, R_028274_PA_SC_VPORT_SCISSOR_4_BR, 2, 1299},
	{16414, R_028278_PA_SC_VPORT_SCISSOR_5_TL, 3, 1296},
	{16439, R_02827C_PA_SC_VPORT_SCISSOR_5_BR, 2, 1299},
	{16464, R_028280_PA_SC_VPORT_SCISSOR_6_TL, 3, 1296},
	{16489, R_028284_PA_SC_VPORT_SCISSOR_6_BR, 2, 1299},
	{16514, R_028288_PA_SC_VPORT_SCISSOR_7_TL, 3, 1296},
	{16539, R_02828C_PA_SC_VPORT_SCISSOR_7_BR, 2, 1299},
	{16564, R_028290_PA_SC_VPORT_SCISSOR_8_TL, 3, 1296},
	{16589, R_028294_PA_SC_VPORT_SCISSOR_8_BR, 2, 1299},
	{16614, R_028298_PA_SC_VPORT_SCISSOR_9_TL, 3, 1296},
	{16639, R_02829C_PA_SC_VPORT_SCISSOR_9_BR, 2, 1299},
	{16664, R_0282A0_PA_SC_VPORT_SCISSOR_10_TL, 3, 1296},
	{16690, R_0282A4_PA_SC_VPORT_SCISSOR_10_BR, 2, 1299},
	{16716, R_0282A8_PA_SC_VPORT_SCISSOR_11_TL, 3, 1296},
	{16742, R_0282AC_PA_SC_VPORT_SCISSOR_11_BR, 2, 1299},
	{16768, R_0282B0_PA_SC_VPORT_SCISSOR_12_TL, 3, 1296},
	{16794, R_0282B4_PA_SC_VPORT_SCISSOR_12_BR, 2, 1299},
	{16820, R_0282B8_PA_SC_VPORT_SCISSOR_13_TL, 3, 1296},
	{16846, R_0282BC_PA_SC_VPORT_SCISSOR_13_BR, 2, 1299},
	{16872, R_0282C0_PA_SC_VPORT_SCISSOR_14_TL, 3, 1296},
	{16898, R_0282C4_PA_SC_VPORT_SCISSOR_14_BR, 2, 1299},
	{16924, R_0282C8_PA_SC_VPORT_SCISSOR_15_TL, 3, 1296},
	{16950, R_0282CC_PA_SC_VPORT_SCISSOR_15_BR, 2, 1299},
	{16976, R_0282D0_PA_SC_VPORT_ZMIN_0},
	{16995, R_0282D4_PA_SC_VPORT_ZMAX_0},
	{17014, R_0282D8_PA_SC_VPORT_ZMIN_1},
	{17033, R_0282DC_PA_SC_VPORT_ZMAX_1},
	{17052, R_0282E0_PA_SC_VPORT_ZMIN_2},
	{17071, R_0282E4_PA_SC_VPORT_ZMAX_2},
	{17090, R_0282E8_PA_SC_VPORT_ZMIN_3},
	{17109, R_0282EC_PA_SC_VPORT_ZMAX_3},
	{17128, R_0282F0_PA_SC_VPORT_ZMIN_4},
	{17147, R_0282F4_PA_SC_VPORT_ZMAX_4},
	{17166, R_0282F8_PA_SC_VPORT_ZMIN_5},
	{17185, R_0282FC_PA_SC_VPORT_ZMAX_5},
	{17204, R_028300_PA_SC_VPORT_ZMIN_6},
	{17223, R_028304_PA_SC_VPORT_ZMAX_6},
	{17242, R_028308_PA_SC_VPORT_ZMIN_7},
	{17261, R_02830C_PA_SC_VPORT_ZMAX_7},
	{17280, R_028310_PA_SC_VPORT_ZMIN_8},
	{17299, R_028314_PA_SC_VPORT_ZMAX_8},
	{17318, R_028318_PA_SC_VPORT_ZMIN_9},
	{17337, R_02831C_PA_SC_VPORT_ZMAX_9},
	{17356, R_028320_PA_SC_VPORT_ZMIN_10},
	{17376, R_028324_PA_SC_VPORT_ZMAX_10},
	{17396, R_028328_PA_SC_VPORT_ZMIN_11},
	{17416, R_02832C_PA_SC_VPORT_ZMAX_11},
	{17436, R_028330_PA_SC_VPORT_ZMIN_12},
	{17456, R_028334_PA_SC_VPORT_ZMAX_12},
	{17476, R_028338_PA_SC_VPORT_ZMIN_13},
	{17496, R_02833C_PA_SC_VPORT_ZMAX_13},
	{17516, R_028340_PA_SC_VPORT_ZMIN_14},
	{17536, R_028344_PA_SC_VPORT_ZMAX_14},
	{17556, R_028348_PA_SC_VPORT_ZMIN_15},
	{17576, R_02834C_PA_SC_VPORT_ZMAX_15},
	{17596, R_028350_PA_SC_RASTER_CONFIG, 15, 1301},
	{17616, R_028354_PA_SC_RASTER_CONFIG_1, 3, 1316},
	{17638, R_028358_PA_SC_SCREEN_EXTENT_CONTROL, 2, 1319},
	{17666, R_028400_VGT_MAX_VTX_INDX},
	{17683, R_028404_VGT_MIN_VTX_INDX},
	{17700, R_028408_VGT_INDX_OFFSET},
	{17716, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{17745, R_028414_CB_BLEND_RED},
	{17758, R_028418_CB_BLEND_GREEN},
	{17773, R_02841C_CB_BLEND_BLUE},
	{17787, R_028420_CB_BLEND_ALPHA},
	{17802, R_028424_CB_DCC_CONTROL, 3, 1321},
	{17817, R_02842C_DB_STENCIL_CONTROL, 6, 1324},
	{17836, R_028430_DB_STENCILREFMASK, 4, 1330},
	{17854, R_028434_DB_STENCILREFMASK_BF, 4, 1334},
	{17875, R_02843C_PA_CL_VPORT_XSCALE},
	{17894, R_028440_PA_CL_VPORT_XOFFSET},
	{17914, R_028444_PA_CL_VPORT_YSCALE},
	{17933, R_028448_PA_CL_VPORT_YOFFSET},
	{17953, R_02844C_PA_CL_VPORT_ZSCALE},
	{17972, R_028450_PA_CL_VPORT_ZOFFSET},
	{17992, R_028454_PA_CL_VPORT_XSCALE_1},
	{18013, R_028458_PA_CL_VPORT_XOFFSET_1},
	{18035, R_02845C_PA_CL_VPORT_YSCALE_1},
	{18056, R_028460_PA_CL_VPORT_YOFFSET_1},
	{18078, R_028464_PA_CL_VPORT_ZSCALE_1},
	{18099, R_028468_PA_CL_VPORT_ZOFFSET_1},
	{18121, R_02846C_PA_CL_VPORT_XSCALE_2},
	{18142, R_028470_PA_CL_VPORT_XOFFSET_2},
	{18164, R_028474_PA_CL_VPORT_YSCALE_2},
	{18185, R_028478_PA_CL_VPORT_YOFFSET_2},
	{18207, R_02847C_PA_CL_VPORT_ZSCALE_2},
	{18228, R_028480_PA_CL_VPORT_ZOFFSET_2},
	{18250, R_028484_PA_CL_VPORT_XSCALE_3},
	{18271, R_028488_PA_CL_VPORT_XOFFSET_3},
	{18293, R_02848C_PA_CL_VPORT_YSCALE_3},
	{18314, R_028490_PA_CL_VPORT_YOFFSET_3},
	{18336, R_028494_PA_CL_VPORT_ZSCALE_3},
	{18357, R_028498_PA_CL_VPORT_ZOFFSET_3},
	{18379, R_02849C_PA_CL_VPORT_XSCALE_4},
	{18400, R_0284A0_PA_CL_VPORT_XOFFSET_4},
	{18422, R_0284A4_PA_CL_VPORT_YSCALE_4},
	{18443, R_0284A8_PA_CL_VPORT_YOFFSET_4},
	{18465, R_0284AC_PA_CL_VPORT_ZSCALE_4},
	{18486, R_0284B0_PA_CL_VPORT_ZOFFSET_4},
	{18508, R_0284B4_PA_CL_VPORT_XSCALE_5},
	{18529, R_0284B8_PA_CL_VPORT_XOFFSET_5},
	{18551, R_0284BC_PA_CL_VPORT_YSCALE_5},
	{18572, R_0284C0_PA_CL_VPORT_YOFFSET_5},
	{18594, R_0284C4_PA_CL_VPORT_ZSCALE_5},
	{18615, R_0284C8_PA_CL_VPORT_ZOFFSET_5},
	{18637, R_0284CC_PA_CL_VPORT_XSCALE_6},
	{18658, R_0284D0_PA_CL_VPORT_XOFFSET_6},
	{18680, R_0284D4_PA_CL_VPORT_YSCALE_6},
	{18701, R_0284D8_PA_CL_VPORT_YOFFSET_6},
	{18723, R_0284DC_PA_CL_VPORT_ZSCALE_6},
	{18744, R_0284E0_PA_CL_VPORT_ZOFFSET_6},
	{18766, R_0284E4_PA_CL_VPORT_XSCALE_7},
	{18787, R_0284E8_PA_CL_VPORT_XOFFSET_7},
	{18809, R_0284EC_PA_CL_VPORT_YSCALE_7},
	{18830, R_0284F0_PA_CL_VPORT_YOFFSET_7},
	{18852, R_0284F4_PA_CL_VPORT_ZSCALE_7},
	{18873, R_0284F8_PA_CL_VPORT_ZOFFSET_7},
	{18895, R_0284FC_PA_CL_VPORT_XSCALE_8},
	{18916, R_028500_PA_CL_VPORT_XOFFSET_8},
	{18938, R_028504_PA_CL_VPORT_YSCALE_8},
	{18959, R_028508_PA_CL_VPORT_YOFFSET_8},
	{18981, R_02850C_PA_CL_VPORT_ZSCALE_8},
	{19002, R_028510_PA_CL_VPORT_ZOFFSET_8},
	{19024, R_028514_PA_CL_VPORT_XSCALE_9},
	{19045, R_028518_PA_CL_VPORT_XOFFSET_9},
	{19067, R_02851C_PA_CL_VPORT_YSCALE_9},
	{19088, R_028520_PA_CL_VPORT_YOFFSET_9},
	{19110, R_028524_PA_CL_VPORT_ZSCALE_9},
	{19131, R_028528_PA_CL_VPORT_ZOFFSET_9},
	{19153, R_02852C_PA_CL_VPORT_XSCALE_10},
	{19175, R_028530_PA_CL_VPORT_XOFFSET_10},
	{19198, R_028534_PA_CL_VPORT_YSCALE_10},
	{19220, R_028538_PA_CL_VPORT_YOFFSET_10},
	{19243, R_02853C_PA_CL_VPORT_ZSCALE_10},
	{19265, R_028540_PA_CL_VPORT_ZOFFSET_10},
	{19288, R_028544_PA_CL_VPORT_XSCALE_11},
	{19310, R_028548_PA_CL_VPORT_XOFFSET_11},
	{19333, R_02854C_PA_CL_VPORT_YSCALE_11},
	{19355, R_028550_PA_CL_VPORT_YOFFSET_11},
	{19378, R_028554_PA_CL_VPORT_ZSCALE_11},
	{19400, R_028558_PA_CL_VPORT_ZOFFSET_11},
	{19423, R_02855C_PA_CL_VPORT_XSCALE_12},
	{19445, R_028560_PA_CL_VPORT_XOFFSET_12},
	{19468, R_028564_PA_CL_VPORT_YSCALE_12},
	{19490, R_028568_PA_CL_VPORT_YOFFSET_12},
	{19513, R_02856C_PA_CL_VPORT_ZSCALE_12},
	{19535, R_028570_PA_CL_VPORT_ZOFFSET_12},
	{19558, R_028574_PA_CL_VPORT_XSCALE_13},
	{19580, R_028578_PA_CL_VPORT_XOFFSET_13},
	{19603, R_02857C_PA_CL_VPORT_YSCALE_13},
	{19625, R_028580_PA_CL_VPORT_YOFFSET_13},
	{19648, R_028584_PA_CL_VPORT_ZSCALE_13},
	{19670, R_028588_PA_CL_VPORT_ZOFFSET_13},
	{19693, R_02858C_PA_CL_VPORT_XSCALE_14},
	{19715, R_028590_PA_CL_VPORT_XOFFSET_14},
	{19738, R_028594_PA_CL_VPORT_YSCALE_14},
	{19760, R_028598_PA_CL_VPORT_YOFFSET_14},
	{19783, R_02859C_PA_CL_VPORT_ZSCALE_14},
	{19805, R_0285A0_PA_CL_VPORT_ZOFFSET_14},
	{19828, R_0285A4_PA_CL_VPORT_XSCALE_15},
	{19850, R_0285A8_PA_CL_VPORT_XOFFSET_15},
	{19873, R_0285AC_PA_CL_VPORT_YSCALE_15},
	{19895, R_0285B0_PA_CL_VPORT_YOFFSET_15},
	{19918, R_0285B4_PA_CL_VPORT_ZSCALE_15},
	{19940, R_0285B8_PA_CL_VPORT_ZOFFSET_15},
	{19963, R_0285BC_PA_CL_UCP_0_X},
	{19977, R_0285C0_PA_CL_UCP_0_Y},
	{19991, R_0285C4_PA_CL_UCP_0_Z},
	{20005, R_0285C8_PA_CL_UCP_0_W},
	{20019, R_0285CC_PA_CL_UCP_1_X},
	{20033, R_0285D0_PA_CL_UCP_1_Y},
	{20047, R_0285D4_PA_CL_UCP_1_Z},
	{20061, R_0285D8_PA_CL_UCP_1_W},
	{20075, R_0285DC_PA_CL_UCP_2_X},
	{20089, R_0285E0_PA_CL_UCP_2_Y},
	{20103, R_0285E4_PA_CL_UCP_2_Z},
	{20117, R_0285E8_PA_CL_UCP_2_W},
	{20131, R_0285EC_PA_CL_UCP_3_X},
	{20145, R_0285F0_PA_CL_UCP_3_Y},
	{20159, R_0285F4_PA_CL_UCP_3_Z},
	{20173, R_0285F8_PA_CL_UCP_3_W},
	{20187, R_0285FC_PA_CL_UCP_4_X},
	{20201, R_028600_PA_CL_UCP_4_Y},
	{20215, R_028604_PA_CL_UCP_4_Z},
	{20229, R_028608_PA_CL_UCP_4_W},
	{20243, R_02860C_PA_CL_UCP_5_X},
	{20257, R_028610_PA_CL_UCP_5_Y},
	{20271, R_028614_PA_CL_UCP_5_Z},
	{20285, R_028618_PA_CL_UCP_5_W},
	{20299, R_028644_SPI_PS_INPUT_CNTL_0, 12, 1338},
	{20319, R_028648_SPI_PS_INPUT_CNTL_1, 12, 1338},
	{20339, R_02864C_SPI_PS_INPUT_CNTL_2, 12, 1338},
	{20359, R_028650_SPI_PS_INPUT_CNTL_3, 12, 1338},
	{20379, R_028654_SPI_PS_INPUT_CNTL_4, 12, 1338},
	{20399, R_028658_SPI_PS_INPUT_CNTL_5, 12, 1338},
	{20419, R_02865C_SPI_PS_INPUT_CNTL_6, 12, 1338},
	{20439, R_028660_SPI_PS_INPUT_CNTL_7, 12, 1338},
	{20459, R_028664_SPI_PS_INPUT_CNTL_8, 12, 1338},
	{20479, R_028668_SPI_PS_INPUT_CNTL_9, 12, 1338},
	{20499, R_02866C_SPI_PS_INPUT_CNTL_10, 12, 1338},
	{20520, R_028670_SPI_PS_INPUT_CNTL_11, 12, 1338},
	{20541, R_028674_SPI_PS_INPUT_CNTL_12, 12, 1338},
	{20562, R_028678_SPI_PS_INPUT_CNTL_13, 12, 1338},
	{20583, R_02867C_SPI_PS_INPUT_CNTL_14, 12, 1338},
	{20604, R_028680_SPI_PS_INPUT_CNTL_15, 12, 1338},
	{20625, R_028684_SPI_PS_INPUT_CNTL_16, 12, 1338},
	{20646, R_028688_SPI_PS_INPUT_CNTL_17, 12, 1338},
	{20667, R_02868C_SPI_PS_INPUT_CNTL_18, 12, 1338},
	{20688, R_028690_SPI_PS_INPUT_CNTL_19, 12, 1338},
	{20709, R_028694_SPI_PS_INPUT_CNTL_20, 12, 1338},
	{20730, R_028698_SPI_PS_INPUT_CNTL_21, 12, 1338},
	{20751, R_02869C_SPI_PS_INPUT_CNTL_22, 12, 1338},
	{20772, R_0286A0_SPI_PS_INPUT_CNTL_23, 12, 1338},
	{20793, R_0286A4_SPI_PS_INPUT_CNTL_24, 12, 1338},
	{20814, R_0286A8_SPI_PS_INPUT_CNTL_25, 12, 1338},
	{20835, R_0286AC_SPI_PS_INPUT_CNTL_26, 12, 1338},
	{20856, R_0286B0_SPI_PS_INPUT_CNTL_27, 12, 1338},
	{20877, R_0286B4_SPI_PS_INPUT_CNTL_28, 12, 1338},
	{20898, R_0286B8_SPI_PS_INPUT_CNTL_29, 12, 1338},
	{20919, R_0286BC_SPI_PS_INPUT_CNTL_30, 12, 1338},
	{20940, R_0286C0_SPI_PS_INPUT_CNTL_31, 12, 1338},
	{20961, R_0286C4_SPI_VS_OUT_CONFIG, 4, 1350},
	{20979, R_0286CC_SPI_PS_INPUT_ENA, 16, 1354},
	{20996, R_0286D0_SPI_PS_INPUT_ADDR, 16, 1370},
	{21014, R_0286D4_SPI_INTERP_CONTROL_0, 7, 1386},
	{21035, R_0286D8_SPI_PS_IN_CONTROL, 5, 1393},
	{21053, R_0286E0_SPI_BARYC_CNTL, 7, 1398},
	{21068, R_0286E8_SPI_TMPRING_SIZE, 2, 1405},
	{21085, R_028704_SPI_WAVE_MGMT_1, 5, 1407},
	{21101, R_028708_SPI_WAVE_MGMT_2, 1, 1412},
	{21117, R_02870C_SPI_SHADER_POS_FORMAT, 4, 1413},
	{21139, R_028710_SPI_SHADER_Z_FORMAT, 1, 1417},
	{21159, R_028714_SPI_SHADER_COL_FORMAT, 8, 1418},
	{21181, R_028754_SX_PS_DOWNCONVERT, 8, 1426},
	{21199, R_028758_SX_BLEND_OPT_EPSILON, 8, 1434},
	{21220, R_02875C_SX_BLEND_OPT_CONTROL, 17, 1442},
	{21241, R_028760_SX_MRT0_BLEND_OPT, 6, 1459},
	{21259, R_028764_SX_MRT1_BLEND_OPT, 6, 1465},
	{21277, R_028768_SX_MRT2_BLEND_OPT, 6, 1471},
	{21295, R_02876C_SX_MRT3_BLEND_OPT, 6, 1477},
	{21313, R_028770_SX_MRT4_BLEND_OPT, 6, 1483},
	{21331, R_028774_SX_MRT5_BLEND_OPT, 6, 1489},
	{21349, R_028778_SX_MRT6_BLEND_OPT, 6, 1495},
	{21367, R_02877C_SX_MRT7_BLEND_OPT, 6, 1501},
	{21385, R_028780_CB_BLEND0_CONTROL, 9, 1507},
	{21403, R_028784_CB_BLEND1_CONTROL, 9, 1507},
	{21421, R_028788_CB_BLEND2_CONTROL, 9, 1507},
	{21439, R_02878C_CB_BLEND3_CONTROL, 9, 1507},
	{21457, R_028790_CB_BLEND4_CONTROL, 9, 1507},
	{21475, R_028794_CB_BLEND5_CONTROL, 9, 1507},
	{21493, R_028798_CB_BLEND6_CONTROL, 9, 1507},
	{21511, R_02879C_CB_BLEND7_CONTROL, 9, 1507},
	{21529, R_0287CC_CS_COPY_STATE, 1, 1516},
	{21543, R_0287D4_PA_CL_POINT_X_RAD},
	{21561, R_0287D8_PA_CL_POINT_Y_RAD},
	{21579, R_0287DC_PA_CL_POINT_SIZE},
	{21596, R_0287E0_PA_CL_POINT_CULL_RAD},
	{21617, R_0287E4_VGT_DMA_BASE_HI, 1, 1517},
	{21633, R_0287E8_VGT_DMA_BASE},
	{21646, R_0287F0_VGT_DRAW_INITIATOR, 4, 1518},
	{21665, R_0287F4_VGT_IMMED_DATA},
	{21680, R_0287F8_VGT_EVENT_ADDRESS_REG, 1, 1522},
	{21702, R_028800_DB_DEPTH_CONTROL, 10, 1523},
	{21719, R_028804_DB_EQAA, 12, 1533},
	{21727, R_028808_CB_COLOR_CONTROL, 4, 1545},
	{21744, R_02880C_DB_SHADER_CONTROL, 13, 1549},
	{21762, R_028810_PA_CL_CLIP_CNTL, 19, 1562},
	{21778, R_028814_PA_SU_SC_MODE_CNTL, 13, 1581},
	{21797, R_028818_PA_CL_VTE_CNTL, 9, 1594},
	{21812, R_02881C_PA_CL_VS_OUT_CNTL, 27, 1603},
	{21830, R_028820_PA_CL_NANINF_CNTL, 16, 1630},
	{21848, R_028824_PA_SU_LINE_STIPPLE_CNTL, 4, 1646},
	{21872, R_028828_PA_SU_LINE_STIPPLE_SCALE},
	{21897, R_02882C_PA_SU_PRIM_FILTER_CNTL, 11, 1650},
	{21920, R_028830_PA_SU_SMALL_PRIM_FILTER_CNTL, 5, 1661},
	{21949, R_028A00_PA_SU_POINT_SIZE, 2, 1666},
	{21966, R_028A04_PA_SU_POINT_MINMAX, 2, 1668},
	{21985, R_028A08_PA_SU_LINE_CNTL, 1, 1670},
	{22001, R_028A0C_PA_SC_LINE_STIPPLE, 4, 1671},
	{22020, R_028A10_VGT_OUTPUT_PATH_CNTL, 1, 1675},
	{22041, R_028A14_VGT_HOS_CNTL, 1, 1676},
	{22054, R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{22077, R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{22100, R_028A20_VGT_HOS_REUSE_DEPTH, 1, 1677},
	{22120, R_028A24_VGT_GROUP_PRIM_TYPE, 4, 1678},
	{22140, R_028A28_VGT_GROUP_FIRST_DECR, 1, 1682},
	{22161, R_028A2C_VGT_GROUP_DECR, 1, 1683},
	{22176, R_028A30_VGT_GROUP_VECT_0_CNTL, 6, 1684},
	{22198, R_028A34_VGT_GROUP_VECT_1_CNTL, 6, 1690},
	{22220, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, 8, 1696},
	{22246, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, 8, 1704},
	{22272, R_028A40_VGT_GS_MODE, 15, 1712},
	{22284, R_028A44_VGT_GS_ONCHIP_CNTL, 2, 1727},
	{22303, R_028A48_PA_SC_MODE_CNTL_0, 4, 1729},
	{22321, R_028A4C_PA_SC_MODE_CNTL_1, 24, 1733},
	{22339, R_028A50_VGT_ENHANCE},
	{22351, R_028A54_VGT_GS_PER_ES, 1, 1757},
	{22365, R_028A58_VGT_ES_PER_GS, 1, 1758},
	{22379, R_028A5C_VGT_GS_PER_VS, 1, 1759},
	{22393, R_028A60_VGT_GSVS_RING_OFFSET_1, 1, 1760},
	{22416, R_028A64_VGT_GSVS_RING_OFFSET_2, 1, 1761},
	{22439, R_028A68_VGT_GSVS_RING_OFFSET_3, 1, 1762},
	{22462, R_028A6C_VGT_GS_OUT_PRIM_TYPE, 5, 1763},
	{22483, R_028A70_IA_ENHANCE},
	{22494, R_028A74_VGT_DMA_SIZE},
	{22507, R_028A78_VGT_DMA_MAX_SIZE},
	{22524, R_028A7C_VGT_DMA_INDEX_TYPE, 9, 1768},
	{22543, R_028A80_WD_ENHANCE},
	{22554, R_028A84_VGT_PRIMITIVEID_EN, 2, 1777},
	{22573, R_028A88_VGT_DMA_NUM_INSTANCES},
	{22595, R_028A8C_VGT_PRIMITIVEID_RESET},
	{22617, R_028A90_VGT_EVENT_INITIATOR, 3, 1779},
	{22637, R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, 1, 1782},
	{22664, R_028AA0_VGT_INSTANCE_STEP_RATE_0},
	{22689, R_028AA4_VGT_INSTANCE_STEP_RATE_1},
	{22714, R_028AA8_IA_MULTI_VGT_PARAM, 7, 1783},
	{22733, R_028AAC_VGT_ESGS_RING_ITEMSIZE, 1, 1790},
	{22756, R_028AB0_VGT_GSVS_RING_ITEMSIZE, 1, 1791},
	{22779, R_028AB4_VGT_REUSE_OFF, 1, 1792},
	{22793, R_028AB8_VGT_VTX_CNT_EN, 1, 1793},
	{22808, R_028ABC_DB_HTILE_SURFACE, 8, 1794},
	{22825, R_028AC0_DB_SRESULTS_COMPARE_STATE0, 4, 1802},
	{22852, R_028AC4_DB_SRESULTS_COMPARE_STATE1, 4, 1806},
	{22879, R_028AC8_DB_PRELOAD_CONTROL, 4, 1810},
	{22898, R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{22924, R_028AD4_VGT_STRMOUT_VTX_STRIDE_0, 1, 1814},
	{22949, R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{22977, R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{23003, R_028AE4_VGT_STRMOUT_VTX_STRIDE_1, 1, 1815},
	{23028, R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{23056, R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{23082, R_028AF4_VGT_STRMOUT_VTX_STRIDE_2, 1, 1816},
	{23107, R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{23135, R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{23161, R_028B04_VGT_STRMOUT_VTX_STRIDE_3, 1, 1817},
	{23186, R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{23214, R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{23245, R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{23288, R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE, 1, 1818},
	{23326, R_028B38_VGT_GS_MAX_VERT_OUT, 1, 1819},
	{23346, R_028B50_VGT_TESS_DISTRIBUTION, 5, 1820},
	{23368, R_028B54_VGT_SHADER_STAGES_EN, 10, 1825},
	{23389, R_028B58_VGT_LS_HS_CONFIG, 3, 1835},
	{23406, R_028B5C_VGT_GS_VERT_ITEMSIZE, 1, 1838},
	{23427, R_028B60_VGT_GS_VERT_ITEMSIZE_1, 1, 1839},
	{23450, R_028B64_VGT_GS_VERT_ITEMSIZE_2, 1, 1840},
	{23473, R_028B68_VGT_GS_VERT_ITEMSIZE_3, 1, 1841},
	{23496, R_028B6C_VGT_TF_PARAM, 11, 1842},
	{23509, R_028B70_DB_ALPHA_TO_MASK, 6, 1853},
	{23526, R_028B74_VGT_DISPATCH_DRAW_INDEX},
	{23550, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 2, 1859},
	{23580, R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{23604, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE},
	{23634, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET},
	{23665, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE},
	{23694, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET},
	{23724, R_028B90_VGT_GS_INSTANCE_CNT, 2, 1861},
	{23744, R_028B94_VGT_STRMOUT_CONFIG, 7, 1863},
	{23763, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 4, 1870},
	{23789, R_028BD4_PA_SC_CENTROID_PRIORITY_0, 8, 1874},
	{23815, R_028BD8_PA_SC_CENTROID_PRIORITY_1, 8, 1882},
	{23841, R_028BDC_PA_SC_LINE_CNTL, 4, 1890},
	{23857, R_028BE0_PA_SC_AA_CONFIG, 5, 1894},
	{23873, R_028BE4_PA_SU_VTX_CNTL, 3, 1899},
	{23888, R_028BE8_PA_CL_GB_VERT_CLIP_ADJ},
	{23911, R_028BEC_PA_CL_GB_VERT_DISC_ADJ},
	{23934, R_028BF0_PA_CL_GB_HORZ_CLIP_ADJ},
	{23957, R_028BF4_PA_CL_GB_HORZ_DISC_ADJ},
	{23980, R_028BF8_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0, 8, 1902},
	{24014, R_028BFC_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1, 8, 1910},
	{24048, R_028C00_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2, 8, 1918},
	{24082, R_028C04_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3, 8, 1926},
	{24116, R_028C08_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0, 8, 1934},
	{24150, R_028C0C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1, 8, 1942},
	{24184, R_028C10_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2, 8, 1950},
	{24218, R_028C14_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3, 8, 1958},
	{24252, R_028C18_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0, 8, 1966},
	{24286, R_028C1C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1, 8, 1974},
	{24320, R_028C20_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2, 8, 1982},
	{24354, R_028C24_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3, 8, 1990},
	{24388, R_028C28_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0, 8, 1998},
	{24422, R_028C2C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1, 8, 2006},
	{24456, R_028C30_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2, 8, 2014},
	{24490, R_028C34_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3, 8, 2022},
	{24524, R_028C38_PA_SC_AA_MASK_X0Y0_X1Y0, 2, 2030},
	{24548, R_028C3C_PA_SC_AA_MASK_X0Y1_X1Y1, 2, 2032},
	{24572, R_028C40_PA_SC_SHADER_CONTROL, 1, 2034},
	{24593, R_028C58_VGT_VERTEX_REUSE_BLOCK_CNTL, 1, 2035},
	{24621, R_028C5C_VGT_OUT_DEALLOC_CNTL, 1, 2036},
	{24642, R_028C60_CB_COLOR0_BASE},
	{24657, R_028C64_CB_COLOR0_PITCH, 2, 2037},
	{24673, R_028C68_CB_COLOR0_SLICE, 1, 2039},
	{24689, R_028C6C_CB_COLOR0_VIEW, 2, 2040},
	{24704, R_028C70_CB_COLOR0_INFO, 18, 2042},
	{24719, R_028C74_CB_COLOR0_ATTRIB, 6, 2060},
	{24736, R_028C78_CB_COLOR0_DCC_CONTROL, 9, 2066},
	{24758, R_028C7C_CB_COLOR0_CMASK},
	{24774, R_028C80_CB_COLOR0_CMASK_SLICE, 1, 2075},
	{24796, R_028C84_CB_COLOR0_FMASK},
	{24812, R_028C88_CB_COLOR0_FMASK_SLICE, 1, 2076},
	{24834, R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{24856, R_028C90_CB_COLOR0_CLEAR_WORD1},
	{24878, R_028C94_CB_COLOR0_DCC_BASE},
	{24897, R_028C9C_CB_COLOR1_BASE},
	{24912, R_028CA0_CB_COLOR1_PITCH, 2, 2037},
	{24928, R_028CA4_CB_COLOR1_SLICE, 1, 2039},
	{24944, R_028CA8_CB_COLOR1_VIEW, 2, 2040},
	{24959, R_028CAC_CB_COLOR1_INFO, 18, 2042},
	{24974, R_028CB0_CB_COLOR1_ATTRIB, 6, 2060},
	{24991, R_028CB4_CB_COLOR1_DCC_CONTROL, 9, 2066},
	{25013, R_028CB8_CB_COLOR1_CMASK},
	{25029, R_028CBC_CB_COLOR1_CMASK_SLICE, 1, 2075},
	{25051, R_028CC0_CB_COLOR1_FMASK},
	{25067, R_028CC4_CB_COLOR1_FMASK_SLICE, 1, 2076},
	{25089, R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{25111, R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{25133, R_028CD0_CB_COLOR1_DCC_BASE},
	{25152, R_028CD8_CB_COLOR2_BASE},
	{25167, R_028CDC_CB_COLOR2_PITCH, 2, 2037},
	{25183, R_028CE0_CB_COLOR2_SLICE, 1, 2039},
	{25199, R_028CE4_CB_COLOR2_VIEW, 2, 2040},
	{25214, R_028CE8_CB_COLOR2_INFO, 18, 2042},
	{25229, R_028CEC_CB_COLOR2_ATTRIB, 6, 2060},
	{25246, R_028CF0_CB_COLOR2_DCC_CONTROL, 9, 2066},
	{25268, R_028CF4_CB_COLOR2_CMASK},
	{25284, R_028CF8_CB_COLOR2_CMASK_SLICE, 1, 2075},
	{25306, R_028CFC_CB_COLOR2_FMASK},
	{25322, R_028D00_CB_COLOR2_FMASK_SLICE, 1, 2076},
	{25344, R_028D04_CB_COLOR2_CLEAR_WORD0},
	{25366, R_028D08_CB_COLOR2_CLEAR_WORD1},
	{25388, R_028D0C_CB_COLOR2_DCC_BASE},
	{25407, R_028D14_CB_COLOR3_BASE},
	{25422, R_028D18_CB_COLOR3_PITCH, 2, 2037},
	{25438, R_028D1C_CB_COLOR3_SLICE, 1, 2039},
	{25454, R_028D20_CB_COLOR3_VIEW, 2, 2040},
	{25469, R_028D24_CB_COLOR3_INFO, 18, 2042},
	{25484, R_028D28_CB_COLOR3_ATTRIB, 6, 2060},
	{25501, R_028D2C_CB_COLOR3_DCC_CONTROL, 9, 2066},
	{25523, R_028D30_CB_COLOR3_CMASK},
	{25539, R_028D34_CB_COLOR3_CMASK_SLICE, 1, 2075},
	{25561, R_028D38_CB_COLOR3_FMASK},
	{25577, R_028D3C_CB_COLOR3_FMASK_SLICE, 1, 2076},
	{25599, R_028D40_CB_COLOR3_CLEAR_WORD0},
	{25621, R_028D44_CB_COLOR3_CLEAR_WORD1},
	{25643, R_028D48_CB_COLOR3_DCC_BASE},
	{25662, R_028D50_CB_COLOR4_BASE},
	{25677, R_028D54_CB_COLOR4_PITCH, 2, 2037},
	{25693, R_028D58_CB_COLOR4_SLICE, 1, 2039},
	{25709, R_028D5C_CB_COLOR4_VIEW, 2, 2040},
	{25724, R_028D60_CB_COLOR4_INFO, 18, 2042},
	{25739, R_028D64_CB_COLOR4_ATTRIB, 6, 2060},
	{25756, R_028D68_CB_COLOR4_DCC_CONTROL, 9, 2066},
	{25778, R_028D6C_CB_COLOR4_CMASK},
	{25794, R_028D70_CB_COLOR4_CMASK_SLICE, 1, 2075},
	{25816, R_028D74_CB_COLOR4_FMASK},
	{25832, R_028D78_CB_COLOR4_FMASK_SLICE, 1, 2076},
	{25854, R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{25876, R_028D80_CB_COLOR4_CLEAR_WORD1},
	{25898, R_028D84_CB_COLOR4_DCC_BASE},
	{25917, R_028D8C_CB_COLOR5_BASE},
	{25932, R_028D90_CB_COLOR5_PITCH, 2, 2037},
	{25948, R_028D94_CB_COLOR5_SLICE, 1, 2039},
	{25964, R_028D98_CB_COLOR5_VIEW, 2, 2040},
	{25979, R_028D9C_CB_COLOR5_INFO, 18, 2042},
	{25994, R_028DA0_CB_COLOR5_ATTRIB, 6, 2060},
	{26011, R_028DA4_CB_COLOR5_DCC_CONTROL, 9, 2066},
	{26033, R_028DA8_CB_COLOR5_CMASK},
	{26049, R_028DAC_CB_COLOR5_CMASK_SLICE, 1, 2075},
	{26071, R_028DB0_CB_COLOR5_FMASK},
	{26087, R_028DB4_CB_COLOR5_FMASK_SLICE, 1, 2076},
	{26109, R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{26131, R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{26153, R_028DC0_CB_COLOR5_DCC_BASE},
	{26172, R_028DC8_CB_COLOR6_BASE},
	{26187, R_028DCC_CB_COLOR6_PITCH, 2, 2037},
	{26203, R_028DD0_CB_COLOR6_SLICE, 1, 2039},
	{26219, R_028DD4_CB_COLOR6_VIEW, 2, 2040},
	{26234, R_028DD8_CB_COLOR6_INFO, 18, 2042},
	{26249, R_028DDC_CB_COLOR6_ATTRIB, 6, 2060},
	{26266, R_028DE0_CB_COLOR6_DCC_CONTROL, 9, 2066},
	{26288, R_028DE4_CB_COLOR6_CMASK},
	{26304, R_028DE8_CB_COLOR6_CMASK_SLICE, 1, 2075},
	{26326, R_028DEC_CB_COLOR6_FMASK},
	{26342, R_028DF0_CB_COLOR6_FMASK_SLICE, 1, 2076},
	{26364, R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{26386, R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{26408, R_028DFC_CB_COLOR6_DCC_BASE},
	{26427, R_028E04_CB_COLOR7_BASE},
	{26442, R_028E08_CB_COLOR7_PITCH, 2, 2037},
	{26458, R_028E0C_CB_COLOR7_SLICE, 1, 2039},
	{26474, R_028E10_CB_COLOR7_VIEW, 2, 2040},
	{26489, R_028E14_CB_COLOR7_INFO, 18, 2042},
	{26504, R_028E18_CB_COLOR7_ATTRIB, 6, 2060},
	{26521, R_028E1C_CB_COLOR7_DCC_CONTROL, 9, 2066},
	{26543, R_028E20_CB_COLOR7_CMASK},
	{26559, R_028E24_CB_COLOR7_CMASK_SLICE, 1, 2075},
	{26581, R_028E28_CB_COLOR7_FMASK},
	{26597, R_028E2C_CB_COLOR7_FMASK_SLICE, 1, 2076},
	{26619, R_028E30_CB_COLOR7_CLEAR_WORD0},
	{26641, R_028E34_CB_COLOR7_CLEAR_WORD1},
	{26663, R_028E38_CB_COLOR7_DCC_BASE},
};

static const struct si_reg gfx9d_reg_table[] = {
	{1059, R_008008_GRBM_STATUS2, 25, 2077},
	{1072, R_008010_GRBM_STATUS, 24, 2102},
	{1157, R_008014_GRBM_STATUS_SE0, 12, 2126},
	{1173, R_008018_GRBM_STATUS_SE1, 12, 2138},
	{1189, R_008038_GRBM_STATUS_SE2, 12, 2150},
	{1205, R_00803C_GRBM_STATUS_SE3, 12, 2162},
	{1115, R_0301F0_CP_COHER_CNTL, 13, 2174},
	{1259, R_0301FC_CP_COHER_STATUS, 2, 2187},
	{1275, R_008210_CP_CPC_STATUS, 16, 2189},
	{1306, R_008218_CP_CPC_STALLED_STAT1, 14, 2205},
	{1327, R_00821C_CP_CPF_STATUS, 21, 2219},
	{1358, R_008224_CP_CPF_STALLED_STAT1, 11, 2240},
	{1821, R_008670_CP_STALLED_STAT3, 19, 2251},
	{1872, R_008680_CP_STAT, 22, 2270},
	{1500, R_030908_VGT_PRIMITIVE_TYPE, 1, 2292},
	{1519, R_03090C_VGT_INDEX_TYPE, 2, 2293},
	{17666, R_030920_VGT_MAX_VTX_INDX},
	{17683, R_030924_VGT_MIN_VTX_INDX},
	{17700, R_030928_VGT_INDX_OFFSET},
	{22637, R_03092C_VGT_MULTI_PRIM_IB_RESET_EN, 2, 2295},
	{1717, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 2297},
	{26682, R_030944_VGT_TF_MEMORY_BASE_HI, 1, 2299},
	{26704, R_030948_WD_POS_BUF_BASE},
	{26720, R_03094C_WD_POS_BUF_BASE_HI, 1, 2300},
	{26739, R_030950_WD_CNTL_SB_BUF_BASE},
	{26759, R_030954_WD_CNTL_SB_BUF_BASE_HI, 1, 2301},
	{26782, R_030958_WD_INDEX_BUF_BASE},
	{26800, R_03095C_WD_INDEX_BUF_BASE_HI, 1, 2302},
	{22714, R_030960_IA_MULTI_VGT_PARAM, 9, 2303},
	{26821, R_030968_VGT_INSTANCE_BASE_ID},
	{1998, R_030D20_SQC_CACHES, 6, 2312},
	{26842, R_030D24_SQC_WRITEBACK, 2, 2318},
	{2226, R_008F0C_SQ_BUF_RSRC_WORD3, 12, 2320},
	{2309, R_008F14_SQ_IMG_RSRC_WORD1, 9, 2332},
	{2351, R_008F18_SQ_IMG_RSRC_WORD2, 3, 558},
	{2392, R_008F1C_SQ_IMG_RSRC_WORD3, 8, 2341},
	{2410, R_008F20_SQ_IMG_RSRC_WORD4, 3, 2349},
	{2428, R_008F24_SQ_IMG_RSRC_WORD5, 7, 2352},
	{2518, R_008F38_SQ_IMG_SAMP_WORD2, 10, 2359},
	{2536, R_008F3C_SQ_IMG_SAMP_WORD3, 3, 2369},
	{2800, R_031100_SPI_CONFIG_CNTL, 9, 2372},
	{2816, R_031104_SPI_CONFIG_CNTL_1, 11, 2381},
	{26856, R_031108_SPI_CONFIG_CNTL_2, 2, 2392},
	{2882, R_0098F8_GB_ADDR_CONFIG, 13, 2394},
	{2897, R_009910_GB_TILE_MODE0, 5, 2407},
	{2911, R_009914_GB_TILE_MODE1, 5, 2407},
	{2925, R_009918_GB_TILE_MODE2, 5, 2407},
	{2939, R_00991C_GB_TILE_MODE3, 5, 2407},
	{2953, R_009920_GB_TILE_MODE4, 5, 2407},
	{2967, R_009924_GB_TILE_MODE5, 5, 2407},
	{2981, R_009928_GB_TILE_MODE6, 5, 2407},
	{2995, R_00992C_GB_TILE_MODE7, 5, 2407},
	{3009, R_009930_GB_TILE_MODE8, 5, 2407},
	{3023, R_009934_GB_TILE_MODE9, 5, 2407},
	{3037, R_009938_GB_TILE_MODE10, 5, 2407},
	{3052, R_00993C_GB_TILE_MODE11, 5, 2407},
	{3067, R_009940_GB_TILE_MODE12, 5, 2407},
	{3082, R_009944_GB_TILE_MODE13, 5, 2407},
	{3097, R_009948_GB_TILE_MODE14, 5, 2407},
	{3112, R_00994C_GB_TILE_MODE15, 5, 2407},
	{3127, R_009950_GB_TILE_MODE16, 5, 2407},
	{3142, R_009954_GB_TILE_MODE17, 5, 2407},
	{3157, R_009958_GB_TILE_MODE18, 5, 2407},
	{3172, R_00995C_GB_TILE_MODE19, 5, 2407},
	{3187, R_009960_GB_TILE_MODE20, 5, 2407},
	{3202, R_009964_GB_TILE_MODE21, 5, 2407},
	{3217, R_009968_GB_TILE_MODE22, 5, 2407},
	{3232, R_00996C_GB_TILE_MODE23, 5, 2407},
	{3247, R_009970_GB_TILE_MODE24, 5, 2407},
	{3262, R_009974_GB_TILE_MODE25, 5, 2407},
	{3277, R_009978_GB_TILE_MODE26, 5, 2407},
	{3292, R_00997C_GB_TILE_MODE27, 5, 2407},
	{3307, R_009980_GB_TILE_MODE28, 5, 2407},
	{3322, R_009984_GB_TILE_MODE29, 5, 2407},
	{3337, R_009988_GB_TILE_MODE30, 5, 2407},
	{3352, R_00998C_GB_TILE_MODE31, 5, 2407},
	{3761, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 4, 2412},
	{3827, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 2416},
	{3851, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 10, 2427},
	{26874, R_00B070_SPI_SHADER_USER_DATA_PS_16},
	{26901, R_00B074_SPI_SHADER_USER_DATA_PS_17},
	{26928, R_00B078_SPI_SHADER_USER_DATA_PS_18},
	{26955, R_00B07C_SPI_SHADER_USER_DATA_PS_19},
	{26982, R_00B080_SPI_SHADER_USER_DATA_PS_20},
	{27009, R_00B084_SPI_SHADER_USER_DATA_PS_21},
	{27036, R_00B088_SPI_SHADER_USER_DATA_PS_22},
	{27063, R_00B08C_SPI_SHADER_USER_DATA_PS_23},
	{27090, R_00B090_SPI_SHADER_USER_DATA_PS_24},
	{27117, R_00B094_SPI_SHADER_USER_DATA_PS_25},
	{27144, R_00B098_SPI_SHADER_USER_DATA_PS_26},
	{27171, R_00B09C_SPI_SHADER_USER_DATA_PS_27},
	{27198, R_00B0A0_SPI_SHADER_USER_DATA_PS_28},
	{27225, R_00B0A4_SPI_SHADER_USER_DATA_PS_29},
	{27252, R_00B0A8_SPI_SHADER_USER_DATA_PS_30},
	{27279, R_00B0AC_SPI_SHADER_USER_DATA_PS_31},
	{4381, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 4, 2437},
	{4472, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 2441},
	{4496, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 14, 2453},
	{27306, R_00B170_SPI_SHADER_USER_DATA_VS_16},
	{27333, R_00B174_SPI_SHADER_USER_DATA_VS_17},
	{27360, R_00B178_SPI_SHADER_USER_DATA_VS_18},
	{27387, R_00B17C_SPI_SHADER_USER_DATA_VS_19},
	{27414, R_00B180_SPI_SHADER_USER_DATA_VS_20},
	{27441, R_00B184_SPI_SHADER_USER_DATA_VS_21},
	{27468, R_00B188_SPI_SHADER_USER_DATA_VS_22},
	{27495, R_00B18C_SPI_SHADER_USER_DATA_VS_23},
	{27522, R_00B190_SPI_SHADER_USER_DATA_VS_24},
	{27549, R_00B194_SPI_SHADER_USER_DATA_VS_25},
	{27576, R_00B198_SPI_SHADER_USER_DATA_VS_26},
	{27603, R_00B19C_SPI_SHADER_USER_DATA_VS_27},
	{27630, R_00B1A0_SPI_SHADER_USER_DATA_VS_28},
	{27657, R_00B1A4_SPI_SHADER_USER_DATA_VS_29},
	{27684, R_00B1A8_SPI_SHADER_USER_DATA_VS_30},
	{27711, R_00B1AC_SPI_SHADER_USER_DATA_VS_31},
	{27738, R_00B1F0_SPI_SHADER_PGM_RSRC2_GS_VS, 9, 2467},
	{27765, R_00B204_SPI_SHADER_PGM_RSRC4_GS, 2, 2476},
	{27789, R_00B208_SPI_SHADER_USER_DATA_ADDR_LO_GS},
	{27821, R_00B20C_SPI_SHADER_USER_DATA_ADDR_HI_GS},
	{5670, R_00B210_SPI_SHADER_PGM_LO_ES},
	{5691, R_00B214_SPI_SHADER_PGM_HI_ES, 1, 2478},
	{5026, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 2479},
	{5092, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 12, 2483},
	{5116, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 9, 2495},
	{27853, R_00B370_SPI_SHADER_USER_DATA_ES_16},
	{27880, R_00B374_SPI_SHADER_USER_DATA_ES_17},
	{27907, R_00B378_SPI_SHADER_USER_DATA_ES_18},
	{27934, R_00B37C_SPI_SHADER_USER_DATA_ES_19},
	{27961, R_00B380_SPI_SHADER_USER_DATA_ES_20},
	{27988, R_00B384_SPI_SHADER_USER_DATA_ES_21},
	{28015, R_00B388_SPI_SHADER_USER_DATA_ES_22},
	{28042, R_00B38C_SPI_SHADER_USER_DATA_ES_23},
	{28069, R_00B390_SPI_SHADER_USER_DATA_ES_24},
	{28096, R_00B394_SPI_SHADER_USER_DATA_ES_25},
	{28123, R_00B398_SPI_SHADER_USER_DATA_ES_26},
	{28150, R_00B39C_SPI_SHADER_USER_DATA_ES_27},
	{28177, R_00B3A0_SPI_SHADER_USER_DATA_ES_28},
	{28204, R_00B3A4_SPI_SHADER_USER_DATA_ES_29},
	{28231, R_00B3A8_SPI_SHADER_USER_DATA_ES_30},
	{28258, R_00B3AC_SPI_SHADER_USER_DATA_ES_31},
	{28285, R_00B404_SPI_SHADER_PGM_RSRC4_HS, 1, 2504},
	{28309, R_00B408_SPI_SHADER_USER_DATA_ADDR_LO_HS},
	{28341, R_00B40C_SPI_SHADER_USER_DATA_ADDR_HI_HS},
	{6910, R_00B410_SPI_SHADER_PGM_LO_LS},
	{6931, R_00B414_SPI_SHADER_PGM_HI_LS, 1, 2505},
	{6266, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 4, 2506},
	{6332, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 11, 2510},
	{6356, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 7, 2521},
	{7000, R_00B430_SPI_SHADER_USER_DATA_LS_0},
	{7026, R_00B434_SPI_SHADER_USER_DATA_LS_1},
	{7052, R_00B438_SPI_SHADER_USER_DATA_LS_2},
	{7078, R_00B43C_SPI_SHADER_USER_DATA_LS_3},
	{7104, R_00B440_SPI_SHADER_USER_DATA_LS_4},
	{7130, R_00B444_SPI_SHADER_USER_DATA_LS_5},
	{7156, R_00B448_SPI_SHADER_USER_DATA_LS_6},
	{7182, R_00B44C_SPI_SHADER_USER_DATA_LS_7},
	{7208, R_00B450_SPI_SHADER_USER_DATA_LS_8},
	{7234, R_00B454_SPI_SHADER_USER_DATA_LS_9},
	{7260, R_00B458_SPI_SHADER_USER_DATA_LS_10},
	{7287, R_00B45C_SPI_SHADER_USER_DATA_LS_11},
	{7314, R_00B460_SPI_SHADER_USER_DATA_LS_12},
	{7341, R_00B464_SPI_SHADER_USER_DATA_LS_13},
	{7368, R_00B468_SPI_SHADER_USER_DATA_LS_14},
	{7395, R_00B46C_SPI_SHADER_USER_DATA_LS_15},
	{28373, R_00B470_SPI_SHADER_USER_DATA_LS_16},
	{28400, R_00B474_SPI_SHADER_USER_DATA_LS_17},
	{28427, R_00B478_SPI_SHADER_USER_DATA_LS_18},
	{28454, R_00B47C_SPI_SHADER_USER_DATA_LS_19},
	{28481, R_00B480_SPI_SHADER_USER_DATA_LS_20},
	{28508, R_00B484_SPI_SHADER_USER_DATA_LS_21},
	{28535, R_00B488_SPI_SHADER_USER_DATA_LS_22},
	{28562, R_00B48C_SPI_SHADER_USER_DATA_LS_23},
	{28589, R_00B490_SPI_SHADER_USER_DATA_LS_24},
	{28616, R_00B494_SPI_SHADER_USER_DATA_LS_25},
	{28643, R_00B498_SPI_SHADER_USER_DATA_LS_26},
	{28670, R_00B49C_SPI_SHADER_USER_DATA_LS_27},
	{28697, R_00B4A0_SPI_SHADER_USER_DATA_LS_28},
	{28724, R_00B4A4_SPI_SHADER_USER_DATA_LS_29},
	{28751, R_00B4A8_SPI_SHADER_USER_DATA_LS_30},
	{28778, R_00B4AC_SPI_SHADER_USER_DATA_LS_31},
	{28805, R_00B530_SPI_SHADER_USER_DATA_COMMON_0},
	{28835, R_00B534_SPI_SHADER_USER_DATA_COMMON_1},
	{28865, R_00B538_SPI_SHADER_USER_DATA_COMMON_2},
	{28895, R_00B53C_SPI_SHADER_USER_DATA_COMMON_3},
	{28925, R_00B540_SPI_SHADER_USER_DATA_COMMON_4},
	{28955, R_00B544_SPI_SHADER_USER_DATA_COMMON_5},
	{28985, R_00B548_SPI_SHADER_USER_DATA_COMMON_6},
	{29015, R_00B54C_SPI_SHADER_USER_DATA_COMMON_7},
	{29045, R_00B550_SPI_SHADER_USER_DATA_COMMON_8},
	{29075, R_00B554_SPI_SHADER_USER_DATA_COMMON_9},
	{29105, R_00B558_SPI_SHADER_USER_DATA_COMMON_10},
	{29136, R_00B55C_SPI_SHADER_USER_DATA_COMMON_11},
	{29167, R_00B560_SPI_SHADER_USER_DATA_COMMON_12},
	{29198, R_00B564_SPI_SHADER_USER_DATA_COMMON_13},
	{29229, R_00B568_SPI_SHADER_USER_DATA_COMMON_14},
	{29260, R_00B56C_SPI_SHADER_USER_DATA_COMMON_15},
	{29291, R_00B570_SPI_SHADER_USER_DATA_COMMON_16},
	{29322, R_00B574_SPI_SHADER_USER_DATA_COMMON_17},
	{29353, R_00B578_SPI_SHADER_USER_DATA_COMMON_18},
	{29384, R_00B57C_SPI_SHADER_USER_DATA_COMMON_19},
	{29415, R_00B580_SPI_SHADER_USER_DATA_COMMON_20},
	{29446, R_00B584_SPI_SHADER_USER_DATA_COMMON_21},
	{29477, R_00B588_SPI_SHADER_USER_DATA_COMMON_22},
	{29508, R_00B58C_SPI_SHADER_USER_DATA_COMMON_23},
	{29539, R_00B590_SPI_SHADER_USER_DATA_COMMON_24},
	{29570, R_00B594_SPI_SHADER_USER_DATA_COMMON_25},
	{29601, R_00B598_SPI_SHADER_USER_DATA_COMMON_26},
	{29632, R_00B59C_SPI_SHADER_USER_DATA_COMMON_27},
	{29663, R_00B5A0_SPI_SHADER_USER_DATA_COMMON_28},
	{29694, R_00B5A4_SPI_SHADER_USER_DATA_COMMON_29},
	{29725, R_00B5A8_SPI_SHADER_USER_DATA_COMMON_30},
	{29756, R_00B5AC_SPI_SHADER_USER_DATA_COMMON_31},
	{7422, R_00B800_COMPUTE_DISPATCH_INITIATOR, 11, 2528},
	{7690, R_00B834_COMPUTE_PGM_HI, 1, 873},
	{29787, R_00B838_COMPUTE_DISPATCH_PKT_ADDR_LO},
	{29816, R_00B83C_COMPUTE_DISPATCH_PKT_ADDR_HI, 1, 875},
	{29845, R_00B840_COMPUTE_DISPATCH_SCRATCH_BASE_LO},
	{29878, R_00B844_COMPUTE_DISPATCH_SCRATCH_BASE_HI, 1, 876},
	{7765, R_00B848_COMPUTE_PGM_RSRC1, 11, 2539},
	{7783, R_00B84C_COMPUTE_PGM_RSRC2, 12, 2550},
	{7814, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 2562},
	{29911, R_034030_CPF_LATENCY_STATS_DATA},
	{29934, R_034034_CPG_LATENCY_STATS_DATA},
	{29957, R_034038_CPC_LATENCY_STATS_DATA},
	{12244, R_036000_CPG_PERFCOUNTER1_SELECT, 5, 2569},
	{12268, R_036004_CPG_PERFCOUNTER0_SELECT1, 4, 2574},
	{12293, R_036008_CPG_PERFCOUNTER0_SELECT, 5, 2569},
	{12317, R_03600C_CPC_PERFCOUNTER1_SELECT, 5, 2578},
	{12341, R_036010_CPC_PERFCOUNTER0_SELECT1, 4, 2583},
	{12366, R_036014_CPF_PERFCOUNTER1_SELECT, 5, 2587},
	{12390, R_036018_CPF_PERFCOUNTER0_SELECT1, 4, 2592},
	{12415, R_03601C_CPF_PERFCOUNTER0_SELECT, 5, 2587},
	{12455, R_036024_CPC_PERFCOUNTER0_SELECT, 5, 2578},
	{29980, R_036028_CPF_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2596},
	{30014, R_03602C_CPG_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2599},
	{30048, R_036030_CPF_LATENCY_STATS_SELECT, 3, 2602},
	{30073, R_036034_CPG_LATENCY_STATS_SELECT, 3, 2605},
	{30098, R_036038_CPC_LATENCY_STATS_SELECT, 3, 2608},
	{12479, R_036100_GRBM_PERFCOUNTER0_SELECT, 22, 2611},
	{12504, R_036104_GRBM_PERFCOUNTER1_SELECT, 22, 2611},
	{12529, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 13, 2633},
	{12557, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 13, 2646},
	{12585, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 13, 2659},
	{12613, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 13, 2672},
	{13414, R_036600_SPI_PERFCOUNTER0_SELECT, 5, 2685},
	{13438, R_036604_SPI_PERFCOUNTER1_SELECT, 5, 2685},
	{13462, R_036608_SPI_PERFCOUNTER2_SELECT, 5, 2685},
	{13486, R_03660C_SPI_PERFCOUNTER3_SELECT, 5, 2685},
	{13510, R_036610_SPI_PERFCOUNTER0_SELECT1, 4, 2690},
	{13610, R_036620_SPI_PERFCOUNTER4_SELECT, 5, 2685},
	{13634, R_036624_SPI_PERFCOUNTER5_SELECT, 5, 2685},
	{15266, R_028008_DB_DEPTH_VIEW, 5, 2694},
	{15299, R_028010_DB_RENDER_OVERRIDE2, 16, 2699},
	{30123, R_028018_DB_HTILE_DATA_BASE_HI, 1, 2715},
	{15572, R_02801C_DB_DEPTH_SIZE, 2, 2716},
	{15472, R_028038_DB_Z_INFO, 13, 2718},
	{15482, R_02803C_DB_STENCIL_INFO, 8, 2731},
	{15498, R_028040_DB_Z_READ_BASE},
	{30145, R_028044_DB_Z_READ_BASE_HI, 1, 2739},
	{15513, R_028048_DB_STENCIL_READ_BASE},
	{30163, R_02804C_DB_STENCIL_READ_BASE_HI, 1, 2740},
	{30187, R_028054_DB_Z_WRITE_BASE_HI, 1, 2741},
	{15550, R_028058_DB_STENCIL_WRITE_BASE},
	{30206, R_02805C_DB_STENCIL_WRITE_BASE_HI, 1, 2742},
	{30231, R_028060_DB_DFSM_CONTROL, 3, 2743},
	{30247, R_028068_DB_Z_INFO2, 1, 2746},
	{30258, R_02806C_DB_STENCIL_INFO2, 1, 2747},
	{15636, R_0281E8_COHER_DEST_BASE_HI_0, 1, 2748},
	{15657, R_0281EC_COHER_DEST_BASE_HI_1, 1, 2749},
	{15678, R_0281F0_COHER_DEST_BASE_HI_2, 1, 2750},
	{15699, R_0281F4_COHER_DEST_BASE_HI_3, 1, 2751},
	{17596, R_028350_PA_SC_RASTER_CONFIG, 15, 2752},
	{17616, R_028354_PA_SC_RASTER_CONFIG_1, 3, 2767},
	{30275, R_02835C_PA_SC_TILE_STEERING_OVERRIDE, 3, 2770},
	{30304, R_028360_CP_PERFMON_CNTX_CNTL, 1, 2773},
	{30325, R_0283A0_PA_SC_RIGHT_VERT_GRID, 4, 2774},
	{30347, R_0283A4_PA_SC_LEFT_VERT_GRID, 4, 2778},
	{30368, R_0283A8_PA_SC_HORIZ_GRID, 4, 2782},
	{20961, R_0286C4_SPI_VS_OUT_CONFIG, 2, 1350},
	{21035, R_0286D8_SPI_PS_IN_CONTROL, 5, 2786},
	{30385, R_0287A0_CB_MRT0_EPITCH, 1, 2791},
	{30400, R_0287A4_CB_MRT1_EPITCH, 1, 2792},
	{30415, R_0287A8_CB_MRT2_EPITCH, 1, 2793},
	{30430, R_0287AC_CB_MRT3_EPITCH, 1, 2794},
	{30445, R_0287B0_CB_MRT4_EPITCH, 1, 2795},
	{30460, R_0287B4_CB_MRT5_EPITCH, 1, 2796},
	{30475, R_0287B8_CB_MRT6_EPITCH, 1, 2797},
	{30490, R_0287BC_CB_MRT7_EPITCH, 1, 2798},
	{21617, R_0287E4_VGT_DMA_BASE_HI, 1, 2799},
	{21646, R_0287F0_VGT_DRAW_INITIATOR, 8, 2800},
	{21744, R_02880C_DB_SHADER_CONTROL, 16, 2808},
	{21778, R_028814_PA_SU_SC_MODE_CNTL, 15, 2824},
	{21797, R_028818_PA_CL_VTE_CNTL, 10, 2839},
	{21812, R_02881C_PA_CL_VS_OUT_CNTL, 28, 2849},
	{30505, R_028834_PA_CL_OBJPRIM_ID_CNTL, 3, 2877},
	{30527, R_028838_PA_CL_NGG_CNTL, 2, 2880},
	{30542, R_02883C_PA_SU_OVER_RASTERIZATION_CNTL, 5, 2882},
	{30572, R_028840_PA_STEREO_CNTL},
	{22272, R_028A40_VGT_GS_MODE, 15, 2887},
	{22284, R_028A44_VGT_GS_ONCHIP_CNTL, 3, 2902},
	{22303, R_028A48_PA_SC_MODE_CNTL_0, 7, 2905},
	{22524, R_028A7C_VGT_DMA_INDEX_TYPE, 7, 2912},
	{22554, R_028A84_VGT_PRIMITIVEID_EN, 3, 2919},
	{22617, R_028A90_VGT_EVENT_INITIATOR, 3, 2922},
	{30587, R_028A94_VGT_GS_MAX_PRIMS_PER_SUBGROUP, 1, 2925},
	{30617, R_028A98_VGT_DRAW_PAYLOAD_CNTL, 4, 2926},
	{22808, R_028ABC_DB_HTILE_SURFACE, 8, 2930},
	{23368, R_028B54_VGT_SHADER_STAGES_EN, 13, 2938},
	{23496, R_028B6C_VGT_TF_PARAM, 8, 2951},
	{23744, R_028B94_VGT_STRMOUT_CONFIG, 8, 2959},
	{30639, R_028B9C_VGT_DMA_EVENT_INITIATOR, 3, 2967},
	{23857, R_028BE0_PA_SC_AA_CONFIG, 6, 2970},
	{24572, R_028C40_PA_SC_SHADER_CONTROL, 3, 2976},
	{30663, R_028C44_PA_SC_BINNER_CNTL_0, 10, 2979},
	{30683, R_028C48_PA_SC_BINNER_CNTL_1, 2, 2989},
	{30703, R_028C4C_PA_SC_CONSERVATIVE_RASTERIZATION_CNTL, 18, 2991},
	{30741, R_028C50_PA_SC_NGG_MODE_CNTL, 1, 3009},
	{30761, R_028C64_CB_COLOR0_BASE_EXT, 1, 3010},
	{30780, R_028C68_CB_COLOR0_ATTRIB2, 3, 3011},
	{24689, R_028C6C_CB_COLOR0_VIEW, 3, 3014},
	{24704, R_028C70_CB_COLOR0_INFO, 16, 3017},
	{24719, R_028C74_CB_COLOR0_ATTRIB, 10, 3033},
	{30798, R_028C80_CB_COLOR0_CMASK_BASE_EXT, 1, 3043},
	{30823, R_028C88_CB_COLOR0_FMASK_BASE_EXT, 1, 3044},
	{30848, R_028C98_CB_COLOR0_DCC_BASE_EXT, 1, 3045},
	{30871, R_028CA0_CB_COLOR1_BASE_EXT, 1, 3010},
	{30890, R_028CA4_CB_COLOR1_ATTRIB2},
	{24944, R_028CA8_CB_COLOR1_VIEW, 3, 3014},
	{24959, R_028CAC_CB_COLOR1_INFO, 16, 3017},
	{24974, R_028CB0_CB_COLOR1_ATTRIB, 10, 3033},
	{30908, R_028CBC_CB_COLOR1_CMASK_BASE_EXT, 1, 3043},
	{30933, R_028CC4_CB_COLOR1_FMASK_BASE_EXT, 1, 3044},
	{30958, R_028CD4_CB_COLOR1_DCC_BASE_EXT, 1, 3045},
	{30981, R_028CDC_CB_COLOR2_BASE_EXT, 1, 3010},
	{31000, R_028CE0_CB_COLOR2_ATTRIB2},
	{25199, R_028CE4_CB_COLOR2_VIEW, 3, 3014},
	{25214, R_028CE8_CB_COLOR2_INFO, 16, 3017},
	{25229, R_028CEC_CB_COLOR2_ATTRIB, 10, 3033},
	{31018, R_028CF8_CB_COLOR2_CMASK_BASE_EXT, 1, 3043},
	{31043, R_028D00_CB_COLOR2_FMASK_BASE_EXT, 1, 3044},
	{31068, R_028D10_CB_COLOR2_DCC_BASE_EXT, 1, 3045},
	{31091, R_028D18_CB_COLOR3_BASE_EXT, 1, 3010},
	{31110, R_028D1C_CB_COLOR3_ATTRIB2},
	{25454, R_028D20_CB_COLOR3_VIEW, 3, 3014},
	{25469, R_028D24_CB_COLOR3_INFO, 16, 3017},
	{25484, R_028D28_CB_COLOR3_ATTRIB, 10, 3033},
	{31128, R_028D34_CB_COLOR3_CMASK_BASE_EXT, 1, 3043},
	{31153, R_028D3C_CB_COLOR3_FMASK_BASE_EXT, 1, 3044},
	{31178, R_028D4C_CB_COLOR3_DCC_BASE_EXT, 1, 3045},
	{31201, R_028D54_CB_COLOR4_BASE_EXT, 1, 3010},
	{31220, R_028D58_CB_COLOR4_ATTRIB2},
	{25709, R_028D5C_CB_COLOR4_VIEW, 3, 3014},
	{25724, R_028D60_CB_COLOR4_INFO, 16, 3017},
	{25739, R_028D64_CB_COLOR4_ATTRIB, 10, 3033},
	{31238, R_028D70_CB_COLOR4_CMASK_BASE_EXT, 1, 3043},
	{31263, R_028D78_CB_COLOR4_FMASK_BASE_EXT, 1, 3044},
	{31288, R_028D88_CB_COLOR4_DCC_BASE_EXT, 1, 3045},
	{31311, R_028D90_CB_COLOR5_BASE_EXT, 1, 3010},
	{31330, R_028D94_CB_COLOR5_ATTRIB2},
	{25964, R_028D98_CB_COLOR5_VIEW, 3, 3014},
	{25979, R_028D9C_CB_COLOR5_INFO, 16, 3017},
	{25994, R_028DA0_CB_COLOR5_ATTRIB, 10, 3033},
	{31348, R_028DAC_CB_COLOR5_CMASK_BASE_EXT, 1, 3043},
	{31373, R_028DB4_CB_COLOR5_FMASK_BASE_EXT, 1, 3044},
	{31398, R_028DC4_CB_COLOR5_DCC_BASE_EXT, 1, 3045},
	{31421, R_028DCC_CB_COLOR6_BASE_EXT, 1, 3010},
	{31440, R_028DD0_CB_COLOR6_ATTRIB2},
	{26219, R_028DD4_CB_COLOR6_VIEW, 3, 3014},
	{26234, R_028DD8_CB_COLOR6_INFO, 16, 3017},
	{26249, R_028DDC_CB_COLOR6_ATTRIB, 10, 3033},
	{31458, R_028DE8_CB_COLOR6_CMASK_BASE_EXT, 1, 3043},
	{31483, R_028DF0_CB_COLOR6_FMASK_BASE_EXT, 1, 3044},
	{31508, R_028E00_CB_COLOR6_DCC_BASE_EXT, 1, 3045},
	{31531, R_028E08_CB_COLOR7_BASE_EXT, 1, 3010},
	{31550, R_028E0C_CB_COLOR7_ATTRIB2},
	{26474, R_028E10_CB_COLOR7_VIEW, 3, 3014},
	{26489, R_028E14_CB_COLOR7_INFO, 16, 3017},
	{26504, R_028E18_CB_COLOR7_ATTRIB, 10, 3033},
	{31568, R_028E24_CB_COLOR7_CMASK_BASE_EXT, 1, 3043},
	{31593, R_028E2C_CB_COLOR7_FMASK_BASE_EXT, 1, 3044},
	{31618, R_028E3C_CB_COLOR7_DCC_BASE_EXT, 1, 3045},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{31641, S_2C3_COUNT_INDIRECT_ENABLE(~0u)},
	{31663, S_2C3_DRAW_INDEX_ENABLE(~0u)},
	/* 2 */
	{31685, S_370_ENGINE_SEL(~0u), 4, 0},
	{31696, S_370_WR_CONFIRM(~0u)},
	{31707, S_370_WR_ONE_ADDR(~0u)},
	{31771, S_370_DST_SEL(~0u), 6, 4},
	/* 6 */
	{31779, S_3F2_IB_SIZE(~0u)},
	{31787, S_3F2_CHAIN(~0u)},
	{31793, S_3F2_VALID(~0u)},
	/* 9 */
	{963, S_410_SRC_ADDR_LO(~0u)},
	/* 10 */
	{31799, S_411_CP_SYNC(~0u)},
	{31831, S_411_SRC_SEL(~0u), 4, 10},
	{31839, S_411_ENGINE(~0u), 2, 0},
	{31771, S_411_DST_SEL(~0u), 4, 14},
	{975, S_411_SRC_ADDR_HI(~0u)},
	/* 15 */
	{842, S_412_DST_ADDR_LO(~0u)},
	/* 16 */
	{854, S_413_DST_ADDR_HI(~0u)},
	/* 17 */
	{31870, S_414_BYTE_COUNT_GFX6(~0u)},
	{31886, S_414_BYTE_COUNT_GFX9(~0u)},
	{31902, S_414_DISABLE_WR_CONFIRM_GFX6(~0u)},
	{31955, S_414_SRC_SWAP(~0u), 4, 18},
	{31964, S_414_DST_SWAP(~0u), 4, 18},
	{31980, S_414_SAS(~0u), 2, 22},
	{31984, S_414_DAS(~0u), 2, 22},
	{32011, S_414_SAIC(~0u), 2, 24},
	{32016, S_414_DAIC(~0u), 2, 24},
	{32021, S_414_RAW_WAIT(~0u)},
	{32030, S_414_DISABLE_WR_CONFIRM_GFX9(~0u)},
	/* 28 */
	{31799, S_500_CP_SYNC(~0u)},
	{31831, S_500_SRC_SEL(~0u), 4, 10},
	{31771, S_500_DST_SEL(~0u), 4, 14},
	{31839, S_500_ENGINE(~0u), 2, 0},
	/* 32 */
	{32054, S_000E4C_SDMA_RQ_PENDING(~0u)},
	{32070, S_000E4C_TST_RQ_PENDING(~0u)},
	{32085, S_000E4C_SDMA1_RQ_PENDING(~0u)},
	{32102, S_000E4C_VCE0_RQ_PENDING(~0u)},
	{32118, S_000E4C_VP8_BUSY(~0u)},
	{32127, S_000E4C_SDMA_BUSY(~0u)},
	{32137, S_000E4C_SDMA1_BUSY(~0u)},
	{32148, S_000E4C_VCE0_BUSY(~0u)},
	{32158, S_000E4C_XDMA_BUSY(~0u)},
	{32168, S_000E4C_CHUB_BUSY(~0u)},
	{32178, S_000E4C_SDMA2_BUSY(~0u)},
	{32189, S_000E4C_SDMA3_BUSY(~0u)},
	{32200, S_000E4C_SAMSCP_BUSY(~0u)},
	{32212, S_000E4C_ISP_BUSY(~0u)},
	{32221, S_000E4C_VCE1_BUSY(~0u)},
	{32231, S_000E4C_ODE_BUSY(~0u)},
	{32240, S_000E4C_SDMA2_RQ_PENDING(~0u)},
	{32257, S_000E4C_SDMA3_RQ_PENDING(~0u)},
	{32274, S_000E4C_SAMSCP_RQ_PENDING(~0u)},
	{32292, S_000E4C_ISP_RQ_PENDING(~0u)},
	{32307, S_000E4C_VCE1_RQ_PENDING(~0u)},
	/* 53 */
	{32323, S_000E50_UVD_RQ_PENDING(~0u)},
	{32338, S_000E50_SAMMSP_RQ_PENDING(~0u)},
	{32356, S_000E50_ACP_RQ_PENDING(~0u)},
	{32371, S_000E50_SMU_RQ_PENDING(~0u)},
	{32386, S_000E50_GRBM_RQ_PENDING(~0u)},
	{32402, S_000E50_HI_RQ_PENDING(~0u)},
	{32416, S_000E50_VMC_BUSY(~0u)},
	{32425, S_000E50_MCB_BUSY(~0u)},
	{32434, S_000E50_MCB_NON_DISPLAY_BUSY(~0u)},
	{32455, S_000E50_MCC_BUSY(~0u)},
	{32464, S_000E50_MCD_BUSY(~0u)},
	{32473, S_000E50_VMC1_BUSY(~0u)},
	{32483, S_000E50_SEM_BUSY(~0u)},
	{32492, S_000E50_ACP_BUSY(~0u)},
	{32501, S_000E50_IH_BUSY(~0u)},
	{32509, S_000E50_UVD_BUSY(~0u)},
	{32518, S_000E50_SAMMSP_BUSY(~0u)},
	{32530, S_000E50_GCATCL2_BUSY(~0u)},
	{32543, S_000E50_OSATCL2_BUSY(~0u)},
	{32556, S_000E50_BIF_BUSY(~0u)},
	/* 73 */
	{32565, S_000E54_MCC0_BUSY(~0u)},
	{32575, S_000E54_MCC1_BUSY(~0u)},
	{32585, S_000E54_MCC2_BUSY(~0u)},
	{32595, S_000E54_MCC3_BUSY(~0u)},
	{32605, S_000E54_MCC4_BUSY(~0u)},
	{32615, S_000E54_MCC5_BUSY(~0u)},
	{32625, S_000E54_MCC6_BUSY(~0u)},
	{32635, S_000E54_MCC7_BUSY(~0u)},
	{32645, S_000E54_MCD0_BUSY(~0u)},
	{32655, S_000E54_MCD1_BUSY(~0u)},
	{32665, S_000E54_MCD2_BUSY(~0u)},
	{32675, S_000E54_MCD3_BUSY(~0u)},
	{32685, S_000E54_MCD4_BUSY(~0u)},
	{32695, S_000E54_MCD5_BUSY(~0u)},
	{32705, S_000E54_MCD6_BUSY(~0u)},
	{32715, S_000E54_MCD7_BUSY(~0u)},
	/* 89 */
	{32725, S_00D034_IDLE(~0u)},
	{32730, S_00D034_REG_IDLE(~0u)},
	{32739, S_00D034_RB_EMPTY(~0u)},
	{32748, S_00D034_RB_FULL(~0u)},
	{32756, S_00D034_RB_CMD_IDLE(~0u)},
	{32768, S_00D034_RB_CMD_FULL(~0u)},
	{32780, S_00D034_IB_CMD_IDLE(~0u)},
	{32792, S_00D034_IB_CMD_FULL(~0u)},
	{32804, S_00D034_BLOCK_IDLE(~0u)},
	{32815, S_00D034_INSIDE_IB(~0u)},
	{32825, S_00D034_EX_IDLE(~0u)},
	{32833, S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(~0u)},
	{32859, S_00D034_PACKET_READY(~0u)},
	{32872, S_00D034_MC_WR_IDLE(~0u)},
	{32883, S_00D034_SRBM_IDLE(~0u)},
	{32893, S_00D034_CONTEXT_EMPTY(~0u)},
	{32907, S_00D034_DELTA_RPTR_FULL(~0u)},
	{32923, S_00D034_RB_MC_RREQ_IDLE(~0u)},
	{32939, S_00D034_IB_MC_RREQ_IDLE(~0u)},
	{32955, S_00D034_MC_RD_IDLE(~0u)},
	{32966, S_00D034_DELTA_RPTR_EMPTY(~0u)},
	{32983, S_00D034_MC_RD_RET_STALL(~0u)},
	{32999, S_00D034_MC_RD_NO_POLL_IDLE(~0u)},
	{33018, S_00D034_PREV_CMD_IDLE(~0u)},
	{33032, S_00D034_SEM_IDLE(~0u)},
	{33041, S_00D034_SEM_REQ_STALL(~0u)},
	{33055, S_00D034_SEM_RESP_STATE(~0u)},
	{33070, S_00D034_INT_IDLE(~0u)},
	{33079, S_00D034_INT_REQ_STALL(~0u)},
	/* 118 */
	{33093, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{33116, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{33139, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{33162, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{33182, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{33202, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{33222, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{33242, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{33262, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{33282, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{33302, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{33322, S_008008_RLC_RQ_PENDING(~0u)},
	{33337, S_008008_RLC_BUSY(~0u)},
	{33346, S_008008_TC_BUSY(~0u)},
	{33354, S_008008_TCC_CC_RESIDENT(~0u)},
	{33370, S_008008_CPF_BUSY(~0u)},
	{33379, S_008008_CPC_BUSY(~0u)},
	{33388, S_008008_CPG_BUSY(~0u)},
	/* 136 */
	{33397, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{33420, S_008010_SRBM_RQ_PENDING(~0u)},
	{33436, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{33459, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{33482, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{33501, S_008010_DB_CLEAN(~0u)},
	{33510, S_008010_CB_CLEAN(~0u)},
	{33519, S_008010_TA_BUSY(~0u)},
	{33527, S_008010_GDS_BUSY(~0u)},
	{33536, S_008010_WD_BUSY_NO_DMA(~0u)},
	{33551, S_008010_VGT_BUSY(~0u)},
	{33560, S_008010_IA_BUSY_NO_DMA(~0u)},
	{33575, S_008010_IA_BUSY(~0u)},
	{33583, S_008010_SX_BUSY(~0u)},
	{33591, S_008010_WD_BUSY(~0u)},
	{33599, S_008010_SPI_BUSY(~0u)},
	{33608, S_008010_BCI_BUSY(~0u)},
	{33617, S_008010_SC_BUSY(~0u)},
	{33625, S_008010_PA_BUSY(~0u)},
	{33633, S_008010_DB_BUSY(~0u)},
	{33641, S_008010_CP_COHERENCY_BUSY(~0u)},
	{32204, S_008010_CP_BUSY(~0u)},
	{32426, S_008010_CB_BUSY(~0u)},
	{33659, S_008010_GUI_ACTIVE(~0u)},
	/* 160 */
	{33670, S_00802C_INSTANCE_INDEX(~0u)},
	{33685, S_00802C_SH_INDEX(~0u)},
	{33694, S_00802C_SE_INDEX(~0u)},
	{33703, S_00802C_SH_BROADCAST_WRITES(~0u)},
	{33723, S_00802C_INSTANCE_BROADCAST_WRITES(~0u)},
	{33749, S_00802C_SE_BROADCAST_WRITES(~0u)},
	/* 166 */
	{33769, S_0084FC_OFFSET_UPDATE_DONE(~0u)},
	/* 167 */
	{33788, S_0085F0_DEST_BASE_0_ENA(~0u)},
	{33804, S_0085F0_DEST_BASE_1_ENA(~0u)},
	{33820, S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{33838, S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{33856, S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{33874, S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{33892, S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{33910, S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{33928, S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{33946, S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{33964, S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{33981, S_0085F0_DEST_BASE_2_ENA(~0u)},
	{33997, S_0085F0_DEST_BASE_3_ENA(~0u)},
	{34013, S_0085F0_TCL1_ACTION_ENA(~0u)},
	{34029, S_0085F0_TC_ACTION_ENA(~0u)},
	{34043, S_0085F0_CB_ACTION_ENA(~0u)},
	{34057, S_0085F0_DB_ACTION_ENA(~0u)},
	{34071, S_0085F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34092, S_0085F0_SH_ICACHE_ACTION_ENA(~0u)},
	/* 186 */
	{33501, S_008014_DB_CLEAN(~0u)},
	{33510, S_008014_CB_CLEAN(~0u)},
	{33608, S_008014_BCI_BUSY(~0u)},
	{33551, S_008014_VGT_BUSY(~0u)},
	{33625, S_008014_PA_BUSY(~0u)},
	{33519, S_008014_TA_BUSY(~0u)},
	{33583, S_008014_SX_BUSY(~0u)},
	{33599, S_008014_SPI_BUSY(~0u)},
	{33617, S_008014_SC_BUSY(~0u)},
	{33633, S_008014_DB_BUSY(~0u)},
	{32426, S_008014_CB_BUSY(~0u)},
	/* 197 */
	{33501, S_008018_DB_CLEAN(~0u)},
	{33510, S_008018_CB_CLEAN(~0u)},
	{33608, S_008018_BCI_BUSY(~0u)},
	{33551, S_008018_VGT_BUSY(~0u)},
	{33625, S_008018_PA_BUSY(~0u)},
	{33519, S_008018_TA_BUSY(~0u)},
	{33583, S_008018_SX_BUSY(~0u)},
	{33599, S_008018_SPI_BUSY(~0u)},
	{33617, S_008018_SC_BUSY(~0u)},
	{33633, S_008018_DB_BUSY(~0u)},
	{32426, S_008018_CB_BUSY(~0u)},
	/* 208 */
	{33501, S_008038_DB_CLEAN(~0u)},
	{33510, S_008038_CB_CLEAN(~0u)},
	{33608, S_008038_BCI_BUSY(~0u)},
	{33551, S_008038_VGT_BUSY(~0u)},
	{33625, S_008038_PA_BUSY(~0u)},
	{33519, S_008038_TA_BUSY(~0u)},
	{33583, S_008038_SX_BUSY(~0u)},
	{33599, S_008038_SPI_BUSY(~0u)},
	{33617, S_008038_SC_BUSY(~0u)},
	{33633, S_008038_DB_BUSY(~0u)},
	{32426, S_008038_CB_BUSY(~0u)},
	/* 219 */
	{33501, S_00803C_DB_CLEAN(~0u)},
	{33510, S_00803C_CB_CLEAN(~0u)},
	{33608, S_00803C_BCI_BUSY(~0u)},
	{33551, S_00803C_VGT_BUSY(~0u)},
	{33625, S_00803C_PA_BUSY(~0u)},
	{33519, S_00803C_TA_BUSY(~0u)},
	{33583, S_00803C_SX_BUSY(~0u)},
	{33599, S_00803C_SPI_BUSY(~0u)},
	{33617, S_00803C_SC_BUSY(~0u)},
	{33633, S_00803C_DB_BUSY(~0u)},
	{32426, S_00803C_CB_BUSY(~0u)},
	/* 230 */
	{33769, S_0300FC_OFFSET_UPDATE_DONE(~0u)},
	/* 231 */
	{34113, S_0301E4_COHER_BASE_HI_256B(~0u)},
	/* 232 */
	{34132, S_0301EC_START_DELAY_COUNT(~0u)},
	/* 233 */
	{33788, S_0301F0_DEST_BASE_0_ENA(~0u)},
	{33804, S_0301F0_DEST_BASE_1_ENA(~0u)},
	{34150, S_0301F0_TC_SD_ACTION_ENA(~0u)},
	{34167, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{33820, S_0301F0_CB0_DEST_BASE_ENA(~0u)},
	{33838, S_0301F0_CB1_DEST_BASE_ENA(~0u)},
	{33856, S_0301F0_CB2_DEST_BASE_ENA(~0u)},
	{33874, S_0301F0_CB3_DEST_BASE_ENA(~0u)},
	{33892, S_0301F0_CB4_DEST_BASE_ENA(~0u)},
	{33910, S_0301F0_CB5_DEST_BASE_ENA(~0u)},
	{33928, S_0301F0_CB6_DEST_BASE_ENA(~0u)},
	{33946, S_0301F0_CB7_DEST_BASE_ENA(~0u)},
	{33964, S_0301F0_DB_DEST_BASE_ENA(~0u)},
	{34184, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{34204, S_0301F0_TC_VOL_ACTION_ENA(~0u)},
	{34222, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{33981, S_0301F0_DEST_BASE_2_ENA(~0u)},
	{33997, S_0301F0_DEST_BASE_3_ENA(~0u)},
	{34013, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{34029, S_0301F0_TC_ACTION_ENA(~0u)},
	{34043, S_0301F0_CB_ACTION_ENA(~0u)},
	{34057, S_0301F0_DB_ACTION_ENA(~0u)},
	{34071, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34239, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{34092, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{34264, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	{34288, S_0301F0_SH_SD_ACTION_ENA(~0u)},
	/* 260 */
	{34305, S_0301FC_MATCHING_GFX_CNTX(~0u)},
	{34323, S_0301FC_MEID(~0u)},
	{34328, S_0301FC_PHASE1_STATUS(~0u)},
	{1005, S_0301FC_STATUS(~0u)},
	/* 264 */
	{34342, S_008210_MEC1_BUSY(~0u)},
	{34352, S_008210_MEC2_BUSY(~0u)},
	{34362, S_008210_DC0_BUSY(~0u)},
	{34371, S_008210_DC1_BUSY(~0u)},
	{34380, S_008210_RCIU1_BUSY(~0u)},
	{34391, S_008210_RCIU2_BUSY(~0u)},
	{34402, S_008210_ROQ1_BUSY(~0u)},
	{34412, S_008210_ROQ2_BUSY(~0u)},
	{34422, S_008210_TCIU_BUSY(~0u)},
	{34432, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{34449, S_008210_QU_BUSY(~0u)},
	{34457, S_008210_ATCL2IU_BUSY(~0u)},
	{34470, S_008210_CPG_CPC_BUSY(~0u)},
	{34483, S_008210_CPF_CPC_BUSY(~0u)},
	{33379, S_008210_CPC_BUSY(~0u)},
	/* 279 */
	{34496, S_008214_MEC1_LOAD_BUSY(~0u)},
	{34511, S_008214_MEC1_SEMAPOHRE_BUSY(~0u)},
	{34531, S_008214_MEC1_MUTEX_BUSY(~0u)},
	{34547, S_008214_MEC1_MESSAGE_BUSY(~0u)},
	{34565, S_008214_MEC1_EOP_QUEUE_BUSY(~0u)},
	{34585, S_008214_MEC1_IQ_QUEUE_BUSY(~0u)},
	{34604, S_008214_MEC1_IB_QUEUE_BUSY(~0u)},
	{34623, S_008214_MEC1_TC_BUSY(~0u)},
	{34636, S_008214_MEC1_DMA_BUSY(~0u)},
	{34650, S_008214_MEC1_PARTIAL_FLUSH_BUSY(~0u)},
	{34674, S_008214_MEC1_PIPE0_BUSY(~0u)},
	{34690, S_008214_MEC1_PIPE1_BUSY(~0u)},
	{34706, S_008214_MEC1_PIPE2_BUSY(~0u)},
	{34722, S_008214_MEC1_PIPE3_BUSY(~0u)},
	{34738, S_008214_MEC2_LOAD_BUSY(~0u)},
	{34753, S_008214_MEC2_SEMAPOHRE_BUSY(~0u)},
	{34773, S_008214_MEC2_MUTEX_BUSY(~0u)},
	{34789, S_008214_MEC2_MESSAGE_BUSY(~0u)},
	{34807, S_008214_MEC2_EOP_QUEUE_BUSY(~0u)},
	{34827, S_008214_MEC2_IQ_QUEUE_BUSY(~0u)},
	{34846, S_008214_MEC2_IB_QUEUE_BUSY(~0u)},
	{34865, S_008214_MEC2_TC_BUSY(~0u)},
	{34878, S_008214_MEC2_DMA_BUSY(~0u)},
	{34892, S_008214_MEC2_PARTIAL_FLUSH_BUSY(~0u)},
	{34916, S_008214_MEC2_PIPE0_BUSY(~0u)},
	{34932, S_008214_MEC2_PIPE1_BUSY(~0u)},
	{34948, S_008214_MEC2_PIPE2_BUSY(~0u)},
	{34964, S_008214_MEC2_PIPE3_BUSY(~0u)},
	/* 307 */
	{34980, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{34999, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{35019, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{35038, S_008218_MEC1_DECODING_PACKET(~0u)},
	{35059, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{35077, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{35100, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{35122, S_008218_MEC2_DECODING_PACKET(~0u)},
	{35143, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{35161, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{35184, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{35206, S_008218_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35230, S_008218_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35254, S_008218_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 321 */
	{35277, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{35296, S_00821C_CSF_BUSY(~0u)},
	{35305, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{35320, S_00821C_ROQ_RING_BUSY(~0u)},
	{35334, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{35353, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{35372, S_00821C_ROQ_STATE_BUSY(~0u)},
	{35387, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{35404, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35426, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{35448, S_00821C_SEMAPHORE_BUSY(~0u)},
	{35463, S_00821C_INTERRUPT_BUSY(~0u)},
	{34422, S_00821C_TCIU_BUSY(~0u)},
	{35478, S_00821C_HQD_BUSY(~0u)},
	{35487, S_00821C_PRT_BUSY(~0u)},
	{34457, S_00821C_ATCL2IU_BUSY(~0u)},
	{35496, S_00821C_CPF_GFX_BUSY(~0u)},
	{35509, S_00821C_CPF_CMP_BUSY(~0u)},
	{35522, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{35541, S_00821C_CPC_CPF_BUSY(~0u)},
	{33370, S_00821C_CPF_BUSY(~0u)},
	/* 342 */
	{35554, S_008220_REG_BUS_FIFO_BUSY(~0u)},
	{35572, S_008220_CSF_RING_BUSY(~0u)},
	{35586, S_008220_CSF_INDIRECT1_BUSY(~0u)},
	{35605, S_008220_CSF_INDIRECT2_BUSY(~0u)},
	{35624, S_008220_CSF_STATE_BUSY(~0u)},
	{35639, S_008220_CSF_CE_INDR1_BUSY(~0u)},
	{35657, S_008220_CSF_CE_INDR2_BUSY(~0u)},
	{35675, S_008220_CSF_ARBITER_BUSY(~0u)},
	{35692, S_008220_CSF_INPUT_BUSY(~0u)},
	{35707, S_008220_OUTSTANDING_READ_TAGS(~0u)},
	{35729, S_008220_HPD_PROCESSING_EOP_BUSY(~0u)},
	{35753, S_008220_HQD_DISPATCH_BUSY(~0u)},
	{35771, S_008220_HQD_IQ_TIMER_BUSY(~0u)},
	{35789, S_008220_HQD_DMA_OFFLOAD_BUSY(~0u)},
	{35810, S_008220_HQD_WAIT_SEMAPHORE_BUSY(~0u)},
	{35834, S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(~0u)},
	{35860, S_008220_HQD_MESSAGE_BUSY(~0u)},
	{35877, S_008220_HQD_PQ_FETCHER_BUSY(~0u)},
	{35897, S_008220_HQD_IB_FETCHER_BUSY(~0u)},
	{35917, S_008220_HQD_IQ_FETCHER_BUSY(~0u)},
	{35937, S_008220_HQD_EOP_FETCHER_BUSY(~0u)},
	{35958, S_008220_HQD_CONSUMED_RPTR_BUSY(~0u)},
	{35981, S_008220_HQD_FETCHER_ARB_BUSY(~0u)},
	{36002, S_008220_HQD_ROQ_ALIGN_BUSY(~0u)},
	{36021, S_008220_HQD_ROQ_EOP_BUSY(~0u)},
	{36038, S_008220_HQD_ROQ_IQ_BUSY(~0u)},
	{36054, S_008220_HQD_ROQ_PQ_BUSY(~0u)},
	{36070, S_008220_HQD_ROQ_IB_BUSY(~0u)},
	{36086, S_008220_HQD_WPTR_POLL_BUSY(~0u)},
	{36105, S_008220_HQD_PQ_BUSY(~0u)},
	{36117, S_008220_HQD_IB_BUSY(~0u)},
	/* 373 */
	{36129, S_008224_RING_FETCHING_DATA(~0u)},
	{36148, S_008224_INDR1_FETCHING_DATA(~0u)},
	{36168, S_008224_INDR2_FETCHING_DATA(~0u)},
	{36188, S_008224_STATE_FETCHING_DATA(~0u)},
	{36208, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{36229, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{35206, S_008224_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35230, S_008224_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35254, S_008224_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 382 */
	{36250, S_030230_COHER_SIZE_HI_256B(~0u)},
	/* 383 */
	{36269, S_0088B0_PRIM_COUNT(~0u)},
	/* 384 */
	{36280, S_0088C4_VS_NO_EXTRA_BUFFER(~0u)},
	{36299, S_0088C4_STREAMOUT_FULL_FLUSH(~0u)},
	{36320, S_0088C4_ES_LIMIT(~0u)},
	/* 387 */
	{36329, S_0088D4_VERT_REUSE(~0u)},
	/* 388 */
	{22130, S_008958_PRIM_TYPE(~0u), 29, 26},
	/* 389 */
	{203, S_00895C_INDEX_TYPE(~0u), 2, 55},
	/* 390 */
	{38, S_008988_SIZE(~0u)},
	/* 391 */
	{36898, S_0089B0_OFFCHIP_BUFFERING(~0u)},
	/* 392 */
	{36916, S_008A14_CLIP_VTX_REORDER_ENA(~0u)},
	{36937, S_008A14_NUM_CLIP_SEQ(~0u)},
	{36950, S_008A14_CLIPPED_PRIM_SEQ_STALL(~0u)},
	{36973, S_008A14_VE_NAN_PROC_DISABLE(~0u)},
	/* 396 */
	{1777, S_008A60_LINE_STIPPLE_VALUE(~0u)},
	/* 397 */
	{36993, S_008B10_CURRENT_PTR(~0u)},
	{37005, S_008B10_CURRENT_COUNT(~0u)},
	/* 399 */
	{37019, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37044, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{37082, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{37123, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{37146, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{37169, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{37193, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37223, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37252, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{37278, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{37307, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{37332, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{36208, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{36229, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{37367, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37395, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{35206, S_008670_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35230, S_008670_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35254, S_008670_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 418 */
	{37425, S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(~0u)},
	{37452, S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(~0u)},
	{37479, S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(~0u)},
	{37508, S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(~0u)},
	{37537, S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(~0u)},
	{37566, S_008674_ME_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37594, S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{37624, S_008674_ME_WAITING_ON_TC_READ_DATA(~0u)},
	{37651, S_008674_ME_WAITING_ON_REG_READ_DATA(~0u)},
	{37679, S_008674_RCIU_WAITING_ON_GDS_FREE(~0u)},
	{37704, S_008674_RCIU_WAITING_ON_GRBM_FREE(~0u)},
	{37730, S_008674_RCIU_WAITING_ON_VGT_FREE(~0u)},
	{37755, S_008674_RCIU_STALLED_ON_ME_READ(~0u)},
	{37779, S_008674_RCIU_STALLED_ON_DMA_READ(~0u)},
	{37804, S_008674_RCIU_STALLED_ON_APPEND_READ(~0u)},
	{37832, S_008674_RCIU_HALTED_BY_REG_VIOLATION(~0u)},
	/* 434 */
	{37861, S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37887, S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(~0u)},
	{37913, S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(~0u)},
	{37940, S_008678_PFP_TO_VGT_WRITES_PENDING(~0u)},
	{37966, S_008678_PFP_RCIU_READ_PENDING(~0u)},
	{37988, S_008678_PFP_WAITING_ON_BUFFER_DATA(~0u)},
	{38015, S_008678_ME_WAIT_ON_CE_COUNTER(~0u)},
	{38037, S_008678_ME_WAIT_ON_AVAIL_BUFFER(~0u)},
	{38061, S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(~0u)},
	{38086, S_008678_ME_RCIU_NOT_RDY_TO_RCV(~0u)},
	{38109, S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(~0u)},
	{38136, S_008678_ME_WAITING_DATA_FROM_PFP(~0u)},
	{38161, S_008678_ME_WAITING_ON_PARTIAL_FLUSH(~0u)},
	{38189, S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{38214, S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{38239, S_008678_ME_WAITING_DATA_FROM_STQ(~0u)},
	{38264, S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{38293, S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{38324, S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(~0u)},
	{38352, S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(~0u)},
	{38379, S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(~0u)},
	{38409, S_008678_PIPE_STATS_WR_DATA_PENDING(~0u)},
	{38436, S_008678_APPEND_RDY_WAIT_ON_CS_DONE(~0u)},
	{38463, S_008678_APPEND_RDY_WAIT_ON_PS_DONE(~0u)},
	{38490, S_008678_APPEND_WAIT_ON_WR_CONFIRM(~0u)},
	{38516, S_008678_APPEND_ACTIVE_PARTITION(~0u)},
	{38540, S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(~0u)},
	{38572, S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(~0u)},
	{38599, S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(~0u)},
	/* 463 */
	{35320, S_008680_ROQ_RING_BUSY(~0u)},
	{35334, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{35353, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{35372, S_008680_ROQ_STATE_BUSY(~0u)},
	{38625, S_008680_DC_BUSY(~0u)},
	{34457, S_008680_ATCL2IU_BUSY(~0u)},
	{38633, S_008680_PFP_BUSY(~0u)},
	{38642, S_008680_MEQ_BUSY(~0u)},
	{38651, S_008680_ME_BUSY(~0u)},
	{38659, S_008680_QUERY_BUSY(~0u)},
	{35448, S_008680_SEMAPHORE_BUSY(~0u)},
	{35463, S_008680_INTERRUPT_BUSY(~0u)},
	{38670, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{32128, S_008680_DMA_BUSY(~0u)},
	{38688, S_008680_RCIU_BUSY(~0u)},
	{34432, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{38698, S_008680_CPC_CPG_BUSY(~0u)},
	{38711, S_008680_CE_BUSY(~0u)},
	{34422, S_008680_TCIU_BUSY(~0u)},
	{35387, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{35404, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35426, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{32204, S_008680_CP_BUSY(~0u)},
	/* 486 */
	{33670, S_030800_INSTANCE_INDEX(~0u)},
	{33685, S_030800_SH_INDEX(~0u)},
	{33694, S_030800_SE_INDEX(~0u)},
	{33703, S_030800_SH_BROADCAST_WRITES(~0u)},
	{33723, S_030800_INSTANCE_BROADCAST_WRITES(~0u)},
	{33749, S_030800_SE_BROADCAST_WRITES(~0u)},
	/* 492 */
	{22130, S_030908_PRIM_TYPE(~0u), 29, 57},
	/* 493 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	/* 494 */
	{38, S_030938_SIZE(~0u)},
	/* 495 */
	{36898, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{38767, S_03093C_OFFCHIP_GRANULARITY(~0u), 4, 86},
	/* 497 */
	{1777, S_030A00_LINE_STIPPLE_VALUE(~0u)},
	/* 498 */
	{36993, S_030A04_CURRENT_PTR(~0u)},
	{37005, S_030A04_CURRENT_COUNT(~0u)},
	/* 500 */
	{445, S_030A10_X(~0u)},
	{91, S_030A10_Y(~0u)},
	/* 502 */
	{445, S_030A14_X(~0u)},
	{91, S_030A14_Y(~0u)},
	/* 504 */
	{445, S_030A18_X(~0u)},
	{91, S_030A18_Y(~0u)},
	/* 506 */
	{445, S_030A2C_X(~0u)},
	{91, S_030A2C_Y(~0u)},
	/* 508 */
	{38787, S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(~0u)},
	{38813, S_008BF0_DISABLE_SC_DB_TILE_FIX(~0u)},
	{38836, S_008BF0_DISABLE_AA_MASK_FULL_FIX(~0u)},
	{38861, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(~0u)},
	{38892, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(~0u)},
	{38926, S_008BF0_DISABLE_SCISSOR_FIX(~0u)},
	{38946, S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(~0u)},
	{38973, S_008BF0_SEND_UNLIT_STILES_TO_PACKER(~0u)},
	{39001, S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(~0u)},
	/* 517 */
	{39036, S_008C08_INST_INVALIDATE(~0u)},
	{39052, S_008C08_DATA_INVALIDATE(~0u)},
	/* 519 */
	{39036, S_030D20_INST_INVALIDATE(~0u)},
	{39052, S_030D20_DATA_INVALIDATE(~0u)},
	{39068, S_030D20_INVALIDATE_VOLATILE(~0u)},
	/* 522 */
	{39088, S_008C0C_RET(~0u)},
	{39092, S_008C0C_RUI(~0u)},
	{39096, S_008C0C_RNG(~0u)},
	/* 525 */
	{2571, S_008DFC_EN(~0u)},
	{39159, S_008DFC_TGT(~0u), 33, 90},
	{39163, S_008DFC_COMPR(~0u)},
	{33783, S_008DFC_DONE(~0u)},
	{39169, S_008DFC_VM(~0u)},
	{39189, S_008DFC_ENCODING(~0u), 63, 123},
	/* 531 */
	{39198, S_030E04_ADDRESS(~0u)},
	/* 532 */
	{2791, S_030F04_COUNT_HI(~0u)},
	/* 533 */
	{39206, S_008F04_BASE_ADDRESS_HI(~0u)},
	{23319, S_008F04_STRIDE(~0u)},
	{39222, S_008F04_CACHE_SWIZZLE(~0u)},
	{39236, S_008F04_SWIZZLE_ENABLE(~0u)},
	/* 537 */
	{2791, S_030F0C_COUNT_HI(~0u)},
	/* 538 */
	{39341, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{39351, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{39361, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{39371, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{39555, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{39947, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{39959, S_008F0C_ELEMENT_SIZE(~0u)},
	{39972, S_008F0C_INDEX_STRIDE(~0u)},
	{39985, S_008F0C_ADD_TID_ENABLE(~0u)},
	{40000, S_008F0C_ATC(~0u)},
	{40004, S_008F0C_HASH_ENABLE(~0u)},
	{40016, S_008F0C_HEAP(~0u)},
	{40021, S_008F0C_MTYPE(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 552 */
	{2791, S_030F14_COUNT_HI(~0u)},
	/* 553 */
	{39206, S_008F14_BASE_ADDRESS_HI(~0u)},
	{40096, S_008F14_MIN_LOD(~0u)},
	{41729, S_008F14_DATA_FORMAT_GFX6(~0u), 64, 222},
	{42113, S_008F14_NUM_FORMAT_GFX6(~0u), 16, 286},
	{40021, S_008F14_MTYPE(~0u)},
	/* 558 */
	{42129, S_008F18_WIDTH(~0u)},
	{42135, S_008F18_HEIGHT(~0u)},
	{42142, S_008F18_PERF_MOD(~0u)},
	{42151, S_008F18_INTERLACED(~0u)},
	/* 562 */
	{2791, S_030F1C_COUNT_HI(~0u)},
	/* 563 */
	{39341, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{39351, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{39361, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{39371, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{42162, S_008F1C_BASE_LEVEL(~0u)},
	{42173, S_008F1C_LAST_LEVEL(~0u)},
	{42184, S_008F1C_TILING_INDEX(~0u)},
	{42197, S_008F1C_POW2_PAD(~0u)},
	{40021, S_008F1C_MTYPE(~0u)},
	{40000, S_008F1C_ATC(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 574 */
	{22114, S_008F20_DEPTH(~0u)},
	{42508, S_008F20_PITCH_GFX6(~0u)},
	/* 576 */
	{42519, S_008F24_BASE_ARRAY(~0u)},
	{42530, S_008F24_LAST_ARRAY(~0u)},
	/* 578 */
	{42541, S_008F28_MIN_LOD_WARN(~0u)},
	{42554, S_008F28_COUNTER_BANK_ID(~0u)},
	{42570, S_008F28_LOD_HDW_CNT_EN(~0u)},
	{42585, S_008F28_COMPRESSION_EN(~0u)},
	{42600, S_008F28_ALPHA_IS_ON_MSB(~0u)},
	{42616, S_008F28_COLOR_TRANSFORM(~0u)},
	{42632, S_008F28_LOST_ALPHA_BITS(~0u)},
	{42648, S_008F28_LOST_COLOR_BITS(~0u)},
	/* 586 */
	{42846, S_008F30_CLAMP_X(~0u), 8, 318},
	{42854, S_008F30_CLAMP_Y(~0u), 8, 318},
	{42862, S_008F30_CLAMP_Z(~0u), 8, 318},
	{42870, S_008F30_MAX_ANISO_RATIO(~0u)},
	{43118, S_008F30_DEPTH_COMPARE_FUNC(~0u), 8, 326},
	{43137, S_008F30_FORCE_UNNORMALIZED(~0u)},
	{43156, S_008F30_ANISO_THRESHOLD(~0u)},
	{43172, S_008F30_MC_COORD_TRUNC(~0u)},
	{43187, S_008F30_FORCE_DEGAMMA(~0u)},
	{43201, S_008F30_ANISO_BIAS(~0u)},
	{43212, S_008F30_TRUNC_COORD(~0u)},
	{43224, S_008F30_DISABLE_CUBE_WRAP(~0u)},
	{43242, S_008F30_FILTER_MODE(~0u)},
	{43254, S_008F30_COMPAT_MODE(~0u)},
	/* 600 */
	{40096, S_008F34_MIN_LOD(~0u)},
	{43266, S_008F34_MAX_LOD(~0u)},
	{43274, S_008F34_PERF_MIP(~0u)},
	{43283, S_008F34_PERF_Z(~0u)},
	/* 604 */
	{43290, S_008F38_LOD_BIAS(~0u)},
	{43299, S_008F38_LOD_BIAS_SEC(~0u)},
	{43361, S_008F38_XY_MAG_FILTER(~0u), 2, 334},
	{43436, S_008F38_XY_MIN_FILTER(~0u), 4, 336},
	{43516, S_008F38_Z_FILTER(~0u), 3, 340},
	{43525, S_008F38_MIP_FILTER(~0u), 3, 340},
	{43536, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{43555, S_008F38_DISABLE_LSB_CEIL(~0u)},
	{43572, S_008F38_FILTER_PREC_FIX(~0u)},
	{43588, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 614 */
	{43603, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{43620, S_008F3C_UPGRADED_DEPTH(~0u)},
	{43762, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 343},
	/* 617 */
	{43780, S_0090DC_VS_LOW_THRESHOLD(~0u)},
	{43797, S_0090DC_GS_LOW_THRESHOLD(~0u)},
	{43814, S_0090DC_ES_LOW_THRESHOLD(~0u)},
	{43831, S_0090DC_HS_LOW_THRESHOLD(~0u)},
	{43848, S_0090DC_LS_LOW_THRESHOLD(~0u)},
	/* 622 */
	{43865, S_0090E0_PS_CU_EN(~0u)},
	{43874, S_0090E0_VS_CU_EN(~0u)},
	/* 624 */
	{43883, S_0090E4_GS_CU_EN(~0u)},
	{43892, S_0090E4_ES_CU_EN(~0u)},
	/* 626 */
	{43901, S_0090E8_LSHS_CU_EN(~0u)},
	/* 627 */
	{2656, S_0090EC_MAX_WAVE_ID(~0u)},
	/* 628 */
	{2656, S_0090E8_MAX_WAVE_ID(~0u)},
	/* 629 */
	{43917, S_0090F0_RING_ORDER_TS0(~0u), 1, 347},
	{43932, S_0090F0_RING_ORDER_TS1(~0u)},
	{43947, S_0090F0_RING_ORDER_TS2(~0u)},
	/* 632 */
	{43962, S_00C700_PIPE_ORDER_TS0(~0u)},
	{43977, S_00C700_PIPE_ORDER_TS1(~0u)},
	{43992, S_00C700_PIPE_ORDER_TS2(~0u)},
	{44007, S_00C700_PIPE_ORDER_TS3(~0u)},
	{44022, S_00C700_TS0_DUR_MULT(~0u)},
	{44035, S_00C700_TS1_DUR_MULT(~0u)},
	{44048, S_00C700_TS2_DUR_MULT(~0u)},
	{44061, S_00C700_TS3_DUR_MULT(~0u)},
	/* 640 */
	{44074, S_0090F4_TS0_DURATION(~0u)},
	{44087, S_0090F4_TS1_DURATION(~0u)},
	/* 642 */
	{44100, S_0090F8_TS2_DURATION(~0u)},
	/* 643 */
	{38, S_008F40_SIZE(~0u)},
	/* 644 */
	{669, S_008F44_OFFSET(~0u)},
	/* 645 */
	{2791, S_030FFC_COUNT_HI(~0u)},
	/* 646 */
	{44113, S_009100_GPR_WRITE_PRIORITY(~0u)},
	{44132, S_009100_EXP_PRIORITY_ORDER(~0u)},
	{44151, S_009100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{44173, S_009100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{44195, S_009100_RSRC_MGMT_RESET(~0u)},
	/* 651 */
	{44464, S_00913C_VTX_DONE_DELAY(~0u), 16, 348},
	{44479, S_00913C_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{44503, S_00913C_PC_LIMIT_ENABLE(~0u)},
	{44519, S_00913C_PC_LIMIT_STRICT(~0u)},
	{44535, S_00913C_PC_LIMIT_SIZE(~0u)},
	/* 656 */
	{44549, S_00936C_TYPE_A(~0u)},
	{44556, S_00936C_VGPR_A(~0u)},
	{44563, S_00936C_SGPR_A(~0u)},
	{44570, S_00936C_LDS_A(~0u)},
	{44576, S_00936C_WAVES_A(~0u)},
	{44584, S_00936C_EN_A(~0u)},
	{44589, S_00936C_TYPE_B(~0u)},
	{44596, S_00936C_VGPR_B(~0u)},
	{44603, S_00936C_SGPR_B(~0u)},
	{44610, S_00936C_LDS_B(~0u)},
	{44616, S_00936C_WAVES_B(~0u)},
	{44624, S_00936C_EN_B(~0u)},
	/* 668 */
	{44629, S_009858_MSAA1_X(~0u)},
	{44637, S_009858_MSAA1_Y(~0u)},
	{44645, S_009858_MSAA2_X(~0u)},
	{44653, S_009858_MSAA2_Y(~0u)},
	{44661, S_009858_MSAA4_X(~0u)},
	{44669, S_009858_MSAA4_Y(~0u)},
	{44677, S_009858_MSAA8_X(~0u)},
	{44685, S_009858_MSAA8_Y(~0u)},
	{44693, S_009858_MSAA16_X(~0u)},
	{44702, S_009858_MSAA16_Y(~0u)},
	/* 678 */
	{44711, S_0098F8_NUM_PIPES(~0u)},
	{44721, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX6(~0u)},
	{44747, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{44768, S_0098F8_NUM_SHADER_ENGINES_GFX6(~0u)},
	{44792, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{44816, S_0098F8_NUM_GPUS_GFX6(~0u)},
	{44830, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{44850, S_0098F8_ROW_SIZE(~0u)},
	{44859, S_0098F8_NUM_LOWER_PIPES(~0u)},
	/* 687 */
	{44992, S_009910_MICRO_TILE_MODE(~0u), 4, 364},
	{45237, S_009910_ARRAY_MODE(~0u), 16, 368},
	{45599, S_009910_PIPE_CONFIG(~0u), 15, 384},
	{45789, S_009910_TILE_SPLIT(~0u), 7, 399},
	{45892, S_009910_BANK_WIDTH(~0u), 4, 406},
	{45999, S_009910_BANK_HEIGHT(~0u), 4, 410},
	{46111, S_009910_MACRO_TILE_ASPECT(~0u), 4, 414},
	{46198, S_009910_NUM_BANKS(~0u), 4, 418},
	{46239, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 422},
	{46259, S_009910_SAMPLE_SPLIT(~0u)},
	/* 697 */
	{45892, S_009990_BANK_WIDTH(~0u)},
	{45999, S_009990_BANK_HEIGHT(~0u)},
	{46111, S_009990_MACRO_TILE_ASPECT(~0u)},
	{46198, S_009990_NUM_BANKS(~0u)},
	/* 701 */
	{46272, S_00B004_MEM_BASE(~0u)},
	/* 702 */
	{46272, S_00B00C_MEM_BASE(~0u)},
	/* 703 */
	{43868, S_00B01C_CU_EN(~0u)},
	{46281, S_00B01C_WAVE_LIMIT(~0u)},
	{46292, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	/* 706 */
	{46272, S_00B024_MEM_BASE(~0u)},
	/* 707 */
	{46311, S_00B028_VGPRS(~0u)},
	{46317, S_00B028_SGPRS(~0u)},
	{2676, S_00B028_PRIORITY(~0u)},
	{46366, S_00B028_FLOAT_MODE(~0u), 241, 426},
	{46377, S_00B028_PRIV(~0u)},
	{46382, S_00B028_DX10_CLAMP(~0u)},
	{46393, S_00B028_DEBUG_MODE(~0u)},
	{46404, S_00B028_IEEE_MODE(~0u)},
	{46414, S_00B028_CU_GROUP_DISABLE(~0u)},
	{46431, S_00B028_CACHE_CTL(~0u)},
	{46441, S_00B028_CDBG_USER(~0u)},
	/* 718 */
	{46451, S_00B02C_SCRATCH_EN(~0u)},
	{46462, S_00B02C_USER_SGPR(~0u)},
	{46472, S_00B02C_TRAP_PRESENT(~0u)},
	{46485, S_00B02C_WAVE_CNT_EN(~0u)},
	{46497, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{46512, S_00B02C_EXCP_EN_SI(~0u)},
	{46523, S_00B02C_EXCP_EN(~0u)},
	/* 725 */
	{46272, S_00B104_MEM_BASE(~0u)},
	/* 726 */
	{46272, S_00B10C_MEM_BASE(~0u)},
	/* 727 */
	{43868, S_00B118_CU_EN(~0u)},
	{46281, S_00B118_WAVE_LIMIT(~0u)},
	{46292, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	/* 730 */
	{36323, S_00B11C_LIMIT(~0u)},
	/* 731 */
	{46272, S_00B124_MEM_BASE(~0u)},
	/* 732 */
	{46311, S_00B128_VGPRS(~0u)},
	{46317, S_00B128_SGPRS(~0u)},
	{2676, S_00B128_PRIORITY(~0u)},
	{46366, S_00B128_FLOAT_MODE(~0u)},
	{46377, S_00B128_PRIV(~0u)},
	{46382, S_00B128_DX10_CLAMP(~0u)},
	{46393, S_00B128_DEBUG_MODE(~0u)},
	{46404, S_00B128_IEEE_MODE(~0u)},
	{46531, S_00B128_VGPR_COMP_CNT(~0u)},
	{46545, S_00B128_CU_GROUP_ENABLE(~0u)},
	{46431, S_00B128_CACHE_CTL(~0u)},
	{46441, S_00B128_CDBG_USER(~0u)},
	/* 744 */
	{46451, S_00B12C_SCRATCH_EN(~0u)},
	{46462, S_00B12C_USER_SGPR(~0u)},
	{46472, S_00B12C_TRAP_PRESENT(~0u)},
	{46561, S_00B12C_OC_LDS_EN(~0u)},
	{46571, S_00B12C_SO_BASE0_EN(~0u)},
	{46583, S_00B12C_SO_BASE1_EN(~0u)},
	{46595, S_00B12C_SO_BASE2_EN(~0u)},
	{46607, S_00B12C_SO_BASE3_EN(~0u)},
	{46619, S_00B12C_SO_EN(~0u)},
	{46512, S_00B12C_EXCP_EN_SI(~0u)},
	{46523, S_00B12C_EXCP_EN(~0u)},
	{46625, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	/* 756 */
	{46272, S_00B204_MEM_BASE(~0u)},
	/* 757 */
	{46272, S_00B20C_MEM_BASE(~0u)},
	/* 758 */
	{43868, S_00B21C_CU_EN(~0u)},
	{46281, S_00B21C_WAVE_LIMIT(~0u)},
	{46292, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{46642, S_00B21C_GROUP_FIFO_DEPTH(~0u)},
	/* 762 */
	{46272, S_00B224_MEM_BASE(~0u)},
	/* 763 */
	{46311, S_00B228_VGPRS(~0u)},
	{46317, S_00B228_SGPRS(~0u)},
	{2676, S_00B228_PRIORITY(~0u)},
	{46366, S_00B228_FLOAT_MODE(~0u)},
	{46377, S_00B228_PRIV(~0u)},
	{46382, S_00B228_DX10_CLAMP(~0u)},
	{46393, S_00B228_DEBUG_MODE(~0u)},
	{46404, S_00B228_IEEE_MODE(~0u)},
	{46545, S_00B228_CU_GROUP_ENABLE(~0u)},
	{46431, S_00B228_CACHE_CTL(~0u)},
	{46441, S_00B228_CDBG_USER(~0u)},
	/* 774 */
	{46451, S_00B22C_SCRATCH_EN(~0u)},
	{46462, S_00B22C_USER_SGPR(~0u)},
	{46472, S_00B22C_TRAP_PRESENT(~0u)},
	{46512, S_00B22C_EXCP_EN_SI(~0u)},
	{46523, S_00B22C_EXCP_EN(~0u)},
	/* 779 */
	{46272, S_00B304_MEM_BASE(~0u)},
	/* 780 */
	{46272, S_00B30C_MEM_BASE(~0u)},
	/* 781 */
	{43868, S_00B31C_CU_EN(~0u)},
	{46281, S_00B31C_WAVE_LIMIT(~0u)},
	{46292, S_00B31C_LOCK_LOW_THRESHOLD(~0u)},
	{46642, S_00B31C_GROUP_FIFO_DEPTH(~0u)},
	/* 785 */
	{46272, S_00B324_MEM_BASE(~0u)},
	/* 786 */
	{46311, S_00B328_VGPRS(~0u)},
	{46317, S_00B328_SGPRS(~0u)},
	{2676, S_00B328_PRIORITY(~0u)},
	{46366, S_00B328_FLOAT_MODE(~0u)},
	{46377, S_00B328_PRIV(~0u)},
	{46382, S_00B328_DX10_CLAMP(~0u)},
	{46393, S_00B328_DEBUG_MODE(~0u)},
	{46404, S_00B328_IEEE_MODE(~0u)},
	{46531, S_00B328_VGPR_COMP_CNT(~0u)},
	{46545, S_00B328_CU_GROUP_ENABLE(~0u)},
	{46431, S_00B328_CACHE_CTL(~0u)},
	{46441, S_00B328_CDBG_USER(~0u)},
	/* 798 */
	{46451, S_00B32C_SCRATCH_EN(~0u)},
	{46462, S_00B32C_USER_SGPR(~0u)},
	{46472, S_00B32C_TRAP_PRESENT(~0u)},
	{46561, S_00B32C_OC_LDS_EN(~0u)},
	{46512, S_00B32C_EXCP_EN_SI(~0u)},
	{46523, S_00B32C_EXCP_EN(~0u)},
	{46503, S_00B32C_LDS_SIZE(~0u)},
	/* 805 */
	{46272, S_00B404_MEM_BASE(~0u)},
	/* 806 */
	{46272, S_00B40C_MEM_BASE(~0u)},
	/* 807 */
	{46281, S_00B41C_WAVE_LIMIT(~0u)},
	{46292, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{46642, S_00B41C_GROUP_FIFO_DEPTH(~0u)},
	/* 810 */
	{46272, S_00B424_MEM_BASE(~0u)},
	/* 811 */
	{46311, S_00B428_VGPRS(~0u)},
	{46317, S_00B428_SGPRS(~0u)},
	{2676, S_00B428_PRIORITY(~0u)},
	{46366, S_00B428_FLOAT_MODE(~0u)},
	{46377, S_00B428_PRIV(~0u)},
	{46382, S_00B428_DX10_CLAMP(~0u)},
	{46393, S_00B428_DEBUG_MODE(~0u)},
	{46404, S_00B428_IEEE_MODE(~0u)},
	{46431, S_00B428_CACHE_CTL(~0u)},
	{46441, S_00B428_CDBG_USER(~0u)},
	/* 821 */
	{46451, S_00B42C_SCRATCH_EN(~0u)},
	{46462, S_00B42C_USER_SGPR(~0u)},
	{46472, S_00B42C_TRAP_PRESENT(~0u)},
	{46561, S_00B42C_OC_LDS_EN(~0u)},
	{46659, S_00B42C_TG_SIZE_EN(~0u)},
	{46512, S_00B42C_EXCP_EN_SI(~0u)},
	{46670, S_00B42C_EXCP_EN_CIK_VI(~0u)},
	/* 828 */
	{46272, S_00B504_MEM_BASE(~0u)},
	/* 829 */
	{46272, S_00B50C_MEM_BASE(~0u)},
	/* 830 */
	{43868, S_00B51C_CU_EN(~0u)},
	{46281, S_00B51C_WAVE_LIMIT(~0u)},
	{46292, S_00B51C_LOCK_LOW_THRESHOLD(~0u)},
	{46642, S_00B51C_GROUP_FIFO_DEPTH(~0u)},
	/* 834 */
	{46272, S_00B524_MEM_BASE(~0u)},
	/* 835 */
	{46311, S_00B528_VGPRS(~0u)},
	{46317, S_00B528_SGPRS(~0u)},
	{2676, S_00B528_PRIORITY(~0u)},
	{46366, S_00B528_FLOAT_MODE(~0u)},
	{46377, S_00B528_PRIV(~0u)},
	{46382, S_00B528_DX10_CLAMP(~0u)},
	{46393, S_00B528_DEBUG_MODE(~0u)},
	{46404, S_00B528_IEEE_MODE(~0u)},
	{46531, S_00B528_VGPR_COMP_CNT(~0u)},
	{46431, S_00B528_CACHE_CTL(~0u)},
	{46441, S_00B528_CDBG_USER(~0u)},
	/* 846 */
	{46451, S_00B52C_SCRATCH_EN(~0u)},
	{46462, S_00B52C_USER_SGPR(~0u)},
	{46472, S_00B52C_TRAP_PRESENT(~0u)},
	{46503, S_00B52C_LDS_SIZE(~0u)},
	{46512, S_00B52C_EXCP_EN_SI(~0u)},
	{46523, S_00B52C_EXCP_EN(~0u)},
	/* 852 */
	{46685, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{46703, S_00B800_PARTIAL_TG_EN(~0u)},
	{46717, S_00B800_FORCE_START_AT_000(~0u)},
	{46736, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{46756, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{46776, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{46798, S_00B800_ORDER_MODE(~0u)},
	{46809, S_00B800_DISPATCH_CACHE_CNTL(~0u)},
	{46829, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{46847, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{46865, S_00B800_DATA_ATC(~0u)},
	{46874, S_00B800_RESTORE(~0u)},
	/* 864 */
	{46882, S_00B81C_NUM_THREAD_FULL(~0u)},
	{46898, S_00B81C_NUM_THREAD_PARTIAL(~0u)},
	/* 866 */
	{46882, S_00B820_NUM_THREAD_FULL(~0u)},
	{46898, S_00B820_NUM_THREAD_PARTIAL(~0u)},
	/* 868 */
	{46882, S_00B824_NUM_THREAD_FULL(~0u)},
	{46898, S_00B824_NUM_THREAD_PARTIAL(~0u)},
	/* 870 */
	{2656, S_00B82C_MAX_WAVE_ID(~0u)},
	/* 871 */
	{7630, S_00B828_PIPELINESTAT_ENABLE(~0u)},
	/* 872 */
	{7658, S_00B82C_PERFCOUNT_ENABLE(~0u)},
	/* 873 */
	{391, S_00B834_DATA(~0u)},
	{46917, S_00B834_INST_ATC(~0u)},
	/* 875 */
	{391, S_00B83C_DATA(~0u)},
	/* 876 */
	{391, S_00B844_DATA(~0u)},
	/* 877 */
	{46311, S_00B848_VGPRS(~0u)},
	{46317, S_00B848_SGPRS(~0u)},
	{2676, S_00B848_PRIORITY(~0u)},
	{46366, S_00B848_FLOAT_MODE(~0u)},
	{46377, S_00B848_PRIV(~0u)},
	{46382, S_00B848_DX10_CLAMP(~0u)},
	{46393, S_00B848_DEBUG_MODE(~0u)},
	{46404, S_00B848_IEEE_MODE(~0u)},
	{46926, S_00B848_BULKY(~0u)},
	{46441, S_00B848_CDBG_USER(~0u)},
	/* 887 */
	{46451, S_00B84C_SCRATCH_EN(~0u)},
	{46462, S_00B84C_USER_SGPR(~0u)},
	{46472, S_00B84C_TRAP_PRESENT(~0u)},
	{46932, S_00B84C_TGID_X_EN(~0u)},
	{46942, S_00B84C_TGID_Y_EN(~0u)},
	{46952, S_00B84C_TGID_Z_EN(~0u)},
	{46659, S_00B84C_TG_SIZE_EN(~0u)},
	{46962, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{46977, S_00B84C_EXCP_EN_MSB(~0u)},
	{46503, S_00B84C_LDS_SIZE(~0u)},
	{46523, S_00B84C_EXCP_EN(~0u)},
	/* 898 */
	{391, S_00B850_DATA(~0u)},
	/* 899 */
	{46989, S_00B854_WAVES_PER_SH_SI(~0u)},
	{47005, S_00B854_WAVES_PER_SH(~0u)},
	{47018, S_00B854_TG_PER_CU(~0u)},
	{47028, S_00B854_LOCK_THRESHOLD(~0u)},
	{47043, S_00B854_SIMD_DEST_CNTL(~0u)},
	{47058, S_00B854_FORCE_SIMD_DIST(~0u)},
	{47074, S_00B854_CU_GROUP_COUNT(~0u)},
	/* 906 */
	{47089, S_00B858_SH0_CU_EN(~0u)},
	{47099, S_00B858_SH1_CU_EN(~0u)},
	/* 908 */
	{47089, S_00B85C_SH0_CU_EN(~0u)},
	{47099, S_00B85C_SH1_CU_EN(~0u)},
	/* 910 */
	{47109, S_00B860_WAVES(~0u)},
	{47115, S_00B860_WAVESIZE(~0u)},
	/* 912 */
	{47089, S_00B864_SH0_CU_EN(~0u)},
	{47099, S_00B864_SH1_CU_EN(~0u)},
	/* 914 */
	{47089, S_00B868_SH0_CU_EN(~0u)},
	{47099, S_00B868_SH1_CU_EN(~0u)},
	/* 916 */
	{47124, S_00B87C_SEND_SEID(~0u)},
	{45320, S_00B87C_RESERVED2(~0u)},
	{47134, S_00B87C_RESERVED3(~0u)},
	{47144, S_00B87C_RESERVED4(~0u)},
	{47154, S_00B87C_WAVE_ID_BASE(~0u)},
	/* 921 */
	{47167, S_00B888_PAYLOAD(~0u)},
	{47175, S_00B888_IS_EVENT(~0u)},
	{47184, S_00B888_IS_STATE(~0u)},
	/* 924 */
	{2051, S_00B890_ADDR(~0u)},
	/* 925 */
	{40000, S_00B894_ATC(~0u)},
	{40021, S_00B894_MTYPE(~0u)},
	/* 927 */
	{8905, S_034404_PERFCOUNTER_HI(~0u)},
	/* 928 */
	{47193, S_036008_PERF_SEL(~0u)},
	{47202, S_036008_PERF_SEL1(~0u)},
	{47212, S_036008_CNTR_MODE(~0u)},
	/* 931 */
	{47222, S_036004_PERF_SEL2(~0u)},
	{47232, S_036004_PERF_SEL3(~0u)},
	/* 933 */
	{47193, S_036024_PERF_SEL(~0u)},
	{47202, S_036024_PERF_SEL1(~0u)},
	{47212, S_036024_CNTR_MODE(~0u)},
	/* 936 */
	{47222, S_036010_PERF_SEL2(~0u)},
	{47232, S_036010_PERF_SEL3(~0u)},
	/* 938 */
	{47193, S_03601C_PERF_SEL(~0u)},
	{47202, S_03601C_PERF_SEL1(~0u)},
	{47212, S_03601C_CNTR_MODE(~0u)},
	/* 941 */
	{47222, S_036018_PERF_SEL2(~0u)},
	{47232, S_036018_PERF_SEL3(~0u)},
	/* 943 */
	{47289, S_036020_PERFMON_STATE(~0u), 3, 667},
	{47303, S_036020_SPM_PERFMON_STATE(~0u)},
	{47321, S_036020_PERFMON_ENABLE_MODE(~0u)},
	{47341, S_036020_PERFMON_SAMPLE_ENABLE(~0u)},
	/* 947 */
	{47193, S_036100_PERF_SEL(~0u)},
	{47363, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47390, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47417, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47444, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47470, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47496, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47523, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47549, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47575, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47629, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47655, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{47681, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{47707, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{47761, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{47788, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{47814, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	/* 966 */
	{47193, S_036108_PERF_SEL(~0u)},
	{47363, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47390, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47444, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47470, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47496, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47523, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47629, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47417, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47549, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 978 */
	{47193, S_03610C_PERF_SEL(~0u)},
	{47363, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47390, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47444, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47470, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47496, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47523, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47629, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47417, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47549, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 990 */
	{47193, S_036110_PERF_SEL(~0u)},
	{47363, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47390, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47444, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47470, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47496, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47523, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47629, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47417, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47549, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1002 */
	{47193, S_036114_PERF_SEL(~0u)},
	{47363, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47390, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47444, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47470, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47496, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47523, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47629, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47417, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47549, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1014 */
	{47193, S_036200_PERF_SEL(~0u)},
	{47840, S_036200_PERF_MODE(~0u)},
	/* 1016 */
	{47193, S_036210_PERF_SEL(~0u)},
	{47202, S_036210_PERF_SEL1(~0u)},
	{47212, S_036210_CNTR_MODE(~0u)},
	{47850, S_036210_PERF_MODE1(~0u)},
	{47840, S_036210_PERF_MODE(~0u)},
	/* 1021 */
	{47222, S_036220_PERF_SEL2(~0u)},
	{47232, S_036220_PERF_SEL3(~0u)},
	{47861, S_036220_PERF_MODE3(~0u)},
	{47872, S_036220_PERF_MODE2(~0u)},
	/* 1025 */
	{47193, S_036230_PERF_SEL(~0u)},
	{47202, S_036230_PERF_SEL1(~0u)},
	{47212, S_036230_CNTR_MODE(~0u)},
	{47850, S_036230_PERF_MODE1(~0u)},
	{47840, S_036230_PERF_MODE(~0u)},
	/* 1030 */
	{47222, S_036240_PERF_SEL2(~0u)},
	{47232, S_036240_PERF_SEL3(~0u)},
	{47861, S_036240_PERF_MODE3(~0u)},
	{47872, S_036240_PERF_MODE2(~0u)},
	/* 1034 */
	{47883, S_036250_PERF_SEID_IGNORE_MASK(~0u)},
	/* 1035 */
	{47193, S_036400_PERF_SEL(~0u)},
	{47202, S_036400_PERF_SEL1(~0u)},
	{47212, S_036400_CNTR_MODE(~0u)},
	/* 1038 */
	{47222, S_036404_PERF_SEL2(~0u)},
	{47232, S_036404_PERF_SEL3(~0u)},
	/* 1040 */
	{47193, S_036500_PERF_SEL(~0u)},
	{47202, S_036500_PERF_SEL1(~0u)},
	{47212, S_036500_CNTR_MODE(~0u)},
	/* 1043 */
	{47222, S_036504_PERF_SEL2(~0u)},
	{47232, S_036504_PERF_SEL3(~0u)},
	/* 1045 */
	{47193, S_036600_PERF_SEL(~0u)},
	{47202, S_036600_PERF_SEL1(~0u)},
	{47212, S_036600_CNTR_MODE(~0u)},
	/* 1048 */
	{47222, S_036610_PERF_SEL2(~0u)},
	{47232, S_036610_PERF_SEL3(~0u)},
	/* 1050 */
	{47905, S_036628_BIN0_MIN(~0u)},
	{47914, S_036628_BIN0_MAX(~0u)},
	{47923, S_036628_BIN1_MIN(~0u)},
	{47932, S_036628_BIN1_MAX(~0u)},
	{47941, S_036628_BIN2_MIN(~0u)},
	{47950, S_036628_BIN2_MAX(~0u)},
	{47959, S_036628_BIN3_MIN(~0u)},
	{47968, S_036628_BIN3_MAX(~0u)},
	/* 1058 */
	{47193, S_036700_PERF_SEL(~0u)},
	{47977, S_036700_SQC_BANK_MASK(~0u)},
	{47991, S_036700_SQC_CLIENT_MASK(~0u)},
	{48007, S_036700_SPM_MODE(~0u)},
	{48016, S_036700_SIMD_MASK(~0u)},
	{47840, S_036700_PERF_MODE(~0u)},
	/* 1064 */
	{48026, S_036780_PS_EN(~0u)},
	{48032, S_036780_VS_EN(~0u)},
	{48038, S_036780_GS_EN(~0u)},
	{23383, S_036780_ES_EN(~0u)},
	{48044, S_036780_HS_EN(~0u)},
	{48050, S_036780_LS_EN(~0u)},
	{48056, S_036780_CS_EN(~0u)},
	{48062, S_036780_CNTR_RATE(~0u)},
	{48072, S_036780_DISABLE_FLUSH(~0u)},
	/* 1073 */
	{48086, S_036784_SH0_MASK(~0u)},
	{48095, S_036784_SH1_MASK(~0u)},
	/* 1075 */
	{48104, S_036788_FORCE_EN(~0u)},
	/* 1076 */
	{12538, S_036900_PERFCOUNTER_SELECT(~0u)},
	{48113, S_036900_PERFCOUNTER_SELECT1(~0u)},
	{47212, S_036900_CNTR_MODE(~0u)},
	/* 1079 */
	{48133, S_036910_PERFCOUNTER_SELECT2(~0u)},
	{48153, S_036910_PERFCOUNTER_SELECT3(~0u)},
	/* 1081 */
	{12538, S_036A00_PERFCOUNTER_SELECT(~0u)},
	{48113, S_036A00_PERFCOUNTER_SELECT1(~0u)},
	{47212, S_036A00_CNTR_MODE(~0u)},
	/* 1084 */
	{48133, S_036A10_PERFCOUNTER_SELECT2(~0u)},
	{48153, S_036A10_PERFCOUNTER_SELECT3(~0u)},
	/* 1086 */
	{47193, S_036B00_PERF_SEL(~0u)},
	{47202, S_036B00_PERF_SEL1(~0u)},
	{47212, S_036B00_CNTR_MODE(~0u)},
	{47850, S_036B00_PERF_MODE1(~0u)},
	{47840, S_036B00_PERF_MODE(~0u)},
	/* 1091 */
	{47222, S_036B04_PERF_SEL2(~0u)},
	{47232, S_036B04_PERF_SEL3(~0u)},
	{47861, S_036B04_PERF_MODE3(~0u)},
	{47872, S_036B04_PERF_MODE2(~0u)},
	/* 1095 */
	{47193, S_036C00_PERF_SEL(~0u)},
	{47202, S_036C00_PERF_SEL1(~0u)},
	{47212, S_036C00_CNTR_MODE(~0u)},
	{47850, S_036C00_PERF_MODE1(~0u)},
	{47840, S_036C00_PERF_MODE(~0u)},
	/* 1100 */
	{47222, S_036C04_PERF_SEL2(~0u)},
	{47232, S_036C04_PERF_SEL3(~0u)},
	{47861, S_036C04_PERF_MODE3(~0u)},
	{47872, S_036C04_PERF_MODE2(~0u)},
	/* 1104 */
	{47193, S_036D00_PERF_SEL(~0u)},
	{47202, S_036D00_PERF_SEL1(~0u)},
	{47212, S_036D00_CNTR_MODE(~0u)},
	{47850, S_036D00_PERF_MODE1(~0u)},
	{47840, S_036D00_PERF_MODE(~0u)},
	/* 1109 */
	{47222, S_036D04_PERF_SEL2(~0u)},
	{47232, S_036D04_PERF_SEL3(~0u)},
	{47861, S_036D04_PERF_MODE3(~0u)},
	{47872, S_036D04_PERF_MODE2(~0u)},
	/* 1113 */
	{47193, S_036E00_PERF_SEL(~0u)},
	{47202, S_036E00_PERF_SEL1(~0u)},
	{47212, S_036E00_CNTR_MODE(~0u)},
	{47850, S_036E00_PERF_MODE1(~0u)},
	{47840, S_036E00_PERF_MODE(~0u)},
	/* 1118 */
	{47222, S_036E04_PERF_SEL2(~0u)},
	{47232, S_036E04_PERF_SEL3(~0u)},
	{47872, S_036E04_PERF_MODE2(~0u)},
	{47861, S_036E04_PERF_MODE3(~0u)},
	/* 1122 */
	{47193, S_036E40_PERF_SEL(~0u)},
	{47202, S_036E40_PERF_SEL1(~0u)},
	{47212, S_036E40_CNTR_MODE(~0u)},
	{47850, S_036E40_PERF_MODE1(~0u)},
	{47840, S_036E40_PERF_MODE(~0u)},
	/* 1127 */
	{47222, S_036E44_PERF_SEL2(~0u)},
	{47232, S_036E44_PERF_SEL3(~0u)},
	{47872, S_036E44_PERF_MODE2(~0u)},
	{47861, S_036E44_PERF_MODE3(~0u)},
	/* 1131 */
	{48173, S_037000_OP_FILTER_ENABLE(~0u)},
	{48190, S_037000_OP_FILTER_SEL(~0u)},
	{48204, S_037000_FORMAT_FILTER_ENABLE(~0u)},
	{48225, S_037000_FORMAT_FILTER_SEL(~0u)},
	{48243, S_037000_CLEAR_FILTER_ENABLE(~0u)},
	{48263, S_037000_CLEAR_FILTER_SEL(~0u)},
	{48280, S_037000_MRT_FILTER_ENABLE(~0u)},
	{48298, S_037000_MRT_FILTER_SEL(~0u)},
	{48313, S_037000_NUM_SAMPLES_FILTER_ENABLE(~0u)},
	{48339, S_037000_NUM_SAMPLES_FILTER_SEL(~0u)},
	{48362, S_037000_NUM_FRAGMENTS_FILTER_ENABLE(~0u)},
	{48390, S_037000_NUM_FRAGMENTS_FILTER_SEL(~0u)},
	/* 1143 */
	{47193, S_037004_PERF_SEL(~0u)},
	{47202, S_037004_PERF_SEL1(~0u)},
	{47212, S_037004_CNTR_MODE(~0u)},
	{47850, S_037004_PERF_MODE1(~0u)},
	{47840, S_037004_PERF_MODE(~0u)},
	/* 1148 */
	{47222, S_037008_PERF_SEL2(~0u)},
	{47232, S_037008_PERF_SEL3(~0u)},
	{47861, S_037008_PERF_MODE3(~0u)},
	{47872, S_037008_PERF_MODE2(~0u)},
	/* 1152 */
	{47193, S_037100_PERF_SEL(~0u)},
	{47202, S_037100_PERF_SEL1(~0u)},
	{47212, S_037100_CNTR_MODE(~0u)},
	{47850, S_037100_PERF_MODE1(~0u)},
	{47840, S_037100_PERF_MODE(~0u)},
	/* 1157 */
	{47222, S_037104_PERF_SEL2(~0u)},
	{47232, S_037104_PERF_SEL3(~0u)},
	{47861, S_037104_PERF_MODE3(~0u)},
	{47872, S_037104_PERF_MODE2(~0u)},
	/* 1161 */
	{48415, S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{48434, S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{48455, S_028000_DEPTH_COPY(~0u)},
	{48466, S_028000_STENCIL_COPY(~0u)},
	{48479, S_028000_RESUMMARIZE_ENABLE(~0u)},
	{48498, S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{48523, S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{48546, S_028000_COPY_CENTROID(~0u)},
	{48560, S_028000_COPY_SAMPLE(~0u)},
	{48572, S_028000_DECOMPRESS_ENABLE(~0u)},
	/* 1171 */
	{48590, S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{48614, S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{48635, S_028004_SAMPLE_RATE(~0u)},
	{48647, S_028004_ZPASS_ENABLE(~0u)},
	{48660, S_028004_ZFAIL_ENABLE(~0u)},
	{48673, S_028004_SFAIL_ENABLE(~0u)},
	{48686, S_028004_DBFAIL_ENABLE(~0u)},
	{48700, S_028004_SLICE_EVEN_ENABLE(~0u)},
	{48718, S_028004_SLICE_ODD_ENABLE(~0u)},
	/* 1180 */
	{48735, S_028008_SLICE_START(~0u)},
	{48747, S_028008_SLICE_MAX(~0u)},
	{48757, S_028008_Z_READ_ONLY(~0u)},
	{48769, S_028008_STENCIL_READ_ONLY(~0u)},
	/* 1184 */
	{48839, S_02800C_FORCE_HIZ_ENABLE(~0u), 4, 670},
	{48856, S_02800C_FORCE_HIS_ENABLE0(~0u), 4, 670},
	{48874, S_02800C_FORCE_HIS_ENABLE1(~0u), 4, 670},
	{48892, S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{48913, S_02800C_FAST_Z_DISABLE(~0u)},
	{48928, S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{48949, S_02800C_NOOP_CULL_DISABLE(~0u)},
	{48967, S_02800C_FORCE_COLOR_KILL(~0u)},
	{48984, S_02800C_FORCE_Z_READ(~0u)},
	{48997, S_02800C_FORCE_STENCIL_READ(~0u)},
	{49016, S_02800C_FORCE_FULL_Z_RANGE(~0u), 4, 670},
	{49035, S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{49059, S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{49082, S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{49099, S_02800C_DISABLE_FULLY_COVERED(~0u)},
	{49184, S_02800C_FORCE_Z_LIMIT_SUMM(~0u), 4, 674},
	{49203, S_02800C_MAX_TILES_IN_DTT(~0u)},
	{49220, S_02800C_DISABLE_TILE_RATE_TILES(~0u)},
	{49244, S_02800C_FORCE_Z_DIRTY(~0u)},
	{49258, S_02800C_FORCE_STENCIL_DIRTY(~0u)},
	{49278, S_02800C_FORCE_Z_VALID(~0u)},
	{49292, S_02800C_FORCE_STENCIL_VALID(~0u)},
	{49312, S_02800C_PRESERVE_COMPRESSION(~0u)},
	/* 1207 */
	{49386, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 678},
	{49415, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{49446, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{49482, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{49517, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{49545, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{49567, S_028010_DISABLE_REG_SNOOP(~0u)},
	{49585, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{49617, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{49643, S_028010_HIZ_ZFUNC(~0u)},
	{49653, S_028010_HIS_SFUNC_FF(~0u)},
	{49666, S_028010_HIS_SFUNC_BF(~0u)},
	{49679, S_028010_PRESERVE_ZRANGE(~0u)},
	{49695, S_028010_PRESERVE_SRESULTS(~0u)},
	{49713, S_028010_DISABLE_FAST_PASS(~0u)},
	/* 1222 */
	{15389, S_028028_CLEAR(~0u)},
	/* 1223 */
	{49731, S_028030_TL_X(~0u)},
	{49736, S_028030_TL_Y(~0u)},
	/* 1225 */
	{49741, S_028034_BR_X(~0u)},
	{49746, S_028034_BR_Y(~0u)},
	/* 1227 */
	{49751, S_02803C_ADDR5_SWIZZLE_MASK(~0u)},
	{45237, S_02803C_ARRAY_MODE(~0u), 7, 682},
	{45599, S_02803C_PIPE_CONFIG(~0u), 18, 689},
	{45892, S_02803C_BANK_WIDTH(~0u), 4, 406},
	{45999, S_02803C_BANK_HEIGHT(~0u), 4, 410},
	{46111, S_02803C_MACRO_TILE_ASPECT(~0u), 4, 414},
	{46198, S_02803C_NUM_BANKS(~0u), 4, 418},
	/* 1234 */
	{21132, S_028040_FORMAT(~0u), 4, 707},
	{49903, S_028040_NUM_SAMPLES(~0u)},
	{45789, S_028040_TILE_SPLIT(~0u), 7, 399},
	{49915, S_028040_TILE_MODE_INDEX(~0u)},
	{49931, S_028040_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{49955, S_028040_ALLOW_EXPCLEAR(~0u)},
	{49970, S_028040_READ_SIZE(~0u)},
	{49980, S_028040_TILE_SURFACE_ENABLE(~0u)},
	{50000, S_028040_CLEAR_DISALLOWED(~0u)},
	{50017, S_028040_ZRANGE_PRECISION(~0u)},
	/* 1244 */
	{21132, S_028044_FORMAT(~0u), 2, 711},
	{45789, S_028044_TILE_SPLIT(~0u), 7, 399},
	{49915, S_028044_TILE_MODE_INDEX(~0u)},
	{49955, S_028044_ALLOW_EXPCLEAR(~0u)},
	{50060, S_028044_TILE_STENCIL_DISABLE(~0u)},
	{50000, S_028044_CLEAR_DISALLOWED(~0u)},
	/* 1250 */
	{50081, S_028058_PITCH_TILE_MAX(~0u)},
	{50096, S_028058_HEIGHT_TILE_MAX(~0u)},
	/* 1252 */
	{50112, S_02805C_SLICE_TILE_MAX(~0u)},
	/* 1253 */
	{39198, S_028084_ADDRESS(~0u)},
	/* 1254 */
	{50127, S_028200_WINDOW_X_OFFSET(~0u)},
	{50143, S_028200_WINDOW_Y_OFFSET(~0u)},
	/* 1256 */
	{49731, S_028204_TL_X(~0u)},
	{49736, S_028204_TL_Y(~0u)},
	{50159, S_028204_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1259 */
	{49741, S_028208_BR_X(~0u)},
	{49746, S_028208_BR_Y(~0u)},
	/* 1261 */
	{50181, S_02820C_CLIP_RULE(~0u)},
	/* 1262 */
	{49731, S_028210_TL_X(~0u)},
	{49736, S_028210_TL_Y(~0u)},
	/* 1264 */
	{49741, S_028214_BR_X(~0u)},
	{49746, S_028214_BR_Y(~0u)},
	/* 1266 */
	{50191, S_028230_ER_TRI(~0u)},
	{43326, S_028230_ER_POINT(~0u)},
	{50198, S_028230_ER_RECT(~0u)},
	{50206, S_028230_ER_LINE_LR(~0u)},
	{50217, S_028230_ER_LINE_RL(~0u)},
	{50228, S_028230_ER_LINE_TB(~0u)},
	{50239, S_028230_ER_LINE_BT(~0u)},
	/* 1273 */
	{50250, S_028234_HW_SCREEN_OFFSET_X(~0u)},
	{50269, S_028234_HW_SCREEN_OFFSET_Y(~0u)},
	/* 1275 */
	{50288, S_028238_TARGET0_ENABLE(~0u)},
	{50303, S_028238_TARGET1_ENABLE(~0u)},
	{50318, S_028238_TARGET2_ENABLE(~0u)},
	{50333, S_028238_TARGET3_ENABLE(~0u)},
	{50348, S_028238_TARGET4_ENABLE(~0u)},
	{50363, S_028238_TARGET5_ENABLE(~0u)},
	{50378, S_028238_TARGET6_ENABLE(~0u)},
	{50393, S_028238_TARGET7_ENABLE(~0u)},
	/* 1283 */
	{50408, S_02823C_OUTPUT0_ENABLE(~0u)},
	{50423, S_02823C_OUTPUT1_ENABLE(~0u)},
	{50438, S_02823C_OUTPUT2_ENABLE(~0u)},
	{50453, S_02823C_OUTPUT3_ENABLE(~0u)},
	{50468, S_02823C_OUTPUT4_ENABLE(~0u)},
	{50483, S_02823C_OUTPUT5_ENABLE(~0u)},
	{50498, S_02823C_OUTPUT6_ENABLE(~0u)},
	{50513, S_02823C_OUTPUT7_ENABLE(~0u)},
	/* 1291 */
	{49731, S_028240_TL_X(~0u)},
	{49736, S_028240_TL_Y(~0u)},
	{50159, S_028240_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1294 */
	{49741, S_028244_BR_X(~0u)},
	{49746, S_028244_BR_Y(~0u)},
	/* 1296 */
	{49731, S_028250_TL_X(~0u)},
	{49736, S_028250_TL_Y(~0u)},
	{50159, S_028250_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1299 */
	{49741, S_028254_BR_X(~0u)},
	{49746, S_028254_BR_Y(~0u)},
	/* 1301 */
	{50620, S_028350_RB_MAP_PKR0(~0u), 4, 713},
	{50632, S_028350_RB_MAP_PKR1(~0u), 4, 713},
	{50744, S_028350_RB_XSEL2(~0u), 4, 717},
	{50753, S_028350_RB_XSEL(~0u)},
	{50761, S_028350_RB_YSEL(~0u)},
	{50865, S_028350_PKR_MAP(~0u), 4, 721},
	{50973, S_028350_PKR_XSEL(~0u), 4, 725},
	{51082, S_028350_PKR_YSEL(~0u), 4, 729},
	{51195, S_028350_PKR_XSEL2(~0u), 4, 733},
	{51297, S_028350_SC_MAP(~0u), 4, 737},
	{51443, S_028350_SC_XSEL(~0u), 4, 741},
	{51590, S_028350_SC_YSEL(~0u), 4, 745},
	{51690, S_028350_SE_MAP(~0u), 4, 749},
	{51836, S_028350_SE_XSEL_GFX6(~0u), 4, 753},
	{51988, S_028350_SE_YSEL_GFX6(~0u), 4, 757},
	/* 1316 */
	{52113, S_028354_SE_PAIR_MAP(~0u), 4, 761},
	{52284, S_028354_SE_PAIR_XSEL_GFX6(~0u), 4, 765},
	{52461, S_028354_SE_PAIR_YSEL_GFX6(~0u), 4, 769},
	/* 1319 */
	{48700, S_028358_SLICE_EVEN_ENABLE(~0u)},
	{48718, S_028358_SLICE_ODD_ENABLE(~0u)},
	/* 1321 */
	{52479, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{52506, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{52545, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	/* 1324 */
	{52811, S_02842C_STENCILFAIL(~0u), 16, 773},
	{52823, S_02842C_STENCILZPASS(~0u), 16, 773},
	{52836, S_02842C_STENCILZFAIL(~0u), 16, 773},
	{52849, S_02842C_STENCILFAIL_BF(~0u), 16, 773},
	{52864, S_02842C_STENCILZPASS_BF(~0u), 16, 773},
	{52880, S_02842C_STENCILZFAIL_BF(~0u), 16, 773},
	/* 1330 */
	{52896, S_028430_STENCILTESTVAL(~0u)},
	{52911, S_028430_STENCILMASK(~0u)},
	{52923, S_028430_STENCILWRITEMASK(~0u)},
	{52940, S_028430_STENCILOPVAL(~0u)},
	/* 1334 */
	{52953, S_028434_STENCILTESTVAL_BF(~0u)},
	{52971, S_028434_STENCILMASK_BF(~0u)},
	{52986, S_028434_STENCILWRITEMASK_BF(~0u)},
	{53006, S_028434_STENCILOPVAL_BF(~0u)},
	/* 1338 */
	{669, S_028644_OFFSET(~0u)},
	{53029, S_028644_DEFAULT_VAL(~0u), 1, 789},
	{53041, S_028644_FLAT_SHADE(~0u)},
	{53052, S_028644_CYL_WRAP(~0u)},
	{53061, S_028644_PT_SPRITE_TEX(~0u)},
	{53075, S_028644_DUP(~0u)},
	{53079, S_028644_FP16_INTERP_MODE(~0u)},
	{53096, S_028644_USE_DEFAULT_ATTR1(~0u)},
	{53114, S_028644_DEFAULT_VAL_ATTR1(~0u)},
	{53132, S_028644_PT_SPRITE_TEX_ATTR1(~0u)},
	{53152, S_028644_ATTR0_VALID(~0u)},
	{53164, S_028644_ATTR1_VALID(~0u)},
	/* 1350 */
	{53176, S_0286C4_VS_EXPORT_COUNT(~0u)},
	{53192, S_0286C4_VS_HALF_PACK(~0u)},
	{53205, S_0286C4_VS_EXPORTS_FOG(~0u)},
	{53220, S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
	/* 1354 */
	{53240, S_0286CC_PERSP_SAMPLE_ENA(~0u)},
	{53257, S_0286CC_PERSP_CENTER_ENA(~0u)},
	{53274, S_0286CC_PERSP_CENTROID_ENA(~0u)},
	{53293, S_0286CC_PERSP_PULL_MODEL_ENA(~0u)},
	{53314, S_0286CC_LINEAR_SAMPLE_ENA(~0u)},
	{53332, S_0286CC_LINEAR_CENTER_ENA(~0u)},
	{53350, S_0286CC_LINEAR_CENTROID_ENA(~0u)},
	{53370, S_0286CC_LINE_STIPPLE_TEX_ENA(~0u)},
	{53391, S_0286CC_POS_X_FLOAT_ENA(~0u)},
	{53407, S_0286CC_POS_Y_FLOAT_ENA(~0u)},
	{53423, S_0286CC_POS_Z_FLOAT_ENA(~0u)},
	{53439, S_0286CC_POS_W_FLOAT_ENA(~0u)},
	{53455, S_0286CC_FRONT_FACE_ENA(~0u)},
	{53470, S_0286CC_ANCILLARY_ENA(~0u)},
	{53484, S_0286CC_SAMPLE_COVERAGE_ENA(~0u)},
	{53504, S_0286CC_POS_FIXED_PT_ENA(~0u)},
	/* 1370 */
	{53240, S_0286D0_PERSP_SAMPLE_ENA(~0u)},
	{53257, S_0286D0_PERSP_CENTER_ENA(~0u)},
	{53274, S_0286D0_PERSP_CENTROID_ENA(~0u)},
	{53293, S_0286D0_PERSP_PULL_MODEL_ENA(~0u)},
	{53314, S_0286D0_LINEAR_SAMPLE_ENA(~0u)},
	{53332, S_0286D0_LINEAR_CENTER_ENA(~0u)},
	{53350, S_0286D0_LINEAR_CENTROID_ENA(~0u)},
	{53370, S_0286D0_LINE_STIPPLE_TEX_ENA(~0u)},
	{53391, S_0286D0_POS_X_FLOAT_ENA(~0u)},
	{53407, S_0286D0_POS_Y_FLOAT_ENA(~0u)},
	{53423, S_0286D0_POS_Z_FLOAT_ENA(~0u)},
	{53439, S_0286D0_POS_W_FLOAT_ENA(~0u)},
	{53455, S_0286D0_FRONT_FACE_ENA(~0u)},
	{53470, S_0286D0_ANCILLARY_ENA(~0u)},
	{53484, S_0286D0_SAMPLE_COVERAGE_ENA(~0u)},
	{53504, S_0286D0_POS_FIXED_PT_ENA(~0u)},
	/* 1386 */
	{53521, S_0286D4_FLAT_SHADE_ENA(~0u)},
	{53536, S_0286D4_PNT_SPRITE_ENA(~0u)},
	{53659, S_0286D4_PNT_SPRITE_OVRD_X(~0u), 5, 790},
	{53677, S_0286D4_PNT_SPRITE_OVRD_Y(~0u), 5, 790},
	{53695, S_0286D4_PNT_SPRITE_OVRD_Z(~0u), 5, 790},
	{53713, S_0286D4_PNT_SPRITE_OVRD_W(~0u), 5, 790},
	{53731, S_0286D4_PNT_SPRITE_TOP_1(~0u)},
	/* 1393 */
	{53748, S_0286D8_NUM_INTERP(~0u)},
	{53759, S_0286D8_PARAM_GEN(~0u)},
	{53769, S_0286D8_FOG_ADDR(~0u)},
	{53778, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	{53798, S_0286D8_PASS_FOG_THROUGH_PS(~0u)},
	/* 1398 */
	{53818, S_0286E0_PERSP_CENTER_CNTL(~0u)},
	{53836, S_0286E0_PERSP_CENTROID_CNTL(~0u)},
	{53856, S_0286E0_LINEAR_CENTER_CNTL(~0u)},
	{53875, S_0286E0_LINEAR_CENTROID_CNTL(~0u)},
	{53945, S_0286E0_POS_FLOAT_LOCATION(~0u), 1, 795},
	{53964, S_0286E0_POS_FLOAT_ULC(~0u)},
	{53978, S_0286E0_FRONT_FACE_ALL_BITS(~0u)},
	/* 1405 */
	{47109, S_0286E8_WAVES(~0u)},
	{47115, S_0286E8_WAVESIZE(~0u)},
	/* 1407 */
	{53998, S_028704_NUM_PS_WAVES(~0u)},
	{54011, S_028704_NUM_VS_WAVES(~0u)},
	{54024, S_028704_NUM_GS_WAVES(~0u)},
	{54037, S_028704_NUM_ES_WAVES(~0u)},
	{54050, S_028704_NUM_HS_WAVES(~0u)},
	/* 1412 */
	{54063, S_028708_NUM_LS_WAVES(~0u)},
	/* 1413 */
	{54164, S_02870C_POS0_EXPORT_FORMAT(~0u), 5, 796},
	{54183, S_02870C_POS1_EXPORT_FORMAT(~0u), 5, 796},
	{54202, S_02870C_POS2_EXPORT_FORMAT(~0u), 5, 796},
	{54221, S_02870C_POS3_EXPORT_FORMAT(~0u), 5, 796},
	/* 1417 */
	{54440, S_028710_Z_EXPORT_FORMAT(~0u), 10, 801},
	/* 1418 */
	{54456, S_028714_COL0_EXPORT_FORMAT(~0u), 10, 801},
	{54475, S_028714_COL1_EXPORT_FORMAT(~0u), 10, 801},
	{54494, S_028714_COL2_EXPORT_FORMAT(~0u), 10, 801},
	{54513, S_028714_COL3_EXPORT_FORMAT(~0u), 10, 801},
	{54532, S_028714_COL4_EXPORT_FORMAT(~0u), 10, 801},
	{54551, S_028714_COL5_EXPORT_FORMAT(~0u), 10, 801},
	{54570, S_028714_COL6_EXPORT_FORMAT(~0u), 10, 801},
	{54589, S_028714_COL7_EXPORT_FORMAT(~0u), 10, 801},
	/* 1426 */
	{54843, S_028754_MRT0(~0u), 11, 811},
	{54848, S_028754_MRT1(~0u)},
	{54853, S_028754_MRT2(~0u)},
	{54858, S_028754_MRT3(~0u)},
	{54863, S_028754_MRT4(~0u)},
	{54868, S_028754_MRT5(~0u)},
	{54873, S_028754_MRT6(~0u)},
	{54878, S_028754_MRT7(~0u)},
	/* 1434 */
	{54963, S_028758_MRT0_EPSILON(~0u), 16, 822},
	{54976, S_028758_MRT1_EPSILON(~0u)},
	{54989, S_028758_MRT2_EPSILON(~0u)},
	{55002, S_028758_MRT3_EPSILON(~0u)},
	{55015, S_028758_MRT4_EPSILON(~0u)},
	{55028, S_028758_MRT5_EPSILON(~0u)},
	{55041, S_028758_MRT6_EPSILON(~0u)},
	{55054, S_028758_MRT7_EPSILON(~0u)},
	/* 1442 */
	{55067, S_02875C_MRT0_COLOR_OPT_DISABLE(~0u)},
	{55090, S_02875C_MRT0_ALPHA_OPT_DISABLE(~0u)},
	{55113, S_02875C_MRT1_COLOR_OPT_DISABLE(~0u)},
	{55136, S_02875C_MRT1_ALPHA_OPT_DISABLE(~0u)},
	{55159, S_02875C_MRT2_COLOR_OPT_DISABLE(~0u)},
	{55182, S_02875C_MRT2_ALPHA_OPT_DISABLE(~0u)},
	{55205, S_02875C_MRT3_COLOR_OPT_DISABLE(~0u)},
	{55228, S_02875C_MRT3_ALPHA_OPT_DISABLE(~0u)},
	{55251, S_02875C_MRT4_COLOR_OPT_DISABLE(~0u)},
	{55274, S_02875C_MRT4_ALPHA_OPT_DISABLE(~0u)},
	{55297, S_02875C_MRT5_COLOR_OPT_DISABLE(~0u)},
	{55320, S_02875C_MRT5_ALPHA_OPT_DISABLE(~0u)},
	{55343, S_02875C_MRT6_COLOR_OPT_DISABLE(~0u)},
	{55366, S_02875C_MRT6_ALPHA_OPT_DISABLE(~0u)},
	{55389, S_02875C_MRT7_COLOR_OPT_DISABLE(~0u)},
	{55412, S_02875C_MRT7_ALPHA_OPT_DISABLE(~0u)},
	{55435, S_02875C_PIXEN_ZERO_OPT_DISABLE(~0u)},
	/* 1459 */
	{55726, S_028760_COLOR_SRC_OPT(~0u), 8, 838},
	{55740, S_028760_COLOR_DST_OPT(~0u)},
	{55888, S_028760_COLOR_COMB_FCN(~0u), 8, 846},
	{55903, S_028760_ALPHA_SRC_OPT(~0u)},
	{55917, S_028760_ALPHA_DST_OPT(~0u)},
	{55931, S_028760_ALPHA_COMB_FCN(~0u)},
	/* 1465 */
	{55726, S_028764_COLOR_SRC_OPT(~0u)},
	{55740, S_028764_COLOR_DST_OPT(~0u)},
	{55888, S_028764_COLOR_COMB_FCN(~0u)},
	{55903, S_028764_ALPHA_SRC_OPT(~0u)},
	{55917, S_028764_ALPHA_DST_OPT(~0u)},
	{55931, S_028764_ALPHA_COMB_FCN(~0u)},
	/* 1471 */
	{55726, S_028768_COLOR_SRC_OPT(~0u)},
	{55740, S_028768_COLOR_DST_OPT(~0u)},
	{55888, S_028768_COLOR_COMB_FCN(~0u)},
	{55903, S_028768_ALPHA_SRC_OPT(~0u)},
	{55917, S_028768_ALPHA_DST_OPT(~0u)},
	{55931, S_028768_ALPHA_COMB_FCN(~0u)},
	/* 1477 */
	{55726, S_02876C_COLOR_SRC_OPT(~0u)},
	{55740, S_02876C_COLOR_DST_OPT(~0u)},
	{55888, S_02876C_COLOR_COMB_FCN(~0u)},
	{55903, S_02876C_ALPHA_SRC_OPT(~0u)},
	{55917, S_02876C_ALPHA_DST_OPT(~0u)},
	{55931, S_02876C_ALPHA_COMB_FCN(~0u)},
	/* 1483 */
	{55726, S_028770_COLOR_SRC_OPT(~0u)},
	{55740, S_028770_COLOR_DST_OPT(~0u)},
	{55888, S_028770_COLOR_COMB_FCN(~0u)},
	{55903, S_028770_ALPHA_SRC_OPT(~0u)},
	{55917, S_028770_ALPHA_DST_OPT(~0u)},
	{55931, S_028770_ALPHA_COMB_FCN(~0u)},
	/* 1489 */
	{55726, S_028774_COLOR_SRC_OPT(~0u)},
	{55740, S_028774_COLOR_DST_OPT(~0u)},
	{55888, S_028774_COLOR_COMB_FCN(~0u)},
	{55903, S_028774_ALPHA_SRC_OPT(~0u)},
	{55917, S_028774_ALPHA_DST_OPT(~0u)},
	{55931, S_028774_ALPHA_COMB_FCN(~0u)},
	/* 1495 */
	{55726, S_028778_COLOR_SRC_OPT(~0u)},
	{55740, S_028778_COLOR_DST_OPT(~0u)},
	{55888, S_028778_COLOR_COMB_FCN(~0u)},
	{55903, S_028778_ALPHA_SRC_OPT(~0u)},
	{55917, S_028778_ALPHA_DST_OPT(~0u)},
	{55931, S_028778_ALPHA_COMB_FCN(~0u)},
	/* 1501 */
	{55726, S_02877C_COLOR_SRC_OPT(~0u)},
	{55740, S_02877C_COLOR_DST_OPT(~0u)},
	{55888, S_02877C_COLOR_COMB_FCN(~0u)},
	{55903, S_02877C_ALPHA_SRC_OPT(~0u)},
	{55917, S_02877C_ALPHA_DST_OPT(~0u)},
	{55931, S_02877C_ALPHA_COMB_FCN(~0u)},
	/* 1507 */
	{56340, S_028780_COLOR_SRCBLEND(~0u), 21, 854},
	{55888, S_028780_COLOR_COMB_FCN(~0u), 5, 875},
	{56445, S_028780_COLOR_DESTBLEND(~0u), 21, 854},
	{56461, S_028780_ALPHA_SRCBLEND(~0u), 21, 854},
	{55931, S_028780_ALPHA_COMB_FCN(~0u), 5, 875},
	{56476, S_028780_ALPHA_DESTBLEND(~0u), 21, 854},
	{56492, S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{7643, S_028780_ENABLE(~0u)},
	{56513, S_028780_DISABLE_ROP3(~0u)},
	/* 1516 */
	{56526, S_0287CC_SRC_STATE_ID(~0u)},
	/* 1517 */
	{56539, S_0287E4_BASE_ADDR_GFX6(~0u)},
	/* 1518 */
	{56632, S_0287F0_SOURCE_SELECT(~0u), 4, 880},
	{56678, S_0287F0_MAJOR_MODE(~0u), 2, 884},
	{56689, S_0287F0_NOT_EOP(~0u)},
	{56697, S_0287F0_USE_OPAQUE(~0u)},
	/* 1522 */
	{56708, S_0287F8_ADDRESS_LOW(~0u)},
	/* 1523 */
	{56720, S_028800_STENCIL_ENABLE(~0u)},
	{48847, S_028800_Z_ENABLE(~0u)},
	{56735, S_028800_Z_WRITE_ENABLE(~0u)},
	{56750, S_028800_DEPTH_BOUNDS_ENABLE(~0u)},
	{49647, S_028800_ZFUNC(~0u), 8, 886},
	{56865, S_028800_BACKFACE_ENABLE(~0u)},
	{56968, S_028800_STENCILFUNC(~0u), 8, 894},
	{56980, S_028800_STENCILFUNC_BF(~0u), 8, 894},
	{56995, S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(~0u)},
	{57029, S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(~0u)},
	/* 1533 */
	{57064, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{57083, S_028804_PS_ITER_SAMPLES(~0u)},
	{57099, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{57123, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{57149, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{57176, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{57198, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{57217, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{57235, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{57262, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{57289, S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{57314, S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
	/* 1545 */
	{57345, S_028808_DISABLE_DUAL_QUAD(~0u)},
	{57363, S_028808_DEGAMMA_ENABLE(~0u)},
	{22279, S_028808_MODE(~0u), 7, 902},
	{56521, S_028808_ROP3(~0u), 256, 909},
	/* 1549 */
	{57673, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{57689, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{57720, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{48905, S_02880C_Z_ORDER(~0u), 4, 1165},
	{57799, S_02880C_KILL_ENABLE(~0u)},
	{57811, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{57835, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{57854, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{57872, S_02880C_EXEC_ON_NOOP(~0u)},
	{57885, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{57907, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{57997, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 1169},
	{58019, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	/* 1562 */
	{58037, S_028810_UCP_ENA_0(~0u)},
	{58047, S_028810_UCP_ENA_1(~0u)},
	{58057, S_028810_UCP_ENA_2(~0u)},
	{58067, S_028810_UCP_ENA_3(~0u)},
	{58077, S_028810_UCP_ENA_4(~0u)},
	{58087, S_028810_UCP_ENA_5(~0u)},
	{58097, S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{58116, S_028810_PS_UCP_MODE(~0u)},
	{58128, S_028810_CLIP_DISABLE(~0u)},
	{58141, S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{58159, S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{58182, S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{58200, S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{58220, S_028810_VTX_KILL_OR(~0u)},
	{58232, S_028810_DX_RASTERIZATION_KILL(~0u)},
	{58254, S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{58278, S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{58304, S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{58323, S_028810_ZCLIP_FAR_DISABLE(~0u)},
	/* 1581 */
	{58341, S_028814_CULL_FRONT(~0u)},
	{58352, S_028814_CULL_BACK(~0u)},
	{22820, S_028814_FACE(~0u)},
	{58372, S_028814_POLY_MODE(~0u), 2, 1173},
	{58438, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 1175},
	{58459, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 1175},
	{58479, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{58504, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{58528, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{58552, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{58577, S_028814_PROVOKING_VTX_LAST(~0u)},
	{58596, S_028814_PERSP_CORR_DIS(~0u)},
	{58611, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	/* 1594 */
	{58629, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{58647, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{58666, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{58684, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{58703, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{58721, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{58740, S_028818_VTX_XY_FMT(~0u)},
	{58751, S_028818_VTX_Z_FMT(~0u)},
	{58761, S_028818_VTX_W0_FMT(~0u)},
	/* 1603 */
	{58772, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{58788, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{58804, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{58820, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{58836, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{58852, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{58868, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{58884, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{58900, S_02881C_CULL_DIST_ENA_0(~0u)},
	{58916, S_02881C_CULL_DIST_ENA_1(~0u)},
	{58932, S_02881C_CULL_DIST_ENA_2(~0u)},
	{58948, S_02881C_CULL_DIST_ENA_3(~0u)},
	{58964, S_02881C_CULL_DIST_ENA_4(~0u)},
	{58980, S_02881C_CULL_DIST_ENA_5(~0u)},
	{58996, S_02881C_CULL_DIST_ENA_6(~0u)},
	{59012, S_02881C_CULL_DIST_ENA_7(~0u)},
	{59028, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{59047, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{59065, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{59092, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{59114, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{59132, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{59152, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{59175, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{59198, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{59223, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{59243, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	/* 1630 */
	{59262, S_028820_VTE_XY_INF_DISCARD(~0u)},
	{59281, S_028820_VTE_Z_INF_DISCARD(~0u)},
	{59299, S_028820_VTE_W_INF_DISCARD(~0u)},
	{59317, S_028820_VTE_0XNANINF_IS_0(~0u)},
	{59335, S_028820_VTE_XY_NAN_RETAIN(~0u)},
	{59353, S_028820_VTE_Z_NAN_RETAIN(~0u)},
	{59370, S_028820_VTE_W_NAN_RETAIN(~0u)},
	{59387, S_028820_VTE_W_RECIP_NAN_IS_0(~0u)},
	{59408, S_028820_VS_XY_NAN_TO_INF(~0u)},
	{59425, S_028820_VS_XY_INF_RETAIN(~0u)},
	{59442, S_028820_VS_Z_NAN_TO_INF(~0u)},
	{59458, S_028820_VS_Z_INF_RETAIN(~0u)},
	{59474, S_028820_VS_W_NAN_TO_INF(~0u)},
	{59490, S_028820_VS_W_INF_RETAIN(~0u)},
	{59506, S_028820_VS_CLIP_DIST_INF_DISCARD(~0u)},
	{59531, S_028820_VTE_NO_OUTPUT_NEG_0(~0u)},
	/* 1646 */
	{59551, S_028824_LINE_STIPPLE_RESET(~0u)},
	{59570, S_028824_EXPAND_FULL_LENGTH(~0u)},
	{59589, S_028824_FRACTIONAL_ACCUM(~0u)},
	{59606, S_028824_DIAMOND_ADJUST(~0u)},
	/* 1650 */
	{59621, S_02882C_TRIANGLE_FILTER_DISABLE(~0u)},
	{59645, S_02882C_LINE_FILTER_DISABLE(~0u)},
	{59665, S_02882C_POINT_FILTER_DISABLE(~0u)},
	{59686, S_02882C_RECTANGLE_FILTER_DISABLE(~0u)},
	{59711, S_02882C_TRIANGLE_EXPAND_ENA(~0u)},
	{59731, S_02882C_LINE_EXPAND_ENA(~0u)},
	{59747, S_02882C_POINT_EXPAND_ENA(~0u)},
	{59764, S_02882C_RECTANGLE_EXPAND_ENA(~0u)},
	{59785, S_02882C_PRIM_EXPAND_CONSTANT(~0u)},
	{59806, S_02882C_XMAX_RIGHT_EXCLUSION(~0u)},
	{59827, S_02882C_YMAX_BOTTOM_EXCLUSION(~0u)},
	/* 1661 */
	{59849, S_028830_SMALL_PRIM_FILTER_ENABLE(~0u)},
	{59621, S_028830_TRIANGLE_FILTER_DISABLE(~0u)},
	{59645, S_028830_LINE_FILTER_DISABLE(~0u)},
	{59665, S_028830_POINT_FILTER_DISABLE(~0u)},
	{59686, S_028830_RECTANGLE_FILTER_DISABLE(~0u)},
	/* 1666 */
	{42135, S_028A00_HEIGHT(~0u)},
	{42129, S_028A00_WIDTH(~0u)},
	/* 1668 */
	{59874, S_028A04_MIN_SIZE(~0u)},
	{22515, S_028A04_MAX_SIZE(~0u)},
	/* 1670 */
	{42129, S_028A08_WIDTH(~0u)},
	/* 1671 */
	{59883, S_028A0C_LINE_PATTERN(~0u)},
	{59896, S_028A0C_REPEAT_COUNT(~0u)},
	{59909, S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{59927, S_028A0C_AUTO_RESET_CNTL(~0u)},
	/* 1675 */
	{60048, S_028A10_PATH_SELECT(~0u), 5, 1178},
	/* 1676 */
	{60060, S_028A14_TESS_MODE(~0u)},
	/* 1677 */
	{22108, S_028A20_REUSE_DEPTH(~0u)},
	/* 1678 */
	{22130, S_028A24_PRIM_TYPE(~0u), 18, 1183},
	{60425, S_028A24_RETAIN_ORDER(~0u)},
	{60438, S_028A24_RETAIN_QUADS(~0u)},
	{60519, S_028A24_PRIM_ORDER(~0u), 5, 1201},
	/* 1682 */
	{22150, S_028A28_FIRST_DECR(~0u)},
	/* 1683 */
	{22156, S_028A2C_DECR(~0u)},
	/* 1684 */
	{60530, S_028A30_COMP_X_EN(~0u)},
	{60540, S_028A30_COMP_Y_EN(~0u)},
	{60550, S_028A30_COMP_Z_EN(~0u)},
	{60560, S_028A30_COMP_W_EN(~0u)},
	{23319, S_028A30_STRIDE(~0u)},
	{60570, S_028A30_SHIFT(~0u)},
	/* 1690 */
	{60530, S_028A34_COMP_X_EN(~0u)},
	{60540, S_028A34_COMP_Y_EN(~0u)},
	{60550, S_028A34_COMP_Z_EN(~0u)},
	{60560, S_028A34_COMP_W_EN(~0u)},
	{23319, S_028A34_STRIDE(~0u)},
	{60570, S_028A34_SHIFT(~0u)},
	/* 1696 */
	{60735, S_028A38_X_CONV(~0u), 9, 1206},
	{17707, S_028A38_X_OFFSET(~0u)},
	{60742, S_028A38_Y_CONV(~0u), 9, 1206},
	{50150, S_028A38_Y_OFFSET(~0u)},
	{60749, S_028A38_Z_CONV(~0u), 9, 1206},
	{60756, S_028A38_Z_OFFSET(~0u)},
	{60765, S_028A38_W_CONV(~0u), 9, 1206},
	{15767, S_028A38_W_OFFSET(~0u)},
	/* 1704 */
	{60735, S_028A3C_X_CONV(~0u), 9, 1206},
	{17707, S_028A3C_X_OFFSET(~0u)},
	{60742, S_028A3C_Y_CONV(~0u), 9, 1206},
	{50150, S_028A3C_Y_OFFSET(~0u)},
	{60749, S_028A3C_Z_CONV(~0u), 9, 1206},
	{60756, S_028A3C_Z_OFFSET(~0u)},
	{60765, S_028A3C_W_CONV(~0u), 9, 1206},
	{15767, S_028A3C_W_OFFSET(~0u)},
	/* 1712 */
	{22279, S_028A40_MODE(~0u), 6, 1215},
	{39276, S_028A40_RESERVED_0(~0u)},
	{60890, S_028A40_CUT_MODE(~0u), 4, 1221},
	{39294, S_028A40_RESERVED_1(~0u)},
	{60899, S_028A40_GS_C_PACK_EN(~0u)},
	{60912, S_028A40_RESERVED_2(~0u)},
	{60923, S_028A40_ES_PASSTHRU(~0u)},
	{60935, S_028A40_COMPUTE_MODE(~0u)},
	{60948, S_028A40_FAST_COMPUTE_MODE(~0u)},
	{60966, S_028A40_ELEMENT_INFO_EN(~0u)},
	{60982, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{61001, S_028A40_SUPPRESS_CUTS(~0u)},
	{61015, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{61033, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{61084, S_028A40_ONCHIP(~0u), 4, 1225},
	/* 1727 */
	{61091, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{61111, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	/* 1729 */
	{61131, S_028A48_MSAA_ENABLE(~0u)},
	{61143, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{61164, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{61184, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	/* 1733 */
	{61209, S_028A4C_WALK_SIZE(~0u)},
	{61219, S_028A4C_WALK_ALIGNMENT(~0u)},
	{61234, S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(~0u)},
	{61259, S_028A4C_WALK_FENCE_ENABLE(~0u)},
	{61277, S_028A4C_WALK_FENCE_SIZE(~0u)},
	{61293, S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(~0u)},
	{61298, S_028A4C_TILE_WALK_ORDER_ENABLE(~0u)},
	{61321, S_028A4C_TILE_COVER_DISABLE(~0u)},
	{61340, S_028A4C_TILE_COVER_NO_SCISSOR(~0u)},
	{61362, S_028A4C_ZMM_LINE_EXTENT(~0u)},
	{61378, S_028A4C_ZMM_LINE_OFFSET(~0u)},
	{61394, S_028A4C_ZMM_RECT_EXTENT(~0u)},
	{61410, S_028A4C_KILL_PIX_POST_HI_Z(~0u)},
	{61429, S_028A4C_KILL_PIX_POST_DETAIL_MASK(~0u)},
	{61455, S_028A4C_PS_ITER_SAMPLE(~0u)},
	{61470, S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(~0u)},
	{61510, S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(~0u)},
	{61537, S_028A4C_GPU_ID_OVERRIDE_ENABLE(~0u)},
	{61560, S_028A4C_GPU_ID_OVERRIDE(~0u)},
	{61576, S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(~0u)},
	{61606, S_028A4C_FORCE_EOV_CNTDWN_ENABLE(~0u)},
	{61630, S_028A4C_FORCE_EOV_REZ_ENABLE(~0u)},
	{61651, S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(~0u)},
	{61681, S_028A4C_OUT_OF_ORDER_WATER_MARK(~0u)},
	/* 1757 */
	{22355, S_028A54_GS_PER_ES(~0u)},
	/* 1758 */
	{22369, S_028A58_ES_PER_GS(~0u)},
	/* 1759 */
	{22383, S_028A5C_GS_PER_VS(~0u)},
	/* 1760 */
	{669, S_028A60_OFFSET(~0u)},
	/* 1761 */
	{669, S_028A64_OFFSET(~0u)},
	/* 1762 */
	{669, S_028A68_OFFSET(~0u)},
	/* 1763 */
	{61773, S_028A6C_OUTPRIM_TYPE(~0u), 3, 1229},
	{61786, S_028A6C_OUTPRIM_TYPE_1(~0u)},
	{61801, S_028A6C_OUTPRIM_TYPE_2(~0u)},
	{61816, S_028A6C_OUTPRIM_TYPE_3(~0u)},
	{61831, S_028A6C_UNIQUE_TYPE_PER_STREAM(~0u)},
	/* 1768 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 1232},
	{61968, S_028A7C_SWAP_MODE(~0u), 4, 1235},
	{62029, S_028A7C_BUF_TYPE(~0u), 3, 1239},
	{62071, S_028A7C_RDREQ_POLICY_CIK(~0u), 2, 1242},
	{62088, S_028A7C_RDREQ_POLICY(~0u)},
	{40000, S_028A7C_ATC(~0u)},
	{56689, S_028A7C_NOT_EOP(~0u)},
	{62101, S_028A7C_REQ_PATH(~0u)},
	{40021, S_028A7C_MTYPE(~0u)},
	/* 1777 */
	{22558, S_028A84_PRIMITIVEID_EN(~0u)},
	{62110, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	/* 1779 */
	{63066, S_028A90_EVENT_TYPE(~0u), 59, 1244},
	{63077, S_028A90_ADDRESS_HI_GFX6(~0u)},
	{63093, S_028A90_EXTENDED_EVENT(~0u)},
	/* 1782 */
	{22655, S_028A94_RESET_EN(~0u)},
	/* 1783 */
	{63108, S_028AA8_PRIMGROUP_SIZE(~0u)},
	{63123, S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{63142, S_028AA8_SWITCH_ON_EOP(~0u)},
	{63156, S_028AA8_PARTIAL_ES_WAVE_ON(~0u)},
	{63175, S_028AA8_SWITCH_ON_EOI(~0u)},
	{63189, S_028AA8_WD_SWITCH_ON_EOP(~0u)},
	{63206, S_028AA8_MAX_PRIMGRP_IN_WAVE(~0u)},
	/* 1790 */
	{22747, S_028AAC_ITEMSIZE(~0u)},
	/* 1791 */
	{22747, S_028AB0_ITEMSIZE(~0u)},
	/* 1792 */
	{22783, S_028AB4_REUSE_OFF(~0u)},
	/* 1793 */
	{22797, S_028AB8_VTX_CNT_EN(~0u)},
	/* 1794 */
	{43354, S_028ABC_LINEAR(~0u)},
	{63226, S_028ABC_FULL_CACHE(~0u)},
	{63237, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{63260, S_028ABC_PRELOAD(~0u)},
	{63268, S_028ABC_PREFETCH_WIDTH(~0u)},
	{63283, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{63299, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{63323, S_028ABC_TC_COMPATIBLE(~0u)},
	/* 1802 */
	{63337, S_028AC0_COMPAREFUNC0(~0u), 8, 894},
	{63350, S_028AC0_COMPAREVALUE0(~0u)},
	{63364, S_028AC0_COMPAREMASK0(~0u)},
	{48866, S_028AC0_ENABLE0(~0u)},
	/* 1806 */
	{63377, S_028AC4_COMPAREFUNC1(~0u), 8, 894},
	{63390, S_028AC4_COMPAREVALUE1(~0u)},
	{63404, S_028AC4_COMPAREMASK1(~0u)},
	{48884, S_028AC4_ENABLE1(~0u)},
	/* 1810 */
	{7499, S_028AC8_START_X(~0u)},
	{7515, S_028AC8_START_Y(~0u)},
	{63417, S_028AC8_MAX_X(~0u)},
	{63423, S_028AC8_MAX_Y(~0u)},
	/* 1814 */
	{23319, S_028AD4_STRIDE(~0u)},
	/* 1815 */
	{23319, S_028AE4_STRIDE(~0u)},
	/* 1816 */
	{23319, S_028AF4_STRIDE(~0u)},
	/* 1817 */
	{23319, S_028B04_STRIDE(~0u)},
	/* 1818 */
	{23312, S_028B30_VERTEX_STRIDE(~0u)},
	/* 1819 */
	{23333, S_028B38_MAX_VERT_OUT(~0u)},
	/* 1820 */
	{63429, S_028B50_ACCUM_ISOLINE(~0u)},
	{63443, S_028B50_ACCUM_TRI(~0u)},
	{63453, S_028B50_ACCUM_QUAD(~0u)},
	{63464, S_028B50_DONUT_SPLIT(~0u)},
	{63476, S_028B50_TRAP_SPLIT(~0u)},
	/* 1825 */
	{48050, S_028B54_LS_EN(~0u), 3, 1303},
	{48044, S_028B54_HS_EN(~0u)},
	{23383, S_028B54_ES_EN(~0u), 3, 1306},
	{48038, S_028B54_GS_EN(~0u)},
	{48032, S_028B54_VS_EN(~0u), 3, 1309},
	{63610, S_028B54_DYNAMIC_HS(~0u)},
	{46625, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{63621, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{63641, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{63661, S_028B54_VS_WAVE_ID_EN(~0u)},
	/* 1835 */
	{63675, S_028B58_NUM_PATCHES(~0u)},
	{63687, S_028B58_HS_NUM_INPUT_CP(~0u)},
	{63703, S_028B58_HS_NUM_OUTPUT_CP(~0u)},
	/* 1838 */
	{22747, S_028B5C_ITEMSIZE(~0u)},
	/* 1839 */
	{22747, S_028B60_ITEMSIZE(~0u)},
	/* 1840 */
	{22747, S_028B64_ITEMSIZE(~0u)},
	/* 1841 */
	{22747, S_028B68_ITEMSIZE(~0u)},
	/* 1842 */
	{209, S_028B6C_TYPE(~0u), 3, 1312},
	{63809, S_028B6C_PARTITIONING(~0u), 4, 1315},
	{63886, S_028B6C_TOPOLOGY(~0u), 4, 1319},
	{63895, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{63915, S_028B6C_DEPRECATED(~0u)},
	{63926, S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	{63948, S_028B6C_DISABLE_DONUTS(~0u)},
	{62071, S_028B6C_RDREQ_POLICY_CIK(~0u), 3, 1323},
	{62088, S_028B6C_RDREQ_POLICY(~0u)},
	{64087, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 1326},
	{40021, S_028B6C_MTYPE(~0u)},
	/* 1853 */
	{64105, S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{64126, S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{64148, S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{64170, S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{64192, S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{64214, S_028B70_OFFSET_ROUND(~0u)},
	/* 1859 */
	{64227, S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{64255, S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
	/* 1861 */
	{7643, S_028B90_ENABLE(~0u)},
	{23740, S_028B90_CNT(~0u)},
	/* 1863 */
	{64283, S_028B94_STREAMOUT_0_EN(~0u)},
	{64298, S_028B94_STREAMOUT_1_EN(~0u)},
	{64313, S_028B94_STREAMOUT_2_EN(~0u)},
	{64328, S_028B94_STREAMOUT_3_EN(~0u)},
	{64343, S_028B94_RAST_STREAM(~0u)},
	{64355, S_028B94_RAST_STREAM_MASK(~0u)},
	{64372, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 1870 */
	{64393, S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{64412, S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{64431, S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{64450, S_028B98_STREAM_3_BUFFER_EN(~0u)},
	/* 1874 */
	{64469, S_028BD4_DISTANCE_0(~0u)},
	{64480, S_028BD4_DISTANCE_1(~0u)},
	{64491, S_028BD4_DISTANCE_2(~0u)},
	{64502, S_028BD4_DISTANCE_3(~0u)},
	{64513, S_028BD4_DISTANCE_4(~0u)},
	{64524, S_028BD4_DISTANCE_5(~0u)},
	{64535, S_028BD4_DISTANCE_6(~0u)},
	{64546, S_028BD4_DISTANCE_7(~0u)},
	/* 1882 */
	{64557, S_028BD8_DISTANCE_8(~0u)},
	{64568, S_028BD8_DISTANCE_9(~0u)},
	{64579, S_028BD8_DISTANCE_10(~0u)},
	{64591, S_028BD8_DISTANCE_11(~0u)},
	{64603, S_028BD8_DISTANCE_12(~0u)},
	{64615, S_028BD8_DISTANCE_13(~0u)},
	{64627, S_028BD8_DISTANCE_14(~0u)},
	{64639, S_028BD8_DISTANCE_15(~0u)},
	/* 1890 */
	{64651, S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{64669, S_028BDC_LAST_PIXEL(~0u)},
	{64680, S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{64705, S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
	/* 1894 */
	{64727, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{64744, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{64766, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{64782, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{64803, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	/* 1899 */
	{64826, S_028BE4_PIX_CENTER(~0u)},
	{64887, S_028BE4_ROUND_MODE(~0u), 4, 1330},
	{65103, S_028BE4_QUANT_MODE(~0u), 8, 1334},
	/* 1902 */
	{65114, S_028BF8_S0_X(~0u)},
	{65119, S_028BF8_S0_Y(~0u)},
	{65124, S_028BF8_S1_X(~0u)},
	{65129, S_028BF8_S1_Y(~0u)},
	{65134, S_028BF8_S2_X(~0u)},
	{65139, S_028BF8_S2_Y(~0u)},
	{65144, S_028BF8_S3_X(~0u)},
	{65149, S_028BF8_S3_Y(~0u)},
	/* 1910 */
	{65154, S_028BFC_S4_X(~0u)},
	{65159, S_028BFC_S4_Y(~0u)},
	{65164, S_028BFC_S5_X(~0u)},
	{65169, S_028BFC_S5_Y(~0u)},
	{65174, S_028BFC_S6_X(~0u)},
	{65179, S_028BFC_S6_Y(~0u)},
	{65184, S_028BFC_S7_X(~0u)},
	{65189, S_028BFC_S7_Y(~0u)},
	/* 1918 */
	{65194, S_028C00_S8_X(~0u)},
	{65199, S_028C00_S8_Y(~0u)},
	{65204, S_028C00_S9_X(~0u)},
	{65209, S_028C00_S9_Y(~0u)},
	{65214, S_028C00_S10_X(~0u)},
	{65220, S_028C00_S10_Y(~0u)},
	{65226, S_028C00_S11_X(~0u)},
	{65232, S_028C00_S11_Y(~0u)},
	/* 1926 */
	{65238, S_028C04_S12_X(~0u)},
	{65244, S_028C04_S12_Y(~0u)},
	{65250, S_028C04_S13_X(~0u)},
	{65256, S_028C04_S13_Y(~0u)},
	{65262, S_028C04_S14_X(~0u)},
	{65268, S_028C04_S14_Y(~0u)},
	{65274, S_028C04_S15_X(~0u)},
	{65280, S_028C04_S15_Y(~0u)},
	/* 1934 */
	{65114, S_028C08_S0_X(~0u)},
	{65119, S_028C08_S0_Y(~0u)},
	{65124, S_028C08_S1_X(~0u)},
	{65129, S_028C08_S1_Y(~0u)},
	{65134, S_028C08_S2_X(~0u)},
	{65139, S_028C08_S2_Y(~0u)},
	{65144, S_028C08_S3_X(~0u)},
	{65149, S_028C08_S3_Y(~0u)},
	/* 1942 */
	{65154, S_028C0C_S4_X(~0u)},
	{65159, S_028C0C_S4_Y(~0u)},
	{65164, S_028C0C_S5_X(~0u)},
	{65169, S_028C0C_S5_Y(~0u)},
	{65174, S_028C0C_S6_X(~0u)},
	{65179, S_028C0C_S6_Y(~0u)},
	{65184, S_028C0C_S7_X(~0u)},
	{65189, S_028C0C_S7_Y(~0u)},
	/* 1950 */
	{65194, S_028C10_S8_X(~0u)},
	{65199, S_028C10_S8_Y(~0u)},
	{65204, S_028C10_S9_X(~0u)},
	{65209, S_028C10_S9_Y(~0u)},
	{65214, S_028C10_S10_X(~0u)},
	{65220, S_028C10_S10_Y(~0u)},
	{65226, S_028C10_S11_X(~0u)},
	{65232, S_028C10_S11_Y(~0u)},
	/* 1958 */
	{65238, S_028C14_S12_X(~0u)},
	{65244, S_028C14_S12_Y(~0u)},
	{65250, S_028C14_S13_X(~0u)},
	{65256, S_028C14_S13_Y(~0u)},
	{65262, S_028C14_S14_X(~0u)},
	{65268, S_028C14_S14_Y(~0u)},
	{65274, S_028C14_S15_X(~0u)},
	{65280, S_028C14_S15_Y(~0u)},
	/* 1966 */
	{65114, S_028C18_S0_X(~0u)},
	{65119, S_028C18_S0_Y(~0u)},
	{65124, S_028C18_S1_X(~0u)},
	{65129, S_028C18_S1_Y(~0u)},
	{65134, S_028C18_S2_X(~0u)},
	{65139, S_028C18_S2_Y(~0u)},
	{65144, S_028C18_S3_X(~0u)},
	{65149, S_028C18_S3_Y(~0u)},
	/* 1974 */
	{65154, S_028C1C_S4_X(~0u)},
	{65159, S_028C1C_S4_Y(~0u)},
	{65164, S_028C1C_S5_X(~0u)},
	{65169, S_028C1C_S5_Y(~0u)},
	{65174, S_028C1C_S6_X(~0u)},
	{65179, S_028C1C_S6_Y(~0u)},
	{65184, S_028C1C_S7_X(~0u)},
	{65189, S_028C1C_S7_Y(~0u)},
	/* 1982 */
	{65194, S_028C20_S8_X(~0u)},
	{65199, S_028C20_S8_Y(~0u)},
	{65204, S_028C20_S9_X(~0u)},
	{65209, S_028C20_S9_Y(~0u)},
	{65214, S_028C20_S10_X(~0u)},
	{65220, S_028C20_S10_Y(~0u)},
	{65226, S_028C20_S11_X(~0u)},
	{65232, S_028C20_S11_Y(~0u)},
	/* 1990 */
	{65238, S_028C24_S12_X(~0u)},
	{65244, S_028C24_S12_Y(~0u)},
	{65250, S_028C24_S13_X(~0u)},
	{65256, S_028C24_S13_Y(~0u)},
	{65262, S_028C24_S14_X(~0u)},
	{65268, S_028C24_S14_Y(~0u)},
	{65274, S_028C24_S15_X(~0u)},
	{65280, S_028C24_S15_Y(~0u)},
	/* 1998 */
	{65114, S_028C28_S0_X(~0u)},
	{65119, S_028C28_S0_Y(~0u)},
	{65124, S_028C28_S1_X(~0u)},
	{65129, S_028C28_S1_Y(~0u)},
	{65134, S_028C28_S2_X(~0u)},
	{65139, S_028C28_S2_Y(~0u)},
	{65144, S_028C28_S3_X(~0u)},
	{65149, S_028C28_S3_Y(~0u)},
	/* 2006 */
	{65154, S_028C2C_S4_X(~0u)},
	{65159, S_028C2C_S4_Y(~0u)},
	{65164, S_028C2C_S5_X(~0u)},
	{65169, S_028C2C_S5_Y(~0u)},
	{65174, S_028C2C_S6_X(~0u)},
	{65179, S_028C2C_S6_Y(~0u)},
	{65184, S_028C2C_S7_X(~0u)},
	{65189, S_028C2C_S7_Y(~0u)},
	/* 2014 */
	{65194, S_028C30_S8_X(~0u)},
	{65199, S_028C30_S8_Y(~0u)},
	{65204, S_028C30_S9_X(~0u)},
	{65209, S_028C30_S9_Y(~0u)},
	{65214, S_028C30_S10_X(~0u)},
	{65220, S_028C30_S10_Y(~0u)},
	{65226, S_028C30_S11_X(~0u)},
	{65232, S_028C30_S11_Y(~0u)},
	/* 2022 */
	{65238, S_028C34_S12_X(~0u)},
	{65244, S_028C34_S12_Y(~0u)},
	{65250, S_028C34_S13_X(~0u)},
	{65256, S_028C34_S13_Y(~0u)},
	{65262, S_028C34_S14_X(~0u)},
	{65268, S_028C34_S14_Y(~0u)},
	{65274, S_028C34_S15_X(~0u)},
	{65280, S_028C34_S15_Y(~0u)},
	/* 2030 */
	{65286, S_028C38_AA_MASK_X0Y0(~0u)},
	{65299, S_028C38_AA_MASK_X1Y0(~0u)},
	/* 2032 */
	{65312, S_028C3C_AA_MASK_X0Y1(~0u)},
	{65325, S_028C3C_AA_MASK_X1Y1(~0u)},
	/* 2034 */
	{65338, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	/* 2035 */
	{65367, S_028C58_VTX_REUSE_DEPTH(~0u)},
	/* 2036 */
	{65383, S_028C5C_DEALLOC_DIST(~0u)},
	/* 2037 */
	{50087, S_028C64_TILE_MAX(~0u)},
	{65396, S_028C64_FMASK_TILE_MAX(~0u)},
	/* 2039 */
	{50087, S_028C68_TILE_MAX(~0u)},
	/* 2040 */
	{48735, S_028C6C_SLICE_START(~0u)},
	{48747, S_028C6C_SLICE_MAX(~0u)},
	/* 2042 */
	{65462, S_028C70_ENDIAN(~0u), 4, 1342},
	{21132, S_028C70_FORMAT(~0u), 23, 1346},
	{45014, S_028C70_LINEAR_GENERAL(~0u)},
	{65829, S_028C70_NUMBER_TYPE(~0u), 8, 1369},
	{65885, S_028C70_COMP_SWAP(~0u), 4, 1377},
	{57412, S_028C70_FAST_CLEAR(~0u)},
	{49321, S_028C70_COMPRESSION(~0u)},
	{65895, S_028C70_BLEND_CLAMP(~0u)},
	{65907, S_028C70_BLEND_BYPASS(~0u)},
	{65920, S_028C70_SIMPLE_FLOAT(~0u)},
	{64887, S_028C70_ROUND_MODE(~0u)},
	{65933, S_028C70_CMASK_IS_LINEAR(~0u)},
	{66160, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 1381},
	{66182, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 1381},
	{66206, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{66232, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{66258, S_028C70_DCC_ENABLE(~0u)},
	{66269, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 2060 */
	{49915, S_028C74_TILE_MODE_INDEX(~0u)},
	{66285, S_028C74_FMASK_TILE_MODE_INDEX(~0u)},
	{66307, S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{49903, S_028C74_NUM_SAMPLES(~0u)},
	{66325, S_028C74_NUM_FRAGMENTS(~0u)},
	{66339, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	/* 2066 */
	{52479, S_028C78_OVERWRITE_COMBINER_DISABLE(~0u)},
	{66357, S_028C78_KEY_CLEAR_ENABLE(~0u)},
	{66433, S_028C78_MAX_UNCOMPRESSED_BLOCK_SIZE(~0u), 3, 1389},
	{66499, S_028C78_MIN_COMPRESSED_BLOCK_SIZE(~0u), 2, 1392},
	{66525, S_028C78_MAX_COMPRESSED_BLOCK_SIZE(~0u)},
	{42616, S_028C78_COLOR_TRANSFORM(~0u)},
	{66551, S_028C78_INDEPENDENT_64B_BLOCKS(~0u)},
	{66574, S_028C78_LOSSY_RGB_PRECISION(~0u)},
	{66594, S_028C78_LOSSY_ALPHA_PRECISION(~0u)},
	/* 2075 */
	{50087, S_028C80_TILE_MAX(~0u)},
	/* 2076 */
	{50087, S_028C88_TILE_MAX(~0u)},
	/* 2077 */
	{33093, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{33116, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{33139, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{33162, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{33182, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{33202, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{33222, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{33242, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{33262, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{33282, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{33302, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{33322, S_008008_RLC_RQ_PENDING(~0u)},
	{66616, S_008008_UTCL2_BUSY(~0u)},
	{66627, S_008008_EA_BUSY(~0u)},
	{66635, S_008008_RMI_BUSY(~0u)},
	{66644, S_008008_UTCL2_RQ_PENDING(~0u)},
	{66661, S_008008_CPF_RQ_PENDING(~0u)},
	{66676, S_008008_EA_LINK_BUSY(~0u)},
	{33337, S_008008_RLC_BUSY(~0u)},
	{33346, S_008008_TC_BUSY(~0u)},
	{33354, S_008008_TCC_CC_RESIDENT(~0u)},
	{33370, S_008008_CPF_BUSY(~0u)},
	{33379, S_008008_CPC_BUSY(~0u)},
	{33388, S_008008_CPG_BUSY(~0u)},
	{66689, S_008008_CPAXI_BUSY(~0u)},
	/* 2102 */
	{33397, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{66700, S_008010_RSMU_RQ_PENDING(~0u)},
	{33436, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{33459, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{33482, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{33501, S_008010_DB_CLEAN(~0u)},
	{33510, S_008010_CB_CLEAN(~0u)},
	{33519, S_008010_TA_BUSY(~0u)},
	{33527, S_008010_GDS_BUSY(~0u)},
	{33536, S_008010_WD_BUSY_NO_DMA(~0u)},
	{33551, S_008010_VGT_BUSY(~0u)},
	{33560, S_008010_IA_BUSY_NO_DMA(~0u)},
	{33575, S_008010_IA_BUSY(~0u)},
	{33583, S_008010_SX_BUSY(~0u)},
	{33591, S_008010_WD_BUSY(~0u)},
	{33599, S_008010_SPI_BUSY(~0u)},
	{33608, S_008010_BCI_BUSY(~0u)},
	{33617, S_008010_SC_BUSY(~0u)},
	{33625, S_008010_PA_BUSY(~0u)},
	{33633, S_008010_DB_BUSY(~0u)},
	{33641, S_008010_CP_COHERENCY_BUSY(~0u)},
	{32204, S_008010_CP_BUSY(~0u)},
	{32426, S_008010_CB_BUSY(~0u)},
	{33659, S_008010_GUI_ACTIVE(~0u)},
	/* 2126 */
	{33501, S_008014_DB_CLEAN(~0u)},
	{33510, S_008014_CB_CLEAN(~0u)},
	{66635, S_008014_RMI_BUSY(~0u)},
	{33608, S_008014_BCI_BUSY(~0u)},
	{33551, S_008014_VGT_BUSY(~0u)},
	{33625, S_008014_PA_BUSY(~0u)},
	{33519, S_008014_TA_BUSY(~0u)},
	{33583, S_008014_SX_BUSY(~0u)},
	{33599, S_008014_SPI_BUSY(~0u)},
	{33617, S_008014_SC_BUSY(~0u)},
	{33633, S_008014_DB_BUSY(~0u)},
	{32426, S_008014_CB_BUSY(~0u)},
	/* 2138 */
	{33501, S_008018_DB_CLEAN(~0u)},
	{33510, S_008018_CB_CLEAN(~0u)},
	{66635, S_008018_RMI_BUSY(~0u)},
	{33608, S_008018_BCI_BUSY(~0u)},
	{33551, S_008018_VGT_BUSY(~0u)},
	{33625, S_008018_PA_BUSY(~0u)},
	{33519, S_008018_TA_BUSY(~0u)},
	{33583, S_008018_SX_BUSY(~0u)},
	{33599, S_008018_SPI_BUSY(~0u)},
	{33617, S_008018_SC_BUSY(~0u)},
	{33633, S_008018_DB_BUSY(~0u)},
	{32426, S_008018_CB_BUSY(~0u)},
	/* 2150 */
	{33501, S_008038_DB_CLEAN(~0u)},
	{33510, S_008038_CB_CLEAN(~0u)},
	{66635, S_008038_RMI_BUSY(~0u)},
	{33608, S_008038_BCI_BUSY(~0u)},
	{33551, S_008038_VGT_BUSY(~0u)},
	{33625, S_008038_PA_BUSY(~0u)},
	{33519, S_008038_TA_BUSY(~0u)},
	{33583, S_008038_SX_BUSY(~0u)},
	{33599, S_008038_SPI_BUSY(~0u)},
	{33617, S_008038_SC_BUSY(~0u)},
	{33633, S_008038_DB_BUSY(~0u)},
	{32426, S_008038_CB_BUSY(~0u)},
	/* 2162 */
	{33501, S_00803C_DB_CLEAN(~0u)},
	{33510, S_00803C_CB_CLEAN(~0u)},
	{66635, S_00803C_RMI_BUSY(~0u)},
	{33608, S_00803C_BCI_BUSY(~0u)},
	{33551, S_00803C_VGT_BUSY(~0u)},
	{33625, S_00803C_PA_BUSY(~0u)},
	{33519, S_00803C_TA_BUSY(~0u)},
	{33583, S_00803C_SX_BUSY(~0u)},
	{33599, S_00803C_SPI_BUSY(~0u)},
	{33617, S_00803C_SC_BUSY(~0u)},
	{33633, S_00803C_DB_BUSY(~0u)},
	{32426, S_00803C_CB_BUSY(~0u)},
	/* 2174 */
	{34167, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{66716, S_0301F0_TC_WC_ACTION_ENA(~0u)},
	{66733, S_0301F0_TC_INV_METADATA_ACTION_ENA(~0u)},
	{34184, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{34222, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{34013, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{34029, S_0301F0_TC_ACTION_ENA(~0u)},
	{34043, S_0301F0_CB_ACTION_ENA(~0u)},
	{34057, S_0301F0_DB_ACTION_ENA(~0u)},
	{34071, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34239, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{34092, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{34264, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	/* 2187 */
	{34323, S_0301FC_MEID(~0u)},
	{1005, S_0301FC_STATUS(~0u)},
	/* 2189 */
	{34342, S_008210_MEC1_BUSY(~0u)},
	{34352, S_008210_MEC2_BUSY(~0u)},
	{34362, S_008210_DC0_BUSY(~0u)},
	{34371, S_008210_DC1_BUSY(~0u)},
	{34380, S_008210_RCIU1_BUSY(~0u)},
	{34391, S_008210_RCIU2_BUSY(~0u)},
	{34402, S_008210_ROQ1_BUSY(~0u)},
	{34412, S_008210_ROQ2_BUSY(~0u)},
	{34422, S_008210_TCIU_BUSY(~0u)},
	{34432, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{34449, S_008210_QU_BUSY(~0u)},
	{66760, S_008210_UTCL2IU_BUSY(~0u)},
	{66773, S_008210_SAVE_RESTORE_BUSY(~0u)},
	{34470, S_008210_CPG_CPC_BUSY(~0u)},
	{34483, S_008210_CPF_CPC_BUSY(~0u)},
	{33379, S_008210_CPC_BUSY(~0u)},
	/* 2205 */
	{34980, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{34999, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{35019, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{35038, S_008218_MEC1_DECODING_PACKET(~0u)},
	{35059, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{35077, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{35100, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{35122, S_008218_MEC2_DECODING_PACKET(~0u)},
	{35143, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{35161, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{35184, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{66791, S_008218_UTCL2IU_WAITING_ON_FREE(~0u)},
	{66815, S_008218_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{66839, S_008218_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 2219 */
	{35277, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{35296, S_00821C_CSF_BUSY(~0u)},
	{35305, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{35320, S_00821C_ROQ_RING_BUSY(~0u)},
	{35334, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{35353, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{35372, S_00821C_ROQ_STATE_BUSY(~0u)},
	{35387, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{35404, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35426, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{35448, S_00821C_SEMAPHORE_BUSY(~0u)},
	{35463, S_00821C_INTERRUPT_BUSY(~0u)},
	{34422, S_00821C_TCIU_BUSY(~0u)},
	{35478, S_00821C_HQD_BUSY(~0u)},
	{35487, S_00821C_PRT_BUSY(~0u)},
	{66760, S_00821C_UTCL2IU_BUSY(~0u)},
	{35496, S_00821C_CPF_GFX_BUSY(~0u)},
	{35509, S_00821C_CPF_CMP_BUSY(~0u)},
	{35522, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{35541, S_00821C_CPC_CPF_BUSY(~0u)},
	{33370, S_00821C_CPF_BUSY(~0u)},
	/* 2240 */
	{36129, S_008224_RING_FETCHING_DATA(~0u)},
	{36148, S_008224_INDR1_FETCHING_DATA(~0u)},
	{36168, S_008224_INDR2_FETCHING_DATA(~0u)},
	{36188, S_008224_STATE_FETCHING_DATA(~0u)},
	{36208, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{36229, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{66791, S_008224_UTCL2IU_WAITING_ON_FREE(~0u)},
	{66815, S_008224_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{66862, S_008224_GFX_UTCL1_WAITING_ON_TRANS(~0u)},
	{66889, S_008224_CMP_UTCL1_WAITING_ON_TRANS(~0u)},
	{66916, S_008224_RCIU_WAITING_ON_FREE(~0u)},
	/* 2251 */
	{37019, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37044, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{37082, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{37123, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{37146, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{37169, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{37193, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37223, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37252, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{37278, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{37307, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{37332, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{36208, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{36229, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{37367, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37395, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{66791, S_008670_UTCL2IU_WAITING_ON_FREE(~0u)},
	{66815, S_008670_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{66839, S_008670_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 2270 */
	{35320, S_008680_ROQ_RING_BUSY(~0u)},
	{35334, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{35353, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{35372, S_008680_ROQ_STATE_BUSY(~0u)},
	{38625, S_008680_DC_BUSY(~0u)},
	{66760, S_008680_UTCL2IU_BUSY(~0u)},
	{38633, S_008680_PFP_BUSY(~0u)},
	{38642, S_008680_MEQ_BUSY(~0u)},
	{38651, S_008680_ME_BUSY(~0u)},
	{38659, S_008680_QUERY_BUSY(~0u)},
	{35448, S_008680_SEMAPHORE_BUSY(~0u)},
	{35463, S_008680_INTERRUPT_BUSY(~0u)},
	{38670, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{32128, S_008680_DMA_BUSY(~0u)},
	{38688, S_008680_RCIU_BUSY(~0u)},
	{34432, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{38711, S_008680_CE_BUSY(~0u)},
	{34422, S_008680_TCIU_BUSY(~0u)},
	{35387, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{35404, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35426, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{32204, S_008680_CP_BUSY(~0u)},
	/* 2292 */
	{22130, S_030908_PRIM_TYPE(~0u), 29, 26},
	/* 2293 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	{66937, S_03090C_PRIMGEN_EN(~0u)},
	/* 2295 */
	{22655, S_03092C_RESET_EN(~0u)},
	{66948, S_03092C_MATCH_ALL_BITS(~0u)},
	/* 2297 */
	{36898, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{38767, S_03093C_OFFCHIP_GRANULARITY(~0u)},
	/* 2299 */
	{880, S_030944_BASE_HI(~0u)},
	/* 2300 */
	{880, S_03094C_BASE_HI(~0u)},
	/* 2301 */
	{880, S_030954_BASE_HI(~0u)},
	/* 2302 */
	{880, S_03095C_BASE_HI(~0u)},
	/* 2303 */
	{63108, S_030960_PRIMGROUP_SIZE(~0u)},
	{63123, S_030960_PARTIAL_VS_WAVE_ON(~0u)},
	{63142, S_030960_SWITCH_ON_EOP(~0u)},
	{63156, S_030960_PARTIAL_ES_WAVE_ON(~0u)},
	{63175, S_030960_SWITCH_ON_EOI(~0u)},
	{63189, S_030960_WD_SWITCH_ON_EOP(~0u)},
	{66963, S_030960_EN_INST_OPT_BASIC(~0u)},
	{66981, S_030960_EN_INST_OPT_ADV(~0u)},
	{66997, S_030960_HW_USE_ONLY(~0u)},
	/* 2312 */
	{67009, S_030D20_TARGET_INST(~0u)},
	{67021, S_030D20_TARGET_DATA(~0u)},
	{39041, S_030D20_INVALIDATE(~0u)},
	{26846, S_030D20_WRITEBACK(~0u)},
	{46843, S_030D20_VOL(~0u)},
	{67033, S_030D20_COMPLETE(~0u)},
	/* 2318 */
	{67042, S_030D24_DWB(~0u)},
	{49252, S_030D24_DIRTY(~0u)},
	/* 2320 */
	{39341, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{39351, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{39361, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{39371, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{39555, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{39947, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{67046, S_008F0C_USER_VM_ENABLE(~0u)},
	{67061, S_008F0C_USER_VM_MODE(~0u)},
	{39972, S_008F0C_INDEX_STRIDE(~0u)},
	{39985, S_008F0C_ADD_TID_ENABLE(~0u)},
	{60739, S_008F0C_NV(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 2332 */
	{39206, S_008F14_BASE_ADDRESS_HI(~0u)},
	{40096, S_008F14_MIN_LOD(~0u)},
	{67646, S_008F14_DATA_FORMAT_GFX9(~0u), 64, 1394},
	{67739, S_008F14_NUM_FORMAT_GFX9(~0u), 11, 1458},
	{67974, S_008F14_NUM_FORMAT_FMASK(~0u), 13, 1469},
	{68224, S_008F14_NUM_FORMAT_ASTC_2D(~0u), 14, 1482},
	{68423, S_008F14_NUM_FORMAT_ASTC_3D(~0u), 10, 1496},
	{60739, S_008F14_NV(~0u)},
	{68442, S_008F14_META_DIRECT(~0u)},
	/* 2341 */
	{39341, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{39351, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{39361, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{39371, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{42162, S_008F1C_BASE_LEVEL(~0u)},
	{42173, S_008F1C_LAST_LEVEL(~0u)},
	{68454, S_008F1C_SW_MODE(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 2349 */
	{22114, S_008F20_DEPTH(~0u)},
	{68462, S_008F20_PITCH_GFX9(~0u)},
	{68569, S_008F20_BC_SWIZZLE(~0u), 6, 1506},
	/* 2352 */
	{42519, S_008F24_BASE_ARRAY(~0u)},
	{68580, S_008F24_ARRAY_PITCH(~0u)},
	{68592, S_008F24_META_DATA_ADDRESS(~0u)},
	{68610, S_008F24_META_LINEAR(~0u)},
	{68622, S_008F24_META_PIPE_ALIGNED(~0u)},
	{68640, S_008F24_META_RB_ALIGNED(~0u)},
	{68656, S_008F24_MAX_MIP(~0u)},
	/* 2359 */
	{43290, S_008F38_LOD_BIAS(~0u)},
	{43299, S_008F38_LOD_BIAS_SEC(~0u)},
	{43361, S_008F38_XY_MAG_FILTER(~0u), 2, 334},
	{43436, S_008F38_XY_MIN_FILTER(~0u), 4, 336},
	{43516, S_008F38_Z_FILTER(~0u), 3, 340},
	{43525, S_008F38_MIP_FILTER(~0u), 3, 340},
	{43536, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{68664, S_008F38_BLEND_ZERO_PRT(~0u)},
	{43572, S_008F38_FILTER_PREC_FIX(~0u)},
	{43588, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 2369 */
	{43603, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{68679, S_008F3C_SKIP_DEGAMMA(~0u)},
	{43762, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 343},
	/* 2372 */
	{44113, S_031100_GPR_WRITE_PRIORITY(~0u)},
	{44132, S_031100_EXP_PRIORITY_ORDER(~0u)},
	{44151, S_031100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{44173, S_031100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{44195, S_031100_RSRC_MGMT_RESET(~0u)},
	{68692, S_031100_TTRACE_STALL_ALL(~0u)},
	{68709, S_031100_ALLOC_ARB_LRU_ENA(~0u)},
	{68727, S_031100_EXP_ARB_LRU_ENA(~0u)},
	{68743, S_031100_PS_PKR_PRIORITY_CNTL(~0u)},
	/* 2381 */
	{44464, S_031104_VTX_DONE_DELAY(~0u), 16, 348},
	{44479, S_031104_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{68764, S_031104_BATON_RESET_DISABLE(~0u)},
	{44503, S_031104_PC_LIMIT_ENABLE(~0u)},
	{44519, S_031104_PC_LIMIT_STRICT(~0u)},
	{68784, S_031104_CRC_SIMD_ID_WADDR_DISABLE(~0u)},
	{68810, S_031104_LBPW_CU_CHK_MODE(~0u)},
	{68827, S_031104_LBPW_CU_CHK_CNT(~0u)},
	{68843, S_031104_CSC_PWR_SAVE_DISABLE(~0u)},
	{68864, S_031104_CSG_PWR_SAVE_DISABLE(~0u)},
	{44535, S_031104_PC_LIMIT_SIZE(~0u)},
	/* 2392 */
	{68885, S_031108_CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD(~0u)},
	{68926, S_031108_CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD(~0u)},
	/* 2394 */
	{44711, S_0098F8_NUM_PIPES(~0u)},
	{68965, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX9(~0u)},
	{68991, S_0098F8_MAX_COMPRESSED_FRAGS(~0u)},
	{44747, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{46198, S_0098F8_NUM_BANKS(~0u)},
	{44792, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{69012, S_0098F8_NUM_SHADER_ENGINES_GFX9(~0u)},
	{69036, S_0098F8_NUM_GPUS_GFX9(~0u)},
	{44830, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{69050, S_0098F8_NUM_RB_PER_SE(~0u)},
	{44850, S_0098F8_ROW_SIZE(~0u)},
	{44859, S_0098F8_NUM_LOWER_PIPES(~0u)},
	{69064, S_0098F8_SE_ENABLE(~0u)},
	/* 2407 */
	{45237, S_009910_ARRAY_MODE(~0u), 16, 368},
	{45599, S_009910_PIPE_CONFIG(~0u), 15, 384},
	{45789, S_009910_TILE_SPLIT(~0u), 7, 399},
	{46239, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 422},
	{46259, S_009910_SAMPLE_SPLIT(~0u)},
	/* 2412 */
	{43868, S_00B01C_CU_EN(~0u)},
	{46281, S_00B01C_WAVE_LIMIT(~0u)},
	{46292, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	{69074, S_00B01C_SIMD_DISABLE(~0u)},
	/* 2416 */
	{46311, S_00B028_VGPRS(~0u)},
	{46317, S_00B028_SGPRS(~0u)},
	{2676, S_00B028_PRIORITY(~0u)},
	{46366, S_00B028_FLOAT_MODE(~0u), 241, 426},
	{46377, S_00B028_PRIV(~0u)},
	{46382, S_00B028_DX10_CLAMP(~0u)},
	{46393, S_00B028_DEBUG_MODE(~0u)},
	{46404, S_00B028_IEEE_MODE(~0u)},
	{46414, S_00B028_CU_GROUP_DISABLE(~0u)},
	{46441, S_00B028_CDBG_USER(~0u)},
	{69087, S_00B028_FP16_OVFL(~0u)},
	/* 2427 */
	{46451, S_00B02C_SCRATCH_EN(~0u)},
	{46462, S_00B02C_USER_SGPR(~0u)},
	{46472, S_00B02C_TRAP_PRESENT(~0u)},
	{46485, S_00B02C_WAVE_CNT_EN(~0u)},
	{46497, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{46523, S_00B02C_EXCP_EN(~0u)},
	{69097, S_00B02C_LOAD_COLLISION_WAVEID(~0u)},
	{69119, S_00B02C_LOAD_INTRAWAVE_COLLISION(~0u)},
	{69144, S_00B02C_SKIP_USGPR0(~0u)},
	{69156, S_00B02C_USER_SGPR_MSB(~0u)},
	/* 2437 */
	{43868, S_00B118_CU_EN(~0u)},
	{46281, S_00B118_WAVE_LIMIT(~0u)},
	{46292, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	{69074, S_00B118_SIMD_DISABLE(~0u)},
	/* 2441 */
	{46311, S_00B128_VGPRS(~0u)},
	{46317, S_00B128_SGPRS(~0u)},
	{2676, S_00B128_PRIORITY(~0u)},
	{46366, S_00B128_FLOAT_MODE(~0u)},
	{46377, S_00B128_PRIV(~0u)},
	{46382, S_00B128_DX10_CLAMP(~0u)},
	{46393, S_00B128_DEBUG_MODE(~0u)},
	{46404, S_00B128_IEEE_MODE(~0u)},
	{46531, S_00B128_VGPR_COMP_CNT(~0u)},
	{46545, S_00B128_CU_GROUP_ENABLE(~0u)},
	{46441, S_00B128_CDBG_USER(~0u)},
	{69087, S_00B128_FP16_OVFL(~0u)},
	/* 2453 */
	{46451, S_00B12C_SCRATCH_EN(~0u)},
	{46462, S_00B12C_USER_SGPR(~0u)},
	{46472, S_00B12C_TRAP_PRESENT(~0u)},
	{46561, S_00B12C_OC_LDS_EN(~0u)},
	{46571, S_00B12C_SO_BASE0_EN(~0u)},
	{46583, S_00B12C_SO_BASE1_EN(~0u)},
	{46595, S_00B12C_SO_BASE2_EN(~0u)},
	{46607, S_00B12C_SO_BASE3_EN(~0u)},
	{46619, S_00B12C_SO_EN(~0u)},
	{46523, S_00B12C_EXCP_EN(~0u)},
	{69170, S_00B12C_PC_BASE_EN(~0u)},
	{46625, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	{69144, S_00B12C_SKIP_USGPR0(~0u)},
	{69156, S_00B12C_USER_SGPR_MSB(~0u)},
	/* 2467 */
	{46451, S_00B1F0_SCRATCH_EN(~0u)},
	{46462, S_00B1F0_USER_SGPR(~0u)},
	{46472, S_00B1F0_TRAP_PRESENT(~0u)},
	{46523, S_00B1F0_EXCP_EN(~0u)},
	{46531, S_00B1F0_VGPR_COMP_CNT(~0u)},
	{46561, S_00B1F0_OC_LDS_EN(~0u)},
	{46503, S_00B1F0_LDS_SIZE(~0u)},
	{69144, S_00B1F0_SKIP_USGPR0(~0u)},
	{69156, S_00B1F0_USER_SGPR_MSB(~0u)},
	/* 2476 */
	{46642, S_00B204_GROUP_FIFO_DEPTH(~0u)},
	{69181, S_00B204_SPI_SHADER_LATE_ALLOC_GS(~0u)},
	/* 2478 */
	{46272, S_00B214_MEM_BASE(~0u)},
	/* 2479 */
	{43868, S_00B21C_CU_EN(~0u)},
	{46281, S_00B21C_WAVE_LIMIT(~0u)},
	{46292, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{69074, S_00B21C_SIMD_DISABLE(~0u)},
	/* 2483 */
	{46311, S_00B228_VGPRS(~0u)},
	{46317, S_00B228_SGPRS(~0u)},
	{2676, S_00B228_PRIORITY(~0u)},
	{46366, S_00B228_FLOAT_MODE(~0u)},
	{46377, S_00B228_PRIV(~0u)},
	{46382, S_00B228_DX10_CLAMP(~0u)},
	{46393, S_00B228_DEBUG_MODE(~0u)},
	{46404, S_00B228_IEEE_MODE(~0u)},
	{46545, S_00B228_CU_GROUP_ENABLE(~0u)},
	{46441, S_00B228_CDBG_USER(~0u)},
	{69206, S_00B228_GS_VGPR_COMP_CNT(~0u)},
	{69087, S_00B228_FP16_OVFL(~0u)},
	/* 2495 */
	{46451, S_00B22C_SCRATCH_EN(~0u)},
	{46462, S_00B22C_USER_SGPR(~0u)},
	{46472, S_00B22C_TRAP_PRESENT(~0u)},
	{46523, S_00B22C_EXCP_EN(~0u)},
	{69223, S_00B22C_ES_VGPR_COMP_CNT(~0u)},
	{46561, S_00B22C_OC_LDS_EN(~0u)},
	{46503, S_00B22C_LDS_SIZE(~0u)},
	{69144, S_00B22C_SKIP_USGPR0(~0u)},
	{69156, S_00B22C_USER_SGPR_MSB(~0u)},
	/* 2504 */
	{46642, S_00B404_GROUP_FIFO_DEPTH(~0u)},
	/* 2505 */
	{46272, S_00B414_MEM_BASE(~0u)},
	/* 2506 */
	{46281, S_00B41C_WAVE_LIMIT(~0u)},
	{46292, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{69074, S_00B41C_SIMD_DISABLE(~0u)},
	{43868, S_00B41C_CU_EN(~0u)},
	/* 2510 */
	{46311, S_00B428_VGPRS(~0u)},
	{46317, S_00B428_SGPRS(~0u)},
	{2676, S_00B428_PRIORITY(~0u)},
	{46366, S_00B428_FLOAT_MODE(~0u)},
	{46377, S_00B428_PRIV(~0u)},
	{46382, S_00B428_DX10_CLAMP(~0u)},
	{46393, S_00B428_DEBUG_MODE(~0u)},
	{46404, S_00B428_IEEE_MODE(~0u)},
	{46441, S_00B428_CDBG_USER(~0u)},
	{69240, S_00B428_LS_VGPR_COMP_CNT(~0u)},
	{69087, S_00B428_FP16_OVFL(~0u)},
	/* 2521 */
	{46451, S_00B42C_SCRATCH_EN(~0u)},
	{46462, S_00B42C_USER_SGPR(~0u)},
	{46472, S_00B42C_TRAP_PRESENT(~0u)},
	{46523, S_00B42C_EXCP_EN(~0u)},
	{46503, S_00B42C_LDS_SIZE(~0u)},
	{69144, S_00B42C_SKIP_USGPR0(~0u)},
	{69156, S_00B42C_USER_SGPR_MSB(~0u)},
	/* 2528 */
	{46685, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{46703, S_00B800_PARTIAL_TG_EN(~0u)},
	{46717, S_00B800_FORCE_START_AT_000(~0u)},
	{46736, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{46756, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{46776, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{46798, S_00B800_ORDER_MODE(~0u)},
	{46829, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{46847, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{8050, S_00B800_RESERVED(~0u)},
	{46874, S_00B800_RESTORE(~0u)},
	/* 2539 */
	{46311, S_00B848_VGPRS(~0u)},
	{46317, S_00B848_SGPRS(~0u)},
	{2676, S_00B848_PRIORITY(~0u)},
	{46366, S_00B848_FLOAT_MODE(~0u)},
	{46377, S_00B848_PRIV(~0u)},
	{46382, S_00B848_DX10_CLAMP(~0u)},
	{46393, S_00B848_DEBUG_MODE(~0u)},
	{46404, S_00B848_IEEE_MODE(~0u)},
	{46926, S_00B848_BULKY(~0u)},
	{46441, S_00B848_CDBG_USER(~0u)},
	{69087, S_00B848_FP16_OVFL(~0u)},
	/* 2550 */
	{46451, S_00B84C_SCRATCH_EN(~0u)},
	{46462, S_00B84C_USER_SGPR(~0u)},
	{46472, S_00B84C_TRAP_PRESENT(~0u)},
	{46932, S_00B84C_TGID_X_EN(~0u)},
	{46942, S_00B84C_TGID_Y_EN(~0u)},
	{46952, S_00B84C_TGID_Z_EN(~0u)},
	{46659, S_00B84C_TG_SIZE_EN(~0u)},
	{46962, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{46977, S_00B84C_EXCP_EN_MSB(~0u)},
	{46503, S_00B84C_LDS_SIZE(~0u)},
	{46523, S_00B84C_EXCP_EN(~0u)},
	{69144, S_00B84C_SKIP_USGPR0(~0u)},
	/* 2562 */
	{47005, S_00B854_WAVES_PER_SH(~0u)},
	{47018, S_00B854_TG_PER_CU(~0u)},
	{47028, S_00B854_LOCK_THRESHOLD(~0u)},
	{47043, S_00B854_SIMD_DEST_CNTL(~0u)},
	{47058, S_00B854_FORCE_SIMD_DIST(~0u)},
	{47074, S_00B854_CU_GROUP_COUNT(~0u)},
	{69074, S_00B854_SIMD_DISABLE(~0u)},
	/* 2569 */
	{69257, S_036008_CNTR_SEL0(~0u)},
	{69267, S_036008_CNTR_SEL1(~0u)},
	{48007, S_036008_SPM_MODE(~0u)},
	{69277, S_036008_CNTR_MODE1(~0u)},
	{69288, S_036008_CNTR_MODE0(~0u)},
	/* 2574 */
	{69299, S_036004_CNTR_SEL2(~0u)},
	{69309, S_036004_CNTR_SEL3(~0u)},
	{69319, S_036004_CNTR_MODE3(~0u)},
	{69330, S_036004_CNTR_MODE2(~0u)},
	/* 2578 */
	{69257, S_036024_CNTR_SEL0(~0u)},
	{69267, S_036024_CNTR_SEL1(~0u)},
	{48007, S_036024_SPM_MODE(~0u)},
	{69277, S_036024_CNTR_MODE1(~0u)},
	{69288, S_036024_CNTR_MODE0(~0u)},
	/* 2583 */
	{69299, S_036010_CNTR_SEL2(~0u)},
	{69309, S_036010_CNTR_SEL3(~0u)},
	{69319, S_036010_CNTR_MODE3(~0u)},
	{69330, S_036010_CNTR_MODE2(~0u)},
	/* 2587 */
	{69257, S_03601C_CNTR_SEL0(~0u)},
	{69267, S_03601C_CNTR_SEL1(~0u)},
	{48007, S_03601C_SPM_MODE(~0u)},
	{69277, S_03601C_CNTR_MODE1(~0u)},
	{69288, S_03601C_CNTR_MODE0(~0u)},
	/* 2592 */
	{69299, S_036018_CNTR_SEL2(~0u)},
	{69309, S_036018_CNTR_SEL3(~0u)},
	{69319, S_036018_CNTR_MODE3(~0u)},
	{69330, S_036018_CNTR_MODE2(~0u)},
	/* 2596 */
	{441, S_036028_INDEX(~0u)},
	{43111, S_036028_ALWAYS(~0u)},
	{7643, S_036028_ENABLE(~0u)},
	/* 2599 */
	{441, S_03602C_INDEX(~0u)},
	{43111, S_03602C_ALWAYS(~0u)},
	{7643, S_03602C_ENABLE(~0u)},
	/* 2602 */
	{441, S_036030_INDEX(~0u)},
	{15389, S_036030_CLEAR(~0u)},
	{7643, S_036030_ENABLE(~0u)},
	/* 2605 */
	{441, S_036034_INDEX(~0u)},
	{15389, S_036034_CLEAR(~0u)},
	{7643, S_036034_ENABLE(~0u)},
	/* 2608 */
	{441, S_036038_INDEX(~0u)},
	{15389, S_036038_CLEAR(~0u)},
	{7643, S_036038_ENABLE(~0u)},
	/* 2611 */
	{47193, S_036100_PERF_SEL(~0u)},
	{47363, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47390, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47417, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47444, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47470, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47496, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47523, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47549, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47575, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47629, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47655, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{47681, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{47707, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{47761, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{47788, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{47814, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	{69341, S_036100_UTCL2_BUSY_USER_DEFINED_MASK(~0u)},
	{69370, S_036100_EA_BUSY_USER_DEFINED_MASK(~0u)},
	{69396, S_036100_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2633 */
	{47193, S_036108_PERF_SEL(~0u)},
	{47363, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47390, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47444, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47470, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47496, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47523, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47629, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47417, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47549, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69396, S_036108_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2646 */
	{47193, S_03610C_PERF_SEL(~0u)},
	{47363, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47390, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47444, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47470, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47496, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47523, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47629, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47417, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47549, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69396, S_03610C_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2659 */
	{47193, S_036110_PERF_SEL(~0u)},
	{47363, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47390, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47444, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47470, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47496, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47523, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47629, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47417, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47549, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69396, S_036110_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2672 */
	{47193, S_036114_PERF_SEL(~0u)},
	{47363, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47390, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47444, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47470, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47496, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47523, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47629, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47417, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47549, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47734, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69396, S_036114_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2685 */
	{47193, S_036600_PERF_SEL(~0u)},
	{47202, S_036600_PERF_SEL1(~0u)},
	{47212, S_036600_CNTR_MODE(~0u)},
	{47850, S_036600_PERF_MODE1(~0u)},
	{47840, S_036600_PERF_MODE(~0u)},
	/* 2690 */
	{47222, S_036610_PERF_SEL2(~0u)},
	{47232, S_036610_PERF_SEL3(~0u)},
	{47861, S_036610_PERF_MODE3(~0u)},
	{47872, S_036610_PERF_MODE2(~0u)},
	/* 2694 */
	{48735, S_028008_SLICE_START(~0u)},
	{48747, S_028008_SLICE_MAX(~0u)},
	{48757, S_028008_Z_READ_ONLY(~0u)},
	{48769, S_028008_STENCIL_READ_ONLY(~0u)},
	{69423, S_028008_MIPID(~0u)},
	/* 2699 */
	{49386, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 678},
	{49415, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{49446, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{49482, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{49517, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{49545, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{49567, S_028010_DISABLE_REG_SNOOP(~0u)},
	{49585, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{49617, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{49643, S_028010_HIZ_ZFUNC(~0u)},
	{49653, S_028010_HIS_SFUNC_FF(~0u)},
	{49666, S_028010_HIS_SFUNC_BF(~0u)},
	{49679, S_028010_PRESERVE_ZRANGE(~0u)},
	{49695, S_028010_PRESERVE_SRESULTS(~0u)},
	{49713, S_028010_DISABLE_FAST_PASS(~0u)},
	{69429, S_028010_ALLOW_PARTIAL_RES_HIER_KILL(~0u)},
	/* 2715 */
	{880, S_028018_BASE_HI(~0u)},
	/* 2716 */
	{69457, S_02801C_X_MAX(~0u)},
	{69463, S_02801C_Y_MAX(~0u)},
	/* 2718 */
	{21132, S_028038_FORMAT(~0u), 4, 707},
	{49903, S_028038_NUM_SAMPLES(~0u)},
	{68454, S_028038_SW_MODE(~0u)},
	{69469, S_028038_PARTIALLY_RESIDENT(~0u)},
	{69488, S_028038_FAULT_BEHAVIOR(~0u)},
	{69503, S_028038_ITERATE_FLUSH(~0u)},
	{69517, S_028038_MAXMIP(~0u)},
	{49931, S_028038_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{49955, S_028038_ALLOW_EXPCLEAR(~0u)},
	{49970, S_028038_READ_SIZE(~0u)},
	{49980, S_028038_TILE_SURFACE_ENABLE(~0u)},
	{50000, S_028038_CLEAR_DISALLOWED(~0u)},
	{50017, S_028038_ZRANGE_PRECISION(~0u)},
	/* 2731 */
	{21132, S_02803C_FORMAT(~0u), 2, 711},
	{68454, S_02803C_SW_MODE(~0u)},
	{69469, S_02803C_PARTIALLY_RESIDENT(~0u)},
	{69488, S_02803C_FAULT_BEHAVIOR(~0u)},
	{69503, S_02803C_ITERATE_FLUSH(~0u)},
	{49955, S_02803C_ALLOW_EXPCLEAR(~0u)},
	{50060, S_02803C_TILE_STENCIL_DISABLE(~0u)},
	{50000, S_02803C_CLEAR_DISALLOWED(~0u)},
	/* 2739 */
	{880, S_028044_BASE_HI(~0u)},
	/* 2740 */
	{880, S_02804C_BASE_HI(~0u)},
	/* 2741 */
	{880, S_028054_BASE_HI(~0u)},
	/* 2742 */
	{880, S_02805C_BASE_HI(~0u)},
	/* 2743 */
	{69533, S_028060_PUNCHOUT_MODE(~0u), 4, 1512},
	{69547, S_028060_POPS_DRAIN_PS_ON_OVERLAP(~0u)},
	{69572, S_028060_DISALLOW_OVERFLOW(~0u)},
	/* 2746 */
	{30393, S_028068_EPITCH(~0u)},
	/* 2747 */
	{30393, S_02806C_EPITCH(~0u)},
	/* 2748 */
	{69590, S_0281E8_DEST_BASE_HI_256B(~0u)},
	/* 2749 */
	{69590, S_0281EC_DEST_BASE_HI_256B(~0u)},
	/* 2750 */
	{69590, S_0281F0_DEST_BASE_HI_256B(~0u)},
	/* 2751 */
	{69590, S_0281F4_DEST_BASE_HI_256B(~0u)},
	/* 2752 */
	{50620, S_028350_RB_MAP_PKR0(~0u), 4, 713},
	{50632, S_028350_RB_MAP_PKR1(~0u), 4, 713},
	{50744, S_028350_RB_XSEL2(~0u), 4, 717},
	{50753, S_028350_RB_XSEL(~0u)},
	{50761, S_028350_RB_YSEL(~0u)},
	{50865, S_028350_PKR_MAP(~0u), 4, 721},
	{50973, S_028350_PKR_XSEL(~0u), 4, 725},
	{51082, S_028350_PKR_YSEL(~0u), 4, 729},
	{51195, S_028350_PKR_XSEL2(~0u), 4, 733},
	{51297, S_028350_SC_MAP(~0u), 4, 737},
	{51443, S_028350_SC_XSEL(~0u), 4, 741},
	{51590, S_028350_SC_YSEL(~0u), 4, 745},
	{51690, S_028350_SE_MAP(~0u), 4, 749},
	{69608, S_028350_SE_XSEL_GFX9(~0u)},
	{69621, S_028350_SE_YSEL_GFX9(~0u)},
	/* 2767 */
	{52113, S_028354_SE_PAIR_MAP(~0u), 4, 761},
	{69634, S_028354_SE_PAIR_XSEL_GFX9(~0u)},
	{69652, S_028354_SE_PAIR_YSEL_GFX9(~0u)},
	/* 2770 */
	{7643, S_02835C_ENABLE(~0u)},
	{69670, S_02835C_NUM_SE(~0u)},
	{69050, S_02835C_NUM_RB_PER_SE(~0u)},
	/* 2773 */
	{69677, S_028360_PERFMON_ENABLE(~0u)},
	/* 2774 */
	{69692, S_0283A0_LEFT_QTR(~0u)},
	{69701, S_0283A0_LEFT_HALF(~0u)},
	{69711, S_0283A0_RIGHT_HALF(~0u)},
	{69722, S_0283A0_RIGHT_QTR(~0u)},
	/* 2778 */
	{69692, S_0283A4_LEFT_QTR(~0u)},
	{69701, S_0283A4_LEFT_HALF(~0u)},
	{69711, S_0283A4_RIGHT_HALF(~0u)},
	{69722, S_0283A4_RIGHT_QTR(~0u)},
	/* 2782 */
	{69732, S_0283A8_TOP_QTR(~0u)},
	{69740, S_0283A8_TOP_HALF(~0u)},
	{69749, S_0283A8_BOT_HALF(~0u)},
	{69758, S_0283A8_BOT_QTR(~0u)},
	/* 2786 */
	{53748, S_0286D8_NUM_INTERP(~0u)},
	{53759, S_0286D8_PARAM_GEN(~0u)},
	{69766, S_0286D8_OFFCHIP_PARAM_EN(~0u)},
	{69783, S_0286D8_LATE_PC_DEALLOC(~0u)},
	{53778, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	/* 2791 */
	{30393, S_0287A0_EPITCH(~0u)},
	/* 2792 */
	{30393, S_0287A4_EPITCH(~0u)},
	/* 2793 */
	{30393, S_0287A8_EPITCH(~0u)},
	/* 2794 */
	{30393, S_0287AC_EPITCH(~0u)},
	/* 2795 */
	{30393, S_0287B0_EPITCH(~0u)},
	/* 2796 */
	{30393, S_0287B4_EPITCH(~0u)},
	/* 2797 */
	{30393, S_0287B8_EPITCH(~0u)},
	/* 2798 */
	{30393, S_0287BC_EPITCH(~0u)},
	/* 2799 */
	{69799, S_0287E4_BASE_ADDR_GFX9(~0u)},
	/* 2800 */
	{56632, S_0287F0_SOURCE_SELECT(~0u), 4, 880},
	{56678, S_0287F0_MAJOR_MODE(~0u), 2, 884},
	{69814, S_0287F0_SPRITE_EN_R6XX(~0u)},
	{56689, S_0287F0_NOT_EOP(~0u)},
	{56697, S_0287F0_USE_OPAQUE(~0u)},
	{69829, S_0287F0_UNROLLED_INST(~0u)},
	{69843, S_0287F0_GRBM_SKEW_NO_DEC(~0u)},
	{69860, S_0287F0_REG_RT_INDEX(~0u)},
	/* 2808 */
	{57673, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{57689, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{57720, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{48905, S_02880C_Z_ORDER(~0u), 4, 1165},
	{57799, S_02880C_KILL_ENABLE(~0u)},
	{57811, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{57835, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{57854, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{57872, S_02880C_EXEC_ON_NOOP(~0u)},
	{57885, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{57907, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{57997, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 1169},
	{58019, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	{69873, S_02880C_PRIMITIVE_ORDERED_PIXEL_SHADER(~0u)},
	{69904, S_02880C_EXEC_IF_OVERLAPPED(~0u)},
	{69923, S_02880C_POPS_OVERLAP_NUM_SAMPLES(~0u)},
	/* 2824 */
	{58341, S_028814_CULL_FRONT(~0u)},
	{58352, S_028814_CULL_BACK(~0u)},
	{22820, S_028814_FACE(~0u)},
	{58372, S_028814_POLY_MODE(~0u), 2, 1173},
	{58438, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 1175},
	{58459, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 1175},
	{58479, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{58504, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{58528, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{58552, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{58577, S_028814_PROVOKING_VTX_LAST(~0u)},
	{58596, S_028814_PERSP_CORR_DIS(~0u)},
	{58611, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	{69948, S_028814_RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF(~0u)},
	{69986, S_028814_NEW_QUAD_DECOMPOSITION(~0u)},
	/* 2839 */
	{58629, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{58647, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{58666, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{58684, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{58703, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{58721, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{58740, S_028818_VTX_XY_FMT(~0u)},
	{58751, S_028818_VTX_Z_FMT(~0u)},
	{58761, S_028818_VTX_W0_FMT(~0u)},
	{70009, S_028818_PERFCOUNTER_REF(~0u)},
	/* 2849 */
	{58772, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{58788, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{58804, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{58820, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{58836, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{58852, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{58868, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{58884, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{58900, S_02881C_CULL_DIST_ENA_0(~0u)},
	{58916, S_02881C_CULL_DIST_ENA_1(~0u)},
	{58932, S_02881C_CULL_DIST_ENA_2(~0u)},
	{58948, S_02881C_CULL_DIST_ENA_3(~0u)},
	{58964, S_02881C_CULL_DIST_ENA_4(~0u)},
	{58980, S_02881C_CULL_DIST_ENA_5(~0u)},
	{58996, S_02881C_CULL_DIST_ENA_6(~0u)},
	{59012, S_02881C_CULL_DIST_ENA_7(~0u)},
	{59028, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{59047, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{59065, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{59092, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{59114, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{59132, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{59152, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{59175, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{59198, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{59223, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{59243, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	{70025, S_02881C_USE_VTX_SHD_OBJPRIM_ID(~0u)},
	/* 2877 */
	{70048, S_028834_OBJ_ID_SEL(~0u)},
	{70059, S_028834_ADD_PIPED_PRIM_ID(~0u)},
	{70077, S_028834_EN_32BIT_OBJPRIMID(~0u)},
	/* 2880 */
	{70096, S_028838_VERTEX_REUSE_OFF(~0u)},
	{70113, S_028838_INDEX_BUF_EDGE_FLAG_ENA(~0u)},
	/* 2882 */
	{70137, S_02883C_DISCARD_0_AREA_TRIANGLES(~0u)},
	{70162, S_02883C_DISCARD_0_AREA_LINES(~0u)},
	{70183, S_02883C_DISCARD_0_AREA_POINTS(~0u)},
	{70205, S_02883C_DISCARD_0_AREA_RECTANGLES(~0u)},
	{70231, S_02883C_USE_PROVOKING_ZW(~0u)},
	/* 2887 */
	{22279, S_028A40_MODE(~0u), 6, 1215},
	{39276, S_028A40_RESERVED_0(~0u)},
	{60890, S_028A40_CUT_MODE(~0u), 4, 1221},
	{39294, S_028A40_RESERVED_1(~0u)},
	{60899, S_028A40_GS_C_PACK_EN(~0u)},
	{60912, S_028A40_RESERVED_2(~0u)},
	{60923, S_028A40_ES_PASSTHRU(~0u)},
	{70248, S_028A40_RESERVED_3(~0u)},
	{70259, S_028A40_RESERVED_4(~0u)},
	{70270, S_028A40_RESERVED_5(~0u)},
	{60982, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{61001, S_028A40_SUPPRESS_CUTS(~0u)},
	{61015, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{61033, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{61084, S_028A40_ONCHIP(~0u), 4, 1225},
	/* 2902 */
	{61091, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{61111, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	{70281, S_028A44_GS_INST_PRIMS_IN_SUBGRP(~0u)},
	/* 2905 */
	{61131, S_028A48_MSAA_ENABLE(~0u)},
	{61143, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{61164, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{61184, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	{70305, S_028A48_SCALE_LINE_WIDTH_PAD(~0u)},
	{70326, S_028A48_ALTERNATE_RBS_PER_TILE(~0u)},
	{70349, S_028A48_COARSE_TILE_STARTS_ON_EVEN_RB(~0u)},
	/* 2912 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 1232},
	{61968, S_028A7C_SWAP_MODE(~0u), 4, 1235},
	{62029, S_028A7C_BUF_TYPE(~0u), 3, 1239},
	{62088, S_028A7C_RDREQ_POLICY(~0u)},
	{66937, S_028A7C_PRIMGEN_EN(~0u)},
	{56689, S_028A7C_NOT_EOP(~0u)},
	{62101, S_028A7C_REQ_PATH(~0u)},
	/* 2919 */
	{22558, S_028A84_PRIMITIVEID_EN(~0u)},
	{62110, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	{70379, S_028A84_NGG_DISABLE_PROVOK_REUSE(~0u)},
	/* 2922 */
	{63066, S_028A90_EVENT_TYPE(~0u), 63, 1516},
	{70504, S_028A90_ADDRESS_HI_GFX9(~0u)},
	{63093, S_028A90_EXTENDED_EVENT(~0u)},
	/* 2925 */
	{30594, S_028A94_MAX_PRIMS_PER_SUBGROUP(~0u)},
	/* 2926 */
	{70520, S_028A98_OBJPRIM_ID_EN(~0u)},
	{70534, S_028A98_EN_REG_RT_INDEX(~0u)},
	{70550, S_028A98_EN_PIPELINE_PRIMID(~0u)},
	{70569, S_028A98_OBJECT_ID_INST_EN(~0u)},
	/* 2930 */
	{63226, S_028ABC_FULL_CACHE(~0u)},
	{63237, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{63260, S_028ABC_PRELOAD(~0u)},
	{63268, S_028ABC_PREFETCH_WIDTH(~0u)},
	{63283, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{63299, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{68627, S_028ABC_PIPE_ALIGNED(~0u)},
	{68645, S_028ABC_RB_ALIGNED(~0u)},
	/* 2938 */
	{48050, S_028B54_LS_EN(~0u), 3, 1303},
	{48044, S_028B54_HS_EN(~0u)},
	{23383, S_028B54_ES_EN(~0u), 3, 1306},
	{48038, S_028B54_GS_EN(~0u)},
	{48032, S_028B54_VS_EN(~0u), 3, 1309},
	{46625, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{63621, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{63641, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{63661, S_028B54_VS_WAVE_ID_EN(~0u)},
	{66937, S_028B54_PRIMGEN_EN(~0u)},
	{70587, S_028B54_ORDERED_ID_MODE(~0u)},
	{63206, S_028B54_MAX_PRIMGRP_IN_WAVE(~0u)},
	{70603, S_028B54_GS_FAST_LAUNCH(~0u)},
	/* 2951 */
	{209, S_028B6C_TYPE(~0u), 3, 1312},
	{63809, S_028B6C_PARTITIONING(~0u), 4, 1315},
	{63886, S_028B6C_TOPOLOGY(~0u), 4, 1319},
	{63895, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{63915, S_028B6C_DEPRECATED(~0u)},
	{63948, S_028B6C_DISABLE_DONUTS(~0u)},
	{62088, S_028B6C_RDREQ_POLICY(~0u)},
	{64087, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 1326},
	/* 2959 */
	{64283, S_028B94_STREAMOUT_0_EN(~0u)},
	{64298, S_028B94_STREAMOUT_1_EN(~0u)},
	{64313, S_028B94_STREAMOUT_2_EN(~0u)},
	{64328, S_028B94_STREAMOUT_3_EN(~0u)},
	{64343, S_028B94_RAST_STREAM(~0u)},
	{70618, S_028B94_EN_PRIMS_NEEDED_CNT(~0u)},
	{64355, S_028B94_RAST_STREAM_MASK(~0u)},
	{64372, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 2967 */
	{63066, S_028B9C_EVENT_TYPE(~0u)},
	{39211, S_028B9C_ADDRESS_HI(~0u)},
	{63093, S_028B9C_EXTENDED_EVENT(~0u)},
	/* 2970 */
	{64727, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{64744, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{64766, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{64782, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{64803, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	{70638, S_028BE0_COVERAGE_TO_SHADER_SELECT(~0u)},
	/* 2976 */
	{65338, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	{69097, S_028C40_LOAD_COLLISION_WAVEID(~0u)},
	{69119, S_028C40_LOAD_INTRAWAVE_COLLISION(~0u)},
	/* 2979 */
	{70754, S_028C44_BINNING_MODE(~0u), 4, 1579},
	{70767, S_028C44_BIN_SIZE_X(~0u)},
	{70778, S_028C44_BIN_SIZE_Y(~0u)},
	{70789, S_028C44_BIN_SIZE_X_EXTEND(~0u)},
	{70807, S_028C44_BIN_SIZE_Y_EXTEND(~0u)},
	{70825, S_028C44_CONTEXT_STATES_PER_BIN(~0u)},
	{70848, S_028C44_PERSISTENT_STATES_PER_BIN(~0u)},
	{70874, S_028C44_DISABLE_START_OF_PRIM(~0u)},
	{70896, S_028C44_FPOVS_PER_BATCH(~0u)},
	{70912, S_028C44_OPTIMAL_BIN_SELECTION(~0u)},
	/* 2989 */
	{70934, S_028C48_MAX_ALLOC_COUNT(~0u)},
	{70950, S_028C48_MAX_PRIM_PER_BATCH(~0u)},
	/* 2991 */
	{70969, S_028C4C_OVER_RAST_ENABLE(~0u)},
	{70986, S_028C4C_OVER_RAST_SAMPLE_SELECT(~0u)},
	{71010, S_028C4C_UNDER_RAST_ENABLE(~0u)},
	{71028, S_028C4C_UNDER_RAST_SAMPLE_SELECT(~0u)},
	{71053, S_028C4C_PBB_UNCERTAINTY_REGION_ENABLE(~0u)},
	{71083, S_028C4C_ZMM_TRI_EXTENT(~0u)},
	{71098, S_028C4C_ZMM_TRI_OFFSET(~0u)},
	{71113, S_028C4C_OVERRIDE_OVER_RAST_INNER_TO_NORMAL(~0u)},
	{71148, S_028C4C_OVERRIDE_UNDER_RAST_INNER_TO_NORMAL(~0u)},
	{71184, S_028C4C_DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE(~0u)},
	{71228, S_028C4C_UNCERTAINTY_REGION_MODE(~0u)},
	{71252, S_028C4C_OUTER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{71288, S_028C4C_INNER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{71324, S_028C4C_NULL_SQUAD_AA_MASK_ENABLE(~0u)},
	{71350, S_028C4C_COVERAGE_AA_MASK_ENABLE(~0u)},
	{71374, S_028C4C_PREZ_AA_MASK_ENABLE(~0u)},
	{71394, S_028C4C_POSTZ_AA_MASK_ENABLE(~0u)},
	{71415, S_028C4C_CENTROID_SAMPLE_OVERRIDE(~0u)},
	/* 3009 */
	{71440, S_028C50_MAX_DEALLOCS_IN_WAVE(~0u)},
	/* 3010 */
	{71461, S_028C64_BASE_256B(~0u)},
	/* 3011 */
	{71471, S_028C68_MIP0_HEIGHT(~0u)},
	{71483, S_028C68_MIP0_WIDTH(~0u)},
	{68656, S_028C68_MAX_MIP(~0u)},
	/* 3014 */
	{48735, S_028C6C_SLICE_START(~0u)},
	{48747, S_028C6C_SLICE_MAX(~0u)},
	{71494, S_028C6C_MIP_LEVEL(~0u)},
	/* 3017 */
	{65462, S_028C70_ENDIAN(~0u), 4, 1342},
	{21132, S_028C70_FORMAT(~0u), 23, 1346},
	{65829, S_028C70_NUMBER_TYPE(~0u), 8, 1369},
	{65885, S_028C70_COMP_SWAP(~0u), 4, 1377},
	{57412, S_028C70_FAST_CLEAR(~0u)},
	{49321, S_028C70_COMPRESSION(~0u)},
	{65895, S_028C70_BLEND_CLAMP(~0u)},
	{65907, S_028C70_BLEND_BYPASS(~0u)},
	{65920, S_028C70_SIMPLE_FLOAT(~0u)},
	{64887, S_028C70_ROUND_MODE(~0u)},
	{66160, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 1381},
	{66182, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 1381},
	{66206, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{66232, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{66258, S_028C70_DCC_ENABLE(~0u)},
	{66269, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 3033 */
	{71504, S_028C74_MIP0_DEPTH(~0u)},
	{68610, S_028C74_META_LINEAR(~0u)},
	{49903, S_028C74_NUM_SAMPLES(~0u)},
	{66325, S_028C74_NUM_FRAGMENTS(~0u)},
	{66339, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	{71515, S_028C74_COLOR_SW_MODE(~0u)},
	{71529, S_028C74_FMASK_SW_MODE(~0u)},
	{71543, S_028C74_RESOURCE_TYPE(~0u), 4, 1583},
	{68645, S_028C74_RB_ALIGNED(~0u)},
	{68627, S_028C74_PIPE_ALIGNED(~0u)},
	/* 3043 */
	{71461, S_028C80_BASE_256B(~0u)},
	/* 3044 */
	{71461, S_028C88_BASE_256B(~0u)},
	/* 3045 */
	{71461, S_028C98_BASE_256B(~0u)},
};

static const char sid_strings[] =
	"NOP\0" /* 0 */
	"SET_BASE\0" /* 4 */
	"CLEAR_STATE\0" /* 13 */
	"INDEX_BUFFER_SIZE\0" /* 25, 38 */
	"DISPATCH_DIRECT\0" /* 43 */
	"DISPATCH_INDIRECT\0" /* 59 */
	"OCCLUSION_QUERY\0" /* 77, 91 */
	"SET_PREDICATION\0" /* 93 */
	"COND_EXEC\0" /* 109 */
	"PRED_EXEC\0" /* 119 */
	"DRAW_INDIRECT\0" /* 129 */
	"DRAW_INDEX_INDIRECT\0" /* 143 */
	"INDEX_BASE\0" /* 163 */
	"DRAW_INDEX_2\0" /* 174 */
	"CONTEXT_CONTROL\0" /* 187, 195 */
	"INDEX_TYPE\0" /* 203, 209 */
	"DRAW_INDIRECT_MULTI\0" /* 214 */
	"DRAW_INDEX_AUTO\0" /* 234, 245 */
	"DRAW_INDEX_IMMD\0" /* 250 */
	"NUM_INSTANCES\0" /* 266 */
	"DRAW_INDEX_MULTI_AUTO\0" /* 280 */
	"INDIRECT_BUFFER_SI\0" /* 302 */
	"INDIRECT_BUFFER_CONST\0" /* 321 */
	"STRMOUT_BUFFER_UPDATE\0" /* 343 */
	"DRAW_INDEX_OFFSET_2\0" /* 365 */
	"WRITE_DATA\0" /* 385, 391 */
	"DRAW_INDEX_INDIRECT_MULTI\0" /* 396 */
	"MEM_SEMAPHORE\0" /* 422 */
	"MPEG_INDEX\0" /* 436, 441, 445 */
	"WAIT_REG_MEM\0" /* 447 */
	"MEM_WRITE\0" /* 460 */
	"INDIRECT_BUFFER_CIK\0" /* 470 */
	"COPY_DATA\0" /* 490 */
	"PFP_SYNC_ME\0" /* 500, 509 */
	"SURFACE_SYNC\0" /* 512 */
	"ME_INITIALIZE\0" /* 525 */
	"COND_WRITE\0" /* 539 */
	"EVENT_WRITE\0" /* 550 */
	"EVENT_WRITE_EOP\0" /* 562 */
	"RELEASE_MEM\0" /* 578 */
	"ONE_REG_WRITE\0" /* 590 */
	"ACQUIRE_MEM\0" /* 604 */
	"SET_CONFIG_REG\0" /* 616 */
	"SET_CONTEXT_REG\0" /* 631 */
	"SET_SH_REG\0" /* 647 */
	"SET_SH_REG_OFFSET\0" /* 658, 669 */
	"SET_UCONFIG_REG\0" /* 676 */
	"LOAD_CONST_RAM\0" /* 692 */
	"WRITE_CONST_RAM\0" /* 707 */
	"DUMP_CONST_RAM\0" /* 723 */
	"INCREMENT_CE_COUNTER\0" /* 738 */
	"INCREMENT_DE_COUNTER\0" /* 759 */
	"WAIT_ON_CE_COUNTER\0" /* 780 */
	"IT_OPCODE_C\0" /* 799 */
	"CP_DMA\0" /* 811 */
	"DMA_DATA\0" /* 818 */
	"DRAW_INDEX_LOC\0" /* 827 */
	"DST_ADDR_LO\0" /* 842 */
	"DST_ADDR_HI\0" /* 854 */
	"IB_BASE_LO\0" /* 866 */
	"IB_BASE_HI\0" /* 877, 880 */
	"CP_DMA_WORD0\0" /* 888 */
	"CP_DMA_WORD1\0" /* 901 */
	"CP_DMA_WORD2\0" /* 914 */
	"CP_DMA_WORD3\0" /* 927 */
	"COMMAND\0" /* 940 */
	"DMA_DATA_WORD0\0" /* 948 */
	"SRC_ADDR_LO\0" /* 963 */
	"SRC_ADDR_HI\0" /* 975 */
	"SRBM_STATUS2\0" /* 987 */
	"SRBM_STATUS\0" /* 1000, 1005 */
	"SRBM_STATUS3\0" /* 1012 */
	"SDMA0_STATUS_REG\0" /* 1025 */
	"SDMA1_STATUS_REG\0" /* 1042 */
	"GRBM_STATUS2\0" /* 1059 */
	"GRBM_STATUS\0" /* 1072 */
	"GRBM_GFX_INDEX\0" /* 1084 */
	"CP_STRMOUT_CNTL\0" /* 1099 */
	"CP_COHER_CNTL\0" /* 1115 */
	"CP_COHER_SIZE\0" /* 1129 */
	"CP_COHER_BASE\0" /* 1143 */
	"GRBM_STATUS_SE0\0" /* 1157 */
	"GRBM_STATUS_SE1\0" /* 1173 */
	"GRBM_STATUS_SE2\0" /* 1189 */
	"GRBM_STATUS_SE3\0" /* 1205 */
	"CP_COHER_BASE_HI\0" /* 1221 */
	"CP_COHER_START_DELAY\0" /* 1238 */
	"CP_COHER_STATUS\0" /* 1259 */
	"CP_CPC_STATUS\0" /* 1275 */
	"CP_CPC_BUSY_STAT\0" /* 1289 */
	"CP_CPC_STALLED_STAT1\0" /* 1306 */
	"CP_CPF_STATUS\0" /* 1327 */
	"CP_CPF_BUSY_STAT\0" /* 1341 */
	"CP_CPF_STALLED_STAT1\0" /* 1358 */
	"CP_COHER_SIZE_HI\0" /* 1379 */
	"VGT_VTX_VECT_EJECT_REG\0" /* 1396 */
	"VGT_CACHE_INVALIDATION\0" /* 1419 */
	"VGT_ESGS_RING_SIZE\0" /* 1442 */
	"VGT_GSVS_RING_SIZE\0" /* 1461 */
	"VGT_GS_VERTEX_REUSE\0" /* 1480 */
	"VGT_PRIMITIVE_TYPE\0" /* 1500 */
	"VGT_INDEX_TYPE\0" /* 1519 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_0\0" /* 1534 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_1\0" /* 1567 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_2\0" /* 1600 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_3\0" /* 1633 */
	"VGT_NUM_INDICES\0" /* 1666 */
	"VGT_NUM_INSTANCES\0" /* 1682 */
	"VGT_TF_RING_SIZE\0" /* 1700 */
	"VGT_HS_OFFCHIP_PARAM\0" /* 1717 */
	"VGT_TF_MEMORY_BASE\0" /* 1738 */
	"PA_CL_ENHANCE\0" /* 1757, 1768 */
	"PA_SU_LINE_STIPPLE_VALUE\0" /* 1771, 1777 */
	"PA_SC_LINE_STIPPLE_STATE\0" /* 1796 */
	"CP_STALLED_STAT3\0" /* 1821 */
	"CP_STALLED_STAT1\0" /* 1838 */
	"CP_STALLED_STAT2\0" /* 1855 */
	"CP_STAT\0" /* 1872 */
	"PA_SC_SCREEN_EXTENT_MIN_0\0" /* 1880 */
	"PA_SC_SCREEN_EXTENT_MAX_0\0" /* 1906 */
	"PA_SC_SCREEN_EXTENT_MIN_1\0" /* 1932 */
	"PA_SC_SCREEN_EXTENT_MAX_1\0" /* 1958 */
	"PA_SC_ENHANCE\0" /* 1984 */
	"SQC_CACHES\0" /* 1998 */
	"SQ_RANDOM_WAVE_PRI\0" /* 2009 */
	"SQ_EXP_0\0" /* 2028 */
	"TA_CS_BC_BASE_ADDR\0" /* 2037, 2051 */
	"TA_CS_BC_BASE_ADDR_HI\0" /* 2056 */
	"DB_OCCLUSION_COUNT0_LOW\0" /* 2078 */
	"DB_OCCLUSION_COUNT0_HI\0" /* 2102 */
	"SQ_BUF_RSRC_WORD0\0" /* 2125 */
	"SQ_BUF_RSRC_WORD1\0" /* 2143 */
	"DB_OCCLUSION_COUNT1_LOW\0" /* 2161 */
	"SQ_BUF_RSRC_WORD2\0" /* 2185 */
	"DB_OCCLUSION_COUNT1_HI\0" /* 2203 */
	"SQ_BUF_RSRC_WORD3\0" /* 2226 */
	"DB_OCCLUSION_COUNT2_LOW\0" /* 2244 */
	"SQ_IMG_RSRC_WORD0\0" /* 2268 */
	"DB_OCCLUSION_COUNT2_HI\0" /* 2286 */
	"SQ_IMG_RSRC_WORD1\0" /* 2309 */
	"DB_OCCLUSION_COUNT3_LOW\0" /* 2327 */
	"SQ_IMG_RSRC_WORD2\0" /* 2351 */
	"DB_OCCLUSION_COUNT3_HI\0" /* 2369 */
	"SQ_IMG_RSRC_WORD3\0" /* 2392 */
	"SQ_IMG_RSRC_WORD4\0" /* 2410 */
	"SQ_IMG_RSRC_WORD5\0" /* 2428 */
	"SQ_IMG_RSRC_WORD6\0" /* 2446 */
	"SQ_IMG_RSRC_WORD7\0" /* 2464 */
	"SQ_IMG_SAMP_WORD0\0" /* 2482 */
	"SQ_IMG_SAMP_WORD1\0" /* 2500 */
	"SQ_IMG_SAMP_WORD2\0" /* 2518 */
	"SQ_IMG_SAMP_WORD3\0" /* 2536 */
	"SPI_DYN_GPR_LOCK_EN\0" /* 2554, 2571 */
	"SPI_STATIC_THREAD_MGMT_1\0" /* 2574 */
	"SPI_STATIC_THREAD_MGMT_2\0" /* 2599 */
	"SPI_STATIC_THREAD_MGMT_3\0" /* 2624 */
	"SPI_PS_MAX_WAVE_ID\0" /* 2649, 2656 */
	"SPI_ARB_PRIORITY\0" /* 2668, 2676 */
	"SPI_ARB_CYCLES_0\0" /* 2685 */
	"SPI_ARB_CYCLES_1\0" /* 2702 */
	"SQ_FLAT_SCRATCH_WORD0\0" /* 2719 */
	"SQ_FLAT_SCRATCH_WORD1\0" /* 2741 */
	"DB_ZPASS_COUNT_LOW\0" /* 2763 */
	"DB_ZPASS_COUNT_HI\0" /* 2782, 2791 */
	"SPI_CONFIG_CNTL\0" /* 2800 */
	"SPI_CONFIG_CNTL_1\0" /* 2816 */
	"SPI_RESOURCE_RESERVE_CU_AB_0\0" /* 2834 */
	"DB_SUBTILE_CONTROL\0" /* 2863 */
	"GB_ADDR_CONFIG\0" /* 2882 */
	"GB_TILE_MODE0\0" /* 2897 */
	"GB_TILE_MODE1\0" /* 2911 */
	"GB_TILE_MODE2\0" /* 2925 */
	"GB_TILE_MODE3\0" /* 2939 */
	"GB_TILE_MODE4\0" /* 2953 */
	"GB_TILE_MODE5\0" /* 2967 */
	"GB_TILE_MODE6\0" /* 2981 */
	"GB_TILE_MODE7\0" /* 2995 */
	"GB_TILE_MODE8\0" /* 3009 */
	"GB_TILE_MODE9\0" /* 3023 */
	"GB_TILE_MODE10\0" /* 3037 */
	"GB_TILE_MODE11\0" /* 3052 */
	"GB_TILE_MODE12\0" /* 3067 */
	"GB_TILE_MODE13\0" /* 3082 */
	"GB_TILE_MODE14\0" /* 3097 */
	"GB_TILE_MODE15\0" /* 3112 */
	"GB_TILE_MODE16\0" /* 3127 */
	"GB_TILE_MODE17\0" /* 3142 */
	"GB_TILE_MODE18\0" /* 3157 */
	"GB_TILE_MODE19\0" /* 3172 */
	"GB_TILE_MODE20\0" /* 3187 */
	"GB_TILE_MODE21\0" /* 3202 */
	"GB_TILE_MODE22\0" /* 3217 */
	"GB_TILE_MODE23\0" /* 3232 */
	"GB_TILE_MODE24\0" /* 3247 */
	"GB_TILE_MODE25\0" /* 3262 */
	"GB_TILE_MODE26\0" /* 3277 */
	"GB_TILE_MODE27\0" /* 3292 */
	"GB_TILE_MODE28\0" /* 3307 */
	"GB_TILE_MODE29\0" /* 3322 */
	"GB_TILE_MODE30\0" /* 3337 */
	"GB_TILE_MODE31\0" /* 3352 */
	"GB_MACROTILE_MODE0\0" /* 3367 */
	"GB_MACROTILE_MODE1\0" /* 3386 */
	"GB_MACROTILE_MODE2\0" /* 3405 */
	"GB_MACROTILE_MODE3\0" /* 3424 */
	"GB_MACROTILE_MODE4\0" /* 3443 */
	"GB_MACROTILE_MODE5\0" /* 3462 */
	"GB_MACROTILE_MODE6\0" /* 3481 */
	"GB_MACROTILE_MODE7\0" /* 3500 */
	"GB_MACROTILE_MODE8\0" /* 3519 */
	"GB_MACROTILE_MODE9\0" /* 3538 */
	"GB_MACROTILE_MODE10\0" /* 3557 */
	"GB_MACROTILE_MODE11\0" /* 3577 */
	"GB_MACROTILE_MODE12\0" /* 3597 */
	"GB_MACROTILE_MODE13\0" /* 3617 */
	"GB_MACROTILE_MODE14\0" /* 3637 */
	"GB_MACROTILE_MODE15\0" /* 3657 */
	"SPI_SHADER_TBA_LO_PS\0" /* 3677 */
	"SPI_SHADER_TBA_HI_PS\0" /* 3698 */
	"SPI_SHADER_TMA_LO_PS\0" /* 3719 */
	"SPI_SHADER_TMA_HI_PS\0" /* 3740 */
	"SPI_SHADER_PGM_RSRC3_PS\0" /* 3761 */
	"SPI_SHADER_PGM_LO_PS\0" /* 3785 */
	"SPI_SHADER_PGM_HI_PS\0" /* 3806 */
	"SPI_SHADER_PGM_RSRC1_PS\0" /* 3827 */
	"SPI_SHADER_PGM_RSRC2_PS\0" /* 3851 */
	"SPI_SHADER_USER_DATA_PS_0\0" /* 3875 */
	"SPI_SHADER_USER_DATA_PS_1\0" /* 3901 */
	"SPI_SHADER_USER_DATA_PS_2\0" /* 3927 */
	"SPI_SHADER_USER_DATA_PS_3\0" /* 3953 */
	"SPI_SHADER_USER_DATA_PS_4\0" /* 3979 */
	"SPI_SHADER_USER_DATA_PS_5\0" /* 4005 */
	"SPI_SHADER_USER_DATA_PS_6\0" /* 4031 */
	"SPI_SHADER_USER_DATA_PS_7\0" /* 4057 */
	"SPI_SHADER_USER_DATA_PS_8\0" /* 4083 */
	"SPI_SHADER_USER_DATA_PS_9\0" /* 4109 */
	"SPI_SHADER_USER_DATA_PS_10\0" /* 4135 */
	"SPI_SHADER_USER_DATA_PS_11\0" /* 4162 */
	"SPI_SHADER_USER_DATA_PS_12\0" /* 4189 */
	"SPI_SHADER_USER_DATA_PS_13\0" /* 4216 */
	"SPI_SHADER_USER_DATA_PS_14\0" /* 4243 */
	"SPI_SHADER_USER_DATA_PS_15\0" /* 4270 */
	"SPI_SHADER_TBA_LO_VS\0" /* 4297 */
	"SPI_SHADER_TBA_HI_VS\0" /* 4318 */
	"SPI_SHADER_TMA_LO_VS\0" /* 4339 */
	"SPI_SHADER_TMA_HI_VS\0" /* 4360 */
	"SPI_SHADER_PGM_RSRC3_VS\0" /* 4381 */
	"SPI_SHADER_LATE_ALLOC_VS\0" /* 4405 */
	"SPI_SHADER_PGM_LO_VS\0" /* 4430 */
	"SPI_SHADER_PGM_HI_VS\0" /* 4451 */
	"SPI_SHADER_PGM_RSRC1_VS\0" /* 4472 */
	"SPI_SHADER_PGM_RSRC2_VS\0" /* 4496 */
	"SPI_SHADER_USER_DATA_VS_0\0" /* 4520 */
	"SPI_SHADER_USER_DATA_VS_1\0" /* 4546 */
	"SPI_SHADER_USER_DATA_VS_2\0" /* 4572 */
	"SPI_SHADER_USER_DATA_VS_3\0" /* 4598 */
	"SPI_SHADER_USER_DATA_VS_4\0" /* 4624 */
	"SPI_SHADER_USER_DATA_VS_5\0" /* 4650 */
	"SPI_SHADER_USER_DATA_VS_6\0" /* 4676 */
	"SPI_SHADER_USER_DATA_VS_7\0" /* 4702 */
	"SPI_SHADER_USER_DATA_VS_8\0" /* 4728 */
	"SPI_SHADER_USER_DATA_VS_9\0" /* 4754 */
	"SPI_SHADER_USER_DATA_VS_10\0" /* 4780 */
	"SPI_SHADER_USER_DATA_VS_11\0" /* 4807 */
	"SPI_SHADER_USER_DATA_VS_12\0" /* 4834 */
	"SPI_SHADER_USER_DATA_VS_13\0" /* 4861 */
	"SPI_SHADER_USER_DATA_VS_14\0" /* 4888 */
	"SPI_SHADER_USER_DATA_VS_15\0" /* 4915 */
	"SPI_SHADER_TBA_LO_GS\0" /* 4942 */
	"SPI_SHADER_TBA_HI_GS\0" /* 4963 */
	"SPI_SHADER_TMA_LO_GS\0" /* 4984 */
	"SPI_SHADER_TMA_HI_GS\0" /* 5005 */
	"SPI_SHADER_PGM_RSRC3_GS\0" /* 5026 */
	"SPI_SHADER_PGM_LO_GS\0" /* 5050 */
	"SPI_SHADER_PGM_HI_GS\0" /* 5071 */
	"SPI_SHADER_PGM_RSRC1_GS\0" /* 5092 */
	"SPI_SHADER_PGM_RSRC2_GS\0" /* 5116 */
	"SPI_SHADER_USER_DATA_GS_0\0" /* 5140 */
	"SPI_SHADER_USER_DATA_GS_1\0" /* 5166 */
	"SPI_SHADER_USER_DATA_GS_2\0" /* 5192 */
	"SPI_SHADER_USER_DATA_GS_3\0" /* 5218 */
	"SPI_SHADER_USER_DATA_GS_4\0" /* 5244 */
	"SPI_SHADER_USER_DATA_GS_5\0" /* 5270 */
	"SPI_SHADER_USER_DATA_GS_6\0" /* 5296 */
	"SPI_SHADER_USER_DATA_GS_7\0" /* 5322 */
	"SPI_SHADER_USER_DATA_GS_8\0" /* 5348 */
	"SPI_SHADER_USER_DATA_GS_9\0" /* 5374 */
	"SPI_SHADER_USER_DATA_GS_10\0" /* 5400 */
	"SPI_SHADER_USER_DATA_GS_11\0" /* 5427 */
	"SPI_SHADER_USER_DATA_GS_12\0" /* 5454 */
	"SPI_SHADER_USER_DATA_GS_13\0" /* 5481 */
	"SPI_SHADER_USER_DATA_GS_14\0" /* 5508 */
	"SPI_SHADER_USER_DATA_GS_15\0" /* 5535 */
	"SPI_SHADER_TBA_LO_ES\0" /* 5562 */
	"SPI_SHADER_TBA_HI_ES\0" /* 5583 */
	"SPI_SHADER_TMA_LO_ES\0" /* 5604 */
	"SPI_SHADER_TMA_HI_ES\0" /* 5625 */
	"SPI_SHADER_PGM_RSRC3_ES\0" /* 5646 */
	"SPI_SHADER_PGM_LO_ES\0" /* 5670 */
	"SPI_SHADER_PGM_HI_ES\0" /* 5691 */
	"SPI_SHADER_PGM_RSRC1_ES\0" /* 5712 */
	"SPI_SHADER_PGM_RSRC2_ES\0" /* 5736 */
	"SPI_SHADER_USER_DATA_ES_0\0" /* 5760 */
	"SPI_SHADER_USER_DATA_ES_1\0" /* 5786 */
	"SPI_SHADER_USER_DATA_ES_2\0" /* 5812 */
	"SPI_SHADER_USER_DATA_ES_3\0" /* 5838 */
	"SPI_SHADER_USER_DATA_ES_4\0" /* 5864 */
	"SPI_SHADER_USER_DATA_ES_5\0" /* 5890 */
	"SPI_SHADER_USER_DATA_ES_6\0" /* 5916 */
	"SPI_SHADER_USER_DATA_ES_7\0" /* 5942 */
	"SPI_SHADER_USER_DATA_ES_8\0" /* 5968 */
	"SPI_SHADER_USER_DATA_ES_9\0" /* 5994 */
	"SPI_SHADER_USER_DATA_ES_10\0" /* 6020 */
	"SPI_SHADER_USER_DATA_ES_11\0" /* 6047 */
	"SPI_SHADER_USER_DATA_ES_12\0" /* 6074 */
	"SPI_SHADER_USER_DATA_ES_13\0" /* 6101 */
	"SPI_SHADER_USER_DATA_ES_14\0" /* 6128 */
	"SPI_SHADER_USER_DATA_ES_15\0" /* 6155 */
	"SPI_SHADER_TBA_LO_HS\0" /* 6182 */
	"SPI_SHADER_TBA_HI_HS\0" /* 6203 */
	"SPI_SHADER_TMA_LO_HS\0" /* 6224 */
	"SPI_SHADER_TMA_HI_HS\0" /* 6245 */
	"SPI_SHADER_PGM_RSRC3_HS\0" /* 6266 */
	"SPI_SHADER_PGM_LO_HS\0" /* 6290 */
	"SPI_SHADER_PGM_HI_HS\0" /* 6311 */
	"SPI_SHADER_PGM_RSRC1_HS\0" /* 6332 */
	"SPI_SHADER_PGM_RSRC2_HS\0" /* 6356 */
	"SPI_SHADER_USER_DATA_HS_0\0" /* 6380 */
	"SPI_SHADER_USER_DATA_HS_1\0" /* 6406 */
	"SPI_SHADER_USER_DATA_HS_2\0" /* 6432 */
	"SPI_SHADER_USER_DATA_HS_3\0" /* 6458 */
	"SPI_SHADER_USER_DATA_HS_4\0" /* 6484 */
	"SPI_SHADER_USER_DATA_HS_5\0" /* 6510 */
	"SPI_SHADER_USER_DATA_HS_6\0" /* 6536 */
	"SPI_SHADER_USER_DATA_HS_7\0" /* 6562 */
	"SPI_SHADER_USER_DATA_HS_8\0" /* 6588 */
	"SPI_SHADER_USER_DATA_HS_9\0" /* 6614 */
	"SPI_SHADER_USER_DATA_HS_10\0" /* 6640 */
	"SPI_SHADER_USER_DATA_HS_11\0" /* 6667 */
	"SPI_SHADER_USER_DATA_HS_12\0" /* 6694 */
	"SPI_SHADER_USER_DATA_HS_13\0" /* 6721 */
	"SPI_SHADER_USER_DATA_HS_14\0" /* 6748 */
	"SPI_SHADER_USER_DATA_HS_15\0" /* 6775 */
	"SPI_SHADER_TBA_LO_LS\0" /* 6802 */
	"SPI_SHADER_TBA_HI_LS\0" /* 6823 */
	"SPI_SHADER_TMA_LO_LS\0" /* 6844 */
	"SPI_SHADER_TMA_HI_LS\0" /* 6865 */
	"SPI_SHADER_PGM_RSRC3_LS\0" /* 6886 */
	"SPI_SHADER_PGM_LO_LS\0" /* 6910 */
	"SPI_SHADER_PGM_HI_LS\0" /* 6931 */
	"SPI_SHADER_PGM_RSRC1_LS\0" /* 6952 */
	"SPI_SHADER_PGM_RSRC2_LS\0" /* 6976 */
	"SPI_SHADER_USER_DATA_LS_0\0" /* 7000 */
	"SPI_SHADER_USER_DATA_LS_1\0" /* 7026 */
	"SPI_SHADER_USER_DATA_LS_2\0" /* 7052 */
	"SPI_SHADER_USER_DATA_LS_3\0" /* 7078 */
	"SPI_SHADER_USER_DATA_LS_4\0" /* 7104 */
	"SPI_SHADER_USER_DATA_LS_5\0" /* 7130 */
	"SPI_SHADER_USER_DATA_LS_6\0" /* 7156 */
	"SPI_SHADER_USER_DATA_LS_7\0" /* 7182 */
	"SPI_SHADER_USER_DATA_LS_8\0" /* 7208 */
	"SPI_SHADER_USER_DATA_LS_9\0" /* 7234 */
	"SPI_SHADER_USER_DATA_LS_10\0" /* 7260 */
	"SPI_SHADER_USER_DATA_LS_11\0" /* 7287 */
	"SPI_SHADER_USER_DATA_LS_12\0" /* 7314 */
	"SPI_SHADER_USER_DATA_LS_13\0" /* 7341 */
	"SPI_SHADER_USER_DATA_LS_14\0" /* 7368 */
	"SPI_SHADER_USER_DATA_LS_15\0" /* 7395 */
	"COMPUTE_DISPATCH_INITIATOR\0" /* 7422 */
	"COMPUTE_DIM_X\0" /* 7449 */
	"COMPUTE_DIM_Y\0" /* 7463 */
	"COMPUTE_DIM_Z\0" /* 7477 */
	"COMPUTE_START_X\0" /* 7491, 7499 */
	"COMPUTE_START_Y\0" /* 7507, 7515 */
	"COMPUTE_START_Z\0" /* 7523 */
	"COMPUTE_NUM_THREAD_X\0" /* 7539 */
	"COMPUTE_NUM_THREAD_Y\0" /* 7560 */
	"COMPUTE_NUM_THREAD_Z\0" /* 7581 */
	"COMPUTE_MAX_WAVE_ID\0" /* 7602 */
	"COMPUTE_PIPELINESTAT_ENABLE\0" /* 7622, 7630, 7643 */
	"COMPUTE_PERFCOUNT_ENABLE\0" /* 7650, 7658 */
	"COMPUTE_PGM_LO\0" /* 7675 */
	"COMPUTE_PGM_HI\0" /* 7690 */
	"COMPUTE_TBA_LO\0" /* 7705 */
	"COMPUTE_TBA_HI\0" /* 7720 */
	"COMPUTE_TMA_LO\0" /* 7735 */
	"COMPUTE_TMA_HI\0" /* 7750 */
	"COMPUTE_PGM_RSRC1\0" /* 7765 */
	"COMPUTE_PGM_RSRC2\0" /* 7783 */
	"COMPUTE_VMID\0" /* 7801 */
	"COMPUTE_RESOURCE_LIMITS\0" /* 7814 */
	"COMPUTE_STATIC_THREAD_MGMT_SE0\0" /* 7838 */
	"COMPUTE_STATIC_THREAD_MGMT_SE1\0" /* 7869 */
	"COMPUTE_TMPRING_SIZE\0" /* 7900 */
	"COMPUTE_STATIC_THREAD_MGMT_SE2\0" /* 7921 */
	"COMPUTE_STATIC_THREAD_MGMT_SE3\0" /* 7952 */
	"COMPUTE_RESTART_X\0" /* 7983 */
	"COMPUTE_RESTART_Y\0" /* 8001 */
	"COMPUTE_RESTART_Z\0" /* 8019 */
	"COMPUTE_MISC_RESERVED\0" /* 8037, 8050 */
	"COMPUTE_DISPATCH_ID\0" /* 8059 */
	"COMPUTE_THREADGROUP_ID\0" /* 8079 */
	"COMPUTE_RELAUNCH\0" /* 8102 */
	"COMPUTE_WAVE_RESTORE_ADDR_LO\0" /* 8119 */
	"COMPUTE_WAVE_RESTORE_ADDR_HI\0" /* 8148 */
	"COMPUTE_WAVE_RESTORE_CONTROL\0" /* 8177 */
	"COMPUTE_USER_DATA_0\0" /* 8206 */
	"COMPUTE_USER_DATA_1\0" /* 8226 */
	"COMPUTE_USER_DATA_2\0" /* 8246 */
	"COMPUTE_USER_DATA_3\0" /* 8266 */
	"COMPUTE_USER_DATA_4\0" /* 8286 */
	"COMPUTE_USER_DATA_5\0" /* 8306 */
	"COMPUTE_USER_DATA_6\0" /* 8326 */
	"COMPUTE_USER_DATA_7\0" /* 8346 */
	"COMPUTE_USER_DATA_8\0" /* 8366 */
	"COMPUTE_USER_DATA_9\0" /* 8386 */
	"COMPUTE_USER_DATA_10\0" /* 8406 */
	"COMPUTE_USER_DATA_11\0" /* 8427 */
	"COMPUTE_USER_DATA_12\0" /* 8448 */
	"COMPUTE_USER_DATA_13\0" /* 8469 */
	"COMPUTE_USER_DATA_14\0" /* 8490 */
	"COMPUTE_USER_DATA_15\0" /* 8511 */
	"COMPUTE_NOWHERE\0" /* 8532, 8540 */
	"CPG_PERFCOUNTER1_LO\0" /* 8548 */
	"CPG_PERFCOUNTER1_HI\0" /* 8568 */
	"CPG_PERFCOUNTER0_LO\0" /* 8588 */
	"CPG_PERFCOUNTER0_HI\0" /* 8608 */
	"CPC_PERFCOUNTER1_LO\0" /* 8628 */
	"CPC_PERFCOUNTER1_HI\0" /* 8648 */
	"CPC_PERFCOUNTER0_LO\0" /* 8668 */
	"CPC_PERFCOUNTER0_HI\0" /* 8688 */
	"CPF_PERFCOUNTER1_LO\0" /* 8708 */
	"CPF_PERFCOUNTER1_HI\0" /* 8728 */
	"CPF_PERFCOUNTER0_LO\0" /* 8748 */
	"CPF_PERFCOUNTER0_HI\0" /* 8768 */
	"GRBM_PERFCOUNTER0_LO\0" /* 8788 */
	"GRBM_PERFCOUNTER0_HI\0" /* 8809 */
	"GRBM_PERFCOUNTER1_LO\0" /* 8830 */
	"GRBM_PERFCOUNTER1_HI\0" /* 8851 */
	"GRBM_SE0_PERFCOUNTER_LO\0" /* 8872 */
	"GRBM_SE0_PERFCOUNTER_HI\0" /* 8896, 8905 */
	"GRBM_SE1_PERFCOUNTER_LO\0" /* 8920 */
	"GRBM_SE1_PERFCOUNTER_HI\0" /* 8944 */
	"GRBM_SE2_PERFCOUNTER_LO\0" /* 8968 */
	"GRBM_SE2_PERFCOUNTER_HI\0" /* 8992 */
	"GRBM_SE3_PERFCOUNTER_LO\0" /* 9016 */
	"GRBM_SE3_PERFCOUNTER_HI\0" /* 9040 */
	"WD_PERFCOUNTER0_LO\0" /* 9064 */
	"WD_PERFCOUNTER0_HI\0" /* 9083 */
	"WD_PERFCOUNTER1_LO\0" /* 9102 */
	"WD_PERFCOUNTER1_HI\0" /* 9121 */
	"WD_PERFCOUNTER2_LO\0" /* 9140 */
	"WD_PERFCOUNTER2_HI\0" /* 9159 */
	"WD_PERFCOUNTER3_LO\0" /* 9178 */
	"WD_PERFCOUNTER3_HI\0" /* 9197 */
	"IA_PERFCOUNTER0_LO\0" /* 9216 */
	"IA_PERFCOUNTER0_HI\0" /* 9235 */
	"IA_PERFCOUNTER1_LO\0" /* 9254 */
	"IA_PERFCOUNTER1_HI\0" /* 9273 */
	"IA_PERFCOUNTER2_LO\0" /* 9292 */
	"IA_PERFCOUNTER2_HI\0" /* 9311 */
	"IA_PERFCOUNTER3_LO\0" /* 9330 */
	"IA_PERFCOUNTER3_HI\0" /* 9349 */
	"VGT_PERFCOUNTER0_LO\0" /* 9368 */
	"VGT_PERFCOUNTER0_HI\0" /* 9388 */
	"VGT_PERFCOUNTER1_LO\0" /* 9408 */
	"VGT_PERFCOUNTER1_HI\0" /* 9428 */
	"VGT_PERFCOUNTER2_LO\0" /* 9448 */
	"VGT_PERFCOUNTER2_HI\0" /* 9468 */
	"VGT_PERFCOUNTER3_LO\0" /* 9488 */
	"VGT_PERFCOUNTER3_HI\0" /* 9508 */
	"PA_SU_PERFCOUNTER0_LO\0" /* 9528 */
	"PA_SU_PERFCOUNTER0_HI\0" /* 9550 */
	"PA_SU_PERFCOUNTER1_LO\0" /* 9572 */
	"PA_SU_PERFCOUNTER1_HI\0" /* 9594 */
	"PA_SU_PERFCOUNTER2_LO\0" /* 9616 */
	"PA_SU_PERFCOUNTER2_HI\0" /* 9638 */
	"PA_SU_PERFCOUNTER3_LO\0" /* 9660 */
	"PA_SU_PERFCOUNTER3_HI\0" /* 9682 */
	"PA_SC_PERFCOUNTER0_LO\0" /* 9704 */
	"PA_SC_PERFCOUNTER0_HI\0" /* 9726 */
	"PA_SC_PERFCOUNTER1_LO\0" /* 9748 */
	"PA_SC_PERFCOUNTER1_HI\0" /* 9770 */
	"PA_SC_PERFCOUNTER2_LO\0" /* 9792 */
	"PA_SC_PERFCOUNTER2_HI\0" /* 9814 */
	"PA_SC_PERFCOUNTER3_LO\0" /* 9836 */
	"PA_SC_PERFCOUNTER3_HI\0" /* 9858 */
	"PA_SC_PERFCOUNTER4_LO\0" /* 9880 */
	"PA_SC_PERFCOUNTER4_HI\0" /* 9902 */
	"PA_SC_PERFCOUNTER5_LO\0" /* 9924 */
	"PA_SC_PERFCOUNTER5_HI\0" /* 9946 */
	"PA_SC_PERFCOUNTER6_LO\0" /* 9968 */
	"PA_SC_PERFCOUNTER6_HI\0" /* 9990 */
	"PA_SC_PERFCOUNTER7_LO\0" /* 10012 */
	"PA_SC_PERFCOUNTER7_HI\0" /* 10034 */
	"SPI_PERFCOUNTER0_HI\0" /* 10056 */
	"SPI_PERFCOUNTER0_LO\0" /* 10076 */
	"SPI_PERFCOUNTER1_HI\0" /* 10096 */
	"SPI_PERFCOUNTER1_LO\0" /* 10116 */
	"SPI_PERFCOUNTER2_HI\0" /* 10136 */
	"SPI_PERFCOUNTER2_LO\0" /* 10156 */
	"SPI_PERFCOUNTER3_HI\0" /* 10176 */
	"SPI_PERFCOUNTER3_LO\0" /* 10196 */
	"SPI_PERFCOUNTER4_HI\0" /* 10216 */
	"SPI_PERFCOUNTER4_LO\0" /* 10236 */
	"SPI_PERFCOUNTER5_HI\0" /* 10256 */
	"SPI_PERFCOUNTER5_LO\0" /* 10276 */
	"SQ_PERFCOUNTER0_LO\0" /* 10296 */
	"SQ_PERFCOUNTER0_HI\0" /* 10315 */
	"SQ_PERFCOUNTER1_LO\0" /* 10334 */
	"SQ_PERFCOUNTER1_HI\0" /* 10353 */
	"SQ_PERFCOUNTER2_LO\0" /* 10372 */
	"SQ_PERFCOUNTER2_HI\0" /* 10391 */
	"SQ_PERFCOUNTER3_LO\0" /* 10410 */
	"SQ_PERFCOUNTER3_HI\0" /* 10429 */
	"SQ_PERFCOUNTER4_LO\0" /* 10448 */
	"SQ_PERFCOUNTER4_HI\0" /* 10467 */
	"SQ_PERFCOUNTER5_LO\0" /* 10486 */
	"SQ_PERFCOUNTER5_HI\0" /* 10505 */
	"SQ_PERFCOUNTER6_LO\0" /* 10524 */
	"SQ_PERFCOUNTER6_HI\0" /* 10543 */
	"SQ_PERFCOUNTER7_LO\0" /* 10562 */
	"SQ_PERFCOUNTER7_HI\0" /* 10581 */
	"SQ_PERFCOUNTER8_LO\0" /* 10600 */
	"SQ_PERFCOUNTER8_HI\0" /* 10619 */
	"SQ_PERFCOUNTER9_LO\0" /* 10638 */
	"SQ_PERFCOUNTER9_HI\0" /* 10657 */
	"SQ_PERFCOUNTER10_LO\0" /* 10676 */
	"SQ_PERFCOUNTER10_HI\0" /* 10696 */
	"SQ_PERFCOUNTER11_LO\0" /* 10716 */
	"SQ_PERFCOUNTER11_HI\0" /* 10736 */
	"SQ_PERFCOUNTER12_LO\0" /* 10756 */
	"SQ_PERFCOUNTER12_HI\0" /* 10776 */
	"SQ_PERFCOUNTER13_LO\0" /* 10796 */
	"SQ_PERFCOUNTER13_HI\0" /* 10816 */
	"SQ_PERFCOUNTER14_LO\0" /* 10836 */
	"SQ_PERFCOUNTER14_HI\0" /* 10856 */
	"SQ_PERFCOUNTER15_LO\0" /* 10876 */
	"SQ_PERFCOUNTER15_HI\0" /* 10896 */
	"SX_PERFCOUNTER0_LO\0" /* 10916 */
	"SX_PERFCOUNTER0_HI\0" /* 10935 */
	"SX_PERFCOUNTER1_LO\0" /* 10954 */
	"SX_PERFCOUNTER1_HI\0" /* 10973 */
	"SX_PERFCOUNTER2_LO\0" /* 10992 */
	"SX_PERFCOUNTER2_HI\0" /* 11011 */
	"SX_PERFCOUNTER3_LO\0" /* 11030 */
	"SX_PERFCOUNTER3_HI\0" /* 11049 */
	"GDS_PERFCOUNTER0_LO\0" /* 11068 */
	"GDS_PERFCOUNTER0_HI\0" /* 11088 */
	"GDS_PERFCOUNTER1_LO\0" /* 11108 */
	"GDS_PERFCOUNTER1_HI\0" /* 11128 */
	"GDS_PERFCOUNTER2_LO\0" /* 11148 */
	"GDS_PERFCOUNTER2_HI\0" /* 11168 */
	"GDS_PERFCOUNTER3_LO\0" /* 11188 */
	"GDS_PERFCOUNTER3_HI\0" /* 11208 */
	"TA_PERFCOUNTER0_LO\0" /* 11228 */
	"TA_PERFCOUNTER0_HI\0" /* 11247 */
	"TA_PERFCOUNTER1_LO\0" /* 11266 */
	"TA_PERFCOUNTER1_HI\0" /* 11285 */
	"TD_PERFCOUNTER0_LO\0" /* 11304 */
	"TD_PERFCOUNTER0_HI\0" /* 11323 */
	"TD_PERFCOUNTER1_LO\0" /* 11342 */
	"TD_PERFCOUNTER1_HI\0" /* 11361 */
	"TCP_PERFCOUNTER0_LO\0" /* 11380 */
	"TCP_PERFCOUNTER0_HI\0" /* 11400 */
	"TCP_PERFCOUNTER1_LO\0" /* 11420 */
	"TCP_PERFCOUNTER1_HI\0" /* 11440 */
	"TCP_PERFCOUNTER2_LO\0" /* 11460 */
	"TCP_PERFCOUNTER2_HI\0" /* 11480 */
	"TCP_PERFCOUNTER3_LO\0" /* 11500 */
	"TCP_PERFCOUNTER3_HI\0" /* 11520 */
	"TCC_PERFCOUNTER0_LO\0" /* 11540 */
	"TCC_PERFCOUNTER0_HI\0" /* 11560 */
	"TCC_PERFCOUNTER1_LO\0" /* 11580 */
	"TCC_PERFCOUNTER1_HI\0" /* 11600 */
	"TCC_PERFCOUNTER2_LO\0" /* 11620 */
	"TCC_PERFCOUNTER2_HI\0" /* 11640 */
	"TCC_PERFCOUNTER3_LO\0" /* 11660 */
	"TCC_PERFCOUNTER3_HI\0" /* 11680 */
	"TCA_PERFCOUNTER0_LO\0" /* 11700 */
	"TCA_PERFCOUNTER0_HI\0" /* 11720 */
	"TCA_PERFCOUNTER1_LO\0" /* 11740 */
	"TCA_PERFCOUNTER1_HI\0" /* 11760 */
	"TCA_PERFCOUNTER2_LO\0" /* 11780 */
	"TCA_PERFCOUNTER2_HI\0" /* 11800 */
	"TCA_PERFCOUNTER3_LO\0" /* 11820 */
	"TCA_PERFCOUNTER3_HI\0" /* 11840 */
	"CB_PERFCOUNTER0_LO\0" /* 11860 */
	"CB_PERFCOUNTER0_HI\0" /* 11879 */
	"CB_PERFCOUNTER1_LO\0" /* 11898 */
	"CB_PERFCOUNTER1_HI\0" /* 11917 */
	"CB_PERFCOUNTER2_LO\0" /* 11936 */
	"CB_PERFCOUNTER2_HI\0" /* 11955 */
	"CB_PERFCOUNTER3_LO\0" /* 11974 */
	"CB_PERFCOUNTER3_HI\0" /* 11993 */
	"DB_PERFCOUNTER0_LO\0" /* 12012 */
	"DB_PERFCOUNTER0_HI\0" /* 12031 */
	"DB_PERFCOUNTER1_LO\0" /* 12050 */
	"DB_PERFCOUNTER1_HI\0" /* 12069 */
	"DB_PERFCOUNTER2_LO\0" /* 12088 */
	"DB_PERFCOUNTER2_HI\0" /* 12107 */
	"DB_PERFCOUNTER3_LO\0" /* 12126 */
	"DB_PERFCOUNTER3_HI\0" /* 12145 */
	"RLC_PERFCOUNTER0_LO\0" /* 12164 */
	"RLC_PERFCOUNTER0_HI\0" /* 12184 */
	"RLC_PERFCOUNTER1_LO\0" /* 12204 */
	"RLC_PERFCOUNTER1_HI\0" /* 12224 */
	"CPG_PERFCOUNTER1_SELECT\0" /* 12244 */
	"CPG_PERFCOUNTER0_SELECT1\0" /* 12268 */
	"CPG_PERFCOUNTER0_SELECT\0" /* 12293 */
	"CPC_PERFCOUNTER1_SELECT\0" /* 12317 */
	"CPC_PERFCOUNTER0_SELECT1\0" /* 12341 */
	"CPF_PERFCOUNTER1_SELECT\0" /* 12366 */
	"CPF_PERFCOUNTER0_SELECT1\0" /* 12390 */
	"CPF_PERFCOUNTER0_SELECT\0" /* 12415 */
	"CP_PERFMON_CNTL\0" /* 12439 */
	"CPC_PERFCOUNTER0_SELECT\0" /* 12455 */
	"GRBM_PERFCOUNTER0_SELECT\0" /* 12479 */
	"GRBM_PERFCOUNTER1_SELECT\0" /* 12504 */
	"GRBM_SE0_PERFCOUNTER_SELECT\0" /* 12529, 12538 */
	"GRBM_SE1_PERFCOUNTER_SELECT\0" /* 12557 */
	"GRBM_SE2_PERFCOUNTER_SELECT\0" /* 12585 */
	"GRBM_SE3_PERFCOUNTER_SELECT\0" /* 12613 */
	"WD_PERFCOUNTER0_SELECT\0" /* 12641 */
	"WD_PERFCOUNTER1_SELECT\0" /* 12664 */
	"WD_PERFCOUNTER2_SELECT\0" /* 12687 */
	"WD_PERFCOUNTER3_SELECT\0" /* 12710 */
	"IA_PERFCOUNTER0_SELECT\0" /* 12733 */
	"IA_PERFCOUNTER1_SELECT\0" /* 12756 */
	"IA_PERFCOUNTER2_SELECT\0" /* 12779 */
	"IA_PERFCOUNTER3_SELECT\0" /* 12802 */
	"IA_PERFCOUNTER0_SELECT1\0" /* 12825 */
	"VGT_PERFCOUNTER0_SELECT\0" /* 12849 */
	"VGT_PERFCOUNTER1_SELECT\0" /* 12873 */
	"VGT_PERFCOUNTER2_SELECT\0" /* 12897 */
	"VGT_PERFCOUNTER3_SELECT\0" /* 12921 */
	"VGT_PERFCOUNTER0_SELECT1\0" /* 12945 */
	"VGT_PERFCOUNTER1_SELECT1\0" /* 12970 */
	"VGT_PERFCOUNTER_SEID_MASK\0" /* 12995 */
	"PA_SU_PERFCOUNTER0_SELECT\0" /* 13021 */
	"PA_SU_PERFCOUNTER0_SELECT1\0" /* 13047 */
	"PA_SU_PERFCOUNTER1_SELECT\0" /* 13074 */
	"PA_SU_PERFCOUNTER1_SELECT1\0" /* 13100 */
	"PA_SU_PERFCOUNTER2_SELECT\0" /* 13127 */
	"PA_SU_PERFCOUNTER3_SELECT\0" /* 13153 */
	"PA_SC_PERFCOUNTER0_SELECT\0" /* 13179 */
	"PA_SC_PERFCOUNTER0_SELECT1\0" /* 13205 */
	"PA_SC_PERFCOUNTER1_SELECT\0" /* 13232 */
	"PA_SC_PERFCOUNTER2_SELECT\0" /* 13258 */
	"PA_SC_PERFCOUNTER3_SELECT\0" /* 13284 */
	"PA_SC_PERFCOUNTER4_SELECT\0" /* 13310 */
	"PA_SC_PERFCOUNTER5_SELECT\0" /* 13336 */
	"PA_SC_PERFCOUNTER6_SELECT\0" /* 13362 */
	"PA_SC_PERFCOUNTER7_SELECT\0" /* 13388 */
	"SPI_PERFCOUNTER0_SELECT\0" /* 13414 */
	"SPI_PERFCOUNTER1_SELECT\0" /* 13438 */
	"SPI_PERFCOUNTER2_SELECT\0" /* 13462 */
	"SPI_PERFCOUNTER3_SELECT\0" /* 13486 */
	"SPI_PERFCOUNTER0_SELECT1\0" /* 13510 */
	"SPI_PERFCOUNTER1_SELECT1\0" /* 13535 */
	"SPI_PERFCOUNTER2_SELECT1\0" /* 13560 */
	"SPI_PERFCOUNTER3_SELECT1\0" /* 13585 */
	"SPI_PERFCOUNTER4_SELECT\0" /* 13610 */
	"SPI_PERFCOUNTER5_SELECT\0" /* 13634 */
	"SPI_PERFCOUNTER_BINS\0" /* 13658 */
	"SQ_PERFCOUNTER0_SELECT\0" /* 13679 */
	"SQ_PERFCOUNTER1_SELECT\0" /* 13702 */
	"SQ_PERFCOUNTER2_SELECT\0" /* 13725 */
	"SQ_PERFCOUNTER3_SELECT\0" /* 13748 */
	"SQ_PERFCOUNTER4_SELECT\0" /* 13771 */
	"SQ_PERFCOUNTER5_SELECT\0" /* 13794 */
	"SQ_PERFCOUNTER6_SELECT\0" /* 13817 */
	"SQ_PERFCOUNTER7_SELECT\0" /* 13840 */
	"SQ_PERFCOUNTER8_SELECT\0" /* 13863 */
	"SQ_PERFCOUNTER9_SELECT\0" /* 13886 */
	"SQ_PERFCOUNTER10_SELECT\0" /* 13909 */
	"SQ_PERFCOUNTER11_SELECT\0" /* 13933 */
	"SQ_PERFCOUNTER12_SELECT\0" /* 13957 */
	"SQ_PERFCOUNTER13_SELECT\0" /* 13981 */
	"SQ_PERFCOUNTER14_SELECT\0" /* 14005 */
	"SQ_PERFCOUNTER15_SELECT\0" /* 14029 */
	"SQ_PERFCOUNTER_CTRL\0" /* 14053 */
	"SQ_PERFCOUNTER_MASK\0" /* 14073 */
	"SQ_PERFCOUNTER_CTRL2\0" /* 14093 */
	"SX_PERFCOUNTER0_SELECT\0" /* 14114 */
	"SX_PERFCOUNTER1_SELECT\0" /* 14137 */
	"SX_PERFCOUNTER2_SELECT\0" /* 14160 */
	"SX_PERFCOUNTER3_SELECT\0" /* 14183 */
	"SX_PERFCOUNTER0_SELECT1\0" /* 14206 */
	"SX_PERFCOUNTER1_SELECT1\0" /* 14230 */
	"GDS_PERFCOUNTER0_SELECT\0" /* 14254 */
	"GDS_PERFCOUNTER1_SELECT\0" /* 14278 */
	"GDS_PERFCOUNTER2_SELECT\0" /* 14302 */
	"GDS_PERFCOUNTER3_SELECT\0" /* 14326 */
	"GDS_PERFCOUNTER0_SELECT1\0" /* 14350 */
	"TA_PERFCOUNTER0_SELECT\0" /* 14375 */
	"TA_PERFCOUNTER0_SELECT1\0" /* 14398 */
	"TA_PERFCOUNTER1_SELECT\0" /* 14422 */
	"TD_PERFCOUNTER0_SELECT\0" /* 14445 */
	"TD_PERFCOUNTER0_SELECT1\0" /* 14468 */
	"TD_PERFCOUNTER1_SELECT\0" /* 14492 */
	"TCP_PERFCOUNTER0_SELECT\0" /* 14515 */
	"TCP_PERFCOUNTER0_SELECT1\0" /* 14539 */
	"TCP_PERFCOUNTER1_SELECT\0" /* 14564 */
	"TCP_PERFCOUNTER1_SELECT1\0" /* 14588 */
	"TCP_PERFCOUNTER2_SELECT\0" /* 14613 */
	"TCP_PERFCOUNTER3_SELECT\0" /* 14637 */
	"TCC_PERFCOUNTER0_SELECT\0" /* 14661 */
	"TCC_PERFCOUNTER0_SELECT1\0" /* 14685 */
	"TCC_PERFCOUNTER1_SELECT\0" /* 14710 */
	"TCC_PERFCOUNTER1_SELECT1\0" /* 14734 */
	"TCC_PERFCOUNTER2_SELECT\0" /* 14759 */
	"TCC_PERFCOUNTER3_SELECT\0" /* 14783 */
	"TCA_PERFCOUNTER0_SELECT\0" /* 14807 */
	"TCA_PERFCOUNTER0_SELECT1\0" /* 14831 */
	"TCA_PERFCOUNTER1_SELECT\0" /* 14856 */
	"TCA_PERFCOUNTER1_SELECT1\0" /* 14880 */
	"TCA_PERFCOUNTER2_SELECT\0" /* 14905 */
	"TCA_PERFCOUNTER3_SELECT\0" /* 14929 */
	"CB_PERFCOUNTER_FILTER\0" /* 14953 */
	"CB_PERFCOUNTER0_SELECT\0" /* 14975 */
	"CB_PERFCOUNTER0_SELECT1\0" /* 14998 */
	"CB_PERFCOUNTER1_SELECT\0" /* 15022 */
	"CB_PERFCOUNTER2_SELECT\0" /* 15045 */
	"CB_PERFCOUNTER3_SELECT\0" /* 15068 */
	"DB_PERFCOUNTER0_SELECT\0" /* 15091 */
	"DB_PERFCOUNTER0_SELECT1\0" /* 15114 */
	"DB_PERFCOUNTER1_SELECT\0" /* 15138 */
	"DB_PERFCOUNTER1_SELECT1\0" /* 15161 */
	"DB_PERFCOUNTER2_SELECT\0" /* 15185 */
	"DB_PERFCOUNTER3_SELECT\0" /* 15208 */
	"DB_RENDER_CONTROL\0" /* 15231 */
	"DB_COUNT_CONTROL\0" /* 15249 */
	"DB_DEPTH_VIEW\0" /* 15266 */
	"DB_RENDER_OVERRIDE\0" /* 15280, 15296 */
	"DB_RENDER_OVERRIDE2\0" /* 15299 */
	"DB_HTILE_DATA_BASE\0" /* 15319 */
	"DB_DEPTH_BOUNDS_MIN\0" /* 15338 */
	"DB_DEPTH_BOUNDS_MAX\0" /* 15358 */
	"DB_STENCIL_CLEAR\0" /* 15378, 15389 */
	"DB_DEPTH_CLEAR\0" /* 15395 */
	"PA_SC_SCREEN_SCISSOR_TL\0" /* 15410 */
	"PA_SC_SCREEN_SCISSOR_BR\0" /* 15434 */
	"DB_DEPTH_INFO\0" /* 15458 */
	"DB_Z_INFO\0" /* 15472 */
	"DB_STENCIL_INFO\0" /* 15482 */
	"DB_Z_READ_BASE\0" /* 15498 */
	"DB_STENCIL_READ_BASE\0" /* 15513 */
	"DB_Z_WRITE_BASE\0" /* 15534 */
	"DB_STENCIL_WRITE_BASE\0" /* 15550 */
	"DB_DEPTH_SIZE\0" /* 15572 */
	"DB_DEPTH_SLICE\0" /* 15586 */
	"TA_BC_BASE_ADDR\0" /* 15601 */
	"TA_BC_BASE_ADDR_HI\0" /* 15617 */
	"COHER_DEST_BASE_HI_0\0" /* 15636 */
	"COHER_DEST_BASE_HI_1\0" /* 15657 */
	"COHER_DEST_BASE_HI_2\0" /* 15678 */
	"COHER_DEST_BASE_HI_3\0" /* 15699 */
	"COHER_DEST_BASE_2\0" /* 15720 */
	"COHER_DEST_BASE_3\0" /* 15738 */
	"PA_SC_WINDOW_OFFSET\0" /* 15756, 15767 */
	"PA_SC_WINDOW_SCISSOR_TL\0" /* 15776 */
	"PA_SC_WINDOW_SCISSOR_BR\0" /* 15800 */
	"PA_SC_CLIPRECT_RULE\0" /* 15824 */
	"PA_SC_CLIPRECT_0_TL\0" /* 15844 */
	"PA_SC_CLIPRECT_0_BR\0" /* 15864 */
	"PA_SC_CLIPRECT_1_TL\0" /* 15884 */
	"PA_SC_CLIPRECT_1_BR\0" /* 15904 */
	"PA_SC_CLIPRECT_2_TL\0" /* 15924 */
	"PA_SC_CLIPRECT_2_BR\0" /* 15944 */
	"PA_SC_CLIPRECT_3_TL\0" /* 15964 */
	"PA_SC_CLIPRECT_3_BR\0" /* 15984 */
	"PA_SC_EDGERULE\0" /* 16004 */
	"PA_SU_HARDWARE_SCREEN_OFFSET\0" /* 16019 */
	"CB_TARGET_MASK\0" /* 16048 */
	"CB_SHADER_MASK\0" /* 16063 */
	"PA_SC_GENERIC_SCISSOR_TL\0" /* 16078 */
	"PA_SC_GENERIC_SCISSOR_BR\0" /* 16103 */
	"COHER_DEST_BASE_0\0" /* 16128 */
	"COHER_DEST_BASE_1\0" /* 16146 */
	"PA_SC_VPORT_SCISSOR_0_TL\0" /* 16164 */
	"PA_SC_VPORT_SCISSOR_0_BR\0" /* 16189 */
	"PA_SC_VPORT_SCISSOR_1_TL\0" /* 16214 */
	"PA_SC_VPORT_SCISSOR_1_BR\0" /* 16239 */
	"PA_SC_VPORT_SCISSOR_2_TL\0" /* 16264 */
	"PA_SC_VPORT_SCISSOR_2_BR\0" /* 16289 */
	"PA_SC_VPORT_SCISSOR_3_TL\0" /* 16314 */
	"PA_SC_VPORT_SCISSOR_3_BR\0" /* 16339 */
	"PA_SC_VPORT_SCISSOR_4_TL\0" /* 16364 */
	"PA_SC_VPORT_SCISSOR_4_BR\0" /* 16389 */
	"PA_SC_VPORT_SCISSOR_5_TL\0" /* 16414 */
	"PA_SC_VPORT_SCISSOR_5_BR\0" /* 16439 */
	"PA_SC_VPORT_SCISSOR_6_TL\0" /* 16464 */
	"PA_SC_VPORT_SCISSOR_6_BR\0" /* 16489 */
	"PA_SC_VPORT_SCISSOR_7_TL\0" /* 16514 */
	"PA_SC_VPORT_SCISSOR_7_BR\0" /* 16539 */
	"PA_SC_VPORT_SCISSOR_8_TL\0" /* 16564 */
	"PA_SC_VPORT_SCISSOR_8_BR\0" /* 16589 */
	"PA_SC_VPORT_SCISSOR_9_TL\0" /* 16614 */
	"PA_SC_VPORT_SCISSOR_9_BR\0" /* 16639 */
	"PA_SC_VPORT_SCISSOR_10_TL\0" /* 16664 */
	"PA_SC_VPORT_SCISSOR_10_BR\0" /* 16690 */
	"PA_SC_VPORT_SCISSOR_11_TL\0" /* 16716 */
	"PA_SC_VPORT_SCISSOR_11_BR\0" /* 16742 */
	"PA_SC_VPORT_SCISSOR_12_TL\0" /* 16768 */
	"PA_SC_VPORT_SCISSOR_12_BR\0" /* 16794 */
	"PA_SC_VPORT_SCISSOR_13_TL\0" /* 16820 */
	"PA_SC_VPORT_SCISSOR_13_BR\0" /* 16846 */
	"PA_SC_VPORT_SCISSOR_14_TL\0" /* 16872 */
	"PA_SC_VPORT_SCISSOR_14_BR\0" /* 16898 */
	"PA_SC_VPORT_SCISSOR_15_TL\0" /* 16924 */
	"PA_SC_VPORT_SCISSOR_15_BR\0" /* 16950 */
	"PA_SC_VPORT_ZMIN_0\0" /* 16976 */
	"PA_SC_VPORT_ZMAX_0\0" /* 16995 */
	"PA_SC_VPORT_ZMIN_1\0" /* 17014 */
	"PA_SC_VPORT_ZMAX_1\0" /* 17033 */
	"PA_SC_VPORT_ZMIN_2\0" /* 17052 */
	"PA_SC_VPORT_ZMAX_2\0" /* 17071 */
	"PA_SC_VPORT_ZMIN_3\0" /* 17090 */
	"PA_SC_VPORT_ZMAX_3\0" /* 17109 */
	"PA_SC_VPORT_ZMIN_4\0" /* 17128 */
	"PA_SC_VPORT_ZMAX_4\0" /* 17147 */
	"PA_SC_VPORT_ZMIN_5\0" /* 17166 */
	"PA_SC_VPORT_ZMAX_5\0" /* 17185 */
	"PA_SC_VPORT_ZMIN_6\0" /* 17204 */
	"PA_SC_VPORT_ZMAX_6\0" /* 17223 */
	"PA_SC_VPORT_ZMIN_7\0" /* 17242 */
	"PA_SC_VPORT_ZMAX_7\0" /* 17261 */
	"PA_SC_VPORT_ZMIN_8\0" /* 17280 */
	"PA_SC_VPORT_ZMAX_8\0" /* 17299 */
	"PA_SC_VPORT_ZMIN_9\0" /* 17318 */
	"PA_SC_VPORT_ZMAX_9\0" /* 17337 */
	"PA_SC_VPORT_ZMIN_10\0" /* 17356 */
	"PA_SC_VPORT_ZMAX_10\0" /* 17376 */
	"PA_SC_VPORT_ZMIN_11\0" /* 17396 */
	"PA_SC_VPORT_ZMAX_11\0" /* 17416 */
	"PA_SC_VPORT_ZMIN_12\0" /* 17436 */
	"PA_SC_VPORT_ZMAX_12\0" /* 17456 */
	"PA_SC_VPORT_ZMIN_13\0" /* 17476 */
	"PA_SC_VPORT_ZMAX_13\0" /* 17496 */
	"PA_SC_VPORT_ZMIN_14\0" /* 17516 */
	"PA_SC_VPORT_ZMAX_14\0" /* 17536 */
	"PA_SC_VPORT_ZMIN_15\0" /* 17556 */
	"PA_SC_VPORT_ZMAX_15\0" /* 17576 */
	"PA_SC_RASTER_CONFIG\0" /* 17596 */
	"PA_SC_RASTER_CONFIG_1\0" /* 17616 */
	"PA_SC_SCREEN_EXTENT_CONTROL\0" /* 17638 */
	"VGT_MAX_VTX_INDX\0" /* 17666 */
	"VGT_MIN_VTX_INDX\0" /* 17683 */
	"VGT_INDX_OFFSET\0" /* 17700, 17707 */
	"VGT_MULTI_PRIM_IB_RESET_INDX\0" /* 17716 */
	"CB_BLEND_RED\0" /* 17745 */
	"CB_BLEND_GREEN\0" /* 17758 */
	"CB_BLEND_BLUE\0" /* 17773 */
	"CB_BLEND_ALPHA\0" /* 17787 */
	"CB_DCC_CONTROL\0" /* 17802 */
	"DB_STENCIL_CONTROL\0" /* 17817 */
	"DB_STENCILREFMASK\0" /* 17836 */
	"DB_STENCILREFMASK_BF\0" /* 17854 */
	"PA_CL_VPORT_XSCALE\0" /* 17875 */
	"PA_CL_VPORT_XOFFSET\0" /* 17894 */
	"PA_CL_VPORT_YSCALE\0" /* 17914 */
	"PA_CL_VPORT_YOFFSET\0" /* 17933 */
	"PA_CL_VPORT_ZSCALE\0" /* 17953 */
	"PA_CL_VPORT_ZOFFSET\0" /* 17972 */
	"PA_CL_VPORT_XSCALE_1\0" /* 17992 */
	"PA_CL_VPORT_XOFFSET_1\0" /* 18013 */
	"PA_CL_VPORT_YSCALE_1\0" /* 18035 */
	"PA_CL_VPORT_YOFFSET_1\0" /* 18056 */
	"PA_CL_VPORT_ZSCALE_1\0" /* 18078 */
	"PA_CL_VPORT_ZOFFSET_1\0" /* 18099 */
	"PA_CL_VPORT_XSCALE_2\0" /* 18121 */
	"PA_CL_VPORT_XOFFSET_2\0" /* 18142 */
	"PA_CL_VPORT_YSCALE_2\0" /* 18164 */
	"PA_CL_VPORT_YOFFSET_2\0" /* 18185 */
	"PA_CL_VPORT_ZSCALE_2\0" /* 18207 */
	"PA_CL_VPORT_ZOFFSET_2\0" /* 18228 */
	"PA_CL_VPORT_XSCALE_3\0" /* 18250 */
	"PA_CL_VPORT_XOFFSET_3\0" /* 18271 */
	"PA_CL_VPORT_YSCALE_3\0" /* 18293 */
	"PA_CL_VPORT_YOFFSET_3\0" /* 18314 */
	"PA_CL_VPORT_ZSCALE_3\0" /* 18336 */
	"PA_CL_VPORT_ZOFFSET_3\0" /* 18357 */
	"PA_CL_VPORT_XSCALE_4\0" /* 18379 */
	"PA_CL_VPORT_XOFFSET_4\0" /* 18400 */
	"PA_CL_VPORT_YSCALE_4\0" /* 18422 */
	"PA_CL_VPORT_YOFFSET_4\0" /* 18443 */
	"PA_CL_VPORT_ZSCALE_4\0" /* 18465 */
	"PA_CL_VPORT_ZOFFSET_4\0" /* 18486 */
	"PA_CL_VPORT_XSCALE_5\0" /* 18508 */
	"PA_CL_VPORT_XOFFSET_5\0" /* 18529 */
	"PA_CL_VPORT_YSCALE_5\0" /* 18551 */
	"PA_CL_VPORT_YOFFSET_5\0" /* 18572 */
	"PA_CL_VPORT_ZSCALE_5\0" /* 18594 */
	"PA_CL_VPORT_ZOFFSET_5\0" /* 18615 */
	"PA_CL_VPORT_XSCALE_6\0" /* 18637 */
	"PA_CL_VPORT_XOFFSET_6\0" /* 18658 */
	"PA_CL_VPORT_YSCALE_6\0" /* 18680 */
	"PA_CL_VPORT_YOFFSET_6\0" /* 18701 */
	"PA_CL_VPORT_ZSCALE_6\0" /* 18723 */
	"PA_CL_VPORT_ZOFFSET_6\0" /* 18744 */
	"PA_CL_VPORT_XSCALE_7\0" /* 18766 */
	"PA_CL_VPORT_XOFFSET_7\0" /* 18787 */
	"PA_CL_VPORT_YSCALE_7\0" /* 18809 */
	"PA_CL_VPORT_YOFFSET_7\0" /* 18830 */
	"PA_CL_VPORT_ZSCALE_7\0" /* 18852 */
	"PA_CL_VPORT_ZOFFSET_7\0" /* 18873 */
	"PA_CL_VPORT_XSCALE_8\0" /* 18895 */
	"PA_CL_VPORT_XOFFSET_8\0" /* 18916 */
	"PA_CL_VPORT_YSCALE_8\0" /* 18938 */
	"PA_CL_VPORT_YOFFSET_8\0" /* 18959 */
	"PA_CL_VPORT_ZSCALE_8\0" /* 18981 */
	"PA_CL_VPORT_ZOFFSET_8\0" /* 19002 */
	"PA_CL_VPORT_XSCALE_9\0" /* 19024 */
	"PA_CL_VPORT_XOFFSET_9\0" /* 19045 */
	"PA_CL_VPORT_YSCALE_9\0" /* 19067 */
	"PA_CL_VPORT_YOFFSET_9\0" /* 19088 */
	"PA_CL_VPORT_ZSCALE_9\0" /* 19110 */
	"PA_CL_VPORT_ZOFFSET_9\0" /* 19131 */
	"PA_CL_VPORT_XSCALE_10\0" /* 19153 */
	"PA_CL_VPORT_XOFFSET_10\0" /* 19175 */
	"PA_CL_VPORT_YSCALE_10\0" /* 19198 */
	"PA_CL_VPORT_YOFFSET_10\0" /* 19220 */
	"PA_CL_VPORT_ZSCALE_10\0" /* 19243 */
	"PA_CL_VPORT_ZOFFSET_10\0" /* 19265 */
	"PA_CL_VPORT_XSCALE_11\0" /* 19288 */
	"PA_CL_VPORT_XOFFSET_11\0" /* 19310 */
	"PA_CL_VPORT_YSCALE_11\0" /* 19333 */
	"PA_CL_VPORT_YOFFSET_11\0" /* 19355 */
	"PA_CL_VPORT_ZSCALE_11\0" /* 19378 */
	"PA_CL_VPORT_ZOFFSET_11\0" /* 19400 */
	"PA_CL_VPORT_XSCALE_12\0" /* 19423 */
	"PA_CL_VPORT_XOFFSET_12\0" /* 19445 */
	"PA_CL_VPORT_YSCALE_12\0" /* 19468 */
	"PA_CL_VPORT_YOFFSET_12\0" /* 19490 */
	"PA_CL_VPORT_ZSCALE_12\0" /* 19513 */
	"PA_CL_VPORT_ZOFFSET_12\0" /* 19535 */
	"PA_CL_VPORT_XSCALE_13\0" /* 19558 */
	"PA_CL_VPORT_XOFFSET_13\0" /* 19580 */
	"PA_CL_VPORT_YSCALE_13\0" /* 19603 */
	"PA_CL_VPORT_YOFFSET_13\0" /* 19625 */
	"PA_CL_VPORT_ZSCALE_13\0" /* 19648 */
	"PA_CL_VPORT_ZOFFSET_13\0" /* 19670 */
	"PA_CL_VPORT_XSCALE_14\0" /* 19693 */
	"PA_CL_VPORT_XOFFSET_14\0" /* 19715 */
	"PA_CL_VPORT_YSCALE_14\0" /* 19738 */
	"PA_CL_VPORT_YOFFSET_14\0" /* 19760 */
	"PA_CL_VPORT_ZSCALE_14\0" /* 19783 */
	"PA_CL_VPORT_ZOFFSET_14\0" /* 19805 */
	"PA_CL_VPORT_XSCALE_15\0" /* 19828 */
	"PA_CL_VPORT_XOFFSET_15\0" /* 19850 */
	"PA_CL_VPORT_YSCALE_15\0" /* 19873 */
	"PA_CL_VPORT_YOFFSET_15\0" /* 19895 */
	"PA_CL_VPORT_ZSCALE_15\0" /* 19918 */
	"PA_CL_VPORT_ZOFFSET_15\0" /* 19940 */
	"PA_CL_UCP_0_X\0" /* 19963 */
	"PA_CL_UCP_0_Y\0" /* 19977 */
	"PA_CL_UCP_0_Z\0" /* 19991 */
	"PA_CL_UCP_0_W\0" /* 20005 */
	"PA_CL_UCP_1_X\0" /* 20019 */
	"PA_CL_UCP_1_Y\0" /* 20033 */
	"PA_CL_UCP_1_Z\0" /* 20047 */
	"PA_CL_UCP_1_W\0" /* 20061 */
	"PA_CL_UCP_2_X\0" /* 20075 */
	"PA_CL_UCP_2_Y\0" /* 20089 */
	"PA_CL_UCP_2_Z\0" /* 20103 */
	"PA_CL_UCP_2_W\0" /* 20117 */
	"PA_CL_UCP_3_X\0" /* 20131 */
	"PA_CL_UCP_3_Y\0" /* 20145 */
	"PA_CL_UCP_3_Z\0" /* 20159 */
	"PA_CL_UCP_3_W\0" /* 20173 */
	"PA_CL_UCP_4_X\0" /* 20187 */
	"PA_CL_UCP_4_Y\0" /* 20201 */
	"PA_CL_UCP_4_Z\0" /* 20215 */
	"PA_CL_UCP_4_W\0" /* 20229 */
	"PA_CL_UCP_5_X\0" /* 20243 */
	"PA_CL_UCP_5_Y\0" /* 20257 */
	"PA_CL_UCP_5_Z\0" /* 20271 */
	"PA_CL_UCP_5_W\0" /* 20285 */
	"SPI_PS_INPUT_CNTL_0\0" /* 20299 */
	"SPI_PS_INPUT_CNTL_1\0" /* 20319 */
	"SPI_PS_INPUT_CNTL_2\0" /* 20339 */
	"SPI_PS_INPUT_CNTL_3\0" /* 20359 */
	"SPI_PS_INPUT_CNTL_4\0" /* 20379 */
	"SPI_PS_INPUT_CNTL_5\0" /* 20399 */
	"SPI_PS_INPUT_CNTL_6\0" /* 20419 */
	"SPI_PS_INPUT_CNTL_7\0" /* 20439 */
	"SPI_PS_INPUT_CNTL_8\0" /* 20459 */
	"SPI_PS_INPUT_CNTL_9\0" /* 20479 */
	"SPI_PS_INPUT_CNTL_10\0" /* 20499 */
	"SPI_PS_INPUT_CNTL_11\0" /* 20520 */
	"SPI_PS_INPUT_CNTL_12\0" /* 20541 */
	"SPI_PS_INPUT_CNTL_13\0" /* 20562 */
	"SPI_PS_INPUT_CNTL_14\0" /* 20583 */
	"SPI_PS_INPUT_CNTL_15\0" /* 20604 */
	"SPI_PS_INPUT_CNTL_16\0" /* 20625 */
	"SPI_PS_INPUT_CNTL_17\0" /* 20646 */
	"SPI_PS_INPUT_CNTL_18\0" /* 20667 */
	"SPI_PS_INPUT_CNTL_19\0" /* 20688 */
	"SPI_PS_INPUT_CNTL_20\0" /* 20709 */
	"SPI_PS_INPUT_CNTL_21\0" /* 20730 */
	"SPI_PS_INPUT_CNTL_22\0" /* 20751 */
	"SPI_PS_INPUT_CNTL_23\0" /* 20772 */
	"SPI_PS_INPUT_CNTL_24\0" /* 20793 */
	"SPI_PS_INPUT_CNTL_25\0" /* 20814 */
	"SPI_PS_INPUT_CNTL_26\0" /* 20835 */
	"SPI_PS_INPUT_CNTL_27\0" /* 20856 */
	"SPI_PS_INPUT_CNTL_28\0" /* 20877 */
	"SPI_PS_INPUT_CNTL_29\0" /* 20898 */
	"SPI_PS_INPUT_CNTL_30\0" /* 20919 */
	"SPI_PS_INPUT_CNTL_31\0" /* 20940 */
	"SPI_VS_OUT_CONFIG\0" /* 20961 */
	"SPI_PS_INPUT_ENA\0" /* 20979 */
	"SPI_PS_INPUT_ADDR\0" /* 20996 */
	"SPI_INTERP_CONTROL_0\0" /* 21014 */
	"SPI_PS_IN_CONTROL\0" /* 21035 */
	"SPI_BARYC_CNTL\0" /* 21053 */
	"SPI_TMPRING_SIZE\0" /* 21068 */
	"SPI_WAVE_MGMT_1\0" /* 21085 */
	"SPI_WAVE_MGMT_2\0" /* 21101 */
	"SPI_SHADER_POS_FORMAT\0" /* 21117, 21132 */
	"SPI_SHADER_Z_FORMAT\0" /* 21139 */
	"SPI_SHADER_COL_FORMAT\0" /* 21159 */
	"SX_PS_DOWNCONVERT\0" /* 21181 */
	"SX_BLEND_OPT_EPSILON\0" /* 21199 */
	"SX_BLEND_OPT_CONTROL\0" /* 21220 */
	"SX_MRT0_BLEND_OPT\0" /* 21241 */
	"SX_MRT1_BLEND_OPT\0" /* 21259 */
	"SX_MRT2_BLEND_OPT\0" /* 21277 */
	"SX_MRT3_BLEND_OPT\0" /* 21295 */
	"SX_MRT4_BLEND_OPT\0" /* 21313 */
	"SX_MRT5_BLEND_OPT\0" /* 21331 */
	"SX_MRT6_BLEND_OPT\0" /* 21349 */
	"SX_MRT7_BLEND_OPT\0" /* 21367 */
	"CB_BLEND0_CONTROL\0" /* 21385 */
	"CB_BLEND1_CONTROL\0" /* 21403 */
	"CB_BLEND2_CONTROL\0" /* 21421 */
	"CB_BLEND3_CONTROL\0" /* 21439 */
	"CB_BLEND4_CONTROL\0" /* 21457 */
	"CB_BLEND5_CONTROL\0" /* 21475 */
	"CB_BLEND6_CONTROL\0" /* 21493 */
	"CB_BLEND7_CONTROL\0" /* 21511 */
	"CS_COPY_STATE\0" /* 21529 */
	"PA_CL_POINT_X_RAD\0" /* 21543 */
	"PA_CL_POINT_Y_RAD\0" /* 21561 */
	"PA_CL_POINT_SIZE\0" /* 21579 */
	"PA_CL_POINT_CULL_RAD\0" /* 21596 */
	"VGT_DMA_BASE_HI\0" /* 21617 */
	"VGT_DMA_BASE\0" /* 21633 */
	"VGT_DRAW_INITIATOR\0" /* 21646 */
	"VGT_IMMED_DATA\0" /* 21665 */
	"VGT_EVENT_ADDRESS_REG\0" /* 21680 */
	"DB_DEPTH_CONTROL\0" /* 21702 */
	"DB_EQAA\0" /* 21719 */
	"CB_COLOR_CONTROL\0" /* 21727 */
	"DB_SHADER_CONTROL\0" /* 21744 */
	"PA_CL_CLIP_CNTL\0" /* 21762 */
	"PA_SU_SC_MODE_CNTL\0" /* 21778 */
	"PA_CL_VTE_CNTL\0" /* 21797 */
	"PA_CL_VS_OUT_CNTL\0" /* 21812 */
	"PA_CL_NANINF_CNTL\0" /* 21830 */
	"PA_SU_LINE_STIPPLE_CNTL\0" /* 21848 */
	"PA_SU_LINE_STIPPLE_SCALE\0" /* 21872 */
	"PA_SU_PRIM_FILTER_CNTL\0" /* 21897 */
	"PA_SU_SMALL_PRIM_FILTER_CNTL\0" /* 21920 */
	"PA_SU_POINT_SIZE\0" /* 21949 */
	"PA_SU_POINT_MINMAX\0" /* 21966 */
	"PA_SU_LINE_CNTL\0" /* 21985 */
	"PA_SC_LINE_STIPPLE\0" /* 22001 */
	"VGT_OUTPUT_PATH_CNTL\0" /* 22020 */
	"VGT_HOS_CNTL\0" /* 22041 */
	"VGT_HOS_MAX_TESS_LEVEL\0" /* 22054 */
	"VGT_HOS_MIN_TESS_LEVEL\0" /* 22077 */
	"VGT_HOS_REUSE_DEPTH\0" /* 22100, 22108, 22114 */
	"VGT_GROUP_PRIM_TYPE\0" /* 22120, 22130 */
	"VGT_GROUP_FIRST_DECR\0" /* 22140, 22150, 22156 */
	"VGT_GROUP_DECR\0" /* 22161 */
	"VGT_GROUP_VECT_0_CNTL\0" /* 22176 */
	"VGT_GROUP_VECT_1_CNTL\0" /* 22198 */
	"VGT_GROUP_VECT_0_FMT_CNTL\0" /* 22220 */
	"VGT_GROUP_VECT_1_FMT_CNTL\0" /* 22246 */
	"VGT_GS_MODE\0" /* 22272, 22279 */
	"VGT_GS_ONCHIP_CNTL\0" /* 22284 */
	"PA_SC_MODE_CNTL_0\0" /* 22303 */
	"PA_SC_MODE_CNTL_1\0" /* 22321 */
	"VGT_ENHANCE\0" /* 22339 */
	"VGT_GS_PER_ES\0" /* 22351, 22355 */
	"VGT_ES_PER_GS\0" /* 22365, 22369 */
	"VGT_GS_PER_VS\0" /* 22379, 22383 */
	"VGT_GSVS_RING_OFFSET_1\0" /* 22393 */
	"VGT_GSVS_RING_OFFSET_2\0" /* 22416 */
	"VGT_GSVS_RING_OFFSET_3\0" /* 22439 */
	"VGT_GS_OUT_PRIM_TYPE\0" /* 22462 */
	"IA_ENHANCE\0" /* 22483 */
	"VGT_DMA_SIZE\0" /* 22494 */
	"VGT_DMA_MAX_SIZE\0" /* 22507, 22515 */
	"VGT_DMA_INDEX_TYPE\0" /* 22524 */
	"WD_ENHANCE\0" /* 22543 */
	"VGT_PRIMITIVEID_EN\0" /* 22554, 22558 */
	"VGT_DMA_NUM_INSTANCES\0" /* 22573 */
	"VGT_PRIMITIVEID_RESET\0" /* 22595 */
	"VGT_EVENT_INITIATOR\0" /* 22617 */
	"VGT_MULTI_PRIM_IB_RESET_EN\0" /* 22637, 22655 */
	"VGT_INSTANCE_STEP_RATE_0\0" /* 22664 */
	"VGT_INSTANCE_STEP_RATE_1\0" /* 22689 */
	"IA_MULTI_VGT_PARAM\0" /* 22714 */
	"VGT_ESGS_RING_ITEMSIZE\0" /* 22733, 22747 */
	"VGT_GSVS_RING_ITEMSIZE\0" /* 22756 */
	"VGT_REUSE_OFF\0" /* 22779, 22783 */
	"VGT_VTX_CNT_EN\0" /* 22793, 22797 */
	"DB_HTILE_SURFACE\0" /* 22808, 22820 */
	"DB_SRESULTS_COMPARE_STATE0\0" /* 22825 */
	"DB_SRESULTS_COMPARE_STATE1\0" /* 22852 */
	"DB_PRELOAD_CONTROL\0" /* 22879 */
	"VGT_STRMOUT_BUFFER_SIZE_0\0" /* 22898 */
	"VGT_STRMOUT_VTX_STRIDE_0\0" /* 22924 */
	"VGT_STRMOUT_BUFFER_OFFSET_0\0" /* 22949 */
	"VGT_STRMOUT_BUFFER_SIZE_1\0" /* 22977 */
	"VGT_STRMOUT_VTX_STRIDE_1\0" /* 23003 */
	"VGT_STRMOUT_BUFFER_OFFSET_1\0" /* 23028 */
	"VGT_STRMOUT_BUFFER_SIZE_2\0" /* 23056 */
	"VGT_STRMOUT_VTX_STRIDE_2\0" /* 23082 */
	"VGT_STRMOUT_BUFFER_OFFSET_2\0" /* 23107 */
	"VGT_STRMOUT_BUFFER_SIZE_3\0" /* 23135 */
	"VGT_STRMOUT_VTX_STRIDE_3\0" /* 23161 */
	"VGT_STRMOUT_BUFFER_OFFSET_3\0" /* 23186 */
	"VGT_STRMOUT_DRAW_OPAQUE_OFFSET\0" /* 23214 */
	"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE\0" /* 23245 */
	"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE\0" /* 23288, 23312, 23319 */
	"VGT_GS_MAX_VERT_OUT\0" /* 23326, 23333 */
	"VGT_TESS_DISTRIBUTION\0" /* 23346 */
	"VGT_SHADER_STAGES_EN\0" /* 23368, 23383 */
	"VGT_LS_HS_CONFIG\0" /* 23389 */
	"VGT_GS_VERT_ITEMSIZE\0" /* 23406 */
	"VGT_GS_VERT_ITEMSIZE_1\0" /* 23427 */
	"VGT_GS_VERT_ITEMSIZE_2\0" /* 23450 */
	"VGT_GS_VERT_ITEMSIZE_3\0" /* 23473 */
	"VGT_TF_PARAM\0" /* 23496 */
	"DB_ALPHA_TO_MASK\0" /* 23509 */
	"VGT_DISPATCH_DRAW_INDEX\0" /* 23526 */
	"PA_SU_POLY_OFFSET_DB_FMT_CNTL\0" /* 23550 */
	"PA_SU_POLY_OFFSET_CLAMP\0" /* 23580 */
	"PA_SU_POLY_OFFSET_FRONT_SCALE\0" /* 23604 */
	"PA_SU_POLY_OFFSET_FRONT_OFFSET\0" /* 23634 */
	"PA_SU_POLY_OFFSET_BACK_SCALE\0" /* 23665 */
	"PA_SU_POLY_OFFSET_BACK_OFFSET\0" /* 23694 */
	"VGT_GS_INSTANCE_CNT\0" /* 23724, 23740 */
	"VGT_STRMOUT_CONFIG\0" /* 23744 */
	"VGT_STRMOUT_BUFFER_CONFIG\0" /* 23763 */
	"PA_SC_CENTROID_PRIORITY_0\0" /* 23789 */
	"PA_SC_CENTROID_PRIORITY_1\0" /* 23815 */
	"PA_SC_LINE_CNTL\0" /* 23841 */
	"PA_SC_AA_CONFIG\0" /* 23857 */
	"PA_SU_VTX_CNTL\0" /* 23873 */
	"PA_CL_GB_VERT_CLIP_ADJ\0" /* 23888 */
	"PA_CL_GB_VERT_DISC_ADJ\0" /* 23911 */
	"PA_CL_GB_HORZ_CLIP_ADJ\0" /* 23934 */
	"PA_CL_GB_HORZ_DISC_ADJ\0" /* 23957 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0\0" /* 23980 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1\0" /* 24014 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2\0" /* 24048 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3\0" /* 24082 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0\0" /* 24116 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1\0" /* 24150 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2\0" /* 24184 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3\0" /* 24218 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0\0" /* 24252 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1\0" /* 24286 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2\0" /* 24320 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3\0" /* 24354 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0\0" /* 24388 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1\0" /* 24422 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2\0" /* 24456 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3\0" /* 24490 */
	"PA_SC_AA_MASK_X0Y0_X1Y0\0" /* 24524 */
	"PA_SC_AA_MASK_X0Y1_X1Y1\0" /* 24548 */
	"PA_SC_SHADER_CONTROL\0" /* 24572 */
	"VGT_VERTEX_REUSE_BLOCK_CNTL\0" /* 24593 */
	"VGT_OUT_DEALLOC_CNTL\0" /* 24621 */
	"CB_COLOR0_BASE\0" /* 24642 */
	"CB_COLOR0_PITCH\0" /* 24657 */
	"CB_COLOR0_SLICE\0" /* 24673 */
	"CB_COLOR0_VIEW\0" /* 24689 */
	"CB_COLOR0_INFO\0" /* 24704 */
	"CB_COLOR0_ATTRIB\0" /* 24719 */
	"CB_COLOR0_DCC_CONTROL\0" /* 24736 */
	"CB_COLOR0_CMASK\0" /* 24758 */
	"CB_COLOR0_CMASK_SLICE\0" /* 24774 */
	"CB_COLOR0_FMASK\0" /* 24796 */
	"CB_COLOR0_FMASK_SLICE\0" /* 24812 */
	"CB_COLOR0_CLEAR_WORD0\0" /* 24834 */
	"CB_COLOR0_CLEAR_WORD1\0" /* 24856 */
	"CB_COLOR0_DCC_BASE\0" /* 24878 */
	"CB_COLOR1_BASE\0" /* 24897 */
	"CB_COLOR1_PITCH\0" /* 24912 */
	"CB_COLOR1_SLICE\0" /* 24928 */
	"CB_COLOR1_VIEW\0" /* 24944 */
	"CB_COLOR1_INFO\0" /* 24959 */
	"CB_COLOR1_ATTRIB\0" /* 24974 */
	"CB_COLOR1_DCC_CONTROL\0" /* 24991 */
	"CB_COLOR1_CMASK\0" /* 25013 */
	"CB_COLOR1_CMASK_SLICE\0" /* 25029 */
	"CB_COLOR1_FMASK\0" /* 25051 */
	"CB_COLOR1_FMASK_SLICE\0" /* 25067 */
	"CB_COLOR1_CLEAR_WORD0\0" /* 25089 */
	"CB_COLOR1_CLEAR_WORD1\0" /* 25111 */
	"CB_COLOR1_DCC_BASE\0" /* 25133 */
	"CB_COLOR2_BASE\0" /* 25152 */
	"CB_COLOR2_PITCH\0" /* 25167 */
	"CB_COLOR2_SLICE\0" /* 25183 */
	"CB_COLOR2_VIEW\0" /* 25199 */
	"CB_COLOR2_INFO\0" /* 25214 */
	"CB_COLOR2_ATTRIB\0" /* 25229 */
	"CB_COLOR2_DCC_CONTROL\0" /* 25246 */
	"CB_COLOR2_CMASK\0" /* 25268 */
	"CB_COLOR2_CMASK_SLICE\0" /* 25284 */
	"CB_COLOR2_FMASK\0" /* 25306 */
	"CB_COLOR2_FMASK_SLICE\0" /* 25322 */
	"CB_COLOR2_CLEAR_WORD0\0" /* 25344 */
	"CB_COLOR2_CLEAR_WORD1\0" /* 25366 */
	"CB_COLOR2_DCC_BASE\0" /* 25388 */
	"CB_COLOR3_BASE\0" /* 25407 */
	"CB_COLOR3_PITCH\0" /* 25422 */
	"CB_COLOR3_SLICE\0" /* 25438 */
	"CB_COLOR3_VIEW\0" /* 25454 */
	"CB_COLOR3_INFO\0" /* 25469 */
	"CB_COLOR3_ATTRIB\0" /* 25484 */
	"CB_COLOR3_DCC_CONTROL\0" /* 25501 */
	"CB_COLOR3_CMASK\0" /* 25523 */
	"CB_COLOR3_CMASK_SLICE\0" /* 25539 */
	"CB_COLOR3_FMASK\0" /* 25561 */
	"CB_COLOR3_FMASK_SLICE\0" /* 25577 */
	"CB_COLOR3_CLEAR_WORD0\0" /* 25599 */
	"CB_COLOR3_CLEAR_WORD1\0" /* 25621 */
	"CB_COLOR3_DCC_BASE\0" /* 25643 */
	"CB_COLOR4_BASE\0" /* 25662 */
	"CB_COLOR4_PITCH\0" /* 25677 */
	"CB_COLOR4_SLICE\0" /* 25693 */
	"CB_COLOR4_VIEW\0" /* 25709 */
	"CB_COLOR4_INFO\0" /* 25724 */
	"CB_COLOR4_ATTRIB\0" /* 25739 */
	"CB_COLOR4_DCC_CONTROL\0" /* 25756 */
	"CB_COLOR4_CMASK\0" /* 25778 */
	"CB_COLOR4_CMASK_SLICE\0" /* 25794 */
	"CB_COLOR4_FMASK\0" /* 25816 */
	"CB_COLOR4_FMASK_SLICE\0" /* 25832 */
	"CB_COLOR4_CLEAR_WORD0\0" /* 25854 */
	"CB_COLOR4_CLEAR_WORD1\0" /* 25876 */
	"CB_COLOR4_DCC_BASE\0" /* 25898 */
	"CB_COLOR5_BASE\0" /* 25917 */
	"CB_COLOR5_PITCH\0" /* 25932 */
	"CB_COLOR5_SLICE\0" /* 25948 */
	"CB_COLOR5_VIEW\0" /* 25964 */
	"CB_COLOR5_INFO\0" /* 25979 */
	"CB_COLOR5_ATTRIB\0" /* 25994 */
	"CB_COLOR5_DCC_CONTROL\0" /* 26011 */
	"CB_COLOR5_CMASK\0" /* 26033 */
	"CB_COLOR5_CMASK_SLICE\0" /* 26049 */
	"CB_COLOR5_FMASK\0" /* 26071 */
	"CB_COLOR5_FMASK_SLICE\0" /* 26087 */
	"CB_COLOR5_CLEAR_WORD0\0" /* 26109 */
	"CB_COLOR5_CLEAR_WORD1\0" /* 26131 */
	"CB_COLOR5_DCC_BASE\0" /* 26153 */
	"CB_COLOR6_BASE\0" /* 26172 */
	"CB_COLOR6_PITCH\0" /* 26187 */
	"CB_COLOR6_SLICE\0" /* 26203 */
	"CB_COLOR6_VIEW\0" /* 26219 */
	"CB_COLOR6_INFO\0" /* 26234 */
	"CB_COLOR6_ATTRIB\0" /* 26249 */
	"CB_COLOR6_DCC_CONTROL\0" /* 26266 */
	"CB_COLOR6_CMASK\0" /* 26288 */
	"CB_COLOR6_CMASK_SLICE\0" /* 26304 */
	"CB_COLOR6_FMASK\0" /* 26326 */
	"CB_COLOR6_FMASK_SLICE\0" /* 26342 */
	"CB_COLOR6_CLEAR_WORD0\0" /* 26364 */
	"CB_COLOR6_CLEAR_WORD1\0" /* 26386 */
	"CB_COLOR6_DCC_BASE\0" /* 26408 */
	"CB_COLOR7_BASE\0" /* 26427 */
	"CB_COLOR7_PITCH\0" /* 26442 */
	"CB_COLOR7_SLICE\0" /* 26458 */
	"CB_COLOR7_VIEW\0" /* 26474 */
	"CB_COLOR7_INFO\0" /* 26489 */
	"CB_COLOR7_ATTRIB\0" /* 26504 */
	"CB_COLOR7_DCC_CONTROL\0" /* 26521 */
	"CB_COLOR7_CMASK\0" /* 26543 */
	"CB_COLOR7_CMASK_SLICE\0" /* 26559 */
	"CB_COLOR7_FMASK\0" /* 26581 */
	"CB_COLOR7_FMASK_SLICE\0" /* 26597 */
	"CB_COLOR7_CLEAR_WORD0\0" /* 26619 */
	"CB_COLOR7_CLEAR_WORD1\0" /* 26641 */
	"CB_COLOR7_DCC_BASE\0" /* 26663 */
	"VGT_TF_MEMORY_BASE_HI\0" /* 26682 */
	"WD_POS_BUF_BASE\0" /* 26704 */
	"WD_POS_BUF_BASE_HI\0" /* 26720 */
	"WD_CNTL_SB_BUF_BASE\0" /* 26739 */
	"WD_CNTL_SB_BUF_BASE_HI\0" /* 26759 */
	"WD_INDEX_BUF_BASE\0" /* 26782 */
	"WD_INDEX_BUF_BASE_HI\0" /* 26800 */
	"VGT_INSTANCE_BASE_ID\0" /* 26821 */
	"SQC_WRITEBACK\0" /* 26842, 26846 */
	"SPI_CONFIG_CNTL_2\0" /* 26856 */
	"SPI_SHADER_USER_DATA_PS_16\0" /* 26874 */
	"SPI_SHADER_USER_DATA_PS_17\0" /* 26901 */
	"SPI_SHADER_USER_DATA_PS_18\0" /* 26928 */
	"SPI_SHADER_USER_DATA_PS_19\0" /* 26955 */
	"SPI_SHADER_USER_DATA_PS_20\0" /* 26982 */
	"SPI_SHADER_USER_DATA_PS_21\0" /* 27009 */
	"SPI_SHADER_USER_DATA_PS_22\0" /* 27036 */
	"SPI_SHADER_USER_DATA_PS_23\0" /* 27063 */
	"SPI_SHADER_USER_DATA_PS_24\0" /* 27090 */
	"SPI_SHADER_USER_DATA_PS_25\0" /* 27117 */
	"SPI_SHADER_USER_DATA_PS_26\0" /* 27144 */
	"SPI_SHADER_USER_DATA_PS_27\0" /* 27171 */
	"SPI_SHADER_USER_DATA_PS_28\0" /* 27198 */
	"SPI_SHADER_USER_DATA_PS_29\0" /* 27225 */
	"SPI_SHADER_USER_DATA_PS_30\0" /* 27252 */
	"SPI_SHADER_USER_DATA_PS_31\0" /* 27279 */
	"SPI_SHADER_USER_DATA_VS_16\0" /* 27306 */
	"SPI_SHADER_USER_DATA_VS_17\0" /* 27333 */
	"SPI_SHADER_USER_DATA_VS_18\0" /* 27360 */
	"SPI_SHADER_USER_DATA_VS_19\0" /* 27387 */
	"SPI_SHADER_USER_DATA_VS_20\0" /* 27414 */
	"SPI_SHADER_USER_DATA_VS_21\0" /* 27441 */
	"SPI_SHADER_USER_DATA_VS_22\0" /* 27468 */
	"SPI_SHADER_USER_DATA_VS_23\0" /* 27495 */
	"SPI_SHADER_USER_DATA_VS_24\0" /* 27522 */
	"SPI_SHADER_USER_DATA_VS_25\0" /* 27549 */
	"SPI_SHADER_USER_DATA_VS_26\0" /* 27576 */
	"SPI_SHADER_USER_DATA_VS_27\0" /* 27603 */
	"SPI_SHADER_USER_DATA_VS_28\0" /* 27630 */
	"SPI_SHADER_USER_DATA_VS_29\0" /* 27657 */
	"SPI_SHADER_USER_DATA_VS_30\0" /* 27684 */
	"SPI_SHADER_USER_DATA_VS_31\0" /* 27711 */
	"SPI_SHADER_PGM_RSRC2_GS_VS\0" /* 27738 */
	"SPI_SHADER_PGM_RSRC4_GS\0" /* 27765 */
	"SPI_SHADER_USER_DATA_ADDR_LO_GS\0" /* 27789 */
	"SPI_SHADER_USER_DATA_ADDR_HI_GS\0" /* 27821 */
	"SPI_SHADER_USER_DATA_ES_16\0" /* 27853 */
	"SPI_SHADER_USER_DATA_ES_17\0" /* 27880 */
	"SPI_SHADER_USER_DATA_ES_18\0" /* 27907 */
	"SPI_SHADER_USER_DATA_ES_19\0" /* 27934 */
	"SPI_SHADER_USER_DATA_ES_20\0" /* 27961 */
	"SPI_SHADER_USER_DATA_ES_21\0" /* 27988 */
	"SPI_SHADER_USER_DATA_ES_22\0" /* 28015 */
	"SPI_SHADER_USER_DATA_ES_23\0" /* 28042 */
	"SPI_SHADER_USER_DATA_ES_24\0" /* 28069 */
	"SPI_SHADER_USER_DATA_ES_25\0" /* 28096 */
	"SPI_SHADER_USER_DATA_ES_26\0" /* 28123 */
	"SPI_SHADER_USER_DATA_ES_27\0" /* 28150 */
	"SPI_SHADER_USER_DATA_ES_28\0" /* 28177 */
	"SPI_SHADER_USER_DATA_ES_29\0" /* 28204 */
	"SPI_SHADER_USER_DATA_ES_30\0" /* 28231 */
	"SPI_SHADER_USER_DATA_ES_31\0" /* 28258 */
	"SPI_SHADER_PGM_RSRC4_HS\0" /* 28285 */
	"SPI_SHADER_USER_DATA_ADDR_LO_HS\0" /* 28309 */
	"SPI_SHADER_USER_DATA_ADDR_HI_HS\0" /* 28341 */
	"SPI_SHADER_USER_DATA_LS_16\0" /* 28373 */
	"SPI_SHADER_USER_DATA_LS_17\0" /* 28400 */
	"SPI_SHADER_USER_DATA_LS_18\0" /* 28427 */
	"SPI_SHADER_USER_DATA_LS_19\0" /* 28454 */
	"SPI_SHADER_USER_DATA_LS_20\0" /* 28481 */
	"SPI_SHADER_USER_DATA_LS_21\0" /* 28508 */
	"SPI_SHADER_USER_DATA_LS_22\0" /* 28535 */
	"SPI_SHADER_USER_DATA_LS_23\0" /* 28562 */
	"SPI_SHADER_USER_DATA_LS_24\0" /* 28589 */
	"SPI_SHADER_USER_DATA_LS_25\0" /* 28616 */
	"SPI_SHADER_USER_DATA_LS_26\0" /* 28643 */
	"SPI_SHADER_USER_DATA_LS_27\0" /* 28670 */
	"SPI_SHADER_USER_DATA_LS_28\0" /* 28697 */
	"SPI_SHADER_USER_DATA_LS_29\0" /* 28724 */
	"SPI_SHADER_USER_DATA_LS_30\0" /* 28751 */
	"SPI_SHADER_USER_DATA_LS_31\0" /* 28778 */
	"SPI_SHADER_USER_DATA_COMMON_0\0" /* 28805 */
	"SPI_SHADER_USER_DATA_COMMON_1\0" /* 28835 */
	"SPI_SHADER_USER_DATA_COMMON_2\0" /* 28865 */
	"SPI_SHADER_USER_DATA_COMMON_3\0" /* 28895 */
	"SPI_SHADER_USER_DATA_COMMON_4\0" /* 28925 */
	"SPI_SHADER_USER_DATA_COMMON_5\0" /* 28955 */
	"SPI_SHADER_USER_DATA_COMMON_6\0" /* 28985 */
	"SPI_SHADER_USER_DATA_COMMON_7\0" /* 29015 */
	"SPI_SHADER_USER_DATA_COMMON_8\0" /* 29045 */
	"SPI_SHADER_USER_DATA_COMMON_9\0" /* 29075 */
	"SPI_SHADER_USER_DATA_COMMON_10\0" /* 29105 */
	"SPI_SHADER_USER_DATA_COMMON_11\0" /* 29136 */
	"SPI_SHADER_USER_DATA_COMMON_12\0" /* 29167 */
	"SPI_SHADER_USER_DATA_COMMON_13\0" /* 29198 */
	"SPI_SHADER_USER_DATA_COMMON_14\0" /* 29229 */
	"SPI_SHADER_USER_DATA_COMMON_15\0" /* 29260 */
	"SPI_SHADER_USER_DATA_COMMON_16\0" /* 29291 */
	"SPI_SHADER_USER_DATA_COMMON_17\0" /* 29322 */
	"SPI_SHADER_USER_DATA_COMMON_18\0" /* 29353 */
	"SPI_SHADER_USER_DATA_COMMON_19\0" /* 29384 */
	"SPI_SHADER_USER_DATA_COMMON_20\0" /* 29415 */
	"SPI_SHADER_USER_DATA_COMMON_21\0" /* 29446 */
	"SPI_SHADER_USER_DATA_COMMON_22\0" /* 29477 */
	"SPI_SHADER_USER_DATA_COMMON_23\0" /* 29508 */
	"SPI_SHADER_USER_DATA_COMMON_24\0" /* 29539 */
	"SPI_SHADER_USER_DATA_COMMON_25\0" /* 29570 */
	"SPI_SHADER_USER_DATA_COMMON_26\0" /* 29601 */
	"SPI_SHADER_USER_DATA_COMMON_27\0" /* 29632 */
	"SPI_SHADER_USER_DATA_COMMON_28\0" /* 29663 */
	"SPI_SHADER_USER_DATA_COMMON_29\0" /* 29694 */
	"SPI_SHADER_USER_DATA_COMMON_30\0" /* 29725 */
	"SPI_SHADER_USER_DATA_COMMON_31\0" /* 29756 */
	"COMPUTE_DISPATCH_PKT_ADDR_LO\0" /* 29787 */
	"COMPUTE_DISPATCH_PKT_ADDR_HI\0" /* 29816 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_LO\0" /* 29845 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_HI\0" /* 29878 */
	"CPF_LATENCY_STATS_DATA\0" /* 29911 */
	"CPG_LATENCY_STATS_DATA\0" /* 29934 */
	"CPC_LATENCY_STATS_DATA\0" /* 29957 */
	"CPF_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 29980 */
	"CPG_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 30014 */
	"CPF_LATENCY_STATS_SELECT\0" /* 30048 */
	"CPG_LATENCY_STATS_SELECT\0" /* 30073 */
	"CPC_LATENCY_STATS_SELECT\0" /* 30098 */
	"DB_HTILE_DATA_BASE_HI\0" /* 30123 */
	"DB_Z_READ_BASE_HI\0" /* 30145 */
	"DB_STENCIL_READ_BASE_HI\0" /* 30163 */
	"DB_Z_WRITE_BASE_HI\0" /* 30187 */
	"DB_STENCIL_WRITE_BASE_HI\0" /* 30206 */
	"DB_DFSM_CONTROL\0" /* 30231 */
	"DB_Z_INFO2\0" /* 30247 */
	"DB_STENCIL_INFO2\0" /* 30258 */
	"PA_SC_TILE_STEERING_OVERRIDE\0" /* 30275 */
	"CP_PERFMON_CNTX_CNTL\0" /* 30304 */
	"PA_SC_RIGHT_VERT_GRID\0" /* 30325 */
	"PA_SC_LEFT_VERT_GRID\0" /* 30347 */
	"PA_SC_HORIZ_GRID\0" /* 30368 */
	"CB_MRT0_EPITCH\0" /* 30385, 30393 */
	"CB_MRT1_EPITCH\0" /* 30400 */
	"CB_MRT2_EPITCH\0" /* 30415 */
	"CB_MRT3_EPITCH\0" /* 30430 */
	"CB_MRT4_EPITCH\0" /* 30445 */
	"CB_MRT5_EPITCH\0" /* 30460 */
	"CB_MRT6_EPITCH\0" /* 30475 */
	"CB_MRT7_EPITCH\0" /* 30490 */
	"PA_CL_OBJPRIM_ID_CNTL\0" /* 30505 */
	"PA_CL_NGG_CNTL\0" /* 30527 */
	"PA_SU_OVER_RASTERIZATION_CNTL\0" /* 30542 */
	"PA_STEREO_CNTL\0" /* 30572 */
	"VGT_GS_MAX_PRIMS_PER_SUBGROUP\0" /* 30587, 30594 */
	"VGT_DRAW_PAYLOAD_CNTL\0" /* 30617 */
	"VGT_DMA_EVENT_INITIATOR\0" /* 30639 */
	"PA_SC_BINNER_CNTL_0\0" /* 30663 */
	"PA_SC_BINNER_CNTL_1\0" /* 30683 */
	"PA_SC_CONSERVATIVE_RASTERIZATION_CNTL\0" /* 30703 */
	"PA_SC_NGG_MODE_CNTL\0" /* 30741 */
	"CB_COLOR0_BASE_EXT\0" /* 30761 */
	"CB_COLOR0_ATTRIB2\0" /* 30780 */
	"CB_COLOR0_CMASK_BASE_EXT\0" /* 30798 */
	"CB_COLOR0_FMASK_BASE_EXT\0" /* 30823 */
	"CB_COLOR0_DCC_BASE_EXT\0" /* 30848 */
	"CB_COLOR1_BASE_EXT\0" /* 30871 */
	"CB_COLOR1_ATTRIB2\0" /* 30890 */
	"CB_COLOR1_CMASK_BASE_EXT\0" /* 30908 */
	"CB_COLOR1_FMASK_BASE_EXT\0" /* 30933 */
	"CB_COLOR1_DCC_BASE_EXT\0" /* 30958 */
	"CB_COLOR2_BASE_EXT\0" /* 30981 */
	"CB_COLOR2_ATTRIB2\0" /* 31000 */
	"CB_COLOR2_CMASK_BASE_EXT\0" /* 31018 */
	"CB_COLOR2_FMASK_BASE_EXT\0" /* 31043 */
	"CB_COLOR2_DCC_BASE_EXT\0" /* 31068 */
	"CB_COLOR3_BASE_EXT\0" /* 31091 */
	"CB_COLOR3_ATTRIB2\0" /* 31110 */
	"CB_COLOR3_CMASK_BASE_EXT\0" /* 31128 */
	"CB_COLOR3_FMASK_BASE_EXT\0" /* 31153 */
	"CB_COLOR3_DCC_BASE_EXT\0" /* 31178 */
	"CB_COLOR4_BASE_EXT\0" /* 31201 */
	"CB_COLOR4_ATTRIB2\0" /* 31220 */
	"CB_COLOR4_CMASK_BASE_EXT\0" /* 31238 */
	"CB_COLOR4_FMASK_BASE_EXT\0" /* 31263 */
	"CB_COLOR4_DCC_BASE_EXT\0" /* 31288 */
	"CB_COLOR5_BASE_EXT\0" /* 31311 */
	"CB_COLOR5_ATTRIB2\0" /* 31330 */
	"CB_COLOR5_CMASK_BASE_EXT\0" /* 31348 */
	"CB_COLOR5_FMASK_BASE_EXT\0" /* 31373 */
	"CB_COLOR5_DCC_BASE_EXT\0" /* 31398 */
	"CB_COLOR6_BASE_EXT\0" /* 31421 */
	"CB_COLOR6_ATTRIB2\0" /* 31440 */
	"CB_COLOR6_CMASK_BASE_EXT\0" /* 31458 */
	"CB_COLOR6_FMASK_BASE_EXT\0" /* 31483 */
	"CB_COLOR6_DCC_BASE_EXT\0" /* 31508 */
	"CB_COLOR7_BASE_EXT\0" /* 31531 */
	"CB_COLOR7_ATTRIB2\0" /* 31550 */
	"CB_COLOR7_CMASK_BASE_EXT\0" /* 31568 */
	"CB_COLOR7_FMASK_BASE_EXT\0" /* 31593 */
	"CB_COLOR7_DCC_BASE_EXT\0" /* 31618 */
	"COUNT_INDIRECT_ENABLE\0" /* 31641 */
	"DRAW_INDEX_ENABLE\0" /* 31663 */
	"PFP\0" /* 31681 */
	"ENGINE_SEL\0" /* 31685 */
	"WR_CONFIRM\0" /* 31696 */
	"WR_ONE_ADDR\0" /* 31707 */
	"MEM_MAPPED_REGISTER\0" /* 31719, 31730 */
	"MEMORY_SYNC\0" /* 31739 */
	"TC_L2\0" /* 31751 */
	"GDS\0" /* 31757 */
	"MEM_ASYNC\0" /* 31761 */
	"DST_SEL\0" /* 31771 */
	"IB_SIZE\0" /* 31779 */
	"CHAIN\0" /* 31787 */
	"VALID\0" /* 31793 */
	"CP_SYNC\0" /* 31799 */
	"SRC_ADDR\0" /* 31807 */
	"SRC_ADDR_TC_L2\0" /* 31816 */
	"SRC_SEL\0" /* 31831 */
	"ENGINE\0" /* 31839 */
	"DST_ADDR\0" /* 31846 */
	"DST_ADDR_TC_L2\0" /* 31855 */
	"BYTE_COUNT_GFX6\0" /* 31870 */
	"BYTE_COUNT_GFX9\0" /* 31886 */
	"DISABLE_WR_CONFIRM_GFX6\0" /* 31902 */
	"NONE\0" /* 31926 */
	"8_IN_16\0" /* 31931 */
	"8_IN_32\0" /* 31939 */
	"8_IN_64\0" /* 31947 */
	"SRC_SWAP\0" /* 31955 */
	"DST_SWAP\0" /* 31964 */
	"MEMORY\0" /* 31973 */
	"SAS\0" /* 31980 */
	"DAS\0" /* 31984 */
	"INCREMENT\0" /* 31988 */
	"NO_INCREMENT\0" /* 31998 */
	"SAIC\0" /* 32011 */
	"DAIC\0" /* 32016 */
	"RAW_WAIT\0" /* 32021 */
	"DISABLE_WR_CONFIRM_GFX9\0" /* 32030 */
	"SDMA_RQ_PENDING\0" /* 32054 */
	"TST_RQ_PENDING\0" /* 32070 */
	"SDMA1_RQ_PENDING\0" /* 32085 */
	"VCE0_RQ_PENDING\0" /* 32102 */
	"VP8_BUSY\0" /* 32118 */
	"SDMA_BUSY\0" /* 32127, 32128 */
	"SDMA1_BUSY\0" /* 32137 */
	"VCE0_BUSY\0" /* 32148 */
	"XDMA_BUSY\0" /* 32158 */
	"CHUB_BUSY\0" /* 32168 */
	"SDMA2_BUSY\0" /* 32178 */
	"SDMA3_BUSY\0" /* 32189 */
	"SAMSCP_BUSY\0" /* 32200, 32204 */
	"ISP_BUSY\0" /* 32212 */
	"VCE1_BUSY\0" /* 32221 */
	"ODE_BUSY\0" /* 32231 */
	"SDMA2_RQ_PENDING\0" /* 32240 */
	"SDMA3_RQ_PENDING\0" /* 32257 */
	"SAMSCP_RQ_PENDING\0" /* 32274 */
	"ISP_RQ_PENDING\0" /* 32292 */
	"VCE1_RQ_PENDING\0" /* 32307 */
	"UVD_RQ_PENDING\0" /* 32323 */
	"SAMMSP_RQ_PENDING\0" /* 32338 */
	"ACP_RQ_PENDING\0" /* 32356 */
	"SMU_RQ_PENDING\0" /* 32371 */
	"GRBM_RQ_PENDING\0" /* 32386 */
	"HI_RQ_PENDING\0" /* 32402 */
	"VMC_BUSY\0" /* 32416 */
	"MCB_BUSY\0" /* 32425, 32426 */
	"MCB_NON_DISPLAY_BUSY\0" /* 32434 */
	"MCC_BUSY\0" /* 32455 */
	"MCD_BUSY\0" /* 32464 */
	"VMC1_BUSY\0" /* 32473 */
	"SEM_BUSY\0" /* 32483 */
	"ACP_BUSY\0" /* 32492 */
	"IH_BUSY\0" /* 32501 */
	"UVD_BUSY\0" /* 32509 */
	"SAMMSP_BUSY\0" /* 32518 */
	"GCATCL2_BUSY\0" /* 32530 */
	"OSATCL2_BUSY\0" /* 32543 */
	"BIF_BUSY\0" /* 32556 */
	"MCC0_BUSY\0" /* 32565 */
	"MCC1_BUSY\0" /* 32575 */
	"MCC2_BUSY\0" /* 32585 */
	"MCC3_BUSY\0" /* 32595 */
	"MCC4_BUSY\0" /* 32605 */
	"MCC5_BUSY\0" /* 32615 */
	"MCC6_BUSY\0" /* 32625 */
	"MCC7_BUSY\0" /* 32635 */
	"MCD0_BUSY\0" /* 32645 */
	"MCD1_BUSY\0" /* 32655 */
	"MCD2_BUSY\0" /* 32665 */
	"MCD3_BUSY\0" /* 32675 */
	"MCD4_BUSY\0" /* 32685 */
	"MCD5_BUSY\0" /* 32695 */
	"MCD6_BUSY\0" /* 32705 */
	"MCD7_BUSY\0" /* 32715 */
	"IDLE\0" /* 32725 */
	"REG_IDLE\0" /* 32730 */
	"RB_EMPTY\0" /* 32739 */
	"RB_FULL\0" /* 32748 */
	"RB_CMD_IDLE\0" /* 32756 */
	"RB_CMD_FULL\0" /* 32768 */
	"IB_CMD_IDLE\0" /* 32780 */
	"IB_CMD_FULL\0" /* 32792 */
	"BLOCK_IDLE\0" /* 32804 */
	"INSIDE_IB\0" /* 32815 */
	"EX_IDLE\0" /* 32825 */
	"EX_IDLE_POLL_TIMER_EXPIRE\0" /* 32833 */
	"PACKET_READY\0" /* 32859 */
	"MC_WR_IDLE\0" /* 32872 */
	"SRBM_IDLE\0" /* 32883 */
	"CONTEXT_EMPTY\0" /* 32893 */
	"DELTA_RPTR_FULL\0" /* 32907 */
	"RB_MC_RREQ_IDLE\0" /* 32923 */
	"IB_MC_RREQ_IDLE\0" /* 32939 */
	"MC_RD_IDLE\0" /* 32955 */
	"DELTA_RPTR_EMPTY\0" /* 32966 */
	"MC_RD_RET_STALL\0" /* 32983 */
	"MC_RD_NO_POLL_IDLE\0" /* 32999 */
	"PREV_CMD_IDLE\0" /* 33018 */
	"SEM_IDLE\0" /* 33032 */
	"SEM_REQ_STALL\0" /* 33041 */
	"SEM_RESP_STATE\0" /* 33055 */
	"INT_IDLE\0" /* 33070 */
	"INT_REQ_STALL\0" /* 33079 */
	"ME0PIPE1_CMDFIFO_AVAIL\0" /* 33093 */
	"ME0PIPE1_CF_RQ_PENDING\0" /* 33116 */
	"ME0PIPE1_PF_RQ_PENDING\0" /* 33139 */
	"ME1PIPE0_RQ_PENDING\0" /* 33162 */
	"ME1PIPE1_RQ_PENDING\0" /* 33182 */
	"ME1PIPE2_RQ_PENDING\0" /* 33202 */
	"ME1PIPE3_RQ_PENDING\0" /* 33222 */
	"ME2PIPE0_RQ_PENDING\0" /* 33242 */
	"ME2PIPE1_RQ_PENDING\0" /* 33262 */
	"ME2PIPE2_RQ_PENDING\0" /* 33282 */
	"ME2PIPE3_RQ_PENDING\0" /* 33302 */
	"RLC_RQ_PENDING\0" /* 33322 */
	"RLC_BUSY\0" /* 33337 */
	"TC_BUSY\0" /* 33346 */
	"TCC_CC_RESIDENT\0" /* 33354 */
	"CPF_BUSY\0" /* 33370 */
	"CPC_BUSY\0" /* 33379 */
	"CPG_BUSY\0" /* 33388 */
	"ME0PIPE0_CMDFIFO_AVAIL\0" /* 33397 */
	"SRBM_RQ_PENDING\0" /* 33420 */
	"ME0PIPE0_CF_RQ_PENDING\0" /* 33436 */
	"ME0PIPE0_PF_RQ_PENDING\0" /* 33459 */
	"GDS_DMA_RQ_PENDING\0" /* 33482 */
	"DB_CLEAN\0" /* 33501 */
	"CB_CLEAN\0" /* 33510 */
	"TA_BUSY\0" /* 33519 */
	"GDS_BUSY\0" /* 33527 */
	"WD_BUSY_NO_DMA\0" /* 33536 */
	"VGT_BUSY\0" /* 33551 */
	"IA_BUSY_NO_DMA\0" /* 33560 */
	"IA_BUSY\0" /* 33575 */
	"SX_BUSY\0" /* 33583 */
	"WD_BUSY\0" /* 33591 */
	"SPI_BUSY\0" /* 33599 */
	"BCI_BUSY\0" /* 33608 */
	"SC_BUSY\0" /* 33617 */
	"PA_BUSY\0" /* 33625 */
	"DB_BUSY\0" /* 33633 */
	"CP_COHERENCY_BUSY\0" /* 33641 */
	"GUI_ACTIVE\0" /* 33659 */
	"INSTANCE_INDEX\0" /* 33670 */
	"SH_INDEX\0" /* 33685 */
	"SE_INDEX\0" /* 33694 */
	"SH_BROADCAST_WRITES\0" /* 33703 */
	"INSTANCE_BROADCAST_WRITES\0" /* 33723 */
	"SE_BROADCAST_WRITES\0" /* 33749 */
	"OFFSET_UPDATE_DONE\0" /* 33769, 33783 */
	"DEST_BASE_0_ENA\0" /* 33788 */
	"DEST_BASE_1_ENA\0" /* 33804 */
	"CB0_DEST_BASE_ENA\0" /* 33820 */
	"CB1_DEST_BASE_ENA\0" /* 33838 */
	"CB2_DEST_BASE_ENA\0" /* 33856 */
	"CB3_DEST_BASE_ENA\0" /* 33874 */
	"CB4_DEST_BASE_ENA\0" /* 33892 */
	"CB5_DEST_BASE_ENA\0" /* 33910 */
	"CB6_DEST_BASE_ENA\0" /* 33928 */
	"CB7_DEST_BASE_ENA\0" /* 33946 */
	"DB_DEST_BASE_ENA\0" /* 33964 */
	"DEST_BASE_2_ENA\0" /* 33981 */
	"DEST_BASE_3_ENA\0" /* 33997 */
	"TCL1_ACTION_ENA\0" /* 34013 */
	"TC_ACTION_ENA\0" /* 34029 */
	"CB_ACTION_ENA\0" /* 34043 */
	"DB_ACTION_ENA\0" /* 34057 */
	"SH_KCACHE_ACTION_ENA\0" /* 34071 */
	"SH_ICACHE_ACTION_ENA\0" /* 34092 */
	"COHER_BASE_HI_256B\0" /* 34113 */
	"START_DELAY_COUNT\0" /* 34132 */
	"TC_SD_ACTION_ENA\0" /* 34150 */
	"TC_NC_ACTION_ENA\0" /* 34167 */
	"TCL1_VOL_ACTION_ENA\0" /* 34184 */
	"TC_VOL_ACTION_ENA\0" /* 34204 */
	"TC_WB_ACTION_ENA\0" /* 34222 */
	"SH_KCACHE_VOL_ACTION_ENA\0" /* 34239 */
	"SH_KCACHE_WB_ACTION_ENA\0" /* 34264 */
	"SH_SD_ACTION_ENA\0" /* 34288 */
	"MATCHING_GFX_CNTX\0" /* 34305 */
	"MEID\0" /* 34323 */
	"PHASE1_STATUS\0" /* 34328 */
	"MEC1_BUSY\0" /* 34342 */
	"MEC2_BUSY\0" /* 34352 */
	"DC0_BUSY\0" /* 34362 */
	"DC1_BUSY\0" /* 34371 */
	"RCIU1_BUSY\0" /* 34380 */
	"RCIU2_BUSY\0" /* 34391 */
	"ROQ1_BUSY\0" /* 34402 */
	"ROQ2_BUSY\0" /* 34412 */
	"TCIU_BUSY\0" /* 34422 */
	"SCRATCH_RAM_BUSY\0" /* 34432 */
	"QU_BUSY\0" /* 34449 */
	"ATCL2IU_BUSY\0" /* 34457 */
	"CPG_CPC_BUSY\0" /* 34470 */
	"CPF_CPC_BUSY\0" /* 34483 */
	"MEC1_LOAD_BUSY\0" /* 34496 */
	"MEC1_SEMAPOHRE_BUSY\0" /* 34511 */
	"MEC1_MUTEX_BUSY\0" /* 34531 */
	"MEC1_MESSAGE_BUSY\0" /* 34547 */
	"MEC1_EOP_QUEUE_BUSY\0" /* 34565 */
	"MEC1_IQ_QUEUE_BUSY\0" /* 34585 */
	"MEC1_IB_QUEUE_BUSY\0" /* 34604 */
	"MEC1_TC_BUSY\0" /* 34623 */
	"MEC1_DMA_BUSY\0" /* 34636 */
	"MEC1_PARTIAL_FLUSH_BUSY\0" /* 34650 */
	"MEC1_PIPE0_BUSY\0" /* 34674 */
	"MEC1_PIPE1_BUSY\0" /* 34690 */
	"MEC1_PIPE2_BUSY\0" /* 34706 */
	"MEC1_PIPE3_BUSY\0" /* 34722 */
	"MEC2_LOAD_BUSY\0" /* 34738 */
	"MEC2_SEMAPOHRE_BUSY\0" /* 34753 */
	"MEC2_MUTEX_BUSY\0" /* 34773 */
	"MEC2_MESSAGE_BUSY\0" /* 34789 */
	"MEC2_EOP_QUEUE_BUSY\0" /* 34807 */
	"MEC2_IQ_QUEUE_BUSY\0" /* 34827 */
	"MEC2_IB_QUEUE_BUSY\0" /* 34846 */
	"MEC2_TC_BUSY\0" /* 34865 */
	"MEC2_DMA_BUSY\0" /* 34878 */
	"MEC2_PARTIAL_FLUSH_BUSY\0" /* 34892 */
	"MEC2_PIPE0_BUSY\0" /* 34916 */
	"MEC2_PIPE1_BUSY\0" /* 34932 */
	"MEC2_PIPE2_BUSY\0" /* 34948 */
	"MEC2_PIPE3_BUSY\0" /* 34964 */
	"RCIU_TX_FREE_STALL\0" /* 34980 */
	"RCIU_PRIV_VIOLATION\0" /* 34999 */
	"TCIU_TX_FREE_STALL\0" /* 35019 */
	"MEC1_DECODING_PACKET\0" /* 35038 */
	"MEC1_WAIT_ON_RCIU\0" /* 35059 */
	"MEC1_WAIT_ON_RCIU_READ\0" /* 35077 */
	"MEC1_WAIT_ON_ROQ_DATA\0" /* 35100 */
	"MEC2_DECODING_PACKET\0" /* 35122 */
	"MEC2_WAIT_ON_RCIU\0" /* 35143 */
	"MEC2_WAIT_ON_RCIU_READ\0" /* 35161 */
	"MEC2_WAIT_ON_ROQ_DATA\0" /* 35184 */
	"ATCL2IU_WAITING_ON_FREE\0" /* 35206 */
	"ATCL2IU_WAITING_ON_TAGS\0" /* 35230 */
	"ATCL1_WAITING_ON_TRANS\0" /* 35254 */
	"POST_WPTR_GFX_BUSY\0" /* 35277 */
	"CSF_BUSY\0" /* 35296 */
	"ROQ_ALIGN_BUSY\0" /* 35305 */
	"ROQ_RING_BUSY\0" /* 35320 */
	"ROQ_INDIRECT1_BUSY\0" /* 35334 */
	"ROQ_INDIRECT2_BUSY\0" /* 35353 */
	"ROQ_STATE_BUSY\0" /* 35372 */
	"ROQ_CE_RING_BUSY\0" /* 35387 */
	"ROQ_CE_INDIRECT1_BUSY\0" /* 35404 */
	"ROQ_CE_INDIRECT2_BUSY\0" /* 35426 */
	"SEMAPHORE_BUSY\0" /* 35448 */
	"INTERRUPT_BUSY\0" /* 35463 */
	"HQD_BUSY\0" /* 35478 */
	"PRT_BUSY\0" /* 35487 */
	"CPF_GFX_BUSY\0" /* 35496 */
	"CPF_CMP_BUSY\0" /* 35509 */
	"GRBM_CPF_STAT_BUSY\0" /* 35522 */
	"CPC_CPF_BUSY\0" /* 35541 */
	"REG_BUS_FIFO_BUSY\0" /* 35554 */
	"CSF_RING_BUSY\0" /* 35572 */
	"CSF_INDIRECT1_BUSY\0" /* 35586 */
	"CSF_INDIRECT2_BUSY\0" /* 35605 */
	"CSF_STATE_BUSY\0" /* 35624 */
	"CSF_CE_INDR1_BUSY\0" /* 35639 */
	"CSF_CE_INDR2_BUSY\0" /* 35657 */
	"CSF_ARBITER_BUSY\0" /* 35675 */
	"CSF_INPUT_BUSY\0" /* 35692 */
	"OUTSTANDING_READ_TAGS\0" /* 35707 */
	"HPD_PROCESSING_EOP_BUSY\0" /* 35729 */
	"HQD_DISPATCH_BUSY\0" /* 35753 */
	"HQD_IQ_TIMER_BUSY\0" /* 35771 */
	"HQD_DMA_OFFLOAD_BUSY\0" /* 35789 */
	"HQD_WAIT_SEMAPHORE_BUSY\0" /* 35810 */
	"HQD_SIGNAL_SEMAPHORE_BUSY\0" /* 35834 */
	"HQD_MESSAGE_BUSY\0" /* 35860 */
	"HQD_PQ_FETCHER_BUSY\0" /* 35877 */
	"HQD_IB_FETCHER_BUSY\0" /* 35897 */
	"HQD_IQ_FETCHER_BUSY\0" /* 35917 */
	"HQD_EOP_FETCHER_BUSY\0" /* 35937 */
	"HQD_CONSUMED_RPTR_BUSY\0" /* 35958 */
	"HQD_FETCHER_ARB_BUSY\0" /* 35981 */
	"HQD_ROQ_ALIGN_BUSY\0" /* 36002 */
	"HQD_ROQ_EOP_BUSY\0" /* 36021 */
	"HQD_ROQ_IQ_BUSY\0" /* 36038 */
	"HQD_ROQ_PQ_BUSY\0" /* 36054 */
	"HQD_ROQ_IB_BUSY\0" /* 36070 */
	"HQD_WPTR_POLL_BUSY\0" /* 36086 */
	"HQD_PQ_BUSY\0" /* 36105 */
	"HQD_IB_BUSY\0" /* 36117 */
	"RING_FETCHING_DATA\0" /* 36129 */
	"INDR1_FETCHING_DATA\0" /* 36148 */
	"INDR2_FETCHING_DATA\0" /* 36168 */
	"STATE_FETCHING_DATA\0" /* 36188 */
	"TCIU_WAITING_ON_FREE\0" /* 36208 */
	"TCIU_WAITING_ON_TAGS\0" /* 36229 */
	"COHER_SIZE_HI_256B\0" /* 36250 */
	"PRIM_COUNT\0" /* 36269 */
	"VS_NO_EXTRA_BUFFER\0" /* 36280 */
	"STREAMOUT_FULL_FLUSH\0" /* 36299 */
	"ES_LIMIT\0" /* 36320, 36323 */
	"VERT_REUSE\0" /* 36329 */
	"DI_PT_NONE\0" /* 36340 */
	"DI_PT_POINTLIST\0" /* 36351 */
	"DI_PT_LINELIST\0" /* 36367 */
	"DI_PT_LINESTRIP\0" /* 36382 */
	"DI_PT_TRILIST\0" /* 36398 */
	"DI_PT_TRIFAN\0" /* 36412 */
	"DI_PT_TRISTRIP\0" /* 36425 */
	"DI_PT_UNUSED_0\0" /* 36440 */
	"DI_PT_UNUSED_1\0" /* 36455 */
	"DI_PT_PATCH\0" /* 36470 */
	"DI_PT_LINELIST_ADJ\0" /* 36482 */
	"DI_PT_LINESTRIP_ADJ\0" /* 36501 */
	"DI_PT_TRILIST_ADJ\0" /* 36521 */
	"DI_PT_TRISTRIP_ADJ\0" /* 36539 */
	"DI_PT_UNUSED_3\0" /* 36558 */
	"DI_PT_UNUSED_4\0" /* 36573 */
	"DI_PT_TRI_WITH_WFLAGS\0" /* 36588 */
	"DI_PT_RECTLIST\0" /* 36610 */
	"DI_PT_LINELOOP\0" /* 36625 */
	"DI_PT_QUADLIST\0" /* 36640 */
	"DI_PT_QUADSTRIP\0" /* 36655 */
	"DI_PT_POLYGON\0" /* 36671 */
	"DI_PT_2D_COPY_RECT_LIST_V0\0" /* 36685 */
	"DI_PT_2D_COPY_RECT_LIST_V1\0" /* 36712 */
	"DI_PT_2D_COPY_RECT_LIST_V2\0" /* 36739 */
	"DI_PT_2D_COPY_RECT_LIST_V3\0" /* 36766 */
	"DI_PT_2D_FILL_RECT_LIST\0" /* 36793 */
	"DI_PT_2D_LINE_STRIP\0" /* 36817 */
	"DI_PT_2D_TRI_STRIP\0" /* 36837 */
	"DI_INDEX_SIZE_16_BIT\0" /* 36856 */
	"DI_INDEX_SIZE_32_BIT\0" /* 36877 */
	"OFFCHIP_BUFFERING\0" /* 36898 */
	"CLIP_VTX_REORDER_ENA\0" /* 36916 */
	"NUM_CLIP_SEQ\0" /* 36937 */
	"CLIPPED_PRIM_SEQ_STALL\0" /* 36950 */
	"VE_NAN_PROC_DISABLE\0" /* 36973 */
	"CURRENT_PTR\0" /* 36993 */
	"CURRENT_COUNT\0" /* 37005 */
	"CE_TO_CSF_NOT_RDY_TO_RCV\0" /* 37019 */
	"CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV\0" /* 37044 */
	"CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER\0" /* 37082 */
	"CE_TO_RAM_INIT_NOT_RDY\0" /* 37123 */
	"CE_TO_RAM_DUMP_NOT_RDY\0" /* 37146 */
	"CE_TO_RAM_WRITE_NOT_RDY\0" /* 37169 */
	"CE_TO_INC_FIFO_NOT_RDY_TO_RCV\0" /* 37193 */
	"CE_TO_WR_FIFO_NOT_RDY_TO_RCV\0" /* 37223 */
	"CE_WAITING_ON_BUFFER_DATA\0" /* 37252 */
	"CE_WAITING_ON_CE_BUFFER_FLAG\0" /* 37278 */
	"CE_WAITING_ON_DE_COUNTER\0" /* 37307 */
	"CE_WAITING_ON_DE_COUNTER_UNDERFLOW\0" /* 37332 */
	"CE_STALLED_ON_TC_WR_CONFIRM\0" /* 37367 */
	"CE_STALLED_ON_ATOMIC_RTN_DATA\0" /* 37395 */
	"RBIU_TO_DMA_NOT_RDY_TO_RCV\0" /* 37425 */
	"RBIU_TO_SEM_NOT_RDY_TO_RCV\0" /* 37452 */
	"RBIU_TO_MEMWR_NOT_RDY_TO_RCV\0" /* 37479 */
	"ME_HAS_ACTIVE_CE_BUFFER_FLAG\0" /* 37508 */
	"ME_HAS_ACTIVE_DE_BUFFER_FLAG\0" /* 37537 */
	"ME_STALLED_ON_TC_WR_CONFIRM\0" /* 37566 */
	"ME_STALLED_ON_ATOMIC_RTN_DATA\0" /* 37594 */
	"ME_WAITING_ON_TC_READ_DATA\0" /* 37624 */
	"ME_WAITING_ON_REG_READ_DATA\0" /* 37651 */
	"RCIU_WAITING_ON_GDS_FREE\0" /* 37679 */
	"RCIU_WAITING_ON_GRBM_FREE\0" /* 37704 */
	"RCIU_WAITING_ON_VGT_FREE\0" /* 37730 */
	"RCIU_STALLED_ON_ME_READ\0" /* 37755 */
	"RCIU_STALLED_ON_DMA_READ\0" /* 37779 */
	"RCIU_STALLED_ON_APPEND_READ\0" /* 37804 */
	"RCIU_HALTED_BY_REG_VIOLATION\0" /* 37832 */
	"PFP_TO_CSF_NOT_RDY_TO_RCV\0" /* 37861 */
	"PFP_TO_MEQ_NOT_RDY_TO_RCV\0" /* 37887 */
	"PFP_TO_RCIU_NOT_RDY_TO_RCV\0" /* 37913 */
	"PFP_TO_VGT_WRITES_PENDING\0" /* 37940 */
	"PFP_RCIU_READ_PENDING\0" /* 37966 */
	"PFP_WAITING_ON_BUFFER_DATA\0" /* 37988 */
	"ME_WAIT_ON_CE_COUNTER\0" /* 38015 */
	"ME_WAIT_ON_AVAIL_BUFFER\0" /* 38037 */
	"GFX_CNTX_NOT_AVAIL_TO_ME\0" /* 38061 */
	"ME_RCIU_NOT_RDY_TO_RCV\0" /* 38086 */
	"ME_TO_CONST_NOT_RDY_TO_RCV\0" /* 38109 */
	"ME_WAITING_DATA_FROM_PFP\0" /* 38136 */
	"ME_WAITING_ON_PARTIAL_FLUSH\0" /* 38161 */
	"MEQ_TO_ME_NOT_RDY_TO_RCV\0" /* 38189 */
	"STQ_TO_ME_NOT_RDY_TO_RCV\0" /* 38214 */
	"ME_WAITING_DATA_FROM_STQ\0" /* 38239 */
	"PFP_STALLED_ON_TC_WR_CONFIRM\0" /* 38264 */
	"PFP_STALLED_ON_ATOMIC_RTN_DATA\0" /* 38293 */
	"EOPD_FIFO_NEEDS_SC_EOP_DONE\0" /* 38324 */
	"EOPD_FIFO_NEEDS_WR_CONFIRM\0" /* 38352 */
	"STRMO_WR_OF_PRIM_DATA_PENDING\0" /* 38379 */
	"PIPE_STATS_WR_DATA_PENDING\0" /* 38409 */
	"APPEND_RDY_WAIT_ON_CS_DONE\0" /* 38436, 38455 */
	"APPEND_RDY_WAIT_ON_PS_DONE\0" /* 38463, 38482 */
	"APPEND_WAIT_ON_WR_CONFIRM\0" /* 38490 */
	"APPEND_ACTIVE_PARTITION\0" /* 38516 */
	"APPEND_WAITING_TO_SEND_MEMWRITE\0" /* 38540 */
	"SURF_SYNC_NEEDS_IDLE_CNTXS\0" /* 38572 */
	"SURF_SYNC_NEEDS_ALL_CLEAN\0" /* 38599 */
	"DC_BUSY\0" /* 38625 */
	"PFP_BUSY\0" /* 38633 */
	"MEQ_BUSY\0" /* 38642 */
	"ME_BUSY\0" /* 38651 */
	"QUERY_BUSY\0" /* 38659 */
	"SURFACE_SYNC_BUSY\0" /* 38670 */
	"RCIU_BUSY\0" /* 38688 */
	"CPC_CPG_BUSY\0" /* 38698 */
	"CE_BUSY\0" /* 38711 */
	"X_8K_DWORDS\0" /* 38719 */
	"X_4K_DWORDS\0" /* 38731 */
	"X_2K_DWORDS\0" /* 38743 */
	"X_1K_DWORDS\0" /* 38755 */
	"OFFCHIP_GRANULARITY\0" /* 38767 */
	"ENABLE_PA_SC_OUT_OF_ORDER\0" /* 38787 */
	"DISABLE_SC_DB_TILE_FIX\0" /* 38813 */
	"DISABLE_AA_MASK_FULL_FIX\0" /* 38836 */
	"ENABLE_1XMSAA_SAMPLE_LOCATIONS\0" /* 38861 */
	"ENABLE_1XMSAA_SAMPLE_LOC_CENTROID\0" /* 38892 */
	"DISABLE_SCISSOR_FIX\0" /* 38926 */
	"DISABLE_PW_BUBBLE_COLLAPSE\0" /* 38946 */
	"SEND_UNLIT_STILES_TO_PACKER\0" /* 38973 */
	"DISABLE_DUALGRAD_PERF_OPTIMIZATION\0" /* 39001 */
	"INST_INVALIDATE\0" /* 39036, 39041 */
	"DATA_INVALIDATE\0" /* 39052 */
	"INVALIDATE_VOLATILE\0" /* 39068 */
	"RET\0" /* 39088 */
	"RUI\0" /* 39092 */
	"RNG\0" /* 39096 */
	"SQ_EXP_MRT\0" /* 39100 */
	"SQ_EXP_MRTZ\0" /* 39111 */
	"SQ_EXP_NULL\0" /* 39123 */
	"SQ_EXP_POS\0" /* 39135 */
	"SQ_EXP_PARAM\0" /* 39146 */
	"TGT\0" /* 39159 */
	"COMPR\0" /* 39163 */
	"VM\0" /* 39169 */
	"SQ_ENC_EXP_FIELD\0" /* 39172 */
	"ENCODING\0" /* 39189 */
	"ADDRESS\0" /* 39198 */
	"BASE_ADDRESS_HI\0" /* 39206, 39211 */
	"CACHE_SWIZZLE\0" /* 39222 */
	"SWIZZLE_ENABLE\0" /* 39236 */
	"SQ_SEL_0\0" /* 39251 */
	"SQ_SEL_1\0" /* 39260 */
	"SQ_SEL_RESERVED_0\0" /* 39269, 39276 */
	"SQ_SEL_RESERVED_1\0" /* 39287, 39294 */
	"SQ_SEL_X\0" /* 39305 */
	"SQ_SEL_Y\0" /* 39314 */
	"SQ_SEL_Z\0" /* 39323 */
	"SQ_SEL_W\0" /* 39332 */
	"DST_SEL_X\0" /* 39341 */
	"DST_SEL_Y\0" /* 39351 */
	"DST_SEL_Z\0" /* 39361 */
	"DST_SEL_W\0" /* 39371 */
	"BUF_NUM_FORMAT_UNORM\0" /* 39381 */
	"BUF_NUM_FORMAT_SNORM\0" /* 39402 */
	"BUF_NUM_FORMAT_USCALED\0" /* 39423 */
	"BUF_NUM_FORMAT_SSCALED\0" /* 39446 */
	"BUF_NUM_FORMAT_UINT\0" /* 39469 */
	"BUF_NUM_FORMAT_SINT\0" /* 39489 */
	"BUF_NUM_FORMAT_SNORM_OGL\0" /* 39509 */
	"BUF_NUM_FORMAT_FLOAT\0" /* 39534 */
	"NUM_FORMAT\0" /* 39555 */
	"BUF_DATA_FORMAT_INVALID\0" /* 39566 */
	"BUF_DATA_FORMAT_8\0" /* 39590 */
	"BUF_DATA_FORMAT_16\0" /* 39608 */
	"BUF_DATA_FORMAT_8_8\0" /* 39627 */
	"BUF_DATA_FORMAT_32\0" /* 39647 */
	"BUF_DATA_FORMAT_16_16\0" /* 39666 */
	"BUF_DATA_FORMAT_10_11_11\0" /* 39688 */
	"BUF_DATA_FORMAT_11_11_10\0" /* 39713 */
	"BUF_DATA_FORMAT_10_10_10_2\0" /* 39738 */
	"BUF_DATA_FORMAT_2_10_10_10\0" /* 39765 */
	"BUF_DATA_FORMAT_8_8_8_8\0" /* 39792 */
	"BUF_DATA_FORMAT_32_32\0" /* 39816 */
	"BUF_DATA_FORMAT_16_16_16_16\0" /* 39838 */
	"BUF_DATA_FORMAT_32_32_32\0" /* 39866 */
	"BUF_DATA_FORMAT_32_32_32_32\0" /* 39891 */
	"BUF_DATA_FORMAT_RESERVED_15\0" /* 39919 */
	"DATA_FORMAT\0" /* 39947 */
	"ELEMENT_SIZE\0" /* 39959 */
	"INDEX_STRIDE\0" /* 39972 */
	"ADD_TID_ENABLE\0" /* 39985 */
	"ATC\0" /* 40000 */
	"HASH_ENABLE\0" /* 40004 */
	"HEAP\0" /* 40016 */
	"MTYPE\0" /* 40021 */
	"SQ_RSRC_BUF\0" /* 40027 */
	"SQ_RSRC_BUF_RSVD_1\0" /* 40039 */
	"SQ_RSRC_BUF_RSVD_2\0" /* 40058 */
	"SQ_RSRC_BUF_RSVD_3\0" /* 40077 */
	"MIN_LOD\0" /* 40096 */
	"IMG_DATA_FORMAT_INVALID\0" /* 40104 */
	"IMG_DATA_FORMAT_8\0" /* 40128 */
	"IMG_DATA_FORMAT_16\0" /* 40146 */
	"IMG_DATA_FORMAT_8_8\0" /* 40165 */
	"IMG_DATA_FORMAT_32\0" /* 40185 */
	"IMG_DATA_FORMAT_16_16\0" /* 40204 */
	"IMG_DATA_FORMAT_10_11_11\0" /* 40226 */
	"IMG_DATA_FORMAT_11_11_10\0" /* 40251 */
	"IMG_DATA_FORMAT_10_10_10_2\0" /* 40276 */
	"IMG_DATA_FORMAT_2_10_10_10\0" /* 40303 */
	"IMG_DATA_FORMAT_8_8_8_8\0" /* 40330 */
	"IMG_DATA_FORMAT_32_32\0" /* 40354 */
	"IMG_DATA_FORMAT_16_16_16_16\0" /* 40376 */
	"IMG_DATA_FORMAT_32_32_32\0" /* 40404 */
	"IMG_DATA_FORMAT_32_32_32_32\0" /* 40429 */
	"IMG_DATA_FORMAT_RESERVED_15\0" /* 40457 */
	"IMG_DATA_FORMAT_5_6_5\0" /* 40485 */
	"IMG_DATA_FORMAT_1_5_5_5\0" /* 40507 */
	"IMG_DATA_FORMAT_5_5_5_1\0" /* 40531 */
	"IMG_DATA_FORMAT_4_4_4_4\0" /* 40555 */
	"IMG_DATA_FORMAT_8_24\0" /* 40579 */
	"IMG_DATA_FORMAT_24_8\0" /* 40600 */
	"IMG_DATA_FORMAT_X24_8_32\0" /* 40621 */
	"IMG_DATA_FORMAT_8_AS_8_8_8_8\0" /* 40646 */
	"IMG_DATA_FORMAT_ETC2_RGB\0" /* 40675 */
	"IMG_DATA_FORMAT_ETC2_RGBA\0" /* 40700 */
	"IMG_DATA_FORMAT_ETC2_R\0" /* 40726 */
	"IMG_DATA_FORMAT_ETC2_RG\0" /* 40749 */
	"IMG_DATA_FORMAT_ETC2_RGBA1\0" /* 40773 */
	"IMG_DATA_FORMAT_RESERVED_29\0" /* 40800 */
	"IMG_DATA_FORMAT_RESERVED_30\0" /* 40828 */
	"IMG_DATA_FORMAT_RESERVED_31\0" /* 40856 */
	"IMG_DATA_FORMAT_GB_GR\0" /* 40884 */
	"IMG_DATA_FORMAT_BG_RG\0" /* 40906 */
	"IMG_DATA_FORMAT_5_9_9_9\0" /* 40928 */
	"IMG_DATA_FORMAT_BC1\0" /* 40952 */
	"IMG_DATA_FORMAT_BC2\0" /* 40972 */
	"IMG_DATA_FORMAT_BC3\0" /* 40992 */
	"IMG_DATA_FORMAT_BC4\0" /* 41012 */
	"IMG_DATA_FORMAT_BC5\0" /* 41032 */
	"IMG_DATA_FORMAT_BC6\0" /* 41052 */
	"IMG_DATA_FORMAT_BC7\0" /* 41072 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX6\0" /* 41092 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX6\0" /* 41131 */
	"IMG_DATA_FORMAT_FMASK8_S2_F1\0" /* 41170 */
	"IMG_DATA_FORMAT_FMASK8_S4_F1\0" /* 41199 */
	"IMG_DATA_FORMAT_FMASK8_S8_F1\0" /* 41228 */
	"IMG_DATA_FORMAT_FMASK8_S2_F2\0" /* 41257 */
	"IMG_DATA_FORMAT_FMASK8_S4_F2\0" /* 41286 */
	"IMG_DATA_FORMAT_FMASK8_S4_F4\0" /* 41315 */
	"IMG_DATA_FORMAT_FMASK16_S16_F1\0" /* 41344 */
	"IMG_DATA_FORMAT_FMASK16_S8_F2\0" /* 41375 */
	"IMG_DATA_FORMAT_FMASK32_S16_F2\0" /* 41405 */
	"IMG_DATA_FORMAT_FMASK32_S8_F4\0" /* 41436 */
	"IMG_DATA_FORMAT_FMASK32_S8_F8\0" /* 41466 */
	"IMG_DATA_FORMAT_FMASK64_S16_F4\0" /* 41496 */
	"IMG_DATA_FORMAT_FMASK64_S16_F8\0" /* 41527 */
	"IMG_DATA_FORMAT_4_4\0" /* 41558 */
	"IMG_DATA_FORMAT_6_5_5\0" /* 41578 */
	"IMG_DATA_FORMAT_1\0" /* 41600 */
	"IMG_DATA_FORMAT_1_REVERSED\0" /* 41618 */
	"IMG_DATA_FORMAT_32_AS_8\0" /* 41645 */
	"IMG_DATA_FORMAT_32_AS_8_8\0" /* 41669 */
	"IMG_DATA_FORMAT_32_AS_32_32_32_32\0" /* 41695 */
	"DATA_FORMAT_GFX6\0" /* 41729 */
	"IMG_NUM_FORMAT_UNORM\0" /* 41746 */
	"IMG_NUM_FORMAT_SNORM\0" /* 41767 */
	"IMG_NUM_FORMAT_USCALED\0" /* 41788 */
	"IMG_NUM_FORMAT_SSCALED\0" /* 41811 */
	"IMG_NUM_FORMAT_UINT\0" /* 41834 */
	"IMG_NUM_FORMAT_SINT\0" /* 41854 */
	"IMG_NUM_FORMAT_SNORM_OGL\0" /* 41874 */
	"IMG_NUM_FORMAT_FLOAT\0" /* 41899 */
	"IMG_NUM_FORMAT_RESERVED_8\0" /* 41920 */
	"IMG_NUM_FORMAT_SRGB\0" /* 41946 */
	"IMG_NUM_FORMAT_UBNORM\0" /* 41966 */
	"IMG_NUM_FORMAT_UBNORM_OGL\0" /* 41988 */
	"IMG_NUM_FORMAT_UBINT\0" /* 42014 */
	"IMG_NUM_FORMAT_UBSCALED\0" /* 42035 */
	"IMG_NUM_FORMAT_RESERVED_14\0" /* 42059 */
	"IMG_NUM_FORMAT_RESERVED_15\0" /* 42086 */
	"NUM_FORMAT_GFX6\0" /* 42113 */
	"WIDTH\0" /* 42129 */
	"HEIGHT\0" /* 42135 */
	"PERF_MOD\0" /* 42142 */
	"INTERLACED\0" /* 42151 */
	"BASE_LEVEL\0" /* 42162 */
	"LAST_LEVEL\0" /* 42173 */
	"TILING_INDEX\0" /* 42184 */
	"POW2_PAD\0" /* 42197 */
	"SQ_RSRC_IMG_RSVD_0\0" /* 42206 */
	"SQ_RSRC_IMG_RSVD_1\0" /* 42225 */
	"SQ_RSRC_IMG_RSVD_2\0" /* 42244 */
	"SQ_RSRC_IMG_RSVD_3\0" /* 42263 */
	"SQ_RSRC_IMG_RSVD_4\0" /* 42282 */
	"SQ_RSRC_IMG_RSVD_5\0" /* 42301 */
	"SQ_RSRC_IMG_RSVD_6\0" /* 42320 */
	"SQ_RSRC_IMG_RSVD_7\0" /* 42339 */
	"SQ_RSRC_IMG_1D\0" /* 42358, 42370 */
	"SQ_RSRC_IMG_2D\0" /* 42373, 42385 */
	"SQ_RSRC_IMG_3D\0" /* 42388, 42400 */
	"SQ_RSRC_IMG_CUBE\0" /* 42403 */
	"SQ_RSRC_IMG_1D_ARRAY\0" /* 42420 */
	"SQ_RSRC_IMG_2D_ARRAY\0" /* 42441 */
	"SQ_RSRC_IMG_2D_MSAA\0" /* 42462 */
	"SQ_RSRC_IMG_2D_MSAA_ARRAY\0" /* 42482 */
	"PITCH_GFX6\0" /* 42508 */
	"BASE_ARRAY\0" /* 42519 */
	"LAST_ARRAY\0" /* 42530 */
	"MIN_LOD_WARN\0" /* 42541 */
	"COUNTER_BANK_ID\0" /* 42554 */
	"LOD_HDW_CNT_EN\0" /* 42570 */
	"COMPRESSION_EN\0" /* 42585 */
	"ALPHA_IS_ON_MSB\0" /* 42600 */
	"COLOR_TRANSFORM\0" /* 42616 */
	"LOST_ALPHA_BITS\0" /* 42632 */
	"LOST_COLOR_BITS\0" /* 42648 */
	"SQ_TEX_WRAP\0" /* 42664 */
	"SQ_TEX_MIRROR\0" /* 42676 */
	"SQ_TEX_CLAMP_LAST_TEXEL\0" /* 42690 */
	"SQ_TEX_MIRROR_ONCE_LAST_TEXEL\0" /* 42714 */
	"SQ_TEX_CLAMP_HALF_BORDER\0" /* 42744 */
	"SQ_TEX_MIRROR_ONCE_HALF_BORDER\0" /* 42769 */
	"SQ_TEX_CLAMP_BORDER\0" /* 42800 */
	"SQ_TEX_MIRROR_ONCE_BORDER\0" /* 42820 */
	"CLAMP_X\0" /* 42846 */
	"CLAMP_Y\0" /* 42854 */
	"CLAMP_Z\0" /* 42862 */
	"MAX_ANISO_RATIO\0" /* 42870 */
	"SQ_TEX_DEPTH_COMPARE_NEVER\0" /* 42886 */
	"SQ_TEX_DEPTH_COMPARE_LESS\0" /* 42913 */
	"SQ_TEX_DEPTH_COMPARE_EQUAL\0" /* 42939 */
	"SQ_TEX_DEPTH_COMPARE_LESSEQUAL\0" /* 42966 */
	"SQ_TEX_DEPTH_COMPARE_GREATER\0" /* 42997 */
	"SQ_TEX_DEPTH_COMPARE_NOTEQUAL\0" /* 43026 */
	"SQ_TEX_DEPTH_COMPARE_GREATEREQUAL\0" /* 43056 */
	"SQ_TEX_DEPTH_COMPARE_ALWAYS\0" /* 43090, 43111 */
	"DEPTH_COMPARE_FUNC\0" /* 43118 */
	"FORCE_UNNORMALIZED\0" /* 43137 */
	"ANISO_THRESHOLD\0" /* 43156 */
	"MC_COORD_TRUNC\0" /* 43172 */
	"FORCE_DEGAMMA\0" /* 43187 */
	"ANISO_BIAS\0" /* 43201 */
	"TRUNC_COORD\0" /* 43212 */
	"DISABLE_CUBE_WRAP\0" /* 43224 */
	"FILTER_MODE\0" /* 43242 */
	"COMPAT_MODE\0" /* 43254 */
	"MAX_LOD\0" /* 43266 */
	"PERF_MIP\0" /* 43274 */
	"PERF_Z\0" /* 43283 */
	"LOD_BIAS\0" /* 43290 */
	"LOD_BIAS_SEC\0" /* 43299 */
	"SQ_TEX_XY_FILTER_POINT\0" /* 43312, 43326 */
	"SQ_TEX_XY_FILTER_BILINEAR\0" /* 43335, 43354 */
	"XY_MAG_FILTER\0" /* 43361 */
	"SQ_TEX_XY_FILTER_ANISO_POINT\0" /* 43375 */
	"SQ_TEX_XY_FILTER_ANISO_BILINEAR\0" /* 43404 */
	"XY_MIN_FILTER\0" /* 43436 */
	"SQ_TEX_Z_FILTER_NONE\0" /* 43450 */
	"SQ_TEX_Z_FILTER_POINT\0" /* 43471 */
	"SQ_TEX_Z_FILTER_LINEAR\0" /* 43493 */
	"Z_FILTER\0" /* 43516 */
	"MIP_FILTER\0" /* 43525 */
	"MIP_POINT_PRECLAMP\0" /* 43536 */
	"DISABLE_LSB_CEIL\0" /* 43555 */
	"FILTER_PREC_FIX\0" /* 43572 */
	"ANISO_OVERRIDE\0" /* 43588 */
	"BORDER_COLOR_PTR\0" /* 43603 */
	"UPGRADED_DEPTH\0" /* 43620 */
	"SQ_TEX_BORDER_COLOR_TRANS_BLACK\0" /* 43635 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_BLACK\0" /* 43667 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_WHITE\0" /* 43700 */
	"SQ_TEX_BORDER_COLOR_REGISTER\0" /* 43733 */
	"BORDER_COLOR_TYPE\0" /* 43762 */
	"VS_LOW_THRESHOLD\0" /* 43780 */
	"GS_LOW_THRESHOLD\0" /* 43797 */
	"ES_LOW_THRESHOLD\0" /* 43814 */
	"HS_LOW_THRESHOLD\0" /* 43831 */
	"LS_LOW_THRESHOLD\0" /* 43848 */
	"PS_CU_EN\0" /* 43865, 43868 */
	"VS_CU_EN\0" /* 43874 */
	"GS_CU_EN\0" /* 43883 */
	"ES_CU_EN\0" /* 43892 */
	"LSHS_CU_EN\0" /* 43901 */
	"X_R0\0" /* 43912 */
	"RING_ORDER_TS0\0" /* 43917 */
	"RING_ORDER_TS1\0" /* 43932 */
	"RING_ORDER_TS2\0" /* 43947 */
	"PIPE_ORDER_TS0\0" /* 43962 */
	"PIPE_ORDER_TS1\0" /* 43977 */
	"PIPE_ORDER_TS2\0" /* 43992 */
	"PIPE_ORDER_TS3\0" /* 44007 */
	"TS0_DUR_MULT\0" /* 44022 */
	"TS1_DUR_MULT\0" /* 44035 */
	"TS2_DUR_MULT\0" /* 44048 */
	"TS3_DUR_MULT\0" /* 44061 */
	"TS0_DURATION\0" /* 44074 */
	"TS1_DURATION\0" /* 44087 */
	"TS2_DURATION\0" /* 44100 */
	"GPR_WRITE_PRIORITY\0" /* 44113 */
	"EXP_PRIORITY_ORDER\0" /* 44132 */
	"ENABLE_SQG_TOP_EVENTS\0" /* 44151 */
	"ENABLE_SQG_BOP_EVENTS\0" /* 44173 */
	"RSRC_MGMT_RESET\0" /* 44195 */
	"X_DELAY_14_CLKS\0" /* 44211 */
	"X_DELAY_16_CLKS\0" /* 44227 */
	"X_DELAY_18_CLKS\0" /* 44243 */
	"X_DELAY_20_CLKS\0" /* 44259 */
	"X_DELAY_22_CLKS\0" /* 44275 */
	"X_DELAY_24_CLKS\0" /* 44291 */
	"X_DELAY_26_CLKS\0" /* 44307 */
	"X_DELAY_28_CLKS\0" /* 44323 */
	"X_DELAY_30_CLKS\0" /* 44339 */
	"X_DELAY_32_CLKS\0" /* 44355 */
	"X_DELAY_34_CLKS\0" /* 44371 */
	"X_DELAY_4_CLKS\0" /* 44387 */
	"X_DELAY_6_CLKS\0" /* 44402 */
	"X_DELAY_8_CLKS\0" /* 44417 */
	"X_DELAY_10_CLKS\0" /* 44432 */
	"X_DELAY_12_CLKS\0" /* 44448 */
	"VTX_DONE_DELAY\0" /* 44464 */
	"INTERP_ONE_PRIM_PER_ROW\0" /* 44479 */
	"PC_LIMIT_ENABLE\0" /* 44503 */
	"PC_LIMIT_STRICT\0" /* 44519 */
	"PC_LIMIT_SIZE\0" /* 44535 */
	"TYPE_A\0" /* 44549 */
	"VGPR_A\0" /* 44556 */
	"SGPR_A\0" /* 44563 */
	"LDS_A\0" /* 44570 */
	"WAVES_A\0" /* 44576 */
	"EN_A\0" /* 44584 */
	"TYPE_B\0" /* 44589 */
	"VGPR_B\0" /* 44596 */
	"SGPR_B\0" /* 44603 */
	"LDS_B\0" /* 44610 */
	"WAVES_B\0" /* 44616 */
	"EN_B\0" /* 44624 */
	"MSAA1_X\0" /* 44629 */
	"MSAA1_Y\0" /* 44637 */
	"MSAA2_X\0" /* 44645 */
	"MSAA2_Y\0" /* 44653 */
	"MSAA4_X\0" /* 44661 */
	"MSAA4_Y\0" /* 44669 */
	"MSAA8_X\0" /* 44677 */
	"MSAA8_Y\0" /* 44685 */
	"MSAA16_X\0" /* 44693 */
	"MSAA16_Y\0" /* 44702 */
	"NUM_PIPES\0" /* 44711 */
	"PIPE_INTERLEAVE_SIZE_GFX6\0" /* 44721 */
	"BANK_INTERLEAVE_SIZE\0" /* 44747 */
	"NUM_SHADER_ENGINES_GFX6\0" /* 44768 */
	"SHADER_ENGINE_TILE_SIZE\0" /* 44792 */
	"NUM_GPUS_GFX6\0" /* 44816 */
	"MULTI_GPU_TILE_SIZE\0" /* 44830 */
	"ROW_SIZE\0" /* 44850 */
	"NUM_LOWER_PIPES\0" /* 44859 */
	"ADDR_SURF_DISPLAY_MICRO_TILING\0" /* 44875 */
	"ADDR_SURF_THIN_MICRO_TILING\0" /* 44906 */
	"ADDR_SURF_DEPTH_MICRO_TILING\0" /* 44934 */
	"ADDR_SURF_THICK_MICRO_TILING\0" /* 44963 */
	"MICRO_TILE_MODE\0" /* 44992 */
	"ARRAY_LINEAR_GENERAL\0" /* 45008, 45014 */
	"ARRAY_LINEAR_ALIGNED\0" /* 45029 */
	"ARRAY_1D_TILED_THIN1\0" /* 45050 */
	"ARRAY_1D_TILED_THICK\0" /* 45071 */
	"ARRAY_2D_TILED_THIN1\0" /* 45092 */
	"ARRAY_2D_TILED_THICK\0" /* 45113 */
	"ARRAY_2D_TILED_XTHICK\0" /* 45134 */
	"ARRAY_3D_TILED_THIN1\0" /* 45156 */
	"ARRAY_3D_TILED_THICK\0" /* 45177 */
	"ARRAY_3D_TILED_XTHICK\0" /* 45198 */
	"ARRAY_POWER_SAVE\0" /* 45220 */
	"ARRAY_MODE\0" /* 45237 */
	"ADDR_SURF_P2\0" /* 45248 */
	"ADDR_SURF_P2_RESERVED0\0" /* 45261 */
	"ADDR_SURF_P2_RESERVED1\0" /* 45284 */
	"ADDR_SURF_P2_RESERVED2\0" /* 45307, 45320 */
	"X_ADDR_SURF_P4_8X16\0" /* 45330 */
	"X_ADDR_SURF_P4_16X16\0" /* 45350 */
	"X_ADDR_SURF_P4_16X32\0" /* 45371 */
	"X_ADDR_SURF_P4_32X32\0" /* 45392 */
	"X_ADDR_SURF_P8_16X16_8X16\0" /* 45413 */
	"X_ADDR_SURF_P8_16X32_8X16\0" /* 45439 */
	"X_ADDR_SURF_P8_32X32_8X16\0" /* 45465 */
	"X_ADDR_SURF_P8_16X32_16X16\0" /* 45491 */
	"X_ADDR_SURF_P8_32X32_16X16\0" /* 45518 */
	"X_ADDR_SURF_P8_32X32_16X32\0" /* 45545 */
	"X_ADDR_SURF_P8_32X64_32X32\0" /* 45572 */
	"PIPE_CONFIG\0" /* 45599 */
	"ADDR_SURF_TILE_SPLIT_64B\0" /* 45611 */
	"ADDR_SURF_TILE_SPLIT_128B\0" /* 45636 */
	"ADDR_SURF_TILE_SPLIT_256B\0" /* 45662 */
	"ADDR_SURF_TILE_SPLIT_512B\0" /* 45688 */
	"ADDR_SURF_TILE_SPLIT_1KB\0" /* 45714 */
	"ADDR_SURF_TILE_SPLIT_2KB\0" /* 45739 */
	"ADDR_SURF_TILE_SPLIT_4KB\0" /* 45764 */
	"TILE_SPLIT\0" /* 45789 */
	"ADDR_SURF_BANK_WIDTH_1\0" /* 45800 */
	"ADDR_SURF_BANK_WIDTH_2\0" /* 45823 */
	"ADDR_SURF_BANK_WIDTH_4\0" /* 45846 */
	"ADDR_SURF_BANK_WIDTH_8\0" /* 45869 */
	"BANK_WIDTH\0" /* 45892 */
	"ADDR_SURF_BANK_HEIGHT_1\0" /* 45903 */
	"ADDR_SURF_BANK_HEIGHT_2\0" /* 45927 */
	"ADDR_SURF_BANK_HEIGHT_4\0" /* 45951 */
	"ADDR_SURF_BANK_HEIGHT_8\0" /* 45975 */
	"BANK_HEIGHT\0" /* 45999 */
	"ADDR_SURF_MACRO_ASPECT_1\0" /* 46011 */
	"ADDR_SURF_MACRO_ASPECT_2\0" /* 46036 */
	"ADDR_SURF_MACRO_ASPECT_4\0" /* 46061 */
	"ADDR_SURF_MACRO_ASPECT_8\0" /* 46086 */
	"MACRO_TILE_ASPECT\0" /* 46111 */
	"ADDR_SURF_2_BANK\0" /* 46129 */
	"ADDR_SURF_4_BANK\0" /* 46146 */
	"ADDR_SURF_8_BANK\0" /* 46163 */
	"ADDR_SURF_16_BANK\0" /* 46180 */
	"NUM_BANKS\0" /* 46198 */
	"ADDR_SURF_ROTATED_MICRO_TILING\0" /* 46208 */
	"MICRO_TILE_MODE_NEW\0" /* 46239 */
	"SAMPLE_SPLIT\0" /* 46259 */
	"MEM_BASE\0" /* 46272 */
	"WAVE_LIMIT\0" /* 46281 */
	"LOCK_LOW_THRESHOLD\0" /* 46292 */
	"VGPRS\0" /* 46311 */
	"SGPRS\0" /* 46317 */
	"FP_32_DENORMS\0" /* 46323 */
	"FP_64_DENORMS\0" /* 46337 */
	"FP_ALL_DENORMS\0" /* 46351 */
	"FLOAT_MODE\0" /* 46366 */
	"PRIV\0" /* 46377 */
	"DX10_CLAMP\0" /* 46382 */
	"DEBUG_MODE\0" /* 46393 */
	"IEEE_MODE\0" /* 46404 */
	"CU_GROUP_DISABLE\0" /* 46414 */
	"CACHE_CTL\0" /* 46431 */
	"CDBG_USER\0" /* 46441 */
	"SCRATCH_EN\0" /* 46451 */
	"USER_SGPR\0" /* 46462 */
	"TRAP_PRESENT\0" /* 46472 */
	"WAVE_CNT_EN\0" /* 46485 */
	"EXTRA_LDS_SIZE\0" /* 46497, 46503 */
	"EXCP_EN_SI\0" /* 46512 */
	"EXCP_EN\0" /* 46523 */
	"VGPR_COMP_CNT\0" /* 46531 */
	"CU_GROUP_ENABLE\0" /* 46545 */
	"OC_LDS_EN\0" /* 46561 */
	"SO_BASE0_EN\0" /* 46571 */
	"SO_BASE1_EN\0" /* 46583 */
	"SO_BASE2_EN\0" /* 46595 */
	"SO_BASE3_EN\0" /* 46607 */
	"SO_EN\0" /* 46619 */
	"DISPATCH_DRAW_EN\0" /* 46625 */
	"GROUP_FIFO_DEPTH\0" /* 46642 */
	"TG_SIZE_EN\0" /* 46659 */
	"EXCP_EN_CIK_VI\0" /* 46670 */
	"COMPUTE_SHADER_EN\0" /* 46685 */
	"PARTIAL_TG_EN\0" /* 46703 */
	"FORCE_START_AT_000\0" /* 46717 */
	"ORDERED_APPEND_ENBL\0" /* 46736 */
	"ORDERED_APPEND_MODE\0" /* 46756 */
	"USE_THREAD_DIMENSIONS\0" /* 46776 */
	"ORDER_MODE\0" /* 46798 */
	"DISPATCH_CACHE_CNTL\0" /* 46809 */
	"SCALAR_L1_INV_VOL\0" /* 46829, 46843 */
	"VECTOR_L1_INV_VOL\0" /* 46847 */
	"DATA_ATC\0" /* 46865 */
	"RESTORE\0" /* 46874 */
	"NUM_THREAD_FULL\0" /* 46882 */
	"NUM_THREAD_PARTIAL\0" /* 46898 */
	"INST_ATC\0" /* 46917 */
	"BULKY\0" /* 46926 */
	"TGID_X_EN\0" /* 46932 */
	"TGID_Y_EN\0" /* 46942 */
	"TGID_Z_EN\0" /* 46952 */
	"TIDIG_COMP_CNT\0" /* 46962 */
	"EXCP_EN_MSB\0" /* 46977 */
	"WAVES_PER_SH_SI\0" /* 46989 */
	"WAVES_PER_SH\0" /* 47005 */
	"TG_PER_CU\0" /* 47018 */
	"LOCK_THRESHOLD\0" /* 47028 */
	"SIMD_DEST_CNTL\0" /* 47043 */
	"FORCE_SIMD_DIST\0" /* 47058 */
	"CU_GROUP_COUNT\0" /* 47074 */
	"SH0_CU_EN\0" /* 47089 */
	"SH1_CU_EN\0" /* 47099 */
	"WAVES\0" /* 47109 */
	"WAVESIZE\0" /* 47115 */
	"SEND_SEID\0" /* 47124 */
	"RESERVED3\0" /* 47134 */
	"RESERVED4\0" /* 47144 */
	"WAVE_ID_BASE\0" /* 47154 */
	"PAYLOAD\0" /* 47167 */
	"IS_EVENT\0" /* 47175 */
	"IS_STATE\0" /* 47184 */
	"PERF_SEL\0" /* 47193 */
	"PERF_SEL1\0" /* 47202 */
	"CNTR_MODE\0" /* 47212 */
	"PERF_SEL2\0" /* 47222 */
	"PERF_SEL3\0" /* 47232 */
	"DISABLE_AND_RESET\0" /* 47242 */
	"START_COUNTING\0" /* 47260 */
	"STOP_COUNTING\0" /* 47275 */
	"PERFMON_STATE\0" /* 47289 */
	"SPM_PERFMON_STATE\0" /* 47303 */
	"PERFMON_ENABLE_MODE\0" /* 47321 */
	"PERFMON_SAMPLE_ENABLE\0" /* 47341 */
	"DB_CLEAN_USER_DEFINED_MASK\0" /* 47363 */
	"CB_CLEAN_USER_DEFINED_MASK\0" /* 47390 */
	"VGT_BUSY_USER_DEFINED_MASK\0" /* 47417 */
	"TA_BUSY_USER_DEFINED_MASK\0" /* 47444 */
	"SX_BUSY_USER_DEFINED_MASK\0" /* 47470 */
	"SPI_BUSY_USER_DEFINED_MASK\0" /* 47496 */
	"SC_BUSY_USER_DEFINED_MASK\0" /* 47523 */
	"PA_BUSY_USER_DEFINED_MASK\0" /* 47549 */
	"GRBM_BUSY_USER_DEFINED_MASK\0" /* 47575 */
	"DB_BUSY_USER_DEFINED_MASK\0" /* 47603 */
	"CB_BUSY_USER_DEFINED_MASK\0" /* 47629 */
	"CP_BUSY_USER_DEFINED_MASK\0" /* 47655 */
	"IA_BUSY_USER_DEFINED_MASK\0" /* 47681 */
	"GDS_BUSY_USER_DEFINED_MASK\0" /* 47707 */
	"BCI_BUSY_USER_DEFINED_MASK\0" /* 47734 */
	"RLC_BUSY_USER_DEFINED_MASK\0" /* 47761 */
	"TC_BUSY_USER_DEFINED_MASK\0" /* 47788 */
	"WD_BUSY_USER_DEFINED_MASK\0" /* 47814 */
	"PERF_MODE\0" /* 47840 */
	"PERF_MODE1\0" /* 47850 */
	"PERF_MODE3\0" /* 47861 */
	"PERF_MODE2\0" /* 47872 */
	"PERF_SEID_IGNORE_MASK\0" /* 47883 */
	"BIN0_MIN\0" /* 47905 */
	"BIN0_MAX\0" /* 47914 */
	"BIN1_MIN\0" /* 47923 */
	"BIN1_MAX\0" /* 47932 */
	"BIN2_MIN\0" /* 47941 */
	"BIN2_MAX\0" /* 47950 */
	"BIN3_MIN\0" /* 47959 */
	"BIN3_MAX\0" /* 47968 */
	"SQC_BANK_MASK\0" /* 47977 */
	"SQC_CLIENT_MASK\0" /* 47991 */
	"SPM_MODE\0" /* 48007 */
	"SIMD_MASK\0" /* 48016 */
	"PS_EN\0" /* 48026 */
	"VS_EN\0" /* 48032 */
	"GS_EN\0" /* 48038 */
	"HS_EN\0" /* 48044 */
	"LS_EN\0" /* 48050 */
	"CS_EN\0" /* 48056 */
	"CNTR_RATE\0" /* 48062 */
	"DISABLE_FLUSH\0" /* 48072 */
	"SH0_MASK\0" /* 48086 */
	"SH1_MASK\0" /* 48095 */
	"FORCE_EN\0" /* 48104 */
	"PERFCOUNTER_SELECT1\0" /* 48113 */
	"PERFCOUNTER_SELECT2\0" /* 48133 */
	"PERFCOUNTER_SELECT3\0" /* 48153 */
	"OP_FILTER_ENABLE\0" /* 48173 */
	"OP_FILTER_SEL\0" /* 48190 */
	"FORMAT_FILTER_ENABLE\0" /* 48204 */
	"FORMAT_FILTER_SEL\0" /* 48225 */
	"CLEAR_FILTER_ENABLE\0" /* 48243 */
	"CLEAR_FILTER_SEL\0" /* 48263 */
	"MRT_FILTER_ENABLE\0" /* 48280 */
	"MRT_FILTER_SEL\0" /* 48298 */
	"NUM_SAMPLES_FILTER_ENABLE\0" /* 48313 */
	"NUM_SAMPLES_FILTER_SEL\0" /* 48339 */
	"NUM_FRAGMENTS_FILTER_ENABLE\0" /* 48362 */
	"NUM_FRAGMENTS_FILTER_SEL\0" /* 48390 */
	"DEPTH_CLEAR_ENABLE\0" /* 48415 */
	"STENCIL_CLEAR_ENABLE\0" /* 48434 */
	"DEPTH_COPY\0" /* 48455 */
	"STENCIL_COPY\0" /* 48466 */
	"RESUMMARIZE_ENABLE\0" /* 48479 */
	"STENCIL_COMPRESS_DISABLE\0" /* 48498 */
	"DEPTH_COMPRESS_DISABLE\0" /* 48523 */
	"COPY_CENTROID\0" /* 48546 */
	"COPY_SAMPLE\0" /* 48560 */
	"DECOMPRESS_ENABLE\0" /* 48572 */
	"ZPASS_INCREMENT_DISABLE\0" /* 48590 */
	"PERFECT_ZPASS_COUNTS\0" /* 48614 */
	"SAMPLE_RATE\0" /* 48635 */
	"ZPASS_ENABLE\0" /* 48647 */
	"ZFAIL_ENABLE\0" /* 48660 */
	"SFAIL_ENABLE\0" /* 48673 */
	"DBFAIL_ENABLE\0" /* 48686 */
	"SLICE_EVEN_ENABLE\0" /* 48700 */
	"SLICE_ODD_ENABLE\0" /* 48718 */
	"SLICE_START\0" /* 48735 */
	"SLICE_MAX\0" /* 48747 */
	"Z_READ_ONLY\0" /* 48757 */
	"STENCIL_READ_ONLY\0" /* 48769 */
	"FORCE_OFF\0" /* 48787 */
	"FORCE_ENABLE\0" /* 48797 */
	"FORCE_DISABLE\0" /* 48810 */
	"FORCE_RESERVED\0" /* 48824 */
	"FORCE_HIZ_ENABLE\0" /* 48839, 48847 */
	"FORCE_HIS_ENABLE0\0" /* 48856, 48866 */
	"FORCE_HIS_ENABLE1\0" /* 48874, 48884 */
	"FORCE_SHADER_Z_ORDER\0" /* 48892, 48905 */
	"FAST_Z_DISABLE\0" /* 48913 */
	"FAST_STENCIL_DISABLE\0" /* 48928 */
	"NOOP_CULL_DISABLE\0" /* 48949 */
	"FORCE_COLOR_KILL\0" /* 48967 */
	"FORCE_Z_READ\0" /* 48984 */
	"FORCE_STENCIL_READ\0" /* 48997 */
	"FORCE_FULL_Z_RANGE\0" /* 49016 */
	"FORCE_QC_SMASK_CONFLICT\0" /* 49035 */
	"DISABLE_VIEWPORT_CLAMP\0" /* 49059 */
	"IGNORE_SC_ZRANGE\0" /* 49082 */
	"DISABLE_FULLY_COVERED\0" /* 49099 */
	"FORCE_SUMM_OFF\0" /* 49121 */
	"FORCE_SUMM_MINZ\0" /* 49136 */
	"FORCE_SUMM_MAXZ\0" /* 49152 */
	"FORCE_SUMM_BOTH\0" /* 49168 */
	"FORCE_Z_LIMIT_SUMM\0" /* 49184 */
	"MAX_TILES_IN_DTT\0" /* 49203 */
	"DISABLE_TILE_RATE_TILES\0" /* 49220 */
	"FORCE_Z_DIRTY\0" /* 49244, 49252 */
	"FORCE_STENCIL_DIRTY\0" /* 49258 */
	"FORCE_Z_VALID\0" /* 49278 */
	"FORCE_STENCIL_VALID\0" /* 49292 */
	"PRESERVE_COMPRESSION\0" /* 49312, 49321 */
	"PSLC_AUTO\0" /* 49333 */
	"PSLC_ON_HANG_ONLY\0" /* 49343 */
	"PSLC_ASAP\0" /* 49361 */
	"PSLC_COUNTDOWN\0" /* 49371 */
	"PARTIAL_SQUAD_LAUNCH_CONTROL\0" /* 49386 */
	"PARTIAL_SQUAD_LAUNCH_COUNTDOWN\0" /* 49415 */
	"DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION\0" /* 49446 */
	"DISABLE_SMEM_EXPCLEAR_OPTIMIZATION\0" /* 49482 */
	"DISABLE_COLOR_ON_VALIDATION\0" /* 49517 */
	"DECOMPRESS_Z_ON_FLUSH\0" /* 49545 */
	"DISABLE_REG_SNOOP\0" /* 49567 */
	"DEPTH_BOUNDS_HIER_DEPTH_DISABLE\0" /* 49585 */
	"SEPARATE_HIZS_FUNC_ENABLE\0" /* 49617 */
	"HIZ_ZFUNC\0" /* 49643, 49647 */
	"HIS_SFUNC_FF\0" /* 49653 */
	"HIS_SFUNC_BF\0" /* 49666 */
	"PRESERVE_ZRANGE\0" /* 49679 */
	"PRESERVE_SRESULTS\0" /* 49695 */
	"DISABLE_FAST_PASS\0" /* 49713 */
	"TL_X\0" /* 49731 */
	"TL_Y\0" /* 49736 */
	"BR_X\0" /* 49741 */
	"BR_Y\0" /* 49746 */
	"ADDR5_SWIZZLE_MASK\0" /* 49751 */
	"ARRAY_PRT_TILED_THIN1\0" /* 49770 */
	"ARRAY_PRT_2D_TILED_THIN1\0" /* 49792 */
	"X_ADDR_SURF_P16_32X32_8X16\0" /* 49817 */
	"X_ADDR_SURF_P16_32X32_16X16\0" /* 49844 */
	"Z_INVALID\0" /* 49872 */
	"Z_16\0" /* 49882 */
	"Z_24\0" /* 49887 */
	"Z_32_FLOAT\0" /* 49892 */
	"NUM_SAMPLES\0" /* 49903 */
	"TILE_MODE_INDEX\0" /* 49915 */
	"DECOMPRESS_ON_N_ZPLANES\0" /* 49931 */
	"ALLOW_EXPCLEAR\0" /* 49955 */
	"READ_SIZE\0" /* 49970 */
	"TILE_SURFACE_ENABLE\0" /* 49980 */
	"CLEAR_DISALLOWED\0" /* 50000 */
	"ZRANGE_PRECISION\0" /* 50017 */
	"STENCIL_INVALID\0" /* 50034 */
	"STENCIL_8\0" /* 50050 */
	"TILE_STENCIL_DISABLE\0" /* 50060 */
	"PITCH_TILE_MAX\0" /* 50081, 50087 */
	"HEIGHT_TILE_MAX\0" /* 50096 */
	"SLICE_TILE_MAX\0" /* 50112 */
	"WINDOW_X_OFFSET\0" /* 50127 */
	"WINDOW_Y_OFFSET\0" /* 50143, 50150 */
	"WINDOW_OFFSET_DISABLE\0" /* 50159 */
	"CLIP_RULE\0" /* 50181 */
	"ER_TRI\0" /* 50191 */
	"ER_RECT\0" /* 50198 */
	"ER_LINE_LR\0" /* 50206 */
	"ER_LINE_RL\0" /* 50217 */
	"ER_LINE_TB\0" /* 50228 */
	"ER_LINE_BT\0" /* 50239 */
	"HW_SCREEN_OFFSET_X\0" /* 50250 */
	"HW_SCREEN_OFFSET_Y\0" /* 50269 */
	"TARGET0_ENABLE\0" /* 50288 */
	"TARGET1_ENABLE\0" /* 50303 */
	"TARGET2_ENABLE\0" /* 50318 */
	"TARGET3_ENABLE\0" /* 50333 */
	"TARGET4_ENABLE\0" /* 50348 */
	"TARGET5_ENABLE\0" /* 50363 */
	"TARGET6_ENABLE\0" /* 50378 */
	"TARGET7_ENABLE\0" /* 50393 */
	"OUTPUT0_ENABLE\0" /* 50408 */
	"OUTPUT1_ENABLE\0" /* 50423 */
	"OUTPUT2_ENABLE\0" /* 50438 */
	"OUTPUT3_ENABLE\0" /* 50453 */
	"OUTPUT4_ENABLE\0" /* 50468 */
	"OUTPUT5_ENABLE\0" /* 50483 */
	"OUTPUT6_ENABLE\0" /* 50498 */
	"OUTPUT7_ENABLE\0" /* 50513 */
	"RASTER_CONFIG_RB_MAP_0\0" /* 50528 */
	"RASTER_CONFIG_RB_MAP_1\0" /* 50551 */
	"RASTER_CONFIG_RB_MAP_2\0" /* 50574 */
	"RASTER_CONFIG_RB_MAP_3\0" /* 50597 */
	"RB_MAP_PKR0\0" /* 50620 */
	"RB_MAP_PKR1\0" /* 50632 */
	"RASTER_CONFIG_RB_XSEL2_0\0" /* 50644 */
	"RASTER_CONFIG_RB_XSEL2_1\0" /* 50669 */
	"RASTER_CONFIG_RB_XSEL2_2\0" /* 50694 */
	"RASTER_CONFIG_RB_XSEL2_3\0" /* 50719 */
	"RB_XSEL2\0" /* 50744 */
	"RB_XSEL\0" /* 50753 */
	"RB_YSEL\0" /* 50761 */
	"RASTER_CONFIG_PKR_MAP_0\0" /* 50769 */
	"RASTER_CONFIG_PKR_MAP_1\0" /* 50793 */
	"RASTER_CONFIG_PKR_MAP_2\0" /* 50817 */
	"RASTER_CONFIG_PKR_MAP_3\0" /* 50841 */
	"PKR_MAP\0" /* 50865 */
	"RASTER_CONFIG_PKR_XSEL_0\0" /* 50873 */
	"RASTER_CONFIG_PKR_XSEL_1\0" /* 50898 */
	"RASTER_CONFIG_PKR_XSEL_2\0" /* 50923 */
	"RASTER_CONFIG_PKR_XSEL_3\0" /* 50948 */
	"PKR_XSEL\0" /* 50973 */
	"RASTER_CONFIG_PKR_YSEL_0\0" /* 50982 */
	"RASTER_CONFIG_PKR_YSEL_1\0" /* 51007 */
	"RASTER_CONFIG_PKR_YSEL_2\0" /* 51032 */
	"RASTER_CONFIG_PKR_YSEL_3\0" /* 51057 */
	"PKR_YSEL\0" /* 51082 */
	"RASTER_CONFIG_PKR_XSEL2_0\0" /* 51091 */
	"RASTER_CONFIG_PKR_XSEL2_1\0" /* 51117 */
	"RASTER_CONFIG_PKR_XSEL2_2\0" /* 51143 */
	"RASTER_CONFIG_PKR_XSEL2_3\0" /* 51169 */
	"PKR_XSEL2\0" /* 51195 */
	"RASTER_CONFIG_SC_MAP_0\0" /* 51205 */
	"RASTER_CONFIG_SC_MAP_1\0" /* 51228 */
	"RASTER_CONFIG_SC_MAP_2\0" /* 51251 */
	"RASTER_CONFIG_SC_MAP_3\0" /* 51274 */
	"SC_MAP\0" /* 51297 */
	"RASTER_CONFIG_SC_XSEL_8_WIDE_TILE\0" /* 51304 */
	"RASTER_CONFIG_SC_XSEL_16_WIDE_TILE\0" /* 51338 */
	"RASTER_CONFIG_SC_XSEL_32_WIDE_TILE\0" /* 51373 */
	"RASTER_CONFIG_SC_XSEL_64_WIDE_TILE\0" /* 51408 */
	"SC_XSEL\0" /* 51443 */
	"RASTER_CONFIG_SC_YSEL_8_WIDE_TILE\0" /* 51451 */
	"RASTER_CONFIG_SC_YSEL_16_WIDE_TILE\0" /* 51485 */
	"RASTER_CONFIG_SC_YSEL_32_WIDE_TILE\0" /* 51520 */
	"RASTER_CONFIG_SC_YSEL_64_WIDE_TILE\0" /* 51555 */
	"SC_YSEL\0" /* 51590 */
	"RASTER_CONFIG_SE_MAP_0\0" /* 51598 */
	"RASTER_CONFIG_SE_MAP_1\0" /* 51621 */
	"RASTER_CONFIG_SE_MAP_2\0" /* 51644 */
	"RASTER_CONFIG_SE_MAP_3\0" /* 51667 */
	"SE_MAP\0" /* 51690 */
	"RASTER_CONFIG_SE_XSEL_8_WIDE_TILE\0" /* 51697 */
	"RASTER_CONFIG_SE_XSEL_16_WIDE_TILE\0" /* 51731 */
	"RASTER_CONFIG_SE_XSEL_32_WIDE_TILE\0" /* 51766 */
	"RASTER_CONFIG_SE_XSEL_64_WIDE_TILE\0" /* 51801 */
	"SE_XSEL_GFX6\0" /* 51836 */
	"RASTER_CONFIG_SE_YSEL_8_WIDE_TILE\0" /* 51849 */
	"RASTER_CONFIG_SE_YSEL_16_WIDE_TILE\0" /* 51883 */
	"RASTER_CONFIG_SE_YSEL_32_WIDE_TILE\0" /* 51918 */
	"RASTER_CONFIG_SE_YSEL_64_WIDE_TILE\0" /* 51953 */
	"SE_YSEL_GFX6\0" /* 51988 */
	"RASTER_CONFIG_SE_PAIR_MAP_0\0" /* 52001 */
	"RASTER_CONFIG_SE_PAIR_MAP_1\0" /* 52029 */
	"RASTER_CONFIG_SE_PAIR_MAP_2\0" /* 52057 */
	"RASTER_CONFIG_SE_PAIR_MAP_3\0" /* 52085 */
	"SE_PAIR_MAP\0" /* 52113 */
	"RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE\0" /* 52125 */
	"RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE\0" /* 52164 */
	"RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE\0" /* 52204 */
	"RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE\0" /* 52244 */
	"SE_PAIR_XSEL_GFX6\0" /* 52284 */
	"RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE\0" /* 52302 */
	"RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE\0" /* 52341 */
	"RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE\0" /* 52381 */
	"RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE\0" /* 52421 */
	"SE_PAIR_YSEL_GFX6\0" /* 52461 */
	"OVERWRITE_COMBINER_DISABLE\0" /* 52479 */
	"OVERWRITE_COMBINER_MRT_SHARING_DISABLE\0" /* 52506 */
	"OVERWRITE_COMBINER_WATERMARK\0" /* 52545 */
	"STENCIL_KEEP\0" /* 52574 */
	"STENCIL_ZERO\0" /* 52587 */
	"STENCIL_ONES\0" /* 52600 */
	"STENCIL_REPLACE_TEST\0" /* 52613 */
	"STENCIL_REPLACE_OP\0" /* 52634 */
	"STENCIL_ADD_CLAMP\0" /* 52653 */
	"STENCIL_SUB_CLAMP\0" /* 52671 */
	"STENCIL_INVERT\0" /* 52689 */
	"STENCIL_ADD_WRAP\0" /* 52704 */
	"STENCIL_SUB_WRAP\0" /* 52721 */
	"STENCIL_AND\0" /* 52738 */
	"STENCIL_OR\0" /* 52750 */
	"STENCIL_XOR\0" /* 52761 */
	"STENCIL_NAND\0" /* 52773 */
	"STENCIL_NOR\0" /* 52786 */
	"STENCIL_XNOR\0" /* 52798 */
	"STENCILFAIL\0" /* 52811 */
	"STENCILZPASS\0" /* 52823 */
	"STENCILZFAIL\0" /* 52836 */
	"STENCILFAIL_BF\0" /* 52849 */
	"STENCILZPASS_BF\0" /* 52864 */
	"STENCILZFAIL_BF\0" /* 52880 */
	"STENCILTESTVAL\0" /* 52896 */
	"STENCILMASK\0" /* 52911 */
	"STENCILWRITEMASK\0" /* 52923 */
	"STENCILOPVAL\0" /* 52940 */
	"STENCILTESTVAL_BF\0" /* 52953 */
	"STENCILMASK_BF\0" /* 52971 */
	"STENCILWRITEMASK_BF\0" /* 52986 */
	"STENCILOPVAL_BF\0" /* 53006 */
	"X_0_0F\0" /* 53022 */
	"DEFAULT_VAL\0" /* 53029 */
	"FLAT_SHADE\0" /* 53041 */
	"CYL_WRAP\0" /* 53052 */
	"PT_SPRITE_TEX\0" /* 53061 */
	"DUP\0" /* 53075 */
	"FP16_INTERP_MODE\0" /* 53079 */
	"USE_DEFAULT_ATTR1\0" /* 53096 */
	"DEFAULT_VAL_ATTR1\0" /* 53114 */
	"PT_SPRITE_TEX_ATTR1\0" /* 53132 */
	"ATTR0_VALID\0" /* 53152 */
	"ATTR1_VALID\0" /* 53164 */
	"VS_EXPORT_COUNT\0" /* 53176 */
	"VS_HALF_PACK\0" /* 53192 */
	"VS_EXPORTS_FOG\0" /* 53205 */
	"VS_OUT_FOG_VEC_ADDR\0" /* 53220 */
	"PERSP_SAMPLE_ENA\0" /* 53240 */
	"PERSP_CENTER_ENA\0" /* 53257 */
	"PERSP_CENTROID_ENA\0" /* 53274 */
	"PERSP_PULL_MODEL_ENA\0" /* 53293 */
	"LINEAR_SAMPLE_ENA\0" /* 53314 */
	"LINEAR_CENTER_ENA\0" /* 53332 */
	"LINEAR_CENTROID_ENA\0" /* 53350 */
	"LINE_STIPPLE_TEX_ENA\0" /* 53370 */
	"POS_X_FLOAT_ENA\0" /* 53391 */
	"POS_Y_FLOAT_ENA\0" /* 53407 */
	"POS_Z_FLOAT_ENA\0" /* 53423 */
	"POS_W_FLOAT_ENA\0" /* 53439 */
	"FRONT_FACE_ENA\0" /* 53455 */
	"ANCILLARY_ENA\0" /* 53470 */
	"SAMPLE_COVERAGE_ENA\0" /* 53484 */
	"POS_FIXED_PT_ENA\0" /* 53504 */
	"FLAT_SHADE_ENA\0" /* 53521 */
	"PNT_SPRITE_ENA\0" /* 53536 */
	"SPI_PNT_SPRITE_SEL_0\0" /* 53551 */
	"SPI_PNT_SPRITE_SEL_1\0" /* 53572 */
	"SPI_PNT_SPRITE_SEL_S\0" /* 53593 */
	"SPI_PNT_SPRITE_SEL_T\0" /* 53614 */
	"SPI_PNT_SPRITE_SEL_NONE\0" /* 53635 */
	"PNT_SPRITE_OVRD_X\0" /* 53659 */
	"PNT_SPRITE_OVRD_Y\0" /* 53677 */
	"PNT_SPRITE_OVRD_Z\0" /* 53695 */
	"PNT_SPRITE_OVRD_W\0" /* 53713 */
	"PNT_SPRITE_TOP_1\0" /* 53731 */
	"NUM_INTERP\0" /* 53748 */
	"PARAM_GEN\0" /* 53759 */
	"FOG_ADDR\0" /* 53769 */
	"BC_OPTIMIZE_DISABLE\0" /* 53778 */
	"PASS_FOG_THROUGH_PS\0" /* 53798 */
	"PERSP_CENTER_CNTL\0" /* 53818 */
	"PERSP_CENTROID_CNTL\0" /* 53836 */
	"LINEAR_CENTER_CNTL\0" /* 53856 */
	"LINEAR_CENTROID_CNTL\0" /* 53875 */
	"X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT\0" /* 53896 */
	"POS_FLOAT_LOCATION\0" /* 53945 */
	"POS_FLOAT_ULC\0" /* 53964 */
	"FRONT_FACE_ALL_BITS\0" /* 53978 */
	"NUM_PS_WAVES\0" /* 53998 */
	"NUM_VS_WAVES\0" /* 54011 */
	"NUM_GS_WAVES\0" /* 54024 */
	"NUM_ES_WAVES\0" /* 54037 */
	"NUM_HS_WAVES\0" /* 54050 */
	"NUM_LS_WAVES\0" /* 54063 */
	"SPI_SHADER_NONE\0" /* 54076 */
	"SPI_SHADER_1COMP\0" /* 54092 */
	"SPI_SHADER_2COMP\0" /* 54109 */
	"SPI_SHADER_4COMPRESS\0" /* 54126 */
	"SPI_SHADER_4COMP\0" /* 54147 */
	"POS0_EXPORT_FORMAT\0" /* 54164 */
	"POS1_EXPORT_FORMAT\0" /* 54183 */
	"POS2_EXPORT_FORMAT\0" /* 54202 */
	"POS3_EXPORT_FORMAT\0" /* 54221 */
	"SPI_SHADER_ZERO\0" /* 54240 */
	"SPI_SHADER_32_R\0" /* 54256 */
	"SPI_SHADER_32_GR\0" /* 54272 */
	"SPI_SHADER_32_AR\0" /* 54289 */
	"SPI_SHADER_FP16_ABGR\0" /* 54306 */
	"SPI_SHADER_UNORM16_ABGR\0" /* 54327 */
	"SPI_SHADER_SNORM16_ABGR\0" /* 54351 */
	"SPI_SHADER_UINT16_ABGR\0" /* 54375 */
	"SPI_SHADER_SINT16_ABGR\0" /* 54398 */
	"SPI_SHADER_32_ABGR\0" /* 54421 */
	"Z_EXPORT_FORMAT\0" /* 54440 */
	"COL0_EXPORT_FORMAT\0" /* 54456 */
	"COL1_EXPORT_FORMAT\0" /* 54475 */
	"COL2_EXPORT_FORMAT\0" /* 54494 */
	"COL3_EXPORT_FORMAT\0" /* 54513 */
	"COL4_EXPORT_FORMAT\0" /* 54532 */
	"COL5_EXPORT_FORMAT\0" /* 54551 */
	"COL6_EXPORT_FORMAT\0" /* 54570 */
	"COL7_EXPORT_FORMAT\0" /* 54589 */
	"SX_RT_EXPORT_NO_CONVERSION\0" /* 54608 */
	"SX_RT_EXPORT_32_R\0" /* 54635 */
	"SX_RT_EXPORT_32_A\0" /* 54653 */
	"SX_RT_EXPORT_10_11_11\0" /* 54671 */
	"SX_RT_EXPORT_2_10_10_10\0" /* 54693 */
	"SX_RT_EXPORT_8_8_8_8\0" /* 54717 */
	"SX_RT_EXPORT_5_6_5\0" /* 54738 */
	"SX_RT_EXPORT_1_5_5_5\0" /* 54757 */
	"SX_RT_EXPORT_4_4_4_4\0" /* 54778 */
	"SX_RT_EXPORT_16_16_GR\0" /* 54799 */
	"SX_RT_EXPORT_16_16_AR\0" /* 54821 */
	"MRT0\0" /* 54843 */
	"MRT1\0" /* 54848 */
	"MRT2\0" /* 54853 */
	"MRT3\0" /* 54858 */
	"MRT4\0" /* 54863 */
	"MRT5\0" /* 54868 */
	"MRT6\0" /* 54873 */
	"MRT7\0" /* 54878 */
	"EXACT\0" /* 54883 */
	"11BIT_FORMAT\0" /* 54889 */
	"10BIT_FORMAT\0" /* 54902 */
	"8BIT_FORMAT\0" /* 54915 */
	"6BIT_FORMAT\0" /* 54927 */
	"5BIT_FORMAT\0" /* 54939 */
	"4BIT_FORMAT\0" /* 54951 */
	"MRT0_EPSILON\0" /* 54963 */
	"MRT1_EPSILON\0" /* 54976 */
	"MRT2_EPSILON\0" /* 54989 */
	"MRT3_EPSILON\0" /* 55002 */
	"MRT4_EPSILON\0" /* 55015 */
	"MRT5_EPSILON\0" /* 55028 */
	"MRT6_EPSILON\0" /* 55041 */
	"MRT7_EPSILON\0" /* 55054 */
	"MRT0_COLOR_OPT_DISABLE\0" /* 55067 */
	"MRT0_ALPHA_OPT_DISABLE\0" /* 55090 */
	"MRT1_COLOR_OPT_DISABLE\0" /* 55113 */
	"MRT1_ALPHA_OPT_DISABLE\0" /* 55136 */
	"MRT2_COLOR_OPT_DISABLE\0" /* 55159 */
	"MRT2_ALPHA_OPT_DISABLE\0" /* 55182 */
	"MRT3_COLOR_OPT_DISABLE\0" /* 55205 */
	"MRT3_ALPHA_OPT_DISABLE\0" /* 55228 */
	"MRT4_COLOR_OPT_DISABLE\0" /* 55251 */
	"MRT4_ALPHA_OPT_DISABLE\0" /* 55274 */
	"MRT5_COLOR_OPT_DISABLE\0" /* 55297 */
	"MRT5_ALPHA_OPT_DISABLE\0" /* 55320 */
	"MRT6_COLOR_OPT_DISABLE\0" /* 55343 */
	"MRT6_ALPHA_OPT_DISABLE\0" /* 55366 */
	"MRT7_COLOR_OPT_DISABLE\0" /* 55389 */
	"MRT7_ALPHA_OPT_DISABLE\0" /* 55412 */
	"PIXEN_ZERO_OPT_DISABLE\0" /* 55435 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_ALL\0" /* 55458 */
	"BLEND_OPT_PRESERVE_ALL_IGNORE_NONE\0" /* 55493 */
	"BLEND_OPT_PRESERVE_C1_IGNORE_C0\0" /* 55528 */
	"BLEND_OPT_PRESERVE_C0_IGNORE_C1\0" /* 55560 */
	"BLEND_OPT_PRESERVE_A1_IGNORE_A0\0" /* 55592 */
	"BLEND_OPT_PRESERVE_A0_IGNORE_A1\0" /* 55624 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_A0\0" /* 55656 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_NONE\0" /* 55690 */
	"COLOR_SRC_OPT\0" /* 55726 */
	"COLOR_DST_OPT\0" /* 55740 */
	"OPT_COMB_NONE\0" /* 55754 */
	"OPT_COMB_ADD\0" /* 55768 */
	"OPT_COMB_SUBTRACT\0" /* 55781 */
	"OPT_COMB_MIN\0" /* 55799 */
	"OPT_COMB_MAX\0" /* 55812 */
	"OPT_COMB_REVSUBTRACT\0" /* 55825 */
	"OPT_COMB_BLEND_DISABLED\0" /* 55846 */
	"OPT_COMB_SAFE_ADD\0" /* 55870 */
	"COLOR_COMB_FCN\0" /* 55888 */
	"ALPHA_SRC_OPT\0" /* 55903 */
	"ALPHA_DST_OPT\0" /* 55917 */
	"ALPHA_COMB_FCN\0" /* 55931 */
	"BLEND_ZERO\0" /* 55946 */
	"BLEND_ONE\0" /* 55957 */
	"BLEND_SRC_COLOR\0" /* 55967 */
	"BLEND_ONE_MINUS_SRC_COLOR\0" /* 55983 */
	"BLEND_SRC_ALPHA\0" /* 56009 */
	"BLEND_ONE_MINUS_SRC_ALPHA\0" /* 56025 */
	"BLEND_DST_ALPHA\0" /* 56051 */
	"BLEND_ONE_MINUS_DST_ALPHA\0" /* 56067 */
	"BLEND_DST_COLOR\0" /* 56093 */
	"BLEND_ONE_MINUS_DST_COLOR\0" /* 56109 */
	"BLEND_SRC_ALPHA_SATURATE\0" /* 56135 */
	"BLEND_CONSTANT_COLOR\0" /* 56160 */
	"BLEND_ONE_MINUS_CONSTANT_COLOR\0" /* 56181 */
	"BLEND_SRC1_COLOR\0" /* 56212 */
	"BLEND_INV_SRC1_COLOR\0" /* 56229 */
	"BLEND_SRC1_ALPHA\0" /* 56250 */
	"BLEND_INV_SRC1_ALPHA\0" /* 56267 */
	"BLEND_CONSTANT_ALPHA\0" /* 56288 */
	"BLEND_ONE_MINUS_CONSTANT_ALPHA\0" /* 56309 */
	"COLOR_SRCBLEND\0" /* 56340 */
	"COMB_DST_PLUS_SRC\0" /* 56355 */
	"COMB_SRC_MINUS_DST\0" /* 56373 */
	"COMB_MIN_DST_SRC\0" /* 56392 */
	"COMB_MAX_DST_SRC\0" /* 56409 */
	"COMB_DST_MINUS_SRC\0" /* 56426 */
	"COLOR_DESTBLEND\0" /* 56445 */
	"ALPHA_SRCBLEND\0" /* 56461 */
	"ALPHA_DESTBLEND\0" /* 56476 */
	"SEPARATE_ALPHA_BLEND\0" /* 56492 */
	"DISABLE_ROP3\0" /* 56513, 56521 */
	"SRC_STATE_ID\0" /* 56526 */
	"BASE_ADDR_GFX6\0" /* 56539 */
	"DI_SRC_SEL_DMA\0" /* 56554 */
	"DI_SRC_SEL_IMMEDIATE\0" /* 56569 */
	"DI_SRC_SEL_AUTO_INDEX\0" /* 56590 */
	"DI_SRC_SEL_RESERVED\0" /* 56612 */
	"SOURCE_SELECT\0" /* 56632 */
	"DI_MAJOR_MODE_0\0" /* 56646 */
	"DI_MAJOR_MODE_1\0" /* 56662 */
	"MAJOR_MODE\0" /* 56678 */
	"NOT_EOP\0" /* 56689 */
	"USE_OPAQUE\0" /* 56697 */
	"ADDRESS_LOW\0" /* 56708 */
	"STENCIL_ENABLE\0" /* 56720 */
	"Z_WRITE_ENABLE\0" /* 56735 */
	"DEPTH_BOUNDS_ENABLE\0" /* 56750 */
	"FRAG_NEVER\0" /* 56770 */
	"FRAG_LESS\0" /* 56781 */
	"FRAG_EQUAL\0" /* 56791 */
	"FRAG_LEQUAL\0" /* 56802 */
	"FRAG_GREATER\0" /* 56814 */
	"FRAG_NOTEQUAL\0" /* 56827 */
	"FRAG_GEQUAL\0" /* 56841 */
	"FRAG_ALWAYS\0" /* 56853 */
	"BACKFACE_ENABLE\0" /* 56865 */
	"REF_NEVER\0" /* 56881 */
	"REF_LESS\0" /* 56891 */
	"REF_EQUAL\0" /* 56900 */
	"REF_LEQUAL\0" /* 56910 */
	"REF_GREATER\0" /* 56921 */
	"REF_NOTEQUAL\0" /* 56933 */
	"REF_GEQUAL\0" /* 56946 */
	"REF_ALWAYS\0" /* 56957 */
	"STENCILFUNC\0" /* 56968 */
	"STENCILFUNC_BF\0" /* 56980 */
	"ENABLE_COLOR_WRITES_ON_DEPTH_FAIL\0" /* 56995 */
	"DISABLE_COLOR_WRITES_ON_DEPTH_PASS\0" /* 57029 */
	"MAX_ANCHOR_SAMPLES\0" /* 57064 */
	"PS_ITER_SAMPLES\0" /* 57083 */
	"MASK_EXPORT_NUM_SAMPLES\0" /* 57099 */
	"ALPHA_TO_MASK_NUM_SAMPLES\0" /* 57123 */
	"HIGH_QUALITY_INTERSECTIONS\0" /* 57149 */
	"INCOHERENT_EQAA_READS\0" /* 57176 */
	"INTERPOLATE_COMP_Z\0" /* 57198 */
	"INTERPOLATE_SRC_Z\0" /* 57217 */
	"STATIC_ANCHOR_ASSOCIATIONS\0" /* 57235 */
	"ALPHA_TO_MASK_EQAA_DISABLE\0" /* 57262 */
	"OVERRASTERIZATION_AMOUNT\0" /* 57289 */
	"ENABLE_POSTZ_OVERRASTERIZATION\0" /* 57314 */
	"DISABLE_DUAL_QUAD\0" /* 57345 */
	"DEGAMMA_ENABLE\0" /* 57363 */
	"CB_DISABLE\0" /* 57378 */
	"CB_NORMAL\0" /* 57389 */
	"CB_ELIMINATE_FAST_CLEAR\0" /* 57399, 57412 */
	"CB_RESOLVE\0" /* 57423 */
	"CB_FMASK_DECOMPRESS\0" /* 57434 */
	"CB_DCC_DECOMPRESS\0" /* 57454 */
	"ROP3_CLEAR\0" /* 57472 */
	"ROP3_NOR\0" /* 57483 */
	"ROP3_AND_INVERTED\0" /* 57492 */
	"ROP3_COPY_INVERTED\0" /* 57510 */
	"ROP3_AND_REVERSE\0" /* 57529 */
	"ROP3_INVERT\0" /* 57546 */
	"ROP3_XOR\0" /* 57558 */
	"ROP3_NAND\0" /* 57567 */
	"ROP3_AND\0" /* 57577 */
	"ROP3_EQUIVALENT\0" /* 57586 */
	"ROP3_NO_OP\0" /* 57602 */
	"ROP3_OR_INVERTED\0" /* 57613 */
	"ROP3_COPY\0" /* 57630 */
	"ROP3_OR_REVERSE\0" /* 57640 */
	"ROP3_OR\0" /* 57656 */
	"ROP3_SET\0" /* 57664 */
	"Z_EXPORT_ENABLE\0" /* 57673 */
	"STENCIL_TEST_VAL_EXPORT_ENABLE\0" /* 57689 */
	"STENCIL_OP_VAL_EXPORT_ENABLE\0" /* 57720 */
	"LATE_Z\0" /* 57749 */
	"EARLY_Z_THEN_LATE_Z\0" /* 57756 */
	"RE_Z\0" /* 57776 */
	"EARLY_Z_THEN_RE_Z\0" /* 57781 */
	"KILL_ENABLE\0" /* 57799 */
	"COVERAGE_TO_MASK_ENABLE\0" /* 57811 */
	"MASK_EXPORT_ENABLE\0" /* 57835 */
	"EXEC_ON_HIER_FAIL\0" /* 57854 */
	"EXEC_ON_NOOP\0" /* 57872 */
	"ALPHA_TO_MASK_DISABLE\0" /* 57885 */
	"DEPTH_BEFORE_SHADER\0" /* 57907 */
	"EXPORT_ANY_Z\0" /* 57927 */
	"EXPORT_LESS_THAN_Z\0" /* 57940 */
	"EXPORT_GREATER_THAN_Z\0" /* 57959 */
	"EXPORT_RESERVED\0" /* 57981 */
	"CONSERVATIVE_Z_EXPORT\0" /* 57997 */
	"DUAL_QUAD_DISABLE\0" /* 58019 */
	"UCP_ENA_0\0" /* 58037 */
	"UCP_ENA_1\0" /* 58047 */
	"UCP_ENA_2\0" /* 58057 */
	"UCP_ENA_3\0" /* 58067 */
	"UCP_ENA_4\0" /* 58077 */
	"UCP_ENA_5\0" /* 58087 */
	"PS_UCP_Y_SCALE_NEG\0" /* 58097 */
	"PS_UCP_MODE\0" /* 58116 */
	"CLIP_DISABLE\0" /* 58128 */
	"UCP_CULL_ONLY_ENA\0" /* 58141 */
	"BOUNDARY_EDGE_FLAG_ENA\0" /* 58159 */
	"DX_CLIP_SPACE_DEF\0" /* 58182 */
	"DIS_CLIP_ERR_DETECT\0" /* 58200 */
	"VTX_KILL_OR\0" /* 58220 */
	"DX_RASTERIZATION_KILL\0" /* 58232 */
	"DX_LINEAR_ATTR_CLIP_ENA\0" /* 58254 */
	"VTE_VPORT_PROVOKE_DISABLE\0" /* 58278 */
	"ZCLIP_NEAR_DISABLE\0" /* 58304 */
	"ZCLIP_FAR_DISABLE\0" /* 58323 */
	"CULL_FRONT\0" /* 58341 */
	"CULL_BACK\0" /* 58352 */
	"X_DISABLE_POLY_MODE\0" /* 58362, 58372 */
	"X_DUAL_MODE\0" /* 58382 */
	"X_DRAW_POINTS\0" /* 58394 */
	"X_DRAW_LINES\0" /* 58408 */
	"X_DRAW_TRIANGLES\0" /* 58421 */
	"POLYMODE_FRONT_PTYPE\0" /* 58438 */
	"POLYMODE_BACK_PTYPE\0" /* 58459 */
	"POLY_OFFSET_FRONT_ENABLE\0" /* 58479 */
	"POLY_OFFSET_BACK_ENABLE\0" /* 58504 */
	"POLY_OFFSET_PARA_ENABLE\0" /* 58528 */
	"VTX_WINDOW_OFFSET_ENABLE\0" /* 58552 */
	"PROVOKING_VTX_LAST\0" /* 58577 */
	"PERSP_CORR_DIS\0" /* 58596 */
	"MULTI_PRIM_IB_ENA\0" /* 58611 */
	"VPORT_X_SCALE_ENA\0" /* 58629 */
	"VPORT_X_OFFSET_ENA\0" /* 58647 */
	"VPORT_Y_SCALE_ENA\0" /* 58666 */
	"VPORT_Y_OFFSET_ENA\0" /* 58684 */
	"VPORT_Z_SCALE_ENA\0" /* 58703 */
	"VPORT_Z_OFFSET_ENA\0" /* 58721 */
	"VTX_XY_FMT\0" /* 58740 */
	"VTX_Z_FMT\0" /* 58751 */
	"VTX_W0_FMT\0" /* 58761 */
	"CLIP_DIST_ENA_0\0" /* 58772 */
	"CLIP_DIST_ENA_1\0" /* 58788 */
	"CLIP_DIST_ENA_2\0" /* 58804 */
	"CLIP_DIST_ENA_3\0" /* 58820 */
	"CLIP_DIST_ENA_4\0" /* 58836 */
	"CLIP_DIST_ENA_5\0" /* 58852 */
	"CLIP_DIST_ENA_6\0" /* 58868 */
	"CLIP_DIST_ENA_7\0" /* 58884 */
	"CULL_DIST_ENA_0\0" /* 58900 */
	"CULL_DIST_ENA_1\0" /* 58916 */
	"CULL_DIST_ENA_2\0" /* 58932 */
	"CULL_DIST_ENA_3\0" /* 58948 */
	"CULL_DIST_ENA_4\0" /* 58964 */
	"CULL_DIST_ENA_5\0" /* 58980 */
	"CULL_DIST_ENA_6\0" /* 58996 */
	"CULL_DIST_ENA_7\0" /* 59012 */
	"USE_VTX_POINT_SIZE\0" /* 59028 */
	"USE_VTX_EDGE_FLAG\0" /* 59047 */
	"USE_VTX_RENDER_TARGET_INDX\0" /* 59065 */
	"USE_VTX_VIEWPORT_INDX\0" /* 59092 */
	"USE_VTX_KILL_FLAG\0" /* 59114 */
	"VS_OUT_MISC_VEC_ENA\0" /* 59132 */
	"VS_OUT_CCDIST0_VEC_ENA\0" /* 59152 */
	"VS_OUT_CCDIST1_VEC_ENA\0" /* 59175 */
	"VS_OUT_MISC_SIDE_BUS_ENA\0" /* 59198 */
	"USE_VTX_GS_CUT_FLAG\0" /* 59223 */
	"USE_VTX_LINE_WIDTH\0" /* 59243 */
	"VTE_XY_INF_DISCARD\0" /* 59262 */
	"VTE_Z_INF_DISCARD\0" /* 59281 */
	"VTE_W_INF_DISCARD\0" /* 59299 */
	"VTE_0XNANINF_IS_0\0" /* 59317 */
	"VTE_XY_NAN_RETAIN\0" /* 59335 */
	"VTE_Z_NAN_RETAIN\0" /* 59353 */
	"VTE_W_NAN_RETAIN\0" /* 59370 */
	"VTE_W_RECIP_NAN_IS_0\0" /* 59387 */
	"VS_XY_NAN_TO_INF\0" /* 59408 */
	"VS_XY_INF_RETAIN\0" /* 59425 */
	"VS_Z_NAN_TO_INF\0" /* 59442 */
	"VS_Z_INF_RETAIN\0" /* 59458 */
	"VS_W_NAN_TO_INF\0" /* 59474 */
	"VS_W_INF_RETAIN\0" /* 59490 */
	"VS_CLIP_DIST_INF_DISCARD\0" /* 59506 */
	"VTE_NO_OUTPUT_NEG_0\0" /* 59531 */
	"LINE_STIPPLE_RESET\0" /* 59551 */
	"EXPAND_FULL_LENGTH\0" /* 59570 */
	"FRACTIONAL_ACCUM\0" /* 59589 */
	"DIAMOND_ADJUST\0" /* 59606 */
	"TRIANGLE_FILTER_DISABLE\0" /* 59621 */
	"LINE_FILTER_DISABLE\0" /* 59645 */
	"POINT_FILTER_DISABLE\0" /* 59665 */
	"RECTANGLE_FILTER_DISABLE\0" /* 59686 */
	"TRIANGLE_EXPAND_ENA\0" /* 59711 */
	"LINE_EXPAND_ENA\0" /* 59731 */
	"POINT_EXPAND_ENA\0" /* 59747 */
	"RECTANGLE_EXPAND_ENA\0" /* 59764 */
	"PRIM_EXPAND_CONSTANT\0" /* 59785 */
	"XMAX_RIGHT_EXCLUSION\0" /* 59806 */
	"YMAX_BOTTOM_EXCLUSION\0" /* 59827 */
	"SMALL_PRIM_FILTER_ENABLE\0" /* 59849 */
	"MIN_SIZE\0" /* 59874 */
	"LINE_PATTERN\0" /* 59883 */
	"REPEAT_COUNT\0" /* 59896 */
	"PATTERN_BIT_ORDER\0" /* 59909 */
	"AUTO_RESET_CNTL\0" /* 59927 */
	"VGT_OUTPATH_VTX_REUSE\0" /* 59943 */
	"VGT_OUTPATH_TESS_EN\0" /* 59965 */
	"VGT_OUTPATH_PASSTHRU\0" /* 59985 */
	"VGT_OUTPATH_GS_BLOCK\0" /* 60006 */
	"VGT_OUTPATH_HS_BLOCK\0" /* 60027 */
	"PATH_SELECT\0" /* 60048 */
	"TESS_MODE\0" /* 60060 */
	"VGT_GRP_3D_POINT\0" /* 60070 */
	"VGT_GRP_3D_LINE\0" /* 60087 */
	"VGT_GRP_3D_TRI\0" /* 60103 */
	"VGT_GRP_3D_RECT\0" /* 60118 */
	"VGT_GRP_3D_QUAD\0" /* 60134 */
	"VGT_GRP_2D_COPY_RECT_V0\0" /* 60150 */
	"VGT_GRP_2D_COPY_RECT_V1\0" /* 60174 */
	"VGT_GRP_2D_COPY_RECT_V2\0" /* 60198 */
	"VGT_GRP_2D_COPY_RECT_V3\0" /* 60222 */
	"VGT_GRP_2D_FILL_RECT\0" /* 60246 */
	"VGT_GRP_2D_LINE\0" /* 60267 */
	"VGT_GRP_2D_TRI\0" /* 60283 */
	"VGT_GRP_PRIM_INDEX_LINE\0" /* 60298 */
	"VGT_GRP_PRIM_INDEX_TRI\0" /* 60322 */
	"VGT_GRP_PRIM_INDEX_QUAD\0" /* 60345 */
	"VGT_GRP_3D_LINE_ADJ\0" /* 60369 */
	"VGT_GRP_3D_TRI_ADJ\0" /* 60389 */
	"VGT_GRP_3D_PATCH\0" /* 60408 */
	"RETAIN_ORDER\0" /* 60425 */
	"RETAIN_QUADS\0" /* 60438 */
	"VGT_GRP_LIST\0" /* 60451 */
	"VGT_GRP_STRIP\0" /* 60464 */
	"VGT_GRP_FAN\0" /* 60478 */
	"VGT_GRP_LOOP\0" /* 60490 */
	"VGT_GRP_POLYGON\0" /* 60503 */
	"PRIM_ORDER\0" /* 60519 */
	"COMP_X_EN\0" /* 60530 */
	"COMP_Y_EN\0" /* 60540 */
	"COMP_Z_EN\0" /* 60550 */
	"COMP_W_EN\0" /* 60560 */
	"SHIFT\0" /* 60570 */
	"VGT_GRP_INDEX_16\0" /* 60576 */
	"VGT_GRP_INDEX_32\0" /* 60593 */
	"VGT_GRP_UINT_16\0" /* 60610 */
	"VGT_GRP_UINT_32\0" /* 60626 */
	"VGT_GRP_SINT_16\0" /* 60642 */
	"VGT_GRP_SINT_32\0" /* 60658 */
	"VGT_GRP_FLOAT_32\0" /* 60674 */
	"VGT_GRP_AUTO_PRIM\0" /* 60691 */
	"VGT_GRP_FIX_1_23_TO_FLOAT\0" /* 60709 */
	"X_CONV\0" /* 60735, 60739 */
	"Y_CONV\0" /* 60742 */
	"Z_CONV\0" /* 60749 */
	"Z_OFFSET\0" /* 60756 */
	"W_CONV\0" /* 60765 */
	"GS_OFF\0" /* 60772 */
	"GS_SCENARIO_A\0" /* 60779 */
	"GS_SCENARIO_B\0" /* 60793 */
	"GS_SCENARIO_G\0" /* 60807 */
	"GS_SCENARIO_C\0" /* 60821 */
	"SPRITE_EN\0" /* 60835 */
	"GS_CUT_1024\0" /* 60845 */
	"GS_CUT_512\0" /* 60857 */
	"GS_CUT_256\0" /* 60868 */
	"GS_CUT_128\0" /* 60879 */
	"CUT_MODE\0" /* 60890 */
	"GS_C_PACK_EN\0" /* 60899 */
	"RESERVED_2\0" /* 60912 */
	"ES_PASSTHRU\0" /* 60923 */
	"COMPUTE_MODE\0" /* 60935 */
	"FAST_COMPUTE_MODE\0" /* 60948 */
	"ELEMENT_INFO_EN\0" /* 60966 */
	"PARTIAL_THD_AT_EOI\0" /* 60982 */
	"SUPPRESS_CUTS\0" /* 61001 */
	"ES_WRITE_OPTIMIZE\0" /* 61015 */
	"GS_WRITE_OPTIMIZE\0" /* 61033 */
	"X_0_OFFCHIP_GS\0" /* 61051 */
	"X_3_ES_AND_GS_ARE_ONCHIP\0" /* 61066, 61084 */
	"ES_VERTS_PER_SUBGRP\0" /* 61091 */
	"GS_PRIMS_PER_SUBGRP\0" /* 61111 */
	"MSAA_ENABLE\0" /* 61131 */
	"VPORT_SCISSOR_ENABLE\0" /* 61143 */
	"LINE_STIPPLE_ENABLE\0" /* 61164 */
	"SEND_UNLIT_STILES_TO_PKR\0" /* 61184 */
	"WALK_SIZE\0" /* 61209 */
	"WALK_ALIGNMENT\0" /* 61219 */
	"WALK_ALIGN8_PRIM_FITS_ST\0" /* 61234 */
	"WALK_FENCE_ENABLE\0" /* 61259 */
	"WALK_FENCE_SIZE\0" /* 61277 */
	"SUPERTILE_WALK_ORDER_ENABLE\0" /* 61293, 61298 */
	"TILE_COVER_DISABLE\0" /* 61321 */
	"TILE_COVER_NO_SCISSOR\0" /* 61340 */
	"ZMM_LINE_EXTENT\0" /* 61362 */
	"ZMM_LINE_OFFSET\0" /* 61378 */
	"ZMM_RECT_EXTENT\0" /* 61394 */
	"KILL_PIX_POST_HI_Z\0" /* 61410 */
	"KILL_PIX_POST_DETAIL_MASK\0" /* 61429 */
	"PS_ITER_SAMPLE\0" /* 61455 */
	"MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE\0" /* 61470 */
	"MULTI_GPU_SUPERTILE_ENABLE\0" /* 61510 */
	"GPU_ID_OVERRIDE_ENABLE\0" /* 61537 */
	"GPU_ID_OVERRIDE\0" /* 61560 */
	"MULTI_GPU_PRIM_DISCARD_ENABLE\0" /* 61576 */
	"FORCE_EOV_CNTDWN_ENABLE\0" /* 61606 */
	"FORCE_EOV_REZ_ENABLE\0" /* 61630 */
	"OUT_OF_ORDER_PRIMITIVE_ENABLE\0" /* 61651 */
	"OUT_OF_ORDER_WATER_MARK\0" /* 61681 */
	"OUTPRIM_TYPE_POINTLIST\0" /* 61705 */
	"OUTPRIM_TYPE_LINESTRIP\0" /* 61728 */
	"OUTPRIM_TYPE_TRISTRIP\0" /* 61751 */
	"OUTPRIM_TYPE\0" /* 61773 */
	"OUTPRIM_TYPE_1\0" /* 61786 */
	"OUTPRIM_TYPE_2\0" /* 61801 */
	"OUTPRIM_TYPE_3\0" /* 61816 */
	"UNIQUE_TYPE_PER_STREAM\0" /* 61831 */
	"VGT_INDEX_16\0" /* 61854 */
	"VGT_INDEX_32\0" /* 61867 */
	"VGT_INDEX_8\0" /* 61880 */
	"VGT_DMA_SWAP_NONE\0" /* 61892 */
	"VGT_DMA_SWAP_16_BIT\0" /* 61910 */
	"VGT_DMA_SWAP_32_BIT\0" /* 61930 */
	"VGT_DMA_SWAP_WORD\0" /* 61950 */
	"SWAP_MODE\0" /* 61968 */
	"VGT_DMA_BUF_MEM\0" /* 61978 */
	"VGT_DMA_BUF_RING\0" /* 61994 */
	"VGT_DMA_BUF_SETUP\0" /* 62011 */
	"BUF_TYPE\0" /* 62029 */
	"VGT_POLICY_LRU\0" /* 62038 */
	"VGT_POLICY_STREAM\0" /* 62053 */
	"RDREQ_POLICY_CIK\0" /* 62071 */
	"RDREQ_POLICY\0" /* 62088 */
	"REQ_PATH\0" /* 62101 */
	"DISABLE_RESET_ON_EOI\0" /* 62110 */
	"SAMPLE_STREAMOUTSTATS1\0" /* 62131 */
	"SAMPLE_STREAMOUTSTATS2\0" /* 62154 */
	"SAMPLE_STREAMOUTSTATS3\0" /* 62177 */
	"CACHE_FLUSH_TS\0" /* 62200 */
	"CONTEXT_DONE\0" /* 62215 */
	"CACHE_FLUSH\0" /* 62228 */
	"CS_PARTIAL_FLUSH\0" /* 62240 */
	"VGT_STREAMOUT_SYNC\0" /* 62257 */
	"VGT_STREAMOUT_RESET\0" /* 62276 */
	"END_OF_PIPE_INCR_DE\0" /* 62296 */
	"END_OF_PIPE_IB_END\0" /* 62316 */
	"RST_PIX_CNT\0" /* 62335 */
	"VS_PARTIAL_FLUSH\0" /* 62347 */
	"PS_PARTIAL_FLUSH\0" /* 62364 */
	"FLUSH_HS_OUTPUT\0" /* 62381 */
	"FLUSH_LS_OUTPUT\0" /* 62397 */
	"CACHE_FLUSH_AND_INV_TS_EVENT\0" /* 62413 */
	"ZPASS_DONE\0" /* 62442 */
	"CACHE_FLUSH_AND_INV_EVENT\0" /* 62453 */
	"PERFCOUNTER_START\0" /* 62479 */
	"PERFCOUNTER_STOP\0" /* 62497 */
	"PIPELINESTAT_START\0" /* 62514 */
	"PIPELINESTAT_STOP\0" /* 62533 */
	"PERFCOUNTER_SAMPLE\0" /* 62551 */
	"FLUSH_ES_OUTPUT\0" /* 62570 */
	"FLUSH_GS_OUTPUT\0" /* 62586 */
	"SAMPLE_PIPELINESTAT\0" /* 62602 */
	"SO_VGTSTREAMOUT_FLUSH\0" /* 62622 */
	"SAMPLE_STREAMOUTSTATS\0" /* 62644 */
	"RESET_VTX_CNT\0" /* 62666 */
	"BLOCK_CONTEXT_DONE\0" /* 62680 */
	"CS_CONTEXT_DONE\0" /* 62699 */
	"VGT_FLUSH\0" /* 62715 */
	"SC_SEND_DB_VPZ\0" /* 62725 */
	"BOTTOM_OF_PIPE_TS\0" /* 62740 */
	"DB_CACHE_FLUSH_AND_INV\0" /* 62758 */
	"FLUSH_AND_INV_DB_DATA_TS\0" /* 62781 */
	"FLUSH_AND_INV_DB_META\0" /* 62806 */
	"FLUSH_AND_INV_CB_DATA_TS\0" /* 62828 */
	"FLUSH_AND_INV_CB_META\0" /* 62853 */
	"FLUSH_AND_INV_CB_PIXEL_DATA\0" /* 62875 */
	"THREAD_TRACE_START\0" /* 62903 */
	"THREAD_TRACE_STOP\0" /* 62922 */
	"THREAD_TRACE_MARKER\0" /* 62940 */
	"THREAD_TRACE_FLUSH\0" /* 62960 */
	"THREAD_TRACE_FINISH\0" /* 62979 */
	"PIXEL_PIPE_STAT_CONTROL\0" /* 62999 */
	"PIXEL_PIPE_STAT_DUMP\0" /* 63023 */
	"PIXEL_PIPE_STAT_RESET\0" /* 63044 */
	"EVENT_TYPE\0" /* 63066 */
	"ADDRESS_HI_GFX6\0" /* 63077 */
	"EXTENDED_EVENT\0" /* 63093 */
	"PRIMGROUP_SIZE\0" /* 63108 */
	"PARTIAL_VS_WAVE_ON\0" /* 63123 */
	"SWITCH_ON_EOP\0" /* 63142 */
	"PARTIAL_ES_WAVE_ON\0" /* 63156 */
	"SWITCH_ON_EOI\0" /* 63175 */
	"WD_SWITCH_ON_EOP\0" /* 63189 */
	"MAX_PRIMGRP_IN_WAVE\0" /* 63206 */
	"FULL_CACHE\0" /* 63226 */
	"HTILE_USES_PRELOAD_WIN\0" /* 63237 */
	"PRELOAD\0" /* 63260 */
	"PREFETCH_WIDTH\0" /* 63268 */
	"PREFETCH_HEIGHT\0" /* 63283 */
	"DST_OUTSIDE_ZERO_TO_ONE\0" /* 63299 */
	"TC_COMPATIBLE\0" /* 63323 */
	"COMPAREFUNC0\0" /* 63337 */
	"COMPAREVALUE0\0" /* 63350 */
	"COMPAREMASK0\0" /* 63364 */
	"COMPAREFUNC1\0" /* 63377 */
	"COMPAREVALUE1\0" /* 63390 */
	"COMPAREMASK1\0" /* 63404 */
	"MAX_X\0" /* 63417 */
	"MAX_Y\0" /* 63423 */
	"ACCUM_ISOLINE\0" /* 63429 */
	"ACCUM_TRI\0" /* 63443 */
	"ACCUM_QUAD\0" /* 63453 */
	"DONUT_SPLIT\0" /* 63464 */
	"TRAP_SPLIT\0" /* 63476 */
	"LS_STAGE_OFF\0" /* 63487 */
	"LS_STAGE_ON\0" /* 63500 */
	"CS_STAGE_ON\0" /* 63512 */
	"ES_STAGE_OFF\0" /* 63524 */
	"ES_STAGE_DS\0" /* 63537 */
	"ES_STAGE_REAL\0" /* 63549 */
	"VS_STAGE_REAL\0" /* 63563 */
	"VS_STAGE_DS\0" /* 63577 */
	"VS_STAGE_COPY_SHADER\0" /* 63589 */
	"DYNAMIC_HS\0" /* 63610 */
	"DIS_DEALLOC_ACCUM_0\0" /* 63621 */
	"DIS_DEALLOC_ACCUM_1\0" /* 63641 */
	"VS_WAVE_ID_EN\0" /* 63661 */
	"NUM_PATCHES\0" /* 63675 */
	"HS_NUM_INPUT_CP\0" /* 63687 */
	"HS_NUM_OUTPUT_CP\0" /* 63703 */
	"TESS_ISOLINE\0" /* 63720 */
	"TESS_TRIANGLE\0" /* 63733 */
	"TESS_QUAD\0" /* 63747 */
	"PART_INTEGER\0" /* 63757 */
	"PART_POW2\0" /* 63770 */
	"PART_FRAC_ODD\0" /* 63780 */
	"PART_FRAC_EVEN\0" /* 63794 */
	"PARTITIONING\0" /* 63809 */
	"OUTPUT_POINT\0" /* 63822 */
	"OUTPUT_LINE\0" /* 63835 */
	"OUTPUT_TRIANGLE_CW\0" /* 63847 */
	"OUTPUT_TRIANGLE_CCW\0" /* 63866 */
	"TOPOLOGY\0" /* 63886 */
	"RESERVED_REDUC_AXIS\0" /* 63895 */
	"DEPRECATED\0" /* 63915 */
	"NUM_DS_WAVES_PER_SIMD\0" /* 63926 */
	"DISABLE_DONUTS\0" /* 63948 */
	"VGT_POLICY_BYPASS\0" /* 63963 */
	"DISTRIBUTION_MODE_NO_DIST\0" /* 63981 */
	"DISTRIBUTION_MODE_PATCHES\0" /* 64007 */
	"DISTRIBUTION_MODE_DONUTS\0" /* 64033 */
	"DISTRIBUTION_MODE_TRAPEZOIDS\0" /* 64058 */
	"DISTRIBUTION_MODE\0" /* 64087 */
	"ALPHA_TO_MASK_ENABLE\0" /* 64105 */
	"ALPHA_TO_MASK_OFFSET0\0" /* 64126 */
	"ALPHA_TO_MASK_OFFSET1\0" /* 64148 */
	"ALPHA_TO_MASK_OFFSET2\0" /* 64170 */
	"ALPHA_TO_MASK_OFFSET3\0" /* 64192 */
	"OFFSET_ROUND\0" /* 64214 */
	"POLY_OFFSET_NEG_NUM_DB_BITS\0" /* 64227 */
	"POLY_OFFSET_DB_IS_FLOAT_FMT\0" /* 64255 */
	"STREAMOUT_0_EN\0" /* 64283 */
	"STREAMOUT_1_EN\0" /* 64298 */
	"STREAMOUT_2_EN\0" /* 64313 */
	"STREAMOUT_3_EN\0" /* 64328 */
	"RAST_STREAM\0" /* 64343 */
	"RAST_STREAM_MASK\0" /* 64355 */
	"USE_RAST_STREAM_MASK\0" /* 64372 */
	"STREAM_0_BUFFER_EN\0" /* 64393 */
	"STREAM_1_BUFFER_EN\0" /* 64412 */
	"STREAM_2_BUFFER_EN\0" /* 64431 */
	"STREAM_3_BUFFER_EN\0" /* 64450 */
	"DISTANCE_0\0" /* 64469 */
	"DISTANCE_1\0" /* 64480 */
	"DISTANCE_2\0" /* 64491 */
	"DISTANCE_3\0" /* 64502 */
	"DISTANCE_4\0" /* 64513 */
	"DISTANCE_5\0" /* 64524 */
	"DISTANCE_6\0" /* 64535 */
	"DISTANCE_7\0" /* 64546 */
	"DISTANCE_8\0" /* 64557 */
	"DISTANCE_9\0" /* 64568 */
	"DISTANCE_10\0" /* 64579 */
	"DISTANCE_11\0" /* 64591 */
	"DISTANCE_12\0" /* 64603 */
	"DISTANCE_13\0" /* 64615 */
	"DISTANCE_14\0" /* 64627 */
	"DISTANCE_15\0" /* 64639 */
	"EXPAND_LINE_WIDTH\0" /* 64651 */
	"LAST_PIXEL\0" /* 64669 */
	"PERPENDICULAR_ENDCAP_ENA\0" /* 64680 */
	"DX10_DIAMOND_TEST_ENA\0" /* 64705 */
	"MSAA_NUM_SAMPLES\0" /* 64727 */
	"AA_MASK_CENTROID_DTMN\0" /* 64744 */
	"MAX_SAMPLE_DIST\0" /* 64766 */
	"MSAA_EXPOSED_SAMPLES\0" /* 64782 */
	"DETAIL_TO_EXPOSED_MODE\0" /* 64803 */
	"PIX_CENTER\0" /* 64826 */
	"X_TRUNCATE\0" /* 64837 */
	"X_ROUND\0" /* 64848 */
	"X_ROUND_TO_EVEN\0" /* 64856 */
	"X_ROUND_TO_ODD\0" /* 64872 */
	"ROUND_MODE\0" /* 64887 */
	"X_16_8_FIXED_POINT_1_16TH\0" /* 64898 */
	"X_16_8_FIXED_POINT_1_8TH\0" /* 64924 */
	"X_16_8_FIXED_POINT_1_4TH\0" /* 64949 */
	"X_16_8_FIXED_POINT_1_2\0" /* 64974 */
	"X_16_8_FIXED_POINT_1\0" /* 64997 */
	"X_16_8_FIXED_POINT_1_256TH\0" /* 65018 */
	"X_14_10_FIXED_POINT_1_1024TH\0" /* 65045 */
	"X_12_12_FIXED_POINT_1_4096TH\0" /* 65074 */
	"QUANT_MODE\0" /* 65103 */
	"S0_X\0" /* 65114 */
	"S0_Y\0" /* 65119 */
	"S1_X\0" /* 65124 */
	"S1_Y\0" /* 65129 */
	"S2_X\0" /* 65134 */
	"S2_Y\0" /* 65139 */
	"S3_X\0" /* 65144 */
	"S3_Y\0" /* 65149 */
	"S4_X\0" /* 65154 */
	"S4_Y\0" /* 65159 */
	"S5_X\0" /* 65164 */
	"S5_Y\0" /* 65169 */
	"S6_X\0" /* 65174 */
	"S6_Y\0" /* 65179 */
	"S7_X\0" /* 65184 */
	"S7_Y\0" /* 65189 */
	"S8_X\0" /* 65194 */
	"S8_Y\0" /* 65199 */
	"S9_X\0" /* 65204 */
	"S9_Y\0" /* 65209 */
	"S10_X\0" /* 65214 */
	"S10_Y\0" /* 65220 */
	"S11_X\0" /* 65226 */
	"S11_Y\0" /* 65232 */
	"S12_X\0" /* 65238 */
	"S12_Y\0" /* 65244 */
	"S13_X\0" /* 65250 */
	"S13_Y\0" /* 65256 */
	"S14_X\0" /* 65262 */
	"S14_Y\0" /* 65268 */
	"S15_X\0" /* 65274 */
	"S15_Y\0" /* 65280 */
	"AA_MASK_X0Y0\0" /* 65286 */
	"AA_MASK_X1Y0\0" /* 65299 */
	"AA_MASK_X0Y1\0" /* 65312 */
	"AA_MASK_X1Y1\0" /* 65325 */
	"REALIGN_DQUADS_AFTER_N_WAVES\0" /* 65338 */
	"VTX_REUSE_DEPTH\0" /* 65367 */
	"DEALLOC_DIST\0" /* 65383 */
	"FMASK_TILE_MAX\0" /* 65396 */
	"ENDIAN_NONE\0" /* 65411 */
	"ENDIAN_8IN16\0" /* 65423 */
	"ENDIAN_8IN32\0" /* 65436 */
	"ENDIAN_8IN64\0" /* 65449 */
	"ENDIAN\0" /* 65462 */
	"COLOR_INVALID\0" /* 65469 */
	"COLOR_8\0" /* 65483 */
	"COLOR_16\0" /* 65491 */
	"COLOR_8_8\0" /* 65500 */
	"COLOR_32\0" /* 65510 */
	"COLOR_16_16\0" /* 65519 */
	"COLOR_10_11_11\0" /* 65531 */
	"COLOR_11_11_10\0" /* 65546 */
	"COLOR_10_10_10_2\0" /* 65561 */
	"COLOR_2_10_10_10\0" /* 65578 */
	"COLOR_8_8_8_8\0" /* 65595 */
	"COLOR_32_32\0" /* 65609 */
	"COLOR_16_16_16_16\0" /* 65621 */
	"COLOR_32_32_32_32\0" /* 65639 */
	"COLOR_5_6_5\0" /* 65657 */
	"COLOR_1_5_5_5\0" /* 65669 */
	"COLOR_5_5_5_1\0" /* 65683 */
	"COLOR_4_4_4_4\0" /* 65697 */
	"COLOR_8_24\0" /* 65711 */
	"COLOR_24_8\0" /* 65722 */
	"COLOR_X24_8_32_FLOAT\0" /* 65733 */
	"NUMBER_UNORM\0" /* 65754 */
	"NUMBER_SNORM\0" /* 65767 */
	"NUMBER_UINT\0" /* 65780 */
	"NUMBER_SINT\0" /* 65792 */
	"NUMBER_SRGB\0" /* 65804 */
	"NUMBER_FLOAT\0" /* 65816 */
	"NUMBER_TYPE\0" /* 65829 */
	"SWAP_STD\0" /* 65841 */
	"SWAP_ALT\0" /* 65850 */
	"SWAP_STD_REV\0" /* 65859 */
	"SWAP_ALT_REV\0" /* 65872 */
	"COMP_SWAP\0" /* 65885 */
	"BLEND_CLAMP\0" /* 65895 */
	"BLEND_BYPASS\0" /* 65907 */
	"SIMPLE_FLOAT\0" /* 65920 */
	"CMASK_IS_LINEAR\0" /* 65933 */
	"FORCE_OPT_AUTO\0" /* 65949 */
	"FORCE_OPT_DISABLE\0" /* 65964 */
	"FORCE_OPT_ENABLE_IF_SRC_A_0\0" /* 65982 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_0\0" /* 66010 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_0\0" /* 66040 */
	"FORCE_OPT_ENABLE_IF_SRC_A_1\0" /* 66071 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_1\0" /* 66099 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_1\0" /* 66129 */
	"BLEND_OPT_DONT_RD_DST\0" /* 66160 */
	"BLEND_OPT_DISCARD_PIXEL\0" /* 66182 */
	"FMASK_COMPRESSION_DISABLE\0" /* 66206 */
	"FMASK_COMPRESS_1FRAG_ONLY\0" /* 66232 */
	"DCC_ENABLE\0" /* 66258 */
	"CMASK_ADDR_TYPE\0" /* 66269 */
	"FMASK_TILE_MODE_INDEX\0" /* 66285 */
	"FMASK_BANK_HEIGHT\0" /* 66307 */
	"NUM_FRAGMENTS\0" /* 66325 */
	"FORCE_DST_ALPHA_1\0" /* 66339 */
	"KEY_CLEAR_ENABLE\0" /* 66357 */
	"MAX_BLOCK_SIZE_64B\0" /* 66374 */
	"MAX_BLOCK_SIZE_128B\0" /* 66393 */
	"MAX_BLOCK_SIZE_256B\0" /* 66413 */
	"MAX_UNCOMPRESSED_BLOCK_SIZE\0" /* 66433 */
	"MIN_BLOCK_SIZE_32B\0" /* 66461 */
	"MIN_BLOCK_SIZE_64B\0" /* 66480 */
	"MIN_COMPRESSED_BLOCK_SIZE\0" /* 66499 */
	"MAX_COMPRESSED_BLOCK_SIZE\0" /* 66525 */
	"INDEPENDENT_64B_BLOCKS\0" /* 66551 */
	"LOSSY_RGB_PRECISION\0" /* 66574 */
	"LOSSY_ALPHA_PRECISION\0" /* 66594 */
	"UTCL2_BUSY\0" /* 66616 */
	"EA_BUSY\0" /* 66627 */
	"RMI_BUSY\0" /* 66635 */
	"UTCL2_RQ_PENDING\0" /* 66644 */
	"CPF_RQ_PENDING\0" /* 66661 */
	"EA_LINK_BUSY\0" /* 66676 */
	"CPAXI_BUSY\0" /* 66689 */
	"RSMU_RQ_PENDING\0" /* 66700 */
	"TC_WC_ACTION_ENA\0" /* 66716 */
	"TC_INV_METADATA_ACTION_ENA\0" /* 66733 */
	"UTCL2IU_BUSY\0" /* 66760 */
	"SAVE_RESTORE_BUSY\0" /* 66773 */
	"UTCL2IU_WAITING_ON_FREE\0" /* 66791 */
	"UTCL2IU_WAITING_ON_TAGS\0" /* 66815 */
	"UTCL1_WAITING_ON_TRANS\0" /* 66839 */
	"GFX_UTCL1_WAITING_ON_TRANS\0" /* 66862 */
	"CMP_UTCL1_WAITING_ON_TRANS\0" /* 66889 */
	"RCIU_WAITING_ON_FREE\0" /* 66916 */
	"PRIMGEN_EN\0" /* 66937 */
	"MATCH_ALL_BITS\0" /* 66948 */
	"EN_INST_OPT_BASIC\0" /* 66963 */
	"EN_INST_OPT_ADV\0" /* 66981 */
	"HW_USE_ONLY\0" /* 66997 */
	"TARGET_INST\0" /* 67009 */
	"TARGET_DATA\0" /* 67021 */
	"COMPLETE\0" /* 67033 */
	"DWB\0" /* 67042 */
	"USER_VM_ENABLE\0" /* 67046 */
	"USER_VM_MODE\0" /* 67061 */
	"IMG_DATA_FORMAT_6E4\0" /* 67074 */
	"IMG_DATA_FORMAT_16_AS_32_32\0" /* 67094 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX9\0" /* 67122 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX9\0" /* 67161 */
	"IMG_DATA_FORMAT_FMASK\0" /* 67200 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR\0" /* 67222 */
	"IMG_DATA_FORMAT_ASTC_2D_HDR\0" /* 67250 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR_SRGB\0" /* 67278 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR\0" /* 67311 */
	"IMG_DATA_FORMAT_ASTC_3D_HDR\0" /* 67339 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR_SRGB\0" /* 67367 */
	"IMG_DATA_FORMAT_N_IN_16\0" /* 67400 */
	"IMG_DATA_FORMAT_N_IN_16_16\0" /* 67424 */
	"IMG_DATA_FORMAT_N_IN_16_16_16_16\0" /* 67451 */
	"IMG_DATA_FORMAT_N_IN_16_AS_16_16_16_16\0" /* 67484 */
	"IMG_DATA_FORMAT_RESERVED_56\0" /* 67523 */
	"IMG_DATA_FORMAT_S8_16\0" /* 67551 */
	"IMG_DATA_FORMAT_S8_32\0" /* 67573 */
	"IMG_DATA_FORMAT_8_AS_32\0" /* 67595 */
	"IMG_DATA_FORMAT_8_AS_32_32\0" /* 67619 */
	"DATA_FORMAT_GFX9\0" /* 67646 */
	"IMG_NUM_FORMAT_RESERVED_6\0" /* 67663 */
	"IMG_NUM_FORMAT_METADATA\0" /* 67689 */
	"IMG_NUM_FORMAT_UNORM_UINT\0" /* 67713 */
	"NUM_FORMAT_GFX9\0" /* 67739 */
	"IMG_FMASK_8_2_1\0" /* 67755 */
	"IMG_FMASK_8_4_1\0" /* 67771 */
	"IMG_FMASK_8_8_1\0" /* 67787 */
	"IMG_FMASK_8_2_2\0" /* 67803 */
	"IMG_FMASK_8_4_2\0" /* 67819 */
	"IMG_FMASK_8_4_4\0" /* 67835 */
	"IMG_FMASK_16_16_1\0" /* 67851 */
	"IMG_FMASK_16_8_2\0" /* 67869 */
	"IMG_FMASK_32_16_2\0" /* 67886 */
	"IMG_FMASK_32_8_4\0" /* 67904 */
	"IMG_FMASK_32_8_8\0" /* 67921 */
	"IMG_FMASK_64_16_4\0" /* 67938 */
	"IMG_FMASK_64_16_8\0" /* 67956 */
	"NUM_FORMAT_FMASK\0" /* 67974 */
	"IMG_ASTC_2D_4x4\0" /* 67991 */
	"IMG_ASTC_2D_5x4\0" /* 68007 */
	"IMG_ASTC_2D_5x5\0" /* 68023 */
	"IMG_ASTC_2D_6x5\0" /* 68039 */
	"IMG_ASTC_2D_6x6\0" /* 68055 */
	"IMG_ASTC_2D_8x5\0" /* 68071 */
	"IMG_ASTC_2D_8x6\0" /* 68087 */
	"IMG_ASTC_2D_8x8\0" /* 68103 */
	"IMG_ASTC_2D_10x5\0" /* 68119 */
	"IMG_ASTC_2D_10x6\0" /* 68136 */
	"IMG_ASTC_2D_10x8\0" /* 68153 */
	"IMG_ASTC_2D_10x10\0" /* 68170 */
	"IMG_ASTC_2D_12x10\0" /* 68188 */
	"IMG_ASTC_2D_12x12\0" /* 68206 */
	"NUM_FORMAT_ASTC_2D\0" /* 68224 */
	"IMG_ASTC_3D_3x3x3\0" /* 68243 */
	"IMG_ASTC_3D_4x3x3\0" /* 68261 */
	"IMG_ASTC_3D_4x4x3\0" /* 68279 */
	"IMG_ASTC_3D_4x4x4\0" /* 68297 */
	"IMG_ASTC_3D_5x4x4\0" /* 68315 */
	"IMG_ASTC_3D_5x5x4\0" /* 68333 */
	"IMG_ASTC_3D_5x5x5\0" /* 68351 */
	"IMG_ASTC_3D_6x5x5\0" /* 68369 */
	"IMG_ASTC_3D_6x6x5\0" /* 68387 */
	"IMG_ASTC_3D_6x6x6\0" /* 68405 */
	"NUM_FORMAT_ASTC_3D\0" /* 68423 */
	"META_DIRECT\0" /* 68442 */
	"SW_MODE\0" /* 68454 */
	"PITCH_GFX9\0" /* 68462 */
	"BC_SWIZZLE_XYZW\0" /* 68473 */
	"BC_SWIZZLE_XWYZ\0" /* 68489 */
	"BC_SWIZZLE_WZYX\0" /* 68505 */
	"BC_SWIZZLE_WXYZ\0" /* 68521 */
	"BC_SWIZZLE_ZYXW\0" /* 68537 */
	"BC_SWIZZLE_YXWZ\0" /* 68553 */
	"BC_SWIZZLE\0" /* 68569 */
	"ARRAY_PITCH\0" /* 68580 */
	"META_DATA_ADDRESS\0" /* 68592 */
	"META_LINEAR\0" /* 68610 */
	"META_PIPE_ALIGNED\0" /* 68622, 68627 */
	"META_RB_ALIGNED\0" /* 68640, 68645 */
	"MAX_MIP\0" /* 68656 */
	"BLEND_ZERO_PRT\0" /* 68664 */
	"SKIP_DEGAMMA\0" /* 68679 */
	"TTRACE_STALL_ALL\0" /* 68692 */
	"ALLOC_ARB_LRU_ENA\0" /* 68709 */
	"EXP_ARB_LRU_ENA\0" /* 68727 */
	"PS_PKR_PRIORITY_CNTL\0" /* 68743 */
	"BATON_RESET_DISABLE\0" /* 68764 */
	"CRC_SIMD_ID_WADDR_DISABLE\0" /* 68784 */
	"LBPW_CU_CHK_MODE\0" /* 68810 */
	"LBPW_CU_CHK_CNT\0" /* 68827 */
	"CSC_PWR_SAVE_DISABLE\0" /* 68843 */
	"CSG_PWR_SAVE_DISABLE\0" /* 68864 */
	"CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD\0" /* 68885 */
	"CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD\0" /* 68926 */
	"PIPE_INTERLEAVE_SIZE_GFX9\0" /* 68965 */
	"MAX_COMPRESSED_FRAGS\0" /* 68991 */
	"NUM_SHADER_ENGINES_GFX9\0" /* 69012 */
	"NUM_GPUS_GFX9\0" /* 69036 */
	"NUM_RB_PER_SE\0" /* 69050 */
	"SE_ENABLE\0" /* 69064 */
	"SIMD_DISABLE\0" /* 69074 */
	"FP16_OVFL\0" /* 69087 */
	"LOAD_COLLISION_WAVEID\0" /* 69097 */
	"LOAD_INTRAWAVE_COLLISION\0" /* 69119 */
	"SKIP_USGPR0\0" /* 69144 */
	"USER_SGPR_MSB\0" /* 69156 */
	"PC_BASE_EN\0" /* 69170 */
	"SPI_SHADER_LATE_ALLOC_GS\0" /* 69181 */
	"GS_VGPR_COMP_CNT\0" /* 69206 */
	"ES_VGPR_COMP_CNT\0" /* 69223 */
	"LS_VGPR_COMP_CNT\0" /* 69240 */
	"CNTR_SEL0\0" /* 69257 */
	"CNTR_SEL1\0" /* 69267 */
	"CNTR_MODE1\0" /* 69277 */
	"CNTR_MODE0\0" /* 69288 */
	"CNTR_SEL2\0" /* 69299 */
	"CNTR_SEL3\0" /* 69309 */
	"CNTR_MODE3\0" /* 69319 */
	"CNTR_MODE2\0" /* 69330 */
	"UTCL2_BUSY_USER_DEFINED_MASK\0" /* 69341 */
	"EA_BUSY_USER_DEFINED_MASK\0" /* 69370 */
	"RMI_BUSY_USER_DEFINED_MASK\0" /* 69396 */
	"MIPID\0" /* 69423 */
	"ALLOW_PARTIAL_RES_HIER_KILL\0" /* 69429 */
	"X_MAX\0" /* 69457 */
	"Y_MAX\0" /* 69463 */
	"PARTIALLY_RESIDENT\0" /* 69469 */
	"FAULT_BEHAVIOR\0" /* 69488 */
	"ITERATE_FLUSH\0" /* 69503 */
	"MAXMIP\0" /* 69517 */
	"FORCE_ON\0" /* 69524 */
	"PUNCHOUT_MODE\0" /* 69533 */
	"POPS_DRAIN_PS_ON_OVERLAP\0" /* 69547 */
	"DISALLOW_OVERFLOW\0" /* 69572 */
	"DEST_BASE_HI_256B\0" /* 69590 */
	"SE_XSEL_GFX9\0" /* 69608 */
	"SE_YSEL_GFX9\0" /* 69621 */
	"SE_PAIR_XSEL_GFX9\0" /* 69634 */
	"SE_PAIR_YSEL_GFX9\0" /* 69652 */
	"NUM_SE\0" /* 69670 */
	"PERFMON_ENABLE\0" /* 69677 */
	"LEFT_QTR\0" /* 69692 */
	"LEFT_HALF\0" /* 69701 */
	"RIGHT_HALF\0" /* 69711 */
	"RIGHT_QTR\0" /* 69722 */
	"TOP_QTR\0" /* 69732 */
	"TOP_HALF\0" /* 69740 */
	"BOT_HALF\0" /* 69749 */
	"BOT_QTR\0" /* 69758 */
	"OFFCHIP_PARAM_EN\0" /* 69766 */
	"LATE_PC_DEALLOC\0" /* 69783 */
	"BASE_ADDR_GFX9\0" /* 69799 */
	"SPRITE_EN_R6XX\0" /* 69814 */
	"UNROLLED_INST\0" /* 69829 */
	"GRBM_SKEW_NO_DEC\0" /* 69843 */
	"REG_RT_INDEX\0" /* 69860 */
	"PRIMITIVE_ORDERED_PIXEL_SHADER\0" /* 69873 */
	"EXEC_IF_OVERLAPPED\0" /* 69904 */
	"POPS_OVERLAP_NUM_SAMPLES\0" /* 69923 */
	"RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF\0" /* 69948 */
	"NEW_QUAD_DECOMPOSITION\0" /* 69986 */
	"PERFCOUNTER_REF\0" /* 70009 */
	"USE_VTX_SHD_OBJPRIM_ID\0" /* 70025 */
	"OBJ_ID_SEL\0" /* 70048 */
	"ADD_PIPED_PRIM_ID\0" /* 70059 */
	"EN_32BIT_OBJPRIMID\0" /* 70077 */
	"VERTEX_REUSE_OFF\0" /* 70096 */
	"INDEX_BUF_EDGE_FLAG_ENA\0" /* 70113 */
	"DISCARD_0_AREA_TRIANGLES\0" /* 70137 */
	"DISCARD_0_AREA_LINES\0" /* 70162 */
	"DISCARD_0_AREA_POINTS\0" /* 70183 */
	"DISCARD_0_AREA_RECTANGLES\0" /* 70205 */
	"USE_PROVOKING_ZW\0" /* 70231 */
	"RESERVED_3\0" /* 70248 */
	"RESERVED_4\0" /* 70259 */
	"RESERVED_5\0" /* 70270 */
	"GS_INST_PRIMS_IN_SUBGRP\0" /* 70281 */
	"SCALE_LINE_WIDTH_PAD\0" /* 70305 */
	"ALTERNATE_RBS_PER_TILE\0" /* 70326 */
	"COARSE_TILE_STARTS_ON_EVEN_RB\0" /* 70349 */
	"NGG_DISABLE_PROVOK_REUSE\0" /* 70379 */
	"BREAK_BATCH\0" /* 70404 */
	"FLUSH_DFSM\0" /* 70416 */
	"RESET_TO_LOWEST_VGT\0" /* 70427 */
	"TGID_ROLLOVER\0" /* 70447 */
	"ENABLE_NGG_PIPELINE\0" /* 70461 */
	"ENABLE_LEGACY_PIPELINE\0" /* 70481 */
	"ADDRESS_HI_GFX9\0" /* 70504 */
	"OBJPRIM_ID_EN\0" /* 70520 */
	"EN_REG_RT_INDEX\0" /* 70534 */
	"EN_PIPELINE_PRIMID\0" /* 70550 */
	"OBJECT_ID_INST_EN\0" /* 70569 */
	"ORDERED_ID_MODE\0" /* 70587 */
	"GS_FAST_LAUNCH\0" /* 70603 */
	"EN_PRIMS_NEEDED_CNT\0" /* 70618 */
	"COVERAGE_TO_SHADER_SELECT\0" /* 70638 */
	"BINNING_ALLOWED\0" /* 70664 */
	"FORCE_BINNING_ON\0" /* 70680 */
	"DISABLE_BINNING_USE_NEW_SC\0" /* 70697 */
	"DISABLE_BINNING_USE_LEGACY_SC\0" /* 70724 */
	"BINNING_MODE\0" /* 70754 */
	"BIN_SIZE_X\0" /* 70767 */
	"BIN_SIZE_Y\0" /* 70778 */
	"BIN_SIZE_X_EXTEND\0" /* 70789 */
	"BIN_SIZE_Y_EXTEND\0" /* 70807 */
	"CONTEXT_STATES_PER_BIN\0" /* 70825 */
	"PERSISTENT_STATES_PER_BIN\0" /* 70848 */
	"DISABLE_START_OF_PRIM\0" /* 70874 */
	"FPOVS_PER_BATCH\0" /* 70896 */
	"OPTIMAL_BIN_SELECTION\0" /* 70912 */
	"MAX_ALLOC_COUNT\0" /* 70934 */
	"MAX_PRIM_PER_BATCH\0" /* 70950 */
	"OVER_RAST_ENABLE\0" /* 70969 */
	"OVER_RAST_SAMPLE_SELECT\0" /* 70986 */
	"UNDER_RAST_ENABLE\0" /* 71010 */
	"UNDER_RAST_SAMPLE_SELECT\0" /* 71028 */
	"PBB_UNCERTAINTY_REGION_ENABLE\0" /* 71053 */
	"ZMM_TRI_EXTENT\0" /* 71083 */
	"ZMM_TRI_OFFSET\0" /* 71098 */
	"OVERRIDE_OVER_RAST_INNER_TO_NORMAL\0" /* 71113 */
	"OVERRIDE_UNDER_RAST_INNER_TO_NORMAL\0" /* 71148 */
	"DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE\0" /* 71184 */
	"UNCERTAINTY_REGION_MODE\0" /* 71228 */
	"OUTER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 71252 */
	"INNER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 71288 */
	"NULL_SQUAD_AA_MASK_ENABLE\0" /* 71324 */
	"COVERAGE_AA_MASK_ENABLE\0" /* 71350 */
	"PREZ_AA_MASK_ENABLE\0" /* 71374 */
	"POSTZ_AA_MASK_ENABLE\0" /* 71394 */
	"CENTROID_SAMPLE_OVERRIDE\0" /* 71415 */
	"MAX_DEALLOCS_IN_WAVE\0" /* 71440 */
	"BASE_256B\0" /* 71461 */
	"MIP0_HEIGHT\0" /* 71471 */
	"MIP0_WIDTH\0" /* 71483 */
	"MIP_LEVEL\0" /* 71494 */
	"MIP0_DEPTH\0" /* 71504 */
	"COLOR_SW_MODE\0" /* 71515 */
	"FMASK_SW_MODE\0" /* 71529 */
	"RESOURCE_TYPE\0" /* 71543 */;

static const int sid_strings_offsets[] = {
	/* 0 */ 509, 31681, 1768, 15296,
	/* 4 */ 31719, 31739, 31751, 31757, 8050, 31761,
	/* 10 */ 31807, 31757, 391, 31816,
	/* 14 */ 31846, 31757, 8540, 31855,
	/* 18 */ 31926, 31931, 31939, 31947,
	/* 22 */ 31973, 31730,
	/* 24 */ 31988, 31998,
	/* 26 */ 36340, 36351, 36367, 36382, 36398, 36412, 36425, 36440, 36455, 36470, 36482, 36501, 36521, 36539, 36558, 36573, 36588, 36610, 36625, 36640, 36655, 36671, 36685, 36712, 36739, 36766, 36793, 36817, 36837,
	/* 55 */ 36856, 36877,
	/* 57 */ 36340, 36351, 36367, 36382, 36398, 36412, 36425, -1, -1, 36470, 36482, 36501, 36521, 36539, -1, -1, 36588, 36610, 36625, 36640, 36655, 36671, 36685, 36712, 36739, 36766, 36793, 36817, 36837,
	/* 86 */ 38719, 38731, 38743, 38755,
	/* 90 */ 39100, -1, -1, -1, -1, -1, -1, -1, 39111, 39123, -1, -1, 39135, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39146,
	/* 123 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39172,
	/* 186 */ 39251, 39260, 39269, 39287, 39305, 39314, 39323, 39332,
	/* 194 */ 39381, 39402, 39423, 39446, 39469, 39489, 39509, 39534,
	/* 202 */ 39566, 39590, 39608, 39627, 39647, 39666, 39688, 39713, 39738, 39765, 39792, 39816, 39838, 39866, 39891, 39919,
	/* 218 */ 40027, 40039, 40058, 40077,
	/* 222 */ 40104, 40128, 40146, 40165, 40185, 40204, 40226, 40251, 40276, 40303, 40330, 40354, 40376, 40404, 40429, 40457, 40485, 40507, 40531, 40555, 40579, 40600, 40621, 40646, 40675, 40700, 40726, 40749, 40773, 40800, 40828, 40856, 40884, 40906, 40928, 40952, 40972, 40992, 41012, 41032, 41052, 41072, 41092, 41131, 41170, 41199, 41228, 41257, 41286, 41315, 41344, 41375, 41405, 41436, 41466, 41496, 41527, 41558, 41578, 41600, 41618, 41645, 41669, 41695,
	/* 286 */ 41746, 41767, 41788, 41811, 41834, 41854, 41874, 41899, 41920, 41946, 41966, 41988, 42014, 42035, 42059, 42086,
	/* 302 */ 42206, 42225, 42244, 42263, 42282, 42301, 42320, 42339, 42358, 42373, 42388, 42403, 42420, 42441, 42462, 42482,
	/* 318 */ 42664, 42676, 42690, 42714, 42744, 42769, 42800, 42820,
	/* 326 */ 42886, 42913, 42939, 42966, 42997, 43026, 43056, 43090,
	/* 334 */ 43312, 43335,
	/* 336 */ 43312, 43335, 43375, 43404,
	/* 340 */ 43450, 43471, 43493,
	/* 343 */ 43635, 43667, 43700, 43733,
	/* 347 */ 43912,
	/* 348 */ 44211, 44227, 44243, 44259, 44275, 44291, 44307, 44323, 44339, 44355, 44371, 44387, 44402, 44417, 44432, 44448,
	/* 364 */ 44875, 44906, 44934, 44963,
	/* 368 */ 45008, 45029, 45050, 45071, 45092, -1, -1, 45113, 45134, -1, -1, -1, 45156, 45177, 45198, 45220,
	/* 384 */ 45248, 45261, 45284, 45307, 45330, 45350, 45371, 45392, 45413, 45439, 45465, 45491, 45518, 45545, 45572,
	/* 399 */ 45611, 45636, 45662, 45688, 45714, 45739, 45764,
	/* 406 */ 45800, 45823, 45846, 45869,
	/* 410 */ 45903, 45927, 45951, 45975,
	/* 414 */ 46011, 46036, 46061, 46086,
	/* 418 */ 46129, 46146, 46163, 46180,
	/* 422 */ 44875, 44906, 44934, 46208,
	/* 426 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46323, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46337, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46351,
	/* 667 */ 47242, 47260, 47275,
	/* 670 */ 48787, 48797, 48810, 48824,
	/* 674 */ 49121, 49136, 49152, 49168,
	/* 678 */ 49333, 49343, 49361, 49371,
	/* 682 */ 45008, 45029, 45050, -1, 45092, 49770, 49792,
	/* 689 */ 45248, -1, -1, -1, 45330, 45350, 45371, 45392, 45413, 45439, 45465, 45491, 45518, 45545, 45572, -1, 49817, 49844,
	/* 707 */ 49872, 49882, 49887, 49892,
	/* 711 */ 50034, 50050,
	/* 713 */ 50528, 50551, 50574, 50597,
	/* 717 */ 50644, 50669, 50694, 50719,
	/* 721 */ 50769, 50793, 50817, 50841,
	/* 725 */ 50873, 50898, 50923, 50948,
	/* 729 */ 50982, 51007, 51032, 51057,
	/* 733 */ 51091, 51117, 51143, 51169,
	/* 737 */ 51205, 51228, 51251, 51274,
	/* 741 */ 51304, 51338, 51373, 51408,
	/* 745 */ 51451, 51485, 51520, 51555,
	/* 749 */ 51598, 51621, 51644, 51667,
	/* 753 */ 51697, 51731, 51766, 51801,
	/* 757 */ 51849, 51883, 51918, 51953,
	/* 761 */ 52001, 52029, 52057, 52085,
	/* 765 */ 52125, 52164, 52204, 52244,
	/* 769 */ 52302, 52341, 52381, 52421,
	/* 773 */ 52574, 52587, 52600, 52613, 52634, 52653, 52671, 52689, 52704, 52721, 52738, 52750, 52761, 52773, 52786, 52798,
	/* 789 */ 53022,
	/* 790 */ 53551, 53572, 53593, 53614, 53635,
	/* 795 */ 53896,
	/* 796 */ 54076, 54092, 54109, 54126, 54147,
	/* 801 */ 54240, 54256, 54272, 54289, 54306, 54327, 54351, 54375, 54398, 54421,
	/* 811 */ 54608, 54635, 54653, 54671, 54693, 54717, 54738, 54757, 54778, 54799, 54821,
	/* 822 */ 54883, 54889, -1, 54902, -1, -1, -1, 54915, -1, -1, -1, 54927, -1, 54939, -1, 54951,
	/* 838 */ 55458, 55493, 55528, 55560, 55592, 55624, 55656, 55690,
	/* 846 */ 55754, 55768, 55781, 55799, 55812, 55825, 55846, 55870,
	/* 854 */ 55946, 55957, 55967, 55983, 56009, 56025, 56051, 56067, 56093, 56109, 56135, -1, -1, 56160, 56181, 56212, 56229, 56250, 56267, 56288, 56309,
	/* 875 */ 56355, 56373, 56392, 56409, 56426,
	/* 880 */ 56554, 56569, 56590, 56612,
	/* 884 */ 56646, 56662,
	/* 886 */ 56770, 56781, 56791, 56802, 56814, 56827, 56841, 56853,
	/* 894 */ 56881, 56891, 56900, 56910, 56921, 56933, 56946, 56957,
	/* 902 */ 57378, 57389, 57399, 57423, -1, 57434, 57454,
	/* 909 */ 57472, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57483, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57492, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57510, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57529, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57546, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57558, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57567, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57577, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57586, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57602, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57613, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57630, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57640, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57656, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57664,
	/* 1165 */ 57749, 57756, 57776, 57781,
	/* 1169 */ 57927, 57940, 57959, 57981,
	/* 1173 */ 58362, 58382,
	/* 1175 */ 58394, 58408, 58421,
	/* 1178 */ 59943, 59965, 59985, 60006, 60027,
	/* 1183 */ 60070, 60087, 60103, 60118, 60134, 60150, 60174, 60198, 60222, 60246, 60267, 60283, 60298, 60322, 60345, 60369, 60389, 60408,
	/* 1201 */ 60451, 60464, 60478, 60490, 60503,
	/* 1206 */ 60576, 60593, 60610, 60626, 60642, 60658, 60674, 60691, 60709,
	/* 1215 */ 60772, 60779, 60793, 60807, 60821, 60835,
	/* 1221 */ 60845, 60857, 60868, 60879,
	/* 1225 */ 61051, -1, -1, 61066,
	/* 1229 */ 61705, 61728, 61751,
	/* 1232 */ 61854, 61867, 61880,
	/* 1235 */ 61892, 61910, 61930, 61950,
	/* 1239 */ 61978, 61994, 62011,
	/* 1242 */ 62038, 62053,
	/* 1244 */ -1, 62131, 62154, 62177, 62200, 62215, 62228, 62240, 62257, -1, 62276, 62296, 62316, 62335, -1, 62347, 62364, 62381, 62397, -1, 62413, 62442, 62453, 62479, 62497, 62514, 62533, 62551, 62570, 62586, 62602, 62622, 62644, 62666, 62680, 62699, 62715, -1, -1, 62725, 62740, -1, 62758, 62781, 62806, 62828, 62853, 38455, 38482, 62875, -1, 62903, 62922, 62940, 62960, 62979, 62999, 63023, 63044,
	/* 1303 */ 63487, 63500, 63512,
	/* 1306 */ 63524, 63537, 63549,
	/* 1309 */ 63563, 63577, 63589,
	/* 1312 */ 63720, 63733, 63747,
	/* 1315 */ 63757, 63770, 63780, 63794,
	/* 1319 */ 63822, 63835, 63847, 63866,
	/* 1323 */ 62038, 62053, 63963,
	/* 1326 */ 63981, 64007, 64033, 64058,
	/* 1330 */ 64837, 64848, 64856, 64872,
	/* 1334 */ 64898, 64924, 64949, 64974, 64997, 65018, 65045, 65074,
	/* 1342 */ 65411, 65423, 65436, 65449,
	/* 1346 */ 65469, 65483, 65491, 65500, 65510, 65519, 65531, 65546, 65561, 65578, 65595, 65609, 65621, -1, 65639, -1, 65657, 65669, 65683, 65697, 65711, 65722, 65733,
	/* 1369 */ 65754, 65767, -1, -1, 65780, 65792, 65804, 65816,
	/* 1377 */ 65841, 65850, 65859, 65872,
	/* 1381 */ 65949, 65964, 65982, 66010, 66040, 66071, 66099, 66129,
	/* 1389 */ 66374, 66393, 66413,
	/* 1392 */ 66461, 66480,
	/* 1394 */ 40104, 40128, 40146, 40165, 40185, 40204, 40226, 40251, 40276, 40303, 40330, 40354, 40376, 40404, 40429, 40457, 40485, 40507, 40531, 40555, 40579, 40600, 40621, 40646, 40675, 40700, 40726, 40749, 40773, 40800, 40828, 67074, 40884, 40906, 40928, 40952, 40972, 40992, 41012, 41032, 41052, 41072, 67094, 67122, 67161, 67200, 67222, 67250, 67278, 67311, 67339, 67367, 67400, 67424, 67451, 67484, 67523, 41558, 41578, 67551, 67573, 67595, 67619, 41695,
	/* 1458 */ 41746, 41767, 41788, 41811, 41834, 41854, 67663, 41899, 67689, 41946, 67713,
	/* 1469 */ 67755, 67771, 67787, 67803, 67819, 67835, 67851, 67869, 67886, 67904, 67921, 67938, 67956,
	/* 1482 */ 67991, 68007, 68023, 68039, 68055, 68071, 68087, 68103, 68119, 68136, 68153, 68170, 68188, 68206,
	/* 1496 */ 68243, 68261, 68279, 68297, 68315, 68333, 68351, 68369, 68387, 68405,
	/* 1506 */ 68473, 68489, 68505, 68521, 68537, 68553,
	/* 1512 */ 245, 69524, 48787, 8050,
	/* 1516 */ -1, 62131, 62154, 62177, 62200, 62215, 62228, 62240, 62257, -1, 62276, 62296, 62316, 62335, 70404, 62347, 62364, 62381, 70416, 70427, 62413, 62442, 62453, 62479, 62497, 62514, 62533, 62551, -1, -1, 62602, 62622, 62644, 62666, 62680, 62699, 62715, 70447, -1, 62725, 62740, -1, 62758, 62781, 62806, 62828, 62853, 38455, 38482, 62875, -1, 62903, 62922, 62940, 62960, 62979, 62999, 63023, 63044, -1, -1, 70461, 70481,
	/* 1579 */ 70664, 70680, 70697, 70724,
	/* 1583 */ 42370, 42385, 42400, 8050,
};

#endif
