/* DO NOT EDIT - This file generated automatically by gl_marshal.py script */

/*
 * Copyright (C) 2012 Intel Corporation
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.  IN NO EVENT SHALL
 * INTEL CORPORATION,
 * AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
 * OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */


#include "api_exec.h"
#include "context.h"
#include "dispatch.h"
#include "glthread.h"
#include "marshal.h"
#include "marshal_generated.h"

static inline int safe_mul(int a, int b)
{
    if (a < 0 || b < 0) return -1;
    if (a == 0 || b == 0) return 0;
    if (a > INT_MAX / b) return -1;
    return a * b;
}

/* MapGrid1d: marshalled asynchronously */
struct marshal_cmd_MapGrid1d
{
   struct marshal_cmd_base cmd_base;
   GLint un;
   GLdouble u1;
   GLdouble u2;
};
static inline void
_mesa_unmarshal_MapGrid1d(struct gl_context *ctx, const struct marshal_cmd_MapGrid1d *cmd)
{
   const GLint un = cmd->un;
   const GLdouble u1 = cmd->u1;
   const GLdouble u2 = cmd->u2;
   CALL_MapGrid1d(ctx->CurrentServerDispatch, (un, u1, u2));
}
static void GLAPIENTRY
_mesa_marshal_MapGrid1d(GLint un, GLdouble u1, GLdouble u2)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MapGrid1d);
   struct marshal_cmd_MapGrid1d *cmd;
   debug_print_marshal("MapGrid1d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MapGrid1d, cmd_size);
      cmd->un = un;
      cmd->u1 = u1;
      cmd->u2 = u2;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MapGrid1d");
   CALL_MapGrid1d(ctx->CurrentServerDispatch, (un, u1, u2));
}


/* MapGrid1f: marshalled asynchronously */
struct marshal_cmd_MapGrid1f
{
   struct marshal_cmd_base cmd_base;
   GLint un;
   GLfloat u1;
   GLfloat u2;
};
static inline void
_mesa_unmarshal_MapGrid1f(struct gl_context *ctx, const struct marshal_cmd_MapGrid1f *cmd)
{
   const GLint un = cmd->un;
   const GLfloat u1 = cmd->u1;
   const GLfloat u2 = cmd->u2;
   CALL_MapGrid1f(ctx->CurrentServerDispatch, (un, u1, u2));
}
static void GLAPIENTRY
_mesa_marshal_MapGrid1f(GLint un, GLfloat u1, GLfloat u2)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MapGrid1f);
   struct marshal_cmd_MapGrid1f *cmd;
   debug_print_marshal("MapGrid1f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MapGrid1f, cmd_size);
      cmd->un = un;
      cmd->u1 = u1;
      cmd->u2 = u2;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MapGrid1f");
   CALL_MapGrid1f(ctx->CurrentServerDispatch, (un, u1, u2));
}


/* ProgramUniform3i64vARB: marshalled asynchronously */
struct marshal_cmd_ProgramUniform3i64vARB
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 24) bytes are GLint64 value[count][3] */
};
static inline void
_mesa_unmarshal_ProgramUniform3i64vARB(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform3i64vARB *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLint64 * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLint64 *) variable_data;
   variable_data += count * 24;
   CALL_ProgramUniform3i64vARB(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform3i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform3i64vARB) + safe_mul(count, 24);
   struct marshal_cmd_ProgramUniform3i64vARB *cmd;
   debug_print_marshal("ProgramUniform3i64vARB");
   if (unlikely(safe_mul(count, 24) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform3i64vARB, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 24);
      variable_data += count * 24;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform3i64vARB");
   CALL_ProgramUniform3i64vARB(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* GetProgramResourceLocationIndex: marshalled synchronously */
static GLint GLAPIENTRY
_mesa_marshal_GetProgramResourceLocationIndex(GLuint program, GLenum programInterface, const GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramResourceLocationIndex");
   return CALL_GetProgramResourceLocationIndex(ctx->CurrentServerDispatch, (program, programInterface, name));
}


/* TexCoordP1ui: marshalled asynchronously */
struct marshal_cmd_TexCoordP1ui
{
   struct marshal_cmd_base cmd_base;
   GLenum type;
   GLuint coords;
};
static inline void
_mesa_unmarshal_TexCoordP1ui(struct gl_context *ctx, const struct marshal_cmd_TexCoordP1ui *cmd)
{
   const GLenum type = cmd->type;
   const GLuint coords = cmd->coords;
   CALL_TexCoordP1ui(ctx->CurrentServerDispatch, (type, coords));
}
static void GLAPIENTRY
_mesa_marshal_TexCoordP1ui(GLenum type, GLuint coords)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoordP1ui);
   struct marshal_cmd_TexCoordP1ui *cmd;
   debug_print_marshal("TexCoordP1ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoordP1ui, cmd_size);
      cmd->type = type;
      cmd->coords = coords;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoordP1ui");
   CALL_TexCoordP1ui(ctx->CurrentServerDispatch, (type, coords));
}


/* PolygonStipple: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_PolygonStipple(const GLubyte * mask)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("PolygonStipple");
   CALL_PolygonStipple(ctx->CurrentServerDispatch, (mask));
}


/* MultiTexCoord1dv: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord1dv
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLdouble v[1];
};
static inline void
_mesa_unmarshal_MultiTexCoord1dv(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord1dv *cmd)
{
   const GLenum target = cmd->target;
   const GLdouble * v = cmd->v;
   CALL_MultiTexCoord1dv(ctx->CurrentServerDispatch, (target, v));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord1dv(GLenum target, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord1dv);
   struct marshal_cmd_MultiTexCoord1dv *cmd;
   debug_print_marshal("MultiTexCoord1dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord1dv, cmd_size);
      cmd->target = target;
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord1dv");
   CALL_MultiTexCoord1dv(ctx->CurrentServerDispatch, (target, v));
}


/* IsEnabled: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsEnabled(GLenum cap)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsEnabled");
   return CALL_IsEnabled(ctx->CurrentServerDispatch, (cap));
}


/* AttachShader: marshalled asynchronously */
struct marshal_cmd_AttachShader
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLuint shader;
};
static inline void
_mesa_unmarshal_AttachShader(struct gl_context *ctx, const struct marshal_cmd_AttachShader *cmd)
{
   const GLuint program = cmd->program;
   const GLuint shader = cmd->shader;
   CALL_AttachShader(ctx->CurrentServerDispatch, (program, shader));
}
static void GLAPIENTRY
_mesa_marshal_AttachShader(GLuint program, GLuint shader)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_AttachShader);
   struct marshal_cmd_AttachShader *cmd;
   debug_print_marshal("AttachShader");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_AttachShader, cmd_size);
      cmd->program = program;
      cmd->shader = shader;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("AttachShader");
   CALL_AttachShader(ctx->CurrentServerDispatch, (program, shader));
}


/* VertexAttrib3fARB: marshalled asynchronously */
struct marshal_cmd_VertexAttrib3fARB
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat x;
   GLfloat y;
   GLfloat z;
};
static inline void
_mesa_unmarshal_VertexAttrib3fARB(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib3fARB *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   CALL_VertexAttrib3fARB(ctx->CurrentServerDispatch, (index, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib3fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib3fARB);
   struct marshal_cmd_VertexAttrib3fARB *cmd;
   debug_print_marshal("VertexAttrib3fARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib3fARB, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib3fARB");
   CALL_VertexAttrib3fARB(ctx->CurrentServerDispatch, (index, x, y, z));
}


/* Indexubv: marshalled asynchronously */
struct marshal_cmd_Indexubv
{
   struct marshal_cmd_base cmd_base;
   GLubyte c[1];
};
static inline void
_mesa_unmarshal_Indexubv(struct gl_context *ctx, const struct marshal_cmd_Indexubv *cmd)
{
   const GLubyte * c = cmd->c;
   CALL_Indexubv(ctx->CurrentServerDispatch, (c));
}
static void GLAPIENTRY
_mesa_marshal_Indexubv(const GLubyte * c)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Indexubv);
   struct marshal_cmd_Indexubv *cmd;
   debug_print_marshal("Indexubv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Indexubv, cmd_size);
      memcpy(cmd->c, c, 1);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Indexubv");
   CALL_Indexubv(ctx->CurrentServerDispatch, (c));
}


/* GetCompressedTextureImage: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetCompressedTextureImage(GLuint texture, GLint level, GLsizei bufSize, GLvoid * pixels)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetCompressedTextureImage");
   CALL_GetCompressedTextureImage(ctx->CurrentServerDispatch, (texture, level, bufSize, pixels));
}


/* MultiTexCoordP3uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_MultiTexCoordP3uiv(GLenum texture, GLenum type, const GLuint * coords)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MultiTexCoordP3uiv");
   CALL_MultiTexCoordP3uiv(ctx->CurrentServerDispatch, (texture, type, coords));
}


/* VertexAttribI4usv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribI4usv(GLuint index, const GLushort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribI4usv");
   CALL_VertexAttribI4usv(ctx->CurrentServerDispatch, (index, v));
}


/* Color3ubv: marshalled asynchronously */
struct marshal_cmd_Color3ubv
{
   struct marshal_cmd_base cmd_base;
   GLubyte v[3];
};
static inline void
_mesa_unmarshal_Color3ubv(struct gl_context *ctx, const struct marshal_cmd_Color3ubv *cmd)
{
   const GLubyte * v = cmd->v;
   CALL_Color3ubv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Color3ubv(const GLubyte * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color3ubv);
   struct marshal_cmd_Color3ubv *cmd;
   debug_print_marshal("Color3ubv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color3ubv, cmd_size);
      memcpy(cmd->v, v, 3);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color3ubv");
   CALL_Color3ubv(ctx->CurrentServerDispatch, (v));
}


/* GetClipPlanex: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetClipPlanex(GLenum plane, GLfixed * equation)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetClipPlanex");
   CALL_GetClipPlanex(ctx->CurrentServerDispatch, (plane, equation));
}


/* ProgramUniform2ui: marshalled asynchronously */
struct marshal_cmd_ProgramUniform2ui
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLuint x;
   GLuint y;
};
static inline void
_mesa_unmarshal_ProgramUniform2ui(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform2ui *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLuint x = cmd->x;
   const GLuint y = cmd->y;
   CALL_ProgramUniform2ui(ctx->CurrentServerDispatch, (program, location, x, y));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform2ui(GLuint program, GLint location, GLuint x, GLuint y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform2ui);
   struct marshal_cmd_ProgramUniform2ui *cmd;
   debug_print_marshal("ProgramUniform2ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform2ui, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform2ui");
   CALL_ProgramUniform2ui(ctx->CurrentServerDispatch, (program, location, x, y));
}


/* TexCoordP1uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexCoordP1uiv(GLenum type, const GLuint * coords)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexCoordP1uiv");
   CALL_TexCoordP1uiv(ctx->CurrentServerDispatch, (type, coords));
}


/* RenderbufferStorage: marshalled asynchronously */
struct marshal_cmd_RenderbufferStorage
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum internalformat;
   GLsizei width;
   GLsizei height;
};
static inline void
_mesa_unmarshal_RenderbufferStorage(struct gl_context *ctx, const struct marshal_cmd_RenderbufferStorage *cmd)
{
   const GLenum target = cmd->target;
   const GLenum internalformat = cmd->internalformat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   CALL_RenderbufferStorage(ctx->CurrentServerDispatch, (target, internalformat, width, height));
}
static void GLAPIENTRY
_mesa_marshal_RenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RenderbufferStorage);
   struct marshal_cmd_RenderbufferStorage *cmd;
   debug_print_marshal("RenderbufferStorage");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RenderbufferStorage, cmd_size);
      cmd->target = target;
      cmd->internalformat = internalformat;
      cmd->width = width;
      cmd->height = height;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RenderbufferStorage");
   CALL_RenderbufferStorage(ctx->CurrentServerDispatch, (target, internalformat, width, height));
}


/* GetClipPlanef: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetClipPlanef(GLenum plane, GLfloat * equation)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetClipPlanef");
   CALL_GetClipPlanef(ctx->CurrentServerDispatch, (plane, equation));
}


/* GetPerfQueryDataINTEL: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetPerfQueryDataINTEL(GLuint queryHandle, GLuint flags, GLsizei dataSize, GLvoid * data, GLuint * bytesWritten)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetPerfQueryDataINTEL");
   CALL_GetPerfQueryDataINTEL(ctx->CurrentServerDispatch, (queryHandle, flags, dataSize, data, bytesWritten));
}


/* DrawArraysIndirect: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_DrawArraysIndirect(GLenum mode, const GLvoid * indirect)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("DrawArraysIndirect");
   CALL_DrawArraysIndirect(ctx->CurrentServerDispatch, (mode, indirect));
}


/* Uniform3i: marshalled asynchronously */
struct marshal_cmd_Uniform3i
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLint v0;
   GLint v1;
   GLint v2;
};
static inline void
_mesa_unmarshal_Uniform3i(struct gl_context *ctx, const struct marshal_cmd_Uniform3i *cmd)
{
   const GLint location = cmd->location;
   const GLint v0 = cmd->v0;
   const GLint v1 = cmd->v1;
   const GLint v2 = cmd->v2;
   CALL_Uniform3i(ctx->CurrentServerDispatch, (location, v0, v1, v2));
}
static void GLAPIENTRY
_mesa_marshal_Uniform3i(GLint location, GLint v0, GLint v1, GLint v2)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform3i);
   struct marshal_cmd_Uniform3i *cmd;
   debug_print_marshal("Uniform3i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform3i, cmd_size);
      cmd->location = location;
      cmd->v0 = v0;
      cmd->v1 = v1;
      cmd->v2 = v2;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform3i");
   CALL_Uniform3i(ctx->CurrentServerDispatch, (location, v0, v1, v2));
}


/* VDPAUGetSurfaceivNV: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VDPAUGetSurfaceivNV(GLintptr surface, GLenum pname, GLsizei bufSize, GLsizei * length, GLint * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VDPAUGetSurfaceivNV");
   CALL_VDPAUGetSurfaceivNV(ctx->CurrentServerDispatch, (surface, pname, bufSize, length, values));
}


/* Uniform3d: marshalled asynchronously */
struct marshal_cmd_Uniform3d
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLdouble x;
   GLdouble y;
   GLdouble z;
};
static inline void
_mesa_unmarshal_Uniform3d(struct gl_context *ctx, const struct marshal_cmd_Uniform3d *cmd)
{
   const GLint location = cmd->location;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   CALL_Uniform3d(ctx->CurrentServerDispatch, (location, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Uniform3d(GLint location, GLdouble x, GLdouble y, GLdouble z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform3d);
   struct marshal_cmd_Uniform3d *cmd;
   debug_print_marshal("Uniform3d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform3d, cmd_size);
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform3d");
   CALL_Uniform3d(ctx->CurrentServerDispatch, (location, x, y, z));
}


/* Uniform3f: marshalled asynchronously */
struct marshal_cmd_Uniform3f
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLfloat v0;
   GLfloat v1;
   GLfloat v2;
};
static inline void
_mesa_unmarshal_Uniform3f(struct gl_context *ctx, const struct marshal_cmd_Uniform3f *cmd)
{
   const GLint location = cmd->location;
   const GLfloat v0 = cmd->v0;
   const GLfloat v1 = cmd->v1;
   const GLfloat v2 = cmd->v2;
   CALL_Uniform3f(ctx->CurrentServerDispatch, (location, v0, v1, v2));
}
static void GLAPIENTRY
_mesa_marshal_Uniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform3f);
   struct marshal_cmd_Uniform3f *cmd;
   debug_print_marshal("Uniform3f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform3f, cmd_size);
      cmd->location = location;
      cmd->v0 = v0;
      cmd->v1 = v1;
      cmd->v2 = v2;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform3f");
   CALL_Uniform3f(ctx->CurrentServerDispatch, (location, v0, v1, v2));
}


/* UniformMatrix2x4fv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix2x4fv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 32) bytes are GLfloat value[count][8] */
};
static inline void
_mesa_unmarshal_UniformMatrix2x4fv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix2x4fv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 32;
   CALL_UniformMatrix2x4fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix2x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix2x4fv) + safe_mul(count, 32);
   struct marshal_cmd_UniformMatrix2x4fv *cmd;
   debug_print_marshal("UniformMatrix2x4fv");
   if (unlikely(safe_mul(count, 32) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix2x4fv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 32);
      variable_data += count * 32;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix2x4fv");
   CALL_UniformMatrix2x4fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* QueryMatrixxOES: marshalled synchronously */
static GLbitfield GLAPIENTRY
_mesa_marshal_QueryMatrixxOES(GLfixed * mantissa, GLint * exponent)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("QueryMatrixxOES");
   return CALL_QueryMatrixxOES(ctx->CurrentServerDispatch, (mantissa, exponent));
}


/* Normal3iv: marshalled asynchronously */
struct marshal_cmd_Normal3iv
{
   struct marshal_cmd_base cmd_base;
   GLint v[3];
};
static inline void
_mesa_unmarshal_Normal3iv(struct gl_context *ctx, const struct marshal_cmd_Normal3iv *cmd)
{
   const GLint * v = cmd->v;
   CALL_Normal3iv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Normal3iv(const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Normal3iv);
   struct marshal_cmd_Normal3iv *cmd;
   debug_print_marshal("Normal3iv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Normal3iv, cmd_size);
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Normal3iv");
   CALL_Normal3iv(ctx->CurrentServerDispatch, (v));
}


/* DrawTexiOES: marshalled asynchronously */
struct marshal_cmd_DrawTexiOES
{
   struct marshal_cmd_base cmd_base;
   GLint x;
   GLint y;
   GLint z;
   GLint width;
   GLint height;
};
static inline void
_mesa_unmarshal_DrawTexiOES(struct gl_context *ctx, const struct marshal_cmd_DrawTexiOES *cmd)
{
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLint z = cmd->z;
   const GLint width = cmd->width;
   const GLint height = cmd->height;
   CALL_DrawTexiOES(ctx->CurrentServerDispatch, (x, y, z, width, height));
}
static void GLAPIENTRY
_mesa_marshal_DrawTexiOES(GLint x, GLint y, GLint z, GLint width, GLint height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawTexiOES);
   struct marshal_cmd_DrawTexiOES *cmd;
   debug_print_marshal("DrawTexiOES");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawTexiOES, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->width = width;
      cmd->height = height;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawTexiOES");
   CALL_DrawTexiOES(ctx->CurrentServerDispatch, (x, y, z, width, height));
}


/* Viewport: marshalled asynchronously */
struct marshal_cmd_Viewport
{
   struct marshal_cmd_base cmd_base;
   GLint x;
   GLint y;
   GLsizei width;
   GLsizei height;
};
static inline void
_mesa_unmarshal_Viewport(struct gl_context *ctx, const struct marshal_cmd_Viewport *cmd)
{
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   CALL_Viewport(ctx->CurrentServerDispatch, (x, y, width, height));
}
static void GLAPIENTRY
_mesa_marshal_Viewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Viewport);
   struct marshal_cmd_Viewport *cmd;
   debug_print_marshal("Viewport");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Viewport, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->width = width;
      cmd->height = height;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Viewport");
   CALL_Viewport(ctx->CurrentServerDispatch, (x, y, width, height));
}


/* CreateProgramPipelines: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CreateProgramPipelines(GLsizei n, GLuint * pipelines)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CreateProgramPipelines");
   CALL_CreateProgramPipelines(ctx->CurrentServerDispatch, (n, pipelines));
}


/* DeleteVertexArrays: marshalled asynchronously */
struct marshal_cmd_DeleteVertexArrays
{
   struct marshal_cmd_base cmd_base;
   GLsizei n;
   /* Next safe_mul(n, 4) bytes are GLuint arrays[n] */
};
static inline void
_mesa_unmarshal_DeleteVertexArrays(struct gl_context *ctx, const struct marshal_cmd_DeleteVertexArrays *cmd)
{
   const GLsizei n = cmd->n;
   const GLuint * arrays;
   const char *variable_data = (const char *) (cmd + 1);
   arrays = (const GLuint *) variable_data;
   variable_data += n * 4;
   CALL_DeleteVertexArrays(ctx->CurrentServerDispatch, (n, arrays));
}
static void GLAPIENTRY
_mesa_marshal_DeleteVertexArrays(GLsizei n, const GLuint * arrays)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DeleteVertexArrays) + safe_mul(n, 4);
   struct marshal_cmd_DeleteVertexArrays *cmd;
   debug_print_marshal("DeleteVertexArrays");
   if (unlikely(safe_mul(n, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DeleteVertexArrays, cmd_size);
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, arrays, n * 4);
      variable_data += n * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DeleteVertexArrays");
   CALL_DeleteVertexArrays(ctx->CurrentServerDispatch, (n, arrays));
}


/* ClearColorIuiEXT: marshalled asynchronously */
struct marshal_cmd_ClearColorIuiEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint r;
   GLuint g;
   GLuint b;
   GLuint a;
};
static inline void
_mesa_unmarshal_ClearColorIuiEXT(struct gl_context *ctx, const struct marshal_cmd_ClearColorIuiEXT *cmd)
{
   const GLuint r = cmd->r;
   const GLuint g = cmd->g;
   const GLuint b = cmd->b;
   const GLuint a = cmd->a;
   CALL_ClearColorIuiEXT(ctx->CurrentServerDispatch, (r, g, b, a));
}
static void GLAPIENTRY
_mesa_marshal_ClearColorIuiEXT(GLuint r, GLuint g, GLuint b, GLuint a)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClearColorIuiEXT);
   struct marshal_cmd_ClearColorIuiEXT *cmd;
   debug_print_marshal("ClearColorIuiEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClearColorIuiEXT, cmd_size);
      cmd->r = r;
      cmd->g = g;
      cmd->b = b;
      cmd->a = a;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClearColorIuiEXT");
   CALL_ClearColorIuiEXT(ctx->CurrentServerDispatch, (r, g, b, a));
}


/* GetnConvolutionFilterARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnConvolutionFilterARB(GLenum target, GLenum format, GLenum type, GLsizei bufSize, GLvoid * image)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnConvolutionFilterARB");
   CALL_GetnConvolutionFilterARB(ctx->CurrentServerDispatch, (target, format, type, bufSize, image));
}


/* PolygonOffsetx: marshalled asynchronously */
struct marshal_cmd_PolygonOffsetx
{
   struct marshal_cmd_base cmd_base;
   GLfixed factor;
   GLfixed units;
};
static inline void
_mesa_unmarshal_PolygonOffsetx(struct gl_context *ctx, const struct marshal_cmd_PolygonOffsetx *cmd)
{
   const GLfixed factor = cmd->factor;
   const GLfixed units = cmd->units;
   CALL_PolygonOffsetx(ctx->CurrentServerDispatch, (factor, units));
}
static void GLAPIENTRY
_mesa_marshal_PolygonOffsetx(GLfixed factor, GLfixed units)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PolygonOffsetx);
   struct marshal_cmd_PolygonOffsetx *cmd;
   debug_print_marshal("PolygonOffsetx");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PolygonOffsetx, cmd_size);
      cmd->factor = factor;
      cmd->units = units;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PolygonOffsetx");
   CALL_PolygonOffsetx(ctx->CurrentServerDispatch, (factor, units));
}


/* GetLightxv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetLightxv(GLenum light, GLenum pname, GLfixed * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetLightxv");
   CALL_GetLightxv(ctx->CurrentServerDispatch, (light, pname, params));
}


/* GetConvolutionParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetConvolutionParameteriv(GLenum target, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetConvolutionParameteriv");
   CALL_GetConvolutionParameteriv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* DepthRangeIndexedfOES: marshalled asynchronously */
struct marshal_cmd_DepthRangeIndexedfOES
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat n;
   GLfloat f;
};
static inline void
_mesa_unmarshal_DepthRangeIndexedfOES(struct gl_context *ctx, const struct marshal_cmd_DepthRangeIndexedfOES *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat n = cmd->n;
   const GLfloat f = cmd->f;
   CALL_DepthRangeIndexedfOES(ctx->CurrentServerDispatch, (index, n, f));
}
static void GLAPIENTRY
_mesa_marshal_DepthRangeIndexedfOES(GLuint index, GLfloat n, GLfloat f)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DepthRangeIndexedfOES);
   struct marshal_cmd_DepthRangeIndexedfOES *cmd;
   debug_print_marshal("DepthRangeIndexedfOES");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DepthRangeIndexedfOES, cmd_size);
      cmd->index = index;
      cmd->n = n;
      cmd->f = f;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DepthRangeIndexedfOES");
   CALL_DepthRangeIndexedfOES(ctx->CurrentServerDispatch, (index, n, f));
}


/* GetProgramResourceLocation: marshalled synchronously */
static GLint GLAPIENTRY
_mesa_marshal_GetProgramResourceLocation(GLuint program, GLenum programInterface, const GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramResourceLocation");
   return CALL_GetProgramResourceLocation(ctx->CurrentServerDispatch, (program, programInterface, name));
}


/* GetSubroutineUniformLocation: marshalled synchronously */
static GLint GLAPIENTRY
_mesa_marshal_GetSubroutineUniformLocation(GLuint program, GLenum shadertype, const GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetSubroutineUniformLocation");
   return CALL_GetSubroutineUniformLocation(ctx->CurrentServerDispatch, (program, shadertype, name));
}


/* VertexAttrib4usv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4usv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLushort v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4usv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4usv *cmd)
{
   const GLuint index = cmd->index;
   const GLushort * v = cmd->v;
   CALL_VertexAttrib4usv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4usv(GLuint index, const GLushort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4usv);
   struct marshal_cmd_VertexAttrib4usv *cmd;
   debug_print_marshal("VertexAttrib4usv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4usv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4usv");
   CALL_VertexAttrib4usv(ctx->CurrentServerDispatch, (index, v));
}


/* TextureStorage1DEXT: marshalled asynchronously */
struct marshal_cmd_TextureStorage1DEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLenum target;
   GLsizei levels;
   GLenum internalFormat;
   GLsizei width;
};
static inline void
_mesa_unmarshal_TextureStorage1DEXT(struct gl_context *ctx, const struct marshal_cmd_TextureStorage1DEXT *cmd)
{
   const GLuint texture = cmd->texture;
   const GLenum target = cmd->target;
   const GLsizei levels = cmd->levels;
   const GLenum internalFormat = cmd->internalFormat;
   const GLsizei width = cmd->width;
   CALL_TextureStorage1DEXT(ctx->CurrentServerDispatch, (texture, target, levels, internalFormat, width));
}
static void GLAPIENTRY
_mesa_marshal_TextureStorage1DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureStorage1DEXT);
   struct marshal_cmd_TextureStorage1DEXT *cmd;
   debug_print_marshal("TextureStorage1DEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureStorage1DEXT, cmd_size);
      cmd->texture = texture;
      cmd->target = target;
      cmd->levels = levels;
      cmd->internalFormat = internalFormat;
      cmd->width = width;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureStorage1DEXT");
   CALL_TextureStorage1DEXT(ctx->CurrentServerDispatch, (texture, target, levels, internalFormat, width));
}


/* VertexAttrib4Nub: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4Nub
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLubyte x;
   GLubyte y;
   GLubyte z;
   GLubyte w;
};
static inline void
_mesa_unmarshal_VertexAttrib4Nub(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4Nub *cmd)
{
   const GLuint index = cmd->index;
   const GLubyte x = cmd->x;
   const GLubyte y = cmd->y;
   const GLubyte z = cmd->z;
   const GLubyte w = cmd->w;
   CALL_VertexAttrib4Nub(ctx->CurrentServerDispatch, (index, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4Nub(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4Nub);
   struct marshal_cmd_VertexAttrib4Nub *cmd;
   debug_print_marshal("VertexAttrib4Nub");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4Nub, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4Nub");
   CALL_VertexAttrib4Nub(ctx->CurrentServerDispatch, (index, x, y, z, w));
}


/* VertexAttribP3ui: marshalled asynchronously */
struct marshal_cmd_VertexAttribP3ui
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLenum type;
   GLboolean normalized;
   GLuint value;
};
static inline void
_mesa_unmarshal_VertexAttribP3ui(struct gl_context *ctx, const struct marshal_cmd_VertexAttribP3ui *cmd)
{
   const GLuint index = cmd->index;
   const GLenum type = cmd->type;
   const GLboolean normalized = cmd->normalized;
   const GLuint value = cmd->value;
   CALL_VertexAttribP3ui(ctx->CurrentServerDispatch, (index, type, normalized, value));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribP3ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribP3ui);
   struct marshal_cmd_VertexAttribP3ui *cmd;
   debug_print_marshal("VertexAttribP3ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribP3ui, cmd_size);
      cmd->index = index;
      cmd->type = type;
      cmd->normalized = normalized;
      cmd->value = value;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribP3ui");
   CALL_VertexAttribP3ui(ctx->CurrentServerDispatch, (index, type, normalized, value));
}


/* PointSize: marshalled asynchronously */
struct marshal_cmd_PointSize
{
   struct marshal_cmd_base cmd_base;
   GLfloat size;
};
static inline void
_mesa_unmarshal_PointSize(struct gl_context *ctx, const struct marshal_cmd_PointSize *cmd)
{
   const GLfloat size = cmd->size;
   CALL_PointSize(ctx->CurrentServerDispatch, (size));
}
static void GLAPIENTRY
_mesa_marshal_PointSize(GLfloat size)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PointSize);
   struct marshal_cmd_PointSize *cmd;
   debug_print_marshal("PointSize");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PointSize, cmd_size);
      cmd->size = size;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PointSize");
   CALL_PointSize(ctx->CurrentServerDispatch, (size));
}


/* PopName: marshalled asynchronously */
struct marshal_cmd_PopName
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_PopName(struct gl_context *ctx, const struct marshal_cmd_PopName *cmd)
{
   CALL_PopName(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_PopName(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PopName);
   struct marshal_cmd_PopName *cmd;
   debug_print_marshal("PopName");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PopName, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PopName");
   CALL_PopName(ctx->CurrentServerDispatch, ());
}


/* FramebufferTexture: marshalled asynchronously */
struct marshal_cmd_FramebufferTexture
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum attachment;
   GLuint texture;
   GLint level;
};
static inline void
_mesa_unmarshal_FramebufferTexture(struct gl_context *ctx, const struct marshal_cmd_FramebufferTexture *cmd)
{
   const GLenum target = cmd->target;
   const GLenum attachment = cmd->attachment;
   const GLuint texture = cmd->texture;
   const GLint level = cmd->level;
   CALL_FramebufferTexture(ctx->CurrentServerDispatch, (target, attachment, texture, level));
}
static void GLAPIENTRY
_mesa_marshal_FramebufferTexture(GLenum target, GLenum attachment, GLuint texture, GLint level)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_FramebufferTexture);
   struct marshal_cmd_FramebufferTexture *cmd;
   debug_print_marshal("FramebufferTexture");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_FramebufferTexture, cmd_size);
      cmd->target = target;
      cmd->attachment = attachment;
      cmd->texture = texture;
      cmd->level = level;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("FramebufferTexture");
   CALL_FramebufferTexture(ctx->CurrentServerDispatch, (target, attachment, texture, level));
}


/* CreateTransformFeedbacks: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CreateTransformFeedbacks(GLsizei n, GLuint * ids)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CreateTransformFeedbacks");
   CALL_CreateTransformFeedbacks(ctx->CurrentServerDispatch, (n, ids));
}


/* VertexAttrib4ubNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4ubNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLubyte x;
   GLubyte y;
   GLubyte z;
   GLubyte w;
};
static inline void
_mesa_unmarshal_VertexAttrib4ubNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4ubNV *cmd)
{
   const GLuint index = cmd->index;
   const GLubyte x = cmd->x;
   const GLubyte y = cmd->y;
   const GLubyte z = cmd->z;
   const GLubyte w = cmd->w;
   CALL_VertexAttrib4ubNV(ctx->CurrentServerDispatch, (index, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4ubNV(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4ubNV);
   struct marshal_cmd_VertexAttrib4ubNV *cmd;
   debug_print_marshal("VertexAttrib4ubNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4ubNV, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4ubNV");
   CALL_VertexAttrib4ubNV(ctx->CurrentServerDispatch, (index, x, y, z, w));
}


/* ValidateProgramPipeline: marshalled asynchronously */
struct marshal_cmd_ValidateProgramPipeline
{
   struct marshal_cmd_base cmd_base;
   GLuint pipeline;
};
static inline void
_mesa_unmarshal_ValidateProgramPipeline(struct gl_context *ctx, const struct marshal_cmd_ValidateProgramPipeline *cmd)
{
   const GLuint pipeline = cmd->pipeline;
   CALL_ValidateProgramPipeline(ctx->CurrentServerDispatch, (pipeline));
}
static void GLAPIENTRY
_mesa_marshal_ValidateProgramPipeline(GLuint pipeline)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ValidateProgramPipeline);
   struct marshal_cmd_ValidateProgramPipeline *cmd;
   debug_print_marshal("ValidateProgramPipeline");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ValidateProgramPipeline, cmd_size);
      cmd->pipeline = pipeline;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ValidateProgramPipeline");
   CALL_ValidateProgramPipeline(ctx->CurrentServerDispatch, (pipeline));
}


/* BindFragDataLocationIndexed: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_BindFragDataLocationIndexed(GLuint program, GLuint colorNumber, GLuint index, const GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("BindFragDataLocationIndexed");
   CALL_BindFragDataLocationIndexed(ctx->CurrentServerDispatch, (program, colorNumber, index, name));
}


/* GetClipPlane: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetClipPlane(GLenum plane, GLdouble * equation)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetClipPlane");
   CALL_GetClipPlane(ctx->CurrentServerDispatch, (plane, equation));
}


/* DeleteSemaphoresEXT: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_DeleteSemaphoresEXT(GLsizei n, const GLuint * semaphores)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("DeleteSemaphoresEXT");
   CALL_DeleteSemaphoresEXT(ctx->CurrentServerDispatch, (n, semaphores));
}


/* TexCoordP4uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexCoordP4uiv(GLenum type, const GLuint * coords)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexCoordP4uiv");
   CALL_TexCoordP4uiv(ctx->CurrentServerDispatch, (type, coords));
}


/* VertexAttribs3dvNV: marshalled asynchronously */
struct marshal_cmd_VertexAttribs3dvNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLsizei n;
   /* Next safe_mul(n, 24) bytes are GLdouble v[n][3] */
};
static inline void
_mesa_unmarshal_VertexAttribs3dvNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttribs3dvNV *cmd)
{
   const GLuint index = cmd->index;
   const GLsizei n = cmd->n;
   const GLdouble * v;
   const char *variable_data = (const char *) (cmd + 1);
   v = (const GLdouble *) variable_data;
   variable_data += n * 24;
   CALL_VertexAttribs3dvNV(ctx->CurrentServerDispatch, (index, n, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribs3dvNV(GLuint index, GLsizei n, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribs3dvNV) + safe_mul(n, 24);
   struct marshal_cmd_VertexAttribs3dvNV *cmd;
   debug_print_marshal("VertexAttribs3dvNV");
   if (unlikely(safe_mul(n, 24) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribs3dvNV, cmd_size);
      cmd->index = index;
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, v, n * 24);
      variable_data += n * 24;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribs3dvNV");
   CALL_VertexAttribs3dvNV(ctx->CurrentServerDispatch, (index, n, v));
}


/* ProgramUniformMatrix2x4dv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix2x4dv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 64) bytes are GLdouble value[count][8] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix2x4dv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix2x4dv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 64;
   CALL_ProgramUniformMatrix2x4dv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix2x4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix2x4dv) + safe_mul(count, 64);
   struct marshal_cmd_ProgramUniformMatrix2x4dv *cmd;
   debug_print_marshal("ProgramUniformMatrix2x4dv");
   if (unlikely(safe_mul(count, 64) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix2x4dv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 64);
      variable_data += count * 64;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix2x4dv");
   CALL_ProgramUniformMatrix2x4dv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* GenQueries: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GenQueries(GLsizei n, GLuint * ids)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GenQueries");
   CALL_GenQueries(ctx->CurrentServerDispatch, (n, ids));
}


/* ProgramUniform4iv: marshalled asynchronously */
struct marshal_cmd_ProgramUniform4iv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 16) bytes are GLint value[count][4] */
};
static inline void
_mesa_unmarshal_ProgramUniform4iv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform4iv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLint * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLint *) variable_data;
   variable_data += count * 16;
   CALL_ProgramUniform4iv(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform4iv(GLuint program, GLint location, GLsizei count, const GLint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform4iv) + safe_mul(count, 16);
   struct marshal_cmd_ProgramUniform4iv *cmd;
   debug_print_marshal("ProgramUniform4iv");
   if (unlikely(safe_mul(count, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform4iv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 16);
      variable_data += count * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform4iv");
   CALL_ProgramUniform4iv(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* ObjectUnpurgeableAPPLE: marshalled synchronously */
static GLenum GLAPIENTRY
_mesa_marshal_ObjectUnpurgeableAPPLE(GLenum objectType, GLuint name, GLenum option)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ObjectUnpurgeableAPPLE");
   return CALL_ObjectUnpurgeableAPPLE(ctx->CurrentServerDispatch, (objectType, name, option));
}


/* GetCompressedTextureSubImage: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetCompressedTextureSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLsizei bufSize, GLvoid * pixels)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetCompressedTextureSubImage");
   CALL_GetCompressedTextureSubImage(ctx->CurrentServerDispatch, (texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, pixels));
}


/* TexCoord2iv: marshalled asynchronously */
struct marshal_cmd_TexCoord2iv
{
   struct marshal_cmd_base cmd_base;
   GLint v[2];
};
static inline void
_mesa_unmarshal_TexCoord2iv(struct gl_context *ctx, const struct marshal_cmd_TexCoord2iv *cmd)
{
   const GLint * v = cmd->v;
   CALL_TexCoord2iv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord2iv(const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord2iv);
   struct marshal_cmd_TexCoord2iv *cmd;
   debug_print_marshal("TexCoord2iv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord2iv, cmd_size);
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord2iv");
   CALL_TexCoord2iv(ctx->CurrentServerDispatch, (v));
}


/* TexImage2DMultisample: marshalled asynchronously */
struct marshal_cmd_TexImage2DMultisample
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizei samples;
   GLenum internalformat;
   GLsizei width;
   GLsizei height;
   GLboolean fixedsamplelocations;
};
static inline void
_mesa_unmarshal_TexImage2DMultisample(struct gl_context *ctx, const struct marshal_cmd_TexImage2DMultisample *cmd)
{
   const GLenum target = cmd->target;
   const GLsizei samples = cmd->samples;
   const GLenum internalformat = cmd->internalformat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLboolean fixedsamplelocations = cmd->fixedsamplelocations;
   CALL_TexImage2DMultisample(ctx->CurrentServerDispatch, (target, samples, internalformat, width, height, fixedsamplelocations));
}
static void GLAPIENTRY
_mesa_marshal_TexImage2DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexImage2DMultisample);
   struct marshal_cmd_TexImage2DMultisample *cmd;
   debug_print_marshal("TexImage2DMultisample");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexImage2DMultisample, cmd_size);
      cmd->target = target;
      cmd->samples = samples;
      cmd->internalformat = internalformat;
      cmd->width = width;
      cmd->height = height;
      cmd->fixedsamplelocations = fixedsamplelocations;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexImage2DMultisample");
   CALL_TexImage2DMultisample(ctx->CurrentServerDispatch, (target, samples, internalformat, width, height, fixedsamplelocations));
}


/* TexParameterx: marshalled asynchronously */
struct marshal_cmd_TexParameterx
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum pname;
   GLfixed param;
};
static inline void
_mesa_unmarshal_TexParameterx(struct gl_context *ctx, const struct marshal_cmd_TexParameterx *cmd)
{
   const GLenum target = cmd->target;
   const GLenum pname = cmd->pname;
   const GLfixed param = cmd->param;
   CALL_TexParameterx(ctx->CurrentServerDispatch, (target, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_TexParameterx(GLenum target, GLenum pname, GLfixed param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexParameterx);
   struct marshal_cmd_TexParameterx *cmd;
   debug_print_marshal("TexParameterx");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexParameterx, cmd_size);
      cmd->target = target;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexParameterx");
   CALL_TexParameterx(ctx->CurrentServerDispatch, (target, pname, param));
}


/* Rotatef: marshalled asynchronously */
struct marshal_cmd_Rotatef
{
   struct marshal_cmd_base cmd_base;
   GLfloat angle;
   GLfloat x;
   GLfloat y;
   GLfloat z;
};
static inline void
_mesa_unmarshal_Rotatef(struct gl_context *ctx, const struct marshal_cmd_Rotatef *cmd)
{
   const GLfloat angle = cmd->angle;
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   CALL_Rotatef(ctx->CurrentServerDispatch, (angle, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Rotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Rotatef);
   struct marshal_cmd_Rotatef *cmd;
   debug_print_marshal("Rotatef");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Rotatef, cmd_size);
      cmd->angle = angle;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Rotatef");
   CALL_Rotatef(ctx->CurrentServerDispatch, (angle, x, y, z));
}


/* TexParameterf: marshalled asynchronously */
struct marshal_cmd_TexParameterf
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum pname;
   GLfloat param;
};
static inline void
_mesa_unmarshal_TexParameterf(struct gl_context *ctx, const struct marshal_cmd_TexParameterf *cmd)
{
   const GLenum target = cmd->target;
   const GLenum pname = cmd->pname;
   const GLfloat param = cmd->param;
   CALL_TexParameterf(ctx->CurrentServerDispatch, (target, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_TexParameterf(GLenum target, GLenum pname, GLfloat param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexParameterf);
   struct marshal_cmd_TexParameterf *cmd;
   debug_print_marshal("TexParameterf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexParameterf, cmd_size);
      cmd->target = target;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexParameterf");
   CALL_TexParameterf(ctx->CurrentServerDispatch, (target, pname, param));
}


/* TexParameteri: marshalled asynchronously */
struct marshal_cmd_TexParameteri
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum pname;
   GLint param;
};
static inline void
_mesa_unmarshal_TexParameteri(struct gl_context *ctx, const struct marshal_cmd_TexParameteri *cmd)
{
   const GLenum target = cmd->target;
   const GLenum pname = cmd->pname;
   const GLint param = cmd->param;
   CALL_TexParameteri(ctx->CurrentServerDispatch, (target, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_TexParameteri(GLenum target, GLenum pname, GLint param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexParameteri);
   struct marshal_cmd_TexParameteri *cmd;
   debug_print_marshal("TexParameteri");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexParameteri, cmd_size);
      cmd->target = target;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexParameteri");
   CALL_TexParameteri(ctx->CurrentServerDispatch, (target, pname, param));
}


/* GetUniformiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetUniformiv(GLuint program, GLint location, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetUniformiv");
   CALL_GetUniformiv(ctx->CurrentServerDispatch, (program, location, params));
}


/* ClearBufferSubData: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ClearBufferSubData(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const GLvoid * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ClearBufferSubData");
   CALL_ClearBufferSubData(ctx->CurrentServerDispatch, (target, internalformat, offset, size, format, type, data));
}


/* TextureParameterfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TextureParameterfv(GLuint texture, GLenum pname, const GLfloat * param)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TextureParameterfv");
   CALL_TextureParameterfv(ctx->CurrentServerDispatch, (texture, pname, param));
}


/* VDPAUFiniNV: marshalled asynchronously */
struct marshal_cmd_VDPAUFiniNV
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_VDPAUFiniNV(struct gl_context *ctx, const struct marshal_cmd_VDPAUFiniNV *cmd)
{
   CALL_VDPAUFiniNV(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_VDPAUFiniNV(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VDPAUFiniNV);
   struct marshal_cmd_VDPAUFiniNV *cmd;
   debug_print_marshal("VDPAUFiniNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VDPAUFiniNV, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VDPAUFiniNV");
   CALL_VDPAUFiniNV(ctx->CurrentServerDispatch, ());
}


/* ProgramUniformMatrix4x2fv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix4x2fv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 32) bytes are GLfloat value[count][8] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix4x2fv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix4x2fv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 32;
   CALL_ProgramUniformMatrix4x2fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix4x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix4x2fv) + safe_mul(count, 32);
   struct marshal_cmd_ProgramUniformMatrix4x2fv *cmd;
   debug_print_marshal("ProgramUniformMatrix4x2fv");
   if (unlikely(safe_mul(count, 32) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix4x2fv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 32);
      variable_data += count * 32;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix4x2fv");
   CALL_ProgramUniformMatrix4x2fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* ProgramUniform2f: marshalled asynchronously */
struct marshal_cmd_ProgramUniform2f
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLfloat x;
   GLfloat y;
};
static inline void
_mesa_unmarshal_ProgramUniform2f(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform2f *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   CALL_ProgramUniform2f(ctx->CurrentServerDispatch, (program, location, x, y));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform2f(GLuint program, GLint location, GLfloat x, GLfloat y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform2f);
   struct marshal_cmd_ProgramUniform2f *cmd;
   debug_print_marshal("ProgramUniform2f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform2f, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform2f");
   CALL_ProgramUniform2f(ctx->CurrentServerDispatch, (program, location, x, y));
}


/* ProgramUniform2d: marshalled asynchronously */
struct marshal_cmd_ProgramUniform2d
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLdouble x;
   GLdouble y;
};
static inline void
_mesa_unmarshal_ProgramUniform2d(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform2d *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   CALL_ProgramUniform2d(ctx->CurrentServerDispatch, (program, location, x, y));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform2d(GLuint program, GLint location, GLdouble x, GLdouble y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform2d);
   struct marshal_cmd_ProgramUniform2d *cmd;
   debug_print_marshal("ProgramUniform2d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform2d, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform2d");
   CALL_ProgramUniform2d(ctx->CurrentServerDispatch, (program, location, x, y));
}


/* ProgramUniform2i: marshalled asynchronously */
struct marshal_cmd_ProgramUniform2i
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLint x;
   GLint y;
};
static inline void
_mesa_unmarshal_ProgramUniform2i(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform2i *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   CALL_ProgramUniform2i(ctx->CurrentServerDispatch, (program, location, x, y));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform2i(GLuint program, GLint location, GLint x, GLint y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform2i);
   struct marshal_cmd_ProgramUniform2i *cmd;
   debug_print_marshal("ProgramUniform2i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform2i, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform2i");
   CALL_ProgramUniform2i(ctx->CurrentServerDispatch, (program, location, x, y));
}


/* Fogx: marshalled asynchronously */
struct marshal_cmd_Fogx
{
   struct marshal_cmd_base cmd_base;
   GLenum pname;
   GLfixed param;
};
static inline void
_mesa_unmarshal_Fogx(struct gl_context *ctx, const struct marshal_cmd_Fogx *cmd)
{
   const GLenum pname = cmd->pname;
   const GLfixed param = cmd->param;
   CALL_Fogx(ctx->CurrentServerDispatch, (pname, param));
}
static void GLAPIENTRY
_mesa_marshal_Fogx(GLenum pname, GLfixed param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Fogx);
   struct marshal_cmd_Fogx *cmd;
   debug_print_marshal("Fogx");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Fogx, cmd_size);
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Fogx");
   CALL_Fogx(ctx->CurrentServerDispatch, (pname, param));
}


/* Uniform3ui64ARB: marshalled asynchronously */
struct marshal_cmd_Uniform3ui64ARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLuint64 x;
   GLuint64 y;
   GLuint64 z;
};
static inline void
_mesa_unmarshal_Uniform3ui64ARB(struct gl_context *ctx, const struct marshal_cmd_Uniform3ui64ARB *cmd)
{
   const GLint location = cmd->location;
   const GLuint64 x = cmd->x;
   const GLuint64 y = cmd->y;
   const GLuint64 z = cmd->z;
   CALL_Uniform3ui64ARB(ctx->CurrentServerDispatch, (location, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Uniform3ui64ARB(GLint location, GLuint64 x, GLuint64 y, GLuint64 z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform3ui64ARB);
   struct marshal_cmd_Uniform3ui64ARB *cmd;
   debug_print_marshal("Uniform3ui64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform3ui64ARB, cmd_size);
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform3ui64ARB");
   CALL_Uniform3ui64ARB(ctx->CurrentServerDispatch, (location, x, y, z));
}


/* Fogf: marshalled asynchronously */
struct marshal_cmd_Fogf
{
   struct marshal_cmd_base cmd_base;
   GLenum pname;
   GLfloat param;
};
static inline void
_mesa_unmarshal_Fogf(struct gl_context *ctx, const struct marshal_cmd_Fogf *cmd)
{
   const GLenum pname = cmd->pname;
   const GLfloat param = cmd->param;
   CALL_Fogf(ctx->CurrentServerDispatch, (pname, param));
}
static void GLAPIENTRY
_mesa_marshal_Fogf(GLenum pname, GLfloat param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Fogf);
   struct marshal_cmd_Fogf *cmd;
   debug_print_marshal("Fogf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Fogf, cmd_size);
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Fogf");
   CALL_Fogf(ctx->CurrentServerDispatch, (pname, param));
}


/* TexSubImage1D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid * pixels)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexSubImage1D");
   CALL_TexSubImage1D(ctx->CurrentServerDispatch, (target, level, xoffset, width, format, type, pixels));
}


/* ProgramUniform3ui64vARB: marshalled asynchronously */
struct marshal_cmd_ProgramUniform3ui64vARB
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 24) bytes are GLuint64 value[count][3] */
};
static inline void
_mesa_unmarshal_ProgramUniform3ui64vARB(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform3ui64vARB *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLuint64 * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLuint64 *) variable_data;
   variable_data += count * 24;
   CALL_ProgramUniform3ui64vARB(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform3ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform3ui64vARB) + safe_mul(count, 24);
   struct marshal_cmd_ProgramUniform3ui64vARB *cmd;
   debug_print_marshal("ProgramUniform3ui64vARB");
   if (unlikely(safe_mul(count, 24) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform3ui64vARB, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 24);
      variable_data += count * 24;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform3ui64vARB");
   CALL_ProgramUniform3ui64vARB(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* Color4usv: marshalled asynchronously */
struct marshal_cmd_Color4usv
{
   struct marshal_cmd_base cmd_base;
   GLushort v[4];
};
static inline void
_mesa_unmarshal_Color4usv(struct gl_context *ctx, const struct marshal_cmd_Color4usv *cmd)
{
   const GLushort * v = cmd->v;
   CALL_Color4usv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Color4usv(const GLushort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color4usv);
   struct marshal_cmd_Color4usv *cmd;
   debug_print_marshal("Color4usv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color4usv, cmd_size);
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color4usv");
   CALL_Color4usv(ctx->CurrentServerDispatch, (v));
}


/* Fogi: marshalled asynchronously */
struct marshal_cmd_Fogi
{
   struct marshal_cmd_base cmd_base;
   GLenum pname;
   GLint param;
};
static inline void
_mesa_unmarshal_Fogi(struct gl_context *ctx, const struct marshal_cmd_Fogi *cmd)
{
   const GLenum pname = cmd->pname;
   const GLint param = cmd->param;
   CALL_Fogi(ctx->CurrentServerDispatch, (pname, param));
}
static void GLAPIENTRY
_mesa_marshal_Fogi(GLenum pname, GLint param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Fogi);
   struct marshal_cmd_Fogi *cmd;
   debug_print_marshal("Fogi");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Fogi, cmd_size);
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Fogi");
   CALL_Fogi(ctx->CurrentServerDispatch, (pname, param));
}


/* DepthFunc: marshalled asynchronously */
struct marshal_cmd_DepthFunc
{
   struct marshal_cmd_base cmd_base;
   GLenum func;
};
static inline void
_mesa_unmarshal_DepthFunc(struct gl_context *ctx, const struct marshal_cmd_DepthFunc *cmd)
{
   const GLenum func = cmd->func;
   CALL_DepthFunc(ctx->CurrentServerDispatch, (func));
}
static void GLAPIENTRY
_mesa_marshal_DepthFunc(GLenum func)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DepthFunc);
   struct marshal_cmd_DepthFunc *cmd;
   debug_print_marshal("DepthFunc");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DepthFunc, cmd_size);
      cmd->func = func;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DepthFunc");
   CALL_DepthFunc(ctx->CurrentServerDispatch, (func));
}


/* GetSamplerParameterIiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetSamplerParameterIiv(GLuint sampler, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetSamplerParameterIiv");
   CALL_GetSamplerParameterIiv(ctx->CurrentServerDispatch, (sampler, pname, params));
}


/* VertexArrayAttribLFormat: marshalled asynchronously */
struct marshal_cmd_VertexArrayAttribLFormat
{
   struct marshal_cmd_base cmd_base;
   GLuint vaobj;
   GLuint attribindex;
   GLint size;
   GLenum type;
   GLuint relativeoffset;
};
static inline void
_mesa_unmarshal_VertexArrayAttribLFormat(struct gl_context *ctx, const struct marshal_cmd_VertexArrayAttribLFormat *cmd)
{
   const GLuint vaobj = cmd->vaobj;
   const GLuint attribindex = cmd->attribindex;
   const GLint size = cmd->size;
   const GLenum type = cmd->type;
   const GLuint relativeoffset = cmd->relativeoffset;
   CALL_VertexArrayAttribLFormat(ctx->CurrentServerDispatch, (vaobj, attribindex, size, type, relativeoffset));
}
static void GLAPIENTRY
_mesa_marshal_VertexArrayAttribLFormat(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexArrayAttribLFormat);
   struct marshal_cmd_VertexArrayAttribLFormat *cmd;
   debug_print_marshal("VertexArrayAttribLFormat");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexArrayAttribLFormat, cmd_size);
      cmd->vaobj = vaobj;
      cmd->attribindex = attribindex;
      cmd->size = size;
      cmd->type = type;
      cmd->relativeoffset = relativeoffset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexArrayAttribLFormat");
   CALL_VertexArrayAttribLFormat(ctx->CurrentServerDispatch, (vaobj, attribindex, size, type, relativeoffset));
}


/* VertexAttribI4uiEXT: marshalled asynchronously */
struct marshal_cmd_VertexAttribI4uiEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLuint x;
   GLuint y;
   GLuint z;
   GLuint w;
};
static inline void
_mesa_unmarshal_VertexAttribI4uiEXT(struct gl_context *ctx, const struct marshal_cmd_VertexAttribI4uiEXT *cmd)
{
   const GLuint index = cmd->index;
   const GLuint x = cmd->x;
   const GLuint y = cmd->y;
   const GLuint z = cmd->z;
   const GLuint w = cmd->w;
   CALL_VertexAttribI4uiEXT(ctx->CurrentServerDispatch, (index, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribI4uiEXT(GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribI4uiEXT);
   struct marshal_cmd_VertexAttribI4uiEXT *cmd;
   debug_print_marshal("VertexAttribI4uiEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribI4uiEXT, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribI4uiEXT");
   CALL_VertexAttribI4uiEXT(ctx->CurrentServerDispatch, (index, x, y, z, w));
}


/* DrawElementsInstancedBaseVertexBaseInstance: marshalled asynchronously */
struct marshal_cmd_DrawElementsInstancedBaseVertexBaseInstance
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
   GLsizei count;
   GLenum type;
   const GLvoid * indices;
   GLsizei primcount;
   GLint basevertex;
   GLuint baseinstance;
};
static inline void
_mesa_unmarshal_DrawElementsInstancedBaseVertexBaseInstance(struct gl_context *ctx, const struct marshal_cmd_DrawElementsInstancedBaseVertexBaseInstance *cmd)
{
   const GLenum mode = cmd->mode;
   const GLsizei count = cmd->count;
   const GLenum type = cmd->type;
   const GLvoid * indices = cmd->indices;
   const GLsizei primcount = cmd->primcount;
   const GLint basevertex = cmd->basevertex;
   const GLuint baseinstance = cmd->baseinstance;
   CALL_DrawElementsInstancedBaseVertexBaseInstance(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount, basevertex, baseinstance));
}
static void GLAPIENTRY
_mesa_marshal_DrawElementsInstancedBaseVertexBaseInstance(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei primcount, GLint basevertex, GLuint baseinstance)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawElementsInstancedBaseVertexBaseInstance);
   struct marshal_cmd_DrawElementsInstancedBaseVertexBaseInstance *cmd;
   debug_print_marshal("DrawElementsInstancedBaseVertexBaseInstance");
   if (_mesa_glthread_is_non_vbo_draw_elements(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("DrawElementsInstancedBaseVertexBaseInstance");
      CALL_DrawElementsInstancedBaseVertexBaseInstance(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount, basevertex, baseinstance));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawElementsInstancedBaseVertexBaseInstance, cmd_size);
      cmd->mode = mode;
      cmd->count = count;
      cmd->type = type;
      cmd->indices = indices;
      cmd->primcount = primcount;
      cmd->basevertex = basevertex;
      cmd->baseinstance = baseinstance;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawElementsInstancedBaseVertexBaseInstance");
   CALL_DrawElementsInstancedBaseVertexBaseInstance(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount, basevertex, baseinstance));
}


/* ProgramEnvParameter4dvARB: marshalled asynchronously */
struct marshal_cmd_ProgramEnvParameter4dvARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
   GLdouble params[4];
};
static inline void
_mesa_unmarshal_ProgramEnvParameter4dvARB(struct gl_context *ctx, const struct marshal_cmd_ProgramEnvParameter4dvARB *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   const GLdouble * params = cmd->params;
   CALL_ProgramEnvParameter4dvARB(ctx->CurrentServerDispatch, (target, index, params));
}
static void GLAPIENTRY
_mesa_marshal_ProgramEnvParameter4dvARB(GLenum target, GLuint index, const GLdouble * params)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramEnvParameter4dvARB);
   struct marshal_cmd_ProgramEnvParameter4dvARB *cmd;
   debug_print_marshal("ProgramEnvParameter4dvARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramEnvParameter4dvARB, cmd_size);
      cmd->target = target;
      cmd->index = index;
      memcpy(cmd->params, params, 32);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramEnvParameter4dvARB");
   CALL_ProgramEnvParameter4dvARB(ctx->CurrentServerDispatch, (target, index, params));
}


/* ColorTableParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ColorTableParameteriv(GLenum target, GLenum pname, const GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ColorTableParameteriv");
   CALL_ColorTableParameteriv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* BindSamplers: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_BindSamplers(GLuint first, GLsizei count, const GLuint * samplers)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("BindSamplers");
   CALL_BindSamplers(ctx->CurrentServerDispatch, (first, count, samplers));
}


/* GetnCompressedTexImageARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnCompressedTexImageARB(GLenum target, GLint lod, GLsizei bufSize, GLvoid * img)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnCompressedTexImageARB");
   CALL_GetnCompressedTexImageARB(ctx->CurrentServerDispatch, (target, lod, bufSize, img));
}


/* CopyNamedBufferSubData: marshalled asynchronously */
struct marshal_cmd_CopyNamedBufferSubData
{
   struct marshal_cmd_base cmd_base;
   GLuint readBuffer;
   GLuint writeBuffer;
   GLintptr readOffset;
   GLintptr writeOffset;
   GLsizeiptr size;
};
static inline void
_mesa_unmarshal_CopyNamedBufferSubData(struct gl_context *ctx, const struct marshal_cmd_CopyNamedBufferSubData *cmd)
{
   const GLuint readBuffer = cmd->readBuffer;
   const GLuint writeBuffer = cmd->writeBuffer;
   const GLintptr readOffset = cmd->readOffset;
   const GLintptr writeOffset = cmd->writeOffset;
   const GLsizeiptr size = cmd->size;
   CALL_CopyNamedBufferSubData(ctx->CurrentServerDispatch, (readBuffer, writeBuffer, readOffset, writeOffset, size));
}
static void GLAPIENTRY
_mesa_marshal_CopyNamedBufferSubData(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_CopyNamedBufferSubData);
   struct marshal_cmd_CopyNamedBufferSubData *cmd;
   debug_print_marshal("CopyNamedBufferSubData");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_CopyNamedBufferSubData, cmd_size);
      cmd->readBuffer = readBuffer;
      cmd->writeBuffer = writeBuffer;
      cmd->readOffset = readOffset;
      cmd->writeOffset = writeOffset;
      cmd->size = size;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("CopyNamedBufferSubData");
   CALL_CopyNamedBufferSubData(ctx->CurrentServerDispatch, (readBuffer, writeBuffer, readOffset, writeOffset, size));
}


/* BindSampler: marshalled asynchronously */
struct marshal_cmd_BindSampler
{
   struct marshal_cmd_base cmd_base;
   GLuint unit;
   GLuint sampler;
};
static inline void
_mesa_unmarshal_BindSampler(struct gl_context *ctx, const struct marshal_cmd_BindSampler *cmd)
{
   const GLuint unit = cmd->unit;
   const GLuint sampler = cmd->sampler;
   CALL_BindSampler(ctx->CurrentServerDispatch, (unit, sampler));
}
static void GLAPIENTRY
_mesa_marshal_BindSampler(GLuint unit, GLuint sampler)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindSampler);
   struct marshal_cmd_BindSampler *cmd;
   debug_print_marshal("BindSampler");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindSampler, cmd_size);
      cmd->unit = unit;
      cmd->sampler = sampler;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindSampler");
   CALL_BindSampler(ctx->CurrentServerDispatch, (unit, sampler));
}


/* GetUniformuiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetUniformuiv(GLuint program, GLint location, GLuint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetUniformuiv");
   CALL_GetUniformuiv(ctx->CurrentServerDispatch, (program, location, params));
}


/* GetQueryBufferObjectuiv: marshalled asynchronously */
struct marshal_cmd_GetQueryBufferObjectuiv
{
   struct marshal_cmd_base cmd_base;
   GLuint id;
   GLuint buffer;
   GLenum pname;
   GLintptr offset;
};
static inline void
_mesa_unmarshal_GetQueryBufferObjectuiv(struct gl_context *ctx, const struct marshal_cmd_GetQueryBufferObjectuiv *cmd)
{
   const GLuint id = cmd->id;
   const GLuint buffer = cmd->buffer;
   const GLenum pname = cmd->pname;
   const GLintptr offset = cmd->offset;
   CALL_GetQueryBufferObjectuiv(ctx->CurrentServerDispatch, (id, buffer, pname, offset));
}
static void GLAPIENTRY
_mesa_marshal_GetQueryBufferObjectuiv(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_GetQueryBufferObjectuiv);
   struct marshal_cmd_GetQueryBufferObjectuiv *cmd;
   debug_print_marshal("GetQueryBufferObjectuiv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_GetQueryBufferObjectuiv, cmd_size);
      cmd->id = id;
      cmd->buffer = buffer;
      cmd->pname = pname;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("GetQueryBufferObjectuiv");
   CALL_GetQueryBufferObjectuiv(ctx->CurrentServerDispatch, (id, buffer, pname, offset));
}


/* MultiTexCoord2fARB: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord2fARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLfloat s;
   GLfloat t;
};
static inline void
_mesa_unmarshal_MultiTexCoord2fARB(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord2fARB *cmd)
{
   const GLenum target = cmd->target;
   const GLfloat s = cmd->s;
   const GLfloat t = cmd->t;
   CALL_MultiTexCoord2fARB(ctx->CurrentServerDispatch, (target, s, t));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord2fARB(GLenum target, GLfloat s, GLfloat t)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord2fARB);
   struct marshal_cmd_MultiTexCoord2fARB *cmd;
   debug_print_marshal("MultiTexCoord2fARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord2fARB, cmd_size);
      cmd->target = target;
      cmd->s = s;
      cmd->t = t;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord2fARB");
   CALL_MultiTexCoord2fARB(ctx->CurrentServerDispatch, (target, s, t));
}


/* Uniform1ui64ARB: marshalled asynchronously */
struct marshal_cmd_Uniform1ui64ARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLuint64 x;
};
static inline void
_mesa_unmarshal_Uniform1ui64ARB(struct gl_context *ctx, const struct marshal_cmd_Uniform1ui64ARB *cmd)
{
   const GLint location = cmd->location;
   const GLuint64 x = cmd->x;
   CALL_Uniform1ui64ARB(ctx->CurrentServerDispatch, (location, x));
}
static void GLAPIENTRY
_mesa_marshal_Uniform1ui64ARB(GLint location, GLuint64 x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform1ui64ARB);
   struct marshal_cmd_Uniform1ui64ARB *cmd;
   debug_print_marshal("Uniform1ui64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform1ui64ARB, cmd_size);
      cmd->location = location;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform1ui64ARB");
   CALL_Uniform1ui64ARB(ctx->CurrentServerDispatch, (location, x));
}


/* GetTextureImage: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTextureImage(GLuint texture, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid * pixels)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTextureImage");
   CALL_GetTextureImage(ctx->CurrentServerDispatch, (texture, level, format, type, bufSize, pixels));
}


/* MultiTexCoord3iv: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord3iv
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLint v[3];
};
static inline void
_mesa_unmarshal_MultiTexCoord3iv(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord3iv *cmd)
{
   const GLenum target = cmd->target;
   const GLint * v = cmd->v;
   CALL_MultiTexCoord3iv(ctx->CurrentServerDispatch, (target, v));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord3iv(GLenum target, const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord3iv);
   struct marshal_cmd_MultiTexCoord3iv *cmd;
   debug_print_marshal("MultiTexCoord3iv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord3iv, cmd_size);
      cmd->target = target;
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord3iv");
   CALL_MultiTexCoord3iv(ctx->CurrentServerDispatch, (target, v));
}


/* Finish: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_Finish(void)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("Finish");
   CALL_Finish(ctx->CurrentServerDispatch, ());
}


/* ClearStencil: marshalled asynchronously */
struct marshal_cmd_ClearStencil
{
   struct marshal_cmd_base cmd_base;
   GLint s;
};
static inline void
_mesa_unmarshal_ClearStencil(struct gl_context *ctx, const struct marshal_cmd_ClearStencil *cmd)
{
   const GLint s = cmd->s;
   CALL_ClearStencil(ctx->CurrentServerDispatch, (s));
}
static void GLAPIENTRY
_mesa_marshal_ClearStencil(GLint s)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClearStencil);
   struct marshal_cmd_ClearStencil *cmd;
   debug_print_marshal("ClearStencil");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClearStencil, cmd_size);
      cmd->s = s;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClearStencil");
   CALL_ClearStencil(ctx->CurrentServerDispatch, (s));
}


/* ClearColorIiEXT: marshalled asynchronously */
struct marshal_cmd_ClearColorIiEXT
{
   struct marshal_cmd_base cmd_base;
   GLint r;
   GLint g;
   GLint b;
   GLint a;
};
static inline void
_mesa_unmarshal_ClearColorIiEXT(struct gl_context *ctx, const struct marshal_cmd_ClearColorIiEXT *cmd)
{
   const GLint r = cmd->r;
   const GLint g = cmd->g;
   const GLint b = cmd->b;
   const GLint a = cmd->a;
   CALL_ClearColorIiEXT(ctx->CurrentServerDispatch, (r, g, b, a));
}
static void GLAPIENTRY
_mesa_marshal_ClearColorIiEXT(GLint r, GLint g, GLint b, GLint a)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClearColorIiEXT);
   struct marshal_cmd_ClearColorIiEXT *cmd;
   debug_print_marshal("ClearColorIiEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClearColorIiEXT, cmd_size);
      cmd->r = r;
      cmd->g = g;
      cmd->b = b;
      cmd->a = a;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClearColorIiEXT");
   CALL_ClearColorIiEXT(ctx->CurrentServerDispatch, (r, g, b, a));
}


/* LoadMatrixd: marshalled asynchronously */
struct marshal_cmd_LoadMatrixd
{
   struct marshal_cmd_base cmd_base;
   GLdouble m[16];
};
static inline void
_mesa_unmarshal_LoadMatrixd(struct gl_context *ctx, const struct marshal_cmd_LoadMatrixd *cmd)
{
   const GLdouble * m = cmd->m;
   CALL_LoadMatrixd(ctx->CurrentServerDispatch, (m));
}
static void GLAPIENTRY
_mesa_marshal_LoadMatrixd(const GLdouble * m)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_LoadMatrixd);
   struct marshal_cmd_LoadMatrixd *cmd;
   debug_print_marshal("LoadMatrixd");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_LoadMatrixd, cmd_size);
      memcpy(cmd->m, m, 128);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("LoadMatrixd");
   CALL_LoadMatrixd(ctx->CurrentServerDispatch, (m));
}


/* VDPAURegisterOutputSurfaceNV: marshalled synchronously */
static GLintptr GLAPIENTRY
_mesa_marshal_VDPAURegisterOutputSurfaceNV(const GLvoid * vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint * textureNames)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VDPAURegisterOutputSurfaceNV");
   return CALL_VDPAURegisterOutputSurfaceNV(ctx->CurrentServerDispatch, (vdpSurface, target, numTextureNames, textureNames));
}


/* VertexP4ui: marshalled asynchronously */
struct marshal_cmd_VertexP4ui
{
   struct marshal_cmd_base cmd_base;
   GLenum type;
   GLuint value;
};
static inline void
_mesa_unmarshal_VertexP4ui(struct gl_context *ctx, const struct marshal_cmd_VertexP4ui *cmd)
{
   const GLenum type = cmd->type;
   const GLuint value = cmd->value;
   CALL_VertexP4ui(ctx->CurrentServerDispatch, (type, value));
}
static void GLAPIENTRY
_mesa_marshal_VertexP4ui(GLenum type, GLuint value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexP4ui);
   struct marshal_cmd_VertexP4ui *cmd;
   debug_print_marshal("VertexP4ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexP4ui, cmd_size);
      cmd->type = type;
      cmd->value = value;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexP4ui");
   CALL_VertexP4ui(ctx->CurrentServerDispatch, (type, value));
}


/* GetProgramResourceIndex: marshalled synchronously */
static GLuint GLAPIENTRY
_mesa_marshal_GetProgramResourceIndex(GLuint program, GLenum programInterface, const GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramResourceIndex");
   return CALL_GetProgramResourceIndex(ctx->CurrentServerDispatch, (program, programInterface, name));
}


/* TextureStorage3DMultisample: marshalled asynchronously */
struct marshal_cmd_TextureStorage3DMultisample
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLsizei samples;
   GLenum internalformat;
   GLsizei width;
   GLsizei height;
   GLsizei depth;
   GLboolean fixedsamplelocations;
};
static inline void
_mesa_unmarshal_TextureStorage3DMultisample(struct gl_context *ctx, const struct marshal_cmd_TextureStorage3DMultisample *cmd)
{
   const GLuint texture = cmd->texture;
   const GLsizei samples = cmd->samples;
   const GLenum internalformat = cmd->internalformat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLsizei depth = cmd->depth;
   const GLboolean fixedsamplelocations = cmd->fixedsamplelocations;
   CALL_TextureStorage3DMultisample(ctx->CurrentServerDispatch, (texture, samples, internalformat, width, height, depth, fixedsamplelocations));
}
static void GLAPIENTRY
_mesa_marshal_TextureStorage3DMultisample(GLuint texture, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureStorage3DMultisample);
   struct marshal_cmd_TextureStorage3DMultisample *cmd;
   debug_print_marshal("TextureStorage3DMultisample");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureStorage3DMultisample, cmd_size);
      cmd->texture = texture;
      cmd->samples = samples;
      cmd->internalformat = internalformat;
      cmd->width = width;
      cmd->height = height;
      cmd->depth = depth;
      cmd->fixedsamplelocations = fixedsamplelocations;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureStorage3DMultisample");
   CALL_TextureStorage3DMultisample(ctx->CurrentServerDispatch, (texture, samples, internalformat, width, height, depth, fixedsamplelocations));
}


/* GetnUniformivARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnUniformivARB(GLuint program, GLint location, GLsizei bufSize, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnUniformivARB");
   CALL_GetnUniformivARB(ctx->CurrentServerDispatch, (program, location, bufSize, params));
}


/* ReleaseShaderCompiler: marshalled asynchronously */
struct marshal_cmd_ReleaseShaderCompiler
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_ReleaseShaderCompiler(struct gl_context *ctx, const struct marshal_cmd_ReleaseShaderCompiler *cmd)
{
   CALL_ReleaseShaderCompiler(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_ReleaseShaderCompiler(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ReleaseShaderCompiler);
   struct marshal_cmd_ReleaseShaderCompiler *cmd;
   debug_print_marshal("ReleaseShaderCompiler");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ReleaseShaderCompiler, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ReleaseShaderCompiler");
   CALL_ReleaseShaderCompiler(ctx->CurrentServerDispatch, ());
}


/* BlendFuncSeparate: marshalled asynchronously */
struct marshal_cmd_BlendFuncSeparate
{
   struct marshal_cmd_base cmd_base;
   GLenum sfactorRGB;
   GLenum dfactorRGB;
   GLenum sfactorAlpha;
   GLenum dfactorAlpha;
};
static inline void
_mesa_unmarshal_BlendFuncSeparate(struct gl_context *ctx, const struct marshal_cmd_BlendFuncSeparate *cmd)
{
   const GLenum sfactorRGB = cmd->sfactorRGB;
   const GLenum dfactorRGB = cmd->dfactorRGB;
   const GLenum sfactorAlpha = cmd->sfactorAlpha;
   const GLenum dfactorAlpha = cmd->dfactorAlpha;
   CALL_BlendFuncSeparate(ctx->CurrentServerDispatch, (sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha));
}
static void GLAPIENTRY
_mesa_marshal_BlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BlendFuncSeparate);
   struct marshal_cmd_BlendFuncSeparate *cmd;
   debug_print_marshal("BlendFuncSeparate");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BlendFuncSeparate, cmd_size);
      cmd->sfactorRGB = sfactorRGB;
      cmd->dfactorRGB = dfactorRGB;
      cmd->sfactorAlpha = sfactorAlpha;
      cmd->dfactorAlpha = dfactorAlpha;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BlendFuncSeparate");
   CALL_BlendFuncSeparate(ctx->CurrentServerDispatch, (sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha));
}


/* Color3us: marshalled asynchronously */
struct marshal_cmd_Color3us
{
   struct marshal_cmd_base cmd_base;
   GLushort red;
   GLushort green;
   GLushort blue;
};
static inline void
_mesa_unmarshal_Color3us(struct gl_context *ctx, const struct marshal_cmd_Color3us *cmd)
{
   const GLushort red = cmd->red;
   const GLushort green = cmd->green;
   const GLushort blue = cmd->blue;
   CALL_Color3us(ctx->CurrentServerDispatch, (red, green, blue));
}
static void GLAPIENTRY
_mesa_marshal_Color3us(GLushort red, GLushort green, GLushort blue)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color3us);
   struct marshal_cmd_Color3us *cmd;
   debug_print_marshal("Color3us");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color3us, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color3us");
   CALL_Color3us(ctx->CurrentServerDispatch, (red, green, blue));
}


/* LoadMatrixx: marshalled asynchronously */
struct marshal_cmd_LoadMatrixx
{
   struct marshal_cmd_base cmd_base;
   GLfixed m[16];
};
static inline void
_mesa_unmarshal_LoadMatrixx(struct gl_context *ctx, const struct marshal_cmd_LoadMatrixx *cmd)
{
   const GLfixed * m = cmd->m;
   CALL_LoadMatrixx(ctx->CurrentServerDispatch, (m));
}
static void GLAPIENTRY
_mesa_marshal_LoadMatrixx(const GLfixed * m)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_LoadMatrixx);
   struct marshal_cmd_LoadMatrixx *cmd;
   debug_print_marshal("LoadMatrixx");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_LoadMatrixx, cmd_size);
      memcpy(cmd->m, m, 64);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("LoadMatrixx");
   CALL_LoadMatrixx(ctx->CurrentServerDispatch, (m));
}


/* BufferStorage: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_BufferStorage(GLenum target, GLsizeiptr size, const GLvoid * data, GLbitfield flags)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("BufferStorage");
   CALL_BufferStorage(ctx->CurrentServerDispatch, (target, size, data, flags));
}


/* Color3ub: marshalled asynchronously */
struct marshal_cmd_Color3ub
{
   struct marshal_cmd_base cmd_base;
   GLubyte red;
   GLubyte green;
   GLubyte blue;
};
static inline void
_mesa_unmarshal_Color3ub(struct gl_context *ctx, const struct marshal_cmd_Color3ub *cmd)
{
   const GLubyte red = cmd->red;
   const GLubyte green = cmd->green;
   const GLubyte blue = cmd->blue;
   CALL_Color3ub(ctx->CurrentServerDispatch, (red, green, blue));
}
static void GLAPIENTRY
_mesa_marshal_Color3ub(GLubyte red, GLubyte green, GLubyte blue)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color3ub);
   struct marshal_cmd_Color3ub *cmd;
   debug_print_marshal("Color3ub");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color3ub, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color3ub");
   CALL_Color3ub(ctx->CurrentServerDispatch, (red, green, blue));
}


/* Color3ui: marshalled asynchronously */
struct marshal_cmd_Color3ui
{
   struct marshal_cmd_base cmd_base;
   GLuint red;
   GLuint green;
   GLuint blue;
};
static inline void
_mesa_unmarshal_Color3ui(struct gl_context *ctx, const struct marshal_cmd_Color3ui *cmd)
{
   const GLuint red = cmd->red;
   const GLuint green = cmd->green;
   const GLuint blue = cmd->blue;
   CALL_Color3ui(ctx->CurrentServerDispatch, (red, green, blue));
}
static void GLAPIENTRY
_mesa_marshal_Color3ui(GLuint red, GLuint green, GLuint blue)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color3ui);
   struct marshal_cmd_Color3ui *cmd;
   debug_print_marshal("Color3ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color3ui, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color3ui");
   CALL_Color3ui(ctx->CurrentServerDispatch, (red, green, blue));
}


/* VertexAttrib4dvNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4dvNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4dvNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4dvNV *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble * v = cmd->v;
   CALL_VertexAttrib4dvNV(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4dvNV(GLuint index, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4dvNV);
   struct marshal_cmd_VertexAttrib4dvNV *cmd;
   debug_print_marshal("VertexAttrib4dvNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4dvNV, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 32);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4dvNV");
   CALL_VertexAttrib4dvNV(ctx->CurrentServerDispatch, (index, v));
}


/* AlphaFragmentOp2ATI: marshalled asynchronously */
struct marshal_cmd_AlphaFragmentOp2ATI
{
   struct marshal_cmd_base cmd_base;
   GLenum op;
   GLuint dst;
   GLuint dstMod;
   GLuint arg1;
   GLuint arg1Rep;
   GLuint arg1Mod;
   GLuint arg2;
   GLuint arg2Rep;
   GLuint arg2Mod;
};
static inline void
_mesa_unmarshal_AlphaFragmentOp2ATI(struct gl_context *ctx, const struct marshal_cmd_AlphaFragmentOp2ATI *cmd)
{
   const GLenum op = cmd->op;
   const GLuint dst = cmd->dst;
   const GLuint dstMod = cmd->dstMod;
   const GLuint arg1 = cmd->arg1;
   const GLuint arg1Rep = cmd->arg1Rep;
   const GLuint arg1Mod = cmd->arg1Mod;
   const GLuint arg2 = cmd->arg2;
   const GLuint arg2Rep = cmd->arg2Rep;
   const GLuint arg2Mod = cmd->arg2Mod;
   CALL_AlphaFragmentOp2ATI(ctx->CurrentServerDispatch, (op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod));
}
static void GLAPIENTRY
_mesa_marshal_AlphaFragmentOp2ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_AlphaFragmentOp2ATI);
   struct marshal_cmd_AlphaFragmentOp2ATI *cmd;
   debug_print_marshal("AlphaFragmentOp2ATI");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_AlphaFragmentOp2ATI, cmd_size);
      cmd->op = op;
      cmd->dst = dst;
      cmd->dstMod = dstMod;
      cmd->arg1 = arg1;
      cmd->arg1Rep = arg1Rep;
      cmd->arg1Mod = arg1Mod;
      cmd->arg2 = arg2;
      cmd->arg2Rep = arg2Rep;
      cmd->arg2Mod = arg2Mod;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("AlphaFragmentOp2ATI");
   CALL_AlphaFragmentOp2ATI(ctx->CurrentServerDispatch, (op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod));
}


/* RasterPos4dv: marshalled asynchronously */
struct marshal_cmd_RasterPos4dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v[4];
};
static inline void
_mesa_unmarshal_RasterPos4dv(struct gl_context *ctx, const struct marshal_cmd_RasterPos4dv *cmd)
{
   const GLdouble * v = cmd->v;
   CALL_RasterPos4dv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos4dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos4dv);
   struct marshal_cmd_RasterPos4dv *cmd;
   debug_print_marshal("RasterPos4dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos4dv, cmd_size);
      memcpy(cmd->v, v, 32);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos4dv");
   CALL_RasterPos4dv(ctx->CurrentServerDispatch, (v));
}


/* DeleteProgramPipelines: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_DeleteProgramPipelines(GLsizei n, const GLuint * pipelines)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("DeleteProgramPipelines");
   CALL_DeleteProgramPipelines(ctx->CurrentServerDispatch, (n, pipelines));
}


/* LineWidthx: marshalled asynchronously */
struct marshal_cmd_LineWidthx
{
   struct marshal_cmd_base cmd_base;
   GLfixed width;
};
static inline void
_mesa_unmarshal_LineWidthx(struct gl_context *ctx, const struct marshal_cmd_LineWidthx *cmd)
{
   const GLfixed width = cmd->width;
   CALL_LineWidthx(ctx->CurrentServerDispatch, (width));
}
static void GLAPIENTRY
_mesa_marshal_LineWidthx(GLfixed width)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_LineWidthx);
   struct marshal_cmd_LineWidthx *cmd;
   debug_print_marshal("LineWidthx");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_LineWidthx, cmd_size);
      cmd->width = width;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("LineWidthx");
   CALL_LineWidthx(ctx->CurrentServerDispatch, (width));
}


/* GetTransformFeedbacki_v: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTransformFeedbacki_v(GLuint xfb, GLenum pname, GLuint index, GLint * param)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTransformFeedbacki_v");
   CALL_GetTransformFeedbacki_v(ctx->CurrentServerDispatch, (xfb, pname, index, param));
}


/* Indexdv: marshalled asynchronously */
struct marshal_cmd_Indexdv
{
   struct marshal_cmd_base cmd_base;
   GLdouble c[1];
};
static inline void
_mesa_unmarshal_Indexdv(struct gl_context *ctx, const struct marshal_cmd_Indexdv *cmd)
{
   const GLdouble * c = cmd->c;
   CALL_Indexdv(ctx->CurrentServerDispatch, (c));
}
static void GLAPIENTRY
_mesa_marshal_Indexdv(const GLdouble * c)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Indexdv);
   struct marshal_cmd_Indexdv *cmd;
   debug_print_marshal("Indexdv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Indexdv, cmd_size);
      memcpy(cmd->c, c, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Indexdv");
   CALL_Indexdv(ctx->CurrentServerDispatch, (c));
}


/* GetnPixelMapfvARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnPixelMapfvARB(GLenum map, GLsizei bufSize, GLfloat * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnPixelMapfvARB");
   CALL_GetnPixelMapfvARB(ctx->CurrentServerDispatch, (map, bufSize, values));
}


/* EGLImageTargetTexture2DOES: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_EGLImageTargetTexture2DOES(GLenum target, GLvoid * writeOffset)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("EGLImageTargetTexture2DOES");
   CALL_EGLImageTargetTexture2DOES(ctx->CurrentServerDispatch, (target, writeOffset));
}


/* DepthMask: marshalled asynchronously */
struct marshal_cmd_DepthMask
{
   struct marshal_cmd_base cmd_base;
   GLboolean flag;
};
static inline void
_mesa_unmarshal_DepthMask(struct gl_context *ctx, const struct marshal_cmd_DepthMask *cmd)
{
   const GLboolean flag = cmd->flag;
   CALL_DepthMask(ctx->CurrentServerDispatch, (flag));
}
static void GLAPIENTRY
_mesa_marshal_DepthMask(GLboolean flag)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DepthMask);
   struct marshal_cmd_DepthMask *cmd;
   debug_print_marshal("DepthMask");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DepthMask, cmd_size);
      cmd->flag = flag;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DepthMask");
   CALL_DepthMask(ctx->CurrentServerDispatch, (flag));
}


/* WindowPos4ivMESA: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_WindowPos4ivMESA(const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("WindowPos4ivMESA");
   CALL_WindowPos4ivMESA(ctx->CurrentServerDispatch, (v));
}


/* GetShaderInfoLog: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * infoLog)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetShaderInfoLog");
   CALL_GetShaderInfoLog(ctx->CurrentServerDispatch, (shader, bufSize, length, infoLog));
}


/* BindFragmentShaderATI: marshalled asynchronously */
struct marshal_cmd_BindFragmentShaderATI
{
   struct marshal_cmd_base cmd_base;
   GLuint id;
};
static inline void
_mesa_unmarshal_BindFragmentShaderATI(struct gl_context *ctx, const struct marshal_cmd_BindFragmentShaderATI *cmd)
{
   const GLuint id = cmd->id;
   CALL_BindFragmentShaderATI(ctx->CurrentServerDispatch, (id));
}
static void GLAPIENTRY
_mesa_marshal_BindFragmentShaderATI(GLuint id)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindFragmentShaderATI);
   struct marshal_cmd_BindFragmentShaderATI *cmd;
   debug_print_marshal("BindFragmentShaderATI");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindFragmentShaderATI, cmd_size);
      cmd->id = id;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindFragmentShaderATI");
   CALL_BindFragmentShaderATI(ctx->CurrentServerDispatch, (id));
}


/* BlendFuncSeparateiARB: marshalled asynchronously */
struct marshal_cmd_BlendFuncSeparateiARB
{
   struct marshal_cmd_base cmd_base;
   GLuint buf;
   GLenum srcRGB;
   GLenum dstRGB;
   GLenum srcA;
   GLenum dstA;
};
static inline void
_mesa_unmarshal_BlendFuncSeparateiARB(struct gl_context *ctx, const struct marshal_cmd_BlendFuncSeparateiARB *cmd)
{
   const GLuint buf = cmd->buf;
   const GLenum srcRGB = cmd->srcRGB;
   const GLenum dstRGB = cmd->dstRGB;
   const GLenum srcA = cmd->srcA;
   const GLenum dstA = cmd->dstA;
   CALL_BlendFuncSeparateiARB(ctx->CurrentServerDispatch, (buf, srcRGB, dstRGB, srcA, dstA));
}
static void GLAPIENTRY
_mesa_marshal_BlendFuncSeparateiARB(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcA, GLenum dstA)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BlendFuncSeparateiARB);
   struct marshal_cmd_BlendFuncSeparateiARB *cmd;
   debug_print_marshal("BlendFuncSeparateiARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BlendFuncSeparateiARB, cmd_size);
      cmd->buf = buf;
      cmd->srcRGB = srcRGB;
      cmd->dstRGB = dstRGB;
      cmd->srcA = srcA;
      cmd->dstA = dstA;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BlendFuncSeparateiARB");
   CALL_BlendFuncSeparateiARB(ctx->CurrentServerDispatch, (buf, srcRGB, dstRGB, srcA, dstA));
}


/* EGLImageTargetRenderbufferStorageOES: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_EGLImageTargetRenderbufferStorageOES(GLenum target, GLvoid * writeOffset)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("EGLImageTargetRenderbufferStorageOES");
   CALL_EGLImageTargetRenderbufferStorageOES(ctx->CurrentServerDispatch, (target, writeOffset));
}


/* GenTransformFeedbacks: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GenTransformFeedbacks(GLsizei n, GLuint * ids)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GenTransformFeedbacks");
   CALL_GenTransformFeedbacks(ctx->CurrentServerDispatch, (n, ids));
}


/* VertexPointer: marshalled asynchronously */
struct marshal_cmd_VertexPointer
{
   struct marshal_cmd_base cmd_base;
   GLint size;
   GLenum type;
   GLsizei stride;
   const GLvoid * pointer;
};
static inline void
_mesa_unmarshal_VertexPointer(struct gl_context *ctx, const struct marshal_cmd_VertexPointer *cmd)
{
   const GLint size = cmd->size;
   const GLenum type = cmd->type;
   const GLsizei stride = cmd->stride;
   const GLvoid * pointer = cmd->pointer;
   CALL_VertexPointer(ctx->CurrentServerDispatch, (size, type, stride, pointer));
}
static void GLAPIENTRY
_mesa_marshal_VertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexPointer);
   struct marshal_cmd_VertexPointer *cmd;
   debug_print_marshal("VertexPointer");
   if (_mesa_glthread_is_non_vbo_vertex_attrib_pointer(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("VertexPointer");
      CALL_VertexPointer(ctx->CurrentServerDispatch, (size, type, stride, pointer));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexPointer, cmd_size);
      cmd->size = size;
      cmd->type = type;
      cmd->stride = stride;
      cmd->pointer = pointer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexPointer");
   CALL_VertexPointer(ctx->CurrentServerDispatch, (size, type, stride, pointer));
}


/* GetCompressedTexImage: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetCompressedTexImage(GLenum target, GLint level, GLvoid * img)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetCompressedTexImage");
   CALL_GetCompressedTexImage(ctx->CurrentServerDispatch, (target, level, img));
}


/* ProgramLocalParameter4dvARB: marshalled asynchronously */
struct marshal_cmd_ProgramLocalParameter4dvARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
   GLdouble params[4];
};
static inline void
_mesa_unmarshal_ProgramLocalParameter4dvARB(struct gl_context *ctx, const struct marshal_cmd_ProgramLocalParameter4dvARB *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   const GLdouble * params = cmd->params;
   CALL_ProgramLocalParameter4dvARB(ctx->CurrentServerDispatch, (target, index, params));
}
static void GLAPIENTRY
_mesa_marshal_ProgramLocalParameter4dvARB(GLenum target, GLuint index, const GLdouble * params)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramLocalParameter4dvARB);
   struct marshal_cmd_ProgramLocalParameter4dvARB *cmd;
   debug_print_marshal("ProgramLocalParameter4dvARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramLocalParameter4dvARB, cmd_size);
      cmd->target = target;
      cmd->index = index;
      memcpy(cmd->params, params, 32);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramLocalParameter4dvARB");
   CALL_ProgramLocalParameter4dvARB(ctx->CurrentServerDispatch, (target, index, params));
}


/* UniformMatrix2dv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix2dv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 32) bytes are GLdouble value[count][4] */
};
static inline void
_mesa_unmarshal_UniformMatrix2dv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix2dv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 32;
   CALL_UniformMatrix2dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix2dv) + safe_mul(count, 32);
   struct marshal_cmd_UniformMatrix2dv *cmd;
   debug_print_marshal("UniformMatrix2dv");
   if (unlikely(safe_mul(count, 32) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix2dv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 32);
      variable_data += count * 32;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix2dv");
   CALL_UniformMatrix2dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* GetQueryObjectui64v: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetQueryObjectui64v(GLuint id, GLenum pname, GLuint64 * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetQueryObjectui64v");
   CALL_GetQueryObjectui64v(ctx->CurrentServerDispatch, (id, pname, params));
}


/* VertexAttribP1uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribP1uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribP1uiv");
   CALL_VertexAttribP1uiv(ctx->CurrentServerDispatch, (index, type, normalized, value));
}


/* IsProgram: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsProgram(GLuint program)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsProgram");
   return CALL_IsProgram(ctx->CurrentServerDispatch, (program));
}


/* BindBuffersBase: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_BindBuffersBase(GLenum target, GLuint first, GLsizei count, const GLuint * buffers)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("BindBuffersBase");
   CALL_BindBuffersBase(ctx->CurrentServerDispatch, (target, first, count, buffers));
}


/* GenTextures: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GenTextures(GLsizei n, GLuint * textures)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GenTextures");
   CALL_GenTextures(ctx->CurrentServerDispatch, (n, textures));
}


/* UnmapNamedBuffer: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_UnmapNamedBuffer(GLuint buffer)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("UnmapNamedBuffer");
   return CALL_UnmapNamedBuffer(ctx->CurrentServerDispatch, (buffer));
}


/* UniformMatrix3x2dv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix3x2dv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 48) bytes are GLdouble value[count][6] */
};
static inline void
_mesa_unmarshal_UniformMatrix3x2dv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix3x2dv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 48;
   CALL_UniformMatrix3x2dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix3x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix3x2dv) + safe_mul(count, 48);
   struct marshal_cmd_UniformMatrix3x2dv *cmd;
   debug_print_marshal("UniformMatrix3x2dv");
   if (unlikely(safe_mul(count, 48) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix3x2dv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 48);
      variable_data += count * 48;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix3x2dv");
   CALL_UniformMatrix3x2dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* WindowPos4fMESA: marshalled asynchronously */
struct marshal_cmd_WindowPos4fMESA
{
   struct marshal_cmd_base cmd_base;
   GLfloat x;
   GLfloat y;
   GLfloat z;
   GLfloat w;
};
static inline void
_mesa_unmarshal_WindowPos4fMESA(struct gl_context *ctx, const struct marshal_cmd_WindowPos4fMESA *cmd)
{
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   const GLfloat w = cmd->w;
   CALL_WindowPos4fMESA(ctx->CurrentServerDispatch, (x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_WindowPos4fMESA(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WindowPos4fMESA);
   struct marshal_cmd_WindowPos4fMESA *cmd;
   debug_print_marshal("WindowPos4fMESA");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WindowPos4fMESA, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WindowPos4fMESA");
   CALL_WindowPos4fMESA(ctx->CurrentServerDispatch, (x, y, z, w));
}


/* VertexAttribs2fvNV: marshalled asynchronously */
struct marshal_cmd_VertexAttribs2fvNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLsizei n;
   /* Next safe_mul(n, 8) bytes are GLfloat v[n][2] */
};
static inline void
_mesa_unmarshal_VertexAttribs2fvNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttribs2fvNV *cmd)
{
   const GLuint index = cmd->index;
   const GLsizei n = cmd->n;
   const GLfloat * v;
   const char *variable_data = (const char *) (cmd + 1);
   v = (const GLfloat *) variable_data;
   variable_data += n * 8;
   CALL_VertexAttribs2fvNV(ctx->CurrentServerDispatch, (index, n, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribs2fvNV(GLuint index, GLsizei n, const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribs2fvNV) + safe_mul(n, 8);
   struct marshal_cmd_VertexAttribs2fvNV *cmd;
   debug_print_marshal("VertexAttribs2fvNV");
   if (unlikely(safe_mul(n, 8) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribs2fvNV, cmd_size);
      cmd->index = index;
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, v, n * 8);
      variable_data += n * 8;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribs2fvNV");
   CALL_VertexAttribs2fvNV(ctx->CurrentServerDispatch, (index, n, v));
}


/* VertexAttribP4ui: marshalled asynchronously */
struct marshal_cmd_VertexAttribP4ui
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLenum type;
   GLboolean normalized;
   GLuint value;
};
static inline void
_mesa_unmarshal_VertexAttribP4ui(struct gl_context *ctx, const struct marshal_cmd_VertexAttribP4ui *cmd)
{
   const GLuint index = cmd->index;
   const GLenum type = cmd->type;
   const GLboolean normalized = cmd->normalized;
   const GLuint value = cmd->value;
   CALL_VertexAttribP4ui(ctx->CurrentServerDispatch, (index, type, normalized, value));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribP4ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribP4ui);
   struct marshal_cmd_VertexAttribP4ui *cmd;
   debug_print_marshal("VertexAttribP4ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribP4ui, cmd_size);
      cmd->index = index;
      cmd->type = type;
      cmd->normalized = normalized;
      cmd->value = value;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribP4ui");
   CALL_VertexAttribP4ui(ctx->CurrentServerDispatch, (index, type, normalized, value));
}


/* StringMarkerGREMEDY: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_StringMarkerGREMEDY(GLsizei len, const GLvoid * string)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("StringMarkerGREMEDY");
   CALL_StringMarkerGREMEDY(ctx->CurrentServerDispatch, (len, string));
}


/* Uniform4i: marshalled asynchronously */
struct marshal_cmd_Uniform4i
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLint v0;
   GLint v1;
   GLint v2;
   GLint v3;
};
static inline void
_mesa_unmarshal_Uniform4i(struct gl_context *ctx, const struct marshal_cmd_Uniform4i *cmd)
{
   const GLint location = cmd->location;
   const GLint v0 = cmd->v0;
   const GLint v1 = cmd->v1;
   const GLint v2 = cmd->v2;
   const GLint v3 = cmd->v3;
   CALL_Uniform4i(ctx->CurrentServerDispatch, (location, v0, v1, v2, v3));
}
static void GLAPIENTRY
_mesa_marshal_Uniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform4i);
   struct marshal_cmd_Uniform4i *cmd;
   debug_print_marshal("Uniform4i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform4i, cmd_size);
      cmd->location = location;
      cmd->v0 = v0;
      cmd->v1 = v1;
      cmd->v2 = v2;
      cmd->v3 = v3;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform4i");
   CALL_Uniform4i(ctx->CurrentServerDispatch, (location, v0, v1, v2, v3));
}


/* Uniform4d: marshalled asynchronously */
struct marshal_cmd_Uniform4d
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLdouble x;
   GLdouble y;
   GLdouble z;
   GLdouble w;
};
static inline void
_mesa_unmarshal_Uniform4d(struct gl_context *ctx, const struct marshal_cmd_Uniform4d *cmd)
{
   const GLint location = cmd->location;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   const GLdouble w = cmd->w;
   CALL_Uniform4d(ctx->CurrentServerDispatch, (location, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_Uniform4d(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform4d);
   struct marshal_cmd_Uniform4d *cmd;
   debug_print_marshal("Uniform4d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform4d, cmd_size);
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform4d");
   CALL_Uniform4d(ctx->CurrentServerDispatch, (location, x, y, z, w));
}


/* Uniform4f: marshalled asynchronously */
struct marshal_cmd_Uniform4f
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLfloat v0;
   GLfloat v1;
   GLfloat v2;
   GLfloat v3;
};
static inline void
_mesa_unmarshal_Uniform4f(struct gl_context *ctx, const struct marshal_cmd_Uniform4f *cmd)
{
   const GLint location = cmd->location;
   const GLfloat v0 = cmd->v0;
   const GLfloat v1 = cmd->v1;
   const GLfloat v2 = cmd->v2;
   const GLfloat v3 = cmd->v3;
   CALL_Uniform4f(ctx->CurrentServerDispatch, (location, v0, v1, v2, v3));
}
static void GLAPIENTRY
_mesa_marshal_Uniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform4f);
   struct marshal_cmd_Uniform4f *cmd;
   debug_print_marshal("Uniform4f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform4f, cmd_size);
      cmd->location = location;
      cmd->v0 = v0;
      cmd->v1 = v1;
      cmd->v2 = v2;
      cmd->v3 = v3;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform4f");
   CALL_Uniform4f(ctx->CurrentServerDispatch, (location, v0, v1, v2, v3));
}


/* ProgramUniform3dv: marshalled asynchronously */
struct marshal_cmd_ProgramUniform3dv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 24) bytes are GLdouble value[count][3] */
};
static inline void
_mesa_unmarshal_ProgramUniform3dv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform3dv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 24;
   CALL_ProgramUniform3dv(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform3dv(GLuint program, GLint location, GLsizei count, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform3dv) + safe_mul(count, 24);
   struct marshal_cmd_ProgramUniform3dv *cmd;
   debug_print_marshal("ProgramUniform3dv");
   if (unlikely(safe_mul(count, 24) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform3dv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 24);
      variable_data += count * 24;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform3dv");
   CALL_ProgramUniform3dv(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* GetNamedBufferParameteri64v: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetNamedBufferParameteri64v(GLuint buffer, GLenum pname, GLint64 * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetNamedBufferParameteri64v");
   CALL_GetNamedBufferParameteri64v(ctx->CurrentServerDispatch, (buffer, pname, params));
}


/* NamedFramebufferTexture: marshalled asynchronously */
struct marshal_cmd_NamedFramebufferTexture
{
   struct marshal_cmd_base cmd_base;
   GLuint framebuffer;
   GLenum attachment;
   GLuint texture;
   GLint level;
};
static inline void
_mesa_unmarshal_NamedFramebufferTexture(struct gl_context *ctx, const struct marshal_cmd_NamedFramebufferTexture *cmd)
{
   const GLuint framebuffer = cmd->framebuffer;
   const GLenum attachment = cmd->attachment;
   const GLuint texture = cmd->texture;
   const GLint level = cmd->level;
   CALL_NamedFramebufferTexture(ctx->CurrentServerDispatch, (framebuffer, attachment, texture, level));
}
static void GLAPIENTRY
_mesa_marshal_NamedFramebufferTexture(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_NamedFramebufferTexture);
   struct marshal_cmd_NamedFramebufferTexture *cmd;
   debug_print_marshal("NamedFramebufferTexture");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_NamedFramebufferTexture, cmd_size);
      cmd->framebuffer = framebuffer;
      cmd->attachment = attachment;
      cmd->texture = texture;
      cmd->level = level;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("NamedFramebufferTexture");
   CALL_NamedFramebufferTexture(ctx->CurrentServerDispatch, (framebuffer, attachment, texture, level));
}


/* ProgramUniform3d: marshalled asynchronously */
struct marshal_cmd_ProgramUniform3d
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLdouble x;
   GLdouble y;
   GLdouble z;
};
static inline void
_mesa_unmarshal_ProgramUniform3d(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform3d *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   CALL_ProgramUniform3d(ctx->CurrentServerDispatch, (program, location, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform3d(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform3d);
   struct marshal_cmd_ProgramUniform3d *cmd;
   debug_print_marshal("ProgramUniform3d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform3d, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform3d");
   CALL_ProgramUniform3d(ctx->CurrentServerDispatch, (program, location, x, y, z));
}


/* ProgramUniform3f: marshalled asynchronously */
struct marshal_cmd_ProgramUniform3f
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLfloat x;
   GLfloat y;
   GLfloat z;
};
static inline void
_mesa_unmarshal_ProgramUniform3f(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform3f *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   CALL_ProgramUniform3f(ctx->CurrentServerDispatch, (program, location, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform3f(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform3f);
   struct marshal_cmd_ProgramUniform3f *cmd;
   debug_print_marshal("ProgramUniform3f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform3f, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform3f");
   CALL_ProgramUniform3f(ctx->CurrentServerDispatch, (program, location, x, y, z));
}


/* ProgramUniform3i: marshalled asynchronously */
struct marshal_cmd_ProgramUniform3i
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLint x;
   GLint y;
   GLint z;
};
static inline void
_mesa_unmarshal_ProgramUniform3i(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform3i *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLint z = cmd->z;
   CALL_ProgramUniform3i(ctx->CurrentServerDispatch, (program, location, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform3i(GLuint program, GLint location, GLint x, GLint y, GLint z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform3i);
   struct marshal_cmd_ProgramUniform3i *cmd;
   debug_print_marshal("ProgramUniform3i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform3i, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform3i");
   CALL_ProgramUniform3i(ctx->CurrentServerDispatch, (program, location, x, y, z));
}


/* PointParameterfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_PointParameterfv(GLenum pname, const GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("PointParameterfv");
   CALL_PointParameterfv(ctx->CurrentServerDispatch, (pname, params));
}


/* GetHistogramParameterfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetHistogramParameterfv(GLenum target, GLenum pname, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetHistogramParameterfv");
   CALL_GetHistogramParameterfv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* GetString: marshalled synchronously */
static const GLubyte * GLAPIENTRY
_mesa_marshal_GetString(GLenum name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetString");
   return CALL_GetString(ctx->CurrentServerDispatch, (name));
}


/* VDPAUUnmapSurfacesNV: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VDPAUUnmapSurfacesNV(GLsizei numSurfaces, const GLintptr * surfaces)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VDPAUUnmapSurfacesNV");
   CALL_VDPAUUnmapSurfacesNV(ctx->CurrentServerDispatch, (numSurfaces, surfaces));
}


/* GetnHistogramARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnHistogramARB(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, GLvoid * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnHistogramARB");
   CALL_GetnHistogramARB(ctx->CurrentServerDispatch, (target, reset, format, type, bufSize, values));
}


/* SecondaryColor3s: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3s
{
   struct marshal_cmd_base cmd_base;
   GLshort red;
   GLshort green;
   GLshort blue;
};
static inline void
_mesa_unmarshal_SecondaryColor3s(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3s *cmd)
{
   const GLshort red = cmd->red;
   const GLshort green = cmd->green;
   const GLshort blue = cmd->blue;
   CALL_SecondaryColor3s(ctx->CurrentServerDispatch, (red, green, blue));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3s(GLshort red, GLshort green, GLshort blue)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3s);
   struct marshal_cmd_SecondaryColor3s *cmd;
   debug_print_marshal("SecondaryColor3s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3s, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3s");
   CALL_SecondaryColor3s(ctx->CurrentServerDispatch, (red, green, blue));
}


/* TexStorageMem2DEXT: marshalled asynchronously */
struct marshal_cmd_TexStorageMem2DEXT
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizei levels;
   GLenum internalFormat;
   GLsizei width;
   GLsizei height;
   GLuint memory;
   GLuint64 offset;
};
static inline void
_mesa_unmarshal_TexStorageMem2DEXT(struct gl_context *ctx, const struct marshal_cmd_TexStorageMem2DEXT *cmd)
{
   const GLenum target = cmd->target;
   const GLsizei levels = cmd->levels;
   const GLenum internalFormat = cmd->internalFormat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLuint memory = cmd->memory;
   const GLuint64 offset = cmd->offset;
   CALL_TexStorageMem2DEXT(ctx->CurrentServerDispatch, (target, levels, internalFormat, width, height, memory, offset));
}
static void GLAPIENTRY
_mesa_marshal_TexStorageMem2DEXT(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexStorageMem2DEXT);
   struct marshal_cmd_TexStorageMem2DEXT *cmd;
   debug_print_marshal("TexStorageMem2DEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexStorageMem2DEXT, cmd_size);
      cmd->target = target;
      cmd->levels = levels;
      cmd->internalFormat = internalFormat;
      cmd->width = width;
      cmd->height = height;
      cmd->memory = memory;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexStorageMem2DEXT");
   CALL_TexStorageMem2DEXT(ctx->CurrentServerDispatch, (target, levels, internalFormat, width, height, memory, offset));
}


/* VertexAttribP2uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribP2uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribP2uiv");
   CALL_VertexAttribP2uiv(ctx->CurrentServerDispatch, (index, type, normalized, value));
}


/* UniformMatrix3x4dv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix3x4dv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 96) bytes are GLdouble value[count][12] */
};
static inline void
_mesa_unmarshal_UniformMatrix3x4dv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix3x4dv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 96;
   CALL_UniformMatrix3x4dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix3x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix3x4dv) + safe_mul(count, 96);
   struct marshal_cmd_UniformMatrix3x4dv *cmd;
   debug_print_marshal("UniformMatrix3x4dv");
   if (unlikely(safe_mul(count, 96) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix3x4dv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 96);
      variable_data += count * 96;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix3x4dv");
   CALL_UniformMatrix3x4dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* VertexAttrib3fNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib3fNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat x;
   GLfloat y;
   GLfloat z;
};
static inline void
_mesa_unmarshal_VertexAttrib3fNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib3fNV *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   CALL_VertexAttrib3fNV(ctx->CurrentServerDispatch, (index, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib3fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib3fNV);
   struct marshal_cmd_VertexAttrib3fNV *cmd;
   debug_print_marshal("VertexAttrib3fNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib3fNV, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib3fNV");
   CALL_VertexAttrib3fNV(ctx->CurrentServerDispatch, (index, x, y, z));
}


/* SecondaryColor3b: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3b
{
   struct marshal_cmd_base cmd_base;
   GLbyte red;
   GLbyte green;
   GLbyte blue;
};
static inline void
_mesa_unmarshal_SecondaryColor3b(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3b *cmd)
{
   const GLbyte red = cmd->red;
   const GLbyte green = cmd->green;
   const GLbyte blue = cmd->blue;
   CALL_SecondaryColor3b(ctx->CurrentServerDispatch, (red, green, blue));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3b(GLbyte red, GLbyte green, GLbyte blue)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3b);
   struct marshal_cmd_SecondaryColor3b *cmd;
   debug_print_marshal("SecondaryColor3b");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3b, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3b");
   CALL_SecondaryColor3b(ctx->CurrentServerDispatch, (red, green, blue));
}


/* EnableClientState: marshalled asynchronously */
struct marshal_cmd_EnableClientState
{
   struct marshal_cmd_base cmd_base;
   GLenum array;
};
static inline void
_mesa_unmarshal_EnableClientState(struct gl_context *ctx, const struct marshal_cmd_EnableClientState *cmd)
{
   const GLenum array = cmd->array;
   CALL_EnableClientState(ctx->CurrentServerDispatch, (array));
}
static void GLAPIENTRY
_mesa_marshal_EnableClientState(GLenum array)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EnableClientState);
   struct marshal_cmd_EnableClientState *cmd;
   debug_print_marshal("EnableClientState");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EnableClientState, cmd_size);
      cmd->array = array;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EnableClientState");
   CALL_EnableClientState(ctx->CurrentServerDispatch, (array));
}


/* GetActiveSubroutineName: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetActiveSubroutineName(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei * length, GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetActiveSubroutineName");
   CALL_GetActiveSubroutineName(ctx->CurrentServerDispatch, (program, shadertype, index, bufsize, length, name));
}


/* SecondaryColor3i: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3i
{
   struct marshal_cmd_base cmd_base;
   GLint red;
   GLint green;
   GLint blue;
};
static inline void
_mesa_unmarshal_SecondaryColor3i(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3i *cmd)
{
   const GLint red = cmd->red;
   const GLint green = cmd->green;
   const GLint blue = cmd->blue;
   CALL_SecondaryColor3i(ctx->CurrentServerDispatch, (red, green, blue));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3i(GLint red, GLint green, GLint blue)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3i);
   struct marshal_cmd_SecondaryColor3i *cmd;
   debug_print_marshal("SecondaryColor3i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3i, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3i");
   CALL_SecondaryColor3i(ctx->CurrentServerDispatch, (red, green, blue));
}


/* FlushMappedBufferRange: marshalled asynchronously */
struct marshal_cmd_FlushMappedBufferRange
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLintptr offset;
   GLsizeiptr length;
};
static inline void
_mesa_unmarshal_FlushMappedBufferRange(struct gl_context *ctx, const struct marshal_cmd_FlushMappedBufferRange *cmd)
{
   const GLenum target = cmd->target;
   const GLintptr offset = cmd->offset;
   const GLsizeiptr length = cmd->length;
   CALL_FlushMappedBufferRange(ctx->CurrentServerDispatch, (target, offset, length));
}
static void GLAPIENTRY
_mesa_marshal_FlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_FlushMappedBufferRange);
   struct marshal_cmd_FlushMappedBufferRange *cmd;
   debug_print_marshal("FlushMappedBufferRange");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_FlushMappedBufferRange, cmd_size);
      cmd->target = target;
      cmd->offset = offset;
      cmd->length = length;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("FlushMappedBufferRange");
   CALL_FlushMappedBufferRange(ctx->CurrentServerDispatch, (target, offset, length));
}


/* TexStorageMem3DEXT: marshalled asynchronously */
struct marshal_cmd_TexStorageMem3DEXT
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizei levels;
   GLenum internalFormat;
   GLsizei width;
   GLsizei height;
   GLsizei depth;
   GLuint memory;
   GLuint64 offset;
};
static inline void
_mesa_unmarshal_TexStorageMem3DEXT(struct gl_context *ctx, const struct marshal_cmd_TexStorageMem3DEXT *cmd)
{
   const GLenum target = cmd->target;
   const GLsizei levels = cmd->levels;
   const GLenum internalFormat = cmd->internalFormat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLsizei depth = cmd->depth;
   const GLuint memory = cmd->memory;
   const GLuint64 offset = cmd->offset;
   CALL_TexStorageMem3DEXT(ctx->CurrentServerDispatch, (target, levels, internalFormat, width, height, depth, memory, offset));
}
static void GLAPIENTRY
_mesa_marshal_TexStorageMem3DEXT(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexStorageMem3DEXT);
   struct marshal_cmd_TexStorageMem3DEXT *cmd;
   debug_print_marshal("TexStorageMem3DEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexStorageMem3DEXT, cmd_size);
      cmd->target = target;
      cmd->levels = levels;
      cmd->internalFormat = internalFormat;
      cmd->width = width;
      cmd->height = height;
      cmd->depth = depth;
      cmd->memory = memory;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexStorageMem3DEXT");
   CALL_TexStorageMem3DEXT(ctx->CurrentServerDispatch, (target, levels, internalFormat, width, height, depth, memory, offset));
}


/* Lightfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_Lightfv(GLenum light, GLenum pname, const GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("Lightfv");
   CALL_Lightfv(ctx->CurrentServerDispatch, (light, pname, params));
}


/* GetFramebufferAttachmentParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetFramebufferAttachmentParameteriv");
   CALL_GetFramebufferAttachmentParameteriv(ctx->CurrentServerDispatch, (target, attachment, pname, params));
}


/* ColorSubTable: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ColorSubTable(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ColorSubTable");
   CALL_ColorSubTable(ctx->CurrentServerDispatch, (target, start, count, format, type, data));
}


/* GetVertexArrayIndexed64iv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetVertexArrayIndexed64iv(GLuint vaobj, GLuint index, GLenum pname, GLint64 * param)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetVertexArrayIndexed64iv");
   CALL_GetVertexArrayIndexed64iv(ctx->CurrentServerDispatch, (vaobj, index, pname, param));
}


/* EndPerfMonitorAMD: marshalled asynchronously */
struct marshal_cmd_EndPerfMonitorAMD
{
   struct marshal_cmd_base cmd_base;
   GLuint monitor;
};
static inline void
_mesa_unmarshal_EndPerfMonitorAMD(struct gl_context *ctx, const struct marshal_cmd_EndPerfMonitorAMD *cmd)
{
   const GLuint monitor = cmd->monitor;
   CALL_EndPerfMonitorAMD(ctx->CurrentServerDispatch, (monitor));
}
static void GLAPIENTRY
_mesa_marshal_EndPerfMonitorAMD(GLuint monitor)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EndPerfMonitorAMD);
   struct marshal_cmd_EndPerfMonitorAMD *cmd;
   debug_print_marshal("EndPerfMonitorAMD");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EndPerfMonitorAMD, cmd_size);
      cmd->monitor = monitor;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EndPerfMonitorAMD");
   CALL_EndPerfMonitorAMD(ctx->CurrentServerDispatch, (monitor));
}


/* CreateBuffers: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CreateBuffers(GLsizei n, GLuint * buffers)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CreateBuffers");
   CALL_CreateBuffers(ctx->CurrentServerDispatch, (n, buffers));
}


/* VertexAttribs4dvNV: marshalled asynchronously */
struct marshal_cmd_VertexAttribs4dvNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLsizei n;
   /* Next safe_mul(n, 32) bytes are GLdouble v[n][4] */
};
static inline void
_mesa_unmarshal_VertexAttribs4dvNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttribs4dvNV *cmd)
{
   const GLuint index = cmd->index;
   const GLsizei n = cmd->n;
   const GLdouble * v;
   const char *variable_data = (const char *) (cmd + 1);
   v = (const GLdouble *) variable_data;
   variable_data += n * 32;
   CALL_VertexAttribs4dvNV(ctx->CurrentServerDispatch, (index, n, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribs4dvNV(GLuint index, GLsizei n, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribs4dvNV) + safe_mul(n, 32);
   struct marshal_cmd_VertexAttribs4dvNV *cmd;
   debug_print_marshal("VertexAttribs4dvNV");
   if (unlikely(safe_mul(n, 32) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribs4dvNV, cmd_size);
      cmd->index = index;
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, v, n * 32);
      variable_data += n * 32;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribs4dvNV");
   CALL_VertexAttribs4dvNV(ctx->CurrentServerDispatch, (index, n, v));
}


/* Uniform2i64vARB: marshalled asynchronously */
struct marshal_cmd_Uniform2i64vARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 16) bytes are GLint64 value[count][2] */
};
static inline void
_mesa_unmarshal_Uniform2i64vARB(struct gl_context *ctx, const struct marshal_cmd_Uniform2i64vARB *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLint64 * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLint64 *) variable_data;
   variable_data += count * 16;
   CALL_Uniform2i64vARB(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform2i64vARB(GLint location, GLsizei count, const GLint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform2i64vARB) + safe_mul(count, 16);
   struct marshal_cmd_Uniform2i64vARB *cmd;
   debug_print_marshal("Uniform2i64vARB");
   if (unlikely(safe_mul(count, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform2i64vARB, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 16);
      variable_data += count * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform2i64vARB");
   CALL_Uniform2i64vARB(ctx->CurrentServerDispatch, (location, count, value));
}


/* GetMultisamplefv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetMultisamplefv(GLenum pname, GLuint index, GLfloat * val)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetMultisamplefv");
   CALL_GetMultisamplefv(ctx->CurrentServerDispatch, (pname, index, val));
}


/* GetActiveSubroutineUniformName: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetActiveSubroutineUniformName(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei * length, GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetActiveSubroutineUniformName");
   CALL_GetActiveSubroutineUniformName(ctx->CurrentServerDispatch, (program, shadertype, index, bufsize, length, name));
}


/* Rectdv: marshalled asynchronously */
struct marshal_cmd_Rectdv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v1[2];
   GLdouble v2[2];
};
static inline void
_mesa_unmarshal_Rectdv(struct gl_context *ctx, const struct marshal_cmd_Rectdv *cmd)
{
   const GLdouble * v1 = cmd->v1;
   const GLdouble * v2 = cmd->v2;
   CALL_Rectdv(ctx->CurrentServerDispatch, (v1, v2));
}
static void GLAPIENTRY
_mesa_marshal_Rectdv(const GLdouble * v1, const GLdouble * v2)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Rectdv);
   struct marshal_cmd_Rectdv *cmd;
   debug_print_marshal("Rectdv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Rectdv, cmd_size);
      memcpy(cmd->v1, v1, 16);
      memcpy(cmd->v2, v2, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Rectdv");
   CALL_Rectdv(ctx->CurrentServerDispatch, (v1, v2));
}


/* DrawArraysInstancedARB: marshalled asynchronously */
struct marshal_cmd_DrawArraysInstancedARB
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
   GLint first;
   GLsizei count;
   GLsizei primcount;
};
static inline void
_mesa_unmarshal_DrawArraysInstancedARB(struct gl_context *ctx, const struct marshal_cmd_DrawArraysInstancedARB *cmd)
{
   const GLenum mode = cmd->mode;
   const GLint first = cmd->first;
   const GLsizei count = cmd->count;
   const GLsizei primcount = cmd->primcount;
   CALL_DrawArraysInstancedARB(ctx->CurrentServerDispatch, (mode, first, count, primcount));
}
static void GLAPIENTRY
_mesa_marshal_DrawArraysInstancedARB(GLenum mode, GLint first, GLsizei count, GLsizei primcount)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawArraysInstancedARB);
   struct marshal_cmd_DrawArraysInstancedARB *cmd;
   debug_print_marshal("DrawArraysInstancedARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawArraysInstancedARB, cmd_size);
      cmd->mode = mode;
      cmd->first = first;
      cmd->count = count;
      cmd->primcount = primcount;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawArraysInstancedARB");
   CALL_DrawArraysInstancedARB(ctx->CurrentServerDispatch, (mode, first, count, primcount));
}


/* MakeImageHandleNonResidentARB: marshalled asynchronously */
struct marshal_cmd_MakeImageHandleNonResidentARB
{
   struct marshal_cmd_base cmd_base;
   GLuint64 handle;
};
static inline void
_mesa_unmarshal_MakeImageHandleNonResidentARB(struct gl_context *ctx, const struct marshal_cmd_MakeImageHandleNonResidentARB *cmd)
{
   const GLuint64 handle = cmd->handle;
   CALL_MakeImageHandleNonResidentARB(ctx->CurrentServerDispatch, (handle));
}
static void GLAPIENTRY
_mesa_marshal_MakeImageHandleNonResidentARB(GLuint64 handle)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MakeImageHandleNonResidentARB);
   struct marshal_cmd_MakeImageHandleNonResidentARB *cmd;
   debug_print_marshal("MakeImageHandleNonResidentARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MakeImageHandleNonResidentARB, cmd_size);
      cmd->handle = handle;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MakeImageHandleNonResidentARB");
   CALL_MakeImageHandleNonResidentARB(ctx->CurrentServerDispatch, (handle));
}


/* ImportMemoryFdEXT: marshalled asynchronously */
struct marshal_cmd_ImportMemoryFdEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint memory;
   GLuint64 size;
   GLenum handleType;
   GLint fd;
};
static inline void
_mesa_unmarshal_ImportMemoryFdEXT(struct gl_context *ctx, const struct marshal_cmd_ImportMemoryFdEXT *cmd)
{
   const GLuint memory = cmd->memory;
   const GLuint64 size = cmd->size;
   const GLenum handleType = cmd->handleType;
   const GLint fd = cmd->fd;
   CALL_ImportMemoryFdEXT(ctx->CurrentServerDispatch, (memory, size, handleType, fd));
}
static void GLAPIENTRY
_mesa_marshal_ImportMemoryFdEXT(GLuint memory, GLuint64 size, GLenum handleType, GLint fd)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ImportMemoryFdEXT);
   struct marshal_cmd_ImportMemoryFdEXT *cmd;
   debug_print_marshal("ImportMemoryFdEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ImportMemoryFdEXT, cmd_size);
      cmd->memory = memory;
      cmd->size = size;
      cmd->handleType = handleType;
      cmd->fd = fd;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ImportMemoryFdEXT");
   CALL_ImportMemoryFdEXT(ctx->CurrentServerDispatch, (memory, size, handleType, fd));
}


/* ProgramEnvParameters4fvEXT: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ProgramEnvParameters4fvEXT(GLenum target, GLuint index, GLsizei count, const GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ProgramEnvParameters4fvEXT");
   CALL_ProgramEnvParameters4fvEXT(ctx->CurrentServerDispatch, (target, index, count, params));
}


/* TexStorageMem1DEXT: marshalled asynchronously */
struct marshal_cmd_TexStorageMem1DEXT
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizei levels;
   GLenum internalFormat;
   GLsizei width;
   GLuint memory;
   GLuint64 offset;
};
static inline void
_mesa_unmarshal_TexStorageMem1DEXT(struct gl_context *ctx, const struct marshal_cmd_TexStorageMem1DEXT *cmd)
{
   const GLenum target = cmd->target;
   const GLsizei levels = cmd->levels;
   const GLenum internalFormat = cmd->internalFormat;
   const GLsizei width = cmd->width;
   const GLuint memory = cmd->memory;
   const GLuint64 offset = cmd->offset;
   CALL_TexStorageMem1DEXT(ctx->CurrentServerDispatch, (target, levels, internalFormat, width, memory, offset));
}
static void GLAPIENTRY
_mesa_marshal_TexStorageMem1DEXT(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLuint memory, GLuint64 offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexStorageMem1DEXT);
   struct marshal_cmd_TexStorageMem1DEXT *cmd;
   debug_print_marshal("TexStorageMem1DEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexStorageMem1DEXT, cmd_size);
      cmd->target = target;
      cmd->levels = levels;
      cmd->internalFormat = internalFormat;
      cmd->width = width;
      cmd->memory = memory;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexStorageMem1DEXT");
   CALL_TexStorageMem1DEXT(ctx->CurrentServerDispatch, (target, levels, internalFormat, width, memory, offset));
}


/* BlendBarrier: marshalled asynchronously */
struct marshal_cmd_BlendBarrier
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_BlendBarrier(struct gl_context *ctx, const struct marshal_cmd_BlendBarrier *cmd)
{
   CALL_BlendBarrier(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_BlendBarrier(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BlendBarrier);
   struct marshal_cmd_BlendBarrier *cmd;
   debug_print_marshal("BlendBarrier");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BlendBarrier, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BlendBarrier");
   CALL_BlendBarrier(ctx->CurrentServerDispatch, ());
}


/* VertexAttrib2svNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib2svNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort v[2];
};
static inline void
_mesa_unmarshal_VertexAttrib2svNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib2svNV *cmd)
{
   const GLuint index = cmd->index;
   const GLshort * v = cmd->v;
   CALL_VertexAttrib2svNV(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib2svNV(GLuint index, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib2svNV);
   struct marshal_cmd_VertexAttrib2svNV *cmd;
   debug_print_marshal("VertexAttrib2svNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib2svNV, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib2svNV");
   CALL_VertexAttrib2svNV(ctx->CurrentServerDispatch, (index, v));
}


/* SecondaryColorP3uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_SecondaryColorP3uiv(GLenum type, const GLuint * color)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("SecondaryColorP3uiv");
   CALL_SecondaryColorP3uiv(ctx->CurrentServerDispatch, (type, color));
}


/* GetnPixelMapuivARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnPixelMapuivARB(GLenum map, GLsizei bufSize, GLuint * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnPixelMapuivARB");
   CALL_GetnPixelMapuivARB(ctx->CurrentServerDispatch, (map, bufSize, values));
}


/* GetSamplerParameterIuiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetSamplerParameterIuiv(GLuint sampler, GLenum pname, GLuint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetSamplerParameterIuiv");
   CALL_GetSamplerParameterIuiv(ctx->CurrentServerDispatch, (sampler, pname, params));
}


/* Disablei: marshalled asynchronously */
struct marshal_cmd_Disablei
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
};
static inline void
_mesa_unmarshal_Disablei(struct gl_context *ctx, const struct marshal_cmd_Disablei *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   CALL_Disablei(ctx->CurrentServerDispatch, (target, index));
}
static void GLAPIENTRY
_mesa_marshal_Disablei(GLenum target, GLuint index)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Disablei);
   struct marshal_cmd_Disablei *cmd;
   debug_print_marshal("Disablei");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Disablei, cmd_size);
      cmd->target = target;
      cmd->index = index;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Disablei");
   CALL_Disablei(ctx->CurrentServerDispatch, (target, index));
}


/* CompressedTexSubImage3D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CompressedTexSubImage3D");
   CALL_CompressedTexSubImage3D(ctx->CurrentServerDispatch, (target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data));
}


/* WindowPos4svMESA: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_WindowPos4svMESA(const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("WindowPos4svMESA");
   CALL_WindowPos4svMESA(ctx->CurrentServerDispatch, (v));
}


/* ObjectLabel: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ObjectLabel(GLenum identifier, GLuint name, GLsizei length, const GLchar * label)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ObjectLabel");
   CALL_ObjectLabel(ctx->CurrentServerDispatch, (identifier, name, length, label));
}


/* Color3dv: marshalled asynchronously */
struct marshal_cmd_Color3dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v[3];
};
static inline void
_mesa_unmarshal_Color3dv(struct gl_context *ctx, const struct marshal_cmd_Color3dv *cmd)
{
   const GLdouble * v = cmd->v;
   CALL_Color3dv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Color3dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color3dv);
   struct marshal_cmd_Color3dv *cmd;
   debug_print_marshal("Color3dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color3dv, cmd_size);
      memcpy(cmd->v, v, 24);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color3dv");
   CALL_Color3dv(ctx->CurrentServerDispatch, (v));
}


/* ProgramUniform1ui64ARB: marshalled asynchronously */
struct marshal_cmd_ProgramUniform1ui64ARB
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLuint64 x;
};
static inline void
_mesa_unmarshal_ProgramUniform1ui64ARB(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform1ui64ARB *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLuint64 x = cmd->x;
   CALL_ProgramUniform1ui64ARB(ctx->CurrentServerDispatch, (program, location, x));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform1ui64ARB(GLuint program, GLint location, GLuint64 x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform1ui64ARB);
   struct marshal_cmd_ProgramUniform1ui64ARB *cmd;
   debug_print_marshal("ProgramUniform1ui64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform1ui64ARB, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform1ui64ARB");
   CALL_ProgramUniform1ui64ARB(ctx->CurrentServerDispatch, (program, location, x));
}


/* BeginQuery: marshalled asynchronously */
struct marshal_cmd_BeginQuery
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint id;
};
static inline void
_mesa_unmarshal_BeginQuery(struct gl_context *ctx, const struct marshal_cmd_BeginQuery *cmd)
{
   const GLenum target = cmd->target;
   const GLuint id = cmd->id;
   CALL_BeginQuery(ctx->CurrentServerDispatch, (target, id));
}
static void GLAPIENTRY
_mesa_marshal_BeginQuery(GLenum target, GLuint id)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BeginQuery);
   struct marshal_cmd_BeginQuery *cmd;
   debug_print_marshal("BeginQuery");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BeginQuery, cmd_size);
      cmd->target = target;
      cmd->id = id;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BeginQuery");
   CALL_BeginQuery(ctx->CurrentServerDispatch, (target, id));
}


/* VertexP3uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexP3uiv(GLenum type, const GLuint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexP3uiv");
   CALL_VertexP3uiv(ctx->CurrentServerDispatch, (type, value));
}


/* GetUniformLocation: marshalled synchronously */
static GLint GLAPIENTRY
_mesa_marshal_GetUniformLocation(GLuint program, const GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetUniformLocation");
   return CALL_GetUniformLocation(ctx->CurrentServerDispatch, (program, name));
}


/* PixelStoref: marshalled asynchronously */
struct marshal_cmd_PixelStoref
{
   struct marshal_cmd_base cmd_base;
   GLenum pname;
   GLfloat param;
};
static inline void
_mesa_unmarshal_PixelStoref(struct gl_context *ctx, const struct marshal_cmd_PixelStoref *cmd)
{
   const GLenum pname = cmd->pname;
   const GLfloat param = cmd->param;
   CALL_PixelStoref(ctx->CurrentServerDispatch, (pname, param));
}
static void GLAPIENTRY
_mesa_marshal_PixelStoref(GLenum pname, GLfloat param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PixelStoref);
   struct marshal_cmd_PixelStoref *cmd;
   debug_print_marshal("PixelStoref");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PixelStoref, cmd_size);
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PixelStoref");
   CALL_PixelStoref(ctx->CurrentServerDispatch, (pname, param));
}


/* WindowPos2iv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_WindowPos2iv(const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("WindowPos2iv");
   CALL_WindowPos2iv(ctx->CurrentServerDispatch, (v));
}


/* PixelStorei: marshalled asynchronously */
struct marshal_cmd_PixelStorei
{
   struct marshal_cmd_base cmd_base;
   GLenum pname;
   GLint param;
};
static inline void
_mesa_unmarshal_PixelStorei(struct gl_context *ctx, const struct marshal_cmd_PixelStorei *cmd)
{
   const GLenum pname = cmd->pname;
   const GLint param = cmd->param;
   CALL_PixelStorei(ctx->CurrentServerDispatch, (pname, param));
}
static void GLAPIENTRY
_mesa_marshal_PixelStorei(GLenum pname, GLint param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PixelStorei);
   struct marshal_cmd_PixelStorei *cmd;
   debug_print_marshal("PixelStorei");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PixelStorei, cmd_size);
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PixelStorei");
   CALL_PixelStorei(ctx->CurrentServerDispatch, (pname, param));
}


/* VertexAttribs1svNV: marshalled asynchronously */
struct marshal_cmd_VertexAttribs1svNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLsizei n;
   /* Next safe_mul(n, 2) bytes are GLshort v[n] */
};
static inline void
_mesa_unmarshal_VertexAttribs1svNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttribs1svNV *cmd)
{
   const GLuint index = cmd->index;
   const GLsizei n = cmd->n;
   const GLshort * v;
   const char *variable_data = (const char *) (cmd + 1);
   v = (const GLshort *) variable_data;
   variable_data += n * 2;
   CALL_VertexAttribs1svNV(ctx->CurrentServerDispatch, (index, n, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribs1svNV(GLuint index, GLsizei n, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribs1svNV) + safe_mul(n, 2);
   struct marshal_cmd_VertexAttribs1svNV *cmd;
   debug_print_marshal("VertexAttribs1svNV");
   if (unlikely(safe_mul(n, 2) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribs1svNV, cmd_size);
      cmd->index = index;
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, v, n * 2);
      variable_data += n * 2;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribs1svNV");
   CALL_VertexAttribs1svNV(ctx->CurrentServerDispatch, (index, n, v));
}


/* CheckNamedFramebufferStatus: marshalled synchronously */
static GLenum GLAPIENTRY
_mesa_marshal_CheckNamedFramebufferStatus(GLuint framebuffer, GLenum target)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CheckNamedFramebufferStatus");
   return CALL_CheckNamedFramebufferStatus(ctx->CurrentServerDispatch, (framebuffer, target));
}


/* UniformSubroutinesuiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_UniformSubroutinesuiv(GLenum shadertype, GLsizei count, const GLuint * indices)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("UniformSubroutinesuiv");
   CALL_UniformSubroutinesuiv(ctx->CurrentServerDispatch, (shadertype, count, indices));
}


/* CheckFramebufferStatus: marshalled synchronously */
static GLenum GLAPIENTRY
_mesa_marshal_CheckFramebufferStatus(GLenum target)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CheckFramebufferStatus");
   return CALL_CheckFramebufferStatus(ctx->CurrentServerDispatch, (target));
}


/* DispatchComputeIndirect: marshalled asynchronously */
struct marshal_cmd_DispatchComputeIndirect
{
   struct marshal_cmd_base cmd_base;
   GLintptr indirect;
};
static inline void
_mesa_unmarshal_DispatchComputeIndirect(struct gl_context *ctx, const struct marshal_cmd_DispatchComputeIndirect *cmd)
{
   const GLintptr indirect = cmd->indirect;
   CALL_DispatchComputeIndirect(ctx->CurrentServerDispatch, (indirect));
}
static void GLAPIENTRY
_mesa_marshal_DispatchComputeIndirect(GLintptr indirect)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DispatchComputeIndirect);
   struct marshal_cmd_DispatchComputeIndirect *cmd;
   debug_print_marshal("DispatchComputeIndirect");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DispatchComputeIndirect, cmd_size);
      cmd->indirect = indirect;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DispatchComputeIndirect");
   CALL_DispatchComputeIndirect(ctx->CurrentServerDispatch, (indirect));
}


/* InvalidateBufferData: marshalled asynchronously */
struct marshal_cmd_InvalidateBufferData
{
   struct marshal_cmd_base cmd_base;
   GLuint buffer;
};
static inline void
_mesa_unmarshal_InvalidateBufferData(struct gl_context *ctx, const struct marshal_cmd_InvalidateBufferData *cmd)
{
   const GLuint buffer = cmd->buffer;
   CALL_InvalidateBufferData(ctx->CurrentServerDispatch, (buffer));
}
static void GLAPIENTRY
_mesa_marshal_InvalidateBufferData(GLuint buffer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_InvalidateBufferData);
   struct marshal_cmd_InvalidateBufferData *cmd;
   debug_print_marshal("InvalidateBufferData");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_InvalidateBufferData, cmd_size);
      cmd->buffer = buffer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("InvalidateBufferData");
   CALL_InvalidateBufferData(ctx->CurrentServerDispatch, (buffer));
}


/* GetUniformdv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetUniformdv(GLuint program, GLint location, GLdouble * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetUniformdv");
   CALL_GetUniformdv(ctx->CurrentServerDispatch, (program, location, params));
}


/* ProgramLocalParameters4fvEXT: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ProgramLocalParameters4fvEXT(GLenum target, GLuint index, GLsizei count, const GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ProgramLocalParameters4fvEXT");
   CALL_ProgramLocalParameters4fvEXT(ctx->CurrentServerDispatch, (target, index, count, params));
}


/* VertexAttribL1dv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribL1dv(GLuint index, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribL1dv");
   CALL_VertexAttribL1dv(ctx->CurrentServerDispatch, (index, v));
}


/* Uniform1ui64vARB: marshalled asynchronously */
struct marshal_cmd_Uniform1ui64vARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 8) bytes are GLuint64 value[count] */
};
static inline void
_mesa_unmarshal_Uniform1ui64vARB(struct gl_context *ctx, const struct marshal_cmd_Uniform1ui64vARB *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLuint64 * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLuint64 *) variable_data;
   variable_data += count * 8;
   CALL_Uniform1ui64vARB(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform1ui64vARB(GLint location, GLsizei count, const GLuint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform1ui64vARB) + safe_mul(count, 8);
   struct marshal_cmd_Uniform1ui64vARB *cmd;
   debug_print_marshal("Uniform1ui64vARB");
   if (unlikely(safe_mul(count, 8) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform1ui64vARB, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 8);
      variable_data += count * 8;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform1ui64vARB");
   CALL_Uniform1ui64vARB(ctx->CurrentServerDispatch, (location, count, value));
}


/* IsFramebuffer: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsFramebuffer(GLuint framebuffer)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsFramebuffer");
   return CALL_IsFramebuffer(ctx->CurrentServerDispatch, (framebuffer));
}


/* GetDoublev: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetDoublev(GLenum pname, GLdouble * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetDoublev");
   CALL_GetDoublev(ctx->CurrentServerDispatch, (pname, params));
}


/* GetObjectLabel: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetObjectLabel(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei * length, GLchar * label)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetObjectLabel");
   CALL_GetObjectLabel(ctx->CurrentServerDispatch, (identifier, name, bufSize, length, label));
}


/* ColorP3uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ColorP3uiv(GLenum type, const GLuint * color)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ColorP3uiv");
   CALL_ColorP3uiv(ctx->CurrentServerDispatch, (type, color));
}


/* GetTextureSubImage: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTextureSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLsizei bufSize, GLvoid * pixels)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTextureSubImage");
   CALL_GetTextureSubImage(ctx->CurrentServerDispatch, (texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, pixels));
}


/* VertexAttribI4ivEXT: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribI4ivEXT(GLuint index, const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribI4ivEXT");
   CALL_VertexAttribI4ivEXT(ctx->CurrentServerDispatch, (index, v));
}


/* VertexAttrib1svNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib1svNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort v[1];
};
static inline void
_mesa_unmarshal_VertexAttrib1svNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib1svNV *cmd)
{
   const GLuint index = cmd->index;
   const GLshort * v = cmd->v;
   CALL_VertexAttrib1svNV(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib1svNV(GLuint index, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib1svNV);
   struct marshal_cmd_VertexAttrib1svNV *cmd;
   debug_print_marshal("VertexAttrib1svNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib1svNV, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 2);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib1svNV");
   CALL_VertexAttrib1svNV(ctx->CurrentServerDispatch, (index, v));
}


/* SecondaryColor3ubv: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3ubv
{
   struct marshal_cmd_base cmd_base;
   GLubyte v[3];
};
static inline void
_mesa_unmarshal_SecondaryColor3ubv(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3ubv *cmd)
{
   const GLubyte * v = cmd->v;
   CALL_SecondaryColor3ubv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3ubv(const GLubyte * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3ubv);
   struct marshal_cmd_SecondaryColor3ubv *cmd;
   debug_print_marshal("SecondaryColor3ubv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3ubv, cmd_size);
      memcpy(cmd->v, v, 3);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3ubv");
   CALL_SecondaryColor3ubv(ctx->CurrentServerDispatch, (v));
}


/* GetDebugMessageLog: marshalled synchronously */
static GLuint GLAPIENTRY
_mesa_marshal_GetDebugMessageLog(GLuint count, GLsizei bufsize, GLenum * sources, GLenum * types, GLuint * ids, GLenum * severities, GLsizei * lengths, GLchar * messageLog)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetDebugMessageLog");
   return CALL_GetDebugMessageLog(ctx->CurrentServerDispatch, (count, bufsize, sources, types, ids, severities, lengths, messageLog));
}


/* Uniform4ui64ARB: marshalled asynchronously */
struct marshal_cmd_Uniform4ui64ARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLuint64 x;
   GLuint64 y;
   GLuint64 z;
   GLuint64 w;
};
static inline void
_mesa_unmarshal_Uniform4ui64ARB(struct gl_context *ctx, const struct marshal_cmd_Uniform4ui64ARB *cmd)
{
   const GLint location = cmd->location;
   const GLuint64 x = cmd->x;
   const GLuint64 y = cmd->y;
   const GLuint64 z = cmd->z;
   const GLuint64 w = cmd->w;
   CALL_Uniform4ui64ARB(ctx->CurrentServerDispatch, (location, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_Uniform4ui64ARB(GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform4ui64ARB);
   struct marshal_cmd_Uniform4ui64ARB *cmd;
   debug_print_marshal("Uniform4ui64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform4ui64ARB, cmd_size);
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform4ui64ARB");
   CALL_Uniform4ui64ARB(ctx->CurrentServerDispatch, (location, x, y, z, w));
}


/* RasterPos3fv: marshalled asynchronously */
struct marshal_cmd_RasterPos3fv
{
   struct marshal_cmd_base cmd_base;
   GLfloat v[3];
};
static inline void
_mesa_unmarshal_RasterPos3fv(struct gl_context *ctx, const struct marshal_cmd_RasterPos3fv *cmd)
{
   const GLfloat * v = cmd->v;
   CALL_RasterPos3fv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos3fv(const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos3fv);
   struct marshal_cmd_RasterPos3fv *cmd;
   debug_print_marshal("RasterPos3fv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos3fv, cmd_size);
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos3fv");
   CALL_RasterPos3fv(ctx->CurrentServerDispatch, (v));
}


/* GetShaderSource: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetShaderSource(GLuint shader, GLsizei bufSize, GLsizei * length, GLchar * source)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetShaderSource");
   CALL_GetShaderSource(ctx->CurrentServerDispatch, (shader, bufSize, length, source));
}


/* BindProgramARB: marshalled asynchronously */
struct marshal_cmd_BindProgramARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint program;
};
static inline void
_mesa_unmarshal_BindProgramARB(struct gl_context *ctx, const struct marshal_cmd_BindProgramARB *cmd)
{
   const GLenum target = cmd->target;
   const GLuint program = cmd->program;
   CALL_BindProgramARB(ctx->CurrentServerDispatch, (target, program));
}
static void GLAPIENTRY
_mesa_marshal_BindProgramARB(GLenum target, GLuint program)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindProgramARB);
   struct marshal_cmd_BindProgramARB *cmd;
   debug_print_marshal("BindProgramARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindProgramARB, cmd_size);
      cmd->target = target;
      cmd->program = program;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindProgramARB");
   CALL_BindProgramARB(ctx->CurrentServerDispatch, (target, program));
}


/* VertexAttrib3sNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib3sNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort x;
   GLshort y;
   GLshort z;
};
static inline void
_mesa_unmarshal_VertexAttrib3sNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib3sNV *cmd)
{
   const GLuint index = cmd->index;
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   const GLshort z = cmd->z;
   CALL_VertexAttrib3sNV(ctx->CurrentServerDispatch, (index, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib3sNV(GLuint index, GLshort x, GLshort y, GLshort z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib3sNV);
   struct marshal_cmd_VertexAttrib3sNV *cmd;
   debug_print_marshal("VertexAttrib3sNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib3sNV, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib3sNV");
   CALL_VertexAttrib3sNV(ctx->CurrentServerDispatch, (index, x, y, z));
}


/* ColorFragmentOp1ATI: marshalled asynchronously */
struct marshal_cmd_ColorFragmentOp1ATI
{
   struct marshal_cmd_base cmd_base;
   GLenum op;
   GLuint dst;
   GLuint dstMask;
   GLuint dstMod;
   GLuint arg1;
   GLuint arg1Rep;
   GLuint arg1Mod;
};
static inline void
_mesa_unmarshal_ColorFragmentOp1ATI(struct gl_context *ctx, const struct marshal_cmd_ColorFragmentOp1ATI *cmd)
{
   const GLenum op = cmd->op;
   const GLuint dst = cmd->dst;
   const GLuint dstMask = cmd->dstMask;
   const GLuint dstMod = cmd->dstMod;
   const GLuint arg1 = cmd->arg1;
   const GLuint arg1Rep = cmd->arg1Rep;
   const GLuint arg1Mod = cmd->arg1Mod;
   CALL_ColorFragmentOp1ATI(ctx->CurrentServerDispatch, (op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod));
}
static void GLAPIENTRY
_mesa_marshal_ColorFragmentOp1ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ColorFragmentOp1ATI);
   struct marshal_cmd_ColorFragmentOp1ATI *cmd;
   debug_print_marshal("ColorFragmentOp1ATI");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ColorFragmentOp1ATI, cmd_size);
      cmd->op = op;
      cmd->dst = dst;
      cmd->dstMask = dstMask;
      cmd->dstMod = dstMod;
      cmd->arg1 = arg1;
      cmd->arg1Rep = arg1Rep;
      cmd->arg1Mod = arg1Mod;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ColorFragmentOp1ATI");
   CALL_ColorFragmentOp1ATI(ctx->CurrentServerDispatch, (op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod));
}


/* ProgramUniformMatrix4x3fv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix4x3fv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 48) bytes are GLfloat value[count][12] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix4x3fv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix4x3fv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 48;
   CALL_ProgramUniformMatrix4x3fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix4x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix4x3fv) + safe_mul(count, 48);
   struct marshal_cmd_ProgramUniformMatrix4x3fv *cmd;
   debug_print_marshal("ProgramUniformMatrix4x3fv");
   if (unlikely(safe_mul(count, 48) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix4x3fv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 48);
      variable_data += count * 48;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix4x3fv");
   CALL_ProgramUniformMatrix4x3fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* PopClientAttrib: marshalled asynchronously */
struct marshal_cmd_PopClientAttrib
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_PopClientAttrib(struct gl_context *ctx, const struct marshal_cmd_PopClientAttrib *cmd)
{
   CALL_PopClientAttrib(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_PopClientAttrib(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PopClientAttrib);
   struct marshal_cmd_PopClientAttrib *cmd;
   debug_print_marshal("PopClientAttrib");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PopClientAttrib, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PopClientAttrib");
   CALL_PopClientAttrib(ctx->CurrentServerDispatch, ());
}


/* DrawElementsInstancedARB: marshalled asynchronously */
struct marshal_cmd_DrawElementsInstancedARB
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
   GLsizei count;
   GLenum type;
   const GLvoid * indices;
   GLsizei primcount;
};
static inline void
_mesa_unmarshal_DrawElementsInstancedARB(struct gl_context *ctx, const struct marshal_cmd_DrawElementsInstancedARB *cmd)
{
   const GLenum mode = cmd->mode;
   const GLsizei count = cmd->count;
   const GLenum type = cmd->type;
   const GLvoid * indices = cmd->indices;
   const GLsizei primcount = cmd->primcount;
   CALL_DrawElementsInstancedARB(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount));
}
static void GLAPIENTRY
_mesa_marshal_DrawElementsInstancedARB(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei primcount)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawElementsInstancedARB);
   struct marshal_cmd_DrawElementsInstancedARB *cmd;
   debug_print_marshal("DrawElementsInstancedARB");
   if (_mesa_glthread_is_non_vbo_draw_elements(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("DrawElementsInstancedARB");
      CALL_DrawElementsInstancedARB(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawElementsInstancedARB, cmd_size);
      cmd->mode = mode;
      cmd->count = count;
      cmd->type = type;
      cmd->indices = indices;
      cmd->primcount = primcount;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawElementsInstancedARB");
   CALL_DrawElementsInstancedARB(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount));
}


/* GetQueryObjectuiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetQueryObjectuiv(GLuint id, GLenum pname, GLuint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetQueryObjectuiv");
   CALL_GetQueryObjectuiv(ctx->CurrentServerDispatch, (id, pname, params));
}


/* VertexAttribI4bv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribI4bv(GLuint index, const GLbyte * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribI4bv");
   CALL_VertexAttribI4bv(ctx->CurrentServerDispatch, (index, v));
}


/* DisableVertexArrayAttrib: marshalled asynchronously */
struct marshal_cmd_DisableVertexArrayAttrib
{
   struct marshal_cmd_base cmd_base;
   GLuint vaobj;
   GLuint index;
};
static inline void
_mesa_unmarshal_DisableVertexArrayAttrib(struct gl_context *ctx, const struct marshal_cmd_DisableVertexArrayAttrib *cmd)
{
   const GLuint vaobj = cmd->vaobj;
   const GLuint index = cmd->index;
   CALL_DisableVertexArrayAttrib(ctx->CurrentServerDispatch, (vaobj, index));
}
static void GLAPIENTRY
_mesa_marshal_DisableVertexArrayAttrib(GLuint vaobj, GLuint index)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DisableVertexArrayAttrib);
   struct marshal_cmd_DisableVertexArrayAttrib *cmd;
   debug_print_marshal("DisableVertexArrayAttrib");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DisableVertexArrayAttrib, cmd_size);
      cmd->vaobj = vaobj;
      cmd->index = index;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DisableVertexArrayAttrib");
   CALL_DisableVertexArrayAttrib(ctx->CurrentServerDispatch, (vaobj, index));
}


/* VertexAttribL4d: marshalled asynchronously */
struct marshal_cmd_VertexAttribL4d
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble x;
   GLdouble y;
   GLdouble z;
   GLdouble w;
};
static inline void
_mesa_unmarshal_VertexAttribL4d(struct gl_context *ctx, const struct marshal_cmd_VertexAttribL4d *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   const GLdouble w = cmd->w;
   CALL_VertexAttribL4d(ctx->CurrentServerDispatch, (index, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribL4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribL4d);
   struct marshal_cmd_VertexAttribL4d *cmd;
   debug_print_marshal("VertexAttribL4d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribL4d, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribL4d");
   CALL_VertexAttribL4d(ctx->CurrentServerDispatch, (index, x, y, z, w));
}


/* ListBase: marshalled asynchronously */
struct marshal_cmd_ListBase
{
   struct marshal_cmd_base cmd_base;
   GLuint base;
};
static inline void
_mesa_unmarshal_ListBase(struct gl_context *ctx, const struct marshal_cmd_ListBase *cmd)
{
   const GLuint base = cmd->base;
   CALL_ListBase(ctx->CurrentServerDispatch, (base));
}
static void GLAPIENTRY
_mesa_marshal_ListBase(GLuint base)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ListBase);
   struct marshal_cmd_ListBase *cmd;
   debug_print_marshal("ListBase");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ListBase, cmd_size);
      cmd->base = base;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ListBase");
   CALL_ListBase(ctx->CurrentServerDispatch, (base));
}


/* GenerateMipmap: marshalled asynchronously */
struct marshal_cmd_GenerateMipmap
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
};
static inline void
_mesa_unmarshal_GenerateMipmap(struct gl_context *ctx, const struct marshal_cmd_GenerateMipmap *cmd)
{
   const GLenum target = cmd->target;
   CALL_GenerateMipmap(ctx->CurrentServerDispatch, (target));
}
static void GLAPIENTRY
_mesa_marshal_GenerateMipmap(GLenum target)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_GenerateMipmap);
   struct marshal_cmd_GenerateMipmap *cmd;
   debug_print_marshal("GenerateMipmap");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_GenerateMipmap, cmd_size);
      cmd->target = target;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("GenerateMipmap");
   CALL_GenerateMipmap(ctx->CurrentServerDispatch, (target));
}


/* BindBufferRange: marshalled asynchronously */
struct marshal_cmd_BindBufferRange
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
   GLuint buffer;
   GLintptr offset;
   GLsizeiptr size;
};
static inline void
_mesa_unmarshal_BindBufferRange(struct gl_context *ctx, const struct marshal_cmd_BindBufferRange *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   const GLuint buffer = cmd->buffer;
   const GLintptr offset = cmd->offset;
   const GLsizeiptr size = cmd->size;
   CALL_BindBufferRange(ctx->CurrentServerDispatch, (target, index, buffer, offset, size));
}
static void GLAPIENTRY
_mesa_marshal_BindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindBufferRange);
   struct marshal_cmd_BindBufferRange *cmd;
   debug_print_marshal("BindBufferRange");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindBufferRange, cmd_size);
      cmd->target = target;
      cmd->index = index;
      cmd->buffer = buffer;
      cmd->offset = offset;
      cmd->size = size;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindBufferRange");
   CALL_BindBufferRange(ctx->CurrentServerDispatch, (target, index, buffer, offset, size));
}


/* ProgramUniformMatrix2x4fv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix2x4fv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 32) bytes are GLfloat value[count][8] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix2x4fv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix2x4fv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 32;
   CALL_ProgramUniformMatrix2x4fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix2x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix2x4fv) + safe_mul(count, 32);
   struct marshal_cmd_ProgramUniformMatrix2x4fv *cmd;
   debug_print_marshal("ProgramUniformMatrix2x4fv");
   if (unlikely(safe_mul(count, 32) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix2x4fv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 32);
      variable_data += count * 32;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix2x4fv");
   CALL_ProgramUniformMatrix2x4fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* BindBufferBase: marshalled asynchronously */
struct marshal_cmd_BindBufferBase
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
   GLuint buffer;
};
static inline void
_mesa_unmarshal_BindBufferBase(struct gl_context *ctx, const struct marshal_cmd_BindBufferBase *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   const GLuint buffer = cmd->buffer;
   CALL_BindBufferBase(ctx->CurrentServerDispatch, (target, index, buffer));
}
static void GLAPIENTRY
_mesa_marshal_BindBufferBase(GLenum target, GLuint index, GLuint buffer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindBufferBase);
   struct marshal_cmd_BindBufferBase *cmd;
   debug_print_marshal("BindBufferBase");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindBufferBase, cmd_size);
      cmd->target = target;
      cmd->index = index;
      cmd->buffer = buffer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindBufferBase");
   CALL_BindBufferBase(ctx->CurrentServerDispatch, (target, index, buffer));
}


/* GetQueryObjectiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetQueryObjectiv(GLuint id, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetQueryObjectiv");
   CALL_GetQueryObjectiv(ctx->CurrentServerDispatch, (id, pname, params));
}


/* VertexAttrib2s: marshalled asynchronously */
struct marshal_cmd_VertexAttrib2s
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort x;
   GLshort y;
};
static inline void
_mesa_unmarshal_VertexAttrib2s(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib2s *cmd)
{
   const GLuint index = cmd->index;
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   CALL_VertexAttrib2s(ctx->CurrentServerDispatch, (index, x, y));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib2s(GLuint index, GLshort x, GLshort y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib2s);
   struct marshal_cmd_VertexAttrib2s *cmd;
   debug_print_marshal("VertexAttrib2s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib2s, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib2s");
   CALL_VertexAttrib2s(ctx->CurrentServerDispatch, (index, x, y));
}


/* SecondaryColor3fvEXT: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3fvEXT
{
   struct marshal_cmd_base cmd_base;
   GLfloat v[3];
};
static inline void
_mesa_unmarshal_SecondaryColor3fvEXT(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3fvEXT *cmd)
{
   const GLfloat * v = cmd->v;
   CALL_SecondaryColor3fvEXT(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3fvEXT(const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3fvEXT);
   struct marshal_cmd_SecondaryColor3fvEXT *cmd;
   debug_print_marshal("SecondaryColor3fvEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3fvEXT, cmd_size);
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3fvEXT");
   CALL_SecondaryColor3fvEXT(ctx->CurrentServerDispatch, (v));
}


/* VertexAttrib2d: marshalled asynchronously */
struct marshal_cmd_VertexAttrib2d
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble x;
   GLdouble y;
};
static inline void
_mesa_unmarshal_VertexAttrib2d(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib2d *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   CALL_VertexAttrib2d(ctx->CurrentServerDispatch, (index, x, y));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib2d(GLuint index, GLdouble x, GLdouble y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib2d);
   struct marshal_cmd_VertexAttrib2d *cmd;
   debug_print_marshal("VertexAttrib2d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib2d, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib2d");
   CALL_VertexAttrib2d(ctx->CurrentServerDispatch, (index, x, y));
}


/* ClearNamedFramebufferiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ClearNamedFramebufferiv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ClearNamedFramebufferiv");
   CALL_ClearNamedFramebufferiv(ctx->CurrentServerDispatch, (framebuffer, buffer, drawbuffer, value));
}


/* Uniform1fv: marshalled asynchronously */
struct marshal_cmd_Uniform1fv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 4) bytes are GLfloat value[count] */
};
static inline void
_mesa_unmarshal_Uniform1fv(struct gl_context *ctx, const struct marshal_cmd_Uniform1fv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 4;
   CALL_Uniform1fv(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform1fv(GLint location, GLsizei count, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform1fv) + safe_mul(count, 4);
   struct marshal_cmd_Uniform1fv *cmd;
   debug_print_marshal("Uniform1fv");
   if (unlikely(safe_mul(count, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform1fv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 4);
      variable_data += count * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform1fv");
   CALL_Uniform1fv(ctx->CurrentServerDispatch, (location, count, value));
}


/* GetProgramPipelineInfoLog: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetProgramPipelineInfoLog(GLuint pipeline, GLsizei bufSize, GLsizei * length, GLchar * infoLog)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramPipelineInfoLog");
   CALL_GetProgramPipelineInfoLog(ctx->CurrentServerDispatch, (pipeline, bufSize, length, infoLog));
}


/* DepthBoundsEXT: marshalled asynchronously */
struct marshal_cmd_DepthBoundsEXT
{
   struct marshal_cmd_base cmd_base;
   GLclampd zmin;
   GLclampd zmax;
};
static inline void
_mesa_unmarshal_DepthBoundsEXT(struct gl_context *ctx, const struct marshal_cmd_DepthBoundsEXT *cmd)
{
   const GLclampd zmin = cmd->zmin;
   const GLclampd zmax = cmd->zmax;
   CALL_DepthBoundsEXT(ctx->CurrentServerDispatch, (zmin, zmax));
}
static void GLAPIENTRY
_mesa_marshal_DepthBoundsEXT(GLclampd zmin, GLclampd zmax)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DepthBoundsEXT);
   struct marshal_cmd_DepthBoundsEXT *cmd;
   debug_print_marshal("DepthBoundsEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DepthBoundsEXT, cmd_size);
      cmd->zmin = zmin;
      cmd->zmax = zmax;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DepthBoundsEXT");
   CALL_DepthBoundsEXT(ctx->CurrentServerDispatch, (zmin, zmax));
}


/* BufferStorageMemEXT: marshalled asynchronously */
struct marshal_cmd_BufferStorageMemEXT
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizeiptr size;
   GLuint memory;
   GLuint64 offset;
};
static inline void
_mesa_unmarshal_BufferStorageMemEXT(struct gl_context *ctx, const struct marshal_cmd_BufferStorageMemEXT *cmd)
{
   const GLenum target = cmd->target;
   const GLsizeiptr size = cmd->size;
   const GLuint memory = cmd->memory;
   const GLuint64 offset = cmd->offset;
   CALL_BufferStorageMemEXT(ctx->CurrentServerDispatch, (target, size, memory, offset));
}
static void GLAPIENTRY
_mesa_marshal_BufferStorageMemEXT(GLenum target, GLsizeiptr size, GLuint memory, GLuint64 offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BufferStorageMemEXT);
   struct marshal_cmd_BufferStorageMemEXT *cmd;
   debug_print_marshal("BufferStorageMemEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BufferStorageMemEXT, cmd_size);
      cmd->target = target;
      cmd->size = size;
      cmd->memory = memory;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BufferStorageMemEXT");
   CALL_BufferStorageMemEXT(ctx->CurrentServerDispatch, (target, size, memory, offset));
}


/* WindowPos3fv: marshalled asynchronously */
struct marshal_cmd_WindowPos3fv
{
   struct marshal_cmd_base cmd_base;
   GLfloat v[3];
};
static inline void
_mesa_unmarshal_WindowPos3fv(struct gl_context *ctx, const struct marshal_cmd_WindowPos3fv *cmd)
{
   const GLfloat * v = cmd->v;
   CALL_WindowPos3fv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_WindowPos3fv(const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WindowPos3fv);
   struct marshal_cmd_WindowPos3fv *cmd;
   debug_print_marshal("WindowPos3fv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WindowPos3fv, cmd_size);
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WindowPos3fv");
   CALL_WindowPos3fv(ctx->CurrentServerDispatch, (v));
}


/* GetHistogramParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetHistogramParameteriv(GLenum target, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetHistogramParameteriv");
   CALL_GetHistogramParameteriv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* PointParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_PointParameteriv(GLenum pname, const GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("PointParameteriv");
   CALL_PointParameteriv(ctx->CurrentServerDispatch, (pname, params));
}


/* NamedRenderbufferStorage: marshalled asynchronously */
struct marshal_cmd_NamedRenderbufferStorage
{
   struct marshal_cmd_base cmd_base;
   GLuint renderbuffer;
   GLenum internalformat;
   GLsizei width;
   GLsizei height;
};
static inline void
_mesa_unmarshal_NamedRenderbufferStorage(struct gl_context *ctx, const struct marshal_cmd_NamedRenderbufferStorage *cmd)
{
   const GLuint renderbuffer = cmd->renderbuffer;
   const GLenum internalformat = cmd->internalformat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   CALL_NamedRenderbufferStorage(ctx->CurrentServerDispatch, (renderbuffer, internalformat, width, height));
}
static void GLAPIENTRY
_mesa_marshal_NamedRenderbufferStorage(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_NamedRenderbufferStorage);
   struct marshal_cmd_NamedRenderbufferStorage *cmd;
   debug_print_marshal("NamedRenderbufferStorage");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_NamedRenderbufferStorage, cmd_size);
      cmd->renderbuffer = renderbuffer;
      cmd->internalformat = internalformat;
      cmd->width = width;
      cmd->height = height;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("NamedRenderbufferStorage");
   CALL_NamedRenderbufferStorage(ctx->CurrentServerDispatch, (renderbuffer, internalformat, width, height));
}


/* GetProgramivARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetProgramivARB(GLenum target, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramivARB");
   CALL_GetProgramivARB(ctx->CurrentServerDispatch, (target, pname, params));
}


/* BindRenderbuffer: marshalled asynchronously */
struct marshal_cmd_BindRenderbuffer
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint renderbuffer;
};
static inline void
_mesa_unmarshal_BindRenderbuffer(struct gl_context *ctx, const struct marshal_cmd_BindRenderbuffer *cmd)
{
   const GLenum target = cmd->target;
   const GLuint renderbuffer = cmd->renderbuffer;
   CALL_BindRenderbuffer(ctx->CurrentServerDispatch, (target, renderbuffer));
}
static void GLAPIENTRY
_mesa_marshal_BindRenderbuffer(GLenum target, GLuint renderbuffer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindRenderbuffer);
   struct marshal_cmd_BindRenderbuffer *cmd;
   debug_print_marshal("BindRenderbuffer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindRenderbuffer, cmd_size);
      cmd->target = target;
      cmd->renderbuffer = renderbuffer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindRenderbuffer");
   CALL_BindRenderbuffer(ctx->CurrentServerDispatch, (target, renderbuffer));
}


/* SecondaryColor3fEXT: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3fEXT
{
   struct marshal_cmd_base cmd_base;
   GLfloat red;
   GLfloat green;
   GLfloat blue;
};
static inline void
_mesa_unmarshal_SecondaryColor3fEXT(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3fEXT *cmd)
{
   const GLfloat red = cmd->red;
   const GLfloat green = cmd->green;
   const GLfloat blue = cmd->blue;
   CALL_SecondaryColor3fEXT(ctx->CurrentServerDispatch, (red, green, blue));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3fEXT(GLfloat red, GLfloat green, GLfloat blue)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3fEXT);
   struct marshal_cmd_SecondaryColor3fEXT *cmd;
   debug_print_marshal("SecondaryColor3fEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3fEXT, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3fEXT");
   CALL_SecondaryColor3fEXT(ctx->CurrentServerDispatch, (red, green, blue));
}


/* PrimitiveRestartIndex: marshalled asynchronously */
struct marshal_cmd_PrimitiveRestartIndex
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
};
static inline void
_mesa_unmarshal_PrimitiveRestartIndex(struct gl_context *ctx, const struct marshal_cmd_PrimitiveRestartIndex *cmd)
{
   const GLuint index = cmd->index;
   CALL_PrimitiveRestartIndex(ctx->CurrentServerDispatch, (index));
}
static void GLAPIENTRY
_mesa_marshal_PrimitiveRestartIndex(GLuint index)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PrimitiveRestartIndex);
   struct marshal_cmd_PrimitiveRestartIndex *cmd;
   debug_print_marshal("PrimitiveRestartIndex");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PrimitiveRestartIndex, cmd_size);
      cmd->index = index;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PrimitiveRestartIndex");
   CALL_PrimitiveRestartIndex(ctx->CurrentServerDispatch, (index));
}


/* TextureStorageMem3DEXT: marshalled asynchronously */
struct marshal_cmd_TextureStorageMem3DEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLsizei levels;
   GLenum internalFormat;
   GLsizei width;
   GLsizei height;
   GLsizei depth;
   GLuint memory;
   GLuint64 offset;
};
static inline void
_mesa_unmarshal_TextureStorageMem3DEXT(struct gl_context *ctx, const struct marshal_cmd_TextureStorageMem3DEXT *cmd)
{
   const GLuint texture = cmd->texture;
   const GLsizei levels = cmd->levels;
   const GLenum internalFormat = cmd->internalFormat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLsizei depth = cmd->depth;
   const GLuint memory = cmd->memory;
   const GLuint64 offset = cmd->offset;
   CALL_TextureStorageMem3DEXT(ctx->CurrentServerDispatch, (texture, levels, internalFormat, width, height, depth, memory, offset));
}
static void GLAPIENTRY
_mesa_marshal_TextureStorageMem3DEXT(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLuint memory, GLuint64 offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureStorageMem3DEXT);
   struct marshal_cmd_TextureStorageMem3DEXT *cmd;
   debug_print_marshal("TextureStorageMem3DEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureStorageMem3DEXT, cmd_size);
      cmd->texture = texture;
      cmd->levels = levels;
      cmd->internalFormat = internalFormat;
      cmd->width = width;
      cmd->height = height;
      cmd->depth = depth;
      cmd->memory = memory;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureStorageMem3DEXT");
   CALL_TextureStorageMem3DEXT(ctx->CurrentServerDispatch, (texture, levels, internalFormat, width, height, depth, memory, offset));
}


/* VertexAttribI4ubv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribI4ubv(GLuint index, const GLubyte * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribI4ubv");
   CALL_VertexAttribI4ubv(ctx->CurrentServerDispatch, (index, v));
}


/* GetGraphicsResetStatusARB: marshalled synchronously */
static GLenum GLAPIENTRY
_mesa_marshal_GetGraphicsResetStatusARB(void)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetGraphicsResetStatusARB");
   return CALL_GetGraphicsResetStatusARB(ctx->CurrentServerDispatch, ());
}


/* CreateRenderbuffers: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CreateRenderbuffers(GLsizei n, GLuint * renderbuffers)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CreateRenderbuffers");
   CALL_CreateRenderbuffers(ctx->CurrentServerDispatch, (n, renderbuffers));
}


/* ActiveStencilFaceEXT: marshalled asynchronously */
struct marshal_cmd_ActiveStencilFaceEXT
{
   struct marshal_cmd_base cmd_base;
   GLenum face;
};
static inline void
_mesa_unmarshal_ActiveStencilFaceEXT(struct gl_context *ctx, const struct marshal_cmd_ActiveStencilFaceEXT *cmd)
{
   const GLenum face = cmd->face;
   CALL_ActiveStencilFaceEXT(ctx->CurrentServerDispatch, (face));
}
static void GLAPIENTRY
_mesa_marshal_ActiveStencilFaceEXT(GLenum face)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ActiveStencilFaceEXT);
   struct marshal_cmd_ActiveStencilFaceEXT *cmd;
   debug_print_marshal("ActiveStencilFaceEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ActiveStencilFaceEXT, cmd_size);
      cmd->face = face;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ActiveStencilFaceEXT");
   CALL_ActiveStencilFaceEXT(ctx->CurrentServerDispatch, (face));
}


/* VertexAttrib4dNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4dNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble x;
   GLdouble y;
   GLdouble z;
   GLdouble w;
};
static inline void
_mesa_unmarshal_VertexAttrib4dNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4dNV *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   const GLdouble w = cmd->w;
   CALL_VertexAttrib4dNV(ctx->CurrentServerDispatch, (index, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4dNV(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4dNV);
   struct marshal_cmd_VertexAttrib4dNV *cmd;
   debug_print_marshal("VertexAttrib4dNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4dNV, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4dNV");
   CALL_VertexAttrib4dNV(ctx->CurrentServerDispatch, (index, x, y, z, w));
}


/* DepthRange: marshalled asynchronously */
struct marshal_cmd_DepthRange
{
   struct marshal_cmd_base cmd_base;
   GLclampd zNear;
   GLclampd zFar;
};
static inline void
_mesa_unmarshal_DepthRange(struct gl_context *ctx, const struct marshal_cmd_DepthRange *cmd)
{
   const GLclampd zNear = cmd->zNear;
   const GLclampd zFar = cmd->zFar;
   CALL_DepthRange(ctx->CurrentServerDispatch, (zNear, zFar));
}
static void GLAPIENTRY
_mesa_marshal_DepthRange(GLclampd zNear, GLclampd zFar)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DepthRange);
   struct marshal_cmd_DepthRange *cmd;
   debug_print_marshal("DepthRange");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DepthRange, cmd_size);
      cmd->zNear = zNear;
      cmd->zFar = zFar;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DepthRange");
   CALL_DepthRange(ctx->CurrentServerDispatch, (zNear, zFar));
}


/* VertexAttrib4fNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4fNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat x;
   GLfloat y;
   GLfloat z;
   GLfloat w;
};
static inline void
_mesa_unmarshal_VertexAttrib4fNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4fNV *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   const GLfloat w = cmd->w;
   CALL_VertexAttrib4fNV(ctx->CurrentServerDispatch, (index, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4fNV(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4fNV);
   struct marshal_cmd_VertexAttrib4fNV *cmd;
   debug_print_marshal("VertexAttrib4fNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4fNV, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4fNV");
   CALL_VertexAttrib4fNV(ctx->CurrentServerDispatch, (index, x, y, z, w));
}


/* Uniform4fv: marshalled asynchronously */
struct marshal_cmd_Uniform4fv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 16) bytes are GLfloat value[count][4] */
};
static inline void
_mesa_unmarshal_Uniform4fv(struct gl_context *ctx, const struct marshal_cmd_Uniform4fv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 16;
   CALL_Uniform4fv(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform4fv(GLint location, GLsizei count, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform4fv) + safe_mul(count, 16);
   struct marshal_cmd_Uniform4fv *cmd;
   debug_print_marshal("Uniform4fv");
   if (unlikely(safe_mul(count, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform4fv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 16);
      variable_data += count * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform4fv");
   CALL_Uniform4fv(ctx->CurrentServerDispatch, (location, count, value));
}


/* SamplerParameterIiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_SamplerParameterIiv(GLuint sampler, GLenum pname, const GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("SamplerParameterIiv");
   CALL_SamplerParameterIiv(ctx->CurrentServerDispatch, (sampler, pname, params));
}


/* Frustumf: marshalled asynchronously */
struct marshal_cmd_Frustumf
{
   struct marshal_cmd_base cmd_base;
   GLfloat left;
   GLfloat right;
   GLfloat bottom;
   GLfloat top;
   GLfloat zNear;
   GLfloat zFar;
};
static inline void
_mesa_unmarshal_Frustumf(struct gl_context *ctx, const struct marshal_cmd_Frustumf *cmd)
{
   const GLfloat left = cmd->left;
   const GLfloat right = cmd->right;
   const GLfloat bottom = cmd->bottom;
   const GLfloat top = cmd->top;
   const GLfloat zNear = cmd->zNear;
   const GLfloat zFar = cmd->zFar;
   CALL_Frustumf(ctx->CurrentServerDispatch, (left, right, bottom, top, zNear, zFar));
}
static void GLAPIENTRY
_mesa_marshal_Frustumf(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Frustumf);
   struct marshal_cmd_Frustumf *cmd;
   debug_print_marshal("Frustumf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Frustumf, cmd_size);
      cmd->left = left;
      cmd->right = right;
      cmd->bottom = bottom;
      cmd->top = top;
      cmd->zNear = zNear;
      cmd->zFar = zFar;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Frustumf");
   CALL_Frustumf(ctx->CurrentServerDispatch, (left, right, bottom, top, zNear, zFar));
}


/* GetQueryBufferObjectui64v: marshalled asynchronously */
struct marshal_cmd_GetQueryBufferObjectui64v
{
   struct marshal_cmd_base cmd_base;
   GLuint id;
   GLuint buffer;
   GLenum pname;
   GLintptr offset;
};
static inline void
_mesa_unmarshal_GetQueryBufferObjectui64v(struct gl_context *ctx, const struct marshal_cmd_GetQueryBufferObjectui64v *cmd)
{
   const GLuint id = cmd->id;
   const GLuint buffer = cmd->buffer;
   const GLenum pname = cmd->pname;
   const GLintptr offset = cmd->offset;
   CALL_GetQueryBufferObjectui64v(ctx->CurrentServerDispatch, (id, buffer, pname, offset));
}
static void GLAPIENTRY
_mesa_marshal_GetQueryBufferObjectui64v(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_GetQueryBufferObjectui64v);
   struct marshal_cmd_GetQueryBufferObjectui64v *cmd;
   debug_print_marshal("GetQueryBufferObjectui64v");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_GetQueryBufferObjectui64v, cmd_size);
      cmd->id = id;
      cmd->buffer = buffer;
      cmd->pname = pname;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("GetQueryBufferObjectui64v");
   CALL_GetQueryBufferObjectui64v(ctx->CurrentServerDispatch, (id, buffer, pname, offset));
}


/* ProgramUniform2uiv: marshalled asynchronously */
struct marshal_cmd_ProgramUniform2uiv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 8) bytes are GLuint value[count][2] */
};
static inline void
_mesa_unmarshal_ProgramUniform2uiv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform2uiv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLuint * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLuint *) variable_data;
   variable_data += count * 8;
   CALL_ProgramUniform2uiv(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform2uiv(GLuint program, GLint location, GLsizei count, const GLuint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform2uiv) + safe_mul(count, 8);
   struct marshal_cmd_ProgramUniform2uiv *cmd;
   debug_print_marshal("ProgramUniform2uiv");
   if (unlikely(safe_mul(count, 8) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform2uiv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 8);
      variable_data += count * 8;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform2uiv");
   CALL_ProgramUniform2uiv(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* Rectsv: marshalled asynchronously */
struct marshal_cmd_Rectsv
{
   struct marshal_cmd_base cmd_base;
   GLshort v1[2];
   GLshort v2[2];
};
static inline void
_mesa_unmarshal_Rectsv(struct gl_context *ctx, const struct marshal_cmd_Rectsv *cmd)
{
   const GLshort * v1 = cmd->v1;
   const GLshort * v2 = cmd->v2;
   CALL_Rectsv(ctx->CurrentServerDispatch, (v1, v2));
}
static void GLAPIENTRY
_mesa_marshal_Rectsv(const GLshort * v1, const GLshort * v2)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Rectsv);
   struct marshal_cmd_Rectsv *cmd;
   debug_print_marshal("Rectsv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Rectsv, cmd_size);
      memcpy(cmd->v1, v1, 4);
      memcpy(cmd->v2, v2, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Rectsv");
   CALL_Rectsv(ctx->CurrentServerDispatch, (v1, v2));
}


/* Frustumx: marshalled asynchronously */
struct marshal_cmd_Frustumx
{
   struct marshal_cmd_base cmd_base;
   GLfixed left;
   GLfixed right;
   GLfixed bottom;
   GLfixed top;
   GLfixed zNear;
   GLfixed zFar;
};
static inline void
_mesa_unmarshal_Frustumx(struct gl_context *ctx, const struct marshal_cmd_Frustumx *cmd)
{
   const GLfixed left = cmd->left;
   const GLfixed right = cmd->right;
   const GLfixed bottom = cmd->bottom;
   const GLfixed top = cmd->top;
   const GLfixed zNear = cmd->zNear;
   const GLfixed zFar = cmd->zFar;
   CALL_Frustumx(ctx->CurrentServerDispatch, (left, right, bottom, top, zNear, zFar));
}
static void GLAPIENTRY
_mesa_marshal_Frustumx(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Frustumx);
   struct marshal_cmd_Frustumx *cmd;
   debug_print_marshal("Frustumx");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Frustumx, cmd_size);
      cmd->left = left;
      cmd->right = right;
      cmd->bottom = bottom;
      cmd->top = top;
      cmd->zNear = zNear;
      cmd->zFar = zFar;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Frustumx");
   CALL_Frustumx(ctx->CurrentServerDispatch, (left, right, bottom, top, zNear, zFar));
}


/* CullFace: marshalled asynchronously */
struct marshal_cmd_CullFace
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
};
static inline void
_mesa_unmarshal_CullFace(struct gl_context *ctx, const struct marshal_cmd_CullFace *cmd)
{
   const GLenum mode = cmd->mode;
   CALL_CullFace(ctx->CurrentServerDispatch, (mode));
}
static void GLAPIENTRY
_mesa_marshal_CullFace(GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_CullFace);
   struct marshal_cmd_CullFace *cmd;
   debug_print_marshal("CullFace");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_CullFace, cmd_size);
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("CullFace");
   CALL_CullFace(ctx->CurrentServerDispatch, (mode));
}


/* BindTexture: marshalled asynchronously */
struct marshal_cmd_BindTexture
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint texture;
};
static inline void
_mesa_unmarshal_BindTexture(struct gl_context *ctx, const struct marshal_cmd_BindTexture *cmd)
{
   const GLenum target = cmd->target;
   const GLuint texture = cmd->texture;
   CALL_BindTexture(ctx->CurrentServerDispatch, (target, texture));
}
static void GLAPIENTRY
_mesa_marshal_BindTexture(GLenum target, GLuint texture)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindTexture);
   struct marshal_cmd_BindTexture *cmd;
   debug_print_marshal("BindTexture");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindTexture, cmd_size);
      cmd->target = target;
      cmd->texture = texture;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindTexture");
   CALL_BindTexture(ctx->CurrentServerDispatch, (target, texture));
}


/* MultiTexCoord4fARB: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord4fARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLfloat s;
   GLfloat t;
   GLfloat r;
   GLfloat q;
};
static inline void
_mesa_unmarshal_MultiTexCoord4fARB(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord4fARB *cmd)
{
   const GLenum target = cmd->target;
   const GLfloat s = cmd->s;
   const GLfloat t = cmd->t;
   const GLfloat r = cmd->r;
   const GLfloat q = cmd->q;
   CALL_MultiTexCoord4fARB(ctx->CurrentServerDispatch, (target, s, t, r, q));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord4fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord4fARB);
   struct marshal_cmd_MultiTexCoord4fARB *cmd;
   debug_print_marshal("MultiTexCoord4fARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord4fARB, cmd_size);
      cmd->target = target;
      cmd->s = s;
      cmd->t = t;
      cmd->r = r;
      cmd->q = q;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord4fARB");
   CALL_MultiTexCoord4fARB(ctx->CurrentServerDispatch, (target, s, t, r, q));
}


/* Uniform2ui64ARB: marshalled asynchronously */
struct marshal_cmd_Uniform2ui64ARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLuint64 x;
   GLuint64 y;
};
static inline void
_mesa_unmarshal_Uniform2ui64ARB(struct gl_context *ctx, const struct marshal_cmd_Uniform2ui64ARB *cmd)
{
   const GLint location = cmd->location;
   const GLuint64 x = cmd->x;
   const GLuint64 y = cmd->y;
   CALL_Uniform2ui64ARB(ctx->CurrentServerDispatch, (location, x, y));
}
static void GLAPIENTRY
_mesa_marshal_Uniform2ui64ARB(GLint location, GLuint64 x, GLuint64 y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform2ui64ARB);
   struct marshal_cmd_Uniform2ui64ARB *cmd;
   debug_print_marshal("Uniform2ui64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform2ui64ARB, cmd_size);
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform2ui64ARB");
   CALL_Uniform2ui64ARB(ctx->CurrentServerDispatch, (location, x, y));
}


/* MultiTexCoordP2uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_MultiTexCoordP2uiv(GLenum texture, GLenum type, const GLuint * coords)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MultiTexCoordP2uiv");
   CALL_MultiTexCoordP2uiv(ctx->CurrentServerDispatch, (texture, type, coords));
}


/* BeginPerfQueryINTEL: marshalled asynchronously */
struct marshal_cmd_BeginPerfQueryINTEL
{
   struct marshal_cmd_base cmd_base;
   GLuint queryHandle;
};
static inline void
_mesa_unmarshal_BeginPerfQueryINTEL(struct gl_context *ctx, const struct marshal_cmd_BeginPerfQueryINTEL *cmd)
{
   const GLuint queryHandle = cmd->queryHandle;
   CALL_BeginPerfQueryINTEL(ctx->CurrentServerDispatch, (queryHandle));
}
static void GLAPIENTRY
_mesa_marshal_BeginPerfQueryINTEL(GLuint queryHandle)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BeginPerfQueryINTEL);
   struct marshal_cmd_BeginPerfQueryINTEL *cmd;
   debug_print_marshal("BeginPerfQueryINTEL");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BeginPerfQueryINTEL, cmd_size);
      cmd->queryHandle = queryHandle;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BeginPerfQueryINTEL");
   CALL_BeginPerfQueryINTEL(ctx->CurrentServerDispatch, (queryHandle));
}


/* NormalPointer: marshalled asynchronously */
struct marshal_cmd_NormalPointer
{
   struct marshal_cmd_base cmd_base;
   GLenum type;
   GLsizei stride;
   const GLvoid * pointer;
};
static inline void
_mesa_unmarshal_NormalPointer(struct gl_context *ctx, const struct marshal_cmd_NormalPointer *cmd)
{
   const GLenum type = cmd->type;
   const GLsizei stride = cmd->stride;
   const GLvoid * pointer = cmd->pointer;
   CALL_NormalPointer(ctx->CurrentServerDispatch, (type, stride, pointer));
}
static void GLAPIENTRY
_mesa_marshal_NormalPointer(GLenum type, GLsizei stride, const GLvoid * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_NormalPointer);
   struct marshal_cmd_NormalPointer *cmd;
   debug_print_marshal("NormalPointer");
   if (_mesa_glthread_is_non_vbo_vertex_attrib_pointer(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("NormalPointer");
      CALL_NormalPointer(ctx->CurrentServerDispatch, (type, stride, pointer));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_NormalPointer, cmd_size);
      cmd->type = type;
      cmd->stride = stride;
      cmd->pointer = pointer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("NormalPointer");
   CALL_NormalPointer(ctx->CurrentServerDispatch, (type, stride, pointer));
}


/* WindowPos4iMESA: marshalled asynchronously */
struct marshal_cmd_WindowPos4iMESA
{
   struct marshal_cmd_base cmd_base;
   GLint x;
   GLint y;
   GLint z;
   GLint w;
};
static inline void
_mesa_unmarshal_WindowPos4iMESA(struct gl_context *ctx, const struct marshal_cmd_WindowPos4iMESA *cmd)
{
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLint z = cmd->z;
   const GLint w = cmd->w;
   CALL_WindowPos4iMESA(ctx->CurrentServerDispatch, (x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_WindowPos4iMESA(GLint x, GLint y, GLint z, GLint w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WindowPos4iMESA);
   struct marshal_cmd_WindowPos4iMESA *cmd;
   debug_print_marshal("WindowPos4iMESA");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WindowPos4iMESA, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WindowPos4iMESA");
   CALL_WindowPos4iMESA(ctx->CurrentServerDispatch, (x, y, z, w));
}


/* VertexAttrib4bv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4bv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLbyte v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4bv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4bv *cmd)
{
   const GLuint index = cmd->index;
   const GLbyte * v = cmd->v;
   CALL_VertexAttrib4bv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4bv(GLuint index, const GLbyte * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4bv);
   struct marshal_cmd_VertexAttrib4bv *cmd;
   debug_print_marshal("VertexAttrib4bv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4bv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4bv");
   CALL_VertexAttrib4bv(ctx->CurrentServerDispatch, (index, v));
}


/* SecondaryColor3usv: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3usv
{
   struct marshal_cmd_base cmd_base;
   GLushort v[3];
};
static inline void
_mesa_unmarshal_SecondaryColor3usv(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3usv *cmd)
{
   const GLushort * v = cmd->v;
   CALL_SecondaryColor3usv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3usv(const GLushort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3usv);
   struct marshal_cmd_SecondaryColor3usv *cmd;
   debug_print_marshal("SecondaryColor3usv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3usv, cmd_size);
      memcpy(cmd->v, v, 6);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3usv");
   CALL_SecondaryColor3usv(ctx->CurrentServerDispatch, (v));
}


/* GetPixelMapuiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetPixelMapuiv(GLenum map, GLuint * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetPixelMapuiv");
   CALL_GetPixelMapuiv(ctx->CurrentServerDispatch, (map, values));
}


/* MapNamedBuffer: marshalled synchronously */
static GLvoid * GLAPIENTRY
_mesa_marshal_MapNamedBuffer(GLuint buffer, GLenum access)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MapNamedBuffer");
   return CALL_MapNamedBuffer(ctx->CurrentServerDispatch, (buffer, access));
}


/* Indexfv: marshalled asynchronously */
struct marshal_cmd_Indexfv
{
   struct marshal_cmd_base cmd_base;
   GLfloat c[1];
};
static inline void
_mesa_unmarshal_Indexfv(struct gl_context *ctx, const struct marshal_cmd_Indexfv *cmd)
{
   const GLfloat * c = cmd->c;
   CALL_Indexfv(ctx->CurrentServerDispatch, (c));
}
static void GLAPIENTRY
_mesa_marshal_Indexfv(const GLfloat * c)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Indexfv);
   struct marshal_cmd_Indexfv *cmd;
   debug_print_marshal("Indexfv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Indexfv, cmd_size);
      memcpy(cmd->c, c, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Indexfv");
   CALL_Indexfv(ctx->CurrentServerDispatch, (c));
}


/* AlphaFragmentOp1ATI: marshalled asynchronously */
struct marshal_cmd_AlphaFragmentOp1ATI
{
   struct marshal_cmd_base cmd_base;
   GLenum op;
   GLuint dst;
   GLuint dstMod;
   GLuint arg1;
   GLuint arg1Rep;
   GLuint arg1Mod;
};
static inline void
_mesa_unmarshal_AlphaFragmentOp1ATI(struct gl_context *ctx, const struct marshal_cmd_AlphaFragmentOp1ATI *cmd)
{
   const GLenum op = cmd->op;
   const GLuint dst = cmd->dst;
   const GLuint dstMod = cmd->dstMod;
   const GLuint arg1 = cmd->arg1;
   const GLuint arg1Rep = cmd->arg1Rep;
   const GLuint arg1Mod = cmd->arg1Mod;
   CALL_AlphaFragmentOp1ATI(ctx->CurrentServerDispatch, (op, dst, dstMod, arg1, arg1Rep, arg1Mod));
}
static void GLAPIENTRY
_mesa_marshal_AlphaFragmentOp1ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_AlphaFragmentOp1ATI);
   struct marshal_cmd_AlphaFragmentOp1ATI *cmd;
   debug_print_marshal("AlphaFragmentOp1ATI");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_AlphaFragmentOp1ATI, cmd_size);
      cmd->op = op;
      cmd->dst = dst;
      cmd->dstMod = dstMod;
      cmd->arg1 = arg1;
      cmd->arg1Rep = arg1Rep;
      cmd->arg1Mod = arg1Mod;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("AlphaFragmentOp1ATI");
   CALL_AlphaFragmentOp1ATI(ctx->CurrentServerDispatch, (op, dst, dstMod, arg1, arg1Rep, arg1Mod));
}


/* GetFloatv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetFloatv(GLenum pname, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetFloatv");
   CALL_GetFloatv(ctx->CurrentServerDispatch, (pname, params));
}


/* ProgramUniform2dv: marshalled asynchronously */
struct marshal_cmd_ProgramUniform2dv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 16) bytes are GLdouble value[count][2] */
};
static inline void
_mesa_unmarshal_ProgramUniform2dv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform2dv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 16;
   CALL_ProgramUniform2dv(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform2dv(GLuint program, GLint location, GLsizei count, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform2dv) + safe_mul(count, 16);
   struct marshal_cmd_ProgramUniform2dv *cmd;
   debug_print_marshal("ProgramUniform2dv");
   if (unlikely(safe_mul(count, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform2dv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 16);
      variable_data += count * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform2dv");
   CALL_ProgramUniform2dv(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* MultiTexCoord3i: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord3i
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLint s;
   GLint t;
   GLint r;
};
static inline void
_mesa_unmarshal_MultiTexCoord3i(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord3i *cmd)
{
   const GLenum target = cmd->target;
   const GLint s = cmd->s;
   const GLint t = cmd->t;
   const GLint r = cmd->r;
   CALL_MultiTexCoord3i(ctx->CurrentServerDispatch, (target, s, t, r));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord3i(GLenum target, GLint s, GLint t, GLint r)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord3i);
   struct marshal_cmd_MultiTexCoord3i *cmd;
   debug_print_marshal("MultiTexCoord3i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord3i, cmd_size);
      cmd->target = target;
      cmd->s = s;
      cmd->t = t;
      cmd->r = r;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord3i");
   CALL_MultiTexCoord3i(ctx->CurrentServerDispatch, (target, s, t, r));
}


/* ProgramUniform1fv: marshalled asynchronously */
struct marshal_cmd_ProgramUniform1fv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 4) bytes are GLfloat value[count] */
};
static inline void
_mesa_unmarshal_ProgramUniform1fv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform1fv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 4;
   CALL_ProgramUniform1fv(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform1fv(GLuint program, GLint location, GLsizei count, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform1fv) + safe_mul(count, 4);
   struct marshal_cmd_ProgramUniform1fv *cmd;
   debug_print_marshal("ProgramUniform1fv");
   if (unlikely(safe_mul(count, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform1fv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 4);
      variable_data += count * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform1fv");
   CALL_ProgramUniform1fv(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* MultiTexCoord3d: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord3d
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLdouble s;
   GLdouble t;
   GLdouble r;
};
static inline void
_mesa_unmarshal_MultiTexCoord3d(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord3d *cmd)
{
   const GLenum target = cmd->target;
   const GLdouble s = cmd->s;
   const GLdouble t = cmd->t;
   const GLdouble r = cmd->r;
   CALL_MultiTexCoord3d(ctx->CurrentServerDispatch, (target, s, t, r));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord3d(GLenum target, GLdouble s, GLdouble t, GLdouble r)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord3d);
   struct marshal_cmd_MultiTexCoord3d *cmd;
   debug_print_marshal("MultiTexCoord3d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord3d, cmd_size);
      cmd->target = target;
      cmd->s = s;
      cmd->t = t;
      cmd->r = r;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord3d");
   CALL_MultiTexCoord3d(ctx->CurrentServerDispatch, (target, s, t, r));
}


/* TexCoord3sv: marshalled asynchronously */
struct marshal_cmd_TexCoord3sv
{
   struct marshal_cmd_base cmd_base;
   GLshort v[3];
};
static inline void
_mesa_unmarshal_TexCoord3sv(struct gl_context *ctx, const struct marshal_cmd_TexCoord3sv *cmd)
{
   const GLshort * v = cmd->v;
   CALL_TexCoord3sv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord3sv(const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord3sv);
   struct marshal_cmd_TexCoord3sv *cmd;
   debug_print_marshal("TexCoord3sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord3sv, cmd_size);
      memcpy(cmd->v, v, 6);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord3sv");
   CALL_TexCoord3sv(ctx->CurrentServerDispatch, (v));
}


/* Fogfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_Fogfv(GLenum pname, const GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("Fogfv");
   CALL_Fogfv(ctx->CurrentServerDispatch, (pname, params));
}


/* Minmax: marshalled asynchronously */
struct marshal_cmd_Minmax
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum internalformat;
   GLboolean sink;
};
static inline void
_mesa_unmarshal_Minmax(struct gl_context *ctx, const struct marshal_cmd_Minmax *cmd)
{
   const GLenum target = cmd->target;
   const GLenum internalformat = cmd->internalformat;
   const GLboolean sink = cmd->sink;
   CALL_Minmax(ctx->CurrentServerDispatch, (target, internalformat, sink));
}
static void GLAPIENTRY
_mesa_marshal_Minmax(GLenum target, GLenum internalformat, GLboolean sink)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Minmax);
   struct marshal_cmd_Minmax *cmd;
   debug_print_marshal("Minmax");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Minmax, cmd_size);
      cmd->target = target;
      cmd->internalformat = internalformat;
      cmd->sink = sink;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Minmax");
   CALL_Minmax(ctx->CurrentServerDispatch, (target, internalformat, sink));
}


/* MultiTexCoord3s: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord3s
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLshort s;
   GLshort t;
   GLshort r;
};
static inline void
_mesa_unmarshal_MultiTexCoord3s(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord3s *cmd)
{
   const GLenum target = cmd->target;
   const GLshort s = cmd->s;
   const GLshort t = cmd->t;
   const GLshort r = cmd->r;
   CALL_MultiTexCoord3s(ctx->CurrentServerDispatch, (target, s, t, r));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord3s(GLenum target, GLshort s, GLshort t, GLshort r)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord3s);
   struct marshal_cmd_MultiTexCoord3s *cmd;
   debug_print_marshal("MultiTexCoord3s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord3s, cmd_size);
      cmd->target = target;
      cmd->s = s;
      cmd->t = t;
      cmd->r = r;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord3s");
   CALL_MultiTexCoord3s(ctx->CurrentServerDispatch, (target, s, t, r));
}


/* Vertex4iv: marshalled asynchronously */
struct marshal_cmd_Vertex4iv
{
   struct marshal_cmd_base cmd_base;
   GLint v[4];
};
static inline void
_mesa_unmarshal_Vertex4iv(struct gl_context *ctx, const struct marshal_cmd_Vertex4iv *cmd)
{
   const GLint * v = cmd->v;
   CALL_Vertex4iv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Vertex4iv(const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex4iv);
   struct marshal_cmd_Vertex4iv *cmd;
   debug_print_marshal("Vertex4iv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex4iv, cmd_size);
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex4iv");
   CALL_Vertex4iv(ctx->CurrentServerDispatch, (v));
}


/* TexCoord4dv: marshalled asynchronously */
struct marshal_cmd_TexCoord4dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v[4];
};
static inline void
_mesa_unmarshal_TexCoord4dv(struct gl_context *ctx, const struct marshal_cmd_TexCoord4dv *cmd)
{
   const GLdouble * v = cmd->v;
   CALL_TexCoord4dv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord4dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord4dv);
   struct marshal_cmd_TexCoord4dv *cmd;
   debug_print_marshal("TexCoord4dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord4dv, cmd_size);
      memcpy(cmd->v, v, 32);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord4dv");
   CALL_TexCoord4dv(ctx->CurrentServerDispatch, (v));
}


/* Begin: marshalled asynchronously */
struct marshal_cmd_Begin
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
};
static inline void
_mesa_unmarshal_Begin(struct gl_context *ctx, const struct marshal_cmd_Begin *cmd)
{
   const GLenum mode = cmd->mode;
   CALL_Begin(ctx->CurrentServerDispatch, (mode));
}
static void GLAPIENTRY
_mesa_marshal_Begin(GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Begin);
   struct marshal_cmd_Begin *cmd;
   debug_print_marshal("Begin");
   if (true) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("Begin");
      CALL_Begin(ctx->CurrentServerDispatch, (mode));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Begin, cmd_size);
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Begin");
   CALL_Begin(ctx->CurrentServerDispatch, (mode));
}


/* LightModeli: marshalled asynchronously */
struct marshal_cmd_LightModeli
{
   struct marshal_cmd_base cmd_base;
   GLenum pname;
   GLint param;
};
static inline void
_mesa_unmarshal_LightModeli(struct gl_context *ctx, const struct marshal_cmd_LightModeli *cmd)
{
   const GLenum pname = cmd->pname;
   const GLint param = cmd->param;
   CALL_LightModeli(ctx->CurrentServerDispatch, (pname, param));
}
static void GLAPIENTRY
_mesa_marshal_LightModeli(GLenum pname, GLint param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_LightModeli);
   struct marshal_cmd_LightModeli *cmd;
   debug_print_marshal("LightModeli");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_LightModeli, cmd_size);
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("LightModeli");
   CALL_LightModeli(ctx->CurrentServerDispatch, (pname, param));
}


/* UniformMatrix2fv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix2fv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 16) bytes are GLfloat value[count][4] */
};
static inline void
_mesa_unmarshal_UniformMatrix2fv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix2fv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 16;
   CALL_UniformMatrix2fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix2fv) + safe_mul(count, 16);
   struct marshal_cmd_UniformMatrix2fv *cmd;
   debug_print_marshal("UniformMatrix2fv");
   if (unlikely(safe_mul(count, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix2fv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 16);
      variable_data += count * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix2fv");
   CALL_UniformMatrix2fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* LightModelf: marshalled asynchronously */
struct marshal_cmd_LightModelf
{
   struct marshal_cmd_base cmd_base;
   GLenum pname;
   GLfloat param;
};
static inline void
_mesa_unmarshal_LightModelf(struct gl_context *ctx, const struct marshal_cmd_LightModelf *cmd)
{
   const GLenum pname = cmd->pname;
   const GLfloat param = cmd->param;
   CALL_LightModelf(ctx->CurrentServerDispatch, (pname, param));
}
static void GLAPIENTRY
_mesa_marshal_LightModelf(GLenum pname, GLfloat param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_LightModelf);
   struct marshal_cmd_LightModelf *cmd;
   debug_print_marshal("LightModelf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_LightModelf, cmd_size);
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("LightModelf");
   CALL_LightModelf(ctx->CurrentServerDispatch, (pname, param));
}


/* GetTexParameterfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTexParameterfv(GLenum target, GLenum pname, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTexParameterfv");
   CALL_GetTexParameterfv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* TextureStorage1D: marshalled asynchronously */
struct marshal_cmd_TextureStorage1D
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLsizei levels;
   GLenum internalformat;
   GLsizei width;
};
static inline void
_mesa_unmarshal_TextureStorage1D(struct gl_context *ctx, const struct marshal_cmd_TextureStorage1D *cmd)
{
   const GLuint texture = cmd->texture;
   const GLsizei levels = cmd->levels;
   const GLenum internalformat = cmd->internalformat;
   const GLsizei width = cmd->width;
   CALL_TextureStorage1D(ctx->CurrentServerDispatch, (texture, levels, internalformat, width));
}
static void GLAPIENTRY
_mesa_marshal_TextureStorage1D(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureStorage1D);
   struct marshal_cmd_TextureStorage1D *cmd;
   debug_print_marshal("TextureStorage1D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureStorage1D, cmd_size);
      cmd->texture = texture;
      cmd->levels = levels;
      cmd->internalformat = internalformat;
      cmd->width = width;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureStorage1D");
   CALL_TextureStorage1D(ctx->CurrentServerDispatch, (texture, levels, internalformat, width));
}


/* MultiTexCoord2fvARB: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord2fvARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLfloat v[2];
};
static inline void
_mesa_unmarshal_MultiTexCoord2fvARB(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord2fvARB *cmd)
{
   const GLenum target = cmd->target;
   const GLfloat * v = cmd->v;
   CALL_MultiTexCoord2fvARB(ctx->CurrentServerDispatch, (target, v));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord2fvARB(GLenum target, const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord2fvARB);
   struct marshal_cmd_MultiTexCoord2fvARB *cmd;
   debug_print_marshal("MultiTexCoord2fvARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord2fvARB, cmd_size);
      cmd->target = target;
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord2fvARB");
   CALL_MultiTexCoord2fvARB(ctx->CurrentServerDispatch, (target, v));
}


/* VertexAttrib4ubv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4ubv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLubyte v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4ubv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4ubv *cmd)
{
   const GLuint index = cmd->index;
   const GLubyte * v = cmd->v;
   CALL_VertexAttrib4ubv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4ubv(GLuint index, const GLubyte * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4ubv);
   struct marshal_cmd_VertexAttrib4ubv *cmd;
   debug_print_marshal("VertexAttrib4ubv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4ubv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4ubv");
   CALL_VertexAttrib4ubv(ctx->CurrentServerDispatch, (index, v));
}


/* GetnTexImageARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnTexImageARB(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, GLvoid * img)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnTexImageARB");
   CALL_GetnTexImageARB(ctx->CurrentServerDispatch, (target, level, format, type, bufSize, img));
}


/* ColorMask: marshalled asynchronously */
struct marshal_cmd_ColorMask
{
   struct marshal_cmd_base cmd_base;
   GLboolean red;
   GLboolean green;
   GLboolean blue;
   GLboolean alpha;
};
static inline void
_mesa_unmarshal_ColorMask(struct gl_context *ctx, const struct marshal_cmd_ColorMask *cmd)
{
   const GLboolean red = cmd->red;
   const GLboolean green = cmd->green;
   const GLboolean blue = cmd->blue;
   const GLboolean alpha = cmd->alpha;
   CALL_ColorMask(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}
static void GLAPIENTRY
_mesa_marshal_ColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ColorMask);
   struct marshal_cmd_ColorMask *cmd;
   debug_print_marshal("ColorMask");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ColorMask, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      cmd->alpha = alpha;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ColorMask");
   CALL_ColorMask(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}


/* MultiTexCoord4x: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord4x
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLfixed s;
   GLfixed t;
   GLfixed r;
   GLfixed q;
};
static inline void
_mesa_unmarshal_MultiTexCoord4x(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord4x *cmd)
{
   const GLenum target = cmd->target;
   const GLfixed s = cmd->s;
   const GLfixed t = cmd->t;
   const GLfixed r = cmd->r;
   const GLfixed q = cmd->q;
   CALL_MultiTexCoord4x(ctx->CurrentServerDispatch, (target, s, t, r, q));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord4x(GLenum target, GLfixed s, GLfixed t, GLfixed r, GLfixed q)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord4x);
   struct marshal_cmd_MultiTexCoord4x *cmd;
   debug_print_marshal("MultiTexCoord4x");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord4x, cmd_size);
      cmd->target = target;
      cmd->s = s;
      cmd->t = t;
      cmd->r = r;
      cmd->q = q;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord4x");
   CALL_MultiTexCoord4x(ctx->CurrentServerDispatch, (target, s, t, r, q));
}


/* UniformHandleui64ARB: marshalled asynchronously */
struct marshal_cmd_UniformHandleui64ARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLuint64 value;
};
static inline void
_mesa_unmarshal_UniformHandleui64ARB(struct gl_context *ctx, const struct marshal_cmd_UniformHandleui64ARB *cmd)
{
   const GLint location = cmd->location;
   const GLuint64 value = cmd->value;
   CALL_UniformHandleui64ARB(ctx->CurrentServerDispatch, (location, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformHandleui64ARB(GLint location, GLuint64 value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformHandleui64ARB);
   struct marshal_cmd_UniformHandleui64ARB *cmd;
   debug_print_marshal("UniformHandleui64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformHandleui64ARB, cmd_size);
      cmd->location = location;
      cmd->value = value;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformHandleui64ARB");
   CALL_UniformHandleui64ARB(ctx->CurrentServerDispatch, (location, value));
}


/* VertexAttribs4svNV: marshalled asynchronously */
struct marshal_cmd_VertexAttribs4svNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLsizei n;
   /* Next safe_mul(n, 8) bytes are GLshort v[n][4] */
};
static inline void
_mesa_unmarshal_VertexAttribs4svNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttribs4svNV *cmd)
{
   const GLuint index = cmd->index;
   const GLsizei n = cmd->n;
   const GLshort * v;
   const char *variable_data = (const char *) (cmd + 1);
   v = (const GLshort *) variable_data;
   variable_data += n * 8;
   CALL_VertexAttribs4svNV(ctx->CurrentServerDispatch, (index, n, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribs4svNV(GLuint index, GLsizei n, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribs4svNV) + safe_mul(n, 8);
   struct marshal_cmd_VertexAttribs4svNV *cmd;
   debug_print_marshal("VertexAttribs4svNV");
   if (unlikely(safe_mul(n, 8) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribs4svNV, cmd_size);
      cmd->index = index;
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, v, n * 8);
      variable_data += n * 8;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribs4svNV");
   CALL_VertexAttribs4svNV(ctx->CurrentServerDispatch, (index, n, v));
}


/* DrawElementsInstancedBaseInstance: marshalled asynchronously */
struct marshal_cmd_DrawElementsInstancedBaseInstance
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
   GLsizei count;
   GLenum type;
   const GLvoid * indices;
   GLsizei primcount;
   GLuint baseinstance;
};
static inline void
_mesa_unmarshal_DrawElementsInstancedBaseInstance(struct gl_context *ctx, const struct marshal_cmd_DrawElementsInstancedBaseInstance *cmd)
{
   const GLenum mode = cmd->mode;
   const GLsizei count = cmd->count;
   const GLenum type = cmd->type;
   const GLvoid * indices = cmd->indices;
   const GLsizei primcount = cmd->primcount;
   const GLuint baseinstance = cmd->baseinstance;
   CALL_DrawElementsInstancedBaseInstance(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount, baseinstance));
}
static void GLAPIENTRY
_mesa_marshal_DrawElementsInstancedBaseInstance(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei primcount, GLuint baseinstance)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawElementsInstancedBaseInstance);
   struct marshal_cmd_DrawElementsInstancedBaseInstance *cmd;
   debug_print_marshal("DrawElementsInstancedBaseInstance");
   if (_mesa_glthread_is_non_vbo_draw_elements(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("DrawElementsInstancedBaseInstance");
      CALL_DrawElementsInstancedBaseInstance(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount, baseinstance));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawElementsInstancedBaseInstance, cmd_size);
      cmd->mode = mode;
      cmd->count = count;
      cmd->type = type;
      cmd->indices = indices;
      cmd->primcount = primcount;
      cmd->baseinstance = baseinstance;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawElementsInstancedBaseInstance");
   CALL_DrawElementsInstancedBaseInstance(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount, baseinstance));
}


/* UniformMatrix4fv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix4fv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 64) bytes are GLfloat value[count][16] */
};
static inline void
_mesa_unmarshal_UniformMatrix4fv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix4fv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 64;
   CALL_UniformMatrix4fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix4fv) + safe_mul(count, 64);
   struct marshal_cmd_UniformMatrix4fv *cmd;
   debug_print_marshal("UniformMatrix4fv");
   if (unlikely(safe_mul(count, 64) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix4fv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 64);
      variable_data += count * 64;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix4fv");
   CALL_UniformMatrix4fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* UniformMatrix3x2fv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix3x2fv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 24) bytes are GLfloat value[count][6] */
};
static inline void
_mesa_unmarshal_UniformMatrix3x2fv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix3x2fv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 24;
   CALL_UniformMatrix3x2fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix3x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix3x2fv) + safe_mul(count, 24);
   struct marshal_cmd_UniformMatrix3x2fv *cmd;
   debug_print_marshal("UniformMatrix3x2fv");
   if (unlikely(safe_mul(count, 24) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix3x2fv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 24);
      variable_data += count * 24;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix3x2fv");
   CALL_UniformMatrix3x2fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* VertexAttrib4Nuiv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4Nuiv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLuint v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4Nuiv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4Nuiv *cmd)
{
   const GLuint index = cmd->index;
   const GLuint * v = cmd->v;
   CALL_VertexAttrib4Nuiv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4Nuiv(GLuint index, const GLuint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4Nuiv);
   struct marshal_cmd_VertexAttrib4Nuiv *cmd;
   debug_print_marshal("VertexAttrib4Nuiv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4Nuiv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4Nuiv");
   CALL_VertexAttrib4Nuiv(ctx->CurrentServerDispatch, (index, v));
}


/* ClientActiveTexture: marshalled asynchronously */
struct marshal_cmd_ClientActiveTexture
{
   struct marshal_cmd_base cmd_base;
   GLenum texture;
};
static inline void
_mesa_unmarshal_ClientActiveTexture(struct gl_context *ctx, const struct marshal_cmd_ClientActiveTexture *cmd)
{
   const GLenum texture = cmd->texture;
   CALL_ClientActiveTexture(ctx->CurrentServerDispatch, (texture));
}
static void GLAPIENTRY
_mesa_marshal_ClientActiveTexture(GLenum texture)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClientActiveTexture);
   struct marshal_cmd_ClientActiveTexture *cmd;
   debug_print_marshal("ClientActiveTexture");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClientActiveTexture, cmd_size);
      cmd->texture = texture;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClientActiveTexture");
   CALL_ClientActiveTexture(ctx->CurrentServerDispatch, (texture));
}


/* GetUniformIndices: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetUniformIndices(GLuint program, GLsizei uniformCount, const GLchar * const * uniformNames, GLuint * uniformIndices)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetUniformIndices");
   CALL_GetUniformIndices(ctx->CurrentServerDispatch, (program, uniformCount, uniformNames, uniformIndices));
}


/* MultiTexCoord2sv: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord2sv
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLshort v[2];
};
static inline void
_mesa_unmarshal_MultiTexCoord2sv(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord2sv *cmd)
{
   const GLenum target = cmd->target;
   const GLshort * v = cmd->v;
   CALL_MultiTexCoord2sv(ctx->CurrentServerDispatch, (target, v));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord2sv(GLenum target, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord2sv);
   struct marshal_cmd_MultiTexCoord2sv *cmd;
   debug_print_marshal("MultiTexCoord2sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord2sv, cmd_size);
      cmd->target = target;
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord2sv");
   CALL_MultiTexCoord2sv(ctx->CurrentServerDispatch, (target, v));
}


/* NamedBufferStorage: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_NamedBufferStorage(GLuint buffer, GLsizeiptr size, const GLvoid * data, GLbitfield flags)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("NamedBufferStorage");
   CALL_NamedBufferStorage(ctx->CurrentServerDispatch, (buffer, size, data, flags));
}


/* NamedFramebufferDrawBuffer: marshalled asynchronously */
struct marshal_cmd_NamedFramebufferDrawBuffer
{
   struct marshal_cmd_base cmd_base;
   GLuint framebuffer;
   GLenum buf;
};
static inline void
_mesa_unmarshal_NamedFramebufferDrawBuffer(struct gl_context *ctx, const struct marshal_cmd_NamedFramebufferDrawBuffer *cmd)
{
   const GLuint framebuffer = cmd->framebuffer;
   const GLenum buf = cmd->buf;
   CALL_NamedFramebufferDrawBuffer(ctx->CurrentServerDispatch, (framebuffer, buf));
}
static void GLAPIENTRY
_mesa_marshal_NamedFramebufferDrawBuffer(GLuint framebuffer, GLenum buf)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_NamedFramebufferDrawBuffer);
   struct marshal_cmd_NamedFramebufferDrawBuffer *cmd;
   debug_print_marshal("NamedFramebufferDrawBuffer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_NamedFramebufferDrawBuffer, cmd_size);
      cmd->framebuffer = framebuffer;
      cmd->buf = buf;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("NamedFramebufferDrawBuffer");
   CALL_NamedFramebufferDrawBuffer(ctx->CurrentServerDispatch, (framebuffer, buf));
}


/* NamedFramebufferTextureLayer: marshalled asynchronously */
struct marshal_cmd_NamedFramebufferTextureLayer
{
   struct marshal_cmd_base cmd_base;
   GLuint framebuffer;
   GLenum attachment;
   GLuint texture;
   GLint level;
   GLint layer;
};
static inline void
_mesa_unmarshal_NamedFramebufferTextureLayer(struct gl_context *ctx, const struct marshal_cmd_NamedFramebufferTextureLayer *cmd)
{
   const GLuint framebuffer = cmd->framebuffer;
   const GLenum attachment = cmd->attachment;
   const GLuint texture = cmd->texture;
   const GLint level = cmd->level;
   const GLint layer = cmd->layer;
   CALL_NamedFramebufferTextureLayer(ctx->CurrentServerDispatch, (framebuffer, attachment, texture, level, layer));
}
static void GLAPIENTRY
_mesa_marshal_NamedFramebufferTextureLayer(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_NamedFramebufferTextureLayer);
   struct marshal_cmd_NamedFramebufferTextureLayer *cmd;
   debug_print_marshal("NamedFramebufferTextureLayer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_NamedFramebufferTextureLayer, cmd_size);
      cmd->framebuffer = framebuffer;
      cmd->attachment = attachment;
      cmd->texture = texture;
      cmd->level = level;
      cmd->layer = layer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("NamedFramebufferTextureLayer");
   CALL_NamedFramebufferTextureLayer(ctx->CurrentServerDispatch, (framebuffer, attachment, texture, level, layer));
}


/* LoadIdentity: marshalled asynchronously */
struct marshal_cmd_LoadIdentity
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_LoadIdentity(struct gl_context *ctx, const struct marshal_cmd_LoadIdentity *cmd)
{
   CALL_LoadIdentity(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_LoadIdentity(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_LoadIdentity);
   struct marshal_cmd_LoadIdentity *cmd;
   debug_print_marshal("LoadIdentity");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_LoadIdentity, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("LoadIdentity");
   CALL_LoadIdentity(ctx->CurrentServerDispatch, ());
}


/* ActiveShaderProgram: marshalled asynchronously */
struct marshal_cmd_ActiveShaderProgram
{
   struct marshal_cmd_base cmd_base;
   GLuint pipeline;
   GLuint program;
};
static inline void
_mesa_unmarshal_ActiveShaderProgram(struct gl_context *ctx, const struct marshal_cmd_ActiveShaderProgram *cmd)
{
   const GLuint pipeline = cmd->pipeline;
   const GLuint program = cmd->program;
   CALL_ActiveShaderProgram(ctx->CurrentServerDispatch, (pipeline, program));
}
static void GLAPIENTRY
_mesa_marshal_ActiveShaderProgram(GLuint pipeline, GLuint program)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ActiveShaderProgram);
   struct marshal_cmd_ActiveShaderProgram *cmd;
   debug_print_marshal("ActiveShaderProgram");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ActiveShaderProgram, cmd_size);
      cmd->pipeline = pipeline;
      cmd->program = program;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ActiveShaderProgram");
   CALL_ActiveShaderProgram(ctx->CurrentServerDispatch, (pipeline, program));
}


/* BindImageTextures: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_BindImageTextures(GLuint first, GLsizei count, const GLuint * textures)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("BindImageTextures");
   CALL_BindImageTextures(ctx->CurrentServerDispatch, (first, count, textures));
}


/* DeleteTransformFeedbacks: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_DeleteTransformFeedbacks(GLsizei n, const GLuint * ids)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("DeleteTransformFeedbacks");
   CALL_DeleteTransformFeedbacks(ctx->CurrentServerDispatch, (n, ids));
}


/* VertexAttrib4ubvNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4ubvNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLubyte v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4ubvNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4ubvNV *cmd)
{
   const GLuint index = cmd->index;
   const GLubyte * v = cmd->v;
   CALL_VertexAttrib4ubvNV(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4ubvNV(GLuint index, const GLubyte * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4ubvNV);
   struct marshal_cmd_VertexAttrib4ubvNV *cmd;
   debug_print_marshal("VertexAttrib4ubvNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4ubvNV, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4ubvNV");
   CALL_VertexAttrib4ubvNV(ctx->CurrentServerDispatch, (index, v));
}


/* FogCoordfEXT: marshalled asynchronously */
struct marshal_cmd_FogCoordfEXT
{
   struct marshal_cmd_base cmd_base;
   GLfloat coord;
};
static inline void
_mesa_unmarshal_FogCoordfEXT(struct gl_context *ctx, const struct marshal_cmd_FogCoordfEXT *cmd)
{
   const GLfloat coord = cmd->coord;
   CALL_FogCoordfEXT(ctx->CurrentServerDispatch, (coord));
}
static void GLAPIENTRY
_mesa_marshal_FogCoordfEXT(GLfloat coord)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_FogCoordfEXT);
   struct marshal_cmd_FogCoordfEXT *cmd;
   debug_print_marshal("FogCoordfEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_FogCoordfEXT, cmd_size);
      cmd->coord = coord;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("FogCoordfEXT");
   CALL_FogCoordfEXT(ctx->CurrentServerDispatch, (coord));
}


/* GetMapfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetMapfv(GLenum target, GLenum query, GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetMapfv");
   CALL_GetMapfv(ctx->CurrentServerDispatch, (target, query, v));
}


/* GetProgramInfoLog: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei * length, GLchar * infoLog)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramInfoLog");
   CALL_GetProgramInfoLog(ctx->CurrentServerDispatch, (program, bufSize, length, infoLog));
}


/* BindTransformFeedback: marshalled asynchronously */
struct marshal_cmd_BindTransformFeedback
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint id;
};
static inline void
_mesa_unmarshal_BindTransformFeedback(struct gl_context *ctx, const struct marshal_cmd_BindTransformFeedback *cmd)
{
   const GLenum target = cmd->target;
   const GLuint id = cmd->id;
   CALL_BindTransformFeedback(ctx->CurrentServerDispatch, (target, id));
}
static void GLAPIENTRY
_mesa_marshal_BindTransformFeedback(GLenum target, GLuint id)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindTransformFeedback);
   struct marshal_cmd_BindTransformFeedback *cmd;
   debug_print_marshal("BindTransformFeedback");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindTransformFeedback, cmd_size);
      cmd->target = target;
      cmd->id = id;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindTransformFeedback");
   CALL_BindTransformFeedback(ctx->CurrentServerDispatch, (target, id));
}


/* GetPixelMapfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetPixelMapfv(GLenum map, GLfloat * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetPixelMapfv");
   CALL_GetPixelMapfv(ctx->CurrentServerDispatch, (map, values));
}


/* TextureBufferRange: marshalled asynchronously */
struct marshal_cmd_TextureBufferRange
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLenum internalformat;
   GLuint buffer;
   GLintptr offset;
   GLsizeiptr size;
};
static inline void
_mesa_unmarshal_TextureBufferRange(struct gl_context *ctx, const struct marshal_cmd_TextureBufferRange *cmd)
{
   const GLuint texture = cmd->texture;
   const GLenum internalformat = cmd->internalformat;
   const GLuint buffer = cmd->buffer;
   const GLintptr offset = cmd->offset;
   const GLsizeiptr size = cmd->size;
   CALL_TextureBufferRange(ctx->CurrentServerDispatch, (texture, internalformat, buffer, offset, size));
}
static void GLAPIENTRY
_mesa_marshal_TextureBufferRange(GLuint texture, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureBufferRange);
   struct marshal_cmd_TextureBufferRange *cmd;
   debug_print_marshal("TextureBufferRange");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureBufferRange, cmd_size);
      cmd->texture = texture;
      cmd->internalformat = internalformat;
      cmd->buffer = buffer;
      cmd->offset = offset;
      cmd->size = size;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureBufferRange");
   CALL_TextureBufferRange(ctx->CurrentServerDispatch, (texture, internalformat, buffer, offset, size));
}


/* VertexAttrib4svNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4svNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4svNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4svNV *cmd)
{
   const GLuint index = cmd->index;
   const GLshort * v = cmd->v;
   CALL_VertexAttrib4svNV(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4svNV(GLuint index, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4svNV);
   struct marshal_cmd_VertexAttrib4svNV *cmd;
   debug_print_marshal("VertexAttrib4svNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4svNV, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4svNV");
   CALL_VertexAttrib4svNV(ctx->CurrentServerDispatch, (index, v));
}


/* PatchParameteri: marshalled asynchronously */
struct marshal_cmd_PatchParameteri
{
   struct marshal_cmd_base cmd_base;
   GLenum pname;
   GLint value;
};
static inline void
_mesa_unmarshal_PatchParameteri(struct gl_context *ctx, const struct marshal_cmd_PatchParameteri *cmd)
{
   const GLenum pname = cmd->pname;
   const GLint value = cmd->value;
   CALL_PatchParameteri(ctx->CurrentServerDispatch, (pname, value));
}
static void GLAPIENTRY
_mesa_marshal_PatchParameteri(GLenum pname, GLint value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PatchParameteri);
   struct marshal_cmd_PatchParameteri *cmd;
   debug_print_marshal("PatchParameteri");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PatchParameteri, cmd_size);
      cmd->pname = pname;
      cmd->value = value;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PatchParameteri");
   CALL_PatchParameteri(ctx->CurrentServerDispatch, (pname, value));
}


/* GetNamedBufferSubData: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetNamedBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr size, GLvoid * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetNamedBufferSubData");
   CALL_GetNamedBufferSubData(ctx->CurrentServerDispatch, (buffer, offset, size, data));
}


/* VDPAUSurfaceAccessNV: marshalled asynchronously */
struct marshal_cmd_VDPAUSurfaceAccessNV
{
   struct marshal_cmd_base cmd_base;
   GLintptr surface;
   GLenum access;
};
static inline void
_mesa_unmarshal_VDPAUSurfaceAccessNV(struct gl_context *ctx, const struct marshal_cmd_VDPAUSurfaceAccessNV *cmd)
{
   const GLintptr surface = cmd->surface;
   const GLenum access = cmd->access;
   CALL_VDPAUSurfaceAccessNV(ctx->CurrentServerDispatch, (surface, access));
}
static void GLAPIENTRY
_mesa_marshal_VDPAUSurfaceAccessNV(GLintptr surface, GLenum access)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VDPAUSurfaceAccessNV);
   struct marshal_cmd_VDPAUSurfaceAccessNV *cmd;
   debug_print_marshal("VDPAUSurfaceAccessNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VDPAUSurfaceAccessNV, cmd_size);
      cmd->surface = surface;
      cmd->access = access;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VDPAUSurfaceAccessNV");
   CALL_VDPAUSurfaceAccessNV(ctx->CurrentServerDispatch, (surface, access));
}


/* EdgeFlagPointer: marshalled asynchronously */
struct marshal_cmd_EdgeFlagPointer
{
   struct marshal_cmd_base cmd_base;
   GLsizei stride;
   const GLvoid * pointer;
};
static inline void
_mesa_unmarshal_EdgeFlagPointer(struct gl_context *ctx, const struct marshal_cmd_EdgeFlagPointer *cmd)
{
   const GLsizei stride = cmd->stride;
   const GLvoid * pointer = cmd->pointer;
   CALL_EdgeFlagPointer(ctx->CurrentServerDispatch, (stride, pointer));
}
static void GLAPIENTRY
_mesa_marshal_EdgeFlagPointer(GLsizei stride, const GLvoid * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EdgeFlagPointer);
   struct marshal_cmd_EdgeFlagPointer *cmd;
   debug_print_marshal("EdgeFlagPointer");
   if (_mesa_glthread_is_non_vbo_vertex_attrib_pointer(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("EdgeFlagPointer");
      CALL_EdgeFlagPointer(ctx->CurrentServerDispatch, (stride, pointer));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EdgeFlagPointer, cmd_size);
      cmd->stride = stride;
      cmd->pointer = pointer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EdgeFlagPointer");
   CALL_EdgeFlagPointer(ctx->CurrentServerDispatch, (stride, pointer));
}


/* WindowPos2f: marshalled asynchronously */
struct marshal_cmd_WindowPos2f
{
   struct marshal_cmd_base cmd_base;
   GLfloat x;
   GLfloat y;
};
static inline void
_mesa_unmarshal_WindowPos2f(struct gl_context *ctx, const struct marshal_cmd_WindowPos2f *cmd)
{
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   CALL_WindowPos2f(ctx->CurrentServerDispatch, (x, y));
}
static void GLAPIENTRY
_mesa_marshal_WindowPos2f(GLfloat x, GLfloat y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WindowPos2f);
   struct marshal_cmd_WindowPos2f *cmd;
   debug_print_marshal("WindowPos2f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WindowPos2f, cmd_size);
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WindowPos2f");
   CALL_WindowPos2f(ctx->CurrentServerDispatch, (x, y));
}


/* WindowPos2d: marshalled asynchronously */
struct marshal_cmd_WindowPos2d
{
   struct marshal_cmd_base cmd_base;
   GLdouble x;
   GLdouble y;
};
static inline void
_mesa_unmarshal_WindowPos2d(struct gl_context *ctx, const struct marshal_cmd_WindowPos2d *cmd)
{
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   CALL_WindowPos2d(ctx->CurrentServerDispatch, (x, y));
}
static void GLAPIENTRY
_mesa_marshal_WindowPos2d(GLdouble x, GLdouble y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WindowPos2d);
   struct marshal_cmd_WindowPos2d *cmd;
   debug_print_marshal("WindowPos2d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WindowPos2d, cmd_size);
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WindowPos2d");
   CALL_WindowPos2d(ctx->CurrentServerDispatch, (x, y));
}


/* GetVertexAttribLdv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetVertexAttribLdv(GLuint index, GLenum pname, GLdouble * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetVertexAttribLdv");
   CALL_GetVertexAttribLdv(ctx->CurrentServerDispatch, (index, pname, params));
}


/* WindowPos2i: marshalled asynchronously */
struct marshal_cmd_WindowPos2i
{
   struct marshal_cmd_base cmd_base;
   GLint x;
   GLint y;
};
static inline void
_mesa_unmarshal_WindowPos2i(struct gl_context *ctx, const struct marshal_cmd_WindowPos2i *cmd)
{
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   CALL_WindowPos2i(ctx->CurrentServerDispatch, (x, y));
}
static void GLAPIENTRY
_mesa_marshal_WindowPos2i(GLint x, GLint y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WindowPos2i);
   struct marshal_cmd_WindowPos2i *cmd;
   debug_print_marshal("WindowPos2i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WindowPos2i, cmd_size);
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WindowPos2i");
   CALL_WindowPos2i(ctx->CurrentServerDispatch, (x, y));
}


/* WindowPos2s: marshalled asynchronously */
struct marshal_cmd_WindowPos2s
{
   struct marshal_cmd_base cmd_base;
   GLshort x;
   GLshort y;
};
static inline void
_mesa_unmarshal_WindowPos2s(struct gl_context *ctx, const struct marshal_cmd_WindowPos2s *cmd)
{
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   CALL_WindowPos2s(ctx->CurrentServerDispatch, (x, y));
}
static void GLAPIENTRY
_mesa_marshal_WindowPos2s(GLshort x, GLshort y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WindowPos2s);
   struct marshal_cmd_WindowPos2s *cmd;
   debug_print_marshal("WindowPos2s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WindowPos2s, cmd_size);
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WindowPos2s");
   CALL_WindowPos2s(ctx->CurrentServerDispatch, (x, y));
}


/* VertexAttribI1uiEXT: marshalled asynchronously */
struct marshal_cmd_VertexAttribI1uiEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLuint x;
};
static inline void
_mesa_unmarshal_VertexAttribI1uiEXT(struct gl_context *ctx, const struct marshal_cmd_VertexAttribI1uiEXT *cmd)
{
   const GLuint index = cmd->index;
   const GLuint x = cmd->x;
   CALL_VertexAttribI1uiEXT(ctx->CurrentServerDispatch, (index, x));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribI1uiEXT(GLuint index, GLuint x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribI1uiEXT);
   struct marshal_cmd_VertexAttribI1uiEXT *cmd;
   debug_print_marshal("VertexAttribI1uiEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribI1uiEXT, cmd_size);
      cmd->index = index;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribI1uiEXT");
   CALL_VertexAttribI1uiEXT(ctx->CurrentServerDispatch, (index, x));
}


/* DeleteSync: marshalled asynchronously */
struct marshal_cmd_DeleteSync
{
   struct marshal_cmd_base cmd_base;
   GLsync sync;
};
static inline void
_mesa_unmarshal_DeleteSync(struct gl_context *ctx, const struct marshal_cmd_DeleteSync *cmd)
{
   const GLsync sync = cmd->sync;
   CALL_DeleteSync(ctx->CurrentServerDispatch, (sync));
}
static void GLAPIENTRY
_mesa_marshal_DeleteSync(GLsync sync)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DeleteSync);
   struct marshal_cmd_DeleteSync *cmd;
   debug_print_marshal("DeleteSync");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DeleteSync, cmd_size);
      cmd->sync = sync;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DeleteSync");
   CALL_DeleteSync(ctx->CurrentServerDispatch, (sync));
}


/* WindowPos4fvMESA: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_WindowPos4fvMESA(const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("WindowPos4fvMESA");
   CALL_WindowPos4fvMESA(ctx->CurrentServerDispatch, (v));
}


/* CompressedTexImage3D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CompressedTexImage3D");
   CALL_CompressedTexImage3D(ctx->CurrentServerDispatch, (target, level, internalformat, width, height, depth, border, imageSize, data));
}


/* GenSemaphoresEXT: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GenSemaphoresEXT(GLsizei n, GLuint * semaphores)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GenSemaphoresEXT");
   CALL_GenSemaphoresEXT(ctx->CurrentServerDispatch, (n, semaphores));
}


/* VertexAttribI1uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribI1uiv(GLuint index, const GLuint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribI1uiv");
   CALL_VertexAttribI1uiv(ctx->CurrentServerDispatch, (index, v));
}


/* SecondaryColor3dv: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v[3];
};
static inline void
_mesa_unmarshal_SecondaryColor3dv(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3dv *cmd)
{
   const GLdouble * v = cmd->v;
   CALL_SecondaryColor3dv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3dv);
   struct marshal_cmd_SecondaryColor3dv *cmd;
   debug_print_marshal("SecondaryColor3dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3dv, cmd_size);
      memcpy(cmd->v, v, 24);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3dv");
   CALL_SecondaryColor3dv(ctx->CurrentServerDispatch, (v));
}


/* GetnPixelMapusvARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnPixelMapusvARB(GLenum map, GLsizei bufSize, GLushort * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnPixelMapusvARB");
   CALL_GetnPixelMapusvARB(ctx->CurrentServerDispatch, (map, bufSize, values));
}


/* VertexAttrib3s: marshalled asynchronously */
struct marshal_cmd_VertexAttrib3s
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort x;
   GLshort y;
   GLshort z;
};
static inline void
_mesa_unmarshal_VertexAttrib3s(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib3s *cmd)
{
   const GLuint index = cmd->index;
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   const GLshort z = cmd->z;
   CALL_VertexAttrib3s(ctx->CurrentServerDispatch, (index, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib3s(GLuint index, GLshort x, GLshort y, GLshort z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib3s);
   struct marshal_cmd_VertexAttrib3s *cmd;
   debug_print_marshal("VertexAttrib3s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib3s, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib3s");
   CALL_VertexAttrib3s(ctx->CurrentServerDispatch, (index, x, y, z));
}


/* UniformMatrix4x3fv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix4x3fv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 48) bytes are GLfloat value[count][12] */
};
static inline void
_mesa_unmarshal_UniformMatrix4x3fv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix4x3fv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 48;
   CALL_UniformMatrix4x3fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix4x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix4x3fv) + safe_mul(count, 48);
   struct marshal_cmd_UniformMatrix4x3fv *cmd;
   debug_print_marshal("UniformMatrix4x3fv");
   if (unlikely(safe_mul(count, 48) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix4x3fv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 48);
      variable_data += count * 48;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix4x3fv");
   CALL_UniformMatrix4x3fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* GetQueryiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetQueryiv(GLenum target, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetQueryiv");
   CALL_GetQueryiv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* VertexAttrib3d: marshalled asynchronously */
struct marshal_cmd_VertexAttrib3d
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble x;
   GLdouble y;
   GLdouble z;
};
static inline void
_mesa_unmarshal_VertexAttrib3d(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib3d *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   CALL_VertexAttrib3d(ctx->CurrentServerDispatch, (index, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib3d(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib3d);
   struct marshal_cmd_VertexAttrib3d *cmd;
   debug_print_marshal("VertexAttrib3d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib3d, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib3d");
   CALL_VertexAttrib3d(ctx->CurrentServerDispatch, (index, x, y, z));
}


/* MapNamedBufferRange: marshalled synchronously */
static GLvoid * GLAPIENTRY
_mesa_marshal_MapNamedBufferRange(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MapNamedBufferRange");
   return CALL_MapNamedBufferRange(ctx->CurrentServerDispatch, (buffer, offset, length, access));
}


/* MapBuffer: marshalled synchronously */
static GLvoid * GLAPIENTRY
_mesa_marshal_MapBuffer(GLenum target, GLenum access)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MapBuffer");
   return CALL_MapBuffer(ctx->CurrentServerDispatch, (target, access));
}


/* GetProgramStageiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetProgramStageiv(GLuint program, GLenum shadertype, GLenum pname, GLint * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramStageiv");
   CALL_GetProgramStageiv(ctx->CurrentServerDispatch, (program, shadertype, pname, values));
}


/* VertexAttrib4Nbv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4Nbv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLbyte v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4Nbv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4Nbv *cmd)
{
   const GLuint index = cmd->index;
   const GLbyte * v = cmd->v;
   CALL_VertexAttrib4Nbv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4Nbv(GLuint index, const GLbyte * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4Nbv);
   struct marshal_cmd_VertexAttrib4Nbv *cmd;
   debug_print_marshal("VertexAttrib4Nbv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4Nbv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4Nbv");
   CALL_VertexAttrib4Nbv(ctx->CurrentServerDispatch, (index, v));
}


/* ProgramBinary: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ProgramBinary(GLuint program, GLenum binaryFormat, const GLvoid * binary, GLsizei length)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ProgramBinary");
   CALL_ProgramBinary(ctx->CurrentServerDispatch, (program, binaryFormat, binary, length));
}


/* InvalidateTexImage: marshalled asynchronously */
struct marshal_cmd_InvalidateTexImage
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLint level;
};
static inline void
_mesa_unmarshal_InvalidateTexImage(struct gl_context *ctx, const struct marshal_cmd_InvalidateTexImage *cmd)
{
   const GLuint texture = cmd->texture;
   const GLint level = cmd->level;
   CALL_InvalidateTexImage(ctx->CurrentServerDispatch, (texture, level));
}
static void GLAPIENTRY
_mesa_marshal_InvalidateTexImage(GLuint texture, GLint level)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_InvalidateTexImage);
   struct marshal_cmd_InvalidateTexImage *cmd;
   debug_print_marshal("InvalidateTexImage");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_InvalidateTexImage, cmd_size);
      cmd->texture = texture;
      cmd->level = level;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("InvalidateTexImage");
   CALL_InvalidateTexImage(ctx->CurrentServerDispatch, (texture, level));
}


/* Uniform4ui: marshalled asynchronously */
struct marshal_cmd_Uniform4ui
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLuint x;
   GLuint y;
   GLuint z;
   GLuint w;
};
static inline void
_mesa_unmarshal_Uniform4ui(struct gl_context *ctx, const struct marshal_cmd_Uniform4ui *cmd)
{
   const GLint location = cmd->location;
   const GLuint x = cmd->x;
   const GLuint y = cmd->y;
   const GLuint z = cmd->z;
   const GLuint w = cmd->w;
   CALL_Uniform4ui(ctx->CurrentServerDispatch, (location, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_Uniform4ui(GLint location, GLuint x, GLuint y, GLuint z, GLuint w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform4ui);
   struct marshal_cmd_Uniform4ui *cmd;
   debug_print_marshal("Uniform4ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform4ui, cmd_size);
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform4ui");
   CALL_Uniform4ui(ctx->CurrentServerDispatch, (location, x, y, z, w));
}


/* VertexArrayAttribFormat: marshalled asynchronously */
struct marshal_cmd_VertexArrayAttribFormat
{
   struct marshal_cmd_base cmd_base;
   GLuint vaobj;
   GLuint attribindex;
   GLint size;
   GLenum type;
   GLboolean normalized;
   GLuint relativeoffset;
};
static inline void
_mesa_unmarshal_VertexArrayAttribFormat(struct gl_context *ctx, const struct marshal_cmd_VertexArrayAttribFormat *cmd)
{
   const GLuint vaobj = cmd->vaobj;
   const GLuint attribindex = cmd->attribindex;
   const GLint size = cmd->size;
   const GLenum type = cmd->type;
   const GLboolean normalized = cmd->normalized;
   const GLuint relativeoffset = cmd->relativeoffset;
   CALL_VertexArrayAttribFormat(ctx->CurrentServerDispatch, (vaobj, attribindex, size, type, normalized, relativeoffset));
}
static void GLAPIENTRY
_mesa_marshal_VertexArrayAttribFormat(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexArrayAttribFormat);
   struct marshal_cmd_VertexArrayAttribFormat *cmd;
   debug_print_marshal("VertexArrayAttribFormat");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexArrayAttribFormat, cmd_size);
      cmd->vaobj = vaobj;
      cmd->attribindex = attribindex;
      cmd->size = size;
      cmd->type = type;
      cmd->normalized = normalized;
      cmd->relativeoffset = relativeoffset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexArrayAttribFormat");
   CALL_VertexArrayAttribFormat(ctx->CurrentServerDispatch, (vaobj, attribindex, size, type, normalized, relativeoffset));
}


/* VertexAttrib1fARB: marshalled asynchronously */
struct marshal_cmd_VertexAttrib1fARB
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat x;
};
static inline void
_mesa_unmarshal_VertexAttrib1fARB(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib1fARB *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat x = cmd->x;
   CALL_VertexAttrib1fARB(ctx->CurrentServerDispatch, (index, x));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib1fARB(GLuint index, GLfloat x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib1fARB);
   struct marshal_cmd_VertexAttrib1fARB *cmd;
   debug_print_marshal("VertexAttrib1fARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib1fARB, cmd_size);
      cmd->index = index;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib1fARB");
   CALL_VertexAttrib1fARB(ctx->CurrentServerDispatch, (index, x));
}


/* GetBooleani_v: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetBooleani_v(GLenum value, GLuint index, GLboolean * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetBooleani_v");
   CALL_GetBooleani_v(ctx->CurrentServerDispatch, (value, index, data));
}


/* DrawTexsOES: marshalled asynchronously */
struct marshal_cmd_DrawTexsOES
{
   struct marshal_cmd_base cmd_base;
   GLshort x;
   GLshort y;
   GLshort z;
   GLshort width;
   GLshort height;
};
static inline void
_mesa_unmarshal_DrawTexsOES(struct gl_context *ctx, const struct marshal_cmd_DrawTexsOES *cmd)
{
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   const GLshort z = cmd->z;
   const GLshort width = cmd->width;
   const GLshort height = cmd->height;
   CALL_DrawTexsOES(ctx->CurrentServerDispatch, (x, y, z, width, height));
}
static void GLAPIENTRY
_mesa_marshal_DrawTexsOES(GLshort x, GLshort y, GLshort z, GLshort width, GLshort height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawTexsOES);
   struct marshal_cmd_DrawTexsOES *cmd;
   debug_print_marshal("DrawTexsOES");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawTexsOES, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->width = width;
      cmd->height = height;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawTexsOES");
   CALL_DrawTexsOES(ctx->CurrentServerDispatch, (x, y, z, width, height));
}


/* GetObjectPtrLabel: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetObjectPtrLabel(const GLvoid * ptr, GLsizei bufSize, GLsizei * length, GLchar * label)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetObjectPtrLabel");
   CALL_GetObjectPtrLabel(ctx->CurrentServerDispatch, (ptr, bufSize, length, label));
}


/* ProgramParameteri: marshalled asynchronously */
struct marshal_cmd_ProgramParameteri
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLenum pname;
   GLint value;
};
static inline void
_mesa_unmarshal_ProgramParameteri(struct gl_context *ctx, const struct marshal_cmd_ProgramParameteri *cmd)
{
   const GLuint program = cmd->program;
   const GLenum pname = cmd->pname;
   const GLint value = cmd->value;
   CALL_ProgramParameteri(ctx->CurrentServerDispatch, (program, pname, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramParameteri(GLuint program, GLenum pname, GLint value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramParameteri);
   struct marshal_cmd_ProgramParameteri *cmd;
   debug_print_marshal("ProgramParameteri");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramParameteri, cmd_size);
      cmd->program = program;
      cmd->pname = pname;
      cmd->value = value;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramParameteri");
   CALL_ProgramParameteri(ctx->CurrentServerDispatch, (program, pname, value));
}


/* Color3fv: marshalled asynchronously */
struct marshal_cmd_Color3fv
{
   struct marshal_cmd_base cmd_base;
   GLfloat v[3];
};
static inline void
_mesa_unmarshal_Color3fv(struct gl_context *ctx, const struct marshal_cmd_Color3fv *cmd)
{
   const GLfloat * v = cmd->v;
   CALL_Color3fv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Color3fv(const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color3fv);
   struct marshal_cmd_Color3fv *cmd;
   debug_print_marshal("Color3fv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color3fv, cmd_size);
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color3fv");
   CALL_Color3fv(ctx->CurrentServerDispatch, (v));
}


/* GetnMapfvARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnMapfvARB(GLenum target, GLenum query, GLsizei bufSize, GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnMapfvARB");
   CALL_GetnMapfvARB(ctx->CurrentServerDispatch, (target, query, bufSize, v));
}


/* MultiTexCoord2i: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord2i
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLint s;
   GLint t;
};
static inline void
_mesa_unmarshal_MultiTexCoord2i(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord2i *cmd)
{
   const GLenum target = cmd->target;
   const GLint s = cmd->s;
   const GLint t = cmd->t;
   CALL_MultiTexCoord2i(ctx->CurrentServerDispatch, (target, s, t));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord2i(GLenum target, GLint s, GLint t)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord2i);
   struct marshal_cmd_MultiTexCoord2i *cmd;
   debug_print_marshal("MultiTexCoord2i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord2i, cmd_size);
      cmd->target = target;
      cmd->s = s;
      cmd->t = t;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord2i");
   CALL_MultiTexCoord2i(ctx->CurrentServerDispatch, (target, s, t));
}


/* MultiTexCoord2d: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord2d
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLdouble s;
   GLdouble t;
};
static inline void
_mesa_unmarshal_MultiTexCoord2d(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord2d *cmd)
{
   const GLenum target = cmd->target;
   const GLdouble s = cmd->s;
   const GLdouble t = cmd->t;
   CALL_MultiTexCoord2d(ctx->CurrentServerDispatch, (target, s, t));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord2d(GLenum target, GLdouble s, GLdouble t)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord2d);
   struct marshal_cmd_MultiTexCoord2d *cmd;
   debug_print_marshal("MultiTexCoord2d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord2d, cmd_size);
      cmd->target = target;
      cmd->s = s;
      cmd->t = t;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord2d");
   CALL_MultiTexCoord2d(ctx->CurrentServerDispatch, (target, s, t));
}


/* SamplerParameterIuiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_SamplerParameterIuiv(GLuint sampler, GLenum pname, const GLuint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("SamplerParameterIuiv");
   CALL_SamplerParameterIuiv(ctx->CurrentServerDispatch, (sampler, pname, params));
}


/* MultiTexCoord2s: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord2s
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLshort s;
   GLshort t;
};
static inline void
_mesa_unmarshal_MultiTexCoord2s(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord2s *cmd)
{
   const GLenum target = cmd->target;
   const GLshort s = cmd->s;
   const GLshort t = cmd->t;
   CALL_MultiTexCoord2s(ctx->CurrentServerDispatch, (target, s, t));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord2s(GLenum target, GLshort s, GLshort t)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord2s);
   struct marshal_cmd_MultiTexCoord2s *cmd;
   debug_print_marshal("MultiTexCoord2s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord2s, cmd_size);
      cmd->target = target;
      cmd->s = s;
      cmd->t = t;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord2s");
   CALL_MultiTexCoord2s(ctx->CurrentServerDispatch, (target, s, t));
}


/* GetInternalformati64v: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetInternalformati64v(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64 * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetInternalformati64v");
   CALL_GetInternalformati64v(ctx->CurrentServerDispatch, (target, internalformat, pname, bufSize, params));
}


/* VDPAURegisterVideoSurfaceNV: marshalled synchronously */
static GLintptr GLAPIENTRY
_mesa_marshal_VDPAURegisterVideoSurfaceNV(const GLvoid * vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint * textureNames)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VDPAURegisterVideoSurfaceNV");
   return CALL_VDPAURegisterVideoSurfaceNV(ctx->CurrentServerDispatch, (vdpSurface, target, numTextureNames, textureNames));
}


/* Indexub: marshalled asynchronously */
struct marshal_cmd_Indexub
{
   struct marshal_cmd_base cmd_base;
   GLubyte c;
};
static inline void
_mesa_unmarshal_Indexub(struct gl_context *ctx, const struct marshal_cmd_Indexub *cmd)
{
   const GLubyte c = cmd->c;
   CALL_Indexub(ctx->CurrentServerDispatch, (c));
}
static void GLAPIENTRY
_mesa_marshal_Indexub(GLubyte c)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Indexub);
   struct marshal_cmd_Indexub *cmd;
   debug_print_marshal("Indexub");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Indexub, cmd_size);
      cmd->c = c;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Indexub");
   CALL_Indexub(ctx->CurrentServerDispatch, (c));
}


/* GetPerfMonitorCounterDataAMD: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetPerfMonitorCounterDataAMD(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint * data, GLint * bytesWritten)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetPerfMonitorCounterDataAMD");
   CALL_GetPerfMonitorCounterDataAMD(ctx->CurrentServerDispatch, (monitor, pname, dataSize, data, bytesWritten));
}


/* MultTransposeMatrixf: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_MultTransposeMatrixf(const GLfloat * m)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MultTransposeMatrixf");
   CALL_MultTransposeMatrixf(ctx->CurrentServerDispatch, (m));
}


/* PolygonOffsetEXT: marshalled asynchronously */
struct marshal_cmd_PolygonOffsetEXT
{
   struct marshal_cmd_base cmd_base;
   GLfloat factor;
   GLfloat bias;
};
static inline void
_mesa_unmarshal_PolygonOffsetEXT(struct gl_context *ctx, const struct marshal_cmd_PolygonOffsetEXT *cmd)
{
   const GLfloat factor = cmd->factor;
   const GLfloat bias = cmd->bias;
   CALL_PolygonOffsetEXT(ctx->CurrentServerDispatch, (factor, bias));
}
static void GLAPIENTRY
_mesa_marshal_PolygonOffsetEXT(GLfloat factor, GLfloat bias)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PolygonOffsetEXT);
   struct marshal_cmd_PolygonOffsetEXT *cmd;
   debug_print_marshal("PolygonOffsetEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PolygonOffsetEXT, cmd_size);
      cmd->factor = factor;
      cmd->bias = bias;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PolygonOffsetEXT");
   CALL_PolygonOffsetEXT(ctx->CurrentServerDispatch, (factor, bias));
}


/* Scalex: marshalled asynchronously */
struct marshal_cmd_Scalex
{
   struct marshal_cmd_base cmd_base;
   GLfixed x;
   GLfixed y;
   GLfixed z;
};
static inline void
_mesa_unmarshal_Scalex(struct gl_context *ctx, const struct marshal_cmd_Scalex *cmd)
{
   const GLfixed x = cmd->x;
   const GLfixed y = cmd->y;
   const GLfixed z = cmd->z;
   CALL_Scalex(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Scalex(GLfixed x, GLfixed y, GLfixed z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Scalex);
   struct marshal_cmd_Scalex *cmd;
   debug_print_marshal("Scalex");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Scalex, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Scalex");
   CALL_Scalex(ctx->CurrentServerDispatch, (x, y, z));
}


/* Scaled: marshalled asynchronously */
struct marshal_cmd_Scaled
{
   struct marshal_cmd_base cmd_base;
   GLdouble x;
   GLdouble y;
   GLdouble z;
};
static inline void
_mesa_unmarshal_Scaled(struct gl_context *ctx, const struct marshal_cmd_Scaled *cmd)
{
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   CALL_Scaled(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Scaled(GLdouble x, GLdouble y, GLdouble z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Scaled);
   struct marshal_cmd_Scaled *cmd;
   debug_print_marshal("Scaled");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Scaled, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Scaled");
   CALL_Scaled(ctx->CurrentServerDispatch, (x, y, z));
}


/* Scalef: marshalled asynchronously */
struct marshal_cmd_Scalef
{
   struct marshal_cmd_base cmd_base;
   GLfloat x;
   GLfloat y;
   GLfloat z;
};
static inline void
_mesa_unmarshal_Scalef(struct gl_context *ctx, const struct marshal_cmd_Scalef *cmd)
{
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   CALL_Scalef(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Scalef(GLfloat x, GLfloat y, GLfloat z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Scalef);
   struct marshal_cmd_Scalef *cmd;
   debug_print_marshal("Scalef");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Scalef, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Scalef");
   CALL_Scalef(ctx->CurrentServerDispatch, (x, y, z));
}


/* IndexPointerEXT: marshalled asynchronously */
struct marshal_cmd_IndexPointerEXT
{
   struct marshal_cmd_base cmd_base;
   GLenum type;
   GLsizei stride;
   GLsizei count;
   const GLvoid * pointer;
};
static inline void
_mesa_unmarshal_IndexPointerEXT(struct gl_context *ctx, const struct marshal_cmd_IndexPointerEXT *cmd)
{
   const GLenum type = cmd->type;
   const GLsizei stride = cmd->stride;
   const GLsizei count = cmd->count;
   const GLvoid * pointer = cmd->pointer;
   CALL_IndexPointerEXT(ctx->CurrentServerDispatch, (type, stride, count, pointer));
}
static void GLAPIENTRY
_mesa_marshal_IndexPointerEXT(GLenum type, GLsizei stride, GLsizei count, const GLvoid * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_IndexPointerEXT);
   struct marshal_cmd_IndexPointerEXT *cmd;
   debug_print_marshal("IndexPointerEXT");
   if (_mesa_glthread_is_non_vbo_vertex_attrib_pointer(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("IndexPointerEXT");
      CALL_IndexPointerEXT(ctx->CurrentServerDispatch, (type, stride, count, pointer));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_IndexPointerEXT, cmd_size);
      cmd->type = type;
      cmd->stride = stride;
      cmd->count = count;
      cmd->pointer = pointer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("IndexPointerEXT");
   CALL_IndexPointerEXT(ctx->CurrentServerDispatch, (type, stride, count, pointer));
}


/* GetUniformfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetUniformfv(GLuint program, GLint location, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetUniformfv");
   CALL_GetUniformfv(ctx->CurrentServerDispatch, (program, location, params));
}


/* ColorFragmentOp2ATI: marshalled asynchronously */
struct marshal_cmd_ColorFragmentOp2ATI
{
   struct marshal_cmd_base cmd_base;
   GLenum op;
   GLuint dst;
   GLuint dstMask;
   GLuint dstMod;
   GLuint arg1;
   GLuint arg1Rep;
   GLuint arg1Mod;
   GLuint arg2;
   GLuint arg2Rep;
   GLuint arg2Mod;
};
static inline void
_mesa_unmarshal_ColorFragmentOp2ATI(struct gl_context *ctx, const struct marshal_cmd_ColorFragmentOp2ATI *cmd)
{
   const GLenum op = cmd->op;
   const GLuint dst = cmd->dst;
   const GLuint dstMask = cmd->dstMask;
   const GLuint dstMod = cmd->dstMod;
   const GLuint arg1 = cmd->arg1;
   const GLuint arg1Rep = cmd->arg1Rep;
   const GLuint arg1Mod = cmd->arg1Mod;
   const GLuint arg2 = cmd->arg2;
   const GLuint arg2Rep = cmd->arg2Rep;
   const GLuint arg2Mod = cmd->arg2Mod;
   CALL_ColorFragmentOp2ATI(ctx->CurrentServerDispatch, (op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod));
}
static void GLAPIENTRY
_mesa_marshal_ColorFragmentOp2ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ColorFragmentOp2ATI);
   struct marshal_cmd_ColorFragmentOp2ATI *cmd;
   debug_print_marshal("ColorFragmentOp2ATI");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ColorFragmentOp2ATI, cmd_size);
      cmd->op = op;
      cmd->dst = dst;
      cmd->dstMask = dstMask;
      cmd->dstMod = dstMod;
      cmd->arg1 = arg1;
      cmd->arg1Rep = arg1Rep;
      cmd->arg1Mod = arg1Mod;
      cmd->arg2 = arg2;
      cmd->arg2Rep = arg2Rep;
      cmd->arg2Mod = arg2Mod;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ColorFragmentOp2ATI");
   CALL_ColorFragmentOp2ATI(ctx->CurrentServerDispatch, (op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod));
}


/* VertexAttrib2sNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib2sNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort x;
   GLshort y;
};
static inline void
_mesa_unmarshal_VertexAttrib2sNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib2sNV *cmd)
{
   const GLuint index = cmd->index;
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   CALL_VertexAttrib2sNV(ctx->CurrentServerDispatch, (index, x, y));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib2sNV(GLuint index, GLshort x, GLshort y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib2sNV);
   struct marshal_cmd_VertexAttrib2sNV *cmd;
   debug_print_marshal("VertexAttrib2sNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib2sNV, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib2sNV");
   CALL_VertexAttrib2sNV(ctx->CurrentServerDispatch, (index, x, y));
}


/* ReadPixels: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid * pixels)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ReadPixels");
   CALL_ReadPixels(ctx->CurrentServerDispatch, (x, y, width, height, format, type, pixels));
}


/* QueryCounter: marshalled asynchronously */
struct marshal_cmd_QueryCounter
{
   struct marshal_cmd_base cmd_base;
   GLuint id;
   GLenum target;
};
static inline void
_mesa_unmarshal_QueryCounter(struct gl_context *ctx, const struct marshal_cmd_QueryCounter *cmd)
{
   const GLuint id = cmd->id;
   const GLenum target = cmd->target;
   CALL_QueryCounter(ctx->CurrentServerDispatch, (id, target));
}
static void GLAPIENTRY
_mesa_marshal_QueryCounter(GLuint id, GLenum target)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_QueryCounter);
   struct marshal_cmd_QueryCounter *cmd;
   debug_print_marshal("QueryCounter");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_QueryCounter, cmd_size);
      cmd->id = id;
      cmd->target = target;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("QueryCounter");
   CALL_QueryCounter(ctx->CurrentServerDispatch, (id, target));
}


/* NormalPointerEXT: marshalled asynchronously */
struct marshal_cmd_NormalPointerEXT
{
   struct marshal_cmd_base cmd_base;
   GLenum type;
   GLsizei stride;
   GLsizei count;
   const GLvoid * pointer;
};
static inline void
_mesa_unmarshal_NormalPointerEXT(struct gl_context *ctx, const struct marshal_cmd_NormalPointerEXT *cmd)
{
   const GLenum type = cmd->type;
   const GLsizei stride = cmd->stride;
   const GLsizei count = cmd->count;
   const GLvoid * pointer = cmd->pointer;
   CALL_NormalPointerEXT(ctx->CurrentServerDispatch, (type, stride, count, pointer));
}
static void GLAPIENTRY
_mesa_marshal_NormalPointerEXT(GLenum type, GLsizei stride, GLsizei count, const GLvoid * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_NormalPointerEXT);
   struct marshal_cmd_NormalPointerEXT *cmd;
   debug_print_marshal("NormalPointerEXT");
   if (_mesa_glthread_is_non_vbo_vertex_attrib_pointer(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("NormalPointerEXT");
      CALL_NormalPointerEXT(ctx->CurrentServerDispatch, (type, stride, count, pointer));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_NormalPointerEXT, cmd_size);
      cmd->type = type;
      cmd->stride = stride;
      cmd->count = count;
      cmd->pointer = pointer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("NormalPointerEXT");
   CALL_NormalPointerEXT(ctx->CurrentServerDispatch, (type, stride, count, pointer));
}


/* GetSubroutineIndex: marshalled synchronously */
static GLuint GLAPIENTRY
_mesa_marshal_GetSubroutineIndex(GLuint program, GLenum shadertype, const GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetSubroutineIndex");
   return CALL_GetSubroutineIndex(ctx->CurrentServerDispatch, (program, shadertype, name));
}


/* ProgramUniform3iv: marshalled asynchronously */
struct marshal_cmd_ProgramUniform3iv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 12) bytes are GLint value[count][3] */
};
static inline void
_mesa_unmarshal_ProgramUniform3iv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform3iv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLint * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLint *) variable_data;
   variable_data += count * 12;
   CALL_ProgramUniform3iv(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform3iv(GLuint program, GLint location, GLsizei count, const GLint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform3iv) + safe_mul(count, 12);
   struct marshal_cmd_ProgramUniform3iv *cmd;
   debug_print_marshal("ProgramUniform3iv");
   if (unlikely(safe_mul(count, 12) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform3iv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 12);
      variable_data += count * 12;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform3iv");
   CALL_ProgramUniform3iv(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* ProgramUniformMatrix2dv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix2dv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 32) bytes are GLdouble value[count][4] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix2dv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix2dv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 32;
   CALL_ProgramUniformMatrix2dv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix2dv) + safe_mul(count, 32);
   struct marshal_cmd_ProgramUniformMatrix2dv *cmd;
   debug_print_marshal("ProgramUniformMatrix2dv");
   if (unlikely(safe_mul(count, 32) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix2dv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 32);
      variable_data += count * 32;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix2dv");
   CALL_ProgramUniformMatrix2dv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* ClearTexSubImage: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ClearTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ClearTexSubImage");
   CALL_ClearTexSubImage(ctx->CurrentServerDispatch, (texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data));
}


/* GetActiveUniformBlockName: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetActiveUniformBlockName(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei * length, GLchar * uniformBlockName)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetActiveUniformBlockName");
   CALL_GetActiveUniformBlockName(ctx->CurrentServerDispatch, (program, uniformBlockIndex, bufSize, length, uniformBlockName));
}


/* DrawElementsBaseVertex: marshalled asynchronously */
struct marshal_cmd_DrawElementsBaseVertex
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
   GLsizei count;
   GLenum type;
   const GLvoid * indices;
   GLint basevertex;
};
static inline void
_mesa_unmarshal_DrawElementsBaseVertex(struct gl_context *ctx, const struct marshal_cmd_DrawElementsBaseVertex *cmd)
{
   const GLenum mode = cmd->mode;
   const GLsizei count = cmd->count;
   const GLenum type = cmd->type;
   const GLvoid * indices = cmd->indices;
   const GLint basevertex = cmd->basevertex;
   CALL_DrawElementsBaseVertex(ctx->CurrentServerDispatch, (mode, count, type, indices, basevertex));
}
static void GLAPIENTRY
_mesa_marshal_DrawElementsBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLint basevertex)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawElementsBaseVertex);
   struct marshal_cmd_DrawElementsBaseVertex *cmd;
   debug_print_marshal("DrawElementsBaseVertex");
   if (_mesa_glthread_is_non_vbo_draw_elements(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("DrawElementsBaseVertex");
      CALL_DrawElementsBaseVertex(ctx->CurrentServerDispatch, (mode, count, type, indices, basevertex));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawElementsBaseVertex, cmd_size);
      cmd->mode = mode;
      cmd->count = count;
      cmd->type = type;
      cmd->indices = indices;
      cmd->basevertex = basevertex;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawElementsBaseVertex");
   CALL_DrawElementsBaseVertex(ctx->CurrentServerDispatch, (mode, count, type, indices, basevertex));
}


/* RasterPos3iv: marshalled asynchronously */
struct marshal_cmd_RasterPos3iv
{
   struct marshal_cmd_base cmd_base;
   GLint v[3];
};
static inline void
_mesa_unmarshal_RasterPos3iv(struct gl_context *ctx, const struct marshal_cmd_RasterPos3iv *cmd)
{
   const GLint * v = cmd->v;
   CALL_RasterPos3iv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos3iv(const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos3iv);
   struct marshal_cmd_RasterPos3iv *cmd;
   debug_print_marshal("RasterPos3iv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos3iv, cmd_size);
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos3iv");
   CALL_RasterPos3iv(ctx->CurrentServerDispatch, (v));
}


/* ColorMaski: marshalled asynchronously */
struct marshal_cmd_ColorMaski
{
   struct marshal_cmd_base cmd_base;
   GLuint buf;
   GLboolean r;
   GLboolean g;
   GLboolean b;
   GLboolean a;
};
static inline void
_mesa_unmarshal_ColorMaski(struct gl_context *ctx, const struct marshal_cmd_ColorMaski *cmd)
{
   const GLuint buf = cmd->buf;
   const GLboolean r = cmd->r;
   const GLboolean g = cmd->g;
   const GLboolean b = cmd->b;
   const GLboolean a = cmd->a;
   CALL_ColorMaski(ctx->CurrentServerDispatch, (buf, r, g, b, a));
}
static void GLAPIENTRY
_mesa_marshal_ColorMaski(GLuint buf, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ColorMaski);
   struct marshal_cmd_ColorMaski *cmd;
   debug_print_marshal("ColorMaski");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ColorMaski, cmd_size);
      cmd->buf = buf;
      cmd->r = r;
      cmd->g = g;
      cmd->b = b;
      cmd->a = a;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ColorMaski");
   CALL_ColorMaski(ctx->CurrentServerDispatch, (buf, r, g, b, a));
}


/* Uniform2uiv: marshalled asynchronously */
struct marshal_cmd_Uniform2uiv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 8) bytes are GLuint value[count][2] */
};
static inline void
_mesa_unmarshal_Uniform2uiv(struct gl_context *ctx, const struct marshal_cmd_Uniform2uiv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLuint * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLuint *) variable_data;
   variable_data += count * 8;
   CALL_Uniform2uiv(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform2uiv(GLint location, GLsizei count, const GLuint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform2uiv) + safe_mul(count, 8);
   struct marshal_cmd_Uniform2uiv *cmd;
   debug_print_marshal("Uniform2uiv");
   if (unlikely(safe_mul(count, 8) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform2uiv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 8);
      variable_data += count * 8;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform2uiv");
   CALL_Uniform2uiv(ctx->CurrentServerDispatch, (location, count, value));
}


/* RasterPos3s: marshalled asynchronously */
struct marshal_cmd_RasterPos3s
{
   struct marshal_cmd_base cmd_base;
   GLshort x;
   GLshort y;
   GLshort z;
};
static inline void
_mesa_unmarshal_RasterPos3s(struct gl_context *ctx, const struct marshal_cmd_RasterPos3s *cmd)
{
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   const GLshort z = cmd->z;
   CALL_RasterPos3s(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos3s(GLshort x, GLshort y, GLshort z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos3s);
   struct marshal_cmd_RasterPos3s *cmd;
   debug_print_marshal("RasterPos3s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos3s, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos3s");
   CALL_RasterPos3s(ctx->CurrentServerDispatch, (x, y, z));
}


/* RasterPos3d: marshalled asynchronously */
struct marshal_cmd_RasterPos3d
{
   struct marshal_cmd_base cmd_base;
   GLdouble x;
   GLdouble y;
   GLdouble z;
};
static inline void
_mesa_unmarshal_RasterPos3d(struct gl_context *ctx, const struct marshal_cmd_RasterPos3d *cmd)
{
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   CALL_RasterPos3d(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos3d(GLdouble x, GLdouble y, GLdouble z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos3d);
   struct marshal_cmd_RasterPos3d *cmd;
   debug_print_marshal("RasterPos3d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos3d, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos3d");
   CALL_RasterPos3d(ctx->CurrentServerDispatch, (x, y, z));
}


/* RasterPos3f: marshalled asynchronously */
struct marshal_cmd_RasterPos3f
{
   struct marshal_cmd_base cmd_base;
   GLfloat x;
   GLfloat y;
   GLfloat z;
};
static inline void
_mesa_unmarshal_RasterPos3f(struct gl_context *ctx, const struct marshal_cmd_RasterPos3f *cmd)
{
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   CALL_RasterPos3f(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos3f(GLfloat x, GLfloat y, GLfloat z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos3f);
   struct marshal_cmd_RasterPos3f *cmd;
   debug_print_marshal("RasterPos3f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos3f, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos3f");
   CALL_RasterPos3f(ctx->CurrentServerDispatch, (x, y, z));
}


/* BindVertexArray: marshalled asynchronously */
struct marshal_cmd_BindVertexArray
{
   struct marshal_cmd_base cmd_base;
   GLuint array;
};
static inline void
_mesa_unmarshal_BindVertexArray(struct gl_context *ctx, const struct marshal_cmd_BindVertexArray *cmd)
{
   const GLuint array = cmd->array;
   CALL_BindVertexArray(ctx->CurrentServerDispatch, (array));
}
static void GLAPIENTRY
_mesa_marshal_BindVertexArray(GLuint array)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindVertexArray);
   struct marshal_cmd_BindVertexArray *cmd;
   debug_print_marshal("BindVertexArray");
   if (_mesa_glthread_is_compat_bind_vertex_array(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("BindVertexArray");
      CALL_BindVertexArray(ctx->CurrentServerDispatch, (array));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindVertexArray, cmd_size);
      cmd->array = array;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindVertexArray");
   CALL_BindVertexArray(ctx->CurrentServerDispatch, (array));
}


/* RasterPos3i: marshalled asynchronously */
struct marshal_cmd_RasterPos3i
{
   struct marshal_cmd_base cmd_base;
   GLint x;
   GLint y;
   GLint z;
};
static inline void
_mesa_unmarshal_RasterPos3i(struct gl_context *ctx, const struct marshal_cmd_RasterPos3i *cmd)
{
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLint z = cmd->z;
   CALL_RasterPos3i(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos3i(GLint x, GLint y, GLint z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos3i);
   struct marshal_cmd_RasterPos3i *cmd;
   debug_print_marshal("RasterPos3i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos3i, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos3i");
   CALL_RasterPos3i(ctx->CurrentServerDispatch, (x, y, z));
}


/* VertexAttribL3dv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribL3dv(GLuint index, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribL3dv");
   CALL_VertexAttribL3dv(ctx->CurrentServerDispatch, (index, v));
}


/* GetTexParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTexParameteriv(GLenum target, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTexParameteriv");
   CALL_GetTexParameteriv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* DrawTransformFeedbackStreamInstanced: marshalled asynchronously */
struct marshal_cmd_DrawTransformFeedbackStreamInstanced
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
   GLuint id;
   GLuint stream;
   GLsizei primcount;
};
static inline void
_mesa_unmarshal_DrawTransformFeedbackStreamInstanced(struct gl_context *ctx, const struct marshal_cmd_DrawTransformFeedbackStreamInstanced *cmd)
{
   const GLenum mode = cmd->mode;
   const GLuint id = cmd->id;
   const GLuint stream = cmd->stream;
   const GLsizei primcount = cmd->primcount;
   CALL_DrawTransformFeedbackStreamInstanced(ctx->CurrentServerDispatch, (mode, id, stream, primcount));
}
static void GLAPIENTRY
_mesa_marshal_DrawTransformFeedbackStreamInstanced(GLenum mode, GLuint id, GLuint stream, GLsizei primcount)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawTransformFeedbackStreamInstanced);
   struct marshal_cmd_DrawTransformFeedbackStreamInstanced *cmd;
   debug_print_marshal("DrawTransformFeedbackStreamInstanced");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawTransformFeedbackStreamInstanced, cmd_size);
      cmd->mode = mode;
      cmd->id = id;
      cmd->stream = stream;
      cmd->primcount = primcount;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawTransformFeedbackStreamInstanced");
   CALL_DrawTransformFeedbackStreamInstanced(ctx->CurrentServerDispatch, (mode, id, stream, primcount));
}


/* VertexAttrib2fvARB: marshalled asynchronously */
struct marshal_cmd_VertexAttrib2fvARB
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat v[2];
};
static inline void
_mesa_unmarshal_VertexAttrib2fvARB(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib2fvARB *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat * v = cmd->v;
   CALL_VertexAttrib2fvARB(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib2fvARB(GLuint index, const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib2fvARB);
   struct marshal_cmd_VertexAttrib2fvARB *cmd;
   debug_print_marshal("VertexAttrib2fvARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib2fvARB, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib2fvARB");
   CALL_VertexAttrib2fvARB(ctx->CurrentServerDispatch, (index, v));
}


/* GetProgramResourceName: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetProgramResourceName(GLuint program, GLenum programInterface, GLuint index, GLsizei  bufSize, GLsizei * length, GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramResourceName");
   CALL_GetProgramResourceName(ctx->CurrentServerDispatch, (program, programInterface, index, bufSize, length, name));
}


/* ProgramUniformMatrix4x3dv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix4x3dv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 96) bytes are GLdouble value[count][12] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix4x3dv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix4x3dv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 96;
   CALL_ProgramUniformMatrix4x3dv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix4x3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix4x3dv) + safe_mul(count, 96);
   struct marshal_cmd_ProgramUniformMatrix4x3dv *cmd;
   debug_print_marshal("ProgramUniformMatrix4x3dv");
   if (unlikely(safe_mul(count, 96) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix4x3dv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 96);
      variable_data += count * 96;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix4x3dv");
   CALL_ProgramUniformMatrix4x3dv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* ColorTable: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ColorTable(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid * table)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ColorTable");
   CALL_ColorTable(ctx->CurrentServerDispatch, (target, internalformat, width, format, type, table));
}


/* LoadName: marshalled asynchronously */
struct marshal_cmd_LoadName
{
   struct marshal_cmd_base cmd_base;
   GLuint name;
};
static inline void
_mesa_unmarshal_LoadName(struct gl_context *ctx, const struct marshal_cmd_LoadName *cmd)
{
   const GLuint name = cmd->name;
   CALL_LoadName(ctx->CurrentServerDispatch, (name));
}
static void GLAPIENTRY
_mesa_marshal_LoadName(GLuint name)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_LoadName);
   struct marshal_cmd_LoadName *cmd;
   debug_print_marshal("LoadName");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_LoadName, cmd_size);
      cmd->name = name;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("LoadName");
   CALL_LoadName(ctx->CurrentServerDispatch, (name));
}


/* GetnUniformuivARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnUniformuivARB(GLuint program, GLint location, GLsizei bufSize, GLuint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnUniformuivARB");
   CALL_GetnUniformuivARB(ctx->CurrentServerDispatch, (program, location, bufSize, params));
}


/* ClearIndex: marshalled asynchronously */
struct marshal_cmd_ClearIndex
{
   struct marshal_cmd_base cmd_base;
   GLfloat c;
};
static inline void
_mesa_unmarshal_ClearIndex(struct gl_context *ctx, const struct marshal_cmd_ClearIndex *cmd)
{
   const GLfloat c = cmd->c;
   CALL_ClearIndex(ctx->CurrentServerDispatch, (c));
}
static void GLAPIENTRY
_mesa_marshal_ClearIndex(GLfloat c)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClearIndex);
   struct marshal_cmd_ClearIndex *cmd;
   debug_print_marshal("ClearIndex");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClearIndex, cmd_size);
      cmd->c = c;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClearIndex");
   CALL_ClearIndex(ctx->CurrentServerDispatch, (c));
}


/* ConvolutionParameterfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ConvolutionParameterfv(GLenum target, GLenum pname, const GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ConvolutionParameterfv");
   CALL_ConvolutionParameterfv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* GetTexGendv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTexGendv(GLenum coord, GLenum pname, GLdouble * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTexGendv");
   CALL_GetTexGendv(ctx->CurrentServerDispatch, (coord, pname, params));
}


/* FlushMappedNamedBufferRange: marshalled asynchronously */
struct marshal_cmd_FlushMappedNamedBufferRange
{
   struct marshal_cmd_base cmd_base;
   GLuint buffer;
   GLintptr offset;
   GLsizeiptr length;
};
static inline void
_mesa_unmarshal_FlushMappedNamedBufferRange(struct gl_context *ctx, const struct marshal_cmd_FlushMappedNamedBufferRange *cmd)
{
   const GLuint buffer = cmd->buffer;
   const GLintptr offset = cmd->offset;
   const GLsizeiptr length = cmd->length;
   CALL_FlushMappedNamedBufferRange(ctx->CurrentServerDispatch, (buffer, offset, length));
}
static void GLAPIENTRY
_mesa_marshal_FlushMappedNamedBufferRange(GLuint buffer, GLintptr offset, GLsizeiptr length)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_FlushMappedNamedBufferRange);
   struct marshal_cmd_FlushMappedNamedBufferRange *cmd;
   debug_print_marshal("FlushMappedNamedBufferRange");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_FlushMappedNamedBufferRange, cmd_size);
      cmd->buffer = buffer;
      cmd->offset = offset;
      cmd->length = length;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("FlushMappedNamedBufferRange");
   CALL_FlushMappedNamedBufferRange(ctx->CurrentServerDispatch, (buffer, offset, length));
}


/* MultiTexCoordP1ui: marshalled asynchronously */
struct marshal_cmd_MultiTexCoordP1ui
{
   struct marshal_cmd_base cmd_base;
   GLenum texture;
   GLenum type;
   GLuint coords;
};
static inline void
_mesa_unmarshal_MultiTexCoordP1ui(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoordP1ui *cmd)
{
   const GLenum texture = cmd->texture;
   const GLenum type = cmd->type;
   const GLuint coords = cmd->coords;
   CALL_MultiTexCoordP1ui(ctx->CurrentServerDispatch, (texture, type, coords));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoordP1ui(GLenum texture, GLenum type, GLuint coords)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoordP1ui);
   struct marshal_cmd_MultiTexCoordP1ui *cmd;
   debug_print_marshal("MultiTexCoordP1ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoordP1ui, cmd_size);
      cmd->texture = texture;
      cmd->type = type;
      cmd->coords = coords;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoordP1ui");
   CALL_MultiTexCoordP1ui(ctx->CurrentServerDispatch, (texture, type, coords));
}


/* EvalMesh2: marshalled asynchronously */
struct marshal_cmd_EvalMesh2
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
   GLint i1;
   GLint i2;
   GLint j1;
   GLint j2;
};
static inline void
_mesa_unmarshal_EvalMesh2(struct gl_context *ctx, const struct marshal_cmd_EvalMesh2 *cmd)
{
   const GLenum mode = cmd->mode;
   const GLint i1 = cmd->i1;
   const GLint i2 = cmd->i2;
   const GLint j1 = cmd->j1;
   const GLint j2 = cmd->j2;
   CALL_EvalMesh2(ctx->CurrentServerDispatch, (mode, i1, i2, j1, j2));
}
static void GLAPIENTRY
_mesa_marshal_EvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EvalMesh2);
   struct marshal_cmd_EvalMesh2 *cmd;
   debug_print_marshal("EvalMesh2");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EvalMesh2, cmd_size);
      cmd->mode = mode;
      cmd->i1 = i1;
      cmd->i2 = i2;
      cmd->j1 = j1;
      cmd->j2 = j2;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EvalMesh2");
   CALL_EvalMesh2(ctx->CurrentServerDispatch, (mode, i1, i2, j1, j2));
}


/* Vertex4fv: marshalled asynchronously */
struct marshal_cmd_Vertex4fv
{
   struct marshal_cmd_base cmd_base;
   GLfloat v[4];
};
static inline void
_mesa_unmarshal_Vertex4fv(struct gl_context *ctx, const struct marshal_cmd_Vertex4fv *cmd)
{
   const GLfloat * v = cmd->v;
   CALL_Vertex4fv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Vertex4fv(const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex4fv);
   struct marshal_cmd_Vertex4fv *cmd;
   debug_print_marshal("Vertex4fv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex4fv, cmd_size);
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex4fv");
   CALL_Vertex4fv(ctx->CurrentServerDispatch, (v));
}


/* ProgramUniform4i64ARB: marshalled asynchronously */
struct marshal_cmd_ProgramUniform4i64ARB
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLint64 x;
   GLint64 y;
   GLint64 z;
   GLint64 w;
};
static inline void
_mesa_unmarshal_ProgramUniform4i64ARB(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform4i64ARB *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLint64 x = cmd->x;
   const GLint64 y = cmd->y;
   const GLint64 z = cmd->z;
   const GLint64 w = cmd->w;
   CALL_ProgramUniform4i64ARB(ctx->CurrentServerDispatch, (program, location, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform4i64ARB(GLuint program, GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform4i64ARB);
   struct marshal_cmd_ProgramUniform4i64ARB *cmd;
   debug_print_marshal("ProgramUniform4i64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform4i64ARB, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform4i64ARB");
   CALL_ProgramUniform4i64ARB(ctx->CurrentServerDispatch, (program, location, x, y, z, w));
}


/* SelectPerfMonitorCountersAMD: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_SelectPerfMonitorCountersAMD(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint * counterList)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("SelectPerfMonitorCountersAMD");
   CALL_SelectPerfMonitorCountersAMD(ctx->CurrentServerDispatch, (monitor, enable, group, numCounters, counterList));
}


/* TextureStorage2D: marshalled asynchronously */
struct marshal_cmd_TextureStorage2D
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLsizei levels;
   GLenum internalformat;
   GLsizei width;
   GLsizei height;
};
static inline void
_mesa_unmarshal_TextureStorage2D(struct gl_context *ctx, const struct marshal_cmd_TextureStorage2D *cmd)
{
   const GLuint texture = cmd->texture;
   const GLsizei levels = cmd->levels;
   const GLenum internalformat = cmd->internalformat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   CALL_TextureStorage2D(ctx->CurrentServerDispatch, (texture, levels, internalformat, width, height));
}
static void GLAPIENTRY
_mesa_marshal_TextureStorage2D(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureStorage2D);
   struct marshal_cmd_TextureStorage2D *cmd;
   debug_print_marshal("TextureStorage2D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureStorage2D, cmd_size);
      cmd->texture = texture;
      cmd->levels = levels;
      cmd->internalformat = internalformat;
      cmd->width = width;
      cmd->height = height;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureStorage2D");
   CALL_TextureStorage2D(ctx->CurrentServerDispatch, (texture, levels, internalformat, width, height));
}


/* GetTextureParameterIiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTextureParameterIiv(GLuint texture, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTextureParameterIiv");
   CALL_GetTextureParameterIiv(ctx->CurrentServerDispatch, (texture, pname, params));
}


/* BindFramebuffer: marshalled asynchronously */
struct marshal_cmd_BindFramebuffer
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint framebuffer;
};
static inline void
_mesa_unmarshal_BindFramebuffer(struct gl_context *ctx, const struct marshal_cmd_BindFramebuffer *cmd)
{
   const GLenum target = cmd->target;
   const GLuint framebuffer = cmd->framebuffer;
   CALL_BindFramebuffer(ctx->CurrentServerDispatch, (target, framebuffer));
}
static void GLAPIENTRY
_mesa_marshal_BindFramebuffer(GLenum target, GLuint framebuffer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindFramebuffer);
   struct marshal_cmd_BindFramebuffer *cmd;
   debug_print_marshal("BindFramebuffer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindFramebuffer, cmd_size);
      cmd->target = target;
      cmd->framebuffer = framebuffer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindFramebuffer");
   CALL_BindFramebuffer(ctx->CurrentServerDispatch, (target, framebuffer));
}


/* GetMinmax: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetMinmax(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetMinmax");
   CALL_GetMinmax(ctx->CurrentServerDispatch, (target, reset, format, type, values));
}


/* VertexAttribs3svNV: marshalled asynchronously */
struct marshal_cmd_VertexAttribs3svNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLsizei n;
   /* Next safe_mul(n, 6) bytes are GLshort v[n][3] */
};
static inline void
_mesa_unmarshal_VertexAttribs3svNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttribs3svNV *cmd)
{
   const GLuint index = cmd->index;
   const GLsizei n = cmd->n;
   const GLshort * v;
   const char *variable_data = (const char *) (cmd + 1);
   v = (const GLshort *) variable_data;
   variable_data += n * 6;
   CALL_VertexAttribs3svNV(ctx->CurrentServerDispatch, (index, n, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribs3svNV(GLuint index, GLsizei n, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribs3svNV) + safe_mul(n, 6);
   struct marshal_cmd_VertexAttribs3svNV *cmd;
   debug_print_marshal("VertexAttribs3svNV");
   if (unlikely(safe_mul(n, 6) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribs3svNV, cmd_size);
      cmd->index = index;
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, v, n * 6);
      variable_data += n * 6;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribs3svNV");
   CALL_VertexAttribs3svNV(ctx->CurrentServerDispatch, (index, n, v));
}


/* GetActiveUniformsiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetActiveUniformsiv(GLuint program, GLsizei uniformCount, const GLuint * uniformIndices, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetActiveUniformsiv");
   CALL_GetActiveUniformsiv(ctx->CurrentServerDispatch, (program, uniformCount, uniformIndices, pname, params));
}


/* VertexAttrib2sv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib2sv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort v[2];
};
static inline void
_mesa_unmarshal_VertexAttrib2sv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib2sv *cmd)
{
   const GLuint index = cmd->index;
   const GLshort * v = cmd->v;
   CALL_VertexAttrib2sv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib2sv(GLuint index, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib2sv);
   struct marshal_cmd_VertexAttrib2sv *cmd;
   debug_print_marshal("VertexAttrib2sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib2sv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib2sv");
   CALL_VertexAttrib2sv(ctx->CurrentServerDispatch, (index, v));
}


/* GetProgramEnvParameterdvARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetProgramEnvParameterdvARB(GLenum target, GLuint index, GLdouble * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramEnvParameterdvARB");
   CALL_GetProgramEnvParameterdvARB(ctx->CurrentServerDispatch, (target, index, params));
}


/* Uniform1dv: marshalled asynchronously */
struct marshal_cmd_Uniform1dv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 8) bytes are GLdouble value[count] */
};
static inline void
_mesa_unmarshal_Uniform1dv(struct gl_context *ctx, const struct marshal_cmd_Uniform1dv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 8;
   CALL_Uniform1dv(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform1dv(GLint location, GLsizei count, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform1dv) + safe_mul(count, 8);
   struct marshal_cmd_Uniform1dv *cmd;
   debug_print_marshal("Uniform1dv");
   if (unlikely(safe_mul(count, 8) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform1dv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 8);
      variable_data += count * 8;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform1dv");
   CALL_Uniform1dv(ctx->CurrentServerDispatch, (location, count, value));
}


/* TransformFeedbackBufferRange: marshalled asynchronously */
struct marshal_cmd_TransformFeedbackBufferRange
{
   struct marshal_cmd_base cmd_base;
   GLuint xfb;
   GLuint index;
   GLuint buffer;
   GLintptr offset;
   GLsizeiptr size;
};
static inline void
_mesa_unmarshal_TransformFeedbackBufferRange(struct gl_context *ctx, const struct marshal_cmd_TransformFeedbackBufferRange *cmd)
{
   const GLuint xfb = cmd->xfb;
   const GLuint index = cmd->index;
   const GLuint buffer = cmd->buffer;
   const GLintptr offset = cmd->offset;
   const GLsizeiptr size = cmd->size;
   CALL_TransformFeedbackBufferRange(ctx->CurrentServerDispatch, (xfb, index, buffer, offset, size));
}
static void GLAPIENTRY
_mesa_marshal_TransformFeedbackBufferRange(GLuint xfb, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TransformFeedbackBufferRange);
   struct marshal_cmd_TransformFeedbackBufferRange *cmd;
   debug_print_marshal("TransformFeedbackBufferRange");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TransformFeedbackBufferRange, cmd_size);
      cmd->xfb = xfb;
      cmd->index = index;
      cmd->buffer = buffer;
      cmd->offset = offset;
      cmd->size = size;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TransformFeedbackBufferRange");
   CALL_TransformFeedbackBufferRange(ctx->CurrentServerDispatch, (xfb, index, buffer, offset, size));
}


/* PushDebugGroup: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_PushDebugGroup(GLenum source, GLuint id, GLsizei length, const GLchar * message)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("PushDebugGroup");
   CALL_PushDebugGroup(ctx->CurrentServerDispatch, (source, id, length, message));
}


/* GetPerfMonitorGroupStringAMD: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetPerfMonitorGroupStringAMD(GLuint group, GLsizei bufSize, GLsizei * length, GLchar * groupString)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetPerfMonitorGroupStringAMD");
   CALL_GetPerfMonitorGroupStringAMD(ctx->CurrentServerDispatch, (group, bufSize, length, groupString));
}


/* GetError: marshalled synchronously */
static GLenum GLAPIENTRY
_mesa_marshal_GetError(void)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetError");
   return CALL_GetError(ctx->CurrentServerDispatch, ());
}


/* PassThrough: marshalled asynchronously */
struct marshal_cmd_PassThrough
{
   struct marshal_cmd_base cmd_base;
   GLfloat token;
};
static inline void
_mesa_unmarshal_PassThrough(struct gl_context *ctx, const struct marshal_cmd_PassThrough *cmd)
{
   const GLfloat token = cmd->token;
   CALL_PassThrough(ctx->CurrentServerDispatch, (token));
}
static void GLAPIENTRY
_mesa_marshal_PassThrough(GLfloat token)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PassThrough);
   struct marshal_cmd_PassThrough *cmd;
   debug_print_marshal("PassThrough");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PassThrough, cmd_size);
      cmd->token = token;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PassThrough");
   CALL_PassThrough(ctx->CurrentServerDispatch, (token));
}


/* PatchParameterfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_PatchParameterfv(GLenum pname, const GLfloat * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("PatchParameterfv");
   CALL_PatchParameterfv(ctx->CurrentServerDispatch, (pname, values));
}


/* GetObjectParameterivAPPLE: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetObjectParameterivAPPLE(GLenum objectType, GLuint name, GLenum pname, GLint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetObjectParameterivAPPLE");
   CALL_GetObjectParameterivAPPLE(ctx->CurrentServerDispatch, (objectType, name, pname, value));
}


/* BindBuffersRange: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_BindBuffersRange(GLenum target, GLuint first, GLsizei count, const GLuint * buffers, const GLintptr * offsets, const GLsizeiptr * sizes)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("BindBuffersRange");
   CALL_BindBuffersRange(ctx->CurrentServerDispatch, (target, first, count, buffers, offsets, sizes));
}


/* VertexAttrib4fvARB: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4fvARB
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4fvARB(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4fvARB *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat * v = cmd->v;
   CALL_VertexAttrib4fvARB(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4fvARB(GLuint index, const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4fvARB);
   struct marshal_cmd_VertexAttrib4fvARB *cmd;
   debug_print_marshal("VertexAttrib4fvARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4fvARB, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4fvARB");
   CALL_VertexAttrib4fvARB(ctx->CurrentServerDispatch, (index, v));
}


/* Uniform3i64vARB: marshalled asynchronously */
struct marshal_cmd_Uniform3i64vARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 24) bytes are GLint64 value[count][3] */
};
static inline void
_mesa_unmarshal_Uniform3i64vARB(struct gl_context *ctx, const struct marshal_cmd_Uniform3i64vARB *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLint64 * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLint64 *) variable_data;
   variable_data += count * 24;
   CALL_Uniform3i64vARB(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform3i64vARB(GLint location, GLsizei count, const GLint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform3i64vARB) + safe_mul(count, 24);
   struct marshal_cmd_Uniform3i64vARB *cmd;
   debug_print_marshal("Uniform3i64vARB");
   if (unlikely(safe_mul(count, 24) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform3i64vARB, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 24);
      variable_data += count * 24;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform3i64vARB");
   CALL_Uniform3i64vARB(ctx->CurrentServerDispatch, (location, count, value));
}


/* WindowPos3dv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_WindowPos3dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("WindowPos3dv");
   CALL_WindowPos3dv(ctx->CurrentServerDispatch, (v));
}


/* TexGenxOES: marshalled asynchronously */
struct marshal_cmd_TexGenxOES
{
   struct marshal_cmd_base cmd_base;
   GLenum coord;
   GLenum pname;
   GLint param;
};
static inline void
_mesa_unmarshal_TexGenxOES(struct gl_context *ctx, const struct marshal_cmd_TexGenxOES *cmd)
{
   const GLenum coord = cmd->coord;
   const GLenum pname = cmd->pname;
   const GLint param = cmd->param;
   CALL_TexGenxOES(ctx->CurrentServerDispatch, (coord, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_TexGenxOES(GLenum coord, GLenum pname, GLint param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexGenxOES);
   struct marshal_cmd_TexGenxOES *cmd;
   debug_print_marshal("TexGenxOES");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexGenxOES, cmd_size);
      cmd->coord = coord;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexGenxOES");
   CALL_TexGenxOES(ctx->CurrentServerDispatch, (coord, pname, param));
}


/* VertexArrayAttribIFormat: marshalled asynchronously */
struct marshal_cmd_VertexArrayAttribIFormat
{
   struct marshal_cmd_base cmd_base;
   GLuint vaobj;
   GLuint attribindex;
   GLint size;
   GLenum type;
   GLuint relativeoffset;
};
static inline void
_mesa_unmarshal_VertexArrayAttribIFormat(struct gl_context *ctx, const struct marshal_cmd_VertexArrayAttribIFormat *cmd)
{
   const GLuint vaobj = cmd->vaobj;
   const GLuint attribindex = cmd->attribindex;
   const GLint size = cmd->size;
   const GLenum type = cmd->type;
   const GLuint relativeoffset = cmd->relativeoffset;
   CALL_VertexArrayAttribIFormat(ctx->CurrentServerDispatch, (vaobj, attribindex, size, type, relativeoffset));
}
static void GLAPIENTRY
_mesa_marshal_VertexArrayAttribIFormat(GLuint vaobj, GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexArrayAttribIFormat);
   struct marshal_cmd_VertexArrayAttribIFormat *cmd;
   debug_print_marshal("VertexArrayAttribIFormat");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexArrayAttribIFormat, cmd_size);
      cmd->vaobj = vaobj;
      cmd->attribindex = attribindex;
      cmd->size = size;
      cmd->type = type;
      cmd->relativeoffset = relativeoffset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexArrayAttribIFormat");
   CALL_VertexArrayAttribIFormat(ctx->CurrentServerDispatch, (vaobj, attribindex, size, type, relativeoffset));
}


/* StencilOp: marshalled asynchronously */
struct marshal_cmd_StencilOp
{
   struct marshal_cmd_base cmd_base;
   GLenum fail;
   GLenum zfail;
   GLenum zpass;
};
static inline void
_mesa_unmarshal_StencilOp(struct gl_context *ctx, const struct marshal_cmd_StencilOp *cmd)
{
   const GLenum fail = cmd->fail;
   const GLenum zfail = cmd->zfail;
   const GLenum zpass = cmd->zpass;
   CALL_StencilOp(ctx->CurrentServerDispatch, (fail, zfail, zpass));
}
static void GLAPIENTRY
_mesa_marshal_StencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_StencilOp);
   struct marshal_cmd_StencilOp *cmd;
   debug_print_marshal("StencilOp");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_StencilOp, cmd_size);
      cmd->fail = fail;
      cmd->zfail = zfail;
      cmd->zpass = zpass;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("StencilOp");
   CALL_StencilOp(ctx->CurrentServerDispatch, (fail, zfail, zpass));
}


/* ProgramUniform1iv: marshalled asynchronously */
struct marshal_cmd_ProgramUniform1iv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 4) bytes are GLint value[count] */
};
static inline void
_mesa_unmarshal_ProgramUniform1iv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform1iv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLint * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLint *) variable_data;
   variable_data += count * 4;
   CALL_ProgramUniform1iv(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform1iv(GLuint program, GLint location, GLsizei count, const GLint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform1iv) + safe_mul(count, 4);
   struct marshal_cmd_ProgramUniform1iv *cmd;
   debug_print_marshal("ProgramUniform1iv");
   if (unlikely(safe_mul(count, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform1iv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 4);
      variable_data += count * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform1iv");
   CALL_ProgramUniform1iv(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* ProgramUniform3ui: marshalled asynchronously */
struct marshal_cmd_ProgramUniform3ui
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLuint x;
   GLuint y;
   GLuint z;
};
static inline void
_mesa_unmarshal_ProgramUniform3ui(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform3ui *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLuint x = cmd->x;
   const GLuint y = cmd->y;
   const GLuint z = cmd->z;
   CALL_ProgramUniform3ui(ctx->CurrentServerDispatch, (program, location, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform3ui(GLuint program, GLint location, GLuint x, GLuint y, GLuint z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform3ui);
   struct marshal_cmd_ProgramUniform3ui *cmd;
   debug_print_marshal("ProgramUniform3ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform3ui, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform3ui");
   CALL_ProgramUniform3ui(ctx->CurrentServerDispatch, (program, location, x, y, z));
}


/* SecondaryColor3sv: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3sv
{
   struct marshal_cmd_base cmd_base;
   GLshort v[3];
};
static inline void
_mesa_unmarshal_SecondaryColor3sv(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3sv *cmd)
{
   const GLshort * v = cmd->v;
   CALL_SecondaryColor3sv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3sv(const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3sv);
   struct marshal_cmd_SecondaryColor3sv *cmd;
   debug_print_marshal("SecondaryColor3sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3sv, cmd_size);
      memcpy(cmd->v, v, 6);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3sv");
   CALL_SecondaryColor3sv(ctx->CurrentServerDispatch, (v));
}


/* TexCoordP3ui: marshalled asynchronously */
struct marshal_cmd_TexCoordP3ui
{
   struct marshal_cmd_base cmd_base;
   GLenum type;
   GLuint coords;
};
static inline void
_mesa_unmarshal_TexCoordP3ui(struct gl_context *ctx, const struct marshal_cmd_TexCoordP3ui *cmd)
{
   const GLenum type = cmd->type;
   const GLuint coords = cmd->coords;
   CALL_TexCoordP3ui(ctx->CurrentServerDispatch, (type, coords));
}
static void GLAPIENTRY
_mesa_marshal_TexCoordP3ui(GLenum type, GLuint coords)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoordP3ui);
   struct marshal_cmd_TexCoordP3ui *cmd;
   debug_print_marshal("TexCoordP3ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoordP3ui, cmd_size);
      cmd->type = type;
      cmd->coords = coords;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoordP3ui");
   CALL_TexCoordP3ui(ctx->CurrentServerDispatch, (type, coords));
}


/* VertexArrayElementBuffer: marshalled asynchronously */
struct marshal_cmd_VertexArrayElementBuffer
{
   struct marshal_cmd_base cmd_base;
   GLuint vaobj;
   GLuint buffer;
};
static inline void
_mesa_unmarshal_VertexArrayElementBuffer(struct gl_context *ctx, const struct marshal_cmd_VertexArrayElementBuffer *cmd)
{
   const GLuint vaobj = cmd->vaobj;
   const GLuint buffer = cmd->buffer;
   CALL_VertexArrayElementBuffer(ctx->CurrentServerDispatch, (vaobj, buffer));
}
static void GLAPIENTRY
_mesa_marshal_VertexArrayElementBuffer(GLuint vaobj, GLuint buffer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexArrayElementBuffer);
   struct marshal_cmd_VertexArrayElementBuffer *cmd;
   debug_print_marshal("VertexArrayElementBuffer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexArrayElementBuffer, cmd_size);
      cmd->vaobj = vaobj;
      cmd->buffer = buffer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexArrayElementBuffer");
   CALL_VertexArrayElementBuffer(ctx->CurrentServerDispatch, (vaobj, buffer));
}


/* Fogxv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_Fogxv(GLenum pname, const GLfixed * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("Fogxv");
   CALL_Fogxv(ctx->CurrentServerDispatch, (pname, params));
}


/* Uniform3i64ARB: marshalled asynchronously */
struct marshal_cmd_Uniform3i64ARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLint64 x;
   GLint64 y;
   GLint64 z;
};
static inline void
_mesa_unmarshal_Uniform3i64ARB(struct gl_context *ctx, const struct marshal_cmd_Uniform3i64ARB *cmd)
{
   const GLint location = cmd->location;
   const GLint64 x = cmd->x;
   const GLint64 y = cmd->y;
   const GLint64 z = cmd->z;
   CALL_Uniform3i64ARB(ctx->CurrentServerDispatch, (location, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Uniform3i64ARB(GLint location, GLint64 x, GLint64 y, GLint64 z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform3i64ARB);
   struct marshal_cmd_Uniform3i64ARB *cmd;
   debug_print_marshal("Uniform3i64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform3i64ARB, cmd_size);
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform3i64ARB");
   CALL_Uniform3i64ARB(ctx->CurrentServerDispatch, (location, x, y, z));
}


/* VertexAttribP1ui: marshalled asynchronously */
struct marshal_cmd_VertexAttribP1ui
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLenum type;
   GLboolean normalized;
   GLuint value;
};
static inline void
_mesa_unmarshal_VertexAttribP1ui(struct gl_context *ctx, const struct marshal_cmd_VertexAttribP1ui *cmd)
{
   const GLuint index = cmd->index;
   const GLenum type = cmd->type;
   const GLboolean normalized = cmd->normalized;
   const GLuint value = cmd->value;
   CALL_VertexAttribP1ui(ctx->CurrentServerDispatch, (index, type, normalized, value));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribP1ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribP1ui);
   struct marshal_cmd_VertexAttribP1ui *cmd;
   debug_print_marshal("VertexAttribP1ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribP1ui, cmd_size);
      cmd->index = index;
      cmd->type = type;
      cmd->normalized = normalized;
      cmd->value = value;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribP1ui");
   CALL_VertexAttribP1ui(ctx->CurrentServerDispatch, (index, type, normalized, value));
}


/* GetImageHandleARB: marshalled synchronously */
static GLuint64 GLAPIENTRY
_mesa_marshal_GetImageHandleARB(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetImageHandleARB");
   return CALL_GetImageHandleARB(ctx->CurrentServerDispatch, (texture, level, layered, layer, format));
}


/* DeleteLists: marshalled asynchronously */
struct marshal_cmd_DeleteLists
{
   struct marshal_cmd_base cmd_base;
   GLuint list;
   GLsizei range;
};
static inline void
_mesa_unmarshal_DeleteLists(struct gl_context *ctx, const struct marshal_cmd_DeleteLists *cmd)
{
   const GLuint list = cmd->list;
   const GLsizei range = cmd->range;
   CALL_DeleteLists(ctx->CurrentServerDispatch, (list, range));
}
static void GLAPIENTRY
_mesa_marshal_DeleteLists(GLuint list, GLsizei range)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DeleteLists);
   struct marshal_cmd_DeleteLists *cmd;
   debug_print_marshal("DeleteLists");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DeleteLists, cmd_size);
      cmd->list = list;
      cmd->range = range;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DeleteLists");
   CALL_DeleteLists(ctx->CurrentServerDispatch, (list, range));
}


/* LogicOp: marshalled asynchronously */
struct marshal_cmd_LogicOp
{
   struct marshal_cmd_base cmd_base;
   GLenum opcode;
};
static inline void
_mesa_unmarshal_LogicOp(struct gl_context *ctx, const struct marshal_cmd_LogicOp *cmd)
{
   const GLenum opcode = cmd->opcode;
   CALL_LogicOp(ctx->CurrentServerDispatch, (opcode));
}
static void GLAPIENTRY
_mesa_marshal_LogicOp(GLenum opcode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_LogicOp);
   struct marshal_cmd_LogicOp *cmd;
   debug_print_marshal("LogicOp");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_LogicOp, cmd_size);
      cmd->opcode = opcode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("LogicOp");
   CALL_LogicOp(ctx->CurrentServerDispatch, (opcode));
}


/* RenderbufferStorageMultisample: marshalled asynchronously */
struct marshal_cmd_RenderbufferStorageMultisample
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizei samples;
   GLenum internalformat;
   GLsizei width;
   GLsizei height;
};
static inline void
_mesa_unmarshal_RenderbufferStorageMultisample(struct gl_context *ctx, const struct marshal_cmd_RenderbufferStorageMultisample *cmd)
{
   const GLenum target = cmd->target;
   const GLsizei samples = cmd->samples;
   const GLenum internalformat = cmd->internalformat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   CALL_RenderbufferStorageMultisample(ctx->CurrentServerDispatch, (target, samples, internalformat, width, height));
}
static void GLAPIENTRY
_mesa_marshal_RenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RenderbufferStorageMultisample);
   struct marshal_cmd_RenderbufferStorageMultisample *cmd;
   debug_print_marshal("RenderbufferStorageMultisample");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RenderbufferStorageMultisample, cmd_size);
      cmd->target = target;
      cmd->samples = samples;
      cmd->internalformat = internalformat;
      cmd->width = width;
      cmd->height = height;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RenderbufferStorageMultisample");
   CALL_RenderbufferStorageMultisample(ctx->CurrentServerDispatch, (target, samples, internalformat, width, height));
}


/* GetTransformFeedbacki64_v: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTransformFeedbacki64_v(GLuint xfb, GLenum pname, GLuint index, GLint64 * param)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTransformFeedbacki64_v");
   CALL_GetTransformFeedbacki64_v(ctx->CurrentServerDispatch, (xfb, pname, index, param));
}


/* WindowPos3d: marshalled asynchronously */
struct marshal_cmd_WindowPos3d
{
   struct marshal_cmd_base cmd_base;
   GLdouble x;
   GLdouble y;
   GLdouble z;
};
static inline void
_mesa_unmarshal_WindowPos3d(struct gl_context *ctx, const struct marshal_cmd_WindowPos3d *cmd)
{
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   CALL_WindowPos3d(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_WindowPos3d(GLdouble x, GLdouble y, GLdouble z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WindowPos3d);
   struct marshal_cmd_WindowPos3d *cmd;
   debug_print_marshal("WindowPos3d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WindowPos3d, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WindowPos3d");
   CALL_WindowPos3d(ctx->CurrentServerDispatch, (x, y, z));
}


/* Enablei: marshalled asynchronously */
struct marshal_cmd_Enablei
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
};
static inline void
_mesa_unmarshal_Enablei(struct gl_context *ctx, const struct marshal_cmd_Enablei *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   CALL_Enablei(ctx->CurrentServerDispatch, (target, index));
}
static void GLAPIENTRY
_mesa_marshal_Enablei(GLenum target, GLuint index)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Enablei);
   struct marshal_cmd_Enablei *cmd;
   debug_print_marshal("Enablei");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Enablei, cmd_size);
      cmd->target = target;
      cmd->index = index;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Enablei");
   CALL_Enablei(ctx->CurrentServerDispatch, (target, index));
}


/* WindowPos3f: marshalled asynchronously */
struct marshal_cmd_WindowPos3f
{
   struct marshal_cmd_base cmd_base;
   GLfloat x;
   GLfloat y;
   GLfloat z;
};
static inline void
_mesa_unmarshal_WindowPos3f(struct gl_context *ctx, const struct marshal_cmd_WindowPos3f *cmd)
{
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   CALL_WindowPos3f(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_WindowPos3f(GLfloat x, GLfloat y, GLfloat z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WindowPos3f);
   struct marshal_cmd_WindowPos3f *cmd;
   debug_print_marshal("WindowPos3f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WindowPos3f, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WindowPos3f");
   CALL_WindowPos3f(ctx->CurrentServerDispatch, (x, y, z));
}


/* GenProgramsARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GenProgramsARB(GLsizei n, GLuint * programs)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GenProgramsARB");
   CALL_GenProgramsARB(ctx->CurrentServerDispatch, (n, programs));
}


/* RasterPos2sv: marshalled asynchronously */
struct marshal_cmd_RasterPos2sv
{
   struct marshal_cmd_base cmd_base;
   GLshort v[2];
};
static inline void
_mesa_unmarshal_RasterPos2sv(struct gl_context *ctx, const struct marshal_cmd_RasterPos2sv *cmd)
{
   const GLshort * v = cmd->v;
   CALL_RasterPos2sv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos2sv(const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos2sv);
   struct marshal_cmd_RasterPos2sv *cmd;
   debug_print_marshal("RasterPos2sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos2sv, cmd_size);
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos2sv");
   CALL_RasterPos2sv(ctx->CurrentServerDispatch, (v));
}


/* WindowPos3i: marshalled asynchronously */
struct marshal_cmd_WindowPos3i
{
   struct marshal_cmd_base cmd_base;
   GLint x;
   GLint y;
   GLint z;
};
static inline void
_mesa_unmarshal_WindowPos3i(struct gl_context *ctx, const struct marshal_cmd_WindowPos3i *cmd)
{
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLint z = cmd->z;
   CALL_WindowPos3i(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_WindowPos3i(GLint x, GLint y, GLint z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WindowPos3i);
   struct marshal_cmd_WindowPos3i *cmd;
   debug_print_marshal("WindowPos3i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WindowPos3i, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WindowPos3i");
   CALL_WindowPos3i(ctx->CurrentServerDispatch, (x, y, z));
}


/* MultiTexCoord4iv: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord4iv
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLint v[4];
};
static inline void
_mesa_unmarshal_MultiTexCoord4iv(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord4iv *cmd)
{
   const GLenum target = cmd->target;
   const GLint * v = cmd->v;
   CALL_MultiTexCoord4iv(ctx->CurrentServerDispatch, (target, v));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord4iv(GLenum target, const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord4iv);
   struct marshal_cmd_MultiTexCoord4iv *cmd;
   debug_print_marshal("MultiTexCoord4iv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord4iv, cmd_size);
      cmd->target = target;
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord4iv");
   CALL_MultiTexCoord4iv(ctx->CurrentServerDispatch, (target, v));
}


/* TexCoord1sv: marshalled asynchronously */
struct marshal_cmd_TexCoord1sv
{
   struct marshal_cmd_base cmd_base;
   GLshort v[1];
};
static inline void
_mesa_unmarshal_TexCoord1sv(struct gl_context *ctx, const struct marshal_cmd_TexCoord1sv *cmd)
{
   const GLshort * v = cmd->v;
   CALL_TexCoord1sv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord1sv(const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord1sv);
   struct marshal_cmd_TexCoord1sv *cmd;
   debug_print_marshal("TexCoord1sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord1sv, cmd_size);
      memcpy(cmd->v, v, 2);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord1sv");
   CALL_TexCoord1sv(ctx->CurrentServerDispatch, (v));
}


/* WindowPos3s: marshalled asynchronously */
struct marshal_cmd_WindowPos3s
{
   struct marshal_cmd_base cmd_base;
   GLshort x;
   GLshort y;
   GLshort z;
};
static inline void
_mesa_unmarshal_WindowPos3s(struct gl_context *ctx, const struct marshal_cmd_WindowPos3s *cmd)
{
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   const GLshort z = cmd->z;
   CALL_WindowPos3s(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_WindowPos3s(GLshort x, GLshort y, GLshort z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WindowPos3s);
   struct marshal_cmd_WindowPos3s *cmd;
   debug_print_marshal("WindowPos3s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WindowPos3s, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WindowPos3s");
   CALL_WindowPos3s(ctx->CurrentServerDispatch, (x, y, z));
}


/* PixelMapusv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_PixelMapusv(GLenum map, GLsizei mapsize, const GLushort * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("PixelMapusv");
   CALL_PixelMapusv(ctx->CurrentServerDispatch, (map, mapsize, values));
}


/* DebugMessageInsert: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_DebugMessageInsert(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar * buf)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("DebugMessageInsert");
   CALL_DebugMessageInsert(ctx->CurrentServerDispatch, (source, type, id, severity, length, buf));
}


/* Orthof: marshalled asynchronously */
struct marshal_cmd_Orthof
{
   struct marshal_cmd_base cmd_base;
   GLfloat left;
   GLfloat right;
   GLfloat bottom;
   GLfloat top;
   GLfloat zNear;
   GLfloat zFar;
};
static inline void
_mesa_unmarshal_Orthof(struct gl_context *ctx, const struct marshal_cmd_Orthof *cmd)
{
   const GLfloat left = cmd->left;
   const GLfloat right = cmd->right;
   const GLfloat bottom = cmd->bottom;
   const GLfloat top = cmd->top;
   const GLfloat zNear = cmd->zNear;
   const GLfloat zFar = cmd->zFar;
   CALL_Orthof(ctx->CurrentServerDispatch, (left, right, bottom, top, zNear, zFar));
}
static void GLAPIENTRY
_mesa_marshal_Orthof(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top, GLfloat zNear, GLfloat zFar)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Orthof);
   struct marshal_cmd_Orthof *cmd;
   debug_print_marshal("Orthof");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Orthof, cmd_size);
      cmd->left = left;
      cmd->right = right;
      cmd->bottom = bottom;
      cmd->top = top;
      cmd->zNear = zNear;
      cmd->zFar = zFar;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Orthof");
   CALL_Orthof(ctx->CurrentServerDispatch, (left, right, bottom, top, zNear, zFar));
}


/* CompressedTexImage2D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CompressedTexImage2D");
   CALL_CompressedTexImage2D(ctx->CurrentServerDispatch, (target, level, internalformat, width, height, border, imageSize, data));
}


/* DeleteObjectARB: marshalled asynchronously */
struct marshal_cmd_DeleteObjectARB
{
   struct marshal_cmd_base cmd_base;
   GLhandleARB obj;
};
static inline void
_mesa_unmarshal_DeleteObjectARB(struct gl_context *ctx, const struct marshal_cmd_DeleteObjectARB *cmd)
{
   const GLhandleARB obj = cmd->obj;
   CALL_DeleteObjectARB(ctx->CurrentServerDispatch, (obj));
}
static void GLAPIENTRY
_mesa_marshal_DeleteObjectARB(GLhandleARB obj)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DeleteObjectARB);
   struct marshal_cmd_DeleteObjectARB *cmd;
   debug_print_marshal("DeleteObjectARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DeleteObjectARB, cmd_size);
      cmd->obj = obj;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DeleteObjectARB");
   CALL_DeleteObjectARB(ctx->CurrentServerDispatch, (obj));
}


/* ProgramUniformMatrix2x3dv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix2x3dv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 48) bytes are GLdouble value[count][6] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix2x3dv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix2x3dv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 48;
   CALL_ProgramUniformMatrix2x3dv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix2x3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix2x3dv) + safe_mul(count, 48);
   struct marshal_cmd_ProgramUniformMatrix2x3dv *cmd;
   debug_print_marshal("ProgramUniformMatrix2x3dv");
   if (unlikely(safe_mul(count, 48) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix2x3dv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 48);
      variable_data += count * 48;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix2x3dv");
   CALL_ProgramUniformMatrix2x3dv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* GetVertexArrayiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetVertexArrayiv(GLuint vaobj, GLenum pname, GLint * param)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetVertexArrayiv");
   CALL_GetVertexArrayiv(ctx->CurrentServerDispatch, (vaobj, pname, param));
}


/* IsSync: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsSync(GLsync sync)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsSync");
   return CALL_IsSync(ctx->CurrentServerDispatch, (sync));
}


/* Color4uiv: marshalled asynchronously */
struct marshal_cmd_Color4uiv
{
   struct marshal_cmd_base cmd_base;
   GLuint v[4];
};
static inline void
_mesa_unmarshal_Color4uiv(struct gl_context *ctx, const struct marshal_cmd_Color4uiv *cmd)
{
   const GLuint * v = cmd->v;
   CALL_Color4uiv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Color4uiv(const GLuint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color4uiv);
   struct marshal_cmd_Color4uiv *cmd;
   debug_print_marshal("Color4uiv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color4uiv, cmd_size);
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color4uiv");
   CALL_Color4uiv(ctx->CurrentServerDispatch, (v));
}


/* MultiTexCoord1sv: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord1sv
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLshort v[1];
};
static inline void
_mesa_unmarshal_MultiTexCoord1sv(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord1sv *cmd)
{
   const GLenum target = cmd->target;
   const GLshort * v = cmd->v;
   CALL_MultiTexCoord1sv(ctx->CurrentServerDispatch, (target, v));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord1sv(GLenum target, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord1sv);
   struct marshal_cmd_MultiTexCoord1sv *cmd;
   debug_print_marshal("MultiTexCoord1sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord1sv, cmd_size);
      cmd->target = target;
      memcpy(cmd->v, v, 2);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord1sv");
   CALL_MultiTexCoord1sv(ctx->CurrentServerDispatch, (target, v));
}


/* Orthox: marshalled asynchronously */
struct marshal_cmd_Orthox
{
   struct marshal_cmd_base cmd_base;
   GLfixed left;
   GLfixed right;
   GLfixed bottom;
   GLfixed top;
   GLfixed zNear;
   GLfixed zFar;
};
static inline void
_mesa_unmarshal_Orthox(struct gl_context *ctx, const struct marshal_cmd_Orthox *cmd)
{
   const GLfixed left = cmd->left;
   const GLfixed right = cmd->right;
   const GLfixed bottom = cmd->bottom;
   const GLfixed top = cmd->top;
   const GLfixed zNear = cmd->zNear;
   const GLfixed zFar = cmd->zFar;
   CALL_Orthox(ctx->CurrentServerDispatch, (left, right, bottom, top, zNear, zFar));
}
static void GLAPIENTRY
_mesa_marshal_Orthox(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed zNear, GLfixed zFar)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Orthox);
   struct marshal_cmd_Orthox *cmd;
   debug_print_marshal("Orthox");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Orthox, cmd_size);
      cmd->left = left;
      cmd->right = right;
      cmd->bottom = bottom;
      cmd->top = top;
      cmd->zNear = zNear;
      cmd->zFar = zFar;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Orthox");
   CALL_Orthox(ctx->CurrentServerDispatch, (left, right, bottom, top, zNear, zFar));
}


/* PushAttrib: marshalled asynchronously */
struct marshal_cmd_PushAttrib
{
   struct marshal_cmd_base cmd_base;
   GLbitfield mask;
};
static inline void
_mesa_unmarshal_PushAttrib(struct gl_context *ctx, const struct marshal_cmd_PushAttrib *cmd)
{
   const GLbitfield mask = cmd->mask;
   CALL_PushAttrib(ctx->CurrentServerDispatch, (mask));
}
static void GLAPIENTRY
_mesa_marshal_PushAttrib(GLbitfield mask)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PushAttrib);
   struct marshal_cmd_PushAttrib *cmd;
   debug_print_marshal("PushAttrib");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PushAttrib, cmd_size);
      cmd->mask = mask;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PushAttrib");
   CALL_PushAttrib(ctx->CurrentServerDispatch, (mask));
}


/* RasterPos2i: marshalled asynchronously */
struct marshal_cmd_RasterPos2i
{
   struct marshal_cmd_base cmd_base;
   GLint x;
   GLint y;
};
static inline void
_mesa_unmarshal_RasterPos2i(struct gl_context *ctx, const struct marshal_cmd_RasterPos2i *cmd)
{
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   CALL_RasterPos2i(ctx->CurrentServerDispatch, (x, y));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos2i(GLint x, GLint y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos2i);
   struct marshal_cmd_RasterPos2i *cmd;
   debug_print_marshal("RasterPos2i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos2i, cmd_size);
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos2i");
   CALL_RasterPos2i(ctx->CurrentServerDispatch, (x, y));
}


/* ClipPlane: marshalled asynchronously */
struct marshal_cmd_ClipPlane
{
   struct marshal_cmd_base cmd_base;
   GLenum plane;
   GLdouble equation[4];
};
static inline void
_mesa_unmarshal_ClipPlane(struct gl_context *ctx, const struct marshal_cmd_ClipPlane *cmd)
{
   const GLenum plane = cmd->plane;
   const GLdouble * equation = cmd->equation;
   CALL_ClipPlane(ctx->CurrentServerDispatch, (plane, equation));
}
static void GLAPIENTRY
_mesa_marshal_ClipPlane(GLenum plane, const GLdouble * equation)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClipPlane);
   struct marshal_cmd_ClipPlane *cmd;
   debug_print_marshal("ClipPlane");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClipPlane, cmd_size);
      cmd->plane = plane;
      memcpy(cmd->equation, equation, 32);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClipPlane");
   CALL_ClipPlane(ctx->CurrentServerDispatch, (plane, equation));
}


/* RasterPos2f: marshalled asynchronously */
struct marshal_cmd_RasterPos2f
{
   struct marshal_cmd_base cmd_base;
   GLfloat x;
   GLfloat y;
};
static inline void
_mesa_unmarshal_RasterPos2f(struct gl_context *ctx, const struct marshal_cmd_RasterPos2f *cmd)
{
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   CALL_RasterPos2f(ctx->CurrentServerDispatch, (x, y));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos2f(GLfloat x, GLfloat y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos2f);
   struct marshal_cmd_RasterPos2f *cmd;
   debug_print_marshal("RasterPos2f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos2f, cmd_size);
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos2f");
   CALL_RasterPos2f(ctx->CurrentServerDispatch, (x, y));
}


/* GetActiveSubroutineUniformiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetActiveSubroutineUniformiv(GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetActiveSubroutineUniformiv");
   CALL_GetActiveSubroutineUniformiv(ctx->CurrentServerDispatch, (program, shadertype, index, pname, values));
}


/* RasterPos2d: marshalled asynchronously */
struct marshal_cmd_RasterPos2d
{
   struct marshal_cmd_base cmd_base;
   GLdouble x;
   GLdouble y;
};
static inline void
_mesa_unmarshal_RasterPos2d(struct gl_context *ctx, const struct marshal_cmd_RasterPos2d *cmd)
{
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   CALL_RasterPos2d(ctx->CurrentServerDispatch, (x, y));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos2d(GLdouble x, GLdouble y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos2d);
   struct marshal_cmd_RasterPos2d *cmd;
   debug_print_marshal("RasterPos2d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos2d, cmd_size);
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos2d");
   CALL_RasterPos2d(ctx->CurrentServerDispatch, (x, y));
}


/* MakeImageHandleResidentARB: marshalled asynchronously */
struct marshal_cmd_MakeImageHandleResidentARB
{
   struct marshal_cmd_base cmd_base;
   GLuint64 handle;
   GLenum access;
};
static inline void
_mesa_unmarshal_MakeImageHandleResidentARB(struct gl_context *ctx, const struct marshal_cmd_MakeImageHandleResidentARB *cmd)
{
   const GLuint64 handle = cmd->handle;
   const GLenum access = cmd->access;
   CALL_MakeImageHandleResidentARB(ctx->CurrentServerDispatch, (handle, access));
}
static void GLAPIENTRY
_mesa_marshal_MakeImageHandleResidentARB(GLuint64 handle, GLenum access)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MakeImageHandleResidentARB);
   struct marshal_cmd_MakeImageHandleResidentARB *cmd;
   debug_print_marshal("MakeImageHandleResidentARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MakeImageHandleResidentARB, cmd_size);
      cmd->handle = handle;
      cmd->access = access;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MakeImageHandleResidentARB");
   CALL_MakeImageHandleResidentARB(ctx->CurrentServerDispatch, (handle, access));
}


/* InvalidateSubFramebuffer: marshalled asynchronously */
struct marshal_cmd_InvalidateSubFramebuffer
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizei numAttachments;
   GLint x;
   GLint y;
   GLsizei width;
   GLsizei height;
   /* Next safe_mul(numAttachments, 4) bytes are GLenum attachments[numAttachments] */
};
static inline void
_mesa_unmarshal_InvalidateSubFramebuffer(struct gl_context *ctx, const struct marshal_cmd_InvalidateSubFramebuffer *cmd)
{
   const GLenum target = cmd->target;
   const GLsizei numAttachments = cmd->numAttachments;
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLenum * attachments;
   const char *variable_data = (const char *) (cmd + 1);
   attachments = (const GLenum *) variable_data;
   variable_data += numAttachments * 4;
   CALL_InvalidateSubFramebuffer(ctx->CurrentServerDispatch, (target, numAttachments, attachments, x, y, width, height));
}
static void GLAPIENTRY
_mesa_marshal_InvalidateSubFramebuffer(GLenum target, GLsizei numAttachments, const GLenum * attachments, GLint x, GLint y, GLsizei width, GLsizei height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_InvalidateSubFramebuffer) + safe_mul(numAttachments, 4);
   struct marshal_cmd_InvalidateSubFramebuffer *cmd;
   debug_print_marshal("InvalidateSubFramebuffer");
   if (unlikely(safe_mul(numAttachments, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_InvalidateSubFramebuffer, cmd_size);
      cmd->target = target;
      cmd->numAttachments = numAttachments;
      cmd->x = x;
      cmd->y = y;
      cmd->width = width;
      cmd->height = height;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, attachments, numAttachments * 4);
      variable_data += numAttachments * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("InvalidateSubFramebuffer");
   CALL_InvalidateSubFramebuffer(ctx->CurrentServerDispatch, (target, numAttachments, attachments, x, y, width, height));
}


/* Color4ub: marshalled asynchronously */
struct marshal_cmd_Color4ub
{
   struct marshal_cmd_base cmd_base;
   GLubyte red;
   GLubyte green;
   GLubyte blue;
   GLubyte alpha;
};
static inline void
_mesa_unmarshal_Color4ub(struct gl_context *ctx, const struct marshal_cmd_Color4ub *cmd)
{
   const GLubyte red = cmd->red;
   const GLubyte green = cmd->green;
   const GLubyte blue = cmd->blue;
   const GLubyte alpha = cmd->alpha;
   CALL_Color4ub(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}
static void GLAPIENTRY
_mesa_marshal_Color4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color4ub);
   struct marshal_cmd_Color4ub *cmd;
   debug_print_marshal("Color4ub");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color4ub, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      cmd->alpha = alpha;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color4ub");
   CALL_Color4ub(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}


/* UniformMatrix2x4dv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix2x4dv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 64) bytes are GLdouble value[count][8] */
};
static inline void
_mesa_unmarshal_UniformMatrix2x4dv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix2x4dv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 64;
   CALL_UniformMatrix2x4dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix2x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix2x4dv) + safe_mul(count, 64);
   struct marshal_cmd_UniformMatrix2x4dv *cmd;
   debug_print_marshal("UniformMatrix2x4dv");
   if (unlikely(safe_mul(count, 64) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix2x4dv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 64);
      variable_data += count * 64;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix2x4dv");
   CALL_UniformMatrix2x4dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* RasterPos2s: marshalled asynchronously */
struct marshal_cmd_RasterPos2s
{
   struct marshal_cmd_base cmd_base;
   GLshort x;
   GLshort y;
};
static inline void
_mesa_unmarshal_RasterPos2s(struct gl_context *ctx, const struct marshal_cmd_RasterPos2s *cmd)
{
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   CALL_RasterPos2s(ctx->CurrentServerDispatch, (x, y));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos2s(GLshort x, GLshort y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos2s);
   struct marshal_cmd_RasterPos2s *cmd;
   debug_print_marshal("RasterPos2s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos2s, cmd_size);
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos2s");
   CALL_RasterPos2s(ctx->CurrentServerDispatch, (x, y));
}


/* DispatchComputeGroupSizeARB: marshalled asynchronously */
struct marshal_cmd_DispatchComputeGroupSizeARB
{
   struct marshal_cmd_base cmd_base;
   GLuint num_groups_x;
   GLuint num_groups_y;
   GLuint num_groups_z;
   GLuint group_size_x;
   GLuint group_size_y;
   GLuint group_size_z;
};
static inline void
_mesa_unmarshal_DispatchComputeGroupSizeARB(struct gl_context *ctx, const struct marshal_cmd_DispatchComputeGroupSizeARB *cmd)
{
   const GLuint num_groups_x = cmd->num_groups_x;
   const GLuint num_groups_y = cmd->num_groups_y;
   const GLuint num_groups_z = cmd->num_groups_z;
   const GLuint group_size_x = cmd->group_size_x;
   const GLuint group_size_y = cmd->group_size_y;
   const GLuint group_size_z = cmd->group_size_z;
   CALL_DispatchComputeGroupSizeARB(ctx->CurrentServerDispatch, (num_groups_x, num_groups_y, num_groups_z, group_size_x, group_size_y, group_size_z));
}
static void GLAPIENTRY
_mesa_marshal_DispatchComputeGroupSizeARB(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, GLuint group_size_x, GLuint group_size_y, GLuint group_size_z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DispatchComputeGroupSizeARB);
   struct marshal_cmd_DispatchComputeGroupSizeARB *cmd;
   debug_print_marshal("DispatchComputeGroupSizeARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DispatchComputeGroupSizeARB, cmd_size);
      cmd->num_groups_x = num_groups_x;
      cmd->num_groups_y = num_groups_y;
      cmd->num_groups_z = num_groups_z;
      cmd->group_size_x = group_size_x;
      cmd->group_size_y = group_size_y;
      cmd->group_size_z = group_size_z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DispatchComputeGroupSizeARB");
   CALL_DispatchComputeGroupSizeARB(ctx->CurrentServerDispatch, (num_groups_x, num_groups_y, num_groups_z, group_size_x, group_size_y, group_size_z));
}


/* VertexP2uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexP2uiv(GLenum type, const GLuint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexP2uiv");
   CALL_VertexP2uiv(ctx->CurrentServerDispatch, (type, value));
}


/* VertexArrayBindingDivisor: marshalled asynchronously */
struct marshal_cmd_VertexArrayBindingDivisor
{
   struct marshal_cmd_base cmd_base;
   GLuint vaobj;
   GLuint bindingindex;
   GLuint divisor;
};
static inline void
_mesa_unmarshal_VertexArrayBindingDivisor(struct gl_context *ctx, const struct marshal_cmd_VertexArrayBindingDivisor *cmd)
{
   const GLuint vaobj = cmd->vaobj;
   const GLuint bindingindex = cmd->bindingindex;
   const GLuint divisor = cmd->divisor;
   CALL_VertexArrayBindingDivisor(ctx->CurrentServerDispatch, (vaobj, bindingindex, divisor));
}
static void GLAPIENTRY
_mesa_marshal_VertexArrayBindingDivisor(GLuint vaobj, GLuint bindingindex, GLuint divisor)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexArrayBindingDivisor);
   struct marshal_cmd_VertexArrayBindingDivisor *cmd;
   debug_print_marshal("VertexArrayBindingDivisor");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexArrayBindingDivisor, cmd_size);
      cmd->vaobj = vaobj;
      cmd->bindingindex = bindingindex;
      cmd->divisor = divisor;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexArrayBindingDivisor");
   CALL_VertexArrayBindingDivisor(ctx->CurrentServerDispatch, (vaobj, bindingindex, divisor));
}


/* MultiTexCoord3dv: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord3dv
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLdouble v[3];
};
static inline void
_mesa_unmarshal_MultiTexCoord3dv(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord3dv *cmd)
{
   const GLenum target = cmd->target;
   const GLdouble * v = cmd->v;
   CALL_MultiTexCoord3dv(ctx->CurrentServerDispatch, (target, v));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord3dv(GLenum target, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord3dv);
   struct marshal_cmd_MultiTexCoord3dv *cmd;
   debug_print_marshal("MultiTexCoord3dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord3dv, cmd_size);
      cmd->target = target;
      memcpy(cmd->v, v, 24);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord3dv");
   CALL_MultiTexCoord3dv(ctx->CurrentServerDispatch, (target, v));
}


/* BindProgramPipeline: marshalled asynchronously */
struct marshal_cmd_BindProgramPipeline
{
   struct marshal_cmd_base cmd_base;
   GLuint pipeline;
};
static inline void
_mesa_unmarshal_BindProgramPipeline(struct gl_context *ctx, const struct marshal_cmd_BindProgramPipeline *cmd)
{
   const GLuint pipeline = cmd->pipeline;
   CALL_BindProgramPipeline(ctx->CurrentServerDispatch, (pipeline));
}
static void GLAPIENTRY
_mesa_marshal_BindProgramPipeline(GLuint pipeline)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindProgramPipeline);
   struct marshal_cmd_BindProgramPipeline *cmd;
   debug_print_marshal("BindProgramPipeline");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindProgramPipeline, cmd_size);
      cmd->pipeline = pipeline;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindProgramPipeline");
   CALL_BindProgramPipeline(ctx->CurrentServerDispatch, (pipeline));
}


/* VertexAttribP4uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribP4uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribP4uiv");
   CALL_VertexAttribP4uiv(ctx->CurrentServerDispatch, (index, type, normalized, value));
}


/* DebugMessageCallback: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_DebugMessageCallback(GLDEBUGPROC callback, const GLvoid * userParam)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("DebugMessageCallback");
   CALL_DebugMessageCallback(ctx->CurrentServerDispatch, (callback, userParam));
}


/* MultiTexCoord1i: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord1i
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLint s;
};
static inline void
_mesa_unmarshal_MultiTexCoord1i(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord1i *cmd)
{
   const GLenum target = cmd->target;
   const GLint s = cmd->s;
   CALL_MultiTexCoord1i(ctx->CurrentServerDispatch, (target, s));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord1i(GLenum target, GLint s)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord1i);
   struct marshal_cmd_MultiTexCoord1i *cmd;
   debug_print_marshal("MultiTexCoord1i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord1i, cmd_size);
      cmd->target = target;
      cmd->s = s;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord1i");
   CALL_MultiTexCoord1i(ctx->CurrentServerDispatch, (target, s));
}


/* WindowPos2dv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_WindowPos2dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("WindowPos2dv");
   CALL_WindowPos2dv(ctx->CurrentServerDispatch, (v));
}


/* TexParameterIuiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexParameterIuiv(GLenum target, GLenum pname, const GLuint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexParameterIuiv");
   CALL_TexParameterIuiv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* DeletePerfQueryINTEL: marshalled asynchronously */
struct marshal_cmd_DeletePerfQueryINTEL
{
   struct marshal_cmd_base cmd_base;
   GLuint queryHandle;
};
static inline void
_mesa_unmarshal_DeletePerfQueryINTEL(struct gl_context *ctx, const struct marshal_cmd_DeletePerfQueryINTEL *cmd)
{
   const GLuint queryHandle = cmd->queryHandle;
   CALL_DeletePerfQueryINTEL(ctx->CurrentServerDispatch, (queryHandle));
}
static void GLAPIENTRY
_mesa_marshal_DeletePerfQueryINTEL(GLuint queryHandle)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DeletePerfQueryINTEL);
   struct marshal_cmd_DeletePerfQueryINTEL *cmd;
   debug_print_marshal("DeletePerfQueryINTEL");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DeletePerfQueryINTEL, cmd_size);
      cmd->queryHandle = queryHandle;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DeletePerfQueryINTEL");
   CALL_DeletePerfQueryINTEL(ctx->CurrentServerDispatch, (queryHandle));
}


/* MultiTexCoord1d: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord1d
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLdouble s;
};
static inline void
_mesa_unmarshal_MultiTexCoord1d(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord1d *cmd)
{
   const GLenum target = cmd->target;
   const GLdouble s = cmd->s;
   CALL_MultiTexCoord1d(ctx->CurrentServerDispatch, (target, s));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord1d(GLenum target, GLdouble s)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord1d);
   struct marshal_cmd_MultiTexCoord1d *cmd;
   debug_print_marshal("MultiTexCoord1d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord1d, cmd_size);
      cmd->target = target;
      cmd->s = s;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord1d");
   CALL_MultiTexCoord1d(ctx->CurrentServerDispatch, (target, s));
}


/* MultiTexCoord1s: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord1s
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLshort s;
};
static inline void
_mesa_unmarshal_MultiTexCoord1s(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord1s *cmd)
{
   const GLenum target = cmd->target;
   const GLshort s = cmd->s;
   CALL_MultiTexCoord1s(ctx->CurrentServerDispatch, (target, s));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord1s(GLenum target, GLshort s)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord1s);
   struct marshal_cmd_MultiTexCoord1s *cmd;
   debug_print_marshal("MultiTexCoord1s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord1s, cmd_size);
      cmd->target = target;
      cmd->s = s;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord1s");
   CALL_MultiTexCoord1s(ctx->CurrentServerDispatch, (target, s));
}


/* BeginConditionalRender: marshalled asynchronously */
struct marshal_cmd_BeginConditionalRender
{
   struct marshal_cmd_base cmd_base;
   GLuint query;
   GLenum mode;
};
static inline void
_mesa_unmarshal_BeginConditionalRender(struct gl_context *ctx, const struct marshal_cmd_BeginConditionalRender *cmd)
{
   const GLuint query = cmd->query;
   const GLenum mode = cmd->mode;
   CALL_BeginConditionalRender(ctx->CurrentServerDispatch, (query, mode));
}
static void GLAPIENTRY
_mesa_marshal_BeginConditionalRender(GLuint query, GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BeginConditionalRender);
   struct marshal_cmd_BeginConditionalRender *cmd;
   debug_print_marshal("BeginConditionalRender");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BeginConditionalRender, cmd_size);
      cmd->query = query;
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BeginConditionalRender");
   CALL_BeginConditionalRender(ctx->CurrentServerDispatch, (query, mode));
}


/* GetShaderiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetShaderiv(GLuint shader, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetShaderiv");
   CALL_GetShaderiv(ctx->CurrentServerDispatch, (shader, pname, params));
}


/* CopyConvolutionFilter1D: marshalled asynchronously */
struct marshal_cmd_CopyConvolutionFilter1D
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum internalformat;
   GLint x;
   GLint y;
   GLsizei width;
};
static inline void
_mesa_unmarshal_CopyConvolutionFilter1D(struct gl_context *ctx, const struct marshal_cmd_CopyConvolutionFilter1D *cmd)
{
   const GLenum target = cmd->target;
   const GLenum internalformat = cmd->internalformat;
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLsizei width = cmd->width;
   CALL_CopyConvolutionFilter1D(ctx->CurrentServerDispatch, (target, internalformat, x, y, width));
}
static void GLAPIENTRY
_mesa_marshal_CopyConvolutionFilter1D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_CopyConvolutionFilter1D);
   struct marshal_cmd_CopyConvolutionFilter1D *cmd;
   debug_print_marshal("CopyConvolutionFilter1D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_CopyConvolutionFilter1D, cmd_size);
      cmd->target = target;
      cmd->internalformat = internalformat;
      cmd->x = x;
      cmd->y = y;
      cmd->width = width;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("CopyConvolutionFilter1D");
   CALL_CopyConvolutionFilter1D(ctx->CurrentServerDispatch, (target, internalformat, x, y, width));
}


/* UniformMatrix4dv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix4dv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 128) bytes are GLdouble value[count][16] */
};
static inline void
_mesa_unmarshal_UniformMatrix4dv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix4dv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 128;
   CALL_UniformMatrix4dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix4dv) + safe_mul(count, 128);
   struct marshal_cmd_UniformMatrix4dv *cmd;
   debug_print_marshal("UniformMatrix4dv");
   if (unlikely(safe_mul(count, 128) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix4dv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 128);
      variable_data += count * 128;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix4dv");
   CALL_UniformMatrix4dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* CreateShaderObjectARB: marshalled synchronously */
static GLhandleARB GLAPIENTRY
_mesa_marshal_CreateShaderObjectARB(GLenum shaderType)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CreateShaderObjectARB");
   return CALL_CreateShaderObjectARB(ctx->CurrentServerDispatch, (shaderType));
}


/* GetTexParameterxv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTexParameterxv(GLenum target, GLenum pname, GLfixed * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTexParameterxv");
   CALL_GetTexParameterxv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* GetAttachedShaders: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei * count, GLuint * obj)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetAttachedShaders");
   CALL_GetAttachedShaders(ctx->CurrentServerDispatch, (program, maxCount, count, obj));
}


/* Materialiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_Materialiv(GLenum face, GLenum pname, const GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("Materialiv");
   CALL_Materialiv(ctx->CurrentServerDispatch, (face, pname, params));
}


/* DeleteFragmentShaderATI: marshalled asynchronously */
struct marshal_cmd_DeleteFragmentShaderATI
{
   struct marshal_cmd_base cmd_base;
   GLuint id;
};
static inline void
_mesa_unmarshal_DeleteFragmentShaderATI(struct gl_context *ctx, const struct marshal_cmd_DeleteFragmentShaderATI *cmd)
{
   const GLuint id = cmd->id;
   CALL_DeleteFragmentShaderATI(ctx->CurrentServerDispatch, (id));
}
static void GLAPIENTRY
_mesa_marshal_DeleteFragmentShaderATI(GLuint id)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DeleteFragmentShaderATI);
   struct marshal_cmd_DeleteFragmentShaderATI *cmd;
   debug_print_marshal("DeleteFragmentShaderATI");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DeleteFragmentShaderATI, cmd_size);
      cmd->id = id;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DeleteFragmentShaderATI");
   CALL_DeleteFragmentShaderATI(ctx->CurrentServerDispatch, (id));
}


/* VertexArrayVertexBuffers: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexArrayVertexBuffers(GLuint vaobj, GLuint first, GLsizei count, const GLuint * buffers, const GLintptr * offsets, const GLsizei * strides)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexArrayVertexBuffers");
   CALL_VertexArrayVertexBuffers(ctx->CurrentServerDispatch, (vaobj, first, count, buffers, offsets, strides));
}


/* DrawElementsInstancedBaseVertex: marshalled asynchronously */
struct marshal_cmd_DrawElementsInstancedBaseVertex
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
   GLsizei count;
   GLenum type;
   const GLvoid * indices;
   GLsizei primcount;
   GLint basevertex;
};
static inline void
_mesa_unmarshal_DrawElementsInstancedBaseVertex(struct gl_context *ctx, const struct marshal_cmd_DrawElementsInstancedBaseVertex *cmd)
{
   const GLenum mode = cmd->mode;
   const GLsizei count = cmd->count;
   const GLenum type = cmd->type;
   const GLvoid * indices = cmd->indices;
   const GLsizei primcount = cmd->primcount;
   const GLint basevertex = cmd->basevertex;
   CALL_DrawElementsInstancedBaseVertex(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount, basevertex));
}
static void GLAPIENTRY
_mesa_marshal_DrawElementsInstancedBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, GLsizei primcount, GLint basevertex)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawElementsInstancedBaseVertex);
   struct marshal_cmd_DrawElementsInstancedBaseVertex *cmd;
   debug_print_marshal("DrawElementsInstancedBaseVertex");
   if (_mesa_glthread_is_non_vbo_draw_elements(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("DrawElementsInstancedBaseVertex");
      CALL_DrawElementsInstancedBaseVertex(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount, basevertex));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawElementsInstancedBaseVertex, cmd_size);
      cmd->mode = mode;
      cmd->count = count;
      cmd->type = type;
      cmd->indices = indices;
      cmd->primcount = primcount;
      cmd->basevertex = basevertex;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawElementsInstancedBaseVertex");
   CALL_DrawElementsInstancedBaseVertex(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount, basevertex));
}


/* DisableClientState: marshalled asynchronously */
struct marshal_cmd_DisableClientState
{
   struct marshal_cmd_base cmd_base;
   GLenum array;
};
static inline void
_mesa_unmarshal_DisableClientState(struct gl_context *ctx, const struct marshal_cmd_DisableClientState *cmd)
{
   const GLenum array = cmd->array;
   CALL_DisableClientState(ctx->CurrentServerDispatch, (array));
}
static void GLAPIENTRY
_mesa_marshal_DisableClientState(GLenum array)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DisableClientState);
   struct marshal_cmd_DisableClientState *cmd;
   debug_print_marshal("DisableClientState");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DisableClientState, cmd_size);
      cmd->array = array;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DisableClientState");
   CALL_DisableClientState(ctx->CurrentServerDispatch, (array));
}


/* TexGeni: marshalled asynchronously */
struct marshal_cmd_TexGeni
{
   struct marshal_cmd_base cmd_base;
   GLenum coord;
   GLenum pname;
   GLint param;
};
static inline void
_mesa_unmarshal_TexGeni(struct gl_context *ctx, const struct marshal_cmd_TexGeni *cmd)
{
   const GLenum coord = cmd->coord;
   const GLenum pname = cmd->pname;
   const GLint param = cmd->param;
   CALL_TexGeni(ctx->CurrentServerDispatch, (coord, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_TexGeni(GLenum coord, GLenum pname, GLint param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexGeni);
   struct marshal_cmd_TexGeni *cmd;
   debug_print_marshal("TexGeni");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexGeni, cmd_size);
      cmd->coord = coord;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexGeni");
   CALL_TexGeni(ctx->CurrentServerDispatch, (coord, pname, param));
}


/* TexGenf: marshalled asynchronously */
struct marshal_cmd_TexGenf
{
   struct marshal_cmd_base cmd_base;
   GLenum coord;
   GLenum pname;
   GLfloat param;
};
static inline void
_mesa_unmarshal_TexGenf(struct gl_context *ctx, const struct marshal_cmd_TexGenf *cmd)
{
   const GLenum coord = cmd->coord;
   const GLenum pname = cmd->pname;
   const GLfloat param = cmd->param;
   CALL_TexGenf(ctx->CurrentServerDispatch, (coord, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_TexGenf(GLenum coord, GLenum pname, GLfloat param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexGenf);
   struct marshal_cmd_TexGenf *cmd;
   debug_print_marshal("TexGenf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexGenf, cmd_size);
      cmd->coord = coord;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexGenf");
   CALL_TexGenf(ctx->CurrentServerDispatch, (coord, pname, param));
}


/* TexGend: marshalled asynchronously */
struct marshal_cmd_TexGend
{
   struct marshal_cmd_base cmd_base;
   GLenum coord;
   GLenum pname;
   GLdouble param;
};
static inline void
_mesa_unmarshal_TexGend(struct gl_context *ctx, const struct marshal_cmd_TexGend *cmd)
{
   const GLenum coord = cmd->coord;
   const GLenum pname = cmd->pname;
   const GLdouble param = cmd->param;
   CALL_TexGend(ctx->CurrentServerDispatch, (coord, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_TexGend(GLenum coord, GLenum pname, GLdouble param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexGend);
   struct marshal_cmd_TexGend *cmd;
   debug_print_marshal("TexGend");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexGend, cmd_size);
      cmd->coord = coord;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexGend");
   CALL_TexGend(ctx->CurrentServerDispatch, (coord, pname, param));
}


/* ProgramUniform4i64vARB: marshalled asynchronously */
struct marshal_cmd_ProgramUniform4i64vARB
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 32) bytes are GLint64 value[count][4] */
};
static inline void
_mesa_unmarshal_ProgramUniform4i64vARB(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform4i64vARB *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLint64 * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLint64 *) variable_data;
   variable_data += count * 32;
   CALL_ProgramUniform4i64vARB(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform4i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform4i64vARB) + safe_mul(count, 32);
   struct marshal_cmd_ProgramUniform4i64vARB *cmd;
   debug_print_marshal("ProgramUniform4i64vARB");
   if (unlikely(safe_mul(count, 32) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform4i64vARB, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 32);
      variable_data += count * 32;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform4i64vARB");
   CALL_ProgramUniform4i64vARB(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* Color4sv: marshalled asynchronously */
struct marshal_cmd_Color4sv
{
   struct marshal_cmd_base cmd_base;
   GLshort v[4];
};
static inline void
_mesa_unmarshal_Color4sv(struct gl_context *ctx, const struct marshal_cmd_Color4sv *cmd)
{
   const GLshort * v = cmd->v;
   CALL_Color4sv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Color4sv(const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color4sv);
   struct marshal_cmd_Color4sv *cmd;
   debug_print_marshal("Color4sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color4sv, cmd_size);
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color4sv");
   CALL_Color4sv(ctx->CurrentServerDispatch, (v));
}


/* LoadTransposeMatrixf: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_LoadTransposeMatrixf(const GLfloat * m)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("LoadTransposeMatrixf");
   CALL_LoadTransposeMatrixf(ctx->CurrentServerDispatch, (m));
}


/* LoadTransposeMatrixd: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_LoadTransposeMatrixd(const GLdouble * m)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("LoadTransposeMatrixd");
   CALL_LoadTransposeMatrixd(ctx->CurrentServerDispatch, (m));
}


/* PixelZoom: marshalled asynchronously */
struct marshal_cmd_PixelZoom
{
   struct marshal_cmd_base cmd_base;
   GLfloat xfactor;
   GLfloat yfactor;
};
static inline void
_mesa_unmarshal_PixelZoom(struct gl_context *ctx, const struct marshal_cmd_PixelZoom *cmd)
{
   const GLfloat xfactor = cmd->xfactor;
   const GLfloat yfactor = cmd->yfactor;
   CALL_PixelZoom(ctx->CurrentServerDispatch, (xfactor, yfactor));
}
static void GLAPIENTRY
_mesa_marshal_PixelZoom(GLfloat xfactor, GLfloat yfactor)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PixelZoom);
   struct marshal_cmd_PixelZoom *cmd;
   debug_print_marshal("PixelZoom");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PixelZoom, cmd_size);
      cmd->xfactor = xfactor;
      cmd->yfactor = yfactor;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PixelZoom");
   CALL_PixelZoom(ctx->CurrentServerDispatch, (xfactor, yfactor));
}


/* ProgramEnvParameter4dARB: marshalled asynchronously */
struct marshal_cmd_ProgramEnvParameter4dARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
   GLdouble x;
   GLdouble y;
   GLdouble z;
   GLdouble w;
};
static inline void
_mesa_unmarshal_ProgramEnvParameter4dARB(struct gl_context *ctx, const struct marshal_cmd_ProgramEnvParameter4dARB *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   const GLdouble w = cmd->w;
   CALL_ProgramEnvParameter4dARB(ctx->CurrentServerDispatch, (target, index, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_ProgramEnvParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramEnvParameter4dARB);
   struct marshal_cmd_ProgramEnvParameter4dARB *cmd;
   debug_print_marshal("ProgramEnvParameter4dARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramEnvParameter4dARB, cmd_size);
      cmd->target = target;
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramEnvParameter4dARB");
   CALL_ProgramEnvParameter4dARB(ctx->CurrentServerDispatch, (target, index, x, y, z, w));
}


/* ColorTableParameterfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ColorTableParameterfv(GLenum target, GLenum pname, const GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ColorTableParameterfv");
   CALL_ColorTableParameterfv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* IsSemaphoreEXT: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsSemaphoreEXT(GLuint semaphore)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsSemaphoreEXT");
   return CALL_IsSemaphoreEXT(ctx->CurrentServerDispatch, (semaphore));
}


/* IsTexture: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsTexture(GLuint texture)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsTexture");
   return CALL_IsTexture(ctx->CurrentServerDispatch, (texture));
}


/* ProgramUniform3uiv: marshalled asynchronously */
struct marshal_cmd_ProgramUniform3uiv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 12) bytes are GLuint value[count][3] */
};
static inline void
_mesa_unmarshal_ProgramUniform3uiv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform3uiv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLuint * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLuint *) variable_data;
   variable_data += count * 12;
   CALL_ProgramUniform3uiv(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform3uiv(GLuint program, GLint location, GLsizei count, const GLuint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform3uiv) + safe_mul(count, 12);
   struct marshal_cmd_ProgramUniform3uiv *cmd;
   debug_print_marshal("ProgramUniform3uiv");
   if (unlikely(safe_mul(count, 12) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform3uiv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 12);
      variable_data += count * 12;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform3uiv");
   CALL_ProgramUniform3uiv(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* IndexPointer: marshalled asynchronously */
struct marshal_cmd_IndexPointer
{
   struct marshal_cmd_base cmd_base;
   GLenum type;
   GLsizei stride;
   const GLvoid * pointer;
};
static inline void
_mesa_unmarshal_IndexPointer(struct gl_context *ctx, const struct marshal_cmd_IndexPointer *cmd)
{
   const GLenum type = cmd->type;
   const GLsizei stride = cmd->stride;
   const GLvoid * pointer = cmd->pointer;
   CALL_IndexPointer(ctx->CurrentServerDispatch, (type, stride, pointer));
}
static void GLAPIENTRY
_mesa_marshal_IndexPointer(GLenum type, GLsizei stride, const GLvoid * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_IndexPointer);
   struct marshal_cmd_IndexPointer *cmd;
   debug_print_marshal("IndexPointer");
   if (_mesa_glthread_is_non_vbo_vertex_attrib_pointer(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("IndexPointer");
      CALL_IndexPointer(ctx->CurrentServerDispatch, (type, stride, pointer));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_IndexPointer, cmd_size);
      cmd->type = type;
      cmd->stride = stride;
      cmd->pointer = pointer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("IndexPointer");
   CALL_IndexPointer(ctx->CurrentServerDispatch, (type, stride, pointer));
}


/* VertexAttrib4sNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4sNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort x;
   GLshort y;
   GLshort z;
   GLshort w;
};
static inline void
_mesa_unmarshal_VertexAttrib4sNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4sNV *cmd)
{
   const GLuint index = cmd->index;
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   const GLshort z = cmd->z;
   const GLshort w = cmd->w;
   CALL_VertexAttrib4sNV(ctx->CurrentServerDispatch, (index, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4sNV(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4sNV);
   struct marshal_cmd_VertexAttrib4sNV *cmd;
   debug_print_marshal("VertexAttrib4sNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4sNV, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4sNV");
   CALL_VertexAttrib4sNV(ctx->CurrentServerDispatch, (index, x, y, z, w));
}


/* GetMapdv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetMapdv(GLenum target, GLenum query, GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetMapdv");
   CALL_GetMapdv(ctx->CurrentServerDispatch, (target, query, v));
}


/* Uniform3ui64vARB: marshalled asynchronously */
struct marshal_cmd_Uniform3ui64vARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 24) bytes are GLuint64 value[count][3] */
};
static inline void
_mesa_unmarshal_Uniform3ui64vARB(struct gl_context *ctx, const struct marshal_cmd_Uniform3ui64vARB *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLuint64 * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLuint64 *) variable_data;
   variable_data += count * 24;
   CALL_Uniform3ui64vARB(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform3ui64vARB(GLint location, GLsizei count, const GLuint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform3ui64vARB) + safe_mul(count, 24);
   struct marshal_cmd_Uniform3ui64vARB *cmd;
   debug_print_marshal("Uniform3ui64vARB");
   if (unlikely(safe_mul(count, 24) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform3ui64vARB, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 24);
      variable_data += count * 24;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform3ui64vARB");
   CALL_Uniform3ui64vARB(ctx->CurrentServerDispatch, (location, count, value));
}


/* GetInteger64i_v: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetInteger64i_v(GLenum cap, GLuint index, GLint64 * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetInteger64i_v");
   CALL_GetInteger64i_v(ctx->CurrentServerDispatch, (cap, index, data));
}


/* BufferPageCommitmentARB: marshalled asynchronously */
struct marshal_cmd_BufferPageCommitmentARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLintptr offset;
   GLsizeiptr size;
   GLboolean commit;
};
static inline void
_mesa_unmarshal_BufferPageCommitmentARB(struct gl_context *ctx, const struct marshal_cmd_BufferPageCommitmentARB *cmd)
{
   const GLenum target = cmd->target;
   const GLintptr offset = cmd->offset;
   const GLsizeiptr size = cmd->size;
   const GLboolean commit = cmd->commit;
   CALL_BufferPageCommitmentARB(ctx->CurrentServerDispatch, (target, offset, size, commit));
}
static void GLAPIENTRY
_mesa_marshal_BufferPageCommitmentARB(GLenum target, GLintptr offset, GLsizeiptr size, GLboolean commit)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BufferPageCommitmentARB);
   struct marshal_cmd_BufferPageCommitmentARB *cmd;
   debug_print_marshal("BufferPageCommitmentARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BufferPageCommitmentARB, cmd_size);
      cmd->target = target;
      cmd->offset = offset;
      cmd->size = size;
      cmd->commit = commit;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BufferPageCommitmentARB");
   CALL_BufferPageCommitmentARB(ctx->CurrentServerDispatch, (target, offset, size, commit));
}


/* IsBuffer: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsBuffer(GLuint buffer)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsBuffer");
   return CALL_IsBuffer(ctx->CurrentServerDispatch, (buffer));
}


/* ColorP4ui: marshalled asynchronously */
struct marshal_cmd_ColorP4ui
{
   struct marshal_cmd_base cmd_base;
   GLenum type;
   GLuint color;
};
static inline void
_mesa_unmarshal_ColorP4ui(struct gl_context *ctx, const struct marshal_cmd_ColorP4ui *cmd)
{
   const GLenum type = cmd->type;
   const GLuint color = cmd->color;
   CALL_ColorP4ui(ctx->CurrentServerDispatch, (type, color));
}
static void GLAPIENTRY
_mesa_marshal_ColorP4ui(GLenum type, GLuint color)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ColorP4ui);
   struct marshal_cmd_ColorP4ui *cmd;
   debug_print_marshal("ColorP4ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ColorP4ui, cmd_size);
      cmd->type = type;
      cmd->color = color;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ColorP4ui");
   CALL_ColorP4ui(ctx->CurrentServerDispatch, (type, color));
}


/* TextureStorage3D: marshalled asynchronously */
struct marshal_cmd_TextureStorage3D
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLsizei levels;
   GLenum internalformat;
   GLsizei width;
   GLsizei height;
   GLsizei depth;
};
static inline void
_mesa_unmarshal_TextureStorage3D(struct gl_context *ctx, const struct marshal_cmd_TextureStorage3D *cmd)
{
   const GLuint texture = cmd->texture;
   const GLsizei levels = cmd->levels;
   const GLenum internalformat = cmd->internalformat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLsizei depth = cmd->depth;
   CALL_TextureStorage3D(ctx->CurrentServerDispatch, (texture, levels, internalformat, width, height, depth));
}
static void GLAPIENTRY
_mesa_marshal_TextureStorage3D(GLuint texture, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureStorage3D);
   struct marshal_cmd_TextureStorage3D *cmd;
   debug_print_marshal("TextureStorage3D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureStorage3D, cmd_size);
      cmd->texture = texture;
      cmd->levels = levels;
      cmd->internalformat = internalformat;
      cmd->width = width;
      cmd->height = height;
      cmd->depth = depth;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureStorage3D");
   CALL_TextureStorage3D(ctx->CurrentServerDispatch, (texture, levels, internalformat, width, height, depth));
}


/* TexCoordP3uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexCoordP3uiv(GLenum type, const GLuint * coords)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexCoordP3uiv");
   CALL_TexCoordP3uiv(ctx->CurrentServerDispatch, (type, coords));
}


/* GetnUniformui64vARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnUniformui64vARB(GLuint program, GLint location, GLsizei bufSize, GLuint64 * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnUniformui64vARB");
   CALL_GetnUniformui64vARB(ctx->CurrentServerDispatch, (program, location, bufSize, params));
}


/* TextureStorageMem2DMultisampleEXT: marshalled asynchronously */
struct marshal_cmd_TextureStorageMem2DMultisampleEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLsizei samples;
   GLenum internalFormat;
   GLsizei width;
   GLsizei height;
   GLboolean fixedSampleLocations;
   GLuint memory;
   GLuint64 offset;
};
static inline void
_mesa_unmarshal_TextureStorageMem2DMultisampleEXT(struct gl_context *ctx, const struct marshal_cmd_TextureStorageMem2DMultisampleEXT *cmd)
{
   const GLuint texture = cmd->texture;
   const GLsizei samples = cmd->samples;
   const GLenum internalFormat = cmd->internalFormat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLboolean fixedSampleLocations = cmd->fixedSampleLocations;
   const GLuint memory = cmd->memory;
   const GLuint64 offset = cmd->offset;
   CALL_TextureStorageMem2DMultisampleEXT(ctx->CurrentServerDispatch, (texture, samples, internalFormat, width, height, fixedSampleLocations, memory, offset));
}
static void GLAPIENTRY
_mesa_marshal_TextureStorageMem2DMultisampleEXT(GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureStorageMem2DMultisampleEXT);
   struct marshal_cmd_TextureStorageMem2DMultisampleEXT *cmd;
   debug_print_marshal("TextureStorageMem2DMultisampleEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureStorageMem2DMultisampleEXT, cmd_size);
      cmd->texture = texture;
      cmd->samples = samples;
      cmd->internalFormat = internalFormat;
      cmd->width = width;
      cmd->height = height;
      cmd->fixedSampleLocations = fixedSampleLocations;
      cmd->memory = memory;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureStorageMem2DMultisampleEXT");
   CALL_TextureStorageMem2DMultisampleEXT(ctx->CurrentServerDispatch, (texture, samples, internalFormat, width, height, fixedSampleLocations, memory, offset));
}


/* Uniform1iv: marshalled asynchronously */
struct marshal_cmd_Uniform1iv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 4) bytes are GLint value[count] */
};
static inline void
_mesa_unmarshal_Uniform1iv(struct gl_context *ctx, const struct marshal_cmd_Uniform1iv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLint * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLint *) variable_data;
   variable_data += count * 4;
   CALL_Uniform1iv(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform1iv(GLint location, GLsizei count, const GLint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform1iv) + safe_mul(count, 4);
   struct marshal_cmd_Uniform1iv *cmd;
   debug_print_marshal("Uniform1iv");
   if (unlikely(safe_mul(count, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform1iv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 4);
      variable_data += count * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform1iv");
   CALL_Uniform1iv(ctx->CurrentServerDispatch, (location, count, value));
}


/* Uniform4uiv: marshalled asynchronously */
struct marshal_cmd_Uniform4uiv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 16) bytes are GLuint value[count][4] */
};
static inline void
_mesa_unmarshal_Uniform4uiv(struct gl_context *ctx, const struct marshal_cmd_Uniform4uiv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLuint * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLuint *) variable_data;
   variable_data += count * 16;
   CALL_Uniform4uiv(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform4uiv(GLint location, GLsizei count, const GLuint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform4uiv) + safe_mul(count, 16);
   struct marshal_cmd_Uniform4uiv *cmd;
   debug_print_marshal("Uniform4uiv");
   if (unlikely(safe_mul(count, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform4uiv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 16);
      variable_data += count * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform4uiv");
   CALL_Uniform4uiv(ctx->CurrentServerDispatch, (location, count, value));
}


/* PopDebugGroup: marshalled asynchronously */
struct marshal_cmd_PopDebugGroup
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_PopDebugGroup(struct gl_context *ctx, const struct marshal_cmd_PopDebugGroup *cmd)
{
   CALL_PopDebugGroup(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_PopDebugGroup(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PopDebugGroup);
   struct marshal_cmd_PopDebugGroup *cmd;
   debug_print_marshal("PopDebugGroup");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PopDebugGroup, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PopDebugGroup");
   CALL_PopDebugGroup(ctx->CurrentServerDispatch, ());
}


/* VertexAttrib1d: marshalled asynchronously */
struct marshal_cmd_VertexAttrib1d
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble x;
};
static inline void
_mesa_unmarshal_VertexAttrib1d(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib1d *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble x = cmd->x;
   CALL_VertexAttrib1d(ctx->CurrentServerDispatch, (index, x));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib1d(GLuint index, GLdouble x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib1d);
   struct marshal_cmd_VertexAttrib1d *cmd;
   debug_print_marshal("VertexAttrib1d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib1d, cmd_size);
      cmd->index = index;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib1d");
   CALL_VertexAttrib1d(ctx->CurrentServerDispatch, (index, x));
}


/* CompressedTexImage1D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CompressedTexImage1D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CompressedTexImage1D");
   CALL_CompressedTexImage1D(ctx->CurrentServerDispatch, (target, level, internalformat, width, border, imageSize, data));
}


/* TexBufferRange: marshalled asynchronously */
struct marshal_cmd_TexBufferRange
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum internalformat;
   GLuint buffer;
   GLintptr offset;
   GLsizeiptr size;
};
static inline void
_mesa_unmarshal_TexBufferRange(struct gl_context *ctx, const struct marshal_cmd_TexBufferRange *cmd)
{
   const GLenum target = cmd->target;
   const GLenum internalformat = cmd->internalformat;
   const GLuint buffer = cmd->buffer;
   const GLintptr offset = cmd->offset;
   const GLsizeiptr size = cmd->size;
   CALL_TexBufferRange(ctx->CurrentServerDispatch, (target, internalformat, buffer, offset, size));
}
static void GLAPIENTRY
_mesa_marshal_TexBufferRange(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexBufferRange);
   struct marshal_cmd_TexBufferRange *cmd;
   debug_print_marshal("TexBufferRange");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexBufferRange, cmd_size);
      cmd->target = target;
      cmd->internalformat = internalformat;
      cmd->buffer = buffer;
      cmd->offset = offset;
      cmd->size = size;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexBufferRange");
   CALL_TexBufferRange(ctx->CurrentServerDispatch, (target, internalformat, buffer, offset, size));
}


/* VertexAttrib1s: marshalled asynchronously */
struct marshal_cmd_VertexAttrib1s
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort x;
};
static inline void
_mesa_unmarshal_VertexAttrib1s(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib1s *cmd)
{
   const GLuint index = cmd->index;
   const GLshort x = cmd->x;
   CALL_VertexAttrib1s(ctx->CurrentServerDispatch, (index, x));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib1s(GLuint index, GLshort x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib1s);
   struct marshal_cmd_VertexAttrib1s *cmd;
   debug_print_marshal("VertexAttrib1s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib1s, cmd_size);
      cmd->index = index;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib1s");
   CALL_VertexAttrib1s(ctx->CurrentServerDispatch, (index, x));
}


/* MultiDrawElementsIndirect: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_MultiDrawElementsIndirect(GLenum mode, GLenum type, const GLvoid * indirect, GLsizei primcount, GLsizei stride)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MultiDrawElementsIndirect");
   CALL_MultiDrawElementsIndirect(ctx->CurrentServerDispatch, (mode, type, indirect, primcount, stride));
}


/* UniformMatrix4x3dv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix4x3dv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 96) bytes are GLdouble value[count][12] */
};
static inline void
_mesa_unmarshal_UniformMatrix4x3dv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix4x3dv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 96;
   CALL_UniformMatrix4x3dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix4x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix4x3dv) + safe_mul(count, 96);
   struct marshal_cmd_UniformMatrix4x3dv *cmd;
   debug_print_marshal("UniformMatrix4x3dv");
   if (unlikely(safe_mul(count, 96) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix4x3dv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 96);
      variable_data += count * 96;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix4x3dv");
   CALL_UniformMatrix4x3dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* TransformFeedbackBufferBase: marshalled asynchronously */
struct marshal_cmd_TransformFeedbackBufferBase
{
   struct marshal_cmd_base cmd_base;
   GLuint xfb;
   GLuint index;
   GLuint buffer;
};
static inline void
_mesa_unmarshal_TransformFeedbackBufferBase(struct gl_context *ctx, const struct marshal_cmd_TransformFeedbackBufferBase *cmd)
{
   const GLuint xfb = cmd->xfb;
   const GLuint index = cmd->index;
   const GLuint buffer = cmd->buffer;
   CALL_TransformFeedbackBufferBase(ctx->CurrentServerDispatch, (xfb, index, buffer));
}
static void GLAPIENTRY
_mesa_marshal_TransformFeedbackBufferBase(GLuint xfb, GLuint index, GLuint buffer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TransformFeedbackBufferBase);
   struct marshal_cmd_TransformFeedbackBufferBase *cmd;
   debug_print_marshal("TransformFeedbackBufferBase");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TransformFeedbackBufferBase, cmd_size);
      cmd->xfb = xfb;
      cmd->index = index;
      cmd->buffer = buffer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TransformFeedbackBufferBase");
   CALL_TransformFeedbackBufferBase(ctx->CurrentServerDispatch, (xfb, index, buffer));
}


/* FogCoordfvEXT: marshalled asynchronously */
struct marshal_cmd_FogCoordfvEXT
{
   struct marshal_cmd_base cmd_base;
   GLfloat coord[1];
};
static inline void
_mesa_unmarshal_FogCoordfvEXT(struct gl_context *ctx, const struct marshal_cmd_FogCoordfvEXT *cmd)
{
   const GLfloat * coord = cmd->coord;
   CALL_FogCoordfvEXT(ctx->CurrentServerDispatch, (coord));
}
static void GLAPIENTRY
_mesa_marshal_FogCoordfvEXT(const GLfloat * coord)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_FogCoordfvEXT);
   struct marshal_cmd_FogCoordfvEXT *cmd;
   debug_print_marshal("FogCoordfvEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_FogCoordfvEXT, cmd_size);
      memcpy(cmd->coord, coord, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("FogCoordfvEXT");
   CALL_FogCoordfvEXT(ctx->CurrentServerDispatch, (coord));
}


/* Uniform2ui64vARB: marshalled asynchronously */
struct marshal_cmd_Uniform2ui64vARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 16) bytes are GLuint64 value[count][2] */
};
static inline void
_mesa_unmarshal_Uniform2ui64vARB(struct gl_context *ctx, const struct marshal_cmd_Uniform2ui64vARB *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLuint64 * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLuint64 *) variable_data;
   variable_data += count * 16;
   CALL_Uniform2ui64vARB(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform2ui64vARB(GLint location, GLsizei count, const GLuint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform2ui64vARB) + safe_mul(count, 16);
   struct marshal_cmd_Uniform2ui64vARB *cmd;
   debug_print_marshal("Uniform2ui64vARB");
   if (unlikely(safe_mul(count, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform2ui64vARB, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 16);
      variable_data += count * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform2ui64vARB");
   CALL_Uniform2ui64vARB(ctx->CurrentServerDispatch, (location, count, value));
}


/* GetColorTableParameterfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetColorTableParameterfv(GLenum target, GLenum pname, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetColorTableParameterfv");
   CALL_GetColorTableParameterfv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* MultiTexCoord3fARB: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord3fARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLfloat s;
   GLfloat t;
   GLfloat r;
};
static inline void
_mesa_unmarshal_MultiTexCoord3fARB(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord3fARB *cmd)
{
   const GLenum target = cmd->target;
   const GLfloat s = cmd->s;
   const GLfloat t = cmd->t;
   const GLfloat r = cmd->r;
   CALL_MultiTexCoord3fARB(ctx->CurrentServerDispatch, (target, s, t, r));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord3fARB(GLenum target, GLfloat s, GLfloat t, GLfloat r)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord3fARB);
   struct marshal_cmd_MultiTexCoord3fARB *cmd;
   debug_print_marshal("MultiTexCoord3fARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord3fARB, cmd_size);
      cmd->target = target;
      cmd->s = s;
      cmd->t = t;
      cmd->r = r;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord3fARB");
   CALL_MultiTexCoord3fARB(ctx->CurrentServerDispatch, (target, s, t, r));
}


/* GetTexLevelParameterfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTexLevelParameterfv");
   CALL_GetTexLevelParameterfv(ctx->CurrentServerDispatch, (target, level, pname, params));
}


/* Vertex2sv: marshalled asynchronously */
struct marshal_cmd_Vertex2sv
{
   struct marshal_cmd_base cmd_base;
   GLshort v[2];
};
static inline void
_mesa_unmarshal_Vertex2sv(struct gl_context *ctx, const struct marshal_cmd_Vertex2sv *cmd)
{
   const GLshort * v = cmd->v;
   CALL_Vertex2sv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Vertex2sv(const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex2sv);
   struct marshal_cmd_Vertex2sv *cmd;
   debug_print_marshal("Vertex2sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex2sv, cmd_size);
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex2sv");
   CALL_Vertex2sv(ctx->CurrentServerDispatch, (v));
}


/* GetnMapdvARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnMapdvARB(GLenum target, GLenum query, GLsizei bufSize, GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnMapdvARB");
   CALL_GetnMapdvARB(ctx->CurrentServerDispatch, (target, query, bufSize, v));
}


/* VertexAttrib2dNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib2dNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble x;
   GLdouble y;
};
static inline void
_mesa_unmarshal_VertexAttrib2dNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib2dNV *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   CALL_VertexAttrib2dNV(ctx->CurrentServerDispatch, (index, x, y));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib2dNV(GLuint index, GLdouble x, GLdouble y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib2dNV);
   struct marshal_cmd_VertexAttrib2dNV *cmd;
   debug_print_marshal("VertexAttrib2dNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib2dNV, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib2dNV");
   CALL_VertexAttrib2dNV(ctx->CurrentServerDispatch, (index, x, y));
}


/* VertexAttrib3svNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib3svNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort v[3];
};
static inline void
_mesa_unmarshal_VertexAttrib3svNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib3svNV *cmd)
{
   const GLuint index = cmd->index;
   const GLshort * v = cmd->v;
   CALL_VertexAttrib3svNV(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib3svNV(GLuint index, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib3svNV);
   struct marshal_cmd_VertexAttrib3svNV *cmd;
   debug_print_marshal("VertexAttrib3svNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib3svNV, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 6);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib3svNV");
   CALL_VertexAttrib3svNV(ctx->CurrentServerDispatch, (index, v));
}


/* GetTexEnviv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTexEnviv(GLenum target, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTexEnviv");
   CALL_GetTexEnviv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* ViewportArrayv: marshalled asynchronously */
struct marshal_cmd_ViewportArrayv
{
   struct marshal_cmd_base cmd_base;
   GLuint first;
   GLsizei count;
   /* Next safe_mul(count, 16) bytes are GLfloat v[count][4] */
};
static inline void
_mesa_unmarshal_ViewportArrayv(struct gl_context *ctx, const struct marshal_cmd_ViewportArrayv *cmd)
{
   const GLuint first = cmd->first;
   const GLsizei count = cmd->count;
   const GLfloat * v;
   const char *variable_data = (const char *) (cmd + 1);
   v = (const GLfloat *) variable_data;
   variable_data += count * 16;
   CALL_ViewportArrayv(ctx->CurrentServerDispatch, (first, count, v));
}
static void GLAPIENTRY
_mesa_marshal_ViewportArrayv(GLuint first, GLsizei count, const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ViewportArrayv) + safe_mul(count, 16);
   struct marshal_cmd_ViewportArrayv *cmd;
   debug_print_marshal("ViewportArrayv");
   if (unlikely(safe_mul(count, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ViewportArrayv, cmd_size);
      cmd->first = first;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, v, count * 16);
      variable_data += count * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ViewportArrayv");
   CALL_ViewportArrayv(ctx->CurrentServerDispatch, (first, count, v));
}


/* SeparableFilter2D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_SeparableFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * row, const GLvoid * column)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("SeparableFilter2D");
   CALL_SeparableFilter2D(ctx->CurrentServerDispatch, (target, internalformat, width, height, format, type, row, column));
}


/* ArrayElement: marshalled asynchronously */
struct marshal_cmd_ArrayElement
{
   struct marshal_cmd_base cmd_base;
   GLint i;
};
static inline void
_mesa_unmarshal_ArrayElement(struct gl_context *ctx, const struct marshal_cmd_ArrayElement *cmd)
{
   const GLint i = cmd->i;
   CALL_ArrayElement(ctx->CurrentServerDispatch, (i));
}
static void GLAPIENTRY
_mesa_marshal_ArrayElement(GLint i)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ArrayElement);
   struct marshal_cmd_ArrayElement *cmd;
   debug_print_marshal("ArrayElement");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ArrayElement, cmd_size);
      cmd->i = i;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ArrayElement");
   CALL_ArrayElement(ctx->CurrentServerDispatch, (i));
}


/* TexImage2D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexImage2D");
   CALL_TexImage2D(ctx->CurrentServerDispatch, (target, level, internalformat, width, height, border, format, type, pixels));
}


/* RasterPos2dv: marshalled asynchronously */
struct marshal_cmd_RasterPos2dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v[2];
};
static inline void
_mesa_unmarshal_RasterPos2dv(struct gl_context *ctx, const struct marshal_cmd_RasterPos2dv *cmd)
{
   const GLdouble * v = cmd->v;
   CALL_RasterPos2dv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos2dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos2dv);
   struct marshal_cmd_RasterPos2dv *cmd;
   debug_print_marshal("RasterPos2dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos2dv, cmd_size);
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos2dv");
   CALL_RasterPos2dv(ctx->CurrentServerDispatch, (v));
}


/* Fogiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_Fogiv(GLenum pname, const GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("Fogiv");
   CALL_Fogiv(ctx->CurrentServerDispatch, (pname, params));
}


/* EndQuery: marshalled asynchronously */
struct marshal_cmd_EndQuery
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
};
static inline void
_mesa_unmarshal_EndQuery(struct gl_context *ctx, const struct marshal_cmd_EndQuery *cmd)
{
   const GLenum target = cmd->target;
   CALL_EndQuery(ctx->CurrentServerDispatch, (target));
}
static void GLAPIENTRY
_mesa_marshal_EndQuery(GLenum target)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EndQuery);
   struct marshal_cmd_EndQuery *cmd;
   debug_print_marshal("EndQuery");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EndQuery, cmd_size);
      cmd->target = target;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EndQuery");
   CALL_EndQuery(ctx->CurrentServerDispatch, (target));
}


/* TexCoord1dv: marshalled asynchronously */
struct marshal_cmd_TexCoord1dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v[1];
};
static inline void
_mesa_unmarshal_TexCoord1dv(struct gl_context *ctx, const struct marshal_cmd_TexCoord1dv *cmd)
{
   const GLdouble * v = cmd->v;
   CALL_TexCoord1dv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord1dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord1dv);
   struct marshal_cmd_TexCoord1dv *cmd;
   debug_print_marshal("TexCoord1dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord1dv, cmd_size);
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord1dv");
   CALL_TexCoord1dv(ctx->CurrentServerDispatch, (v));
}


/* AlphaFragmentOp3ATI: marshalled asynchronously */
struct marshal_cmd_AlphaFragmentOp3ATI
{
   struct marshal_cmd_base cmd_base;
   GLenum op;
   GLuint dst;
   GLuint dstMod;
   GLuint arg1;
   GLuint arg1Rep;
   GLuint arg1Mod;
   GLuint arg2;
   GLuint arg2Rep;
   GLuint arg2Mod;
   GLuint arg3;
   GLuint arg3Rep;
   GLuint arg3Mod;
};
static inline void
_mesa_unmarshal_AlphaFragmentOp3ATI(struct gl_context *ctx, const struct marshal_cmd_AlphaFragmentOp3ATI *cmd)
{
   const GLenum op = cmd->op;
   const GLuint dst = cmd->dst;
   const GLuint dstMod = cmd->dstMod;
   const GLuint arg1 = cmd->arg1;
   const GLuint arg1Rep = cmd->arg1Rep;
   const GLuint arg1Mod = cmd->arg1Mod;
   const GLuint arg2 = cmd->arg2;
   const GLuint arg2Rep = cmd->arg2Rep;
   const GLuint arg2Mod = cmd->arg2Mod;
   const GLuint arg3 = cmd->arg3;
   const GLuint arg3Rep = cmd->arg3Rep;
   const GLuint arg3Mod = cmd->arg3Mod;
   CALL_AlphaFragmentOp3ATI(ctx->CurrentServerDispatch, (op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod));
}
static void GLAPIENTRY
_mesa_marshal_AlphaFragmentOp3ATI(GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_AlphaFragmentOp3ATI);
   struct marshal_cmd_AlphaFragmentOp3ATI *cmd;
   debug_print_marshal("AlphaFragmentOp3ATI");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_AlphaFragmentOp3ATI, cmd_size);
      cmd->op = op;
      cmd->dst = dst;
      cmd->dstMod = dstMod;
      cmd->arg1 = arg1;
      cmd->arg1Rep = arg1Rep;
      cmd->arg1Mod = arg1Mod;
      cmd->arg2 = arg2;
      cmd->arg2Rep = arg2Rep;
      cmd->arg2Mod = arg2Mod;
      cmd->arg3 = arg3;
      cmd->arg3Rep = arg3Rep;
      cmd->arg3Mod = arg3Mod;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("AlphaFragmentOp3ATI");
   CALL_AlphaFragmentOp3ATI(ctx->CurrentServerDispatch, (op, dst, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod));
}


/* Clear: marshalled asynchronously */
struct marshal_cmd_Clear
{
   struct marshal_cmd_base cmd_base;
   GLbitfield mask;
};
static inline void
_mesa_unmarshal_Clear(struct gl_context *ctx, const struct marshal_cmd_Clear *cmd)
{
   const GLbitfield mask = cmd->mask;
   CALL_Clear(ctx->CurrentServerDispatch, (mask));
}
static void GLAPIENTRY
_mesa_marshal_Clear(GLbitfield mask)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Clear);
   struct marshal_cmd_Clear *cmd;
   debug_print_marshal("Clear");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Clear, cmd_size);
      cmd->mask = mask;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Clear");
   CALL_Clear(ctx->CurrentServerDispatch, (mask));
}


/* VertexAttrib4sv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4sv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4sv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4sv *cmd)
{
   const GLuint index = cmd->index;
   const GLshort * v = cmd->v;
   CALL_VertexAttrib4sv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4sv(GLuint index, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4sv);
   struct marshal_cmd_VertexAttrib4sv *cmd;
   debug_print_marshal("VertexAttrib4sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4sv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4sv");
   CALL_VertexAttrib4sv(ctx->CurrentServerDispatch, (index, v));
}


/* Ortho: marshalled asynchronously */
struct marshal_cmd_Ortho
{
   struct marshal_cmd_base cmd_base;
   GLdouble left;
   GLdouble right;
   GLdouble bottom;
   GLdouble top;
   GLdouble zNear;
   GLdouble zFar;
};
static inline void
_mesa_unmarshal_Ortho(struct gl_context *ctx, const struct marshal_cmd_Ortho *cmd)
{
   const GLdouble left = cmd->left;
   const GLdouble right = cmd->right;
   const GLdouble bottom = cmd->bottom;
   const GLdouble top = cmd->top;
   const GLdouble zNear = cmd->zNear;
   const GLdouble zFar = cmd->zFar;
   CALL_Ortho(ctx->CurrentServerDispatch, (left, right, bottom, top, zNear, zFar));
}
static void GLAPIENTRY
_mesa_marshal_Ortho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Ortho);
   struct marshal_cmd_Ortho *cmd;
   debug_print_marshal("Ortho");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Ortho, cmd_size);
      cmd->left = left;
      cmd->right = right;
      cmd->bottom = bottom;
      cmd->top = top;
      cmd->zNear = zNear;
      cmd->zFar = zFar;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Ortho");
   CALL_Ortho(ctx->CurrentServerDispatch, (left, right, bottom, top, zNear, zFar));
}


/* Uniform3uiv: marshalled asynchronously */
struct marshal_cmd_Uniform3uiv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 12) bytes are GLuint value[count][3] */
};
static inline void
_mesa_unmarshal_Uniform3uiv(struct gl_context *ctx, const struct marshal_cmd_Uniform3uiv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLuint * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLuint *) variable_data;
   variable_data += count * 12;
   CALL_Uniform3uiv(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform3uiv(GLint location, GLsizei count, const GLuint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform3uiv) + safe_mul(count, 12);
   struct marshal_cmd_Uniform3uiv *cmd;
   debug_print_marshal("Uniform3uiv");
   if (unlikely(safe_mul(count, 12) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform3uiv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 12);
      variable_data += count * 12;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform3uiv");
   CALL_Uniform3uiv(ctx->CurrentServerDispatch, (location, count, value));
}


/* GetUniformi64vARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetUniformi64vARB(GLuint program, GLint location, GLint64 * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetUniformi64vARB");
   CALL_GetUniformi64vARB(ctx->CurrentServerDispatch, (program, location, params));
}


/* EndQueryIndexed: marshalled asynchronously */
struct marshal_cmd_EndQueryIndexed
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
};
static inline void
_mesa_unmarshal_EndQueryIndexed(struct gl_context *ctx, const struct marshal_cmd_EndQueryIndexed *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   CALL_EndQueryIndexed(ctx->CurrentServerDispatch, (target, index));
}
static void GLAPIENTRY
_mesa_marshal_EndQueryIndexed(GLenum target, GLuint index)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EndQueryIndexed);
   struct marshal_cmd_EndQueryIndexed *cmd;
   debug_print_marshal("EndQueryIndexed");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EndQueryIndexed, cmd_size);
      cmd->target = target;
      cmd->index = index;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EndQueryIndexed");
   CALL_EndQueryIndexed(ctx->CurrentServerDispatch, (target, index));
}


/* TexParameterxv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexParameterxv(GLenum target, GLenum pname, const GLfixed * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexParameterxv");
   CALL_TexParameterxv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* MultiDrawArraysIndirectCountARB: marshalled asynchronously */
struct marshal_cmd_MultiDrawArraysIndirectCountARB
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
   GLintptr indirect;
   GLintptr drawcount;
   GLsizei maxdrawcount;
   GLsizei stride;
};
static inline void
_mesa_unmarshal_MultiDrawArraysIndirectCountARB(struct gl_context *ctx, const struct marshal_cmd_MultiDrawArraysIndirectCountARB *cmd)
{
   const GLenum mode = cmd->mode;
   const GLintptr indirect = cmd->indirect;
   const GLintptr drawcount = cmd->drawcount;
   const GLsizei maxdrawcount = cmd->maxdrawcount;
   const GLsizei stride = cmd->stride;
   CALL_MultiDrawArraysIndirectCountARB(ctx->CurrentServerDispatch, (mode, indirect, drawcount, maxdrawcount, stride));
}
static void GLAPIENTRY
_mesa_marshal_MultiDrawArraysIndirectCountARB(GLenum mode, GLintptr indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiDrawArraysIndirectCountARB);
   struct marshal_cmd_MultiDrawArraysIndirectCountARB *cmd;
   debug_print_marshal("MultiDrawArraysIndirectCountARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiDrawArraysIndirectCountARB, cmd_size);
      cmd->mode = mode;
      cmd->indirect = indirect;
      cmd->drawcount = drawcount;
      cmd->maxdrawcount = maxdrawcount;
      cmd->stride = stride;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiDrawArraysIndirectCountARB");
   CALL_MultiDrawArraysIndirectCountARB(ctx->CurrentServerDispatch, (mode, indirect, drawcount, maxdrawcount, stride));
}


/* ProgramUniformMatrix2fv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix2fv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 16) bytes are GLfloat value[count][4] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix2fv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix2fv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 16;
   CALL_ProgramUniformMatrix2fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix2fv) + safe_mul(count, 16);
   struct marshal_cmd_ProgramUniformMatrix2fv *cmd;
   debug_print_marshal("ProgramUniformMatrix2fv");
   if (unlikely(safe_mul(count, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix2fv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 16);
      variable_data += count * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix2fv");
   CALL_ProgramUniformMatrix2fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* ProgramLocalParameter4fvARB: marshalled asynchronously */
struct marshal_cmd_ProgramLocalParameter4fvARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
   GLfloat params[4];
};
static inline void
_mesa_unmarshal_ProgramLocalParameter4fvARB(struct gl_context *ctx, const struct marshal_cmd_ProgramLocalParameter4fvARB *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   const GLfloat * params = cmd->params;
   CALL_ProgramLocalParameter4fvARB(ctx->CurrentServerDispatch, (target, index, params));
}
static void GLAPIENTRY
_mesa_marshal_ProgramLocalParameter4fvARB(GLenum target, GLuint index, const GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramLocalParameter4fvARB);
   struct marshal_cmd_ProgramLocalParameter4fvARB *cmd;
   debug_print_marshal("ProgramLocalParameter4fvARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramLocalParameter4fvARB, cmd_size);
      cmd->target = target;
      cmd->index = index;
      memcpy(cmd->params, params, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramLocalParameter4fvARB");
   CALL_ProgramLocalParameter4fvARB(ctx->CurrentServerDispatch, (target, index, params));
}


/* Uniform4dv: marshalled asynchronously */
struct marshal_cmd_Uniform4dv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 32) bytes are GLdouble value[count][4] */
};
static inline void
_mesa_unmarshal_Uniform4dv(struct gl_context *ctx, const struct marshal_cmd_Uniform4dv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 32;
   CALL_Uniform4dv(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform4dv(GLint location, GLsizei count, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform4dv) + safe_mul(count, 32);
   struct marshal_cmd_Uniform4dv *cmd;
   debug_print_marshal("Uniform4dv");
   if (unlikely(safe_mul(count, 32) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform4dv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 32);
      variable_data += count * 32;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform4dv");
   CALL_Uniform4dv(ctx->CurrentServerDispatch, (location, count, value));
}


/* GetUnsignedBytevEXT: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetUnsignedBytevEXT(GLenum pname, GLubyte * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetUnsignedBytevEXT");
   CALL_GetUnsignedBytevEXT(ctx->CurrentServerDispatch, (pname, data));
}


/* LightModelx: marshalled asynchronously */
struct marshal_cmd_LightModelx
{
   struct marshal_cmd_base cmd_base;
   GLenum pname;
   GLfixed param;
};
static inline void
_mesa_unmarshal_LightModelx(struct gl_context *ctx, const struct marshal_cmd_LightModelx *cmd)
{
   const GLenum pname = cmd->pname;
   const GLfixed param = cmd->param;
   CALL_LightModelx(ctx->CurrentServerDispatch, (pname, param));
}
static void GLAPIENTRY
_mesa_marshal_LightModelx(GLenum pname, GLfixed param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_LightModelx);
   struct marshal_cmd_LightModelx *cmd;
   debug_print_marshal("LightModelx");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_LightModelx, cmd_size);
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("LightModelx");
   CALL_LightModelx(ctx->CurrentServerDispatch, (pname, param));
}


/* VertexAttribI3iEXT: marshalled asynchronously */
struct marshal_cmd_VertexAttribI3iEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLint x;
   GLint y;
   GLint z;
};
static inline void
_mesa_unmarshal_VertexAttribI3iEXT(struct gl_context *ctx, const struct marshal_cmd_VertexAttribI3iEXT *cmd)
{
   const GLuint index = cmd->index;
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLint z = cmd->z;
   CALL_VertexAttribI3iEXT(ctx->CurrentServerDispatch, (index, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribI3iEXT(GLuint index, GLint x, GLint y, GLint z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribI3iEXT);
   struct marshal_cmd_VertexAttribI3iEXT *cmd;
   debug_print_marshal("VertexAttribI3iEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribI3iEXT, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribI3iEXT");
   CALL_VertexAttribI3iEXT(ctx->CurrentServerDispatch, (index, x, y, z));
}


/* ClearColorx: marshalled asynchronously */
struct marshal_cmd_ClearColorx
{
   struct marshal_cmd_base cmd_base;
   GLclampx red;
   GLclampx green;
   GLclampx blue;
   GLclampx alpha;
};
static inline void
_mesa_unmarshal_ClearColorx(struct gl_context *ctx, const struct marshal_cmd_ClearColorx *cmd)
{
   const GLclampx red = cmd->red;
   const GLclampx green = cmd->green;
   const GLclampx blue = cmd->blue;
   const GLclampx alpha = cmd->alpha;
   CALL_ClearColorx(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}
static void GLAPIENTRY
_mesa_marshal_ClearColorx(GLclampx red, GLclampx green, GLclampx blue, GLclampx alpha)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClearColorx);
   struct marshal_cmd_ClearColorx *cmd;
   debug_print_marshal("ClearColorx");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClearColorx, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      cmd->alpha = alpha;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClearColorx");
   CALL_ClearColorx(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}


/* EndTransformFeedback: marshalled asynchronously */
struct marshal_cmd_EndTransformFeedback
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_EndTransformFeedback(struct gl_context *ctx, const struct marshal_cmd_EndTransformFeedback *cmd)
{
   CALL_EndTransformFeedback(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_EndTransformFeedback(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EndTransformFeedback);
   struct marshal_cmd_EndTransformFeedback *cmd;
   debug_print_marshal("EndTransformFeedback");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EndTransformFeedback, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EndTransformFeedback");
   CALL_EndTransformFeedback(ctx->CurrentServerDispatch, ());
}


/* VertexAttribL2dv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribL2dv(GLuint index, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribL2dv");
   CALL_VertexAttribL2dv(ctx->CurrentServerDispatch, (index, v));
}


/* GetActiveUniformName: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetActiveUniformName(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei * length, GLchar * uniformName)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetActiveUniformName");
   CALL_GetActiveUniformName(ctx->CurrentServerDispatch, (program, uniformIndex, bufSize, length, uniformName));
}


/* GetProgramBinary: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetProgramBinary(GLuint program, GLsizei bufSize, GLsizei * length, GLenum * binaryFormat, GLvoid * binary)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramBinary");
   CALL_GetProgramBinary(ctx->CurrentServerDispatch, (program, bufSize, length, binaryFormat, binary));
}


/* ViewportIndexedfv: marshalled asynchronously */
struct marshal_cmd_ViewportIndexedfv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat v[4];
};
static inline void
_mesa_unmarshal_ViewportIndexedfv(struct gl_context *ctx, const struct marshal_cmd_ViewportIndexedfv *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat * v = cmd->v;
   CALL_ViewportIndexedfv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_ViewportIndexedfv(GLuint index, const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ViewportIndexedfv);
   struct marshal_cmd_ViewportIndexedfv *cmd;
   debug_print_marshal("ViewportIndexedfv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ViewportIndexedfv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ViewportIndexedfv");
   CALL_ViewportIndexedfv(ctx->CurrentServerDispatch, (index, v));
}


/* BindTextureUnit: marshalled asynchronously */
struct marshal_cmd_BindTextureUnit
{
   struct marshal_cmd_base cmd_base;
   GLuint unit;
   GLuint texture;
};
static inline void
_mesa_unmarshal_BindTextureUnit(struct gl_context *ctx, const struct marshal_cmd_BindTextureUnit *cmd)
{
   const GLuint unit = cmd->unit;
   const GLuint texture = cmd->texture;
   CALL_BindTextureUnit(ctx->CurrentServerDispatch, (unit, texture));
}
static void GLAPIENTRY
_mesa_marshal_BindTextureUnit(GLuint unit, GLuint texture)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindTextureUnit);
   struct marshal_cmd_BindTextureUnit *cmd;
   debug_print_marshal("BindTextureUnit");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindTextureUnit, cmd_size);
      cmd->unit = unit;
      cmd->texture = texture;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindTextureUnit");
   CALL_BindTextureUnit(ctx->CurrentServerDispatch, (unit, texture));
}


/* CallList: marshalled asynchronously */
struct marshal_cmd_CallList
{
   struct marshal_cmd_base cmd_base;
   GLuint list;
};
static inline void
_mesa_unmarshal_CallList(struct gl_context *ctx, const struct marshal_cmd_CallList *cmd)
{
   const GLuint list = cmd->list;
   CALL_CallList(ctx->CurrentServerDispatch, (list));
}
static void GLAPIENTRY
_mesa_marshal_CallList(GLuint list)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_CallList);
   struct marshal_cmd_CallList *cmd;
   debug_print_marshal("CallList");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_CallList, cmd_size);
      cmd->list = list;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("CallList");
   CALL_CallList(ctx->CurrentServerDispatch, (list));
}


/* Materialfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_Materialfv(GLenum face, GLenum pname, const GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("Materialfv");
   CALL_Materialfv(ctx->CurrentServerDispatch, (face, pname, params));
}


/* DeleteProgram: marshalled asynchronously */
struct marshal_cmd_DeleteProgram
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
};
static inline void
_mesa_unmarshal_DeleteProgram(struct gl_context *ctx, const struct marshal_cmd_DeleteProgram *cmd)
{
   const GLuint program = cmd->program;
   CALL_DeleteProgram(ctx->CurrentServerDispatch, (program));
}
static void GLAPIENTRY
_mesa_marshal_DeleteProgram(GLuint program)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DeleteProgram);
   struct marshal_cmd_DeleteProgram *cmd;
   debug_print_marshal("DeleteProgram");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DeleteProgram, cmd_size);
      cmd->program = program;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DeleteProgram");
   CALL_DeleteProgram(ctx->CurrentServerDispatch, (program));
}


/* GetActiveAtomicCounterBufferiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetActiveAtomicCounterBufferiv(GLuint program, GLuint bufferIndex, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetActiveAtomicCounterBufferiv");
   CALL_GetActiveAtomicCounterBufferiv(ctx->CurrentServerDispatch, (program, bufferIndex, pname, params));
}


/* ClearDepthf: marshalled asynchronously */
struct marshal_cmd_ClearDepthf
{
   struct marshal_cmd_base cmd_base;
   GLclampf depth;
};
static inline void
_mesa_unmarshal_ClearDepthf(struct gl_context *ctx, const struct marshal_cmd_ClearDepthf *cmd)
{
   const GLclampf depth = cmd->depth;
   CALL_ClearDepthf(ctx->CurrentServerDispatch, (depth));
}
static void GLAPIENTRY
_mesa_marshal_ClearDepthf(GLclampf depth)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClearDepthf);
   struct marshal_cmd_ClearDepthf *cmd;
   debug_print_marshal("ClearDepthf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClearDepthf, cmd_size);
      cmd->depth = depth;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClearDepthf");
   CALL_ClearDepthf(ctx->CurrentServerDispatch, (depth));
}


/* GetTextureHandleARB: marshalled synchronously */
static GLuint64 GLAPIENTRY
_mesa_marshal_GetTextureHandleARB(GLuint texture)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTextureHandleARB");
   return CALL_GetTextureHandleARB(ctx->CurrentServerDispatch, (texture));
}


/* GetConvolutionFilter: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetConvolutionFilter(GLenum target, GLenum format, GLenum type, GLvoid * image)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetConvolutionFilter");
   CALL_GetConvolutionFilter(ctx->CurrentServerDispatch, (target, format, type, image));
}


/* MultiModeDrawElementsIBM: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_MultiModeDrawElementsIBM(const GLenum * mode, const GLsizei * count, GLenum type, const GLvoid * const * indices, GLsizei primcount, GLint modestride)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MultiModeDrawElementsIBM");
   CALL_MultiModeDrawElementsIBM(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount, modestride));
}


/* Uniform2iv: marshalled asynchronously */
struct marshal_cmd_Uniform2iv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 8) bytes are GLint value[count][2] */
};
static inline void
_mesa_unmarshal_Uniform2iv(struct gl_context *ctx, const struct marshal_cmd_Uniform2iv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLint * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLint *) variable_data;
   variable_data += count * 8;
   CALL_Uniform2iv(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform2iv(GLint location, GLsizei count, const GLint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform2iv) + safe_mul(count, 8);
   struct marshal_cmd_Uniform2iv *cmd;
   debug_print_marshal("Uniform2iv");
   if (unlikely(safe_mul(count, 8) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform2iv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 8);
      variable_data += count * 8;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform2iv");
   CALL_Uniform2iv(ctx->CurrentServerDispatch, (location, count, value));
}


/* GetFixedv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetFixedv(GLenum pname, GLfixed * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetFixedv");
   CALL_GetFixedv(ctx->CurrentServerDispatch, (pname, params));
}


/* SampleCoveragex: marshalled asynchronously */
struct marshal_cmd_SampleCoveragex
{
   struct marshal_cmd_base cmd_base;
   GLclampx value;
   GLboolean invert;
};
static inline void
_mesa_unmarshal_SampleCoveragex(struct gl_context *ctx, const struct marshal_cmd_SampleCoveragex *cmd)
{
   const GLclampx value = cmd->value;
   const GLboolean invert = cmd->invert;
   CALL_SampleCoveragex(ctx->CurrentServerDispatch, (value, invert));
}
static void GLAPIENTRY
_mesa_marshal_SampleCoveragex(GLclampx value, GLboolean invert)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SampleCoveragex);
   struct marshal_cmd_SampleCoveragex *cmd;
   debug_print_marshal("SampleCoveragex");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SampleCoveragex, cmd_size);
      cmd->value = value;
      cmd->invert = invert;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SampleCoveragex");
   CALL_SampleCoveragex(ctx->CurrentServerDispatch, (value, invert));
}


/* GetPerfQueryInfoINTEL: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetPerfQueryInfoINTEL(GLuint queryId, GLuint queryNameLength, GLchar * queryName, GLuint * dataSize, GLuint * noCounters, GLuint * noInstances, GLuint * capsMask)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetPerfQueryInfoINTEL");
   CALL_GetPerfQueryInfoINTEL(ctx->CurrentServerDispatch, (queryId, queryNameLength, queryName, dataSize, noCounters, noInstances, capsMask));
}


/* DeleteFramebuffers: marshalled asynchronously */
struct marshal_cmd_DeleteFramebuffers
{
   struct marshal_cmd_base cmd_base;
   GLsizei n;
   /* Next safe_mul(n, 4) bytes are GLuint framebuffers[n] */
};
static inline void
_mesa_unmarshal_DeleteFramebuffers(struct gl_context *ctx, const struct marshal_cmd_DeleteFramebuffers *cmd)
{
   const GLsizei n = cmd->n;
   const GLuint * framebuffers;
   const char *variable_data = (const char *) (cmd + 1);
   framebuffers = (const GLuint *) variable_data;
   variable_data += n * 4;
   CALL_DeleteFramebuffers(ctx->CurrentServerDispatch, (n, framebuffers));
}
static void GLAPIENTRY
_mesa_marshal_DeleteFramebuffers(GLsizei n, const GLuint * framebuffers)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DeleteFramebuffers) + safe_mul(n, 4);
   struct marshal_cmd_DeleteFramebuffers *cmd;
   debug_print_marshal("DeleteFramebuffers");
   if (unlikely(safe_mul(n, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DeleteFramebuffers, cmd_size);
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, framebuffers, n * 4);
      variable_data += n * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DeleteFramebuffers");
   CALL_DeleteFramebuffers(ctx->CurrentServerDispatch, (n, framebuffers));
}


/* VertexAttrib4uiv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4uiv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLuint v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4uiv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4uiv *cmd)
{
   const GLuint index = cmd->index;
   const GLuint * v = cmd->v;
   CALL_VertexAttrib4uiv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4uiv(GLuint index, const GLuint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4uiv);
   struct marshal_cmd_VertexAttrib4uiv *cmd;
   debug_print_marshal("VertexAttrib4uiv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4uiv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4uiv");
   CALL_VertexAttrib4uiv(ctx->CurrentServerDispatch, (index, v));
}


/* VertexAttrib4Nsv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4Nsv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4Nsv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4Nsv *cmd)
{
   const GLuint index = cmd->index;
   const GLshort * v = cmd->v;
   CALL_VertexAttrib4Nsv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4Nsv(GLuint index, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4Nsv);
   struct marshal_cmd_VertexAttrib4Nsv *cmd;
   debug_print_marshal("VertexAttrib4Nsv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4Nsv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4Nsv");
   CALL_VertexAttrib4Nsv(ctx->CurrentServerDispatch, (index, v));
}


/* Vertex4s: marshalled asynchronously */
struct marshal_cmd_Vertex4s
{
   struct marshal_cmd_base cmd_base;
   GLshort x;
   GLshort y;
   GLshort z;
   GLshort w;
};
static inline void
_mesa_unmarshal_Vertex4s(struct gl_context *ctx, const struct marshal_cmd_Vertex4s *cmd)
{
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   const GLshort z = cmd->z;
   const GLshort w = cmd->w;
   CALL_Vertex4s(ctx->CurrentServerDispatch, (x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_Vertex4s(GLshort x, GLshort y, GLshort z, GLshort w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex4s);
   struct marshal_cmd_Vertex4s *cmd;
   debug_print_marshal("Vertex4s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex4s, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex4s");
   CALL_Vertex4s(ctx->CurrentServerDispatch, (x, y, z, w));
}


/* VertexAttribI2iEXT: marshalled asynchronously */
struct marshal_cmd_VertexAttribI2iEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLint x;
   GLint y;
};
static inline void
_mesa_unmarshal_VertexAttribI2iEXT(struct gl_context *ctx, const struct marshal_cmd_VertexAttribI2iEXT *cmd)
{
   const GLuint index = cmd->index;
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   CALL_VertexAttribI2iEXT(ctx->CurrentServerDispatch, (index, x, y));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribI2iEXT(GLuint index, GLint x, GLint y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribI2iEXT);
   struct marshal_cmd_VertexAttribI2iEXT *cmd;
   debug_print_marshal("VertexAttribI2iEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribI2iEXT, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribI2iEXT");
   CALL_VertexAttribI2iEXT(ctx->CurrentServerDispatch, (index, x, y));
}


/* Vertex4f: marshalled asynchronously */
struct marshal_cmd_Vertex4f
{
   struct marshal_cmd_base cmd_base;
   GLfloat x;
   GLfloat y;
   GLfloat z;
   GLfloat w;
};
static inline void
_mesa_unmarshal_Vertex4f(struct gl_context *ctx, const struct marshal_cmd_Vertex4f *cmd)
{
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   const GLfloat w = cmd->w;
   CALL_Vertex4f(ctx->CurrentServerDispatch, (x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_Vertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex4f);
   struct marshal_cmd_Vertex4f *cmd;
   debug_print_marshal("Vertex4f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex4f, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex4f");
   CALL_Vertex4f(ctx->CurrentServerDispatch, (x, y, z, w));
}


/* Vertex4d: marshalled asynchronously */
struct marshal_cmd_Vertex4d
{
   struct marshal_cmd_base cmd_base;
   GLdouble x;
   GLdouble y;
   GLdouble z;
   GLdouble w;
};
static inline void
_mesa_unmarshal_Vertex4d(struct gl_context *ctx, const struct marshal_cmd_Vertex4d *cmd)
{
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   const GLdouble w = cmd->w;
   CALL_Vertex4d(ctx->CurrentServerDispatch, (x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_Vertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex4d);
   struct marshal_cmd_Vertex4d *cmd;
   debug_print_marshal("Vertex4d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex4d, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex4d");
   CALL_Vertex4d(ctx->CurrentServerDispatch, (x, y, z, w));
}


/* VertexAttribL4dv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribL4dv(GLuint index, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribL4dv");
   CALL_VertexAttribL4dv(ctx->CurrentServerDispatch, (index, v));
}


/* GetnUniformi64vARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnUniformi64vARB(GLuint program, GLint location, GLsizei bufSize, GLint64 * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnUniformi64vARB");
   CALL_GetnUniformi64vARB(ctx->CurrentServerDispatch, (program, location, bufSize, params));
}


/* GetTexGenfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTexGenfv(GLenum coord, GLenum pname, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTexGenfv");
   CALL_GetTexGenfv(ctx->CurrentServerDispatch, (coord, pname, params));
}


/* Vertex4i: marshalled asynchronously */
struct marshal_cmd_Vertex4i
{
   struct marshal_cmd_base cmd_base;
   GLint x;
   GLint y;
   GLint z;
   GLint w;
};
static inline void
_mesa_unmarshal_Vertex4i(struct gl_context *ctx, const struct marshal_cmd_Vertex4i *cmd)
{
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLint z = cmd->z;
   const GLint w = cmd->w;
   CALL_Vertex4i(ctx->CurrentServerDispatch, (x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_Vertex4i(GLint x, GLint y, GLint z, GLint w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex4i);
   struct marshal_cmd_Vertex4i *cmd;
   debug_print_marshal("Vertex4i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex4i, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex4i");
   CALL_Vertex4i(ctx->CurrentServerDispatch, (x, y, z, w));
}


/* MemoryBarrierByRegion: marshalled asynchronously */
struct marshal_cmd_MemoryBarrierByRegion
{
   struct marshal_cmd_base cmd_base;
   GLbitfield barriers;
};
static inline void
_mesa_unmarshal_MemoryBarrierByRegion(struct gl_context *ctx, const struct marshal_cmd_MemoryBarrierByRegion *cmd)
{
   const GLbitfield barriers = cmd->barriers;
   CALL_MemoryBarrierByRegion(ctx->CurrentServerDispatch, (barriers));
}
static void GLAPIENTRY
_mesa_marshal_MemoryBarrierByRegion(GLbitfield barriers)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MemoryBarrierByRegion);
   struct marshal_cmd_MemoryBarrierByRegion *cmd;
   debug_print_marshal("MemoryBarrierByRegion");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MemoryBarrierByRegion, cmd_size);
      cmd->barriers = barriers;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MemoryBarrierByRegion");
   CALL_MemoryBarrierByRegion(ctx->CurrentServerDispatch, (barriers));
}


/* StencilFuncSeparateATI: marshalled asynchronously */
struct marshal_cmd_StencilFuncSeparateATI
{
   struct marshal_cmd_base cmd_base;
   GLenum frontfunc;
   GLenum backfunc;
   GLint ref;
   GLuint mask;
};
static inline void
_mesa_unmarshal_StencilFuncSeparateATI(struct gl_context *ctx, const struct marshal_cmd_StencilFuncSeparateATI *cmd)
{
   const GLenum frontfunc = cmd->frontfunc;
   const GLenum backfunc = cmd->backfunc;
   const GLint ref = cmd->ref;
   const GLuint mask = cmd->mask;
   CALL_StencilFuncSeparateATI(ctx->CurrentServerDispatch, (frontfunc, backfunc, ref, mask));
}
static void GLAPIENTRY
_mesa_marshal_StencilFuncSeparateATI(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_StencilFuncSeparateATI);
   struct marshal_cmd_StencilFuncSeparateATI *cmd;
   debug_print_marshal("StencilFuncSeparateATI");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_StencilFuncSeparateATI, cmd_size);
      cmd->frontfunc = frontfunc;
      cmd->backfunc = backfunc;
      cmd->ref = ref;
      cmd->mask = mask;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("StencilFuncSeparateATI");
   CALL_StencilFuncSeparateATI(ctx->CurrentServerDispatch, (frontfunc, backfunc, ref, mask));
}


/* GetVertexAttribIuiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetVertexAttribIuiv(GLuint index, GLenum pname, GLuint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetVertexAttribIuiv");
   CALL_GetVertexAttribIuiv(ctx->CurrentServerDispatch, (index, pname, params));
}


/* LightModelfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_LightModelfv(GLenum pname, const GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("LightModelfv");
   CALL_LightModelfv(ctx->CurrentServerDispatch, (pname, params));
}


/* Vertex4dv: marshalled asynchronously */
struct marshal_cmd_Vertex4dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v[4];
};
static inline void
_mesa_unmarshal_Vertex4dv(struct gl_context *ctx, const struct marshal_cmd_Vertex4dv *cmd)
{
   const GLdouble * v = cmd->v;
   CALL_Vertex4dv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Vertex4dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex4dv);
   struct marshal_cmd_Vertex4dv *cmd;
   debug_print_marshal("Vertex4dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex4dv, cmd_size);
      memcpy(cmd->v, v, 32);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex4dv");
   CALL_Vertex4dv(ctx->CurrentServerDispatch, (v));
}


/* GetInfoLogARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetInfoLogARB(GLhandleARB obj, GLsizei maxLength, GLsizei * length, GLcharARB * infoLog)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetInfoLogARB");
   CALL_GetInfoLogARB(ctx->CurrentServerDispatch, (obj, maxLength, length, infoLog));
}


/* StencilMask: marshalled asynchronously */
struct marshal_cmd_StencilMask
{
   struct marshal_cmd_base cmd_base;
   GLuint mask;
};
static inline void
_mesa_unmarshal_StencilMask(struct gl_context *ctx, const struct marshal_cmd_StencilMask *cmd)
{
   const GLuint mask = cmd->mask;
   CALL_StencilMask(ctx->CurrentServerDispatch, (mask));
}
static void GLAPIENTRY
_mesa_marshal_StencilMask(GLuint mask)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_StencilMask);
   struct marshal_cmd_StencilMask *cmd;
   debug_print_marshal("StencilMask");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_StencilMask, cmd_size);
      cmd->mask = mask;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("StencilMask");
   CALL_StencilMask(ctx->CurrentServerDispatch, (mask));
}


/* NamedFramebufferReadBuffer: marshalled asynchronously */
struct marshal_cmd_NamedFramebufferReadBuffer
{
   struct marshal_cmd_base cmd_base;
   GLuint framebuffer;
   GLenum buf;
};
static inline void
_mesa_unmarshal_NamedFramebufferReadBuffer(struct gl_context *ctx, const struct marshal_cmd_NamedFramebufferReadBuffer *cmd)
{
   const GLuint framebuffer = cmd->framebuffer;
   const GLenum buf = cmd->buf;
   CALL_NamedFramebufferReadBuffer(ctx->CurrentServerDispatch, (framebuffer, buf));
}
static void GLAPIENTRY
_mesa_marshal_NamedFramebufferReadBuffer(GLuint framebuffer, GLenum buf)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_NamedFramebufferReadBuffer);
   struct marshal_cmd_NamedFramebufferReadBuffer *cmd;
   debug_print_marshal("NamedFramebufferReadBuffer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_NamedFramebufferReadBuffer, cmd_size);
      cmd->framebuffer = framebuffer;
      cmd->buf = buf;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("NamedFramebufferReadBuffer");
   CALL_NamedFramebufferReadBuffer(ctx->CurrentServerDispatch, (framebuffer, buf));
}


/* ProgramUniformHandleui64ARB: marshalled asynchronously */
struct marshal_cmd_ProgramUniformHandleui64ARB
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLuint64 value;
};
static inline void
_mesa_unmarshal_ProgramUniformHandleui64ARB(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformHandleui64ARB *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLuint64 value = cmd->value;
   CALL_ProgramUniformHandleui64ARB(ctx->CurrentServerDispatch, (program, location, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformHandleui64ARB(GLuint program, GLint location, GLuint64 value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformHandleui64ARB);
   struct marshal_cmd_ProgramUniformHandleui64ARB *cmd;
   debug_print_marshal("ProgramUniformHandleui64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformHandleui64ARB, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->value = value;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformHandleui64ARB");
   CALL_ProgramUniformHandleui64ARB(ctx->CurrentServerDispatch, (program, location, value));
}


/* ProgramUniform2i64ARB: marshalled asynchronously */
struct marshal_cmd_ProgramUniform2i64ARB
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLint64 x;
   GLint64 y;
};
static inline void
_mesa_unmarshal_ProgramUniform2i64ARB(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform2i64ARB *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLint64 x = cmd->x;
   const GLint64 y = cmd->y;
   CALL_ProgramUniform2i64ARB(ctx->CurrentServerDispatch, (program, location, x, y));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform2i64ARB(GLuint program, GLint location, GLint64 x, GLint64 y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform2i64ARB);
   struct marshal_cmd_ProgramUniform2i64ARB *cmd;
   debug_print_marshal("ProgramUniform2i64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform2i64ARB, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform2i64ARB");
   CALL_ProgramUniform2i64ARB(ctx->CurrentServerDispatch, (program, location, x, y));
}


/* IsList: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsList(GLuint list)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsList");
   return CALL_IsList(ctx->CurrentServerDispatch, (list));
}


/* GetIntegeri_v: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetIntegeri_v(GLenum value, GLuint index, GLint * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetIntegeri_v");
   CALL_GetIntegeri_v(ctx->CurrentServerDispatch, (value, index, data));
}


/* ProgramUniform2iv: marshalled asynchronously */
struct marshal_cmd_ProgramUniform2iv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 8) bytes are GLint value[count][2] */
};
static inline void
_mesa_unmarshal_ProgramUniform2iv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform2iv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLint * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLint *) variable_data;
   variable_data += count * 8;
   CALL_ProgramUniform2iv(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform2iv(GLuint program, GLint location, GLsizei count, const GLint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform2iv) + safe_mul(count, 8);
   struct marshal_cmd_ProgramUniform2iv *cmd;
   debug_print_marshal("ProgramUniform2iv");
   if (unlikely(safe_mul(count, 8) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform2iv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 8);
      variable_data += count * 8;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform2iv");
   CALL_ProgramUniform2iv(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* CreateVertexArrays: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CreateVertexArrays(GLsizei n, GLuint * arrays)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CreateVertexArrays");
   CALL_CreateVertexArrays(ctx->CurrentServerDispatch, (n, arrays));
}


/* FogCoordPointer: marshalled asynchronously */
struct marshal_cmd_FogCoordPointer
{
   struct marshal_cmd_base cmd_base;
   GLenum type;
   GLsizei stride;
   const GLvoid * pointer;
};
static inline void
_mesa_unmarshal_FogCoordPointer(struct gl_context *ctx, const struct marshal_cmd_FogCoordPointer *cmd)
{
   const GLenum type = cmd->type;
   const GLsizei stride = cmd->stride;
   const GLvoid * pointer = cmd->pointer;
   CALL_FogCoordPointer(ctx->CurrentServerDispatch, (type, stride, pointer));
}
static void GLAPIENTRY
_mesa_marshal_FogCoordPointer(GLenum type, GLsizei stride, const GLvoid * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_FogCoordPointer);
   struct marshal_cmd_FogCoordPointer *cmd;
   debug_print_marshal("FogCoordPointer");
   if (_mesa_glthread_is_non_vbo_vertex_attrib_pointer(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("FogCoordPointer");
      CALL_FogCoordPointer(ctx->CurrentServerDispatch, (type, stride, pointer));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_FogCoordPointer, cmd_size);
      cmd->type = type;
      cmd->stride = stride;
      cmd->pointer = pointer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("FogCoordPointer");
   CALL_FogCoordPointer(ctx->CurrentServerDispatch, (type, stride, pointer));
}


/* SecondaryColor3us: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3us
{
   struct marshal_cmd_base cmd_base;
   GLushort red;
   GLushort green;
   GLushort blue;
};
static inline void
_mesa_unmarshal_SecondaryColor3us(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3us *cmd)
{
   const GLushort red = cmd->red;
   const GLushort green = cmd->green;
   const GLushort blue = cmd->blue;
   CALL_SecondaryColor3us(ctx->CurrentServerDispatch, (red, green, blue));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3us(GLushort red, GLushort green, GLushort blue)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3us);
   struct marshal_cmd_SecondaryColor3us *cmd;
   debug_print_marshal("SecondaryColor3us");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3us, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3us");
   CALL_SecondaryColor3us(ctx->CurrentServerDispatch, (red, green, blue));
}


/* TextureStorageMem1DEXT: marshalled asynchronously */
struct marshal_cmd_TextureStorageMem1DEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLsizei levels;
   GLenum internalFormat;
   GLsizei width;
   GLuint memory;
   GLuint64 offset;
};
static inline void
_mesa_unmarshal_TextureStorageMem1DEXT(struct gl_context *ctx, const struct marshal_cmd_TextureStorageMem1DEXT *cmd)
{
   const GLuint texture = cmd->texture;
   const GLsizei levels = cmd->levels;
   const GLenum internalFormat = cmd->internalFormat;
   const GLsizei width = cmd->width;
   const GLuint memory = cmd->memory;
   const GLuint64 offset = cmd->offset;
   CALL_TextureStorageMem1DEXT(ctx->CurrentServerDispatch, (texture, levels, internalFormat, width, memory, offset));
}
static void GLAPIENTRY
_mesa_marshal_TextureStorageMem1DEXT(GLuint texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLuint memory, GLuint64 offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureStorageMem1DEXT);
   struct marshal_cmd_TextureStorageMem1DEXT *cmd;
   debug_print_marshal("TextureStorageMem1DEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureStorageMem1DEXT, cmd_size);
      cmd->texture = texture;
      cmd->levels = levels;
      cmd->internalFormat = internalFormat;
      cmd->width = width;
      cmd->memory = memory;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureStorageMem1DEXT");
   CALL_TextureStorageMem1DEXT(ctx->CurrentServerDispatch, (texture, levels, internalFormat, width, memory, offset));
}


/* SecondaryColor3ub: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3ub
{
   struct marshal_cmd_base cmd_base;
   GLubyte red;
   GLubyte green;
   GLubyte blue;
};
static inline void
_mesa_unmarshal_SecondaryColor3ub(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3ub *cmd)
{
   const GLubyte red = cmd->red;
   const GLubyte green = cmd->green;
   const GLubyte blue = cmd->blue;
   CALL_SecondaryColor3ub(ctx->CurrentServerDispatch, (red, green, blue));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3ub(GLubyte red, GLubyte green, GLubyte blue)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3ub);
   struct marshal_cmd_SecondaryColor3ub *cmd;
   debug_print_marshal("SecondaryColor3ub");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3ub, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3ub");
   CALL_SecondaryColor3ub(ctx->CurrentServerDispatch, (red, green, blue));
}


/* NamedBufferStorageMemEXT: marshalled asynchronously */
struct marshal_cmd_NamedBufferStorageMemEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint buffer;
   GLsizeiptr size;
   GLuint memory;
   GLuint64 offset;
};
static inline void
_mesa_unmarshal_NamedBufferStorageMemEXT(struct gl_context *ctx, const struct marshal_cmd_NamedBufferStorageMemEXT *cmd)
{
   const GLuint buffer = cmd->buffer;
   const GLsizeiptr size = cmd->size;
   const GLuint memory = cmd->memory;
   const GLuint64 offset = cmd->offset;
   CALL_NamedBufferStorageMemEXT(ctx->CurrentServerDispatch, (buffer, size, memory, offset));
}
static void GLAPIENTRY
_mesa_marshal_NamedBufferStorageMemEXT(GLuint buffer, GLsizeiptr size, GLuint memory, GLuint64 offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_NamedBufferStorageMemEXT);
   struct marshal_cmd_NamedBufferStorageMemEXT *cmd;
   debug_print_marshal("NamedBufferStorageMemEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_NamedBufferStorageMemEXT, cmd_size);
      cmd->buffer = buffer;
      cmd->size = size;
      cmd->memory = memory;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("NamedBufferStorageMemEXT");
   CALL_NamedBufferStorageMemEXT(ctx->CurrentServerDispatch, (buffer, size, memory, offset));
}


/* SecondaryColor3ui: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3ui
{
   struct marshal_cmd_base cmd_base;
   GLuint red;
   GLuint green;
   GLuint blue;
};
static inline void
_mesa_unmarshal_SecondaryColor3ui(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3ui *cmd)
{
   const GLuint red = cmd->red;
   const GLuint green = cmd->green;
   const GLuint blue = cmd->blue;
   CALL_SecondaryColor3ui(ctx->CurrentServerDispatch, (red, green, blue));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3ui(GLuint red, GLuint green, GLuint blue)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3ui);
   struct marshal_cmd_SecondaryColor3ui *cmd;
   debug_print_marshal("SecondaryColor3ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3ui, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3ui");
   CALL_SecondaryColor3ui(ctx->CurrentServerDispatch, (red, green, blue));
}


/* ProgramUniform4ui64ARB: marshalled asynchronously */
struct marshal_cmd_ProgramUniform4ui64ARB
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLuint64 x;
   GLuint64 y;
   GLuint64 z;
   GLuint64 w;
};
static inline void
_mesa_unmarshal_ProgramUniform4ui64ARB(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform4ui64ARB *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLuint64 x = cmd->x;
   const GLuint64 y = cmd->y;
   const GLuint64 z = cmd->z;
   const GLuint64 w = cmd->w;
   CALL_ProgramUniform4ui64ARB(ctx->CurrentServerDispatch, (program, location, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform4ui64ARB(GLuint program, GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform4ui64ARB);
   struct marshal_cmd_ProgramUniform4ui64ARB *cmd;
   debug_print_marshal("ProgramUniform4ui64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform4ui64ARB, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform4ui64ARB");
   CALL_ProgramUniform4ui64ARB(ctx->CurrentServerDispatch, (program, location, x, y, z, w));
}


/* VertexAttrib1sNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib1sNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort x;
};
static inline void
_mesa_unmarshal_VertexAttrib1sNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib1sNV *cmd)
{
   const GLuint index = cmd->index;
   const GLshort x = cmd->x;
   CALL_VertexAttrib1sNV(ctx->CurrentServerDispatch, (index, x));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib1sNV(GLuint index, GLshort x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib1sNV);
   struct marshal_cmd_VertexAttrib1sNV *cmd;
   debug_print_marshal("VertexAttrib1sNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib1sNV, cmd_size);
      cmd->index = index;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib1sNV");
   CALL_VertexAttrib1sNV(ctx->CurrentServerDispatch, (index, x));
}


/* SignalSemaphoreEXT: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_SignalSemaphoreEXT(GLuint semaphore, GLuint numBufferBarriers, const GLuint * buffers, GLuint numTextureBarriers, const GLuint * textures, const GLenum * dstLayouts)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("SignalSemaphoreEXT");
   CALL_SignalSemaphoreEXT(ctx->CurrentServerDispatch, (semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, dstLayouts));
}


/* TextureBuffer: marshalled asynchronously */
struct marshal_cmd_TextureBuffer
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLenum internalformat;
   GLuint buffer;
};
static inline void
_mesa_unmarshal_TextureBuffer(struct gl_context *ctx, const struct marshal_cmd_TextureBuffer *cmd)
{
   const GLuint texture = cmd->texture;
   const GLenum internalformat = cmd->internalformat;
   const GLuint buffer = cmd->buffer;
   CALL_TextureBuffer(ctx->CurrentServerDispatch, (texture, internalformat, buffer));
}
static void GLAPIENTRY
_mesa_marshal_TextureBuffer(GLuint texture, GLenum internalformat, GLuint buffer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureBuffer);
   struct marshal_cmd_TextureBuffer *cmd;
   debug_print_marshal("TextureBuffer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureBuffer, cmd_size);
      cmd->texture = texture;
      cmd->internalformat = internalformat;
      cmd->buffer = buffer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureBuffer");
   CALL_TextureBuffer(ctx->CurrentServerDispatch, (texture, internalformat, buffer));
}


/* InitNames: marshalled asynchronously */
struct marshal_cmd_InitNames
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_InitNames(struct gl_context *ctx, const struct marshal_cmd_InitNames *cmd)
{
   CALL_InitNames(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_InitNames(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_InitNames);
   struct marshal_cmd_InitNames *cmd;
   debug_print_marshal("InitNames");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_InitNames, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("InitNames");
   CALL_InitNames(ctx->CurrentServerDispatch, ());
}


/* Normal3sv: marshalled asynchronously */
struct marshal_cmd_Normal3sv
{
   struct marshal_cmd_base cmd_base;
   GLshort v[3];
};
static inline void
_mesa_unmarshal_Normal3sv(struct gl_context *ctx, const struct marshal_cmd_Normal3sv *cmd)
{
   const GLshort * v = cmd->v;
   CALL_Normal3sv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Normal3sv(const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Normal3sv);
   struct marshal_cmd_Normal3sv *cmd;
   debug_print_marshal("Normal3sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Normal3sv, cmd_size);
      memcpy(cmd->v, v, 6);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Normal3sv");
   CALL_Normal3sv(ctx->CurrentServerDispatch, (v));
}


/* DeleteQueries: marshalled asynchronously */
struct marshal_cmd_DeleteQueries
{
   struct marshal_cmd_base cmd_base;
   GLsizei n;
   /* Next safe_mul(n, 4) bytes are GLuint ids[n] */
};
static inline void
_mesa_unmarshal_DeleteQueries(struct gl_context *ctx, const struct marshal_cmd_DeleteQueries *cmd)
{
   const GLsizei n = cmd->n;
   const GLuint * ids;
   const char *variable_data = (const char *) (cmd + 1);
   ids = (const GLuint *) variable_data;
   variable_data += n * 4;
   CALL_DeleteQueries(ctx->CurrentServerDispatch, (n, ids));
}
static void GLAPIENTRY
_mesa_marshal_DeleteQueries(GLsizei n, const GLuint * ids)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DeleteQueries) + safe_mul(n, 4);
   struct marshal_cmd_DeleteQueries *cmd;
   debug_print_marshal("DeleteQueries");
   if (unlikely(safe_mul(n, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DeleteQueries, cmd_size);
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, ids, n * 4);
      variable_data += n * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DeleteQueries");
   CALL_DeleteQueries(ctx->CurrentServerDispatch, (n, ids));
}


/* InvalidateFramebuffer: marshalled asynchronously */
struct marshal_cmd_InvalidateFramebuffer
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizei numAttachments;
   /* Next safe_mul(numAttachments, 4) bytes are GLenum attachments[numAttachments] */
};
static inline void
_mesa_unmarshal_InvalidateFramebuffer(struct gl_context *ctx, const struct marshal_cmd_InvalidateFramebuffer *cmd)
{
   const GLenum target = cmd->target;
   const GLsizei numAttachments = cmd->numAttachments;
   const GLenum * attachments;
   const char *variable_data = (const char *) (cmd + 1);
   attachments = (const GLenum *) variable_data;
   variable_data += numAttachments * 4;
   CALL_InvalidateFramebuffer(ctx->CurrentServerDispatch, (target, numAttachments, attachments));
}
static void GLAPIENTRY
_mesa_marshal_InvalidateFramebuffer(GLenum target, GLsizei numAttachments, const GLenum * attachments)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_InvalidateFramebuffer) + safe_mul(numAttachments, 4);
   struct marshal_cmd_InvalidateFramebuffer *cmd;
   debug_print_marshal("InvalidateFramebuffer");
   if (unlikely(safe_mul(numAttachments, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_InvalidateFramebuffer, cmd_size);
      cmd->target = target;
      cmd->numAttachments = numAttachments;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, attachments, numAttachments * 4);
      variable_data += numAttachments * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("InvalidateFramebuffer");
   CALL_InvalidateFramebuffer(ctx->CurrentServerDispatch, (target, numAttachments, attachments));
}


/* Hint: marshalled asynchronously */
struct marshal_cmd_Hint
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum mode;
};
static inline void
_mesa_unmarshal_Hint(struct gl_context *ctx, const struct marshal_cmd_Hint *cmd)
{
   const GLenum target = cmd->target;
   const GLenum mode = cmd->mode;
   CALL_Hint(ctx->CurrentServerDispatch, (target, mode));
}
static void GLAPIENTRY
_mesa_marshal_Hint(GLenum target, GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Hint);
   struct marshal_cmd_Hint *cmd;
   debug_print_marshal("Hint");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Hint, cmd_size);
      cmd->target = target;
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Hint");
   CALL_Hint(ctx->CurrentServerDispatch, (target, mode));
}


/* MemoryBarrier: marshalled asynchronously */
struct marshal_cmd_MemoryBarrier
{
   struct marshal_cmd_base cmd_base;
   GLbitfield barriers;
};
static inline void
_mesa_unmarshal_MemoryBarrier(struct gl_context *ctx, const struct marshal_cmd_MemoryBarrier *cmd)
{
   const GLbitfield barriers = cmd->barriers;
   CALL_MemoryBarrier(ctx->CurrentServerDispatch, (barriers));
}
static void GLAPIENTRY
_mesa_marshal_MemoryBarrier(GLbitfield barriers)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MemoryBarrier);
   struct marshal_cmd_MemoryBarrier *cmd;
   debug_print_marshal("MemoryBarrier");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MemoryBarrier, cmd_size);
      cmd->barriers = barriers;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MemoryBarrier");
   CALL_MemoryBarrier(ctx->CurrentServerDispatch, (barriers));
}


/* CopyColorSubTable: marshalled asynchronously */
struct marshal_cmd_CopyColorSubTable
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizei start;
   GLint x;
   GLint y;
   GLsizei width;
};
static inline void
_mesa_unmarshal_CopyColorSubTable(struct gl_context *ctx, const struct marshal_cmd_CopyColorSubTable *cmd)
{
   const GLenum target = cmd->target;
   const GLsizei start = cmd->start;
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLsizei width = cmd->width;
   CALL_CopyColorSubTable(ctx->CurrentServerDispatch, (target, start, x, y, width));
}
static void GLAPIENTRY
_mesa_marshal_CopyColorSubTable(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_CopyColorSubTable);
   struct marshal_cmd_CopyColorSubTable *cmd;
   debug_print_marshal("CopyColorSubTable");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_CopyColorSubTable, cmd_size);
      cmd->target = target;
      cmd->start = start;
      cmd->x = x;
      cmd->y = y;
      cmd->width = width;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("CopyColorSubTable");
   CALL_CopyColorSubTable(ctx->CurrentServerDispatch, (target, start, x, y, width));
}


/* GetObjectParameterfvARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetObjectParameterfvARB(GLhandleARB obj, GLenum pname, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetObjectParameterfvARB");
   CALL_GetObjectParameterfvARB(ctx->CurrentServerDispatch, (obj, pname, params));
}


/* GetTexEnvxv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTexEnvxv(GLenum target, GLenum pname, GLfixed * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTexEnvxv");
   CALL_GetTexEnvxv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* DrawTexsvOES: marshalled asynchronously */
struct marshal_cmd_DrawTexsvOES
{
   struct marshal_cmd_base cmd_base;
   GLshort coords[5];
};
static inline void
_mesa_unmarshal_DrawTexsvOES(struct gl_context *ctx, const struct marshal_cmd_DrawTexsvOES *cmd)
{
   const GLshort * coords = cmd->coords;
   CALL_DrawTexsvOES(ctx->CurrentServerDispatch, (coords));
}
static void GLAPIENTRY
_mesa_marshal_DrawTexsvOES(const GLshort * coords)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawTexsvOES);
   struct marshal_cmd_DrawTexsvOES *cmd;
   debug_print_marshal("DrawTexsvOES");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawTexsvOES, cmd_size);
      memcpy(cmd->coords, coords, 10);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawTexsvOES");
   CALL_DrawTexsvOES(ctx->CurrentServerDispatch, (coords));
}


/* Disable: marshalled asynchronously */
struct marshal_cmd_Disable
{
   struct marshal_cmd_base cmd_base;
   GLenum cap;
};
static inline void
_mesa_unmarshal_Disable(struct gl_context *ctx, const struct marshal_cmd_Disable *cmd)
{
   const GLenum cap = cmd->cap;
   CALL_Disable(ctx->CurrentServerDispatch, (cap));
}
static void GLAPIENTRY
_mesa_marshal_Disable(GLenum cap)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Disable);
   struct marshal_cmd_Disable *cmd;
   debug_print_marshal("Disable");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Disable, cmd_size);
      cmd->cap = cap;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Disable");
   CALL_Disable(ctx->CurrentServerDispatch, (cap));
}


/* ClearColor: marshalled asynchronously */
struct marshal_cmd_ClearColor
{
   struct marshal_cmd_base cmd_base;
   GLclampf red;
   GLclampf green;
   GLclampf blue;
   GLclampf alpha;
};
static inline void
_mesa_unmarshal_ClearColor(struct gl_context *ctx, const struct marshal_cmd_ClearColor *cmd)
{
   const GLclampf red = cmd->red;
   const GLclampf green = cmd->green;
   const GLclampf blue = cmd->blue;
   const GLclampf alpha = cmd->alpha;
   CALL_ClearColor(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}
static void GLAPIENTRY
_mesa_marshal_ClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClearColor);
   struct marshal_cmd_ClearColor *cmd;
   debug_print_marshal("ClearColor");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClearColor, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      cmd->alpha = alpha;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClearColor");
   CALL_ClearColor(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}


/* GetTextureParameterIuiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTextureParameterIuiv(GLuint texture, GLenum pname, GLuint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTextureParameterIuiv");
   CALL_GetTextureParameterIuiv(ctx->CurrentServerDispatch, (texture, pname, params));
}


/* RasterPos4iv: marshalled asynchronously */
struct marshal_cmd_RasterPos4iv
{
   struct marshal_cmd_base cmd_base;
   GLint v[4];
};
static inline void
_mesa_unmarshal_RasterPos4iv(struct gl_context *ctx, const struct marshal_cmd_RasterPos4iv *cmd)
{
   const GLint * v = cmd->v;
   CALL_RasterPos4iv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos4iv(const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos4iv);
   struct marshal_cmd_RasterPos4iv *cmd;
   debug_print_marshal("RasterPos4iv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos4iv, cmd_size);
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos4iv");
   CALL_RasterPos4iv(ctx->CurrentServerDispatch, (v));
}


/* VDPAUIsSurfaceNV: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_VDPAUIsSurfaceNV(GLintptr surface)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VDPAUIsSurfaceNV");
   return CALL_VDPAUIsSurfaceNV(ctx->CurrentServerDispatch, (surface));
}


/* ProgramUniformMatrix2x3fv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix2x3fv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 24) bytes are GLfloat value[count][6] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix2x3fv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix2x3fv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 24;
   CALL_ProgramUniformMatrix2x3fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix2x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix2x3fv) + safe_mul(count, 24);
   struct marshal_cmd_ProgramUniformMatrix2x3fv *cmd;
   debug_print_marshal("ProgramUniformMatrix2x3fv");
   if (unlikely(safe_mul(count, 24) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix2x3fv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 24);
      variable_data += count * 24;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix2x3fv");
   CALL_ProgramUniformMatrix2x3fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* BindVertexBuffer: marshalled asynchronously */
struct marshal_cmd_BindVertexBuffer
{
   struct marshal_cmd_base cmd_base;
   GLuint bindingindex;
   GLuint buffer;
   GLintptr offset;
   GLsizei stride;
};
static inline void
_mesa_unmarshal_BindVertexBuffer(struct gl_context *ctx, const struct marshal_cmd_BindVertexBuffer *cmd)
{
   const GLuint bindingindex = cmd->bindingindex;
   const GLuint buffer = cmd->buffer;
   const GLintptr offset = cmd->offset;
   const GLsizei stride = cmd->stride;
   CALL_BindVertexBuffer(ctx->CurrentServerDispatch, (bindingindex, buffer, offset, stride));
}
static void GLAPIENTRY
_mesa_marshal_BindVertexBuffer(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindVertexBuffer);
   struct marshal_cmd_BindVertexBuffer *cmd;
   debug_print_marshal("BindVertexBuffer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindVertexBuffer, cmd_size);
      cmd->bindingindex = bindingindex;
      cmd->buffer = buffer;
      cmd->offset = offset;
      cmd->stride = stride;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindVertexBuffer");
   CALL_BindVertexBuffer(ctx->CurrentServerDispatch, (bindingindex, buffer, offset, stride));
}


/* RasterPos4i: marshalled asynchronously */
struct marshal_cmd_RasterPos4i
{
   struct marshal_cmd_base cmd_base;
   GLint x;
   GLint y;
   GLint z;
   GLint w;
};
static inline void
_mesa_unmarshal_RasterPos4i(struct gl_context *ctx, const struct marshal_cmd_RasterPos4i *cmd)
{
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLint z = cmd->z;
   const GLint w = cmd->w;
   CALL_RasterPos4i(ctx->CurrentServerDispatch, (x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos4i(GLint x, GLint y, GLint z, GLint w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos4i);
   struct marshal_cmd_RasterPos4i *cmd;
   debug_print_marshal("RasterPos4i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos4i, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos4i");
   CALL_RasterPos4i(ctx->CurrentServerDispatch, (x, y, z, w));
}


/* RasterPos4d: marshalled asynchronously */
struct marshal_cmd_RasterPos4d
{
   struct marshal_cmd_base cmd_base;
   GLdouble x;
   GLdouble y;
   GLdouble z;
   GLdouble w;
};
static inline void
_mesa_unmarshal_RasterPos4d(struct gl_context *ctx, const struct marshal_cmd_RasterPos4d *cmd)
{
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   const GLdouble w = cmd->w;
   CALL_RasterPos4d(ctx->CurrentServerDispatch, (x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos4d);
   struct marshal_cmd_RasterPos4d *cmd;
   debug_print_marshal("RasterPos4d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos4d, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos4d");
   CALL_RasterPos4d(ctx->CurrentServerDispatch, (x, y, z, w));
}


/* RasterPos4f: marshalled asynchronously */
struct marshal_cmd_RasterPos4f
{
   struct marshal_cmd_base cmd_base;
   GLfloat x;
   GLfloat y;
   GLfloat z;
   GLfloat w;
};
static inline void
_mesa_unmarshal_RasterPos4f(struct gl_context *ctx, const struct marshal_cmd_RasterPos4f *cmd)
{
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   const GLfloat w = cmd->w;
   CALL_RasterPos4f(ctx->CurrentServerDispatch, (x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos4f);
   struct marshal_cmd_RasterPos4f *cmd;
   debug_print_marshal("RasterPos4f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos4f, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos4f");
   CALL_RasterPos4f(ctx->CurrentServerDispatch, (x, y, z, w));
}


/* VDPAUMapSurfacesNV: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VDPAUMapSurfacesNV(GLsizei numSurfaces, const GLintptr * surfaces)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VDPAUMapSurfacesNV");
   CALL_VDPAUMapSurfacesNV(ctx->CurrentServerDispatch, (numSurfaces, surfaces));
}


/* GetQueryIndexediv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetQueryIndexediv(GLenum target, GLuint index, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetQueryIndexediv");
   CALL_GetQueryIndexediv(ctx->CurrentServerDispatch, (target, index, pname, params));
}


/* RasterPos3dv: marshalled asynchronously */
struct marshal_cmd_RasterPos3dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v[3];
};
static inline void
_mesa_unmarshal_RasterPos3dv(struct gl_context *ctx, const struct marshal_cmd_RasterPos3dv *cmd)
{
   const GLdouble * v = cmd->v;
   CALL_RasterPos3dv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos3dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos3dv);
   struct marshal_cmd_RasterPos3dv *cmd;
   debug_print_marshal("RasterPos3dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos3dv, cmd_size);
      memcpy(cmd->v, v, 24);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos3dv");
   CALL_RasterPos3dv(ctx->CurrentServerDispatch, (v));
}


/* GetProgramiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetProgramiv(GLuint program, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramiv");
   CALL_GetProgramiv(ctx->CurrentServerDispatch, (program, pname, params));
}


/* TexCoord1iv: marshalled asynchronously */
struct marshal_cmd_TexCoord1iv
{
   struct marshal_cmd_base cmd_base;
   GLint v[1];
};
static inline void
_mesa_unmarshal_TexCoord1iv(struct gl_context *ctx, const struct marshal_cmd_TexCoord1iv *cmd)
{
   const GLint * v = cmd->v;
   CALL_TexCoord1iv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord1iv(const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord1iv);
   struct marshal_cmd_TexCoord1iv *cmd;
   debug_print_marshal("TexCoord1iv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord1iv, cmd_size);
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord1iv");
   CALL_TexCoord1iv(ctx->CurrentServerDispatch, (v));
}


/* RasterPos4s: marshalled asynchronously */
struct marshal_cmd_RasterPos4s
{
   struct marshal_cmd_base cmd_base;
   GLshort x;
   GLshort y;
   GLshort z;
   GLshort w;
};
static inline void
_mesa_unmarshal_RasterPos4s(struct gl_context *ctx, const struct marshal_cmd_RasterPos4s *cmd)
{
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   const GLshort z = cmd->z;
   const GLshort w = cmd->w;
   CALL_RasterPos4s(ctx->CurrentServerDispatch, (x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos4s);
   struct marshal_cmd_RasterPos4s *cmd;
   debug_print_marshal("RasterPos4s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos4s, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos4s");
   CALL_RasterPos4s(ctx->CurrentServerDispatch, (x, y, z, w));
}


/* VertexAttrib3dv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib3dv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble v[3];
};
static inline void
_mesa_unmarshal_VertexAttrib3dv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib3dv *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble * v = cmd->v;
   CALL_VertexAttrib3dv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib3dv(GLuint index, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib3dv);
   struct marshal_cmd_VertexAttrib3dv *cmd;
   debug_print_marshal("VertexAttrib3dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib3dv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 24);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib3dv");
   CALL_VertexAttrib3dv(ctx->CurrentServerDispatch, (index, v));
}


/* Histogram: marshalled asynchronously */
struct marshal_cmd_Histogram
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizei width;
   GLenum internalformat;
   GLboolean sink;
};
static inline void
_mesa_unmarshal_Histogram(struct gl_context *ctx, const struct marshal_cmd_Histogram *cmd)
{
   const GLenum target = cmd->target;
   const GLsizei width = cmd->width;
   const GLenum internalformat = cmd->internalformat;
   const GLboolean sink = cmd->sink;
   CALL_Histogram(ctx->CurrentServerDispatch, (target, width, internalformat, sink));
}
static void GLAPIENTRY
_mesa_marshal_Histogram(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Histogram);
   struct marshal_cmd_Histogram *cmd;
   debug_print_marshal("Histogram");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Histogram, cmd_size);
      cmd->target = target;
      cmd->width = width;
      cmd->internalformat = internalformat;
      cmd->sink = sink;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Histogram");
   CALL_Histogram(ctx->CurrentServerDispatch, (target, width, internalformat, sink));
}


/* Uniform2fv: marshalled asynchronously */
struct marshal_cmd_Uniform2fv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 8) bytes are GLfloat value[count][2] */
};
static inline void
_mesa_unmarshal_Uniform2fv(struct gl_context *ctx, const struct marshal_cmd_Uniform2fv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 8;
   CALL_Uniform2fv(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform2fv(GLint location, GLsizei count, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform2fv) + safe_mul(count, 8);
   struct marshal_cmd_Uniform2fv *cmd;
   debug_print_marshal("Uniform2fv");
   if (unlikely(safe_mul(count, 8) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform2fv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 8);
      variable_data += count * 8;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform2fv");
   CALL_Uniform2fv(ctx->CurrentServerDispatch, (location, count, value));
}


/* ProgramUniformMatrix3x4dv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix3x4dv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 96) bytes are GLdouble value[count][12] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix3x4dv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix3x4dv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 96;
   CALL_ProgramUniformMatrix3x4dv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix3x4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix3x4dv) + safe_mul(count, 96);
   struct marshal_cmd_ProgramUniformMatrix3x4dv *cmd;
   debug_print_marshal("ProgramUniformMatrix3x4dv");
   if (unlikely(safe_mul(count, 96) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix3x4dv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 96);
      variable_data += count * 96;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix3x4dv");
   CALL_ProgramUniformMatrix3x4dv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* DrawBuffers: marshalled asynchronously */
struct marshal_cmd_DrawBuffers
{
   struct marshal_cmd_base cmd_base;
   GLsizei n;
   /* Next safe_mul(n, 4) bytes are GLenum bufs[n] */
};
static inline void
_mesa_unmarshal_DrawBuffers(struct gl_context *ctx, const struct marshal_cmd_DrawBuffers *cmd)
{
   const GLsizei n = cmd->n;
   const GLenum * bufs;
   const char *variable_data = (const char *) (cmd + 1);
   bufs = (const GLenum *) variable_data;
   variable_data += n * 4;
   CALL_DrawBuffers(ctx->CurrentServerDispatch, (n, bufs));
}
static void GLAPIENTRY
_mesa_marshal_DrawBuffers(GLsizei n, const GLenum * bufs)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawBuffers) + safe_mul(n, 4);
   struct marshal_cmd_DrawBuffers *cmd;
   debug_print_marshal("DrawBuffers");
   if (unlikely(safe_mul(n, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawBuffers, cmd_size);
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, bufs, n * 4);
      variable_data += n * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawBuffers");
   CALL_DrawBuffers(ctx->CurrentServerDispatch, (n, bufs));
}


/* VertexAttribL1ui64ARB: marshalled asynchronously */
struct marshal_cmd_VertexAttribL1ui64ARB
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLuint64EXT x;
};
static inline void
_mesa_unmarshal_VertexAttribL1ui64ARB(struct gl_context *ctx, const struct marshal_cmd_VertexAttribL1ui64ARB *cmd)
{
   const GLuint index = cmd->index;
   const GLuint64EXT x = cmd->x;
   CALL_VertexAttribL1ui64ARB(ctx->CurrentServerDispatch, (index, x));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribL1ui64ARB(GLuint index, GLuint64EXT x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribL1ui64ARB);
   struct marshal_cmd_VertexAttribL1ui64ARB *cmd;
   debug_print_marshal("VertexAttribL1ui64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribL1ui64ARB, cmd_size);
      cmd->index = index;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribL1ui64ARB");
   CALL_VertexAttribL1ui64ARB(ctx->CurrentServerDispatch, (index, x));
}


/* GetnPolygonStippleARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnPolygonStippleARB(GLsizei bufSize, GLubyte * pattern)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnPolygonStippleARB");
   CALL_GetnPolygonStippleARB(ctx->CurrentServerDispatch, (bufSize, pattern));
}


/* Color3uiv: marshalled asynchronously */
struct marshal_cmd_Color3uiv
{
   struct marshal_cmd_base cmd_base;
   GLuint v[3];
};
static inline void
_mesa_unmarshal_Color3uiv(struct gl_context *ctx, const struct marshal_cmd_Color3uiv *cmd)
{
   const GLuint * v = cmd->v;
   CALL_Color3uiv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Color3uiv(const GLuint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color3uiv);
   struct marshal_cmd_Color3uiv *cmd;
   debug_print_marshal("Color3uiv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color3uiv, cmd_size);
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color3uiv");
   CALL_Color3uiv(ctx->CurrentServerDispatch, (v));
}


/* EvalCoord2fv: marshalled asynchronously */
struct marshal_cmd_EvalCoord2fv
{
   struct marshal_cmd_base cmd_base;
   GLfloat u[2];
};
static inline void
_mesa_unmarshal_EvalCoord2fv(struct gl_context *ctx, const struct marshal_cmd_EvalCoord2fv *cmd)
{
   const GLfloat * u = cmd->u;
   CALL_EvalCoord2fv(ctx->CurrentServerDispatch, (u));
}
static void GLAPIENTRY
_mesa_marshal_EvalCoord2fv(const GLfloat * u)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EvalCoord2fv);
   struct marshal_cmd_EvalCoord2fv *cmd;
   debug_print_marshal("EvalCoord2fv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EvalCoord2fv, cmd_size);
      memcpy(cmd->u, u, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EvalCoord2fv");
   CALL_EvalCoord2fv(ctx->CurrentServerDispatch, (u));
}


/* TextureStorage3DEXT: marshalled asynchronously */
struct marshal_cmd_TextureStorage3DEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLenum target;
   GLsizei levels;
   GLenum internalFormat;
   GLsizei width;
   GLsizei height;
   GLsizei depth;
};
static inline void
_mesa_unmarshal_TextureStorage3DEXT(struct gl_context *ctx, const struct marshal_cmd_TextureStorage3DEXT *cmd)
{
   const GLuint texture = cmd->texture;
   const GLenum target = cmd->target;
   const GLsizei levels = cmd->levels;
   const GLenum internalFormat = cmd->internalFormat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLsizei depth = cmd->depth;
   CALL_TextureStorage3DEXT(ctx->CurrentServerDispatch, (texture, target, levels, internalFormat, width, height, depth));
}
static void GLAPIENTRY
_mesa_marshal_TextureStorage3DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureStorage3DEXT);
   struct marshal_cmd_TextureStorage3DEXT *cmd;
   debug_print_marshal("TextureStorage3DEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureStorage3DEXT, cmd_size);
      cmd->texture = texture;
      cmd->target = target;
      cmd->levels = levels;
      cmd->internalFormat = internalFormat;
      cmd->width = width;
      cmd->height = height;
      cmd->depth = depth;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureStorage3DEXT");
   CALL_TextureStorage3DEXT(ctx->CurrentServerDispatch, (texture, target, levels, internalFormat, width, height, depth));
}


/* VertexAttrib2fARB: marshalled asynchronously */
struct marshal_cmd_VertexAttrib2fARB
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat x;
   GLfloat y;
};
static inline void
_mesa_unmarshal_VertexAttrib2fARB(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib2fARB *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   CALL_VertexAttrib2fARB(ctx->CurrentServerDispatch, (index, x, y));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib2fARB(GLuint index, GLfloat x, GLfloat y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib2fARB);
   struct marshal_cmd_VertexAttrib2fARB *cmd;
   debug_print_marshal("VertexAttrib2fARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib2fARB, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib2fARB");
   CALL_VertexAttrib2fARB(ctx->CurrentServerDispatch, (index, x, y));
}


/* SpecializeShaderARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_SpecializeShaderARB(GLuint shader, const GLchar * pEntryPoint, GLuint numSpecializationConstants, const GLuint * pConstantIndex, const GLuint * pConstantValue)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("SpecializeShaderARB");
   CALL_SpecializeShaderARB(ctx->CurrentServerDispatch, (shader, pEntryPoint, numSpecializationConstants, pConstantIndex, pConstantValue));
}


/* BeginPerfMonitorAMD: marshalled asynchronously */
struct marshal_cmd_BeginPerfMonitorAMD
{
   struct marshal_cmd_base cmd_base;
   GLuint monitor;
};
static inline void
_mesa_unmarshal_BeginPerfMonitorAMD(struct gl_context *ctx, const struct marshal_cmd_BeginPerfMonitorAMD *cmd)
{
   const GLuint monitor = cmd->monitor;
   CALL_BeginPerfMonitorAMD(ctx->CurrentServerDispatch, (monitor));
}
static void GLAPIENTRY
_mesa_marshal_BeginPerfMonitorAMD(GLuint monitor)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BeginPerfMonitorAMD);
   struct marshal_cmd_BeginPerfMonitorAMD *cmd;
   debug_print_marshal("BeginPerfMonitorAMD");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BeginPerfMonitorAMD, cmd_size);
      cmd->monitor = monitor;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BeginPerfMonitorAMD");
   CALL_BeginPerfMonitorAMD(ctx->CurrentServerDispatch, (monitor));
}


/* WindowPos2fv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_WindowPos2fv(const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("WindowPos2fv");
   CALL_WindowPos2fv(ctx->CurrentServerDispatch, (v));
}


/* TexImage3D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexImage3D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexImage3D");
   CALL_TexImage3D(ctx->CurrentServerDispatch, (target, level, internalformat, width, height, depth, border, format, type, pixels));
}


/* GetPerfQueryIdByNameINTEL: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetPerfQueryIdByNameINTEL(GLchar * queryName, GLuint * queryId)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetPerfQueryIdByNameINTEL");
   CALL_GetPerfQueryIdByNameINTEL(ctx->CurrentServerDispatch, (queryName, queryId));
}


/* BindFragDataLocation: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_BindFragDataLocation(GLuint program, GLuint colorNumber, const GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("BindFragDataLocation");
   CALL_BindFragDataLocation(ctx->CurrentServerDispatch, (program, colorNumber, name));
}


/* LightModeliv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_LightModeliv(GLenum pname, const GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("LightModeliv");
   CALL_LightModeliv(ctx->CurrentServerDispatch, (pname, params));
}


/* Normal3bv: marshalled asynchronously */
struct marshal_cmd_Normal3bv
{
   struct marshal_cmd_base cmd_base;
   GLbyte v[3];
};
static inline void
_mesa_unmarshal_Normal3bv(struct gl_context *ctx, const struct marshal_cmd_Normal3bv *cmd)
{
   const GLbyte * v = cmd->v;
   CALL_Normal3bv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Normal3bv(const GLbyte * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Normal3bv);
   struct marshal_cmd_Normal3bv *cmd;
   debug_print_marshal("Normal3bv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Normal3bv, cmd_size);
      memcpy(cmd->v, v, 3);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Normal3bv");
   CALL_Normal3bv(ctx->CurrentServerDispatch, (v));
}


/* BeginQueryIndexed: marshalled asynchronously */
struct marshal_cmd_BeginQueryIndexed
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
   GLuint id;
};
static inline void
_mesa_unmarshal_BeginQueryIndexed(struct gl_context *ctx, const struct marshal_cmd_BeginQueryIndexed *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   const GLuint id = cmd->id;
   CALL_BeginQueryIndexed(ctx->CurrentServerDispatch, (target, index, id));
}
static void GLAPIENTRY
_mesa_marshal_BeginQueryIndexed(GLenum target, GLuint index, GLuint id)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BeginQueryIndexed);
   struct marshal_cmd_BeginQueryIndexed *cmd;
   debug_print_marshal("BeginQueryIndexed");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BeginQueryIndexed, cmd_size);
      cmd->target = target;
      cmd->index = index;
      cmd->id = id;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BeginQueryIndexed");
   CALL_BeginQueryIndexed(ctx->CurrentServerDispatch, (target, index, id));
}


/* ClearNamedBufferData: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ClearNamedBufferData(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const GLvoid * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ClearNamedBufferData");
   CALL_ClearNamedBufferData(ctx->CurrentServerDispatch, (buffer, internalformat, format, type, data));
}


/* Vertex3iv: marshalled asynchronously */
struct marshal_cmd_Vertex3iv
{
   struct marshal_cmd_base cmd_base;
   GLint v[3];
};
static inline void
_mesa_unmarshal_Vertex3iv(struct gl_context *ctx, const struct marshal_cmd_Vertex3iv *cmd)
{
   const GLint * v = cmd->v;
   CALL_Vertex3iv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Vertex3iv(const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex3iv);
   struct marshal_cmd_Vertex3iv *cmd;
   debug_print_marshal("Vertex3iv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex3iv, cmd_size);
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex3iv");
   CALL_Vertex3iv(ctx->CurrentServerDispatch, (v));
}


/* UniformMatrix2x3dv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix2x3dv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 48) bytes are GLdouble value[count][6] */
};
static inline void
_mesa_unmarshal_UniformMatrix2x3dv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix2x3dv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 48;
   CALL_UniformMatrix2x3dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix2x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix2x3dv) + safe_mul(count, 48);
   struct marshal_cmd_UniformMatrix2x3dv *cmd;
   debug_print_marshal("UniformMatrix2x3dv");
   if (unlikely(safe_mul(count, 48) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix2x3dv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 48);
      variable_data += count * 48;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix2x3dv");
   CALL_UniformMatrix2x3dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* UniformHandleui64vARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_UniformHandleui64vARB(GLint location, GLsizei count, const GLuint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("UniformHandleui64vARB");
   CALL_UniformHandleui64vARB(ctx->CurrentServerDispatch, (location, count, value));
}


/* TexCoord3dv: marshalled asynchronously */
struct marshal_cmd_TexCoord3dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v[3];
};
static inline void
_mesa_unmarshal_TexCoord3dv(struct gl_context *ctx, const struct marshal_cmd_TexCoord3dv *cmd)
{
   const GLdouble * v = cmd->v;
   CALL_TexCoord3dv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord3dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord3dv);
   struct marshal_cmd_TexCoord3dv *cmd;
   debug_print_marshal("TexCoord3dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord3dv, cmd_size);
      memcpy(cmd->v, v, 24);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord3dv");
   CALL_TexCoord3dv(ctx->CurrentServerDispatch, (v));
}


/* GetProgramStringARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetProgramStringARB(GLenum target, GLenum pname, GLvoid * string)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramStringARB");
   CALL_GetProgramStringARB(ctx->CurrentServerDispatch, (target, pname, string));
}


/* VertexP3ui: marshalled asynchronously */
struct marshal_cmd_VertexP3ui
{
   struct marshal_cmd_base cmd_base;
   GLenum type;
   GLuint value;
};
static inline void
_mesa_unmarshal_VertexP3ui(struct gl_context *ctx, const struct marshal_cmd_VertexP3ui *cmd)
{
   const GLenum type = cmd->type;
   const GLuint value = cmd->value;
   CALL_VertexP3ui(ctx->CurrentServerDispatch, (type, value));
}
static void GLAPIENTRY
_mesa_marshal_VertexP3ui(GLenum type, GLuint value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexP3ui);
   struct marshal_cmd_VertexP3ui *cmd;
   debug_print_marshal("VertexP3ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexP3ui, cmd_size);
      cmd->type = type;
      cmd->value = value;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexP3ui");
   CALL_VertexP3ui(ctx->CurrentServerDispatch, (type, value));
}


/* CreateProgramObjectARB: marshalled synchronously */
static GLhandleARB GLAPIENTRY
_mesa_marshal_CreateProgramObjectARB(void)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CreateProgramObjectARB");
   return CALL_CreateProgramObjectARB(ctx->CurrentServerDispatch, ());
}


/* UniformMatrix3fv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix3fv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 36) bytes are GLfloat value[count][9] */
};
static inline void
_mesa_unmarshal_UniformMatrix3fv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix3fv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 36;
   CALL_UniformMatrix3fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix3fv) + safe_mul(count, 36);
   struct marshal_cmd_UniformMatrix3fv *cmd;
   debug_print_marshal("UniformMatrix3fv");
   if (unlikely(safe_mul(count, 36) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix3fv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 36);
      variable_data += count * 36;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix3fv");
   CALL_UniformMatrix3fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* PrioritizeTextures: marshalled asynchronously */
struct marshal_cmd_PrioritizeTextures
{
   struct marshal_cmd_base cmd_base;
   GLsizei n;
   /* Next safe_mul(n, 4) bytes are GLuint textures[n] */
   /* Next safe_mul(n, 4) bytes are GLclampf priorities[n] */
};
static inline void
_mesa_unmarshal_PrioritizeTextures(struct gl_context *ctx, const struct marshal_cmd_PrioritizeTextures *cmd)
{
   const GLsizei n = cmd->n;
   const GLuint * textures;
   const GLclampf * priorities;
   const char *variable_data = (const char *) (cmd + 1);
   textures = (const GLuint *) variable_data;
   variable_data += n * 4;
   priorities = (const GLclampf *) variable_data;
   variable_data += n * 4;
   CALL_PrioritizeTextures(ctx->CurrentServerDispatch, (n, textures, priorities));
}
static void GLAPIENTRY
_mesa_marshal_PrioritizeTextures(GLsizei n, const GLuint * textures, const GLclampf * priorities)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PrioritizeTextures) + safe_mul(n, 4) + safe_mul(n, 4);
   struct marshal_cmd_PrioritizeTextures *cmd;
   debug_print_marshal("PrioritizeTextures");
   if (unlikely(safe_mul(n, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PrioritizeTextures, cmd_size);
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, textures, n * 4);
      variable_data += n * 4;
      memcpy(variable_data, priorities, n * 4);
      variable_data += n * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PrioritizeTextures");
   CALL_PrioritizeTextures(ctx->CurrentServerDispatch, (n, textures, priorities));
}


/* VertexAttribI3uiEXT: marshalled asynchronously */
struct marshal_cmd_VertexAttribI3uiEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLuint x;
   GLuint y;
   GLuint z;
};
static inline void
_mesa_unmarshal_VertexAttribI3uiEXT(struct gl_context *ctx, const struct marshal_cmd_VertexAttribI3uiEXT *cmd)
{
   const GLuint index = cmd->index;
   const GLuint x = cmd->x;
   const GLuint y = cmd->y;
   const GLuint z = cmd->z;
   CALL_VertexAttribI3uiEXT(ctx->CurrentServerDispatch, (index, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribI3uiEXT(GLuint index, GLuint x, GLuint y, GLuint z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribI3uiEXT);
   struct marshal_cmd_VertexAttribI3uiEXT *cmd;
   debug_print_marshal("VertexAttribI3uiEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribI3uiEXT, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribI3uiEXT");
   CALL_VertexAttribI3uiEXT(ctx->CurrentServerDispatch, (index, x, y, z));
}


/* ProgramUniform1i64ARB: marshalled asynchronously */
struct marshal_cmd_ProgramUniform1i64ARB
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLint64 x;
};
static inline void
_mesa_unmarshal_ProgramUniform1i64ARB(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform1i64ARB *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLint64 x = cmd->x;
   CALL_ProgramUniform1i64ARB(ctx->CurrentServerDispatch, (program, location, x));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform1i64ARB(GLuint program, GLint location, GLint64 x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform1i64ARB);
   struct marshal_cmd_ProgramUniform1i64ARB *cmd;
   debug_print_marshal("ProgramUniform1i64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform1i64ARB, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform1i64ARB");
   CALL_ProgramUniform1i64ARB(ctx->CurrentServerDispatch, (program, location, x));
}


/* GetMaterialxv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetMaterialxv(GLenum face, GLenum pname, GLfixed * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetMaterialxv");
   CALL_GetMaterialxv(ctx->CurrentServerDispatch, (face, pname, params));
}


/* SecondaryColor3uiv: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3uiv
{
   struct marshal_cmd_base cmd_base;
   GLuint v[3];
};
static inline void
_mesa_unmarshal_SecondaryColor3uiv(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3uiv *cmd)
{
   const GLuint * v = cmd->v;
   CALL_SecondaryColor3uiv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3uiv(const GLuint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3uiv);
   struct marshal_cmd_SecondaryColor3uiv *cmd;
   debug_print_marshal("SecondaryColor3uiv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3uiv, cmd_size);
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3uiv");
   CALL_SecondaryColor3uiv(ctx->CurrentServerDispatch, (v));
}


/* EndConditionalRender: marshalled asynchronously */
struct marshal_cmd_EndConditionalRender
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_EndConditionalRender(struct gl_context *ctx, const struct marshal_cmd_EndConditionalRender *cmd)
{
   CALL_EndConditionalRender(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_EndConditionalRender(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EndConditionalRender);
   struct marshal_cmd_EndConditionalRender *cmd;
   debug_print_marshal("EndConditionalRender");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EndConditionalRender, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EndConditionalRender");
   CALL_EndConditionalRender(ctx->CurrentServerDispatch, ());
}


/* ProgramLocalParameter4dARB: marshalled asynchronously */
struct marshal_cmd_ProgramLocalParameter4dARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
   GLdouble x;
   GLdouble y;
   GLdouble z;
   GLdouble w;
};
static inline void
_mesa_unmarshal_ProgramLocalParameter4dARB(struct gl_context *ctx, const struct marshal_cmd_ProgramLocalParameter4dARB *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   const GLdouble w = cmd->w;
   CALL_ProgramLocalParameter4dARB(ctx->CurrentServerDispatch, (target, index, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_ProgramLocalParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramLocalParameter4dARB);
   struct marshal_cmd_ProgramLocalParameter4dARB *cmd;
   debug_print_marshal("ProgramLocalParameter4dARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramLocalParameter4dARB, cmd_size);
      cmd->target = target;
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramLocalParameter4dARB");
   CALL_ProgramLocalParameter4dARB(ctx->CurrentServerDispatch, (target, index, x, y, z, w));
}


/* Color3sv: marshalled asynchronously */
struct marshal_cmd_Color3sv
{
   struct marshal_cmd_base cmd_base;
   GLshort v[3];
};
static inline void
_mesa_unmarshal_Color3sv(struct gl_context *ctx, const struct marshal_cmd_Color3sv *cmd)
{
   const GLshort * v = cmd->v;
   CALL_Color3sv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Color3sv(const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color3sv);
   struct marshal_cmd_Color3sv *cmd;
   debug_print_marshal("Color3sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color3sv, cmd_size);
      memcpy(cmd->v, v, 6);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color3sv");
   CALL_Color3sv(ctx->CurrentServerDispatch, (v));
}


/* GenFragmentShadersATI: marshalled synchronously */
static GLuint GLAPIENTRY
_mesa_marshal_GenFragmentShadersATI(GLuint range)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GenFragmentShadersATI");
   return CALL_GenFragmentShadersATI(ctx->CurrentServerDispatch, (range));
}


/* GetNamedBufferParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetNamedBufferParameteriv(GLuint buffer, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetNamedBufferParameteriv");
   CALL_GetNamedBufferParameteriv(ctx->CurrentServerDispatch, (buffer, pname, params));
}


/* BlendEquationSeparateiARB: marshalled asynchronously */
struct marshal_cmd_BlendEquationSeparateiARB
{
   struct marshal_cmd_base cmd_base;
   GLuint buf;
   GLenum modeRGB;
   GLenum modeA;
};
static inline void
_mesa_unmarshal_BlendEquationSeparateiARB(struct gl_context *ctx, const struct marshal_cmd_BlendEquationSeparateiARB *cmd)
{
   const GLuint buf = cmd->buf;
   const GLenum modeRGB = cmd->modeRGB;
   const GLenum modeA = cmd->modeA;
   CALL_BlendEquationSeparateiARB(ctx->CurrentServerDispatch, (buf, modeRGB, modeA));
}
static void GLAPIENTRY
_mesa_marshal_BlendEquationSeparateiARB(GLuint buf, GLenum modeRGB, GLenum modeA)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BlendEquationSeparateiARB);
   struct marshal_cmd_BlendEquationSeparateiARB *cmd;
   debug_print_marshal("BlendEquationSeparateiARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BlendEquationSeparateiARB, cmd_size);
      cmd->buf = buf;
      cmd->modeRGB = modeRGB;
      cmd->modeA = modeA;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BlendEquationSeparateiARB");
   CALL_BlendEquationSeparateiARB(ctx->CurrentServerDispatch, (buf, modeRGB, modeA));
}


/* MultiTexCoord1fvARB: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord1fvARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLfloat v[1];
};
static inline void
_mesa_unmarshal_MultiTexCoord1fvARB(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord1fvARB *cmd)
{
   const GLenum target = cmd->target;
   const GLfloat * v = cmd->v;
   CALL_MultiTexCoord1fvARB(ctx->CurrentServerDispatch, (target, v));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord1fvARB(GLenum target, const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord1fvARB);
   struct marshal_cmd_MultiTexCoord1fvARB *cmd;
   debug_print_marshal("MultiTexCoord1fvARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord1fvARB, cmd_size);
      cmd->target = target;
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord1fvARB");
   CALL_MultiTexCoord1fvARB(ctx->CurrentServerDispatch, (target, v));
}


/* TexStorage2D: marshalled asynchronously */
struct marshal_cmd_TexStorage2D
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizei levels;
   GLenum internalFormat;
   GLsizei width;
   GLsizei height;
};
static inline void
_mesa_unmarshal_TexStorage2D(struct gl_context *ctx, const struct marshal_cmd_TexStorage2D *cmd)
{
   const GLenum target = cmd->target;
   const GLsizei levels = cmd->levels;
   const GLenum internalFormat = cmd->internalFormat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   CALL_TexStorage2D(ctx->CurrentServerDispatch, (target, levels, internalFormat, width, height));
}
static void GLAPIENTRY
_mesa_marshal_TexStorage2D(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexStorage2D);
   struct marshal_cmd_TexStorage2D *cmd;
   debug_print_marshal("TexStorage2D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexStorage2D, cmd_size);
      cmd->target = target;
      cmd->levels = levels;
      cmd->internalFormat = internalFormat;
      cmd->width = width;
      cmd->height = height;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexStorage2D");
   CALL_TexStorage2D(ctx->CurrentServerDispatch, (target, levels, internalFormat, width, height));
}


/* FramebufferTexture2D: marshalled asynchronously */
struct marshal_cmd_FramebufferTexture2D
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum attachment;
   GLenum textarget;
   GLuint texture;
   GLint level;
};
static inline void
_mesa_unmarshal_FramebufferTexture2D(struct gl_context *ctx, const struct marshal_cmd_FramebufferTexture2D *cmd)
{
   const GLenum target = cmd->target;
   const GLenum attachment = cmd->attachment;
   const GLenum textarget = cmd->textarget;
   const GLuint texture = cmd->texture;
   const GLint level = cmd->level;
   CALL_FramebufferTexture2D(ctx->CurrentServerDispatch, (target, attachment, textarget, texture, level));
}
static void GLAPIENTRY
_mesa_marshal_FramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_FramebufferTexture2D);
   struct marshal_cmd_FramebufferTexture2D *cmd;
   debug_print_marshal("FramebufferTexture2D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_FramebufferTexture2D, cmd_size);
      cmd->target = target;
      cmd->attachment = attachment;
      cmd->textarget = textarget;
      cmd->texture = texture;
      cmd->level = level;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("FramebufferTexture2D");
   CALL_FramebufferTexture2D(ctx->CurrentServerDispatch, (target, attachment, textarget, texture, level));
}


/* GetSamplerParameterfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetSamplerParameterfv");
   CALL_GetSamplerParameterfv(ctx->CurrentServerDispatch, (sampler, pname, params));
}


/* VertexAttrib2dv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib2dv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble v[2];
};
static inline void
_mesa_unmarshal_VertexAttrib2dv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib2dv *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble * v = cmd->v;
   CALL_VertexAttrib2dv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib2dv(GLuint index, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib2dv);
   struct marshal_cmd_VertexAttrib2dv *cmd;
   debug_print_marshal("VertexAttrib2dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib2dv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib2dv");
   CALL_VertexAttrib2dv(ctx->CurrentServerDispatch, (index, v));
}


/* Vertex4sv: marshalled asynchronously */
struct marshal_cmd_Vertex4sv
{
   struct marshal_cmd_base cmd_base;
   GLshort v[4];
};
static inline void
_mesa_unmarshal_Vertex4sv(struct gl_context *ctx, const struct marshal_cmd_Vertex4sv *cmd)
{
   const GLshort * v = cmd->v;
   CALL_Vertex4sv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Vertex4sv(const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex4sv);
   struct marshal_cmd_Vertex4sv *cmd;
   debug_print_marshal("Vertex4sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex4sv, cmd_size);
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex4sv");
   CALL_Vertex4sv(ctx->CurrentServerDispatch, (v));
}


/* GetQueryObjecti64v: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetQueryObjecti64v(GLuint id, GLenum pname, GLint64 * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetQueryObjecti64v");
   CALL_GetQueryObjecti64v(ctx->CurrentServerDispatch, (id, pname, params));
}


/* ClampColor: marshalled asynchronously */
struct marshal_cmd_ClampColor
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum clamp;
};
static inline void
_mesa_unmarshal_ClampColor(struct gl_context *ctx, const struct marshal_cmd_ClampColor *cmd)
{
   const GLenum target = cmd->target;
   const GLenum clamp = cmd->clamp;
   CALL_ClampColor(ctx->CurrentServerDispatch, (target, clamp));
}
static void GLAPIENTRY
_mesa_marshal_ClampColor(GLenum target, GLenum clamp)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClampColor);
   struct marshal_cmd_ClampColor *cmd;
   debug_print_marshal("ClampColor");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClampColor, cmd_size);
      cmd->target = target;
      cmd->clamp = clamp;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClampColor");
   CALL_ClampColor(ctx->CurrentServerDispatch, (target, clamp));
}


/* Uniform1i64ARB: marshalled asynchronously */
struct marshal_cmd_Uniform1i64ARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLint64 x;
};
static inline void
_mesa_unmarshal_Uniform1i64ARB(struct gl_context *ctx, const struct marshal_cmd_Uniform1i64ARB *cmd)
{
   const GLint location = cmd->location;
   const GLint64 x = cmd->x;
   CALL_Uniform1i64ARB(ctx->CurrentServerDispatch, (location, x));
}
static void GLAPIENTRY
_mesa_marshal_Uniform1i64ARB(GLint location, GLint64 x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform1i64ARB);
   struct marshal_cmd_Uniform1i64ARB *cmd;
   debug_print_marshal("Uniform1i64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform1i64ARB, cmd_size);
      cmd->location = location;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform1i64ARB");
   CALL_Uniform1i64ARB(ctx->CurrentServerDispatch, (location, x));
}


/* DepthRangeArrayfvOES: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_DepthRangeArrayfvOES(GLuint first, GLsizei count, const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("DepthRangeArrayfvOES");
   CALL_DepthRangeArrayfvOES(ctx->CurrentServerDispatch, (first, count, v));
}


/* ConvolutionFilter1D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ConvolutionFilter1D(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid * image)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ConvolutionFilter1D");
   CALL_ConvolutionFilter1D(ctx->CurrentServerDispatch, (target, internalformat, width, format, type, image));
}


/* DrawElementsIndirect: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_DrawElementsIndirect(GLenum mode, GLenum type, const GLvoid * indirect)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("DrawElementsIndirect");
   CALL_DrawElementsIndirect(ctx->CurrentServerDispatch, (mode, type, indirect));
}


/* WindowPos3sv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_WindowPos3sv(const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("WindowPos3sv");
   CALL_WindowPos3sv(ctx->CurrentServerDispatch, (v));
}


/* CallLists: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CallLists(GLsizei n, GLenum type, const GLvoid * lists)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CallLists");
   CALL_CallLists(ctx->CurrentServerDispatch, (n, type, lists));
}


/* AlphaFunc: marshalled asynchronously */
struct marshal_cmd_AlphaFunc
{
   struct marshal_cmd_base cmd_base;
   GLenum func;
   GLclampf ref;
};
static inline void
_mesa_unmarshal_AlphaFunc(struct gl_context *ctx, const struct marshal_cmd_AlphaFunc *cmd)
{
   const GLenum func = cmd->func;
   const GLclampf ref = cmd->ref;
   CALL_AlphaFunc(ctx->CurrentServerDispatch, (func, ref));
}
static void GLAPIENTRY
_mesa_marshal_AlphaFunc(GLenum func, GLclampf ref)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_AlphaFunc);
   struct marshal_cmd_AlphaFunc *cmd;
   debug_print_marshal("AlphaFunc");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_AlphaFunc, cmd_size);
      cmd->func = func;
      cmd->ref = ref;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("AlphaFunc");
   CALL_AlphaFunc(ctx->CurrentServerDispatch, (func, ref));
}


/* GetTextureParameterfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTextureParameterfv(GLuint texture, GLenum pname, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTextureParameterfv");
   CALL_GetTextureParameterfv(ctx->CurrentServerDispatch, (texture, pname, params));
}


/* EdgeFlag: marshalled asynchronously */
struct marshal_cmd_EdgeFlag
{
   struct marshal_cmd_base cmd_base;
   GLboolean flag;
};
static inline void
_mesa_unmarshal_EdgeFlag(struct gl_context *ctx, const struct marshal_cmd_EdgeFlag *cmd)
{
   const GLboolean flag = cmd->flag;
   CALL_EdgeFlag(ctx->CurrentServerDispatch, (flag));
}
static void GLAPIENTRY
_mesa_marshal_EdgeFlag(GLboolean flag)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EdgeFlag);
   struct marshal_cmd_EdgeFlag *cmd;
   debug_print_marshal("EdgeFlag");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EdgeFlag, cmd_size);
      cmd->flag = flag;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EdgeFlag");
   CALL_EdgeFlag(ctx->CurrentServerDispatch, (flag));
}


/* EdgeFlagv: marshalled asynchronously */
struct marshal_cmd_EdgeFlagv
{
   struct marshal_cmd_base cmd_base;
   GLboolean flag[1];
};
static inline void
_mesa_unmarshal_EdgeFlagv(struct gl_context *ctx, const struct marshal_cmd_EdgeFlagv *cmd)
{
   const GLboolean * flag = cmd->flag;
   CALL_EdgeFlagv(ctx->CurrentServerDispatch, (flag));
}
static void GLAPIENTRY
_mesa_marshal_EdgeFlagv(const GLboolean * flag)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EdgeFlagv);
   struct marshal_cmd_EdgeFlagv *cmd;
   debug_print_marshal("EdgeFlagv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EdgeFlagv, cmd_size);
      memcpy(cmd->flag, flag, 1);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EdgeFlagv");
   CALL_EdgeFlagv(ctx->CurrentServerDispatch, (flag));
}


/* DepthRangex: marshalled asynchronously */
struct marshal_cmd_DepthRangex
{
   struct marshal_cmd_base cmd_base;
   GLclampx zNear;
   GLclampx zFar;
};
static inline void
_mesa_unmarshal_DepthRangex(struct gl_context *ctx, const struct marshal_cmd_DepthRangex *cmd)
{
   const GLclampx zNear = cmd->zNear;
   const GLclampx zFar = cmd->zFar;
   CALL_DepthRangex(ctx->CurrentServerDispatch, (zNear, zFar));
}
static void GLAPIENTRY
_mesa_marshal_DepthRangex(GLclampx zNear, GLclampx zFar)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DepthRangex);
   struct marshal_cmd_DepthRangex *cmd;
   debug_print_marshal("DepthRangex");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DepthRangex, cmd_size);
      cmd->zNear = zNear;
      cmd->zFar = zFar;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DepthRangex");
   CALL_DepthRangex(ctx->CurrentServerDispatch, (zNear, zFar));
}


/* ProgramUniformHandleui64vARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ProgramUniformHandleui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ProgramUniformHandleui64vARB");
   CALL_ProgramUniformHandleui64vARB(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* VDPAUInitNV: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VDPAUInitNV(const GLvoid * vdpDevice, const GLvoid * getProcAddress)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VDPAUInitNV");
   CALL_VDPAUInitNV(ctx->CurrentServerDispatch, (vdpDevice, getProcAddress));
}


/* GetBufferParameteri64v: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetBufferParameteri64v(GLenum target, GLenum pname, GLint64 * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetBufferParameteri64v");
   CALL_GetBufferParameteri64v(ctx->CurrentServerDispatch, (target, pname, params));
}


/* CreateProgram: marshalled synchronously */
static GLuint GLAPIENTRY
_mesa_marshal_CreateProgram(void)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CreateProgram");
   return CALL_CreateProgram(ctx->CurrentServerDispatch, ());
}


/* DepthRangef: marshalled asynchronously */
struct marshal_cmd_DepthRangef
{
   struct marshal_cmd_base cmd_base;
   GLclampf zNear;
   GLclampf zFar;
};
static inline void
_mesa_unmarshal_DepthRangef(struct gl_context *ctx, const struct marshal_cmd_DepthRangef *cmd)
{
   const GLclampf zNear = cmd->zNear;
   const GLclampf zFar = cmd->zFar;
   CALL_DepthRangef(ctx->CurrentServerDispatch, (zNear, zFar));
}
static void GLAPIENTRY
_mesa_marshal_DepthRangef(GLclampf zNear, GLclampf zFar)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DepthRangef);
   struct marshal_cmd_DepthRangef *cmd;
   debug_print_marshal("DepthRangef");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DepthRangef, cmd_size);
      cmd->zNear = zNear;
      cmd->zFar = zFar;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DepthRangef");
   CALL_DepthRangef(ctx->CurrentServerDispatch, (zNear, zFar));
}


/* TextureParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TextureParameteriv(GLuint texture, GLenum pname, const GLint * param)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TextureParameteriv");
   CALL_TextureParameteriv(ctx->CurrentServerDispatch, (texture, pname, param));
}


/* ColorFragmentOp3ATI: marshalled asynchronously */
struct marshal_cmd_ColorFragmentOp3ATI
{
   struct marshal_cmd_base cmd_base;
   GLenum op;
   GLuint dst;
   GLuint dstMask;
   GLuint dstMod;
   GLuint arg1;
   GLuint arg1Rep;
   GLuint arg1Mod;
   GLuint arg2;
   GLuint arg2Rep;
   GLuint arg2Mod;
   GLuint arg3;
   GLuint arg3Rep;
   GLuint arg3Mod;
};
static inline void
_mesa_unmarshal_ColorFragmentOp3ATI(struct gl_context *ctx, const struct marshal_cmd_ColorFragmentOp3ATI *cmd)
{
   const GLenum op = cmd->op;
   const GLuint dst = cmd->dst;
   const GLuint dstMask = cmd->dstMask;
   const GLuint dstMod = cmd->dstMod;
   const GLuint arg1 = cmd->arg1;
   const GLuint arg1Rep = cmd->arg1Rep;
   const GLuint arg1Mod = cmd->arg1Mod;
   const GLuint arg2 = cmd->arg2;
   const GLuint arg2Rep = cmd->arg2Rep;
   const GLuint arg2Mod = cmd->arg2Mod;
   const GLuint arg3 = cmd->arg3;
   const GLuint arg3Rep = cmd->arg3Rep;
   const GLuint arg3Mod = cmd->arg3Mod;
   CALL_ColorFragmentOp3ATI(ctx->CurrentServerDispatch, (op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod));
}
static void GLAPIENTRY
_mesa_marshal_ColorFragmentOp3ATI(GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ColorFragmentOp3ATI);
   struct marshal_cmd_ColorFragmentOp3ATI *cmd;
   debug_print_marshal("ColorFragmentOp3ATI");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ColorFragmentOp3ATI, cmd_size);
      cmd->op = op;
      cmd->dst = dst;
      cmd->dstMask = dstMask;
      cmd->dstMod = dstMod;
      cmd->arg1 = arg1;
      cmd->arg1Rep = arg1Rep;
      cmd->arg1Mod = arg1Mod;
      cmd->arg2 = arg2;
      cmd->arg2Rep = arg2Rep;
      cmd->arg2Mod = arg2Mod;
      cmd->arg3 = arg3;
      cmd->arg3Rep = arg3Rep;
      cmd->arg3Mod = arg3Mod;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ColorFragmentOp3ATI");
   CALL_ColorFragmentOp3ATI(ctx->CurrentServerDispatch, (op, dst, dstMask, dstMod, arg1, arg1Rep, arg1Mod, arg2, arg2Rep, arg2Mod, arg3, arg3Rep, arg3Mod));
}


/* ValidateProgram: marshalled asynchronously */
struct marshal_cmd_ValidateProgram
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
};
static inline void
_mesa_unmarshal_ValidateProgram(struct gl_context *ctx, const struct marshal_cmd_ValidateProgram *cmd)
{
   const GLuint program = cmd->program;
   CALL_ValidateProgram(ctx->CurrentServerDispatch, (program));
}
static void GLAPIENTRY
_mesa_marshal_ValidateProgram(GLuint program)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ValidateProgram);
   struct marshal_cmd_ValidateProgram *cmd;
   debug_print_marshal("ValidateProgram");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ValidateProgram, cmd_size);
      cmd->program = program;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ValidateProgram");
   CALL_ValidateProgram(ctx->CurrentServerDispatch, (program));
}


/* VertexPointerEXT: marshalled asynchronously */
struct marshal_cmd_VertexPointerEXT
{
   struct marshal_cmd_base cmd_base;
   GLint size;
   GLenum type;
   GLsizei stride;
   GLsizei count;
   const GLvoid * pointer;
};
static inline void
_mesa_unmarshal_VertexPointerEXT(struct gl_context *ctx, const struct marshal_cmd_VertexPointerEXT *cmd)
{
   const GLint size = cmd->size;
   const GLenum type = cmd->type;
   const GLsizei stride = cmd->stride;
   const GLsizei count = cmd->count;
   const GLvoid * pointer = cmd->pointer;
   CALL_VertexPointerEXT(ctx->CurrentServerDispatch, (size, type, stride, count, pointer));
}
static void GLAPIENTRY
_mesa_marshal_VertexPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexPointerEXT);
   struct marshal_cmd_VertexPointerEXT *cmd;
   debug_print_marshal("VertexPointerEXT");
   if (_mesa_glthread_is_non_vbo_vertex_attrib_pointer(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("VertexPointerEXT");
      CALL_VertexPointerEXT(ctx->CurrentServerDispatch, (size, type, stride, count, pointer));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexPointerEXT, cmd_size);
      cmd->size = size;
      cmd->type = type;
      cmd->stride = stride;
      cmd->count = count;
      cmd->pointer = pointer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexPointerEXT");
   CALL_VertexPointerEXT(ctx->CurrentServerDispatch, (size, type, stride, count, pointer));
}


/* VertexAttribI4sv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribI4sv(GLuint index, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribI4sv");
   CALL_VertexAttribI4sv(ctx->CurrentServerDispatch, (index, v));
}


/* Scissor: marshalled asynchronously */
struct marshal_cmd_Scissor
{
   struct marshal_cmd_base cmd_base;
   GLint x;
   GLint y;
   GLsizei width;
   GLsizei height;
};
static inline void
_mesa_unmarshal_Scissor(struct gl_context *ctx, const struct marshal_cmd_Scissor *cmd)
{
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   CALL_Scissor(ctx->CurrentServerDispatch, (x, y, width, height));
}
static void GLAPIENTRY
_mesa_marshal_Scissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Scissor);
   struct marshal_cmd_Scissor *cmd;
   debug_print_marshal("Scissor");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Scissor, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->width = width;
      cmd->height = height;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Scissor");
   CALL_Scissor(ctx->CurrentServerDispatch, (x, y, width, height));
}


/* BeginTransformFeedback: marshalled asynchronously */
struct marshal_cmd_BeginTransformFeedback
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
};
static inline void
_mesa_unmarshal_BeginTransformFeedback(struct gl_context *ctx, const struct marshal_cmd_BeginTransformFeedback *cmd)
{
   const GLenum mode = cmd->mode;
   CALL_BeginTransformFeedback(ctx->CurrentServerDispatch, (mode));
}
static void GLAPIENTRY
_mesa_marshal_BeginTransformFeedback(GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BeginTransformFeedback);
   struct marshal_cmd_BeginTransformFeedback *cmd;
   debug_print_marshal("BeginTransformFeedback");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BeginTransformFeedback, cmd_size);
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BeginTransformFeedback");
   CALL_BeginTransformFeedback(ctx->CurrentServerDispatch, (mode));
}


/* TexCoord2i: marshalled asynchronously */
struct marshal_cmd_TexCoord2i
{
   struct marshal_cmd_base cmd_base;
   GLint s;
   GLint t;
};
static inline void
_mesa_unmarshal_TexCoord2i(struct gl_context *ctx, const struct marshal_cmd_TexCoord2i *cmd)
{
   const GLint s = cmd->s;
   const GLint t = cmd->t;
   CALL_TexCoord2i(ctx->CurrentServerDispatch, (s, t));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord2i(GLint s, GLint t)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord2i);
   struct marshal_cmd_TexCoord2i *cmd;
   debug_print_marshal("TexCoord2i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord2i, cmd_size);
      cmd->s = s;
      cmd->t = t;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord2i");
   CALL_TexCoord2i(ctx->CurrentServerDispatch, (s, t));
}


/* VertexArrayAttribBinding: marshalled asynchronously */
struct marshal_cmd_VertexArrayAttribBinding
{
   struct marshal_cmd_base cmd_base;
   GLuint vaobj;
   GLuint attribindex;
   GLuint bindingindex;
};
static inline void
_mesa_unmarshal_VertexArrayAttribBinding(struct gl_context *ctx, const struct marshal_cmd_VertexArrayAttribBinding *cmd)
{
   const GLuint vaobj = cmd->vaobj;
   const GLuint attribindex = cmd->attribindex;
   const GLuint bindingindex = cmd->bindingindex;
   CALL_VertexArrayAttribBinding(ctx->CurrentServerDispatch, (vaobj, attribindex, bindingindex));
}
static void GLAPIENTRY
_mesa_marshal_VertexArrayAttribBinding(GLuint vaobj, GLuint attribindex, GLuint bindingindex)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexArrayAttribBinding);
   struct marshal_cmd_VertexArrayAttribBinding *cmd;
   debug_print_marshal("VertexArrayAttribBinding");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexArrayAttribBinding, cmd_size);
      cmd->vaobj = vaobj;
      cmd->attribindex = attribindex;
      cmd->bindingindex = bindingindex;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexArrayAttribBinding");
   CALL_VertexArrayAttribBinding(ctx->CurrentServerDispatch, (vaobj, attribindex, bindingindex));
}


/* Color4ui: marshalled asynchronously */
struct marshal_cmd_Color4ui
{
   struct marshal_cmd_base cmd_base;
   GLuint red;
   GLuint green;
   GLuint blue;
   GLuint alpha;
};
static inline void
_mesa_unmarshal_Color4ui(struct gl_context *ctx, const struct marshal_cmd_Color4ui *cmd)
{
   const GLuint red = cmd->red;
   const GLuint green = cmd->green;
   const GLuint blue = cmd->blue;
   const GLuint alpha = cmd->alpha;
   CALL_Color4ui(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}
static void GLAPIENTRY
_mesa_marshal_Color4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color4ui);
   struct marshal_cmd_Color4ui *cmd;
   debug_print_marshal("Color4ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color4ui, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      cmd->alpha = alpha;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color4ui");
   CALL_Color4ui(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}


/* TexCoord2f: marshalled asynchronously */
struct marshal_cmd_TexCoord2f
{
   struct marshal_cmd_base cmd_base;
   GLfloat s;
   GLfloat t;
};
static inline void
_mesa_unmarshal_TexCoord2f(struct gl_context *ctx, const struct marshal_cmd_TexCoord2f *cmd)
{
   const GLfloat s = cmd->s;
   const GLfloat t = cmd->t;
   CALL_TexCoord2f(ctx->CurrentServerDispatch, (s, t));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord2f(GLfloat s, GLfloat t)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord2f);
   struct marshal_cmd_TexCoord2f *cmd;
   debug_print_marshal("TexCoord2f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord2f, cmd_size);
      cmd->s = s;
      cmd->t = t;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord2f");
   CALL_TexCoord2f(ctx->CurrentServerDispatch, (s, t));
}


/* TexCoord2d: marshalled asynchronously */
struct marshal_cmd_TexCoord2d
{
   struct marshal_cmd_base cmd_base;
   GLdouble s;
   GLdouble t;
};
static inline void
_mesa_unmarshal_TexCoord2d(struct gl_context *ctx, const struct marshal_cmd_TexCoord2d *cmd)
{
   const GLdouble s = cmd->s;
   const GLdouble t = cmd->t;
   CALL_TexCoord2d(ctx->CurrentServerDispatch, (s, t));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord2d(GLdouble s, GLdouble t)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord2d);
   struct marshal_cmd_TexCoord2d *cmd;
   debug_print_marshal("TexCoord2d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord2d, cmd_size);
      cmd->s = s;
      cmd->t = t;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord2d");
   CALL_TexCoord2d(ctx->CurrentServerDispatch, (s, t));
}


/* GetTransformFeedbackiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTransformFeedbackiv(GLuint xfb, GLenum pname, GLint * param)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTransformFeedbackiv");
   CALL_GetTransformFeedbackiv(ctx->CurrentServerDispatch, (xfb, pname, param));
}


/* TexCoord2s: marshalled asynchronously */
struct marshal_cmd_TexCoord2s
{
   struct marshal_cmd_base cmd_base;
   GLshort s;
   GLshort t;
};
static inline void
_mesa_unmarshal_TexCoord2s(struct gl_context *ctx, const struct marshal_cmd_TexCoord2s *cmd)
{
   const GLshort s = cmd->s;
   const GLshort t = cmd->t;
   CALL_TexCoord2s(ctx->CurrentServerDispatch, (s, t));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord2s(GLshort s, GLshort t)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord2s);
   struct marshal_cmd_TexCoord2s *cmd;
   debug_print_marshal("TexCoord2s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord2s, cmd_size);
      cmd->s = s;
      cmd->t = t;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord2s");
   CALL_TexCoord2s(ctx->CurrentServerDispatch, (s, t));
}


/* PointSizePointerOES: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_PointSizePointerOES(GLenum type, GLsizei stride, const GLvoid * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("PointSizePointerOES");
   CALL_PointSizePointerOES(ctx->CurrentServerDispatch, (type, stride, pointer));
}


/* Color4us: marshalled asynchronously */
struct marshal_cmd_Color4us
{
   struct marshal_cmd_base cmd_base;
   GLushort red;
   GLushort green;
   GLushort blue;
   GLushort alpha;
};
static inline void
_mesa_unmarshal_Color4us(struct gl_context *ctx, const struct marshal_cmd_Color4us *cmd)
{
   const GLushort red = cmd->red;
   const GLushort green = cmd->green;
   const GLushort blue = cmd->blue;
   const GLushort alpha = cmd->alpha;
   CALL_Color4us(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}
static void GLAPIENTRY
_mesa_marshal_Color4us(GLushort red, GLushort green, GLushort blue, GLushort alpha)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color4us);
   struct marshal_cmd_Color4us *cmd;
   debug_print_marshal("Color4us");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color4us, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      cmd->alpha = alpha;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color4us");
   CALL_Color4us(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}


/* Color3bv: marshalled asynchronously */
struct marshal_cmd_Color3bv
{
   struct marshal_cmd_base cmd_base;
   GLbyte v[3];
};
static inline void
_mesa_unmarshal_Color3bv(struct gl_context *ctx, const struct marshal_cmd_Color3bv *cmd)
{
   const GLbyte * v = cmd->v;
   CALL_Color3bv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Color3bv(const GLbyte * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color3bv);
   struct marshal_cmd_Color3bv *cmd;
   debug_print_marshal("Color3bv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color3bv, cmd_size);
      memcpy(cmd->v, v, 3);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color3bv");
   CALL_Color3bv(ctx->CurrentServerDispatch, (v));
}


/* PrimitiveRestartNV: marshalled asynchronously */
struct marshal_cmd_PrimitiveRestartNV
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_PrimitiveRestartNV(struct gl_context *ctx, const struct marshal_cmd_PrimitiveRestartNV *cmd)
{
   CALL_PrimitiveRestartNV(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_PrimitiveRestartNV(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PrimitiveRestartNV);
   struct marshal_cmd_PrimitiveRestartNV *cmd;
   debug_print_marshal("PrimitiveRestartNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PrimitiveRestartNV, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PrimitiveRestartNV");
   CALL_PrimitiveRestartNV(ctx->CurrentServerDispatch, ());
}


/* BindBufferOffsetEXT: marshalled asynchronously */
struct marshal_cmd_BindBufferOffsetEXT
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
   GLuint buffer;
   GLintptr offset;
};
static inline void
_mesa_unmarshal_BindBufferOffsetEXT(struct gl_context *ctx, const struct marshal_cmd_BindBufferOffsetEXT *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   const GLuint buffer = cmd->buffer;
   const GLintptr offset = cmd->offset;
   CALL_BindBufferOffsetEXT(ctx->CurrentServerDispatch, (target, index, buffer, offset));
}
static void GLAPIENTRY
_mesa_marshal_BindBufferOffsetEXT(GLenum target, GLuint index, GLuint buffer, GLintptr offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BindBufferOffsetEXT);
   struct marshal_cmd_BindBufferOffsetEXT *cmd;
   debug_print_marshal("BindBufferOffsetEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BindBufferOffsetEXT, cmd_size);
      cmd->target = target;
      cmd->index = index;
      cmd->buffer = buffer;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BindBufferOffsetEXT");
   CALL_BindBufferOffsetEXT(ctx->CurrentServerDispatch, (target, index, buffer, offset));
}


/* ProvokingVertex: marshalled asynchronously */
struct marshal_cmd_ProvokingVertex
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
};
static inline void
_mesa_unmarshal_ProvokingVertex(struct gl_context *ctx, const struct marshal_cmd_ProvokingVertex *cmd)
{
   const GLenum mode = cmd->mode;
   CALL_ProvokingVertex(ctx->CurrentServerDispatch, (mode));
}
static void GLAPIENTRY
_mesa_marshal_ProvokingVertex(GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProvokingVertex);
   struct marshal_cmd_ProvokingVertex *cmd;
   debug_print_marshal("ProvokingVertex");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProvokingVertex, cmd_size);
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProvokingVertex");
   CALL_ProvokingVertex(ctx->CurrentServerDispatch, (mode));
}


/* VertexAttribs4fvNV: marshalled asynchronously */
struct marshal_cmd_VertexAttribs4fvNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLsizei n;
   /* Next safe_mul(n, 16) bytes are GLfloat v[n][4] */
};
static inline void
_mesa_unmarshal_VertexAttribs4fvNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttribs4fvNV *cmd)
{
   const GLuint index = cmd->index;
   const GLsizei n = cmd->n;
   const GLfloat * v;
   const char *variable_data = (const char *) (cmd + 1);
   v = (const GLfloat *) variable_data;
   variable_data += n * 16;
   CALL_VertexAttribs4fvNV(ctx->CurrentServerDispatch, (index, n, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribs4fvNV(GLuint index, GLsizei n, const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribs4fvNV) + safe_mul(n, 16);
   struct marshal_cmd_VertexAttribs4fvNV *cmd;
   debug_print_marshal("VertexAttribs4fvNV");
   if (unlikely(safe_mul(n, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribs4fvNV, cmd_size);
      cmd->index = index;
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, v, n * 16);
      variable_data += n * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribs4fvNV");
   CALL_VertexAttribs4fvNV(ctx->CurrentServerDispatch, (index, n, v));
}


/* Vertex2i: marshalled asynchronously */
struct marshal_cmd_Vertex2i
{
   struct marshal_cmd_base cmd_base;
   GLint x;
   GLint y;
};
static inline void
_mesa_unmarshal_Vertex2i(struct gl_context *ctx, const struct marshal_cmd_Vertex2i *cmd)
{
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   CALL_Vertex2i(ctx->CurrentServerDispatch, (x, y));
}
static void GLAPIENTRY
_mesa_marshal_Vertex2i(GLint x, GLint y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex2i);
   struct marshal_cmd_Vertex2i *cmd;
   debug_print_marshal("Vertex2i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex2i, cmd_size);
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex2i");
   CALL_Vertex2i(ctx->CurrentServerDispatch, (x, y));
}


/* GetQueryBufferObjecti64v: marshalled asynchronously */
struct marshal_cmd_GetQueryBufferObjecti64v
{
   struct marshal_cmd_base cmd_base;
   GLuint id;
   GLuint buffer;
   GLenum pname;
   GLintptr offset;
};
static inline void
_mesa_unmarshal_GetQueryBufferObjecti64v(struct gl_context *ctx, const struct marshal_cmd_GetQueryBufferObjecti64v *cmd)
{
   const GLuint id = cmd->id;
   const GLuint buffer = cmd->buffer;
   const GLenum pname = cmd->pname;
   const GLintptr offset = cmd->offset;
   CALL_GetQueryBufferObjecti64v(ctx->CurrentServerDispatch, (id, buffer, pname, offset));
}
static void GLAPIENTRY
_mesa_marshal_GetQueryBufferObjecti64v(GLuint id, GLuint buffer, GLenum pname, GLintptr offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_GetQueryBufferObjecti64v);
   struct marshal_cmd_GetQueryBufferObjecti64v *cmd;
   debug_print_marshal("GetQueryBufferObjecti64v");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_GetQueryBufferObjecti64v, cmd_size);
      cmd->id = id;
      cmd->buffer = buffer;
      cmd->pname = pname;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("GetQueryBufferObjecti64v");
   CALL_GetQueryBufferObjecti64v(ctx->CurrentServerDispatch, (id, buffer, pname, offset));
}


/* InterleavedArrays: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_InterleavedArrays(GLenum format, GLsizei stride, const GLvoid * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("InterleavedArrays");
   CALL_InterleavedArrays(ctx->CurrentServerDispatch, (format, stride, pointer));
}


/* RasterPos2fv: marshalled asynchronously */
struct marshal_cmd_RasterPos2fv
{
   struct marshal_cmd_base cmd_base;
   GLfloat v[2];
};
static inline void
_mesa_unmarshal_RasterPos2fv(struct gl_context *ctx, const struct marshal_cmd_RasterPos2fv *cmd)
{
   const GLfloat * v = cmd->v;
   CALL_RasterPos2fv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos2fv(const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos2fv);
   struct marshal_cmd_RasterPos2fv *cmd;
   debug_print_marshal("RasterPos2fv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos2fv, cmd_size);
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos2fv");
   CALL_RasterPos2fv(ctx->CurrentServerDispatch, (v));
}


/* TexCoord1fv: marshalled asynchronously */
struct marshal_cmd_TexCoord1fv
{
   struct marshal_cmd_base cmd_base;
   GLfloat v[1];
};
static inline void
_mesa_unmarshal_TexCoord1fv(struct gl_context *ctx, const struct marshal_cmd_TexCoord1fv *cmd)
{
   const GLfloat * v = cmd->v;
   CALL_TexCoord1fv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord1fv(const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord1fv);
   struct marshal_cmd_TexCoord1fv *cmd;
   debug_print_marshal("TexCoord1fv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord1fv, cmd_size);
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord1fv");
   CALL_TexCoord1fv(ctx->CurrentServerDispatch, (v));
}


/* MultiTexCoord4dv: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord4dv
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLdouble v[4];
};
static inline void
_mesa_unmarshal_MultiTexCoord4dv(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord4dv *cmd)
{
   const GLenum target = cmd->target;
   const GLdouble * v = cmd->v;
   CALL_MultiTexCoord4dv(ctx->CurrentServerDispatch, (target, v));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord4dv(GLenum target, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord4dv);
   struct marshal_cmd_MultiTexCoord4dv *cmd;
   debug_print_marshal("MultiTexCoord4dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord4dv, cmd_size);
      cmd->target = target;
      memcpy(cmd->v, v, 32);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord4dv");
   CALL_MultiTexCoord4dv(ctx->CurrentServerDispatch, (target, v));
}


/* ProgramEnvParameter4fvARB: marshalled asynchronously */
struct marshal_cmd_ProgramEnvParameter4fvARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
   GLfloat params[4];
};
static inline void
_mesa_unmarshal_ProgramEnvParameter4fvARB(struct gl_context *ctx, const struct marshal_cmd_ProgramEnvParameter4fvARB *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   const GLfloat * params = cmd->params;
   CALL_ProgramEnvParameter4fvARB(ctx->CurrentServerDispatch, (target, index, params));
}
static void GLAPIENTRY
_mesa_marshal_ProgramEnvParameter4fvARB(GLenum target, GLuint index, const GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramEnvParameter4fvARB);
   struct marshal_cmd_ProgramEnvParameter4fvARB *cmd;
   debug_print_marshal("ProgramEnvParameter4fvARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramEnvParameter4fvARB, cmd_size);
      cmd->target = target;
      cmd->index = index;
      memcpy(cmd->params, params, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramEnvParameter4fvARB");
   CALL_ProgramEnvParameter4fvARB(ctx->CurrentServerDispatch, (target, index, params));
}


/* RasterPos4fv: marshalled asynchronously */
struct marshal_cmd_RasterPos4fv
{
   struct marshal_cmd_base cmd_base;
   GLfloat v[4];
};
static inline void
_mesa_unmarshal_RasterPos4fv(struct gl_context *ctx, const struct marshal_cmd_RasterPos4fv *cmd)
{
   const GLfloat * v = cmd->v;
   CALL_RasterPos4fv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos4fv(const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos4fv);
   struct marshal_cmd_RasterPos4fv *cmd;
   debug_print_marshal("RasterPos4fv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos4fv, cmd_size);
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos4fv");
   CALL_RasterPos4fv(ctx->CurrentServerDispatch, (v));
}


/* PushMatrix: marshalled asynchronously */
struct marshal_cmd_PushMatrix
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_PushMatrix(struct gl_context *ctx, const struct marshal_cmd_PushMatrix *cmd)
{
   CALL_PushMatrix(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_PushMatrix(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PushMatrix);
   struct marshal_cmd_PushMatrix *cmd;
   debug_print_marshal("PushMatrix");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PushMatrix, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PushMatrix");
   CALL_PushMatrix(ctx->CurrentServerDispatch, ());
}


/* EndList: marshalled asynchronously */
struct marshal_cmd_EndList
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_EndList(struct gl_context *ctx, const struct marshal_cmd_EndList *cmd)
{
   CALL_EndList(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_EndList(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EndList);
   struct marshal_cmd_EndList *cmd;
   debug_print_marshal("EndList");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EndList, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EndList");
   CALL_EndList(ctx->CurrentServerDispatch, ());
}


/* DrawRangeElements: marshalled asynchronously */
struct marshal_cmd_DrawRangeElements
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
   GLuint start;
   GLuint end;
   GLsizei count;
   GLenum type;
   const GLvoid * indices;
};
static inline void
_mesa_unmarshal_DrawRangeElements(struct gl_context *ctx, const struct marshal_cmd_DrawRangeElements *cmd)
{
   const GLenum mode = cmd->mode;
   const GLuint start = cmd->start;
   const GLuint end = cmd->end;
   const GLsizei count = cmd->count;
   const GLenum type = cmd->type;
   const GLvoid * indices = cmd->indices;
   CALL_DrawRangeElements(ctx->CurrentServerDispatch, (mode, start, end, count, type, indices));
}
static void GLAPIENTRY
_mesa_marshal_DrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid * indices)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawRangeElements);
   struct marshal_cmd_DrawRangeElements *cmd;
   debug_print_marshal("DrawRangeElements");
   if (_mesa_glthread_is_non_vbo_draw_elements(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("DrawRangeElements");
      CALL_DrawRangeElements(ctx->CurrentServerDispatch, (mode, start, end, count, type, indices));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawRangeElements, cmd_size);
      cmd->mode = mode;
      cmd->start = start;
      cmd->end = end;
      cmd->count = count;
      cmd->type = type;
      cmd->indices = indices;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawRangeElements");
   CALL_DrawRangeElements(ctx->CurrentServerDispatch, (mode, start, end, count, type, indices));
}


/* GetTexGenxvOES: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTexGenxvOES(GLenum coord, GLenum pname, GLfixed * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTexGenxvOES");
   CALL_GetTexGenxvOES(ctx->CurrentServerDispatch, (coord, pname, params));
}


/* GetHandleARB: marshalled synchronously */
static GLhandleARB GLAPIENTRY
_mesa_marshal_GetHandleARB(GLenum pname)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetHandleARB");
   return CALL_GetHandleARB(ctx->CurrentServerDispatch, (pname));
}


/* DrawTexfvOES: marshalled asynchronously */
struct marshal_cmd_DrawTexfvOES
{
   struct marshal_cmd_base cmd_base;
   GLfloat coords[5];
};
static inline void
_mesa_unmarshal_DrawTexfvOES(struct gl_context *ctx, const struct marshal_cmd_DrawTexfvOES *cmd)
{
   const GLfloat * coords = cmd->coords;
   CALL_DrawTexfvOES(ctx->CurrentServerDispatch, (coords));
}
static void GLAPIENTRY
_mesa_marshal_DrawTexfvOES(const GLfloat * coords)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawTexfvOES);
   struct marshal_cmd_DrawTexfvOES *cmd;
   debug_print_marshal("DrawTexfvOES");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawTexfvOES, cmd_size);
      memcpy(cmd->coords, coords, 20);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawTexfvOES");
   CALL_DrawTexfvOES(ctx->CurrentServerDispatch, (coords));
}


/* BlendFunciARB: marshalled asynchronously */
struct marshal_cmd_BlendFunciARB
{
   struct marshal_cmd_base cmd_base;
   GLuint buf;
   GLenum src;
   GLenum dst;
};
static inline void
_mesa_unmarshal_BlendFunciARB(struct gl_context *ctx, const struct marshal_cmd_BlendFunciARB *cmd)
{
   const GLuint buf = cmd->buf;
   const GLenum src = cmd->src;
   const GLenum dst = cmd->dst;
   CALL_BlendFunciARB(ctx->CurrentServerDispatch, (buf, src, dst));
}
static void GLAPIENTRY
_mesa_marshal_BlendFunciARB(GLuint buf, GLenum src, GLenum dst)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BlendFunciARB);
   struct marshal_cmd_BlendFunciARB *cmd;
   debug_print_marshal("BlendFunciARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BlendFunciARB, cmd_size);
      cmd->buf = buf;
      cmd->src = src;
      cmd->dst = dst;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BlendFunciARB");
   CALL_BlendFunciARB(ctx->CurrentServerDispatch, (buf, src, dst));
}


/* ClearNamedFramebufferfi: marshalled asynchronously */
struct marshal_cmd_ClearNamedFramebufferfi
{
   struct marshal_cmd_base cmd_base;
   GLuint framebuffer;
   GLenum buffer;
   GLint drawbuffer;
   GLfloat depth;
   GLint stencil;
};
static inline void
_mesa_unmarshal_ClearNamedFramebufferfi(struct gl_context *ctx, const struct marshal_cmd_ClearNamedFramebufferfi *cmd)
{
   const GLuint framebuffer = cmd->framebuffer;
   const GLenum buffer = cmd->buffer;
   const GLint drawbuffer = cmd->drawbuffer;
   const GLfloat depth = cmd->depth;
   const GLint stencil = cmd->stencil;
   CALL_ClearNamedFramebufferfi(ctx->CurrentServerDispatch, (framebuffer, buffer, drawbuffer, depth, stencil));
}
static void GLAPIENTRY
_mesa_marshal_ClearNamedFramebufferfi(GLuint framebuffer, GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClearNamedFramebufferfi);
   struct marshal_cmd_ClearNamedFramebufferfi *cmd;
   debug_print_marshal("ClearNamedFramebufferfi");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClearNamedFramebufferfi, cmd_size);
      cmd->framebuffer = framebuffer;
      cmd->buffer = buffer;
      cmd->drawbuffer = drawbuffer;
      cmd->depth = depth;
      cmd->stencil = stencil;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClearNamedFramebufferfi");
   CALL_ClearNamedFramebufferfi(ctx->CurrentServerDispatch, (framebuffer, buffer, drawbuffer, depth, stencil));
}


/* ClearNamedFramebufferfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ClearNamedFramebufferfv(GLuint framebuffer, GLenum buffer, GLint drawbuffer, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ClearNamedFramebufferfv");
   CALL_ClearNamedFramebufferfv(ctx->CurrentServerDispatch, (framebuffer, buffer, drawbuffer, value));
}


/* Uniform2ui: marshalled asynchronously */
struct marshal_cmd_Uniform2ui
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLuint x;
   GLuint y;
};
static inline void
_mesa_unmarshal_Uniform2ui(struct gl_context *ctx, const struct marshal_cmd_Uniform2ui *cmd)
{
   const GLint location = cmd->location;
   const GLuint x = cmd->x;
   const GLuint y = cmd->y;
   CALL_Uniform2ui(ctx->CurrentServerDispatch, (location, x, y));
}
static void GLAPIENTRY
_mesa_marshal_Uniform2ui(GLint location, GLuint x, GLuint y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform2ui);
   struct marshal_cmd_Uniform2ui *cmd;
   debug_print_marshal("Uniform2ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform2ui, cmd_size);
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform2ui");
   CALL_Uniform2ui(ctx->CurrentServerDispatch, (location, x, y));
}


/* ScissorIndexed: marshalled asynchronously */
struct marshal_cmd_ScissorIndexed
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLint left;
   GLint bottom;
   GLsizei width;
   GLsizei height;
};
static inline void
_mesa_unmarshal_ScissorIndexed(struct gl_context *ctx, const struct marshal_cmd_ScissorIndexed *cmd)
{
   const GLuint index = cmd->index;
   const GLint left = cmd->left;
   const GLint bottom = cmd->bottom;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   CALL_ScissorIndexed(ctx->CurrentServerDispatch, (index, left, bottom, width, height));
}
static void GLAPIENTRY
_mesa_marshal_ScissorIndexed(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ScissorIndexed);
   struct marshal_cmd_ScissorIndexed *cmd;
   debug_print_marshal("ScissorIndexed");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ScissorIndexed, cmd_size);
      cmd->index = index;
      cmd->left = left;
      cmd->bottom = bottom;
      cmd->width = width;
      cmd->height = height;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ScissorIndexed");
   CALL_ScissorIndexed(ctx->CurrentServerDispatch, (index, left, bottom, width, height));
}


/* End: marshalled asynchronously */
struct marshal_cmd_End
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_End(struct gl_context *ctx, const struct marshal_cmd_End *cmd)
{
   CALL_End(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_End(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_End);
   struct marshal_cmd_End *cmd;
   debug_print_marshal("End");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_End, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("End");
   CALL_End(ctx->CurrentServerDispatch, ());
}


/* NamedFramebufferParameteri: marshalled asynchronously */
struct marshal_cmd_NamedFramebufferParameteri
{
   struct marshal_cmd_base cmd_base;
   GLuint framebuffer;
   GLenum pname;
   GLint param;
};
static inline void
_mesa_unmarshal_NamedFramebufferParameteri(struct gl_context *ctx, const struct marshal_cmd_NamedFramebufferParameteri *cmd)
{
   const GLuint framebuffer = cmd->framebuffer;
   const GLenum pname = cmd->pname;
   const GLint param = cmd->param;
   CALL_NamedFramebufferParameteri(ctx->CurrentServerDispatch, (framebuffer, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_NamedFramebufferParameteri(GLuint framebuffer, GLenum pname, GLint param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_NamedFramebufferParameteri);
   struct marshal_cmd_NamedFramebufferParameteri *cmd;
   debug_print_marshal("NamedFramebufferParameteri");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_NamedFramebufferParameteri, cmd_size);
      cmd->framebuffer = framebuffer;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("NamedFramebufferParameteri");
   CALL_NamedFramebufferParameteri(ctx->CurrentServerDispatch, (framebuffer, pname, param));
}


/* BindVertexBuffers: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_BindVertexBuffers(GLuint first, GLsizei count, const GLuint * buffers, const GLintptr * offsets, const GLsizei * strides)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("BindVertexBuffers");
   CALL_BindVertexBuffers(ctx->CurrentServerDispatch, (first, count, buffers, offsets, strides));
}


/* GetSamplerParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetSamplerParameteriv(GLuint sampler, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetSamplerParameteriv");
   CALL_GetSamplerParameteriv(ctx->CurrentServerDispatch, (sampler, pname, params));
}


/* GenProgramPipelines: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GenProgramPipelines(GLsizei n, GLuint * pipelines)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GenProgramPipelines");
   CALL_GenProgramPipelines(ctx->CurrentServerDispatch, (n, pipelines));
}


/* IsProgramPipeline: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsProgramPipeline(GLuint pipeline)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsProgramPipeline");
   return CALL_IsProgramPipeline(ctx->CurrentServerDispatch, (pipeline));
}


/* ShaderBinary: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ShaderBinary(GLsizei n, const GLuint * shaders, GLenum binaryformat, const GLvoid * binary, GLsizei length)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ShaderBinary");
   CALL_ShaderBinary(ctx->CurrentServerDispatch, (n, shaders, binaryformat, binary, length));
}


/* TextureSubImage1D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TextureSubImage1D(GLuint texture, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid * pixels)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TextureSubImage1D");
   CALL_TextureSubImage1D(ctx->CurrentServerDispatch, (texture, level, xoffset, width, format, type, pixels));
}


/* Normal3x: marshalled asynchronously */
struct marshal_cmd_Normal3x
{
   struct marshal_cmd_base cmd_base;
   GLfixed nx;
   GLfixed ny;
   GLfixed nz;
};
static inline void
_mesa_unmarshal_Normal3x(struct gl_context *ctx, const struct marshal_cmd_Normal3x *cmd)
{
   const GLfixed nx = cmd->nx;
   const GLfixed ny = cmd->ny;
   const GLfixed nz = cmd->nz;
   CALL_Normal3x(ctx->CurrentServerDispatch, (nx, ny, nz));
}
static void GLAPIENTRY
_mesa_marshal_Normal3x(GLfixed nx, GLfixed ny, GLfixed nz)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Normal3x);
   struct marshal_cmd_Normal3x *cmd;
   debug_print_marshal("Normal3x");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Normal3x, cmd_size);
      cmd->nx = nx;
      cmd->ny = ny;
      cmd->nz = nz;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Normal3x");
   CALL_Normal3x(ctx->CurrentServerDispatch, (nx, ny, nz));
}


/* VertexAttrib4fARB: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4fARB
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat x;
   GLfloat y;
   GLfloat z;
   GLfloat w;
};
static inline void
_mesa_unmarshal_VertexAttrib4fARB(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4fARB *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   const GLfloat w = cmd->w;
   CALL_VertexAttrib4fARB(ctx->CurrentServerDispatch, (index, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4fARB(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4fARB);
   struct marshal_cmd_VertexAttrib4fARB *cmd;
   debug_print_marshal("VertexAttrib4fARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4fARB, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4fARB");
   CALL_VertexAttrib4fARB(ctx->CurrentServerDispatch, (index, x, y, z, w));
}


/* TexCoord4fv: marshalled asynchronously */
struct marshal_cmd_TexCoord4fv
{
   struct marshal_cmd_base cmd_base;
   GLfloat v[4];
};
static inline void
_mesa_unmarshal_TexCoord4fv(struct gl_context *ctx, const struct marshal_cmd_TexCoord4fv *cmd)
{
   const GLfloat * v = cmd->v;
   CALL_TexCoord4fv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord4fv(const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord4fv);
   struct marshal_cmd_TexCoord4fv *cmd;
   debug_print_marshal("TexCoord4fv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord4fv, cmd_size);
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord4fv");
   CALL_TexCoord4fv(ctx->CurrentServerDispatch, (v));
}


/* ReadnPixelsARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ReadnPixelsARB(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, GLvoid * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ReadnPixelsARB");
   CALL_ReadnPixelsARB(ctx->CurrentServerDispatch, (x, y, width, height, format, type, bufSize, data));
}


/* InvalidateTexSubImage: marshalled asynchronously */
struct marshal_cmd_InvalidateTexSubImage
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLint level;
   GLint xoffset;
   GLint yoffset;
   GLint zoffset;
   GLsizei width;
   GLsizei height;
   GLsizei depth;
};
static inline void
_mesa_unmarshal_InvalidateTexSubImage(struct gl_context *ctx, const struct marshal_cmd_InvalidateTexSubImage *cmd)
{
   const GLuint texture = cmd->texture;
   const GLint level = cmd->level;
   const GLint xoffset = cmd->xoffset;
   const GLint yoffset = cmd->yoffset;
   const GLint zoffset = cmd->zoffset;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLsizei depth = cmd->depth;
   CALL_InvalidateTexSubImage(ctx->CurrentServerDispatch, (texture, level, xoffset, yoffset, zoffset, width, height, depth));
}
static void GLAPIENTRY
_mesa_marshal_InvalidateTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_InvalidateTexSubImage);
   struct marshal_cmd_InvalidateTexSubImage *cmd;
   debug_print_marshal("InvalidateTexSubImage");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_InvalidateTexSubImage, cmd_size);
      cmd->texture = texture;
      cmd->level = level;
      cmd->xoffset = xoffset;
      cmd->yoffset = yoffset;
      cmd->zoffset = zoffset;
      cmd->width = width;
      cmd->height = height;
      cmd->depth = depth;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("InvalidateTexSubImage");
   CALL_InvalidateTexSubImage(ctx->CurrentServerDispatch, (texture, level, xoffset, yoffset, zoffset, width, height, depth));
}


/* Normal3s: marshalled asynchronously */
struct marshal_cmd_Normal3s
{
   struct marshal_cmd_base cmd_base;
   GLshort nx;
   GLshort ny;
   GLshort nz;
};
static inline void
_mesa_unmarshal_Normal3s(struct gl_context *ctx, const struct marshal_cmd_Normal3s *cmd)
{
   const GLshort nx = cmd->nx;
   const GLshort ny = cmd->ny;
   const GLshort nz = cmd->nz;
   CALL_Normal3s(ctx->CurrentServerDispatch, (nx, ny, nz));
}
static void GLAPIENTRY
_mesa_marshal_Normal3s(GLshort nx, GLshort ny, GLshort nz)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Normal3s);
   struct marshal_cmd_Normal3s *cmd;
   debug_print_marshal("Normal3s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Normal3s, cmd_size);
      cmd->nx = nx;
      cmd->ny = ny;
      cmd->nz = nz;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Normal3s");
   CALL_Normal3s(ctx->CurrentServerDispatch, (nx, ny, nz));
}


/* Materialxv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_Materialxv(GLenum face, GLenum pname, const GLfixed * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("Materialxv");
   CALL_Materialxv(ctx->CurrentServerDispatch, (face, pname, params));
}


/* Normal3i: marshalled asynchronously */
struct marshal_cmd_Normal3i
{
   struct marshal_cmd_base cmd_base;
   GLint nx;
   GLint ny;
   GLint nz;
};
static inline void
_mesa_unmarshal_Normal3i(struct gl_context *ctx, const struct marshal_cmd_Normal3i *cmd)
{
   const GLint nx = cmd->nx;
   const GLint ny = cmd->ny;
   const GLint nz = cmd->nz;
   CALL_Normal3i(ctx->CurrentServerDispatch, (nx, ny, nz));
}
static void GLAPIENTRY
_mesa_marshal_Normal3i(GLint nx, GLint ny, GLint nz)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Normal3i);
   struct marshal_cmd_Normal3i *cmd;
   debug_print_marshal("Normal3i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Normal3i, cmd_size);
      cmd->nx = nx;
      cmd->ny = ny;
      cmd->nz = nz;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Normal3i");
   CALL_Normal3i(ctx->CurrentServerDispatch, (nx, ny, nz));
}


/* Normal3b: marshalled asynchronously */
struct marshal_cmd_Normal3b
{
   struct marshal_cmd_base cmd_base;
   GLbyte nx;
   GLbyte ny;
   GLbyte nz;
};
static inline void
_mesa_unmarshal_Normal3b(struct gl_context *ctx, const struct marshal_cmd_Normal3b *cmd)
{
   const GLbyte nx = cmd->nx;
   const GLbyte ny = cmd->ny;
   const GLbyte nz = cmd->nz;
   CALL_Normal3b(ctx->CurrentServerDispatch, (nx, ny, nz));
}
static void GLAPIENTRY
_mesa_marshal_Normal3b(GLbyte nx, GLbyte ny, GLbyte nz)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Normal3b);
   struct marshal_cmd_Normal3b *cmd;
   debug_print_marshal("Normal3b");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Normal3b, cmd_size);
      cmd->nx = nx;
      cmd->ny = ny;
      cmd->nz = nz;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Normal3b");
   CALL_Normal3b(ctx->CurrentServerDispatch, (nx, ny, nz));
}


/* Normal3d: marshalled asynchronously */
struct marshal_cmd_Normal3d
{
   struct marshal_cmd_base cmd_base;
   GLdouble nx;
   GLdouble ny;
   GLdouble nz;
};
static inline void
_mesa_unmarshal_Normal3d(struct gl_context *ctx, const struct marshal_cmd_Normal3d *cmd)
{
   const GLdouble nx = cmd->nx;
   const GLdouble ny = cmd->ny;
   const GLdouble nz = cmd->nz;
   CALL_Normal3d(ctx->CurrentServerDispatch, (nx, ny, nz));
}
static void GLAPIENTRY
_mesa_marshal_Normal3d(GLdouble nx, GLdouble ny, GLdouble nz)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Normal3d);
   struct marshal_cmd_Normal3d *cmd;
   debug_print_marshal("Normal3d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Normal3d, cmd_size);
      cmd->nx = nx;
      cmd->ny = ny;
      cmd->nz = nz;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Normal3d");
   CALL_Normal3d(ctx->CurrentServerDispatch, (nx, ny, nz));
}


/* Normal3f: marshalled asynchronously */
struct marshal_cmd_Normal3f
{
   struct marshal_cmd_base cmd_base;
   GLfloat nx;
   GLfloat ny;
   GLfloat nz;
};
static inline void
_mesa_unmarshal_Normal3f(struct gl_context *ctx, const struct marshal_cmd_Normal3f *cmd)
{
   const GLfloat nx = cmd->nx;
   const GLfloat ny = cmd->ny;
   const GLfloat nz = cmd->nz;
   CALL_Normal3f(ctx->CurrentServerDispatch, (nx, ny, nz));
}
static void GLAPIENTRY
_mesa_marshal_Normal3f(GLfloat nx, GLfloat ny, GLfloat nz)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Normal3f);
   struct marshal_cmd_Normal3f *cmd;
   debug_print_marshal("Normal3f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Normal3f, cmd_size);
      cmd->nx = nx;
      cmd->ny = ny;
      cmd->nz = nz;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Normal3f");
   CALL_Normal3f(ctx->CurrentServerDispatch, (nx, ny, nz));
}


/* Indexi: marshalled asynchronously */
struct marshal_cmd_Indexi
{
   struct marshal_cmd_base cmd_base;
   GLint c;
};
static inline void
_mesa_unmarshal_Indexi(struct gl_context *ctx, const struct marshal_cmd_Indexi *cmd)
{
   const GLint c = cmd->c;
   CALL_Indexi(ctx->CurrentServerDispatch, (c));
}
static void GLAPIENTRY
_mesa_marshal_Indexi(GLint c)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Indexi);
   struct marshal_cmd_Indexi *cmd;
   debug_print_marshal("Indexi");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Indexi, cmd_size);
      cmd->c = c;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Indexi");
   CALL_Indexi(ctx->CurrentServerDispatch, (c));
}


/* Uniform1uiv: marshalled asynchronously */
struct marshal_cmd_Uniform1uiv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 4) bytes are GLuint value[count] */
};
static inline void
_mesa_unmarshal_Uniform1uiv(struct gl_context *ctx, const struct marshal_cmd_Uniform1uiv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLuint * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLuint *) variable_data;
   variable_data += count * 4;
   CALL_Uniform1uiv(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform1uiv(GLint location, GLsizei count, const GLuint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform1uiv) + safe_mul(count, 4);
   struct marshal_cmd_Uniform1uiv *cmd;
   debug_print_marshal("Uniform1uiv");
   if (unlikely(safe_mul(count, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform1uiv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 4);
      variable_data += count * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform1uiv");
   CALL_Uniform1uiv(ctx->CurrentServerDispatch, (location, count, value));
}


/* VertexAttribI2uiEXT: marshalled asynchronously */
struct marshal_cmd_VertexAttribI2uiEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLuint x;
   GLuint y;
};
static inline void
_mesa_unmarshal_VertexAttribI2uiEXT(struct gl_context *ctx, const struct marshal_cmd_VertexAttribI2uiEXT *cmd)
{
   const GLuint index = cmd->index;
   const GLuint x = cmd->x;
   const GLuint y = cmd->y;
   CALL_VertexAttribI2uiEXT(ctx->CurrentServerDispatch, (index, x, y));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribI2uiEXT(GLuint index, GLuint x, GLuint y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribI2uiEXT);
   struct marshal_cmd_VertexAttribI2uiEXT *cmd;
   debug_print_marshal("VertexAttribI2uiEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribI2uiEXT, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribI2uiEXT");
   CALL_VertexAttribI2uiEXT(ctx->CurrentServerDispatch, (index, x, y));
}


/* IsRenderbuffer: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsRenderbuffer(GLuint renderbuffer)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsRenderbuffer");
   return CALL_IsRenderbuffer(ctx->CurrentServerDispatch, (renderbuffer));
}


/* NormalP3uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_NormalP3uiv(GLenum type, const GLuint * coords)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("NormalP3uiv");
   CALL_NormalP3uiv(ctx->CurrentServerDispatch, (type, coords));
}


/* Indexf: marshalled asynchronously */
struct marshal_cmd_Indexf
{
   struct marshal_cmd_base cmd_base;
   GLfloat c;
};
static inline void
_mesa_unmarshal_Indexf(struct gl_context *ctx, const struct marshal_cmd_Indexf *cmd)
{
   const GLfloat c = cmd->c;
   CALL_Indexf(ctx->CurrentServerDispatch, (c));
}
static void GLAPIENTRY
_mesa_marshal_Indexf(GLfloat c)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Indexf);
   struct marshal_cmd_Indexf *cmd;
   debug_print_marshal("Indexf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Indexf, cmd_size);
      cmd->c = c;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Indexf");
   CALL_Indexf(ctx->CurrentServerDispatch, (c));
}


/* Indexd: marshalled asynchronously */
struct marshal_cmd_Indexd
{
   struct marshal_cmd_base cmd_base;
   GLdouble c;
};
static inline void
_mesa_unmarshal_Indexd(struct gl_context *ctx, const struct marshal_cmd_Indexd *cmd)
{
   const GLdouble c = cmd->c;
   CALL_Indexd(ctx->CurrentServerDispatch, (c));
}
static void GLAPIENTRY
_mesa_marshal_Indexd(GLdouble c)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Indexd);
   struct marshal_cmd_Indexd *cmd;
   debug_print_marshal("Indexd");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Indexd, cmd_size);
      cmd->c = c;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Indexd");
   CALL_Indexd(ctx->CurrentServerDispatch, (c));
}


/* GetMaterialiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetMaterialiv(GLenum face, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetMaterialiv");
   CALL_GetMaterialiv(ctx->CurrentServerDispatch, (face, pname, params));
}


/* Indexs: marshalled asynchronously */
struct marshal_cmd_Indexs
{
   struct marshal_cmd_base cmd_base;
   GLshort c;
};
static inline void
_mesa_unmarshal_Indexs(struct gl_context *ctx, const struct marshal_cmd_Indexs *cmd)
{
   const GLshort c = cmd->c;
   CALL_Indexs(ctx->CurrentServerDispatch, (c));
}
static void GLAPIENTRY
_mesa_marshal_Indexs(GLshort c)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Indexs);
   struct marshal_cmd_Indexs *cmd;
   debug_print_marshal("Indexs");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Indexs, cmd_size);
      cmd->c = c;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Indexs");
   CALL_Indexs(ctx->CurrentServerDispatch, (c));
}


/* MultiTexCoordP1uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_MultiTexCoordP1uiv(GLenum texture, GLenum type, const GLuint * coords)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MultiTexCoordP1uiv");
   CALL_MultiTexCoordP1uiv(ctx->CurrentServerDispatch, (texture, type, coords));
}


/* ConvolutionFilter2D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ConvolutionFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * image)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ConvolutionFilter2D");
   CALL_ConvolutionFilter2D(ctx->CurrentServerDispatch, (target, internalformat, width, height, format, type, image));
}


/* Vertex2d: marshalled asynchronously */
struct marshal_cmd_Vertex2d
{
   struct marshal_cmd_base cmd_base;
   GLdouble x;
   GLdouble y;
};
static inline void
_mesa_unmarshal_Vertex2d(struct gl_context *ctx, const struct marshal_cmd_Vertex2d *cmd)
{
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   CALL_Vertex2d(ctx->CurrentServerDispatch, (x, y));
}
static void GLAPIENTRY
_mesa_marshal_Vertex2d(GLdouble x, GLdouble y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex2d);
   struct marshal_cmd_Vertex2d *cmd;
   debug_print_marshal("Vertex2d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex2d, cmd_size);
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex2d");
   CALL_Vertex2d(ctx->CurrentServerDispatch, (x, y));
}


/* Vertex2f: marshalled asynchronously */
struct marshal_cmd_Vertex2f
{
   struct marshal_cmd_base cmd_base;
   GLfloat x;
   GLfloat y;
};
static inline void
_mesa_unmarshal_Vertex2f(struct gl_context *ctx, const struct marshal_cmd_Vertex2f *cmd)
{
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   CALL_Vertex2f(ctx->CurrentServerDispatch, (x, y));
}
static void GLAPIENTRY
_mesa_marshal_Vertex2f(GLfloat x, GLfloat y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex2f);
   struct marshal_cmd_Vertex2f *cmd;
   debug_print_marshal("Vertex2f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex2f, cmd_size);
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex2f");
   CALL_Vertex2f(ctx->CurrentServerDispatch, (x, y));
}


/* Color4bv: marshalled asynchronously */
struct marshal_cmd_Color4bv
{
   struct marshal_cmd_base cmd_base;
   GLbyte v[4];
};
static inline void
_mesa_unmarshal_Color4bv(struct gl_context *ctx, const struct marshal_cmd_Color4bv *cmd)
{
   const GLbyte * v = cmd->v;
   CALL_Color4bv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Color4bv(const GLbyte * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color4bv);
   struct marshal_cmd_Color4bv *cmd;
   debug_print_marshal("Color4bv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color4bv, cmd_size);
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color4bv");
   CALL_Color4bv(ctx->CurrentServerDispatch, (v));
}


/* ProgramUniformMatrix3x2dv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix3x2dv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 48) bytes are GLdouble value[count][6] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix3x2dv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix3x2dv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 48;
   CALL_ProgramUniformMatrix3x2dv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix3x2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix3x2dv) + safe_mul(count, 48);
   struct marshal_cmd_ProgramUniformMatrix3x2dv *cmd;
   debug_print_marshal("ProgramUniformMatrix3x2dv");
   if (unlikely(safe_mul(count, 48) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix3x2dv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 48);
      variable_data += count * 48;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix3x2dv");
   CALL_ProgramUniformMatrix3x2dv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* VertexAttrib2fvNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib2fvNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat v[2];
};
static inline void
_mesa_unmarshal_VertexAttrib2fvNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib2fvNV *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat * v = cmd->v;
   CALL_VertexAttrib2fvNV(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib2fvNV(GLuint index, const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib2fvNV);
   struct marshal_cmd_VertexAttrib2fvNV *cmd;
   debug_print_marshal("VertexAttrib2fvNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib2fvNV, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib2fvNV");
   CALL_VertexAttrib2fvNV(ctx->CurrentServerDispatch, (index, v));
}


/* Vertex2s: marshalled asynchronously */
struct marshal_cmd_Vertex2s
{
   struct marshal_cmd_base cmd_base;
   GLshort x;
   GLshort y;
};
static inline void
_mesa_unmarshal_Vertex2s(struct gl_context *ctx, const struct marshal_cmd_Vertex2s *cmd)
{
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   CALL_Vertex2s(ctx->CurrentServerDispatch, (x, y));
}
static void GLAPIENTRY
_mesa_marshal_Vertex2s(GLshort x, GLshort y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex2s);
   struct marshal_cmd_Vertex2s *cmd;
   debug_print_marshal("Vertex2s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex2s, cmd_size);
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex2s");
   CALL_Vertex2s(ctx->CurrentServerDispatch, (x, y));
}


/* ActiveTexture: marshalled asynchronously */
struct marshal_cmd_ActiveTexture
{
   struct marshal_cmd_base cmd_base;
   GLenum texture;
};
static inline void
_mesa_unmarshal_ActiveTexture(struct gl_context *ctx, const struct marshal_cmd_ActiveTexture *cmd)
{
   const GLenum texture = cmd->texture;
   CALL_ActiveTexture(ctx->CurrentServerDispatch, (texture));
}
static void GLAPIENTRY
_mesa_marshal_ActiveTexture(GLenum texture)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ActiveTexture);
   struct marshal_cmd_ActiveTexture *cmd;
   debug_print_marshal("ActiveTexture");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ActiveTexture, cmd_size);
      cmd->texture = texture;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ActiveTexture");
   CALL_ActiveTexture(ctx->CurrentServerDispatch, (texture));
}


/* InvalidateNamedFramebufferSubData: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_InvalidateNamedFramebufferSubData(GLuint framebuffer, GLsizei numAttachments, const GLenum * attachments, GLint x, GLint y, GLsizei width, GLsizei height)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("InvalidateNamedFramebufferSubData");
   CALL_InvalidateNamedFramebufferSubData(ctx->CurrentServerDispatch, (framebuffer, numAttachments, attachments, x, y, width, height));
}


/* ColorP4uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_ColorP4uiv(GLenum type, const GLuint * color)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("ColorP4uiv");
   CALL_ColorP4uiv(ctx->CurrentServerDispatch, (type, color));
}


/* DrawTexxOES: marshalled asynchronously */
struct marshal_cmd_DrawTexxOES
{
   struct marshal_cmd_base cmd_base;
   GLfixed x;
   GLfixed y;
   GLfixed z;
   GLfixed width;
   GLfixed height;
};
static inline void
_mesa_unmarshal_DrawTexxOES(struct gl_context *ctx, const struct marshal_cmd_DrawTexxOES *cmd)
{
   const GLfixed x = cmd->x;
   const GLfixed y = cmd->y;
   const GLfixed z = cmd->z;
   const GLfixed width = cmd->width;
   const GLfixed height = cmd->height;
   CALL_DrawTexxOES(ctx->CurrentServerDispatch, (x, y, z, width, height));
}
static void GLAPIENTRY
_mesa_marshal_DrawTexxOES(GLfixed x, GLfixed y, GLfixed z, GLfixed width, GLfixed height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawTexxOES);
   struct marshal_cmd_DrawTexxOES *cmd;
   debug_print_marshal("DrawTexxOES");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawTexxOES, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->width = width;
      cmd->height = height;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawTexxOES");
   CALL_DrawTexxOES(ctx->CurrentServerDispatch, (x, y, z, width, height));
}


/* MultiTexCoordP3ui: marshalled asynchronously */
struct marshal_cmd_MultiTexCoordP3ui
{
   struct marshal_cmd_base cmd_base;
   GLenum texture;
   GLenum type;
   GLuint coords;
};
static inline void
_mesa_unmarshal_MultiTexCoordP3ui(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoordP3ui *cmd)
{
   const GLenum texture = cmd->texture;
   const GLenum type = cmd->type;
   const GLuint coords = cmd->coords;
   CALL_MultiTexCoordP3ui(ctx->CurrentServerDispatch, (texture, type, coords));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoordP3ui(GLenum texture, GLenum type, GLuint coords)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoordP3ui);
   struct marshal_cmd_MultiTexCoordP3ui *cmd;
   debug_print_marshal("MultiTexCoordP3ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoordP3ui, cmd_size);
      cmd->texture = texture;
      cmd->type = type;
      cmd->coords = coords;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoordP3ui");
   CALL_MultiTexCoordP3ui(ctx->CurrentServerDispatch, (texture, type, coords));
}


/* GetAttribLocation: marshalled synchronously */
static GLint GLAPIENTRY
_mesa_marshal_GetAttribLocation(GLuint program, const GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetAttribLocation");
   return CALL_GetAttribLocation(ctx->CurrentServerDispatch, (program, name));
}


/* DrawBuffer: marshalled asynchronously */
struct marshal_cmd_DrawBuffer
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
};
static inline void
_mesa_unmarshal_DrawBuffer(struct gl_context *ctx, const struct marshal_cmd_DrawBuffer *cmd)
{
   const GLenum mode = cmd->mode;
   CALL_DrawBuffer(ctx->CurrentServerDispatch, (mode));
}
static void GLAPIENTRY
_mesa_marshal_DrawBuffer(GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawBuffer);
   struct marshal_cmd_DrawBuffer *cmd;
   debug_print_marshal("DrawBuffer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawBuffer, cmd_size);
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawBuffer");
   CALL_DrawBuffer(ctx->CurrentServerDispatch, (mode));
}


/* GetPointerv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetPointerv(GLenum pname, GLvoid ** params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetPointerv");
   CALL_GetPointerv(ctx->CurrentServerDispatch, (pname, params));
}


/* MultiTexCoord2dv: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord2dv
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLdouble v[2];
};
static inline void
_mesa_unmarshal_MultiTexCoord2dv(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord2dv *cmd)
{
   const GLenum target = cmd->target;
   const GLdouble * v = cmd->v;
   CALL_MultiTexCoord2dv(ctx->CurrentServerDispatch, (target, v));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord2dv(GLenum target, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord2dv);
   struct marshal_cmd_MultiTexCoord2dv *cmd;
   debug_print_marshal("MultiTexCoord2dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord2dv, cmd_size);
      cmd->target = target;
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord2dv");
   CALL_MultiTexCoord2dv(ctx->CurrentServerDispatch, (target, v));
}


/* IsSampler: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsSampler(GLuint sampler)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsSampler");
   return CALL_IsSampler(ctx->CurrentServerDispatch, (sampler));
}


/* BlendFunc: marshalled asynchronously */
struct marshal_cmd_BlendFunc
{
   struct marshal_cmd_base cmd_base;
   GLenum sfactor;
   GLenum dfactor;
};
static inline void
_mesa_unmarshal_BlendFunc(struct gl_context *ctx, const struct marshal_cmd_BlendFunc *cmd)
{
   const GLenum sfactor = cmd->sfactor;
   const GLenum dfactor = cmd->dfactor;
   CALL_BlendFunc(ctx->CurrentServerDispatch, (sfactor, dfactor));
}
static void GLAPIENTRY
_mesa_marshal_BlendFunc(GLenum sfactor, GLenum dfactor)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BlendFunc);
   struct marshal_cmd_BlendFunc *cmd;
   debug_print_marshal("BlendFunc");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BlendFunc, cmd_size);
      cmd->sfactor = sfactor;
      cmd->dfactor = dfactor;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BlendFunc");
   CALL_BlendFunc(ctx->CurrentServerDispatch, (sfactor, dfactor));
}


/* NamedRenderbufferStorageMultisample: marshalled asynchronously */
struct marshal_cmd_NamedRenderbufferStorageMultisample
{
   struct marshal_cmd_base cmd_base;
   GLuint renderbuffer;
   GLsizei samples;
   GLenum internalformat;
   GLsizei width;
   GLsizei height;
};
static inline void
_mesa_unmarshal_NamedRenderbufferStorageMultisample(struct gl_context *ctx, const struct marshal_cmd_NamedRenderbufferStorageMultisample *cmd)
{
   const GLuint renderbuffer = cmd->renderbuffer;
   const GLsizei samples = cmd->samples;
   const GLenum internalformat = cmd->internalformat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   CALL_NamedRenderbufferStorageMultisample(ctx->CurrentServerDispatch, (renderbuffer, samples, internalformat, width, height));
}
static void GLAPIENTRY
_mesa_marshal_NamedRenderbufferStorageMultisample(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_NamedRenderbufferStorageMultisample);
   struct marshal_cmd_NamedRenderbufferStorageMultisample *cmd;
   debug_print_marshal("NamedRenderbufferStorageMultisample");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_NamedRenderbufferStorageMultisample, cmd_size);
      cmd->renderbuffer = renderbuffer;
      cmd->samples = samples;
      cmd->internalformat = internalformat;
      cmd->width = width;
      cmd->height = height;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("NamedRenderbufferStorageMultisample");
   CALL_NamedRenderbufferStorageMultisample(ctx->CurrentServerDispatch, (renderbuffer, samples, internalformat, width, height));
}


/* ColorMaterial: marshalled asynchronously */
struct marshal_cmd_ColorMaterial
{
   struct marshal_cmd_base cmd_base;
   GLenum face;
   GLenum mode;
};
static inline void
_mesa_unmarshal_ColorMaterial(struct gl_context *ctx, const struct marshal_cmd_ColorMaterial *cmd)
{
   const GLenum face = cmd->face;
   const GLenum mode = cmd->mode;
   CALL_ColorMaterial(ctx->CurrentServerDispatch, (face, mode));
}
static void GLAPIENTRY
_mesa_marshal_ColorMaterial(GLenum face, GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ColorMaterial);
   struct marshal_cmd_ColorMaterial *cmd;
   debug_print_marshal("ColorMaterial");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ColorMaterial, cmd_size);
      cmd->face = face;
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ColorMaterial");
   CALL_ColorMaterial(ctx->CurrentServerDispatch, (face, mode));
}


/* RasterPos3sv: marshalled asynchronously */
struct marshal_cmd_RasterPos3sv
{
   struct marshal_cmd_base cmd_base;
   GLshort v[3];
};
static inline void
_mesa_unmarshal_RasterPos3sv(struct gl_context *ctx, const struct marshal_cmd_RasterPos3sv *cmd)
{
   const GLshort * v = cmd->v;
   CALL_RasterPos3sv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos3sv(const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos3sv);
   struct marshal_cmd_RasterPos3sv *cmd;
   debug_print_marshal("RasterPos3sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos3sv, cmd_size);
      memcpy(cmd->v, v, 6);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos3sv");
   CALL_RasterPos3sv(ctx->CurrentServerDispatch, (v));
}


/* TexCoordP2ui: marshalled asynchronously */
struct marshal_cmd_TexCoordP2ui
{
   struct marshal_cmd_base cmd_base;
   GLenum type;
   GLuint coords;
};
static inline void
_mesa_unmarshal_TexCoordP2ui(struct gl_context *ctx, const struct marshal_cmd_TexCoordP2ui *cmd)
{
   const GLenum type = cmd->type;
   const GLuint coords = cmd->coords;
   CALL_TexCoordP2ui(ctx->CurrentServerDispatch, (type, coords));
}
static void GLAPIENTRY
_mesa_marshal_TexCoordP2ui(GLenum type, GLuint coords)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoordP2ui);
   struct marshal_cmd_TexCoordP2ui *cmd;
   debug_print_marshal("TexCoordP2ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoordP2ui, cmd_size);
      cmd->type = type;
      cmd->coords = coords;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoordP2ui");
   CALL_TexCoordP2ui(ctx->CurrentServerDispatch, (type, coords));
}


/* TexParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexParameteriv(GLenum target, GLenum pname, const GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexParameteriv");
   CALL_TexParameteriv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* WaitSemaphoreEXT: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_WaitSemaphoreEXT(GLuint semaphore, GLuint numBufferBarriers, const GLuint * buffers, GLuint numTextureBarriers, const GLuint * textures, const GLenum * srcLayouts)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("WaitSemaphoreEXT");
   CALL_WaitSemaphoreEXT(ctx->CurrentServerDispatch, (semaphore, numBufferBarriers, buffers, numTextureBarriers, textures, srcLayouts));
}


/* VertexAttrib3fvARB: marshalled asynchronously */
struct marshal_cmd_VertexAttrib3fvARB
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat v[3];
};
static inline void
_mesa_unmarshal_VertexAttrib3fvARB(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib3fvARB *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat * v = cmd->v;
   CALL_VertexAttrib3fvARB(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib3fvARB(GLuint index, const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib3fvARB);
   struct marshal_cmd_VertexAttrib3fvARB *cmd;
   debug_print_marshal("VertexAttrib3fvARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib3fvARB, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib3fvARB");
   CALL_VertexAttrib3fvARB(ctx->CurrentServerDispatch, (index, v));
}


/* ProgramUniformMatrix3x4fv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix3x4fv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 48) bytes are GLfloat value[count][12] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix3x4fv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix3x4fv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 48;
   CALL_ProgramUniformMatrix3x4fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix3x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix3x4fv) + safe_mul(count, 48);
   struct marshal_cmd_ProgramUniformMatrix3x4fv *cmd;
   debug_print_marshal("ProgramUniformMatrix3x4fv");
   if (unlikely(safe_mul(count, 48) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix3x4fv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 48);
      variable_data += count * 48;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix3x4fv");
   CALL_ProgramUniformMatrix3x4fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* GetColorTable: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetColorTable(GLenum target, GLenum format, GLenum type, GLvoid * table)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetColorTable");
   CALL_GetColorTable(ctx->CurrentServerDispatch, (target, format, type, table));
}


/* TexCoord3i: marshalled asynchronously */
struct marshal_cmd_TexCoord3i
{
   struct marshal_cmd_base cmd_base;
   GLint s;
   GLint t;
   GLint r;
};
static inline void
_mesa_unmarshal_TexCoord3i(struct gl_context *ctx, const struct marshal_cmd_TexCoord3i *cmd)
{
   const GLint s = cmd->s;
   const GLint t = cmd->t;
   const GLint r = cmd->r;
   CALL_TexCoord3i(ctx->CurrentServerDispatch, (s, t, r));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord3i(GLint s, GLint t, GLint r)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord3i);
   struct marshal_cmd_TexCoord3i *cmd;
   debug_print_marshal("TexCoord3i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord3i, cmd_size);
      cmd->s = s;
      cmd->t = t;
      cmd->r = r;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord3i");
   CALL_TexCoord3i(ctx->CurrentServerDispatch, (s, t, r));
}


/* CopyColorTable: marshalled asynchronously */
struct marshal_cmd_CopyColorTable
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum internalformat;
   GLint x;
   GLint y;
   GLsizei width;
};
static inline void
_mesa_unmarshal_CopyColorTable(struct gl_context *ctx, const struct marshal_cmd_CopyColorTable *cmd)
{
   const GLenum target = cmd->target;
   const GLenum internalformat = cmd->internalformat;
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLsizei width = cmd->width;
   CALL_CopyColorTable(ctx->CurrentServerDispatch, (target, internalformat, x, y, width));
}
static void GLAPIENTRY
_mesa_marshal_CopyColorTable(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_CopyColorTable);
   struct marshal_cmd_CopyColorTable *cmd;
   debug_print_marshal("CopyColorTable");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_CopyColorTable, cmd_size);
      cmd->target = target;
      cmd->internalformat = internalformat;
      cmd->x = x;
      cmd->y = y;
      cmd->width = width;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("CopyColorTable");
   CALL_CopyColorTable(ctx->CurrentServerDispatch, (target, internalformat, x, y, width));
}


/* Frustum: marshalled asynchronously */
struct marshal_cmd_Frustum
{
   struct marshal_cmd_base cmd_base;
   GLdouble left;
   GLdouble right;
   GLdouble bottom;
   GLdouble top;
   GLdouble zNear;
   GLdouble zFar;
};
static inline void
_mesa_unmarshal_Frustum(struct gl_context *ctx, const struct marshal_cmd_Frustum *cmd)
{
   const GLdouble left = cmd->left;
   const GLdouble right = cmd->right;
   const GLdouble bottom = cmd->bottom;
   const GLdouble top = cmd->top;
   const GLdouble zNear = cmd->zNear;
   const GLdouble zFar = cmd->zFar;
   CALL_Frustum(ctx->CurrentServerDispatch, (left, right, bottom, top, zNear, zFar));
}
static void GLAPIENTRY
_mesa_marshal_Frustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Frustum);
   struct marshal_cmd_Frustum *cmd;
   debug_print_marshal("Frustum");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Frustum, cmd_size);
      cmd->left = left;
      cmd->right = right;
      cmd->bottom = bottom;
      cmd->top = top;
      cmd->zNear = zNear;
      cmd->zFar = zFar;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Frustum");
   CALL_Frustum(ctx->CurrentServerDispatch, (left, right, bottom, top, zNear, zFar));
}


/* TexCoord3d: marshalled asynchronously */
struct marshal_cmd_TexCoord3d
{
   struct marshal_cmd_base cmd_base;
   GLdouble s;
   GLdouble t;
   GLdouble r;
};
static inline void
_mesa_unmarshal_TexCoord3d(struct gl_context *ctx, const struct marshal_cmd_TexCoord3d *cmd)
{
   const GLdouble s = cmd->s;
   const GLdouble t = cmd->t;
   const GLdouble r = cmd->r;
   CALL_TexCoord3d(ctx->CurrentServerDispatch, (s, t, r));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord3d(GLdouble s, GLdouble t, GLdouble r)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord3d);
   struct marshal_cmd_TexCoord3d *cmd;
   debug_print_marshal("TexCoord3d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord3d, cmd_size);
      cmd->s = s;
      cmd->t = t;
      cmd->r = r;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord3d");
   CALL_TexCoord3d(ctx->CurrentServerDispatch, (s, t, r));
}


/* GetTextureParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTextureParameteriv(GLuint texture, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTextureParameteriv");
   CALL_GetTextureParameteriv(ctx->CurrentServerDispatch, (texture, pname, params));
}


/* TexCoord3f: marshalled asynchronously */
struct marshal_cmd_TexCoord3f
{
   struct marshal_cmd_base cmd_base;
   GLfloat s;
   GLfloat t;
   GLfloat r;
};
static inline void
_mesa_unmarshal_TexCoord3f(struct gl_context *ctx, const struct marshal_cmd_TexCoord3f *cmd)
{
   const GLfloat s = cmd->s;
   const GLfloat t = cmd->t;
   const GLfloat r = cmd->r;
   CALL_TexCoord3f(ctx->CurrentServerDispatch, (s, t, r));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord3f(GLfloat s, GLfloat t, GLfloat r)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord3f);
   struct marshal_cmd_TexCoord3f *cmd;
   debug_print_marshal("TexCoord3f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord3f, cmd_size);
      cmd->s = s;
      cmd->t = t;
      cmd->r = r;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord3f");
   CALL_TexCoord3f(ctx->CurrentServerDispatch, (s, t, r));
}


/* DepthRangeArrayv: marshalled asynchronously */
struct marshal_cmd_DepthRangeArrayv
{
   struct marshal_cmd_base cmd_base;
   GLuint first;
   GLsizei count;
   /* Next safe_mul(count, 16) bytes are GLclampd v[count][2] */
};
static inline void
_mesa_unmarshal_DepthRangeArrayv(struct gl_context *ctx, const struct marshal_cmd_DepthRangeArrayv *cmd)
{
   const GLuint first = cmd->first;
   const GLsizei count = cmd->count;
   const GLclampd * v;
   const char *variable_data = (const char *) (cmd + 1);
   v = (const GLclampd *) variable_data;
   variable_data += count * 16;
   CALL_DepthRangeArrayv(ctx->CurrentServerDispatch, (first, count, v));
}
static void GLAPIENTRY
_mesa_marshal_DepthRangeArrayv(GLuint first, GLsizei count, const GLclampd * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DepthRangeArrayv) + safe_mul(count, 16);
   struct marshal_cmd_DepthRangeArrayv *cmd;
   debug_print_marshal("DepthRangeArrayv");
   if (unlikely(safe_mul(count, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DepthRangeArrayv, cmd_size);
      cmd->first = first;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, v, count * 16);
      variable_data += count * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DepthRangeArrayv");
   CALL_DepthRangeArrayv(ctx->CurrentServerDispatch, (first, count, v));
}


/* DeleteTextures: marshalled asynchronously */
struct marshal_cmd_DeleteTextures
{
   struct marshal_cmd_base cmd_base;
   GLsizei n;
   /* Next safe_mul(n, 4) bytes are GLuint textures[n] */
};
static inline void
_mesa_unmarshal_DeleteTextures(struct gl_context *ctx, const struct marshal_cmd_DeleteTextures *cmd)
{
   const GLsizei n = cmd->n;
   const GLuint * textures;
   const char *variable_data = (const char *) (cmd + 1);
   textures = (const GLuint *) variable_data;
   variable_data += n * 4;
   CALL_DeleteTextures(ctx->CurrentServerDispatch, (n, textures));
}
static void GLAPIENTRY
_mesa_marshal_DeleteTextures(GLsizei n, const GLuint * textures)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DeleteTextures) + safe_mul(n, 4);
   struct marshal_cmd_DeleteTextures *cmd;
   debug_print_marshal("DeleteTextures");
   if (unlikely(safe_mul(n, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DeleteTextures, cmd_size);
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, textures, n * 4);
      variable_data += n * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DeleteTextures");
   CALL_DeleteTextures(ctx->CurrentServerDispatch, (n, textures));
}


/* TexCoordPointerEXT: marshalled asynchronously */
struct marshal_cmd_TexCoordPointerEXT
{
   struct marshal_cmd_base cmd_base;
   GLint size;
   GLenum type;
   GLsizei stride;
   GLsizei count;
   const GLvoid * pointer;
};
static inline void
_mesa_unmarshal_TexCoordPointerEXT(struct gl_context *ctx, const struct marshal_cmd_TexCoordPointerEXT *cmd)
{
   const GLint size = cmd->size;
   const GLenum type = cmd->type;
   const GLsizei stride = cmd->stride;
   const GLsizei count = cmd->count;
   const GLvoid * pointer = cmd->pointer;
   CALL_TexCoordPointerEXT(ctx->CurrentServerDispatch, (size, type, stride, count, pointer));
}
static void GLAPIENTRY
_mesa_marshal_TexCoordPointerEXT(GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoordPointerEXT);
   struct marshal_cmd_TexCoordPointerEXT *cmd;
   debug_print_marshal("TexCoordPointerEXT");
   if (_mesa_glthread_is_non_vbo_vertex_attrib_pointer(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("TexCoordPointerEXT");
      CALL_TexCoordPointerEXT(ctx->CurrentServerDispatch, (size, type, stride, count, pointer));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoordPointerEXT, cmd_size);
      cmd->size = size;
      cmd->type = type;
      cmd->stride = stride;
      cmd->count = count;
      cmd->pointer = pointer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoordPointerEXT");
   CALL_TexCoordPointerEXT(ctx->CurrentServerDispatch, (size, type, stride, count, pointer));
}


/* TexCoord3s: marshalled asynchronously */
struct marshal_cmd_TexCoord3s
{
   struct marshal_cmd_base cmd_base;
   GLshort s;
   GLshort t;
   GLshort r;
};
static inline void
_mesa_unmarshal_TexCoord3s(struct gl_context *ctx, const struct marshal_cmd_TexCoord3s *cmd)
{
   const GLshort s = cmd->s;
   const GLshort t = cmd->t;
   const GLshort r = cmd->r;
   CALL_TexCoord3s(ctx->CurrentServerDispatch, (s, t, r));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord3s(GLshort s, GLshort t, GLshort r)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord3s);
   struct marshal_cmd_TexCoord3s *cmd;
   debug_print_marshal("TexCoord3s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord3s, cmd_size);
      cmd->s = s;
      cmd->t = t;
      cmd->r = r;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord3s");
   CALL_TexCoord3s(ctx->CurrentServerDispatch, (s, t, r));
}


/* GetTexLevelParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTexLevelParameteriv");
   CALL_GetTexLevelParameteriv(ctx->CurrentServerDispatch, (target, level, pname, params));
}


/* TextureParameterIuiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TextureParameterIuiv(GLuint texture, GLenum pname, const GLuint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TextureParameterIuiv");
   CALL_TextureParameterIuiv(ctx->CurrentServerDispatch, (texture, pname, params));
}


/* GenPerfMonitorsAMD: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GenPerfMonitorsAMD(GLsizei n, GLuint * monitors)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GenPerfMonitorsAMD");
   CALL_GenPerfMonitorsAMD(ctx->CurrentServerDispatch, (n, monitors));
}


/* ClearAccum: marshalled asynchronously */
struct marshal_cmd_ClearAccum
{
   struct marshal_cmd_base cmd_base;
   GLfloat red;
   GLfloat green;
   GLfloat blue;
   GLfloat alpha;
};
static inline void
_mesa_unmarshal_ClearAccum(struct gl_context *ctx, const struct marshal_cmd_ClearAccum *cmd)
{
   const GLfloat red = cmd->red;
   const GLfloat green = cmd->green;
   const GLfloat blue = cmd->blue;
   const GLfloat alpha = cmd->alpha;
   CALL_ClearAccum(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}
static void GLAPIENTRY
_mesa_marshal_ClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClearAccum);
   struct marshal_cmd_ClearAccum *cmd;
   debug_print_marshal("ClearAccum");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClearAccum, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      cmd->alpha = alpha;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClearAccum");
   CALL_ClearAccum(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}


/* TexCoord4iv: marshalled asynchronously */
struct marshal_cmd_TexCoord4iv
{
   struct marshal_cmd_base cmd_base;
   GLint v[4];
};
static inline void
_mesa_unmarshal_TexCoord4iv(struct gl_context *ctx, const struct marshal_cmd_TexCoord4iv *cmd)
{
   const GLint * v = cmd->v;
   CALL_TexCoord4iv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord4iv(const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord4iv);
   struct marshal_cmd_TexCoord4iv *cmd;
   debug_print_marshal("TexCoord4iv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord4iv, cmd_size);
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord4iv");
   CALL_TexCoord4iv(ctx->CurrentServerDispatch, (v));
}


/* TexStorage3D: marshalled asynchronously */
struct marshal_cmd_TexStorage3D
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizei levels;
   GLenum internalFormat;
   GLsizei width;
   GLsizei height;
   GLsizei depth;
};
static inline void
_mesa_unmarshal_TexStorage3D(struct gl_context *ctx, const struct marshal_cmd_TexStorage3D *cmd)
{
   const GLenum target = cmd->target;
   const GLsizei levels = cmd->levels;
   const GLenum internalFormat = cmd->internalFormat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLsizei depth = cmd->depth;
   CALL_TexStorage3D(ctx->CurrentServerDispatch, (target, levels, internalFormat, width, height, depth));
}
static void GLAPIENTRY
_mesa_marshal_TexStorage3D(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexStorage3D);
   struct marshal_cmd_TexStorage3D *cmd;
   debug_print_marshal("TexStorage3D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexStorage3D, cmd_size);
      cmd->target = target;
      cmd->levels = levels;
      cmd->internalFormat = internalFormat;
      cmd->width = width;
      cmd->height = height;
      cmd->depth = depth;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexStorage3D");
   CALL_TexStorage3D(ctx->CurrentServerDispatch, (target, levels, internalFormat, width, height, depth));
}


/* Uniform2i64ARB: marshalled asynchronously */
struct marshal_cmd_Uniform2i64ARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLint64 x;
   GLint64 y;
};
static inline void
_mesa_unmarshal_Uniform2i64ARB(struct gl_context *ctx, const struct marshal_cmd_Uniform2i64ARB *cmd)
{
   const GLint location = cmd->location;
   const GLint64 x = cmd->x;
   const GLint64 y = cmd->y;
   CALL_Uniform2i64ARB(ctx->CurrentServerDispatch, (location, x, y));
}
static void GLAPIENTRY
_mesa_marshal_Uniform2i64ARB(GLint location, GLint64 x, GLint64 y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform2i64ARB);
   struct marshal_cmd_Uniform2i64ARB *cmd;
   debug_print_marshal("Uniform2i64ARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform2i64ARB, cmd_size);
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform2i64ARB");
   CALL_Uniform2i64ARB(ctx->CurrentServerDispatch, (location, x, y));
}


/* FramebufferTexture3D: marshalled asynchronously */
struct marshal_cmd_FramebufferTexture3D
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum attachment;
   GLenum textarget;
   GLuint texture;
   GLint level;
   GLint layer;
};
static inline void
_mesa_unmarshal_FramebufferTexture3D(struct gl_context *ctx, const struct marshal_cmd_FramebufferTexture3D *cmd)
{
   const GLenum target = cmd->target;
   const GLenum attachment = cmd->attachment;
   const GLenum textarget = cmd->textarget;
   const GLuint texture = cmd->texture;
   const GLint level = cmd->level;
   const GLint layer = cmd->layer;
   CALL_FramebufferTexture3D(ctx->CurrentServerDispatch, (target, attachment, textarget, texture, level, layer));
}
static void GLAPIENTRY
_mesa_marshal_FramebufferTexture3D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint layer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_FramebufferTexture3D);
   struct marshal_cmd_FramebufferTexture3D *cmd;
   debug_print_marshal("FramebufferTexture3D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_FramebufferTexture3D, cmd_size);
      cmd->target = target;
      cmd->attachment = attachment;
      cmd->textarget = textarget;
      cmd->texture = texture;
      cmd->level = level;
      cmd->layer = layer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("FramebufferTexture3D");
   CALL_FramebufferTexture3D(ctx->CurrentServerDispatch, (target, attachment, textarget, texture, level, layer));
}


/* GetBufferParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetBufferParameteriv(GLenum target, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetBufferParameteriv");
   CALL_GetBufferParameteriv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* VertexAttrib2fNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib2fNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat x;
   GLfloat y;
};
static inline void
_mesa_unmarshal_VertexAttrib2fNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib2fNV *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   CALL_VertexAttrib2fNV(ctx->CurrentServerDispatch, (index, x, y));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib2fNV(GLuint index, GLfloat x, GLfloat y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib2fNV);
   struct marshal_cmd_VertexAttrib2fNV *cmd;
   debug_print_marshal("VertexAttrib2fNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib2fNV, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib2fNV");
   CALL_VertexAttrib2fNV(ctx->CurrentServerDispatch, (index, x, y));
}


/* CopyTexImage2D: marshalled asynchronously */
struct marshal_cmd_CopyTexImage2D
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLint level;
   GLenum internalformat;
   GLint x;
   GLint y;
   GLsizei width;
   GLsizei height;
   GLint border;
};
static inline void
_mesa_unmarshal_CopyTexImage2D(struct gl_context *ctx, const struct marshal_cmd_CopyTexImage2D *cmd)
{
   const GLenum target = cmd->target;
   const GLint level = cmd->level;
   const GLenum internalformat = cmd->internalformat;
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLint border = cmd->border;
   CALL_CopyTexImage2D(ctx->CurrentServerDispatch, (target, level, internalformat, x, y, width, height, border));
}
static void GLAPIENTRY
_mesa_marshal_CopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_CopyTexImage2D);
   struct marshal_cmd_CopyTexImage2D *cmd;
   debug_print_marshal("CopyTexImage2D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_CopyTexImage2D, cmd_size);
      cmd->target = target;
      cmd->level = level;
      cmd->internalformat = internalformat;
      cmd->x = x;
      cmd->y = y;
      cmd->width = width;
      cmd->height = height;
      cmd->border = border;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("CopyTexImage2D");
   CALL_CopyTexImage2D(ctx->CurrentServerDispatch, (target, level, internalformat, x, y, width, height, border));
}


/* Vertex3fv: marshalled asynchronously */
struct marshal_cmd_Vertex3fv
{
   struct marshal_cmd_base cmd_base;
   GLfloat v[3];
};
static inline void
_mesa_unmarshal_Vertex3fv(struct gl_context *ctx, const struct marshal_cmd_Vertex3fv *cmd)
{
   const GLfloat * v = cmd->v;
   CALL_Vertex3fv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Vertex3fv(const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex3fv);
   struct marshal_cmd_Vertex3fv *cmd;
   debug_print_marshal("Vertex3fv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex3fv, cmd_size);
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex3fv");
   CALL_Vertex3fv(ctx->CurrentServerDispatch, (v));
}


/* WindowPos4dvMESA: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_WindowPos4dvMESA(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("WindowPos4dvMESA");
   CALL_WindowPos4dvMESA(ctx->CurrentServerDispatch, (v));
}


/* ProgramUniform2i64vARB: marshalled asynchronously */
struct marshal_cmd_ProgramUniform2i64vARB
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 16) bytes are GLint64 value[count][2] */
};
static inline void
_mesa_unmarshal_ProgramUniform2i64vARB(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform2i64vARB *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLint64 * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLint64 *) variable_data;
   variable_data += count * 16;
   CALL_ProgramUniform2i64vARB(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform2i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform2i64vARB) + safe_mul(count, 16);
   struct marshal_cmd_ProgramUniform2i64vARB *cmd;
   debug_print_marshal("ProgramUniform2i64vARB");
   if (unlikely(safe_mul(count, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform2i64vARB, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 16);
      variable_data += count * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform2i64vARB");
   CALL_ProgramUniform2i64vARB(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* MultiTexCoordP2ui: marshalled asynchronously */
struct marshal_cmd_MultiTexCoordP2ui
{
   struct marshal_cmd_base cmd_base;
   GLenum texture;
   GLenum type;
   GLuint coords;
};
static inline void
_mesa_unmarshal_MultiTexCoordP2ui(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoordP2ui *cmd)
{
   const GLenum texture = cmd->texture;
   const GLenum type = cmd->type;
   const GLuint coords = cmd->coords;
   CALL_MultiTexCoordP2ui(ctx->CurrentServerDispatch, (texture, type, coords));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoordP2ui(GLenum texture, GLenum type, GLuint coords)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoordP2ui);
   struct marshal_cmd_MultiTexCoordP2ui *cmd;
   debug_print_marshal("MultiTexCoordP2ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoordP2ui, cmd_size);
      cmd->texture = texture;
      cmd->type = type;
      cmd->coords = coords;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoordP2ui");
   CALL_MultiTexCoordP2ui(ctx->CurrentServerDispatch, (texture, type, coords));
}


/* VertexAttribs1dvNV: marshalled asynchronously */
struct marshal_cmd_VertexAttribs1dvNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLsizei n;
   /* Next safe_mul(n, 8) bytes are GLdouble v[n] */
};
static inline void
_mesa_unmarshal_VertexAttribs1dvNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttribs1dvNV *cmd)
{
   const GLuint index = cmd->index;
   const GLsizei n = cmd->n;
   const GLdouble * v;
   const char *variable_data = (const char *) (cmd + 1);
   v = (const GLdouble *) variable_data;
   variable_data += n * 8;
   CALL_VertexAttribs1dvNV(ctx->CurrentServerDispatch, (index, n, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribs1dvNV(GLuint index, GLsizei n, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribs1dvNV) + safe_mul(n, 8);
   struct marshal_cmd_VertexAttribs1dvNV *cmd;
   debug_print_marshal("VertexAttribs1dvNV");
   if (unlikely(safe_mul(n, 8) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribs1dvNV, cmd_size);
      cmd->index = index;
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, v, n * 8);
      variable_data += n * 8;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribs1dvNV");
   CALL_VertexAttribs1dvNV(ctx->CurrentServerDispatch, (index, n, v));
}


/* ImportSemaphoreFdEXT: marshalled asynchronously */
struct marshal_cmd_ImportSemaphoreFdEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint semaphore;
   GLenum handleType;
   GLint fd;
};
static inline void
_mesa_unmarshal_ImportSemaphoreFdEXT(struct gl_context *ctx, const struct marshal_cmd_ImportSemaphoreFdEXT *cmd)
{
   const GLuint semaphore = cmd->semaphore;
   const GLenum handleType = cmd->handleType;
   const GLint fd = cmd->fd;
   CALL_ImportSemaphoreFdEXT(ctx->CurrentServerDispatch, (semaphore, handleType, fd));
}
static void GLAPIENTRY
_mesa_marshal_ImportSemaphoreFdEXT(GLuint semaphore, GLenum handleType, GLint fd)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ImportSemaphoreFdEXT);
   struct marshal_cmd_ImportSemaphoreFdEXT *cmd;
   debug_print_marshal("ImportSemaphoreFdEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ImportSemaphoreFdEXT, cmd_size);
      cmd->semaphore = semaphore;
      cmd->handleType = handleType;
      cmd->fd = fd;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ImportSemaphoreFdEXT");
   CALL_ImportSemaphoreFdEXT(ctx->CurrentServerDispatch, (semaphore, handleType, fd));
}


/* IsQuery: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsQuery(GLuint id)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsQuery");
   return CALL_IsQuery(ctx->CurrentServerDispatch, (id));
}


/* EdgeFlagPointerEXT: marshalled asynchronously */
struct marshal_cmd_EdgeFlagPointerEXT
{
   struct marshal_cmd_base cmd_base;
   GLsizei stride;
   GLsizei count;
   const GLboolean * pointer;
};
static inline void
_mesa_unmarshal_EdgeFlagPointerEXT(struct gl_context *ctx, const struct marshal_cmd_EdgeFlagPointerEXT *cmd)
{
   const GLsizei stride = cmd->stride;
   const GLsizei count = cmd->count;
   const GLboolean * pointer = cmd->pointer;
   CALL_EdgeFlagPointerEXT(ctx->CurrentServerDispatch, (stride, count, pointer));
}
static void GLAPIENTRY
_mesa_marshal_EdgeFlagPointerEXT(GLsizei stride, GLsizei count, const GLboolean * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EdgeFlagPointerEXT);
   struct marshal_cmd_EdgeFlagPointerEXT *cmd;
   debug_print_marshal("EdgeFlagPointerEXT");
   if (_mesa_glthread_is_non_vbo_vertex_attrib_pointer(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("EdgeFlagPointerEXT");
      CALL_EdgeFlagPointerEXT(ctx->CurrentServerDispatch, (stride, count, pointer));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EdgeFlagPointerEXT, cmd_size);
      cmd->stride = stride;
      cmd->count = count;
      cmd->pointer = pointer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EdgeFlagPointerEXT");
   CALL_EdgeFlagPointerEXT(ctx->CurrentServerDispatch, (stride, count, pointer));
}


/* VertexAttribs2svNV: marshalled asynchronously */
struct marshal_cmd_VertexAttribs2svNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLsizei n;
   /* Next safe_mul(n, 4) bytes are GLshort v[n][2] */
};
static inline void
_mesa_unmarshal_VertexAttribs2svNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttribs2svNV *cmd)
{
   const GLuint index = cmd->index;
   const GLsizei n = cmd->n;
   const GLshort * v;
   const char *variable_data = (const char *) (cmd + 1);
   v = (const GLshort *) variable_data;
   variable_data += n * 4;
   CALL_VertexAttribs2svNV(ctx->CurrentServerDispatch, (index, n, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribs2svNV(GLuint index, GLsizei n, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribs2svNV) + safe_mul(n, 4);
   struct marshal_cmd_VertexAttribs2svNV *cmd;
   debug_print_marshal("VertexAttribs2svNV");
   if (unlikely(safe_mul(n, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribs2svNV, cmd_size);
      cmd->index = index;
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, v, n * 4);
      variable_data += n * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribs2svNV");
   CALL_VertexAttribs2svNV(ctx->CurrentServerDispatch, (index, n, v));
}


/* CreateShaderProgramv: marshalled synchronously */
static GLuint GLAPIENTRY
_mesa_marshal_CreateShaderProgramv(GLenum type, GLsizei count, const GLchar * const * strings)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CreateShaderProgramv");
   return CALL_CreateShaderProgramv(ctx->CurrentServerDispatch, (type, count, strings));
}


/* BlendEquationiARB: marshalled asynchronously */
struct marshal_cmd_BlendEquationiARB
{
   struct marshal_cmd_base cmd_base;
   GLuint buf;
   GLenum mode;
};
static inline void
_mesa_unmarshal_BlendEquationiARB(struct gl_context *ctx, const struct marshal_cmd_BlendEquationiARB *cmd)
{
   const GLuint buf = cmd->buf;
   const GLenum mode = cmd->mode;
   CALL_BlendEquationiARB(ctx->CurrentServerDispatch, (buf, mode));
}
static void GLAPIENTRY
_mesa_marshal_BlendEquationiARB(GLuint buf, GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BlendEquationiARB);
   struct marshal_cmd_BlendEquationiARB *cmd;
   debug_print_marshal("BlendEquationiARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BlendEquationiARB, cmd_size);
      cmd->buf = buf;
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BlendEquationiARB");
   CALL_BlendEquationiARB(ctx->CurrentServerDispatch, (buf, mode));
}


/* VertexAttribI4uivEXT: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribI4uivEXT(GLuint index, const GLuint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribI4uivEXT");
   CALL_VertexAttribI4uivEXT(ctx->CurrentServerDispatch, (index, v));
}


/* PointSizex: marshalled asynchronously */
struct marshal_cmd_PointSizex
{
   struct marshal_cmd_base cmd_base;
   GLfixed size;
};
static inline void
_mesa_unmarshal_PointSizex(struct gl_context *ctx, const struct marshal_cmd_PointSizex *cmd)
{
   const GLfixed size = cmd->size;
   CALL_PointSizex(ctx->CurrentServerDispatch, (size));
}
static void GLAPIENTRY
_mesa_marshal_PointSizex(GLfixed size)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PointSizex);
   struct marshal_cmd_PointSizex *cmd;
   debug_print_marshal("PointSizex");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PointSizex, cmd_size);
      cmd->size = size;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PointSizex");
   CALL_PointSizex(ctx->CurrentServerDispatch, (size));
}


/* PolygonMode: marshalled asynchronously */
struct marshal_cmd_PolygonMode
{
   struct marshal_cmd_base cmd_base;
   GLenum face;
   GLenum mode;
};
static inline void
_mesa_unmarshal_PolygonMode(struct gl_context *ctx, const struct marshal_cmd_PolygonMode *cmd)
{
   const GLenum face = cmd->face;
   const GLenum mode = cmd->mode;
   CALL_PolygonMode(ctx->CurrentServerDispatch, (face, mode));
}
static void GLAPIENTRY
_mesa_marshal_PolygonMode(GLenum face, GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PolygonMode);
   struct marshal_cmd_PolygonMode *cmd;
   debug_print_marshal("PolygonMode");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PolygonMode, cmd_size);
      cmd->face = face;
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PolygonMode");
   CALL_PolygonMode(ctx->CurrentServerDispatch, (face, mode));
}


/* SecondaryColor3iv: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3iv
{
   struct marshal_cmd_base cmd_base;
   GLint v[3];
};
static inline void
_mesa_unmarshal_SecondaryColor3iv(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3iv *cmd)
{
   const GLint * v = cmd->v;
   CALL_SecondaryColor3iv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3iv(const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3iv);
   struct marshal_cmd_SecondaryColor3iv *cmd;
   debug_print_marshal("SecondaryColor3iv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3iv, cmd_size);
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3iv");
   CALL_SecondaryColor3iv(ctx->CurrentServerDispatch, (v));
}


/* VertexAttribI1iEXT: marshalled asynchronously */
struct marshal_cmd_VertexAttribI1iEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLint x;
};
static inline void
_mesa_unmarshal_VertexAttribI1iEXT(struct gl_context *ctx, const struct marshal_cmd_VertexAttribI1iEXT *cmd)
{
   const GLuint index = cmd->index;
   const GLint x = cmd->x;
   CALL_VertexAttribI1iEXT(ctx->CurrentServerDispatch, (index, x));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribI1iEXT(GLuint index, GLint x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribI1iEXT);
   struct marshal_cmd_VertexAttribI1iEXT *cmd;
   debug_print_marshal("VertexAttribI1iEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribI1iEXT, cmd_size);
      cmd->index = index;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribI1iEXT");
   CALL_VertexAttribI1iEXT(ctx->CurrentServerDispatch, (index, x));
}


/* VertexAttrib4Niv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4Niv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLint v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4Niv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4Niv *cmd)
{
   const GLuint index = cmd->index;
   const GLint * v = cmd->v;
   CALL_VertexAttrib4Niv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4Niv(GLuint index, const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4Niv);
   struct marshal_cmd_VertexAttrib4Niv *cmd;
   debug_print_marshal("VertexAttrib4Niv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4Niv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4Niv");
   CALL_VertexAttrib4Niv(ctx->CurrentServerDispatch, (index, v));
}


/* GetnUniformdvARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnUniformdvARB(GLuint program, GLint location, GLsizei bufSize, GLdouble * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnUniformdvARB");
   CALL_GetnUniformdvARB(ctx->CurrentServerDispatch, (program, location, bufSize, params));
}


/* LinkProgram: marshalled asynchronously */
struct marshal_cmd_LinkProgram
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
};
static inline void
_mesa_unmarshal_LinkProgram(struct gl_context *ctx, const struct marshal_cmd_LinkProgram *cmd)
{
   const GLuint program = cmd->program;
   CALL_LinkProgram(ctx->CurrentServerDispatch, (program));
}
static void GLAPIENTRY
_mesa_marshal_LinkProgram(GLuint program)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_LinkProgram);
   struct marshal_cmd_LinkProgram *cmd;
   debug_print_marshal("LinkProgram");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_LinkProgram, cmd_size);
      cmd->program = program;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("LinkProgram");
   CALL_LinkProgram(ctx->CurrentServerDispatch, (program));
}


/* ProgramUniform4d: marshalled asynchronously */
struct marshal_cmd_ProgramUniform4d
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLdouble x;
   GLdouble y;
   GLdouble z;
   GLdouble w;
};
static inline void
_mesa_unmarshal_ProgramUniform4d(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform4d *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   const GLdouble w = cmd->w;
   CALL_ProgramUniform4d(ctx->CurrentServerDispatch, (program, location, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform4d(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform4d);
   struct marshal_cmd_ProgramUniform4d *cmd;
   debug_print_marshal("ProgramUniform4d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform4d, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform4d");
   CALL_ProgramUniform4d(ctx->CurrentServerDispatch, (program, location, x, y, z, w));
}


/* ProgramUniform4f: marshalled asynchronously */
struct marshal_cmd_ProgramUniform4f
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLfloat x;
   GLfloat y;
   GLfloat z;
   GLfloat w;
};
static inline void
_mesa_unmarshal_ProgramUniform4f(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform4f *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   const GLfloat w = cmd->w;
   CALL_ProgramUniform4f(ctx->CurrentServerDispatch, (program, location, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform4f(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform4f);
   struct marshal_cmd_ProgramUniform4f *cmd;
   debug_print_marshal("ProgramUniform4f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform4f, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform4f");
   CALL_ProgramUniform4f(ctx->CurrentServerDispatch, (program, location, x, y, z, w));
}


/* ProgramUniform4i: marshalled asynchronously */
struct marshal_cmd_ProgramUniform4i
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLint x;
   GLint y;
   GLint z;
   GLint w;
};
static inline void
_mesa_unmarshal_ProgramUniform4i(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform4i *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLint z = cmd->z;
   const GLint w = cmd->w;
   CALL_ProgramUniform4i(ctx->CurrentServerDispatch, (program, location, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform4i(GLuint program, GLint location, GLint x, GLint y, GLint z, GLint w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform4i);
   struct marshal_cmd_ProgramUniform4i *cmd;
   debug_print_marshal("ProgramUniform4i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform4i, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform4i");
   CALL_ProgramUniform4i(ctx->CurrentServerDispatch, (program, location, x, y, z, w));
}


/* GetFramebufferParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetFramebufferParameteriv(GLenum target, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetFramebufferParameteriv");
   CALL_GetFramebufferParameteriv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* GetNamedBufferPointerv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetNamedBufferPointerv(GLuint buffer, GLenum pname, GLvoid ** params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetNamedBufferPointerv");
   CALL_GetNamedBufferPointerv(ctx->CurrentServerDispatch, (buffer, pname, params));
}


/* VertexAttrib4d: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4d
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble x;
   GLdouble y;
   GLdouble z;
   GLdouble w;
};
static inline void
_mesa_unmarshal_VertexAttrib4d(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4d *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   const GLdouble w = cmd->w;
   CALL_VertexAttrib4d(ctx->CurrentServerDispatch, (index, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4d);
   struct marshal_cmd_VertexAttrib4d *cmd;
   debug_print_marshal("VertexAttrib4d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4d, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4d");
   CALL_VertexAttrib4d(ctx->CurrentServerDispatch, (index, x, y, z, w));
}


/* ProgramUniform4ui64vARB: marshalled asynchronously */
struct marshal_cmd_ProgramUniform4ui64vARB
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 32) bytes are GLuint64 value[count][4] */
};
static inline void
_mesa_unmarshal_ProgramUniform4ui64vARB(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform4ui64vARB *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLuint64 * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLuint64 *) variable_data;
   variable_data += count * 32;
   CALL_ProgramUniform4ui64vARB(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform4ui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform4ui64vARB) + safe_mul(count, 32);
   struct marshal_cmd_ProgramUniform4ui64vARB *cmd;
   debug_print_marshal("ProgramUniform4ui64vARB");
   if (unlikely(safe_mul(count, 32) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform4ui64vARB, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 32);
      variable_data += count * 32;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform4ui64vARB");
   CALL_ProgramUniform4ui64vARB(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* WindowPos4sMESA: marshalled asynchronously */
struct marshal_cmd_WindowPos4sMESA
{
   struct marshal_cmd_base cmd_base;
   GLshort x;
   GLshort y;
   GLshort z;
   GLshort w;
};
static inline void
_mesa_unmarshal_WindowPos4sMESA(struct gl_context *ctx, const struct marshal_cmd_WindowPos4sMESA *cmd)
{
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   const GLshort z = cmd->z;
   const GLshort w = cmd->w;
   CALL_WindowPos4sMESA(ctx->CurrentServerDispatch, (x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_WindowPos4sMESA(GLshort x, GLshort y, GLshort z, GLshort w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WindowPos4sMESA);
   struct marshal_cmd_WindowPos4sMESA *cmd;
   debug_print_marshal("WindowPos4sMESA");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WindowPos4sMESA, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WindowPos4sMESA");
   CALL_WindowPos4sMESA(ctx->CurrentServerDispatch, (x, y, z, w));
}


/* VertexAttrib4s: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4s
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort x;
   GLshort y;
   GLshort z;
   GLshort w;
};
static inline void
_mesa_unmarshal_VertexAttrib4s(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4s *cmd)
{
   const GLuint index = cmd->index;
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   const GLshort z = cmd->z;
   const GLshort w = cmd->w;
   CALL_VertexAttrib4s(ctx->CurrentServerDispatch, (index, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4s(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4s);
   struct marshal_cmd_VertexAttrib4s *cmd;
   debug_print_marshal("VertexAttrib4s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4s, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4s");
   CALL_VertexAttrib4s(ctx->CurrentServerDispatch, (index, x, y, z, w));
}


/* ProgramUniform1i64vARB: marshalled asynchronously */
struct marshal_cmd_ProgramUniform1i64vARB
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 8) bytes are GLint64 value[count] */
};
static inline void
_mesa_unmarshal_ProgramUniform1i64vARB(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform1i64vARB *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLint64 * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLint64 *) variable_data;
   variable_data += count * 8;
   CALL_ProgramUniform1i64vARB(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform1i64vARB(GLuint program, GLint location, GLsizei count, const GLint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform1i64vARB) + safe_mul(count, 8);
   struct marshal_cmd_ProgramUniform1i64vARB *cmd;
   debug_print_marshal("ProgramUniform1i64vARB");
   if (unlikely(safe_mul(count, 8) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform1i64vARB, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 8);
      variable_data += count * 8;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform1i64vARB");
   CALL_ProgramUniform1i64vARB(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* VertexAttrib1dvNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib1dvNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble v[1];
};
static inline void
_mesa_unmarshal_VertexAttrib1dvNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib1dvNV *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble * v = cmd->v;
   CALL_VertexAttrib1dvNV(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib1dvNV(GLuint index, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib1dvNV);
   struct marshal_cmd_VertexAttrib1dvNV *cmd;
   debug_print_marshal("VertexAttrib1dvNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib1dvNV, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib1dvNV");
   CALL_VertexAttrib1dvNV(ctx->CurrentServerDispatch, (index, v));
}


/* GetSemaphoreParameterui64vEXT: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetSemaphoreParameterui64vEXT(GLuint semaphore, GLenum pname, GLuint64 * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetSemaphoreParameterui64vEXT");
   CALL_GetSemaphoreParameterui64vEXT(ctx->CurrentServerDispatch, (semaphore, pname, params));
}


/* TexStorage3DMultisample: marshalled asynchronously */
struct marshal_cmd_TexStorage3DMultisample
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizei samples;
   GLenum internalformat;
   GLsizei width;
   GLsizei height;
   GLsizei depth;
   GLboolean fixedsamplelocations;
};
static inline void
_mesa_unmarshal_TexStorage3DMultisample(struct gl_context *ctx, const struct marshal_cmd_TexStorage3DMultisample *cmd)
{
   const GLenum target = cmd->target;
   const GLsizei samples = cmd->samples;
   const GLenum internalformat = cmd->internalformat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLsizei depth = cmd->depth;
   const GLboolean fixedsamplelocations = cmd->fixedsamplelocations;
   CALL_TexStorage3DMultisample(ctx->CurrentServerDispatch, (target, samples, internalformat, width, height, depth, fixedsamplelocations));
}
static void GLAPIENTRY
_mesa_marshal_TexStorage3DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexStorage3DMultisample);
   struct marshal_cmd_TexStorage3DMultisample *cmd;
   debug_print_marshal("TexStorage3DMultisample");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexStorage3DMultisample, cmd_size);
      cmd->target = target;
      cmd->samples = samples;
      cmd->internalformat = internalformat;
      cmd->width = width;
      cmd->height = height;
      cmd->depth = depth;
      cmd->fixedsamplelocations = fixedsamplelocations;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexStorage3DMultisample");
   CALL_TexStorage3DMultisample(ctx->CurrentServerDispatch, (target, samples, internalformat, width, height, depth, fixedsamplelocations));
}


/* SamplerParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_SamplerParameteriv(GLuint sampler, GLenum pname, const GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("SamplerParameteriv");
   CALL_SamplerParameteriv(ctx->CurrentServerDispatch, (sampler, pname, params));
}


/* VertexAttribP3uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribP3uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribP3uiv");
   CALL_VertexAttribP3uiv(ctx->CurrentServerDispatch, (index, type, normalized, value));
}


/* ScissorIndexedv: marshalled asynchronously */
struct marshal_cmd_ScissorIndexedv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLint v[4];
};
static inline void
_mesa_unmarshal_ScissorIndexedv(struct gl_context *ctx, const struct marshal_cmd_ScissorIndexedv *cmd)
{
   const GLuint index = cmd->index;
   const GLint * v = cmd->v;
   CALL_ScissorIndexedv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_ScissorIndexedv(GLuint index, const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ScissorIndexedv);
   struct marshal_cmd_ScissorIndexedv *cmd;
   debug_print_marshal("ScissorIndexedv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ScissorIndexedv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ScissorIndexedv");
   CALL_ScissorIndexedv(ctx->CurrentServerDispatch, (index, v));
}


/* GetStringi: marshalled synchronously */
static const GLubyte * GLAPIENTRY
_mesa_marshal_GetStringi(GLenum name, GLuint index)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetStringi");
   return CALL_GetStringi(ctx->CurrentServerDispatch, (name, index));
}


/* Uniform2dv: marshalled asynchronously */
struct marshal_cmd_Uniform2dv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 16) bytes are GLdouble value[count][2] */
};
static inline void
_mesa_unmarshal_Uniform2dv(struct gl_context *ctx, const struct marshal_cmd_Uniform2dv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 16;
   CALL_Uniform2dv(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform2dv(GLint location, GLsizei count, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform2dv) + safe_mul(count, 16);
   struct marshal_cmd_Uniform2dv *cmd;
   debug_print_marshal("Uniform2dv");
   if (unlikely(safe_mul(count, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform2dv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 16);
      variable_data += count * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform2dv");
   CALL_Uniform2dv(ctx->CurrentServerDispatch, (location, count, value));
}


/* VertexAttrib4dv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4dv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4dv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4dv *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble * v = cmd->v;
   CALL_VertexAttrib4dv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4dv(GLuint index, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4dv);
   struct marshal_cmd_VertexAttrib4dv *cmd;
   debug_print_marshal("VertexAttrib4dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4dv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 32);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4dv");
   CALL_VertexAttrib4dv(ctx->CurrentServerDispatch, (index, v));
}


/* CreateTextures: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CreateTextures(GLenum target, GLsizei n, GLuint * textures)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CreateTextures");
   CALL_CreateTextures(ctx->CurrentServerDispatch, (target, n, textures));
}


/* EvalCoord2dv: marshalled asynchronously */
struct marshal_cmd_EvalCoord2dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble u[2];
};
static inline void
_mesa_unmarshal_EvalCoord2dv(struct gl_context *ctx, const struct marshal_cmd_EvalCoord2dv *cmd)
{
   const GLdouble * u = cmd->u;
   CALL_EvalCoord2dv(ctx->CurrentServerDispatch, (u));
}
static void GLAPIENTRY
_mesa_marshal_EvalCoord2dv(const GLdouble * u)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_EvalCoord2dv);
   struct marshal_cmd_EvalCoord2dv *cmd;
   debug_print_marshal("EvalCoord2dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_EvalCoord2dv, cmd_size);
      memcpy(cmd->u, u, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("EvalCoord2dv");
   CALL_EvalCoord2dv(ctx->CurrentServerDispatch, (u));
}


/* VertexAttrib1fNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib1fNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat x;
};
static inline void
_mesa_unmarshal_VertexAttrib1fNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib1fNV *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat x = cmd->x;
   CALL_VertexAttrib1fNV(ctx->CurrentServerDispatch, (index, x));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib1fNV(GLuint index, GLfloat x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib1fNV);
   struct marshal_cmd_VertexAttrib1fNV *cmd;
   debug_print_marshal("VertexAttrib1fNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib1fNV, cmd_size);
      cmd->index = index;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib1fNV");
   CALL_VertexAttrib1fNV(ctx->CurrentServerDispatch, (index, x));
}


/* CompressedTexSubImage1D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CompressedTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CompressedTexSubImage1D");
   CALL_CompressedTexSubImage1D(ctx->CurrentServerDispatch, (target, level, xoffset, width, format, imageSize, data));
}


/* GetSeparableFilter: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetSeparableFilter(GLenum target, GLenum format, GLenum type, GLvoid * row, GLvoid * column, GLvoid * span)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetSeparableFilter");
   CALL_GetSeparableFilter(ctx->CurrentServerDispatch, (target, format, type, row, column, span));
}


/* FeedbackBuffer: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_FeedbackBuffer(GLsizei size, GLenum type, GLfloat * buffer)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("FeedbackBuffer");
   CALL_FeedbackBuffer(ctx->CurrentServerDispatch, (size, type, buffer));
}


/* RasterPos2iv: marshalled asynchronously */
struct marshal_cmd_RasterPos2iv
{
   struct marshal_cmd_base cmd_base;
   GLint v[2];
};
static inline void
_mesa_unmarshal_RasterPos2iv(struct gl_context *ctx, const struct marshal_cmd_RasterPos2iv *cmd)
{
   const GLint * v = cmd->v;
   CALL_RasterPos2iv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_RasterPos2iv(const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_RasterPos2iv);
   struct marshal_cmd_RasterPos2iv *cmd;
   debug_print_marshal("RasterPos2iv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_RasterPos2iv, cmd_size);
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("RasterPos2iv");
   CALL_RasterPos2iv(ctx->CurrentServerDispatch, (v));
}


/* TexImage1D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexImage1D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid * pixels)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexImage1D");
   CALL_TexImage1D(ctx->CurrentServerDispatch, (target, level, internalformat, width, border, format, type, pixels));
}


/* MultiDrawElementsEXT: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_MultiDrawElementsEXT(GLenum mode, const GLsizei * count, GLenum type, const GLvoid * const * indices, GLsizei primcount)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MultiDrawElementsEXT");
   CALL_MultiDrawElementsEXT(ctx->CurrentServerDispatch, (mode, count, type, indices, primcount));
}


/* GetnSeparableFilterARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnSeparableFilterARB(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, GLvoid * row, GLsizei columnBufSize, GLvoid * column, GLvoid * span)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnSeparableFilterARB");
   CALL_GetnSeparableFilterARB(ctx->CurrentServerDispatch, (target, format, type, rowBufSize, row, columnBufSize, column, span));
}


/* FrontFace: marshalled asynchronously */
struct marshal_cmd_FrontFace
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
};
static inline void
_mesa_unmarshal_FrontFace(struct gl_context *ctx, const struct marshal_cmd_FrontFace *cmd)
{
   const GLenum mode = cmd->mode;
   CALL_FrontFace(ctx->CurrentServerDispatch, (mode));
}
static void GLAPIENTRY
_mesa_marshal_FrontFace(GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_FrontFace);
   struct marshal_cmd_FrontFace *cmd;
   debug_print_marshal("FrontFace");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_FrontFace, cmd_size);
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("FrontFace");
   CALL_FrontFace(ctx->CurrentServerDispatch, (mode));
}


/* MultiModeDrawArraysIBM: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_MultiModeDrawArraysIBM(const GLenum * mode, const GLint * first, const GLsizei * count, GLsizei primcount, GLint modestride)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MultiModeDrawArraysIBM");
   CALL_MultiModeDrawArraysIBM(ctx->CurrentServerDispatch, (mode, first, count, primcount, modestride));
}


/* Normal3dv: marshalled asynchronously */
struct marshal_cmd_Normal3dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v[3];
};
static inline void
_mesa_unmarshal_Normal3dv(struct gl_context *ctx, const struct marshal_cmd_Normal3dv *cmd)
{
   const GLdouble * v = cmd->v;
   CALL_Normal3dv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Normal3dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Normal3dv);
   struct marshal_cmd_Normal3dv *cmd;
   debug_print_marshal("Normal3dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Normal3dv, cmd_size);
      memcpy(cmd->v, v, 24);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Normal3dv");
   CALL_Normal3dv(ctx->CurrentServerDispatch, (v));
}


/* Lightf: marshalled asynchronously */
struct marshal_cmd_Lightf
{
   struct marshal_cmd_base cmd_base;
   GLenum light;
   GLenum pname;
   GLfloat param;
};
static inline void
_mesa_unmarshal_Lightf(struct gl_context *ctx, const struct marshal_cmd_Lightf *cmd)
{
   const GLenum light = cmd->light;
   const GLenum pname = cmd->pname;
   const GLfloat param = cmd->param;
   CALL_Lightf(ctx->CurrentServerDispatch, (light, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_Lightf(GLenum light, GLenum pname, GLfloat param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Lightf);
   struct marshal_cmd_Lightf *cmd;
   debug_print_marshal("Lightf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Lightf, cmd_size);
      cmd->light = light;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Lightf");
   CALL_Lightf(ctx->CurrentServerDispatch, (light, pname, param));
}


/* MatrixMode: marshalled asynchronously */
struct marshal_cmd_MatrixMode
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
};
static inline void
_mesa_unmarshal_MatrixMode(struct gl_context *ctx, const struct marshal_cmd_MatrixMode *cmd)
{
   const GLenum mode = cmd->mode;
   CALL_MatrixMode(ctx->CurrentServerDispatch, (mode));
}
static void GLAPIENTRY
_mesa_marshal_MatrixMode(GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MatrixMode);
   struct marshal_cmd_MatrixMode *cmd;
   debug_print_marshal("MatrixMode");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MatrixMode, cmd_size);
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MatrixMode");
   CALL_MatrixMode(ctx->CurrentServerDispatch, (mode));
}


/* GetPixelMapusv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetPixelMapusv(GLenum map, GLushort * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetPixelMapusv");
   CALL_GetPixelMapusv(ctx->CurrentServerDispatch, (map, values));
}


/* Lighti: marshalled asynchronously */
struct marshal_cmd_Lighti
{
   struct marshal_cmd_base cmd_base;
   GLenum light;
   GLenum pname;
   GLint param;
};
static inline void
_mesa_unmarshal_Lighti(struct gl_context *ctx, const struct marshal_cmd_Lighti *cmd)
{
   const GLenum light = cmd->light;
   const GLenum pname = cmd->pname;
   const GLint param = cmd->param;
   CALL_Lighti(ctx->CurrentServerDispatch, (light, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_Lighti(GLenum light, GLenum pname, GLint param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Lighti);
   struct marshal_cmd_Lighti *cmd;
   debug_print_marshal("Lighti");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Lighti, cmd_size);
      cmd->light = light;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Lighti");
   CALL_Lighti(ctx->CurrentServerDispatch, (light, pname, param));
}


/* GetFragDataIndex: marshalled synchronously */
static GLint GLAPIENTRY
_mesa_marshal_GetFragDataIndex(GLuint program, const GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetFragDataIndex");
   return CALL_GetFragDataIndex(ctx->CurrentServerDispatch, (program, name));
}


/* Lightx: marshalled asynchronously */
struct marshal_cmd_Lightx
{
   struct marshal_cmd_base cmd_base;
   GLenum light;
   GLenum pname;
   GLfixed param;
};
static inline void
_mesa_unmarshal_Lightx(struct gl_context *ctx, const struct marshal_cmd_Lightx *cmd)
{
   const GLenum light = cmd->light;
   const GLenum pname = cmd->pname;
   const GLfixed param = cmd->param;
   CALL_Lightx(ctx->CurrentServerDispatch, (light, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_Lightx(GLenum light, GLenum pname, GLfixed param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Lightx);
   struct marshal_cmd_Lightx *cmd;
   debug_print_marshal("Lightx");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Lightx, cmd_size);
      cmd->light = light;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Lightx");
   CALL_Lightx(ctx->CurrentServerDispatch, (light, pname, param));
}


/* ProgramUniform3fv: marshalled asynchronously */
struct marshal_cmd_ProgramUniform3fv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 12) bytes are GLfloat value[count][3] */
};
static inline void
_mesa_unmarshal_ProgramUniform3fv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform3fv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 12;
   CALL_ProgramUniform3fv(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform3fv(GLuint program, GLint location, GLsizei count, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform3fv) + safe_mul(count, 12);
   struct marshal_cmd_ProgramUniform3fv *cmd;
   debug_print_marshal("ProgramUniform3fv");
   if (unlikely(safe_mul(count, 12) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform3fv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 12);
      variable_data += count * 12;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform3fv");
   CALL_ProgramUniform3fv(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* MultMatrixd: marshalled asynchronously */
struct marshal_cmd_MultMatrixd
{
   struct marshal_cmd_base cmd_base;
   GLdouble m[16];
};
static inline void
_mesa_unmarshal_MultMatrixd(struct gl_context *ctx, const struct marshal_cmd_MultMatrixd *cmd)
{
   const GLdouble * m = cmd->m;
   CALL_MultMatrixd(ctx->CurrentServerDispatch, (m));
}
static void GLAPIENTRY
_mesa_marshal_MultMatrixd(const GLdouble * m)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultMatrixd);
   struct marshal_cmd_MultMatrixd *cmd;
   debug_print_marshal("MultMatrixd");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultMatrixd, cmd_size);
      memcpy(cmd->m, m, 128);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultMatrixd");
   CALL_MultMatrixd(ctx->CurrentServerDispatch, (m));
}


/* MultMatrixf: marshalled asynchronously */
struct marshal_cmd_MultMatrixf
{
   struct marshal_cmd_base cmd_base;
   GLfloat m[16];
};
static inline void
_mesa_unmarshal_MultMatrixf(struct gl_context *ctx, const struct marshal_cmd_MultMatrixf *cmd)
{
   const GLfloat * m = cmd->m;
   CALL_MultMatrixf(ctx->CurrentServerDispatch, (m));
}
static void GLAPIENTRY
_mesa_marshal_MultMatrixf(const GLfloat * m)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultMatrixf);
   struct marshal_cmd_MultMatrixf *cmd;
   debug_print_marshal("MultMatrixf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultMatrixf, cmd_size);
      memcpy(cmd->m, m, 64);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultMatrixf");
   CALL_MultMatrixf(ctx->CurrentServerDispatch, (m));
}


/* Uniform4ui64vARB: marshalled asynchronously */
struct marshal_cmd_Uniform4ui64vARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 32) bytes are GLuint64 value[count][4] */
};
static inline void
_mesa_unmarshal_Uniform4ui64vARB(struct gl_context *ctx, const struct marshal_cmd_Uniform4ui64vARB *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLuint64 * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLuint64 *) variable_data;
   variable_data += count * 32;
   CALL_Uniform4ui64vARB(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform4ui64vARB(GLint location, GLsizei count, const GLuint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform4ui64vARB) + safe_mul(count, 32);
   struct marshal_cmd_Uniform4ui64vARB *cmd;
   debug_print_marshal("Uniform4ui64vARB");
   if (unlikely(safe_mul(count, 32) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform4ui64vARB, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 32);
      variable_data += count * 32;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform4ui64vARB");
   CALL_Uniform4ui64vARB(ctx->CurrentServerDispatch, (location, count, value));
}


/* MultiTexCoord4fvARB: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord4fvARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLfloat v[4];
};
static inline void
_mesa_unmarshal_MultiTexCoord4fvARB(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord4fvARB *cmd)
{
   const GLenum target = cmd->target;
   const GLfloat * v = cmd->v;
   CALL_MultiTexCoord4fvARB(ctx->CurrentServerDispatch, (target, v));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord4fvARB(GLenum target, const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord4fvARB);
   struct marshal_cmd_MultiTexCoord4fvARB *cmd;
   debug_print_marshal("MultiTexCoord4fvARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord4fvARB, cmd_size);
      cmd->target = target;
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord4fvARB");
   CALL_MultiTexCoord4fvARB(ctx->CurrentServerDispatch, (target, v));
}


/* UniformMatrix2x3fv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix2x3fv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 24) bytes are GLfloat value[count][6] */
};
static inline void
_mesa_unmarshal_UniformMatrix2x3fv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix2x3fv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 24;
   CALL_UniformMatrix2x3fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix2x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix2x3fv) + safe_mul(count, 24);
   struct marshal_cmd_UniformMatrix2x3fv *cmd;
   debug_print_marshal("UniformMatrix2x3fv");
   if (unlikely(safe_mul(count, 24) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix2x3fv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 24);
      variable_data += count * 24;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix2x3fv");
   CALL_UniformMatrix2x3fv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* SamplerParameterf: marshalled asynchronously */
struct marshal_cmd_SamplerParameterf
{
   struct marshal_cmd_base cmd_base;
   GLuint sampler;
   GLenum pname;
   GLfloat param;
};
static inline void
_mesa_unmarshal_SamplerParameterf(struct gl_context *ctx, const struct marshal_cmd_SamplerParameterf *cmd)
{
   const GLuint sampler = cmd->sampler;
   const GLenum pname = cmd->pname;
   const GLfloat param = cmd->param;
   CALL_SamplerParameterf(ctx->CurrentServerDispatch, (sampler, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_SamplerParameterf(GLuint sampler, GLenum pname, GLfloat param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SamplerParameterf);
   struct marshal_cmd_SamplerParameterf *cmd;
   debug_print_marshal("SamplerParameterf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SamplerParameterf, cmd_size);
      cmd->sampler = sampler;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SamplerParameterf");
   CALL_SamplerParameterf(ctx->CurrentServerDispatch, (sampler, pname, param));
}


/* UniformMatrix3dv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix3dv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 72) bytes are GLdouble value[count][9] */
};
static inline void
_mesa_unmarshal_UniformMatrix3dv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix3dv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 72;
   CALL_UniformMatrix3dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix3dv) + safe_mul(count, 72);
   struct marshal_cmd_UniformMatrix3dv *cmd;
   debug_print_marshal("UniformMatrix3dv");
   if (unlikely(safe_mul(count, 72) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix3dv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 72);
      variable_data += count * 72;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix3dv");
   CALL_UniformMatrix3dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* PointParameterx: marshalled asynchronously */
struct marshal_cmd_PointParameterx
{
   struct marshal_cmd_base cmd_base;
   GLenum pname;
   GLfixed param;
};
static inline void
_mesa_unmarshal_PointParameterx(struct gl_context *ctx, const struct marshal_cmd_PointParameterx *cmd)
{
   const GLenum pname = cmd->pname;
   const GLfixed param = cmd->param;
   CALL_PointParameterx(ctx->CurrentServerDispatch, (pname, param));
}
static void GLAPIENTRY
_mesa_marshal_PointParameterx(GLenum pname, GLfixed param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PointParameterx);
   struct marshal_cmd_PointParameterx *cmd;
   debug_print_marshal("PointParameterx");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PointParameterx, cmd_size);
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PointParameterx");
   CALL_PointParameterx(ctx->CurrentServerDispatch, (pname, param));
}


/* DrawArrays: marshalled asynchronously */
struct marshal_cmd_DrawArrays
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
   GLint first;
   GLsizei count;
};
static inline void
_mesa_unmarshal_DrawArrays(struct gl_context *ctx, const struct marshal_cmd_DrawArrays *cmd)
{
   const GLenum mode = cmd->mode;
   const GLint first = cmd->first;
   const GLsizei count = cmd->count;
   CALL_DrawArrays(ctx->CurrentServerDispatch, (mode, first, count));
}
static void GLAPIENTRY
_mesa_marshal_DrawArrays(GLenum mode, GLint first, GLsizei count)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawArrays);
   struct marshal_cmd_DrawArrays *cmd;
   debug_print_marshal("DrawArrays");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawArrays, cmd_size);
      cmd->mode = mode;
      cmd->first = first;
      cmd->count = count;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawArrays");
   CALL_DrawArrays(ctx->CurrentServerDispatch, (mode, first, count));
}


/* Uniform3dv: marshalled asynchronously */
struct marshal_cmd_Uniform3dv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 24) bytes are GLdouble value[count][3] */
};
static inline void
_mesa_unmarshal_Uniform3dv(struct gl_context *ctx, const struct marshal_cmd_Uniform3dv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 24;
   CALL_Uniform3dv(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform3dv(GLint location, GLsizei count, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform3dv) + safe_mul(count, 24);
   struct marshal_cmd_Uniform3dv *cmd;
   debug_print_marshal("Uniform3dv");
   if (unlikely(safe_mul(count, 24) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform3dv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 24);
      variable_data += count * 24;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform3dv");
   CALL_Uniform3dv(ctx->CurrentServerDispatch, (location, count, value));
}


/* PointParameteri: marshalled asynchronously */
struct marshal_cmd_PointParameteri
{
   struct marshal_cmd_base cmd_base;
   GLenum pname;
   GLint param;
};
static inline void
_mesa_unmarshal_PointParameteri(struct gl_context *ctx, const struct marshal_cmd_PointParameteri *cmd)
{
   const GLenum pname = cmd->pname;
   const GLint param = cmd->param;
   CALL_PointParameteri(ctx->CurrentServerDispatch, (pname, param));
}
static void GLAPIENTRY
_mesa_marshal_PointParameteri(GLenum pname, GLint param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PointParameteri);
   struct marshal_cmd_PointParameteri *cmd;
   debug_print_marshal("PointParameteri");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PointParameteri, cmd_size);
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PointParameteri");
   CALL_PointParameteri(ctx->CurrentServerDispatch, (pname, param));
}


/* PointParameterf: marshalled asynchronously */
struct marshal_cmd_PointParameterf
{
   struct marshal_cmd_base cmd_base;
   GLenum pname;
   GLfloat param;
};
static inline void
_mesa_unmarshal_PointParameterf(struct gl_context *ctx, const struct marshal_cmd_PointParameterf *cmd)
{
   const GLenum pname = cmd->pname;
   const GLfloat param = cmd->param;
   CALL_PointParameterf(ctx->CurrentServerDispatch, (pname, param));
}
static void GLAPIENTRY
_mesa_marshal_PointParameterf(GLenum pname, GLfloat param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PointParameterf);
   struct marshal_cmd_PointParameterf *cmd;
   debug_print_marshal("PointParameterf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PointParameterf, cmd_size);
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PointParameterf");
   CALL_PointParameterf(ctx->CurrentServerDispatch, (pname, param));
}


/* VertexAttribBinding: marshalled asynchronously */
struct marshal_cmd_VertexAttribBinding
{
   struct marshal_cmd_base cmd_base;
   GLuint attribindex;
   GLuint bindingindex;
};
static inline void
_mesa_unmarshal_VertexAttribBinding(struct gl_context *ctx, const struct marshal_cmd_VertexAttribBinding *cmd)
{
   const GLuint attribindex = cmd->attribindex;
   const GLuint bindingindex = cmd->bindingindex;
   CALL_VertexAttribBinding(ctx->CurrentServerDispatch, (attribindex, bindingindex));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribBinding(GLuint attribindex, GLuint bindingindex)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribBinding);
   struct marshal_cmd_VertexAttribBinding *cmd;
   debug_print_marshal("VertexAttribBinding");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribBinding, cmd_size);
      cmd->attribindex = attribindex;
      cmd->bindingindex = bindingindex;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribBinding");
   CALL_VertexAttribBinding(ctx->CurrentServerDispatch, (attribindex, bindingindex));
}


/* TextureSubImage2D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TextureSubImage2D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TextureSubImage2D");
   CALL_TextureSubImage2D(ctx->CurrentServerDispatch, (texture, level, xoffset, yoffset, width, height, format, type, pixels));
}


/* CreateShader: marshalled synchronously */
static GLuint GLAPIENTRY
_mesa_marshal_CreateShader(GLenum type)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CreateShader");
   return CALL_CreateShader(ctx->CurrentServerDispatch, (type));
}


/* ProgramUniform1dv: marshalled asynchronously */
struct marshal_cmd_ProgramUniform1dv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 8) bytes are GLdouble value[count] */
};
static inline void
_mesa_unmarshal_ProgramUniform1dv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform1dv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 8;
   CALL_ProgramUniform1dv(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform1dv(GLuint program, GLint location, GLsizei count, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform1dv) + safe_mul(count, 8);
   struct marshal_cmd_ProgramUniform1dv *cmd;
   debug_print_marshal("ProgramUniform1dv");
   if (unlikely(safe_mul(count, 8) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform1dv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 8);
      variable_data += count * 8;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform1dv");
   CALL_ProgramUniform1dv(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* GetProgramEnvParameterfvARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetProgramEnvParameterfvARB(GLenum target, GLuint index, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramEnvParameterfvARB");
   CALL_GetProgramEnvParameterfvARB(ctx->CurrentServerDispatch, (target, index, params));
}


/* DeleteBuffers: marshalled asynchronously */
struct marshal_cmd_DeleteBuffers
{
   struct marshal_cmd_base cmd_base;
   GLsizei n;
   /* Next safe_mul(n, 4) bytes are GLuint buffer[n] */
};
static inline void
_mesa_unmarshal_DeleteBuffers(struct gl_context *ctx, const struct marshal_cmd_DeleteBuffers *cmd)
{
   const GLsizei n = cmd->n;
   const GLuint * buffer;
   const char *variable_data = (const char *) (cmd + 1);
   buffer = (const GLuint *) variable_data;
   variable_data += n * 4;
   CALL_DeleteBuffers(ctx->CurrentServerDispatch, (n, buffer));
}
static void GLAPIENTRY
_mesa_marshal_DeleteBuffers(GLsizei n, const GLuint * buffer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DeleteBuffers) + safe_mul(n, 4);
   struct marshal_cmd_DeleteBuffers *cmd;
   debug_print_marshal("DeleteBuffers");
   if (unlikely(safe_mul(n, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DeleteBuffers, cmd_size);
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, buffer, n * 4);
      variable_data += n * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DeleteBuffers");
   CALL_DeleteBuffers(ctx->CurrentServerDispatch, (n, buffer));
}


/* GetBufferSubData: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetBufferSubData");
   CALL_GetBufferSubData(ctx->CurrentServerDispatch, (target, offset, size, data));
}


/* GetNamedRenderbufferParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetNamedRenderbufferParameteriv(GLuint renderbuffer, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetNamedRenderbufferParameteriv");
   CALL_GetNamedRenderbufferParameteriv(ctx->CurrentServerDispatch, (renderbuffer, pname, params));
}


/* GetPerfMonitorGroupsAMD: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetPerfMonitorGroupsAMD(GLint * numGroups, GLsizei groupsSize, GLuint * groups)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetPerfMonitorGroupsAMD");
   CALL_GetPerfMonitorGroupsAMD(ctx->CurrentServerDispatch, (numGroups, groupsSize, groups));
}


/* VertexAttribP2ui: marshalled asynchronously */
struct marshal_cmd_VertexAttribP2ui
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLenum type;
   GLboolean normalized;
   GLuint value;
};
static inline void
_mesa_unmarshal_VertexAttribP2ui(struct gl_context *ctx, const struct marshal_cmd_VertexAttribP2ui *cmd)
{
   const GLuint index = cmd->index;
   const GLenum type = cmd->type;
   const GLboolean normalized = cmd->normalized;
   const GLuint value = cmd->value;
   CALL_VertexAttribP2ui(ctx->CurrentServerDispatch, (index, type, normalized, value));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribP2ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribP2ui);
   struct marshal_cmd_VertexAttribP2ui *cmd;
   debug_print_marshal("VertexAttribP2ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribP2ui, cmd_size);
      cmd->index = index;
      cmd->type = type;
      cmd->normalized = normalized;
      cmd->value = value;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribP2ui");
   CALL_VertexAttribP2ui(ctx->CurrentServerDispatch, (index, type, normalized, value));
}


/* ProgramUniform4dv: marshalled asynchronously */
struct marshal_cmd_ProgramUniform4dv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 32) bytes are GLdouble value[count][4] */
};
static inline void
_mesa_unmarshal_ProgramUniform4dv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform4dv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 32;
   CALL_ProgramUniform4dv(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform4dv(GLuint program, GLint location, GLsizei count, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform4dv) + safe_mul(count, 32);
   struct marshal_cmd_ProgramUniform4dv *cmd;
   debug_print_marshal("ProgramUniform4dv");
   if (unlikely(safe_mul(count, 32) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform4dv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 32);
      variable_data += count * 32;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform4dv");
   CALL_ProgramUniform4dv(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* GetMinmaxParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetMinmaxParameteriv(GLenum target, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetMinmaxParameteriv");
   CALL_GetMinmaxParameteriv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* DrawTexivOES: marshalled asynchronously */
struct marshal_cmd_DrawTexivOES
{
   struct marshal_cmd_base cmd_base;
   GLint coords[5];
};
static inline void
_mesa_unmarshal_DrawTexivOES(struct gl_context *ctx, const struct marshal_cmd_DrawTexivOES *cmd)
{
   const GLint * coords = cmd->coords;
   CALL_DrawTexivOES(ctx->CurrentServerDispatch, (coords));
}
static void GLAPIENTRY
_mesa_marshal_DrawTexivOES(const GLint * coords)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawTexivOES);
   struct marshal_cmd_DrawTexivOES *cmd;
   debug_print_marshal("DrawTexivOES");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawTexivOES, cmd_size);
      memcpy(cmd->coords, coords, 20);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawTexivOES");
   CALL_DrawTexivOES(ctx->CurrentServerDispatch, (coords));
}


/* CopyTexImage1D: marshalled asynchronously */
struct marshal_cmd_CopyTexImage1D
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLint level;
   GLenum internalformat;
   GLint x;
   GLint y;
   GLsizei width;
   GLint border;
};
static inline void
_mesa_unmarshal_CopyTexImage1D(struct gl_context *ctx, const struct marshal_cmd_CopyTexImage1D *cmd)
{
   const GLenum target = cmd->target;
   const GLint level = cmd->level;
   const GLenum internalformat = cmd->internalformat;
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLsizei width = cmd->width;
   const GLint border = cmd->border;
   CALL_CopyTexImage1D(ctx->CurrentServerDispatch, (target, level, internalformat, x, y, width, border));
}
static void GLAPIENTRY
_mesa_marshal_CopyTexImage1D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_CopyTexImage1D);
   struct marshal_cmd_CopyTexImage1D *cmd;
   debug_print_marshal("CopyTexImage1D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_CopyTexImage1D, cmd_size);
      cmd->target = target;
      cmd->level = level;
      cmd->internalformat = internalformat;
      cmd->x = x;
      cmd->y = y;
      cmd->width = width;
      cmd->border = border;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("CopyTexImage1D");
   CALL_CopyTexImage1D(ctx->CurrentServerDispatch, (target, level, internalformat, x, y, width, border));
}


/* InvalidateNamedFramebufferData: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_InvalidateNamedFramebufferData(GLuint framebuffer, GLsizei numAttachments, const GLenum * attachments)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("InvalidateNamedFramebufferData");
   CALL_InvalidateNamedFramebufferData(ctx->CurrentServerDispatch, (framebuffer, numAttachments, attachments));
}


/* SemaphoreParameterui64vEXT: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_SemaphoreParameterui64vEXT(GLuint semaphore, GLenum pname, const GLuint64 * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("SemaphoreParameterui64vEXT");
   CALL_SemaphoreParameterui64vEXT(ctx->CurrentServerDispatch, (semaphore, pname, params));
}


/* GetnColorTableARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnColorTableARB(GLenum target, GLenum format, GLenum type, GLsizei bufSize, GLvoid * table)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnColorTableARB");
   CALL_GetnColorTableARB(ctx->CurrentServerDispatch, (target, format, type, bufSize, table));
}


/* VertexAttribFormat: marshalled asynchronously */
struct marshal_cmd_VertexAttribFormat
{
   struct marshal_cmd_base cmd_base;
   GLuint attribindex;
   GLint size;
   GLenum type;
   GLboolean normalized;
   GLuint relativeoffset;
};
static inline void
_mesa_unmarshal_VertexAttribFormat(struct gl_context *ctx, const struct marshal_cmd_VertexAttribFormat *cmd)
{
   const GLuint attribindex = cmd->attribindex;
   const GLint size = cmd->size;
   const GLenum type = cmd->type;
   const GLboolean normalized = cmd->normalized;
   const GLuint relativeoffset = cmd->relativeoffset;
   CALL_VertexAttribFormat(ctx->CurrentServerDispatch, (attribindex, size, type, normalized, relativeoffset));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribFormat(GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribFormat);
   struct marshal_cmd_VertexAttribFormat *cmd;
   debug_print_marshal("VertexAttribFormat");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribFormat, cmd_size);
      cmd->attribindex = attribindex;
      cmd->size = size;
      cmd->type = type;
      cmd->normalized = normalized;
      cmd->relativeoffset = relativeoffset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribFormat");
   CALL_VertexAttribFormat(ctx->CurrentServerDispatch, (attribindex, size, type, normalized, relativeoffset));
}


/* Vertex3i: marshalled asynchronously */
struct marshal_cmd_Vertex3i
{
   struct marshal_cmd_base cmd_base;
   GLint x;
   GLint y;
   GLint z;
};
static inline void
_mesa_unmarshal_Vertex3i(struct gl_context *ctx, const struct marshal_cmd_Vertex3i *cmd)
{
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLint z = cmd->z;
   CALL_Vertex3i(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Vertex3i(GLint x, GLint y, GLint z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex3i);
   struct marshal_cmd_Vertex3i *cmd;
   debug_print_marshal("Vertex3i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex3i, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex3i");
   CALL_Vertex3i(ctx->CurrentServerDispatch, (x, y, z));
}


/* Vertex3f: marshalled asynchronously */
struct marshal_cmd_Vertex3f
{
   struct marshal_cmd_base cmd_base;
   GLfloat x;
   GLfloat y;
   GLfloat z;
};
static inline void
_mesa_unmarshal_Vertex3f(struct gl_context *ctx, const struct marshal_cmd_Vertex3f *cmd)
{
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   CALL_Vertex3f(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Vertex3f(GLfloat x, GLfloat y, GLfloat z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex3f);
   struct marshal_cmd_Vertex3f *cmd;
   debug_print_marshal("Vertex3f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex3f, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex3f");
   CALL_Vertex3f(ctx->CurrentServerDispatch, (x, y, z));
}


/* Vertex3d: marshalled asynchronously */
struct marshal_cmd_Vertex3d
{
   struct marshal_cmd_base cmd_base;
   GLdouble x;
   GLdouble y;
   GLdouble z;
};
static inline void
_mesa_unmarshal_Vertex3d(struct gl_context *ctx, const struct marshal_cmd_Vertex3d *cmd)
{
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   CALL_Vertex3d(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Vertex3d(GLdouble x, GLdouble y, GLdouble z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex3d);
   struct marshal_cmd_Vertex3d *cmd;
   debug_print_marshal("Vertex3d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex3d, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex3d");
   CALL_Vertex3d(ctx->CurrentServerDispatch, (x, y, z));
}


/* GetProgramPipelineiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetProgramPipelineiv(GLuint pipeline, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramPipelineiv");
   CALL_GetProgramPipelineiv(ctx->CurrentServerDispatch, (pipeline, pname, params));
}


/* ReadBuffer: marshalled asynchronously */
struct marshal_cmd_ReadBuffer
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
};
static inline void
_mesa_unmarshal_ReadBuffer(struct gl_context *ctx, const struct marshal_cmd_ReadBuffer *cmd)
{
   const GLenum mode = cmd->mode;
   CALL_ReadBuffer(ctx->CurrentServerDispatch, (mode));
}
static void GLAPIENTRY
_mesa_marshal_ReadBuffer(GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ReadBuffer);
   struct marshal_cmd_ReadBuffer *cmd;
   debug_print_marshal("ReadBuffer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ReadBuffer, cmd_size);
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ReadBuffer");
   CALL_ReadBuffer(ctx->CurrentServerDispatch, (mode));
}


/* ConvolutionParameteri: marshalled asynchronously */
struct marshal_cmd_ConvolutionParameteri
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum pname;
   GLint params;
};
static inline void
_mesa_unmarshal_ConvolutionParameteri(struct gl_context *ctx, const struct marshal_cmd_ConvolutionParameteri *cmd)
{
   const GLenum target = cmd->target;
   const GLenum pname = cmd->pname;
   const GLint params = cmd->params;
   CALL_ConvolutionParameteri(ctx->CurrentServerDispatch, (target, pname, params));
}
static void GLAPIENTRY
_mesa_marshal_ConvolutionParameteri(GLenum target, GLenum pname, GLint params)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ConvolutionParameteri);
   struct marshal_cmd_ConvolutionParameteri *cmd;
   debug_print_marshal("ConvolutionParameteri");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ConvolutionParameteri, cmd_size);
      cmd->target = target;
      cmd->pname = pname;
      cmd->params = params;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ConvolutionParameteri");
   CALL_ConvolutionParameteri(ctx->CurrentServerDispatch, (target, pname, params));
}


/* GetTexParameterIiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTexParameterIiv(GLenum target, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTexParameterIiv");
   CALL_GetTexParameterIiv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* Vertex3s: marshalled asynchronously */
struct marshal_cmd_Vertex3s
{
   struct marshal_cmd_base cmd_base;
   GLshort x;
   GLshort y;
   GLshort z;
};
static inline void
_mesa_unmarshal_Vertex3s(struct gl_context *ctx, const struct marshal_cmd_Vertex3s *cmd)
{
   const GLshort x = cmd->x;
   const GLshort y = cmd->y;
   const GLshort z = cmd->z;
   CALL_Vertex3s(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Vertex3s(GLshort x, GLshort y, GLshort z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex3s);
   struct marshal_cmd_Vertex3s *cmd;
   debug_print_marshal("Vertex3s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex3s, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex3s");
   CALL_Vertex3s(ctx->CurrentServerDispatch, (x, y, z));
}


/* ConvolutionParameterf: marshalled asynchronously */
struct marshal_cmd_ConvolutionParameterf
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum pname;
   GLfloat params;
};
static inline void
_mesa_unmarshal_ConvolutionParameterf(struct gl_context *ctx, const struct marshal_cmd_ConvolutionParameterf *cmd)
{
   const GLenum target = cmd->target;
   const GLenum pname = cmd->pname;
   const GLfloat params = cmd->params;
   CALL_ConvolutionParameterf(ctx->CurrentServerDispatch, (target, pname, params));
}
static void GLAPIENTRY
_mesa_marshal_ConvolutionParameterf(GLenum target, GLenum pname, GLfloat params)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ConvolutionParameterf);
   struct marshal_cmd_ConvolutionParameterf *cmd;
   debug_print_marshal("ConvolutionParameterf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ConvolutionParameterf, cmd_size);
      cmd->target = target;
      cmd->pname = pname;
      cmd->params = params;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ConvolutionParameterf");
   CALL_ConvolutionParameterf(ctx->CurrentServerDispatch, (target, pname, params));
}


/* GetColorTableParameteriv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetColorTableParameteriv(GLenum target, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetColorTableParameteriv");
   CALL_GetColorTableParameteriv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* GetTransformFeedbackVarying: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTransformFeedbackVarying(GLuint program, GLuint index, GLsizei bufSize, GLsizei * length, GLsizei * size, GLenum * type, GLchar * name)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTransformFeedbackVarying");
   CALL_GetTransformFeedbackVarying(ctx->CurrentServerDispatch, (program, index, bufSize, length, size, type, name));
}


/* GetNextPerfQueryIdINTEL: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetNextPerfQueryIdINTEL(GLuint queryId, GLuint * nextQueryId)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetNextPerfQueryIdINTEL");
   CALL_GetNextPerfQueryIdINTEL(ctx->CurrentServerDispatch, (queryId, nextQueryId));
}


/* TexCoord3fv: marshalled asynchronously */
struct marshal_cmd_TexCoord3fv
{
   struct marshal_cmd_base cmd_base;
   GLfloat v[3];
};
static inline void
_mesa_unmarshal_TexCoord3fv(struct gl_context *ctx, const struct marshal_cmd_TexCoord3fv *cmd)
{
   const GLfloat * v = cmd->v;
   CALL_TexCoord3fv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord3fv(const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord3fv);
   struct marshal_cmd_TexCoord3fv *cmd;
   debug_print_marshal("TexCoord3fv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord3fv, cmd_size);
      memcpy(cmd->v, v, 12);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord3fv");
   CALL_TexCoord3fv(ctx->CurrentServerDispatch, (v));
}


/* TextureBarrierNV: marshalled asynchronously */
struct marshal_cmd_TextureBarrierNV
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_TextureBarrierNV(struct gl_context *ctx, const struct marshal_cmd_TextureBarrierNV *cmd)
{
   CALL_TextureBarrierNV(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_TextureBarrierNV(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureBarrierNV);
   struct marshal_cmd_TextureBarrierNV *cmd;
   debug_print_marshal("TextureBarrierNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureBarrierNV, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureBarrierNV");
   CALL_TextureBarrierNV(ctx->CurrentServerDispatch, ());
}


/* GetProgramInterfaceiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetProgramInterfaceiv(GLuint program, GLenum programInterface, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramInterfaceiv");
   CALL_GetProgramInterfaceiv(ctx->CurrentServerDispatch, (program, programInterface, pname, params));
}


/* VertexAttribL1ui64vARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_VertexAttribL1ui64vARB(GLuint index, const GLuint64EXT * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("VertexAttribL1ui64vARB");
   CALL_VertexAttribL1ui64vARB(ctx->CurrentServerDispatch, (index, v));
}


/* ProgramLocalParameter4fARB: marshalled asynchronously */
struct marshal_cmd_ProgramLocalParameter4fARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLuint index;
   GLfloat x;
   GLfloat y;
   GLfloat z;
   GLfloat w;
};
static inline void
_mesa_unmarshal_ProgramLocalParameter4fARB(struct gl_context *ctx, const struct marshal_cmd_ProgramLocalParameter4fARB *cmd)
{
   const GLenum target = cmd->target;
   const GLuint index = cmd->index;
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   const GLfloat w = cmd->w;
   CALL_ProgramLocalParameter4fARB(ctx->CurrentServerDispatch, (target, index, x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_ProgramLocalParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramLocalParameter4fARB);
   struct marshal_cmd_ProgramLocalParameter4fARB *cmd;
   debug_print_marshal("ProgramLocalParameter4fARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramLocalParameter4fARB, cmd_size);
      cmd->target = target;
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramLocalParameter4fARB");
   CALL_ProgramLocalParameter4fARB(ctx->CurrentServerDispatch, (target, index, x, y, z, w));
}


/* PauseTransformFeedback: marshalled asynchronously */
struct marshal_cmd_PauseTransformFeedback
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_PauseTransformFeedback(struct gl_context *ctx, const struct marshal_cmd_PauseTransformFeedback *cmd)
{
   CALL_PauseTransformFeedback(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_PauseTransformFeedback(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PauseTransformFeedback);
   struct marshal_cmd_PauseTransformFeedback *cmd;
   debug_print_marshal("PauseTransformFeedback");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PauseTransformFeedback, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PauseTransformFeedback");
   CALL_PauseTransformFeedback(ctx->CurrentServerDispatch, ());
}


/* DeleteShader: marshalled asynchronously */
struct marshal_cmd_DeleteShader
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
};
static inline void
_mesa_unmarshal_DeleteShader(struct gl_context *ctx, const struct marshal_cmd_DeleteShader *cmd)
{
   const GLuint program = cmd->program;
   CALL_DeleteShader(ctx->CurrentServerDispatch, (program));
}
static void GLAPIENTRY
_mesa_marshal_DeleteShader(GLuint program)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DeleteShader);
   struct marshal_cmd_DeleteShader *cmd;
   debug_print_marshal("DeleteShader");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DeleteShader, cmd_size);
      cmd->program = program;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DeleteShader");
   CALL_DeleteShader(ctx->CurrentServerDispatch, (program));
}


/* NamedFramebufferRenderbuffer: marshalled asynchronously */
struct marshal_cmd_NamedFramebufferRenderbuffer
{
   struct marshal_cmd_base cmd_base;
   GLuint framebuffer;
   GLenum attachment;
   GLenum renderbuffertarget;
   GLuint renderbuffer;
};
static inline void
_mesa_unmarshal_NamedFramebufferRenderbuffer(struct gl_context *ctx, const struct marshal_cmd_NamedFramebufferRenderbuffer *cmd)
{
   const GLuint framebuffer = cmd->framebuffer;
   const GLenum attachment = cmd->attachment;
   const GLenum renderbuffertarget = cmd->renderbuffertarget;
   const GLuint renderbuffer = cmd->renderbuffer;
   CALL_NamedFramebufferRenderbuffer(ctx->CurrentServerDispatch, (framebuffer, attachment, renderbuffertarget, renderbuffer));
}
static void GLAPIENTRY
_mesa_marshal_NamedFramebufferRenderbuffer(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_NamedFramebufferRenderbuffer);
   struct marshal_cmd_NamedFramebufferRenderbuffer *cmd;
   debug_print_marshal("NamedFramebufferRenderbuffer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_NamedFramebufferRenderbuffer, cmd_size);
      cmd->framebuffer = framebuffer;
      cmd->attachment = attachment;
      cmd->renderbuffertarget = renderbuffertarget;
      cmd->renderbuffer = renderbuffer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("NamedFramebufferRenderbuffer");
   CALL_NamedFramebufferRenderbuffer(ctx->CurrentServerDispatch, (framebuffer, attachment, renderbuffertarget, renderbuffer));
}


/* CompileShader: marshalled asynchronously */
struct marshal_cmd_CompileShader
{
   struct marshal_cmd_base cmd_base;
   GLuint shader;
};
static inline void
_mesa_unmarshal_CompileShader(struct gl_context *ctx, const struct marshal_cmd_CompileShader *cmd)
{
   const GLuint shader = cmd->shader;
   CALL_CompileShader(ctx->CurrentServerDispatch, (shader));
}
static void GLAPIENTRY
_mesa_marshal_CompileShader(GLuint shader)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_CompileShader);
   struct marshal_cmd_CompileShader *cmd;
   debug_print_marshal("CompileShader");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_CompileShader, cmd_size);
      cmd->shader = shader;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("CompileShader");
   CALL_CompileShader(ctx->CurrentServerDispatch, (shader));
}


/* Vertex2iv: marshalled asynchronously */
struct marshal_cmd_Vertex2iv
{
   struct marshal_cmd_base cmd_base;
   GLint v[2];
};
static inline void
_mesa_unmarshal_Vertex2iv(struct gl_context *ctx, const struct marshal_cmd_Vertex2iv *cmd)
{
   const GLint * v = cmd->v;
   CALL_Vertex2iv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Vertex2iv(const GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex2iv);
   struct marshal_cmd_Vertex2iv *cmd;
   debug_print_marshal("Vertex2iv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex2iv, cmd_size);
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex2iv");
   CALL_Vertex2iv(ctx->CurrentServerDispatch, (v));
}


/* GetVertexArrayIndexediv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetVertexArrayIndexediv(GLuint vaobj, GLuint index, GLenum pname, GLint * param)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetVertexArrayIndexediv");
   CALL_GetVertexArrayIndexediv(ctx->CurrentServerDispatch, (vaobj, index, pname, param));
}


/* TexParameterIiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexParameterIiv(GLenum target, GLenum pname, const GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexParameterIiv");
   CALL_TexParameterIiv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* TexGendv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexGendv(GLenum coord, GLenum pname, const GLdouble * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexGendv");
   CALL_TexGendv(ctx->CurrentServerDispatch, (coord, pname, params));
}


/* ResetMinmax: marshalled asynchronously */
struct marshal_cmd_ResetMinmax
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
};
static inline void
_mesa_unmarshal_ResetMinmax(struct gl_context *ctx, const struct marshal_cmd_ResetMinmax *cmd)
{
   const GLenum target = cmd->target;
   CALL_ResetMinmax(ctx->CurrentServerDispatch, (target));
}
static void GLAPIENTRY
_mesa_marshal_ResetMinmax(GLenum target)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ResetMinmax);
   struct marshal_cmd_ResetMinmax *cmd;
   debug_print_marshal("ResetMinmax");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ResetMinmax, cmd_size);
      cmd->target = target;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ResetMinmax");
   CALL_ResetMinmax(ctx->CurrentServerDispatch, (target));
}


/* SampleCoverage: marshalled asynchronously */
struct marshal_cmd_SampleCoverage
{
   struct marshal_cmd_base cmd_base;
   GLclampf value;
   GLboolean invert;
};
static inline void
_mesa_unmarshal_SampleCoverage(struct gl_context *ctx, const struct marshal_cmd_SampleCoverage *cmd)
{
   const GLclampf value = cmd->value;
   const GLboolean invert = cmd->invert;
   CALL_SampleCoverage(ctx->CurrentServerDispatch, (value, invert));
}
static void GLAPIENTRY
_mesa_marshal_SampleCoverage(GLclampf value, GLboolean invert)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SampleCoverage);
   struct marshal_cmd_SampleCoverage *cmd;
   debug_print_marshal("SampleCoverage");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SampleCoverage, cmd_size);
      cmd->value = value;
      cmd->invert = invert;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SampleCoverage");
   CALL_SampleCoverage(ctx->CurrentServerDispatch, (value, invert));
}


/* GenerateTextureMipmap: marshalled asynchronously */
struct marshal_cmd_GenerateTextureMipmap
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
};
static inline void
_mesa_unmarshal_GenerateTextureMipmap(struct gl_context *ctx, const struct marshal_cmd_GenerateTextureMipmap *cmd)
{
   const GLuint texture = cmd->texture;
   CALL_GenerateTextureMipmap(ctx->CurrentServerDispatch, (texture));
}
static void GLAPIENTRY
_mesa_marshal_GenerateTextureMipmap(GLuint texture)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_GenerateTextureMipmap);
   struct marshal_cmd_GenerateTextureMipmap *cmd;
   debug_print_marshal("GenerateTextureMipmap");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_GenerateTextureMipmap, cmd_size);
      cmd->texture = texture;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("GenerateTextureMipmap");
   CALL_GenerateTextureMipmap(ctx->CurrentServerDispatch, (texture));
}


/* DeleteProgramsARB: marshalled asynchronously */
struct marshal_cmd_DeleteProgramsARB
{
   struct marshal_cmd_base cmd_base;
   GLsizei n;
   /* Next safe_mul(n, 4) bytes are GLuint programs[n] */
};
static inline void
_mesa_unmarshal_DeleteProgramsARB(struct gl_context *ctx, const struct marshal_cmd_DeleteProgramsARB *cmd)
{
   const GLsizei n = cmd->n;
   const GLuint * programs;
   const char *variable_data = (const char *) (cmd + 1);
   programs = (const GLuint *) variable_data;
   variable_data += n * 4;
   CALL_DeleteProgramsARB(ctx->CurrentServerDispatch, (n, programs));
}
static void GLAPIENTRY
_mesa_marshal_DeleteProgramsARB(GLsizei n, const GLuint * programs)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DeleteProgramsARB) + safe_mul(n, 4);
   struct marshal_cmd_DeleteProgramsARB *cmd;
   debug_print_marshal("DeleteProgramsARB");
   if (unlikely(safe_mul(n, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DeleteProgramsARB, cmd_size);
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, programs, n * 4);
      variable_data += n * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DeleteProgramsARB");
   CALL_DeleteProgramsARB(ctx->CurrentServerDispatch, (n, programs));
}


/* ShadeModel: marshalled asynchronously */
struct marshal_cmd_ShadeModel
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
};
static inline void
_mesa_unmarshal_ShadeModel(struct gl_context *ctx, const struct marshal_cmd_ShadeModel *cmd)
{
   const GLenum mode = cmd->mode;
   CALL_ShadeModel(ctx->CurrentServerDispatch, (mode));
}
static void GLAPIENTRY
_mesa_marshal_ShadeModel(GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ShadeModel);
   struct marshal_cmd_ShadeModel *cmd;
   debug_print_marshal("ShadeModel");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ShadeModel, cmd_size);
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ShadeModel");
   CALL_ShadeModel(ctx->CurrentServerDispatch, (mode));
}


/* CreateQueries: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CreateQueries(GLenum target, GLsizei n, GLuint * ids)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CreateQueries");
   CALL_CreateQueries(ctx->CurrentServerDispatch, (target, n, ids));
}


/* MultiDrawArrays: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_MultiDrawArrays(GLenum mode, const GLint * first, const GLsizei * count, GLsizei primcount)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MultiDrawArrays");
   CALL_MultiDrawArrays(ctx->CurrentServerDispatch, (mode, first, count, primcount));
}


/* GetProgramLocalParameterdvARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetProgramLocalParameterdvARB(GLenum target, GLuint index, GLdouble * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetProgramLocalParameterdvARB");
   CALL_GetProgramLocalParameterdvARB(ctx->CurrentServerDispatch, (target, index, params));
}


/* MapBufferRange: marshalled synchronously */
static GLvoid * GLAPIENTRY
_mesa_marshal_MapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MapBufferRange");
   return CALL_MapBufferRange(ctx->CurrentServerDispatch, (target, offset, length, access));
}


/* DispatchCompute: marshalled asynchronously */
struct marshal_cmd_DispatchCompute
{
   struct marshal_cmd_base cmd_base;
   GLuint num_groups_x;
   GLuint num_groups_y;
   GLuint num_groups_z;
};
static inline void
_mesa_unmarshal_DispatchCompute(struct gl_context *ctx, const struct marshal_cmd_DispatchCompute *cmd)
{
   const GLuint num_groups_x = cmd->num_groups_x;
   const GLuint num_groups_y = cmd->num_groups_y;
   const GLuint num_groups_z = cmd->num_groups_z;
   CALL_DispatchCompute(ctx->CurrentServerDispatch, (num_groups_x, num_groups_y, num_groups_z));
}
static void GLAPIENTRY
_mesa_marshal_DispatchCompute(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DispatchCompute);
   struct marshal_cmd_DispatchCompute *cmd;
   debug_print_marshal("DispatchCompute");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DispatchCompute, cmd_size);
      cmd->num_groups_x = num_groups_x;
      cmd->num_groups_y = num_groups_y;
      cmd->num_groups_z = num_groups_z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DispatchCompute");
   CALL_DispatchCompute(ctx->CurrentServerDispatch, (num_groups_x, num_groups_y, num_groups_z));
}


/* UseProgramStages: marshalled asynchronously */
struct marshal_cmd_UseProgramStages
{
   struct marshal_cmd_base cmd_base;
   GLuint pipeline;
   GLbitfield stages;
   GLuint program;
};
static inline void
_mesa_unmarshal_UseProgramStages(struct gl_context *ctx, const struct marshal_cmd_UseProgramStages *cmd)
{
   const GLuint pipeline = cmd->pipeline;
   const GLbitfield stages = cmd->stages;
   const GLuint program = cmd->program;
   CALL_UseProgramStages(ctx->CurrentServerDispatch, (pipeline, stages, program));
}
static void GLAPIENTRY
_mesa_marshal_UseProgramStages(GLuint pipeline, GLbitfield stages, GLuint program)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UseProgramStages);
   struct marshal_cmd_UseProgramStages *cmd;
   debug_print_marshal("UseProgramStages");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UseProgramStages, cmd_size);
      cmd->pipeline = pipeline;
      cmd->stages = stages;
      cmd->program = program;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UseProgramStages");
   CALL_UseProgramStages(ctx->CurrentServerDispatch, (pipeline, stages, program));
}


/* ProgramUniformMatrix4fv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix4fv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 64) bytes are GLfloat value[count][16] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix4fv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix4fv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 64;
   CALL_ProgramUniformMatrix4fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix4fv) + safe_mul(count, 64);
   struct marshal_cmd_ProgramUniformMatrix4fv *cmd;
   debug_print_marshal("ProgramUniformMatrix4fv");
   if (unlikely(safe_mul(count, 64) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix4fv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 64);
      variable_data += count * 64;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix4fv");
   CALL_ProgramUniformMatrix4fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* FramebufferRenderbuffer: marshalled asynchronously */
struct marshal_cmd_FramebufferRenderbuffer
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum attachment;
   GLenum renderbuffertarget;
   GLuint renderbuffer;
};
static inline void
_mesa_unmarshal_FramebufferRenderbuffer(struct gl_context *ctx, const struct marshal_cmd_FramebufferRenderbuffer *cmd)
{
   const GLenum target = cmd->target;
   const GLenum attachment = cmd->attachment;
   const GLenum renderbuffertarget = cmd->renderbuffertarget;
   const GLuint renderbuffer = cmd->renderbuffer;
   CALL_FramebufferRenderbuffer(ctx->CurrentServerDispatch, (target, attachment, renderbuffertarget, renderbuffer));
}
static void GLAPIENTRY
_mesa_marshal_FramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_FramebufferRenderbuffer);
   struct marshal_cmd_FramebufferRenderbuffer *cmd;
   debug_print_marshal("FramebufferRenderbuffer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_FramebufferRenderbuffer, cmd_size);
      cmd->target = target;
      cmd->attachment = attachment;
      cmd->renderbuffertarget = renderbuffertarget;
      cmd->renderbuffer = renderbuffer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("FramebufferRenderbuffer");
   CALL_FramebufferRenderbuffer(ctx->CurrentServerDispatch, (target, attachment, renderbuffertarget, renderbuffer));
}


/* IsProgramARB: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsProgramARB(GLuint program)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsProgramARB");
   return CALL_IsProgramARB(ctx->CurrentServerDispatch, (program));
}


/* Map2d: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_Map2d(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble * points)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("Map2d");
   CALL_Map2d(ctx->CurrentServerDispatch, (target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points));
}


/* Map2f: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_Map2f(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat * points)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("Map2f");
   CALL_Map2f(ctx->CurrentServerDispatch, (target, u1, u2, ustride, uorder, v1, v2, vstride, vorder, points));
}


/* ProgramStringARB: marshalled asynchronously */
struct marshal_cmd_ProgramStringARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum format;
   GLsizei len;
   /* Next len bytes are GLvoid string[len] */
};
static inline void
_mesa_unmarshal_ProgramStringARB(struct gl_context *ctx, const struct marshal_cmd_ProgramStringARB *cmd)
{
   const GLenum target = cmd->target;
   const GLenum format = cmd->format;
   const GLsizei len = cmd->len;
   const GLvoid * string;
   const char *variable_data = (const char *) (cmd + 1);
   string = (const GLvoid *) variable_data;
   variable_data += len;
   CALL_ProgramStringARB(ctx->CurrentServerDispatch, (target, format, len, string));
}
static void GLAPIENTRY
_mesa_marshal_ProgramStringARB(GLenum target, GLenum format, GLsizei len, const GLvoid * string)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramStringARB) + len;
   struct marshal_cmd_ProgramStringARB *cmd;
   debug_print_marshal("ProgramStringARB");
   if (unlikely(len < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramStringARB, cmd_size);
      cmd->target = target;
      cmd->format = format;
      cmd->len = len;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, string, len);
      variable_data += len;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramStringARB");
   CALL_ProgramStringARB(ctx->CurrentServerDispatch, (target, format, len, string));
}


/* CopyTextureSubImage2D: marshalled asynchronously */
struct marshal_cmd_CopyTextureSubImage2D
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLint level;
   GLint xoffset;
   GLint yoffset;
   GLint x;
   GLint y;
   GLsizei width;
   GLsizei height;
};
static inline void
_mesa_unmarshal_CopyTextureSubImage2D(struct gl_context *ctx, const struct marshal_cmd_CopyTextureSubImage2D *cmd)
{
   const GLuint texture = cmd->texture;
   const GLint level = cmd->level;
   const GLint xoffset = cmd->xoffset;
   const GLint yoffset = cmd->yoffset;
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   CALL_CopyTextureSubImage2D(ctx->CurrentServerDispatch, (texture, level, xoffset, yoffset, x, y, width, height));
}
static void GLAPIENTRY
_mesa_marshal_CopyTextureSubImage2D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_CopyTextureSubImage2D);
   struct marshal_cmd_CopyTextureSubImage2D *cmd;
   debug_print_marshal("CopyTextureSubImage2D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_CopyTextureSubImage2D, cmd_size);
      cmd->texture = texture;
      cmd->level = level;
      cmd->xoffset = xoffset;
      cmd->yoffset = yoffset;
      cmd->x = x;
      cmd->y = y;
      cmd->width = width;
      cmd->height = height;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("CopyTextureSubImage2D");
   CALL_CopyTextureSubImage2D(ctx->CurrentServerDispatch, (texture, level, xoffset, yoffset, x, y, width, height));
}


/* MultiTexCoord4s: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord4s
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLshort s;
   GLshort t;
   GLshort r;
   GLshort q;
};
static inline void
_mesa_unmarshal_MultiTexCoord4s(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord4s *cmd)
{
   const GLenum target = cmd->target;
   const GLshort s = cmd->s;
   const GLshort t = cmd->t;
   const GLshort r = cmd->r;
   const GLshort q = cmd->q;
   CALL_MultiTexCoord4s(ctx->CurrentServerDispatch, (target, s, t, r, q));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord4s(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord4s);
   struct marshal_cmd_MultiTexCoord4s *cmd;
   debug_print_marshal("MultiTexCoord4s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord4s, cmd_size);
      cmd->target = target;
      cmd->s = s;
      cmd->t = t;
      cmd->r = r;
      cmd->q = q;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord4s");
   CALL_MultiTexCoord4s(ctx->CurrentServerDispatch, (target, s, t, r, q));
}


/* ViewportIndexedf: marshalled asynchronously */
struct marshal_cmd_ViewportIndexedf
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat x;
   GLfloat y;
   GLfloat w;
   GLfloat h;
};
static inline void
_mesa_unmarshal_ViewportIndexedf(struct gl_context *ctx, const struct marshal_cmd_ViewportIndexedf *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat w = cmd->w;
   const GLfloat h = cmd->h;
   CALL_ViewportIndexedf(ctx->CurrentServerDispatch, (index, x, y, w, h));
}
static void GLAPIENTRY
_mesa_marshal_ViewportIndexedf(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ViewportIndexedf);
   struct marshal_cmd_ViewportIndexedf *cmd;
   debug_print_marshal("ViewportIndexedf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ViewportIndexedf, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      cmd->w = w;
      cmd->h = h;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ViewportIndexedf");
   CALL_ViewportIndexedf(ctx->CurrentServerDispatch, (index, x, y, w, h));
}


/* MultiTexCoord4i: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord4i
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLint s;
   GLint t;
   GLint r;
   GLint q;
};
static inline void
_mesa_unmarshal_MultiTexCoord4i(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord4i *cmd)
{
   const GLenum target = cmd->target;
   const GLint s = cmd->s;
   const GLint t = cmd->t;
   const GLint r = cmd->r;
   const GLint q = cmd->q;
   CALL_MultiTexCoord4i(ctx->CurrentServerDispatch, (target, s, t, r, q));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord4i(GLenum target, GLint s, GLint t, GLint r, GLint q)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord4i);
   struct marshal_cmd_MultiTexCoord4i *cmd;
   debug_print_marshal("MultiTexCoord4i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord4i, cmd_size);
      cmd->target = target;
      cmd->s = s;
      cmd->t = t;
      cmd->r = r;
      cmd->q = q;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord4i");
   CALL_MultiTexCoord4i(ctx->CurrentServerDispatch, (target, s, t, r, q));
}


/* DebugMessageControl: marshalled asynchronously */
struct marshal_cmd_DebugMessageControl
{
   struct marshal_cmd_base cmd_base;
   GLenum source;
   GLenum type;
   GLenum severity;
   GLsizei count;
   GLboolean enabled;
   /* Next safe_mul(count, 4) bytes are GLuint ids[count] */
};
static inline void
_mesa_unmarshal_DebugMessageControl(struct gl_context *ctx, const struct marshal_cmd_DebugMessageControl *cmd)
{
   const GLenum source = cmd->source;
   const GLenum type = cmd->type;
   const GLenum severity = cmd->severity;
   const GLsizei count = cmd->count;
   const GLboolean enabled = cmd->enabled;
   const GLuint * ids;
   const char *variable_data = (const char *) (cmd + 1);
   ids = (const GLuint *) variable_data;
   variable_data += count * 4;
   CALL_DebugMessageControl(ctx->CurrentServerDispatch, (source, type, severity, count, ids, enabled));
}
static void GLAPIENTRY
_mesa_marshal_DebugMessageControl(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint * ids, GLboolean enabled)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DebugMessageControl) + safe_mul(count, 4);
   struct marshal_cmd_DebugMessageControl *cmd;
   debug_print_marshal("DebugMessageControl");
   if (unlikely(safe_mul(count, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DebugMessageControl, cmd_size);
      cmd->source = source;
      cmd->type = type;
      cmd->severity = severity;
      cmd->count = count;
      cmd->enabled = enabled;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, ids, count * 4);
      variable_data += count * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DebugMessageControl");
   CALL_DebugMessageControl(ctx->CurrentServerDispatch, (source, type, severity, count, ids, enabled));
}


/* MultiTexCoord4d: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord4d
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLdouble s;
   GLdouble t;
   GLdouble r;
   GLdouble q;
};
static inline void
_mesa_unmarshal_MultiTexCoord4d(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord4d *cmd)
{
   const GLenum target = cmd->target;
   const GLdouble s = cmd->s;
   const GLdouble t = cmd->t;
   const GLdouble r = cmd->r;
   const GLdouble q = cmd->q;
   CALL_MultiTexCoord4d(ctx->CurrentServerDispatch, (target, s, t, r, q));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord4d(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord4d);
   struct marshal_cmd_MultiTexCoord4d *cmd;
   debug_print_marshal("MultiTexCoord4d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord4d, cmd_size);
      cmd->target = target;
      cmd->s = s;
      cmd->t = t;
      cmd->r = r;
      cmd->q = q;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord4d");
   CALL_MultiTexCoord4d(ctx->CurrentServerDispatch, (target, s, t, r, q));
}


/* GetHistogram: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetHistogram(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid * values)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetHistogram");
   CALL_GetHistogram(ctx->CurrentServerDispatch, (target, reset, format, type, values));
}


/* Translatex: marshalled asynchronously */
struct marshal_cmd_Translatex
{
   struct marshal_cmd_base cmd_base;
   GLfixed x;
   GLfixed y;
   GLfixed z;
};
static inline void
_mesa_unmarshal_Translatex(struct gl_context *ctx, const struct marshal_cmd_Translatex *cmd)
{
   const GLfixed x = cmd->x;
   const GLfixed y = cmd->y;
   const GLfixed z = cmd->z;
   CALL_Translatex(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Translatex(GLfixed x, GLfixed y, GLfixed z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Translatex);
   struct marshal_cmd_Translatex *cmd;
   debug_print_marshal("Translatex");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Translatex, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Translatex");
   CALL_Translatex(ctx->CurrentServerDispatch, (x, y, z));
}


/* MultiDrawElementsIndirectCountARB: marshalled asynchronously */
struct marshal_cmd_MultiDrawElementsIndirectCountARB
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
   GLenum type;
   GLintptr indirect;
   GLintptr drawcount;
   GLsizei maxdrawcount;
   GLsizei stride;
};
static inline void
_mesa_unmarshal_MultiDrawElementsIndirectCountARB(struct gl_context *ctx, const struct marshal_cmd_MultiDrawElementsIndirectCountARB *cmd)
{
   const GLenum mode = cmd->mode;
   const GLenum type = cmd->type;
   const GLintptr indirect = cmd->indirect;
   const GLintptr drawcount = cmd->drawcount;
   const GLsizei maxdrawcount = cmd->maxdrawcount;
   const GLsizei stride = cmd->stride;
   CALL_MultiDrawElementsIndirectCountARB(ctx->CurrentServerDispatch, (mode, type, indirect, drawcount, maxdrawcount, stride));
}
static void GLAPIENTRY
_mesa_marshal_MultiDrawElementsIndirectCountARB(GLenum mode, GLenum type, GLintptr indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiDrawElementsIndirectCountARB);
   struct marshal_cmd_MultiDrawElementsIndirectCountARB *cmd;
   debug_print_marshal("MultiDrawElementsIndirectCountARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiDrawElementsIndirectCountARB, cmd_size);
      cmd->mode = mode;
      cmd->type = type;
      cmd->indirect = indirect;
      cmd->drawcount = drawcount;
      cmd->maxdrawcount = maxdrawcount;
      cmd->stride = stride;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiDrawElementsIndirectCountARB");
   CALL_MultiDrawElementsIndirectCountARB(ctx->CurrentServerDispatch, (mode, type, indirect, drawcount, maxdrawcount, stride));
}


/* Indexsv: marshalled asynchronously */
struct marshal_cmd_Indexsv
{
   struct marshal_cmd_base cmd_base;
   GLshort c[1];
};
static inline void
_mesa_unmarshal_Indexsv(struct gl_context *ctx, const struct marshal_cmd_Indexsv *cmd)
{
   const GLshort * c = cmd->c;
   CALL_Indexsv(ctx->CurrentServerDispatch, (c));
}
static void GLAPIENTRY
_mesa_marshal_Indexsv(const GLshort * c)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Indexsv);
   struct marshal_cmd_Indexsv *cmd;
   debug_print_marshal("Indexsv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Indexsv, cmd_size);
      memcpy(cmd->c, c, 2);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Indexsv");
   CALL_Indexsv(ctx->CurrentServerDispatch, (c));
}


/* VertexAttrib1fvARB: marshalled asynchronously */
struct marshal_cmd_VertexAttrib1fvARB
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLfloat v[1];
};
static inline void
_mesa_unmarshal_VertexAttrib1fvARB(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib1fvARB *cmd)
{
   const GLuint index = cmd->index;
   const GLfloat * v = cmd->v;
   CALL_VertexAttrib1fvARB(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib1fvARB(GLuint index, const GLfloat * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib1fvARB);
   struct marshal_cmd_VertexAttrib1fvARB *cmd;
   debug_print_marshal("VertexAttrib1fvARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib1fvARB, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib1fvARB");
   CALL_VertexAttrib1fvARB(ctx->CurrentServerDispatch, (index, v));
}


/* TexCoord2dv: marshalled asynchronously */
struct marshal_cmd_TexCoord2dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v[2];
};
static inline void
_mesa_unmarshal_TexCoord2dv(struct gl_context *ctx, const struct marshal_cmd_TexCoord2dv *cmd)
{
   const GLdouble * v = cmd->v;
   CALL_TexCoord2dv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord2dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord2dv);
   struct marshal_cmd_TexCoord2dv *cmd;
   debug_print_marshal("TexCoord2dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord2dv, cmd_size);
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord2dv");
   CALL_TexCoord2dv(ctx->CurrentServerDispatch, (v));
}


/* Translated: marshalled asynchronously */
struct marshal_cmd_Translated
{
   struct marshal_cmd_base cmd_base;
   GLdouble x;
   GLdouble y;
   GLdouble z;
};
static inline void
_mesa_unmarshal_Translated(struct gl_context *ctx, const struct marshal_cmd_Translated *cmd)
{
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   CALL_Translated(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Translated(GLdouble x, GLdouble y, GLdouble z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Translated);
   struct marshal_cmd_Translated *cmd;
   debug_print_marshal("Translated");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Translated, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Translated");
   CALL_Translated(ctx->CurrentServerDispatch, (x, y, z));
}


/* Translatef: marshalled asynchronously */
struct marshal_cmd_Translatef
{
   struct marshal_cmd_base cmd_base;
   GLfloat x;
   GLfloat y;
   GLfloat z;
};
static inline void
_mesa_unmarshal_Translatef(struct gl_context *ctx, const struct marshal_cmd_Translatef *cmd)
{
   const GLfloat x = cmd->x;
   const GLfloat y = cmd->y;
   const GLfloat z = cmd->z;
   CALL_Translatef(ctx->CurrentServerDispatch, (x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Translatef(GLfloat x, GLfloat y, GLfloat z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Translatef);
   struct marshal_cmd_Translatef *cmd;
   debug_print_marshal("Translatef");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Translatef, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Translatef");
   CALL_Translatef(ctx->CurrentServerDispatch, (x, y, z));
}


/* MultTransposeMatrixd: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_MultTransposeMatrixd(const GLdouble * m)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MultTransposeMatrixd");
   CALL_MultTransposeMatrixd(ctx->CurrentServerDispatch, (m));
}


/* ProgramUniform4uiv: marshalled asynchronously */
struct marshal_cmd_ProgramUniform4uiv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 16) bytes are GLuint value[count][4] */
};
static inline void
_mesa_unmarshal_ProgramUniform4uiv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform4uiv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLuint * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLuint *) variable_data;
   variable_data += count * 16;
   CALL_ProgramUniform4uiv(ctx->CurrentServerDispatch, (program, location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform4uiv(GLuint program, GLint location, GLsizei count, const GLuint * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform4uiv) + safe_mul(count, 16);
   struct marshal_cmd_ProgramUniform4uiv *cmd;
   debug_print_marshal("ProgramUniform4uiv");
   if (unlikely(safe_mul(count, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform4uiv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 16);
      variable_data += count * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform4uiv");
   CALL_ProgramUniform4uiv(ctx->CurrentServerDispatch, (program, location, count, value));
}


/* GetPerfCounterInfoINTEL: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetPerfCounterInfoINTEL(GLuint queryId, GLuint counterId, GLuint counterNameLength, GLchar * counterName, GLuint counterDescLength, GLchar * counterDesc, GLuint * counterOffset, GLuint * counterDataSize, GLuint * counterTypeEnum, GLuint * counterDataTypeEnum, GLuint64 * rawCounterMaxValue)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetPerfCounterInfoINTEL");
   CALL_GetPerfCounterInfoINTEL(ctx->CurrentServerDispatch, (queryId, counterId, counterNameLength, counterName, counterDescLength, counterDesc, counterOffset, counterDataSize, counterTypeEnum, counterDataTypeEnum, rawCounterMaxValue));
}


/* RenderMode: marshalled synchronously */
static GLint GLAPIENTRY
_mesa_marshal_RenderMode(GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("RenderMode");
   return CALL_RenderMode(ctx->CurrentServerDispatch, (mode));
}


/* MultiTexCoord1fARB: marshalled asynchronously */
struct marshal_cmd_MultiTexCoord1fARB
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLfloat s;
};
static inline void
_mesa_unmarshal_MultiTexCoord1fARB(struct gl_context *ctx, const struct marshal_cmd_MultiTexCoord1fARB *cmd)
{
   const GLenum target = cmd->target;
   const GLfloat s = cmd->s;
   CALL_MultiTexCoord1fARB(ctx->CurrentServerDispatch, (target, s));
}
static void GLAPIENTRY
_mesa_marshal_MultiTexCoord1fARB(GLenum target, GLfloat s)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_MultiTexCoord1fARB);
   struct marshal_cmd_MultiTexCoord1fARB *cmd;
   debug_print_marshal("MultiTexCoord1fARB");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_MultiTexCoord1fARB, cmd_size);
      cmd->target = target;
      cmd->s = s;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("MultiTexCoord1fARB");
   CALL_MultiTexCoord1fARB(ctx->CurrentServerDispatch, (target, s));
}


/* SecondaryColor3d: marshalled asynchronously */
struct marshal_cmd_SecondaryColor3d
{
   struct marshal_cmd_base cmd_base;
   GLdouble red;
   GLdouble green;
   GLdouble blue;
};
static inline void
_mesa_unmarshal_SecondaryColor3d(struct gl_context *ctx, const struct marshal_cmd_SecondaryColor3d *cmd)
{
   const GLdouble red = cmd->red;
   const GLdouble green = cmd->green;
   const GLdouble blue = cmd->blue;
   CALL_SecondaryColor3d(ctx->CurrentServerDispatch, (red, green, blue));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColor3d(GLdouble red, GLdouble green, GLdouble blue)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColor3d);
   struct marshal_cmd_SecondaryColor3d *cmd;
   debug_print_marshal("SecondaryColor3d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColor3d, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColor3d");
   CALL_SecondaryColor3d(ctx->CurrentServerDispatch, (red, green, blue));
}


/* FramebufferParameteri: marshalled asynchronously */
struct marshal_cmd_FramebufferParameteri
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum pname;
   GLint param;
};
static inline void
_mesa_unmarshal_FramebufferParameteri(struct gl_context *ctx, const struct marshal_cmd_FramebufferParameteri *cmd)
{
   const GLenum target = cmd->target;
   const GLenum pname = cmd->pname;
   const GLint param = cmd->param;
   CALL_FramebufferParameteri(ctx->CurrentServerDispatch, (target, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_FramebufferParameteri(GLenum target, GLenum pname, GLint param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_FramebufferParameteri);
   struct marshal_cmd_FramebufferParameteri *cmd;
   debug_print_marshal("FramebufferParameteri");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_FramebufferParameteri, cmd_size);
      cmd->target = target;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("FramebufferParameteri");
   CALL_FramebufferParameteri(ctx->CurrentServerDispatch, (target, pname, param));
}


/* VertexAttribs4ubvNV: marshalled asynchronously */
struct marshal_cmd_VertexAttribs4ubvNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLsizei n;
   /* Next safe_mul(n, 4) bytes are GLubyte v[n][4] */
};
static inline void
_mesa_unmarshal_VertexAttribs4ubvNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttribs4ubvNV *cmd)
{
   const GLuint index = cmd->index;
   const GLsizei n = cmd->n;
   const GLubyte * v;
   const char *variable_data = (const char *) (cmd + 1);
   v = (const GLubyte *) variable_data;
   variable_data += n * 4;
   CALL_VertexAttribs4ubvNV(ctx->CurrentServerDispatch, (index, n, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribs4ubvNV(GLuint index, GLsizei n, const GLubyte * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribs4ubvNV) + safe_mul(n, 4);
   struct marshal_cmd_VertexAttribs4ubvNV *cmd;
   debug_print_marshal("VertexAttribs4ubvNV");
   if (unlikely(safe_mul(n, 4) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribs4ubvNV, cmd_size);
      cmd->index = index;
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, v, n * 4);
      variable_data += n * 4;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribs4ubvNV");
   CALL_VertexAttribs4ubvNV(ctx->CurrentServerDispatch, (index, n, v));
}


/* LightModelxv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_LightModelxv(GLenum pname, const GLfixed * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("LightModelxv");
   CALL_LightModelxv(ctx->CurrentServerDispatch, (pname, params));
}


/* CopyTexSubImage1D: marshalled asynchronously */
struct marshal_cmd_CopyTexSubImage1D
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLint level;
   GLint xoffset;
   GLint x;
   GLint y;
   GLsizei width;
};
static inline void
_mesa_unmarshal_CopyTexSubImage1D(struct gl_context *ctx, const struct marshal_cmd_CopyTexSubImage1D *cmd)
{
   const GLenum target = cmd->target;
   const GLint level = cmd->level;
   const GLint xoffset = cmd->xoffset;
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLsizei width = cmd->width;
   CALL_CopyTexSubImage1D(ctx->CurrentServerDispatch, (target, level, xoffset, x, y, width));
}
static void GLAPIENTRY
_mesa_marshal_CopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_CopyTexSubImage1D);
   struct marshal_cmd_CopyTexSubImage1D *cmd;
   debug_print_marshal("CopyTexSubImage1D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_CopyTexSubImage1D, cmd_size);
      cmd->target = target;
      cmd->level = level;
      cmd->xoffset = xoffset;
      cmd->x = x;
      cmd->y = y;
      cmd->width = width;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("CopyTexSubImage1D");
   CALL_CopyTexSubImage1D(ctx->CurrentServerDispatch, (target, level, xoffset, x, y, width));
}


/* TextureSubImage3D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TextureSubImage3D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * pixels)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TextureSubImage3D");
   CALL_TextureSubImage3D(ctx->CurrentServerDispatch, (texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels));
}


/* StencilFunc: marshalled asynchronously */
struct marshal_cmd_StencilFunc
{
   struct marshal_cmd_base cmd_base;
   GLenum func;
   GLint ref;
   GLuint mask;
};
static inline void
_mesa_unmarshal_StencilFunc(struct gl_context *ctx, const struct marshal_cmd_StencilFunc *cmd)
{
   const GLenum func = cmd->func;
   const GLint ref = cmd->ref;
   const GLuint mask = cmd->mask;
   CALL_StencilFunc(ctx->CurrentServerDispatch, (func, ref, mask));
}
static void GLAPIENTRY
_mesa_marshal_StencilFunc(GLenum func, GLint ref, GLuint mask)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_StencilFunc);
   struct marshal_cmd_StencilFunc *cmd;
   debug_print_marshal("StencilFunc");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_StencilFunc, cmd_size);
      cmd->func = func;
      cmd->ref = ref;
      cmd->mask = mask;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("StencilFunc");
   CALL_StencilFunc(ctx->CurrentServerDispatch, (func, ref, mask));
}


/* CopyPixels: marshalled asynchronously */
struct marshal_cmd_CopyPixels
{
   struct marshal_cmd_base cmd_base;
   GLint x;
   GLint y;
   GLsizei width;
   GLsizei height;
   GLenum type;
};
static inline void
_mesa_unmarshal_CopyPixels(struct gl_context *ctx, const struct marshal_cmd_CopyPixels *cmd)
{
   const GLint x = cmd->x;
   const GLint y = cmd->y;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLenum type = cmd->type;
   CALL_CopyPixels(ctx->CurrentServerDispatch, (x, y, width, height, type));
}
static void GLAPIENTRY
_mesa_marshal_CopyPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_CopyPixels);
   struct marshal_cmd_CopyPixels *cmd;
   debug_print_marshal("CopyPixels");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_CopyPixels, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->width = width;
      cmd->height = height;
      cmd->type = type;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("CopyPixels");
   CALL_CopyPixels(ctx->CurrentServerDispatch, (x, y, width, height, type));
}


/* TexGenxvOES: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexGenxvOES(GLenum coord, GLenum pname, const GLfixed * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexGenxvOES");
   CALL_TexGenxvOES(ctx->CurrentServerDispatch, (coord, pname, params));
}


/* GetTextureLevelParameterfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetTextureLevelParameterfv(GLuint texture, GLint level, GLenum pname, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetTextureLevelParameterfv");
   CALL_GetTextureLevelParameterfv(ctx->CurrentServerDispatch, (texture, level, pname, params));
}


/* VertexAttrib4Nubv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib4Nubv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLubyte v[4];
};
static inline void
_mesa_unmarshal_VertexAttrib4Nubv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib4Nubv *cmd)
{
   const GLuint index = cmd->index;
   const GLubyte * v = cmd->v;
   CALL_VertexAttrib4Nubv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib4Nubv(GLuint index, const GLubyte * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib4Nubv);
   struct marshal_cmd_VertexAttrib4Nubv *cmd;
   debug_print_marshal("VertexAttrib4Nubv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib4Nubv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 4);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib4Nubv");
   CALL_VertexAttrib4Nubv(ctx->CurrentServerDispatch, (index, v));
}


/* UniformMatrix4x2dv: marshalled asynchronously */
struct marshal_cmd_UniformMatrix4x2dv
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 64) bytes are GLdouble value[count][8] */
};
static inline void
_mesa_unmarshal_UniformMatrix4x2dv(struct gl_context *ctx, const struct marshal_cmd_UniformMatrix4x2dv *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLdouble * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLdouble *) variable_data;
   variable_data += count * 64;
   CALL_UniformMatrix4x2dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_UniformMatrix4x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_UniformMatrix4x2dv) + safe_mul(count, 64);
   struct marshal_cmd_UniformMatrix4x2dv *cmd;
   debug_print_marshal("UniformMatrix4x2dv");
   if (unlikely(safe_mul(count, 64) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_UniformMatrix4x2dv, cmd_size);
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 64);
      variable_data += count * 64;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("UniformMatrix4x2dv");
   CALL_UniformMatrix4x2dv(ctx->CurrentServerDispatch, (location, count, transpose, value));
}


/* VertexAttribPointer: marshalled asynchronously */
struct marshal_cmd_VertexAttribPointer
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLint size;
   GLenum type;
   GLboolean normalized;
   GLsizei stride;
   const GLvoid * pointer;
};
static inline void
_mesa_unmarshal_VertexAttribPointer(struct gl_context *ctx, const struct marshal_cmd_VertexAttribPointer *cmd)
{
   const GLuint index = cmd->index;
   const GLint size = cmd->size;
   const GLenum type = cmd->type;
   const GLboolean normalized = cmd->normalized;
   const GLsizei stride = cmd->stride;
   const GLvoid * pointer = cmd->pointer;
   CALL_VertexAttribPointer(ctx->CurrentServerDispatch, (index, size, type, normalized, stride, pointer));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribPointer);
   struct marshal_cmd_VertexAttribPointer *cmd;
   debug_print_marshal("VertexAttribPointer");
   if (_mesa_glthread_is_non_vbo_vertex_attrib_pointer(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("VertexAttribPointer");
      CALL_VertexAttribPointer(ctx->CurrentServerDispatch, (index, size, type, normalized, stride, pointer));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribPointer, cmd_size);
      cmd->index = index;
      cmd->size = size;
      cmd->type = type;
      cmd->normalized = normalized;
      cmd->stride = stride;
      cmd->pointer = pointer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribPointer");
   CALL_VertexAttribPointer(ctx->CurrentServerDispatch, (index, size, type, normalized, stride, pointer));
}


/* IndexMask: marshalled asynchronously */
struct marshal_cmd_IndexMask
{
   struct marshal_cmd_base cmd_base;
   GLuint mask;
};
static inline void
_mesa_unmarshal_IndexMask(struct gl_context *ctx, const struct marshal_cmd_IndexMask *cmd)
{
   const GLuint mask = cmd->mask;
   CALL_IndexMask(ctx->CurrentServerDispatch, (mask));
}
static void GLAPIENTRY
_mesa_marshal_IndexMask(GLuint mask)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_IndexMask);
   struct marshal_cmd_IndexMask *cmd;
   debug_print_marshal("IndexMask");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_IndexMask, cmd_size);
      cmd->mask = mask;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("IndexMask");
   CALL_IndexMask(ctx->CurrentServerDispatch, (mask));
}


/* VertexAttribIFormat: marshalled asynchronously */
struct marshal_cmd_VertexAttribIFormat
{
   struct marshal_cmd_base cmd_base;
   GLuint attribindex;
   GLint size;
   GLenum type;
   GLuint relativeoffset;
};
static inline void
_mesa_unmarshal_VertexAttribIFormat(struct gl_context *ctx, const struct marshal_cmd_VertexAttribIFormat *cmd)
{
   const GLuint attribindex = cmd->attribindex;
   const GLint size = cmd->size;
   const GLenum type = cmd->type;
   const GLuint relativeoffset = cmd->relativeoffset;
   CALL_VertexAttribIFormat(ctx->CurrentServerDispatch, (attribindex, size, type, relativeoffset));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribIFormat(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribIFormat);
   struct marshal_cmd_VertexAttribIFormat *cmd;
   debug_print_marshal("VertexAttribIFormat");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribIFormat, cmd_size);
      cmd->attribindex = attribindex;
      cmd->size = size;
      cmd->type = type;
      cmd->relativeoffset = relativeoffset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribIFormat");
   CALL_VertexAttribIFormat(ctx->CurrentServerDispatch, (attribindex, size, type, relativeoffset));
}


/* DrawArraysInstancedBaseInstance: marshalled asynchronously */
struct marshal_cmd_DrawArraysInstancedBaseInstance
{
   struct marshal_cmd_base cmd_base;
   GLenum mode;
   GLint first;
   GLsizei count;
   GLsizei primcount;
   GLuint baseinstance;
};
static inline void
_mesa_unmarshal_DrawArraysInstancedBaseInstance(struct gl_context *ctx, const struct marshal_cmd_DrawArraysInstancedBaseInstance *cmd)
{
   const GLenum mode = cmd->mode;
   const GLint first = cmd->first;
   const GLsizei count = cmd->count;
   const GLsizei primcount = cmd->primcount;
   const GLuint baseinstance = cmd->baseinstance;
   CALL_DrawArraysInstancedBaseInstance(ctx->CurrentServerDispatch, (mode, first, count, primcount, baseinstance));
}
static void GLAPIENTRY
_mesa_marshal_DrawArraysInstancedBaseInstance(GLenum mode, GLint first, GLsizei count, GLsizei primcount, GLuint baseinstance)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DrawArraysInstancedBaseInstance);
   struct marshal_cmd_DrawArraysInstancedBaseInstance *cmd;
   debug_print_marshal("DrawArraysInstancedBaseInstance");
   if (_mesa_glthread_is_non_vbo_draw_elements(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("DrawArraysInstancedBaseInstance");
      CALL_DrawArraysInstancedBaseInstance(ctx->CurrentServerDispatch, (mode, first, count, primcount, baseinstance));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DrawArraysInstancedBaseInstance, cmd_size);
      cmd->mode = mode;
      cmd->first = first;
      cmd->count = count;
      cmd->primcount = primcount;
      cmd->baseinstance = baseinstance;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DrawArraysInstancedBaseInstance");
   CALL_DrawArraysInstancedBaseInstance(ctx->CurrentServerDispatch, (mode, first, count, primcount, baseinstance));
}


/* TextureStorageMem3DMultisampleEXT: marshalled asynchronously */
struct marshal_cmd_TextureStorageMem3DMultisampleEXT
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLsizei samples;
   GLenum internalFormat;
   GLsizei width;
   GLsizei height;
   GLsizei depth;
   GLboolean fixedSampleLocations;
   GLuint memory;
   GLuint64 offset;
};
static inline void
_mesa_unmarshal_TextureStorageMem3DMultisampleEXT(struct gl_context *ctx, const struct marshal_cmd_TextureStorageMem3DMultisampleEXT *cmd)
{
   const GLuint texture = cmd->texture;
   const GLsizei samples = cmd->samples;
   const GLenum internalFormat = cmd->internalFormat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLsizei depth = cmd->depth;
   const GLboolean fixedSampleLocations = cmd->fixedSampleLocations;
   const GLuint memory = cmd->memory;
   const GLuint64 offset = cmd->offset;
   CALL_TextureStorageMem3DMultisampleEXT(ctx->CurrentServerDispatch, (texture, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset));
}
static void GLAPIENTRY
_mesa_marshal_TextureStorageMem3DMultisampleEXT(GLuint texture, GLsizei samples, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations, GLuint memory, GLuint64 offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureStorageMem3DMultisampleEXT);
   struct marshal_cmd_TextureStorageMem3DMultisampleEXT *cmd;
   debug_print_marshal("TextureStorageMem3DMultisampleEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureStorageMem3DMultisampleEXT, cmd_size);
      cmd->texture = texture;
      cmd->samples = samples;
      cmd->internalFormat = internalFormat;
      cmd->width = width;
      cmd->height = height;
      cmd->depth = depth;
      cmd->fixedSampleLocations = fixedSampleLocations;
      cmd->memory = memory;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureStorageMem3DMultisampleEXT");
   CALL_TextureStorageMem3DMultisampleEXT(ctx->CurrentServerDispatch, (texture, samples, internalFormat, width, height, depth, fixedSampleLocations, memory, offset));
}


/* CompressedTextureSubImage3D: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CompressedTextureSubImage3D(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CompressedTextureSubImage3D");
   CALL_CompressedTextureSubImage3D(ctx->CurrentServerDispatch, (texture, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data));
}


/* PopAttrib: marshalled asynchronously */
struct marshal_cmd_PopAttrib
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_PopAttrib(struct gl_context *ctx, const struct marshal_cmd_PopAttrib *cmd)
{
   CALL_PopAttrib(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_PopAttrib(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_PopAttrib);
   struct marshal_cmd_PopAttrib *cmd;
   debug_print_marshal("PopAttrib");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_PopAttrib, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("PopAttrib");
   CALL_PopAttrib(ctx->CurrentServerDispatch, ());
}


/* Uniform3ui: marshalled asynchronously */
struct marshal_cmd_Uniform3ui
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLuint x;
   GLuint y;
   GLuint z;
};
static inline void
_mesa_unmarshal_Uniform3ui(struct gl_context *ctx, const struct marshal_cmd_Uniform3ui *cmd)
{
   const GLint location = cmd->location;
   const GLuint x = cmd->x;
   const GLuint y = cmd->y;
   const GLuint z = cmd->z;
   CALL_Uniform3ui(ctx->CurrentServerDispatch, (location, x, y, z));
}
static void GLAPIENTRY
_mesa_marshal_Uniform3ui(GLint location, GLuint x, GLuint y, GLuint z)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform3ui);
   struct marshal_cmd_Uniform3ui *cmd;
   debug_print_marshal("Uniform3ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform3ui, cmd_size);
      cmd->location = location;
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform3ui");
   CALL_Uniform3ui(ctx->CurrentServerDispatch, (location, x, y, z));
}


/* DeletePerfMonitorsAMD: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_DeletePerfMonitorsAMD(GLsizei n, GLuint * monitors)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("DeletePerfMonitorsAMD");
   CALL_DeletePerfMonitorsAMD(ctx->CurrentServerDispatch, (n, monitors));
}


/* Color4dv: marshalled asynchronously */
struct marshal_cmd_Color4dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v[4];
};
static inline void
_mesa_unmarshal_Color4dv(struct gl_context *ctx, const struct marshal_cmd_Color4dv *cmd)
{
   const GLdouble * v = cmd->v;
   CALL_Color4dv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Color4dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Color4dv);
   struct marshal_cmd_Color4dv *cmd;
   debug_print_marshal("Color4dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Color4dv, cmd_size);
      memcpy(cmd->v, v, 32);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Color4dv");
   CALL_Color4dv(ctx->CurrentServerDispatch, (v));
}


/* DisableVertexAttribArray: marshalled asynchronously */
struct marshal_cmd_DisableVertexAttribArray
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
};
static inline void
_mesa_unmarshal_DisableVertexAttribArray(struct gl_context *ctx, const struct marshal_cmd_DisableVertexAttribArray *cmd)
{
   const GLuint index = cmd->index;
   CALL_DisableVertexAttribArray(ctx->CurrentServerDispatch, (index));
}
static void GLAPIENTRY
_mesa_marshal_DisableVertexAttribArray(GLuint index)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_DisableVertexAttribArray);
   struct marshal_cmd_DisableVertexAttribArray *cmd;
   debug_print_marshal("DisableVertexAttribArray");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_DisableVertexAttribArray, cmd_size);
      cmd->index = index;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("DisableVertexAttribArray");
   CALL_DisableVertexAttribArray(ctx->CurrentServerDispatch, (index));
}


/* ProgramUniformMatrix3x2fv: marshalled asynchronously */
struct marshal_cmd_ProgramUniformMatrix3x2fv
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLsizei count;
   GLboolean transpose;
   /* Next safe_mul(count, 24) bytes are GLfloat value[count][6] */
};
static inline void
_mesa_unmarshal_ProgramUniformMatrix3x2fv(struct gl_context *ctx, const struct marshal_cmd_ProgramUniformMatrix3x2fv *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLboolean transpose = cmd->transpose;
   const GLfloat * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLfloat *) variable_data;
   variable_data += count * 24;
   CALL_ProgramUniformMatrix3x2fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniformMatrix3x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniformMatrix3x2fv) + safe_mul(count, 24);
   struct marshal_cmd_ProgramUniformMatrix3x2fv *cmd;
   debug_print_marshal("ProgramUniformMatrix3x2fv");
   if (unlikely(safe_mul(count, 24) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniformMatrix3x2fv, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->count = count;
      cmd->transpose = transpose;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 24);
      variable_data += count * 24;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniformMatrix3x2fv");
   CALL_ProgramUniformMatrix3x2fv(ctx->CurrentServerDispatch, (program, location, count, transpose, value));
}


/* GetDoublei_v: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetDoublei_v(GLenum target, GLuint index, GLdouble * data)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetDoublei_v");
   CALL_GetDoublei_v(ctx->CurrentServerDispatch, (target, index, data));
}


/* IsTransformFeedback: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsTransformFeedback(GLuint id)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsTransformFeedback");
   return CALL_IsTransformFeedback(ctx->CurrentServerDispatch, (id));
}


/* GetMemoryObjectParameterivEXT: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetMemoryObjectParameterivEXT(GLuint memoryObject, GLenum pname, GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetMemoryObjectParameterivEXT");
   CALL_GetMemoryObjectParameterivEXT(ctx->CurrentServerDispatch, (memoryObject, pname, params));
}


/* ClipPlanex: marshalled asynchronously */
struct marshal_cmd_ClipPlanex
{
   struct marshal_cmd_base cmd_base;
   GLenum plane;
   GLfixed equation[4];
};
static inline void
_mesa_unmarshal_ClipPlanex(struct gl_context *ctx, const struct marshal_cmd_ClipPlanex *cmd)
{
   const GLenum plane = cmd->plane;
   const GLfixed * equation = cmd->equation;
   CALL_ClipPlanex(ctx->CurrentServerDispatch, (plane, equation));
}
static void GLAPIENTRY
_mesa_marshal_ClipPlanex(GLenum plane, const GLfixed * equation)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClipPlanex);
   struct marshal_cmd_ClipPlanex *cmd;
   debug_print_marshal("ClipPlanex");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClipPlanex, cmd_size);
      cmd->plane = plane;
      memcpy(cmd->equation, equation, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClipPlanex");
   CALL_ClipPlanex(ctx->CurrentServerDispatch, (plane, equation));
}


/* GetLightfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetLightfv(GLenum light, GLenum pname, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetLightfv");
   CALL_GetLightfv(ctx->CurrentServerDispatch, (light, pname, params));
}


/* ClipPlanef: marshalled asynchronously */
struct marshal_cmd_ClipPlanef
{
   struct marshal_cmd_base cmd_base;
   GLenum plane;
   GLfloat equation[4];
};
static inline void
_mesa_unmarshal_ClipPlanef(struct gl_context *ctx, const struct marshal_cmd_ClipPlanef *cmd)
{
   const GLenum plane = cmd->plane;
   const GLfloat * equation = cmd->equation;
   CALL_ClipPlanef(ctx->CurrentServerDispatch, (plane, equation));
}
static void GLAPIENTRY
_mesa_marshal_ClipPlanef(GLenum plane, const GLfloat * equation)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ClipPlanef);
   struct marshal_cmd_ClipPlanef *cmd;
   debug_print_marshal("ClipPlanef");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ClipPlanef, cmd_size);
      cmd->plane = plane;
      memcpy(cmd->equation, equation, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ClipPlanef");
   CALL_ClipPlanef(ctx->CurrentServerDispatch, (plane, equation));
}


/* ProgramUniform1ui: marshalled asynchronously */
struct marshal_cmd_ProgramUniform1ui
{
   struct marshal_cmd_base cmd_base;
   GLuint program;
   GLint location;
   GLuint x;
};
static inline void
_mesa_unmarshal_ProgramUniform1ui(struct gl_context *ctx, const struct marshal_cmd_ProgramUniform1ui *cmd)
{
   const GLuint program = cmd->program;
   const GLint location = cmd->location;
   const GLuint x = cmd->x;
   CALL_ProgramUniform1ui(ctx->CurrentServerDispatch, (program, location, x));
}
static void GLAPIENTRY
_mesa_marshal_ProgramUniform1ui(GLuint program, GLint location, GLuint x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_ProgramUniform1ui);
   struct marshal_cmd_ProgramUniform1ui *cmd;
   debug_print_marshal("ProgramUniform1ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_ProgramUniform1ui, cmd_size);
      cmd->program = program;
      cmd->location = location;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("ProgramUniform1ui");
   CALL_ProgramUniform1ui(ctx->CurrentServerDispatch, (program, location, x));
}


/* SecondaryColorPointer: marshalled asynchronously */
struct marshal_cmd_SecondaryColorPointer
{
   struct marshal_cmd_base cmd_base;
   GLint size;
   GLenum type;
   GLsizei stride;
   const GLvoid * pointer;
};
static inline void
_mesa_unmarshal_SecondaryColorPointer(struct gl_context *ctx, const struct marshal_cmd_SecondaryColorPointer *cmd)
{
   const GLint size = cmd->size;
   const GLenum type = cmd->type;
   const GLsizei stride = cmd->stride;
   const GLvoid * pointer = cmd->pointer;
   CALL_SecondaryColorPointer(ctx->CurrentServerDispatch, (size, type, stride, pointer));
}
static void GLAPIENTRY
_mesa_marshal_SecondaryColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid * pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_SecondaryColorPointer);
   struct marshal_cmd_SecondaryColorPointer *cmd;
   debug_print_marshal("SecondaryColorPointer");
   if (_mesa_glthread_is_non_vbo_vertex_attrib_pointer(ctx)) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("SecondaryColorPointer");
      CALL_SecondaryColorPointer(ctx->CurrentServerDispatch, (size, type, stride, pointer));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_SecondaryColorPointer, cmd_size);
      cmd->size = size;
      cmd->type = type;
      cmd->stride = stride;
      cmd->pointer = pointer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("SecondaryColorPointer");
   CALL_SecondaryColorPointer(ctx->CurrentServerDispatch, (size, type, stride, pointer));
}


/* LineStipple: marshalled asynchronously */
struct marshal_cmd_LineStipple
{
   struct marshal_cmd_base cmd_base;
   GLint factor;
   GLushort pattern;
};
static inline void
_mesa_unmarshal_LineStipple(struct gl_context *ctx, const struct marshal_cmd_LineStipple *cmd)
{
   const GLint factor = cmd->factor;
   const GLushort pattern = cmd->pattern;
   CALL_LineStipple(ctx->CurrentServerDispatch, (factor, pattern));
}
static void GLAPIENTRY
_mesa_marshal_LineStipple(GLint factor, GLushort pattern)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_LineStipple);
   struct marshal_cmd_LineStipple *cmd;
   debug_print_marshal("LineStipple");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_LineStipple, cmd_size);
      cmd->factor = factor;
      cmd->pattern = pattern;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("LineStipple");
   CALL_LineStipple(ctx->CurrentServerDispatch, (factor, pattern));
}


/* BeginFragmentShaderATI: marshalled asynchronously */
struct marshal_cmd_BeginFragmentShaderATI
{
   struct marshal_cmd_base cmd_base;
};
static inline void
_mesa_unmarshal_BeginFragmentShaderATI(struct gl_context *ctx, const struct marshal_cmd_BeginFragmentShaderATI *cmd)
{
   CALL_BeginFragmentShaderATI(ctx->CurrentServerDispatch, ());
}
static void GLAPIENTRY
_mesa_marshal_BeginFragmentShaderATI(void)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BeginFragmentShaderATI);
   struct marshal_cmd_BeginFragmentShaderATI *cmd;
   debug_print_marshal("BeginFragmentShaderATI");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BeginFragmentShaderATI, cmd_size);
      (void) cmd;

      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BeginFragmentShaderATI");
   CALL_BeginFragmentShaderATI(ctx->CurrentServerDispatch, ());
}


/* GenRenderbuffers: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GenRenderbuffers(GLsizei n, GLuint * renderbuffers)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GenRenderbuffers");
   CALL_GenRenderbuffers(ctx->CurrentServerDispatch, (n, renderbuffers));
}


/* GetMinmaxParameterfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetMinmaxParameterfv(GLenum target, GLenum pname, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetMinmaxParameterfv");
   CALL_GetMinmaxParameterfv(ctx->CurrentServerDispatch, (target, pname, params));
}


/* TextureStorageMem2DEXT: marshalled asynchronously */
struct marshal_cmd_TextureStorageMem2DEXT
{
   struct marshal_cmd_base cmd_base;
   GLenum texture;
   GLsizei levels;
   GLenum internalFormat;
   GLsizei width;
   GLsizei height;
   GLuint memory;
   GLuint64 offset;
};
static inline void
_mesa_unmarshal_TextureStorageMem2DEXT(struct gl_context *ctx, const struct marshal_cmd_TextureStorageMem2DEXT *cmd)
{
   const GLenum texture = cmd->texture;
   const GLsizei levels = cmd->levels;
   const GLenum internalFormat = cmd->internalFormat;
   const GLsizei width = cmd->width;
   const GLsizei height = cmd->height;
   const GLuint memory = cmd->memory;
   const GLuint64 offset = cmd->offset;
   CALL_TextureStorageMem2DEXT(ctx->CurrentServerDispatch, (texture, levels, internalFormat, width, height, memory, offset));
}
static void GLAPIENTRY
_mesa_marshal_TextureStorageMem2DEXT(GLenum texture, GLsizei levels, GLenum internalFormat, GLsizei width, GLsizei height, GLuint memory, GLuint64 offset)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureStorageMem2DEXT);
   struct marshal_cmd_TextureStorageMem2DEXT *cmd;
   debug_print_marshal("TextureStorageMem2DEXT");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureStorageMem2DEXT, cmd_size);
      cmd->texture = texture;
      cmd->levels = levels;
      cmd->internalFormat = internalFormat;
      cmd->width = width;
      cmd->height = height;
      cmd->memory = memory;
      cmd->offset = offset;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureStorageMem2DEXT");
   CALL_TextureStorageMem2DEXT(ctx->CurrentServerDispatch, (texture, levels, internalFormat, width, height, memory, offset));
}


/* IsEnabledi: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsEnabledi(GLenum target, GLuint index)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsEnabledi");
   return CALL_IsEnabledi(ctx->CurrentServerDispatch, (target, index));
}


/* WaitSync: marshalled asynchronously */
struct marshal_cmd_WaitSync
{
   struct marshal_cmd_base cmd_base;
   GLsync sync;
   GLbitfield flags;
   GLuint64 timeout;
};
static inline void
_mesa_unmarshal_WaitSync(struct gl_context *ctx, const struct marshal_cmd_WaitSync *cmd)
{
   const GLsync sync = cmd->sync;
   const GLbitfield flags = cmd->flags;
   const GLuint64 timeout = cmd->timeout;
   CALL_WaitSync(ctx->CurrentServerDispatch, (sync, flags, timeout));
}
static void GLAPIENTRY
_mesa_marshal_WaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WaitSync);
   struct marshal_cmd_WaitSync *cmd;
   debug_print_marshal("WaitSync");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WaitSync, cmd_size);
      cmd->sync = sync;
      cmd->flags = flags;
      cmd->timeout = timeout;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WaitSync");
   CALL_WaitSync(ctx->CurrentServerDispatch, (sync, flags, timeout));
}


/* GetVertexAttribPointerv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetVertexAttribPointerv(GLuint index, GLenum pname, GLvoid ** pointer)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetVertexAttribPointerv");
   CALL_GetVertexAttribPointerv(ctx->CurrentServerDispatch, (index, pname, pointer));
}


/* Uniform1i64vARB: marshalled asynchronously */
struct marshal_cmd_Uniform1i64vARB
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLsizei count;
   /* Next safe_mul(count, 8) bytes are GLint64 value[count] */
};
static inline void
_mesa_unmarshal_Uniform1i64vARB(struct gl_context *ctx, const struct marshal_cmd_Uniform1i64vARB *cmd)
{
   const GLint location = cmd->location;
   const GLsizei count = cmd->count;
   const GLint64 * value;
   const char *variable_data = (const char *) (cmd + 1);
   value = (const GLint64 *) variable_data;
   variable_data += count * 8;
   CALL_Uniform1i64vARB(ctx->CurrentServerDispatch, (location, count, value));
}
static void GLAPIENTRY
_mesa_marshal_Uniform1i64vARB(GLint location, GLsizei count, const GLint64 * value)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform1i64vARB) + safe_mul(count, 8);
   struct marshal_cmd_Uniform1i64vARB *cmd;
   debug_print_marshal("Uniform1i64vARB");
   if (unlikely(safe_mul(count, 8) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform1i64vARB, cmd_size);
      cmd->location = location;
      cmd->count = count;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, value, count * 8);
      variable_data += count * 8;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform1i64vARB");
   CALL_Uniform1i64vARB(ctx->CurrentServerDispatch, (location, count, value));
}


/* CreatePerfQueryINTEL: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_CreatePerfQueryINTEL(GLuint queryId, GLuint * queryHandle)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("CreatePerfQueryINTEL");
   CALL_CreatePerfQueryINTEL(ctx->CurrentServerDispatch, (queryId, queryHandle));
}


/* NewList: marshalled asynchronously */
struct marshal_cmd_NewList
{
   struct marshal_cmd_base cmd_base;
   GLuint list;
   GLenum mode;
};
static inline void
_mesa_unmarshal_NewList(struct gl_context *ctx, const struct marshal_cmd_NewList *cmd)
{
   const GLuint list = cmd->list;
   const GLenum mode = cmd->mode;
   CALL_NewList(ctx->CurrentServerDispatch, (list, mode));
}
static void GLAPIENTRY
_mesa_marshal_NewList(GLuint list, GLenum mode)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_NewList);
   struct marshal_cmd_NewList *cmd;
   debug_print_marshal("NewList");
   if (true) {
      _mesa_glthread_finish(ctx);
      _mesa_glthread_restore_dispatch(ctx);
      debug_print_sync_fallback("NewList");
      CALL_NewList(ctx->CurrentServerDispatch, (list, mode));
      return;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_NewList, cmd_size);
      cmd->list = list;
      cmd->mode = mode;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("NewList");
   CALL_NewList(ctx->CurrentServerDispatch, (list, mode));
}


/* TexBuffer: marshalled asynchronously */
struct marshal_cmd_TexBuffer
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum internalFormat;
   GLuint buffer;
};
static inline void
_mesa_unmarshal_TexBuffer(struct gl_context *ctx, const struct marshal_cmd_TexBuffer *cmd)
{
   const GLenum target = cmd->target;
   const GLenum internalFormat = cmd->internalFormat;
   const GLuint buffer = cmd->buffer;
   CALL_TexBuffer(ctx->CurrentServerDispatch, (target, internalFormat, buffer));
}
static void GLAPIENTRY
_mesa_marshal_TexBuffer(GLenum target, GLenum internalFormat, GLuint buffer)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexBuffer);
   struct marshal_cmd_TexBuffer *cmd;
   debug_print_marshal("TexBuffer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexBuffer, cmd_size);
      cmd->target = target;
      cmd->internalFormat = internalFormat;
      cmd->buffer = buffer;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexBuffer");
   CALL_TexBuffer(ctx->CurrentServerDispatch, (target, internalFormat, buffer));
}


/* TexCoord4sv: marshalled asynchronously */
struct marshal_cmd_TexCoord4sv
{
   struct marshal_cmd_base cmd_base;
   GLshort v[4];
};
static inline void
_mesa_unmarshal_TexCoord4sv(struct gl_context *ctx, const struct marshal_cmd_TexCoord4sv *cmd)
{
   const GLshort * v = cmd->v;
   CALL_TexCoord4sv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord4sv(const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord4sv);
   struct marshal_cmd_TexCoord4sv *cmd;
   debug_print_marshal("TexCoord4sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord4sv, cmd_size);
      memcpy(cmd->v, v, 8);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord4sv");
   CALL_TexCoord4sv(ctx->CurrentServerDispatch, (v));
}


/* TexCoord1f: marshalled asynchronously */
struct marshal_cmd_TexCoord1f
{
   struct marshal_cmd_base cmd_base;
   GLfloat s;
};
static inline void
_mesa_unmarshal_TexCoord1f(struct gl_context *ctx, const struct marshal_cmd_TexCoord1f *cmd)
{
   const GLfloat s = cmd->s;
   CALL_TexCoord1f(ctx->CurrentServerDispatch, (s));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord1f(GLfloat s)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord1f);
   struct marshal_cmd_TexCoord1f *cmd;
   debug_print_marshal("TexCoord1f");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord1f, cmd_size);
      cmd->s = s;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord1f");
   CALL_TexCoord1f(ctx->CurrentServerDispatch, (s));
}


/* TexCoord1d: marshalled asynchronously */
struct marshal_cmd_TexCoord1d
{
   struct marshal_cmd_base cmd_base;
   GLdouble s;
};
static inline void
_mesa_unmarshal_TexCoord1d(struct gl_context *ctx, const struct marshal_cmd_TexCoord1d *cmd)
{
   const GLdouble s = cmd->s;
   CALL_TexCoord1d(ctx->CurrentServerDispatch, (s));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord1d(GLdouble s)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord1d);
   struct marshal_cmd_TexCoord1d *cmd;
   debug_print_marshal("TexCoord1d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord1d, cmd_size);
      cmd->s = s;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord1d");
   CALL_TexCoord1d(ctx->CurrentServerDispatch, (s));
}


/* TexCoord1i: marshalled asynchronously */
struct marshal_cmd_TexCoord1i
{
   struct marshal_cmd_base cmd_base;
   GLint s;
};
static inline void
_mesa_unmarshal_TexCoord1i(struct gl_context *ctx, const struct marshal_cmd_TexCoord1i *cmd)
{
   const GLint s = cmd->s;
   CALL_TexCoord1i(ctx->CurrentServerDispatch, (s));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord1i(GLint s)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord1i);
   struct marshal_cmd_TexCoord1i *cmd;
   debug_print_marshal("TexCoord1i");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord1i, cmd_size);
      cmd->s = s;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord1i");
   CALL_TexCoord1i(ctx->CurrentServerDispatch, (s));
}


/* GetnUniformfvARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnUniformfvARB(GLuint program, GLint location, GLsizei bufSize, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnUniformfvARB");
   CALL_GetnUniformfvARB(ctx->CurrentServerDispatch, (program, location, bufSize, params));
}


/* TexCoord1s: marshalled asynchronously */
struct marshal_cmd_TexCoord1s
{
   struct marshal_cmd_base cmd_base;
   GLshort s;
};
static inline void
_mesa_unmarshal_TexCoord1s(struct gl_context *ctx, const struct marshal_cmd_TexCoord1s *cmd)
{
   const GLshort s = cmd->s;
   CALL_TexCoord1s(ctx->CurrentServerDispatch, (s));
}
static void GLAPIENTRY
_mesa_marshal_TexCoord1s(GLshort s)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoord1s);
   struct marshal_cmd_TexCoord1s *cmd;
   debug_print_marshal("TexCoord1s");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoord1s, cmd_size);
      cmd->s = s;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoord1s");
   CALL_TexCoord1s(ctx->CurrentServerDispatch, (s));
}


/* Uniform1ui: marshalled asynchronously */
struct marshal_cmd_Uniform1ui
{
   struct marshal_cmd_base cmd_base;
   GLint location;
   GLuint x;
};
static inline void
_mesa_unmarshal_Uniform1ui(struct gl_context *ctx, const struct marshal_cmd_Uniform1ui *cmd)
{
   const GLint location = cmd->location;
   const GLuint x = cmd->x;
   CALL_Uniform1ui(ctx->CurrentServerDispatch, (location, x));
}
static void GLAPIENTRY
_mesa_marshal_Uniform1ui(GLint location, GLuint x)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Uniform1ui);
   struct marshal_cmd_Uniform1ui *cmd;
   debug_print_marshal("Uniform1ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Uniform1ui, cmd_size);
      cmd->location = location;
      cmd->x = x;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Uniform1ui");
   CALL_Uniform1ui(ctx->CurrentServerDispatch, (location, x));
}


/* TexStorage1D: marshalled asynchronously */
struct marshal_cmd_TexStorage1D
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLsizei levels;
   GLenum internalFormat;
   GLsizei width;
};
static inline void
_mesa_unmarshal_TexStorage1D(struct gl_context *ctx, const struct marshal_cmd_TexStorage1D *cmd)
{
   const GLenum target = cmd->target;
   const GLsizei levels = cmd->levels;
   const GLenum internalFormat = cmd->internalFormat;
   const GLsizei width = cmd->width;
   CALL_TexStorage1D(ctx->CurrentServerDispatch, (target, levels, internalFormat, width));
}
static void GLAPIENTRY
_mesa_marshal_TexStorage1D(GLenum target, GLsizei levels, GLenum internalFormat, GLsizei width)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexStorage1D);
   struct marshal_cmd_TexStorage1D *cmd;
   debug_print_marshal("TexStorage1D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexStorage1D, cmd_size);
      cmd->target = target;
      cmd->levels = levels;
      cmd->internalFormat = internalFormat;
      cmd->width = width;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexStorage1D");
   CALL_TexStorage1D(ctx->CurrentServerDispatch, (target, levels, internalFormat, width));
}


/* BlitFramebuffer: marshalled asynchronously */
struct marshal_cmd_BlitFramebuffer
{
   struct marshal_cmd_base cmd_base;
   GLint srcX0;
   GLint srcY0;
   GLint srcX1;
   GLint srcY1;
   GLint dstX0;
   GLint dstY0;
   GLint dstX1;
   GLint dstY1;
   GLbitfield mask;
   GLenum filter;
};
static inline void
_mesa_unmarshal_BlitFramebuffer(struct gl_context *ctx, const struct marshal_cmd_BlitFramebuffer *cmd)
{
   const GLint srcX0 = cmd->srcX0;
   const GLint srcY0 = cmd->srcY0;
   const GLint srcX1 = cmd->srcX1;
   const GLint srcY1 = cmd->srcY1;
   const GLint dstX0 = cmd->dstX0;
   const GLint dstY0 = cmd->dstY0;
   const GLint dstX1 = cmd->dstX1;
   const GLint dstY1 = cmd->dstY1;
   const GLbitfield mask = cmd->mask;
   const GLenum filter = cmd->filter;
   CALL_BlitFramebuffer(ctx->CurrentServerDispatch, (srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter));
}
static void GLAPIENTRY
_mesa_marshal_BlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BlitFramebuffer);
   struct marshal_cmd_BlitFramebuffer *cmd;
   debug_print_marshal("BlitFramebuffer");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BlitFramebuffer, cmd_size);
      cmd->srcX0 = srcX0;
      cmd->srcY0 = srcY0;
      cmd->srcX1 = srcX1;
      cmd->srcY1 = srcY1;
      cmd->dstX0 = dstX0;
      cmd->dstY0 = dstY0;
      cmd->dstX1 = dstX1;
      cmd->dstY1 = dstY1;
      cmd->mask = mask;
      cmd->filter = filter;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BlitFramebuffer");
   CALL_BlitFramebuffer(ctx->CurrentServerDispatch, (srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter));
}


/* TextureParameterf: marshalled asynchronously */
struct marshal_cmd_TextureParameterf
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLenum pname;
   GLfloat param;
};
static inline void
_mesa_unmarshal_TextureParameterf(struct gl_context *ctx, const struct marshal_cmd_TextureParameterf *cmd)
{
   const GLuint texture = cmd->texture;
   const GLenum pname = cmd->pname;
   const GLfloat param = cmd->param;
   CALL_TextureParameterf(ctx->CurrentServerDispatch, (texture, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_TextureParameterf(GLuint texture, GLenum pname, GLfloat param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureParameterf);
   struct marshal_cmd_TextureParameterf *cmd;
   debug_print_marshal("TextureParameterf");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureParameterf, cmd_size);
      cmd->texture = texture;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureParameterf");
   CALL_TextureParameterf(ctx->CurrentServerDispatch, (texture, pname, param));
}


/* FramebufferTexture1D: marshalled asynchronously */
struct marshal_cmd_FramebufferTexture1D
{
   struct marshal_cmd_base cmd_base;
   GLenum target;
   GLenum attachment;
   GLenum textarget;
   GLuint texture;
   GLint level;
};
static inline void
_mesa_unmarshal_FramebufferTexture1D(struct gl_context *ctx, const struct marshal_cmd_FramebufferTexture1D *cmd)
{
   const GLenum target = cmd->target;
   const GLenum attachment = cmd->attachment;
   const GLenum textarget = cmd->textarget;
   const GLuint texture = cmd->texture;
   const GLint level = cmd->level;
   CALL_FramebufferTexture1D(ctx->CurrentServerDispatch, (target, attachment, textarget, texture, level));
}
static void GLAPIENTRY
_mesa_marshal_FramebufferTexture1D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_FramebufferTexture1D);
   struct marshal_cmd_FramebufferTexture1D *cmd;
   debug_print_marshal("FramebufferTexture1D");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_FramebufferTexture1D, cmd_size);
      cmd->target = target;
      cmd->attachment = attachment;
      cmd->textarget = textarget;
      cmd->texture = texture;
      cmd->level = level;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("FramebufferTexture1D");
   CALL_FramebufferTexture1D(ctx->CurrentServerDispatch, (target, attachment, textarget, texture, level));
}


/* TextureParameteri: marshalled asynchronously */
struct marshal_cmd_TextureParameteri
{
   struct marshal_cmd_base cmd_base;
   GLuint texture;
   GLenum pname;
   GLint param;
};
static inline void
_mesa_unmarshal_TextureParameteri(struct gl_context *ctx, const struct marshal_cmd_TextureParameteri *cmd)
{
   const GLuint texture = cmd->texture;
   const GLenum pname = cmd->pname;
   const GLint param = cmd->param;
   CALL_TextureParameteri(ctx->CurrentServerDispatch, (texture, pname, param));
}
static void GLAPIENTRY
_mesa_marshal_TextureParameteri(GLuint texture, GLenum pname, GLint param)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TextureParameteri);
   struct marshal_cmd_TextureParameteri *cmd;
   debug_print_marshal("TextureParameteri");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TextureParameteri, cmd_size);
      cmd->texture = texture;
      cmd->pname = pname;
      cmd->param = param;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TextureParameteri");
   CALL_TextureParameteri(ctx->CurrentServerDispatch, (texture, pname, param));
}


/* GetMapiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetMapiv(GLenum target, GLenum query, GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetMapiv");
   CALL_GetMapiv(ctx->CurrentServerDispatch, (target, query, v));
}


/* GetUniformui64vARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetUniformui64vARB(GLuint program, GLint location, GLuint64 * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetUniformui64vARB");
   CALL_GetUniformui64vARB(ctx->CurrentServerDispatch, (program, location, params));
}


/* TexCoordP4ui: marshalled asynchronously */
struct marshal_cmd_TexCoordP4ui
{
   struct marshal_cmd_base cmd_base;
   GLenum type;
   GLuint coords;
};
static inline void
_mesa_unmarshal_TexCoordP4ui(struct gl_context *ctx, const struct marshal_cmd_TexCoordP4ui *cmd)
{
   const GLenum type = cmd->type;
   const GLuint coords = cmd->coords;
   CALL_TexCoordP4ui(ctx->CurrentServerDispatch, (type, coords));
}
static void GLAPIENTRY
_mesa_marshal_TexCoordP4ui(GLenum type, GLuint coords)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_TexCoordP4ui);
   struct marshal_cmd_TexCoordP4ui *cmd;
   debug_print_marshal("TexCoordP4ui");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_TexCoordP4ui, cmd_size);
      cmd->type = type;
      cmd->coords = coords;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("TexCoordP4ui");
   CALL_TexCoordP4ui(ctx->CurrentServerDispatch, (type, coords));
}


/* VertexAttrib1sv: marshalled asynchronously */
struct marshal_cmd_VertexAttrib1sv
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLshort v[1];
};
static inline void
_mesa_unmarshal_VertexAttrib1sv(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib1sv *cmd)
{
   const GLuint index = cmd->index;
   const GLshort * v = cmd->v;
   CALL_VertexAttrib1sv(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib1sv(GLuint index, const GLshort * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib1sv);
   struct marshal_cmd_VertexAttrib1sv *cmd;
   debug_print_marshal("VertexAttrib1sv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib1sv, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 2);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib1sv");
   CALL_VertexAttrib1sv(ctx->CurrentServerDispatch, (index, v));
}


/* WindowPos4dMESA: marshalled asynchronously */
struct marshal_cmd_WindowPos4dMESA
{
   struct marshal_cmd_base cmd_base;
   GLdouble x;
   GLdouble y;
   GLdouble z;
   GLdouble w;
};
static inline void
_mesa_unmarshal_WindowPos4dMESA(struct gl_context *ctx, const struct marshal_cmd_WindowPos4dMESA *cmd)
{
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   const GLdouble z = cmd->z;
   const GLdouble w = cmd->w;
   CALL_WindowPos4dMESA(ctx->CurrentServerDispatch, (x, y, z, w));
}
static void GLAPIENTRY
_mesa_marshal_WindowPos4dMESA(GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_WindowPos4dMESA);
   struct marshal_cmd_WindowPos4dMESA *cmd;
   debug_print_marshal("WindowPos4dMESA");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_WindowPos4dMESA, cmd_size);
      cmd->x = x;
      cmd->y = y;
      cmd->z = z;
      cmd->w = w;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("WindowPos4dMESA");
   CALL_WindowPos4dMESA(ctx->CurrentServerDispatch, (x, y, z, w));
}


/* Vertex3dv: marshalled asynchronously */
struct marshal_cmd_Vertex3dv
{
   struct marshal_cmd_base cmd_base;
   GLdouble v[3];
};
static inline void
_mesa_unmarshal_Vertex3dv(struct gl_context *ctx, const struct marshal_cmd_Vertex3dv *cmd)
{
   const GLdouble * v = cmd->v;
   CALL_Vertex3dv(ctx->CurrentServerDispatch, (v));
}
static void GLAPIENTRY
_mesa_marshal_Vertex3dv(const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_Vertex3dv);
   struct marshal_cmd_Vertex3dv *cmd;
   debug_print_marshal("Vertex3dv");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_Vertex3dv, cmd_size);
      memcpy(cmd->v, v, 24);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("Vertex3dv");
   CALL_Vertex3dv(ctx->CurrentServerDispatch, (v));
}


/* VertexAttribL2d: marshalled asynchronously */
struct marshal_cmd_VertexAttribL2d
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble x;
   GLdouble y;
};
static inline void
_mesa_unmarshal_VertexAttribL2d(struct gl_context *ctx, const struct marshal_cmd_VertexAttribL2d *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble x = cmd->x;
   const GLdouble y = cmd->y;
   CALL_VertexAttribL2d(ctx->CurrentServerDispatch, (index, x, y));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribL2d(GLuint index, GLdouble x, GLdouble y)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribL2d);
   struct marshal_cmd_VertexAttribL2d *cmd;
   debug_print_marshal("VertexAttribL2d");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribL2d, cmd_size);
      cmd->index = index;
      cmd->x = x;
      cmd->y = y;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribL2d");
   CALL_VertexAttribL2d(ctx->CurrentServerDispatch, (index, x, y));
}


/* GetnMapivARB: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetnMapivARB(GLenum target, GLenum query, GLsizei bufSize, GLint * v)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetnMapivARB");
   CALL_GetnMapivARB(ctx->CurrentServerDispatch, (target, query, bufSize, v));
}


/* GetVertexAttribfv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_GetVertexAttribfv(GLuint index, GLenum pname, GLfloat * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("GetVertexAttribfv");
   CALL_GetVertexAttribfv(ctx->CurrentServerDispatch, (index, pname, params));
}


/* MultiTexCoordP4uiv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_MultiTexCoordP4uiv(GLenum texture, GLenum type, const GLuint * coords)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("MultiTexCoordP4uiv");
   CALL_MultiTexCoordP4uiv(ctx->CurrentServerDispatch, (texture, type, coords));
}


/* TexGeniv: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_TexGeniv(GLenum coord, GLenum pname, const GLint * params)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("TexGeniv");
   CALL_TexGeniv(ctx->CurrentServerDispatch, (coord, pname, params));
}


/* IsMemoryObjectEXT: marshalled synchronously */
static GLboolean GLAPIENTRY
_mesa_marshal_IsMemoryObjectEXT(GLuint memoryObject)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("IsMemoryObjectEXT");
   return CALL_IsMemoryObjectEXT(ctx->CurrentServerDispatch, (memoryObject));
}


/* BlendColor: marshalled asynchronously */
struct marshal_cmd_BlendColor
{
   struct marshal_cmd_base cmd_base;
   GLclampf red;
   GLclampf green;
   GLclampf blue;
   GLclampf alpha;
};
static inline void
_mesa_unmarshal_BlendColor(struct gl_context *ctx, const struct marshal_cmd_BlendColor *cmd)
{
   const GLclampf red = cmd->red;
   const GLclampf green = cmd->green;
   const GLclampf blue = cmd->blue;
   const GLclampf alpha = cmd->alpha;
   CALL_BlendColor(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}
static void GLAPIENTRY
_mesa_marshal_BlendColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_BlendColor);
   struct marshal_cmd_BlendColor *cmd;
   debug_print_marshal("BlendColor");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_BlendColor, cmd_size);
      cmd->red = red;
      cmd->green = green;
      cmd->blue = blue;
      cmd->alpha = alpha;
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("BlendColor");
   CALL_BlendColor(ctx->CurrentServerDispatch, (red, green, blue, alpha));
}


/* VertexAttribs2dvNV: marshalled asynchronously */
struct marshal_cmd_VertexAttribs2dvNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLsizei n;
   /* Next safe_mul(n, 16) bytes are GLdouble v[n][2] */
};
static inline void
_mesa_unmarshal_VertexAttribs2dvNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttribs2dvNV *cmd)
{
   const GLuint index = cmd->index;
   const GLsizei n = cmd->n;
   const GLdouble * v;
   const char *variable_data = (const char *) (cmd + 1);
   v = (const GLdouble *) variable_data;
   variable_data += n * 16;
   CALL_VertexAttribs2dvNV(ctx->CurrentServerDispatch, (index, n, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttribs2dvNV(GLuint index, GLsizei n, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttribs2dvNV) + safe_mul(n, 16);
   struct marshal_cmd_VertexAttribs2dvNV *cmd;
   debug_print_marshal("VertexAttribs2dvNV");
   if (unlikely(safe_mul(n, 16) < 0)) {
      goto fallback_to_sync;
   }
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttribs2dvNV, cmd_size);
      cmd->index = index;
      cmd->n = n;
      char *variable_data = (char *) (cmd + 1);
      memcpy(variable_data, v, n * 16);
      variable_data += n * 16;
      _mesa_post_marshal_hook(ctx);
      return;
   }

fallback_to_sync:
   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttribs2dvNV");
   CALL_VertexAttribs2dvNV(ctx->CurrentServerDispatch, (index, n, v));
}


/* VertexAttrib2dvNV: marshalled asynchronously */
struct marshal_cmd_VertexAttrib2dvNV
{
   struct marshal_cmd_base cmd_base;
   GLuint index;
   GLdouble v[2];
};
static inline void
_mesa_unmarshal_VertexAttrib2dvNV(struct gl_context *ctx, const struct marshal_cmd_VertexAttrib2dvNV *cmd)
{
   const GLuint index = cmd->index;
   const GLdouble * v = cmd->v;
   CALL_VertexAttrib2dvNV(ctx->CurrentServerDispatch, (index, v));
}
static void GLAPIENTRY
_mesa_marshal_VertexAttrib2dvNV(GLuint index, const GLdouble * v)
{
   GET_CURRENT_CONTEXT(ctx);
   size_t cmd_size = sizeof(struct marshal_cmd_VertexAttrib2dvNV);
   struct marshal_cmd_VertexAttrib2dvNV *cmd;
   debug_print_marshal("VertexAttrib2dvNV");
   if (cmd_size <= MARSHAL_MAX_CMD_SIZE) {
      cmd = _mesa_glthread_allocate_command(ctx, DISPATCH_CMD_VertexAttrib2dvNV, cmd_size);
      cmd->index = index;
      memcpy(cmd->v, v, 16);
      _mesa_post_marshal_hook(ctx);
      return;
   }

   _mesa_glthread_finish(ctx);
   debug_print_sync_fallback("VertexAttrib2dvNV");
   CALL_VertexAttrib2dvNV(ctx->CurrentServerDispatch, (index, v));
}


/* NamedFramebufferDrawBuffers: marshalled synchronously */
static void GLAPIENTRY
_mesa_marshal_NamedFramebufferDrawBuffers(GLuint framebuffer, GLsizei n, const GLenum * bufs)
{
   GET_CURRENT_CONTEXT(ctx);
   _mesa_glthread_finish(ctx);
   debug_print_sync("NamedFramebufferDrawBuffers");
   CALL_NamedFramebufferDraw