/* DO NOT EDIT - This file generated automatically by gl_gentable.py (from Mesa) script */

/*
 * Copyright (C) 1999-2001  Brian Paul   All Rights Reserved.
 * (C) Copyright IBM Corporation 2004, 2005
 * (C) Copyright Apple Inc 2011
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL, IBM,
 * AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
 * OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* GLXEXT is the define used in the xserver when the GLX extension is being
 * built.  Hijack this to determine whether this file is being built for the
 * server or the client.
 */
#ifdef HAVE_DIX_CONFIG_H
#include <dix-config.h>
#endif

#if (defined(GLXEXT) && defined(HAVE_BACKTRACE)) \
	|| (!defined(GLXEXT) && defined(DEBUG) && !defined(__CYGWIN__) && !defined(__MINGW32__) && !defined(__OpenBSD__) && !defined(__NetBSD__) && !defined(__DragonFly__))
#define USE_BACKTRACE
#endif

#ifdef USE_BACKTRACE
#include <execinfo.h>
#endif

#ifndef _WIN32
#include <dlfcn.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "main/glheader.h"

#include "glapi.h"
#include "glapitable.h"

#ifdef GLXEXT
#include "os.h"
#endif

static void
__glapi_gentable_NoOp(void) {
    const char *fstr = "Unknown";

    /* Silence potential GCC warning for some #ifdef paths.
     */
    (void) fstr;
#if defined(USE_BACKTRACE)
#if !defined(GLXEXT)
    if (getenv("MESA_DEBUG") || getenv("LIBGL_DEBUG"))
#endif
    {
        void *frames[2];

        if(backtrace(frames, 2) == 2) {
            Dl_info info;
            dladdr(frames[1], &info);
            if(info.dli_sname)
                fstr = info.dli_sname;
        }

#if !defined(GLXEXT)
        fprintf(stderr, "Call to unimplemented API: %s\n", fstr);
#endif
    }
#endif
#if defined(GLXEXT)
    LogMessage(X_ERROR, "GLX: Call to unimplemented API: %s\n", fstr);
#endif
}

static void
__glapi_gentable_set_remaining_noop(struct _glapi_table *disp) {
    GLuint entries = _glapi_get_dispatch_table_size();
    void **dispatch = (void **) disp;
    unsigned i;

    /* ISO C is annoying sometimes */
    union {_glapi_proc p; void *v;} p;
    p.p = __glapi_gentable_NoOp;

    for(i=0; i < entries; i++)
        if(dispatch[i] == NULL)
            dispatch[i] = p.v;
}


#define GLAPI_TABLE_COUNT 1410
static const char * const _glapi_table_func_names[GLAPI_TABLE_COUNT] = {
    /*     0 */ "NewList",
    /*     1 */ "EndList",
    /*     2 */ "CallList",
    /*     3 */ "CallLists",
    /*     4 */ "DeleteLists",
    /*     5 */ "GenLists",
    /*     6 */ "ListBase",
    /*     7 */ "Begin",
    /*     8 */ "Bitmap",
    /*     9 */ "Color3b",
    /*    10 */ "Color3bv",
    /*    11 */ "Color3d",
    /*    12 */ "Color3dv",
    /*    13 */ "Color3f",
    /*    14 */ "Color3fv",
    /*    15 */ "Color3i",
    /*    16 */ "Color3iv",
    /*    17 */ "Color3s",
    /*    18 */ "Color3sv",
    /*    19 */ "Color3ub",
    /*    20 */ "Color3ubv",
    /*    21 */ "Color3ui",
    /*    22 */ "Color3uiv",
    /*    23 */ "Color3us",
    /*    24 */ "Color3usv",
    /*    25 */ "Color4b",
    /*    26 */ "Color4bv",
    /*    27 */ "Color4d",
    /*    28 */ "Color4dv",
    /*    29 */ "Color4f",
    /*    30 */ "Color4fv",
    /*    31 */ "Color4i",
    /*    32 */ "Color4iv",
    /*    33 */ "Color4s",
    /*    34 */ "Color4sv",
    /*    35 */ "Color4ub",
    /*    36 */ "Color4ubv",
    /*    37 */ "Color4ui",
    /*    38 */ "Color4uiv",
    /*    39 */ "Color4us",
    /*    40 */ "Color4usv",
    /*    41 */ "EdgeFlag",
    /*    42 */ "EdgeFlagv",
    /*    43 */ "End",
    /*    44 */ "Indexd",
    /*    45 */ "Indexdv",
    /*    46 */ "Indexf",
    /*    47 */ "Indexfv",
    /*    48 */ "Indexi",
    /*    49 */ "Indexiv",
    /*    50 */ "Indexs",
    /*    51 */ "Indexsv",
    /*    52 */ "Normal3b",
    /*    53 */ "Normal3bv",
    /*    54 */ "Normal3d",
    /*    55 */ "Normal3dv",
    /*    56 */ "Normal3f",
    /*    57 */ "Normal3fv",
    /*    58 */ "Normal3i",
    /*    59 */ "Normal3iv",
    /*    60 */ "Normal3s",
    /*    61 */ "Normal3sv",
    /*    62 */ "RasterPos2d",
    /*    63 */ "RasterPos2dv",
    /*    64 */ "RasterPos2f",
    /*    65 */ "RasterPos2fv",
    /*    66 */ "RasterPos2i",
    /*    67 */ "RasterPos2iv",
    /*    68 */ "RasterPos2s",
    /*    69 */ "RasterPos2sv",
    /*    70 */ "RasterPos3d",
    /*    71 */ "RasterPos3dv",
    /*    72 */ "RasterPos3f",
    /*    73 */ "RasterPos3fv",
    /*    74 */ "RasterPos3i",
    /*    75 */ "RasterPos3iv",
    /*    76 */ "RasterPos3s",
    /*    77 */ "RasterPos3sv",
    /*    78 */ "RasterPos4d",
    /*    79 */ "RasterPos4dv",
    /*    80 */ "RasterPos4f",
    /*    81 */ "RasterPos4fv",
    /*    82 */ "RasterPos4i",
    /*    83 */ "RasterPos4iv",
    /*    84 */ "RasterPos4s",
    /*    85 */ "RasterPos4sv",
    /*    86 */ "Rectd",
    /*    87 */ "Rectdv",
    /*    88 */ "Rectf",
    /*    89 */ "Rectfv",
    /*    90 */ "Recti",
    /*    91 */ "Rectiv",
    /*    92 */ "Rects",
    /*    93 */ "Rectsv",
    /*    94 */ "TexCoord1d",
    /*    95 */ "TexCoord1dv",
    /*    96 */ "TexCoord1f",
    /*    97 */ "TexCoord1fv",
    /*    98 */ "TexCoord1i",
    /*    99 */ "TexCoord1iv",
    /*   100 */ "TexCoord1s",
    /*   101 */ "TexCoord1sv",
    /*   102 */ "TexCoord2d",
    /*   103 */ "TexCoord2dv",
    /*   104 */ "TexCoord2f",
    /*   105 */ "TexCoord2fv",
    /*   106 */ "TexCoord2i",
    /*   107 */ "TexCoord2iv",
    /*   108 */ "TexCoord2s",
    /*   109 */ "TexCoord2sv",
    /*   110 */ "TexCoord3d",
    /*   111 */ "TexCoord3dv",
    /*   112 */ "TexCoord3f",
    /*   113 */ "TexCoord3fv",
    /*   114 */ "TexCoord3i",
    /*   115 */ "TexCoord3iv",
    /*   116 */ "TexCoord3s",
    /*   117 */ "TexCoord3sv",
    /*   118 */ "TexCoord4d",
    /*   119 */ "TexCoord4dv",
    /*   120 */ "TexCoord4f",
    /*   121 */ "TexCoord4fv",
    /*   122 */ "TexCoord4i",
    /*   123 */ "TexCoord4iv",
    /*   124 */ "TexCoord4s",
    /*   125 */ "TexCoord4sv",
    /*   126 */ "Vertex2d",
    /*   127 */ "Vertex2dv",
    /*   128 */ "Vertex2f",
    /*   129 */ "Vertex2fv",
    /*   130 */ "Vertex2i",
    /*   131 */ "Vertex2iv",
    /*   132 */ "Vertex2s",
    /*   133 */ "Vertex2sv",
    /*   134 */ "Vertex3d",
    /*   135 */ "Vertex3dv",
    /*   136 */ "Vertex3f",
    /*   137 */ "Vertex3fv",
    /*   138 */ "Vertex3i",
    /*   139 */ "Vertex3iv",
    /*   140 */ "Vertex3s",
    /*   141 */ "Vertex3sv",
    /*   142 */ "Vertex4d",
    /*   143 */ "Vertex4dv",
    /*   144 */ "Vertex4f",
    /*   145 */ "Vertex4fv",
    /*   146 */ "Vertex4i",
    /*   147 */ "Vertex4iv",
    /*   148 */ "Vertex4s",
    /*   149 */ "Vertex4sv",
    /*   150 */ "ClipPlane",
    /*   151 */ "ColorMaterial",
    /*   152 */ "CullFace",
    /*   153 */ "Fogf",
    /*   154 */ "Fogfv",
    /*   155 */ "Fogi",
    /*   156 */ "Fogiv",
    /*   157 */ "FrontFace",
    /*   158 */ "Hint",
    /*   159 */ "Lightf",
    /*   160 */ "Lightfv",
    /*   161 */ "Lighti",
    /*   162 */ "Lightiv",
    /*   163 */ "LightModelf",
    /*   164 */ "LightModelfv",
    /*   165 */ "LightModeli",
    /*   166 */ "LightModeliv",
    /*   167 */ "LineStipple",
    /*   168 */ "LineWidth",
    /*   169 */ "Materialf",
    /*   170 */ "Materialfv",
    /*   171 */ "Materiali",
    /*   172 */ "Materialiv",
    /*   173 */ "PointSize",
    /*   174 */ "PolygonMode",
    /*   175 */ "PolygonStipple",
    /*   176 */ "Scissor",
    /*   177 */ "ShadeModel",
    /*   178 */ "TexParameterf",
    /*   179 */ "TexParameterfv",
    /*   180 */ "TexParameteri",
    /*   181 */ "TexParameteriv",
    /*   182 */ "TexImage1D",
    /*   183 */ "TexImage2D",
    /*   184 */ "TexEnvf",
    /*   185 */ "TexEnvfv",
    /*   186 */ "TexEnvi",
    /*   187 */ "TexEnviv",
    /*   188 */ "TexGend",
    /*   189 */ "TexGendv",
    /*   190 */ "TexGenf",
    /*   191 */ "TexGenfv",
    /*   192 */ "TexGeni",
    /*   193 */ "TexGeniv",
    /*   194 */ "FeedbackBuffer",
    /*   195 */ "SelectBuffer",
    /*   196 */ "RenderMode",
    /*   197 */ "InitNames",
    /*   198 */ "LoadName",
    /*   199 */ "PassThrough",
    /*   200 */ "PopName",
    /*   201 */ "PushName",
    /*   202 */ "DrawBuffer",
    /*   203 */ "Clear",
    /*   204 */ "ClearAccum",
    /*   205 */ "ClearIndex",
    /*   206 */ "ClearColor",
    /*   207 */ "ClearStencil",
    /*   208 */ "ClearDepth",
    /*   209 */ "StencilMask",
    /*   210 */ "ColorMask",
    /*   211 */ "DepthMask",
    /*   212 */ "IndexMask",
    /*   213 */ "Accum",
    /*   214 */ "Disable",
    /*   215 */ "Enable",
    /*   216 */ "Finish",
    /*   217 */ "Flush",
    /*   218 */ "PopAttrib",
    /*   219 */ "PushAttrib",
    /*   220 */ "Map1d",
    /*   221 */ "Map1f",
    /*   222 */ "Map2d",
    /*   223 */ "Map2f",
    /*   224 */ "MapGrid1d",
    /*   225 */ "MapGrid1f",
    /*   226 */ "MapGrid2d",
    /*   227 */ "MapGrid2f",
    /*   228 */ "EvalCoord1d",
    /*   229 */ "EvalCoord1dv",
    /*   230 */ "EvalCoord1f",
    /*   231 */ "EvalCoord1fv",
    /*   232 */ "EvalCoord2d",
    /*   233 */ "EvalCoord2dv",
    /*   234 */ "EvalCoord2f",
    /*   235 */ "EvalCoord2fv",
    /*   236 */ "EvalMesh1",
    /*   237 */ "EvalPoint1",
    /*   238 */ "EvalMesh2",
    /*   239 */ "EvalPoint2",
    /*   240 */ "AlphaFunc",
    /*   241 */ "BlendFunc",
    /*   242 */ "LogicOp",
    /*   243 */ "StencilFunc",
    /*   244 */ "StencilOp",
    /*   245 */ "DepthFunc",
    /*   246 */ "PixelZoom",
    /*   247 */ "PixelTransferf",
    /*   248 */ "PixelTransferi",
    /*   249 */ "PixelStoref",
    /*   250 */ "PixelStorei",
    /*   251 */ "PixelMapfv",
    /*   252 */ "PixelMapuiv",
    /*   253 */ "PixelMapusv",
    /*   254 */ "ReadBuffer",
    /*   255 */ "CopyPixels",
    /*   256 */ "ReadPixels",
    /*   257 */ "DrawPixels",
    /*   258 */ "GetBooleanv",
    /*   259 */ "GetClipPlane",
    /*   260 */ "GetDoublev",
    /*   261 */ "GetError",
    /*   262 */ "GetFloatv",
    /*   263 */ "GetIntegerv",
    /*   264 */ "GetLightfv",
    /*   265 */ "GetLightiv",
    /*   266 */ "GetMapdv",
    /*   267 */ "GetMapfv",
    /*   268 */ "GetMapiv",
    /*   269 */ "GetMaterialfv",
    /*   270 */ "GetMaterialiv",
    /*   271 */ "GetPixelMapfv",
    /*   272 */ "GetPixelMapuiv",
    /*   273 */ "GetPixelMapusv",
    /*   274 */ "GetPolygonStipple",
    /*   275 */ "GetString",
    /*   276 */ "GetTexEnvfv",
    /*   277 */ "GetTexEnviv",
    /*   278 */ "GetTexGendv",
    /*   279 */ "GetTexGenfv",
    /*   280 */ "GetTexGeniv",
    /*   281 */ "GetTexImage",
    /*   282 */ "GetTexParameterfv",
    /*   283 */ "GetTexParameteriv",
    /*   284 */ "GetTexLevelParameterfv",
    /*   285 */ "GetTexLevelParameteriv",
    /*   286 */ "IsEnabled",
    /*   287 */ "IsList",
    /*   288 */ "DepthRange",
    /*   289 */ "Frustum",
    /*   290 */ "LoadIdentity",
    /*   291 */ "LoadMatrixf",
    /*   292 */ "LoadMatrixd",
    /*   293 */ "MatrixMode",
    /*   294 */ "MultMatrixf",
    /*   295 */ "MultMatrixd",
    /*   296 */ "Ortho",
    /*   297 */ "PopMatrix",
    /*   298 */ "PushMatrix",
    /*   299 */ "Rotated",
    /*   300 */ "Rotatef",
    /*   301 */ "Scaled",
    /*   302 */ "Scalef",
    /*   303 */ "Translated",
    /*   304 */ "Translatef",
    /*   305 */ "Viewport",
    /*   306 */ "ArrayElement",
    /*   307 */ "BindTexture",
    /*   308 */ "ColorPointer",
    /*   309 */ "DisableClientState",
    /*   310 */ "DrawArrays",
    /*   311 */ "DrawElements",
    /*   312 */ "EdgeFlagPointer",
    /*   313 */ "EnableClientState",
    /*   314 */ "IndexPointer",
    /*   315 */ "Indexub",
    /*   316 */ "Indexubv",
    /*   317 */ "InterleavedArrays",
    /*   318 */ "NormalPointer",
    /*   319 */ "PolygonOffset",
    /*   320 */ "TexCoordPointer",
    /*   321 */ "VertexPointer",
    /*   322 */ "AreTexturesResident",
    /*   323 */ "CopyTexImage1D",
    /*   324 */ "CopyTexImage2D",
    /*   325 */ "CopyTexSubImage1D",
    /*   326 */ "CopyTexSubImage2D",
    /*   327 */ "DeleteTextures",
    /*   328 */ "GenTextures",
    /*   329 */ "GetPointerv",
    /*   330 */ "IsTexture",
    /*   331 */ "PrioritizeTextures",
    /*   332 */ "TexSubImage1D",
    /*   333 */ "TexSubImage2D",
    /*   334 */ "PopClientAttrib",
    /*   335 */ "PushClientAttrib",
    /*   336 */ "BlendColor",
    /*   337 */ "BlendEquation",
    /*   338 */ "DrawRangeElements",
    /*   339 */ "ColorTable",
    /*   340 */ "ColorTableParameterfv",
    /*   341 */ "ColorTableParameteriv",
    /*   342 */ "CopyColorTable",
    /*   343 */ "GetColorTable",
    /*   344 */ "GetColorTableParameterfv",
    /*   345 */ "GetColorTableParameteriv",
    /*   346 */ "ColorSubTable",
    /*   347 */ "CopyColorSubTable",
    /*   348 */ "ConvolutionFilter1D",
    /*   349 */ "ConvolutionFilter2D",
    /*   350 */ "ConvolutionParameterf",
    /*   351 */ "ConvolutionParameterfv",
    /*   352 */ "ConvolutionParameteri",
    /*   353 */ "ConvolutionParameteriv",
    /*   354 */ "CopyConvolutionFilter1D",
    /*   355 */ "CopyConvolutionFilter2D",
    /*   356 */ "GetConvolutionFilter",
    /*   357 */ "GetConvolutionParameterfv",
    /*   358 */ "GetConvolutionParameteriv",
    /*   359 */ "GetSeparableFilter",
    /*   360 */ "SeparableFilter2D",
    /*   361 */ "GetHistogram",
    /*   362 */ "GetHistogramParameterfv",
    /*   363 */ "GetHistogramParameteriv",
    /*   364 */ "GetMinmax",
    /*   365 */ "GetMinmaxParameterfv",
    /*   366 */ "GetMinmaxParameteriv",
    /*   367 */ "Histogram",
    /*   368 */ "Minmax",
    /*   369 */ "ResetHistogram",
    /*   370 */ "ResetMinmax",
    /*   371 */ "TexImage3D",
    /*   372 */ "TexSubImage3D",
    /*   373 */ "CopyTexSubImage3D",
    /*   374 */ "ActiveTexture",
    /*   375 */ "ClientActiveTexture",
    /*   376 */ "MultiTexCoord1d",
    /*   377 */ "MultiTexCoord1dv",
    /*   378 */ "MultiTexCoord1fARB",
    /*   379 */ "MultiTexCoord1fvARB",
    /*   380 */ "MultiTexCoord1i",
    /*   381 */ "MultiTexCoord1iv",
    /*   382 */ "MultiTexCoord1s",
    /*   383 */ "MultiTexCoord1sv",
    /*   384 */ "MultiTexCoord2d",
    /*   385 */ "MultiTexCoord2dv",
    /*   386 */ "MultiTexCoord2fARB",
    /*   387 */ "MultiTexCoord2fvARB",
    /*   388 */ "MultiTexCoord2i",
    /*   389 */ "MultiTexCoord2iv",
    /*   390 */ "MultiTexCoord2s",
    /*   391 */ "MultiTexCoord2sv",
    /*   392 */ "MultiTexCoord3d",
    /*   393 */ "MultiTexCoord3dv",
    /*   394 */ "MultiTexCoord3fARB",
    /*   395 */ "MultiTexCoord3fvARB",
    /*   396 */ "MultiTexCoord3i",
    /*   397 */ "MultiTexCoord3iv",
    /*   398 */ "MultiTexCoord3s",
    /*   399 */ "MultiTexCoord3sv",
    /*   400 */ "MultiTexCoord4d",
    /*   401 */ "MultiTexCoord4dv",
    /*   402 */ "MultiTexCoord4fARB",
    /*   403 */ "MultiTexCoord4fvARB",
    /*   404 */ "MultiTexCoord4i",
    /*   405 */ "MultiTexCoord4iv",
    /*   406 */ "MultiTexCoord4s",
    /*   407 */ "MultiTexCoord4sv",
    /*   408 */ "CompressedTexImage1D",
    /*   409 */ "CompressedTexImage2D",
    /*   410 */ "CompressedTexImage3D",
    /*   411 */ "CompressedTexSubImage1D",
    /*   412 */ "CompressedTexSubImage2D",
    /*   413 */ "CompressedTexSubImage3D",
    /*   414 */ "GetCompressedTexImage",
    /*   415 */ "LoadTransposeMatrixd",
    /*   416 */ "LoadTransposeMatrixf",
    /*   417 */ "MultTransposeMatrixd",
    /*   418 */ "MultTransposeMatrixf",
    /*   419 */ "SampleCoverage",
    /*   420 */ "BlendFuncSeparate",
    /*   421 */ "FogCoordPointer",
    /*   422 */ "FogCoordd",
    /*   423 */ "FogCoorddv",
    /*   424 */ "MultiDrawArrays",
    /*   425 */ "PointParameterf",
    /*   426 */ "PointParameterfv",
    /*   427 */ "PointParameteri",
    /*   428 */ "PointParameteriv",
    /*   429 */ "SecondaryColor3b",
    /*   430 */ "SecondaryColor3bv",
    /*   431 */ "SecondaryColor3d",
    /*   432 */ "SecondaryColor3dv",
    /*   433 */ "SecondaryColor3i",
    /*   434 */ "SecondaryColor3iv",
    /*   435 */ "SecondaryColor3s",
    /*   436 */ "SecondaryColor3sv",
    /*   437 */ "SecondaryColor3ub",
    /*   438 */ "SecondaryColor3ubv",
    /*   439 */ "SecondaryColor3ui",
    /*   440 */ "SecondaryColor3uiv",
    /*   441 */ "SecondaryColor3us",
    /*   442 */ "SecondaryColor3usv",
    /*   443 */ "SecondaryColorPointer",
    /*   444 */ "WindowPos2d",
    /*   445 */ "WindowPos2dv",
    /*   446 */ "WindowPos2f",
    /*   447 */ "WindowPos2fv",
    /*   448 */ "WindowPos2i",
    /*   449 */ "WindowPos2iv",
    /*   450 */ "WindowPos2s",
    /*   451 */ "WindowPos2sv",
    /*   452 */ "WindowPos3d",
    /*   453 */ "WindowPos3dv",
    /*   454 */ "WindowPos3f",
    /*   455 */ "WindowPos3fv",
    /*   456 */ "WindowPos3i",
    /*   457 */ "WindowPos3iv",
    /*   458 */ "WindowPos3s",
    /*   459 */ "WindowPos3sv",
    /*   460 */ "BeginQuery",
    /*   461 */ "BindBuffer",
    /*   462 */ "BufferData",
    /*   463 */ "BufferSubData",
    /*   464 */ "DeleteBuffers",
    /*   465 */ "DeleteQueries",
    /*   466 */ "EndQuery",
    /*   467 */ "GenBuffers",
    /*   468 */ "GenQueries",
    /*   469 */ "GetBufferParameteriv",
    /*   470 */ "GetBufferPointerv",
    /*   471 */ "GetBufferSubData",
    /*   472 */ "GetQueryObjectiv",
    /*   473 */ "GetQueryObjectuiv",
    /*   474 */ "GetQueryiv",
    /*   475 */ "IsBuffer",
    /*   476 */ "IsQuery",
    /*   477 */ "MapBuffer",
    /*   478 */ "UnmapBuffer",
    /*   479 */ "AttachShader",
    /*   480 */ "BindAttribLocation",
    /*   481 */ "BlendEquationSeparate",
    /*   482 */ "CompileShader",
    /*   483 */ "CreateProgram",
    /*   484 */ "CreateShader",
    /*   485 */ "DeleteProgram",
    /*   486 */ "DeleteShader",
    /*   487 */ "DetachShader",
    /*   488 */ "DisableVertexAttribArray",
    /*   489 */ "DrawBuffers",
    /*   490 */ "EnableVertexAttribArray",
    /*   491 */ "GetActiveAttrib",
    /*   492 */ "GetActiveUniform",
    /*   493 */ "GetAttachedShaders",
    /*   494 */ "GetAttribLocation",
    /*   495 */ "GetProgramInfoLog",
    /*   496 */ "GetProgramiv",
    /*   497 */ "GetShaderInfoLog",
    /*   498 */ "GetShaderSource",
    /*   499 */ "GetShaderiv",
    /*   500 */ "GetUniformLocation",
    /*   501 */ "GetUniformfv",
    /*   502 */ "GetUniformiv",
    /*   503 */ "GetVertexAttribPointerv",
    /*   504 */ "GetVertexAttribdv",
    /*   505 */ "GetVertexAttribfv",
    /*   506 */ "GetVertexAttribiv",
    /*   507 */ "IsProgram",
    /*   508 */ "IsShader",
    /*   509 */ "LinkProgram",
    /*   510 */ "ShaderSource",
    /*   511 */ "StencilFuncSeparate",
    /*   512 */ "StencilMaskSeparate",
    /*   513 */ "StencilOpSeparate",
    /*   514 */ "Uniform1f",
    /*   515 */ "Uniform1fv",
    /*   516 */ "Uniform1i",
    /*   517 */ "Uniform1iv",
    /*   518 */ "Uniform2f",
    /*   519 */ "Uniform2fv",
    /*   520 */ "Uniform2i",
    /*   521 */ "Uniform2iv",
    /*   522 */ "Uniform3f",
    /*   523 */ "Uniform3fv",
    /*   524 */ "Uniform3i",
    /*   525 */ "Uniform3iv",
    /*   526 */ "Uniform4f",
    /*   527 */ "Uniform4fv",
    /*   528 */ "Uniform4i",
    /*   529 */ "Uniform4iv",
    /*   530 */ "UniformMatrix2fv",
    /*   531 */ "UniformMatrix3fv",
    /*   532 */ "UniformMatrix4fv",
    /*   533 */ "UseProgram",
    /*   534 */ "ValidateProgram",
    /*   535 */ "VertexAttrib1d",
    /*   536 */ "VertexAttrib1dv",
    /*   537 */ "VertexAttrib1s",
    /*   538 */ "VertexAttrib1sv",
    /*   539 */ "VertexAttrib2d",
    /*   540 */ "VertexAttrib2dv",
    /*   541 */ "VertexAttrib2s",
    /*   542 */ "VertexAttrib2sv",
    /*   543 */ "VertexAttrib3d",
    /*   544 */ "VertexAttrib3dv",
    /*   545 */ "VertexAttrib3s",
    /*   546 */ "VertexAttrib3sv",
    /*   547 */ "VertexAttrib4Nbv",
    /*   548 */ "VertexAttrib4Niv",
    /*   549 */ "VertexAttrib4Nsv",
    /*   550 */ "VertexAttrib4Nub",
    /*   551 */ "VertexAttrib4Nubv",
    /*   552 */ "VertexAttrib4Nuiv",
    /*   553 */ "VertexAttrib4Nusv",
    /*   554 */ "VertexAttrib4bv",
    /*   555 */ "VertexAttrib4d",
    /*   556 */ "VertexAttrib4dv",
    /*   557 */ "VertexAttrib4iv",
    /*   558 */ "VertexAttrib4s",
    /*   559 */ "VertexAttrib4sv",
    /*   560 */ "VertexAttrib4ubv",
    /*   561 */ "VertexAttrib4uiv",
    /*   562 */ "VertexAttrib4usv",
    /*   563 */ "VertexAttribPointer",
    /*   564 */ "UniformMatrix2x3fv",
    /*   565 */ "UniformMatrix2x4fv",
    /*   566 */ "UniformMatrix3x2fv",
    /*   567 */ "UniformMatrix3x4fv",
    /*   568 */ "UniformMatrix4x2fv",
    /*   569 */ "UniformMatrix4x3fv",
    /*   570 */ "BeginConditionalRender",
    /*   571 */ "BeginTransformFeedback",
    /*   572 */ "BindBufferBase",
    /*   573 */ "BindBufferRange",
    /*   574 */ "BindFragDataLocation",
    /*   575 */ "ClampColor",
    /*   576 */ "ClearBufferfi",
    /*   577 */ "ClearBufferfv",
    /*   578 */ "ClearBufferiv",
    /*   579 */ "ClearBufferuiv",
    /*   580 */ "ColorMaski",
    /*   581 */ "Disablei",
    /*   582 */ "Enablei",
    /*   583 */ "EndConditionalRender",
    /*   584 */ "EndTransformFeedback",
    /*   585 */ "GetBooleani_v",
    /*   586 */ "GetFragDataLocation",
    /*   587 */ "GetIntegeri_v",
    /*   588 */ "GetStringi",
    /*   589 */ "GetTexParameterIiv",
    /*   590 */ "GetTexParameterIuiv",
    /*   591 */ "GetTransformFeedbackVarying",
    /*   592 */ "GetUniformuiv",
    /*   593 */ "GetVertexAttribIiv",
    /*   594 */ "GetVertexAttribIuiv",
    /*   595 */ "IsEnabledi",
    /*   596 */ "TexParameterIiv",
    /*   597 */ "TexParameterIuiv",
    /*   598 */ "TransformFeedbackVaryings",
    /*   599 */ "Uniform1ui",
    /*   600 */ "Uniform1uiv",
    /*   601 */ "Uniform2ui",
    /*   602 */ "Uniform2uiv",
    /*   603 */ "Uniform3ui",
    /*   604 */ "Uniform3uiv",
    /*   605 */ "Uniform4ui",
    /*   606 */ "Uniform4uiv",
    /*   607 */ "VertexAttribI1iv",
    /*   608 */ "VertexAttribI1uiv",
    /*   609 */ "VertexAttribI4bv",
    /*   610 */ "VertexAttribI4sv",
    /*   611 */ "VertexAttribI4ubv",
    /*   612 */ "VertexAttribI4usv",
    /*   613 */ "VertexAttribIPointer",
    /*   614 */ "PrimitiveRestartIndex",
    /*   615 */ "TexBuffer",
    /*   616 */ "FramebufferTexture",
    /*   617 */ "GetBufferParameteri64v",
    /*   618 */ "GetInteger64i_v",
    /*   619 */ "VertexAttribDivisor",
    /*   620 */ "MinSampleShading",
    /*   621 */ "MemoryBarrierByRegion",
    /*   622 */ "BindProgramARB",
    /*   623 */ "DeleteProgramsARB",
    /*   624 */ "GenProgramsARB",
    /*   625 */ "GetProgramEnvParameterdvARB",
    /*   626 */ "GetProgramEnvParameterfvARB",
    /*   627 */ "GetProgramLocalParameterdvARB",
    /*   628 */ "GetProgramLocalParameterfvARB",
    /*   629 */ "GetProgramStringARB",
    /*   630 */ "GetProgramivARB",
    /*   631 */ "IsProgramARB",
    /*   632 */ "ProgramEnvParameter4dARB",
    /*   633 */ "ProgramEnvParameter4dvARB",
    /*   634 */ "ProgramEnvParameter4fARB",
    /*   635 */ "ProgramEnvParameter4fvARB",
    /*   636 */ "ProgramLocalParameter4dARB",
    /*   637 */ "ProgramLocalParameter4dvARB",
    /*   638 */ "ProgramLocalParameter4fARB",
    /*   639 */ "ProgramLocalParameter4fvARB",
    /*   640 */ "ProgramStringARB",
    /*   641 */ "VertexAttrib1fARB",
    /*   642 */ "VertexAttrib1fvARB",
    /*   643 */ "VertexAttrib2fARB",
    /*   644 */ "VertexAttrib2fvARB",
    /*   645 */ "VertexAttrib3fARB",
    /*   646 */ "VertexAttrib3fvARB",
    /*   647 */ "VertexAttrib4fARB",
    /*   648 */ "VertexAttrib4fvARB",
    /*   649 */ "AttachObjectARB",
    /*   650 */ "CreateProgramObjectARB",
    /*   651 */ "CreateShaderObjectARB",
    /*   652 */ "DeleteObjectARB",
    /*   653 */ "DetachObjectARB",
    /*   654 */ "GetAttachedObjectsARB",
    /*   655 */ "GetHandleARB",
    /*   656 */ "GetInfoLogARB",
    /*   657 */ "GetObjectParameterfvARB",
    /*   658 */ "GetObjectParameterivARB",
    /*   659 */ "DrawArraysInstancedARB",
    /*   660 */ "DrawElementsInstancedARB",
    /*   661 */ "BindFramebuffer",
    /*   662 */ "BindRenderbuffer",
    /*   663 */ "BlitFramebuffer",
    /*   664 */ "CheckFramebufferStatus",
    /*   665 */ "DeleteFramebuffers",
    /*   666 */ "DeleteRenderbuffers",
    /*   667 */ "FramebufferRenderbuffer",
    /*   668 */ "FramebufferTexture1D",
    /*   669 */ "FramebufferTexture2D",
    /*   670 */ "FramebufferTexture3D",
    /*   671 */ "FramebufferTextureLayer",
    /*   672 */ "GenFramebuffers",
    /*   673 */ "GenRenderbuffers",
    /*   674 */ "GenerateMipmap",
    /*   675 */ "GetFramebufferAttachmentParameteriv",
    /*   676 */ "GetRenderbufferParameteriv",
    /*   677 */ "IsFramebuffer",
    /*   678 */ "IsRenderbuffer",
    /*   679 */ "RenderbufferStorage",
    /*   680 */ "RenderbufferStorageMultisample",
    /*   681 */ "FlushMappedBufferRange",
    /*   682 */ "MapBufferRange",
    /*   683 */ "BindVertexArray",
    /*   684 */ "DeleteVertexArrays",
    /*   685 */ "GenVertexArrays",
    /*   686 */ "IsVertexArray",
    /*   687 */ "GetActiveUniformBlockName",
    /*   688 */ "GetActiveUniformBlockiv",
    /*   689 */ "GetActiveUniformName",
    /*   690 */ "GetActiveUniformsiv",
    /*   691 */ "GetUniformBlockIndex",
    /*   692 */ "GetUniformIndices",
    /*   693 */ "UniformBlockBinding",
    /*   694 */ "CopyBufferSubData",
    /*   695 */ "ClientWaitSync",
    /*   696 */ "DeleteSync",
    /*   697 */ "FenceSync",
    /*   698 */ "GetInteger64v",
    /*   699 */ "GetSynciv",
    /*   700 */ "IsSync",
    /*   701 */ "WaitSync",
    /*   702 */ "DrawElementsBaseVertex",
    /*   703 */ "DrawElementsInstancedBaseVertex",
    /*   704 */ "DrawRangeElementsBaseVertex",
    /*   705 */ "MultiDrawElementsBaseVertex",
    /*   706 */ "ProvokingVertex",
    /*   707 */ "GetMultisamplefv",
    /*   708 */ "SampleMaski",
    /*   709 */ "TexImage2DMultisample",
    /*   710 */ "TexImage3DMultisample",
    /*   711 */ "BlendEquationSeparateiARB",
    /*   712 */ "BlendEquationiARB",
    /*   713 */ "BlendFuncSeparateiARB",
    /*   714 */ "BlendFunciARB",
    /*   715 */ "BindFragDataLocationIndexed",
    /*   716 */ "GetFragDataIndex",
    /*   717 */ "BindSampler",
    /*   718 */ "DeleteSamplers",
    /*   719 */ "GenSamplers",
    /*   720 */ "GetSamplerParameterIiv",
    /*   721 */ "GetSamplerParameterIuiv",
    /*   722 */ "GetSamplerParameterfv",
    /*   723 */ "GetSamplerParameteriv",
    /*   724 */ "IsSampler",
    /*   725 */ "SamplerParameterIiv",
    /*   726 */ "SamplerParameterIuiv",
    /*   727 */ "SamplerParameterf",
    /*   728 */ "SamplerParameterfv",
    /*   729 */ "SamplerParameteri",
    /*   730 */ "SamplerParameteriv",
    /*   731 */ "GetQueryObjecti64v",
    /*   732 */ "GetQueryObjectui64v",
    /*   733 */ "QueryCounter",
    /*   734 */ "ColorP3ui",
    /*   735 */ "ColorP3uiv",
    /*   736 */ "ColorP4ui",
    /*   737 */ "ColorP4uiv",
    /*   738 */ "MultiTexCoordP1ui",
    /*   739 */ "MultiTexCoordP1uiv",
    /*   740 */ "MultiTexCoordP2ui",
    /*   741 */ "MultiTexCoordP2uiv",
    /*   742 */ "MultiTexCoordP3ui",
    /*   743 */ "MultiTexCoordP3uiv",
    /*   744 */ "MultiTexCoordP4ui",
    /*   745 */ "MultiTexCoordP4uiv",
    /*   746 */ "NormalP3ui",
    /*   747 */ "NormalP3uiv",
    /*   748 */ "SecondaryColorP3ui",
    /*   749 */ "SecondaryColorP3uiv",
    /*   750 */ "TexCoordP1ui",
    /*   751 */ "TexCoordP1uiv",
    /*   752 */ "TexCoordP2ui",
    /*   753 */ "TexCoordP2uiv",
    /*   754 */ "TexCoordP3ui",
    /*   755 */ "TexCoordP3uiv",
    /*   756 */ "TexCoordP4ui",
    /*   757 */ "TexCoordP4uiv",
    /*   758 */ "VertexAttribP1ui",
    /*   759 */ "VertexAttribP1uiv",
    /*   760 */ "VertexAttribP2ui",
    /*   761 */ "VertexAttribP2uiv",
    /*   762 */ "VertexAttribP3ui",
    /*   763 */ "VertexAttribP3uiv",
    /*   764 */ "VertexAttribP4ui",
    /*   765 */ "VertexAttribP4uiv",
    /*   766 */ "VertexP2ui",
    /*   767 */ "VertexP2uiv",
    /*   768 */ "VertexP3ui",
    /*   769 */ "VertexP3uiv",
    /*   770 */ "VertexP4ui",
    /*   771 */ "VertexP4uiv",
    /*   772 */ "DrawArraysIndirect",
    /*   773 */ "DrawElementsIndirect",
    /*   774 */ "GetUniformdv",
    /*   775 */ "Uniform1d",
    /*   776 */ "Uniform1dv",
    /*   777 */ "Uniform2d",
    /*   778 */ "Uniform2dv",
    /*   779 */ "Uniform3d",
    /*   780 */ "Uniform3dv",
    /*   781 */ "Uniform4d",
    /*   782 */ "Uniform4dv",
    /*   783 */ "UniformMatrix2dv",
    /*   784 */ "UniformMatrix2x3dv",
    /*   785 */ "UniformMatrix2x4dv",
    /*   786 */ "UniformMatrix3dv",
    /*   787 */ "UniformMatrix3x2dv",
    /*   788 */ "UniformMatrix3x4dv",
    /*   789 */ "UniformMatrix4dv",
    /*   790 */ "UniformMatrix4x2dv",
    /*   791 */ "UniformMatrix4x3dv",
    /*   792 */ "GetActiveSubroutineName",
    /*   793 */ "GetActiveSubroutineUniformName",
    /*   794 */ "GetActiveSubroutineUniformiv",
    /*   795 */ "GetProgramStageiv",
    /*   796 */ "GetSubroutineIndex",
    /*   797 */ "GetSubroutineUniformLocation",
    /*   798 */ "GetUniformSubroutineuiv",
    /*   799 */ "UniformSubroutinesuiv",
    /*   800 */ "PatchParameterfv",
    /*   801 */ "PatchParameteri",
    /*   802 */ "BindTransformFeedback",
    /*   803 */ "DeleteTransformFeedbacks",
    /*   804 */ "DrawTransformFeedback",
    /*   805 */ "GenTransformFeedbacks",
    /*   806 */ "IsTransformFeedback",
    /*   807 */ "PauseTransformFeedback",
    /*   808 */ "ResumeTransformFeedback",
    /*   809 */ "BeginQueryIndexed",
    /*   810 */ "DrawTransformFeedbackStream",
    /*   811 */ "EndQueryIndexed",
    /*   812 */ "GetQueryIndexediv",
    /*   813 */ "ClearDepthf",
    /*   814 */ "DepthRangef",
    /*   815 */ "GetShaderPrecisionFormat",
    /*   816 */ "ReleaseShaderCompiler",
    /*   817 */ "ShaderBinary",
    /*   818 */ "GetProgramBinary",
    /*   819 */ "ProgramBinary",
    /*   820 */ "ProgramParameteri",
    /*   821 */ "GetVertexAttribLdv",
    /*   822 */ "VertexAttribL1d",
    /*   823 */ "VertexAttribL1dv",
    /*   824 */ "VertexAttribL2d",
    /*   825 */ "VertexAttribL2dv",
    /*   826 */ "VertexAttribL3d",
    /*   827 */ "VertexAttribL3dv",
    /*   828 */ "VertexAttribL4d",
    /*   829 */ "VertexAttribL4dv",
    /*   830 */ "VertexAttribLPointer",
    /*   831 */ "DepthRangeArrayv",
    /*   832 */ "DepthRangeIndexed",
    /*   833 */ "GetDoublei_v",
    /*   834 */ "GetFloati_v",
    /*   835 */ "ScissorArrayv",
    /*   836 */ "ScissorIndexed",
    /*   837 */ "ScissorIndexedv",
    /*   838 */ "ViewportArrayv",
    /*   839 */ "ViewportIndexedf",
    /*   840 */ "ViewportIndexedfv",
    /*   841 */ "GetGraphicsResetStatusARB",
    /*   842 */ "GetnColorTableARB",
    /*   843 */ "GetnCompressedTexImageARB",
    /*   844 */ "GetnConvolutionFilterARB",
    /*   845 */ "GetnHistogramARB",
    /*   846 */ "GetnMapdvARB",
    /*   847 */ "GetnMapfvARB",
    /*   848 */ "GetnMapivARB",
    /*   849 */ "GetnMinmaxARB",
    /*   850 */ "GetnPixelMapfvARB",
    /*   851 */ "GetnPixelMapuivARB",
    /*   852 */ "GetnPixelMapusvARB",
    /*   853 */ "GetnPolygonStippleARB",
    /*   854 */ "GetnSeparableFilterARB",
    /*   855 */ "GetnTexImageARB",
    /*   856 */ "GetnUniformdvARB",
    /*   857 */ "GetnUniformfvARB",
    /*   858 */ "GetnUniformivARB",
    /*   859 */ "GetnUniformuivARB",
    /*   860 */ "ReadnPixelsARB",
    /*   861 */ "DrawArraysInstancedBaseInstance",
    /*   862 */ "DrawElementsInstancedBaseInstance",
    /*   863 */ "DrawElementsInstancedBaseVertexBaseInstance",
    /*   864 */ "DrawTransformFeedbackInstanced",
    /*   865 */ "DrawTransformFeedbackStreamInstanced",
    /*   866 */ "GetInternalformativ",
    /*   867 */ "GetActiveAtomicCounterBufferiv",
    /*   868 */ "BindImageTexture",
    /*   869 */ "MemoryBarrier",
    /*   870 */ "TexStorage1D",
    /*   871 */ "TexStorage2D",
    /*   872 */ "TexStorage3D",
    /*   873 */ "TextureStorage1DEXT",
    /*   874 */ "TextureStorage2DEXT",
    /*   875 */ "TextureStorage3DEXT",
    /*   876 */ "ClearBufferData",
    /*   877 */ "ClearBufferSubData",
    /*   878 */ "DispatchCompute",
    /*   879 */ "DispatchComputeIndirect",
    /*   880 */ "CopyImageSubData",
    /*   881 */ "TextureView",
    /*   882 */ "BindVertexBuffer",
    /*   883 */ "VertexAttribBinding",
    /*   884 */ "VertexAttribFormat",
    /*   885 */ "VertexAttribIFormat",
    /*   886 */ "VertexAttribLFormat",
    /*   887 */ "VertexBindingDivisor",
    /*   888 */ "FramebufferParameteri",
    /*   889 */ "GetFramebufferParameteriv",
    /*   890 */ "GetInternalformati64v",
    /*   891 */ "MultiDrawArraysIndirect",
    /*   892 */ "MultiDrawElementsIndirect",
    /*   893 */ "GetProgramInterfaceiv",
    /*   894 */ "GetProgramResourceIndex",
    /*   895 */ "GetProgramResourceLocation",
    /*   896 */ "GetProgramResourceLocationIndex",
    /*   897 */ "GetProgramResourceName",
    /*   898 */ "GetProgramResourceiv",
    /*   899 */ "ShaderStorageBlockBinding",
    /*   900 */ "TexBufferRange",
    /*   901 */ "TexStorage2DMultisample",
    /*   902 */ "TexStorage3DMultisample",
    /*   903 */ "BufferStorage",
    /*   904 */ "ClearTexImage",
    /*   905 */ "ClearTexSubImage",
    /*   906 */ "BindBuffersBase",
    /*   907 */ "BindBuffersRange",
    /*   908 */ "BindImageTextures",
    /*   909 */ "BindSamplers",
    /*   910 */ "BindTextures",
    /*   911 */ "BindVertexBuffers",
    /*   912 */ "GetImageHandleARB",
    /*   913 */ "GetTextureHandleARB",
    /*   914 */ "GetTextureSamplerHandleARB",
    /*   915 */ "GetVertexAttribLui64vARB",
    /*   916 */ "IsImageHandleResidentARB",
    /*   917 */ "IsTextureHandleResidentARB",
    /*   918 */ "MakeImageHandleNonResidentARB",
    /*   919 */ "MakeImageHandleResidentARB",
    /*   920 */ "MakeTextureHandleNonResidentARB",
    /*   921 */ "MakeTextureHandleResidentARB",
    /*   922 */ "ProgramUniformHandleui64ARB",
    /*   923 */ "ProgramUniformHandleui64vARB",
    /*   924 */ "UniformHandleui64ARB",
    /*   925 */ "UniformHandleui64vARB",
    /*   926 */ "VertexAttribL1ui64ARB",
    /*   927 */ "VertexAttribL1ui64vARB",
    /*   928 */ "DispatchComputeGroupSizeARB",
    /*   929 */ "MultiDrawArraysIndirectCountARB",
    /*   930 */ "MultiDrawElementsIndirectCountARB",
    /*   931 */ "ClipControl",
    /*   932 */ "BindTextureUnit",
    /*   933 */ "BlitNamedFramebuffer",
    /*   934 */ "CheckNamedFramebufferStatus",
    /*   935 */ "ClearNamedBufferData",
    /*   936 */ "ClearNamedBufferSubData",
    /*   937 */ "ClearNamedFramebufferfi",
    /*   938 */ "ClearNamedFramebufferfv",
    /*   939 */ "ClearNamedFramebufferiv",
    /*   940 */ "ClearNamedFramebufferuiv",
    /*   941 */ "CompressedTextureSubImage1D",
    /*   942 */ "CompressedTextureSubImage2D",
    /*   943 */ "CompressedTextureSubImage3D",
    /*   944 */ "CopyNamedBufferSubData",
    /*   945 */ "CopyTextureSubImage1D",
    /*   946 */ "CopyTextureSubImage2D",
    /*   947 */ "CopyTextureSubImage3D",
    /*   948 */ "CreateBuffers",
    /*   949 */ "CreateFramebuffers",
    /*   950 */ "CreateProgramPipelines",
    /*   951 */ "CreateQueries",
    /*   952 */ "CreateRenderbuffers",
    /*   953 */ "CreateSamplers",
    /*   954 */ "CreateTextures",
    /*   955 */ "CreateTransformFeedbacks",
    /*   956 */ "CreateVertexArrays",
    /*   957 */ "DisableVertexArrayAttrib",
    /*   958 */ "EnableVertexArrayAttrib",
    /*   959 */ "FlushMappedNamedBufferRange",
    /*   960 */ "GenerateTextureMipmap",
    /*   961 */ "GetCompressedTextureImage",
    /*   962 */ "GetNamedBufferParameteri64v",
    /*   963 */ "GetNamedBufferParameteriv",
    /*   964 */ "GetNamedBufferPointerv",
    /*   965 */ "GetNamedBufferSubData",
    /*   966 */ "GetNamedFramebufferAttachmentParameteriv",
    /*   967 */ "GetNamedFramebufferParameteriv",
    /*   968 */ "GetNamedRenderbufferParameteriv",
    /*   969 */ "GetQueryBufferObjecti64v",
    /*   970 */ "GetQueryBufferObjectiv",
    /*   971 */ "GetQueryBufferObjectui64v",
    /*   972 */ "GetQueryBufferObjectuiv",
    /*   973 */ "GetTextureImage",
    /*   974 */ "GetTextureLevelParameterfv",
    /*   975 */ "GetTextureLevelParameteriv",
    /*   976 */ "GetTextureParameterIiv",
    /*   977 */ "GetTextureParameterIuiv",
    /*   978 */ "GetTextureParameterfv",
    /*   979 */ "GetTextureParameteriv",
    /*   980 */ "GetTransformFeedbacki64_v",
    /*   981 */ "GetTransformFeedbacki_v",
    /*   982 */ "GetTransformFeedbackiv",
    /*   983 */ "GetVertexArrayIndexed64iv",
    /*   984 */ "GetVertexArrayIndexediv",
    /*   985 */ "GetVertexArrayiv",
    /*   986 */ "InvalidateNamedFramebufferData",
    /*   987 */ "InvalidateNamedFramebufferSubData",
    /*   988 */ "MapNamedBuffer",
    /*   989 */ "MapNamedBufferRange",
    /*   990 */ "NamedBufferData",
    /*   991 */ "NamedBufferStorage",
    /*   992 */ "NamedBufferSubData",
    /*   993 */ "NamedFramebufferDrawBuffer",
    /*   994 */ "NamedFramebufferDrawBuffers",
    /*   995 */ "NamedFramebufferParameteri",
    /*   996 */ "NamedFramebufferReadBuffer",
    /*   997 */ "NamedFramebufferRenderbuffer",
    /*   998 */ "NamedFramebufferTexture",
    /*   999 */ "NamedFramebufferTextureLayer",
    /*  1000 */ "NamedRenderbufferStorage",
    /*  1001 */ "NamedRenderbufferStorageMultisample",
    /*  1002 */ "TextureBuffer",
    /*  1003 */ "TextureBufferRange",
    /*  1004 */ "TextureParameterIiv",
    /*  1005 */ "TextureParameterIuiv",
    /*  1006 */ "TextureParameterf",
    /*  1007 */ "TextureParameterfv",
    /*  1008 */ "TextureParameteri",
    /*  1009 */ "TextureParameteriv",
    /*  1010 */ "TextureStorage1D",
    /*  1011 */ "TextureStorage2D",
    /*  1012 */ "TextureStorage2DMultisample",
    /*  1013 */ "TextureStorage3D",
    /*  1014 */ "TextureStorage3DMultisample",
    /*  1015 */ "TextureSubImage1D",
    /*  1016 */ "TextureSubImage2D",
    /*  1017 */ "TextureSubImage3D",
    /*  1018 */ "TransformFeedbackBufferBase",
    /*  1019 */ "TransformFeedbackBufferRange",
    /*  1020 */ "UnmapNamedBuffer",
    /*  1021 */ "VertexArrayAttribBinding",
    /*  1022 */ "VertexArrayAttribFormat",
    /*  1023 */ "VertexArrayAttribIFormat",
    /*  1024 */ "VertexArrayAttribLFormat",
    /*  1025 */ "VertexArrayBindingDivisor",
    /*  1026 */ "VertexArrayElementBuffer",
    /*  1027 */ "VertexArrayVertexBuffer",
    /*  1028 */ "VertexArrayVertexBuffers",
    /*  1029 */ "GetCompressedTextureSubImage",
    /*  1030 */ "GetTextureSubImage",
    /*  1031 */ "BufferPageCommitmentARB",
    /*  1032 */ "NamedBufferPageCommitmentARB",
    /*  1033 */ "GetUniformi64vARB",
    /*  1034 */ "GetUniformui64vARB",
    /*  1035 */ "GetnUniformi64vARB",
    /*  1036 */ "GetnUniformui64vARB",
    /*  1037 */ "ProgramUniform1i64ARB",
    /*  1038 */ "ProgramUniform1i64vARB",
    /*  1039 */ "ProgramUniform1ui64ARB",
    /*  1040 */ "ProgramUniform1ui64vARB",
    /*  1041 */ "ProgramUniform2i64ARB",
    /*  1042 */ "ProgramUniform2i64vARB",
    /*  1043 */ "ProgramUniform2ui64ARB",
    /*  1044 */ "ProgramUniform2ui64vARB",
    /*  1045 */ "ProgramUniform3i64ARB",
    /*  1046 */ "ProgramUniform3i64vARB",
    /*  1047 */ "ProgramUniform3ui64ARB",
    /*  1048 */ "ProgramUniform3ui64vARB",
    /*  1049 */ "ProgramUniform4i64ARB",
    /*  1050 */ "ProgramUniform4i64vARB",
    /*  1051 */ "ProgramUniform4ui64ARB",
    /*  1052 */ "ProgramUniform4ui64vARB",
    /*  1053 */ "Uniform1i64ARB",
    /*  1054 */ "Uniform1i64vARB",
    /*  1055 */ "Uniform1ui64ARB",
    /*  1056 */ "Uniform1ui64vARB",
    /*  1057 */ "Uniform2i64ARB",
    /*  1058 */ "Uniform2i64vARB",
    /*  1059 */ "Uniform2ui64ARB",
    /*  1060 */ "Uniform2ui64vARB",
    /*  1061 */ "Uniform3i64ARB",
    /*  1062 */ "Uniform3i64vARB",
    /*  1063 */ "Uniform3ui64ARB",
    /*  1064 */ "Uniform3ui64vARB",
    /*  1065 */ "Uniform4i64ARB",
    /*  1066 */ "Uniform4i64vARB",
    /*  1067 */ "Uniform4ui64ARB",
    /*  1068 */ "Uniform4ui64vARB",
    /*  1069 */ "InvalidateBufferData",
    /*  1070 */ "InvalidateBufferSubData",
    /*  1071 */ "InvalidateFramebuffer",
    /*  1072 */ "InvalidateSubFramebuffer",
    /*  1073 */ "InvalidateTexImage",
    /*  1074 */ "InvalidateTexSubImage",
    /*  1075 */ "PolygonOffsetEXT",
    /*  1076 */ "DrawTexfOES",
    /*  1077 */ "DrawTexfvOES",
    /*  1078 */ "DrawTexiOES",
    /*  1079 */ "DrawTexivOES",
    /*  1080 */ "DrawTexsOES",
    /*  1081 */ "DrawTexsvOES",
    /*  1082 */ "DrawTexxOES",
    /*  1083 */ "DrawTexxvOES",
    /*  1084 */ "PointSizePointerOES",
    /*  1085 */ "QueryMatrixxOES",
    /*  1086 */ "SampleMaskSGIS",
    /*  1087 */ "SamplePatternSGIS",
    /*  1088 */ "ColorPointerEXT",
    /*  1089 */ "EdgeFlagPointerEXT",
    /*  1090 */ "IndexPointerEXT",
    /*  1091 */ "NormalPointerEXT",
    /*  1092 */ "TexCoordPointerEXT",
    /*  1093 */ "VertexPointerEXT",
    /*  1094 */ "DiscardFramebufferEXT",
    /*  1095 */ "ActiveShaderProgram",
    /*  1096 */ "BindProgramPipeline",
    /*  1097 */ "CreateShaderProgramv",
    /*  1098 */ "DeleteProgramPipelines",
    /*  1099 */ "GenProgramPipelines",
    /*  1100 */ "GetProgramPipelineInfoLog",
    /*  1101 */ "GetProgramPipelineiv",
    /*  1102 */ "IsProgramPipeline",
    /*  1103 */ "LockArraysEXT",
    /*  1104 */ "ProgramUniform1d",
    /*  1105 */ "ProgramUniform1dv",
    /*  1106 */ "ProgramUniform1f",
    /*  1107 */ "ProgramUniform1fv",
    /*  1108 */ "ProgramUniform1i",
    /*  1109 */ "ProgramUniform1iv",
    /*  1110 */ "ProgramUniform1ui",
    /*  1111 */ "ProgramUniform1uiv",
    /*  1112 */ "ProgramUniform2d",
    /*  1113 */ "ProgramUniform2dv",
    /*  1114 */ "ProgramUniform2f",
    /*  1115 */ "ProgramUniform2fv",
    /*  1116 */ "ProgramUniform2i",
    /*  1117 */ "ProgramUniform2iv",
    /*  1118 */ "ProgramUniform2ui",
    /*  1119 */ "ProgramUniform2uiv",
    /*  1120 */ "ProgramUniform3d",
    /*  1121 */ "ProgramUniform3dv",
    /*  1122 */ "ProgramUniform3f",
    /*  1123 */ "ProgramUniform3fv",
    /*  1124 */ "ProgramUniform3i",
    /*  1125 */ "ProgramUniform3iv",
    /*  1126 */ "ProgramUniform3ui",
    /*  1127 */ "ProgramUniform3uiv",
    /*  1128 */ "ProgramUniform4d",
    /*  1129 */ "ProgramUniform4dv",
    /*  1130 */ "ProgramUniform4f",
    /*  1131 */ "ProgramUniform4fv",
    /*  1132 */ "ProgramUniform4i",
    /*  1133 */ "ProgramUniform4iv",
    /*  1134 */ "ProgramUniform4ui",
    /*  1135 */ "ProgramUniform4uiv",
    /*  1136 */ "ProgramUniformMatrix2dv",
    /*  1137 */ "ProgramUniformMatrix2fv",
    /*  1138 */ "ProgramUniformMatrix2x3dv",
    /*  1139 */ "ProgramUniformMatrix2x3fv",
    /*  1140 */ "ProgramUniformMatrix2x4dv",
    /*  1141 */ "ProgramUniformMatrix2x4fv",
    /*  1142 */ "ProgramUniformMatrix3dv",
    /*  1143 */ "ProgramUniformMatrix3fv",
    /*  1144 */ "ProgramUniformMatrix3x2dv",
    /*  1145 */ "ProgramUniformMatrix3x2fv",
    /*  1146 */ "ProgramUniformMatrix3x4dv",
    /*  1147 */ "ProgramUniformMatrix3x4fv",
    /*  1148 */ "ProgramUniformMatrix4dv",
    /*  1149 */ "ProgramUniformMatrix4fv",
    /*  1150 */ "ProgramUniformMatrix4x2dv",
    /*  1151 */ "ProgramUniformMatrix4x2fv",
    /*  1152 */ "ProgramUniformMatrix4x3dv",
    /*  1153 */ "ProgramUniformMatrix4x3fv",
    /*  1154 */ "UnlockArraysEXT",
    /*  1155 */ "UseProgramStages",
    /*  1156 */ "ValidateProgramPipeline",
    /*  1157 */ "DebugMessageCallback",
    /*  1158 */ "DebugMessageControl",
    /*  1159 */ "DebugMessageInsert",
    /*  1160 */ "GetDebugMessageLog",
    /*  1161 */ "GetObjectLabel",
    /*  1162 */ "GetObjectPtrLabel",
    /*  1163 */ "ObjectLabel",
    /*  1164 */ "ObjectPtrLabel",
    /*  1165 */ "PopDebugGroup",
    /*  1166 */ "PushDebugGroup",
    /*  1167 */ "SecondaryColor3fEXT",
    /*  1168 */ "SecondaryColor3fvEXT",
    /*  1169 */ "MultiDrawElementsEXT",
    /*  1170 */ "FogCoordfEXT",
    /*  1171 */ "FogCoordfvEXT",
    /*  1172 */ "ResizeBuffersMESA",
    /*  1173 */ "WindowPos4dMESA",
    /*  1174 */ "WindowPos4dvMESA",
    /*  1175 */ "WindowPos4fMESA",
    /*  1176 */ "WindowPos4fvMESA",
    /*  1177 */ "WindowPos4iMESA",
    /*  1178 */ "WindowPos4ivMESA",
    /*  1179 */ "WindowPos4sMESA",
    /*  1180 */ "WindowPos4svMESA",
    /*  1181 */ "MultiModeDrawArraysIBM",
    /*  1182 */ "MultiModeDrawElementsIBM",
    /*  1183 */ "AreProgramsResidentNV",
    /*  1184 */ "ExecuteProgramNV",
    /*  1185 */ "GetProgramParameterdvNV",
    /*  1186 */ "GetProgramParameterfvNV",
    /*  1187 */ "GetProgramStringNV",
    /*  1188 */ "GetProgramivNV",
    /*  1189 */ "GetTrackMatrixivNV",
    /*  1190 */ "GetVertexAttribdvNV",
    /*  1191 */ "GetVertexAttribfvNV",
    /*  1192 */ "GetVertexAttribivNV",
    /*  1193 */ "LoadProgramNV",
    /*  1194 */ "ProgramParameters4dvNV",
    /*  1195 */ "ProgramParameters4fvNV",
    /*  1196 */ "RequestResidentProgramsNV",
    /*  1197 */ "TrackMatrixNV",
    /*  1198 */ "VertexAttrib1dNV",
    /*  1199 */ "VertexAttrib1dvNV",
    /*  1200 */ "VertexAttrib1fNV",
    /*  1201 */ "VertexAttrib1fvNV",
    /*  1202 */ "VertexAttrib1sNV",
    /*  1203 */ "VertexAttrib1svNV",
    /*  1204 */ "VertexAttrib2dNV",
    /*  1205 */ "VertexAttrib2dvNV",
    /*  1206 */ "VertexAttrib2fNV",
    /*  1207 */ "VertexAttrib2fvNV",
    /*  1208 */ "VertexAttrib2sNV",
    /*  1209 */ "VertexAttrib2svNV",
    /*  1210 */ "VertexAttrib3dNV",
    /*  1211 */ "VertexAttrib3dvNV",
    /*  1212 */ "VertexAttrib3fNV",
    /*  1213 */ "VertexAttrib3fvNV",
    /*  1214 */ "VertexAttrib3sNV",
    /*  1215 */ "VertexAttrib3svNV",
    /*  1216 */ "VertexAttrib4dNV",
    /*  1217 */ "VertexAttrib4dvNV",
    /*  1218 */ "VertexAttrib4fNV",
    /*  1219 */ "VertexAttrib4fvNV",
    /*  1220 */ "VertexAttrib4sNV",
    /*  1221 */ "VertexAttrib4svNV",
    /*  1222 */ "VertexAttrib4ubNV",
    /*  1223 */ "VertexAttrib4ubvNV",
    /*  1224 */ "VertexAttribPointerNV",
    /*  1225 */ "VertexAttribs1dvNV",
    /*  1226 */ "VertexAttribs1fvNV",
    /*  1227 */ "VertexAttribs1svNV",
    /*  1228 */ "VertexAttribs2dvNV",
    /*  1229 */ "VertexAttribs2fvNV",
    /*  1230 */ "VertexAttribs2svNV",
    /*  1231 */ "VertexAttribs3dvNV",
    /*  1232 */ "VertexAttribs3fvNV",
    /*  1233 */ "VertexAttribs3svNV",
    /*  1234 */ "VertexAttribs4dvNV",
    /*  1235 */ "VertexAttribs4fvNV",
    /*  1236 */ "VertexAttribs4svNV",
    /*  1237 */ "VertexAttribs4ubvNV",
    /*  1238 */ "GetTexBumpParameterfvATI",
    /*  1239 */ "GetTexBumpParameterivATI",
    /*  1240 */ "TexBumpParameterfvATI",
    /*  1241 */ "TexBumpParameterivATI",
    /*  1242 */ "AlphaFragmentOp1ATI",
    /*  1243 */ "AlphaFragmentOp2ATI",
    /*  1244 */ "AlphaFragmentOp3ATI",
    /*  1245 */ "BeginFragmentShaderATI",
    /*  1246 */ "BindFragmentShaderATI",
    /*  1247 */ "ColorFragmentOp1ATI",
    /*  1248 */ "ColorFragmentOp2ATI",
    /*  1249 */ "ColorFragmentOp3ATI",
    /*  1250 */ "DeleteFragmentShaderATI",
    /*  1251 */ "EndFragmentShaderATI",
    /*  1252 */ "GenFragmentShadersATI",
    /*  1253 */ "PassTexCoordATI",
    /*  1254 */ "SampleMapATI",
    /*  1255 */ "SetFragmentShaderConstantATI",
    /*  1256 */ "DepthRangeArrayfvOES",
    /*  1257 */ "DepthRangeIndexedfOES",
    /*  1258 */ "ActiveStencilFaceEXT",
    /*  1259 */ "GetProgramNamedParameterdvNV",
    /*  1260 */ "GetProgramNamedParameterfvNV",
    /*  1261 */ "ProgramNamedParameter4dNV",
    /*  1262 */ "ProgramNamedParameter4dvNV",
    /*  1263 */ "ProgramNamedParameter4fNV",
    /*  1264 */ "ProgramNamedParameter4fvNV",
    /*  1265 */ "PrimitiveRestartNV",
    /*  1266 */ "GetTexGenxvOES",
    /*  1267 */ "TexGenxOES",
    /*  1268 */ "TexGenxvOES",
    /*  1269 */ "DepthBoundsEXT",
    /*  1270 */ "BindFramebufferEXT",
    /*  1271 */ "BindRenderbufferEXT",
    /*  1272 */ "StringMarkerGREMEDY",
    /*  1273 */ "BufferParameteriAPPLE",
    /*  1274 */ "FlushMappedBufferRangeAPPLE",
    /*  1275 */ "VertexAttribI1iEXT",
    /*  1276 */ "VertexAttribI1uiEXT",
    /*  1277 */ "VertexAttribI2iEXT",
    /*  1278 */ "VertexAttribI2ivEXT",
    /*  1279 */ "VertexAttribI2uiEXT",
    /*  1280 */ "VertexAttribI2uivEXT",
    /*  1281 */ "VertexAttribI3iEXT",
    /*  1282 */ "VertexAttribI3ivEXT",
    /*  1283 */ "VertexAttribI3uiEXT",
    /*  1284 */ "VertexAttribI3uivEXT",
    /*  1285 */ "VertexAttribI4iEXT",
    /*  1286 */ "VertexAttribI4ivEXT",
    /*  1287 */ "VertexAttribI4uiEXT",
    /*  1288 */ "VertexAttribI4uivEXT",
    /*  1289 */ "ClearColorIiEXT",
    /*  1290 */ "ClearColorIuiEXT",
    /*  1291 */ "BindBufferOffsetEXT",
    /*  1292 */ "BeginPerfMonitorAMD",
    /*  1293 */ "DeletePerfMonitorsAMD",
    /*  1294 */ "EndPerfMonitorAMD",
    /*  1295 */ "GenPerfMonitorsAMD",
    /*  1296 */ "GetPerfMonitorCounterDataAMD",
    /*  1297 */ "GetPerfMonitorCounterInfoAMD",
    /*  1298 */ "GetPerfMonitorCounterStringAMD",
    /*  1299 */ "GetPerfMonitorCountersAMD",
    /*  1300 */ "GetPerfMonitorGroupStringAMD",
    /*  1301 */ "GetPerfMonitorGroupsAMD",
    /*  1302 */ "SelectPerfMonitorCountersAMD",
    /*  1303 */ "GetObjectParameterivAPPLE",
    /*  1304 */ "ObjectPurgeableAPPLE",
    /*  1305 */ "ObjectUnpurgeableAPPLE",
    /*  1306 */ "ActiveProgramEXT",
    /*  1307 */ "CreateShaderProgramEXT",
    /*  1308 */ "UseShaderProgramEXT",
    /*  1309 */ "TextureBarrierNV",
    /*  1310 */ "VDPAUFiniNV",
    /*  1311 */ "VDPAUGetSurfaceivNV",
    /*  1312 */ "VDPAUInitNV",
    /*  1313 */ "VDPAUIsSurfaceNV",
    /*  1314 */ "VDPAUMapSurfacesNV",
    /*  1315 */ "VDPAURegisterOutputSurfaceNV",
    /*  1316 */ "VDPAURegisterVideoSurfaceNV",
    /*  1317 */ "VDPAUSurfaceAccessNV",
    /*  1318 */ "VDPAUUnmapSurfacesNV",
    /*  1319 */ "VDPAUUnregisterSurfaceNV",
    /*  1320 */ "BeginPerfQueryINTEL",
    /*  1321 */ "CreatePerfQueryINTEL",
    /*  1322 */ "DeletePerfQueryINTEL",
    /*  1323 */ "EndPerfQueryINTEL",
    /*  1324 */ "GetFirstPerfQueryIdINTEL",
    /*  1325 */ "GetNextPerfQueryIdINTEL",
    /*  1326 */ "GetPerfCounterInfoINTEL",
    /*  1327 */ "GetPerfQueryDataINTEL",
    /*  1328 */ "GetPerfQueryIdByNameINTEL",
    /*  1329 */ "GetPerfQueryInfoINTEL",
    /*  1330 */ "PolygonOffsetClampEXT",
    /*  1331 */ "WindowRectanglesEXT",
    /*  1332 */ "BufferStorageMemEXT",
    /*  1333 */ "CreateMemoryObjectsEXT",
    /*  1334 */ "DeleteMemoryObjectsEXT",
    /*  1335 */ "DeleteSemaphoresEXT",
    /*  1336 */ "GenSemaphoresEXT",
    /*  1337 */ "GetMemoryObjectParameterivEXT",
    /*  1338 */ "GetSemaphoreParameterui64vEXT",
    /*  1339 */ "GetUnsignedBytei_vEXT",
    /*  1340 */ "GetUnsignedBytevEXT",
    /*  1341 */ "IsMemoryObjectEXT",
    /*  1342 */ "IsSemaphoreEXT",
    /*  1343 */ "MemoryObjectParameterivEXT",
    /*  1344 */ "NamedBufferStorageMemEXT",
    /*  1345 */ "SemaphoreParameterui64vEXT",
    /*  1346 */ "SignalSemaphoreEXT",
    /*  1347 */ "TexStorageMem1DEXT",
    /*  1348 */ "TexStorageMem2DEXT",
    /*  1349 */ "TexStorageMem2DMultisampleEXT",
    /*  1350 */ "TexStorageMem3DEXT",
    /*  1351 */ "TexStorageMem3DMultisampleEXT",
    /*  1352 */ "TextureStorageMem1DEXT",
    /*  1353 */ "TextureStorageMem2DEXT",
    /*  1354 */ "TextureStorageMem2DMultisampleEXT",
    /*  1355 */ "TextureStorageMem3DEXT",
    /*  1356 */ "TextureStorageMem3DMultisampleEXT",
    /*  1357 */ "WaitSemaphoreEXT",
    /*  1358 */ "ImportMemoryFdEXT",
    /*  1359 */ "ImportSemaphoreFdEXT",
    /*  1360 */ "StencilFuncSeparateATI",
    /*  1361 */ "ProgramEnvParameters4fvEXT",
    /*  1362 */ "ProgramLocalParameters4fvEXT",
    /*  1363 */ "EGLImageTargetRenderbufferStorageOES",
    /*  1364 */ "EGLImageTargetTexture2DOES",
    /*  1365 */ "AlphaFuncx",
    /*  1366 */ "ClearColorx",
    /*  1367 */ "ClearDepthx",
    /*  1368 */ "Color4x",
    /*  1369 */ "DepthRangex",
    /*  1370 */ "Fogx",
    /*  1371 */ "Fogxv",
    /*  1372 */ "Frustumf",
    /*  1373 */ "Frustumx",
    /*  1374 */ "LightModelx",
    /*  1375 */ "LightModelxv",
    /*  1376 */ "Lightx",
    /*  1377 */ "Lightxv",
    /*  1378 */ "LineWidthx",
    /*  1379 */ "LoadMatrixx",
    /*  1380 */ "Materialx",
    /*  1381 */ "Materialxv",
    /*  1382 */ "MultMatrixx",
    /*  1383 */ "MultiTexCoord4x",
    /*  1384 */ "Normal3x",
    /*  1385 */ "Orthof",
    /*  1386 */ "Orthox",
    /*  1387 */ "PointSizex",
    /*  1388 */ "PolygonOffsetx",
    /*  1389 */ "Rotatex",
    /*  1390 */ "SampleCoveragex",
    /*  1391 */ "Scalex",
    /*  1392 */ "TexEnvx",
    /*  1393 */ "TexEnvxv",
    /*  1394 */ "TexParameterx",
    /*  1395 */ "Translatex",
    /*  1396 */ "ClipPlanef",
    /*  1397 */ "ClipPlanex",
    /*  1398 */ "GetClipPlanef",
    /*  1399 */ "GetClipPlanex",
    /*  1400 */ "GetFixedv",
    /*  1401 */ "GetLightxv",
    /*  1402 */ "GetMaterialxv",
    /*  1403 */ "GetTexEnvxv",
    /*  1404 */ "GetTexParameterxv",
    /*  1405 */ "PointParameterx",
    /*  1406 */ "PointParameterxv",
    /*  1407 */ "TexParameterxv",
    /*  1408 */ "BlendBarrier",
    /*  1409 */ "PrimitiveBoundingBox",
};

struct _glapi_table *
_glapi_create_table_from_handle(void *handle, const char *symbol_prefix) {
    struct _glapi_table *disp = calloc(_glapi_get_dispatch_table_size(), sizeof(_glapi_proc));
    char symboln[512];

    if(!disp)
        return NULL;

    if(symbol_prefix == NULL)
        symbol_prefix = "";

    /* Note: This code relies on _glapi_table_func_names being sorted by the
     * entry point index of each function.
     */
    for (int func_index = 0; func_index < GLAPI_TABLE_COUNT; ++func_index) {
        const char *name = _glapi_table_func_names[func_index];
        void ** procp = &((void **)disp)[func_index];

        snprintf(symboln, sizeof(symboln), "%s%s", symbol_prefix, name);
#ifdef _WIN32
        *procp = GetProcAddress(handle, symboln);
#else
        *procp = dlsym(handle, symboln);
#endif
    }
    __glapi_gentable_set_remaining_noop(disp);

    return disp;
}

void
 _glapi_table_patch(struct _glapi_table *table, const char *name, void *wrapper)
{
   for (int func_index = 0; func_index < GLAPI_TABLE_COUNT; ++func_index) {
      if (!strcmp(_glapi_table_func_names[func_index], name)) {
            ((void **)table)[func_index] = wrapper;
            return;
         }
   }
   fprintf(stderr, "could not patch %s in dispatch table\n", name);
}


