/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_OCCLUSION_QUERY},
	{93, PKT3_SET_PREDICATION},
	{109, PKT3_COND_EXEC},
	{119, PKT3_PRED_EXEC},
	{129, PKT3_DRAW_INDIRECT},
	{143, PKT3_DRAW_INDEX_INDIRECT},
	{163, PKT3_INDEX_BASE},
	{174, PKT3_DRAW_INDEX_2},
	{187, PKT3_CONTEXT_CONTROL},
	{203, PKT3_INDEX_TYPE},
	{214, PKT3_DRAW_INDIRECT_MULTI},
	{234, PKT3_DRAW_INDEX_AUTO},
	{250, PKT3_DRAW_INDEX_IMMD},
	{266, PKT3_NUM_INSTANCES},
	{280, PKT3_DRAW_INDEX_MULTI_AUTO},
	{302, PKT3_INDIRECT_BUFFER_SI},
	{321, PKT3_INDIRECT_BUFFER_CONST},
	{343, PKT3_STRMOUT_BUFFER_UPDATE},
	{365, PKT3_DRAW_INDEX_OFFSET_2},
	{385, PKT3_WRITE_DATA},
	{396, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{422, PKT3_MEM_SEMAPHORE},
	{436, PKT3_MPEG_INDEX},
	{447, PKT3_WAIT_REG_MEM},
	{460, PKT3_MEM_WRITE},
	{470, PKT3_INDIRECT_BUFFER_CIK},
	{490, PKT3_COPY_DATA},
	{500, PKT3_PFP_SYNC_ME},
	{512, PKT3_SURFACE_SYNC},
	{525, PKT3_ME_INITIALIZE},
	{539, PKT3_COND_WRITE},
	{550, PKT3_EVENT_WRITE},
	{562, PKT3_EVENT_WRITE_EOP},
	{578, PKT3_ONE_REG_WRITE},
	{592, PKT3_ACQUIRE_MEM},
	{604, PKT3_SET_CONFIG_REG},
	{619, PKT3_SET_CONTEXT_REG},
	{635, PKT3_SET_SH_REG},
	{646, PKT3_SET_SH_REG_OFFSET},
	{664, PKT3_SET_UCONFIG_REG},
	{680, PKT3_LOAD_CONST_RAM},
	{695, PKT3_WRITE_CONST_RAM},
	{711, PKT3_DUMP_CONST_RAM},
	{726, PKT3_INCREMENT_CE_COUNTER},
	{747, PKT3_INCREMENT_DE_COUNTER},
	{768, PKT3_WAIT_ON_CE_COUNTER},
	{787, PKT3_IT_OPCODE_C},
	{799, PKT3_CP_DMA},
	{806, PKT3_DMA_DATA},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{815, S_2C3_COUNT_INDIRECT_ENABLE(~0u)},
	{837, S_2C3_DRAW_INDEX_ENABLE(~0u)},
	/* 2 */
	{865, S_370_ENGINE_SEL(~0u), 4, 0},
	{876, S_370_WR_CONFIRM(~0u)},
	{887, S_370_WR_ONE_ADDR(~0u)},
	{960, S_370_DST_SEL(~0u), 6, 4},
	/* 6 */
	{968, S_3F2_IB_SIZE(~0u)},
	{976, S_3F2_CHAIN(~0u)},
	{982, S_3F2_VALID(~0u)},
	/* 9 */
	{988, S_410_SRC_ADDR_LO(~0u)},
	/* 10 */
	{1000, S_411_CP_SYNC(~0u)},
	{1032, S_411_SRC_SEL(~0u), 4, 10},
	{1040, S_411_ENGINE(~0u), 2, 0},
	{1079, S_411_DSL_SEL(~0u), 4, 14},
	{1087, S_411_SRC_ADDR_HI(~0u)},
	/* 15 */
	{1099, S_412_DST_ADDR_LO(~0u)},
	/* 16 */
	{1111, S_413_DST_ADDR_HI(~0u)},
	/* 17 */
	{1123, S_414_BYTE_COUNT_GFX6(~0u)},
	{1139, S_414_BYTE_COUNT_GFX9(~0u)},
	{1155, S_414_DISABLE_WR_CONFIRM_GFX6(~0u)},
	{1208, S_414_SRC_SWAP(~0u), 4, 18},
	{1217, S_414_DST_SWAP(~0u), 4, 18},
	{1233, S_414_SAS(~0u), 2, 22},
	{1237, S_414_DAS(~0u), 2, 22},
	{1264, S_414_SAIC(~0u), 2, 24},
	{1269, S_414_DAIC(~0u), 2, 24},
	{1274, S_414_RAW_WAIT(~0u)},
	{1283, S_414_DISABLE_WR_CONFIRM_GFX9(~0u)},
	/* 28 */
	{1000, S_500_CP_SYNC(~0u)},
	{1032, S_500_SRC_SEL(~0u), 4, 10},
	{1079, S_500_DSL_SEL(~0u), 4, 26},
	{1040, S_500_ENGINE(~0u), 2, 0},
	/* 32 */
	{1307, S_000E4C_SDMA_RQ_PENDING(~0u)},
	{1323, S_000E4C_TST_RQ_PENDING(~0u)},
	{1338, S_000E4C_SDMA1_RQ_PENDING(~0u)},
	{1355, S_000E4C_VCE0_RQ_PENDING(~0u)},
	{1371, S_000E4C_VP8_BUSY(~0u)},
	{1380, S_000E4C_SDMA_BUSY(~0u)},
	{1390, S_000E4C_SDMA1_BUSY(~0u)},
	{1401, S_000E4C_VCE0_BUSY(~0u)},
	{1411, S_000E4C_XDMA_BUSY(~0u)},
	{1421, S_000E4C_CHUB_BUSY(~0u)},
	{1431, S_000E4C_SDMA2_BUSY(~0u)},
	{1442, S_000E4C_SDMA3_BUSY(~0u)},
	{1453, S_000E4C_SAMSCP_BUSY(~0u)},
	{1465, S_000E4C_ISP_BUSY(~0u)},
	{1474, S_000E4C_VCE1_BUSY(~0u)},
	{1484, S_000E4C_ODE_BUSY(~0u)},
	{1493, S_000E4C_SDMA2_RQ_PENDING(~0u)},
	{1510, S_000E4C_SDMA3_RQ_PENDING(~0u)},
	{1527, S_000E4C_SAMSCP_RQ_PENDING(~0u)},
	{1545, S_000E4C_ISP_RQ_PENDING(~0u)},
	{1560, S_000E4C_VCE1_RQ_PENDING(~0u)},
	/* 53 */
	{1576, S_000E50_UVD_RQ_PENDING(~0u)},
	{1591, S_000E50_SAMMSP_RQ_PENDING(~0u)},
	{1609, S_000E50_ACP_RQ_PENDING(~0u)},
	{1624, S_000E50_SMU_RQ_PENDING(~0u)},
	{1639, S_000E50_GRBM_RQ_PENDING(~0u)},
	{1655, S_000E50_HI_RQ_PENDING(~0u)},
	{1669, S_000E50_VMC_BUSY(~0u)},
	{1678, S_000E50_MCB_BUSY(~0u)},
	{1687, S_000E50_MCB_NON_DISPLAY_BUSY(~0u)},
	{1708, S_000E50_MCC_BUSY(~0u)},
	{1717, S_000E50_MCD_BUSY(~0u)},
	{1726, S_000E50_VMC1_BUSY(~0u)},
	{1736, S_000E50_SEM_BUSY(~0u)},
	{1745, S_000E50_ACP_BUSY(~0u)},
	{1754, S_000E50_IH_BUSY(~0u)},
	{1762, S_000E50_UVD_BUSY(~0u)},
	{1771, S_000E50_SAMMSP_BUSY(~0u)},
	{1783, S_000E50_GCATCL2_BUSY(~0u)},
	{1796, S_000E50_OSATCL2_BUSY(~0u)},
	{1809, S_000E50_BIF_BUSY(~0u)},
	/* 73 */
	{1818, S_000E54_MCC0_BUSY(~0u)},
	{1828, S_000E54_MCC1_BUSY(~0u)},
	{1838, S_000E54_MCC2_BUSY(~0u)},
	{1848, S_000E54_MCC3_BUSY(~0u)},
	{1858, S_000E54_MCC4_BUSY(~0u)},
	{1868, S_000E54_MCC5_BUSY(~0u)},
	{1878, S_000E54_MCC6_BUSY(~0u)},
	{1888, S_000E54_MCC7_BUSY(~0u)},
	{1898, S_000E54_MCD0_BUSY(~0u)},
	{1908, S_000E54_MCD1_BUSY(~0u)},
	{1918, S_000E54_MCD2_BUSY(~0u)},
	{1928, S_000E54_MCD3_BUSY(~0u)},
	{1938, S_000E54_MCD4_BUSY(~0u)},
	{1948, S_000E54_MCD5_BUSY(~0u)},
	{1958, S_000E54_MCD6_BUSY(~0u)},
	{1968, S_000E54_MCD7_BUSY(~0u)},
	/* 89 */
	{1978, S_00D034_IDLE(~0u)},
	{1983, S_00D034_REG_IDLE(~0u)},
	{1992, S_00D034_RB_EMPTY(~0u)},
	{2001, S_00D034_RB_FULL(~0u)},
	{2009, S_00D034_RB_CMD_IDLE(~0u)},
	{2021, S_00D034_RB_CMD_FULL(~0u)},
	{2033, S_00D034_IB_CMD_IDLE(~0u)},
	{2045, S_00D034_IB_CMD_FULL(~0u)},
	{2057, S_00D034_BLOCK_IDLE(~0u)},
	{2068, S_00D034_INSIDE_IB(~0u)},
	{2078, S_00D034_EX_IDLE(~0u)},
	{2086, S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(~0u)},
	{2112, S_00D034_PACKET_READY(~0u)},
	{2125, S_00D034_MC_WR_IDLE(~0u)},
	{2136, S_00D034_SRBM_IDLE(~0u)},
	{2146, S_00D034_CONTEXT_EMPTY(~0u)},
	{2160, S_00D034_DELTA_RPTR_FULL(~0u)},
	{2176, S_00D034_RB_MC_RREQ_IDLE(~0u)},
	{2192, S_00D034_IB_MC_RREQ_IDLE(~0u)},
	{2208, S_00D034_MC_RD_IDLE(~0u)},
	{2219, S_00D034_DELTA_RPTR_EMPTY(~0u)},
	{2236, S_00D034_MC_RD_RET_STALL(~0u)},
	{2252, S_00D034_MC_RD_NO_POLL_IDLE(~0u)},
	{2271, S_00D034_PREV_CMD_IDLE(~0u)},
	{2285, S_00D034_SEM_IDLE(~0u)},
	{2294, S_00D034_SEM_REQ_STALL(~0u)},
	{2308, S_00D034_SEM_RESP_STATE(~0u)},
	{2323, S_00D034_INT_IDLE(~0u)},
	{2332, S_00D034_INT_REQ_STALL(~0u)},
	/* 118 */
	{2346, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{2369, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{2392, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{2415, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{2435, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{2455, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{2475, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{2495, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{2515, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{2535, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{2555, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{2575, S_008008_RLC_RQ_PENDING(~0u)},
	{2590, S_008008_RLC_BUSY(~0u)},
	{2599, S_008008_TC_BUSY(~0u)},
	{2607, S_008008_TCC_CC_RESIDENT(~0u)},
	{2623, S_008008_CPF_BUSY(~0u)},
	{2632, S_008008_CPC_BUSY(~0u)},
	{2641, S_008008_CPG_BUSY(~0u)},
	{2650, S_008008_UTCL2_BUSY(~0u)},
	{2661, S_008008_EA_BUSY(~0u)},
	{2669, S_008008_RMI_BUSY(~0u)},
	{2678, S_008008_UTCL2_RQ_PENDING(~0u)},
	{2695, S_008008_CPF_RQ_PENDING(~0u)},
	{2710, S_008008_EA_LINK_BUSY(~0u)},
	{2723, S_008008_CPAXI_BUSY(~0u)},
	/* 143 */
	{2734, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{2757, S_008010_SRBM_RQ_PENDING(~0u)},
	{2773, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{2796, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{2819, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{2838, S_008010_DB_CLEAN(~0u)},
	{2847, S_008010_CB_CLEAN(~0u)},
	{2856, S_008010_TA_BUSY(~0u)},
	{2864, S_008010_GDS_BUSY(~0u)},
	{2873, S_008010_WD_BUSY_NO_DMA(~0u)},
	{2888, S_008010_VGT_BUSY(~0u)},
	{2897, S_008010_IA_BUSY_NO_DMA(~0u)},
	{2912, S_008010_IA_BUSY(~0u)},
	{2920, S_008010_SX_BUSY(~0u)},
	{2928, S_008010_WD_BUSY(~0u)},
	{2936, S_008010_SPI_BUSY(~0u)},
	{2945, S_008010_BCI_BUSY(~0u)},
	{2954, S_008010_SC_BUSY(~0u)},
	{2962, S_008010_PA_BUSY(~0u)},
	{2970, S_008010_DB_BUSY(~0u)},
	{2978, S_008010_CP_COHERENCY_BUSY(~0u)},
	{1457, S_008010_CP_BUSY(~0u)},
	{1679, S_008010_CB_BUSY(~0u)},
	{2996, S_008010_GUI_ACTIVE(~0u)},
	{3007, S_008010_RSMU_RQ_PENDING(~0u)},
	/* 168 */
	{3023, S_0084FC_OFFSET_UPDATE_DONE(~0u)},
	/* 169 */
	{3042, S_0085F0_DEST_BASE_0_ENA(~0u)},
	{3058, S_0085F0_DEST_BASE_1_ENA(~0u)},
	{3074, S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{3092, S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{3110, S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{3128, S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{3146, S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{3164, S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{3182, S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{3200, S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{3218, S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{3235, S_0085F0_DEST_BASE_2_ENA(~0u)},
	{3251, S_0085F0_DEST_BASE_3_ENA(~0u)},
	{3267, S_0085F0_TCL1_ACTION_ENA(~0u)},
	{3283, S_0085F0_TC_ACTION_ENA(~0u)},
	{3297, S_0085F0_CB_ACTION_ENA(~0u)},
	{3311, S_0085F0_DB_ACTION_ENA(~0u)},
	{3325, S_0085F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3346, S_0085F0_SH_ICACHE_ACTION_ENA(~0u)},
	/* 188 */
	{2838, S_008014_DB_CLEAN(~0u)},
	{2847, S_008014_CB_CLEAN(~0u)},
	{2945, S_008014_BCI_BUSY(~0u)},
	{2888, S_008014_VGT_BUSY(~0u)},
	{2962, S_008014_PA_BUSY(~0u)},
	{2856, S_008014_TA_BUSY(~0u)},
	{2920, S_008014_SX_BUSY(~0u)},
	{2936, S_008014_SPI_BUSY(~0u)},
	{2954, S_008014_SC_BUSY(~0u)},
	{2970, S_008014_DB_BUSY(~0u)},
	{1679, S_008014_CB_BUSY(~0u)},
	{2669, S_008014_RMI_BUSY(~0u)},
	/* 200 */
	{2838, S_008018_DB_CLEAN(~0u)},
	{2847, S_008018_CB_CLEAN(~0u)},
	{2945, S_008018_BCI_BUSY(~0u)},
	{2888, S_008018_VGT_BUSY(~0u)},
	{2962, S_008018_PA_BUSY(~0u)},
	{2856, S_008018_TA_BUSY(~0u)},
	{2920, S_008018_SX_BUSY(~0u)},
	{2936, S_008018_SPI_BUSY(~0u)},
	{2954, S_008018_SC_BUSY(~0u)},
	{2970, S_008018_DB_BUSY(~0u)},
	{1679, S_008018_CB_BUSY(~0u)},
	{2669, S_008018_RMI_BUSY(~0u)},
	/* 212 */
	{2838, S_008038_DB_CLEAN(~0u)},
	{2847, S_008038_CB_CLEAN(~0u)},
	{2945, S_008038_BCI_BUSY(~0u)},
	{2888, S_008038_VGT_BUSY(~0u)},
	{2962, S_008038_PA_BUSY(~0u)},
	{2856, S_008038_TA_BUSY(~0u)},
	{2920, S_008038_SX_BUSY(~0u)},
	{2936, S_008038_SPI_BUSY(~0u)},
	{2954, S_008038_SC_BUSY(~0u)},
	{2970, S_008038_DB_BUSY(~0u)},
	{1679, S_008038_CB_BUSY(~0u)},
	{2669, S_008038_RMI_BUSY(~0u)},
	/* 224 */
	{2838, S_00803C_DB_CLEAN(~0u)},
	{2847, S_00803C_CB_CLEAN(~0u)},
	{2945, S_00803C_BCI_BUSY(~0u)},
	{2888, S_00803C_VGT_BUSY(~0u)},
	{2962, S_00803C_PA_BUSY(~0u)},
	{2856, S_00803C_TA_BUSY(~0u)},
	{2920, S_00803C_SX_BUSY(~0u)},
	{2936, S_00803C_SPI_BUSY(~0u)},
	{2954, S_00803C_SC_BUSY(~0u)},
	{2970, S_00803C_DB_BUSY(~0u)},
	{1679, S_00803C_CB_BUSY(~0u)},
	{2669, S_00803C_RMI_BUSY(~0u)},
	/* 236 */
	{3023, S_0300FC_OFFSET_UPDATE_DONE(~0u)},
	/* 237 */
	{3367, S_0301E4_COHER_BASE_HI_256B(~0u)},
	/* 238 */
	{3386, S_0301EC_START_DELAY_COUNT(~0u)},
	/* 239 */
	{3042, S_0301F0_DEST_BASE_0_ENA(~0u)},
	{3058, S_0301F0_DEST_BASE_1_ENA(~0u)},
	{3404, S_0301F0_TC_SD_ACTION_ENA(~0u)},
	{3421, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{3074, S_0301F0_CB0_DEST_BASE_ENA(~0u)},
	{3092, S_0301F0_CB1_DEST_BASE_ENA(~0u)},
	{3110, S_0301F0_CB2_DEST_BASE_ENA(~0u)},
	{3128, S_0301F0_CB3_DEST_BASE_ENA(~0u)},
	{3146, S_0301F0_CB4_DEST_BASE_ENA(~0u)},
	{3164, S_0301F0_CB5_DEST_BASE_ENA(~0u)},
	{3182, S_0301F0_CB6_DEST_BASE_ENA(~0u)},
	{3200, S_0301F0_CB7_DEST_BASE_ENA(~0u)},
	{3218, S_0301F0_DB_DEST_BASE_ENA(~0u)},
	{3438, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{3458, S_0301F0_TC_VOL_ACTION_ENA(~0u)},
	{3476, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{3235, S_0301F0_DEST_BASE_2_ENA(~0u)},
	{3251, S_0301F0_DEST_BASE_3_ENA(~0u)},
	{3267, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{3283, S_0301F0_TC_ACTION_ENA(~0u)},
	{3297, S_0301F0_CB_ACTION_ENA(~0u)},
	{3311, S_0301F0_DB_ACTION_ENA(~0u)},
	{3325, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3493, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{3346, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{3518, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	{3542, S_0301F0_SH_SD_ACTION_ENA(~0u)},
	{3559, S_0301F0_TC_WC_ACTION_ENA(~0u)},
	{3576, S_0301F0_TC_INV_METADATA_ACTION_ENA(~0u)},
	/* 268 */
	{3603, S_0301FC_MATCHING_GFX_CNTX(~0u)},
	{3621, S_0301FC_MEID(~0u)},
	{3626, S_0301FC_PHASE1_STATUS(~0u)},
	{3633, S_0301FC_STATUS(~0u)},
	/* 272 */
	{3640, S_008210_MEC1_BUSY(~0u)},
	{3650, S_008210_MEC2_BUSY(~0u)},
	{3660, S_008210_DC0_BUSY(~0u)},
	{3669, S_008210_DC1_BUSY(~0u)},
	{3678, S_008210_RCIU1_BUSY(~0u)},
	{3689, S_008210_RCIU2_BUSY(~0u)},
	{3700, S_008210_ROQ1_BUSY(~0u)},
	{3710, S_008210_ROQ2_BUSY(~0u)},
	{3720, S_008210_TCIU_BUSY(~0u)},
	{3730, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{3747, S_008210_QU_BUSY(~0u)},
	{3755, S_008210_ATCL2IU_BUSY(~0u)},
	{3768, S_008210_CPG_CPC_BUSY(~0u)},
	{3781, S_008210_CPF_CPC_BUSY(~0u)},
	{2632, S_008210_CPC_BUSY(~0u)},
	{3794, S_008210_UTCL2IU_BUSY(~0u)},
	{3807, S_008210_SAVE_RESTORE_BUSY(~0u)},
	/* 289 */
	{3825, S_008214_MEC1_LOAD_BUSY(~0u)},
	{3840, S_008214_MEC1_SEMAPOHRE_BUSY(~0u)},
	{3860, S_008214_MEC1_MUTEX_BUSY(~0u)},
	{3876, S_008214_MEC1_MESSAGE_BUSY(~0u)},
	{3894, S_008214_MEC1_EOP_QUEUE_BUSY(~0u)},
	{3914, S_008214_MEC1_IQ_QUEUE_BUSY(~0u)},
	{3933, S_008214_MEC1_IB_QUEUE_BUSY(~0u)},
	{3952, S_008214_MEC1_TC_BUSY(~0u)},
	{3965, S_008214_MEC1_DMA_BUSY(~0u)},
	{3979, S_008214_MEC1_PARTIAL_FLUSH_BUSY(~0u)},
	{4003, S_008214_MEC1_PIPE0_BUSY(~0u)},
	{4019, S_008214_MEC1_PIPE1_BUSY(~0u)},
	{4035, S_008214_MEC1_PIPE2_BUSY(~0u)},
	{4051, S_008214_MEC1_PIPE3_BUSY(~0u)},
	{4067, S_008214_MEC2_LOAD_BUSY(~0u)},
	{4082, S_008214_MEC2_SEMAPOHRE_BUSY(~0u)},
	{4102, S_008214_MEC2_MUTEX_BUSY(~0u)},
	{4118, S_008214_MEC2_MESSAGE_BUSY(~0u)},
	{4136, S_008214_MEC2_EOP_QUEUE_BUSY(~0u)},
	{4156, S_008214_MEC2_IQ_QUEUE_BUSY(~0u)},
	{4175, S_008214_MEC2_IB_QUEUE_BUSY(~0u)},
	{4194, S_008214_MEC2_TC_BUSY(~0u)},
	{4207, S_008214_MEC2_DMA_BUSY(~0u)},
	{4221, S_008214_MEC2_PARTIAL_FLUSH_BUSY(~0u)},
	{4245, S_008214_MEC2_PIPE0_BUSY(~0u)},
	{4261, S_008214_MEC2_PIPE1_BUSY(~0u)},
	{4277, S_008214_MEC2_PIPE2_BUSY(~0u)},
	{4293, S_008214_MEC2_PIPE3_BUSY(~0u)},
	/* 317 */
	{4309, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{4328, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{4348, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{4367, S_008218_MEC1_DECODING_PACKET(~0u)},
	{4388, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{4406, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{4429, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{4451, S_008218_MEC2_DECODING_PACKET(~0u)},
	{4472, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{4490, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{4513, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{4535, S_008218_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4559, S_008218_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4583, S_008218_ATCL1_WAITING_ON_TRANS(~0u)},
	{4606, S_008218_UTCL2IU_WAITING_ON_FREE(~0u)},
	{4630, S_008218_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{4654, S_008218_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 334 */
	{4677, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{4696, S_00821C_CSF_BUSY(~0u)},
	{4705, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{4720, S_00821C_ROQ_RING_BUSY(~0u)},
	{4734, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{4753, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{4772, S_00821C_ROQ_STATE_BUSY(~0u)},
	{4787, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{4804, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4826, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{4848, S_00821C_SEMAPHORE_BUSY(~0u)},
	{4863, S_00821C_INTERRUPT_BUSY(~0u)},
	{3720, S_00821C_TCIU_BUSY(~0u)},
	{4878, S_00821C_HQD_BUSY(~0u)},
	{4887, S_00821C_PRT_BUSY(~0u)},
	{3755, S_00821C_ATCL2IU_BUSY(~0u)},
	{4896, S_00821C_CPF_GFX_BUSY(~0u)},
	{4909, S_00821C_CPF_CMP_BUSY(~0u)},
	{4922, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{4941, S_00821C_CPC_CPF_BUSY(~0u)},
	{2623, S_00821C_CPF_BUSY(~0u)},
	{3794, S_00821C_UTCL2IU_BUSY(~0u)},
	/* 356 */
	{4954, S_008220_REG_BUS_FIFO_BUSY(~0u)},
	{4972, S_008220_CSF_RING_BUSY(~0u)},
	{4986, S_008220_CSF_INDIRECT1_BUSY(~0u)},
	{5005, S_008220_CSF_INDIRECT2_BUSY(~0u)},
	{5024, S_008220_CSF_STATE_BUSY(~0u)},
	{5039, S_008220_CSF_CE_INDR1_BUSY(~0u)},
	{5057, S_008220_CSF_CE_INDR2_BUSY(~0u)},
	{5075, S_008220_CSF_ARBITER_BUSY(~0u)},
	{5092, S_008220_CSF_INPUT_BUSY(~0u)},
	{5107, S_008220_OUTSTANDING_READ_TAGS(~0u)},
	{5129, S_008220_HPD_PROCESSING_EOP_BUSY(~0u)},
	{5153, S_008220_HQD_DISPATCH_BUSY(~0u)},
	{5171, S_008220_HQD_IQ_TIMER_BUSY(~0u)},
	{5189, S_008220_HQD_DMA_OFFLOAD_BUSY(~0u)},
	{5210, S_008220_HQD_WAIT_SEMAPHORE_BUSY(~0u)},
	{5234, S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(~0u)},
	{5260, S_008220_HQD_MESSAGE_BUSY(~0u)},
	{5277, S_008220_HQD_PQ_FETCHER_BUSY(~0u)},
	{5297, S_008220_HQD_IB_FETCHER_BUSY(~0u)},
	{5317, S_008220_HQD_IQ_FETCHER_BUSY(~0u)},
	{5337, S_008220_HQD_EOP_FETCHER_BUSY(~0u)},
	{5358, S_008220_HQD_CONSUMED_RPTR_BUSY(~0u)},
	{5381, S_008220_HQD_FETCHER_ARB_BUSY(~0u)},
	{5402, S_008220_HQD_ROQ_ALIGN_BUSY(~0u)},
	{5421, S_008220_HQD_ROQ_EOP_BUSY(~0u)},
	{5438, S_008220_HQD_ROQ_IQ_BUSY(~0u)},
	{5454, S_008220_HQD_ROQ_PQ_BUSY(~0u)},
	{5470, S_008220_HQD_ROQ_IB_BUSY(~0u)},
	{5486, S_008220_HQD_WPTR_POLL_BUSY(~0u)},
	{5505, S_008220_HQD_PQ_BUSY(~0u)},
	{5517, S_008220_HQD_IB_BUSY(~0u)},
	/* 387 */
	{5529, S_008224_RING_FETCHING_DATA(~0u)},
	{5548, S_008224_INDR1_FETCHING_DATA(~0u)},
	{5568, S_008224_INDR2_FETCHING_DATA(~0u)},
	{5588, S_008224_STATE_FETCHING_DATA(~0u)},
	{5608, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{5629, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{4535, S_008224_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4559, S_008224_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4583, S_008224_ATCL1_WAITING_ON_TRANS(~0u)},
	{4606, S_008224_UTCL2IU_WAITING_ON_FREE(~0u)},
	{4630, S_008224_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{5650, S_008224_GFX_UTCL1_WAITING_ON_TRANS(~0u)},
	{5677, S_008224_CMP_UTCL1_WAITING_ON_TRANS(~0u)},
	{5704, S_008224_RCIU_WAITING_ON_FREE(~0u)},
	/* 401 */
	{5725, S_030230_COHER_SIZE_HI_256B(~0u)},
	/* 402 */
	{5744, S_0088B0_PRIM_COUNT(~0u)},
	/* 403 */
	{5755, S_0088C4_VS_NO_EXTRA_BUFFER(~0u)},
	{5774, S_0088C4_STREAMOUT_FULL_FLUSH(~0u)},
	{5795, S_0088C4_ES_LIMIT(~0u)},
	/* 406 */
	{5804, S_0088D4_VERT_REUSE(~0u)},
	/* 407 */
	{6331, S_008958_PRIM_TYPE(~0u), 29, 30},
	/* 408 */
	{203, S_00895C_INDEX_TYPE(~0u), 2, 59},
	/* 409 */
	{38, S_008988_SIZE(~0u)},
	/* 410 */
	{6383, S_0089B0_OFFCHIP_BUFFERING(~0u)},
	/* 411 */
	{6401, S_008A14_CLIP_VTX_REORDER_ENA(~0u)},
	{6422, S_008A14_NUM_CLIP_SEQ(~0u)},
	{6435, S_008A14_CLIPPED_PRIM_SEQ_STALL(~0u)},
	{6458, S_008A14_VE_NAN_PROC_DISABLE(~0u)},
	/* 415 */
	{6478, S_008A60_LINE_STIPPLE_VALUE(~0u)},
	/* 416 */
	{6497, S_008B10_CURRENT_PTR(~0u)},
	{6509, S_008B10_CURRENT_COUNT(~0u)},
	/* 418 */
	{6523, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{6548, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{6586, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{6627, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{6650, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{6673, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{6697, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6727, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6756, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{6782, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{6811, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{6836, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{5608, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{5629, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{6871, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{6899, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{4535, S_008670_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4559, S_008670_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4583, S_008670_ATCL1_WAITING_ON_TRANS(~0u)},
	{4606, S_008670_UTCL2IU_WAITING_ON_FREE(~0u)},
	{4630, S_008670_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{4654, S_008670_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 440 */
	{6929, S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(~0u)},
	{6956, S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(~0u)},
	{6983, S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(~0u)},
	{7012, S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(~0u)},
	{7041, S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(~0u)},
	{7070, S_008674_ME_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{7098, S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{7128, S_008674_ME_WAITING_ON_TC_READ_DATA(~0u)},
	{7155, S_008674_ME_WAITING_ON_REG_READ_DATA(~0u)},
	{7183, S_008674_RCIU_WAITING_ON_GDS_FREE(~0u)},
	{7208, S_008674_RCIU_WAITING_ON_GRBM_FREE(~0u)},
	{7234, S_008674_RCIU_WAITING_ON_VGT_FREE(~0u)},
	{7259, S_008674_RCIU_STALLED_ON_ME_READ(~0u)},
	{7283, S_008674_RCIU_STALLED_ON_DMA_READ(~0u)},
	{7308, S_008674_RCIU_STALLED_ON_APPEND_READ(~0u)},
	{7336, S_008674_RCIU_HALTED_BY_REG_VIOLATION(~0u)},
	/* 456 */
	{7365, S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{7391, S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(~0u)},
	{7417, S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7444, S_008678_PFP_TO_VGT_WRITES_PENDING(~0u)},
	{7470, S_008678_PFP_RCIU_READ_PENDING(~0u)},
	{7492, S_008678_PFP_WAITING_ON_BUFFER_DATA(~0u)},
	{7519, S_008678_ME_WAIT_ON_CE_COUNTER(~0u)},
	{7541, S_008678_ME_WAIT_ON_AVAIL_BUFFER(~0u)},
	{7565, S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(~0u)},
	{7590, S_008678_ME_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7613, S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(~0u)},
	{7640, S_008678_ME_WAITING_DATA_FROM_PFP(~0u)},
	{7665, S_008678_ME_WAITING_ON_PARTIAL_FLUSH(~0u)},
	{7693, S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7718, S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7743, S_008678_ME_WAITING_DATA_FROM_STQ(~0u)},
	{7768, S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{7797, S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{7828, S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(~0u)},
	{7856, S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(~0u)},
	{7883, S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(~0u)},
	{7913, S_008678_PIPE_STATS_WR_DATA_PENDING(~0u)},
	{7940, S_008678_APPEND_RDY_WAIT_ON_CS_DONE(~0u)},
	{7967, S_008678_APPEND_RDY_WAIT_ON_PS_DONE(~0u)},
	{7994, S_008678_APPEND_WAIT_ON_WR_CONFIRM(~0u)},
	{8020, S_008678_APPEND_ACTIVE_PARTITION(~0u)},
	{8044, S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(~0u)},
	{8076, S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(~0u)},
	{8103, S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(~0u)},
	/* 485 */
	{4720, S_008680_ROQ_RING_BUSY(~0u)},
	{4734, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{4753, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{4772, S_008680_ROQ_STATE_BUSY(~0u)},
	{8129, S_008680_DC_BUSY(~0u)},
	{3755, S_008680_ATCL2IU_BUSY(~0u)},
	{8137, S_008680_PFP_BUSY(~0u)},
	{8146, S_008680_MEQ_BUSY(~0u)},
	{8155, S_008680_ME_BUSY(~0u)},
	{8163, S_008680_QUERY_BUSY(~0u)},
	{4848, S_008680_SEMAPHORE_BUSY(~0u)},
	{4863, S_008680_INTERRUPT_BUSY(~0u)},
	{8174, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{1381, S_008680_DMA_BUSY(~0u)},
	{8192, S_008680_RCIU_BUSY(~0u)},
	{3730, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{8202, S_008680_CPC_CPG_BUSY(~0u)},
	{8215, S_008680_CE_BUSY(~0u)},
	{3720, S_008680_TCIU_BUSY(~0u)},
	{4787, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{4804, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4826, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{1457, S_008680_CP_BUSY(~0u)},
	{3794, S_008680_UTCL2IU_BUSY(~0u)},
	/* 509 */
	{8223, S_030800_INSTANCE_INDEX(~0u)},
	{8238, S_030800_SH_INDEX(~0u)},
	{8247, S_030800_SE_INDEX(~0u)},
	{8256, S_030800_SH_BROADCAST_WRITES(~0u)},
	{8276, S_030800_INSTANCE_BROADCAST_WRITES(~0u)},
	{8302, S_030800_SE_BROADCAST_WRITES(~0u)},
	/* 515 */
	{6331, S_030908_PRIM_TYPE(~0u), 29, 61},
	/* 516 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 59},
	{8322, S_03090C_PRIMGEN_EN(~0u)},
	/* 518 */
	{38, S_030938_SIZE(~0u)},
	/* 519 */
	{6383, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{8381, S_03093C_OFFCHIP_GRANULARITY(~0u), 4, 90},
	/* 521 */
	{6478, S_030A00_LINE_STIPPLE_VALUE(~0u)},
	/* 522 */
	{6497, S_030A04_CURRENT_PTR(~0u)},
	{6509, S_030A04_CURRENT_COUNT(~0u)},
	/* 524 */
	{445, S_030A10_X(~0u)},
	{91, S_030A10_Y(~0u)},
	/* 526 */
	{445, S_030A14_X(~0u)},
	{91, S_030A14_Y(~0u)},
	/* 528 */
	{445, S_030A18_X(~0u)},
	{91, S_030A18_Y(~0u)},
	/* 530 */
	{445, S_030A2C_X(~0u)},
	{91, S_030A2C_Y(~0u)},
	/* 532 */
	{8401, S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(~0u)},
	{8427, S_008BF0_DISABLE_SC_DB_TILE_FIX(~0u)},
	{8450, S_008BF0_DISABLE_AA_MASK_FULL_FIX(~0u)},
	{8475, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(~0u)},
	{8506, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(~0u)},
	{8540, S_008BF0_DISABLE_SCISSOR_FIX(~0u)},
	{8560, S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(~0u)},
	{8587, S_008BF0_SEND_UNLIT_STILES_TO_PACKER(~0u)},
	{8615, S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(~0u)},
	/* 541 */
	{8650, S_008C08_INST_INVALIDATE(~0u)},
	{8666, S_008C08_DATA_INVALIDATE(~0u)},
	/* 543 */
	{8650, S_030D20_INST_INVALIDATE(~0u)},
	{8666, S_030D20_DATA_INVALIDATE(~0u)},
	{8682, S_030D20_INVALIDATE_VOLATILE(~0u)},
	{8702, S_030D20_TARGET_INST(~0u)},
	{8714, S_030D20_TARGET_DATA(~0u)},
	{8655, S_030D20_INVALIDATE(~0u)},
	{8726, S_030D20_WRITEBACK(~0u)},
	{8736, S_030D20_VOL(~0u)},
	{8740, S_030D20_COMPLETE(~0u)},
	/* 552 */
	{8749, S_008C0C_RET(~0u)},
	{8753, S_008C0C_RUI(~0u)},
	{8757, S_008C0C_RNG(~0u)},
	/* 555 */
	{8330, S_008DFC_EN(~0u)},
	{8820, S_008DFC_TGT(~0u), 33, 94},
	{8824, S_008DFC_COMPR(~0u)},
	{3037, S_008DFC_DONE(~0u)},
	{8830, S_008DFC_VM(~0u)},
	{8850, S_008DFC_ENCODING(~0u), 63, 127},
	/* 561 */
	{8859, S_030E04_ADDRESS(~0u)},
	/* 562 */
	{8867, S_030F04_COUNT_HI(~0u)},
	/* 563 */
	{8876, S_008F04_BASE_ADDRESS_HI(~0u)},
	{8892, S_008F04_STRIDE(~0u)},
	{8899, S_008F04_CACHE_SWIZZLE(~0u)},
	{8913, S_008F04_SWIZZLE_ENABLE(~0u)},
	/* 567 */
	{8867, S_030F0C_COUNT_HI(~0u)},
	/* 568 */
	{9018, S_008F0C_DST_SEL_X(~0u), 8, 190},
	{9028, S_008F0C_DST_SEL_Y(~0u), 8, 190},
	{9038, S_008F0C_DST_SEL_Z(~0u), 8, 190},
	{9048, S_008F0C_DST_SEL_W(~0u), 8, 190},
	{9232, S_008F0C_NUM_FORMAT(~0u), 8, 198},
	{9624, S_008F0C_DATA_FORMAT(~0u), 16, 206},
	{9636, S_008F0C_ELEMENT_SIZE(~0u)},
	{9649, S_008F0C_INDEX_STRIDE(~0u)},
	{9662, S_008F0C_ADD_TID_ENABLE(~0u)},
	{9677, S_008F0C_ATC(~0u)},
	{9681, S_008F0C_HASH_ENABLE(~0u)},
	{9693, S_008F0C_HEAP(~0u)},
	{9698, S_008F0C_MTYPE(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 222},
	{9773, S_008F0C_USER_VM_ENABLE(~0u)},
	{9788, S_008F0C_USER_VM_MODE(~0u)},
	{9801, S_008F0C_NV(~0u)},
	/* 585 */
	{8867, S_030F14_COUNT_HI(~0u)},
	/* 586 */
	{8876, S_008F14_BASE_ADDRESS_HI(~0u)},
	{9804, S_008F14_MIN_LOD(~0u)},
	{11437, S_008F14_DATA_FORMAT_GFX6(~0u), 64, 226},
	{11821, S_008F14_NUM_FORMAT_GFX6(~0u), 16, 290},
	{9698, S_008F14_MTYPE(~0u)},
	{12395, S_008F14_DATA_FORMAT_GFX9(~0u), 64, 306},
	{12488, S_008F14_NUM_FORMAT_GFX9(~0u), 11, 370},
	{12723, S_008F14_NUM_FORMAT_FMASK(~0u), 13, 381},
	{12973, S_008F14_NUM_FORMAT_ASTC_2D(~0u), 14, 394},
	{13172, S_008F14_NUM_FORMAT_ASTC_3D(~0u), 10, 408},
	{9801, S_008F14_NV(~0u)},
	{13191, S_008F14_META_DIRECT(~0u)},
	/* 598 */
	{13203, S_008F18_WIDTH(~0u)},
	{13209, S_008F18_HEIGHT(~0u)},
	{13216, S_008F18_PERF_MOD(~0u)},
	{13225, S_008F18_INTERLACED(~0u)},
	/* 602 */
	{8867, S_030F1C_COUNT_HI(~0u)},
	/* 603 */
	{9018, S_008F1C_DST_SEL_X(~0u), 8, 190},
	{9028, S_008F1C_DST_SEL_Y(~0u), 8, 190},
	{9038, S_008F1C_DST_SEL_Z(~0u), 8, 190},
	{9048, S_008F1C_DST_SEL_W(~0u), 8, 190},
	{13236, S_008F1C_BASE_LEVEL(~0u)},
	{13247, S_008F1C_LAST_LEVEL(~0u)},
	{13258, S_008F1C_TILING_INDEX(~0u)},
	{13271, S_008F1C_POW2_PAD(~0u)},
	{9698, S_008F1C_MTYPE(~0u)},
	{9677, S_008F1C_ATC(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 418},
	{13582, S_008F1C_SW_MODE(~0u)},
	/* 615 */
	{13590, S_008F20_DEPTH(~0u)},
	{13596, S_008F20_PITCH_GFX6(~0u)},
	{13607, S_008F20_PITCH_GFX9(~0u)},
	{13714, S_008F20_BC_SWIZZLE(~0u), 6, 434},
	/* 619 */
	{13725, S_008F24_BASE_ARRAY(~0u)},
	{13736, S_008F24_LAST_ARRAY(~0u)},
	{13747, S_008F24_ARRAY_PITCH(~0u)},
	{13759, S_008F24_META_DATA_ADDRESS(~0u)},
	{13777, S_008F24_META_LINEAR(~0u)},
	{13789, S_008F24_META_PIPE_ALIGNED(~0u)},
	{13807, S_008F24_META_RB_ALIGNED(~0u)},
	{13823, S_008F24_MAX_MIP(~0u)},
	/* 627 */
	{13831, S_008F28_MIN_LOD_WARN(~0u)},
	{13844, S_008F28_COUNTER_BANK_ID(~0u)},
	{13860, S_008F28_LOD_HDW_CNT_EN(~0u)},
	{13875, S_008F28_COMPRESSION_EN(~0u)},
	{13890, S_008F28_ALPHA_IS_ON_MSB(~0u)},
	{13906, S_008F28_COLOR_TRANSFORM(~0u)},
	{13922, S_008F28_LOST_ALPHA_BITS(~0u)},
	{13938, S_008F28_LOST_COLOR_BITS(~0u)},
	/* 635 */
	{14136, S_008F30_CLAMP_X(~0u), 8, 440},
	{14144, S_008F30_CLAMP_Y(~0u), 8, 440},
	{14152, S_008F30_CLAMP_Z(~0u), 8, 440},
	{14160, S_008F30_MAX_ANISO_RATIO(~0u)},
	{14408, S_008F30_DEPTH_COMPARE_FUNC(~0u), 8, 448},
	{14427, S_008F30_FORCE_UNNORMALIZED(~0u)},
	{14446, S_008F30_ANISO_THRESHOLD(~0u)},
	{14462, S_008F30_MC_COORD_TRUNC(~0u)},
	{14477, S_008F30_FORCE_DEGAMMA(~0u)},
	{14491, S_008F30_ANISO_BIAS(~0u)},
	{14502, S_008F30_TRUNC_COORD(~0u)},
	{14514, S_008F30_DISABLE_CUBE_WRAP(~0u)},
	{14532, S_008F30_FILTER_MODE(~0u)},
	{14544, S_008F30_COMPAT_MODE(~0u)},
	/* 649 */
	{9804, S_008F34_MIN_LOD(~0u)},
	{14556, S_008F34_MAX_LOD(~0u)},
	{14564, S_008F34_PERF_MIP(~0u)},
	{14573, S_008F34_PERF_Z(~0u)},
	/* 653 */
	{14580, S_008F38_LOD_BIAS(~0u)},
	{14589, S_008F38_LOD_BIAS_SEC(~0u)},
	{14651, S_008F38_XY_MAG_FILTER(~0u), 2, 456},
	{14726, S_008F38_XY_MIN_FILTER(~0u), 4, 458},
	{14806, S_008F38_Z_FILTER(~0u), 3, 462},
	{14815, S_008F38_MIP_FILTER(~0u), 3, 462},
	{14826, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{14845, S_008F38_DISABLE_LSB_CEIL(~0u)},
	{14862, S_008F38_FILTER_PREC_FIX(~0u)},
	{14878, S_008F38_ANISO_OVERRIDE(~0u)},
	{14893, S_008F38_BLEND_ZERO_PRT(~0u)},
	/* 664 */
	{14908, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{15052, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 465},
	{15070, S_008F3C_SKIP_DEGAMMA(~0u)},
	/* 667 */
	{15083, S_0090DC_VS_LOW_THRESHOLD(~0u)},
	{15100, S_0090DC_GS_LOW_THRESHOLD(~0u)},
	{15117, S_0090DC_ES_LOW_THRESHOLD(~0u)},
	{15134, S_0090DC_HS_LOW_THRESHOLD(~0u)},
	{15151, S_0090DC_LS_LOW_THRESHOLD(~0u)},
	/* 672 */
	{15168, S_0090E0_PS_CU_EN(~0u)},
	{15177, S_0090E0_VS_CU_EN(~0u)},
	/* 674 */
	{15186, S_0090E4_GS_CU_EN(~0u)},
	{15195, S_0090E4_ES_CU_EN(~0u)},
	/* 676 */
	{15204, S_0090E8_LSHS_CU_EN(~0u)},
	/* 677 */
	{15215, S_0090EC_MAX_WAVE_ID(~0u)},
	/* 678 */
	{15215, S_0090E8_MAX_WAVE_ID(~0u)},
	/* 679 */
	{15232, S_0090F0_RING_ORDER_TS0(~0u), 1, 469},
	{15247, S_0090F0_RING_ORDER_TS1(~0u)},
	{15262, S_0090F0_RING_ORDER_TS2(~0u)},
	/* 682 */
	{15277, S_00C700_PIPE_ORDER_TS0(~0u)},
	{15292, S_00C700_PIPE_ORDER_TS1(~0u)},
	{15307, S_00C700_PIPE_ORDER_TS2(~0u)},
	{15322, S_00C700_PIPE_ORDER_TS3(~0u)},
	{15337, S_00C700_TS0_DUR_MULT(~0u)},
	{15350, S_00C700_TS1_DUR_MULT(~0u)},
	{15363, S_00C700_TS2_DUR_MULT(~0u)},
	{15376, S_00C700_TS3_DUR_MULT(~0u)},
	/* 690 */
	{15389, S_0090F4_TS0_DURATION(~0u)},
	{15402, S_0090F4_TS1_DURATION(~0u)},
	/* 692 */
	{15415, S_0090F8_TS2_DURATION(~0u)},
	/* 693 */
	{38, S_008F40_SIZE(~0u)},
	/* 694 */
	{657, S_008F44_OFFSET(~0u)},
	/* 695 */
	{8867, S_030FFC_COUNT_HI(~0u)},
	/* 696 */
	{15428, S_009100_GPR_WRITE_PRIORITY(~0u)},
	{15447, S_009100_EXP_PRIORITY_ORDER(~0u)},
	{15466, S_009100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{15488, S_009100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{15510, S_009100_RSRC_MGMT_RESET(~0u)},
	/* 701 */
	{15779, S_00913C_VTX_DONE_DELAY(~0u), 16, 470},
	{15794, S_00913C_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{15818, S_00913C_PC_LIMIT_ENABLE(~0u)},
	{15834, S_00913C_PC_LIMIT_STRICT(~0u)},
	{15850, S_00913C_PC_LIMIT_SIZE(~0u)},
	/* 706 */
	{15864, S_00936C_TYPE_A(~0u)},
	{15871, S_00936C_VGPR_A(~0u)},
	{15878, S_00936C_SGPR_A(~0u)},
	{15885, S_00936C_LDS_A(~0u)},
	{15891, S_00936C_WAVES_A(~0u)},
	{15899, S_00936C_EN_A(~0u)},
	{15904, S_00936C_TYPE_B(~0u)},
	{15911, S_00936C_VGPR_B(~0u)},
	{15918, S_00936C_SGPR_B(~0u)},
	{15925, S_00936C_LDS_B(~0u)},
	{15931, S_00936C_WAVES_B(~0u)},
	{15939, S_00936C_EN_B(~0u)},
	/* 718 */
	{15944, S_009858_MSAA1_X(~0u)},
	{15952, S_009858_MSAA1_Y(~0u)},
	{15960, S_009858_MSAA2_X(~0u)},
	{15968, S_009858_MSAA2_Y(~0u)},
	{15976, S_009858_MSAA4_X(~0u)},
	{15984, S_009858_MSAA4_Y(~0u)},
	{15992, S_009858_MSAA8_X(~0u)},
	{16000, S_009858_MSAA8_Y(~0u)},
	{16008, S_009858_MSAA16_X(~0u)},
	{16017, S_009858_MSAA16_Y(~0u)},
	/* 728 */
	{16026, S_0098F8_NUM_PIPES(~0u)},
	{16036, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX6(~0u)},
	{16062, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{16083, S_0098F8_NUM_SHADER_ENGINES_GFX6(~0u)},
	{16107, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{16131, S_0098F8_NUM_GPUS_GFX6(~0u)},
	{16145, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{16165, S_0098F8_ROW_SIZE(~0u)},
	{16174, S_0098F8_NUM_LOWER_PIPES(~0u)},
	{16190, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX9(~0u)},
	{16216, S_0098F8_MAX_COMPRESSED_FRAGS(~0u)},
	{16237, S_0098F8_NUM_BANKS(~0u)},
	{16247, S_0098F8_NUM_SHADER_ENGINES_GFX9(~0u)},
	{16271, S_0098F8_NUM_GPUS_GFX9(~0u)},
	{16285, S_0098F8_NUM_RB_PER_SE(~0u)},
	{16299, S_0098F8_SE_ENABLE(~0u)},
	/* 744 */
	{16426, S_009910_MICRO_TILE_MODE(~0u), 4, 486},
	{16671, S_009910_ARRAY_MODE(~0u), 16, 490},
	{17033, S_009910_PIPE_CONFIG(~0u), 15, 506},
	{17223, S_009910_TILE_SPLIT(~0u), 7, 521},
	{17326, S_009910_BANK_WIDTH(~0u), 4, 528},
	{17433, S_009910_BANK_HEIGHT(~0u), 4, 532},
	{17545, S_009910_MACRO_TILE_ASPECT(~0u), 4, 536},
	{16237, S_009910_NUM_BANKS(~0u), 4, 540},
	{17663, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 544},
	{17683, S_009910_SAMPLE_SPLIT(~0u)},
	/* 754 */
	{17326, S_009990_BANK_WIDTH(~0u)},
	{17433, S_009990_BANK_HEIGHT(~0u)},
	{17545, S_009990_MACRO_TILE_ASPECT(~0u)},
	{16237, S_009990_NUM_BANKS(~0u)},
	/* 758 */
	{17696, S_00B004_MEM_BASE(~0u)},
	/* 759 */
	{17696, S_00B00C_MEM_BASE(~0u)},
	/* 760 */
	{15171, S_00B01C_CU_EN(~0u)},
	{17705, S_00B01C_WAVE_LIMIT(~0u)},
	{17716, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	{17735, S_00B01C_SIMD_DISABLE(~0u)},
	/* 764 */
	{17696, S_00B024_MEM_BASE(~0u)},
	/* 765 */
	{17748, S_00B028_VGPRS(~0u)},
	{17754, S_00B028_SGPRS(~0u)},
	{15438, S_00B028_PRIORITY(~0u)},
	{17803, S_00B028_FLOAT_MODE(~0u), 241, 548},
	{17814, S_00B028_PRIV(~0u)},
	{17819, S_00B028_DX10_CLAMP(~0u)},
	{17830, S_00B028_DEBUG_MODE(~0u)},
	{17841, S_00B028_IEEE_MODE(~0u)},
	{17851, S_00B028_CU_GROUP_DISABLE(~0u)},
	{17868, S_00B028_CACHE_CTL(~0u)},
	{17878, S_00B028_CDBG_USER(~0u)},
	{17888, S_00B028_FP16_OVFL(~0u)},
	/* 777 */
	{17898, S_00B02C_SCRATCH_EN(~0u)},
	{17909, S_00B02C_USER_SGPR(~0u)},
	{17919, S_00B02C_TRAP_PRESENT(~0u)},
	{17932, S_00B02C_WAVE_CNT_EN(~0u)},
	{17944, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{17959, S_00B02C_EXCP_EN_SI(~0u)},
	{17970, S_00B02C_EXCP_EN(~0u)},
	{17978, S_00B02C_LOAD_COLLISION_WAVEID(~0u)},
	{18000, S_00B02C_LOAD_INTRAWAVE_COLLISION(~0u)},
	{18025, S_00B02C_SKIP_USGPR0(~0u)},
	{18037, S_00B02C_USER_SGPR_MSB(~0u)},
	/* 788 */
	{17696, S_00B104_MEM_BASE(~0u)},
	/* 789 */
	{17696, S_00B10C_MEM_BASE(~0u)},
	/* 790 */
	{15171, S_00B118_CU_EN(~0u)},
	{17705, S_00B118_WAVE_LIMIT(~0u)},
	{17716, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	{17735, S_00B118_SIMD_DISABLE(~0u)},
	/* 794 */
	{5798, S_00B11C_LIMIT(~0u)},
	/* 795 */
	{17696, S_00B124_MEM_BASE(~0u)},
	/* 796 */
	{17748, S_00B128_VGPRS(~0u)},
	{17754, S_00B128_SGPRS(~0u)},
	{15438, S_00B128_PRIORITY(~0u)},
	{17803, S_00B128_FLOAT_MODE(~0u)},
	{17814, S_00B128_PRIV(~0u)},
	{17819, S_00B128_DX10_CLAMP(~0u)},
	{17830, S_00B128_DEBUG_MODE(~0u)},
	{17841, S_00B128_IEEE_MODE(~0u)},
	{18051, S_00B128_VGPR_COMP_CNT(~0u)},
	{18065, S_00B128_CU_GROUP_ENABLE(~0u)},
	{17868, S_00B128_CACHE_CTL(~0u)},
	{17878, S_00B128_CDBG_USER(~0u)},
	{17888, S_00B128_FP16_OVFL(~0u)},
	/* 809 */
	{17898, S_00B12C_SCRATCH_EN(~0u)},
	{17909, S_00B12C_USER_SGPR(~0u)},
	{17919, S_00B12C_TRAP_PRESENT(~0u)},
	{18081, S_00B12C_OC_LDS_EN(~0u)},
	{18091, S_00B12C_SO_BASE0_EN(~0u)},
	{18103, S_00B12C_SO_BASE1_EN(~0u)},
	{18115, S_00B12C_SO_BASE2_EN(~0u)},
	{18127, S_00B12C_SO_BASE3_EN(~0u)},
	{18139, S_00B12C_SO_EN(~0u)},
	{17959, S_00B12C_EXCP_EN_SI(~0u)},
	{17970, S_00B12C_EXCP_EN(~0u)},
	{18145, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	{18162, S_00B12C_PC_BASE_EN(~0u)},
	{18025, S_00B12C_SKIP_USGPR0(~0u)},
	{18037, S_00B12C_USER_SGPR_MSB(~0u)},
	/* 824 */
	{17696, S_00B204_MEM_BASE(~0u)},
	/* 825 */
	{17696, S_00B20C_MEM_BASE(~0u)},
	/* 826 */
	{15171, S_00B21C_CU_EN(~0u)},
	{17705, S_00B21C_WAVE_LIMIT(~0u)},
	{17716, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{18173, S_00B21C_GROUP_FIFO_DEPTH(~0u)},
	{17735, S_00B21C_SIMD_DISABLE(~0u)},
	/* 831 */
	{17696, S_00B224_MEM_BASE(~0u)},
	/* 832 */
	{17748, S_00B228_VGPRS(~0u)},
	{17754, S_00B228_SGPRS(~0u)},
	{15438, S_00B228_PRIORITY(~0u)},
	{17803, S_00B228_FLOAT_MODE(~0u)},
	{17814, S_00B228_PRIV(~0u)},
	{17819, S_00B228_DX10_CLAMP(~0u)},
	{17830, S_00B228_DEBUG_MODE(~0u)},
	{17841, S_00B228_IEEE_MODE(~0u)},
	{18065, S_00B228_CU_GROUP_ENABLE(~0u)},
	{17868, S_00B228_CACHE_CTL(~0u)},
	{17878, S_00B228_CDBG_USER(~0u)},
	{18190, S_00B228_GS_VGPR_COMP_CNT(~0u)},
	{17888, S_00B228_FP16_OVFL(~0u)},
	/* 845 */
	{17898, S_00B22C_SCRATCH_EN(~0u)},
	{17909, S_00B22C_USER_SGPR(~0u)},
	{17919, S_00B22C_TRAP_PRESENT(~0u)},
	{17959, S_00B22C_EXCP_EN_SI(~0u)},
	{17970, S_00B22C_EXCP_EN(~0u)},
	{18207, S_00B22C_ES_VGPR_COMP_CNT(~0u)},
	{18081, S_00B22C_OC_LDS_EN(~0u)},
	{17950, S_00B22C_LDS_SIZE(~0u)},
	{18025, S_00B22C_SKIP_USGPR0(~0u)},
	{18037, S_00B22C_USER_SGPR_MSB(~0u)},
	/* 855 */
	{17696, S_00B304_MEM_BASE(~0u)},
	/* 856 */
	{17696, S_00B30C_MEM_BASE(~0u)},
	/* 857 */
	{15171, S_00B31C_CU_EN(~0u)},
	{17705, S_00B31C_WAVE_LIMIT(~0u)},
	{17716, S_00B31C_LOCK_LOW_THRESHOLD(~0u)},
	{18173, S_00B31C_GROUP_FIFO_DEPTH(~0u)},
	/* 861 */
	{17696, S_00B324_MEM_BASE(~0u)},
	/* 862 */
	{17748, S_00B328_VGPRS(~0u)},
	{17754, S_00B328_SGPRS(~0u)},
	{15438, S_00B328_PRIORITY(~0u)},
	{17803, S_00B328_FLOAT_MODE(~0u)},
	{17814, S_00B328_PRIV(~0u)},
	{17819, S_00B328_DX10_CLAMP(~0u)},
	{17830, S_00B328_DEBUG_MODE(~0u)},
	{17841, S_00B328_IEEE_MODE(~0u)},
	{18051, S_00B328_VGPR_COMP_CNT(~0u)},
	{18065, S_00B328_CU_GROUP_ENABLE(~0u)},
	{17868, S_00B328_CACHE_CTL(~0u)},
	{17878, S_00B328_CDBG_USER(~0u)},
	/* 874 */
	{17898, S_00B32C_SCRATCH_EN(~0u)},
	{17909, S_00B32C_USER_SGPR(~0u)},
	{17919, S_00B32C_TRAP_PRESENT(~0u)},
	{18081, S_00B32C_OC_LDS_EN(~0u)},
	{17959, S_00B32C_EXCP_EN_SI(~0u)},
	{17970, S_00B32C_EXCP_EN(~0u)},
	{17950, S_00B32C_LDS_SIZE(~0u)},
	/* 881 */
	{17696, S_00B404_MEM_BASE(~0u)},
	/* 882 */
	{17696, S_00B40C_MEM_BASE(~0u)},
	/* 883 */
	{17705, S_00B41C_WAVE_LIMIT(~0u)},
	{17716, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{18173, S_00B41C_GROUP_FIFO_DEPTH(~0u)},
	{17735, S_00B41C_SIMD_DISABLE(~0u)},
	{15171, S_00B41C_CU_EN(~0u)},
	/* 888 */
	{17696, S_00B424_MEM_BASE(~0u)},
	/* 889 */
	{17748, S_00B428_VGPRS(~0u)},
	{17754, S_00B428_SGPRS(~0u)},
	{15438, S_00B428_PRIORITY(~0u)},
	{17803, S_00B428_FLOAT_MODE(~0u)},
	{17814, S_00B428_PRIV(~0u)},
	{17819, S_00B428_DX10_CLAMP(~0u)},
	{17830, S_00B428_DEBUG_MODE(~0u)},
	{17841, S_00B428_IEEE_MODE(~0u)},
	{17868, S_00B428_CACHE_CTL(~0u)},
	{17878, S_00B428_CDBG_USER(~0u)},
	{18224, S_00B428_LS_VGPR_COMP_CNT(~0u)},
	{17888, S_00B428_FP16_OVFL(~0u)},
	/* 901 */
	{17898, S_00B42C_SCRATCH_EN(~0u)},
	{17909, S_00B42C_USER_SGPR(~0u)},
	{17919, S_00B42C_TRAP_PRESENT(~0u)},
	{18081, S_00B42C_OC_LDS_EN(~0u)},
	{18241, S_00B42C_TG_SIZE_EN(~0u)},
	{17959, S_00B42C_EXCP_EN_SI(~0u)},
	{18252, S_00B42C_EXCP_EN_CIK_VI(~0u)},
	{17970, S_00B42C_EXCP_EN(~0u)},
	{17950, S_00B42C_LDS_SIZE(~0u)},
	{18025, S_00B42C_SKIP_USGPR0(~0u)},
	{18037, S_00B42C_USER_SGPR_MSB(~0u)},
	/* 912 */
	{17696, S_00B504_MEM_BASE(~0u)},
	/* 913 */
	{17696, S_00B50C_MEM_BASE(~0u)},
	/* 914 */
	{15171, S_00B51C_CU_EN(~0u)},
	{17705, S_00B51C_WAVE_LIMIT(~0u)},
	{17716, S_00B51C_LOCK_LOW_THRESHOLD(~0u)},
	{18173, S_00B51C_GROUP_FIFO_DEPTH(~0u)},
	/* 918 */
	{17696, S_00B524_MEM_BASE(~0u)},
	/* 919 */
	{17748, S_00B528_VGPRS(~0u)},
	{17754, S_00B528_SGPRS(~0u)},
	{15438, S_00B528_PRIORITY(~0u)},
	{17803, S_00B528_FLOAT_MODE(~0u)},
	{17814, S_00B528_PRIV(~0u)},
	{17819, S_00B528_DX10_CLAMP(~0u)},
	{17830, S_00B528_DEBUG_MODE(~0u)},
	{17841, S_00B528_IEEE_MODE(~0u)},
	{18051, S_00B528_VGPR_COMP_CNT(~0u)},
	{17868, S_00B528_CACHE_CTL(~0u)},
	{17878, S_00B528_CDBG_USER(~0u)},
	/* 930 */
	{17898, S_00B52C_SCRATCH_EN(~0u)},
	{17909, S_00B52C_USER_SGPR(~0u)},
	{17919, S_00B52C_TRAP_PRESENT(~0u)},
	{17950, S_00B52C_LDS_SIZE(~0u)},
	{17959, S_00B52C_EXCP_EN_SI(~0u)},
	{17970, S_00B52C_EXCP_EN(~0u)},
	/* 936 */
	{18267, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{18285, S_00B800_PARTIAL_TG_EN(~0u)},
	{18299, S_00B800_FORCE_START_AT_000(~0u)},
	{18318, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{18338, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{18358, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{18380, S_00B800_ORDER_MODE(~0u)},
	{18391, S_00B800_DISPATCH_CACHE_CNTL(~0u)},
	{18411, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{18429, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{18447, S_00B800_DATA_ATC(~0u)},
	{18456, S_00B800_RESTORE(~0u)},
	{941, S_00B800_RESERVED(~0u)},
	/* 949 */
	{18464, S_00B81C_NUM_THREAD_FULL(~0u)},
	{18480, S_00B81C_NUM_THREAD_PARTIAL(~0u)},
	/* 951 */
	{18464, S_00B820_NUM_THREAD_FULL(~0u)},
	{18480, S_00B820_NUM_THREAD_PARTIAL(~0u)},
	/* 953 */
	{18464, S_00B824_NUM_THREAD_FULL(~0u)},
	{18480, S_00B824_NUM_THREAD_PARTIAL(~0u)},
	/* 955 */
	{15215, S_00B82C_MAX_WAVE_ID(~0u)},
	/* 956 */
	{18499, S_00B828_PIPELINESTAT_ENABLE(~0u)},
	/* 957 */
	{18519, S_00B82C_PERFCOUNT_ENABLE(~0u)},
	/* 958 */
	{391, S_00B834_DATA(~0u)},
	{18536, S_00B834_INST_ATC(~0u)},
	/* 960 */
	{391, S_00B83C_DATA(~0u)},
	/* 961 */
	{391, S_00B844_DATA(~0u)},
	/* 962 */
	{17748, S_00B848_VGPRS(~0u)},
	{17754, S_00B848_SGPRS(~0u)},
	{15438, S_00B848_PRIORITY(~0u)},
	{17803, S_00B848_FLOAT_MODE(~0u)},
	{17814, S_00B848_PRIV(~0u)},
	{17819, S_00B848_DX10_CLAMP(~0u)},
	{17830, S_00B848_DEBUG_MODE(~0u)},
	{17841, S_00B848_IEEE_MODE(~0u)},
	{18545, S_00B848_BULKY(~0u)},
	{17878, S_00B848_CDBG_USER(~0u)},
	{17888, S_00B848_FP16_OVFL(~0u)},
	/* 973 */
	{17898, S_00B84C_SCRATCH_EN(~0u)},
	{17909, S_00B84C_USER_SGPR(~0u)},
	{17919, S_00B84C_TRAP_PRESENT(~0u)},
	{18551, S_00B84C_TGID_X_EN(~0u)},
	{18561, S_00B84C_TGID_Y_EN(~0u)},
	{18571, S_00B84C_TGID_Z_EN(~0u)},
	{18241, S_00B84C_TG_SIZE_EN(~0u)},
	{18581, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{18596, S_00B84C_EXCP_EN_MSB(~0u)},
	{17950, S_00B84C_LDS_SIZE(~0u)},
	{17970, S_00B84C_EXCP_EN(~0u)},
	{18025, S_00B84C_SKIP_USGPR0(~0u)},
	/* 985 */
	{391, S_00B850_DATA(~0u)},
	/* 986 */
	{18608, S_00B854_WAVES_PER_SH_SI(~0u)},
	{18624, S_00B854_WAVES_PER_SH(~0u)},
	{18637, S_00B854_TG_PER_CU(~0u)},
	{18647, S_00B854_LOCK_THRESHOLD(~0u)},
	{18662, S_00B854_SIMD_DEST_CNTL(~0u)},
	{18677, S_00B854_FORCE_SIMD_DIST(~0u)},
	{18693, S_00B854_CU_GROUP_COUNT(~0u)},
	{17735, S_00B854_SIMD_DISABLE(~0u)},
	/* 994 */
	{18708, S_00B858_SH0_CU_EN(~0u)},
	{18718, S_00B858_SH1_CU_EN(~0u)},
	/* 996 */
	{18708, S_00B85C_SH0_CU_EN(~0u)},
	{18718, S_00B85C_SH1_CU_EN(~0u)},
	/* 998 */
	{18728, S_00B860_WAVES(~0u)},
	{18734, S_00B860_WAVESIZE(~0u)},
	/* 1000 */
	{18708, S_00B864_SH0_CU_EN(~0u)},
	{18718, S_00B864_SH1_CU_EN(~0u)},
	/* 1002 */
	{18708, S_00B868_SH0_CU_EN(~0u)},
	{18718, S_00B868_SH1_CU_EN(~0u)},
	/* 1004 */
	{18743, S_00B87C_SEND_SEID(~0u)},
	{16754, S_00B87C_RESERVED2(~0u)},
	{18753, S_00B87C_RESERVED3(~0u)},
	{18763, S_00B87C_RESERVED4(~0u)},
	{18773, S_00B87C_WAVE_ID_BASE(~0u)},
	/* 1009 */
	{18786, S_00B888_PAYLOAD(~0u)},
	{18794, S_00B888_IS_EVENT(~0u)},
	{18803, S_00B888_IS_STATE(~0u)},
	/* 1012 */
	{894, S_00B890_ADDR(~0u)},
	/* 1013 */
	{9677, S_00B894_ATC(~0u)},
	{9698, S_00B894_MTYPE(~0u)},
	/* 1015 */
	{18812, S_034404_PERFCOUNTER_HI(~0u)},
	/* 1016 */
	{18827, S_036004_PERF_SEL2(~0u)},
	{18837, S_036004_PERF_SEL3(~0u)},
	{18847, S_036004_CNTR_SEL2(~0u)},
	{18857, S_036004_CNTR_SEL3(~0u)},
	{18867, S_036004_CNTR_MODE3(~0u)},
	{18878, S_036004_CNTR_MODE2(~0u)},
	/* 1022 */
	{18889, S_036008_PERF_SEL(~0u)},
	{18898, S_036008_PERF_SEL1(~0u)},
	{18908, S_036008_CNTR_MODE(~0u)},
	{18918, S_036008_CNTR_SEL0(~0u)},
	{18928, S_036008_CNTR_SEL1(~0u)},
	{18938, S_036008_SPM_MODE(~0u)},
	{18947, S_036008_CNTR_MODE1(~0u)},
	{18958, S_036008_CNTR_MODE0(~0u)},
	/* 1030 */
	{18827, S_036010_PERF_SEL2(~0u)},
	{18837, S_036010_PERF_SEL3(~0u)},
	{18847, S_036010_CNTR_SEL2(~0u)},
	{18857, S_036010_CNTR_SEL3(~0u)},
	{18867, S_036010_CNTR_MODE3(~0u)},
	{18878, S_036010_CNTR_MODE2(~0u)},
	/* 1036 */
	{18827, S_036018_PERF_SEL2(~0u)},
	{18837, S_036018_PERF_SEL3(~0u)},
	{18847, S_036018_CNTR_SEL2(~0u)},
	{18857, S_036018_CNTR_SEL3(~0u)},
	{18867, S_036018_CNTR_MODE3(~0u)},
	{18878, S_036018_CNTR_MODE2(~0u)},
	/* 1042 */
	{18889, S_03601C_PERF_SEL(~0u)},
	{18898, S_03601C_PERF_SEL1(~0u)},
	{18908, S_03601C_CNTR_MODE(~0u)},
	{18918, S_03601C_CNTR_SEL0(~0u)},
	{18928, S_03601C_CNTR_SEL1(~0u)},
	{18938, S_03601C_SPM_MODE(~0u)},
	{18947, S_03601C_CNTR_MODE1(~0u)},
	{18958, S_03601C_CNTR_MODE0(~0u)},
	/* 1050 */
	{19016, S_036020_PERFMON_STATE(~0u), 3, 789},
	{19030, S_036020_SPM_PERFMON_STATE(~0u)},
	{19048, S_036020_PERFMON_ENABLE_MODE(~0u)},
	{19068, S_036020_PERFMON_SAMPLE_ENABLE(~0u)},
	/* 1054 */
	{18889, S_036024_PERF_SEL(~0u)},
	{18898, S_036024_PERF_SEL1(~0u)},
	{18908, S_036024_CNTR_MODE(~0u)},
	{18918, S_036024_CNTR_SEL0(~0u)},
	{18928, S_036024_CNTR_SEL1(~0u)},
	{18938, S_036024_SPM_MODE(~0u)},
	{18947, S_036024_CNTR_MODE1(~0u)},
	{18958, S_036024_CNTR_MODE0(~0u)},
	/* 1062 */
	{18889, S_036100_PERF_SEL(~0u)},
	{19090, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19117, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19144, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19171, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19197, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19223, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19250, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19276, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19302, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{19330, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19356, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19382, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{19408, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{19434, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{19461, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19488, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{19515, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{19541, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	{19567, S_036100_UTCL2_BUSY_USER_DEFINED_MASK(~0u)},
	{19596, S_036100_EA_BUSY_USER_DEFINED_MASK(~0u)},
	{19622, S_036100_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1084 */
	{18889, S_036108_PERF_SEL(~0u)},
	{19090, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19117, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19171, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19197, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19223, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19250, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19330, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19356, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19144, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19276, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19461, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19622, S_036108_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1097 */
	{18889, S_03610C_PERF_SEL(~0u)},
	{19090, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19117, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19171, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19197, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19223, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19250, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19330, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19356, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19144, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19276, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19461, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19622, S_03610C_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1110 */
	{18889, S_036110_PERF_SEL(~0u)},
	{19090, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19117, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19171, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19197, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19223, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19250, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19330, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19356, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19144, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19276, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19461, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19622, S_036110_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1123 */
	{18889, S_036114_PERF_SEL(~0u)},
	{19090, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19117, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{19171, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{19197, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{19223, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{19250, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{19330, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{19356, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{19144, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{19276, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{19461, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{19622, S_036114_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1136 */
	{18889, S_036200_PERF_SEL(~0u)},
	{19649, S_036200_PERF_MODE(~0u)},
	/* 1138 */
	{18889, S_036210_PERF_SEL(~0u)},
	{18898, S_036210_PERF_SEL1(~0u)},
	{18908, S_036210_CNTR_MODE(~0u)},
	{19659, S_036210_PERF_MODE1(~0u)},
	{19649, S_036210_PERF_MODE(~0u)},
	/* 1143 */
	{18827, S_036220_PERF_SEL2(~0u)},
	{18837, S_036220_PERF_SEL3(~0u)},
	{19670, S_036220_PERF_MODE3(~0u)},
	{19681, S_036220_PERF_MODE2(~0u)},
	/* 1147 */
	{18889, S_036230_PERF_SEL(~0u)},
	{18898, S_036230_PERF_SEL1(~0u)},
	{18908, S_036230_CNTR_MODE(~0u)},
	{19659, S_036230_PERF_MODE1(~0u)},
	{19649, S_036230_PERF_MODE(~0u)},
	/* 1152 */
	{18827, S_036240_PERF_SEL2(~0u)},
	{18837, S_036240_PERF_SEL3(~0u)},
	{19670, S_036240_PERF_MODE3(~0u)},
	{19681, S_036240_PERF_MODE2(~0u)},
	/* 1156 */
	{19692, S_036250_PERF_SEID_IGNORE_MASK(~0u)},
	/* 1157 */
	{18889, S_036400_PERF_SEL(~0u)},
	{18898, S_036400_PERF_SEL1(~0u)},
	{18908, S_036400_CNTR_MODE(~0u)},
	/* 1160 */
	{18827, S_036404_PERF_SEL2(~0u)},
	{18837, S_036404_PERF_SEL3(~0u)},
	/* 1162 */
	{18889, S_036500_PERF_SEL(~0u)},
	{18898, S_036500_PERF_SEL1(~0u)},
	{18908, S_036500_CNTR_MODE(~0u)},
	/* 1165 */
	{18827, S_036504_PERF_SEL2(~0u)},
	{18837, S_036504_PERF_SEL3(~0u)},
	/* 1167 */
	{18889, S_036600_PERF_SEL(~0u)},
	{18898, S_036600_PERF_SEL1(~0u)},
	{18908, S_036600_CNTR_MODE(~0u)},
	{19659, S_036600_PERF_MODE1(~0u)},
	{19649, S_036600_PERF_MODE(~0u)},
	/* 1172 */
	{18827, S_036610_PERF_SEL2(~0u)},
	{18837, S_036610_PERF_SEL3(~0u)},
	{19670, S_036610_PERF_MODE3(~0u)},
	{19681, S_036610_PERF_MODE2(~0u)},
	/* 1176 */
	{19714, S_036628_BIN0_MIN(~0u)},
	{19723, S_036628_BIN0_MAX(~0u)},
	{19732, S_036628_BIN1_MIN(~0u)},
	{19741, S_036628_BIN1_MAX(~0u)},
	{19750, S_036628_BIN2_MIN(~0u)},
	{19759, S_036628_BIN2_MAX(~0u)},
	{19768, S_036628_BIN3_MIN(~0u)},
	{19777, S_036628_BIN3_MAX(~0u)},
	/* 1184 */
	{18889, S_036700_PERF_SEL(~0u)},
	{19786, S_036700_SQC_BANK_MASK(~0u)},
	{19800, S_036700_SQC_CLIENT_MASK(~0u)},
	{18938, S_036700_SPM_MODE(~0u)},
	{19816, S_036700_SIMD_MASK(~0u)},
	{19649, S_036700_PERF_MODE(~0u)},
	/* 1190 */
	{19826, S_036780_PS_EN(~0u)},
	{19832, S_036780_VS_EN(~0u)},
	{19838, S_036780_GS_EN(~0u)},
	{19844, S_036780_ES_EN(~0u)},
	{19850, S_036780_HS_EN(~0u)},
	{19856, S_036780_LS_EN(~0u)},
	{19862, S_036780_CS_EN(~0u)},
	{19868, S_036780_CNTR_RATE(~0u)},
	{19878, S_036780_DISABLE_FLUSH(~0u)},
	/* 1199 */
	{19892, S_036784_SH0_MASK(~0u)},
	{19901, S_036784_SH1_MASK(~0u)},
	/* 1201 */
	{19910, S_036788_FORCE_EN(~0u)},
	/* 1202 */
	{19919, S_036900_PERFCOUNTER_SELECT(~0u)},
	{19938, S_036900_PERFCOUNTER_SELECT1(~0u)},
	{18908, S_036900_CNTR_MODE(~0u)},
	/* 1205 */
	{19958, S_036910_PERFCOUNTER_SELECT2(~0u)},
	{19978, S_036910_PERFCOUNTER_SELECT3(~0u)},
	/* 1207 */
	{19919, S_036A00_PERFCOUNTER_SELECT(~0u)},
	{19938, S_036A00_PERFCOUNTER_SELECT1(~0u)},
	{18908, S_036A00_CNTR_MODE(~0u)},
	/* 1210 */
	{19958, S_036A10_PERFCOUNTER_SELECT2(~0u)},
	{19978, S_036A10_PERFCOUNTER_SELECT3(~0u)},
	/* 1212 */
	{18889, S_036B00_PERF_SEL(~0u)},
	{18898, S_036B00_PERF_SEL1(~0u)},
	{18908, S_036B00_CNTR_MODE(~0u)},
	{19659, S_036B00_PERF_MODE1(~0u)},
	{19649, S_036B00_PERF_MODE(~0u)},
	/* 1217 */
	{18827, S_036B04_PERF_SEL2(~0u)},
	{18837, S_036B04_PERF_SEL3(~0u)},
	{19670, S_036B04_PERF_MODE3(~0u)},
	{19681, S_036B04_PERF_MODE2(~0u)},
	/* 1221 */
	{18889, S_036C00_PERF_SEL(~0u)},
	{18898, S_036C00_PERF_SEL1(~0u)},
	{18908, S_036C00_CNTR_MODE(~0u)},
	{19659, S_036C00_PERF_MODE1(~0u)},
	{19649, S_036C00_PERF_MODE(~0u)},
	/* 1226 */
	{18827, S_036C04_PERF_SEL2(~0u)},
	{18837, S_036C04_PERF_SEL3(~0u)},
	{19670, S_036C04_PERF_MODE3(~0u)},
	{19681, S_036C04_PERF_MODE2(~0u)},
	/* 1230 */
	{18889, S_036D00_PERF_SEL(~0u)},
	{18898, S_036D00_PERF_SEL1(~0u)},
	{18908, S_036D00_CNTR_MODE(~0u)},
	{19659, S_036D00_PERF_MODE1(~0u)},
	{19649, S_036D00_PERF_MODE(~0u)},
	/* 1235 */
	{18827, S_036D04_PERF_SEL2(~0u)},
	{18837, S_036D04_PERF_SEL3(~0u)},
	{19670, S_036D04_PERF_MODE3(~0u)},
	{19681, S_036D04_PERF_MODE2(~0u)},
	/* 1239 */
	{18889, S_036E00_PERF_SEL(~0u)},
	{18898, S_036E00_PERF_SEL1(~0u)},
	{18908, S_036E00_CNTR_MODE(~0u)},
	{19659, S_036E00_PERF_MODE1(~0u)},
	{19649, S_036E00_PERF_MODE(~0u)},
	/* 1244 */
	{18827, S_036E04_PERF_SEL2(~0u)},
	{18837, S_036E04_PERF_SEL3(~0u)},
	{19681, S_036E04_PERF_MODE2(~0u)},
	{19670, S_036E04_PERF_MODE3(~0u)},
	/* 1248 */
	{18889, S_036E40_PERF_SEL(~0u)},
	{18898, S_036E40_PERF_SEL1(~0u)},
	{18908, S_036E40_CNTR_MODE(~0u)},
	{19659, S_036E40_PERF_MODE1(~0u)},
	{19649, S_036E40_PERF_MODE(~0u)},
	/* 1253 */
	{18827, S_036E44_PERF_SEL2(~0u)},
	{18837, S_036E44_PERF_SEL3(~0u)},
	{19681, S_036E44_PERF_MODE2(~0u)},
	{19670, S_036E44_PERF_MODE3(~0u)},
	/* 1257 */
	{19998, S_037000_OP_FILTER_ENABLE(~0u)},
	{20015, S_037000_OP_FILTER_SEL(~0u)},
	{20029, S_037000_FORMAT_FILTER_ENABLE(~0u)},
	{20050, S_037000_FORMAT_FILTER_SEL(~0u)},
	{20068, S_037000_CLEAR_FILTER_ENABLE(~0u)},
	{20088, S_037000_CLEAR_FILTER_SEL(~0u)},
	{20105, S_037000_MRT_FILTER_ENABLE(~0u)},
	{20123, S_037000_MRT_FILTER_SEL(~0u)},
	{20138, S_037000_NUM_SAMPLES_FILTER_ENABLE(~0u)},
	{20164, S_037000_NUM_SAMPLES_FILTER_SEL(~0u)},
	{20187, S_037000_NUM_FRAGMENTS_FILTER_ENABLE(~0u)},
	{20215, S_037000_NUM_FRAGMENTS_FILTER_SEL(~0u)},
	/* 1269 */
	{18889, S_037004_PERF_SEL(~0u)},
	{18898, S_037004_PERF_SEL1(~0u)},
	{18908, S_037004_CNTR_MODE(~0u)},
	{19659, S_037004_PERF_MODE1(~0u)},
	{19649, S_037004_PERF_MODE(~0u)},
	/* 1274 */
	{18827, S_037008_PERF_SEL2(~0u)},
	{18837, S_037008_PERF_SEL3(~0u)},
	{19670, S_037008_PERF_MODE3(~0u)},
	{19681, S_037008_PERF_MODE2(~0u)},
	/* 1278 */
	{18889, S_037100_PERF_SEL(~0u)},
	{18898, S_037100_PERF_SEL1(~0u)},
	{18908, S_037100_CNTR_MODE(~0u)},
	{19659, S_037100_PERF_MODE1(~0u)},
	{19649, S_037100_PERF_MODE(~0u)},
	/* 1283 */
	{18827, S_037104_PERF_SEL2(~0u)},
	{18837, S_037104_PERF_SEL3(~0u)},
	{19670, S_037104_PERF_MODE3(~0u)},
	{19681, S_037104_PERF_MODE2(~0u)},
	/* 1287 */
	{20240, S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{20259, S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{20280, S_028000_DEPTH_COPY(~0u)},
	{20291, S_028000_STENCIL_COPY(~0u)},
	{20304, S_028000_RESUMMARIZE_ENABLE(~0u)},
	{20323, S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{20348, S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{20371, S_028000_COPY_CENTROID(~0u)},
	{20385, S_028000_COPY_SAMPLE(~0u)},
	{20397, S_028000_DECOMPRESS_ENABLE(~0u)},
	/* 1297 */
	{20415, S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{20439, S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{20460, S_028004_SAMPLE_RATE(~0u)},
	{20472, S_028004_ZPASS_ENABLE(~0u)},
	{20485, S_028004_ZFAIL_ENABLE(~0u)},
	{20498, S_028004_SFAIL_ENABLE(~0u)},
	{20511, S_028004_DBFAIL_ENABLE(~0u)},
	{20525, S_028004_SLICE_EVEN_ENABLE(~0u)},
	{20543, S_028004_SLICE_ODD_ENABLE(~0u)},
	/* 1306 */
	{20560, S_028008_SLICE_START(~0u)},
	{20572, S_028008_SLICE_MAX(~0u)},
	{20582, S_028008_Z_READ_ONLY(~0u)},
	{20594, S_028008_STENCIL_READ_ONLY(~0u)},
	{20612, S_028008_MIPID(~0u)},
	/* 1311 */
	{20670, S_02800C_FORCE_HIZ_ENABLE(~0u), 4, 792},
	{20687, S_02800C_FORCE_HIS_ENABLE0(~0u), 4, 792},
	{20705, S_02800C_FORCE_HIS_ENABLE1(~0u), 4, 792},
	{20723, S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{20744, S_02800C_FAST_Z_DISABLE(~0u)},
	{20759, S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{20780, S_02800C_NOOP_CULL_DISABLE(~0u)},
	{20798, S_02800C_FORCE_COLOR_KILL(~0u)},
	{20815, S_02800C_FORCE_Z_READ(~0u)},
	{20828, S_02800C_FORCE_STENCIL_READ(~0u)},
	{20847, S_02800C_FORCE_FULL_Z_RANGE(~0u), 4, 792},
	{20866, S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{20890, S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{20913, S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{20930, S_02800C_DISABLE_FULLY_COVERED(~0u)},
	{21015, S_02800C_FORCE_Z_LIMIT_SUMM(~0u), 4, 796},
	{21034, S_02800C_MAX_TILES_IN_DTT(~0u)},
	{21051, S_02800C_DISABLE_TILE_RATE_TILES(~0u)},
	{21075, S_02800C_FORCE_Z_DIRTY(~0u)},
	{21089, S_02800C_FORCE_STENCIL_DIRTY(~0u)},
	{21109, S_02800C_FORCE_Z_VALID(~0u)},
	{21123, S_02800C_FORCE_STENCIL_VALID(~0u)},
	{21143, S_02800C_PRESERVE_COMPRESSION(~0u)},
	/* 1334 */
	{21217, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 800},
	{21246, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{21277, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{21313, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{21348, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{21376, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{21398, S_028010_DISABLE_REG_SNOOP(~0u)},
	{21416, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{21448, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{21474, S_028010_HIZ_ZFUNC(~0u)},
	{21484, S_028010_HIS_SFUNC_FF(~0u)},
	{21497, S_028010_HIS_SFUNC_BF(~0u)},
	{21510, S_028010_PRESERVE_ZRANGE(~0u)},
	{21526, S_028010_PRESERVE_SRESULTS(~0u)},
	{21544, S_028010_DISABLE_FAST_PASS(~0u)},
	{21562, S_028010_ALLOW_PARTIAL_RES_HIER_KILL(~0u)},
	/* 1350 */
	{21590, S_028028_CLEAR(~0u)},
	/* 1351 */
	{21596, S_028030_TL_X(~0u)},
	{21601, S_028030_TL_Y(~0u)},
	/* 1353 */
	{21606, S_028034_BR_X(~0u)},
	{21611, S_028034_BR_Y(~0u)},
	/* 1355 */
	{21616, S_02803C_ADDR5_SWIZZLE_MASK(~0u)},
	{16671, S_02803C_ARRAY_MODE(~0u), 7, 804},
	{17033, S_02803C_PIPE_CONFIG(~0u), 18, 811},
	{17326, S_02803C_BANK_WIDTH(~0u), 4, 528},
	{17433, S_02803C_BANK_HEIGHT(~0u), 4, 532},
	{17545, S_02803C_MACRO_TILE_ASPECT(~0u), 4, 536},
	{16237, S_02803C_NUM_BANKS(~0u), 4, 540},
	/* 1362 */
	{9236, S_028040_FORMAT(~0u), 4, 829},
	{21768, S_028040_NUM_SAMPLES(~0u)},
	{17223, S_028040_TILE_SPLIT(~0u), 7, 521},
	{21780, S_028040_TILE_MODE_INDEX(~0u)},
	{21796, S_028040_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{21820, S_028040_ALLOW_EXPCLEAR(~0u)},
	{21835, S_028040_READ_SIZE(~0u)},
	{21845, S_028040_TILE_SURFACE_ENABLE(~0u)},
	{21865, S_028040_CLEAR_DISALLOWED(~0u)},
	{21882, S_028040_ZRANGE_PRECISION(~0u)},
	/* 1372 */
	{9236, S_028044_FORMAT(~0u), 2, 833},
	{17223, S_028044_TILE_SPLIT(~0u), 7, 521},
	{21780, S_028044_TILE_MODE_INDEX(~0u)},
	{21820, S_028044_ALLOW_EXPCLEAR(~0u)},
	{21925, S_028044_TILE_STENCIL_DISABLE(~0u)},
	{21865, S_028044_CLEAR_DISALLOWED(~0u)},
	/* 1378 */
	{21946, S_028058_PITCH_TILE_MAX(~0u)},
	{21961, S_028058_HEIGHT_TILE_MAX(~0u)},
	/* 1380 */
	{21977, S_02805C_SLICE_TILE_MAX(~0u)},
	/* 1381 */
	{8859, S_028084_ADDRESS(~0u)},
	/* 1382 */
	{21992, S_0281E8_DEST_BASE_HI_256B(~0u)},
	/* 1383 */
	{21992, S_0281EC_DEST_BASE_HI_256B(~0u)},
	/* 1384 */
	{21992, S_0281F0_DEST_BASE_HI_256B(~0u)},
	/* 1385 */
	{21992, S_0281F4_DEST_BASE_HI_256B(~0u)},
	/* 1386 */
	{22010, S_028200_WINDOW_X_OFFSET(~0u)},
	{22026, S_028200_WINDOW_Y_OFFSET(~0u)},
	/* 1388 */
	{21596, S_028204_TL_X(~0u)},
	{21601, S_028204_TL_Y(~0u)},
	{22042, S_028204_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1391 */
	{21606, S_028208_BR_X(~0u)},
	{21611, S_028208_BR_Y(~0u)},
	/* 1393 */
	{22064, S_02820C_CLIP_RULE(~0u)},
	/* 1394 */
	{21596, S_028210_TL_X(~0u)},
	{21601, S_028210_TL_Y(~0u)},
	/* 1396 */
	{21606, S_028214_BR_X(~0u)},
	{21611, S_028214_BR_Y(~0u)},
	/* 1398 */
	{22074, S_028230_ER_TRI(~0u)},
	{14616, S_028230_ER_POINT(~0u)},
	{22081, S_028230_ER_RECT(~0u)},
	{22089, S_028230_ER_LINE_LR(~0u)},
	{22100, S_028230_ER_LINE_RL(~0u)},
	{22111, S_028230_ER_LINE_TB(~0u)},
	{22122, S_028230_ER_LINE_BT(~0u)},
	/* 1405 */
	{22133, S_028234_HW_SCREEN_OFFSET_X(~0u)},
	{22152, S_028234_HW_SCREEN_OFFSET_Y(~0u)},
	/* 1407 */
	{22171, S_028238_TARGET0_ENABLE(~0u)},
	{22186, S_028238_TARGET1_ENABLE(~0u)},
	{22201, S_028238_TARGET2_ENABLE(~0u)},
	{22216, S_028238_TARGET3_ENABLE(~0u)},
	{22231, S_028238_TARGET4_ENABLE(~0u)},
	{22246, S_028238_TARGET5_ENABLE(~0u)},
	{22261, S_028238_TARGET6_ENABLE(~0u)},
	{22276, S_028238_TARGET7_ENABLE(~0u)},
	/* 1415 */
	{22291, S_02823C_OUTPUT0_ENABLE(~0u)},
	{22306, S_02823C_OUTPUT1_ENABLE(~0u)},
	{22321, S_02823C_OUTPUT2_ENABLE(~0u)},
	{22336, S_02823C_OUTPUT3_ENABLE(~0u)},
	{22351, S_02823C_OUTPUT4_ENABLE(~0u)},
	{22366, S_02823C_OUTPUT5_ENABLE(~0u)},
	{22381, S_02823C_OUTPUT6_ENABLE(~0u)},
	{22396, S_02823C_OUTPUT7_ENABLE(~0u)},
	/* 1423 */
	{21596, S_028240_TL_X(~0u)},
	{21601, S_028240_TL_Y(~0u)},
	{22042, S_028240_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1426 */
	{21606, S_028244_BR_X(~0u)},
	{21611, S_028244_BR_Y(~0u)},
	/* 1428 */
	{21596, S_028250_TL_X(~0u)},
	{21601, S_028250_TL_Y(~0u)},
	{22042, S_028250_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1431 */
	{21606, S_028254_BR_X(~0u)},
	{21611, S_028254_BR_Y(~0u)},
	/* 1433 */
	{22503, S_028350_RB_MAP_PKR0(~0u), 4, 835},
	{22515, S_028350_RB_MAP_PKR1(~0u), 4, 835},
	{22627, S_028350_RB_XSEL2(~0u), 4, 839},
	{22636, S_028350_RB_XSEL(~0u)},
	{22644, S_028350_RB_YSEL(~0u)},
	{22748, S_028350_PKR_MAP(~0u), 4, 843},
	{22856, S_028350_PKR_XSEL(~0u), 4, 847},
	{22965, S_028350_PKR_YSEL(~0u), 4, 851},
	{23078, S_028350_PKR_XSEL2(~0u), 4, 855},
	{23180, S_028350_SC_MAP(~0u), 4, 859},
	{23326, S_028350_SC_XSEL(~0u), 4, 863},
	{23473, S_028350_SC_YSEL(~0u), 4, 867},
	{23573, S_028350_SE_MAP(~0u), 4, 871},
	{23719, S_028350_SE_XSEL_GFX6(~0u), 4, 875},
	{23871, S_028350_SE_YSEL_GFX6(~0u), 4, 879},
	{23884, S_028350_SE_XSEL_GFX9(~0u)},
	{23897, S_028350_SE_YSEL_GFX9(~0u)},
	/* 1450 */
	{24022, S_028354_SE_PAIR_MAP(~0u), 4, 883},
	{24193, S_028354_SE_PAIR_XSEL_GFX6(~0u), 4, 887},
	{24370, S_028354_SE_PAIR_YSEL_GFX6(~0u), 4, 891},
	{24388, S_028354_SE_PAIR_XSEL_GFX9(~0u)},
	{24406, S_028354_SE_PAIR_YSEL_GFX9(~0u)},
	/* 1455 */
	{20525, S_028358_SLICE_EVEN_ENABLE(~0u)},
	{20543, S_028358_SLICE_ODD_ENABLE(~0u)},
	/* 1457 */
	{24424, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{24451, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{24490, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	/* 1460 */
	{24756, S_02842C_STENCILFAIL(~0u), 16, 895},
	{24768, S_02842C_STENCILZPASS(~0u), 16, 895},
	{24781, S_02842C_STENCILZFAIL(~0u), 16, 895},
	{24794, S_02842C_STENCILFAIL_BF(~0u), 16, 895},
	{24809, S_02842C_STENCILZPASS_BF(~0u), 16, 895},
	{24825, S_02842C_STENCILZFAIL_BF(~0u), 16, 895},
	/* 1466 */
	{24841, S_028430_STENCILTESTVAL(~0u)},
	{24856, S_028430_STENCILMASK(~0u)},
	{24868, S_028430_STENCILWRITEMASK(~0u)},
	{24885, S_028430_STENCILOPVAL(~0u)},
	/* 1470 */
	{24898, S_028434_STENCILTESTVAL_BF(~0u)},
	{24916, S_028434_STENCILMASK_BF(~0u)},
	{24931, S_028434_STENCILWRITEMASK_BF(~0u)},
	{24951, S_028434_STENCILOPVAL_BF(~0u)},
	/* 1474 */
	{657, S_028644_OFFSET(~0u)},
	{24974, S_028644_DEFAULT_VAL(~0u), 1, 911},
	{24986, S_028644_FLAT_SHADE(~0u)},
	{24997, S_028644_CYL_WRAP(~0u)},
	{25006, S_028644_PT_SPRITE_TEX(~0u)},
	{25020, S_028644_DUP(~0u)},
	{25024, S_028644_FP16_INTERP_MODE(~0u)},
	{25041, S_028644_USE_DEFAULT_ATTR1(~0u)},
	{25059, S_028644_DEFAULT_VAL_ATTR1(~0u)},
	{25077, S_028644_PT_SPRITE_TEX_ATTR1(~0u)},
	{25097, S_028644_ATTR0_VALID(~0u)},
	{25109, S_028644_ATTR1_VALID(~0u)},
	/* 1486 */
	{25121, S_0286C4_VS_EXPORT_COUNT(~0u)},
	{25137, S_0286C4_VS_HALF_PACK(~0u)},
	{25150, S_0286C4_VS_EXPORTS_FOG(~0u)},
	{25165, S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
	/* 1490 */
	{25185, S_0286CC_PERSP_SAMPLE_ENA(~0u)},
	{25202, S_0286CC_PERSP_CENTER_ENA(~0u)},
	{25219, S_0286CC_PERSP_CENTROID_ENA(~0u)},
	{25238, S_0286CC_PERSP_PULL_MODEL_ENA(~0u)},
	{25259, S_0286CC_LINEAR_SAMPLE_ENA(~0u)},
	{25277, S_0286CC_LINEAR_CENTER_ENA(~0u)},
	{25295, S_0286CC_LINEAR_CENTROID_ENA(~0u)},
	{25315, S_0286CC_LINE_STIPPLE_TEX_ENA(~0u)},
	{25336, S_0286CC_POS_X_FLOAT_ENA(~0u)},
	{25352, S_0286CC_POS_Y_FLOAT_ENA(~0u)},
	{25368, S_0286CC_POS_Z_FLOAT_ENA(~0u)},
	{25384, S_0286CC_POS_W_FLOAT_ENA(~0u)},
	{25400, S_0286CC_FRONT_FACE_ENA(~0u)},
	{25415, S_0286CC_ANCILLARY_ENA(~0u)},
	{25429, S_0286CC_SAMPLE_COVERAGE_ENA(~0u)},
	{25449, S_0286CC_POS_FIXED_PT_ENA(~0u)},
	/* 1506 */
	{25185, S_0286D0_PERSP_SAMPLE_ENA(~0u)},
	{25202, S_0286D0_PERSP_CENTER_ENA(~0u)},
	{25219, S_0286D0_PERSP_CENTROID_ENA(~0u)},
	{25238, S_0286D0_PERSP_PULL_MODEL_ENA(~0u)},
	{25259, S_0286D0_LINEAR_SAMPLE_ENA(~0u)},
	{25277, S_0286D0_LINEAR_CENTER_ENA(~0u)},
	{25295, S_0286D0_LINEAR_CENTROID_ENA(~0u)},
	{25315, S_0286D0_LINE_STIPPLE_TEX_ENA(~0u)},
	{25336, S_0286D0_POS_X_FLOAT_ENA(~0u)},
	{25352, S_0286D0_POS_Y_FLOAT_ENA(~0u)},
	{25368, S_0286D0_POS_Z_FLOAT_ENA(~0u)},
	{25384, S_0286D0_POS_W_FLOAT_ENA(~0u)},
	{25400, S_0286D0_FRONT_FACE_ENA(~0u)},
	{25415, S_0286D0_ANCILLARY_ENA(~0u)},
	{25429, S_0286D0_SAMPLE_COVERAGE_ENA(~0u)},
	{25449, S_0286D0_POS_FIXED_PT_ENA(~0u)},
	/* 1522 */
	{25466, S_0286D4_FLAT_SHADE_ENA(~0u)},
	{25481, S_0286D4_PNT_SPRITE_ENA(~0u)},
	{25604, S_0286D4_PNT_SPRITE_OVRD_X(~0u), 5, 912},
	{25622, S_0286D4_PNT_SPRITE_OVRD_Y(~0u), 5, 912},
	{25640, S_0286D4_PNT_SPRITE_OVRD_Z(~0u), 5, 912},
	{25658, S_0286D4_PNT_SPRITE_OVRD_W(~0u), 5, 912},
	{25676, S_0286D4_PNT_SPRITE_TOP_1(~0u)},
	/* 1529 */
	{25693, S_0286D8_NUM_INTERP(~0u)},
	{25704, S_0286D8_PARAM_GEN(~0u)},
	{25714, S_0286D8_FOG_ADDR(~0u)},
	{25723, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	{25743, S_0286D8_PASS_FOG_THROUGH_PS(~0u)},
	{25763, S_0286D8_OFFCHIP_PARAM_EN(~0u)},
	{25780, S_0286D8_LATE_PC_DEALLOC(~0u)},
	/* 1536 */
	{25796, S_0286E0_PERSP_CENTER_CNTL(~0u)},
	{25814, S_0286E0_PERSP_CENTROID_CNTL(~0u)},
	{25834, S_0286E0_LINEAR_CENTER_CNTL(~0u)},
	{25853, S_0286E0_LINEAR_CENTROID_CNTL(~0u)},
	{25923, S_0286E0_POS_FLOAT_LOCATION(~0u), 1, 917},
	{25942, S_0286E0_POS_FLOAT_ULC(~0u)},
	{25956, S_0286E0_FRONT_FACE_ALL_BITS(~0u)},
	/* 1543 */
	{18728, S_0286E8_WAVES(~0u)},
	{18734, S_0286E8_WAVESIZE(~0u)},
	/* 1545 */
	{25976, S_028704_NUM_PS_WAVES(~0u)},
	{25989, S_028704_NUM_VS_WAVES(~0u)},
	{26002, S_028704_NUM_GS_WAVES(~0u)},
	{26015, S_028704_NUM_ES_WAVES(~0u)},
	{26028, S_028704_NUM_HS_WAVES(~0u)},
	/* 1550 */
	{26041, S_028708_NUM_LS_WAVES(~0u)},
	/* 1551 */
	{26142, S_02870C_POS0_EXPORT_FORMAT(~0u), 5, 918},
	{26161, S_02870C_POS1_EXPORT_FORMAT(~0u), 5, 918},
	{26180, S_02870C_POS2_EXPORT_FORMAT(~0u), 5, 918},
	{26199, S_02870C_POS3_EXPORT_FORMAT(~0u), 5, 918},
	/* 1555 */
	{26418, S_028710_Z_EXPORT_FORMAT(~0u), 10, 923},
	/* 1556 */
	{26434, S_028714_COL0_EXPORT_FORMAT(~0u), 10, 923},
	{26453, S_028714_COL1_EXPORT_FORMAT(~0u), 10, 923},
	{26472, S_028714_COL2_EXPORT_FORMAT(~0u), 10, 923},
	{26491, S_028714_COL3_EXPORT_FORMAT(~0u), 10, 923},
	{26510, S_028714_COL4_EXPORT_FORMAT(~0u), 10, 923},
	{26529, S_028714_COL5_EXPORT_FORMAT(~0u), 10, 923},
	{26548, S_028714_COL6_EXPORT_FORMAT(~0u), 10, 923},
	{26567, S_028714_COL7_EXPORT_FORMAT(~0u), 10, 923},
	/* 1564 */
	{26821, S_028754_MRT0(~0u), 11, 933},
	{26826, S_028754_MRT1(~0u)},
	{26831, S_028754_MRT2(~0u)},
	{26836, S_028754_MRT3(~0u)},
	{26841, S_028754_MRT4(~0u)},
	{26846, S_028754_MRT5(~0u)},
	{26851, S_028754_MRT6(~0u)},
	{26856, S_028754_MRT7(~0u)},
	/* 1572 */
	{26941, S_028758_MRT0_EPSILON(~0u), 16, 944},
	{26954, S_028758_MRT1_EPSILON(~0u)},
	{26967, S_028758_MRT2_EPSILON(~0u)},
	{26980, S_028758_MRT3_EPSILON(~0u)},
	{26993, S_028758_MRT4_EPSILON(~0u)},
	{27006, S_028758_MRT5_EPSILON(~0u)},
	{27019, S_028758_MRT6_EPSILON(~0u)},
	{27032, S_028758_MRT7_EPSILON(~0u)},
	/* 1580 */
	{27045, S_02875C_MRT0_COLOR_OPT_DISABLE(~0u)},
	{27068, S_02875C_MRT0_ALPHA_OPT_DISABLE(~0u)},
	{27091, S_02875C_MRT1_COLOR_OPT_DISABLE(~0u)},
	{27114, S_02875C_MRT1_ALPHA_OPT_DISABLE(~0u)},
	{27137, S_02875C_MRT2_COLOR_OPT_DISABLE(~0u)},
	{27160, S_02875C_MRT2_ALPHA_OPT_DISABLE(~0u)},
	{27183, S_02875C_MRT3_COLOR_OPT_DISABLE(~0u)},
	{27206, S_02875C_MRT3_ALPHA_OPT_DISABLE(~0u)},
	{27229, S_02875C_MRT4_COLOR_OPT_DISABLE(~0u)},
	{27252, S_02875C_MRT4_ALPHA_OPT_DISABLE(~0u)},
	{27275, S_02875C_MRT5_COLOR_OPT_DISABLE(~0u)},
	{27298, S_02875C_MRT5_ALPHA_OPT_DISABLE(~0u)},
	{27321, S_02875C_MRT6_COLOR_OPT_DISABLE(~0u)},
	{27344, S_02875C_MRT6_ALPHA_OPT_DISABLE(~0u)},
	{27367, S_02875C_MRT7_COLOR_OPT_DISABLE(~0u)},
	{27390, S_02875C_MRT7_ALPHA_OPT_DISABLE(~0u)},
	{27413, S_02875C_PIXEN_ZERO_OPT_DISABLE(~0u)},
	/* 1597 */
	{27704, S_028760_COLOR_SRC_OPT(~0u), 8, 960},
	{27718, S_028760_COLOR_DST_OPT(~0u)},
	{27866, S_028760_COLOR_COMB_FCN(~0u), 8, 968},
	{27881, S_028760_ALPHA_SRC_OPT(~0u)},
	{27895, S_028760_ALPHA_DST_OPT(~0u)},
	{27909, S_028760_ALPHA_COMB_FCN(~0u)},
	/* 1603 */
	{27704, S_028764_COLOR_SRC_OPT(~0u)},
	{27718, S_028764_COLOR_DST_OPT(~0u)},
	{27866, S_028764_COLOR_COMB_FCN(~0u)},
	{27881, S_028764_ALPHA_SRC_OPT(~0u)},
	{27895, S_028764_ALPHA_DST_OPT(~0u)},
	{27909, S_028764_ALPHA_COMB_FCN(~0u)},
	/* 1609 */
	{27704, S_028768_COLOR_SRC_OPT(~0u)},
	{27718, S_028768_COLOR_DST_OPT(~0u)},
	{27866, S_028768_COLOR_COMB_FCN(~0u)},
	{27881, S_028768_ALPHA_SRC_OPT(~0u)},
	{27895, S_028768_ALPHA_DST_OPT(~0u)},
	{27909, S_028768_ALPHA_COMB_FCN(~0u)},
	/* 1615 */
	{27704, S_02876C_COLOR_SRC_OPT(~0u)},
	{27718, S_02876C_COLOR_DST_OPT(~0u)},
	{27866, S_02876C_COLOR_COMB_FCN(~0u)},
	{27881, S_02876C_ALPHA_SRC_OPT(~0u)},
	{27895, S_02876C_ALPHA_DST_OPT(~0u)},
	{27909, S_02876C_ALPHA_COMB_FCN(~0u)},
	/* 1621 */
	{27704, S_028770_COLOR_SRC_OPT(~0u)},
	{27718, S_028770_COLOR_DST_OPT(~0u)},
	{27866, S_028770_COLOR_COMB_FCN(~0u)},
	{27881, S_028770_ALPHA_SRC_OPT(~0u)},
	{27895, S_028770_ALPHA_DST_OPT(~0u)},
	{27909, S_028770_ALPHA_COMB_FCN(~0u)},
	/* 1627 */
	{27704, S_028774_COLOR_SRC_OPT(~0u)},
	{27718, S_028774_COLOR_DST_OPT(~0u)},
	{27866, S_028774_COLOR_COMB_FCN(~0u)},
	{27881, S_028774_ALPHA_SRC_OPT(~0u)},
	{27895, S_028774_ALPHA_DST_OPT(~0u)},
	{27909, S_028774_ALPHA_COMB_FCN(~0u)},
	/* 1633 */
	{27704, S_028778_COLOR_SRC_OPT(~0u)},
	{27718, S_028778_COLOR_DST_OPT(~0u)},
	{27866, S_028778_COLOR_COMB_FCN(~0u)},
	{27881, S_028778_ALPHA_SRC_OPT(~0u)},
	{27895, S_028778_ALPHA_DST_OPT(~0u)},
	{27909, S_028778_ALPHA_COMB_FCN(~0u)},
	/* 1639 */
	{27704, S_02877C_COLOR_SRC_OPT(~0u)},
	{27718, S_02877C_COLOR_DST_OPT(~0u)},
	{27866, S_02877C_COLOR_COMB_FCN(~0u)},
	{27881, S_02877C_ALPHA_SRC_OPT(~0u)},
	{27895, S_02877C_ALPHA_DST_OPT(~0u)},
	{27909, S_02877C_ALPHA_COMB_FCN(~0u)},
	/* 1645 */
	{28318, S_028780_COLOR_SRCBLEND(~0u), 21, 976},
	{27866, S_028780_COLOR_COMB_FCN(~0u), 5, 997},
	{28423, S_028780_COLOR_DESTBLEND(~0u), 21, 976},
	{28439, S_028780_ALPHA_SRCBLEND(~0u), 21, 976},
	{27909, S_028780_ALPHA_COMB_FCN(~0u), 5, 997},
	{28454, S_028780_ALPHA_DESTBLEND(~0u), 21, 976},
	{28470, S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{830, S_028780_ENABLE(~0u)},
	{28491, S_028780_DISABLE_ROP3(~0u)},
	/* 1654 */
	{28504, S_0287CC_SRC_STATE_ID(~0u)},
	/* 1655 */
	{28517, S_0287E4_BASE_ADDR_GFX6(~0u)},
	{28532, S_0287E4_BASE_ADDR_GFX9(~0u)},
	/* 1657 */
	{28625, S_0287F0_SOURCE_SELECT(~0u), 4, 1002},
	{28671, S_0287F0_MAJOR_MODE(~0u), 2, 1006},
	{28682, S_0287F0_NOT_EOP(~0u)},
	{28690, S_0287F0_USE_OPAQUE(~0u)},
	{28701, S_0287F0_SPRITE_EN_R6XX(~0u)},
	{28716, S_0287F0_UNROLLED_INST(~0u)},
	{28730, S_0287F0_GRBM_SKEW_NO_DEC(~0u)},
	{28747, S_0287F0_REG_RT_INDEX(~0u)},
	/* 1665 */
	{28760, S_0287F8_ADDRESS_LOW(~0u)},
	/* 1666 */
	{28772, S_028800_STENCIL_ENABLE(~0u)},
	{20678, S_028800_Z_ENABLE(~0u)},
	{28787, S_028800_Z_WRITE_ENABLE(~0u)},
	{28802, S_028800_DEPTH_BOUNDS_ENABLE(~0u)},
	{21478, S_028800_ZFUNC(~0u), 8, 1008},
	{28917, S_028800_BACKFACE_ENABLE(~0u)},
	{29020, S_028800_STENCILFUNC(~0u), 8, 1016},
	{29032, S_028800_STENCILFUNC_BF(~0u), 8, 1016},
	{29047, S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(~0u)},
	{29081, S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(~0u)},
	/* 1676 */
	{29116, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{29135, S_028804_PS_ITER_SAMPLES(~0u)},
	{29151, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{29175, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{29201, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{29228, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{29250, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{29269, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{29287, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{29314, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{29341, S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{29366, S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
	/* 1688 */
	{29397, S_028808_DISABLE_DUAL_QUAD(~0u)},
	{29415, S_028808_DEGAMMA_ENABLE(~0u)},
	{9796, S_028808_MODE(~0u), 7, 1024},
	{28499, S_028808_ROP3(~0u), 256, 1031},
	/* 1692 */
	{29720, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{29736, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{29767, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{20736, S_02880C_Z_ORDER(~0u), 4, 1287},
	{29846, S_02880C_KILL_ENABLE(~0u)},
	{29858, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{29882, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{29901, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{29919, S_02880C_EXEC_ON_NOOP(~0u)},
	{29932, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{29954, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{30044, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 1291},
	{30066, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	{30084, S_02880C_PRIMITIVE_ORDERED_PIXEL_SHADER(~0u)},
	{30115, S_02880C_EXEC_IF_OVERLAPPED(~0u)},
	{30134, S_02880C_POPS_OVERLAP_NUM_SAMPLES(~0u)},
	/* 1708 */
	{30159, S_028810_UCP_ENA_0(~0u)},
	{30169, S_028810_UCP_ENA_1(~0u)},
	{30179, S_028810_UCP_ENA_2(~0u)},
	{30189, S_028810_UCP_ENA_3(~0u)},
	{30199, S_028810_UCP_ENA_4(~0u)},
	{30209, S_028810_UCP_ENA_5(~0u)},
	{30219, S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{30238, S_028810_PS_UCP_MODE(~0u)},
	{30250, S_028810_CLIP_DISABLE(~0u)},
	{30263, S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{30281, S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{30304, S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{30322, S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{30342, S_028810_VTX_KILL_OR(~0u)},
	{30354, S_028810_DX_RASTERIZATION_KILL(~0u)},
	{30376, S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{30400, S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{30426, S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{30445, S_028810_ZCLIP_FAR_DISABLE(~0u)},
	/* 1727 */
	{30463, S_028814_CULL_FRONT(~0u)},
	{30474, S_028814_CULL_BACK(~0u)},
	{30484, S_028814_FACE(~0u)},
	{30499, S_028814_POLY_MODE(~0u), 2, 1295},
	{30565, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 1297},
	{30586, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 1297},
	{30606, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{30631, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{30655, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{30679, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{30704, S_028814_PROVOKING_VTX_LAST(~0u)},
	{30723, S_028814_PERSP_CORR_DIS(~0u)},
	{30738, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	{30756, S_028814_RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF(~0u)},
	{30794, S_028814_NEW_QUAD_DECOMPOSITION(~0u)},
	/* 1742 */
	{30817, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{30835, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{30854, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{30872, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{30891, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{30909, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{30928, S_028818_VTX_XY_FMT(~0u)},
	{30939, S_028818_VTX_Z_FMT(~0u)},
	{30949, S_028818_VTX_W0_FMT(~0u)},
	{30960, S_028818_PERFCOUNTER_REF(~0u)},
	/* 1752 */
	{30976, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{30992, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{31008, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{31024, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{31040, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{31056, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{31072, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{31088, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{31104, S_02881C_CULL_DIST_ENA_0(~0u)},
	{31120, S_02881C_CULL_DIST_ENA_1(~0u)},
	{31136, S_02881C_CULL_DIST_ENA_2(~0u)},
	{31152, S_02881C_CULL_DIST_ENA_3(~0u)},
	{31168, S_02881C_CULL_DIST_ENA_4(~0u)},
	{31184, S_02881C_CULL_DIST_ENA_5(~0u)},
	{31200, S_02881C_CULL_DIST_ENA_6(~0u)},
	{31216, S_02881C_CULL_DIST_ENA_7(~0u)},
	{31232, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{31251, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{31269, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{31296, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{31318, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{31336, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{31356, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{31379, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{31402, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{31427, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{31447, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	{31466, S_02881C_USE_VTX_SHD_OBJPRIM_ID(~0u)},
	/* 1780 */
	{31489, S_028820_VTE_XY_INF_DISCARD(~0u)},
	{31508, S_028820_VTE_Z_INF_DISCARD(~0u)},
	{31526, S_028820_VTE_W_INF_DISCARD(~0u)},
	{31544, S_028820_VTE_0XNANINF_IS_0(~0u)},
	{31562, S_028820_VTE_XY_NAN_RETAIN(~0u)},
	{31580, S_028820_VTE_Z_NAN_RETAIN(~0u)},
	{31597, S_028820_VTE_W_NAN_RETAIN(~0u)},
	{31614, S_028820_VTE_W_RECIP_NAN_IS_0(~0u)},
	{31635, S_028820_VS_XY_NAN_TO_INF(~0u)},
	{31652, S_028820_VS_XY_INF_RETAIN(~0u)},
	{31669, S_028820_VS_Z_NAN_TO_INF(~0u)},
	{31685, S_028820_VS_Z_INF_RETAIN(~0u)},
	{31701, S_028820_VS_W_NAN_TO_INF(~0u)},
	{31717, S_028820_VS_W_INF_RETAIN(~0u)},
	{31733, S_028820_VS_CLIP_DIST_INF_DISCARD(~0u)},
	{31758, S_028820_VTE_NO_OUTPUT_NEG_0(~0u)},
	/* 1796 */
	{31778, S_028824_LINE_STIPPLE_RESET(~0u)},
	{31797, S_028824_EXPAND_FULL_LENGTH(~0u)},
	{31816, S_028824_FRACTIONAL_ACCUM(~0u)},
	{31833, S_028824_DIAMOND_ADJUST(~0u)},
	/* 1800 */
	{31848, S_02882C_TRIANGLE_FILTER_DISABLE(~0u)},
	{31872, S_02882C_LINE_FILTER_DISABLE(~0u)},
	{31892, S_02882C_POINT_FILTER_DISABLE(~0u)},
	{31913, S_02882C_RECTANGLE_FILTER_DISABLE(~0u)},
	{31938, S_02882C_TRIANGLE_EXPAND_ENA(~0u)},
	{31958, S_02882C_LINE_EXPAND_ENA(~0u)},
	{31974, S_02882C_POINT_EXPAND_ENA(~0u)},
	{31991, S_02882C_RECTANGLE_EXPAND_ENA(~0u)},
	{32012, S_02882C_PRIM_EXPAND_CONSTANT(~0u)},
	{32033, S_02882C_XMAX_RIGHT_EXCLUSION(~0u)},
	{32054, S_02882C_YMAX_BOTTOM_EXCLUSION(~0u)},
	/* 1811 */
	{32076, S_028830_SMALL_PRIM_FILTER_ENABLE(~0u)},
	{31848, S_028830_TRIANGLE_FILTER_DISABLE(~0u)},
	{31872, S_028830_LINE_FILTER_DISABLE(~0u)},
	{31892, S_028830_POINT_FILTER_DISABLE(~0u)},
	{31913, S_028830_RECTANGLE_FILTER_DISABLE(~0u)},
	{32101, S_028830_SRBSL_ENABLE(~0u)},
	/* 1817 */
	{13209, S_028A00_HEIGHT(~0u)},
	{13203, S_028A00_WIDTH(~0u)},
	/* 1819 */
	{32114, S_028A04_MIN_SIZE(~0u)},
	{32123, S_028A04_MAX_SIZE(~0u)},
	/* 1821 */
	{13203, S_028A08_WIDTH(~0u)},
	/* 1822 */
	{32132, S_028A0C_LINE_PATTERN(~0u)},
	{32145, S_028A0C_REPEAT_COUNT(~0u)},
	{32158, S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{32176, S_028A0C_AUTO_RESET_CNTL(~0u)},
	/* 1826 */
	{32297, S_028A10_PATH_SELECT(~0u), 5, 1300},
	/* 1827 */
	{32309, S_028A14_TESS_MODE(~0u)},
	/* 1828 */
	{32319, S_028A20_REUSE_DEPTH(~0u)},
	/* 1829 */
	{6331, S_028A24_PRIM_TYPE(~0u), 18, 1305},
	{32686, S_028A24_RETAIN_ORDER(~0u)},
	{32699, S_028A24_RETAIN_QUADS(~0u)},
	{32780, S_028A24_PRIM_ORDER(~0u), 5, 1323},
	/* 1833 */
	{32791, S_028A28_FIRST_DECR(~0u)},
	/* 1834 */
	{32797, S_028A2C_DECR(~0u)},
	/* 1835 */
	{32802, S_028A30_COMP_X_EN(~0u)},
	{32812, S_028A30_COMP_Y_EN(~0u)},
	{32822, S_028A30_COMP_Z_EN(~0u)},
	{32832, S_028A30_COMP_W_EN(~0u)},
	{8892, S_028A30_STRIDE(~0u)},
	{32842, S_028A30_SHIFT(~0u)},
	/* 1841 */
	{32802, S_028A34_COMP_X_EN(~0u)},
	{32812, S_028A34_COMP_Y_EN(~0u)},
	{32822, S_028A34_COMP_Z_EN(~0u)},
	{32832, S_028A34_COMP_W_EN(~0u)},
	{8892, S_028A34_STRIDE(~0u)},
	{32842, S_028A34_SHIFT(~0u)},
	/* 1847 */
	{33007, S_028A38_X_CONV(~0u), 9, 1328},
	{22017, S_028A38_X_OFFSET(~0u)},
	{33014, S_028A38_Y_CONV(~0u), 9, 1328},
	{22033, S_028A38_Y_OFFSET(~0u)},
	{33021, S_028A38_Z_CONV(~0u), 9, 1328},
	{33028, S_028A38_Z_OFFSET(~0u)},
	{33037, S_028A38_W_CONV(~0u), 9, 1328},
	{33044, S_028A38_W_OFFSET(~0u)},
	/* 1855 */
	{33007, S_028A3C_X_CONV(~0u), 9, 1328},
	{22017, S_028A3C_X_OFFSET(~0u)},
	{33014, S_028A3C_Y_CONV(~0u), 9, 1328},
	{22033, S_028A3C_Y_OFFSET(~0u)},
	{33021, S_028A3C_Z_CONV(~0u), 9, 1328},
	{33028, S_028A3C_Z_OFFSET(~0u)},
	{33037, S_028A3C_W_CONV(~0u), 9, 1328},
	{33044, S_028A3C_W_OFFSET(~0u)},
	/* 1863 */
	{9796, S_028A40_MODE(~0u), 6, 1337},
	{8953, S_028A40_RESERVED_0(~0u)},
	{33171, S_028A40_CUT_MODE(~0u), 4, 1343},
	{8971, S_028A40_RESERVED_1(~0u)},
	{33180, S_028A40_GS_C_PACK_EN(~0u)},
	{33193, S_028A40_RESERVED_2(~0u)},
	{33204, S_028A40_ES_PASSTHRU(~0u)},
	{33216, S_028A40_COMPUTE_MODE(~0u)},
	{33229, S_028A40_FAST_COMPUTE_MODE(~0u)},
	{33247, S_028A40_ELEMENT_INFO_EN(~0u)},
	{33263, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{33282, S_028A40_SUPPRESS_CUTS(~0u)},
	{33296, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{33314, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{33365, S_028A40_ONCHIP(~0u), 4, 1347},
	{33372, S_028A40_RESERVED_3(~0u)},
	{33383, S_028A40_RESERVED_4(~0u)},
	{33394, S_028A40_RESERVED_5(~0u)},
	/* 1881 */
	{33405, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{33425, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	{33445, S_028A44_GS_INST_PRIMS_IN_SUBGRP(~0u)},
	/* 1884 */
	{33469, S_028A48_MSAA_ENABLE(~0u)},
	{33481, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{33502, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{33522, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	{33547, S_028A48_SCALE_LINE_WIDTH_PAD(~0u)},
	{33568, S_028A48_ALTERNATE_RBS_PER_TILE(~0u)},
	{33591, S_028A48_COARSE_TILE_STARTS_ON_EVEN_RB(~0u)},
	/* 1891 */
	{33621, S_028A4C_WALK_SIZE(~0u)},
	{33631, S_028A4C_WALK_ALIGNMENT(~0u)},
	{33646, S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(~0u)},
	{33671, S_028A4C_WALK_FENCE_ENABLE(~0u)},
	{33689, S_028A4C_WALK_FENCE_SIZE(~0u)},
	{33705, S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(~0u)},
	{33710, S_028A4C_TILE_WALK_ORDER_ENABLE(~0u)},
	{33733, S_028A4C_TILE_COVER_DISABLE(~0u)},
	{33752, S_028A4C_TILE_COVER_NO_SCISSOR(~0u)},
	{33774, S_028A4C_ZMM_LINE_EXTENT(~0u)},
	{33790, S_028A4C_ZMM_LINE_OFFSET(~0u)},
	{33806, S_028A4C_ZMM_RECT_EXTENT(~0u)},
	{33822, S_028A4C_KILL_PIX_POST_HI_Z(~0u)},
	{33841, S_028A4C_KILL_PIX_POST_DETAIL_MASK(~0u)},
	{33867, S_028A4C_PS_ITER_SAMPLE(~0u)},
	{33882, S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(~0u)},
	{33922, S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(~0u)},
	{33949, S_028A4C_GPU_ID_OVERRIDE_ENABLE(~0u)},
	{33972, S_028A4C_GPU_ID_OVERRIDE(~0u)},
	{33988, S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(~0u)},
	{34018, S_028A4C_FORCE_EOV_CNTDWN_ENABLE(~0u)},
	{34042, S_028A4C_FORCE_EOV_REZ_ENABLE(~0u)},
	{34063, S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(~0u)},
	{34093, S_028A4C_OUT_OF_ORDER_WATER_MARK(~0u)},
	/* 1915 */
	{34117, S_028A54_GS_PER_ES(~0u)},
	/* 1916 */
	{34127, S_028A58_ES_PER_GS(~0u)},
	/* 1917 */
	{34137, S_028A5C_GS_PER_VS(~0u)},
	/* 1918 */
	{657, S_028A60_OFFSET(~0u)},
	/* 1919 */
	{657, S_028A64_OFFSET(~0u)},
	/* 1920 */
	{657, S_028A68_OFFSET(~0u)},
	/* 1921 */
	{34215, S_028A6C_OUTPRIM_TYPE(~0u), 3, 1351},
	{34228, S_028A6C_OUTPRIM_TYPE_1(~0u)},
	{34243, S_028A6C_OUTPRIM_TYPE_2(~0u)},
	{34258, S_028A6C_OUTPRIM_TYPE_3(~0u)},
	{34273, S_028A6C_UNIQUE_TYPE_PER_STREAM(~0u)},
	/* 1926 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 1354},
	{34410, S_028A7C_SWAP_MODE(~0u), 4, 1357},
	{34471, S_028A7C_BUF_TYPE(~0u), 3, 1361},
	{34513, S_028A7C_RDREQ_POLICY_CIK(~0u), 2, 1364},
	{34530, S_028A7C_RDREQ_POLICY(~0u)},
	{9677, S_028A7C_ATC(~0u)},
	{28682, S_028A7C_NOT_EOP(~0u)},
	{34543, S_028A7C_REQ_PATH(~0u)},
	{9698, S_028A7C_MTYPE(~0u)},
	{8322, S_028A7C_PRIMGEN_EN(~0u)},
	/* 1936 */
	{34552, S_028A84_PRIMITIVEID_EN(~0u)},
	{34567, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	{34588, S_028A84_NGG_DISABLE_PROVOK_REUSE(~0u)},
	/* 1939 */
	{35648, S_028A90_EVENT_TYPE(~0u), 63, 1366},
	{35659, S_028A90_ADDRESS_HI_GFX6(~0u)},
	{35675, S_028A90_EXTENDED_EVENT(~0u)},
	{35690, S_028A90_ADDRESS_HI_GFX9(~0u)},
	/* 1943 */
	{35706, S_028A94_RESET_EN(~0u)},
	/* 1944 */
	{35715, S_028AA8_PRIMGROUP_SIZE(~0u)},
	{35730, S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{35749, S_028AA8_SWITCH_ON_EOP(~0u)},
	{35763, S_028AA8_PARTIAL_ES_WAVE_ON(~0u)},
	{35782, S_028AA8_SWITCH_ON_EOI(~0u)},
	{35796, S_028AA8_WD_SWITCH_ON_EOP(~0u)},
	{35813, S_028AA8_MAX_PRIMGRP_IN_WAVE(~0u)},
	/* 1951 */
	{35833, S_028AAC_ITEMSIZE(~0u)},
	/* 1952 */
	{35833, S_028AB0_ITEMSIZE(~0u)},
	/* 1953 */
	{35842, S_028AB4_REUSE_OFF(~0u)},
	/* 1954 */
	{35852, S_028AB8_VTX_CNT_EN(~0u)},
	/* 1955 */
	{13782, S_028ABC_LINEAR(~0u)},
	{35863, S_028ABC_FULL_CACHE(~0u)},
	{35874, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{35897, S_028ABC_PRELOAD(~0u)},
	{35905, S_028ABC_PREFETCH_WIDTH(~0u)},
	{35920, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{35936, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{35960, S_028ABC_TC_COMPATIBLE(~0u)},
	{13794, S_028ABC_PIPE_ALIGNED(~0u)},
	{13812, S_028ABC_RB_ALIGNED(~0u)},
	/* 1965 */
	{35974, S_028AC0_COMPAREFUNC0(~0u), 8, 1016},
	{35987, S_028AC0_COMPAREVALUE0(~0u)},
	{36001, S_028AC0_COMPAREMASK0(~0u)},
	{20697, S_028AC0_ENABLE0(~0u)},
	/* 1969 */
	{36014, S_028AC4_COMPAREFUNC1(~0u), 8, 1016},
	{36027, S_028AC4_COMPAREVALUE1(~0u)},
	{36041, S_028AC4_COMPAREMASK1(~0u)},
	{20715, S_028AC4_ENABLE1(~0u)},
	/* 1973 */
	{36054, S_028AC8_START_X(~0u)},
	{36062, S_028AC8_START_Y(~0u)},
	{36070, S_028AC8_MAX_X(~0u)},
	{36076, S_028AC8_MAX_Y(~0u)},
	/* 1977 */
	{8892, S_028AD4_STRIDE(~0u)},
	/* 1978 */
	{8892, S_028AE4_STRIDE(~0u)},
	/* 1979 */
	{8892, S_028AF4_STRIDE(~0u)},
	/* 1980 */
	{8892, S_028B04_STRIDE(~0u)},
	/* 1981 */
	{36082, S_028B30_VERTEX_STRIDE(~0u)},
	/* 1982 */
	{36096, S_028B38_MAX_VERT_OUT(~0u)},
	/* 1983 */
	{36109, S_028B50_ACCUM_ISOLINE(~0u)},
	{36123, S_028B50_ACCUM_TRI(~0u)},
	{36133, S_028B50_ACCUM_QUAD(~0u)},
	{36144, S_028B50_DONUT_SPLIT(~0u)},
	{36156, S_028B50_TRAP_SPLIT(~0u)},
	/* 1988 */
	{19856, S_028B54_LS_EN(~0u), 3, 1429},
	{19850, S_028B54_HS_EN(~0u)},
	{19844, S_028B54_ES_EN(~0u), 3, 1432},
	{19838, S_028B54_GS_EN(~0u)},
	{19832, S_028B54_VS_EN(~0u), 3, 1435},
	{36290, S_028B54_DYNAMIC_HS(~0u)},
	{18145, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{36301, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{36321, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{36341, S_028B54_VS_WAVE_ID_EN(~0u)},
	{8322, S_028B54_PRIMGEN_EN(~0u)},
	{36355, S_028B54_ORDERED_ID_MODE(~0u)},
	{35813, S_028B54_MAX_PRIMGRP_IN_WAVE(~0u)},
	{36371, S_028B54_GS_FAST_LAUNCH(~0u)},
	/* 2002 */
	{36386, S_028B58_NUM_PATCHES(~0u)},
	{36398, S_028B58_HS_NUM_INPUT_CP(~0u)},
	{36414, S_028B58_HS_NUM_OUTPUT_CP(~0u)},
	/* 2005 */
	{35833, S_028B5C_ITEMSIZE(~0u)},
	/* 2006 */
	{35833, S_028B60_ITEMSIZE(~0u)},
	/* 2007 */
	{35833, S_028B64_ITEMSIZE(~0u)},
	/* 2008 */
	{35833, S_028B68_ITEMSIZE(~0u)},
	/* 2009 */
	{209, S_028B6C_TYPE(~0u), 3, 1438},
	{36520, S_028B6C_PARTITIONING(~0u), 4, 1441},
	{36597, S_028B6C_TOPOLOGY(~0u), 4, 1445},
	{36606, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{36626, S_028B6C_DEPRECATED(~0u)},
	{36637, S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	{36659, S_028B6C_DISABLE_DONUTS(~0u)},
	{34513, S_028B6C_RDREQ_POLICY_CIK(~0u), 3, 1449},
	{34530, S_028B6C_RDREQ_POLICY(~0u)},
	{36798, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 1452},
	{9698, S_028B6C_MTYPE(~0u)},
	/* 2020 */
	{36816, S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{36837, S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{36859, S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{36881, S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{36903, S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{36925, S_028B70_OFFSET_ROUND(~0u)},
	/* 2026 */
	{36938, S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{36966, S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
	/* 2028 */
	{830, S_028B90_ENABLE(~0u)},
	{18061, S_028B90_CNT(~0u)},
	/* 2030 */
	{36994, S_028B94_STREAMOUT_0_EN(~0u)},
	{37009, S_028B94_STREAMOUT_1_EN(~0u)},
	{37024, S_028B94_STREAMOUT_2_EN(~0u)},
	{37039, S_028B94_STREAMOUT_3_EN(~0u)},
	{37054, S_028B94_RAST_STREAM(~0u)},
	{37066, S_028B94_RAST_STREAM_MASK(~0u)},
	{37083, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	{37104, S_028B94_EN_PRIMS_NEEDED_CNT(~0u)},
	/* 2038 */
	{37124, S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{37143, S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{37162, S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{37181, S_028B98_STREAM_3_BUFFER_EN(~0u)},
	/* 2042 */
	{37200, S_028BD4_DISTANCE_0(~0u)},
	{37211, S_028BD4_DISTANCE_1(~0u)},
	{37222, S_028BD4_DISTANCE_2(~0u)},
	{37233, S_028BD4_DISTANCE_3(~0u)},
	{37244, S_028BD4_DISTANCE_4(~0u)},
	{37255, S_028BD4_DISTANCE_5(~0u)},
	{37266, S_028BD4_DISTANCE_6(~0u)},
	{37277, S_028BD4_DISTANCE_7(~0u)},
	/* 2050 */
	{37288, S_028BD8_DISTANCE_8(~0u)},
	{37299, S_028BD8_DISTANCE_9(~0u)},
	{37310, S_028BD8_DISTANCE_10(~0u)},
	{37322, S_028BD8_DISTANCE_11(~0u)},
	{37334, S_028BD8_DISTANCE_12(~0u)},
	{37346, S_028BD8_DISTANCE_13(~0u)},
	{37358, S_028BD8_DISTANCE_14(~0u)},
	{37370, S_028BD8_DISTANCE_15(~0u)},
	/* 2058 */
	{37382, S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{37400, S_028BDC_LAST_PIXEL(~0u)},
	{37411, S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{37436, S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
	/* 2062 */
	{37458, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{37475, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{37497, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{37513, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{37534, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	{37557, S_028BE0_COVERAGE_TO_SHADER_SELECT(~0u)},
	/* 2068 */
	{37583, S_028BE4_PIX_CENTER(~0u)},
	{37644, S_028BE4_ROUND_MODE(~0u), 4, 1456},
	{37860, S_028BE4_QUANT_MODE(~0u), 8, 1460},
	/* 2071 */
	{37871, S_028BF8_S0_X(~0u)},
	{37876, S_028BF8_S0_Y(~0u)},
	{37881, S_028BF8_S1_X(~0u)},
	{37886, S_028BF8_S1_Y(~0u)},
	{37891, S_028BF8_S2_X(~0u)},
	{37896, S_028BF8_S2_Y(~0u)},
	{37901, S_028BF8_S3_X(~0u)},
	{37906, S_028BF8_S3_Y(~0u)},
	/* 2079 */
	{37911, S_028BFC_S4_X(~0u)},
	{37916, S_028BFC_S4_Y(~0u)},
	{37921, S_028BFC_S5_X(~0u)},
	{37926, S_028BFC_S5_Y(~0u)},
	{37931, S_028BFC_S6_X(~0u)},
	{37936, S_028BFC_S6_Y(~0u)},
	{37941, S_028BFC_S7_X(~0u)},
	{37946, S_028BFC_S7_Y(~0u)},
	/* 2087 */
	{37951, S_028C00_S8_X(~0u)},
	{37956, S_028C00_S8_Y(~0u)},
	{37961, S_028C00_S9_X(~0u)},
	{37966, S_028C00_S9_Y(~0u)},
	{37971, S_028C00_S10_X(~0u)},
	{37977, S_028C00_S10_Y(~0u)},
	{37983, S_028C00_S11_X(~0u)},
	{37989, S_028C00_S11_Y(~0u)},
	/* 2095 */
	{37995, S_028C04_S12_X(~0u)},
	{38001, S_028C04_S12_Y(~0u)},
	{38007, S_028C04_S13_X(~0u)},
	{38013, S_028C04_S13_Y(~0u)},
	{38019, S_028C04_S14_X(~0u)},
	{38025, S_028C04_S14_Y(~0u)},
	{38031, S_028C04_S15_X(~0u)},
	{38037, S_028C04_S15_Y(~0u)},
	/* 2103 */
	{37871, S_028C08_S0_X(~0u)},
	{37876, S_028C08_S0_Y(~0u)},
	{37881, S_028C08_S1_X(~0u)},
	{37886, S_028C08_S1_Y(~0u)},
	{37891, S_028C08_S2_X(~0u)},
	{37896, S_028C08_S2_Y(~0u)},
	{37901, S_028C08_S3_X(~0u)},
	{37906, S_028C08_S3_Y(~0u)},
	/* 2111 */
	{37911, S_028C0C_S4_X(~0u)},
	{37916, S_028C0C_S4_Y(~0u)},
	{37921, S_028C0C_S5_X(~0u)},
	{37926, S_028C0C_S5_Y(~0u)},
	{37931, S_028C0C_S6_X(~0u)},
	{37936, S_028C0C_S6_Y(~0u)},
	{37941, S_028C0C_S7_X(~0u)},
	{37946, S_028C0C_S7_Y(~0u)},
	/* 2119 */
	{37951, S_028C10_S8_X(~0u)},
	{37956, S_028C10_S8_Y(~0u)},
	{37961, S_028C10_S9_X(~0u)},
	{37966, S_028C10_S9_Y(~0u)},
	{37971, S_028C10_S10_X(~0u)},
	{37977, S_028C10_S10_Y(~0u)},
	{37983, S_028C10_S11_X(~0u)},
	{37989, S_028C10_S11_Y(~0u)},
	/* 2127 */
	{37995, S_028C14_S12_X(~0u)},
	{38001, S_028C14_S12_Y(~0u)},
	{38007, S_028C14_S13_X(~0u)},
	{38013, S_028C14_S13_Y(~0u)},
	{38019, S_028C14_S14_X(~0u)},
	{38025, S_028C14_S14_Y(~0u)},
	{38031, S_028C14_S15_X(~0u)},
	{38037, S_028C14_S15_Y(~0u)},
	/* 2135 */
	{37871, S_028C18_S0_X(~0u)},
	{37876, S_028C18_S0_Y(~0u)},
	{37881, S_028C18_S1_X(~0u)},
	{37886, S_028C18_S1_Y(~0u)},
	{37891, S_028C18_S2_X(~0u)},
	{37896, S_028C18_S2_Y(~0u)},
	{37901, S_028C18_S3_X(~0u)},
	{37906, S_028C18_S3_Y(~0u)},
	/* 2143 */
	{37911, S_028C1C_S4_X(~0u)},
	{37916, S_028C1C_S4_Y(~0u)},
	{37921, S_028C1C_S5_X(~0u)},
	{37926, S_028C1C_S5_Y(~0u)},
	{37931, S_028C1C_S6_X(~0u)},
	{37936, S_028C1C_S6_Y(~0u)},
	{37941, S_028C1C_S7_X(~0u)},
	{37946, S_028C1C_S7_Y(~0u)},
	/* 2151 */
	{37951, S_028C20_S8_X(~0u)},
	{37956, S_028C20_S8_Y(~0u)},
	{37961, S_028C20_S9_X(~0u)},
	{37966, S_028C20_S9_Y(~0u)},
	{37971, S_028C20_S10_X(~0u)},
	{37977, S_028C20_S10_Y(~0u)},
	{37983, S_028C20_S11_X(~0u)},
	{37989, S_028C20_S11_Y(~0u)},
	/* 2159 */
	{37995, S_028C24_S12_X(~0u)},
	{38001, S_028C24_S12_Y(~0u)},
	{38007, S_028C24_S13_X(~0u)},
	{38013, S_028C24_S13_Y(~0u)},
	{38019, S_028C24_S14_X(~0u)},
	{38025, S_028C24_S14_Y(~0u)},
	{38031, S_028C24_S15_X(~0u)},
	{38037, S_028C24_S15_Y(~0u)},
	/* 2167 */
	{37871, S_028C28_S0_X(~0u)},
	{37876, S_028C28_S0_Y(~0u)},
	{37881, S_028C28_S1_X(~0u)},
	{37886, S_028C28_S1_Y(~0u)},
	{37891, S_028C28_S2_X(~0u)},
	{37896, S_028C28_S2_Y(~0u)},
	{37901, S_028C28_S3_X(~0u)},
	{37906, S_028C28_S3_Y(~0u)},
	/* 2175 */
	{37911, S_028C2C_S4_X(~0u)},
	{37916, S_028C2C_S4_Y(~0u)},
	{37921, S_028C2C_S5_X(~0u)},
	{37926, S_028C2C_S5_Y(~0u)},
	{37931, S_028C2C_S6_X(~0u)},
	{37936, S_028C2C_S6_Y(~0u)},
	{37941, S_028C2C_S7_X(~0u)},
	{37946, S_028C2C_S7_Y(~0u)},
	/* 2183 */
	{37951, S_028C30_S8_X(~0u)},
	{37956, S_028C30_S8_Y(~0u)},
	{37961, S_028C30_S9_X(~0u)},
	{37966, S_028C30_S9_Y(~0u)},
	{37971, S_028C30_S10_X(~0u)},
	{37977, S_028C30_S10_Y(~0u)},
	{37983, S_028C30_S11_X(~0u)},
	{37989, S_028C30_S11_Y(~0u)},
	/* 2191 */
	{37995, S_028C34_S12_X(~0u)},
	{38001, S_028C34_S12_Y(~0u)},
	{38007, S_028C34_S13_X(~0u)},
	{38013, S_028C34_S13_Y(~0u)},
	{38019, S_028C34_S14_X(~0u)},
	{38025, S_028C34_S14_Y(~0u)},
	{38031, S_028C34_S15_X(~0u)},
	{38037, S_028C34_S15_Y(~0u)},
	/* 2199 */
	{38043, S_028C38_AA_MASK_X0Y0(~0u)},
	{38056, S_028C38_AA_MASK_X1Y0(~0u)},
	/* 2201 */
	{38069, S_028C3C_AA_MASK_X0Y1(~0u)},
	{38082, S_028C3C_AA_MASK_X1Y1(~0u)},
	/* 2203 */
	{38095, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	{17978, S_028C40_LOAD_COLLISION_WAVEID(~0u)},
	{18000, S_028C40_LOAD_INTRAWAVE_COLLISION(~0u)},
	/* 2206 */
	{38124, S_028C58_VTX_REUSE_DEPTH(~0u)},
	/* 2207 */
	{38140, S_028C5C_DEALLOC_DIST(~0u)},
	/* 2208 */
	{21952, S_028C64_TILE_MAX(~0u)},
	{38153, S_028C64_FMASK_TILE_MAX(~0u)},
	/* 2210 */
	{21952, S_028C68_TILE_MAX(~0u)},
	/* 2211 */
	{20560, S_028C6C_SLICE_START(~0u)},
	{20572, S_028C6C_SLICE_MAX(~0u)},
	{38168, S_028C6C_MIP_LEVEL(~0u)},
	/* 2214 */
	{38229, S_028C70_ENDIAN(~0u), 4, 1468},
	{9236, S_028C70_FORMAT(~0u), 23, 1472},
	{16448, S_028C70_LINEAR_GENERAL(~0u)},
	{38596, S_028C70_NUMBER_TYPE(~0u), 8, 1495},
	{38652, S_028C70_COMP_SWAP(~0u), 4, 1503},
	{29464, S_028C70_FAST_CLEAR(~0u)},
	{21152, S_028C70_COMPRESSION(~0u)},
	{38662, S_028C70_BLEND_CLAMP(~0u)},
	{38674, S_028C70_BLEND_BYPASS(~0u)},
	{38687, S_028C70_SIMPLE_FLOAT(~0u)},
	{37644, S_028C70_ROUND_MODE(~0u)},
	{38700, S_028C70_CMASK_IS_LINEAR(~0u)},
	{38927, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 1507},
	{38949, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 1507},
	{38973, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{38999, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{39025, S_028C70_DCC_ENABLE(~0u)},
	{39036, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 2232 */
	{21780, S_028C74_TILE_MODE_INDEX(~0u)},
	{39052, S_028C74_FMASK_TILE_MODE_INDEX(~0u)},
	{39074, S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{21768, S_028C74_NUM_SAMPLES(~0u)},
	{39092, S_028C74_NUM_FRAGMENTS(~0u)},
	{39106, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	{39124, S_028C74_MIP0_DEPTH(~0u)},
	{13777, S_028C74_META_LINEAR(~0u)},
	{39135, S_028C74_COLOR_SW_MODE(~0u)},
	{39149, S_028C74_FMASK_SW_MODE(~0u)},
	{39163, S_028C74_RESOURCE_TYPE(~0u), 4, 1515},
	{13812, S_028C74_RB_ALIGNED(~0u)},
	{13794, S_028C74_PIPE_ALIGNED(~0u)},
	/* 2245 */
	{24424, S_028C78_OVERWRITE_COMBINER_DISABLE(~0u)},
	{39177, S_028C78_KEY_CLEAR_ENABLE(~0u)},
	{39194, S_028C78_MAX_UNCOMPRESSED_BLOCK_SIZE(~0u)},
	{39222, S_028C78_MIN_COMPRESSED_BLOCK_SIZE(~0u)},
	{39248, S_028C78_MAX_COMPRESSED_BLOCK_SIZE(~0u)},
	{13906, S_028C78_COLOR_TRANSFORM(~0u)},
	{39274, S_028C78_INDEPENDENT_64B_BLOCKS(~0u)},
	{39297, S_028C78_LOSSY_RGB_PRECISION(~0u)},
	{39317, S_028C78_LOSSY_ALPHA_PRECISION(~0u)},
	/* 2254 */
	{21952, S_028C80_TILE_MAX(~0u)},
	/* 2255 */
	{21952, S_028C88_TILE_MAX(~0u)},
	/* 2256 */
	{35706, S_03092C_RESET_EN(~0u)},
	{39339, S_03092C_MATCH_ALL_BITS(~0u)},
	/* 2258 */
	{39354, S_030944_BASE_HI(~0u)},
	/* 2259 */
	{39354, S_03094C_BASE_HI(~0u)},
	/* 2260 */
	{39354, S_030954_BASE_HI(~0u)},
	/* 2261 */
	{39354, S_03095C_BASE_HI(~0u)},
	/* 2262 */
	{35715, S_030960_PRIMGROUP_SIZE(~0u)},
	{35730, S_030960_PARTIAL_VS_WAVE_ON(~0u)},
	{35749, S_030960_SWITCH_ON_EOP(~0u)},
	{35763, S_030960_PARTIAL_ES_WAVE_ON(~0u)},
	{35782, S_030960_SWITCH_ON_EOI(~0u)},
	{35796, S_030960_WD_SWITCH_ON_EOP(~0u)},
	{39362, S_030960_EN_INST_OPT_BASIC(~0u)},
	{39380, S_030960_EN_INST_OPT_ADV(~0u)},
	{39396, S_030960_HW_USE_ONLY(~0u)},
	/* 2271 */
	{39408, S_030D24_DWB(~0u)},
	{21083, S_030D24_DIRTY(~0u)},
	/* 2273 */
	{39412, S_030E08_GRAD_ADJ_0(~0u)},
	{39423, S_030E08_GRAD_ADJ_1(~0u)},
	{39434, S_030E08_GRAD_ADJ_2(~0u)},
	{39445, S_030E08_GRAD_ADJ_3(~0u)},
	/* 2277 */
	{15428, S_031100_GPR_WRITE_PRIORITY(~0u)},
	{15447, S_031100_EXP_PRIORITY_ORDER(~0u)},
	{15466, S_031100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{15488, S_031100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{15510, S_031100_RSRC_MGMT_RESET(~0u)},
	{39456, S_031100_TTRACE_STALL_ALL(~0u)},
	{39473, S_031100_ALLOC_ARB_LRU_ENA(~0u)},
	{39491, S_031100_EXP_ARB_LRU_ENA(~0u)},
	{39507, S_031100_PS_PKR_PRIORITY_CNTL(~0u)},
	/* 2286 */
	{15779, S_031104_VTX_DONE_DELAY(~0u)},
	{15794, S_031104_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{39528, S_031104_BATON_RESET_DISABLE(~0u)},
	{15818, S_031104_PC_LIMIT_ENABLE(~0u)},
	{15834, S_031104_PC_LIMIT_STRICT(~0u)},
	{39548, S_031104_CRC_SIMD_ID_WADDR_DISABLE(~0u)},
	{39574, S_031104_LBPW_CU_CHK_MODE(~0u)},
	{39591, S_031104_LBPW_CU_CHK_CNT(~0u)},
	{39607, S_031104_CSC_PWR_SAVE_DISABLE(~0u)},
	{39628, S_031104_CSG_PWR_SAVE_DISABLE(~0u)},
	{15850, S_031104_PC_LIMIT_SIZE(~0u)},
	/* 2297 */
	{39649, S_031108_CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD(~0u)},
	{39690, S_031108_CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD(~0u)},
	/* 2299 */
	{17898, S_00B1F0_SCRATCH_EN(~0u)},
	{17909, S_00B1F0_USER_SGPR(~0u)},
	{17919, S_00B1F0_TRAP_PRESENT(~0u)},
	{17970, S_00B1F0_EXCP_EN(~0u)},
	{18051, S_00B1F0_VGPR_COMP_CNT(~0u)},
	{18081, S_00B1F0_OC_LDS_EN(~0u)},
	{17950, S_00B1F0_LDS_SIZE(~0u)},
	{18025, S_00B1F0_SKIP_USGPR0(~0u)},
	{18037, S_00B1F0_USER_SGPR_MSB(~0u)},
	/* 2308 */
	{18173, S_00B204_GROUP_FIFO_DEPTH(~0u)},
	{39729, S_00B204_SPI_SHADER_LATE_ALLOC_GS(~0u)},
	/* 2310 */
	{17696, S_00B214_MEM_BASE(~0u)},
	/* 2311 */
	{18173, S_00B404_GROUP_FIFO_DEPTH(~0u)},
	/* 2312 */
	{17696, S_00B414_MEM_BASE(~0u)},
	/* 2313 */
	{391, S_00B83C_DATA(~0u)},
	/* 2314 */
	{391, S_00B844_DATA(~0u)},
	/* 2315 */
	{441, S_036028_INDEX(~0u)},
	{14401, S_036028_ALWAYS(~0u)},
	{830, S_036028_ENABLE(~0u)},
	/* 2318 */
	{441, S_03602C_INDEX(~0u)},
	{14401, S_03602C_ALWAYS(~0u)},
	{830, S_03602C_ENABLE(~0u)},
	/* 2321 */
	{441, S_036030_INDEX(~0u)},
	{21590, S_036030_CLEAR(~0u)},
	{830, S_036030_ENABLE(~0u)},
	/* 2324 */
	{441, S_036034_INDEX(~0u)},
	{21590, S_036034_CLEAR(~0u)},
	{830, S_036034_ENABLE(~0u)},
	/* 2327 */
	{441, S_036038_INDEX(~0u)},
	{21590, S_036038_CLEAR(~0u)},
	{830, S_036038_ENABLE(~0u)},
	/* 2330 */
	{39354, S_028018_BASE_HI(~0u)},
	/* 2331 */
	{39754, S_02801C_X_MAX(~0u)},
	{39760, S_02801C_Y_MAX(~0u)},
	/* 2333 */
	{9236, S_028038_FORMAT(~0u)},
	{21768, S_028038_NUM_SAMPLES(~0u)},
	{13582, S_028038_SW_MODE(~0u)},
	{39766, S_028038_PARTIALLY_RESIDENT(~0u)},
	{39785, S_028038_FAULT_BEHAVIOR(~0u)},
	{39800, S_028038_ITERATE_FLUSH(~0u)},
	{39814, S_028038_MAXMIP(~0u)},
	{21796, S_028038_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{21820, S_028038_ALLOW_EXPCLEAR(~0u)},
	{21835, S_028038_READ_SIZE(~0u)},
	{21845, S_028038_TILE_SURFACE_ENABLE(~0u)},
	{21865, S_028038_CLEAR_DISALLOWED(~0u)},
	{21882, S_028038_ZRANGE_PRECISION(~0u)},
	/* 2346 */
	{9236, S_02803C_FORMAT(~0u)},
	{13582, S_02803C_SW_MODE(~0u)},
	{39766, S_02803C_PARTIALLY_RESIDENT(~0u)},
	{39785, S_02803C_FAULT_BEHAVIOR(~0u)},
	{39800, S_02803C_ITERATE_FLUSH(~0u)},
	{21820, S_02803C_ALLOW_EXPCLEAR(~0u)},
	{21925, S_02803C_TILE_STENCIL_DISABLE(~0u)},
	{21865, S_02803C_CLEAR_DISALLOWED(~0u)},
	/* 2354 */
	{39354, S_028044_BASE_HI(~0u)},
	/* 2355 */
	{39354, S_02804C_BASE_HI(~0u)},
	/* 2356 */
	{39354, S_028054_BASE_HI(~0u)},
	/* 2357 */
	{39354, S_02805C_BASE_HI(~0u)},
	/* 2358 */
	{39830, S_028060_PUNCHOUT_MODE(~0u), 4, 1519},
	{39844, S_028060_POPS_DRAIN_PS_ON_OVERLAP(~0u)},
	{39869, S_028060_DISALLOW_OVERFLOW(~0u)},
	/* 2361 */
	{39887, S_028064_PS_INVOKE_MASK(~0u)},
	/* 2362 */
	{39902, S_028068_EPITCH(~0u)},
	/* 2363 */
	{39902, S_02806C_EPITCH(~0u)},
	/* 2364 */
	{830, S_02835C_ENABLE(~0u)},
	{39909, S_02835C_NUM_SE(~0u)},
	{16285, S_02835C_NUM_RB_PER_SE(~0u)},
	{39916, S_02835C_DISABLE_SRBSL_DB_OPTIMIZED_PACKING(~0u)},
	/* 2368 */
	{39951, S_028360_PERFMON_ENABLE(~0u)},
	/* 2369 */
	{39966, S_0283A0_LEFT_QTR(~0u)},
	{39975, S_0283A0_LEFT_HALF(~0u)},
	{39985, S_0283A0_RIGHT_HALF(~0u)},
	{39996, S_0283A0_RIGHT_QTR(~0u)},
	/* 2373 */
	{39966, S_0283A4_LEFT_QTR(~0u)},
	{39975, S_0283A4_LEFT_HALF(~0u)},
	{39985, S_0283A4_RIGHT_HALF(~0u)},
	{39996, S_0283A4_RIGHT_QTR(~0u)},
	/* 2377 */
	{40006, S_0283A8_TOP_QTR(~0u)},
	{40014, S_0283A8_TOP_HALF(~0u)},
	{40023, S_0283A8_BOT_HALF(~0u)},
	{40032, S_0283A8_BOT_QTR(~0u)},
	/* 2381 */
	{40040, S_0283AC_LEFT_EYE_FOV_LEFT(~0u)},
	{40058, S_0283AC_LEFT_EYE_FOV_RIGHT(~0u)},
	{40077, S_0283AC_RIGHT_EYE_FOV_LEFT(~0u)},
	{40096, S_0283AC_RIGHT_EYE_FOV_RIGHT(~0u)},
	/* 2385 */
	{40116, S_0283B0_FOV_TOP(~0u)},
	{40124, S_0283B0_FOV_BOT(~0u)},
	/* 2387 */
	{39902, S_0287A0_EPITCH(~0u)},
	/* 2388 */
	{39902, S_0287A4_EPITCH(~0u)},
	/* 2389 */
	{39902, S_0287A8_EPITCH(~0u)},
	/* 2390 */
	{39902, S_0287AC_EPITCH(~0u)},
	/* 2391 */
	{39902, S_0287B0_EPITCH(~0u)},
	/* 2392 */
	{39902, S_0287B4_EPITCH(~0u)},
	/* 2393 */
	{39902, S_0287B8_EPITCH(~0u)},
	/* 2394 */
	{39902, S_0287BC_EPITCH(~0u)},
	/* 2395 */
	{40132, S_028834_OBJ_ID_SEL(~0u)},
	{40143, S_028834_ADD_PIPED_PRIM_ID(~0u)},
	{40161, S_028834_EN_32BIT_OBJPRIMID(~0u)},
	/* 2398 */
	{40180, S_028838_VERTEX_REUSE_OFF(~0u)},
	{40197, S_028838_INDEX_BUF_EDGE_FLAG_ENA(~0u)},
	/* 2400 */
	{40221, S_02883C_DISCARD_0_AREA_TRIANGLES(~0u)},
	{40246, S_02883C_DISCARD_0_AREA_LINES(~0u)},
	{40267, S_02883C_DISCARD_0_AREA_POINTS(~0u)},
	{40289, S_02883C_DISCARD_0_AREA_RECTANGLES(~0u)},
	{40315, S_02883C_USE_PROVOKING_ZW(~0u)},
	/* 2405 */
	{40332, S_028A94_MAX_PRIMS_PER_SUBGROUP(~0u)},
	/* 2406 */
	{40355, S_028A98_OBJPRIM_ID_EN(~0u)},
	{40369, S_028A98_EN_REG_RT_INDEX(~0u)},
	{40385, S_028A98_EN_PIPELINE_PRIMID(~0u)},
	{40404, S_028A98_OBJECT_ID_INST_EN(~0u)},
	/* 2410 */
	{40422, S_028A9C_COMPOUND_INDEX_EN(~0u)},
	/* 2411 */
	{35648, S_028B9C_EVENT_TYPE(~0u)},
	{8881, S_028B9C_ADDRESS_HI(~0u)},
	{35675, S_028B9C_EXTENDED_EVENT(~0u)},
	/* 2414 */
	{40530, S_028C44_BINNING_MODE(~0u), 4, 1523},
	{40543, S_028C44_BIN_SIZE_X(~0u)},
	{40554, S_028C44_BIN_SIZE_Y(~0u)},
	{40565, S_028C44_BIN_SIZE_X_EXTEND(~0u)},
	{40583, S_028C44_BIN_SIZE_Y_EXTEND(~0u)},
	{40601, S_028C44_CONTEXT_STATES_PER_BIN(~0u)},
	{40624, S_028C44_PERSISTENT_STATES_PER_BIN(~0u)},
	{40650, S_028C44_DISABLE_START_OF_PRIM(~0u)},
	{40672, S_028C44_FPOVS_PER_BATCH(~0u)},
	{40688, S_028C44_OPTIMAL_BIN_SELECTION(~0u)},
	/* 2424 */
	{40710, S_028C48_MAX_ALLOC_COUNT(~0u)},
	{40726, S_028C48_MAX_PRIM_PER_BATCH(~0u)},
	/* 2426 */
	{40745, S_028C4C_OVER_RAST_ENABLE(~0u)},
	{40762, S_028C4C_OVER_RAST_SAMPLE_SELECT(~0u)},
	{40786, S_028C4C_UNDER_RAST_ENABLE(~0u)},
	{40804, S_028C4C_UNDER_RAST_SAMPLE_SELECT(~0u)},
	{40829, S_028C4C_PBB_UNCERTAINTY_REGION_ENABLE(~0u)},
	{40859, S_028C4C_ZMM_TRI_EXTENT(~0u)},
	{40874, S_028C4C_ZMM_TRI_OFFSET(~0u)},
	{40889, S_028C4C_OVERRIDE_OVER_RAST_INNER_TO_NORMAL(~0u)},
	{40924, S_028C4C_OVERRIDE_UNDER_RAST_INNER_TO_NORMAL(~0u)},
	{40960, S_028C4C_DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE(~0u)},
	{41004, S_028C4C_UNCERTAINTY_REGION_MODE(~0u)},
	{41028, S_028C4C_OUTER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{41064, S_028C4C_INNER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{41100, S_028C4C_NULL_SQUAD_AA_MASK_ENABLE(~0u)},
	{41126, S_028C4C_COVERAGE_AA_MASK_ENABLE(~0u)},
	{41150, S_028C4C_PREZ_AA_MASK_ENABLE(~0u)},
	{41170, S_028C4C_POSTZ_AA_MASK_ENABLE(~0u)},
	{41191, S_028C4C_CENTROID_SAMPLE_OVERRIDE(~0u)},
	/* 2444 */
	{41216, S_028C50_MAX_DEALLOCS_IN_WAVE(~0u)},
	/* 2445 */
	{41237, S_028C64_BASE_256B(~0u)},
	/* 2446 */
	{41247, S_028C68_MIP0_HEIGHT(~0u)},
	{41259, S_028C68_MIP0_WIDTH(~0u)},
	{13823, S_028C68_MAX_MIP(~0u)},
	/* 2449 */
	{41237, S_028C80_BASE_256B(~0u)},
	/* 2450 */
	{41237, S_028C88_BASE_256B(~0u)},
	/* 2451 */
	{41237, S_028C98_BASE_256B(~0u)},
};

static const struct si_reg sid_reg_table[] = {
	{41270, R_2C3_DRAW_INDEX_LOC, 2, 0},
	{195, R_370_CONTROL, 4, 2},
	{1099, R_371_DST_ADDR_LO},
	{1111, R_372_DST_ADDR_HI},
	{41285, R_3F0_IB_BASE_LO},
	{41296, R_3F1_IB_BASE_HI},
	{195, R_3F2_CONTROL, 3, 6},
	{41307, R_410_CP_DMA_WORD0, 1, 9},
	{41320, R_411_CP_DMA_WORD1, 5, 10},
	{41333, R_412_CP_DMA_WORD2, 1, 15},
	{41346, R_413_CP_DMA_WORD3, 1, 16},
	{41359, R_414_COMMAND, 11, 17},
	{41367, R_500_DMA_DATA_WORD0, 4, 28},
	{988, R_501_SRC_ADDR_LO},
	{1087, R_502_SRC_ADDR_HI},
	{1099, R_503_DST_ADDR_LO},
	{1111, R_504_DST_ADDR_HI},
	{41382, R_000E4C_SRBM_STATUS2, 21, 32},
	{41395, R_000E50_SRBM_STATUS, 20, 53},
	{41407, R_000E54_SRBM_STATUS3, 16, 73},
	{41420, R_00D034_SDMA0_STATUS_REG, 29, 89},
	{41437, R_00D834_SDMA1_STATUS_REG, 29, 89},
	{41454, R_008008_GRBM_STATUS2, 25, 118},
	{41467, R_008010_GRBM_STATUS, 25, 143},
	{41479, R_0084FC_CP_STRMOUT_CNTL, 1, 168},
	{41495, R_0085F0_CP_COHER_CNTL, 19, 169},
	{41509, R_0085F4_CP_COHER_SIZE},
	{41523, R_0085F8_CP_COHER_BASE},
	{41537, R_008014_GRBM_STATUS_SE0, 12, 188},
	{41553, R_008018_GRBM_STATUS_SE1, 12, 200},
	{41569, R_008038_GRBM_STATUS_SE2, 12, 212},
	{41585, R_00803C_GRBM_STATUS_SE3, 12, 224},
	{41479, R_0300FC_CP_STRMOUT_CNTL, 1, 236},
	{41601, R_0301E4_CP_COHER_BASE_HI, 1, 237},
	{41618, R_0301EC_CP_COHER_START_DELAY, 1, 238},
	{41495, R_0301F0_CP_COHER_CNTL, 29, 239},
	{41509, R_0301F4_CP_COHER_SIZE},
	{41523, R_0301F8_CP_COHER_BASE},
	{41639, R_0301FC_CP_COHER_STATUS, 4, 268},
	{41655, R_008210_CP_CPC_STATUS, 17, 272},
	{41669, R_008214_CP_CPC_BUSY_STAT, 28, 289},
	{41686, R_008218_CP_CPC_STALLED_STAT1, 17, 317},
	{41707, R_00821C_CP_CPF_STATUS, 22, 334},
	{41721, R_008220_CP_CPF_BUSY_STAT, 31, 356},
	{41738, R_008224_CP_CPF_STALLED_STAT1, 14, 387},
	{41759, R_030230_CP_COHER_SIZE_HI, 1, 401},
	{41776, R_0088B0_VGT_VTX_VECT_EJECT_REG, 1, 402},
	{41799, R_0088C4_VGT_CACHE_INVALIDATION, 3, 403},
	{41822, R_0088C8_VGT_ESGS_RING_SIZE},
	{41841, R_0088CC_VGT_GSVS_RING_SIZE},
	{41860, R_0088D4_VGT_GS_VERTEX_REUSE, 1, 406},
	{41880, R_008958_VGT_PRIMITIVE_TYPE, 1, 407},
	{41899, R_00895C_VGT_INDEX_TYPE, 1, 408},
	{41914, R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{41947, R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{41980, R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{42013, R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{42046, R_008970_VGT_NUM_INDICES},
	{42062, R_008974_VGT_NUM_INSTANCES},
	{42080, R_008988_VGT_TF_RING_SIZE, 1, 409},
	{42097, R_0089B0_VGT_HS_OFFCHIP_PARAM, 1, 410},
	{42118, R_0089B8_VGT_TF_MEMORY_BASE},
	{42137, R_008A14_PA_CL_ENHANCE, 4, 411},
	{42151, R_008A60_PA_SU_LINE_STIPPLE_VALUE, 1, 415},
	{42176, R_008B10_PA_SC_LINE_STIPPLE_STATE, 2, 416},
	{42201, R_008670_CP_STALLED_STAT3, 22, 418},
	{42218, R_008674_CP_STALLED_STAT1, 16, 440},
	{42235, R_008678_CP_STALLED_STAT2, 29, 456},
	{42252, R_008680_CP_STAT, 24, 485},
	{42260, R_030800_GRBM_GFX_INDEX, 6, 509},
	{41822, R_030900_VGT_ESGS_RING_SIZE},
	{41841, R_030904_VGT_GSVS_RING_SIZE},
	{41880, R_030908_VGT_PRIMITIVE_TYPE, 1, 515},
	{41899, R_03090C_VGT_INDEX_TYPE, 2, 516},
	{41914, R_030910_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{41947, R_030914_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{41980, R_030918_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{42013, R_03091C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{42046, R_030930_VGT_NUM_INDICES},
	{42062, R_030934_VGT_NUM_INSTANCES},
	{42080, R_030938_VGT_TF_RING_SIZE, 1, 518},
	{42097, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 519},
	{42118, R_030940_VGT_TF_MEMORY_BASE},
	{42151, R_030A00_PA_SU_LINE_STIPPLE_VALUE, 1, 521},
	{42176, R_030A04_PA_SC_LINE_STIPPLE_STATE, 2, 522},
	{42275, R_030A10_PA_SC_SCREEN_EXTENT_MIN_0, 2, 524},
	{42301, R_030A14_PA_SC_SCREEN_EXTENT_MAX_0, 2, 526},
	{42327, R_030A18_PA_SC_SCREEN_EXTENT_MIN_1, 2, 528},
	{42353, R_030A2C_PA_SC_SCREEN_EXTENT_MAX_1, 2, 530},
	{42379, R_008BF0_PA_SC_ENHANCE, 9, 532},
	{42393, R_008C08_SQC_CACHES, 2, 541},
	{42393, R_030D20_SQC_CACHES, 9, 543},
	{42404, R_008C0C_SQ_RANDOM_WAVE_PRI, 3, 552},
	{42423, R_008DFC_SQ_EXP_0, 6, 555},
	{42432, R_030E00_TA_CS_BC_BASE_ADDR},
	{42451, R_030E04_TA_CS_BC_BASE_ADDR_HI, 1, 561},
	{42473, R_030F00_DB_OCCLUSION_COUNT0_LOW},
	{42497, R_008F00_SQ_BUF_RSRC_WORD0},
	{42515, R_030F04_DB_OCCLUSION_COUNT0_HI, 1, 562},
	{42538, R_008F04_SQ_BUF_RSRC_WORD1, 4, 563},
	{42556, R_030F08_DB_OCCLUSION_COUNT1_LOW},
	{42580, R_008F08_SQ_BUF_RSRC_WORD2},
	{42598, R_030F0C_DB_OCCLUSION_COUNT1_HI, 1, 567},
	{42621, R_008F0C_SQ_BUF_RSRC_WORD3, 17, 568},
	{42639, R_030F10_DB_OCCLUSION_COUNT2_LOW},
	{42663, R_008F10_SQ_IMG_RSRC_WORD0},
	{42681, R_030F14_DB_OCCLUSION_COUNT2_HI, 1, 585},
	{42704, R_008F14_SQ_IMG_RSRC_WORD1, 12, 586},
	{42722, R_030F18_DB_OCCLUSION_COUNT3_LOW},
	{42746, R_008F18_SQ_IMG_RSRC_WORD2, 4, 598},
	{42764, R_030F1C_DB_OCCLUSION_COUNT3_HI, 1, 602},
	{42787, R_008F1C_SQ_IMG_RSRC_WORD3, 12, 603},
	{42805, R_008F20_SQ_IMG_RSRC_WORD4, 4, 615},
	{42823, R_008F24_SQ_IMG_RSRC_WORD5, 8, 619},
	{42841, R_008F28_SQ_IMG_RSRC_WORD6, 8, 627},
	{42859, R_008F2C_SQ_IMG_RSRC_WORD7},
	{42877, R_008F30_SQ_IMG_SAMP_WORD0, 14, 635},
	{42895, R_008F34_SQ_IMG_SAMP_WORD1, 4, 649},
	{42913, R_008F38_SQ_IMG_SAMP_WORD2, 11, 653},
	{42931, R_008F3C_SQ_IMG_SAMP_WORD3, 3, 664},
	{42949, R_0090DC_SPI_DYN_GPR_LOCK_EN, 5, 667},
	{42969, R_0090E0_SPI_STATIC_THREAD_MGMT_1, 2, 672},
	{42994, R_0090E4_SPI_STATIC_THREAD_MGMT_2, 2, 674},
	{43019, R_0090E8_SPI_STATIC_THREAD_MGMT_3, 1, 676},
	{43044, R_0090EC_SPI_PS_MAX_WAVE_ID, 1, 677},
	{43044, R_0090E8_SPI_PS_MAX_WAVE_ID, 1, 678},
	{43063, R_0090F0_SPI_ARB_PRIORITY, 3, 679},
	{43063, R_00C700_SPI_ARB_PRIORITY, 8, 682},
	{43080, R_0090F4_SPI_ARB_CYCLES_0, 2, 690},
	{43097, R_0090F8_SPI_ARB_CYCLES_1, 1, 692},
	{43114, R_008F40_SQ_FLAT_SCRATCH_WORD0, 1, 693},
	{43136, R_008F44_SQ_FLAT_SCRATCH_WORD1, 1, 694},
	{43158, R_030FF8_DB_ZPASS_COUNT_LOW},
	{43177, R_030FFC_DB_ZPASS_COUNT_HI, 1, 695},
	{43195, R_009100_SPI_CONFIG_CNTL, 5, 696},
	{43211, R_00913C_SPI_CONFIG_CNTL_1, 5, 701},
	{43229, R_00936C_SPI_RESOURCE_RESERVE_CU_AB_0, 12, 706},
	{42432, R_00950C_TA_CS_BC_BASE_ADDR},
	{43258, R_009858_DB_SUBTILE_CONTROL, 10, 718},
	{43277, R_0098F8_GB_ADDR_CONFIG, 16, 728},
	{43292, R_009910_GB_TILE_MODE0, 10, 744},
	{43306, R_009914_GB_TILE_MODE1, 10, 744},
	{43320, R_009918_GB_TILE_MODE2, 10, 744},
	{43334, R_00991C_GB_TILE_MODE3, 10, 744},
	{43348, R_009920_GB_TILE_MODE4, 10, 744},
	{43362, R_009924_GB_TILE_MODE5, 10, 744},
	{43376, R_009928_GB_TILE_MODE6, 10, 744},
	{43390, R_00992C_GB_TILE_MODE7, 10, 744},
	{43404, R_009930_GB_TILE_MODE8, 10, 744},
	{43418, R_009934_GB_TILE_MODE9, 10, 744},
	{43432, R_009938_GB_TILE_MODE10, 10, 744},
	{43447, R_00993C_GB_TILE_MODE11, 10, 744},
	{43462, R_009940_GB_TILE_MODE12, 10, 744},
	{43477, R_009944_GB_TILE_MODE13, 10, 744},
	{43492, R_009948_GB_TILE_MODE14, 10, 744},
	{43507, R_00994C_GB_TILE_MODE15, 10, 744},
	{43522, R_009950_GB_TILE_MODE16, 10, 744},
	{43537, R_009954_GB_TILE_MODE17, 10, 744},
	{43552, R_009958_GB_TILE_MODE18, 10, 744},
	{43567, R_00995C_GB_TILE_MODE19, 10, 744},
	{43582, R_009960_GB_TILE_MODE20, 10, 744},
	{43597, R_009964_GB_TILE_MODE21, 10, 744},
	{43612, R_009968_GB_TILE_MODE22, 10, 744},
	{43627, R_00996C_GB_TILE_MODE23, 10, 744},
	{43642, R_009970_GB_TILE_MODE24, 10, 744},
	{43657, R_009974_GB_TILE_MODE25, 10, 744},
	{43672, R_009978_GB_TILE_MODE26, 10, 744},
	{43687, R_00997C_GB_TILE_MODE27, 10, 744},
	{43702, R_009980_GB_TILE_MODE28, 10, 744},
	{43717, R_009984_GB_TILE_MODE29, 10, 744},
	{43732, R_009988_GB_TILE_MODE30, 10, 744},
	{43747, R_00998C_GB_TILE_MODE31, 10, 744},
	{43762, R_009990_GB_MACROTILE_MODE0, 4, 754},
	{43781, R_009994_GB_MACROTILE_MODE1, 4, 754},
	{43800, R_009998_GB_MACROTILE_MODE2, 4, 754},
	{43819, R_00999C_GB_MACROTILE_MODE3, 4, 754},
	{43838, R_0099A0_GB_MACROTILE_MODE4, 4, 754},
	{43857, R_0099A4_GB_MACROTILE_MODE5, 4, 754},
	{43876, R_0099A8_GB_MACROTILE_MODE6, 4, 754},
	{43895, R_0099AC_GB_MACROTILE_MODE7, 4, 754},
	{43914, R_0099B0_GB_MACROTILE_MODE8, 4, 754},
	{43933, R_0099B4_GB_MACROTILE_MODE9, 4, 754},
	{43952, R_0099B8_GB_MACROTILE_MODE10, 4, 754},
	{43972, R_0099BC_GB_MACROTILE_MODE11, 4, 754},
	{43992, R_0099C0_GB_MACROTILE_MODE12, 4, 754},
	{44012, R_0099C4_GB_MACROTILE_MODE13, 4, 754},
	{44032, R_0099C8_GB_MACROTILE_MODE14, 4, 754},
	{44052, R_0099CC_GB_MACROTILE_MODE15, 4, 754},
	{44072, R_00B000_SPI_SHADER_TBA_LO_PS},
	{44093, R_00B004_SPI_SHADER_TBA_HI_PS, 1, 758},
	{44114, R_00B008_SPI_SHADER_TMA_LO_PS},
	{44135, R_00B00C_SPI_SHADER_TMA_HI_PS, 1, 759},
	{44156, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 4, 760},
	{44180, R_00B020_SPI_SHADER_PGM_LO_PS},
	{44201, R_00B024_SPI_SHADER_PGM_HI_PS, 1, 764},
	{44222, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 12, 765},
	{44246, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 11, 777},
	{44270, R_00B030_SPI_SHADER_USER_DATA_PS_0},
	{44296, R_00B034_SPI_SHADER_USER_DATA_PS_1},
	{44322, R_00B038_SPI_SHADER_USER_DATA_PS_2},
	{44348, R_00B03C_SPI_SHADER_USER_DATA_PS_3},
	{44374, R_00B040_SPI_SHADER_USER_DATA_PS_4},
	{44400, R_00B044_SPI_SHADER_USER_DATA_PS_5},
	{44426, R_00B048_SPI_SHADER_USER_DATA_PS_6},
	{44452, R_00B04C_SPI_SHADER_USER_DATA_PS_7},
	{44478, R_00B050_SPI_SHADER_USER_DATA_PS_8},
	{44504, R_00B054_SPI_SHADER_USER_DATA_PS_9},
	{44530, R_00B058_SPI_SHADER_USER_DATA_PS_10},
	{44557, R_00B05C_SPI_SHADER_USER_DATA_PS_11},
	{44584, R_00B060_SPI_SHADER_USER_DATA_PS_12},
	{44611, R_00B064_SPI_SHADER_USER_DATA_PS_13},
	{44638, R_00B068_SPI_SHADER_USER_DATA_PS_14},
	{44665, R_00B06C_SPI_SHADER_USER_DATA_PS_15},
	{44692, R_00B100_SPI_SHADER_TBA_LO_VS},
	{44713, R_00B104_SPI_SHADER_TBA_HI_VS, 1, 788},
	{44734, R_00B108_SPI_SHADER_TMA_LO_VS},
	{44755, R_00B10C_SPI_SHADER_TMA_HI_VS, 1, 789},
	{44776, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 4, 790},
	{44800, R_00B11C_SPI_SHADER_LATE_ALLOC_VS, 1, 794},
	{44825, R_00B120_SPI_SHADER_PGM_LO_VS},
	{44846, R_00B124_SPI_SHADER_PGM_HI_VS, 1, 795},
	{44867, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 13, 796},
	{44891, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 15, 809},
	{44915, R_00B130_SPI_SHADER_USER_DATA_VS_0},
	{44941, R_00B134_SPI_SHADER_USER_DATA_VS_1},
	{44967, R_00B138_SPI_SHADER_USER_DATA_VS_2},
	{44993, R_00B13C_SPI_SHADER_USER_DATA_VS_3},
	{45019, R_00B140_SPI_SHADER_USER_DATA_VS_4},
	{45045, R_00B144_SPI_SHADER_USER_DATA_VS_5},
	{45071, R_00B148_SPI_SHADER_USER_DATA_VS_6},
	{45097, R_00B14C_SPI_SHADER_USER_DATA_VS_7},
	{45123, R_00B150_SPI_SHADER_USER_DATA_VS_8},
	{45149, R_00B154_SPI_SHADER_USER_DATA_VS_9},
	{45175, R_00B158_SPI_SHADER_USER_DATA_VS_10},
	{45202, R_00B15C_SPI_SHADER_USER_DATA_VS_11},
	{45229, R_00B160_SPI_SHADER_USER_DATA_VS_12},
	{45256, R_00B164_SPI_SHADER_USER_DATA_VS_13},
	{45283, R_00B168_SPI_SHADER_USER_DATA_VS_14},
	{45310, R_00B16C_SPI_SHADER_USER_DATA_VS_15},
	{45337, R_00B200_SPI_SHADER_TBA_LO_GS},
	{45358, R_00B204_SPI_SHADER_TBA_HI_GS, 1, 824},
	{45379, R_00B208_SPI_SHADER_TMA_LO_GS},
	{45400, R_00B20C_SPI_SHADER_TMA_HI_GS, 1, 825},
	{45421, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 5, 826},
	{45445, R_00B220_SPI_SHADER_PGM_LO_GS},
	{45466, R_00B224_SPI_SHADER_PGM_HI_GS, 1, 831},
	{45487, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 13, 832},
	{45511, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 10, 845},
	{45535, R_00B230_SPI_SHADER_USER_DATA_GS_0},
	{45561, R_00B234_SPI_SHADER_USER_DATA_GS_1},
	{45587, R_00B238_SPI_SHADER_USER_DATA_GS_2},
	{45613, R_00B23C_SPI_SHADER_USER_DATA_GS_3},
	{45639, R_00B240_SPI_SHADER_USER_DATA_GS_4},
	{45665, R_00B244_SPI_SHADER_USER_DATA_GS_5},
	{45691, R_00B248_SPI_SHADER_USER_DATA_GS_6},
	{45717, R_00B24C_SPI_SHADER_USER_DATA_GS_7},
	{45743, R_00B250_SPI_SHADER_USER_DATA_GS_8},
	{45769, R_00B254_SPI_SHADER_USER_DATA_GS_9},
	{45795, R_00B258_SPI_SHADER_USER_DATA_GS_10},
	{45822, R_00B25C_SPI_SHADER_USER_DATA_GS_11},
	{45849, R_00B260_SPI_SHADER_USER_DATA_GS_12},
	{45876, R_00B264_SPI_SHADER_USER_DATA_GS_13},
	{45903, R_00B268_SPI_SHADER_USER_DATA_GS_14},
	{45930, R_00B26C_SPI_SHADER_USER_DATA_GS_15},
	{45957, R_00B300_SPI_SHADER_TBA_LO_ES},
	{45978, R_00B304_SPI_SHADER_TBA_HI_ES, 1, 855},
	{45999, R_00B308_SPI_SHADER_TMA_LO_ES},
	{46020, R_00B30C_SPI_SHADER_TMA_HI_ES, 1, 856},
	{46041, R_00B31C_SPI_SHADER_PGM_RSRC3_ES, 4, 857},
	{46065, R_00B320_SPI_SHADER_PGM_LO_ES},
	{46086, R_00B324_SPI_SHADER_PGM_HI_ES, 1, 861},
	{46107, R_00B328_SPI_SHADER_PGM_RSRC1_ES, 12, 862},
	{46131, R_00B32C_SPI_SHADER_PGM_RSRC2_ES, 7, 874},
	{46155, R_00B330_SPI_SHADER_USER_DATA_ES_0},
	{46181, R_00B334_SPI_SHADER_USER_DATA_ES_1},
	{46207, R_00B338_SPI_SHADER_USER_DATA_ES_2},
	{46233, R_00B33C_SPI_SHADER_USER_DATA_ES_3},
	{46259, R_00B340_SPI_SHADER_USER_DATA_ES_4},
	{46285, R_00B344_SPI_SHADER_USER_DATA_ES_5},
	{46311, R_00B348_SPI_SHADER_USER_DATA_ES_6},
	{46337, R_00B34C_SPI_SHADER_USER_DATA_ES_7},
	{46363, R_00B350_SPI_SHADER_USER_DATA_ES_8},
	{46389, R_00B354_SPI_SHADER_USER_DATA_ES_9},
	{46415, R_00B358_SPI_SHADER_USER_DATA_ES_10},
	{46442, R_00B35C_SPI_SHADER_USER_DATA_ES_11},
	{46469, R_00B360_SPI_SHADER_USER_DATA_ES_12},
	{46496, R_00B364_SPI_SHADER_USER_DATA_ES_13},
	{46523, R_00B368_SPI_SHADER_USER_DATA_ES_14},
	{46550, R_00B36C_SPI_SHADER_USER_DATA_ES_15},
	{46577, R_00B400_SPI_SHADER_TBA_LO_HS},
	{46598, R_00B404_SPI_SHADER_TBA_HI_HS, 1, 881},
	{46619, R_00B408_SPI_SHADER_TMA_LO_HS},
	{46640, R_00B40C_SPI_SHADER_TMA_HI_HS, 1, 882},
	{46661, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 5, 883},
	{46685, R_00B420_SPI_SHADER_PGM_LO_HS},
	{46706, R_00B424_SPI_SHADER_PGM_HI_HS, 1, 888},
	{46727, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 12, 889},
	{46751, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 11, 901},
	{46775, R_00B430_SPI_SHADER_USER_DATA_HS_0},
	{46801, R_00B434_SPI_SHADER_USER_DATA_HS_1},
	{46827, R_00B438_SPI_SHADER_USER_DATA_HS_2},
	{46853, R_00B43C_SPI_SHADER_USER_DATA_HS_3},
	{46879, R_00B440_SPI_SHADER_USER_DATA_HS_4},
	{46905, R_00B444_SPI_SHADER_USER_DATA_HS_5},
	{46931, R_00B448_SPI_SHADER_USER_DATA_HS_6},
	{46957, R_00B44C_SPI_SHADER_USER_DATA_HS_7},
	{46983, R_00B450_SPI_SHADER_USER_DATA_HS_8},
	{47009, R_00B454_SPI_SHADER_USER_DATA_HS_9},
	{47035, R_00B458_SPI_SHADER_USER_DATA_HS_10},
	{47062, R_00B45C_SPI_SHADER_USER_DATA_HS_11},
	{47089, R_00B460_SPI_SHADER_USER_DATA_HS_12},
	{47116, R_00B464_SPI_SHADER_USER_DATA_HS_13},
	{47143, R_00B468_SPI_SHADER_USER_DATA_HS_14},
	{47170, R_00B46C_SPI_SHADER_USER_DATA_HS_15},
	{47197, R_00B500_SPI_SHADER_TBA_LO_LS},
	{47218, R_00B504_SPI_SHADER_TBA_HI_LS, 1, 912},
	{47239, R_00B508_SPI_SHADER_TMA_LO_LS},
	{47260, R_00B50C_SPI_SHADER_TMA_HI_LS, 1, 913},
	{47281, R_00B51C_SPI_SHADER_PGM_RSRC3_LS, 4, 914},
	{47305, R_00B520_SPI_SHADER_PGM_LO_LS},
	{47326, R_00B524_SPI_SHADER_PGM_HI_LS, 1, 918},
	{47347, R_00B528_SPI_SHADER_PGM_RSRC1_LS, 11, 919},
	{47371, R_00B52C_SPI_SHADER_PGM_RSRC2_LS, 6, 930},
	{47395, R_00B530_SPI_SHADER_USER_DATA_LS_0},
	{47421, R_00B534_SPI_SHADER_USER_DATA_LS_1},
	{47447, R_00B538_SPI_SHADER_USER_DATA_LS_2},
	{47473, R_00B53C_SPI_SHADER_USER_DATA_LS_3},
	{47499, R_00B540_SPI_SHADER_USER_DATA_LS_4},
	{47525, R_00B544_SPI_SHADER_USER_DATA_LS_5},
	{47551, R_00B548_SPI_SHADER_USER_DATA_LS_6},
	{47577, R_00B54C_SPI_SHADER_USER_DATA_LS_7},
	{47603, R_00B550_SPI_SHADER_USER_DATA_LS_8},
	{47629, R_00B554_SPI_SHADER_USER_DATA_LS_9},
	{47655, R_00B558_SPI_SHADER_USER_DATA_LS_10},
	{47682, R_00B55C_SPI_SHADER_USER_DATA_LS_11},
	{47709, R_00B560_SPI_SHADER_USER_DATA_LS_12},
	{47736, R_00B564_SPI_SHADER_USER_DATA_LS_13},
	{47763, R_00B568_SPI_SHADER_USER_DATA_LS_14},
	{47790, R_00B56C_SPI_SHADER_USER_DATA_LS_15},
	{47817, R_00B800_COMPUTE_DISPATCH_INITIATOR, 13, 936},
	{47844, R_00B804_COMPUTE_DIM_X},
	{47858, R_00B808_COMPUTE_DIM_Y},
	{47872, R_00B80C_COMPUTE_DIM_Z},
	{47886, R_00B810_COMPUTE_START_X},
	{47902, R_00B814_COMPUTE_START_Y},
	{47918, R_00B818_COMPUTE_START_Z},
	{47934, R_00B81C_COMPUTE_NUM_THREAD_X, 2, 949},
	{47955, R_00B820_COMPUTE_NUM_THREAD_Y, 2, 951},
	{47976, R_00B824_COMPUTE_NUM_THREAD_Z, 2, 953},
	{47997, R_00B82C_COMPUTE_MAX_WAVE_ID, 1, 955},
	{48017, R_00B828_COMPUTE_PIPELINESTAT_ENABLE, 1, 956},
	{48045, R_00B82C_COMPUTE_PERFCOUNT_ENABLE, 1, 957},
	{48070, R_00B830_COMPUTE_PGM_LO},
	{48085, R_00B834_COMPUTE_PGM_HI, 2, 958},
	{48100, R_00B838_COMPUTE_TBA_LO},
	{48115, R_00B83C_COMPUTE_TBA_HI, 1, 960},
	{48130, R_00B840_COMPUTE_TMA_LO},
	{48145, R_00B844_COMPUTE_TMA_HI, 1, 961},
	{48160, R_00B848_COMPUTE_PGM_RSRC1, 11, 962},
	{48178, R_00B84C_COMPUTE_PGM_RSRC2, 12, 973},
	{48196, R_00B850_COMPUTE_VMID, 1, 985},
	{48209, R_00B854_COMPUTE_RESOURCE_LIMITS, 8, 986},
	{48233, R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0, 2, 994},
	{48264, R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1, 2, 996},
	{48295, R_00B860_COMPUTE_TMPRING_SIZE, 2, 998},
	{48316, R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2, 2, 1000},
	{48347, R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3, 2, 1002},
	{48378, R_00B86C_COMPUTE_RESTART_X},
	{48396, R_00B870_COMPUTE_RESTART_Y},
	{48414, R_00B874_COMPUTE_RESTART_Z},
	{48432, R_00B87C_COMPUTE_MISC_RESERVED, 5, 1004},
	{48454, R_00B880_COMPUTE_DISPATCH_ID},
	{48474, R_00B884_COMPUTE_THREADGROUP_ID},
	{48497, R_00B888_COMPUTE_RELAUNCH, 3, 1009},
	{48514, R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO},
	{48543, R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI, 1, 1012},
	{48572, R_00B894_COMPUTE_WAVE_RESTORE_CONTROL, 2, 1013},
	{48601, R_00B900_COMPUTE_USER_DATA_0},
	{48621, R_00B904_COMPUTE_USER_DATA_1},
	{48641, R_00B908_COMPUTE_USER_DATA_2},
	{48661, R_00B90C_COMPUTE_USER_DATA_3},
	{48681, R_00B910_COMPUTE_USER_DATA_4},
	{48701, R_00B914_COMPUTE_USER_DATA_5},
	{48721, R_00B918_COMPUTE_USER_DATA_6},
	{48741, R_00B91C_COMPUTE_USER_DATA_7},
	{48761, R_00B920_COMPUTE_USER_DATA_8},
	{48781, R_00B924_COMPUTE_USER_DATA_9},
	{48801, R_00B928_COMPUTE_USER_DATA_10},
	{48822, R_00B92C_COMPUTE_USER_DATA_11},
	{48843, R_00B930_COMPUTE_USER_DATA_12},
	{48864, R_00B934_COMPUTE_USER_DATA_13},
	{48885, R_00B938_COMPUTE_USER_DATA_14},
	{48906, R_00B93C_COMPUTE_USER_DATA_15},
	{48927, R_00B9FC_COMPUTE_NOWHERE},
	{48943, R_034000_CPG_PERFCOUNTER1_LO},
	{48963, R_034004_CPG_PERFCOUNTER1_HI},
	{48983, R_034008_CPG_PERFCOUNTER0_LO},
	{49003, R_03400C_CPG_PERFCOUNTER0_HI},
	{49023, R_034010_CPC_PERFCOUNTER1_LO},
	{49043, R_034014_CPC_PERFCOUNTER1_HI},
	{49063, R_034018_CPC_PERFCOUNTER0_LO},
	{49083, R_03401C_CPC_PERFCOUNTER0_HI},
	{49103, R_034020_CPF_PERFCOUNTER1_LO},
	{49123, R_034024_CPF_PERFCOUNTER1_HI},
	{49143, R_034028_CPF_PERFCOUNTER0_LO},
	{49163, R_03402C_CPF_PERFCOUNTER0_HI},
	{49183, R_034100_GRBM_PERFCOUNTER0_LO},
	{49204, R_034104_GRBM_PERFCOUNTER0_HI},
	{49225, R_03410C_GRBM_PERFCOUNTER1_LO},
	{49246, R_034110_GRBM_PERFCOUNTER1_HI},
	{49267, R_034114_GRBM_SE0_PERFCOUNTER_LO},
	{49291, R_034118_GRBM_SE0_PERFCOUNTER_HI},
	{49315, R_03411C_GRBM_SE1_PERFCOUNTER_LO},
	{49339, R_034120_GRBM_SE1_PERFCOUNTER_HI},
	{49363, R_034124_GRBM_SE2_PERFCOUNTER_LO},
	{49387, R_034128_GRBM_SE2_PERFCOUNTER_HI},
	{49411, R_03412C_GRBM_SE3_PERFCOUNTER_LO},
	{49435, R_034130_GRBM_SE3_PERFCOUNTER_HI},
	{49459, R_034200_WD_PERFCOUNTER0_LO},
	{49478, R_034204_WD_PERFCOUNTER0_HI},
	{49497, R_034208_WD_PERFCOUNTER1_LO},
	{49516, R_03420C_WD_PERFCOUNTER1_HI},
	{49535, R_034210_WD_PERFCOUNTER2_LO},
	{49554, R_034214_WD_PERFCOUNTER2_HI},
	{49573, R_034218_WD_PERFCOUNTER3_LO},
	{49592, R_03421C_WD_PERFCOUNTER3_HI},
	{49611, R_034220_IA_PERFCOUNTER0_LO},
	{49630, R_034224_IA_PERFCOUNTER0_HI},
	{49649, R_034228_IA_PERFCOUNTER1_LO},
	{49668, R_03422C_IA_PERFCOUNTER1_HI},
	{49687, R_034230_IA_PERFCOUNTER2_LO},
	{49706, R_034234_IA_PERFCOUNTER2_HI},
	{49725, R_034238_IA_PERFCOUNTER3_LO},
	{49744, R_03423C_IA_PERFCOUNTER3_HI},
	{49763, R_034240_VGT_PERFCOUNTER0_LO},
	{49783, R_034244_VGT_PERFCOUNTER0_HI},
	{49803, R_034248_VGT_PERFCOUNTER1_LO},
	{49823, R_03424C_VGT_PERFCOUNTER1_HI},
	{49843, R_034250_VGT_PERFCOUNTER2_LO},
	{49863, R_034254_VGT_PERFCOUNTER2_HI},
	{49883, R_034258_VGT_PERFCOUNTER3_LO},
	{49903, R_03425C_VGT_PERFCOUNTER3_HI},
	{49923, R_034400_PA_SU_PERFCOUNTER0_LO},
	{49945, R_034404_PA_SU_PERFCOUNTER0_HI, 1, 1015},
	{49967, R_034408_PA_SU_PERFCOUNTER1_LO},
	{49989, R_03440C_PA_SU_PERFCOUNTER1_HI, 1, 1015},
	{50011, R_034410_PA_SU_PERFCOUNTER2_LO},
	{50033, R_034414_PA_SU_PERFCOUNTER2_HI, 1, 1015},
	{50055, R_034418_PA_SU_PERFCOUNTER3_LO},
	{50077, R_03441C_PA_SU_PERFCOUNTER3_HI, 1, 1015},
	{50099, R_034500_PA_SC_PERFCOUNTER0_LO},
	{50121, R_034504_PA_SC_PERFCOUNTER0_HI},
	{50143, R_034508_PA_SC_PERFCOUNTER1_LO},
	{50165, R_03450C_PA_SC_PERFCOUNTER1_HI},
	{50187, R_034510_PA_SC_PERFCOUNTER2_LO},
	{50209, R_034514_PA_SC_PERFCOUNTER2_HI},
	{50231, R_034518_PA_SC_PERFCOUNTER3_LO},
	{50253, R_03451C_PA_SC_PERFCOUNTER3_HI},
	{50275, R_034520_PA_SC_PERFCOUNTER4_LO},
	{50297, R_034524_PA_SC_PERFCOUNTER4_HI},
	{50319, R_034528_PA_SC_PERFCOUNTER5_LO},
	{50341, R_03452C_PA_SC_PERFCOUNTER5_HI},
	{50363, R_034530_PA_SC_PERFCOUNTER6_LO},
	{50385, R_034534_PA_SC_PERFCOUNTER6_HI},
	{50407, R_034538_PA_SC_PERFCOUNTER7_LO},
	{50429, R_03453C_PA_SC_PERFCOUNTER7_HI},
	{50451, R_034600_SPI_PERFCOUNTER0_HI},
	{50471, R_034604_SPI_PERFCOUNTER0_LO},
	{50491, R_034608_SPI_PERFCOUNTER1_HI},
	{50511, R_03460C_SPI_PERFCOUNTER1_LO},
	{50531, R_034610_SPI_PERFCOUNTER2_HI},
	{50551, R_034614_SPI_PERFCOUNTER2_LO},
	{50571, R_034618_SPI_PERFCOUNTER3_HI},
	{50591, R_03461C_SPI_PERFCOUNTER3_LO},
	{50611, R_034620_SPI_PERFCOUNTER4_HI},
	{50631, R_034624_SPI_PERFCOUNTER4_LO},
	{50651, R_034628_SPI_PERFCOUNTER5_HI},
	{50671, R_03462C_SPI_PERFCOUNTER5_LO},
	{50691, R_034700_SQ_PERFCOUNTER0_LO},
	{50710, R_034704_SQ_PERFCOUNTER0_HI},
	{50729, R_034708_SQ_PERFCOUNTER1_LO},
	{50748, R_03470C_SQ_PERFCOUNTER1_HI},
	{50767, R_034710_SQ_PERFCOUNTER2_LO},
	{50786, R_034714_SQ_PERFCOUNTER2_HI},
	{50805, R_034718_SQ_PERFCOUNTER3_LO},
	{50824, R_03471C_SQ_PERFCOUNTER3_HI},
	{50843, R_034720_SQ_PERFCOUNTER4_LO},
	{50862, R_034724_SQ_PERFCOUNTER4_HI},
	{50881, R_034728_SQ_PERFCOUNTER5_LO},
	{50900, R_03472C_SQ_PERFCOUNTER5_HI},
	{50919, R_034730_SQ_PERFCOUNTER6_LO},
	{50938, R_034734_SQ_PERFCOUNTER6_HI},
	{50957, R_034738_SQ_PERFCOUNTER7_LO},
	{50976, R_03473C_SQ_PERFCOUNTER7_HI},
	{50995, R_034740_SQ_PERFCOUNTER8_LO},
	{51014, R_034744_SQ_PERFCOUNTER8_HI},
	{51033, R_034748_SQ_PERFCOUNTER9_LO},
	{51052, R_03474C_SQ_PERFCOUNTER9_HI},
	{51071, R_034750_SQ_PERFCOUNTER10_LO},
	{51091, R_034754_SQ_PERFCOUNTER10_HI},
	{51111, R_034758_SQ_PERFCOUNTER11_LO},
	{51131, R_03475C_SQ_PERFCOUNTER11_HI},
	{51151, R_034760_SQ_PERFCOUNTER12_LO},
	{51171, R_034764_SQ_PERFCOUNTER12_HI},
	{51191, R_034768_SQ_PERFCOUNTER13_LO},
	{51211, R_03476C_SQ_PERFCOUNTER13_HI},
	{51231, R_034770_SQ_PERFCOUNTER14_LO},
	{51251, R_034774_SQ_PERFCOUNTER14_HI},
	{51271, R_034778_SQ_PERFCOUNTER15_LO},
	{51291, R_03477C_SQ_PERFCOUNTER15_HI},
	{51311, R_034900_SX_PERFCOUNTER0_LO},
	{51330, R_034904_SX_PERFCOUNTER0_HI},
	{51349, R_034908_SX_PERFCOUNTER1_LO},
	{51368, R_03490C_SX_PERFCOUNTER1_HI},
	{51387, R_034910_SX_PERFCOUNTER2_LO},
	{51406, R_034914_SX_PERFCOUNTER2_HI},
	{51425, R_034918_SX_PERFCOUNTER3_LO},
	{51444, R_03491C_SX_PERFCOUNTER3_HI},
	{51463, R_034A00_GDS_PERFCOUNTER0_LO},
	{51483, R_034A04_GDS_PERFCOUNTER0_HI},
	{51503, R_034A08_GDS_PERFCOUNTER1_LO},
	{51523, R_034A0C_GDS_PERFCOUNTER1_HI},
	{51543, R_034A10_GDS_PERFCOUNTER2_LO},
	{51563, R_034A14_GDS_PERFCOUNTER2_HI},
	{51583, R_034A18_GDS_PERFCOUNTER3_LO},
	{51603, R_034A1C_GDS_PERFCOUNTER3_HI},
	{51623, R_034B00_TA_PERFCOUNTER0_LO},
	{51642, R_034B04_TA_PERFCOUNTER0_HI},
	{51661, R_034B08_TA_PERFCOUNTER1_LO},
	{51680, R_034B0C_TA_PERFCOUNTER1_HI},
	{51699, R_034C00_TD_PERFCOUNTER0_LO},
	{51718, R_034C04_TD_PERFCOUNTER0_HI},
	{51737, R_034C08_TD_PERFCOUNTER1_LO},
	{51756, R_034C0C_TD_PERFCOUNTER1_HI},
	{51775, R_034D00_TCP_PERFCOUNTER0_LO},
	{51795, R_034D04_TCP_PERFCOUNTER0_HI},
	{51815, R_034D08_TCP_PERFCOUNTER1_LO},
	{51835, R_034D0C_TCP_PERFCOUNTER1_HI},
	{51855, R_034D10_TCP_PERFCOUNTER2_LO},
	{51875, R_034D14_TCP_PERFCOUNTER2_HI},
	{51895, R_034D18_TCP_PERFCOUNTER3_LO},
	{51915, R_034D1C_TCP_PERFCOUNTER3_HI},
	{51935, R_034E00_TCC_PERFCOUNTER0_LO},
	{51955, R_034E04_TCC_PERFCOUNTER0_HI},
	{51975, R_034E08_TCC_PERFCOUNTER1_LO},
	{51995, R_034E0C_TCC_PERFCOUNTER1_HI},
	{52015, R_034E10_TCC_PERFCOUNTER2_LO},
	{52035, R_034E14_TCC_PERFCOUNTER2_HI},
	{52055, R_034E18_TCC_PERFCOUNTER3_LO},
	{52075, R_034E1C_TCC_PERFCOUNTER3_HI},
	{52095, R_034E40_TCA_PERFCOUNTER0_LO},
	{52115, R_034E44_TCA_PERFCOUNTER0_HI},
	{52135, R_034E48_TCA_PERFCOUNTER1_LO},
	{52155, R_034E4C_TCA_PERFCOUNTER1_HI},
	{52175, R_034E50_TCA_PERFCOUNTER2_LO},
	{52195, R_034E54_TCA_PERFCOUNTER2_HI},
	{52215, R_034E58_TCA_PERFCOUNTER3_LO},
	{52235, R_034E5C_TCA_PERFCOUNTER3_HI},
	{52255, R_035018_CB_PERFCOUNTER0_LO},
	{52274, R_03501C_CB_PERFCOUNTER0_HI},
	{52293, R_035020_CB_PERFCOUNTER1_LO},
	{52312, R_035024_CB_PERFCOUNTER1_HI},
	{52331, R_035028_CB_PERFCOUNTER2_LO},
	{52350, R_03502C_CB_PERFCOUNTER2_HI},
	{52369, R_035030_CB_PERFCOUNTER3_LO},
	{52388, R_035034_CB_PERFCOUNTER3_HI},
	{52407, R_035100_DB_PERFCOUNTER0_LO},
	{52426, R_035104_DB_PERFCOUNTER0_HI},
	{52445, R_035108_DB_PERFCOUNTER1_LO},
	{52464, R_03510C_DB_PERFCOUNTER1_HI},
	{52483, R_035110_DB_PERFCOUNTER2_LO},
	{52502, R_035114_DB_PERFCOUNTER2_HI},
	{52521, R_035118_DB_PERFCOUNTER3_LO},
	{52540, R_03511C_DB_PERFCOUNTER3_HI},
	{52559, R_035200_RLC_PERFCOUNTER0_LO},
	{52579, R_035204_RLC_PERFCOUNTER0_HI},
	{52599, R_035208_RLC_PERFCOUNTER1_LO},
	{52619, R_03520C_RLC_PERFCOUNTER1_HI},
	{52639, R_036000_CPG_PERFCOUNTER1_SELECT, 8, 1022},
	{52663, R_036004_CPG_PERFCOUNTER0_SELECT1, 6, 1016},
	{52688, R_036008_CPG_PERFCOUNTER0_SELECT, 8, 1022},
	{52712, R_03600C_CPC_PERFCOUNTER1_SELECT, 8, 1054},
	{52736, R_036010_CPC_PERFCOUNTER0_SELECT1, 6, 1030},
	{52761, R_036014_CPF_PERFCOUNTER1_SELECT, 8, 1042},
	{52785, R_036018_CPF_PERFCOUNTER0_SELECT1, 6, 1036},
	{52810, R_03601C_CPF_PERFCOUNTER0_SELECT, 8, 1042},
	{52834, R_036020_CP_PERFMON_CNTL, 4, 1050},
	{52850, R_036024_CPC_PERFCOUNTER0_SELECT, 8, 1054},
	{52874, R_036100_GRBM_PERFCOUNTER0_SELECT, 22, 1062},
	{52899, R_036104_GRBM_PERFCOUNTER1_SELECT, 22, 1062},
	{52924, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 13, 1084},
	{52952, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 13, 1097},
	{52980, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 13, 1110},
	{53008, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 13, 1123},
	{53036, R_036200_WD_PERFCOUNTER0_SELECT, 2, 1136},
	{53059, R_036204_WD_PERFCOUNTER1_SELECT, 2, 1136},
	{53082, R_036208_WD_PERFCOUNTER2_SELECT, 2, 1136},
	{53105, R_03620C_WD_PERFCOUNTER3_SELECT, 2, 1136},
	{53128, R_036210_IA_PERFCOUNTER0_SELECT, 5, 1138},
	{53151, R_036214_IA_PERFCOUNTER1_SELECT, 5, 1138},
	{53174, R_036218_IA_PERFCOUNTER2_SELECT, 5, 1138},
	{53197, R_03621C_IA_PERFCOUNTER3_SELECT, 5, 1138},
	{53220, R_036220_IA_PERFCOUNTER0_SELECT1, 4, 1143},
	{53244, R_036230_VGT_PERFCOUNTER0_SELECT, 5, 1147},
	{53268, R_036234_VGT_PERFCOUNTER1_SELECT, 5, 1147},
	{53292, R_036238_VGT_PERFCOUNTER2_SELECT, 5, 1147},
	{53316, R_03623C_VGT_PERFCOUNTER3_SELECT, 5, 1147},
	{53340, R_036240_VGT_PERFCOUNTER0_SELECT1, 4, 1152},
	{53365, R_036244_VGT_PERFCOUNTER1_SELECT1},
	{53390, R_036250_VGT_PERFCOUNTER_SEID_MASK, 1, 1156},
	{53416, R_036400_PA_SU_PERFCOUNTER0_SELECT, 3, 1157},
	{53442, R_036404_PA_SU_PERFCOUNTER0_SELECT1, 2, 1160},
	{53469, R_036408_PA_SU_PERFCOUNTER1_SELECT, 3, 1157},
	{53495, R_03640C_PA_SU_PERFCOUNTER1_SELECT1},
	{53522, R_036410_PA_SU_PERFCOUNTER2_SELECT, 3, 1157},
	{53548, R_036414_PA_SU_PERFCOUNTER3_SELECT, 3, 1157},
	{53574, R_036500_PA_SC_PERFCOUNTER0_SELECT, 3, 1162},
	{53600, R_036504_PA_SC_PERFCOUNTER0_SELECT1, 2, 1165},
	{53627, R_036508_PA_SC_PERFCOUNTER1_SELECT, 3, 1162},
	{53653, R_03650C_PA_SC_PERFCOUNTER2_SELECT, 3, 1162},
	{53679, R_036510_PA_SC_PERFCOUNTER3_SELECT, 3, 1162},
	{53705, R_036514_PA_SC_PERFCOUNTER4_SELECT, 3, 1162},
	{53731, R_036518_PA_SC_PERFCOUNTER5_SELECT, 3, 1162},
	{53757, R_03651C_PA_SC_PERFCOUNTER6_SELECT, 3, 1162},
	{53783, R_036520_PA_SC_PERFCOUNTER7_SELECT, 3, 1162},
	{53809, R_036600_SPI_PERFCOUNTER0_SELECT, 5, 1167},
	{53833, R_036604_SPI_PERFCOUNTER1_SELECT, 5, 1167},
	{53857, R_036608_SPI_PERFCOUNTER2_SELECT, 5, 1167},
	{53881, R_03660C_SPI_PERFCOUNTER3_SELECT, 5, 1167},
	{53905, R_036610_SPI_PERFCOUNTER0_SELECT1, 4, 1172},
	{53930, R_036614_SPI_PERFCOUNTER1_SELECT1},
	{53955, R_036618_SPI_PERFCOUNTER2_SELECT1},
	{53980, R_03661C_SPI_PERFCOUNTER3_SELECT1},
	{54005, R_036620_SPI_PERFCOUNTER4_SELECT, 5, 1167},
	{54029, R_036624_SPI_PERFCOUNTER5_SELECT, 5, 1167},
	{54053, R_036628_SPI_PERFCOUNTER_BINS, 8, 1176},
	{54074, R_036700_SQ_PERFCOUNTER0_SELECT, 6, 1184},
	{54097, R_036704_SQ_PERFCOUNTER1_SELECT, 6, 1184},
	{54120, R_036708_SQ_PERFCOUNTER2_SELECT, 6, 1184},
	{54143, R_03670C_SQ_PERFCOUNTER3_SELECT, 6, 1184},
	{54166, R_036710_SQ_PERFCOUNTER4_SELECT, 6, 1184},
	{54189, R_036714_SQ_PERFCOUNTER5_SELECT, 6, 1184},
	{54212, R_036718_SQ_PERFCOUNTER6_SELECT, 6, 1184},
	{54235, R_03671C_SQ_PERFCOUNTER7_SELECT, 6, 1184},
	{54258, R_036720_SQ_PERFCOUNTER8_SELECT, 6, 1184},
	{54281, R_036724_SQ_PERFCOUNTER9_SELECT, 6, 1184},
	{54304, R_036728_SQ_PERFCOUNTER10_SELECT, 6, 1184},
	{54328, R_03672C_SQ_PERFCOUNTER11_SELECT, 6, 1184},
	{54352, R_036730_SQ_PERFCOUNTER12_SELECT, 6, 1184},
	{54376, R_036734_SQ_PERFCOUNTER13_SELECT, 6, 1184},
	{54400, R_036738_SQ_PERFCOUNTER14_SELECT, 6, 1184},
	{54424, R_03673C_SQ_PERFCOUNTER15_SELECT, 6, 1184},
	{54448, R_036780_SQ_PERFCOUNTER_CTRL, 9, 1190},
	{54468, R_036784_SQ_PERFCOUNTER_MASK, 2, 1199},
	{54488, R_036788_SQ_PERFCOUNTER_CTRL2, 1, 1201},
	{54509, R_036900_SX_PERFCOUNTER0_SELECT, 3, 1202},
	{54532, R_036904_SX_PERFCOUNTER1_SELECT, 3, 1202},
	{54555, R_036908_SX_PERFCOUNTER2_SELECT, 3, 1202},
	{54578, R_03690C_SX_PERFCOUNTER3_SELECT, 3, 1202},
	{54601, R_036910_SX_PERFCOUNTER0_SELECT1, 2, 1205},
	{54625, R_036914_SX_PERFCOUNTER1_SELECT1},
	{54649, R_036A00_GDS_PERFCOUNTER0_SELECT, 3, 1207},
	{54673, R_036A04_GDS_PERFCOUNTER1_SELECT, 3, 1207},
	{54697, R_036A08_GDS_PERFCOUNTER2_SELECT, 3, 1207},
	{54721, R_036A0C_GDS_PERFCOUNTER3_SELECT, 3, 1207},
	{54745, R_036A10_GDS_PERFCOUNTER0_SELECT1, 2, 1210},
	{54770, R_036B00_TA_PERFCOUNTER0_SELECT, 5, 1212},
	{54793, R_036B04_TA_PERFCOUNTER0_SELECT1, 4, 1217},
	{54817, R_036B08_TA_PERFCOUNTER1_SELECT, 5, 1212},
	{54840, R_036C00_TD_PERFCOUNTER0_SELECT, 5, 1221},
	{54863, R_036C04_TD_PERFCOUNTER0_SELECT1, 4, 1226},
	{54887, R_036C08_TD_PERFCOUNTER1_SELECT, 5, 1221},
	{54910, R_036D00_TCP_PERFCOUNTER0_SELECT, 5, 1230},
	{54934, R_036D04_TCP_PERFCOUNTER0_SELECT1, 4, 1235},
	{54959, R_036D08_TCP_PERFCOUNTER1_SELECT, 5, 1230},
	{54983, R_036D0C_TCP_PERFCOUNTER1_SELECT1},
	{55008, R_036D10_TCP_PERFCOUNTER2_SELECT, 5, 1230},
	{55032, R_036D14_TCP_PERFCOUNTER3_SELECT, 5, 1230},
	{55056, R_036E00_TCC_PERFCOUNTER0_SELECT, 5, 1239},
	{55080, R_036E04_TCC_PERFCOUNTER0_SELECT1, 4, 1244},
	{55105, R_036E08_TCC_PERFCOUNTER1_SELECT, 5, 1239},
	{55129, R_036E0C_TCC_PERFCOUNTER1_SELECT1},
	{55154, R_036E10_TCC_PERFCOUNTER2_SELECT, 5, 1239},
	{55178, R_036E14_TCC_PERFCOUNTER3_SELECT, 5, 1239},
	{55202, R_036E40_TCA_PERFCOUNTER0_SELECT, 5, 1248},
	{55226, R_036E44_TCA_PERFCOUNTER0_SELECT1, 4, 1253},
	{55251, R_036E48_TCA_PERFCOUNTER1_SELECT, 5, 1248},
	{55275, R_036E4C_TCA_PERFCOUNTER1_SELECT1},
	{55300, R_036E50_TCA_PERFCOUNTER2_SELECT, 5, 1248},
	{55324, R_036E54_TCA_PERFCOUNTER3_SELECT, 5, 1248},
	{55348, R_037000_CB_PERFCOUNTER_FILTER, 12, 1257},
	{55370, R_037004_CB_PERFCOUNTER0_SELECT, 5, 1269},
	{55393, R_037008_CB_PERFCOUNTER0_SELECT1, 4, 1274},
	{55417, R_03700C_CB_PERFCOUNTER1_SELECT, 5, 1269},
	{55440, R_037010_CB_PERFCOUNTER2_SELECT, 5, 1269},
	{55463, R_037014_CB_PERFCOUNTER3_SELECT, 5, 1269},
	{55486, R_037100_DB_PERFCOUNTER0_SELECT, 5, 1278},
	{55509, R_037104_DB_PERFCOUNTER0_SELECT1, 4, 1283},
	{55533, R_037108_DB_PERFCOUNTER1_SELECT, 5, 1278},
	{55556, R_03710C_DB_PERFCOUNTER1_SELECT1},
	{55580, R_037110_DB_PERFCOUNTER2_SELECT, 5, 1278},
	{55603, R_037118_DB_PERFCOUNTER3_SELECT, 5, 1278},
	{55626, R_028000_DB_RENDER_CONTROL, 10, 1287},
	{55644, R_028004_DB_COUNT_CONTROL, 9, 1297},
	{55661, R_028008_DB_DEPTH_VIEW, 5, 1306},
	{55675, R_02800C_DB_RENDER_OVERRIDE, 23, 1311},
	{55694, R_028010_DB_RENDER_OVERRIDE2, 16, 1334},
	{55714, R_028014_DB_HTILE_DATA_BASE},
	{55733, R_028020_DB_DEPTH_BOUNDS_MIN},
	{55753, R_028024_DB_DEPTH_BOUNDS_MAX},
	{55773, R_028028_DB_STENCIL_CLEAR, 1, 1350},
	{55790, R_02802C_DB_DEPTH_CLEAR},
	{55805, R_028030_PA_SC_SCREEN_SCISSOR_TL, 2, 1351},
	{55829, R_028034_PA_SC_SCREEN_SCISSOR_BR, 2, 1353},
	{55853, R_02803C_DB_DEPTH_INFO, 7, 1355},
	{55867, R_028040_DB_Z_INFO, 10, 1362},
	{55877, R_028044_DB_STENCIL_INFO, 6, 1372},
	{55893, R_028048_DB_Z_READ_BASE},
	{55908, R_02804C_DB_STENCIL_READ_BASE},
	{55929, R_028050_DB_Z_WRITE_BASE},
	{55945, R_028054_DB_STENCIL_WRITE_BASE},
	{55967, R_028058_DB_DEPTH_SIZE, 2, 1378},
	{55981, R_02805C_DB_DEPTH_SLICE, 1, 1380},
	{55996, R_028080_TA_BC_BASE_ADDR},
	{56012, R_028084_TA_BC_BASE_ADDR_HI, 1, 1381},
	{56031, R_0281E8_COHER_DEST_BASE_HI_0, 1, 1382},
	{56052, R_0281EC_COHER_DEST_BASE_HI_1, 1, 1383},
	{56073, R_0281F0_COHER_DEST_BASE_HI_2, 1, 1384},
	{56094, R_0281F4_COHER_DEST_BASE_HI_3, 1, 1385},
	{56115, R_0281F8_COHER_DEST_BASE_2},
	{56133, R_0281FC_COHER_DEST_BASE_3},
	{56151, R_028200_PA_SC_WINDOW_OFFSET, 2, 1386},
	{56171, R_028204_PA_SC_WINDOW_SCISSOR_TL, 3, 1388},
	{56195, R_028208_PA_SC_WINDOW_SCISSOR_BR, 2, 1391},
	{56219, R_02820C_PA_SC_CLIPRECT_RULE, 1, 1393},
	{56239, R_028210_PA_SC_CLIPRECT_0_TL, 2, 1394},
	{56259, R_028214_PA_SC_CLIPRECT_0_BR, 2, 1396},
	{56279, R_028218_PA_SC_CLIPRECT_1_TL, 2, 1394},
	{56299, R_02821C_PA_SC_CLIPRECT_1_BR, 2, 1396},
	{56319, R_028220_PA_SC_CLIPRECT_2_TL, 2, 1394},
	{56339, R_028224_PA_SC_CLIPRECT_2_BR, 2, 1396},
	{56359, R_028228_PA_SC_CLIPRECT_3_TL, 2, 1394},
	{56379, R_02822C_PA_SC_CLIPRECT_3_BR, 2, 1396},
	{56399, R_028230_PA_SC_EDGERULE, 7, 1398},
	{56414, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, 2, 1405},
	{56443, R_028238_CB_TARGET_MASK, 8, 1407},
	{56458, R_02823C_CB_SHADER_MASK, 8, 1415},
	{56473, R_028240_PA_SC_GENERIC_SCISSOR_TL, 3, 1423},
	{56498, R_028244_PA_SC_GENERIC_SCISSOR_BR, 2, 1426},
	{56523, R_028248_COHER_DEST_BASE_0},
	{56541, R_02824C_COHER_DEST_BASE_1},
	{56559, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 3, 1428},
	{56584, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 2, 1431},
	{56609, R_028258_PA_SC_VPORT_SCISSOR_1_TL, 3, 1428},
	{56634, R_02825C_PA_SC_VPORT_SCISSOR_1_BR, 2, 1431},
	{56659, R_028260_PA_SC_VPORT_SCISSOR_2_TL, 3, 1428},
	{56684, R_028264_PA_SC_VPORT_SCISSOR_2_BR, 2, 1431},
	{56709, R_028268_PA_SC_VPORT_SCISSOR_3_TL, 3, 1428},
	{56734, R_02826C_PA_SC_VPORT_SCISSOR_3_BR, 2, 1431},
	{56759, R_028270_PA_SC_VPORT_SCISSOR_4_TL, 3, 1428},
	{56784, R_028274_PA_SC_VPORT_SCISSOR_4_BR, 2, 1431},
	{56809, R_028278_PA_SC_VPORT_SCISSOR_5_TL, 3, 1428},
	{56834, R_02827C_PA_SC_VPORT_SCISSOR_5_BR, 2, 1431},
	{56859, R_028280_PA_SC_VPORT_SCISSOR_6_TL, 3, 1428},
	{56884, R_028284_PA_SC_VPORT_SCISSOR_6_BR, 2, 1431},
	{56909, R_028288_PA_SC_VPORT_SCISSOR_7_TL, 3, 1428},
	{56934, R_02828C_PA_SC_VPORT_SCISSOR_7_BR, 2, 1431},
	{56959, R_028290_PA_SC_VPORT_SCISSOR_8_TL, 3, 1428},
	{56984, R_028294_PA_SC_VPORT_SCISSOR_8_BR, 2, 1431},
	{57009, R_028298_PA_SC_VPORT_SCISSOR_9_TL, 3, 1428},
	{57034, R_02829C_PA_SC_VPORT_SCISSOR_9_BR, 2, 1431},
	{57059, R_0282A0_PA_SC_VPORT_SCISSOR_10_TL, 3, 1428},
	{57085, R_0282A4_PA_SC_VPORT_SCISSOR_10_BR, 2, 1431},
	{57111, R_0282A8_PA_SC_VPORT_SCISSOR_11_TL, 3, 1428},
	{57137, R_0282AC_PA_SC_VPORT_SCISSOR_11_BR, 2, 1431},
	{57163, R_0282B0_PA_SC_VPORT_SCISSOR_12_TL, 3, 1428},
	{57189, R_0282B4_PA_SC_VPORT_SCISSOR_12_BR, 2, 1431},
	{57215, R_0282B8_PA_SC_VPORT_SCISSOR_13_TL, 3, 1428},
	{57241, R_0282BC_PA_SC_VPORT_SCISSOR_13_BR, 2, 1431},
	{57267, R_0282C0_PA_SC_VPORT_SCISSOR_14_TL, 3, 1428},
	{57293, R_0282C4_PA_SC_VPORT_SCISSOR_14_BR, 2, 1431},
	{57319, R_0282C8_PA_SC_VPORT_SCISSOR_15_TL, 3, 1428},
	{57345, R_0282CC_PA_SC_VPORT_SCISSOR_15_BR, 2, 1431},
	{57371, R_0282D0_PA_SC_VPORT_ZMIN_0},
	{57390, R_0282D4_PA_SC_VPORT_ZMAX_0},
	{57409, R_0282D8_PA_SC_VPORT_ZMIN_1},
	{57428, R_0282DC_PA_SC_VPORT_ZMAX_1},
	{57447, R_0282E0_PA_SC_VPORT_ZMIN_2},
	{57466, R_0282E4_PA_SC_VPORT_ZMAX_2},
	{57485, R_0282E8_PA_SC_VPORT_ZMIN_3},
	{57504, R_0282EC_PA_SC_VPORT_ZMAX_3},
	{57523, R_0282F0_PA_SC_VPORT_ZMIN_4},
	{57542, R_0282F4_PA_SC_VPORT_ZMAX_4},
	{57561, R_0282F8_PA_SC_VPORT_ZMIN_5},
	{57580, R_0282FC_PA_SC_VPORT_ZMAX_5},
	{57599, R_028300_PA_SC_VPORT_ZMIN_6},
	{57618, R_028304_PA_SC_VPORT_ZMAX_6},
	{57637, R_028308_PA_SC_VPORT_ZMIN_7},
	{57656, R_02830C_PA_SC_VPORT_ZMAX_7},
	{57675, R_028310_PA_SC_VPORT_ZMIN_8},
	{57694, R_028314_PA_SC_VPORT_ZMAX_8},
	{57713, R_028318_PA_SC_VPORT_ZMIN_9},
	{57732, R_02831C_PA_SC_VPORT_ZMAX_9},
	{57751, R_028320_PA_SC_VPORT_ZMIN_10},
	{57771, R_028324_PA_SC_VPORT_ZMAX_10},
	{57791, R_028328_PA_SC_VPORT_ZMIN_11},
	{57811, R_02832C_PA_SC_VPORT_ZMAX_11},
	{57831, R_028330_PA_SC_VPORT_ZMIN_12},
	{57851, R_028334_PA_SC_VPORT_ZMAX_12},
	{57871, R_028338_PA_SC_VPORT_ZMIN_13},
	{57891, R_02833C_PA_SC_VPORT_ZMAX_13},
	{57911, R_028340_PA_SC_VPORT_ZMIN_14},
	{57931, R_028344_PA_SC_VPORT_ZMAX_14},
	{57951, R_028348_PA_SC_VPORT_ZMIN_15},
	{57971, R_02834C_PA_SC_VPORT_ZMAX_15},
	{57991, R_028350_PA_SC_RASTER_CONFIG, 17, 1433},
	{58011, R_028354_PA_SC_RASTER_CONFIG_1, 5, 1450},
	{58033, R_028358_PA_SC_SCREEN_EXTENT_CONTROL, 2, 1455},
	{58061, R_028400_VGT_MAX_VTX_INDX},
	{58078, R_028404_VGT_MIN_VTX_INDX},
	{58095, R_028408_VGT_INDX_OFFSET},
	{58111, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{58140, R_028414_CB_BLEND_RED},
	{58153, R_028418_CB_BLEND_GREEN},
	{58168, R_02841C_CB_BLEND_BLUE},
	{58182, R_028420_CB_BLEND_ALPHA},
	{58197, R_028424_CB_DCC_CONTROL, 3, 1457},
	{58212, R_02842C_DB_STENCIL_CONTROL, 6, 1460},
	{58231, R_028430_DB_STENCILREFMASK, 4, 1466},
	{58249, R_028434_DB_STENCILREFMASK_BF, 4, 1470},
	{58270, R_02843C_PA_CL_VPORT_XSCALE},
	{58289, R_028440_PA_CL_VPORT_XOFFSET},
	{58309, R_028444_PA_CL_VPORT_YSCALE},
	{58328, R_028448_PA_CL_VPORT_YOFFSET},
	{58348, R_02844C_PA_CL_VPORT_ZSCALE},
	{58367, R_028450_PA_CL_VPORT_ZOFFSET},
	{58387, R_028454_PA_CL_VPORT_XSCALE_1},
	{58408, R_028458_PA_CL_VPORT_XOFFSET_1},
	{58430, R_02845C_PA_CL_VPORT_YSCALE_1},
	{58451, R_028460_PA_CL_VPORT_YOFFSET_1},
	{58473, R_028464_PA_CL_VPORT_ZSCALE_1},
	{58494, R_028468_PA_CL_VPORT_ZOFFSET_1},
	{58516, R_02846C_PA_CL_VPORT_XSCALE_2},
	{58537, R_028470_PA_CL_VPORT_XOFFSET_2},
	{58559, R_028474_PA_CL_VPORT_YSCALE_2},
	{58580, R_028478_PA_CL_VPORT_YOFFSET_2},
	{58602, R_02847C_PA_CL_VPORT_ZSCALE_2},
	{58623, R_028480_PA_CL_VPORT_ZOFFSET_2},
	{58645, R_028484_PA_CL_VPORT_XSCALE_3},
	{58666, R_028488_PA_CL_VPORT_XOFFSET_3},
	{58688, R_02848C_PA_CL_VPORT_YSCALE_3},
	{58709, R_028490_PA_CL_VPORT_YOFFSET_3},
	{58731, R_028494_PA_CL_VPORT_ZSCALE_3},
	{58752, R_028498_PA_CL_VPORT_ZOFFSET_3},
	{58774, R_02849C_PA_CL_VPORT_XSCALE_4},
	{58795, R_0284A0_PA_CL_VPORT_XOFFSET_4},
	{58817, R_0284A4_PA_CL_VPORT_YSCALE_4},
	{58838, R_0284A8_PA_CL_VPORT_YOFFSET_4},
	{58860, R_0284AC_PA_CL_VPORT_ZSCALE_4},
	{58881, R_0284B0_PA_CL_VPORT_ZOFFSET_4},
	{58903, R_0284B4_PA_CL_VPORT_XSCALE_5},
	{58924, R_0284B8_PA_CL_VPORT_XOFFSET_5},
	{58946, R_0284BC_PA_CL_VPORT_YSCALE_5},
	{58967, R_0284C0_PA_CL_VPORT_YOFFSET_5},
	{58989, R_0284C4_PA_CL_VPORT_ZSCALE_5},
	{59010, R_0284C8_PA_CL_VPORT_ZOFFSET_5},
	{59032, R_0284CC_PA_CL_VPORT_XSCALE_6},
	{59053, R_0284D0_PA_CL_VPORT_XOFFSET_6},
	{59075, R_0284D4_PA_CL_VPORT_YSCALE_6},
	{59096, R_0284D8_PA_CL_VPORT_YOFFSET_6},
	{59118, R_0284DC_PA_CL_VPORT_ZSCALE_6},
	{59139, R_0284E0_PA_CL_VPORT_ZOFFSET_6},
	{59161, R_0284E4_PA_CL_VPORT_XSCALE_7},
	{59182, R_0284E8_PA_CL_VPORT_XOFFSET_7},
	{59204, R_0284EC_PA_CL_VPORT_YSCALE_7},
	{59225, R_0284F0_PA_CL_VPORT_YOFFSET_7},
	{59247, R_0284F4_PA_CL_VPORT_ZSCALE_7},
	{59268, R_0284F8_PA_CL_VPORT_ZOFFSET_7},
	{59290, R_0284FC_PA_CL_VPORT_XSCALE_8},
	{59311, R_028500_PA_CL_VPORT_XOFFSET_8},
	{59333, R_028504_PA_CL_VPORT_YSCALE_8},
	{59354, R_028508_PA_CL_VPORT_YOFFSET_8},
	{59376, R_02850C_PA_CL_VPORT_ZSCALE_8},
	{59397, R_028510_PA_CL_VPORT_ZOFFSET_8},
	{59419, R_028514_PA_CL_VPORT_XSCALE_9},
	{59440, R_028518_PA_CL_VPORT_XOFFSET_9},
	{59462, R_02851C_PA_CL_VPORT_YSCALE_9},
	{59483, R_028520_PA_CL_VPORT_YOFFSET_9},
	{59505, R_028524_PA_CL_VPORT_ZSCALE_9},
	{59526, R_028528_PA_CL_VPORT_ZOFFSET_9},
	{59548, R_02852C_PA_CL_VPORT_XSCALE_10},
	{59570, R_028530_PA_CL_VPORT_XOFFSET_10},
	{59593, R_028534_PA_CL_VPORT_YSCALE_10},
	{59615, R_028538_PA_CL_VPORT_YOFFSET_10},
	{59638, R_02853C_PA_CL_VPORT_ZSCALE_10},
	{59660, R_028540_PA_CL_VPORT_ZOFFSET_10},
	{59683, R_028544_PA_CL_VPORT_XSCALE_11},
	{59705, R_028548_PA_CL_VPORT_XOFFSET_11},
	{59728, R_02854C_PA_CL_VPORT_YSCALE_11},
	{59750, R_028550_PA_CL_VPORT_YOFFSET_11},
	{59773, R_028554_PA_CL_VPORT_ZSCALE_11},
	{59795, R_028558_PA_CL_VPORT_ZOFFSET_11},
	{59818, R_02855C_PA_CL_VPORT_XSCALE_12},
	{59840, R_028560_PA_CL_VPORT_XOFFSET_12},
	{59863, R_028564_PA_CL_VPORT_YSCALE_12},
	{59885, R_028568_PA_CL_VPORT_YOFFSET_12},
	{59908, R_02856C_PA_CL_VPORT_ZSCALE_12},
	{59930, R_028570_PA_CL_VPORT_ZOFFSET_12},
	{59953, R_028574_PA_CL_VPORT_XSCALE_13},
	{59975, R_028578_PA_CL_VPORT_XOFFSET_13},
	{59998, R_02857C_PA_CL_VPORT_YSCALE_13},
	{60020, R_028580_PA_CL_VPORT_YOFFSET_13},
	{60043, R_028584_PA_CL_VPORT_ZSCALE_13},
	{60065, R_028588_PA_CL_VPORT_ZOFFSET_13},
	{60088, R_02858C_PA_CL_VPORT_XSCALE_14},
	{60110, R_028590_PA_CL_VPORT_XOFFSET_14},
	{60133, R_028594_PA_CL_VPORT_YSCALE_14},
	{60155, R_028598_PA_CL_VPORT_YOFFSET_14},
	{60178, R_02859C_PA_CL_VPORT_ZSCALE_14},
	{60200, R_0285A0_PA_CL_VPORT_ZOFFSET_14},
	{60223, R_0285A4_PA_CL_VPORT_XSCALE_15},
	{60245, R_0285A8_PA_CL_VPORT_XOFFSET_15},
	{60268, R_0285AC_PA_CL_VPORT_YSCALE_15},
	{60290, R_0285B0_PA_CL_VPORT_YOFFSET_15},
	{60313, R_0285B4_PA_CL_VPORT_ZSCALE_15},
	{60335, R_0285B8_PA_CL_VPORT_ZOFFSET_15},
	{60358, R_0285BC_PA_CL_UCP_0_X},
	{60372, R_0285C0_PA_CL_UCP_0_Y},
	{60386, R_0285C4_PA_CL_UCP_0_Z},
	{60400, R_0285C8_PA_CL_UCP_0_W},
	{60414, R_0285CC_PA_CL_UCP_1_X},
	{60428, R_0285D0_PA_CL_UCP_1_Y},
	{60442, R_0285D4_PA_CL_UCP_1_Z},
	{60456, R_0285D8_PA_CL_UCP_1_W},
	{60470, R_0285DC_PA_CL_UCP_2_X},
	{60484, R_0285E0_PA_CL_UCP_2_Y},
	{60498, R_0285E4_PA_CL_UCP_2_Z},
	{60512, R_0285E8_PA_CL_UCP_2_W},
	{60526, R_0285EC_PA_CL_UCP_3_X},
	{60540, R_0285F0_PA_CL_UCP_3_Y},
	{60554, R_0285F4_PA_CL_UCP_3_Z},
	{60568, R_0285F8_PA_CL_UCP_3_W},
	{60582, R_0285FC_PA_CL_UCP_4_X},
	{60596, R_028600_PA_CL_UCP_4_Y},
	{60610, R_028604_PA_CL_UCP_4_Z},
	{60624, R_028608_PA_CL_UCP_4_W},
	{60638, R_02860C_PA_CL_UCP_5_X},
	{60652, R_028610_PA_CL_UCP_5_Y},
	{60666, R_028614_PA_CL_UCP_5_Z},
	{60680, R_028618_PA_CL_UCP_5_W},
	{60694, R_028644_SPI_PS_INPUT_CNTL_0, 12, 1474},
	{60714, R_028648_SPI_PS_INPUT_CNTL_1, 12, 1474},
	{60734, R_02864C_SPI_PS_INPUT_CNTL_2, 12, 1474},
	{60754, R_028650_SPI_PS_INPUT_CNTL_3, 12, 1474},
	{60774, R_028654_SPI_PS_INPUT_CNTL_4, 12, 1474},
	{60794, R_028658_SPI_PS_INPUT_CNTL_5, 12, 1474},
	{60814, R_02865C_SPI_PS_INPUT_CNTL_6, 12, 1474},
	{60834, R_028660_SPI_PS_INPUT_CNTL_7, 12, 1474},
	{60854, R_028664_SPI_PS_INPUT_CNTL_8, 12, 1474},
	{60874, R_028668_SPI_PS_INPUT_CNTL_9, 12, 1474},
	{60894, R_02866C_SPI_PS_INPUT_CNTL_10, 12, 1474},
	{60915, R_028670_SPI_PS_INPUT_CNTL_11, 12, 1474},
	{60936, R_028674_SPI_PS_INPUT_CNTL_12, 12, 1474},
	{60957, R_028678_SPI_PS_INPUT_CNTL_13, 12, 1474},
	{60978, R_02867C_SPI_PS_INPUT_CNTL_14, 12, 1474},
	{60999, R_028680_SPI_PS_INPUT_CNTL_15, 12, 1474},
	{61020, R_028684_SPI_PS_INPUT_CNTL_16, 12, 1474},
	{61041, R_028688_SPI_PS_INPUT_CNTL_17, 12, 1474},
	{61062, R_02868C_SPI_PS_INPUT_CNTL_18, 12, 1474},
	{61083, R_028690_SPI_PS_INPUT_CNTL_19, 12, 1474},
	{61104, R_028694_SPI_PS_INPUT_CNTL_20, 12, 1474},
	{61125, R_028698_SPI_PS_INPUT_CNTL_21, 12, 1474},
	{61146, R_02869C_SPI_PS_INPUT_CNTL_22, 12, 1474},
	{61167, R_0286A0_SPI_PS_INPUT_CNTL_23, 12, 1474},
	{61188, R_0286A4_SPI_PS_INPUT_CNTL_24, 12, 1474},
	{61209, R_0286A8_SPI_PS_INPUT_CNTL_25, 12, 1474},
	{61230, R_0286AC_SPI_PS_INPUT_CNTL_26, 12, 1474},
	{61251, R_0286B0_SPI_PS_INPUT_CNTL_27, 12, 1474},
	{61272, R_0286B4_SPI_PS_INPUT_CNTL_28, 12, 1474},
	{61293, R_0286B8_SPI_PS_INPUT_CNTL_29, 12, 1474},
	{61314, R_0286BC_SPI_PS_INPUT_CNTL_30, 12, 1474},
	{61335, R_0286C0_SPI_PS_INPUT_CNTL_31, 12, 1474},
	{61356, R_0286C4_SPI_VS_OUT_CONFIG, 4, 1486},
	{61374, R_0286CC_SPI_PS_INPUT_ENA, 16, 1490},
	{61391, R_0286D0_SPI_PS_INPUT_ADDR, 16, 1506},
	{61409, R_0286D4_SPI_INTERP_CONTROL_0, 7, 1522},
	{61430, R_0286D8_SPI_PS_IN_CONTROL, 7, 1529},
	{61448, R_0286E0_SPI_BARYC_CNTL, 7, 1536},
	{61463, R_0286E8_SPI_TMPRING_SIZE, 2, 1543},
	{61480, R_028704_SPI_WAVE_MGMT_1, 5, 1545},
	{61496, R_028708_SPI_WAVE_MGMT_2, 1, 1550},
	{61512, R_02870C_SPI_SHADER_POS_FORMAT, 4, 1551},
	{61534, R_028710_SPI_SHADER_Z_FORMAT, 1, 1555},
	{61554, R_028714_SPI_SHADER_COL_FORMAT, 8, 1556},
	{61576, R_028754_SX_PS_DOWNCONVERT, 8, 1564},
	{61594, R_028758_SX_BLEND_OPT_EPSILON, 8, 1572},
	{61615, R_02875C_SX_BLEND_OPT_CONTROL, 17, 1580},
	{61636, R_028760_SX_MRT0_BLEND_OPT, 6, 1597},
	{61654, R_028764_SX_MRT1_BLEND_OPT, 6, 1603},
	{61672, R_028768_SX_MRT2_BLEND_OPT, 6, 1609},
	{61690, R_02876C_SX_MRT3_BLEND_OPT, 6, 1615},
	{61708, R_028770_SX_MRT4_BLEND_OPT, 6, 1621},
	{61726, R_028774_SX_MRT5_BLEND_OPT, 6, 1627},
	{61744, R_028778_SX_MRT6_BLEND_OPT, 6, 1633},
	{61762, R_02877C_SX_MRT7_BLEND_OPT, 6, 1639},
	{61780, R_028780_CB_BLEND0_CONTROL, 9, 1645},
	{61798, R_028784_CB_BLEND1_CONTROL, 9, 1645},
	{61816, R_028788_CB_BLEND2_CONTROL, 9, 1645},
	{61834, R_02878C_CB_BLEND3_CONTROL, 9, 1645},
	{61852, R_028790_CB_BLEND4_CONTROL, 9, 1645},
	{61870, R_028794_CB_BLEND5_CONTROL, 9, 1645},
	{61888, R_028798_CB_BLEND6_CONTROL, 9, 1645},
	{61906, R_02879C_CB_BLEND7_CONTROL, 9, 1645},
	{61924, R_0287CC_CS_COPY_STATE, 1, 1654},
	{61938, R_0287D4_PA_CL_POINT_X_RAD},
	{61956, R_0287D8_PA_CL_POINT_Y_RAD},
	{61974, R_0287DC_PA_CL_POINT_SIZE},
	{61991, R_0287E0_PA_CL_POINT_CULL_RAD},
	{62012, R_0287E4_VGT_DMA_BASE_HI, 2, 1655},
	{62028, R_0287E8_VGT_DMA_BASE},
	{62041, R_0287F0_VGT_DRAW_INITIATOR, 8, 1657},
	{62060, R_0287F4_VGT_IMMED_DATA},
	{62075, R_0287F8_VGT_EVENT_ADDRESS_REG, 1, 1665},
	{62097, R_028800_DB_DEPTH_CONTROL, 10, 1666},
	{62114, R_028804_DB_EQAA, 12, 1676},
	{62122, R_028808_CB_COLOR_CONTROL, 4, 1688},
	{62139, R_02880C_DB_SHADER_CONTROL, 16, 1692},
	{62157, R_028810_PA_CL_CLIP_CNTL, 19, 1708},
	{62173, R_028814_PA_SU_SC_MODE_CNTL, 15, 1727},
	{62192, R_028818_PA_CL_VTE_CNTL, 10, 1742},
	{62207, R_02881C_PA_CL_VS_OUT_CNTL, 28, 1752},
	{62225, R_028820_PA_CL_NANINF_CNTL, 16, 1780},
	{62243, R_028824_PA_SU_LINE_STIPPLE_CNTL, 4, 1796},
	{62267, R_028828_PA_SU_LINE_STIPPLE_SCALE},
	{62292, R_02882C_PA_SU_PRIM_FILTER_CNTL, 11, 1800},
	{62315, R_028830_PA_SU_SMALL_PRIM_FILTER_CNTL, 6, 1811},
	{62344, R_028A00_PA_SU_POINT_SIZE, 2, 1817},
	{62361, R_028A04_PA_SU_POINT_MINMAX, 2, 1819},
	{62380, R_028A08_PA_SU_LINE_CNTL, 1, 1821},
	{62396, R_028A0C_PA_SC_LINE_STIPPLE, 4, 1822},
	{62415, R_028A10_VGT_OUTPUT_PATH_CNTL, 1, 1826},
	{62436, R_028A14_VGT_HOS_CNTL, 1, 1827},
	{62449, R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{62472, R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{62495, R_028A20_VGT_HOS_REUSE_DEPTH, 1, 1828},
	{62515, R_028A24_VGT_GROUP_PRIM_TYPE, 4, 1829},
	{62535, R_028A28_VGT_GROUP_FIRST_DECR, 1, 1833},
	{62556, R_028A2C_VGT_GROUP_DECR, 1, 1834},
	{62571, R_028A30_VGT_GROUP_VECT_0_CNTL, 6, 1835},
	{62593, R_028A34_VGT_GROUP_VECT_1_CNTL, 6, 1841},
	{62615, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, 8, 1847},
	{62641, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, 8, 1855},
	{62667, R_028A40_VGT_GS_MODE, 18, 1863},
	{62679, R_028A44_VGT_GS_ONCHIP_CNTL, 3, 1881},
	{62698, R_028A48_PA_SC_MODE_CNTL_0, 7, 1884},
	{62716, R_028A4C_PA_SC_MODE_CNTL_1, 24, 1891},
	{62734, R_028A50_VGT_ENHANCE},
	{62746, R_028A54_VGT_GS_PER_ES, 1, 1915},
	{62760, R_028A58_VGT_ES_PER_GS, 1, 1916},
	{62774, R_028A5C_VGT_GS_PER_VS, 1, 1917},
	{62788, R_028A60_VGT_GSVS_RING_OFFSET_1, 1, 1918},
	{62811, R_028A64_VGT_GSVS_RING_OFFSET_2, 1, 1919},
	{62834, R_028A68_VGT_GSVS_RING_OFFSET_3, 1, 1920},
	{62857, R_028A6C_VGT_GS_OUT_PRIM_TYPE, 5, 1921},
	{62878, R_028A70_IA_ENHANCE},
	{62889, R_028A74_VGT_DMA_SIZE},
	{62902, R_028A78_VGT_DMA_MAX_SIZE},
	{62919, R_028A7C_VGT_DMA_INDEX_TYPE, 10, 1926},
	{62938, R_028A80_WD_ENHANCE},
	{62949, R_028A84_VGT_PRIMITIVEID_EN, 3, 1936},
	{62968, R_028A88_VGT_DMA_NUM_INSTANCES},
	{62990, R_028A8C_VGT_PRIMITIVEID_RESET},
	{63012, R_028A90_VGT_EVENT_INITIATOR, 4, 1939},
	{63032, R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, 1, 1943},
	{63059, R_028AA0_VGT_INSTANCE_STEP_RATE_0},
	{63084, R_028AA4_VGT_INSTANCE_STEP_RATE_1},
	{63109, R_028AA8_IA_MULTI_VGT_PARAM, 7, 1944},
	{63128, R_028AAC_VGT_ESGS_RING_ITEMSIZE, 1, 1951},
	{63151, R_028AB0_VGT_GSVS_RING_ITEMSIZE, 1, 1952},
	{63174, R_028AB4_VGT_REUSE_OFF, 1, 1953},
	{63188, R_028AB8_VGT_VTX_CNT_EN, 1, 1954},
	{63203, R_028ABC_DB_HTILE_SURFACE, 10, 1955},
	{63220, R_028AC0_DB_SRESULTS_COMPARE_STATE0, 4, 1965},
	{63247, R_028AC4_DB_SRESULTS_COMPARE_STATE1, 4, 1969},
	{63274, R_028AC8_DB_PRELOAD_CONTROL, 4, 1973},
	{63293, R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{63319, R_028AD4_VGT_STRMOUT_VTX_STRIDE_0, 1, 1977},
	{63344, R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{63372, R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{63398, R_028AE4_VGT_STRMOUT_VTX_STRIDE_1, 1, 1978},
	{63423, R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{63451, R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{63477, R_028AF4_VGT_STRMOUT_VTX_STRIDE_2, 1, 1979},
	{63502, R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{63530, R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{63556, R_028B04_VGT_STRMOUT_VTX_STRIDE_3, 1, 1980},
	{63581, R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{63609, R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{63640, R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{63683, R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE, 1, 1981},
	{63721, R_028B38_VGT_GS_MAX_VERT_OUT, 1, 1982},
	{63741, R_028B50_VGT_TESS_DISTRIBUTION, 5, 1983},
	{63763, R_028B54_VGT_SHADER_STAGES_EN, 14, 1988},
	{63784, R_028B58_VGT_LS_HS_CONFIG, 3, 2002},
	{63801, R_028B5C_VGT_GS_VERT_ITEMSIZE, 1, 2005},
	{63822, R_028B60_VGT_GS_VERT_ITEMSIZE_1, 1, 2006},
	{63845, R_028B64_VGT_GS_VERT_ITEMSIZE_2, 1, 2007},
	{63868, R_028B68_VGT_GS_VERT_ITEMSIZE_3, 1, 2008},
	{63891, R_028B6C_VGT_TF_PARAM, 11, 2009},
	{63904, R_028B70_DB_ALPHA_TO_MASK, 6, 2020},
	{63921, R_028B74_VGT_DISPATCH_DRAW_INDEX},
	{63945, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 2, 2026},
	{63975, R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{63999, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE},
	{64029, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET},
	{64060, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE},
	{64089, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET},
	{64119, R_028B90_VGT_GS_INSTANCE_CNT, 2, 2028},
	{64139, R_028B94_VGT_STRMOUT_CONFIG, 8, 2030},
	{64158, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 4, 2038},
	{64184, R_028BD4_PA_SC_CENTROID_PRIORITY_0, 8, 2042},
	{64210, R_028BD8_PA_SC_CENTROID_PRIORITY_1, 8, 2050},
	{64236, R_028BDC_PA_SC_LINE_CNTL, 4, 2058},
	{64252, R_028BE0_PA_SC_AA_CONFIG, 6, 2062},
	{64268, R_028BE4_PA_SU_VTX_CNTL, 3, 2068},
	{64283, R_028BE8_PA_CL_GB_VERT_CLIP_ADJ},
	{64306, R_028BEC_PA_CL_GB_VERT_DISC_ADJ},
	{64329, R_028BF0_PA_CL_GB_HORZ_CLIP_ADJ},
	{64352, R_028BF4_PA_CL_GB_HORZ_DISC_ADJ},
	{64375, R_028BF8_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0, 8, 2071},
	{64409, R_028BFC_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1, 8, 2079},
	{64443, R_028C00_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2, 8, 2087},
	{64477, R_028C04_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3, 8, 2095},
	{64511, R_028C08_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0, 8, 2103},
	{64545, R_028C0C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1, 8, 2111},
	{64579, R_028C10_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2, 8, 2119},
	{64613, R_028C14_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3, 8, 2127},
	{64647, R_028C18_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0, 8, 2135},
	{64681, R_028C1C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1, 8, 2143},
	{64715, R_028C20_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2, 8, 2151},
	{64749, R_028C24_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3, 8, 2159},
	{64783, R_028C28_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0, 8, 2167},
	{64817, R_028C2C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1, 8, 2175},
	{64851, R_028C30_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2, 8, 2183},
	{64885, R_028C34_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3, 8, 2191},
	{64919, R_028C38_PA_SC_AA_MASK_X0Y0_X1Y0, 2, 2199},
	{64943, R_028C3C_PA_SC_AA_MASK_X0Y1_X1Y1, 2, 2201},
	{64967, R_028C40_PA_SC_SHADER_CONTROL, 3, 2203},
	{64988, R_028C58_VGT_VERTEX_REUSE_BLOCK_CNTL, 1, 2206},
	{65016, R_028C5C_VGT_OUT_DEALLOC_CNTL, 1, 2207},
	{65037, R_028C60_CB_COLOR0_BASE},
	{65052, R_028C64_CB_COLOR0_PITCH, 2, 2208},
	{65068, R_028C68_CB_COLOR0_SLICE, 1, 2210},
	{65084, R_028C6C_CB_COLOR0_VIEW, 3, 2211},
	{65099, R_028C70_CB_COLOR0_INFO, 18, 2214},
	{65114, R_028C74_CB_COLOR0_ATTRIB, 13, 2232},
	{65131, R_028C78_CB_COLOR0_DCC_CONTROL, 9, 2245},
	{65153, R_028C7C_CB_COLOR0_CMASK},
	{65169, R_028C80_CB_COLOR0_CMASK_SLICE, 1, 2254},
	{65191, R_028C84_CB_COLOR0_FMASK},
	{65207, R_028C88_CB_COLOR0_FMASK_SLICE, 1, 2255},
	{65229, R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{65251, R_028C90_CB_COLOR0_CLEAR_WORD1},
	{65273, R_028C94_CB_COLOR0_DCC_BASE},
	{65292, R_028C9C_CB_COLOR1_BASE},
	{65307, R_028CA0_CB_COLOR1_PITCH, 2, 2208},
	{65323, R_028CA4_CB_COLOR1_SLICE, 1, 2210},
	{65339, R_028CA8_CB_COLOR1_VIEW, 3, 2211},
	{65354, R_028CAC_CB_COLOR1_INFO, 18, 2214},
	{65369, R_028CB0_CB_COLOR1_ATTRIB, 13, 2232},
	{65386, R_028CB4_CB_COLOR1_DCC_CONTROL, 9, 2245},
	{65408, R_028CB8_CB_COLOR1_CMASK},
	{65424, R_028CBC_CB_COLOR1_CMASK_SLICE, 1, 2254},
	{65446, R_028CC0_CB_COLOR1_FMASK},
	{65462, R_028CC4_CB_COLOR1_FMASK_SLICE, 1, 2255},
	{65484, R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{65506, R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{65528, R_028CD0_CB_COLOR1_DCC_BASE},
	{65547, R_028CD8_CB_COLOR2_BASE},
	{65562, R_028CDC_CB_COLOR2_PITCH, 2, 2208},
	{65578, R_028CE0_CB_COLOR2_SLICE, 1, 2210},
	{65594, R_028CE4_CB_COLOR2_VIEW, 3, 2211},
	{65609, R_028CE8_CB_COLOR2_INFO, 18, 2214},
	{65624, R_028CEC_CB_COLOR2_ATTRIB, 13, 2232},
	{65641, R_028CF0_CB_COLOR2_DCC_CONTROL, 9, 2245},
	{65663, R_028CF4_CB_COLOR2_CMASK},
	{65679, R_028CF8_CB_COLOR2_CMASK_SLICE, 1, 2254},
	{65701, R_028CFC_CB_COLOR2_FMASK},
	{65717, R_028D00_CB_COLOR2_FMASK_SLICE, 1, 2255},
	{65739, R_028D04_CB_COLOR2_CLEAR_WORD0},
	{65761, R_028D08_CB_COLOR2_CLEAR_WORD1},
	{65783, R_028D0C_CB_COLOR2_DCC_BASE},
	{65802, R_028D14_CB_COLOR3_BASE},
	{65817, R_028D18_CB_COLOR3_PITCH, 2, 2208},
	{65833, R_028D1C_CB_COLOR3_SLICE, 1, 2210},
	{65849, R_028D20_CB_COLOR3_VIEW, 3, 2211},
	{65864, R_028D24_CB_COLOR3_INFO, 18, 2214},
	{65879, R_028D28_CB_COLOR3_ATTRIB, 13, 2232},
	{65896, R_028D2C_CB_COLOR3_DCC_CONTROL, 9, 2245},
	{65918, R_028D30_CB_COLOR3_CMASK},
	{65934, R_028D34_CB_COLOR3_CMASK_SLICE, 1, 2254},
	{65956, R_028D38_CB_COLOR3_FMASK},
	{65972, R_028D3C_CB_COLOR3_FMASK_SLICE, 1, 2255},
	{65994, R_028D40_CB_COLOR3_CLEAR_WORD0},
	{66016, R_028D44_CB_COLOR3_CLEAR_WORD1},
	{66038, R_028D48_CB_COLOR3_DCC_BASE},
	{66057, R_028D50_CB_COLOR4_BASE},
	{66072, R_028D54_CB_COLOR4_PITCH, 2, 2208},
	{66088, R_028D58_CB_COLOR4_SLICE, 1, 2210},
	{66104, R_028D5C_CB_COLOR4_VIEW, 3, 2211},
	{66119, R_028D60_CB_COLOR4_INFO, 18, 2214},
	{66134, R_028D64_CB_COLOR4_ATTRIB, 13, 2232},
	{66151, R_028D68_CB_COLOR4_DCC_CONTROL, 9, 2245},
	{66173, R_028D6C_CB_COLOR4_CMASK},
	{66189, R_028D70_CB_COLOR4_CMASK_SLICE, 1, 2254},
	{66211, R_028D74_CB_COLOR4_FMASK},
	{66227, R_028D78_CB_COLOR4_FMASK_SLICE, 1, 2255},
	{66249, R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{66271, R_028D80_CB_COLOR4_CLEAR_WORD1},
	{66293, R_028D84_CB_COLOR4_DCC_BASE},
	{66312, R_028D8C_CB_COLOR5_BASE},
	{66327, R_028D90_CB_COLOR5_PITCH, 2, 2208},
	{66343, R_028D94_CB_COLOR5_SLICE, 1, 2210},
	{66359, R_028D98_CB_COLOR5_VIEW, 3, 2211},
	{66374, R_028D9C_CB_COLOR5_INFO, 18, 2214},
	{66389, R_028DA0_CB_COLOR5_ATTRIB, 13, 2232},
	{66406, R_028DA4_CB_COLOR5_DCC_CONTROL, 9, 2245},
	{66428, R_028DA8_CB_COLOR5_CMASK},
	{66444, R_028DAC_CB_COLOR5_CMASK_SLICE, 1, 2254},
	{66466, R_028DB0_CB_COLOR5_FMASK},
	{66482, R_028DB4_CB_COLOR5_FMASK_SLICE, 1, 2255},
	{66504, R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{66526, R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{66548, R_028DC0_CB_COLOR5_DCC_BASE},
	{66567, R_028DC8_CB_COLOR6_BASE},
	{66582, R_028DCC_CB_COLOR6_PITCH, 2, 2208},
	{66598, R_028DD0_CB_COLOR6_SLICE, 1, 2210},
	{66614, R_028DD4_CB_COLOR6_VIEW, 3, 2211},
	{66629, R_028DD8_CB_COLOR6_INFO, 18, 2214},
	{66644, R_028DDC_CB_COLOR6_ATTRIB, 13, 2232},
	{66661, R_028DE0_CB_COLOR6_DCC_CONTROL, 9, 2245},
	{66683, R_028DE4_CB_COLOR6_CMASK},
	{66699, R_028DE8_CB_COLOR6_CMASK_SLICE, 1, 2254},
	{66721, R_028DEC_CB_COLOR6_FMASK},
	{66737, R_028DF0_CB_COLOR6_FMASK_SLICE, 1, 2255},
	{66759, R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{66781, R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{66803, R_028DFC_CB_COLOR6_DCC_BASE},
	{66822, R_028E04_CB_COLOR7_BASE},
	{66837, R_028E08_CB_COLOR7_PITCH, 2, 2208},
	{66853, R_028E0C_CB_COLOR7_SLICE, 1, 2210},
	{66869, R_028E10_CB_COLOR7_VIEW, 3, 2211},
	{66884, R_028E14_CB_COLOR7_INFO, 18, 2214},
	{66899, R_028E18_CB_COLOR7_ATTRIB, 13, 2232},
	{66916, R_028E1C_CB_COLOR7_DCC_CONTROL, 9, 2245},
	{66938, R_028E20_CB_COLOR7_CMASK},
	{66954, R_028E24_CB_COLOR7_CMASK_SLICE, 1, 2254},
	{66976, R_028E28_CB_COLOR7_FMASK},
	{66992, R_028E2C_CB_COLOR7_FMASK_SLICE, 1, 2255},
	{67014, R_028E30_CB_COLOR7_CLEAR_WORD0},
	{67036, R_028E34_CB_COLOR7_CLEAR_WORD1},
	{67058, R_028E38_CB_COLOR7_DCC_BASE},
	{58061, R_030920_VGT_MAX_VTX_INDX},
	{58078, R_030924_VGT_MIN_VTX_INDX},
	{58095, R_030928_VGT_INDX_OFFSET},
	{63032, R_03092C_VGT_MULTI_PRIM_IB_RESET_EN, 2, 2256},
	{67077, R_030944_VGT_TF_MEMORY_BASE_HI, 1, 2258},
	{67099, R_030948_WD_POS_BUF_BASE},
	{67115, R_03094C_WD_POS_BUF_BASE_HI, 1, 2259},
	{67134, R_030950_WD_CNTL_SB_BUF_BASE},
	{67154, R_030954_WD_CNTL_SB_BUF_BASE_HI, 1, 2260},
	{67177, R_030958_WD_INDEX_BUF_BASE},
	{67195, R_03095C_WD_INDEX_BUF_BASE_HI, 1, 2261},
	{63109, R_030960_IA_MULTI_VGT_PARAM, 9, 2262},
	{67216, R_030964_VGT_OBJECT_ID},
	{67230, R_030968_VGT_INSTANCE_BASE_ID},
	{67251, R_030D24_SQC_WRITEBACK, 2, 2271},
	{67265, R_030E08_TA_GRAD_ADJ_UCONFIG, 4, 2273},
	{43195, R_031100_SPI_CONFIG_CNTL, 9, 2277},
	{43211, R_031104_SPI_CONFIG_CNTL_1, 11, 2286},
	{67285, R_031108_SPI_CONFIG_CNTL_2, 2, 2297},
	{67303, R_00B070_SPI_SHADER_USER_DATA_PS_16},
	{67330, R_00B074_SPI_SHADER_USER_DATA_PS_17},
	{67357, R_00B078_SPI_SHADER_USER_DATA_PS_18},
	{67384, R_00B07C_SPI_SHADER_USER_DATA_PS_19},
	{67411, R_00B080_SPI_SHADER_USER_DATA_PS_20},
	{67438, R_00B084_SPI_SHADER_USER_DATA_PS_21},
	{67465, R_00B088_SPI_SHADER_USER_DATA_PS_22},
	{67492, R_00B08C_SPI_SHADER_USER_DATA_PS_23},
	{67519, R_00B090_SPI_SHADER_USER_DATA_PS_24},
	{67546, R_00B094_SPI_SHADER_USER_DATA_PS_25},
	{67573, R_00B098_SPI_SHADER_USER_DATA_PS_26},
	{67600, R_00B09C_SPI_SHADER_USER_DATA_PS_27},
	{67627, R_00B0A0_SPI_SHADER_USER_DATA_PS_28},
	{67654, R_00B0A4_SPI_SHADER_USER_DATA_PS_29},
	{67681, R_00B0A8_SPI_SHADER_USER_DATA_PS_30},
	{67708, R_00B0AC_SPI_SHADER_USER_DATA_PS_31},
	{67735, R_00B170_SPI_SHADER_USER_DATA_VS_16},
	{67762, R_00B174_SPI_SHADER_USER_DATA_VS_17},
	{67789, R_00B178_SPI_SHADER_USER_DATA_VS_18},
	{67816, R_00B17C_SPI_SHADER_USER_DATA_VS_19},
	{67843, R_00B180_SPI_SHADER_USER_DATA_VS_20},
	{67870, R_00B184_SPI_SHADER_USER_DATA_VS_21},
	{67897, R_00B188_SPI_SHADER_USER_DATA_VS_22},
	{67924, R_00B18C_SPI_SHADER_USER_DATA_VS_23},
	{67951, R_00B190_SPI_SHADER_USER_DATA_VS_24},
	{67978, R_00B194_SPI_SHADER_USER_DATA_VS_25},
	{68005, R_00B198_SPI_SHADER_USER_DATA_VS_26},
	{68032, R_00B19C_SPI_SHADER_USER_DATA_VS_27},
	{68059, R_00B1A0_SPI_SHADER_USER_DATA_VS_28},
	{68086, R_00B1A4_SPI_SHADER_USER_DATA_VS_29},
	{68113, R_00B1A8_SPI_SHADER_USER_DATA_VS_30},
	{68140, R_00B1AC_SPI_SHADER_USER_DATA_VS_31},
	{68167, R_00B1F0_SPI_SHADER_PGM_RSRC2_GS_VS, 9, 2299},
	{68194, R_00B204_SPI_SHADER_PGM_RSRC4_GS, 2, 2308},
	{68218, R_00B208_SPI_SHADER_USER_DATA_ADDR_LO_GS},
	{68250, R_00B20C_SPI_SHADER_USER_DATA_ADDR_HI_GS},
	{46065, R_00B210_SPI_SHADER_PGM_LO_ES},
	{46086, R_00B214_SPI_SHADER_PGM_HI_ES, 1, 2310},
	{68282, R_00B370_SPI_SHADER_USER_DATA_ES_16},
	{68309, R_00B374_SPI_SHADER_USER_DATA_ES_17},
	{68336, R_00B378_SPI_SHADER_USER_DATA_ES_18},
	{68363, R_00B37C_SPI_SHADER_USER_DATA_ES_19},
	{68390, R_00B380_SPI_SHADER_USER_DATA_ES_20},
	{68417, R_00B384_SPI_SHADER_USER_DATA_ES_21},
	{68444, R_00B388_SPI_SHADER_USER_DATA_ES_22},
	{68471, R_00B38C_SPI_SHADER_USER_DATA_ES_23},
	{68498, R_00B390_SPI_SHADER_USER_DATA_ES_24},
	{68525, R_00B394_SPI_SHADER_USER_DATA_ES_25},
	{68552, R_00B398_SPI_SHADER_USER_DATA_ES_26},
	{68579, R_00B39C_SPI_SHADER_USER_DATA_ES_27},
	{68606, R_00B3A0_SPI_SHADER_USER_DATA_ES_28},
	{68633, R_00B3A4_SPI_SHADER_USER_DATA_ES_29},
	{68660, R_00B3A8_SPI_SHADER_USER_DATA_ES_30},
	{68687, R_00B3AC_SPI_SHADER_USER_DATA_ES_31},
	{68714, R_00B404_SPI_SHADER_PGM_RSRC4_HS, 1, 2311},
	{68738, R_00B408_SPI_SHADER_USER_DATA_ADDR_LO_HS},
	{68770, R_00B40C_SPI_SHADER_USER_DATA_ADDR_HI_HS},
	{47305, R_00B410_SPI_SHADER_PGM_LO_LS},
	{47326, R_00B414_SPI_SHADER_PGM_HI_LS, 1, 2312},
	{47395, R_00B430_SPI_SHADER_USER_DATA_LS_0},
	{47421, R_00B434_SPI_SHADER_USER_DATA_LS_1},
	{47447, R_00B438_SPI_SHADER_USER_DATA_LS_2},
	{47473, R_00B43C_SPI_SHADER_USER_DATA_LS_3},
	{47499, R_00B440_SPI_SHADER_USER_DATA_LS_4},
	{47525, R_00B444_SPI_SHADER_USER_DATA_LS_5},
	{47551, R_00B448_SPI_SHADER_USER_DATA_LS_6},
	{47577, R_00B44C_SPI_SHADER_USER_DATA_LS_7},
	{47603, R_00B450_SPI_SHADER_USER_DATA_LS_8},
	{47629, R_00B454_SPI_SHADER_USER_DATA_LS_9},
	{47655, R_00B458_SPI_SHADER_USER_DATA_LS_10},
	{47682, R_00B45C_SPI_SHADER_USER_DATA_LS_11},
	{47709, R_00B460_SPI_SHADER_USER_DATA_LS_12},
	{47736, R_00B464_SPI_SHADER_USER_DATA_LS_13},
	{47763, R_00B468_SPI_SHADER_USER_DATA_LS_14},
	{47790, R_00B46C_SPI_SHADER_USER_DATA_LS_15},
	{68802, R_00B470_SPI_SHADER_USER_DATA_LS_16},
	{68829, R_00B474_SPI_SHADER_USER_DATA_LS_17},
	{68856, R_00B478_SPI_SHADER_USER_DATA_LS_18},
	{68883, R_00B47C_SPI_SHADER_USER_DATA_LS_19},
	{68910, R_00B480_SPI_SHADER_USER_DATA_LS_20},
	{68937, R_00B484_SPI_SHADER_USER_DATA_LS_21},
	{68964, R_00B488_SPI_SHADER_USER_DATA_LS_22},
	{68991, R_00B48C_SPI_SHADER_USER_DATA_LS_23},
	{69018, R_00B490_SPI_SHADER_USER_DATA_LS_24},
	{69045, R_00B494_SPI_SHADER_USER_DATA_LS_25},
	{69072, R_00B498_SPI_SHADER_USER_DATA_LS_26},
	{69099, R_00B49C_SPI_SHADER_USER_DATA_LS_27},
	{69126, R_00B4A0_SPI_SHADER_USER_DATA_LS_28},
	{69153, R_00B4A4_SPI_SHADER_USER_DATA_LS_29},
	{69180, R_00B4A8_SPI_SHADER_USER_DATA_LS_30},
	{69207, R_00B4AC_SPI_SHADER_USER_DATA_LS_31},
	{69234, R_00B530_SPI_SHADER_USER_DATA_COMMON_0},
	{69264, R_00B534_SPI_SHADER_USER_DATA_COMMON_1},
	{69294, R_00B538_SPI_SHADER_USER_DATA_COMMON_2},
	{69324, R_00B53C_SPI_SHADER_USER_DATA_COMMON_3},
	{69354, R_00B540_SPI_SHADER_USER_DATA_COMMON_4},
	{69384, R_00B544_SPI_SHADER_USER_DATA_COMMON_5},
	{69414, R_00B548_SPI_SHADER_USER_DATA_COMMON_6},
	{69444, R_00B54C_SPI_SHADER_USER_DATA_COMMON_7},
	{69474, R_00B550_SPI_SHADER_USER_DATA_COMMON_8},
	{69504, R_00B554_SPI_SHADER_USER_DATA_COMMON_9},
	{69534, R_00B558_SPI_SHADER_USER_DATA_COMMON_10},
	{69565, R_00B55C_SPI_SHADER_USER_DATA_COMMON_11},
	{69596, R_00B560_SPI_SHADER_USER_DATA_COMMON_12},
	{69627, R_00B564_SPI_SHADER_USER_DATA_COMMON_13},
	{69658, R_00B568_SPI_SHADER_USER_DATA_COMMON_14},
	{69689, R_00B56C_SPI_SHADER_USER_DATA_COMMON_15},
	{69720, R_00B570_SPI_SHADER_USER_DATA_COMMON_16},
	{69751, R_00B574_SPI_SHADER_USER_DATA_COMMON_17},
	{69782, R_00B578_SPI_SHADER_USER_DATA_COMMON_18},
	{69813, R_00B57C_SPI_SHADER_USER_DATA_COMMON_19},
	{69844, R_00B580_SPI_SHADER_USER_DATA_COMMON_20},
	{69875, R_00B584_SPI_SHADER_USER_DATA_COMMON_21},
	{69906, R_00B588_SPI_SHADER_USER_DATA_COMMON_22},
	{69937, R_00B58C_SPI_SHADER_USER_DATA_COMMON_23},
	{69968, R_00B590_SPI_SHADER_USER_DATA_COMMON_24},
	{69999, R_00B594_SPI_SHADER_USER_DATA_COMMON_25},
	{70030, R_00B598_SPI_SHADER_USER_DATA_COMMON_26},
	{70061, R_00B59C_SPI_SHADER_USER_DATA_COMMON_27},
	{70092, R_00B5A0_SPI_SHADER_USER_DATA_COMMON_28},
	{70123, R_00B5A4_SPI_SHADER_USER_DATA_COMMON_29},
	{70154, R_00B5A8_SPI_SHADER_USER_DATA_COMMON_30},
	{70185, R_00B5AC_SPI_SHADER_USER_DATA_COMMON_31},
	{70216, R_00B838_COMPUTE_DISPATCH_PKT_ADDR_LO},
	{70245, R_00B83C_COMPUTE_DISPATCH_PKT_ADDR_HI, 1, 2313},
	{70274, R_00B840_COMPUTE_DISPATCH_SCRATCH_BASE_LO},
	{70307, R_00B844_COMPUTE_DISPATCH_SCRATCH_BASE_HI, 1, 2314},
	{70340, R_034030_CPF_LATENCY_STATS_DATA},
	{70363, R_034034_CPG_LATENCY_STATS_DATA},
	{70386, R_034038_CPC_LATENCY_STATS_DATA},
	{70409, R_036028_CPF_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2315},
	{70443, R_03602C_CPG_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2318},
	{70477, R_036030_CPF_LATENCY_STATS_SELECT, 3, 2321},
	{70502, R_036034_CPG_LATENCY_STATS_SELECT, 3, 2324},
	{70527, R_036038_CPC_LATENCY_STATS_SELECT, 3, 2327},
	{70552, R_028018_DB_HTILE_DATA_BASE_HI, 1, 2330},
	{55967, R_02801C_DB_DEPTH_SIZE, 2, 2331},
	{55867, R_028038_DB_Z_INFO, 13, 2333},
	{55877, R_02803C_DB_STENCIL_INFO, 8, 2346},
	{55893, R_028040_DB_Z_READ_BASE},
	{70574, R_028044_DB_Z_READ_BASE_HI, 1, 2354},
	{55908, R_028048_DB_STENCIL_READ_BASE},
	{70592, R_02804C_DB_STENCIL_READ_BASE_HI, 1, 2355},
	{70616, R_028054_DB_Z_WRITE_BASE_HI, 1, 2356},
	{55945, R_028058_DB_STENCIL_WRITE_BASE},
	{70635, R_02805C_DB_STENCIL_WRITE_BASE_HI, 1, 2357},
	{70660, R_028060_DB_DFSM_CONTROL, 3, 2358},
	{70676, R_028064_DB_RENDER_FILTER, 1, 2361},
	{70693, R_028068_DB_Z_INFO2, 1, 2362},
	{70704, R_02806C_DB_STENCIL_INFO2, 1, 2363},
	{70721, R_02835C_PA_SC_TILE_STEERING_OVERRIDE, 4, 2364},
	{70750, R_028360_CP_PERFMON_CNTX_CNTL, 1, 2368},
	{70771, R_0283A0_PA_SC_RIGHT_VERT_GRID, 4, 2369},
	{70793, R_0283A4_PA_SC_LEFT_VERT_GRID, 4, 2373},
	{70814, R_0283A8_PA_SC_HORIZ_GRID, 4, 2377},
	{70831, R_0283AC_PA_SC_FOV_WINDOW_LR, 4, 2381},
	{70851, R_0283B0_PA_SC_FOV_WINDOW_TB, 2, 2385},
	{70871, R_0287A0_CB_MRT0_EPITCH, 1, 2387},
	{70886, R_0287A4_CB_MRT1_EPITCH, 1, 2388},
	{70901, R_0287A8_CB_MRT2_EPITCH, 1, 2389},
	{70916, R_0287AC_CB_MRT3_EPITCH, 1, 2390},
	{70931, R_0287B0_CB_MRT4_EPITCH, 1, 2391},
	{70946, R_0287B4_CB_MRT5_EPITCH, 1, 2392},
	{70961, R_0287B8_CB_MRT6_EPITCH, 1, 2393},
	{70976, R_0287BC_CB_MRT7_EPITCH, 1, 2394},
	{70991, R_028834_PA_CL_OBJPRIM_ID_CNTL, 3, 2395},
	{71013, R_028838_PA_CL_NGG_CNTL, 2, 2398},
	{71028, R_02883C_PA_SU_OVER_RASTERIZATION_CNTL, 5, 2400},
	{71058, R_028A94_VGT_GS_MAX_PRIMS_PER_SUBGROUP, 1, 2405},
	{71088, R_028A98_VGT_DRAW_PAYLOAD_CNTL, 4, 2406},
	{71110, R_028A9C_VGT_INDEX_PAYLOAD_CNTL, 1, 2410},
	{71133, R_028B9C_VGT_DMA_EVENT_INITIATOR, 3, 2411},
	{71157, R_028C44_PA_SC_BINNER_CNTL_0, 10, 2414},
	{71177, R_028C48_PA_SC_BINNER_CNTL_1, 2, 2424},
	{71197, R_028C4C_PA_SC_CONSERVATIVE_RASTERIZATION_CNTL, 18, 2426},
	{71235, R_028C50_PA_SC_NGG_MODE_CNTL, 1, 2444},
	{71255, R_028C64_CB_COLOR0_BASE_EXT, 1, 2445},
	{71274, R_028C68_CB_COLOR0_ATTRIB2, 3, 2446},
	{71292, R_028C80_CB_COLOR0_CMASK_BASE_EXT, 1, 2449},
	{71317, R_028C88_CB_COLOR0_FMASK_BASE_EXT, 1, 2450},
	{71342, R_028C98_CB_COLOR0_DCC_BASE_EXT, 1, 2451},
	{71365, R_028CA0_CB_COLOR1_BASE_EXT, 1, 2445},
	{71384, R_028CA4_CB_COLOR1_ATTRIB2},
	{71402, R_028CBC_CB_COLOR1_CMASK_BASE_EXT, 1, 2449},
	{71427, R_028CC4_CB_COLOR1_FMASK_BASE_EXT, 1, 2450},
	{71452, R_028CD4_CB_COLOR1_DCC_BASE_EXT, 1, 2451},
	{71475, R_028CDC_CB_COLOR2_BASE_EXT, 1, 2445},
	{71494, R_028CE0_CB_COLOR2_ATTRIB2},
	{71512, R_028CF8_CB_COLOR2_CMASK_BASE_EXT, 1, 2449},
	{71537, R_028D00_CB_COLOR2_FMASK_BASE_EXT, 1, 2450},
	{71562, R_028D10_CB_COLOR2_DCC_BASE_EXT, 1, 2451},
	{71585, R_028D18_CB_COLOR3_BASE_EXT, 1, 2445},
	{71604, R_028D1C_CB_COLOR3_ATTRIB2},
	{71622, R_028D34_CB_COLOR3_CMASK_BASE_EXT, 1, 2449},
	{71647, R_028D3C_CB_COLOR3_FMASK_BASE_EXT, 1, 2450},
	{71672, R_028D4C_CB_COLOR3_DCC_BASE_EXT, 1, 2451},
	{71695, R_028D54_CB_COLOR4_BASE_EXT, 1, 2445},
	{71714, R_028D58_CB_COLOR4_ATTRIB2},
	{71732, R_028D70_CB_COLOR4_CMASK_BASE_EXT, 1, 2449},
	{71757, R_028D78_CB_COLOR4_FMASK_BASE_EXT, 1, 2450},
	{71782, R_028D88_CB_COLOR4_DCC_BASE_EXT, 1, 2451},
	{71805, R_028D90_CB_COLOR5_BASE_EXT, 1, 2445},
	{71824, R_028D94_CB_COLOR5_ATTRIB2},
	{71842, R_028DAC_CB_COLOR5_CMASK_BASE_EXT, 1, 2449},
	{71867, R_028DB4_CB_COLOR5_FMASK_BASE_EXT, 1, 2450},
	{71892, R_028DC4_CB_COLOR5_DCC_BASE_EXT, 1, 2451},
	{71915, R_028DCC_CB_COLOR6_BASE_EXT, 1, 2445},
	{71934, R_028DD0_CB_COLOR6_ATTRIB2},
	{71952, R_028DE8_CB_COLOR6_CMASK_BASE_EXT, 1, 2449},
	{71977, R_028DF0_CB_COLOR6_FMASK_BASE_EXT, 1, 2450},
	{72002, R_028E00_CB_COLOR6_DCC_BASE_EXT, 1, 2451},
	{72025, R_028E08_CB_COLOR7_BASE_EXT, 1, 2445},
	{72044, R_028E0C_CB_COLOR7_ATTRIB2},
	{72062, R_028E24_CB_COLOR7_CMASK_BASE_EXT, 1, 2449},
	{72087, R_028E2C_CB_COLOR7_FMASK_BASE_EXT, 1, 2450},
	{72112, R_028E3C_CB_COLOR7_DCC_BASE_EXT, 1, 2451},
};

static const char sid_strings[] =
	"NOP\0" /* 0 */
	"SET_BASE\0" /* 4 */
	"CLEAR_STATE\0" /* 13 */
	"INDEX_BUFFER_SIZE\0" /* 25, 38 */
	"DISPATCH_DIRECT\0" /* 43 */
	"DISPATCH_INDIRECT\0" /* 59 */
	"OCCLUSION_QUERY\0" /* 91, 77 */
	"SET_PREDICATION\0" /* 93 */
	"COND_EXEC\0" /* 109 */
	"PRED_EXEC\0" /* 119 */
	"DRAW_INDIRECT\0" /* 129 */
	"DRAW_INDEX_INDIRECT\0" /* 143 */
	"INDEX_BASE\0" /* 163 */
	"DRAW_INDEX_2\0" /* 174 */
	"CONTEXT_CONTROL\0" /* 187, 195 */
	"INDEX_TYPE\0" /* 209, 203 */
	"DRAW_INDIRECT_MULTI\0" /* 214 */
	"DRAW_INDEX_AUTO\0" /* 234, 245 */
	"DRAW_INDEX_IMMD\0" /* 250 */
	"NUM_INSTANCES\0" /* 266 */
	"DRAW_INDEX_MULTI_AUTO\0" /* 280 */
	"INDIRECT_BUFFER_SI\0" /* 302 */
	"INDIRECT_BUFFER_CONST\0" /* 321 */
	"STRMOUT_BUFFER_UPDATE\0" /* 343 */
	"DRAW_INDEX_OFFSET_2\0" /* 365 */
	"WRITE_DATA\0" /* 385, 391 */
	"DRAW_INDEX_INDIRECT_MULTI\0" /* 396 */
	"MEM_SEMAPHORE\0" /* 422 */
	"MPEG_INDEX\0" /* 441, 436, 445 */
	"WAIT_REG_MEM\0" /* 447 */
	"MEM_WRITE\0" /* 460 */
	"INDIRECT_BUFFER_CIK\0" /* 470 */
	"COPY_DATA\0" /* 490 */
	"PFP_SYNC_ME\0" /* 500, 509 */
	"SURFACE_SYNC\0" /* 512 */
	"ME_INITIALIZE\0" /* 525 */
	"COND_WRITE\0" /* 539 */
	"EVENT_WRITE\0" /* 550 */
	"EVENT_WRITE_EOP\0" /* 562 */
	"ONE_REG_WRITE\0" /* 578 */
	"ACQUIRE_MEM\0" /* 592 */
	"SET_CONFIG_REG\0" /* 604 */
	"SET_CONTEXT_REG\0" /* 619 */
	"SET_SH_REG\0" /* 635 */
	"SET_SH_REG_OFFSET\0" /* 657, 646 */
	"SET_UCONFIG_REG\0" /* 664 */
	"LOAD_CONST_RAM\0" /* 680 */
	"WRITE_CONST_RAM\0" /* 695 */
	"DUMP_CONST_RAM\0" /* 711 */
	"INCREMENT_CE_COUNTER\0" /* 726 */
	"INCREMENT_DE_COUNTER\0" /* 747 */
	"WAIT_ON_CE_COUNTER\0" /* 768 */
	"IT_OPCODE_C\0" /* 787 */
	"CP_DMA\0" /* 799 */
	"DMA_DATA\0" /* 806 */
	"COUNT_INDIRECT_ENABLE\0" /* 830, 815 */
	"DRAW_INDEX_ENABLE\0" /* 837 */
	"PFP\0" /* 855 */
	"CE\0" /* 859 */
	"DE\0" /* 862 */
	"ENGINE_SEL\0" /* 865 */
	"WR_CONFIRM\0" /* 876 */
	"WR_ONE_ADDR\0" /* 894, 887 */
	"MEM_MAPPED_REGISTER\0" /* 899, 910 */
	"MEMORY_SYNC\0" /* 919 */
	"TC_L2\0" /* 931 */
	"GDS\0" /* 937 */
	"RESERVED\0" /* 941 */
	"MEM_ASYNC\0" /* 950 */
	"DST_SEL\0" /* 960 */
	"IB_SIZE\0" /* 968 */
	"CHAIN\0" /* 976 */
	"VALID\0" /* 982 */
	"SRC_ADDR_LO\0" /* 988 */
	"CP_SYNC\0" /* 1000 */
	"SRC_ADDR\0" /* 1008 */
	"SRC_ADDR_TC_L2\0" /* 1017 */
	"SRC_SEL\0" /* 1032 */
	"ENGINE\0" /* 1040 */
	"DST_ADDR\0" /* 1047 */
	"NOWHERE\0" /* 1056 */
	"DST_ADDR_TC_L2\0" /* 1064 */
	"DSL_SEL\0" /* 1079 */
	"SRC_ADDR_HI\0" /* 1087 */
	"DST_ADDR_LO\0" /* 1099 */
	"DST_ADDR_HI\0" /* 1111 */
	"BYTE_COUNT_GFX6\0" /* 1123 */
	"BYTE_COUNT_GFX9\0" /* 1139 */
	"DISABLE_WR_CONFIRM_GFX6\0" /* 1155 */
	"NONE\0" /* 1179 */
	"8_IN_16\0" /* 1184 */
	"8_IN_32\0" /* 1192 */
	"8_IN_64\0" /* 1200 */
	"SRC_SWAP\0" /* 1208 */
	"DST_SWAP\0" /* 1217 */
	"MEMORY\0" /* 1226 */
	"SAS\0" /* 1233 */
	"DAS\0" /* 1237 */
	"INCREMENT\0" /* 1241 */
	"NO_INCREMENT\0" /* 1251 */
	"SAIC\0" /* 1264 */
	"DAIC\0" /* 1269 */
	"RAW_WAIT\0" /* 1274 */
	"DISABLE_WR_CONFIRM_GFX9\0" /* 1283 */
	"SDMA_RQ_PENDING\0" /* 1307 */
	"TST_RQ_PENDING\0" /* 1323 */
	"SDMA1_RQ_PENDING\0" /* 1338 */
	"VCE0_RQ_PENDING\0" /* 1355 */
	"VP8_BUSY\0" /* 1371 */
	"SDMA_BUSY\0" /* 1380, 1381 */
	"SDMA1_BUSY\0" /* 1390 */
	"VCE0_BUSY\0" /* 1401 */
	"XDMA_BUSY\0" /* 1411 */
	"CHUB_BUSY\0" /* 1421 */
	"SDMA2_BUSY\0" /* 1431 */
	"SDMA3_BUSY\0" /* 1442 */
	"SAMSCP_BUSY\0" /* 1457, 1453 */
	"ISP_BUSY\0" /* 1465 */
	"VCE1_BUSY\0" /* 1474 */
	"ODE_BUSY\0" /* 1484 */
	"SDMA2_RQ_PENDING\0" /* 1493 */
	"SDMA3_RQ_PENDING\0" /* 1510 */
	"SAMSCP_RQ_PENDING\0" /* 1527 */
	"ISP_RQ_PENDING\0" /* 1545 */
	"VCE1_RQ_PENDING\0" /* 1560 */
	"UVD_RQ_PENDING\0" /* 1576 */
	"SAMMSP_RQ_PENDING\0" /* 1591 */
	"ACP_RQ_PENDING\0" /* 1609 */
	"SMU_RQ_PENDING\0" /* 1624 */
	"GRBM_RQ_PENDING\0" /* 1639 */
	"HI_RQ_PENDING\0" /* 1655 */
	"VMC_BUSY\0" /* 1669 */
	"MCB_BUSY\0" /* 1678, 1679 */
	"MCB_NON_DISPLAY_BUSY\0" /* 1687 */
	"MCC_BUSY\0" /* 1708 */
	"MCD_BUSY\0" /* 1717 */
	"VMC1_BUSY\0" /* 1726 */
	"SEM_BUSY\0" /* 1736 */
	"ACP_BUSY\0" /* 1745 */
	"IH_BUSY\0" /* 1754 */
	"UVD_BUSY\0" /* 1762 */
	"SAMMSP_BUSY\0" /* 1771 */
	"GCATCL2_BUSY\0" /* 1783 */
	"OSATCL2_BUSY\0" /* 1796 */
	"BIF_BUSY\0" /* 1809 */
	"MCC0_BUSY\0" /* 1818 */
	"MCC1_BUSY\0" /* 1828 */
	"MCC2_BUSY\0" /* 1838 */
	"MCC3_BUSY\0" /* 1848 */
	"MCC4_BUSY\0" /* 1858 */
	"MCC5_BUSY\0" /* 1868 */
	"MCC6_BUSY\0" /* 1878 */
	"MCC7_BUSY\0" /* 1888 */
	"MCD0_BUSY\0" /* 1898 */
	"MCD1_BUSY\0" /* 1908 */
	"MCD2_BUSY\0" /* 1918 */
	"MCD3_BUSY\0" /* 1928 */
	"MCD4_BUSY\0" /* 1938 */
	"MCD5_BUSY\0" /* 1948 */
	"MCD6_BUSY\0" /* 1958 */
	"MCD7_BUSY\0" /* 1968 */
	"IDLE\0" /* 1978 */
	"REG_IDLE\0" /* 1983 */
	"RB_EMPTY\0" /* 1992 */
	"RB_FULL\0" /* 2001 */
	"RB_CMD_IDLE\0" /* 2009 */
	"RB_CMD_FULL\0" /* 2021 */
	"IB_CMD_IDLE\0" /* 2033 */
	"IB_CMD_FULL\0" /* 2045 */
	"BLOCK_IDLE\0" /* 2057 */
	"INSIDE_IB\0" /* 2068 */
	"EX_IDLE\0" /* 2078 */
	"EX_IDLE_POLL_TIMER_EXPIRE\0" /* 2086 */
	"PACKET_READY\0" /* 2112 */
	"MC_WR_IDLE\0" /* 2125 */
	"SRBM_IDLE\0" /* 2136 */
	"CONTEXT_EMPTY\0" /* 2146 */
	"DELTA_RPTR_FULL\0" /* 2160 */
	"RB_MC_RREQ_IDLE\0" /* 2176 */
	"IB_MC_RREQ_IDLE\0" /* 2192 */
	"MC_RD_IDLE\0" /* 2208 */
	"DELTA_RPTR_EMPTY\0" /* 2219 */
	"MC_RD_RET_STALL\0" /* 2236 */
	"MC_RD_NO_POLL_IDLE\0" /* 2252 */
	"PREV_CMD_IDLE\0" /* 2271 */
	"SEM_IDLE\0" /* 2285 */
	"SEM_REQ_STALL\0" /* 2294 */
	"SEM_RESP_STATE\0" /* 2308 */
	"INT_IDLE\0" /* 2323 */
	"INT_REQ_STALL\0" /* 2332 */
	"ME0PIPE1_CMDFIFO_AVAIL\0" /* 2346 */
	"ME0PIPE1_CF_RQ_PENDING\0" /* 2369 */
	"ME0PIPE1_PF_RQ_PENDING\0" /* 2392 */
	"ME1PIPE0_RQ_PENDING\0" /* 2415 */
	"ME1PIPE1_RQ_PENDING\0" /* 2435 */
	"ME1PIPE2_RQ_PENDING\0" /* 2455 */
	"ME1PIPE3_RQ_PENDING\0" /* 2475 */
	"ME2PIPE0_RQ_PENDING\0" /* 2495 */
	"ME2PIPE1_RQ_PENDING\0" /* 2515 */
	"ME2PIPE2_RQ_PENDING\0" /* 2535 */
	"ME2PIPE3_RQ_PENDING\0" /* 2555 */
	"RLC_RQ_PENDING\0" /* 2575 */
	"RLC_BUSY\0" /* 2590 */
	"TC_BUSY\0" /* 2599 */
	"TCC_CC_RESIDENT\0" /* 2607 */
	"CPF_BUSY\0" /* 2623 */
	"CPC_BUSY\0" /* 2632 */
	"CPG_BUSY\0" /* 2641 */
	"UTCL2_BUSY\0" /* 2650 */
	"EA_BUSY\0" /* 2661 */
	"RMI_BUSY\0" /* 2669 */
	"UTCL2_RQ_PENDING\0" /* 2678 */
	"CPF_RQ_PENDING\0" /* 2695 */
	"EA_LINK_BUSY\0" /* 2710 */
	"CPAXI_BUSY\0" /* 2723 */
	"ME0PIPE0_CMDFIFO_AVAIL\0" /* 2734 */
	"SRBM_RQ_PENDING\0" /* 2757 */
	"ME0PIPE0_CF_RQ_PENDING\0" /* 2773 */
	"ME0PIPE0_PF_RQ_PENDING\0" /* 2796 */
	"GDS_DMA_RQ_PENDING\0" /* 2819 */
	"DB_CLEAN\0" /* 2838 */
	"CB_CLEAN\0" /* 2847 */
	"TA_BUSY\0" /* 2856 */
	"GDS_BUSY\0" /* 2864 */
	"WD_BUSY_NO_DMA\0" /* 2873 */
	"VGT_BUSY\0" /* 2888 */
	"IA_BUSY_NO_DMA\0" /* 2897 */
	"IA_BUSY\0" /* 2912 */
	"SX_BUSY\0" /* 2920 */
	"WD_BUSY\0" /* 2928 */
	"SPI_BUSY\0" /* 2936 */
	"BCI_BUSY\0" /* 2945 */
	"SC_BUSY\0" /* 2954 */
	"PA_BUSY\0" /* 2962 */
	"DB_BUSY\0" /* 2970 */
	"CP_COHERENCY_BUSY\0" /* 2978 */
	"GUI_ACTIVE\0" /* 2996 */
	"RSMU_RQ_PENDING\0" /* 3007 */
	"OFFSET_UPDATE_DONE\0" /* 3037, 3023 */
	"DEST_BASE_0_ENA\0" /* 3042 */
	"DEST_BASE_1_ENA\0" /* 3058 */
	"CB0_DEST_BASE_ENA\0" /* 3074 */
	"CB1_DEST_BASE_ENA\0" /* 3092 */
	"CB2_DEST_BASE_ENA\0" /* 3110 */
	"CB3_DEST_BASE_ENA\0" /* 3128 */
	"CB4_DEST_BASE_ENA\0" /* 3146 */
	"CB5_DEST_BASE_ENA\0" /* 3164 */
	"CB6_DEST_BASE_ENA\0" /* 3182 */
	"CB7_DEST_BASE_ENA\0" /* 3200 */
	"DB_DEST_BASE_ENA\0" /* 3218 */
	"DEST_BASE_2_ENA\0" /* 3235 */
	"DEST_BASE_3_ENA\0" /* 3251 */
	"TCL1_ACTION_ENA\0" /* 3267 */
	"TC_ACTION_ENA\0" /* 3283 */
	"CB_ACTION_ENA\0" /* 3297 */
	"DB_ACTION_ENA\0" /* 3311 */
	"SH_KCACHE_ACTION_ENA\0" /* 3325 */
	"SH_ICACHE_ACTION_ENA\0" /* 3346 */
	"COHER_BASE_HI_256B\0" /* 3367 */
	"START_DELAY_COUNT\0" /* 3386 */
	"TC_SD_ACTION_ENA\0" /* 3404 */
	"TC_NC_ACTION_ENA\0" /* 3421 */
	"TCL1_VOL_ACTION_ENA\0" /* 3438 */
	"TC_VOL_ACTION_ENA\0" /* 3458 */
	"TC_WB_ACTION_ENA\0" /* 3476 */
	"SH_KCACHE_VOL_ACTION_ENA\0" /* 3493 */
	"SH_KCACHE_WB_ACTION_ENA\0" /* 3518 */
	"SH_SD_ACTION_ENA\0" /* 3542 */
	"TC_WC_ACTION_ENA\0" /* 3559 */
	"TC_INV_METADATA_ACTION_ENA\0" /* 3576 */
	"MATCHING_GFX_CNTX\0" /* 3603 */
	"MEID\0" /* 3621 */
	"PHASE1_STATUS\0" /* 3633, 3626 */
	"MEC1_BUSY\0" /* 3640 */
	"MEC2_BUSY\0" /* 3650 */
	"DC0_BUSY\0" /* 3660 */
	"DC1_BUSY\0" /* 3669 */
	"RCIU1_BUSY\0" /* 3678 */
	"RCIU2_BUSY\0" /* 3689 */
	"ROQ1_BUSY\0" /* 3700 */
	"ROQ2_BUSY\0" /* 3710 */
	"TCIU_BUSY\0" /* 3720 */
	"SCRATCH_RAM_BUSY\0" /* 3730 */
	"QU_BUSY\0" /* 3747 */
	"ATCL2IU_BUSY\0" /* 3755 */
	"CPG_CPC_BUSY\0" /* 3768 */
	"CPF_CPC_BUSY\0" /* 3781 */
	"UTCL2IU_BUSY\0" /* 3794 */
	"SAVE_RESTORE_BUSY\0" /* 3807 */
	"MEC1_LOAD_BUSY\0" /* 3825 */
	"MEC1_SEMAPOHRE_BUSY\0" /* 3840 */
	"MEC1_MUTEX_BUSY\0" /* 3860 */
	"MEC1_MESSAGE_BUSY\0" /* 3876 */
	"MEC1_EOP_QUEUE_BUSY\0" /* 3894 */
	"MEC1_IQ_QUEUE_BUSY\0" /* 3914 */
	"MEC1_IB_QUEUE_BUSY\0" /* 3933 */
	"MEC1_TC_BUSY\0" /* 3952 */
	"MEC1_DMA_BUSY\0" /* 3965 */
	"MEC1_PARTIAL_FLUSH_BUSY\0" /* 3979 */
	"MEC1_PIPE0_BUSY\0" /* 4003 */
	"MEC1_PIPE1_BUSY\0" /* 4019 */
	"MEC1_PIPE2_BUSY\0" /* 4035 */
	"MEC1_PIPE3_BUSY\0" /* 4051 */
	"MEC2_LOAD_BUSY\0" /* 4067 */
	"MEC2_SEMAPOHRE_BUSY\0" /* 4082 */
	"MEC2_MUTEX_BUSY\0" /* 4102 */
	"MEC2_MESSAGE_BUSY\0" /* 4118 */
	"MEC2_EOP_QUEUE_BUSY\0" /* 4136 */
	"MEC2_IQ_QUEUE_BUSY\0" /* 4156 */
	"MEC2_IB_QUEUE_BUSY\0" /* 4175 */
	"MEC2_TC_BUSY\0" /* 4194 */
	"MEC2_DMA_BUSY\0" /* 4207 */
	"MEC2_PARTIAL_FLUSH_BUSY\0" /* 4221 */
	"MEC2_PIPE0_BUSY\0" /* 4245 */
	"MEC2_PIPE1_BUSY\0" /* 4261 */
	"MEC2_PIPE2_BUSY\0" /* 4277 */
	"MEC2_PIPE3_BUSY\0" /* 4293 */
	"RCIU_TX_FREE_STALL\0" /* 4309 */
	"RCIU_PRIV_VIOLATION\0" /* 4328 */
	"TCIU_TX_FREE_STALL\0" /* 4348 */
	"MEC1_DECODING_PACKET\0" /* 4367 */
	"MEC1_WAIT_ON_RCIU\0" /* 4388 */
	"MEC1_WAIT_ON_RCIU_READ\0" /* 4406 */
	"MEC1_WAIT_ON_ROQ_DATA\0" /* 4429 */
	"MEC2_DECODING_PACKET\0" /* 4451 */
	"MEC2_WAIT_ON_RCIU\0" /* 4472 */
	"MEC2_WAIT_ON_RCIU_READ\0" /* 4490 */
	"MEC2_WAIT_ON_ROQ_DATA\0" /* 4513 */
	"ATCL2IU_WAITING_ON_FREE\0" /* 4535 */
	"ATCL2IU_WAITING_ON_TAGS\0" /* 4559 */
	"ATCL1_WAITING_ON_TRANS\0" /* 4583 */
	"UTCL2IU_WAITING_ON_FREE\0" /* 4606 */
	"UTCL2IU_WAITING_ON_TAGS\0" /* 4630 */
	"UTCL1_WAITING_ON_TRANS\0" /* 4654 */
	"POST_WPTR_GFX_BUSY\0" /* 4677 */
	"CSF_BUSY\0" /* 4696 */
	"ROQ_ALIGN_BUSY\0" /* 4705 */
	"ROQ_RING_BUSY\0" /* 4720 */
	"ROQ_INDIRECT1_BUSY\0" /* 4734 */
	"ROQ_INDIRECT2_BUSY\0" /* 4753 */
	"ROQ_STATE_BUSY\0" /* 4772 */
	"ROQ_CE_RING_BUSY\0" /* 4787 */
	"ROQ_CE_INDIRECT1_BUSY\0" /* 4804 */
	"ROQ_CE_INDIRECT2_BUSY\0" /* 4826 */
	"SEMAPHORE_BUSY\0" /* 4848 */
	"INTERRUPT_BUSY\0" /* 4863 */
	"HQD_BUSY\0" /* 4878 */
	"PRT_BUSY\0" /* 4887 */
	"CPF_GFX_BUSY\0" /* 4896 */
	"CPF_CMP_BUSY\0" /* 4909 */
	"GRBM_CPF_STAT_BUSY\0" /* 4922 */
	"CPC_CPF_BUSY\0" /* 4941 */
	"REG_BUS_FIFO_BUSY\0" /* 4954 */
	"CSF_RING_BUSY\0" /* 4972 */
	"CSF_INDIRECT1_BUSY\0" /* 4986 */
	"CSF_INDIRECT2_BUSY\0" /* 5005 */
	"CSF_STATE_BUSY\0" /* 5024 */
	"CSF_CE_INDR1_BUSY\0" /* 5039 */
	"CSF_CE_INDR2_BUSY\0" /* 5057 */
	"CSF_ARBITER_BUSY\0" /* 5075 */
	"CSF_INPUT_BUSY\0" /* 5092 */
	"OUTSTANDING_READ_TAGS\0" /* 5107 */
	"HPD_PROCESSING_EOP_BUSY\0" /* 5129 */
	"HQD_DISPATCH_BUSY\0" /* 5153 */
	"HQD_IQ_TIMER_BUSY\0" /* 5171 */
	"HQD_DMA_OFFLOAD_BUSY\0" /* 5189 */
	"HQD_WAIT_SEMAPHORE_BUSY\0" /* 5210 */
	"HQD_SIGNAL_SEMAPHORE_BUSY\0" /* 5234 */
	"HQD_MESSAGE_BUSY\0" /* 5260 */
	"HQD_PQ_FETCHER_BUSY\0" /* 5277 */
	"HQD_IB_FETCHER_BUSY\0" /* 5297 */
	"HQD_IQ_FETCHER_BUSY\0" /* 5317 */
	"HQD_EOP_FETCHER_BUSY\0" /* 5337 */
	"HQD_CONSUMED_RPTR_BUSY\0" /* 5358 */
	"HQD_FETCHER_ARB_BUSY\0" /* 5381 */
	"HQD_ROQ_ALIGN_BUSY\0" /* 5402 */
	"HQD_ROQ_EOP_BUSY\0" /* 5421 */
	"HQD_ROQ_IQ_BUSY\0" /* 5438 */
	"HQD_ROQ_PQ_BUSY\0" /* 5454 */
	"HQD_ROQ_IB_BUSY\0" /* 5470 */
	"HQD_WPTR_POLL_BUSY\0" /* 5486 */
	"HQD_PQ_BUSY\0" /* 5505 */
	"HQD_IB_BUSY\0" /* 5517 */
	"RING_FETCHING_DATA\0" /* 5529 */
	"INDR1_FETCHING_DATA\0" /* 5548 */
	"INDR2_FETCHING_DATA\0" /* 5568 */
	"STATE_FETCHING_DATA\0" /* 5588 */
	"TCIU_WAITING_ON_FREE\0" /* 5608 */
	"TCIU_WAITING_ON_TAGS\0" /* 5629 */
	"GFX_UTCL1_WAITING_ON_TRANS\0" /* 5650 */
	"CMP_UTCL1_WAITING_ON_TRANS\0" /* 5677 */
	"RCIU_WAITING_ON_FREE\0" /* 5704 */
	"COHER_SIZE_HI_256B\0" /* 5725 */
	"PRIM_COUNT\0" /* 5744 */
	"VS_NO_EXTRA_BUFFER\0" /* 5755 */
	"STREAMOUT_FULL_FLUSH\0" /* 5774 */
	"ES_LIMIT\0" /* 5795, 5798 */
	"VERT_REUSE\0" /* 5804 */
	"DI_PT_NONE\0" /* 5815 */
	"DI_PT_POINTLIST\0" /* 5826 */
	"DI_PT_LINELIST\0" /* 5842 */
	"DI_PT_LINESTRIP\0" /* 5857 */
	"DI_PT_TRILIST\0" /* 5873 */
	"DI_PT_TRIFAN\0" /* 5887 */
	"DI_PT_TRISTRIP\0" /* 5900 */
	"DI_PT_UNUSED_0\0" /* 5915 */
	"DI_PT_UNUSED_1\0" /* 5930 */
	"DI_PT_PATCH\0" /* 5945 */
	"DI_PT_LINELIST_ADJ\0" /* 5957 */
	"DI_PT_LINESTRIP_ADJ\0" /* 5976 */
	"DI_PT_TRILIST_ADJ\0" /* 5996 */
	"DI_PT_TRISTRIP_ADJ\0" /* 6014 */
	"DI_PT_UNUSED_3\0" /* 6033 */
	"DI_PT_UNUSED_4\0" /* 6048 */
	"DI_PT_TRI_WITH_WFLAGS\0" /* 6063 */
	"DI_PT_RECTLIST\0" /* 6085 */
	"DI_PT_LINELOOP\0" /* 6100 */
	"DI_PT_QUADLIST\0" /* 6115 */
	"DI_PT_QUADSTRIP\0" /* 6130 */
	"DI_PT_POLYGON\0" /* 6146 */
	"DI_PT_2D_COPY_RECT_LIST_V0\0" /* 6160 */
	"DI_PT_2D_COPY_RECT_LIST_V1\0" /* 6187 */
	"DI_PT_2D_COPY_RECT_LIST_V2\0" /* 6214 */
	"DI_PT_2D_COPY_RECT_LIST_V3\0" /* 6241 */
	"DI_PT_2D_FILL_RECT_LIST\0" /* 6268 */
	"DI_PT_2D_LINE_STRIP\0" /* 6292 */
	"DI_PT_2D_TRI_STRIP\0" /* 6312 */
	"PRIM_TYPE\0" /* 6331 */
	"DI_INDEX_SIZE_16_BIT\0" /* 6341 */
	"DI_INDEX_SIZE_32_BIT\0" /* 6362 */
	"OFFCHIP_BUFFERING\0" /* 6383 */
	"CLIP_VTX_REORDER_ENA\0" /* 6401 */
	"NUM_CLIP_SEQ\0" /* 6422 */
	"CLIPPED_PRIM_SEQ_STALL\0" /* 6435 */
	"VE_NAN_PROC_DISABLE\0" /* 6458 */
	"LINE_STIPPLE_VALUE\0" /* 6478 */
	"CURRENT_PTR\0" /* 6497 */
	"CURRENT_COUNT\0" /* 6509 */
	"CE_TO_CSF_NOT_RDY_TO_RCV\0" /* 6523 */
	"CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV\0" /* 6548 */
	"CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER\0" /* 6586 */
	"CE_TO_RAM_INIT_NOT_RDY\0" /* 6627 */
	"CE_TO_RAM_DUMP_NOT_RDY\0" /* 6650 */
	"CE_TO_RAM_WRITE_NOT_RDY\0" /* 6673 */
	"CE_TO_INC_FIFO_NOT_RDY_TO_RCV\0" /* 6697 */
	"CE_TO_WR_FIFO_NOT_RDY_TO_RCV\0" /* 6727 */
	"CE_WAITING_ON_BUFFER_DATA\0" /* 6756 */
	"CE_WAITING_ON_CE_BUFFER_FLAG\0" /* 6782 */
	"CE_WAITING_ON_DE_COUNTER\0" /* 6811 */
	"CE_WAITING_ON_DE_COUNTER_UNDERFLOW\0" /* 6836 */
	"CE_STALLED_ON_TC_WR_CONFIRM\0" /* 6871 */
	"CE_STALLED_ON_ATOMIC_RTN_DATA\0" /* 6899 */
	"RBIU_TO_DMA_NOT_RDY_TO_RCV\0" /* 6929 */
	"RBIU_TO_SEM_NOT_RDY_TO_RCV\0" /* 6956 */
	"RBIU_TO_MEMWR_NOT_RDY_TO_RCV\0" /* 6983 */
	"ME_HAS_ACTIVE_CE_BUFFER_FLAG\0" /* 7012 */
	"ME_HAS_ACTIVE_DE_BUFFER_FLAG\0" /* 7041 */
	"ME_STALLED_ON_TC_WR_CONFIRM\0" /* 7070 */
	"ME_STALLED_ON_ATOMIC_RTN_DATA\0" /* 7098 */
	"ME_WAITING_ON_TC_READ_DATA\0" /* 7128 */
	"ME_WAITING_ON_REG_READ_DATA\0" /* 7155 */
	"RCIU_WAITING_ON_GDS_FREE\0" /* 7183 */
	"RCIU_WAITING_ON_GRBM_FREE\0" /* 7208 */
	"RCIU_WAITING_ON_VGT_FREE\0" /* 7234 */
	"RCIU_STALLED_ON_ME_READ\0" /* 7259 */
	"RCIU_STALLED_ON_DMA_READ\0" /* 7283 */
	"RCIU_STALLED_ON_APPEND_READ\0" /* 7308 */
	"RCIU_HALTED_BY_REG_VIOLATION\0" /* 7336 */
	"PFP_TO_CSF_NOT_RDY_TO_RCV\0" /* 7365 */
	"PFP_TO_MEQ_NOT_RDY_TO_RCV\0" /* 7391 */
	"PFP_TO_RCIU_NOT_RDY_TO_RCV\0" /* 7417 */
	"PFP_TO_VGT_WRITES_PENDING\0" /* 7444 */
	"PFP_RCIU_READ_PENDING\0" /* 7470 */
	"PFP_WAITING_ON_BUFFER_DATA\0" /* 7492 */
	"ME_WAIT_ON_CE_COUNTER\0" /* 7519 */
	"ME_WAIT_ON_AVAIL_BUFFER\0" /* 7541 */
	"GFX_CNTX_NOT_AVAIL_TO_ME\0" /* 7565 */
	"ME_RCIU_NOT_RDY_TO_RCV\0" /* 7590 */
	"ME_TO_CONST_NOT_RDY_TO_RCV\0" /* 7613 */
	"ME_WAITING_DATA_FROM_PFP\0" /* 7640 */
	"ME_WAITING_ON_PARTIAL_FLUSH\0" /* 7665 */
	"MEQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7693 */
	"STQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7718 */
	"ME_WAITING_DATA_FROM_STQ\0" /* 7743 */
	"PFP_STALLED_ON_TC_WR_CONFIRM\0" /* 7768 */
	"PFP_STALLED_ON_ATOMIC_RTN_DATA\0" /* 7797 */
	"EOPD_FIFO_NEEDS_SC_EOP_DONE\0" /* 7828 */
	"EOPD_FIFO_NEEDS_WR_CONFIRM\0" /* 7856 */
	"STRMO_WR_OF_PRIM_DATA_PENDING\0" /* 7883 */
	"PIPE_STATS_WR_DATA_PENDING\0" /* 7913 */
	"APPEND_RDY_WAIT_ON_CS_DONE\0" /* 7940, 7959 */
	"APPEND_RDY_WAIT_ON_PS_DONE\0" /* 7986, 7967 */
	"APPEND_WAIT_ON_WR_CONFIRM\0" /* 7994 */
	"APPEND_ACTIVE_PARTITION\0" /* 8020 */
	"APPEND_WAITING_TO_SEND_MEMWRITE\0" /* 8044 */
	"SURF_SYNC_NEEDS_IDLE_CNTXS\0" /* 8076 */
	"SURF_SYNC_NEEDS_ALL_CLEAN\0" /* 8103 */
	"DC_BUSY\0" /* 8129 */
	"PFP_BUSY\0" /* 8137 */
	"MEQ_BUSY\0" /* 8146 */
	"ME_BUSY\0" /* 8155 */
	"QUERY_BUSY\0" /* 8163 */
	"SURFACE_SYNC_BUSY\0" /* 8174 */
	"RCIU_BUSY\0" /* 8192 */
	"CPC_CPG_BUSY\0" /* 8202 */
	"CE_BUSY\0" /* 8215 */
	"INSTANCE_INDEX\0" /* 8223 */
	"SH_INDEX\0" /* 8238 */
	"SE_INDEX\0" /* 8247 */
	"SH_BROADCAST_WRITES\0" /* 8256 */
	"INSTANCE_BROADCAST_WRITES\0" /* 8276 */
	"SE_BROADCAST_WRITES\0" /* 8302 */
	"PRIMGEN_EN\0" /* 8322, 8330 */
	"X_8K_DWORDS\0" /* 8333 */
	"X_4K_DWORDS\0" /* 8345 */
	"X_2K_DWORDS\0" /* 8357 */
	"X_1K_DWORDS\0" /* 8369 */
	"OFFCHIP_GRANULARITY\0" /* 8381 */
	"ENABLE_PA_SC_OUT_OF_ORDER\0" /* 8401 */
	"DISABLE_SC_DB_TILE_FIX\0" /* 8427 */
	"DISABLE_AA_MASK_FULL_FIX\0" /* 8450 */
	"ENABLE_1XMSAA_SAMPLE_LOCATIONS\0" /* 8475 */
	"ENABLE_1XMSAA_SAMPLE_LOC_CENTROID\0" /* 8506 */
	"DISABLE_SCISSOR_FIX\0" /* 8540 */
	"DISABLE_PW_BUBBLE_COLLAPSE\0" /* 8560 */
	"SEND_UNLIT_STILES_TO_PACKER\0" /* 8587 */
	"DISABLE_DUALGRAD_PERF_OPTIMIZATION\0" /* 8615 */
	"INST_INVALIDATE\0" /* 8650, 8655 */
	"DATA_INVALIDATE\0" /* 8666 */
	"INVALIDATE_VOLATILE\0" /* 8682 */
	"TARGET_INST\0" /* 8702 */
	"TARGET_DATA\0" /* 8714 */
	"WRITEBACK\0" /* 8726 */
	"VOL\0" /* 8736 */
	"COMPLETE\0" /* 8740 */
	"RET\0" /* 8749 */
	"RUI\0" /* 8753 */
	"RNG\0" /* 8757 */
	"SQ_EXP_MRT\0" /* 8761 */
	"SQ_EXP_MRTZ\0" /* 8772 */
	"SQ_EXP_NULL\0" /* 8784 */
	"SQ_EXP_POS\0" /* 8796 */
	"SQ_EXP_PARAM\0" /* 8807 */
	"TGT\0" /* 8820 */
	"COMPR\0" /* 8824 */
	"VM\0" /* 8830 */
	"SQ_ENC_EXP_FIELD\0" /* 8833 */
	"ENCODING\0" /* 8850 */
	"ADDRESS\0" /* 8859 */
	"COUNT_HI\0" /* 8867 */
	"BASE_ADDRESS_HI\0" /* 8881, 8876 */
	"STRIDE\0" /* 8892 */
	"CACHE_SWIZZLE\0" /* 8899 */
	"SWIZZLE_ENABLE\0" /* 8913 */
	"SQ_SEL_0\0" /* 8928 */
	"SQ_SEL_1\0" /* 8937 */
	"SQ_SEL_RESERVED_0\0" /* 8953, 8946 */
	"SQ_SEL_RESERVED_1\0" /* 8971, 8964 */
	"SQ_SEL_X\0" /* 8982 */
	"SQ_SEL_Y\0" /* 8991 */
	"SQ_SEL_Z\0" /* 9000 */
	"SQ_SEL_W\0" /* 9009 */
	"DST_SEL_X\0" /* 9018 */
	"DST_SEL_Y\0" /* 9028 */
	"DST_SEL_Z\0" /* 9038 */
	"DST_SEL_W\0" /* 9048 */
	"BUF_NUM_FORMAT_UNORM\0" /* 9058 */
	"BUF_NUM_FORMAT_SNORM\0" /* 9079 */
	"BUF_NUM_FORMAT_USCALED\0" /* 9100 */
	"BUF_NUM_FORMAT_SSCALED\0" /* 9123 */
	"BUF_NUM_FORMAT_UINT\0" /* 9146 */
	"BUF_NUM_FORMAT_SINT\0" /* 9166 */
	"BUF_NUM_FORMAT_SNORM_OGL\0" /* 9186 */
	"BUF_NUM_FORMAT_FLOAT\0" /* 9211 */
	"NUM_FORMAT\0" /* 9232, 9236 */
	"BUF_DATA_FORMAT_INVALID\0" /* 9243 */
	"BUF_DATA_FORMAT_8\0" /* 9267 */
	"BUF_DATA_FORMAT_16\0" /* 9285 */
	"BUF_DATA_FORMAT_8_8\0" /* 9304 */
	"BUF_DATA_FORMAT_32\0" /* 9324 */
	"BUF_DATA_FORMAT_16_16\0" /* 9343 */
	"BUF_DATA_FORMAT_10_11_11\0" /* 9365 */
	"BUF_DATA_FORMAT_11_11_10\0" /* 9390 */
	"BUF_DATA_FORMAT_10_10_10_2\0" /* 9415 */
	"BUF_DATA_FORMAT_2_10_10_10\0" /* 9442 */
	"BUF_DATA_FORMAT_8_8_8_8\0" /* 9469 */
	"BUF_DATA_FORMAT_32_32\0" /* 9493 */
	"BUF_DATA_FORMAT_16_16_16_16\0" /* 9515 */
	"BUF_DATA_FORMAT_32_32_32\0" /* 9543 */
	"BUF_DATA_FORMAT_32_32_32_32\0" /* 9568 */
	"BUF_DATA_FORMAT_RESERVED_15\0" /* 9596 */
	"DATA_FORMAT\0" /* 9624 */
	"ELEMENT_SIZE\0" /* 9636 */
	"INDEX_STRIDE\0" /* 9649 */
	"ADD_TID_ENABLE\0" /* 9662 */
	"ATC\0" /* 9677 */
	"HASH_ENABLE\0" /* 9681 */
	"HEAP\0" /* 9693 */
	"MTYPE\0" /* 9698 */
	"SQ_RSRC_BUF\0" /* 9704 */
	"SQ_RSRC_BUF_RSVD_1\0" /* 9716 */
	"SQ_RSRC_BUF_RSVD_2\0" /* 9735 */
	"SQ_RSRC_BUF_RSVD_3\0" /* 9754 */
	"USER_VM_ENABLE\0" /* 9773 */
	"USER_VM_MODE\0" /* 9796, 9788 */
	"NV\0" /* 9801 */
	"MIN_LOD\0" /* 9804 */
	"IMG_DATA_FORMAT_INVALID\0" /* 9812 */
	"IMG_DATA_FORMAT_8\0" /* 9836 */
	"IMG_DATA_FORMAT_16\0" /* 9854 */
	"IMG_DATA_FORMAT_8_8\0" /* 9873 */
	"IMG_DATA_FORMAT_32\0" /* 9893 */
	"IMG_DATA_FORMAT_16_16\0" /* 9912 */
	"IMG_DATA_FORMAT_10_11_11\0" /* 9934 */
	"IMG_DATA_FORMAT_11_11_10\0" /* 9959 */
	"IMG_DATA_FORMAT_10_10_10_2\0" /* 9984 */
	"IMG_DATA_FORMAT_2_10_10_10\0" /* 10011 */
	"IMG_DATA_FORMAT_8_8_8_8\0" /* 10038 */
	"IMG_DATA_FORMAT_32_32\0" /* 10062 */
	"IMG_DATA_FORMAT_16_16_16_16\0" /* 10084 */
	"IMG_DATA_FORMAT_32_32_32\0" /* 10112 */
	"IMG_DATA_FORMAT_32_32_32_32\0" /* 10137 */
	"IMG_DATA_FORMAT_RESERVED_15\0" /* 10165 */
	"IMG_DATA_FORMAT_5_6_5\0" /* 10193 */
	"IMG_DATA_FORMAT_1_5_5_5\0" /* 10215 */
	"IMG_DATA_FORMAT_5_5_5_1\0" /* 10239 */
	"IMG_DATA_FORMAT_4_4_4_4\0" /* 10263 */
	"IMG_DATA_FORMAT_8_24\0" /* 10287 */
	"IMG_DATA_FORMAT_24_8\0" /* 10308 */
	"IMG_DATA_FORMAT_X24_8_32\0" /* 10329 */
	"IMG_DATA_FORMAT_8_AS_8_8_8_8\0" /* 10354 */
	"IMG_DATA_FORMAT_ETC2_RGB\0" /* 10383 */
	"IMG_DATA_FORMAT_ETC2_RGBA\0" /* 10408 */
	"IMG_DATA_FORMAT_ETC2_R\0" /* 10434 */
	"IMG_DATA_FORMAT_ETC2_RG\0" /* 10457 */
	"IMG_DATA_FORMAT_ETC2_RGBA1\0" /* 10481 */
	"IMG_DATA_FORMAT_RESERVED_29\0" /* 10508 */
	"IMG_DATA_FORMAT_RESERVED_30\0" /* 10536 */
	"IMG_DATA_FORMAT_RESERVED_31\0" /* 10564 */
	"IMG_DATA_FORMAT_GB_GR\0" /* 10592 */
	"IMG_DATA_FORMAT_BG_RG\0" /* 10614 */
	"IMG_DATA_FORMAT_5_9_9_9\0" /* 10636 */
	"IMG_DATA_FORMAT_BC1\0" /* 10660 */
	"IMG_DATA_FORMAT_BC2\0" /* 10680 */
	"IMG_DATA_FORMAT_BC3\0" /* 10700 */
	"IMG_DATA_FORMAT_BC4\0" /* 10720 */
	"IMG_DATA_FORMAT_BC5\0" /* 10740 */
	"IMG_DATA_FORMAT_BC6\0" /* 10760 */
	"IMG_DATA_FORMAT_BC7\0" /* 10780 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX6\0" /* 10800 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX6\0" /* 10839 */
	"IMG_DATA_FORMAT_FMASK8_S2_F1\0" /* 10878 */
	"IMG_DATA_FORMAT_FMASK8_S4_F1\0" /* 10907 */
	"IMG_DATA_FORMAT_FMASK8_S8_F1\0" /* 10936 */
	"IMG_DATA_FORMAT_FMASK8_S2_F2\0" /* 10965 */
	"IMG_DATA_FORMAT_FMASK8_S4_F2\0" /* 10994 */
	"IMG_DATA_FORMAT_FMASK8_S4_F4\0" /* 11023 */
	"IMG_DATA_FORMAT_FMASK16_S16_F1\0" /* 11052 */
	"IMG_DATA_FORMAT_FMASK16_S8_F2\0" /* 11083 */
	"IMG_DATA_FORMAT_FMASK32_S16_F2\0" /* 11113 */
	"IMG_DATA_FORMAT_FMASK32_S8_F4\0" /* 11144 */
	"IMG_DATA_FORMAT_FMASK32_S8_F8\0" /* 11174 */
	"IMG_DATA_FORMAT_FMASK64_S16_F4\0" /* 11204 */
	"IMG_DATA_FORMAT_FMASK64_S16_F8\0" /* 11235 */
	"IMG_DATA_FORMAT_4_4\0" /* 11266 */
	"IMG_DATA_FORMAT_6_5_5\0" /* 11286 */
	"IMG_DATA_FORMAT_1\0" /* 11308 */
	"IMG_DATA_FORMAT_1_REVERSED\0" /* 11326 */
	"IMG_DATA_FORMAT_32_AS_8\0" /* 11353 */
	"IMG_DATA_FORMAT_32_AS_8_8\0" /* 11377 */
	"IMG_DATA_FORMAT_32_AS_32_32_32_32\0" /* 11403 */
	"DATA_FORMAT_GFX6\0" /* 11437 */
	"IMG_NUM_FORMAT_UNORM\0" /* 11454 */
	"IMG_NUM_FORMAT_SNORM\0" /* 11475 */
	"IMG_NUM_FORMAT_USCALED\0" /* 11496 */
	"IMG_NUM_FORMAT_SSCALED\0" /* 11519 */
	"IMG_NUM_FORMAT_UINT\0" /* 11542 */
	"IMG_NUM_FORMAT_SINT\0" /* 11562 */
	"IMG_NUM_FORMAT_SNORM_OGL\0" /* 11582 */
	"IMG_NUM_FORMAT_FLOAT\0" /* 11607 */
	"IMG_NUM_FORMAT_RESERVED_8\0" /* 11628 */
	"IMG_NUM_FORMAT_SRGB\0" /* 11654 */
	"IMG_NUM_FORMAT_UBNORM\0" /* 11674 */
	"IMG_NUM_FORMAT_UBNORM_OGL\0" /* 11696 */
	"IMG_NUM_FORMAT_UBINT\0" /* 11722 */
	"IMG_NUM_FORMAT_UBSCALED\0" /* 11743 */
	"IMG_NUM_FORMAT_RESERVED_14\0" /* 11767 */
	"IMG_NUM_FORMAT_RESERVED_15\0" /* 11794 */
	"NUM_FORMAT_GFX6\0" /* 11821 */
	"IMG_DATA_FORMAT_6E4\0" /* 11837 */
	"IMG_DATA_FORMAT_16_AS_32_32\0" /* 11857 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX9\0" /* 11885 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX9\0" /* 11924 */
	"IMG_DATA_FORMAT_FMASK\0" /* 11963 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR\0" /* 11985 */
	"IMG_DATA_FORMAT_ASTC_2D_HDR\0" /* 12013 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR_SRGB\0" /* 12041 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR\0" /* 12074 */
	"IMG_DATA_FORMAT_ASTC_3D_HDR\0" /* 12102 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR_SRGB\0" /* 12130 */
	"IMG_DATA_FORMAT_N_IN_16\0" /* 12163 */
	"IMG_DATA_FORMAT_N_IN_16_16\0" /* 12187 */
	"IMG_DATA_FORMAT_N_IN_16_16_16_16\0" /* 12214 */
	"IMG_DATA_FORMAT_N_IN_16_AS_16_16_16_16\0" /* 12247 */
	"IMG_DATA_FORMAT_RESERVED_56\0" /* 12286 */
	"IMG_DATA_S8_16\0" /* 12314 */
	"IMG_DATA_S8_32\0" /* 12329 */
	"IMG_DATA_FORMAT_8_AS_32\0" /* 12344 */
	"IMG_DATA_FORMAT_8_AS_32_32\0" /* 12368 */
	"DATA_FORMAT_GFX9\0" /* 12395 */
	"IMG_NUM_FORMAT_RESERVED_6\0" /* 12412 */
	"IMG_NUM_FORMAT_METADATA\0" /* 12438 */
	"IMG_NUM_FORMAT_UNORM_UINT\0" /* 12462 */
	"NUM_FORMAT_GFX9\0" /* 12488 */
	"IMG_FMASK_8_2_1\0" /* 12504 */
	"IMG_FMASK_8_4_1\0" /* 12520 */
	"IMG_FMASK_8_8_1\0" /* 12536 */
	"IMG_FMASK_8_2_2\0" /* 12552 */
	"IMG_FMASK_8_4_2\0" /* 12568 */
	"IMG_FMASK_8_4_4\0" /* 12584 */
	"IMG_FMASK_16_16_1\0" /* 12600 */
	"IMG_FMASK_16_8_2\0" /* 12618 */
	"IMG_FMASK_32_16_2\0" /* 12635 */
	"IMG_FMASK_32_8_4\0" /* 12653 */
	"IMG_FMASK_32_8_8\0" /* 12670 */
	"IMG_FMASK_64_16_4\0" /* 12687 */
	"IMG_FMASK_64_16_8\0" /* 12705 */
	"NUM_FORMAT_FMASK\0" /* 12723 */
	"IMG_ASTC_2D_4x4\0" /* 12740 */
	"IMG_ASTC_2D_5x4\0" /* 12756 */
	"IMG_ASTC_2D_5x5\0" /* 12772 */
	"IMG_ASTC_2D_6x5\0" /* 12788 */
	"IMG_ASTC_2D_6x6\0" /* 12804 */
	"IMG_ASTC_2D_8x5\0" /* 12820 */
	"IMG_ASTC_2D_8x6\0" /* 12836 */
	"IMG_ASTC_2D_8x8\0" /* 12852 */
	"IMG_ASTC_2D_10x5\0" /* 12868 */
	"IMG_ASTC_2D_10x6\0" /* 12885 */
	"IMG_ASTC_2D_10x8\0" /* 12902 */
	"IMG_ASTC_2D_10x10\0" /* 12919 */
	"IMG_ASTC_2D_12x10\0" /* 12937 */
	"IMG_ASTC_2D_12x12\0" /* 12955 */
	"NUM_FORMAT_ASTC_2D\0" /* 12973, 12989 */
	"IMG_ASTC_3D_3x3x3\0" /* 12992 */
	"IMG_ASTC_3D_4x3x3\0" /* 13010 */
	"IMG_ASTC_3D_4x4x3\0" /* 13028 */
	"IMG_ASTC_3D_4x4x4\0" /* 13046 */
	"IMG_ASTC_3D_5x4x4\0" /* 13064 */
	"IMG_ASTC_3D_5x5x4\0" /* 13082 */
	"IMG_ASTC_3D_5x5x5\0" /* 13100 */
	"IMG_ASTC_3D_6x5x5\0" /* 13118 */
	"IMG_ASTC_3D_6x6x5\0" /* 13136 */
	"IMG_ASTC_3D_6x6x6\0" /* 13154 */
	"NUM_FORMAT_ASTC_3D\0" /* 13188, 13172 */
	"META_DIRECT\0" /* 13191 */
	"WIDTH\0" /* 13203 */
	"HEIGHT\0" /* 13209 */
	"PERF_MOD\0" /* 13216 */
	"INTERLACED\0" /* 13225 */
	"BASE_LEVEL\0" /* 13236 */
	"LAST_LEVEL\0" /* 13247 */
	"TILING_INDEX\0" /* 13258 */
	"POW2_PAD\0" /* 13271 */
	"SQ_RSRC_IMG_RSVD_0\0" /* 13280 */
	"SQ_RSRC_IMG_RSVD_1\0" /* 13299 */
	"SQ_RSRC_IMG_RSVD_2\0" /* 13318 */
	"SQ_RSRC_IMG_RSVD_3\0" /* 13337 */
	"SQ_RSRC_IMG_RSVD_4\0" /* 13356 */
	"SQ_RSRC_IMG_RSVD_5\0" /* 13375 */
	"SQ_RSRC_IMG_RSVD_6\0" /* 13394 */
	"SQ_RSRC_IMG_RSVD_7\0" /* 13413 */
	"SQ_RSRC_IMG_1D\0" /* 13432, 13444 */
	"SQ_RSRC_IMG_2D\0" /* 13447 */
	"SQ_RSRC_IMG_3D\0" /* 13462 */
	"SQ_RSRC_IMG_CUBE\0" /* 13477 */
	"SQ_RSRC_IMG_1D_ARRAY\0" /* 13494 */
	"SQ_RSRC_IMG_2D_ARRAY\0" /* 13515 */
	"SQ_RSRC_IMG_2D_MSAA\0" /* 13536 */
	"SQ_RSRC_IMG_2D_MSAA_ARRAY\0" /* 13556 */
	"SW_MODE\0" /* 13582 */
	"DEPTH\0" /* 13590 */
	"PITCH_GFX6\0" /* 13596 */
	"PITCH_GFX9\0" /* 13607 */
	"BC_SWIZZLE_XYZW\0" /* 13618 */
	"BC_SWIZZLE_XWYZ\0" /* 13634 */
	"BC_SWIZZLE_WZYX\0" /* 13650 */
	"BC_SWIZZLE_WXYZ\0" /* 13666 */
	"BC_SWIZZLE_ZYXW\0" /* 13682 */
	"BC_SWIZZLE_YXWZ\0" /* 13698 */
	"BC_SWIZZLE\0" /* 13714 */
	"BASE_ARRAY\0" /* 13725 */
	"LAST_ARRAY\0" /* 13736 */
	"ARRAY_PITCH\0" /* 13747 */
	"META_DATA_ADDRESS\0" /* 13759 */
	"META_LINEAR\0" /* 13777, 13782 */
	"META_PIPE_ALIGNED\0" /* 13794, 13789 */
	"META_RB_ALIGNED\0" /* 13812, 13807 */
	"MAX_MIP\0" /* 13823 */
	"MIN_LOD_WARN\0" /* 13831 */
	"COUNTER_BANK_ID\0" /* 13844 */
	"LOD_HDW_CNT_EN\0" /* 13860 */
	"COMPRESSION_EN\0" /* 13875 */
	"ALPHA_IS_ON_MSB\0" /* 13890 */
	"COLOR_TRANSFORM\0" /* 13906 */
	"LOST_ALPHA_BITS\0" /* 13922 */
	"LOST_COLOR_BITS\0" /* 13938 */
	"SQ_TEX_WRAP\0" /* 13954 */
	"SQ_TEX_MIRROR\0" /* 13966 */
	"SQ_TEX_CLAMP_LAST_TEXEL\0" /* 13980 */
	"SQ_TEX_MIRROR_ONCE_LAST_TEXEL\0" /* 14004 */
	"SQ_TEX_CLAMP_HALF_BORDER\0" /* 14034 */
	"SQ_TEX_MIRROR_ONCE_HALF_BORDER\0" /* 14059 */
	"SQ_TEX_CLAMP_BORDER\0" /* 14090 */
	"SQ_TEX_MIRROR_ONCE_BORDER\0" /* 14110 */
	"CLAMP_X\0" /* 14136 */
	"CLAMP_Y\0" /* 14144 */
	"CLAMP_Z\0" /* 14152 */
	"MAX_ANISO_RATIO\0" /* 14160 */
	"SQ_TEX_DEPTH_COMPARE_NEVER\0" /* 14176 */
	"SQ_TEX_DEPTH_COMPARE_LESS\0" /* 14203 */
	"SQ_TEX_DEPTH_COMPARE_EQUAL\0" /* 14229 */
	"SQ_TEX_DEPTH_COMPARE_LESSEQUAL\0" /* 14256 */
	"SQ_TEX_DEPTH_COMPARE_GREATER\0" /* 14287 */
	"SQ_TEX_DEPTH_COMPARE_NOTEQUAL\0" /* 14316 */
	"SQ_TEX_DEPTH_COMPARE_GREATEREQUAL\0" /* 14346 */
	"SQ_TEX_DEPTH_COMPARE_ALWAYS\0" /* 14401, 14380 */
	"DEPTH_COMPARE_FUNC\0" /* 14408 */
	"FORCE_UNNORMALIZED\0" /* 14427 */
	"ANISO_THRESHOLD\0" /* 14446 */
	"MC_COORD_TRUNC\0" /* 14462 */
	"FORCE_DEGAMMA\0" /* 14477 */
	"ANISO_BIAS\0" /* 14491 */
	"TRUNC_COORD\0" /* 14502 */
	"DISABLE_CUBE_WRAP\0" /* 14514 */
	"FILTER_MODE\0" /* 14532 */
	"COMPAT_MODE\0" /* 14544 */
	"MAX_LOD\0" /* 14556 */
	"PERF_MIP\0" /* 14564 */
	"PERF_Z\0" /* 14573 */
	"LOD_BIAS\0" /* 14580 */
	"LOD_BIAS_SEC\0" /* 14589 */
	"SQ_TEX_XY_FILTER_POINT\0" /* 14616, 14602 */
	"SQ_TEX_XY_FILTER_BILINEAR\0" /* 14625 */
	"XY_MAG_FILTER\0" /* 14651 */
	"SQ_TEX_XY_FILTER_ANISO_POINT\0" /* 14665 */
	"SQ_TEX_XY_FILTER_ANISO_BILINEAR\0" /* 14694 */
	"XY_MIN_FILTER\0" /* 14726 */
	"SQ_TEX_Z_FILTER_NONE\0" /* 14740 */
	"SQ_TEX_Z_FILTER_POINT\0" /* 14761 */
	"SQ_TEX_Z_FILTER_LINEAR\0" /* 14783 */
	"Z_FILTER\0" /* 14806 */
	"MIP_FILTER\0" /* 14815 */
	"MIP_POINT_PRECLAMP\0" /* 14826 */
	"DISABLE_LSB_CEIL\0" /* 14845 */
	"FILTER_PREC_FIX\0" /* 14862 */
	"ANISO_OVERRIDE\0" /* 14878 */
	"BLEND_ZERO_PRT\0" /* 14893 */
	"BORDER_COLOR_PTR\0" /* 14908 */
	"SQ_TEX_BORDER_COLOR_TRANS_BLACK\0" /* 14925 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_BLACK\0" /* 14957 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_WHITE\0" /* 14990 */
	"SQ_TEX_BORDER_COLOR_REGISTER\0" /* 15023 */
	"BORDER_COLOR_TYPE\0" /* 15052 */
	"SKIP_DEGAMMA\0" /* 15070 */
	"VS_LOW_THRESHOLD\0" /* 15083 */
	"GS_LOW_THRESHOLD\0" /* 15100 */
	"ES_LOW_THRESHOLD\0" /* 15117 */
	"HS_LOW_THRESHOLD\0" /* 15134 */
	"LS_LOW_THRESHOLD\0" /* 15151 */
	"PS_CU_EN\0" /* 15168, 15171 */
	"VS_CU_EN\0" /* 15177 */
	"GS_CU_EN\0" /* 15186 */
	"ES_CU_EN\0" /* 15195 */
	"LSHS_CU_EN\0" /* 15204 */
	"MAX_WAVE_ID\0" /* 15215 */
	"X_R0\0" /* 15227 */
	"RING_ORDER_TS0\0" /* 15232 */
	"RING_ORDER_TS1\0" /* 15247 */
	"RING_ORDER_TS2\0" /* 15262 */
	"PIPE_ORDER_TS0\0" /* 15277 */
	"PIPE_ORDER_TS1\0" /* 15292 */
	"PIPE_ORDER_TS2\0" /* 15307 */
	"PIPE_ORDER_TS3\0" /* 15322 */
	"TS0_DUR_MULT\0" /* 15337 */
	"TS1_DUR_MULT\0" /* 15350 */
	"TS2_DUR_MULT\0" /* 15363 */
	"TS3_DUR_MULT\0" /* 15376 */
	"TS0_DURATION\0" /* 15389 */
	"TS1_DURATION\0" /* 15402 */
	"TS2_DURATION\0" /* 15415 */
	"GPR_WRITE_PRIORITY\0" /* 15428, 15438 */
	"EXP_PRIORITY_ORDER\0" /* 15447 */
	"ENABLE_SQG_TOP_EVENTS\0" /* 15466 */
	"ENABLE_SQG_BOP_EVENTS\0" /* 15488 */
	"RSRC_MGMT_RESET\0" /* 15510 */
	"X_DELAY_14_CLKS\0" /* 15526 */
	"X_DELAY_16_CLKS\0" /* 15542 */
	"X_DELAY_18_CLKS\0" /* 15558 */
	"X_DELAY_20_CLKS\0" /* 15574 */
	"X_DELAY_22_CLKS\0" /* 15590 */
	"X_DELAY_24_CLKS\0" /* 15606 */
	"X_DELAY_26_CLKS\0" /* 15622 */
	"X_DELAY_28_CLKS\0" /* 15638 */
	"X_DELAY_30_CLKS\0" /* 15654 */
	"X_DELAY_32_CLKS\0" /* 15670 */
	"X_DELAY_34_CLKS\0" /* 15686 */
	"X_DELAY_4_CLKS\0" /* 15702 */
	"X_DELAY_6_CLKS\0" /* 15717 */
	"X_DELAY_8_CLKS\0" /* 15732 */
	"X_DELAY_10_CLKS\0" /* 15747 */
	"X_DELAY_12_CLKS\0" /* 15763 */
	"VTX_DONE_DELAY\0" /* 15779 */
	"INTERP_ONE_PRIM_PER_ROW\0" /* 15794 */
	"PC_LIMIT_ENABLE\0" /* 15818 */
	"PC_LIMIT_STRICT\0" /* 15834 */
	"PC_LIMIT_SIZE\0" /* 15850 */
	"TYPE_A\0" /* 15864 */
	"VGPR_A\0" /* 15871 */
	"SGPR_A\0" /* 15878 */
	"LDS_A\0" /* 15885 */
	"WAVES_A\0" /* 15891 */
	"EN_A\0" /* 15899 */
	"TYPE_B\0" /* 15904 */
	"VGPR_B\0" /* 15911 */
	"SGPR_B\0" /* 15918 */
	"LDS_B\0" /* 15925 */
	"WAVES_B\0" /* 15931 */
	"EN_B\0" /* 15939 */
	"MSAA1_X\0" /* 15944 */
	"MSAA1_Y\0" /* 15952 */
	"MSAA2_X\0" /* 15960 */
	"MSAA2_Y\0" /* 15968 */
	"MSAA4_X\0" /* 15976 */
	"MSAA4_Y\0" /* 15984 */
	"MSAA8_X\0" /* 15992 */
	"MSAA8_Y\0" /* 16000 */
	"MSAA16_X\0" /* 16008 */
	"MSAA16_Y\0" /* 16017 */
	"NUM_PIPES\0" /* 16026 */
	"PIPE_INTERLEAVE_SIZE_GFX6\0" /* 16036 */
	"BANK_INTERLEAVE_SIZE\0" /* 16062 */
	"NUM_SHADER_ENGINES_GFX6\0" /* 16083 */
	"SHADER_ENGINE_TILE_SIZE\0" /* 16107 */
	"NUM_GPUS_GFX6\0" /* 16131 */
	"MULTI_GPU_TILE_SIZE\0" /* 16145 */
	"ROW_SIZE\0" /* 16165 */
	"NUM_LOWER_PIPES\0" /* 16174 */
	"PIPE_INTERLEAVE_SIZE_GFX9\0" /* 16190 */
	"MAX_COMPRESSED_FRAGS\0" /* 16216 */
	"NUM_BANKS\0" /* 16237 */
	"NUM_SHADER_ENGINES_GFX9\0" /* 16247 */
	"NUM_GPUS_GFX9\0" /* 16271 */
	"NUM_RB_PER_SE\0" /* 16285 */
	"SE_ENABLE\0" /* 16299 */
	"ADDR_SURF_DISPLAY_MICRO_TILING\0" /* 16309 */
	"ADDR_SURF_THIN_MICRO_TILING\0" /* 16340 */
	"ADDR_SURF_DEPTH_MICRO_TILING\0" /* 16368 */
	"ADDR_SURF_THICK_MICRO_TILING\0" /* 16397 */
	"MICRO_TILE_MODE\0" /* 16426 */
	"ARRAY_LINEAR_GENERAL\0" /* 16448, 16442 */
	"ARRAY_LINEAR_ALIGNED\0" /* 16463 */
	"ARRAY_1D_TILED_THIN1\0" /* 16484 */
	"ARRAY_1D_TILED_THICK\0" /* 16505 */
	"ARRAY_2D_TILED_THIN1\0" /* 16526 */
	"ARRAY_2D_TILED_THICK\0" /* 16547 */
	"ARRAY_2D_TILED_XTHICK\0" /* 16568 */
	"ARRAY_3D_TILED_THIN1\0" /* 16590 */
	"ARRAY_3D_TILED_THICK\0" /* 16611 */
	"ARRAY_3D_TILED_XTHICK\0" /* 16632 */
	"ARRAY_POWER_SAVE\0" /* 16654 */
	"ARRAY_MODE\0" /* 16671 */
	"ADDR_SURF_P2\0" /* 16682 */
	"ADDR_SURF_P2_RESERVED0\0" /* 16695 */
	"ADDR_SURF_P2_RESERVED1\0" /* 16718 */
	"ADDR_SURF_P2_RESERVED2\0" /* 16754, 16741 */
	"X_ADDR_SURF_P4_8X16\0" /* 16764 */
	"X_ADDR_SURF_P4_16X16\0" /* 16784 */
	"X_ADDR_SURF_P4_16X32\0" /* 16805 */
	"X_ADDR_SURF_P4_32X32\0" /* 16826 */
	"X_ADDR_SURF_P8_16X16_8X16\0" /* 16847 */
	"X_ADDR_SURF_P8_16X32_8X16\0" /* 16873 */
	"X_ADDR_SURF_P8_32X32_8X16\0" /* 16899 */
	"X_ADDR_SURF_P8_16X32_16X16\0" /* 16925 */
	"X_ADDR_SURF_P8_32X32_16X16\0" /* 16952 */
	"X_ADDR_SURF_P8_32X32_16X32\0" /* 16979 */
	"X_ADDR_SURF_P8_32X64_32X32\0" /* 17006 */
	"PIPE_CONFIG\0" /* 17033 */
	"ADDR_SURF_TILE_SPLIT_64B\0" /* 17045 */
	"ADDR_SURF_TILE_SPLIT_128B\0" /* 17070 */
	"ADDR_SURF_TILE_SPLIT_256B\0" /* 17096 */
	"ADDR_SURF_TILE_SPLIT_512B\0" /* 17122 */
	"ADDR_SURF_TILE_SPLIT_1KB\0" /* 17148 */
	"ADDR_SURF_TILE_SPLIT_2KB\0" /* 17173 */
	"ADDR_SURF_TILE_SPLIT_4KB\0" /* 17198 */
	"TILE_SPLIT\0" /* 17223 */
	"ADDR_SURF_BANK_WIDTH_1\0" /* 17234 */
	"ADDR_SURF_BANK_WIDTH_2\0" /* 17257 */
	"ADDR_SURF_BANK_WIDTH_4\0" /* 17280 */
	"ADDR_SURF_BANK_WIDTH_8\0" /* 17303 */
	"BANK_WIDTH\0" /* 17326 */
	"ADDR_SURF_BANK_HEIGHT_1\0" /* 17337 */
	"ADDR_SURF_BANK_HEIGHT_2\0" /* 17361 */
	"ADDR_SURF_BANK_HEIGHT_4\0" /* 17385 */
	"ADDR_SURF_BANK_HEIGHT_8\0" /* 17409 */
	"BANK_HEIGHT\0" /* 17433 */
	"ADDR_SURF_MACRO_ASPECT_1\0" /* 17445 */
	"ADDR_SURF_MACRO_ASPECT_2\0" /* 17470 */
	"ADDR_SURF_MACRO_ASPECT_4\0" /* 17495 */
	"ADDR_SURF_MACRO_ASPECT_8\0" /* 17520 */
	"MACRO_TILE_ASPECT\0" /* 17545 */
	"ADDR_SURF_2_BANK\0" /* 17563 */
	"ADDR_SURF_4_BANK\0" /* 17580 */
	"ADDR_SURF_8_BANK\0" /* 17597 */
	"ADDR_SURF_16_BANK\0" /* 17614 */
	"ADDR_SURF_ROTATED_MICRO_TILING\0" /* 17632 */
	"MICRO_TILE_MODE_NEW\0" /* 17663 */
	"SAMPLE_SPLIT\0" /* 17683 */
	"MEM_BASE\0" /* 17696 */
	"WAVE_LIMIT\0" /* 17705 */
	"LOCK_LOW_THRESHOLD\0" /* 17716 */
	"SIMD_DISABLE\0" /* 17735 */
	"VGPRS\0" /* 17748 */
	"SGPRS\0" /* 17754 */
	"FP_32_DENORMS\0" /* 17760 */
	"FP_64_DENORMS\0" /* 17774 */
	"FP_ALL_DENORMS\0" /* 17788 */
	"FLOAT_MODE\0" /* 17803 */
	"PRIV\0" /* 17814 */
	"DX10_CLAMP\0" /* 17819 */
	"DEBUG_MODE\0" /* 17830 */
	"IEEE_MODE\0" /* 17841 */
	"CU_GROUP_DISABLE\0" /* 17851 */
	"CACHE_CTL\0" /* 17868 */
	"CDBG_USER\0" /* 17878 */
	"FP16_OVFL\0" /* 17888 */
	"SCRATCH_EN\0" /* 17898 */
	"USER_SGPR\0" /* 17909 */
	"TRAP_PRESENT\0" /* 17919 */
	"WAVE_CNT_EN\0" /* 17932 */
	"EXTRA_LDS_SIZE\0" /* 17944, 17950 */
	"EXCP_EN_SI\0" /* 17959 */
	"EXCP_EN\0" /* 17970 */
	"LOAD_COLLISION_WAVEID\0" /* 17978 */
	"LOAD_INTRAWAVE_COLLISION\0" /* 18000 */
	"SKIP_USGPR0\0" /* 18025 */
	"USER_SGPR_MSB\0" /* 18037 */
	"VGPR_COMP_CNT\0" /* 18051, 18061 */
	"CU_GROUP_ENABLE\0" /* 18065 */
	"OC_LDS_EN\0" /* 18081 */
	"SO_BASE0_EN\0" /* 18091 */
	"SO_BASE1_EN\0" /* 18103 */
	"SO_BASE2_EN\0" /* 18115 */
	"SO_BASE3_EN\0" /* 18127 */
	"SO_EN\0" /* 18139 */
	"DISPATCH_DRAW_EN\0" /* 18145 */
	"PC_BASE_EN\0" /* 18162 */
	"GROUP_FIFO_DEPTH\0" /* 18173 */
	"GS_VGPR_COMP_CNT\0" /* 18190 */
	"ES_VGPR_COMP_CNT\0" /* 18207 */
	"LS_VGPR_COMP_CNT\0" /* 18224 */
	"TG_SIZE_EN\0" /* 18241 */
	"EXCP_EN_CIK_VI\0" /* 18252 */
	"COMPUTE_SHADER_EN\0" /* 18267 */
	"PARTIAL_TG_EN\0" /* 18285 */
	"FORCE_START_AT_000\0" /* 18299 */
	"ORDERED_APPEND_ENBL\0" /* 18318 */
	"ORDERED_APPEND_MODE\0" /* 18338 */
	"USE_THREAD_DIMENSIONS\0" /* 18358 */
	"ORDER_MODE\0" /* 18380 */
	"DISPATCH_CACHE_CNTL\0" /* 18391 */
	"SCALAR_L1_INV_VOL\0" /* 18411 */
	"VECTOR_L1_INV_VOL\0" /* 18429 */
	"DATA_ATC\0" /* 18447 */
	"RESTORE\0" /* 18456 */
	"NUM_THREAD_FULL\0" /* 18464 */
	"NUM_THREAD_PARTIAL\0" /* 18480 */
	"PIPELINESTAT_ENABLE\0" /* 18499 */
	"PERFCOUNT_ENABLE\0" /* 18519 */
	"INST_ATC\0" /* 18536 */
	"BULKY\0" /* 18545 */
	"TGID_X_EN\0" /* 18551 */
	"TGID_Y_EN\0" /* 18561 */
	"TGID_Z_EN\0" /* 18571 */
	"TIDIG_COMP_CNT\0" /* 18581 */
	"EXCP_EN_MSB\0" /* 18596 */
	"WAVES_PER_SH_SI\0" /* 18608 */
	"WAVES_PER_SH\0" /* 18624 */
	"TG_PER_CU\0" /* 18637 */
	"LOCK_THRESHOLD\0" /* 18647 */
	"SIMD_DEST_CNTL\0" /* 18662 */
	"FORCE_SIMD_DIST\0" /* 18677 */
	"CU_GROUP_COUNT\0" /* 18693 */
	"SH0_CU_EN\0" /* 18708 */
	"SH1_CU_EN\0" /* 18718 */
	"WAVES\0" /* 18728 */
	"WAVESIZE\0" /* 18734 */
	"SEND_SEID\0" /* 18743 */
	"RESERVED3\0" /* 18753 */
	"RESERVED4\0" /* 18763 */
	"WAVE_ID_BASE\0" /* 18773 */
	"PAYLOAD\0" /* 18786 */
	"IS_EVENT\0" /* 18794 */
	"IS_STATE\0" /* 18803 */
	"PERFCOUNTER_HI\0" /* 18812 */
	"PERF_SEL2\0" /* 18827 */
	"PERF_SEL3\0" /* 18837 */
	"CNTR_SEL2\0" /* 18847 */
	"CNTR_SEL3\0" /* 18857 */
	"CNTR_MODE3\0" /* 18867 */
	"CNTR_MODE2\0" /* 18878 */
	"PERF_SEL\0" /* 18889 */
	"PERF_SEL1\0" /* 18898 */
	"CNTR_MODE\0" /* 18908 */
	"CNTR_SEL0\0" /* 18918 */
	"CNTR_SEL1\0" /* 18928 */
	"SPM_MODE\0" /* 18938 */
	"CNTR_MODE1\0" /* 18947 */
	"CNTR_MODE0\0" /* 18958 */
	"DISABLE_AND_RESET\0" /* 18969 */
	"START_COUNTING\0" /* 18987 */
	"STOP_COUNTING\0" /* 19002 */
	"PERFMON_STATE\0" /* 19016 */
	"SPM_PERFMON_STATE\0" /* 19030 */
	"PERFMON_ENABLE_MODE\0" /* 19048 */
	"PERFMON_SAMPLE_ENABLE\0" /* 19068 */
	"DB_CLEAN_USER_DEFINED_MASK\0" /* 19090 */
	"CB_CLEAN_USER_DEFINED_MASK\0" /* 19117 */
	"VGT_BUSY_USER_DEFINED_MASK\0" /* 19144 */
	"TA_BUSY_USER_DEFINED_MASK\0" /* 19171 */
	"SX_BUSY_USER_DEFINED_MASK\0" /* 19197 */
	"SPI_BUSY_USER_DEFINED_MASK\0" /* 19223 */
	"SC_BUSY_USER_DEFINED_MASK\0" /* 19250 */
	"PA_BUSY_USER_DEFINED_MASK\0" /* 19276 */
	"GRBM_BUSY_USER_DEFINED_MASK\0" /* 19302 */
	"DB_BUSY_USER_DEFINED_MASK\0" /* 19330 */
	"CB_BUSY_USER_DEFINED_MASK\0" /* 19356 */
	"CP_BUSY_USER_DEFINED_MASK\0" /* 19382 */
	"IA_BUSY_USER_DEFINED_MASK\0" /* 19408 */
	"GDS_BUSY_USER_DEFINED_MASK\0" /* 19434 */
	"BCI_BUSY_USER_DEFINED_MASK\0" /* 19461 */
	"RLC_BUSY_USER_DEFINED_MASK\0" /* 19488 */
	"TC_BUSY_USER_DEFINED_MASK\0" /* 19515 */
	"WD_BUSY_USER_DEFINED_MASK\0" /* 19541 */
	"UTCL2_BUSY_USER_DEFINED_MASK\0" /* 19567 */
	"EA_BUSY_USER_DEFINED_MASK\0" /* 19596 */
	"RMI_BUSY_USER_DEFINED_MASK\0" /* 19622 */
	"PERF_MODE\0" /* 19649 */
	"PERF_MODE1\0" /* 19659 */
	"PERF_MODE3\0" /* 19670 */
	"PERF_MODE2\0" /* 19681 */
	"PERF_SEID_IGNORE_MASK\0" /* 19692 */
	"BIN0_MIN\0" /* 19714 */
	"BIN0_MAX\0" /* 19723 */
	"BIN1_MIN\0" /* 19732 */
	"BIN1_MAX\0" /* 19741 */
	"BIN2_MIN\0" /* 19750 */
	"BIN2_MAX\0" /* 19759 */
	"BIN3_MIN\0" /* 19768 */
	"BIN3_MAX\0" /* 19777 */
	"SQC_BANK_MASK\0" /* 19786 */
	"SQC_CLIENT_MASK\0" /* 19800 */
	"SIMD_MASK\0" /* 19816 */
	"PS_EN\0" /* 19826 */
	"VS_EN\0" /* 19832 */
	"GS_EN\0" /* 19838 */
	"ES_EN\0" /* 19844 */
	"HS_EN\0" /* 19850 */
	"LS_EN\0" /* 19856 */
	"CS_EN\0" /* 19862 */
	"CNTR_RATE\0" /* 19868 */
	"DISABLE_FLUSH\0" /* 19878 */
	"SH0_MASK\0" /* 19892 */
	"SH1_MASK\0" /* 19901 */
	"FORCE_EN\0" /* 19910 */
	"PERFCOUNTER_SELECT\0" /* 19919 */
	"PERFCOUNTER_SELECT1\0" /* 19938 */
	"PERFCOUNTER_SELECT2\0" /* 19958 */
	"PERFCOUNTER_SELECT3\0" /* 19978 */
	"OP_FILTER_ENABLE\0" /* 19998 */
	"OP_FILTER_SEL\0" /* 20015 */
	"FORMAT_FILTER_ENABLE\0" /* 20029 */
	"FORMAT_FILTER_SEL\0" /* 20050 */
	"CLEAR_FILTER_ENABLE\0" /* 20068 */
	"CLEAR_FILTER_SEL\0" /* 20088 */
	"MRT_FILTER_ENABLE\0" /* 20105 */
	"MRT_FILTER_SEL\0" /* 20123 */
	"NUM_SAMPLES_FILTER_ENABLE\0" /* 20138 */
	"NUM_SAMPLES_FILTER_SEL\0" /* 20164 */
	"NUM_FRAGMENTS_FILTER_ENABLE\0" /* 20187 */
	"NUM_FRAGMENTS_FILTER_SEL\0" /* 20215 */
	"DEPTH_CLEAR_ENABLE\0" /* 20240 */
	"STENCIL_CLEAR_ENABLE\0" /* 20259 */
	"DEPTH_COPY\0" /* 20280 */
	"STENCIL_COPY\0" /* 20291 */
	"RESUMMARIZE_ENABLE\0" /* 20304 */
	"STENCIL_COMPRESS_DISABLE\0" /* 20323 */
	"DEPTH_COMPRESS_DISABLE\0" /* 20348 */
	"COPY_CENTROID\0" /* 20371 */
	"COPY_SAMPLE\0" /* 20385 */
	"DECOMPRESS_ENABLE\0" /* 20397 */
	"ZPASS_INCREMENT_DISABLE\0" /* 20415 */
	"PERFECT_ZPASS_COUNTS\0" /* 20439 */
	"SAMPLE_RATE\0" /* 20460 */
	"ZPASS_ENABLE\0" /* 20472 */
	"ZFAIL_ENABLE\0" /* 20485 */
	"SFAIL_ENABLE\0" /* 20498 */
	"DBFAIL_ENABLE\0" /* 20511 */
	"SLICE_EVEN_ENABLE\0" /* 20525 */
	"SLICE_ODD_ENABLE\0" /* 20543 */
	"SLICE_START\0" /* 20560 */
	"SLICE_MAX\0" /* 20572 */
	"Z_READ_ONLY\0" /* 20582 */
	"STENCIL_READ_ONLY\0" /* 20594 */
	"MIPID\0" /* 20612 */
	"FORCE_OFF\0" /* 20618 */
	"FORCE_ENABLE\0" /* 20628 */
	"FORCE_DISABLE\0" /* 20641 */
	"FORCE_RESERVED\0" /* 20655 */
	"FORCE_HIZ_ENABLE\0" /* 20678, 20670 */
	"FORCE_HIS_ENABLE0\0" /* 20697, 20687 */
	"FORCE_HIS_ENABLE1\0" /* 20705, 20715 */
	"FORCE_SHADER_Z_ORDER\0" /* 20736, 20723 */
	"FAST_Z_DISABLE\0" /* 20744 */
	"FAST_STENCIL_DISABLE\0" /* 20759 */
	"NOOP_CULL_DISABLE\0" /* 20780 */
	"FORCE_COLOR_KILL\0" /* 20798 */
	"FORCE_Z_READ\0" /* 20815 */
	"FORCE_STENCIL_READ\0" /* 20828 */
	"FORCE_FULL_Z_RANGE\0" /* 20847 */
	"FORCE_QC_SMASK_CONFLICT\0" /* 20866 */
	"DISABLE_VIEWPORT_CLAMP\0" /* 20890 */
	"IGNORE_SC_ZRANGE\0" /* 20913 */
	"DISABLE_FULLY_COVERED\0" /* 20930 */
	"FORCE_SUMM_OFF\0" /* 20952 */
	"FORCE_SUMM_MINZ\0" /* 20967 */
	"FORCE_SUMM_MAXZ\0" /* 20983 */
	"FORCE_SUMM_BOTH\0" /* 20999 */
	"FORCE_Z_LIMIT_SUMM\0" /* 21015 */
	"MAX_TILES_IN_DTT\0" /* 21034 */
	"DISABLE_TILE_RATE_TILES\0" /* 21051 */
	"FORCE_Z_DIRTY\0" /* 21083, 21075 */
	"FORCE_STENCIL_DIRTY\0" /* 21089 */
	"FORCE_Z_VALID\0" /* 21109 */
	"FORCE_STENCIL_VALID\0" /* 21123 */
	"PRESERVE_COMPRESSION\0" /* 21152, 21143 */
	"PSLC_AUTO\0" /* 21164 */
	"PSLC_ON_HANG_ONLY\0" /* 21174 */
	"PSLC_ASAP\0" /* 21192 */
	"PSLC_COUNTDOWN\0" /* 21202 */
	"PARTIAL_SQUAD_LAUNCH_CONTROL\0" /* 21217 */
	"PARTIAL_SQUAD_LAUNCH_COUNTDOWN\0" /* 21246 */
	"DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION\0" /* 21277 */
	"DISABLE_SMEM_EXPCLEAR_OPTIMIZATION\0" /* 21313 */
	"DISABLE_COLOR_ON_VALIDATION\0" /* 21348 */
	"DECOMPRESS_Z_ON_FLUSH\0" /* 21376 */
	"DISABLE_REG_SNOOP\0" /* 21398 */
	"DEPTH_BOUNDS_HIER_DEPTH_DISABLE\0" /* 21416 */
	"SEPARATE_HIZS_FUNC_ENABLE\0" /* 21448 */
	"HIZ_ZFUNC\0" /* 21474, 21478 */
	"HIS_SFUNC_FF\0" /* 21484 */
	"HIS_SFUNC_BF\0" /* 21497 */
	"PRESERVE_ZRANGE\0" /* 21510 */
	"PRESERVE_SRESULTS\0" /* 21526 */
	"DISABLE_FAST_PASS\0" /* 21544 */
	"ALLOW_PARTIAL_RES_HIER_KILL\0" /* 21562 */
	"CLEAR\0" /* 21590 */
	"TL_X\0" /* 21596 */
	"TL_Y\0" /* 21601 */
	"BR_X\0" /* 21606 */
	"BR_Y\0" /* 21611 */
	"ADDR5_SWIZZLE_MASK\0" /* 21616 */
	"ARRAY_PRT_TILED_THIN1\0" /* 21635 */
	"ARRAY_PRT_2D_TILED_THIN1\0" /* 21657 */
	"X_ADDR_SURF_P16_32X32_8X16\0" /* 21682 */
	"X_ADDR_SURF_P16_32X32_16X16\0" /* 21709 */
	"Z_INVALID\0" /* 21737 */
	"Z_16\0" /* 21747 */
	"Z_24\0" /* 21752 */
	"Z_32_FLOAT\0" /* 21757 */
	"NUM_SAMPLES\0" /* 21768 */
	"TILE_MODE_INDEX\0" /* 21780 */
	"DECOMPRESS_ON_N_ZPLANES\0" /* 21796 */
	"ALLOW_EXPCLEAR\0" /* 21820 */
	"READ_SIZE\0" /* 21835 */
	"TILE_SURFACE_ENABLE\0" /* 21845 */
	"CLEAR_DISALLOWED\0" /* 21865 */
	"ZRANGE_PRECISION\0" /* 21882 */
	"STENCIL_INVALID\0" /* 21899 */
	"STENCIL_8\0" /* 21915 */
	"TILE_STENCIL_DISABLE\0" /* 21925 */
	"PITCH_TILE_MAX\0" /* 21952, 21946 */
	"HEIGHT_TILE_MAX\0" /* 21961 */
	"SLICE_TILE_MAX\0" /* 21977 */
	"DEST_BASE_HI_256B\0" /* 21992 */
	"WINDOW_X_OFFSET\0" /* 22017, 22010 */
	"WINDOW_Y_OFFSET\0" /* 22033, 22026 */
	"WINDOW_OFFSET_DISABLE\0" /* 22042 */
	"CLIP_RULE\0" /* 22064 */
	"ER_TRI\0" /* 22074 */
	"ER_RECT\0" /* 22081 */
	"ER_LINE_LR\0" /* 22089 */
	"ER_LINE_RL\0" /* 22100 */
	"ER_LINE_TB\0" /* 22111 */
	"ER_LINE_BT\0" /* 22122 */
	"HW_SCREEN_OFFSET_X\0" /* 22133 */
	"HW_SCREEN_OFFSET_Y\0" /* 22152 */
	"TARGET0_ENABLE\0" /* 22171 */
	"TARGET1_ENABLE\0" /* 22186 */
	"TARGET2_ENABLE\0" /* 22201 */
	"TARGET3_ENABLE\0" /* 22216 */
	"TARGET4_ENABLE\0" /* 22231 */
	"TARGET5_ENABLE\0" /* 22246 */
	"TARGET6_ENABLE\0" /* 22261 */
	"TARGET7_ENABLE\0" /* 22276 */
	"OUTPUT0_ENABLE\0" /* 22291 */
	"OUTPUT1_ENABLE\0" /* 22306 */
	"OUTPUT2_ENABLE\0" /* 22321 */
	"OUTPUT3_ENABLE\0" /* 22336 */
	"OUTPUT4_ENABLE\0" /* 22351 */
	"OUTPUT5_ENABLE\0" /* 22366 */
	"OUTPUT6_ENABLE\0" /* 22381 */
	"OUTPUT7_ENABLE\0" /* 22396 */
	"RASTER_CONFIG_RB_MAP_0\0" /* 22411 */
	"RASTER_CONFIG_RB_MAP_1\0" /* 22434 */
	"RASTER_CONFIG_RB_MAP_2\0" /* 22457 */
	"RASTER_CONFIG_RB_MAP_3\0" /* 22480 */
	"RB_MAP_PKR0\0" /* 22503 */
	"RB_MAP_PKR1\0" /* 22515 */
	"RASTER_CONFIG_RB_XSEL2_0\0" /* 22527 */
	"RASTER_CONFIG_RB_XSEL2_1\0" /* 22552 */
	"RASTER_CONFIG_RB_XSEL2_2\0" /* 22577 */
	"RASTER_CONFIG_RB_XSEL2_3\0" /* 22602 */
	"RB_XSEL2\0" /* 22627 */
	"RB_XSEL\0" /* 22636 */
	"RB_YSEL\0" /* 22644 */
	"RASTER_CONFIG_PKR_MAP_0\0" /* 22652 */
	"RASTER_CONFIG_PKR_MAP_1\0" /* 22676 */
	"RASTER_CONFIG_PKR_MAP_2\0" /* 22700 */
	"RASTER_CONFIG_PKR_MAP_3\0" /* 22724 */
	"PKR_MAP\0" /* 22748 */
	"RASTER_CONFIG_PKR_XSEL_0\0" /* 22756 */
	"RASTER_CONFIG_PKR_XSEL_1\0" /* 22781 */
	"RASTER_CONFIG_PKR_XSEL_2\0" /* 22806 */
	"RASTER_CONFIG_PKR_XSEL_3\0" /* 22831 */
	"PKR_XSEL\0" /* 22856 */
	"RASTER_CONFIG_PKR_YSEL_0\0" /* 22865 */
	"RASTER_CONFIG_PKR_YSEL_1\0" /* 22890 */
	"RASTER_CONFIG_PKR_YSEL_2\0" /* 22915 */
	"RASTER_CONFIG_PKR_YSEL_3\0" /* 22940 */
	"PKR_YSEL\0" /* 22965 */
	"RASTER_CONFIG_PKR_XSEL2_0\0" /* 22974 */
	"RASTER_CONFIG_PKR_XSEL2_1\0" /* 23000 */
	"RASTER_CONFIG_PKR_XSEL2_2\0" /* 23026 */
	"RASTER_CONFIG_PKR_XSEL2_3\0" /* 23052 */
	"PKR_XSEL2\0" /* 23078 */
	"RASTER_CONFIG_SC_MAP_0\0" /* 23088 */
	"RASTER_CONFIG_SC_MAP_1\0" /* 23111 */
	"RASTER_CONFIG_SC_MAP_2\0" /* 23134 */
	"RASTER_CONFIG_SC_MAP_3\0" /* 23157 */
	"SC_MAP\0" /* 23180 */
	"RASTER_CONFIG_SC_XSEL_8_WIDE_TILE\0" /* 23187 */
	"RASTER_CONFIG_SC_XSEL_16_WIDE_TILE\0" /* 23221 */
	"RASTER_CONFIG_SC_XSEL_32_WIDE_TILE\0" /* 23256 */
	"RASTER_CONFIG_SC_XSEL_64_WIDE_TILE\0" /* 23291 */
	"SC_XSEL\0" /* 23326 */
	"RASTER_CONFIG_SC_YSEL_8_WIDE_TILE\0" /* 23334 */
	"RASTER_CONFIG_SC_YSEL_16_WIDE_TILE\0" /* 23368 */
	"RASTER_CONFIG_SC_YSEL_32_WIDE_TILE\0" /* 23403 */
	"RASTER_CONFIG_SC_YSEL_64_WIDE_TILE\0" /* 23438 */
	"SC_YSEL\0" /* 23473 */
	"RASTER_CONFIG_SE_MAP_0\0" /* 23481 */
	"RASTER_CONFIG_SE_MAP_1\0" /* 23504 */
	"RASTER_CONFIG_SE_MAP_2\0" /* 23527 */
	"RASTER_CONFIG_SE_MAP_3\0" /* 23550 */
	"SE_MAP\0" /* 23573 */
	"RASTER_CONFIG_SE_XSEL_8_WIDE_TILE\0" /* 23580 */
	"RASTER_CONFIG_SE_XSEL_16_WIDE_TILE\0" /* 23614 */
	"RASTER_CONFIG_SE_XSEL_32_WIDE_TILE\0" /* 23649 */
	"RASTER_CONFIG_SE_XSEL_64_WIDE_TILE\0" /* 23684 */
	"SE_XSEL_GFX6\0" /* 23719 */
	"RASTER_CONFIG_SE_YSEL_8_WIDE_TILE\0" /* 23732 */
	"RASTER_CONFIG_SE_YSEL_16_WIDE_TILE\0" /* 23766 */
	"RASTER_CONFIG_SE_YSEL_32_WIDE_TILE\0" /* 23801 */
	"RASTER_CONFIG_SE_YSEL_64_WIDE_TILE\0" /* 23836 */
	"SE_YSEL_GFX6\0" /* 23871 */
	"SE_XSEL_GFX9\0" /* 23884 */
	"SE_YSEL_GFX9\0" /* 23897 */
	"RASTER_CONFIG_SE_PAIR_MAP_0\0" /* 23910 */
	"RASTER_CONFIG_SE_PAIR_MAP_1\0" /* 23938 */
	"RASTER_CONFIG_SE_PAIR_MAP_2\0" /* 23966 */
	"RASTER_CONFIG_SE_PAIR_MAP_3\0" /* 23994 */
	"SE_PAIR_MAP\0" /* 24022 */
	"RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE\0" /* 24034 */
	"RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE\0" /* 24073 */
	"RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE\0" /* 24113 */
	"RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE\0" /* 24153 */
	"SE_PAIR_XSEL_GFX6\0" /* 24193 */
	"RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE\0" /* 24211 */
	"RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE\0" /* 24250 */
	"RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE\0" /* 24290 */
	"RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE\0" /* 24330 */
	"SE_PAIR_YSEL_GFX6\0" /* 24370 */
	"SE_PAIR_XSEL_GFX9\0" /* 24388 */
	"SE_PAIR_YSEL_GFX9\0" /* 24406 */
	"OVERWRITE_COMBINER_DISABLE\0" /* 24424 */
	"OVERWRITE_COMBINER_MRT_SHARING_DISABLE\0" /* 24451 */
	"OVERWRITE_COMBINER_WATERMARK\0" /* 24490 */
	"STENCIL_KEEP\0" /* 24519 */
	"STENCIL_ZERO\0" /* 24532 */
	"STENCIL_ONES\0" /* 24545 */
	"STENCIL_REPLACE_TEST\0" /* 24558 */
	"STENCIL_REPLACE_OP\0" /* 24579 */
	"STENCIL_ADD_CLAMP\0" /* 24598 */
	"STENCIL_SUB_CLAMP\0" /* 24616 */
	"STENCIL_INVERT\0" /* 24634 */
	"STENCIL_ADD_WRAP\0" /* 24649 */
	"STENCIL_SUB_WRAP\0" /* 24666 */
	"STENCIL_AND\0" /* 24683 */
	"STENCIL_OR\0" /* 24695 */
	"STENCIL_XOR\0" /* 24706 */
	"STENCIL_NAND\0" /* 24718 */
	"STENCIL_NOR\0" /* 24731 */
	"STENCIL_XNOR\0" /* 24743 */
	"STENCILFAIL\0" /* 24756 */
	"STENCILZPASS\0" /* 24768 */
	"STENCILZFAIL\0" /* 24781 */
	"STENCILFAIL_BF\0" /* 24794 */
	"STENCILZPASS_BF\0" /* 24809 */
	"STENCILZFAIL_BF\0" /* 24825 */
	"STENCILTESTVAL\0" /* 24841 */
	"STENCILMASK\0" /* 24856 */
	"STENCILWRITEMASK\0" /* 24868 */
	"STENCILOPVAL\0" /* 24885 */
	"STENCILTESTVAL_BF\0" /* 24898 */
	"STENCILMASK_BF\0" /* 24916 */
	"STENCILWRITEMASK_BF\0" /* 24931 */
	"STENCILOPVAL_BF\0" /* 24951 */
	"X_0_0F\0" /* 24967 */
	"DEFAULT_VAL\0" /* 24974 */
	"FLAT_SHADE\0" /* 24986 */
	"CYL_WRAP\0" /* 24997 */
	"PT_SPRITE_TEX\0" /* 25006 */
	"DUP\0" /* 25020 */
	"FP16_INTERP_MODE\0" /* 25024 */
	"USE_DEFAULT_ATTR1\0" /* 25041 */
	"DEFAULT_VAL_ATTR1\0" /* 25059 */
	"PT_SPRITE_TEX_ATTR1\0" /* 25077 */
	"ATTR0_VALID\0" /* 25097 */
	"ATTR1_VALID\0" /* 25109 */
	"VS_EXPORT_COUNT\0" /* 25121 */
	"VS_HALF_PACK\0" /* 25137 */
	"VS_EXPORTS_FOG\0" /* 25150 */
	"VS_OUT_FOG_VEC_ADDR\0" /* 25165 */
	"PERSP_SAMPLE_ENA\0" /* 25185 */
	"PERSP_CENTER_ENA\0" /* 25202 */
	"PERSP_CENTROID_ENA\0" /* 25219 */
	"PERSP_PULL_MODEL_ENA\0" /* 25238 */
	"LINEAR_SAMPLE_ENA\0" /* 25259 */
	"LINEAR_CENTER_ENA\0" /* 25277 */
	"LINEAR_CENTROID_ENA\0" /* 25295 */
	"LINE_STIPPLE_TEX_ENA\0" /* 25315 */
	"POS_X_FLOAT_ENA\0" /* 25336 */
	"POS_Y_FLOAT_ENA\0" /* 25352 */
	"POS_Z_FLOAT_ENA\0" /* 25368 */
	"POS_W_FLOAT_ENA\0" /* 25384 */
	"FRONT_FACE_ENA\0" /* 25400 */
	"ANCILLARY_ENA\0" /* 25415 */
	"SAMPLE_COVERAGE_ENA\0" /* 25429 */
	"POS_FIXED_PT_ENA\0" /* 25449 */
	"FLAT_SHADE_ENA\0" /* 25466 */
	"PNT_SPRITE_ENA\0" /* 25481 */
	"SPI_PNT_SPRITE_SEL_0\0" /* 25496 */
	"SPI_PNT_SPRITE_SEL_1\0" /* 25517 */
	"SPI_PNT_SPRITE_SEL_S\0" /* 25538 */
	"SPI_PNT_SPRITE_SEL_T\0" /* 25559 */
	"SPI_PNT_SPRITE_SEL_NONE\0" /* 25580 */
	"PNT_SPRITE_OVRD_X\0" /* 25604 */
	"PNT_SPRITE_OVRD_Y\0" /* 25622 */
	"PNT_SPRITE_OVRD_Z\0" /* 25640 */
	"PNT_SPRITE_OVRD_W\0" /* 25658 */
	"PNT_SPRITE_TOP_1\0" /* 25676 */
	"NUM_INTERP\0" /* 25693 */
	"PARAM_GEN\0" /* 25704 */
	"FOG_ADDR\0" /* 25714 */
	"BC_OPTIMIZE_DISABLE\0" /* 25723 */
	"PASS_FOG_THROUGH_PS\0" /* 25743 */
	"OFFCHIP_PARAM_EN\0" /* 25763 */
	"LATE_PC_DEALLOC\0" /* 25780 */
	"PERSP_CENTER_CNTL\0" /* 25796 */
	"PERSP_CENTROID_CNTL\0" /* 25814 */
	"LINEAR_CENTER_CNTL\0" /* 25834 */
	"LINEAR_CENTROID_CNTL\0" /* 25853 */
	"X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT\0" /* 25874 */
	"POS_FLOAT_LOCATION\0" /* 25923 */
	"POS_FLOAT_ULC\0" /* 25942 */
	"FRONT_FACE_ALL_BITS\0" /* 25956 */
	"NUM_PS_WAVES\0" /* 25976 */
	"NUM_VS_WAVES\0" /* 25989 */
	"NUM_GS_WAVES\0" /* 26002 */
	"NUM_ES_WAVES\0" /* 26015 */
	"NUM_HS_WAVES\0" /* 26028 */
	"NUM_LS_WAVES\0" /* 26041 */
	"SPI_SHADER_NONE\0" /* 26054 */
	"SPI_SHADER_1COMP\0" /* 26070 */
	"SPI_SHADER_2COMP\0" /* 26087 */
	"SPI_SHADER_4COMPRESS\0" /* 26104 */
	"SPI_SHADER_4COMP\0" /* 26125 */
	"POS0_EXPORT_FORMAT\0" /* 26142 */
	"POS1_EXPORT_FORMAT\0" /* 26161 */
	"POS2_EXPORT_FORMAT\0" /* 26180 */
	"POS3_EXPORT_FORMAT\0" /* 26199 */
	"SPI_SHADER_ZERO\0" /* 26218 */
	"SPI_SHADER_32_R\0" /* 26234 */
	"SPI_SHADER_32_GR\0" /* 26250 */
	"SPI_SHADER_32_AR\0" /* 26267 */
	"SPI_SHADER_FP16_ABGR\0" /* 26284 */
	"SPI_SHADER_UNORM16_ABGR\0" /* 26305 */
	"SPI_SHADER_SNORM16_ABGR\0" /* 26329 */
	"SPI_SHADER_UINT16_ABGR\0" /* 26353 */
	"SPI_SHADER_SINT16_ABGR\0" /* 26376 */
	"SPI_SHADER_32_ABGR\0" /* 26399 */
	"Z_EXPORT_FORMAT\0" /* 26418 */
	"COL0_EXPORT_FORMAT\0" /* 26434 */
	"COL1_EXPORT_FORMAT\0" /* 26453 */
	"COL2_EXPORT_FORMAT\0" /* 26472 */
	"COL3_EXPORT_FORMAT\0" /* 26491 */
	"COL4_EXPORT_FORMAT\0" /* 26510 */
	"COL5_EXPORT_FORMAT\0" /* 26529 */
	"COL6_EXPORT_FORMAT\0" /* 26548 */
	"COL7_EXPORT_FORMAT\0" /* 26567 */
	"SX_RT_EXPORT_NO_CONVERSION\0" /* 26586 */
	"SX_RT_EXPORT_32_R\0" /* 26613 */
	"SX_RT_EXPORT_32_A\0" /* 26631 */
	"SX_RT_EXPORT_10_11_11\0" /* 26649 */
	"SX_RT_EXPORT_2_10_10_10\0" /* 26671 */
	"SX_RT_EXPORT_8_8_8_8\0" /* 26695 */
	"SX_RT_EXPORT_5_6_5\0" /* 26716 */
	"SX_RT_EXPORT_1_5_5_5\0" /* 26735 */
	"SX_RT_EXPORT_4_4_4_4\0" /* 26756 */
	"SX_RT_EXPORT_16_16_GR\0" /* 26777 */
	"SX_RT_EXPORT_16_16_AR\0" /* 26799 */
	"MRT0\0" /* 26821 */
	"MRT1\0" /* 26826 */
	"MRT2\0" /* 26831 */
	"MRT3\0" /* 26836 */
	"MRT4\0" /* 26841 */
	"MRT5\0" /* 26846 */
	"MRT6\0" /* 26851 */
	"MRT7\0" /* 26856 */
	"EXACT\0" /* 26861 */
	"11BIT_FORMAT\0" /* 26867 */
	"10BIT_FORMAT\0" /* 26880 */
	"8BIT_FORMAT\0" /* 26893 */
	"6BIT_FORMAT\0" /* 26905 */
	"5BIT_FORMAT\0" /* 26917 */
	"4BIT_FORMAT\0" /* 26929 */
	"MRT0_EPSILON\0" /* 26941 */
	"MRT1_EPSILON\0" /* 26954 */
	"MRT2_EPSILON\0" /* 26967 */
	"MRT3_EPSILON\0" /* 26980 */
	"MRT4_EPSILON\0" /* 26993 */
	"MRT5_EPSILON\0" /* 27006 */
	"MRT6_EPSILON\0" /* 27019 */
	"MRT7_EPSILON\0" /* 27032 */
	"MRT0_COLOR_OPT_DISABLE\0" /* 27045 */
	"MRT0_ALPHA_OPT_DISABLE\0" /* 27068 */
	"MRT1_COLOR_OPT_DISABLE\0" /* 27091 */
	"MRT1_ALPHA_OPT_DISABLE\0" /* 27114 */
	"MRT2_COLOR_OPT_DISABLE\0" /* 27137 */
	"MRT2_ALPHA_OPT_DISABLE\0" /* 27160 */
	"MRT3_COLOR_OPT_DISABLE\0" /* 27183 */
	"MRT3_ALPHA_OPT_DISABLE\0" /* 27206 */
	"MRT4_COLOR_OPT_DISABLE\0" /* 27229 */
	"MRT4_ALPHA_OPT_DISABLE\0" /* 27252 */
	"MRT5_COLOR_OPT_DISABLE\0" /* 27275 */
	"MRT5_ALPHA_OPT_DISABLE\0" /* 27298 */
	"MRT6_COLOR_OPT_DISABLE\0" /* 27321 */
	"MRT6_ALPHA_OPT_DISABLE\0" /* 27344 */
	"MRT7_COLOR_OPT_DISABLE\0" /* 27367 */
	"MRT7_ALPHA_OPT_DISABLE\0" /* 27390 */
	"PIXEN_ZERO_OPT_DISABLE\0" /* 27413 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_ALL\0" /* 27436 */
	"BLEND_OPT_PRESERVE_ALL_IGNORE_NONE\0" /* 27471 */
	"BLEND_OPT_PRESERVE_C1_IGNORE_C0\0" /* 27506 */
	"BLEND_OPT_PRESERVE_C0_IGNORE_C1\0" /* 27538 */
	"BLEND_OPT_PRESERVE_A1_IGNORE_A0\0" /* 27570 */
	"BLEND_OPT_PRESERVE_A0_IGNORE_A1\0" /* 27602 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_A0\0" /* 27634 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_NONE\0" /* 27668 */
	"COLOR_SRC_OPT\0" /* 27704 */
	"COLOR_DST_OPT\0" /* 27718 */
	"OPT_COMB_NONE\0" /* 27732 */
	"OPT_COMB_ADD\0" /* 27746 */
	"OPT_COMB_SUBTRACT\0" /* 27759 */
	"OPT_COMB_MIN\0" /* 27777 */
	"OPT_COMB_MAX\0" /* 27790 */
	"OPT_COMB_REVSUBTRACT\0" /* 27803 */
	"OPT_COMB_BLEND_DISABLED\0" /* 27824 */
	"OPT_COMB_SAFE_ADD\0" /* 27848 */
	"COLOR_COMB_FCN\0" /* 27866 */
	"ALPHA_SRC_OPT\0" /* 27881 */
	"ALPHA_DST_OPT\0" /* 27895 */
	"ALPHA_COMB_FCN\0" /* 27909 */
	"BLEND_ZERO\0" /* 27924 */
	"BLEND_ONE\0" /* 27935 */
	"BLEND_SRC_COLOR\0" /* 27945 */
	"BLEND_ONE_MINUS_SRC_COLOR\0" /* 27961 */
	"BLEND_SRC_ALPHA\0" /* 27987 */
	"BLEND_ONE_MINUS_SRC_ALPHA\0" /* 28003 */
	"BLEND_DST_ALPHA\0" /* 28029 */
	"BLEND_ONE_MINUS_DST_ALPHA\0" /* 28045 */
	"BLEND_DST_COLOR\0" /* 28071 */
	"BLEND_ONE_MINUS_DST_COLOR\0" /* 28087 */
	"BLEND_SRC_ALPHA_SATURATE\0" /* 28113 */
	"BLEND_CONSTANT_COLOR\0" /* 28138 */
	"BLEND_ONE_MINUS_CONSTANT_COLOR\0" /* 28159 */
	"BLEND_SRC1_COLOR\0" /* 28190 */
	"BLEND_INV_SRC1_COLOR\0" /* 28207 */
	"BLEND_SRC1_ALPHA\0" /* 28228 */
	"BLEND_INV_SRC1_ALPHA\0" /* 28245 */
	"BLEND_CONSTANT_ALPHA\0" /* 28266 */
	"BLEND_ONE_MINUS_CONSTANT_ALPHA\0" /* 28287 */
	"COLOR_SRCBLEND\0" /* 28318 */
	"COMB_DST_PLUS_SRC\0" /* 28333 */
	"COMB_SRC_MINUS_DST\0" /* 28351 */
	"COMB_MIN_DST_SRC\0" /* 28370 */
	"COMB_MAX_DST_SRC\0" /* 28387 */
	"COMB_DST_MINUS_SRC\0" /* 28404 */
	"COLOR_DESTBLEND\0" /* 28423 */
	"ALPHA_SRCBLEND\0" /* 28439 */
	"ALPHA_DESTBLEND\0" /* 28454 */
	"SEPARATE_ALPHA_BLEND\0" /* 28470 */
	"DISABLE_ROP3\0" /* 28499, 28491 */
	"SRC_STATE_ID\0" /* 28504 */
	"BASE_ADDR_GFX6\0" /* 28517 */
	"BASE_ADDR_GFX9\0" /* 28532 */
	"DI_SRC_SEL_DMA\0" /* 28547 */
	"DI_SRC_SEL_IMMEDIATE\0" /* 28562 */
	"DI_SRC_SEL_AUTO_INDEX\0" /* 28583 */
	"DI_SRC_SEL_RESERVED\0" /* 28605 */
	"SOURCE_SELECT\0" /* 28625 */
	"DI_MAJOR_MODE_0\0" /* 28639 */
	"DI_MAJOR_MODE_1\0" /* 28655 */
	"MAJOR_MODE\0" /* 28671 */
	"NOT_EOP\0" /* 28682 */
	"USE_OPAQUE\0" /* 28690 */
	"SPRITE_EN_R6XX\0" /* 28701 */
	"UNROLLED_INST\0" /* 28716 */
	"GRBM_SKEW_NO_DEC\0" /* 28730 */
	"REG_RT_INDEX\0" /* 28747 */
	"ADDRESS_LOW\0" /* 28760 */
	"STENCIL_ENABLE\0" /* 28772 */
	"Z_WRITE_ENABLE\0" /* 28787 */
	"DEPTH_BOUNDS_ENABLE\0" /* 28802 */
	"FRAG_NEVER\0" /* 28822 */
	"FRAG_LESS\0" /* 28833 */
	"FRAG_EQUAL\0" /* 28843 */
	"FRAG_LEQUAL\0" /* 28854 */
	"FRAG_GREATER\0" /* 28866 */
	"FRAG_NOTEQUAL\0" /* 28879 */
	"FRAG_GEQUAL\0" /* 28893 */
	"FRAG_ALWAYS\0" /* 28905 */
	"BACKFACE_ENABLE\0" /* 28917 */
	"REF_NEVER\0" /* 28933 */
	"REF_LESS\0" /* 28943 */
	"REF_EQUAL\0" /* 28952 */
	"REF_LEQUAL\0" /* 28962 */
	"REF_GREATER\0" /* 28973 */
	"REF_NOTEQUAL\0" /* 28985 */
	"REF_GEQUAL\0" /* 28998 */
	"REF_ALWAYS\0" /* 29009 */
	"STENCILFUNC\0" /* 29020 */
	"STENCILFUNC_BF\0" /* 29032 */
	"ENABLE_COLOR_WRITES_ON_DEPTH_FAIL\0" /* 29047 */
	"DISABLE_COLOR_WRITES_ON_DEPTH_PASS\0" /* 29081 */
	"MAX_ANCHOR_SAMPLES\0" /* 29116 */
	"PS_ITER_SAMPLES\0" /* 29135 */
	"MASK_EXPORT_NUM_SAMPLES\0" /* 29151 */
	"ALPHA_TO_MASK_NUM_SAMPLES\0" /* 29175 */
	"HIGH_QUALITY_INTERSECTIONS\0" /* 29201 */
	"INCOHERENT_EQAA_READS\0" /* 29228 */
	"INTERPOLATE_COMP_Z\0" /* 29250 */
	"INTERPOLATE_SRC_Z\0" /* 29269 */
	"STATIC_ANCHOR_ASSOCIATIONS\0" /* 29287 */
	"ALPHA_TO_MASK_EQAA_DISABLE\0" /* 29314 */
	"OVERRASTERIZATION_AMOUNT\0" /* 29341 */
	"ENABLE_POSTZ_OVERRASTERIZATION\0" /* 29366 */
	"DISABLE_DUAL_QUAD\0" /* 29397 */
	"DEGAMMA_ENABLE\0" /* 29415 */
	"CB_DISABLE\0" /* 29430 */
	"CB_NORMAL\0" /* 29441 */
	"CB_ELIMINATE_FAST_CLEAR\0" /* 29464, 29451 */
	"CB_RESOLVE\0" /* 29475 */
	"CB_FMASK_DECOMPRESS\0" /* 29486 */
	"CB_DCC_DECOMPRESS\0" /* 29506 */
	"X_0X00\0" /* 29524 */
	"X_0X05\0" /* 29531 */
	"X_0X0A\0" /* 29538 */
	"X_0X0F\0" /* 29545 */
	"X_0X11\0" /* 29552 */
	"X_0X22\0" /* 29559 */
	"X_0X33\0" /* 29566 */
	"X_0X44\0" /* 29573 */
	"X_0X50\0" /* 29580 */
	"X_0X55\0" /* 29587 */
	"X_0X5A\0" /* 29594 */
	"X_0X5F\0" /* 29601 */
	"X_0X66\0" /* 29608 */
	"X_0X77\0" /* 29615 */
	"X_0X88\0" /* 29622 */
	"X_0X99\0" /* 29629 */
	"X_0XA0\0" /* 29636 */
	"X_0XA5\0" /* 29643 */
	"X_0XAA\0" /* 29650 */
	"X_0XAF\0" /* 29657 */
	"X_0XBB\0" /* 29664 */
	"X_0XCC\0" /* 29671 */
	"X_0XDD\0" /* 29678 */
	"X_0XEE\0" /* 29685 */
	"X_0XF0\0" /* 29692 */
	"X_0XF5\0" /* 29699 */
	"X_0XFA\0" /* 29706 */
	"X_0XFF\0" /* 29713 */
	"Z_EXPORT_ENABLE\0" /* 29720 */
	"STENCIL_TEST_VAL_EXPORT_ENABLE\0" /* 29736 */
	"STENCIL_OP_VAL_EXPORT_ENABLE\0" /* 29767 */
	"LATE_Z\0" /* 29796 */
	"EARLY_Z_THEN_LATE_Z\0" /* 29803 */
	"RE_Z\0" /* 29823 */
	"EARLY_Z_THEN_RE_Z\0" /* 29828 */
	"KILL_ENABLE\0" /* 29846 */
	"COVERAGE_TO_MASK_ENABLE\0" /* 29858 */
	"MASK_EXPORT_ENABLE\0" /* 29882 */
	"EXEC_ON_HIER_FAIL\0" /* 29901 */
	"EXEC_ON_NOOP\0" /* 29919 */
	"ALPHA_TO_MASK_DISABLE\0" /* 29932 */
	"DEPTH_BEFORE_SHADER\0" /* 29954 */
	"EXPORT_ANY_Z\0" /* 29974 */
	"EXPORT_LESS_THAN_Z\0" /* 29987 */
	"EXPORT_GREATER_THAN_Z\0" /* 30006 */
	"EXPORT_RESERVED\0" /* 30028 */
	"CONSERVATIVE_Z_EXPORT\0" /* 30044 */
	"DUAL_QUAD_DISABLE\0" /* 30066 */
	"PRIMITIVE_ORDERED_PIXEL_SHADER\0" /* 30084 */
	"EXEC_IF_OVERLAPPED\0" /* 30115 */
	"POPS_OVERLAP_NUM_SAMPLES\0" /* 30134 */
	"UCP_ENA_0\0" /* 30159 */
	"UCP_ENA_1\0" /* 30169 */
	"UCP_ENA_2\0" /* 30179 */
	"UCP_ENA_3\0" /* 30189 */
	"UCP_ENA_4\0" /* 30199 */
	"UCP_ENA_5\0" /* 30209 */
	"PS_UCP_Y_SCALE_NEG\0" /* 30219 */
	"PS_UCP_MODE\0" /* 30238 */
	"CLIP_DISABLE\0" /* 30250 */
	"UCP_CULL_ONLY_ENA\0" /* 30263 */
	"BOUNDARY_EDGE_FLAG_ENA\0" /* 30281 */
	"DX_CLIP_SPACE_DEF\0" /* 30304 */
	"DIS_CLIP_ERR_DETECT\0" /* 30322 */
	"VTX_KILL_OR\0" /* 30342 */
	"DX_RASTERIZATION_KILL\0" /* 30354 */
	"DX_LINEAR_ATTR_CLIP_ENA\0" /* 30376 */
	"VTE_VPORT_PROVOKE_DISABLE\0" /* 30400 */
	"ZCLIP_NEAR_DISABLE\0" /* 30426 */
	"ZCLIP_FAR_DISABLE\0" /* 30445 */
	"CULL_FRONT\0" /* 30463 */
	"CULL_BACK\0" /* 30474 */
	"FACE\0" /* 30484 */
	"X_DISABLE_POLY_MODE\0" /* 30489, 30499 */
	"X_DUAL_MODE\0" /* 30509 */
	"X_DRAW_POINTS\0" /* 30521 */
	"X_DRAW_LINES\0" /* 30535 */
	"X_DRAW_TRIANGLES\0" /* 30548 */
	"POLYMODE_FRONT_PTYPE\0" /* 30565 */
	"POLYMODE_BACK_PTYPE\0" /* 30586 */
	"POLY_OFFSET_FRONT_ENABLE\0" /* 30606 */
	"POLY_OFFSET_BACK_ENABLE\0" /* 30631 */
	"POLY_OFFSET_PARA_ENABLE\0" /* 30655 */
	"VTX_WINDOW_OFFSET_ENABLE\0" /* 30679 */
	"PROVOKING_VTX_LAST\0" /* 30704 */
	"PERSP_CORR_DIS\0" /* 30723 */
	"MULTI_PRIM_IB_ENA\0" /* 30738 */
	"RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF\0" /* 30756 */
	"NEW_QUAD_DECOMPOSITION\0" /* 30794 */
	"VPORT_X_SCALE_ENA\0" /* 30817 */
	"VPORT_X_OFFSET_ENA\0" /* 30835 */
	"VPORT_Y_SCALE_ENA\0" /* 30854 */
	"VPORT_Y_OFFSET_ENA\0" /* 30872 */
	"VPORT_Z_SCALE_ENA\0" /* 30891 */
	"VPORT_Z_OFFSET_ENA\0" /* 30909 */
	"VTX_XY_FMT\0" /* 30928 */
	"VTX_Z_FMT\0" /* 30939 */
	"VTX_W0_FMT\0" /* 30949 */
	"PERFCOUNTER_REF\0" /* 30960 */
	"CLIP_DIST_ENA_0\0" /* 30976 */
	"CLIP_DIST_ENA_1\0" /* 30992 */
	"CLIP_DIST_ENA_2\0" /* 31008 */
	"CLIP_DIST_ENA_3\0" /* 31024 */
	"CLIP_DIST_ENA_4\0" /* 31040 */
	"CLIP_DIST_ENA_5\0" /* 31056 */
	"CLIP_DIST_ENA_6\0" /* 31072 */
	"CLIP_DIST_ENA_7\0" /* 31088 */
	"CULL_DIST_ENA_0\0" /* 31104 */
	"CULL_DIST_ENA_1\0" /* 31120 */
	"CULL_DIST_ENA_2\0" /* 31136 */
	"CULL_DIST_ENA_3\0" /* 31152 */
	"CULL_DIST_ENA_4\0" /* 31168 */
	"CULL_DIST_ENA_5\0" /* 31184 */
	"CULL_DIST_ENA_6\0" /* 31200 */
	"CULL_DIST_ENA_7\0" /* 31216 */
	"USE_VTX_POINT_SIZE\0" /* 31232 */
	"USE_VTX_EDGE_FLAG\0" /* 31251 */
	"USE_VTX_RENDER_TARGET_INDX\0" /* 31269 */
	"USE_VTX_VIEWPORT_INDX\0" /* 31296 */
	"USE_VTX_KILL_FLAG\0" /* 31318 */
	"VS_OUT_MISC_VEC_ENA\0" /* 31336 */
	"VS_OUT_CCDIST0_VEC_ENA\0" /* 31356 */
	"VS_OUT_CCDIST1_VEC_ENA\0" /* 31379 */
	"VS_OUT_MISC_SIDE_BUS_ENA\0" /* 31402 */
	"USE_VTX_GS_CUT_FLAG\0" /* 31427 */
	"USE_VTX_LINE_WIDTH\0" /* 31447 */
	"USE_VTX_SHD_OBJPRIM_ID\0" /* 31466 */
	"VTE_XY_INF_DISCARD\0" /* 31489 */
	"VTE_Z_INF_DISCARD\0" /* 31508 */
	"VTE_W_INF_DISCARD\0" /* 31526 */
	"VTE_0XNANINF_IS_0\0" /* 31544 */
	"VTE_XY_NAN_RETAIN\0" /* 31562 */
	"VTE_Z_NAN_RETAIN\0" /* 31580 */
	"VTE_W_NAN_RETAIN\0" /* 31597 */
	"VTE_W_RECIP_NAN_IS_0\0" /* 31614 */
	"VS_XY_NAN_TO_INF\0" /* 31635 */
	"VS_XY_INF_RETAIN\0" /* 31652 */
	"VS_Z_NAN_TO_INF\0" /* 31669 */
	"VS_Z_INF_RETAIN\0" /* 31685 */
	"VS_W_NAN_TO_INF\0" /* 31701 */
	"VS_W_INF_RETAIN\0" /* 31717 */
	"VS_CLIP_DIST_INF_DISCARD\0" /* 31733 */
	"VTE_NO_OUTPUT_NEG_0\0" /* 31758 */
	"LINE_STIPPLE_RESET\0" /* 31778 */
	"EXPAND_FULL_LENGTH\0" /* 31797 */
	"FRACTIONAL_ACCUM\0" /* 31816 */
	"DIAMOND_ADJUST\0" /* 31833 */
	"TRIANGLE_FILTER_DISABLE\0" /* 31848 */
	"LINE_FILTER_DISABLE\0" /* 31872 */
	"POINT_FILTER_DISABLE\0" /* 31892 */
	"RECTANGLE_FILTER_DISABLE\0" /* 31913 */
	"TRIANGLE_EXPAND_ENA\0" /* 31938 */
	"LINE_EXPAND_ENA\0" /* 31958 */
	"POINT_EXPAND_ENA\0" /* 31974 */
	"RECTANGLE_EXPAND_ENA\0" /* 31991 */
	"PRIM_EXPAND_CONSTANT\0" /* 32012 */
	"XMAX_RIGHT_EXCLUSION\0" /* 32033 */
	"YMAX_BOTTOM_EXCLUSION\0" /* 32054 */
	"SMALL_PRIM_FILTER_ENABLE\0" /* 32076 */
	"SRBSL_ENABLE\0" /* 32101 */
	"MIN_SIZE\0" /* 32114 */
	"MAX_SIZE\0" /* 32123 */
	"LINE_PATTERN\0" /* 32132 */
	"REPEAT_COUNT\0" /* 32145 */
	"PATTERN_BIT_ORDER\0" /* 32158 */
	"AUTO_RESET_CNTL\0" /* 32176 */
	"VGT_OUTPATH_VTX_REUSE\0" /* 32192 */
	"VGT_OUTPATH_TESS_EN\0" /* 32214 */
	"VGT_OUTPATH_PASSTHRU\0" /* 32234 */
	"VGT_OUTPATH_GS_BLOCK\0" /* 32255 */
	"VGT_OUTPATH_HS_BLOCK\0" /* 32276 */
	"PATH_SELECT\0" /* 32297 */
	"TESS_MODE\0" /* 32309 */
	"REUSE_DEPTH\0" /* 32319 */
	"VGT_GRP_3D_POINT\0" /* 32331 */
	"VGT_GRP_3D_LINE\0" /* 32348 */
	"VGT_GRP_3D_TRI\0" /* 32364 */
	"VGT_GRP_3D_RECT\0" /* 32379 */
	"VGT_GRP_3D_QUAD\0" /* 32395 */
	"VGT_GRP_2D_COPY_RECT_V0\0" /* 32411 */
	"VGT_GRP_2D_COPY_RECT_V1\0" /* 32435 */
	"VGT_GRP_2D_COPY_RECT_V2\0" /* 32459 */
	"VGT_GRP_2D_COPY_RECT_V3\0" /* 32483 */
	"VGT_GRP_2D_FILL_RECT\0" /* 32507 */
	"VGT_GRP_2D_LINE\0" /* 32528 */
	"VGT_GRP_2D_TRI\0" /* 32544 */
	"VGT_GRP_PRIM_INDEX_LINE\0" /* 32559 */
	"VGT_GRP_PRIM_INDEX_TRI\0" /* 32583 */
	"VGT_GRP_PRIM_INDEX_QUAD\0" /* 32606 */
	"VGT_GRP_3D_LINE_ADJ\0" /* 32630 */
	"VGT_GRP_3D_TRI_ADJ\0" /* 32650 */
	"VGT_GRP_3D_PATCH\0" /* 32669 */
	"RETAIN_ORDER\0" /* 32686 */
	"RETAIN_QUADS\0" /* 32699 */
	"VGT_GRP_LIST\0" /* 32712 */
	"VGT_GRP_STRIP\0" /* 32725 */
	"VGT_GRP_FAN\0" /* 32739 */
	"VGT_GRP_LOOP\0" /* 32751 */
	"VGT_GRP_POLYGON\0" /* 32764 */
	"PRIM_ORDER\0" /* 32780 */
	"FIRST_DECR\0" /* 32797, 32791 */
	"COMP_X_EN\0" /* 32802 */
	"COMP_Y_EN\0" /* 32812 */
	"COMP_Z_EN\0" /* 32822 */
	"COMP_W_EN\0" /* 32832 */
	"SHIFT\0" /* 32842 */
	"VGT_GRP_INDEX_16\0" /* 32848 */
	"VGT_GRP_INDEX_32\0" /* 32865 */
	"VGT_GRP_UINT_16\0" /* 32882 */
	"VGT_GRP_UINT_32\0" /* 32898 */
	"VGT_GRP_SINT_16\0" /* 32914 */
	"VGT_GRP_SINT_32\0" /* 32930 */
	"VGT_GRP_FLOAT_32\0" /* 32946 */
	"VGT_GRP_AUTO_PRIM\0" /* 32963 */
	"VGT_GRP_FIX_1_23_TO_FLOAT\0" /* 32981 */
	"X_CONV\0" /* 33007 */
	"Y_CONV\0" /* 33014 */
	"Z_CONV\0" /* 33021 */
	"Z_OFFSET\0" /* 33028 */
	"W_CONV\0" /* 33037 */
	"W_OFFSET\0" /* 33044 */
	"GS_OFF\0" /* 33053 */
	"GS_SCENARIO_A\0" /* 33060 */
	"GS_SCENARIO_B\0" /* 33074 */
	"GS_SCENARIO_G\0" /* 33088 */
	"GS_SCENARIO_C\0" /* 33102 */
	"SPRITE_EN\0" /* 33116 */
	"GS_CUT_1024\0" /* 33126 */
	"GS_CUT_512\0" /* 33138 */
	"GS_CUT_256\0" /* 33149 */
	"GS_CUT_128\0" /* 33160 */
	"CUT_MODE\0" /* 33171 */
	"GS_C_PACK_EN\0" /* 33180 */
	"RESERVED_2\0" /* 33193 */
	"ES_PASSTHRU\0" /* 33204 */
	"COMPUTE_MODE\0" /* 33216 */
	"FAST_COMPUTE_MODE\0" /* 33229 */
	"ELEMENT_INFO_EN\0" /* 33247 */
	"PARTIAL_THD_AT_EOI\0" /* 33263 */
	"SUPPRESS_CUTS\0" /* 33282 */
	"ES_WRITE_OPTIMIZE\0" /* 33296 */
	"GS_WRITE_OPTIMIZE\0" /* 33314 */
	"X_0_OFFCHIP_GS\0" /* 33332 */
	"X_3_ES_AND_GS_ARE_ONCHIP\0" /* 33347, 33365 */
	"RESERVED_3\0" /* 33372 */
	"RESERVED_4\0" /* 33383 */
	"RESERVED_5\0" /* 33394 */
	"ES_VERTS_PER_SUBGRP\0" /* 33405 */
	"GS_PRIMS_PER_SUBGRP\0" /* 33425 */
	"GS_INST_PRIMS_IN_SUBGRP\0" /* 33445 */
	"MSAA_ENABLE\0" /* 33469 */
	"VPORT_SCISSOR_ENABLE\0" /* 33481 */
	"LINE_STIPPLE_ENABLE\0" /* 33502 */
	"SEND_UNLIT_STILES_TO_PKR\0" /* 33522 */
	"SCALE_LINE_WIDTH_PAD\0" /* 33547 */
	"ALTERNATE_RBS_PER_TILE\0" /* 33568 */
	"COARSE_TILE_STARTS_ON_EVEN_RB\0" /* 33591 */
	"WALK_SIZE\0" /* 33621 */
	"WALK_ALIGNMENT\0" /* 33631 */
	"WALK_ALIGN8_PRIM_FITS_ST\0" /* 33646 */
	"WALK_FENCE_ENABLE\0" /* 33671 */
	"WALK_FENCE_SIZE\0" /* 33689 */
	"SUPERTILE_WALK_ORDER_ENABLE\0" /* 33705, 33710 */
	"TILE_COVER_DISABLE\0" /* 33733 */
	"TILE_COVER_NO_SCISSOR\0" /* 33752 */
	"ZMM_LINE_EXTENT\0" /* 33774 */
	"ZMM_LINE_OFFSET\0" /* 33790 */
	"ZMM_RECT_EXTENT\0" /* 33806 */
	"KILL_PIX_POST_HI_Z\0" /* 33822 */
	"KILL_PIX_POST_DETAIL_MASK\0" /* 33841 */
	"PS_ITER_SAMPLE\0" /* 33867 */
	"MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE\0" /* 33882 */
	"MULTI_GPU_SUPERTILE_ENABLE\0" /* 33922 */
	"GPU_ID_OVERRIDE_ENABLE\0" /* 33949 */
	"GPU_ID_OVERRIDE\0" /* 33972 */
	"MULTI_GPU_PRIM_DISCARD_ENABLE\0" /* 33988 */
	"FORCE_EOV_CNTDWN_ENABLE\0" /* 34018 */
	"FORCE_EOV_REZ_ENABLE\0" /* 34042 */
	"OUT_OF_ORDER_PRIMITIVE_ENABLE\0" /* 34063 */
	"OUT_OF_ORDER_WATER_MARK\0" /* 34093 */
	"GS_PER_ES\0" /* 34117 */
	"ES_PER_GS\0" /* 34127 */
	"GS_PER_VS\0" /* 34137 */
	"OUTPRIM_TYPE_POINTLIST\0" /* 34147 */
	"OUTPRIM_TYPE_LINESTRIP\0" /* 34170 */
	"OUTPRIM_TYPE_TRISTRIP\0" /* 34193 */
	"OUTPRIM_TYPE\0" /* 34215 */
	"OUTPRIM_TYPE_1\0" /* 34228 */
	"OUTPRIM_TYPE_2\0" /* 34243 */
	"OUTPRIM_TYPE_3\0" /* 34258 */
	"UNIQUE_TYPE_PER_STREAM\0" /* 34273 */
	"VGT_INDEX_16\0" /* 34296 */
	"VGT_INDEX_32\0" /* 34309 */
	"VGT_INDEX_8\0" /* 34322 */
	"VGT_DMA_SWAP_NONE\0" /* 34334 */
	"VGT_DMA_SWAP_16_BIT\0" /* 34352 */
	"VGT_DMA_SWAP_32_BIT\0" /* 34372 */
	"VGT_DMA_SWAP_WORD\0" /* 34392 */
	"SWAP_MODE\0" /* 34410 */
	"VGT_DMA_BUF_MEM\0" /* 34420 */
	"VGT_DMA_BUF_RING\0" /* 34436 */
	"VGT_DMA_BUF_SETUP\0" /* 34453 */
	"BUF_TYPE\0" /* 34471 */
	"VGT_POLICY_LRU\0" /* 34480 */
	"VGT_POLICY_STREAM\0" /* 34495 */
	"RDREQ_POLICY_CIK\0" /* 34513 */
	"RDREQ_POLICY\0" /* 34530 */
	"REQ_PATH\0" /* 34543 */
	"PRIMITIVEID_EN\0" /* 34552 */
	"DISABLE_RESET_ON_EOI\0" /* 34567 */
	"NGG_DISABLE_PROVOK_REUSE\0" /* 34588 */
	"SAMPLE_STREAMOUTSTATS1\0" /* 34613 */
	"SAMPLE_STREAMOUTSTATS2\0" /* 34636 */
	"SAMPLE_STREAMOUTSTATS3\0" /* 34659 */
	"CACHE_FLUSH_TS\0" /* 34682 */
	"CONTEXT_DONE\0" /* 34697 */
	"CACHE_FLUSH\0" /* 34710 */
	"CS_PARTIAL_FLUSH\0" /* 34722 */
	"VGT_STREAMOUT_SYNC\0" /* 34739 */
	"VGT_STREAMOUT_RESET\0" /* 34758 */
	"END_OF_PIPE_INCR_DE\0" /* 34778 */
	"END_OF_PIPE_IB_END\0" /* 34798 */
	"RST_PIX_CNT\0" /* 34817 */
	"VS_PARTIAL_FLUSH\0" /* 34829 */
	"PS_PARTIAL_FLUSH\0" /* 34846 */
	"FLUSH_HS_OUTPUT\0" /* 34863 */
	"FLUSH_LS_OUTPUT\0" /* 34879 */
	"CACHE_FLUSH_AND_INV_TS_EVENT\0" /* 34895 */
	"ZPASS_DONE\0" /* 34924 */
	"CACHE_FLUSH_AND_INV_EVENT\0" /* 34935 */
	"PERFCOUNTER_START\0" /* 34961 */
	"PERFCOUNTER_STOP\0" /* 34979 */
	"PIPELINESTAT_START\0" /* 34996 */
	"PIPELINESTAT_STOP\0" /* 35015 */
	"PERFCOUNTER_SAMPLE\0" /* 35033 */
	"FLUSH_ES_OUTPUT\0" /* 35052 */
	"FLUSH_GS_OUTPUT\0" /* 35068 */
	"SAMPLE_PIPELINESTAT\0" /* 35084 */
	"SO_VGTSTREAMOUT_FLUSH\0" /* 35104 */
	"SAMPLE_STREAMOUTSTATS\0" /* 35126 */
	"RESET_VTX_CNT\0" /* 35148 */
	"BLOCK_CONTEXT_DONE\0" /* 35162 */
	"CS_CONTEXT_DONE\0" /* 35181 */
	"VGT_FLUSH\0" /* 35197 */
	"SC_SEND_DB_VPZ\0" /* 35207 */
	"BOTTOM_OF_PIPE_TS\0" /* 35222 */
	"DB_CACHE_FLUSH_AND_INV\0" /* 35240 */
	"FLUSH_AND_INV_DB_DATA_TS\0" /* 35263 */
	"FLUSH_AND_INV_DB_META\0" /* 35288 */
	"FLUSH_AND_INV_CB_DATA_TS\0" /* 35310 */
	"FLUSH_AND_INV_CB_META\0" /* 35335 */
	"FLUSH_AND_INV_CB_PIXEL_DATA\0" /* 35357 */
	"THREAD_TRACE_START\0" /* 35385 */
	"THREAD_TRACE_STOP\0" /* 35404 */
	"THREAD_TRACE_MARKER\0" /* 35422 */
	"THREAD_TRACE_FLUSH\0" /* 35442 */
	"THREAD_TRACE_FINISH\0" /* 35461 */
	"PIXEL_PIPE_STAT_CONTROL\0" /* 35481 */
	"PIXEL_PIPE_STAT_DUMP\0" /* 35505 */
	"PIXEL_PIPE_STAT_RESET\0" /* 35526 */
	"BREAK_BATCH\0" /* 35548 */
	"FLUSH_DFSM\0" /* 35560 */
	"RESET_TO_LOWEST_VGT\0" /* 35571 */
	"TGID_ROLLOVER\0" /* 35591 */
	"ENABLE_NGG_PIPELINE\0" /* 35605 */
	"ENABLE_LEGACY_PIPELINE\0" /* 35625 */
	"EVENT_TYPE\0" /* 35648 */
	"ADDRESS_HI_GFX6\0" /* 35659 */
	"EXTENDED_EVENT\0" /* 35675 */
	"ADDRESS_HI_GFX9\0" /* 35690 */
	"RESET_EN\0" /* 35706 */
	"PRIMGROUP_SIZE\0" /* 35715 */
	"PARTIAL_VS_WAVE_ON\0" /* 35730 */
	"SWITCH_ON_EOP\0" /* 35749 */
	"PARTIAL_ES_WAVE_ON\0" /* 35763 */
	"SWITCH_ON_EOI\0" /* 35782 */
	"WD_SWITCH_ON_EOP\0" /* 35796 */
	"MAX_PRIMGRP_IN_WAVE\0" /* 35813 */
	"ITEMSIZE\0" /* 35833 */
	"REUSE_OFF\0" /* 35842 */
	"VTX_CNT_EN\0" /* 35852 */
	"FULL_CACHE\0" /* 35863 */
	"HTILE_USES_PRELOAD_WIN\0" /* 35874 */
	"PRELOAD\0" /* 35897 */
	"PREFETCH_WIDTH\0" /* 35905 */
	"PREFETCH_HEIGHT\0" /* 35920 */
	"DST_OUTSIDE_ZERO_TO_ONE\0" /* 35936 */
	"TC_COMPATIBLE\0" /* 35960 */
	"COMPAREFUNC0\0" /* 35974 */
	"COMPAREVALUE0\0" /* 35987 */
	"COMPAREMASK0\0" /* 36001 */
	"COMPAREFUNC1\0" /* 36014 */
	"COMPAREVALUE1\0" /* 36027 */
	"COMPAREMASK1\0" /* 36041 */
	"START_X\0" /* 36054 */
	"START_Y\0" /* 36062 */
	"MAX_X\0" /* 36070 */
	"MAX_Y\0" /* 36076 */
	"VERTEX_STRIDE\0" /* 36082 */
	"MAX_VERT_OUT\0" /* 36096 */
	"ACCUM_ISOLINE\0" /* 36109 */
	"ACCUM_TRI\0" /* 36123 */
	"ACCUM_QUAD\0" /* 36133 */
	"DONUT_SPLIT\0" /* 36144 */
	"TRAP_SPLIT\0" /* 36156 */
	"LS_STAGE_OFF\0" /* 36167 */
	"LS_STAGE_ON\0" /* 36180 */
	"CS_STAGE_ON\0" /* 36192 */
	"ES_STAGE_OFF\0" /* 36204 */
	"ES_STAGE_DS\0" /* 36217 */
	"ES_STAGE_REAL\0" /* 36229 */
	"VS_STAGE_REAL\0" /* 36243 */
	"VS_STAGE_DS\0" /* 36257 */
	"VS_STAGE_COPY_SHADER\0" /* 36269 */
	"DYNAMIC_HS\0" /* 36290 */
	"DIS_DEALLOC_ACCUM_0\0" /* 36301 */
	"DIS_DEALLOC_ACCUM_1\0" /* 36321 */
	"VS_WAVE_ID_EN\0" /* 36341 */
	"ORDERED_ID_MODE\0" /* 36355 */
	"GS_FAST_LAUNCH\0" /* 36371 */
	"NUM_PATCHES\0" /* 36386 */
	"HS_NUM_INPUT_CP\0" /* 36398 */
	"HS_NUM_OUTPUT_CP\0" /* 36414 */
	"TESS_ISOLINE\0" /* 36431 */
	"TESS_TRIANGLE\0" /* 36444 */
	"TESS_QUAD\0" /* 36458 */
	"PART_INTEGER\0" /* 36468 */
	"PART_POW2\0" /* 36481 */
	"PART_FRAC_ODD\0" /* 36491 */
	"PART_FRAC_EVEN\0" /* 36505 */
	"PARTITIONING\0" /* 36520 */
	"OUTPUT_POINT\0" /* 36533 */
	"OUTPUT_LINE\0" /* 36546 */
	"OUTPUT_TRIANGLE_CW\0" /* 36558 */
	"OUTPUT_TRIANGLE_CCW\0" /* 36577 */
	"TOPOLOGY\0" /* 36597 */
	"RESERVED_REDUC_AXIS\0" /* 36606 */
	"DEPRECATED\0" /* 36626 */
	"NUM_DS_WAVES_PER_SIMD\0" /* 36637 */
	"DISABLE_DONUTS\0" /* 36659 */
	"VGT_POLICY_BYPASS\0" /* 36674 */
	"DISTRIBUTION_MODE_NO_DIST\0" /* 36692 */
	"DISTRIBUTION_MODE_PATCHES\0" /* 36718 */
	"DISTRIBUTION_MODE_DONUTS\0" /* 36744 */
	"DISTRIBUTION_MODE_TRAPEZOIDS\0" /* 36769 */
	"DISTRIBUTION_MODE\0" /* 36798 */
	"ALPHA_TO_MASK_ENABLE\0" /* 36816 */
	"ALPHA_TO_MASK_OFFSET0\0" /* 36837 */
	"ALPHA_TO_MASK_OFFSET1\0" /* 36859 */
	"ALPHA_TO_MASK_OFFSET2\0" /* 36881 */
	"ALPHA_TO_MASK_OFFSET3\0" /* 36903 */
	"OFFSET_ROUND\0" /* 36925 */
	"POLY_OFFSET_NEG_NUM_DB_BITS\0" /* 36938 */
	"POLY_OFFSET_DB_IS_FLOAT_FMT\0" /* 36966 */
	"STREAMOUT_0_EN\0" /* 36994 */
	"STREAMOUT_1_EN\0" /* 37009 */
	"STREAMOUT_2_EN\0" /* 37024 */
	"STREAMOUT_3_EN\0" /* 37039 */
	"RAST_STREAM\0" /* 37054 */
	"RAST_STREAM_MASK\0" /* 37066 */
	"USE_RAST_STREAM_MASK\0" /* 37083 */
	"EN_PRIMS_NEEDED_CNT\0" /* 37104 */
	"STREAM_0_BUFFER_EN\0" /* 37124 */
	"STREAM_1_BUFFER_EN\0" /* 37143 */
	"STREAM_2_BUFFER_EN\0" /* 37162 */
	"STREAM_3_BUFFER_EN\0" /* 37181 */
	"DISTANCE_0\0" /* 37200 */
	"DISTANCE_1\0" /* 37211 */
	"DISTANCE_2\0" /* 37222 */
	"DISTANCE_3\0" /* 37233 */
	"DISTANCE_4\0" /* 37244 */
	"DISTANCE_5\0" /* 37255 */
	"DISTANCE_6\0" /* 37266 */
	"DISTANCE_7\0" /* 37277 */
	"DISTANCE_8\0" /* 37288 */
	"DISTANCE_9\0" /* 37299 */
	"DISTANCE_10\0" /* 37310 */
	"DISTANCE_11\0" /* 37322 */
	"DISTANCE_12\0" /* 37334 */
	"DISTANCE_13\0" /* 37346 */
	"DISTANCE_14\0" /* 37358 */
	"DISTANCE_15\0" /* 37370 */
	"EXPAND_LINE_WIDTH\0" /* 37382 */
	"LAST_PIXEL\0" /* 37400 */
	"PERPENDICULAR_ENDCAP_ENA\0" /* 37411 */
	"DX10_DIAMOND_TEST_ENA\0" /* 37436 */
	"MSAA_NUM_SAMPLES\0" /* 37458 */
	"AA_MASK_CENTROID_DTMN\0" /* 37475 */
	"MAX_SAMPLE_DIST\0" /* 37497 */
	"MSAA_EXPOSED_SAMPLES\0" /* 37513 */
	"DETAIL_TO_EXPOSED_MODE\0" /* 37534 */
	"COVERAGE_TO_SHADER_SELECT\0" /* 37557 */
	"PIX_CENTER\0" /* 37583 */
	"X_TRUNCATE\0" /* 37594 */
	"X_ROUND\0" /* 37605 */
	"X_ROUND_TO_EVEN\0" /* 37613 */
	"X_ROUND_TO_ODD\0" /* 37629 */
	"ROUND_MODE\0" /* 37644 */
	"X_16_8_FIXED_POINT_1_16TH\0" /* 37655 */
	"X_16_8_FIXED_POINT_1_8TH\0" /* 37681 */
	"X_16_8_FIXED_POINT_1_4TH\0" /* 37706 */
	"X_16_8_FIXED_POINT_1_2\0" /* 37731 */
	"X_16_8_FIXED_POINT_1\0" /* 37754 */
	"X_16_8_FIXED_POINT_1_256TH\0" /* 37775 */
	"X_14_10_FIXED_POINT_1_1024TH\0" /* 37802 */
	"X_12_12_FIXED_POINT_1_4096TH\0" /* 37831 */
	"QUANT_MODE\0" /* 37860 */
	"S0_X\0" /* 37871 */
	"S0_Y\0" /* 37876 */
	"S1_X\0" /* 37881 */
	"S1_Y\0" /* 37886 */
	"S2_X\0" /* 37891 */
	"S2_Y\0" /* 37896 */
	"S3_X\0" /* 37901 */
	"S3_Y\0" /* 37906 */
	"S4_X\0" /* 37911 */
	"S4_Y\0" /* 37916 */
	"S5_X\0" /* 37921 */
	"S5_Y\0" /* 37926 */
	"S6_X\0" /* 37931 */
	"S6_Y\0" /* 37936 */
	"S7_X\0" /* 37941 */
	"S7_Y\0" /* 37946 */
	"S8_X\0" /* 37951 */
	"S8_Y\0" /* 37956 */
	"S9_X\0" /* 37961 */
	"S9_Y\0" /* 37966 */
	"S10_X\0" /* 37971 */
	"S10_Y\0" /* 37977 */
	"S11_X\0" /* 37983 */
	"S11_Y\0" /* 37989 */
	"S12_X\0" /* 37995 */
	"S12_Y\0" /* 38001 */
	"S13_X\0" /* 38007 */
	"S13_Y\0" /* 38013 */
	"S14_X\0" /* 38019 */
	"S14_Y\0" /* 38025 */
	"S15_X\0" /* 38031 */
	"S15_Y\0" /* 38037 */
	"AA_MASK_X0Y0\0" /* 38043 */
	"AA_MASK_X1Y0\0" /* 38056 */
	"AA_MASK_X0Y1\0" /* 38069 */
	"AA_MASK_X1Y1\0" /* 38082 */
	"REALIGN_DQUADS_AFTER_N_WAVES\0" /* 38095 */
	"VTX_REUSE_DEPTH\0" /* 38124 */
	"DEALLOC_DIST\0" /* 38140 */
	"FMASK_TILE_MAX\0" /* 38153 */
	"MIP_LEVEL\0" /* 38168 */
	"ENDIAN_NONE\0" /* 38178 */
	"ENDIAN_8IN16\0" /* 38190 */
	"ENDIAN_8IN32\0" /* 38203 */
	"ENDIAN_8IN64\0" /* 38216 */
	"ENDIAN\0" /* 38229 */
	"COLOR_INVALID\0" /* 38236 */
	"COLOR_8\0" /* 38250 */
	"COLOR_16\0" /* 38258 */
	"COLOR_8_8\0" /* 38267 */
	"COLOR_32\0" /* 38277 */
	"COLOR_16_16\0" /* 38286 */
	"COLOR_10_11_11\0" /* 38298 */
	"COLOR_11_11_10\0" /* 38313 */
	"COLOR_10_10_10_2\0" /* 38328 */
	"COLOR_2_10_10_10\0" /* 38345 */
	"COLOR_8_8_8_8\0" /* 38362 */
	"COLOR_32_32\0" /* 38376 */
	"COLOR_16_16_16_16\0" /* 38388 */
	"COLOR_32_32_32_32\0" /* 38406 */
	"COLOR_5_6_5\0" /* 38424 */
	"COLOR_1_5_5_5\0" /* 38436 */
	"COLOR_5_5_5_1\0" /* 38450 */
	"COLOR_4_4_4_4\0" /* 38464 */
	"COLOR_8_24\0" /* 38478 */
	"COLOR_24_8\0" /* 38489 */
	"COLOR_X24_8_32_FLOAT\0" /* 38500 */
	"NUMBER_UNORM\0" /* 38521 */
	"NUMBER_SNORM\0" /* 38534 */
	"NUMBER_UINT\0" /* 38547 */
	"NUMBER_SINT\0" /* 38559 */
	"NUMBER_SRGB\0" /* 38571 */
	"NUMBER_FLOAT\0" /* 38583 */
	"NUMBER_TYPE\0" /* 38596 */
	"SWAP_STD\0" /* 38608 */
	"SWAP_ALT\0" /* 38617 */
	"SWAP_STD_REV\0" /* 38626 */
	"SWAP_ALT_REV\0" /* 38639 */
	"COMP_SWAP\0" /* 38652 */
	"BLEND_CLAMP\0" /* 38662 */
	"BLEND_BYPASS\0" /* 38674 */
	"SIMPLE_FLOAT\0" /* 38687 */
	"CMASK_IS_LINEAR\0" /* 38700 */
	"FORCE_OPT_AUTO\0" /* 38716 */
	"FORCE_OPT_DISABLE\0" /* 38731 */
	"FORCE_OPT_ENABLE_IF_SRC_A_0\0" /* 38749 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_0\0" /* 38777 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_0\0" /* 38807 */
	"FORCE_OPT_ENABLE_IF_SRC_A_1\0" /* 38838 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_1\0" /* 38866 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_1\0" /* 38896 */
	"BLEND_OPT_DONT_RD_DST\0" /* 38927 */
	"BLEND_OPT_DISCARD_PIXEL\0" /* 38949 */
	"FMASK_COMPRESSION_DISABLE\0" /* 38973 */
	"FMASK_COMPRESS_1FRAG_ONLY\0" /* 38999 */
	"DCC_ENABLE\0" /* 39025 */
	"CMASK_ADDR_TYPE\0" /* 39036 */
	"FMASK_TILE_MODE_INDEX\0" /* 39052 */
	"FMASK_BANK_HEIGHT\0" /* 39074 */
	"NUM_FRAGMENTS\0" /* 39092 */
	"FORCE_DST_ALPHA_1\0" /* 39106 */
	"MIP0_DEPTH\0" /* 39124 */
	"COLOR_SW_MODE\0" /* 39135 */
	"FMASK_SW_MODE\0" /* 39149 */
	"RESOURCE_TYPE\0" /* 39163 */
	"KEY_CLEAR_ENABLE\0" /* 39177 */
	"MAX_UNCOMPRESSED_BLOCK_SIZE\0" /* 39194 */
	"MIN_COMPRESSED_BLOCK_SIZE\0" /* 39222 */
	"MAX_COMPRESSED_BLOCK_SIZE\0" /* 39248 */
	"INDEPENDENT_64B_BLOCKS\0" /* 39274 */
	"LOSSY_RGB_PRECISION\0" /* 39297 */
	"LOSSY_ALPHA_PRECISION\0" /* 39317 */
	"MATCH_ALL_BITS\0" /* 39339 */
	"BASE_HI\0" /* 39354 */
	"EN_INST_OPT_BASIC\0" /* 39362 */
	"EN_INST_OPT_ADV\0" /* 39380 */
	"HW_USE_ONLY\0" /* 39396 */
	"DWB\0" /* 39408 */
	"GRAD_ADJ_0\0" /* 39412 */
	"GRAD_ADJ_1\0" /* 39423 */
	"GRAD_ADJ_2\0" /* 39434 */
	"GRAD_ADJ_3\0" /* 39445 */
	"TTRACE_STALL_ALL\0" /* 39456 */
	"ALLOC_ARB_LRU_ENA\0" /* 39473 */
	"EXP_ARB_LRU_ENA\0" /* 39491 */
	"PS_PKR_PRIORITY_CNTL\0" /* 39507 */
	"BATON_RESET_DISABLE\0" /* 39528 */
	"CRC_SIMD_ID_WADDR_DISABLE\0" /* 39548 */
	"LBPW_CU_CHK_MODE\0" /* 39574 */
	"LBPW_CU_CHK_CNT\0" /* 39591 */
	"CSC_PWR_SAVE_DISABLE\0" /* 39607 */
	"CSG_PWR_SAVE_DISABLE\0" /* 39628 */
	"CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD\0" /* 39649 */
	"CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD\0" /* 39690 */
	"SPI_SHADER_LATE_ALLOC_GS\0" /* 39729 */
	"X_MAX\0" /* 39754 */
	"Y_MAX\0" /* 39760 */
	"PARTIALLY_RESIDENT\0" /* 39766 */
	"FAULT_BEHAVIOR\0" /* 39785 */
	"ITERATE_FLUSH\0" /* 39800 */
	"MAXMIP\0" /* 39814 */
	"FORCE_ON\0" /* 39821 */
	"PUNCHOUT_MODE\0" /* 39830 */
	"POPS_DRAIN_PS_ON_OVERLAP\0" /* 39844 */
	"DISALLOW_OVERFLOW\0" /* 39869 */
	"PS_INVOKE_MASK\0" /* 39887 */
	"EPITCH\0" /* 39902 */
	"NUM_SE\0" /* 39909 */
	"DISABLE_SRBSL_DB_OPTIMIZED_PACKING\0" /* 39916 */
	"PERFMON_ENABLE\0" /* 39951 */
	"LEFT_QTR\0" /* 39966 */
	"LEFT_HALF\0" /* 39975 */
	"RIGHT_HALF\0" /* 39985 */
	"RIGHT_QTR\0" /* 39996 */
	"TOP_QTR\0" /* 40006 */
	"TOP_HALF\0" /* 40014 */
	"BOT_HALF\0" /* 40023 */
	"BOT_QTR\0" /* 40032 */
	"LEFT_EYE_FOV_LEFT\0" /* 40040 */
	"LEFT_EYE_FOV_RIGHT\0" /* 40058 */
	"RIGHT_EYE_FOV_LEFT\0" /* 40077 */
	"RIGHT_EYE_FOV_RIGHT\0" /* 40096 */
	"FOV_TOP\0" /* 40116 */
	"FOV_BOT\0" /* 40124 */
	"OBJ_ID_SEL\0" /* 40132 */
	"ADD_PIPED_PRIM_ID\0" /* 40143 */
	"EN_32BIT_OBJPRIMID\0" /* 40161 */
	"VERTEX_REUSE_OFF\0" /* 40180 */
	"INDEX_BUF_EDGE_FLAG_ENA\0" /* 40197 */
	"DISCARD_0_AREA_TRIANGLES\0" /* 40221 */
	"DISCARD_0_AREA_LINES\0" /* 40246 */
	"DISCARD_0_AREA_POINTS\0" /* 40267 */
	"DISCARD_0_AREA_RECTANGLES\0" /* 40289 */
	"USE_PROVOKING_ZW\0" /* 40315 */
	"MAX_PRIMS_PER_SUBGROUP\0" /* 40332 */
	"OBJPRIM_ID_EN\0" /* 40355 */
	"EN_REG_RT_INDEX\0" /* 40369 */
	"EN_PIPELINE_PRIMID\0" /* 40385 */
	"OBJECT_ID_INST_EN\0" /* 40404 */
	"COMPOUND_INDEX_EN\0" /* 40422 */
	"BINNING_ALLOWED\0" /* 40440 */
	"FORCE_BINNING_ON\0" /* 40456 */
	"DISABLE_BINNING_USE_NEW_SC\0" /* 40473 */
	"DISABLE_BINNING_USE_LEGACY_SC\0" /* 40500 */
	"BINNING_MODE\0" /* 40530 */
	"BIN_SIZE_X\0" /* 40543 */
	"BIN_SIZE_Y\0" /* 40554 */
	"BIN_SIZE_X_EXTEND\0" /* 40565 */
	"BIN_SIZE_Y_EXTEND\0" /* 40583 */
	"CONTEXT_STATES_PER_BIN\0" /* 40601 */
	"PERSISTENT_STATES_PER_BIN\0" /* 40624 */
	"DISABLE_START_OF_PRIM\0" /* 40650 */
	"FPOVS_PER_BATCH\0" /* 40672 */
	"OPTIMAL_BIN_SELECTION\0" /* 40688 */
	"MAX_ALLOC_COUNT\0" /* 40710 */
	"MAX_PRIM_PER_BATCH\0" /* 40726 */
	"OVER_RAST_ENABLE\0" /* 40745 */
	"OVER_RAST_SAMPLE_SELECT\0" /* 40762 */
	"UNDER_RAST_ENABLE\0" /* 40786 */
	"UNDER_RAST_SAMPLE_SELECT\0" /* 40804 */
	"PBB_UNCERTAINTY_REGION_ENABLE\0" /* 40829 */
	"ZMM_TRI_EXTENT\0" /* 40859 */
	"ZMM_TRI_OFFSET\0" /* 40874 */
	"OVERRIDE_OVER_RAST_INNER_TO_NORMAL\0" /* 40889 */
	"OVERRIDE_UNDER_RAST_INNER_TO_NORMAL\0" /* 40924 */
	"DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE\0" /* 40960 */
	"UNCERTAINTY_REGION_MODE\0" /* 41004 */
	"OUTER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 41028 */
	"INNER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 41064 */
	"NULL_SQUAD_AA_MASK_ENABLE\0" /* 41100 */
	"COVERAGE_AA_MASK_ENABLE\0" /* 41126 */
	"PREZ_AA_MASK_ENABLE\0" /* 41150 */
	"POSTZ_AA_MASK_ENABLE\0" /* 41170 */
	"CENTROID_SAMPLE_OVERRIDE\0" /* 41191 */
	"MAX_DEALLOCS_IN_WAVE\0" /* 41216 */
	"BASE_256B\0" /* 41237 */
	"MIP0_HEIGHT\0" /* 41247 */
	"MIP0_WIDTH\0" /* 41259 */
	"DRAW_INDEX_LOC\0" /* 41270 */
	"IB_BASE_LO\0" /* 41285 */
	"IB_BASE_HI\0" /* 41296 */
	"CP_DMA_WORD0\0" /* 41307 */
	"CP_DMA_WORD1\0" /* 41320 */
	"CP_DMA_WORD2\0" /* 41333 */
	"CP_DMA_WORD3\0" /* 41346 */
	"COMMAND\0" /* 41359 */
	"DMA_DATA_WORD0\0" /* 41367 */
	"SRBM_STATUS2\0" /* 41382 */
	"SRBM_STATUS\0" /* 41395 */
	"SRBM_STATUS3\0" /* 41407 */
	"SDMA0_STATUS_REG\0" /* 41420 */
	"SDMA1_STATUS_REG\0" /* 41437 */
	"GRBM_STATUS2\0" /* 41454 */
	"GRBM_STATUS\0" /* 41467 */
	"CP_STRMOUT_CNTL\0" /* 41479 */
	"CP_COHER_CNTL\0" /* 41495 */
	"CP_COHER_SIZE\0" /* 41509 */
	"CP_COHER_BASE\0" /* 41523 */
	"GRBM_STATUS_SE0\0" /* 41537 */
	"GRBM_STATUS_SE1\0" /* 41553 */
	"GRBM_STATUS_SE2\0" /* 41569 */
	"GRBM_STATUS_SE3\0" /* 41585 */
	"CP_COHER_BASE_HI\0" /* 41601 */
	"CP_COHER_START_DELAY\0" /* 41618 */
	"CP_COHER_STATUS\0" /* 41639 */
	"CP_CPC_STATUS\0" /* 41655 */
	"CP_CPC_BUSY_STAT\0" /* 41669 */
	"CP_CPC_STALLED_STAT1\0" /* 41686 */
	"CP_CPF_STATUS\0" /* 41707 */
	"CP_CPF_BUSY_STAT\0" /* 41721 */
	"CP_CPF_STALLED_STAT1\0" /* 41738 */
	"CP_COHER_SIZE_HI\0" /* 41759 */
	"VGT_VTX_VECT_EJECT_REG\0" /* 41776 */
	"VGT_CACHE_INVALIDATION\0" /* 41799 */
	"VGT_ESGS_RING_SIZE\0" /* 41822 */
	"VGT_GSVS_RING_SIZE\0" /* 41841 */
	"VGT_GS_VERTEX_REUSE\0" /* 41860 */
	"VGT_PRIMITIVE_TYPE\0" /* 41880 */
	"VGT_INDEX_TYPE\0" /* 41899 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_0\0" /* 41914 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_1\0" /* 41947 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_2\0" /* 41980 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_3\0" /* 42013 */
	"VGT_NUM_INDICES\0" /* 42046 */
	"VGT_NUM_INSTANCES\0" /* 42062 */
	"VGT_TF_RING_SIZE\0" /* 42080 */
	"VGT_HS_OFFCHIP_PARAM\0" /* 42097 */
	"VGT_TF_MEMORY_BASE\0" /* 42118 */
	"PA_CL_ENHANCE\0" /* 42137 */
	"PA_SU_LINE_STIPPLE_VALUE\0" /* 42151 */
	"PA_SC_LINE_STIPPLE_STATE\0" /* 42176 */
	"CP_STALLED_STAT3\0" /* 42201 */
	"CP_STALLED_STAT1\0" /* 42218 */
	"CP_STALLED_STAT2\0" /* 42235 */
	"CP_STAT\0" /* 42252 */
	"GRBM_GFX_INDEX\0" /* 42260 */
	"PA_SC_SCREEN_EXTENT_MIN_0\0" /* 42275 */
	"PA_SC_SCREEN_EXTENT_MAX_0\0" /* 42301 */
	"PA_SC_SCREEN_EXTENT_MIN_1\0" /* 42327 */
	"PA_SC_SCREEN_EXTENT_MAX_1\0" /* 42353 */
	"PA_SC_ENHANCE\0" /* 42379 */
	"SQC_CACHES\0" /* 42393 */
	"SQ_RANDOM_WAVE_PRI\0" /* 42404 */
	"SQ_EXP_0\0" /* 42423 */
	"TA_CS_BC_BASE_ADDR\0" /* 42432 */
	"TA_CS_BC_BASE_ADDR_HI\0" /* 42451 */
	"DB_OCCLUSION_COUNT0_LOW\0" /* 42473 */
	"SQ_BUF_RSRC_WORD0\0" /* 42497 */
	"DB_OCCLUSION_COUNT0_HI\0" /* 42515 */
	"SQ_BUF_RSRC_WORD1\0" /* 42538 */
	"DB_OCCLUSION_COUNT1_LOW\0" /* 42556 */
	"SQ_BUF_RSRC_WORD2\0" /* 42580 */
	"DB_OCCLUSION_COUNT1_HI\0" /* 42598 */
	"SQ_BUF_RSRC_WORD3\0" /* 42621 */
	"DB_OCCLUSION_COUNT2_LOW\0" /* 42639 */
	"SQ_IMG_RSRC_WORD0\0" /* 42663 */
	"DB_OCCLUSION_COUNT2_HI\0" /* 42681 */
	"SQ_IMG_RSRC_WORD1\0" /* 42704 */
	"DB_OCCLUSION_COUNT3_LOW\0" /* 42722 */
	"SQ_IMG_RSRC_WORD2\0" /* 42746 */
	"DB_OCCLUSION_COUNT3_HI\0" /* 42764 */
	"SQ_IMG_RSRC_WORD3\0" /* 42787 */
	"SQ_IMG_RSRC_WORD4\0" /* 42805 */
	"SQ_IMG_RSRC_WORD5\0" /* 42823 */
	"SQ_IMG_RSRC_WORD6\0" /* 42841 */
	"SQ_IMG_RSRC_WORD7\0" /* 42859 */
	"SQ_IMG_SAMP_WORD0\0" /* 42877 */
	"SQ_IMG_SAMP_WORD1\0" /* 42895 */
	"SQ_IMG_SAMP_WORD2\0" /* 42913 */
	"SQ_IMG_SAMP_WORD3\0" /* 42931 */
	"SPI_DYN_GPR_LOCK_EN\0" /* 42949 */
	"SPI_STATIC_THREAD_MGMT_1\0" /* 42969 */
	"SPI_STATIC_THREAD_MGMT_2\0" /* 42994 */
	"SPI_STATIC_THREAD_MGMT_3\0" /* 43019 */
	"SPI_PS_MAX_WAVE_ID\0" /* 43044 */
	"SPI_ARB_PRIORITY\0" /* 43063 */
	"SPI_ARB_CYCLES_0\0" /* 43080 */
	"SPI_ARB_CYCLES_1\0" /* 43097 */
	"SQ_FLAT_SCRATCH_WORD0\0" /* 43114 */
	"SQ_FLAT_SCRATCH_WORD1\0" /* 43136 */
	"DB_ZPASS_COUNT_LOW\0" /* 43158 */
	"DB_ZPASS_COUNT_HI\0" /* 43177 */
	"SPI_CONFIG_CNTL\0" /* 43195 */
	"SPI_CONFIG_CNTL_1\0" /* 43211 */
	"SPI_RESOURCE_RESERVE_CU_AB_0\0" /* 43229 */
	"DB_SUBTILE_CONTROL\0" /* 43258 */
	"GB_ADDR_CONFIG\0" /* 43277 */
	"GB_TILE_MODE0\0" /* 43292 */
	"GB_TILE_MODE1\0" /* 43306 */
	"GB_TILE_MODE2\0" /* 43320 */
	"GB_TILE_MODE3\0" /* 43334 */
	"GB_TILE_MODE4\0" /* 43348 */
	"GB_TILE_MODE5\0" /* 43362 */
	"GB_TILE_MODE6\0" /* 43376 */
	"GB_TILE_MODE7\0" /* 43390 */
	"GB_TILE_MODE8\0" /* 43404 */
	"GB_TILE_MODE9\0" /* 43418 */
	"GB_TILE_MODE10\0" /* 43432 */
	"GB_TILE_MODE11\0" /* 43447 */
	"GB_TILE_MODE12\0" /* 43462 */
	"GB_TILE_MODE13\0" /* 43477 */
	"GB_TILE_MODE14\0" /* 43492 */
	"GB_TILE_MODE15\0" /* 43507 */
	"GB_TILE_MODE16\0" /* 43522 */
	"GB_TILE_MODE17\0" /* 43537 */
	"GB_TILE_MODE18\0" /* 43552 */
	"GB_TILE_MODE19\0" /* 43567 */
	"GB_TILE_MODE20\0" /* 43582 */
	"GB_TILE_MODE21\0" /* 43597 */
	"GB_TILE_MODE22\0" /* 43612 */
	"GB_TILE_MODE23\0" /* 43627 */
	"GB_TILE_MODE24\0" /* 43642 */
	"GB_TILE_MODE25\0" /* 43657 */
	"GB_TILE_MODE26\0" /* 43672 */
	"GB_TILE_MODE27\0" /* 43687 */
	"GB_TILE_MODE28\0" /* 43702 */
	"GB_TILE_MODE29\0" /* 43717 */
	"GB_TILE_MODE30\0" /* 43732 */
	"GB_TILE_MODE31\0" /* 43747 */
	"GB_MACROTILE_MODE0\0" /* 43762 */
	"GB_MACROTILE_MODE1\0" /* 43781 */
	"GB_MACROTILE_MODE2\0" /* 43800 */
	"GB_MACROTILE_MODE3\0" /* 43819 */
	"GB_MACROTILE_MODE4\0" /* 43838 */
	"GB_MACROTILE_MODE5\0" /* 43857 */
	"GB_MACROTILE_MODE6\0" /* 43876 */
	"GB_MACROTILE_MODE7\0" /* 43895 */
	"GB_MACROTILE_MODE8\0" /* 43914 */
	"GB_MACROTILE_MODE9\0" /* 43933 */
	"GB_MACROTILE_MODE10\0" /* 43952 */
	"GB_MACROTILE_MODE11\0" /* 43972 */
	"GB_MACROTILE_MODE12\0" /* 43992 */
	"GB_MACROTILE_MODE13\0" /* 44012 */
	"GB_MACROTILE_MODE14\0" /* 44032 */
	"GB_MACROTILE_MODE15\0" /* 44052 */
	"SPI_SHADER_TBA_LO_PS\0" /* 44072 */
	"SPI_SHADER_TBA_HI_PS\0" /* 44093 */
	"SPI_SHADER_TMA_LO_PS\0" /* 44114 */
	"SPI_SHADER_TMA_HI_PS\0" /* 44135 */
	"SPI_SHADER_PGM_RSRC3_PS\0" /* 44156 */
	"SPI_SHADER_PGM_LO_PS\0" /* 44180 */
	"SPI_SHADER_PGM_HI_PS\0" /* 44201 */
	"SPI_SHADER_PGM_RSRC1_PS\0" /* 44222 */
	"SPI_SHADER_PGM_RSRC2_PS\0" /* 44246 */
	"SPI_SHADER_USER_DATA_PS_0\0" /* 44270 */
	"SPI_SHADER_USER_DATA_PS_1\0" /* 44296 */
	"SPI_SHADER_USER_DATA_PS_2\0" /* 44322 */
	"SPI_SHADER_USER_DATA_PS_3\0" /* 44348 */
	"SPI_SHADER_USER_DATA_PS_4\0" /* 44374 */
	"SPI_SHADER_USER_DATA_PS_5\0" /* 44400 */
	"SPI_SHADER_USER_DATA_PS_6\0" /* 44426 */
	"SPI_SHADER_USER_DATA_PS_7\0" /* 44452 */
	"SPI_SHADER_USER_DATA_PS_8\0" /* 44478 */
	"SPI_SHADER_USER_DATA_PS_9\0" /* 44504 */
	"SPI_SHADER_USER_DATA_PS_10\0" /* 44530 */
	"SPI_SHADER_USER_DATA_PS_11\0" /* 44557 */
	"SPI_SHADER_USER_DATA_PS_12\0" /* 44584 */
	"SPI_SHADER_USER_DATA_PS_13\0" /* 44611 */
	"SPI_SHADER_USER_DATA_PS_14\0" /* 44638 */
	"SPI_SHADER_USER_DATA_PS_15\0" /* 44665 */
	"SPI_SHADER_TBA_LO_VS\0" /* 44692 */
	"SPI_SHADER_TBA_HI_VS\0" /* 44713 */
	"SPI_SHADER_TMA_LO_VS\0" /* 44734 */
	"SPI_SHADER_TMA_HI_VS\0" /* 44755 */
	"SPI_SHADER_PGM_RSRC3_VS\0" /* 44776 */
	"SPI_SHADER_LATE_ALLOC_VS\0" /* 44800 */
	"SPI_SHADER_PGM_LO_VS\0" /* 44825 */
	"SPI_SHADER_PGM_HI_VS\0" /* 44846 */
	"SPI_SHADER_PGM_RSRC1_VS\0" /* 44867 */
	"SPI_SHADER_PGM_RSRC2_VS\0" /* 44891 */
	"SPI_SHADER_USER_DATA_VS_0\0" /* 44915 */
	"SPI_SHADER_USER_DATA_VS_1\0" /* 44941 */
	"SPI_SHADER_USER_DATA_VS_2\0" /* 44967 */
	"SPI_SHADER_USER_DATA_VS_3\0" /* 44993 */
	"SPI_SHADER_USER_DATA_VS_4\0" /* 45019 */
	"SPI_SHADER_USER_DATA_VS_5\0" /* 45045 */
	"SPI_SHADER_USER_DATA_VS_6\0" /* 45071 */
	"SPI_SHADER_USER_DATA_VS_7\0" /* 45097 */
	"SPI_SHADER_USER_DATA_VS_8\0" /* 45123 */
	"SPI_SHADER_USER_DATA_VS_9\0" /* 45149 */
	"SPI_SHADER_USER_DATA_VS_10\0" /* 45175 */
	"SPI_SHADER_USER_DATA_VS_11\0" /* 45202 */
	"SPI_SHADER_USER_DATA_VS_12\0" /* 45229 */
	"SPI_SHADER_USER_DATA_VS_13\0" /* 45256 */
	"SPI_SHADER_USER_DATA_VS_14\0" /* 45283 */
	"SPI_SHADER_USER_DATA_VS_15\0" /* 45310 */
	"SPI_SHADER_TBA_LO_GS\0" /* 45337 */
	"SPI_SHADER_TBA_HI_GS\0" /* 45358 */
	"SPI_SHADER_TMA_LO_GS\0" /* 45379 */
	"SPI_SHADER_TMA_HI_GS\0" /* 45400 */
	"SPI_SHADER_PGM_RSRC3_GS\0" /* 45421 */
	"SPI_SHADER_PGM_LO_GS\0" /* 45445 */
	"SPI_SHADER_PGM_HI_GS\0" /* 45466 */
	"SPI_SHADER_PGM_RSRC1_GS\0" /* 45487 */
	"SPI_SHADER_PGM_RSRC2_GS\0" /* 45511 */
	"SPI_SHADER_USER_DATA_GS_0\0" /* 45535 */
	"SPI_SHADER_USER_DATA_GS_1\0" /* 45561 */
	"SPI_SHADER_USER_DATA_GS_2\0" /* 45587 */
	"SPI_SHADER_USER_DATA_GS_3\0" /* 45613 */
	"SPI_SHADER_USER_DATA_GS_4\0" /* 45639 */
	"SPI_SHADER_USER_DATA_GS_5\0" /* 45665 */
	"SPI_SHADER_USER_DATA_GS_6\0" /* 45691 */
	"SPI_SHADER_USER_DATA_GS_7\0" /* 45717 */
	"SPI_SHADER_USER_DATA_GS_8\0" /* 45743 */
	"SPI_SHADER_USER_DATA_GS_9\0" /* 45769 */
	"SPI_SHADER_USER_DATA_GS_10\0" /* 45795 */
	"SPI_SHADER_USER_DATA_GS_11\0" /* 45822 */
	"SPI_SHADER_USER_DATA_GS_12\0" /* 45849 */
	"SPI_SHADER_USER_DATA_GS_13\0" /* 45876 */
	"SPI_SHADER_USER_DATA_GS_14\0" /* 45903 */
	"SPI_SHADER_USER_DATA_GS_15\0" /* 45930 */
	"SPI_SHADER_TBA_LO_ES\0" /* 45957 */
	"SPI_SHADER_TBA_HI_ES\0" /* 45978 */
	"SPI_SHADER_TMA_LO_ES\0" /* 45999 */
	"SPI_SHADER_TMA_HI_ES\0" /* 46020 */
	"SPI_SHADER_PGM_RSRC3_ES\0" /* 46041 */
	"SPI_SHADER_PGM_LO_ES\0" /* 46065 */
	"SPI_SHADER_PGM_HI_ES\0" /* 46086 */
	"SPI_SHADER_PGM_RSRC1_ES\0" /* 46107 */
	"SPI_SHADER_PGM_RSRC2_ES\0" /* 46131 */
	"SPI_SHADER_USER_DATA_ES_0\0" /* 46155 */
	"SPI_SHADER_USER_DATA_ES_1\0" /* 46181 */
	"SPI_SHADER_USER_DATA_ES_2\0" /* 46207 */
	"SPI_SHADER_USER_DATA_ES_3\0" /* 46233 */
	"SPI_SHADER_USER_DATA_ES_4\0" /* 46259 */
	"SPI_SHADER_USER_DATA_ES_5\0" /* 46285 */
	"SPI_SHADER_USER_DATA_ES_6\0" /* 46311 */
	"SPI_SHADER_USER_DATA_ES_7\0" /* 46337 */
	"SPI_SHADER_USER_DATA_ES_8\0" /* 46363 */
	"SPI_SHADER_USER_DATA_ES_9\0" /* 46389 */
	"SPI_SHADER_USER_DATA_ES_10\0" /* 46415 */
	"SPI_SHADER_USER_DATA_ES_11\0" /* 46442 */
	"SPI_SHADER_USER_DATA_ES_12\0" /* 46469 */
	"SPI_SHADER_USER_DATA_ES_13\0" /* 46496 */
	"SPI_SHADER_USER_DATA_ES_14\0" /* 46523 */
	"SPI_SHADER_USER_DATA_ES_15\0" /* 46550 */
	"SPI_SHADER_TBA_LO_HS\0" /* 46577 */
	"SPI_SHADER_TBA_HI_HS\0" /* 46598 */
	"SPI_SHADER_TMA_LO_HS\0" /* 46619 */
	"SPI_SHADER_TMA_HI_HS\0" /* 46640 */
	"SPI_SHADER_PGM_RSRC3_HS\0" /* 46661 */
	"SPI_SHADER_PGM_LO_HS\0" /* 46685 */
	"SPI_SHADER_PGM_HI_HS\0" /* 46706 */
	"SPI_SHADER_PGM_RSRC1_HS\0" /* 46727 */
	"SPI_SHADER_PGM_RSRC2_HS\0" /* 46751 */
	"SPI_SHADER_USER_DATA_HS_0\0" /* 46775 */
	"SPI_SHADER_USER_DATA_HS_1\0" /* 46801 */
	"SPI_SHADER_USER_DATA_HS_2\0" /* 46827 */
	"SPI_SHADER_USER_DATA_HS_3\0" /* 46853 */
	"SPI_SHADER_USER_DATA_HS_4\0" /* 46879 */
	"SPI_SHADER_USER_DATA_HS_5\0" /* 46905 */
	"SPI_SHADER_USER_DATA_HS_6\0" /* 46931 */
	"SPI_SHADER_USER_DATA_HS_7\0" /* 46957 */
	"SPI_SHADER_USER_DATA_HS_8\0" /* 46983 */
	"SPI_SHADER_USER_DATA_HS_9\0" /* 47009 */
	"SPI_SHADER_USER_DATA_HS_10\0" /* 47035 */
	"SPI_SHADER_USER_DATA_HS_11\0" /* 47062 */
	"SPI_SHADER_USER_DATA_HS_12\0" /* 47089 */
	"SPI_SHADER_USER_DATA_HS_13\0" /* 47116 */
	"SPI_SHADER_USER_DATA_HS_14\0" /* 47143 */
	"SPI_SHADER_USER_DATA_HS_15\0" /* 47170 */
	"SPI_SHADER_TBA_LO_LS\0" /* 47197 */
	"SPI_SHADER_TBA_HI_LS\0" /* 47218 */
	"SPI_SHADER_TMA_LO_LS\0" /* 47239 */
	"SPI_SHADER_TMA_HI_LS\0" /* 47260 */
	"SPI_SHADER_PGM_RSRC3_LS\0" /* 47281 */
	"SPI_SHADER_PGM_LO_LS\0" /* 47305 */
	"SPI_SHADER_PGM_HI_LS\0" /* 47326 */
	"SPI_SHADER_PGM_RSRC1_LS\0" /* 47347 */
	"SPI_SHADER_PGM_RSRC2_LS\0" /* 47371 */
	"SPI_SHADER_USER_DATA_LS_0\0" /* 47395 */
	"SPI_SHADER_USER_DATA_LS_1\0" /* 47421 */
	"SPI_SHADER_USER_DATA_LS_2\0" /* 47447 */
	"SPI_SHADER_USER_DATA_LS_3\0" /* 47473 */
	"SPI_SHADER_USER_DATA_LS_4\0" /* 47499 */
	"SPI_SHADER_USER_DATA_LS_5\0" /* 47525 */
	"SPI_SHADER_USER_DATA_LS_6\0" /* 47551 */
	"SPI_SHADER_USER_DATA_LS_7\0" /* 47577 */
	"SPI_SHADER_USER_DATA_LS_8\0" /* 47603 */
	"SPI_SHADER_USER_DATA_LS_9\0" /* 47629 */
	"SPI_SHADER_USER_DATA_LS_10\0" /* 47655 */
	"SPI_SHADER_USER_DATA_LS_11\0" /* 47682 */
	"SPI_SHADER_USER_DATA_LS_12\0" /* 47709 */
	"SPI_SHADER_USER_DATA_LS_13\0" /* 47736 */
	"SPI_SHADER_USER_DATA_LS_14\0" /* 47763 */
	"SPI_SHADER_USER_DATA_LS_15\0" /* 47790 */
	"COMPUTE_DISPATCH_INITIATOR\0" /* 47817 */
	"COMPUTE_DIM_X\0" /* 47844 */
	"COMPUTE_DIM_Y\0" /* 47858 */
	"COMPUTE_DIM_Z\0" /* 47872 */
	"COMPUTE_START_X\0" /* 47886 */
	"COMPUTE_START_Y\0" /* 47902 */
	"COMPUTE_START_Z\0" /* 47918 */
	"COMPUTE_NUM_THREAD_X\0" /* 47934 */
	"COMPUTE_NUM_THREAD_Y\0" /* 47955 */
	"COMPUTE_NUM_THREAD_Z\0" /* 47976 */
	"COMPUTE_MAX_WAVE_ID\0" /* 47997 */
	"COMPUTE_PIPELINESTAT_ENABLE\0" /* 48017 */
	"COMPUTE_PERFCOUNT_ENABLE\0" /* 48045 */
	"COMPUTE_PGM_LO\0" /* 48070 */
	"COMPUTE_PGM_HI\0" /* 48085 */
	"COMPUTE_TBA_LO\0" /* 48100 */
	"COMPUTE_TBA_HI\0" /* 48115 */
	"COMPUTE_TMA_LO\0" /* 48130 */
	"COMPUTE_TMA_HI\0" /* 48145 */
	"COMPUTE_PGM_RSRC1\0" /* 48160 */
	"COMPUTE_PGM_RSRC2\0" /* 48178 */
	"COMPUTE_VMID\0" /* 48196 */
	"COMPUTE_RESOURCE_LIMITS\0" /* 48209 */
	"COMPUTE_STATIC_THREAD_MGMT_SE0\0" /* 48233 */
	"COMPUTE_STATIC_THREAD_MGMT_SE1\0" /* 48264 */
	"COMPUTE_TMPRING_SIZE\0" /* 48295 */
	"COMPUTE_STATIC_THREAD_MGMT_SE2\0" /* 48316 */
	"COMPUTE_STATIC_THREAD_MGMT_SE3\0" /* 48347 */
	"COMPUTE_RESTART_X\0" /* 48378 */
	"COMPUTE_RESTART_Y\0" /* 48396 */
	"COMPUTE_RESTART_Z\0" /* 48414 */
	"COMPUTE_MISC_RESERVED\0" /* 48432 */
	"COMPUTE_DISPATCH_ID\0" /* 48454 */
	"COMPUTE_THREADGROUP_ID\0" /* 48474 */
	"COMPUTE_RELAUNCH\0" /* 48497 */
	"COMPUTE_WAVE_RESTORE_ADDR_LO\0" /* 48514 */
	"COMPUTE_WAVE_RESTORE_ADDR_HI\0" /* 48543 */
	"COMPUTE_WAVE_RESTORE_CONTROL\0" /* 48572 */
	"COMPUTE_USER_DATA_0\0" /* 48601 */
	"COMPUTE_USER_DATA_1\0" /* 48621 */
	"COMPUTE_USER_DATA_2\0" /* 48641 */
	"COMPUTE_USER_DATA_3\0" /* 48661 */
	"COMPUTE_USER_DATA_4\0" /* 48681 */
	"COMPUTE_USER_DATA_5\0" /* 48701 */
	"COMPUTE_USER_DATA_6\0" /* 48721 */
	"COMPUTE_USER_DATA_7\0" /* 48741 */
	"COMPUTE_USER_DATA_8\0" /* 48761 */
	"COMPUTE_USER_DATA_9\0" /* 48781 */
	"COMPUTE_USER_DATA_10\0" /* 48801 */
	"COMPUTE_USER_DATA_11\0" /* 48822 */
	"COMPUTE_USER_DATA_12\0" /* 48843 */
	"COMPUTE_USER_DATA_13\0" /* 48864 */
	"COMPUTE_USER_DATA_14\0" /* 48885 */
	"COMPUTE_USER_DATA_15\0" /* 48906 */
	"COMPUTE_NOWHERE\0" /* 48927 */
	"CPG_PERFCOUNTER1_LO\0" /* 48943 */
	"CPG_PERFCOUNTER1_HI\0" /* 48963 */
	"CPG_PERFCOUNTER0_LO\0" /* 48983 */
	"CPG_PERFCOUNTER0_HI\0" /* 49003 */
	"CPC_PERFCOUNTER1_LO\0" /* 49023 */
	"CPC_PERFCOUNTER1_HI\0" /* 49043 */
	"CPC_PERFCOUNTER0_LO\0" /* 49063 */
	"CPC_PERFCOUNTER0_HI\0" /* 49083 */
	"CPF_PERFCOUNTER1_LO\0" /* 49103 */
	"CPF_PERFCOUNTER1_HI\0" /* 49123 */
	"CPF_PERFCOUNTER0_LO\0" /* 49143 */
	"CPF_PERFCOUNTER0_HI\0" /* 49163 */
	"GRBM_PERFCOUNTER0_LO\0" /* 49183 */
	"GRBM_PERFCOUNTER0_HI\0" /* 49204 */
	"GRBM_PERFCOUNTER1_LO\0" /* 49225 */
	"GRBM_PERFCOUNTER1_HI\0" /* 49246 */
	"GRBM_SE0_PERFCOUNTER_LO\0" /* 49267 */
	"GRBM_SE0_PERFCOUNTER_HI\0" /* 49291 */
	"GRBM_SE1_PERFCOUNTER_LO\0" /* 49315 */
	"GRBM_SE1_PERFCOUNTER_HI\0" /* 49339 */
	"GRBM_SE2_PERFCOUNTER_LO\0" /* 49363 */
	"GRBM_SE2_PERFCOUNTER_HI\0" /* 49387 */
	"GRBM_SE3_PERFCOUNTER_LO\0" /* 49411 */
	"GRBM_SE3_PERFCOUNTER_HI\0" /* 49435 */
	"WD_PERFCOUNTER0_LO\0" /* 49459 */
	"WD_PERFCOUNTER0_HI\0" /* 49478 */
	"WD_PERFCOUNTER1_LO\0" /* 49497 */
	"WD_PERFCOUNTER1_HI\0" /* 49516 */
	"WD_PERFCOUNTER2_LO\0" /* 49535 */
	"WD_PERFCOUNTER2_HI\0" /* 49554 */
	"WD_PERFCOUNTER3_LO\0" /* 49573 */
	"WD_PERFCOUNTER3_HI\0" /* 49592 */
	"IA_PERFCOUNTER0_LO\0" /* 49611 */
	"IA_PERFCOUNTER0_HI\0" /* 49630 */
	"IA_PERFCOUNTER1_LO\0" /* 49649 */
	"IA_PERFCOUNTER1_HI\0" /* 49668 */
	"IA_PERFCOUNTER2_LO\0" /* 49687 */
	"IA_PERFCOUNTER2_HI\0" /* 49706 */
	"IA_PERFCOUNTER3_LO\0" /* 49725 */
	"IA_PERFCOUNTER3_HI\0" /* 49744 */
	"VGT_PERFCOUNTER0_LO\0" /* 49763 */
	"VGT_PERFCOUNTER0_HI\0" /* 49783 */
	"VGT_PERFCOUNTER1_LO\0" /* 49803 */
	"VGT_PERFCOUNTER1_HI\0" /* 49823 */
	"VGT_PERFCOUNTER2_LO\0" /* 49843 */
	"VGT_PERFCOUNTER2_HI\0" /* 49863 */
	"VGT_PERFCOUNTER3_LO\0" /* 49883 */
	"VGT_PERFCOUNTER3_HI\0" /* 49903 */
	"PA_SU_PERFCOUNTER0_LO\0" /* 49923 */
	"PA_SU_PERFCOUNTER0_HI\0" /* 49945 */
	"PA_SU_PERFCOUNTER1_LO\0" /* 49967 */
	"PA_SU_PERFCOUNTER1_HI\0" /* 49989 */
	"PA_SU_PERFCOUNTER2_LO\0" /* 50011 */
	"PA_SU_PERFCOUNTER2_HI\0" /* 50033 */
	"PA_SU_PERFCOUNTER3_LO\0" /* 50055 */
	"PA_SU_PERFCOUNTER3_HI\0" /* 50077 */
	"PA_SC_PERFCOUNTER0_LO\0" /* 50099 */
	"PA_SC_PERFCOUNTER0_HI\0" /* 50121 */
	"PA_SC_PERFCOUNTER1_LO\0" /* 50143 */
	"PA_SC_PERFCOUNTER1_HI\0" /* 50165 */
	"PA_SC_PERFCOUNTER2_LO\0" /* 50187 */
	"PA_SC_PERFCOUNTER2_HI\0" /* 50209 */
	"PA_SC_PERFCOUNTER3_LO\0" /* 50231 */
	"PA_SC_PERFCOUNTER3_HI\0" /* 50253 */
	"PA_SC_PERFCOUNTER4_LO\0" /* 50275 */
	"PA_SC_PERFCOUNTER4_HI\0" /* 50297 */
	"PA_SC_PERFCOUNTER5_LO\0" /* 50319 */
	"PA_SC_PERFCOUNTER5_HI\0" /* 50341 */
	"PA_SC_PERFCOUNTER6_LO\0" /* 50363 */
	"PA_SC_PERFCOUNTER6_HI\0" /* 50385 */
	"PA_SC_PERFCOUNTER7_LO\0" /* 50407 */
	"PA_SC_PERFCOUNTER7_HI\0" /* 50429 */
	"SPI_PERFCOUNTER0_HI\0" /* 50451 */
	"SPI_PERFCOUNTER0_LO\0" /* 50471 */
	"SPI_PERFCOUNTER1_HI\0" /* 50491 */
	"SPI_PERFCOUNTER1_LO\0" /* 50511 */
	"SPI_PERFCOUNTER2_HI\0" /* 50531 */
	"SPI_PERFCOUNTER2_LO\0" /* 50551 */
	"SPI_PERFCOUNTER3_HI\0" /* 50571 */
	"SPI_PERFCOUNTER3_LO\0" /* 50591 */
	"SPI_PERFCOUNTER4_HI\0" /* 50611 */
	"SPI_PERFCOUNTER4_LO\0" /* 50631 */
	"SPI_PERFCOUNTER5_HI\0" /* 50651 */
	"SPI_PERFCOUNTER5_LO\0" /* 50671 */
	"SQ_PERFCOUNTER0_LO\0" /* 50691 */
	"SQ_PERFCOUNTER0_HI\0" /* 50710 */
	"SQ_PERFCOUNTER1_LO\0" /* 50729 */
	"SQ_PERFCOUNTER1_HI\0" /* 50748 */
	"SQ_PERFCOUNTER2_LO\0" /* 50767 */
	"SQ_PERFCOUNTER2_HI\0" /* 50786 */
	"SQ_PERFCOUNTER3_LO\0" /* 50805 */
	"SQ_PERFCOUNTER3_HI\0" /* 50824 */
	"SQ_PERFCOUNTER4_LO\0" /* 50843 */
	"SQ_PERFCOUNTER4_HI\0" /* 50862 */
	"SQ_PERFCOUNTER5_LO\0" /* 50881 */
	"SQ_PERFCOUNTER5_HI\0" /* 50900 */
	"SQ_PERFCOUNTER6_LO\0" /* 50919 */
	"SQ_PERFCOUNTER6_HI\0" /* 50938 */
	"SQ_PERFCOUNTER7_LO\0" /* 50957 */
	"SQ_PERFCOUNTER7_HI\0" /* 50976 */
	"SQ_PERFCOUNTER8_LO\0" /* 50995 */
	"SQ_PERFCOUNTER8_HI\0" /* 51014 */
	"SQ_PERFCOUNTER9_LO\0" /* 51033 */
	"SQ_PERFCOUNTER9_HI\0" /* 51052 */
	"SQ_PERFCOUNTER10_LO\0" /* 51071 */
	"SQ_PERFCOUNTER10_HI\0" /* 51091 */
	"SQ_PERFCOUNTER11_LO\0" /* 51111 */
	"SQ_PERFCOUNTER11_HI\0" /* 51131 */
	"SQ_PERFCOUNTER12_LO\0" /* 51151 */
	"SQ_PERFCOUNTER12_HI\0" /* 51171 */
	"SQ_PERFCOUNTER13_LO\0" /* 51191 */
	"SQ_PERFCOUNTER13_HI\0" /* 51211 */
	"SQ_PERFCOUNTER14_LO\0" /* 51231 */
	"SQ_PERFCOUNTER14_HI\0" /* 51251 */
	"SQ_PERFCOUNTER15_LO\0" /* 51271 */
	"SQ_PERFCOUNTER15_HI\0" /* 51291 */
	"SX_PERFCOUNTER0_LO\0" /* 51311 */
	"SX_PERFCOUNTER0_HI\0" /* 51330 */
	"SX_PERFCOUNTER1_LO\0" /* 51349 */
	"SX_PERFCOUNTER1_HI\0" /* 51368 */
	"SX_PERFCOUNTER2_LO\0" /* 51387 */
	"SX_PERFCOUNTER2_HI\0" /* 51406 */
	"SX_PERFCOUNTER3_LO\0" /* 51425 */
	"SX_PERFCOUNTER3_HI\0" /* 51444 */
	"GDS_PERFCOUNTER0_LO\0" /* 51463 */
	"GDS_PERFCOUNTER0_HI\0" /* 51483 */
	"GDS_PERFCOUNTER1_LO\0" /* 51503 */
	"GDS_PERFCOUNTER1_HI\0" /* 51523 */
	"GDS_PERFCOUNTER2_LO\0" /* 51543 */
	"GDS_PERFCOUNTER2_HI\0" /* 51563 */
	"GDS_PERFCOUNTER3_LO\0" /* 51583 */
	"GDS_PERFCOUNTER3_HI\0" /* 51603 */
	"TA_PERFCOUNTER0_LO\0" /* 51623 */
	"TA_PERFCOUNTER0_HI\0" /* 51642 */
	"TA_PERFCOUNTER1_LO\0" /* 51661 */
	"TA_PERFCOUNTER1_HI\0" /* 51680 */
	"TD_PERFCOUNTER0_LO\0" /* 51699 */
	"TD_PERFCOUNTER0_HI\0" /* 51718 */
	"TD_PERFCOUNTER1_LO\0" /* 51737 */
	"TD_PERFCOUNTER1_HI\0" /* 51756 */
	"TCP_PERFCOUNTER0_LO\0" /* 51775 */
	"TCP_PERFCOUNTER0_HI\0" /* 51795 */
	"TCP_PERFCOUNTER1_LO\0" /* 51815 */
	"TCP_PERFCOUNTER1_HI\0" /* 51835 */
	"TCP_PERFCOUNTER2_LO\0" /* 51855 */
	"TCP_PERFCOUNTER2_HI\0" /* 51875 */
	"TCP_PERFCOUNTER3_LO\0" /* 51895 */
	"TCP_PERFCOUNTER3_HI\0" /* 51915 */
	"TCC_PERFCOUNTER0_LO\0" /* 51935 */
	"TCC_PERFCOUNTER0_HI\0" /* 51955 */
	"TCC_PERFCOUNTER1_LO\0" /* 51975 */
	"TCC_PERFCOUNTER1_HI\0" /* 51995 */
	"TCC_PERFCOUNTER2_LO\0" /* 52015 */
	"TCC_PERFCOUNTER2_HI\0" /* 52035 */
	"TCC_PERFCOUNTER3_LO\0" /* 52055 */
	"TCC_PERFCOUNTER3_HI\0" /* 52075 */
	"TCA_PERFCOUNTER0_LO\0" /* 52095 */
	"TCA_PERFCOUNTER0_HI\0" /* 52115 */
	"TCA_PERFCOUNTER1_LO\0" /* 52135 */
	"TCA_PERFCOUNTER1_HI\0" /* 52155 */
	"TCA_PERFCOUNTER2_LO\0" /* 52175 */
	"TCA_PERFCOUNTER2_HI\0" /* 52195 */
	"TCA_PERFCOUNTER3_LO\0" /* 52215 */
	"TCA_PERFCOUNTER3_HI\0" /* 52235 */
	"CB_PERFCOUNTER0_LO\0" /* 52255 */
	"CB_PERFCOUNTER0_HI\0" /* 52274 */
	"CB_PERFCOUNTER1_LO\0" /* 52293 */
	"CB_PERFCOUNTER1_HI\0" /* 52312 */
	"CB_PERFCOUNTER2_LO\0" /* 52331 */
	"CB_PERFCOUNTER2_HI\0" /* 52350 */
	"CB_PERFCOUNTER3_LO\0" /* 52369 */
	"CB_PERFCOUNTER3_HI\0" /* 52388 */
	"DB_PERFCOUNTER0_LO\0" /* 52407 */
	"DB_PERFCOUNTER0_HI\0" /* 52426 */
	"DB_PERFCOUNTER1_LO\0" /* 52445 */
	"DB_PERFCOUNTER1_HI\0" /* 52464 */
	"DB_PERFCOUNTER2_LO\0" /* 52483 */
	"DB_PERFCOUNTER2_HI\0" /* 52502 */
	"DB_PERFCOUNTER3_LO\0" /* 52521 */
	"DB_PERFCOUNTER3_HI\0" /* 52540 */
	"RLC_PERFCOUNTER0_LO\0" /* 52559 */
	"RLC_PERFCOUNTER0_HI\0" /* 52579 */
	"RLC_PERFCOUNTER1_LO\0" /* 52599 */
	"RLC_PERFCOUNTER1_HI\0" /* 52619 */
	"CPG_PERFCOUNTER1_SELECT\0" /* 52639 */
	"CPG_PERFCOUNTER0_SELECT1\0" /* 52663 */
	"CPG_PERFCOUNTER0_SELECT\0" /* 52688 */
	"CPC_PERFCOUNTER1_SELECT\0" /* 52712 */
	"CPC_PERFCOUNTER0_SELECT1\0" /* 52736 */
	"CPF_PERFCOUNTER1_SELECT\0" /* 52761 */
	"CPF_PERFCOUNTER0_SELECT1\0" /* 52785 */
	"CPF_PERFCOUNTER0_SELECT\0" /* 52810 */
	"CP_PERFMON_CNTL\0" /* 52834 */
	"CPC_PERFCOUNTER0_SELECT\0" /* 52850 */
	"GRBM_PERFCOUNTER0_SELECT\0" /* 52874 */
	"GRBM_PERFCOUNTER1_SELECT\0" /* 52899 */
	"GRBM_SE0_PERFCOUNTER_SELECT\0" /* 52924 */
	"GRBM_SE1_PERFCOUNTER_SELECT\0" /* 52952 */
	"GRBM_SE2_PERFCOUNTER_SELECT\0" /* 52980 */
	"GRBM_SE3_PERFCOUNTER_SELECT\0" /* 53008 */
	"WD_PERFCOUNTER0_SELECT\0" /* 53036 */
	"WD_PERFCOUNTER1_SELECT\0" /* 53059 */
	"WD_PERFCOUNTER2_SELECT\0" /* 53082 */
	"WD_PERFCOUNTER3_SELECT\0" /* 53105 */
	"IA_PERFCOUNTER0_SELECT\0" /* 53128 */
	"IA_PERFCOUNTER1_SELECT\0" /* 53151 */
	"IA_PERFCOUNTER2_SELECT\0" /* 53174 */
	"IA_PERFCOUNTER3_SELECT\0" /* 53197 */
	"IA_PERFCOUNTER0_SELECT1\0" /* 53220 */
	"VGT_PERFCOUNTER0_SELECT\0" /* 53244 */
	"VGT_PERFCOUNTER1_SELECT\0" /* 53268 */
	"VGT_PERFCOUNTER2_SELECT\0" /* 53292 */
	"VGT_PERFCOUNTER3_SELECT\0" /* 53316 */
	"VGT_PERFCOUNTER0_SELECT1\0" /* 53340 */
	"VGT_PERFCOUNTER1_SELECT1\0" /* 53365 */
	"VGT_PERFCOUNTER_SEID_MASK\0" /* 53390 */
	"PA_SU_PERFCOUNTER0_SELECT\0" /* 53416 */
	"PA_SU_PERFCOUNTER0_SELECT1\0" /* 53442 */
	"PA_SU_PERFCOUNTER1_SELECT\0" /* 53469 */
	"PA_SU_PERFCOUNTER1_SELECT1\0" /* 53495 */
	"PA_SU_PERFCOUNTER2_SELECT\0" /* 53522 */
	"PA_SU_PERFCOUNTER3_SELECT\0" /* 53548 */
	"PA_SC_PERFCOUNTER0_SELECT\0" /* 53574 */
	"PA_SC_PERFCOUNTER0_SELECT1\0" /* 53600 */
	"PA_SC_PERFCOUNTER1_SELECT\0" /* 53627 */
	"PA_SC_PERFCOUNTER2_SELECT\0" /* 53653 */
	"PA_SC_PERFCOUNTER3_SELECT\0" /* 53679 */
	"PA_SC_PERFCOUNTER4_SELECT\0" /* 53705 */
	"PA_SC_PERFCOUNTER5_SELECT\0" /* 53731 */
	"PA_SC_PERFCOUNTER6_SELECT\0" /* 53757 */
	"PA_SC_PERFCOUNTER7_SELECT\0" /* 53783 */
	"SPI_PERFCOUNTER0_SELECT\0" /* 53809 */
	"SPI_PERFCOUNTER1_SELECT\0" /* 53833 */
	"SPI_PERFCOUNTER2_SELECT\0" /* 53857 */
	"SPI_PERFCOUNTER3_SELECT\0" /* 53881 */
	"SPI_PERFCOUNTER0_SELECT1\0" /* 53905 */
	"SPI_PERFCOUNTER1_SELECT1\0" /* 53930 */
	"SPI_PERFCOUNTER2_SELECT1\0" /* 53955 */
	"SPI_PERFCOUNTER3_SELECT1\0" /* 53980 */
	"SPI_PERFCOUNTER4_SELECT\0" /* 54005 */
	"SPI_PERFCOUNTER5_SELECT\0" /* 54029 */
	"SPI_PERFCOUNTER_BINS\0" /* 54053 */
	"SQ_PERFCOUNTER0_SELECT\0" /* 54074 */
	"SQ_PERFCOUNTER1_SELECT\0" /* 54097 */
	"SQ_PERFCOUNTER2_SELECT\0" /* 54120 */
	"SQ_PERFCOUNTER3_SELECT\0" /* 54143 */
	"SQ_PERFCOUNTER4_SELECT\0" /* 54166 */
	"SQ_PERFCOUNTER5_SELECT\0" /* 54189 */
	"SQ_PERFCOUNTER6_SELECT\0" /* 54212 */
	"SQ_PERFCOUNTER7_SELECT\0" /* 54235 */
	"SQ_PERFCOUNTER8_SELECT\0" /* 54258 */
	"SQ_PERFCOUNTER9_SELECT\0" /* 54281 */
	"SQ_PERFCOUNTER10_SELECT\0" /* 54304 */
	"SQ_PERFCOUNTER11_SELECT\0" /* 54328 */
	"SQ_PERFCOUNTER12_SELECT\0" /* 54352 */
	"SQ_PERFCOUNTER13_SELECT\0" /* 54376 */
	"SQ_PERFCOUNTER14_SELECT\0" /* 54400 */
	"SQ_PERFCOUNTER15_SELECT\0" /* 54424 */
	"SQ_PERFCOUNTER_CTRL\0" /* 54448 */
	"SQ_PERFCOUNTER_MASK\0" /* 54468 */
	"SQ_PERFCOUNTER_CTRL2\0" /* 54488 */
	"SX_PERFCOUNTER0_SELECT\0" /* 54509 */
	"SX_PERFCOUNTER1_SELECT\0" /* 54532 */
	"SX_PERFCOUNTER2_SELECT\0" /* 54555 */
	"SX_PERFCOUNTER3_SELECT\0" /* 54578 */
	"SX_PERFCOUNTER0_SELECT1\0" /* 54601 */
	"SX_PERFCOUNTER1_SELECT1\0" /* 54625 */
	"GDS_PERFCOUNTER0_SELECT\0" /* 54649 */
	"GDS_PERFCOUNTER1_SELECT\0" /* 54673 */
	"GDS_PERFCOUNTER2_SELECT\0" /* 54697 */
	"GDS_PERFCOUNTER3_SELECT\0" /* 54721 */
	"GDS_PERFCOUNTER0_SELECT1\0" /* 54745 */
	"TA_PERFCOUNTER0_SELECT\0" /* 54770 */
	"TA_PERFCOUNTER0_SELECT1\0" /* 54793 */
	"TA_PERFCOUNTER1_SELECT\0" /* 54817 */
	"TD_PERFCOUNTER0_SELECT\0" /* 54840 */
	"TD_PERFCOUNTER0_SELECT1\0" /* 54863 */
	"TD_PERFCOUNTER1_SELECT\0" /* 54887 */
	"TCP_PERFCOUNTER0_SELECT\0" /* 54910 */
	"TCP_PERFCOUNTER0_SELECT1\0" /* 54934 */
	"TCP_PERFCOUNTER1_SELECT\0" /* 54959 */
	"TCP_PERFCOUNTER1_SELECT1\0" /* 54983 */
	"TCP_PERFCOUNTER2_SELECT\0" /* 55008 */
	"TCP_PERFCOUNTER3_SELECT\0" /* 55032 */
	"TCC_PERFCOUNTER0_SELECT\0" /* 55056 */
	"TCC_PERFCOUNTER0_SELECT1\0" /* 55080 */
	"TCC_PERFCOUNTER1_SELECT\0" /* 55105 */
	"TCC_PERFCOUNTER1_SELECT1\0" /* 55129 */
	"TCC_PERFCOUNTER2_SELECT\0" /* 55154 */
	"TCC_PERFCOUNTER3_SELECT\0" /* 55178 */
	"TCA_PERFCOUNTER0_SELECT\0" /* 55202 */
	"TCA_PERFCOUNTER0_SELECT1\0" /* 55226 */
	"TCA_PERFCOUNTER1_SELECT\0" /* 55251 */
	"TCA_PERFCOUNTER1_SELECT1\0" /* 55275 */
	"TCA_PERFCOUNTER2_SELECT\0" /* 55300 */
	"TCA_PERFCOUNTER3_SELECT\0" /* 55324 */
	"CB_PERFCOUNTER_FILTER\0" /* 55348 */
	"CB_PERFCOUNTER0_SELECT\0" /* 55370 */
	"CB_PERFCOUNTER0_SELECT1\0" /* 55393 */
	"CB_PERFCOUNTER1_SELECT\0" /* 55417 */
	"CB_PERFCOUNTER2_SELECT\0" /* 55440 */
	"CB_PERFCOUNTER3_SELECT\0" /* 55463 */
	"DB_PERFCOUNTER0_SELECT\0" /* 55486 */
	"DB_PERFCOUNTER0_SELECT1\0" /* 55509 */
	"DB_PERFCOUNTER1_SELECT\0" /* 55533 */
	"DB_PERFCOUNTER1_SELECT1\0" /* 55556 */
	"DB_PERFCOUNTER2_SELECT\0" /* 55580 */
	"DB_PERFCOUNTER3_SELECT\0" /* 55603 */
	"DB_RENDER_CONTROL\0" /* 55626 */
	"DB_COUNT_CONTROL\0" /* 55644 */
	"DB_DEPTH_VIEW\0" /* 55661 */
	"DB_RENDER_OVERRIDE\0" /* 55675 */
	"DB_RENDER_OVERRIDE2\0" /* 55694 */
	"DB_HTILE_DATA_BASE\0" /* 55714 */
	"DB_DEPTH_BOUNDS_MIN\0" /* 55733 */
	"DB_DEPTH_BOUNDS_MAX\0" /* 55753 */
	"DB_STENCIL_CLEAR\0" /* 55773 */
	"DB_DEPTH_CLEAR\0" /* 55790 */
	"PA_SC_SCREEN_SCISSOR_TL\0" /* 55805 */
	"PA_SC_SCREEN_SCISSOR_BR\0" /* 55829 */
	"DB_DEPTH_INFO\0" /* 55853 */
	"DB_Z_INFO\0" /* 55867 */
	"DB_STENCIL_INFO\0" /* 55877 */
	"DB_Z_READ_BASE\0" /* 55893 */
	"DB_STENCIL_READ_BASE\0" /* 55908 */
	"DB_Z_WRITE_BASE\0" /* 55929 */
	"DB_STENCIL_WRITE_BASE\0" /* 55945 */
	"DB_DEPTH_SIZE\0" /* 55967 */
	"DB_DEPTH_SLICE\0" /* 55981 */
	"TA_BC_BASE_ADDR\0" /* 55996 */
	"TA_BC_BASE_ADDR_HI\0" /* 56012 */
	"COHER_DEST_BASE_HI_0\0" /* 56031 */
	"COHER_DEST_BASE_HI_1\0" /* 56052 */
	"COHER_DEST_BASE_HI_2\0" /* 56073 */
	"COHER_DEST_BASE_HI_3\0" /* 56094 */
	"COHER_DEST_BASE_2\0" /* 56115 */
	"COHER_DEST_BASE_3\0" /* 56133 */
	"PA_SC_WINDOW_OFFSET\0" /* 56151 */
	"PA_SC_WINDOW_SCISSOR_TL\0" /* 56171 */
	"PA_SC_WINDOW_SCISSOR_BR\0" /* 56195 */
	"PA_SC_CLIPRECT_RULE\0" /* 56219 */
	"PA_SC_CLIPRECT_0_TL\0" /* 56239 */
	"PA_SC_CLIPRECT_0_BR\0" /* 56259 */
	"PA_SC_CLIPRECT_1_TL\0" /* 56279 */
	"PA_SC_CLIPRECT_1_BR\0" /* 56299 */
	"PA_SC_CLIPRECT_2_TL\0" /* 56319 */
	"PA_SC_CLIPRECT_2_BR\0" /* 56339 */
	"PA_SC_CLIPRECT_3_TL\0" /* 56359 */
	"PA_SC_CLIPRECT_3_BR\0" /* 56379 */
	"PA_SC_EDGERULE\0" /* 56399 */
	"PA_SU_HARDWARE_SCREEN_OFFSET\0" /* 56414 */
	"CB_TARGET_MASK\0" /* 56443 */
	"CB_SHADER_MASK\0" /* 56458 */
	"PA_SC_GENERIC_SCISSOR_TL\0" /* 56473 */
	"PA_SC_GENERIC_SCISSOR_BR\0" /* 56498 */
	"COHER_DEST_BASE_0\0" /* 56523 */
	"COHER_DEST_BASE_1\0" /* 56541 */
	"PA_SC_VPORT_SCISSOR_0_TL\0" /* 56559 */
	"PA_SC_VPORT_SCISSOR_0_BR\0" /* 56584 */
	"PA_SC_VPORT_SCISSOR_1_TL\0" /* 56609 */
	"PA_SC_VPORT_SCISSOR_1_BR\0" /* 56634 */
	"PA_SC_VPORT_SCISSOR_2_TL\0" /* 56659 */
	"PA_SC_VPORT_SCISSOR_2_BR\0" /* 56684 */
	"PA_SC_VPORT_SCISSOR_3_TL\0" /* 56709 */
	"PA_SC_VPORT_SCISSOR_3_BR\0" /* 56734 */
	"PA_SC_VPORT_SCISSOR_4_TL\0" /* 56759 */
	"PA_SC_VPORT_SCISSOR_4_BR\0" /* 56784 */
	"PA_SC_VPORT_SCISSOR_5_TL\0" /* 56809 */
	"PA_SC_VPORT_SCISSOR_5_BR\0" /* 56834 */
	"PA_SC_VPORT_SCISSOR_6_TL\0" /* 56859 */
	"PA_SC_VPORT_SCISSOR_6_BR\0" /* 56884 */
	"PA_SC_VPORT_SCISSOR_7_TL\0" /* 56909 */
	"PA_SC_VPORT_SCISSOR_7_BR\0" /* 56934 */
	"PA_SC_VPORT_SCISSOR_8_TL\0" /* 56959 */
	"PA_SC_VPORT_SCISSOR_8_BR\0" /* 56984 */
	"PA_SC_VPORT_SCISSOR_9_TL\0" /* 57009 */
	"PA_SC_VPORT_SCISSOR_9_BR\0" /* 57034 */
	"PA_SC_VPORT_SCISSOR_10_TL\0" /* 57059 */
	"PA_SC_VPORT_SCISSOR_10_BR\0" /* 57085 */
	"PA_SC_VPORT_SCISSOR_11_TL\0" /* 57111 */
	"PA_SC_VPORT_SCISSOR_11_BR\0" /* 57137 */
	"PA_SC_VPORT_SCISSOR_12_TL\0" /* 57163 */
	"PA_SC_VPORT_SCISSOR_12_BR\0" /* 57189 */
	"PA_SC_VPORT_SCISSOR_13_TL\0" /* 57215 */
	"PA_SC_VPORT_SCISSOR_13_BR\0" /* 57241 */
	"PA_SC_VPORT_SCISSOR_14_TL\0" /* 57267 */
	"PA_SC_VPORT_SCISSOR_14_BR\0" /* 57293 */
	"PA_SC_VPORT_SCISSOR_15_TL\0" /* 57319 */
	"PA_SC_VPORT_SCISSOR_15_BR\0" /* 57345 */
	"PA_SC_VPORT_ZMIN_0\0" /* 57371 */
	"PA_SC_VPORT_ZMAX_0\0" /* 57390 */
	"PA_SC_VPORT_ZMIN_1\0" /* 57409 */
	"PA_SC_VPORT_ZMAX_1\0" /* 57428 */
	"PA_SC_VPORT_ZMIN_2\0" /* 57447 */
	"PA_SC_VPORT_ZMAX_2\0" /* 57466 */
	"PA_SC_VPORT_ZMIN_3\0" /* 57485 */
	"PA_SC_VPORT_ZMAX_3\0" /* 57504 */
	"PA_SC_VPORT_ZMIN_4\0" /* 57523 */
	"PA_SC_VPORT_ZMAX_4\0" /* 57542 */
	"PA_SC_VPORT_ZMIN_5\0" /* 57561 */
	"PA_SC_VPORT_ZMAX_5\0" /* 57580 */
	"PA_SC_VPORT_ZMIN_6\0" /* 57599 */
	"PA_SC_VPORT_ZMAX_6\0" /* 57618 */
	"PA_SC_VPORT_ZMIN_7\0" /* 57637 */
	"PA_SC_VPORT_ZMAX_7\0" /* 57656 */
	"PA_SC_VPORT_ZMIN_8\0" /* 57675 */
	"PA_SC_VPORT_ZMAX_8\0" /* 57694 */
	"PA_SC_VPORT_ZMIN_9\0" /* 57713 */
	"PA_SC_VPORT_ZMAX_9\0" /* 57732 */
	"PA_SC_VPORT_ZMIN_10\0" /* 57751 */
	"PA_SC_VPORT_ZMAX_10\0" /* 57771 */
	"PA_SC_VPORT_ZMIN_11\0" /* 57791 */
	"PA_SC_VPORT_ZMAX_11\0" /* 57811 */
	"PA_SC_VPORT_ZMIN_12\0" /* 57831 */
	"PA_SC_VPORT_ZMAX_12\0" /* 57851 */
	"PA_SC_VPORT_ZMIN_13\0" /* 57871 */
	"PA_SC_VPORT_ZMAX_13\0" /* 57891 */
	"PA_SC_VPORT_ZMIN_14\0" /* 57911 */
	"PA_SC_VPORT_ZMAX_14\0" /* 57931 */
	"PA_SC_VPORT_ZMIN_15\0" /* 57951 */
	"PA_SC_VPORT_ZMAX_15\0" /* 57971 */
	"PA_SC_RASTER_CONFIG\0" /* 57991 */
	"PA_SC_RASTER_CONFIG_1\0" /* 58011 */
	"PA_SC_SCREEN_EXTENT_CONTROL\0" /* 58033 */
	"VGT_MAX_VTX_INDX\0" /* 58061 */
	"VGT_MIN_VTX_INDX\0" /* 58078 */
	"VGT_INDX_OFFSET\0" /* 58095 */
	"VGT_MULTI_PRIM_IB_RESET_INDX\0" /* 58111 */
	"CB_BLEND_RED\0" /* 58140 */
	"CB_BLEND_GREEN\0" /* 58153 */
	"CB_BLEND_BLUE\0" /* 58168 */
	"CB_BLEND_ALPHA\0" /* 58182 */
	"CB_DCC_CONTROL\0" /* 58197 */
	"DB_STENCIL_CONTROL\0" /* 58212 */
	"DB_STENCILREFMASK\0" /* 58231 */
	"DB_STENCILREFMASK_BF\0" /* 58249 */
	"PA_CL_VPORT_XSCALE\0" /* 58270 */
	"PA_CL_VPORT_XOFFSET\0" /* 58289 */
	"PA_CL_VPORT_YSCALE\0" /* 58309 */
	"PA_CL_VPORT_YOFFSET\0" /* 58328 */
	"PA_CL_VPORT_ZSCALE\0" /* 58348 */
	"PA_CL_VPORT_ZOFFSET\0" /* 58367 */
	"PA_CL_VPORT_XSCALE_1\0" /* 58387 */
	"PA_CL_VPORT_XOFFSET_1\0" /* 58408 */
	"PA_CL_VPORT_YSCALE_1\0" /* 58430 */
	"PA_CL_VPORT_YOFFSET_1\0" /* 58451 */
	"PA_CL_VPORT_ZSCALE_1\0" /* 58473 */
	"PA_CL_VPORT_ZOFFSET_1\0" /* 58494 */
	"PA_CL_VPORT_XSCALE_2\0" /* 58516 */
	"PA_CL_VPORT_XOFFSET_2\0" /* 58537 */
	"PA_CL_VPORT_YSCALE_2\0" /* 58559 */
	"PA_CL_VPORT_YOFFSET_2\0" /* 58580 */
	"PA_CL_VPORT_ZSCALE_2\0" /* 58602 */
	"PA_CL_VPORT_ZOFFSET_2\0" /* 58623 */
	"PA_CL_VPORT_XSCALE_3\0" /* 58645 */
	"PA_CL_VPORT_XOFFSET_3\0" /* 58666 */
	"PA_CL_VPORT_YSCALE_3\0" /* 58688 */
	"PA_CL_VPORT_YOFFSET_3\0" /* 58709 */
	"PA_CL_VPORT_ZSCALE_3\0" /* 58731 */
	"PA_CL_VPORT_ZOFFSET_3\0" /* 58752 */
	"PA_CL_VPORT_XSCALE_4\0" /* 58774 */
	"PA_CL_VPORT_XOFFSET_4\0" /* 58795 */
	"PA_CL_VPORT_YSCALE_4\0" /* 58817 */
	"PA_CL_VPORT_YOFFSET_4\0" /* 58838 */
	"PA_CL_VPORT_ZSCALE_4\0" /* 58860 */
	"PA_CL_VPORT_ZOFFSET_4\0" /* 58881 */
	"PA_CL_VPORT_XSCALE_5\0" /* 58903 */
	"PA_CL_VPORT_XOFFSET_5\0" /* 58924 */
	"PA_CL_VPORT_YSCALE_5\0" /* 58946 */
	"PA_CL_VPORT_YOFFSET_5\0" /* 58967 */
	"PA_CL_VPORT_ZSCALE_5\0" /* 58989 */
	"PA_CL_VPORT_ZOFFSET_5\0" /* 59010 */
	"PA_CL_VPORT_XSCALE_6\0" /* 59032 */
	"PA_CL_VPORT_XOFFSET_6\0" /* 59053 */
	"PA_CL_VPORT_YSCALE_6\0" /* 59075 */
	"PA_CL_VPORT_YOFFSET_6\0" /* 59096 */
	"PA_CL_VPORT_ZSCALE_6\0" /* 59118 */
	"PA_CL_VPORT_ZOFFSET_6\0" /* 59139 */
	"PA_CL_VPORT_XSCALE_7\0" /* 59161 */
	"PA_CL_VPORT_XOFFSET_7\0" /* 59182 */
	"PA_CL_VPORT_YSCALE_7\0" /* 59204 */
	"PA_CL_VPORT_YOFFSET_7\0" /* 59225 */
	"PA_CL_VPORT_ZSCALE_7\0" /* 59247 */
	"PA_CL_VPORT_ZOFFSET_7\0" /* 59268 */
	"PA_CL_VPORT_XSCALE_8\0" /* 59290 */
	"PA_CL_VPORT_XOFFSET_8\0" /* 59311 */
	"PA_CL_VPORT_YSCALE_8\0" /* 59333 */
	"PA_CL_VPORT_YOFFSET_8\0" /* 59354 */
	"PA_CL_VPORT_ZSCALE_8\0" /* 59376 */
	"PA_CL_VPORT_ZOFFSET_8\0" /* 59397 */
	"PA_CL_VPORT_XSCALE_9\0" /* 59419 */
	"PA_CL_VPORT_XOFFSET_9\0" /* 59440 */
	"PA_CL_VPORT_YSCALE_9\0" /* 59462 */
	"PA_CL_VPORT_YOFFSET_9\0" /* 59483 */
	"PA_CL_VPORT_ZSCALE_9\0" /* 59505 */
	"PA_CL_VPORT_ZOFFSET_9\0" /* 59526 */
	"PA_CL_VPORT_XSCALE_10\0" /* 59548 */
	"PA_CL_VPORT_XOFFSET_10\0" /* 59570 */
	"PA_CL_VPORT_YSCALE_10\0" /* 59593 */
	"PA_CL_VPORT_YOFFSET_10\0" /* 59615 */
	"PA_CL_VPORT_ZSCALE_10\0" /* 59638 */
	"PA_CL_VPORT_ZOFFSET_10\0" /* 59660 */
	"PA_CL_VPORT_XSCALE_11\0" /* 59683 */
	"PA_CL_VPORT_XOFFSET_11\0" /* 59705 */
	"PA_CL_VPORT_YSCALE_11\0" /* 59728 */
	"PA_CL_VPORT_YOFFSET_11\0" /* 59750 */
	"PA_CL_VPORT_ZSCALE_11\0" /* 59773 */
	"PA_CL_VPORT_ZOFFSET_11\0" /* 59795 */
	"PA_CL_VPORT_XSCALE_12\0" /* 59818 */
	"PA_CL_VPORT_XOFFSET_12\0" /* 59840 */
	"PA_CL_VPORT_YSCALE_12\0" /* 59863 */
	"PA_CL_VPORT_YOFFSET_12\0" /* 59885 */
	"PA_CL_VPORT_ZSCALE_12\0" /* 59908 */
	"PA_CL_VPORT_ZOFFSET_12\0" /* 59930 */
	"PA_CL_VPORT_XSCALE_13\0" /* 59953 */
	"PA_CL_VPORT_XOFFSET_13\0" /* 59975 */
	"PA_CL_VPORT_YSCALE_13\0" /* 59998 */
	"PA_CL_VPORT_YOFFSET_13\0" /* 60020 */
	"PA_CL_VPORT_ZSCALE_13\0" /* 60043 */
	"PA_CL_VPORT_ZOFFSET_13\0" /* 60065 */
	"PA_CL_VPORT_XSCALE_14\0" /* 60088 */
	"PA_CL_VPORT_XOFFSET_14\0" /* 60110 */
	"PA_CL_VPORT_YSCALE_14\0" /* 60133 */
	"PA_CL_VPORT_YOFFSET_14\0" /* 60155 */
	"PA_CL_VPORT_ZSCALE_14\0" /* 60178 */
	"PA_CL_VPORT_ZOFFSET_14\0" /* 60200 */
	"PA_CL_VPORT_XSCALE_15\0" /* 60223 */
	"PA_CL_VPORT_XOFFSET_15\0" /* 60245 */
	"PA_CL_VPORT_YSCALE_15\0" /* 60268 */
	"PA_CL_VPORT_YOFFSET_15\0" /* 60290 */
	"PA_CL_VPORT_ZSCALE_15\0" /* 60313 */
	"PA_CL_VPORT_ZOFFSET_15\0" /* 60335 */
	"PA_CL_UCP_0_X\0" /* 60358 */
	"PA_CL_UCP_0_Y\0" /* 60372 */
	"PA_CL_UCP_0_Z\0" /* 60386 */
	"PA_CL_UCP_0_W\0" /* 60400 */
	"PA_CL_UCP_1_X\0" /* 60414 */
	"PA_CL_UCP_1_Y\0" /* 60428 */
	"PA_CL_UCP_1_Z\0" /* 60442 */
	"PA_CL_UCP_1_W\0" /* 60456 */
	"PA_CL_UCP_2_X\0" /* 60470 */
	"PA_CL_UCP_2_Y\0" /* 60484 */
	"PA_CL_UCP_2_Z\0" /* 60498 */
	"PA_CL_UCP_2_W\0" /* 60512 */
	"PA_CL_UCP_3_X\0" /* 60526 */
	"PA_CL_UCP_3_Y\0" /* 60540 */
	"PA_CL_UCP_3_Z\0" /* 60554 */
	"PA_CL_UCP_3_W\0" /* 60568 */
	"PA_CL_UCP_4_X\0" /* 60582 */
	"PA_CL_UCP_4_Y\0" /* 60596 */
	"PA_CL_UCP_4_Z\0" /* 60610 */
	"PA_CL_UCP_4_W\0" /* 60624 */
	"PA_CL_UCP_5_X\0" /* 60638 */
	"PA_CL_UCP_5_Y\0" /* 60652 */
	"PA_CL_UCP_5_Z\0" /* 60666 */
	"PA_CL_UCP_5_W\0" /* 60680 */
	"SPI_PS_INPUT_CNTL_0\0" /* 60694 */
	"SPI_PS_INPUT_CNTL_1\0" /* 60714 */
	"SPI_PS_INPUT_CNTL_2\0" /* 60734 */
	"SPI_PS_INPUT_CNTL_3\0" /* 60754 */
	"SPI_PS_INPUT_CNTL_4\0" /* 60774 */
	"SPI_PS_INPUT_CNTL_5\0" /* 60794 */
	"SPI_PS_INPUT_CNTL_6\0" /* 60814 */
	"SPI_PS_INPUT_CNTL_7\0" /* 60834 */
	"SPI_PS_INPUT_CNTL_8\0" /* 60854 */
	"SPI_PS_INPUT_CNTL_9\0" /* 60874 */
	"SPI_PS_INPUT_CNTL_10\0" /* 60894 */
	"SPI_PS_INPUT_CNTL_11\0" /* 60915 */
	"SPI_PS_INPUT_CNTL_12\0" /* 60936 */
	"SPI_PS_INPUT_CNTL_13\0" /* 60957 */
	"SPI_PS_INPUT_CNTL_14\0" /* 60978 */
	"SPI_PS_INPUT_CNTL_15\0" /* 60999 */
	"SPI_PS_INPUT_CNTL_16\0" /* 61020 */
	"SPI_PS_INPUT_CNTL_17\0" /* 61041 */
	"SPI_PS_INPUT_CNTL_18\0" /* 61062 */
	"SPI_PS_INPUT_CNTL_19\0" /* 61083 */
	"SPI_PS_INPUT_CNTL_20\0" /* 61104 */
	"SPI_PS_INPUT_CNTL_21\0" /* 61125 */
	"SPI_PS_INPUT_CNTL_22\0" /* 61146 */
	"SPI_PS_INPUT_CNTL_23\0" /* 61167 */
	"SPI_PS_INPUT_CNTL_24\0" /* 61188 */
	"SPI_PS_INPUT_CNTL_25\0" /* 61209 */
	"SPI_PS_INPUT_CNTL_26\0" /* 61230 */
	"SPI_PS_INPUT_CNTL_27\0" /* 61251 */
	"SPI_PS_INPUT_CNTL_28\0" /* 61272 */
	"SPI_PS_INPUT_CNTL_29\0" /* 61293 */
	"SPI_PS_INPUT_CNTL_30\0" /* 61314 */
	"SPI_PS_INPUT_CNTL_31\0" /* 61335 */
	"SPI_VS_OUT_CONFIG\0" /* 61356 */
	"SPI_PS_INPUT_ENA\0" /* 61374 */
	"SPI_PS_INPUT_ADDR\0" /* 61391 */
	"SPI_INTERP_CONTROL_0\0" /* 61409 */
	"SPI_PS_IN_CONTROL\0" /* 61430 */
	"SPI_BARYC_CNTL\0" /* 61448 */
	"SPI_TMPRING_SIZE\0" /* 61463 */
	"SPI_WAVE_MGMT_1\0" /* 61480 */
	"SPI_WAVE_MGMT_2\0" /* 61496 */
	"SPI_SHADER_POS_FORMAT\0" /* 61512 */
	"SPI_SHADER_Z_FORMAT\0" /* 61534 */
	"SPI_SHADER_COL_FORMAT\0" /* 61554 */
	"SX_PS_DOWNCONVERT\0" /* 61576 */
	"SX_BLEND_OPT_EPSILON\0" /* 61594 */
	"SX_BLEND_OPT_CONTROL\0" /* 61615 */
	"SX_MRT0_BLEND_OPT\0" /* 61636 */
	"SX_MRT1_BLEND_OPT\0" /* 61654 */
	"SX_MRT2_BLEND_OPT\0" /* 61672 */
	"SX_MRT3_BLEND_OPT\0" /* 61690 */
	"SX_MRT4_BLEND_OPT\0" /* 61708 */
	"SX_MRT5_BLEND_OPT\0" /* 61726 */
	"SX_MRT6_BLEND_OPT\0" /* 61744 */
	"SX_MRT7_BLEND_OPT\0" /* 61762 */
	"CB_BLEND0_CONTROL\0" /* 61780 */
	"CB_BLEND1_CONTROL\0" /* 61798 */
	"CB_BLEND2_CONTROL\0" /* 61816 */
	"CB_BLEND3_CONTROL\0" /* 61834 */
	"CB_BLEND4_CONTROL\0" /* 61852 */
	"CB_BLEND5_CONTROL\0" /* 61870 */
	"CB_BLEND6_CONTROL\0" /* 61888 */
	"CB_BLEND7_CONTROL\0" /* 61906 */
	"CS_COPY_STATE\0" /* 61924 */
	"PA_CL_POINT_X_RAD\0" /* 61938 */
	"PA_CL_POINT_Y_RAD\0" /* 61956 */
	"PA_CL_POINT_SIZE\0" /* 61974 */
	"PA_CL_POINT_CULL_RAD\0" /* 61991 */
	"VGT_DMA_BASE_HI\0" /* 62012 */
	"VGT_DMA_BASE\0" /* 62028 */
	"VGT_DRAW_INITIATOR\0" /* 62041 */
	"VGT_IMMED_DATA\0" /* 62060 */
	"VGT_EVENT_ADDRESS_REG\0" /* 62075 */
	"DB_DEPTH_CONTROL\0" /* 62097 */
	"DB_EQAA\0" /* 62114 */
	"CB_COLOR_CONTROL\0" /* 62122 */
	"DB_SHADER_CONTROL\0" /* 62139 */
	"PA_CL_CLIP_CNTL\0" /* 62157 */
	"PA_SU_SC_MODE_CNTL\0" /* 62173 */
	"PA_CL_VTE_CNTL\0" /* 62192 */
	"PA_CL_VS_OUT_CNTL\0" /* 62207 */
	"PA_CL_NANINF_CNTL\0" /* 62225 */
	"PA_SU_LINE_STIPPLE_CNTL\0" /* 62243 */
	"PA_SU_LINE_STIPPLE_SCALE\0" /* 62267 */
	"PA_SU_PRIM_FILTER_CNTL\0" /* 62292 */
	"PA_SU_SMALL_PRIM_FILTER_CNTL\0" /* 62315 */
	"PA_SU_POINT_SIZE\0" /* 62344 */
	"PA_SU_POINT_MINMAX\0" /* 62361 */
	"PA_SU_LINE_CNTL\0" /* 62380 */
	"PA_SC_LINE_STIPPLE\0" /* 62396 */
	"VGT_OUTPUT_PATH_CNTL\0" /* 62415 */
	"VGT_HOS_CNTL\0" /* 62436 */
	"VGT_HOS_MAX_TESS_LEVEL\0" /* 62449 */
	"VGT_HOS_MIN_TESS_LEVEL\0" /* 62472 */
	"VGT_HOS_REUSE_DEPTH\0" /* 62495 */
	"VGT_GROUP_PRIM_TYPE\0" /* 62515 */
	"VGT_GROUP_FIRST_DECR\0" /* 62535 */
	"VGT_GROUP_DECR\0" /* 62556 */
	"VGT_GROUP_VECT_0_CNTL\0" /* 62571 */
	"VGT_GROUP_VECT_1_CNTL\0" /* 62593 */
	"VGT_GROUP_VECT_0_FMT_CNTL\0" /* 62615 */
	"VGT_GROUP_VECT_1_FMT_CNTL\0" /* 62641 */
	"VGT_GS_MODE\0" /* 62667 */
	"VGT_GS_ONCHIP_CNTL\0" /* 62679 */
	"PA_SC_MODE_CNTL_0\0" /* 62698 */
	"PA_SC_MODE_CNTL_1\0" /* 62716 */
	"VGT_ENHANCE\0" /* 62734 */
	"VGT_GS_PER_ES\0" /* 62746 */
	"VGT_ES_PER_GS\0" /* 62760 */
	"VGT_GS_PER_VS\0" /* 62774 */
	"VGT_GSVS_RING_OFFSET_1\0" /* 62788 */
	"VGT_GSVS_RING_OFFSET_2\0" /* 62811 */
	"VGT_GSVS_RING_OFFSET_3\0" /* 62834 */
	"VGT_GS_OUT_PRIM_TYPE\0" /* 62857 */
	"IA_ENHANCE\0" /* 62878 */
	"VGT_DMA_SIZE\0" /* 62889 */
	"VGT_DMA_MAX_SIZE\0" /* 62902 */
	"VGT_DMA_INDEX_TYPE\0" /* 62919 */
	"WD_ENHANCE\0" /* 62938 */
	"VGT_PRIMITIVEID_EN\0" /* 62949 */
	"VGT_DMA_NUM_INSTANCES\0" /* 62968 */
	"VGT_PRIMITIVEID_RESET\0" /* 62990 */
	"VGT_EVENT_INITIATOR\0" /* 63012 */
	"VGT_MULTI_PRIM_IB_RESET_EN\0" /* 63032 */
	"VGT_INSTANCE_STEP_RATE_0\0" /* 63059 */
	"VGT_INSTANCE_STEP_RATE_1\0" /* 63084 */
	"IA_MULTI_VGT_PARAM\0" /* 63109 */
	"VGT_ESGS_RING_ITEMSIZE\0" /* 63128 */
	"VGT_GSVS_RING_ITEMSIZE\0" /* 63151 */
	"VGT_REUSE_OFF\0" /* 63174 */
	"VGT_VTX_CNT_EN\0" /* 63188 */
	"DB_HTILE_SURFACE\0" /* 63203 */
	"DB_SRESULTS_COMPARE_STATE0\0" /* 63220 */
	"DB_SRESULTS_COMPARE_STATE1\0" /* 63247 */
	"DB_PRELOAD_CONTROL\0" /* 63274 */
	"VGT_STRMOUT_BUFFER_SIZE_0\0" /* 63293 */
	"VGT_STRMOUT_VTX_STRIDE_0\0" /* 63319 */
	"VGT_STRMOUT_BUFFER_OFFSET_0\0" /* 63344 */
	"VGT_STRMOUT_BUFFER_SIZE_1\0" /* 63372 */
	"VGT_STRMOUT_VTX_STRIDE_1\0" /* 63398 */
	"VGT_STRMOUT_BUFFER_OFFSET_1\0" /* 63423 */
	"VGT_STRMOUT_BUFFER_SIZE_2\0" /* 63451 */
	"VGT_STRMOUT_VTX_STRIDE_2\0" /* 63477 */
	"VGT_STRMOUT_BUFFER_OFFSET_2\0" /* 63502 */
	"VGT_STRMOUT_BUFFER_SIZE_3\0" /* 63530 */
	"VGT_STRMOUT_VTX_STRIDE_3\0" /* 63556 */
	"VGT_STRMOUT_BUFFER_OFFSET_3\0" /* 63581 */
	"VGT_STRMOUT_DRAW_OPAQUE_OFFSET\0" /* 63609 */
	"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE\0" /* 63640 */
	"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE\0" /* 63683 */
	"VGT_GS_MAX_VERT_OUT\0" /* 63721 */
	"VGT_TESS_DISTRIBUTION\0" /* 63741 */
	"VGT_SHADER_STAGES_EN\0" /* 63763 */
	"VGT_LS_HS_CONFIG\0" /* 63784 */
	"VGT_GS_VERT_ITEMSIZE\0" /* 63801 */
	"VGT_GS_VERT_ITEMSIZE_1\0" /* 63822 */
	"VGT_GS_VERT_ITEMSIZE_2\0" /* 63845 */
	"VGT_GS_VERT_ITEMSIZE_3\0" /* 63868 */
	"VGT_TF_PARAM\0" /* 63891 */
	"DB_ALPHA_TO_MASK\0" /* 63904 */
	"VGT_DISPATCH_DRAW_INDEX\0" /* 63921 */
	"PA_SU_POLY_OFFSET_DB_FMT_CNTL\0" /* 63945 */
	"PA_SU_POLY_OFFSET_CLAMP\0" /* 63975 */
	"PA_SU_POLY_OFFSET_FRONT_SCALE\0" /* 63999 */
	"PA_SU_POLY_OFFSET_FRONT_OFFSET\0" /* 64029 */
	"PA_SU_POLY_OFFSET_BACK_SCALE\0" /* 64060 */
	"PA_SU_POLY_OFFSET_BACK_OFFSET\0" /* 64089 */
	"VGT_GS_INSTANCE_CNT\0" /* 64119 */
	"VGT_STRMOUT_CONFIG\0" /* 64139 */
	"VGT_STRMOUT_BUFFER_CONFIG\0" /* 64158 */
	"PA_SC_CENTROID_PRIORITY_0\0" /* 64184 */
	"PA_SC_CENTROID_PRIORITY_1\0" /* 64210 */
	"PA_SC_LINE_CNTL\0" /* 64236 */
	"PA_SC_AA_CONFIG\0" /* 64252 */
	"PA_SU_VTX_CNTL\0" /* 64268 */
	"PA_CL_GB_VERT_CLIP_ADJ\0" /* 64283 */
	"PA_CL_GB_VERT_DISC_ADJ\0" /* 64306 */
	"PA_CL_GB_HORZ_CLIP_ADJ\0" /* 64329 */
	"PA_CL_GB_HORZ_DISC_ADJ\0" /* 64352 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0\0" /* 64375 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1\0" /* 64409 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2\0" /* 64443 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3\0" /* 64477 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0\0" /* 64511 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1\0" /* 64545 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2\0" /* 64579 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3\0" /* 64613 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0\0" /* 64647 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1\0" /* 64681 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2\0" /* 64715 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3\0" /* 64749 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0\0" /* 64783 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1\0" /* 64817 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2\0" /* 64851 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3\0" /* 64885 */
	"PA_SC_AA_MASK_X0Y0_X1Y0\0" /* 64919 */
	"PA_SC_AA_MASK_X0Y1_X1Y1\0" /* 64943 */
	"PA_SC_SHADER_CONTROL\0" /* 64967 */
	"VGT_VERTEX_REUSE_BLOCK_CNTL\0" /* 64988 */
	"VGT_OUT_DEALLOC_CNTL\0" /* 65016 */
	"CB_COLOR0_BASE\0" /* 65037 */
	"CB_COLOR0_PITCH\0" /* 65052 */
	"CB_COLOR0_SLICE\0" /* 65068 */
	"CB_COLOR0_VIEW\0" /* 65084 */
	"CB_COLOR0_INFO\0" /* 65099 */
	"CB_COLOR0_ATTRIB\0" /* 65114 */
	"CB_COLOR0_DCC_CONTROL\0" /* 65131 */
	"CB_COLOR0_CMASK\0" /* 65153 */
	"CB_COLOR0_CMASK_SLICE\0" /* 65169 */
	"CB_COLOR0_FMASK\0" /* 65191 */
	"CB_COLOR0_FMASK_SLICE\0" /* 65207 */
	"CB_COLOR0_CLEAR_WORD0\0" /* 65229 */
	"CB_COLOR0_CLEAR_WORD1\0" /* 65251 */
	"CB_COLOR0_DCC_BASE\0" /* 65273 */
	"CB_COLOR1_BASE\0" /* 65292 */
	"CB_COLOR1_PITCH\0" /* 65307 */
	"CB_COLOR1_SLICE\0" /* 65323 */
	"CB_COLOR1_VIEW\0" /* 65339 */
	"CB_COLOR1_INFO\0" /* 65354 */
	"CB_COLOR1_ATTRIB\0" /* 65369 */
	"CB_COLOR1_DCC_CONTROL\0" /* 65386 */
	"CB_COLOR1_CMASK\0" /* 65408 */
	"CB_COLOR1_CMASK_SLICE\0" /* 65424 */
	"CB_COLOR1_FMASK\0" /* 65446 */
	"CB_COLOR1_FMASK_SLICE\0" /* 65462 */
	"CB_COLOR1_CLEAR_WORD0\0" /* 65484 */
	"CB_COLOR1_CLEAR_WORD1\0" /* 65506 */
	"CB_COLOR1_DCC_BASE\0" /* 65528 */
	"CB_COLOR2_BASE\0" /* 65547 */
	"CB_COLOR2_PITCH\0" /* 65562 */
	"CB_COLOR2_SLICE\0" /* 65578 */
	"CB_COLOR2_VIEW\0" /* 65594 */
	"CB_COLOR2_INFO\0" /* 65609 */
	"CB_COLOR2_ATTRIB\0" /* 65624 */
	"CB_COLOR2_DCC_CONTROL\0" /* 65641 */
	"CB_COLOR2_CMASK\0" /* 65663 */
	"CB_COLOR2_CMASK_SLICE\0" /* 65679 */
	"CB_COLOR2_FMASK\0" /* 65701 */
	"CB_COLOR2_FMASK_SLICE\0" /* 65717 */
	"CB_COLOR2_CLEAR_WORD0\0" /* 65739 */
	"CB_COLOR2_CLEAR_WORD1\0" /* 65761 */
	"CB_COLOR2_DCC_BASE\0" /* 65783 */
	"CB_COLOR3_BASE\0" /* 65802 */
	"CB_COLOR3_PITCH\0" /* 65817 */
	"CB_COLOR3_SLICE\0" /* 65833 */
	"CB_COLOR3_VIEW\0" /* 65849 */
	"CB_COLOR3_INFO\0" /* 65864 */
	"CB_COLOR3_ATTRIB\0" /* 65879 */
	"CB_COLOR3_DCC_CONTROL\0" /* 65896 */
	"CB_COLOR3_CMASK\0" /* 65918 */
	"CB_COLOR3_CMASK_SLICE\0" /* 65934 */
	"CB_COLOR3_FMASK\0" /* 65956 */
	"CB_COLOR3_FMASK_SLICE\0" /* 65972 */
	"CB_COLOR3_CLEAR_WORD0\0" /* 65994 */
	"CB_COLOR3_CLEAR_WORD1\0" /* 66016 */
	"CB_COLOR3_DCC_BASE\0" /* 66038 */
	"CB_COLOR4_BASE\0" /* 66057 */
	"CB_COLOR4_PITCH\0" /* 66072 */
	"CB_COLOR4_SLICE\0" /* 66088 */
	"CB_COLOR4_VIEW\0" /* 66104 */
	"CB_COLOR4_INFO\0" /* 66119 */
	"CB_COLOR4_ATTRIB\0" /* 66134 */
	"CB_COLOR4_DCC_CONTROL\0" /* 66151 */
	"CB_COLOR4_CMASK\0" /* 66173 */
	"CB_COLOR4_CMASK_SLICE\0" /* 66189 */
	"CB_COLOR4_FMASK\0" /* 66211 */
	"CB_COLOR4_FMASK_SLICE\0" /* 66227 */
	"CB_COLOR4_CLEAR_WORD0\0" /* 66249 */
	"CB_COLOR4_CLEAR_WORD1\0" /* 66271 */
	"CB_COLOR4_DCC_BASE\0" /* 66293 */
	"CB_COLOR5_BASE\0" /* 66312 */
	"CB_COLOR5_PITCH\0" /* 66327 */
	"CB_COLOR5_SLICE\0" /* 66343 */
	"CB_COLOR5_VIEW\0" /* 66359 */
	"CB_COLOR5_INFO\0" /* 66374 */
	"CB_COLOR5_ATTRIB\0" /* 66389 */
	"CB_COLOR5_DCC_CONTROL\0" /* 66406 */
	"CB_COLOR5_CMASK\0" /* 66428 */
	"CB_COLOR5_CMASK_SLICE\0" /* 66444 */
	"CB_COLOR5_FMASK\0" /* 66466 */
	"CB_COLOR5_FMASK_SLICE\0" /* 66482 */
	"CB_COLOR5_CLEAR_WORD0\0" /* 66504 */
	"CB_COLOR5_CLEAR_WORD1\0" /* 66526 */
	"CB_COLOR5_DCC_BASE\0" /* 66548 */
	"CB_COLOR6_BASE\0" /* 66567 */
	"CB_COLOR6_PITCH\0" /* 66582 */
	"CB_COLOR6_SLICE\0" /* 66598 */
	"CB_COLOR6_VIEW\0" /* 66614 */
	"CB_COLOR6_INFO\0" /* 66629 */
	"CB_COLOR6_ATTRIB\0" /* 66644 */
	"CB_COLOR6_DCC_CONTROL\0" /* 66661 */
	"CB_COLOR6_CMASK\0" /* 66683 */
	"CB_COLOR6_CMASK_SLICE\0" /* 66699 */
	"CB_COLOR6_FMASK\0" /* 66721 */
	"CB_COLOR6_FMASK_SLICE\0" /* 66737 */
	"CB_COLOR6_CLEAR_WORD0\0" /* 66759 */
	"CB_COLOR6_CLEAR_WORD1\0" /* 66781 */
	"CB_COLOR6_DCC_BASE\0" /* 66803 */
	"CB_COLOR7_BASE\0" /* 66822 */
	"CB_COLOR7_PITCH\0" /* 66837 */
	"CB_COLOR7_SLICE\0" /* 66853 */
	"CB_COLOR7_VIEW\0" /* 66869 */
	"CB_COLOR7_INFO\0" /* 66884 */
	"CB_COLOR7_ATTRIB\0" /* 66899 */
	"CB_COLOR7_DCC_CONTROL\0" /* 66916 */
	"CB_COLOR7_CMASK\0" /* 66938 */
	"CB_COLOR7_CMASK_SLICE\0" /* 66954 */
	"CB_COLOR7_FMASK\0" /* 66976 */
	"CB_COLOR7_FMASK_SLICE\0" /* 66992 */
	"CB_COLOR7_CLEAR_WORD0\0" /* 67014 */
	"CB_COLOR7_CLEAR_WORD1\0" /* 67036 */
	"CB_COLOR7_DCC_BASE\0" /* 67058 */
	"VGT_TF_MEMORY_BASE_HI\0" /* 67077 */
	"WD_POS_BUF_BASE\0" /* 67099 */
	"WD_POS_BUF_BASE_HI\0" /* 67115 */
	"WD_CNTL_SB_BUF_BASE\0" /* 67134 */
	"WD_CNTL_SB_BUF_BASE_HI\0" /* 67154 */
	"WD_INDEX_BUF_BASE\0" /* 67177 */
	"WD_INDEX_BUF_BASE_HI\0" /* 67195 */
	"VGT_OBJECT_ID\0" /* 67216 */
	"VGT_INSTANCE_BASE_ID\0" /* 67230 */
	"SQC_WRITEBACK\0" /* 67251 */
	"TA_GRAD_ADJ_UCONFIG\0" /* 67265 */
	"SPI_CONFIG_CNTL_2\0" /* 67285 */
	"SPI_SHADER_USER_DATA_PS_16\0" /* 67303 */
	"SPI_SHADER_USER_DATA_PS_17\0" /* 67330 */
	"SPI_SHADER_USER_DATA_PS_18\0" /* 67357 */
	"SPI_SHADER_USER_DATA_PS_19\0" /* 67384 */
	"SPI_SHADER_USER_DATA_PS_20\0" /* 67411 */
	"SPI_SHADER_USER_DATA_PS_21\0" /* 67438 */
	"SPI_SHADER_USER_DATA_PS_22\0" /* 67465 */
	"SPI_SHADER_USER_DATA_PS_23\0" /* 67492 */
	"SPI_SHADER_USER_DATA_PS_24\0" /* 67519 */
	"SPI_SHADER_USER_DATA_PS_25\0" /* 67546 */
	"SPI_SHADER_USER_DATA_PS_26\0" /* 67573 */
	"SPI_SHADER_USER_DATA_PS_27\0" /* 67600 */
	"SPI_SHADER_USER_DATA_PS_28\0" /* 67627 */
	"SPI_SHADER_USER_DATA_PS_29\0" /* 67654 */
	"SPI_SHADER_USER_DATA_PS_30\0" /* 67681 */
	"SPI_SHADER_USER_DATA_PS_31\0" /* 67708 */
	"SPI_SHADER_USER_DATA_VS_16\0" /* 67735 */
	"SPI_SHADER_USER_DATA_VS_17\0" /* 67762 */
	"SPI_SHADER_USER_DATA_VS_18\0" /* 67789 */
	"SPI_SHADER_USER_DATA_VS_19\0" /* 67816 */
	"SPI_SHADER_USER_DATA_VS_20\0" /* 67843 */
	"SPI_SHADER_USER_DATA_VS_21\0" /* 67870 */
	"SPI_SHADER_USER_DATA_VS_22\0" /* 67897 */
	"SPI_SHADER_USER_DATA_VS_23\0" /* 67924 */
	"SPI_SHADER_USER_DATA_VS_24\0" /* 67951 */
	"SPI_SHADER_USER_DATA_VS_25\0" /* 67978 */
	"SPI_SHADER_USER_DATA_VS_26\0" /* 68005 */
	"SPI_SHADER_USER_DATA_VS_27\0" /* 68032 */
	"SPI_SHADER_USER_DATA_VS_28\0" /* 68059 */
	"SPI_SHADER_USER_DATA_VS_29\0" /* 68086 */
	"SPI_SHADER_USER_DATA_VS_30\0" /* 68113 */
	"SPI_SHADER_USER_DATA_VS_31\0" /* 68140 */
	"SPI_SHADER_PGM_RSRC2_GS_VS\0" /* 68167 */
	"SPI_SHADER_PGM_RSRC4_GS\0" /* 68194 */
	"SPI_SHADER_USER_DATA_ADDR_LO_GS\0" /* 68218 */
	"SPI_SHADER_USER_DATA_ADDR_HI_GS\0" /* 68250 */
	"SPI_SHADER_USER_DATA_ES_16\0" /* 68282 */
	"SPI_SHADER_USER_DATA_ES_17\0" /* 68309 */
	"SPI_SHADER_USER_DATA_ES_18\0" /* 68336 */
	"SPI_SHADER_USER_DATA_ES_19\0" /* 68363 */
	"SPI_SHADER_USER_DATA_ES_20\0" /* 68390 */
	"SPI_SHADER_USER_DATA_ES_21\0" /* 68417 */
	"SPI_SHADER_USER_DATA_ES_22\0" /* 68444 */
	"SPI_SHADER_USER_DATA_ES_23\0" /* 68471 */
	"SPI_SHADER_USER_DATA_ES_24\0" /* 68498 */
	"SPI_SHADER_USER_DATA_ES_25\0" /* 68525 */
	"SPI_SHADER_USER_DATA_ES_26\0" /* 68552 */
	"SPI_SHADER_USER_DATA_ES_27\0" /* 68579 */
	"SPI_SHADER_USER_DATA_ES_28\0" /* 68606 */
	"SPI_SHADER_USER_DATA_ES_29\0" /* 68633 */
	"SPI_SHADER_USER_DATA_ES_30\0" /* 68660 */
	"SPI_SHADER_USER_DATA_ES_31\0" /* 68687 */
	"SPI_SHADER_PGM_RSRC4_HS\0" /* 68714 */
	"SPI_SHADER_USER_DATA_ADDR_LO_HS\0" /* 68738 */
	"SPI_SHADER_USER_DATA_ADDR_HI_HS\0" /* 68770 */
	"SPI_SHADER_USER_DATA_LS_16\0" /* 68802 */
	"SPI_SHADER_USER_DATA_LS_17\0" /* 68829 */
	"SPI_SHADER_USER_DATA_LS_18\0" /* 68856 */
	"SPI_SHADER_USER_DATA_LS_19\0" /* 68883 */
	"SPI_SHADER_USER_DATA_LS_20\0" /* 68910 */
	"SPI_SHADER_USER_DATA_LS_21\0" /* 68937 */
	"SPI_SHADER_USER_DATA_LS_22\0" /* 68964 */
	"SPI_SHADER_USER_DATA_LS_23\0" /* 68991 */
	"SPI_SHADER_USER_DATA_LS_24\0" /* 69018 */
	"SPI_SHADER_USER_DATA_LS_25\0" /* 69045 */
	"SPI_SHADER_USER_DATA_LS_26\0" /* 69072 */
	"SPI_SHADER_USER_DATA_LS_27\0" /* 69099 */
	"SPI_SHADER_USER_DATA_LS_28\0" /* 69126 */
	"SPI_SHADER_USER_DATA_LS_29\0" /* 69153 */
	"SPI_SHADER_USER_DATA_LS_30\0" /* 69180 */
	"SPI_SHADER_USER_DATA_LS_31\0" /* 69207 */
	"SPI_SHADER_USER_DATA_COMMON_0\0" /* 69234 */
	"SPI_SHADER_USER_DATA_COMMON_1\0" /* 69264 */
	"SPI_SHADER_USER_DATA_COMMON_2\0" /* 69294 */
	"SPI_SHADER_USER_DATA_COMMON_3\0" /* 69324 */
	"SPI_SHADER_USER_DATA_COMMON_4\0" /* 69354 */
	"SPI_SHADER_USER_DATA_COMMON_5\0" /* 69384 */
	"SPI_SHADER_USER_DATA_COMMON_6\0" /* 69414 */
	"SPI_SHADER_USER_DATA_COMMON_7\0" /* 69444 */
	"SPI_SHADER_USER_DATA_COMMON_8\0" /* 69474 */
	"SPI_SHADER_USER_DATA_COMMON_9\0" /* 69504 */
	"SPI_SHADER_USER_DATA_COMMON_10\0" /* 69534 */
	"SPI_SHADER_USER_DATA_COMMON_11\0" /* 69565 */
	"SPI_SHADER_USER_DATA_COMMON_12\0" /* 69596 */
	"SPI_SHADER_USER_DATA_COMMON_13\0" /* 69627 */
	"SPI_SHADER_USER_DATA_COMMON_14\0" /* 69658 */
	"SPI_SHADER_USER_DATA_COMMON_15\0" /* 69689 */
	"SPI_SHADER_USER_DATA_COMMON_16\0" /* 69720 */
	"SPI_SHADER_USER_DATA_COMMON_17\0" /* 69751 */
	"SPI_SHADER_USER_DATA_COMMON_18\0" /* 69782 */
	"SPI_SHADER_USER_DATA_COMMON_19\0" /* 69813 */
	"SPI_SHADER_USER_DATA_COMMON_20\0" /* 69844 */
	"SPI_SHADER_USER_DATA_COMMON_21\0" /* 69875 */
	"SPI_SHADER_USER_DATA_COMMON_22\0" /* 69906 */
	"SPI_SHADER_USER_DATA_COMMON_23\0" /* 69937 */
	"SPI_SHADER_USER_DATA_COMMON_24\0" /* 69968 */
	"SPI_SHADER_USER_DATA_COMMON_25\0" /* 69999 */
	"SPI_SHADER_USER_DATA_COMMON_26\0" /* 70030 */
	"SPI_SHADER_USER_DATA_COMMON_27\0" /* 70061 */
	"SPI_SHADER_USER_DATA_COMMON_28\0" /* 70092 */
	"SPI_SHADER_USER_DATA_COMMON_29\0" /* 70123 */
	"SPI_SHADER_USER_DATA_COMMON_30\0" /* 70154 */
	"SPI_SHADER_USER_DATA_COMMON_31\0" /* 70185 */
	"COMPUTE_DISPATCH_PKT_ADDR_LO\0" /* 70216 */
	"COMPUTE_DISPATCH_PKT_ADDR_HI\0" /* 70245 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_LO\0" /* 70274 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_HI\0" /* 70307 */
	"CPF_LATENCY_STATS_DATA\0" /* 70340 */
	"CPG_LATENCY_STATS_DATA\0" /* 70363 */
	"CPC_LATENCY_STATS_DATA\0" /* 70386 */
	"CPF_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 70409 */
	"CPG_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 70443 */
	"CPF_LATENCY_STATS_SELECT\0" /* 70477 */
	"CPG_LATENCY_STATS_SELECT\0" /* 70502 */
	"CPC_LATENCY_STATS_SELECT\0" /* 70527 */
	"DB_HTILE_DATA_BASE_HI\0" /* 70552 */
	"DB_Z_READ_BASE_HI\0" /* 70574 */
	"DB_STENCIL_READ_BASE_HI\0" /* 70592 */
	"DB_Z_WRITE_BASE_HI\0" /* 70616 */
	"DB_STENCIL_WRITE_BASE_HI\0" /* 70635 */
	"DB_DFSM_CONTROL\0" /* 70660 */
	"DB_RENDER_FILTER\0" /* 70676 */
	"DB_Z_INFO2\0" /* 70693 */
	"DB_STENCIL_INFO2\0" /* 70704 */
	"PA_SC_TILE_STEERING_OVERRIDE\0" /* 70721 */
	"CP_PERFMON_CNTX_CNTL\0" /* 70750 */
	"PA_SC_RIGHT_VERT_GRID\0" /* 70771 */
	"PA_SC_LEFT_VERT_GRID\0" /* 70793 */
	"PA_SC_HORIZ_GRID\0" /* 70814 */
	"PA_SC_FOV_WINDOW_LR\0" /* 70831 */
	"PA_SC_FOV_WINDOW_TB\0" /* 70851 */
	"CB_MRT0_EPITCH\0" /* 70871 */
	"CB_MRT1_EPITCH\0" /* 70886 */
	"CB_MRT2_EPITCH\0" /* 70901 */
	"CB_MRT3_EPITCH\0" /* 70916 */
	"CB_MRT4_EPITCH\0" /* 70931 */
	"CB_MRT5_EPITCH\0" /* 70946 */
	"CB_MRT6_EPITCH\0" /* 70961 */
	"CB_MRT7_EPITCH\0" /* 70976 */
	"PA_CL_OBJPRIM_ID_CNTL\0" /* 70991 */
	"PA_CL_NGG_CNTL\0" /* 71013 */
	"PA_SU_OVER_RASTERIZATION_CNTL\0" /* 71028 */
	"VGT_GS_MAX_PRIMS_PER_SUBGROUP\0" /* 71058 */
	"VGT_DRAW_PAYLOAD_CNTL\0" /* 71088 */
	"VGT_INDEX_PAYLOAD_CNTL\0" /* 71110 */
	"VGT_DMA_EVENT_INITIATOR\0" /* 71133 */
	"PA_SC_BINNER_CNTL_0\0" /* 71157 */
	"PA_SC_BINNER_CNTL_1\0" /* 71177 */
	"PA_SC_CONSERVATIVE_RASTERIZATION_CNTL\0" /* 71197 */
	"PA_SC_NGG_MODE_CNTL\0" /* 71235 */
	"CB_COLOR0_BASE_EXT\0" /* 71255 */
	"CB_COLOR0_ATTRIB2\0" /* 71274 */
	"CB_COLOR0_CMASK_BASE_EXT\0" /* 71292 */
	"CB_COLOR0_FMASK_BASE_EXT\0" /* 71317 */
	"CB_COLOR0_DCC_BASE_EXT\0" /* 71342 */
	"CB_COLOR1_BASE_EXT\0" /* 71365 */
	"CB_COLOR1_ATTRIB2\0" /* 71384 */
	"CB_COLOR1_CMASK_BASE_EXT\0" /* 71402 */
	"CB_COLOR1_FMASK_BASE_EXT\0" /* 71427 */
	"CB_COLOR1_DCC_BASE_EXT\0" /* 71452 */
	"CB_COLOR2_BASE_EXT\0" /* 71475 */
	"CB_COLOR2_ATTRIB2\0" /* 71494 */
	"CB_COLOR2_CMASK_BASE_EXT\0" /* 71512 */
	"CB_COLOR2_FMASK_BASE_EXT\0" /* 71537 */
	"CB_COLOR2_DCC_BASE_EXT\0" /* 71562 */
	"CB_COLOR3_BASE_EXT\0" /* 71585 */
	"CB_COLOR3_ATTRIB2\0" /* 71604 */
	"CB_COLOR3_CMASK_BASE_EXT\0" /* 71622 */
	"CB_COLOR3_FMASK_BASE_EXT\0" /* 71647 */
	"CB_COLOR3_DCC_BASE_EXT\0" /* 71672 */
	"CB_COLOR4_BASE_EXT\0" /* 71695 */
	"CB_COLOR4_ATTRIB2\0" /* 71714 */
	"CB_COLOR4_CMASK_BASE_EXT\0" /* 71732 */
	"CB_COLOR4_FMASK_BASE_EXT\0" /* 71757 */
	"CB_COLOR4_DCC_BASE_EXT\0" /* 71782 */
	"CB_COLOR5_BASE_EXT\0" /* 71805 */
	"CB_COLOR5_ATTRIB2\0" /* 71824 */
	"CB_COLOR5_CMASK_BASE_EXT\0" /* 71842 */
	"CB_COLOR5_FMASK_BASE_EXT\0" /* 71867 */
	"CB_COLOR5_DCC_BASE_EXT\0" /* 71892 */
	"CB_COLOR6_BASE_EXT\0" /* 71915 */
	"CB_COLOR6_ATTRIB2\0" /* 71934 */
	"CB_COLOR6_CMASK_BASE_EXT\0" /* 71952 */
	"CB_COLOR6_FMASK_BASE_EXT\0" /* 71977 */
	"CB_COLOR6_DCC_BASE_EXT\0" /* 72002 */
	"CB_COLOR7_BASE_EXT\0" /* 72025 */
	"CB_COLOR7_ATTRIB2\0" /* 72044 */
	"CB_COLOR7_CMASK_BASE_EXT\0" /* 72062 */
	"CB_COLOR7_FMASK_BASE_EXT\0" /* 72087 */
	"CB_COLOR7_DCC_BASE_EXT\0" /* 72112 */;

static const int sid_strings_offsets[] = {
	/* 0 */ 509, 855, 859, 862,
	/* 4 */ 899, 919, 931, 937, 941, 950,
	/* 10 */ 1008, 937, 391, 1017,
	/* 14 */ 1047, 937, 1056, 1064,
	/* 18 */ 1179, 1184, 1192, 1200,
	/* 22 */ 1226, 910,
	/* 24 */ 1241, 1251,
	/* 26 */ 1047, 937, -1, 1064,
	/* 30 */ 5815, 5826, 5842, 5857, 5873, 5887, 5900, 5915, 5930, 5945, 5957, 5976, 5996, 6014, 6033, 6048, 6063, 6085, 6100, 6115, 6130, 6146, 6160, 6187, 6214, 6241, 6268, 6292, 6312,
	/* 59 */ 6341, 6362,
	/* 61 */ 5815, 5826, 5842, 5857, 5873, 5887, 5900, -1, -1, 5945, 5957, 5976, 5996, 6014, -1, -1, 6063, 6085, 6100, 6115, 6130, 6146, 6160, 6187, 6214, 6241, 6268, 6292, 6312,
	/* 90 */ 8333, 8345, 8357, 8369,
	/* 94 */ 8761, -1, -1, -1, -1, -1, -1, -1, 8772, 8784, -1, -1, 8796, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8807,
	/* 127 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8833,
	/* 190 */ 8928, 8937, 8946, 8964, 8982, 8991, 9000, 9009,
	/* 198 */ 9058, 9079, 9100, 9123, 9146, 9166, 9186, 9211,
	/* 206 */ 9243, 9267, 9285, 9304, 9324, 9343, 9365, 9390, 9415, 9442, 9469, 9493, 9515, 9543, 9568, 9596,
	/* 222 */ 9704, 9716, 9735, 9754,
	/* 226 */ 9812, 9836, 9854, 9873, 9893, 9912, 9934, 9959, 9984, 10011, 10038, 10062, 10084, 10112, 10137, 10165, 10193, 10215, 10239, 10263, 10287, 10308, 10329, 10354, 10383, 10408, 10434, 10457, 10481, 10508, 10536, 10564, 10592, 10614, 10636, 10660, 10680, 10700, 10720, 10740, 10760, 10780, 10800, 10839, 10878, 10907, 10936, 10965, 10994, 11023, 11052, 11083, 11113, 11144, 11174, 11204, 11235, 11266, 11286, 11308, 11326, 11353, 11377, 11403,
	/* 290 */ 11454, 11475, 11496, 11519, 11542, 11562, 11582, 11607, 11628, 11654, 11674, 11696, 11722, 11743, 11767, 11794,
	/* 306 */ 9812, 9836, 9854, 9873, 9893, 9912, 9934, 9959, 9984, 10011, 10038, 10062, 10084, 10112, 10137, 10165, 10193, 10215, 10239, 10263, 10287, 10308, 10329, 10354, 10383, 10408, 10434, 10457, 10481, 10508, 10536, 11837, 10592, 10614, 10636, 10660, 10680, 10700, 10720, 10740, 10760, 10780, 11857, 11885, 11924, 11963, 11985, 12013, 12041, 12074, 12102, 12130, 12163, 12187, 12214, 12247, 12286, 11266, 11286, 12314, 12329, 12344, 12368, 11403,
	/* 370 */ 11454, 11475, 11496, 11519, 11542, 11562, 12412, 11607, 12438, 11654, 12462,
	/* 381 */ 12504, 12520, 12536, 12552, 12568, 12584, 12600, 12618, 12635, 12653, 12670, 12687, 12705,
	/* 394 */ 12740, 12756, 12772, 12788, 12804, 12820, 12836, 12852, 12868, 12885, 12902, 12919, 12937, 12955,
	/* 408 */ 12992, 13010, 13028, 13046, 13064, 13082, 13100, 13118, 13136, 13154,
	/* 418 */ 13280, 13299, 13318, 13337, 13356, 13375, 13394, 13413, 13432, 13447, 13462, 13477, 13494, 13515, 13536, 13556,
	/* 434 */ 13618, 13634, 13650, 13666, 13682, 13698,
	/* 440 */ 13954, 13966, 13980, 14004, 14034, 14059, 14090, 14110,
	/* 448 */ 14176, 14203, 14229, 14256, 14287, 14316, 14346, 14380,
	/* 456 */ 14602, 14625,
	/* 458 */ 14602, 14625, 14665, 14694,
	/* 462 */ 14740, 14761, 14783,
	/* 465 */ 14925, 14957, 14990, 15023,
	/* 469 */ 15227,
	/* 470 */ 15526, 15542, 15558, 15574, 15590, 15606, 15622, 15638, 15654, 15670, 15686, 15702, 15717, 15732, 15747, 15763,
	/* 486 */ 16309, 16340, 16368, 16397,
	/* 490 */ 16442, 16463, 16484, 16505, 16526, -1, -1, 16547, 16568, -1, -1, -1, 16590, 16611, 16632, 16654,
	/* 506 */ 16682, 16695, 16718, 16741, 16764, 16784, 16805, 16826, 16847, 16873, 16899, 16925, 16952, 16979, 17006,
	/* 521 */ 17045, 17070, 17096, 17122, 17148, 17173, 17198,
	/* 528 */ 17234, 17257, 17280, 17303,
	/* 532 */ 17337, 17361, 17385, 17409,
	/* 536 */ 17445, 17470, 17495, 17520,
	/* 540 */ 17563, 17580, 17597, 17614,
	/* 544 */ 16309, 16340, 16368, 17632,
	/* 548 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17760, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17774, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17788,
	/* 789 */ 18969, 18987, 19002,
	/* 792 */ 20618, 20628, 20641, 20655,
	/* 796 */ 20952, 20967, 20983, 20999,
	/* 800 */ 21164, 21174, 21192, 21202,
	/* 804 */ 16442, 16463, 16484, -1, 16526, 21635, 21657,
	/* 811 */ 16682, -1, -1, -1, 16764, 16784, 16805, 16826, 16847, 16873, 16899, 16925, 16952, 16979, 17006, -1, 21682, 21709,
	/* 829 */ 21737, 21747, 21752, 21757,
	/* 833 */ 21899, 21915,
	/* 835 */ 22411, 22434, 22457, 22480,
	/* 839 */ 22527, 22552, 22577, 22602,
	/* 843 */ 22652, 22676, 22700, 22724,
	/* 847 */ 22756, 22781, 22806, 22831,
	/* 851 */ 22865, 22890, 22915, 22940,
	/* 855 */ 22974, 23000, 23026, 23052,
	/* 859 */ 23088, 23111, 23134, 23157,
	/* 863 */ 23187, 23221, 23256, 23291,
	/* 867 */ 23334, 23368, 23403, 23438,
	/* 871 */ 23481, 23504, 23527, 23550,
	/* 875 */ 23580, 23614, 23649, 23684,
	/* 879 */ 23732, 23766, 23801, 23836,
	/* 883 */ 23910, 23938, 23966, 23994,
	/* 887 */ 24034, 24073, 24113, 24153,
	/* 891 */ 24211, 24250, 24290, 24330,
	/* 895 */ 24519, 24532, 24545, 24558, 24579, 24598, 24616, 24634, 24649, 24666, 24683, 24695, 24706, 24718, 24731, 24743,
	/* 911 */ 24967,
	/* 912 */ 25496, 25517, 25538, 25559, 25580,
	/* 917 */ 25874,
	/* 918 */ 26054, 26070, 26087, 26104, 26125,
	/* 923 */ 26218, 26234, 26250, 26267, 26284, 26305, 26329, 26353, 26376, 26399,
	/* 933 */ 26586, 26613, 26631, 26649, 26671, 26695, 26716, 26735, 26756, 26777, 26799,
	/* 944 */ 26861, 26867, -1, 26880, -1, -1, -1, 26893, -1, -1, -1, 26905, -1, 26917, -1, 26929,
	/* 960 */ 27436, 27471, 27506, 27538, 27570, 27602, 27634, 27668,
	/* 968 */ 27732, 27746, 27759, 27777, 27790, 27803, 27824, 27848,
	/* 976 */ 27924, 27935, 27945, 27961, 27987, 28003, 28029, 28045, 28071, 28087, 28113, -1, -1, 28138, 28159, 28190, 28207, 28228, 28245, 28266, 28287,
	/* 997 */ 28333, 28351, 28370, 28387, 28404,
	/* 1002 */ 28547, 28562, 28583, 28605,
	/* 1006 */ 28639, 28655,
	/* 1008 */ 28822, 28833, 28843, 28854, 28866, 28879, 28893, 28905,
	/* 1016 */ 28933, 28943, 28952, 28962, 28973, 28985, 28998, 29009,
	/* 1024 */ 29430, 29441, 29451, 29475, -1, 29486, 29506,
	/* 1031 */ 29524, -1, -1, -1, -1, 29531, -1, -1, -1, -1, 29538, -1, -1, -1, -1, 29545, -1, 29552, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29559, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29566, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29573, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29580, -1, -1, -1, -1, 29587, -1, -1, -1, -1, 29594, -1, -1, -1, -1, 29601, -1, -1, -1, -1, -1, -1, 29608, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29615, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29622, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29629, -1, -1, -1, -1, -1, -1, 29636, -1, -1, -1, -1, 29643, -1, -1, -1, -1, 29650, -1, -1, -1, -1, 29657, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29664, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29671, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29678, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 29685, -1, 29692, -1, -1, -1, -1, 29699, -1, -1, -1, -1, 29706, -1, -1, -1, -1, 29713,
	/* 1287 */ 29796, 29803, 29823, 29828,
	/* 1291 */ 29974, 29987, 30006, 30028,
	/* 1295 */ 30489, 30509,
	/* 1297 */ 30521, 30535, 30548,
	/* 1300 */ 32192, 32214, 32234, 32255, 32276,
	/* 1305 */ 32331, 32348, 32364, 32379, 32395, 32411, 32435, 32459, 32483, 32507, 32528, 32544, 32559, 32583, 32606, 32630, 32650, 32669,
	/* 1323 */ 32712, 32725, 32739, 32751, 32764,
	/* 1328 */ 32848, 32865, 32882, 32898, 32914, 32930, 32946, 32963, 32981,
	/* 1337 */ 33053, 33060, 33074, 33088, 33102, 33116,
	/* 1343 */ 33126, 33138, 33149, 33160,
	/* 1347 */ 33332, -1, -1, 33347,
	/* 1351 */ 34147, 34170, 34193,
	/* 1354 */ 34296, 34309, 34322,
	/* 1357 */ 34334, 34352, 34372, 34392,
	/* 1361 */ 34420, 34436, 34453,
	/* 1364 */ 34480, 34495,
	/* 1366 */ -1, 34613, 34636, 34659, 34682, 34697, 34710, 34722, 34739, -1, 34758, 34778, 34798, 34817, 35548, 34829, 34846, 34863, 35560, 35571, 34895, 34924, 34935, 34961, 34979, 34996, 35015, 35033, 35052, 35068, 35084, 35104, 35126, 35148, 35162, 35181, 35197, 35591, -1, 35207, 35222, -1, 35240, 35263, 35288, 35310, 35335, 7959, 7986, 35357, -1, 35385, 35404, 35422, 35442, 35461, 35481, 35505, 35526, -1, -1, 35605, 35625,
	/* 1429 */ 36167, 36180, 36192,
	/* 1432 */ 36204, 36217, 36229,
	/* 1435 */ 36243, 36257, 36269,
	/* 1438 */ 36431, 36444, 36458,
	/* 1441 */ 36468, 36481, 36491, 36505,
	/* 1445 */ 36533, 36546, 36558, 36577,
	/* 1449 */ 34480, 34495, 36674,
	/* 1452 */ 36692, 36718, 36744, 36769,
	/* 1456 */ 37594, 37605, 37613, 37629,
	/* 1460 */ 37655, 37681, 37706, 37731, 37754, 37775, 37802, 37831,
	/* 1468 */ 38178, 38190, 38203, 38216,
	/* 1472 */ 38236, 38250, 38258, 38267, 38277, 38286, 38298, 38313, 38328, 38345, 38362, 38376, 38388, -1, 38406, -1, 38424, 38436, 38450, 38464, 38478, 38489, 38500,
	/* 1495 */ 38521, 38534, -1, -1, 38547, 38559, 38571, 38583,
	/* 1503 */ 38608, 38617, 38626, 38639,
	/* 1507 */ 38716, 38731, 38749, 38777, 38807, 38838, 38866, 38896,
	/* 1515 */ 13444, 12989, 13188, 941,
	/* 1519 */ 245, 39821, 20618, 941,
	/* 1523 */ 40440, 40456, 40473, 40500,
};

#endif
