
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yylval          MYSQLlval
#define yychar          MYSQLchar
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 25 "/home/buildbot/buildbot/build/sql/sql_yacc.yy"

#define YYLIP  (& thd->m_parser_state->m_lip)
#define YYPS   (& thd->m_parser_state->m_yacc)
#define YYCSCL (thd->variables.character_set_client)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (thd->lex)

#define Select Lex->current_select
#include "sql_priv.h"
#include "unireg.h"                    // REQUIRED: for other includes
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Sql_cmd_alter_table*
#include "sql_truncate.h"                      // Sql_cmd_truncate_table
#include "sql_admin.h"                         // Sql_cmd_analyze/Check..._table
#include "sql_partition_admin.h"               // Sql_cmd_alter_table_*_part.
#include "sql_handler.h"                       // Sql_cmd_handler_*
#include "sql_signal.h"
#include "sql_get_diagnostics.h"               // Sql_cmd_get_diagnostics
#include "event_parse_data.h"
#include "create_options.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"
#include "rpl_mi.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror(current_thd, (char*) (A));      \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(thd);  \
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, strlen(yytext), thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(THD *thd, const char *s)
{
  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug-dbug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug-dbug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label(current_thd, empty_lex_str, lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  return sp->add_instr(i);
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

int case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  return !test(i) ||
         sp->push_backpatch(i, ctx->push_label(current_thd, empty_lex_str, 0)) ||
         sp->add_cont_backpatch(i) ||
         sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

int case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  if (!test(i) || sp->add_instr(i))
    return 1;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (lex->spcont && tmp->var == Sys_autocommit_ptr)
    lex->sphead->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to push a SP local variable into the assignment list.

  @param thd      the current thread
  @param var_type the SP local variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_local_variable(THD *thd, sp_variable *spv, Item *val)
{
  Item *it;
  LEX *lex= thd->lex;
  sp_instr_set *sp_set;

  if (val)
    it= val;
  else if (spv->default_value)
    it= spv->default_value;
  else
  {
    it= new (thd->mem_root) Item_null();
    if (it == NULL)
      return TRUE;
  }

  sp_set= new sp_instr_set(lex->sphead->instructions(), lex->spcont,
                           spv->offset, it, spv->type, lex, TRUE);

  return (sp_set == NULL || lex->sphead->add_instr(sp_set));
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd      the current thread
  @param name     the field name
  @param val      the value being assigned to the row

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_trigger_new_row(THD *thd, LEX_STRING *name, Item *val)
{
  LEX *lex= thd->lex;
  Item_trigger_field *trg_fld;
  sp_instr_set_trigger_field *sp_fld;

  /* QQ: Shouldn't this be field's default value ? */
  if (! val)
    val= new Item_null();

  DBUG_ASSERT(lex->trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (lex->trg_chistics.event == TRG_EVENT_INSERT ||
               lex->trg_chistics.event == TRG_EVENT_UPDATE));

  trg_fld= new (thd->mem_root)
            Item_trigger_field(lex->current_context(),
                               Item_trigger_field::NEW_ROW,
                               name->str, UPDATE_ACL, FALSE);

  if (trg_fld == NULL)
    return TRUE;

  sp_fld= new sp_instr_set_trigger_field(lex->sphead->instructions(),
                                         lex->spcont, trg_fld, val, lex);

  if (sp_fld == NULL)
    return TRUE;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  lex->trg_table_fields.link_in_list(trg_fld, &trg_fld->next_trg_field);

  return lex->sphead->add_instr(sp_fld);
}


/**
  Create an object to represent a SP variable in the Item-hierarchy.

  @param  thd         The current thread.
  @param  name        The SP variable name.
  @param  spvar       The SP variable (optional).
  @param  start_in_q  Start position of the SP variable name in the query.
  @param  end_in_q    End position of the SP variable name in the query.

  @remark If spvar is not specified, the name is used to search for the
          variable in the parse-time context. If the variable does not
          exist, a error is set and NULL is returned to the caller.

  @return An Item_splocal object representing the SP variable, or NULL on error.
*/
static Item_splocal*
create_item_for_sp_var(THD *thd, LEX_STRING name, sp_variable *spvar,
                       const char *start_in_q, const char *end_in_q)
{
  Item_splocal *item;
  LEX *lex= thd->lex;
  uint pos_in_q, len_in_q;
  sp_pcontext *spc = lex->spcont;

  /* If necessary, look for the variable. */
  if (spc && !spvar)
    spvar= spc->find_variable(name, false);

  if (!spvar)
  {
    my_error(ER_SP_UNDECLARED_VAR, MYF(0), name.str);
    return NULL;
  }

  DBUG_ASSERT(spc && spvar);

  /* Position and length of the SP variable name in the query. */
  pos_in_q= start_in_q - lex->sphead->m_tmp_query;
  len_in_q= end_in_q - start_in_q;

  item= new (thd->mem_root)
    Item_splocal(name, spvar->offset, spvar->type, pos_in_q, len_in_q);

#ifndef DBUG_OFF
  if (item)
    item->m_sp= lex->sphead;
#endif

  return item;
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_UPGRADABLE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= Alter_info::ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  lex->option_list= NULL;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list, lex->option_list, lex->check_exists);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}


/**
  Create a separate LEX for each assignment if in SP.

  If we are in SP we want have own LEX for each assignment.
  This is mostly because it is hard for several sp_instr_set
  and sp_instr_set_trigger instructions share one LEX.
  (Well, it is theoretically possible but adds some extra
  overhead on preparation for execution stage and IMO less
  robust).

  QQ: May be we should simply prohibit group assignments in SP?

  @see sp_create_assignment_instr

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead
*/

static void sp_create_assignment_lex(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    Lex_input_stream *lip= &thd->m_parser_state->m_lip;
    LEX *old_lex= lex;
    lex->sphead->reset_lex(thd);
    lex= thd->lex;

    /* Set new LEX as if we at start of set rule. */
    lex->sql_command= SQLCOM_SET_OPTION;
    mysql_init_select(lex);
    lex->var_list.empty();
    lex->one_shot_set= 0;
    lex->autocommit= 0;
    /* get_ptr() is only correct with no lookahead. */
    DBUG_ASSERT(no_lookahead);
    lex->sphead->m_tmp_query= lip->get_ptr();
    /* Inherit from outer lex. */
    lex->option_type= old_lex->option_type;
  }
}


/**
  Create a SP instruction for a SET assignment.

  @see sp_create_assignment_lex

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead

  @return false if success, true otherwise.
*/

static bool sp_create_assignment_instr(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    sp_head *sp= lex->sphead;

    if (!lex->var_list.is_empty())
    {
      /*
        We have assignment to user or system variable or
        option setting, so we should construct sp_instr_stmt
        for it.
      */
      LEX_STRING qbuff;
      sp_instr_stmt *i;
      Lex_input_stream *lip= &thd->m_parser_state->m_lip;

      if (!(i= new sp_instr_stmt(sp->instructions(), lex->spcont,
                                 lex)))
        return true;

      /*
        Extract the query statement from the tokenizer.  The
        end is either lip->ptr, if there was no lookahead,
        lip->tok_end otherwise.
      */
      if (no_lookahead)
        qbuff.length= lip->get_ptr() - sp->m_tmp_query;
      else
        qbuff.length= lip->get_tok_end() - sp->m_tmp_query;

      if (!(qbuff.str= (char*) alloc_root(thd->mem_root,
                                          qbuff.length + 5)))
        return true;

      strmake(strmake(qbuff.str, "SET ", 4), sp->m_tmp_query,
              qbuff.length);
      qbuff.length+= 4;
      i->m_query= qbuff;
      if (sp->add_instr(i))
        return true;
    }
    enum_var_type inner_option_type= lex->option_type;
    if (lex->sphead->restore_lex(thd))
      return true;
    /* Copy option_type to outer lex in case it has changed. */
    thd->lex->option_type= inner_option_type;
  }
  return false;
}




/* Line 189 of yacc.c  */
#line 948 "/home/buildbot/buildbot/build/mkdist/sql/sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADMIN_SYM = 262,
     ADDDATE_SYM = 263,
     AFTER_SYM = 264,
     AGAINST = 265,
     AGGREGATE_SYM = 266,
     ALGORITHM_SYM = 267,
     ALL = 268,
     ALTER = 269,
     ALWAYS_SYM = 270,
     ANALYZE_SYM = 271,
     AND_AND_SYM = 272,
     AND_SYM = 273,
     ANY_SYM = 274,
     AS = 275,
     ASC = 276,
     ASCII_SYM = 277,
     ASENSITIVE_SYM = 278,
     AT_SYM = 279,
     AUTHORS_SYM = 280,
     AUTOEXTEND_SIZE_SYM = 281,
     AUTO_INC = 282,
     AUTO_SYM = 283,
     AVG_ROW_LENGTH = 284,
     AVG_SYM = 285,
     BACKUP_SYM = 286,
     BEFORE_SYM = 287,
     BEGIN_SYM = 288,
     BETWEEN_SYM = 289,
     BIGINT = 290,
     BINARY = 291,
     BINLOG_SYM = 292,
     BIN_NUM = 293,
     BIT_AND = 294,
     BIT_OR = 295,
     BIT_SYM = 296,
     BIT_XOR = 297,
     BLOB_SYM = 298,
     BLOCK_SYM = 299,
     BOOLEAN_SYM = 300,
     BOOL_SYM = 301,
     BOTH = 302,
     BTREE_SYM = 303,
     BY = 304,
     BYTE_SYM = 305,
     CACHE_SYM = 306,
     CALL_SYM = 307,
     CASCADE = 308,
     CASCADED = 309,
     CASE_SYM = 310,
     CAST_SYM = 311,
     CATALOG_NAME_SYM = 312,
     CHAIN_SYM = 313,
     CHANGE = 314,
     CHANGED = 315,
     CHARSET = 316,
     CHAR_SYM = 317,
     CHECKPOINT_SYM = 318,
     CHECKSUM_SYM = 319,
     CHECK_SYM = 320,
     CIPHER_SYM = 321,
     CLASS_ORIGIN_SYM = 322,
     CLIENT_SYM = 323,
     CLIENT_STATS_SYM = 324,
     CLOSE_SYM = 325,
     COALESCE = 326,
     CODE_SYM = 327,
     COLLATE_SYM = 328,
     COLLATION_SYM = 329,
     COLUMNS = 330,
     COLUMN_ADD_SYM = 331,
     COLUMN_CHECK_SYM = 332,
     COLUMN_CREATE_SYM = 333,
     COLUMN_DELETE_SYM = 334,
     COLUMN_GET_SYM = 335,
     COLUMN_SYM = 336,
     COLUMN_NAME_SYM = 337,
     COMMENT_SYM = 338,
     COMMITTED_SYM = 339,
     COMMIT_SYM = 340,
     COMPACT_SYM = 341,
     COMPLETION_SYM = 342,
     COMPRESSED_SYM = 343,
     CONCURRENT = 344,
     CONDITION_SYM = 345,
     CONNECTION_SYM = 346,
     CONSISTENT_SYM = 347,
     CONSTRAINT = 348,
     CONSTRAINT_CATALOG_SYM = 349,
     CONSTRAINT_NAME_SYM = 350,
     CONSTRAINT_SCHEMA_SYM = 351,
     CONTAINS_SYM = 352,
     CONTEXT_SYM = 353,
     CONTINUE_SYM = 354,
     CONTRIBUTORS_SYM = 355,
     CONVERT_SYM = 356,
     COUNT_SYM = 357,
     CPU_SYM = 358,
     CREATE = 359,
     CROSS = 360,
     CUBE_SYM = 361,
     CURDATE = 362,
     CURRENT_SYM = 363,
     CURRENT_USER = 364,
     CURRENT_ROLE = 365,
     CURRENT_POS_SYM = 366,
     CURSOR_SYM = 367,
     CURSOR_NAME_SYM = 368,
     CURTIME = 369,
     DATABASE = 370,
     DATABASES = 371,
     DATAFILE_SYM = 372,
     DATA_SYM = 373,
     DATETIME = 374,
     DATE_ADD_INTERVAL = 375,
     DATE_SUB_INTERVAL = 376,
     DATE_SYM = 377,
     DAY_HOUR_SYM = 378,
     DAY_MICROSECOND_SYM = 379,
     DAY_MINUTE_SYM = 380,
     DAY_SECOND_SYM = 381,
     DAY_SYM = 382,
     DEALLOCATE_SYM = 383,
     DECIMAL_NUM = 384,
     DECIMAL_SYM = 385,
     DECLARE_SYM = 386,
     DEFAULT = 387,
     DEFINER_SYM = 388,
     DELAYED_SYM = 389,
     DELAY_KEY_WRITE_SYM = 390,
     DELETE_SYM = 391,
     DESC = 392,
     DESCRIBE = 393,
     DES_KEY_FILE = 394,
     DETERMINISTIC_SYM = 395,
     DIAGNOSTICS_SYM = 396,
     DIRECTORY_SYM = 397,
     DISABLE_SYM = 398,
     DISCARD = 399,
     DISK_SYM = 400,
     DISTINCT = 401,
     DIV_SYM = 402,
     DOUBLE_SYM = 403,
     DO_SYM = 404,
     DROP = 405,
     DUAL_SYM = 406,
     DUMPFILE = 407,
     DUPLICATE_SYM = 408,
     DYNAMIC_SYM = 409,
     EACH_SYM = 410,
     ELSE = 411,
     ELSEIF_SYM = 412,
     ENABLE_SYM = 413,
     ENCLOSED = 414,
     END = 415,
     ENDS_SYM = 416,
     END_OF_INPUT = 417,
     ENGINES_SYM = 418,
     ENGINE_SYM = 419,
     ENUM = 420,
     EQ = 421,
     EQUAL_SYM = 422,
     ERROR_SYM = 423,
     ERRORS = 424,
     ESCAPED = 425,
     ESCAPE_SYM = 426,
     EVENTS_SYM = 427,
     EVENT_SYM = 428,
     EVERY_SYM = 429,
     EXCHANGE_SYM = 430,
     EXAMINED_SYM = 431,
     EXECUTE_SYM = 432,
     EXISTS = 433,
     EXIT_SYM = 434,
     EXPANSION_SYM = 435,
     EXTENDED_SYM = 436,
     EXTENT_SIZE_SYM = 437,
     EXTRACT_SYM = 438,
     FALSE_SYM = 439,
     FAST_SYM = 440,
     FAULTS_SYM = 441,
     FETCH_SYM = 442,
     FILE_SYM = 443,
     FIRST_SYM = 444,
     FIXED_SYM = 445,
     FLOAT_NUM = 446,
     FLOAT_SYM = 447,
     FLUSH_SYM = 448,
     FORCE_SYM = 449,
     FOREIGN = 450,
     FOR_SYM = 451,
     FOUND_SYM = 452,
     FROM = 453,
     FULL = 454,
     FULLTEXT_SYM = 455,
     FUNCTION_SYM = 456,
     GE = 457,
     GENERAL = 458,
     GENERATED_SYM = 459,
     GEOMETRYCOLLECTION = 460,
     GEOMETRY_SYM = 461,
     GET_FORMAT = 462,
     GET_SYM = 463,
     GLOBAL_SYM = 464,
     GRANT = 465,
     GRANTS = 466,
     GROUP_SYM = 467,
     GROUP_CONCAT_SYM = 468,
     GT_SYM = 469,
     HANDLER_SYM = 470,
     HARD_SYM = 471,
     HASH_SYM = 472,
     HAVING = 473,
     HELP_SYM = 474,
     HEX_NUM = 475,
     HEX_STRING = 476,
     HIGH_PRIORITY = 477,
     HOST_SYM = 478,
     HOSTS_SYM = 479,
     HOUR_MICROSECOND_SYM = 480,
     HOUR_MINUTE_SYM = 481,
     HOUR_SECOND_SYM = 482,
     HOUR_SYM = 483,
     ID_SYM = 484,
     IDENT = 485,
     IDENTIFIED_SYM = 486,
     IDENT_QUOTED = 487,
     IF = 488,
     IGNORE_SYM = 489,
     IGNORE_SERVER_IDS_SYM = 490,
     IMPORT = 491,
     INDEXES = 492,
     INDEX_SYM = 493,
     INDEX_STATS_SYM = 494,
     INFILE = 495,
     INITIAL_SIZE_SYM = 496,
     INNER_SYM = 497,
     INOUT_SYM = 498,
     INSENSITIVE_SYM = 499,
     INSERT = 500,
     INSERT_METHOD = 501,
     INSTALL_SYM = 502,
     INTERVAL_SYM = 503,
     INTO = 504,
     INT_SYM = 505,
     INVOKER_SYM = 506,
     IN_SYM = 507,
     IO_SYM = 508,
     IPC_SYM = 509,
     IS = 510,
     ISOLATION = 511,
     ISSUER_SYM = 512,
     ITERATE_SYM = 513,
     JOIN_SYM = 514,
     KEYS = 515,
     KEY_BLOCK_SIZE = 516,
     KEY_SYM = 517,
     KILL_SYM = 518,
     LANGUAGE_SYM = 519,
     LAST_SYM = 520,
     LAST_VALUE = 521,
     LE = 522,
     LEADING = 523,
     LEAVES = 524,
     LEAVE_SYM = 525,
     LEFT = 526,
     LESS_SYM = 527,
     LEVEL_SYM = 528,
     LEX_HOSTNAME = 529,
     LIKE = 530,
     LIMIT = 531,
     LINEAR_SYM = 532,
     LINES = 533,
     LINESTRING = 534,
     LIST_SYM = 535,
     LOAD = 536,
     LOCAL_SYM = 537,
     LOCATOR_SYM = 538,
     LOCKS_SYM = 539,
     LOCK_SYM = 540,
     LOGFILE_SYM = 541,
     LOGS_SYM = 542,
     LONGBLOB = 543,
     LONGTEXT = 544,
     LONG_NUM = 545,
     LONG_SYM = 546,
     LOOP_SYM = 547,
     LOW_PRIORITY = 548,
     LT = 549,
     MASTER_CONNECT_RETRY_SYM = 550,
     MASTER_GTID_POS_SYM = 551,
     MASTER_HOST_SYM = 552,
     MASTER_LOG_FILE_SYM = 553,
     MASTER_LOG_POS_SYM = 554,
     MASTER_PASSWORD_SYM = 555,
     MASTER_PORT_SYM = 556,
     MASTER_SERVER_ID_SYM = 557,
     MASTER_SSL_CAPATH_SYM = 558,
     MASTER_SSL_CA_SYM = 559,
     MASTER_SSL_CERT_SYM = 560,
     MASTER_SSL_CIPHER_SYM = 561,
     MASTER_SSL_CRL_SYM = 562,
     MASTER_SSL_CRLPATH_SYM = 563,
     MASTER_SSL_KEY_SYM = 564,
     MASTER_SSL_SYM = 565,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 566,
     MASTER_SYM = 567,
     MASTER_USER_SYM = 568,
     MASTER_USE_GTID_SYM = 569,
     MASTER_HEARTBEAT_PERIOD_SYM = 570,
     MATCH = 571,
     MAX_CONNECTIONS_PER_HOUR = 572,
     MAX_QUERIES_PER_HOUR = 573,
     MAX_ROWS = 574,
     MAX_SIZE_SYM = 575,
     MAX_SYM = 576,
     MAX_UPDATES_PER_HOUR = 577,
     MAX_USER_CONNECTIONS_SYM = 578,
     MAX_VALUE_SYM = 579,
     MEDIUMBLOB = 580,
     MEDIUMINT = 581,
     MEDIUMTEXT = 582,
     MEDIUM_SYM = 583,
     MEMORY_SYM = 584,
     MERGE_SYM = 585,
     MESSAGE_TEXT_SYM = 586,
     MICROSECOND_SYM = 587,
     MIGRATE_SYM = 588,
     MINUTE_MICROSECOND_SYM = 589,
     MINUTE_SECOND_SYM = 590,
     MINUTE_SYM = 591,
     MIN_ROWS = 592,
     MIN_SYM = 593,
     MODE_SYM = 594,
     MODIFIES_SYM = 595,
     MODIFY_SYM = 596,
     MOD_SYM = 597,
     MONTH_SYM = 598,
     MULTILINESTRING = 599,
     MULTIPOINT = 600,
     MULTIPOLYGON = 601,
     MUTEX_SYM = 602,
     MYSQL_ERRNO_SYM = 603,
     NAMES_SYM = 604,
     NAME_SYM = 605,
     NATIONAL_SYM = 606,
     NATURAL = 607,
     NCHAR_STRING = 608,
     NCHAR_SYM = 609,
     NDBCLUSTER_SYM = 610,
     NE = 611,
     NEG = 612,
     NEW_SYM = 613,
     NEXT_SYM = 614,
     NODEGROUP_SYM = 615,
     NONE_SYM = 616,
     NOT2_SYM = 617,
     NOT_SYM = 618,
     NOW_SYM = 619,
     NO_SYM = 620,
     NO_WAIT_SYM = 621,
     NO_WRITE_TO_BINLOG = 622,
     NULL_SYM = 623,
     NUM = 624,
     NUMBER_SYM = 625,
     NUMERIC_SYM = 626,
     NVARCHAR_SYM = 627,
     OFFSET_SYM = 628,
     OLD_PASSWORD = 629,
     ON = 630,
     ONE_SYM = 631,
     ONLY_SYM = 632,
     ONLINE_SYM = 633,
     OPEN_SYM = 634,
     OPTIMIZE = 635,
     OPTIONS_SYM = 636,
     OPTION = 637,
     OPTIONALLY = 638,
     OR2_SYM = 639,
     ORDER_SYM = 640,
     OR_OR_SYM = 641,
     OR_SYM = 642,
     OUTER = 643,
     OUTFILE = 644,
     OUT_SYM = 645,
     OWNER_SYM = 646,
     PACK_KEYS_SYM = 647,
     PAGE_SYM = 648,
     PAGE_CHECKSUM_SYM = 649,
     PARAM_MARKER = 650,
     PARSER_SYM = 651,
     PARSE_VCOL_EXPR_SYM = 652,
     PARTIAL = 653,
     PARTITION_SYM = 654,
     PARTITIONS_SYM = 655,
     PARTITIONING_SYM = 656,
     PASSWORD = 657,
     PERSISTENT_SYM = 658,
     PHASE_SYM = 659,
     PLUGINS_SYM = 660,
     PLUGIN_SYM = 661,
     POINT_SYM = 662,
     POLYGON = 663,
     PORT_SYM = 664,
     POSITION_SYM = 665,
     PRECISION = 666,
     PREPARE_SYM = 667,
     PRESERVE_SYM = 668,
     PREV_SYM = 669,
     PRIMARY_SYM = 670,
     PRIVILEGES = 671,
     PROCEDURE_SYM = 672,
     PROCESS = 673,
     PROCESSLIST_SYM = 674,
     PROFILE_SYM = 675,
     PROFILES_SYM = 676,
     PROXY_SYM = 677,
     PURGE = 678,
     QUARTER_SYM = 679,
     QUERY_SYM = 680,
     QUICK = 681,
     RANGE_SYM = 682,
     READS_SYM = 683,
     READ_ONLY_SYM = 684,
     READ_SYM = 685,
     READ_WRITE_SYM = 686,
     REAL = 687,
     REBUILD_SYM = 688,
     RECOVER_SYM = 689,
     REDOFILE_SYM = 690,
     REDO_BUFFER_SIZE_SYM = 691,
     REDUNDANT_SYM = 692,
     REFERENCES = 693,
     REGEXP = 694,
     RELAY = 695,
     RELAYLOG_SYM = 696,
     RELAY_LOG_FILE_SYM = 697,
     RELAY_LOG_POS_SYM = 698,
     RELAY_THREAD = 699,
     RELEASE_SYM = 700,
     RELOAD = 701,
     REMOVE_SYM = 702,
     RENAME = 703,
     REORGANIZE_SYM = 704,
     REPAIR = 705,
     REPEATABLE_SYM = 706,
     REPEAT_SYM = 707,
     REPLACE = 708,
     REPLICATION = 709,
     REQUIRE_SYM = 710,
     RESET_SYM = 711,
     RESIGNAL_SYM = 712,
     RESOURCES = 713,
     RESTORE_SYM = 714,
     RESTRICT = 715,
     RESUME_SYM = 716,
     RETURNED_SQLSTATE_SYM = 717,
     RETURNING_SYM = 718,
     RETURNS_SYM = 719,
     RETURN_SYM = 720,
     REVERSE_SYM = 721,
     REVOKE = 722,
     RIGHT = 723,
     ROLE_SYM = 724,
     ROLLBACK_SYM = 725,
     ROLLUP_SYM = 726,
     ROUTINE_SYM = 727,
     ROWS_SYM = 728,
     ROW_FORMAT_SYM = 729,
     ROW_SYM = 730,
     ROW_COUNT_SYM = 731,
     RTREE_SYM = 732,
     SAVEPOINT_SYM = 733,
     SCHEDULE_SYM = 734,
     SCHEMA_NAME_SYM = 735,
     SECOND_MICROSECOND_SYM = 736,
     SECOND_SYM = 737,
     SECURITY_SYM = 738,
     SELECT_SYM = 739,
     SENSITIVE_SYM = 740,
     SEPARATOR_SYM = 741,
     SERIALIZABLE_SYM = 742,
     SERIAL_SYM = 743,
     SESSION_SYM = 744,
     SERVER_SYM = 745,
     SERVER_OPTIONS = 746,
     SET = 747,
     SET_VAR = 748,
     SHARE_SYM = 749,
     SHIFT_LEFT = 750,
     SHIFT_RIGHT = 751,
     SHOW = 752,
     SHUTDOWN = 753,
     SIGNAL_SYM = 754,
     SIGNED_SYM = 755,
     SIMPLE_SYM = 756,
     SLAVE = 757,
     SLAVES = 758,
     SLAVE_POS_SYM = 759,
     SLOW = 760,
     SMALLINT = 761,
     SNAPSHOT_SYM = 762,
     SOCKET_SYM = 763,
     SOFT_SYM = 764,
     SONAME_SYM = 765,
     SOUNDS_SYM = 766,
     SOURCE_SYM = 767,
     SPATIAL_SYM = 768,
     SPECIFIC_SYM = 769,
     SQLEXCEPTION_SYM = 770,
     SQLSTATE_SYM = 771,
     SQLWARNING_SYM = 772,
     SQL_BIG_RESULT = 773,
     SQL_BUFFER_RESULT = 774,
     SQL_CACHE_SYM = 775,
     SQL_CALC_FOUND_ROWS = 776,
     SQL_NO_CACHE_SYM = 777,
     SQL_SMALL_RESULT = 778,
     SQL_SYM = 779,
     SQL_THREAD = 780,
     SSL_SYM = 781,
     STARTING = 782,
     STARTS_SYM = 783,
     START_SYM = 784,
     STATS_AUTO_RECALC_SYM = 785,
     STATS_PERSISTENT_SYM = 786,
     STATS_SAMPLE_PAGES_SYM = 787,
     STATUS_SYM = 788,
     STDDEV_SAMP_SYM = 789,
     STD_SYM = 790,
     STOP_SYM = 791,
     STORAGE_SYM = 792,
     STRAIGHT_JOIN = 793,
     STRING_SYM = 794,
     SUBCLASS_ORIGIN_SYM = 795,
     SUBDATE_SYM = 796,
     SUBJECT_SYM = 797,
     SUBPARTITIONS_SYM = 798,
     SUBPARTITION_SYM = 799,
     SUBSTRING = 800,
     SUM_SYM = 801,
     SUPER_SYM = 802,
     SUSPEND_SYM = 803,
     SWAPS_SYM = 804,
     SWITCHES_SYM = 805,
     SYSDATE = 806,
     TABLES = 807,
     TABLESPACE = 808,
     TABLE_REF_PRIORITY = 809,
     TABLE_STATS_SYM = 810,
     TABLE_SYM = 811,
     TABLE_CHECKSUM_SYM = 812,
     TABLE_NAME_SYM = 813,
     TEMPORARY = 814,
     TEMPTABLE_SYM = 815,
     TERMINATED = 816,
     TEXT_STRING = 817,
     TEXT_SYM = 818,
     THAN_SYM = 819,
     THEN_SYM = 820,
     TIMESTAMP = 821,
     TIMESTAMP_ADD = 822,
     TIMESTAMP_DIFF = 823,
     TIME_SYM = 824,
     TINYBLOB = 825,
     TINYINT = 826,
     TINYTEXT = 827,
     TO_SYM = 828,
     TRAILING = 829,
     TRANSACTION_SYM = 830,
     TRANSACTIONAL_SYM = 831,
     TRIGGERS_SYM = 832,
     TRIGGER_SYM = 833,
     TRIM = 834,
     TRUE_SYM = 835,
     TRUNCATE_SYM = 836,
     TYPES_SYM = 837,
     TYPE_SYM = 838,
     UDF_RETURNS_SYM = 839,
     ULONGLONG_NUM = 840,
     UNCOMMITTED_SYM = 841,
     UNDEFINED_SYM = 842,
     UNDERSCORE_CHARSET = 843,
     UNDOFILE_SYM = 844,
     UNDO_BUFFER_SIZE_SYM = 845,
     UNDO_SYM = 846,
     UNICODE_SYM = 847,
     UNINSTALL_SYM = 848,
     UNION_SYM = 849,
     UNIQUE_SYM = 850,
     UNKNOWN_SYM = 851,
     UNLOCK_SYM = 852,
     UNSIGNED = 853,
     UNTIL_SYM = 854,
     UPDATE_SYM = 855,
     UPGRADE_SYM = 856,
     USAGE = 857,
     USER = 858,
     USER_STATS_SYM = 859,
     USE_FRM = 860,
     USE_SYM = 861,
     USING = 862,
     UTC_DATE_SYM = 863,
     UTC_TIMESTAMP_SYM = 864,
     UTC_TIME_SYM = 865,
     VALUES = 866,
     VALUE_SYM = 867,
     VARBINARY = 868,
     VARCHAR = 869,
     VARIABLES = 870,
     VARIANCE_SYM = 871,
     VARYING = 872,
     VAR_SAMP_SYM = 873,
     VIA_SYM = 874,
     VIEW_SYM = 875,
     VIRTUAL_SYM = 876,
     WAIT_SYM = 877,
     WARNINGS = 878,
     WEEK_SYM = 879,
     WEIGHT_STRING_SYM = 880,
     WHEN_SYM = 881,
     WHERE = 882,
     WHILE_SYM = 883,
     WITH = 884,
     WITH_CUBE_SYM = 885,
     WITH_ROLLUP_SYM = 886,
     WORK_SYM = 887,
     WRAPPER_SYM = 888,
     WRITE_SYM = 889,
     X509_SYM = 890,
     XA_SYM = 891,
     XML_SYM = 892,
     XOR = 893,
     YEAR_MONTH_SYM = 894,
     YEAR_SYM = 895,
     ZEROFILL = 896,
     IMPOSSIBLE_ACTION = 897
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADMIN_SYM 262
#define ADDDATE_SYM 263
#define AFTER_SYM 264
#define AGAINST 265
#define AGGREGATE_SYM 266
#define ALGORITHM_SYM 267
#define ALL 268
#define ALTER 269
#define ALWAYS_SYM 270
#define ANALYZE_SYM 271
#define AND_AND_SYM 272
#define AND_SYM 273
#define ANY_SYM 274
#define AS 275
#define ASC 276
#define ASCII_SYM 277
#define ASENSITIVE_SYM 278
#define AT_SYM 279
#define AUTHORS_SYM 280
#define AUTOEXTEND_SIZE_SYM 281
#define AUTO_INC 282
#define AUTO_SYM 283
#define AVG_ROW_LENGTH 284
#define AVG_SYM 285
#define BACKUP_SYM 286
#define BEFORE_SYM 287
#define BEGIN_SYM 288
#define BETWEEN_SYM 289
#define BIGINT 290
#define BINARY 291
#define BINLOG_SYM 292
#define BIN_NUM 293
#define BIT_AND 294
#define BIT_OR 295
#define BIT_SYM 296
#define BIT_XOR 297
#define BLOB_SYM 298
#define BLOCK_SYM 299
#define BOOLEAN_SYM 300
#define BOOL_SYM 301
#define BOTH 302
#define BTREE_SYM 303
#define BY 304
#define BYTE_SYM 305
#define CACHE_SYM 306
#define CALL_SYM 307
#define CASCADE 308
#define CASCADED 309
#define CASE_SYM 310
#define CAST_SYM 311
#define CATALOG_NAME_SYM 312
#define CHAIN_SYM 313
#define CHANGE 314
#define CHANGED 315
#define CHARSET 316
#define CHAR_SYM 317
#define CHECKPOINT_SYM 318
#define CHECKSUM_SYM 319
#define CHECK_SYM 320
#define CIPHER_SYM 321
#define CLASS_ORIGIN_SYM 322
#define CLIENT_SYM 323
#define CLIENT_STATS_SYM 324
#define CLOSE_SYM 325
#define COALESCE 326
#define CODE_SYM 327
#define COLLATE_SYM 328
#define COLLATION_SYM 329
#define COLUMNS 330
#define COLUMN_ADD_SYM 331
#define COLUMN_CHECK_SYM 332
#define COLUMN_CREATE_SYM 333
#define COLUMN_DELETE_SYM 334
#define COLUMN_GET_SYM 335
#define COLUMN_SYM 336
#define COLUMN_NAME_SYM 337
#define COMMENT_SYM 338
#define COMMITTED_SYM 339
#define COMMIT_SYM 340
#define COMPACT_SYM 341
#define COMPLETION_SYM 342
#define COMPRESSED_SYM 343
#define CONCURRENT 344
#define CONDITION_SYM 345
#define CONNECTION_SYM 346
#define CONSISTENT_SYM 347
#define CONSTRAINT 348
#define CONSTRAINT_CATALOG_SYM 349
#define CONSTRAINT_NAME_SYM 350
#define CONSTRAINT_SCHEMA_SYM 351
#define CONTAINS_SYM 352
#define CONTEXT_SYM 353
#define CONTINUE_SYM 354
#define CONTRIBUTORS_SYM 355
#define CONVERT_SYM 356
#define COUNT_SYM 357
#define CPU_SYM 358
#define CREATE 359
#define CROSS 360
#define CUBE_SYM 361
#define CURDATE 362
#define CURRENT_SYM 363
#define CURRENT_USER 364
#define CURRENT_ROLE 365
#define CURRENT_POS_SYM 366
#define CURSOR_SYM 367
#define CURSOR_NAME_SYM 368
#define CURTIME 369
#define DATABASE 370
#define DATABASES 371
#define DATAFILE_SYM 372
#define DATA_SYM 373
#define DATETIME 374
#define DATE_ADD_INTERVAL 375
#define DATE_SUB_INTERVAL 376
#define DATE_SYM 377
#define DAY_HOUR_SYM 378
#define DAY_MICROSECOND_SYM 379
#define DAY_MINUTE_SYM 380
#define DAY_SECOND_SYM 381
#define DAY_SYM 382
#define DEALLOCATE_SYM 383
#define DECIMAL_NUM 384
#define DECIMAL_SYM 385
#define DECLARE_SYM 386
#define DEFAULT 387
#define DEFINER_SYM 388
#define DELAYED_SYM 389
#define DELAY_KEY_WRITE_SYM 390
#define DELETE_SYM 391
#define DESC 392
#define DESCRIBE 393
#define DES_KEY_FILE 394
#define DETERMINISTIC_SYM 395
#define DIAGNOSTICS_SYM 396
#define DIRECTORY_SYM 397
#define DISABLE_SYM 398
#define DISCARD 399
#define DISK_SYM 400
#define DISTINCT 401
#define DIV_SYM 402
#define DOUBLE_SYM 403
#define DO_SYM 404
#define DROP 405
#define DUAL_SYM 406
#define DUMPFILE 407
#define DUPLICATE_SYM 408
#define DYNAMIC_SYM 409
#define EACH_SYM 410
#define ELSE 411
#define ELSEIF_SYM 412
#define ENABLE_SYM 413
#define ENCLOSED 414
#define END 415
#define ENDS_SYM 416
#define END_OF_INPUT 417
#define ENGINES_SYM 418
#define ENGINE_SYM 419
#define ENUM 420
#define EQ 421
#define EQUAL_SYM 422
#define ERROR_SYM 423
#define ERRORS 424
#define ESCAPED 425
#define ESCAPE_SYM 426
#define EVENTS_SYM 427
#define EVENT_SYM 428
#define EVERY_SYM 429
#define EXCHANGE_SYM 430
#define EXAMINED_SYM 431
#define EXECUTE_SYM 432
#define EXISTS 433
#define EXIT_SYM 434
#define EXPANSION_SYM 435
#define EXTENDED_SYM 436
#define EXTENT_SIZE_SYM 437
#define EXTRACT_SYM 438
#define FALSE_SYM 439
#define FAST_SYM 440
#define FAULTS_SYM 441
#define FETCH_SYM 442
#define FILE_SYM 443
#define FIRST_SYM 444
#define FIXED_SYM 445
#define FLOAT_NUM 446
#define FLOAT_SYM 447
#define FLUSH_SYM 448
#define FORCE_SYM 449
#define FOREIGN 450
#define FOR_SYM 451
#define FOUND_SYM 452
#define FROM 453
#define FULL 454
#define FULLTEXT_SYM 455
#define FUNCTION_SYM 456
#define GE 457
#define GENERAL 458
#define GENERATED_SYM 459
#define GEOMETRYCOLLECTION 460
#define GEOMETRY_SYM 461
#define GET_FORMAT 462
#define GET_SYM 463
#define GLOBAL_SYM 464
#define GRANT 465
#define GRANTS 466
#define GROUP_SYM 467
#define GROUP_CONCAT_SYM 468
#define GT_SYM 469
#define HANDLER_SYM 470
#define HARD_SYM 471
#define HASH_SYM 472
#define HAVING 473
#define HELP_SYM 474
#define HEX_NUM 475
#define HEX_STRING 476
#define HIGH_PRIORITY 477
#define HOST_SYM 478
#define HOSTS_SYM 479
#define HOUR_MICROSECOND_SYM 480
#define HOUR_MINUTE_SYM 481
#define HOUR_SECOND_SYM 482
#define HOUR_SYM 483
#define ID_SYM 484
#define IDENT 485
#define IDENTIFIED_SYM 486
#define IDENT_QUOTED 487
#define IF 488
#define IGNORE_SYM 489
#define IGNORE_SERVER_IDS_SYM 490
#define IMPORT 491
#define INDEXES 492
#define INDEX_SYM 493
#define INDEX_STATS_SYM 494
#define INFILE 495
#define INITIAL_SIZE_SYM 496
#define INNER_SYM 497
#define INOUT_SYM 498
#define INSENSITIVE_SYM 499
#define INSERT 500
#define INSERT_METHOD 501
#define INSTALL_SYM 502
#define INTERVAL_SYM 503
#define INTO 504
#define INT_SYM 505
#define INVOKER_SYM 506
#define IN_SYM 507
#define IO_SYM 508
#define IPC_SYM 509
#define IS 510
#define ISOLATION 511
#define ISSUER_SYM 512
#define ITERATE_SYM 513
#define JOIN_SYM 514
#define KEYS 515
#define KEY_BLOCK_SIZE 516
#define KEY_SYM 517
#define KILL_SYM 518
#define LANGUAGE_SYM 519
#define LAST_SYM 520
#define LAST_VALUE 521
#define LE 522
#define LEADING 523
#define LEAVES 524
#define LEAVE_SYM 525
#define LEFT 526
#define LESS_SYM 527
#define LEVEL_SYM 528
#define LEX_HOSTNAME 529
#define LIKE 530
#define LIMIT 531
#define LINEAR_SYM 532
#define LINES 533
#define LINESTRING 534
#define LIST_SYM 535
#define LOAD 536
#define LOCAL_SYM 537
#define LOCATOR_SYM 538
#define LOCKS_SYM 539
#define LOCK_SYM 540
#define LOGFILE_SYM 541
#define LOGS_SYM 542
#define LONGBLOB 543
#define LONGTEXT 544
#define LONG_NUM 545
#define LONG_SYM 546
#define LOOP_SYM 547
#define LOW_PRIORITY 548
#define LT 549
#define MASTER_CONNECT_RETRY_SYM 550
#define MASTER_GTID_POS_SYM 551
#define MASTER_HOST_SYM 552
#define MASTER_LOG_FILE_SYM 553
#define MASTER_LOG_POS_SYM 554
#define MASTER_PASSWORD_SYM 555
#define MASTER_PORT_SYM 556
#define MASTER_SERVER_ID_SYM 557
#define MASTER_SSL_CAPATH_SYM 558
#define MASTER_SSL_CA_SYM 559
#define MASTER_SSL_CERT_SYM 560
#define MASTER_SSL_CIPHER_SYM 561
#define MASTER_SSL_CRL_SYM 562
#define MASTER_SSL_CRLPATH_SYM 563
#define MASTER_SSL_KEY_SYM 564
#define MASTER_SSL_SYM 565
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 566
#define MASTER_SYM 567
#define MASTER_USER_SYM 568
#define MASTER_USE_GTID_SYM 569
#define MASTER_HEARTBEAT_PERIOD_SYM 570
#define MATCH 571
#define MAX_CONNECTIONS_PER_HOUR 572
#define MAX_QUERIES_PER_HOUR 573
#define MAX_ROWS 574
#define MAX_SIZE_SYM 575
#define MAX_SYM 576
#define MAX_UPDATES_PER_HOUR 577
#define MAX_USER_CONNECTIONS_SYM 578
#define MAX_VALUE_SYM 579
#define MEDIUMBLOB 580
#define MEDIUMINT 581
#define MEDIUMTEXT 582
#define MEDIUM_SYM 583
#define MEMORY_SYM 584
#define MERGE_SYM 585
#define MESSAGE_TEXT_SYM 586
#define MICROSECOND_SYM 587
#define MIGRATE_SYM 588
#define MINUTE_MICROSECOND_SYM 589
#define MINUTE_SECOND_SYM 590
#define MINUTE_SYM 591
#define MIN_ROWS 592
#define MIN_SYM 593
#define MODE_SYM 594
#define MODIFIES_SYM 595
#define MODIFY_SYM 596
#define MOD_SYM 597
#define MONTH_SYM 598
#define MULTILINESTRING 599
#define MULTIPOINT 600
#define MULTIPOLYGON 601
#define MUTEX_SYM 602
#define MYSQL_ERRNO_SYM 603
#define NAMES_SYM 604
#define NAME_SYM 605
#define NATIONAL_SYM 606
#define NATURAL 607
#define NCHAR_STRING 608
#define NCHAR_SYM 609
#define NDBCLUSTER_SYM 610
#define NE 611
#define NEG 612
#define NEW_SYM 613
#define NEXT_SYM 614
#define NODEGROUP_SYM 615
#define NONE_SYM 616
#define NOT2_SYM 617
#define NOT_SYM 618
#define NOW_SYM 619
#define NO_SYM 620
#define NO_WAIT_SYM 621
#define NO_WRITE_TO_BINLOG 622
#define NULL_SYM 623
#define NUM 624
#define NUMBER_SYM 625
#define NUMERIC_SYM 626
#define NVARCHAR_SYM 627
#define OFFSET_SYM 628
#define OLD_PASSWORD 629
#define ON 630
#define ONE_SYM 631
#define ONLY_SYM 632
#define ONLINE_SYM 633
#define OPEN_SYM 634
#define OPTIMIZE 635
#define OPTIONS_SYM 636
#define OPTION 637
#define OPTIONALLY 638
#define OR2_SYM 639
#define ORDER_SYM 640
#define OR_OR_SYM 641
#define OR_SYM 642
#define OUTER 643
#define OUTFILE 644
#define OUT_SYM 645
#define OWNER_SYM 646
#define PACK_KEYS_SYM 647
#define PAGE_SYM 648
#define PAGE_CHECKSUM_SYM 649
#define PARAM_MARKER 650
#define PARSER_SYM 651
#define PARSE_VCOL_EXPR_SYM 652
#define PARTIAL 653
#define PARTITION_SYM 654
#define PARTITIONS_SYM 655
#define PARTITIONING_SYM 656
#define PASSWORD 657
#define PERSISTENT_SYM 658
#define PHASE_SYM 659
#define PLUGINS_SYM 660
#define PLUGIN_SYM 661
#define POINT_SYM 662
#define POLYGON 663
#define PORT_SYM 664
#define POSITION_SYM 665
#define PRECISION 666
#define PREPARE_SYM 667
#define PRESERVE_SYM 668
#define PREV_SYM 669
#define PRIMARY_SYM 670
#define PRIVILEGES 671
#define PROCEDURE_SYM 672
#define PROCESS 673
#define PROCESSLIST_SYM 674
#define PROFILE_SYM 675
#define PROFILES_SYM 676
#define PROXY_SYM 677
#define PURGE 678
#define QUARTER_SYM 679
#define QUERY_SYM 680
#define QUICK 681
#define RANGE_SYM 682
#define READS_SYM 683
#define READ_ONLY_SYM 684
#define READ_SYM 685
#define READ_WRITE_SYM 686
#define REAL 687
#define REBUILD_SYM 688
#define RECOVER_SYM 689
#define REDOFILE_SYM 690
#define REDO_BUFFER_SIZE_SYM 691
#define REDUNDANT_SYM 692
#define REFERENCES 693
#define REGEXP 694
#define RELAY 695
#define RELAYLOG_SYM 696
#define RELAY_LOG_FILE_SYM 697
#define RELAY_LOG_POS_SYM 698
#define RELAY_THREAD 699
#define RELEASE_SYM 700
#define RELOAD 701
#define REMOVE_SYM 702
#define RENAME 703
#define REORGANIZE_SYM 704
#define REPAIR 705
#define REPEATABLE_SYM 706
#define REPEAT_SYM 707
#define REPLACE 708
#define REPLICATION 709
#define REQUIRE_SYM 710
#define RESET_SYM 711
#define RESIGNAL_SYM 712
#define RESOURCES 713
#define RESTORE_SYM 714
#define RESTRICT 715
#define RESUME_SYM 716
#define RETURNED_SQLSTATE_SYM 717
#define RETURNING_SYM 718
#define RETURNS_SYM 719
#define RETURN_SYM 720
#define REVERSE_SYM 721
#define REVOKE 722
#define RIGHT 723
#define ROLE_SYM 724
#define ROLLBACK_SYM 725
#define ROLLUP_SYM 726
#define ROUTINE_SYM 727
#define ROWS_SYM 728
#define ROW_FORMAT_SYM 729
#define ROW_SYM 730
#define ROW_COUNT_SYM 731
#define RTREE_SYM 732
#define SAVEPOINT_SYM 733
#define SCHEDULE_SYM 734
#define SCHEMA_NAME_SYM 735
#define SECOND_MICROSECOND_SYM 736
#define SECOND_SYM 737
#define SECURITY_SYM 738
#define SELECT_SYM 739
#define SENSITIVE_SYM 740
#define SEPARATOR_SYM 741
#define SERIALIZABLE_SYM 742
#define SERIAL_SYM 743
#define SESSION_SYM 744
#define SERVER_SYM 745
#define SERVER_OPTIONS 746
#define SET 747
#define SET_VAR 748
#define SHARE_SYM 749
#define SHIFT_LEFT 750
#define SHIFT_RIGHT 751
#define SHOW 752
#define SHUTDOWN 753
#define SIGNAL_SYM 754
#define SIGNED_SYM 755
#define SIMPLE_SYM 756
#define SLAVE 757
#define SLAVES 758
#define SLAVE_POS_SYM 759
#define SLOW 760
#define SMALLINT 761
#define SNAPSHOT_SYM 762
#define SOCKET_SYM 763
#define SOFT_SYM 764
#define SONAME_SYM 765
#define SOUNDS_SYM 766
#define SOURCE_SYM 767
#define SPATIAL_SYM 768
#define SPECIFIC_SYM 769
#define SQLEXCEPTION_SYM 770
#define SQLSTATE_SYM 771
#define SQLWARNING_SYM 772
#define SQL_BIG_RESULT 773
#define SQL_BUFFER_RESULT 774
#define SQL_CACHE_SYM 775
#define SQL_CALC_FOUND_ROWS 776
#define SQL_NO_CACHE_SYM 777
#define SQL_SMALL_RESULT 778
#define SQL_SYM 779
#define SQL_THREAD 780
#define SSL_SYM 781
#define STARTING 782
#define STARTS_SYM 783
#define START_SYM 784
#define STATS_AUTO_RECALC_SYM 785
#define STATS_PERSISTENT_SYM 786
#define STATS_SAMPLE_PAGES_SYM 787
#define STATUS_SYM 788
#define STDDEV_SAMP_SYM 789
#define STD_SYM 790
#define STOP_SYM 791
#define STORAGE_SYM 792
#define STRAIGHT_JOIN 793
#define STRING_SYM 794
#define SUBCLASS_ORIGIN_SYM 795
#define SUBDATE_SYM 796
#define SUBJECT_SYM 797
#define SUBPARTITIONS_SYM 798
#define SUBPARTITION_SYM 799
#define SUBSTRING 800
#define SUM_SYM 801
#define SUPER_SYM 802
#define SUSPEND_SYM 803
#define SWAPS_SYM 804
#define SWITCHES_SYM 805
#define SYSDATE 806
#define TABLES 807
#define TABLESPACE 808
#define TABLE_REF_PRIORITY 809
#define TABLE_STATS_SYM 810
#define TABLE_SYM 811
#define TABLE_CHECKSUM_SYM 812
#define TABLE_NAME_SYM 813
#define TEMPORARY 814
#define TEMPTABLE_SYM 815
#define TERMINATED 816
#define TEXT_STRING 817
#define TEXT_SYM 818
#define THAN_SYM 819
#define THEN_SYM 820
#define TIMESTAMP 821
#define TIMESTAMP_ADD 822
#define TIMESTAMP_DIFF 823
#define TIME_SYM 824
#define TINYBLOB 825
#define TINYINT 826
#define TINYTEXT 827
#define TO_SYM 828
#define TRAILING 829
#define TRANSACTION_SYM 830
#define TRANSACTIONAL_SYM 831
#define TRIGGERS_SYM 832
#define TRIGGER_SYM 833
#define TRIM 834
#define TRUE_SYM 835
#define TRUNCATE_SYM 836
#define TYPES_SYM 837
#define TYPE_SYM 838
#define UDF_RETURNS_SYM 839
#define ULONGLONG_NUM 840
#define UNCOMMITTED_SYM 841
#define UNDEFINED_SYM 842
#define UNDERSCORE_CHARSET 843
#define UNDOFILE_SYM 844
#define UNDO_BUFFER_SIZE_SYM 845
#define UNDO_SYM 846
#define UNICODE_SYM 847
#define UNINSTALL_SYM 848
#define UNION_SYM 849
#define UNIQUE_SYM 850
#define UNKNOWN_SYM 851
#define UNLOCK_SYM 852
#define UNSIGNED 853
#define UNTIL_SYM 854
#define UPDATE_SYM 855
#define UPGRADE_SYM 856
#define USAGE 857
#define USER 858
#define USER_STATS_SYM 859
#define USE_FRM 860
#define USE_SYM 861
#define USING 862
#define UTC_DATE_SYM 863
#define UTC_TIMESTAMP_SYM 864
#define UTC_TIME_SYM 865
#define VALUES 866
#define VALUE_SYM 867
#define VARBINARY 868
#define VARCHAR 869
#define VARIABLES 870
#define VARIANCE_SYM 871
#define VARYING 872
#define VAR_SAMP_SYM 873
#define VIA_SYM 874
#define VIEW_SYM 875
#define VIRTUAL_SYM 876
#define WAIT_SYM 877
#define WARNINGS 878
#define WEEK_SYM 879
#define WEIGHT_STRING_SYM 880
#define WHEN_SYM 881
#define WHERE 882
#define WHILE_SYM 883
#define WITH 884
#define WITH_CUBE_SYM 885
#define WITH_ROLLUP_SYM 886
#define WORK_SYM 887
#define WRAPPER_SYM 888
#define WRITE_SYM 889
#define X509_SYM 890
#define XA_SYM 891
#define XML_SYM 892
#define XOR 893
#define YEAR_MONTH_SYM 894
#define YEAR_SYM 895
#define ZEROFILL 896
#define IMPOSSIBLE_ACTION 897




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 890 "/home/buildbot/buildbot/build/sql/sql_yacc.yy"

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  enum ha_choice choice;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  class sp_condition_value *spcondvalue;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  Diagnostics_information::Which_area diag_area;
  Diagnostics_information *diag_info;
  Statement_information_item *stmt_info_item;
  Statement_information_item::Name stmt_info_item_name;
  List<Statement_information_item> *stmt_info_list;
  Condition_information_item *cond_info_item;
  Condition_information_item::Name cond_info_item_name;
  List<Condition_information_item> *cond_info_list;
  DYNCALL_CREATE_DEF *dyncol_def;
  List<DYNCALL_CREATE_DEF> *dyncol_def_list;
  bool is_not_empty;



/* Line 214 of yacc.c  */
#line 2330 "/home/buildbot/buildbot/build/mkdist/sql/sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 950 "/home/buildbot/buildbot/build/sql/sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 264 of yacc.c  */
#line 2347 "/home/buildbot/buildbot/build/mkdist/sql/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  624
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   65738

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  662
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  995
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2819
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4785

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   897

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   655,     2,     2,     2,   649,   644,     2,
     652,   653,   647,   646,   654,   645,   660,   648,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   661,   658,
       2,     2,     2,     2,   659,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   650,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   656,   643,   657,   651,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   117,   119,
     121,   123,   125,   127,   129,   131,   135,   137,   139,   144,
     146,   149,   150,   155,   156,   159,   163,   165,   168,   169,
     173,   174,   181,   183,   187,   191,   195,   199,   203,   207,
     211,   215,   219,   223,   227,   231,   235,   239,   243,   247,
     253,   255,   256,   258,   262,   264,   268,   272,   276,   280,
     284,   288,   292,   293,   295,   297,   298,   306,   307,   308,
     324,   325,   326,   342,   343,   344,   360,   361,   368,   369,
     373,   378,   384,   389,   393,   396,   407,   409,   413,   416,
     419,   422,   425,   428,   431,   434,   435,   449,   450,   457,
     460,   461,   463,   467,   469,   470,   473,   474,   477,   478,
     480,   484,   489,   490,   493,   494,   497,   499,   501,   503,
     505,   507,   509,   511,   513,   515,   517,   519,   521,   523,
     524,   528,   530,   531,   534,   535,   538,   541,   544,   547,
     550,   554,   558,   560,   562,   564,   567,   571,   575,   576,
     581,   582,   586,   587,   589,   593,   595,   596,   598,   602,
     604,   605,   609,   610,   612,   616,   618,   623,   624,   626,
     628,   630,   631,   635,   638,   642,   643,   647,   648,   654,
     660,   661,   669,   675,   676,   679,   681,   683,   685,   689,
     691,   693,   695,   699,   700,   702,   704,   706,   708,   711,
     713,   717,   719,   721,   722,   724,   725,   728,   732,   738,
     740,   742,   744,   746,   748,   750,   752,   754,   756,   758,
     760,   762,   764,   766,   768,   772,   777,   778,   780,   782,
     786,   788,   792,   796,   798,   801,   803,   805,   807,   809,
     813,   817,   819,   821,   823,   825,   827,   829,   831,   833,
     835,   837,   839,   841,   843,   845,   849,   850,   853,   855,
     857,   859,   861,   863,   865,   867,   869,   871,   873,   875,
     877,   879,   880,   886,   887,   890,   891,   895,   896,   899,
     902,   905,   908,   909,   916,   919,   920,   923,   925,   927,
     931,   932,   933,   934,   942,   943,   946,   949,   951,   953,
     954,   955,   964,   965,   972,   974,   977,   979,   982,   983,
     984,   991,   992,   993,  1000,  1001,  1004,  1005,  1011,  1012,
    1014,  1015,  1021,  1022,  1025,  1026,  1032,  1037,  1038,  1039,
    1048,  1049,  1057,  1059,  1061,  1063,  1065,  1067,  1070,  1075,
    1081,  1082,  1087,  1092,  1097,  1101,  1105,  1108,  1111,  1112,
    1115,  1117,  1120,  1124,  1126,  1128,  1130,  1132,  1134,  1137,
    1141,  1143,  1145,  1147,  1149,  1151,  1153,  1155,  1157,  1159,
    1161,  1164,  1168,  1170,  1172,  1174,  1176,  1178,  1180,  1182,
    1185,  1189,  1191,  1193,  1195,  1197,  1199,  1201,  1203,  1205,
    1207,  1210,  1214,  1216,  1218,  1220,  1223,  1226,  1229,  1231,
    1233,  1235,  1237,  1240,  1244,  1248,  1252,  1256,  1260,  1264,
    1268,  1272,  1277,  1278,  1280,  1282,  1284,  1286,  1288,  1289,
    1297,  1301,  1302,  1308,  1310,  1313,  1318,  1319,  1320,  1326,
    1327,  1335,  1337,  1338,  1340,  1341,  1346,  1347,  1348,  1352,
    1358,  1365,  1366,  1371,  1374,  1377,  1380,  1383,  1384,  1386,
    1387,  1391,  1392,  1394,  1396,  1400,  1402,  1407,  1413,  1419,
    1420,  1423,  1424,  1425,  1433,  1434,  1445,  1447,  1451,  1453,
    1455,  1456,  1459,  1460,  1464,  1466,  1470,  1471,  1478,  1480,
    1481,  1482,  1488,  1489,  1494,  1496,  1498,  1500,  1504,  1506,
    1510,  1511,  1512,  1518,  1520,  1524,  1526,  1528,  1529,  1533,
    1535,  1539,  1540,  1545,  1547,  1548,  1550,  1553,  1555,  1559,
    1564,  1568,  1572,  1576,  1580,  1585,  1590,  1594,  1595,  1596,
    1603,  1604,  1606,  1607,  1609,  1611,  1614,  1616,  1618,  1619,
    1621,  1623,  1626,  1628,  1629,  1633,  1634,  1636,  1638,  1641,
    1643,  1646,  1650,  1654,  1658,  1662,  1666,  1670,  1674,  1678,
    1682,  1686,  1690,  1694,  1698,  1702,  1706,  1710,  1714,  1718,
    1722,  1726,  1730,  1731,  1738,  1740,  1742,  1746,  1751,  1756,
    1759,  1762,  1765,  1769,  1773,  1777,  1781,  1785,  1789,  1793,
    1798,  1803,  1805,  1807,  1809,  1811,  1813,  1815,  1817,  1819,
    1821,  1823,  1825,  1827,  1829,  1832,  1834,  1836,  1838,  1840,
    1842,  1844,  1848,  1850,  1852,  1855,  1858,  1859,  1868,  1869,
    1879,  1880,  1890,  1891,  1901,  1910,  1913,  1914,  1916,  1921,
    1922,  1924,  1927,  1928,  1932,  1935,  1944,  1945,  1948,  1949,
    1951,  1953,  1954,  1956,  1959,  1961,  1963,  1966,  1969,  1974,
    1978,  1982,  1986,  1990,  1992,  1995,  1997,  1999,  2003,  2006,
    2010,  2013,  2016,  2018,  2022,  2026,  2029,  2033,  2035,  2038,
    2041,  2044,  2046,  2049,  2051,  2053,  2055,  2058,  2062,  2065,
    2069,  2072,  2075,  2079,  2083,  2087,  2088,  2095,  2096,  2103,
    2106,  2108,  2110,  2112,  2114,  2116,  2118,  2120,  2122,  2124,
    2126,  2128,  2131,  2134,  2136,  2139,  2141,  2144,  2148,  2151,
    2153,  2155,  2157,  2159,  2161,  2163,  2165,  2168,  2169,  2171,
    2173,  2179,  2180,  2182,  2185,  2187,  2189,  2191,  2193,  2197,
    2201,  2205,  2209,  2210,  2212,  2213,  2215,  2216,  2218,  2221,
    2223,  2225,  2228,  2231,  2236,  2238,  2242,  2245,  2247,  2250,
    2253,  2256,  2260,  2264,  2268,  2272,  2275,  2278,  2280,  2282,
    2284,  2287,  2289,  2291,  2293,  2295,  2297,  2298,  2301,  2303,
    2305,  2307,  2309,  2311,  2312,  2315,  2317,  2319,  2320,  2322,
    2324,  2327,  2330,  2332,  2335,  2338,  2339,  2341,  2343,  2345,
    2349,  2351,  2355,  2356,  2358,  2359,  2364,  2366,  2368,  2370,
    2371,  2373,  2376,  2378,  2380,  2383,  2385,  2389,  2393,  2395,
    2397,  2398,  2401,  2402,  2404,  2410,  2411,  2415,  2419,  2421,
    2422,  2425,  2428,  2431,  2432,  2436,  2440,  2447,  2454,  2456,
    2458,  2461,  2464,  2467,  2469,  2472,  2475,  2477,  2479,  2480,
    2482,  2484,  2486,  2488,  2489,  2491,  2493,  2495,  2496,  2498,
    2501,  2502,  2504,  2505,  2507,  2508,  2510,  2512,  2515,  2517,
    2520,  2522,  2525,  2528,  2531,  2535,  2538,  2542,  2546,  2550,
    2554,  2556,  2558,  2560,  2562,  2566,  2568,  2570,  2572,  2577,
    2580,  2582,  2587,  2588,  2590,  2593,  2594,  2597,  2599,  2603,
    2604,  2605,  2613,  2614,  2620,  2628,  2629,  2635,  2636,  2642,
    2643,  2649,  2650,  2655,  2656,  2667,  2671,  2676,  2680,  2684,
    2692,  2693,  2697,  2699,  2704,  2705,  2709,  2710,  2713,  2714,
    2716,  2717,  2720,  2723,  2726,  2729,  2731,  2733,  2735,  2740,
    2745,  2746,  2753,  2758,  2759,  2765,  2766,  2773,  2778,  2782,
    2784,  2792,  2795,  2797,  2799,  2800,  2807,  2808,  2812,  2815,
    2816,  2822,  2823,  2824,  2831,  2833,  2837,  2839,  2841,  2845,
    2849,  2853,  2856,  2861,  2862,  2870,  2871,  2872,  2881,  2887,
    2893,  2897,  2902,  2905,  2908,  2915,  2921,  2925,  2931,  2933,
    2935,  2937,  2939,  2941,  2942,  2944,  2946,  2949,  2952,  2956,
    2960,  2964,  2968,  2969,  2971,  2972,  2974,  2975,  2978,  2979,
    2981,  2984,  2986,  2988,  2990,  2991,  2993,  2995,  2996,  2999,
    3001,  3002,  3004,  3006,  3008,  3009,  3016,  3017,  3023,  3028,
    3033,  3037,  3038,  3040,  3042,  3046,  3050,  3053,  3056,  3057,
    3060,  3062,  3066,  3067,  3069,  3071,  3072,  3075,  3080,  3082,
    3086,  3087,  3093,  3094,  3096,  3098,  3099,  3106,  3107,  3109,
    3111,  3114,  3116,  3118,  3120,  3121,  3127,  3129,  3133,  3136,
    3137,  3141,  3143,  3148,  3150,  3151,  3156,  3158,  3159,  3164,
    3165,  3167,  3171,  3172,  3174,  3178,  3180,  3182,  3185,  3186,
    3192,  3193,  3195,  3197,  3200,  3202,  3204,  3206,  3208,  3210,
    3213,  3214,  3220,  3221,  3223,  3225,  3226,  3231,  3236,  3240,
    3246,  3248,  3252,  3256,  3257,  3264,  3266,  3268,  3270,  3274,
    3277,  3281,  3283,  3285,  3286,  3293,  3295,  3297,  3299,  3303,
    3307,  3312,  3313,  3320,  3321,  3324,  3325,  3330,  3331,  3334,
    3336,  3339,  3344,  3347,  3351,  3354,  3358,  3359,  3363,  3364,
    3365,  3372,  3375,  3377,  3379,  3382,  3385,  3394,  3399,  3400,
    3402,  3405,  3407,  3409,  3411,  3413,  3414,  3417,  3422,  3426,
    3428,  3430,  3434,  3439,  3440,  3441,  3442,  3445,  3448,  3450,
    3452,  3453,  3456,  3460,  3461,  3464,  3468,  3469,  3472,  3476,
    3480,  3484,  3487,  3491,  3496,  3500,  3505,  3509,  3514,  3516,
    3520,  3525,  3529,  3533,  3540,  3542,  3548,  3555,  3561,  3569,
    3576,  3585,  3591,  3598,  3603,  3608,  3614,  3618,  3623,  3625,
    3629,  3633,  3637,  3641,  3645,  3649,  3655,  3661,  3665,  3669,
    3673,  3677,  3681,  3685,  3687,  3689,  3691,  3693,  3695,  3697,
    3699,  3701,  3703,  3705,  3707,  3709,  3711,  3713,  3715,  3717,
    3719,  3720,  3723,  3725,  3728,  3730,  3732,  3734,  3737,  3740,
    3742,  3744,  3747,  3750,  3755,  3757,  3761,  3763,  3765,  3767,
    3769,  3771,  3775,  3777,  3779,  3781,  3783,  3787,  3790,  3793,
    3796,  3799,  3803,  3807,  3813,  3820,  3825,  3830,  3838,  3841,
    3848,  3854,  3861,  3868,  3873,  3878,  3884,  3889,  3896,  3899,
    3902,  3907,  3912,  3917,  3928,  3935,  3944,  3951,  3956,  3961,
    3968,  3973,  3978,  3983,  3990,  3995,  4003,  4011,  4019,  4026,
    4033,  4040,  4047,  4051,  4056,  4063,  4072,  4075,  4078,  4087,
    4096,  4103,  4110,  4113,  4120,  4127,  4136,  4145,  4152,  4161,
    4168,  4171,  4180,  4189,  4192,  4195,  4198,  4205,  4212,  4217,
    4222,  4231,  4236,  4241,  4246,  4251,  4255,  4264,  4269,  4274,
    4281,  4286,  4291,  4296,  4303,  4312,  4317,  4321,  4328,  4333,
    4340,  4346,  4355,  4363,  4374,  4376,  4383,  4388,  4393,  4398,
    4403,  4408,  4415,  4420,  4421,  4427,  4434,  4437,  4441,  4442,
    4447,  4448,  4452,  4453,  4455,  4457,  4461,  4466,  4471,  4477,
    4482,  4487,  4492,  4498,  4503,  4504,  4505,  4513,  4518,  4524,
    4529,  4535,  4540,  4545,  4550,  4555,  4560,  4566,  4567,  4576,
    4577,  4581,  4585,  4587,  4592,  4593,  4595,  4596,  4599,  4600,
    4601,  4606,  4611,  4614,  4615,  4619,  4622,  4626,  4629,  4631,
    4633,  4636,  4638,  4641,  4643,  4646,  4649,  4652,  4653,  4657,
    4658,  4660,  4662,  4666,  4668,  4672,  4674,  4678,  4679,  4681,
    4682,  4685,  4690,  4696,  4698,  4700,  4702,  4704,  4709,  4711,
    4715,  4719,  4720,  4727,  4728,  4737,  4742,  4743,  4752,  4753,
    4764,  4771,  4772,  4781,  4782,  4793,  4800,  4802,  4805,  4807,
    4809,  4812,  4813,  4815,  4821,  4822,  4828,  4832,  4838,  4841,
    4842,  4843,  4851,  4853,  4854,  4855,  4862,  4863,  4867,  4868,
    4869,  4875,  4876,  4878,  4879,  4881,  4882,  4885,  4889,  4893,
    4895,  4897,  4898,  4906,  4907,  4915,  4917,  4920,  4921,  4922,
    4925,  4926,  4929,  4930,  4932,  4934,  4936,  4938,  4942,  4944,
    4948,  4950,  4952,  4954,  4956,  4958,  4960,  4962,  4964,  4966,
    4968,  4970,  4972,  4974,  4976,  4978,  4980,  4982,  4984,  4986,
    4988,  4990,  4992,  4994,  4996,  4998,  4999,  5001,  5003,  5004,
    5007,  5008,  5010,  5011,  5012,  5016,  5017,  5018,  5022,  5025,
    5026,  5027,  5032,  5037,  5040,  5041,  5043,  5045,  5049,  5053,
    5055,  5058,  5059,  5061,  5062,  5067,  5072,  5075,  5076,  5078,
    5080,  5081,  5083,  5084,  5086,  5089,  5095,  5100,  5102,  5106,
    5110,  5112,  5114,  5116,  5118,  5120,  5122,  5123,  5126,  5130,
    5135,  5137,  5140,  5143,  5145,  5147,  5149,  5151,  5153,  5155,
    5157,  5159,  5161,  5163,  5165,  5167,  5169,  5171,  5173,  5175,
    5177,  5179,  5181,  5183,  5185,  5187,  5189,  5191,  5193,  5195,
    5196,  5197,  5204,  5205,  5207,  5211,  5213,  5217,  5218,  5221,
    5225,  5227,  5230,  5232,  5233,  5237,  5238,  5239,  5247,  5250,
    5252,  5253,  5257,  5258,  5266,  5267,  5275,  5280,  5287,  5292,
    5297,  5302,  5307,  5308,  5315,  5320,  5325,  5331,  5338,  5343,
    5345,  5349,  5351,  5354,  5356,  5360,  5362,  5363,  5366,  5367,
    5369,  5370,  5371,  5380,  5381,  5382,  5389,  5390,  5392,  5394,
    5396,  5398,  5400,  5403,  5405,  5407,  5409,  5413,  5418,  5419,
    5423,  5427,  5429,  5432,  5435,  5436,  5440,  5441,  5447,  5451,
    5453,  5457,  5459,  5463,  5465,  5467,  5468,  5470,  5471,  5476,
    5477,  5479,  5483,  5485,  5487,  5489,  5490,  5491,  5498,  5499,
    5500,  5512,  5516,  5518,  5522,  5526,  5528,  5532,  5533,  5535,
    5536,  5541,  5542,  5543,  5553,  5554,  5560,  5561,  5568,  5569,
    5572,  5574,  5578,  5581,  5586,  5587,  5590,  5591,  5594,  5596,
    5598,  5600,  5601,  5606,  5607,  5609,  5610,  5612,  5614,  5618,
    5620,  5622,  5625,  5628,  5631,  5633,  5635,  5637,  5639,  5640,
    5644,  5645,  5649,  5652,  5657,  5662,  5666,  5671,  5676,  5678,
    5682,  5686,  5690,  5694,  5701,  5704,  5707,  5708,  5715,  5716,
    5724,  5730,  5733,  5735,  5737,  5739,  5745,  5751,  5754,  5757,
    5759,  5764,  5768,  5771,  5775,  5778,  5781,  5783,  5787,  5792,
    5796,  5800,  5803,  5807,  5810,  5814,  5816,  5818,  5820,  5822,
    5826,  5830,  5834,  5838,  5842,  5846,  5850,  5854,  5858,  5860,
    5862,  5864,  5866,  5868,  5869,  5871,  5872,  5875,  5876,  5878,
    5880,  5882,  5883,  5886,  5887,  5890,  5891,  5894,  5897,  5898,
    5903,  5904,  5909,  5911,  5913,  5915,  5917,  5919,  5921,  5923,
    5924,  5926,  5928,  5929,  5931,  5933,  5934,  5939,  5940,  5941,
    5947,  5949,  5950,  5955,  5959,  5961,  5964,  5967,  5970,  5973,
    5976,  5980,  5983,  5985,  5987,  5989,  5991,  5994,  5996,  5998,
    6000,  6002,  6004,  6006,  6008,  6009,  6011,  6012,  6016,  6017,
    6021,  6025,  6027,  6028,  6033,  6035,  6038,  6039,  6041,  6042,
    6046,  6050,  6053,  6056,  6057,  6063,  6064,  6066,  6068,  6069,
    6071,  6073,  6076,  6078,  6081,  6083,  6086,  6087,  6088,  6089,
    6090,  6113,  6115,  6117,  6118,  6120,  6121,  6123,  6125,  6126,
    6128,  6130,  6131,  6134,  6137,  6139,  6143,  6148,  6152,  6156,
    6157,  6160,  6163,  6165,  6169,  6173,  6174,  6179,  6180,  6184,
    6186,  6188,  6189,  6193,  6196,  6200,  6202,  6204,  6207,  6208,
    6211,  6215,  6217,  6223,  6225,  6227,  6230,  6233,  6235,  6237,
    6239,  6241,  6243,  6245,  6248,  6251,  6253,  6255,  6257,  6259,
    6261,  6263,  6265,  6267,  6269,  6272,  6275,  6277,  6279,  6281,
    6283,  6285,  6288,  6291,  6294,  6296,  6298,  6302,  6308,  6310,
    6312,  6314,  6316,  6318,  6322,  6327,  6333,  6335,  6341,  6345,
    6348,  6350,  6354,  6357,  6360,  6365,  6367,  6369,  6371,  6373,
    6375,  6377,  6379,  6381,  6383,  6385,  6387,  6389,  6391,  6393,
    6397,  6400,  6402,  6404,  6406,  6408,  6410,  6412,  6414,  6416,
    6418,  6420,  6422,  6424,  6426,  6428,  6430,  6432,  6434,  6436,
    6438,  6440,  6442,  6444,  6446,  6448,  6450,  6452,  6454,  6456,
    6458,  6460,  6462,  6464,  6466,  6468,  6470,  6472,  6474,  6476,
    6478,  6480,  6482,  6484,  6486,  6488,  6490,  6492,  6494,  6496,
    6498,  6500,  6502,  6504,  6506,  6508,  6510,  6512,  6514,  6516,
    6518,  6520,  6522,  6524,  6526,  6528,  6530,  6532,  6534,  6536,
    6538,  6540,  6542,  6544,  6546,  6548,  6550,  6552,  6554,  6556,
    6558,  6560,  6562,  6564,  6566,  6568,  6570,  6572,  6574,  6576,
    6578,  6580,  6582,  6584,  6586,  6588,  6590,  6592,  6594,  6596,
    6598,  6600,  6602,  6604,  6606,  6608,  6610,  6612,  6614,  6616,
    6618,  6620,  6622,  6624,  6626,  6628,  6630,  6632,  6634,  6636,
    6638,  6640,  6642,  6644,  6646,  6648,  6650,  6652,  6654,  6656,
    6658,  6660,  6662,  6664,  6666,  6668,  6670,  6672,  6674,  6676,
    6678,  6680,  6682,  6684,  6686,  6688,  6690,  6692,  6694,  6696,
    6698,  6700,  6702,  6704,  6706,  6708,  6710,  6712,  6714,  6716,
    6718,  6720,  6722,  6724,  6726,  6728,  6730,  6732,  6734,  6736,
    6738,  6740,  6742,  6744,  6746,  6748,  6750,  6752,  6754,  6756,
    6758,  6760,  6762,  6764,  6766,  6768,  6770,  6772,  6774,  6776,
    6778,  6780,  6782,  6784,  6786,  6788,  6790,  6792,  6794,  6796,
    6798,  6800,  6802,  6804,  6806,  6808,  6810,  6812,  6814,  6816,
    6818,  6820,  6822,  6824,  6826,  6828,  6830,  6832,  6834,  6836,
    6838,  6840,  6842,  6844,  6846,  6848,  6850,  6852,  6854,  6856,
    6858,  6860,  6862,  6864,  6866,  6868,  6870,  6872,  6874,  6876,
    6878,  6880,  6882,  6884,  6886,  6888,  6890,  6892,  6894,  6896,
    6898,  6900,  6902,  6904,  6906,  6908,  6910,  6912,  6914,  6916,
    6918,  6920,  6922,  6924,  6926,  6928,  6930,  6932,  6934,  6936,
    6938,  6940,  6942,  6944,  6946,  6948,  6950,  6952,  6954,  6956,
    6958,  6960,  6962,  6964,  6966,  6968,  6970,  6972,  6974,  6976,
    6978,  6980,  6982,  6984,  6986,  6988,  6990,  6992,  6994,  6996,
    6998,  7000,  7002,  7004,  7006,  7008,  7010,  7012,  7014,  7016,
    7018,  7020,  7022,  7024,  7026,  7028,  7030,  7032,  7034,  7036,
    7038,  7040,  7042,  7044,  7046,  7048,  7050,  7052,  7054,  7056,
    7058,  7060,  7062,  7064,  7066,  7068,  7070,  7072,  7074,  7076,
    7078,  7080,  7082,  7084,  7086,  7088,  7090,  7092,  7094,  7096,
    7098,  7100,  7102,  7104,  7106,  7108,  7110,  7112,  7114,  7116,
    7118,  7120,  7122,  7124,  7126,  7128,  7130,  7132,  7134,  7136,
    7138,  7140,  7142,  7143,  7147,  7148,  7152,  7153,  7157,  7158,
    7162,  7163,  7167,  7170,  7171,  7174,  7175,  7178,  7179,  7184,
    7185,  7189,  7191,  7193,  7195,  7197,  7198,  7200,  7202,  7204,
    7205,  7208,  7211,  7214,  7218,  7222,  7227,  7234,  7237,  7241,
    7245,  7248,  7252,  7258,  7260,  7264,  7268,  7270,  7272,  7276,
    7280,  7282,  7286,  7289,  7292,  7295,  7298,  7301,  7303,  7305,
    7310,  7315,  7317,  7319,  7321,  7323,  7325,  7326,  7331,  7333,
    7335,  7337,  7341,  7345,  7347,  7349,  7352,  7355,  7358,  7359,
    7363,  7368,  7372,  7373,  7381,  7383,  7386,  7388,  7390,  7392,
    7394,  7396,  7398,  7399,  7405,  7407,  7409,  7411,  7413,  7415,
    7419,  7426,  7433,  7440,  7448,  7454,  7458,  7463,  7465,  7469,
    7478,  7487,  7496,  7503,  7508,  7509,  7513,  7514,  7518,  7520,
    7524,  7527,  7529,  7531,  7532,  7534,  7536,  7539,  7540,  7542,
    7544,  7548,  7549,  7553,  7554,  7558,  7559,  7563,  7564,  7568,
    7570,  7572,  7574,  7576,  7578,  7580,  7582,  7584,  7586,  7588,
    7590,  7593,  7596,  7598,  7602,  7605,  7608,  7611,  7614,  7617,
    7620,  7623,  7626,  7628,  7630,  7633,  7634,  7636,  7640,  7642,
    7645,  7648,  7651,  7653,  7657,  7661,  7663,  7665,  7669,  7671,
    7675,  7677,  7681,  7683,  7685,  7687,  7689,  7694,  7700,  7705,
    7712,  7714,  7715,  7719,  7723,  7725,  7727,  7728,  7731,  7734,
    7737,  7740,  7741,  7744,  7745,  7749,  7752,  7754,  7757,  7760,
    7763,  7766,  7769,  7770,  7774,  7775,  7777,  7778,  7782,  7785,
    7786,  7788,  7791,  7792,  7794,  7799,  7804,  7810,  7813,  7817,
    7818,  7820,  7821,  7826,  7827,  7829,  7831,  7832,  7834,  7835,
    7838,  7841,  7843,  7844,  7846,  7848,  7851,  7855,  7858,  7859,
    7866,  7870,  7871,  7872,  7873,  7875,  7878,  7880,  7882,  7884,
    7886,  7888,  7890,  7892,  7894,  7896,  7899,  7902,  7906,  7908,
    7910,  7912,  7914,  7916,  7918,  7920,  7922,  7924,  7926,  7928,
    7930,  7932,  7933,  7937,  7939,  7942,  7944,  7947,  7951,  7955,
    7959,  7960,  7964,  7968,  7969,  7977,  7978,  7982,  7984,  7988,
    7989,  7993,  7996,  8001,  8002,  8006,  8011,  8016,  8017,  8018,
    8019,  8036,  8045,  8053,  8054,  8055,  8056,  8057,  8058,  8074,
    8075,  8076,  8077,  8078,  8091,  8096,  8101,  8105,  8110,  8114,
    8117,  8119,  8123,  8129,  8131,  8133,  8134,  8136,  8138,  8139,
    8142,  8143,  8144,  8148,  8149,  8152,  8158,  8162,  8166,  8170
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     663,     0,    -1,   162,    -1,    -1,   666,   664,   658,   665,
      -1,   666,   162,    -1,    -1,   162,    -1,   667,    -1,  1584,
      -1,  1052,    -1,  1120,    -1,  1133,    -1,   721,    -1,   679,
      -1,  1134,    -1,  1112,    -1,  1590,    -1,   688,    -1,   668,
      -1,  1385,    -1,  1419,    -1,  1336,    -1,  1338,    -1,   672,
      -1,  1426,    -1,   757,    -1,  1550,    -1,  1540,    -1,   677,
      -1,  1349,    -1,  1654,    -1,  1656,    -1,  1147,    -1,  1446,
      -1,  1453,    -1,  1532,    -1,  1139,    -1,   966,    -1,   876,
      -1,  1154,    -1,   670,    -1,  1442,    -1,  1593,    -1,  1142,
      -1,  1115,    -1,  1352,    -1,  1436,    -1,   756,    -1,  1547,
      -1,  1591,    -1,  1592,    -1,  1166,    -1,  1505,    -1,   749,
      -1,  1405,    -1,  1451,    -1,  1099,    -1,  1102,    -1,  1398,
      -1,  1655,    -1,  1538,    -1,  1377,    -1,  1452,    -1,  1646,
      -1,   669,   412,  1498,    -1,   128,    -1,   150,    -1,   412,
    1498,   198,   671,    -1,  1495,    -1,   659,  1500,    -1,    -1,
     177,  1498,   673,   674,    -1,    -1,   607,   675,    -1,   675,
     654,   676,    -1,   676,    -1,   659,  1500,    -1,    -1,   219,
     678,  1500,    -1,    -1,    59,   312,   686,   573,   680,   681,
      -1,   682,    -1,   681,   654,   682,    -1,   297,   166,  1495,
      -1,   313,   166,  1495,    -1,   300,   166,  1495,    -1,   301,
     166,  1315,    -1,   295,   166,  1315,    -1,   310,   166,  1315,
      -1,   304,   166,  1495,    -1,   303,   166,  1495,    -1,   305,
     166,  1495,    -1,   306,   166,  1495,    -1,   309,   166,  1495,
      -1,   311,   166,  1315,    -1,   307,   166,  1495,    -1,   308,
     166,  1495,    -1,   315,   166,  1482,    -1,   235,   166,   652,
     683,   653,    -1,   685,    -1,    -1,   684,    -1,   683,   654,
     684,    -1,  1315,    -1,   298,   166,  1495,    -1,   299,   166,
    1317,    -1,   442,   166,  1495,    -1,   443,   166,  1315,    -1,
     314,   166,   111,    -1,   314,   166,   504,    -1,   314,   166,
     365,    -1,    -1,   687,    -1,  1495,    -1,    -1,   104,   928,
     556,   931,  1491,   689,   864,    -1,    -1,    -1,   104,  1029,
     238,   931,  1498,  1033,   375,  1491,   690,   652,  1046,   653,
    1034,   691,  1086,    -1,    -1,    -1,   104,  1030,   238,   931,
    1498,  1032,   375,  1491,   692,   652,  1046,   653,  1035,   693,
    1086,    -1,    -1,    -1,   104,  1031,   238,   931,  1498,  1032,
     375,  1491,   694,   652,  1046,   653,  1036,   695,  1086,    -1,
      -1,   104,   115,   931,  1498,   696,   925,    -1,    -1,   104,
     697,  1612,    -1,   104,   603,   714,  1571,    -1,   104,   469,
     714,  1554,  1552,    -1,   104,   286,   212,   827,    -1,   104,
     553,   824,    -1,   104,   698,    -1,   490,  1500,   195,   118,
     633,  1500,   381,   652,   699,   653,    -1,   700,    -1,   699,
     654,   700,    -1,   603,  1495,    -1,   223,  1495,    -1,   115,
    1495,    -1,   391,  1495,    -1,   402,  1495,    -1,   508,  1495,
      -1,   409,  1315,    -1,    -1,  1183,   173,   931,   715,   702,
     375,   479,   703,   708,   705,   710,   149,   711,    -1,    -1,
     174,  1189,  1285,   704,   706,   707,    -1,    24,  1189,    -1,
      -1,   158,    -1,   143,   375,   502,    -1,   143,    -1,    -1,
     528,  1189,    -1,    -1,   161,  1189,    -1,    -1,   709,    -1,
     375,    87,   413,    -1,   375,    87,   363,   413,    -1,    -1,
      83,  1495,    -1,    -1,   712,   713,    -1,   773,    -1,   775,
      -1,   771,    -1,   792,    -1,   810,    -1,   812,    -1,   807,
      -1,   777,    -1,   779,    -1,   780,    -1,   781,    -1,   782,
      -1,   784,    -1,    -1,  1498,   660,  1498,    -1,  1498,    -1,
      -1,   716,   718,    -1,    -1,   717,   719,    -1,    83,  1495,
      -1,   264,   524,    -1,   365,   524,    -1,    97,   524,    -1,
     428,   524,   118,    -1,   340,   524,   118,    -1,   720,    -1,
     718,    -1,   140,    -1,  1195,   140,    -1,   524,   483,   133,
      -1,   524,   483,   251,    -1,    -1,    52,   715,   722,   723,
      -1,    -1,   652,   724,   653,    -1,    -1,   725,    -1,   725,
     654,  1189,    -1,  1189,    -1,    -1,   727,    -1,   727,   654,
     729,    -1,   729,    -1,    -1,  1498,   728,   989,    -1,    -1,
     731,    -1,   731,   654,   732,    -1,   732,    -1,   733,   728,
    1498,   989,    -1,    -1,   252,    -1,   390,    -1,   243,    -1,
      -1,   734,   770,   658,    -1,   770,   658,    -1,   735,   770,
     658,    -1,    -1,   736,   737,   658,    -1,    -1,   131,   768,
     738,   989,   769,    -1,   131,  1498,    90,   196,   745,    -1,
      -1,   131,   742,   215,   196,   739,   743,   770,    -1,   131,
    1498,   112,   196,   740,    -1,    -1,   741,  1166,    -1,   179,
      -1,    99,    -1,   744,    -1,   743,   654,   744,    -1,   748,
      -1,  1315,    -1,   746,    -1,   516,   747,  1496,    -1,    -1,
     612,    -1,   745,    -1,  1498,    -1,   517,    -1,  1195,   197,
      -1,   515,    -1,   499,   750,   752,    -1,  1498,    -1,   746,
      -1,    -1,   750,    -1,    -1,   492,   753,    -1,   755,   166,
     754,    -1,   753,   654,   755,   166,   754,    -1,  1481,    -1,
    1220,    -1,  1487,    -1,    67,    -1,   540,    -1,    94,    -1,
      96,    -1,    95,    -1,    57,    -1,   480,    -1,   558,    -1,
      82,    -1,   113,    -1,   331,    -1,   348,    -1,   457,   751,
     752,    -1,   208,   758,   141,   759,    -1,    -1,   108,    -1,
     760,    -1,    90,   764,   765,    -1,   761,    -1,   760,   654,
     761,    -1,   762,   166,   763,    -1,  1498,    -1,   659,  1500,
      -1,   370,    -1,   476,    -1,   754,    -1,   766,    -1,   765,
     654,   766,    -1,   762,   166,   767,    -1,    67,    -1,   540,
      -1,    94,    -1,    96,    -1,    95,    -1,    57,    -1,   480,
      -1,   558,    -1,    82,    -1,   113,    -1,   331,    -1,   348,
      -1,   462,    -1,  1498,    -1,   768,   654,  1498,    -1,    -1,
     132,  1189,    -1,   773,    -1,   775,    -1,   771,    -1,   792,
      -1,   810,    -1,   812,    -1,   807,    -1,   777,    -1,   779,
      -1,   780,    -1,   781,    -1,   782,    -1,   784,    -1,    -1,
     233,   772,   787,   160,   233,    -1,    -1,   774,   667,    -1,
      -1,   465,   776,  1189,    -1,    -1,   778,   816,    -1,   270,
    1499,    -1,   258,  1499,    -1,   379,  1498,    -1,    -1,   187,
     785,  1498,   249,   783,   786,    -1,    70,  1498,    -1,    -1,
     359,   198,    -1,   198,    -1,  1498,    -1,   786,   654,  1498,
      -1,    -1,    -1,    -1,   788,  1189,   565,   789,   735,   790,
     791,    -1,    -1,   157,   787,    -1,   156,   735,    -1,   793,
      -1,   796,    -1,    -1,    -1,    55,   794,  1189,   795,   798,
     806,   160,    55,    -1,    -1,    55,   797,   799,   806,   160,
      55,    -1,   800,    -1,   798,   800,    -1,   803,    -1,   799,
     803,    -1,    -1,    -1,   626,   801,  1189,   802,   565,   735,
      -1,    -1,    -1,   626,   804,  1189,   805,   565,   735,    -1,
      -1,   156,   735,    -1,    -1,  1499,   661,   808,   816,   809,
      -1,    -1,  1499,    -1,    -1,  1499,   661,   811,   814,   809,
      -1,    -1,   813,   814,    -1,    -1,    33,   815,   736,   734,
     160,    -1,   292,   735,   160,   292,    -1,    -1,    -1,   628,
     817,  1189,   149,   818,   735,   160,   628,    -1,    -1,   452,
     735,   599,   819,  1189,   160,   452,    -1,    32,    -1,     9,
      -1,   245,    -1,   600,    -1,   136,    -1,   849,   851,    -1,
     849,    59,   846,   830,    -1,   849,     6,   846,   825,   834,
      -1,    -1,   606,   286,   212,  1498,    -1,   849,     6,   846,
     837,    -1,   849,   150,   846,   837,    -1,   850,   829,   840,
      -1,   850,   829,   843,    -1,     6,   847,    -1,     6,   848,
      -1,    -1,   831,   832,    -1,   833,    -1,   832,   833,    -1,
     832,   654,   833,    -1,   852,    -1,   853,    -1,   854,    -1,
     835,    -1,   836,    -1,   835,   836,    -1,   835,   654,   836,
      -1,   852,    -1,   853,    -1,   854,    -1,   855,    -1,   858,
      -1,   860,    -1,   862,    -1,   859,    -1,   838,    -1,   839,
      -1,   838,   839,    -1,   838,   654,   839,    -1,   852,    -1,
     853,    -1,   854,    -1,   860,    -1,   862,    -1,   841,    -1,
     842,    -1,   841,   842,    -1,   841,   654,   842,    -1,   852,
      -1,   856,    -1,   857,    -1,   858,    -1,   860,    -1,   862,
      -1,   859,    -1,   844,    -1,   845,    -1,   844,   845,    -1,
     844,   654,   845,    -1,   852,    -1,   860,    -1,   862,    -1,
     117,  1495,    -1,   589,  1495,    -1,   435,  1495,    -1,  1498,
      -1,  1498,    -1,   429,    -1,   431,    -1,   363,     4,    -1,
     241,  1369,   863,    -1,    26,  1369,   863,    -1,   320,  1369,
     863,    -1,   182,  1369,   863,    -1,   590,  1369,   863,    -1,
     436,  1369,   863,    -1,   360,  1369,  1316,    -1,    83,  1369,
    1495,    -1,  1412,   164,  1369,   939,    -1,    -1,   862,    -1,
     622,    -1,   366,    -1,  1318,    -1,  1494,    -1,    -1,   652,
     945,   653,   865,   932,   871,   868,    -1,   932,   871,   868,
      -1,    -1,   652,   921,   653,   866,  1597,    -1,   867,    -1,
     275,  1491,    -1,   652,   275,  1491,   653,    -1,    -1,    -1,
    1461,   924,   921,   869,  1594,    -1,    -1,  1461,   924,   652,
     921,   653,   870,  1597,    -1,   872,    -1,    -1,   873,    -1,
      -1,   399,   875,   874,   878,    -1,    -1,    -1,   399,   877,
     878,    -1,    49,   879,   889,   890,   897,    -1,   881,   262,
     882,   652,   883,   653,    -1,    -1,   881,   217,   880,   887,
      -1,   427,   887,    -1,   427,   886,    -1,   280,   887,    -1,
     280,   886,    -1,    -1,   277,    -1,    -1,    12,   166,  1316,
      -1,    -1,   884,    -1,   885,    -1,   884,   654,   885,    -1,
    1498,    -1,    75,   652,   883,   653,    -1,   652,  1183,   895,
    1184,   653,    -1,   652,  1183,   895,  1184,   653,    -1,    -1,
     400,  1316,    -1,    -1,    -1,   544,    49,   881,   217,   888,
     891,   896,    -1,    -1,   544,    49,   881,   262,   882,   652,
     893,   653,   892,   896,    -1,   894,    -1,   893,   654,   894,
      -1,  1498,    -1,  1192,    -1,    -1,   543,  1316,    -1,    -1,
     652,   898,   653,    -1,   899,    -1,   898,   654,   899,    -1,
      -1,   399,   900,   901,   902,   918,   913,    -1,  1498,    -1,
      -1,    -1,   611,   272,   564,   903,   905,    -1,    -1,   611,
     252,   904,   906,    -1,   324,    -1,   908,    -1,   908,    -1,
     652,   907,   653,    -1,   908,    -1,   907,   654,   908,    -1,
      -1,    -1,   652,   909,   911,   910,   653,    -1,   912,    -1,
     911,   654,   912,    -1,   324,    -1,  1192,    -1,    -1,   652,
     914,   653,    -1,   915,    -1,   914,   654,   915,    -1,    -1,
     544,   916,   917,   918,    -1,  1500,    -1,    -1,   919,    -1,
     919,   920,    -1,   920,    -1,   553,  1369,  1500,    -1,  1412,
     164,  1369,   939,    -1,    91,  1369,  1495,    -1,   360,  1369,
    1316,    -1,   319,  1369,  1318,    -1,   337,  1369,  1318,    -1,
     118,   142,  1369,  1495,    -1,   238,   142,  1369,  1495,    -1,
      83,  1369,  1495,    -1,    -1,    -1,   484,   922,  1177,  1181,
     923,   943,    -1,    -1,    20,    -1,    -1,   926,    -1,   927,
      -1,   926,   927,    -1,   938,    -1,   937,    -1,    -1,   929,
      -1,   930,    -1,   930,   929,    -1,   559,    -1,    -1,   233,
    1195,   178,    -1,    -1,   934,    -1,   935,    -1,   935,   933,
      -1,   935,    -1,   935,   934,    -1,   935,   654,   934,    -1,
     164,  1369,   939,    -1,   319,  1369,  1317,    -1,   337,  1369,
    1317,    -1,    29,  1369,  1315,    -1,   402,  1369,  1495,    -1,
      83,  1369,  1495,    -1,    27,  1369,  1317,    -1,   392,  1369,
    1315,    -1,   392,  1369,   132,    -1,   530,  1369,  1315,    -1,
     530,  1369,   132,    -1,   531,  1369,  1315,    -1,   531,  1369,
     132,    -1,   532,  1369,  1315,    -1,   532,  1369,   132,    -1,
      64,  1369,  1315,    -1,   557,  1369,  1315,    -1,   394,  1369,
    1321,    -1,   135,  1369,  1315,    -1,   474,  1369,   941,    -1,
      -1,   594,  1369,   936,   652,  1434,   653,    -1,   937,    -1,
     938,    -1,   246,  1369,   942,    -1,   118,   142,  1369,  1495,
      -1,   238,   142,  1369,  1495,    -1,   553,  1498,    -1,   537,
     145,    -1,   537,   329,    -1,    91,  1369,  1495,    -1,   261,
    1369,  1315,    -1,   576,  1369,  1321,    -1,  1494,  1368,  1495,
      -1,  1494,  1368,  1498,    -1,  1494,  1368,  1318,    -1,  1494,
    1368,   132,    -1,  1001,   992,  1369,   994,    -1,  1001,    73,
    1369,  1000,    -1,  1500,    -1,  1500,    -1,   132,    -1,   190,
      -1,   154,    -1,    88,    -1,   437,    -1,    86,    -1,   393,
      -1,   365,    -1,   189,    -1,   265,    -1,  1308,    -1,  1176,
    1180,    -1,   539,    -1,   432,    -1,   130,    -1,   250,    -1,
     946,    -1,   947,    -1,   946,   654,   947,    -1,   948,    -1,
     949,    -1,   958,   954,    -1,   958,  1018,    -1,    -1,  1024,
    1049,  1033,   652,  1046,   653,   950,  1034,    -1,    -1,  1030,
    1027,  1049,  1032,   652,  1046,   653,   951,  1035,    -1,    -1,
    1031,  1027,  1049,  1032,   652,  1046,   653,   952,  1036,    -1,
      -1,   956,  1025,  1049,  1033,   652,  1046,   653,   953,  1034,
      -1,   956,   195,   262,  1049,   652,  1046,   653,  1018,    -1,
     956,   955,    -1,    -1,   955,    -1,    65,   652,  1189,   653,
      -1,    -1,   957,    -1,    93,  1048,    -1,    -1,  1490,   959,
     960,    -1,   968,   986,    -1,   968,   961,    20,   652,   967,
     653,   962,   963,    -1,    -1,   204,    15,    -1,    -1,   621,
      -1,   403,    -1,    -1,   964,    -1,   964,   965,    -1,   965,
      -1,   595,    -1,   595,   262,    -1,    83,  1495,    -1,   397,
     652,   967,   653,    -1,  1183,  1189,  1184,    -1,   976,   984,
     980,    -1,   977,   985,   980,    -1,   192,   978,   980,    -1,
      41,    -1,    41,   983,    -1,    46,    -1,    45,    -1,   972,
     983,  1004,    -1,   972,  1004,    -1,   973,   983,  1005,    -1,
     973,  1005,    -1,    36,   983,    -1,    36,    -1,   974,   983,
    1004,    -1,   975,   983,  1005,    -1,   613,   983,    -1,   640,
     984,   980,    -1,   122,    -1,   569,   984,    -1,   566,   984,
      -1,   119,   984,    -1,   570,    -1,    43,   984,    -1,   971,
      -1,   325,    -1,   288,    -1,   291,   613,    -1,   291,   974,
    1004,    -1,   572,  1004,    -1,   563,   984,  1004,    -1,   327,
    1004,    -1,   289,  1004,    -1,   130,   978,   980,    -1,   371,
     978,   980,    -1,   190,   978,   980,    -1,    -1,   165,   969,
     652,  1051,   653,  1004,    -1,    -1,   492,   970,   652,  1051,
     653,  1004,    -1,   291,  1004,    -1,   488,    -1,   206,    -1,
     205,    -1,   407,    -1,   345,    -1,   279,    -1,   344,    -1,
     408,    -1,   346,    -1,    62,    -1,   354,    -1,   351,    62,
      -1,   972,   617,    -1,   614,    -1,   351,   614,    -1,   372,
      -1,   354,   614,    -1,   351,    62,   617,    -1,   354,   617,
      -1,   250,    -1,   571,    -1,   506,    -1,   326,    -1,    35,
      -1,   432,    -1,   148,    -1,   148,   411,    -1,    -1,   983,
      -1,   979,    -1,   652,   369,   654,   369,   653,    -1,    -1,
     981,    -1,   981,   982,    -1,   982,    -1,   500,    -1,   598,
      -1,   641,    -1,   652,   290,   653,    -1,   652,   585,   653,
      -1,   652,   129,   653,    -1,   652,   369,   653,    -1,    -1,
     983,    -1,    -1,   979,    -1,    -1,   987,    -1,   987,   988,
      -1,   988,    -1,   368,    -1,  1195,   368,    -1,   132,   990,
      -1,   375,   600,   364,  1186,    -1,    27,    -1,   488,   132,
     612,    -1,  1017,   262,    -1,   595,    -1,   595,   262,    -1,
      83,  1495,    -1,    73,   998,    -1,  1494,  1368,  1495,    -1,
    1494,  1368,  1498,    -1,  1494,  1368,  1318,    -1,  1494,  1368,
     132,    -1,   968,   999,    -1,   364,  1186,    -1,  1480,    -1,
     220,    -1,   221,    -1,    62,   492,    -1,    61,    -1,  1500,
      -1,    36,    -1,   993,    -1,   132,    -1,    -1,   992,   994,
      -1,  1500,    -1,    36,    -1,   996,    -1,   132,    -1,  1500,
      -1,    -1,    73,  1000,    -1,   998,    -1,   132,    -1,    -1,
     132,    -1,    22,    -1,    36,    22,    -1,    22,    36,    -1,
     592,    -1,   592,    36,    -1,    36,   592,    -1,    -1,  1002,
      -1,  1003,    -1,    50,    -1,   992,   993,  1005,    -1,    36,
      -1,    36,   992,   993,    -1,    -1,    36,    -1,    -1,   652,
    1316,  1007,   653,    -1,    21,    -1,   137,    -1,   466,    -1,
      -1,  1008,    -1,  1008,  1009,    -1,  1009,    -1,  1316,    -1,
    1011,  1010,    -1,  1012,    -1,  1013,   654,  1012,    -1,  1011,
     645,  1011,    -1,  1013,    -1,  1014,    -1,    -1,   273,  1015,
      -1,    -1,   415,    -1,   438,  1491,  1019,  1021,  1022,    -1,
      -1,   652,  1020,   653,    -1,  1020,   654,  1498,    -1,  1498,
      -1,    -1,   316,   199,    -1,   316,   398,    -1,   316,   501,
      -1,    -1,   375,   600,  1023,    -1,   375,   136,  1023,    -1,
     375,   600,  1023,   375,   136,  1023,    -1,   375,   136,  1023,
     375,   600,  1023,    -1,   460,    -1,    53,    -1,   492,   368,
      -1,   365,     5,    -1,   492,   132,    -1,  1026,    -1,   415,
     262,    -1,   595,  1027,    -1,   262,    -1,   238,    -1,    -1,
    1026,    -1,   260,    -1,   238,    -1,   237,    -1,    -1,   595,
      -1,   200,    -1,   513,    -1,    -1,  1032,    -1,  1032,  1040,
      -1,    -1,  1037,    -1,    -1,  1039,    -1,    -1,  1038,    -1,
    1042,    -1,  1037,  1042,    -1,  1043,    -1,  1038,  1043,    -1,
    1044,    -1,  1039,  1044,    -1,   607,  1045,    -1,   583,  1045,
      -1,   261,  1369,  1315,    -1,    83,  1495,    -1,  1494,  1368,
    1495,    -1,  1494,  1368,  1498,    -1,  1494,  1368,  1318,    -1,
    1494,  1368,   132,    -1,  1041,    -1,  1040,    -1,  1041,    -1,
    1041,    -1,   629,   396,  1494,    -1,    48,    -1,   477,    -1,
     217,    -1,  1046,   654,  1047,  1306,    -1,  1047,  1306,    -1,
    1498,    -1,  1498,   652,   369,   653,    -1,    -1,  1490,    -1,
     931,  1048,    -1,    -1,   660,  1498,    -1,  1478,    -1,  1051,
     654,  1478,    -1,    -1,    -1,    14,  1053,  1091,   556,  1491,
    1054,  1065,    -1,    -1,    14,   115,  1064,  1055,   926,    -1,
      14,   115,  1498,   601,   118,   142,   350,    -1,    -1,    14,
     417,   715,  1056,   716,    -1,    -1,    14,   201,   715,  1057,
     716,    -1,    -1,    14,  1620,  1615,  1058,  1622,    -1,    -1,
      14,  1615,  1059,  1622,    -1,    -1,    14,  1615,   173,   715,
    1060,  1061,  1062,   705,   710,  1063,    -1,    14,   553,   826,
      -1,    14,   286,   212,   828,    -1,    14,   553,   823,    -1,
      14,   553,   822,    -1,    14,   490,  1500,   381,   652,   699,
     653,    -1,    -1,   375,   479,   703,    -1,   709,    -1,   375,
     479,   703,   709,    -1,    -1,   448,   573,   715,    -1,    -1,
     149,   711,    -1,    -1,  1498,    -1,    -1,   144,   553,    -1,
     236,   553,    -1,  1080,   872,    -1,  1080,  1069,    -1,  1069,
      -1,   873,    -1,  1071,    -1,   150,   399,  1347,  1078,    -1,
     433,   399,  1141,  1070,    -1,    -1,   380,   399,  1141,  1070,
    1066,  1141,    -1,    16,   399,  1141,  1070,    -1,    -1,    65,
     399,  1070,  1067,  1136,    -1,    -1,   450,   399,  1141,  1070,
    1068,  1117,    -1,    71,   399,  1141,  1316,    -1,   581,   399,
    1070,    -1,  1074,    -1,   175,   399,  1079,   629,   556,  1491,
     875,    -1,   447,   401,    -1,    13,    -1,  1078,    -1,    -1,
       6,   399,   931,  1141,  1072,  1073,    -1,    -1,   652,   898,
     653,    -1,   400,  1316,    -1,    -1,   449,   399,  1141,  1075,
    1076,    -1,    -1,    -1,  1078,  1077,   249,   652,   898,   653,
      -1,  1079,    -1,  1078,   654,  1079,    -1,  1498,    -1,  1082,
      -1,  1080,   654,  1082,    -1,     6,  1089,   931,    -1,  1081,
     948,  1097,    -1,     6,   949,    -1,  1081,   652,   945,   653,
      -1,    -1,    59,  1089,  1347,  1490,  1083,   958,  1097,    -1,
      -1,    -1,   341,  1089,  1347,  1490,  1084,   960,  1085,  1097,
      -1,   150,  1089,  1347,  1490,  1096,    -1,   150,   195,   262,
    1347,  1490,    -1,   150,   415,   262,    -1,   150,  1026,  1347,
    1490,    -1,   143,   260,    -1,   158,   260,    -1,    14,  1089,
    1490,   492,   132,  1480,    -1,    14,  1089,  1490,   150,   132,
      -1,   448,  1098,  1491,    -1,   101,   573,   992,   994,   999,
      -1,   933,    -1,   194,    -1,  1299,    -1,  1087,    -1,  1088,
      -1,    -1,  1088,    -1,  1087,    -1,  1088,  1087,    -1,  1087,
    1088,    -1,    12,  1369,   132,    -1,    12,  1369,  1498,    -1,
     285,  1369,   132,    -1,   285,  1369,  1498,    -1,    -1,    81,
      -1,    -1,   234,    -1,    -1,  1092,  1093,    -1,    -1,  1094,
      -1,  1094,  1095,    -1,  1095,    -1,   234,    -1,   378,    -1,
      -1,   460,    -1,    53,    -1,    -1,     9,  1498,    -1,   189,
      -1,    -1,   573,    -1,   166,    -1,    20,    -1,    -1,   529,
     502,   686,  1106,  1100,  1110,    -1,    -1,   529,    13,   503,
    1106,  1101,    -1,   536,   502,   686,  1106,    -1,   536,    13,
     503,  1106,    -1,   529,   575,  1103,    -1,    -1,  1104,    -1,
    1105,    -1,  1104,   654,  1105,    -1,   629,    92,   507,    -1,
     430,   377,    -1,   430,   634,    -1,    -1,  1107,  1108,    -1,
    1109,    -1,  1108,   654,  1109,    -1,    -1,   525,    -1,   444,
      -1,    -1,   599,  1111,    -1,   599,   296,   166,  1495,    -1,
     685,    -1,  1111,   654,   685,    -1,    -1,    64,  1534,  1113,
    1342,  1114,    -1,    -1,   426,    -1,   181,    -1,    -1,   450,
    1141,  1534,  1116,  1342,  1117,    -1,    -1,  1118,    -1,  1119,
      -1,  1119,  1118,    -1,   426,    -1,   181,    -1,   605,    -1,
      -1,    16,  1141,  1534,  1121,  1122,    -1,  1123,    -1,  1122,
     654,  1123,    -1,  1343,  1124,    -1,    -1,   403,   196,  1125,
      -1,    13,    -1,    75,  1126,   237,  1128,    -1,    13,    -1,
      -1,   652,  1127,  1130,   653,    -1,    13,    -1,    -1,   652,
    1129,  1131,   653,    -1,    -1,  1498,    -1,  1130,   654,  1498,
      -1,    -1,  1132,    -1,  1131,   654,  1132,    -1,  1498,    -1,
     415,    -1,    37,  1495,    -1,    -1,    65,  1534,  1135,  1342,
    1136,    -1,    -1,  1137,    -1,  1138,    -1,  1138,  1137,    -1,
     426,    -1,   185,    -1,   328,    -1,   181,    -1,    60,    -1,
     196,   601,    -1,    -1,   380,  1141,  1534,  1140,  1342,    -1,
      -1,   367,    -1,   282,    -1,    -1,   448,  1534,  1143,  1145,
      -1,   448,   603,   714,  1144,    -1,  1501,   573,  1501,    -1,
    1144,   654,  1501,   573,  1501,    -1,  1146,    -1,  1145,   654,
    1146,    -1,  1491,   573,  1491,    -1,    -1,    51,   238,  1148,
    1149,   252,  1153,    -1,  1150,    -1,  1152,    -1,  1151,    -1,
    1150,   654,  1151,    -1,  1491,  1162,    -1,  1491,  1160,  1162,
      -1,  1498,    -1,   132,    -1,    -1,   281,   238,   249,    51,
    1155,  1156,    -1,  1159,    -1,  1157,    -1,  1158,    -1,  1157,
     654,  1158,    -1,  1491,  1162,  1165,    -1,  1491,  1160,  1162,
    1165,    -1,    -1,   399,   875,  1161,   652,  1070,   653,    -1,
      -1,  1163,  1164,    -1,    -1,  1026,   652,  1281,   653,    -1,
      -1,   234,   269,    -1,  1167,    -1,   484,  1170,    -1,   652,
    1168,   653,  1597,    -1,   484,  1172,    -1,   652,  1168,   653,
      -1,   484,  1260,    -1,   652,  1169,   653,    -1,    -1,  1172,
    1171,  1594,    -1,    -1,    -1,  1173,  1177,  1181,  1174,  1175,
    1180,    -1,  1302,  1308,    -1,  1331,    -1,  1176,    -1,  1331,
    1176,    -1,  1176,  1331,    -1,   198,  1240,  1291,  1296,  1293,
    1302,  1308,  1322,    -1,   198,   151,  1291,  1308,    -1,    -1,
    1178,    -1,  1178,  1179,    -1,  1179,    -1,  1611,    -1,   522,
      -1,   520,    -1,    -1,   196,   600,    -1,   285,   252,   494,
     339,    -1,  1181,   654,  1182,    -1,  1182,    -1,   647,    -1,
    1183,  1485,  1184,    -1,  1183,  1189,  1184,  1185,    -1,    -1,
      -1,    -1,    20,  1498,    -1,    20,  1495,    -1,  1498,    -1,
    1495,    -1,    -1,   652,   653,    -1,   652,  1316,   653,    -1,
      -1,   652,   653,    -1,   652,  1316,   653,    -1,    -1,   652,
     653,    -1,  1189,  1193,  1189,    -1,  1189,   638,  1189,    -1,
    1189,  1194,  1189,    -1,   363,  1189,    -1,  1190,   255,   580,
      -1,  1190,   255,  1195,   580,    -1,  1190,   255,   184,    -1,
    1190,   255,  1195,   184,    -1,  1190,   255,   596,    -1,  1190,
     255,  1195,   596,    -1,  1190,    -1,  1190,   255,   368,    -1,
    1190,   255,  1195,   368,    -1,  1190,   167,  1191,    -1,  1190,
    1197,  1191,    -1,  1190,  1197,  1198,   652,  1606,   653,    -1,
    1191,    -1,  1192,   252,   652,  1606,   653,    -1,  1192,  1195,
     252,   652,  1606,   653,    -1,  1192,   252,   652,  1189,   653,
      -1,  1192,   252,   652,  1189,   654,  1233,   653,    -1,  1192,
    1195,   252,   652,  1189,   653,    -1,  1192,  1195,   252,   652,
    1189,   654,  1233,   653,    -1,  1192,    34,  1192,    18,  1191,
      -1,  1192,  1195,    34,  1192,    18,  1191,    -1,  1192,   511,
     275,  1192,    -1,  1192,   275,  1203,  1295,    -1,  1192,  1195,
     275,  1203,  1295,    -1,  1192,   439,  1192,    -1,  1192,  1195,
     439,  1192,    -1,  1192,    -1,  1192,   643,  1192,    -1,  1192,
     644,  1192,    -1,  1192,   495,  1192,    -1,  1192,   496,  1192,
      -1,  1192,   646,  1192,    -1,  1192,   645,  1192,    -1,  1192,
     646,   248,  1189,  1285,    -1,  1192,   645,   248,  1189,  1285,
      -1,  1192,   647,  1192,    -1,  1192,   648,  1192,    -1,  1192,
     649,  1192,    -1,  1192,   147,  1192,    -1,  1192,   342,  1192,
      -1,  1192,   650,  1192,    -1,  1203,    -1,   387,    -1,   384,
      -1,    18,    -1,    17,    -1,   363,    -1,   362,    -1,   655,
      -1,   362,    -1,   166,    -1,   202,    -1,   214,    -1,   267,
      -1,   294,    -1,   356,    -1,    13,    -1,    19,    -1,    -1,
      20,  1200,    -1,   250,    -1,   598,   250,    -1,   148,    -1,
     432,    -1,   192,    -1,   130,   978,    -1,   972,  1004,    -1,
     973,    -1,   122,    -1,   569,   984,    -1,   119,   984,    -1,
    1189,   654,  1189,  1199,    -1,  1201,    -1,  1202,   654,  1201,
      -1,  1487,    -1,  1204,    -1,  1205,    -1,  1208,    -1,  1206,
      -1,  1203,    73,  1500,    -1,  1481,    -1,  1479,    -1,  1220,
      -1,  1216,    -1,  1203,   386,  1203,    -1,   646,  1203,    -1,
     645,  1203,    -1,   651,  1203,    -1,  1196,  1203,    -1,   652,
    1606,   653,    -1,   652,  1189,   653,    -1,   652,  1189,   654,
    1233,   653,    -1,   475,   652,  1189,   654,  1233,   653,    -1,
     178,   652,  1606,   653,    -1,   656,  1498,  1189,   657,    -1,
     316,  1234,    10,   652,  1192,  1210,   653,    -1,    36,  1203,
      -1,    56,   652,  1189,    20,  1230,   653,    -1,    55,  1236,
    1238,  1237,   160,    -1,   101,   652,  1189,   654,  1230,   653,
      -1,   101,   652,  1189,   607,   993,   653,    -1,   132,   652,
    1487,   653,    -1,   611,   652,  1488,   653,    -1,   248,  1189,
    1285,   646,  1189,    -1,    62,   652,  1233,   653,    -1,    62,
     652,  1233,   607,   993,   653,    -1,   109,  1188,    -1,   110,
    1188,    -1,   122,   652,  1189,   653,    -1,   127,   652,  1189,
     653,    -1,   228,   652,  1189,   653,    -1,   245,   652,  1189,
     654,  1189,   654,  1189,   654,  1189,   653,    -1,   248,   652,
    1189,   654,  1189,   653,    -1,   248,   652,  1189,   654,  1189,
     654,  1233,   653,    -1,   271,   652,  1189,   654,  1189,   653,
      -1,   336,   652,  1189,   653,    -1,   343,   652,  1189,   653,
      -1,   468,   652,  1189,   654,  1189,   653,    -1,   482,   652,
    1189,   653,    -1,   569,   652,  1189,   653,    -1,   566,   652,
    1189,   653,    -1,   566,   652,  1189,   654,  1189,   653,    -1,
     579,   652,  1189,   653,    -1,   579,   652,   268,  1189,   198,
    1189,   653,    -1,   579,   652,   574,  1189,   198,  1189,   653,
      -1,   579,   652,    47,  1189,   198,  1189,   653,    -1,   579,
     652,   268,   198,  1189,   653,    -1,   579,   652,   574,   198,
    1189,   653,    -1,   579,   652,    47,   198,  1189,   653,    -1,
     579,   652,  1189,   198,  1189,   653,    -1,   603,   652,   653,
      -1,   640,   652,  1189,   653,    -1,     8,   652,  1189,   654,
    1189,   653,    -1,     8,   652,  1189,   654,   248,  1189,  1285,
     653,    -1,   107,  1188,    -1,   114,  1187,    -1,   120,   652,
    1189,   654,   248,  1189,  1285,   653,    -1,   121,   652,  1189,
     654,   248,  1189,  1285,   653,    -1,   183,   652,  1285,   198,
    1189,   653,    -1,   207,   652,  1287,   654,  1189,   653,    -1,
     364,  1187,    -1,   410,   652,  1192,   252,  1189,   653,    -1,
     541,   652,  1189,   654,  1189,   653,    -1,   541,   652,  1189,
     654,   248,  1189,  1285,   653,    -1,   545,   652,  1189,   654,
    1189,   654,  1189,   653,    -1,   545,   652,  1189,   654,  1189,
     653,    -1,   545,   652,  1189,   198,  1189,   196,  1189,   653,
      -1,   545,   652,  1189,   198,  1189,   653,    -1,   551,  1187,
      -1,   567,   652,  1286,   654,  1189,   654,  1189,   653,    -1,
     568,   652,  1286,   654,  1189,   654,  1189,   653,    -1,   608,
    1188,    -1,   610,  1187,    -1,   609,  1187,    -1,    76,   652,
    1189,   654,  1202,   653,    -1,    79,   652,  1189,   654,  1233,
     653,    -1,    77,   652,  1189,   653,    -1,    78,   652,  1202,
     653,    -1,    80,   652,  1189,   654,  1189,    20,  1230,   653,
      -1,    22,   652,  1189,   653,    -1,    61,   652,  1189,   653,
      -1,    71,   652,  1233,   653,    -1,    74,   652,  1189,   653,
      -1,   115,   652,   653,    -1,   233,   652,  1189,   654,  1189,
     654,  1189,   653,    -1,   266,   652,  1233,   653,    -1,   332,
     652,  1189,   653,    -1,   342,   652,  1189,   654,  1189,   653,
      -1,   374,   652,  1189,   653,    -1,   402,   652,  1189,   653,
      -1,   424,   652,  1189,   653,    -1,   452,   652,  1189,   654,
    1189,   653,    -1,   453,   652,  1189,   654,  1189,   654,  1189,
     653,    -1,   466,   652,  1189,   653,    -1,   476,   652,   653,
      -1,   581,   652,  1189,   654,  1189,   653,    -1,   624,   652,
    1189,   653,    -1,   624,   652,  1189,   654,  1189,   653,    -1,
     625,   652,  1189,  1016,   653,    -1,   625,   652,  1189,    20,
      62,  1006,  1016,   653,    -1,   625,   652,  1189,    20,    36,
    1006,   653,    -1,   625,   652,  1189,   654,  1315,   654,  1315,
     654,  1315,   653,    -1,  1207,    -1,    97,   652,  1189,   654,
    1189,   653,    -1,   205,   652,  1233,   653,    -1,   279,   652,
    1233,   653,    -1,   344,   652,  1233,   653,    -1,   345,   652,
    1233,   653,    -1,   346,   652,  1233,   653,    -1,   407,   652,
    1189,   654,  1189,   653,    -1,   408,   652,  1233,   653,    -1,
      -1,  1494,   652,  1209,  1213,   653,    -1,  1498,   660,  1498,
     652,  1232,   653,    -1,  1211,  1212,    -1,   252,    45,   339,
      -1,    -1,   252,   352,   264,   339,    -1,    -1,   629,   425,
     180,    -1,    -1,  1214,    -1,  1215,    -1,  1214,   654,  1215,
      -1,  1183,  1189,  1184,  1185,    -1,    30,   652,  1228,   653,
      -1,    30,   652,   146,  1228,   653,    -1,    39,   652,  1228,
     653,    -1,    40,   652,  1228,   653,    -1,    42,   652,  1228,
     653,    -1,   102,   652,  1290,   647,   653,    -1,   102,   652,
    1228,   653,    -1,    -1,    -1,   102,   652,   146,  1217,  1233,
    1218,   653,    -1,   338,   652,  1228,   653,    -1,   338,   652,
     146,  1228,   653,    -1,   321,   652,  1228,   653,    -1,   321,
     652,   146,  1228,   653,    -1,   535,   652,  1228,   653,    -1,
     616,   652,  1228,   653,    -1,   534,   652,  1228,   653,    -1,
     618,   652,  1228,   653,    -1,   546,   652,  1228,   653,    -1,
     546,   652,   146,  1228,   653,    -1,    -1,   213,   652,  1223,
    1219,  1233,  1225,  1224,   653,    -1,    -1,   659,  1221,  1222,
      -1,  1500,   493,  1189,    -1,  1500,    -1,   659,  1521,  1500,
    1050,    -1,    -1,   146,    -1,    -1,   486,  1478,    -1,    -1,
      -1,   385,    49,  1226,  1227,    -1,  1227,   654,  1486,  1306,
      -1,  1486,  1306,    -1,    -1,  1290,  1229,  1189,    -1,    36,
     984,    -1,    62,   984,  1004,    -1,   354,   984,    -1,   250,
      -1,   500,    -1,   500,   250,    -1,   598,    -1,   598,   250,
      -1,   122,    -1,   569,   984,    -1,   119,   984,    -1,   130,
     978,    -1,    -1,   148,  1231,   985,    -1,    -1,  1233,    -1,
    1189,    -1,  1233,   654,  1189,    -1,  1235,    -1,   652,  1235,
     653,    -1,  1487,    -1,  1235,   654,  1487,    -1,    -1,  1189,
      -1,    -1,   156,  1189,    -1,   626,  1189,   565,  1189,    -1,
    1238,   626,  1189,   565,  1189,    -1,  1254,    -1,  1243,    -1,
    1242,    -1,  1239,    -1,   656,  1498,  1239,   657,    -1,  1241,
      -1,  1242,   654,  1241,    -1,  1239,  1251,  1239,    -1,    -1,
    1239,  1251,  1239,   375,  1244,  1189,    -1,    -1,  1239,  1251,
    1239,   607,  1245,   652,  1284,   653,    -1,  1239,   352,  1250,
    1254,    -1,    -1,  1239,   271,  1270,   259,  1239,   375,  1246,
    1189,    -1,    -1,  1239,   271,  1270,   259,  1254,  1247,   607,
     652,  1284,   653,    -1,  1239,   352,   271,  1270,   259,  1254,
      -1,    -1,  1239,   468,  1270,   259,  1239,   375,  1248,  1189,
      -1,    -1,  1239,   468,  1270,   259,  1254,  1249,   607,   652,
    1284,   653,    -1,  1239,   352,   468,  1270,   259,  1254,    -1,
     259,    -1,   242,   259,    -1,   538,    -1,  1250,    -1,   105,
     259,    -1,    -1,  1253,    -1,   399,   652,  1284,   653,   875,
      -1,    -1,  1255,  1491,  1252,  1289,  1279,    -1,  1269,  1268,
    1265,    -1,   652,  1268,  1256,   653,  1289,    -1,  1263,  1598,
      -1,    -1,    -1,  1256,   594,  1602,  1257,  1603,  1258,  1598,
      -1,  1260,    -1,    -1,    -1,  1261,  1609,  1181,  1262,   943,
    1180,    -1,    -1,  1268,  1264,  1242,    -1,    -1,    -1,  1266,
    1177,  1181,  1267,   943,    -1,    -1,   484,    -1,    -1,   388,
      -1,    -1,   196,   259,    -1,   196,   385,    49,    -1,   196,
     212,    49,    -1,   194,    -1,   234,    -1,    -1,  1272,  1026,
    1271,  1274,   652,  1283,   653,    -1,    -1,   606,  1026,  1271,
    1275,   652,  1281,   653,    -1,  1273,    -1,  1276,  1273,    -1,
      -1,    -1,  1278,  1276,    -1,    -1,  1280,  1277,    -1,    -1,
    1283,    -1,  1498,    -1,   415,    -1,  1282,    -1,  1283,   654,
    1282,    -1,  1498,    -1,  1284,   654,  1498,    -1,  1286,    -1,
     123,    -1,   124,    -1,   125,    -1,   126,    -1,   225,    -1,
     226,    -1,   227,    -1,   334,    -1,   335,    -1,   481,    -1,
     639,    -1,   127,    -1,   624,    -1,   228,    -1,   336,    -1,
     343,    -1,   424,    -1,   482,    -1,   332,    -1,   640,    -1,
     122,    -1,   569,    -1,   119,    -1,   566,    -1,    -1,    20,
      -1,   166,    -1,    -1,  1288,  1498,    -1,    -1,    13,    -1,
      -1,    -1,   627,  1292,  1189,    -1,    -1,    -1,   218,  1294,
    1189,    -1,   171,  1203,    -1,    -1,    -1,   212,    49,  1297,
    1298,    -1,  1297,   654,  1486,  1306,    -1,  1486,  1306,    -1,
      -1,   630,    -1,   631,    -1,   385,    49,  1300,    -1,  1300,
     654,  1301,    -1,  1301,    -1,  1488,  1306,    -1,    -1,  1303,
      -1,    -1,   385,    49,  1304,  1305,    -1,  1305,   654,  1486,
    1306,    -1,  1486,  1306,    -1,    -1,    21,    -1,   137,    -1,
      -1,  1309,    -1,    -1,  1309,    -1,   276,  1310,    -1,   276,
    1310,   473,   176,  1312,    -1,   276,   473,   176,  1312,    -1,
    1311,    -1,  1311,   654,  1311,    -1,  1311,   373,  1311,    -1,
    1498,    -1,  1479,    -1,   585,    -1,   290,    -1,   369,    -1,
    1311,    -1,    -1,   276,  1311,    -1,   276,   473,   176,    -1,
     276,  1311,   473,   176,    -1,   369,    -1,   645,   369,    -1,
     645,   290,    -1,   369,    -1,   220,    -1,   290,    -1,   585,
      -1,   129,    -1,   191,    -1,   369,    -1,   220,    -1,   290,
      -1,   585,    -1,  1319,    -1,   369,    -1,   585,    -1,   290,
      -1,   129,    -1,   191,    -1,   369,    -1,   585,    -1,   220,
      -1,   290,    -1,  1319,    -1,  1320,    -1,   129,    -1,   191,
      -1,  1315,    -1,   132,    -1,    -1,    -1,   417,  1498,  1323,
     652,  1324,   653,    -1,    -1,  1325,    -1,  1325,   654,  1326,
      -1,  1326,    -1,  1183,  1189,  1184,    -1,    -1,  1328,  1329,
      -1,  1329,   654,  1330,    -1,  1330,    -1,   659,  1500,    -1,
    1500,    -1,    -1,   249,  1332,  1333,    -1,    -1,    -1,   389,
    1497,  1334,   995,  1335,  1462,  1465,    -1,   152,  1497,    -1,
    1327,    -1,    -1,   149,  1337,  1233,    -1,    -1,   150,  1348,
    1534,  1347,  1339,  1342,  1096,    -1,    -1,   150,   238,  1347,
    1498,   375,  1491,  1340,    -1,   150,   115,  1347,  1498,    -1,
     150,   201,  1347,  1498,   660,  1498,    -1,   150,   201,  1347,
    1498,    -1,   150,   417,  1347,   715,    -1,   150,   603,   714,
    1570,    -1,   150,   469,   714,  1554,    -1,    -1,   150,   620,
    1347,  1341,  1342,  1096,    -1,   150,   173,  1347,   715,    -1,
     150,   578,  1347,   715,    -1,   150,   553,   849,   860,   861,
      -1,   150,   286,   212,   850,   860,   861,    -1,   150,   490,
    1347,  1500,    -1,  1343,    -1,  1342,   654,  1343,    -1,  1491,
      -1,  1491,  1252,    -1,  1346,    -1,  1345,   654,  1346,    -1,
    1492,    -1,    -1,   233,   178,    -1,    -1,   559,    -1,    -1,
      -1,   245,  1350,  1355,  1090,  1357,  1351,  1359,  1375,    -1,
      -1,    -1,   453,  1353,  1356,  1357,  1354,  1359,    -1,    -1,
     293,    -1,   134,    -1,   222,    -1,  1384,    -1,   134,    -1,
     249,  1358,    -1,  1358,    -1,  1344,    -1,  1362,    -1,   652,
     653,  1362,    -1,   652,  1361,   653,  1362,    -1,    -1,   492,
    1360,  1366,    -1,  1361,   654,  1484,    -1,  1484,    -1,   611,
    1365,    -1,   612,  1365,    -1,    -1,   921,  1363,  1594,    -1,
      -1,   652,   921,   653,  1364,  1597,    -1,  1365,   654,  1370,
      -1,  1370,    -1,  1366,   654,  1367,    -1,  1367,    -1,  1488,
    1368,  1374,    -1,   166,    -1,   493,    -1,    -1,  1368,    -1,
      -1,   652,  1371,  1372,   653,    -1,    -1,  1373,    -1,  1373,
     654,  1374,    -1,  1374,    -1,  1189,    -1,   132,    -1,    -1,
      -1,   375,   153,  1376,   262,   600,  1382,    -1,    -1,    -1,
     600,  1378,  1384,  1090,  1240,   492,  1380,  1379,  1291,  1302,
    1313,    -1,  1380,   654,  1381,    -1,  1381,    -1,  1488,  1368,
    1374,    -1,  1382,   654,  1383,    -1,  1383,    -1,  1488,  1368,
    1374,    -1,    -1,   293,    -1,    -1,   136,  1386,  1396,  1387,
      -1,    -1,    -1,   198,  1491,  1252,  1388,  1291,  1302,  1313,
    1389,  1392,    -1,    -1,  1393,  1390,   198,  1240,  1291,    -1,
      -1,   198,  1345,  1391,   607,  1240,  1291,    -1,    -1,   463,
    1181,    -1,  1394,    -1,  1393,   654,  1394,    -1,  1498,  1395,
      -1,  1498,   660,  1498,  1395,    -1,    -1,   660,   647,    -1,
      -1,  1397,  1396,    -1,   426,    -1,   293,    -1,   234,    -1,
      -1,   581,  1400,  1399,  1343,    -1,    -1,   556,    -1,    -1,
    1402,    -1,  1403,    -1,  1402,   654,  1403,    -1,   103,    -1,
     329,    -1,    44,   253,    -1,    98,   550,    -1,   393,   186,
      -1,   254,    -1,   549,    -1,   512,    -1,    13,    -1,    -1,
     196,   425,   369,    -1,    -1,   497,  1406,  1407,    -1,   116,
    1418,    -1,  1414,   552,  1413,  1418,    -1,  1414,   577,  1413,
    1418,    -1,   172,  1413,  1418,    -1,   556,   533,  1413,  1418,
      -1,   379,   552,  1413,  1418,    -1,   405,    -1,   405,   510,
    1495,    -1,   405,   510,  1418,    -1,   164,   940,  1410,    -1,
     164,    13,  1410,    -1,  1414,    75,  1415,  1491,  1413,  1418,
      -1,  1411,   287,    -1,   502,   224,    -1,    -1,    37,   172,
    1416,  1417,  1408,  1307,    -1,    -1,   441,   686,   172,  1416,
    1417,  1409,  1307,    -1,  1028,  1415,  1491,  1413,  1291,    -1,
    1412,   163,    -1,    25,    -1,   100,    -1,   416,    -1,   102,
     652,   647,   653,   623,    -1,   102,   652,   647,   653,   169,
      -1,   623,  1307,    -1,   169,  1307,    -1,   421,    -1,   420,
    1401,  1404,  1307,    -1,  1520,   533,  1418,    -1,  1414,   419,
      -1,  1520,   615,  1418,    -1,   992,  1418,    -1,    74,  1418,
      -1,   211,    -1,   211,   196,  1502,    -1,   104,   115,   931,
    1498,    -1,   104,   556,  1491,    -1,   104,   620,  1491,    -1,
     312,   533,    -1,    13,   503,   533,    -1,   502,   533,    -1,
     502,   687,   533,    -1,    69,    -1,   604,    -1,   555,    -1,
     239,    -1,   104,   417,   715,    -1,   104,   201,   715,    -1,
     104,   578,   715,    -1,   417,   533,  1418,    -1,   201,   533,
    1418,    -1,   417,    72,   715,    -1,   201,    72,   715,    -1,
     104,   173,   715,    -1,  1423,   196,  1189,    -1,   533,    -1,
     347,    -1,   287,    -1,   312,    -1,    36,    -1,    -1,   537,
      -1,    -1,  1415,  1498,    -1,    -1,   199,    -1,   198,    -1,
     252,    -1,    -1,   252,  1495,    -1,    -1,   198,  1317,    -1,
      -1,   275,  1495,    -1,   627,  1189,    -1,    -1,  1423,  1491,
    1420,  1425,    -1,    -1,  1423,  1424,  1421,  1422,    -1,  1166,
      -1,  1349,    -1,  1352,    -1,  1377,    -1,  1385,    -1,   137,
      -1,   138,    -1,    -1,   181,    -1,   400,    -1,    -1,  1478,
      -1,  1498,    -1,    -1,   193,  1141,  1427,  1428,    -1,    -1,
      -1,  1534,  1429,  1434,  1430,  1431,    -1,  1432,    -1,    -1,
     629,   430,   285,  1435,    -1,  1432,   654,  1433,    -1,  1433,
      -1,   168,   287,    -1,   164,   287,    -1,   203,   287,    -1,
     505,   287,    -1,    36,   287,    -1,   440,   287,   686,    -1,
     425,    51,    -1,   224,    -1,   416,    -1,   287,    -1,   533,
      -1,   502,   686,    -1,    69,    -1,   604,    -1,   555,    -1,
     239,    -1,   312,    -1,   139,    -1,   458,    -1,    -1,  1342,
      -1,    -1,    18,   143,    63,    -1,    -1,   456,  1437,  1438,
      -1,  1438,   654,  1439,    -1,  1439,    -1,    -1,   502,  1440,
     686,  1441,    -1,   312,    -1,   425,    51,    -1,    -1,    13,
      -1,    -1,   423,  1443,  1444,    -1,  1411,   287,  1445,    -1,
     573,  1495,    -1,    32,  1189,    -1,    -1,   263,  1447,  1448,
    1449,  1450,    -1,    -1,   216,    -1,   509,    -1,    -1,    91,
      -1,   425,    -1,   425,   229,    -1,  1189,    -1,   603,  1501,
      -1,   498,    -1,   606,  1498,    -1,    -1,    -1,    -1,    -1,
     281,  1458,  1454,  1460,  1459,   240,  1497,  1455,  1461,   249,
     556,  1491,  1252,  1456,   995,  1457,  1468,  1462,  1465,  1469,
    1471,  1474,    -1,   118,    -1,   637,    -1,    -1,   282,    -1,
      -1,    89,    -1,   293,    -1,    -1,   453,    -1,   234,    -1,
      -1,    75,  1463,    -1,  1463,  1464,    -1,  1464,    -1,   561,
      49,  1478,    -1,   383,   159,    49,  1478,    -1,   159,    49,
    1478,    -1,   170,    49,  1478,    -1,    -1,   278,  1466,    -1,
    1466,  1467,    -1,  1467,    -1,   561,    49,  1478,    -1,   527,
      49,  1478,    -1,    -1,   473,   231,    49,  1478,    -1,    -1,
     234,   369,  1470,    -1,   278,    -1,   473,    -1,    -1,   652,
    1472,   653,    -1,   652,   653,    -1,  1472,   654,  1473,    -1,
    1473,    -1,  1488,    -1,   659,  1500,    -1,    -1,   492,  1475,
      -1,  1475,   654,  1476,    -1,  1476,    -1,  1488,  1368,  1183,
    1374,  1184,    -1,   562,    -1,   353,    -1,   588,   562,    -1,
    1477,  1496,    -1,  1496,    -1,   220,    -1,   221,    -1,    38,
      -1,   395,    -1,  1481,    -1,   646,  1482,    -1,   645,  1482,
      -1,  1477,    -1,  1482,    -1,  1483,    -1,   368,    -1,   184,
      -1,   580,    -1,   220,    -1,   221,    -1,    38,    -1,   588,
     991,    -1,   588,    38,    -1,   369,    -1,   290,    -1,   585,
      -1,   129,    -1,   191,    -1,   122,   562,    -1,   569,   562,
      -1,   566,   562,    -1,  1488,    -1,  1485,    -1,  1498,   660,
     647,    -1,  1498,   660,  1498,   660,   647,    -1,  1189,    -1,
    1498,    -1,  1489,    -1,  1498,    -1,  1489,    -1,  1498,   660,
    1498,    -1,   660,  1498,   660,  1498,    -1,  1498,   660,  1498,
     660,  1498,    -1,  1498,    -1,  1498,   660,  1498,   660,  1498,
      -1,  1498,   660,  1498,    -1,   660,  1498,    -1,  1498,    -1,
    1498,   660,  1498,    -1,   660,  1498,    -1,  1498,  1395,    -1,
    1498,   660,  1498,  1395,    -1,  1498,    -1,   230,    -1,   232,
      -1,   562,    -1,   562,    -1,   562,    -1,  1494,    -1,  1503,
      -1,  1494,    -1,  1504,    -1,  1498,    -1,  1495,    -1,   274,
      -1,  1500,    -1,  1500,   659,  1500,    -1,   109,  1188,    -1,
    1501,    -1,  1555,    -1,  1504,    -1,    22,    -1,    31,    -1,
      33,    -1,    50,    -1,    51,    -1,    61,    -1,    64,    -1,
      63,    -1,    70,    -1,    76,    -1,    77,    -1,    78,    -1,
      79,    -1,    80,    -1,    83,    -1,    85,    -1,    97,    -1,
     128,    -1,   149,    -1,   160,    -1,   176,    -1,   177,    -1,
     193,    -1,   208,    -1,   215,    -1,   219,    -1,   223,    -1,
     247,    -1,   264,    -1,   365,    -1,   379,    -1,   382,    -1,
     381,    -1,   391,    -1,   396,    -1,   409,    -1,   412,    -1,
     447,    -1,   450,    -1,   456,    -1,   459,    -1,   470,    -1,
     478,    -1,   483,    -1,   490,    -1,   498,    -1,   500,    -1,
     508,    -1,   502,    -1,   503,    -1,   510,    -1,   529,    -1,
     536,    -1,   581,    -1,   592,    -1,   593,    -1,   633,    -1,
     636,    -1,   601,    -1,     5,    -1,     8,    -1,     7,    -1,
       9,    -1,    10,    -1,    11,    -1,    12,    -1,    15,    -1,
      19,    -1,    24,    -1,    25,    -1,    27,    -1,    26,    -1,
      28,    -1,    29,    -1,    30,    -1,    37,    -1,    41,    -1,
      44,    -1,    46,    -1,    45,    -1,    48,    -1,    54,    -1,
      57,    -1,    58,    -1,    60,    -1,    66,    -1,    69,    -1,
      68,    -1,    67,    -1,    71,    -1,    72,    -1,    74,    -1,
      82,    -1,    75,    -1,    84,    -1,    86,    -1,    87,    -1,
      88,    -1,    89,    -1,    91,    -1,    92,    -1,    94,    -1,
      96,    -1,    95,    -1,    98,    -1,   100,    -1,   111,    -1,
     103,    -1,   106,    -1,   108,    -1,   113,    -1,   118,    -1,
     117,    -1,   119,    -1,   122,    -1,   127,    -1,   133,    -1,
     135,    -1,   139,    -1,   141,    -1,   142,    -1,   143,    -1,
     144,    -1,   145,    -1,   152,    -1,   153,    -1,   154,    -1,
     161,    -1,   165,    -1,   164,    -1,   163,    -1,   168,    -1,
     169,    -1,   171,    -1,   173,    -1,   172,    -1,   174,    -1,
     175,    -1,   180,    -1,   181,    -1,   182,    -1,   186,    -1,
     185,    -1,   197,    -1,   158,    -1,   199,    -1,   188,    -1,
     189,    -1,   190,    -1,   203,    -1,   204,    -1,   206,    -1,
     205,    -1,   207,    -1,   211,    -1,   209,    -1,   217,    -1,
     216,    -1,   224,    -1,   228,    -1,   229,    -1,   231,    -1,
     235,    -1,   239,    -1,   251,    -1,   236,    -1,   237,    -1,
     241,    -1,   253,    -1,   254,    -1,   256,    -1,   257,    -1,
     246,    -1,   261,    -1,   266,    -1,   265,    -1,   269,    -1,
     272,    -1,   273,    -1,   279,    -1,   280,    -1,   282,    -1,
     284,    -1,   286,    -1,   287,    -1,   319,    -1,   312,    -1,
     315,    -1,   296,    -1,   297,    -1,   301,    -1,   298,    -1,
     299,    -1,   313,    -1,   314,    -1,   300,    -1,   302,    -1,
     295,    -1,   310,    -1,   304,    -1,   303,    -1,   305,    -1,
     306,    -1,   307,    -1,   308,    -1,   309,    -1,   317,    -1,
     318,    -1,   320,    -1,   322,    -1,   323,    -1,   328,    -1,
     329,    -1,   330,    -1,   331,    -1,   332,    -1,   333,    -1,
     336,    -1,   337,    -1,   341,    -1,   339,    -1,   343,    -1,
     344,    -1,   345,    -1,   346,    -1,   347,    -1,   348,    -1,
     350,    -1,   349,    -1,   351,    -1,   354,    -1,   355,    -1,
     359,    -1,   358,    -1,   366,    -1,   360,    -1,   361,    -1,
     370,    -1,   372,    -1,   373,    -1,   374,    -1,   376,    -1,
     378,    -1,   377,    -1,   392,    -1,   393,    -1,   398,    -1,
     401,    -1,   400,    -1,   402,    -1,   403,    -1,   404,    -1,
     406,    -1,   405,    -1,   407,    -1,   408,    -1,   413,    -1,
     414,    -1,   416,    -1,   418,    -1,   419,    -1,   420,    -1,
     421,    -1,   422,    -1,   424,    -1,   425,    -1,   426,    -1,
     429,    -1,   433,    -1,   434,    -1,   436,    -1,   435,    -1,
     437,    -1,   440,    -1,   441,    -1,   442,    -1,   443,    -1,
     444,    -1,   446,    -1,   449,    -1,   451,    -1,   454,    -1,
     458,    -1,   461,    -1,   462,    -1,   464,    -1,   466,    -1,
     469,    -1,   471,    -1,   472,    -1,   473,    -1,   476,    -1,
     474,    -1,   475,    -1,   477,    -1,   479,    -1,   480,    -1,
     482,    -1,   488,    -1,   487,    -1,   489,    -1,   501,    -1,
     494,    -1,   504,    -1,   505,    -1,   507,    -1,   509,    -1,
     511,    -1,   512,    -1,   520,    -1,   519,    -1,   522,    -1,
     525,    -1,   528,    -1,   533,    -1,   537,    -1,   539,    -1,
     540,    -1,   541,    -1,   542,    -1,   544,    -1,   543,    -1,
     547,    -1,   548,    -1,   549,    -1,   550,    -1,   558,    -1,
     555,    -1,   552,    -1,   557,    -1,   553,    -1,   559,    -1,
     560,    -1,   563,    -1,   564,    -1,   575,    -1,   576,    -1,
     577,    -1,   566,    -1,   567,    -1,   568,    -1,   569,    -1,
     582,    -1,   583,    -1,   584,    -1,   201,    -1,   586,    -1,
     587,    -1,   590,    -1,   589,    -1,   596,    -1,   599,    -1,
     603,    -1,   604,    -1,   605,    -1,   615,    -1,   620,    -1,
     621,    -1,   612,    -1,   623,    -1,   622,    -1,   624,    -1,
     625,    -1,   632,    -1,   635,    -1,   637,    -1,   640,    -1,
     619,    -1,    -1,   492,  1506,  1507,    -1,    -1,  1523,  1508,
    1513,    -1,    -1,   575,  1509,  1525,    -1,    -1,  1519,  1510,
    1511,    -1,    -1,  1522,  1512,  1513,    -1,   575,  1525,    -1,
      -1,   654,  1514,    -1,    -1,  1515,  1517,    -1,    -1,  1514,
     654,  1516,  1517,    -1,    -1,  1519,  1518,  1522,    -1,  1523,
      -1,   209,    -1,   282,    -1,   489,    -1,    -1,   209,    -1,
     282,    -1,   489,    -1,    -1,   209,   660,    -1,   282,   660,
      -1,   489,   660,    -1,  1524,  1368,  1531,    -1,  1524,  1368,
    1531,    -1,   659,  1500,  1368,  1189,    -1,   659,   659,  1521,
    1524,  1368,  1531,    -1,   992,   997,    -1,   349,  1368,  1189,
      -1,   349,   994,   999,    -1,   469,  1500,    -1,   402,  1368,
    1530,    -1,   402,   196,  1501,  1368,  1530,    -1,  1498,    -1,
    1498,   660,  1498,    -1,   132,   660,  1498,    -1,  1526,    -1,
    1527,    -1,  1526,   654,  1527,    -1,  1527,   654,  1526,    -1,
    1528,    -1,   256,   273,  1529,    -1,   430,   377,    -1,   430,
     634,    -1,   430,   586,    -1,   430,    84,    -1,   451,   430,
      -1,   487,    -1,   562,    -1,   402,   652,   562,   653,    -1,
     374,   652,   562,   653,    -1,  1189,    -1,   132,    -1,   375,
      -1,    13,    -1,    36,    -1,    -1,   285,  1534,  1533,  1535,
      -1,   556,    -1,   552,    -1,  1536,    -1,  1535,   654,  1536,
      -1,  1491,  1289,  1537,    -1,   430,    -1,   634,    -1,   634,
      89,    -1,   293,   634,    -1,   430,   282,    -1,    -1,   597,
    1539,  1534,    -1,   215,  1491,   379,  1289,    -1,   215,  1493,
      70,    -1,    -1,   215,  1493,   430,  1541,  1542,  1291,  1308,
      -1,  1543,    -1,  1498,  1544,    -1,   189,    -1,   359,    -1,
     189,    -1,   359,    -1,   414,    -1,   265,    -1,    -1,  1546,
    1545,   652,  1373,   653,    -1,   166,    -1,   202,    -1,   267,
      -1,   214,    -1,   294,    -1,   467,   714,  1548,    -1,  1558,
     375,  1557,  1569,   198,  1572,    -1,  1558,   375,   201,  1569,
     198,  1572,    -1,  1558,   375,   417,  1569,   198,  1572,    -1,
      13,  1559,   654,   210,   382,   198,  1572,    -1,   422,   375,
    1501,   198,  1570,    -1,  1549,   198,  1572,    -1,     7,   382,
     196,  1556,    -1,  1556,    -1,   210,   714,  1551,    -1,  1558,
     375,  1557,  1569,   573,  1571,  1579,  1580,    -1,  1558,   375,
     201,  1569,   573,  1571,  1579,  1580,    -1,  1558,   375,   417,
    1569,   573,  1571,  1579,  1580,    -1,   422,   375,  1501,   573,
    1571,  1581,    -1,  1556,   573,  1571,  1553,    -1,    -1,   629,
       7,  1502,    -1,    -1,   629,     7,   382,    -1,  1556,    -1,
    1554,   654,  1556,    -1,   110,  1188,    -1,  1500,    -1,  1555,
      -1,    -1,   556,    -1,  1560,    -1,    13,  1559,    -1,    -1,
     416,    -1,  1561,    -1,  1560,   654,  1561,    -1,    -1,   484,
    1562,  1576,    -1,    -1,   245,  1563,  1576,    -1,    -1,   600,
    1564,  1576,    -1,    -1,   438,  1565,  1576,    -1,   136,    -1,
     602,    -1,   238,    -1,    14,    -1,   104,    -1,   150,    -1,
     177,    -1,   446,    -1,   498,    -1,   418,    -1,   188,    -1,
     210,   382,    -1,   497,   116,    -1,   547,    -1,   104,   559,
     552,    -1,   285,   552,    -1,   454,   502,    -1,   454,    68,
      -1,   104,   620,    -1,   497,   620,    -1,   104,   472,    -1,
      14,   472,    -1,   104,   603,    -1,   173,    -1,   578,    -1,
     104,   553,    -1,    -1,    18,    -1,  1568,  1566,  1567,    -1,
    1568,    -1,   542,   562,    -1,   257,   562,    -1,    66,   562,
      -1,   647,    -1,  1498,   660,   647,    -1,   647,   660,   647,
      -1,  1491,    -1,  1501,    -1,  1570,   654,  1501,    -1,  1575,
      -1,  1571,   654,  1575,    -1,  1502,    -1,  1572,   654,  1502,
      -1,   619,    -1,   629,    -1,   607,    -1,    20,    -1,  1501,
     231,    49,   562,    -1,  1501,   231,    49,   402,   562,    -1,
    1501,   231,  1573,  1500,    -1,  1501,   231,  1573,  1500,  1574,
    1495,    -1,  1502,    -1,    -1,   652,  1577,   653,    -1,  1577,
     654,  1578,    -1,  1578,    -1,  1498,    -1,    -1,   455,  1567,
      -1,   455,   526,    -1,   455,   635,    -1,   455,   361,    -1,
      -1,   629,  1582,    -1,    -1,   629,   210,   382,    -1,  1582,
    1583,    -1,  1583,    -1,   210,   382,    -1,   318,  1315,    -1,
     322,  1315,    -1,   317,  1315,    -1,   323,  1314,    -1,    -1,
      33,  1585,  1586,    -1,    -1,   632,    -1,    -1,    18,   365,
      58,    -1,    18,    58,    -1,    -1,   445,    -1,   365,   445,
      -1,    -1,   478,    -1,    85,  1586,  1587,  1588,    -1,   470,
    1586,  1587,  1588,    -1,   470,  1586,   573,  1589,  1498,    -1,
     478,  1498,    -1,   445,   478,  1498,    -1,    -1,  1595,    -1,
      -1,   594,  1602,  1596,  1167,    -1,    -1,  1595,    -1,  1599,
      -1,    -1,  1599,    -1,    -1,  1600,  1601,    -1,  1303,  1307,
      -1,  1309,    -1,    -1,   146,    -1,    13,    -1,   484,  1259,
      -1,   652,  1169,   653,    -1,  1603,  1598,    -1,    -1,  1604,
     594,  1602,  1605,  1603,  1598,    -1,  1607,  1604,  1608,    -1,
      -1,    -1,    -1,  1610,    -1,  1610,  1611,    -1,  1611,    -1,
     538,    -1,   222,    -1,   146,    -1,   523,    -1,   518,    -1,
     519,    -1,   521,    -1,    13,    -1,  1617,  1613,    -1,  1616,
    1614,    -1,  1618,  1615,  1622,    -1,  1622,    -1,  1630,    -1,
    1641,    -1,  1635,    -1,   701,    -1,  1622,    -1,  1630,    -1,
    1641,    -1,  1635,    -1,  1634,    -1,   701,    -1,  1616,    -1,
    1617,    -1,    -1,   133,   166,  1502,    -1,  1619,    -1,  1619,
    1620,    -1,  1620,    -1,   387,   453,    -1,    12,   166,   587,
      -1,    12,   166,   330,    -1,    12,   166,   560,    -1,    -1,
     524,   483,   133,    -1,   524,   483,   251,    -1,    -1,  1621,
     620,  1491,  1623,  1624,    20,  1626,    -1,    -1,   652,  1625,
     653,    -1,  1498,    -1,  1625,   654,  1498,    -1,    -1,  1627,
    1628,  1629,    -1,   484,  1170,    -1,   652,  1168,   653,  1597,
      -1,    -1,   629,    65,   382,    -1,   629,    54,    65,   382,
      -1,   629,   282,    65,   382,    -1,    -1,    -1,    -1,   578,
    1183,   715,   820,   821,   375,  1183,  1631,  1491,   196,  1183,
    1632,   155,   475,  1633,   770,    -1,    11,  1183,   201,  1498,
     464,   944,   510,  1495,    -1,  1183,   201,  1498,   464,   944,
     510,  1495,    -1,    -1,    -1,    -1,    -1,    -1,  1183,   201,
     715,   652,  1636,   726,   653,  1637,   464,  1638,   989,  1639,
     717,  1640,   770,    -1,    -1,    -1,    -1,    -1,   417,  1183,
     715,  1642,   652,  1643,   730,   653,  1644,   717,  1645,   770,
      -1,   636,  1648,  1647,  1649,    -1,   636,   160,  1647,  1651,
      -1,   636,   412,  1647,    -1,   636,    85,  1647,  1650,    -1,
     636,   470,  1647,    -1,   636,   434,    -1,  1478,    -1,  1478,
     654,  1478,    -1,  1478,   654,  1478,   654,  1315,    -1,    33,
      -1,   529,    -1,    -1,   259,    -1,   461,    -1,    -1,   376,
     404,    -1,    -1,    -1,   548,  1652,  1653,    -1,    -1,   196,
     333,    -1,   247,   406,  1498,   510,  1495,    -1,   247,   510,
    1495,    -1,   593,   406,  1498,    -1,   593,   510,  1495,    -1,
     642,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1930,  1930,  1942,  1941,  1966,  1973,  1975,  1979,  1980,
    1985,  1986,  1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,
    1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,
    2005,  2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,
    2015,  2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,  2024,
    2025,  2026,  2027,  2028,  2029,  2030,  2031,  2032,  2033,  2034,
    2035,  2036,  2037,  2038,  2039,  2043,  2052,  2053,  2057,  2066,
    2072,  2082,  2081,  2091,  2093,  2097,  2098,  2102,  2115,  2114,
    2134,  2133,  2142,  2143,  2147,  2151,  2155,  2159,  2163,  2167,
    2172,  2176,  2180,  2184,  2188,  2192,  2197,  2201,  2206,  2237,
    2242,  2245,  2247,  2248,  2252,  2258,  2262,  2278,  2282,  2288,
    2298,  2308,  2321,  2325,  2329,  2345,  2344,  2385,  2390,  2384,
    2397,  2402,  2395,  2409,  2414,  2407,  2420,  2419,  2432,  2431,
    2439,  2443,  2447,  2451,  2455,  2462,  2475,  2476,  2480,  2484,
    2488,  2492,  2496,  2500,  2504,  2512,  2511,  2542,  2541,  2548,
    2555,  2556,  2562,  2568,  2578,  2584,  2590,  2592,  2599,  2600,
    2604,  2610,  2619,  2620,  2628,  2628,  2684,  2685,  2686,  2687,
    2688,  2689,  2690,  2691,  2692,  2693,  2694,  2695,  2696,  2701,
    2715,  2731,  2749,  2750,  2754,  2755,  2760,  2762,  2764,  2766,
    2768,  2770,  2772,  2778,  2779,  2780,  2784,  2788,  2796,  2795,
    2808,  2810,  2813,  2815,  2819,  2823,  2830,  2832,  2836,  2837,
    2842,  2862,  2890,  2892,  2896,  2897,  2901,  2928,  2929,  2930,
    2931,  2935,  2936,  2940,  2941,  2946,  2949,  2976,  2975,  3039,
    3055,  3054,  3110,  3136,  3136,  3159,  3160,  3165,  3167,  3172,
    3194,  3205,  3209,  3231,  3232,  3236,  3240,  3249,  3255,  3261,
    3270,  3284,  3307,  3313,  3314,  3320,  3323,  3327,  3335,  3355,
    3357,  3375,  3381,  3383,  3385,  3387,  3389,  3391,  3393,  3395,
    3397,  3399,  3401,  3403,  3408,  3423,  3439,  3440,  3445,  3451,
    3460,  3466,  3475,  3483,  3492,  3501,  3503,  3512,  3517,  3523,
    3532,  3540,  3542,  3544,  3546,  3548,  3550,  3552,  3554,  3556,
    3558,  3560,  3562,  3564,  3569,  3587,  3608,  3609,  3613,  3614,
    3615,  3616,  3617,  3618,  3619,  3620,  3621,  3622,  3623,  3624,
    3625,  3630,  3629,  3636,  3636,  3691,  3690,  3719,  3719,  3734,
    3787,  3830,  3851,  3850,  3872,  3891,  3893,  3894,  3898,  3918,
    3941,  3943,  3959,  3941,  3978,  3980,  3981,  3985,  3986,  3991,
    3997,  3990,  4018,  4017,  4033,  4034,  4038,  4039,  4044,  4048,
    4043,  4069,  4073,  4068,  4092,  4102,  4107,  4106,  4141,  4142,
    4147,  4146,  4178,  4178,  4193,  4192,  4229,  4241,  4243,  4240,
    4270,  4269,  4290,  4292,  4297,  4299,  4301,  4318,  4323,  4329,
    4336,  4337,  4345,  4351,  4360,  4366,  4372,  4373,  4377,  4377,
    4382,  4383,  4384,  4388,  4389,  4390,  4394,  4398,  4399,  4400,
    4404,  4405,  4406,  4407,  4408,  4409,  4410,  4411,  4415,  4419,
    4420,  4421,  4425,  4426,  4427,  4428,  4429,  4433,  4437,  4438,
    4439,  4443,  4444,  4445,  4446,  4447,  4448,  4449,  4453,  4457,
    4458,  4459,  4463,  4464,  4465,  4470,  4478,  4486,  4494,  4506,
    4518,  4523,  4528,  4536,  4544,  4552,  4560,  4568,  4576,  4584,
    4597,  4610,  4623,  4625,  4629,  4634,  4647,  4648,  4700,  4699,
    4702,  4708,  4708,  4709,  4723,  4724,  4728,  4730,  4729,  4733,
    4732,  4738,  4775,  4776,  4781,  4780,  4799,  4818,  4817,  4834,
    4838,  4846,  4845,  4848,  4850,  4852,  4854,  4859,  4860,  4866,
    4867,  4884,  4885,  4889,  4890,  4894,  4913,  4923,  4934,  4943,
    4944,  4960,  4962,  4961,  4966,  4964,  4975,  4976,  4980,  4998,
    5014,  5015,  5031,  5046,  5068,  5069,  5074,  5073,  5097,  5107,
    5129,  5128,  5146,  5145,  5165,  5187,  5191,  5220,  5232,  5233,
    5238,  5249,  5237,  5274,  5275,  5279,  5292,  5313,  5326,  5352,
    5353,  5358,  5357,  5394,  5399,  5400,  5404,  5405,  5409,  5411,
    5417,  5423,  5425,  5427,  5429,  5431,  5433,  5443,  5458,  5442,
    5472,  5473,  5477,  5478,  5482,  5483,  5487,  5488,  5492,  5493,
    5497,  5498,  5502,  5507,  5511,  5518,  5520,  5524,  5525,  5529,
    5530,  5531,  5535,  5540,  5545,  5550,  5555,  5560,  5565,  5570,
    5585,  5591,  5606,  5611,  5626,  5632,  5650,  5655,  5660,  5665,
    5670,  5675,  5681,  5680,  5706,  5707,  5708,  5713,  5718,  5723,
    5725,  5727,  5729,  5735,  5740,  5745,  5751,  5757,  5763,  5772,
    5790,  5807,  5830,  5844,  5845,  5846,  5847,  5848,  5849,  5850,
    5854,  5855,  5856,  5860,  5861,  5865,  5866,  5867,  5868,  5873,
    5880,  5881,  5885,  5886,  5890,  5891,  5899,  5898,  5907,  5905,
    5915,  5913,  5923,  5921,  5929,  5950,  5956,  5958,  5962,  5966,
    5967,  5971,  5976,  5975,  6001,  6002,  6011,  6013,  6018,  6021,
    6025,  6032,  6033,  6037,  6038,  6042,  6048,  6054,  6058,  6074,
    6090,  6091,  6092,  6093,  6098,  6102,  6107,  6112,  6116,  6121,
    6126,  6132,  6137,  6143,  6147,  6152,  6157,  6175,  6177,  6179,
    6192,  6194,  6199,  6204,  6216,  6221,  6226,  6231,  6233,  6235,
    6237,  6239,  6241,  6243,  6245,  6248,  6247,  6252,  6251,  6255,
    6257,  6266,  6267,  6268,  6273,  6274,  6275,  6276,  6277,  6281,
    6285,  6286,  6290,  6291,  6295,  6296,  6297,  6298,  6299,  6303,
    6304,  6305,  6306,  6307,  6311,  6316,  6318,  6324,  6325,  6327,
    6332,  6341,  6342,  6346,  6347,  6351,  6352,  6353,  6357,  6358,
    6359,  6360,  6363,  6364,  6368,  6369,  6373,  6374,  6378,  6379,
    6383,  6384,  6385,  6386,  6393,  6394,  6400,  6406,  6412,  6418,
    6419,  6432,  6438,  6444,  6450,  6459,  6480,  6486,  6491,  6492,
    6496,  6497,  6501,  6509,  6513,  6514,  6518,  6519,  6523,  6532,
    6536,  6537,  6541,  6549,  6550,  6554,  6555,  6559,  6560,  6565,
    6566,  6570,  6577,  6586,  6591,  6599,  6600,  6601,  6602,  6603,
    6604,  6609,  6617,  6618,  6623,  6622,  6635,  6636,  6640,  6643,
    6644,  6645,  6646,  6650,  6658,  6665,  6666,  6670,  6680,  6681,
    6685,  6686,  6689,  6691,  6695,  6707,  6708,  6712,  6719,  6732,
    6733,  6735,  6737,  6743,  6748,  6754,  6760,  6767,  6777,  6778,
    6779,  6780,  6781,  6785,  6789,  6790,  6794,  6795,  6799,  6800,
    6804,  6805,  6806,  6810,  6811,  6815,  6819,  6832,  6844,  6845,
    6849,  6850,  6854,  6855,  6859,  6860,  6864,  6865,  6869,  6870,
    6874,  6875,  6879,  6880,  6884,  6886,  6887,  6893,  6899,  6905,
    6913,  6914,  6918,  6922,  6923,  6936,  6937,  6938,  6942,  6943,
    6947,  6953,  6967,  6968,  6972,  6984,  6985,  6989,  6990,  6998,
    7015,  6997,  7035,  7034,  7048,  7060,  7059,  7078,  7077,  7096,
    7095,  7114,  7108,  7128,  7127,  7160,  7165,  7170,  7175,  7180,
    7190,  7191,  7192,  7193,  7197,  7198,  7210,  7211,  7215,  7216,
    7219,  7221,  7229,  7237,  7239,  7241,  7242,  7250,  7251,  7255,
    7264,  7262,  7275,  7288,  7287,  7300,  7298,  7311,  7318,  7328,
    7329,  7356,  7363,  7367,  7372,  7371,  7387,  7389,  7394,  7402,
    7401,  7417,  7421,  7420,  7432,  7433,  7437,  7452,  7453,  7457,
    7466,  7470,  7475,  7481,  7480,  7492,  7503,  7491,  7519,  7528,
    7537,  7547,  7556,  7562,  7568,  7577,  7586,  7605,  7625,  7635,
    7639,  7644,  7645,  7648,  7650,  7651,  7652,  7653,  7656,  7661,
    7672,  7677,  7688,  7689,  7693,  7694,  7698,  7698,  7701,  7703,
    7707,  7708,  7712,  7713,  7721,  7722,  7723,  7727,  7728,  7733,
    7741,  7742,  7743,  7744,  7749,  7748,  7758,  7757,  7764,  7771,
    7781,  7798,  7801,  7808,  7812,  7819,  7823,  7827,  7834,  7834,
    7840,  7841,  7845,  7846,  7847,  7851,  7852,  7865,  7872,  7873,
    7878,  7877,  7889,  7890,  7891,  7896,  7895,  7916,  7917,  7921,
    7922,  7926,  7927,  7928,  7933,  7932,  7953,  7954,  7958,  7963,
    7964,  7971,  7973,  7977,  7979,  7978,  7990,  7992,  7991,  8004,
    8005,  8010,  8019,  8020,  8021,  8025,  8031,  8040,  8049,  8048,
    8074,  8075,  8079,  8080,  8084,  8085,  8086,  8087,  8088,  8089,
    8094,  8093,  8114,  8115,  8116,  8121,  8120,  8126,  8133,  8138,
    8146,  8147,  8151,  8165,  8164,  8177,  8178,  8182,  8183,  8187,
    8197,  8207,  8208,  8213,  8212,  8223,  8224,  8228,  8229,  8233,
    8243,  8254,  8253,  8261,  8261,  8270,  8271,  8276,  8277,  8286,
    8295,  8296,  8300,  8305,  8310,  8315,  8320,  8319,  8339,  8347,
    8339,  8354,  8355,  8356,  8357,  8358,  8362,  8369,  8376,  8378,
    8389,  8390,  8394,  8395,  8423,  8453,  8455,  8461,  8471,  8472,
    8473,  8487,  8492,  8517,  8523,  8529,  8530,  8531,  8532,  8533,
    8537,  8538,  8539,  8543,  8544,  8545,  8549,  8550,  8555,  8606,
    8613,  8656,  8662,  8668,  8674,  8680,  8686,  8692,  8698,  8702,
    8708,  8714,  8720,  8726,  8732,  8736,  8742,  8751,  8757,  8765,
    8771,  8781,  8787,  8796,  8806,  8812,  8822,  8828,  8837,  8841,
    8847,  8853,  8859,  8865,  8871,  8877,  8883,  8889,  8895,  8901,
    8907,  8913,  8919,  8925,  8929,  8930,  8934,  8935,  8939,  8940,
    8944,  8945,  8949,  8950,  8951,  8952,  8953,  8954,  8958,  8959,
    8964,  8970,  8974,  8981,  8988,  8995,  9002,  9009,  9014,  9020,
    9027,  9034,  9042,  9053,  9075,  9082,  9090,  9091,  9092,  9093,
    9094,  9095,  9106,  9107,  9108,  9109,  9110,  9116,  9120,  9126,
    9132,  9138,  9144,  9146,  9153,  9160,  9166,  9209,  9218,  9225,
    9233,  9239,  9246,  9252,  9266,  9273,  9289,  9295,  9301,  9309,
    9317,  9323,  9329,  9335,  9341,  9355,  9366,  9372,  9378,  9384,
    9390,  9396,  9402,  9408,  9414,  9420,  9426,  9432,  9438,  9444,
    9450,  9456,  9462,  9470,  9491,  9498,  9504,  9511,  9518,  9525,
    9532,  9538,  9544,  9551,  9557,  9564,  9570,  9576,  9582,  9588,
    9594,  9612,  9618,  9624,  9631,  9638,  9646,  9653,  9660,  9667,
    9674,  9691,  9697,  9703,  9709,  9715,  9722,  9728,  9734,  9740,
    9746,  9752,  9763,  9769,  9775,  9781,  9787,  9795,  9801,  9812,
    9818,  9824,  9832,  9842,  9848,  9864,  9870,  9877,  9884,  9891,
    9898,  9905,  9909,  9929,  9928, 10000, 10041, 10043, 10048, 10049,
   10053, 10054, 10058, 10059, 10063, 10070, 10078, 10104, 10110, 10116,
   10122, 10128, 10134, 10143, 10150, 10152, 10149, 10159, 10170, 10176,
   10182, 10188, 10194, 10200, 10206, 10212, 10218, 10225, 10224, 10244,
   10243, 10258, 10268, 10276, 10292, 10293, 10298, 10303, 10306, 10309,
   10308, 10325, 10327, 10333, 10332, 10349, 10351, 10353, 10355, 10357,
   10359, 10361, 10363, 10365, 10367, 10373, 10379, 10382, 10381, 10387,
   10388, 10392, 10399, 10407, 10408, 10412, 10419, 10427, 10428, 10432,
   10433, 10437, 10445, 10456, 10457, 10469, 10480, 10481, 10487, 10488,
   10508, 10512, 10510, 10528, 10526, 10537, 10547, 10545, 10563, 10562,
   10572, 10583, 10581, 10600, 10599, 10610, 10622, 10623, 10624, 10628,
   10629, 10637, 10638, 10642, 10657, 10657, 10672, 10712, 10788, 10799,
   10804, 10796, 10823, 10843, 10851, 10843, 10860, 10859, 10882, 10899,
   10882, 10906, 10910, 10936, 10937, 10942, 10945, 10946, 10947, 10951,
   10952, 10957, 10956, 10962, 10961, 10969, 10970, 10973, 10975, 10975,
   10979, 10979, 10984, 10985, 10989, 10991, 10996, 10997, 11001, 11012,
   11025, 11026, 11027, 11028, 11029, 11030, 11031, 11032, 11033, 11034,
   11035, 11036, 11040, 11041, 11042, 11043, 11044, 11045, 11046, 11047,
   11048, 11052, 11053, 11054, 11055, 11058, 11060, 11061, 11065, 11066,
   11074, 11076, 11080, 11082, 11081, 11095, 11098, 11097, 11112, 11118,
   11132, 11134, 11138, 11140, 11145, 11146, 11166, 11191, 11195, 11196,
   11200, 11212, 11214, 11219, 11218, 11253, 11255, 11260, 11261, 11262,
   11267, 11274, 11278, 11279, 11283, 11287, 11291, 11298, 11305, 11312,
   11322, 11355, 11359, 11365, 11371, 11380, 11388, 11392, 11399, 11400,
   11404, 11405, 11406, 11410, 11411, 11412, 11413, 11414, 11415, 11419,
   11420, 11421, 11422, 11423, 11427, 11428, 11429, 11430, 11431, 11435,
   11436, 11437, 11438, 11439, 11443, 11448, 11449, 11453, 11454, 11457,
   11460, 11459, 11490, 11491, 11495, 11496, 11500, 11510, 11510, 11520,
   11521, 11525, 11544, 11577, 11576, 11589, 11597, 11588, 11599, 11611,
   11623, 11622, 11640, 11639, 11650, 11650, 11666, 11673, 11695, 11715,
   11727, 11731, 11736, 11735, 11745, 11751, 11758, 11763, 11768, 11778,
   11779, 11783, 11794, 11807, 11808, 11812, 11824, 11828, 11836, 11837,
   11845, 11853, 11844, 11863, 11870, 11862, 11880, 11888, 11889, 11897,
   11901, 11902, 11913, 11914, 11918, 11927, 11928, 11929, 11931, 11930,
   11941, 11942, 11946, 11947, 11949, 11948, 11952, 11951, 11957, 11958,
   11962, 11963, 11967, 11977, 11978, 11982, 11983, 11988, 11987, 12001,
   12002, 12006, 12011, 12019, 12020, 12028, 12030, 12030, 12038, 12046,
   12037, 12068, 12069, 12073, 12081, 12082, 12086, 12096, 12097, 12104,
   12103, 12119, 12130, 12118, 12133, 12132, 12144, 12143, 12156, 12158,
   12162, 12163, 12167, 12180, 12196, 12197, 12201, 12202, 12206, 12207,
   12208, 12213, 12212, 12233, 12235, 12238, 12240, 12243, 12244, 12247,
   12251, 12255, 12259, 12263, 12267, 12271, 12275, 12279, 12287, 12290,
   12300, 12299, 12315, 12322, 12330, 12338, 12346, 12354, 12362, 12369,
   12376, 12382, 12384, 12386, 12395, 12399, 12404, 12403, 12409, 12408,
   12413, 12422, 12429, 12434, 12439, 12444, 12446, 12448, 12450, 12452,
   12454, 12461, 12469, 12471, 12479, 12486, 12493, 12500, 12506, 12512,
   12521, 12529, 12533, 12538, 12545, 12550, 12557, 12564, 12571, 12578,
   12585, 12592, 12598, 12605, 12612, 12617, 12622, 12627, 12637, 12639,
   12641, 12646, 12647, 12650, 12652, 12656, 12657, 12661, 12662, 12666,
   12667, 12671, 12672, 12676, 12677, 12680, 12682, 12689, 12700, 12699,
   12715, 12714, 12724, 12725, 12726, 12727, 12728, 12732, 12733, 12737,
   12738, 12739, 12743, 12744, 12745, 12760, 12759, 12772, 12781, 12771,
   12783, 12787, 12788, 12802, 12803, 12808, 12810, 12812, 12814, 12816,
   12818, 12829, 12831, 12833, 12835, 12841, 12843, 12854, 12856, 12858,
   12860, 12862, 12864, 12866, 12871, 12872, 12876, 12877, 12881, 12880,
   12890, 12891, 12895, 12895, 12898, 12899, 12903, 12904, 12909, 12908,
   12919, 12923, 12927, 12940, 12939, 12954, 12955, 12956, 12959, 12960,
   12961, 12962, 12970, 12974, 12983, 12989, 13001, 13012, 13022, 13032,
   13000, 13040, 13041, 13045, 13046, 13050, 13051, 13059, 13063, 13064,
   13065, 13068, 13070, 13074, 13075, 13079, 13084, 13091, 13096, 13103,
   13105, 13109, 13110, 13114, 13119, 13127, 13128, 13131, 13133, 13141,
   13143, 13147, 13148, 13149, 13153, 13155, 13160, 13161, 13170, 13171,
   13175, 13176, 13180, 13193, 13216, 13228, 13239, 13258, 13266, 13278,
   13286, 13301, 13321, 13322, 13323, 13331, 13332, 13333, 13334, 13341,
   13347, 13353, 13359, 13365, 13371, 13400, 13431, 13441, 13451, 13457,
   13466, 13478, 13484, 13490, 13506, 13507, 13511, 13520, 13535, 13539,
   13585, 13589, 13606, 13610, 13688, 13712, 13742, 13743, 13759, 13769,
   13773, 13779, 13785, 13795, 13801, 13810, 13820, 13821, 13849, 13863,
   13877, 13892, 13893, 13903, 13904, 13914, 13915, 13916, 13920, 13935,
   13967, 13977, 13977, 13981, 13982, 13983, 13984, 13985, 13986, 13987,
   13988, 13989, 13990, 13991, 13992, 13993, 13994, 13995, 13996, 13997,
   13998, 13999, 14000, 14001, 14002, 14003, 14004, 14005, 14006, 14007,
   14008, 14009, 14010, 14011, 14012, 14013, 14014, 14015, 14016, 14017,
   14018, 14019, 14020, 14021, 14022, 14023, 14024, 14025, 14026, 14027,
   14028, 14029, 14030, 14031, 14032, 14033, 14034, 14035, 14036, 14037,
   14038, 14039, 14040, 14050, 14051, 14052, 14053, 14054, 14055, 14056,
   14057, 14058, 14059, 14060, 14061, 14062, 14063, 14064, 14065, 14066,
   14067, 14068, 14069, 14070, 14071, 14072, 14073, 14074, 14075, 14076,
   14077, 14078, 14079, 14080, 14081, 14082, 14083, 14084, 14085, 14086,
   14087, 14088, 14089, 14090, 14091, 14092, 14093, 14094, 14095, 14096,
   14097, 14098, 14099, 14104, 14105, 14106, 14107, 14108, 14109, 14110,
   14111, 14112, 14113, 14114, 14115, 14116, 14117, 14118, 14119, 14120,
   14121, 14122, 14123, 14124, 14125, 14126, 14127, 14128, 14129, 14130,
   14131, 14132, 14133, 14134, 14135, 14136, 14137, 14138, 14139, 14140,
   14141, 14142, 14143, 14144, 14145, 14146, 14147, 14148, 14149, 14150,
   14151, 14152, 14153, 14154, 14155, 14156, 14157, 14158, 14159, 14160,
   14161, 14162, 14163, 14164, 14165, 14166, 14167, 14168, 14169, 14170,
   14171, 14172, 14173, 14174, 14175, 14176, 14177, 14178, 14179, 14180,
   14181, 14182, 14183, 14184, 14185, 14186, 14187, 14188, 14189, 14190,
   14191, 14192, 14193, 14194, 14195, 14196, 14197, 14198, 14199, 14200,
   14201, 14202, 14203, 14204, 14205, 14206, 14207, 14208, 14209, 14210,
   14211, 14212, 14213, 14214, 14215, 14216, 14217, 14218, 14219, 14220,
   14221, 14222, 14223, 14224, 14225, 14226, 14227, 14228, 14229, 14230,
   14231, 14232, 14233, 14234, 14235, 14236, 14237, 14238, 14239, 14240,
   14241, 14242, 14243, 14244, 14245, 14246, 14247, 14248, 14249, 14250,
   14251, 14252, 14253, 14254, 14255, 14256, 14257, 14258, 14259, 14260,
   14261, 14262, 14263, 14264, 14265, 14266, 14267, 14268, 14269, 14270,
   14271, 14272, 14273, 14274, 14275, 14276, 14277, 14278, 14279, 14280,
   14281, 14282, 14283, 14284, 14285, 14286, 14287, 14288, 14289, 14290,
   14291, 14292, 14293, 14294, 14295, 14296, 14297, 14298, 14299, 14300,
   14301, 14302, 14303, 14304, 14305, 14306, 14307, 14308, 14309, 14310,
   14311, 14312, 14313, 14314, 14315, 14316, 14317, 14318, 14319, 14320,
   14321, 14322, 14323, 14324, 14325, 14326, 14327, 14328, 14329, 14330,
   14331, 14332, 14333, 14334, 14335, 14336, 14337, 14338, 14339, 14340,
   14341, 14342, 14343, 14344, 14345, 14346, 14347, 14348, 14349, 14350,
   14351, 14352, 14353, 14354, 14355, 14356, 14357, 14358, 14359, 14360,
   14361, 14362, 14374, 14373, 14392, 14391, 14398, 14397, 14407, 14406,
   14417, 14416, 14422, 14430, 14432, 14437, 14437, 14446, 14445, 14459,
   14458, 14463, 14467, 14468, 14469, 14473, 14474, 14475, 14476, 14480,
   14481, 14482, 14483, 14488, 14512, 14538, 14549, 14561, 14574, 14589,
   14608, 14614, 14639, 14652, 14678, 14721, 14735, 14736, 14737, 14738,
   14742, 14759, 14776, 14777, 14781, 14782, 14783, 14784, 14788, 14789,
   14798, 14809, 14810, 14811, 14817, 14823, 14835, 14834, 14850, 14851,
   14855, 14856, 14860, 14875, 14876, 14877, 14882, 14883, 14888, 14887,
   14907, 14919, 14932, 14931, 14965, 14966, 14970, 14971, 14975, 14976,
   14977, 14978, 14980, 14979, 14992, 14993, 14994, 14995, 14996, 15002,
   15007, 15013, 15024, 15035, 15039, 15046, 15055, 15057, 15062, 15067,
   15074, 15086, 15098, 15105, 15117, 15118, 15121, 15122, 15125, 15130,
   15138, 15149, 15164, 15167, 15169, 15173, 15174, 15181, 15183, 15187,
   15188, 15193, 15192, 15196, 15195, 15199, 15198, 15202, 15201, 15204,
   15205, 15206, 15207, 15208, 15209, 15210, 15211, 15212, 15213, 15214,
   15215, 15216, 15217, 15218, 15219, 15220, 15221, 15222, 15223, 15224,
   15225, 15226, 15227, 15228, 15229, 15233, 15234, 15238, 15239, 15243,
   15253, 15263, 15276, 15291, 15304, 15317, 15329, 15334, 15342, 15347,
   15355, 15360, 15367, 15367, 15368, 15368, 15371, 15400, 15405, 15411,
   15417, 15423, 15427, 15431, 15432, 15436, 15463, 15465, 15469, 15473,
   15477, 15484, 15485, 15489, 15490, 15494, 15495, 15499, 15500, 15506,
   15512, 15518, 15528, 15527, 15537, 15538, 15543, 15544, 15545, 15550,
   15551, 15552, 15556, 15557, 15561, 15573, 15582, 15592, 15601, 15615,
   15616, 15621, 15620, 15636, 15637, 15638, 15642, 15643, 15647, 15647,
   15669, 15670, 15674, 15675, 15676, 15680, 15684, 15691, 15694, 15692,
   15708, 15715, 15736, 15753, 15755, 15759, 15760, 15764, 15765, 15773,
   15774, 15775, 15776, 15782, 15788, 15798, 15800, 15802, 15807, 15808,
   15809, 15810, 15811, 15815, 15816, 15817, 15818, 15819, 15820, 15830,
   15831, 15836, 15849, 15862, 15864, 15866, 15871, 15876, 15878, 15880,
   15886, 15887, 15889, 15895, 15894, 15911, 15912, 15916, 15921, 15929,
   15929, 15953, 15954, 15959, 15960, 15962, 15964, 15982, 15988, 15993,
   15975, 16054, 16071, 16095, 16126, 16130, 16139, 16162, 16091, 16225,
   16249, 16258, 16265, 16224, 16285, 16289, 16293, 16297, 16301, 16305,
   16312, 16319, 16326, 16336, 16337, 16341, 16342, 16343, 16347, 16348,
   16353, 16355, 16354, 16360, 16361, 16365, 16372, 16382, 16388, 16399
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADMIN_SYM", "ADDDATE_SYM", "AFTER_SYM", "AGAINST",
  "AGGREGATE_SYM", "ALGORITHM_SYM", "ALL", "ALTER", "ALWAYS_SYM",
  "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC",
  "ASCII_SYM", "ASENSITIVE_SYM", "AT_SYM", "AUTHORS_SYM",
  "AUTOEXTEND_SIZE_SYM", "AUTO_INC", "AUTO_SYM", "AVG_ROW_LENGTH",
  "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM", "BETWEEN_SYM",
  "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR",
  "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM",
  "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM",
  "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM", "CATALOG_NAME_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKPOINT_SYM", "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM",
  "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLIENT_STATS_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_ADD_SYM", "COLUMN_CHECK_SYM", "COLUMN_CREATE_SYM",
  "COLUMN_DELETE_SYM", "COLUMN_GET_SYM", "COLUMN_SYM", "COLUMN_NAME_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPLETION_SYM", "COMPRESSED_SYM", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM", "CONSTRAINT_SCHEMA_SYM",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONTRIBUTORS_SYM",
  "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_SYM", "CURRENT_USER", "CURRENT_ROLE",
  "CURRENT_POS_SYM", "CURSOR_SYM", "CURSOR_NAME_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATAFILE_SYM", "DATA_SYM", "DATETIME",
  "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM",
  "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM",
  "DEALLOCATE_SYM", "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_KEY_FILE", "DETERMINISTIC_SYM",
  "DIAGNOSTICS_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD", "DISK_SYM",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSE",
  "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERROR_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXCHANGE_SYM", "EXAMINED_SYM", "EXECUTE_SYM",
  "EXISTS", "EXIT_SYM", "EXPANSION_SYM", "EXTENDED_SYM", "EXTENT_SIZE_SYM",
  "EXTRACT_SYM", "FALSE_SYM", "FAST_SYM", "FAULTS_SYM", "FETCH_SYM",
  "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM", "FLOAT_SYM",
  "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FOR_SYM", "FOUND_SYM", "FROM",
  "FULL", "FULLTEXT_SYM", "FUNCTION_SYM", "GE", "GENERAL", "GENERATED_SYM",
  "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GET_FORMAT", "GET_SYM",
  "GLOBAL_SYM", "GRANT", "GRANTS", "GROUP_SYM", "GROUP_CONCAT_SYM",
  "GT_SYM", "HANDLER_SYM", "HARD_SYM", "HASH_SYM", "HAVING", "HELP_SYM",
  "HEX_NUM", "HEX_STRING", "HIGH_PRIORITY", "HOST_SYM", "HOSTS_SYM",
  "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM", "HOUR_SECOND_SYM", "HOUR_SYM",
  "ID_SYM", "IDENT", "IDENTIFIED_SYM", "IDENT_QUOTED", "IF", "IGNORE_SYM",
  "IGNORE_SERVER_IDS_SYM", "IMPORT", "INDEXES", "INDEX_SYM",
  "INDEX_STATS_SYM", "INFILE", "INITIAL_SIZE_SYM", "INNER_SYM",
  "INOUT_SYM", "INSENSITIVE_SYM", "INSERT", "INSERT_METHOD", "INSTALL_SYM",
  "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM", "IN_SYM", "IO_SYM",
  "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM", "ITERATE_SYM", "JOIN_SYM",
  "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM", "KILL_SYM", "LANGUAGE_SYM",
  "LAST_SYM", "LAST_VALUE", "LE", "LEADING", "LEAVES", "LEAVE_SYM", "LEFT",
  "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME", "LIKE", "LIMIT", "LINEAR_SYM",
  "LINES", "LINESTRING", "LIST_SYM", "LOAD", "LOCAL_SYM", "LOCATOR_SYM",
  "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM", "LOGS_SYM", "LONGBLOB",
  "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM", "LOW_PRIORITY", "LT",
  "MASTER_CONNECT_RETRY_SYM", "MASTER_GTID_POS_SYM", "MASTER_HOST_SYM",
  "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM", "MASTER_PASSWORD_SYM",
  "MASTER_PORT_SYM", "MASTER_SERVER_ID_SYM", "MASTER_SSL_CAPATH_SYM",
  "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM", "MASTER_SSL_CIPHER_SYM",
  "MASTER_SSL_CRL_SYM", "MASTER_SSL_CRLPATH_SYM", "MASTER_SSL_KEY_SYM",
  "MASTER_SSL_SYM", "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM",
  "MASTER_USER_SYM", "MASTER_USE_GTID_SYM", "MASTER_HEARTBEAT_PERIOD_SYM",
  "MATCH", "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM",
  "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM", "NATIONAL_SYM",
  "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM", "NE", "NEG",
  "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM", "NOT2_SYM",
  "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM", "NO_WRITE_TO_BINLOG",
  "NULL_SYM", "NUM", "NUMBER_SYM", "NUMERIC_SYM", "NVARCHAR_SYM",
  "OFFSET_SYM", "OLD_PASSWORD", "ON", "ONE_SYM", "ONLY_SYM", "ONLINE_SYM",
  "OPEN_SYM", "OPTIMIZE", "OPTIONS_SYM", "OPTION", "OPTIONALLY", "OR2_SYM",
  "ORDER_SYM", "OR_OR_SYM", "OR_SYM", "OUTER", "OUTFILE", "OUT_SYM",
  "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM", "PAGE_CHECKSUM_SYM",
  "PARAM_MARKER", "PARSER_SYM", "PARSE_VCOL_EXPR_SYM", "PARTIAL",
  "PARTITION_SYM", "PARTITIONS_SYM", "PARTITIONING_SYM", "PASSWORD",
  "PERSISTENT_SYM", "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM", "POINT_SYM",
  "POLYGON", "PORT_SYM", "POSITION_SYM", "PRECISION", "PREPARE_SYM",
  "PRESERVE_SYM", "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES", "PROCEDURE_SYM",
  "PROCESS", "PROCESSLIST_SYM", "PROFILE_SYM", "PROFILES_SYM", "PROXY_SYM",
  "PURGE", "QUARTER_SYM", "QUERY_SYM", "QUICK", "RANGE_SYM", "READS_SYM",
  "READ_ONLY_SYM", "READ_SYM", "READ_WRITE_SYM", "REAL", "REBUILD_SYM",
  "RECOVER_SYM", "REDOFILE_SYM", "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM",
  "REFERENCES", "REGEXP", "RELAY", "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM",
  "RELAY_LOG_POS_SYM", "RELAY_THREAD", "RELEASE_SYM", "RELOAD",
  "REMOVE_SYM", "RENAME", "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM",
  "REPEAT_SYM", "REPLACE", "REPLICATION", "REQUIRE_SYM", "RESET_SYM",
  "RESIGNAL_SYM", "RESOURCES", "RESTORE_SYM", "RESTRICT", "RESUME_SYM",
  "RETURNED_SQLSTATE_SYM", "RETURNING_SYM", "RETURNS_SYM", "RETURN_SYM",
  "REVERSE_SYM", "REVOKE", "RIGHT", "ROLE_SYM", "ROLLBACK_SYM",
  "ROLLUP_SYM", "ROUTINE_SYM", "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM",
  "ROW_COUNT_SYM", "RTREE_SYM", "SAVEPOINT_SYM", "SCHEDULE_SYM",
  "SCHEMA_NAME_SYM", "SECOND_MICROSECOND_SYM", "SECOND_SYM",
  "SECURITY_SYM", "SELECT_SYM", "SENSITIVE_SYM", "SEPARATOR_SYM",
  "SERIALIZABLE_SYM", "SERIAL_SYM", "SESSION_SYM", "SERVER_SYM",
  "SERVER_OPTIONS", "SET", "SET_VAR", "SHARE_SYM", "SHIFT_LEFT",
  "SHIFT_RIGHT", "SHOW", "SHUTDOWN", "SIGNAL_SYM", "SIGNED_SYM",
  "SIMPLE_SYM", "SLAVE", "SLAVES", "SLAVE_POS_SYM", "SLOW", "SMALLINT",
  "SNAPSHOT_SYM", "SOCKET_SYM", "SOFT_SYM", "SONAME_SYM", "SOUNDS_SYM",
  "SOURCE_SYM", "SPATIAL_SYM", "SPECIFIC_SYM", "SQLEXCEPTION_SYM",
  "SQLSTATE_SYM", "SQLWARNING_SYM", "SQL_BIG_RESULT", "SQL_BUFFER_RESULT",
  "SQL_CACHE_SYM", "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM",
  "SQL_SMALL_RESULT", "SQL_SYM", "SQL_THREAD", "SSL_SYM", "STARTING",
  "STARTS_SYM", "START_SYM", "STATS_AUTO_RECALC_SYM",
  "STATS_PERSISTENT_SYM", "STATS_SAMPLE_PAGES_SYM", "STATUS_SYM",
  "STDDEV_SAMP_SYM", "STD_SYM", "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN",
  "STRING_SYM", "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM", "SUBJECT_SYM",
  "SUBPARTITIONS_SYM", "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM",
  "SUPER_SYM", "SUSPEND_SYM", "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE",
  "TABLES", "TABLESPACE", "TABLE_REF_PRIORITY", "TABLE_STATS_SYM",
  "TABLE_SYM", "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY",
  "TEMPTABLE_SYM", "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM",
  "THEN_SYM", "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM",
  "TINYBLOB", "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING",
  "TRANSACTION_SYM", "TRANSACTIONAL_SYM", "TRIGGERS_SYM", "TRIGGER_SYM",
  "TRIM", "TRUE_SYM", "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM",
  "UDF_RETURNS_SYM", "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDOFILE_SYM", "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM",
  "UNICODE_SYM", "UNINSTALL_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USER_STATS_SYM", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VAR_SAMP_SYM", "VIA_SYM", "VIEW_SYM", "VIRTUAL_SYM",
  "WAIT_SYM", "WARNINGS", "WEEK_SYM", "WEIGHT_STRING_SYM", "WHEN_SYM",
  "WHERE", "WHILE_SYM", "WITH", "WITH_CUBE_SYM", "WITH_ROLLUP_SYM",
  "WORK_SYM", "WRAPPER_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM",
  "XOR", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL", "IMPOSSIBLE_ACTION",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "'('",
  "')'", "','", "'!'", "'{'", "'}'", "';'", "'@'", "'.'", "':'", "$accept",
  "query", "$@1", "opt_end_of_input", "verb_clause", "statement",
  "deallocate", "deallocate_or_drop", "prepare", "prepare_src", "execute",
  "$@2", "execute_using", "execute_var_list", "execute_var_ident", "help",
  "$@3", "change", "$@4", "master_defs", "master_def",
  "ignore_server_id_list", "ignore_server_id", "master_file_def",
  "optional_connection_name", "connection_name", "create", "$@5", "$@6",
  "$@7", "$@8", "$@9", "$@10", "$@11", "$@12", "$@13", "server_def",
  "server_options_list", "server_option", "event_tail", "$@14",
  "ev_schedule_time", "$@15", "opt_ev_status", "ev_starts", "ev_ends",
  "opt_ev_on_completion", "ev_on_completion", "opt_ev_comment",
  "ev_sql_stmt", "$@16", "ev_sql_stmt_inner", "clear_privileges",
  "sp_name", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "$@17", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "sp_fdparams",
  "sp_init_param", "sp_fdparam", "sp_pdparam_list", "sp_pdparams",
  "sp_pdparam", "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1",
  "sp_decls", "sp_decl", "$@18", "$@19", "sp_cursor_stmt", "$@20",
  "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "sqlstate", "opt_value", "sp_hcond", "signal_stmt", "signal_value",
  "opt_signal_value", "opt_set_signal_information",
  "signal_information_item_list", "signal_allowed_expr",
  "signal_condition_information_item_name", "resignal_stmt",
  "get_diagnostics", "which_area", "diagnostics_information",
  "statement_information", "statement_information_item",
  "simple_target_specification", "statement_information_item_name",
  "condition_number", "condition_information",
  "condition_information_item", "condition_information_item_name",
  "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "sp_proc_stmt_if",
  "$@21", "sp_proc_stmt_statement", "$@22", "sp_proc_stmt_return", "$@23",
  "sp_proc_stmt_unlabeled", "$@24", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_open", "sp_proc_stmt_fetch",
  "$@25", "sp_proc_stmt_close", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "$@26", "$@27", "$@28", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "$@29", "$@30", "searched_case_stmt", "$@31",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "$@32", "$@33", "searched_when_clause", "$@34",
  "$@35", "else_clause_opt", "sp_labeled_control", "$@36", "sp_opt_label",
  "sp_labeled_block", "$@37", "sp_unlabeled_block", "$@38",
  "sp_block_content", "$@39", "sp_unlabeled_control", "$@40", "$@41",
  "$@42", "trg_action_time", "trg_event", "change_tablespace_access",
  "change_tablespace_info", "tablespace_info", "opt_logfile_group_name",
  "alter_tablespace_info", "logfile_group_info",
  "alter_logfile_group_info", "add_log_file", "change_ts_option_list",
  "$@43", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create_body",
  "$@44", "$@45", "create_like", "opt_create_select", "$@46", "$@47",
  "opt_create_partitioning", "opt_partitioning", "partitioning", "$@48",
  "have_partitioning", "partition_entry", "$@49", "partition",
  "part_type_def", "$@50", "opt_linear", "opt_key_algo", "part_field_list",
  "part_field_item_list", "part_field_item", "part_column_list",
  "part_func", "sub_part_func", "opt_num_parts", "opt_sub_part", "$@51",
  "$@52", "sub_part_field_list", "sub_part_field_item", "part_func_expr",
  "opt_num_subparts", "part_defs", "part_def_list", "part_definition",
  "$@53", "part_name", "opt_part_values", "$@54", "$@55", "part_func_max",
  "part_values_in", "part_value_list", "part_value_item", "$@56", "$@57",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@58", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@59", "$@60", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "opt_create_table_options", "create_table_options_space_separated",
  "create_table_options", "create_table_option", "$@61", "default_charset",
  "default_collation", "storage_engines", "known_storage_engines",
  "row_types", "merge_insert_types", "opt_select_from", "udf_type",
  "create_field_list", "field_list", "field_list_item", "column_def",
  "key_def", "$@62", "$@63", "$@64", "$@65", "opt_check_constraint",
  "check_constraint", "opt_constraint", "constraint", "field_spec", "$@66",
  "field_def", "opt_generated_always", "vcol_opt_specifier",
  "vcol_opt_attribute", "vcol_opt_attribute_list", "vcol_attribute",
  "parse_vcol_expr", "virtual_column_func", "type", "$@67", "$@68",
  "spatial_type", "char", "nchar", "varchar", "nvarchar", "int_type",
  "real_type", "float_options", "precision", "field_options",
  "field_opt_list", "field_option", "field_length", "opt_field_length",
  "opt_precision", "opt_attribute", "opt_attribute_list", "attribute",
  "type_with_opt_collate", "now_or_signed_literal", "hex_num_or_string",
  "charset", "charset_name", "charset_name_or_default",
  "opt_load_data_charset", "old_or_new_charset_name",
  "old_or_new_charset_name_or_default", "collation_name", "opt_collate",
  "collation_name_or_default", "opt_default", "ascii", "unicode",
  "opt_binary", "opt_bin_mod", "ws_nweights", "$@69", "ws_level_flag_desc",
  "ws_level_flag_reverse", "ws_level_flags", "ws_level_number",
  "ws_level_list_item", "ws_level_list", "ws_level_range",
  "ws_level_list_or_range", "opt_ws_levels", "opt_primary", "references",
  "opt_ref_list", "ref_list", "opt_match_clause", "opt_on_update_delete",
  "delete_option", "normal_key_type", "constraint_key_type",
  "key_or_index", "opt_key_or_index", "keys_or_index", "opt_unique",
  "fulltext", "spatial", "init_key_options", "key_alg",
  "normal_key_options", "fulltext_key_options", "spatial_key_options",
  "normal_key_opts", "spatial_key_opts", "fulltext_key_opts",
  "key_using_alg", "all_key_opt", "normal_key_opt", "spatial_key_opt",
  "fulltext_key_opt", "btree_or_rtree", "key_list", "key_part",
  "opt_ident", "opt_if_not_exists_ident", "opt_component", "string_list",
  "alter", "$@70", "$@71", "$@72", "$@73", "$@74", "$@75", "$@76", "$@77",
  "ev_alter_on_schedule_completion", "opt_ev_rename_to", "opt_ev_sql_stmt",
  "ident_or_empty", "alter_commands", "$@78", "$@79", "$@80",
  "remove_partitioning", "all_or_alt_part_name_list", "add_partition_rule",
  "$@81", "add_part_extra", "reorg_partition_rule", "$@82",
  "reorg_parts_rule", "$@83", "alt_part_name_list", "alt_part_name_item",
  "alter_list", "add_column", "alter_list_item", "$@84", "$@85", "$@86",
  "opt_index_lock_algorithm", "alter_algorithm_option",
  "alter_lock_option", "opt_column", "opt_ignore", "alter_options", "$@87",
  "alter_options_part2", "alter_option_list", "alter_option",
  "opt_restrict", "opt_place", "opt_to", "slave", "$@88", "$@89", "start",
  "opt_start_transaction_option_list", "start_transaction_option_list",
  "start_transaction_option", "slave_thread_opts", "$@90",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "checksum", "$@91", "opt_checksum_type", "repair",
  "$@92", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "analyze", "$@93", "analyze_table_list", "analyze_table_elem_spec",
  "opt_persistent_stat_clause", "persistent_stat_spec",
  "persistent_column_stat_spec", "$@94", "persistent_index_stat_spec",
  "$@95", "table_column_list", "table_index_list", "table_index_name",
  "binlog_base64_event", "check", "$@96", "opt_mi_check_type",
  "mi_check_types", "mi_check_type", "optimize", "$@97",
  "opt_no_write_to_binlog", "rename", "$@98", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@99",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@100",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@101", "cache_keys_spec",
  "$@102", "cache_key_list_or_empty", "opt_ignore_leaves", "select",
  "select_init", "select_paren", "select_paren_derived", "select_init2",
  "$@103", "select_part2", "$@104", "$@105", "select_into", "select_from",
  "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "opt_default_time_precision",
  "opt_time_precision", "optional_braces", "expr", "bool_pri", "predicate",
  "bit_expr", "or", "and", "not", "not2", "comp_op", "all_or_any",
  "opt_dyncol_type", "dyncol_type", "dyncall_create_element",
  "dyncall_create_list", "simple_expr", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "geometry_function", "function_call_generic", "@106", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "$@107", "$@108", "$@109",
  "variable", "$@110", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "$@111", "gorder_list",
  "in_sum_expr", "$@112", "cast_type", "$@113", "opt_expr_list",
  "expr_list", "ident_list_arg", "ident_list", "opt_expr", "opt_else",
  "when_list", "table_ref", "join_table_list", "esc_table_ref",
  "derived_table_list", "join_table", "$@114", "$@115", "$@116", "$@117",
  "$@118", "$@119", "inner_join", "normal_join", "opt_use_partition",
  "use_partition", "table_factor", "$@120", "select_derived_union",
  "$@121", "$@122", "select_init2_derived", "select_part2_derived",
  "$@123", "$@124", "select_derived", "$@125", "select_derived2", "$@126",
  "$@127", "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@128",
  "$@129", "index_hints_list", "opt_index_hints_list", "$@130",
  "opt_key_definition", "$@131", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@132", "having_clause", "$@133", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@134", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "limit_rows_option",
  "delete_limit_clause", "int_num", "ulong_num", "real_ulong_num",
  "ulonglong_num", "real_ulonglong_num", "dec_num_error", "dec_num",
  "choice", "procedure_clause", "$@135", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@136",
  "select_var_list", "select_var_ident", "into", "$@137",
  "into_destination", "$@138", "$@139", "do", "$@140", "drop", "$@141",
  "$@142", "$@143", "table_list", "table_name",
  "table_name_with_opt_use_partition", "table_alias_ref_list",
  "table_alias_ref", "opt_if_exists", "opt_temporary", "insert", "$@144",
  "$@145", "replace", "$@146", "$@147", "insert_lock_option",
  "replace_lock_option", "insert2", "insert_table", "insert_field_spec",
  "$@148", "fields", "insert_values", "$@149", "$@150", "values_list",
  "ident_eq_list", "ident_eq_value", "equal", "opt_equal", "no_braces",
  "$@151", "opt_values", "values", "expr_or_default", "opt_insert_update",
  "$@152", "update", "$@153", "$@154", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@155", "single_multi", "$@156", "$@157", "$@158", "$@159",
  "opt_select_expressions", "table_wild_list", "table_wild_one",
  "opt_wild", "opt_delete_options", "opt_delete_option", "truncate",
  "$@160", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@161", "show_param",
  "$@162", "$@163", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@164", "$@165", "explainable_command",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "$@166", "flush_options", "$@167", "$@168",
  "opt_with_read_lock", "flush_options_list", "flush_option",
  "opt_table_list", "optional_flush_tables_arguments", "reset", "$@169",
  "reset_options", "reset_option", "$@170", "slave_reset_options", "purge",
  "$@171", "purge_options", "purge_option", "kill", "$@172", "kill_type",
  "kill_option", "kill_expr", "shutdown", "use", "load", "$@173", "$@174",
  "$@175", "$@176", "data_or_xml", "opt_local", "load_data_lock",
  "opt_duplicate", "opt_field_term", "field_term_list", "field_term",
  "opt_line_term", "line_term_list", "line_term",
  "opt_xml_rows_identified_by", "opt_ignore_lines", "lines_or_rows",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "load_data_set_list", "load_data_set_elem",
  "text_literal", "text_string", "param_marker", "signed_literal",
  "literal", "NUM_literal", "temporal_literal", "insert_ident",
  "table_wild", "order_ident", "simple_ident", "simple_ident_nospvar",
  "simple_ident_q", "field_ident", "table_ident", "table_ident_opt_wild",
  "table_ident_nodb", "IDENT_sys", "TEXT_STRING_sys",
  "TEXT_STRING_literal", "TEXT_STRING_filesystem", "ident", "label_ident",
  "ident_or_text", "user", "user_or_role", "keyword", "keyword_sp", "set",
  "$@177", "start_option_value_list", "$@178", "$@179", "$@180",
  "start_option_value_list_following_option_type", "$@181",
  "option_value_list_continued", "option_value_list", "$@182", "$@183",
  "option_value", "$@184", "option_type", "opt_var_type",
  "opt_var_ident_type", "option_value_following_option_type",
  "option_value_no_option_type", "internal_variable_name",
  "transaction_characteristics", "transaction_access_mode",
  "isolation_level", "transaction_access_mode_types", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@185",
  "table_or_tables", "table_lock_list", "table_lock", "lock_option",
  "unlock", "$@186", "handler", "$@187", "handler_read_or_scan",
  "handler_scan_function", "handler_rkey_function", "$@188",
  "handler_rkey_mode", "revoke", "revoke_command", "admin_option_for_role",
  "grant", "grant_command", "opt_with_admin", "opt_with_admin_option",
  "role_list", "current_role", "grant_role", "opt_table",
  "grant_privileges", "opt_privileges", "object_privilege_list",
  "object_privilege", "$@189", "$@190", "$@191", "$@192", "opt_and",
  "require_list", "require_list_element", "grant_ident", "user_list",
  "grant_list", "user_and_role_list", "via_or_with", "using_or_as",
  "grant_user", "opt_column_list", "column_list", "column_list_id",
  "require_clause", "grant_options", "opt_grant_option",
  "grant_option_list", "grant_option", "begin", "$@193", "opt_work",
  "opt_chain", "opt_release", "opt_savepoint", "commit", "rollback",
  "savepoint", "release", "union_clause", "union_list", "$@194",
  "union_opt", "opt_union_order_or_limit", "union_order_or_limit", "$@195",
  "order_or_limit", "union_option", "query_specification",
  "query_expression_body", "$@196", "subselect", "subselect_start",
  "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_replace_or_algorithm",
  "view_replace", "view_algorithm", "view_suid", "view_tail", "$@197",
  "view_list_opt", "view_list", "view_select", "$@198", "view_select_aux",
  "view_check_option", "trigger_tail", "$@199", "$@200", "$@201",
  "udf_tail", "sf_tail", "$@202", "$@203", "$@204", "$@205", "$@206",
  "sp_tail", "$@207", "$@208", "$@209", "$@210", "xa", "xid",
  "begin_or_start", "opt_join_or_resume", "opt_one_phase", "opt_suspend",
  "$@211", "opt_migrate", "install", "uninstall", "keep_gcc_happy", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   124,    38,    45,    43,    42,    47,    37,
      94,   126,    40,    41,    44,    33,   123,   125,    59,    64,
      46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   662,   663,   664,   663,   663,   665,   665,   666,   666,
     667,   667,   667,   667,   667,   667,   667,   667,   667,   667,
     667,   667,   667,   667,   667,   667,   667,   667,   667,   667,
     667,   667,   667,   667,   667,   667,   667,   667,   667,   667,
     667,   667,   667,   667,   667,   667,   667,   667,   667,   667,
     667,   667,   667,   667,   667,   667,   667,   667,   667,   667,
     667,   667,   667,   667,   667,   668,   669,   669,   670,   671,
     671,   673,   672,   674,   674,   675,   675,   676,   678,   677,
     680,   679,   681,   681,   682,   682,   682,   682,   682,   682,
     682,   682,   682,   682,   682,   682,   682,   682,   682,   682,
     682,   683,   683,   683,   684,   685,   685,   685,   685,   685,
     685,   685,   686,   686,   687,   689,   688,   690,   691,   688,
     692,   693,   688,   694,   695,   688,   696,   688,   697,   688,
     688,   688,   688,   688,   688,   698,   699,   699,   700,   700,
     700,   700,   700,   700,   700,   702,   701,   704,   703,   703,
     705,   705,   705,   705,   706,   706,   707,   707,   708,   708,
     709,   709,   710,   710,   712,   711,   713,   713,   713,   713,
     713,   713,   713,   713,   713,   713,   713,   713,   713,   714,
     715,   715,   716,   716,   717,   717,   718,   718,   718,   718,
     718,   718,   718,   719,   719,   719,   720,   720,   722,   721,
     723,   723,   724,   724,   725,   725,   726,   726,   727,   727,
     728,   729,   730,   730,   731,   731,   732,   733,   733,   733,
     733,   734,   734,   735,   735,   736,   736,   738,   737,   737,
     739,   737,   737,   741,   740,   742,   742,   743,   743,   744,
     745,   745,   746,   747,   747,   748,   748,   748,   748,   748,
     749,   750,   750,   751,   751,   752,   752,   753,   753,   754,
     754,   754,   755,   755,   755,   755,   755,   755,   755,   755,
     755,   755,   755,   755,   756,   757,   758,   758,   759,   759,
     760,   760,   761,   762,   762,   763,   763,   764,   765,   765,
     766,   767,   767,   767,   767,   767,   767,   767,   767,   767,
     767,   767,   767,   767,   768,   768,   769,   769,   770,   770,
     770,   770,   770,   770,   770,   770,   770,   770,   770,   770,
     770,   772,   771,   774,   773,   776,   775,   778,   777,   779,
     780,   781,   783,   782,   784,   785,   785,   785,   786,   786,
     788,   789,   790,   787,   791,   791,   791,   792,   792,   794,
     795,   793,   797,   796,   798,   798,   799,   799,   801,   802,
     800,   804,   805,   803,   806,   806,   808,   807,   809,   809,
     811,   810,   813,   812,   815,   814,   816,   817,   818,   816,
     819,   816,   820,   820,   821,   821,   821,   822,   823,   824,
     825,   825,   826,   826,   827,   828,   829,   829,   831,   830,
     832,   832,   832,   833,   833,   833,   834,   835,   835,   835,
     836,   836,   836,   836,   836,   836,   836,   836,   837,   838,
     838,   838,   839,   839,   839,   839,   839,   840,   841,   841,
     841,   842,   842,   842,   842,   842,   842,   842,   843,   844,
     844,   844,   845,   845,   845,   846,   847,   848,   849,   850,
     851,   851,   851,   852,   853,   854,   855,   856,   857,   858,
     859,   860,   861,   861,   862,   862,   863,   863,   865,   864,
     864,   866,   864,   864,   867,   867,   868,   869,   868,   870,
     868,   871,   872,   872,   874,   873,   875,   877,   876,   878,
     879,   880,   879,   879,   879,   879,   879,   881,   881,   882,
     882,   883,   883,   884,   884,   885,   886,   887,   888,   889,
     889,   890,   891,   890,   892,   890,   893,   893,   894,   895,
     896,   896,   897,   897,   898,   898,   900,   899,   901,   902,
     903,   902,   904,   902,   905,   905,   906,   906,   907,   907,
     909,   910,   908,   911,   911,   912,   912,   913,   913,   914,
     914,   916,   915,   917,   918,   918,   919,   919,   920,   920,
     920,   920,   920,   920,   920,   920,   920,   922,   923,   921,
     924,   924,   925,   925,   926,   926,   927,   927,   928,   928,
     929,   929,   930,   931,   931,   932,   932,   933,   933,   934,
     934,   934,   935,   935,   935,   935,   935,   935,   935,   935,
     935,   935,   935,   935,   935,   935,   935,   935,   935,   935,
     935,   935,   936,   935,   935,   935,   935,   935,   935,   935,
     935,   935,   935,   935,   935,   935,   935,   935,   935,   937,
     938,   939,   940,   941,   941,   941,   941,   941,   941,   941,
     942,   942,   942,   943,   943,   944,   944,   944,   944,   945,
     946,   946,   947,   947,   948,   948,   950,   949,   951,   949,
     952,   949,   953,   949,   949,   949,   954,   954,   955,   956,
     956,   957,   959,   958,   960,   960,   961,   961,   962,   962,
     962,   963,   963,   964,   964,   965,   965,   965,   966,   967,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   968,   968,   968,   968,   968,
     968,   968,   968,   968,   968,   969,   968,   970,   968,   968,
     968,   971,   971,   971,   971,   971,   971,   971,   971,   972,
     973,   973,   974,   974,   975,   975,   975,   975,   975,   976,
     976,   976,   976,   976,   977,   977,   977,   978,   978,   978,
     979,   980,   980,   981,   981,   982,   982,   982,   983,   983,
     983,   983,   984,   984,   985,   985,   986,   986,   987,   987,
     988,   988,   988,   988,   988,   988,   988,   988,   988,   988,
     988,   988,   988,   988,   988,   989,   990,   990,   991,   991,
     992,   992,   993,   993,   994,   994,   995,   995,   996,   996,
     997,   997,   998,   999,   999,  1000,  1000,  1001,  1001,  1002,
    1002,  1002,  1003,  1003,  1003,  1004,  1004,  1004,  1004,  1004,
    1004,  1004,  1005,  1005,  1007,  1006,  1008,  1008,  1009,  1010,
    1010,  1010,  1010,  1011,  1012,  1013,  1013,  1014,  1015,  1015,
    1016,  1016,  1017,  1017,  1018,  1019,  1019,  1020,  1020,  1021,
    1021,  1021,  1021,  1022,  1022,  1022,  1022,  1022,  1023,  1023,
    1023,  1023,  1023,  1024,  1025,  1025,  1026,  1026,  1027,  1027,
    1028,  1028,  1028,  1029,  1029,  1030,  1031,  1032,  1033,  1033,
    1034,  1034,  1035,  1035,  1036,  1036,  1037,  1037,  1038,  1038,
    1039,  1039,  1040,  1040,  1041,  1041,  1041,  1041,  1041,  1041,
    1042,  1042,  1043,  1044,  1044,  1045,  1045,  1045,  1046,  1046,
    1047,  1047,  1048,  1048,  1049,  1050,  1050,  1051,  1051,  1053,
    1054,  1052,  1055,  1052,  1052,  1056,  1052,  1057,  1052,  1058,
    1052,  1059,  1052,  1060,  1052,  1052,  1052,  1052,  1052,  1052,
    1061,  1061,  1061,  1061,  1062,  1062,  1063,  1063,  1064,  1064,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1066,  1065,  1065,  1067,  1065,  1068,  1065,  1065,  1065,  1065,
    1065,  1069,  1070,  1070,  1072,  1071,  1073,  1073,  1073,  1075,
    1074,  1076,  1077,  1076,  1078,  1078,  1079,  1080,  1080,  1081,
    1082,  1082,  1082,  1083,  1082,  1084,  1085,  1082,  1082,  1082,
    1082,  1082,  1082,  1082,  1082,  1082,  1082,  1082,  1082,  1082,
    1082,  1082,  1082,  1086,  1086,  1086,  1086,  1086,  1087,  1087,
    1088,  1088,  1089,  1089,  1090,  1090,  1092,  1091,  1093,  1093,
    1094,  1094,  1095,  1095,  1096,  1096,  1096,  1097,  1097,  1097,
    1098,  1098,  1098,  1098,  1100,  1099,  1101,  1099,  1099,  1099,
    1102,  1103,  1103,  1104,  1104,  1105,  1105,  1105,  1107,  1106,
    1108,  1108,  1109,  1109,  1109,  1110,  1110,  1110,  1111,  1111,
    1113,  1112,  1114,  1114,  1114,  1116,  1115,  1117,  1117,  1118,
    1118,  1119,  1119,  1119,  1121,  1120,  1122,  1122,  1123,  1124,
    1124,  1125,  1125,  1126,  1127,  1126,  1128,  1129,  1128,  1130,
    1130,  1130,  1131,  1131,  1131,  1132,  1132,  1133,  1135,  1134,
    1136,  1136,  1137,  1137,  1138,  1138,  1138,  1138,  1138,  1138,
    1140,  1139,  1141,  1141,  1141,  1143,  1142,  1142,  1144,  1144,
    1145,  1145,  1146,  1148,  1147,  1149,  1149,  1150,  1150,  1151,
    1152,  1153,  1153,  1155,  1154,  1156,  1156,  1157,  1157,  1158,
    1159,  1161,  1160,  1163,  1162,  1164,  1164,  1165,  1165,  1166,
    1167,  1167,  1168,  1168,  1169,  1169,  1171,  1170,  1173,  1174,
    1172,  1175,  1175,  1175,  1175,  1175,  1176,  1176,  1177,  1177,
    1178,  1178,  1179,  1179,  1179,  1180,  1180,  1180,  1181,  1181,
    1181,  1182,  1182,  1183,  1184,  1185,  1185,  1185,  1185,  1185,
    1186,  1186,  1186,  1187,  1187,  1187,  1188,  1188,  1189,  1189,
    1189,  1189,  1189,  1189,  1189,  1189,  1189,  1189,  1189,  1190,
    1190,  1190,  1190,  1190,  1190,  1191,  1191,  1191,  1191,  1191,
    1191,  1191,  1191,  1191,  1191,  1191,  1191,  1191,  1191,  1192,
    1192,  1192,  1192,  1192,  1192,  1192,  1192,  1192,  1192,  1192,
    1192,  1192,  1192,  1192,  1193,  1193,  1194,  1194,  1195,  1195,
    1196,  1196,  1197,  1197,  1197,  1197,  1197,  1197,  1198,  1198,
    1199,  1199,  1200,  1200,  1200,  1200,  1200,  1200,  1200,  1200,
    1200,  1200,  1200,  1201,  1202,  1202,  1203,  1203,  1203,  1203,
    1203,  1203,  1203,  1203,  1203,  1203,  1203,  1203,  1203,  1203,
    1203,  1203,  1203,  1203,  1203,  1203,  1203,  1203,  1203,  1203,
    1203,  1203,  1203,  1203,  1203,  1203,  1204,  1204,  1204,  1204,
    1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,
    1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,  1204,
    1204,  1204,  1204,  1204,  1205,  1205,  1205,  1205,  1205,  1205,
    1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,
    1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,  1205,
    1205,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1207,  1207,  1207,  1207,  1207,
    1207,  1207,  1207,  1209,  1208,  1208,  1210,  1210,  1211,  1211,
    1212,  1212,  1213,  1213,  1214,  1214,  1215,  1216,  1216,  1216,
    1216,  1216,  1216,  1216,  1217,  1218,  1216,  1216,  1216,  1216,
    1216,  1216,  1216,  1216,  1216,  1216,  1216,  1219,  1216,  1221,
    1220,  1222,  1222,  1222,  1223,  1223,  1224,  1224,  1225,  1226,
    1225,  1227,  1227,  1229,  1228,  1230,  1230,  1230,  1230,  1230,
    1230,  1230,  1230,  1230,  1230,  1230,  1230,  1231,  1230,  1232,
    1232,  1233,  1233,  1234,  1234,  1235,  1235,  1236,  1236,  1237,
    1237,  1238,  1238,  1239,  1239,  1240,  1241,  1241,  1242,  1242,
    1243,  1244,  1243,  1245,  1243,  1243,  1246,  1243,  1247,  1243,
    1243,  1248,  1243,  1249,  1243,  1243,  1250,  1250,  1250,  1251,
    1251,  1252,  1252,  1253,  1255,  1254,  1254,  1254,  1256,  1257,
    1258,  1256,  1259,  1261,  1262,  1260,  1264,  1263,  1266,  1267,
    1265,  1268,  1269,  1270,  1270,  1271,  1271,  1271,  1271,  1272,
    1272,  1274,  1273,  1275,  1273,  1276,  1276,  1277,  1278,  1277,
    1280,  1279,  1281,  1281,  1282,  1282,  1283,  1283,  1284,  1284,
    1285,  1285,  1285,  1285,  1285,  1285,  1285,  1285,  1285,  1285,
    1285,  1285,  1286,  1286,  1286,  1286,  1286,  1286,  1286,  1286,
    1286,  1287,  1287,  1287,  1287,  1288,  1288,  1288,  1289,  1289,
    1290,  1290,  1291,  1292,  1291,  1293,  1294,  1293,  1295,  1295,
    1296,  1296,  1297,  1297,  1298,  1298,  1298,  1299,  1300,  1300,
    1301,  1302,  1302,  1304,  1303,  1305,  1305,  1306,  1306,  1306,
    1307,  1307,  1308,  1308,  1309,  1309,  1309,  1310,  1310,  1310,
    1311,  1311,  1311,  1311,  1311,  1312,  1313,  1313,  1313,  1313,
    1314,  1314,  1314,  1315,  1315,  1315,  1315,  1315,  1315,  1316,
    1316,  1316,  1316,  1316,  1317,  1317,  1317,  1317,  1317,  1318,
    1318,  1318,  1318,  1318,  1319,  1320,  1320,  1321,  1321,  1322,
    1323,  1322,  1324,  1324,  1325,  1325,  1326,  1328,  1327,  1329,
    1329,  1330,  1330,  1332,  1331,  1334,  1335,  1333,  1333,  1333,
    1337,  1336,  1339,  1338,  1340,  1338,  1338,  1338,  1338,  1338,
    1338,  1338,  1341,  1338,  1338,  1338,  1338,  1338,  1338,  1342,
    1342,  1343,  1344,  1345,  1345,  1346,  1347,  1347,  1348,  1348,
    1350,  1351,  1349,  1353,  1354,  1352,  1355,  1355,  1355,  1355,
    1356,  1356,  1357,  1357,  1358,  1359,  1359,  1359,  1360,  1359,
    1361,  1361,  1362,  1362,  1363,  1362,  1364,  1362,  1365,  1365,
    1366,  1366,  1367,  1368,  1368,  1369,  1369,  1371,  1370,  1372,
    1372,  1373,  1373,  1374,  1374,  1375,  1376,  1375,  1378,  1379,
    1377,  1380,  1380,  1381,  1382,  1382,  1383,  1384,  1384,  1386,
    1385,  1388,  1389,  1387,  1390,  1387,  1391,  1387,  1392,  1392,
    1393,  1393,  1394,  1394,  1395,  1395,  1396,  1396,  1397,  1397,
    1397,  1399,  1398,  1400,  1400,  1401,  1401,  1402,  1402,  1403,
    1403,  1403,  1403,  1403,  1403,  1403,  1403,  1403,  1404,  1404,
    1406,  1405,  1407,  1407,  1407,  1407,  1407,  1407,  1407,  1407,
    1407,  1407,  1407,  1407,  1407,  1407,  1408,  1407,  1409,  1407,
    1407,  1407,  1407,  1407,  1407,  1407,  1407,  1407,  1407,  1407,
    1407,  1407,  1407,  1407,  1407,  1407,  1407,  1407,  1407,  1407,
    1407,  1407,  1407,  1407,  1407,  1407,  1407,  1407,  1407,  1407,
    1407,  1407,  1407,  1407,  1407,  1407,  1407,  1407,  1410,  1410,
    1410,  1411,  1411,  1412,  1412,  1413,  1413,  1414,  1414,  1415,
    1415,  1416,  1416,  1417,  1417,  1418,  1418,  1418,  1420,  1419,
    1421,  1419,  1422,  1422,  1422,  1422,  1422,  1423,  1423,  1424,
    1424,  1424,  1425,  1425,  1425,  1427,  1426,  1429,  1430,  1428,
    1428,  1431,  1431,  1432,  1432,  1433,  1433,  1433,  1433,  1433,
    1433,  1433,  1433,  1433,  1433,  1433,  1433,  1433,  1433,  1433,
    1433,  1433,  1433,  1433,  1434,  1434,  1435,  1435,  1437,  1436,
    1438,  1438,  1440,  1439,  1439,  1439,  1441,  1441,  1443,  1442,
    1444,  1445,  1445,  1447,  1446,  1448,  1448,  1448,  1449,  1449,
    1449,  1449,  1450,  1450,  1451,  1452,  1454,  1455,  1456,  1457,
    1453,  1458,  1458,  1459,  1459,  1460,  1460,  1460,  1461,  1461,
    1461,  1462,  1462,  1463,  1463,  1464,  1464,  1464,  1464,  1465,
    1465,  1466,  1466,  1467,  1467,  1468,  1468,  1469,  1469,  1470,
    1470,  1471,  1471,  1471,  1472,  1472,  1473,  1473,  1474,  1474,
    1475,  1475,  1476,  1477,  1477,  1477,  1477,  1478,  1478,  1478,
    1478,  1479,  1480,  1480,  1480,  1481,  1481,  1481,  1481,  1481,
    1481,  1481,  1481,  1481,  1481,  1481,  1482,  1482,  1482,  1482,
    1482,  1483,  1483,  1483,  1484,  1484,  1485,  1485,  1486,  1487,
    1487,  1488,  1488,  1489,  1489,  1489,  1490,  1490,  1490,  1490,
    1491,  1491,  1491,  1492,  1492,  1493,  1494,  1494,  1495,  1496,
    1497,  1498,  1498,  1499,  1499,  1500,  1500,  1500,  1501,  1501,
    1501,  1502,  1502,  1503,  1503,  1503,  1503,  1503,  1503,  1503,
    1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,
    1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,
    1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,
    1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,
    1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,  1503,
    1503,  1503,  1503,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1504,  1504,  1506,  1505,  1508,  1507,  1509,  1507,  1510,  1507,
    1512,  1511,  1511,  1513,  1513,  1515,  1514,  1516,  1514,  1518,
    1517,  1517,  1519,  1519,  1519,  1520,  1520,  1520,  1520,  1521,
    1521,  1521,  1521,  1522,  1523,  1523,  1523,  1523,  1523,  1523,
    1523,  1523,  1523,  1524,  1524,  1524,  1525,  1525,  1525,  1525,
    1526,  1527,  1528,  1528,  1529,  1529,  1529,  1529,  1530,  1530,
    1530,  1531,  1531,  1531,  1531,  1531,  1533,  1532,  1534,  1534,
    1535,  1535,  1536,  1537,  1537,  1537,  1537,  1537,  1539,  1538,
    1540,  1540,  1541,  1540,  1542,  1542,  1543,  1543,  1544,  1544,
    1544,  1544,  1545,  1544,  1546,  1546,  1546,  1546,  1546,  1547,
    1548,  1548,  1548,  1548,  1548,  1548,  1549,  1549,  1550,  1551,
    1551,  1551,  1551,  1551,  1552,  1552,  1553,  1553,  1554,  1554,
    1555,  1556,  1556,  1557,  1557,  1558,  1558,  1559,  1559,  1560,
    1560,  1562,  1561,  1563,  1561,  1564,  1561,  1565,  1561,  1561,
    1561,  1561,  1561,  1561,  1561,  1561,  1561,  1561,  1561,  1561,
    1561,  1561,  1561,  1561,  1561,  1561,  1561,  1561,  1561,  1561,
    1561,  1561,  1561,  1561,  1561,  1566,  1566,  1567,  1567,  1568,
    1568,  1568,  1569,  1569,  1569,  1569,  1570,  1570,  1571,  1571,
    1572,  1572,  1573,  1573,  1574,  1574,  1575,  1575,  1575,  1575,
    1575,  1576,  1576,  1577,  1577,  1578,  1579,  1579,  1579,  1579,
    1579,  1580,  1580,  1581,  1581,  1582,  1582,  1583,  1583,  1583,
    1583,  1583,  1585,  1584,  1586,  1586,  1587,  1587,  1587,  1588,
    1588,  1588,  1589,  1589,  1590,  1591,  1591,  1592,  1593,  1594,
    1594,  1596,  1595,  1597,  1597,  1597,  1598,  1598,  1600,  1599,
    1601,  1601,  1602,  1602,  1602,  1603,  1603,  1604,  1605,  1604,
    1606,  1607,  1608,  1609,  1609,  1610,  1610,  1611,  1611,  1611,
    1611,  1611,  1611,  1611,  1611,  1612,  1612,  1612,  1613,  1613,
    1613,  1613,  1613,  1614,  1614,  1614,  1614,  1614,  1614,  1615,
    1615,  1616,  1617,  1618,  1618,  1618,  1619,  1620,  1620,  1620,
    1621,  1621,  1621,  1623,  1622,  1624,  1624,  1625,  1625,  1627,
    1626,  1628,  1628,  1629,  1629,  1629,  1629,  1631,  1632,  1633,
    1630,  1634,  1634,  1636,  1637,  1638,  1639,  1640,  1635,  1642,
    1643,  1644,  1645,  1641,  1646,  1646,  1646,  1646,  1646,  1646,
    1647,  1647,  1647,  1648,  1648,  1649,  1649,  1649,  1650,  1650,
    1651,  1652,  1651,  1653,  1653,  1654,  1654,  1655,  1655,  1656
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     4,     1,
       2,     0,     4,     0,     2,     3,     1,     2,     0,     3,
       0,     6,     1,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       1,     0,     1,     3,     1,     3,     3,     3,     3,     3,
       3,     3,     0,     1,     1,     0,     7,     0,     0,    15,
       0,     0,    15,     0,     0,    15,     0,     6,     0,     3,
       4,     5,     4,     3,     2,    10,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     0,    13,     0,     6,     2,
       0,     1,     3,     1,     0,     2,     0,     2,     0,     1,
       3,     4,     0,     2,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     1,     0,     2,     0,     2,     2,     2,     2,     2,
       3,     3,     1,     1,     1,     2,     3,     3,     0,     4,
       0,     3,     0,     1,     3,     1,     0,     1,     3,     1,
       0,     3,     0,     1,     3,     1,     4,     0,     1,     1,
       1,     0,     3,     2,     3,     0,     3,     0,     5,     5,
       0,     7,     5,     0,     2,     1,     1,     1,     3,     1,
       1,     1,     3,     0,     1,     1,     1,     1,     2,     1,
       3,     1,     1,     0,     1,     0,     2,     3,     5,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     4,     0,     1,     1,     3,
       1,     3,     3,     1,     2,     1,     1,     1,     1,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     0,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     5,     0,     2,     0,     3,     0,     2,     2,
       2,     2,     0,     6,     2,     0,     2,     1,     1,     3,
       0,     0,     0,     7,     0,     2,     2,     1,     1,     0,
       0,     8,     0,     6,     1,     2,     1,     2,     0,     0,
       6,     0,     0,     6,     0,     2,     0,     5,     0,     1,
       0,     5,     0,     2,     0,     5,     4,     0,     0,     8,
       0,     7,     1,     1,     1,     1,     1,     2,     4,     5,
       0,     4,     4,     4,     3,     3,     2,     2,     0,     2,
       1,     2,     3,     1,     1,     1,     1,     1,     2,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     1,     1,     2,     2,     2,     1,     1,
       1,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     4,     0,     1,     1,     1,     1,     1,     0,     7,
       3,     0,     5,     1,     2,     4,     0,     0,     5,     0,
       7,     1,     0,     1,     0,     4,     0,     0,     3,     5,
       6,     0,     4,     2,     2,     2,     2,     0,     1,     0,
       3,     0,     1,     1,     3,     1,     4,     5,     5,     0,
       2,     0,     0,     7,     0,    10,     1,     3,     1,     1,
       0,     2,     0,     3,     1,     3,     0,     6,     1,     0,
       0,     5,     0,     4,     1,     1,     1,     3,     1,     3,
       0,     0,     5,     1,     3,     1,     1,     0,     3,     1,
       3,     0,     4,     1,     0,     1,     2,     1,     3,     4,
       3,     3,     3,     3,     4,     4,     3,     0,     0,     6,
       0,     1,     0,     1,     1,     2,     1,     1,     0,     1,
       1,     2,     1,     0,     3,     0,     1,     1,     2,     1,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     0,     6,     1,     1,     3,     4,     4,     2,
       2,     2,     3,     3,     3,     3,     3,     3,     3,     4,
       4,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     3,     1,     1,     2,     2,     0,     8,     0,     9,
       0,     9,     0,     9,     8,     2,     0,     1,     4,     0,
       1,     2,     0,     3,     2,     8,     0,     2,     0,     1,
       1,     0,     1,     2,     1,     1,     2,     2,     4,     3,
       3,     3,     3,     1,     2,     1,     1,     3,     2,     3,
       2,     2,     1,     3,     3,     2,     3,     1,     2,     2,
       2,     1,     2,     1,     1,     1,     2,     3,     2,     3,
       2,     2,     3,     3,     3,     0,     6,     0,     6,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     1,     2,     1,     2,     3,     2,     1,
       1,     1,     1,     1,     1,     1,     2,     0,     1,     1,
       5,     0,     1,     2,     1,     1,     1,     1,     3,     3,
       3,     3,     0,     1,     0,     1,     0,     1,     2,     1,
       1,     2,     2,     4,     1,     3,     2,     1,     2,     2,
       2,     3,     3,     3,     3,     2,     2,     1,     1,     1,
       2,     1,     1,     1,     1,     1,     0,     2,     1,     1,
       1,     1,     1,     0,     2,     1,     1,     0,     1,     1,
       2,     2,     1,     2,     2,     0,     1,     1,     1,     3,
       1,     3,     0,     1,     0,     4,     1,     1,     1,     0,
       1,     2,     1,     1,     2,     1,     3,     3,     1,     1,
       0,     2,     0,     1,     5,     0,     3,     3,     1,     0,
       2,     2,     2,     0,     3,     3,     6,     6,     1,     1,
       2,     2,     2,     1,     2,     2,     1,     1,     0,     1,
       1,     1,     1,     0,     1,     1,     1,     0,     1,     2,
       0,     1,     0,     1,     0,     1,     1,     2,     1,     2,
       1,     2,     2,     2,     3,     2,     3,     3,     3,     3,
       1,     1,     1,     1,     3,     1,     1,     1,     4,     2,
       1,     4,     0,     1,     2,     0,     2,     1,     3,     0,
       0,     7,     0,     5,     7,     0,     5,     0,     5,     0,
       5,     0,     4,     0,    10,     3,     4,     3,     3,     7,
       0,     3,     1,     4,     0,     3,     0,     2,     0,     1,
       0,     2,     2,     2,     2,     1,     1,     1,     4,     4,
       0,     6,     4,     0,     5,     0,     6,     4,     3,     1,
       7,     2,     1,     1,     0,     6,     0,     3,     2,     0,
       5,     0,     0,     6,     1,     3,     1,     1,     3,     3,
       3,     2,     4,     0,     7,     0,     0,     8,     5,     5,
       3,     4,     2,     2,     6,     5,     3,     5,     1,     1,
       1,     1,     1,     0,     1,     1,     2,     2,     3,     3,
       3,     3,     0,     1,     0,     1,     0,     2,     0,     1,
       2,     1,     1,     1,     0,     1,     1,     0,     2,     1,
       0,     1,     1,     1,     0,     6,     0,     5,     4,     4,
       3,     0,     1,     1,     3,     3,     2,     2,     0,     2,
       1,     3,     0,     1,     1,     0,     2,     4,     1,     3,
       0,     5,     0,     1,     1,     0,     6,     0,     1,     1,
       2,     1,     1,     1,     0,     5,     1,     3,     2,     0,
       3,     1,     4,     1,     0,     4,     1,     0,     4,     0,
       1,     3,     0,     1,     3,     1,     1,     2,     0,     5,
       0,     1,     1,     2,     1,     1,     1,     1,     1,     2,
       0,     5,     0,     1,     1,     0,     4,     4,     3,     5,
       1,     3,     3,     0,     6,     1,     1,     1,     3,     2,
       3,     1,     1,     0,     6,     1,     1,     1,     3,     3,
       4,     0,     6,     0,     2,     0,     4,     0,     2,     1,
       2,     4,     2,     3,     2,     3,     0,     3,     0,     0,
       6,     2,     1,     1,     2,     2,     8,     4,     0,     1,
       2,     1,     1,     1,     1,     0,     2,     4,     3,     1,
       1,     3,     4,     0,     0,     0,     2,     2,     1,     1,
       0,     2,     3,     0,     2,     3,     0,     2,     3,     3,
       3,     2,     3,     4,     3,     4,     3,     4,     1,     3,
       4,     3,     3,     6,     1,     5,     6,     5,     7,     6,
       8,     5,     6,     4,     4,     5,     3,     4,     1,     3,
       3,     3,     3,     3,     3,     5,     5,     3,     3,     3,
       3,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     2,     1,     2,     1,     1,     1,     2,     2,     1,
       1,     2,     2,     4,     1,     3,     1,     1,     1,     1,
       1,     3,     1,     1,     1,     1,     3,     2,     2,     2,
       2,     3,     3,     5,     6,     4,     4,     7,     2,     6,
       5,     6,     6,     4,     4,     5,     4,     6,     2,     2,
       4,     4,     4,    10,     6,     8,     6,     4,     4,     6,
       4,     4,     4,     6,     4,     7,     7,     7,     6,     6,
       6,     6,     3,     4,     6,     8,     2,     2,     8,     8,
       6,     6,     2,     6,     6,     8,     8,     6,     8,     6,
       2,     8,     8,     2,     2,     2,     6,     6,     4,     4,
       8,     4,     4,     4,     4,     3,     8,     4,     4,     6,
       4,     4,     4,     6,     8,     4,     3,     6,     4,     6,
       5,     8,     7,    10,     1,     6,     4,     4,     4,     4,
       4,     6,     4,     0,     5,     6,     2,     3,     0,     4,
       0,     3,     0,     1,     1,     3,     4,     4,     5,     4,
       4,     4,     5,     4,     0,     0,     7,     4,     5,     4,
       5,     4,     4,     4,     4,     4,     5,     0,     8,     0,
       3,     3,     1,     4,     0,     1,     0,     2,     0,     0,
       4,     4,     2,     0,     3,     2,     3,     2,     1,     1,
       2,     1,     2,     1,     2,     2,     2,     0,     3,     0,
       1,     1,     3,     1,     3,     1,     3,     0,     1,     0,
       2,     4,     5,     1,     1,     1,     1,     4,     1,     3,
       3,     0,     6,     0,     8,     4,     0,     8,     0,    10,
       6,     0,     8,     0,    10,     6,     1,     2,     1,     1,
       2,     0,     1,     5,     0,     5,     3,     5,     2,     0,
       0,     7,     1,     0,     0,     6,     0,     3,     0,     0,
       5,     0,     1,     0,     1,     0,     2,     3,     3,     1,
       1,     0,     7,     0,     7,     1,     2,     0,     0,     2,
       0,     2,     0,     1,     1,     1,     1,     3,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     0,     2,
       0,     1,     0,     0,     3,     0,     0,     3,     2,     0,
       0,     4,     4,     2,     0,     1,     1,     3,     3,     1,
       2,     0,     1,     0,     4,     4,     2,     0,     1,     1,
       0,     1,     0,     1,     2,     5,     4,     1,     3,     3,
       1,     1,     1,     1,     1,     1,     0,     2,     3,     4,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       0,     6,     0,     1,     3,     1,     3,     0,     2,     3,
       1,     2,     1,     0,     3,     0,     0,     7,     2,     1,
       0,     3,     0,     7,     0,     7,     4,     6,     4,     4,
       4,     4,     0,     6,     4,     4,     5,     6,     4,     1,
       3,     1,     2,     1,     3,     1,     0,     2,     0,     1,
       0,     0,     8,     0,     0,     6,     0,     1,     1,     1,
       1,     1,     2,     1,     1,     1,     3,     4,     0,     3,
       3,     1,     2,     2,     0,     3,     0,     5,     3,     1,
       3,     1,     3,     1,     1,     0,     1,     0,     4,     0,
       1,     3,     1,     1,     1,     0,     0,     6,     0,     0,
      11,     3,     1,     3,     3,     1,     3,     0,     1,     0,
       4,     0,     0,     9,     0,     5,     0,     6,     0,     2,
       1,     3,     2,     4,     0,     2,     0,     2,     1,     1,
       1,     0,     4,     0,     1,     0,     1,     1,     3,     1,
       1,     2,     2,     2,     1,     1,     1,     1,     0,     3,
       0,     3,     2,     4,     4,     3,     4,     4,     1,     3,
       3,     3,     3,     6,     2,     2,     0,     6,     0,     7,
       5,     2,     1,     1,     1,     5,     5,     2,     2,     1,
       4,     3,     2,     3,     2,     2,     1,     3,     4,     3,
       3,     2,     3,     2,     3,     1,     1,     1,     1,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     1,     1,
       1,     1,     1,     0,     1,     0,     2,     0,     1,     1,
       1,     0,     2,     0,     2,     0,     2,     2,     0,     4,
       0,     4,     1,     1,     1,     1,     1,     1,     1,     0,
       1,     1,     0,     1,     1,     0,     4,     0,     0,     5,
       1,     0,     4,     3,     1,     2,     2,     2,     2,     2,
       3,     2,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     0,     3,     0,     3,
       3,     1,     0,     4,     1,     2,     0,     1,     0,     3,
       3,     2,     2,     0,     5,     0,     1,     1,     0,     1,
       1,     2,     1,     2,     1,     2,     0,     0,     0,     0,
      22,     1,     1,     0,     1,     0,     1,     1,     0,     1,
       1,     0,     2,     2,     1,     3,     4,     3,     3,     0,
       2,     2,     1,     3,     3,     0,     4,     0,     3,     1,
       1,     0,     3,     2,     3,     1,     1,     2,     0,     2,
       3,     1,     5,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     2,     2,     2,     1,     1,     3,     5,     1,     1,
       1,     1,     1,     3,     4,     5,     1,     5,     3,     2,
       1,     3,     2,     2,     4,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     3,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     3,     0,     3,     0,     3,     0,     3,
       0,     3,     2,     0,     2,     0,     2,     0,     4,     0,
       3,     1,     1,     1,     1,     0,     1,     1,     1,     0,
       2,     2,     2,     3,     3,     4,     6,     2,     3,     3,
       2,     3,     5,     1,     3,     3,     1,     1,     3,     3,
       1,     3,     2,     2,     2,     2,     2,     1,     1,     4,
       4,     1,     1,     1,     1,     1,     0,     4,     1,     1,
       1,     3,     3,     1,     1,     2,     2,     2,     0,     3,
       4,     3,     0,     7,     1,     2,     1,     1,     1,     1,
       1,     1,     0,     5,     1,     1,     1,     1,     1,     3,
       6,     6,     6,     7,     5,     3,     4,     1,     3,     8,
       8,     8,     6,     4,     0,     3,     0,     3,     1,     3,
       2,     1,     1,     0,     1,     1,     2,     0,     1,     1,
       3,     0,     3,     0,     3,     0,     3,     0,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     2,     1,     3,     2,     2,     2,     2,     2,     2,
       2,     2,     1,     1,     2,     0,     1,     3,     1,     2,
       2,     2,     1,     3,     3,     1,     1,     3,     1,     3,
       1,     3,     1,     1,     1,     1,     4,     5,     4,     6,
       1,     0,     3,     3,     1,     1,     0,     2,     2,     2,
       2,     0,     2,     0,     3,     2,     1,     2,     2,     2,
       2,     2,     0,     3,     0,     1,     0,     3,     2,     0,
       1,     2,     0,     1,     4,     4,     5,     2,     3,     0,
       1,     0,     4,     0,     1,     1,     0,     1,     0,     2,
       2,     1,     0,     1,     1,     2,     3,     2,     0,     6,
       3,     0,     0,     0,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     3,     1,     2,     1,     2,     3,     3,     3,
       0,     3,     3,     0,     7,     0,     3,     1,     3,     0,
       3,     2,     4,     0,     3,     4,     4,     0,     0,     0,
      16,     8,     7,     0,     0,     0,     0,     0,    15,     0,
       0,     0,     0,    12,     4,     4,     3,     4,     3,     2,
       1,     3,     5,     1,     1,     0,     1,     1,     0,     2,
       0,     0,     3,     0,     2,     5,     3,     3,     3,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,   929,  1132,  2682,     0,     0,     0,     0,     0,     0,
    2684,   128,    66,  1789,  1917,  1918,  1700,  1728,     2,     0,
    1132,   276,   179,     0,    78,  1730,     0,  1973,     0,     0,
    1132,     0,   487,     0,  1968,     0,     0,  1132,  1733,  1958,
     253,   179,  2684,     0,  1178,  2472,  1830,  1984,     0,     0,
       0,  1813,     0,  2548,  1778,     0,     0,  2819,     0,     0,
       3,     8,    19,     0,    41,    24,    29,    14,    18,    13,
      54,    48,    26,    39,    38,    10,    57,    58,    16,    45,
      11,    12,    15,    37,    44,    33,    40,    52,  1169,    22,
      23,    30,    46,    62,    20,    59,    55,    21,  1919,    25,
      47,    42,    34,    56,    63,    35,    53,    36,    61,    28,
      49,    27,     9,    17,    50,    51,    43,    64,    31,    60,
      32,     0,   958,     0,     0,     0,     0,     0,     0,  1036,
     941,  2749,  2750,  2751,  1134,  1133,     0,  2684,  2088,  1117,
    1143,  2163,  2165,  2164,  2166,  2167,  2168,  2169,  2170,  2171,
    2104,  2172,  2173,  2175,  2174,  2176,  2177,  2178,  2105,  2106,
    2179,  2180,  2181,  2183,  2182,  2184,  2107,  2108,  2185,  2186,
    2187,  2188,  2109,  2111,  2110,  2189,  2192,  2191,  2190,  2112,
    2193,  2194,  2195,  2197,  2113,  2114,  2115,  2116,  2117,  2196,
    2118,  2198,  2119,  2199,  2200,  2201,  2202,  2203,  2204,  2205,
    2207,  2206,  2120,  2208,  2209,  2211,  2212,  2213,  2210,  2214,
    2216,  2215,  2217,  2218,  2219,  2121,  2220,  2221,  2222,  2223,
    2224,  2225,  2226,  2227,  2122,  2228,  2229,  2230,  2248,  2123,
    2231,  2234,  2233,  2232,  2235,  2236,  2237,  2239,  2238,  2240,
    2241,  2124,  2125,  2242,  2243,  2244,  2246,  2245,  2250,  2251,
    2252,  2126,  2247,  2249,  2449,  2253,  2254,  2256,  2255,  2257,
    2127,  2259,  2258,  2128,  2261,  2260,  2129,  2130,  2262,  2263,
    2264,  2086,  2265,  2087,  2266,  2269,  2270,  2267,  2271,  2276,
    2131,  2268,  2272,  2273,  2274,  2275,  2277,  2132,  2279,  2278,
    2280,  2281,  2282,  2283,  2284,  2285,  2286,  2287,  2288,  2301,
    2292,  2293,  2295,  2296,  2299,  2294,  2300,  2304,  2303,  2305,
    2306,  2307,  2308,  2309,  2302,  2290,  2297,  2298,  2291,  2310,
    2311,  2289,  2312,  2313,  2314,  2315,  2316,  2317,  2318,  2319,
    2320,  2321,  2322,  2324,  2323,  2325,  2326,  2327,  2328,  2329,
    2330,  2332,  2331,  2333,  2334,  2335,  2337,  2336,  2339,  2340,
    2133,  2338,  2341,  2342,  2343,  2344,  2345,  2347,  2346,  2134,
    2136,  2135,  2137,  2348,  2349,  2138,  2350,  2352,  2351,  2353,
    2354,  2355,  2357,  2356,  2358,  2359,  2139,  2140,  2360,  2361,
    2362,  2363,  2364,  2365,  2366,  2367,  2368,  2369,  2370,  2371,
    2372,  2373,  2375,  2374,  2376,  2377,  2378,  2379,  2380,  2381,
    2382,  2141,  2383,  2142,  2384,  2385,  2143,  2386,  2144,  2387,
    2388,  2389,  2390,  2391,  2145,  2392,  2393,  2394,  2396,  2397,
    2395,  2398,  2146,  2399,  2400,  2401,  2147,  2403,  2402,  2404,
    2148,  2406,  2149,  2150,  2405,  2152,  2153,  2407,  2408,  2409,
    2151,  2410,  2154,  2411,  2412,  2414,  2413,  2415,  2416,  2417,
    2155,  2418,  2156,  2419,  2420,  2421,  2422,  2423,  2425,  2424,
    2426,  2427,  2428,  2429,  2432,  2434,  2431,  2433,  2430,  2435,
    2436,  2437,  2438,  2442,  2443,  2444,  2445,  2439,  2440,  2441,
    2157,  2446,  2447,  2448,  2450,  2451,  2453,  2452,  2158,  2159,
    2454,  2455,  2162,  2456,  2457,  2458,  2462,  2459,  2471,  2460,
    2461,  2464,  2463,  2465,  2466,  2467,  2160,  2468,  2161,  2469,
    2470,   198,  2091,   181,  2092,  2103,   112,  2539,  2538,  1080,
    1118,  2685,  2686,   583,   885,     0,   179,     0,   886,     0,
     582,   884,   179,  2751,   134,     0,   579,   580,     0,     0,
       0,  1806,     0,  1726,  1726,  1726,  1726,     0,  1726,   179,
    1726,     0,  1729,  1726,   179,  1726,     0,    71,  1925,   277,
       0,     0,     0,     0,     0,  2085,     0,  1736,     0,     0,
    1975,  1991,     0,  1992,  1986,  2536,     0,  1203,     0,     0,
       0,     0,   179,  1135,     0,  1787,     0,   243,   252,   254,
     255,   251,     0,  2686,  2697,  1170,  1176,  1188,     0,  1897,
     255,     0,   112,  1061,     0,   112,  1814,  1811,     0,     0,
       0,  1787,  1985,  2803,     0,     0,     0,  2799,     0,  2804,
       0,  1178,     0,     0,     1,     5,     0,     0,  2243,  2352,
    1910,  1908,  2080,     0,   932,   959,     0,   937,     0,   935,
    2097,  2096,  2095,     0,   948,   947,   945,     0,   448,     0,
    1038,     0,  2760,   939,  1094,  2683,     0,   200,     0,     0,
     113,   114,     0,     0,     0,  2689,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   129,  1203,  1203,  2751,  2753,
    2755,   583,   581,   583,   583,   583,  1810,  1809,  1808,     0,
    1806,  2164,  2104,  2178,     0,  2053,     0,     0,     0,  1487,
       0,  2109,     0,  2193,  2195,  2113,  2114,  2115,  2116,  2117,
    2120,     0,     0,  1216,  1216,  1216,  1213,     0,     0,     0,
    2218,  2219,  2059,     0,     0,     0,  2049,  2060,  2256,  2257,
       0,  2051,  2052,  2263,     0,     0,     0,  2278,     0,  2283,
    2057,     0,     0,  2319,  2321,     0,     0,  2325,  2326,  2327,
    2328,  2034,  1271,     0,  1213,  2048,  2056,  2344,  2041,  2353,
    2358,  2359,     0,  2368,     0,     0,  2390,     0,  2397,  2395,
    2401,     0,     0,  2422,     0,     0,  1213,  2033,  2442,  2443,
    2444,  2445,     0,  2050,  2157,  2058,     0,  2456,  1216,  1213,
    1213,     0,     0,     0,  2465,  2466,  2470,     0,     0,     0,
    2721,  1270,     0,  1449,     0,  1481,  1228,  1234,  1248,     0,
    1263,  1297,  1298,  1300,  1404,  1299,  1305,  1304,  1701,  2045,
    1303,  1302,  2046,  2047,  1296,  2070,  2091,  2069,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1893,     0,     0,
    1712,  1726,    73,     0,     0,  2597,  2612,  2613,  1216,  2609,
    2614,  2238,  2125,  2250,     0,  2611,  2603,     0,  2363,  2367,
    2607,  2382,  2385,  2601,     0,  2149,  2426,  2633,  2605,  2610,
    2591,  2578,  2592,     0,     0,  2595,  2599,  2082,  1595,  2551,
    2552,     0,    79,  1738,  1739,  1737,  1034,     0,  2816,  1976,
    1977,  1978,     0,  1995,     0,  1130,     0,     0,   497,   488,
       0,  1892,  1891,     0,  1969,  2698,     0,     0,  1085,  1741,
    1788,     0,  1740,  1964,     0,  1962,  1959,  1961,   244,     0,
       0,   274,  2165,  2597,  2367,  2569,     0,  2577,     0,  2692,
    2689,  2699,  2734,  2729,  2728,  2731,  2732,  1194,  2733,  1193,
    2730,  2727,  1203,  1189,  1191,  1192,   801,     0,     0,  2492,
    2493,  2332,  2353,  2391,  2494,  2439,     0,     0,  2513,  2473,
    2478,  2474,     0,     0,  1852,     0,   801,  1875,  1905,  1853,
       0,     0,  1905,     0,  1630,  1895,  1898,     0,  2496,  1866,
     882,   881,  1878,   880,  2497,  1891,     0,  1838,  1854,     0,
    1815,  1859,   112,  2498,     0,  1894,  1877,     0,  1876,  1630,
    1905,     0,  1831,     0,     0,     0,     0,     0,   250,  1068,
    1068,     0,     0,  1060,  1062,  1063,  1068,  1068,     0,  2817,
    2818,  2549,  1034,  2040,  2038,  2039,  2089,  2800,  2037,  2808,
    2810,  2796,  2798,  2805,  1172,     0,  2703,     6,    65,     0,
    1922,  2758,  2759,  2757,   817,     0,  1216,  2098,  2101,  2752,
    2102,   182,   946,     0,   449,   182,     0,     0,     0,     0,
       0,   450,   451,   387,     0,  1042,  1043,  1037,  1039,  1041,
     943,     0,     0,   942,  2760,     0,     0,  1145,  1147,  1146,
    1163,   202,   199,   180,    80,  1082,  1719,  1721,  1120,  2688,
       0,     0,  2690,  2694,  1269,  1268,     0,   126,   132,     0,
    2584,  2588,     0,     0,  2101,  2660,   130,  2648,  2756,  1203,
    1203,  1203,  2748,     0,  2736,  2743,  2744,  2747,  2746,  2745,
    2742,     0,  2735,  2738,  2739,  2741,  2740,  2760,  2754,     0,
       0,     0,     0,     0,  1790,  1794,  1800,  1804,  1807,     0,
       0,  1600,  1318,  1600,  1600,  1600,  1488,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1600,     0,  1356,  1328,  1329,     0,  1357,     0,     0,     0,
    2061,     0,     0,     0,  2721,     0,     0,     0,  1454,     0,
       0,     0,  2721,     0,     0,     0,     0,     0,     0,  1483,
    1485,  2069,  1600,     0,     0,  1600,     0,     0,     0,     0,
       0,  1221,  1362,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1600,  1600,     0,     0,
    1600,  1370,  2063,     0,     0,     0,  2062,     0,     0,     0,
    2055,   798,   799,  2035,  2054,     0,  1373,  1375,  1374,     0,
    1600,  1600,     0,     0,     0,  1308,  1307,  1309,     0,     0,
       0,     0,     0,     0,  1267,  1266,  1265,  1264,     0,     0,
       0,  1272,     0,  1273,  1274,     0,  1275,  1276,  1277,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1310,     0,
       0,     0,  2036,  1413,     0,  1727,  1706,  1714,  1708,     0,
    1893,  1709,  1711,  1718,   462,     0,  1715,  2646,  1710,     0,
    1702,     0,    72,     0,  1947,  1952,     0,     0,     0,  1942,
    1950,  1944,  1951,  1943,     0,     0,  1953,   112,     0,  1945,
    1949,  1948,  1926,  1930,  1934,  1927,     0,     0,   275,   278,
     280,     0,   283,  2598,  2596,  2630,  2629,  2634,     0,  2631,
    2627,  2590,  2620,  2661,  2624,     0,  2661,  2626,  2625,  2661,
    2621,  2628,  2661,     0,  2593,     0,  1596,  1597,     0,  2550,
       0,  2081,  1035,     0,     0,  1979,  1980,     0,  1153,  1996,
    1997,  1993,  1595,  2537,  2540,     0,   688,  1204,   498,     0,
       0,   509,     0,     0,    68,    69,     0,  1137,     0,  1136,
    1140,     0,     0,     0,  1744,  1734,  1743,  1521,  1965,   112,
       0,   242,   267,   262,   270,   264,   266,   265,   271,   272,
     273,   268,   263,   269,   256,     0,     0,  2596,     0,     0,
    2593,  2693,     0,  2695,  2712,  1177,  2700,  1200,  1179,  1199,
       0,  1190,   800,     0,   803,   805,  1763,  1764,   804,   813,
       0,   802,     0,     0,  2510,     0,  2499,     0,   809,   811,
     810,  2507,   808,     0,     0,  2483,     0,     0,  1901,     0,
       0,  1865,     0,   583,     0,     0,     0,     0,     0,     0,
    1832,     0,     0,   632,     0,  1858,  1631,  1899,  1900,  1905,
       0,     0,  1905,     0,  1871,  1895,  1905,     0,  1905,  1827,
       0,     0,  1819,  1824,  1820,     0,  1826,  1825,  1828,  1816,
    1817,     0,  1845,  1873,     0,  1895,  1857,  1864,     0,  1844,
    1851,     0,  1862,  1895,  1895,     0,  1905,  1905,  1056,  1072,
    1054,  1066,  1067,     0,     0,  1059,  1058,  1812,  1524,     0,
       0,  2797,  2811,  2795,  2806,  2807,  2794,  1173,  2704,  1171,
    2705,     0,     7,     4,  1912,  1913,  1914,  1915,  1916,  1911,
    1909,  1923,  1924,   818,   817,   574,   577,   576,     0,     0,
    2100,     0,   938,     0,  1893,   936,     0,     0,  1893,   398,
    1893,   452,   930,  1040,   950,     0,     0,   940,  1095,  1096,
    1099,     0,     0,   486,  1163,  1149,  1165,     0,   203,   205,
       0,  1084,  1083,     0,  1081,  1128,  1127,  1125,     0,  1126,
    1124,  1119,  1121,  1122,  2687,  2691,   584,   817,  1893,     0,
       0,   131,     0,   390,     0,     0,     0,     0,     0,   583,
       0,     0,  2737,   115,   887,   887,   887,  1796,  1723,  1521,
    1725,  2080,     0,     0,     0,  1802,     0,     0,  1601,  1600,
       0,  1463,     0,     0,     0,     0,  1489,     0,     0,     0,
       0,     0,     0,     0,     0,  1294,     0,     0,     0,     0,
       0,  1434,     0,  1463,  1217,  1675,  1676,  1660,  1661,  1659,
    1662,  1214,     0,  1663,  1674,  1385,     0,     0,     0,     0,
       0,     0,  1571,  1572,  1573,  1574,  1582,  1575,  1576,  1577,
    1584,  1589,  1578,  1579,  1585,  1586,  1587,  1580,  1588,  1583,
    1581,  1590,     0,  1570,     0,  1593,  1591,  1594,  1592,     0,
    1455,  1447,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1600,     0,     0,     0,  1600,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1396,     0,     0,     0,
       0,     0,  1600,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1352,     0,  2072,  2071,     0,     0,     0,
     850,     0,  1312,     0,  1311,  1533,     0,  2706,  2722,     0,
    2499,  1450,  1452,     0,  1219,  1218,  1220,  1231,  1224,  1229,
    1222,  1226,     0,  1278,  2171,  1232,     0,     0,  1260,  2721,
    1609,  1261,  1246,  1251,  1252,     0,  1249,  1250,     0,  1254,
       0,  1253,  1257,  1258,  1259,  1262,     0,     0,     0,     0,
    1301,  1306,  1482,  1203,  2073,     0,     0,   462,   465,   464,
    1716,   463,  1765,     0,  1044,     0,     0,    74,    76,  1939,
    1936,  1935,  1937,  1941,   112,  1946,  1938,     0,  1954,  2218,
    2442,  2445,   287,     0,   260,   259,   261,   284,     0,     0,
    2623,     0,  2604,     0,  2608,  2602,  2606,  2586,     0,     0,
    2594,     0,  2632,  2615,  2619,  2618,  2616,     0,  2617,  2622,
    2600,  1599,  2251,  2336,     0,  1602,  2554,  1731,  2815,  1981,
    2456,  1982,  1974,     0,  1994,     0,     0,     0,  1131,   689,
       0,  1203,   496,   495,   494,   493,     0,   511,   491,   499,
      70,     0,     0,  1970,     0,     0,     0,     0,  1087,  1742,
       0,     0,  1722,  1522,  1966,  1960,     0,     0,     0,     0,
       0,  2650,  2575,     0,     0,     0,  2696,  2714,  2713,  2701,
    1203,  1621,  1204,  1204,  2069,  2515,     0,  2509,  2508,     0,
       0,     0,  2528,  2511,     0,     0,  2477,  2516,  2517,  2520,
       0,     0,     0,     0,     0,  2514,  2439,  2479,  2480,     0,
    2485,  2475,  2534,  2535,  2532,  2533,  2531,  2504,  1872,     0,
    1903,  1906,  1907,     0,     0,  1886,  1880,  1879,  1869,  1881,
    1870,  1890,  1889,  1888,  1842,  1841,  1643,  1644,  2394,  1642,
    1634,  1637,  1641,  1640,  1835,  1896,  1885,  1883,  1867,  1905,
    1840,  1839,  1884,  1882,  1821,  1822,  1823,     0,  1630,     0,
    1901,  1874,  1905,  1895,     0,  1905,  1905,  1887,  1861,  1863,
    1057,  1074,  1073,  1069,  1070,  1075,  1065,  1064,  1542,  1541,
       0,  1496,     0,  1498,  1495,  1494,  1493,     0,  1541,  2801,
    2809,  2813,     0,  1630,  2711,  2709,   575,  1765,  1765,     0,
    2099,     0,     0,     0,     0,     0,     0,     0,   183,   192,
       0,     0,   396,   397,  1765,   395,   438,   439,   442,   443,
     444,     0,     0,     0,     0,     0,     0,     0,     0,   136,
     445,  1765,  1765,   392,   418,   419,   422,   423,   424,   425,
     426,   388,     0,   393,   817,     0,   952,   954,  2761,  2762,
    2763,     0,     0,  1098,  1152,  1144,  1151,  1148,  1163,  1161,
    1150,   877,   876,     0,  1164,   201,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    81,    82,
     100,  1720,  1129,  1123,   127,   817,  1765,  1765,  1765,  1765,
     394,   427,   428,   431,   432,   433,   434,   437,   435,   436,
       0,  2589,     0,     0,  1893,     0,  2652,  2653,     0,  2649,
       0,  2789,     0,     0,     0,   181,   585,   888,     0,     0,
       0,     0,     0,  1791,     0,  2083,  1801,  1524,  1805,  1804,
       0,  1381,     0,  1427,     0,  1429,  1430,  1431,     0,     0,
       0,     0,     0,  1382,     0,  1326,  1383,  1384,     0,  1378,
       0,  1379,     0,     0,     0,     0,     0,     0,     0,  1433,
       0,  1215,     0,     0,  1330,  1331,  1323,  1315,     0,  1406,
       0,     0,  1332,     0,     0,     0,     0,  1387,     0,  1407,
    1484,     0,  1486,  2073,     0,  1439,  1388,  1337,     0,  1437,
       0,  1338,  1408,  1409,  1410,  1390,  1391,     0,  1412,     0,
    1392,     0,     0,  1395,     0,     0,  1340,  1443,  1441,     0,
       0,     0,     0,  1445,  1342,     0,     0,     0,  1341,     0,
       0,     0,     0,     0,     0,     0,  1344,     0,  1324,  1442,
    1444,  1398,     0,     0,     0,     0,     0,  1353,     0,  2715,
    1532,  2723,  1533,     0,     0,  2717,  2707,  2712,  2720,  1316,
       0,     0,  2074,  1225,  1230,  1223,  1227,  2721,     0,     0,
       0,     0,  1244,  1243,     0,     0,     0,  2721,  1609,  1247,
       0,     0,  1423,  1424,  1479,     0,  1707,  1704,  1717,  1766,
       0,  2647,  1046,  1045,  1713,  1044,    77,     0,  1940,  1933,
    1955,  1928,     0,   279,   288,   281,   285,   286,   282,  2665,
       0,  2664,     0,     0,  2583,  2642,  2645,  2080,     0,     0,
       0,  2564,  2558,  2565,  2567,  2561,  2566,  2568,  2559,  2560,
    2555,  2562,  1603,  1632,     0,  1983,  1154,  1156,  1157,  1155,
    1163,     0,     0,  2543,  2544,  2542,  2541,   501,     0,   510,
       0,   522,     0,     0,     0,  1972,  1971,     0,  1138,  1141,
    1142,  1092,  1091,  1093,  1086,  1088,  1089,   567,  1748,     0,
       0,     0,  1754,  1735,  1745,     0,  1967,  1963,     0,   257,
    2576,     0,     0,     0,     0,     0,     0,     0,  1198,  1524,
    1693,  1195,  1183,  1632,  1622,  1182,  1205,  1201,     0,   816,
     815,   814,   812,     0,     0,     0,     0,  2522,  2523,     0,
       0,  2500,  2501,  2502,     0,  2505,  2482,  2483,     0,  2484,
       0,  1902,     0,  1846,     0,  1868,     0,     0,     0,     0,
    1837,     0,  1860,  1818,  1903,  1836,  1602,  1895,  1833,  1834,
    1072,     0,  1055,  1541,  1524,     0,     0,  1516,  1543,     0,
    1543,  1518,  1519,  1524,     0,  1524,  1521,  1538,     0,     0,
    2812,  1623,  2710,     0,     0,   934,   186,   189,   187,     0,
     188,     0,     0,   447,   446,     0,  1893,   440,   140,   139,
     141,   142,  1657,  1658,  1654,  1655,  1653,  1656,   144,   143,
     138,   949,     0,     0,     0,  1893,   420,   399,   400,   403,
     404,   405,  1032,  1765,  1032,     0,  1765,  1765,  1032,  1765,
       0,     0,  1765,  1765,     0,     0,  1765,     0,     0,  1032,
       0,  1765,     0,  1019,     0,     0,  1765,  1765,  1765,  1765,
    1765,  1032,     0,     0,  1765,  1765,   486,  1765,     0,     0,
    1050,     0,     0,  1765,  1765,  1765,  1765,     0,     0,  1765,
    1765,     0,  1765,   966,  1018,   587,   614,   615,   931,   965,
     967,   979,   482,     0,   997,  1021,  1022,  1020,     0,     0,
       0,     0,   150,  2765,  1097,     0,     0,  1562,   204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1893,   429,  2585,     0,     0,
    1765,   389,   406,   407,   410,   411,   412,   413,   414,   417,
     415,   416,     0,  2656,  2658,     0,     0,   383,   382,     0,
     145,  2783,     0,     0,   669,   116,   473,   482,   586,   589,
       0,     0,   889,     0,     0,     0,  1724,  1804,  1524,  1602,
    2081,  1602,     0,  1803,     0,     0,  1428,  1464,     0,  1490,
       0,  1320,   772,   772,   772,  1473,   757,  1477,  1468,   772,
    1469,   772,  1471,     0,     0,     0,  1280,  1295,     0,     0,
       0,     0,     0,  1435,  1432,     0,     0,     0,     0,  1458,
       0,     0,     0,  1325,     0,  1418,  1440,  1438,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1446,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   839,   845,   848,   849,   851,   843,
       0,  1400,  1313,  1203,  2724,  2726,  1174,     0,  2716,  2718,
     925,  1451,     0,  1241,  1237,     0,  1235,  1608,  1256,  1255,
       0,     0,     0,  1245,  1204,  1414,  1203,     0,  1480,  2075,
    1705,   461,   631,  1703,    75,  1931,     0,     0,  2662,     0,
    2673,     0,     0,     0,     0,     0,     0,     0,     0,  2553,
    1633,  1775,     0,  1163,  1167,  2090,  1987,  2546,  2547,  2545,
       0,   502,   503,   505,  1204,   519,   497,     0,   489,   492,
       0,   501,     0,  1090,  1188,     0,  1767,  1752,  1759,  1753,
       0,     0,     0,  1751,  2065,  2064,  2071,  2699,     0,  1568,
       0,     0,  2574,  2651,     0,     0,     0,  2702,  1602,  1602,
    1687,     0,     0,  1180,  1185,  1181,  1184,     0,  1202,  1209,
    1208,  2066,  2073,  2512,     0,     0,     0,     0,  2527,  2521,
    2518,  2519,     0,  2481,  2503,  2487,  2486,  2489,  2491,  1667,
    1668,  1666,  1664,  1665,  1904,  1630,  1856,  1855,  1645,  1636,
       0,  1639,  1638,  1829,  1848,  1850,  1905,  1071,     0,  1078,
    1076,     0,  2706,  1536,     0,  1520,  1517,  1544,     0,  1543,
    1543,  1524,     0,  1500,  1779,  1782,     0,  1499,  1595,  1526,
    1188,  2802,  2814,     0,   630,   629,   191,   190,   196,   197,
    1671,  1672,  1669,  1670,   453,   466,  1673,   467,   441,   137,
     454,   455,   421,     0,   401,  1033,   922,   583,  1001,     0,
     670,   583,   873,   878,   878,   583,     0,     0,  1132,     0,
       0,  1726,     0,     0,  1132,     0,     0,     0,  1765,     0,
    1012,   961,     0,  1726,     0,  1726,  1726,  1013,     0,     0,
     962,  1765,     0,     0,     0,     0,     0,  1726,  1132,     0,
       0,     0,   484,     0,  1132,   981,  1053,  1052,  1051,     0,
    1132,  1132,     0,     0,     0,     0,   620,   621,   619,     0,
       0,     0,   612,   588,   817,   963,   483,   964,   669,     0,
    1047,   666,   672,  2076,     0,     0,   160,     0,     0,   951,
       0,   153,   151,   162,     0,     0,  1101,     0,  1100,     0,
    1565,     0,  1566,  1563,  1564,   101,    88,    84,   105,   106,
      86,    87,    91,    90,    92,    93,    96,    97,    94,    89,
      95,    85,   109,   111,   110,    98,   107,   108,    83,   460,
     459,   458,   457,   430,     0,     0,     0,  1893,   408,  2657,
    2655,  2654,     0,     0,  2790,   386,   384,   385,     0,     0,
     206,   647,   648,   646,   645,     0,   474,     0,     0,     0,
     649,   650,   652,   653,  1998,   481,   817,   590,   915,   917,
     916,   903,   902,   117,   120,   123,     0,  1602,  1621,  2084,
    1795,     0,  1354,  1491,     0,     0,   773,  1465,   825,  1475,
       0,  1476,   759,   758,   774,  1467,  1470,  1474,  1472,  1319,
    1327,  1376,     0,  1293,  1377,     0,  1405,  1322,  1321,     0,
       0,     0,  1360,  1361,     0,  1456,     0,     0,  1334,     0,
    1336,     0,     0,  1420,  1389,  1411,  1363,  1393,     0,  1339,
    1314,     0,  1364,     0,  1369,  1367,     0,  1343,     0,     0,
    1350,     0,  1348,     0,  1349,     0,  1351,  1397,  1399,     0,
       0,   850,   836,   837,   838,     0,   840,   842,   844,     0,
       0,  1534,  2725,  1175,     0,     0,  1453,  1233,     0,  1242,
    1239,     0,  1236,  1205,  1425,  1415,     0,  1929,   296,   291,
     299,   293,   295,   294,   300,   301,   302,   303,   297,   292,
     298,   290,   289,  2663,     0,  2582,  2587,  2644,  2643,  2666,
    2666,  2666,     0,  1604,     0,  1732,  1158,  1163,  1167,     0,
    1159,  1998,   506,     0,     0,     0,   526,     0,   524,   500,
       0,  1139,  1203,  1749,  1761,     0,  1769,     0,     0,  1746,
    1756,     0,     0,     0,  1755,   486,     0,   258,     0,  2571,
    2572,  2570,  1632,  1610,     0,     0,  1699,     0,  1694,  1196,
       0,  1207,  1206,     0,  2530,  2529,  2525,  2524,  2526,  2506,
       0,     0,  1847,  1635,  1630,  1843,     0,     0,  2712,  1595,
    1528,  1524,  1497,  1524,     0,     0,  1505,  1524,  1501,  1503,
       0,  1602,     0,  1560,  1203,  2068,  1624,  1627,   402,   671,
     923,  1132,     0,     0,     0,   878,   665,   583,   922,   887,
     879,   583,   583,   999,  1028,  1029,     0,     0,   598,   595,
       0,   607,   982,   973,   983,   994,   996,     0,   597,   622,
       0,     0,   610,  1726,     0,  1010,     0,     0,   592,     0,
       0,   641,   642,   640,   616,   623,  1030,  1031,   593,   594,
       0,     0,  1617,  1619,  1627,   600,   599,  1678,  1677,   609,
       0,   596,     0,  1016,   989,     0,   638,   636,   633,   635,
     634,   639,   637,   611,   602,   601,   604,   603,   606,   605,
     608,   624,   978,     0,  1032,  1032,   998,     0,  2079,     0,
    1049,  1000,     0,   654,   667,   655,     0,     0,   628,   627,
     625,   626,   161,   149,     0,     0,   953,   955,     0,     0,
     956,  2767,     0,  2769,  1103,  1104,     0,     0,  1166,     0,
       0,   102,   104,     0,   391,   456,   409,  2659,     0,   217,
    1203,     0,     0,   207,   209,   210,     0,     0,   471,   468,
     669,  2000,  1999,   470,   570,   591,     0,     0,     0,  1804,
    1797,  1646,     0,  1492,     0,     0,     0,     0,   819,   830,
     828,   822,     0,   826,   827,  1466,     0,     0,   775,  1478,
     739,   772,  1290,   757,  1284,  1286,  1282,     0,   740,  1285,
     772,     0,   825,  1289,  1281,     0,  1436,     0,     0,  1459,
       0,     0,     0,     0,     0,     0,     0,  1317,     0,  1416,
       0,     0,     0,     0,     0,     0,  1347,  1345,  1346,   834,
    1402,     0,   847,   841,   839,   846,     0,  1632,  2706,   926,
    1238,     0,  1426,     0,     0,     0,  2671,  2671,  2671,  1774,
    1773,     0,  1772,  1776,  1160,  1168,     0,   504,   507,     0,
     499,     0,   523,     0,   490,   568,     0,     0,     0,  1770,
    1758,  2703,  1747,  1750,  2073,  1523,  1569,  2573,  1187,     0,
    1605,  1698,  1695,     0,  1688,  1690,  1692,     0,  2067,  2488,
    2490,  1849,  1077,  1079,  1529,  1527,  1537,     0,  1493,  1524,
    1524,     0,  1493,     0,     0,  1781,  1621,  1783,  1525,  1557,
    1539,     0,  1628,  1629,  1626,   984,     0,   583,   874,   875,
     887,   924,     0,   887,   887,     0,     0,   972,  1003,  1120,
       0,   977,   813,   617,     0,   968,  1011,  1044,     0,   618,
    1005,   970,     0,  1620,   485,   969,   991,   975,  1954,  1002,
    1048,   855,   753,   702,   693,   772,   696,   695,   772,   707,
     757,   755,   725,   757,   757,   732,   731,   749,   735,   715,
     825,   825,   714,   752,   825,   736,   734,   738,     0,   740,
     757,   745,   733,   737,   754,   730,   727,   751,   772,   772,
     772,   711,   750,   825,     0,   743,   772,   673,   776,   713,
     825,   832,     0,     0,   772,   774,  2078,   147,   152,   163,
     164,   944,  2766,     0,  2764,     0,  1109,     0,  1162,  1567,
      99,     0,     0,     0,   220,   218,   219,     0,   213,   215,
     210,  2777,     0,  2784,     0,     0,  2782,   475,  2703,   585,
     651,   571,     0,     0,     0,     0,     0,  1792,  1355,   770,
     768,   771,   769,   821,   820,   824,     0,   823,   832,     0,
       0,  1292,  1287,   741,  1291,  1283,  1288,  1380,  1358,  1359,
       0,  1457,  1448,  1386,     0,  1335,  1417,     0,     0,  1394,
    1365,  1368,  1366,  1371,  1372,     0,  1401,     0,  1195,  1195,
     643,  2719,  1240,  1956,  2674,     0,     0,  2670,  2668,     0,
    2669,  2667,  2635,     0,  2580,  2581,  2579,  2563,     0,     0,
       0,  1203,   512,     0,   529,   528,   525,  1632,  1760,  1762,
    1768,  1757,     0,  1606,  1621,   806,  1691,     0,  1197,     0,
    1506,     0,  1510,  1515,  1511,     0,  1502,     0,  1646,  1561,
       0,  1632,  1627,   986,     0,     0,     0,     0,     0,     0,
    1015,     0,     0,   974,   995,  1017,  1009,  1008,     0,     0,
    1132,  1618,   990,   992,  1087,     0,     0,   859,   701,   694,
     712,   710,   761,   756,     0,   761,   761,   721,   739,   716,
       0,   825,   729,   720,   741,   744,   746,   748,   761,     0,
     825,   709,   708,   718,   705,   761,   784,     0,     0,     0,
       0,   780,     0,   853,     0,   787,     0,   674,   777,   779,
       0,     0,     0,   742,   825,   698,   833,   832,   700,   825,
     832,   761,   761,     0,   154,   957,   323,  2768,  1178,     0,
    2773,     0,  1110,  1106,  1107,  1102,   103,   135,  2781,  2791,
     217,     0,     0,   158,     0,   208,   813,   211,   472,   482,
       0,   477,     0,  1627,   920,     0,     0,  2394,  1647,  1798,
     831,   829,     0,  1460,  1627,     0,  1419,  1421,   835,     0,
    1535,   644,     0,  1932,  2641,  2640,  2639,  2636,     0,     0,
       0,     0,     0,     0,  2672,  2676,  1771,     0,     0,     0,
     520,     0,     0,   554,   569,  1614,  1627,     0,  1632,     0,
    1696,  1689,  1530,     0,     0,     0,     0,     0,  1780,  1549,
    1550,     0,     0,  1555,  1559,  1540,  1625,     0,     0,   985,
     668,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1014,  2042,  1047,   486,  1006,   971,     0,   976,   613,
       0,   858,     0,   863,   765,   766,   767,   722,   762,   764,
       0,   724,   692,   717,   747,   723,     0,   719,   706,   790,
     789,  1210,   782,   797,   677,     0,     0,   788,     0,   778,
     786,   781,     0,   697,   699,   703,   704,   690,   691,  2077,
       0,   156,   349,     0,   335,   321,     0,     0,     0,   325,
     165,   168,   166,     0,   167,   173,     0,   174,   175,   176,
     177,   178,   169,   347,   348,   172,   170,   171,     0,  2093,
       0,  2094,  2771,     0,     0,  2770,  1105,     0,  1112,   184,
     214,     0,     0,   150,   159,  2785,   795,  1998,     0,  2699,
     890,     0,   919,     0,   892,   894,  1648,     0,  1203,  1793,
     760,     0,  1462,  1333,  1403,     0,  2637,  2677,  2680,  2678,
    2679,  1650,     0,  2681,  2675,     0,  1521,  1204,     0,   513,
       0,   516,   518,   532,     0,  1765,  1765,     0,     0,  1765,
    1765,  1765,  1765,   547,   555,   557,     0,  1615,  1616,     0,
    1611,  1613,  1607,  1679,   807,  2001,  2706,  1507,     0,  1512,
       0,  1504,  1545,  1545,  1556,   988,     0,     0,     0,   656,
       0,     0,  2044,  2043,  1004,   980,  1047,     0,   856,     0,
     860,   861,   862,     0,   854,   763,     0,   927,     0,     0,
     796,  1210,   785,  1203,   794,   793,   791,   792,   155,     0,
     148,     0,     0,   334,   337,     0,     0,   340,   330,   329,
     331,     0,   324,   323,   323,   377,   328,   374,   373,   366,
    2703,     0,     0,     0,  1111,  1116,     0,  1113,  1115,  2792,
     216,  1203,   162,     0,   469,   479,   478,     0,  1765,   118,
     891,   911,   910,   896,     0,  1627,     0,     0,   121,   893,
     913,   900,   124,   895,   912,   898,  1649,  1799,  1627,  1957,
    1652,  1651,  1777,  1785,     0,  1988,     0,   521,   514,     0,
       0,   530,     0,     0,  1765,  1765,     0,     0,     0,     0,
       0,   527,   556,  1765,  1627,     0,  1186,     0,  2009,  1531,
       0,     0,     0,  1553,  1551,   987,     0,   662,   890,   658,
     660,  1007,     0,   857,     0,     0,   825,     0,   825,  1211,
       0,   783,     0,   157,   350,   361,   364,   356,   336,     0,
       0,     0,   326,   323,     0,   310,   308,   309,   315,   316,
     317,   318,   319,   320,   311,   314,   312,   313,   323,     0,
     225,     0,     0,  2772,     0,  2774,     0,  1108,     0,   194,
     193,   185,     0,   323,  2778,     0,  2786,  2703,   905,     0,
    1023,   897,     0,   918,   921,     0,  1023,   901,  1023,   899,
    1461,     0,     0,   806,   508,   520,   517,   540,   533,   536,
       0,   566,   560,     0,     0,   562,   563,   561,   558,   551,
       0,   549,     0,  1612,  1680,     0,     0,     0,     0,  2002,
    2004,     0,  1697,  1509,  1514,     0,  1546,     0,     0,     0,
     664,   890,   657,   892,   894,     0,   869,     0,   868,     0,
     865,   864,   726,   928,   728,  1212,   678,     0,     0,   323,
     357,     0,   332,     0,     0,     0,     0,   223,   380,     0,
     221,   368,   368,  2775,  2776,  1114,   195,  2793,     0,   164,
     184,   480,   904,   119,  1025,  1024,   909,   908,   906,   907,
     914,   122,   125,  1784,  1786,  1989,   515,   540,     0,   538,
       0,   534,   531,   535,   564,   565,     0,   548,     0,   559,
       0,     0,     0,     0,     0,  2003,     0,     0,  2010,  2012,
    1548,  1547,  1562,     0,   663,   659,   661,   993,   871,   872,
     870,     0,     0,   680,   679,   681,   358,   364,   354,   362,
     323,     0,     0,   322,   341,   376,   224,     0,   378,     0,
     323,     0,   367,   369,   371,     0,   146,  2787,  1027,  1026,
    2015,   537,     0,   545,   541,   543,   546,   554,   553,   550,
    1203,  2007,  2008,     0,  2005,     0,     0,  2011,     0,     0,
       0,     0,     0,   685,   675,   682,   684,     0,   355,     0,
       0,   353,   333,   338,   323,     0,   323,   236,   235,     0,
     227,   304,   375,     0,   226,  2779,   323,     0,  2001,   539,
       0,     0,   552,     0,     0,  1683,  1685,  2006,  2014,  2013,
    1554,  1552,   867,   866,   687,   686,   683,   359,     0,   323,
       0,   323,     0,   323,     0,     0,     0,     0,     0,   222,
     323,  2788,     0,  2009,   544,   542,  1204,  1681,  1203,     0,
     351,   323,   339,   344,   381,     0,   230,   305,   306,     0,
     233,  2780,     0,  2017,  1686,  1684,   323,   323,   340,   343,
     379,     0,     0,   228,   229,   241,   240,   232,     0,  2016,
       0,  2021,   323,   323,   345,   249,   247,   323,   237,   245,
     239,     0,   246,   307,   234,     0,     0,  2028,     0,   231,
     248,  2019,  2020,  2018,  2023,     0,     0,  2025,  2026,     0,
    1990,   238,  2027,  2022,     0,  2029,  2031,     0,  2024,     0,
    1203,  2030,     0,  1204,  2032
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    59,   626,  1553,    60,    61,    62,    63,    64,  1394,
      65,   842,  1312,  1847,  1848,    66,   566,    67,  1600,  2158,
    2159,  3500,  3501,  2160,   659,   660,    68,  2196,  3526,  4450,
    3527,  4456,  3528,  4458,  1617,   533,   534,  2098,  2099,  1112,
    3139,  3079,  3984,  3083,  4141,  4290,  4183,  2116,  3490,  3985,
    3986,  4150,   561,  2194,  1572,  4319,  2078,  4441,  2079,    69,
     657,  1082,  1597,  1598,  3512,  3513,  3795,  3514,  3787,  3788,
    3789,  3790,  4610,  4413,  4530,  4611,  4696,  4731,  4737,  4738,
    4659,  4747,  4748,  4749,  4735,   919,  4750,    70,   589,   590,
     921,  1424,  1862,  1425,    71,    72,   560,  1338,  1339,  1340,
    1341,  2378,  1863,  2373,  2374,  3281,  4660,  4733,  4414,  4415,
    4297,  4416,  4153,  4417,  4301,  4418,  4156,  4419,  4420,  4421,
    4422,  4602,  4423,  4296,  4652,  4410,  4411,  4654,  4713,  4729,
    4424,  4163,  4291,  4517,  4164,  4292,  4597,  4406,  4598,  4647,
    4709,  4407,  4518,  4650,  4521,  4425,  4431,  4612,  4426,  4432,
    4427,  4168,  4308,  4430,  4306,  4429,  4656,  4607,  2699,  3138,
     644,   645,   671,  2184,   646,  1098,  1052,  1574,  2111,  2112,
    2567,  2568,  2681,  2682,  2683,  2103,  2104,  2105,  2170,  2171,
    2172,  2085,  2086,  2087,  1578,  2082,  2083,   647,  1053,  1063,
    2106,  2107,  2108,  2687,  2174,  2175,  2176,  2177,  2109,  1840,
    2110,  2984,  2705,  3799,  3798,  2706,  3523,  4189,  4447,  3154,
    3155,  3066,  3440,  2129,    73,   578,   899,  1391,  2422,  1392,
    2424,  2860,  2861,  2862,  1912,  1913,  3872,  1917,  2421,  4050,
    4465,  4220,  4221,  2864,  4219,  2868,  3307,  3308,  3621,  3874,
    4053,  4470,  4360,  4562,  4468,  4558,  4469,  4560,  4671,  4624,
    4625,  4371,  4480,  4481,  4566,  4627,  4233,  4234,  4235,  2442,
    2874,  3877,  3802,  2164,  1564,  1565,   535,   536,   537,  3388,
    2707,  2624,  2708,  2709,  3463,  2626,  2627,  2831,  1482,  3453,
    3424,  3848,  3145,  3149,  3150,  3151,  3152,  3153,  4388,  4503,
    4504,  4501,  3473,  3386,  2999,  3000,  3071,  3476,  3757,  3966,
    4595,  4644,  4645,  4646,    74,   896,  4006,  3934,  3949,  3759,
    3760,  3761,  3762,  3763,  3764,  3765,  3181,  3182,  4107,  4108,
    4109,  3176,  3177,  3549,  3967,  3968,  3969,  4007,  4122,  1234,
    3542,  1448,  1449,  4060,  1460,  1461,  2470,  1957,  2471,  1568,
    3543,  3544,  3545,  3978,  3240,  3845,  3246,  3247,  3248,  2794,
    2795,  2796,  2797,  2798,  2316,  3970,  3475,  3927,  4100,  4103,
    4274,  4510,  3001,  3387,  3002,  3391,  1001,   538,  3003,  3004,
    2197,  2198,  4329,  4338,  4342,  4330,  4343,  4339,  4331,  4332,
    4333,  4345,  4341,  3161,  4012,  4013,  3379,  3389,  3256,  4276,
      75,   129,  2114,  1044,  1055,  1051,  1074,   652,  1584,  2117,
    2642,  3771,   634,  2628,  3920,  3689,  3924,  2629,  3403,  2630,
    3903,  4079,  2631,  3706,  3922,  4097,  3404,  3405,  2632,  2633,
    2634,  3912,  3919,  4266,  4543,  4544,  4545,  3005,  1373,   649,
     650,  1067,  1068,  1069,  2364,  3471,  3049,    76,  2045,  2040,
      77,  1013,  1014,  1015,  1528,  1529,  2043,  2044,  2512,  2950,
      78,   662,  1604,    79,  1402,  2434,  2435,  2436,    80,  1075,
    1588,  1589,  2123,  3088,  3496,  3776,  3995,  4178,  3991,  4316,
    4317,    81,    82,   663,  1611,  1612,  1613,    83,  1385,   136,
      84,   907,  1397,  1399,  1400,    85,   656,  1076,  1077,  1078,
    1079,  2125,    86,  1903,  2406,  2407,  2408,  2409,  1594,  2646,
    1595,  1596,  2134,  3300,    87,    88,   623,  2324,   595,   931,
     596,   597,  1951,  2461,  3849,   942,   943,   944,  2903,  1438,
    1439,  1440,  1909,  2908,  4280,  1166,  1162,   805,   806,   807,
     808,  1259,  1260,  3971,   809,  1269,  1806,  3193,  3564,  1665,
    1666,   810,   811,   812,   813,   814,   815,  1833,  3212,  3213,
    3579,  2351,  2352,  2353,   816,  2238,  3199,  2251,   817,  1252,
    1791,  1721,  3571,  3205,  3830,  4023,  1650,  2214,  2743,  3184,
    2827,  2318,  1188,  1189,  1147,  2221,  1656,  2051,  2052,  2053,
    2054,  2055,  3663,  3664,  4063,  3891,  4065,  3895,  2522,  2523,
    1932,  1933,  2056,  2057,  2951,  3889,  4246,  2319,  2320,  2321,
    3597,  2952,  3361,  2969,  2970,  3901,  2513,  2058,  2958,  4383,
    4072,  4073,  4499,  4498,  4074,  3899,  3900,  3668,  3669,  3091,
    3092,  3093,  2888,  1712,  1713,  1719,  1368,  1369,  1651,  2403,
    2848,  3884,  4057,  2342,  3640,  4055,  4240,  2637,  3432,  3433,
    2463,  2464,  2973,  3376,  3674,  1485,  3850,  2850,  2010,  2938,
    2939,  3807,  4213,  4736,  2799,  2934,  2985,  1683,  1684,  3439,
    4376,  4570,  4674,  4675,  4676,  3336,  3337,  3644,  3645,  2465,
    2900,  3338,  3885,  4245,    89,   542,    90,  1845,  2830,  1309,
    2370,  1086,  1404,  1637,  1638,   829,   556,    91,   567,  2404,
      92,   585,  1930,   886,   911,  1405,  1406,  2443,  2875,  2882,
    2444,  2887,  3631,  2877,  3313,  3314,  2359,  2360,  2878,  3316,
    3628,  3611,  3612,  3295,  3869,    93,   611,  3371,  2964,  2965,
    4352,  4353,   912,    94,   541,  1134,  2719,  4019,  1643,  2202,
    4199,  1135,  1136,  2205,   689,   690,    95,  1018,   607,  1508,
    1509,  1510,  2028,    96,   599,  1002,  2935,  3354,  2004,   903,
    1305,  1489,  1005,  1490,  1990,  2493,  1471,    97,  1040,  1039,
    1559,    98,   630,  1560,    99,   843,  1332,  1858,  2835,  3267,
    1333,  1334,  2371,  4033,   100,   586,   916,   917,  1409,  2447,
     101,   580,   904,  1923,   102,   570,   891,  1377,  1902,   103,
     104,   105,   893,  3301,  4463,  4620,   574,  1905,  1381,  3524,
    4378,  4489,  4490,  4492,  4578,  4579,  4668,  4741,  4763,  4757,
    4766,  4767,  4770,  4775,  4776,   819,  1027,   820,  4091,   821,
     822,   823,  2883,  2884,  3377,   824,  2885,   825,  3072,  1087,
    1640,   564,   512,   641,  1028,  2856,   827,  4170,  1047,  1048,
    1105,   514,   515,   106,   598,   959,  1465,  1455,  1464,  1977,
    2487,  1981,  2489,  2490,  3350,  2926,  3351,  2927,  1007,  1973,
    1978,  2928,   962,  1966,  1967,  1968,  1969,  2919,  1963,  1987,
     107,   894,   519,  1383,  1384,  2415,   108,   610,   109,  1370,
    1895,  1896,  2400,  2847,  2401,   110,   925,   926,   111,   871,
    1621,  2384,  1100,  1050,  1101,  1881,   874,  1344,   875,   876,
    1359,  1353,  1362,  1356,  4038,  3861,  3862,  2388,  1308,  1106,
    1942,  2188,  3132,  1107,  1872,  2380,  2381,  3606,  3864,  3285,
    4044,  4045,   112,   137,   522,   665,  1093,  1432,   113,   114,
     115,   116,  1435,  1548,  2457,  1549,  2325,  1550,  1551,  2065,
    1949,  1787,  1788,  3254,  1249,  1250,  2328,  2803,  2804,   945,
     675,  1122,  1114,   130,   131,   132,   678,   679,   133,  1072,
    1073,  2643,  3085,  3492,  3774,  3775,  3990,  4175,  1116,  4002,
    4538,  4700,  1117,  1118,  3140,  4004,  4323,  4540,  4666,  1119,
    2696,  3509,  4179,  4443,   117,  1029,   620,  1546,  1541,  1543,
    2061,  2530,   118,   119,   120
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4100
static const int yypact[] =
{
    4912,  2591,    82, -4100,  -136,   783, 58124,   739,  1388,  1388,
     465,  3344, -4100, -4100, -4100, -4100, -4100,  3183, -4100, 58124,
      82,   335, -4100, 26391, -4100, -4100,   -51, -4100,    73,  1388,
      82,   456, -4100, 58124, -4100,   667,   955,    82, -4100, -4100,
   51150, -4100,   465, 58124, -4100, -4100, -4100, -4100, 51150,   197,
     207,   668,   -43, -4100, -4100, 58124,  2163, -4100,  -161,  1307,
    1203, -4100, -4100,  1105, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, 27028, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100,  1378, 58124,  1467, 58124,  1437, 58124, 49248, 58124, -4100,
    1523, -4100, -4100,  1543, -4100, -4100,  1388,   465, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100,  1053, -4100, -4100,  -136, -4100, -4100, -4100,
   -4100, -4100,  1730,  1518, -4100,  1551, -4100, 49248, -4100, 58124,
   -4100, -4100, -4100,   237, -4100,  1213, -4100,  1233,  1671,  1677,
    1686,  1299, 12789,  1709,  1709,  1709,  1709,  1694,  1709, -4100,
    1709, 58124, -4100,  1709, -4100,  1709,  1388, -4100, -4100, -4100,
    1804, 37202, 58124,  1572,   178,   -89, 49248,  1128, 58124,  -136,
     756, -4100,  1741, -4100, -4100, -4100,  1388, -4100,  1905,  1794,
     249, 58124, -4100, -4100,  1388,   860,   960,  1385, -4100, -4100,
    1511, -4100, 37836,   186, -4100, -4100, -4100,  2407, 28939,  6473,
    1511,  1529,  -136,  -122,  1538,  -136, -4100, -4100, 58124,  -136,
    1388,  1723, -4100, -4100,   318,   318,   318, -4100,   318, -4100,
     318, -4100,  -161,  1401, -4100, -4100,  1404, 58124,   748,   856,
   -4100, -4100,  1409,   880, -4100,  1479, 41640, -4100, 58124, -4100,
   -4100, -4100, -4100,  1708, -4100, -4100, -4100,  2271, -4100,  1544,
     845, 58124,  1584, -4100, -4100, -4100, 26391,  1459, 58124,  1545,
   -4100, -4100, 26391, 26391,   205,    10,   788, 58124, 58124, 46078,
    1925, -4100,  2123, 41640,  1681, -4100,   284,  -117,  1543,  2124,
   -4100,  1518, -4100,  1518,  1518,  1518, -4100, -4100, -4100, 51784,
    1299,  1488,  1491,  1496, 18037, -4100,  1525,  1531,  1533, 12789,
    1536,  1556,  1571,  1575,  1590,  1620,  1636,  1663,  1667,  1676,
    1689,  1692,  1701,  1704,  1704,  1704,  1727,  1729,  1731,  1733,
     346,  1737, -4100,  1739,  1742,  1758, -4100, -4100,  1765,  1776,
    1781, -4100, -4100,  1791,  1793,  1799, 13445,  1806,  1809,  1812,
   -4100, 23194,  1817,  1822,  1830,  1837,  1878,  1881,  1886,  1888,
    1892, -4100, -4100, 12789,  1727, -4100, -4100,  1900, -4100,  1907,
    1910,  1928,  1930,  1938,  1944,  1952,  1959,  1969,  1974,  1976,
    1991,  1995,  1998,  2018,  2036,  2053,  1727, -4100,  1026,  2059,
    2069,  1208,  2092, -4100,  2097, -4100,   344,  2104,  1704,  1727,
    1727,  2111,  2113,  2129,  2134,  2150,  2153, 18037, 18037, 18037,
   12789, -4100, 58124, -4100, 58124,  1628,  2689, -4100,  2830, 18037,
     203, -4100, -4100, -4100, -4100, -4100, -4100, -4100,  1519,  1619,
   -4100, -4100, -4100, -4100, -4100, -4100,  2158,  1530,  2022, 58124,
   58124, 58124, 58124, 58124, 58124, 46078, 49248,  1666, 58124, 46712,
   -4100,  1709,  1604,  3980, 32119,  1848,  1836,  2063,  1704, -4100,
   -4100,   558,   697,   747,  1951, -4100, -4100,  1786,   906,  1971,
   -4100,   950,   394, -4100,    93,  1052,  1075, -4100, -4100, -4100,
   -4100, -4100, -4100,  1941,  2002,  1903, -4100, -4100,   135, -4100,
   -4100, 58124, -4100, -4100, -4100, -4100,  2316,  2067, -4100, -4100,
   -4100,   169,  2345,   223, 26391, -4100,  1916, 12789,  1623, -4100,
    -201, -4100, -4100,  2326, -4100, -4100, 46712, 26391, -4100, -4100,
   -4100, 23833, -4100, -4100,  2612, -4100,  2025, -4100, -4100,  1619,
    3453, -4100,  2317,  1848,  2400, -4100,  2626, -4100,  2457,  2356,
      10,  2242, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100,  2200,  2407, -4100, -4100,   192,  2357,  2191,   418,
     470, 41006,   789, 49248,   508,    62, 29575, 42274,  2194, -4100,
   -4100, -4100,   815,  2355, -4100,  2688, -4100, -4100,    -2, -4100,
    2210,  1162,    -2, 47346,  2594,   187, -4100,   317, -4100,  2671,
   -4100, -4100, -4100, -4100, -4100,  2346,  2330,  2375, -4100,   339,
    2765, -4100,  -136, -4100,   930, -4100, -4100,  2362, -4100,  2594,
      -2,   187, -4100,  2606,  2734,   816,  2708,  -164, -4100, -4100,
   -4100,  -123,  2823, -4100,  2264, -4100, -4100, -4100, 26391, -4100,
   -4100, -4100,  2316, -4100, -4100, -4100, -4100,  2287, -4100,  2567,
    2398, -4100, -4100,    44, -4100,  2298,    -9,  2791, -4100,  1561,
   42908, -4100, -4100, -4100,  2826,  2837,  1704,  2306, -4100, -4100,
   -4100, -4100, -4100,  2963, -4100, -4100,  2319,  2862,  2862,  2862,
    2982, -4100, -4100, -4100, 26391, -4100, -4100, -4100,   845, -4100,
   -4100,  2505,  2383, -4100,  1584, 26391,  2743,  2367, -4100, -4100,
    2617, 12789, -4100, -4100, -4100,    37, -4100, -4100,  2047, -4100,
    2953,  2590, -4100, -4100, -4100, -4100,  2858, -4100, -4100,  2963,
    -241, -4100,  2919,  2862,  2809, -4100,  2388, -4100, -4100, -4100,
   -4100, -4100, -4100,   230, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100,  1644, -4100, -4100, -4100, -4100, -4100,  1584, -4100, 26391,
   58124, 58124, 58124, 26391, -4100,  2392, -4100,  2397, -4100, 12789,
   12789,   327,  2985,  3047,  3047,  3047,  1628,  2435, 12789, 12789,
   12789, 12789, 12789, 12789, 12789, 12789, 12789, 12789, 12789, 12789,
     332,  2417, -4100, -4100, -4100,  1079, -4100,  2418, 12789, 12789,
   -4100, 12789, 12789, 27665, -4100,  3913, 12789,   966,  2926, 12789,
   12789, 12789, 12789,  3083, 12789, 12789, 12789, 27665,  3065,  2426,
   -4100,  2424,  1030, 12789, 12789,  1513, 12789, 12789, 12789, 12789,
   12789, -4100, -4100, 12789, 12789, 12789, 12789, 18037, 12789, 12789,
   12789, 12789, 12789, 12789,  2437, 12789,  3047,  3047, 12789, 12789,
    1574, -4100, -4100, 12789,  2468,  2468, -4100, 12789,  9509, 12789,
   -4100, -4100, -4100, -4100, -4100,  2438, -4100, -4100, -4100, 27665,
    3047,  3047, 12789, 12789, 12789,  2985,  2985,  2985,   217,  2442,
     814, 12789, 30211,  2439, -4100, -4100, -4100, -4100, 12789, 12789,
   12789, -4100, 18037, -4100, -4100,  1899, -4100, -4100, -4100, 14101,
   18037, 18037,  2445, 18037, 18037, 18037, 18037, 18037,  2827, 18037,
   18037, 18693, 19349, 18037, 18037, 18037, 18037,  1109,  2985, 49248,
   18037, 12789, -4100, -4100, 58124, -4100, -4100, -4100,  2443,  2723,
    1666, -4100,  2450, -4100,   623,  2945, -4100, -4100,  2458, 26391,
   -4100,  2459, -4100,  2829, -4100, -4100,  2840,  2841,  2843, -4100,
   -4100, -4100, -4100, -4100,  3080,  2846, -4100,  -136,  2848, -4100,
   -4100, -4100, -4100,  2483, -4100, -4100, 20005, 49248, -4100,  2486,
   -4100,  2976, -4100, -4100, -4100, -4100, -4100, -4100,  2595, -4100,
   -4100, -4100, -4100,  2498, -4100, 46712,  2498, -4100, -4100,  2498,
   -4100, -4100,  2498, 41640,    64,  3510, -4100, -4100, 58124, -4100,
   58758, -4100, -4100, 23833,  -136, -4100,  2927, 14757, -4100, -4100,
   -4100,  2873,   201,  2503, -4100, 26391, -4100,  1628, -4100,   110,
     110,  2759,   182, 49248, -4100, -4100,   160,  2509,  2592,  2513,
   -4100,  2597, 26391, 26391, -4100, -4100, -4100,  2769, -4100,  -136,
     960, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100,  2519,  3009,  2980,  2523, 46712, 41640,
     843, -4100, 58124, -4100,  1595, -4100, -4100, -4100,  2524, -4100,
   12789, -4100, -4100, 58124, -4100, -4100, -4100, -4100, -4100,  3106,
   12789, -4100, 46712,  1154, -4100,    94,  1216,   815, -4100, -4100,
   -4100, -4100, -4100, 58124, 52418,  2526, 10165,  2648,  2930,  -136,
   12789, -4100,  2536,  1518, 58124, 58124, 58124, 26391, 58124, 26391,
   -4100,   772,   772, -4100, 43542, -4100, -4100, -4100, -4100,    -2,
   58124, 58124,    -2, 41640, -4100,   187,   -37, 58124,    -2, -4100,
    2931,  2635, -4100, -4100, -4100,  3000, -4100, -4100,  2991,  2543,
   -4100,  3028, -4100, -4100,  2668,   187, -4100, -4100, 26391, -4100,
   -4100,   187, -4100,   187,   187, 12789,    -2,    -2, -4100,   -72,
   -4100, -4100, -4100,  2705,  -122, -4100, -4100, -4100,  1300,   318,
    2810, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100,    83, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100,   143, -4100, -4100, -4100,  2009,  3075,
   -4100, 49248,  1773,  -100,   786,  1773,  1898,  -136,   553, -4100,
     553, -4100, -4100, -4100,  2850,   215, 26391, -4100,  2577, -4100,
    2832, 53052, 26391, -4100, -4100, -4100,   158,  2583,  2584,  1628,
    4191, -4100, -4100, 26391, -4100, -4100, -4100, -4100,  2638, -4100,
   -4100, -4100, -4100,  1234, -4100, -4100, -4100,   162,  2027,  3234,
   46078, -4100,  2609,  2640,   138, 41640,  3043, 58124, 58124,  1518,
   58124, 58124, -4100, -4100, -4100, -4100, -4100,  2596, -4100,  2769,
   -4100,  1348, 58124,  3050, 34659, -4100,   457,   404, -4100,  3047,
    2598, -4100,  2601,  2605,  2619, 12789,    60,   211,  1274,  1403,
     751,  1373,   596,  1389,   626, -4100,  1412,   782,   795,   868,
     271, -4100,  2622,  2633, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100,  2631, -4100, -4100, -4100,   935,   940,  1411,  1425,
    2634,  2637, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100,  3088, -4100,  1443, -4100, -4100, -4100, -4100,  2645,
   -4100, -4100,  1434,  1029,  1057,   311,  2642,  1517,  1129,  1592,
    1621,  2650, 27665, 58124,  3047,  2639,  1492,  1559,  3047,  2653,
    1143,  1612,  1642,  1645,  1649,  1652,  1656,  1147,  1658,  3585,
    1668,  1188,  1197,  1697,  1209,  1226, -4100,  1717,  2659,  2666,
    1250,   316,  3047,  2674,   387,  2649,  2651,  1725, 10821, 11477,
   12133,   728,  1257, -4100,  2677, -4100,  2424,  2679,  2685,   423,
     164,  1735, -4100, 12789, -4100, -4100,   919,  1470,  2727,   159,
    1216, -4100,  2831, 58124,  2239,   184, -4100, -4100, -4100, -4100,
   -4100, -4100,  1003, -4100,  2690, -4100,  2699,  2070,  2703, 12789,
     855,  2703,  3531,  2173,  2173, 18037,  3548,  2615, 13445,   953,
   13445,   953,  2703,  2703,  2703, -4100, 18037,  2706, 18037, 18037,
   -4100,  2985,  1628,  2687,   734, 58124, 26391,   623, -4100, -4100,
   -4100, -4100,   815, 46712,   116, 26391, 49248,  2709, -4100, -4100,
   -4100, -4100, -4100, -4100,  -136, -4100, -4100,  3811, 26391,  2795,
    2798,  2803, -4100, 32755, -4100, -4100, -4100, -4100, 32755,   746,
   -4100, 58124, -4100,  2794, -4100, -4100, -4100,   861, 24470, 24470,
   -4100, 24470, -4100, -4100, -4100, -4100, -4100,   394, -4100, -4100,
   -4100, -4100,   290,   315,  3087,  2741, -4100, -4100, -4100, -4100,
   34025,  1628, -4100, 26391, -4100,  3131,     5, 26391,  2719, -4100,
    2724, -4100, -4100, -4100, -4100, -4100,  1548,  2833, -4100,  3368,
   -4100, 12789,  -136, -4100, 46712, 46712, 26391, 26391,   706, -4100,
    1369,  2735, -4100, -4100,  3373, -4100,  3453, 20005, 46078,  3179,
    3192, -4100,  2739, 24470, 24470, 24470, -4100, -4100, -4100, -4100,
   -4100,   111,  1628, -4100,  2736, -4100, 47980, -4100,  1628,   815,
    2745,  2746, -4100, -4100,  3126,   627, -4100,  2747,  2748, -4100,
    2740,  2749,  2752, 53686, 12789, -4100,    94, -4100, -4100,   815,
   -4100, -4100, -4100, 18037,  1739, -4100,  1628, -4100, -4100,  -136,
    3207, -4100,  1628,  2753, 58124, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,  3231, -4100,
    2941,   588, -4100, -4100, -4100, -4100, -4100, -4100, -4100,    -2,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100,  2997,  2594,  2765,
    2930, -4100,    -2,   187, 26391,    -2,    -2,  1628, -4100, -4100,
   -4100, -4100, -4100,  2774, -4100,  2834, -4100, -4100, -4100, -4100,
   58124,  2817,  2937, -4100,  2777, -4100, -4100, 26391, -4100,  2780,
   -4100,  3239,  3389,  2594, -4100, -4100, -4100,   815,   815,  3090,
   -4100,  -136,  2917,  2918,  2920,  2923,  2924,  2960, -4100, -4100,
    -136,  -136, -4100, -4100,   815, -4100,  2128, -4100, -4100, -4100,
   -4100,  -136,  -136,  -136,  -136,  1857,  -136,  -136,  1705, -4100,
   -4100,   815,   815, -4100,  1858, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100,  1311, -4100,  3767,   181, -4100,  3001, -4100, -4100,
   -4100, 26391,  3255, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100,  2804, -4100, -4100, 12789,  3289,  3292,  3294,
    3295,  3296,  3298,  3299,  3302,  3306,  3315,  3318,  3319,  3321,
    3323,  3328,  3329,  3330,  3331,  3332,  3334,  3336,  2849, -4100,
   -4100, -4100, -4100, -4100, -4100,   190,   815,   815,   815,   815,
   -4100,  2576, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   41640, -4100, 49248,  3218,  1115,   -45, -4100, -4100, 49248, -4100,
   58124, -4100,  1603, 58124,  2853,   630,  4938,  1241,  3133,  3134,
    3137, 58124,  2899, -4100, 34659, -4100, -4100,  1300, -4100,  2855,
   15413, -4100,  2860, -4100, 12789, -4100, -4100, -4100,  1371, 12789,
   12789,  3356,  2556, -4100, 48614, -4100, -4100, -4100, 12789, -4100,
   12789, -4100, 12789, 12789, 12789, 12789, 48614,  2556, 12789, -4100,
    2864, -4100,  3271,  3273, -4100, -4100, -4100, -4100, 12789, -4100,
   12789, 12789, -4100, 12789, 12789, 12789, 12789, -4100, 12789, -4100,
   -4100, 18037, -4100,  2865,  2877, -4100, -4100, -4100,  2880, -4100,
   12789, -4100, -4100, -4100, -4100, -4100, -4100, 12789, -4100, 12789,
   -4100, 12789, 12789, -4100, 12789, 12789, -4100, -4100, -4100, 16069,
   12789, 12789,  2881, -4100, -4100, 12789, 12789, 12789, -4100, 12789,
     321, 12789,   369, 12789,  1503, 12789, -4100, 12789, -4100, -4100,
   -4100, -4100, 12789,   374,  1548,  1857,  2884, -4100,  1712, -4100,
   -4100,  1170, -4100,   919,  2886, -4100, -4100,  1595, -4100, -4100,
   49248, 12789, -4100, -4100, -4100, -4100, -4100, -4100, 18037,   453,
    2889, 18037, -4100,  3531,  3083,  3083,  2404, 12789,   855,  3531,
   12789,  2898,  2872, -4100, 12789, 58124, -4100, -4100, -4100, -4100,
   49248, -4100, -4100, -4100, -4100,   116, -4100,  2459, -4100, -4100,
    2719, -4100,  3388,  2902, -4100, -4100, -4100, -4100, -4100, -4100,
    1745, -4100, 41640,  3551, -4100,  2903, -4100,  2908,  2989,  2996,
    2999, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100,  2594,  1369, -4100, -4100,  2921, -4100, -4100,
    2617,  3011,  2942,  3301,  3488, -4100, -4100, 58124, 18037, -4100,
    3536,  2928,  2934,  3422,  2938,  1628, -4100,  3020, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100,   805, -4100, -4100,  2944,
    2944, 21918, -4100, -4100, -4100, 58124, -4100, -4100,  3431, -4100,
   -4100,  3219, 46712, 41640,  3408,  3409,  3410,   975, -4100,   350,
   -4100,  1176,  3360,  2594, -4100,  3412, 49882, -4100, 35293, -4100,
   -4100, -4100, -4100,  1154,  3049,  3054,  1673, -4100, -4100,  3361,
    3193, -4100, -4100, -4100,   815,  1628, -4100,  2526, 10165,  2968,
   30847, -4100,  1119, -4100,    58, -4100, 44176,  3450, 44176, 44176,
   -4100,  3258, -4100, -4100,  3207, -4100,  2741,   187, -4100, -4100,
     -72,  2470, -4100, -4100,  1122,  3366,  3374, -4100,  3246,  2068,
    3246, -4100, -4100,  1122, 27665,  1300,  2769, -4100,  1857,  3309,
   -4100, -4100, -4100, 47980, 44810, -4100, -4100, -4100, -4100,  3517,
   -4100,  3521,   221, -4100, -4100,  1375,   786, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100,  1898,  1375,  1375,   553, -4100,   130, -4100, -4100,
   -4100, -4100,  2678,   815,  3560,  3244,   815,   815,  3560,   815,
    3245,  3248,   815,   815,  3072,  3507,   815,  3390,  3098,  1569,
    3393,   815,  3257, -4100,  3102,  3515,   815,   815,   815,   815,
     815,  3560,  3260,  3614,   815,   815, -4100,   815,  3265,  3266,
     232,  3267,  3275,   815,   815,   815,   815,   168, 58124,   815,
     815,  3276,   815, -4100, -4100,  5592, -4100, -4100, -4100, -4100,
   -4100, -4100,   822, 25113, -4100, -4100, -4100, -4100,   815,    16,
     996,  3097,   269,  3027, -4100,   367,  3029, 54320,  1628,  3030,
    1857,  -136,  -136,  1119,  -136,  1857,  -136,  -136,  -136,  -136,
    -136,  -136,  -136,  1857,  1857,  -136,   913,  1273,  -136,  1857,
    4191,  -136,  1548,  1375,  1375,  2027, -4100, -4100,  3304,  3468,
     815, -4100,   167, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100,  3124, -4100,   151,  3225,  3038, -4100, -4100,   106,
   -4100, -4100,   115, 26391, 20644, -4100, -4100,  3293, -4100,  3530,
     918,   918, -4100, 26391, 26391, 26391, -4100,  3033,  1300,  2741,
    1622,  2741,  3052, -4100, 13445,  1744, -4100,  1628, 12789,  1628,
    2088, -4100,  3053,  3053,  3053, -4100,  3057, -4100, -4100,  3053,
    3451,  3053,  3454,  3058,  3059,  1751,  1284, -4100,  1754,  1521,
    1748,  3061,  3062,  1519, -4100, 12789, 12789,  1771,  1785,   537,
    1269,  1295,   495, -4100,  1802,  3728, -4100, -4100,  1815,  1832,
    1850,  1860,  1303,  1868,  1761, 13445,  1896,   377,   540, -4100,
    1917,  1315,  1335,  1945, 12789,  1947, 12789,  1961, 12789,  1977,
    1987,  2016,  3064,  3064,   141, -4100,  3056, -4100, -4100, -4100,
    3070, -4100, -4100,  2200,  1170, -4100, -4100,  3073, -4100, -4100,
    3046,  1628,  3076, -4100, -4100, 12789, -4100,   203, -4100, -4100,
   18037,   705,  3077, -4100,  1628, -4100, -4100,  3078,  1519, -4100,
   -4100, -4100, -4100, -4100, -4100,  3096,  3877, 32755, -4100, 58124,
     989,  3352,  3091, 35927, 41640, 41640, 41640,  3085, 12789, -4100,
   -4100,  3365, 26391, -4100,  3501, -4100, -4100, -4100, -4100, -4100,
    3092,  3089, -4100, -4100, -4100,  3531,  3470,  3350, -4100, -4100,
    1548, 58124, 46712, -4100,  2407, 27665, -4100,  3100, -4100,  3100,
    1514,  3103,  1795, -4100, -4100, -4100,  3093,  2242,  1803, -4100,
   20005,  3552,  2458, -4100, 41640, 41640, 41640, -4100,  2741,  2741,
     165,  3151,  3500, -4100, -4100, -4100, -4100, 54954, -4100, -4100,
   -4100, -4100,  1194, -4100,  3104,  3105,   146,  3333, -4100, -4100,
   -4100, -4100, 10165, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100,  2594, -4100, -4100, -4100, -4100,
   44176, -4100, -4100, -4100, -4100, -4100,    -2, -4100,  3593, -4100,
    3110,  -221,  1470, -4100,  2496, -4100, -4100, -4100,  3506,  3246,
    3246,  1122,  3512,   811,  3112, -4100,   815, -4100,  2360, -4100,
    2407, -4100, -4100, 12789, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100,  1311, -4100, -4100, 28302,  1518, -4100,   214,
   -4100,  1518, -4100,   158,   158,  1518, 55588, 28302,    82,  1119,
    1857,  1709,  1857, 56222,    82,  -136,  -136,  2405,   815,  1857,
   -4100, -4100,  3513,  1709,  3516,  1709,  1709, -4100, 49248, 58124,
   -4100,   815,  1358,  1857, 56856,  1119,  1119,  1709,    82, 27665,
    3014,  3142, -4100,  -136,    82, -4100, -4100, -4100, -4100, 26391,
      82,    82,  1624,  3263,  3438,  3449, -4100, -4100, -4100,  1857,
    3142, 56222, -4100, -4100,  6841, -4100, -4100, -4100, 21281, 58124,
     297,   196, -4100,  3109, 39104,  3359, -4100, 12789, 12789,  3399,
   58124,  3402, -4100,  3697, 58124,  3762, -4100,   127, -4100, 56222,
   -4100,  3132, -4100,  3138, -4100,  1857, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100,  3135, 58124,  1375,  1115, -4100, -4100,
   -4100, -4100,  -136,   115, -4100, -4100, -4100, -4100,  3418,  3427,
   58124, -4100, -4100, -4100, -4100,  3305, -4100, 26391,  3153,  3155,
    3150, -4100, -4100, -4100,  1042, -4100,  5554, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, 34659,  2741,  3424, -4100,
   -4100,  3083, -4100,  1628, 12789,   957, -4100, -4100,   219, -4100,
     976, -4100, -4100, -4100,  3159, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100,  3099, -4100, -4100,  2556, -4100, -4100, -4100,  3161,
    3083,  3083, -4100, -4100,  3763,  3335, 12789, 12789, -4100, 12789,
   -4100,   226,  3163,  3190, -4100, -4100, -4100, -4100, 12789, -4100,
   -4100,  3083, -4100, 12789, -4100, -4100, 12789, -4100, 12789, 12789,
   -4100,  2029, -4100,  2057, -4100,  2099, -4100, -4100, -4100,  1548,
    3167,  3549, -4100, -4100, -4100,  1548,  3357, -4100, -4100,  1548,
    1857,  2524, -4100, -4100,   814, 58124, -4100, -4100,  1823, -4100,
   -4100, 12789, -4100, 49882, -4100, -4100,  3395, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100,  3617, -4100, -4100, -4100, -4100,  -139,
    -139,  -139, 16725,  1628,  3675, -4100, -4100, -4100,  3501,  3561,
   -4100,    65, -4100, 58124,  3176,  1400, -4100,  1843, -4100, -4100,
    3180, -4100,  2200,  3181, -4100,   815, 16725,  2944,  3355, -4100,
   -4100,  1514, 27665, 35293, -4100, -4100, 58124, -4100, 41640,  2739,
    2739,  2739,  2594,  3624,  3011,  3011, -4100, 31483, -4100, -4100,
    3346, -4100, -4100, 36561, -4100, -4100, -4100, -4100, -4100, -4100,
   30847, 53686, -4100, -4100,  2594, -4100,  -136,  2582,  1595,  2721,
   -4100,  1300, -4100,  1122,  3582,  3583, -4100,  1122, -4100, -4100,
   27665,  2741, 16725, -4100,  2200,  1628,  3189,   323, -4100, -4100,
   -4100,    82,  3200,  3591,  3594,   158, -4100,  1518, 28302, -4100,
   -4100,  1518,  1518, -4100, -4100, -4100,    96, 56222, -4100, -4100,
   28302, -4100, -4100, -4100,  3191, -4100, -4100,  1548, -4100, -4100,
   44810,  -136, -4100,  1709, 58124, -4100, 28302, 28302, -4100,  3215,
    -136, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   28302, 56222,  3201, -4100,   323, -4100, -4100, -4100, -4100, -4100,
    1905, -4100, 56222, -4100, -4100, 56222, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100,  3209,  3123,  2011, -4100,  3206, -4100, 58124,
   -4100, -4100, 26391, -4100, -4100, -4100,  5128, 58124, -4100, -4100,
   -4100, -4100, -4100,  1628,  3083,  3775, -4100, -4100,  3362,  -136,
    3714, -4100,  1851, -4100, -4100, -4100,  3628,  3213, -4100, 54320,
    1855, -4100, -4100,  1898, -4100, -4100, -4100, -4100,  3372,  1294,
   -4100,  3397,  3216,  3224, -4100, -4100,  -136,  3230, -4100, -4100,
   21281, -4100, -4100, -4100,  3852, -4100,  3232,  3235,  3237,  2855,
   -4100,  3616,   363,  1628,  3241,  3242,  3251,  3254,  3862,   195,
   -4100,  3869, 48614, -4100, -4100, -4100,  1914,  3540, -4100, -4100,
   -4100,  3053, -4100,  3057, -4100, -4100, -4100,  3851, -4100, -4100,
    3053,  3664,   219, -4100, -4100,  3268, -4100,  3270,  3277, -4100,
     318,  3282,  2132,  1337,  1933,  3579,  3655, -4100,  3511, -4100,
    2136,  1236,  2174,  2176,  2192,  2197, -4100, -4100, -4100, -4100,
   -4100,  3284, -4100, -4100,   385, -4100,  3272,  1288,  1470, -4100,
   -4100,  1970, -4100,  3653,  3558,   208,  3312,  3312,  3312,  1739,
    1628,  1985, -4100, -4100, -4100, -4100,  3694, -4100, -4100,  3297,
    3368, 58124, -4100,  3350, -4100,  2524, 27665, 16725,  3307,  3291,
   -4100,    -9, -4100, -4100,  3286, -4100, -4100,  2739, -4100,  3906,
    3739, -4100, -4100, 49248,  3311, -4100, -4100,  3619, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100,  2777,  2652,  3363,  1122,
    1122,  2984,  3367, 12789,  3314, -4100,  3424, -4100, -4100,    43,
    2524, 12789, -4100, -4100, -4100, -4100, 12789,  1518, -4100, -4100,
   -4100, -4100,  3316, -4100, -4100,  3831,  3835, -4100, -4100,  1234,
   58124, -4100,  3106, -4100, 28302,  3191, -4100,   209,  3413, -4100,
   -4100, -4100, 27665, -4100, -4100, -4100, 58124, -4100, 26391, -4100,
   -4100,  3324, -4100,  3053,  3053,  3053, -4100, -4100,  3053, -4100,
    3057,  3567, -4100,  3057,  3057, -4100, -4100, -4100, -4100, -4100,
     219,  2610, -4100, -4100,   219, -4100, -4100, -4100,   161,  -189,
    3057, -4100, -4100, -4100, -4100, -4100, -4100, -4100,  3053,  3053,
    3053, -4100, -4100,   219,  3053, -4100,  3053, -4100,  2932, -4100,
     222,   128,  3053,  3053,  3053,  3159,  3322, -4100, -4100, -4100,
   -4100, -4100, -4100, 58124, -4100,  1142, 58124,   131, -4100, -4100,
   -4100,  1857,  2004,  -136, -4100, -4100, -4100,  3338,  3327, -4100,
   -4100, -4100,   996, -4100, 58124,  5128, -4100, -4100,    -9,  5592,
   -4100, -4100,  1156, 58124, 58124, 58124, 45444, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, 48614, -4100,  3947,  3615,
    3347, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   12789, -4100, -4100, -4100, 12789, -4100, -4100,  3647,  3807, -4100,
   -4100, -4100, -4100, -4100, -4100,  3339, -4100,  1857,  1176,  1176,
   -4100, -4100, -4100,  3970, -4100,  3440,  3444, -4100, -4100,  3447,
   -4100, -4100,   108,  1482, -4100, -4100, -4100, -4100, 16725,  3727,
    3456, -4100, -4100,  3348,  3404, -4100, -4100,  1288, -4100, -4100,
   -4100, -4100, 12789, -4100,  3424,  2405, -4100, 31483, -4100,   814,
   -4100,  3403, -4100, -4100, -4100,  3411,  1628, 58124,  3616, -4100,
     937,  1288,   323,  -108,  2204,  3369,  3370, 58124,  3378,  3380,
   -4100,  3695, 28302, -4100, -4100, -4100, -4100, -4100, 26391,  5128,
      82, -4100, -4100,  3191,   805,  3364, 58124,  3703, -4100, -4100,
   -4100, -4100,  1181, -4100,  3381,  1181,  1181, -4100,  2357, -4100,
    3407,   219, -4100, -4100,  3429, -4100, -4100, -4100,  1181,  3406,
     219, -4100, -4100, -4100, -4100,  1181, -4100, 49248,  -136,  3308,
    4005, -4100,  3425, -4100,  3909,  3785,  4031, -4100,  3256, -4100,
    3792,  3688,   815, -4100,   219, -4100, -4100,  3947, -4100,   219,
    3947,  1181,  1181, 58124,  3537, -4100, 64464, -4100, -4100,  -161,
    3430,  2008, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
     866, 58124, 26391,  3399,  3604, -4100,  3106, -4100, -4100,  3293,
    3355, -4100,  2020,   323,  3417,  2023,  2031,  3895,  3599,  3610,
   -4100, -4100,  3421,  3423,   323,  2221, -4100, -4100, -4100,  3432,
   -4100, -4100,  3941, -4100, -4100, -4100, -4100, -4100,   325,  3707,
    1857,  1857,  1857,   -82,  1482, -4100, -4100,  3490, 26391, 18037,
    3553, 58124,  1564,  3252, -4100,  1180,   323, 12789,  2594, 44810,
   -4100, -4100, -4100, 12789,  3439, 12789,  3442,  2037, -4100, -4100,
   -4100,   158,   158, -4100,   937, -4100, -4100,  1548,  3350, -4100,
   -4100, 58124, 58124,  2040, 58124, 58124,  2795,  2798,  2803,  1273,
    1273, -4100, -4100,   297, -4100, -4100, -4100,  3843, -4100, -4100,
    2094, -4100,   978,  3720, -4100, -4100, -4100, -4100,  1181, -4100,
     318, -4100, -4100, -4100, -4100, -4100,   318, -4100, -4100, -4100,
   -4100,  3445, -4100, -4100, -4100,  3735,  3489, -4100,  3448, -4100,
   -4100, -4100, 39738, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   12789,  3942,  3476, 58124,   904, -4100,  8392,  8392, 58124, -4100,
   -4100, -4100, -4100,  6088, -4100, -4100,   837, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,  4072, -4100,
    3446, -4100, -4100,  3458,  1263, -4100, -4100, 58124, 57490, -4100,
   -4100,  5128,  3917,   269, -4100, -4100, -4100,  1042,  3461,  2242,
     270, 58124, -4100,  3740,   136,  1740, -4100,  3939,  2200, -4100,
   -4100, 12789, -4100, -4100, -4100,  4053, -4100, -4100, -4100, -4100,
   -4100, -4100,    87, -4100, -4100, 27665,  2769, -4100,  1548, -4100,
    2100, -4100, -4100, -4100,  3554,   815,   815,  3975,  3978,   815,
     815,   815,   815,  3469,  3252, -4100,  3958, -4100, -4100, 12789,
   -4100, -4100,  1628,  3708, -4100,  4052,  1470,  1628, 58124,  1628,
   58124, -4100,  3933,  3933, -4100, -4100,  2107,  2119,  2126, -4100,
    2137,  2143, -4100, -4100, -4100, -4100,   297,  3478, -4100, 58124,
   -4100, -4100, -4100,    88, -4100, -4100,  2145, -4100,  2154,  1124,
   -4100,  3445, -4100, -4100, -4100, -4100, -4100, -4100,  1628, 12789,
   -4100, 12789,  3505, -4100, -4100,  3934, 58124, -4100, -4100, -4100,
   -4100, 12789, -4100, 64464, 64464, -4100, -4100, -4100, -4100,  4101,
      -9,  4070,  3754,  4078, -4100, -4100,  2162, -4100, -4100,  2704,
   -4100, -4100,  3697,  5128, -4100, -4100, -4100,  -136,   815, -4100,
     270, -4100, -4100, -4100,   815,   323,  3492,  3750, -4100,   136,
   -4100, -4100, -4100,  1740, -4100, -4100, -4100,  2524,   323, -4100,
   -4100, -4100,  3495, -4100,   815, -4100,  3497, -4100, -4100, 58124,
    3499, -4100,  -136,  -136,   815,   815,  2102,  2102,  1548, 49248,
    3609, -4100, -4100,   815,   323, 58124, -4100,  1114,  3876, -4100,
    2222,  2255,   103, -4100, -4100, -4100,  3717, -4100,   270, -4100,
   -4100, -4100,  3350, -4100,   886,   886,   219,   318,   219, -4100,
    3503, -4100,  3504,  1628,  1628, -4100,    70, -4100, -4100,  3911,
    3998, 12789,  1628, 61294,  3509, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, 65098, 12789,
   -4100,   837,  4072, -4100,  3780, -4100,  3781, -4100, 57490, -4100,
   -4100, -4100,  4024, 64464, -4100,  4016, -4100,    -9, -4100,  1857,
     274, -4100, 40372, -4100, -4100,  1639,   274, -4100,   274, -4100,
   -4100, 27665, 16725,  2405, -4100,  3553, -4100,  3518, -4100, -4100,
     -42, -4100, -4100,  -136,  -136, -4100, -4100, -4100, -4100, -4100,
    2267, -4100, 49248, -4100, -4100,  4119,  4133,  4027,  4138,  1114,
   -4100,  -113, -4100, -4100, -4100,  4139, -4100,  4140,  3538,  3539,
   -4100,   270, -4100,   136,  1740,  2284, -4100,  4194, -4100,   172,
    3826,  3827, -4100, -4100, -4100, -4100,  -101,  3580, 12789, 64464,
   -4100,  4047, -4100,  3977,  2223,  3919,  3555, -4100,  3557,  1598,
    4081,  8392,  8392, -4100, -4100, -4100, -4100, -4100,  4065, -4100,
   -4100, -4100, -4100, -4100,  3936,  4210, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,  2295, -4100,
   17381, -4100, -4100, -4100, -4100, -4100, 49248, -4100,  3609, -4100,
    3574,   318,   318,  4188,   318, -4100,  4189,  4190,  -113, -4100,
   -4100, -4100, 54320, 54320, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100,  3643,  4110, -4100, -4100,   120, -4100,   180, -4100,  1628,
   61928,  4195, 58124, -4100, -4100, -4100, -4100, 12789, -4100, 50516,
   62562,  3595, -4100, -4100, -4100,  3777, -4100,  2704, -4100, -4100,
    3786, -4100,  3518, -4100,  3600, -4100,  3531,  3252, -4100, -4100,
    3605, -4100, -4100,   318, -4100,   318,   318, -4100,  3607,  2308,
     886,   886,  -136,  4000, -4100,   120, -4100, 12789, -4100,  4105,
    3701, -4100,  3620, -4100, 64464,  2187, 64464, -4100, -4100,  4056,
    3622,  1424, -4100,  3621, -4100, -4100, 64464,  4037,  4052, -4100,
   17381,  3625, -4100, 12789,  3629,  3623, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100,  1628,  4218, 64464,
   58124, 59392,  3829, 63196,  4088, 58124,  5128,  4089,  4090, -4100,
   64464, -4100,  4238,  3876, -4100, -4100,  1628, -4100, -4100,  3723,
   -4100, 60026, -4100,  2819, -4100,  3661, -4100, -4100,  4159,  2444,
   -4100, -4100,   318,  4059, -4100, -4100, 64464, 64464, -4100, -4100,
   -4100, 38470, 12789, -4100, -4100, -4100, -4100, -4100,   975, -4100,
    3925,  3644, 60660, 63830, -4100, -4100, -4100, 33391, -4100, -4100,
   -4100,  4098, -4100,  1628, -4100,    59, 22555,  3808, 38470, -4100,
   -4100, -4100, -4100, -4100, -4100, 49248,  2328, -4100, -4100, 27665,
   -4100, -4100, -4100, -4100, 25752,  3648, -4100,   815, -4100, 27665,
   -4100, -4100, 16725, -4100, -4100
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4100, -4100, -4100, -4100, -4100,   148, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100,  1936, -4100, -4100, -4100, -4100, -4100,
    1635, -4100,   525, -2397,  -512,  3313, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100,   806,  1746,  3633,
   -4100,   519, -4100,   129, -4100, -4100, -4100, -2968,    -8,  -224,
   -4100, -4100,  1541,    27,  3262,  -222, -3324, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100,   529,   527, -4100, -4100,
     322, -4100, -4100, -2202, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100,  -435,  -393,  1862, -4100, -4100, -4100,  4279, -4100,
    3729, -4100, -1830,  2395, -4100, -4100, -4100, -4100, -4100,  2460,
   -1757, -4100, -4100, -4100,  1495, -4100, -4100, -4100,  -173,   347,
   -4100,   348, -4100,   349, -4100,   352, -4100,   356,   359,   360,
     361, -4100,   364, -4100, -4100,  -392, -4100, -4100, -4100, -4100,
     365, -4100, -4100, -4100, -4100, -4100, -4100, -4100,  -248, -4100,
   -4100,   -54, -4100, -4100,  -243,   370, -4100,  -177,   372, -4100,
     373, -4100,   -70, -4100,   -71, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100,  3269, -4100, -4100,
   -4100, -2316, -4100, -4100, -2258,  2784, -4100, -1840, -4100, -4100,
   -1956, -4100, -4100, -1663,  -657, -4100, -4100,  1397,  -354, -4100,
   -1464, -1971, -1970, -4100, -4100, -4100, -2065, -2059,  -801,  2528,
   -1228, -2331, -4100, -4100, -4100, -4100,   183, -4100, -4100,   371,
    1747,  2268, -4100, -2540, -4100, -4100,   941, -4100, -4100,  1520,
     763,  1516, -4100,  1085,  3002, -1309, -4100, -4100, -4100, -4100,
   -4100, -4100,    30,   341,   -74, -4100, -3812,   770, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -2739, -4100, -4100, -4100,
    -273, -4100, -4100,  -169, -4100, -4100,  -227, -4100,   170, -2378,
   -4100, -4100, -4100, -4100,  2785, -1397, -4100,  3864, -4100,  -495,
     604,  1782, -2275, -2019, -4100,  -946,  -945, -2957, -4100, -4100,
   -4100, -2147,  1275,  1338, -4100,   889,  1777, -2459, -4100, -4100,
   -4100, -4100, -4100,  1340, -4100, -4100,   500, -4100,   494, -4100,
   -4100, -4100, -4100,  -231, -4100,   133, -3029, -4100, -4100, -4100,
   -2949,  1227,   687, -4100, -4100, -4100, -1072, -3011,  -703, -4100,
     313, -2524, -2576,   657, -4100, -4100,   455, -3945, -4100, -4100,
    -592, -2169, -2469,   -39, -4100, -4100,   479, -3401,  1906, -4100,
   -4100, -4100, -3315, -2244,  1648, -4100, -4100,  1196, -4100, -1551,
    1195, -4100, -4100, -4100,  1202, -4100,    61, -4100, -4100, -4100,
   -4100, -4099, -4100, -4100, -1572, -2467, -4100, -4100,  4434,  4437,
   -1590, -3130, -4047,   -53,   -55, -4100, -4100, -4100,  2254, -1222,
     122,   113,   114,  1743,  -933,   266,  1070, -1601, -4100,   343,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100,  1828,  -175, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -2477, -2914, -4100, -4100,
    1398, -4100, -4100, -4100, -2482, -2095, -2085, -2429,  3441, -4100,
   -4100, -4100, -4100,  3396, -2286, -3768, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100,  2933,  1268, -4100, -4100,  1955, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100,   542,  2032, -4100, -4100, -4100,
   -4100,  2340, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
      32, -4100, -4100, -4100,   784,  2859, -4100, -4100, -4100,   -12,
   -4100, -4100, -4100, -4100,  2545, -4100, -4100, -4100, -4100,  2882,
   -4100, -4100, -4100, -4100, -4100, -4100,  1625, -4100,  2065, -4100,
   -1547, -4100, -4100,  1182, -1035,  2021,  -617,  2156,   493, -4100,
    3863, -4100, -4100, -4100, -1768, -1874, -4100,  3544,  -864, -2709,
    2533,  -575, -1930,  1240,   227,  1866,  1465,  4850, -4100, -1200,
   -1147, -4100, -4100,  -665, -4100, -4100, -4100, -4100, -4100,  2275,
    2281,  -603, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100,  1684, -4100, -4100, -4100, -4100, -1262, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100,  1979, -4100, -2125, -4100,
   -4100,  -458, -4100,  3325, -4100, -4100, -4100, -2364, -2002,  1986,
    1153, -4100, -4100, -4100, -4100, -4100, -4100, -4100,  1996, -4100,
   -1623, -4100, -2814, -4100, -4100, -4100, -4100, -4100,  2195, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -1666, -4100, -1893,   263,
   -4100,   445, -4100, -4100, -4100, -4100, -4100, -4100, -4100,   -61,
    1023,   -59, -3304, -1142,  1769, -4100, -4100, -1329,  3371, -2389,
   -4100, -4100, -4100,  2177, -4100, -4100, -4100, -4100, -4100,   824,
   -3020,  2978, -4100, -4100, -3264,  -964, -2355,  -935, -4100, -1444,
    1593,   632, -4100, -2022, -1153, -1597, -2992, -2475, -4100,  1474,
   -4100, -4100, -4100, -4100,  -168, -4100, -4100, -4100,   652,  2079,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
    -566,  -914, -4100, -4100,  2341,  -494, -4100,  3508, -4100, -4100,
    3519, -4100, -4100, -4100, -4100,  3170,  3143,  2144, -4100, -4100,
   -2655, -4100, -4100,  2109, -4100,   924,  -931, -1684,  1237, -4100,
   -4100,  1235, -3300, -4100, -4100,  3520, -4100, -4100, -4100,  1185,
   -4100,    95,  3946,  3522, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100,  2922, -1111,  3872, -4100, -4100, -4100, -4100, -4100,
   -4100,  2534, -4100, -4100, -4100, -4100, -4100, -4100,  3084,  3966,
    -596, -1349, -4100,  -804,  2537,  2064,  -915, -4100, -4100, -4100,
   -4100,  3972, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100,  2715,   865, -4100, -4100, -4100, -4100,  3165, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,  1277,
     -88, -4100,    90,  -121, -4100,     3, -4100, -4100, -4100, -4100,
   -4100,  -191, -4100, -4100,  -194, -4100, -1031, -1446,   628, -1322,
   -2590, -4100,  1264,  3148, -3449,  -683, -1195, -1224, -2686,    80,
   -4100, -4100,  3631,    71,  -426,  -336,    -6, -2962,   -97,  -586,
    -625, -4100, -2375, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100,  2103, -4100, -4100, -4100,  1239, -4100,  3993, -4100,  2802,
    1242,  3996, -1421,  2621,  2115,  2120, -4100, -4100,  2125, -2012,
   -4100, -4100,   171, -4100,  2693, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100, -4100,
   -4100, -4100,  3766,  -461,  -483,  3172,  4012,  3682, -4100,  3243,
   -4100, -4100, -4100, -4100, -4100,   568, -4100,   962,  2155, -1295,
   -2366, -4100, -4100,  2986,   981, -4100,  1770,  -281,  -577, -4100,
   -4100,   566, -4100, -4100,  1454,  4019,  3683, -4100, -4100, -4100,
   -4100, -4100, -2807,  -921, -4100, -3479, -2869, -1755, -4100, -4100,
   -2222, -3086, -4100, -4100, -1088, -4100, -4100, -4100, -4100, -2110,
   -4100, -4100, -4100,    46,  4082,  4083, -4100, -4100,   662, -4100,
    -437, -4100, -4100, -4100, -4100, -4100, -4100, -4100,  3937, -4100,
   -4100, -4100, -4100,  3940, -4100, -4100, -4100, -4100, -4100,  3943,
   -4100, -4100, -4100, -4100, -4100,  1814, -4100, -4100, -4100, -4100,
   -4100, -4100, -4100, -4100, -4100
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2761
static const yytype_int16 yytable[] =
{
     513,  1096,   897,  1004,  1554,  1035,   957,  1000,   558,  1561,
    1436,  1049,  1682,   557,  1865,  1775,  2203,   565,   576,  2635,
    1450,  1453,  2466,  2467,  2133,   584,  1645,   579,   667,  2636,
     643,  1466,  2326,   511,   591,  1516,  1304,   594,  2012,  1486,
    2011,  1726,   591,  1979,  1774,  2199,  2200,  2130,  2849,   612,
     830,   831,   832,  1906,   834,  2744,   836,  1480,  1190,   838,
    1749,   840,  1797,  2881,  1486,  2975,  3042,  2751,  1877,  1805,
    2986,  3418,  3667,  2558,  1864,   139,  1841,  3115,   873,  2833,
    3324,  1915,  3479,  3360,   818,  1517,  1691,  1104,  2986,  2986,
    1010,  1142,   632,  1017,  3251,  2625,  1085,  1088,  1566,  1567,
     872,  1113,  1121,   563,  1537,  2809,  2372,  2449,  2905,   927,
    2088,  3486,  2752,  2998,  2949,  3419,   635,  2945,   513,  2688,
     513,   642,   648,  1807,  1808,  2689,  4037,  1811,  1812,  1813,
    1814,   872,  1816,  1817,  1819,  1821,  1822,  1823,  1824,  1825,
    3494,  2570,  2571,  1287,  3993,  3007,  2019,  3366,  3531,  3011,
    2954,   637,  3881,   639,  2173,  1366,  2101,  3178,  3179,  2963,
    3026,  1590,  3242,  3185,  3976,  3187,  2032,  2066,  3598,  2362,
    3703,  3130,  3037,  3548,  2035,  2036,  1254,  1255,   631,   653,
     520,  1254,  1255,  2462,  2313,  1910,  1129,  2185,  1130,  1131,
    1132,   571,  1921,  2101,  1245,  1246,  1247,  1518,  2986,  2986,
     575,  1254,  1255,  4642,   664,  2721,  1288,   583,   872,  1360,
     601,  2805,  3183,  2685,  2686,  2676,  2219,  3814,  1601,  4327,
     604,  1366,  3902,  3944,  4394,  3319,  4519,  2936,  1254,  1255,
    3346,  2222,  2990,  2991,  1254,  1255,  4320, -1558,  1469,  1115,
    1123,  3538,  3135,  3562,  3538,  3141,  3685,  3826,   879,   121,
    2166,  2994,  3046,  1307,  1531,  3539,   966,   947,  3539,  3682,
    1375,  3382,  2362,  1089,  2566,  1878,  4256, -2708,  2639,  3540,
   -2638,  3575,  3540,  1469,  3855,  1563,  1289, -1558,  3243,  3382,
     966,   947,  4561,   966,   947,   901,  2573,  4211,  1254,  1255,
   -2080,  3915,  4077,  2800,  1563,  1109,  4511, -1598,  2412,  3521,
    1110,  1367,  4593,  1544,  4589,  -933,  3469,   654,  1011,  2459,
    3380,   572,  1379,  3056,  1099,  4495,  3605,  3334, -2476,  4008,
    1398,  3396,  1563,   621,  -572,  4264,  3148,  3879,  1254,  1255,
    3168, -1893,  3170,  1254,  1255,  2080,  4519,  4761,  1254,  1255,
    1648,  4502,  3121,  3122,  3672,  1648,  2090,  1310,  2118,  2680,
    1964,  3136,  -573,  4327,  2978,   568,  1023,  2692, -2109,  1484,
    2460,   138,  4496,   608,   134,  3142,   271,  1367,   273,  1526,
     123,  2084,  2041,  3358,   872,  1091, -2708,  4350,  4446,  3075,
    3086,  4024,  1230,  2533,  2534,  1487,  1254,  1255,  1619,  1491,
    2179,  3855,  2527,  1292,  1254,  1255,  2131,  4328,  3047,  1918,
    2545,  1579,  1580,  1629,  1254,  1255,  3242,  1071,  2084,  3383,
    2792,  1497,  3081,  1620,  4576,  3937,  3942,  2563,  2564,  3943,
    2132,  1254,  1255,  2547,  3128,  3946,   138,  3082,  3947,  3076,
     670,  1630,  3359,  4056,  3157,  2413,  2793,  2314,  3953,  1488,
    1254,  1255,  3087,   559,  1919,  3975,  1623,  3758,  4577,   135,
    2102,  1527, -2556,  2042,  4584,  1092,  4351,  2899,  1393,   569,
    3673,  1111,  1357,  1602,   870,  3856,  2119,   609,  2062,   882,
    1254,  1255,  2979,  1649,  1254,  1255,  2924, -2557,  1671,  1300,
    1511,  1879,  2671,  2672,  2673,  2674,  3470,  2102,  4497,  2081,
    1690,   622, -2476,  1411, -1598,   870,  2062,  3057,  4391,  1837,
     271,  2898,   273, -2760,  1190,  1545,  2971,  1012,  2059,  3332,
    3333,  1532,  1254,  1255,  2290,  1625,  1380,  2693,  3522,  2784,
    4594,   642,  3243,   648,  1965,   138,  1974,  2167,  3329,  3330,
    3331,  4328,  4762,  1838,  1626,  1627,  1628,  3392,  1024,  1025,
    4590,  4682,  4683,  1256,  4078,   648,  1257,  3143,  1256,  3658,
    3906,  1257,  2484,  3662,  3335,   642,   877,  1254,  1255,  2598,
     642,   902,   887,  4212,  1231,  1232, -2556,  2786,  4046,  3857,
    1090,   881,   870,  3223,  2014,   905,  2363,  2017,  3576,  2101,
    4505,  2020,  3856,  2023, -2259,  1434,   642,   661,  3686,  1290,
    1470, -2557,   958,  4067,  1376,  1256,  2570,  2571,  1257,  2986,
    1802,  1256,  1019,  3625,  1257,  4186,  2625,  3244,   880,  1841,
    4557,  2038,  2039,  1254,  1255,  1865,  2064,  2688,  1566,  1567,
    1880,  1038,  2088,  2689,   674,  1470,  4113,  2962,  3096,  3384,
     642, -1598,  1054,  3101,  3472,  4117, -2285,  1587,  4076,  2414,
     888,  3109,  3110,  1254,  1255,   513,  3898,  3117,  2569, -1558,
     632,  2986,  1083,  1866,  3144,  1256,   632,   632,  1257,  4133,
    2640,  1097,  1054,   642,  4135,  3670,  3632,   642,  2343,  2363,
    1810,  1566,  1567,   661, -2404,  1864,   661,  3378,  1070,  2346,
    1020,  2937,  2349,  1137,  2506, -2109,  2220,  1831,  4395,  2161,
    1632,  1603,  1659,  1660,  3252,  1256,  4405,  2906,  1257,   602,
    1256,  1110,  3380,  1257,   995,  1256,  3137,  2173,  1257,   605,
     573,  2685,  2686,  1361,  3688,  4643,  3167,  2034,  1714,  3123,
    2684,  2340,  1254,  1255,  1127,  2992,  1727,   841,  1729,  3851,
    3696,  3697,  3347,  1922,  3858,  1191,  1080, -2638,   870,  1303,
    1742,  1743,  1744,  1844,  3700,  1254,  1255,   895,  1748,  4192,
    3859,  4718,  4348,  1256,  3548,   908,  1257,  2186,  3131,   929,
    4202,  1256,  1911,  2419,  1257,  4337, -2638,  2187,  2066,  1873,
    1603,  1256,   603,  2089,  1257,  3945,  3914,  1104,  3530,  3495,
    3175,  1021,  3940,  3994,  2993,  3635,  3245,  3815,  1256,  1839,
    4374,  1257,  4241, -1598,  2084,  3505,  1251,  1258,  1253,  1254,
    1255,  -933,  1258,  4062,  1941,  3048,  4596,  1256,  1071,  3385,
    1257,  3541,  1254,  1255,  3541,  1855,  2329,  2178,  2315,  1908,
    -572,  3127,  1258,  1296,   513,  1298,  1299,  1054,   513,   642,
     642,  4433,   513,   642,  2048, -1598,  1928,  1256,  1342,  3973,
    1257,  1256,  1940,  3860,  1257,  3892,  3893,  2953,  -573,  1258,
    1492,  3244, -2109,  2710,  1451,  1258,  1454,  1297,  2090,  1457,
    1462,  1301,  1111,  2854,  4058,  1306,  1959,  3859,  2018,  3506,
    1782,  1783,  1498,  2102,  3175,  1371,  1483,  2711,  2236,  1256,
    1026,  3525,  1257,  2988, -1920,  1254,  1255,  2431,   632,  3006,
    3758,  1521,  3009,  3010,  3263,  3012,  1358,  1934,  3015,  3016,
     642,   632,  3019,  2968, -2760,   632,  1233,  3028,  1170,  1258,
    3349, -2259,  3032,  3033,  3034,  3035,  3036, -2556,  3679,  1838,
    3040,  3041,  3204,  3043,  1256,  2237,  2305,  1257,  1289,  3052,
    3053,  3054,  3055, -2632,  3304,  3059,  3060,  3695,  3062,  4506,
    2881,  3692, -2557,  2179,  4380,   642,  4381,   642, -2556,  1258,
     642,   642,  1254,  1255,  1258,  1446,  2691,  1254,  1255,  1258,
    3653,  2498,  3637, -2285,  1782,  2255,  3158,   642,  4541,  2635,
    2291,  1395,   889, -2557,  1382,  3821,  2068,  3638,  1994,  2636,
    1256,  1446,  3666,  1257,  3824,  1452,  2431,  1401,  3399,  1838,
    3401,  1407, -1921, -1920,   909,  4440,  3126,  3412,  1171,  3657,
    3312, -2404,  2049,  3661,  2477,  2998,  2050,  1258,  3916,  2256,
    1256,  3425,   632,  1257,  1335,  1258,  3808,  3025,  3436,  3438,
    3077,   140,  2570,  2571,  3112,  1258,  2341,  2084,  2473,  3183,
    3224,  3455,  3457,  3459,  1562,  4184,  3026,  3460,  3438,  1104,
    2294,  2295,  1258,  1648,  1943,  2625,  1254,  1255,  2488,  2262,
    2012,   516,  2012,  2012,  2941,  2942,  3099,  2211,   632,  2001,
    3327,  1258,  2688,   661,  2502,   661,  3364,  3365,  2689,   632,
    3565,  4453, -2615,  3502,  1254,  1255,  2311,  2312, -2259,  1065,
    2372,  4512,  2088,  4514,  4460,  1715,  3534,  2840,  1716,  1256,
     995,  1258,  1257,  1486,  2702,  1258,  3374,   521,  2723,  2532,
    1271, -1921,  4294,  2569,  2500,  3534,  2814,  2815,   577,  3784,
    4483,  2210,  1256,  2869,  2765,  1257,  2376,  2505,  3785,  2002,
    2508,  2509, -2619,   632,  1634,  1635,  1636,  1641,  1486,  4303,
   -2285,  4069,  2432,  1258,  2193,  3159,  3654,  2181,  2813,  3930,
    4285,  2101,  3931,  1826,  1582,   581,  1254,  1255,  3208,  3209,
    1094,  1095,  1838,   910,  1512,  1792,  2685,  2686,  2946,   872,
    1254,  1255,  4554,  2519,  1254,  1255,  1256,  1191, -2404,  1257,
    3078,  4070,  3950,  3951,  3952,  1839,  1734,  4270,  1258,  1256,
    3955,  1191,  1257,   932,  4298,  4299,  3368,  2333,  3981,  3928,
    3929,  1291,  1830,  3225,  3226,   680,  3183,  2326,  2166,  3183,
    3183, -1920,  2818,  2819,  -476,  1254,  1255,  1590,  1675,  1633,
    1041,  2173, -2632,  1639,  1254,  1255,  3183,  1775,  2684,  1566,
    1567,  2606,  2377,  1066,   606,  2348,  1254,  1255,  3596,  3923,
    3954,  2432, -1920,  1776,  1258,  1522,  3974,  3977,  3979,  3980,
    1867,  1290,  2499,  1254,  1255,  1839,   642,  3535,  2929,  2812,
    2228,  4507,  1256,  1675,  1866,  1257,  3786,  2361,  2350,  2822,
    1944,  2478,   883,  4295,  1258,   890,  3535,  1254,  1255,  2609,
    1676,  2865,   913,  4485,  1254,  1255,  3521,  1473,  3113,  2365,
    2230, -2618,  1447,   642,  4486,  2089,  1254,  1255,  1834,  4304,
     658,  1254,  1255,  4440,  1605,  1274,  1920,  2680,  1785,  1677,
    1775,  1254,  1255,   632,  3192,  2003,  3298,   624,  1447, -1921,
    2930,  2433,  1254,  1255,  2405,  1676,   933,  4311,  2090,  1256,
    1254,  1255,  1257,   995,  1256, -2616,  3536,  1257,  4312,  2966,
    1191,   642,  1254,  1255,  3411,  1474,  2418,  2101,  2427,  2428,
   -1921,  1128,  2368,  1258,  1677,  3546,  4508,  3420, -1920,   642,
     884, -2615,  1254,  1255,  1254,  1255,  2084,   642,  3260,  3261,
    1603,  1827,  1891,  1475,  1894,   625,  1258,   632,  1523,  1678,
    2178,  2334,  2901,  3818,  4475,  4476,  4271,  4379,  4509,   632,
    1142,  2306,  4326,  2690,  1828,   914,  2354,   642,  1254,  1255,
    1254,  1255,   934,  1524,  2355,  3160,   632,   632,   661,  1880,
   -1920, -2619,   722,  2322,  2226,  1291,  1254,  1255,  1839,  2931,
    2433,  3917,  3398,  1256,  1678,  1606,  1257,  3114,  3369,  1607,
    1258,   885,   642,   642,  4011,  1970,  1946, -2617,  1254,  1255,
    1608,  3390,  3390,  1258,  1954,  2102,  2233,  1955,  3428,  3429,
    1042,  1256,  1254,  1255,  1257,  1898,   642,  2179,  1679,  2234,
   -2622,  1254,  1255,  1407,  2691,  2450, -1921,  1975,   958,    44,
    4547,  2902,   915,  1513,   727,  4305,  1786,  1043,   513,   513,
     513,   632,   513,   632,  2070,  2167,  3064,   872,  2013,  4272,
     661,  1838,  4783,  1407,  2015,   513,  2459,   642,  2932,  4347,
    2383,   513,   138,  1679,  2012,  3522,   593,  4487,  1971,  4262,
    4263,  1995,  1996,  1997,  1675,  1999,  1258,   517, -1921,  1254,
    1255,   518,   632,  1256,  4697,  1625,  1257,   627,  2016,  3120,
    1254,  1255,  2235,   870,  2022,  4569,  1648,  1256,  1960,  2569,
    1257,  1256,  1717,   686,  1257,  1718,  4698,  3784,  1254,  1255,
    1991,  3195,  3537,  4071,   633,  4313,  3785,  3421,  1829,  3289,
    3290,  3291,  2084,  2922,  4265,  2677,  1961,  1998,   582,  2000,
   -2618,  3537,  1609,   740,  1484,   642,  1676,  2021,  1865,  4613,
    4613,  2323,  1256,  1258,  4021,  1257,  1254,  1255,  1258,  1476,
     632,  1256,   592,  2335,  1257,  2126,   632,  1648,  1222,  2242,
    4244,   655,   687,  1256,  2243,  2980,  1257,   632,  2033,  2336,
    1283,  1284,  1285,  1286, -2616,   271,  2048,   273,  1947,  3169,
    1256,  4171,  2697,  1257,   642,  1254,  1255,  3619,  3284,   642,
    3259,   513,   513,  3422,  2195,   513,  3988,    58,  1864,  1254,
    1255,  2102,  4188,   636,  1256,  2698,  1137,  1257,  2209,  3373,
    2437,  1256,   756,  1625,  1257,  1254,  1255,  4020,  2100,   638,
    2995,  1775,   995,  1256,  2191,  2192,  1257,  2986,  1256,  1738,
    1610,  1257,  3620,  2684,  1680,  2981,  2120,  1258,  1256,  1254,
    1255,  1257,  2128,  1254,  1255,  4488,   123,  1675,  1223,  1256,
    3315,  4104,  1257,  2253,  3786,  1254,  1255,  1256,   935,   936,
    1257,   938,  4039,   940,  3592,  1258,   651,    13,  3594,  1256,
    -476,  2788,  1257,  4243,  2933,  1972, -2617,  3074,   941,  1680,
    3446,  2254,  3447,   658,  1254,  1255,  1962,  3309,  1477,  1256,
    1762,  1256,  1257,  3423,  1257,   688,  1191,  2263,  4559, -2622,
    4054,  4563,  1681,  4134,  1254,  1255,  4136,  1839,  2817,  1676,
    1478,  1948,  1254,  1255,  2982,  2089, -2708,  4608,   664,  2366,
    2854,   666,  1254,  1255,  4075,  1256,  3448,  1256,  1257,  3502,
    1257,  1254,  1255,   668,  3022,  1254,  1255,  1258,  1677,   681,
    1226,  4171,  4171,  1256,  2049,  2748,  1257,  4399,  3449,  4105,
    2753,  1258,  1479,  2258,  2048,  1258,  3680,  2332,  1254,  1255,
    3683,  3684,   530,  2759,  3989,  1256,  1104,  2270,  1257,  4040,
    4041,  2277,  1254,  1255,  4042,  4043,    25,  2131,  4010,  1256,
    4237,  4238,  1257,  3390,  3450,  1775,  4223,  1629,  1256,  1254,
    1255,  1257,  4106,  4327,  2710,  4029,  1258,  2774,  2893,  2356,
     632,  2132,  1254,  1255,  4239,  1258,  4224,   642,  1678,   632,
     642,   870,  2281,  2326,  3434,  1631,  2354,  1258,  2711,  1254,
    1255,  2282,   632,  2437,  3343, -2708,  2071,  1342,   785,  2472,
    1227,  2438,  1342,  2284,  1258,  2379,  1307,  1254,  1255,   271,
    2072,   273,  2387,  2387,  2178,  2387,  1256,  1254,  1255,  1257,
    2285,  2690,  2256,  4669,  2101,  1254,  1255,  1256,  1258,  3840,
    1257,  2986,  2986,  3025,   642,  1258,  2828,   632,   957,  2691,
    1388,   632,   588,  1389,  2289,  1256,   833,  1258,  1257,   683,
     588,  2307,  1258,  1254,  1255,   684,  2357,  1679,   642,   642,
     632,   632,  1258,  3206,   685,   661,   672,  2223,  4171,  4171,
    1979,  1191,   642,  1258,  1254,  1255,  2728,  2387,  2387,  2387,
     517,  1258,   828,  1256,   518,   844,  1257,  -212,   837,  3207,
     642,   878,  2049,  1258,   898, -1804,  2050,  3218,  2386,  2386,
    2983,  2386,  1254,  1255,  1254,  1255,  1436,   958,  3023,  3228,
     271,  3352,   273,  1258,  4551,  1258,  4552,  2986,  1254,  1255,
    2439,  2440,  1256,  2410,  3024,  1257,  2552,  1382,  2495,  3229,
     892,  3834,   900,  2426,  1254,  1255,  1256,   918,  2437,  1257,
    1486,  4328, -1804,   920,  1254,  1255,  1401,  2430,  2204,  1258,
    2224,  1258,  1256,  2091,    38,  1257,   910,  3451,  4208,  4209,
    4210,  2441, -1893,  2386,  2386,  2386,  2227,  1258,   632,  3532,
    3655,  3355,  1009,  1254,  1255,  3372,  1256,  2073,  4171,  1257,
    1256,  1016,  2229,  1257,  2514,    44,  1254,  1255,  2553,  1258,
    1390,   632,  1256,  4171,  1036,  1257,  2225,  1291,  3567,  3568,
    2491,  3452,  1037,  1258,  2244,  2231,  2232,   669,  4171,   881,
     966,   947,  1258,   673,  1254,  1255,  3905,  2554,  2245,  3581,
    1045,  1256,  2067,  1798,  1257,  2678,  3589,  2252,  2338,  1056,
     835,  2694,  2995,  3908,  3909,   839,  2249,  1291,  1775,  2084,
    1064,  1256,  4428,  2916,  1257,  1254,  1255,  1605,  1071,  1256,
    2166,  1081,  1257,  2074,  2507,   632,  1254,  1255,  1084,  1256,
    1102,  2092,  1257,   906,  2917,  2439,  2440,  1451,  1256,  1103,
    1258,  1257,  1256,  1680,  1108,  1257,   121,  2526,  2075,  1451,
    1139,  1258,  2536,  1140,  4171,  2266,  1775,  2555,  1141,  1254,
    1255,  2543,  2544,  1254,  1255,  1256,  4171,  4171,  1257,  1258,
    2918,    54,  2548,  2549,  2550,  2551,  3318,  2559,  2560,  1256,
    2257,  1291,  1257,  1291,   642,  2966,   642,  1143,  2102,  1163,
    1164,  1026,   642,  1144,  2695,  1145,  1256,   513,  1148,  1257,
    1294,  1254,  1255,  1254,  1255,  2717,   613,  1258,  2720,  1256,
    1295,  2076,  1257,   995,  1254,  1255,  3022,  1866,  1149,  1254,
    1255,  1311,  2267,    58,  1254,  1255,  1256,  1271,   642,  1257,
    2700,  1254,  1255,  1150,  1838,  4171,  2556,  1151,  1606, -1804,
     642,  1675,  1607,  2810,  1256,  4171,  1258,  1257,  1254,  1255,
    1254,  1255,  1152,  1608,  1256,  2259,  1291,  1257,   614,  2131,
    1258,  2350,  1256,  1236,  3691,  1257,  1254,  1255,  1104,  1104,
    1104,  1094,  1095,  2832,  1343,  2271,  1258,  1799,  2084,  1941,
    1941,  1941,  1153,  2132,  2260,  1732, -1804,  1057,  1530,  4171,
    1256,  4171,  2722,  1257,  1535,  1536,  3311,  4356,  1154,  2093,
    1258,  4171, -1893,  1676,  1258,  2272,  1291,  2077,  2273,  1291,
    2094,  1256,  2274,  1291,  1257,  2275,  1258,  2095,  1345,  2276,
    2516,  2278,  1291,  1351,  4171,  1155,  4171,  4600,  4171,  1156,
    1271,  2280,  2980,   615,   642,  4171,  2690,  2517,  1157,  1256,
    1058,  1256,  1257,  1352,  1257,  1258,  4171,  1874,  1354,  2959,
    1875,  1158,  3767,  1876,  1159,  1256,  1355,  4692,  1257,  2829,
    2283,  4171,  4171,  1160,   642,  1258,  1161,  3258,  2561,  2562,
    2012,  1256,  4018,  1258,  1257,  2802,  1291,  4171,  4171,  2084,
    2286,  1256,  4171,  1258,  1257,  1609,   642,  1364,  2298,  1165,
    1366,  1167,  1258,  1168,  3627,  1169,  1258,  2167,  2317,  1172,
    3651,  1173,  2981,  1838,  1174,   995,  1378,  3172,  2838,  2839,
    1256,  3196,  1775,  1257,  3191,  2232,  2096,  3194,  1291,  1258,
    1175,  2863,  1274,  1256,  3220,  1291,  1257,  1176,  3169,  1486,
     932,  1059,  2820,  1258,  3202,  3410,  3024,  4542,  1177,  1030,
    1031,  3315,  1032,  1178,  1033,  2886,  2472,  1451,  3203,  2889,
    1258,  1256,  2557,  1179,  1257,  1180,   642,   642,  3321,  3322,
    4619,  1181,  4691,  1258,  4693,  3210,  3325,  3326,  1184,  4618,
    2910,  1185,  2912,  2168,  1186, -1598,   966,   947,  3214,  1192,
    1258,  2982,  1256,  1610,  1193,  1257,  3600,  1291,  1775,  1800,
    1839,  3822,  1194,  1256,   958,  3215,  1257,  4711,  1258,  1195,
    2013,  2326,  2013,  2013,  1838,  1801,  3622,  3623,  1258,  4252,
    4253,  2097,  3381,  3216,  3772,  3773,  1258,  3434,  3780,  3781,
    3393,  1570,  2565,  3217,  1363,  1274,  1256,  3400,  1776,  1257,
    1256,  3219, -1598,  1257,  4742,  4743,  1367,   642,   642,  3414,
    1196,  3416,  3417,  1197,  1258,  1346,  2960,  2909,  1198,  3831,
    1199,  4362,  4363,  3430,  1200,  4366,  4367,  4368,  4369,  3222,
    1372,  1271,  1203,   933, -1598,  1258, -1598,  1365,  1256,  1204,
    1256,  1257,  1205,  1257,   995,  1276,  1277,  3811,  3819,  1386,
    3227,  1256, -1598,  2552,  1257,   616,  1256,  1374, -1598,  1257,
    1206,  1256,  1207,  1258,  1257,  1258,  3835,  1291,  1256,  4092,
    1208,  1257,  2732,  4355, -1598,  1696,  1209,   617,  3230,  1258,
    3232,  2515, -1598,   121,  1210,  1256,  2521,  1256,  1257, -1598,
    1257,  1211,  3058,  1396,  3234,  1258,  1347,  2169,  2733, -1598,
    1202,  1212,  1348,  3852,  1291,  1258,  1213,  3073,  1214,   934,
    3236, -1598,  3538,   618,  1060,  2553, -1598,  4092,  3867,  3868,
    3237,  3094,  1221,  1215,  4449, -1598,  3539,  1216,  3932,  1839,
    1217,  3935,  3936,  3174,  1258,  1237,  1238,  3997,  2562,  2166,
    3540,  4176,  4177,  1408,  2554,   995,  1349,  1258,  3948,  3238,
    1218,   966,  3938,  4190,  4191,  2734,  4194,  4191,  2735,  1410,
    4473,  4474,  3586,  1350,  4195,  4191,  2736,  2983,  1219,  4482,
    4251,  3326,   619,  4259,  4191,  1258,  1700,   632,  3073,  1426,
    1061,  1603,  1062,  1941,  2737,  1220,   122,   632,   632,   632,
    3587,  1224, -1598,  1279,  1280,  1281,  1282,  1283,  1284,  1285,
    1286,  1225,  3097,  3098,   123,  3100,  1258,  3102,  3103,  3104,
    3105,  3106,  3107,  3108,  2555, -1598,  3111,  1258,  2516,  3116,
   -1893,  1366,  3119,  -669,  1228, -1598,  1274,  4268,  4269,  1229,
    1839,  3574,  3588,  4358,  4359,  2517,  1235,  2515,   957,  2995,
    4385,  3623,  1271,  1239, -2751,  1240,  2948,  2518,  2140,  2141,
    1258,  2996,  4386,  4191,  1258,  1428,  4724, -1598,  1499,  4387,
    4191,  1241,  2546,  3146,  2154,  3833,  1242,  2071,  4604,  3839,
    4389,  4191,   124,  3163,  3164,  3165,  4390,  4191,  4396,  4397,
    1701,  2072,  1243,  3601,  1704,  1244,  2738,  4398,  4397,  1500,
    1293,  1705,  1258,  2556,  1258,  4437,  4438,  2084,  1281,  1282,
    1283,  1284,  1285,  1286,  1429,  1258, -1598,  3841, -1598,  3842,
    1258,  1342,  1430,  2379,  1431,  1258,  1434,  1371,   642,   642,
     642,  2389,  1258,  2390,  4439,  3843,   632,  1437,  2519,  1442,
    3844,  1443, -1598,  4784,  1463,  1261,  1262,  4080,  1467,  1258,
    1468,  1258,  1472,  1501,  1270,  2863,   642,  1493,  1502,  1776,
    1484,  4015,  4016,  -669,  4203,  4493,  3326,   125,   524,  1494,
    2140,  2141,  1495, -1598,  1191,  1496,  3462,  1367,   642,   642,
     642,  1263,  1706,  1519,  2516,  1515,  2154,  1520, -1598,  1276,
    1277,  3342,  2865,  1264,  1525,  2454,  2455,  2456,  4494,  3326,
    2739,  2517,  2156,  2157,  3497,  1533,  2131, -1598,  1534,  3694,
    4567,  4568,  2515,  2518,  4255,   935,   936,   937,   938,   939,
     940,  2832,  3297, -1598,  2013,  3791,  2167,  4587,  3623, -1598,
    2132,  1539,  1838,  1540,  1265,   941,  1542,  3816,  4621,  4622,
    1708,  1547,  -676,  1552, -1598,  1569,  1266,  1274,  1563,  3956,
     587,  4681,  3499, -1598,  2520,  1571, -1598, -1598,  2073,  1573,
   -1598,  1576,  4340,  4344,  4083,  4727,  4728,  1271,  3341,  1577,
   -1598,  4773,  4774,  1267,  4030,  4031,  1581, -1598,  1585, -1598,
    3073,  1775, -1598,  1765,  1766,  1591,  3397, -1598,  3641,  3642,
    3395,  3073,  3407,  1586,  2519,  3957, -1598,  3406,   126,  3607,
    3608,  1614,  2168, -1598, -1598,  3958,  1593, -1598, -1598,  1503,
    4354,  1592,   642,  3406,  2156,  2157,  3431,  3890,  3427,  2557,
    3865,  3866,  3442,  1776,  2521,  1615,  1616,  1622,  3444,  3445,
    1624,  4132,  1625,   632,  2074,  1268,  1642,  1279,  1280,  1281,
    1282,  1283,  1284,  1285,  1286,  3406,  2740,  1644,  1289,  2516,
    1648,  1655,  3073,  3468,  3959,  4357,  1094,  1095,  3481,  2075,
    1674,  1685,  1720, -1598,   513,  1731,  2517,  2997,  3491,  4277,
    1732,   127,  1272,  3406,  1733,  4277,  3408,  3409,  2518,  2515,
    1756,  1773,  1709,  -669,  1504,  1784, -1598,  1809,  1836,  1793,
    1254,  1255,  1815,  1835,  1620,  1273, -1598,  3487,  1711,  1842,
    1276,  1277,  1843,   995,  3441, -2751,  1849,  4340,  1846,  3504,
    2520,  4344,  1652,  1653,  1654,  2741,  4400,  1850,  1851,  3443,
    1852,  1853,  2076,  1854,  3515,  1856,  3960,  1857, -1598,  1672,
    1868,   632,  1869,  2552,   128,  3480,  3435,  1870,  4257,  4258,
    1871,  4260,  4261,  3362,  2742,  1904,  1899,  1907,  1505,  1916,
    3529,  3550,   271,  1924,   273,  1925,  2169,  1926,  1931,  2519,
    1927,  1735,  1274,  1936,  1739,  1937,  1938,  1939,  1950,  1956,
    1980,  1988,  1989,  1993,  2024,  2025,  2026,  2027,  -669, -1598,
    2521,   528,  1094,  1095,  -852,  1758,  1759,  2029,  1839,  1763,
    2030,  2031,  3541,  3507,  2995,  2553,  1692,  1693,  1694,  1695,
    1696, -2751,  2046, -1598,  2060,  4477,  2996,  2069,  3551,  1777,
    1778,  3552,  3687,  3939,  3755,  2115,  2516,  3517,  2077,  3553,
    2675,  2121,  4111,  4112,  2554,  2122,  2135,  1775,  2136,  2162,
    3646,  2180,  2182,  2517,  2190,  4115,  2183,  3554,  2207,  3599,
    2201,  2213,  4118,  2391,  2215,  2518,  3701,  2910,  2216, -1598,
    1281,  1282,  1283,  1284,  1285,  1286,  4354,  3705,  1436,  1275,
    3707,  2552,  2217,  -669,  3437,  2239,  2392,  1506,  4137,  4138,
    2240,  4340,  4344,  3956,  2241,  2520,  2248,  2246,  2256,  2393,
    2247,  3555,  2265,  4059,  1094,  1095,  4049,  2863,   543,  2250,
    3961,  2394,  2261,  2296,  2555,  2297,  2269,  3962,  1697,  1698,
    1699,  1700,  2287,  1451,  1507, -1598,  2886,  3634,  -669,  2288,
    3636,  2327,   642,   524,  2331,  1276,  1277,  2293, -1598,  3957,
    2308,   642,  2309,  2553,  2909,  4225,  2519,  2829,  2310,  3958,
   -1422,  1278, -1279,  4226,   958,   958,   695,  3963, -1598,  3556,
   -1598,  2337,  2395,  1286,  2396,  2521,   544,  1170,  2347,  3894,
    1222,  2131,  2554,  2367,  1776,  1226,  4513,  2382,  2402,  3675,
    4227,  2411,  4173,  1603, -1598, -1598,  2417,  2420, -1598, -1598,
    2423,  2397,  3073,  2556,   545,  2132,  2446,  2445,  3959,  2451,
    2452,  3406,  2552,  2453,  3073,  3454,  2468,  2474,  2475,  2476,
    2481,  2479,  2480,  4452,   642,  2492,  2494,  2496,  3406,  2482,
    3073,  3073,  2483,  4626,  2497,  1701, -1893,  1702,  1703,  1704,
    3964,   546,  2501,  4462,  3073,  3406,  1705,  3652,  2510,  2524,
    4086,  2525,  2555,  2511,  2528,  2529,  3406,   722,  2531,  3406,
    2535,  2537,  2538,  2542,  2539,  1451,  2398,  2540,  2541,  2641,
    3557,  2645,  2520,  3558,  2553,  2649,  2647,  4236,  2650,   523,
    2651,  2652,  2653,  3710,  2654,  2655,   632,  1256,  2656,   547,
    1257,  3766,  2657,  1279,  1280,  1281,  1282,  1283,  1284,  1285,
    1286,  2658,  3693,  2554,  2659,  2660,   271,  2661,   273,  2662,
    4228,  3699,   726,  3094,  2663,  2664,  2665,  2666,  2667,   727,
    2668,  2399,  2669,  2670,  2679,  2701,  2718,  1706,  2713,  2714,
    1412,  2556,  2715,  2726,  3073,  2722,  2731,  2754,  -852,  2755,
    1413,  2756,  2521,  4626,   846,  2355,  2826,  3965,   731,   732,
    2766,  3559,  1775,  2767,  2779,  1414,   642,  2801,  -669,  2808,
    4631,  4632,  2816,  4634,   524,  1775,  3886,  1415,  1416,  1417,
    1775,  2825,  3711,  2555,  2836,  1775,  2837,  2576,  2841,  2577,
    3769,  4768,  2844,  2842,  1707,  1708,  1418,  2552,  2843,  2845,
    3456,  4229,  2846,  2855,  4777,  2852,  2857,  2859,  2552,  4768,
    2867,  3458,  -883,  2858,  4777,  2866,  1911,  3796,  2870,  4230,
    2871,  -817,  -817,  2872,  2579,   -67,  2876,  2890,   740,  2557,
     548,  2891,  4677,  -817,  4678,  4679,  2894,  2895,  2896,  2460,
    2459,  2914,  4231,  2582,   847,  3875,  2915,  1964,  1094,  1095,
    1776,  2583,  2925,  1965,  3961,  2955,  2940,  2943,  2212,  2553,
     525,  3962,  2556,  2956,  2957,  2976,   528,   642,  4236,  2977,
    2553,  2995,  2972,  3008,  3013,  3017,   849,  3014,  2585,  3018,
    3020,  3021,   549,  3027,  4442,  3030,  3029,  3031,  2554,  3038,
     850,   751,  1563,  3039,  3044,  2586,  3050,  3045,  3560,  2554,
    3080,  3963,  4121,   550,  3051,  3061,   755,   756,  1271,  3084,
    3125,  3089,  3095,  1882,  3406,  3124,  3129,  1883,  3073,  3133,
    3134,  4739,  2606,  3166,  2591,  1271,  1776,  3561,  1884,  2208,
    3406,  3186,   632,  4754,  3188,  3175,  3255,  1709,   897,  3180,
    3249,  3189,  3190,  2264,  3197,  3198,  3239,  2268,  -669,  1451,
     854,  1258,  1710,  1711,  3250,  3266,  3253,  2557,  2555,  3257,
    3262,  3265,  1271,   695,  3286,  3299,   551,  3292,  3287,  2555,
    3294,  2292,   552,  3303,  3964,  3302,  4444,  1388,   855,  3306,
    3328,  3339,  3340,  3323,  3317,   856,  3320,  3344,  3345,  3356,
     271,   553,   273,  3348,  3357,  3363,  3370,  3987,  2595,  3477,
    3992,  3367,  3482,  2572,  3485,  3413,  2596,  3488,  3415,  2573,
    3489,  2574,  3493,  2575,  1419,  3498,   554,  3503,  3515,   995,
    3646,  2597,  3499,  3510,  2576,   857,  2577,  4014,  4014,  4014,
    2013,  1420,  3511,   555,  3520,  4232,  3518,  2556,  3519,  2062,
     642,  3547,  3569,   526,  3566,  3516,  3577,  4086,  2556,  3578,
    3590,  3570,  2314,  3244,   722,  3603,  2578,  3604,  3613,  3618,
    3615,  2579,  2580,  3624,   527,  3626,  3639,  2279,  2581,  2437,
    3647,  3659,  3660,  3671,  3698,  3690,  4780,  1313,  2557,  2599,
    2582,  3965,  3676,  3677,  3998,  3702,  3678,   528,  2583,  3709,
    2472,  3708,  2639,  3770,  3768,  3777,  3778,  2600,  2584,  3793,
     777,  4059,  3801,  1274,  4087,  1271,  3792,  4088,  3794,   726,
    1314,   642,  3783,  3797,  3803,  2585,   727,  3804,   783,  3805,
    1274,  2889,  3806,   785,  3809,  3810,   786,   529,  3813,  1563,
    -578,  4014,  2586,   530,  3811,  3817,  3073,  3812,  4096,  3820,
    2587,  2588,   632,  3823,  3825,   731,   732,  2589,  3836,  3837,
    4101,  3827,  2604,  3828,  2605,  2590,  3847,  1274,  1885,  -960,
    3829,  2591,  2607,  1421,  3268,  3832,  3838,  3846,  3853,   531,
    3854,  3863,  2592,  3870,  3269,  3868,  3343,   532,   860,  3871,
    1315,   642,  4442,  4089,  4090,  3882,  1886,  3883,  3888,  3270,
    3880,  2593,  1451,  3910,  1887,  3887,  3897,  3911,  3907,  3918,
   -1508,  3271,  3272,  3273, -1513,  1316,  3926,  4139,  3933,  1317,
    3211,  4000,  3983,  3976,  4022,   740,  4026,  4027,  4032,  4047,
    3274,  3999,  4028,  1422,   863,  4181,   632,   271,  4094,   273,
    4051,  3819,  4034,  2594,  2613,  2595,  4035,   864,  1888,  4036,
    4064,  1423,  4048,  2596,  1318,  4052,  1313,  4099,  4066,  4102,
    4124,  4081,  4082,  2557,  3973,  4125,  1276,  1277,  2597,  4120,
    4084,  4236,  4085,  4110,  2557,  1319,  1692,  1693,  1694,  1695,
    1696,  4126,   632,  1276,  1277,  4222,  4114,  4127,   751,  1314,
    1320,  4128,  2598,   642,  4130,  4673,  4131,  1889,  4116,  4174,
    2614,  2615,  2616,   755,   756,  4140,  4751,  2617,  4185,  4193,
    1274,  4196,  4197,  4198,  4200,  4014,  4014,  4201,  4014,  4014,
    1276,  1277,  4182,  2618,  4205,  4204,  2599,  2619,   867,  4207,
    4215,  4248,  4267,  4751,  4250,  4273,  4218,  4279,  1321,  4281,
    4283,  4282,  -352,  4289,  2600,  4307,  2620,  4309,  2601,  4336,
     868,  4310,   869,  4321,  4325,  4346,  4349,  4364,  4361,  1315,
    4365,  4370,  4373,  1322,  2622,  4375,  4287,  4377,  4216,  4382,
    4392,  4405,  4408,  4673,  -370,  4434,  4435,  4293,  1697,  1698,
    1699,  1700,  4300,  4436,  1316,  4454,  4455,  2602,  1317,  4461,
    4464,  4467,  2603,  4479,  4491,  3472,  4515,  4516,  4523,  2604,
    4522,  2605,  4533,  4534,  4536,  4539,  2606,  4527,  4571,  2607,
    4557,  4314,  4318,   826,  1279,  1280,  1281,  1282,  1283,  1284,
    1285,  1286,  4572,  1318,  3156,  4014,  4573,  4574,  4580,  4581,
    4582,  4583,  1280,  1281,  1282,  1283,  1284,  1285,  1286,  4588,
    2608,  4591,  4592,  4286,  1319,  4782,  4596,  4601,  3275,  1776,
    4603,  4605,  4609,  4606,  2609,  2610,  2611,  2612, -2455,  1320,
    4615,  2598,  2573,  1276,  1277,  3276,  4630,  1323,  1279,  1280,
    1281,  1282,  1283,  1284,  1285,  1286,  1324,  4633,  4635,  4636,
    4526,  2613,  2889,  4640,  2889,  1701,  4641,  1702,  1703,  1704,
    4651,  1325,  4665,  4664,  4670,  4526,  1705,   777, -1682,  4667,
    4680,  4087,  4685,  4393,  4088,  4688,  4689,  1321,  4702,  1326,
    4537,  4694,  4478,  4710,  4690,   783,  4695,  4708,  4705,  4699,
     785,  4714,  4707,   786,  4716,  4719,  4720,  4722,  4726,  4730,
    4409,  4732,  1322,  4740,  4755,  4760,  4756,  2614,  2615,  2616,
    4769,  4302,  4779,  2834,  2617,  3118,  3996,  1514,  2989,  3782,
    1120,  4003,  4322,  1327,  4445,  4616,  1328,  1575,  4617,  4001,
    2618,  4005,  4180,  4771,  2619,   826,  4734,   600,  2375,  1008,
     826,  2448,  3282,  4151,  4152,  4154,  4744,  1706,  4155,  3277,
    4089,  4090,  4157,  2620,  1329,  4158,  4159,  4160,  2621,  4648,
    4161,  4162,  4520,  4222,  4649,  4614,  4165,  3278,  4166,  4167,
    4531,  2622,  4532,   642,  2113,  2358,  1330,   826,  1618,  4484,
    4324,  1279,  1280,  1281,  1282,  1283,  1284,  1285,  1286,  3065,
    4187,  3704,  2623,  3873,   826,  2832,  3305,  3310,  3617,  4466,
    4217,  4556,  1914,  3876,  1707,  1708,  1323,  4704,  4448,  4629,
    4672,   682,  2165,  4009,  4372,  1324,  3467,  3063,  3508,  3800,
    3070,  3474,  4093,  4095,  4686,  1331,  4402,  3279,  3941,  3563,
    1325,  4275,  3982,  4129,  4555,  -960,  2137,  4526,   826,   826,
     826,   826,  4318,  4471,  4472,  3280,  4119,  4663,  1326,  2974,
     826,  3241,  3593,  3591,  3595,   539,  4549,  4500,   540,  4586,
    4585,  2712,  4451,  4457,  3162,  1776,  4459,  4335,  3681,  4278,
    3067,  2644,  3466,  1538,  1583,  2947,  4098,  2047,  2873,  4628,
    4535,  2429,  2163,  3913,  2127,  2853,   642,  3296,  2897,  2807,
    3614,  4172,  1327,  2458,  1034,  1328,  2138,  1441,  2139,  2140,
    2141,  2142,  2143,  4701,  2144,  2145,  2146,  2147,  2148,  2149,
    2150,  2151,  2152,  3602,  2153,  2154,  2155,  2747,  4401,  2745,
    3264,  2967,  1730,  1329,  3656,  2961,  4384,  2806,  4526,  4254,
    4526,  4638,  3779,  4548,  4639,  2823,  3921,  4721,   826,  2063,
    4068,  1673,   517,  3353,  3461,  1330,   518,  1709,  4526,  4061,
    4725,  2904,  2716,  1897,  4564,  4565,  1929,  1555,  2851,  2879,
    3878,  3629,  1710,  1711,  3630,  3665,  4553,  1022,  1556,  1557,
     642,  1558,  1138,  2503,  2206,  1003,  2005,  2504,  2944,  4526,
    4526,  1006,  2369,  3925,  4759,  1935,  3094,  3094,  3616,  4575,
    4703,  4637,  4723,  4778,  1331,  4781,  3633,  4123,  1953,  3649,
    2923,   960,  2330,  3650,   961,  2921,  4653,  2486,  2913,  2920,
    2416,  1302,  1945,  4661,   928,  1427,  4206,  2892,  1890,  3283,
    4214,  2189,   930,  1433,  1124,   676,   677,  1125,     0,     0,
    1126,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2156,  2157,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4772,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4712,     0,     0,     0,     0,  4717,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   826,  4684,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4752,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1776,     0,  4752,     0,     0,     0,     0,     0,     0,   642,
       0,     0,     0,  1776,     0,     0,     0,     0,  1776,     0,
     826,   826,     0,  1776,     0,     0,     0,     0,     0,   826,
     826,   826,   826,   826,   826,   826,   826,   826,   826,   826,
     826,     0,     0,     0,     0,     0,     0,     0,     0,   826,
     826,     0,   826,   826,     0,     0,     0,   826,     0,     0,
     826,   826,   826,   826,     0,   826,   826,   826,     0,     0,
       0,     0,     0,     0,   826,   826,     0,   826,   826,   826,
     826,   826,     0,     0,   826,   826,   826,   826,   826,   826,
     826,   826,   826,   826,   826,     0,   826,     0,     0,   826,
     826,     0,     0,     0,   826,     0,     0,     0,   826,   826,
     826,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   826,   826,   826,     0,     0,     0,     0,
       0,     0,   826,     0,     0,     0,     0,     0,     0,   826,
     826,   826,     0,   826,     0,     0,     0,     0,     0,     0,
     826,   826,   826,     0,   826,   826,   826,   826,   826,     0,
     826,   826,   826,   826,   826,   826,   826,   826,     0,     0,
       0,   826,   826,     0,     0,     0,     1,     0,     2,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     3,     0,     0,     0,     4,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     6,  2576,     0,  2577,     0,     0,
       0,     7,     0,     0,     0,     0,     8,     9,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    10,     0,  -817,
    -817,     0,  2579,     0,     0,     0,     0,     0,   826,     0,
       0,  -817,     0,     0,     0,     0,    11,     0,     0,     0,
       0,  2582,     0,     0,     0,     0,     0,     0,     0,  2583,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      12,     0,     0,     0,     0,     0,     0,     0,    13,    14,
      15,     0,     0,     0,     0,     0,  2585,     0,     0,     0,
       0,    16,    17,     0,     0,     0,     0,     0,     0,     0,
    1563,   826,     0,  2586,    18,     0,     0,     0,     0,     0,
       0,   826,     0,     0,     0,     0,     0,     0,     0,    19,
       0,     0,     0,     0,     0,     0,     0,   826,     0,     0,
       0,   826,  2591,     0,     0,    20,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,     0,    22,     0,     0,     0,     0,    23,     0,     0,
       0,    24,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   826,    25,     0,    26,
       0,     0,     0,  3712,  3713,     0,     0,     0,   271,  3714,
     273,  3715,     0,  3716,  3717,    27,  2595,     0,     0,     0,
       0,     0,     0,     0,  2596,     0,     0,     0,     0,     0,
    3550,     0,     0,    28,     0,     0,     0,    29,     0,  2597,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2703,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3718,     0,     0,
    3719,     0,     0,     0,     0,     0,     0,  2599,  3720,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2600,  3721,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   826,     0,     0,     0,
       0,     0,    30,  3722,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    31,
       0,    32,     0,     0,     0,     0,     0,     0,  3723,     0,
    3724,     0,     0,     0,    33,     0,     0,     0,     0,     0,
    2604,     0,  2605,  3725,  3726,    34,     0,     0,     0,     0,
    2607,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,     0,     0,
      36,     0,    37,     0,     0,    38,     0,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,  3727,    41,
       0,     0,    42,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,     0,     0,    44,     0,     0,   826,
     826,   826,     0,     0,    45,     0,     0,  3728,     0,    46,
      47,    48,  2613,     0,   826,     0,  3729,  3730,     0,  3731,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     826,    49,     0,     0,     0,     0,   826,     0,    50,   826,
       0,   826,     0,  3732,  3733,  3734,     0,   826,     0,   826,
     826,     0,     0,     0,     0,     0,     0,     0,  2614,  2615,
    2616,     0,  3735,  3736,  3737,  2617,     0,     0,     0,  3738,
       0,     0,  3739,     0,     0,     0,     0,     0,     0,     0,
       0,  2618,     0,    51,     0,  2619,     0,     0,     0,  3740,
    3741,     0,     0,     0,     0,    52,     0,     0,     0,    53,
       0,     0,    54,     0,  2620,     0,     0,     0,    55,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2622,     0,     0,  3742,  3743,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    56,  1146,
       0,     0,   826,     0,    57,     0,     0,     0,     0,     0,
    3744,     0,     0,     0,    58,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2576,     0,  2577,     0,     0,  1183,     0,     0,     0,
    2704,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1201,     0,   826,     0,     0,     0,     0,
       0,     0,     0,     0,   826,     0,  3745,     0,  2579,  2576,
    3746,  2577,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3747,     0,     0,  2582,     0,     0,
       0,     0,     0,     0,     0,  2583,     0,     0,     0,     0,
    1248,     0,     0,  -817,  -817,     0,  2579,     0,     0,     0,
       0,     0,     0,     0,     0,  -817,     0,     0,     0,     0,
       0,     0,  2585,     0,     0,  2582,     0,     0,     0,     0,
       0,     0,     0,  2583,     0,     0,  1563,     0,     0,  2586,
       0,  3748,     0,     0,  3749,     0,     0,  3750,  3751,  3752,
    3753,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2585,     0,     0,     0,     0,     0,     0,     0,  2591,     0,
       0,     0,     0,     0,  1563,     0,     0,  2586,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3754,  3755,     0,     0,  2638,     0,  1387,     0,     0,
       0,     0,     0,     0,     0,     0,  2591,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   826,  3756,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   271,     0,   273,     0,     0,     0,
       0,     0,  2595,     0,     0,     0,     0,     0,     0,     0,
    2596,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2597,     0,     0,     0,     0,
       0,     0,   271,     0,   273,     0,     0,  2638,     0,     0,
    2595,     0,     0,     0,     0,     0,     0,     0,  2596,     0,
       0,   826,     0,     0,     0,   826,     0,     0,     0,     0,
     826,   826,     0,  2597,     0,     0,     0,     0,     0,   826,
       0,   826,     0,   826,   826,   826,   826,     0,     0,   826,
       0,     0,     0,  2599,     0,     0,     0,     0,     0,   826,
       0,   826,   826,     0,   826,   826,   826,   826,     0,   826,
       0,  2600,   826,     0,     0,     0,     0,     0,     0,     0,
       0,   826,     0,     0,     0,     0,     0,     0,   826,     0,
     826,  2599,   826,   826,     0,   826,   826,     0,     0,     0,
     826,   826,   826,     0,     0,     0,   826,   826,   826,  2600,
     826,  1599,   826,     0,   826,     0,   826,     0,   826,     0,
       0,     0,     0,   826,     0,     0,  2604,     0,  2605,     0,
       0,     0,     0,     0,     0,     0,  2607,     0,     0,     0,
       0,     0,   826,     0,     0,     0,     0,     0,     0,   826,
       0,     0,   826,     0,     0,     0,     0,     0,   826,     0,
       0,   826,     0,     0,  2604,   826,  2605,     0,     0,  1646,
    1647,     0,     0,     0,  2607,     0,     0,     0,  1657,  1658,
       0,     0,  1661,  1662,  1663,  1664,  1667,  1668,  1669,  1670,
       0,     0,     0,     0,     0,     0,     0,     0,  1686,  1687,
       0,  1688,  1689,     0,     0,     0,     0,     0,  2613,  1722,
    1723,  1724,  1725,     0,     0,  1728,     0,     0,     0,     0,
       0,     0,     0,  1736,  1737,     0,  1740,  1741,     0,   826,
       0,     0,     0,  1745,  1746,  1747,     0,     0,  1750,  1751,
    1752,  1753,  1754,  1755,     0,  1757,  2613,     0,  1760,  1761,
       0,     0,     0,  1764,     0,     0,     0,  1767,  1771,  1772,
       0,     0,     0,     0,  2614,  2615,  2616,     0,     0,     0,
       0,  2617,  1779,  1780,  1781,     0,     0,     0,     0,     0,
       0,  1789,     1,     0,     2,     0,     0,  2618,  1794,  1795,
    1796,  2619,     0,     0,     0,     0,     0,     0,     0,   826,
       0,     0,  2614,  2615,  2616,     4,     0,     0,     0,  2617,
    2620,     0,     0,     0,     0,     0,     0,     0,     0,     5,
       6,  1832,     0,     0,     0,  2618,     0,     7,  2622,  2619,
       0,     0,     8,     9,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2620,     0,
       0,     0,     0,    10,     0,     0,  2987,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2622,     0,     0,     0,
       0,     0,    11,     0,  2987,  2987,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    12,     0,     0,     0,
       0,     0,     0,     0,    13,    14,    15,  1901,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    16,    17,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2638,     0,     0,     0,
       0,     0,     0,     0,     0,    19,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    20,     0,     0,     0,     0,     0,     0,     0,     0,
    1952,     0,     0,     0,     0,     0,    21,     0,    22,     0,
    1958,     0,     0,    23,  2987,  2987,     0,    24,     0,     0,
       0,     0,     0,     0,     0,     0,  1986,     0,     0,     0,
    1992,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    25,     0,    26,     0,     0,     0,     0,
    2638,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    27,     0,     0,     0,   826,     0,     0,     0,   826,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    28,
       0,     0,     0,    29,     0,  2037,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   826,   826,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   826,     0,     0,     0,
       0,     0,     0,     0,     0,   826,     0,   826,     0,   826,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   826,     0,     0,     0,
       0,   826,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   826,
       0,     0,     0,     0,     0,    31,   963,    32,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   964,     0,
      33,     0,     0,     0,     0,  2218,     0,     0,     0,   901,
     965,    34,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    35,   966,   947,    36,     0,    37,     0,
       0,    38,   967,     0,    39,    40,     0,   968,     0,     0,
       0,     0,     0,   826,     0,    41,     0,     0,    42,     0,
       0,     0,     0,     0,     0,     0,    43,     0,     0,     0,
       0,     0,    44,   969,     0,   970,     0,   971,     0,     0,
      45,     0,     0,     0,     0,    46,    47,    48,     0,   972,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   826,     0,     0,     0,     0,     0,
      14,    15,     0,     0,     0,     0,     0,    49,  2300,  2302,
    2304,     0,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1893,   973,     0,     0,
       0,     0,   974,     0,     0,   975,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2339,
       0,     0,     0,     0,     0,     0,     0,     0,  2344,    51,
    2345,     0,   976,     0,   977,     0,     0,     0,     0,     0,
       0,    52,   978,     0,   979,    53,     0,     0,    54,     0,
       0,     0,     0,     0,    55,  2638,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   826,   826,
     980,   981,   982,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    56,     0,     0,     0,     0,     0,
      57,     0,     0,   983,     0,     0,     0,     0,     0,     0,
      58,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   984,     0,  2987,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2425,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   985,     0,  2638,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   826,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2485,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   826,   826,     0,
     826,     0,     0,     0,     0,     0,     0,  3464,     0,   826,
       0,     0,   986,  2573,   826,  2574,     0,   826,     0,   826,
     826,     0,     0,     0,     0,     0,     0,     0,  2576,     0,
    2577,     0,     0,     0,     0,     0,     0,     0,   987,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   988,
     989,     0,   826,   990,   991,     0,     0,     0,     0,     0,
    2578,     0,     0,     0,     0,  2579,     0,     0,     0,     0,
       0,     0,     0,     0,   992,     0,     0,     0,     0,     0,
       0,     0,     0,   826,  2582,     0,     0,     0,     0,     0,
       0,     0,  2583,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2584,     0,     0,     0,     0,   826,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2585,
       0,     0,   993,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1563,     0,   994,  2586,     0,     0,     0,
       0,     0,     0,     0,  2587,     0,  2648,     0,     0,     0,
       0,  3465,     0,     0,     0,     0,     0,     0,     0,  2590,
       0,     0,     0,   826,     0,  2591, -2495,     0,     0,     0,
     995,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   996,   997,
       0,     0,     0,     0,     0,  2593,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2725,     0,     0,     0,  2727,     0,     0,     0,     0,  2729,
    2730,   271,     0,   273,     0,     0,     0,   998,  1664,  2595,
    2746,     0,  1664,     0,  2749,  2750,     0,  2596, -2495,     0,
       0,     0,     0,     0,     0,     0,   999,     0,  2757,     0,
    2758,     0,  2597,  2760,  2761,  2762,  2763,     0,  2764,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2768,     0,     0,     0,     0,     0,  2598,  2769,     0,  2770,
       0,  2771,  2772,     0,  2773,     0,     0,     0,     0,  2776,
    2777,  2778,     0,     0,     0,  2780,  2781,  2782,     0,  2783,
       0,  2785,     0,  2787,     0,  2789,     0,  2790,     0,     0,
    2599,     0,  2791,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2600,     0,
       0,  2811,  2601,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2821,     0,     0,
    2824,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2603,     0,     0,     0,
       0,     0,     0,  2604,     0,  2605,     0,     0,     0,     0,
       0,     0,     0,  2607,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   826,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2610,
       0,     0,     0,     0,   826,     0,     0,     0,     0,     0,
       0,     0,   826,     0,     0,     0,     0,   826,     0,     0,
       0,     0,     0,     0,     0,  2613,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1986,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2614,  2615,  2616,     0,     0,     0,     0,  2617,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3972,
       0,     0,     0,     0,  2618,     0,     0,     0,  2619,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2620,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2638,     0,     0,     0,     0,  2622,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   826,     0,     0,     0,   826,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   826,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   826,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3171,     0,     0,     0,  3173,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3972,
       0,     0,     0,     0,     0,  3200,  3201,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4169,     0,     0,
       0,     0,     0,     0,     0,  3221,     0,     0,     0,     0,
       0,     0,     0,     0,  3231,     0,  3233,     0,  3235,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     826,     0,     0,     0,     0,     0,     0,     0,   826,     0,
       0,     0,     0,     0,   826,     0,   826,     0,  3293,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   826,  1986,     0,     0,     0,     0,  4169,  4169,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4334,     0,  3375,     0,  4334,  4334,     0,     0,     0,
       0,     0,   826,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     826,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     826,     0,   826,     0,     0,     0,     0,  3483,  3484,     0,
       0,     0,   826,     0,  4169,  4169,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4334,     0,     0,     0,     0,     0,     0,     0,     0,
    4334,     0,     0,     0,  4334,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4334,
       0,     0,     0,     0,  3533,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   826,     0,  4169,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3572,  3573,     0,  4169,
     826,     0,     0,     0,     0,     0,     0,     0,  3580,     0,
       0,     0,     0,  3582,  4169,     0,  3583,     0,  3584,  3585,
       0,     0,     0,     0,     0,     0,  4550,     0,     0,     0,
       0,     0,     0,   826,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4334,     0,  4334,  4334,     0,     0,     0,     0,
       0,     0,  3610,     0,     0,     0,     0,     0,     0,   826,
    4169,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4169,  4169,     0,     0,  3610,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   826,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3610,     0,     0,     0,     0,     0,     0,     0,
       0,  4169,     0,     0,     0,     0,     0,     0,   826,     0,
       0,  4169,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   826,     0,
       0,     0,     0,     0,     0,  4169,     0,  4169,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4169,     0,     0,
       0,   826,     0,     0,   826,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4169,     0,  4169,     0,  4169,     0,     0,     0,     0,     0,
       0,  4169,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4169,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4169,  4169,     0,
       0,     0,     0,   826,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4169,  4169,     0,     0,     0,  4169,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   141,     0,   142,
     143,   144,   145,   146,   147,     0,     0,   148,     0,     0,
       0,   149,     0,   826,     0,     0,   151,   152,   153,   154,
     155,   156,   157,     0,     0,     0,     0,     0,     0,   160,
       0,     0,     0,   161,     0,     0,   162,   163,   164,     0,
     165,     0,     0,     0,     0,     0,   168,     0,     0,   169,
     170,     0,   171,     0,     0,     0,     0,     0,   175,   176,
     177,   178,     0,   180,   181,     0,   182,   183,     0,     0,
       0,     0,     0,     0,   189,     0,   191,  3610,   193,   194,
     195,   196,     0,   197,   198,     0,   199,   200,   201,     0,
     203,     0,   204,     0,     0,   205,     0,     0,   206,     0,
     207,     0,     0,   208,     0,   209,     0,     0,     0,   210,
     211,   212,     0,  3896,   213,     0,     0,     0,     0,   214,
       0,  3375,     0,     0,     0,   216,  3904,   217,     0,     0,
       0,   218,     0,   219,   220,   221,   222,   223,     0,     0,
       0,     0,     0,     0,   225,   226,   227,     0,     0,     0,
     228,     0,     0,   230,     0,   231,   232,   233,     0,     0,
     234,   235,     0,   236,   237,   238,   239,   240,     0,     0,
       0,     0,   243,   244,   245,     0,     0,   246,   247,     0,
     248,   249,   250,     0,     0,     0,     0,     0,     0,   252,
       0,   253,     0,   254,     0,   255,   256,   257,   258,   259,
       0,   261,     0,   262,     0,     0,     0,     0,   264,   265,
       0,     0,     0,     0,     0,     0,   268,     0,     0,     0,
     269,   270,   271,   272,   273,     0,     0,   274,   275,   276,
       0,   277,     0,   278,     0,     0,     0,     0,   279,     0,
       0,     0,     0,   281,     0,   282,   283,     0,   284,   285,
       0,     0,     0,   286,     0,     0,     0,   288,   289,     0,
       0,   290,     0,     0,   291,   292,     0,     0,     0,     0,
       0,   293,   294,     0,   295,     0,   296,     0,   297,   298,
    3375,     0,     0,     0,  4025,     0,     0,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,     0,   315,   316,   317,   318,     0,   319,
     320,   321,   322,     0,   323,   324,     0,     0,  3610,     0,
     325,   326,   327,   328,   329,   330,     0,     0,   331,   332,
       0,   333,  3375,   334,     0,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,   344,   345,     0,     0,
     346,   347,   348,   349,     0,     0,     0,     0,   351,     0,
       0,     0,   352,     0,   353,   354,   355,     0,   356,   357,
     358,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   363,   364,     0,     0,     0,     0,
     366,     0,   367,   368,   369,   370,   371,   372,   373,   374,
     375,     0,     0,     0,     0,   378,   379,     0,   380,     0,
     381,   382,   383,   384,   385,     0,   386,   387,   388,     0,
       0,   389,     0,     0,     0,   390,   391,   392,   393,   394,
       0,     0,   395,   396,   397,   398,   399,     0,   400,     0,
       0,   402,     0,   404,     0,     0,   405,     0,     0,     0,
     407,     0,     0,   409,   410,     0,   411,     0,   412,     0,
       0,   413,     0,   415,   416,   417,   418,   419,   420,   421,
       0,   423,   424,     0,   425,     0,     0,     0,     0,   427,
     428,   429,     0,     0,     0,     0,   431,     0,     0,     0,
       0,     0,     0,   434,     0,     0,   437,   438,     0,   439,
       0,   441,     0,   443,   444,     0,     0,  4242,     0,     0,
       0,   445,   446,  4247,   447,  4249,     0,   448,     0,     0,
     449,     0,     0,     0,     0,   451,     0,     0,     0,   453,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
     461,   462,   463,     0,   464,   465,     0,   466,     0,   467,
     468,   469,   470,     0,     0,   471,   472,     0,   473,   474,
     475,   476,     0,     0,     0,     0,     0,   477,   478,   479,
       0,     0,     0,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,     0,     0,     0,     0,     0,   490,     0,
    4288,   491,     0,     0,     0,   493,   494,   495,     0,     0,
       0,     0,     0,     0,   496,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,   503,   504,     0,     0,
       0,     0,     0,     0,   505,     0,     0,   507,     0,   509,
       0,     0,   510,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3375,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3375,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4403,
       0,  4404,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4412,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4524,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4529,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3610,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4599,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4655,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4687,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   141,     0,   142,   691,   144,   145,
     146,   147,     0,  4706,   148,     0,     0,     0,   149,     0,
       0,   692,     0,   151,   152,   153,   154,   155,   156,   693,
     158,     0,   159,     0,     0,   694,   160,   695,   696,   697,
     161,   698,     0,   162,   163,   164,  1768,   165,     0,   166,
     167,     0,     0,   168,   699,   700,   169,   170,     0,   171,
     701,   702,   173,   174,     0,   175,   176,   177,   178,   179,
     703,   181,  4753,   704,   183,   705,   706,   707,   708,   709,
       0,   189,   190,   191,   192,   193,   194,   195,   196,     0,
     197,   198,     0,   199,   200,   201,   710,   203,     0,   204,
     711,   712,   205,     0,     0,   206,   713,   207,   714,   715,
     208,     0,   209,   716,   717,     0,   210,   211,   212,   718,
     719,   720,  3610,     0,     0,     0,   721,   215,   722,     0,
       0,   723,   216,     0,   217,     0,     0,     0,   218,     0,
     219,   220,   221,   222,   223,     0,     0,     0,   224,     0,
       0,   225,   226,   227,     0,     0,     0,   228,     0,   229,
     230,     0,   231,   232,   233,     0,     0,   234,   235,     0,
     236,   237,   238,   239,   240,   241,   242,   724,     0,   243,
     244,   245,   725,   726,   246,   247,     0,   248,   249,   250,
     727,     0,   251,     0,     0,     0,   252,     0,   253,     0,
     254,     0,   255,   256,   728,   258,   729,   260,   261,     0,
     262,     0,   730,     0,   263,   264,   265,     0,   266,   731,
     732,     0,   267,   268,     0,     0,     0,   733,   270,   271,
     272,   273,   734,     0,   274,   275,   276,     0,   277,     0,
     278,     0,     0,     0,   735,   279,   280,   736,     0,     0,
     281,     0,   282,   283,     0,   284,   285,     0,     0,     0,
     286,     0,     0,   287,   288,   737,     0,  1769,   290,     0,
     738,   291,   292,     0,     0,     0,     0,     0,   739,   294,
       0,   295,     0,   296,     0,   297,   298,     0,     0,   740,
       0,     0,     0,     0,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
       0,   315,   316,   317,   318,   741,   319,   320,   321,   322,
     742,   323,   324,     0,     0,     0,     0,   325,   326,   327,
     328,   743,   330,     0,     0,   744,   332,   745,   333,     0,
     334,   746,   747,   748,   749,   750,   339,   340,   341,   342,
     343,     0,   751,   344,   345,     0,     0,   346,   347,   348,
     349,   752,   753,   754,   350,   351,     0,   755,   756,   352,
       0,   353,   354,   757,     0,   356,   357,   358,   359,     0,
     360,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,   363,   364,     0,   758,   365,     0,   366,     0,   367,
     368,   759,   370,   371,   372,   373,   760,   761,   376,   762,
       0,   377,   378,   379,     0,   380,     0,   381,   382,   383,
     384,   385,     0,   763,   387,   388,     0,     0,   389,     0,
       0,     0,   390,   391,   392,   393,   394,     0,     0,   395,
     396,   397,   398,   399,     0,   400,   401,     0,   402,   403,
     404,   764,   765,   405,     0,   406,     0,   407,   408,     0,
     409,   410,     0,   411,     0,   766,     0,   767,   413,   414,
     415,   416,   417,   418,   768,   769,   421,   422,   423,   424,
       0,   770,   426,     0,     0,     0,   427,   428,   429,   430,
       0,     0,     0,   431,     0,     0,     0,   432,     0,   433,
     434,   435,   436,   437,   438,     0,   439,   440,   441,   442,
     443,   444,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,     0,     0,   448,     0,     0,   449,   450,     0,
       0,     0,   451,   771,   772,   452,   453,     0,   454,   455,
     773,   457,   458,   459,   774,   775,   460,   461,   462,   463,
     776,   464,   465,     0,   466,     0,   467,   468,   469,   470,
       0,   777,   471,   472,     0,   778,   779,   780,   781,     0,
       0,     0,     0,  1770,   477,   478,   479,     0,   782,   783,
     784,   481,   482,   483,   785,   484,   485,   786,   486,   487,
       0,   488,   489,     0,     0,   490,     0,     0,   491,     0,
     492,     0,   787,   494,   495,     0,     0,   788,   789,   790,
     791,   496,     0,     0,   497,   792,     0,   793,   498,   499,
     500,   501,   502,   794,   795,     0,     0,     0,     0,     0,
       0,   505,   506,     0,   507,   508,   509,     0,     0,   796,
       0,     0,     0,     0,   797,   798,     0,     0,     0,     0,
     799,   800,     0,     0,   801,   802,     0,     0,   803,   804,
     141,     0,   142,   691,   144,   145,   146,   147,  1982,     0,
     148,     0,     0,     0,   149,     0,     0,   692,     0,   151,
     152,   153,   154,   155,   156,   693,   158,     0,   159,     0,
       0,  1983,   160,   695,   696,   697,   161,   698,     0,   162,
     163,   164,     0,   165,     0,   166,   167,     0,     0,   168,
     699,   700,   169,   170,     0,   171,   701,   702,   173,   174,
       0,   175,   176,   177,   178,   179,   703,   181,     0,   704,
     183,   705,   706,   707,   708,   709,     0,   189,   190,   191,
     192,   193,   194,   195,   196,     0,   197,   198,     0,   199,
     200,   201,   710,   203,     0,   204,   711,   712,   205,     0,
       0,   206,   713,   207,   714,   715,   208,     0,   209,   716,
     717,     0,   210,   211,   212,   718,   719,   720,     0,     0,
       0,     0,   721,   215,   722,     0,     0,  1984,   216,     0,
     217,     0,     0,     0,   218,     0,   219,   220,   221,   222,
     223,     0,     0,     0,   224,     0,     0,   225,   226,   227,
       0,     0,     0,   228,     0,   229,   230,     0,   231,   232,
     233,     0,     0,   234,   235,     0,   236,   237,   238,   239,
     240,   241,   242,   724,     0,   243,   244,   245,   725,   726,
     246,   247,     0,   248,   249,   250,   727,     0,   251,     0,
       0,     0,   252,     0,   253,     0,   254,     0,   255,   256,
     728,   258,   729,   260,   261,     0,   262,     0,   730,     0,
     263,   264,   265,     0,   266,   731,   732,     0,   267,   268,
       0,     0,     0,   733,   270,   271,   272,   273,   734,     0,
     274,   275,   276,     0,   277,     0,   278,     0,     0,     0,
     735,   279,   280,   736,     0,     0,   281,     0,   282,   283,
       0,   284,   285,     0,     0,     0,   286,     0,     0,   287,
     288,   737,     0,     0,   290,     0,   738,   291,   292,     0,
       0,     0,     0,     0,   739,   294,     0,   295,     0,   296,
       0,   297,   298,     0,     0,   740,     0,     0,     0,     0,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,     0,   315,   316,   317,
     318,   741,   319,   320,   321,   322,   742,   323,   324,     0,
       0,     0,     0,   325,   326,   327,   328,   743,   330,     0,
       0,   744,   332,   745,   333,     0,   334,   746,   747,   748,
     749,   750,   339,   340,   341,   342,   343,     0,   751,   344,
     345,     0,     0,   346,   347,   348,   349,   752,   753,   754,
     350,   351,     0,   755,   756,   352,     0,   353,   354,   757,
    1985,   356,   357,   358,   359,     0,   360,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,   363,   364,     0,
     758,   365,     0,   366,     0,   367,   368,   759,   370,   371,
     372,   373,   760,   761,   376,   762,     0,   377,   378,   379,
       0,   380,     0,   381,   382,   383,   384,   385,     0,   763,
     387,   388,     0,     0,   389,     0,     0,     0,   390,   391,
     392,   393,   394,     0,     0,   395,   396,   397,   398,   399,
       0,   400,   401,     0,   402,   403,   404,   764,   765,   405,
       0,   406,     0,   407,   408,     0,   409,   410,     0,   411,
       0,   766,     0,   767,   413,   414,   415,   416,   417,   418,
     768,   769,   421,   422,   423,   424,     0,   770,   426,     0,
       0,     0,   427,   428,   429,   430,     0,     0,     0,   431,
       0,     0,     0,   432,     0,   433,   434,   435,   436,   437,
     438,     0,   439,   440,   441,   442,   443,   444,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,     0,     0,
     448,     0,     0,   449,   450,     0,     0,     0,   451,   771,
     772,   452,   453,     0,   454,   455,   773,   457,   458,   459,
     774,   775,   460,   461,   462,   463,   776,   464,   465,     0,
     466,     0,   467,   468,   469,   470,     0,   777,   471,   472,
       0,   778,   779,   780,   781,     0,     0,     0,     0,     0,
     477,   478,   479,     0,   782,   783,   784,   481,   482,   483,
     785,   484,   485,   786,   486,   487,     0,   488,   489,     0,
       0,   490,     0,     0,   491,     0,   492,     0,   787,   494,
     495,     0,     0,   788,   789,   790,   791,   496,     0,     0,
     497,   792,     0,   793,   498,   499,   500,   501,   502,   794,
     795,     0,     0,     0,     0,     0,     0,   505,   506,     0,
     507,   508,   509,     0,     0,   796,     0,     0,     0,     0,
     797,   798,     0,     0,     0,     0,   799,   800,     0,     0,
     801,   802,     0,     0,   803,   804,   141,     0,   142,   691,
     144,   145,   146,   147,     0,     0,   148,     0,     0,     0,
     149,     0,     0,   692,     0,   151,   152,   153,   154,   155,
     156,   693,   158,     0,   159,     0,     0,   694,   160,   695,
     696,   697,   161,   698,     0,   162,   163,   164,     0,   165,
       0,   166,   167,     0,     0,   168,   699,   700,   169,   170,
       0,   171,   701,   702,   173,   174,     0,   175,   176,   177,
     178,   179,   703,   181,     0,   704,   183,   705,   706,   707,
     708,   709,     0,   189,   190,   191,   192,   193,   194,   195,
     196,     0,   197,   198,     0,   199,   200,   201,   710,   203,
       0,   204,   711,   712,   205,     0,     0,   206,   713,   207,
     714,   715,   208,     0,   209,   716,   717,     0,   210,   211,
     212,   718,   719,   720,     0,     0,     0,     0,   721,   215,
     722,     0,     0,   723,   216,     0,   217,     0,     0,     0,
     218,     0,   219,   220,   221,   222,   223,     0,     0,     0,
     224,     0,     0,   225,   226,   227,     0,     0,     0,   228,
       0,   229,   230,     0,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,   239,   240,   241,   242,   724,
       0,   243,   244,   245,   725,   726,   246,   247,     0,   248,
     249,   250,   727,     0,   251,     0,     0,     0,   252,  2299,
     253,     0,   254,     0,   255,   256,   728,   258,   729,   260,
     261,     0,   262,     0,   730,     0,   263,   264,   265,     0,
     266,   731,   732,     0,   267,   268,     0,     0,     0,   733,
     270,   271,   272,   273,   734,     0,   274,   275,   276,     0,
     277,     0,   278,     0,     0,     0,   735,   279,   280,   736,
       0,     0,   281,     0,   282,   283,     0,   284,   285,     0,
       0,     0,   286,     0,     0,   287,   288,   737,     0,     0,
     290,     0,   738,   291,   292,     0,     0,     0,     0,     0,
     739,   294,     0,   295,     0,   296,     0,   297,   298,     0,
       0,   740,     0,     0,     0,     0,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,     0,   315,   316,   317,   318,   741,   319,   320,
     321,   322,   742,   323,   324,     0,     0,     0,     0,   325,
     326,   327,   328,   743,   330,     0,     0,   744,   332,   745,
     333,     0,   334,   746,   747,   748,   749,   750,   339,   340,
     341,   342,   343,     0,   751,   344,   345,     0,     0,   346,
     347,   348,   349,   752,   753,   754,   350,   351,     0,   755,
     756,   352,     0,   353,   354,   757,     0,   356,   357,   358,
     359,     0,   360,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,   363,   364,     0,   758,   365,     0,   366,
       0,   367,   368,   759,   370,   371,   372,   373,   760,   761,
     376,   762,     0,   377,   378,   379,     0,   380,     0,   381,
     382,   383,   384,   385,     0,   763,   387,   388,     0,     0,
     389,     0,     0,     0,   390,   391,   392,   393,   394,     0,
       0,   395,   396,   397,   398,   399,     0,   400,   401,     0,
     402,   403,   404,   764,   765,   405,     0,   406,     0,   407,
     408,     0,   409,   410,     0,   411,     0,   766,     0,   767,
     413,   414,   415,   416,   417,   418,   768,   769,   421,   422,
     423,   424,     0,   770,   426,     0,     0,     0,   427,   428,
     429,   430,     0,     0,     0,   431,     0,     0,     0,   432,
       0,   433,   434,   435,   436,   437,   438,     0,   439,   440,
     441,   442,   443,   444,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,     0,     0,   448,     0,     0,   449,
     450,     0,     0,     0,   451,   771,   772,   452,   453,     0,
     454,   455,   773,   457,   458,   459,   774,   775,   460,   461,
     462,   463,   776,   464,   465,     0,   466,     0,   467,   468,
     469,   470,     0,   777,   471,   472,     0,   778,   779,   780,
     781,     0,     0,     0,     0,     0,   477,   478,   479,     0,
     782,   783,   784,   481,   482,   483,   785,   484,   485,   786,
     486,   487,     0,   488,   489,     0,     0,   490,     0,     0,
     491,     0,   492,     0,   787,   494,   495,     0,     0,   788,
     789,   790,   791,   496,     0,     0,   497,   792,     0,   793,
     498,   499,   500,   501,   502,   794,   795,     0,     0,     0,
       0,     0,     0,   505,   506,     0,   507,   508,   509,     0,
       0,   796,     0,     0,     0,     0,   797,   798,     0,     0,
       0,     0,   799,   800,     0,     0,   801,   802,     0,     0,
     803,   804,   141,     0,   142,   691,   144,   145,   146,   147,
       0,     0,   148,     0,     0,     0,   149,     0,     0,   692,
       0,   151,   152,   153,   154,   155,   156,   693,   158,     0,
     159,     0,     0,   694,   160,   695,   696,   697,   161,   698,
       0,   162,   163,   164,     0,   165,     0,   166,   167,     0,
       0,   168,   699,   700,   169,   170,     0,   171,   701,   702,
     173,   174,     0,   175,   176,   177,   178,   179,   703,   181,
       0,   704,   183,   705,   706,   707,   708,   709,     0,   189,
     190,   191,   192,   193,   194,   195,   196,     0,   197,   198,
       0,   199,   200,   201,   710,   203,     0,   204,   711,   712,
     205,     0,     0,   206,   713,   207,   714,   715,   208,     0,
     209,   716,   717,     0,   210,   211,   212,   718,   719,   720,
       0,     0,     0,     0,   721,   215,   722,     0,     0,   723,
     216,     0,   217,     0,     0,     0,   218,     0,   219,   220,
     221,   222,   223,     0,     0,     0,   224,     0,     0,   225,
     226,   227,     0,     0,     0,   228,     0,   229,   230,     0,
     231,   232,   233,     0,     0,   234,   235,     0,   236,   237,
     238,   239,   240,   241,   242,   724,     0,   243,   244,   245,
     725,   726,   246,   247,     0,   248,   249,   250,   727,     0,
     251,     0,     0,     0,   252,  2301,   253,     0,   254,     0,
     255,   256,   728,   258,   729,   260,   261,     0,   262,     0,
     730,     0,   263,   264,   265,     0,   266,   731,   732,     0,
     267,   268,     0,     0,     0,   733,   270,   271,   272,   273,
     734,     0,   274,   275,   276,     0,   277,     0,   278,     0,
       0,     0,   735,   279,   280,   736,     0,     0,   281,     0,
     282,   283,     0,   284,   285,     0,     0,     0,   286,     0,
       0,   287,   288,   737,     0,     0,   290,     0,   738,   291,
     292,     0,     0,     0,     0,     0,   739,   294,     0,   295,
       0,   296,     0,   297,   298,     0,     0,   740,     0,     0,
       0,     0,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,     0,   315,
     316,   317,   318,   741,   319,   320,   321,   322,   742,   323,
     324,     0,     0,     0,     0,   325,   326,   327,   328,   743,
     330,     0,     0,   744,   332,   745,   333,     0,   334,   746,
     747,   748,   749,   750,   339,   340,   341,   342,   343,     0,
     751,   344,   345,     0,     0,   346,   347,   348,   349,   752,
     753,   754,   350,   351,     0,   755,   756,   352,     0,   353,
     354,   757,     0,   356,   357,   358,   359,     0,   360,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,   363,
     364,     0,   758,   365,     0,   366,     0,   367,   368,   759,
     370,   371,   372,   373,   760,   761,   376,   762,     0,   377,
     378,   379,     0,   380,     0,   381,   382,   383,   384,   385,
       0,   763,   387,   388,     0,     0,   389,     0,     0,     0,
     390,   391,   392,   393,   394,     0,     0,   395,   396,   397,
     398,   399,     0,   400,   401,     0,   402,   403,   404,   764,
     765,   405,     0,   406,     0,   407,   408,     0,   409,   410,
       0,   411,     0,   766,     0,   767,   413,   414,   415,   416,
     417,   418,   768,   769,   421,   422,   423,   424,     0,   770,
     426,     0,     0,     0,   427,   428,   429,   430,     0,     0,
       0,   431,     0,     0,     0,   432,     0,   433,   434,   435,
     436,   437,   438,     0,   439,   440,   441,   442,   443,   444,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
       0,     0,   448,     0,     0,   449,   450,     0,     0,     0,
     451,   771,   772,   452,   453,     0,   454,   455,   773,   457,
     458,   459,   774,   775,   460,   461,   462,   463,   776,   464,
     465,     0,   466,     0,   467,   468,   469,   470,     0,   777,
     471,   472,     0,   778,   779,   780,   781,     0,     0,     0,
       0,     0,   477,   478,   479,     0,   782,   783,   784,   481,
     482,   483,   785,   484,   485,   786,   486,   487,     0,   488,
     489,     0,     0,   490,     0,     0,   491,     0,   492,     0,
     787,   494,   495,     0,     0,   788,   789,   790,   791,   496,
       0,     0,   497,   792,     0,   793,   498,   499,   500,   501,
     502,   794,   795,     0,     0,     0,     0,     0,     0,   505,
     506,     0,   507,   508,   509,     0,     0,   796,     0,     0,
       0,     0,   797,   798,     0,     0,     0,     0,   799,   800,
       0,     0,   801,   802,     0,     0,   803,   804,   141,     0,
     142,   691,   144,   145,   146,   147,     0,     0,   148,     0,
       0,     0,   149,     0,     0,   692,     0,   151,   152,   153,
     154,   155,   156,   693,   158,     0,   159,     0,     0,   694,
     160,   695,   696,   697,   161,   698,     0,   162,   163,   164,
       0,   165,     0,   166,   167,     0,     0,   168,   699,   700,
     169,   170,     0,   171,   701,   702,   173,   174,     0,   175,
     176,   177,   178,   179,   703,   181,     0,   704,   183,   705,
     706,   707,   708,   709,     0,   189,   190,   191,   192,   193,
     194,   195,   196,     0,   197,   198,     0,   199,   200,   201,
     710,   203,     0,   204,   711,   712,   205,     0,     0,   206,
     713,   207,   714,   715,   208,     0,   209,   716,   717,     0,
     210,   211,   212,   718,   719,   720,     0,     0,     0,     0,
     721,   215,   722,     0,     0,   723,   216,     0,   217,     0,
       0,     0,   218,     0,   219,   220,   221,   222,   223,     0,
       0,     0,   224,     0,     0,   225,   226,   227,     0,     0,
       0,   228,     0,   229,   230,     0,   231,   232,   233,     0,
       0,   234,   235,     0,   236,   237,   238,   239,   240,   241,
     242,   724,     0,   243,   244,   245,   725,   726,   246,   247,
       0,   248,   249,   250,   727,     0,   251,     0,     0,     0,
     252,  2303,   253,     0,   254,     0,   255,   256,   728,   258,
     729,   260,   261,     0,   262,     0,   730,     0,   263,   264,
     265,     0,   266,   731,   732,     0,   267,   268,     0,     0,
       0,   733,   270,   271,   272,   273,   734,     0,   274,   275,
     276,     0,   277,     0,   278,     0,     0,     0,   735,   279,
     280,   736,     0,     0,   281,     0,   282,   283,     0,   284,
     285,     0,     0,     0,   286,     0,     0,   287,   288,   737,
       0,     0,   290,     0,   738,   291,   292,     0,     0,     0,
       0,     0,   739,   294,     0,   295,     0,   296,     0,   297,
     298,     0,     0,   740,     0,     0,     0,     0,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,     0,   315,   316,   317,   318,   741,
     319,   320,   321,   322,   742,   323,   324,     0,     0,     0,
       0,   325,   326,   327,   328,   743,   330,     0,     0,   744,
     332,   745,   333,     0,   334,   746,   747,   748,   749,   750,
     339,   340,   341,   342,   343,     0,   751,   344,   345,     0,
       0,   346,   347,   348,   349,   752,   753,   754,   350,   351,
       0,   755,   756,   352,     0,   353,   354,   757,     0,   356,
     357,   358,   359,     0,   360,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,   363,   364,     0,   758,   365,
       0,   366,     0,   367,   368,   759,   370,   371,   372,   373,
     760,   761,   376,   762,     0,   377,   378,   379,     0,   380,
       0,   381,   382,   383,   384,   385,     0,   763,   387,   388,
       0,     0,   389,     0,     0,     0,   390,   391,   392,   393,
     394,     0,     0,   395,   396,   397,   398,   399,     0,   400,
     401,     0,   402,   403,   404,   764,   765,   405,     0,   406,
       0,   407,   408,     0,   409,   410,     0,   411,     0,   766,
       0,   767,   413,   414,   415,   416,   417,   418,   768,   769,
     421,   422,   423,   424,     0,   770,   426,     0,     0,     0,
     427,   428,   429,   430,     0,     0,     0,   431,     0,     0,
       0,   432,     0,   433,   434,   435,   436,   437,   438,     0,
     439,   440,   441,   442,   443,   444,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,     0,     0,   448,     0,
       0,   449,   450,     0,     0,     0,   451,   771,   772,   452,
     453,     0,   454,   455,   773,   457,   458,   459,   774,   775,
     460,   461,   462,   463,   776,   464,   465,     0,   466,     0,
     467,   468,   469,   470,     0,   777,   471,   472,     0,   778,
     779,   780,   781,     0,     0,     0,     0,     0,   477,   478,
     479,     0,   782,   783,   784,   481,   482,   483,   785,   484,
     485,   786,   486,   487,     0,   488,   489,     0,     0,   490,
       0,     0,   491,     0,   492,     0,   787,   494,   495,     0,
       0,   788,   789,   790,   791,   496,     0,     0,   497,   792,
       0,   793,   498,   499,   500,   501,   502,   794,   795,     0,
       0,     0,     0,     0,     0,   505,   506,     0,   507,   508,
     509,     0,     0,   796,     0,     0,     0,     0,   797,   798,
       0,     0,     0,     0,   799,   800,     0,     0,   801,   802,
       0,     0,   803,   804,   141,     0,   142,   691,   144,   145,
     146,   147,     0,     0,   148,     0,     0,     0,   149,     0,
       0,   692,     0,   151,   152,   153,   154,   155,   156,   693,
     158,     0,   159,     0,     0,   694,   160,   695,   696,   697,
     161,   698,     0,   162,   163,   164,     0,   165,     0,   166,
     167,     0,     0,   168,   699,   700,   169,   170,     0,   171,
     701,   702,   173,   174,     0,   175,   176,   177,   178,   179,
     703,   181,     0,   704,   183,   705,   706,   707,   708,   709,
       0,   189,   190,   191,   192,   193,   194,   195,   196,     0,
     197,   198,     0,   199,   200,   201,   710,   203,     0,   204,
     711,   712,   205,     0,     0,   206,   713,   207,   714,   715,
     208,     0,   209,   716,   717,     0,   210,   211,   212,   718,
     719,   720,     0,     0,     0,     0,   721,   215,   722,     0,
       0,   723,   216,     0,   217,     0,     0,     0,   218,     0,
     219,   220,   221,   222,   223,     0,     0,     0,   224,     0,
       0,   225,   226,   227,     0,     0,     0,   228,     0,   229,
     230,     0,   231,   232,   233,     0,     0,   234,   235,     0,
     236,   237,   238,   239,   240,   241,   242,   724,     0,   243,
     244,   245,   725,   726,   246,   247,     0,   248,   249,   250,
     727,     0,   251,     0,     0,     0,   252,     0,   253,     0,
     254,     0,   255,   256,   728,   258,   729,   260,   261,     0,
     262,     0,   730,     0,   263,   264,   265,     0,   266,   731,
     732,     0,   267,   268,     0,     0,     0,   733,   270,   271,
     272,   273,   734,     0,   274,   275,   276,     0,   277,     0,
     278,     0,     0,     0,   735,   279,   280,   736,     0,     0,
     281,     0,   282,   283,     0,   284,   285,     0,     0,     0,
     286,     0,     0,   287,   288,   737,     0,     0,   290,     0,
     738,   291,   292,     0,     0,     0,     0,     0,   739,   294,
       0,   295,     0,   296,     0,   297,   298,     0,     0,   740,
       0,     0,     0,     0,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
       0,   315,   316,   317,   318,   741,   319,   320,   321,   322,
     742,   323,   324,     0,     0,     0,     0,   325,   326,   327,
     328,   743,   330,     0,     0,   744,   332,   745,   333,     0,
     334,   746,   747,   748,   749,   750,   339,   340,   341,   342,
     343,     0,   751,   344,   345,     0,     0,   346,   347,   348,
     349,   752,   753,   754,   350,   351,     0,   755,   756,   352,
       0,   353,   354,   757,     0,   356,   357,   358,   359,     0,
     360,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,   363,   364,     0,   758,   365,     0,   366,     0,   367,
     368,   759,   370,   371,   372,   373,   760,   761,   376,   762,
       0,   377,   378,   379,     0,   380,     0,   381,   382,   383,
     384,   385,     0,   763,   387,   388,     0,     0,   389,     0,
       0,     0,   390,   391,   392,   393,   394,     0,     0,   395,
     396,   397,   398,   399,     0,   400,   401,     0,   402,   403,
     404,   764,   765,   405,     0,   406,     0,   407,   408,     0,
     409,   410,     0,   411,     0,   766,     0,   767,   413,   414,
     415,   416,   417,   418,   768,   769,   421,   422,   423,   424,
       0,   770,   426,     0,     0,     0,   427,   428,   429,   430,
       0,     0,     0,   431,     0,     0,     0,   432,     0,   433,
     434,   435,   436,   437,   438,     0,   439,   440,   441,   442,
     443,   444,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,     0,     0,   448,     0,     0,   449,   450,     0,
       0,     0,   451,   771,   772,   452,   453,     0,   454,   455,
     773,   457,   458,   459,   774,   775,   460,   461,   462,   463,
     776,   464,   465,     0,   466,     0,   467,   468,   469,   470,
       0,   777,   471,   472,     0,   778,   779,   780,   781,     0,
       0,     0,     0,     0,   477,   478,   479,     0,   782,   783,
     784,   481,   482,   483,   785,   484,   485,   786,   486,   487,
       0,   488,   489,     0,     0,   490,     0,     0,   491,     0,
     492,     0,   787,   494,   495,     0,     0,   788,   789,   790,
     791,   496,     0,     0,   497,   792,     0,   793,   498,   499,
     500,   501,   502,   794,   795,     0,     0,     0,     0,     0,
       0,   505,   506,     0,   507,   508,   509,     0,     0,   796,
       0,     0,     0,     0,   797,   798,     0,     0,     0,     0,
     799,   800,     0,     0,   801,   802,     0,     0,   803,   804,
     141,     0,   142,   691,   144,   145,   146,   147,     0,     0,
     148,     0,     0,     0,   149,     0,     0,   692,     0,   151,
     152,   153,   154,   155,   156,   693,   158,     0,   159,     0,
       0,   694,   160,   695,   696,   697,   161,   698,     0,   162,
     163,   164,     0,   165,     0,   166,   167,     0,     0,   168,
     699,   700,   169,   170,     0,   171,   701,   702,   173,   174,
       0,   175,   176,   177,   178,   179,   703,   181,     0,   704,
     183,   705,   706,   707,   708,   709,     0,   189,   190,   191,
     192,   193,   194,   195,   196,     0,   197,   198,     0,   199,
     200,   201,   710,   203,     0,   204,   711,   712,   205,     0,
       0,   206,   713,   207,   714,   715,   208,     0,   209,   716,
     717,     0,   210,   211,   212,   718,   719,   720,     0,     0,
       0,     0,   721,   215,   722,     0,     0,   723,   216,     0,
     217,     0,     0,     0,   218,     0,   219,   220,   221,   222,
     223,     0,     0,     0,   224,     0,     0,   225,   226,   227,
       0,     0,     0,   228,     0,   229,   230,     0,   231,   232,
     233,     0,     0,   234,   235,     0,   236,   237,   238,   239,
     240,   241,   242,   724,     0,   243,   244,   245,   725,   726,
     246,   247,     0,   248,   249,   250,   727,     0,   251,     0,
       0,     0,   252,     0,   253,     0,   254,     0,   255,   256,
     728,   258,   729,   260,   261,     0,   262,     0,   730,     0,
     263,   264,   265,     0,   266,   731,   732,     0,   267,   268,
       0,     0,     0,   733,   270,   271,   272,   273,   734,     0,
     274,   275,   276,     0,   277,     0,   278,     0,     0,     0,
     735,   279,   280,   736,     0,     0,   281,     0,   282,   283,
       0,   284,   285,     0,     0,     0,   286,     0,     0,   287,
     288,   737,     0,     0,   290,     0,   738,   291,   292,     0,
       0,     0,     0,     0,   739,   294,     0,   295,     0,   296,
       0,   297,   298,     0,     0,   740,     0,     0,     0,     0,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,     0,   315,   316,   317,
     318,   741,   319,   320,   321,   322,   742,   323,   324,     0,
       0,     0,     0,   325,   326,   327,   328,   743,   330,     0,
       0,   744,   332,   745,   333,     0,   334,   746,   747,   748,
     749,   750,   339,   340,   341,   342,   343,     0,   751,   344,
     345,     0,     0,   346,   347,   348,   349,   752,   753,   754,
     350,   351,     0,   755,   756,   352,     0,   353,   354,   757,
       0,   356,   357,   358,   359,     0,   360,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,   363,   364,     0,
     758,   365,     0,   366,     0,   367,   368,   759,   370,   371,
     372,   373,   760,   761,   376,   762,     0,   377,   378,   379,
       0,   380,     0,   381,   382,   383,   384,   385,     0,   763,
     387,   388,     0,     0,   389,     0,     0,     0,   390,   391,
     392,   393,   394,     0,     0,   395,   396,   397,   398,   399,
       0,   400,   401,     0,   402,   403,   404,   764,   765,   405,
       0,   406,     0,   407,   408,     0,   409,   410,     0,   411,
       0,   766,     0,   767,   413,   414,   415,   416,   417,   418,
     768,   769,   421,   422,   423,   424,     0,   770,   426,     0,
       0,     0,   427,   428,   429,   430,     0,     0,     0,   431,
       0,     0,     0,   432,     0,   433,   434,   435,   436,   437,
     438,     0,   439,   440,   441,   442,   443,   444,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,     0,     0,
     448,     0,     0,   449,   450,     0,     0,     0,   451,   771,
     772,   452,   453,     0,   454,   455,   773,   457,   458,   459,
     774,   775,   460,   461,   462,   463,   776,   464,   465,     0,
     466,     0,   467,   468,   469,   470,     0,   777,   471,   472,
       0,   778,   779,   780,   781,     0,     0,     0,     0,     0,
     477,   478,   479,     0,   782,   783,   784,   481,   482,   483,
     785,   484,   485,   786,   486,   487,     0,   488,   489,     0,
       0,   490,     0,     0,   491,     0,   492,     0,   787,   494,
     495,     0,     0,   788,   789,   790,   791,   496,     0,     0,
     497,   792,     0,   793,   498,   499,   500,   501,   502,   794,
     795,     0,     0,     0,     0,     0,     0,   505,   506,     0,
     507,   508,   509,     0,     0,   796,     0,     0,     0,     0,
     797,   798,     0,     0,     0,     0,   799,  1182,     0,     0,
     801,   802,     0,     0,   803,   804,   141,     0,   142,   691,
     144,   145,   146,   147,  1803,     0,   148,     0,     0,     0,
    1804,     0,     0,   692,     0,   151,   152,   153,   154,   155,
     156,   693,   158,     0,   159,     0,     0,   694,   160,   695,
     696,   697,   161,   698,     0,   162,   163,   164,     0,   165,
       0,   166,   167,     0,     0,   168,   699,   700,   169,   170,
       0,   171,   701,   702,   173,   174,     0,   175,   176,   177,
     178,   179,   703,   181,     0,   704,   183,   705,   706,   707,
     708,   709,     0,   189,   190,   191,   192,   193,   194,   195,
     196,     0,   197,   198,     0,   199,   200,   201,   710,   203,
       0,   204,   711,   712,   205,     0,     0,   206,   713,   207,
     714,   715,   208,     0,   209,   716,   717,     0,   210,   211,
     212,   718,   719,   720,     0,     0,     0,     0,   721,   215,
     722,     0,     0,   723,   216,     0,   217,     0,     0,     0,
     218,     0,   219,   220,   221,   222,   223,     0,     0,     0,
     224,     0,     0,   225,   226,   227,     0,     0,     0,   228,
       0,   229,   230,     0,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,   239,   240,   241,   242,   724,
       0,   243,   244,   245,   725,   726,   246,   247,     0,   248,
     249,   250,   727,     0,   251,     0,     0,     0,   252,     0,
     253,     0,   254,     0,   255,   256,   728,   258,   729,   260,
     261,     0,   262,     0,   730,     0,   263,   264,   265,     0,
     266,   731,   732,     0,   267,   268,     0,     0,     0,   733,
     270,   271,   272,   273,   734,     0,   274,   275,   276,     0,
     277,     0,   278,     0,     0,     0,   735,   279,   280,   736,
       0,     0,   281,     0,   282,   283,     0,   284,   285,     0,
       0,     0,   286,     0,     0,   287,   288,   737,     0,     0,
     290,     0,   738,   291,   292,     0,     0,     0,     0,     0,
     739,   294,     0,   295,     0,   296,     0,   297,   298,     0,
       0,   740,     0,     0,     0,     0,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,     0,   315,   316,   317,   318,   741,   319,   320,
     321,   322,   742,   323,   324,     0,     0,     0,     0,   325,
     326,   327,   328,   743,   330,     0,     0,   744,   332,   745,
     333,     0,   334,   746,   747,   748,   749,   750,   339,   340,
     341,   342,   343,     0,   751,   344,   345,     0,     0,   346,
     347,   348,   349,   752,     0,   754,   350,   351,     0,   755,
     756,   352,     0,   353,   354,   757,     0,   356,   357,   358,
     359,     0,   360,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,   363,   364,     0,   758,   365,     0,   366,
       0,   367,   368,   759,   370,   371,   372,   373,   760,   761,
     376,   762,     0,   377,   378,   379,     0,   380,     0,   381,
     382,   383,   384,   385,     0,   763,   387,   388,     0,     0,
     389,     0,     0,     0,   390,   391,   392,   393,   394,     0,
       0,   395,   396,   397,   398,   399,     0,   400,   401,     0,
     402,   403,   404,   764,   765,   405,     0,   406,     0,   407,
     408,     0,   409,   410,     0,   411,     0,   766,     0,   767,
     413,   414,   415,   416,   417,   418,   768,   769,   421,   422,
     423,   424,     0,   770,   426,     0,     0,     0,   427,   428,
     429,   430,     0,     0,     0,   431,     0,     0,     0,   432,
       0,   433,   434,   435,   436,   437,   438,     0,   439,   440,
     441,   442,   443,   444,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,     0,     0,   448,     0,     0,   449,
     450,     0,     0,     0,   451,   771,   772,   452,   453,     0,
     454,   455,   773,   457,   458,   459,   774,   775,   460,   461,
     462,   463,   776,   464,   465,     0,   466,     0,   467,   468,
     469,   470,     0,   777,   471,   472,     0,   778,   779,   780,
     781,     0,     0,     0,     0,     0,   477,   478,   479,     0,
     782,   783,   784,   481,   482,   483,   785,   484,   485,   786,
     486,   487,     0,   488,   489,     0,     0,   490,     0,     0,
     491,     0,   492,     0,   787,   494,   495,     0,     0,   788,
     789,   790,   791,   496,     0,     0,   497,   792,     0,   793,
     498,   499,   500,   501,   502,   794,   795,     0,     0,     0,
       0,     0,     0,   505,   506,     0,   507,   508,   509,     0,
       0,   796,     0,     0,     0,     0,   797,   798,     0,     0,
       0,     0,   799,   800,     0,     0,   801,   802,     0,     0,
     803,   804,   141,     0,   142,   691,   144,   145,   146,   147,
       0,     0,   148,     0,     0,     0,   149,     0,     0,   692,
       0,   151,   152,   153,   154,   155,   156,   693,   158,     0,
     159,     0,     0,   694,   160,   695,   696,   697,   161,   698,
       0,   162,   163,   164,     0,   165,     0,   166,   167,     0,
       0,   168,   699,   700,   169,   170,     0,   171,   701,   702,
     173,   174,     0,   175,   176,   177,   178,   179,   703,   181,
       0,   704,   183,   705,   706,   707,   708,   709,     0,   189,
     190,   191,   192,   193,   194,   195,   196,     0,   197,   198,
       0,   199,   200,   201,   710,   203,     0,   204,   711,   712,
     205,     0,     0,   206,   713,   207,   714,   715,   208,     0,
     209,   716,   717,     0,   210,   211,   212,   718,   719,   720,
       0,     0,     0,     0,   721,   215,   722,     0,     0,   723,
     216,     0,   217,     0,     0,     0,   218,     0,   219,   220,
     221,   222,   223,     0,     0,     0,   224,     0,     0,   225,
     226,   227,     0,     0,     0,   228,     0,   229,   230,     0,
     231,   232,   233,     0,     0,   234,   235,     0,   236,   237,
     238,   239,   240,   241,   242,   724,     0,   243,   244,   245,
     725,   726,   246,   247,     0,   248,   249,   250,   727,     0,
     251,     0,     0,     0,   252,     0,   253,     0,   254,     0,
     255,   256,   728,   258,   729,   260,   261,     0,   262,     0,
     730,     0,   263,   264,   265,     0,   266,   731,   732,     0,
     267,   268,     0,     0,     0,   733,   270,   271,   272,   273,
     734,     0,   274,   275,   276,     0,   277,     0,   278,     0,
       0,     0,   735,   279,   280,   736,     0,     0,   281,     0,
     282,   283,     0,   284,   285,     0,     0,     0,   286,     0,
       0,   287,   288,   737,     0,     0,   290,     0,   738,   291,
     292,     0,     0,     0,     0,     0,   739,   294,     0,   295,
       0,   296,     0,   297,   298,     0,     0,   740,     0,     0,
       0,     0,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,     0,   315,
     316,   317,   318,   741,   319,   320,   321,   322,   742,   323,
     324,     0,     0,     0,     0,   325,   326,   327,   328,   743,
     330,     0,     0,   744,   332,   745,   333,     0,   334,   746,
     747,   748,   749,   750,   339,   340,   341,   342,   343,     0,
     751,   344,   345,     0,     0,   346,   347,   348,   349,   752,
     753,   754,   350,   351,     0,   755,   756,   352,     0,   353,
     354,   757,     0,   356,   357,   358,   359,     0,   360,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,   363,
     364,     0,   758,   365,     0,   366,     0,   367,   368,   759,
     370,   371,   372,   373,   760,   761,   376,   762,     0,   377,
     378,   379,     0,   380,     0,   381,   382,   383,   384,   385,
       0,   763,   387,   388,     0,     0,   389,     0,     0,     0,
     390,   391,   392,   393,   394,     0,     0,   395,   396,   397,
     398,   399,     0,   400,   401,     0,   402,   403,   404,   764,
     765,   405,     0,   406,     0,   407,   408,     0,   409,   410,
       0,   411,     0,   766,     0,   767,   413,   414,   415,   416,
     417,   418,   768,   769,   421,   422,   423,   424,     0,   770,
     426,     0,     0,     0,   427,   428,   429,   430,     0,     0,
       0,   431,     0,     0,     0,   432,     0,   433,   434,   435,
     436,   437,   438,     0,   439,   440,   441,   442,   443,   444,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
       0,     0,   448,     0,     0,   449,   450,     0,     0,     0,
     451,   771,   772,   452,   453,     0,   454,   455,   773,   457,
     458,   459,   774,   775,   460,   461,   462,   463,   776,   464,
     465,     0,   466,     0,   467,   468,   469,   470,     0,   777,
     471,   472,     0,   778,   779,   780,   781,     0,     0,     0,
       0,     0,   477,   478,   479,     0,   782,   783,   784,   481,
     482,   483,   785,   484,   485,   786,   486,   487,     0,   488,
     489,     0,     0,   490,     0,     0,   491,     0,   492,     0,
    1900,   494,   495,     0,     0,   788,   789,   790,   791,   496,
       0,     0,   497,   792,     0,   793,   498,   499,   500,   501,
     502,   794,   795,     0,     0,     0,     0,     0,     0,   505,
     506,     0,   507,   508,   509,     0,     0,   796,     0,     0,
       0,     0,   797,   798,     0,     0,     0,     0,   799,   800,
       0,     0,   801,   802,     0,     0,   803,   804,   141,     0,
     142,   691,   144,   145,   146,   147,     0,     0,   148,     0,
       0,     0,   149,     0,     0,   692,     0,   151,   152,   153,
     154,   155,   156,   693,   158,     0,   159,     0,     0,   694,
     160,   695,   696,   697,   161,   698,     0,   162,   163,   164,
       0,   165,     0,   166,   167,     0,     0,   168,   699,   700,
     169,   170,     0,   171,   701,   702,   173,   174,     0,   175,
     176,   177,   178,   179,   703,   181,     0,   704,   183,   705,
     706,   707,   708,   709,     0,   189,   190,   191,   192,   193,
     194,   195,   196,     0,   197,   198,     0,   199,   200,   201,
     710,   203,     0,   204,   711,   712,   205,     0,     0,   206,
     713,   207,   714,   715,   208,     0,   209,   716,   717,     0,
     210,   211,   212,   718,   719,   720,     0,     0,     0,     0,
     721,   215,   722,     0,     0,   723,   216,     0,   217,     0,
       0,     0,   218,     0,   219,   220,   221,   222,   223,     0,
       0,     0,   224,     0,     0,   225,   226,   227,     0,     0,
       0,   228,     0,   229,   230,     0,   231,   232,   233,     0,
       0,   234,   235,     0,   236,   237,   238,   239,   240,   241,
     242,   724,     0,   243,   244,   245,   725,   726,   246,   247,
       0,   248,   249,   250,   727,     0,   251,     0,     0,     0,
     252,     0,   253,     0,   254,     0,   255,   256,   728,   258,
     729,   260,   261,     0,   262,     0,   730,     0,   263,   264,
     265,     0,   266,   731,   732,     0,   267,   268,     0,     0,
       0,   733,   270,   271,   272,   273,   734,     0,   274,   275,
     276,     0,   277,     0,   278,     0,     0,     0,   735,   279,
     280,  2724,     0,     0,   281,     0,   282,   283,     0,   284,
     285,     0,     0,     0,   286,     0,     0,   287,   288,   737,
       0,     0,   290,     0,   738,   291,   292,     0,     0,     0,
       0,     0,   739,   294,     0,   295,     0,   296,     0,   297,
     298,     0,     0,   740,     0,     0,     0,     0,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,     0,   315,   316,   317,   318,   741,
     319,   320,   321,   322,   742,   323,   324,     0,     0,     0,
       0,   325,   326,   327,   328,   743,   330,     0,     0,   744,
     332,   745,   333,     0,   334,   746,   747,   748,   749,   750,
     339,   340,   341,   342,   343,     0,   751,   344,   345,     0,
       0,   346,   347,   348,   349,   752,   753,   754,   350,   351,
       0,   755,   756,   352,     0,   353,   354,   757,     0,   356,
     357,   358,   359,     0,   360,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,   363,   364,     0,   758,   365,
       0,   366,     0,   367,   368,   759,   370,   371,   372,   373,
     760,   761,   376,   762,     0,   377,   378,   379,     0,   380,
       0,   381,   382,   383,   384,   385,     0,   763,   387,   388,
       0,     0,   389,     0,     0,     0,   390,   391,   392,   393,
     394,     0,     0,   395,   396,   397,   398,   399,     0,   400,
     401,     0,   402,   403,   404,   764,   765,   405,     0,   406,
       0,   407,   408,     0,   409,   410,     0,   411,     0,   766,
       0,   767,   413,   414,   415,   416,   417,   418,   768,   769,
     421,   422,   423,   424,     0,   770,   426,     0,     0,     0,
     427,   428,   429,   430,     0,     0,     0,   431,     0,     0,
       0,   432,     0,   433,   434,   435,   436,   437,   438,     0,
     439,   440,   441,   442,   443,   444,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,     0,     0,   448,     0,
       0,   449,   450,     0,     0,     0,   451,   771,   772,   452,
     453,     0,   454,   455,   773,   457,   458,   459,   774,   775,
     460,   461,   462,   463,   776,   464,   465,     0,   466,     0,
     467,   468,   469,   470,     0,   777,   471,   472,     0,   778,
     779,   780,   781,     0,     0,     0,     0,     0,   477,   478,
     479,     0,   782,   783,   784,   481,   482,   483,   785,   484,
     485,   786,   486,   487,     0,   488,   489,     0,     0,   490,
       0,     0,   491,     0,   492,     0,   787,   494,   495,     0,
       0,   788,   789,   790,   791,   496,     0,     0,   497,   792,
       0,   793,   498,   499,   500,   501,   502,   794,   795,     0,
       0,     0,     0,     0,     0,   505,   506,     0,   507,   508,
     509,     0,     0,   796,     0,     0,     0,     0,   797,   798,
       0,     0,     0,     0,   799,   800,     0,     0,   801,   802,
       0,     0,   803,   804,   141,     0,   142,   691,   144,   145,
     146,   147,     0,     0,   148,     0,     0,     0,   149,     0,
       0,   692,     0,   151,   152,   153,   154,   155,   156,   693,
     158,     0,   159,     0,     0,   694,   160,   695,   696,   697,
     161,   698,     0,   162,   163,   164,     0,   165,     0,   166,
     167,     0,     0,   168,   699,   700,   169,   170,     0,   171,
     701,   702,   173,   174,     0,   175,   176,   177,   178,   179,
     703,   181,     0,   704,   183,   705,   706,   707,   708,   709,
       0,   189,   190,   191,   192,   193,   194,   195,   196,     0,
     197,   198,     0,   199,   200,   201,   710,   203,     0,   204,
     711,   712,   205,     0,     0,   206,   713,   207,   714,   715,
     208,     0,   209,   716,   717,     0,   210,   211,   212,   718,
     719,   720,     0,     0,     0,     0,   721,   215,   722,     0,
       0,   723,   216,     0,   217,     0,     0,     0,   218,     0,
     219,   220,   221,   222,   223,     0,     0,     0,   224,     0,
       0,   225,   226,   227,     0,     0,     0,   228,     0,   229,
     230,     0,   231,   232,   233,     0,     0,   234,   235,     0,
     236,   237,   238,   239,   240,   241,   242,   724,     0,   243,
     244,   245,   725,   726,   246,   247,     0,   248,   249,   250,
     727,     0,   251,     0,     0,     0,   252,     0,   253,     0,
     254,     0,   255,   256,   728,   258,   729,   260,   261,     0,
     262,     0,   730,     0,   263,   264,   265,     0,   266,   731,
     732,     0,   267,   268,     0,     0,     0,   733,   270,   271,
     272,   273,   734,     0,   274,   275,   276,     0,   277,     0,
     278,     0,     0,     0,   735,   279,   280,  2775,     0,     0,
     281,     0,   282,   283,     0,   284,   285,     0,     0,     0,
     286,     0,     0,   287,   288,   737,     0,     0,   290,     0,
     738,   291,   292,     0,     0,     0,     0,     0,   739,   294,
       0,   295,     0,   296,     0,   297,   298,     0,     0,   740,
       0,     0,     0,     0,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
       0,   315,   316,   317,   318,   741,   319,   320,   321,   322,
     742,   323,   324,     0,     0,     0,     0,   325,   326,   327,
     328,   743,   330,     0,     0,   744,   332,   745,   333,     0,
     334,   746,   747,   748,   749,   750,   339,   340,   341,   342,
     343,     0,   751,   344,   345,     0,     0,   346,   347,   348,
     349,   752,   753,   754,   350,   351,     0,   755,   756,   352,
       0,   353,   354,   757,     0,   356,   357,   358,   359,     0,
     360,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,   363,   364,     0,   758,   365,     0,   366,     0,   367,
     368,   759,   370,   371,   372,   373,   760,   761,   376,   762,
       0,   377,   378,   379,     0,   380,     0,   381,   382,   383,
     384,   385,     0,   763,   387,   388,     0,     0,   389,     0,
       0,     0,   390,   391,   392,   393,   394,     0,     0,   395,
     396,   397,   398,   399,     0,   400,   401,     0,   402,   403,
     404,   764,   765,   405,     0,   406,     0,   407,   408,     0,
     409,   410,     0,   411,     0,   766,     0,   767,   413,   414,
     415,   416,   417,   418,   768,   769,   421,   422,   423,   424,
       0,   770,   426,     0,     0,     0,   427,   428,   429,   430,
       0,     0,     0,   431,     0,     0,     0,   432,     0,   433,
     434,   435,   436,   437,   438,     0,   439,   440,   441,   442,
     443,   444,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,     0,     0,   448,     0,     0,   449,   450,     0,
       0,     0,   451,   771,   772,   452,   453,     0,   454,   455,
     773,   457,   458,   459,   774,   775,   460,   461,   462,   463,
     776,   464,   465,     0,   466,     0,   467,   468,   469,   470,
       0,   777,   471,   472,     0,   778,   779,   780,   781,     0,
       0,     0,     0,     0,   477,   478,   479,     0,   782,   783,
     784,   481,   482,   483,   785,   484,   485,   786,   486,   487,
       0,   488,   489,     0,     0,   490,     0,     0,   491,     0,
     492,     0,   787,   494,   495,     0,     0,   788,   789,   790,
     791,   496,     0,     0,   497,   792,     0,   793,   498,   499,
     500,   501,   502,   794,   795,     0,     0,     0,     0,     0,
       0,   505,   506,     0,   507,   508,   509,     0,     0,   796,
       0,     0,     0,     0,   797,   798,     0,     0,     0,     0,
     799,   800,     0,     0,   801,   802,     0,     0,   803,   804,
     141,     0,   142,   691,   144,   145,   146,   147,     0,     0,
     148,     0,     0,     0,   149,     0,     0,   692,     0,   151,
     152,   153,   154,   155,   156,   693,   158,     0,   159,     0,
       0,   694,   160,   695,   696,   697,   161,   698,     0,   162,
     163,   164,     0,   165,     0,   166,   167,     0,     0,   168,
     699,   700,   169,   170,     0,   171,   701,   702,   173,   174,
       0,   175,   176,   177,   178,   179,   703,   181,     0,   704,
     183,   705,   706,   707,   708,   709,     0,   189,   190,   191,
     192,   193,   194,   195,   196,     0,   197,   198,     0,   199,
     200,   201,   710,   203,     0,   204,   711,   712,   205,     0,
       0,   206,   713,   207,   714,   715,   208,     0,   209,   716,
     717,     0,   210,   211,   212,   718,   719,   720,     0,     0,
       0,     0,   721,   215,   722,     0,     0,  3609,   216,     0,
     217,     0,     0,     0,   218,     0,   219,   220,   221,   222,
     223,     0,     0,     0,   224,     0,     0,   225,   226,   227,
       0,     0,     0,   228,     0,   229,   230,     0,   231,   232,
     233,     0,     0,   234,   235,     0,   236,   237,   238,   239,
     240,   241,   242,   724,     0,   243,   244,   245,   725,   726,
     246,   247,     0,   248,   249,   250,   727,     0,   251,     0,
       0,     0,   252,     0,   253,     0,   254,     0,   255,   256,
     728,   258,   729,   260,   261,     0,   262,     0,   730,     0,
     263,   264,   265,     0,   266,   731,   732,     0,   267,   268,
       0,     0,     0,   733,   270,   271,   272,   273,   734,     0,
     274,   275,   276,     0,   277,     0,   278,     0,     0,     0,
     735,   279,   280,   736,     0,     0,   281,     0,   282,   283,
       0,   284,   285,     0,     0,     0,   286,     0,     0,   287,
     288,   737,     0,     0,   290,     0,   738,   291,   292,     0,
       0,     0,     0,     0,   739,   294,     0,   295,     0,   296,
       0,   297,   298,     0,     0,   740,     0,     0,     0,     0,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,     0,   315,   316,   317,
     318,   741,   319,   320,   321,   322,   742,   323,   324,     0,
       0,     0,     0,   325,   326,   327,   328,   743,   330,     0,
       0,   744,   332,   745,   333,     0,   334,   746,   747,   748,
     749,   750,   339,   340,   341,   342,   343,     0,   751,   344,
     345,     0,     0,   346,   347,   348,   349,   752,   753,   754,
     350,   351,     0,   755,   756,   352,     0,   353,   354,   757,
       0,   356,   357,   358,   359,     0,   360,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,   363,   364,     0,
     758,   365,     0,   366,     0,   367,   368,   759,   370,   371,
     372,   373,   760,   761,   376,   762,     0,   377,   378,   379,
       0,   380,     0,   381,   382,   383,   384,   385,     0,   763,
     387,   388,     0,     0,   389,     0,     0,     0,   390,   391,
     392,   393,   394,     0,     0,   395,   396,   397,   398,   399,
       0,   400,   401,     0,   402,   403,   404,   764,   765,   405,
       0,   406,     0,   407,   408,     0,   409,   410,     0,   411,
       0,   766,     0,   767,   413,   414,   415,   416,   417,   418,
     768,   769,   421,   422,   423,   424,     0,   770,   426,     0,
       0,     0,   427,   428,   429,   430,     0,     0,     0,   431,
       0,     0,     0,   432,     0,   433,   434,   435,   436,   437,
     438,     0,   439,   440,   441,   442,   443,   444,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,     0,     0,
     448,     0,     0,   449,   450,     0,     0,     0,   451,   771,
     772,   452,   453,     0,   454,   455,   773,   457,   458,   459,
     774,   775,   460,   461,   462,   463,   776,   464,   465,     0,
     466,     0,   467,   468,   469,   470,     0,   777,   471,   472,
       0,   778,   779,   780,   781,     0,     0,     0,     0,     0,
     477,   478,   479,     0,   782,   783,   784,   481,   482,   483,
     785,   484,   485,   786,   486,   487,     0,   488,   489,     0,
       0,   490,     0,     0,   491,     0,   492,     0,   787,   494,
     495,     0,     0,   788,   789,   790,   791,   496,     0,     0,
     497,   792,     0,   793,   498,   499,   500,   501,   502,   794,
     795,     0,     0,     0,     0,     0,     0,   505,   506,     0,
     507,   508,   509,     0,     0,   796,     0,     0,     0,     0,
     797,   798,     0,     0,     0,     0,   799,   800,     0,     0,
     801,   802,     0,     0,   803,   804,   141,     0,   142,   691,
     144,   145,   146,   147,     0,     0,   148,     0,     0,     0,
     149,     0,     0,   692,     0,   151,   152,   153,   154,   155,
     156,   693,   158,     0,   159,     0,     0,   694,   160,   695,
     696,   697,   161,   698,     0,   162,   163,   164,     0,   165,
       0,   166,   167,     0,     0,   168,   699,   700,   169,   170,
       0,   171,   701,   702,   173,   174,     0,   175,   176,   177,
     178,   179,   703,   181,     0,   704,   183,   705,   706,   707,
     708,   709,     0,   189,   190,   191,   192,   193,   194,   195,
     196,     0,   197,   198,     0,   199,   200,   201,   710,   203,
       0,   204,   711,   712,   205,     0,     0,   206,   713,   207,
     714,   715,   208,     0,   209,   716,   717,     0,   210,   211,
     212,   718,   719,   720,     0,     0,     0,     0,   721,   215,
     722,     0,     0,   723,   216,     0,   217,     0,     0,     0,
     218,     0,   219,   220,   221,   222,   223,     0,     0,     0,
     224,     0,     0,   225,   226,   227,     0,     0,     0,   228,
       0,   229,   230,     0,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,   239,   240,   241,   242,   724,
       0,   243,   244,   245,   725,   726,   246,   247,     0,   248,
     249,   250,   727,     0,   251,     0,     0,     0,   252,     0,
     253,     0,   254,     0,   255,   256,   728,   258,   729,   260,
     261,     0,   262,     0,   730,     0,   263,   264,   265,     0,
     266,   731,   732,     0,   267,   268,     0,     0,     0,   733,
     270,   271,   272,   273,   734,     0,   274,   275,   276,     0,
     277,     0,   278,     0,     0,     0,   735,   279,   280,   736,
       0,     0,   281,     0,   282,   283,     0,   284,   285,     0,
       0,     0,   286,     0,     0,   287,   288,   737,     0,     0,
     290,     0,   738,   291,   292,     0,     0,     0,     0,     0,
     739,   294,     0,   295,     0,   296,     0,   297,   298,     0,
       0,   740,     0,     0,     0,     0,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,     0,   315,   316,   317,   318,   741,   319,   320,
     321,   322,   742,   323,   324,  4623,     0,     0,     0,   325,
     326,   327,   328,   743,   330,     0,     0,   744,   332,   745,
     333,     0,   334,   746,   747,   748,   749,   750,   339,   340,
     341,   342,   343,     0,   751,   344,   345,     0,     0,   346,
     347,   348,   349,   752,     0,   754,   350,   351,     0,   755,
     756,   352,     0,   353,   354,   757,     0,   356,   357,   358,
     359,     0,   360,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,   363,   364,     0,   758,   365,     0,   366,
       0,   367,   368,   759,   370,   371,   372,   373,   760,   761,
     376,   762,     0,   377,   378,   379,     0,   380,     0,   381,
     382,   383,   384,   385,     0,   763,   387,   388,     0,     0,
     389,     0,     0,     0,   390,   391,   392,   393,   394,     0,
       0,   395,   396,   397,   398,   399,     0,   400,   401,     0,
     402,   403,   404,   764,   765,   405,     0,   406,     0,   407,
     408,     0,   409,   410,     0,   411,     0,   766,     0,   767,
     413,   414,   415,   416,   417,   418,   768,   769,   421,   422,
     423,   424,     0,   770,   426,     0,     0,     0,   427,   428,
     429,   430,     0,     0,     0,   431,     0,     0,     0,   432,
       0,   433,   434,   435,   436,   437,   438,     0,   439,   440,
     441,   442,   443,   444,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,     0,     0,   448,     0,     0,   449,
     450,     0,     0,     0,   451,   771,   772,   452,   453,     0,
     454,   455,   773,   457,   458,   459,   774,   775,   460,   461,
     462,   463,   776,   464,   465,     0,   466,     0,   467,   468,
     469,   470,     0,   777,   471,   472,     0,   778,   779,   780,
     781,     0,     0,     0,     0,     0,   477,   478,   479,     0,
     782,   783,   784,   481,   482,   483,   785,   484,   485,   786,
     486,   487,     0,   488,   489,     0,     0,   490,     0,     0,
     491,     0,   492,     0,   787,   494,   495,     0,     0,   788,
     789,   790,   791,   496,     0,     0,   497,   792,     0,   793,
     498,   499,   500,   501,   502,   794,   795,     0,     0,     0,
       0,     0,     0,   505,   506,     0,   507,   508,   509,     0,
       0,   796,     0,     0,     0,     0,   797,   798,     0,     0,
       0,     0,   799,   800,     0,     0,   801,   802,     0,     0,
     803,   804,   141,     0,   142,   691,   144,   145,   146,   147,
       0,     0,   148,     0,     0,     0,   149,     0,     0,   692,
       0,   151,   152,   153,   154,   155,   156,   693,   158,     0,
     159,     0,     0,   694,   160,   695,   696,   697,   161,   698,
       0,   162,   163,   164,     0,   165,     0,   166,   167,     0,
       0,   168,   699,   700,   169,   170,     0,   171,   701,   702,
     173,   174,     0,   175,   176,   177,   178,   179,   703,   181,
       0,   704,   183,   705,   706,   707,   708,   709,     0,   189,
     190,   191,   192,   193,   194,   195,   196,     0,   197,   198,
       0,   199,   200,   201,   710,   203,     0,   204,   711,   712,
     205,     0,     0,   206,   713,   207,   714,   715,   208,     0,
     209,   716,   717,     0,   210,   211,   212,   718,   719,   720,
       0,     0,     0,     0,   721,   215,   722,     0,     0,   723,
     216,     0,   217,     0,     0,     0,   218,     0,   219,   220,
     221,   222,   223,     0,     0,     0,   224,     0,     0,   225,
     226,   227,     0,     0,     0,   228,     0,   229,   230,     0,
     231,   232,   233,     0,     0,   234,   235,     0,   236,   237,
     238,   239,   240,   241,   242,   724,     0,   243,   244,   245,
     725,   726,   246,   247,     0,   248,   249,   250,   727,     0,
     251,     0,     0,     0,   252,     0,   253,     0,   254,     0,
     255,   256,   728,   258,   729,   260,   261,     0,   262,     0,
     730,     0,   263,   264,   265,     0,   266,   731,   732,     0,
     267,   268,     0,     0,     0,   733,   270,   271,   272,   273,
     734,     0,   274,   275,   276,     0,   277,     0,   278,     0,
       0,     0,   735,   279,   280,   736,     0,     0,   281,     0,
     282,   283,     0,   284,   285,     0,     0,     0,   286,     0,
       0,   287,   288,   737,     0,     0,   290,     0,   738,   291,
     292,     0,     0,     0,     0,     0,   739,   294,     0,   295,
       0,   296,     0,   297,   298,     0,     0,   740,     0,     0,
       0,     0,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,     0,   315,
     316,   317,   318,   741,   319,   320,   321,   322,   742,   323,
     324,     0,     0,     0,     0,   325,   326,   327,   328,   743,
     330,     0,     0,   744,   332,   745,   333,     0,   334,   746,
     747,   748,   749,   750,   339,   340,   341,   342,   343,     0,
     751,   344,   345,     0,     0,   346,   347,   348,   349,   752,
       0,   754,   350,   351,     0,   755,   756,   352,     0,   353,
     354,   757,     0,   356,   357,   358,   359,     0,   360,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,   363,
     364,     0,   758,   365,     0,   366,     0,   367,   368,   759,
     370,   371,   372,   373,   760,   761,   376,   762,     0,   377,
     378,   379,     0,   380,     0,   381,   382,   383,   384,   385,
       0,   763,   387,   388,     0,     0,   389,     0,     0,     0,
     390,   391,   392,   393,   394,     0,     0,   395,   396,   397,
     398,   399,     0,   400,   401,     0,   402,   403,   404,   764,
     765,   405,     0,   406,     0,   407,   408,     0,   409,   410,
       0,   411,     0,   766,     0,   767,   413,   414,   415,   416,
     417,   418,   768,   769,   421,   422,   423,   424,     0,   770,
     426,     0,     0,     0,   427,   428,   429,   430,     0,     0,
       0,   431,     0,     0,     0,   432,     0,   433,   434,   435,
     436,   437,   438,     0,   439,   440,   441,   442,   443,   444,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
       0,     0,   448,     0,     0,   449,   450,     0,     0,     0,
     451,   771,   772,   452,   453,     0,   454,   455,   773,   457,
     458,   459,   774,   775,   460,   461,   462,   463,   776,   464,
     465,     0,   466,     0,   467,   468,   469,   470,     0,   777,
     471,   472,     0,   778,   779,   780,   781,     0,     0,     0,
       0,     0,   477,   478,   479,     0,   782,   783,   784,   481,
     482,   483,   785,   484,   485,   786,   486,   487,     0,   488,
     489,     0,     0,   490,     0,     0,   491,     0,   492,     0,
     787,   494,   495,     0,     0,   788,   789,   790,   791,   496,
       0,     0,   497,   792,     0,   793,   498,   499,   500,   501,
     502,   794,   795,     0,     0,     0,     0,     0,     0,   505,
     506,     0,   507,   508,   509,     0,     0,   796,     0,     0,
       0,     0,   797,   798,     0,     0,     0,     0,   799,   800,
       0,     0,   801,   802,     0,     0,   803,   804,   141,     0,
     142,   691,   144,   145,   146,   147,     0,     0,   148,     0,
       0,     0,   149,     0,     0,   692,     0,   151,   152,   153,
     154,   155,   156,   693,   158,     0,   159,     0,     0,   694,
     160,   695,   696,   697,   161,   698,     0,   162,   163,   164,
       0,   165,     0,   166,   167,     0,     0,   168,   699,   700,
     169,   170,     0,   171,   701,   702,   173,   174,     0,   175,
     176,   177,   178,   179,   703,   181,     0,   704,   183,   705,
     706,   707,   708,   709,     0,   189,   190,   191,   192,   193,
     194,   195,   196,     0,   197,   198,     0,   199,   200,   201,
     710,   203,     0,   204,   711,   712,   205,     0,     0,   206,
     713,   207,   714,   715,   208,     0,   209,   716,   717,     0,
     210,   211,   212,   718,   719,   720,     0,     0,     0,     0,
     721,   215,   722,     0,     0,   723,   216,     0,   217,     0,
       0,     0,   218,     0,   219,   220,   221,   222,   223,     0,
       0,     0,   224,     0,     0,   225,   226,   227,     0,     0,
       0,   228,     0,   229,   230,     0,   231,   232,   233,     0,
       0,   234,   235,     0,   236,   237,   238,   239,   240,   241,
     242,   724,     0,   243,   244,   245,   725,   726,   246,   247,
       0,   248,   249,   250,   727,     0,   251,     0,     0,     0,
     252,     0,   253,     0,   254,     0,   255,   256,   728,   258,
     729,   260,   261,     0,   262,     0,   730,     0,   263,   264,
     265,     0,   266,   731,   732,     0,   267,   268,     0,     0,
       0,   733,   270,   271,   272,   273,   734,     0,   274,   275,
     276,     0,   277,     0,   278,     0,     0,     0,   735,   279,
     280,  1818,     0,     0,   281,     0,   282,   283,     0,   284,
     285,     0,     0,     0,   286,     0,     0,   287,   288,   737,
       0,     0,   290,     0,   738,   291,   292,     0,     0,     0,
       0,     0,   739,   294,     0,   295,     0,   296,     0,   297,
     298,     0,     0,   740,     0,     0,     0,     0,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,     0,   315,   316,   317,   318,   741,
     319,   320,   321,   322,   742,   323,   324,     0,     0,     0,
       0,   325,   326,   327,   328,   743,   330,     0,     0,   744,
     332,   745,   333,     0,   334,   746,   747,   748,   749,   750,
     339,   340,   341,   342,   343,     0,   751,   344,   345,     0,
       0,   346,   347,   348,   349,   752,     0,   754,   350,   351,
       0,   755,   756,   352,     0,   353,   354,   757,     0,   356,
     357,   358,   359,     0,   360,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,   363,   364,     0,   758,   365,
       0,   366,     0,   367,   368,   759,   370,   371,   372,   373,
     760,   761,   376,   762,     0,   377,   378,   379,     0,   380,
       0,   381,   382,   383,   384,   385,     0,   763,   387,   388,
       0,     0,   389,     0,     0,     0,   390,   391,   392,   393,
     394,     0,     0,   395,   396,   397,   398,   399,     0,   400,
     401,     0,   402,   403,   404,   764,   765,   405,     0,   406,
       0,   407,   408,     0,   409,   410,     0,   411,     0,   766,
       0,   767,   413,   414,   415,   416,   417,   418,   768,   769,
     421,   422,   423,   424,     0,   770,   426,     0,     0,     0,
     427,   428,   429,   430,     0,     0,     0,   431,     0,     0,
       0,   432,     0,   433,   434,   435,   436,   437,   438,     0,
     439,   440,   441,   442,   443,   444,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,     0,     0,   448,     0,
       0,   449,   450,     0,     0,     0,   451,   771,   772,   452,
     453,     0,   454,   455,   773,   457,   458,   459,   774,   775,
     460,   461,   462,   463,   776,   464,   465,     0,   466,     0,
     467,   468,   469,   470,     0,   777,   471,   472,     0,   778,
     779,   780,   781,     0,     0,     0,     0,     0,   477,   478,
     479,     0,   782,   783,   784,   481,   482,   483,   785,   484,
     485,   786,   486,   487,     0,   488,   489,     0,     0,   490,
       0,     0,   491,     0,   492,     0,   787,   494,   495,     0,
       0,   788,   789,   790,   791,   496,     0,     0,   497,   792,
       0,   793,   498,   499,   500,   501,   502,   794,   795,     0,
       0,     0,     0,     0,     0,   505,   506,     0,   507,   508,
     509,     0,     0,   796,     0,     0,     0,     0,   797,   798,
       0,     0,     0,     0,   799,   800,     0,     0,   801,   802,
       0,     0,   803,   804,   141,     0,   142,   691,   144,   145,
     146,   147,     0,     0,   148,     0,     0,     0,   149,     0,
       0,   692,     0,   151,   152,   153,   154,   155,   156,   693,
     158,     0,   159,     0,     0,   694,   160,   695,   696,   697,
     161,   698,     0,   162,   163,   164,     0,   165,     0,   166,
     167,     0,     0,   168,   699,   700,   169,   170,     0,   171,
     701,   702,   173,   174,     0,   175,   176,   177,   178,   179,
     703,   181,     0,   704,   183,   705,   706,   707,   708,   709,
       0,   189,   190,   191,   192,   193,   194,   195,   196,     0,
     197,   198,     0,   199,   200,   201,   710,   203,     0,   204,
     711,   712,   205,     0,     0,   206,   713,   207,   714,   715,
     208,     0,   209,   716,   717,     0,   210,   211,   212,   718,
     719,   720,     0,     0,     0,     0,   721,   215,   722,     0,
       0,   723,   216,     0,   217,     0,     0,     0,   218,     0,
     219,   220,   221,   222,   223,     0,     0,     0,   224,     0,
       0,   225,   226,   227,     0,     0,     0,   228,     0,   229,
     230,     0,   231,   232,   233,     0,     0,   234,   235,     0,
     236,   237,   238,   239,   240,   241,   242,   724,     0,   243,
     244,   245,   725,   726,   246,   247,     0,   248,   249,   250,
     727,     0,   251,     0,     0,     0,   252,     0,   253,     0,
     254,     0,   255,   256,   728,   258,   729,   260,   261,     0,
     262,     0,   730,     0,   263,   264,   265,     0,   266,   731,
     732,     0,   267,   268,     0,     0,     0,   733,   270,   271,
     272,   273,   734,     0,   274,   275,   276,     0,   277,     0,
     278,     0,     0,     0,   735,   279,   280,  1820,     0,     0,
     281,     0,   282,   283,     0,   284,   285,     0,     0,     0,
     286,     0,     0,   287,   288,   737,     0,     0,   290,     0,
     738,   291,   292,     0,     0,     0,     0,     0,   739,   294,
       0,   295,     0,   296,     0,   297,   298,     0,     0,   740,
       0,     0,     0,     0,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
       0,   315,   316,   317,   318,   741,   319,   320,   321,   322,
     742,   323,   324,     0,     0,     0,     0,   325,   326,   327,
     328,   743,   330,     0,     0,   744,   332,   745,   333,     0,
     334,   746,   747,   748,   749,   750,   339,   340,   341,   342,
     343,     0,   751,   344,   345,     0,     0,   346,   347,   348,
     349,   752,     0,   754,   350,   351,     0,   755,   756,   352,
       0,   353,   354,   757,     0,   356,   357,   358,   359,     0,
     360,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,   363,   364,     0,   758,   365,     0,   366,     0,   367,
     368,   759,   370,   371,   372,   373,   760,   761,   376,   762,
       0,   377,   378,   379,     0,   380,     0,   381,   382,   383,
     384,   385,     0,   763,   387,   388,     0,     0,   389,     0,
       0,     0,   390,   391,   392,   393,   394,     0,     0,   395,
     396,   397,   398,   399,     0,   400,   401,     0,   402,   403,
     404,   764,   765,   405,     0,   406,     0,   407,   408,     0,
     409,   410,     0,   411,     0,   766,     0,   767,   413,   414,
     415,   416,   417,   418,   768,   769,   421,   422,   423,   424,
       0,   770,   426,     0,     0,     0,   427,   428,   429,   430,
       0,     0,     0,   431,     0,     0,     0,   432,     0,   433,
     434,   435,   436,   437,   438,     0,   439,   440,   441,   442,
     443,   444,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,     0,     0,   448,     0,     0,   449,   450,     0,
       0,     0,   451,   771,   772,   452,   453,     0,   454,   455,
     773,   457,   458,   459,   774,   775,   460,   461,   462,   463,
     776,   464,   465,     0,   466,     0,   467,   468,   469,   470,
       0,   777,   471,   472,     0,   778,   779,   780,   781,     0,
       0,     0,     0,     0,   477,   478,   479,     0,   782,   783,
     784,   481,   482,   483,   785,   484,   485,   786,   486,   487,
       0,   488,   489,     0,     0,   490,     0,     0,   491,     0,
     492,     0,   787,   494,   495,     0,     0,   788,   789,   790,
     791,   496,     0,     0,   497,   792,     0,   793,   498,   499,
     500,   501,   502,   794,   795,     0,     0,     0,     0,     0,
       0,   505,   506,     0,   507,   508,   509,     0,     0,   796,
       0,     0,     0,     0,   797,   798,     0,     0,     0,     0,
     799,   800,     0,     0,   801,   802,     0,     0,   803,   804,
     141,     0,   142,   143,   144,   145,   146,   147,     0,     0,
     148,     0,     0,     0,   149,     0,     0,   150,     0,   151,
     152,   153,   154,   155,   156,   157,   158,     0,   159,     0,
       0,     0,   160,   695,     0,     0,   161,     0,     0,   162,
     163,   164,     0,   165,     0,   166,   167,     0,     0,   168,
       0,     0,   169,   170,     0,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,   184,   185,   186,   187,   188,     0,   189,   190,   191,
     192,   193,   194,   195,   196,     0,   197,   198,     0,   199,
     200,   201,   202,   203,     0,   204,     0,     0,   205,     0,
       0,   206,     0,   207,     0,     0,   208,     0,   209,     0,
       0,     0,   210,   211,   212,     0,     0,  1859,     0,     0,
       0,     0,   214,   215,   722,     0,     0,     0,   216,     0,
     217,     0,     0,     0,   218,     0,   219,   220,   221,   222,
     223,     0,     0,     0,   224,     0,     0,   225,   226,   227,
       0,     0,     0,   228,     0,   229,   230,     0,   231,   232,
     233,     0,     0,   234,   235,     0,   236,   237,   238,   239,
     240,   241,   242,     0,     0,   243,   244,   245,     0,   726,
     246,   247,     0,   248,   249,   250,   727,     0,   251,     0,
       0,     0,   252,     0,   253,     0,   254,     0,   255,   256,
     257,   258,   259,   260,   261,     0,   262,     0,     0,     0,
     263,   264,   265,     0,   266,   731,   732,     0,   267,   268,
       0,     0,     0,   269,   270,   271,   272,   273,     0,     0,
     274,   275,   276,     0,   277,     0,   278,     0,     0,     0,
       0,   279,   280,     0,     0,     0,   281,     0,   282,   283,
       0,   284,   285,     0,     0,     0,   286,     0,     0,   287,
     288,   289,     0,     0,   290,     0,     0,   291,   292,     0,
       0,     0,     0,     0,   293,   294,     0,   295,     0,   296,
       0,   297,   298,     0,     0,   740,     0,     0,     0,     0,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,     0,   315,   316,   317,
     318,     0,   319,   320,   321,   322,     0,   323,   324,     0,
       0,     0,     0,   325,   326,   327,   328,   329,   330,     0,
       0,   331,   332,     0,   333,     0,   334,     0,   335,   336,
     337,   338,   339,   340,   341,   342,   343,     0,   751,   344,
     345,     0,     0,   346,   347,   348,   349,     0,     0,     0,
     350,   351,     0,   755,   756,   352,     0,   353,   354,   355,
       0,   356,   357,   358,   359,     0,   360,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,   363,   364,     0,
       0,   365,     0,   366,     0,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
       0,   380,     0,   381,   382,   383,   384,   385,     0,   386,
     387,   388,     0,     0,   389,     0,     0,     0,   390,   391,
     392,   393,   394,     0,     0,   395,   396,   397,   398,   399,
       0,   400,   401,     0,   402,   403,   404,     0,     0,   405,
       0,   406,     0,   407,   408,     0,   409,   410,     0,   411,
       0,   412,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,     0,     0,   431,
       0,     0,     0,   432,     0,   433,   434,   435,   436,   437,
     438,     0,   439,   440,   441,   442,   443,   444,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,     0,     0,
     448,     0,     0,   449,   450,     0,     0,     0,   451,     0,
       0,   452,   453,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,   461,   462,   463,     0,   464,   465,     0,
     466,     0,   467,   468,   469,   470,     0,   777,   471,   472,
       0,  1860,   474,   475,  1861,     0,     0,     0,     0,     0,
     477,   478,   479,     0,     0,   783,   480,   481,   482,   483,
     785,   484,   485,   786,   486,   487,     0,   488,   489,     0,
       0,   490,     0,     0,   491,     0,   492,     0,   493,   494,
     495,     0,     0,     0,     0,     0,     0,   496,     0,     0,
     497,     0,     0,     0,   498,   499,   500,   501,   502,   503,
     504,     0,     0,     0,     0,     0,     0,   505,   506,     0,
     507,   508,   509,     0,     0,   510,     0,     0,     0,   141,
       0,   142,   143,   144,   145,   146,   147,     0,     0,   148,
       0,     0,     0,   149,   803,   804,   150,     0,   151,   152,
     153,   154,   155,   156,   157,   158,     0,   159,     0,     0,
       0,   160,     0,     0,     0,   161,     0,     0,   162,   163,
     164,     0,   165,     0,   166,   167,     0,     0,   168,     0,
       0,   169,   170,     0,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,     0,   182,   183,
     184,   185,   186,   187,   188,     0,   189,   190,   191,   192,
     193,   194,   195,   196,     0,   197,   198,  2996,   199,   200,
     201,   202,   203,     0,   204,     0,     0,   205,     0,     0,
     206,     0,   207,     0,     0,   208,     0,   209,     0,     0,
       0,   210,   211,   212,     0,     0,   213,     0,     0,     0,
       0,   214,   215,     0,     0,     0,     0,   216,     0,   217,
       0,     0,     0,   218,     0,   219,   220,   221,   222,   223,
       0,     0,     0,   224,     0,     0,   225,   226,   227,     0,
       0,     0,   228,     0,   229,   230,     0,   231,   232,   233,
       0,     0,   234,   235,     0,   236,   237,   238,   239,   240,
     241,   242,     0,     0,   243,   244,   245,     0,     0,   246,
     247,     0,   248,   249,   250,     0,     0,   251,     0,     0,
       0,   252,     0,   253,   524,   254,     0,   255,   256,   257,
     258,   259,   260,   261,     0,   262,     0,     0,     0,   263,
     264,   265,     0,   266,     0,     0,     0,   267,   268,     0,
       0,     0,   269,   270,   271,   272,   273,     0,     0,   274,
     275,   276,  2131,   277,     0,   278,     0,     0,     0,     0,
     279,   280,     0,     0,     0,   281,     0,   282,   283,     0,
     284,   285,     0,     0,     0,   286,  2132,     0,   287,   288,
     289,     0,     0,   290,     0,     0,   291,   292,     0,  3147,
       0,     0,     0,   293,   294,     0,   295,     0,   296,     0,
     297,   298,     0,     0,     0,     0,     0,     0,     0,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,     0,   315,   316,   317,   318,
       0,   319,   320,   321,   322,     0,   323,   324,     0,     0,
       0,     0,   325,   326,   327,   328,   329,   330,     0,     0,
     331,   332,     0,   333,     0,   334,     0,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,   344,   345,
       0,     0,   346,   347,   348,   349,     0,     0,     0,   350,
     351,     0,     0,     0,   352,     0,   353,   354,   355,     0,
     356,   357,   358,   359,     0,   360,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,   363,   364,     0,     0,
     365,     0,   366,     0,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,     0,     0,   377,   378,   379,     0,
     380,     0,   381,   382,   383,   384,   385,     0,   386,   387,
     388,     0,     0,   389,     0,     0,     0,   390,   391,   392,
     393,   394,     0,     0,   395,   396,   397,   398,   399,     0,
     400,   401,     0,   402,   403,   404,     0,     0,   405,     0,
     406,     0,   407,   408,     0,   409,   410,     0,   411,     0,
     412,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,  2437,     0,
       0,   427,   428,   429,   430,     0,     0,     0,   431,     0,
       0,     0,   432,     0,   433,   434,   435,   436,   437,   438,
       0,   439,   440,   441,   442,   443,   444,   528,     0,     0,
       0,     0,     0,   445,   446,     0,   447,     0,     0,   448,
       0,     0,   449,   450,     0,     0,     0,   451,     0,     0,
     452,   453,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,   461,   462,   463,     0,   464,   465,     0,   466,
       0,   467,   468,   469,   470,     0,     0,   471,   472,     0,
     473,   474,   475,   476,     0,     0,     0,     0,     0,   477,
     478,   479,     0,     0,     0,   480,   481,   482,   483,     0,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
     490,     0,     0,   491,     0,   492,     0,   493,   494,   495,
       0,     0,     0,     0,     0,     0,   496,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,   503,   504,
       0,     0,     0,     0,     0,     0,   505,   506,     0,   507,
     508,   509,     0,     0,   510,     0,   141,     0,   142,   143,
     144,   145,   146,   147,     0,     0,   148,     0,     0,     0,
     149,     0,     0,   150,  3069,   151,   152,   153,   154,   155,
     156,   157,   158,     0,   159,     0,     0,     0,   160,     0,
       0,     0,   161,     0,     0,   162,   163,   164,     0,   165,
       0,   166,   167,     0,     0,   168,     0,     0,   169,   170,
       0,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,     0,   182,   183,   184,   185,   186,
     187,   188,     0,   189,   190,   191,   192,   193,   194,   195,
     196,     0,   197,   198,  2996,   199,   200,   201,   202,   203,
       0,   204,     0,     0,   205,     0,     0,   206,     0,   207,
       0,     0,   208,     0,   209,     0,     0,     0,   210,   211,
     212,     0,     0,   213,     0,     0,     0,     0,   214,   215,
       0,     0,     0,     0,   216,     0,   217,     0,     0,     0,
     218,     0,   219,   220,   221,   222,   223,     0,     0,     0,
     224,     0,     0,   225,   226,   227,     0,     0,     0,   228,
       0,   229,   230,     0,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,   239,   240,   241,   242,     0,
       0,   243,   244,   245,     0,     0,   246,   247,     0,   248,
     249,   250,     0,     0,   251,     0,     0,     0,   252,     0,
     253,   524,   254,     0,   255,   256,   257,   258,   259,   260,
     261,     0,   262,     0,     0,     0,   263,   264,   265,     0,
     266,     0,     0,     0,   267,   268,     0,     0,     0,   269,
     270,   271,   272,   273,     0,     0,   274,   275,   276,  2131,
     277,     0,   278,     0,     0,     0,     0,   279,   280,     0,
       0,     0,   281,     0,   282,   283,     0,   284,   285,     0,
       0,     0,   286,  2132,     0,   287,   288,   289,     0,     0,
     290,     0,     0,   291,   292,     0,     0,     0,     0,     0,
     293,   294,     0,   295,     0,   296,     0,   297,   298,     0,
       0,     0,     0,     0,     0,     0,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,     0,   315,   316,   317,   318,     0,   319,   320,
     321,   322,     0,   323,   324,     0,     0,     0,     0,   325,
     326,   327,   328,   329,   330,     0,     0,   331,   332,     0,
     333,     0,   334,     0,   335,   336,   337,   338,   339,   340,
     341,   342,   343,     0,     0,   344,   345,     0,     0,   346,
     347,   348,   349,     0,     0,     0,   350,   351,     0,     0,
       0,   352,     0,   353,   354,   355,     0,   356,   357,   358,
     359,     0,   360,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,   363,   364,     0,     0,   365,     0,   366,
       0,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,     0,     0,   377,   378,   379,     0,   380,     0,   381,
     382,   383,   384,   385,     0,   386,   387,   388,     0,     0,
     389,     0,     0,     0,   390,   391,   392,   393,   394,     0,
       0,   395,   396,   397,   398,   399,     0,   400,   401,     0,
     402,   403,   404,     0,     0,   405,     0,   406,     0,   407,
     408,     0,   409,   410,     0,   411,     0,   412,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,     0,     0,     0,   427,   428,
     429,   430,     0,     0,     0,   431,     0,     0,     0,   432,
       0,   433,   434,   435,   436,   437,   438,     0,   439,   440,
     441,   442,   443,   444,   528,     0,     0,     0,     0,     0,
     445,   446,     0,   447,     0,     0,   448,     0,     0,   449,
     450,     0,     0,     0,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,   461,
     462,   463,     0,   464,   465,     0,   466,     0,   467,   468,
     469,   470,     0,     0,   471,   472,     0,   473,   474,   475,
     476,     0,     0,     0,     0,     0,   477,   478,   479,     0,
       0,     0,   480,   481,   482,   483,     0,   484,   485,     0,
     486,   487,     0,   488,   489,     0,     0,   490,     0,     0,
     491,     0,   492,     0,   493,   494,   495,     0,     0,     0,
       0,     0,     0,   496,     0,     0,   497,     0,     0,     0,
     498,   499,   500,   501,   502,   503,   504,     0,     0,     0,
       0,     0,     0,   505,   506,     0,   507,   508,   509,     0,
       0,   510,     0,   141,     0,   142,   143,   144,   145,   146,
     147,     0,     0,   148,     0,     0,     0,   149,     0,     0,
     150,  3069,   151,   152,   153,   154,   155,   156,   157,   158,
       0,   159,     0,     0,     0,   160,     0,     0,     0,   161,
       0,     0,   162,   163,   164,     0,   165,     0,   166,   167,
       0,     0,   168,     0,     0,   169,   170,     0,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,     0,   182,   183,   184,   185,   186,   187,   188,     0,
     189,   190,   191,   192,   193,   194,   195,   196,     0,   197,
     198,     0,   199,   200,   201,   202,   203,     0,   204,     0,
       0,   205,     0,     0,   206,     0,   207,     0,     0,   208,
       0,   209,     0,     0,     0,   210,   211,   212,     0,     0,
     213,     0,     0,     0,     0,   214,   215,     0,     0,     0,
       0,   216,     0,   217,     0,     0,     0,   218,     0,   219,
     220,   221,   222,   223,     0,     0,     0,   224,     0,     0,
     225,   226,   227,     0,     0,     0,   228,     0,   229,   230,
       0,   231,   232,   233,     0,     0,   234,   235,     0,   236,
     237,   238,   239,   240,   241,   242,     0,     0,   243,   244,
     245,     0,     0,   246,   247,     0,   248,   249,   250,     0,
       0,   251,     0,     0,     0,   252,     0,   253,     0,   254,
       0,   255,   256,   257,   258,   259,   260,   261,     0,   262,
       0,     0,     0,   263,   264,   265,     0,   266,     0,     0,
       0,   267,   268,     0,     0,     0,   269,   270,   271,   272,
     273,     0,     0,   274,   275,   276,     0,   277,     0,   278,
       0,     0,     0,     0,   279,   280,     0,     0,     0,   281,
       0,   282,   283,     0,   284,   285,     0,     0,     0,   286,
       0,     0,   287,   288,   289,     0,     0,   290,     0,     0,
     291,   292,     0,     0,     0,     0,     0,   293,   294,     0,
     295,     0,   296,     0,   297,   298,     0,     0,     0,     0,
       0,     0,     0,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,     0,
     315,   316,   317,   318,     0,   319,   320,   321,   322,     0,
     323,   324,     0,     0,     0,     0,   325,   326,   327,   328,
     329,   330,     0,     0,   331,   332,     0,   333,     0,   334,
       0,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,   344,   345,     0,     0,   346,   347,   348,   349,
       0,     0,     0,   350,   351,     0,     0,     0,   352,     0,
     353,   354,   355,     0,   356,   357,   358,   359,     0,   360,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
     363,   364,     0,     0,   365,     0,   366,     0,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,     0,   380,     0,   381,   382,   383,   384,
     385,     0,   386,   387,   388,     0,     0,   389,     0,     0,
       0,   390,   391,   392,   393,   394,     0,     0,   395,   396,
     397,   398,   399,     0,   400,   401,     0,   402,   403,   404,
       0,     0,   405,     0,   406,     0,   407,   408,     0,   409,
     410,     0,   411,     0,   412,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,  2437,     0,     0,   427,   428,   429,   430,     0,
       0,     0,   431,     0,     0,     0,   432,     0,   433,   434,
     435,   436,   437,   438,     0,   439,   440,   441,   442,   443,
     444,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,     0,     0,   448,     0,     0,   449,   450,     0,     0,
       0,   451,     0,     0,   452,   453,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,   461,   462,   463,     0,
     464,   465,     0,   466,     0,   467,   468,   469,   470,     0,
       0,   471,   472,     0,   473,   474,   475,   476,     0,     0,
       0,     0,     0,   477,   478,   479,     0,     0,     0,   480,
     481,   482,   483,     0,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,   490,     0,     0,   491,     0,   492,
       0,   493,   494,   495,     0,     0,     0,     0,     0,     0,
     496,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,   503,   504,     0,     0,     0,     0,     0,     0,
     505,   506,     0,   507,   508,   509,     0,     0,   510,     0,
     141,     0,   142,   143,   144,   145,   146,   147,     0,     0,
     148,  2880,     0,     0,   149,     0,     0,   150,   804,   151,
     152,   153,   154,   155,   156,   157,   158,     0,   159,     0,
       0,     0,   160,     0,     0,     0,   161,     0,     0,   162,
     163,   164,     0,   165,     0,   166,   167,     0,     0,   168,
       0,     0,   169,   170,     0,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,   184,   185,   186,   187,   188,     0,   189,   190,   191,
     192,   193,   194,   195,   196,     0,   197,   198,     0,   199,
     200,   201,   202,   203,     0,   204,     0,     0,   205,     0,
       0,   206,     0,   207,     0,     0,   208,     0,   209,     0,
       0,     0,   210,   211,   212,     0,     0,   213,     0,     0,
       0,     0,   214,   215,     0,     0,     0,     0,   216,     0,
     217,     0,     0,     0,   218,     0,   219,   220,   221,   222,
     223,     0,     0,     0,   224,     0,     0,   225,   226,   227,
       0,     0,     0,   228,     0,   229,   230,     0,   231,   232,
     233,     0,     0,   234,   235,     0,   236,   237,   238,   239,
     240,   241,   242,     0,     0,   243,   244,   245,     0,     0,
     246,   247,     0,   248,   249,   250,     0,     0,   251,     0,
       0,     0,   252,     0,   253,     0,   254,     0,   255,   256,
     257,   258,   259,   260,   261,     0,   262,     0,     0,     0,
     263,   264,   265,     0,   266,     0,     0,     0,   267,   268,
       0,     0,     0,   269,   270,   271,   272,   273,     0,     0,
     274,   275,   276,     0,   277,     0,   278,     0,     0,     0,
       0,   279,   280,     0,     0,     0,   281,     0,   282,   283,
       0,   284,   285,     0,     0,     0,   286,     0,     0,   287,
     288,   289,     0,     0,   290,     0,     0,   291,   292,     0,
       0,     0,     0,     0,   293,   294,     0,   295,     0,   296,
       0,   297,   298,     0,     0,     0,     0,     0,     0,     0,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,     0,   315,   316,   317,
     318,     0,   319,   320,   321,   322,     0,   323,   324,     0,
       0,     0,     0,   325,   326,   327,   328,   329,   330,     0,
       0,   331,   332,     0,   333,     0,   334,     0,   335,   336,
     337,   338,   339,   340,   341,   342,   343,     0,     0,   344,
     345,     0,     0,   346,   347,   348,   349,     0,     0,     0,
     350,   351,     0,     0,     0,   352,     0,   353,   354,   355,
       0,   356,   357,   358,   359,     0,   360,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,   363,   364,     0,
       0,   365,     0,   366,     0,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
       0,   380,     0,   381,   382,   383,   384,   385,     0,   386,
     387,   388,     0,     0,   389,     0,     0,     0,   390,   391,
     392,   393,   394,     0,     0,   395,   396,   397,   398,   399,
       0,   400,   401,     0,   402,   403,   404,     0,     0,   405,
       0,   406,     0,   407,   408,     0,   409,   410,     0,   411,
       0,   412,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,     0,     0,   431,
       0,     0,     0,   432,     0,   433,   434,   435,   436,   437,
     438,     0,   439,   440,   441,   442,   443,   444,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,     0,     0,
     448,     0,     0,   449,   450,     0,     0,     0,   451,     0,
       0,   452,   453,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,   461,   462,   463,     0,   464,   465,     0,
     466,     0,   467,   468,   469,   470,     0,     0,   471,   472,
       0,   473,   474,   475,   476,     0,     0,     0,     0,     0,
     477,   478,   479,     0,     0,     0,   480,   481,   482,   483,
       0,   484,   485,     0,   486,   487,     0,   488,   489,     0,
       0,   490,     0,     0,   491,     0,   492,     0,   493,   494,
     495,     0,     0,     0,     0,     0,     0,   496,     0,     0,
     497,     0,     0,     0,   498,   499,   500,   501,   502,   503,
     504,     0,     0,     0,     0,     0,     0,   505,   506,     0,
     507,   508,   509,     0,     0,   510,     0,     0,     0,   141,
       0,   142,   143,   144,   145,   146,   147,     0,  4764,   148,
       0,     0,     0,   149,  4765,   804,   150,     0,   151,   152,
     153,   154,   155,   156,   157,   158,     0,   159,     0,     0,
       0,   160,     0,     0,     0,   161,     0,     0,   162,   163,
     164,     0,   165,     0,   166,   167,     0,     0,   168,     0,
       0,   169,   170,     0,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,     0,   182,   183,
     184,   185,   186,   187,   188,     0,   189,   190,   191,   192,
     193,   194,   195,   196,     0,   197,   198,     0,   199,   200,
     201,   202,   203,     0,   204,     0,     0,   205,     0,     0,
     206,     0,   207,     0,     0,   208,     0,   209,     0,     0,
       0,   210,   211,   212,     0,     0,   213,     0,     0,     0,
       0,   214,   215,     0,     0,     0,     0,   216,     0,   217,
       0,     0,     0,   218,     0,   219,   220,   221,   222,   223,
       0,     0,     0,   224,     0,     0,   225,   226,   227,     0,
       0,     0,   228,     0,   229,   230,     0,   231,   232,   233,
       0,     0,   234,   235,     0,   236,   237,   238,   239,   240,
     241,   242,     0,     0,   243,   244,   245,     0,     0,   246,
     247,     0,   248,   249,   250,     0,     0,   251,     0,     0,
       0,   252,     0,   253,     0,   254,     0,   255,   256,   257,
     258,   259,   260,   261,     0,   262,     0,     0,     0,   263,
     264,   265,     0,   266,     0,     0,     0,   267,   268,     0,
       0,     0,   269,   270,   271,   272,   273,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,     0,     0,     0,
     279,   280,     0,     0,     0,   281,     0,   282,   283,     0,
     284,   285,     0,     0,     0,   286,     0,     0,   287,   288,
     289,     0,     0,   290,     0,     0,   291,   292,     0,     0,
       0,     0,     0,   293,   294,     0,   295,     0,   296,     0,
     297,   298,     0,     0,     0,     0,     0,     0,     0,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,     0,   315,   316,   317,   318,
       0,   319,   320,   321,   322,     0,   323,   324,     0,     0,
       0,     0,   325,   326,   327,   328,   329,   330,     0,     0,
     331,   332,     0,   333,     0,   334,     0,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,   344,   345,
       0,     0,   346,   347,   348,   349,     0,     0,     0,   350,
     351,     0,     0,     0,   352,     0,   353,   354,   355,     0,
     356,   357,   358,   359,     0,   360,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,   363,   364,     0,     0,
     365,     0,   366,     0,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,     0,     0,   377,   378,   379,     0,
     380,     0,   381,   382,   383,   384,   385,     0,   386,   387,
     388,     0,     0,   389,     0,     0,     0,   390,   391,   392,
     393,   394,     0,     0,   395,   396,   397,   398,   399,     0,
     400,   401,     0,   402,   403,   404,     0,     0,   405,     0,
     406,     0,   407,   408,     0,   409,   410,     0,   411,     0,
     412,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,     0,     0,
       0,   427,   428,   429,   430,     0,     0,     0,   431,     0,
       0,     0,   432,     0,   433,   434,   435,   436,   437,   438,
       0,   439,   440,   441,   442,   443,   444,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,     0,     0,   448,
       0,     0,   449,   450,     0,     0,     0,   451,     0,     0,
     452,   453,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,   461,   462,   463,     0,   464,   465,     0,   466,
       0,   467,   468,   469,   470,     0,     0,   471,   472,     0,
     473,   474,   475,   476,     0,     0,     0,     0,     0,   477,
     478,   479,     0,     0,     0,   480,   481,   482,   483,     0,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
     490,     0,     0,   491,     0,   492,     0,   493,   494,   495,
       0,     0,     0,     0,     0,     0,   496,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,   503,   504,
       0,     0,     0,     0,     0,     0,   505,   506,     0,   507,
     508,   509,     0,     0,   510,     0,     0,     0,   141,     0,
     142,   143,   144,   145,   146,   147,  1187,     0,   148,     0,
       0,     0,   149,     0,   804,   150,     0,   151,   152,   153,
     154,   155,   156,   157,   158,     0,   159,     0,     0,     0,
     160,     0,     0,     0,   161,     0,     0,   162,   163,   164,
       0,   165,     0,   166,   167,     0,     0,   168,     0,     0,
     169,   170,     0,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,     0,   182,   183,   184,
     185,   186,   187,   188,     0,   189,   190,   191,   192,   193,
     194,   195,   196,     0,   197,   198,     0,   199,   200,   201,
     202,   203,     0,   204,     0,     0,   205,     0,     0,   206,
       0,   207,     0,     0,   208,     0,   209,     0,     0,     0,
     210,   211,   212,     0,     0,   213,     0,     0,     0,     0,
     214,   215,     0,     0,     0,     0,   216,     0,   217,     0,
       0,     0,   218,     0,   219,   220,   221,   222,   223,     0,
       0,     0,   224,     0,     0,   225,   226,   227,     0,     0,
       0,   228,     0,   229,   230,     0,   231,   232,   233,     0,
       0,   234,   235,     0,   236,   237,   238,   239,   240,   241,
     242,     0,     0,   243,   244,   245,     0,     0,   246,   247,
       0,   248,   249,   250,     0,     0,   251,     0,     0,     0,
     252,     0,   253,     0,   254,     0,   255,   256,   257,   258,
     259,   260,   261,     0,   262,     0,     0,     0,   263,   264,
     265,     0,   266,     0,     0,     0,   267,   268,     0,     0,
       0,   269,   270,   271,   272,   273,     0,     0,   274,   275,
     276,     0,   277,     0,   278,     0,     0,     0,     0,   279,
     280,     0,  1403,     0,   281,     0,   282,   283,     0,   284,
     285,     0,     0,     0,   286,     0,     0,   287,   288,   289,
       0,     0,   290,     0,     0,   291,   292,     0,     0,     0,
       0,     0,   293,   294,     0,   295,     0,   296,     0,   297,
     298,     0,     0,     0,     0,     0,     0,     0,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,     0,   315,   316,   317,   318,     0,
     319,   320,   321,   322,     0,   323,   324,     0,     0,     0,
       0,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,   333,     0,   334,     0,   335,   336,   337,   338,
     339,   340,   341,   342,   343,     0,     0,   344,   345,     0,
       0,   346,   347,   348,   349,     0,     0,     0,   350,   351,
       0,     0,     0,   352,     0,   353,   354,   355,     0,   356,
     357,   358,   359,     0,   360,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,   363,   364,     0,     0,   365,
       0,   366,     0,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,     0,     0,   377,   378,   379,     0,   380,
       0,   381,   382,   383,   384,   385,     0,   386,   387,   388,
       0,     0,   389,     0,     0,     0,   390,   391,   392,   393,
     394,     0,     0,   395,   396,   397,   398,   399,     0,   400,
     401,     0,   402,   403,   404,     0,     0,   405,     0,   406,
       0,   407,   408,     0,   409,   410,     0,   411,     0,   412,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,     0,     0,     0,
     427,   428,   429,   430,     0,     0,     0,   431,     0,     0,
       0,   432,     0,   433,   434,   435,   436,   437,   438,     0,
     439,   440,   441,   442,   443,   444,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,     0,     0,   448,     0,
       0,   449,   450,     0,     0,     0,   451,     0,     0,   452,
     453,     0,   454,   455,   456,   457,   458,   459,     0,     0,
     460,   461,   462,   463,     0,   464,   465,     0,   466,     0,
     467,   468,   469,   470,     0,     0,   471,   472,     0,   473,
     474,   475,   476,     0,     0,     0,     0,     0,   477,   478,
     479,     0,     0,     0,   480,   481,   482,   483,     0,   484,
     485,     0,   486,   487,     0,   488,   489,     0,     0,   490,
       0,     0,   491,     0,   492,     0,   493,   494,   495,     0,
       0,     0,     0,     0,     0,   496,     0,     0,   497,     0,
       0,     0,   498,   499,   500,   501,   502,   503,   504,     0,
       0,     0,     0,     0,     0,   505,   506,     0,   507,   508,
     509,     0,     0,   510,     0,   141,     0,   142,   143,   144,
     145,   146,   147,     0,     0,   148,     0,     0,     0,   149,
       0,     0,   150,   562,   151,   152,   153,   154,   155,   156,
     157,   158,     0,   159,     0,     0,     0,   160,     0,     0,
       0,   161,     0,     0,   162,   163,   164,     0,   165,     0,
     166,   167,     0,     0,   168,     0,     0,   169,   170,     0,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,   184,   185,   186,   187,
     188,     0,   189,   190,   191,   192,   193,   194,   195,   196,
       0,   197,   198,     0,   199,   200,   201,   202,   203,     0,
     204,     0,     0,   205,     0,     0,   206,     0,   207,     0,
       0,   208,     0,   209,     0,     0,     0,   210,   211,   212,
       0,     0,   213,     0,     0,     0,     0,   214,   215,     0,
       0,     0,     0,   216,     0,   217,     0,     0,     0,   218,
       0,   219,   220,   221,   222,   223,     0,     0,     0,   224,
       0,     0,   225,   226,   227,     0,     0,     0,   228,     0,
     229,   230,     0,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,   239,   240,   241,   242,     0,     0,
     243,   244,   245,     0,     0,   246,   247,     0,   248,   249,
     250,     0,     0,   251,     0,     0,     0,   252,     0,   253,
       0,   254,     0,   255,   256,   257,   258,   259,   260,   261,
       0,   262,     0,     0,     0,   263,   264,   265,     0,   266,
       0,     0,     0,   267,   268,     0,     0,     0,   269,   270,
     271,   272,   273,     0,     0,   274,   275,   276,     0,   277,
       0,   278,     0,     0,     0,     0,   279,   280,     0,     0,
       0,   281,     0,   282,   283,     0,   284,   285,     0,     0,
       0,   286,     0,     0,   287,   288,   289,     0,     0,   290,
       0,     0,   291,   292,     0,     0,     0,     0,     0,   293,
     294,     0,   295,     0,   296,     0,   297,   298,     0,     0,
       0,     0,     0,     0,     0,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,     0,   315,   316,   317,   318,     0,   319,   320,   321,
     322,     0,   323,   324,     0,     0,     0,     0,   325,   326,
     327,   328,   329,   330,     0,     0,   331,   332,     0,   333,
       0,   334,     0,   335,   336,   337,   338,   339,   340,   341,
     342,   343,     0,     0,   344,   345,     0,     0,   346,   347,
     348,   349,     0,     0,     0,   350,   351,     0,     0,     0,
     352,     0,   353,   354,   355,     0,   356,   357,   358,   359,
       0,   360,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,   363,   364,     0,     0,   365,     0,   366,     0,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,     0,   380,     0,   381,   382,
     383,   384,   385,     0,   386,   387,   388,     0,     0,   389,
       0,     0,     0,   390,   391,   392,   393,   394,     0,     0,
     395,   396,   397,   398,   399,     0,   400,   401,     0,   402,
     403,   404,     0,     0,   405,     0,   406,     0,   407,   408,
       0,   409,   410,     0,   411,     0,   412,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,     0,     0,   431,     0,     0,     0,   432,     0,
     433,   434,   435,   436,   437,   438,     0,   439,   440,   441,
     442,   443,   444,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,     0,     0,   448,     0,     0,   449,   450,
       0,     0,     0,   451,     0,     0,   452,   453,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,   461,   462,
     463,     0,   464,   465,     0,   466,     0,   467,   468,   469,
     470,     0,     0,   471,   472,     0,   473,   474,   475,   476,
       0,     0,     0,     0,     0,   477,   478,   479,     0,     0,
       0,   480,   481,   482,   483,     0,   484,   485,     0,   486,
     487,     0,   488,   489,     0,     0,   490,     0,     0,   491,
       0,   492,     0,   493,   494,   495,     0,     0,     0,     0,
       0,     0,   496,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,   503,   504,     0,     0,     0,     0,
       0,     0,   505,   506,     0,   507,   508,   509,     0,     0,
     510,     0,     0,     0,     0,     0,     0,  2385,   141,     0,
     142,   143,   144,   145,   146,   147,     0,     0,   148,     0,
     562,     0,   149,     0,     0,   150,     0,   151,   152,   153,
     154,   155,   156,   157,   158,     0,   159,     0,     0,     0,
     160,     0,     0,     0,   161,     0,     0,   162,   163,   164,
       0,   165,     0,   166,   167,     0,     0,   168,     0,     0,
     169,   170,     0,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,     0,   182,   183,   184,
     185,   186,   187,   188,     0,   189,   190,   191,   192,   193,
     194,   195,   196,     0,   197,   198,     0,   199,   200,   201,
     202,   203,     0,   204,     0,     0,   205,     0,     0,   206,
       0,   207,     0,     0,   208,     0,   209,     0,     0,     0,
     210,   211,   212,     0,     0,   213,     0,     0,     0,     0,
     214,   215,     0,     0,     0,     0,   216,     0,   217,     0,
       0,     0,   218,     0,   219,   220,   221,   222,   223,     0,
       0,     0,   224,     0,     0,   225,   226,   227,     0,     0,
       0,   228,     0,   229,   230,     0,   231,   232,   233,     0,
       0,   234,   235,     0,   236,   237,   238,   239,   240,   241,
     242,     0,     0,   243,   244,   245,     0,     0,   246,   247,
       0,   248,   249,   250,     0,     0,   251,     0,     0,     0,
     252,     0,   253,     0,   254,     0,   255,   256,   257,   258,
     259,   260,   261,     0,   262,     0,     0,     0,   263,   264,
     265,     0,   266,     0,     0,     0,   267,   268,     0,     0,
       0,   269,   270,   271,   272,   273,     0,     0,   274,   275,
     276,     0,   277,     0,   278,     0,     0,     0,     0,   279,
     280,     0,     0,     0,   281,     0,   282,   283,     0,   284,
     285,     0,     0,     0,   286,     0,     0,   287,   288,   289,
       0,     0,   290,     0,     0,   291,   292,     0,     0,     0,
       0,     0,   293,   294,     0,   295,     0,   296,     0,   297,
     298,     0,     0,     0,     0,     0,     0,     0,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,     0,   315,   316,   317,   318,     0,
     319,   320,   321,   322,     0,   323,   324,     0,     0,     0,
       0,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,   333,     0,   334,     0,   335,   336,   337,   338,
     339,   340,   341,   342,   343,     0,     0,   344,   345,     0,
       0,   346,   347,   348,   349,     0,     0,     0,   350,   351,
       0,     0,     0,   352,     0,   353,   354,   355,     0,   356,
     357,   358,   359,     0,   360,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,   363,   364,     0,     0,   365,
       0,   366,     0,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,     0,     0,   377,   378,   379,     0,   380,
       0,   381,   382,   383,   384,   385,     0,   386,   387,   388,
       0,     0,   389,     0,     0,     0,   390,   391,   392,   393,
     394,     0,     0,   395,   396,   397,   398,   399,     0,   400,
     401,     0,   402,   403,   404,     0,     0,   405,     0,   406,
       0,   407,   408,     0,   409,   410,     0,   411,     0,   412,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,     0,     0,     0,
     427,   428,   429,   430,     0,     0,     0,   431,     0,     0,
       0,   432,     0,   433,   434,   435,   436,   437,   438,     0,
     439,   440,   441,   442,   443,   444,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,     0,     0,   448,     0,
       0,   449,   450,     0,     0,     0,   451,     0,     0,   452,
     453,     0,   454,   455,   456,   457,   458,   459,     0,     0,
     460,   461,   462,   463,     0,   464,   465,     0,   466,     0,
     467,   468,   469,   470,     0,     0,   471,   472,     0,   473,
     474,   475,   476,     0,     0,     0,     0,     0,   477,   478,
     479,     0,     0,     0,   480,   481,   482,   483,     0,   484,
     485,     0,   486,   487,     0,   488,   489,     0,     0,   490,
       0,     0,   491,     0,   492,     0,   493,   494,   495,     0,
       0,     0,     0,     0,     0,   496,     0,     0,   497,     0,
       0,     0,   498,   499,   500,   501,   502,   503,   504,     0,
       0,     0,     0,     0,     0,   505,   506,     0,   507,   508,
     509,     0,     0,   510,     0,     0,     0,   141,     0,   142,
     143,   144,   145,   146,   147,  3068,     0,   148,     0,     0,
       0,   149,     0,  3069,   150,     0,   151,   152,   153,   154,
     155,   156,   157,   158,     0,   159,     0,     0,     0,   160,
       0,     0,     0,   161,     0,     0,   162,   163,   164,     0,
     165,     0,   166,   167,     0,     0,   168,     0,     0,   169,
     170,     0,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,   184,   185,
     186,   187,   188,     0,   189,   190,   191,   192,   193,   194,
     195,   196,     0,   197,   198,     0,   199,   200,   201,   202,
     203,     0,   204,     0,     0,   205,     0,     0,   206,     0,
     207,     0,     0,   208,     0,   209,     0,     0,     0,   210,
     211,   212,     0,     0,   213,     0,     0,     0,     0,   214,
     215,     0,     0,     0,     0,   216,     0,   217,     0,     0,
       0,   218,     0,   219,   220,   221,   222,   223,     0,     0,
       0,   224,     0,     0,   225,   226,   227,     0,     0,     0,
     228,     0,   229,   230,     0,   231,   232,   233,     0,     0,
     234,   235,     0,   236,   237,   238,   239,   240,   241,   242,
       0,     0,   243,   244,   245,     0,     0,   246,   247,     0,
     248,   249,   250,     0,     0,   251,     0,     0,     0,   252,
       0,   253,     0,   254,     0,   255,   256,   257,   258,   259,
     260,   261,     0,   262,     0,     0,     0,   263,   264,   265,
       0,   266,     0,     0,     0,   267,   268,     0,     0,     0,
     269,   270,   271,   272,   273,     0,     0,   274,   275,   276,
       0,   277,     0,   278,     0,     0,     0,     0,   279,   280,
       0,     0,     0,   281,     0,   282,   283,     0,   284,   285,
       0,     0,     0,   286,     0,     0,   287,   288,   289,     0,
       0,   290,     0,     0,   291,   292,     0,     0,     0,     0,
       0,   293,   294,     0,   295,     0,   296,     0,   297,   298,
       0,     0,     0,     0,     0,     0,     0,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,     0,   315,   316,   317,   318,     0,   319,
     320,   321,   322,     0,   323,   324,     0,     0,     0,     0,
     325,   326,   327,   328,   329,   330,     0,     0,   331,   332,
       0,   333,     0,   334,     0,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,   344,   345,     0,     0,
     346,   347,   348,   349,     0,     0,     0,   350,   351,     0,
       0,     0,   352,     0,   353,   354,   355,     0,   356,   357,
     358,   359,     0,   360,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,   363,   364,     0,     0,   365,     0,
     366,     0,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,     0,   380,     0,
     381,   382,   383,   384,   385,     0,   386,   387,   388,     0,
       0,   389,     0,     0,     0,   390,   391,   392,   393,   394,
       0,     0,   395,   396,   397,   398,   399,     0,   400,   401,
       0,   402,   403,   404,     0,     0,   405,     0,   406,     0,
     407,   408,     0,   409,   410,     0,   411,     0,   412,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,     0,     0,     0,   427,
     428,   429,   430,     0,     0,     0,   431,     0,     0,     0,
     432,     0,   433,   434,   435,   436,   437,   438,     0,   439,
     440,   441,   442,   443,   444,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,     0,     0,   448,     0,     0,
     449,   450,     0,     0,     0,   451,     0,     0,   452,   453,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
     461,   462,   463,     0,   464,   465,     0,   466,     0,   467,
     468,   469,   470,     0,     0,   471,   472,     0,   473,   474,
     475,   476,     0,     0,     0,     0,     0,   477,   478,   479,
       0,     0,     0,   480,   481,   482,   483,     0,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,   490,     0,
       0,   491,     0,   492,     0,   493,   494,   495,     0,     0,
       0,     0,     0,     0,   496,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,   503,   504,     0,     0,
       0,     0,     0,     0,   505,   506,     0,   507,   508,   509,
       0,     0,   510,     0,     0,     0,   141,     0,   142,   143,
     144,   145,   146,   147,     0,     0,   148,     0,     0,     0,
     149,  4765,   804,   150,     0,   151,   152,   153,   154,   155,
     156,   157,   158,     0,   159,     0,     0,     0,   160,     0,
       0,     0,   161,     0,     0,   162,   163,   164,     0,   165,
       0,   166,   167,     0,     0,   168,     0,     0,   169,   170,
       0,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,     0,   182,   183,   184,   185,   186,
     187,   188,     0,   189,   190,   191,   192,   193,   194,   195,
     196,     0,   197,   198,     0,   199,   200,   201,   202,   203,
       0,   204,     0,     0,   205,     0,     0,   206,     0,   207,
       0,     0,   208,     0,   209,     0,     0,     0,   210,   211,
     212,     0,     0,   213,     0,     0,     0,     0,   214,   215,
       0,     0,     0,     0,   216,     0,   217,     0,     0,     0,
     218,     0,   219,   220,   221,   222,   223,     0,     0,     0,
     224,     0,     0,   225,   226,   227,     0,     0,     0,   228,
       0,   229,   230,     0,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,   239,   240,   241,   242,     0,
       0,   243,   244,   245,     0,     0,   246,   247,     0,   248,
     249,   250,     0,     0,   251,     0,     0,     0,   252,     0,
     253,     0,   254,     0,   255,   256,   257,   258,   259,   260,
     261,     0,   262,     0,     0,     0,   263,   264,   265,     0,
     266,     0,     0,     0,   267,   268,     0,     0,     0,   269,
     270,   271,   272,   273,     0,     0,   274,   275,   276,     0,
     277,     0,   278,     0,     0,     0,     0,   279,   280,     0,
       0,     0,   281,     0,   282,   283,     0,   284,   285,     0,
       0,     0,   286,     0,     0,   287,   288,   289,     0,     0,
     290,     0,     0,   291,   292,     0,     0,     0,     0,     0,
     293,   294,     0,   295,     0,   296,     0,   297,   298,     0,
       0,     0,     0,     0,     0,     0,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,     0,   315,   316,   317,   318,     0,   319,   320,
     321,   322,     0,   323,   324,     0,     0,     0,     0,   325,
     326,   327,   328,   329,   330,     0,     0,   331,   332,     0,
     333,     0,   334,     0,   335,   336,   337,   338,   339,   340,
     341,   342,   343,     0,     0,   344,   345,     0,     0,   346,
     347,   348,   349,     0,     0,     0,   350,   351,     0,     0,
       0,   352,     0,   353,   354,   355,     0,   356,   357,   358,
     359,     0,   360,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,   363,   364,     0,     0,   365,     0,   366,
       0,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,     0,     0,   377,   378,   379,     0,   380,     0,   381,
     382,   383,   384,   385,     0,   386,   387,   388,     0,     0,
     389,     0,     0,     0,   390,   391,   392,   393,   394,     0,
       0,   395,   396,   397,   398,   399,     0,   400,   401,     0,
     402,   403,   404,     0,     0,   405,     0,   406,     0,   407,
     408,     0,   409,   410,     0,   411,     0,   412,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,     0,     0,     0,   427,   428,
     429,   430,     0,     0,     0,   431,     0,     0,     0,   432,
       0,   433,   434,   435,   436,   437,   438,     0,   439,   440,
     441,   442,   443,   444,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,     0,     0,   448,     0,     0,   449,
     450,     0,     0,     0,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,   461,
     462,   463,     0,   464,   465,     0,   466,     0,   467,   468,
     469,   470,     0,     0,   471,   472,     0,   473,   474,   475,
     476,     0,     0,     0,     0,     0,   477,   478,   479,     0,
       0,     0,   480,   481,   482,   483,     0,   484,   485,     0,
     486,   487,     0,   488,   489,     0,     0,   490,     0,     0,
     491,     0,   492,     0,   493,   494,   495,     0,     0,     0,
       0,     0,     0,   496,     0,     0,   497,     0,     0,     0,
     498,   499,   500,   501,   502,   503,   504,     0,     0,     0,
       0,     0,     0,   505,   506,     0,   507,   508,   509,     0,
       0,   510,     0,   141,     0,   142,   143,   144,   145,   146,
     147,     0,     0,   148,     0,     0,     0,   149,     0,     0,
     150,   562,   151,   152,   153,   154,   155,   156,   157,   158,
       0,   159,     0,     0,     0,   160,     0,     0,     0,   161,
       0,     0,   162,   163,   164,     0,   165,     0,   166,   167,
       0,     0,   168,     0,     0,   169,   170,     0,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,     0,   182,   183,   184,   185,   186,   187,   188,     0,
     189,   190,   191,   192,   193,   194,   195,   196,     0,   197,
     198,     0,   199,   200,   201,   202,   203,     0,   204,     0,
       0,   205,     0,     0,   206,     0,   207,     0,     0,   208,
       0,   209,     0,     0,     0,   210,   211,   212,     0,     0,
     213,     0,     0,     0,     0,   214,   215,     0,     0,     0,
       0,   216,     0,   217,     0,     0,     0,   218,     0,   219,
     220,   221,   222,   223,     0,     0,     0,   224,     0,     0,
     225,   226,   227,     0,     0,     0,   228,     0,   229,   230,
       0,   231,   232,   233,     0,     0,   234,   235,     0,   236,
     237,   238,   239,   240,   241,   242,     0,     0,   243,   628,
     245,     0,     0,   246,   247,     0,   248,   249,   250,     0,
       0,   251,     0,     0,     0,   252,     0,   253,     0,   254,
       0,   255,   256,   257,   258,   259,   260,   261,     0,   262,
       0,     0,     0,   263,   264,   265,     0,   266,     0,     0,
       0,   267,   268,     0,     0,     0,   269,   270,   271,   272,
     273,     0,     0,   274,   275,   276,     0,   277,     0,   278,
       0,     0,     0,     0,   279,   280,     0,     0,     0,   281,
       0,   282,   283,     0,   284,   285,     0,     0,     0,   286,
       0,     0,   287,   288,   289,     0,     0,   290,     0,     0,
     291,   292,     0,     0,     0,     0,     0,   293,   294,     0,
     295,     0,   296,     0,   297,   298,     0,     0,     0,     0,
       0,     0,     0,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,     0,
     315,   316,   317,   318,     0,   319,   320,   321,   322,     0,
     323,   324,     0,     0,     0,     0,   325,   326,   327,   328,
     329,   330,     0,     0,   331,   332,     0,   333,     0,   334,
       0,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,   344,   345,     0,     0,   346,   347,   348,   349,
       0,     0,     0,   350,   351,     0,     0,     0,   352,     0,
     353,   354,   355,     0,   356,   357,   358,   359,     0,   360,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
     363,   364,     0,     0,   365,     0,   366,     0,   629,   368,
     369,   370,   371,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,     0,   380,     0,   381,   382,   383,   384,
     385,     0,   386,   387,   388,     0,     0,   389,     0,     0,
       0,   390,   391,   392,   393,   394,     0,     0,   395,   396,
     397,   398,   399,     0,   400,   401,     0,   402,   403,   404,
       0,     0,   405,     0,   406,     0,   407,   408,     0,   409,
     410,     0,   411,     0,   412,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,     0,     0,     0,   427,   428,   429,   430,     0,
       0,     0,   431,     0,     0,     0,   432,     0,   433,   434,
     435,   436,   437,   438,     0,   439,   440,   441,   442,   443,
     444,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,     0,     0,   448,     0,     0,   449,   450,     0,     0,
       0,   451,     0,     0,   452,   453,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,   461,   462,   463,     0,
     464,   465,     0,   466,     0,   467,   468,   469,   470,     0,
       0,   471,   472,     0,   473,   474,   475,   476,     0,     0,
       0,     0,     0,   477,   478,   479,     0,     0,     0,   480,
     481,   482,   483,     0,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,   490,     0,     0,   491,     0,   492,
       0,   493,   494,   495,     0,     0,     0,     0,     0,     0,
     496,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,   503,   504,     0,     0,     0,     0,     0,     0,
     505,   506,     0,   507,   508,   509,     0,     0,   510,     0,
     141,     0,   142,   143,   144,   145,   146,   147,     0,     0,
     148,     0,     0,     0,   149,     0,     0,   150,   562,   151,
     152,   153,   154,   155,   156,   157,   158,     0,   159,     0,
       0,     0,   160,     0,     0,     0,   161,     0,     0,   162,
     163,   164,     0,   165,     0,   166,   167,     0,     0,   168,
       0,     0,   169,   170,     0,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,   184,   185,   186,   187,   188,     0,   189,   190,   191,
     192,   193,   194,   195,   196,     0,   197,   198,     0,   199,
     200,   201,   202,   203,     0,   204,     0,     0,   205,     0,
       0,   206,     0,   207,     0,     0,   208,     0,   209,     0,
       0,     0,   210,   211,   212,     0,     0,   213,     0,     0,
       0,     0,   214,   215,     0,     0,     0,     0,   216,     0,
     217,     0,     0,     0,   218,     0,   219,   220,   221,   222,
     223,     0,     0,     0,   224,     0,     0,   225,   226,   227,
       0,     0,     0,   228,     0,   229,   230,     0,   231,   232,
     233,     0,     0,   234,   235,     0,   236,   237,   238,   239,
     240,   241,   242,     0,     0,   243,   244,   245,     0,     0,
     246,   247,     0,   248,   249,   250,     0,     0,   251,     0,
       0,     0,   252,     0,   253,     0,   254,     0,   255,   256,
     257,   258,   259,   260,   261,     0,   262,     0,     0,     0,
     263,   264,   265,     0,   266,     0,     0,     0,   267,   268,
       0,     0,     0,   269,   270,   271,   272,   273,     0,     0,
     274,   275,   276,     0,   277,     0,   278,     0,     0,     0,
       0,   279,   280,     0,     0,     0,   281,     0,   282,   283,
       0,   284,   285,     0,     0,     0,   286,     0,     0,   287,
     288,   289,     0,     0,   290,     0,     0,   291,   292,     0,
       0,     0,     0,     0,   293,   294,     0,   295,     0,   296,
       0,   297,   298,     0,     0,     0,     0,     0,     0,     0,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,     0,   315,   316,   317,
     318,     0,   319,   320,   321,   322,     0,   323,   324,     0,
       0,     0,     0,   325,   326,   327,   328,   329,   330,     0,
       0,   331,   332,     0,   333,     0,   334,     0,   335,   336,
     337,   338,   339,   340,   341,   342,   343,     0,     0,   344,
     345,     0,     0,   346,   347,   348,   349,     0,     0,     0,
     350,   351,     0,     0,     0,   352,     0,   353,   354,   355,
       0,   356,   357,   358,   359,     0,   360,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,   363,   364,     0,
       0,   365,     0,   366,     0,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
       0,   380,     0,   381,   382,   383,   384,   385,     0,   386,
     387,   388,     0,     0,   389,     0,     0,     0,   390,   391,
     392,   393,   394,     0,     0,   395,   396,   397,   398,   399,
       0,   400,   401,     0,   402,   403,   404,     0,     0,   405,
       0,   406,     0,   407,   408,     0,   409,   410,     0,   411,
       0,   412,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,     0,     0,   431,
       0,     0,     0,   432,     0,   433,   434,   435,   436,   437,
     438,     0,   439,   440,   441,   442,   443,   444,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,     0,     0,
     448,     0,     0,   449,   450,     0,     0,     0,   451,     0,
       0,   452,   453,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,   461,   462,   463,     0,   464,   465,     0,
     466,     0,   467,   468,   469,   470,     0,     0,   471,   472,
       0,   473,   474,   475,   476,     0,     0,     0,     0,     0,
     477,   478,   479,     0,     0,     0,   480,   481,   482,   483,
       0,   484,   485,     0,   486,   487,     0,   488,   489,     0,
       0,   490,     0,     0,   491,     0,   492,     0,   493,   494,
     495,     0,     0,     0,     0,     0,     0,   496,     0,     0,
     497,     0,     0,     0,   498,   499,   500,   501,   502,   503,
     504,     0,     0,     0,     0,     0,     0,   505,   506,     0,
     507,   508,   509,     0,     0,   510,     0,   141,     0,   142,
     143,   144,   145,   146,   147,     0,     0,   148,     0,     0,
       0,   149,     0,     0,   150,   804,   151,   152,   153,   154,
     155,   156,   157,   158,     0,   159,     0,     0,     0,   160,
       0,     0,     0,   161,     0,     0,   162,   163,   164,     0,
     165,     0,   166,   167,     0,     0,   168,     0,     0,   169,
     170,     0,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,   184,   185,
     186,   187,   188,     0,   189,   190,   191,   192,   193,   194,
     195,   196,     0,   197,   198,     0,   199,   200,   201,   202,
     203,     0,   204,     0,     0,   205,     0,     0,   206,     0,
     207,     0,     0,   208,     0,   209,     0,     0,     0,   210,
     211,   212,     0,     0,   213,     0,     0,     0,     0,   214,
     215,     0,     0,     0,     0,   216,     0,   217,     0,     0,
       0,   218,     0,   219,   220,   221,   222,   223,     0,     0,
       0,   224,     0,     0,   225,   226,   227,     0,     0,     0,
     228,     0,   229,   230,     0,   231,   232,   233,     0,     0,
     234,   235,     0,   236,   237,   238,   239,   240,   241,   242,
       0,     0,   243,   244,   245,     0,     0,   246,   247,     0,
     248,   249,   250,     0,     0,   251,     0,     0,     0,   252,
       0,   253,     0,   254,     0,   255,   256,   257,   258,   259,
     260,   261,     0,   262,     0,     0,     0,   263,   264,   265,
       0,   266,     0,     0,     0,   267,   268,     0,     0,     0,
     269,   270,   271,   272,   273,     0,     0,   274,   275,   276,
       0,   277,     0,   278,     0,     0,     0,     0,   279,   280,
       0,     0,     0,   281,     0,   282,   283,     0,   284,   285,
       0,     0,     0,   286,     0,     0,   287,   288,   289,     0,
       0,   290,     0,     0,   291,   292,     0,     0,     0,     0,
       0,   293,   294,     0,   295,     0,   296,     0,   297,   298,
       0,     0,     0,     0,     0,     0,     0,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,     0,   315,   316,   317,   318,     0,   319,
     320,   321,   322,     0,   323,   324,     0,     0,     0,     0,
     325,   326,   327,   328,   329,   330,     0,     0,   331,   332,
       0,   333,     0,   334,     0,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,   344,   345,     0,     0,
     346,   347,   348,   349,     0,     0,     0,   350,   351,     0,
       0,     0,   352,     0,   353,   354,   355,     0,   356,   357,
     358,   359,     0,   360,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,   363,   364,     0,     0,   365,     0,
     366,     0,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,     0,   380,     0,
     381,   382,   383,   384,   385,     0,   386,   387,   388,     0,
       0,   389,     0,     0,     0,   390,   391,   392,   393,   394,
       0,     0,   395,   396,   397,   398,   399,     0,   400,   401,
       0,   402,   403,   404,     0,     0,   405,     0,   406,     0,
     407,   408,     0,   409,   410,     0,   411,     0,   412,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,     0,     0,     0,   427,
     428,   429,   430,     0,     0,     0,   431,     0,     0,     0,
     432,     0,   433,   434,   435,   436,   437,   438,     0,   439,
     440,   441,   442,   443,   444,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,     0,     0,   448,     0,     0,
     449,   450,     0,     0,     0,   451,     0,     0,   452,   453,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
     461,   462,   463,     0,   464,   465,     0,   466,     0,   467,
     468,   469,   470,     0,     0,   471,   472,     0,   473,   474,
     475,   476,     0,     0,     0,     0,     0,   477,   478,   479,
       0,     0,     0,   480,   481,   482,   483,     0,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,   490,     0,
       0,   491,     0,   492,     0,   493,   494,   495,     0,     0,
       0,     0,     0,     0,   496,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,   503,   504,     0,     0,
       0,     0,     0,     0,   505,   506,     0,   507,   508,   509,
       0,     0,   510,     0,   141,     0,   142,   143,   144,   145,
     146,   147,     0,     0,   148,     0,     0,     0,   149,     0,
       0,   150,  3069,   151,   152,   153,   154,   155,   156,   157,
     158,     0,   159,     0,     0,     0,   160,     0,     0,     0,
     161,     0,     0,   162,   163,   164,     0,   165,     0,   166,
     167,     0,     0,   168,     0,     0,   169,   170,     0,   171,
     946,   947,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,     0,   182,   183,   184,   185,   186,   187,   188,
       0,   189,   190,   191,   192,   193,   194,   195,   196,     0,
     197,   198,     0,   199,   200,   201,   202,   203,     0,   204,
       0,     0,   205,     0,     0,   206,     0,   207,     0,     0,
     208,     0,   209,     0,     0,     0,   210,   211,   212,     0,
       0,   213,     0,     0,     0,     0,   214,   215,     0,     0,
       0,   948,   216,     0,   217,     0,     0,     0,   218,     0,
     219,   220,   221,   222,   223,     0,     0,     0,   224,     0,
       0,   225,   226,   227,     0,     0,     0,   228,     0,   229,
     230,     0,   231,   232,   233,     0,     0,   234,   235,     0,
     236,   237,   238,   239,   240,   241,   242,     0,     0,   243,
     244,   245,     0,     0,   246,   247,     0,   248,   249,   250,
       0,     0,   251,     0,     0,     0,   252,     0,   253,     0,
     254,     0,   255,   256,   257,   258,   259,   260,   949,     0,
     262,     0,     0,     0,   263,   264,   265,     0,   266,     0,
       0,     0,   267,   268,     0,     0,     0,   269,   270,   271,
     272,   273,     0,     0,   274,   275,   276,     0,   277,     0,
     278,     0,     0,     0,     0,   279,   280,     0,     0,     0,
     281,     0,   282,   283,     0,   284,   285,     0,     0,     0,
     286,     0,     0,   287,   288,   289,     0,     0,   290,     0,
       0,   291,   292,     0,     0,     0,     0,     0,   293,   294,
       0,   950,     0,   296,     0,   297,   298,     0,     0,     0,
       0,     0,     0,     0,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
       0,   315,   316,   317,   318,     0,   319,   320,   321,   322,
       0,   323,   324,     0,     0,     0,     0,   325,   326,   327,
     328,   329,   330,     0,     0,   331,   332,     0,   333,     0,
     334,     0,   335,   336,   337,   338,   339,   340,   951,   342,
     343,     0,     0,   344,   345,     0,     0,   346,   347,   348,
     349,     0,     0,     0,   350,   351,     0,     0,     0,   352,
       0,   353,   354,   355,     0,   356,   357,   358,   359,     0,
     360,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,   363,   364,     0,     0,   365,     0,   366,     0,   367,
     368,   952,   370,   371,   372,   373,   374,   375,   376,     0,
       0,   377,   378,   379,     0,   380,     0,   381,   382,   383,
     384,   385,     0,   386,   387,   388,     0,     0,   389,     0,
       0,     0,   390,   391,   392,   393,   394,     0,     0,   395,
     396,   397,   398,   399,     0,   400,   401,     0,   402,   403,
     404,     0,     0,   405,     0,   406,     0,   407,   408,     0,
     409,   410,     0,   411,     0,   412,     0,     0,   953,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,     0,     0,     0,   427,   428,   954,   430,
       0,     0,     0,   431,     0,     0,     0,   432,     0,   433,
     434,   435,   436,   437,   438,     0,   439,   440,   441,   442,
     443,   444,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,     0,     0,   448,     0,     0,   449,   450,     0,
       0,     0,   451,     0,     0,   452,   453,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,   461,   462,   463,
       0,   464,   465,     0,   466,     0,   467,   468,   469,   470,
       0,     0,   471,   472,     0,   473,   474,   475,   476,     0,
       0,     0,     0,     0,   955,   478,   479,     0,     0,     0,
     480,   481,   482,   483,     0,   484,   485,     0,   486,   487,
       0,   488,   489,     0,     0,   490,     0,     0,   491,     0,
     492,     0,   493,   494,   495,     0,     0,     0,     0,     0,
       0,   496,     0,     0,   497,     0,     0,     0,   498,   499,
     500,   501,   502,   503,   504,     0,     0,     0,     0,     0,
       0,   505,   506,     0,   507,   508,   509,     0,     0,   510,
     141,     0,   142,   143,   144,   145,   146,   147,     0,     0,
     148,     0,     0,     0,   149,     0,     0,   150,   956,   151,
     152,   153,   154,   155,   156,   157,   158,     0,   159,     0,
       0,     0,   160,     0,     0,     0,   161,     0,     0,   162,
     163,   164,     0,   165,     0,   166,   167,     0,     0,   168,
       0,     0,   169,   170,     0,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,   184,   185,   186,   187,   188,     0,   189,   190,   191,
     192,   193,   194,   195,   196,     0,   197,   198,     0,   199,
     200,   201,   202,   203,     0,   204,     0,     0,   205,     0,
       0,   206,     0,   207,     0,     0,   208,     0,   209,     0,
       0,     0,   210,   211,   212,     0,     0,   213,     0,     0,
       0,     0,   214,   215,     0,     0,     0,     0,   216,     0,
     217,     0,     0,     0,   218,     0,   219,   220,   221,   222,
     223,     0,     0,     0,   224,     0,     0,   225,   226,   227,
       0,     0,     0,   228,     0,   229,   230,     0,   231,   232,
     233,     0,     0,   234,   235,     0,   236,   237,   238,   239,
     240,   241,   242,     0,     0,   243,   244,   245,     0,     0,
     246,   247,     0,   248,   249,   250,     0,     0,   251,     0,
       0,     0,   252,     0,   253,     0,   254,     0,   255,   256,
     257,   258,   259,   260,   261,     0,   262,     0,     0,     0,
     263,   264,   265,     0,   266,     0,     0,     0,   267,   268,
       0,     0,     0,   269,   270,   271,   272,   273,     0,     0,
     274,   275,   276,     0,   277,     0,   278,     0,     0,     0,
       0,   279,   280,     0,     0,     0,   281,     0,   282,   283,
       0,   284,   285,     0,     0,     0,   286,     0,     0,   287,
     288,   289,     0,     0,   290,     0,     0,   291,   292,   640,
       0,     0,     0,     0,   293,   294,     0,   295,     0,   296,
       0,   297,   298,     0,     0,     0,     0,     0,     0,     0,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,     0,   315,   316,   317,
     318,     0,   319,   320,   321,   322,     0,   323,   324,     0,
       0,     0,     0,   325,   326,   327,   328,   329,   330,     0,
       0,   331,   332,     0,   333,     0,   334,     0,   335,   336,
     337,   338,   339,   340,   341,   342,   343,     0,     0,   344,
     345,     0,     0,   346,   347,   348,   349,     0,     0,     0,
     350,   351,     0,     0,     0,   352,     0,   353,   354,   355,
       0,   356,   357,   358,   359,     0,   360,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,   363,   364,     0,
       0,   365,     0,   366,     0,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
       0,   380,     0,   381,   382,   383,   384,   385,     0,   386,
     387,   388,     0,     0,   389,     0,     0,     0,   390,   391,
     392,   393,   394,     0,     0,   395,   396,   397,   398,   399,
       0,   400,   401,     0,   402,   403,   404,     0,     0,   405,
       0,   406,     0,   407,   408,     0,   409,   410,     0,   411,
       0,   412,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,     0,     0,   431,
       0,     0,     0,   432,     0,   433,   434,   435,   436,   437,
     438,     0,   439,   440,   441,   442,   443,   444,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,     0,     0,
     448,     0,     0,   449,   450,     0,     0,     0,   451,     0,
       0,   452,   453,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,   461,   462,   463,     0,   464,   465,     0,
     466,     0,   467,   468,   469,   470,     0,   138,   471,   472,
       0,   473,   474,   475,   476,     0,     0,     0,     0,     0,
     477,   478,   479,     0,     0,     0,   480,   481,   482,   483,
       0,   484,   485,     0,   486,   487,     0,   488,   489,     0,
       0,   490,     0,     0,   491,     0,   492,     0,   493,   494,
     495,     0,     0,     0,     0,     0,     0,   496,     0,     0,
     497,     0,     0,     0,   498,   499,   500,   501,   502,   503,
     504,     0,     0,     0,     0,     0,     0,   505,   506,     0,
     507,   508,   509,     0,     0,   510,   141,     0,   142,   143,
     144,   145,   146,   147,     0,     0,   148,     0,     0,     0,
     149,     0,     0,   150,  1456,   151,   152,   153,   154,   155,
     156,   157,   158,     0,   159,     0,     0,     0,   160,     0,
       0,     0,   161,     0,     0,   162,   163,   164,     0,   165,
       0,   166,   167,     0,     0,   168,     0,     0,   169,   170,
       0,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,     0,   182,   183,   184,   185,   186,
     187,   188,     0,   189,   190,   191,   192,   193,   194,   195,
     196,     0,   197,   198,     0,   199,   200,   201,   202,   203,
       0,   204,     0,     0,   205,     0,     0,   206,     0,   207,
       0,     0,   208,     0,   209,     0,     0,     0,   210,   211,
     212,     0,     0,   213,     0,     0,     0,     0,   214,   215,
       0,     0,     0,     0,   216,     0,   217,     0,     0,     0,
     218,     0,   219,   220,   221,   222,   223,     0,     0,     0,
     224,     0,     0,   225,   226,   227,     0,     0,     0,   228,
       0,   229,   230,     0,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,   239,   240,   241,   242,     0,
       0,   243,   244,   245,     0,     0,   246,   247,     0,   248,
     249,   250,     0,     0,   251,     0,     0,     0,   252,     0,
     253,     0,   254,     0,   255,   256,   257,   258,   259,   260,
     261,     0,   262,     0,     0,     0,   263,   264,   265,     0,
     266,     0,     0,     0,   267,   268,     0,     0,     0,   269,
     270,   271,   272,   273,     0,     0,   274,   275,   276,     0,
     277,     0,   278,     0,     0,     0,     0,   279,   280,     0,
       0,     0,   281,     0,   282,   283,     0,   284,   285,     0,
       0,     0,   286,     0,     0,   287,   288,   289,     0,     0,
     290,     0,     0,   291,   292,   640,     0,     0,     0,     0,
     293,   294,     0,   295,     0,   296,     0,   297,   298,     0,
       0,     0,     0,     0,     0,     0,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,     0,   315,   316,   317,   318,     0,   319,   320,
     321,   322,     0,   323,   324,     0,     0,     0,     0,   325,
     326,   327,   328,   329,   330,     0,     0,   331,   332,     0,
     333,     0,   334,     0,   335,   336,   337,   338,   339,   340,
     341,   342,   343,     0,     0,   344,   345,     0,     0,   346,
     347,   348,   349,     0,     0,     0,   350,   351,     0,     0,
       0,   352,     0,   353,   354,   355,     0,   356,   357,   358,
     359,     0,   360,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,   363,   364,     0,     0,   365,     0,   366,
       0,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,     0,     0,   377,   378,   379,     0,   380,     0,   381,
     382,   383,   384,   385,     0,   386,   387,   388,     0,     0,
     389,     0,     0,     0,   390,   391,   392,   393,   394,     0,
       0,   395,   396,   397,   398,   399,     0,   400,   401,     0,
     402,   403,   404,     0,     0,   405,     0,   406,     0,   407,
     408,     0,   409,   410,     0,   411,     0,   412,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,     0,     0,     0,   427,   428,
     429,   430,     0,     0,     0,   431,     0,     0,     0,   432,
       0,   433,   434,   435,   436,   437,   438,     0,   439,   440,
     441,   442,   443,   444,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,     0,     0,   448,     0,     0,   449,
     450,     0,     0,     0,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,   461,
     462,   463,     0,   464,   465,     0,   466,     0,   467,   468,
     469,   470,     0,   138,   471,   472,     0,   473,   474,   475,
     476,     0,     0,     0,     0,     0,   477,   478,   479,     0,
       0,     0,   480,   481,   482,   483,     0,   484,   485,     0,
     486,   487,     0,   488,   489,     0,     0,   490,     0,     0,
     491,     0,   492,     0,   493,   494,   495,     0,     0,     0,
       0,     0,     0,   496,     0,     0,   497,     0,     0,     0,
     498,   499,   500,   501,   502,   503,   504,     0,     0,     0,
       0,     0,     0,   505,   506,     0,   507,   508,   509,     0,
       0,   510,   141,     0,   142,   143,   144,   145,   146,   147,
       0,     0,   148,     0,     0,     0,   149,     0,     0,   150,
    1790,   151,   152,   153,   154,   155,   156,   157,   158,     0,
     159,     0,     0,     0,   160,     0,     0,     0,   161,     0,
       0,   162,   163,   164,     0,   165,     0,   166,   167,     0,
       0,   168,     0,     0,   169,   170,     0,   171,   946,   947,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,   184,   185,   186,   187,   188,     0,   189,
     190,   191,   192,   193,   194,   195,   196,     0,   197,   198,
       0,   199,   200,   201,   202,   203,     0,   204,     0,     0,
     205,     0,     0,   206,     0,   207,     0,     0,   208,     0,
     209,     0,     0,     0,   210,   211,   212,     0,     0,   213,
       0,     0,     0,     0,   214,   215,     0,     0,     0,   948,
     216,     0,   217,     0,     0,     0,   218,     0,   219,   220,
     221,   222,   223,     0,     0,     0,   224,     0,     0,   225,
     226,   227,     0,     0,     0,   228,     0,   229,   230,     0,
     231,   232,   233,     0,     0,   234,   235,     0,   236,   237,
     238,   239,   240,   241,   242,     0,     0,   243,   244,   245,
       0,     0,   246,   247,     0,   248,   249,   250,     0,     0,
     251,     0,     0,     0,   252,     0,   253,     0,   254,     0,
     255,   256,   257,   258,   259,   260,   949,     0,   262,     0,
       0,     0,   263,   264,   265,     0,   266,     0,     0,     0,
     267,   268,     0,     0,     0,   269,   270,   271,   272,   273,
       0,     0,   274,   275,   276,     0,   277,     0,   278,     0,
       0,     0,     0,   279,   280,     0,     0,     0,   281,     0,
     282,   283,     0,   284,   285,     0,     0,     0,   286,     0,
       0,   287,   288,   289,     0,     0,   290,     0,     0,   291,
     292,     0,     0,     0,     0,     0,   293,   294,     0,   950,
       0,   296,     0,   297,   298,     0,     0,     0,     0,     0,
       0,     0,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,     0,   315,
     316,   317,   318,     0,   319,   320,   321,   322,     0,   323,
     324,     0,     0,     0,     0,   325,   326,   327,   328,   329,
     330,     0,     0,   331,   332,     0,   333,     0,   334,     0,
     335,   336,   337,   338,   339,   340,   951,   342,   343,     0,
       0,   344,   345,     0,     0,   346,   347,   348,   349,     0,
       0,     0,   350,   351,     0,     0,     0,   352,     0,   353,
     354,   355,     0,   356,   357,   358,   359,     0,   360,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,   363,
     364,     0,     0,   365,     0,   366,     0,   367,   368,   952,
     370,   371,   372,   373,   374,   375,   376,     0,     0,   377,
     378,   379,     0,   380,     0,   381,   382,   383,   384,   385,
       0,   386,   387,   388,     0,     0,   389,     0,     0,     0,
     390,   391,   392,   393,   394,     0,     0,   395,   396,   397,
     398,   399,     0,   400,   401,     0,   402,   403,   404,     0,
       0,   405,     0,   406,     0,   407,   408,     0,   409,   410,
       0,   411,     0,   412,     0,     0,   953,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,     0,     0,     0,   427,   428,   954,   430,     0,     0,
       0,   431,     0,     0,     0,   432,     0,   433,   434,   435,
     436,   437,   438,     0,   439,   440,   441,   442,   443,   444,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
       0,     0,   448,     0,     0,   449,   450,     0,     0,     0,
     451,     0,     0,   452,   453,     0,   454,   455,   456,   457,
     458,   459,     0,     0,   460,   461,   462,   463,     0,   464,
     465,     0,   466,     0,   467,   468,   469,   470,     0,     0,
     471,   472,     0,   473,   474,   475,   476,     0,     0,     0,
       0,     0,   477,   478,   479,     0,     0,     0,   480,   481,
     482,   483,     0,   484,   485,     0,   486,   487,     0,   488,
     489,     0,     0,   490,     0,     0,   491,     0,   492,     0,
     493,   494,   495,     0,     0,     0,     0,     0,     0,   496,
       0,     0,   497,     0,     0,     0,   498,   499,   500,   501,
     502,   503,   504,     0,     0,     0,     0,     0,     0,   505,
     506,     0,   507,   508,   509,     0,     0,   510,   141,     0,
     142,   143,   144,   145,   146,   147,     0,     0,   148,     0,
       0,     0,   149,     0,     0,   150,   956,   151,   152,   153,
     154,   155,   156,   157,   158,     0,   159,     0,     0,     0,
     160,     0,     0,     0,   161,     0,     0,   162,   163,   164,
       0,   165,     0,   166,   167,     0,     0,   168,     0,     0,
     169,   170,     0,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,     0,   182,   183,   184,
     185,   186,   187,   188,     0,   189,   190,   191,   192,   193,
     194,   195,   196,     0,   197,   198,     0,   199,   200,   201,
     202,   203,     0,   204,     0,     0,   205,     0,     0,   206,
       0,   207,     0,     0,   208,     0,   209,     0,     0,     0,
     210,   211,   212,     0,     0,   213,     0,     0,     0,     0,
     214,   215,     0,     0,     0,     0,   216,     0,   217,     0,
       0,     0,   218,     0,   219,   220,   221,   222,   223,     0,
       0,     0,   224,     0,     0,   225,   226,   227,     0,     0,
       0,   228,     0,   229,   230,     0,   231,   232,   233,     0,
       0,   234,   235,     0,   236,   237,   238,   239,   240,   241,
     242,     0,     0,   243,   244,   245,     0,     0,   246,   247,
       0,   248,   249,   250,     0,     0,   251,     0,     0,     0,
     252,     0,   253,     0,   254,     0,   255,   256,   257,   258,
     259,   260,   261,     0,   262,     0,     0,     0,   263,   264,
     265,     0,   266,     0,     0,     0,   267,   268,     0,     0,
       0,   269,   270,   271,   272,   273,     0,     0,   274,   275,
     276,     0,   277,     0,   278,     0,     0,     0,     0,   279,
     280,     0,     0,     0,   281,     0,   282,   283,     0,   284,
     285,     0,     0,     0,   286,     0,     0,   287,   288,   289,
       0,     0,   290,     0,     0,   291,   292,   640,     0,     0,
       0,     0,   293,   294,     0,   295,     0,   296,     0,   297,
     298,     0,     0,     0,     0,     0,     0,     0,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,     0,   315,   316,   317,   318,     0,
     319,   320,   321,   322,     0,   323,   324,     0,     0,     0,
       0,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,   333,     0,   334,     0,   335,   336,   337,   338,
     339,   340,   341,   342,   343,     0,     0,   344,   345,     0,
       0,   346,   347,   348,   349,     0,     0,     0,   350,   351,
       0,     0,     0,   352,     0,   353,   354,   355,     0,   356,
     357,   358,   359,     0,   360,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,   363,   364,     0,     0,   365,
       0,   366,     0,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,     0,     0,   377,   378,   379,     0,   380,
       0,   381,   382,   383,   384,   385,     0,   386,   387,   388,
       0,     0,   389,     0,     0,     0,   390,   391,   392,   393,
     394,     0,     0,   395,   396,   397,   398,   399,     0,   400,
     401,     0,   402,   403,   404,     0,     0,   405,     0,   406,
       0,   407,   408,     0,   409,   410,     0,   411,     0,   412,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,     0,     0,     0,
     427,   428,   429,   430,     0,     0,     0,   431,     0,     0,
       0,   432,     0,   433,   434,   435,   436,   437,   438,     0,
     439,   440,   441,   442,   443,   444,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,     0,     0,   448,     0,
       0,   449,   450,     0,     0,     0,   451,     0,     0,   452,
     453,     0,   454,   455,   456,   457,   458,   459,     0,     0,
     460,   461,   462,   463,     0,   464,   465,     0,   466,     0,
     467,   468,   469,   470,     0,   138,   471,   472,     0,   473,
     474,   475,   476,     0,     0,     0,     0,     0,   477,   478,
     479,     0,     0,     0,   480,   481,   482,   483,     0,   484,
     485,     0,   486,   487,     0,   488,   489,     0,     0,   490,
       0,     0,   491,     0,   492,     0,   493,   494,   495,     0,
       0,     0,     0,     0,     0,   496,     0,     0,   497,     0,
       0,     0,   498,   499,   500,   501,   502,   503,   504,     0,
       0,     0,     0,     0,     0,   505,   506,     0,   507,   508,
     509,     0,     0,   510,   141,     0,   142,   143,   144,   145,
     146,   147,     0,     0,   148,     0,     0,     0,   149,     0,
       0,   150,  3643,   151,   152,   153,   154,   155,   156,   157,
     158,     0,   159,     0,     0,     0,   160,     0,     0,     0,
     161,     0,     0,   162,   163,   164,     0,   165,     0,   166,
     167,     0,     0,   168,     0,     0,   169,   170,     0,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,     0,   182,   183,   184,   185,   186,   187,   188,
       0,   189,   190,   191,   192,   193,   194,   195,   196,  1336,
     197,   198,     0,   199,   200,   201,   202,   203,     0,   204,
       0,     0,   205,     0,     0,   206,     0,   207,     0,     0,
     208,     0,   209,     0,     0,     0,   210,   211,   212,     0,
       0,   213,     0,     0,     0,     0,   214,   215,     0,     0,
       0,     0,   216,     0,   217,     0,     0,     0,   218,     0,
     219,   220,   221,   222,   223,     0,     0,     0,   224,     0,
       0,   225,   226,   227,     0,     0,     0,   228,     0,   229,
     230,     0,   231,   232,   233,     0,     0,   234,   235,     0,
     236,   237,   238,   239,   240,   241,   242,     0,     0,   243,
     244,   245,     0,     0,   246,   247,     0,   248,   249,   250,
       0,     0,   251,     0,     0,     0,   252,     0,   253,     0,
     254,     0,   255,   256,   257,   258,   259,   260,   261,     0,
     262,     0,     0,     0,   263,   264,   265,     0,   266,     0,
       0,     0,   267,   268,     0,     0,     0,   269,   270,   271,
     272,   273,     0,     0,   274,   275,   276,     0,   277,     0,
     278,     0,     0,     0,     0,   279,   280,     0,     0,     0,
     281,     0,   282,   283,     0,   284,   285,     0,     0,     0,
     286,     0,     0,   287,   288,   289,     0,     0,   290,     0,
       0,   291,   292,     0,     0,     0,     0,     0,   293,   294,
       0,   295,     0,   296,     0,   297,   298,     0,     0,     0,
       0,     0,     0,     0,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
       0,   315,   316,   317,   318,     0,   319,   320,   321,   322,
       0,   323,   324,     0,     0,     0,     0,   325,   326,   327,
     328,   329,   330,     0,     0,   331,   332,     0,   333,     0,
     334,     0,   335,   336,   337,   338,   339,   340,   341,   342,
     343,     0,     0,   344,   345,     0,     0,   346,   347,   348,
     349,     0,     0,     0,   350,   351,     0,     0,     0,   352,
       0,   353,   354,   355,     0,   356,   357,   358,   359,     0,
     360,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,   363,   364,     0,     0,   365,     0,   366,     0,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,     0,
       0,   377,   378,   379,     0,   380,     0,   381,   382,   383,
     384,   385,     0,   386,   387,   388,     0,     0,   389,     0,
       0,     0,   390,   391,   392,   393,   394,     0,     0,   395,
     396,   397,   398,   399,     0,   400,   401,     0,   402,   403,
     404,     0,     0,   405,     0,   406,     0,   407,   408,     0,
     409,   410,     0,   411,     0,   412,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,     0,     0,     0,   427,   428,   429,   430,
       0,     0,     0,   431,     0,     0,     0,   432,     0,   433,
     434,   435,   436,   437,   438,     0,   439,   440,   441,   442,
     443,   444,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,     0,     0,   448,     0,     0,   449,   450,     0,
       0,     0,   451,     0,     0,   452,   453,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,   461,   462,   463,
       0,   464,   465,     0,   466,     0,   467,   468,   469,   470,
       0,     0,   471,   472,     0,   473,   474,   475,   476,     0,
       0,     0,     0,     0,   477,   478,   479,     0,     0,     0,
     480,   481,   482,   483,     0,   484,   485,     0,   486,   487,
       0,   488,   489,     0,     0,   490,     0,     0,   491,     0,
     492,     0,   493,   494,   495,     0,     0,     0,     0,     0,
       0,   496,     0,     0,   497,     0,     0,     0,   498,   499,
     500,   501,   502,   503,   504,     0,     0,     0,     0,     0,
       0,   505,   506,     0,   507,   508,   509,     0,     0,   510,
     141,     0,   142,   143,   144,   145,   146,   147,     0,     0,
     148,     0,     0,     0,   149,     0,     0,   150,  1337,   151,
     152,   153,   154,   155,   156,   157,   158,     0,   159,     0,
       0,     0,   160,     0,     0,     0,   161,     0,     0,   162,
     163,   164,     0,   165,     0,   166,   167,     0,     0,   168,
       0,     0,   169,   170,     0,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,   184,   185,   186,   187,   188,     0,   189,   190,   191,
     192,   193,   194,   195,   196,     0,   197,   198,     0,   199,
     200,   201,   202,   203,     0,   204,     0,     0,   205,     0,
       0,   206,     0,   207,     0,     0,   208,     0,   209,     0,
       0,     0,   210,   211,   212,     0,     0,   213,     0,     0,
       0,     0,   214,   215,     0,     0,     0,     0,   216,     0,
     217,     0,     0,     0,   218,     0,   219,   220,   221,   222,
     223,     0,     0,     0,   224,     0,     0,   225,   226,   227,
       0,     0,     0,   228,     0,   229,   230,     0,   231,   232,
     233,     0,     0,   234,   235,     0,   236,   237,   238,   239,
     240,   241,   242,     0,     0,   243,   244,   245,     0,     0,
     246,   247,     0,   248,   249,   250,     0,     0,   251,     0,
       0,     0,   252,     0,   253,     0,   254,     0,   255,   256,
     257,   258,   259,   260,   261,     0,   262,     0,     0,     0,
     263,   264,   265,     0,   266,     0,     0,     0,   267,   268,
       0,     0,     0,   269,   270,   271,   272,   273,     0,     0,
     274,   275,   276,     0,   277,     0,   278,     0,     0,     0,
       0,   279,   280,     0,     0,     0,   281,     0,   282,   283,
       0,   284,   285,     0,     0,     0,   286,     0,     0,   287,
     288,   289,     0,     0,   290,     0,     0,   291,   292,     0,
       0,     0,     0,     0,   293,   294,     0,   295,     0,   296,
       0,   297,   298,     0,     0,     0,     0,     0,     0,     0,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,     0,   315,   316,   317,
     318,     0,   319,   320,   321,   322,     0,   323,   324,     0,
       0,     0,     0,   325,   326,   327,   328,   329,   330,     0,
       0,   331,   332,     0,   333,     0,   334,     0,   335,   336,
     337,   338,   339,   340,   341,   342,   343,     0,     0,   344,
     345,     0,     0,   346,   347,   348,   349,     0,     0,     0,
     350,   351,     0,     0,     0,   352,     0,   353,   354,   355,
       0,   356,   357,   358,   359,     0,   360,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,   363,   364,     0,
       0,   365,     0,   366,     0,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
       0,   380,     0,   381,   382,   383,   384,   385,     0,   386,
     387,   388,     0,     0,   389,     0,     0,     0,   390,   391,
     392,   393,   394,     0,     0,   395,   396,   397,   398,   399,
       0,   400,   401,     0,   402,   403,   404,     0,     0,   405,
       0,   406,     0,   407,   408,     0,   409,   410,     0,   411,
       0,   412,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,     0,     0,   431,
       0,     0,     0,   432,     0,   433,   434,   435,   436,   437,
     438,     0,   439,   440,   441,   442,   443,   444,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,     0,     0,
     448,     0,     0,   449,   450,     0,     0,     0,   451,     0,
       0,   452,   453,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,   461,   462,   463,     0,   464,   465,     0,
     466,     0,   467,   468,   469,   470,     0,     0,   471,   472,
       0,   473,   474,   475,   476,     0,     0,     0,     0,     0,
     477,   478,   479,     0,     0,     0,   480,   481,   482,   483,
       0,   484,   485,     0,   486,   487,     0,   488,   489,     0,
       0,   490,     0,     0,   491,     0,   492,     0,   493,   494,
     495,     0,     0,     0,     0,     0,     0,   496,     0,     0,
     497,     0,     0,     0,   498,   499,   500,   501,   502,   503,
     504,     0,     0,     0,     0,     0,     0,   505,   506,     0,
     507,   508,   509,     0,     0,   510,   141,     0,   142,   143,
     144,   145,   146,   147,     0,     0,   148,     0,     0,     0,
     149,     0,     0,     0,  1337,   151,   152,   153,   154,   155,
     156,   157,     0,     0,  -372,     0,     0,     0,   160,     0,
       0,     0,   161,     0,     0,   162,   163,   164,     0,   165,
       0,     0,     0,     0,     0,   168,  4142,     0,   169,   170,
       0,   171,     0,     0,     0,     0,     0,   175,   176,   177,
     178,  4143,   180,   181,     0,   182,   183,     0,     0,     0,
       0,     0,     0,   189,     0,   191,     0,   193,   194,   195,
     196,     0,   197,   198,     0,   199,   200,   201,     0,   203,
       0,   204,     0,     0,   205,     0,     0,   206,     0,   207,
       0,     0,   208,     0,   209,     0,     0,     0,   210,   211,
     212,     0,     0,   213,     0,     0,     0,     0,   214,     0,
       0,     0,     0,     0,   216,     0,   217,     0,     0,     0,
     218,     0,   219,   220,   221,   222,   223,     0,     0,     0,
       0,     0,     0,   225,   226,   227,     0,     0,     0,   228,
       0,     0,   230,     0,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,   239,   240,     0,     0,     0,
       0,   243,   244,   245,     0,     0,   246,   247,  4144,   248,
     249,   250,     0,     0,     0,     0,     0,     0,   252,     0,
     253,     0,   254,     0,   255,   256,   257,   258,   259,     0,
     261,     0,   262,     0,     0,     0,     0,   264,   265,     0,
       0,     0,     0,     0,     0,   268,     0,     0,     0,   269,
     270,   271,   272,   273,  4145,     0,   274,   275,   276,     0,
     277,     0,   278,     0,     0,     0,     0,   279,     0,     0,
       0,     0,   281,     0,   282,   283,     0,   284,   285,  4146,
       0,     0,   286,     0,     0,     0,   288,   289,     0,     0,
     290,  4147,     0,   291,   292,     0,     0,     0,     0,     0,
     293,   294,     0,   295,     0,   296,     0,   297,   298,     0,
       0,     0,     0,  -327,     0,     0,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,     0,   315,   316,   317,   318,     0,   319,   320,
     321,   322,     0,   323,   324,     0,     0,     0,     0,   325,
     326,   327,   328,   329,   330,     0,     0,   331,   332,     0,
     333,     0,   334,     0,   335,   336,   337,   338,   339,   340,
     341,   342,   343,     0,     0,   344,   345,     0,     0,   346,
     347,   348,   349,     0,     0,     0,     0,   351,     0,     0,
       0,   352,     0,   353,   354,   355,     0,   356,   357,   358,
    4148,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   363,   364,     0,     0,     0,     0,   366,
       0,   367,   368,   369,   370,   371,   372,   373,   374,   375,
       0,     0,     0,     0,   378,   379,     0,   380,     0,   381,
     382,   383,   384,   385,     0,   386,   387,   388,     0,     0,
     389,     0,     0,     0,   390,   391,   392,   393,   394,     0,
       0,   395,   396,   397,   398,   399,     0,   400,     0,     0,
     402,     0,   404,  -327,     0,   405,     0,     0,     0,   407,
       0,     0,   409,   410,     0,   411,  4149,   412,     0,     0,
     413,     0,   415,   416,   417,   418,   419,   420,   421,     0,
     423,   424,     0,   425,     0,     0,     0,     0,   427,   428,
     429,     0,     0,     0,     0,   431,     0,     0,     0,     0,
       0,     0,   434,     0,     0,   437,   438,     0,   439,     0,
     441,     0,   443,   444,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,     0,     0,   448,     0,     0,   449,
       0,     0,     0,     0,   451,     0,     0,     0,   453,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,   461,
     462,   463,     0,   464,   465,     0,   466,     0,   467,   468,
     469,   470,     0,     0,   471,   472,     0,   473,   474,   475,
     476,     0,     0,     0,     0,     0,   477,   478,   479,     0,
       0,     0,     0,   481,   482,   483,     0,   484,   485,     0,
     486,   487,     0,     0,     0,     0,     0,   490,     0,     0,
     491,     0,     0,     0,   493,   494,   495,     0,     0,     0,
       0,     0,     0,   496,     0,     0,   497,     0,     0,     0,
     498,   499,   500,   501,   502,   503,   504,     0,     0,  -327,
       0,     0,     0,   505,     0,     0,   507,     0,   509,     0,
     141,   510,   142,   143,   144,   145,   146,   147,     0,     0,
     148,     0,     0,     0,   149,  4758,     0,   150,     0,   151,
     152,   153,   154,   155,   156,   157,   158,     0,   159,     0,
       0,     0,   160,     0,     0,     0,   161,     0,     0,   162,
     163,   164,     0,   165,     0,   166,   167,     0,     0,   168,
       0,     0,   169,   170,     0,   171,   172,     0,   173,   174,
       0,   175,   176,   177,   178,   179,   180,   181,     0,   182,
     183,   184,   185,   186,   187,   188,     0,   189,   190,   191,
     192,   193,   194,   195,   196,     0,   197,   198,     0,   199,
     200,   201,   202,   203,     0,   204,     0,     0,   205,     0,
       0,   206,     0,   207,  1046,     0,   208,     0,   209,     0,
       0,     0,   210,   211,   212,     0,     0,   213,     0,     0,
       0,     0,   214,   215,     0,     0,     0,     0,   216,     0,
     217,     0,     0,     0,   218,     0,   219,   220,   221,   222,
     223,     0,     0,     0,   224,     0,     0,   225,   226,   227,
       0,     0,     0,   228,     0,   229,   230,     0,   231,   232,
     233,     0,     0,   234,   235,     0,   236,   237,   238,   239,
     240,   241,   242,     0,     0,   243,   244,   245,     0,     0,
     246,   247,     0,   248,   249,   250,     0,     0,   251,     0,
       0,     0,   252,     0,   253,     0,   254,     0,   255,   256,
     257,   258,   259,   260,   261,     0,   262,     0,     0,     0,
     263,   264,   265,     0,   266,     0,     0,     0,   267,   268,
       0,     0,     0,   269,   270,   271,   272,   273,     0,     0,
     274,   275,   276,     0,   277,     0,   278,     0,     0,     0,
       0,   279,   280,     0,     0,     0,   281,     0,   282,   283,
       0,   284,   285,     0,     0,     0,   286,     0,     0,   287,
     288,   289,     0,     0,   290,     0,     0,   291,   292,   640,
       0,     0,     0,     0,   293,   294,     0,   295,     0,   296,
       0,   297,   298,     0,     0,     0,     0,     0,     0,     0,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,     0,   315,   316,   317,
     318,     0,   319,   320,   321,   322,     0,   323,   324,     0,
       0,     0,     0,   325,   326,   327,   328,   329,   330,     0,
       0,   331,   332,     0,   333,     0,   334,     0,   335,   336,
     337,   338,   339,   340,   341,   342,   343,     0,     0,   344,
     345,     0,     0,   346,   347,   348,   349,     0,     0,     0,
     350,   351,     0,     0,     0,   352,     0,   353,   354,   355,
       0,   356,   357,   358,   359,     0,   360,   361,     0,     0,
       0,     0,     0,     0,     0,     0,   362,   363,   364,     0,
       0,   365,     0,   366,     0,   367,   368,   369,   370,   371,
     372,   373,   374,   375,   376,     0,     0,   377,   378,   379,
       0,   380,     0,   381,   382,   383,   384,   385,     0,   386,
     387,   388,     0,     0,   389,     0,     0,     0,   390,   391,
     392,   393,   394,     0,     0,   395,   396,   397,   398,   399,
       0,   400,   401,     0,   402,   403,   404,     0,     0,   405,
       0,   406,     0,   407,   408,     0,   409,   410,     0,   411,
       0,   412,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,     0,
       0,     0,   427,   428,   429,   430,     0,     0,     0,   431,
       0,     0,     0,   432,     0,   433,   434,   435,   436,   437,
     438,     0,   439,   440,   441,   442,   443,   444,     0,     0,
       0,     0,     0,     0,   445,   446,     0,   447,     0,     0,
     448,     0,     0,   449,   450,     0,     0,     0,   451,     0,
       0,   452,   453,     0,   454,   455,   456,   457,   458,   459,
       0,     0,   460,   461,   462,   463,     0,   464,   465,     0,
     466,     0,   467,   468,   469,   470,     0,   138,   471,   472,
       0,   473,   474,   475,   476,     0,     0,     0,     0,     0,
     477,   478,   479,     0,     0,     0,   480,   481,   482,   483,
       0,   484,   485,     0,   486,   487,     0,   488,   489,     0,
       0,   490,     0,     0,   491,     0,   492,     0,   493,   494,
     495,     0,     0,     0,     0,     0,     0,   496,     0,     0,
     497,     0,     0,     0,   498,   499,   500,   501,   502,   503,
     504,     0,     0,     0,     0,     0,     0,   505,   506,     0,
     507,   508,   509,     0,   141,   510,   142,   143,   144,   145,
     146,   147,     0,     0,   148,     0,     0,  1235,   149,     0,
       0,   150,     0,   151,   152,   153,   154,   155,   156,   157,
     158,     0,   159,     0,     0,     0,   160,     0,     0,     0,
     161,     0,     0,   162,   163,   164,     0,   165,     0,   166,
     167,     0,     0,   168,     0,     0,   169,   170,     0,   171,
     172,     0,   173,   174,     0,   175,   176,   177,   178,   179,
     180,   181,     0,   182,   183,   184,   185,   186,   187,   188,
       0,   189,   190,   191,   192,   193,   194,   195,   196,     0,
     197,   198,     0,   199,   200,   201,   202,   203,     0,   204,
       0,     0,   205,     0,     0,   206,     0,   207,     0,     0,
     208,     0,   209,     0,     0,     0,   210,   211,   212,     0,
       0,   213,     0,     0,     0,     0,   214,   215,     0,     0,
       0,     0,   216,     0,   217,     0,     0,     0,   218,     0,
     219,   220,   221,   222,   223,     0,     0,     0,   224,     0,
       0,   225,   226,   227,     0,     0,     0,   228,     0,   229,
     230,     0,   231,   232,   233,     0,     0,   234,   235,     0,
     236,   237,   238,   239,   240,   241,   242,     0,     0,   243,
     244,   245,     0,     0,   246,   247,     0,   248,   249,   250,
       0,     0,   251,     0,     0,     0,   252,     0,   253,     0,
     254,     0,   255,   256,   257,   258,   259,   260,   261,     0,
     262,     0,     0,     0,   263,   264,   265,     0,   266,     0,
       0,     0,   267,   268,     0,     0,     0,   269,   270,   271,
     272,   273,     0,     0,   274,   275,   276,     0,   277,     0,
     278,     0,     0,     0,     0,   279,   280,     0,     0,     0,
     281,     0,   282,   283,     0,   284,   285,     0,     0,     0,
     286,     0,     0,   287,   288,   289,     0,     0,   290,     0,
       0,   291,   292,     0,     0,     0,     0,     0,   293,   294,
       0,   295,     0,   296,     0,   297,   298,     0,     0,     0,
       0,     0,     0,     0,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
       0,   315,   316,   317,   318,     0,   319,   320,   321,   322,
       0,   323,   324,     0,     0,     0,     0,   325,   326,   327,
     328,   329,   330,     0,     0,   331,   332,     0,   333,     0,
     334,     0,   335,   336,   337,   338,   339,   340,   341,   342,
     343,     0,     0,   344,   345,     0,     0,   346,   347,   348,
     349,     0,     0,     0,   350,   351,     0,     0,     0,   352,
       0,   353,   354,   355,     0,   356,   357,   358,   359,     0,
     360,   361,     0,     0,     0,     0,     0,     0,     0,     0,
     362,   363,   364,     0,     0,   365,     0,   366,     0,   367,
     368,   369,   370,   371,   372,   373,   374,   375,   376,     0,
       0,   377,   378,   379,     0,   380,     0,   381,   382,   383,
     384,   385,     0,   386,   387,   388,     0,     0,   389,     0,
       0,     0,   390,   391,   392,   393,   394,     0,     0,   395,
     396,   397,   398,   399,     0,   400,   401,     0,   402,   403,
     404,     0,     0,   405,     0,   406,     0,   407,   408,     0,
     409,   410,     0,   411,     0,   412,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,     0,     0,     0,   427,   428,   429,   430,
       0,     0,     0,   431,     0,     0,     0,   432,     0,   433,
     434,   435,   436,   437,   438,     0,   439,   440,   441,   442,
     443,   444,     0,     0,     0,     0,     0,     0,   445,   446,
       0,   447,     0,     0,   448,     0,     0,   449,   450,     0,
       0,     0,   451,     0,     0,   452,   453,     0,   454,   455,
     456,   457,   458,   459,     0,     0,   460,   461,   462,   463,
       0,   464,   465,     0,   466,     0,   467,   468,   469,   470,
       0,     0,   471,   472,     0,   473,   474,   475,   476,     0,
       0,     0,     0,     0,   477,   478,   479,     0,     0,     0,
     480,   481,   482,   483,     0,   484,   485,     0,   486,   487,
       0,   488,   489,     0,     0,   490,     0,     0,   491,     0,
     492,     0,   493,   494,   495,     0,     0,     0,     0,     0,
       0,   496,     0,     0,   497,     0,     0,     0,   498,   499,
     500,   501,   502,   503,   504,     0,     0,     0,     0,     0,
       0,   505,   506,     0,   507,   508,   509,     0,   141,   510,
     142,   143,   144,   145,   146,   147,  2208,     0,   148,     0,
       0,     0,   149,     0,     0,   150,     0,   151,   152,   153,
     154,   155,   156,   157,   158,     0,   159,     0,     0,     0,
     160,     0,     0,     0,   161,     0,     0,   162,   163,   164,
       0,   165,     0,   166,   167,     0,     0,   168,     0,     0,
     169,   170,     0,   171,   172,     0,   173,   174,     0,   175,
     176,   177,   178,   179,   180,   181,     0,   182,   183,   184,
     185,   186,   187,   188,     0,   189,   190,   191,   192,   193,
     194,   195,   196,     0,   197,   198,     0,   199,   200,   201,
     202,   203,     0,   204,     0,     0,   205,     0,     0,   206,
       0,   207,     0,     0,   208,     0,   209,     0,     0,     0,
     210,   211,   212,     0,     0,   213,     0,     0,     0,     0,
     214,   215,     0,     0,     0,     0,   216,     0,   217,     0,
       0,     0,   218,     0,   219,   220,   221,   222,   223,     0,
       0,     0,   224,     0,     0,   225,   226,   227,     0,     0,
       0,   228,     0,   229,   230,     0,   231,   232,   233,     0,
       0,   234,   235,     0,   236,   237,   238,   239,   240,   241,
     242,     0,     0,   243,   244,   245,     0,     0,   246,   247,
       0,   248,   249,   250,     0,     0,   251,     0,     0,     0,
     252,     0,   253,     0,   254,     0,   255,   256,   257,   258,
     259,   260,   261,     0,   262,     0,     0,     0,   263,   264,
     265,     0,   266,     0,     0,     0,   267,   268,     0,     0,
       0,   269,   270,   271,   272,   273,     0,     0,   274,   275,
     276,     0,   277,     0,   278,     0,     0,     0,     0,   279,
     280,     0,     0,     0,   281,     0,   282,   283,     0,   284,
     285,     0,     0,     0,   286,     0,     0,   287,   288,   289,
       0,     0,   290,     0,     0,   291,   292,     0,     0,     0,
       0,     0,   293,   294,     0,   295,     0,   296,     0,   297,
     298,     0,     0,     0,     0,     0,     0,     0,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,     0,   315,   316,   317,   318,     0,
     319,   320,   321,   322,     0,   323,   324,     0,     0,     0,
       0,   325,   326,   327,   328,   329,   330,     0,     0,   331,
     332,     0,   333,     0,   334,     0,   335,   336,   337,   338,
     339,   340,   341,   342,   343,     0,     0,   344,   345,     0,
       0,   346,   347,   348,   349,     0,     0,     0,   350,   351,
       0,     0,     0,   352,     0,   353,   354,   355,     0,   356,
     357,   358,   359,     0,   360,   361,     0,     0,     0,     0,
       0,     0,     0,     0,   362,   363,   364,     0,     0,   365,
       0,   366,     0,   367,   368,   369,   370,   371,   372,   373,
     374,   375,   376,     0,     0,   377,   378,   379,     0,   380,
       0,   381,   382,   383,   384,   385,     0,   386,   387,   388,
       0,     0,   389,     0,     0,     0,   390,   391,   392,   393,
     394,     0,     0,   395,   396,   397,   398,   399,     0,   400,
     401,     0,   402,   403,   404,     0,     0,   405,     0,   406,
       0,   407,   408,     0,   409,   410,     0,   411,     0,   412,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,     0,     0,     0,
     427,   428,   429,   430,     0,     0,     0,   431,     0,     0,
       0,   432,     0,   433,   434,   435,   436,   437,   438,     0,
     439,   440,   441,   442,   443,   444,     0,     0,     0,     0,
       0,     0,   445,   446,     0,   447,     0,     0,   448,     0,
       0,   449,   450,     0,     0,     0,   451,     0,     0,   452,
     453,     0,   454,   455,   456,   457,   458,   459,     0,     0,
     460,   461,   462,   463,     0,   464,   465,     0,   466,     0,
     467,   468,   469,   470,     0,     0,   471,   472,     0,   473,
     474,   475,   476,     0,     0,     0,     0,     0,   477,   478,
     479,     0,     0,     0,   480,   481,   482,   483,     0,   484,
     485,     0,   486,   487,     0,   488,   489,     0,     0,   490,
       0,     0,   491,     0,   492,     0,   493,   494,   495,     0,
       0,     0,     0,     0,     0,   496,     0,     0,   497,     0,
       0,     0,   498,   499,   500,   501,   502,   503,   504,     0,
       0,     0,     0,     0,     0,   505,   506,     0,   507,   508,
     509,     0,   141,   510,   142,   143,   144,   145,   146,   147,
    2911,     0,   148,     0,     0,     0,   149,     0,     0,   150,
       0,   151,   152,   153,   154,   155,   156,   157,   158,     0,
     159,     0,     0,     0,   160,     0,     0,     0,   161,     0,
       0,   162,   163,   164,     0,   165,     0,   166,   167,     0,
       0,   168,     0,     0,   169,   170,     0,   171,   172,     0,
     173,   174,     0,   175,   176,   177,   178,   179,   180,   181,
       0,   182,   183,   184,   185,   186,   187,   188,     0,   189,
     190,   191,   192,   193,   194,   195,   196,     0,   197,   198,
       0,   199,   200,   201,   202,   203,     0,   204,     0,     0,
     205,     0,     0,   206,     0,   207,     0,     0,   208,     0,
     209,     0,     0,     0,   210,   211,   212,     0,     0,   213,
       0,     0,     0,     0,   214,   215,     0,     0,     0,     0,
     216,     0,   217,     0,     0,     0,   218,     0,   219,   220,
     221,   222,   223,     0,     0,     0,   224,     0,     0,   225,
     226,   227,     0,     0,     0,   228,     0,   229,   230,     0,
     231,   232,   233,     0,     0,   234,   235,     0,   236,   237,
     238,   239,   240,   241,   242,     0,     0,   243,   244,   245,
       0,     0,   246,   247,     0,   248,   249,   250,     0,     0,
     251,     0,     0,     0,   252,     0,   253,     0,   254,     0,
     255,   256,   257,   258,   259,   260,   261,     0,   262,     0,
       0,     0,   263,   264,   265,     0,   266,     0,     0,     0,
     267,   268,     0,     0,     0,   269,   270,   271,   272,   273,
       0,     0,   274,   275,   276,     0,   277,     0,   278,     0,
       0,     0,     0,   279,   280,     0,     0,     0,   281,     0,
     282,   283,     0,   284,   285,     0,     0,     0,   286,     0,
       0,   287,   288,   289,     0,     0,   290,     0,     0,   291,
     292,     0,     0,     0,     0,     0,   293,   294,     0,   295,
       0,   296,     0,   297,   298,     0,     0,     0,     0,     0,
       0,     0,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,     0,   315,
     316,   317,   318,     0,   319,   320,   321,   322,     0,   323,
     324,     0,     0,     0,     0,   325,   326,   327,   328,   329,
     330,     0,     0,   331,   332,     0,   333,     0,   334,     0,
     335,   336,   337,   338,   339,   340,   341,   342,   343,     0,
       0,   344,   345,     0,     0,   346,   347,   348,   349,     0,
       0,     0,   350,   351,     0,     0,     0,   352,     0,   353,
     354,   355,     0,   356,   357,   358,   359,     0,   360,   361,
       0,     0,     0,     0,     0,     0,     0,     0,   362,   363,
     364,     0,     0,   365,     0,   366,     0,   367,   368,   369,
     370,   371,   372,   373,   374,   375,   376,     0,     0,   377,
     378,   379,     0,   380,     0,   381,   382,   383,   384,   385,
       0,   386,   387,   388,     0,     0,   389,     0,     0,     0,
     390,   391,   392,   393,   394,     0,     0,   395,   396,   397,
     398,   399,     0,   400,   401,     0,   402,   403,   404,     0,
       0,   405,     0,   406,     0,   407,   408,     0,   409,   410,
       0,   411,     0,   412,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,     0,     0,     0,   427,   428,   429,   430,     0,     0,
       0,   431,     0,     0,     0,   432,     0,   433,   434,   435,
     436,   437,   438,     0,   439,   440,   441,   442,   443,   444,
       0,     0,     0,     0,     0,     0,   445,   446,     0,   447,
       0,     0,   448,     0,     0,   449,   450,     0,     0,     0,
     451,     0,     0,   452,   453,     0,   454,   455,   456,   457,
     458,   459,     0,     0,   460,   461,   462,   463,     0,   464,
     465,     0,   466,     0,   467,   468,   469,   470,     0,     0,
     471,   472,     0,   473,   474,   475,   476,     0,     0,     0,
       0,     0,   477,   478,   479,     0,     0,     0,   480,   481,
     482,   483,     0,   484,   485,     0,   486,   487,     0,   488,
     489,     0,     0,   490,     0,     0,   491,     0,   492,     0,
     493,   494,   495,     0,     0,     0,     0,     0,     0,   496,
       0,     0,   497,     0,     0,     0,   498,   499,   500,   501,
     502,   503,   504,     0,     0,     0,     0,     0,     0,   505,
     506,     0,   507,   508,   509,     0,   141,   510,   142,   143,
     144,   145,   146,   147,  3288,     0,   148,     0,     0,     0,
     149,     0,     0,   150,     0,   151,   152,   153,   154,   155,
     156,   157,   158,     0,   159,     0,     0,     0,   160,     0,
       0,     0,   161,     0,     0,   162,   163,   164,     0,   165,
       0,   166,   167,     0,     0,   168,     0,     0,   169,   170,
       0,   171,   172,     0,   173,   174,     0,   175,   176,   177,
     178,   179,   180,   181,     0,   182,   183,   184,   185,   186,
     187,   188,     0,   189,   190,   191,   192,   193,   194,   195,
     196,     0,   197,   198,     0,   199,   200,   201,   202,   203,
       0,   204,     0,     0,   205,     0,     0,   206,     0,   207,
       0,     0,   208,     0,   209,     0,     0,     0,   210,   211,
     212,     0,     0,   213,     0,     0,     0,     0,   214,   215,
       0,     0,     0,     0,   216,     0,   217,     0,     0,     0,
     218,     0,   219,   220,   221,   222,   223,     0,     0,     0,
     224,     0,     0,   225,   226,   227,     0,     0,     0,   228,
       0,   229,   230,     0,   231,   232,   233,     0,     0,   234,
     235,     0,   236,   237,   238,   239,   240,   241,   242,     0,
       0,   243,   244,   245,     0,     0,   246,   247,     0,   248,
     249,   250,     0,     0,   251,     0,     0,     0,   252,     0,
     253,     0,   254,     0,   255,   256,   257,   258,   259,   260,
     261,     0,   262,     0,     0,     0,   263,   264,   265,     0,
     266,     0,     0,     0,   267,   268,     0,     0,     0,   269,
     270,   271,   272,   273,     0,     0,   274,   275,   276,     0,
     277,     0,   278,     0,     0,     0,     0,   279,   280,     0,
       0,     0,   281,     0,   282,   283,     0,   284,   285,     0,
       0,     0,   286,     0,     0,   287,   288,   289,     0,     0,
     290,     0,     0,   291,   292,     0,     0,     0,     0,     0,
     293,   294,     0,   295,     0,   296,     0,   297,   298,     0,
       0,     0,     0,     0,     0,     0,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,     0,   315,   316,   317,   318,     0,   319,   320,
     321,   322,     0,   323,   324,     0,     0,     0,     0,   325,
     326,   327,   328,   329,   330,     0,     0,   331,   332,     0,
     333,     0,   334,     0,   335,   336,   337,   338,   339,   340,
     341,   342,   343,     0,     0,   344,   345,     0,     0,   346,
     347,   348,   349,     0,     0,     0,   350,   351,     0,     0,
       0,   352,     0,   353,   354,   355,     0,   356,   357,   358,
     359,     0,   360,   361,     0,     0,     0,     0,     0,     0,
       0,     0,   362,   363,   364,     0,     0,   365,     0,   366,
       0,   367,   368,   369,   370,   371,   372,   373,   374,   375,
     376,     0,     0,   377,   378,   379,     0,   380,     0,   381,
     382,   383,   384,   385,     0,   386,   387,   388,     0,     0,
     389,     0,     0,     0,   390,   391,   392,   393,   394,     0,
       0,   395,   396,   397,   398,   399,     0,   400,   401,     0,
     402,   403,   404,     0,     0,   405,     0,   406,     0,   407,
     408,     0,   409,   410,     0,   411,     0,   412,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,     0,     0,     0,   427,   428,
     429,   430,     0,     0,     0,   431,     0,     0,     0,   432,
       0,   433,   434,   435,   436,   437,   438,     0,   439,   440,
     441,   442,   443,   444,     0,     0,     0,     0,     0,     0,
     445,   446,     0,   447,     0,     0,   448,     0,     0,   449,
     450,     0,     0,     0,   451,     0,     0,   452,   453,     0,
     454,   455,   456,   457,   458,   459,     0,     0,   460,   461,
     462,   463,     0,   464,   465,     0,   466,     0,   467,   468,
     469,   470,     0,     0,   471,   472,     0,   473,   474,   475,
     476,     0,     0,     0,     0,     0,   477,   478,   479,     0,
       0,     0,   480,   481,   482,   483,     0,   484,   485,     0,
     486,   487,     0,   488,   489,     0,     0,   490,     0,     0,
     491,     0,   492,     0,   493,   494,   495,     0,     0,     0,
       0,     0,     0,   496,     0,     0,   497,     0,     0,     0,
     498,   499,   500,   501,   502,   503,   504,     0,     0,     0,
       0,     0,     0,   505,   506,     0,   507,   508,   509,     0,
       0,   510,     0,     0,     0,     0,     0,   141,  3648,   142,
     143,   144,   145,   146,   147,   845,   846,   148,     0,     0,
       0,   149,     0,     0,   150,     0,   151,   152,   153,   154,
     155,   156,   157,   158,     0,   159,     0,     0,     0,   160,
       0,     0,     0,   161,     0,     0,   162,   163,   164,     0,
     165,     0,   166,   167,     0,     0,   168,     0,     0,   169,
     170,     0,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,   184,   185,
     186,   187,   188,     0,   189,   190,   191,   192,   193,   194,
     195,   196,     0,   197,   198,     0,   199,   200,   201,   202,
     203,     0,   204,     0,     0,   205,   847,     0,   206,     0,
     207,     0,   848,   208,     0,   209,     0,     0,     0,   210,
     211,   212,     0,     0,   213,     0,     0,     0,     0,   214,
     215,     0,     0,     0,     0,   216,     0,   217,   849,     0,
       0,   218,     0,   219,   220,   221,   222,   223,     0,     0,
       0,   224,   850,     0,   225,   226,   227,     0,     0,     0,
     228,     0,   229,   230,     0,   231,   232,   233,     0,     0,
     234,   235,     0,   236,   237,   851,   239,   240,   241,   852,
       0,     0,   243,   244,   245,     0,     0,   246,   247,     0,
     853,   249,   250,     0,     0,   251,     0,     0,     0,   252,
       0,   253,     0,   254,     0,   255,   256,   257,   258,   259,
     260,   261,   854,   262,     0,     0,     0,   263,   264,   265,
       0,   266,     0,     0,     0,   267,   268,     0,     0,     0,
     269,   270,   271,   272,   273,     0,     0,   274,   275,   276,
     855,   277,     0,   278,     0,     0,     0,   856,   279,   280,
       0,     0,     0,   281,     0,   282,   283,     0,   284,   285,
       0,     0,     0,   286,     0,     0,   287,   288,   289,     0,
       0,   290,     0,     0,   291,   292,   640,     0,     0,     0,
       0,   293,   294,     0,   295,     0,   296,   857,   297,   298,
       0,     0,     0,     0,     0,     0,     0,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,     0,   315,   316,   317,   318,     0,   319,
     320,   321,   322,     0,   323,   324,     0,     0,     0,     0,
     325,   326,   327,   328,   329,   330,     0,     0,   331,   332,
       0,   333,     0,   334,     0,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,   344,   345,     0,     0,
     346,   347,   348,   349,     0,     0,     0,   350,   351,     0,
       0,     0,   352,     0,   353,   354,   355,     0,   356,   357,
     358,   359,     0,   360,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,   363,   364,     0,     0,   365,     0,
     366,     0,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,     0,   380,     0,
     858,   382,   383,   384,   859,     0,   386,   387,   388,     0,
       0,   389,     0,     0,     0,   390,   391,   392,   393,   394,
     860,     0,   395,   396,   397,   398,   399,     0,   861,   401,
       0,   402,   403,   404,     0,     0,   862,     0,   406,     0,
     407,   408,     0,   409,   410,     0,   411,     0,   412,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   863,     0,     0,   427,
     428,   429,   430,     0,     0,     0,   431,     0,     0,   864,
     865,     0,   433,   434,   435,   436,   437,   438,     0,   439,
     440,   441,   442,   443,   444,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,     0,     0,   448,     0,     0,
     449,   450,     0,     0,     0,   451,     0,     0,   452,   453,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   866,
     461,   462,   463,     0,   464,   465,     0,   466,     0,   467,
     468,   469,   470,     0,   138,   471,   472,     0,   473,   474,
     475,   476,     0,     0,     0,     0,     0,   477,   478,   479,
     867,     0,     0,   480,   481,   482,   483,     0,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,   490,     0,
       0,   491,   868,   492,   869,   493,   494,   495,     0,     0,
       0,     0,     0,     0,   496,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,   503,   504,     0,     0,
       0,     0,     0,     0,   505,   506,     0,   507,   508,   509,
       0,   141,   510,   922,   143,   144,   145,   146,   147,   923,
     846,   148,     0,     0,     0,   149,     0,     0,   150,     0,
     151,   152,   153,   154,   155,   156,   157,   158,     0,   159,
       0,     0,     0,   160,     0,     0,     0,   161,     0,     0,
     162,   163,   164,     0,   165,     0,   166,   167,     0,     0,
     168,     0,     0,   169,   170,     0,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,     0,
     182,   183,   184,   185,   186,   187,   188,     0,   189,   190,
     191,   192,   193,   194,   195,   196,     0,   197,   198,     0,
     199,   200,   201,   202,   203,     0,   204,     0,     0,   205,
     847,     0,   206,     0,   207,     0,   848,   208,     0,   209,
       0,     0,     0,   210,   211,   212,     0,     0,   213,     0,
       0,     0,     0,   214,   215,     0,     0,     0,     0,   216,
       0,   217,   849,     0,     0,   218,     0,   219,   220,   221,
     222,   223,     0,     0,     0,   224,   850,     0,   225,   226,
     227,     0,     0,     0,   228,     0,   229,   230,     0,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   851,
     239,   240,   241,   852,     0,     0,   243,   244,   245,     0,
       0,   246,   247,     0,   853,   249,   250,     0,     0,   251,
       0,     0,     0,   252,     0,   253,     0,   254,     0,   255,
     256,   257,   258,   259,   260,   261,   854,   262,     0,     0,
       0,   263,   264,   265,     0,   266,     0,     0,     0,   267,
     268,     0,     0,     0,   269,   270,   271,   272,   273,     0,
       0,   274,   275,   276,   855,   277,     0,   278,     0,     0,
       0,   856,   279,   280,     0,     0,     0,   281,     0,   282,
     283,     0,   284,   285,     0,     0,     0,   286,     0,     0,
     287,   288,   289,     0,     0,   290,     0,     0,   291,   292,
     640,     0,     0,     0,     0,   293,   294,     0,   295,     0,
     296,   857,   297,   298,     0,     0,     0,     0,     0,     0,
       0,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,     0,   315,   316,
     317,   318,     0,   319,   320,   321,   322,     0,   323,   324,
       0,     0,     0,     0,   325,   326,   327,   328,   329,   330,
       0,     0,   331,   332,     0,   333,     0,   334,     0,   335,
     336,   337,   338,   339,   340,   341,   342,   343,     0,     0,
     344,   345,     0,     0,   346,   347,   348,   349,     0,     0,
       0,   350,   351,     0,     0,     0,   352,     0,   353,   354,
     355,     0,   356,   357,   358,   359,     0,   360,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,   363,   364,
       0,     0,   365,     0,   366,     0,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,     0,     0,   377,   378,
     379,     0,   380,     0,   858,   382,   383,   384,   924,     0,
     386,   387,   388,     0,     0,   389,     0,     0,     0,   390,
     391,   392,   393,   394,   860,     0,   395,   396,   397,   398,
     399,     0,   861,   401,     0,   402,   403,   404,     0,     0,
     862,     0,   406,     0,   407,   408,     0,   409,   410,     0,
     411,     0,   412,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     863,     0,     0,   427,   428,   429,   430,     0,     0,     0,
     431,     0,     0,   864,   865,     0,   433,   434,   435,   436,
     437,   438,     0,   439,   440,   441,   442,   443,   444,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,     0,
       0,   448,     0,     0,   449,   450,     0,     0,     0,   451,
       0,     0,   452,   453,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   866,   461,   462,   463,     0,   464,   465,
       0,   466,     0,   467,   468,   469,   470,     0,   138,   471,
     472,     0,   473,   474,   475,   476,     0,     0,     0,     0,
       0,   477,   478,   479,   867,     0,     0,   480,   481,   482,
     483,     0,   484,   485,     0,   486,   487,     0,   488,   489,
       0,     0,   490,     0,     0,   491,   868,   492,   869,   493,
     494,   495,     0,     0,     0,     0,     0,     0,   496,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
     503,   504,     0,     0,     0,     0,     0,     0,   505,   506,
       0,   507,   508,   509,     0,   141,   510,   142,   143,   144,
     145,   146,   147,     0,     0,   148,     0,     0,     0,   149,
       0,     0,   150,     0,   151,   152,   153,   154,   155,   156,
     157,   158,     0,   159,     0,     0,     0,   160,     0,     0,
       0,   161,     0,     0,   162,   163,   164,     0,   165,     0,
     166,   167,     0,     0,   168,     0,     0,   169,   170,     0,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,   184,   185,   186,   187,
     188,     0,   189,   190,   191,   192,   193,   194,   195,   196,
       0,   197,   198,     0,   199,   200,   201,   202,   203,     0,
     204,     0,     0,   205,     0,     0,   206,     0,   207,     0,
       0,   208,     0,   209,     0,     0,     0,   210,   211,   212,
       0,     0,   213,     0,     0,     0,     0,   214,   215,  2552,
       0,     0,     0,   216,     0,   217,     0,     0,     0,   218,
       0,   219,   220,   221,   222,   223,     0,     0,     0,   224,
       0,     0,   225,   226,   227,     0,     0,     0,   228,     0,
     229,   230,     0,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,   239,   240,   241,   242,     0,     0,
     243,   244,   245,     0,     0,   246,   247,     0,   248,   249,
     250,  2553,     0,   251,     0,     0,     0,   252,     0,   253,
       0,   254,     0,   255,   256,   257,   258,   259,   260,   261,
       0,   262,     0,     0,     0,   263,   264,   265,     0,   266,
    2554,     0,     0,   267,   268,     0,     0,     0,   269,   270,
     271,   272,   273,     0,     0,   274,   275,   276,     0,   277,
       0,   278,     0,     0,     0,     0,   279,   280,     0,     0,
       0,   281,     0,   282,   283,     0,   284,   285,     0,     0,
       0,   286,     0,     0,   287,   288,   289,     0,     0,   290,
       0,     0,   291,   292,     0,     0,     0,     0,     0,   293,
     294,     0,   295,     0,   296,     0,   297,   298,     0,     0,
    2555,     0,     0,     0,     0,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,     0,   315,   316,   317,   318,     0,   319,   320,   321,
     322,     0,   323,   324,     0,     0,     0,     0,   325,   326,
     327,   328,   329,   330,     0,     0,   331,   332,     0,   333,
       0,   334,     0,   335,   336,   337,   338,   339,   340,   341,
     342,   343,     0,     0,   344,   345,     0,     0,   346,   347,
     348,   349,  1094,  1095,     0,   350,   351,     0,     0,  2556,
     352,     0,   353,   354,   355,     0,   356,   357,   358,   359,
       0,   360,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,   363,   364,     0,     0,   365,     0,   366,     0,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,     0,   380,     0,   381,   382,
     383,   384,   385,     0,   386,   387,   388,     0,     0,   389,
       0,     0,     0,   390,   391,   392,   393,   394,     0,     0,
     395,   396,   397,   398,   399,     0,   400,   401,     0,   402,
     403,   404,     0,     0,   405,     0,   406,     0,   407,   408,
       0,   409,   410,     0,   411,     0,   412,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,     0,     0,   431,     0,     0,     0,   432,     0,
     433,   434,   435,   436,   437,   438,     0,   439,   440,   441,
     442,   443,   444,     0,     0,  4745,   587,  4746,     0,   445,
     446,     0,   447,     0,     0,   448,     0,     0,   449,   450,
       0,     0,     0,   451,     0,     0,   452,   453,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,   461,   462,
     463,     0,   464,   465,     0,   466,     0,   467,   468,   469,
     470,     0,     0,   471,   472,     0,   473,   474,   475,   476,
       0,     0,     0,     0,     0,   477,   478,   479,     0,     0,
       0,   480,   481,   482,   483,  2557,   484,   485,     0,   486,
     487,     0,   488,   489,     0,     0,   490,     0,     0,   491,
       0,   492,     0,   493,   494,   495,     0,     0,     0,     0,
       0,     0,   496,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,   503,   504,     0,     0,     0,     0,
       0,     0,   505,   506,     0,   507,   508,   509,     0,   141,
     510,   142,   143,   144,   145,   146,   147,     0,     0,   148,
       0,     0,     0,   149,     0,     0,   150,     0,   151,   152,
     153,   154,   155,   156,   157,   158,     0,   159,     0,     0,
       0,   160,     0,     0,     0,   161,     0,     0,   162,   163,
     164,     0,   165,     0,   166,   167,     0,     0,   168,     0,
       0,   169,   170,     0,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,     0,   182,   183,
     184,   185,   186,   187,   188,     0,   189,   190,   191,   192,
     193,   194,   195,   196,     0,   197,   198,     0,   199,   200,
     201,   202,   203,     0,   204,     0,     0,   205,     0,     0,
     206,     0,   207,     0,     0,   208,     0,   209,     0,     0,
       0,   210,   211,   212,     0,     0,   213,     0,     0,     0,
       0,   214,   215,  1675,     0,     0,  3478,   216,     0,   217,
       0,     0,     0,   218,     0,   219,   220,   221,   222,   223,
       0,     0,     0,   224,     0,     0,   225,   226,   227,     0,
       0,     0,   228,     0,   229,   230,     0,   231,   232,   233,
       0,     0,   234,   235,     0,   236,   237,   238,   239,   240,
     241,   242,     0,     0,   243,   244,   245,     0,     0,   246,
     247,     0,   248,   249,   250,  1676,     0,   251,     0,     0,
       0,   252,     0,   253,     0,   254,     0,   255,   256,   257,
     258,   259,   260,   261,     0,   262,     0,     0,     0,   263,
     264,   265,     0,   266,  2980,     0,     0,   267,   268,     0,
       0,     0,   269,   270,   271,   272,   273,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,     0,     0,     0,
     279,   280,     0,     0,     0,   281,     0,   282,   283,     0,
     284,   285,     0,     0,     0,   286,     0,     0,   287,   288,
     289,     0,     0,   290,     0,     0,   291,   292,     0,     0,
       0,     0,     0,   293,   294,     0,   295,     0,   296,     0,
     297,   298,     0,     0,  2981,     0,     0,     0,     0,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,     0,   315,   316,   317,   318,
       0,   319,   320,   321,   322,     0,   323,   324,     0,     0,
       0,     0,   325,   326,   327,   328,   329,   330,     0,     0,
     331,   332,     0,   333,     0,   334,     0,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,   344,   345,
       0,     0,   346,   347,   348,   349,     0,     0,     0,   350,
     351,     0,     0,  2982,   352,     0,   353,   354,   355,     0,
     356,   357,   358,   359,     0,   360,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,   363,   364,     0,     0,
     365,     0,   366,     0,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,     0,     0,   377,   378,   379,     0,
     380,     0,   381,   382,   383,   384,   385,     0,   386,   387,
     388,     0,     0,   389,     0,     0,     0,   390,   391,   392,
     393,   394,     0,     0,   395,   396,   397,   398,   399,     0,
     400,   401,     0,   402,   403,   404,     0,     0,   405,     0,
     406,     0,   407,   408,     0,   409,   410,     0,   411,     0,
     412,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,     0,     0,
       0,   427,   428,   429,   430,     0,     0,     0,   431,     0,
       0,     0,   432,     0,   433,   434,   435,   436,   437,   438,
       0,   439,   440,   441,   442,   443,   444,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,     0,     0,   448,
       0,     0,   449,   450,     0,     0,     0,   451,     0,     0,
     452,   453,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,   461,   462,   463,     0,   464,   465,     0,   466,
       0,   467,   468,   469,   470,     0,   138,   471,   472,     0,
     473,   474,   475,   476,     0,     0,     0,     0,     0,   477,
     478,   479,     0,     0,     0,   480,   481,   482,   483,  2983,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
     490,     0,     0,   491,     0,   492,     0,   493,   494,   495,
       0,     0,     0,     0,     0,     0,   496,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,   503,   504,
       0,     0,     0,     0,     0,     0,   505,   506,     0,   507,
     508,   509,     0,   141,   510,   142,   143,   144,   145,   146,
     147,     0,     0,   148,     0,     0,     0,   149,     0,     0,
     150,     0,   151,   152,   153,   154,   155,   156,   157,   158,
       0,   159,     0,     0,     0,   160,     0,     0,     0,   161,
       0,     0,   162,   163,   164,     0,   165,     0,   166,   167,
       0,     0,   168,     0,     0,   169,   170,     0,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,     0,   182,   183,   184,   185,   186,   187,   188,     0,
     189,   190,   191,   192,   193,   194,   195,   196,     0,   197,
     198,     0,   199,   200,   201,   202,   203,     0,   204,     0,
       0,   205,     0,     0,   206,     0,   207,     0,     0,   208,
       0,   209,     0,     0,     0,   210,   211,   212,     0,     0,
     213,     0,     0,     0,     0,   214,   215,  1675,     0,     0,
    4284,   216,     0,   217,     0,     0,     0,   218,     0,   219,
     220,   221,   222,   223,     0,     0,     0,   224,     0,     0,
     225,   226,   227,     0,     0,     0,   228,     0,   229,   230,
       0,   231,   232,   233,     0,     0,   234,   235,     0,   236,
     237,   238,   239,   240,   241,   242,     0,     0,   243,   244,
     245,     0,     0,   246,   247,     0,   248,   249,   250,  1676,
       0,   251,     0,     0,     0,   252,     0,   253,     0,   254,
       0,   255,   256,   257,   258,   259,   260,   261,     0,   262,
       0,     0,     0,   263,   264,   265,     0,   266,  2980,     0,
       0,   267,   268,     0,     0,     0,   269,   270,   271,   272,
     273,     0,     0,   274,   275,   276,     0,   277,     0,   278,
       0,     0,     0,     0,   279,   280,     0,     0,     0,   281,
       0,   282,   283,     0,   284,   285,     0,     0,     0,   286,
       0,     0,   287,   288,   289,     0,     0,   290,     0,     0,
     291,   292,     0,     0,     0,     0,     0,   293,   294,     0,
     295,     0,   296,     0,   297,   298,     0,     0,  2981,     0,
       0,     0,     0,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,     0,
     315,   316,   317,   318,     0,   319,   320,   321,   322,     0,
     323,   324,     0,     0,     0,     0,   325,   326,   327,   328,
     329,   330,     0,     0,   331,   332,     0,   333,     0,   334,
       0,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,   344,   345,     0,     0,   346,   347,   348,   349,
       0,     0,     0,   350,   351,     0,     0,  2982,   352,     0,
     353,   354,   355,     0,   356,   357,   358,   359,     0,   360,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
     363,   364,     0,     0,   365,     0,   366,     0,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,     0,   380,     0,   381,   382,   383,   384,
     385,     0,   386,   387,   388,     0,     0,   389,     0,     0,
       0,   390,   391,   392,   393,   394,     0,     0,   395,   396,
     397,   398,   399,     0,   400,   401,     0,   402,   403,   404,
       0,     0,   405,     0,   406,     0,   407,   408,     0,   409,
     410,     0,   411,     0,   412,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,     0,     0,     0,   427,   428,   429,   430,     0,
       0,     0,   431,     0,     0,     0,   432,     0,   433,   434,
     435,   436,   437,   438,     0,   439,   440,   441,   442,   443,
     444,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,     0,     0,   448,     0,     0,   449,   450,     0,     0,
       0,   451,     0,     0,   452,   453,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,   461,   462,   463,     0,
     464,   465,     0,   466,     0,   467,   468,   469,   470,     0,
     138,   471,   472,     0,   473,   474,   475,   476,     0,     0,
       0,     0,     0,   477,   478,   479,     0,     0,     0,   480,
     481,   482,   483,  2983,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,   490,     0,     0,   491,     0,   492,
       0,   493,   494,   495,     0,     0,     0,     0,     0,     0,
     496,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,   503,   504,     0,     0,     0,     0,     0,     0,
     505,   506,     0,   507,   508,   509,     0,   141,   510,   142,
     143,   144,   145,   146,   147,     0,     0,   148,     0,     0,
       0,   149,     0,     0,   150,     0,   151,   152,   153,   154,
     155,   156,   157,   158,     0,   159,     0,     0,     0,   160,
       0,     0,     0,   161,     0,     0,   162,   163,   164,     0,
     165,     0,   166,   167,     0,     0,   168,     0,     0,   169,
     170,     0,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,   184,   185,
     186,   187,   188,     0,   189,   190,   191,   192,   193,   194,
     195,   196,     0,   197,   198,     0,   199,   200,   201,   202,
     203,     0,   204,     0,     0,   205,     0,     0,   206,     0,
     207,     0,     0,   208,     0,   209,     0,     0,     0,   210,
     211,   212,     0,     0,   213,     0,     0,     0,     0,   214,
     215,  1675,     0,     0,  4546,   216,     0,   217,     0,     0,
       0,   218,     0,   219,   220,   221,   222,   223,     0,     0,
       0,   224,     0,     0,   225,   226,   227,     0,     0,     0,
     228,     0,   229,   230,     0,   231,   232,   233,     0,     0,
     234,   235,     0,   236,   237,   238,   239,   240,   241,   242,
       0,     0,   243,   244,   245,     0,     0,   246,   247,     0,
     248,   249,   250,  1676,     0,   251,     0,     0,     0,   252,
       0,   253,     0,   254,     0,   255,   256,   257,   258,   259,
     260,   261,     0,   262,     0,     0,     0,   263,   264,   265,
       0,   266,  2980,     0,     0,   267,   268,     0,     0,     0,
     269,   270,   271,   272,   273,     0,     0,   274,   275,   276,
       0,   277,     0,   278,     0,     0,     0,     0,   279,   280,
       0,     0,     0,   281,     0,   282,   283,     0,   284,   285,
       0,     0,     0,   286,     0,     0,   287,   288,   289,     0,
       0,   290,     0,     0,   291,   292,     0,     0,     0,     0,
       0,   293,   294,     0,   295,     0,   296,     0,   297,   298,
       0,     0,  2981,     0,     0,     0,     0,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,     0,   315,   316,   317,   318,     0,   319,
     320,   321,   322,     0,   323,   324,     0,     0,     0,     0,
     325,   326,   327,   328,   329,   330,     0,     0,   331,   332,
       0,   333,     0,   334,     0,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,   344,   345,     0,     0,
     346,   347,   348,   349,     0,     0,     0,   350,   351,     0,
       0,  2982,   352,     0,   353,   354,   355,     0,   356,   357,
     358,   359,     0,   360,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,   363,   364,     0,     0,   365,     0,
     366,     0,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,     0,   380,     0,
     381,   382,   383,   384,   385,     0,   386,   387,   388,     0,
       0,   389,     0,     0,     0,   390,   391,   392,   393,   394,
       0,     0,   395,   396,   397,   398,   399,     0,   400,   401,
       0,   402,   403,   404,     0,     0,   405,     0,   406,     0,
     407,   408,     0,   409,   410,     0,   411,     0,   412,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,     0,     0,     0,   427,
     428,   429,   430,     0,     0,     0,   431,     0,     0,     0,
     432,     0,   433,   434,   435,   436,   437,   438,     0,   439,
     440,   441,   442,   443,   444,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,     0,     0,   448,     0,     0,
     449,   450,     0,     0,     0,   451,     0,     0,   452,   453,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
     461,   462,   463,     0,   464,   465,     0,   466,     0,   467,
     468,   469,   470,     0,   138,   471,   472,     0,   473,   474,
     475,   476,     0,     0,     0,     0,     0,   477,   478,   479,
       0,     0,     0,   480,   481,   482,   483,  2983,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,   490,     0,
       0,   491,     0,   492,     0,   493,   494,   495,     0,     0,
       0,     0,     0,     0,   496,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,   503,   504,     0,     0,
       0,     0,     0,     0,   505,   506,     0,   507,   508,   509,
       0,   141,   510,   142,   143,   144,   145,   146,   147,     0,
       0,   148,     0,     0,     0,   149,     0,     0,   150,     0,
     151,   152,   153,   154,   155,   156,   157,   158,     0,   159,
       0,     0,  1444,   160,     0,     0,     0,   161,     0,     0,
     162,   163,   164,     0,   165,     0,   166,   167,     0,     0,
     168,     0,     0,   169,   170,     0,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,     0,
     182,   183,   184,   185,   186,   187,   188,     0,   189,   190,
     191,   192,   193,   194,   195,   196,     0,   197,   198,     0,
     199,   200,   201,   202,   203,     0,   204,     0,     0,   205,
       0,     0,   206,     0,   207,     0,     0,   208,     0,   209,
       0,     0,     0,   210,   211,   212,     0,     0,   213,     0,
       0,     0,     0,   214,   215,     0,     0,     0,  1445,   216,
       0,   217,     0,     0,     0,   218,     0,   219,   220,   221,
     222,   223,     0,     0,     0,   224,     0,     0,   225,   226,
     227,     0,     0,     0,   228,     0,   229,   230,     0,   231,
     232,   233,  1446,     0,   234,   235,     0,   236,   237,   238,
     239,   240,   241,   242,     0,     0,   243,   244,   245,     0,
       0,   246,   247,     0,   248,   249,   250,     0,     0,   251,
       0,     0,     0,   252,     0,   253,     0,   254,     0,   255,
     256,   257,   258,   259,   260,   261,     0,   262,     0,     0,
       0,   263,   264,   265,     0,   266,     0,     0,     0,   267,
     268,     0,     0,     0,   269,   270,   271,   272,   273,     0,
       0,   274,   275,   276,     0,   277,     0,   278,     0,     0,
       0,     0,   279,   280,     0,     0,     0,   281,     0,   282,
     283,     0,   284,   285,     0,     0,     0,   286,     0,     0,
     287,   288,   289,     0,     0,   290,     0,     0,   291,   292,
     640,     0,     0,     0,     0,   293,   294,     0,   295,     0,
     296,     0,   297,   298,     0,     0,     0,     0,     0,     0,
       0,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,     0,   315,   316,
     317,   318,     0,   319,   320,   321,   322,     0,   323,   324,
       0,     0,     0,     0,   325,   326,   327,   328,   329,   330,
       0,     0,   331,   332,     0,   333,     0,   334,     0,   335,
     336,   337,   338,   339,   340,   341,   342,   343,     0,     0,
     344,   345,     0,     0,   346,   347,   348,   349,     0,     0,
       0,   350,   351,     0,     0,     0,   352,     0,   353,   354,
     355,     0,   356,   357,   358,   359,     0,   360,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,   363,   364,
       0,     0,   365,     0,   366,     0,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,     0,     0,   377,   378,
     379,     0,   380,     0,   381,   382,   383,   384,   385,     0,
     386,   387,   388,     0,     0,   389,     0,     0,     0,   390,
     391,   392,   393,   394,     0,     0,   395,   396,   397,   398,
     399,     0,   400,   401,     0,   402,   403,   404,     0,     0,
     405,     0,   406,     0,   407,   408,     0,   409,   410,     0,
     411,     0,   412,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
       0,     0,     0,   427,   428,   429,   430,     0,     0,  1447,
     431,     0,     0,     0,   432,     0,   433,   434,   435,   436,
     437,   438,     0,   439,   440,   441,   442,   443,   444,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,     0,
       0,   448,     0,     0,   449,   450,     0,     0,     0,   451,
       0,     0,   452,   453,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   460,   461,   462,   463,     0,   464,   465,
       0,   466,     0,   467,   468,   469,   470,     0,   138,   471,
     472,     0,   473,   474,   475,   476,     0,     0,     0,     0,
       0,   477,   478,   479,     0,     0,     0,   480,   481,   482,
     483,     0,   484,   485,     0,   486,   487,     0,   488,   489,
       0,     0,   490,     0,     0,   491,     0,   492,     0,   493,
     494,   495,     0,     0,     0,     0,     0,     0,   496,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
     503,   504,     0,     0,     0,     0,     0,     0,   505,   506,
       0,   507,   508,   509,     0,   141,   510,   142,   143,   144,
     145,   146,   147,     0,     0,   148,     0,     0,     0,   149,
       0,     0,   150,     0,   151,   152,   153,   154,   155,   156,
     157,   158,     0,   159,     0,     0,     0,   160,     0,     0,
       0,   161,     0,     0,   162,   163,   164,     0,   165,     0,
     166,   167,     0,     0,   168,     0,     0,   169,   170,     0,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,   184,   185,   186,   187,
     188,     0,   189,   190,   191,   192,   193,   194,   195,   196,
       0,   197,   198,     0,   199,   200,   201,   202,   203,     0,
     204,     0,     0,   205,     0,     0,   206,     0,   207,  1046,
     848,   208,     0,   209,     0,     0,     0,   210,   211,   212,
       0,     0,   213,     0,     0,     0,     0,   214,   215,     0,
       0,     0,     0,   216,     0,   217,     0,     0,     0,   218,
       0,   219,   220,   221,   222,   223,     0,     0,     0,   224,
       0,     0,   225,   226,   227,     0,     0,     0,   228,     0,
     229,   230,     0,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,   239,   240,   241,   242,     0,     0,
     243,   244,   245,     0,     0,   246,   247,     0,   248,   249,
     250,     0,     0,   251,     0,     0,     0,   252,     0,   253,
       0,   254,     0,   255,   256,   257,   258,   259,   260,   261,
       0,   262,     0,     0,     0,   263,   264,   265,     0,   266,
       0,     0,     0,   267,   268,     0,     0,     0,   269,   270,
     271,   272,   273,     0,     0,   274,   275,   276,     0,   277,
       0,   278,     0,     0,     0,     0,   279,   280,     0,     0,
       0,   281,     0,   282,   283,     0,   284,   285,     0,     0,
       0,   286,     0,     0,   287,   288,   289,     0,     0,   290,
       0,     0,   291,   292,   640,     0,     0,     0,     0,   293,
     294,     0,   295,     0,   296,     0,   297,   298,     0,     0,
       0,     0,     0,     0,     0,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,     0,   315,   316,   317,   318,     0,   319,   320,   321,
     322,     0,   323,   324,     0,     0,     0,     0,   325,   326,
     327,   328,   329,   330,     0,     0,   331,   332,     0,   333,
       0,   334,     0,   335,   336,   337,   338,   339,   340,   341,
     342,   343,     0,     0,   344,   345,     0,     0,   346,   347,
     348,   349,     0,     0,     0,   350,   351,     0,     0,     0,
     352,     0,   353,   354,   355,     0,   356,   357,   358,   359,
       0,   360,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,   363,   364,     0,     0,   365,     0,   366,     0,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,     0,   380,     0,   381,   382,
     383,   384,   385,     0,   386,   387,   388,     0,     0,   389,
       0,     0,     0,   390,   391,   392,   393,   394,     0,     0,
     395,   396,   397,   398,   399,     0,   400,   401,     0,   402,
     403,   404,     0,     0,   405,     0,   406,     0,   407,   408,
       0,   409,   410,     0,   411,     0,   412,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,     0,     0,   431,     0,     0,     0,   432,     0,
     433,   434,   435,   436,   437,   438,     0,   439,   440,   441,
     442,   443,   444,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,     0,     0,   448,     0,     0,   449,   450,
       0,     0,     0,   451,     0,     0,   452,   453,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,   461,   462,
     463,     0,   464,   465,     0,   466,     0,   467,   468,   469,
     470,     0,   138,   471,   472,     0,   473,   474,   475,   476,
       0,     0,     0,     0,     0,   477,   478,   479,     0,     0,
       0,   480,   481,   482,   483,     0,   484,   485,     0,   486,
     487,     0,   488,   489,     0,     0,   490,     0,     0,   491,
       0,   492,     0,   493,   494,   495,     0,     0,     0,     0,
       0,     0,   496,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,   503,   504,     0,     0,     0,     0,
       0,     0,   505,   506,     0,   507,   508,   509,     0,   141,
     510,   142,   143,   144,   145,   146,   147,     0,     0,   148,
       0,     0,     0,   149,     0,     0,   150,     0,   151,   152,
     153,   154,   155,   156,   157,   158,     0,   159,     0,     0,
    1458,   160,     0,     0,     0,   161,     0,     0,   162,   163,
     164,     0,   165,     0,   166,   167,     0,     0,   168,     0,
       0,   169,   170,     0,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,     0,   182,   183,
     184,   185,   186,   187,   188,     0,   189,   190,   191,   192,
     193,   194,   195,   196,     0,   197,   198,     0,   199,   200,
     201,   202,   203,     0,   204,     0,     0,   205,     0,     0,
     206,     0,   207,     0,     0,   208,     0,   209,     0,     0,
       0,   210,   211,   212,     0,     0,   213,     0,     0,     0,
       0,   214,   215,     0,     0,     0,  1459,   216,     0,   217,
       0,     0,     0,   218,     0,   219,   220,   221,   222,   223,
       0,     0,     0,   224,     0,     0,   225,   226,   227,     0,
       0,     0,   228,     0,   229,   230,     0,   231,   232,   233,
       0,     0,   234,   235,     0,   236,   237,   238,   239,   240,
     241,   242,     0,     0,   243,   244,   245,     0,     0,   246,
     247,     0,   248,   249,   250,     0,     0,   251,     0,     0,
       0,   252,     0,   253,     0,   254,     0,   255,   256,   257,
     258,   259,   260,   261,     0,   262,     0,     0,     0,   263,
     264,   265,     0,   266,     0,     0,     0,   267,   268,     0,
       0,     0,   269,   270,   271,   272,   273,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,     0,     0,     0,
     279,   280,     0,     0,     0,   281,     0,   282,   283,     0,
     284,   285,     0,     0,     0,   286,     0,     0,   287,   288,
     289,     0,     0,   290,     0,     0,   291,   292,   640,     0,
       0,     0,     0,   293,   294,     0,   295,     0,   296,     0,
     297,   298,     0,     0,     0,     0,     0,     0,     0,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,     0,   315,   316,   317,   318,
       0,   319,   320,   321,   322,     0,   323,   324,     0,     0,
       0,     0,   325,   326,   327,   328,   329,   330,     0,     0,
     331,   332,     0,   333,     0,   334,     0,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,   344,   345,
       0,     0,   346,   347,   348,   349,     0,     0,     0,   350,
     351,     0,     0,     0,   352,     0,   353,   354,   355,     0,
     356,   357,   358,   359,     0,   360,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,   363,   364,     0,     0,
     365,     0,   366,     0,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,     0,     0,   377,   378,   379,     0,
     380,     0,   381,   382,   383,   384,   385,     0,   386,   387,
     388,     0,     0,   389,     0,     0,     0,   390,   391,   392,
     393,   394,     0,     0,   395,   396,   397,   398,   399,     0,
     400,   401,     0,   402,   403,   404,     0,     0,   405,     0,
     406,     0,   407,   408,     0,   409,   410,     0,   411,     0,
     412,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,     0,     0,
       0,   427,   428,   429,   430,     0,     0,     0,   431,     0,
       0,     0,   432,     0,   433,   434,   435,   436,   437,   438,
       0,   439,   440,   441,   442,   443,   444,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,     0,     0,   448,
       0,     0,   449,   450,     0,     0,     0,   451,     0,     0,
     452,   453,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,   461,   462,   463,     0,   464,   465,     0,   466,
       0,   467,   468,   469,   470,     0,   138,   471,   472,     0,
     473,   474,   475,   476,     0,     0,     0,     0,     0,   477,
     478,   479,     0,     0,     0,   480,   481,   482,   483,     0,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
     490,     0,     0,   491,     0,   492,     0,   493,   494,   495,
       0,     0,     0,     0,     0,     0,   496,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,   503,   504,
       0,     0,     0,     0,     0,     0,   505,   506,     0,   507,
     508,   509,     0,   141,   510,   142,   143,   144,   145,   146,
     147,     0,     0,   148,     0,     0,     0,   149,     0,     0,
     150,     0,   151,   152,   153,   154,   155,   156,   157,   158,
       0,   159,     0,     0,     0,   160,  1023,     0,     0,   161,
       0,     0,   162,   163,   164,     0,   165,     0,   166,   167,
       0,     0,   168,     0,     0,   169,   170,     0,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,     0,   182,   183,   184,   185,   186,   187,   188,     0,
     189,   190,   191,   192,   193,   194,   195,   196,     0,   197,
     198,     0,   199,   200,   201,   202,   203,     0,   204,     0,
       0,   205,     0,     0,   206,     0,   207,     0,     0,   208,
       0,   209,     0,     0,     0,   210,   211,   212,     0,     0,
     213,     0,     0,     0,     0,   214,   215,     0,     0,     0,
       0,   216,     0,   217,     0,     0,     0,   218,     0,   219,
     220,   221,   222,   223,     0,     0,     0,   224,     0,     0,
     225,   226,   227,     0,     0,     0,   228,     0,   229,   230,
       0,   231,   232,   233,     0,     0,   234,   235,     0,   236,
     237,   238,   239,   240,   241,   242,     0,     0,   243,   244,
     245,     0,     0,   246,   247,     0,   248,   249,   250,     0,
       0,   251,     0,     0,     0,   252,     0,   253,     0,   254,
       0,   255,   256,   257,   258,   259,   260,   261,     0,   262,
       0,     0,     0,   263,   264,   265,     0,   266,  1024,  1025,
       0,   267,   268,     0,     0,     0,   269,   270,   271,   272,
     273,     0,     0,   274,   275,   276,     0,   277,     0,   278,
       0,     0,     0,     0,   279,   280,     0,     0,     0,   281,
       0,   282,   283,     0,   284,   285,     0,     0,     0,   286,
       0,     0,   287,   288,   289,     0,     0,   290,     0,     0,
     291,   292,     0,     0,     0,     0,     0,   293,   294,     0,
     295,     0,   296,     0,   297,   298,     0,     0,     0,     0,
       0,     0,     0,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,     0,
     315,   316,   317,   318,     0,   319,   320,   321,   322,     0,
     323,   324,     0,     0,     0,     0,   325,   326,   327,   328,
     329,   330,     0,     0,   331,   332,     0,   333,     0,   334,
       0,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,   344,   345,     0,     0,   346,   347,   348,   349,
       0,     0,     0,   350,   351,     0,     0,     0,   352,     0,
     353,   354,   355,     0,   356,   357,   358,   359,     0,   360,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
     363,   364,     0,     0,   365,     0,   366,     0,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,     0,   380,     0,   381,   382,   383,   384,
     385,     0,   386,   387,   388,     0,     0,   389,     0,     0,
       0,   390,   391,   392,   393,   394,     0,     0,   395,   396,
     397,   398,   399,     0,   400,   401,     0,   402,   403,   404,
       0,     0,   405,     0,   406,     0,   407,   408,     0,   409,
     410,     0,   411,     0,   412,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,     0,     0,     0,   427,   428,   429,   430,     0,
       0,     0,   431,     0,     0,     0,   432,     0,   433,   434,
     435,   436,   437,   438,     0,   439,   440,   441,   442,   443,
     444,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,     0,     0,   448,     0,     0,   449,   450,     0,     0,
       0,   451,     0,     0,   452,   453,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,   461,   462,   463,     0,
     464,   465,     0,   466,     0,   467,   468,   469,   470,     0,
    1026,   471,   472,     0,   473,   474,   475,   476,     0,     0,
       0,     0,     0,   477,   478,   479,     0,     0,     0,   480,
     481,   482,   483,     0,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,   490,     0,     0,   491,     0,   492,
       0,   493,   494,   495,     0,     0,     0,     0,     0,     0,
     496,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,   503,   504,     0,     0,     0,     0,     0,     0,
     505,   506,     0,   507,   508,   509,     0,   141,   510,   142,
     143,   144,   145,   146,   147,     0,     0,   148,     0,     0,
       0,   149,     0,     0,   150,     0,   151,   152,   153,   154,
     155,   156,   157,   158,     0,   159,     0,     0,     0,   160,
       0,     0,     0,   161,     0,     0,   162,   163,   164,     0,
     165,     0,   166,   167,     0,     0,   168,     0,     0,   169,
     170,     0,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,   184,   185,
     186,   187,   188,     0,   189,   190,   191,   192,   193,   194,
     195,   196,     0,   197,   198,     0,   199,   200,   201,   202,
     203,     0,   204,     0,     0,   205,     0,     0,   206,     0,
     207,     0,     0,   208,     0,   209,     0,     0,     0,   210,
     211,   212,     0,     0,   213,     0,     0,     0,     0,   214,
     215,     0,     0,     0,     0,   216,     0,   217,     0,     0,
       0,   218,     0,   219,   220,   221,   222,   223,     0,     0,
       0,   224,     0,     0,   225,   226,   227,     0,     0,     0,
     228,     0,   229,   230,     0,   231,   232,   233,     0,     0,
     234,   235,     0,   236,   237,   238,   239,   240,   241,   242,
       0,     0,   243,   244,   245,     0,     0,   246,   247,     0,
     248,   249,   250,     0,     0,   251,     0,     0,     0,   252,
       0,   253,     0,   254,     0,   255,   256,   257,   258,   259,
     260,   261,     0,   262,     0,     0,     0,   263,   264,   265,
       0,   266,     0,     0,     0,   267,   268,     0,     0,     0,
     269,   270,   271,   272,   273,     0,     0,   274,   275,   276,
       0,   277,     0,   278,     0,     0,     0,     0,   279,   280,
       0,     0,     0,   281,     0,   282,   283,     0,   284,   285,
       0,     0,     0,   286,     0,     0,   287,   288,   289,     0,
       0,   290,     0,     0,   291,   292,     0,     0,     0,     0,
       0,   293,   294,     0,   295,     0,   296,     0,   297,   298,
       0,     0,  2006,     0,     0,     0,     0,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,     0,   315,   316,   317,   318,     0,   319,
     320,   321,   322,     0,   323,   324,     0,     0,     0,     0,
     325,   326,   327,   328,   329,   330,     0,     0,   331,   332,
       0,   333,     0,   334,     0,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,   344,   345,     0,     0,
     346,   347,   348,   349,     0,     0,     0,   350,   351,     0,
       0,  2007,   352,     0,   353,   354,   355,     0,   356,   357,
     358,   359,     0,   360,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,   363,   364,     0,   758,   365,     0,
     366,     0,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,     0,   380,     0,
     381,   382,   383,   384,   385,     0,   386,   387,   388,     0,
       0,   389,     0,     0,     0,   390,   391,   392,   393,   394,
       0,     0,   395,   396,   397,   398,   399,     0,   400,   401,
       0,   402,   403,   404,     0,     0,   405,     0,   406,     0,
     407,   408,     0,   409,   410,     0,   411,     0,   412,     0,
       0,   413,   414,   415,   416,  2008,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,     0,     0,     0,   427,
     428,   429,   430,     0,     0,     0,   431,     0,     0,     0,
     432,     0,   433,   434,   435,   436,   437,   438,     0,   439,
     440,   441,   442,   443,   444,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,     0,     0,   448,     0,     0,
     449,   450,     0,     0,     0,   451,     0,     0,   452,   453,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
     461,   462,   463,     0,   464,   465,     0,   466,     0,   467,
     468,   469,   470,     0,     0,   471,   472,     0,   473,   474,
     475,   476,     0,     0,     0,     0,     0,   477,   478,   479,
       0,     0,     0,   480,   481,   482,   483,  2009,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,   490,     0,
       0,   491,     0,   492,     0,   493,   494,   495,     0,     0,
       0,     0,     0,     0,   496,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,   503,   504,     0,     0,
       0,     0,     0,     0,   505,   506,     0,   507,   508,   509,
       0,   141,   510,   142,   143,   144,   145,   146,   147,     0,
       0,   148,     0,     0,     0,   149,     0,     0,   150,     0,
     151,   152,   153,   154,   155,   156,   157,   158,     0,   159,
       0,     0,     0,   160,     0,     0,     0,   161,     0,     0,
     162,   163,   164,     0,   165,     0,   166,   167,     0,     0,
     168,     0,     0,   169,   170,     0,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,     0,
     182,   183,   184,   185,   186,   187,   188,     0,   189,   190,
     191,   192,   193,   194,   195,   196,     0,   197,   198,     0,
     199,   200,   201,   202,   203,     0,   204,     0,     0,   205,
       0,     0,   206,     0,   207,     0,     0,   208,     0,   209,
       0,     0,     0,   210,   211,   212,     0,     0,   213,     0,
       0,     0,     0,   214,   215,     0,     0,     0,     0,   216,
       0,   217,     0,     0,     0,   218,     0,   219,   220,   221,
     222,   223,     0,     0,     0,   224,     0,     0,   225,   226,
     227,     0,     0,     0,   228,     0,   229,   230,     0,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
     239,   240,   241,   242,     0,     0,   243,   244,   245,     0,
       0,   246,   247,     0,   248,   249,   250,     0,     0,   251,
       0,     0,     0,   252,     0,   253,     0,   254,     0,   255,
     256,   257,   258,   259,   260,   261,     0,   262,     0,     0,
       0,   263,   264,   265,     0,   266,     0,     0,     0,   267,
     268,     0,     0,     0,   269,   270,   271,   272,   273,     0,
       0,   274,   275,   276,     0,   277,     0,   278,     0,     0,
       0,     0,   279,   280,     0,     0,     0,   281,     0,   282,
     283,     0,   284,   285,     0,     0,     0,   286,     0,     0,
     287,   288,   289,     0,     0,   290,     0,     0,   291,   292,
       0,     0,     0,     0,     0,   293,   294,     0,   295,     0,
     296,     0,   297,   298,     0,     0,  2006,     0,     0,     0,
       0,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,     0,   315,   316,
     317,   318,     0,   319,   320,   321,   322,     0,   323,   324,
       0,     0,     0,     0,   325,   326,   327,   328,   329,   330,
       0,     0,   331,   332,     0,   333,     0,   334,     0,   335,
     336,   337,   338,   339,   340,   341,   342,   343,     0,     0,
     344,   345,     0,     0,   346,   347,   348,   349,     0,     0,
       0,   350,   351,     0,     0,  2007,   352,     0,   353,   354,
     355,     0,   356,   357,   358,   359,     0,   360,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,   363,   364,
       0,   758,   365,     0,   366,     0,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,     0,     0,   377,   378,
     379,     0,   380,     0,   381,   382,   383,   384,   385,     0,
     386,   387,   388,     0,     0,   389,     0,     0,     0,   390,
     391,   392,   393,   394,     0,     0,   395,   396,   397,   398,
     399,     0,   400,   401,     0,   402,   403,   404,     0,     0,
     405,     0,   406,     0,   407,   408,     0,   409,   410,     0,
     411,     0,   412,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
       0,     0,     0,   427,   428,   429,   430,     0,     0,     0,
     431,     0,     0,     0,   432,     0,   433,   434,   435,   436,
     437,   438,     0,   439,   440,   441,   442,   443,   444,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,     0,
       0,   448,     0,     0,   449,   450,     0,     0,     0,   451,
       0,     0,   452,   453,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   460,   461,   462,   463,     0,   464,   465,
       0,   466,     0,   467,   468,   469,   470,     0,     0,   471,
     472,     0,   473,   474,   475,   476,     0,     0,     0,     0,
       0,   477,   478,   479,     0,     0,     0,   480,   481,   482,
     483,  2009,   484,   485,     0,   486,   487,     0,   488,   489,
       0,     0,   490,     0,     0,   491,     0,   492,     0,   493,
     494,   495,     0,     0,     0,     0,     0,     0,   496,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
     503,   504,     0,     0,     0,     0,     0,     0,   505,   506,
       0,   507,   508,   509,     0,   141,   510,   142,   143,   144,
     145,   146,   147,     0,     0,   148,     0,     0,     0,   149,
       0,     0,   150,     0,   151,   152,   153,   154,   155,   156,
     157,   158,     0,   159,     0,     0,  1444,   160,     0,     0,
       0,   161,     0,     0,   162,   163,   164,     0,   165,     0,
     166,   167,     0,     0,   168,     0,     0,   169,   170,     0,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,   184,   185,   186,   187,
     188,     0,   189,   190,   191,   192,   193,   194,   195,   196,
       0,   197,   198,     0,   199,   200,   201,   202,   203,     0,
     204,     0,     0,   205,     0,     0,   206,     0,   207,     0,
       0,   208,     0,   209,     0,     0,     0,   210,   211,   212,
       0,     0,   213,     0,     0,     0,     0,   214,   215,     0,
       0,     0,  1445,   216,     0,   217,     0,     0,     0,   218,
       0,   219,   220,   221,   222,   223,     0,     0,     0,   224,
       0,     0,   225,   226,   227,     0,     0,     0,   228,     0,
     229,   230,     0,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,   239,   240,   241,   242,     0,     0,
     243,   244,   245,     0,     0,   246,   247,     0,   248,   249,
     250,     0,     0,   251,     0,     0,     0,   252,     0,   253,
       0,   254,     0,   255,   256,   257,   258,   259,   260,   261,
       0,   262,     0,     0,     0,   263,   264,   265,     0,   266,
       0,     0,     0,   267,   268,     0,     0,     0,   269,   270,
     271,   272,   273,     0,     0,   274,   275,   276,     0,   277,
       0,   278,     0,     0,     0,     0,   279,   280,     0,     0,
       0,   281,     0,   282,   283,     0,   284,   285,     0,     0,
       0,   286,     0,     0,   287,   288,   289,     0,     0,   290,
       0,     0,   291,   292,   640,     0,     0,     0,     0,   293,
     294,     0,   295,     0,   296,     0,   297,   298,     0,     0,
       0,     0,     0,     0,     0,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,     0,   315,   316,   317,   318,     0,   319,   320,   321,
     322,     0,   323,   324,     0,     0,     0,     0,   325,   326,
     327,   328,   329,   330,     0,     0,   331,   332,     0,   333,
       0,   334,     0,   335,   336,   337,   338,   339,   340,   341,
     342,   343,     0,     0,   344,   345,     0,     0,   346,   347,
     348,   349,     0,     0,     0,   350,   351,     0,     0,     0,
     352,     0,   353,   354,   355,     0,   356,   357,   358,   359,
       0,   360,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,   363,   364,     0,     0,   365,     0,   366,     0,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,     0,   380,     0,   381,   382,
     383,   384,   385,     0,   386,   387,   388,     0,     0,   389,
       0,     0,     0,   390,   391,   392,   393,   394,     0,     0,
     395,   396,   397,   398,   399,     0,   400,   401,     0,   402,
     403,   404,     0,     0,   405,     0,   406,     0,   407,   408,
       0,   409,   410,     0,   411,     0,   412,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,     0,     0,   431,     0,     0,     0,   432,     0,
     433,   434,   435,   436,   437,   438,     0,   439,   440,   441,
     442,   443,   444,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,     0,     0,   448,     0,     0,   449,   450,
       0,     0,     0,   451,     0,     0,   452,   453,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,   461,   462,
     463,     0,   464,   465,     0,   466,     0,   467,   468,   469,
     470,     0,   138,   471,   472,     0,   473,   474,   475,   476,
       0,     0,     0,     0,     0,   477,   478,   479,     0,     0,
       0,   480,   481,   482,   483,     0,   484,   485,     0,   486,
     487,     0,   488,   489,     0,     0,   490,     0,     0,   491,
       0,   492,     0,   493,   494,   495,     0,     0,     0,     0,
       0,     0,   496,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,   503,   504,     0,     0,     0,     0,
       0,     0,   505,   506,     0,   507,   508,   509,     0,   141,
     510,   142,   143,   144,   145,   146,   147,     0,     0,   148,
       0,     0,     0,   149,     0,     0,   150,     0,   151,   152,
     153,   154,   155,   156,   157,   158,     0,   159,     0,     0,
       0,   160,     0,     0,     0,   161,     0,     0,   162,   163,
     164,     0,   165,     0,   166,   167,     0,     0,   168,     0,
       0,   169,   170,     0,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,     0,   182,   183,
     184,   185,   186,   187,   188,     0,   189,   190,   191,   192,
     193,   194,   195,   196,     0,   197,   198,     0,   199,   200,
     201,   202,   203,     0,   204,     0,     0,   205,     0,     0,
     206,     0,   207,     0,     0,   208,     0,   209,     0,     0,
       0,   210,   211,   212,     0,     0,   213,     0,     0,     0,
       0,   214,   215,     0,     0,     0,     0,   216,     0,   217,
       0,     0,     0,   218,     0,   219,   220,   221,   222,   223,
       0,     0,     0,   224,     0,     0,   225,   226,   227,     0,
       0,     0,   228,     0,   229,   230,     0,   231,   232,   233,
       0,     0,   234,   235,     0,   236,   237,   238,   239,   240,
     241,   242,     0,     0,   243,   244,   245,     0,     0,   246,
     247,     0,   248,   249,   250,     0,     0,   251,     0,     0,
       0,   252,     0,   253,     0,   254,     0,   255,   256,   257,
     258,   259,   260,   261,     0,   262,     0,     0,     0,   263,
     264,   265,     0,   266,     0,     0,     0,   267,   268,     0,
       0,     0,   269,   270,   271,   272,   273,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,     0,     0,     0,
     279,   280,     0,     0,     0,   281,     0,   282,   283,     0,
     284,   285,     0,     0,     0,   286,     0,     0,   287,   288,
     289,     0,     0,   290,     0,     0,   291,   292,     0,     0,
       0,     0,     0,   293,   294,     0,   295,     0,   296,     0,
     297,   298,     0,     0,  2006,     0,     0,     0,     0,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,     0,   315,   316,   317,   318,
       0,   319,   320,   321,   322,     0,   323,   324,     0,     0,
       0,     0,   325,   326,   327,   328,   329,   330,     0,     0,
     331,   332,     0,   333,     0,   334,     0,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,   344,   345,
       0,     0,   346,   347,   348,   349,     0,     0,     0,   350,
     351,     0,     0,  2007,   352,     0,   353,   354,   355,     0,
     356,   357,   358,   359,     0,   360,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,   363,   364,     0,   758,
     365,     0,   366,     0,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,     0,     0,   377,   378,   379,     0,
     380,     0,   381,   382,   383,   384,   385,     0,   386,   387,
     388,     0,     0,   389,     0,     0,     0,   390,   391,   392,
     393,   394,     0,     0,   395,   396,   397,   398,   399,     0,
     400,   401,     0,   402,   403,   404,     0,     0,   405,     0,
     406,     0,   407,   408,     0,   409,   410,     0,   411,     0,
     412,     0,     0,   413,   414,   415,   416,  4017,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,     0,     0,
       0,   427,   428,   429,   430,     0,     0,     0,   431,     0,
       0,     0,   432,     0,   433,   434,   435,   436,   437,   438,
       0,   439,   440,   441,   442,   443,   444,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,     0,     0,   448,
       0,     0,   449,   450,     0,     0,     0,   451,     0,     0,
     452,   453,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,   461,   462,   463,     0,   464,   465,     0,   466,
       0,   467,   468,   469,   470,     0,     0,   471,   472,     0,
     473,   474,   475,   476,     0,     0,     0,     0,     0,   477,
     478,   479,     0,     0,     0,   480,   481,   482,   483,  2009,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
     490,     0,     0,   491,     0,   492,     0,   493,   494,   495,
       0,     0,     0,     0,     0,     0,   496,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,   503,   504,
       0,     0,     0,     0,     0,     0,   505,   506,     0,   507,
     508,   509,     0,   141,   510,   142,   143,   144,   145,   146,
     147,     0,     0,   148,     0,     0,     0,   149,     0,     0,
     150,     0,   151,   152,   153,   154,   155,   156,   157,   158,
       0,   159,     0,     0,     0,   160,     0,     0,     0,   161,
       0,     0,   162,   163,   164,     0,   165,     0,   166,   167,
       0,     0,   168,     0,     0,   169,   170,     0,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,     0,   182,   183,   184,   185,   186,   187,   188,     0,
     189,   190,   191,   192,   193,   194,   195,   196,     0,   197,
     198,     0,   199,   200,   201,   202,   203,     0,   204,     0,
       0,   205,     0,     0,   206,     0,   207,     0,   848,   208,
       0,   209,     0,     0,     0,   210,   211,   212,     0,     0,
     213,     0,     0,     0,     0,   214,   215,     0,     0,     0,
       0,   216,     0,   217,     0,     0,     0,   218,     0,   219,
     220,   221,   222,   223,     0,     0,     0,   224,     0,     0,
     225,   226,   227,     0,     0,     0,   228,     0,   229,   230,
       0,   231,   232,   233,     0,     0,   234,   235,     0,   236,
     237,   238,   239,   240,   241,   242,     0,     0,   243,   244,
     245,     0,     0,   246,   247,     0,   248,   249,   250,     0,
       0,   251,     0,     0,     0,   252,     0,   253,     0,   254,
       0,   255,   256,   257,   258,   259,   260,   261,     0,   262,
       0,     0,     0,   263,   264,   265,     0,   266,     0,     0,
       0,   267,   268,     0,     0,     0,   269,   270,   271,   272,
     273,     0,     0,   274,   275,   276,     0,   277,     0,   278,
       0,     0,     0,     0,   279,   280,     0,     0,     0,   281,
       0,   282,   283,     0,   284,   285,     0,     0,     0,   286,
       0,     0,   287,   288,   289,     0,     0,   290,     0,     0,
     291,   292,   640,     0,     0,     0,     0,   293,   294,     0,
     295,     0,   296,     0,   297,   298,     0,     0,     0,     0,
       0,     0,     0,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,     0,
     315,   316,   317,   318,     0,   319,   320,   321,   322,     0,
     323,   324,     0,     0,     0,     0,   325,   326,   327,   328,
     329,   330,     0,     0,   331,   332,     0,   333,     0,   334,
       0,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,   344,   345,     0,     0,   346,   347,   348,   349,
       0,     0,     0,   350,   351,     0,     0,     0,   352,     0,
     353,   354,   355,     0,   356,   357,   358,   359,     0,   360,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
     363,   364,     0,     0,   365,     0,   366,     0,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,     0,   380,     0,   381,   382,   383,   384,
     385,     0,   386,   387,   388,     0,     0,   389,     0,     0,
       0,   390,   391,   392,   393,   394,     0,     0,   395,   396,
     397,   398,   399,     0,   400,   401,     0,   402,   403,   404,
       0,     0,   405,     0,   406,     0,   407,   408,     0,   409,
     410,     0,   411,     0,   412,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,     0,     0,     0,   427,   428,   429,   430,     0,
       0,     0,   431,     0,     0,     0,   432,     0,   433,   434,
     435,   436,   437,   438,     0,   439,   440,   441,   442,   443,
     444,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,     0,     0,   448,     0,     0,   449,   450,     0,     0,
       0,   451,     0,     0,   452,   453,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,   461,   462,   463,     0,
     464,   465,     0,   466,     0,   467,   468,   469,   470,     0,
     138,   471,   472,     0,   473,   474,   475,   476,     0,     0,
       0,     0,     0,   477,   478,   479,     0,     0,     0,   480,
     481,   482,   483,     0,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,   490,     0,     0,   491,     0,   492,
       0,   493,   494,   495,     0,     0,     0,     0,     0,     0,
     496,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,   503,   504,     0,     0,     0,     0,     0,     0,
     505,   506,     0,   507,   508,   509,     0,   141,   510,   142,
     143,   144,   145,   146,   147,     0,     0,   148,     0,     0,
       0,   149,     0,     0,   150,     0,   151,   152,   153,   154,
     155,   156,   157,   158,     0,   159,     0,     0,     0,   160,
       0,     0,     0,   161,     0,     0,   162,   163,   164,     0,
     165,     0,   166,   167,     0,     0,   168,     0,     0,   169,
     170,     0,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,   184,   185,
     186,   187,   188,     0,   189,   190,   191,   192,   193,   194,
     195,   196,     0,   197,   198,     0,   199,   200,   201,   202,
     203,     0,   204,     0,     0,   205,     0,     0,   206,     0,
     207,  1046,     0,   208,     0,   209,     0,     0,     0,   210,
     211,   212,     0,     0,   213,     0,     0,     0,     0,   214,
     215,     0,     0,     0,     0,   216,     0,   217,     0,     0,
       0,   218,     0,   219,   220,   221,   222,   223,     0,     0,
       0,   224,     0,     0,   225,   226,   227,     0,     0,     0,
     228,     0,   229,   230,     0,   231,   232,   233,     0,     0,
     234,   235,     0,   236,   237,   238,   239,   240,   241,   242,
       0,     0,   243,   244,   245,     0,     0,   246,   247,     0,
     248,   249,   250,     0,     0,   251,     0,     0,     0,   252,
       0,   253,     0,   254,     0,   255,   256,   257,   258,   259,
     260,   261,     0,   262,     0,     0,     0,   263,   264,   265,
       0,   266,     0,     0,     0,   267,   268,     0,     0,     0,
     269,   270,   271,   272,   273,     0,     0,   274,   275,   276,
       0,   277,     0,   278,     0,     0,     0,     0,   279,   280,
       0,     0,     0,   281,     0,   282,   283,     0,   284,   285,
       0,     0,     0,   286,     0,     0,   287,   288,   289,     0,
       0,   290,     0,     0,   291,   292,   640,     0,     0,     0,
       0,   293,   294,     0,   295,     0,   296,     0,   297,   298,
       0,     0,     0,     0,     0,     0,     0,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,     0,   315,   316,   317,   318,     0,   319,
     320,   321,   322,     0,   323,   324,     0,     0,     0,     0,
     325,   326,   327,   328,   329,   330,     0,     0,   331,   332,
       0,   333,     0,   334,     0,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,   344,   345,     0,     0,
     346,   347,   348,   349,     0,     0,     0,   350,   351,     0,
       0,     0,   352,     0,   353,   354,   355,     0,   356,   357,
     358,   359,     0,   360,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,   363,   364,     0,     0,   365,     0,
     366,     0,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,     0,   380,     0,
     381,   382,   383,   384,   385,     0,   386,   387,   388,     0,
       0,   389,     0,     0,     0,   390,   391,   392,   393,   394,
       0,     0,   395,   396,   397,   398,   399,     0,   400,   401,
       0,   402,   403,   404,     0,     0,   405,     0,   406,     0,
     407,   408,     0,   409,   410,     0,   411,     0,   412,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,     0,     0,     0,   427,
     428,   429,   430,     0,     0,     0,   431,     0,     0,     0,
     432,     0,   433,   434,   435,   436,   437,   438,     0,   439,
     440,   441,   442,   443,   444,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,     0,     0,   448,     0,     0,
     449,   450,     0,     0,     0,   451,     0,     0,   452,   453,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
     461,   462,   463,     0,   464,   465,     0,   466,     0,   467,
     468,   469,   470,     0,   138,   471,   472,     0,   473,   474,
     475,   476,     0,     0,     0,     0,     0,   477,   478,   479,
       0,     0,     0,   480,   481,   482,   483,     0,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,   490,     0,
       0,   491,     0,   492,     0,   493,   494,   495,     0,     0,
       0,     0,     0,     0,   496,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,   503,   504,     0,     0,
       0,     0,     0,     0,   505,   506,     0,   507,   508,   509,
       0,   141,   510,   142,   143,   144,   145,   146,   147,  1481,
       0,   148,     0,     0,     0,   149,     0,     0,   150,     0,
     151,   152,   153,   154,   155,   156,   157,   158,     0,   159,
       0,     0,     0,   160,     0,     0,     0,   161,     0,     0,
     162,   163,   164,     0,   165,     0,   166,   167,     0,     0,
     168,     0,     0,   169,   170,     0,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,     0,
     182,   183,   184,   185,   186,   187,   188,     0,   189,   190,
     191,   192,   193,   194,   195,   196,     0,   197,   198,     0,
     199,   200,   201,   202,   203,     0,   204,     0,     0,   205,
       0,     0,   206,     0,   207,     0,     0,   208,     0,   209,
       0,     0,     0,   210,   211,   212,     0,     0,   213,     0,
       0,     0,     0,   214,   215,     0,     0,     0,     0,   216,
       0,   217,     0,     0,     0,   218,     0,   219,   220,   221,
     222,   223,     0,     0,     0,   224,     0,     0,   225,   226,
     227,     0,     0,     0,   228,     0,   229,   230,     0,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
     239,   240,   241,   242,     0,     0,   243,   244,   245,     0,
       0,   246,   247,     0,   248,   249,   250,     0,     0,   251,
       0,     0,     0,   252,     0,   253,     0,   254,     0,   255,
     256,   257,   258,   259,   260,   261,     0,   262,     0,     0,
       0,   263,   264,   265,     0,   266,     0,     0,     0,   267,
     268,     0,     0,     0,   269,   270,   271,   272,   273,     0,
       0,   274,   275,   276,     0,   277,     0,   278,     0,     0,
       0,     0,   279,   280,     0,     0,     0,   281,     0,   282,
     283,     0,   284,   285,     0,     0,     0,   286,     0,     0,
     287,   288,   289,     0,     0,   290,     0,     0,   291,   292,
     640,     0,     0,     0,     0,   293,   294,     0,   295,     0,
     296,     0,   297,   298,     0,     0,     0,     0,     0,     0,
       0,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,     0,   315,   316,
     317,   318,     0,   319,   320,   321,   322,     0,   323,   324,
       0,     0,     0,     0,   325,   326,   327,   328,   329,   330,
       0,     0,   331,   332,     0,   333,     0,   334,     0,   335,
     336,   337,   338,   339,   340,   341,   342,   343,     0,     0,
     344,   345,     0,     0,   346,   347,   348,   349,     0,     0,
       0,   350,   351,     0,     0,     0,   352,     0,   353,   354,
     355,     0,   356,   357,   358,   359,     0,   360,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,   363,   364,
       0,     0,   365,     0,   366,     0,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,     0,     0,   377,   378,
     379,     0,   380,     0,   381,   382,   383,   384,   385,     0,
     386,   387,   388,     0,     0,   389,     0,     0,     0,   390,
     391,   392,   393,   394,     0,     0,   395,   396,   397,   398,
     399,     0,   400,   401,     0,   402,   403,   404,     0,     0,
     405,     0,   406,     0,   407,   408,     0,   409,   410,     0,
     411,     0,   412,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
       0,     0,     0,   427,   428,   429,   430,     0,     0,     0,
     431,     0,     0,     0,   432,     0,   433,   434,   435,   436,
     437,   438,     0,   439,   440,   441,   442,   443,   444,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,     0,
       0,   448,     0,     0,   449,   450,     0,     0,     0,   451,
       0,     0,   452,   453,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   460,   461,   462,   463,     0,   464,   465,
       0,   466,     0,   467,   468,   469,   470,     0,   138,   471,
     472,     0,   473,   474,   475,   476,     0,     0,     0,     0,
       0,   477,   478,   479,     0,     0,     0,   480,   481,   482,
     483,     0,   484,   485,     0,   486,   487,     0,   488,   489,
       0,     0,   490,     0,     0,   491,     0,   492,     0,   493,
     494,   495,     0,     0,     0,     0,     0,     0,   496,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
     503,   504,     0,     0,     0,     0,     0,     0,   505,   506,
       0,   507,   508,   509,     0,   141,   510,   142,   143,   144,
     145,   146,   147,     0,     0,   148,     0,     0,     0,   149,
       0,     0,   150,     0,   151,   152,   153,   154,   155,   156,
     157,   158,     0,   159,     0,     0,     0,   160,     0,     0,
       0,   161,     0,     0,   162,   163,   164,     0,   165,     0,
     166,   167,     0,     0,   168,     0,     0,   169,   170,     0,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,   184,   185,   186,   187,
     188,     0,   189,   190,   191,   192,   193,   194,   195,   196,
       0,   197,   198,     0,   199,   200,   201,   202,   203,     0,
     204,     0,     0,   205,     0,     0,   206,     0,   207,     0,
       0,   208,     0,   209,     0,     0,     0,   210,   211,   212,
       0,     0,   213,     0,     0,     0,     0,   214,   215,     0,
       0,     0,  2469,   216,     0,   217,     0,     0,     0,   218,
       0,   219,   220,   221,   222,   223,     0,     0,     0,   224,
       0,     0,   225,   226,   227,     0,     0,     0,   228,     0,
     229,   230,     0,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,   239,   240,   241,   242,     0,     0,
     243,   244,   245,     0,     0,   246,   247,     0,   248,   249,
     250,     0,     0,   251,     0,     0,     0,   252,     0,   253,
       0,   254,     0,   255,   256,   257,   258,   259,   260,   261,
       0,   262,     0,     0,     0,   263,   264,   265,     0,   266,
       0,     0,     0,   267,   268,     0,     0,     0,   269,   270,
     271,   272,   273,     0,     0,   274,   275,   276,     0,   277,
       0,   278,     0,     0,     0,     0,   279,   280,     0,     0,
       0,   281,     0,   282,   283,     0,   284,   285,     0,     0,
       0,   286,     0,     0,   287,   288,   289,     0,     0,   290,
       0,     0,   291,   292,   640,     0,     0,     0,     0,   293,
     294,     0,   295,     0,   296,     0,   297,   298,     0,     0,
       0,     0,     0,     0,     0,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,     0,   315,   316,   317,   318,     0,   319,   320,   321,
     322,     0,   323,   324,     0,     0,     0,     0,   325,   326,
     327,   328,   329,   330,     0,     0,   331,   332,     0,   333,
       0,   334,     0,   335,   336,   337,   338,   339,   340,   341,
     342,   343,     0,     0,   344,   345,     0,     0,   346,   347,
     348,   349,     0,     0,     0,   350,   351,     0,     0,     0,
     352,     0,   353,   354,   355,     0,   356,   357,   358,   359,
       0,   360,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,   363,   364,     0,     0,   365,     0,   366,     0,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,     0,   380,     0,   381,   382,
     383,   384,   385,     0,   386,   387,   388,     0,     0,   389,
       0,     0,     0,   390,   391,   392,   393,   394,     0,     0,
     395,   396,   397,   398,   399,     0,   400,   401,     0,   402,
     403,   404,     0,     0,   405,     0,   406,     0,   407,   408,
       0,   409,   410,     0,   411,     0,   412,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,     0,     0,   431,     0,     0,     0,   432,     0,
     433,   434,   435,   436,   437,   438,     0,   439,   440,   441,
     442,   443,   444,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,     0,     0,   448,     0,     0,   449,   450,
       0,     0,     0,   451,     0,     0,   452,   453,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,   461,   462,
     463,     0,   464,   465,     0,   466,     0,   467,   468,   469,
     470,     0,   138,   471,   472,     0,   473,   474,   475,   476,
       0,     0,     0,     0,     0,   477,   478,   479,     0,     0,
       0,   480,   481,   482,   483,     0,   484,   485,     0,   486,
     487,     0,   488,   489,     0,     0,   490,     0,     0,   491,
       0,   492,     0,   493,   494,   495,     0,     0,     0,     0,
       0,     0,   496,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,   503,   504,     0,     0,     0,     0,
       0,     0,   505,   506,     0,   507,   508,   509,     0,   141,
     510,   142,   143,   144,   145,   146,   147,     0,     0,   148,
       0,     0,     0,   149,     0,     0,   150,     0,   151,   152,
     153,   154,   155,   156,   157,   158,     0,   159,     0,     0,
    1444,   160,     0,     0,     0,   161,     0,     0,   162,   163,
     164,     0,   165,     0,   166,   167,     0,     0,   168,     0,
       0,   169,   170,     0,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,     0,   182,   183,
     184,   185,   186,   187,   188,     0,   189,   190,   191,   192,
     193,   194,   195,   196,     0,   197,   198,     0,   199,   200,
     201,   202,   203,     0,   204,     0,     0,   205,     0,     0,
     206,     0,   207,     0,     0,   208,     0,   209,     0,     0,
       0,   210,   211,   212,     0,     0,   213,     0,     0,     0,
       0,   214,   215,     0,     0,     0,     0,   216,     0,   217,
       0,     0,     0,   218,     0,   219,   220,   221,   222,   223,
       0,     0,     0,   224,     0,     0,   225,   226,   227,     0,
       0,     0,   228,     0,   229,   230,     0,   231,   232,   233,
       0,     0,   234,   235,     0,   236,   237,   238,   239,   240,
     241,   242,     0,     0,   243,   244,   245,     0,     0,   246,
     247,     0,   248,   249,   250,     0,     0,   251,     0,     0,
       0,   252,     0,   253,     0,   254,     0,   255,   256,   257,
     258,   259,   260,   261,     0,   262,     0,     0,     0,   263,
     264,   265,     0,   266,     0,     0,     0,   267,   268,     0,
       0,     0,   269,   270,   271,   272,   273,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,     0,     0,     0,
     279,   280,     0,     0,     0,   281,     0,   282,   283,     0,
     284,   285,     0,     0,     0,   286,     0,     0,   287,   288,
     289,     0,     0,   290,     0,     0,   291,   292,   640,     0,
       0,     0,     0,   293,   294,     0,   295,     0,   296,     0,
     297,   298,     0,     0,     0,     0,     0,     0,     0,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,     0,   315,   316,   317,   318,
       0,   319,   320,   321,   322,     0,   323,   324,     0,     0,
       0,     0,   325,   326,   327,   328,   329,   330,     0,     0,
     331,   332,     0,   333,     0,   334,     0,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,   344,   345,
       0,     0,   346,   347,   348,   349,     0,     0,     0,   350,
     351,     0,     0,     0,   352,     0,   353,   354,   355,     0,
     356,   357,   358,   359,     0,   360,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,   363,   364,     0,     0,
     365,     0,   366,     0,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,     0,     0,   377,   378,   379,     0,
     380,     0,   381,   382,   383,   384,   385,     0,   386,   387,
     388,     0,     0,   389,     0,     0,     0,   390,   391,   392,
     393,   394,     0,     0,   395,   396,   397,   398,   399,     0,
     400,   401,     0,   402,   403,   404,     0,     0,   405,     0,
     406,     0,   407,   408,     0,   409,   410,     0,   411,     0,
     412,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,     0,     0,
       0,   427,   428,   429,   430,     0,     0,     0,   431,     0,
       0,     0,   432,     0,   433,   434,   435,   436,   437,   438,
       0,   439,   440,   441,   442,   443,   444,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,     0,     0,   448,
       0,     0,   449,   450,     0,     0,     0,   451,     0,     0,
     452,   453,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,   461,   462,   463,     0,   464,   465,     0,   466,
       0,   467,   468,   469,   470,     0,   138,   471,   472,     0,
     473,   474,   475,   476,     0,     0,     0,     0,     0,   477,
     478,   479,     0,     0,     0,   480,   481,   482,   483,     0,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
     490,     0,     0,   491,     0,   492,     0,   493,   494,   495,
       0,     0,     0,     0,     0,     0,   496,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,   503,   504,
       0,     0,     0,     0,     0,     0,   505,   506,     0,   507,
     508,   509,     0,   141,   510,   142,   143,   144,   145,   146,
     147,     0,     0,   148,     0,     0,     0,   149,     0,     0,
     150,     0,   151,   152,   153,   154,   155,   156,   157,   158,
       0,   159,     0,     0,     0,   160,     0,     0,     0,   161,
       0,     0,   162,   163,   164,     0,   165,     0,   166,   167,
       0,     0,   168,     0,     0,   169,   170,     0,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,     0,   182,   183,   184,   185,   186,   187,   188,     0,
     189,   190,   191,   192,   193,   194,   195,   196,     0,   197,
     198,     0,   199,   200,   201,   202,   203,     0,   204,     0,
       0,   205,     0,     0,   206,     0,   207,     0,     0,   208,
       0,   209,     0,     0,     0,   210,   211,   212,     0,     0,
     213,     0,     0,     0,     0,   214,   215,     0,     0,     0,
       0,   216,     0,   217,     0,     0,     0,   218,     0,   219,
     220,   221,   222,   223,     0,     0,     0,   224,     0,     0,
     225,   226,   227,     0,     0,     0,   228,     0,   229,   230,
       0,   231,   232,   233,     0,     0,   234,   235,     0,   236,
     237,   238,   239,   240,   241,   242,     0,     0,   243,   244,
     245,     0,     0,   246,   247,     0,   248,   249,   250,     0,
       0,   251,     0,     0,     0,   252,     0,   253,     0,   254,
       0,   255,   256,   257,   258,   259,   260,   261,     0,   262,
       0,     0,     0,   263,   264,   265,     0,   266,     0,     0,
       0,   267,   268,     0,     0,     0,   269,   270,   271,   272,
     273,     0,     0,   274,   275,   276,     0,   277,     0,   278,
       0,     0,     0,     0,   279,   280,     0,     0,     0,   281,
       0,   282,   283,     0,   284,   285,     0,     0,     0,   286,
       0,     0,   287,   288,   289,     0,     0,   290,     0,     0,
     291,   292,   640,     0,     0,     0,     0,   293,   294,     0,
     295,     0,   296,     0,   297,   298,     0,     0,     0,     0,
       0,     0,     0,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,     0,
     315,   316,   317,   318,     0,   319,   320,   321,   322,     0,
     323,   324,     0,     0,     0,     0,   325,   326,   327,   328,
     329,   330,     0,     0,   331,   332,     0,   333,     0,   334,
       0,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,   344,   345,     0,     0,   346,   347,   348,   349,
       0,     0,     0,   350,   351,     0,     0,     0,   352,     0,
     353,   354,   355,     0,   356,   357,   358,   359,     0,   360,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
     363,   364,     0,     0,   365,     0,   366,     0,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,     0,   380,     0,   381,   382,   383,   384,
     385,     0,   386,   387,   388,     0,     0,   389,     0,     0,
       0,   390,   391,   392,   393,   394,     0,     0,   395,   396,
     397,   398,   399,     0,   400,   401,     0,   402,   403,   404,
       0,     0,   405,     0,   406,     0,   407,   408,     0,   409,
     410,     0,   411,     0,   412,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,     0,     0,     0,   427,   428,   429,   430,     0,
       0,     0,   431,     0,     0,     0,   432,     0,   433,   434,
     435,   436,   437,   438,     0,   439,   440,   441,   442,   443,
     444,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,     0,     0,   448,     0,     0,   449,   450,     0,     0,
       0,   451,     0,     0,   452,   453,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,   461,   462,   463,     0,
     464,   465,     0,   466,     0,   467,   468,   469,   470,     0,
     138,   471,   472,     0,   473,   474,   475,   476,     0,     0,
       0,     0,     0,   477,   478,   479,     0,     0,     0,   480,
     481,   482,   483,     0,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,   490,     0,     0,   491,     0,   492,
       0,   493,   494,   495,     0,     0,     0,     0,     0,     0,
     496,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,   503,   504,     0,     0,     0,     0,     0,     0,
     505,   506,     0,   507,   508,   509,     0,   141,   510,   142,
     143,   144,   145,   146,   147,     0,     0,   148,     0,     0,
       0,   149,  2907,     0,   150,     0,   151,   152,   153,   154,
     155,   156,   157,   158,     0,   159,     0,     0,     0,   160,
       0,     0,     0,   161,     0,     0,   162,   163,   164,     0,
     165,     0,   166,   167,     0,     0,   168,     0,     0,   169,
     170,     0,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,   184,   185,
     186,   187,   188,     0,   189,   190,   191,   192,   193,   194,
     195,   196,     0,   197,   198,     0,   199,   200,   201,   202,
     203,     0,   204,     0,     0,   205,     0,     0,   206,     0,
     207,     0,     0,   208,     0,   209,     0,     0,     0,   210,
     211,   212,     0,     0,   213,     0,     0,     0,     0,   214,
     215,     0,     0,     0,     0,   216,     0,   217,     0,     0,
       0,   218,     0,   219,   220,   221,   222,   223,     0,     0,
       0,   224,     0,     0,   225,   226,   227,     0,     0,     0,
     228,     0,   229,   230,     0,   231,   232,   233,     0,     0,
     234,   235,     0,   236,   237,   238,   239,   240,   241,   242,
       0,     0,   243,   244,   245,     0,     0,   246,   247,     0,
     248,   249,   250,     0,     0,   251,     0,     0,     0,   252,
       0,   253,     0,   254,     0,   255,   256,   257,   258,   259,
     260,   261,     0,   262,     0,     0,     0,   263,   264,   265,
       0,   266,     0,     0,     0,   267,   268,     0,     0,     0,
     269,   270,   271,   272,   273,     0,     0,   274,   275,   276,
       0,   277,     0,   278,     0,     0,     0,     0,   279,   280,
       0,     0,     0,   281,     0,   282,   283,     0,   284,   285,
       0,     0,     0,   286,     0,     0,   287,   288,   289,     0,
       0,   290,     0,     0,   291,   292,     0,     0,     0,     0,
       0,   293,   294,     0,   295,     0,   296,     0,   297,   298,
       0,     0,     0,     0,     0,     0,     0,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,     0,   315,   316,   317,   318,     0,   319,
     320,   321,   322,     0,   323,   324,     0,     0,     0,     0,
     325,   326,   327,   328,   329,   330,     0,     0,   331,   332,
       0,   333,     0,   334,     0,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,   344,   345,     0,     0,
     346,   347,   348,   349,     0,     0,     0,   350,   351,     0,
       0,     0,   352,     0,   353,   354,   355,     0,   356,   357,
     358,   359,     0,   360,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,   363,   364,     0,     0,   365,     0,
     366,     0,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,     0,   380,     0,
     381,   382,   383,   384,   385,     0,   386,   387,   388,     0,
       0,   389,     0,     0,     0,   390,   391,   392,   393,   394,
       0,     0,   395,   396,   397,   398,   399,     0,   400,   401,
       0,   402,   403,   404,     0,     0,   405,     0,   406,     0,
     407,   408,     0,   409,   410,     0,   411,     0,   412,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,     0,     0,     0,   427,
     428,   429,   430,     0,     0,     0,   431,     0,     0,     0,
     432,     0,   433,   434,   435,   436,   437,   438,     0,   439,
     440,   441,   442,   443,   444,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,     0,     0,   448,     0,     0,
     449,   450,     0,     0,     0,   451,     0,     0,   452,   453,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
     461,   462,   463,     0,   464,   465,     0,   466,     0,   467,
     468,   469,   470,     0,   138,   471,   472,     0,   473,   474,
     475,   476,     0,     0,     0,     0,     0,   477,   478,   479,
       0,     0,     0,   480,   481,   482,   483,     0,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,   490,     0,
       0,   491,     0,   492,     0,   493,   494,   495,     0,     0,
       0,     0,     0,     0,   496,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,   503,   504,     0,     0,
       0,     0,     0,     0,   505,   506,     0,   507,   508,   509,
       0,   141,   510,   142,   143,   144,   145,   146,   147,     0,
       0,   148,     0,     0,     0,   149,     0,     0,   150,     0,
     151,   152,   153,   154,   155,   156,   157,   158,     0,   159,
       0,     0,     0,   160,     0,     0,     0,   161,     0,     0,
     162,   163,   164,     0,   165,     0,   166,   167,     0,     0,
     168,     0,     0,   169,   170,     0,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,     0,
     182,   183,   184,   185,   186,   187,   188,     0,   189,   190,
     191,   192,   193,   194,   195,   196,     0,   197,   198,     0,
     199,   200,   201,   202,   203,  4657,   204,     0,     0,   205,
       0,     0,   206,     0,   207,     0,     0,   208,     0,   209,
       0,     0,     0,   210,   211,   212,     0,     0,   213,     0,
       0,     0,     0,   214,   215,     0,     0,     0,     0,   216,
       0,   217,     0,     0,     0,   218,     0,   219,   220,   221,
     222,   223,     0,     0,     0,   224,     0,     0,   225,   226,
     227,     0,     0,     0,   228,     0,   229,   230,     0,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
     239,   240,   241,   242,     0,  4658,   243,   244,   245,     0,
       0,   246,   247,     0,   248,   249,   250,     0,     0,   251,
       0,     0,     0,   252,     0,   253,     0,   254,     0,   255,
     256,   257,   258,   259,   260,   261,     0,   262,     0,     0,
       0,   263,   264,   265,     0,   266,     0,     0,     0,   267,
     268,     0,     0,     0,   269,   270,   271,   272,   273,     0,
       0,   274,   275,   276,     0,   277,     0,   278,     0,     0,
       0,     0,   279,   280,     0,     0,     0,   281,     0,   282,
     283,     0,   284,   285,     0,     0,     0,   286,     0,     0,
     287,   288,   289,     0,     0,   290,     0,     0,   291,   292,
       0,     0,     0,     0,     0,   293,   294,     0,   295,     0,
     296,     0,   297,   298,     0,     0,     0,     0,     0,     0,
       0,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,     0,   315,   316,
     317,   318,     0,   319,   320,   321,   322,     0,   323,   324,
       0,     0,     0,     0,   325,   326,   327,   328,   329,   330,
       0,     0,   331,   332,     0,   333,     0,   334,     0,   335,
     336,   337,   338,   339,   340,   341,   342,   343,     0,     0,
     344,   345,     0,     0,   346,   347,   348,   349,     0,     0,
       0,   350,   351,     0,     0,     0,   352,     0,   353,   354,
     355,     0,   356,   357,   358,   359,     0,   360,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,   363,   364,
       0,     0,   365,     0,   366,     0,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,     0,     0,   377,   378,
     379,     0,   380,     0,   381,   382,   383,   384,   385,     0,
     386,   387,   388,     0,     0,   389,     0,     0,     0,   390,
     391,   392,   393,   394,     0,     0,   395,   396,   397,   398,
     399,     0,   400,   401,     0,   402,   403,   404,     0,     0,
     405,     0,   406,     0,   407,   408,     0,   409,   410,     0,
     411,     0,   412,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
       0,     0,     0,   427,   428,   429,   430,     0,     0,     0,
     431,     0,     0,     0,   432,     0,   433,   434,   435,   436,
     437,   438,     0,   439,   440,   441,   442,   443,   444,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,     0,
       0,   448,     0,     0,   449,   450,     0,     0,     0,   451,
       0,     0,   452,   453,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   460,   461,   462,   463,     0,   464,   465,
       0,   466,     0,   467,   468,   469,   470,     0,     0,   471,
     472,     0,   473,   474,   475,   476,     0,     0,     0,     0,
       0,   477,   478,   479,     0,     0,     0,   480,   481,   482,
     483,     0,   484,   485,     0,   486,   487,     0,   488,   489,
       0,     0,   490,     0,     0,   491,     0,   492,     0,   493,
     494,   495,     0,     0,     0,     0,     0,     0,   496,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
     503,   504,     0,     0,     0,     0,     0,     0,   505,   506,
       0,   507,   508,   509,     0,   141,   510,   142,   143,   144,
     145,   146,   147,     0,     0,   148,     0,     0,     0,   149,
       0,     0,   150,     0,   151,   152,   153,   154,   155,   156,
     157,   158,     0,   159,     0,     0,     0,   160,     0,     0,
       0,   161,     0,     0,   162,   163,   164,     0,   165,     0,
     166,   167,     0,     0,   168,     0,     0,   169,   170,     0,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,   184,   185,   186,   187,
     188,     0,   189,   190,   191,   192,   193,   194,   195,   196,
       0,   197,   198,     0,   199,   200,   201,   202,   203,     0,
     204,     0,     0,   205,     0,     0,   206,     0,   207,     0,
       0,   208,     0,   209,     0,     0,     0,   210,   211,   212,
       0,     0,   213,     0,     0,     0,     0,   214,   215,     0,
       0,     0,     0,   216,     0,   217,     0,     0,     0,   218,
       0,   219,   220,   221,   222,   223,     0,     0,     0,   224,
       0,     0,   225,   226,   227,     0,     0,     0,   228,     0,
     229,   230,     0,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,   239,   240,   241,   242,     0,     0,
     243,   244,   245,     0,     0,   246,   247,     0,   248,   249,
     250,     0,     0,   251,     0,     0,     0,   252,     0,   253,
       0,   254,     0,   255,   256,   257,   258,   259,   260,   261,
       0,   262,     0,     0,     0,   263,   264,   265,     0,   266,
       0,     0,     0,   267,   268,     0,     0,     0,   269,   270,
     271,   272,   273,     0,     0,   274,   275,   276,     0,   277,
       0,   278,     0,     0,     0,     0,   279,   280,     0,     0,
       0,   281,     0,   282,   283,     0,   284,   285,     0,     0,
       0,   286,     0,     0,   287,   288,   289,     0,     0,   290,
       0,     0,   291,   292,     0,     0,     0,     0,     0,   293,
     294,     0,   295,     0,   296,     0,   297,   298,     0,     0,
       0,     0,     0,     0,     0,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,     0,   315,   316,   317,   318,     0,   319,   320,   321,
     322,     0,   323,   324,     0,     0,     0,     0,   325,   326,
     327,   328,   329,   330,     0,     0,   331,   332,     0,   333,
       0,   334,     0,   335,   336,   337,   338,   339,   340,   341,
     342,   343,     0,     0,   344,   345,     0,     0,   346,   347,
     348,   349,     0,     0,     0,   350,   351,     0,     0,     0,
     352,     0,   353,   354,   355,     0,   356,   357,   358,   359,
       0,   360,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,   363,   364,     0,     0,   365,     0,   366,     0,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,     0,   380,     0,   381,   382,
     383,   384,   385,     0,   386,   387,   388,     0,     0,   389,
       0,     0,     0,   390,   391,   392,   393,   394,     0,     0,
     395,   396,   397,   398,   399,     0,   400,   401,     0,   402,
     403,   404,     0,     0,   405,     0,   406,     0,   407,   408,
       0,   409,   410,     0,   411,     0,   412,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,     0,     0,   431,     0,     0,     0,   432,     0,
     433,   434,   435,   436,   437,   438,     0,   439,   440,   441,
     442,   443,   444,     0,     0,     0,   587,     0,     0,   445,
     446,     0,   447,     0,     0,   448,     0,     0,   449,   450,
       0,     0,     0,   451,     0,     0,   452,   453,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,   461,   462,
     463,     0,   464,   465,     0,   466,     0,   467,   468,   469,
     470,     0,     0,   471,   472,     0,   473,   474,   475,   476,
       0,     0,     0,     0,     0,   477,   478,   479,     0,     0,
       0,   480,   481,   482,   483,     0,   484,   485,     0,   486,
     487,     0,   488,   489,     0,     0,   490,     0,     0,   491,
       0,   492,     0,   493,   494,   495,     0,     0,     0,     0,
       0,     0,   496,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,   503,   504,     0,     0,     0,     0,
       0,     0,   505,   506,     0,   507,   508,   509,     0,   141,
     510,   142,   143,   144,   145,   146,   147,     0,     0,   148,
       0,     0,     0,   149,     0,     0,   150,     0,   151,   152,
     153,   154,   155,   156,   157,   158,     0,   159,     0,     0,
       0,   160,     0,     0,     0,   161,     0,     0,   162,   163,
     164,     0,   165,     0,   166,   167,     0,     0,   168,     0,
       0,   169,   170,     0,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,     0,   182,   183,
     184,   185,   186,   187,   188,     0,   189,   190,   191,   192,
     193,   194,   195,   196,     0,   197,   198,     0,   199,   200,
     201,   202,   203,     0,   204,     0,     0,   205,     0,     0,
     206,     0,   207,     0,     0,   208,     0,   209,     0,     0,
       0,   210,   211,   212,     0,     0,   213,     0,     0,     0,
       0,   214,   215,     0,     0,     0,     0,   216,     0,   217,
       0,     0,     0,   218,     0,   219,   220,   221,   222,   223,
       0,     0,     0,   224,     0,     0,   225,   226,   227,     0,
       0,     0,   228,     0,   229,   230,     0,   231,   232,   233,
       0,     0,   234,   235,     0,   236,   237,   238,   239,   240,
     241,   242,     0,     0,   243,   244,   245,     0,     0,   246,
     247,     0,   248,   249,   250,     0,     0,   251,     0,     0,
       0,   252,  1133,   253,     0,   254,     0,   255,   256,   257,
     258,   259,   260,   261,     0,   262,     0,     0,     0,   263,
     264,   265,     0,   266,     0,     0,     0,   267,   268,     0,
       0,     0,   269,   270,   271,   272,   273,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,     0,     0,     0,
     279,   280,     0,     0,     0,   281,     0,   282,   283,     0,
     284,   285,     0,     0,     0,   286,     0,     0,   287,   288,
     289,     0,     0,   290,     0,     0,   291,   292,     0,     0,
       0,     0,     0,   293,   294,     0,   295,     0,   296,     0,
     297,   298,     0,     0,     0,     0,     0,     0,     0,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,     0,   315,   316,   317,   318,
       0,   319,   320,   321,   322,     0,   323,   324,     0,     0,
       0,     0,   325,   326,   327,   328,   329,   330,     0,     0,
     331,   332,     0,   333,     0,   334,     0,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,   344,   345,
       0,     0,   346,   347,   348,   349,     0,     0,     0,   350,
     351,     0,     0,     0,   352,     0,   353,   354,   355,     0,
     356,   357,   358,   359,     0,   360,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,   363,   364,     0,     0,
     365,     0,   366,     0,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,     0,     0,   377,   378,   379,     0,
     380,     0,   381,   382,   383,   384,   385,     0,   386,   387,
     388,     0,     0,   389,     0,     0,     0,   390,   391,   392,
     393,   394,     0,     0,   395,   396,   397,   398,   399,     0,
     400,   401,     0,   402,   403,   404,     0,     0,   405,     0,
     406,     0,   407,   408,     0,   409,   410,     0,   411,     0,
     412,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,     0,     0,
       0,   427,   428,   429,   430,     0,     0,     0,   431,     0,
       0,     0,   432,     0,   433,   434,   435,   436,   437,   438,
       0,   439,   440,   441,   442,   443,   444,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,     0,     0,   448,
       0,     0,   449,   450,     0,     0,     0,   451,     0,     0,
     452,   453,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,   461,   462,   463,     0,   464,   465,     0,   466,
       0,   467,   468,   469,   470,     0,     0,   471,   472,     0,
     473,   474,   475,   476,     0,     0,     0,     0,     0,   477,
     478,   479,     0,     0,     0,   480,   481,   482,   483,     0,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
     490,     0,     0,   491,     0,   492,     0,   493,   494,   495,
       0,     0,     0,     0,     0,     0,   496,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,   503,   504,
       0,     0,     0,     0,     0,     0,   505,   506,     0,   507,
     508,   509,     0,   141,   510,   142,   143,   144,   145,   146,
     147,     0,     0,   148,     0,     0,     0,   149,     0,     0,
     150,     0,   151,   152,   153,   154,   155,   156,   157,   158,
       0,   159,     0,     0,     0,   160,     0,     0,     0,   161,
       0,     0,   162,   163,   164,     0,   165,     0,   166,   167,
       0,     0,   168,     0,     0,   169,   170,     0,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,     0,   182,   183,   184,   185,   186,   187,   188,     0,
     189,   190,   191,   192,   193,   194,   195,   196,     0,   197,
     198,     0,   199,   200,   201,   202,   203,     0,   204,     0,
       0,   205,     0,     0,   206,     0,   207,     0,     0,   208,
       0,   209,     0,     0,     0,   210,   211,   212,     0,     0,
     213,     0,     0,     0,     0,   214,   215,     0,     0,     0,
     948,   216,     0,   217,     0,     0,     0,   218,     0,   219,
     220,   221,   222,   223,     0,     0,     0,   224,     0,     0,
     225,   226,   227,     0,     0,     0,   228,     0,   229,   230,
       0,   231,   232,   233,     0,     0,   234,   235,     0,   236,
     237,   238,   239,   240,   241,   242,     0,     0,   243,   244,
     245,     0,     0,   246,   247,     0,   248,   249,   250,     0,
       0,   251,     0,     0,     0,   252,     0,   253,     0,   254,
       0,   255,   256,   257,   258,   259,   260,   261,     0,   262,
       0,     0,     0,   263,   264,   265,     0,   266,     0,     0,
       0,   267,   268,     0,     0,     0,   269,   270,   271,   272,
     273,     0,     0,   274,   275,   276,     0,   277,     0,   278,
       0,     0,     0,     0,   279,   280,     0,     0,     0,   281,
       0,   282,   283,     0,   284,   285,     0,     0,     0,   286,
       0,     0,   287,   288,   289,     0,     0,   290,     0,     0,
     291,   292,     0,     0,     0,     0,     0,   293,   294,     0,
     295,     0,   296,     0,   297,   298,     0,     0,     0,     0,
       0,     0,     0,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,     0,
     315,   316,   317,   318,     0,   319,   320,   321,   322,     0,
     323,   324,     0,     0,     0,     0,   325,   326,   327,   328,
     329,   330,     0,     0,   331,   332,     0,   333,     0,   334,
       0,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,   344,   345,     0,     0,   346,   347,   348,   349,
       0,     0,     0,   350,   351,     0,     0,     0,   352,     0,
     353,   354,   355,     0,   356,   357,   358,   359,     0,   360,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
     363,   364,     0,     0,   365,     0,   366,     0,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,     0,   380,     0,   381,   382,   383,   384,
     385,     0,   386,   387,   388,     0,     0,   389,     0,     0,
       0,   390,   391,   392,   393,   394,     0,     0,   395,   396,
     397,   398,   399,     0,   400,   401,     0,   402,   403,   404,
       0,     0,   405,     0,   406,     0,   407,   408,     0,   409,
     410,     0,   411,     0,   412,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,     0,     0,     0,   427,   428,   429,   430,     0,
       0,     0,   431,     0,     0,     0,   432,     0,   433,   434,
     435,   436,   437,   438,     0,   439,   440,   441,   442,   443,
     444,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,     0,     0,   448,     0,     0,   449,   450,     0,     0,
       0,   451,     0,     0,   452,   453,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,   461,   462,   463,     0,
     464,   465,     0,   466,     0,   467,   468,   469,   470,     0,
       0,   471,   472,     0,   473,   474,   475,   476,     0,     0,
       0,     0,     0,  1976,   478,   479,     0,     0,     0,   480,
     481,   482,   483,     0,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,   490,     0,     0,   491,     0,   492,
       0,   493,   494,   495,     0,     0,     0,     0,     0,     0,
     496,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,   503,   504,     0,     0,     0,     0,     0,     0,
     505,   506,     0,   507,   508,   509,     0,   141,   510,   142,
     143,   144,   145,   146,   147,     0,     0,   148,     0,     0,
       0,   149,     0,     0,   150,     0,   151,   152,   153,   154,
     155,   156,   157,   158,     0,   159,     0,     0,     0,   160,
       0,     0,     0,   161,     0,     0,   162,   163,   164,     0,
     165,     0,   166,   167,     0,     0,   168,     0,     0,   169,
     170,     0,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,   184,   185,
     186,   187,   188,     0,   189,   190,   191,   192,   193,   194,
     195,   196,     0,   197,   198,     0,   199,   200,   201,   202,
     203,     0,   204,     0,     0,   205,     0,     0,   206,     0,
     207,     0,     0,   208,     0,   209,     0,     0,     0,   210,
     211,   212,     0,     0,   213,     0,     0,     0,     0,   214,
     215,     0,     0,     0,  2124,   216,     0,   217,     0,     0,
       0,   218,     0,   219,   220,   221,   222,   223,     0,     0,
       0,   224,     0,     0,   225,   226,   227,     0,     0,     0,
     228,     0,   229,   230,     0,   231,   232,   233,     0,     0,
     234,   235,     0,   236,   237,   238,   239,   240,   241,   242,
       0,     0,   243,   244,   245,     0,     0,   246,   247,     0,
     248,   249,   250,     0,     0,   251,     0,     0,     0,   252,
       0,   253,     0,   254,     0,   255,   256,   257,   258,   259,
     260,   261,     0,   262,     0,     0,     0,   263,   264,   265,
       0,   266,     0,     0,     0,   267,   268,     0,     0,     0,
     269,   270,   271,   272,   273,     0,     0,   274,   275,   276,
       0,   277,     0,   278,     0,     0,     0,     0,   279,   280,
       0,     0,     0,   281,     0,   282,   283,     0,   284,   285,
       0,     0,     0,   286,     0,     0,   287,   288,   289,     0,
       0,   290,     0,     0,   291,   292,     0,     0,     0,     0,
       0,   293,   294,     0,   295,     0,   296,     0,   297,   298,
       0,     0,     0,     0,     0,     0,     0,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,     0,   315,   316,   317,   318,     0,   319,
     320,   321,   322,     0,   323,   324,     0,     0,     0,     0,
     325,   326,   327,   328,   329,   330,     0,     0,   331,   332,
       0,   333,     0,   334,     0,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,   344,   345,     0,     0,
     346,   347,   348,   349,     0,     0,     0,   350,   351,     0,
       0,     0,   352,     0,   353,   354,   355,     0,   356,   357,
     358,   359,     0,   360,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,   363,   364,     0,     0,   365,     0,
     366,     0,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,     0,   380,     0,
     381,   382,   383,   384,   385,     0,   386,   387,   388,     0,
       0,   389,     0,     0,     0,   390,   391,   392,   393,   394,
       0,     0,   395,   396,   397,   398,   399,     0,   400,   401,
       0,   402,   403,   404,     0,     0,   405,     0,   406,     0,
     407,   408,     0,   409,   410,     0,   411,     0,   412,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,     0,     0,     0,   427,
     428,   429,   430,     0,     0,     0,   431,     0,     0,     0,
     432,     0,   433,   434,   435,   436,   437,   438,     0,   439,
     440,   441,   442,   443,   444,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,     0,     0,   448,     0,     0,
     449,   450,     0,     0,     0,   451,     0,     0,   452,   453,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
     461,   462,   463,     0,   464,   465,     0,   466,     0,   467,
     468,   469,   470,     0,     0,   471,   472,     0,   473,   474,
     475,   476,     0,     0,     0,     0,     0,   477,   478,   479,
       0,     0,     0,   480,   481,   482,   483,     0,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,   490,     0,
       0,   491,     0,   492,     0,   493,   494,   495,     0,     0,
       0,     0,     0,     0,   496,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,   503,   504,     0,     0,
       0,     0,     0,     0,   505,   506,     0,   507,   508,   509,
       0,   141,   510,   142,   143,   144,   145,   146,   147,     0,
       0,   148,     0,     0,     0,   149,     0,     0,   150,     0,
     151,   152,   153,   154,   155,   156,   157,   158,     0,   159,
       0,     0,     0,   160,     0,     0,     0,   161,     0,     0,
     162,   163,   164,     0,   165,     0,   166,   167,     0,     0,
     168,     0,     0,   169,   170,     0,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,     0,
     182,   183,   184,   185,   186,   187,   188,     0,   189,   190,
     191,   192,   193,   194,   195,   196,     0,   197,   198,     0,
     199,   200,   201,   202,   203,     0,   204,     0,     0,   205,
       0,     0,   206,     0,   207,     0,     0,   208,     0,   209,
       0,     0,     0,   210,   211,   212,     0,     0,   213,     0,
       0,     0,     0,   214,   215,     0,     0,     0,   948,   216,
       0,   217,     0,     0,     0,   218,     0,   219,   220,   221,
     222,   223,     0,     0,     0,   224,     0,     0,   225,   226,
     227,     0,     0,     0,   228,     0,   229,   230,     0,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
     239,   240,   241,   242,     0,     0,   243,   244,   245,     0,
       0,   246,   247,     0,   248,   249,   250,     0,     0,   251,
       0,     0,     0,   252,     0,   253,     0,   254,     0,   255,
     256,   257,   258,   259,   260,   261,     0,   262,     0,     0,
       0,   263,   264,   265,     0,   266,     0,     0,     0,   267,
     268,     0,     0,     0,   269,   270,   271,   272,   273,     0,
       0,   274,   275,   276,     0,   277,     0,   278,     0,     0,
       0,     0,   279,   280,     0,     0,     0,   281,     0,   282,
     283,     0,   284,   285,     0,     0,     0,   286,     0,     0,
     287,   288,   289,     0,     0,   290,     0,     0,   291,   292,
       0,     0,     0,     0,     0,   293,   294,     0,   295,     0,
     296,     0,   297,   298,     0,     0,     0,     0,     0,     0,
       0,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,     0,   315,   316,
     317,   318,     0,   319,   320,   321,   322,     0,   323,   324,
       0,     0,     0,     0,   325,   326,   327,   328,   329,   330,
       0,     0,   331,   332,     0,   333,     0,   334,     0,   335,
     336,   337,   338,   339,   340,   341,   342,   343,     0,     0,
     344,   345,     0,     0,   346,   347,   348,   349,     0,     0,
       0,   350,   351,     0,     0,     0,   352,     0,   353,   354,
     355,     0,   356,   357,   358,   359,     0,   360,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,   363,   364,
       0,     0,   365,     0,   366,     0,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,     0,     0,   377,   378,
     379,     0,   380,     0,   381,   382,   383,   384,   385,     0,
     386,   387,   388,     0,     0,   389,     0,     0,     0,   390,
     391,   392,   393,   394,     0,     0,   395,   396,   397,   398,
     399,     0,   400,   401,     0,   402,   403,   404,     0,     0,
     405,     0,   406,     0,   407,   408,     0,   409,   410,     0,
     411,     0,   412,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
       0,     0,     0,   427,   428,   429,   430,     0,     0,     0,
     431,     0,     0,     0,   432,     0,   433,   434,   435,   436,
     437,   438,     0,   439,   440,   441,   442,   443,   444,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,     0,
       0,   448,     0,     0,   449,   450,     0,     0,     0,   451,
       0,     0,   452,   453,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   460,   461,   462,   463,     0,   464,   465,
       0,   466,     0,   467,   468,   469,   470,     0,     0,   471,
     472,     0,   473,   474,   475,   476,     0,     0,     0,     0,
       0,   477,   478,   479,     0,     0,     0,   480,   481,   482,
     483,     0,   484,   485,     0,   486,   487,     0,   488,   489,
       0,     0,   490,     0,     0,   491,     0,   492,     0,   493,
     494,   495,     0,     0,     0,     0,     0,     0,   496,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
     503,   504,     0,     0,     0,     0,     0,     0,   505,   506,
       0,   507,   508,   509,     0,   141,   510,   142,   143,   144,
     145,   146,   147,     0,     0,   148,     0,     0,     0,   149,
       0,     0,   150,     0,   151,   152,   153,   154,   155,   156,
     157,   158,     0,   159,     0,     0,     0,   160,     0,     0,
       0,   161,     0,     0,   162,   163,   164,     0,   165,     0,
     166,   167,     0,     0,   168,     0,     0,   169,   170,     0,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,   184,   185,   186,   187,
     188,     0,   189,   190,   191,   192,   193,   194,   195,   196,
       0,   197,   198,     0,   199,   200,   201,   202,   203,     0,
     204,     0,     0,   205,     0,     0,   206,     0,   207,     0,
       0,   208,     0,   209,     0,     0,     0,   210,   211,   212,
       0,     0,   213,     0,     0,     0,     0,   214,   215,     0,
       0,     0,     0,   216,     0,   217,     0,     0,     0,   218,
       0,   219,   220,   221,   222,   223,     0,     0,     0,   224,
       0,     0,   225,   226,   227,     0,     0,     0,   228,     0,
     229,   230,     0,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,   239,   240,   241,   242,     0,     0,
     243,   244,   245,     0,     0,   246,   247,     0,   248,   249,
     250,     0,     0,   251,     0,     0,     0,   252,     0,   253,
       0,   254,     0,   255,   256,   257,   258,   259,   260,   261,
       0,   262,     0,     0,     0,   263,   264,   265,     0,   266,
       0,     0,     0,   267,   268,     0,     0,     0,   269,   270,
     271,   272,   273,     0,     0,   274,   275,   276,     0,   277,
       0,   278,     0,     0,     0,     0,   279,   280,     0,     0,
       0,   281,     0,   282,   283,     0,   284,   285,     0,     0,
       0,   286,     0,     0,   287,   288,   289,     0,     0,   290,
       0,     0,   291,   292,     0,     0,     0,     0,     0,   293,
     294,     0,   295,     0,   296,     0,   297,   298,     0,     0,
       0,     0,     0,     0,     0,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,     0,   315,   316,   317,   318,     0,   319,   320,   321,
     322,     0,   323,   324,     0,     0,     0,     0,   325,   326,
     327,   328,   329,   330,     0,     0,   331,   332,     0,   333,
       0,   334,     0,   335,   336,   337,   338,   339,   340,   341,
     342,   343,     0,     0,   344,   345,     0,     0,   346,   347,
     348,   349,     0,     0,     0,   350,   351,     0,     0,     0,
     352,     0,   353,   354,   355,     0,   356,   357,   358,   359,
       0,   360,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,   363,   364,     0,     0,   365,     0,   366,     0,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,  3090,   380,     0,   381,   382,
     383,   384,   385,     0,   386,   387,   388,     0,     0,   389,
       0,     0,     0,   390,   391,   392,   393,   394,     0,     0,
     395,   396,   397,   398,   399,     0,   400,   401,     0,   402,
     403,   404,     0,     0,   405,     0,   406,     0,   407,   408,
       0,   409,   410,     0,   411,     0,   412,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,     0,     0,   431,     0,     0,     0,   432,     0,
     433,   434,   435,   436,   437,   438,     0,   439,   440,   441,
     442,   443,   444,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,     0,     0,   448,     0,     0,   449,   450,
       0,     0,     0,   451,     0,     0,   452,   453,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,   461,   462,
     463,     0,   464,   465,     0,   466,     0,   467,   468,   469,
     470,     0,     0,   471,   472,     0,   473,   474,   475,   476,
       0,     0,     0,     0,     0,   477,   478,   479,     0,     0,
       0,   480,   481,   482,   483,     0,   484,   485,     0,   486,
     487,     0,   488,   489,     0,     0,   490,     0,     0,   491,
       0,   492,     0,   493,   494,   495,     0,     0,     0,     0,
       0,     0,   496,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,   503,   504,     0,     0,     0,     0,
       0,     0,   505,   506,     0,   507,   508,   509,     0,   141,
     510,   142,   143,   144,   145,   146,   147,     0,     0,   148,
       0,     0,     0,   149,     0,     0,   150,     0,   151,   152,
     153,   154,   155,   156,   157,   158,     0,   159,     0,     0,
       0,   160,     0,     0,     0,   161,     0,     0,   162,   163,
     164,     0,   165,     0,   166,   167,     0,     0,   168,     0,
       0,   169,   170,     0,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,     0,   182,   183,
     184,   185,   186,   187,   188,     0,   189,   190,   191,   192,
     193,   194,   195,   196,     0,   197,   198,     0,   199,   200,
     201,   202,   203,     0,   204,     0,     0,   205,     0,     0,
     206,     0,   207,     0,     0,   208,     0,   209,     0,     0,
       0,   210,   211,   212,     0,     0,   213,     0,     0,     0,
       0,   214,   215,     0,     0,     0,     0,   216,     0,   217,
       0,     0,     0,   218,     0,   219,   220,   221,   222,   223,
       0,     0,     0,   224,     0,     0,   225,   226,   227,     0,
       0,     0,   228,     0,   229,   230,     0,   231,   232,   233,
       0,     0,   234,   235,     0,   236,   237,   238,   239,   240,
     241,   242,     0,     0,   243,   244,   245,     0,     0,   246,
     247,     0,   248,   249,   250,     0,     0,   251,     0,     0,
       0,   252,     0,   253,     0,   254,     0,   255,   256,   257,
     258,   259,   260,   261,     0,   262,     0,     0,     0,   263,
     264,   265,     0,   266,     0,     0,     0,   267,   268,     0,
       0,     0,   269,   270,   271,   272,   273,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,     0,     0,     0,
     279,   280,     0,     0,     0,   281,     0,   282,   283,     0,
     284,   285,     0,     0,     0,   286,     0,     0,   287,   288,
     289,     0,     0,   290,     0,     0,   291,   292,     0,     0,
       0,     0,     0,   293,   294,     0,   295,     0,   296,     0,
     297,   298,     0,     0,     0,     0,     0,     0,     0,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,     0,   315,   316,   317,   318,
       0,   319,   320,   321,   322,     0,   323,   324,     0,     0,
       0,     0,   325,   326,   327,   328,   329,   330,     0,     0,
     331,   332,     0,   333,     0,   334,     0,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,   344,   345,
       0,     0,   346,   347,   348,   349,     0,     0,     0,   350,
     351,     0,     0,     0,   352,     0,   353,   354,   355,     0,
     356,   357,   358,   359,     0,   360,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,   363,   364,     0,     0,
     365,     0,   366,     0,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,     0,     0,   377,   378,   379,     0,
     380,     0,   381,   382,   383,   384,   385,     0,   386,   387,
     388,     0,     0,   389,     0,     0,     0,   390,   391,   392,
     393,   394,     0,     0,   395,   396,   397,   398,   399,     0,
     400,   401,     0,   402,   403,   404,     0,     0,   405,     0,
     406,     0,   407,   408,     0,   409,   410,     0,   411,     0,
     412,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,     0,     0,
       0,   427,   428,   429,   430,     0,     0,     0,   431,     0,
       0,     0,   432,     0,   433,   434,   435,   436,   437,   438,
       0,   439,   440,   441,   442,   443,   444,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,     0,     0,   448,
       0,     0,   449,   450,     0,     0,     0,   451,     0,     0,
     452,   453,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,   461,   462,   463,     0,   464,   465,     0,   466,
       0,   467,   468,   469,   470,     0,   138,   471,   472,     0,
     473,   474,   475,   476,     0,     0,     0,     0,     0,   477,
     478,   479,     0,     0,     0,   480,   481,   482,   483,     0,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
     490,     0,     0,   491,     0,   492,     0,   493,   494,   495,
       0,     0,     0,     0,     0,     0,   496,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,   503,   504,
       0,     0,     0,     0,     0,     0,   505,   506,     0,   507,
     508,   509,     0,   141,   510,   142,   143,   144,   145,   146,
     147,     0,     0,   148,     0,     0,     0,   149,     0,     0,
     150,     0,   151,   152,   153,   154,   155,   156,   157,   158,
       0,   159,     0,     0,     0,   160,     0,     0,     0,   161,
       0,     0,   162,   163,   164,     0,   165,     0,   166,   167,
       0,     0,   168,     0,     0,   169,   170,     0,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,     0,   182,   183,   184,   185,   186,   187,   188,     0,
     189,   190,   191,   192,   193,   194,   195,   196,     0,   197,
     198,     0,   199,   200,   201,   202,   203,     0,   204,     0,
       0,   205,     0,     0,   206,     0,   207,     0,     0,   208,
       0,   209,     0,     0,     0,   210,   211,   212,     0,     0,
     213,     0,     0,     0,     0,   214,   215,     0,     0,     0,
    3394,   216,     0,   217,     0,     0,     0,   218,     0,   219,
     220,   221,   222,   223,     0,     0,     0,   224,     0,     0,
     225,   226,   227,     0,     0,     0,   228,     0,   229,   230,
       0,   231,   232,   233,     0,     0,   234,   235,     0,   236,
     237,   238,   239,   240,   241,   242,     0,     0,   243,   244,
     245,     0,     0,   246,   247,     0,   248,   249,   250,     0,
       0,   251,     0,     0,     0,   252,     0,   253,     0,   254,
       0,   255,   256,   257,   258,   259,   260,   261,     0,   262,
       0,     0,     0,   263,   264,   265,     0,   266,     0,     0,
       0,   267,   268,     0,     0,     0,   269,   270,   271,   272,
     273,     0,     0,   274,   275,   276,     0,   277,     0,   278,
       0,     0,     0,     0,   279,   280,     0,     0,     0,   281,
       0,   282,   283,     0,   284,   285,     0,     0,     0,   286,
       0,     0,   287,   288,   289,     0,     0,   290,     0,     0,
     291,   292,     0,     0,     0,     0,     0,   293,   294,     0,
     295,     0,   296,     0,   297,   298,     0,     0,     0,     0,
       0,     0,     0,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,     0,
     315,   316,   317,   318,     0,   319,   320,   321,   322,     0,
     323,   324,     0,     0,     0,     0,   325,   326,   327,   328,
     329,   330,     0,     0,   331,   332,     0,   333,     0,   334,
       0,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,   344,   345,     0,     0,   346,   347,   348,   349,
       0,     0,     0,   350,   351,     0,     0,     0,   352,     0,
     353,   354,   355,     0,   356,   357,   358,   359,     0,   360,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
     363,   364,     0,     0,   365,     0,   366,     0,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,     0,   380,     0,   381,   382,   383,   384,
     385,     0,   386,   387,   388,     0,     0,   389,     0,     0,
       0,   390,   391,   392,   393,   394,     0,     0,   395,   396,
     397,   398,   399,     0,   400,   401,     0,   402,   403,   404,
       0,     0,   405,     0,   406,     0,   407,   408,     0,   409,
     410,     0,   411,     0,   412,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,     0,     0,     0,   427,   428,   429,   430,     0,
       0,     0,   431,     0,     0,     0,   432,     0,   433,   434,
     435,   436,   437,   438,     0,   439,   440,   441,   442,   443,
     444,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,     0,     0,   448,     0,     0,   449,   450,     0,     0,
       0,   451,     0,     0,   452,   453,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,   461,   462,   463,     0,
     464,   465,     0,   466,     0,   467,   468,   469,   470,     0,
       0,   471,   472,     0,   473,   474,   475,   476,     0,     0,
       0,     0,     0,   477,   478,   479,     0,     0,     0,   480,
     481,   482,   483,     0,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,   490,     0,     0,   491,     0,   492,
       0,   493,   494,   495,     0,     0,     0,     0,     0,     0,
     496,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,   503,   504,     0,     0,     0,     0,     0,     0,
     505,   506,     0,   507,   508,   509,     0,   141,   510,   142,
     143,   144,   145,   146,   147,  3402,     0,   148,     0,     0,
       0,   149,     0,     0,   150,     0,   151,   152,   153,   154,
     155,   156,   157,   158,     0,   159,     0,     0,     0,   160,
       0,     0,     0,   161,     0,     0,   162,   163,   164,     0,
     165,     0,   166,   167,     0,     0,   168,     0,     0,   169,
     170,     0,   171,   172,     0,   173,   174,     0,   175,   176,
     177,   178,   179,   180,   181,     0,   182,   183,   184,   185,
     186,   187,   188,     0,   189,   190,   191,   192,   193,   194,
     195,   196,     0,   197,   198,     0,   199,   200,   201,   202,
     203,     0,   204,     0,     0,   205,     0,     0,   206,     0,
     207,     0,     0,   208,     0,   209,     0,     0,     0,   210,
     211,   212,     0,     0,   213,     0,     0,     0,     0,   214,
     215,     0,     0,     0,     0,   216,     0,   217,     0,     0,
       0,   218,     0,   219,   220,   221,   222,   223,     0,     0,
       0,   224,     0,     0,   225,   226,   227,     0,     0,     0,
     228,     0,   229,   230,     0,   231,   232,   233,     0,     0,
     234,   235,     0,   236,   237,   238,   239,   240,   241,   242,
       0,     0,   243,   244,   245,     0,     0,   246,   247,     0,
     248,   249,   250,     0,     0,   251,     0,     0,     0,   252,
       0,   253,     0,   254,     0,   255,   256,   257,   258,   259,
     260,   261,     0,   262,     0,     0,     0,   263,   264,   265,
       0,   266,     0,     0,     0,   267,   268,     0,     0,     0,
     269,   270,   271,   272,   273,     0,     0,   274,   275,   276,
       0,   277,     0,   278,     0,     0,     0,     0,   279,   280,
       0,     0,     0,   281,     0,   282,   283,     0,   284,   285,
       0,     0,     0,   286,     0,     0,   287,   288,   289,     0,
       0,   290,     0,     0,   291,   292,     0,     0,     0,     0,
       0,   293,   294,     0,   295,     0,   296,     0,   297,   298,
       0,     0,     0,     0,     0,     0,     0,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,     0,   315,   316,   317,   318,     0,   319,
     320,   321,   322,     0,   323,   324,     0,     0,     0,     0,
     325,   326,   327,   328,   329,   330,     0,     0,   331,   332,
       0,   333,     0,   334,     0,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,   344,   345,     0,     0,
     346,   347,   348,   349,     0,     0,     0,   350,   351,     0,
       0,     0,   352,     0,   353,   354,   355,     0,   356,   357,
     358,   359,     0,   360,   361,     0,     0,     0,     0,     0,
       0,     0,     0,   362,   363,   364,     0,     0,   365,     0,
     366,     0,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,     0,     0,   377,   378,   379,     0,   380,     0,
     381,   382,   383,   384,   385,     0,   386,   387,   388,     0,
       0,   389,     0,     0,     0,   390,   391,   392,   393,   394,
       0,     0,   395,   396,   397,   398,   399,     0,   400,   401,
       0,   402,   403,   404,     0,     0,   405,     0,   406,     0,
     407,   408,     0,   409,   410,     0,   411,     0,   412,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,     0,     0,     0,   427,
     428,   429,   430,     0,     0,     0,   431,     0,     0,     0,
     432,     0,   433,   434,   435,   436,   437,   438,     0,   439,
     440,   441,   442,   443,   444,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,     0,     0,   448,     0,     0,
     449,   450,     0,     0,     0,   451,     0,     0,   452,   453,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
     461,   462,   463,     0,   464,   465,     0,   466,     0,   467,
     468,   469,   470,     0,     0,   471,   472,     0,   473,   474,
     475,   476,     0,     0,     0,     0,     0,   477,   478,   479,
       0,     0,     0,   480,   481,   482,   483,     0,   484,   485,
       0,   486,   487,     0,   488,   489,     0,     0,   490,     0,
       0,   491,     0,   492,     0,   493,   494,   495,     0,     0,
       0,     0,     0,     0,   496,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,   503,   504,     0,     0,
       0,     0,     0,     0,   505,   506,     0,   507,   508,   509,
       0,   141,   510,   142,   143,   144,   145,   146,   147,     0,
       0,   148,     0,     0,     0,   149,     0,     0,   150,     0,
     151,   152,   153,   154,   155,   156,   157,   158,     0,   159,
       0,     0,     0,   160,     0,     0,     0,   161,     0,     0,
     162,   163,   164,     0,   165,     0,   166,   167,     0,     0,
     168,     0,     0,   169,   170,     0,   171,   172,     0,   173,
     174,     0,   175,   176,   177,   178,   179,   180,   181,     0,
     182,   183,   184,   185,   186,   187,   188,     0,   189,   190,
     191,   192,   193,   194,   195,   196,     0,   197,   198,     0,
     199,   200,   201,   202,   203,     0,   204,     0,     0,   205,
       0,     0,   206,     0,   207,     0,     0,   208,     0,   209,
       0,     0,     0,   210,   211,   212,     0,     0,   213,     0,
       0,     0,     0,   214,   215,     0,     0,     0,  3426,   216,
       0,   217,     0,     0,     0,   218,     0,   219,   220,   221,
     222,   223,     0,     0,     0,   224,     0,     0,   225,   226,
     227,     0,     0,     0,   228,     0,   229,   230,     0,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
     239,   240,   241,   242,     0,     0,   243,   244,   245,     0,
       0,   246,   247,     0,   248,   249,   250,     0,     0,   251,
       0,     0,     0,   252,     0,   253,     0,   254,     0,   255,
     256,   257,   258,   259,   260,   261,     0,   262,     0,     0,
       0,   263,   264,   265,     0,   266,     0,     0,     0,   267,
     268,     0,     0,     0,   269,   270,   271,   272,   273,     0,
       0,   274,   275,   276,     0,   277,     0,   278,     0,     0,
       0,     0,   279,   280,     0,     0,     0,   281,     0,   282,
     283,     0,   284,   285,     0,     0,     0,   286,     0,     0,
     287,   288,   289,     0,     0,   290,     0,     0,   291,   292,
       0,     0,     0,     0,     0,   293,   294,     0,   295,     0,
     296,     0,   297,   298,     0,     0,     0,     0,     0,     0,
       0,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,     0,   315,   316,
     317,   318,     0,   319,   320,   321,   322,     0,   323,   324,
       0,     0,     0,     0,   325,   326,   327,   328,   329,   330,
       0,     0,   331,   332,     0,   333,     0,   334,     0,   335,
     336,   337,   338,   339,   340,   341,   342,   343,     0,     0,
     344,   345,     0,     0,   346,   347,   348,   349,     0,     0,
       0,   350,   351,     0,     0,     0,   352,     0,   353,   354,
     355,     0,   356,   357,   358,   359,     0,   360,   361,     0,
       0,     0,     0,     0,     0,     0,     0,   362,   363,   364,
       0,     0,   365,     0,   366,     0,   367,   368,   369,   370,
     371,   372,   373,   374,   375,   376,     0,     0,   377,   378,
     379,     0,   380,     0,   381,   382,   383,   384,   385,     0,
     386,   387,   388,     0,     0,   389,     0,     0,     0,   390,
     391,   392,   393,   394,     0,     0,   395,   396,   397,   398,
     399,     0,   400,   401,     0,   402,   403,   404,     0,     0,
     405,     0,   406,     0,   407,   408,     0,   409,   410,     0,
     411,     0,   412,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
       0,     0,     0,   427,   428,   429,   430,     0,     0,     0,
     431,     0,     0,     0,   432,     0,   433,   434,   435,   436,
     437,   438,     0,   439,   440,   441,   442,   443,   444,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,     0,
       0,   448,     0,     0,   449,   450,     0,     0,     0,   451,
       0,     0,   452,   453,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   460,   461,   462,   463,     0,   464,   465,
       0,   466,     0,   467,   468,   469,   470,     0,     0,   471,
     472,     0,   473,   474,   475,   476,     0,     0,     0,     0,
       0,   477,   478,   479,     0,     0,     0,   480,   481,   482,
     483,     0,   484,   485,     0,   486,   487,     0,   488,   489,
       0,     0,   490,     0,     0,   491,     0,   492,     0,   493,
     494,   495,     0,     0,     0,     0,     0,     0,   496,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
     503,   504,     0,     0,     0,     0,     0,     0,   505,   506,
       0,   507,   508,   509,     0,   141,   510,   142,   143,   144,
     145,   146,   147,     0,     0,   148,     0,     0,     0,   149,
       0,     0,   150,     0,   151,   152,   153,   154,   155,   156,
     157,   158,     0,   159,     0,     0,     0,   160,     0,     0,
       0,   161,     0,     0,   162,   163,   164,     0,   165,     0,
     166,   167,     0,     0,   168,     0,     0,   169,   170,     0,
     171,   172,     0,   173,   174,     0,   175,   176,   177,   178,
     179,   180,   181,     0,   182,   183,   184,   185,   186,   187,
     188,     0,   189,   190,   191,   192,   193,   194,   195,   196,
       0,   197,   198,     0,   199,   200,   201,   202,   203,     0,
     204,     0,     0,   205,     0,     0,   206,     0,   207,     0,
       0,   208,     0,   209,     0,     0,     0,   210,   211,   212,
       0,     0,   213,     0,     0,     0,     0,   214,   215,     0,
       0,     0,     0,   216,     0,   217,     0,     0,     0,   218,
       0,   219,   220,   221,   222,   223,     0,     0,     0,   224,
       0,     0,   225,   226,   227,     0,     0,     0,   228,     0,
     229,   230,     0,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,   239,   240,   241,   242,     0,     0,
     243,   244,   245,     0,     0,   246,   247,     0,   248,   249,
     250,     0,     0,   251,     0,     0,     0,   252,     0,   253,
       0,   254,     0,   255,   256,   257,   258,   259,   260,   261,
       0,   262,     0,     0,     0,   263,   264,   265,     0,   266,
       0,     0,     0,   267,   268,     0,     0,     0,   269,   270,
     271,   272,   273,     0,     0,   274,   275,   276,     0,   277,
       0,   278,     0,     0,     0,     0,   279,   280,     0,     0,
       0,   281,     0,   282,   283,     0,   284,   285,     0,     0,
       0,   286,     0,     0,   287,   288,   289,     0,     0,   290,
       0,     0,   291,   292,     0,     0,     0,     0,     0,   293,
     294,     0,   295,     0,   296,     0,   297,   298,     0,     0,
       0,     0,     0,     0,     0,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,     0,   315,   316,   317,   318,     0,   319,   320,   321,
     322,     0,   323,   324,     0,     0,     0,     0,   325,   326,
     327,   328,   329,   330,     0,     0,   331,   332,     0,   333,
       0,   334,     0,   335,   336,   337,   338,   339,   340,   341,
     342,   343,     0,     0,   344,   345,     0,     0,   346,   347,
     348,   349,     0,     0,     0,   350,   351,     0,     0,     0,
     352,     0,   353,   354,   355,     0,   356,   357,   358,   359,
       0,   360,   361,     0,     0,     0,     0,     0,     0,     0,
       0,   362,   363,   364,     0,     0,   365,     0,   366,     0,
     367,   368,   369,   370,   371,   372,   373,   374,   375,   376,
       0,     0,   377,   378,   379,  4315,   380,     0,   381,   382,
     383,   384,   385,     0,   386,   387,   388,     0,     0,   389,
       0,     0,     0,   390,   391,   392,   393,   394,     0,     0,
     395,   396,   397,   398,   399,     0,   400,   401,     0,   402,
     403,   404,     0,     0,   405,     0,   406,     0,   407,   408,
       0,   409,   410,     0,   411,     0,   412,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,     0,     0,     0,   427,   428,   429,
     430,     0,     0,     0,   431,     0,     0,     0,   432,     0,
     433,   434,   435,   436,   437,   438,     0,   439,   440,   441,
     442,   443,   444,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,     0,     0,   448,     0,     0,   449,   450,
       0,     0,     0,   451,     0,     0,   452,   453,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,   461,   462,
     463,     0,   464,   465,     0,   466,     0,   467,   468,   469,
     470,     0,     0,   471,   472,     0,   473,   474,   475,   476,
       0,     0,     0,     0,     0,   477,   478,   479,     0,     0,
       0,   480,   481,   482,   483,     0,   484,   485,     0,   486,
     487,     0,   488,   489,     0,     0,   490,     0,     0,   491,
       0,   492,     0,   493,   494,   495,     0,     0,     0,     0,
       0,     0,   496,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,   503,   504,     0,     0,     0,     0,
       0,     0,   505,   506,     0,   507,   508,   509,     0,   141,
     510,   142,   143,   144,   145,   146,   147,     0,     0,   148,
       0,     0,     0,   149,     0,     0,   150,     0,   151,   152,
     153,   154,   155,   156,   157,   158,     0,   159,     0,     0,
       0,   160,     0,     0,     0,   161,     0,     0,   162,   163,
     164,     0,   165,     0,   166,   167,     0,     0,   168,     0,
       0,   169,   170,     0,   171,   172,     0,   173,   174,     0,
     175,   176,   177,   178,   179,   180,   181,     0,   182,   183,
     184,   185,   186,   187,   188,     0,   189,   190,   191,   192,
     193,   194,   195,   196,     0,   197,   198,     0,   199,   200,
     201,   202,   203,     0,   204,     0,     0,   205,     0,     0,
     206,     0,   207,     0,     0,   208,     0,   209,     0,     0,
       0,   210,   211,   212,     0,     0,   213,     0,     0,     0,
       0,   214,   215,     0,     0,     0,     0,   216,     0,   217,
       0,     0,     0,   218,     0,   219,   220,   221,   222,   223,
       0,     0,     0,   224,     0,     0,   225,   226,   227,     0,
       0,     0,   228,     0,   229,   230,     0,   231,   232,   233,
       0,     0,   234,   235,     0,   236,   237,   238,   239,   240,
     241,   242,     0,     0,   243,   244,   245,     0,     0,   246,
     247,     0,   248,   249,   250,     0,     0,   251,     0,     0,
       0,   252,     0,   253,     0,   254,     0,   255,   256,   257,
     258,   259,   260,   261,     0,   262,     0,     0,     0,   263,
     264,   265,     0,   266,     0,     0,     0,   267,   268,     0,
       0,     0,   269,   270,   271,   272,   273,     0,     0,   274,
     275,   276,     0,   277,     0,   278,     0,     0,     0,     0,
     279,   280,     0,     0,     0,   281,     0,   282,   283,     0,
     284,   285,     0,     0,     0,   286,     0,     0,   287,   288,
     289,     0,     0,   290,     0,     0,   291,   292,     0,     0,
       0,     0,     0,   293,   294,     0,   295,     0,   296,     0,
     297,   298,     0,     0,     0,     0,     0,     0,     0,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,     0,   315,   316,   317,   318,
       0,   319,   320,   321,   322,     0,   323,   324,     0,     0,
       0,     0,   325,   326,   327,   328,   329,   330,     0,     0,
     331,   332,     0,   333,     0,   334,     0,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,   344,   345,
       0,     0,   346,   347,   348,   349,     0,     0,     0,   350,
     351,     0,     0,     0,   352,     0,   353,   354,   355,     0,
     356,   357,   358,   359,     0,   360,   361,     0,     0,     0,
       0,     0,     0,     0,     0,   362,   363,   364,     0,     0,
     365,     0,   366,     0,   367,   368,   369,   370,   371,   372,
     373,   374,   375,   376,     0,     0,   377,   378,   379,     0,
     380,     0,   381,   382,   383,   384,   385,     0,   386,   387,
     388,     0,     0,   389,     0,     0,     0,   390,   391,   392,
     393,   394,     0,     0,   395,   396,   397,   398,   399,     0,
     400,   401,     0,   402,   403,   404,     0,     0,   405,     0,
     406,     0,   407,   408,     0,   409,   410,     0,   411,     0,
     412,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,     0,     0,
       0,   427,   428,   429,   430,     0,     0,     0,   431,     0,
       0,     0,   432,     0,   433,   434,   435,   436,   437,   438,
       0,   439,   440,   441,   442,   443,   444,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,     0,     0,   448,
       0,     0,   449,   450,     0,     0,     0,   451,     0,     0,
     452,   453,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,   461,   462,   463,     0,   464,   465,     0,   466,
       0,   467,   468,   469,   470,     0,     0,   471,   472,     0,
     473,   474,   475,   476,     0,     0,     0,     0,     0,   477,
     478,   479,     0,     0,     0,   480,   481,   482,   483,     0,
     484,   485,     0,   486,   487,     0,   488,   489,     0,     0,
     490,     0,     0,   491,     0,   492,     0,   493,   494,   495,
       0,     0,     0,     0,     0,     0,   496,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,   503,   504,
       0,     0,     0,     0,     0,     0,   505,   506,     0,   507,
     508,   509,     0,   141,   510,   142,   143,   144,   145,   146,
     147,     0,     0,   148,     0,     0,     0,   149,     0,     0,
     150,     0,   151,   152,   153,   154,   155,   156,   157,   158,
       0,   159,     0,     0,     0,   160,     0,     0,     0,   161,
       0,     0,   162,   163,   164,     0,   165,     0,   166,   167,
       0,     0,   168,     0,     0,   169,   170,     0,   171,   172,
       0,   173,   174,     0,   175,   176,   177,   178,   179,   180,
     181,     0,   182,   183,   184,   185,   186,   187,   188,     0,
     189,   190,   191,   192,   193,   194,   195,   196,     0,   197,
     198,     0,   199,   200,   201,   202,   203,     0,   204,     0,
       0,   205,     0,     0,   206,     0,   207,     0,     0,   208,
       0,   209,     0,     0,     0,   210,   211,   212,     0,     0,
     213,     0,     0,     0,     0,   214,   215,     0,     0,     0,
       0,   216,     0,   217,     0,     0,     0,   218,     0,   219,
     220,   221,   222,   223,     0,     0,     0,   224,     0,     0,
     225,   226,   227,     0,     0,     0,   228,     0,   229,   230,
       0,   231,   232,   233,     0,     0,   234,   235,     0,   236,
     237,   238,   239,   240,   241,   242,     0,     0,   243,   244,
     245,     0,     0,   246,   247,     0,   248,  1892,   250,     0,
       0,   251,     0,     0,     0,   252,     0,   253,     0,   254,
       0,   255,   256,   257,   258,   259,   260,   261,     0,   262,
       0,     0,     0,   263,   264,   265,     0,   266,     0,     0,
       0,   267,   268,     0,     0,     0,   269,   270,   271,   272,
     273,     0,     0,   274,   275,   276,     0,   277,     0,   278,
       0,     0,     0,     0,   279,   280,     0,     0,     0,   281,
       0,   282,   283,     0,   284,   285,     0,     0,     0,   286,
       0,     0,   287,   288,   289,     0,     0,   290,     0,     0,
     291,   292,     0,     0,     0,     0,     0,   293,   294,     0,
     295,     0,   296,     0,   297,   298,     0,     0,     0,     0,
       0,     0,     0,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,     0,
     315,   316,   317,   318,     0,   319,   320,   321,   322,     0,
     323,   324,     0,     0,     0,     0,   325,   326,   327,   328,
     329,   330,     0,     0,   331,   332,     0,   333,     0,   334,
       0,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,   344,   345,     0,     0,   346,  1893,   348,   349,
       0,     0,     0,   350,   351,     0,     0,     0,   352,     0,
     353,   354,   355,     0,   356,   357,   358,   359,     0,   360,
     361,     0,     0,     0,     0,     0,     0,     0,     0,   362,
     363,   364,     0,     0,   365,     0,   366,     0,   367,   368,
     369,   370,   371,   372,   373,   374,   375,   376,     0,     0,
     377,   378,   379,     0,   380,     0,   381,   382,   383,   384,
     385,     0,   386,   387,   388,     0,     0,   389,     0,     0,
       0,   390,   391,   392,   393,   394,     0,     0,   395,   396,
     397,   398,   399,     0,   400,   401,     0,   402,   403,   404,
       0,     0,   405,     0,   406,     0,   407,   408,     0,   409,
     410,     0,   411,     0,   412,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,     0,     0,     0,   427,   428,   429,   430,     0,
       0,     0,   431,     0,     0,     0,   432,     0,   433,   434,
     435,   436,   437,   438,     0,   439,   440,   441,   442,   443,
     444,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,     0,     0,   448,     0,     0,   449,   450,     0,     0,
       0,   451,     0,     0,   452,   453,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,   461,   462,   463,     0,
     464,   465,     0,   466,     0,   467,   468,   469,   470,     0,
       0,   471,   472,     0,   473,   474,   475,   476,     0,     0,
       0,     0,     0,   477,   478,   479,     0,     0,     0,   480,
     481,   482,   483,     0,   484,   485,     0,   486,   487,     0,
     488,   489,     0,     0,   490,     0,     0,   491,     0,   492,
       0,   493,   494,   495,     0,     0,     0,     0,     0,     0,
     496,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,   503,   504,     0,     0,     0,     0,     0,     0,
     505,   506,     0,   507,   508,   509,     0,   141,   510,   142,
     143,   144,   145,   146,   147,     0,     0,   148,     0,     0,
       0,   149,     0,     0,     0,     0,   151,   152,   153,   154,
     155,   156,   157,     0,     0,  -372,     0,     0,     0,   160,
       0,     0,     0,   161,     0,     0,   162,   163,   164,     0,
     165,     0,     0,     0,     0,     0,   168,  4142,     0,   169,
     170,     0,   171,     0,     0,     0,     0,     0,   175,   176,
     177,   178,  4143,   180,   181,     0,   182,   183,     0,     0,
       0,     0,     0,     0,   189,     0,   191,     0,   193,   194,
     195,   196,     0,   197,   198,     0,   199,   200,   201,     0,
     203,     0,   204,     0,     0,   205,     0,     0,   206,     0,
     207,     0,     0,   208,     0,   209,     0,     0,     0,   210,
     211,   212,     0,     0,   213,     0,     0,     0,     0,   214,
       0,     0,     0,     0,     0,   216,     0,   217,     0,     0,
       0,   218,     0,   219,   220,   221,   222,   223,     0,     0,
       0,     0,     0,     0,   225,   226,   227,     0,  -342,  -342,
     228,     0,  -342,   230,     0,   231,   232,   233,     0,     0,
     234,   235,     0,   236,   237,   238,   239,   240,     0,     0,
       0,     0,   243,   244,   245,     0,     0,   246,   247,  4144,
     248,   249,   250,     0,     0,     0,     0,     0,     0,   252,
       0,   253,     0,   254,     0,   255,   256,   257,   258,   259,
       0,   261,     0,   262,     0,     0,     0,     0,   264,   265,
       0,     0,     0,     0,     0,     0,   268,     0,     0,     0,
     269,   270,   271,   272,   273,  4145,     0,   274,   275,   276,
       0,   277,     0,   278,     0,     0,     0,     0,   279,     0,
       0,     0,     0,   281,     0,   282,   283,     0,   284,   285,
    4146,     0,     0,   286,     0,     0,     0,   288,   289,     0,
       0,   290,  4147,     0,   291,   292,     0,     0,     0,     0,
       0,   293,   294,     0,   295,     0,   296,     0,   297,   298,
       0,     0,     0,     0,  -327,     0,     0,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,     0,   315,   316,   317,   318,     0,   319,
     320,   321,   322,     0,   323,   324,     0,     0,     0,     0,
     325,   326,   327,   328,   329,   330,     0,     0,   331,   332,
       0,   333,     0,   334,     0,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,   344,   345,     0,     0,
     346,   347,   348,   349,     0,     0,     0,     0,   351,     0,
       0,     0,   352,     0,   353,   354,   355,     0,   356,   357,
     358,  4148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   363,   364,     0,     0,     0,     0,
     366,     0,   367,   368,   369,   370,   371,   372,   373,   374,
     375,     0,     0,     0,     0,   378,   379,     0,   380,     0,
     381,   382,   383,   384,   385,     0,   386,   387,   388,     0,
       0,   389,     0,     0,     0,   390,   391,   392,   393,   394,
       0,     0,   395,   396,   397,   398,   399,     0,   400,     0,
       0,   402,     0,   404,  -327,     0,   405,     0,     0,     0,
     407,     0,     0,   409,   410,     0,   411,  4149,   412,     0,
       0,   413,     0,   415,   416,   417,   418,   419,   420,   421,
       0,   423,   424,     0,   425,     0,     0,     0,     0,   427,
     428,   429,     0,     0,     0,     0,   431,     0,     0,     0,
       0,     0,     0,   434,     0,     0,   437,   438,     0,   439,
       0,   441,     0,   443,   444,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,     0,     0,   448,     0,     0,
     449,     0,     0,     0,     0,   451,     0,     0,     0,   453,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
     461,   462,   463,     0,   464,   465,     0,   466,     0,   467,
     468,   469,   470,     0,     0,   471,   472,     0,   473,   474,
     475,   476,     0,     0,     0,     0,     0,   477,   478,   479,
       0,     0,     0,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,     0,     0,     0,     0,     0,   490,     0,
       0,   491,     0,     0,     0,   493,   494,   495,     0,     0,
       0,     0,     0,     0,   496,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,   503,   504,     0,     0,
    -327,     0,     0,     0,   505,     0,     0,   507,     0,   509,
       0,   141,   510,   142,   143,   144,   145,   146,   147,     0,
       0,   148,     0,     0,     0,   149,     0,     0,     0,     0,
     151,   152,   153,   154,   155,   156,   157,     0,     0,  -372,
       0,     0,     0,   160,     0,     0,     0,   161,     0,     0,
     162,   163,   164,     0,   165,     0,     0,     0,     0,     0,
     168,  4142,     0,   169,   170,     0,   171,     0,     0,     0,
       0,     0,   175,   176,   177,   178,  4143,   180,   181,     0,
     182,   183,     0,     0,     0,     0,     0,     0,   189,     0,
     191,     0,   193,   194,   195,   196,     0,   197,   198,     0,
     199,   200,   201,     0,   203,     0,   204,     0,     0,   205,
       0,     0,   206,     0,   207,     0,     0,   208,     0,   209,
       0,     0,     0,   210,   211,   212,     0,     0,   213,     0,
       0,     0,     0,   214,     0,     0,     0,     0,     0,   216,
       0,   217,     0,     0,     0,   218,     0,   219,   220,   221,
     222,   223,     0,     0,     0,     0,     0,     0,   225,   226,
     227,     0,  -363,     0,   228,     0,  -363,   230,     0,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
     239,   240,     0,     0,     0,     0,   243,   244,   245,     0,
       0,   246,   247,  4144,   248,   249,   250,     0,     0,     0,
       0,     0,     0,   252,     0,   253,     0,   254,     0,   255,
     256,   257,   258,   259,     0,   261,     0,   262,     0,     0,
       0,     0,   264,   265,     0,     0,     0,     0,     0,     0,
     268,     0,     0,     0,   269,   270,   271,   272,   273,  4145,
       0,   274,   275,   276,     0,   277,     0,   278,     0,     0,
       0,     0,   279,     0,     0,     0,     0,   281,     0,   282,
     283,     0,   284,   285,  4146,     0,     0,   286,     0,     0,
       0,   288,   289,     0,     0,   290,  4147,     0,   291,   292,
       0,     0,     0,     0,     0,   293,   294,     0,   295,     0,
     296,     0,   297,   298,     0,     0,     0,     0,  -327,     0,
       0,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,     0,   315,   316,
     317,   318,     0,   319,   320,   321,   322,     0,   323,   324,
       0,     0,     0,     0,   325,   326,   327,   328,   329,   330,
       0,     0,   331,   332,     0,   333,     0,   334,     0,   335,
     336,   337,   338,   339,   340,   341,   342,   343,     0,     0,
     344,   345,     0,     0,   346,   347,   348,   349,     0,     0,
       0,     0,   351,     0,     0,     0,   352,     0,   353,   354,
     355,     0,   356,   357,   358,  4148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   363,   364,
       0,     0,     0,     0,   366,     0,   367,   368,   369,   370,
     371,   372,   373,   374,   375,     0,     0,     0,     0,   378,
     379,     0,   380,     0,   381,   382,   383,   384,   385,     0,
     386,   387,   388,     0,     0,   389,     0,     0,     0,   390,
     391,   392,   393,   394,     0,     0,   395,   396,   397,   398,
     399,     0,   400,     0,     0,   402,     0,   404,  -327,     0,
     405,     0,     0,     0,   407,     0,     0,   409,   410,     0,
     411,  4149,   412,     0,     0,   413,     0,   415,   416,   417,
     418,   419,   420,   421,     0,   423,   424,     0,   425,     0,
       0,     0,     0,   427,   428,   429,     0,     0,     0,     0,
     431,     0,     0,     0,     0,     0,     0,   434,     0,     0,
     437,   438,     0,   439,     0,   441,     0,   443,   444,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,     0,
       0,   448,     0,     0,   449,     0,     0,     0,     0,   451,
       0,     0,     0,   453,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   460,   461,   462,   463,     0,   464,   465,
       0,   466,     0,   467,   468,   469,   470,     0,     0,   471,
     472,     0,   473,   474,   475,   476,     0,     0,     0,     0,
       0,   477,   478,   479,     0,     0,     0,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,     0,     0,     0,
       0,     0,   490,     0,     0,   491,     0,     0,     0,   493,
     494,   495,     0,     0,     0,     0,     0,     0,   496,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
     503,   504,  -363,     0,  -327,     0,     0,     0,   505,     0,
       0,   507,     0,   509,     0,   141,   510,   142,   143,   144,
     145,   146,   147,     0,     0,   148,     0,     0,     0,   149,
       0,     0,     0,     0,   151,   152,   153,   154,   155,   156,
     157,     0,     0,  -372,     0,     0,     0,   160,     0,     0,
       0,   161,     0,     0,   162,   163,   164,     0,   165,     0,
       0,     0,     0,     0,   168,  4142,     0,   169,   170,     0,
     171,     0,     0,     0,     0,     0,   175,   176,   177,   178,
    4143,   180,   181,     0,   182,   183,     0,     0,     0,     0,
       0,     0,   189,     0,   191,     0,   193,   194,   195,   196,
       0,   197,   198,     0,   199,   200,   201,     0,   203,     0,
     204,     0,     0,   205,     0,     0,   206,     0,   207,     0,
       0,   208,     0,   209,     0,     0,     0,   210,   211,   212,
       0,     0,   213,     0,     0,     0,     0,   214,     0,     0,
       0,     0,     0,   216,     0,   217,     0,     0,     0,   218,
       0,   219,   220,   221,   222,   223,     0,     0,     0,     0,
       0,     0,   225,   226,   227,     0,  -360,     0,   228,     0,
    -360,   230,     0,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,   239,   240,     0,     0,     0,     0,
     243,   244,   245,     0,     0,   246,   247,  4144,   248,   249,
     250,     0,     0,     0,     0,     0,     0,   252,     0,   253,
       0,   254,     0,   255,   256,   257,   258,   259,     0,   261,
       0,   262,     0,     0,     0,     0,   264,   265,     0,     0,
       0,     0,     0,     0,   268,     0,     0,     0,   269,   270,
     271,   272,   273,  4145,     0,   274,   275,   276,     0,   277,
       0,   278,     0,     0,     0,     0,   279,     0,     0,     0,
       0,   281,     0,   282,   283,     0,   284,   285,  4146,     0,
       0,   286,     0,     0,     0,   288,   289,     0,     0,   290,
    4147,     0,   291,   292,     0,     0,     0,     0,     0,   293,
     294,     0,   295,     0,   296,     0,   297,   298,     0,     0,
       0,     0,  -327,     0,     0,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,     0,   315,   316,   317,   318,     0,   319,   320,   321,
     322,     0,   323,   324,     0,     0,     0,     0,   325,   326,
     327,   328,   329,   330,     0,     0,   331,   332,     0,   333,
       0,   334,     0,   335,   336,   337,   338,   339,   340,   341,
     342,   343,     0,     0,   344,   345,     0,     0,   346,   347,
     348,   349,     0,     0,     0,     0,   351,     0,     0,     0,
     352,     0,   353,   354,   355,     0,   356,   357,   358,  4148,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   363,   364,     0,     0,     0,     0,   366,     0,
     367,   368,   369,   370,   371,   372,   373,   374,   375,     0,
       0,     0,     0,   378,   379,     0,   380,     0,   381,   382,
     383,   384,   385,     0,   386,   387,   388,     0,     0,   389,
       0,     0,     0,   390,   391,   392,   393,   394,     0,     0,
     395,   396,   397,   398,   399,     0,   400,     0,     0,   402,
       0,   404,  -327,     0,   405,     0,     0,     0,   407,     0,
       0,   409,   410,     0,   411,  4149,   412,     0,     0,   413,
       0,   415,   416,   417,   418,   419,   420,   421,     0,   423,
     424,     0,   425,     0,     0,     0,     0,   427,   428,   429,
       0,     0,     0,     0,   431,     0,     0,     0,     0,     0,
       0,   434,     0,     0,   437,   438,     0,   439,     0,   441,
       0,   443,   444,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,     0,     0,   448,     0,     0,   449,     0,
       0,     0,     0,   451,     0,     0,     0,   453,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,   461,   462,
     463,     0,   464,   465,     0,   466,     0,   467,   468,   469,
     470,     0,     0,   471,   472,     0,   473,   474,   475,   476,
       0,     0,     0,     0,     0,   477,   478,   479,     0,     0,
       0,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,     0,     0,     0,     0,     0,   490,     0,     0,   491,
       0,     0,     0,   493,   494,   495,     0,     0,     0,     0,
       0,     0,   496,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,   503,   504,  -360,     0,  -327,     0,
       0,     0,   505,     0,     0,   507,     0,   509,     0,   141,
     510,   142,   143,   144,   145,   146,   147,     0,     0,   148,
       0,     0,     0,   149,     0,     0,     0,     0,   151,   152,
     153,   154,   155,   156,   157,     0,     0,  -372,     0,     0,
       0,   160,     0,     0,     0,   161,     0,     0,   162,   163,
     164,     0,   165,     0,     0,     0,     0,     0,   168,  4142,
       0,   169,   170,     0,   171,     0,     0,     0,     0,     0,
     175,   176,   177,   178,  4143,   180,   181,     0,   182,   183,
       0,     0,     0,     0,     0,     0,   189,     0,   191,     0,
     193,   194,   195,   196,     0,   197,   198,     0,   199,   200,
     201,     0,   203,     0,   204,     0,     0,   205,     0,     0,
     206,     0,   207,     0,     0,   208,     0,   209,     0,     0,
       0,   210,   211,   212,     0,     0,   213,     0,     0,     0,
       0,   214,     0,     0,     0,     0,     0,   216,     0,   217,
       0,     0,     0,   218,     0,   219,   220,   221,   222,   223,
       0,     0,     0,     0,     0,     0,   225,   226,   227,     0,
       0,     0,   228,     0,  4525,   230,     0,   231,   232,   233,
       0,     0,   234,   235,     0,   236,   237,   238,   239,   240,
       0,     0,     0,     0,   243,   244,   245,     0,     0,   246,
     247,  4144,   248,   249,   250,     0,     0,     0,     0,     0,
       0,   252,     0,   253,     0,   254,     0,   255,   256,   257,
     258,   259,     0,   261,     0,   262,     0,     0,     0,     0,
     264,   265,     0,     0,     0,     0,     0,     0,   268,     0,
       0,     0,   269,   270,   271,   272,   273,  4145,     0,   274,
     275,   276,     0,   277,     0,   278,     0,     0,     0,     0,
     279,     0,     0,     0,     0,   281,     0,   282,   283,     0,
     284,   285,  4146,     0,     0,   286,     0,     0,     0,   288,
     289,     0,     0,   290,  4147,     0,   291,   292,     0,     0,
       0,     0,     0,   293,   294,     0,   295,     0,   296,     0,
     297,   298,     0,     0,     0,     0,  -327,     0,     0,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,     0,   315,   316,   317,   318,
       0,   319,   320,   321,   322,     0,   323,   324,     0,     0,
       0,     0,   325,   326,   327,   328,   329,   330,     0,     0,
     331,   332,     0,   333,     0,   334,     0,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,   344,   345,
       0,     0,   346,   347,   348,   349,     0,     0,     0,     0,
     351,     0,     0,     0,   352,     0,   353,   354,   355,     0,
     356,   357,   358,  4148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   363,   364,     0,     0,
       0,     0,   366,     0,   367,   368,   369,   370,   371,   372,
     373,   374,   375,     0,     0,     0,     0,   378,   379,     0,
     380,     0,   381,   382,   383,   384,   385,     0,   386,   387,
     388,     0,     0,   389,     0,     0,     0,   390,   391,   392,
     393,   394,     0,     0,   395,   396,   397,   398,   399,     0,
     400,     0,     0,   402,     0,   404,  -327,     0,   405,     0,
       0,     0,   407,     0,     0,   409,   410,     0,   411,  4149,
     412,     0,     0,   413,     0,   415,   416,   417,   418,   419,
     420,   421,     0,   423,   424,     0,   425,     0,     0,     0,
       0,   427,   428,   429,     0,     0,     0,     0,   431,     0,
       0,     0,     0,     0,     0,   434,     0,     0,   437,   438,
       0,   439,     0,   441,     0,   443,   444,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,     0,     0,   448,
       0,     0,   449,     0,     0,     0,     0,   451,     0,     0,
       0,   453,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,   461,   462,   463,     0,   464,   465,     0,   466,
       0,   467,   468,   469,   470,     0,     0,   471,   472,     0,
     473,   474,   475,   476,     0,     0,     0,     0,     0,   477,
     478,   479,     0,     0,     0,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,     0,     0,     0,     0,     0,
     490,     0,     0,   491,     0,     0,     0,   493,   494,   495,
       0,     0,     0,     0,     0,     0,   496,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,   503,   504,
       0,     0,  -327,     0,     0,     0,   505,     0,     0,   507,
       0,   509,     0,   141,   510,   142,   143,   144,   145,   146,
     147,     0,     0,   148,     0,     0,     0,   149,     0,     0,
       0,     0,   151,   152,   153,   154,   155,   156,   157,     0,
       0,  -372,     0,     0,     0,   160,     0,     0,     0,   161,
       0,     0,   162,   163,   164,     0,   165,     0,     0,     0,
       0,     0,   168,  4142,     0,   169,   170,     0,   171,     0,
       0,     0,     0,     0,   175,   176,   177,   178,  4143,   180,
     181,     0,   182,   183,     0,     0,     0,     0,     0,     0,
     189,     0,   191,     0,   193,   194,   195,   196,     0,   197,
     198,     0,   199,   200,   201,     0,   203,     0,   204,     0,
       0,   205,     0,     0,   206,     0,   207,     0,     0,   208,
       0,   209,     0,     0,     0,   210,   211,   212,     0,     0,
     213,     0,     0,     0,     0,   214,     0,     0,     0,     0,
       0,   216,     0,   217,     0,     0,     0,   218,     0,   219,
     220,   221,   222,   223,     0,     0,     0,     0,     0,     0,
     225,   226,   227,     0,     0,     0,   228,     0,  -365,   230,
       0,   231,   232,   233,     0,     0,   234,   235,     0,   236,
     237,   238,   239,   240,     0,     0,     0,     0,   243,   244,
     245,     0,     0,   246,   247,  4144,   248,   249,   250,     0,
       0,     0,     0,     0,     0,   252,     0,   253,     0,   254,
       0,   255,   256,   257,   258,   259,     0,   261,     0,   262,
       0,     0,     0,     0,   264,   265,     0,     0,     0,     0,
       0,     0,   268,     0,     0,     0,   269,   270,   271,   272,
     273,  4145,     0,   274,   275,   276,     0,   277,     0,   278,
       0,     0,     0,     0,   279,     0,     0,     0,     0,   281,
       0,   282,   283,     0,   284,   285,  4146,     0,     0,   286,
       0,     0,     0,   288,   289,     0,     0,   290,  4147,     0,
     291,   292,     0,     0,     0,     0,     0,   293,   294,     0,
     295,     0,   296,     0,   297,   298,     0,     0,     0,     0,
    -327,     0,     0,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,     0,
     315,   316,   317,   318,     0,   319,   320,   321,   322,     0,
     323,   324,     0,     0,     0,     0,   325,   326,   327,   328,
     329,   330,     0,     0,   331,   332,     0,   333,     0,   334,
       0,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,   344,   345,     0,     0,   346,   347,   348,   349,
       0,     0,     0,     0,   351,     0,     0,     0,   352,     0,
     353,   354,   355,     0,   356,   357,   358,  4148,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     363,   364,     0,     0,     0,     0,   366,     0,   367,   368,
     369,   370,   371,   372,   373,   374,   375,     0,     0,     0,
       0,   378,   379,     0,   380,     0,   381,   382,   383,   384,
     385,     0,   386,   387,   388,     0,     0,   389,     0,     0,
       0,   390,   391,   392,   393,   394,     0,     0,   395,   396,
     397,   398,   399,     0,   400,     0,     0,   402,     0,   404,
    -327,     0,   405,     0,     0,     0,   407,     0,     0,   409,
     410,     0,   411,  4149,   412,     0,     0,   413,     0,   415,
     416,   417,   418,   419,   420,   421,     0,   423,   424,     0,
     425,     0,     0,     0,     0,   427,   428,   429,     0,     0,
       0,     0,   431,     0,     0,     0,     0,     0,     0,   434,
       0,     0,   437,   438,     0,   439,     0,   441,     0,   443,
     444,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,     0,     0,   448,     0,     0,   449,     0,     0,     0,
       0,   451,     0,     0,     0,   453,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,   461,   462,   463,     0,
     464,   465,     0,   466,     0,   467,   468,   469,   470,     0,
       0,   471,   472,     0,   473,   474,   475,   476,     0,     0,
       0,     0,     0,   477,   478,   479,     0,     0,     0,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,     0,
       0,     0,     0,     0,   490,     0,     0,   491,     0,     0,
       0,   493,   494,   495,     0,     0,     0,     0,     0,     0,
     496,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,   503,   504,     0,     0,  -327,     0,     0,     0,
     505,     0,     0,   507,     0,   509,     0,   141,   510,   142,
     143,   144,   145,   146,   147,     0,     0,   148,     0,     0,
       0,   149,     0,     0,     0,     0,   151,   152,   153,   154,
     155,   156,   157,     0,     0,  -372,     0,     0,     0,   160,
       0,     0,     0,   161,     0,     0,   162,   163,   164,     0,
     165,     0,     0,     0,     0,     0,   168,  4142,     0,   169,
     170,     0,   171,     0,     0,     0,     0,     0,   175,   176,
     177,   178,  4143,   180,   181,     0,   182,   183,     0,     0,
       0,     0,     0,     0,   189,     0,   191,     0,   193,   194,
     195,   196,     0,   197,   198,     0,   199,   200,   201,     0,
     203,     0,   204,     0,     0,   205,     0,     0,   206,     0,
     207,     0,     0,   208,     0,   209,     0,     0,     0,   210,
     211,   212,     0,     0,   213,     0,     0,     0,     0,   214,
       0,     0,     0,     0,     0,   216,     0,   217,     0,     0,
       0,   218,     0,   219,   220,   221,   222,   223,     0,     0,
       0,     0,     0,     0,   225,   226,   227,     0,     0,     0,
     228,     0,  4662,   230,     0,   231,   232,   233,     0,     0,
     234,   235,     0,   236,   237,   238,   239,   240,     0,     0,
       0,     0,   243,   244,   245,     0,     0,   246,   247,  4144,
     248,   249,   250,     0,     0,     0,     0,     0,     0,   252,
       0,   253,     0,   254,     0,   255,   256,   257,   258,   259,
       0,   261,     0,   262,     0,     0,     0,     0,   264,   265,
       0,     0,     0,     0,     0,     0,   268,     0,     0,     0,
     269,   270,   271,   272,   273,  4145,     0,   274,   275,   276,
       0,   277,     0,   278,     0,     0,     0,     0,   279,     0,
       0,     0,     0,   281,     0,   282,   283,     0,   284,   285,
    4146,     0,     0,   286,     0,     0,     0,   288,   289,     0,
       0,   290,  4147,     0,   291,   292,     0,     0,     0,     0,
       0,   293,   294,     0,   295,     0,   296,     0,   297,   298,
       0,     0,     0,     0,  -327,     0,     0,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,     0,   315,   316,   317,   318,     0,   319,
     320,   321,   322,     0,   323,   324,     0,     0,     0,     0,
     325,   326,   327,   328,   329,   330,     0,     0,   331,   332,
       0,   333,     0,   334,     0,   335,   336,   337,   338,   339,
     340,   341,   342,   343,     0,     0,   344,   345,     0,     0,
     346,   347,   348,   349,     0,     0,     0,     0,   351,     0,
       0,     0,   352,     0,   353,   354,   355,     0,   356,   357,
     358,  4148,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   363,   364,     0,     0,     0,     0,
     366,     0,   367,   368,   369,   370,   371,   372,   373,   374,
     375,     0,     0,     0,     0,   378,   379,     0,   380,     0,
     381,   382,   383,   384,   385,     0,   386,   387,   388,     0,
       0,   389,     0,     0,     0,   390,   391,   392,   393,   394,
       0,     0,   395,   396,   397,   398,   399,     0,   400,     0,
       0,   402,     0,   404,  -327,     0,   405,     0,     0,     0,
     407,     0,     0,   409,   410,     0,   411,  4149,   412,     0,
       0,   413,     0,   415,   416,   417,   418,   419,   420,   421,
       0,   423,   424,     0,   425,     0,     0,     0,     0,   427,
     428,   429,     0,     0,     0,     0,   431,     0,     0,     0,
       0,     0,     0,   434,     0,     0,   437,   438,     0,   439,
       0,   441,     0,   443,   444,     0,     0,     0,     0,     0,
       0,   445,   446,     0,   447,     0,     0,   448,     0,     0,
     449,     0,     0,     0,     0,   451,     0,     0,     0,   453,
       0,   454,   455,   456,   457,   458,   459,     0,     0,   460,
     461,   462,   463,     0,   464,   465,     0,   466,     0,   467,
     468,   469,   470,     0,     0,   471,   472,     0,   473,   474,
     475,   476,     0,     0,     0,     0,     0,   477,   478,   479,
       0,     0,     0,     0,   481,   482,   483,     0,   484,   485,
       0,   486,   487,     0,     0,     0,     0,     0,   490,     0,
       0,   491,     0,     0,     0,   493,   494,   495,     0,     0,
       0,     0,     0,     0,   496,     0,     0,   497,     0,     0,
       0,   498,   499,   500,   501,   502,   503,   504,     0,     0,
    -327,     0,     0,     0,   505,     0,     0,   507,     0,   509,
       0,   141,   510,   142,   143,   144,   145,   146,   147,     0,
       0,   148,     0,     0,     0,   149,     0,     0,     0,     0,
     151,   152,   153,   154,   155,   156,   157,     0,     0,  -372,
       0,     0,     0,   160,     0,     0,     0,   161,     0,     0,
     162,   163,   164,     0,   165,     0,     0,     0,     0,     0,
     168,  4142,     0,   169,   170,     0,   171,     0,     0,     0,
       0,     0,   175,   176,   177,   178,  4143,   180,   181,     0,
     182,   183,     0,     0,     0,     0,     0,     0,   189,     0,
     191,     0,   193,   194,   195,   196,     0,   197,   198,     0,
     199,   200,   201,     0,   203,     0,   204,     0,     0,   205,
       0,     0,   206,     0,   207,     0,     0,   208,     0,   209,
       0,     0,     0,   210,   211,   212,     0,     0,   213,     0,
       0,     0,     0,   214,     0,     0,     0,     0,     0,   216,
       0,   217,     0,     0,     0,   218,     0,   219,   220,   221,
     222,   223,     0,     0,     0,     0,     0,     0,   225,   226,
     227,     0,     0,     0,   228,     0,  4715,   230,     0,   231,
     232,   233,     0,     0,   234,   235,     0,   236,   237,   238,
     239,   240,     0,     0,     0,     0,   243,   244,   245,     0,
       0,   246,   247,  4144,   248,   249,   250,     0,     0,     0,
       0,     0,     0,   252,     0,   253,     0,   254,     0,   255,
     256,   257,   258,   259,     0,   261,     0,   262,     0,     0,
       0,     0,   264,   265,     0,     0,     0,     0,     0,     0,
     268,     0,     0,     0,   269,   270,   271,   272,   273,  4145,
       0,   274,   275,   276,     0,   277,     0,   278,     0,     0,
       0,     0,   279,     0,     0,     0,     0,   281,     0,   282,
     283,     0,   284,   285,  4146,     0,     0,   286,     0,     0,
       0,   288,   289,     0,     0,   290,  4147,     0,   291,   292,
       0,     0,     0,     0,     0,   293,   294,     0,   295,     0,
     296,     0,   297,   298,     0,     0,     0,     0,  -327,     0,
       0,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,     0,   315,   316,
     317,   318,     0,   319,   320,   321,   322,     0,   323,   324,
       0,     0,     0,     0,   325,   326,   327,   328,   329,   330,
       0,     0,   331,   332,     0,   333,     0,   334,     0,   335,
     336,   337,   338,   339,   340,   341,   342,   343,     0,     0,
     344,   345,     0,     0,   346,   347,   348,   349,     0,     0,
       0,     0,   351,     0,     0,     0,   352,     0,   353,   354,
     355,     0,   356,   357,   358,  4148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   363,   364,
       0,     0,     0,     0,   366,     0,   367,   368,   369,   370,
     371,   372,   373,   374,   375,     0,     0,     0,     0,   378,
     379,     0,   380,     0,   381,   382,   383,   384,   385,     0,
     386,   387,   388,     0,     0,   389,     0,     0,     0,   390,
     391,   392,   393,   394,     0,     0,   395,   396,   397,   398,
     399,     0,   400,     0,     0,   402,     0,   404,  -327,     0,
     405,     0,     0,     0,   407,     0,     0,   409,   410,     0,
     411,  4149,   412,     0,     0,   413,     0,   415,   416,   417,
     418,   419,   420,   421,     0,   423,   424,     0,   425,     0,
       0,     0,     0,   427,   428,   429,     0,     0,     0,     0,
     431,     0,     0,     0,     0,     0,     0,   434,     0,     0,
     437,   438,     0,   439,     0,   441,     0,   443,   444,     0,
       0,     0,     0,     0,     0,   445,   446,     0,   447,     0,
       0,   448,     0,     0,   449,     0,     0,     0,     0,   451,
       0,     0,     0,   453,     0,   454,   455,   456,   457,   458,
     459,     0,     0,   460,   461,   462,   463,     0,   464,   465,
       0,   466,     0,   467,   468,   469,   470,     0,     0,   471,
     472,     0,   473,   474,   475,   476,     0,     0,     0,     0,
       0,   477,   478,   479,     0,     0,     0,     0,   481,   482,
     483,     0,   484,   485,     0,   486,   487,     0,     0,     0,
       0,     0,   490,     0,     0,   491,     0,     0,     0,   493,
     494,   495,     0,     0,     0,     0,     0,     0,   496,     0,
       0,   497,     0,     0,     0,   498,   499,   500,   501,   502,
     503,   504,     0,     0,  -327,     0,     0,     0,   505,     0,
       0,   507,     0,   509,     0,   141,   510,   142,   143,   144,
     145,   146,   147,     0,     0,   148,     0,     0,     0,   149,
       0,     0,     0,     0,   151,   152,   153,   154,   155,   156,
     157,     0,     0,  -372,     0,     0,     0,   160,     0,     0,
       0,   161,     0,     0,   162,   163,   164,     0,   165,     0,
       0,     0,     0,     0,   168,  4142,     0,   169,   170,     0,
     171,     0,     0,     0,     0,     0,   175,   176,   177,   178,
    4143,   180,   181,     0,   182,   183,     0,     0,     0,     0,
       0,     0,   189,     0,   191,     0,   193,   194,   195,   196,
       0,   197,   198,     0,   199,   200,   201,     0,   203,     0,
     204,     0,     0,   205,     0,     0,   206,     0,   207,     0,
       0,   208,     0,   209,     0,     0,     0,   210,   211,   212,
       0,     0,   213,     0,     0,     0,     0,   214,     0,     0,
       0,     0,     0,   216,     0,   217,     0,     0,     0,   218,
       0,   219,   220,   221,   222,   223,     0,     0,     0,     0,
       0,     0,   225,   226,   227,     0,     0,     0,   228,     0,
    -346,   230,     0,   231,   232,   233,     0,     0,   234,   235,
       0,   236,   237,   238,   239,   240,     0,     0,     0,     0,
     243,   244,   245,     0,     0,   246,   247,  4144,   248,   249,
     250,     0,     0,     0,     0,     0,     0,   252,     0,   253,
       0,   254,     0,   255,   256,   257,   258,   259,     0,   261,
       0,   262,     0,     0,     0,     0,   264,   265,     0,     0,
       0,     0,     0,     0,   268,     0,     0,     0,   269,   270,
     271,   272,   273,  4145,     0,   274,   275,   276,     0,   277,
       0,   278,     0,     0,     0,     0,   279,     0,     0,     0,
       0,   281,     0,   282,   283,     0,   284,   285,  4146,     0,
       0,   286,     0,     0,     0,   288,   289,     0,     0,   290,
    4147,     0,   291,   292,     0,     0,     0,     0,     0,   293,
     294,     0,   295,     0,   296,     0,   297,   298,     0,     0,
       0,     0,  -327,     0,     0,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,     0,   315,   316,   317,   318,     0,   319,   320,   321,
     322,     0,   323,   324,     0,     0,     0,     0,   325,   326,
     327,   328,   329,   330,     0,     0,   331,   332,     0,   333,
       0,   334,     0,   335,   336,   337,   338,   339,   340,   341,
     342,   343,     0,     0,   344,   345,     0,     0,   346,   347,
     348,   349,     0,     0,     0,     0,   351,     0,     0,     0,
     352,     0,   353,   354,   355,     0,   356,   357,   358,  4148,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   363,   364,     0,     0,     0,     0,   366,     0,
     367,   368,   369,   370,   371,   372,   373,   374,   375,     0,
       0,     0,     0,   378,   379,     0,   380,     0,   381,   382,
     383,   384,   385,     0,   386,   387,   388,     0,     0,   389,
       0,     0,     0,   390,   391,   392,   393,   394,     0,     0,
     395,   396,   397,   398,   399,     0,   400,     0,     0,   402,
       0,   404,  -327,     0,   405,     0,     0,     0,   407,     0,
       0,   409,   410,     0,   411,  4149,   412,     0,     0,   413,
       0,   415,   416,   417,   418,   419,   420,   421,     0,   423,
     424,     0,   425,     0,     0,     0,     0,   427,   428,   429,
       0,     0,     0,     0,   431,     0,     0,     0,     0,     0,
       0,   434,     0,     0,   437,   438,     0,   439,     0,   441,
       0,   443,   444,     0,     0,     0,     0,     0,     0,   445,
     446,     0,   447,     0,     0,   448,     0,     0,   449,     0,
       0,     0,     0,   451,     0,     0,     0,   453,     0,   454,
     455,   456,   457,   458,   459,     0,     0,   460,   461,   462,
     463,     0,   464,   465,     0,   466,     0,   467,   468,   469,
     470,     0,     0,   471,   472,     0,   473,   474,   475,   476,
       0,     0,     0,     0,     0,   477,   478,   479,     0,     0,
       0,     0,   481,   482,   483,     0,   484,   485,     0,   486,
     487,     0,     0,     0,     0,     0,   490,     0,     0,   491,
       0,     0,     0,   493,   494,   495,     0,     0,     0,     0,
       0,     0,   496,     0,     0,   497,     0,     0,     0,   498,
     499,   500,   501,   502,   503,   504,     0,     0,  -327,     0,
       0,     0,   505,     0,     0,   507,     0,   509,     0,   141,
     510,   142,   143,   144,   145,   146,   147,     0,     0,   148,
       0,     0,     0,   149,     0,     0,     0,     0,   151,   152,
     153,   154,   155,   156,   157,     0,     0,  -372,     0,     0,
       0,   160,     0,     0,     0,   161,     0,     0,   162,   163,
     164,     0,   165,     0,     0,     0,     0,     0,   168,  4142,
       0,   169,   170,     0,   171,     0,     0,     0,     0,     0,
     175,   176,   177,   178,  4143,   180,   181,     0,   182,   183,
       0,     0,     0,     0,     0,     0,   189,     0,   191,     0,
     193,   194,   195,   196,     0,   197,   198,     0,   199,   200,
     201,     0,   203,     0,   204,     0,     0,   205,     0,     0,
     206,     0,   207,     0,     0,   208,     0,   209,     0,     0,
       0,   210,   211,   212,     0,     0,   213,     0,     0,     0,
       0,   214,     0,     0,     0,     0,     0,   216,     0,   217,
       0,     0,     0,   218,     0,   219,   220,   221,   222,   223,
       0,     0,     0,     0,     0,     0,   225,   226,   227,     0,
       0,     0,   228,     0,     0,   230,     0,   231,   232,   233,
       0,     0,   234,   235,     0,   236,   237,   238,   239,   240,
       0,     0,     0,     0,   243,   244,   245,     0,     0,   246,
     247,  4144,   248,   249,   250,     0,     0,     0,     0,     0,
       0,   252,     0,   253,     0,   254,     0,   255,   256,   257,
     258,   259,     0,   261,     0,   262,     0,     0,     0,     0,
     264,   265,     0,     0,     0,     0,     0,     0,   268,     0,
       0,     0,   269,   270,   271,   272,   273,  4145,     0,   274,
     275,   276,     0,   277,     0,   278,     0,     0,     0,     0,
     279,     0,     0,     0,     0,   281,     0,   282,   283,     0,
     284,   285,  4146,     0,     0,   286,     0,     0,     0,   288,
     289,     0,     0,   290,  4147,     0,   291,   292,     0,     0,
       0,     0,     0,   293,   294,     0,   295,     0,   296,     0,
     297,   298,     0,     0,     0,     0,  -327,     0,     0,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,     0,   315,   316,   317,   318,
       0,   319,   320,   321,   322,     0,   323,   324,     0,     0,
       0,     0,   325,   326,   327,   328,   329,   330,     0,     0,
     331,   332,     0,   333,     0,   334,     0,   335,   336,   337,
     338,   339,   340,   341,   342,   343,     0,     0,   344,   345,
       0,     0,   346,   347,   348,   349,     0,     0,     0,     0,
     351,     0,     0,     0,   352,     0,   353,   354,   355,     0,
     356,   357,   358,  4148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   363,   364,     0,     0,
       0,     0,   366,     0,   367,   368,   369,   370,   371,   372,
     373,   374,   375,     0,     0,     0,     0,   378,   379,     0,
     380,     0,   381,   382,   383,   384,   385,     0,   386,   387,
     388,     0,     0,   389,     0,     0,     0,   390,   391,   392,
     393,   394,     0,     0,   395,   396,   397,   398,   399,     0,
     400,     0,     0,   402,     0,   404,  -327,     0,   405,     0,
       0,     0,   407,     0,     0,   409,   410,     0,   411,  4149,
     412,     0,     0,   413,     0,   415,   416,   417,   418,   419,
     420,   421,     0,   423,   424,     0,   425,     0,     0,     0,
       0,   427,   428,   429,     0,     0,     0,     0,   431,     0,
       0,     0,     0,     0,     0,   434,     0,     0,   437,   438,
       0,   439,     0,   441,     0,   443,   444,     0,     0,     0,
       0,     0,     0,   445,   446,     0,   447,     0,     0,   448,
       0,     0,   449,     0,     0,     0,     0,   451,     0,     0,
       0,   453,     0,   454,   455,   456,   457,   458,   459,     0,
       0,   460,   461,   462,   463,     0,   464,   465,     0,   466,
       0,   467,   468,   469,   470,     0,     0,   471,   472,     0,
     473,   474,   475,   476,     0,     0,     0,     0,     0,   477,
     478,   479,     0,     0,     0,     0,   481,   482,   483,     0,
     484,   485,     0,   486,   487,     0,     0,     0,     0,     0,
     490,     0,     0,   491,     0,     0,     0,   493,   494,   495,
       0,     0,     0,     0,     0,     0,   496,     0,     0,   497,
       0,     0,     0,   498,   499,   500,   501,   502,   503,   504,
       0,     0,  -327,     0,     0,     0,   505,     0,     0,   507,
       0,   509,     0,   141,   510,   142,   143,   144,   145,   146,
     147,     0,     0,   148,     0,     0,     0,   149,     0,     0,
       0,     0,   151,   152,   153,   154,   155,   156,   157,     0,
       0,  -372,     0,     0,     0,   160,     0,     0,     0,   161,
       0,     0,   162,   163,   164,     0,   165,     0,     0,     0,
       0,     0,   168,  4142,     0,   169,   170,     0,   171,     0,
       0,     0,     0,     0,   175,   176,   177,   178,  4143,   180,
     181,     0,   182,   183,     0,     0,     0,     0,     0,     0,
     189,     0,   191,     0,   193,   194,   195,   196,     0,   197,
     198,     0,   199,   200,   201,     0,   203,     0,   204,     0,
       0,   205,     0,     0,   206,     0,   207,     0,     0,   208,
       0,   209,     0,     0,     0,   210,   211,   212,     0,     0,
     213,     0,     0,     0,     0,   214,     0,     0,     0,     0,
       0,   216,     0,   217,     0,     0,     0,   218,     0,   219,
     220,   221,   222,   223,     0,     0,     0,     0,     0,     0,
     225,   226,   227,     0,     0,     0,   228,     0,     0,   230,
       0,   231,   232,   233,     0,     0,   234,   235,     0,   236,
     237,   238,   239,   240,     0,     0,     0,     0,   243,   244,
     245,     0,     0,   246,   247,  4144,   248,   249,   250,     0,
       0,     0,     0,     0,     0,   252,     0,   253,     0,   254,
       0,   255,   256,   257,   258,   259,     0,   261,     0,   262,
       0,     0,     0,     0,   264,   265,     0,     0,     0,     0,
       0,     0,   268,     0,     0,     0,   269,   270,   271,   272,
     273,  4145,     0,   274,   275,   276,     0,   277,     0,   278,
       0,     0,     0,     0,   279,     0,     0,     0,     0,   281,
       0,   282,   283,     0,   284,   285,  4146,     0,     0,   286,
       0,     0,     0,   288,   289,     0,     0,   290,  4147,     0,
     291,   292,     0,     0,     0,     0,     0,   293,   294,     0,
     295,     0,   296,     0,   297,   298,     0,     0,     0,     0,
    -327,     0,     0,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,     0,
     315,   316,   317,   318,     0,   319,   320,   321,   322,     0,
     323,   324,     0,     0,     0,     0,   325,   326,   327,   328,
     329,   330,     0,     0,   331,   332,     0,   333,     0,   334,
       0,   335,   336,   337,   338,   339,   340,   341,   342,   343,
       0,     0,   344,   345,     0,     0,   346,   347,   348,   349,
       0,     0,     0,     0,   351,     0,     0,     0,   352,     0,
     353,   354,   355,     0,   356,   357,   358,  4148,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     363,   364,     0,     0,     0,     0,   366,     0,   367,   368,
     369,   370,   371,   372,   373,   374,   375,     0,     0,     0,
       0,   378,   379,     0,   380,     0,   381,   382,   383,   384,
     385,     0,   386,   387,   388,     0,     0,   389,     0,     0,
       0,   390,   391,   392,   393,   394,     0,     0,   395,   396,
     397,   398,   399,     0,   400,     0,     0,   402,     0,   404,
    -327,     0,   405,     0,     0,     0,   407,     0,     0,   409,
     410,     0,   411,  4149,   412,     0,     0,   413,     0,   415,
     416,   417,   418,   419,   420,   421,     0,   423,   424,     0,
     425,     0,     0,     0,     0,   427,   428,   429,     0,     0,
       0,     0,   431,     0,     0,     0,     0,     0,     0,   434,
       0,     0,   437,   438,     0,   439,     0,   441,     0,   443,
     444,     0,     0,     0,     0,     0,     0,   445,   446,     0,
     447,     0,     0,   448,     0,     0,   449,     0,     0,     0,
       0,   451,     0,     0,     0,   453,     0,   454,   455,   456,
     457,   458,   459,     0,     0,   460,   461,   462,   463,     0,
     464,   465,     0,   466,     0,   467,   468,   469,   470,     0,
       0,   471,   472,     0,   473,   474,   475,   476,     0,     0,
       0,     0,     0,   477,   478,   479,     0,     0,     0,     0,
     481,   482,   483,     0,   484,   485,     0,   486,   487,     0,
       0,     0,     0,     0,   490,     0,     0,  4528,     0,     0,
       0,   493,   494,   495,     0,     0,     0,     0,     0,     0,
     496,     0,     0,   497,     0,     0,     0,   498,   499,   500,
     501,   502,   503,   504,     0,     0,  -327,     0,     0,     0,
     505,     0,     0,   507,     0,   509,     0,     0,   510
};

static const yytype_int16 yycheck[] =
{
       6,   666,   577,   599,  1039,   622,   598,   599,    20,  1040,
     931,   636,  1165,    19,  1336,  1239,  1639,    23,    30,  2114,
     951,   952,  1952,  1953,  1596,    37,  1137,    33,   523,  2114,
     127,   962,  1787,     6,    40,   999,   837,    43,  1484,   974,
    1484,  1183,    48,  1464,  1239,  1635,  1636,  1594,  2403,    55,
     544,   545,   546,  1382,   548,  2224,   550,   972,   741,   553,
    1207,   555,  1262,  2441,   999,  2534,  2606,  2236,  1363,  1269,
    2545,  3028,  3372,  2095,  1336,     4,  1304,  2667,   561,  2365,
    2887,  1390,  3074,  2952,   542,  1000,  1174,   673,  2563,  2564,
     602,   694,    98,   605,  2803,  2114,   662,   663,  1044,  1044,
     561,   676,   677,    23,  1018,  2327,  1863,  1937,  2463,   592,
    1574,  3079,  2237,  2572,  2511,  3029,   122,  2506,   124,  2184,
     126,   127,   128,  1270,  1271,  2184,    18,  1274,  1275,  1276,
    1277,   592,  1279,  1280,  1281,  1282,  1283,  1284,  1285,  1286,
      13,  2112,  2112,   808,    13,  2574,  1495,  2961,  3168,  2578,
    2514,   124,  3631,   126,  1618,    20,    26,  2733,  2734,  2523,
    2589,  1075,    21,  2739,    36,  2741,  1515,  1564,  3254,    53,
    3434,    20,  2601,  3184,  1523,  1524,    17,    18,    98,   133,
       9,    17,    18,  1951,    20,    75,   681,    49,   683,   684,
     685,   118,    32,    26,   797,   798,   799,  1001,  2673,  2674,
      29,    17,    18,    83,    18,  2207,   809,    36,   669,   116,
      13,  2321,  2736,  2184,  2184,  2171,   156,    22,   181,    83,
      13,    20,  3671,    62,   136,  2880,   156,   169,    17,    18,
      84,    20,  2563,  2564,    17,    18,  4181,   194,   275,   676,
     677,    22,   136,  3192,    22,   130,   150,  3562,    70,    12,
      83,  2567,    20,   839,   377,    36,    61,    62,    36,  3389,
      91,    65,    53,    58,  2104,   201,  4078,   276,    87,    50,
     162,    45,    50,   275,    66,   132,    73,   234,   137,    65,
      61,    62,   324,    61,    62,    36,    12,   369,    17,    18,
     379,  3692,   400,  2315,   132,    11,  4395,   162,   293,   234,
     417,   166,   403,   259,   132,   162,     9,   136,   430,   198,
    2996,   238,    89,   145,   668,   212,   455,   152,   256,  3798,
     906,  3007,   132,   484,   162,  4093,  2704,  3627,    17,    18,
    2719,   164,  2721,    17,    18,   435,   156,   278,    17,    18,
      13,  4388,  2673,  2674,    21,    13,  1574,   841,   133,   182,
     256,   245,   162,    83,   133,   406,    38,   402,   166,   276,
     249,   562,   259,   406,   282,   250,   230,   166,   232,   533,
     133,   241,   444,   594,   835,   365,   385,   290,  4323,   363,
      13,  3830,    38,  2067,  2068,   198,    17,    18,   629,    72,
    1618,    66,  2058,   819,    17,    18,   238,   261,   166,   217,
    2084,  1058,  1059,   173,    17,    18,    21,   524,   241,   195,
      36,    72,   143,   654,   527,  3730,  3731,  2101,  2102,  3734,
     262,    17,    18,  2086,  2682,   614,   562,   158,   617,   413,
     527,   201,   653,  3882,  2709,   430,    62,   273,  3753,   252,
      17,    18,    75,   108,   262,  3760,  1103,  3476,   561,   367,
     320,   615,   162,   525,  4501,   445,   369,  2459,   659,   510,
     137,   578,    68,   426,   561,   257,   251,   510,   385,   566,
      17,    18,   251,   146,    17,    18,  2488,   162,   146,   833,
     992,   417,  2166,  2167,  2168,  2169,   189,   320,   385,   589,
    1173,   652,   430,   919,   293,   592,   385,   329,  4266,  1300,
     230,   151,   232,   620,  1187,   461,  2528,   629,  1539,  2898,
    2899,   634,    17,    18,   198,   654,   293,   562,   453,   198,
     621,   527,   137,   529,   430,   562,  1457,   360,  2894,  2895,
    2896,   261,   473,   366,  1109,  1110,  1111,  3004,   220,   221,
     368,  4640,  4641,   384,   652,   551,   387,   432,   384,  3363,
    3680,   387,  1973,  3367,   389,   561,   562,    17,    18,   285,
     566,   312,   568,   645,   220,   221,   276,   198,  3868,   361,
     365,   660,   669,   196,  1489,   581,   460,  1492,   352,    26,
    4392,  1496,   257,  1498,   166,   594,   592,   516,   492,   386,
     627,   276,   598,  3897,   425,   384,  2567,  2567,   387,  3074,
    1265,   384,   608,  3312,   387,  4006,  2625,   466,   430,  1837,
     652,  1526,  1527,    17,    18,  1937,  1551,  2682,  1564,  1564,
     556,   627,  2086,  2682,   387,   627,  3941,  2520,  2650,   415,
     636,   430,   638,  2655,   438,  3950,   166,  1074,  3902,   634,
     569,  2663,  2664,    17,    18,   651,  3666,  2669,  2112,   606,
     656,  3126,   658,  1336,   539,   384,   662,   663,   387,  3974,
     479,   667,   668,   669,  3979,  3374,  3321,   673,  1815,   460,
    1273,  1617,  1617,   602,   166,  1937,   605,  2993,   651,  1826,
     609,   623,  1829,   689,  2033,   493,   626,  1290,   600,  1603,
    1127,   654,  1150,  1151,  2804,   384,   626,  2465,   387,   502,
     384,   417,  3388,   387,   537,   384,   600,  2171,   387,   502,
     637,  2682,  2682,   620,  3400,   595,  2718,  1521,  1176,  2675,
    2184,  1809,    17,    18,   678,  2565,  1184,   556,  1186,  3598,
    3416,  3417,   586,   573,   526,   741,   656,   629,   835,   836,
    1198,  1199,  1200,  1309,  3430,    17,    18,   576,  1206,  4013,
     542,  4696,  4201,   384,  3765,   584,   387,   619,   607,   573,
    4024,   384,   652,  1916,   387,   629,   658,   629,  2165,  1355,
     654,   384,   575,  1574,   387,   614,  3690,  1363,  3167,   652,
     652,   610,  3731,   652,   654,  3325,   645,   592,   384,   622,
    4239,   387,  4056,   658,   241,  3126,   802,   638,   804,    17,
      18,   658,   638,  3889,  1429,   573,   626,   384,   524,   595,
     387,   592,    17,    18,   592,  1327,   657,  1618,   654,  1385,
     658,   654,   638,   829,   830,   831,   832,   833,   834,   835,
     836,  4310,   838,   839,   484,   634,  1402,   384,   844,   617,
     387,   384,  1428,   635,   387,  3659,  3660,  2513,   658,   638,
     533,   466,   660,   583,   951,   638,   953,   830,  2086,   956,
     957,   834,   578,  2410,  3884,   838,  1452,   542,  1493,  3127,
     653,   654,   533,   320,   652,   881,   973,   607,   607,   384,
     562,  3156,   387,  2546,   136,    17,    18,   181,   894,  2573,
    3919,    75,  2576,  2577,  2824,  2579,   502,  1409,  2582,  2583,
     906,   907,  2586,  2526,   620,   911,   562,  2591,   562,   638,
    2922,   493,  2596,  2597,  2598,  2599,  2600,   627,  3385,   366,
    2604,  2605,   385,  2607,   384,   654,   198,   387,    73,  2613,
    2614,  2615,  2616,   375,  2864,  2619,  2620,  3414,  2622,    53,
    3318,  3410,   627,  2171,  4248,   951,  4250,   953,   658,   638,
     956,   957,    17,    18,   638,   166,  2184,    17,    18,   638,
    3357,   373,  3328,   493,   653,   654,    48,   973,  4447,  3064,
     654,   900,   216,   658,   894,  3551,  1568,  3332,  1473,  3064,
     384,   166,  3371,   387,  3560,   196,   181,   907,  3010,   366,
    3012,   911,   136,   245,   134,  4319,  2680,  3019,   652,  3363,
    2874,   493,   652,  3367,   377,  3464,   656,   638,  3694,   646,
     384,  3033,  1018,   387,   843,   638,   653,  2589,  3040,  3041,
      24,   238,  2993,  2993,   111,   638,   171,   241,  1959,  3553,
     653,  3053,  3054,  3055,  1040,  4003,  3465,  3059,  3060,  1625,
     653,   654,   638,    13,   201,  3064,    17,    18,  1979,  1732,
    2496,   312,  2498,  2499,  2498,  2499,  2653,   653,  1064,   287,
    2890,   638,  3127,   992,  2028,   994,  2959,  2960,  3127,  1075,
    3195,  4335,   375,  3095,    17,    18,   653,   654,   660,   234,
    2837,  4396,  2546,  4398,  4348,   119,   129,  2382,   122,   384,
     537,   638,   387,  2028,   464,   638,  2970,   632,  2209,  2063,
     147,   245,   198,  2567,  2019,   129,   653,   654,   652,   243,
    4374,   654,   384,  2422,  2261,   387,   370,  2032,   252,   347,
    2035,  2036,   375,  1129,  1130,  1131,  1132,  1133,  2063,   292,
     660,   194,   426,   638,  1629,   217,  3358,  1620,  2338,  3715,
    4132,    26,  3718,    34,  1064,   478,    17,    18,   653,   654,
     362,   363,   366,   293,   224,  1252,  3127,  3127,  2507,  1620,
      17,    18,  4462,   352,    17,    18,   384,  1173,   660,   387,
     174,   234,  3748,  3749,  3750,   622,   146,   199,   638,   384,
    3756,  1187,   387,    13,  4146,  4147,   375,   184,  3764,  3713,
    3714,   654,  1289,   653,   654,   533,  3720,  2952,    83,  3723,
    3724,   453,  2344,  2345,   162,    17,    18,  2121,   129,  1129,
     330,  2675,   654,  1133,    17,    18,  3740,  2441,  2682,  2165,
    2165,   399,   476,   378,   556,  1828,    17,    18,  3250,  3706,
    3754,   426,   484,  1239,   638,   419,  3760,  3761,  3762,  3763,
    1337,   386,   654,    17,    18,   622,  1252,   290,   129,  2337,
     654,   365,   384,   129,  1937,   387,   390,  1843,  1833,  2347,
     417,   634,   134,   359,   638,   509,   290,    17,    18,   447,
     191,  2418,   312,   159,    17,    18,   234,   115,   365,  1845,
     654,   375,   493,  1289,   170,  2086,    17,    18,  1294,   452,
     660,    17,    18,  4617,    60,   342,  1393,   182,   484,   220,
    2524,    17,    18,  1309,    20,   533,  2853,     0,   493,   453,
     191,   605,    17,    18,  1900,   191,   146,    54,  2546,   384,
      17,    18,   387,   537,   384,   375,   369,   387,    65,  2524,
    1336,  1337,    17,    18,  3018,   173,  1911,    26,  1924,  1925,
     484,   679,  1854,   638,   220,   369,   460,  3031,   600,  1355,
     222,   654,    17,    18,    17,    18,   241,  1363,   653,   654,
     654,   252,  1368,   201,  1370,   162,   638,  1373,   552,   290,
    2171,   368,   196,  3542,  4366,  4367,   398,  4246,   492,  1385,
    1983,   653,  4189,  2184,   275,   425,   652,  1393,    17,    18,
      17,    18,   222,   577,   660,   477,  1402,  1403,  1327,   556,
     652,   654,   129,   484,   653,   654,    17,    18,   622,   290,
     605,  3697,  3009,   384,   290,   181,   387,   504,   607,   185,
     638,   293,  1428,  1429,  3802,   209,  1432,   375,    17,    18,
     196,  3003,  3004,   638,  1440,   320,   654,  1443,  3035,  3036,
     560,   384,    17,    18,   387,  1374,  1452,  2675,   369,   654,
     375,    17,    18,  1373,  2682,  1938,   600,  1463,  1464,   484,
    4452,   285,   502,   533,   191,   628,   652,   587,  1474,  1475,
    1476,  1477,  1478,  1479,  1571,   360,   654,  1938,  1484,   501,
    1409,   366,  4782,  1403,  1490,  1491,   198,  1493,   369,  4198,
     629,  1497,   562,   369,  2940,   453,    42,   383,   282,  4089,
    4090,  1474,  1475,  1476,   129,  1478,   638,   552,   652,    17,
      18,   556,  1518,   384,    90,   654,   387,   412,  1491,  2672,
      17,    18,   654,  1620,  1497,  4482,    13,   384,   374,  2993,
     387,   384,   566,   234,   387,   569,   112,   243,    17,    18,
    1469,    20,   585,   606,   166,   282,   252,   189,   439,  2844,
    2845,  2846,   241,  2484,  4094,  2180,   402,  1477,   603,  1479,
     654,   585,   328,   290,   276,  1571,   191,  1496,  2890,  4531,
    4532,   652,   384,   638,  3818,   387,    17,    18,   638,   417,
    1586,   384,    41,   580,   387,  1591,  1592,    13,   562,   654,
    4059,   137,   293,   384,   654,   220,   387,  1603,  1518,   596,
     647,   648,   649,   650,   654,   230,   484,   232,    13,  2720,
     384,  3986,     9,   387,  1620,    17,    18,   217,   629,  1625,
    2820,  1627,  1628,   265,  1630,  1631,   484,   652,  2890,    17,
      18,   320,  4010,   166,   384,    32,  1642,   387,  1644,  2968,
     484,   384,   369,   654,   387,    17,    18,  3816,  1577,   212,
      81,  2875,   537,   384,  1627,  1628,   387,  4132,   384,   146,
     426,   387,   262,  3127,   585,   290,  1586,   638,   384,    17,
      18,   387,  1592,    17,    18,   561,   133,   129,   652,   384,
    2875,   500,   387,   654,   390,    17,    18,   384,   518,   519,
     387,   521,   210,   523,  3245,   638,   173,   136,  3249,   384,
     658,   198,   387,  4058,   585,   489,   654,  2638,   538,   585,
      86,   654,    88,   660,    17,    18,   562,  2870,   556,   384,
     146,   384,   387,   365,   387,   426,  1732,  1733,  4467,   654,
    3877,  4470,   653,  3977,    17,    18,  3980,   622,  2341,   191,
     578,   146,    17,    18,   369,  2546,   276,   149,    18,  1846,
    3297,   233,    17,    18,  3901,   384,   132,   384,   387,  3781,
     387,    17,    18,   212,   195,    17,    18,   638,   220,   556,
     562,  4146,  4147,   384,   652,  2233,   387,   653,   154,   598,
    2238,   638,   620,   654,   484,   638,  3387,  1793,    17,    18,
    3391,  3392,   559,  2251,   652,   384,  2382,   654,   387,   317,
     318,   654,    17,    18,   322,   323,   245,   238,   652,   384,
     630,   631,   387,  3385,   190,  3039,   252,   173,   384,    17,
      18,   387,   641,    83,   583,  3847,   638,  2285,  2453,  1835,
    1836,   262,    17,    18,   654,   638,   272,  1843,   290,  1845,
    1846,  1938,   654,  3598,  3039,   201,   652,   638,   607,    17,
      18,   654,  1858,   484,   660,   385,    83,  1863,   585,  1956,
     652,   492,  1868,   654,   638,  1871,  2452,    17,    18,   230,
      97,   232,  1878,  1879,  2675,  1881,   384,    17,    18,   387,
     654,  2682,   646,  4622,    26,    17,    18,   384,   638,   653,
     387,  4366,  4367,  3465,  1900,   638,  2354,  1903,  2490,  3127,
     277,  1907,    40,   280,   654,   384,   212,   638,   387,   238,
      48,   654,   638,    17,    18,   238,  1836,   369,  1924,  1925,
    1926,  1927,   638,   654,   238,  1854,   529,   653,  4303,  4304,
    3351,  1937,  1938,   638,    17,    18,   565,  1943,  1944,  1945,
     552,   638,   233,   384,   556,   141,   387,   653,   551,   654,
    1956,   379,   652,   638,    49,   607,   656,   654,  1878,  1879,
     585,  1881,    17,    18,    17,    18,  2887,  1973,   399,   654,
     230,  2935,   232,   638,  4456,   638,  4458,  4452,    17,    18,
     611,   612,   384,  1903,   415,   387,   129,  1907,  1994,   654,
     249,   654,   198,  1922,    17,    18,   384,   612,   484,   387,
    2935,   261,   654,   492,    17,    18,  1926,  1927,   660,   638,
     607,   638,   384,   115,   453,   387,   293,   393,  4040,  4041,
    4042,   652,   164,  1943,  1944,  1945,   653,   638,  2034,  3171,
    3359,  2946,   503,    17,    18,  2966,   384,   264,  4413,   387,
     384,   503,   653,   387,  2050,   484,    17,    18,   191,   638,
     427,  2057,   384,  4428,   653,   387,   653,   654,  3200,  3201,
    1989,   437,   658,   638,   653,   653,   654,   526,  4443,   660,
      61,    62,   638,   532,    17,    18,  3677,   220,   653,  3221,
     601,   384,    73,   184,   387,  2182,  3239,   653,    18,   381,
     549,  2188,    81,  3683,  3684,   554,   653,   654,  3322,   241,
     556,   384,  4304,   430,   387,    17,    18,    60,   524,   384,
      83,   652,   387,   340,  2034,  2121,    17,    18,   573,   384,
     195,   223,   387,   582,   451,   611,   612,  2224,   384,     6,
     638,   387,   384,   585,   453,   387,    12,  2057,   365,  2236,
     652,   638,  2071,   652,  4519,   653,  3370,   290,   652,    17,
      18,  2080,  2081,    17,    18,   384,  4531,  4532,   387,   638,
     487,   600,  2091,  2092,  2093,  2094,   652,  2096,  2097,   384,
     653,   654,   387,   654,  2180,  3370,  2182,   652,   320,   714,
     715,   562,  2188,   652,  2190,   652,   384,  2193,   652,   387,
     660,    17,    18,    17,    18,  2201,    33,   638,  2204,   384,
     178,   428,   387,   537,    17,    18,   195,  2890,   652,    17,
      18,   607,   653,   652,    17,    18,   384,   147,  2224,   387,
    2193,    17,    18,   652,   366,  4600,   369,   652,   181,   607,
    2236,   129,   185,  2330,   384,  4610,   638,   387,    17,    18,
      17,    18,   652,   196,   384,   653,   654,   387,    85,   238,
     638,  2826,   384,   788,  3407,   387,    17,    18,  2844,  2845,
    2846,   362,   363,  2360,   416,   653,   638,   368,   241,  2894,
    2895,  2896,   652,   262,   653,   654,   654,     6,  1010,  4654,
     384,  4656,   660,   387,  1016,  1017,  2872,  4217,   652,   391,
     638,  4666,   164,   191,   638,   653,   654,   524,   653,   654,
     402,   384,   653,   654,   387,   653,   638,   409,   472,   653,
     242,   653,   654,   848,  4689,   652,  4691,  4519,  4693,   652,
     147,   653,   220,   160,  2330,  4700,  3127,   259,   652,   384,
      59,   384,   387,   382,   387,   638,  4711,  1356,   552,   271,
    1359,   652,  3484,  1362,   652,   384,   375,   160,   387,  2355,
     653,  4726,  4727,   652,  2360,   638,   652,  2815,   653,   654,
    3806,   384,  3806,   638,   387,   653,   654,  4742,  4743,   241,
     653,   384,  4747,   638,   387,   328,  2382,   375,   653,   652,
      20,   652,   638,   652,  3315,   652,   638,   360,   653,   652,
    3354,   652,   290,   366,   652,   537,    51,   653,   653,   654,
     384,   653,  3626,   387,   653,   654,   508,   653,   654,   638,
     652,  2417,   342,   384,   653,   654,   387,   652,  3529,  3354,
      13,   150,    18,   638,   653,  3017,   415,  4449,   652,   615,
     616,  3626,   618,   652,   620,  2441,  2533,  2534,   653,  2445,
     638,   384,   585,   652,   387,   652,  2452,  2453,   653,   654,
    4545,   652,  4654,   638,  4656,   653,   653,   654,   652,  4544,
    2466,   652,  2468,   436,   652,   105,    61,    62,   653,   652,
     638,   369,   384,   426,   652,   387,   653,   654,  3702,   580,
     622,  3553,   652,   384,  2490,   653,   387,  4689,   638,   652,
    2496,  4246,  2498,  2499,   366,   596,   653,   654,   638,  4071,
    4072,   603,  2997,   653,   653,   654,   638,  3702,   653,   654,
    3005,  1046,   654,   653,   573,   342,   384,  3011,  2524,   387,
     384,   653,   162,   387,  4726,  4727,   166,  2533,  2534,  3023,
     652,  3025,  3026,   652,   638,   472,   468,  2466,   652,  3570,
     652,  4225,  4226,  3037,   652,  4229,  4230,  4231,  4232,   653,
     234,   147,   652,   146,   194,   638,   196,   654,   384,   652,
     384,   387,   652,   387,   537,   495,   496,   653,   654,   653,
     653,   384,   212,   129,   387,   412,   384,   510,   218,   387,
     652,   384,   652,   638,   387,   638,   653,   654,   384,  3911,
     652,   387,    36,  4216,   234,   127,   652,   434,   653,   638,
     653,   105,   242,    12,   652,   384,   538,   384,   387,   249,
     387,   652,  2618,   287,   653,   638,   553,   590,    62,   259,
     754,   652,   559,   653,   654,   638,   652,  2633,   652,   222,
     653,   271,    22,   470,   363,   191,   276,  3959,   653,   654,
     653,  2647,   776,   652,  4328,   285,    36,   652,  3720,   622,
     652,  3723,  3724,   565,   638,   789,   790,   653,   654,    83,
      50,   653,   654,    51,   220,   537,   603,   638,  3740,   653,
     652,    61,    62,   653,   654,   119,   653,   654,   122,   654,
    4364,  4365,   653,   620,   653,   654,   130,   585,   652,  4373,
     653,   654,   529,   653,   654,   638,   228,  2703,  2704,   382,
     429,   654,   431,  3328,   148,   652,   115,  2713,  2714,  2715,
     653,   652,   352,   643,   644,   645,   646,   647,   648,   649,
     650,   652,  2651,  2652,   133,  2654,   638,  2656,  2657,  2658,
    2659,  2660,  2661,  2662,   290,   375,  2665,   638,   242,  2668,
     164,    20,  2671,    65,   652,   385,   342,   653,   654,   652,
     622,  3209,   653,   653,   654,   259,   652,   105,  3350,    81,
     653,   654,   147,   652,   173,   652,   296,   271,   298,   299,
     638,    93,   653,   654,   638,   375,  4706,   417,    13,   653,
     654,   652,   654,  2703,   314,   653,   652,    83,   565,   653,
     653,   654,   201,  2713,  2714,  2715,   653,   654,   653,   654,
     332,    97,   652,  3261,   336,   652,   250,   653,   654,    44,
     652,   343,   638,   369,   638,   653,   654,   241,   645,   646,
     647,   648,   649,   650,   198,   638,   105,   653,   468,   653,
     638,  2837,   375,  2839,   478,   638,   594,  2843,  2844,  2845,
    2846,  1879,   638,  1881,   140,   653,  2852,   647,   352,   492,
     653,   660,   492,  4783,   660,   166,   167,   653,   503,   638,
     172,   638,   652,    98,    34,  2871,  2872,   196,   103,  2875,
     276,  3804,  3805,   195,   653,   653,   654,   286,   200,   533,
     298,   299,   552,   162,  2890,   510,  3061,   166,  2894,  2895,
    2896,   202,   424,   287,   242,   533,   314,   163,   538,   495,
     496,  2907,  4049,   214,   196,  1943,  1944,  1945,   653,   654,
     354,   259,   442,   443,  3089,    92,   238,   196,   654,  3413,
     653,   654,   105,   271,  4077,   518,   519,   520,   521,   522,
     523,  3028,  2852,   212,  2940,  3510,   360,   653,   654,   218,
     262,   654,   366,   376,   255,   538,   548,  3539,   653,   654,
     482,   653,    20,   162,   594,   118,   267,   342,   132,    27,
     516,   653,   654,   242,   468,   659,   606,   607,   264,     6,
     249,   652,  4194,  4195,  3907,   156,   157,   147,  2907,   117,
     259,   653,   654,   294,  3848,  3849,     4,   627,   483,   629,
    2996,  4215,   271,  1224,  1225,   252,  3008,   276,  3334,  3335,
    3006,  3007,  3014,   620,   352,    73,   285,  3013,   417,  3290,
    3291,    58,   436,   653,   654,    83,   399,   657,   658,   254,
    4215,   654,  3028,  3029,   442,   443,  3038,   375,  3034,   585,
    3607,  3608,  3044,  3039,   538,   445,   178,   118,  3050,  3051,
     231,  3972,   654,  3049,   340,   356,   654,   643,   644,   645,
     646,   647,   648,   649,   650,  3061,   500,   660,    73,   242,
      13,   626,  3068,  3069,   132,  4218,   362,   363,  3074,   365,
     653,   653,   146,   352,  3080,    10,   259,   399,  3084,  4110,
     654,   490,   252,  3089,   660,  4116,  3015,  3016,   271,   105,
     653,   653,   624,   415,   329,   653,   375,   652,   375,   660,
      17,    18,   275,   660,   654,   275,   385,  3080,   640,   164,
     495,   496,   654,   537,  3043,   524,   287,  4339,   659,  3125,
     468,  4343,  1143,  1144,  1145,   569,  4279,   287,   287,  3049,
     287,    51,   428,   287,  3140,   287,   204,   654,   417,  1160,
     654,  3147,   166,   129,   553,  3074,   132,   552,  4081,  4082,
     652,  4084,  4085,   657,   598,   282,   229,   654,   393,   400,
    3166,    62,   230,   654,   232,   573,   590,   654,   399,   352,
     573,  1192,   342,   654,  1195,   166,   196,   654,   654,    73,
     654,   533,   252,   647,   253,   550,   186,   196,    65,   468,
     538,   513,   362,   363,   262,  1216,  1217,   654,   622,  1220,
     172,   533,   592,  3132,    81,   191,   123,   124,   125,   126,
     127,   620,   507,   492,   404,  4368,    93,   142,   119,  1240,
    1241,   122,  3397,   613,   614,   375,   242,  3147,   524,   130,
     654,   654,  3935,  3936,   220,   403,   653,  4461,   654,   601,
    3337,     7,   633,   259,   201,  3948,   606,   148,   198,  3255,
     654,   653,  3955,   166,   653,   271,  3431,  3263,   653,   538,
     645,   646,   647,   648,   649,   650,  4461,  3442,  4189,   439,
    3445,   129,   653,   595,   132,   653,   189,   512,  3981,  3982,
     647,  4503,  4504,    27,   653,   468,   198,   653,   646,   202,
     653,   192,   653,  3885,   362,   363,  3871,  3303,   115,   654,
     368,   214,   652,   654,   290,   654,   653,   375,   225,   226,
     227,   228,   653,  3410,   549,   594,  3322,  3323,   195,   653,
    3326,   594,  3328,   200,   493,   495,   496,   653,   607,    73,
     653,  3337,   653,   191,  3263,    83,   352,  3343,   653,    83,
     653,   511,   652,    91,  3350,  3351,    38,   415,   627,   250,
     629,   652,   265,   650,   267,   538,   173,   562,   652,   375,
     562,   238,   220,   654,  3370,   562,  4397,   573,   627,  3381,
     118,   240,  3989,   654,   653,   654,   652,   544,   657,   658,
      12,   294,  3388,   369,   201,   262,    13,   652,   132,   210,
     198,  3397,   129,   654,  3400,   132,   660,   652,   652,   273,
     660,   654,   654,  4334,  3410,   198,   653,   176,  3414,   660,
    3416,  3417,   660,  4560,   473,   332,   164,   334,   335,   336,
     488,   238,   425,  4354,  3430,  3431,   343,  3356,   654,   492,
     122,   654,   290,   599,   654,   196,  3442,   129,    49,  3445,
     350,   524,   524,   483,   524,  3542,   359,   524,   524,   448,
     351,   196,   468,   354,   191,   166,   652,  4053,   166,   115,
     166,   166,   166,  3469,   166,   166,  3472,   384,   166,   286,
     387,  3477,   166,   643,   644,   645,   646,   647,   648,   649,
     650,   166,  3411,   220,   166,   166,   230,   166,   232,   166,
     238,  3420,   184,  3499,   166,   166,   166,   166,   166,   191,
     166,   414,   166,   654,   286,   652,   607,   424,   375,   375,
      57,   369,   375,   653,  3520,   660,   160,   653,   262,   248,
      67,   248,   538,  4670,    14,   660,   654,   595,   220,   221,
     653,   432,  4756,   653,   653,    82,  3542,   653,   415,   653,
    4571,  4572,   653,  4574,   200,  4769,  3643,    94,    95,    96,
    4774,   653,  3472,   290,   166,  4779,   654,    27,     7,    29,
    3489,  4756,   573,   660,   481,   482,   113,   129,   660,   573,
     132,   319,   573,   562,  4769,   654,   634,    89,   129,  4774,
     652,   132,   238,   282,  4779,    49,   652,  3516,   166,   337,
     652,    61,    62,   573,    64,   412,   652,   166,   290,   585,
     417,   382,  4633,    73,  4635,  4636,   198,   198,   198,   249,
     198,   562,   360,    83,   104,  3621,   562,   256,   362,   363,
    3626,    91,   654,   430,   368,   259,   176,   369,  1649,   191,
     286,   375,   369,   259,   388,   118,   513,  3643,  4234,   118,
     191,    81,   333,   399,   399,   573,   136,   399,   118,   142,
     260,   553,   469,   260,  4319,   553,   399,   142,   220,   399,
     150,   353,   132,    49,   399,   135,   399,   401,   569,   220,
     573,   415,   364,   490,   399,   399,   368,   369,   147,   652,
     212,   652,   652,   173,  3690,   381,   562,   177,  3694,   464,
     652,  4722,   399,   660,   164,   147,  3702,   598,   188,   647,
    3706,   250,  3708,  4738,   250,   652,   660,   624,  4283,   652,
     654,   653,   653,  1734,   653,   653,   652,  1738,   595,  3816,
     210,   638,   639,   640,   654,   629,   653,   585,   290,   653,
     653,   653,   147,    38,   382,   234,   553,   652,   647,   290,
     375,  1762,   559,   654,   488,   653,  4321,   277,   238,   399,
     198,   600,   252,   660,   654,   245,   653,   653,   653,   166,
     230,   578,   232,   430,   654,   259,   654,  3773,   238,   660,
    3776,   259,   413,     6,   375,   262,   246,   375,   262,    12,
      83,    14,    20,    16,   331,   653,   603,   652,  3794,   537,
    3887,   261,   654,   375,    27,   285,    29,  3803,  3804,  3805,
    3806,   348,   375,   620,   654,   553,   653,   369,   653,   385,
    3816,   652,    49,   469,   653,   510,   653,   122,   369,   629,
     653,   486,   273,   466,   129,   430,    59,   210,   153,   653,
     269,    64,    65,   653,   490,   654,   212,   252,    71,   484,
     494,   259,   259,   654,   629,   654,  4777,    36,   585,   319,
      83,   595,   652,   262,  3783,   654,   262,   513,    91,   653,
    3957,   652,    87,   149,   502,   237,   653,   337,   101,   653,
     562,  4463,    20,   342,   566,   147,   479,   569,   654,   184,
      69,  3887,   510,   653,   652,   118,   191,   652,   580,   652,
     342,  3897,   276,   585,   653,   653,   588,   553,    36,   132,
     556,  3907,   135,   559,   653,    36,  3912,   653,  3920,   369,
     143,   144,  3918,    62,   250,   220,   221,   150,   339,   264,
    3926,   653,   392,   653,   394,   158,   654,   342,   418,   162,
     653,   164,   402,   480,    57,   653,   425,   653,   285,   595,
     382,   629,   175,   249,    67,   654,   660,   603,   438,   652,
     139,  3957,  4617,   645,   646,    49,   446,   218,   339,    82,
     653,   194,  4059,   132,   454,   654,   652,   132,   652,   556,
     607,    94,    95,    96,   607,   164,   652,  3983,   411,   168,
     252,   654,   660,    36,   369,   290,   339,   180,    18,   262,
     113,   653,   653,   540,   484,  4001,  4002,   230,  3918,   232,
     652,   654,   562,   236,   474,   238,   562,   497,   498,   562,
     607,   558,   556,   246,   203,   611,    36,   653,   607,   316,
      15,   652,   652,   585,   617,   600,   495,   496,   261,  3958,
     652,  4627,   652,   652,   585,   224,   123,   124,   125,   126,
     127,   132,  4048,   495,   496,  4051,   617,   262,   353,    69,
     239,    20,   285,  4059,   262,  4630,   368,   547,   652,   629,
     530,   531,   532,   368,   369,   528,  4731,   537,   464,   652,
     342,   176,   473,   463,   653,  4081,  4082,   654,  4084,  4085,
     495,   496,  4002,   553,   143,   653,   319,   557,   578,   382,
     600,   652,   249,  4758,   652,   375,   543,   652,   287,   364,
     652,   612,   626,   161,   337,    33,   576,   661,   341,   369,
     600,   653,   602,   196,   653,   176,    63,   142,   564,   139,
     142,   652,   164,   312,   594,   417,  4132,    75,  4048,   196,
     652,   626,   198,  4708,    33,    65,   382,  4143,   225,   226,
     227,   228,  4148,    65,   164,   653,   396,   380,   168,   654,
     653,   652,   385,   544,   278,   438,   653,   653,   160,   392,
     249,   394,   382,   382,   140,   149,   399,   658,    49,   402,
     652,  4177,  4178,   542,   643,   644,   645,   646,   647,   648,
     649,   650,    49,   203,   654,  4191,   159,    49,    49,    49,
     652,   652,   644,   645,   646,   647,   648,   649,   650,     5,
     433,   375,   375,  4132,   224,  4780,   626,   160,   331,  4215,
     233,   292,   131,   658,   447,   448,   449,   450,   661,   239,
     155,   285,    12,   495,   496,   348,   652,   416,   643,   644,
     645,   646,   647,   648,   649,   650,   425,    49,    49,    49,
    4413,   474,  4248,   600,  4250,   332,   136,   334,   335,   336,
      55,   440,   475,   658,   654,  4428,   343,   562,   653,   473,
     653,   566,   262,  4269,   569,   160,   565,   287,   231,   458,
    4443,   215,  4369,    55,   654,   580,   654,   654,   653,   658,
     585,   452,   653,   588,   196,   196,   196,    49,   565,   628,
    4296,   132,   312,   234,   369,   197,   652,   530,   531,   532,
     492,  4153,   654,  2367,   537,  2670,  3781,   994,  2562,  3503,
     677,  3792,  4183,   502,  4322,  4539,   505,  1055,  4540,  3790,
     553,  3794,  4000,  4758,   557,   694,  4719,    48,  1868,   600,
     699,  1936,  2837,  3986,  3986,  3986,  4728,   424,  3986,   462,
     645,   646,  3986,   576,   533,  3986,  3986,  3986,   581,  4597,
    3986,  3986,  4406,  4359,  4597,  4532,  3986,   480,  3986,  3986,
    4431,   594,  4432,  4369,  1580,  1837,   555,   736,  1099,  4375,
    4187,   643,   644,   645,   646,   647,   648,   649,   650,  2632,
    4009,  3440,  2114,  3620,   753,  4482,  2866,  2871,  3303,  4359,
    4049,  4465,  1390,  3623,   481,   482,   416,  4670,  4327,  4568,
    4627,   537,  1617,  3799,  4234,   425,  3068,  2625,  3133,  3520,
    2633,  3071,  3912,  3919,  4645,   604,  4283,   540,  3731,  3192,
     440,  4108,  3765,  3968,  4463,   658,   235,  4600,   797,   798,
     799,   800,  4438,  4362,  4363,   558,  3957,  4610,   458,  2533,
     809,  2793,  3246,  3241,  3249,    11,  4452,  4386,    11,  4504,
    4503,  2197,  4330,  4339,  2711,  4461,  4343,  4191,  3388,  4116,
    2632,  2121,  3064,  1022,  1068,  2510,  3924,  1534,  2436,  4566,
    4438,  1926,  1613,  3689,  1592,  2410,  4482,  2852,  2457,  2323,
    3298,  3988,   502,  1950,   621,   505,   295,   943,   297,   298,
     299,   300,   301,  4666,   303,   304,   305,   306,   307,   308,
     309,   310,   311,  3263,   313,   314,   315,  2232,  4281,  2228,
    2826,  2525,  1187,   533,  3361,  2519,  4253,  2322,  4691,  4074,
    4693,  4582,  3499,  4452,  4583,  2348,  3702,  4700,   897,  1551,
    3898,  1160,   552,  2940,  3060,   555,   556,   624,  4711,  3887,
    4708,  2462,  2201,  1373,  4473,  4474,  1403,  1039,  2404,  2440,
    3626,  3316,   639,   640,  3317,  3370,  4461,   611,  1039,  1039,
    4566,  1039,   690,  2029,  1642,   599,  1482,  2030,  2504,  4742,
    4743,   599,  1857,  3708,  4747,  1410,  4582,  4583,  3301,  4489,
    4668,  4578,  4703,  4774,   604,  4779,  3322,  3959,  1440,  3350,
    2487,   598,  1790,  3351,   598,  2480,  4602,  1976,  2473,  2479,
    1907,   835,  1430,  4609,   592,   923,  4038,  2452,  1365,  2839,
    4044,  1625,   593,   930,   677,   533,   533,   677,    -1,    -1,
     677,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   442,   443,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4765,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4690,    -1,    -1,    -1,    -1,  4695,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1081,  4642,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4731,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4756,    -1,  4758,    -1,    -1,    -1,    -1,    -1,    -1,  4765,
      -1,    -1,    -1,  4769,    -1,    -1,    -1,    -1,  4774,    -1,
    1139,  1140,    -1,  4779,    -1,    -1,    -1,    -1,    -1,  1148,
    1149,  1150,  1151,  1152,  1153,  1154,  1155,  1156,  1157,  1158,
    1159,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1168,
    1169,    -1,  1171,  1172,    -1,    -1,    -1,  1176,    -1,    -1,
    1179,  1180,  1181,  1182,    -1,  1184,  1185,  1186,    -1,    -1,
      -1,    -1,    -1,    -1,  1193,  1194,    -1,  1196,  1197,  1198,
    1199,  1200,    -1,    -1,  1203,  1204,  1205,  1206,  1207,  1208,
    1209,  1210,  1211,  1212,  1213,    -1,  1215,    -1,    -1,  1218,
    1219,    -1,    -1,    -1,  1223,    -1,    -1,    -1,  1227,  1228,
    1229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1242,  1243,  1244,    -1,    -1,    -1,    -1,
      -1,    -1,  1251,    -1,    -1,    -1,    -1,    -1,    -1,  1258,
    1259,  1260,    -1,  1262,    -1,    -1,    -1,    -1,    -1,    -1,
    1269,  1270,  1271,    -1,  1273,  1274,  1275,  1276,  1277,    -1,
    1279,  1280,  1281,  1282,  1283,  1284,  1285,  1286,    -1,    -1,
      -1,  1290,  1291,    -1,    -1,    -1,    14,    -1,    16,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    33,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    51,    52,    27,    -1,    29,    -1,    -1,
      -1,    59,    -1,    -1,    -1,    -1,    64,    65,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,    -1,    61,
      62,    -1,    64,    -1,    -1,    -1,    -1,    -1,  1377,    -1,
      -1,    73,    -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,
      -1,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    91,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     128,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   136,   137,
     138,    -1,    -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,
      -1,   149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     132,  1440,    -1,   135,   162,    -1,    -1,    -1,    -1,    -1,
      -1,  1450,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   177,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1466,    -1,    -1,
      -1,  1470,   164,    -1,    -1,   193,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     208,    -1,   210,    -1,    -1,    -1,    -1,   215,    -1,    -1,
      -1,   219,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1525,   245,    -1,   247,
      -1,    -1,    -1,    35,    36,    -1,    -1,    -1,   230,    41,
     232,    43,    -1,    45,    46,   263,   238,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   246,    -1,    -1,    -1,    -1,    -1,
      62,    -1,    -1,   281,    -1,    -1,    -1,   285,    -1,   261,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   275,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,    -1,
     122,    -1,    -1,    -1,    -1,    -1,    -1,   319,   130,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   337,   148,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1655,    -1,    -1,    -1,
      -1,    -1,   380,   165,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   397,
      -1,   399,    -1,    -1,    -1,    -1,    -1,    -1,   190,    -1,
     192,    -1,    -1,    -1,   412,    -1,    -1,    -1,    -1,    -1,
     392,    -1,   394,   205,   206,   423,    -1,    -1,    -1,    -1,
     402,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   445,    -1,    -1,
     448,    -1,   450,    -1,    -1,   453,    -1,    -1,   456,   457,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   250,   467,
      -1,    -1,   470,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     478,    -1,    -1,    -1,    -1,    -1,   484,    -1,    -1,  1768,
    1769,  1770,    -1,    -1,   492,    -1,    -1,   279,    -1,   497,
     498,   499,   474,    -1,  1783,    -1,   288,   289,    -1,   291,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1809,   529,    -1,    -1,    -1,    -1,  1815,    -1,   536,  1818,
      -1,  1820,    -1,   325,   326,   327,    -1,  1826,    -1,  1828,
    1829,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   530,   531,
     532,    -1,   344,   345,   346,   537,    -1,    -1,    -1,   351,
      -1,    -1,   354,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   553,    -1,   581,    -1,   557,    -1,    -1,    -1,   371,
     372,    -1,    -1,    -1,    -1,   593,    -1,    -1,    -1,   597,
      -1,    -1,   600,    -1,   576,    -1,    -1,    -1,   606,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   594,    -1,    -1,   407,   408,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   636,   699,
      -1,    -1,  1921,    -1,   642,    -1,    -1,    -1,    -1,    -1,
     432,    -1,    -1,    -1,   652,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    27,    -1,    29,    -1,    -1,   736,    -1,    -1,    -1,
     652,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   753,    -1,  1974,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1983,    -1,   488,    -1,    64,    27,
     492,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   506,    -1,    -1,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    91,    -1,    -1,    -1,    -1,
     800,    -1,    -1,    61,    62,    -1,    64,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    73,    -1,    -1,    -1,    -1,
      -1,    -1,   118,    -1,    -1,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    91,    -1,    -1,   132,    -1,    -1,   135,
      -1,   563,    -1,    -1,   566,    -1,    -1,   569,   570,   571,
     572,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   164,    -1,
      -1,    -1,    -1,    -1,   132,    -1,    -1,   135,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   613,   614,    -1,    -1,  2114,    -1,   897,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   164,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2136,   640,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   230,    -1,   232,    -1,    -1,    -1,
      -1,    -1,   238,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     246,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   261,    -1,    -1,    -1,    -1,
      -1,    -1,   230,    -1,   232,    -1,    -1,  2196,    -1,    -1,
     238,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   246,    -1,
      -1,  2210,    -1,    -1,    -1,  2214,    -1,    -1,    -1,    -1,
    2219,  2220,    -1,   261,    -1,    -1,    -1,    -1,    -1,  2228,
      -1,  2230,    -1,  2232,  2233,  2234,  2235,    -1,    -1,  2238,
      -1,    -1,    -1,   319,    -1,    -1,    -1,    -1,    -1,  2248,
      -1,  2250,  2251,    -1,  2253,  2254,  2255,  2256,    -1,  2258,
      -1,   337,  2261,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2270,    -1,    -1,    -1,    -1,    -1,    -1,  2277,    -1,
    2279,   319,  2281,  2282,    -1,  2284,  2285,    -1,    -1,    -1,
    2289,  2290,  2291,    -1,    -1,    -1,  2295,  2296,  2297,   337,
    2299,  1081,  2301,    -1,  2303,    -1,  2305,    -1,  2307,    -1,
      -1,    -1,    -1,  2312,    -1,    -1,   392,    -1,   394,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   402,    -1,    -1,    -1,
      -1,    -1,  2331,    -1,    -1,    -1,    -1,    -1,    -1,  2338,
      -1,    -1,  2341,    -1,    -1,    -1,    -1,    -1,  2347,    -1,
      -1,  2350,    -1,    -1,   392,  2354,   394,    -1,    -1,  1139,
    1140,    -1,    -1,    -1,   402,    -1,    -1,    -1,  1148,  1149,
      -1,    -1,  1152,  1153,  1154,  1155,  1156,  1157,  1158,  1159,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1168,  1169,
      -1,  1171,  1172,    -1,    -1,    -1,    -1,    -1,   474,  1179,
    1180,  1181,  1182,    -1,    -1,  1185,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1193,  1194,    -1,  1196,  1197,    -1,  2418,
      -1,    -1,    -1,  1203,  1204,  1205,    -1,    -1,  1208,  1209,
    1210,  1211,  1212,  1213,    -1,  1215,   474,    -1,  1218,  1219,
      -1,    -1,    -1,  1223,    -1,    -1,    -1,  1227,  1228,  1229,
      -1,    -1,    -1,    -1,   530,   531,   532,    -1,    -1,    -1,
      -1,   537,  1242,  1243,  1244,    -1,    -1,    -1,    -1,    -1,
      -1,  1251,    14,    -1,    16,    -1,    -1,   553,  1258,  1259,
    1260,   557,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2488,
      -1,    -1,   530,   531,   532,    37,    -1,    -1,    -1,   537,
     576,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    51,
      52,  1291,    -1,    -1,    -1,   553,    -1,    59,   594,   557,
      -1,    -1,    64,    65,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   576,    -1,
      -1,    -1,    -1,    85,    -1,    -1,  2545,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   594,    -1,    -1,    -1,
      -1,    -1,   104,    -1,  2563,  2564,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   128,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   136,   137,   138,  1377,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,   150,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2625,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   177,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   193,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1440,    -1,    -1,    -1,    -1,    -1,   208,    -1,   210,    -1,
    1450,    -1,    -1,   215,  2673,  2674,    -1,   219,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1466,    -1,    -1,    -1,
    1470,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   245,    -1,   247,    -1,    -1,    -1,    -1,
    2709,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   263,    -1,    -1,    -1,  2724,    -1,    -1,    -1,  2728,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   281,
      -1,    -1,    -1,   285,    -1,  1525,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2755,  2756,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2775,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2784,    -1,  2786,    -1,  2788,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2815,    -1,    -1,    -1,
      -1,  2820,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   380,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2848,
      -1,    -1,    -1,    -1,    -1,   397,    13,   399,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    25,    -1,
     412,    -1,    -1,    -1,    -1,  1655,    -1,    -1,    -1,    36,
      37,   423,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   445,    61,    62,   448,    -1,   450,    -1,
      -1,   453,    69,    -1,   456,   457,    -1,    74,    -1,    -1,
      -1,    -1,    -1,  2922,    -1,   467,    -1,    -1,   470,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   478,    -1,    -1,    -1,
      -1,    -1,   484,   100,    -1,   102,    -1,   104,    -1,    -1,
     492,    -1,    -1,    -1,    -1,   497,   498,   499,    -1,   116,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2973,    -1,    -1,    -1,    -1,    -1,
     137,   138,    -1,    -1,    -1,    -1,    -1,   529,  1768,  1769,
    1770,    -1,    -1,    -1,   536,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   163,   164,    -1,    -1,
      -1,    -1,   169,    -1,    -1,   172,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1809,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1818,   581,
    1820,    -1,   199,    -1,   201,    -1,    -1,    -1,    -1,    -1,
      -1,   593,   209,    -1,   211,   597,    -1,    -1,   600,    -1,
      -1,    -1,    -1,    -1,   606,  3064,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3077,  3078,
     237,   238,   239,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   636,    -1,    -1,    -1,    -1,    -1,
     642,    -1,    -1,   260,    -1,    -1,    -1,    -1,    -1,    -1,
     652,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   282,    -1,  3126,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1921,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   312,    -1,  3156,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3174,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1974,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3206,  3207,    -1,
    3209,    -1,    -1,    -1,    -1,    -1,    -1,     6,    -1,  3218,
      -1,    -1,   379,    12,  3223,    14,    -1,  3226,    -1,  3228,
    3229,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    27,    -1,
      29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   405,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   416,
     417,    -1,  3261,   420,   421,    -1,    -1,    -1,    -1,    -1,
      59,    -1,    -1,    -1,    -1,    64,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   441,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3292,    83,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    91,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   101,    -1,    -1,    -1,    -1,  3316,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,
      -1,    -1,   489,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   132,    -1,   502,   135,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   143,    -1,  2136,    -1,    -1,    -1,
      -1,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   158,
      -1,    -1,    -1,  3372,    -1,   164,   533,    -1,    -1,    -1,
     537,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   555,   556,
      -1,    -1,    -1,    -1,    -1,   194,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2210,    -1,    -1,    -1,  2214,    -1,    -1,    -1,    -1,  2219,
    2220,   230,    -1,   232,    -1,    -1,    -1,   604,  2228,   238,
    2230,    -1,  2232,    -1,  2234,  2235,    -1,   246,   615,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   623,    -1,  2248,    -1,
    2250,    -1,   261,  2253,  2254,  2255,  2256,    -1,  2258,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    2270,    -1,    -1,    -1,    -1,    -1,   285,  2277,    -1,  2279,
      -1,  2281,  2282,    -1,  2284,    -1,    -1,    -1,    -1,  2289,
    2290,  2291,    -1,    -1,    -1,  2295,  2296,  2297,    -1,  2299,
      -1,  2301,    -1,  2303,    -1,  2305,    -1,  2307,    -1,    -1,
     319,    -1,  2312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   337,    -1,
      -1,  2331,   341,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2347,    -1,    -1,
    2350,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   385,    -1,    -1,    -1,
      -1,    -1,    -1,   392,    -1,   394,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   402,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3627,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   448,
      -1,    -1,    -1,    -1,  3663,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3671,    -1,    -1,    -1,    -1,  3676,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   474,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2488,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   530,   531,   532,    -1,    -1,    -1,    -1,   537,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3758,
      -1,    -1,    -1,    -1,   553,    -1,    -1,    -1,   557,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   576,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3799,    -1,    -1,    -1,    -1,   594,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3830,    -1,    -1,    -1,  3834,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3868,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3882,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2724,    -1,    -1,    -1,  2728,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3968,
      -1,    -1,    -1,    -1,    -1,  2755,  2756,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3986,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2775,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2784,    -1,  2786,    -1,  2788,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4049,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4057,    -1,
      -1,    -1,    -1,    -1,  4063,    -1,  4065,    -1,  2848,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4140,  2922,    -1,    -1,    -1,    -1,  4146,  4147,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4190,    -1,  2973,    -1,  4194,  4195,    -1,    -1,    -1,
      -1,    -1,  4201,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4239,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4289,    -1,  4291,    -1,    -1,    -1,    -1,  3077,  3078,    -1,
      -1,    -1,  4301,    -1,  4303,  4304,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4330,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4339,    -1,    -1,    -1,  4343,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4388,
      -1,    -1,    -1,    -1,  3174,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4411,    -1,  4413,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3206,  3207,    -1,  4428,
    4429,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3218,    -1,
      -1,    -1,    -1,  3223,  4443,    -1,  3226,    -1,  3228,  3229,
      -1,    -1,    -1,    -1,    -1,    -1,  4455,    -1,    -1,    -1,
      -1,    -1,    -1,  4462,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4501,    -1,  4503,  4504,    -1,    -1,    -1,    -1,
      -1,    -1,  3292,    -1,    -1,    -1,    -1,    -1,    -1,  4518,
    4519,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4531,  4532,    -1,    -1,  3316,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4560,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3372,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4600,    -1,    -1,    -1,    -1,    -1,    -1,  4607,    -1,
      -1,  4610,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4647,    -1,
      -1,    -1,    -1,    -1,    -1,  4654,    -1,  4656,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4666,    -1,    -1,
      -1,  4670,    -1,    -1,  4673,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4689,    -1,  4691,    -1,  4693,    -1,    -1,    -1,    -1,    -1,
      -1,  4700,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4711,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4726,  4727,    -1,
      -1,    -1,    -1,  4732,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4742,  4743,    -1,    -1,    -1,  4747,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     5,    -1,     7,
       8,     9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,
      -1,    19,    -1,  4782,    -1,    -1,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    37,
      -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,
      48,    -1,    -1,    -1,    -1,    -1,    54,    -1,    -1,    57,
      58,    -1,    60,    -1,    -1,    -1,    -1,    -1,    66,    67,
      68,    69,    -1,    71,    72,    -1,    74,    75,    -1,    -1,
      -1,    -1,    -1,    -1,    82,    -1,    84,  3627,    86,    87,
      88,    89,    -1,    91,    92,    -1,    94,    95,    96,    -1,
      98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,
     108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,
     118,   119,    -1,  3663,   122,    -1,    -1,    -1,    -1,   127,
      -1,  3671,    -1,    -1,    -1,   133,  3676,   135,    -1,    -1,
      -1,   139,    -1,   141,   142,   143,   144,   145,    -1,    -1,
      -1,    -1,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,
     158,    -1,    -1,   161,    -1,   163,   164,   165,    -1,    -1,
     168,   169,    -1,   171,   172,   173,   174,   175,    -1,    -1,
      -1,    -1,   180,   181,   182,    -1,    -1,   185,   186,    -1,
     188,   189,   190,    -1,    -1,    -1,    -1,    -1,    -1,   197,
      -1,   199,    -1,   201,    -1,   203,   204,   205,   206,   207,
      -1,   209,    -1,   211,    -1,    -1,    -1,    -1,   216,   217,
      -1,    -1,    -1,    -1,    -1,    -1,   224,    -1,    -1,    -1,
     228,   229,   230,   231,   232,    -1,    -1,   235,   236,   237,
      -1,   239,    -1,   241,    -1,    -1,    -1,    -1,   246,    -1,
      -1,    -1,    -1,   251,    -1,   253,   254,    -1,   256,   257,
      -1,    -1,    -1,   261,    -1,    -1,    -1,   265,   266,    -1,
      -1,   269,    -1,    -1,   272,   273,    -1,    -1,    -1,    -1,
      -1,   279,   280,    -1,   282,    -1,   284,    -1,   286,   287,
    3830,    -1,    -1,    -1,  3834,    -1,    -1,   295,   296,   297,
     298,   299,   300,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,    -1,   312,   313,   314,   315,    -1,   317,
     318,   319,   320,    -1,   322,   323,    -1,    -1,  3868,    -1,
     328,   329,   330,   331,   332,   333,    -1,    -1,   336,   337,
      -1,   339,  3882,   341,    -1,   343,   344,   345,   346,   347,
     348,   349,   350,   351,    -1,    -1,   354,   355,    -1,    -1,
     358,   359,   360,   361,    -1,    -1,    -1,    -1,   366,    -1,
      -1,    -1,   370,    -1,   372,   373,   374,    -1,   376,   377,
     378,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   392,   393,    -1,    -1,    -1,    -1,
     398,    -1,   400,   401,   402,   403,   404,   405,   406,   407,
     408,    -1,    -1,    -1,    -1,   413,   414,    -1,   416,    -1,
     418,   419,   420,   421,   422,    -1,   424,   425,   426,    -1,
      -1,   429,    -1,    -1,    -1,   433,   434,   435,   436,   437,
      -1,    -1,   440,   441,   442,   443,   444,    -1,   446,    -1,
      -1,   449,    -1,   451,    -1,    -1,   454,    -1,    -1,    -1,
     458,    -1,    -1,   461,   462,    -1,   464,    -1,   466,    -1,
      -1,   469,    -1,   471,   472,   473,   474,   475,   476,   477,
      -1,   479,   480,    -1,   482,    -1,    -1,    -1,    -1,   487,
     488,   489,    -1,    -1,    -1,    -1,   494,    -1,    -1,    -1,
      -1,    -1,    -1,   501,    -1,    -1,   504,   505,    -1,   507,
      -1,   509,    -1,   511,   512,    -1,    -1,  4057,    -1,    -1,
      -1,   519,   520,  4063,   522,  4065,    -1,   525,    -1,    -1,
     528,    -1,    -1,    -1,    -1,   533,    -1,    -1,    -1,   537,
      -1,   539,   540,   541,   542,   543,   544,    -1,    -1,   547,
     548,   549,   550,    -1,   552,   553,    -1,   555,    -1,   557,
     558,   559,   560,    -1,    -1,   563,   564,    -1,   566,   567,
     568,   569,    -1,    -1,    -1,    -1,    -1,   575,   576,   577,
      -1,    -1,    -1,    -1,   582,   583,   584,    -1,   586,   587,
      -1,   589,   590,    -1,    -1,    -1,    -1,    -1,   596,    -1,
    4140,   599,    -1,    -1,    -1,   603,   604,   605,    -1,    -1,
      -1,    -1,    -1,    -1,   612,    -1,    -1,   615,    -1,    -1,
      -1,   619,   620,   621,   622,   623,   624,   625,    -1,    -1,
      -1,    -1,    -1,    -1,   632,    -1,    -1,   635,    -1,   637,
      -1,    -1,   640,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4201,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4239,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4289,
      -1,  4291,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4301,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4429,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4462,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4518,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4607,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4647,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,  4673,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    47,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,  4732,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,  4782,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,    -1,   188,   189,   190,
     191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,
     201,    -1,   203,   204,   205,   206,   207,   208,   209,    -1,
     211,    -1,   213,    -1,   215,   216,   217,    -1,   219,   220,
     221,    -1,   223,   224,    -1,    -1,    -1,   228,   229,   230,
     231,   232,   233,    -1,   235,   236,   237,    -1,   239,    -1,
     241,    -1,    -1,    -1,   245,   246,   247,   248,    -1,    -1,
     251,    -1,   253,   254,    -1,   256,   257,    -1,    -1,    -1,
     261,    -1,    -1,   264,   265,   266,    -1,   268,   269,    -1,
     271,   272,   273,    -1,    -1,    -1,    -1,    -1,   279,   280,
      -1,   282,    -1,   284,    -1,   286,   287,    -1,    -1,   290,
      -1,    -1,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,    -1,    -1,   328,   329,   330,
     331,   332,   333,    -1,    -1,   336,   337,   338,   339,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,    -1,   368,   369,   370,
      -1,   372,   373,   374,    -1,   376,   377,   378,   379,    -1,
     381,   382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,   392,   393,    -1,   395,   396,    -1,   398,    -1,   400,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,   416,    -1,   418,   419,   420,
     421,   422,    -1,   424,   425,   426,    -1,    -1,   429,    -1,
      -1,    -1,   433,   434,   435,   436,   437,    -1,    -1,   440,
     441,   442,   443,   444,    -1,   446,   447,    -1,   449,   450,
     451,   452,   453,   454,    -1,   456,    -1,   458,   459,    -1,
     461,   462,    -1,   464,    -1,   466,    -1,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
      -1,   482,   483,    -1,    -1,    -1,   487,   488,   489,   490,
      -1,    -1,    -1,   494,    -1,    -1,    -1,   498,    -1,   500,
     501,   502,   503,   504,   505,    -1,   507,   508,   509,   510,
     511,   512,    -1,    -1,    -1,    -1,    -1,    -1,   519,   520,
      -1,   522,    -1,    -1,   525,    -1,    -1,   528,   529,    -1,
      -1,    -1,   533,   534,   535,   536,   537,    -1,   539,   540,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,    -1,   555,    -1,   557,   558,   559,   560,
      -1,   562,   563,   564,    -1,   566,   567,   568,   569,    -1,
      -1,    -1,    -1,   574,   575,   576,   577,    -1,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
      -1,   592,   593,    -1,    -1,   596,    -1,    -1,   599,    -1,
     601,    -1,   603,   604,   605,    -1,    -1,   608,   609,   610,
     611,   612,    -1,    -1,   615,   616,    -1,   618,   619,   620,
     621,   622,   623,   624,   625,    -1,    -1,    -1,    -1,    -1,
      -1,   632,   633,    -1,   635,   636,   637,    -1,    -1,   640,
      -1,    -1,    -1,    -1,   645,   646,    -1,    -1,    -1,    -1,
     651,   652,    -1,    -1,   655,   656,    -1,    -1,   659,   660,
       5,    -1,     7,     8,     9,    10,    11,    12,    13,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,    -1,   188,   189,   190,   191,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,
     205,   206,   207,   208,   209,    -1,   211,    -1,   213,    -1,
     215,   216,   217,    -1,   219,   220,   221,    -1,   223,   224,
      -1,    -1,    -1,   228,   229,   230,   231,   232,   233,    -1,
     235,   236,   237,    -1,   239,    -1,   241,    -1,    -1,    -1,
     245,   246,   247,   248,    -1,    -1,   251,    -1,   253,   254,
      -1,   256,   257,    -1,    -1,    -1,   261,    -1,    -1,   264,
     265,   266,    -1,    -1,   269,    -1,   271,   272,   273,    -1,
      -1,    -1,    -1,    -1,   279,   280,    -1,   282,    -1,   284,
      -1,   286,   287,    -1,    -1,   290,    -1,    -1,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,    -1,    -1,   328,   329,   330,   331,   332,   333,    -1,
      -1,   336,   337,   338,   339,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,    -1,   368,   369,   370,    -1,   372,   373,   374,
     375,   376,   377,   378,   379,    -1,   381,   382,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,   392,   393,    -1,
     395,   396,    -1,   398,    -1,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,    -1,   412,   413,   414,
      -1,   416,    -1,   418,   419,   420,   421,   422,    -1,   424,
     425,   426,    -1,    -1,   429,    -1,    -1,    -1,   433,   434,
     435,   436,   437,    -1,    -1,   440,   441,   442,   443,   444,
      -1,   446,   447,    -1,   449,   450,   451,   452,   453,   454,
      -1,   456,    -1,   458,   459,    -1,   461,   462,    -1,   464,
      -1,   466,    -1,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,    -1,   482,   483,    -1,
      -1,    -1,   487,   488,   489,   490,    -1,    -1,    -1,   494,
      -1,    -1,    -1,   498,    -1,   500,   501,   502,   503,   504,
     505,    -1,   507,   508,   509,   510,   511,   512,    -1,    -1,
      -1,    -1,    -1,    -1,   519,   520,    -1,   522,    -1,    -1,
     525,    -1,    -1,   528,   529,    -1,    -1,    -1,   533,   534,
     535,   536,   537,    -1,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,    -1,
     555,    -1,   557,   558,   559,   560,    -1,   562,   563,   564,
      -1,   566,   567,   568,   569,    -1,    -1,    -1,    -1,    -1,
     575,   576,   577,    -1,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,    -1,   592,   593,    -1,
      -1,   596,    -1,    -1,   599,    -1,   601,    -1,   603,   604,
     605,    -1,    -1,   608,   609,   610,   611,   612,    -1,    -1,
     615,   616,    -1,   618,   619,   620,   621,   622,   623,   624,
     625,    -1,    -1,    -1,    -1,    -1,    -1,   632,   633,    -1,
     635,   636,   637,    -1,    -1,   640,    -1,    -1,    -1,    -1,
     645,   646,    -1,    -1,    -1,    -1,   651,   652,    -1,    -1,
     655,   656,    -1,    -1,   659,   660,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,    -1,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,   198,
     199,    -1,   201,    -1,   203,   204,   205,   206,   207,   208,
     209,    -1,   211,    -1,   213,    -1,   215,   216,   217,    -1,
     219,   220,   221,    -1,   223,   224,    -1,    -1,    -1,   228,
     229,   230,   231,   232,   233,    -1,   235,   236,   237,    -1,
     239,    -1,   241,    -1,    -1,    -1,   245,   246,   247,   248,
      -1,    -1,   251,    -1,   253,   254,    -1,   256,   257,    -1,
      -1,    -1,   261,    -1,    -1,   264,   265,   266,    -1,    -1,
     269,    -1,   271,   272,   273,    -1,    -1,    -1,    -1,    -1,
     279,   280,    -1,   282,    -1,   284,    -1,   286,   287,    -1,
      -1,   290,    -1,    -1,    -1,    -1,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,    -1,    -1,   328,
     329,   330,   331,   332,   333,    -1,    -1,   336,   337,   338,
     339,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,   363,   364,   365,   366,    -1,   368,
     369,   370,    -1,   372,   373,   374,    -1,   376,   377,   378,
     379,    -1,   381,   382,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   391,   392,   393,    -1,   395,   396,    -1,   398,
      -1,   400,   401,   402,   403,   404,   405,   406,   407,   408,
     409,   410,    -1,   412,   413,   414,    -1,   416,    -1,   418,
     419,   420,   421,   422,    -1,   424,   425,   426,    -1,    -1,
     429,    -1,    -1,    -1,   433,   434,   435,   436,   437,    -1,
      -1,   440,   441,   442,   443,   444,    -1,   446,   447,    -1,
     449,   450,   451,   452,   453,   454,    -1,   456,    -1,   458,
     459,    -1,   461,   462,    -1,   464,    -1,   466,    -1,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,    -1,   482,   483,    -1,    -1,    -1,   487,   488,
     489,   490,    -1,    -1,    -1,   494,    -1,    -1,    -1,   498,
      -1,   500,   501,   502,   503,   504,   505,    -1,   507,   508,
     509,   510,   511,   512,    -1,    -1,    -1,    -1,    -1,    -1,
     519,   520,    -1,   522,    -1,    -1,   525,    -1,    -1,   528,
     529,    -1,    -1,    -1,   533,   534,   535,   536,   537,    -1,
     539,   540,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,    -1,   555,    -1,   557,   558,
     559,   560,    -1,   562,   563,   564,    -1,   566,   567,   568,
     569,    -1,    -1,    -1,    -1,    -1,   575,   576,   577,    -1,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,    -1,   592,   593,    -1,    -1,   596,    -1,    -1,
     599,    -1,   601,    -1,   603,   604,   605,    -1,    -1,   608,
     609,   610,   611,   612,    -1,    -1,   615,   616,    -1,   618,
     619,   620,   621,   622,   623,   624,   625,    -1,    -1,    -1,
      -1,    -1,    -1,   632,   633,    -1,   635,   636,   637,    -1,
      -1,   640,    -1,    -1,    -1,    -1,   645,   646,    -1,    -1,
      -1,    -1,   651,   652,    -1,    -1,   655,   656,    -1,    -1,
     659,   660,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,    -1,   188,   189,   190,   191,    -1,
     193,    -1,    -1,    -1,   197,   198,   199,    -1,   201,    -1,
     203,   204,   205,   206,   207,   208,   209,    -1,   211,    -1,
     213,    -1,   215,   216,   217,    -1,   219,   220,   221,    -1,
     223,   224,    -1,    -1,    -1,   228,   229,   230,   231,   232,
     233,    -1,   235,   236,   237,    -1,   239,    -1,   241,    -1,
      -1,    -1,   245,   246,   247,   248,    -1,    -1,   251,    -1,
     253,   254,    -1,   256,   257,    -1,    -1,    -1,   261,    -1,
      -1,   264,   265,   266,    -1,    -1,   269,    -1,   271,   272,
     273,    -1,    -1,    -1,    -1,    -1,   279,   280,    -1,   282,
      -1,   284,    -1,   286,   287,    -1,    -1,   290,    -1,    -1,
      -1,    -1,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,    -1,    -1,   328,   329,   330,   331,   332,
     333,    -1,    -1,   336,   337,   338,   339,    -1,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,    -1,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,    -1,   368,   369,   370,    -1,   372,
     373,   374,    -1,   376,   377,   378,   379,    -1,   381,   382,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   391,   392,
     393,    -1,   395,   396,    -1,   398,    -1,   400,   401,   402,
     403,   404,   405,   406,   407,   408,   409,   410,    -1,   412,
     413,   414,    -1,   416,    -1,   418,   419,   420,   421,   422,
      -1,   424,   425,   426,    -1,    -1,   429,    -1,    -1,    -1,
     433,   434,   435,   436,   437,    -1,    -1,   440,   441,   442,
     443,   444,    -1,   446,   447,    -1,   449,   450,   451,   452,
     453,   454,    -1,   456,    -1,   458,   459,    -1,   461,   462,
      -1,   464,    -1,   466,    -1,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,    -1,   482,
     483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,    -1,
      -1,   494,    -1,    -1,    -1,   498,    -1,   500,   501,   502,
     503,   504,   505,    -1,   507,   508,   509,   510,   511,   512,
      -1,    -1,    -1,    -1,    -1,    -1,   519,   520,    -1,   522,
      -1,    -1,   525,    -1,    -1,   528,   529,    -1,    -1,    -1,
     533,   534,   535,   536,   537,    -1,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,    -1,   555,    -1,   557,   558,   559,   560,    -1,   562,
     563,   564,    -1,   566,   567,   568,   569,    -1,    -1,    -1,
      -1,    -1,   575,   576,   577,    -1,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,    -1,   592,
     593,    -1,    -1,   596,    -1,    -1,   599,    -1,   601,    -1,
     603,   604,   605,    -1,    -1,   608,   609,   610,   611,   612,
      -1,    -1,   615,   616,    -1,   618,   619,   620,   621,   622,
     623,   624,   625,    -1,    -1,    -1,    -1,    -1,    -1,   632,
     633,    -1,   635,   636,   637,    -1,    -1,   640,    -1,    -1,
      -1,    -1,   645,   646,    -1,    -1,    -1,    -1,   651,   652,
      -1,    -1,   655,   656,    -1,    -1,   659,   660,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,    -1,   106,
     107,   108,   109,   110,   111,    -1,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,   178,    -1,   180,   181,   182,   183,   184,   185,   186,
      -1,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,   198,   199,    -1,   201,    -1,   203,   204,   205,   206,
     207,   208,   209,    -1,   211,    -1,   213,    -1,   215,   216,
     217,    -1,   219,   220,   221,    -1,   223,   224,    -1,    -1,
      -1,   228,   229,   230,   231,   232,   233,    -1,   235,   236,
     237,    -1,   239,    -1,   241,    -1,    -1,    -1,   245,   246,
     247,   248,    -1,    -1,   251,    -1,   253,   254,    -1,   256,
     257,    -1,    -1,    -1,   261,    -1,    -1,   264,   265,   266,
      -1,    -1,   269,    -1,   271,   272,   273,    -1,    -1,    -1,
      -1,    -1,   279,   280,    -1,   282,    -1,   284,    -1,   286,
     287,    -1,    -1,   290,    -1,    -1,    -1,    -1,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,    -1,
      -1,   328,   329,   330,   331,   332,   333,    -1,    -1,   336,
     337,   338,   339,    -1,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,    -1,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
      -1,   368,   369,   370,    -1,   372,   373,   374,    -1,   376,
     377,   378,   379,    -1,   381,   382,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   391,   392,   393,    -1,   395,   396,
      -1,   398,    -1,   400,   401,   402,   403,   404,   405,   406,
     407,   408,   409,   410,    -1,   412,   413,   414,    -1,   416,
      -1,   418,   419,   420,   421,   422,    -1,   424,   425,   426,
      -1,    -1,   429,    -1,    -1,    -1,   433,   434,   435,   436,
     437,    -1,    -1,   440,   441,   442,   443,   444,    -1,   446,
     447,    -1,   449,   450,   451,   452,   453,   454,    -1,   456,
      -1,   458,   459,    -1,   461,   462,    -1,   464,    -1,   466,
      -1,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,    -1,   482,   483,    -1,    -1,    -1,
     487,   488,   489,   490,    -1,    -1,    -1,   494,    -1,    -1,
      -1,   498,    -1,   500,   501,   502,   503,   504,   505,    -1,
     507,   508,   509,   510,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,   519,   520,    -1,   522,    -1,    -1,   525,    -1,
      -1,   528,   529,    -1,    -1,    -1,   533,   534,   535,   536,
     537,    -1,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,    -1,   555,    -1,
     557,   558,   559,   560,    -1,   562,   563,   564,    -1,   566,
     567,   568,   569,    -1,    -1,    -1,    -1,    -1,   575,   576,
     577,    -1,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   590,    -1,   592,   593,    -1,    -1,   596,
      -1,    -1,   599,    -1,   601,    -1,   603,   604,   605,    -1,
      -1,   608,   609,   610,   611,   612,    -1,    -1,   615,   616,
      -1,   618,   619,   620,   621,   622,   623,   624,   625,    -1,
      -1,    -1,    -1,    -1,    -1,   632,   633,    -1,   635,   636,
     637,    -1,    -1,   640,    -1,    -1,    -1,    -1,   645,   646,
      -1,    -1,    -1,    -1,   651,   652,    -1,    -1,   655,   656,
      -1,    -1,   659,   660,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,    -1,   188,   189,   190,
     191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,
     201,    -1,   203,   204,   205,   206,   207,   208,   209,    -1,
     211,    -1,   213,    -1,   215,   216,   217,    -1,   219,   220,
     221,    -1,   223,   224,    -1,    -1,    -1,   228,   229,   230,
     231,   232,   233,    -1,   235,   236,   237,    -1,   239,    -1,
     241,    -1,    -1,    -1,   245,   246,   247,   248,    -1,    -1,
     251,    -1,   253,   254,    -1,   256,   257,    -1,    -1,    -1,
     261,    -1,    -1,   264,   265,   266,    -1,    -1,   269,    -1,
     271,   272,   273,    -1,    -1,    -1,    -1,    -1,   279,   280,
      -1,   282,    -1,   284,    -1,   286,   287,    -1,    -1,   290,
      -1,    -1,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,    -1,    -1,   328,   329,   330,
     331,   332,   333,    -1,    -1,   336,   337,   338,   339,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,    -1,   368,   369,   370,
      -1,   372,   373,   374,    -1,   376,   377,   378,   379,    -1,
     381,   382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,   392,   393,    -1,   395,   396,    -1,   398,    -1,   400,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,   416,    -1,   418,   419,   420,
     421,   422,    -1,   424,   425,   426,    -1,    -1,   429,    -1,
      -1,    -1,   433,   434,   435,   436,   437,    -1,    -1,   440,
     441,   442,   443,   444,    -1,   446,   447,    -1,   449,   450,
     451,   452,   453,   454,    -1,   456,    -1,   458,   459,    -1,
     461,   462,    -1,   464,    -1,   466,    -1,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
      -1,   482,   483,    -1,    -1,    -1,   487,   488,   489,   490,
      -1,    -1,    -1,   494,    -1,    -1,    -1,   498,    -1,   500,
     501,   502,   503,   504,   505,    -1,   507,   508,   509,   510,
     511,   512,    -1,    -1,    -1,    -1,    -1,    -1,   519,   520,
      -1,   522,    -1,    -1,   525,    -1,    -1,   528,   529,    -1,
      -1,    -1,   533,   534,   535,   536,   537,    -1,   539,   540,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,    -1,   555,    -1,   557,   558,   559,   560,
      -1,   562,   563,   564,    -1,   566,   567,   568,   569,    -1,
      -1,    -1,    -1,    -1,   575,   576,   577,    -1,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
      -1,   592,   593,    -1,    -1,   596,    -1,    -1,   599,    -1,
     601,    -1,   603,   604,   605,    -1,    -1,   608,   609,   610,
     611,   612,    -1,    -1,   615,   616,    -1,   618,   619,   620,
     621,   622,   623,   624,   625,    -1,    -1,    -1,    -1,    -1,
      -1,   632,   633,    -1,   635,   636,   637,    -1,    -1,   640,
      -1,    -1,    -1,    -1,   645,   646,    -1,    -1,    -1,    -1,
     651,   652,    -1,    -1,   655,   656,    -1,    -1,   659,   660,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,    -1,   188,   189,   190,   191,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,
     205,   206,   207,   208,   209,    -1,   211,    -1,   213,    -1,
     215,   216,   217,    -1,   219,   220,   221,    -1,   223,   224,
      -1,    -1,    -1,   228,   229,   230,   231,   232,   233,    -1,
     235,   236,   237,    -1,   239,    -1,   241,    -1,    -1,    -1,
     245,   246,   247,   248,    -1,    -1,   251,    -1,   253,   254,
      -1,   256,   257,    -1,    -1,    -1,   261,    -1,    -1,   264,
     265,   266,    -1,    -1,   269,    -1,   271,   272,   273,    -1,
      -1,    -1,    -1,    -1,   279,   280,    -1,   282,    -1,   284,
      -1,   286,   287,    -1,    -1,   290,    -1,    -1,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,    -1,    -1,   328,   329,   330,   331,   332,   333,    -1,
      -1,   336,   337,   338,   339,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,    -1,   368,   369,   370,    -1,   372,   373,   374,
      -1,   376,   377,   378,   379,    -1,   381,   382,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,   392,   393,    -1,
     395,   396,    -1,   398,    -1,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,    -1,   412,   413,   414,
      -1,   416,    -1,   418,   419,   420,   421,   422,    -1,   424,
     425,   426,    -1,    -1,   429,    -1,    -1,    -1,   433,   434,
     435,   436,   437,    -1,    -1,   440,   441,   442,   443,   444,
      -1,   446,   447,    -1,   449,   450,   451,   452,   453,   454,
      -1,   456,    -1,   458,   459,    -1,   461,   462,    -1,   464,
      -1,   466,    -1,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,    -1,   482,   483,    -1,
      -1,    -1,   487,   488,   489,   490,    -1,    -1,    -1,   494,
      -1,    -1,    -1,   498,    -1,   500,   501,   502,   503,   504,
     505,    -1,   507,   508,   509,   510,   511,   512,    -1,    -1,
      -1,    -1,    -1,    -1,   519,   520,    -1,   522,    -1,    -1,
     525,    -1,    -1,   528,   529,    -1,    -1,    -1,   533,   534,
     535,   536,   537,    -1,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,    -1,
     555,    -1,   557,   558,   559,   560,    -1,   562,   563,   564,
      -1,   566,   567,   568,   569,    -1,    -1,    -1,    -1,    -1,
     575,   576,   577,    -1,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,    -1,   592,   593,    -1,
      -1,   596,    -1,    -1,   599,    -1,   601,    -1,   603,   604,
     605,    -1,    -1,   608,   609,   610,   611,   612,    -1,    -1,
     615,   616,    -1,   618,   619,   620,   621,   622,   623,   624,
     625,    -1,    -1,    -1,    -1,    -1,    -1,   632,   633,    -1,
     635,   636,   637,    -1,    -1,   640,    -1,    -1,    -1,    -1,
     645,   646,    -1,    -1,    -1,    -1,   651,   652,    -1,    -1,
     655,   656,    -1,    -1,   659,   660,     5,    -1,     7,     8,
       9,    10,    11,    12,    13,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,    -1,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,
     199,    -1,   201,    -1,   203,   204,   205,   206,   207,   208,
     209,    -1,   211,    -1,   213,    -1,   215,   216,   217,    -1,
     219,   220,   221,    -1,   223,   224,    -1,    -1,    -1,   228,
     229,   230,   231,   232,   233,    -1,   235,   236,   237,    -1,
     239,    -1,   241,    -1,    -1,    -1,   245,   246,   247,   248,
      -1,    -1,   251,    -1,   253,   254,    -1,   256,   257,    -1,
      -1,    -1,   261,    -1,    -1,   264,   265,   266,    -1,    -1,
     269,    -1,   271,   272,   273,    -1,    -1,    -1,    -1,    -1,
     279,   280,    -1,   282,    -1,   284,    -1,   286,   287,    -1,
      -1,   290,    -1,    -1,    -1,    -1,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,    -1,    -1,    -1,    -1,   328,
     329,   330,   331,   332,   333,    -1,    -1,   336,   337,   338,
     339,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,   364,   365,   366,    -1,   368,
     369,   370,    -1,   372,   373,   374,    -1,   376,   377,   378,
     379,    -1,   381,   382,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   391,   392,   393,    -1,   395,   396,    -1,   398,
      -1,   400,   401,   402,   403,   404,   405,   406,   407,   408,
     409,   410,    -1,   412,   413,   414,    -1,   416,    -1,   418,
     419,   420,   421,   422,    -1,   424,   425,   426,    -1,    -1,
     429,    -1,    -1,    -1,   433,   434,   435,   436,   437,    -1,
      -1,   440,   441,   442,   443,   444,    -1,   446,   447,    -1,
     449,   450,   451,   452,   453,   454,    -1,   456,    -1,   458,
     459,    -1,   461,   462,    -1,   464,    -1,   466,    -1,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,    -1,   482,   483,    -1,    -1,    -1,   487,   488,
     489,   490,    -1,    -1,    -1,   494,    -1,    -1,    -1,   498,
      -1,   500,   501,   502,   503,   504,   505,    -1,   507,   508,
     509,   510,   511,   512,    -1,    -1,    -1,    -1,    -1,    -1,
     519,   520,    -1,   522,    -1,    -1,   525,    -1,    -1,   528,
     529,    -1,    -1,    -1,   533,   534,   535,   536,   537,    -1,
     539,   540,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,    -1,   555,    -1,   557,   558,
     559,   560,    -1,   562,   563,   564,    -1,   566,   567,   568,
     569,    -1,    -1,    -1,    -1,    -1,   575,   576,   577,    -1,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,    -1,   592,   593,    -1,    -1,   596,    -1,    -1,
     599,    -1,   601,    -1,   603,   604,   605,    -1,    -1,   608,
     609,   610,   611,   612,    -1,    -1,   615,   616,    -1,   618,
     619,   620,   621,   622,   623,   624,   625,    -1,    -1,    -1,
      -1,    -1,    -1,   632,   633,    -1,   635,   636,   637,    -1,
      -1,   640,    -1,    -1,    -1,    -1,   645,   646,    -1,    -1,
      -1,    -1,   651,   652,    -1,    -1,   655,   656,    -1,    -1,
     659,   660,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,    -1,   188,   189,   190,   191,    -1,
     193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,    -1,
     203,   204,   205,   206,   207,   208,   209,    -1,   211,    -1,
     213,    -1,   215,   216,   217,    -1,   219,   220,   221,    -1,
     223,   224,    -1,    -1,    -1,   228,   229,   230,   231,   232,
     233,    -1,   235,   236,   237,    -1,   239,    -1,   241,    -1,
      -1,    -1,   245,   246,   247,   248,    -1,    -1,   251,    -1,
     253,   254,    -1,   256,   257,    -1,    -1,    -1,   261,    -1,
      -1,   264,   265,   266,    -1,    -1,   269,    -1,   271,   272,
     273,    -1,    -1,    -1,    -1,    -1,   279,   280,    -1,   282,
      -1,   284,    -1,   286,   287,    -1,    -1,   290,    -1,    -1,
      -1,    -1,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,    -1,    -1,   328,   329,   330,   331,   332,
     333,    -1,    -1,   336,   337,   338,   339,    -1,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,    -1,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
     363,   364,   365,   366,    -1,   368,   369,   370,    -1,   372,
     373,   374,    -1,   376,   377,   378,   379,    -1,   381,   382,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   391,   392,
     393,    -1,   395,   396,    -1,   398,    -1,   400,   401,   402,
     403,   404,   405,   406,   407,   408,   409,   410,    -1,   412,
     413,   414,    -1,   416,    -1,   418,   419,   420,   421,   422,
      -1,   424,   425,   426,    -1,    -1,   429,    -1,    -1,    -1,
     433,   434,   435,   436,   437,    -1,    -1,   440,   441,   442,
     443,   444,    -1,   446,   447,    -1,   449,   450,   451,   452,
     453,   454,    -1,   456,    -1,   458,   459,    -1,   461,   462,
      -1,   464,    -1,   466,    -1,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,    -1,   482,
     483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,    -1,
      -1,   494,    -1,    -1,    -1,   498,    -1,   500,   501,   502,
     503,   504,   505,    -1,   507,   508,   509,   510,   511,   512,
      -1,    -1,    -1,    -1,    -1,    -1,   519,   520,    -1,   522,
      -1,    -1,   525,    -1,    -1,   528,   529,    -1,    -1,    -1,
     533,   534,   535,   536,   537,    -1,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,    -1,   555,    -1,   557,   558,   559,   560,    -1,   562,
     563,   564,    -1,   566,   567,   568,   569,    -1,    -1,    -1,
      -1,    -1,   575,   576,   577,    -1,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,    -1,   592,
     593,    -1,    -1,   596,    -1,    -1,   599,    -1,   601,    -1,
     603,   604,   605,    -1,    -1,   608,   609,   610,   611,   612,
      -1,    -1,   615,   616,    -1,   618,   619,   620,   621,   622,
     623,   624,   625,    -1,    -1,    -1,    -1,    -1,    -1,   632,
     633,    -1,   635,   636,   637,    -1,    -1,   640,    -1,    -1,
      -1,    -1,   645,   646,    -1,    -1,    -1,    -1,   651,   652,
      -1,    -1,   655,   656,    -1,    -1,   659,   660,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,    -1,   106,
     107,   108,   109,   110,   111,    -1,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,   178,    -1,   180,   181,   182,   183,   184,   185,   186,
      -1,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,    -1,   199,    -1,   201,    -1,   203,   204,   205,   206,
     207,   208,   209,    -1,   211,    -1,   213,    -1,   215,   216,
     217,    -1,   219,   220,   221,    -1,   223,   224,    -1,    -1,
      -1,   228,   229,   230,   231,   232,   233,    -1,   235,   236,
     237,    -1,   239,    -1,   241,    -1,    -1,    -1,   245,   246,
     247,   248,    -1,    -1,   251,    -1,   253,   254,    -1,   256,
     257,    -1,    -1,    -1,   261,    -1,    -1,   264,   265,   266,
      -1,    -1,   269,    -1,   271,   272,   273,    -1,    -1,    -1,
      -1,    -1,   279,   280,    -1,   282,    -1,   284,    -1,   286,
     287,    -1,    -1,   290,    -1,    -1,    -1,    -1,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,    -1,
      -1,   328,   329,   330,   331,   332,   333,    -1,    -1,   336,
     337,   338,   339,    -1,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,    -1,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,   363,   364,   365,   366,
      -1,   368,   369,   370,    -1,   372,   373,   374,    -1,   376,
     377,   378,   379,    -1,   381,   382,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   391,   392,   393,    -1,   395,   396,
      -1,   398,    -1,   400,   401,   402,   403,   404,   405,   406,
     407,   408,   409,   410,    -1,   412,   413,   414,    -1,   416,
      -1,   418,   419,   420,   421,   422,    -1,   424,   425,   426,
      -1,    -1,   429,    -1,    -1,    -1,   433,   434,   435,   436,
     437,    -1,    -1,   440,   441,   442,   443,   444,    -1,   446,
     447,    -1,   449,   450,   451,   452,   453,   454,    -1,   456,
      -1,   458,   459,    -1,   461,   462,    -1,   464,    -1,   466,
      -1,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,    -1,   482,   483,    -1,    -1,    -1,
     487,   488,   489,   490,    -1,    -1,    -1,   494,    -1,    -1,
      -1,   498,    -1,   500,   501,   502,   503,   504,   505,    -1,
     507,   508,   509,   510,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,   519,   520,    -1,   522,    -1,    -1,   525,    -1,
      -1,   528,   529,    -1,    -1,    -1,   533,   534,   535,   536,
     537,    -1,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,    -1,   555,    -1,
     557,   558,   559,   560,    -1,   562,   563,   564,    -1,   566,
     567,   568,   569,    -1,    -1,    -1,    -1,    -1,   575,   576,
     577,    -1,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   590,    -1,   592,   593,    -1,    -1,   596,
      -1,    -1,   599,    -1,   601,    -1,   603,   604,   605,    -1,
      -1,   608,   609,   610,   611,   612,    -1,    -1,   615,   616,
      -1,   618,   619,   620,   621,   622,   623,   624,   625,    -1,
      -1,    -1,    -1,    -1,    -1,   632,   633,    -1,   635,   636,
     637,    -1,    -1,   640,    -1,    -1,    -1,    -1,   645,   646,
      -1,    -1,    -1,    -1,   651,   652,    -1,    -1,   655,   656,
      -1,    -1,   659,   660,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,    -1,   188,   189,   190,
     191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,
     201,    -1,   203,   204,   205,   206,   207,   208,   209,    -1,
     211,    -1,   213,    -1,   215,   216,   217,    -1,   219,   220,
     221,    -1,   223,   224,    -1,    -1,    -1,   228,   229,   230,
     231,   232,   233,    -1,   235,   236,   237,    -1,   239,    -1,
     241,    -1,    -1,    -1,   245,   246,   247,   248,    -1,    -1,
     251,    -1,   253,   254,    -1,   256,   257,    -1,    -1,    -1,
     261,    -1,    -1,   264,   265,   266,    -1,    -1,   269,    -1,
     271,   272,   273,    -1,    -1,    -1,    -1,    -1,   279,   280,
      -1,   282,    -1,   284,    -1,   286,   287,    -1,    -1,   290,
      -1,    -1,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,    -1,    -1,   328,   329,   330,
     331,   332,   333,    -1,    -1,   336,   337,   338,   339,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,   363,   364,   365,   366,    -1,   368,   369,   370,
      -1,   372,   373,   374,    -1,   376,   377,   378,   379,    -1,
     381,   382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,   392,   393,    -1,   395,   396,    -1,   398,    -1,   400,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,   416,    -1,   418,   419,   420,
     421,   422,    -1,   424,   425,   426,    -1,    -1,   429,    -1,
      -1,    -1,   433,   434,   435,   436,   437,    -1,    -1,   440,
     441,   442,   443,   444,    -1,   446,   447,    -1,   449,   450,
     451,   452,   453,   454,    -1,   456,    -1,   458,   459,    -1,
     461,   462,    -1,   464,    -1,   466,    -1,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
      -1,   482,   483,    -1,    -1,    -1,   487,   488,   489,   490,
      -1,    -1,    -1,   494,    -1,    -1,    -1,   498,    -1,   500,
     501,   502,   503,   504,   505,    -1,   507,   508,   509,   510,
     511,   512,    -1,    -1,    -1,    -1,    -1,    -1,   519,   520,
      -1,   522,    -1,    -1,   525,    -1,    -1,   528,   529,    -1,
      -1,    -1,   533,   534,   535,   536,   537,    -1,   539,   540,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,    -1,   555,    -1,   557,   558,   559,   560,
      -1,   562,   563,   564,    -1,   566,   567,   568,   569,    -1,
      -1,    -1,    -1,    -1,   575,   576,   577,    -1,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
      -1,   592,   593,    -1,    -1,   596,    -1,    -1,   599,    -1,
     601,    -1,   603,   604,   605,    -1,    -1,   608,   609,   610,
     611,   612,    -1,    -1,   615,   616,    -1,   618,   619,   620,
     621,   622,   623,   624,   625,    -1,    -1,    -1,    -1,    -1,
      -1,   632,   633,    -1,   635,   636,   637,    -1,    -1,   640,
      -1,    -1,    -1,    -1,   645,   646,    -1,    -1,    -1,    -1,
     651,   652,    -1,    -1,   655,   656,    -1,    -1,   659,   660,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,    -1,   188,   189,   190,   191,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,
     205,   206,   207,   208,   209,    -1,   211,    -1,   213,    -1,
     215,   216,   217,    -1,   219,   220,   221,    -1,   223,   224,
      -1,    -1,    -1,   228,   229,   230,   231,   232,   233,    -1,
     235,   236,   237,    -1,   239,    -1,   241,    -1,    -1,    -1,
     245,   246,   247,   248,    -1,    -1,   251,    -1,   253,   254,
      -1,   256,   257,    -1,    -1,    -1,   261,    -1,    -1,   264,
     265,   266,    -1,    -1,   269,    -1,   271,   272,   273,    -1,
      -1,    -1,    -1,    -1,   279,   280,    -1,   282,    -1,   284,
      -1,   286,   287,    -1,    -1,   290,    -1,    -1,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,    -1,
      -1,    -1,    -1,   328,   329,   330,   331,   332,   333,    -1,
      -1,   336,   337,   338,   339,    -1,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,   362,   363,   364,
     365,   366,    -1,   368,   369,   370,    -1,   372,   373,   374,
      -1,   376,   377,   378,   379,    -1,   381,   382,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,   392,   393,    -1,
     395,   396,    -1,   398,    -1,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,    -1,   412,   413,   414,
      -1,   416,    -1,   418,   419,   420,   421,   422,    -1,   424,
     425,   426,    -1,    -1,   429,    -1,    -1,    -1,   433,   434,
     435,   436,   437,    -1,    -1,   440,   441,   442,   443,   444,
      -1,   446,   447,    -1,   449,   450,   451,   452,   453,   454,
      -1,   456,    -1,   458,   459,    -1,   461,   462,    -1,   464,
      -1,   466,    -1,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,    -1,   482,   483,    -1,
      -1,    -1,   487,   488,   489,   490,    -1,    -1,    -1,   494,
      -1,    -1,    -1,   498,    -1,   500,   501,   502,   503,   504,
     505,    -1,   507,   508,   509,   510,   511,   512,    -1,    -1,
      -1,    -1,    -1,    -1,   519,   520,    -1,   522,    -1,    -1,
     525,    -1,    -1,   528,   529,    -1,    -1,    -1,   533,   534,
     535,   536,   537,    -1,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,    -1,
     555,    -1,   557,   558,   559,   560,    -1,   562,   563,   564,
      -1,   566,   567,   568,   569,    -1,    -1,    -1,    -1,    -1,
     575,   576,   577,    -1,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,    -1,   592,   593,    -1,
      -1,   596,    -1,    -1,   599,    -1,   601,    -1,   603,   604,
     605,    -1,    -1,   608,   609,   610,   611,   612,    -1,    -1,
     615,   616,    -1,   618,   619,   620,   621,   622,   623,   624,
     625,    -1,    -1,    -1,    -1,    -1,    -1,   632,   633,    -1,
     635,   636,   637,    -1,    -1,   640,    -1,    -1,    -1,    -1,
     645,   646,    -1,    -1,    -1,    -1,   651,   652,    -1,    -1,
     655,   656,    -1,    -1,   659,   660,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,    -1,   188,
     189,   190,   191,    -1,   193,    -1,    -1,    -1,   197,    -1,
     199,    -1,   201,    -1,   203,   204,   205,   206,   207,   208,
     209,    -1,   211,    -1,   213,    -1,   215,   216,   217,    -1,
     219,   220,   221,    -1,   223,   224,    -1,    -1,    -1,   228,
     229,   230,   231,   232,   233,    -1,   235,   236,   237,    -1,
     239,    -1,   241,    -1,    -1,    -1,   245,   246,   247,   248,
      -1,    -1,   251,    -1,   253,   254,    -1,   256,   257,    -1,
      -1,    -1,   261,    -1,    -1,   264,   265,   266,    -1,    -1,
     269,    -1,   271,   272,   273,    -1,    -1,    -1,    -1,    -1,
     279,   280,    -1,   282,    -1,   284,    -1,   286,   287,    -1,
      -1,   290,    -1,    -1,    -1,    -1,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,    -1,   328,
     329,   330,   331,   332,   333,    -1,    -1,   336,   337,   338,
     339,    -1,   341,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,    -1,   353,   354,   355,    -1,    -1,   358,
     359,   360,   361,   362,    -1,   364,   365,   366,    -1,   368,
     369,   370,    -1,   372,   373,   374,    -1,   376,   377,   378,
     379,    -1,   381,   382,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   391,   392,   393,    -1,   395,   396,    -1,   398,
      -1,   400,   401,   402,   403,   404,   405,   406,   407,   408,
     409,   410,    -1,   412,   413,   414,    -1,   416,    -1,   418,
     419,   420,   421,   422,    -1,   424,   425,   426,    -1,    -1,
     429,    -1,    -1,    -1,   433,   434,   435,   436,   437,    -1,
      -1,   440,   441,   442,   443,   444,    -1,   446,   447,    -1,
     449,   450,   451,   452,   453,   454,    -1,   456,    -1,   458,
     459,    -1,   461,   462,    -1,   464,    -1,   466,    -1,   468,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,    -1,   482,   483,    -1,    -1,    -1,   487,   488,
     489,   490,    -1,    -1,    -1,   494,    -1,    -1,    -1,   498,
      -1,   500,   501,   502,   503,   504,   505,    -1,   507,   508,
     509,   510,   511,   512,    -1,    -1,    -1,    -1,    -1,    -1,
     519,   520,    -1,   522,    -1,    -1,   525,    -1,    -1,   528,
     529,    -1,    -1,    -1,   533,   534,   535,   536,   537,    -1,
     539,   540,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,    -1,   555,    -1,   557,   558,
     559,   560,    -1,   562,   563,   564,    -1,   566,   567,   568,
     569,    -1,    -1,    -1,    -1,    -1,   575,   576,   577,    -1,
     579,   580,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,    -1,   592,   593,    -1,    -1,   596,    -1,    -1,
     599,    -1,   601,    -1,   603,   604,   605,    -1,    -1,   608,
     609,   610,   611,   612,    -1,    -1,   615,   616,    -1,   618,
     619,   620,   621,   622,   623,   624,   625,    -1,    -1,    -1,
      -1,    -1,    -1,   632,   633,    -1,   635,   636,   637,    -1,
      -1,   640,    -1,    -1,    -1,    -1,   645,   646,    -1,    -1,
      -1,    -1,   651,   652,    -1,    -1,   655,   656,    -1,    -1,
     659,   660,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,    -1,   188,   189,   190,   191,    -1,
     193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,    -1,
     203,   204,   205,   206,   207,   208,   209,    -1,   211,    -1,
     213,    -1,   215,   216,   217,    -1,   219,   220,   221,    -1,
     223,   224,    -1,    -1,    -1,   228,   229,   230,   231,   232,
     233,    -1,   235,   236,   237,    -1,   239,    -1,   241,    -1,
      -1,    -1,   245,   246,   247,   248,    -1,    -1,   251,    -1,
     253,   254,    -1,   256,   257,    -1,    -1,    -1,   261,    -1,
      -1,   264,   265,   266,    -1,    -1,   269,    -1,   271,   272,
     273,    -1,    -1,    -1,    -1,    -1,   279,   280,    -1,   282,
      -1,   284,    -1,   286,   287,    -1,    -1,   290,    -1,    -1,
      -1,    -1,   295,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,    -1,   312,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,    -1,    -1,    -1,    -1,   328,   329,   330,   331,   332,
     333,    -1,    -1,   336,   337,   338,   339,    -1,   341,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,    -1,
     353,   354,   355,    -1,    -1,   358,   359,   360,   361,   362,
      -1,   364,   365,   366,    -1,   368,   369,   370,    -1,   372,
     373,   374,    -1,   376,   377,   378,   379,    -1,   381,   382,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   391,   392,
     393,    -1,   395,   396,    -1,   398,    -1,   400,   401,   402,
     403,   404,   405,   406,   407,   408,   409,   410,    -1,   412,
     413,   414,    -1,   416,    -1,   418,   419,   420,   421,   422,
      -1,   424,   425,   426,    -1,    -1,   429,    -1,    -1,    -1,
     433,   434,   435,   436,   437,    -1,    -1,   440,   441,   442,
     443,   444,    -1,   446,   447,    -1,   449,   450,   451,   452,
     453,   454,    -1,   456,    -1,   458,   459,    -1,   461,   462,
      -1,   464,    -1,   466,    -1,   468,   469,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,    -1,   482,
     483,    -1,    -1,    -1,   487,   488,   489,   490,    -1,    -1,
      -1,   494,    -1,    -1,    -1,   498,    -1,   500,   501,   502,
     503,   504,   505,    -1,   507,   508,   509,   510,   511,   512,
      -1,    -1,    -1,    -1,    -1,    -1,   519,   520,    -1,   522,
      -1,    -1,   525,    -1,    -1,   528,   529,    -1,    -1,    -1,
     533,   534,   535,   536,   537,    -1,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,    -1,   555,    -1,   557,   558,   559,   560,    -1,   562,
     563,   564,    -1,   566,   567,   568,   569,    -1,    -1,    -1,
      -1,    -1,   575,   576,   577,    -1,   579,   580,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,    -1,   592,
     593,    -1,    -1,   596,    -1,    -1,   599,    -1,   601,    -1,
     603,   604,   605,    -1,    -1,   608,   609,   610,   611,   612,
      -1,    -1,   615,   616,    -1,   618,   619,   620,   621,   622,
     623,   624,   625,    -1,    -1,    -1,    -1,    -1,    -1,   632,
     633,    -1,   635,   636,   637,    -1,    -1,   640,    -1,    -1,
      -1,    -1,   645,   646,    -1,    -1,    -1,    -1,   651,   652,
      -1,    -1,   655,   656,    -1,    -1,   659,   660,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,    -1,   106,
     107,   108,   109,   110,   111,    -1,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,   178,    -1,   180,   181,   182,   183,   184,   185,   186,
      -1,   188,   189,   190,   191,    -1,   193,    -1,    -1,    -1,
     197,    -1,   199,    -1,   201,    -1,   203,   204,   205,   206,
     207,   208,   209,    -1,   211,    -1,   213,    -1,   215,   216,
     217,    -1,   219,   220,   221,    -1,   223,   224,    -1,    -1,
      -1,   228,   229,   230,   231,   232,   233,    -1,   235,   236,
     237,    -1,   239,    -1,   241,    -1,    -1,    -1,   245,   246,
     247,   248,    -1,    -1,   251,    -1,   253,   254,    -1,   256,
     257,    -1,    -1,    -1,   261,    -1,    -1,   264,   265,   266,
      -1,    -1,   269,    -1,   271,   272,   273,    -1,    -1,    -1,
      -1,    -1,   279,   280,    -1,   282,    -1,   284,    -1,   286,
     287,    -1,    -1,   290,    -1,    -1,    -1,    -1,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,    -1,    -1,    -1,
      -1,   328,   329,   330,   331,   332,   333,    -1,    -1,   336,
     337,   338,   339,    -1,   341,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,    -1,   353,   354,   355,    -1,
      -1,   358,   359,   360,   361,   362,    -1,   364,   365,   366,
      -1,   368,   369,   370,    -1,   372,   373,   374,    -1,   376,
     377,   378,   379,    -1,   381,   382,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   391,   392,   393,    -1,   395,   396,
      -1,   398,    -1,   400,   401,   402,   403,   404,   405,   406,
     407,   408,   409,   410,    -1,   412,   413,   414,    -1,   416,
      -1,   418,   419,   420,   421,   422,    -1,   424,   425,   426,
      -1,    -1,   429,    -1,    -1,    -1,   433,   434,   435,   436,
     437,    -1,    -1,   440,   441,   442,   443,   444,    -1,   446,
     447,    -1,   449,   450,   451,   452,   453,   454,    -1,   456,
      -1,   458,   459,    -1,   461,   462,    -1,   464,    -1,   466,
      -1,   468,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,    -1,   482,   483,    -1,    -1,    -1,
     487,   488,   489,   490,    -1,    -1,    -1,   494,    -1,    -1,
      -1,   498,    -1,   500,   501,   502,   503,   504,   505,    -1,
     507,   508,   509,   510,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,   519,   520,    -1,   522,    -1,    -1,   525,    -1,
      -1,   528,   529,    -1,    -1,    -1,   533,   534,   535,   536,
     537,    -1,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,    -1,   555,    -1,
     557,   558,   559,   560,    -1,   562,   563,   564,    -1,   566,
     567,   568,   569,    -1,    -1,    -1,    -1,    -1,   575,   576,
     577,    -1,   579,   580,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   590,    -1,   592,   593,    -1,    -1,   596,
      -1,    -1,   599,    -1,   601,    -1,   603,   604,   605,    -1,
      -1,   608,   609,   610,   611,   612,    -1,    -1,   615,   616,
      -1,   618,   619,   620,   621,   622,   623,   624,   625,    -1,
      -1,    -1,    -1,    -1,    -1,   632,   633,    -1,   635,   636,
     637,    -1,    -1,   640,    -1,    -1,    -1,    -1,   645,   646,
      -1,    -1,    -1,    -1,   651,   652,    -1,    -1,   655,   656,
      -1,    -1,   659,   660,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,    -1,   188,   189,   190,
     191,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,
     201,    -1,   203,   204,   205,   206,   207,   208,   209,    -1,
     211,    -1,   213,    -1,   215,   216,   217,    -1,   219,   220,
     221,    -1,   223,   224,    -1,    -1,    -1,   228,   229,   230,
     231,   232,   233,    -1,   235,   236,   237,    -1,   239,    -1,
     241,    -1,    -1,    -1,   245,   246,   247,   248,    -1,    -1,
     251,    -1,   253,   254,    -1,   256,   257,    -1,    -1,    -1,
     261,    -1,    -1,   264,   265,   266,    -1,    -1,   269,    -1,
     271,   272,   273,    -1,    -1,    -1,    -1,    -1,   279,   280,
      -1,   282,    -1,   284,    -1,   286,   287,    -1,    -1,   290,
      -1,    -1,    -1,    -1,   295,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
      -1,   312,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,    -1,    -1,    -1,    -1,   328,   329,   330,
     331,   332,   333,    -1,    -1,   336,   337,   338,   339,    -1,
     341,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,    -1,   353,   354,   355,    -1,    -1,   358,   359,   360,
     361,   362,    -1,   364,   365,   366,    -1,   368,   369,   370,
      -1,   372,   373,   374,    -1,   376,   377,   378,   379,    -1,
     381,   382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     391,   392,   393,    -1,   395,   396,    -1,   398,    -1,   400,
     401,   402,   403,   404,   405,   406,   407,   408,   409,   410,
      -1,   412,   413,   414,    -1,   416,    -1,   418,   419,   420,
     421,   422,    -1,   424,   425,   426,    -1,    -1,   429,    -1,
      -1,    -1,   433,   434,   435,   436,   437,    -1,    -1,   440,
     441,   442,   443,   444,    -1,   446,   447,    -1,   449,   450,
     451,   452,   453,   454,    -1,   456,    -1,   458,   459,    -1,
     461,   462,    -1,   464,    -1,   466,    -1,   468,   469,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
      -1,   482,   483,    -1,    -1,    -1,   487,   488,   489,   490,
      -1,    -1,    -1,   494,    -1,    -1,    -1,   498,    -1,   500,
     501,   502,   503,   504,   505,    -1,   507,   508,   509,   510,
     511,   512,    -1,    -1,    -1,    -1,    -1,    -1,   519,   520,
      -1,   522,    -1,    -1,   525,    -1,    -1,   528,   529,    -1,
      -1,    -1,   533,   534,   535,   536,   537,    -1,   539,   540,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,    -1,   555,    -1,   557,   558,   559,   560,
      -1,   562,   563,   564,    -1,   566,   567,   568,   569,    -1,
      -1,    -1,    -1,    -1,   575,   576,   577,    -1,   579,   580,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
      -1,   592,   593,    -1,    -1,   596,    -1,    -1,   599,    -1,
     601,    -1,   603,   604,   605,    -1,    -1,   608,   609,   610,
     611,   612,    -1,    -1,   615,   616,    -1,   618,   619,   620,
     621,   622,   623,   624,   625,    -1,    -1,    -1,    -1,    -1,
      -1,   632,   633,    -1,   635,   636,   637,    -1,    -1,   640,
      -1,    -1,    -1,    -1,   645,   646,    -1,    -1,    -1,    -1,
     651,   652,    -1,    -1,   655,   656,    -1,    -1,   659,   660,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    -1,    37,    38,    -1,    -1,    41,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,
      -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,
      -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,    -1,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,    -1,    -1,   180,   181,   182,    -1,   184,
     185,   186,    -1,   188,   189,   190,   191,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,
     205,   206,   207,   208,   209,    -1,   211,    -1,    -1,    -1,
     215,   216,   217,    -1,   219,   220,   221,    -1,   223,   224,
      -1,    -1,    -1,   228,   229,   230,   231,   232,    -1,    -1,
     235,   236,   237,    -1,   239,    -1,   241,    -1,    -1,    -1,
      -1,   246,   247,    -1,    -1,    -1,   251,    -1,   253,   254,
      -1,   256,   257,    -1,    -1,    -1,   261,    -1,    -1,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,   272,   273,    -1,
      -1,    -1,    -1,    -1,   279,   280,    -1,   282,    -1,   284,
      -1,   286,   287,    -1,    -1,   290,    -1,    -1,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,    -1,   317,   318,   319,   320,    -1,   322,   323,    -1,
      -1,    -1,    -1,   328,   329,   330,   331,   332,   333,    -1,
      -1,   336,   337,    -1,   339,    -1,   341,    -1,   343,   344,
     345,   346,   347,   348,   349,   350,   351,    -1,   353,   354,
     355,    -1,    -1,   358,   359,   360,   361,    -1,    -1,    -1,
     365,   366,    -1,   368,   369,   370,    -1,   372,   373,   374,
      -1,   376,   377,   378,   379,    -1,   381,   382,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,   392,   393,    -1,
      -1,   396,    -1,   398,    -1,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,    -1,    -1,   412,   413,   414,
      -1,   416,    -1,   418,   419,   420,   421,   422,    -1,   424,
     425,   426,    -1,    -1,   429,    -1,    -1,    -1,   433,   434,
     435,   436,   437,    -1,    -1,   440,   441,   442,   443,   444,
      -1,   446,   447,    -1,   449,   450,   451,    -1,    -1,   454,
      -1,   456,    -1,   458,   459,    -1,   461,   462,    -1,   464,
      -1,   466,    -1,    -1,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,    -1,   482,   483,    -1,
      -1,    -1,   487,   488,   489,   490,    -1,    -1,    -1,   494,
      -1,    -1,    -1,   498,    -1,   500,   501,   502,   503,   504,
     505,    -1,   507,   508,   509,   510,   511,   512,    -1,    -1,
      -1,    -1,    -1,    -1,   519,   520,    -1,   522,    -1,    -1,
     525,    -1,    -1,   528,   529,    -1,    -1,    -1,   533,    -1,
      -1,   536,   537,    -1,   539,   540,   541,   542,   543,   544,
      -1,    -1,   547,   548,   549,   550,    -1,   552,   553,    -1,
     555,    -1,   557,   558,   559,   560,    -1,   562,   563,   564,
      -1,   566,   567,   568,   569,    -1,    -1,    -1,    -1,    -1,
     575,   576,   577,    -1,    -1,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,    -1,   592,   593,    -1,
      -1,   596,    -1,    -1,   599,    -1,   601,    -1,   603,   604,
     605,    -1,    -1,    -1,    -1,    -1,    -1,   612,    -1,    -1,
     615,    -1,    -1,    -1,   619,   620,   621,   622,   623,   624,
     625,    -1,    -1,    -1,    -1,    -1,    -1,   632,   633,    -1,
     635,   636,   637,    -1,    -1,   640,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,   659,   660,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    93,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,   180,   181,   182,    -1,    -1,   185,
     186,    -1,   188,   189,   190,    -1,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,   200,   201,    -1,   203,   204,   205,
     206,   207,   208,   209,    -1,   211,    -1,    -1,    -1,   215,
     216,   217,    -1,   219,    -1,    -1,    -1,   223,   224,    -1,
      -1,    -1,   228,   229,   230,   231,   232,    -1,    -1,   235,
     236,   237,   238,   239,    -1,   241,    -1,    -1,    -1,    -1,
     246,   247,    -1,    -1,    -1,   251,    -1,   253,   254,    -1,
     256,   257,    -1,    -1,    -1,   261,   262,    -1,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,   272,   273,    -1,   275,
      -1,    -1,    -1,   279,   280,    -1,   282,    -1,   284,    -1,
     286,   287,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,    -1,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,    -1,   322,   323,    -1,    -1,
      -1,    -1,   328,   329,   330,   331,   332,   333,    -1,    -1,
     336,   337,    -1,   339,    -1,   341,    -1,   343,   344,   345,
     346,   347,   348,   349,   350,   351,    -1,    -1,   354,   355,
      -1,    -1,   358,   359,   360,   361,    -1,    -1,    -1,   365,
     366,    -1,    -1,    -1,   370,    -1,   372,   373,   374,    -1,
     376,   377,   378,   379,    -1,   381,   382,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   391,   392,   393,    -1,    -1,
     396,    -1,   398,    -1,   400,   401,   402,   403,   404,   405,
     406,   407,   408,   409,    -1,    -1,   412,   413,   414,    -1,
     416,    -1,   418,   419,   420,   421,   422,    -1,   424,   425,
     426,    -1,    -1,   429,    -1,    -1,    -1,   433,   434,   435,
     436,   437,    -1,    -1,   440,   441,   442,   443,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,    -1,   454,    -1,
     456,    -1,   458,   459,    -1,   461,   462,    -1,   464,    -1,
     466,    -1,    -1,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,    -1,   482,   483,   484,    -1,
      -1,   487,   488,   489,   490,    -1,    -1,    -1,   494,    -1,
      -1,    -1,   498,    -1,   500,   501,   502,   503,   504,   505,
      -1,   507,   508,   509,   510,   511,   512,   513,    -1,    -1,
      -1,    -1,    -1,   519,   520,    -1,   522,    -1,    -1,   525,
      -1,    -1,   528,   529,    -1,    -1,    -1,   533,    -1,    -1,
     536,   537,    -1,   539,   540,   541,   542,   543,   544,    -1,
      -1,   547,   548,   549,   550,    -1,   552,   553,    -1,   555,
      -1,   557,   558,   559,   560,    -1,    -1,   563,   564,    -1,
     566,   567,   568,   569,    -1,    -1,    -1,    -1,    -1,   575,
     576,   577,    -1,    -1,    -1,   581,   582,   583,   584,    -1,
     586,   587,    -1,   589,   590,    -1,   592,   593,    -1,    -1,
     596,    -1,    -1,   599,    -1,   601,    -1,   603,   604,   605,
      -1,    -1,    -1,    -1,    -1,    -1,   612,    -1,    -1,   615,
      -1,    -1,    -1,   619,   620,   621,   622,   623,   624,   625,
      -1,    -1,    -1,    -1,    -1,    -1,   632,   633,    -1,   635,
     636,   637,    -1,    -1,   640,    -1,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,   660,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,
      -1,    -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,
      -1,    60,    61,    -1,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    93,    94,    95,    96,    97,    98,
      -1,   100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,
      -1,    -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,
     119,    -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,
      -1,    -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,    -1,
      -1,   180,   181,   182,    -1,    -1,   185,   186,    -1,   188,
     189,   190,    -1,    -1,   193,    -1,    -1,    -1,   197,    -1,
     199,   200,   201,    -1,   203,   204,   205,   206,   207,   208,
     209,    -1,   211,    -1,    -1,    -1,   215,   216,   217,    -1,
     219,    -1,    -1,    -1,   223,   224,    -1,    -1,    -1,   228,
     229,   230,   231,   232,    -1,    -1,   235,   236,   237,   238,
     239,    -1,   241,    -1,    -1,    -1,    -1,   246,   247,    -1,
      -1,    -1,   251,    -1,   253,   254,    -1,   256,   257,    -1,
      -1,    -1,   261,   262,    -1,   264,   265,   266,    -1,    -1,
     269,    -1,    -1,   272,   273,    -1,    -1,    -1,    -1,    -1,
     279,   280,    -1,   282,    -1,   284,    -1,   286,   287,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   295,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,    -1,   312,   313,   314,   315,    -1,   317,   318,
     319,   320,    -1,   322,   323,    -1,    -1,    -1,    -1,   328,
     329,   330,   331,   332,   333,    -1,    -1,   336,   337,    -1,
     339,    -1,   341,    -1,   343,   344,   345,   346,   347,   348,
     349,   350,   351,    -1,    -1,   354,   355,    -1,    -1,   358,
     359,   360,   361,    -1,    -1,    -1,   365,   366,    -1,    -1,
      -1,   370,    -1,   372,   373,   374,    -1,   376,   377,   378,
     379,    -1,   381,   382,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   391,   392,   393,    -1,    -1,   396,    -1,   398,
      -1,   400,   401,   402,   403,   404,   405,   406,   407,   408,
     409,    -1,    -1,   412,   413,   414,    -1,   416,    -1,   418,
     419,   420,   421,   422,    -1,   424,   425,   426,    -1,    -1,
     429,    -1,    -1,    -1,   433,   434,   435,   436,   437,    -1,
      -1,   440,   441,   442,   443,   444,    -1,   446,   447,    -1,
     449,   450,   451,    -1,    -1,   454,    -1,   456,    -1,   458,
     459,    -1,   461,   462,    -1,   464,    -1,   466,    -1,    -1,
     469,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,    -1,   482,   483,    -1,    -1,    -1,   487,   488,
     489,   490,    -1,    -1,    -1,   494,    -1,    -1,    -1,   498,
      -1,   500,   501,   502,   503,   504,   505,    -1,   507,   508,
     509,   510,   511,   512,   513,    -1,    -1,    -1,    -1,    -1,
     519,   520,    -1,   522,    -1,    -1,   525,    -1,    -1,   528,
     529,    -1,    -1,    -1,   533,    -1,    -1,   536,   537,    -1,
     539,   540,   541,   542,   543,   544,    -1,    -1,   547,   548,
     549,   550,    -1,   552,   553,    -1,   555,    -1,   557,   558,
     559,   560,    -1,    -1,   563,   564,    -1,   566,   567,   568,
     569,    -1,    -1,    -1,    -1,    -1,   575,   576,   577,    -1,
      -1,    -1,   581,   582,   583,   584,    -1,   586,   587,    -1,
     589,   590,    -1,   592,   593,    -1,    -1,   596,    -1,    -1,
     599,    -1,   601,    -1,   603,   604,   605,    -1,    -1,    -1,
      -1,    -1,    -1,   612,    -1,    -1,   615,    -1,    -1,    -1,
     619,   620,   621,   622,   623,   624,   625,    -1,    -1,    -1,
      -1,    -1,    -1,   632,   633,    -1,   635,   636,   637,    -1,
      -1,   640,    -1,     5,    -1,     7,     8,     9,    10,    11,
      12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,
      22,   660,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    -1,    41,
      -1,    -1,    44,    45,    46,    -1,    48,    -1,    50,    51,
      -1,    -1,    54,    -1,    -1,    57,    58,    -1,    60,    61,
      -1,    63,    64,    -1,    66,    67,    68,    69,    70,    71,
      72,    -1,    74,    75,    76,    77,    78,    79,    80,    -1,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    91,
      92,    -1,    94,    95,    96,    97,    98,    -1,   100,    -1,
      -1,   103,    -1,    -1,   106,    -1,   108,    -1,    -1,   111,
      -1,   113,    -1,    -1,    -1,   117,   118,   119,    -1,    -1,
     122,    -1,    -1,    -1,    -1,   127,   128,    -1,    -1,    -1,
      -1,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,
     142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,
     152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,
      -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,   171,
     172,   173,   174,   175,   176,   177,    -1,    -1,   180,   181,
     182,    -1,    -1,   185,   186,    -1,   188,   189,   190,    -1,
      -1,   193,    -1,    -1,    -1,   197,    -1,   199,    -1,   201,
      -1,   203,   204,   205,   206,   207,   208,   209,    -1,   211,
      -1,    -1,    -1,   215,   216,   217,    -1,   219,    -1,    -1,
      -1,   223,   224,    -1,    -1,    -1,   228,   229,   230,   231,
     232,    -1,    -1,   235,   236,   237,    -1,   239,    -1,   241,
      -1,    -1,    -1,    -1,   246,   247,    -1,    -1,    -1,   251,
      -1,   253,   254,    -1,   256,   257,    -1,    -1,    -1,   261,
      -1,    -1,   264,   265,   266,    -1,    -1,   269,    -1,    -1,
     272,   273,    -1,    -1,    -1,    -1,    -1,   279,   280,    -1,
     282,    -1,   284,    -1,   286,   287,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   295,   296,   297,   298,   299,   300,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,    -1,
     312,   313,   314,   315,    -1,   317,   318,   319,   320,    -1,
     322,   323,    -1,    -1,    -1,    -1,   328,   329,   330,   331,
     332,   333,    -1,    -1,   336,   337,    -1,   339,    -1,   341,
      -1,   343,   344,   345,   346,   347,   348,   349,   350,   351,
      -1,    -1,   354,   355,    -1,    -1,   358,   359,   360,   361,
      -1,    -1,    -1,   365,   366,    -1,    -1,    -1,   370,    -1,
     372,   373,   374,    -1,   376,   377,   378,   379,    -1,   381,
     382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   391,
     392,   393,    -1,    -1,   396,    -1,   398,    -1,   400,   401,
     402,   403,   404,   405,   406,   407,   408,   409,    -1,    -1,
     412,   413,   414,    -1,   416,    -1,   418,   419,   420,   421,
     422,    -1,   424,   425,   426,    -1,    -1,   429,    -1,    -1,
      -1,   433,   434,   435,   436,   437,    -1,    -1,   440,   441,
     442,   443,   444,    -1,   446,   447,    -1,   449,   450,   451,
      -1,    -1,   454,    -1,   456,    -1,   458,   459,    -1,   461,
     462,    -1,   464,    -1,   466,    -1,    -1,   469,   470,   471,
     472,   473,   474,   475,   476,   477,   478,   479,   480,    -1,
     482,   483,   484,    -1,    -1,   487,   488,   489,   490,    -1,
      -1,    -1,   494,    -1,    -1,    -1,   498,    -1,   500,   501,
     502,   503,   504,   505,    -1,   507,   508,   509,   510,   511,
     512,    -1,    -1,    -1,    -1,    -1,    -1,   519,   520,    -1,
     522,    -1,    -1,   525,    -1,    -1,   528,   529,    -1,    -1,
      -1,   533,    -1,    -1,   536,   537,    -1,   539,   540,   541,
     542,   543,   544,    -1,    -1,   547,   548,   549,   550,    -1,
     552,   553,    -1,   555,    -1,   557,   558,   559,   560,    -1,
      -1,   563,   564,    -1,   566,   567,   568,   569,    -1,    -1,
      -1,    -1,    -1,   575,   576,   577,    -1,    -1,    -1,   581,
     582,   583,   584,    -1,   586,   587,    -1,   589,   590,    -1,
     592,   593,    -1,    -1,   596,    -1,    -1,   599,    -1,   601,
      -1,   603,   604,   605,    -1,    -1,    -1,    -1,    -1,    -1,
     612,    -1,    -1,   615,    -1,    -1,    -1,   619,   620,   621,
     622,   623,   624,   625,    -1,    -1,    -1,    -1,    -1,    -1,
     632,   633,    -1,   635,   636,   637,    -1,    -1,   640,    -1,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,   653,    -1,    -1,    19,    -1,    -1,    22,   660,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,
      -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,
      -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,
      -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,    -1,    -1,   180,   181,   182,    -1,    -1,
     185,   186,    -1,   188,   189,   190,    -1,    -1,   193,    -1,
      -1,    -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,
     205,   206,   207,   208,   209,    -1,   211,    -1,    -1,    -1,
     215,   216,   217,    -1,   219,    -1,    -1,    -1,   223,   224,
      -1,    -1,    -1,   228,   229,   230,   231,   232,    -1,    -1,
     235,   236,   237,    -1,   239,    -1,   241,    -1,    -1,    -1,
      -1,   246,   247,    -1,    -1,    -1,   251,    -1,   253,   254,
      -1,   256,   257,    -1,    -1,    -1,   261,    -1,    -1,   264,
     265,   266,    -1,    -1,   269,    -1,    -1,   272,   273,    -1,
      -1,    -1,    -1,    -1,   279,   280,    -1,   282,    -1,   284,
      -1,   286,   287,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,    -1,   312,   313,   314,
     315,    -1,   317,   318,   319,   320,    -1,   322,   323,    -1,
      -1,    -1,    -1,   328,   329,   330,   331,   332,   333,    -1,
      -1,   336,   337,    -1,   339,    -1,   341,    -1,   343,   344,
     345,   346,   347,   348,   349,   350,   351,    -1,    -1,   354,
     355,    -1,    -1,   358,   359,   360,   361,    -1,    -1,    -1,
     365,   366,    -1,    -1,    -1,   370,    -1,   372,   373,   374,
      -1,   376,   377,   378,   379,    -1,   381,   382,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   391,   392,   393,    -1,
      -1,   396,    -1,   398,    -1,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,    -1,    -1,   412,   413,   414,
      -1,   416,    -1,   418,   419,   420,   421,   422,    -1,   424,
     425,   426,    -1,    -1,   429,    -1,    -1,    -1,   433,   434,
     435,   436,   437,    -1,    -1,   440,   441,   442,   443,   444,
      -1,   446,   447,    -1,   449,   450,   451,    -1,    -1,   454,
      -1,   456,    -1,   458,   459,    -1,   461,   462,    -1,   464,
      -1,   466,    -1,    -1,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,    -1,   482,   483,    -1,
      -1,    -1,   487,   488,   489,   490,    -1,    -1,    -1,   494,
      -1,    -1,    -1,   498,    -1,   500,   501,   502,   503,   504,
     505,    -1,   507,   508,   509,   510,   511,   512,    -1,    -1,
      -1,    -1,    -1,    -1,   519,   520,    -1,   522,    -1,    -1,
     525,    -1,    -1,   528,   529,    -1,    -1,    -1,   533,    -1,
      -1,   536,   537,    -1,   539,   540,   541,   542,   543,   544,
      -1,    -1,   547,   548,   549,   550,    -1,   552,   553,    -1,
     555,    -1,   557,   558,   559,   560,    -1,    -1,   563,   564,
      -1,   566,   567,   568,   569,    -1,    -1,    -1,    -1,    -1,
     575,   576,   577,    -1,    -1,    -1,   581,   582,   583,   584,
      -1,   586,   587,    -1,   589,   590,    -1,   592,   593,    -1,
      -1,   596,    -1,    -1,   599,    -1,   601,    -1,   603,   604,
     605,    -1,    -1,    -1,    -1,    -1,    -1,   612,    -1,    -1,
     615,    -1,    -1,    -1,   619,   620,   621,   622,   623,   624,
     625,    -1,    -1,    -1,    -1,    -1,    -1,   632,   633,    -1,
     635,   636,   637,    -1,    -1,   640,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,   653,    15,
      -1,    -1,    -1,    19,   659,   660,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,   180,   181,   182,    -1,    -1,   185,
     186,    -1,   188,   189,   190,    -1,    -1,   193,    -1,    -1,
      -1,   197,    -1,   199,    -1,   201,    -1,   203,   204,   205,
     206,   207,   208,   209,    -1,   211,    -1,    -1,    -1,   215,
     216,   217,    -1,   219,    -1,    -1,    -1,   223,   224,    -1,
      -1,    -1,   228,   229,   230,   231,   232,    -1,    -1,   235,
     236,   237,    -1,   239,    -1,   241,    -1,    -1,    -1,    -1,
     246,   247,    -1,    -1,    -1,   251,    -1,   253,   254,    -1,
     256,   257,    -1,    -1,    -1,   261,    -1,    -1,   264,   265,
     266,    -1,    -1,   269,    -1,    -1,   272,   273,    -1,    -1,
      -1,    -1,    -1,   279,   280,    -1,   282,    -1,   284,    -1,
     286,   287,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,    -1,   312,   313,   314,   315,
      -1,   317,   318,   319,   320,    -1,   322,   323,    -1,    -1,
      -1,    -1,   328,   329,   330,   331,   332,   333,    -1,    -1,
     336,   337,    -1,   339,    -1,   341,    -1,   343,   344,   345,
     346,   347,   348,   349,   350,   351,    -1,    -1,   354,   355,
      -1,    -1,   358,   359,   360,   361,    -1,    -1,    -1,   365,
     366,    -1,    -1,    -1,   370,    -1,   372,   373,   374,    -1,
     376,   377,   378,   379,    -1,   381,   382,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   391,   392,   393,    -1,    -1,
     396,    -1,   398,    -1,   400,   401,   402,   403,   404,   405,
     406,   407,   408,   409,    -1,    -1,   412,   413,   414,    -1,
     416,    -1,   418,   419,   420,   421,   422,    -1,   424,   425,
     426,    -1,    -1,   429,    -1,    -1,    -1,   433,   434,   435,
     436,   437,    -1,    -1,   440,   441,   442,   443,   444,    -1,
     446,   447,    -1,   449,   450,   451,    -1,    -1,   454,    -1,
     456,    -1,   458,   459,    -1,   461,   462,    -1,   464,    -1,
     466,    -1,    -1,   469,   470,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,    -1,   482,   483,    -1,    -1,
      -1,   487,   488,   489,   490,    -1,    -1,    -1,   494,    -1,
      -1,    -1,   498,    -1,   500,   501,   502,   503,   504,   505,
      -1,   507,   508,   509,   510,   511,   512,    -1,    -1,    -1,
      -1,    -1,    -1,   519,   520,    -1,   522,    -1,    -1,   525,
      -1,    -1,   528,   529,    -1,    -1,    -1,   533,    -1,    -1,
     536,   537,    -1,   539,   540,   541,   542,   543,   544,    -1,
      -1,   547,   548,   549,   550,    -1,   552,   553,    -1,   555,
      -1,   557,   558,   559,   560,    -1,    -1,   563,   564,    -1,
     566,   567,   568,   569,    -1,    -1,    -1,    -1,    -1,   575,
     576,   577,    -1,    -1,    -1,   581,   582,   583,   584,    -1,
     586,   587,    -1,   589,   590,    -1,   592,   593,    -1,    -1,
     596,    -1,    -1,   599,    -1,   601,    -1,   603,   604,   605,
      -1,    -1,    -1,    -1,    -1,    -1,   612,    -1,    -1,   615,
      -1,    -1,    -1,   619,   620,   621,   622,   623,   624,   625,
      -1,    -1,    -1,    -1,    -1,    -1,   632,   633,    -1,   635,
     636,   637,    -1,    -1,   640,    -1,    -1,    -1,     5,    -1,
       7,     8,     9,    10,    11,    12,   652,    -1,    15,    -1,
      -1,    -1,    19,    -1,   660,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,
      57,    58,    -1,    60,    61,    -1,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,
      -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,
     117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,
     127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,    -1,    -1,   180,   181,   182,    -1,    -1,   185,   186,
      -1,   188,   189,   190,    -1,    -1,   193,    -1,    -1,    -1,
     197,    -1,   199,    -1,   201,    -1,   203,   204,   205,   206,
     207,   208,   209,    -1,   211,    -1,    -1,    -1,   215,   216,
     217,    -1,   219,    -1,    -1,    -1,   223,   224,    -1,    -1,
      -1,   228,   229,   230,   231,   232,    -1,    -1,   235,   236,
     237,    -1,   239,    -1,   241,    -1,    -1,    -1,    -1,   246,
     247,    -1,   249,    -1,   251,    -1,   253,   254,    -1,   256,
     257,    -1,    -1,    -1,   261,    -1,    -1,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,   272,   273,    -1,    -1,    -1,
      -1,    -1,   279,   280,    -1,   282,    -1,   284,    -1,   286,
     287,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,    -1,
     317,   318,   319,   320,    -1,   322,   323,    -1,    -1,    -1,
      -1,   328,   329,   330,   331,   332,   333,    -1,    -1,   336,
     337,    -1,   339,    -1,   341,    -1,   343,   344,   345,   346,
     347,   348,   349,   350,   351,    -1,    -1,   354,   355,    -1,
      -1,   358,   359,   360,   361,    -1,    -1,    -1,   365,   366,
      -1,    -1,    -1,   370,    -1,   372,   373,   374,    -1,   376,
     377,   378,   379,    -1,   381,   382,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   391,   392,   393,    -1,    -1,   396,
      -1,   398,    -1,   400,   401,   402,   403,   404,   405,   406,
     407,   408,   409,    -1,    -1,   412,   413,   414,    -1,   416,
      -1,   418,   419,   420,   421,   422,    -1,   424,   425,   426,
      -1,    -1,   429,    -1,    -1,    -1,   433,   434,   435,   436,
     437,    -1,    -1,   440,   441,   442,   443,   444,    -1,   446,
     447,    -1,   449,   450,   451,    -1,    -1,   454,    -1,   456,
      -1,   458,   459,    -1,   461,   462,    -1,   464,    -1,   466,
      -1,    -1,   469,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,    -1,   482,   483,    -1,    -1,    -1,
     487,   488,   489,   490,    -1,    -1,    -1,   494,    -1,    -1,
      -1,   498,    -1,   500,   501,   502,   503,   504,   505,    -1,
     507,   508,   509,   510,   511,   512,    -1,    -1,    -1,    -1,
      -1,    -1,   519,   520,    -1,   522,    -1,    -1,   525,    -1,
      -1,   528,   529,    -1,    -1,    -1,   533,    -1,    -1,   536,
     537,    -1,   539,   540,   541,   542,   543,   544,    -1,    -1,
     547,   548,   549,   550,    -1,   552,   553,    -1,   555,    -1,
     557,   558,   559,   560,    -1,    -1,   563,   564,    -1,   566,
     567,   568,   569,    -1,    -1,    -1,    -1,    -1,   575,   576,
     577,    -1,    -1,    -1,   581,   582,   583,   584,    -1,   586,
     587,    -1,   589,   590,    -1,   592,   593,    -1,    -1,   596,
      -1,    -1,   599,    -1,   601,    -1,   603,   604,   605,    -1,
      -1,    -1,    -1,    -1,    -1,   612,    -1,    -1,   615,    -1,
      -1,    -1,   619,   620,   621,   622,   623,   624,   625,    -1,
      -1,    -1,    -1,    -1,    -1,   632,   633,    -1,   635,   636,
     637,    -1,    -1,   640,    -1,     5,    -1,     7,     8,     9,
      10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,
      -1,    -1,    22,   660,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,
      60,    61,    -1,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,
      -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,
      -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,    -1,
      -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,    -1,   168,   169,
      -1,   171,   172,   173,   174,   175,   176,   177,    -1,    -1,
     180,   181,   182,    -1,    -1,   185,   186,    -1,   188,   189,
     190,    -1,    -1,   193,    -1,    -1,    -1,   197,    -1,   199,
      -1,   201,    -1,   203,   204,   205,   206,   207,   208,   209,
      -1,   211,    -1,    -1,    -1,   215,   216,   217,    -1,   219,
      -1,    -1,    -1,   223,   224,    -1,    -1,    -1,   228,   229,
     230,   231,   232,    -1,    -1,   235,   236,   237,    -1,   239,
      -1,   241,    -1,    -1,    -1,    -1,   246,   247,    -1,    -1,
      -1,   251,    -1,   253,   254,    -1,   256,   257,    -1,    -1,
      -1,   261,    -1,    -1,   264,   265,   266,    -1,    -1,   269,
      -1,    -1,   272,   273,    -1,    -1,    -1,    -1,    -1,   279,
     280,    -1,   282,    -1,   284,    -1,   286,   287,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   295,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,    -1,   312,   313,   314,   315,    -1,   317,   318,   319,
     320,    -1,   322,   323,    -1,    -1,    -1,    -1,   328,   329,
     330,   331,   332,   333,    -1,    -1,   336,   337,    -1,   339,
      -1,   341,    -1,   343,   344,   345,   346,   347,   348,   349,
     350,   351,    -1,    -1,   354,   355,    -1,    -1,   358,   359,
     360,   361,    -1,    -1,    -1,   365,   366,    -1,    -1,    -1,
     370,    -1,   372,   373,   374,    -1,   376,   377,   378,   379,
      -1,   381,   382,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   391,   392,   393,    -1,    -1,   396,    -1,   398,    -1,
     400,   401,   402,   403,   404,   405,   406,   407,   408,   409,
      -1,    -1,   412,   413,   414,    -1,   416,    -1,   418,   419,
     420,   421,   422,    -1,   424,   425,   426,    -1,    -1,   429,
      -1,    -1,    -1,   433,   434,   435,   436,   437,    -1,    -1,
     440,   441,   442,   443,   444,    -1,   446,   447,    -1,   449,
     450,   451,    -1,    -1,   454,    -1,   456,    -1,   458,   459,
      -1,   461,   462,    -1,   464,    -1,   466,    -1,    -1,   469,
     470,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,    -1,   482,   483,    -1,    -1,    -1,   487,   488,   489,
     490,    -1,    -1,    -1,   494,    -1,    -1,    -1,   498,    -1,
     500,   501,   502,   503,   504,   505,    -1,   507,   508,   509,
     510,   511,   512,    -1,    -1,    -1,    -1,    -1,    -1,   519,
     520,    -1,   522,    -1,    -1,   525,    -1,    -1,   528,   529,
      -1,    -1,    -1,   533,    -1,    -1,   536,   537,    -1,   539,
     540,   541,   542,   543,   544,    -1,    -1,   547,   548,   549,
     550,    -1,   552,   553,    -1,   555,    -1,   557,   558,   559,
     560,    -1,    -1,   563,   564,    -1,   566,   567,   568,   569,
      -1,    -1,    -1,    -1,    -1,   575,   576,   577,    -1,    -1,
      -1,   581,   582,   583,   584,    -1,   586,   587,    -1,   589,
     590,    -1,   592,   593,    -1,    -1,   596,    -1,    -1,   599,
      -1,   601,    -1,   603,   604,   605,    -1,    -1,    -1,    -1,
      -1,    -1,   612,    -1,    -1,   615,    -1,    -1,    -1,   619,
     620,   621,   622,   623,   624,   625,    -1,    -1,    -1,    -1,
      -1,    -1,   632,   633,    -1,   635,   636,   637,    -1,    -1,
     640,    -1,    -1,    -1,    -1,    -1,    -1,   647,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
     660,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,
      57,    58,    -1,    60,    61,    -1,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,
      -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,
     117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,
     127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,    -1,    -1,   180,   181,   182,    -1,    -1,   185,   186,
      -1,   188,   189,   190,    -1,    -1,   193,    -1,    -1,    -1,
     197,    -1,   199,    -1,   201,    -1,   203,   204,   205,   206,
     207,   208,   209,    -1,   211,    -1,    -1,    -1,   215,   216,
     217,    -1,   219,    -1,    -1,    -1,   223,   224,    -1,    -1,
      -1,   228,   229,   230,   231,   232,    -1,    -1,   235,   236,
     237,    -1,   239,    -1,   241,    -1,    -1,    -1,    -1,   246,
     247,    -1,    -1,    -1,   251,    -1,   253,   254,    -1,   256,
     257,    -1,    -1,    -1,   261,    -1,    -1,   264,   265,   266,
      -1,    -1,   269,    -1,    -1,   272,   273,    -1,    -1,    -1,
      -1,    -1,   279,   280,    -1,   282,    -1,   284,    -1,   286,
     287,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   295,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,    -1,   312,   313,   314,   315,    -1,
     317,   318,   319,   320,    -1,   322,   323,    -1,    -1,    -1,
      -1,   328,   329,   330,   331,   332,   333,    -1,    -1,   336,
     337,    -1,   339,    -1,   341,    -1,   343,   344,   345,   346,
     347,   348,   349,   350,   351,    -1,    -1,   354,   355,    -1,
      -1,   358,   359,   360,   361,    -1,    -1,    -1,   365,   366,
      -1,    -1,    -1,   370,    -1,   372,   373,   374,    -1,   376,
     377,   378,   379,    -1,   381,   382,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   391,   392,   393,    -1,    -1,   396,
      -1,   398,    -1,   400,   401,   402,   403,   404,   405,   406,
     407,   408,   409,    -1,    -1,   412,   413,   414,    -1,   416,
      -1,   418,   419,   420,   421,   422,    -1,   424,   425,   426,
      -1,    -1,   429,    -1,    -1,    -1,   433,   434,   435,   436,
     437,    -1,    -1,   440,   441,   442,   443,   444,    -1,   446,
     447,    -1,   449,   450,   451,    -1,    -1,   454,    -1,   456,
      -1,   458,   459,    -1,   461,   462,    -1