
/* A Bison parser, made by GNU Bison 2.4.1.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C
   
      Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.4.1"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 0

/* Substitute the variable and function names.  */
#define yyparse         MYSQLparse
#define yylex           MYSQLlex
#define yyerror         MYSQLerror
#define yylval          MYSQLlval
#define yychar          MYSQLchar
#define yydebug         MYSQLdebug
#define yynerrs         MYSQLnerrs


/* Copy the first part of user declarations.  */

/* Line 189 of yacc.c  */
#line 25 "/home/buildbot/git/sql/sql_yacc.yy"

#define YYLIP  (& thd->m_parser_state->m_lip)
#define YYPS   (& thd->m_parser_state->m_yacc)
#define YYCSCL (thd->variables.character_set_client)

#define MYSQL_YACC
#define YYINITDEPTH 100
#define YYMAXDEPTH 3200                        /* Because of 64K stack */
#define Lex (thd->lex)

#define Select Lex->current_select
#include <my_global.h>
#include "sql_priv.h"
#include "unireg.h"                    // REQUIRED: for other includes
#include "sql_parse.h"                        /* comp_*_creator */
#include "sql_table.h"                        /* primary_key_name */
#include "sql_partition.h"  /* mem_alloc_error, partition_info, HASH_PARTITION */
#include "sql_acl.h"                          /* *_ACL */
#include "password.h"       /* my_make_scrambled_password_323, my_make_scrambled_password */
#include "sql_class.h"      /* Key_part_spec, enum_filetype, Diag_condition_item_name */
#include "slave.h"
#include "lex_symbol.h"
#include "item_create.h"
#include "sp_head.h"
#include "sp_pcontext.h"
#include "sp_rcontext.h"
#include "sp.h"
#include "sql_alter.h"                         // Sql_cmd_alter_table*
#include "sql_truncate.h"                      // Sql_cmd_truncate_table
#include "sql_admin.h"                         // Sql_cmd_analyze/Check..._table
#include "sql_partition_admin.h"               // Sql_cmd_alter_table_*_part.
#include "sql_handler.h"                       // Sql_cmd_handler_*
#include "sql_signal.h"
#include "sql_get_diagnostics.h"               // Sql_cmd_get_diagnostics
#include "event_parse_data.h"
#include "create_options.h"
#include <myisam.h>
#include <myisammrg.h>
#include "keycaches.h"
#include "set_var.h"
#include "rpl_mi.h"
#include "lex_token.h"

/* this is to get the bison compilation windows warnings out */
#ifdef _MSC_VER
/* warning C4065: switch statement contains 'default' but no 'case' labels */
#pragma warning (disable : 4065)
#endif

int yylex(void *yylval, void *yythd);

#define yyoverflow(A,B,C,D,E,F)               \
  {                                           \
    ulong val= *(F);                          \
    if (my_yyoverflow((B), (D), &val))        \
    {                                         \
      yyerror(thd, (char*) (A));              \
      return 2;                               \
    }                                         \
    else                                      \
    {                                         \
      *(F)= (YYSIZE_T)val;                    \
    }                                         \
  }

#define MYSQL_YYABORT                         \
  do                                          \
  {                                           \
    LEX::cleanup_lex_after_parse_error(thd);  \
    YYABORT;                                  \
  } while (0)

#define MYSQL_YYABORT_UNLESS(A)         \
  if (!(A))                             \
  {                                     \
    my_parse_error(ER(ER_SYNTAX_ERROR));\
    MYSQL_YYABORT;                      \
  }

/*
  Work around for broken code generated by bison 1.875.

  The code generated by bison 1.875a and later, bison 2.1 and bison 2.2 is ok.
  With bison 1.875 however, the generated code contains:
<pre>
  yyerrlab1:
  #if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
    __attribute__ ((__unused__))
  #endif
</pre>
  This usage of __attribute__ is illegal, so we remove it.
  See the following references for details:
  http://lists.gnu.org/archive/html/bug-bison/2004-02/msg00014.html
  http://gcc.gnu.org/bugzilla/show_bug.cgi?id=14273
*/

#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
#undef __attribute__
#define __attribute__(X)
#endif


#ifndef DBUG_OFF
#define YYDEBUG 1
#else
#define YYDEBUG 0
#endif

/**
  @brief Push an error message into MySQL error stack with line
  and position information.

  This function provides semantic action implementers with a way
  to push the famous "You have a syntax error near..." error
  message into the error stack, which is normally produced only if
  a parse error is discovered internally by the Bison generated
  parser.
*/

void my_parse_error(const char *s)
{
  THD *thd= current_thd;
  Lex_input_stream *lip= & thd->m_parser_state->m_lip;

  const char *yytext= lip->get_tok_start();
  if (!yytext)
    yytext= "";

  /* Push an error into the error stack */
  ErrConvString err(yytext, strlen(yytext), thd->variables.character_set_client);
  my_printf_error(ER_PARSE_ERROR,  ER(ER_PARSE_ERROR), MYF(0), s,
                  err.ptr(), lip->yylineno);
}

/**
  @brief Bison callback to report a syntax/OOM error

  This function is invoked by the bison-generated parser
  when a syntax error, a parse error or an out-of-memory
  condition occurs. This function is not invoked when the
  parser is requested to abort by semantic action code
  by means of YYABORT or YYACCEPT macros. This is why these
  macros should not be used (use MYSQL_YYABORT/MYSQL_YYACCEPT
  instead).

  The parser will abort immediately after invoking this callback.

  This function is not for use in semantic actions and is internal to
  the parser, as it performs some pre-return cleanup. 
  In semantic actions, please use my_parse_error or my_error to
  push an error into the error stack and MYSQL_YYABORT
  to abort from the parser.
*/

void MYSQLerror(THD *thd, const char *s)
{
  /*
    Restore the original LEX if it was replaced when parsing
    a stored procedure. We must ensure that a parsing error
    does not leave any side effects in the THD.
  */
  LEX::cleanup_lex_after_parse_error(thd);

  /* "parse error" changed into "syntax error" between bison 1.75 and 1.875 */
  if (strcmp(s,"parse error") == 0 || strcmp(s,"syntax error") == 0)
    s= ER(ER_SYNTAX_ERROR);
  my_parse_error(s);
}


#ifndef DBUG_OFF
void turn_parser_debug_on()
{
  /*
     MYSQLdebug is in sql/sql_yacc.cc, in bison generated code.
     Turning this option on is **VERY** verbose, and should be
     used when investigating a syntax error problem only.

     The syntax to run with bison traces is as follows :
     - Starting a server manually :
       mysqld --debug-dbug="d,parser_debug" ...
     - Running a test :
       mysql-test-run.pl --mysqld="--debug-dbug=d,parser_debug" ...

     The result will be in the process stderr (var/log/master.err)
   */

  extern int yydebug;
  yydebug= 1;
}
#endif

static bool is_native_function(THD *thd, const LEX_STRING *name)
{
  if (find_native_function_builder(thd, *name))
    return true;

  if (is_lex_native_function(name))
    return true;

  return false;
}


/**
  Helper action for a case statement (entering the CASE).
  This helper is used for both 'simple' and 'searched' cases.
  This helper, with the other case_stmt_action_..., is executed when
  the following SQL code is parsed:
<pre>
CREATE PROCEDURE proc_19194_simple(i int)
BEGIN
  DECLARE str CHAR(10);

  CASE i
    WHEN 1 THEN SET str="1";
    WHEN 2 THEN SET str="2";
    WHEN 3 THEN SET str="3";
    ELSE SET str="unknown";
  END CASE;

  SELECT str;
END
</pre>
  The actions are used to generate the following code:
<pre>
SHOW PROCEDURE CODE proc_19194_simple;
Pos     Instruction
0       set str@1 NULL
1       set_case_expr (12) 0 i@0
2       jump_if_not 5(12) (case_expr@0 = 1)
3       set str@1 _latin1'1'
4       jump 12
5       jump_if_not 8(12) (case_expr@0 = 2)
6       set str@1 _latin1'2'
7       jump 12
8       jump_if_not 11(12) (case_expr@0 = 3)
9       set str@1 _latin1'3'
10      jump 12
11      set str@1 _latin1'unknown'
12      stmt 0 "SELECT str"
</pre>

  @param lex the parser lex context
*/

void case_stmt_action_case(LEX *lex)
{
  lex->sphead->new_cont_backpatch(NULL);

  /*
    BACKPATCH: Creating target label for the jump to
    "case_stmt_action_end_case"
    (Instruction 12 in the example)
  */

  lex->spcont->push_label(current_thd, empty_lex_str, lex->sphead->instructions());
}

/**
  Helper action for a case expression statement (the expr in 'CASE expr').
  This helper is used for 'searched' cases only.
  @param lex the parser lex context
  @param expr the parsed expression
  @return 0 on success
*/

int case_stmt_action_expr(LEX *lex, Item* expr)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *parsing_ctx= lex->spcont;
  int case_expr_id= parsing_ctx->register_case_expr();
  sp_instr_set_case_expr *i;

  if (parsing_ctx->push_case_expr_id(case_expr_id))
    return 1;

  i= new sp_instr_set_case_expr(sp->instructions(),
                                parsing_ctx, case_expr_id, expr, lex);

  sp->add_cont_backpatch(i);
  return sp->add_instr(i);
}

/**
  Helper action for a case when condition.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param when the parsed expression for the WHEN clause
  @param simple true for simple cases, false for searched cases
*/

int case_stmt_action_when(LEX *lex, Item *when, bool simple)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump_if_not *i;
  Item_case_expr *var;
  Item *expr;

  if (simple)
  {
    var= new Item_case_expr(ctx->get_current_case_expr_id());

#ifndef DBUG_OFF
    if (var)
    {
      var->m_sp= sp;
    }
#endif

    expr= new Item_func_eq(var, when);
    i= new sp_instr_jump_if_not(ip, ctx, expr, lex);
  }
  else
    i= new sp_instr_jump_if_not(ip, ctx, when, lex);

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  return !MY_TEST(i) ||
         sp->push_backpatch(i, ctx->push_label(current_thd, empty_lex_str, 0)) ||
         sp->add_cont_backpatch(i) ||
         sp->add_instr(i);
}

/**
  Helper action for a case then statements.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
*/

int case_stmt_action_then(LEX *lex)
{
  sp_head *sp= lex->sphead;
  sp_pcontext *ctx= lex->spcont;
  uint ip= sp->instructions();
  sp_instr_jump *i = new sp_instr_jump(ip, ctx);
  if (!MY_TEST(i) || sp->add_instr(i))
    return 1;

  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_when" to "case_stmt_action_then"
    (jump_if_not from instruction 2 to 5, 5 to 8 ... in the example)
  */

  sp->backpatch(ctx->pop_label());

  /*
    BACKPATCH: Registering forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */

  return sp->push_backpatch(i, ctx->last_label());
}

/**
  Helper action for an end case.
  This helper is used for both 'simple' and 'searched' cases.
  @param lex the parser lex context
  @param simple true for simple cases, false for searched cases
*/

void case_stmt_action_end_case(LEX *lex, bool simple)
{
  /*
    BACKPATCH: Resolving forward jump from
    "case_stmt_action_then" to "case_stmt_action_end_case"
    (jump from instruction 4 to 12, 7 to 12 ... in the example)
  */
  lex->sphead->backpatch(lex->spcont->pop_label());

  if (simple)
    lex->spcont->pop_case_expr_id();

  lex->sphead->do_cont_backpatch();
}


static bool
find_sys_var_null_base(THD *thd, struct sys_var_with_base *tmp)
{
  tmp->var= find_sys_var(thd, tmp->base_name.str, tmp->base_name.length);

  if (tmp->var == NULL)
    my_error(ER_UNKNOWN_SYSTEM_VARIABLE, MYF(0), tmp->base_name.str);
  else
    tmp->base_name= null_lex_str;

  return thd->is_error();
}


/**
  Helper action for a SET statement.
  Used to push a system variable into the assignment list.

  @param thd      the current thread
  @param tmp      the system variable with base name
  @param var_type the scope of the variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_system_variable(THD *thd, struct sys_var_with_base *tmp,
                    enum enum_var_type var_type, Item *val)
{
  set_var *var;
  LEX *lex= thd->lex;

  /* No AUTOCOMMIT from a stored function or trigger. */
  if (lex->spcont && tmp->var == Sys_autocommit_ptr)
    lex->sphead->m_flags|= sp_head::HAS_SET_AUTOCOMMIT_STMT;

  if (val && val->type() == Item::FIELD_ITEM &&
      ((Item_field*)val)->table_name)
  {
    my_error(ER_WRONG_TYPE_FOR_VAR, MYF(0), tmp->var->name.str);
    return TRUE;
  }

  if (! (var= new set_var(var_type, tmp->var, &tmp->base_name, val)))
    return TRUE;

  return lex->var_list.push_back(var);
}


/**
  Helper action for a SET statement.
  Used to push a SP local variable into the assignment list.

  @param thd      the current thread
  @param var_type the SP local variable
  @param val      the value being assigned to the variable

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_local_variable(THD *thd, sp_variable *spv, Item *val)
{
  Item *it;
  LEX *lex= thd->lex;
  sp_instr_set *sp_set;

  if (val)
    it= val;
  else if (spv->default_value)
    it= spv->default_value;
  else
  {
    it= new (thd->mem_root) Item_null();
    if (it == NULL)
      return TRUE;
  }

  sp_set= new sp_instr_set(lex->sphead->instructions(), lex->spcont,
                           spv->offset, it, spv->type, lex, TRUE);

  return (sp_set == NULL || lex->sphead->add_instr(sp_set));
}


/**
  Helper action for a SET statement.
  Used to SET a field of NEW row.

  @param thd      the current thread
  @param name     the field name
  @param val      the value being assigned to the row

  @return TRUE if error, FALSE otherwise.
*/

static bool
set_trigger_new_row(THD *thd, LEX_STRING *name, Item *val)
{
  LEX *lex= thd->lex;
  Item_trigger_field *trg_fld;
  sp_instr_set_trigger_field *sp_fld;

  /* QQ: Shouldn't this be field's default value ? */
  if (! val)
    val= new Item_null();

  DBUG_ASSERT(lex->trg_chistics.action_time == TRG_ACTION_BEFORE &&
              (lex->trg_chistics.event == TRG_EVENT_INSERT ||
               lex->trg_chistics.event == TRG_EVENT_UPDATE));

  trg_fld= new (thd->mem_root)
            Item_trigger_field(lex->current_context(),
                               Item_trigger_field::NEW_ROW,
                               name->str, UPDATE_ACL, FALSE);

  if (trg_fld == NULL)
    return TRUE;

  sp_fld= new sp_instr_set_trigger_field(lex->sphead->instructions(),
                                         lex->spcont, trg_fld, val, lex);

  if (sp_fld == NULL)
    return TRUE;

  /*
    Let us add this item to list of all Item_trigger_field
    objects in trigger.
  */
  lex->trg_table_fields.link_in_list(trg_fld, &trg_fld->next_trg_field);

  return lex->sphead->add_instr(sp_fld);
}


/**
  Create an object to represent a SP variable in the Item-hierarchy.

  @param  thd         The current thread.
  @param  name        The SP variable name.
  @param  spvar       The SP variable (optional).
  @param  start_in_q  Start position of the SP variable name in the query.
  @param  end_in_q    End position of the SP variable name in the query.

  @remark If spvar is not specified, the name is used to search for the
          variable in the parse-time context. If the variable does not
          exist, a error is set and NULL is returned to the caller.

  @return An Item_splocal object representing the SP variable, or NULL on error.
*/
static Item_splocal*
create_item_for_sp_var(THD *thd, LEX_STRING name, sp_variable *spvar,
                       const char *start_in_q, const char *end_in_q)
{
  Item_splocal *item;
  LEX *lex= thd->lex;
  uint pos_in_q, len_in_q;
  sp_pcontext *spc = lex->spcont;

  /* If necessary, look for the variable. */
  if (spc && !spvar)
    spvar= spc->find_variable(name, false);

  if (!spvar)
  {
    my_error(ER_SP_UNDECLARED_VAR, MYF(0), name.str);
    return NULL;
  }

  DBUG_ASSERT(spc && spvar);

  /* Position and length of the SP variable name in the query. */
  pos_in_q= start_in_q - lex->sphead->m_tmp_query;
  len_in_q= end_in_q - start_in_q;

  item= new (thd->mem_root)
    Item_splocal(name, spvar->offset, spvar->type, pos_in_q, len_in_q);

#ifndef DBUG_OFF
  if (item)
    item->m_sp= lex->sphead;
#endif

  return item;
}

/**
  Helper to resolve the SQL:2003 Syntax exception 1) in <in predicate>.
  See SQL:2003, Part 2, section 8.4 <in predicate>, Note 184, page 383.
  This function returns the proper item for the SQL expression
  <code>left [NOT] IN ( expr )</code>
  @param thd the current thread
  @param left the in predicand
  @param equal true for IN predicates, false for NOT IN predicates
  @param expr first and only expression of the in value list
  @return an expression representing the IN predicate.
*/
Item* handle_sql2003_note184_exception(THD *thd, Item* left, bool equal,
                                       Item *expr)
{
  /*
    Relevant references for this issue:
    - SQL:2003, Part 2, section 8.4 <in predicate>, page 383,
    - SQL:2003, Part 2, section 7.2 <row value expression>, page 296,
    - SQL:2003, Part 2, section 6.3 <value expression primary>, page 174,
    - SQL:2003, Part 2, section 7.15 <subquery>, page 370,
    - SQL:2003 Feature F561, "Full value expressions".

    The exception in SQL:2003 Note 184 means:
    Item_singlerow_subselect, which corresponds to a <scalar subquery>,
    should be re-interpreted as an Item_in_subselect, which corresponds
    to a <table subquery> when used inside an <in predicate>.

    Our reading of Note 184 is reccursive, so that all:
    - IN (( <subquery> ))
    - IN ((( <subquery> )))
    - IN '('^N <subquery> ')'^N
    - etc
    should be interpreted as a <table subquery>, no matter how deep in the
    expression the <subquery> is.
  */

  Item *result;

  DBUG_ENTER("handle_sql2003_note184_exception");

  if (expr->type() == Item::SUBSELECT_ITEM)
  {
    Item_subselect *expr2 = (Item_subselect*) expr;

    if (expr2->substype() == Item_subselect::SINGLEROW_SUBS)
    {
      Item_singlerow_subselect *expr3 = (Item_singlerow_subselect*) expr2;
      st_select_lex *subselect;

      /*
        Implement the mandated change, by altering the semantic tree:
          left IN Item_singlerow_subselect(subselect)
        is modified to
          left IN (subselect)
        which is represented as
          Item_in_subselect(left, subselect)
      */
      subselect= expr3->invalidate_and_restore_select_lex();
      result= new (thd->mem_root) Item_in_subselect(left, subselect);

      if (! equal)
        result = negate_expression(thd, result);

      DBUG_RETURN(result);
    }
  }

  if (equal)
    result= new (thd->mem_root) Item_func_eq(left, expr);
  else
    result= new (thd->mem_root) Item_func_ne(left, expr);

  DBUG_RETURN(result);
}

/**
   @brief Creates a new SELECT_LEX for a UNION branch.

   Sets up and initializes a SELECT_LEX structure for a query once the parser
   discovers a UNION token. The current SELECT_LEX is pushed on the stack and
   the new SELECT_LEX becomes the current one.

   @param lex The parser state.

   @param is_union_distinct True if the union preceding the new select statement
   uses UNION DISTINCT.

   @param is_top_level This should be @c TRUE if the newly created SELECT_LEX
   is a non-nested statement.

   @return <code>false</code> if successful, <code>true</code> if an error was
   reported. In the latter case parsing should stop.
 */
bool add_select_to_union_list(LEX *lex, bool is_union_distinct, 
                              bool is_top_level)
{
  /* 
     Only the last SELECT can have INTO. Since the grammar won't allow INTO in
     a nested SELECT, we make this check only when creating a top-level SELECT.
  */
  if (is_top_level && lex->result)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "UNION", "INTO");
    return TRUE;
  }
  if (lex->current_select->linkage == GLOBAL_OPTIONS_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  /* This counter shouldn't be incremented for UNION parts */
  lex->nest_level--;
  if (mysql_new_select(lex, 0))
    return TRUE;
  mysql_init_select(lex);
  lex->current_select->linkage=UNION_TYPE;
  if (is_union_distinct) /* UNION DISTINCT - remember position */
    lex->current_select->master_unit()->union_distinct=
      lex->current_select;
  return FALSE;
}

/**
   @brief Initializes a SELECT_LEX for a query within parentheses (aka
   braces).

   @return false if successful, true if an error was reported. In the latter
   case parsing should stop.
 */
bool setup_select_in_parentheses(LEX *lex) 
{
  SELECT_LEX * sel= lex->current_select;
  if (sel->set_braces(1))
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      !sel->master_unit()->first_select()->braces &&
      sel->master_unit()->first_select()->linkage ==
      UNION_TYPE)
  {
    my_parse_error(ER(ER_SYNTAX_ERROR));
    return TRUE;
  }
  if (sel->linkage == UNION_TYPE &&
      sel->olap != UNSPECIFIED_OLAP_TYPE &&
      sel->master_unit()->fake_select_lex)
  {
    my_error(ER_WRONG_USAGE, MYF(0), "CUBE/ROLLUP", "ORDER BY");
    return TRUE;
  }
  /* select in braces, can't contain global parameters */
  if (sel->master_unit()->fake_select_lex)
    sel->master_unit()->global_parameters=
      sel->master_unit()->fake_select_lex;
  return FALSE;
}

static bool add_create_index_prepare (LEX *lex, Table_ident *table)
{
  lex->sql_command= SQLCOM_CREATE_INDEX;
  if (!lex->current_select->add_table_to_list(lex->thd, table, NULL,
                                              TL_OPTION_UPDATING,
                                              TL_READ_NO_INSERT,
                                              MDL_SHARED_UPGRADABLE))
    return TRUE;
  lex->alter_info.reset();
  lex->alter_info.flags= Alter_info::ALTER_ADD_INDEX;
  lex->col_list.empty();
  lex->change= NullS;
  lex->option_list= NULL;
  return FALSE;
}

static bool add_create_index (LEX *lex, Key::Keytype type,
                              const LEX_STRING &name,
                              KEY_CREATE_INFO *info= NULL, bool generated= 0)
{
  Key *key;
  key= new Key(type, name, info ? info : &lex->key_create_info, generated, 
               lex->col_list, lex->option_list, lex->check_exists);
  if (key == NULL)
    return TRUE;

  lex->alter_info.key_list.push_back(key);
  lex->col_list.empty();
  return FALSE;
}


/**
  Create a separate LEX for each assignment if in SP.

  If we are in SP we want have own LEX for each assignment.
  This is mostly because it is hard for several sp_instr_set
  and sp_instr_set_trigger instructions share one LEX.
  (Well, it is theoretically possible but adds some extra
  overhead on preparation for execution stage and IMO less
  robust).

  QQ: May be we should simply prohibit group assignments in SP?

  @see sp_create_assignment_instr

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead
*/

static void sp_create_assignment_lex(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    Lex_input_stream *lip= &thd->m_parser_state->m_lip;
    LEX *old_lex= lex;
    lex->sphead->reset_lex(thd);
    lex= thd->lex;

    /* Set new LEX as if we at start of set rule. */
    lex->sql_command= SQLCOM_SET_OPTION;
    mysql_init_select(lex);
    lex->var_list.empty();
    lex->autocommit= 0;
    /* get_ptr() is only correct with no lookahead. */
    DBUG_ASSERT(no_lookahead);
    lex->sphead->m_tmp_query= lip->get_ptr();
    /* Inherit from outer lex. */
    lex->option_type= old_lex->option_type;
  }
}


/**
  Create a SP instruction for a SET assignment.

  @see sp_create_assignment_lex

  @param thd           Thread context
  @param no_lookahead  True if the parser has no lookahead

  @return false if success, true otherwise.
*/

static bool sp_create_assignment_instr(THD *thd, bool no_lookahead)
{
  LEX *lex= thd->lex;

  if (lex->sphead)
  {
    sp_head *sp= lex->sphead;

    if (!lex->var_list.is_empty())
    {
      /*
        We have assignment to user or system variable or
        option setting, so we should construct sp_instr_stmt
        for it.
      */
      LEX_STRING qbuff;
      sp_instr_stmt *i;
      Lex_input_stream *lip= &thd->m_parser_state->m_lip;

      if (!(i= new sp_instr_stmt(sp->instructions(), lex->spcont,
                                 lex)))
        return true;

      /*
        Extract the query statement from the tokenizer.  The
        end is either lip->ptr, if there was no lookahead,
        lip->tok_end otherwise.
      */
      if (no_lookahead)
        qbuff.length= lip->get_ptr() - sp->m_tmp_query;
      else
        qbuff.length= lip->get_tok_end() - sp->m_tmp_query;

      if (!(qbuff.str= (char*) alloc_root(thd->mem_root,
                                          qbuff.length + 5)))
        return true;

      strmake(strmake(qbuff.str, "SET ", 4), sp->m_tmp_query,
              qbuff.length);
      qbuff.length+= 4;
      i->m_query= qbuff;
      if (sp->add_instr(i))
        return true;
    }
    enum_var_type inner_option_type= lex->option_type;
    if (lex->sphead->restore_lex(thd))
      return true;
    /* Copy option_type to outer lex in case it has changed. */
    thd->lex->option_type= inner_option_type;
  }
  return false;
}




/* Line 189 of yacc.c  */
#line 956 "/home/buildbot/git/mkdist/sql/sql_yacc.cc"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT_SYM = 258,
     ACCESSIBLE_SYM = 259,
     ACTION = 260,
     ADD = 261,
     ADMIN_SYM = 262,
     ADDDATE_SYM = 263,
     AFTER_SYM = 264,
     AGAINST = 265,
     AGGREGATE_SYM = 266,
     ALGORITHM_SYM = 267,
     ALL = 268,
     ALTER = 269,
     ALWAYS_SYM = 270,
     ANALYZE_SYM = 271,
     AND_AND_SYM = 272,
     AND_SYM = 273,
     ANY_SYM = 274,
     AS = 275,
     ASC = 276,
     ASCII_SYM = 277,
     ASENSITIVE_SYM = 278,
     AT_SYM = 279,
     AUTHORS_SYM = 280,
     AUTOEXTEND_SIZE_SYM = 281,
     AUTO_INC = 282,
     AUTO_SYM = 283,
     AVG_ROW_LENGTH = 284,
     AVG_SYM = 285,
     BACKUP_SYM = 286,
     BEFORE_SYM = 287,
     BEGIN_SYM = 288,
     BETWEEN_SYM = 289,
     BIGINT = 290,
     BINARY = 291,
     BINLOG_SYM = 292,
     BIN_NUM = 293,
     BIT_AND = 294,
     BIT_OR = 295,
     BIT_SYM = 296,
     BIT_XOR = 297,
     BLOB_SYM = 298,
     BLOCK_SYM = 299,
     BOOLEAN_SYM = 300,
     BOOL_SYM = 301,
     BOTH = 302,
     BTREE_SYM = 303,
     BY = 304,
     BYTE_SYM = 305,
     CACHE_SYM = 306,
     CALL_SYM = 307,
     CASCADE = 308,
     CASCADED = 309,
     CASE_SYM = 310,
     CAST_SYM = 311,
     CATALOG_NAME_SYM = 312,
     CHAIN_SYM = 313,
     CHANGE = 314,
     CHANGED = 315,
     CHARSET = 316,
     CHAR_SYM = 317,
     CHECKPOINT_SYM = 318,
     CHECKSUM_SYM = 319,
     CHECK_SYM = 320,
     CIPHER_SYM = 321,
     CLASS_ORIGIN_SYM = 322,
     CLIENT_SYM = 323,
     CLIENT_STATS_SYM = 324,
     CLOSE_SYM = 325,
     COALESCE = 326,
     CODE_SYM = 327,
     COLLATE_SYM = 328,
     COLLATION_SYM = 329,
     COLUMNS = 330,
     COLUMN_ADD_SYM = 331,
     COLUMN_CHECK_SYM = 332,
     COLUMN_CREATE_SYM = 333,
     COLUMN_DELETE_SYM = 334,
     COLUMN_GET_SYM = 335,
     COLUMN_SYM = 336,
     COLUMN_NAME_SYM = 337,
     COMMENT_SYM = 338,
     COMMITTED_SYM = 339,
     COMMIT_SYM = 340,
     COMPACT_SYM = 341,
     COMPLETION_SYM = 342,
     COMPRESSED_SYM = 343,
     CONCURRENT = 344,
     CONDITION_SYM = 345,
     CONNECTION_SYM = 346,
     CONSISTENT_SYM = 347,
     CONSTRAINT = 348,
     CONSTRAINT_CATALOG_SYM = 349,
     CONSTRAINT_NAME_SYM = 350,
     CONSTRAINT_SCHEMA_SYM = 351,
     CONTAINS_SYM = 352,
     CONTEXT_SYM = 353,
     CONTINUE_SYM = 354,
     CONTRIBUTORS_SYM = 355,
     CONVERT_SYM = 356,
     COUNT_SYM = 357,
     CPU_SYM = 358,
     CREATE = 359,
     CROSS = 360,
     CUBE_SYM = 361,
     CURDATE = 362,
     CURRENT_SYM = 363,
     CURRENT_USER = 364,
     CURRENT_ROLE = 365,
     CURRENT_POS_SYM = 366,
     CURSOR_SYM = 367,
     CURSOR_NAME_SYM = 368,
     CURTIME = 369,
     DATABASE = 370,
     DATABASES = 371,
     DATAFILE_SYM = 372,
     DATA_SYM = 373,
     DATETIME = 374,
     DATE_ADD_INTERVAL = 375,
     DATE_SUB_INTERVAL = 376,
     DATE_SYM = 377,
     DAY_HOUR_SYM = 378,
     DAY_MICROSECOND_SYM = 379,
     DAY_MINUTE_SYM = 380,
     DAY_SECOND_SYM = 381,
     DAY_SYM = 382,
     DEALLOCATE_SYM = 383,
     DECIMAL_NUM = 384,
     DECIMAL_SYM = 385,
     DECLARE_SYM = 386,
     DEFAULT = 387,
     DEFINER_SYM = 388,
     DELAYED_SYM = 389,
     DELAY_KEY_WRITE_SYM = 390,
     DELETE_SYM = 391,
     DESC = 392,
     DESCRIBE = 393,
     DES_KEY_FILE = 394,
     DETERMINISTIC_SYM = 395,
     DIAGNOSTICS_SYM = 396,
     DIRECTORY_SYM = 397,
     DISABLE_SYM = 398,
     DISCARD = 399,
     DISK_SYM = 400,
     DISTINCT = 401,
     DIV_SYM = 402,
     DOUBLE_SYM = 403,
     DO_SYM = 404,
     DROP = 405,
     DUAL_SYM = 406,
     DUMPFILE = 407,
     DUPLICATE_SYM = 408,
     DYNAMIC_SYM = 409,
     EACH_SYM = 410,
     ELSE = 411,
     ELSEIF_SYM = 412,
     ENABLE_SYM = 413,
     ENCLOSED = 414,
     END = 415,
     ENDS_SYM = 416,
     END_OF_INPUT = 417,
     ENGINES_SYM = 418,
     ENGINE_SYM = 419,
     ENUM = 420,
     EQ = 421,
     EQUAL_SYM = 422,
     ERROR_SYM = 423,
     ERRORS = 424,
     ESCAPED = 425,
     ESCAPE_SYM = 426,
     EVENTS_SYM = 427,
     EVENT_SYM = 428,
     EVERY_SYM = 429,
     EXCHANGE_SYM = 430,
     EXAMINED_SYM = 431,
     EXECUTE_SYM = 432,
     EXISTS = 433,
     EXIT_SYM = 434,
     EXPANSION_SYM = 435,
     EXPORT_SYM = 436,
     EXTENDED_SYM = 437,
     EXTENT_SIZE_SYM = 438,
     EXTRACT_SYM = 439,
     FALSE_SYM = 440,
     FAST_SYM = 441,
     FAULTS_SYM = 442,
     FETCH_SYM = 443,
     FILE_SYM = 444,
     FIRST_SYM = 445,
     FIXED_SYM = 446,
     FLOAT_NUM = 447,
     FLOAT_SYM = 448,
     FLUSH_SYM = 449,
     FORCE_SYM = 450,
     FOREIGN = 451,
     FOR_SYM = 452,
     FOUND_SYM = 453,
     FROM = 454,
     FULL = 455,
     FULLTEXT_SYM = 456,
     FUNCTION_SYM = 457,
     GE = 458,
     GENERAL = 459,
     GENERATED_SYM = 460,
     GEOMETRYCOLLECTION = 461,
     GEOMETRY_SYM = 462,
     GET_FORMAT = 463,
     GET_SYM = 464,
     GLOBAL_SYM = 465,
     GRANT = 466,
     GRANTS = 467,
     GROUP_SYM = 468,
     GROUP_CONCAT_SYM = 469,
     GT_SYM = 470,
     HANDLER_SYM = 471,
     HARD_SYM = 472,
     HASH_SYM = 473,
     HAVING = 474,
     HELP_SYM = 475,
     HEX_NUM = 476,
     HEX_STRING = 477,
     HIGH_PRIORITY = 478,
     HOST_SYM = 479,
     HOSTS_SYM = 480,
     HOUR_MICROSECOND_SYM = 481,
     HOUR_MINUTE_SYM = 482,
     HOUR_SECOND_SYM = 483,
     HOUR_SYM = 484,
     ID_SYM = 485,
     IDENT = 486,
     IDENTIFIED_SYM = 487,
     IDENT_QUOTED = 488,
     IF = 489,
     IGNORE_SYM = 490,
     IGNORE_SERVER_IDS_SYM = 491,
     IMPORT = 492,
     INDEXES = 493,
     INDEX_SYM = 494,
     INDEX_STATS_SYM = 495,
     INFILE = 496,
     INITIAL_SIZE_SYM = 497,
     INNER_SYM = 498,
     INOUT_SYM = 499,
     INSENSITIVE_SYM = 500,
     INSERT = 501,
     INSERT_METHOD = 502,
     INSTALL_SYM = 503,
     INTERVAL_SYM = 504,
     INTO = 505,
     INT_SYM = 506,
     INVOKER_SYM = 507,
     IN_SYM = 508,
     IO_SYM = 509,
     IPC_SYM = 510,
     IS = 511,
     ISOLATION = 512,
     ISSUER_SYM = 513,
     ITERATE_SYM = 514,
     JOIN_SYM = 515,
     KEYS = 516,
     KEY_BLOCK_SIZE = 517,
     KEY_SYM = 518,
     KILL_SYM = 519,
     LANGUAGE_SYM = 520,
     LAST_SYM = 521,
     LAST_VALUE = 522,
     LE = 523,
     LEADING = 524,
     LEAVES = 525,
     LEAVE_SYM = 526,
     LEFT = 527,
     LESS_SYM = 528,
     LEVEL_SYM = 529,
     LEX_HOSTNAME = 530,
     LIKE = 531,
     LIMIT = 532,
     LINEAR_SYM = 533,
     LINES = 534,
     LINESTRING = 535,
     LIST_SYM = 536,
     LOAD = 537,
     LOCAL_SYM = 538,
     LOCATOR_SYM = 539,
     LOCKS_SYM = 540,
     LOCK_SYM = 541,
     LOGFILE_SYM = 542,
     LOGS_SYM = 543,
     LONGBLOB = 544,
     LONGTEXT = 545,
     LONG_NUM = 546,
     LONG_SYM = 547,
     LOOP_SYM = 548,
     LOW_PRIORITY = 549,
     LT = 550,
     MASTER_CONNECT_RETRY_SYM = 551,
     MASTER_GTID_POS_SYM = 552,
     MASTER_HOST_SYM = 553,
     MASTER_LOG_FILE_SYM = 554,
     MASTER_LOG_POS_SYM = 555,
     MASTER_PASSWORD_SYM = 556,
     MASTER_PORT_SYM = 557,
     MASTER_SERVER_ID_SYM = 558,
     MASTER_SSL_CAPATH_SYM = 559,
     MASTER_SSL_CA_SYM = 560,
     MASTER_SSL_CERT_SYM = 561,
     MASTER_SSL_CIPHER_SYM = 562,
     MASTER_SSL_CRL_SYM = 563,
     MASTER_SSL_CRLPATH_SYM = 564,
     MASTER_SSL_KEY_SYM = 565,
     MASTER_SSL_SYM = 566,
     MASTER_SSL_VERIFY_SERVER_CERT_SYM = 567,
     MASTER_SYM = 568,
     MASTER_USER_SYM = 569,
     MASTER_USE_GTID_SYM = 570,
     MASTER_HEARTBEAT_PERIOD_SYM = 571,
     MATCH = 572,
     MAX_CONNECTIONS_PER_HOUR = 573,
     MAX_QUERIES_PER_HOUR = 574,
     MAX_ROWS = 575,
     MAX_SIZE_SYM = 576,
     MAX_SYM = 577,
     MAX_UPDATES_PER_HOUR = 578,
     MAX_USER_CONNECTIONS_SYM = 579,
     MAX_VALUE_SYM = 580,
     MEDIUMBLOB = 581,
     MEDIUMINT = 582,
     MEDIUMTEXT = 583,
     MEDIUM_SYM = 584,
     MEMORY_SYM = 585,
     MERGE_SYM = 586,
     MESSAGE_TEXT_SYM = 587,
     MICROSECOND_SYM = 588,
     MIGRATE_SYM = 589,
     MINUTE_MICROSECOND_SYM = 590,
     MINUTE_SECOND_SYM = 591,
     MINUTE_SYM = 592,
     MIN_ROWS = 593,
     MIN_SYM = 594,
     MODE_SYM = 595,
     MODIFIES_SYM = 596,
     MODIFY_SYM = 597,
     MOD_SYM = 598,
     MONTH_SYM = 599,
     MULTILINESTRING = 600,
     MULTIPOINT = 601,
     MULTIPOLYGON = 602,
     MUTEX_SYM = 603,
     MYSQL_SYM = 604,
     MYSQL_ERRNO_SYM = 605,
     NAMES_SYM = 606,
     NAME_SYM = 607,
     NATIONAL_SYM = 608,
     NATURAL = 609,
     NCHAR_STRING = 610,
     NCHAR_SYM = 611,
     NDBCLUSTER_SYM = 612,
     NE = 613,
     NEG = 614,
     NEW_SYM = 615,
     NEXT_SYM = 616,
     NODEGROUP_SYM = 617,
     NONE_SYM = 618,
     NOT2_SYM = 619,
     NOT_SYM = 620,
     NOW_SYM = 621,
     NO_SYM = 622,
     NO_WAIT_SYM = 623,
     NO_WRITE_TO_BINLOG = 624,
     NULL_SYM = 625,
     NUM = 626,
     NUMBER_SYM = 627,
     NUMERIC_SYM = 628,
     NVARCHAR_SYM = 629,
     OFFSET_SYM = 630,
     OLD_PASSWORD = 631,
     ON = 632,
     ONE_SYM = 633,
     ONLY_SYM = 634,
     ONLINE_SYM = 635,
     OPEN_SYM = 636,
     OPTIMIZE = 637,
     OPTIONS_SYM = 638,
     OPTION = 639,
     OPTIONALLY = 640,
     OR2_SYM = 641,
     ORDER_SYM = 642,
     OR_OR_SYM = 643,
     OR_SYM = 644,
     OUTER = 645,
     OUTFILE = 646,
     OUT_SYM = 647,
     OWNER_SYM = 648,
     PACK_KEYS_SYM = 649,
     PAGE_SYM = 650,
     PAGE_CHECKSUM_SYM = 651,
     PARAM_MARKER = 652,
     PARSER_SYM = 653,
     PARSE_VCOL_EXPR_SYM = 654,
     PARTIAL = 655,
     PARTITION_SYM = 656,
     PARTITIONS_SYM = 657,
     PARTITIONING_SYM = 658,
     PASSWORD = 659,
     PERSISTENT_SYM = 660,
     PHASE_SYM = 661,
     PLUGINS_SYM = 662,
     PLUGIN_SYM = 663,
     POINT_SYM = 664,
     POLYGON = 665,
     PORT_SYM = 666,
     POSITION_SYM = 667,
     PRECISION = 668,
     PREPARE_SYM = 669,
     PRESERVE_SYM = 670,
     PREV_SYM = 671,
     PRIMARY_SYM = 672,
     PRIVILEGES = 673,
     PROCEDURE_SYM = 674,
     PROCESS = 675,
     PROCESSLIST_SYM = 676,
     PROFILE_SYM = 677,
     PROFILES_SYM = 678,
     PROXY_SYM = 679,
     PURGE = 680,
     QUARTER_SYM = 681,
     QUERY_SYM = 682,
     QUICK = 683,
     RANGE_SYM = 684,
     READS_SYM = 685,
     READ_ONLY_SYM = 686,
     READ_SYM = 687,
     READ_WRITE_SYM = 688,
     REAL = 689,
     REBUILD_SYM = 690,
     RECOVER_SYM = 691,
     REDOFILE_SYM = 692,
     REDO_BUFFER_SIZE_SYM = 693,
     REDUNDANT_SYM = 694,
     REFERENCES = 695,
     REGEXP = 696,
     RELAY = 697,
     RELAYLOG_SYM = 698,
     RELAY_LOG_FILE_SYM = 699,
     RELAY_LOG_POS_SYM = 700,
     RELAY_THREAD = 701,
     RELEASE_SYM = 702,
     RELOAD = 703,
     REMOVE_SYM = 704,
     RENAME = 705,
     REORGANIZE_SYM = 706,
     REPAIR = 707,
     REPEATABLE_SYM = 708,
     REPEAT_SYM = 709,
     REPLACE = 710,
     REPLICATION = 711,
     REQUIRE_SYM = 712,
     RESET_SYM = 713,
     RESIGNAL_SYM = 714,
     RESOURCES = 715,
     RESTORE_SYM = 716,
     RESTRICT = 717,
     RESUME_SYM = 718,
     RETURNED_SQLSTATE_SYM = 719,
     RETURNING_SYM = 720,
     RETURNS_SYM = 721,
     RETURN_SYM = 722,
     REVERSE_SYM = 723,
     REVOKE = 724,
     RIGHT = 725,
     ROLE_SYM = 726,
     ROLLBACK_SYM = 727,
     ROLLUP_SYM = 728,
     ROUTINE_SYM = 729,
     ROWS_SYM = 730,
     ROW_FORMAT_SYM = 731,
     ROW_SYM = 732,
     ROW_COUNT_SYM = 733,
     RTREE_SYM = 734,
     SAVEPOINT_SYM = 735,
     SCHEDULE_SYM = 736,
     SCHEMA_NAME_SYM = 737,
     SECOND_MICROSECOND_SYM = 738,
     SECOND_SYM = 739,
     SECURITY_SYM = 740,
     SELECT_SYM = 741,
     SENSITIVE_SYM = 742,
     SEPARATOR_SYM = 743,
     SERIALIZABLE_SYM = 744,
     SERIAL_SYM = 745,
     SESSION_SYM = 746,
     SERVER_SYM = 747,
     SERVER_OPTIONS = 748,
     SET = 749,
     SET_VAR = 750,
     SHARE_SYM = 751,
     SHIFT_LEFT = 752,
     SHIFT_RIGHT = 753,
     SHOW = 754,
     SHUTDOWN = 755,
     SIGNAL_SYM = 756,
     SIGNED_SYM = 757,
     SIMPLE_SYM = 758,
     SLAVE = 759,
     SLAVES = 760,
     SLAVE_POS_SYM = 761,
     SLOW = 762,
     SMALLINT = 763,
     SNAPSHOT_SYM = 764,
     SOCKET_SYM = 765,
     SOFT_SYM = 766,
     SONAME_SYM = 767,
     SOUNDS_SYM = 768,
     SOURCE_SYM = 769,
     SPATIAL_SYM = 770,
     SPECIFIC_SYM = 771,
     SQLEXCEPTION_SYM = 772,
     SQLSTATE_SYM = 773,
     SQLWARNING_SYM = 774,
     SQL_BIG_RESULT = 775,
     SQL_BUFFER_RESULT = 776,
     SQL_CACHE_SYM = 777,
     SQL_CALC_FOUND_ROWS = 778,
     SQL_NO_CACHE_SYM = 779,
     SQL_SMALL_RESULT = 780,
     SQL_SYM = 781,
     SQL_THREAD = 782,
     SSL_SYM = 783,
     STARTING = 784,
     STARTS_SYM = 785,
     START_SYM = 786,
     STATS_AUTO_RECALC_SYM = 787,
     STATS_PERSISTENT_SYM = 788,
     STATS_SAMPLE_PAGES_SYM = 789,
     STATUS_SYM = 790,
     STDDEV_SAMP_SYM = 791,
     STD_SYM = 792,
     STOP_SYM = 793,
     STORAGE_SYM = 794,
     STRAIGHT_JOIN = 795,
     STRING_SYM = 796,
     SUBCLASS_ORIGIN_SYM = 797,
     SUBDATE_SYM = 798,
     SUBJECT_SYM = 799,
     SUBPARTITIONS_SYM = 800,
     SUBPARTITION_SYM = 801,
     SUBSTRING = 802,
     SUM_SYM = 803,
     SUPER_SYM = 804,
     SUSPEND_SYM = 805,
     SWAPS_SYM = 806,
     SWITCHES_SYM = 807,
     SYSDATE = 808,
     TABLES = 809,
     TABLESPACE = 810,
     TABLE_REF_PRIORITY = 811,
     TABLE_STATS_SYM = 812,
     TABLE_SYM = 813,
     TABLE_CHECKSUM_SYM = 814,
     TABLE_NAME_SYM = 815,
     TEMPORARY = 816,
     TEMPTABLE_SYM = 817,
     TERMINATED = 818,
     TEXT_STRING = 819,
     TEXT_SYM = 820,
     THAN_SYM = 821,
     THEN_SYM = 822,
     TIMESTAMP = 823,
     TIMESTAMP_ADD = 824,
     TIMESTAMP_DIFF = 825,
     TIME_SYM = 826,
     TINYBLOB = 827,
     TINYINT = 828,
     TINYTEXT = 829,
     TO_SYM = 830,
     TRAILING = 831,
     TRANSACTION_SYM = 832,
     TRANSACTIONAL_SYM = 833,
     TRIGGERS_SYM = 834,
     TRIGGER_SYM = 835,
     TRIM = 836,
     TRUE_SYM = 837,
     TRUNCATE_SYM = 838,
     TYPES_SYM = 839,
     TYPE_SYM = 840,
     UDF_RETURNS_SYM = 841,
     ULONGLONG_NUM = 842,
     UNCOMMITTED_SYM = 843,
     UNDEFINED_SYM = 844,
     UNDERSCORE_CHARSET = 845,
     UNDOFILE_SYM = 846,
     UNDO_BUFFER_SIZE_SYM = 847,
     UNDO_SYM = 848,
     UNICODE_SYM = 849,
     UNINSTALL_SYM = 850,
     UNION_SYM = 851,
     UNIQUE_SYM = 852,
     UNKNOWN_SYM = 853,
     UNLOCK_SYM = 854,
     UNSIGNED = 855,
     UNTIL_SYM = 856,
     UPDATE_SYM = 857,
     UPGRADE_SYM = 858,
     USAGE = 859,
     USER = 860,
     USER_STATS_SYM = 861,
     USE_FRM = 862,
     USE_SYM = 863,
     USING = 864,
     UTC_DATE_SYM = 865,
     UTC_TIMESTAMP_SYM = 866,
     UTC_TIME_SYM = 867,
     VALUES = 868,
     VALUE_SYM = 869,
     VARBINARY = 870,
     VARCHAR = 871,
     VARIABLES = 872,
     VARIANCE_SYM = 873,
     VARYING = 874,
     VAR_SAMP_SYM = 875,
     VIA_SYM = 876,
     VIEW_SYM = 877,
     VIRTUAL_SYM = 878,
     WAIT_SYM = 879,
     WARNINGS = 880,
     WEEK_SYM = 881,
     WEIGHT_STRING_SYM = 882,
     WHEN_SYM = 883,
     WHERE = 884,
     WHILE_SYM = 885,
     WITH = 886,
     WITH_CUBE_SYM = 887,
     WITH_ROLLUP_SYM = 888,
     WORK_SYM = 889,
     WRAPPER_SYM = 890,
     WRITE_SYM = 891,
     X509_SYM = 892,
     XA_SYM = 893,
     XML_SYM = 894,
     XOR = 895,
     YEAR_MONTH_SYM = 896,
     YEAR_SYM = 897,
     ZEROFILL = 898,
     IMPOSSIBLE_ACTION = 899
   };
#endif
/* Tokens.  */
#define ABORT_SYM 258
#define ACCESSIBLE_SYM 259
#define ACTION 260
#define ADD 261
#define ADMIN_SYM 262
#define ADDDATE_SYM 263
#define AFTER_SYM 264
#define AGAINST 265
#define AGGREGATE_SYM 266
#define ALGORITHM_SYM 267
#define ALL 268
#define ALTER 269
#define ALWAYS_SYM 270
#define ANALYZE_SYM 271
#define AND_AND_SYM 272
#define AND_SYM 273
#define ANY_SYM 274
#define AS 275
#define ASC 276
#define ASCII_SYM 277
#define ASENSITIVE_SYM 278
#define AT_SYM 279
#define AUTHORS_SYM 280
#define AUTOEXTEND_SIZE_SYM 281
#define AUTO_INC 282
#define AUTO_SYM 283
#define AVG_ROW_LENGTH 284
#define AVG_SYM 285
#define BACKUP_SYM 286
#define BEFORE_SYM 287
#define BEGIN_SYM 288
#define BETWEEN_SYM 289
#define BIGINT 290
#define BINARY 291
#define BINLOG_SYM 292
#define BIN_NUM 293
#define BIT_AND 294
#define BIT_OR 295
#define BIT_SYM 296
#define BIT_XOR 297
#define BLOB_SYM 298
#define BLOCK_SYM 299
#define BOOLEAN_SYM 300
#define BOOL_SYM 301
#define BOTH 302
#define BTREE_SYM 303
#define BY 304
#define BYTE_SYM 305
#define CACHE_SYM 306
#define CALL_SYM 307
#define CASCADE 308
#define CASCADED 309
#define CASE_SYM 310
#define CAST_SYM 311
#define CATALOG_NAME_SYM 312
#define CHAIN_SYM 313
#define CHANGE 314
#define CHANGED 315
#define CHARSET 316
#define CHAR_SYM 317
#define CHECKPOINT_SYM 318
#define CHECKSUM_SYM 319
#define CHECK_SYM 320
#define CIPHER_SYM 321
#define CLASS_ORIGIN_SYM 322
#define CLIENT_SYM 323
#define CLIENT_STATS_SYM 324
#define CLOSE_SYM 325
#define COALESCE 326
#define CODE_SYM 327
#define COLLATE_SYM 328
#define COLLATION_SYM 329
#define COLUMNS 330
#define COLUMN_ADD_SYM 331
#define COLUMN_CHECK_SYM 332
#define COLUMN_CREATE_SYM 333
#define COLUMN_DELETE_SYM 334
#define COLUMN_GET_SYM 335
#define COLUMN_SYM 336
#define COLUMN_NAME_SYM 337
#define COMMENT_SYM 338
#define COMMITTED_SYM 339
#define COMMIT_SYM 340
#define COMPACT_SYM 341
#define COMPLETION_SYM 342
#define COMPRESSED_SYM 343
#define CONCURRENT 344
#define CONDITION_SYM 345
#define CONNECTION_SYM 346
#define CONSISTENT_SYM 347
#define CONSTRAINT 348
#define CONSTRAINT_CATALOG_SYM 349
#define CONSTRAINT_NAME_SYM 350
#define CONSTRAINT_SCHEMA_SYM 351
#define CONTAINS_SYM 352
#define CONTEXT_SYM 353
#define CONTINUE_SYM 354
#define CONTRIBUTORS_SYM 355
#define CONVERT_SYM 356
#define COUNT_SYM 357
#define CPU_SYM 358
#define CREATE 359
#define CROSS 360
#define CUBE_SYM 361
#define CURDATE 362
#define CURRENT_SYM 363
#define CURRENT_USER 364
#define CURRENT_ROLE 365
#define CURRENT_POS_SYM 366
#define CURSOR_SYM 367
#define CURSOR_NAME_SYM 368
#define CURTIME 369
#define DATABASE 370
#define DATABASES 371
#define DATAFILE_SYM 372
#define DATA_SYM 373
#define DATETIME 374
#define DATE_ADD_INTERVAL 375
#define DATE_SUB_INTERVAL 376
#define DATE_SYM 377
#define DAY_HOUR_SYM 378
#define DAY_MICROSECOND_SYM 379
#define DAY_MINUTE_SYM 380
#define DAY_SECOND_SYM 381
#define DAY_SYM 382
#define DEALLOCATE_SYM 383
#define DECIMAL_NUM 384
#define DECIMAL_SYM 385
#define DECLARE_SYM 386
#define DEFAULT 387
#define DEFINER_SYM 388
#define DELAYED_SYM 389
#define DELAY_KEY_WRITE_SYM 390
#define DELETE_SYM 391
#define DESC 392
#define DESCRIBE 393
#define DES_KEY_FILE 394
#define DETERMINISTIC_SYM 395
#define DIAGNOSTICS_SYM 396
#define DIRECTORY_SYM 397
#define DISABLE_SYM 398
#define DISCARD 399
#define DISK_SYM 400
#define DISTINCT 401
#define DIV_SYM 402
#define DOUBLE_SYM 403
#define DO_SYM 404
#define DROP 405
#define DUAL_SYM 406
#define DUMPFILE 407
#define DUPLICATE_SYM 408
#define DYNAMIC_SYM 409
#define EACH_SYM 410
#define ELSE 411
#define ELSEIF_SYM 412
#define ENABLE_SYM 413
#define ENCLOSED 414
#define END 415
#define ENDS_SYM 416
#define END_OF_INPUT 417
#define ENGINES_SYM 418
#define ENGINE_SYM 419
#define ENUM 420
#define EQ 421
#define EQUAL_SYM 422
#define ERROR_SYM 423
#define ERRORS 424
#define ESCAPED 425
#define ESCAPE_SYM 426
#define EVENTS_SYM 427
#define EVENT_SYM 428
#define EVERY_SYM 429
#define EXCHANGE_SYM 430
#define EXAMINED_SYM 431
#define EXECUTE_SYM 432
#define EXISTS 433
#define EXIT_SYM 434
#define EXPANSION_SYM 435
#define EXPORT_SYM 436
#define EXTENDED_SYM 437
#define EXTENT_SIZE_SYM 438
#define EXTRACT_SYM 439
#define FALSE_SYM 440
#define FAST_SYM 441
#define FAULTS_SYM 442
#define FETCH_SYM 443
#define FILE_SYM 444
#define FIRST_SYM 445
#define FIXED_SYM 446
#define FLOAT_NUM 447
#define FLOAT_SYM 448
#define FLUSH_SYM 449
#define FORCE_SYM 450
#define FOREIGN 451
#define FOR_SYM 452
#define FOUND_SYM 453
#define FROM 454
#define FULL 455
#define FULLTEXT_SYM 456
#define FUNCTION_SYM 457
#define GE 458
#define GENERAL 459
#define GENERATED_SYM 460
#define GEOMETRYCOLLECTION 461
#define GEOMETRY_SYM 462
#define GET_FORMAT 463
#define GET_SYM 464
#define GLOBAL_SYM 465
#define GRANT 466
#define GRANTS 467
#define GROUP_SYM 468
#define GROUP_CONCAT_SYM 469
#define GT_SYM 470
#define HANDLER_SYM 471
#define HARD_SYM 472
#define HASH_SYM 473
#define HAVING 474
#define HELP_SYM 475
#define HEX_NUM 476
#define HEX_STRING 477
#define HIGH_PRIORITY 478
#define HOST_SYM 479
#define HOSTS_SYM 480
#define HOUR_MICROSECOND_SYM 481
#define HOUR_MINUTE_SYM 482
#define HOUR_SECOND_SYM 483
#define HOUR_SYM 484
#define ID_SYM 485
#define IDENT 486
#define IDENTIFIED_SYM 487
#define IDENT_QUOTED 488
#define IF 489
#define IGNORE_SYM 490
#define IGNORE_SERVER_IDS_SYM 491
#define IMPORT 492
#define INDEXES 493
#define INDEX_SYM 494
#define INDEX_STATS_SYM 495
#define INFILE 496
#define INITIAL_SIZE_SYM 497
#define INNER_SYM 498
#define INOUT_SYM 499
#define INSENSITIVE_SYM 500
#define INSERT 501
#define INSERT_METHOD 502
#define INSTALL_SYM 503
#define INTERVAL_SYM 504
#define INTO 505
#define INT_SYM 506
#define INVOKER_SYM 507
#define IN_SYM 508
#define IO_SYM 509
#define IPC_SYM 510
#define IS 511
#define ISOLATION 512
#define ISSUER_SYM 513
#define ITERATE_SYM 514
#define JOIN_SYM 515
#define KEYS 516
#define KEY_BLOCK_SIZE 517
#define KEY_SYM 518
#define KILL_SYM 519
#define LANGUAGE_SYM 520
#define LAST_SYM 521
#define LAST_VALUE 522
#define LE 523
#define LEADING 524
#define LEAVES 525
#define LEAVE_SYM 526
#define LEFT 527
#define LESS_SYM 528
#define LEVEL_SYM 529
#define LEX_HOSTNAME 530
#define LIKE 531
#define LIMIT 532
#define LINEAR_SYM 533
#define LINES 534
#define LINESTRING 535
#define LIST_SYM 536
#define LOAD 537
#define LOCAL_SYM 538
#define LOCATOR_SYM 539
#define LOCKS_SYM 540
#define LOCK_SYM 541
#define LOGFILE_SYM 542
#define LOGS_SYM 543
#define LONGBLOB 544
#define LONGTEXT 545
#define LONG_NUM 546
#define LONG_SYM 547
#define LOOP_SYM 548
#define LOW_PRIORITY 549
#define LT 550
#define MASTER_CONNECT_RETRY_SYM 551
#define MASTER_GTID_POS_SYM 552
#define MASTER_HOST_SYM 553
#define MASTER_LOG_FILE_SYM 554
#define MASTER_LOG_POS_SYM 555
#define MASTER_PASSWORD_SYM 556
#define MASTER_PORT_SYM 557
#define MASTER_SERVER_ID_SYM 558
#define MASTER_SSL_CAPATH_SYM 559
#define MASTER_SSL_CA_SYM 560
#define MASTER_SSL_CERT_SYM 561
#define MASTER_SSL_CIPHER_SYM 562
#define MASTER_SSL_CRL_SYM 563
#define MASTER_SSL_CRLPATH_SYM 564
#define MASTER_SSL_KEY_SYM 565
#define MASTER_SSL_SYM 566
#define MASTER_SSL_VERIFY_SERVER_CERT_SYM 567
#define MASTER_SYM 568
#define MASTER_USER_SYM 569
#define MASTER_USE_GTID_SYM 570
#define MASTER_HEARTBEAT_PERIOD_SYM 571
#define MATCH 572
#define MAX_CONNECTIONS_PER_HOUR 573
#define MAX_QUERIES_PER_HOUR 574
#define MAX_ROWS 575
#define MAX_SIZE_SYM 576
#define MAX_SYM 577
#define MAX_UPDATES_PER_HOUR 578
#define MAX_USER_CONNECTIONS_SYM 579
#define MAX_VALUE_SYM 580
#define MEDIUMBLOB 581
#define MEDIUMINT 582
#define MEDIUMTEXT 583
#define MEDIUM_SYM 584
#define MEMORY_SYM 585
#define MERGE_SYM 586
#define MESSAGE_TEXT_SYM 587
#define MICROSECOND_SYM 588
#define MIGRATE_SYM 589
#define MINUTE_MICROSECOND_SYM 590
#define MINUTE_SECOND_SYM 591
#define MINUTE_SYM 592
#define MIN_ROWS 593
#define MIN_SYM 594
#define MODE_SYM 595
#define MODIFIES_SYM 596
#define MODIFY_SYM 597
#define MOD_SYM 598
#define MONTH_SYM 599
#define MULTILINESTRING 600
#define MULTIPOINT 601
#define MULTIPOLYGON 602
#define MUTEX_SYM 603
#define MYSQL_SYM 604
#define MYSQL_ERRNO_SYM 605
#define NAMES_SYM 606
#define NAME_SYM 607
#define NATIONAL_SYM 608
#define NATURAL 609
#define NCHAR_STRING 610
#define NCHAR_SYM 611
#define NDBCLUSTER_SYM 612
#define NE 613
#define NEG 614
#define NEW_SYM 615
#define NEXT_SYM 616
#define NODEGROUP_SYM 617
#define NONE_SYM 618
#define NOT2_SYM 619
#define NOT_SYM 620
#define NOW_SYM 621
#define NO_SYM 622
#define NO_WAIT_SYM 623
#define NO_WRITE_TO_BINLOG 624
#define NULL_SYM 625
#define NUM 626
#define NUMBER_SYM 627
#define NUMERIC_SYM 628
#define NVARCHAR_SYM 629
#define OFFSET_SYM 630
#define OLD_PASSWORD 631
#define ON 632
#define ONE_SYM 633
#define ONLY_SYM 634
#define ONLINE_SYM 635
#define OPEN_SYM 636
#define OPTIMIZE 637
#define OPTIONS_SYM 638
#define OPTION 639
#define OPTIONALLY 640
#define OR2_SYM 641
#define ORDER_SYM 642
#define OR_OR_SYM 643
#define OR_SYM 644
#define OUTER 645
#define OUTFILE 646
#define OUT_SYM 647
#define OWNER_SYM 648
#define PACK_KEYS_SYM 649
#define PAGE_SYM 650
#define PAGE_CHECKSUM_SYM 651
#define PARAM_MARKER 652
#define PARSER_SYM 653
#define PARSE_VCOL_EXPR_SYM 654
#define PARTIAL 655
#define PARTITION_SYM 656
#define PARTITIONS_SYM 657
#define PARTITIONING_SYM 658
#define PASSWORD 659
#define PERSISTENT_SYM 660
#define PHASE_SYM 661
#define PLUGINS_SYM 662
#define PLUGIN_SYM 663
#define POINT_SYM 664
#define POLYGON 665
#define PORT_SYM 666
#define POSITION_SYM 667
#define PRECISION 668
#define PREPARE_SYM 669
#define PRESERVE_SYM 670
#define PREV_SYM 671
#define PRIMARY_SYM 672
#define PRIVILEGES 673
#define PROCEDURE_SYM 674
#define PROCESS 675
#define PROCESSLIST_SYM 676
#define PROFILE_SYM 677
#define PROFILES_SYM 678
#define PROXY_SYM 679
#define PURGE 680
#define QUARTER_SYM 681
#define QUERY_SYM 682
#define QUICK 683
#define RANGE_SYM 684
#define READS_SYM 685
#define READ_ONLY_SYM 686
#define READ_SYM 687
#define READ_WRITE_SYM 688
#define REAL 689
#define REBUILD_SYM 690
#define RECOVER_SYM 691
#define REDOFILE_SYM 692
#define REDO_BUFFER_SIZE_SYM 693
#define REDUNDANT_SYM 694
#define REFERENCES 695
#define REGEXP 696
#define RELAY 697
#define RELAYLOG_SYM 698
#define RELAY_LOG_FILE_SYM 699
#define RELAY_LOG_POS_SYM 700
#define RELAY_THREAD 701
#define RELEASE_SYM 702
#define RELOAD 703
#define REMOVE_SYM 704
#define RENAME 705
#define REORGANIZE_SYM 706
#define REPAIR 707
#define REPEATABLE_SYM 708
#define REPEAT_SYM 709
#define REPLACE 710
#define REPLICATION 711
#define REQUIRE_SYM 712
#define RESET_SYM 713
#define RESIGNAL_SYM 714
#define RESOURCES 715
#define RESTORE_SYM 716
#define RESTRICT 717
#define RESUME_SYM 718
#define RETURNED_SQLSTATE_SYM 719
#define RETURNING_SYM 720
#define RETURNS_SYM 721
#define RETURN_SYM 722
#define REVERSE_SYM 723
#define REVOKE 724
#define RIGHT 725
#define ROLE_SYM 726
#define ROLLBACK_SYM 727
#define ROLLUP_SYM 728
#define ROUTINE_SYM 729
#define ROWS_SYM 730
#define ROW_FORMAT_SYM 731
#define ROW_SYM 732
#define ROW_COUNT_SYM 733
#define RTREE_SYM 734
#define SAVEPOINT_SYM 735
#define SCHEDULE_SYM 736
#define SCHEMA_NAME_SYM 737
#define SECOND_MICROSECOND_SYM 738
#define SECOND_SYM 739
#define SECURITY_SYM 740
#define SELECT_SYM 741
#define SENSITIVE_SYM 742
#define SEPARATOR_SYM 743
#define SERIALIZABLE_SYM 744
#define SERIAL_SYM 745
#define SESSION_SYM 746
#define SERVER_SYM 747
#define SERVER_OPTIONS 748
#define SET 749
#define SET_VAR 750
#define SHARE_SYM 751
#define SHIFT_LEFT 752
#define SHIFT_RIGHT 753
#define SHOW 754
#define SHUTDOWN 755
#define SIGNAL_SYM 756
#define SIGNED_SYM 757
#define SIMPLE_SYM 758
#define SLAVE 759
#define SLAVES 760
#define SLAVE_POS_SYM 761
#define SLOW 762
#define SMALLINT 763
#define SNAPSHOT_SYM 764
#define SOCKET_SYM 765
#define SOFT_SYM 766
#define SONAME_SYM 767
#define SOUNDS_SYM 768
#define SOURCE_SYM 769
#define SPATIAL_SYM 770
#define SPECIFIC_SYM 771
#define SQLEXCEPTION_SYM 772
#define SQLSTATE_SYM 773
#define SQLWARNING_SYM 774
#define SQL_BIG_RESULT 775
#define SQL_BUFFER_RESULT 776
#define SQL_CACHE_SYM 777
#define SQL_CALC_FOUND_ROWS 778
#define SQL_NO_CACHE_SYM 779
#define SQL_SMALL_RESULT 780
#define SQL_SYM 781
#define SQL_THREAD 782
#define SSL_SYM 783
#define STARTING 784
#define STARTS_SYM 785
#define START_SYM 786
#define STATS_AUTO_RECALC_SYM 787
#define STATS_PERSISTENT_SYM 788
#define STATS_SAMPLE_PAGES_SYM 789
#define STATUS_SYM 790
#define STDDEV_SAMP_SYM 791
#define STD_SYM 792
#define STOP_SYM 793
#define STORAGE_SYM 794
#define STRAIGHT_JOIN 795
#define STRING_SYM 796
#define SUBCLASS_ORIGIN_SYM 797
#define SUBDATE_SYM 798
#define SUBJECT_SYM 799
#define SUBPARTITIONS_SYM 800
#define SUBPARTITION_SYM 801
#define SUBSTRING 802
#define SUM_SYM 803
#define SUPER_SYM 804
#define SUSPEND_SYM 805
#define SWAPS_SYM 806
#define SWITCHES_SYM 807
#define SYSDATE 808
#define TABLES 809
#define TABLESPACE 810
#define TABLE_REF_PRIORITY 811
#define TABLE_STATS_SYM 812
#define TABLE_SYM 813
#define TABLE_CHECKSUM_SYM 814
#define TABLE_NAME_SYM 815
#define TEMPORARY 816
#define TEMPTABLE_SYM 817
#define TERMINATED 818
#define TEXT_STRING 819
#define TEXT_SYM 820
#define THAN_SYM 821
#define THEN_SYM 822
#define TIMESTAMP 823
#define TIMESTAMP_ADD 824
#define TIMESTAMP_DIFF 825
#define TIME_SYM 826
#define TINYBLOB 827
#define TINYINT 828
#define TINYTEXT 829
#define TO_SYM 830
#define TRAILING 831
#define TRANSACTION_SYM 832
#define TRANSACTIONAL_SYM 833
#define TRIGGERS_SYM 834
#define TRIGGER_SYM 835
#define TRIM 836
#define TRUE_SYM 837
#define TRUNCATE_SYM 838
#define TYPES_SYM 839
#define TYPE_SYM 840
#define UDF_RETURNS_SYM 841
#define ULONGLONG_NUM 842
#define UNCOMMITTED_SYM 843
#define UNDEFINED_SYM 844
#define UNDERSCORE_CHARSET 845
#define UNDOFILE_SYM 846
#define UNDO_BUFFER_SIZE_SYM 847
#define UNDO_SYM 848
#define UNICODE_SYM 849
#define UNINSTALL_SYM 850
#define UNION_SYM 851
#define UNIQUE_SYM 852
#define UNKNOWN_SYM 853
#define UNLOCK_SYM 854
#define UNSIGNED 855
#define UNTIL_SYM 856
#define UPDATE_SYM 857
#define UPGRADE_SYM 858
#define USAGE 859
#define USER 860
#define USER_STATS_SYM 861
#define USE_FRM 862
#define USE_SYM 863
#define USING 864
#define UTC_DATE_SYM 865
#define UTC_TIMESTAMP_SYM 866
#define UTC_TIME_SYM 867
#define VALUES 868
#define VALUE_SYM 869
#define VARBINARY 870
#define VARCHAR 871
#define VARIABLES 872
#define VARIANCE_SYM 873
#define VARYING 874
#define VAR_SAMP_SYM 875
#define VIA_SYM 876
#define VIEW_SYM 877
#define VIRTUAL_SYM 878
#define WAIT_SYM 879
#define WARNINGS 880
#define WEEK_SYM 881
#define WEIGHT_STRING_SYM 882
#define WHEN_SYM 883
#define WHERE 884
#define WHILE_SYM 885
#define WITH 886
#define WITH_CUBE_SYM 887
#define WITH_ROLLUP_SYM 888
#define WORK_SYM 889
#define WRAPPER_SYM 890
#define WRITE_SYM 891
#define X509_SYM 892
#define XA_SYM 893
#define XML_SYM 894
#define XOR 895
#define YEAR_MONTH_SYM 896
#define YEAR_SYM 897
#define ZEROFILL 898
#define IMPOSSIBLE_ACTION 899




#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 214 of yacc.c  */
#line 898 "/home/buildbot/git/sql/sql_yacc.yy"

  int  num;
  ulong ulong_num;
  ulonglong ulonglong_number;
  longlong longlong_number;
  LEX_STRING lex_str;
  LEX_STRING *lex_str_ptr;
  LEX_SYMBOL symbol;
  LEX_TYPE lex_type;
  Table_ident *table;
  char *simple_string;
  Item *item;
  Item_num *item_num;
  List<Item> *item_list;
  List<String> *string_list;
  String *string;
  Key_part_spec *key_part;
  TABLE_LIST *table_list;
  udf_func *udf;
  LEX_USER *lex_user;
  struct sys_var_with_base variable;
  enum enum_var_type var_type;
  Key::Keytype key_type;
  enum ha_key_alg key_alg;
  handlerton *db_type;
  enum row_type row_type;
  enum ha_rkey_function ha_rkey_mode;
  enum enum_tx_isolation tx_isolation;
  enum Cast_target cast_type;
  enum Item_udftype udf_type;
  enum ha_choice choice;
  CHARSET_INFO *charset;
  thr_lock_type lock_type;
  interval_type interval, interval_time_st;
  timestamp_type date_time_type;
  st_select_lex *select_lex;
  chooser_compare_func_creator boolfunc2creator;
  class sp_condition_value *spcondvalue;
  struct { int vars, conds, hndlrs, curs; } spblock;
  sp_name *spname;
  LEX *lex;
  sp_head *sphead;
  struct p_elem_val *p_elem_value;
  enum index_hint_type index_hint;
  enum enum_filetype filetype;
  enum Foreign_key::fk_option m_fk_option;
  enum enum_yes_no_unknown m_yes_no_unk;
  Diag_condition_item_name diag_condition_item_name;
  Diagnostics_information::Which_area diag_area;
  Diagnostics_information *diag_info;
  Statement_information_item *stmt_info_item;
  Statement_information_item::Name stmt_info_item_name;
  List<Statement_information_item> *stmt_info_list;
  Condition_information_item *cond_info_item;
  Condition_information_item::Name cond_info_item_name;
  List<Condition_information_item> *cond_info_list;
  DYNCALL_CREATE_DEF *dyncol_def;
  List<DYNCALL_CREATE_DEF> *dyncol_def_list;
  bool is_not_empty;



/* Line 214 of yacc.c  */
#line 2343 "/home/buildbot/git/mkdist/sql/sql_yacc.cc"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif


/* Copy the second part of user declarations.  */

/* Line 264 of yacc.c  */
#line 959 "/home/buildbot/git/sql/sql_yacc.yy"

bool my_yyoverflow(short **a, YYSTYPE **b, ulong *yystacksize);


/* Line 264 of yacc.c  */
#line 2360 "/home/buildbot/git/mkdist/sql/sql_yacc.cc"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  625
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   65738

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  664
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  998
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2824
/* YYNRULES -- Number of states.  */
#define YYNSTATES  4793

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   899

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   657,     2,     2,     2,   651,   646,     2,
     654,   655,   649,   648,   656,   647,   662,   650,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   663,   660,
       2,     2,     2,     2,   661,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   652,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   658,   645,   659,   653,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     6,    11,    14,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    77,    79,
      81,    83,    85,    87,    89,    91,    93,    95,    97,    99,
     101,   103,   105,   107,   109,   111,   113,   115,   117,   119,
     121,   123,   125,   127,   129,   131,   135,   137,   139,   144,
     146,   149,   150,   155,   156,   159,   163,   165,   168,   169,
     173,   174,   181,   183,   187,   191,   195,   199,   203,   207,
     211,   215,   219,   223,   227,   231,   235,   239,   243,   247,
     253,   255,   256,   258,   262,   264,   268,   272,   276,   280,
     284,   288,   292,   293,   295,   297,   298,   306,   307,   308,
     324,   325,   326,   342,   343,   344,   360,   361,   368,   369,
     373,   378,   384,   389,   393,   396,   407,   409,   413,   416,
     419,   422,   425,   428,   431,   434,   435,   449,   450,   457,
     460,   461,   463,   467,   469,   470,   473,   474,   477,   478,
     480,   484,   489,   490,   493,   494,   497,   499,   501,   503,
     505,   507,   509,   511,   513,   515,   517,   519,   521,   523,
     524,   528,   530,   531,   534,   535,   538,   541,   544,   547,
     550,   554,   558,   560,   562,   564,   567,   571,   575,   576,
     581,   582,   586,   587,   589,   593,   595,   596,   598,   602,
     604,   605,   609,   610,   612,   616,   618,   623,   624,   626,
     628,   630,   631,   635,   638,   642,   643,   647,   648,   654,
     660,   661,   669,   675,   676,   679,   681,   683,   685,   689,
     691,   693,   695,   699,   700,   702,   704,   706,   708,   711,
     713,   717,   719,   721,   722,   724,   725,   728,   732,   738,
     740,   742,   744,   746,   748,   750,   752,   754,   756,   758,
     760,   762,   764,   766,   768,   772,   777,   778,   780,   782,
     786,   788,   792,   796,   798,   801,   803,   805,   807,   809,
     813,   817,   819,   821,   823,   825,   827,   829,   831,   833,
     835,   837,   839,   841,   843,   845,   849,   850,   853,   855,
     857,   859,   861,   863,   865,   867,   869,   871,   873,   875,
     877,   879,   880,   886,   887,   890,   891,   895,   896,   899,
     902,   905,   908,   909,   916,   919,   920,   923,   925,   927,
     931,   932,   933,   934,   942,   943,   946,   949,   951,   953,
     954,   955,   964,   965,   972,   974,   977,   979,   982,   983,
     984,   991,   992,   993,  1000,  1001,  1004,  1005,  1011,  1012,
    1014,  1015,  1021,  1022,  1025,  1026,  1032,  1037,  1038,  1039,
    1048,  1049,  1057,  1059,  1061,  1063,  1065,  1067,  1070,  1075,
    1081,  1082,  1087,  1092,  1097,  1101,  1105,  1108,  1111,  1112,
    1115,  1117,  1120,  1124,  1126,  1128,  1130,  1132,  1134,  1137,
    1141,  1143,  1145,  1147,  1149,  1151,  1153,  1155,  1157,  1159,
    1161,  1164,  1168,  1170,  1172,  1174,  1176,  1178,  1180,  1182,
    1185,  1189,  1191,  1193,  1195,  1197,  1199,  1201,  1203,  1205,
    1207,  1210,  1214,  1216,  1218,  1220,  1223,  1226,  1229,  1231,
    1233,  1235,  1237,  1240,  1244,  1248,  1252,  1256,  1260,  1264,
    1268,  1272,  1277,  1278,  1280,  1282,  1284,  1286,  1288,  1289,
    1297,  1301,  1302,  1308,  1310,  1313,  1318,  1319,  1320,  1326,
    1327,  1335,  1337,  1338,  1340,  1341,  1346,  1347,  1348,  1352,
    1358,  1365,  1366,  1371,  1374,  1377,  1380,  1383,  1384,  1386,
    1387,  1391,  1392,  1394,  1396,  1400,  1402,  1407,  1413,  1419,
    1420,  1423,  1424,  1425,  1433,  1434,  1445,  1447,  1451,  1453,
    1455,  1456,  1459,  1460,  1464,  1466,  1470,  1471,  1478,  1480,
    1481,  1482,  1488,  1489,  1494,  1496,  1498,  1500,  1504,  1506,
    1510,  1511,  1512,  1518,  1520,  1524,  1526,  1528,  1529,  1533,
    1535,  1539,  1540,  1545,  1547,  1548,  1550,  1553,  1555,  1559,
    1564,  1568,  1572,  1576,  1580,  1585,  1590,  1594,  1595,  1596,
    1603,  1604,  1606,  1607,  1609,  1611,  1614,  1616,  1618,  1619,
    1621,  1623,  1626,  1628,  1629,  1633,  1635,  1639,  1640,  1642,
    1644,  1647,  1649,  1652,  1656,  1660,  1664,  1668,  1672,  1676,
    1680,  1684,  1688,  1692,  1696,  1700,  1704,  1708,  1712,  1716,
    1720,  1724,  1728,  1732,  1736,  1737,  1744,  1746,  1748,  1752,
    1757,  1762,  1765,  1768,  1771,  1775,  1779,  1783,  1787,  1791,
    1795,  1799,  1804,  1809,  1811,  1813,  1815,  1817,  1819,  1821,
    1823,  1825,  1827,  1829,  1831,  1833,  1835,  1838,  1840,  1842,
    1844,  1846,  1848,  1850,  1854,  1856,  1858,  1861,  1864,  1865,
    1874,  1875,  1885,  1886,  1896,  1897,  1907,  1916,  1919,  1920,
    1922,  1927,  1928,  1930,  1933,  1934,  1938,  1941,  1942,  1952,
    1953,  1956,  1957,  1959,  1961,  1962,  1964,  1967,  1969,  1971,
    1974,  1977,  1982,  1986,  1990,  1994,  1998,  2000,  2003,  2005,
    2007,  2011,  2014,  2018,  2021,  2024,  2026,  2030,  2034,  2037,
    2041,  2043,  2046,  2049,  2052,  2054,  2057,  2059,  2061,  2063,
    2066,  2070,  2073,  2077,  2080,  2083,  2087,  2091,  2095,  2096,
    2103,  2104,  2111,  2114,  2116,  2118,  2120,  2122,  2124,  2126,
    2128,  2130,  2132,  2134,  2136,  2139,  2142,  2144,  2147,  2149,
    2152,  2156,  2159,  2161,  2163,  2165,  2167,  2169,  2171,  2173,
    2176,  2177,  2179,  2181,  2187,  2188,  2190,  2193,  2195,  2197,
    2199,  2201,  2205,  2209,  2213,  2217,  2218,  2220,  2221,  2223,
    2224,  2226,  2229,  2231,  2233,  2236,  2239,  2244,  2246,  2250,
    2253,  2255,  2258,  2261,  2264,  2268,  2272,  2276,  2280,  2283,
    2286,  2288,  2291,  2293,  2295,  2297,  2299,  2301,  2302,  2305,
    2307,  2309,  2311,  2313,  2315,  2316,  2319,  2321,  2323,  2324,
    2326,  2328,  2331,  2334,  2336,  2339,  2342,  2343,  2345,  2347,
    2349,  2353,  2355,  2359,  2360,  2362,  2363,  2368,  2370,  2372,
    2374,  2375,  2377,  2380,  2382,  2384,  2387,  2389,  2393,  2397,
    2399,  2401,  2402,  2405,  2406,  2408,  2414,  2415,  2419,  2423,
    2425,  2426,  2429,  2432,  2435,  2436,  2440,  2444,  2451,  2458,
    2460,  2462,  2465,  2468,  2471,  2473,  2476,  2479,  2481,  2483,
    2484,  2486,  2488,  2490,  2492,  2493,  2495,  2497,  2499,  2500,
    2502,  2505,  2506,  2508,  2509,  2511,  2512,  2514,  2516,  2519,
    2521,  2524,  2526,  2529,  2532,  2535,  2539,  2542,  2546,  2550,
    2554,  2558,  2560,  2562,  2564,  2566,  2570,  2572,  2574,  2576,
    2581,  2584,  2586,  2591,  2592,  2594,  2597,  2598,  2601,  2603,
    2607,  2608,  2609,  2617,  2618,  2624,  2632,  2633,  2639,  2640,
    2646,  2647,  2653,  2654,  2659,  2660,  2671,  2675,  2680,  2684,
    2688,  2696,  2697,  2701,  2703,  2708,  2709,  2713,  2714,  2717,
    2718,  2720,  2721,  2724,  2727,  2730,  2733,  2735,  2737,  2739,
    2744,  2749,  2750,  2757,  2762,  2763,  2769,  2770,  2777,  2782,
    2786,  2788,  2796,  2799,  2801,  2803,  2804,  2811,  2812,  2816,
    2819,  2820,  2826,  2827,  2828,  2835,  2837,  2841,  2843,  2845,
    2849,  2853,  2857,  2860,  2865,  2866,  2874,  2875,  2876,  2885,
    2891,  2897,  2901,  2906,  2909,  2912,  2919,  2925,  2929,  2935,
    2937,  2939,  2941,  2943,  2945,  2946,  2948,  2950,  2953,  2956,
    2960,  2964,  2968,  2972,  2973,  2975,  2976,  2978,  2979,  2982,
    2983,  2985,  2988,  2990,  2992,  2994,  2995,  2997,  2999,  3000,
    3003,  3005,  3006,  3008,  3010,  3012,  3013,  3020,  3021,  3027,
    3032,  3037,  3041,  3042,  3044,  3046,  3050,  3054,  3057,  3060,
    3061,  3064,  3066,  3070,  3071,  3073,  3075,  3076,  3079,  3084,
    3086,  3090,  3091,  3097,  3098,  3100,  3102,  3103,  3110,  3111,
    3113,  3115,  3118,  3120,  3122,  3124,  3127,  3128,  3134,  3136,
    3140,  3143,  3144,  3148,  3150,  3155,  3157,  3158,  3163,  3165,
    3166,  3171,  3172,  3174,  3178,  3179,  3181,  3185,  3187,  3189,
    3192,  3193,  3199,  3200,  3202,  3204,  3207,  3209,  3211,  3213,
    3215,  3217,  3220,  3221,  3227,  3228,  3230,  3232,  3233,  3238,
    3243,  3247,  3253,  3255,  3259,  3263,  3264,  3271,  3273,  3275,
    3277,  3281,  3284,  3288,  3290,  3292,  3293,  3300,  3302,  3304,
    3306,  3310,  3314,  3319,  3320,  3327,  3328,  3331,  3332,  3337,
    3338,  3341,  3343,  3346,  3351,  3354,  3358,  3361,  3365,  3366,
    3370,  3371,  3372,  3379,  3382,  3384,  3386,  3389,  3392,  3401,
    3406,  3407,  3409,  3412,  3414,  3416,  3418,  3420,  3421,  3424,
    3429,  3433,  3435,  3437,  3441,  3446,  3447,  3448,  3449,  3452,
    3455,  3457,  3459,  3460,  3463,  3467,  3468,  3471,  3475,  3476,
    3479,  3483,  3487,  3491,  3494,  3498,  3503,  3507,  3512,  3516,
    3521,  3523,  3527,  3532,  3536,  3540,  3547,  3549,  3555,  3562,
    3568,  3576,  3583,  3592,  3598,  3605,  3610,  3615,  3621,  3625,
    3630,  3632,  3636,  3640,  3644,  3648,  3652,  3656,  3662,  3668,
    3672,  3676,  3680,  3684,  3688,  3692,  3694,  3696,  3698,  3700,
    3702,  3704,  3706,  3708,  3710,  3712,  3714,  3716,  3718,  3720,
    3722,  3724,  3726,  3727,  3730,  3732,  3735,  3737,  3739,  3741,
    3744,  3747,  3749,  3751,  3754,  3757,  3762,  3764,  3768,  3770,
    3772,  3774,  3776,  3778,  3782,  3784,  3786,  3788,  3790,  3794,
    3797,  3800,  3803,  3806,  3810,  3814,  3820,  3827,  3832,  3837,
    3845,  3848,  3855,  3861,  3868,  3875,  3880,  3885,  3891,  3896,
    3903,  3906,  3909,  3914,  3919,  3924,  3935,  3942,  3951,  3958,
    3963,  3968,  3975,  3980,  3985,  3990,  3997,  4002,  4010,  4018,
    4026,  4033,  4040,  4047,  4054,  4058,  4063,  4070,  4079,  4082,
    4085,  4094,  4103,  4110,  4117,  4120,  4127,  4134,  4143,  4152,
    4159,  4168,  4175,  4178,  4187,  4196,  4199,  4202,  4205,  4212,
    4219,  4224,  4229,  4238,  4243,  4248,  4253,  4258,  4262,  4271,
    4276,  4281,  4288,  4293,  4298,  4303,  4310,  4319,  4324,  4328,
    4335,  4340,  4347,  4353,  4362,  4370,  4381,  4383,  4390,  4395,
    4400,  4405,  4410,  4415,  4422,  4427,  4428,  4434,  4441,  4444,
    4448,  4449,  4454,  4455,  4459,  4460,  4462,  4464,  4468,  4473,
    4478,  4484,  4489,  4494,  4499,  4505,  4510,  4511,  4512,  4520,
    4525,  4531,  4536,  4542,  4547,  4552,  4557,  4562,  4567,  4573,
    4574,  4583,  4584,  4588,  4592,  4594,  4599,  4600,  4602,  4603,
    4606,  4607,  4608,  4613,  4618,  4621,  4622,  4626,  4629,  4633,
    4636,  4638,  4640,  4643,  4645,  4648,  4650,  4653,  4656,  4659,
    4660,  4664,  4665,  4667,  4669,  4673,  4675,  4679,  4681,  4685,
    4686,  4688,  4689,  4692,  4697,  4703,  4705,  4707,  4709,  4711,
    4716,  4718,  4722,  4726,  4727,  4734,  4735,  4744,  4749,  4750,
    4759,  4760,  4771,  4778,  4779,  4788,  4789,  4800,  4807,  4809,
    4812,  4814,  4816,  4819,  4820,  4822,  4828,  4829,  4835,  4839,
    4845,  4848,  4849,  4850,  4858,  4860,  4861,  4862,  4869,  4870,
    4874,  4875,  4876,  4882,  4883,  4885,  4886,  4888,  4889,  4892,
    4896,  4900,  4902,  4904,  4905,  4913,  4914,  4922,  4924,  4927,
    4928,  4929,  4932,  4933,  4936,  4937,  4939,  4941,  4943,  4945,
    4949,  4951,  4955,  4957,  4959,  4961,  4963,  4965,  4967,  4969,
    4971,  4973,  4975,  4977,  4979,  4981,  4983,  4985,  4987,  4989,
    4991,  4993,  4995,  4997,  4999,  5001,  5003,  5005,  5006,  5008,
    5010,  5011,  5014,  5015,  5017,  5018,  5019,  5023,  5024,  5025,
    5029,  5032,  5033,  5034,  5039,  5044,  5047,  5048,  5050,  5052,
    5056,  5060,  5062,  5065,  5066,  5068,  5069,  5074,  5079,  5082,
    5083,  5085,  5087,  5088,  5090,  5091,  5093,  5096,  5102,  5107,
    5109,  5113,  5117,  5119,  5121,  5123,  5125,  5127,  5129,  5130,
    5133,  5137,  5142,  5144,  5147,  5150,  5152,  5154,  5156,  5158,
    5160,  5162,  5164,  5166,  5168,  5170,  5172,  5174,  5176,  5178,
    5180,  5182,  5184,  5186,  5188,  5190,  5192,  5194,  5196,  5198,
    5200,  5202,  5203,  5204,  5211,  5212,  5214,  5218,  5220,  5224,
    5225,  5228,  5232,  5234,  5237,  5239,  5240,  5244,  5245,  5246,
    5254,  5257,  5259,  5260,  5264,  5265,  5273,  5274,  5282,  5287,
    5294,  5299,  5304,  5309,  5314,  5315,  5322,  5327,  5332,  5338,
    5345,  5350,  5352,  5356,  5358,  5361,  5363,  5367,  5369,  5370,
    5373,  5374,  5376,  5377,  5378,  5387,  5388,  5389,  5396,  5397,
    5399,  5401,  5403,  5405,  5407,  5410,  5412,  5414,  5416,  5420,
    5425,  5426,  5430,  5434,  5436,  5439,  5442,  5443,  5447,  5448,
    5454,  5458,  5460,  5464,  5466,  5470,  5472,  5474,  5475,  5477,
    5478,  5483,  5484,  5486,  5490,  5492,  5494,  5496,  5497,  5498,
    5505,  5506,  5507,  5519,  5523,  5525,  5529,  5533,  5535,  5539,
    5540,  5542,  5543,  5548,  5549,  5550,  5560,  5561,  5567,  5568,
    5575,  5576,  5579,  5581,  5585,  5588,  5593,  5594,  5597,  5598,
    5601,  5603,  5605,  5607,  5608,  5613,  5614,  5616,  5617,  5619,
    5621,  5625,  5627,  5629,  5632,  5635,  5638,  5640,  5642,  5644,
    5646,  5647,  5651,  5652,  5656,  5659,  5664,  5669,  5673,  5678,
    5683,  5685,  5689,  5693,  5697,  5701,  5708,  5711,  5714,  5715,
    5722,  5723,  5731,  5737,  5740,  5742,  5744,  5746,  5752,  5758,
    5761,  5764,  5766,  5771,  5775,  5778,  5782,  5785,  5788,  5790,
    5794,  5799,  5803,  5807,  5810,  5814,  5817,  5821,  5823,  5825,
    5827,  5829,  5833,  5837,  5841,  5845,  5849,  5853,  5857,  5861,
    5865,  5867,  5869,  5871,  5873,  5875,  5876,  5878,  5879,  5882,
    5883,  5885,  5887,  5889,  5890,  5893,  5894,  5897,  5898,  5901,
    5904,  5905,  5910,  5911,  5916,  5918,  5920,  5922,  5924,  5926,
    5928,  5930,  5931,  5933,  5935,  5936,  5938,  5940,  5941,  5946,
    5947,  5952,  5954,  5955,  5957,  5962,  5963,  5967,  5971,  5973,
    5976,  5979,  5982,  5985,  5988,  5992,  5995,  5997,  5999,  6001,
    6003,  6006,  6008,  6010,  6012,  6014,  6016,  6018,  6020,  6021,
    6023,  6024,  6028,  6029,  6033,  6037,  6039,  6040,  6045,  6047,
    6050,  6051,  6053,  6054,  6058,  6062,  6065,  6068,  6069,  6075,
    6076,  6078,  6080,  6081,  6083,  6085,  6088,  6090,  6093,  6095,
    6098,  6099,  6100,  6101,  6102,  6125,  6127,  6129,  6130,  6132,
    6133,  6135,  6137,  6138,  6140,  6142,  6143,  6146,  6149,  6151,
    6155,  6160,  6164,  6168,  6169,  6172,  6175,  6177,  6181,  6185,
    6186,  6191,  6192,  6196,  6198,  6200,  6201,  6205,  6208,  6212,
    6214,  6216,  6219,  6220,  6223,  6227,  6229,  6235,  6237,  6239,
    6242,  6245,  6247,  6249,  6251,  6253,  6255,  6257,  6259,  6262,
    6265,  6267,  6269,  6271,  6273,  6275,  6277,  6279,  6281,  6283,
    6286,  6288,  6290,  6292,  6294,  6296,  6299,  6302,  6305,  6307,
    6309,  6313,  6319,  6321,  6323,  6325,  6327,  6329,  6333,  6338,
    6344,  6346,  6352,  6356,  6359,  6361,  6365,  6368,  6371,  6376,
    6378,  6380,  6382,  6384,  6386,  6388,  6390,  6392,  6394,  6396,
    6398,  6400,  6402,  6404,  6408,  6411,  6413,  6415,  6417,  6419,
    6421,  6423,  6425,  6427,  6429,  6431,  6433,  6435,  6437,  6439,
    6441,  6443,  6445,  6447,  6449,  6451,  6453,  6455,  6457,  6459,
    6461,  6463,  6465,  6467,  6469,  6471,  6473,  6475,  6477,  6479,
    6481,  6483,  6485,  6487,  6489,  6491,  6493,  6495,  6497,  6499,
    6501,  6503,  6505,  6507,  6509,  6511,  6513,  6515,  6517,  6519,
    6521,  6523,  6525,  6527,  6529,  6531,  6533,  6535,  6537,  6539,
    6541,  6543,  6545,  6547,  6549,  6551,  6553,  6555,  6557,  6559,
    6561,  6563,  6565,  6567,  6569,  6571,  6573,  6575,  6577,  6579,
    6581,  6583,  6585,  6587,  6589,  6591,  6593,  6595,  6597,  6599,
    6601,  6603,  6605,  6607,  6609,  6611,  6613,  6615,  6617,  6619,
    6621,  6623,  6625,  6627,  6629,  6631,  6633,  6635,  6637,  6639,
    6641,  6643,  6645,  6647,  6649,  6651,  6653,  6655,  6657,  6659,
    6661,  6663,  6665,  6667,  6669,  6671,  6673,  6675,  6677,  6679,
    6681,  6683,  6685,  6687,  6689,  6691,  6693,  6695,  6697,  6699,
    6701,  6703,  6705,  6707,  6709,  6711,  6713,  6715,  6717,  6719,
    6721,  6723,  6725,  6727,  6729,  6731,  6733,  6735,  6737,  6739,
    6741,  6743,  6745,  6747,  6749,  6751,  6753,  6755,  6757,  6759,
    6761,  6763,  6765,  6767,  6769,  6771,  6773,  6775,  6777,  6779,
    6781,  6783,  6785,  6787,  6789,  6791,  6793,  6795,  6797,  6799,
    6801,  6803,  6805,  6807,  6809,  6811,  6813,  6815,  6817,  6819,
    6821,  6823,  6825,  6827,  6829,  6831,  6833,  6835,  6837,  6839,
    6841,  6843,  6845,  6847,  6849,  6851,  6853,  6855,  6857,  6859,
    6861,  6863,  6865,  6867,  6869,  6871,  6873,  6875,  6877,  6879,
    6881,  6883,  6885,  6887,  6889,  6891,  6893,  6895,  6897,  6899,
    6901,  6903,  6905,  6907,  6909,  6911,  6913,  6915,  6917,  6919,
    6921,  6923,  6925,  6927,  6929,  6931,  6933,  6935,  6937,  6939,
    6941,  6943,  6945,  6947,  6949,  6951,  6953,  6955,  6957,  6959,
    6961,  6963,  6965,  6967,  6969,  6971,  6973,  6975,  6977,  6979,
    6981,  6983,  6985,  6987,  6989,  6991,  6993,  6995,  6997,  6999,
    7001,  7003,  7005,  7007,  7009,  7011,  7013,  7015,  7017,  7019,
    7021,  7023,  7025,  7027,  7029,  7031,  7033,  7035,  7037,  7039,
    7041,  7043,  7045,  7047,  7049,  7051,  7053,  7055,  7057,  7059,
    7061,  7063,  7065,  7067,  7069,  7071,  7073,  7075,  7077,  7079,
    7081,  7083,  7085,  7087,  7089,  7091,  7093,  7095,  7097,  7099,
    7101,  7103,  7105,  7107,  7109,  7111,  7113,  7115,  7117,  7119,
    7121,  7123,  7125,  7127,  7129,  7131,  7133,  7135,  7137,  7139,
    7141,  7143,  7145,  7147,  7149,  7151,  7153,  7155,  7157,  7159,
    7160,  7164,  7165,  7169,  7170,  7174,  7175,  7179,  7180,  7184,
    7187,  7188,  7191,  7192,  7195,  7196,  7201,  7202,  7206,  7208,
    7210,  7212,  7214,  7215,  7217,  7219,  7221,  7222,  7225,  7228,
    7231,  7235,  7239,  7244,  7251,  7254,  7258,  7262,  7265,  7269,
    7275,  7277,  7281,  7285,  7287,  7289,  7293,  7297,  7299,  7303,
    7306,  7309,  7312,  7315,  7318,  7320,  7322,  7327,  7332,  7334,
    7336,  7338,  7340,  7342,  7343,  7348,  7350,  7352,  7354,  7356,
    7358,  7362,  7366,  7368,  7370,  7373,  7376,  7379,  7380,  7384,
    7389,  7393,  7394,  7402,  7404,  7407,  7409,  7411,  7413,  7415,
    7417,  7419,  7420,  7426,  7428,  7430,  7432,  7434,  7436,  7440,
    7447,  7454,  7461,  7469,  7475,  7479,  7484,  7486,  7490,  7499,
    7508,  7517,  7524,  7529,  7530,  7534,  7535,  7539,  7541,  7545,
    7548,  7550,  7552,  7553,  7555,  7557,  7560,  7561,  7563,  7565,
    7569,  7570,  7574,  7575,  7579,  7580,  7584,  7585,  7589,  7591,
    7593,  7595,  7597,  7599,  7601,  7603,  7605,  7607,  7609,  7611,
    7614,  7617,  7619,  7623,  7626,  7629,  7632,  7635,  7638,  7641,
    7644,  7647,  7649,  7651,  7654,  7655,  7657,  7661,  7663,  7666,
    7669,  7672,  7674,  7678,  7682,  7684,  7686,  7690,  7692,  7696,
    7698,  7702,  7704,  7706,  7708,  7710,  7715,  7721,  7726,  7733,
    7735,  7736,  7740,  7744,  7746,  7748,  7749,  7752,  7755,  7758,
    7761,  7762,  7765,  7766,  7770,  7773,  7775,  7778,  7781,  7784,
    7787,  7790,  7791,  7795,  7796,  7798,  7799,  7803,  7806,  7807,
    7809,  7812,  7813,  7815,  7820,  7825,  7831,  7834,  7838,  7839,
    7841,  7842,  7847,  7848,  7850,  7852,  7853,  7855,  7856,  7859,
    7862,  7864,  7865,  7867,  7869,  7872,  7876,  7879,  7880,  7887,
    7891,  7892,  7893,  7894,  7896,  7899,  7901,  7903,  7905,  7907,
    7909,  7911,  7913,  7915,  7917,  7920,  7923,  7927,  7929,  7931,
    7933,  7935,  7937,  7939,  7941,  7943,  7945,  7947,  7949,  7951,
    7953,  7954,  7958,  7962,  7966,  7970,  7971,  7975,  7979,  7980,
    7988,  7989,  7993,  7995,  7999,  8000,  8004,  8007,  8012,  8013,
    8017,  8022,  8027,  8028,  8029,  8030,  8047,  8056,  8064,  8065,
    8066,  8067,  8068,  8069,  8085,  8086,  8087,  8088,  8089,  8102,
    8107,  8112,  8116,  8121,  8125,  8128,  8130,  8134,  8140,  8142,
    8144,  8145,  8147,  8149,  8150,  8153,  8154,  8155,  8159,  8160,
    8163,  8169,  8173,  8177,  8181
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     665,     0,    -1,   162,    -1,    -1,   668,   666,   660,   667,
      -1,   668,   162,    -1,    -1,   162,    -1,   669,    -1,  1591,
      -1,  1055,    -1,  1123,    -1,  1136,    -1,   723,    -1,   681,
      -1,  1137,    -1,  1115,    -1,  1597,    -1,   690,    -1,   670,
      -1,  1388,    -1,  1422,    -1,  1339,    -1,  1341,    -1,   674,
      -1,  1429,    -1,   759,    -1,  1557,    -1,  1547,    -1,   679,
      -1,  1352,    -1,  1659,    -1,  1661,    -1,  1150,    -1,  1450,
      -1,  1457,    -1,  1538,    -1,  1142,    -1,   970,    -1,   878,
      -1,  1157,    -1,   672,    -1,  1446,    -1,  1600,    -1,  1145,
      -1,  1118,    -1,  1355,    -1,  1440,    -1,   758,    -1,  1554,
      -1,  1598,    -1,  1599,    -1,  1169,    -1,  1511,    -1,   751,
      -1,  1408,    -1,  1455,    -1,  1102,    -1,  1105,    -1,  1401,
      -1,  1660,    -1,  1545,    -1,  1380,    -1,  1456,    -1,  1651,
      -1,   671,   414,  1503,    -1,   128,    -1,   150,    -1,   414,
    1503,   199,   673,    -1,  1500,    -1,   661,  1505,    -1,    -1,
     177,  1503,   675,   676,    -1,    -1,   609,   677,    -1,   677,
     656,   678,    -1,   678,    -1,   661,  1505,    -1,    -1,   220,
     680,  1505,    -1,    -1,    59,   313,   688,   575,   682,   683,
      -1,   684,    -1,   683,   656,   684,    -1,   298,   166,  1500,
      -1,   314,   166,  1500,    -1,   301,   166,  1500,    -1,   302,
     166,  1318,    -1,   296,   166,  1318,    -1,   311,   166,  1318,
      -1,   305,   166,  1500,    -1,   304,   166,  1500,    -1,   306,
     166,  1500,    -1,   307,   166,  1500,    -1,   310,   166,  1500,
      -1,   312,   166,  1318,    -1,   308,   166,  1500,    -1,   309,
     166,  1500,    -1,   316,   166,  1487,    -1,   236,   166,   654,
     685,   655,    -1,   687,    -1,    -1,   686,    -1,   685,   656,
     686,    -1,  1318,    -1,   299,   166,  1500,    -1,   300,   166,
    1320,    -1,   444,   166,  1500,    -1,   445,   166,  1318,    -1,
     315,   166,   111,    -1,   315,   166,   506,    -1,   315,   166,
     367,    -1,    -1,   689,    -1,  1500,    -1,    -1,   934,   930,
     558,   933,  1496,   691,   866,    -1,    -1,    -1,   104,  1032,
     239,   933,  1503,  1036,   377,  1496,   692,   654,  1049,   655,
    1037,   693,  1089,    -1,    -1,    -1,   104,  1033,   239,   933,
    1503,  1035,   377,  1496,   694,   654,  1049,   655,  1038,   695,
    1089,    -1,    -1,    -1,   104,  1034,   239,   933,  1503,  1035,
     377,  1496,   696,   654,  1049,   655,  1039,   697,  1089,    -1,
      -1,   104,   115,   933,  1503,   698,   927,    -1,    -1,   934,
     699,  1619,    -1,   104,   605,   716,  1578,    -1,   104,   471,
     716,  1561,  1559,    -1,   104,   287,   213,   829,    -1,   104,
     555,   826,    -1,   104,   700,    -1,   492,  1505,   196,   118,
     635,  1505,   383,   654,   701,   655,    -1,   702,    -1,   701,
     656,   702,    -1,   605,  1500,    -1,   224,  1500,    -1,   115,
    1500,    -1,   393,  1500,    -1,   404,  1500,    -1,   510,  1500,
      -1,   411,  1318,    -1,    -1,  1186,   173,   933,   717,   704,
     377,   481,   705,   710,   707,   712,   149,   713,    -1,    -1,
     174,  1192,  1288,   706,   708,   709,    -1,    24,  1192,    -1,
      -1,   158,    -1,   143,   377,   504,    -1,   143,    -1,    -1,
     530,  1192,    -1,    -1,   161,  1192,    -1,    -1,   711,    -1,
     377,    87,   415,    -1,   377,    87,   365,   415,    -1,    -1,
      83,  1500,    -1,    -1,   714,   715,    -1,   775,    -1,   777,
      -1,   773,    -1,   794,    -1,   812,    -1,   814,    -1,   809,
      -1,   779,    -1,   781,    -1,   782,    -1,   783,    -1,   784,
      -1,   786,    -1,    -1,  1503,   662,  1503,    -1,  1503,    -1,
      -1,   718,   720,    -1,    -1,   719,   721,    -1,    83,  1500,
      -1,   265,   526,    -1,   367,   526,    -1,    97,   526,    -1,
     430,   526,   118,    -1,   341,   526,   118,    -1,   722,    -1,
     720,    -1,   140,    -1,  1198,   140,    -1,   526,   485,   133,
      -1,   526,   485,   252,    -1,    -1,    52,   717,   724,   725,
      -1,    -1,   654,   726,   655,    -1,    -1,   727,    -1,   727,
     656,  1192,    -1,  1192,    -1,    -1,   729,    -1,   729,   656,
     731,    -1,   731,    -1,    -1,  1503,   730,   993,    -1,    -1,
     733,    -1,   733,   656,   734,    -1,   734,    -1,   735,   730,
    1503,   993,    -1,    -1,   253,    -1,   392,    -1,   244,    -1,
      -1,   736,   772,   660,    -1,   772,   660,    -1,   737,   772,
     660,    -1,    -1,   738,   739,   660,    -1,    -1,   131,   770,
     740,   993,   771,    -1,   131,  1503,    90,   197,   747,    -1,
      -1,   131,   744,   216,   197,   741,   745,   772,    -1,   131,
    1503,   112,   197,   742,    -1,    -1,   743,  1169,    -1,   179,
      -1,    99,    -1,   746,    -1,   745,   656,   746,    -1,   750,
      -1,  1318,    -1,   748,    -1,   518,   749,  1501,    -1,    -1,
     614,    -1,   747,    -1,  1503,    -1,   519,    -1,  1198,   198,
      -1,   517,    -1,   501,   752,   754,    -1,  1503,    -1,   748,
      -1,    -1,   752,    -1,    -1,   494,   755,    -1,   757,   166,
     756,    -1,   755,   656,   757,   166,   756,    -1,  1486,    -1,
    1223,    -1,  1492,    -1,    67,    -1,   542,    -1,    94,    -1,
      96,    -1,    95,    -1,    57,    -1,   482,    -1,   560,    -1,
      82,    -1,   113,    -1,   332,    -1,   350,    -1,   459,   753,
     754,    -1,   209,   760,   141,   761,    -1,    -1,   108,    -1,
     762,    -1,    90,   766,   767,    -1,   763,    -1,   762,   656,
     763,    -1,   764,   166,   765,    -1,  1503,    -1,   661,  1505,
      -1,   372,    -1,   478,    -1,   756,    -1,   768,    -1,   767,
     656,   768,    -1,   764,   166,   769,    -1,    67,    -1,   542,
      -1,    94,    -1,    96,    -1,    95,    -1,    57,    -1,   482,
      -1,   560,    -1,    82,    -1,   113,    -1,   332,    -1,   350,
      -1,   464,    -1,  1503,    -1,   770,   656,  1503,    -1,    -1,
     132,  1192,    -1,   775,    -1,   777,    -1,   773,    -1,   794,
      -1,   812,    -1,   814,    -1,   809,    -1,   779,    -1,   781,
      -1,   782,    -1,   783,    -1,   784,    -1,   786,    -1,    -1,
     234,   774,   789,   160,   234,    -1,    -1,   776,   669,    -1,
      -1,   467,   778,  1192,    -1,    -1,   780,   818,    -1,   271,
    1504,    -1,   259,  1504,    -1,   381,  1503,    -1,    -1,   188,
     787,  1503,   250,   785,   788,    -1,    70,  1503,    -1,    -1,
     361,   199,    -1,   199,    -1,  1503,    -1,   788,   656,  1503,
      -1,    -1,    -1,    -1,   790,  1192,   567,   791,   737,   792,
     793,    -1,    -1,   157,   789,    -1,   156,   737,    -1,   795,
      -1,   798,    -1,    -1,    -1,    55,   796,  1192,   797,   800,
     808,   160,    55,    -1,    -1,    55,   799,   801,   808,   160,
      55,    -1,   802,    -1,   800,   802,    -1,   805,    -1,   801,
     805,    -1,    -1,    -1,   628,   803,  1192,   804,   567,   737,
      -1,    -1,    -1,   628,   806,  1192,   807,   567,   737,    -1,
      -1,   156,   737,    -1,    -1,  1504,   663,   810,   818,   811,
      -1,    -1,  1504,    -1,    -1,  1504,   663,   813,   816,   811,
      -1,    -1,   815,   816,    -1,    -1,    33,   817,   738,   736,
     160,    -1,   293,   737,   160,   293,    -1,    -1,    -1,   630,
     819,  1192,   149,   820,   737,   160,   630,    -1,    -1,   454,
     737,   601,   821,  1192,   160,   454,    -1,    32,    -1,     9,
      -1,   246,    -1,   602,    -1,   136,    -1,   851,   853,    -1,
     851,    59,   848,   832,    -1,   851,     6,   848,   827,   836,
      -1,    -1,   608,   287,   213,  1503,    -1,   851,     6,   848,
     839,    -1,   851,   150,   848,   839,    -1,   852,   831,   842,
      -1,   852,   831,   845,    -1,     6,   849,    -1,     6,   850,
      -1,    -1,   833,   834,    -1,   835,    -1,   834,   835,    -1,
     834,   656,   835,    -1,   854,    -1,   855,    -1,   856,    -1,
     837,    -1,   838,    -1,   837,   838,    -1,   837,   656,   838,
      -1,   854,    -1,   855,    -1,   856,    -1,   857,    -1,   860,
      -1,   862,    -1,   864,    -1,   861,    -1,   840,    -1,   841,
      -1,   840,   841,    -1,   840,   656,   841,    -1,   854,    -1,
     855,    -1,   856,    -1,   862,    -1,   864,    -1,   843,    -1,
     844,    -1,   843,   844,    -1,   843,   656,   844,    -1,   854,
      -1,   858,    -1,   859,    -1,   860,    -1,   862,    -1,   864,
      -1,   861,    -1,   846,    -1,   847,    -1,   846,   847,    -1,
     846,   656,   847,    -1,   854,    -1,   862,    -1,   864,    -1,
     117,  1500,    -1,   591,  1500,    -1,   437,  1500,    -1,  1503,
      -1,  1503,    -1,   431,    -1,   433,    -1,   365,     4,    -1,
     242,  1372,   865,    -1,    26,  1372,   865,    -1,   321,  1372,
     865,    -1,   183,  1372,   865,    -1,   592,  1372,   865,    -1,
     438,  1372,   865,    -1,   362,  1372,  1319,    -1,    83,  1372,
    1500,    -1,  1415,   164,  1372,   942,    -1,    -1,   864,    -1,
     624,    -1,   368,    -1,  1321,    -1,  1499,    -1,    -1,   654,
     948,   655,   867,   935,   873,   870,    -1,   935,   873,   870,
      -1,    -1,   654,   923,   655,   868,  1604,    -1,   869,    -1,
     276,  1496,    -1,   654,   276,  1496,   655,    -1,    -1,    -1,
    1465,   926,   923,   871,  1601,    -1,    -1,  1465,   926,   654,
     923,   655,   872,  1604,    -1,   874,    -1,    -1,   875,    -1,
      -1,   401,   877,   876,   880,    -1,    -1,    -1,   401,   879,
     880,    -1,    49,   881,   891,   892,   899,    -1,   883,   263,
     884,   654,   885,   655,    -1,    -1,   883,   218,   882,   889,
      -1,   429,   889,    -1,   429,   888,    -1,   281,   889,    -1,
     281,   888,    -1,    -1,   278,    -1,    -1,    12,   166,  1319,
      -1,    -1,   886,    -1,   887,    -1,   886,   656,   887,    -1,
    1503,    -1,    75,   654,   885,   655,    -1,   654,  1186,   897,
    1187,   655,    -1,   654,  1186,   897,  1187,   655,    -1,    -1,
     402,  1319,    -1,    -1,    -1,   546,    49,   883,   218,   890,
     893,   898,    -1,    -1,   546,    49,   883,   263,   884,   654,
     895,   655,   894,   898,    -1,   896,    -1,   895,   656,   896,
      -1,  1503,    -1,  1195,    -1,    -1,   545,  1319,    -1,    -1,
     654,   900,   655,    -1,   901,    -1,   900,   656,   901,    -1,
      -1,   401,   902,   903,   904,   920,   915,    -1,  1503,    -1,
      -1,    -1,   613,   273,   566,   905,   907,    -1,    -1,   613,
     253,   906,   908,    -1,   325,    -1,   910,    -1,   910,    -1,
     654,   909,   655,    -1,   910,    -1,   909,   656,   910,    -1,
      -1,    -1,   654,   911,   913,   912,   655,    -1,   914,    -1,
     913,   656,   914,    -1,   325,    -1,  1195,    -1,    -1,   654,
     916,   655,    -1,   917,    -1,   916,   656,   917,    -1,    -1,
     546,   918,   919,   920,    -1,  1505,    -1,    -1,   921,    -1,
     921,   922,    -1,   922,    -1,   555,  1372,  1505,    -1,  1415,
     164,  1372,   942,    -1,    91,  1372,  1500,    -1,   362,  1372,
    1319,    -1,   320,  1372,  1321,    -1,   338,  1372,  1321,    -1,
     118,   142,  1372,  1500,    -1,   239,   142,  1372,  1500,    -1,
      83,  1372,  1500,    -1,    -1,    -1,   486,   924,  1180,  1184,
     925,   946,    -1,    -1,    20,    -1,    -1,   928,    -1,   929,
      -1,   928,   929,    -1,   941,    -1,   940,    -1,    -1,   931,
      -1,   932,    -1,   932,   931,    -1,   561,    -1,    -1,   234,
    1198,   178,    -1,   104,    -1,   104,   389,   455,    -1,    -1,
     937,    -1,   938,    -1,   938,   936,    -1,   938,    -1,   938,
     937,    -1,   938,   656,   937,    -1,   164,  1372,   942,    -1,
     320,  1372,  1320,    -1,   338,  1372,  1320,    -1,    29,  1372,
    1318,    -1,   404,  1372,  1500,    -1,    83,  1372,  1500,    -1,
      27,  1372,  1320,    -1,   394,  1372,  1318,    -1,   394,  1372,
     132,    -1,   532,  1372,  1318,    -1,   532,  1372,   132,    -1,
     533,  1372,  1318,    -1,   533,  1372,   132,    -1,   534,  1372,
    1318,    -1,   534,  1372,   132,    -1,    64,  1372,  1318,    -1,
     559,  1372,  1318,    -1,   396,  1372,  1324,    -1,   135,  1372,
    1318,    -1,   476,  1372,   944,    -1,    -1,   596,  1372,   939,
     654,  1438,   655,    -1,   940,    -1,   941,    -1,   247,  1372,
     945,    -1,   118,   142,  1372,  1500,    -1,   239,   142,  1372,
    1500,    -1,   555,  1503,    -1,   539,   145,    -1,   539,   330,
      -1,    91,  1372,  1500,    -1,   262,  1372,  1318,    -1,   578,
    1372,  1324,    -1,  1499,  1371,  1500,    -1,  1499,  1371,  1503,
      -1,  1499,  1371,  1321,    -1,  1499,  1371,   132,    -1,  1004,
     995,  1372,   997,    -1,  1004,    73,  1372,  1003,    -1,  1505,
      -1,  1505,    -1,   132,    -1,   191,    -1,   154,    -1,    88,
      -1,   439,    -1,    86,    -1,   395,    -1,   367,    -1,   190,
      -1,   266,    -1,  1311,    -1,  1179,  1183,    -1,   541,    -1,
     434,    -1,   130,    -1,   251,    -1,   949,    -1,   950,    -1,
     949,   656,   950,    -1,   951,    -1,   952,    -1,   961,   957,
      -1,   961,  1021,    -1,    -1,  1027,  1052,  1036,   654,  1049,
     655,   953,  1037,    -1,    -1,  1033,  1030,  1052,  1035,   654,
    1049,   655,   954,  1038,    -1,    -1,  1034,  1030,  1052,  1035,
     654,  1049,   655,   955,  1039,    -1,    -1,   959,  1028,  1052,
    1036,   654,  1049,   655,   956,  1037,    -1,   959,   196,   263,
    1052,   654,  1049,   655,  1021,    -1,   959,   958,    -1,    -1,
     958,    -1,    65,   654,  1192,   655,    -1,    -1,   960,    -1,
      93,  1051,    -1,    -1,  1495,   962,   963,    -1,   972,   990,
      -1,    -1,   972,   965,    20,   964,   654,   971,   655,   966,
     967,    -1,    -1,   205,    15,    -1,    -1,   623,    -1,   405,
      -1,    -1,   968,    -1,   968,   969,    -1,   969,    -1,   597,
      -1,   597,   263,    -1,    83,  1500,    -1,   399,   654,   971,
     655,    -1,  1186,  1192,  1187,    -1,   980,   988,   984,    -1,
     981,   989,   984,    -1,   193,   982,   984,    -1,    41,    -1,
      41,   987,    -1,    46,    -1,    45,    -1,   976,   987,  1007,
      -1,   976,  1007,    -1,   977,   987,  1008,    -1,   977,  1008,
      -1,    36,   987,    -1,    36,    -1,   978,   987,  1007,    -1,
     979,   987,  1008,    -1,   615,   987,    -1,   642,   988,   984,
      -1,   122,    -1,   571,   988,    -1,   568,   988,    -1,   119,
     988,    -1,   572,    -1,    43,   988,    -1,   975,    -1,   326,
      -1,   289,    -1,   292,   615,    -1,   292,   978,  1007,    -1,
     574,  1007,    -1,   565,   988,  1007,    -1,   328,  1007,    -1,
     290,  1007,    -1,   130,   982,   984,    -1,   373,   982,   984,
      -1,   191,   982,   984,    -1,    -1,   165,   973,   654,  1054,
     655,  1007,    -1,    -1,   494,   974,   654,  1054,   655,  1007,
      -1,   292,  1007,    -1,   490,    -1,   207,    -1,   206,    -1,
     409,    -1,   346,    -1,   280,    -1,   345,    -1,   410,    -1,
     347,    -1,    62,    -1,   356,    -1,   353,    62,    -1,   976,
     619,    -1,   616,    -1,   353,   616,    -1,   374,    -1,   356,
     616,    -1,   353,    62,   619,    -1,   356,   619,    -1,   251,
      -1,   573,    -1,   508,    -1,   327,    -1,    35,    -1,   434,
      -1,   148,    -1,   148,   413,    -1,    -1,   987,    -1,   983,
      -1,   654,   371,   656,   371,   655,    -1,    -1,   985,    -1,
     985,   986,    -1,   986,    -1,   502,    -1,   600,    -1,   643,
      -1,   654,   291,   655,    -1,   654,   587,   655,    -1,   654,
     129,   655,    -1,   654,   371,   655,    -1,    -1,   987,    -1,
      -1,   983,    -1,    -1,   991,    -1,   991,   992,    -1,   992,
      -1,   370,    -1,  1198,   370,    -1,   132,   994,    -1,   377,
     602,   366,  1189,    -1,    27,    -1,   490,   132,   614,    -1,
    1020,   263,    -1,   597,    -1,   597,   263,    -1,    83,  1500,
      -1,    73,  1001,    -1,  1499,  1371,  1500,    -1,  1499,  1371,
    1503,    -1,  1499,  1371,  1321,    -1,  1499,  1371,   132,    -1,
     972,  1002,    -1,   366,  1189,    -1,  1485,    -1,    62,   494,
      -1,    61,    -1,  1505,    -1,    36,    -1,   996,    -1,   132,
      -1,    -1,   995,   997,    -1,  1505,    -1,    36,    -1,   999,
      -1,   132,    -1,  1505,    -1,    -1,    73,  1003,    -1,  1001,
      -1,   132,    -1,    -1,   132,    -1,    22,    -1,    36,    22,
      -1,    22,    36,    -1,   594,    -1,   594,    36,    -1,    36,
     594,    -1,    -1,  1005,    -1,  1006,    -1,    50,    -1,   995,
     996,  1008,    -1,    36,    -1,    36,   995,   996,    -1,    -1,
      36,    -1,    -1,   654,  1319,  1010,   655,    -1,    21,    -1,
     137,    -1,   468,    -1,    -1,  1011,    -1,  1011,  1012,    -1,
    1012,    -1,  1319,    -1,  1014,  1013,    -1,  1015,    -1,  1016,
     656,  1015,    -1,  1014,   647,  1014,    -1,  1016,    -1,  1017,
      -1,    -1,   274,  1018,    -1,    -1,   417,    -1,   440,  1496,
    1022,  1024,  1025,    -1,    -1,   654,  1023,   655,    -1,  1023,
     656,  1503,    -1,  1503,    -1,    -1,   317,   200,    -1,   317,
     400,    -1,   317,   503,    -1,    -1,   377,   602,  1026,    -1,
     377,   136,  1026,    -1,   377,   602,  1026,   377,   136,  1026,
      -1,   377,   136,  1026,   377,   602,  1026,    -1,   462,    -1,
      53,    -1,   494,   370,    -1,   367,     5,    -1,   494,   132,
      -1,  1029,    -1,   417,   263,    -1,   597,  1030,    -1,   263,
      -1,   239,    -1,    -1,  1029,    -1,   261,    -1,   239,    -1,
     238,    -1,    -1,   597,    -1,   201,    -1,   515,    -1,    -1,
    1035,    -1,  1035,  1043,    -1,    -1,  1040,    -1,    -1,  1042,
      -1,    -1,  1041,    -1,  1045,    -1,  1040,  1045,    -1,  1046,
      -1,  1041,  1046,    -1,  1047,    -1,  1042,  1047,    -1,   609,
    1048,    -1,   585,  1048,    -1,   262,  1372,  1318,    -1,    83,
    1500,    -1,  1499,  1371,  1500,    -1,  1499,  1371,  1503,    -1,
    1499,  1371,  1321,    -1,  1499,  1371,   132,    -1,  1044,    -1,
    1043,    -1,  1044,    -1,  1044,    -1,   631,   398,  1499,    -1,
      48,    -1,   479,    -1,   218,    -1,  1049,   656,  1050,  1309,
      -1,  1050,  1309,    -1,  1503,    -1,  1503,   654,   371,   655,
      -1,    -1,  1495,    -1,   933,  1051,    -1,    -1,   662,  1503,
      -1,  1482,    -1,  1054,   656,  1482,    -1,    -1,    -1,    14,
    1056,  1094,   558,  1496,  1057,  1068,    -1,    -1,    14,   115,
    1067,  1058,   928,    -1,    14,   115,  1503,   603,   118,   142,
     352,    -1,    -1,    14,   419,   717,  1059,   718,    -1,    -1,
      14,   202,   717,  1060,   718,    -1,    -1,    14,  1625,  1622,
    1061,  1627,    -1,    -1,    14,  1622,  1062,  1627,    -1,    -1,
      14,  1622,   173,   717,  1063,  1064,  1065,   707,   712,  1066,
      -1,    14,   555,   828,    -1,    14,   287,   213,   830,    -1,
      14,   555,   825,    -1,    14,   555,   824,    -1,    14,   492,
    1505,   383,   654,   701,   655,    -1,    -1,   377,   481,   705,
      -1,   711,    -1,   377,   481,   705,   711,    -1,    -1,   450,
     575,   717,    -1,    -1,   149,   713,    -1,    -1,  1503,    -1,
      -1,   144,   555,    -1,   237,   555,    -1,  1083,   874,    -1,
    1083,  1072,    -1,  1072,    -1,   875,    -1,  1074,    -1,   150,
     401,  1350,  1081,    -1,   435,   401,  1144,  1073,    -1,    -1,
     382,   401,  1144,  1073,  1069,  1144,    -1,    16,   401,  1144,
    1073,    -1,    -1,    65,   401,  1073,  1070,  1139,    -1,    -1,
     452,   401,  1144,  1073,  1071,  1120,    -1,    71,   401,  1144,
    1319,    -1,   583,   401,  1073,    -1,  1077,    -1,   175,   401,
    1082,   631,   558,  1496,   877,    -1,   449,   403,    -1,    13,
      -1,  1081,    -1,    -1,     6,   401,   933,  1144,  1075,  1076,
      -1,    -1,   654,   900,   655,    -1,   402,  1319,    -1,    -1,
     451,   401,  1144,  1078,  1079,    -1,    -1,    -1,  1081,  1080,
     250,   654,   900,   655,    -1,  1082,    -1,  1081,   656,  1082,
      -1,  1503,    -1,  1085,    -1,  1083,   656,  1085,    -1,     6,
    1092,   933,    -1,  1084,   951,  1100,    -1,     6,   952,    -1,
    1084,   654,   948,   655,    -1,    -1,    59,  1092,  1350,  1495,
    1086,   961,  1100,    -1,    -1,    -1,   342,  1092,  1350,  1495,
    1087,   963,  1088,  1100,    -1,   150,  1092,  1350,  1495,  1099,
      -1,   150,   196,   263,  1350,  1495,    -1,   150,   417,   263,
      -1,   150,  1029,  1350,  1495,    -1,   143,   261,    -1,   158,
     261,    -1,    14,  1092,  1495,   494,   132,  1485,    -1,    14,
    1092,  1495,   150,   132,    -1,   450,  1101,  1496,    -1,   101,
     575,   995,   997,  1002,    -1,   936,    -1,   195,    -1,  1302,
      -1,  1090,    -1,  1091,    -1,    -1,  1091,    -1,  1090,    -1,
    1091,  1090,    -1,  1090,  1091,    -1,    12,  1372,   132,    -1,
      12,  1372,  1503,    -1,   286,  1372,   132,    -1,   286,  1372,
    1503,    -1,    -1,    81,    -1,    -1,   235,    -1,    -1,  1095,
    1096,    -1,    -1,  1097,    -1,  1097,  1098,    -1,  1098,    -1,
     235,    -1,   380,    -1,    -1,   462,    -1,    53,    -1,    -1,
       9,  1503,    -1,   190,    -1,    -1,   575,    -1,   166,    -1,
      20,    -1,    -1,   531,   504,   688,  1109,  1103,  1113,    -1,
      -1,   531,    13,   505,  1109,  1104,    -1,   538,   504,   688,
    1109,    -1,   538,    13,   505,  1109,    -1,   531,   577,  1106,
      -1,    -1,  1107,    -1,  1108,    -1,  1107,   656,  1108,    -1,
     631,    92,   509,    -1,   432,   379,    -1,   432,   636,    -1,
      -1,  1110,  1111,    -1,  1112,    -1,  1111,   656,  1112,    -1,
      -1,   527,    -1,   446,    -1,    -1,   601,  1114,    -1,   601,
     297,   166,  1500,    -1,   687,    -1,  1114,   656,   687,    -1,
      -1,    64,  1540,  1116,  1345,  1117,    -1,    -1,   428,    -1,
     182,    -1,    -1,   452,  1144,  1541,  1119,  1345,  1120,    -1,
      -1,  1121,    -1,  1122,    -1,  1122,  1121,    -1,   428,    -1,
     182,    -1,   607,    -1,   199,   349,    -1,    -1,    16,  1144,
    1540,  1124,  1125,    -1,  1126,    -1,  1125,   656,  1126,    -1,
    1346,  1127,    -1,    -1,   405,   197,  1128,    -1,    13,    -1,
      75,  1129,   238,  1131,    -1,    13,    -1,    -1,   654,  1130,
    1133,   655,    -1,    13,    -1,    -1,   654,  1132,  1134,   655,
      -1,    -1,  1503,    -1,  1133,   656,  1503,    -1,    -1,  1135,
      -1,  1134,   656,  1135,    -1,  1503,    -1,   417,    -1,    37,
    1500,    -1,    -1,    65,  1541,  1138,  1345,  1139,    -1,    -1,
    1140,    -1,  1141,    -1,  1141,  1140,    -1,   428,    -1,   186,
      -1,   329,    -1,   182,    -1,    60,    -1,   197,   603,    -1,
      -1,   382,  1144,  1540,  1143,  1345,    -1,    -1,   369,    -1,
     283,    -1,    -1,   450,  1540,  1146,  1148,    -1,   450,   605,
     716,  1147,    -1,  1508,   575,  1508,    -1,  1147,   656,  1508,
     575,  1508,    -1,  1149,    -1,  1148,   656,  1149,    -1,  1496,
     575,  1496,    -1,    -1,    51,   239,  1151,  1152,   253,  1156,
      -1,  1153,    -1,  1155,    -1,  1154,    -1,  1153,   656,  1154,
      -1,  1496,  1165,    -1,  1496,  1163,  1165,    -1,  1503,    -1,
     132,    -1,    -1,   282,   239,   250,    51,  1158,  1159,    -1,
    1162,    -1,  1160,    -1,  1161,    -1,  1160,   656,  1161,    -1,
    1496,  1165,  1168,    -1,  1496,  1163,  1165,  1168,    -1,    -1,
     401,   877,  1164,   654,  1073,   655,    -1,    -1,  1166,  1167,
      -1,    -1,  1029,   654,  1284,   655,    -1,    -1,   235,   270,
      -1,  1170,    -1,   486,  1173,    -1,   654,  1171,   655,  1604,
      -1,   486,  1175,    -1,   654,  1171,   655,    -1,   486,  1263,
      -1,   654,  1172,   655,    -1,    -1,  1175,  1174,  1601,    -1,
      -1,    -1,  1176,  1180,  1184,  1177,  1178,  1183,    -1,  1305,
    1311,    -1,  1334,    -1,  1179,    -1,  1334,  1179,    -1,  1179,
    1334,    -1,   199,  1243,  1294,  1299,  1296,  1305,  1311,  1325,
      -1,   199,   151,  1294,  1311,    -1,    -1,  1181,    -1,  1181,
    1182,    -1,  1182,    -1,  1618,    -1,   524,    -1,   522,    -1,
      -1,   197,   602,    -1,   286,   253,   496,   340,    -1,  1184,
     656,  1185,    -1,  1185,    -1,   649,    -1,  1186,  1490,  1187,
      -1,  1186,  1192,  1187,  1188,    -1,    -1,    -1,    -1,    20,
    1503,    -1,    20,  1500,    -1,  1503,    -1,  1500,    -1,    -1,
     654,   655,    -1,   654,  1319,   655,    -1,    -1,   654,   655,
      -1,   654,  1319,   655,    -1,    -1,   654,   655,    -1,  1192,
    1196,  1192,    -1,  1192,   640,  1192,    -1,  1192,  1197,  1192,
      -1,   365,  1192,    -1,  1193,   256,   582,    -1,  1193,   256,
    1198,   582,    -1,  1193,   256,   185,    -1,  1193,   256,  1198,
     185,    -1,  1193,   256,   598,    -1,  1193,   256,  1198,   598,
      -1,  1193,    -1,  1193,   256,   370,    -1,  1193,   256,  1198,
     370,    -1,  1193,   167,  1194,    -1,  1193,  1200,  1194,    -1,
    1193,  1200,  1201,   654,  1613,   655,    -1,  1194,    -1,  1195,
     253,   654,  1613,   655,    -1,  1195,  1198,   253,   654,  1613,
     655,    -1,  1195,   253,   654,  1192,   655,    -1,  1195,   253,
     654,  1192,   656,  1236,   655,    -1,  1195,  1198,   253,   654,
    1192,   655,    -1,  1195,  1198,   253,   654,  1192,   656,  1236,
     655,    -1,  1195,    34,  1195,    18,  1194,    -1,  1195,  1198,
      34,  1195,    18,  1194,    -1,  1195,   513,   276,  1195,    -1,
    1195,   276,  1206,  1298,    -1,  1195,  1198,   276,  1206,  1298,
      -1,  1195,   441,  1195,    -1,  1195,  1198,   441,  1195,    -1,
    1195,    -1,  1195,   645,  1195,    -1,  1195,   646,  1195,    -1,
    1195,   497,  1195,    -1,  1195,   498,  1195,    -1,  1195,   648,
    1195,    -1,  1195,   647,  1195,    -1,  1195,   648,   249,  1192,
    1288,    -1,  1195,   647,   249,  1192,  1288,    -1,  1195,   649,
    1195,    -1,  1195,   650,  1195,    -1,  1195,   651,  1195,    -1,
    1195,   147,  1195,    -1,  1195,   343,  1195,    -1,  1195,   652,
    1195,    -1,  1206,    -1,   389,    -1,   386,    -1,    18,    -1,
      17,    -1,   365,    -1,   364,    -1,   657,    -1,   364,    -1,
     166,    -1,   203,    -1,   215,    -1,   268,    -1,   295,    -1,
     358,    -1,    13,    -1,    19,    -1,    -1,    20,  1203,    -1,
     251,    -1,   600,   251,    -1,   148,    -1,   434,    -1,   193,
      -1,   130,   982,    -1,   976,  1007,    -1,   977,    -1,   122,
      -1,   571,   988,    -1,   119,   988,    -1,  1192,   656,  1192,
    1202,    -1,  1204,    -1,  1205,   656,  1204,    -1,  1492,    -1,
    1207,    -1,  1208,    -1,  1211,    -1,  1209,    -1,  1206,    73,
    1505,    -1,  1486,    -1,  1484,    -1,  1223,    -1,  1219,    -1,
    1206,   388,  1206,    -1,   648,  1206,    -1,   647,  1206,    -1,
     653,  1206,    -1,  1199,  1206,    -1,   654,  1613,   655,    -1,
     654,  1192,   655,    -1,   654,  1192,   656,  1236,   655,    -1,
     477,   654,  1192,   656,  1236,   655,    -1,   178,   654,  1613,
     655,    -1,   658,  1503,  1192,   659,    -1,   317,  1237,    10,
     654,  1195,  1213,   655,    -1,    36,  1206,    -1,    56,   654,
    1192,    20,  1233,   655,    -1,    55,  1239,  1241,  1240,   160,
      -1,   101,   654,  1192,   656,  1233,   655,    -1,   101,   654,
    1192,   609,   996,   655,    -1,   132,   654,  1492,   655,    -1,
     613,   654,  1493,   655,    -1,   249,  1192,  1288,   648,  1192,
      -1,    62,   654,  1236,   655,    -1,    62,   654,  1236,   609,
     996,   655,    -1,   109,  1191,    -1,   110,  1191,    -1,   122,
     654,  1192,   655,    -1,   127,   654,  1192,   655,    -1,   229,
     654,  1192,   655,    -1,   246,   654,  1192,   656,  1192,   656,
    1192,   656,  1192,   655,    -1,   249,   654,  1192,   656,  1192,
     655,    -1,   249,   654,  1192,   656,  1192,   656,  1236,   655,
      -1,   272,   654,  1192,   656,  1192,   655,    -1,   337,   654,
    1192,   655,    -1,   344,   654,  1192,   655,    -1,   470,   654,
    1192,   656,  1192,   655,    -1,   484,   654,  1192,   655,    -1,
     571,   654,  1192,   655,    -1,   568,   654,  1192,   655,    -1,
     568,   654,  1192,   656,  1192,   655,    -1,   581,   654,  1192,
     655,    -1,   581,   654,   269,  1192,   199,  1192,   655,    -1,
     581,   654,   576,  1192,   199,  1192,   655,    -1,   581,   654,
      47,  1192,   199,  1192,   655,    -1,   581,   654,   269,   199,
    1192,   655,    -1,   581,   654,   576,   199,  1192,   655,    -1,
     581,   654,    47,   199,  1192,   655,    -1,   581,   654,  1192,
     199,  1192,   655,    -1,   605,   654,   655,    -1,   642,   654,
    1192,   655,    -1,     8,   654,  1192,   656,  1192,   655,    -1,
       8,   654,  1192,   656,   249,  1192,  1288,   655,    -1,   107,
    1191,    -1,   114,  1190,    -1,   120,   654,  1192,   656,   249,
    1192,  1288,   655,    -1,   121,   654,  1192,   656,   249,  1192,
    1288,   655,    -1,   184,   654,  1288,   199,  1192,   655,    -1,
     208,   654,  1290,   656,  1192,   655,    -1,   366,  1190,    -1,
     412,   654,  1195,   253,  1192,   655,    -1,   543,   654,  1192,
     656,  1192,   655,    -1,   543,   654,  1192,   656,   249,  1192,
    1288,   655,    -1,   547,   654,  1192,   656,  1192,   656,  1192,
     655,    -1,   547,   654,  1192,   656,  1192,   655,    -1,   547,
     654,  1192,   199,  1192,   197,  1192,   655,    -1,   547,   654,
    1192,   199,  1192,   655,    -1,   553,  1190,    -1,   569,   654,
    1289,   656,  1192,   656,  1192,   655,    -1,   570,   654,  1289,
     656,  1192,   656,  1192,   655,    -1,   610,  1191,    -1,   612,
    1190,    -1,   611,  1190,    -1,    76,   654,  1192,   656,  1205,
     655,    -1,    79,   654,  1192,   656,  1236,   655,    -1,    77,
     654,  1192,   655,    -1,    78,   654,  1205,   655,    -1,    80,
     654,  1192,   656,  1192,    20,  1233,   655,    -1,    22,   654,
    1192,   655,    -1,    61,   654,  1192,   655,    -1,    71,   654,
    1236,   655,    -1,    74,   654,  1192,   655,    -1,   115,   654,
     655,    -1,   234,   654,  1192,   656,  1192,   656,  1192,   655,
      -1,   267,   654,  1236,   655,    -1,   333,   654,  1192,   655,
      -1,   343,   654,  1192,   656,  1192,   655,    -1,   376,   654,
    1192,   655,    -1,   404,   654,  1192,   655,    -1,   426,   654,
    1192,   655,    -1,   454,   654,  1192,   656,  1192,   655,    -1,
     455,   654,  1192,   656,  1192,   656,  1192,   655,    -1,   468,
     654,  1192,   655,    -1,   478,   654,   655,    -1,   583,   654,
    1192,   656,  1192,   655,    -1,   626,   654,  1192,   655,    -1,
     626,   654,  1192,   656,  1192,   655,    -1,   627,   654,  1192,
    1019,   655,    -1,   627,   654,  1192,    20,    62,  1009,  1019,
     655,    -1,   627,   654,  1192,    20,    36,  1009,   655,    -1,
     627,   654,  1192,   656,  1318,   656,  1318,   656,  1318,   655,
      -1,  1210,    -1,    97,   654,  1192,   656,  1192,   655,    -1,
     206,   654,  1236,   655,    -1,   280,   654,  1236,   655,    -1,
     345,   654,  1236,   655,    -1,   346,   654,  1236,   655,    -1,
     347,   654,  1236,   655,    -1,   409,   654,  1192,   656,  1192,
     655,    -1,   410,   654,  1236,   655,    -1,    -1,  1499,   654,
    1212,  1216,   655,    -1,  1503,   662,  1503,   654,  1235,   655,
      -1,  1214,  1215,    -1,   253,    45,   340,    -1,    -1,   253,
     354,   265,   340,    -1,    -1,   631,   427,   180,    -1,    -1,
    1217,    -1,  1218,    -1,  1217,   656,  1218,    -1,  1186,  1192,
    1187,  1188,    -1,    30,   654,  1231,   655,    -1,    30,   654,
     146,  1231,   655,    -1,    39,   654,  1231,   655,    -1,    40,
     654,  1231,   655,    -1,    42,   654,  1231,   655,    -1,   102,
     654,  1293,   649,   655,    -1,   102,   654,  1231,   655,    -1,
      -1,    -1,   102,   654,   146,  1220,  1236,  1221,   655,    -1,
     339,   654,  1231,   655,    -1,   339,   654,   146,  1231,   655,
      -1,   322,   654,  1231,   655,    -1,   322,   654,   146,  1231,
     655,    -1,   537,   654,  1231,   655,    -1,   618,   654,  1231,
     655,    -1,   536,   654,  1231,   655,    -1,   620,   654,  1231,
     655,    -1,   548,   654,  1231,   655,    -1,   548,   654,   146,
    1231,   655,    -1,    -1,   214,   654,  1226,  1222,  1236,  1228,
    1227,   655,    -1,    -1,   661,  1224,  1225,    -1,  1505,   495,
    1192,    -1,  1505,    -1,   661,  1527,  1505,  1053,    -1,    -1,
     146,    -1,    -1,   488,  1482,    -1,    -1,    -1,   387,    49,
    1229,  1230,    -1,  1230,   656,  1491,  1309,    -1,  1491,  1309,
      -1,    -1,  1293,  1232,  1192,    -1,    36,   988,    -1,    62,
     988,  1007,    -1,   356,   988,    -1,   251,    -1,   502,    -1,
     502,   251,    -1,   600,    -1,   600,   251,    -1,   122,    -1,
     571,   988,    -1,   119,   988,    -1,   130,   982,    -1,    -1,
     148,  1234,   989,    -1,    -1,  1236,    -1,  1192,    -1,  1236,
     656,  1192,    -1,  1238,    -1,   654,  1238,   655,    -1,  1492,
      -1,  1238,   656,  1492,    -1,    -1,  1192,    -1,    -1,   156,
    1192,    -1,   628,  1192,   567,  1192,    -1,  1241,   628,  1192,
     567,  1192,    -1,  1257,    -1,  1246,    -1,  1245,    -1,  1242,
      -1,   658,  1503,  1242,   659,    -1,  1244,    -1,  1245,   656,
    1244,    -1,  1242,  1254,  1242,    -1,    -1,  1242,  1254,  1242,
     377,  1247,  1192,    -1,    -1,  1242,  1254,  1242,   609,  1248,
     654,  1287,   655,    -1,  1242,   354,  1253,  1257,    -1,    -1,
    1242,   272,  1273,   260,  1242,   377,  1249,  1192,    -1,    -1,
    1242,   272,  1273,   260,  1257,  1250,   609,   654,  1287,   655,
      -1,  1242,   354,   272,  1273,   260,  1257,    -1,    -1,  1242,
     470,  1273,   260,  1242,   377,  1251,  1192,    -1,    -1,  1242,
     470,  1273,   260,  1257,  1252,   609,   654,  1287,   655,    -1,
    1242,   354,   470,  1273,   260,  1257,    -1,   260,    -1,   243,
     260,    -1,   540,    -1,  1253,    -1,   105,   260,    -1,    -1,
    1256,    -1,   401,   654,  1287,   655,   877,    -1,    -1,  1258,
    1496,  1255,  1292,  1282,    -1,  1272,  1271,  1268,    -1,   654,
    1271,  1259,   655,  1292,    -1,  1266,  1605,    -1,    -1,    -1,
    1259,   596,  1609,  1260,  1610,  1261,  1605,    -1,  1263,    -1,
      -1,    -1,  1264,  1616,  1184,  1265,   946,  1183,    -1,    -1,
    1271,  1267,  1245,    -1,    -1,    -1,  1269,  1180,  1184,  1270,
     946,    -1,    -1,   486,    -1,    -1,   390,    -1,    -1,   197,
     260,    -1,   197,   387,    49,    -1,   197,   213,    49,    -1,
     195,    -1,   235,    -1,    -1,  1275,  1029,  1274,  1277,   654,
    1286,   655,    -1,    -1,   608,  1029,  1274,  1278,   654,  1284,
     655,    -1,  1276,    -1,  1279,  1276,    -1,    -1,    -1,  1281,
    1279,    -1,    -1,  1283,  1280,    -1,    -1,  1286,    -1,  1503,
      -1,   417,    -1,  1285,    -1,  1286,   656,  1285,    -1,  1503,
      -1,  1287,   656,  1503,    -1,  1289,    -1,   123,    -1,   124,
      -1,   125,    -1,   126,    -1,   226,    -1,   227,    -1,   228,
      -1,   335,    -1,   336,    -1,   483,    -1,   641,    -1,   127,
      -1,   626,    -1,   229,    -1,   337,    -1,   344,    -1,   426,
      -1,   484,    -1,   333,    -1,   642,    -1,   122,    -1,   571,
      -1,   119,    -1,   568,    -1,    -1,    20,    -1,   166,    -1,
      -1,  1291,  1503,    -1,    -1,    13,    -1,    -1,    -1,   629,
    1295,  1192,    -1,    -1,    -1,   219,  1297,  1192,    -1,   171,
    1206,    -1,    -1,    -1,   213,    49,  1300,  1301,    -1,  1300,
     656,  1491,  1309,    -1,  1491,  1309,    -1,    -1,   632,    -1,
     633,    -1,   387,    49,  1303,    -1,  1303,   656,  1304,    -1,
    1304,    -1,  1493,  1309,    -1,    -1,  1306,    -1,    -1,   387,
      49,  1307,  1308,    -1,  1308,   656,  1491,  1309,    -1,  1491,
    1309,    -1,    -1,    21,    -1,   137,    -1,    -1,  1312,    -1,
      -1,  1312,    -1,   277,  1313,    -1,   277,  1313,   475,   176,
    1315,    -1,   277,   475,   176,  1315,    -1,  1314,    -1,  1314,
     656,  1314,    -1,  1314,   375,  1314,    -1,  1503,    -1,  1484,
      -1,   587,    -1,   291,    -1,   371,    -1,  1314,    -1,    -1,
     277,  1314,    -1,   277,   475,   176,    -1,   277,  1314,   475,
     176,    -1,   371,    -1,   647,   371,    -1,   647,   291,    -1,
     371,    -1,   221,    -1,   291,    -1,   587,    -1,   129,    -1,
     192,    -1,   371,    -1,   221,    -1,   291,    -1,   587,    -1,
    1322,    -1,   371,    -1,   587,    -1,   291,    -1,   129,    -1,
     192,    -1,   371,    -1,   587,    -1,   221,    -1,   291,    -1,
    1322,    -1,  1323,    -1,   129,    -1,   192,    -1,  1318,    -1,
     132,    -1,    -1,    -1,   419,  1503,  1326,   654,  1327,   655,
      -1,    -1,  1328,    -1,  1328,   656,  1329,    -1,  1329,    -1,
    1186,  1192,  1187,    -1,    -1,  1331,  1332,    -1,  1332,   656,
    1333,    -1,  1333,    -1,   661,  1505,    -1,  1505,    -1,    -1,
     250,  1335,  1336,    -1,    -1,    -1,   391,  1502,  1337,   998,
    1338,  1466,  1469,    -1,   152,  1502,    -1,  1330,    -1,    -1,
     149,  1340,  1236,    -1,    -1,   150,  1351,  1540,  1350,  1342,
    1345,  1099,    -1,    -1,   150,   239,  1350,  1503,   377,  1496,
    1343,    -1,   150,   115,  1350,  1503,    -1,   150,   202,  1350,
    1503,   662,  1503,    -1,   150,   202,  1350,  1503,    -1,   150,
     419,  1350,   717,    -1,   150,   605,   716,  1577,    -1,   150,
     471,   716,  1561,    -1,    -1,   150,   622,  1350,  1344,  1345,
    1099,    -1,   150,   173,  1350,   717,    -1,   150,   580,  1350,
     717,    -1,   150,   555,   851,   862,   863,    -1,   150,   287,
     213,   852,   862,   863,    -1,   150,   492,  1350,  1505,    -1,
    1346,    -1,  1345,   656,  1346,    -1,  1496,    -1,  1496,  1255,
      -1,  1349,    -1,  1348,   656,  1349,    -1,  1497,    -1,    -1,
     234,   178,    -1,    -1,   561,    -1,    -1,    -1,   246,  1353,
    1358,  1093,  1360,  1354,  1362,  1378,    -1,    -1,    -1,   455,
    1356,  1359,  1360,  1357,  1362,    -1,    -1,   294,    -1,   134,
      -1,   223,    -1,  1387,    -1,   134,    -1,   250,  1361,    -1,
    1361,    -1,  1347,    -1,  1365,    -1,   654,   655,  1365,    -1,
     654,  1364,   655,  1365,    -1,    -1,   494,  1363,  1369,    -1,
    1364,   656,  1489,    -1,  1489,    -1,   613,  1368,    -1,   614,
    1368,    -1,    -1,   923,  1366,  1601,    -1,    -1,   654,   923,
     655,  1367,  1604,    -1,  1368,   656,  1373,    -1,  1373,    -1,
    1369,   656,  1370,    -1,  1370,    -1,  1493,  1371,  1377,    -1,
     166,    -1,   495,    -1,    -1,  1371,    -1,    -1,   654,  1374,
    1375,   655,    -1,    -1,  1376,    -1,  1376,   656,  1377,    -1,
    1377,    -1,  1192,    -1,   132,    -1,    -1,    -1,   377,   153,
    1379,   263,   602,  1385,    -1,    -1,    -1,   602,  1381,  1387,
    1093,  1243,   494,  1383,  1382,  1294,  1305,  1316,    -1,  1383,
     656,  1384,    -1,  1384,    -1,  1493,  1371,  1377,    -1,  1385,
     656,  1386,    -1,  1386,    -1,  1493,  1371,  1377,    -1,    -1,
     294,    -1,    -1,   136,  1389,  1399,  1390,    -1,    -1,    -1,
     199,  1496,  1255,  1391,  1294,  1305,  1316,  1392,  1395,    -1,
      -1,  1396,  1393,   199,  1243,  1294,    -1,    -1,   199,  1348,
    1394,   609,  1243,  1294,    -1,    -1,   465,  1184,    -1,  1397,
      -1,  1396,   656,  1397,    -1,  1503,  1398,    -1,  1503,   662,
    1503,  1398,    -1,    -1,   662,   649,    -1,    -1,  1400,  1399,
      -1,   428,    -1,   294,    -1,   235,    -1,    -1,   583,  1403,
    1402,  1346,    -1,    -1,   558,    -1,    -1,  1405,    -1,  1406,
      -1,  1405,   656,  1406,    -1,   103,    -1,   330,    -1,    44,
     254,    -1,    98,   552,    -1,   395,   187,    -1,   255,    -1,
     551,    -1,   514,    -1,    13,    -1,    -1,   197,   427,   371,
      -1,    -1,   499,  1409,  1410,    -1,   116,  1421,    -1,  1417,
     554,  1416,  1421,    -1,  1417,   579,  1416,  1421,    -1,   172,
    1416,  1421,    -1,   558,   535,  1416,  1421,    -1,   381,   554,
    1416,  1421,    -1,   407,    -1,   407,   512,  1500,    -1,   407,
     512,  1421,    -1,   164,   943,  1413,    -1,   164,    13,  1413,
      -1,  1417,    75,  1418,  1496,  1416,  1421,    -1,  1414,   288,
      -1,   504,   225,    -1,    -1,    37,   172,  1419,  1420,  1411,
    1310,    -1,    -1,   443,   688,   172,  1419,  1420,  1412,  1310,
      -1,  1031,  1418,  1496,  1416,  1294,    -1,  1415,   163,    -1,
      25,    -1,   100,    -1,   418,    -1,   102,   654,   649,   655,
     625,    -1,   102,   654,   649,   655,   169,    -1,   625,  1310,
      -1,   169,  1310,    -1,   423,    -1,   422,  1404,  1407,  1310,
      -1,  1526,   535,  1421,    -1,  1417,   421,    -1,  1526,   617,
    1421,    -1,   995,  1421,    -1,    74,  1421,    -1,   212,    -1,
     212,   197,  1507,    -1,   104,   115,   933,  1503,    -1,   104,
     558,  1496,    -1,   104,   622,  1496,    -1,   313,   535,    -1,
      13,   505,   535,    -1,   504,   535,    -1,   504,   689,   535,
      -1,    69,    -1,   606,    -1,   557,    -1,   240,    -1,   104,
     419,   717,    -1,   104,   202,   717,    -1,   104,   580,   717,
      -1,   419,   535,  1421,    -1,   202,   535,  1421,    -1,   419,
      72,   717,    -1,   202,    72,   717,    -1,   104,   173,   717,
      -1,  1426,   197,  1192,    -1,   535,    -1,   348,    -1,   288,
      -1,   313,    -1,    36,    -1,    -1,   539,    -1,    -1,  1418,
    1503,    -1,    -1,   200,    -1,   199,    -1,   253,    -1,    -1,
     253,  1500,    -1,    -1,   199,  1320,    -1,    -1,   276,  1500,
      -1,   629,  1192,    -1,    -1,  1426,  1496,  1423,  1428,    -1,
      -1,  1426,  1427,  1424,  1425,    -1,  1169,    -1,  1352,    -1,
    1355,    -1,  1380,    -1,  1388,    -1,   137,    -1,   138,    -1,
      -1,   182,    -1,   402,    -1,    -1,  1482,    -1,  1503,    -1,
      -1,   194,  1144,  1430,  1431,    -1,    -1,  1540,  1432,  1438,
    1433,    -1,  1436,    -1,    -1,  1434,    -1,   631,   432,   286,
    1439,    -1,    -1,   197,  1435,   181,    -1,  1436,   656,  1437,
      -1,  1437,    -1,   168,   288,    -1,   164,   288,    -1,   204,
     288,    -1,   507,   288,    -1,    36,   288,    -1,   442,   288,
     688,    -1,   427,    51,    -1,   225,    -1,   418,    -1,   288,
      -1,   535,    -1,   504,   688,    -1,    69,    -1,   606,    -1,
     557,    -1,   240,    -1,   313,    -1,   139,    -1,   460,    -1,
      -1,  1345,    -1,    -1,    18,   143,    63,    -1,    -1,   458,
    1441,  1442,    -1,  1442,   656,  1443,    -1,  1443,    -1,    -1,
     504,  1444,   688,  1445,    -1,   313,    -1,   427,    51,    -1,
      -1,    13,    -1,    -1,   425,  1447,  1448,    -1,  1414,   288,
    1449,    -1,   575,  1500,    -1,    32,  1192,    -1,    -1,   264,
    1451,  1452,  1453,  1454,    -1,    -1,   217,    -1,   511,    -1,
      -1,    91,    -1,   427,    -1,   427,   230,    -1,  1192,    -1,
     605,  1508,    -1,   500,    -1,   608,  1503,    -1,    -1,    -1,
      -1,    -1,   282,  1462,  1458,  1464,  1463,   241,  1502,  1459,
    1465,   250,   558,  1496,  1255,  1460,   998,  1461,  1472,  1466,
    1469,  1473,  1475,  1478,    -1,   118,    -1,   639,    -1,    -1,
     283,    -1,    -1,    89,    -1,   294,    -1,    -1,   455,    -1,
     235,    -1,    -1,    75,  1467,    -1,  1467,  1468,    -1,  1468,
      -1,   563,    49,  1482,    -1,   385,   159,    49,  1482,    -1,
     159,    49,  1482,    -1,   170,    49,  1482,    -1,    -1,   279,
    1470,    -1,  1470,  1471,    -1,  1471,    -1,   563,    49,  1482,
      -1,   529,    49,  1482,    -1,    -1,   475,   232,    49,  1482,
      -1,    -1,   235,   371,  1474,    -1,   279,    -1,   475,    -1,
      -1,   654,  1476,   655,    -1,   654,   655,    -1,  1476,   656,
    1477,    -1,  1477,    -1,  1493,    -1,   661,  1505,    -1,    -1,
     494,  1479,    -1,  1479,   656,  1480,    -1,  1480,    -1,  1493,
    1371,  1186,  1377,  1187,    -1,   564,    -1,   355,    -1,   590,
     564,    -1,  1481,  1501,    -1,  1501,    -1,  1483,    -1,   221,
      -1,   222,    -1,    38,    -1,   397,    -1,  1486,    -1,   648,
    1487,    -1,   647,  1487,    -1,  1481,    -1,  1487,    -1,  1488,
      -1,   370,    -1,   185,    -1,   582,    -1,   221,    -1,   222,
      -1,    38,    -1,   590,  1483,    -1,   371,    -1,   291,    -1,
     587,    -1,   129,    -1,   192,    -1,   122,   564,    -1,   571,
     564,    -1,   568,   564,    -1,  1493,    -1,  1490,    -1,  1503,
     662,   649,    -1,  1503,   662,  1503,   662,   649,    -1,  1192,
      -1,  1503,    -1,  1494,    -1,  1503,    -1,  1494,    -1,  1503,
     662,  1503,    -1,   662,  1503,   662,  1503,    -1,  1503,   662,
    1503,   662,  1503,    -1,  1503,    -1,  1503,   662,  1503,   662,
    1503,    -1,  1503,   662,  1503,    -1,   662,  1503,    -1,  1503,
      -1,  1503,   662,  1503,    -1,   662,  1503,    -1,  1503,  1398,
      -1,  1503,   662,  1503,  1398,    -1,  1503,    -1,   231,    -1,
     233,    -1,   564,    -1,   564,    -1,   564,    -1,  1499,    -1,
    1509,    -1,  1499,    -1,  1510,    -1,  1503,    -1,  1500,    -1,
     275,    -1,  1505,    -1,  1505,   661,  1505,    -1,   109,  1191,
      -1,  1506,    -1,  1562,    -1,  1506,    -1,  1510,    -1,    22,
      -1,    31,    -1,    33,    -1,    50,    -1,    51,    -1,    61,
      -1,    64,    -1,    63,    -1,    70,    -1,    76,    -1,    77,
      -1,    78,    -1,    79,    -1,    80,    -1,    83,    -1,    85,
      -1,    97,    -1,   128,    -1,   149,    -1,   160,    -1,   176,
      -1,   177,    -1,   194,    -1,   209,    -1,   216,    -1,   220,
      -1,   224,    -1,   248,    -1,   265,    -1,   367,    -1,   381,
      -1,   384,    -1,   383,    -1,   393,    -1,   398,    -1,   411,
      -1,   414,    -1,   449,    -1,   452,    -1,   458,    -1,   461,
      -1,   472,    -1,   480,    -1,   485,    -1,   492,    -1,   500,
      -1,   502,    -1,   510,    -1,   504,    -1,   505,    -1,   512,
      -1,   531,    -1,   538,    -1,   583,    -1,   594,    -1,   595,
      -1,   635,    -1,   638,    -1,   603,    -1,     5,    -1,     8,
      -1,     7,    -1,     9,    -1,    10,    -1,    11,    -1,    12,
      -1,    15,    -1,    19,    -1,    24,    -1,    25,    -1,    27,
      -1,    26,    -1,    28,    -1,    29,    -1,    30,    -1,    37,
      -1,    41,    -1,    44,    -1,    46,    -1,    45,    -1,    48,
      -1,    54,    -1,    57,    -1,    58,    -1,    60,    -1,    66,
      -1,    69,    -1,    68,    -1,    67,    -1,    71,    -1,    72,
      -1,    74,    -1,    82,    -1,    75,    -1,    84,    -1,    86,
      -1,    87,    -1,    88,    -1,    89,    -1,    91,    -1,    92,
      -1,    94,    -1,    96,    -1,    95,    -1,    98,    -1,   100,
      -1,   111,    -1,   103,    -1,   106,    -1,   108,    -1,   113,
      -1,   118,    -1,   117,    -1,   119,    -1,   122,    -1,   127,
      -1,   133,    -1,   135,    -1,   139,    -1,   141,    -1,   142,
      -1,   143,    -1,   144,    -1,   145,    -1,   152,    -1,   153,
      -1,   154,    -1,   161,    -1,   165,    -1,   164,    -1,   163,
      -1,   168,    -1,   169,    -1,   171,    -1,   173,    -1,   172,
      -1,   174,    -1,   175,    -1,   180,    -1,   181,    -1,   182,
      -1,   183,    -1,   187,    -1,   186,    -1,   198,    -1,   158,
      -1,   200,    -1,   189,    -1,   190,    -1,   191,    -1,   204,
      -1,   205,    -1,   207,    -1,   206,    -1,   208,    -1,   212,
      -1,   210,    -1,   218,    -1,   217,    -1,   225,    -1,   229,
      -1,   230,    -1,   232,    -1,   236,    -1,   240,    -1,   252,
      -1,   237,    -1,   238,    -1,   242,    -1,   254,    -1,   255,
      -1,   257,    -1,   258,    -1,   247,    -1,   262,    -1,   267,
      -1,   266,    -1,   270,    -1,   273,    -1,   274,    -1,   280,
      -1,   281,    -1,   283,    -1,   285,    -1,   287,    -1,   288,
      -1,   320,    -1,   313,    -1,   316,    -1,   297,    -1,   298,
      -1,   302,    -1,   299,    -1,   300,    -1,   314,    -1,   315,
      -1,   301,    -1,   303,    -1,   296,    -1,   311,    -1,   305,
      -1,   304,    -1,   306,    -1,   307,    -1,   308,    -1,   309,
      -1,   310,    -1,   318,    -1,   319,    -1,   321,    -1,   323,
      -1,   324,    -1,   329,    -1,   330,    -1,   331,    -1,   332,
      -1,   333,    -1,   334,    -1,   337,    -1,   338,    -1,   342,
      -1,   340,    -1,   344,    -1,   345,    -1,   346,    -1,   347,
      -1,   348,    -1,   349,    -1,   350,    -1,   352,    -1,   351,
      -1,   353,    -1,   356,    -1,   357,    -1,   361,    -1,   360,
      -1,   368,    -1,   362,    -1,   363,    -1,   372,    -1,   374,
      -1,   375,    -1,   376,    -1,   378,    -1,   380,    -1,   379,
      -1,   394,    -1,   395,    -1,   400,    -1,   403,    -1,   402,
      -1,   404,    -1,   405,    -1,   406,    -1,   408,    -1,   407,
      -1,   409,    -1,   410,    -1,   415,    -1,   416,    -1,   418,
      -1,   420,    -1,   421,    -1,   422,    -1,   423,    -1,   424,
      -1,   426,    -1,   427,    -1,   428,    -1,   431,    -1,   435,
      -1,   436,    -1,   438,    -1,   437,    -1,   439,    -1,   442,
      -1,   443,    -1,   444,    -1,   445,    -1,   446,    -1,   448,
      -1,   451,    -1,   453,    -1,   456,    -1,   460,    -1,   463,
      -1,   464,    -1,   466,    -1,   468,    -1,   471,    -1,   473,
      -1,   474,    -1,   475,    -1,   478,    -1,   476,    -1,   477,
      -1,   479,    -1,   481,    -1,   482,    -1,   484,    -1,   490,
      -1,   489,    -1,   491,    -1,   503,    -1,   496,    -1,   506,
      -1,   507,    -1,   509,    -1,   511,    -1,   513,    -1,   514,
      -1,   522,    -1,   521,    -1,   524,    -1,   527,    -1,   530,
      -1,   535,    -1,   539,    -1,   541,    -1,   542,    -1,   543,
      -1,   544,    -1,   546,    -1,   545,    -1,   549,    -1,   550,
      -1,   551,    -1,   552,    -1,   560,    -1,   557,    -1,   554,
      -1,   559,    -1,   555,    -1,   561,    -1,   562,    -1,   565,
      -1,   566,    -1,   577,    -1,   578,    -1,   579,    -1,   568,
      -1,   569,    -1,   570,    -1,   571,    -1,   584,    -1,   585,
      -1,   586,    -1,   202,    -1,   588,    -1,   589,    -1,   592,
      -1,   591,    -1,   598,    -1,   601,    -1,   605,    -1,   606,
      -1,   607,    -1,   617,    -1,   622,    -1,   623,    -1,   614,
      -1,   625,    -1,   624,    -1,   626,    -1,   627,    -1,   634,
      -1,   637,    -1,   639,    -1,   642,    -1,   621,    -1,    -1,
     494,  1512,  1513,    -1,    -1,  1529,  1514,  1519,    -1,    -1,
     577,  1515,  1531,    -1,    -1,  1525,  1516,  1517,    -1,    -1,
    1528,  1518,  1519,    -1,   577,  1531,    -1,    -1,   656,  1520,
      -1,    -1,  1521,  1523,    -1,    -1,  1520,   656,  1522,  1523,
      -1,    -1,  1525,  1524,  1528,    -1,  1529,    -1,   210,    -1,
     283,    -1,   491,    -1,    -1,   210,    -1,   283,    -1,   491,
      -1,    -1,   210,   662,    -1,   283,   662,    -1,   491,   662,
      -1,  1530,  1371,  1537,    -1,  1530,  1371,  1537,    -1,   661,
    1505,  1371,  1192,    -1,   661,   661,  1527,  1530,  1371,  1537,
      -1,   995,  1000,    -1,   351,  1371,  1192,    -1,   351,   997,
    1002,    -1,   471,  1505,    -1,   404,  1371,  1536,    -1,   404,
     197,  1508,  1371,  1536,    -1,  1503,    -1,  1503,   662,  1503,
      -1,   132,   662,  1503,    -1,  1532,    -1,  1533,    -1,  1532,
     656,  1533,    -1,  1533,   656,  1532,    -1,  1534,    -1,   257,
     274,  1535,    -1,   432,   379,    -1,   432,   636,    -1,   432,
     588,    -1,   432,    84,    -1,   453,   432,    -1,   489,    -1,
     564,    -1,   404,   654,   564,   655,    -1,   376,   654,   564,
     655,    -1,  1192,    -1,   132,    -1,   377,    -1,    13,    -1,
      36,    -1,    -1,   286,  1540,  1539,  1542,    -1,   558,    -1,
     554,    -1,  1540,    -1,   622,    -1,  1543,    -1,  1542,   656,
    1543,    -1,  1496,  1292,  1544,    -1,   432,    -1,   636,    -1,
     636,    89,    -1,   294,   636,    -1,   432,   283,    -1,    -1,
     599,  1546,  1540,    -1,   216,  1496,   381,  1292,    -1,   216,
    1498,    70,    -1,    -1,   216,  1498,   432,  1548,  1549,  1294,
    1311,    -1,  1550,    -1,  1503,  1551,    -1,   190,    -1,   361,
      -1,   190,    -1,   361,    -1,   416,    -1,   266,    -1,    -1,
    1553,  1552,   654,  1376,   655,    -1,   166,    -1,   203,    -1,
     268,    -1,   215,    -1,   295,    -1,   469,   716,  1555,    -1,
    1565,   377,  1564,  1576,   199,  1579,    -1,  1565,   377,   202,
    1576,   199,  1579,    -1,  1565,   377,   419,  1576,   199,  1579,
      -1,    13,  1566,   656,   211,   384,   199,  1579,    -1,   424,
     377,  1508,   199,  1577,    -1,  1556,   199,  1579,    -1,     7,
     384,   197,  1563,    -1,  1563,    -1,   211,   716,  1558,    -1,
    1565,   377,  1564,  1576,   575,  1578,  1586,  1587,    -1,  1565,
     377,   202,  1576,   575,  1578,  1586,  1587,    -1,  1565,   377,
     419,  1576,   575,  1578,  1586,  1587,    -1,   424,   377,  1508,
     575,  1578,  1588,    -1,  1563,   575,  1578,  1560,    -1,    -1,
     631,     7,  1507,    -1,    -1,   631,     7,   384,    -1,  1563,
      -1,  1561,   656,  1563,    -1,   110,  1191,    -1,  1505,    -1,
    1562,    -1,    -1,   558,    -1,  1567,    -1,    13,  1566,    -1,
      -1,   418,    -1,  1568,    -1,  1567,   656,  1568,    -1,    -1,
     486,  1569,  1583,    -1,    -1,   246,  1570,  1583,    -1,    -1,
     602,  1571,  1583,    -1,    -1,   440,  1572,  1583,    -1,   136,
      -1,   604,    -1,   239,    -1,    14,    -1,   104,    -1,   150,
      -1,   177,    -1,   448,    -1,   500,    -1,   420,    -1,   189,
      -1,   211,   384,    -1,   499,   116,    -1,   549,    -1,   104,
     561,   554,    -1,   286,   554,    -1,   456,   504,    -1,   456,
      68,    -1,   104,   622,    -1,   499,   622,    -1,   104,   474,
      -1,    14,   474,    -1,   104,   605,    -1,   173,    -1,   580,
      -1,   104,   555,    -1,    -1,    18,    -1,  1575,  1573,  1574,
      -1,  1575,    -1,   544,   564,    -1,   258,   564,    -1,    66,
     564,    -1,   649,    -1,  1503,   662,   649,    -1,   649,   662,
     649,    -1,  1496,    -1,  1508,    -1,  1577,   656,  1508,    -1,
    1582,    -1,  1578,   656,  1582,    -1,  1507,    -1,  1579,   656,
    1507,    -1,   621,    -1,   631,    -1,   609,    -1,    20,    -1,
    1508,   232,    49,   564,    -1,  1508,   232,    49,   404,   564,
      -1,  1508,   232,  1580,  1505,    -1,  1508,   232,  1580,  1505,
    1581,  1500,    -1,  1507,    -1,    -1,   654,  1584,   655,    -1,
    1584,   656,  1585,    -1,  1585,    -1,  1503,    -1,    -1,   457,
    1574,    -1,   457,   528,    -1,   457,   637,    -1,   457,   363,
      -1,    -1,   631,  1589,    -1,    -1,   631,   211,   384,    -1,
    1589,  1590,    -1,  1590,    -1,   211,   384,    -1,   319,  1318,
      -1,   323,  1318,    -1,   318,  1318,    -1,   324,  1317,    -1,
      -1,    33,  1592,  1593,    -1,    -1,   634,    -1,    -1,    18,
     367,    58,    -1,    18,    58,    -1,    -1,   447,    -1,   367,
     447,    -1,    -1,   480,    -1,    85,  1593,  1594,  1595,    -1,
     472,  1593,  1594,  1595,    -1,   472,  1593,   575,  1596,  1503,
      -1,   480,  1503,    -1,   447,   480,  1503,    -1,    -1,  1602,
      -1,    -1,   596,  1609,  1603,  1170,    -1,    -1,  1602,    -1,
    1606,    -1,    -1,  1606,    -1,    -1,  1607,  1608,    -1,  1306,
    1310,    -1,  1312,    -1,    -1,   146,    -1,    13,    -1,   486,
    1262,    -1,   654,  1172,   655,    -1,  1610,  1605,    -1,    -1,
    1611,   596,  1609,  1612,  1610,  1605,    -1,  1614,  1611,  1615,
      -1,    -1,    -1,    -1,  1617,    -1,  1617,  1618,    -1,  1618,
      -1,   540,    -1,   223,    -1,   146,    -1,   525,    -1,   520,
      -1,   521,    -1,   523,    -1,    13,    -1,  1624,  1620,    -1,
    1623,  1621,    -1,  1625,  1622,  1627,    -1,  1627,    -1,  1635,
      -1,  1646,    -1,  1640,    -1,   703,    -1,  1627,    -1,  1635,
      -1,  1646,    -1,  1640,    -1,  1639,    -1,   703,    -1,  1623,
      -1,  1624,    -1,    -1,   133,   166,  1507,    -1,    12,   166,
     589,    -1,    12,   166,   331,    -1,    12,   166,   562,    -1,
      -1,   526,   485,   133,    -1,   526,   485,   252,    -1,    -1,
    1626,   622,  1496,  1628,  1629,    20,  1631,    -1,    -1,   654,
    1630,   655,    -1,  1503,    -1,  1630,   656,  1503,    -1,    -1,
    1632,  1633,  1634,    -1,   486,  1173,    -1,   654,  1171,   655,
    1604,    -1,    -1,   631,    65,   384,    -1,   631,    54,    65,
     384,    -1,   631,   283,    65,   384,    -1,    -1,    -1,    -1,
     580,  1186,   717,   822,   823,   377,  1186,  1636,  1496,   197,
    1186,  1637,   155,   477,  1638,   772,    -1,    11,  1186,   202,
    1503,   466,   947,   512,  1500,    -1,  1186,   202,  1503,   466,
     947,   512,  1500,    -1,    -1,    -1,    -1,    -1,    -1,  1186,
     202,   717,   654,  1641,   728,   655,  1642,   466,  1643,   993,
    1644,   719,  1645,   772,    -1,    -1,    -1,    -1,    -1,   419,
    1186,   717,  1647,   654,  1648,   732,   655,  1649,   719,  1650,
     772,    -1,   638,  1653,  1652,  1654,    -1,   638,   160,  1652,
    1656,    -1,   638,   414,  1652,    -1,   638,    85,  1652,  1655,
      -1,   638,   472,  1652,    -1,   638,   436,    -1,  1482,    -1,
    1482,   656,  1482,    -1,  1482,   656,  1482,   656,  1318,    -1,
      33,    -1,   531,    -1,    -1,   260,    -1,   463,    -1,    -1,
     378,   406,    -1,    -1,    -1,   550,  1657,  1658,    -1,    -1,
     197,   334,    -1,   248,   408,  1503,   512,  1500,    -1,   248,
     512,  1500,    -1,   595,   408,  1503,    -1,   595,   512,  1500,
      -1,   644,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1941,  1941,  1953,  1952,  1977,  1984,  1986,  1990,  1991,
    1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,  2005,
    2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,  2015,
    2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,  2024,  2025,
    2026,  2027,  2028,  2029,  2030,  2031,  2032,  2033,  2034,  2035,
    2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,  2045,
    2046,  2047,  2048,  2049,  2050,  2054,  2063,  2064,  2068,  2077,
    2083,  2093,  2092,  2102,  2104,  2108,  2109,  2113,  2126,  2125,
    2145,  2144,  2153,  2154,  2158,  2162,  2166,  2170,  2174,  2178,
    2183,  2187,  2191,  2195,  2199,  2203,  2208,  2212,  2217,  2248,
    2253,  2256,  2258,  2259,  2263,  2269,  2273,  2289,  2293,  2299,
    2309,  2319,  2332,  2336,  2340,  2356,  2355,  2400,  2405,  2399,
    2412,  2417,  2410,  2424,  2429,  2422,  2435,  2434,  2447,  2446,
    2462,  2466,  2470,  2474,  2478,  2485,  2498,  2499,  2503,  2507,
    2511,  2515,  2519,  2523,  2527,  2535,  2534,  2565,  2564,  2571,
    2578,  2579,  2585,  2591,  2601,  2607,  2613,  2615,  2622,  2623,
    2627,  2633,  2642,  2643,  2651,  2651,  2707,  2708,  2709,  2710,
    2711,  2712,  2713,  2714,  2715,  2716,  2717,  2718,  2719,  2724,
    2738,  2754,  2772,  2773,  2777,  2778,  2783,  2785,  2787,  2789,
    2791,  2793,  2795,  2801,  2802,  2803,  2807,  2811,  2819,  2818,
    2831,  2833,  2836,  2838,  2842,  2846,  2853,  2855,  2859,  2860,
    2865,  2885,  2913,  2915,  2919,  2920,  2924,  2951,  2952,  2953,
    2954,  2958,  2959,  2963,  2964,  2969,  2972,  2999,  2998,  3062,
    3078,  3077,  3133,  3159,  3159,  3182,  3183,  3188,  3190,  3195,
    3217,  3228,  3232,  3254,  3255,  3259,  3263,  3272,  3278,  3284,
    3293,  3307,  3330,  3336,  3337,  3343,  3346,  3350,  3358,  3378,
    3380,  3398,  3404,  3406,  3408,  3410,  3412,  3414,  3416,  3418,
    3420,  3422,  3424,  3426,  3431,  3446,  3462,  3463,  3468,  3474,
    3483,  3489,  3498,  3506,  3515,  3524,  3526,  3535,  3540,  3546,
    3555,  3563,  3565,  3567,  3569,  3571,  3573,  3575,  3577,  3579,
    3581,  3583,  3585,  3587,  3592,  3610,  3631,  3632,  3636,  3637,
    3638,  3639,  3640,  3641,  3642,  3643,  3644,  3645,  3646,  3647,
    3648,  3653,  3652,  3659,  3659,  3714,  3713,  3742,  3742,  3757,
    3810,  3853,  3874,  3873,  3895,  3914,  3916,  3917,  3921,  3941,
    3964,  3966,  3982,  3964,  4001,  4003,  4004,  4008,  4009,  4014,
    4020,  4013,  4041,  4040,  4056,  4057,  4061,  4062,  4067,  4071,
    4066,  4092,  4096,  4091,  4115,  4125,  4130,  4129,  4164,  4165,
    4170,  4169,  4201,  4201,  4216,  4215,  4252,  4264,  4266,  4263,
    4293,  4292,  4313,  4315,  4320,  4322,  4324,  4341,  4346,  4352,
    4359,  4360,  4368,  4374,  4383,  4389,  4395,  4396,  4400,  4400,
    4405,  4406,  4407,  4411,  4412,  4413,  4417,  4421,  4422,  4423,
    4427,  4428,  4429,  4430,  4431,  4432,  4433,  4434,  4438,  4442,
    4443,  4444,  4448,  4449,  4450,  4451,  4452,  4456,  4460,  4461,
    4462,  4466,  4467,  4468,  4469,  4470,  4471,  4472,  4476,  4480,
    4481,  4482,  4486,  4487,  4488,  4493,  4501,  4509,  4517,  4529,
    4541,  4546,  4551,  4559,  4567,  4575,  4583,  4591,  4599,  4607,
    4620,  4633,  4646,  4648,  4652,  4657,  4670,  4671,  4723,  4722,
    4725,  4731,  4731,  4732,  4746,  4747,  4751,  4753,  4752,  4756,
    4755,  4761,  4798,  4799,  4804,  4803,  4822,  4841,  4840,  4857,
    4861,  4869,  4868,  4871,  4873,  4875,  4877,  4882,  4883,  4889,
    4890,  4907,  4908,  4912,  4913,  4917,  4936,  4946,  4957,  4966,
    4967,  4983,  4985,  4984,  4989,  4987,  4998,  4999,  5003,  5021,
    5037,  5038,  5054,  5069,  5091,  5092,  5097,  5096,  5120,  5130,
    5152,  5151,  5169,  5168,  5188,  5210,  5214,  5243,  5255,  5256,
    5261,  5272,  5260,  5297,  5298,  5302,  5315,  5336,  5349,  5375,
    5376,  5381,  5380,  5417,  5422,  5423,  5427,  5428,  5432,  5434,
    5440,  5446,  5448,  5450,  5452,  5454,  5456,  5466,  5481,  5465,
    5495,  5496,  5500,  5501,  5505,  5506,  5510,  5511,  5515,  5516,
    5520,  5521,  5525,  5530,  5534,  5542,  5546,  5552,  5554,  5558,
    5559,  5563,  5564,  5565,  5569,  5574,  5579,  5584,  5589,  5594,
    5599,  5604,  5619,  5625,  5640,  5645,  5660,  5666,  5684,  5689,
    5694,  5699,  5704,  5709,  5715,  5714,  5740,  5741,  5742,  5747,
    5752,  5757,  5759,  5761,  5763,  5769,  5774,  5779,  5785,  5791,
    5797,  5806,  5814,  5831,  5854,  5868,  5869,  5870,  5871,  5872,
    5873,  5874,  5878,  5879,  5880,  5884,  5885,  5889,  5890,  5891,
    5892,  5897,  5904,  5905,  5909,  5910,  5914,  5915,  5923,  5922,
    5931,  5929,  5939,  5937,  5947,  5945,  5953,  5974,  5980,  5982,
    5986,  5990,  5991,  5995,  6000,  5999,  6025,  6028,  6027,  6037,
    6039,  6044,  6047,  6051,  6058,  6059,  6063,  6064,  6068,  6074,
    6080,  6084,  6100,  6116,  6117,  6118,  6119,  6124,  6128,  6133,
    6138,  6142,  6147,  6152,  6158,  6163,  6169,  6173,  6178,  6183,
    6201,  6203,  6205,  6218,  6220,  6225,  6230,  6242,  6247,  6252,
    6257,  6259,  6261,  6263,  6265,  6267,  6269,  6271,  6274,  6273,
    6278,  6277,  6281,  6283,  6292,  6293,  6294,  6300,  6301,  6302,
    6303,  6304,  6308,  6312,  6313,  6317,  6318,  6322,  6323,  6324,
    6325,  6326,  6330,  6331,  6332,  6333,  6334,  6338,  6343,  6345,
    6351,  6352,  6354,  6359,  6368,  6369,  6373,  6374,  6378,  6379,
    6380,  6384,  6385,  6386,  6387,  6390,  6391,  6395,  6396,  6400,
    6401,  6405,  6406,  6410,  6411,  6412,  6413,  6420,  6421,  6427,
    6433,  6439,  6445,  6446,  6459,  6465,  6471,  6477,  6486,  6507,
    6513,  6518,  6519,  6523,  6531,  6535,  6536,  6540,  6541,  6545,
    6554,  6558,  6559,  6563,  6571,  6572,  6576,  6577,  6581,  6582,
    6587,  6588,  6592,  6599,  6608,  6613,  6621,  6622,  6623,  6624,
    6625,  6626,  6631,  6639,  6640,  6645,  6644,  6657,  6658,  6662,
    6665,  6666,  6667,  6668,  6672,  6680,  6687,  6688,  6692,  6702,
    6703,  6707,  6708,  6711,  6713,  6717,  6729,  6730,  6734,  6741,
    6754,  6755,  6757,  6759,  6765,  6770,  6776,  6782,  6789,  6799,
    6800,  6801,  6802,  6803,  6807,  6811,  6812,  6816,  6817,  6821,
    6822,  6826,  6827,  6828,  6832,  6833,  6837,  6841,  6854,  6866,
    6867,  6871,  6872,  6876,  6877,  6881,  6882,  6886,  6887,  6891,
    6892,  6896,  6897,  6901,  6902,  6906,  6908,  6909,  6915,  6921,
    6927,  6935,  6936,  6940,  6944,  6945,  6958,  6959,  6960,  6964,
    6965,  6969,  6975,  6989,  6990,  6994,  7006,  7007,  7011,  7012,
    7020,  7038,  7019,  7058,  7057,  7071,  7083,  7082,  7101,  7100,
    7119,  7118,  7137,  7131,  7151,  7150,  7183,  7188,  7193,  7198,
    7203,  7213,  7214,  7215,  7216,  7220,  7221,  7233,  7234,  7238,
    7239,  7242,  7244,  7252,  7260,  7262,  7264,  7265,  7273,  7274,
    7278,  7287,  7285,  7298,  7311,  7310,  7323,  7321,  7334,  7341,
    7351,  7352,  7379,  7386,  7390,  7395,  7394,  7410,  7412,  7417,
    7425,  7424,  7440,  7444,  7443,  7455,  7456,  7460,  7475,  7476,
    7480,  7489,  7493,  7498,  7504,  7503,  7515,  7526,  7514,  7542,
    7551,  7560,  7570,  7579,  7585,  7591,  7600,  7609,  7628,  7646,
    7656,  7660,  7665,  7666,  7669,  7671,  7672,  7673,  7674,  7677,
    7682,  7693,  7698,  7709,  7710,  7714,  7715,  7719,  7719,  7722,
    7724,  7728,  7729,  7733,  7734,  7742,  7743,  7744,  7748,  7749,
    7754,  7762,  7763,  7764,  7765,  7770,  7769,  7779,  7778,  7785,
    7792,  7802,  7819,  7822,  7829,  7833,  7840,  7844,  7848,  7855,
    7855,  7861,  7862,  7866,  7867,  7868,  7872,  7873,  7886,  7893,
    7894,  7899,  7898,  7910,  7911,  7912,  7917,  7916,  7946,  7947,
    7951,  7952,  7956,  7957,  7958,  7959,  7964,  7963,  7984,  7985,
    7989,  7994,  7995,  8002,  8004,  8008,  8010,  8009,  8021,  8023,
    8022,  8035,  8036,  8041,  8050,  8051,  8052,  8056,  8062,  8071,
    8080,  8079,  8112,  8113,  8117,  8118,  8122,  8123,  8124,  8125,
    8126,  8127,  8132,  8131,  8152,  8153,  8154,  8159,  8158,  8164,
    8171,  8176,  8184,  8185,  8189,  8203,  8202,  8216,  8217,  8221,
    8222,  8226,  8236,  8246,  8247,  8252,  8251,  8263,  8264,  8268,
    8269,  8273,  8283,  8294,  8293,  8301,  8301,  8310,  8311,  8316,
    8317,  8326,  8335,  8336,  8340,  8345,  8350,  8355,  8360,  8359,
    8379,  8387,  8379,  8394,  8395,  8396,  8397,  8398,  8402,  8409,
    8416,  8418,  8429,  8430,  8434,  8435,  8463,  8493,  8495,  8501,
    8511,  8512,  8513,  8527,  8532,  8557,  8563,  8569,  8570,  8571,
    8572,  8573,  8577,  8578,  8579,  8583,  8584,  8585,  8589,  8590,
    8595,  8646,  8653,  8696,  8702,  8708,  8714,  8720,  8726,  8732,
    8738,  8742,  8748,  8754,  8760,  8766,  8772,  8776,  8782,  8791,
    8797,  8805,  8811,  8821,  8827,  8836,  8846,  8852,  8862,  8868,
    8877,  8881,  8887,  8893,  8899,  8905,  8911,  8917,  8923,  8929,
    8935,  8941,  8947,  8953,  8959,  8965,  8969,  8970,  8974,  8975,
    8979,  8980,  8984,  8985,  8989,  8990,  8991,  8992,  8993,  8994,
    8998,  8999,  9004,  9010,  9014,  9021,  9028,  9035,  9042,  9049,
    9054,  9060,  9067,  9074,  9082,  9093,  9115,  9122,  9130,  9131,
    9132,  9133,  9134,  9135,  9146,  9147,  9148,  9149,  9150,  9156,
    9160,  9166,  9172,  9178,  9184,  9186,  9193,  9200,  9206,  9230,
    9239,  9246,  9254,  9260,  9267,  9273,  9287,  9294,  9310,  9316,
    9322,  9330,  9338,  9344,  9350,  9356,  9362,  9376,  9387,  9393,
    9399,  9405,  9411,  9417,  9423,  9429,  9435,  9441,  9447,  9453,
    9459,  9465,  9471,  9477,  9483,  9491,  9512,  9519,  9525,  9532,
    9539,  9546,  9553,  9559,  9565,  9572,  9578,  9585,  9591,  9597,
    9603,  9609,  9615,  9633,  9639,  9645,  9652,  9659,  9667,  9674,
    9681,  9688,  9695,  9712,  9718,  9724,  9730,  9736,  9743,  9749,
    9755,  9761,  9767,  9773,  9784,  9790,  9796,  9802,  9808,  9816,
    9822,  9833,  9839,  9845,  9853,  9863,  9869,  9885,  9891,  9898,
    9905,  9912,  9919,  9926,  9930,  9950,  9949, 10021, 10062, 10064,
   10069, 10070, 10074, 10075, 10079, 10080, 10084, 10091, 10099, 10126,
   10132, 10138, 10144, 10150, 10156, 10165, 10172, 10174, 10171, 10181,
   10192, 10198, 10204, 10210, 10216, 10222, 10228, 10234, 10240, 10247,
   10246, 10266, 10265, 10280, 10290, 10298, 10314, 10315, 10320, 10325,
   10328, 10331, 10330, 10347, 10349, 10355, 10354, 10371, 10373, 10375,
   10377, 10379, 10381, 10383, 10385, 10387, 10389, 10395, 10401, 10404,
   10403, 10409, 10410, 10414, 10421, 10429, 10430, 10434, 10441, 10449,
   10450, 10454, 10455, 10459, 10467, 10478, 10479, 10491, 10502, 10503,
   10509, 10510, 10530, 10534, 10532, 10550, 10548, 10559, 10569, 10567,
   10585, 10584, 10594, 10605, 10603, 10622, 10621, 10632, 10644, 10645,
   10646, 10650, 10651, 10659, 10660, 10664, 10679, 10679, 10694, 10734,
   10810, 10821, 10826, 10818, 10845, 10865, 10873, 10865, 10882, 10881,
   10904, 10921, 10904, 10928, 10932, 10958, 10959, 10964, 10967, 10968,
   10969, 10973, 10974, 10979, 10978, 10984, 10983, 10991, 10992, 10995,
   10997, 10997, 11001, 11001, 11006, 11007, 11011, 11013, 11018, 11019,
   11023, 11034, 11047, 11048, 11049, 11050, 11051, 11052, 11053, 11054,
   11055, 11056, 11057, 11058, 11062, 11063, 11064, 11065, 11066, 11067,
   11068, 11069, 11070, 11074, 11075, 11076, 11077, 11080, 11082, 11083,
   11087, 11088, 11096, 11098, 11102, 11104, 11103, 11117, 11120, 11119,
   11134, 11140, 11154, 11156, 11160, 11162, 11167, 11168, 11188, 11213,
   11217, 11218, 11222, 11234, 11236, 11241, 11240, 11275, 11277, 11282,
   11283, 11284, 11289, 11296, 11300, 11301, 11305, 11312, 11316, 11323,
   11330, 11337, 11347, 11380, 11384, 11390, 11396, 11405, 11413, 11417,
   11424, 11425, 11429, 11430, 11431, 11435, 11436, 11437, 11438, 11439,
   11440, 11444, 11445, 11446, 11447, 11448, 11452, 11453, 11454, 11455,
   11456, 11460, 11461, 11462, 11463, 11464, 11468, 11473, 11474, 11478,
   11479, 11482, 11485, 11484, 11515, 11516, 11520, 11521, 11525, 11535,
   11535, 11545, 11546, 11550, 11569, 11602, 11601, 11614, 11622, 11613,
   11624, 11636, 11648, 11647, 11665, 11664, 11675, 11675, 11691, 11698,
   11720, 11740, 11752, 11756, 11761, 11760, 11770, 11776, 11783, 11788,
   11793, 11803, 11804, 11808, 11819, 11832, 11833, 11837, 11849, 11853,
   11861, 11862, 11870, 11878, 11869, 11888, 11895, 11887, 11905, 11913,
   11914, 11922, 11926, 11927, 11938, 11939, 11943, 11952, 11953, 11954,
   11956, 11955, 11966, 11967, 11971, 11972, 11974, 11973, 11977, 11976,
   11982, 11983, 11987, 11988, 11992, 12002, 12003, 12007, 12008, 12013,
   12012, 12026, 12027, 12031, 12036, 12044, 12045, 12053, 12055, 12055,
   12063, 12071, 12062, 12093, 12094, 12098, 12106, 12107, 12111, 12121,
   12122, 12129, 12128, 12144, 12155, 12143, 12158, 12157, 12169, 12168,
   12181, 12183, 12187, 12188, 12192, 12205, 12221, 12222, 12226, 12227,
   12231, 12232, 12233, 12238, 12237, 12258, 12260, 12263, 12265, 12268,
   12269, 12272, 12276, 12280, 12284, 12288, 12292, 12296, 12300, 12304,
   12312, 12315, 12325, 12324, 12340, 12347, 12355, 12363, 12371, 12379,
   12387, 12394, 12401, 12407, 12409, 12411, 12420, 12424, 12429, 12428,
   12434, 12433, 12438, 12447, 12454, 12459, 12464, 12469, 12471, 12473,
   12475, 12477, 12479, 12486, 12494, 12496, 12504, 12511, 12518, 12525,
   12531, 12537, 12546, 12554, 12558, 12563, 12570, 12575, 12582, 12589,
   12596, 12603, 12610, 12617, 12623, 12630, 12637, 12642, 12647, 12652,
   12662, 12664, 12666, 12671, 12672, 12675, 12677, 12681, 12682, 12686,
   12687, 12691, 12692, 12696, 12697, 12701, 12702, 12705, 12707, 12714,
   12725, 12724, 12740, 12739, 12749, 12750, 12751, 12752, 12753, 12757,
   12758, 12762, 12763, 12764, 12768, 12769, 12770, 12785, 12784, 12797,
   12796, 12807, 12811, 12812, 12825, 12828, 12827, 12839, 12840, 12845,
   12847, 12849, 12851, 12853, 12855, 12866, 12868, 12870, 12872, 12878,
   12880, 12891, 12893, 12895, 12897, 12899, 12901, 12903, 12908, 12909,
   12913, 12914, 12918, 12917, 12927, 12928, 12932, 12932, 12935, 12936,
   12940, 12941, 12946, 12945, 12956, 12960, 12964, 12977, 12976, 12991,
   12992, 12993, 12996, 12997, 12998, 12999, 13007, 13011, 13020, 13026,
   13038, 13049, 13059, 13069, 13037, 13077, 13078, 13082, 13083, 13087,
   13088, 13096, 13100, 13101, 13102, 13105, 13107, 13111, 13112, 13116,
   13121, 13128, 13133, 13140, 13142, 13146, 13147, 13151, 13156, 13164,
   13165, 13168, 13170, 13178, 13180, 13184, 13185, 13186, 13190, 13192,
   13197, 13198, 13207, 13208, 13212, 13213, 13217, 13230, 13253, 13265,
   13272, 13291, 13299, 13304, 13316, 13324, 13339, 13359, 13360, 13361,
   13369, 13370, 13371, 13372, 13386, 13392, 13398, 13404, 13410, 13416,
   13433, 13443, 13453, 13459, 13468, 13480, 13486, 13492, 13508, 13509,
   13513, 13522, 13537, 13541, 13587, 13591, 13608, 13612, 13690, 13714,
   13744, 13745, 13761, 13771, 13775, 13781, 13787, 13797, 13803, 13812,
   13822, 13823, 13851, 13865, 13879, 13894, 13895, 13905, 13906, 13916,
   13917, 13918, 13922, 13937, 13969, 13979, 13979, 13981, 13991, 13992,
   13993, 13994, 13995, 13996, 13997, 13998, 13999, 14000, 14001, 14002,
   14003, 14004, 14005, 14006, 14007, 14008, 14009, 14010, 14011, 14012,
   14013, 14014, 14015, 14016, 14017, 14018, 14019, 14020, 14021, 14022,
   14023, 14024, 14025, 14026, 14027, 14028, 14029, 14030, 14031, 14032,
   14033, 14034, 14035, 14036, 14037, 14038, 14039, 14040, 14041, 14042,
   14043, 14044, 14045, 14046, 14047, 14048, 14049, 14050, 14060, 14061,
   14062, 14063, 14064, 14065, 14066, 14067, 14068, 14069, 14070, 14071,
   14072, 14073, 14074, 14075, 14076, 14077, 14078, 14079, 14080, 14081,
   14082, 14083, 14084, 14085, 14086, 14087, 14088, 14089, 14090, 14091,
   14092, 14093, 14094, 14095, 14096, 14097, 14098, 14099, 14100, 14101,
   14102, 14103, 14104, 14105, 14106, 14107, 14108, 14109, 14114, 14115,
   14116, 14117, 14118, 14119, 14120, 14121, 14122, 14123, 14124, 14125,
   14126, 14127, 14128, 14129, 14130, 14131, 14132, 14133, 14134, 14135,
   14136, 14137, 14138, 14139, 14140, 14141, 14142, 14143, 14144, 14145,
   14146, 14147, 14148, 14149, 14150, 14151, 14152, 14153, 14154, 14155,
   14156, 14157, 14158, 14159, 14160, 14161, 14162, 14163, 14164, 14165,
   14166, 14167, 14168, 14169, 14170, 14171, 14172, 14173, 14174, 14175,
   14176, 14177, 14178, 14179, 14180, 14181, 14182, 14183, 14184, 14185,
   14186, 14187, 14188, 14189, 14190, 14191, 14192, 14193, 14194, 14195,
   14196, 14197, 14198, 14199, 14200, 14201, 14202, 14203, 14204, 14205,
   14206, 14207, 14208, 14209, 14210, 14211, 14212, 14213, 14214, 14215,
   14216, 14217, 14218, 14219, 14220, 14221, 14222, 14223, 14224, 14225,
   14226, 14227, 14228, 14229, 14230, 14231, 14232, 14233, 14234, 14235,
   14236, 14237, 14238, 14239, 14240, 14241, 14242, 14243, 14244, 14245,
   14246, 14247, 14248, 14249, 14250, 14251, 14252, 14253, 14254, 14255,
   14256, 14257, 14258, 14259, 14260, 14261, 14262, 14263, 14264, 14265,
   14266, 14267, 14268, 14269, 14270, 14271, 14272, 14273, 14274, 14275,
   14276, 14277, 14278, 14279, 14280, 14281, 14282, 14283, 14284, 14285,
   14286, 14287, 14288, 14289, 14290, 14291, 14292, 14293, 14294, 14295,
   14296, 14297, 14298, 14299, 14300, 14301, 14302, 14303, 14304, 14305,
   14306, 14307, 14308, 14309, 14310, 14311, 14312, 14313, 14314, 14315,
   14316, 14317, 14318, 14319, 14320, 14321, 14322, 14323, 14324, 14325,
   14326, 14327, 14328, 14329, 14330, 14331, 14332, 14333, 14334, 14335,
   14336, 14337, 14338, 14339, 14340, 14341, 14342, 14343, 14344, 14345,
   14346, 14347, 14348, 14349, 14350, 14351, 14352, 14353, 14354, 14355,
   14356, 14357, 14358, 14359, 14360, 14361, 14362, 14363, 14364, 14365,
   14366, 14367, 14368, 14369, 14370, 14371, 14372, 14373, 14374, 14386,
   14385, 14403, 14402, 14409, 14408, 14418, 14417, 14428, 14427, 14433,
   14441, 14443, 14448, 14448, 14457, 14456, 14470, 14469, 14474, 14478,
   14479, 14480, 14484, 14485, 14486, 14487, 14491, 14492, 14493, 14494,
   14499, 14523, 14549, 14560, 14572, 14585, 14600, 14619, 14625, 14650,
   14663, 14689, 14732, 14746, 14747, 14748, 14749, 14753, 14770, 14787,
   14788, 14792, 14793, 14794, 14795, 14799, 14800, 14809, 14820, 14821,
   14822, 14828, 14834, 14846, 14845, 14861, 14862, 14866, 14867, 14871,
   14872, 14876, 14891, 14892, 14893, 14898, 14899, 14904, 14903, 14923,
   14935, 14948, 14947, 14981, 14982, 14986, 14987, 14991, 14992, 14993,
   14994, 14996, 14995, 15008, 15009, 15010, 15011, 15012, 15018, 15023,
   15029, 15040, 15051, 15055, 15062, 15071, 15073, 15078, 15083, 15090,
   15102, 15114, 15121, 15133, 15134, 15137, 15138, 15141, 15146, 15154,
   15165, 15185, 15188, 15190, 15194, 15195, 15202, 15204, 15208, 15209,
   15214, 15213, 15217, 15216, 15220, 15219, 15223, 15222, 15225, 15226,
   15227, 15228, 15229, 15230, 15231, 15232, 15233, 15234, 15235, 15236,
   15237, 15238, 15239, 15240, 15241, 15242, 15243, 15244, 15245, 15246,
   15247, 15248, 15249, 15250, 15254, 15255, 15259, 15260, 15264, 15274,
   15284, 15297, 15312, 15325, 15338, 15350, 15355, 15363, 15368, 15376,
   15381, 15388, 15388, 15389, 15389, 15392, 15421, 15426, 15432, 15438,
   15444, 15448, 15452, 15453, 15457, 15484, 15486, 15490, 15494, 15498,
   15505, 15506, 15510, 15511, 15515, 15516, 15520, 15521, 15527, 15533,
   15539, 15549, 15548, 15558, 15559, 15564, 15565, 15566, 15571, 15572,
   15573, 15577, 15578, 15582, 15594, 15603, 15613, 15622, 15636, 15637,
   15642, 15641, 15657, 15658, 15659, 15663, 15664, 15668, 15668, 15690,
   15691, 15695, 15696, 15697, 15701, 15705, 15712, 15715, 15713, 15729,
   15736, 15757, 15781, 15783, 15787, 15788, 15792, 15793, 15801, 15802,
   15803, 15804, 15810, 15816, 15826, 15828, 15830, 15835, 15836, 15837,
   15838, 15839, 15843, 15844, 15845, 15846, 15847, 15848, 15858, 15859,
   15864, 15877, 15890, 15892, 15894, 15900, 15901, 15903, 15909, 15908,
   15925, 15926, 15930, 15935, 15943, 15943, 15967, 15968, 15973, 15974,
   15976, 15978, 15996, 16002, 16007, 15989, 16068, 16085, 16109, 16140,
   16144, 16153, 16176, 16105, 16239, 16263, 16272, 16279, 16238, 16299,
   16303, 16307, 16311, 16315, 16319, 16326, 16333, 16340, 16350, 16351,
   16355, 16356, 16357, 16361, 16362, 16367, 16369, 16368, 16374, 16375,
   16379, 16386, 16396, 16402, 16413
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT_SYM", "ACCESSIBLE_SYM", "ACTION",
  "ADD", "ADMIN_SYM", "ADDDATE_SYM", "AFTER_SYM", "AGAINST",
  "AGGREGATE_SYM", "ALGORITHM_SYM", "ALL", "ALTER", "ALWAYS_SYM",
  "ANALYZE_SYM", "AND_AND_SYM", "AND_SYM", "ANY_SYM", "AS", "ASC",
  "ASCII_SYM", "ASENSITIVE_SYM", "AT_SYM", "AUTHORS_SYM",
  "AUTOEXTEND_SIZE_SYM", "AUTO_INC", "AUTO_SYM", "AVG_ROW_LENGTH",
  "AVG_SYM", "BACKUP_SYM", "BEFORE_SYM", "BEGIN_SYM", "BETWEEN_SYM",
  "BIGINT", "BINARY", "BINLOG_SYM", "BIN_NUM", "BIT_AND", "BIT_OR",
  "BIT_SYM", "BIT_XOR", "BLOB_SYM", "BLOCK_SYM", "BOOLEAN_SYM", "BOOL_SYM",
  "BOTH", "BTREE_SYM", "BY", "BYTE_SYM", "CACHE_SYM", "CALL_SYM",
  "CASCADE", "CASCADED", "CASE_SYM", "CAST_SYM", "CATALOG_NAME_SYM",
  "CHAIN_SYM", "CHANGE", "CHANGED", "CHARSET", "CHAR_SYM",
  "CHECKPOINT_SYM", "CHECKSUM_SYM", "CHECK_SYM", "CIPHER_SYM",
  "CLASS_ORIGIN_SYM", "CLIENT_SYM", "CLIENT_STATS_SYM", "CLOSE_SYM",
  "COALESCE", "CODE_SYM", "COLLATE_SYM", "COLLATION_SYM", "COLUMNS",
  "COLUMN_ADD_SYM", "COLUMN_CHECK_SYM", "COLUMN_CREATE_SYM",
  "COLUMN_DELETE_SYM", "COLUMN_GET_SYM", "COLUMN_SYM", "COLUMN_NAME_SYM",
  "COMMENT_SYM", "COMMITTED_SYM", "COMMIT_SYM", "COMPACT_SYM",
  "COMPLETION_SYM", "COMPRESSED_SYM", "CONCURRENT", "CONDITION_SYM",
  "CONNECTION_SYM", "CONSISTENT_SYM", "CONSTRAINT",
  "CONSTRAINT_CATALOG_SYM", "CONSTRAINT_NAME_SYM", "CONSTRAINT_SCHEMA_SYM",
  "CONTAINS_SYM", "CONTEXT_SYM", "CONTINUE_SYM", "CONTRIBUTORS_SYM",
  "CONVERT_SYM", "COUNT_SYM", "CPU_SYM", "CREATE", "CROSS", "CUBE_SYM",
  "CURDATE", "CURRENT_SYM", "CURRENT_USER", "CURRENT_ROLE",
  "CURRENT_POS_SYM", "CURSOR_SYM", "CURSOR_NAME_SYM", "CURTIME",
  "DATABASE", "DATABASES", "DATAFILE_SYM", "DATA_SYM", "DATETIME",
  "DATE_ADD_INTERVAL", "DATE_SUB_INTERVAL", "DATE_SYM", "DAY_HOUR_SYM",
  "DAY_MICROSECOND_SYM", "DAY_MINUTE_SYM", "DAY_SECOND_SYM", "DAY_SYM",
  "DEALLOCATE_SYM", "DECIMAL_NUM", "DECIMAL_SYM", "DECLARE_SYM", "DEFAULT",
  "DEFINER_SYM", "DELAYED_SYM", "DELAY_KEY_WRITE_SYM", "DELETE_SYM",
  "DESC", "DESCRIBE", "DES_KEY_FILE", "DETERMINISTIC_SYM",
  "DIAGNOSTICS_SYM", "DIRECTORY_SYM", "DISABLE_SYM", "DISCARD", "DISK_SYM",
  "DISTINCT", "DIV_SYM", "DOUBLE_SYM", "DO_SYM", "DROP", "DUAL_SYM",
  "DUMPFILE", "DUPLICATE_SYM", "DYNAMIC_SYM", "EACH_SYM", "ELSE",
  "ELSEIF_SYM", "ENABLE_SYM", "ENCLOSED", "END", "ENDS_SYM",
  "END_OF_INPUT", "ENGINES_SYM", "ENGINE_SYM", "ENUM", "EQ", "EQUAL_SYM",
  "ERROR_SYM", "ERRORS", "ESCAPED", "ESCAPE_SYM", "EVENTS_SYM",
  "EVENT_SYM", "EVERY_SYM", "EXCHANGE_SYM", "EXAMINED_SYM", "EXECUTE_SYM",
  "EXISTS", "EXIT_SYM", "EXPANSION_SYM", "EXPORT_SYM", "EXTENDED_SYM",
  "EXTENT_SIZE_SYM", "EXTRACT_SYM", "FALSE_SYM", "FAST_SYM", "FAULTS_SYM",
  "FETCH_SYM", "FILE_SYM", "FIRST_SYM", "FIXED_SYM", "FLOAT_NUM",
  "FLOAT_SYM", "FLUSH_SYM", "FORCE_SYM", "FOREIGN", "FOR_SYM", "FOUND_SYM",
  "FROM", "FULL", "FULLTEXT_SYM", "FUNCTION_SYM", "GE", "GENERAL",
  "GENERATED_SYM", "GEOMETRYCOLLECTION", "GEOMETRY_SYM", "GET_FORMAT",
  "GET_SYM", "GLOBAL_SYM", "GRANT", "GRANTS", "GROUP_SYM",
  "GROUP_CONCAT_SYM", "GT_SYM", "HANDLER_SYM", "HARD_SYM", "HASH_SYM",
  "HAVING", "HELP_SYM", "HEX_NUM", "HEX_STRING", "HIGH_PRIORITY",
  "HOST_SYM", "HOSTS_SYM", "HOUR_MICROSECOND_SYM", "HOUR_MINUTE_SYM",
  "HOUR_SECOND_SYM", "HOUR_SYM", "ID_SYM", "IDENT", "IDENTIFIED_SYM",
  "IDENT_QUOTED", "IF", "IGNORE_SYM", "IGNORE_SERVER_IDS_SYM", "IMPORT",
  "INDEXES", "INDEX_SYM", "INDEX_STATS_SYM", "INFILE", "INITIAL_SIZE_SYM",
  "INNER_SYM", "INOUT_SYM", "INSENSITIVE_SYM", "INSERT", "INSERT_METHOD",
  "INSTALL_SYM", "INTERVAL_SYM", "INTO", "INT_SYM", "INVOKER_SYM",
  "IN_SYM", "IO_SYM", "IPC_SYM", "IS", "ISOLATION", "ISSUER_SYM",
  "ITERATE_SYM", "JOIN_SYM", "KEYS", "KEY_BLOCK_SIZE", "KEY_SYM",
  "KILL_SYM", "LANGUAGE_SYM", "LAST_SYM", "LAST_VALUE", "LE", "LEADING",
  "LEAVES", "LEAVE_SYM", "LEFT", "LESS_SYM", "LEVEL_SYM", "LEX_HOSTNAME",
  "LIKE", "LIMIT", "LINEAR_SYM", "LINES", "LINESTRING", "LIST_SYM", "LOAD",
  "LOCAL_SYM", "LOCATOR_SYM", "LOCKS_SYM", "LOCK_SYM", "LOGFILE_SYM",
  "LOGS_SYM", "LONGBLOB", "LONGTEXT", "LONG_NUM", "LONG_SYM", "LOOP_SYM",
  "LOW_PRIORITY", "LT", "MASTER_CONNECT_RETRY_SYM", "MASTER_GTID_POS_SYM",
  "MASTER_HOST_SYM", "MASTER_LOG_FILE_SYM", "MASTER_LOG_POS_SYM",
  "MASTER_PASSWORD_SYM", "MASTER_PORT_SYM", "MASTER_SERVER_ID_SYM",
  "MASTER_SSL_CAPATH_SYM", "MASTER_SSL_CA_SYM", "MASTER_SSL_CERT_SYM",
  "MASTER_SSL_CIPHER_SYM", "MASTER_SSL_CRL_SYM", "MASTER_SSL_CRLPATH_SYM",
  "MASTER_SSL_KEY_SYM", "MASTER_SSL_SYM",
  "MASTER_SSL_VERIFY_SERVER_CERT_SYM", "MASTER_SYM", "MASTER_USER_SYM",
  "MASTER_USE_GTID_SYM", "MASTER_HEARTBEAT_PERIOD_SYM", "MATCH",
  "MAX_CONNECTIONS_PER_HOUR", "MAX_QUERIES_PER_HOUR", "MAX_ROWS",
  "MAX_SIZE_SYM", "MAX_SYM", "MAX_UPDATES_PER_HOUR",
  "MAX_USER_CONNECTIONS_SYM", "MAX_VALUE_SYM", "MEDIUMBLOB", "MEDIUMINT",
  "MEDIUMTEXT", "MEDIUM_SYM", "MEMORY_SYM", "MERGE_SYM",
  "MESSAGE_TEXT_SYM", "MICROSECOND_SYM", "MIGRATE_SYM",
  "MINUTE_MICROSECOND_SYM", "MINUTE_SECOND_SYM", "MINUTE_SYM", "MIN_ROWS",
  "MIN_SYM", "MODE_SYM", "MODIFIES_SYM", "MODIFY_SYM", "MOD_SYM",
  "MONTH_SYM", "MULTILINESTRING", "MULTIPOINT", "MULTIPOLYGON",
  "MUTEX_SYM", "MYSQL_SYM", "MYSQL_ERRNO_SYM", "NAMES_SYM", "NAME_SYM",
  "NATIONAL_SYM", "NATURAL", "NCHAR_STRING", "NCHAR_SYM", "NDBCLUSTER_SYM",
  "NE", "NEG", "NEW_SYM", "NEXT_SYM", "NODEGROUP_SYM", "NONE_SYM",
  "NOT2_SYM", "NOT_SYM", "NOW_SYM", "NO_SYM", "NO_WAIT_SYM",
  "NO_WRITE_TO_BINLOG", "NULL_SYM", "NUM", "NUMBER_SYM", "NUMERIC_SYM",
  "NVARCHAR_SYM", "OFFSET_SYM", "OLD_PASSWORD", "ON", "ONE_SYM",
  "ONLY_SYM", "ONLINE_SYM", "OPEN_SYM", "OPTIMIZE", "OPTIONS_SYM",
  "OPTION", "OPTIONALLY", "OR2_SYM", "ORDER_SYM", "OR_OR_SYM", "OR_SYM",
  "OUTER", "OUTFILE", "OUT_SYM", "OWNER_SYM", "PACK_KEYS_SYM", "PAGE_SYM",
  "PAGE_CHECKSUM_SYM", "PARAM_MARKER", "PARSER_SYM", "PARSE_VCOL_EXPR_SYM",
  "PARTIAL", "PARTITION_SYM", "PARTITIONS_SYM", "PARTITIONING_SYM",
  "PASSWORD", "PERSISTENT_SYM", "PHASE_SYM", "PLUGINS_SYM", "PLUGIN_SYM",
  "POINT_SYM", "POLYGON", "PORT_SYM", "POSITION_SYM", "PRECISION",
  "PREPARE_SYM", "PRESERVE_SYM", "PREV_SYM", "PRIMARY_SYM", "PRIVILEGES",
  "PROCEDURE_SYM", "PROCESS", "PROCESSLIST_SYM", "PROFILE_SYM",
  "PROFILES_SYM", "PROXY_SYM", "PURGE", "QUARTER_SYM", "QUERY_SYM",
  "QUICK", "RANGE_SYM", "READS_SYM", "READ_ONLY_SYM", "READ_SYM",
  "READ_WRITE_SYM", "REAL", "REBUILD_SYM", "RECOVER_SYM", "REDOFILE_SYM",
  "REDO_BUFFER_SIZE_SYM", "REDUNDANT_SYM", "REFERENCES", "REGEXP", "RELAY",
  "RELAYLOG_SYM", "RELAY_LOG_FILE_SYM", "RELAY_LOG_POS_SYM",
  "RELAY_THREAD", "RELEASE_SYM", "RELOAD", "REMOVE_SYM", "RENAME",
  "REORGANIZE_SYM", "REPAIR", "REPEATABLE_SYM", "REPEAT_SYM", "REPLACE",
  "REPLICATION", "REQUIRE_SYM", "RESET_SYM", "RESIGNAL_SYM", "RESOURCES",
  "RESTORE_SYM", "RESTRICT", "RESUME_SYM", "RETURNED_SQLSTATE_SYM",
  "RETURNING_SYM", "RETURNS_SYM", "RETURN_SYM", "REVERSE_SYM", "REVOKE",
  "RIGHT", "ROLE_SYM", "ROLLBACK_SYM", "ROLLUP_SYM", "ROUTINE_SYM",
  "ROWS_SYM", "ROW_FORMAT_SYM", "ROW_SYM", "ROW_COUNT_SYM", "RTREE_SYM",
  "SAVEPOINT_SYM", "SCHEDULE_SYM", "SCHEMA_NAME_SYM",
  "SECOND_MICROSECOND_SYM", "SECOND_SYM", "SECURITY_SYM", "SELECT_SYM",
  "SENSITIVE_SYM", "SEPARATOR_SYM", "SERIALIZABLE_SYM", "SERIAL_SYM",
  "SESSION_SYM", "SERVER_SYM", "SERVER_OPTIONS", "SET", "SET_VAR",
  "SHARE_SYM", "SHIFT_LEFT", "SHIFT_RIGHT", "SHOW", "SHUTDOWN",
  "SIGNAL_SYM", "SIGNED_SYM", "SIMPLE_SYM", "SLAVE", "SLAVES",
  "SLAVE_POS_SYM", "SLOW", "SMALLINT", "SNAPSHOT_SYM", "SOCKET_SYM",
  "SOFT_SYM", "SONAME_SYM", "SOUNDS_SYM", "SOURCE_SYM", "SPATIAL_SYM",
  "SPECIFIC_SYM", "SQLEXCEPTION_SYM", "SQLSTATE_SYM", "SQLWARNING_SYM",
  "SQL_BIG_RESULT", "SQL_BUFFER_RESULT", "SQL_CACHE_SYM",
  "SQL_CALC_FOUND_ROWS", "SQL_NO_CACHE_SYM", "SQL_SMALL_RESULT", "SQL_SYM",
  "SQL_THREAD", "SSL_SYM", "STARTING", "STARTS_SYM", "START_SYM",
  "STATS_AUTO_RECALC_SYM", "STATS_PERSISTENT_SYM",
  "STATS_SAMPLE_PAGES_SYM", "STATUS_SYM", "STDDEV_SAMP_SYM", "STD_SYM",
  "STOP_SYM", "STORAGE_SYM", "STRAIGHT_JOIN", "STRING_SYM",
  "SUBCLASS_ORIGIN_SYM", "SUBDATE_SYM", "SUBJECT_SYM", "SUBPARTITIONS_SYM",
  "SUBPARTITION_SYM", "SUBSTRING", "SUM_SYM", "SUPER_SYM", "SUSPEND_SYM",
  "SWAPS_SYM", "SWITCHES_SYM", "SYSDATE", "TABLES", "TABLESPACE",
  "TABLE_REF_PRIORITY", "TABLE_STATS_SYM", "TABLE_SYM",
  "TABLE_CHECKSUM_SYM", "TABLE_NAME_SYM", "TEMPORARY", "TEMPTABLE_SYM",
  "TERMINATED", "TEXT_STRING", "TEXT_SYM", "THAN_SYM", "THEN_SYM",
  "TIMESTAMP", "TIMESTAMP_ADD", "TIMESTAMP_DIFF", "TIME_SYM", "TINYBLOB",
  "TINYINT", "TINYTEXT", "TO_SYM", "TRAILING", "TRANSACTION_SYM",
  "TRANSACTIONAL_SYM", "TRIGGERS_SYM", "TRIGGER_SYM", "TRIM", "TRUE_SYM",
  "TRUNCATE_SYM", "TYPES_SYM", "TYPE_SYM", "UDF_RETURNS_SYM",
  "ULONGLONG_NUM", "UNCOMMITTED_SYM", "UNDEFINED_SYM",
  "UNDERSCORE_CHARSET", "UNDOFILE_SYM", "UNDO_BUFFER_SIZE_SYM", "UNDO_SYM",
  "UNICODE_SYM", "UNINSTALL_SYM", "UNION_SYM", "UNIQUE_SYM", "UNKNOWN_SYM",
  "UNLOCK_SYM", "UNSIGNED", "UNTIL_SYM", "UPDATE_SYM", "UPGRADE_SYM",
  "USAGE", "USER", "USER_STATS_SYM", "USE_FRM", "USE_SYM", "USING",
  "UTC_DATE_SYM", "UTC_TIMESTAMP_SYM", "UTC_TIME_SYM", "VALUES",
  "VALUE_SYM", "VARBINARY", "VARCHAR", "VARIABLES", "VARIANCE_SYM",
  "VARYING", "VAR_SAMP_SYM", "VIA_SYM", "VIEW_SYM", "VIRTUAL_SYM",
  "WAIT_SYM", "WARNINGS", "WEEK_SYM", "WEIGHT_STRING_SYM", "WHEN_SYM",
  "WHERE", "WHILE_SYM", "WITH", "WITH_CUBE_SYM", "WITH_ROLLUP_SYM",
  "WORK_SYM", "WRAPPER_SYM", "WRITE_SYM", "X509_SYM", "XA_SYM", "XML_SYM",
  "XOR", "YEAR_MONTH_SYM", "YEAR_SYM", "ZEROFILL", "IMPOSSIBLE_ACTION",
  "'|'", "'&'", "'-'", "'+'", "'*'", "'/'", "'%'", "'^'", "'~'", "'('",
  "')'", "','", "'!'", "'{'", "'}'", "';'", "'@'", "'.'", "':'", "$accept",
  "query", "$@1", "opt_end_of_input", "verb_clause", "statement",
  "deallocate", "deallocate_or_drop", "prepare", "prepare_src", "execute",
  "$@2", "execute_using", "execute_var_list", "execute_var_ident", "help",
  "$@3", "change", "$@4", "master_defs", "master_def",
  "ignore_server_id_list", "ignore_server_id", "master_file_def",
  "optional_connection_name", "connection_name", "create", "$@5", "$@6",
  "$@7", "$@8", "$@9", "$@10", "$@11", "$@12", "$@13", "server_def",
  "server_options_list", "server_option", "event_tail", "$@14",
  "ev_schedule_time", "$@15", "opt_ev_status", "ev_starts", "ev_ends",
  "opt_ev_on_completion", "ev_on_completion", "opt_ev_comment",
  "ev_sql_stmt", "$@16", "ev_sql_stmt_inner", "clear_privileges",
  "sp_name", "sp_a_chistics", "sp_c_chistics", "sp_chistic",
  "sp_c_chistic", "sp_suid", "call", "$@17", "opt_sp_cparam_list",
  "opt_sp_cparams", "sp_cparams", "sp_fdparam_list", "sp_fdparams",
  "sp_init_param", "sp_fdparam", "sp_pdparam_list", "sp_pdparams",
  "sp_pdparam", "sp_opt_inout", "sp_proc_stmts", "sp_proc_stmts1",
  "sp_decls", "sp_decl", "$@18", "$@19", "sp_cursor_stmt", "$@20",
  "sp_handler_type", "sp_hcond_list", "sp_hcond_element", "sp_cond",
  "sqlstate", "opt_value", "sp_hcond", "signal_stmt", "signal_value",
  "opt_signal_value", "opt_set_signal_information",
  "signal_information_item_list", "signal_allowed_expr",
  "signal_condition_information_item_name", "resignal_stmt",
  "get_diagnostics", "which_area", "diagnostics_information",
  "statement_information", "statement_information_item",
  "simple_target_specification", "statement_information_item_name",
  "condition_number", "condition_information",
  "condition_information_item", "condition_information_item_name",
  "sp_decl_idents", "sp_opt_default", "sp_proc_stmt", "sp_proc_stmt_if",
  "$@21", "sp_proc_stmt_statement", "$@22", "sp_proc_stmt_return", "$@23",
  "sp_proc_stmt_unlabeled", "$@24", "sp_proc_stmt_leave",
  "sp_proc_stmt_iterate", "sp_proc_stmt_open", "sp_proc_stmt_fetch",
  "$@25", "sp_proc_stmt_close", "sp_opt_fetch_noise", "sp_fetch_list",
  "sp_if", "$@26", "$@27", "$@28", "sp_elseifs", "case_stmt_specification",
  "simple_case_stmt", "$@29", "$@30", "searched_case_stmt", "$@31",
  "simple_when_clause_list", "searched_when_clause_list",
  "simple_when_clause", "$@32", "$@33", "searched_when_clause", "$@34",
  "$@35", "else_clause_opt", "sp_labeled_control", "$@36", "sp_opt_label",
  "sp_labeled_block", "$@37", "sp_unlabeled_block", "$@38",
  "sp_block_content", "$@39", "sp_unlabeled_control", "$@40", "$@41",
  "$@42", "trg_action_time", "trg_event", "change_tablespace_access",
  "change_tablespace_info", "tablespace_info", "opt_logfile_group_name",
  "alter_tablespace_info", "logfile_group_info",
  "alter_logfile_group_info", "add_log_file", "change_ts_option_list",
  "$@43", "change_ts_options", "change_ts_option",
  "tablespace_option_list", "tablespace_options", "tablespace_option",
  "alter_tablespace_option_list", "alter_tablespace_options",
  "alter_tablespace_option", "logfile_group_option_list",
  "logfile_group_options", "logfile_group_option",
  "alter_logfile_group_option_list", "alter_logfile_group_options",
  "alter_logfile_group_option", "ts_datafile", "lg_undofile",
  "lg_redofile", "tablespace_name", "logfile_group_name", "ts_access_mode",
  "opt_ts_initial_size", "opt_ts_autoextend_size", "opt_ts_max_size",
  "opt_ts_extent_size", "opt_ts_undo_buffer_size",
  "opt_ts_redo_buffer_size", "opt_ts_nodegroup", "opt_ts_comment",
  "opt_ts_engine", "opt_ts_wait", "ts_wait", "size_number", "create_body",
  "$@44", "$@45", "create_like", "opt_create_select", "$@46", "$@47",
  "opt_create_partitioning", "opt_partitioning", "partitioning", "$@48",
  "have_partitioning", "partition_entry", "$@49", "partition",
  "part_type_def", "$@50", "opt_linear", "opt_key_algo", "part_field_list",
  "part_field_item_list", "part_field_item", "part_column_list",
  "part_func", "sub_part_func", "opt_num_parts", "opt_sub_part", "$@51",
  "$@52", "sub_part_field_list", "sub_part_field_item", "part_func_expr",
  "opt_num_subparts", "part_defs", "part_def_list", "part_definition",
  "$@53", "part_name", "opt_part_values", "$@54", "$@55", "part_func_max",
  "part_values_in", "part_value_list", "part_value_item", "$@56", "$@57",
  "part_value_item_list", "part_value_expr_item", "opt_sub_partition",
  "sub_part_list", "sub_part_definition", "$@58", "sub_name",
  "opt_part_options", "opt_part_option_list", "opt_part_option",
  "create_select", "$@59", "$@60", "opt_as", "opt_create_database_options",
  "create_database_options", "create_database_option", "opt_table_options",
  "table_options", "table_option", "opt_if_not_exists",
  "create_or_replace", "opt_create_table_options",
  "create_table_options_space_separated", "create_table_options",
  "create_table_option", "$@61", "default_charset", "default_collation",
  "storage_engines", "known_storage_engines", "row_types",
  "merge_insert_types", "opt_select_from", "udf_type", "create_field_list",
  "field_list", "field_list_item", "column_def", "key_def", "$@62", "$@63",
  "$@64", "$@65", "opt_check_constraint", "check_constraint",
  "opt_constraint", "constraint", "field_spec", "$@66", "field_def", "@67",
  "opt_generated_always", "vcol_opt_specifier", "vcol_opt_attribute",
  "vcol_opt_attribute_list", "vcol_attribute", "parse_vcol_expr",
  "virtual_column_func", "type", "$@68", "$@69", "spatial_type", "char",
  "nchar", "varchar", "nvarchar", "int_type", "real_type", "float_options",
  "precision", "field_options", "field_opt_list", "field_option",
  "field_length", "opt_field_length", "opt_precision", "opt_attribute",
  "opt_attribute_list", "attribute", "type_with_opt_collate",
  "now_or_signed_literal", "charset", "charset_name",
  "charset_name_or_default", "opt_load_data_charset",
  "old_or_new_charset_name", "old_or_new_charset_name_or_default",
  "collation_name", "opt_collate", "collation_name_or_default",
  "opt_default", "ascii", "unicode", "opt_binary", "opt_bin_mod",
  "ws_nweights", "$@70", "ws_level_flag_desc", "ws_level_flag_reverse",
  "ws_level_flags", "ws_level_number", "ws_level_list_item",
  "ws_level_list", "ws_level_range", "ws_level_list_or_range",
  "opt_ws_levels", "opt_primary", "references", "opt_ref_list", "ref_list",
  "opt_match_clause", "opt_on_update_delete", "delete_option",
  "normal_key_type", "constraint_key_type", "key_or_index",
  "opt_key_or_index", "keys_or_index", "opt_unique", "fulltext", "spatial",
  "init_key_options", "key_alg", "normal_key_options",
  "fulltext_key_options", "spatial_key_options", "normal_key_opts",
  "spatial_key_opts", "fulltext_key_opts", "key_using_alg", "all_key_opt",
  "normal_key_opt", "spatial_key_opt", "fulltext_key_opt",
  "btree_or_rtree", "key_list", "key_part", "opt_ident",
  "opt_if_not_exists_ident", "opt_component", "string_list", "alter",
  "$@71", "$@72", "$@73", "$@74", "$@75", "$@76", "$@77", "$@78",
  "ev_alter_on_schedule_completion", "opt_ev_rename_to", "opt_ev_sql_stmt",
  "ident_or_empty", "alter_commands", "$@79", "$@80", "$@81",
  "remove_partitioning", "all_or_alt_part_name_list", "add_partition_rule",
  "$@82", "add_part_extra", "reorg_partition_rule", "$@83",
  "reorg_parts_rule", "$@84", "alt_part_name_list", "alt_part_name_item",
  "alter_list", "add_column", "alter_list_item", "$@85", "$@86", "$@87",
  "opt_index_lock_algorithm", "alter_algorithm_option",
  "alter_lock_option", "opt_column", "opt_ignore", "alter_options", "$@88",
  "alter_options_part2", "alter_option_list", "alter_option",
  "opt_restrict", "opt_place", "opt_to", "slave", "$@89", "$@90", "start",
  "opt_start_transaction_option_list", "start_transaction_option_list",
  "start_transaction_option", "slave_thread_opts", "$@91",
  "slave_thread_opt_list", "slave_thread_opt", "slave_until",
  "slave_until_opts", "checksum", "$@92", "opt_checksum_type", "repair",
  "$@93", "opt_mi_repair_type", "mi_repair_types", "mi_repair_type",
  "analyze", "$@94", "analyze_table_list", "analyze_table_elem_spec",
  "opt_persistent_stat_clause", "persistent_stat_spec",
  "persistent_column_stat_spec", "$@95", "persistent_index_stat_spec",
  "$@96", "table_column_list", "table_index_list", "table_index_name",
  "binlog_base64_event", "check", "$@97", "opt_mi_check_type",
  "mi_check_types", "mi_check_type", "optimize", "$@98",
  "opt_no_write_to_binlog", "rename", "$@99", "rename_list",
  "table_to_table_list", "table_to_table", "keycache", "$@100",
  "keycache_list_or_parts", "keycache_list", "assign_to_keycache",
  "assign_to_keycache_parts", "key_cache_name", "preload", "$@101",
  "preload_list_or_parts", "preload_list", "preload_keys",
  "preload_keys_parts", "adm_partition", "$@102", "cache_keys_spec",
  "$@103", "cache_key_list_or_empty", "opt_ignore_leaves", "select",
  "select_init", "select_paren", "select_paren_derived", "select_init2",
  "$@104", "select_part2", "$@105", "$@106", "select_into", "select_from",
  "select_options", "select_option_list", "select_option",
  "select_lock_type", "select_item_list", "select_item", "remember_name",
  "remember_end", "select_alias", "opt_default_time_precision",
  "opt_time_precision", "optional_braces", "expr", "bool_pri", "predicate",
  "bit_expr", "or", "and", "not", "not2", "comp_op", "all_or_any",
  "opt_dyncol_type", "dyncol_type", "dyncall_create_element",
  "dyncall_create_list", "simple_expr", "function_call_keyword",
  "function_call_nonkeyword", "function_call_conflict",
  "geometry_function", "function_call_generic", "@107", "fulltext_options",
  "opt_natural_language_mode", "opt_query_expansion", "opt_udf_expr_list",
  "udf_expr_list", "udf_expr", "sum_expr", "$@108", "$@109", "$@110",
  "variable", "$@111", "variable_aux", "opt_distinct",
  "opt_gconcat_separator", "opt_gorder_clause", "$@112", "gorder_list",
  "in_sum_expr", "$@113", "cast_type", "$@114", "opt_expr_list",
  "expr_list", "ident_list_arg", "ident_list", "opt_expr", "opt_else",
  "when_list", "table_ref", "join_table_list", "esc_table_ref",
  "derived_table_list", "join_table", "$@115", "$@116", "$@117", "$@118",
  "$@119", "$@120", "inner_join", "normal_join", "opt_use_partition",
  "use_partition", "table_factor", "$@121", "select_derived_union",
  "$@122", "$@123", "select_init2_derived", "select_part2_derived",
  "$@124", "$@125", "select_derived", "$@126", "select_derived2", "$@127",
  "$@128", "get_select_lex", "select_derived_init", "opt_outer",
  "index_hint_clause", "index_hint_type", "index_hint_definition", "$@129",
  "$@130", "index_hints_list", "opt_index_hints_list", "$@131",
  "opt_key_definition", "$@132", "opt_key_usage_list", "key_usage_element",
  "key_usage_list", "using_list", "interval", "interval_time_stamp",
  "date_time_type", "table_alias", "opt_table_alias", "opt_all",
  "where_clause", "$@133", "having_clause", "$@134", "opt_escape",
  "group_clause", "group_list", "olap_opt", "alter_order_clause",
  "alter_order_list", "alter_order_item", "opt_order_clause",
  "order_clause", "$@135", "order_list", "order_dir",
  "opt_limit_clause_init", "opt_limit_clause", "limit_clause",
  "limit_options", "limit_option", "limit_rows_option",
  "delete_limit_clause", "int_num", "ulong_num", "real_ulong_num",
  "ulonglong_num", "real_ulonglong_num", "dec_num_error", "dec_num",
  "choice", "procedure_clause", "$@136", "procedure_list",
  "procedure_list2", "procedure_item", "select_var_list_init", "$@137",
  "select_var_list", "select_var_ident", "into", "$@138",
  "into_destination", "$@139", "$@140", "do", "$@141", "drop", "$@142",
  "$@143", "$@144", "table_list", "table_name",
  "table_name_with_opt_use_partition", "table_alias_ref_list",
  "table_alias_ref", "opt_if_exists", "opt_temporary", "insert", "$@145",
  "$@146", "replace", "$@147", "$@148", "insert_lock_option",
  "replace_lock_option", "insert2", "insert_table", "insert_field_spec",
  "$@149", "fields", "insert_values", "$@150", "$@151", "values_list",
  "ident_eq_list", "ident_eq_value", "equal", "opt_equal", "no_braces",
  "$@152", "opt_values", "values", "expr_or_default", "opt_insert_update",
  "$@153", "update", "$@154", "$@155", "update_list", "update_elem",
  "insert_update_list", "insert_update_elem", "opt_low_priority", "delete",
  "$@156", "single_multi", "$@157", "$@158", "$@159", "$@160",
  "opt_select_expressions", "table_wild_list", "table_wild_one",
  "opt_wild", "opt_delete_options", "opt_delete_option", "truncate",
  "$@161", "opt_table_sym", "opt_profile_defs", "profile_defs",
  "profile_def", "opt_profile_args", "show", "$@162", "show_param",
  "$@163", "$@164", "show_engine_param", "master_or_binary", "opt_storage",
  "opt_db", "opt_full", "from_or_in", "binlog_in", "binlog_from",
  "wild_and_where", "describe", "$@165", "$@166", "explainable_command",
  "describe_command", "opt_extended_describe", "opt_describe_column",
  "flush", "$@167", "flush_options", "$@168", "opt_flush_lock",
  "flush_lock", "$@169", "flush_options_list", "flush_option",
  "opt_table_list", "optional_flush_tables_arguments", "reset", "$@170",
  "reset_options", "reset_option", "$@171", "slave_reset_options", "purge",
  "$@172", "purge_options", "purge_option", "kill", "$@173", "kill_type",
  "kill_option", "kill_expr", "shutdown", "use", "load", "$@174", "$@175",
  "$@176", "$@177", "data_or_xml", "opt_local", "load_data_lock",
  "opt_duplicate", "opt_field_term", "field_term_list", "field_term",
  "opt_line_term", "line_term_list", "line_term",
  "opt_xml_rows_identified_by", "opt_ignore_lines", "lines_or_rows",
  "opt_field_or_var_spec", "fields_or_vars", "field_or_var",
  "opt_load_data_set_spec", "load_data_set_list", "load_data_set_elem",
  "text_literal", "text_string", "hex_or_bin_String", "param_marker",
  "signed_literal", "literal", "NUM_literal", "temporal_literal",
  "insert_ident", "table_wild", "order_ident", "simple_ident",
  "simple_ident_nospvar", "simple_ident_q", "field_ident", "table_ident",
  "table_ident_opt_wild", "table_ident_nodb", "IDENT_sys",
  "TEXT_STRING_sys", "TEXT_STRING_literal", "TEXT_STRING_filesystem",
  "ident", "label_ident", "ident_or_text", "user_maybe_role",
  "user_or_role", "user", "keyword", "keyword_sp", "set", "$@178",
  "start_option_value_list", "$@179", "$@180", "$@181",
  "start_option_value_list_following_option_type", "$@182",
  "option_value_list_continued", "option_value_list", "$@183", "$@184",
  "option_value", "$@185", "option_type", "opt_var_type",
  "opt_var_ident_type", "option_value_following_option_type",
  "option_value_no_option_type", "internal_variable_name",
  "transaction_characteristics", "transaction_access_mode",
  "isolation_level", "transaction_access_mode_types", "isolation_types",
  "text_or_password", "set_expr_or_default", "lock", "$@186",
  "table_or_tables", "table_or_view", "table_lock_list", "table_lock",
  "lock_option", "unlock", "$@187", "handler", "$@188",
  "handler_read_or_scan", "handler_scan_function", "handler_rkey_function",
  "$@189", "handler_rkey_mode", "revoke", "revoke_command",
  "admin_option_for_role", "grant", "grant_command", "opt_with_admin",
  "opt_with_admin_option", "role_list", "current_role", "grant_role",
  "opt_table", "grant_privileges", "opt_privileges",
  "object_privilege_list", "object_privilege", "$@190", "$@191", "$@192",
  "$@193", "opt_and", "require_list", "require_list_element",
  "grant_ident", "user_list", "grant_list", "user_and_role_list",
  "via_or_with", "using_or_as", "grant_user", "opt_column_list",
  "column_list", "column_list_id", "require_clause", "grant_options",
  "opt_grant_option", "grant_option_list", "grant_option", "begin",
  "$@194", "opt_work", "opt_chain", "opt_release", "opt_savepoint",
  "commit", "rollback", "savepoint", "release", "union_clause",
  "union_list", "$@195", "union_opt", "opt_union_order_or_limit",
  "union_order_or_limit", "$@196", "order_or_limit", "union_option",
  "query_specification", "query_expression_body", "$@197", "subselect",
  "subselect_start", "subselect_end", "opt_query_expression_options",
  "query_expression_option_list", "query_expression_option",
  "view_or_trigger_or_sp_or_event", "definer_tail", "no_definer_tail",
  "definer_opt", "no_definer", "definer", "view_algorithm", "view_suid",
  "view_tail", "$@198", "view_list_opt", "view_list", "view_select",
  "$@199", "view_select_aux", "view_check_option", "trigger_tail", "$@200",
  "$@201", "$@202", "udf_tail", "sf_tail", "$@203", "$@204", "$@205",
  "$@206", "$@207", "sp_tail", "$@208", "$@209", "$@210", "$@211", "xa",
  "xid", "begin_or_start", "opt_join_or_resume", "opt_one_phase",
  "opt_suspend", "$@212", "opt_migrate", "install", "uninstall",
  "keep_gcc_happy", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   124,    38,    45,    43,    42,
      47,    37,    94,   126,    40,    41,    44,    33,   123,   125,
      59,    64,    46,    58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   664,   665,   666,   665,   665,   667,   667,   668,   668,
     669,   669,   669,   669,   669,   669,   669,   669,   669,   669,
     669,   669,   669,   669,   669,   669,   669,   669,   669,   669,
     669,   669,   669,   669,   669,   669,   669,   669,   669,   669,
     669,   669,   669,   669,   669,   669,   669,   669,   669,   669,
     669,   669,   669,   669,   669,   669,   669,   669,   669,   669,
     669,   669,   669,   669,   669,   670,   671,   671,   672,   673,
     673,   675,   674,   676,   676,   677,   677,   678,   680,   679,
     682,   681,   683,   683,   684,   684,   684,   684,   684,   684,
     684,   684,   684,   684,   684,   684,   684,   684,   684,   684,
     684,   685,   685,   685,   686,   687,   687,   687,   687,   687,
     687,   687,   688,   688,   689,   691,   690,   692,   693,   690,
     694,   695,   690,   696,   697,   690,   698,   690,   699,   690,
     690,   690,   690,   690,   690,   700,   701,   701,   702,   702,
     702,   702,   702,   702,   702,   704,   703,   706,   705,   705,
     707,   707,   707,   707,   708,   708,   709,   709,   710,   710,
     711,   711,   712,   712,   714,   713,   715,   715,   715,   715,
     715,   715,   715,   715,   715,   715,   715,   715,   715,   716,
     717,   717,   718,   718,   719,   719,   720,   720,   720,   720,
     720,   720,   720,   721,   721,   721,   722,   722,   724,   723,
     725,   725,   726,   726,   727,   727,   728,   728,   729,   729,
     730,   731,   732,   732,   733,   733,   734,   735,   735,   735,
     735,   736,   736,   737,   737,   738,   738,   740,   739,   739,
     741,   739,   739,   743,   742,   744,   744,   745,   745,   746,
     747,   747,   748,   749,   749,   750,   750,   750,   750,   750,
     751,   752,   752,   753,   753,   754,   754,   755,   755,   756,
     756,   756,   757,   757,   757,   757,   757,   757,   757,   757,
     757,   757,   757,   757,   758,   759,   760,   760,   761,   761,
     762,   762,   763,   764,   764,   765,   765,   766,   767,   767,
     768,   769,   769,   769,   769,   769,   769,   769,   769,   769,
     769,   769,   769,   769,   770,   770,   771,   771,   772,   772,
     772,   772,   772,   772,   772,   772,   772,   772,   772,   772,
     772,   774,   773,   776,   775,   778,   777,   780,   779,   781,
     782,   783,   785,   784,   786,   787,   787,   787,   788,   788,
     790,   791,   792,   789,   793,   793,   793,   794,   794,   796,
     797,   795,   799,   798,   800,   800,   801,   801,   803,   804,
     802,   806,   807,   805,   808,   808,   810,   809,   811,   811,
     813,   812,   815,   814,   817,   816,   818,   819,   820,   818,
     821,   818,   822,   822,   823,   823,   823,   824,   825,   826,
     827,   827,   828,   828,   829,   830,   831,   831,   833,   832,
     834,   834,   834,   835,   835,   835,   836,   837,   837,   837,
     838,   838,   838,   838,   838,   838,   838,   838,   839,   840,
     840,   840,   841,   841,   841,   841,   841,   842,   843,   843,
     843,   844,   844,   844,   844,   844,   844,   844,   845,   846,
     846,   846,   847,   847,   847,   848,   849,   850,   851,   852,
     853,   853,   853,   854,   855,   856,   857,   858,   859,   860,
     861,   862,   863,   863,   864,   864,   865,   865,   867,   866,
     866,   868,   866,   866,   869,   869,   870,   871,   870,   872,
     870,   873,   874,   874,   876,   875,   877,   879,   878,   880,
     881,   882,   881,   881,   881,   881,   881,   883,   883,   884,
     884,   885,   885,   886,   886,   887,   888,   889,   890,   891,
     891,   892,   893,   892,   894,   892,   895,   895,   896,   897,
     898,   898,   899,   899,   900,   900,   902,   901,   903,   904,
     905,   904,   906,   904,   907,   907,   908,   908,   909,   909,
     911,   912,   910,   913,   913,   914,   914,   915,   915,   916,
     916,   918,   917,   919,   920,   920,   921,   921,   922,   922,
     922,   922,   922,   922,   922,   922,   922,   924,   925,   923,
     926,   926,   927,   927,   928,   928,   929,   929,   930,   930,
     931,   931,   932,   933,   933,   934,   934,   935,   935,   936,
     936,   937,   937,   937,   938,   938,   938,   938,   938,   938,
     938,   938,   938,   938,   938,   938,   938,   938,   938,   938,
     938,   938,   938,   938,   939,   938,   938,   938,   938,   938,
     938,   938,   938,   938,   938,   938,   938,   938,   938,   938,
     938,   940,   941,   942,   943,   944,   944,   944,   944,   944,
     944,   944,   945,   945,   945,   946,   946,   947,   947,   947,
     947,   948,   949,   949,   950,   950,   951,   951,   953,   952,
     954,   952,   955,   952,   956,   952,   952,   952,   957,   957,
     958,   959,   959,   960,   962,   961,   963,   964,   963,   965,
     965,   966,   966,   966,   967,   967,   968,   968,   969,   969,
     969,   970,   971,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   972,   972,
     972,   972,   972,   972,   972,   972,   972,   972,   973,   972,
     974,   972,   972,   972,   975,   975,   975,   975,   975,   975,
     975,   975,   976,   977,   977,   978,   978,   979,   979,   979,
     979,   979,   980,   980,   980,   980,   980,   981,   981,   981,
     982,   982,   982,   983,   984,   984,   985,   985,   986,   986,
     986,   987,   987,   987,   987,   988,   988,   989,   989,   990,
     990,   991,   991,   992,   992,   992,   992,   992,   992,   992,
     992,   992,   992,   992,   992,   992,   992,   992,   993,   994,
     994,   995,   995,   996,   996,   997,   997,   998,   998,   999,
     999,  1000,  1000,  1001,  1002,  1002,  1003,  1003,  1004,  1004,
    1005,  1005,  1005,  1006,  1006,  1006,  1007,  1007,  1007,  1007,
    1007,  1007,  1007,  1008,  1008,  1010,  1009,  1011,  1011,  1012,
    1013,  1013,  1013,  1013,  1014,  1015,  1016,  1016,  1017,  1018,
    1018,  1019,  1019,  1020,  1020,  1021,  1022,  1022,  1023,  1023,
    1024,  1024,  1024,  1024,  1025,  1025,  1025,  1025,  1025,  1026,
    1026,  1026,  1026,  1026,  1027,  1028,  1028,  1029,  1029,  1030,
    1030,  1031,  1031,  1031,  1032,  1032,  1033,  1034,  1035,  1036,
    1036,  1037,  1037,  1038,  1038,  1039,  1039,  1040,  1040,  1041,
    1041,  1042,  1042,  1043,  1043,  1044,  1044,  1044,  1044,  1044,
    1044,  1045,  1045,  1046,  1047,  1047,  1048,  1048,  1048,  1049,
    1049,  1050,  1050,  1051,  1051,  1052,  1053,  1053,  1054,  1054,
    1056,  1057,  1055,  1058,  1055,  1055,  1059,  1055,  1060,  1055,
    1061,  1055,  1062,  1055,  1063,  1055,  1055,  1055,  1055,  1055,
    1055,  1064,  1064,  1064,  1064,  1065,  1065,  1066,  1066,  1067,
    1067,  1068,  1068,  1068,  1068,  1068,  1068,  1068,  1068,  1068,
    1068,  1069,  1068,  1068,  1070,  1068,  1071,  1068,  1068,  1068,
    1068,  1068,  1072,  1073,  1073,  1075,  1074,  1076,  1076,  1076,
    1078,  1077,  1079,  1080,  1079,  1081,  1081,  1082,  1083,  1083,
    1084,  1085,  1085,  1085,  1086,  1085,  1087,  1088,  1085,  1085,
    1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,  1085,
    1085,  1085,  1085,  1085,  1089,  1089,  1089,  1089,  1089,  1090,
    1090,  1091,  1091,  1092,  1092,  1093,  1093,  1095,  1094,  1096,
    1096,  1097,  1097,  1098,  1098,  1099,  1099,  1099,  1100,  1100,
    1100,  1101,  1101,  1101,  1101,  1103,  1102,  1104,  1102,  1102,
    1102,  1105,  1106,  1106,  1107,  1107,  1108,  1108,  1108,  1110,
    1109,  1111,  1111,  1112,  1112,  1112,  1113,  1113,  1113,  1114,
    1114,  1116,  1115,  1117,  1117,  1117,  1119,  1118,  1120,  1120,
    1121,  1121,  1122,  1122,  1122,  1122,  1124,  1123,  1125,  1125,
    1126,  1127,  1127,  1128,  1128,  1129,  1130,  1129,  1131,  1132,
    1131,  1133,  1133,  1133,  1134,  1134,  1134,  1135,  1135,  1136,
    1138,  1137,  1139,  1139,  1140,  1140,  1141,  1141,  1141,  1141,
    1141,  1141,  1143,  1142,  1144,  1144,  1144,  1146,  1145,  1145,
    1147,  1147,  1148,  1148,  1149,  1151,  1150,  1152,  1152,  1153,
    1153,  1154,  1155,  1156,  1156,  1158,  1157,  1159,  1159,  1160,
    1160,  1161,  1162,  1164,  1163,  1166,  1165,  1167,  1167,  1168,
    1168,  1169,  1170,  1170,  1171,  1171,  1172,  1172,  1174,  1173,
    1176,  1177,  1175,  1178,  1178,  1178,  1178,  1178,  1179,  1179,
    1180,  1180,  1181,  1181,  1182,  1182,  1182,  1183,  1183,  1183,
    1184,  1184,  1184,  1185,  1185,  1186,  1187,  1188,  1188,  1188,
    1188,  1188,  1189,  1189,  1189,  1190,  1190,  1190,  1191,  1191,
    1192,  1192,  1192,  1192,  1192,  1192,  1192,  1192,  1192,  1192,
    1192,  1193,  1193,  1193,  1193,  1193,  1193,  1194,  1194,  1194,
    1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,  1194,
    1194,  1195,  1195,  1195,  1195,  1195,  1195,  1195,  1195,  1195,
    1195,  1195,  1195,  1195,  1195,  1195,  1196,  1196,  1197,  1197,
    1198,  1198,  1199,  1199,  1200,  1200,  1200,  1200,  1200,  1200,
    1201,  1201,  1202,  1202,  1203,  1203,  1203,  1203,  1203,  1203,
    1203,  1203,  1203,  1203,  1203,  1204,  1205,  1205,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,
    1206,  1206,  1206,  1206,  1206,  1206,  1206,  1206,  1207,  1207,
    1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,
    1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,  1207,
    1207,  1207,  1207,  1207,  1207,  1207,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1209,  1209,  1209,  1209,  1209,  1209,  1209,
    1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,  1209,
    1209,  1209,  1209,  1209,  1209,  1209,  1209,  1210,  1210,  1210,
    1210,  1210,  1210,  1210,  1210,  1212,  1211,  1211,  1213,  1213,
    1214,  1214,  1215,  1215,  1216,  1216,  1217,  1217,  1218,  1219,
    1219,  1219,  1219,  1219,  1219,  1219,  1220,  1221,  1219,  1219,
    1219,  1219,  1219,  1219,  1219,  1219,  1219,  1219,  1219,  1222,
    1219,  1224,  1223,  1225,  1225,  1225,  1226,  1226,  1227,  1227,
    1228,  1229,  1228,  1230,  1230,  1232,  1231,  1233,  1233,  1233,
    1233,  1233,  1233,  1233,  1233,  1233,  1233,  1233,  1233,  1234,
    1233,  1235,  1235,  1236,  1236,  1237,  1237,  1238,  1238,  1239,
    1239,  1240,  1240,  1241,  1241,  1242,  1242,  1243,  1244,  1244,
    1245,  1245,  1246,  1247,  1246,  1248,  1246,  1246,  1249,  1246,
    1250,  1246,  1246,  1251,  1246,  1252,  1246,  1246,  1253,  1253,
    1253,  1254,  1254,  1255,  1255,  1256,  1258,  1257,  1257,  1257,
    1259,  1260,  1261,  1259,  1262,  1264,  1265,  1263,  1267,  1266,
    1269,  1270,  1268,  1271,  1272,  1273,  1273,  1274,  1274,  1274,
    1274,  1275,  1275,  1277,  1276,  1278,  1276,  1279,  1279,  1280,
    1281,  1280,  1283,  1282,  1284,  1284,  1285,  1285,  1286,  1286,
    1287,  1287,  1288,  1288,  1288,  1288,  1288,  1288,  1288,  1288,
    1288,  1288,  1288,  1288,  1289,  1289,  1289,  1289,  1289,  1289,
    1289,  1289,  1289,  1290,  1290,  1290,  1290,  1291,  1291,  1291,
    1292,  1292,  1293,  1293,  1294,  1295,  1294,  1296,  1297,  1296,
    1298,  1298,  1299,  1299,  1300,  1300,  1301,  1301,  1301,  1302,
    1303,  1303,  1304,  1305,  1305,  1307,  1306,  1308,  1308,  1309,
    1309,  1309,  1310,  1310,  1311,  1311,  1312,  1312,  1312,  1313,
    1313,  1313,  1314,  1314,  1314,  1314,  1314,  1315,  1316,  1316,
    1316,  1316,  1317,  1317,  1317,  1318,  1318,  1318,  1318,  1318,
    1318,  1319,  1319,  1319,  1319,  1319,  1320,  1320,  1320,  1320,
    1320,  1321,  1321,  1321,  1321,  1321,  1322,  1323,  1323,  1324,
    1324,  1325,  1326,  1325,  1327,  1327,  1328,  1328,  1329,  1331,
    1330,  1332,  1332,  1333,  1333,  1335,  1334,  1337,  1338,  1336,
    1336,  1336,  1340,  1339,  1342,  1341,  1343,  1341,  1341,  1341,
    1341,  1341,  1341,  1341,  1344,  1341,  1341,  1341,  1341,  1341,
    1341,  1345,  1345,  1346,  1347,  1348,  1348,  1349,  1350,  1350,
    1351,  1351,  1353,  1354,  1352,  1356,  1357,  1355,  1358,  1358,
    1358,  1358,  1359,  1359,  1360,  1360,  1361,  1362,  1362,  1362,
    1363,  1362,  1364,  1364,  1365,  1365,  1366,  1365,  1367,  1365,
    1368,  1368,  1369,  1369,  1370,  1371,  1371,  1372,  1372,  1374,
    1373,  1375,  1375,  1376,  1376,  1377,  1377,  1378,  1379,  1378,
    1381,  1382,  1380,  1383,  1383,  1384,  1385,  1385,  1386,  1387,
    1387,  1389,  1388,  1391,  1392,  1390,  1393,  1390,  1394,  1390,
    1395,  1395,  1396,  1396,  1397,  1397,  1398,  1398,  1399,  1399,
    1400,  1400,  1400,  1402,  1401,  1403,  1403,  1404,  1404,  1405,
    1405,  1406,  1406,  1406,  1406,  1406,  1406,  1406,  1406,  1406,
    1407,  1407,  1409,  1408,  1410,  1410,  1410,  1410,  1410,  1410,
    1410,  1410,  1410,  1410,  1410,  1410,  1410,  1410,  1411,  1410,
    1412,  1410,  1410,  1410,  1410,  1410,  1410,  1410,  1410,  1410,
    1410,  1410,  1410,  1410,  1410,  1410,  1410,  1410,  1410,  1410,
    1410,  1410,  1410,  1410,  1410,  1410,  1410,  1410,  1410,  1410,
    1410,  1410,  1410,  1410,  1410,  1410,  1410,  1410,  1410,  1410,
    1413,  1413,  1413,  1414,  1414,  1415,  1415,  1416,  1416,  1417,
    1417,  1418,  1418,  1419,  1419,  1420,  1420,  1421,  1421,  1421,
    1423,  1422,  1424,  1422,  1425,  1425,  1425,  1425,  1425,  1426,
    1426,  1427,  1427,  1427,  1428,  1428,  1428,  1430,  1429,  1432,
    1431,  1431,  1433,  1433,  1434,  1435,  1434,  1436,  1436,  1437,
    1437,  1437,  1437,  1437,  1437,  1437,  1437,  1437,  1437,  1437,
    1437,  1437,  1437,  1437,  1437,  1437,  1437,  1437,  1438,  1438,
    1439,  1439,  1441,  1440,  1442,  1442,  1444,  1443,  1443,  1443,
    1445,  1445,  1447,  1446,  1448,  1449,  1449,  1451,  1450,  1452,
    1452,  1452,  1453,  1453,  1453,  1453,  1454,  1454,  1455,  1456,
    1458,  1459,  1460,  1461,  1457,  1462,  1462,  1463,  1463,  1464,
    1464,  1464,  1465,  1465,  1465,  1466,  1466,  1467,  1467,  1468,
    1468,  1468,  1468,  1469,  1469,  1470,  1470,  1471,  1471,  1472,
    1472,  1473,  1473,  1474,  1474,  1475,  1475,  1475,  1476,  1476,
    1477,  1477,  1478,  1478,  1479,  1479,  1480,  1481,  1481,  1481,
    1481,  1482,  1482,  1483,  1483,  1483,  1484,  1485,  1485,  1485,
    1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,  1486,
    1487,  1487,  1487,  1487,  1487,  1488,  1488,  1488,  1489,  1489,
    1490,  1490,  1491,  1492,  1492,  1493,  1493,  1494,  1494,  1494,
    1495,  1495,  1495,  1495,  1496,  1496,  1496,  1497,  1497,  1498,
    1499,  1499,  1500,  1501,  1502,  1503,  1503,  1504,  1504,  1505,
    1505,  1505,  1506,  1506,  1506,  1507,  1507,  1508,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,
    1509,  1509,  1509,  1509,  1509,  1509,  1509,  1509,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1512,
    1511,  1514,  1513,  1515,  1513,  1516,  1513,  1518,  1517,  1517,
    1519,  1519,  1521,  1520,  1522,  1520,  1524,  1523,  1523,  1525,
    1525,  1525,  1526,  1526,  1526,  1526,  1527,  1527,  1527,  1527,
    1528,  1529,  1529,  1529,  1529,  1529,  1529,  1529,  1529,  1529,
    1530,  1530,  1530,  1531,  1531,  1531,  1531,  1532,  1533,  1534,
    1534,  1535,  1535,  1535,  1535,  1536,  1536,  1536,  1537,  1537,
    1537,  1537,  1537,  1539,  1538,  1540,  1540,  1541,  1541,  1542,
    1542,  1543,  1544,  1544,  1544,  1544,  1544,  1546,  1545,  1547,
    1547,  1548,  1547,  1549,  1549,  1550,  1550,  1551,  1551,  1551,
    1551,  1552,  1551,  1553,  1553,  1553,  1553,  1553,  1554,  1555,
    1555,  1555,  1555,  1555,  1555,  1556,  1556,  1557,  1558,  1558,
    1558,  1558,  1558,  1559,  1559,  1560,  1560,  1561,  1561,  1562,
    1563,  1563,  1564,  1564,  1565,  1565,  1566,  1566,  1567,  1567,
    1569,  1568,  1570,  1568,  1571,  1568,  1572,  1568,  1568,  1568,
    1568,  1568,  1568,  1568,  1568,  1568,  1568,  1568,  1568,  1568,
    1568,  1568,  1568,  1568,  1568,  1568,  1568,  1568,  1568,  1568,
    1568,  1568,  1568,  1568,  1573,  1573,  1574,  1574,  1575,  1575,
    1575,  1576,  1576,  1576,  1576,  1577,  1577,  1578,  1578,  1579,
    1579,  1580,  1580,  1581,  1581,  1582,  1582,  1582,  1582,  1582,
    1583,  1583,  1584,  1584,  1585,  1586,  1586,  1586,  1586,  1586,
    1587,  1587,  1588,  1588,  1589,  1589,  1590,  1590,  1590,  1590,
    1590,  1592,  1591,  1593,  1593,  1594,  1594,  1594,  1595,  1595,
    1595,  1596,  1596,  1597,  1598,  1598,  1599,  1600,  1601,  1601,
    1603,  1602,  1604,  1604,  1604,  1605,  1605,  1607,  1606,  1608,
    1608,  1609,  1609,  1609,  1610,  1610,  1611,  1612,  1611,  1613,
    1614,  1615,  1616,  1616,  1617,  1617,  1618,  1618,  1618,  1618,
    1618,  1618,  1618,  1618,  1619,  1619,  1619,  1620,  1620,  1620,
    1620,  1620,  1621,  1621,  1621,  1621,  1621,  1621,  1622,  1622,
    1623,  1624,  1625,  1625,  1625,  1626,  1626,  1626,  1628,  1627,
    1629,  1629,  1630,  1630,  1632,  1631,  1633,  1633,  1634,  1634,
    1634,  1634,  1636,  1637,  1638,  1635,  1639,  1639,  1641,  1642,
    1643,  1644,  1645,  1640,  1647,  1648,  1649,  1650,  1646,  1651,
    1651,  1651,  1651,  1651,  1651,  1652,  1652,  1652,  1653,  1653,
    1654,  1654,  1654,  1655,  1655,  1656,  1657,  1656,  1658,  1658,
    1659,  1659,  1660,  1660,  1661
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     0,     4,     2,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     1,     4,     1,
       2,     0,     4,     0,     2,     3,     1,     2,     0,     3,
       0,     6,     1,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     5,
       1,     0,     1,     3,     1,     3,     3,     3,     3,     3,
       3,     3,     0,     1,     1,     0,     7,     0,     0,    15,
       0,     0,    15,     0,     0,    15,     0,     6,     0,     3,
       4,     5,     4,     3,     2,    10,     1,     3,     2,     2,
       2,     2,     2,     2,     2,     0,    13,     0,     6,     2,
       0,     1,     3,     1,     0,     2,     0,     2,     0,     1,
       3,     4,     0,     2,     0,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     1,     0,     2,     0,     2,     2,     2,     2,     2,
       3,     3,     1,     1,     1,     2,     3,     3,     0,     4,
       0,     3,     0,     1,     3,     1,     0,     1,     3,     1,
       0,     3,     0,     1,     3,     1,     4,     0,     1,     1,
       1,     0,     3,     2,     3,     0,     3,     0,     5,     5,
       0,     7,     5,     0,     2,     1,     1,     1,     3,     1,
       1,     1,     3,     0,     1,     1,     1,     1,     2,     1,
       3,     1,     1,     0,     1,     0,     2,     3,     5,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     4,     0,     1,     1,     3,
       1,     3,     3,     1,     2,     1,     1,     1,     1,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     0,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     5,     0,     2,     0,     3,     0,     2,     2,
       2,     2,     0,     6,     2,     0,     2,     1,     1,     3,
       0,     0,     0,     7,     0,     2,     2,     1,     1,     0,
       0,     8,     0,     6,     1,     2,     1,     2,     0,     0,
       6,     0,     0,     6,     0,     2,     0,     5,     0,     1,
       0,     5,     0,     2,     0,     5,     4,     0,     0,     8,
       0,     7,     1,     1,     1,     1,     1,     2,     4,     5,
       0,     4,     4,     4,     3,     3,     2,     2,     0,     2,
       1,     2,     3,     1,     1,     1,     1,     1,     2,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     1,     1,     1,     1,     1,     1,     2,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     1,     1,     1,     2,     2,     2,     1,     1,
       1,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     4,     0,     1,     1,     1,     1,     1,     0,     7,
       3,     0,     5,     1,     2,     4,     0,     0,     5,     0,
       7,     1,     0,     1,     0,     4,     0,     0,     3,     5,
       6,     0,     4,     2,     2,     2,     2,     0,     1,     0,
       3,     0,     1,     1,     3,     1,     4,     5,     5,     0,
       2,     0,     0,     7,     0,    10,     1,     3,     1,     1,
       0,     2,     0,     3,     1,     3,     0,     6,     1,     0,
       0,     5,     0,     4,     1,     1,     1,     3,     1,     3,
       0,     0,     5,     1,     3,     1,     1,     0,     3,     1,
       3,     0,     4,     1,     0,     1,     2,     1,     3,     4,
       3,     3,     3,     3,     4,     4,     3,     0,     0,     6,
       0,     1,     0,     1,     1,     2,     1,     1,     0,     1,
       1,     2,     1,     0,     3,     1,     3,     0,     1,     1,
       2,     1,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     0,     6,     1,     1,     3,     4,
       4,     2,     2,     2,     3,     3,     3,     3,     3,     3,
       3,     4,     4,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     3,     1,     1,     2,     2,     0,     8,
       0,     9,     0,     9,     0,     9,     8,     2,     0,     1,
       4,     0,     1,     2,     0,     3,     2,     0,     9,     0,
       2,     0,     1,     1,     0,     1,     2,     1,     1,     2,
       2,     4,     3,     3,     3,     3,     1,     2,     1,     1,
       3,     2,     3,     2,     2,     1,     3,     3,     2,     3,
       1,     2,     2,     2,     1,     2,     1,     1,     1,     2,
       3,     2,     3,     2,     2,     3,     3,     3,     0,     6,
       0,     6,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     1,     2,     1,     2,
       3,     2,     1,     1,     1,     1,     1,     1,     1,     2,
       0,     1,     1,     5,     0,     1,     2,     1,     1,     1,
       1,     3,     3,     3,     3,     0,     1,     0,     1,     0,
       1,     2,     1,     1,     2,     2,     4,     1,     3,     2,
       1,     2,     2,     2,     3,     3,     3,     3,     2,     2,
       1,     2,     1,     1,     1,     1,     1,     0,     2,     1,
       1,     1,     1,     1,     0,     2,     1,     1,     0,     1,
       1,     2,     2,     1,     2,     2,     0,     1,     1,     1,
       3,     1,     3,     0,     1,     0,     4,     1,     1,     1,
       0,     1,     2,     1,     1,     2,     1,     3,     3,     1,
       1,     0,     2,     0,     1,     5,     0,     3,     3,     1,
       0,     2,     2,     2,     0,     3,     3,     6,     6,     1,
       1,     2,     2,     2,     1,     2,     2,     1,     1,     0,
       1,     1,     1,     1,     0,     1,     1,     1,     0,     1,
       2,     0,     1,     0,     1,     0,     1,     1,     2,     1,
       2,     1,     2,     2,     2,     3,     2,     3,     3,     3,
       3,     1,     1,     1,     1,     3,     1,     1,     1,     4,
       2,     1,     4,     0,     1,     2,     0,     2,     1,     3,
       0,     0,     7,     0,     5,     7,     0,     5,     0,     5,
       0,     5,     0,     4,     0,    10,     3,     4,     3,     3,
       7,     0,     3,     1,     4,     0,     3,     0,     2,     0,
       1,     0,     2,     2,     2,     2,     1,     1,     1,     4,
       4,     0,     6,     4,     0,     5,     0,     6,     4,     3,
       1,     7,     2,     1,     1,     0,     6,     0,     3,     2,
       0,     5,     0,     0,     6,     1,     3,     1,     1,     3,
       3,     3,     2,     4,     0,     7,     0,     0,     8,     5,
       5,     3,     4,     2,     2,     6,     5,     3,     5,     1,
       1,     1,     1,     1,     0,     1,     1,     2,     2,     3,
       3,     3,     3,     0,     1,     0,     1,     0,     2,     0,
       1,     2,     1,     1,     1,     0,     1,     1,     0,     2,
       1,     0,     1,     1,     1,     0,     6,     0,     5,     4,
       4,     3,     0,     1,     1,     3,     3,     2,     2,     0,
       2,     1,     3,     0,     1,     1,     0,     2,     4,     1,
       3,     0,     5,     0,     1,     1,     0,     6,     0,     1,
       1,     2,     1,     1,     1,     2,     0,     5,     1,     3,
       2,     0,     3,     1,     4,     1,     0,     4,     1,     0,
       4,     0,     1,     3,     0,     1,     3,     1,     1,     2,
       0,     5,     0,     1,     1,     2,     1,     1,     1,     1,
       1,     2,     0,     5,     0,     1,     1,     0,     4,     4,
       3,     5,     1,     3,     3,     0,     6,     1,     1,     1,
       3,     2,     3,     1,     1,     0,     6,     1,     1,     1,
       3,     3,     4,     0,     6,     0,     2,     0,     4,     0,
       2,     1,     2,     4,     2,     3,     2,     3,     0,     3,
       0,     0,     6,     2,     1,     1,     2,     2,     8,     4,
       0,     1,     2,     1,     1,     1,     1,     0,     2,     4,
       3,     1,     1,     3,     4,     0,     0,     0,     2,     2,
       1,     1,     0,     2,     3,     0,     2,     3,     0,     2,
       3,     3,     3,     2,     3,     4,     3,     4,     3,     4,
       1,     3,     4,     3,     3,     6,     1,     5,     6,     5,
       7,     6,     8,     5,     6,     4,     4,     5,     3,     4,
       1,     3,     3,     3,     3,     3,     3,     5,     5,     3,
       3,     3,     3,     3,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     0,     2,     1,     2,     1,     1,     1,     2,
       2,     1,     1,     2,     2,     4,     1,     3,     1,     1,
       1,     1,     1,     3,     1,     1,     1,     1,     3,     2,
       2,     2,     2,     3,     3,     5,     6,     4,     4,     7,
       2,     6,     5,     6,     6,     4,     4,     5,     4,     6,
       2,     2,     4,     4,     4,    10,     6,     8,     6,     4,
       4,     6,     4,     4,     4,     6,     4,     7,     7,     7,
       6,     6,     6,     6,     3,     4,     6,     8,     2,     2,
       8,     8,     6,     6,     2,     6,     6,     8,     8,     6,
       8,     6,     2,     8,     8,     2,     2,     2,     6,     6,
       4,     4,     8,     4,     4,     4,     4,     3,     8,     4,
       4,     6,     4,     4,     4,     6,     8,     4,     3,     6,
       4,     6,     5,     8,     7,    10,     1,     6,     4,     4,
       4,     4,     4,     6,     4,     0,     5,     6,     2,     3,
       0,     4,     0,     3,     0,     1,     1,     3,     4,     4,
       5,     4,     4,     4,     5,     4,     0,     0,     7,     4,
       5,     4,     5,     4,     4,     4,     4,     4,     5,     0,
       8,     0,     3,     3,     1,     4,     0,     1,     0,     2,
       0,     0,     4,     4,     2,     0,     3,     2,     3,     2,
       1,     1,     2,     1,     2,     1,     2,     2,     2,     0,
       3,     0,     1,     1,     3,     1,     3,     1,     3,     0,
       1,     0,     2,     4,     5,     1,     1,     1,     1,     4,
       1,     3,     3,     0,     6,     0,     8,     4,     0,     8,
       0,    10,     6,     0,     8,     0,    10,     6,     1,     2,
       1,     1,     2,     0,     1,     5,     0,     5,     3,     5,
       2,     0,     0,     7,     1,     0,     0,     6,     0,     3,
       0,     0,     5,     0,     1,     0,     1,     0,     2,     3,
       3,     1,     1,     0,     7,     0,     7,     1,     2,     0,
       0,     2,     0,     2,     0,     1,     1,     1,     1,     3,
       1,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     1,
       0,     2,     0,     1,     0,     0,     3,     0,     0,     3,
       2,     0,     0,     4,     4,     2,     0,     1,     1,     3,
       3,     1,     2,     0,     1,     0,     4,     4,     2,     0,
       1,     1,     0,     1,     0,     1,     2,     5,     4,     1,
       3,     3,     1,     1,     1,     1,     1,     1,     0,     2,
       3,     4,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     0,     6,     0,     1,     3,     1,     3,     0,
       2,     3,     1,     2,     1,     0,     3,     0,     0,     7,
       2,     1,     0,     3,     0,     7,     0,     7,     4,     6,
       4,     4,     4,     4,     0,     6,     4,     4,     5,     6,
       4,     1,     3,     1,     2,     1,     3,     1,     0,     2,
       0,     1,     0,     0,     8,     0,     0,     6,     0,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     3,     4,
       0,     3,     3,     1,     2,     2,     0,     3,     0,     5,
       3,     1,     3,     1,     3,     1,     1,     0,     1,     0,
       4,     0,     1,     3,     1,     1,     1,     0,     0,     6,
       0,     0,    11,     3,     1,     3,     3,     1,     3,     0,
       1,     0,     4,     0,     0,     9,     0,     5,     0,     6,
       0,     2,     1,     3,     2,     4,     0,     2,     0,     2,
       1,     1,     1,     0,     4,     0,     1,     0,     1,     1,
       3,     1,     1,     2,     2,     2,     1,     1,     1,     1,
       0,     3,     0,     3,     2,     4,     4,     3,     4,     4,
       1,     3,     3,     3,     3,     6,     2,     2,     0,     6,
       0,     7,     5,     2,     1,     1,     1,     5,     5,     2,
       2,     1,     4,     3,     2,     3,     2,     2,     1,     3,
       4,     3,     3,     2,     3,     2,     3,     1,     1,     1,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       1,     1,     1,     1,     1,     0,     1,     0,     2,     0,
       1,     1,     1,     0,     2,     0,     2,     0,     2,     2,
       0,     4,     0,     4,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     0,     1,     1,     0,     4,     0,
       4,     1,     0,     1,     4,     0,     3,     3,     1,     2,
       2,     2,     2,     2,     3,     2,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       0,     3,     0,     3,     3,     1,     0,     4,     1,     2,
       0,     1,     0,     3,     3,     2,     2,     0,     5,     0,
       1,     1,     0,     1,     1,     2,     1,     2,     1,     2,
       0,     0,     0,     0,    22,     1,     1,     0,     1,     0,
       1,     1,     0,     1,     1,     0,     2,     2,     1,     3,
       4,     3,     3,     0,     2,     2,     1,     3,     3,     0,
       4,     0,     3,     1,     1,     0,     3,     2,     3,     1,
       1,     2,     0,     2,     3,     1,     5,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     1,     1,     1,     1,     2,     2,     2,     1,     1,
       3,     5,     1,     1,     1,     1,     1,     3,     4,     5,
       1,     5,     3,     2,     1,     3,     2,     2,     4,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       3,     0,     3,     0,     3,     0,     3,     0,     3,     2,
       0,     2,     0,     2,     0,     4,     0,     3,     1,     1,
       1,     1,     0,     1,     1,     1,     0,     2,     2,     2,
       3,     3,     4,     6,     2,     3,     3,     2,     3,     5,
       1,     3,     3,     1,     1,     3,     3,     1,     3,     2,
       2,     2,     2,     2,     1,     1,     4,     4,     1,     1,
       1,     1,     1,     0,     4,     1,     1,     1,     1,     1,
       3,     3,     1,     1,     2,     2,     2,     0,     3,     4,
       3,     0,     7,     1,     2,     1,     1,     1,     1,     1,
       1,     0,     5,     1,     1,     1,     1,     1,     3,     6,
       6,     6,     7,     5,     3,     4,     1,     3,     8,     8,
       8,     6,     4,     0,     3,     0,     3,     1,     3,     2,
       1,     1,     0,     1,     1,     2,     0,     1,     1,     3,
       0,     3,     0,     3,     0,     3,     0,     3,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     1,     3,     2,     2,     2,     2,     2,     2,     2,
       2,     1,     1,     2,     0,     1,     3,     1,     2,     2,
       2,     1,     3,     3,     1,     1,     3,     1,     3,     1,
       3,     1,     1,     1,     1,     4,     5,     4,     6,     1,
       0,     3,     3,     1,     1,     0,     2,     2,     2,     2,
       0,     2,     0,     3,     2,     1,     2,     2,     2,     2,
       2,     0,     3,     0,     1,     0,     3,     2,     0,     1,
       2,     0,     1,     4,     4,     5,     2,     3,     0,     1,
       0,     4,     0,     1,     1,     0,     1,     0,     2,     2,
       1,     0,     1,     1,     2,     3,     2,     0,     6,     3,
       0,     0,     0,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     2,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     3,     3,     3,     3,     0,     3,     3,     0,     7,
       0,     3,     1,     3,     0,     3,     2,     4,     0,     3,
       4,     4,     0,     0,     0,    16,     8,     7,     0,     0,
       0,     0,     0,    15,     0,     0,     0,     0,    12,     4,
       4,     3,     4,     3,     2,     1,     3,     5,     1,     1,
       0,     1,     1,     0,     2,     0,     0,     3,     0,     2,
       5,     3,     3,     3,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
       0,   930,  1134,  2691,     0,     0,     0,     0,     0,     0,
    2693,   585,    66,  1791,  1919,  1920,  1702,  1730,     2,     0,
    1134,   276,   179,     0,    78,  1732,     0,  1977,     0,     0,
    1134,     0,   487,     0,  1972,     0,     0,  1134,  1735,  1962,
     253,   179,  2693,     0,  1180,  2479,  1832,  1988,     0,     0,
       0,  1815,     0,  2557,  1780,     0,     0,  2824,     0,     0,
       3,     8,    19,     0,    41,    24,    29,    14,    18,    13,
      54,    48,    26,    39,   128,    38,    10,    57,    58,    16,
      45,    11,    12,    15,    37,    44,    33,    40,    52,  1171,
      22,    23,    30,    46,    62,    20,    59,    55,    21,  1921,
      25,    47,    42,    34,    56,    63,    35,    53,    36,    61,
      28,    49,    27,     9,    17,    50,    51,    43,    64,    31,
      60,    32,     0,   959,     0,     0,     0,     0,     0,     0,
    1037,   942,  2758,  2759,  2760,  1136,  1135,     0,  2693,  2092,
    1119,  1145,  2168,  2170,  2169,  2171,  2172,  2173,  2174,  2175,
    2176,  2109,  2177,  2178,  2180,  2179,  2181,  2182,  2183,  2110,
    2111,  2184,  2185,  2186,  2188,  2187,  2189,  2112,  2113,  2190,
    2191,  2192,  2193,  2114,  2116,  2115,  2194,  2197,  2196,  2195,
    2117,  2198,  2199,  2200,  2202,  2118,  2119,  2120,  2121,  2122,
    2201,  2123,  2203,  2124,  2204,  2205,  2206,  2207,  2208,  2209,
    2210,  2212,  2211,  2125,  2213,  2214,  2216,  2217,  2218,  2215,
    2219,  2221,  2220,  2222,  2223,  2224,  2126,  2225,  2226,  2227,
    2228,  2229,  2230,  2231,  2232,  2127,  2233,  2234,  2235,  2254,
    2128,  2236,  2239,  2238,  2237,  2240,  2241,  2242,  2244,  2243,
    2245,  2246,  2129,  2130,  2247,  2248,  2249,  2250,  2252,  2251,
    2256,  2257,  2258,  2131,  2253,  2255,  2456,  2259,  2260,  2262,
    2261,  2263,  2132,  2265,  2264,  2133,  2267,  2266,  2134,  2135,
    2268,  2269,  2270,  2090,  2271,  2091,  2272,  2275,  2276,  2273,
    2277,  2282,  2136,  2274,  2278,  2279,  2280,  2281,  2283,  2137,
    2285,  2284,  2286,  2287,  2288,  2289,  2290,  2291,  2292,  2293,
    2294,  2307,  2298,  2299,  2301,  2302,  2305,  2300,  2306,  2310,
    2309,  2311,  2312,  2313,  2314,  2315,  2308,  2296,  2303,  2304,
    2297,  2316,  2317,  2295,  2318,  2319,  2320,  2321,  2322,  2323,
    2324,  2325,  2326,  2327,  2328,  2330,  2329,  2331,  2332,  2333,
    2334,  2335,  2336,  2337,  2339,  2338,  2340,  2341,  2342,  2344,
    2343,  2346,  2347,  2138,  2345,  2348,  2349,  2350,  2351,  2352,
    2354,  2353,  2139,  2141,  2140,  2142,  2355,  2356,  2143,  2357,
    2359,  2358,  2360,  2361,  2362,  2364,  2363,  2365,  2366,  2144,
    2145,  2367,  2368,  2369,  2370,  2371,  2372,  2373,  2374,  2375,
    2376,  2377,  2378,  2379,  2380,  2382,  2381,  2383,  2384,  2385,
    2386,  2387,  2388,  2389,  2146,  2390,  2147,  2391,  2392,  2148,
    2393,  2149,  2394,  2395,  2396,  2397,  2398,  2150,  2399,  2400,
    2401,  2403,  2404,  2402,  2405,  2151,  2406,  2407,  2408,  2152,
    2410,  2409,  2411,  2153,  2413,  2154,  2155,  2412,  2157,  2158,
    2414,  2415,  2416,  2156,  2417,  2159,  2418,  2419,  2421,  2420,
    2422,  2423,  2424,  2160,  2425,  2161,  2426,  2427,  2428,  2429,
    2430,  2432,  2431,  2433,  2434,  2435,  2436,  2439,  2441,  2438,
    2440,  2437,  2442,  2443,  2444,  2445,  2449,  2450,  2451,  2452,
    2446,  2447,  2448,  2162,  2453,  2454,  2455,  2457,  2458,  2460,
    2459,  2163,  2164,  2461,  2462,  2167,  2463,  2464,  2465,  2469,
    2466,  2478,  2467,  2468,  2471,  2470,  2472,  2473,  2474,  2165,
    2475,  2166,  2476,  2477,   198,  2095,   181,  2096,  2108,   112,
    2546,  2545,  1081,  2548,  2547,  1120,  2694,  2695,   583,   886,
       0,     0,   179,     0,   887,     0,   885,   179,   134,     0,
       0,     0,  1808,     0,  1728,  1728,  1728,  1728,     0,  1728,
     179,  1728,     0,  1731,  1728,   179,  1728,     0,    71,  1927,
     277,     0,     0,     0,     0,     0,  2089,     0,  1738,     0,
       0,  1979,  1995,     0,  1996,  1990,  2543,     0,  1205,     0,
       0,     0,     0,   179,  1137,     0,  1789,     0,   243,   252,
     254,   255,   251,     0,  2695,  2706,  1172,  1178,  1190,     0,
    1899,   255,     0,   112,  1062,     0,   112,  1816,  1813,     0,
       0,     0,  1789,  1989,  2808,     0,     0,     0,  2804,     0,
    2809,     0,  1180,     0,     0,     1,     5,     0,     0,   582,
    2760,     0,   579,   580,  2249,  2359,  1912,  1910,  2084,     0,
     933,   960,     0,   938,     0,   936,  2101,  2100,  2099,     0,
     949,   948,   946,     0,   448,     0,  1039,     0,  2765,   940,
    1096,  2692,     0,   200,     0,     0,   113,   114,     0,     0,
       0,  2698,     0,     0,     0,   586,     0,     0,   133,     0,
       0,   583,   583,   583,  1812,  1811,  1810,     0,  1808,  2169,
    2109,  2183,     0,  2058,     0,     0,     0,  1489,     0,  2114,
       0,  2198,  2200,  2118,  2119,  2120,  2121,  2122,  2125,     0,
       0,  1218,  1218,  1218,  1215,     0,     0,     0,  2223,  2224,
    2063,     0,     0,     0,  2054,  2064,  2262,  2263,     0,  2056,
    2057,  2269,     0,     0,     0,  2284,     0,  2289,  2061,     0,
       0,  2325,  2327,     0,     0,  2331,  2332,  2333,  2334,  2038,
    1273,     0,  1215,  2053,  2060,  2351,  2046,  2360,  2365,  2366,
       0,  2375,     0,     0,  2397,     0,  2404,  2402,  2408,     0,
       0,  2429,     0,     0,  1215,  2037,  2449,  2450,  2451,  2452,
       0,  2055,  2162,  2062,     0,  2463,  1218,  1215,  1215,     0,
       0,     0,  2472,  2473,  2477,     0,     0,     0,  2730,  1272,
       0,  1451,     0,  1483,  1230,  1236,  1250,     0,  1265,  1299,
    1300,  1302,  1406,  1301,  1307,  1306,  1703,  2050,  1305,  1304,
    2051,  2052,  1298,  2074,  2095,  2073,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1895,     0,     0,  1714,  1728,
      73,     0,     0,  2606,  2621,  2622,  1218,  2618,  2623,  2243,
    2130,  2256,     0,  2620,  2612,     0,  2370,  2374,  2616,  2389,
    2392,  2610,     0,  2154,  2433,  2642,  2614,  2619,  2600,  2587,
    2601,     0,     0,  2604,  2608,  2086,  1597,  2560,  2561,     0,
      79,  1740,  1741,  1739,  1035,     0,  2821,  1980,  1981,  1982,
       0,  1999,     0,  1132,     0,     0,   497,   488,     0,  1894,
    1893,     0,  1973,  2707,     0,     0,  1086,  1743,  1790,     0,
    1742,  1968,     0,  1966,  1963,  1965,   244,     0,     0,   274,
    2170,  2606,  2374,  2578,     0,  2586,     0,  2701,  2698,  2708,
    2743,  2738,  2737,  2740,  2741,  1196,  2742,  1195,  2739,  2736,
    1205,  1191,  1193,  1194,   802,     0,     0,  2499,  2500,  2339,
    2360,  2398,  2501,  2446,     0,     0,  2520,  2480,  2485,  2481,
       0,     0,  1854,     0,   802,  1877,  1907,  1855,     0,     0,
    1907,     0,  1632,  1897,  1900,     0,  2503,  1868,   883,   882,
    1880,   881,  2504,  1893,     0,  1840,  1856,     0,  1817,  1861,
     112,  2505,     0,  1896,  1879,     0,  1878,  1632,  1907,     0,
    1833,     0,     0,     0,     0,     0,   250,  1069,  1069,     0,
       0,  1061,  1063,  1064,  1069,  1069,     0,  2822,  2823,  2558,
    1035,  2045,  2043,  2044,  2093,  2805,  2042,  2041,  2813,  2815,
    2801,  2803,  2810,  1174,     0,  2712,     6,    65,   129,  1205,
    1205,  2760,   583,   581,     0,  1924,  2763,  2764,  2762,   818,
       0,  1218,  2102,  2105,  2761,  2106,   182,   947,     0,   449,
     182,     0,     0,     0,     0,     0,   450,   451,   387,     0,
    1043,  1044,  1038,  1040,  1042,   944,     0,     0,   943,  2765,
       0,     0,  1147,  1149,  1148,  1165,   202,   199,   180,    80,
    1083,  1721,  1723,  1122,  2697,     0,     0,  2699,  2703,  1271,
    1270,     0,   126,   132,     0,  2593,  2597,     0,     0,  2105,
    2669,     0,   130,  2657,     0,     0,     0,     0,  1792,  1796,
    1802,  1806,  1809,     0,     0,  1602,  1320,  1602,  1602,  1602,
    1490,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1602,     0,  1358,  1330,  1331,     0,
    1359,     0,     0,     0,  2065,     0,     0,     0,  2730,     0,
       0,     0,  1456,     0,     0,     0,  2730,     0,     0,     0,
       0,     0,     0,  1485,  1487,  2073,  1602,     0,     0,  1602,
       0,     0,     0,     0,     0,  1223,  1364,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1602,  1602,     0,     0,  1602,  1372,  2067,     0,     0,     0,
    2066,     0,     0,     0,  2039,  2059,     0,  1375,  1377,  1376,
       0,  1602,  1602,     0,     0,     0,  1310,  1309,  1311,     0,
       0,     0,     0,     0,     0,  1269,  1268,  1267,  1266,     0,
       0,     0,  1274,     0,  1275,  1276,     0,  1277,  1278,  1279,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1312,
       0,     0,     0,  2040,  1415,     0,  1729,  1708,  1716,  1710,
       0,  1895,  1711,  1713,  1720,   462,     0,  1717,  2107,  2655,
    1712,     0,  1704,     0,    72,     0,  1951,  1956,     0,     0,
       0,  1946,  1954,  1948,  1955,  1947,     0,     0,  1957,   112,
       0,  1949,  1953,  1952,  1928,  1931,  1938,  1929,     0,     0,
     275,   278,   280,     0,   283,  2607,  2605,  2639,  2638,  2643,
       0,  2640,  2636,  2599,  2629,  2670,  2633,     0,  2670,  2635,
    2634,  2670,  2630,  2637,  2670,     0,  2602,     0,  1598,  1599,
       0,  2559,     0,  2085,  1036,     0,     0,  1983,  1984,     0,
    1155,  2000,  2001,  1997,  1597,  2544,  2549,     0,   691,  1206,
     498,     0,     0,   509,     0,     0,    68,    69,     0,  1139,
       0,  1138,  1142,     0,     0,     0,  1746,  1736,  1745,  1523,
    1969,   112,     0,   242,   267,   262,   270,   264,   266,   265,
     271,   272,   273,   268,   263,   269,   256,     0,     0,  2605,
       0,     0,  2602,  2702,     0,  2704,  2721,  1179,  2709,  1202,
    1181,  1201,     0,  1192,   801,     0,   804,   806,  1765,  1766,
     805,   814,     0,   803,     0,     0,  2517,     0,  2506,     0,
     810,   812,   811,  2514,   809,     0,     0,  2490,     0,     0,
    1903,     0,     0,  1867,     0,   583,     0,     0,     0,     0,
       0,     0,  1834,     0,     0,   634,     0,  1860,  1633,  1901,
    1902,  1907,     0,     0,  1907,     0,  1873,  1897,  1907,     0,
    1907,  1829,     0,     0,  1821,  1826,  1822,     0,  1828,  1827,
    1830,  1818,  1819,     0,  1847,  1875,     0,  1897,  1859,  1866,
       0,  1846,  1853,     0,  1864,  1897,  1897,     0,  1907,  1907,
    1057,  1073,  1055,  1067,  1068,     0,     0,  1060,  1059,  1814,
    1526,     0,     0,  2802,  2816,  2800,  2811,  2812,  2799,  1175,
    2713,  1173,  2714,     0,     7,     4,  1205,  1205,  1205,  2757,
       0,  2745,  2752,  2753,  2756,  2755,  2754,  2751,     0,  2744,
    2747,  2748,  2750,  2749,  2765,     0,  1914,  1915,  1916,  1917,
    1918,  1913,  1911,  1925,  1926,   819,   818,   574,   577,   576,
       0,     0,  2104,     0,   939,     0,  1895,   937,     0,     0,
    1895,   398,  1895,   452,   931,  1041,   951,     0,     0,   941,
    1097,  1098,  1101,     0,     0,   486,  1165,  1151,  1167,     0,
     203,   205,     0,  1085,  1084,     0,  1082,  1130,  1129,  1127,
       0,  1128,  1126,  1121,  1123,  1124,  2696,  2700,   584,   818,
    1895,     0,     0,   131,     0,   390,     0,     0,   888,   888,
     888,  1798,  1725,  1523,  1727,  2084,     0,     0,     0,  1804,
       0,     0,  1603,  1602,     0,  1465,     0,     0,     0,     0,
    1491,     0,     0,     0,     0,     0,     0,     0,     0,  1296,
       0,     0,     0,     0,     0,  1436,     0,  1465,  1219,  1677,
    1678,  1662,  1663,  1661,  1664,  1216,     0,  1665,  1676,  1387,
       0,     0,     0,     0,     0,     0,  1573,  1574,  1575,  1576,
    1584,  1577,  1578,  1579,  1586,  1591,  1580,  1581,  1587,  1588,
    1589,  1582,  1590,  1585,  1583,  1592,     0,  1572,     0,  1595,
    1593,  1596,  1594,     0,  1457,  1449,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1602,     0,
       0,     0,  1602,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1398,     0,     0,     0,     0,     0,  1602,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1354,     0,  2076,
    2075,     0,     0,     0,   851,     0,  1314,     0,  1313,  1535,
       0,  2715,  2731,     0,  2506,  1452,  1454,     0,  1221,  1220,
    1222,  1233,  1226,  1231,  1224,  1228,     0,  1280,  2176,  1234,
       0,     0,  1262,  2730,  1611,  1263,  1248,  1253,  1254,     0,
    1251,  1252,     0,  1256,     0,  1255,  1259,  1260,  1261,  1264,
       0,     0,     0,     0,  1303,  1308,  1484,  1205,  2077,     0,
       0,   462,   465,   464,  1718,   463,  1767,     0,  1045,     0,
       0,    74,    76,  1943,  1940,  1939,  1941,  1945,   112,  1950,
    1942,     0,  1958,  2223,  2449,  2452,   287,     0,   260,   259,
     261,   284,     0,     0,  2632,     0,  2613,     0,  2617,  2611,
    2615,  2595,     0,     0,  2603,     0,  2641,  2624,  2628,  2627,
    2625,     0,  2626,  2631,  2609,  1601,  2257,  2343,     0,  1604,
    2563,  1733,  2820,  1985,  2463,  1986,  1978,     0,  1998,     0,
       0,     0,  1133,   692,     0,  1205,   496,   495,   494,   493,
       0,   511,   491,   499,    70,     0,     0,  1974,     0,     0,
       0,     0,  1088,  1744,     0,     0,  1724,  1524,  1970,  1964,
       0,     0,     0,     0,     0,  2659,  2584,     0,     0,     0,
    2705,  2723,  2722,  2710,  1205,  1623,  1206,  1206,  2073,  2522,
       0,  2516,  2515,     0,     0,     0,  2535,  2518,     0,     0,
    2484,  2523,  2524,  2527,     0,     0,     0,     0,     0,  2521,
    2446,  2486,  2487,     0,  2492,  2482,  2541,  2542,  2539,  2540,
    2538,  2511,  1874,     0,  1905,  1908,  1909,     0,     0,  1888,
    1882,  1881,  1871,  1883,  1872,  1892,  1891,  1890,  1844,  1843,
    1645,  1646,  2401,  1644,  1636,  1639,  1643,  1642,  1837,  1898,
    1887,  1885,  1869,  1907,  1842,  1841,  1886,  1884,  1823,  1824,
    1825,     0,  1632,     0,  1903,  1876,  1907,  1897,     0,  1907,
    1907,  1889,  1863,  1865,  1058,  1075,  1074,  1070,  1071,  1076,
    1066,  1065,  1544,  1543,     0,  1498,     0,  1500,  1497,  1496,
    1495,     0,  1543,  2806,  2814,  2818,     0,  1632,  2720,  2718,
       0,     0,     0,   583,     0,     0,  2746,   115,   575,  1767,
    1767,     0,  2103,     0,     0,     0,     0,     0,     0,     0,
     183,   192,     0,     0,   396,   397,  1767,   395,   438,   439,
     442,   443,   444,     0,     0,     0,     0,     0,     0,     0,
       0,   136,   445,  1767,  1767,   392,   418,   419,   422,   423,
     424,   425,   426,   388,     0,   393,   818,     0,   953,   955,
    2766,  2767,  2768,     0,     0,  1100,  1154,  1146,  1153,  1150,
    1165,  1163,  1152,   878,   877,     0,  1166,   201,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      81,    82,   100,  1722,  1131,  1125,   127,   818,  1767,  1767,
    1767,  1767,   394,   427,   428,   431,   432,   433,   434,   437,
     435,   436,     0,  2598,     0,     0,  1895,     0,  2661,  2662,
       0,  2658,   889,     0,     0,     0,     0,     0,  1793,     0,
    2087,  1803,  1526,  1807,  1806,     0,  1383,     0,  1429,     0,
    1431,  1432,  1433,     0,     0,     0,     0,     0,  1384,     0,
    1328,  1385,  1386,     0,  1380,     0,  1381,     0,     0,     0,
       0,     0,     0,     0,  1435,     0,  1217,     0,     0,  1332,
    1333,  1325,  1317,     0,  1408,     0,     0,  1334,     0,     0,
       0,     0,  1389,     0,  1409,  1486,     0,  1488,  2077,     0,
    1441,  1390,  1339,     0,  1439,     0,  1340,  1410,  1411,  1412,
    1392,  1393,     0,  1414,     0,  1394,     0,     0,  1397,     0,
       0,  1342,  1445,  1443,     0,     0,     0,     0,  1447,  1344,
       0,     0,     0,  1343,     0,     0,     0,     0,     0,     0,
       0,  1346,     0,  1326,  1444,  1446,  1400,     0,     0,     0,
       0,     0,  1355,     0,  2724,  1534,  2732,  1535,     0,     0,
    2726,  2716,  2721,  2729,  1318,     0,     0,  2078,  1227,  1232,
    1225,  1229,  2730,     0,     0,     0,     0,  1246,  1245,     0,
       0,     0,  2730,  1611,  1249,     0,     0,  1425,  1426,  1481,
       0,  1709,  1706,  1719,  1768,     0,  2656,  1047,  1046,  1715,
    1045,    77,     0,  1944,  1937,  1959,  1932,     0,   279,   288,
     281,   285,   286,   282,  2674,     0,  2673,     0,     0,  2592,
    2651,  2654,  2084,     0,     0,     0,  2573,  2567,  2574,  2576,
    2570,  2575,  2577,  2568,  2569,  2564,  2571,  1605,  1634,     0,
    1987,  1156,  1158,  1159,  1157,  1165,     0,     0,  2552,  2553,
    2551,  2550,   501,     0,   510,     0,   522,     0,     0,     0,
    1976,  1975,     0,  1140,  1143,  1144,  1093,     0,  1092,  1094,
    1087,  1089,  1090,   567,  1750,     0,     0,     0,  1756,  1737,
    1747,     0,  1971,  1967,     0,   257,  2585,     0,     0,     0,
       0,     0,     0,     0,  1200,  1526,  1695,  1197,  1185,  1634,
    1624,  1184,  1207,  1203,     0,   817,   816,   815,   813,     0,
       0,     0,     0,  2529,  2530,     0,     0,  2507,  2508,  2509,
       0,  2512,  2489,  2490,     0,  2491,     0,  1904,     0,  1848,
       0,  1870,     0,     0,     0,     0,  1839,     0,  1862,  1820,
    1905,  1838,  1604,  1897,  1835,  1836,  1073,     0,  1056,  1543,
    1526,     0,     0,  1518,  1545,     0,  1545,  1520,  1521,  1526,
       0,  1526,  1523,  1540,     0,     0,  2817,  1625,  2719,     0,
    2794,     0,     0,     0,   181,   587,     0,     0,   935,   186,
     189,   187,     0,   188,     0,     0,   447,   446,     0,  1895,
     440,   140,   139,   141,   142,  1659,  1660,  1656,  1657,  1655,
    1658,   144,   143,   138,   950,     0,     0,     0,  1895,   420,
     399,   400,   403,   404,   405,  1033,  1767,  1033,     0,  1767,
    1767,  1033,  1767,     0,     0,  1767,  1767,     0,     0,  1767,
       0,     0,  1033,     0,  1767,     0,  1020,     0,     0,  1767,
    1767,  1767,  1767,  1767,  1033,     0,     0,  1767,  1767,   486,
    1767,     0,     0,  1051,     0,     0,  1767,  1767,  1767,  1767,
       0,     0,  1767,  1767,     0,  1767,   967,  1019,   589,   616,
     617,   932,   966,   968,   980,   482,     0,   998,  1022,  1023,
    1021,     0,     0,     0,     0,   150,  2770,  1099,     0,     0,
    1564,   204,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1895,   429,
    2594,     0,     0,  1767,   389,   406,   407,   410,   411,   412,
     413,   414,   417,   415,   416,     0,  2665,  2667,     0,     0,
     890,     0,     0,     0,  1726,  1806,  1526,  1604,  2085,  1604,
       0,  1805,     0,     0,  1430,  1466,     0,  1492,     0,  1322,
     775,   775,   775,  1475,   760,  1479,  1470,   775,  1471,   775,
    1473,     0,     0,     0,  1282,  1297,     0,     0,     0,     0,
       0,  1437,  1434,     0,     0,     0,     0,  1460,     0,     0,
       0,  1327,     0,  1420,  1442,  1440,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1448,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   840,   846,   849,   850,   852,   844,     0,  1402,
    1315,  1205,  2733,  2735,  1176,     0,  2725,  2727,   926,  1453,
       0,  1243,  1239,     0,  1237,  1610,  1258,  1257,     0,     0,
       0,  1247,  1206,  1416,  1205,     0,  1482,  2079,  1707,   461,
     633,  1705,    75,  1935,     0,  1930,  1933,     0,     0,  2671,
       0,  2682,     0,     0,     0,     0,     0,     0,     0,     0,
    2562,  1635,  1777,     0,  1165,  1169,  2094,  1991,  2555,  2556,
    2554,     0,   502,   503,   505,  1206,   519,   497,     0,   489,
     492,     0,   501,     0,  1095,  1091,  1190,     0,  1769,  1754,
    1761,  1755,     0,     0,     0,  1753,  2069,  2068,  2075,  2708,
       0,  1570,     0,     0,  2583,  2660,     0,     0,     0,  2711,
    1604,  1604,  1689,     0,     0,  1182,  1187,  1183,  1186,     0,
    1204,  1211,  1210,  2070,  2077,  2519,     0,     0,     0,     0,
    2534,  2528,  2525,  2526,     0,  2488,  2510,  2494,  2493,  2496,
    2498,  1669,  1670,  1668,  1666,  1667,  1906,  1632,  1858,  1857,
    1647,  1638,     0,  1641,  1640,  1831,  1850,  1852,  1907,  1072,
       0,  1079,  1077,     0,  2715,  1538,     0,  1522,  1519,  1546,
       0,  1545,  1545,  1526,     0,  1502,  1781,  1784,     0,  1501,
    1597,  1528,  1190,  2807,  2819,     0,     0,     0,   383,   382,
       0,   145,  2788,     0,     0,   671,   116,   473,   482,   588,
     591,   632,   631,   191,   190,   196,   197,  1673,  1674,  1671,
    1672,   453,   466,  1675,   467,   441,   137,   454,   455,   421,
       0,   401,  1034,   923,   583,  1002,     0,   672,   583,   874,
     879,   879,   583,     0,     0,  1134,     0,     0,  1728,     0,
       0,  1134,     0,     0,     0,  1767,     0,  1013,   962,     0,
    1728,     0,  1728,  1728,  1014,     0,     0,   963,  1767,     0,
       0,     0,     0,     0,  1728,  1134,     0,     0,     0,   484,
       0,  1134,   982,  1054,  1053,  1052,     0,  1134,  1134,     0,
       0,     0,     0,   622,   623,   621,     0,     0,     0,   614,
     590,   818,   964,   483,   965,   671,     0,  1048,   668,   674,
    2080,     0,     0,   160,     0,     0,   952,     0,   153,   151,
     162,     0,     0,  1103,     0,  1102,     0,  1567,     0,  1568,
    1565,  1566,   101,    88,    84,   105,   106,    86,    87,    91,
      90,    92,    93,    96,    97,    94,    89,    95,    85,   109,
     111,   110,    98,   107,   108,    83,   460,   459,   458,   457,
     430,     0,     0,     0,  1895,   408,  2666,  2664,  2663,     0,
     916,   918,   917,   904,   903,   117,   120,   123,     0,  1604,
    1623,  2088,  1797,     0,  1356,  1493,     0,     0,   776,  1467,
     826,  1477,     0,  1478,   762,   761,   777,  1469,  1472,  1476,
    1474,  1321,  1329,  1378,     0,  1295,  1379,     0,  1407,  1324,
    1323,     0,     0,     0,  1362,  1363,     0,  1458,     0,     0,
    1336,     0,  1338,     0,     0,  1422,  1391,  1413,  1365,  1395,
       0,  1341,  1316,     0,  1366,     0,  1371,  1369,     0,  1345,
       0,     0,  1352,     0,  1350,     0,  1351,     0,  1353,  1399,
    1401,     0,     0,   851,   837,   838,   839,     0,   841,   843,
     845,     0,     0,  1536,  2734,  1177,     0,     0,  1455,  1235,
       0,  1244,  1241,     0,  1238,  1207,  1427,  1417,     0,     0,
     296,   291,   299,   293,   295,   294,   300,   301,   302,   303,
     297,   292,   298,   290,   289,  2672,     0,  2591,  2596,  2653,
    2652,  2675,  2675,  2675,     0,  1606,     0,  1734,  1160,  1165,
    1169,     0,  1161,  2002,   506,     0,     0,     0,   526,     0,
     524,   500,     0,  1141,  1205,  1751,  1763,     0,  1771,     0,
       0,  1748,  1758,     0,     0,     0,  1757,   486,     0,   258,
       0,  2580,  2581,  2579,  1634,  1612,     0,     0,  1701,     0,
    1696,  1198,     0,  1209,  1208,     0,  2537,  2536,  2532,  2531,
    2533,  2513,     0,     0,  1849,  1637,  1632,  1845,     0,     0,
    2721,  1597,  1530,  1526,  1499,  1526,     0,     0,  1507,  1526,
    1503,  1505,     0,  1604,     0,  1562,  1205,  2072,  1626,  1629,
       0,  2795,   386,   384,   385,     0,     0,   206,   649,   650,
     648,   647,     0,   474,     0,     0,     0,   651,   652,   654,
     655,  2002,   481,   818,   592,   402,   673,   924,  1134,     0,
       0,     0,   879,   667,   583,   923,   888,   880,   583,   583,
    1000,  1029,  1030,     0,     0,   600,   597,     0,   609,   983,
     974,   984,   995,   997,     0,   599,   624,     0,     0,   612,
    1728,     0,  1011,     0,     0,   594,     0,     0,   643,   644,
     642,   618,   625,  1031,  1032,   595,   596,     0,     0,  1619,
    1621,  1629,   602,   601,  1680,  1679,   611,     0,   598,     0,
    1017,   990,     0,   640,   638,   635,   637,   636,   641,   639,
     613,   604,   603,   606,   605,   608,   607,   610,   626,   979,
       0,  1033,  1033,   999,     0,  2083,     0,  1050,  1001,     0,
     656,   669,   657,     0,     0,   630,   629,   627,   628,   161,
     149,     0,     0,   954,   956,     0,     0,   957,  2772,     0,
    2774,  1105,  1106,     0,     0,  1168,     0,     0,   102,   104,
       0,   391,   456,   409,  2668,     0,     0,     0,  1806,  1799,
    1648,     0,  1494,     0,     0,     0,     0,   820,   831,   829,
     823,     0,   827,   828,  1468,     0,     0,   778,  1480,   742,
     775,  1292,   760,  1286,  1288,  1284,     0,   743,  1287,   775,
       0,   826,  1291,  1283,     0,  1438,     0,     0,  1461,     0,
       0,     0,     0,     0,     0,     0,  1319,     0,  1418,     0,
       0,     0,     0,     0,     0,  1349,  1347,  1348,   835,  1404,
       0,   848,   842,   840,   847,     0,  1634,  2715,   927,  1240,
       0,  1428,  1936,  1960,     0,     0,  2680,  2680,  2680,  1776,
    1775,     0,  1774,  1778,  1162,  1170,  2004,  2003,     0,   504,
     507,     0,   499,     0,   523,     0,   490,   568,     0,     0,
       0,  1772,  1760,  2712,  1749,  1752,  2077,  1525,  1571,  2582,
    1189,     0,  1607,  1700,  1697,     0,  1690,  1692,  1694,     0,
    2071,  2495,  2497,  1851,  1078,  1080,  1531,  1529,  1539,     0,
    1495,  1526,  1526,     0,  1495,     0,     0,  1783,  1623,  1785,
    1527,  1559,  1541,     0,  1630,  1631,  1628,     0,   217,  1205,
       0,     0,   207,   209,   210,     0,     0,   471,   468,   671,
     470,   570,   593,   985,     0,   583,   875,   876,   888,   925,
       0,   888,   888,     0,     0,   973,  1004,  1122,     0,   978,
     814,   619,     0,   969,  1012,  1045,     0,   620,  1006,   971,
       0,  1622,   485,   970,   992,   976,  1958,  1003,  1049,   856,
     756,   705,   696,   775,   699,   698,   775,   710,   760,   758,
     728,   760,   760,   735,   734,   752,   738,   718,   826,   826,
     717,   755,   826,   739,   737,   741,     0,   743,   760,   748,
     736,   740,   757,   733,   730,   754,   775,   775,   775,   714,
     753,   826,     0,   746,   775,   675,   779,   716,   826,   833,
       0,     0,   775,   777,  2082,   147,   152,   163,   164,   945,
    2771,     0,  2769,     0,  1111,     0,  1164,  1569,    99,     0,
       0,     0,     0,     0,     0,  1794,  1357,   773,   771,   774,
     772,   822,   821,   825,     0,   824,   833,     0,     0,  1294,
    1289,   744,  1293,  1285,  1290,  1382,  1360,  1361,     0,  1459,
    1450,  1388,     0,  1337,  1419,     0,     0,  1396,  1367,  1370,
    1368,  1373,  1374,     0,  1403,     0,  1197,  1197,   645,  2728,
    1242,     0,  1934,  2683,     0,     0,  2679,  2677,     0,  2678,
    2676,  2644,     0,  2589,  2590,  2588,  2572,     0,     0,     0,
    1205,   512,     0,   529,   528,   525,  1634,  1762,  1764,  1770,
    1759,     0,  1608,  1623,   807,  1693,     0,  1199,     0,  1508,
       0,  1512,  1517,  1513,     0,  1504,     0,  1648,  1563,     0,
    1634,  1629,     0,   220,   218,   219,     0,   213,   215,   210,
    2782,     0,  2789,     0,     0,  2787,   475,  2712,   587,   653,
     571,     0,   987,     0,     0,     0,     0,     0,     0,  1016,
       0,     0,   975,   996,  1018,  1010,  1009,     0,     0,  1134,
    1620,   991,   993,  1088,     0,     0,   860,   704,   697,   715,
     713,   764,   759,     0,   764,   764,   724,   742,   719,     0,
     826,   732,   723,   744,   747,   749,   751,   764,     0,   826,
     712,   711,   721,   708,   764,   787,     0,     0,     0,     0,
     783,     0,   854,     0,   790,     0,   676,   780,   782,     0,
       0,     0,   745,   826,   701,   834,   833,   703,   826,   833,
     764,   764,     0,   154,   958,   323,  2773,  1180,     0,  2778,
       0,  1112,  1108,  1109,  1104,   103,   135,     0,  1629,   921,
       0,     0,  2401,  1649,  1800,   832,   830,     0,  1462,  1629,
       0,  1421,  1423,   836,     0,  1537,   646,     0,  2650,  2649,
    2648,  2645,     0,     0,     0,     0,     0,     0,  2681,  2685,
    1773,     0,     0,     0,   520,     0,     0,   554,   569,  1616,
    1629,     0,  1634,     0,  1698,  1691,  1532,     0,     0,     0,
       0,     0,  1782,  1551,  1552,     0,     0,  1557,  1561,  1542,
    1627,  2786,  2796,   217,     0,     0,   158,     0,   208,   814,
     211,   472,   482,     0,   477,     0,     0,   986,   670,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1015,
    2047,  1048,   486,  1007,   972,     0,   977,   615,     0,   859,
       0,   864,   768,   769,   770,   725,   765,   767,     0,   727,
     695,   720,   750,   726,     0,   722,   709,   793,   792,  1212,
     785,   800,   680,     0,     0,   791,   677,   781,   789,   784,
       0,   700,   702,   706,   707,   693,   694,  2081,     0,   156,
     349,     0,   335,   321,     0,     0,     0,   325,   165,   168,
     166,     0,   167,   173,     0,   174,   175,   176,   177,   178,
     169,   347,   348,   172,   170,   171,     0,  2097,     0,  2098,
    2776,     0,     0,  2775,  1107,     0,  1114,   891,     0,   920,
       0,   893,   895,  1650,     0,  1205,  1795,   763,     0,  1464,
    1335,  1405,  1961,  2646,  2686,  2689,  2687,  2688,  1652,     0,
    2690,  2684,     0,  1523,  1206,     0,   513,     0,   516,   518,
     532,     0,  1767,  1767,     0,     0,  1767,  1767,  1767,  1767,
     547,   555,   557,     0,  1617,  1618,     0,  1613,  1615,  1609,
    1681,   808,  2005,  2715,  1509,     0,  1514,     0,  1506,  1547,
    1547,  1558,   184,   214,     0,     0,   150,   159,  2790,   798,
    2002,     0,  2708,   989,     0,     0,     0,   658,     0,     0,
    2049,  2048,  1005,   981,  1048,     0,   857,     0,   861,   862,
     863,     0,   855,   766,     0,   928,     0,     0,   799,  1212,
     788,     0,   797,   796,   794,   795,   155,     0,   148,     0,
       0,   334,   337,     0,     0,   340,   330,   329,   331,     0,
     324,   323,   323,   377,   328,   374,   373,   366,  2712,     0,
       0,     0,  1113,  1118,     0,  1115,  1117,     0,  1767,   118,
     892,   912,   911,   897,     0,  1629,     0,     0,   121,   894,
     914,   901,   124,   896,   913,   899,  1651,  1801,  1629,  1654,
    1653,  1779,  1787,     0,  1992,     0,   521,   514,     0,     0,
     530,     0,     0,  1767,  1767,     0,     0,     0,     0,     0,
     527,   556,  1767,  1629,     0,  1188,     0,  2013,  1533,     0,
       0,     0,  1555,  1553,  2797,   216,  1205,   162,     0,   469,
     479,   478,   988,     0,   664,   891,   660,   662,  1008,     0,
     858,     0,     0,   826,     0,   826,  1213,     0,   786,  1205,
     157,   350,   361,   364,   356,   336,     0,     0,     0,   326,
     323,     0,   310,   308,   309,   315,   316,   317,   318,   319,
     320,   311,   314,   312,   313,   323,     0,   225,     0,     0,
    2777,     0,  2779,     0,  1110,     0,   906,     0,  1024,   898,
       0,   919,   922,     0,  1024,   902,  1024,   900,  1463,     0,
       0,   807,   508,   520,   517,   540,   533,   536,     0,   566,
     560,     0,     0,   562,   563,   561,   558,   551,     0,   549,
       0,  1614,  1682,     0,     0,     0,     0,  2006,  2008,     0,
    1699,  1511,  1516,     0,  1548,     0,     0,     0,   194,   193,
     185,     0,   323,  2783,     0,  2791,  2712,   666,   891,   659,
     893,   895,     0,   870,     0,   869,     0,   866,   865,   729,
     929,   731,  1214,     0,     0,     0,   323,   357,     0,   332,
       0,     0,     0,     0,   223,   380,     0,   221,   368,   368,
    2780,  2781,  1116,   905,   119,  1026,  1025,   910,   909,   907,
     908,   915,   122,   125,  1786,  1788,  1993,   515,   540,     0,
     538,     0,   534,   531,   535,   564,   565,     0,   548,     0,
     559,     0,     0,     0,     0,     0,  2007,     0,     0,  2014,
    2016,  1550,  1549,  1564,     0,   195,  2798,     0,   164,   184,
     480,   665,   661,   663,   994,   872,   873,   871,     0,     0,
     681,   358,   364,   354,   362,   323,     0,     0,   322,   341,
     376,   224,     0,   378,     0,   323,     0,   367,   369,   371,
    1028,  1027,  2019,   537,     0,   545,   541,   543,   546,   554,
     553,   550,  1205,  2011,  2012,     0,  2009,     0,     0,  2015,
       0,     0,     0,   146,  2792,     0,     0,   683,   682,   684,
       0,   355,     0,     0,   353,   333,   338,   323,     0,   323,
     236,   235,     0,   227,   304,   375,     0,   226,     0,  2005,
     539,     0,     0,   552,     0,     0,  1685,  1687,  2010,  2018,
    2017,  1556,  1554,  2784,   323,   868,   867,     0,   688,   678,
     685,   687,   359,     0,   323,     0,   323,     0,   323,     0,
       0,     0,     0,     0,   222,     0,  2013,   544,   542,  1206,
    1683,  1205,   323,  2793,   690,   689,   686,     0,   351,   323,
     339,   344,   381,     0,   230,   305,   306,     0,   233,     0,
    2021,  1688,  1686,  2785,   323,   323,   340,   343,   379,     0,
       0,   228,   229,   241,   240,   232,     0,  2020,     0,  2025,
     323,   323,   345,   249,   247,   323,   237,   245,   239,     0,
     246,   307,   234,     0,     0,  2032,     0,   231,   248,  2023,
    2024,  2022,  2027,     0,     0,  2029,  2030,     0,  1994,   238,
    2031,  2026,     0,  2033,  2035,     0,  2028,     0,  1205,  2034,
       0,  1206,  2036
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,    59,   627,  1535,    60,    61,    62,    63,    64,  1376,
      65,   840,  1294,  1841,  1842,    66,   567,    67,  1602,  2160,
    2161,  3507,  3508,  2162,   665,   666,    68,  2535,  3515,  4448,
    3516,  4454,  3517,  4456,  1619,   630,   538,  2100,  2101,  1539,
    3366,  3086,  3993,  3090,  4149,  4298,  4256,  2118,  3497,  3994,
    3995,  4158,   562,  2533,  1574,  4384,  2080,  4500,  2081,    69,
     663,  1087,  1599,  1600,  3671,  3672,  3904,  3673,  3896,  3897,
    3898,  3899,  4615,  4420,  4537,  4616,  4701,  4739,  4745,  4746,
    4662,  4755,  4756,  4757,  4743,   917,  4758,    70,   590,   591,
     919,  1406,  1856,  1407,    71,    72,   561,  1320,  1321,  1322,
    1323,  2373,  1857,  2368,  2369,  3263,  4663,  4741,  4421,  4422,
    4305,  4423,  4161,  4424,  4309,  4425,  4164,  4426,  4427,  4428,
    4429,  4607,  4430,  4304,  4655,  4417,  4418,  4657,  4721,  4737,
    4431,  4171,  4299,  4524,  4172,  4300,  4602,  4413,  4603,  4650,
    4717,  4414,  4525,  4653,  4528,  4432,  4438,  4617,  4433,  4439,
    4434,  4176,  4316,  4437,  4314,  4436,  4659,  4612,  2970,  3365,
     650,   651,   678,  2186,   652,  1103,  1057,  1576,  2113,  2114,
    2570,  2571,  2684,  2685,  2686,  2105,  2106,  2107,  2172,  2173,
    2174,  2087,  2088,  2089,  1580,  2084,  2085,   653,  1058,  1068,
    2108,  2109,  2110,  2690,  2176,  2177,  2178,  2179,  2111,  1834,
    2112,  2991,  2976,  3908,  3907,  2977,  3680,  4262,  4506,  3381,
    3382,  3073,  3447,  2131,    73,   579,   897,  1373,  2417,  1374,
    2419,  2851,  2852,  2853,  1906,  1907,  3861,  1911,  2416,  4044,
    4463,  4217,  4218,  2855,  4216,  2859,  3289,  3290,  3613,  3863,
    4047,  4468,  4359,  4563,  4466,  4559,  4467,  4561,  4672,  4626,
    4627,  4370,  4478,  4479,  4567,  4629,  4230,  4231,  4232,  2438,
    2866,  3866,  3911,  2166,  1566,  1567,   631,   632,   633,  3395,
      74,  2978,  2627,  2979,  2980,  3470,  2629,  2630,  2819,  1464,
    3460,  3431,  3836,  3372,  3376,  3377,  3378,  3379,  3380,  4395,
    4510,  4511,  4508,  3480,  3393,  3006,  3007,  3078,  3483,  3765,
    4291,  3975,  4649,  4689,  4690,  4691,    75,   894,  4079,  3943,
    3958,  3767,  3768,  3769,  3770,  3771,  3772,  3773,  3163,  3164,
    4115,  4116,  4117,  3158,  3159,  3538,  3976,  3977,  3978,  4080,
    4130,  3531,  1430,  1431,  4054,  1442,  1443,  2466,  1951,  2467,
    1570,  3532,  3533,  3534,  3987,  3222,  3833,  3228,  3229,  3230,
    2782,  2783,  2784,  2785,  2786,  2311,  3979,  3482,  3936,  4108,
    4111,  4282,  4517,  3008,  3394,  3009,  3398,   999,   539,  3010,
    3011,  2192,  2193,  4329,  4338,  4342,  4330,  4343,  4339,  4331,
    4332,  4333,  4345,  4341,  3143,  4007,  4008,  3386,  3396,  3238,
    4284,    76,   130,  2116,  1049,  1060,  1056,  1079,   658,  1586,
    2119,  2645,  3779,   640,  2631,  3929,  3697,  3933,  2632,  3410,
    2633,  3912,  4087,  2634,  3714,  3931,  4105,  3411,  3412,  2635,
    2636,  2637,  3921,  3928,  4274,  4544,  4545,  4546,  3012,  1355,
     655,   656,  1072,  1073,  1074,  2359,  3478,  3056,    77,  2039,
    2034,    78,  1011,  1012,  1013,  1510,  1511,  2037,  2038,  2508,
    2942,    79,   668,  1606,    80,  1384,  2430,  2431,  2432,    81,
    1080,  1590,  1591,  2125,  3095,  3503,  3784,  4004,  4186,  4000,
    4324,  4325,    82,    83,   669,  1613,  1614,  1615,    84,  1367,
     137,    85,   905,  1379,  1381,  1382,    86,   662,  1081,  1082,
    1083,  1084,  2127,    87,  1897,  2401,  2402,  2403,  2404,  1596,
    2649,  1597,  1598,  2136,  3282,    88,    89,   624,  2319,   596,
     929,   597,   598,  1945,  2457,  3837,   940,   941,   942,  2895,
    1420,  1421,  1422,  1903,  2900,  4288,  1150,  1146,   803,   804,
     805,   806,  1240,  1241,  3980,   807,  1250,  1800,  3175,  3553,
    1659,  1660,   808,   809,   810,   811,   812,   813,  1827,  3194,
    3195,  3568,  2346,  2347,  2348,   814,  2233,  3181,  2246,   815,
    1233,  1785,  1715,  3560,  3187,  3818,  4018,  1644,  2209,  2731,
    3166,  2815,  2313,  1172,  1173,  1131,  2216,  1650,  2045,  2046,
    2047,  2048,  2049,  3655,  3656,  4057,  3880,  4059,  3884,  2518,
    2519,  1926,  1927,  2050,  2051,  2943,  3878,  4243,  2314,  2315,
    2316,  3586,  2944,  3343,  2961,  2962,  3890,  2509,  2052,  2950,
    4382,  4066,  4067,  4497,  4496,  4068,  3888,  3889,  3660,  3661,
    3098,  3099,  3100,  2880,  1706,  1707,  1713,  1350,  1351,  1645,
    2398,  2839,  3873,  4051,  2337,  3632,  4049,  4237,  2640,  3439,
    3440,  2459,  2460,  2965,  3358,  3666,  1467,  3838,  2841,  2004,
    2930,  2931,  3795,  4210,  4744,  2787,  2926,  2992,  1677,  1678,
    3446,  4375,  4571,  4675,  4676,  4677,  3318,  3319,  3636,  3637,
    2461,  2892,  3320,  3874,  4242,    90,   543,    91,  1839,  2818,
    1291,  2365,  1091,  1386,  1631,  1632,   827,   557,    92,   568,
    2399,    93,   586,  1924,   884,   909,  1387,  1388,  2439,  2867,
    2874,  2440,  2879,  3623,  2869,  3295,  3296,  2354,  2355,  2870,
    3298,  3620,  3601,  3602,  3277,  3858,    94,   612,  3353,  2956,
    2957,  4351,  4352,   910,    95,   542,  1118,  2707,  4014,  1637,
    2197,  4196,  1119,  1120,  2200,   687,   688,    96,  1016,   608,
    1490,  1491,  1492,  2022,    97,   600,  1000,  2927,  3336,  1998,
     901,  1286,  1471,  1003,  1472,  1984,  2489,  1453,    98,  1045,
    1044,  1561,    99,   636,  1562,   100,   841,  1314,  1852,  2825,
    2826,  3248,  1315,  1316,  2366,  3842,   101,   587,   914,   915,
    1391,  2443,   102,   581,   902,  1917,   103,   571,   889,  1359,
    1896,   104,   105,   106,   891,  3283,  4461,  4622,   575,  1899,
    1363,  3681,  4377,  4487,  4488,  4490,  4579,  4580,  4669,  4749,
    4771,  4765,  4774,  4775,  4778,  4783,  4784,   817,  1025,  1026,
     818,  4099,   819,   820,   821,  2875,  2876,  3359,   822,  2877,
     823,  3079,  1092,  1634,   565,   515,   647,  1027,  2847,   825,
    4178,  1052,  1288,  1110,  1111,   517,   518,   107,   599,   957,
    1447,  1437,  1446,  1971,  2483,  1975,  2485,  2486,  3332,  2918,
    3333,  2919,  1005,  1967,  1972,  2920,   960,  1960,  1961,  1962,
    1963,  2911,  1957,  1981,   108,   892,   524,   525,  1365,  1366,
    2410,   109,   611,   110,  1352,  1889,  1890,  2395,  2838,  2396,
     111,   923,   924,   112,   869,  1623,  2379,  1105,  1055,  1106,
    1875,   872,  1326,   873,   874,  1341,  1335,  1344,  1338,  4032,
    3850,  3851,  2383,  1290,  1112,  1936,  2190,  3139,  1113,  1866,
    2375,  2376,  3596,  3853,  3267,  4038,  4039,   113,   138,   527,
     671,  1098,  1414,   114,   115,   116,   117,  1417,  1530,  2453,
    1531,  2320,  1532,  1533,  2059,  1943,  1781,  1782,  3236,  1230,
    1231,  2323,  2791,  2792,   943,  1038,  1549,  1541,   131,   132,
     133,   134,  1077,  1078,  2646,  3092,  3499,  3782,  3783,  3999,
    4183,  1543,  4075,  4587,  4712,  1544,  1545,  3367,  4077,  4388,
    4589,  4684,  1546,  2967,  3668,  4252,  4502,   118,  1028,   621,
    1528,  1523,  1525,  2055,  2526,   119,   120,   121
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4105
static const int yypact[] =
{
    5580,  2351,    84, -4105,  -163,   175, 57464,   601,   533,  -183,
     409,  3254, -4105, -4105, -4105, -4105, -4105,  3377, -4105, 57464,
      84,  1118, -4105, 25631, -4105, -4105,   -46, -4105,   108,   533,
      84,   612, -4105, 57464, -4105,   844,  1010,    84, -4105, -4105,
   50468, -4105,   409, 57464, -4105, -4105, -4105, -4105, 50468,   208,
     190,   871,  1034, -4105, -4105, 57464,  1126, -4105,  -133,  1415,
    1310, -4105, -4105,  1027, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105,   962, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, 26270,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105,  1397, 57464,  1423, 57464,  1418, 57464, 48560, 57464,
   -4105,  1475, -4105, -4105,  1567, -4105, -4105,   533,   409, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105,  1083, -4105, -4105,  -163,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105,  1723,  1538, -4105,
    1575,  1350, -4105, 48560, -4105, 57464, -4105, -4105, -4105,  1580,
    1653,  1667,    88, 11987,  1588,  1588,  1588,  1588,  1696,  1588,
   -4105,  1588, 57464, -4105,  1588, -4105,  1588,   533, -4105, -4105,
   -4105,  1799, 36476, 57464,  1539,   185,   599, 48560,   182, 57464,
    -163,   806, -4105,  1704, -4105, -4105, -4105,   533, -4105,  1909,
    1810,   967, 57464, -4105, -4105,  -183,   173,     9,  1364, -4105,
   -4105,  1522, -4105, 37112,   181, -4105, -4105, -4105,  2741, 28187,
    6472,  1522,  1526,  -163,  -126,  1532,  -163, -4105, -4105, 57464,
    -163,   533,  1733, -4105, -4105,   279,   279,   279, -4105,   279,
   -4105,   279, -4105,  -133,  1388, -4105, -4105,  1387, 57464, -4105,
     317,  1502, -4105,  1508,  1157,  2136, -4105, -4105,  1409,   -44,
   -4105,  1501, 40928, -4105, 57464, -4105, -4105, -4105, -4105,  1710,
   -4105, -4105, -4105,  1849, -4105,  1562,   772, 57464,  1603, -4105,
   -4105, -4105, 25631,  1477, 57464,  1558, -4105, -4105, 25631, 25631,
     212,   943,    21, 57464, 57464, -4105, 45380,  1953, -4105,  2129,
   40928,  1538,  1538,  1538, -4105, -4105, -4105, 51104,    88,  1517,
    1525,  1533, 17251, -4105,  1541,  1553,  1563, 11987,  1578,  1591,
    1634,  1636,  1639,  1641,  1643,  1657,  1670,  1672,  1674,  1681,
    1684,  1703,  1703,  1703,  1705,  1720,  1742,  1748,  -196,  1754,
   -4105,  1760,  1765,  1785, -4105, -4105,  1787,  1806,  1813, -4105,
   -4105,  1815,  1818,  1820, 12645,  1822,  1824,  1827, -4105, 22424,
    1837,  1841,  1844,  1856,  1868,  1875,  1880,  1882,  1888, -4105,
   -4105, 11987,  1705, -4105, -4105,  1894, -4105,  1896,  1898,  1914,
    1919,  1948,  1958,  1962,  1969,  1972,  1974,  1977,  1980,  1985,
    1998,  2002,  2015,  2023,  1705, -4105,  -194,  2057,  2064,   590,
    2066, -4105,  2078, -4105,   290,  2081,  1703,  1705,  1705,  2085,
    2091,  2099,  2102,  2110,  2115, 17251, 17251, 17251, 11987, -4105,
   57464, -4105, 57464,  2185,  3055, -4105,  2691, 17251,   861, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105,  1599,  1717, -4105, -4105,
   -4105, -4105, -4105, -4105,  2127,  1595,  2130, 57464, 57464, 57464,
   57464, 57464, 57464, 45380, 48560,  1730, 57464, 46016, -4105,  1588,
    1721,  4053, 31377,  1993,  1873,  1779,  1703, -4105, -4105,   598,
     720,   735,  2039, -4105, -4105,  1823,   744,  2076, -4105,   762,
     184, -4105,   104,   819,   856, -4105, -4105, -4105, -4105, -4105,
   -4105,  1817,  2142,  1901, -4105, -4105,   146, -4105, -4105, 57464,
   -4105, -4105, -4105, -4105,  2385,  2092, -4105, -4105, -4105,   156,
    2592,   200, 25631, -4105,  2037, 11987,  1355, -4105,  -199, -4105,
   -4105,  2486, -4105, -4105, 46016, 25631, -4105, -4105, -4105, 23065,
   -4105, -4105,  2732, -4105,  2131, -4105, -4105,  1717,  3901, -4105,
    2401,  1993,  2421, -4105,  2601, -4105,  2428,  2331,   943,  2212,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
    2164,  2741, -4105, -4105,    70,  2329,  2172,    90,   178, 40292,
     937, 48560,   245,   103, 28825, 41564,  2174, -4105, -4105, -4105,
     870,  2342, -4105,  2686, -4105, -4105,   679, -4105,  2215,  2038,
     679, 46652,  2594,   179, -4105,   277, -4105,  2678, -4105, -4105,
   -4105, -4105, -4105,  2348,  2336,  2382, -4105,   325,  1626, -4105,
    -163, -4105,    43, -4105, -4105,  2361, -4105,  2594,   679,   179,
   -4105,  2610,  2737,   808,  2710,  -161, -4105, -4105, -4105,   595,
    2819, -4105,  2262, -4105, -4105, -4105, 25631, -4105, -4105, -4105,
    2385, -4105, -4105, -4105, -4105,  2265, -4105, -4105,  2553,  2388,
   -4105, -4105,    45, -4105,  2294,   -24,  2793, -4105, -4105,   316,
    1232,  1567,  1538, -4105,  2318, 42200, -4105, -4105, -4105,  2828,
    2847,  1703,  2309, -4105, -4105, -4105, -4105, -4105,  2978, -4105,
   -4105,  2335,  2873,  2873,  2873,  2988, -4105, -4105, -4105, 25631,
   -4105, -4105, -4105,   772, -4105, -4105,  2510,  2374, -4105,  1603,
   25631,  2751,  2349, -4105, -4105,  2608, 11987, -4105, -4105, -4105,
     322, -4105, -4105,   201, -4105,  2952,  2564, -4105, -4105, -4105,
   -4105,  2835, -4105, -4105,  2978,  -223, -4105,  2898,  2873,  2785,
   -4105,  2786,  2364, -4105, 57464, 57464, 57464, 25631, -4105,  2365,
   -4105,  2360, -4105, 11987, 11987,  1380,  2950,  3011,  3011,  3011,
    2185,  2398, 11987, 11987, 11987, 11987, 11987, 11987, 11987, 11987,
   11987, 11987, 11987, 11987,  1570,  2377, -4105, -4105, -4105,  1557,
   -4105,  2378, 11987, 11987, -4105, 11987, 11987, 26909, -4105,  3393,
   11987,   388,  2892, 11987, 11987, 11987, 11987,  3258, 11987, 11987,
   11987, 26909,  3029,  2389, -4105,  2384,  1604, 11987, 11987,  1614,
   11987, 11987, 11987, 11987, 11987, -4105, -4105, 11987, 11987, 11987,
   11987, 17251, 11987, 11987, 11987, 11987, 11987, 11987,  2392, 11987,
    3011,  3011, 11987, 11987,  1650, -4105, -4105, 11987,  2242,  2242,
   -4105, 11987,  8697, 11987, -4105, -4105,  2397, -4105, -4105, -4105,
   26909,  3011,  3011, 11987, 11987, 11987,  2950,  2950,  2950,   222,
    2399,   490, 11987, 29463,  2395, -4105, -4105, -4105, -4105, 11987,
   11987, 11987, -4105, 17251, -4105, -4105,  2003, -4105, -4105, -4105,
   13303, 17251, 17251,  2404, 17251, 17251, 17251, 17251, 17251,  2787,
   17251, 17251, 17909, 18567, 17251, 17251, 17251, 17251,  1627,  2950,
   48560, 17251, 11987, -4105, -4105, 57464, -4105, -4105, -4105,  2402,
    2684,  1730, -4105,  2411, -4105,   814,  2907, -4105, -4105, -4105,
    2416, 25631, -4105,  2412, -4105,  2788, -4105, -4105,  2791,  2794,
    2795, -4105, -4105, -4105, -4105, -4105,  3023,  2799, -4105,  -163,
    2804, -4105, -4105, -4105, -4105,  2438, -4105, -4105, 19225, 48560,
   -4105,  2442, -4105,  2936, -4105, -4105, -4105, -4105, -4105, -4105,
    2559, -4105, -4105, -4105, -4105,  2453, -4105, 46016,  2453, -4105,
   -4105,  2453, -4105, -4105,  2453, 40928,    62,  3522, -4105, -4105,
   57464, -4105, 58100, -4105, -4105, 23065,  -163, -4105,  2875, 13961,
   -4105, -4105, -4105,  2832,   177,  2461, -4105, 25631, -4105,  2185,
   -4105,    94,    94,  2716,   162, 48560, -4105, -4105,   166,  2463,
    2547,  2465, -4105,  2548, 25631, 25631, -4105, -4105, -4105,  2724,
   -4105,  -163,     9, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105,  2471,  2962,  2932,  2478,
   46016, 40928,    72, -4105, 57464, -4105,  1693, -4105, -4105, -4105,
    2480, -4105, 11987, -4105, -4105, 57464, -4105, -4105, -4105, -4105,
   -4105,  3067, 11987, -4105, 46016,   -78, -4105,   119,    69,   870,
   -4105, -4105, -4105, -4105, -4105, 57464, 51740,  2485,  9355,  2609,
    2893,  -163, 11987, -4105,  2506,  1538, 57464, 57464, 57464, 25631,
   57464, 25631, -4105,  1087,  1087, -4105, 42836, -4105, -4105, -4105,
   -4105,   679, 57464, 57464,   679, 40928, -4105,   179,   -10, 57464,
     679, -4105,  2905,  2612, -4105, -4105, -4105,  2973, -4105, -4105,
    2965,  2511, -4105,  2994, -4105, -4105,  2634,   179, -4105, -4105,
   25631, -4105, -4105,   179, -4105,   179,   179, 11987,   679,   679,
   -4105,  1045, -4105, -4105, -4105,  2661,  -126, -4105, -4105, -4105,
     630,   279,  2765, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105,    57, -4105, -4105, -4105, -4105, -4105, -4105,
     220, -4105, -4105, -4105, -4105, -4105, -4105, -4105,   933, -4105,
   -4105, -4105, -4105, -4105,  1603, 25631, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105,    76, -4105, -4105, -4105,
    2022,  3031, -4105, 48560,  2674,   888,   699,  2674,  1885,  -163,
     176, -4105,   176, -4105, -4105, -4105,  2797,   199, 25631, -4105,
    2519, -4105,  2775, 52376, 25631, -4105, -4105, -4105,  1552,  2523,
    2527,  2185,  4192, -4105, -4105, 25631, -4105, -4105, -4105, -4105,
    2581, -4105, -4105, -4105, -4105,  2451, -4105, -4105, -4105,   158,
    2008,  3178, 45380, -4105,  2555,  2578,   134, 40928, -4105, -4105,
   -4105,  2543, -4105,  2724, -4105,  1249, 57464,  3002, 33925, -4105,
     333,   425, -4105,  3011,  2575, -4105,  2577,  2582,  2583, 11987,
      54,   455,   752,  1295,  1071,   952,   372,  1041,   378, -4105,
    1363,   522,   535,   550,   224, -4105,  2587,  2554, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105,  2589, -4105, -4105, -4105,
     564,   572,  1217,  1261,  2591,  2595, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105,  3003, -4105,  1512, -4105,
   -4105, -4105, -4105,  2561, -4105, -4105,  1279,   627,   658,   226,
    2571,  1550,   857,  1564,  1572,  2569, 26909, 57464,  3011,  2596,
    1302,  1315,  3011,  2597,   876,  1319,  1612,  1615,  1629,  1339,
    1346,   901,  1677,  2562,  1353,   905,   929,  1365,   954,   969,
   -4105,  1377,  2599,  2602,   988,   232,  3011,  2604,   339,  2593,
    2600,  1384, 10013, 10671, 11329,  1234,  1031, -4105,  2613, -4105,
    2384,  2614,  2617,   386,   205,  1394, -4105, 11987, -4105, -4105,
     902,  1266,  2637,   142,    69, -4105,  2779, 57464,  2400,   170,
   -4105, -4105, -4105, -4105, -4105, -4105,  1092, -4105,  2624, -4105,
    2626,  1654,  2630, 11987,  1151,  2630,  2546,  2328,  2328, 17251,
    2502,  3163, 12645,   807, 12645,   807,  2630,  2630,  2630, -4105,
   17251,  2629, 17251, 17251, -4105,  2950,  2185,  2631,   691, 57464,
   25631,   814, -4105, -4105, -4105, -4105,   870, 46016,   143, 25631,
   48560,  2628, -4105, -4105, -4105, -4105, -4105, -4105,  -163, -4105,
   -4105,  3769, 25631,  2721,  2725,  2727, -4105, 32015, -4105, -4105,
   -4105, -4105, 32015,   -33, -4105, 57464, -4105,  2713, -4105, -4105,
   -4105,  1036, 23704, 23704, -4105, 23704, -4105, -4105, -4105, -4105,
   -4105,   184, -4105, -4105, -4105, -4105,   229,   303,  3876,  2663,
   -4105, -4105, -4105, -4105, 33289,  2185, -4105, 25631, -4105,  3053,
     -22, 25631,  2641, -4105,  2655, -4105, -4105, -4105, -4105, -4105,
    2680,  2770, -4105,  3305, -4105, 11987,  -163, -4105, 46016, 46016,
   25631, 25631,   753, -4105,  2303,  2666, -4105, -4105,  3308, -4105,
    3901, 19225, 45380,  3111,  3125, -4105,  2669, 23704, 23704, 23704,
   -4105, -4105, -4105, -4105, -4105,  1361,  2185, -4105,  2667, -4105,
   47288, -4105,  2185,   870,  2677,  2679, -4105, -4105,  3054,   879,
   -4105,  2689,  2695, -4105,  2685,  2692,  2693, 53012, 11987, -4105,
     119, -4105, -4105,   870, -4105, -4105, -4105, 17251,  1760, -4105,
    2185, -4105, -4105,  -163,  3154, -4105,  2185,  2701, 57464, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105,  3182, -4105,  2887,   -97, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105,   679, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105,  2938,  2594,  1626,  2893, -4105,   679,   179, 25631,   679,
     679,  2185, -4105, -4105, -4105, -4105, -4105,  2707, -4105,  2766,
   -4105, -4105, -4105, -4105, 57464,  2143,  2877, -4105,  2720, -4105,
   -4105, 25631, -4105,  2722, -4105,  3189,  3342,  2594, -4105, -4105,
    3192, 57464, 57464,  1538, 57464, 57464, -4105, -4105, -4105,   870,
     870,  3043, -4105,  -163,  2876,  2879,  2881,  2884,  2888,  2914,
   -4105, -4105,  -163,  -163, -4105, -4105,   870, -4105,  2190, -4105,
   -4105, -4105, -4105,  -163,  -163,  -163,  -163,  2924,  -163,  -163,
    1766, -4105, -4105,   870,   870, -4105,   574, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105,   971, -4105,  4145,   171, -4105,  2953,
   -4105, -4105, -4105, 25631,  3203, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105,  2762, -4105, -4105, 11987,  3255,
    3263,  3264,  3267,  3268,  3270,  3272,  3273,  3274,  3275,  3278,
    3283,  3284,  3285,  3286,  3292,  3293,  3294,  3296,  3297,  3298,
    2768, -4105, -4105, -4105, -4105, -4105, -4105,   159,   870,   870,
     870,   870, -4105,  2369, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, 40928, -4105, 48560,  3155,  2557,   -86, -4105, -4105,
   48560, -4105,  1268,  3089,  3091,  3092, 57464,  2862, -4105, 33925,
   -4105, -4105,   630, -4105,  2813, 14619, -4105,  2821, -4105, 11987,
   -4105, -4105, -4105,  1333, 11987, 11987,  3319,  2070, -4105, 47924,
   -4105, -4105, -4105, 11987, -4105, 11987, -4105, 11987, 11987, 11987,
   11987, 47924,  2070, 11987, -4105,  2825, -4105,  3233,  3234, -4105,
   -4105, -4105, -4105, 11987, -4105, 11987, 11987, -4105, 11987, 11987,
   11987, 11987, -4105, 11987, -4105, -4105, 17251, -4105,  2827,  2833,
   -4105, -4105, -4105,  2836, -4105, 11987, -4105, -4105, -4105, -4105,
   -4105, -4105, 11987, -4105, 11987, -4105, 11987, 11987, -4105, 11987,
   11987, -4105, -4105, -4105, 15277, 11987, 11987,  2840, -4105, -4105,
   11987, 11987, 11987, -4105, 11987,  1289, 11987,  1853, 11987,  1966,
   11987, -4105, 11987, -4105, -4105, -4105, -4105, 11987,   364,  2680,
    2924,  2841, -4105,  1772, -4105, -4105,  2568, -4105,   902,  2842,
   -4105, -4105,  1693, -4105, -4105, 48560, 11987, -4105, -4105, -4105,
   -4105, -4105, -4105, 17251,   395,  2844, 17251, -4105,  2546,  3258,
    3258,  2203, 11987,  1151,  2546, 11987,  2846,  2848, -4105, 11987,
   57464, -4105, -4105, -4105, -4105, 48560, -4105, -4105, -4105, -4105,
     143, -4105,  2412, -4105, -4105,  2641,   295,  3337,  2852, -4105,
   -4105, -4105, -4105, -4105, -4105,  1774, -4105, 40928,  3503, -4105,
    2850, -4105,  2851,  2940,  2946,  2947, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,  2594,  2303,
   -4105, -4105,  2868, -4105, -4105,  2608,  2959,  2891,  3247,  3442,
   -4105, -4105, 57464, 17251, -4105,  3484,  2886,  2889,  3372,  2890,
    2185, -4105,  2967, -4105, -4105, -4105, -4105,  3198, -4105, -4105,
   -4105, -4105,   745, -4105, -4105,  2894,  2894, 21144, -4105, -4105,
   -4105, 57464, -4105, -4105,  3383, -4105, -4105,  3171, 46016, 40928,
    3357,  3358,  3359,  1056, -4105,   398, -4105,   843,  3310,  2594,
   -4105,  3362, 49196, -4105, 34561, -4105, -4105, -4105, -4105,   -78,
    2998,  2999,  1492, -4105, -4105,  3315,  3135, -4105, -4105, -4105,
     870,  2185, -4105,  2485,  9355,  2917, 30101, -4105,  1466, -4105,
     272, -4105, 43472,  3398, 43472, 43472, -4105,  3206, -4105, -4105,
    3154, -4105,  2663,   179, -4105, -4105,  1045,  2928, -4105, -4105,
    1152,  3318,  3320, -4105,  3191,  2393,  3191, -4105, -4105,  1152,
   26909,   630,  2724, -4105,  2924,  3250, -4105, -4105, -4105, 57464,
   -4105,  1852, 57464,  2933,  -166,  5260, 47288, 44108, -4105, -4105,
   -4105, -4105,  3478, -4105,  3483,   203, -4105, -4105,  1833,   699,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105,  1885,  1833,  1833,   176, -4105,
     131, -4105, -4105, -4105, -4105,  2244,   870,  3530,  3202,   870,
     870,  3530,   870,  3213,  3214,   870,   870,  3042,  3482,   870,
    3364,  3075,  1134,  3370,   870,  3232, -4105,  3079,  3493,   870,
     870,   870,   870,   870,  3530,  3236,  3587,   870,   870, -4105,
     870,  3241,  3242,   169,  3261,  3262,   870,   870,   870,   870,
     168, 57464,   870,   870,  3269,   870, -4105, -4105,  5300, -4105,
   -4105, -4105, -4105, -4105, -4105,   846, 24349, -4105, -4105, -4105,
   -4105,   870,    14,   300,  3080,  1438,  3005, -4105,   379,  3014,
   53648,  2185,  3021,  2924,  -163,  -163,  1466,  -163,  2924,  -163,
    -163,  -163,  -163,  -163,  -163,  -163,  2924,  2924,  -163,   820,
    1956,  -163,  2924,  4192,  -163,  2680,  1833,  1833,  2008, -4105,
   -4105,  3299,  3443,   870, -4105,  2444, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105,  3112, -4105,   165,   889,   889,
   -4105, 25631, 25631, 25631, -4105,  3019,   630,  2663,  1587,  2663,
    3034, -4105, 12645,  1396, -4105,  2185, 11987,  2185,  1989, -4105,
    3036,  3036,  3036, -4105,  3040, -4105, -4105,  3036,  3434,  3036,
    3437,  3045,  3047,  1782,  1716, -4105,  1795,  2093,  1406,  3048,
    3050,  1599, -4105, 11987, 11987,  1408,  1427,  -106,  1075,  1100,
     406, -4105,  1463,  3355, -4105, -4105,  1490,  1507,  1583,  1601,
    1106,  1624,  1857, 12645,  1637,   874,   516, -4105,  1676,  1115,
    1204,  1726, 11987,  1750, 11987,  1757, 11987,  1769,  1808,  1847,
    3062,  3062,   155, -4105,  3041, -4105, -4105, -4105,  3051, -4105,
   -4105,  2164,  2568, -4105, -4105,  3057, -4105, -4105,  3061,  2185,
    3065, -4105, -4105, 11987, -4105,   861, -4105, -4105, 17251,   524,
    3069, -4105,  2185, -4105, -4105,  3076,  1599, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105,  3300, -4105, -4105,  3556, 32015, -4105,
   57464,  1176,  3351,  3087, 35197, 40928, 40928, 40928,  3084, 11987,
   -4105, -4105,  3363, 25631, -4105,  3504, -4105, -4105, -4105, -4105,
   -4105,  3090,  3093, -4105, -4105, -4105,  2546,  3472,  3352, -4105,
   -4105,  2680, 57464, 46016, -4105, -4105,  2741, 26909, -4105,  3096,
   -4105,  3096,  -167,  3099,  1860, -4105, -4105, -4105,  3094,  2212,
    1862, -4105, 19225,  3558,  2416, -4105, 40928, 40928, 40928, -4105,
    2663,  2663,   141,  3153,  3505, -4105, -4105, -4105, -4105, 54284,
   -4105, -4105, -4105, -4105,  1155, -4105,  3104,  3105,   125,  3333,
   -4105, -4105, -4105, -4105,  9355, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105,  2594, -4105, -4105,
   -4105, -4105, 43472, -4105, -4105, -4105, -4105, -4105,   679, -4105,
    3598, -4105,  3115,   959,  1266, -4105,   657, -4105, -4105, -4105,
    3507,  3191,  3191,  1152,  3514,  1144,  3120, -4105,   870, -4105,
    3058, -4105,  2741, -4105, -4105, 11987,  3311,  3126, -4105, -4105,
      96, -4105, -4105,   869, 25631, 19866, -4105, -4105,  3378, -4105,
    5033, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
     971, -4105, -4105, 27548,  1538, -4105,   210, -4105,  1538, -4105,
    1552,  1552,  1538, 54920, 27548,    84,  1466,  2924,  1588,  2924,
   55556,    84,  -163,  -163,  2493,   870,  2924, -4105, -4105,  3518,
    1588,  3520,  1588,  1588, -4105, 48560, 57464, -4105,   870,  1347,
    2924, 56192,  1466,  1466,  1588,    84, 26909,  3183,  3436, -4105,
    -163,    84, -4105, -4105, -4105, -4105, 25631,    84,    84,  1903,
    3456,  3457,  3542, -4105, -4105, -4105,  2924,  3436, 55556, -4105,
   -4105,  6905, -4105, -4105, -4105, 20505, 57464,   292,   493, -4105,
    3122, 38384,  3374, -4105, 11987, 11987,  3413, 57464,  3415, -4105,
    3710, 57464,  3774, -4105,   150, -4105, 55556, -4105,  3140, -4105,
    3144, -4105,  2924, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105,  3147, 57464,  1833,  2557, -4105, -4105, -4105, -4105,  -163,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, 33925,  2663,
    3417, -4105, -4105,  3258, -4105,  2185, 11987,  1393, -4105, -4105,
     235, -4105,  1398, -4105, -4105, -4105,  3164, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105,  2826, -4105, -4105,  2070, -4105, -4105,
   -4105,  3165,  3258,  3258, -4105, -4105,  3772,  3335, 11987, 11987,
   -4105, 11987, -4105,   238,  3169,  3199, -4105, -4105, -4105, -4105,
   11987, -4105, -4105,  3258, -4105, 11987, -4105, -4105, 11987, -4105,
   11987, 11987, -4105,  1865, -4105,  1905, -4105,  1921, -4105, -4105,
   -4105,  2680,  3174,  3557, -4105, -4105, -4105,  2680,  3366, -4105,
   -4105,  2680,  2924,  2480, -4105, -4105,   490, 57464, -4105, -4105,
    1922, -4105, -4105, 11987, -4105, 49196, -4105, -4105,  3651,  3549,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105,  3625, -4105, -4105, -4105,
   -4105,  -147,  -147,  -147, 15935,  2185,  3687, -4105, -4105, -4105,
    3504,  3573, -4105,    64, -4105, 57464,  3190,  1366, -4105,  1932,
   -4105, -4105,  3194, -4105,  2164,  3188, -4105,   870, 15935,  2894,
    3360, -4105, -4105,  -167, 26909, 34561, -4105, -4105, 57464, -4105,
   40928,  2669,  2669,  2669,  2594,  3637,  2959,  2959, -4105, 30739,
   -4105, -4105,  3361, -4105, -4105, 35833, -4105, -4105, -4105, -4105,
   -4105, -4105, 30101, 53012, -4105, -4105,  2594, -4105,  -163,  1916,
    1693,  3332, -4105,   630, -4105,  1152,  3594,  3595, -4105,  1152,
   -4105, -4105, 26909,  2663, 15935, -4105,  2164,  2185,  3200,   324,
     869, -4105, -4105, -4105, -4105,  3481,  3485, 57464, -4105, -4105,
   -4105, -4105,  3348, -4105, 25631,  3210,  3211,  3205, -4105, -4105,
   -4105,    67, -4105,  6794, -4105, -4105, -4105, -4105,    84,  3217,
    3604,  3605,  1552, -4105,  1538, 27548, -4105, -4105,  1538,  1538,
   -4105, -4105, -4105,   759, 55556, -4105, -4105, 27548, -4105, -4105,
   -4105,  3218, -4105, -4105,  2680, -4105, -4105, 44108,  -163, -4105,
    1588, 57464, -4105, 27548, 27548, -4105,  3244,  -163, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, 27548, 55556,  3222,
   -4105,   324, -4105, -4105, -4105, -4105, -4105,  1909, -4105, 55556,
   -4105, -4105, 55556, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
    3225,  2703,  1401, -4105,  3226, -4105, 57464, -4105, -4105, 25631,
   -4105, -4105, -4105,  6054, 57464, -4105, -4105, -4105, -4105, -4105,
    2185,  3258,  3798, -4105, -4105,  3382,  -163,  3738, -4105,  1937,
   -4105, -4105, -4105,  3652,  3238, -4105, 53648,  1939, -4105, -4105,
    1885, -4105, -4105, -4105, -4105,  3237,  3240,  3248,  2813, -4105,
    3612,  1239,  2185,  3246,  3249,  3256,  3257,  3859,   172, -4105,
    3860, 47924, -4105, -4105, -4105,  1942,  3532, -4105, -4105, -4105,
    3036, -4105,  3040, -4105, -4105, -4105,  3843, -4105, -4105,  3036,
    3658,   235, -4105, -4105,  3259, -4105,  3271,  3279, -4105,   279,
    3280,  1929,  1287,  1954,  3576,  3653, -4105,  3490, -4105,  1950,
    1305,  1959,  2024,  2079,  2120, -4105, -4105, -4105, -4105, -4105,
    3281, -4105, -4105,   399, -4105,  3287,   932,  1266, -4105, -4105,
    1991, -4105, -4105,  3906,  3535,   965,  3309,  3309,  3309,  1760,
    2185,  1995, -4105, -4105, -4105, -4105, -4105, -4105,  3675, -4105,
   -4105,  3277,  3305, 57464, -4105,  3352, -4105,  2480, 26909, 15935,
    3289,  3295, -4105,   -24, -4105, -4105,  3265, -4105, -4105,  2669,
   -4105,  3881,  3720, -4105, -4105, 48560,  3303, -4105, -4105,  3608,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,  2720,  2119,
    3336,  1152,  1152,  3367,  3343, 11987,  3301, -4105,  3417, -4105,
   -4105,    32,  2480, 11987, -4105, -4105, -4105,  3441,   950, -4105,
    3473,  3314,  3316, -4105, -4105,  -163,  3321, -4105, -4105, 20505,
   -4105,  3936, -4105, -4105, 11987,  1538, -4105, -4105, -4105, -4105,
    3312, -4105, -4105,  3832,  3833, -4105, -4105,  2451, 57464, -4105,
    3067, -4105, 27548,  3218, -4105,   193,  3416, -4105, -4105, -4105,
   26909, -4105, -4105, -4105, 57464, -4105, 25631, -4105, -4105,  3317,
   -4105,  3036,  3036,  3036, -4105, -4105,  3036, -4105,  3040,  3567,
   -4105,  3040,  3040, -4105, -4105, -4105, -4105, -4105,   235,   366,
   -4105, -4105,   235, -4105, -4105, -4105,   129,  1079,  3040, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105,  3036,  3036,  3036, -4105,
   -4105,   235,  3036, -4105,  3036, -4105,  3276, -4105,   215,   132,
    3036,  3036,  3036,  3164,  3322, -4105, -4105, -4105, -4105, -4105,
   -4105, 57464, -4105,  1166, 57464,   151, -4105, -4105, -4105,  2924,
    1999, 57464, 57464, 57464, 44744, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, 47924, -4105,  3945,  3614,  3334, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, 11987, -4105,
   -4105, -4105, 11987, -4105, -4105,  3649,  3813, -4105, -4105, -4105,
   -4105, -4105, -4105,  3356, -4105,  2924,   843,   843, -4105, -4105,
   -4105,  3855, -4105, -4105,  3446,  3449, -4105, -4105,  3451, -4105,
   -4105,   120,  2075, -4105, -4105, -4105, -4105, 15935,  3753,  3459,
   -4105, -4105,  3371,  3411, -4105, -4105,   932, -4105, -4105, -4105,
   -4105, 11987, -4105,  3417,  2493, -4105, 30739, -4105,   490, -4105,
    3418, -4105, -4105, -4105,  3419,  2185, 57464,  3612, -4105,   268,
     932,   324,  -163, -4105, -4105, -4105,  3376,  3373, -4105, -4105,
   -4105,   300, -4105, 57464,  6054, -4105, -4105,   -24,  5300, -4105,
   -4105,  1196,   919,  2146,  3379,  3386, 57464,  3387,  3391, -4105,
    3235, 27548, -4105, -4105, -4105, -4105, -4105, 25631,  6054,    84,
   -4105, -4105,  3218,   745,  3394, 57464,  3709, -4105, -4105, -4105,
   -4105,  1298, -4105,  3396,  1298,  1298, -4105,  2329, -4105,  3429,
     235, -4105, -4105,  3432, -4105, -4105, -4105,  1298,  3399,   235,
   -4105, -4105, -4105, -4105,  1298, -4105, 48560,  -163,  2806,  4017,
   -4105,  3435, -4105,  3920,  3792,  4036, -4105,  2870, -4105,  3796,
    3691,   870, -4105,   235, -4105, -4105,  3945, -4105,   235,  3945,
    1298,  1298, 57464,  3533, -4105, 63824, -4105, -4105,  -133,  3433,
    2007, -4105, -4105, -4105, -4105, -4105, -4105,  2011,   324,  3421,
    2020,  2033,  3889,  3592,  3607, -4105, -4105,  3422,  3420,   324,
    2155, -4105, -4105, -4105,  3423, -4105, -4105,  4010, -4105, -4105,
   -4105, -4105,   259,  3696,  2924,  2924,  2924,   830,  2075, -4105,
   -4105,  3486, 25631, 17251,  3540, 57464,   764,  2867, -4105,  1494,
     324, 11987,  2594, 44108, -4105, -4105, -4105, 11987,  3438, 11987,
    3439,  2047, -4105, -4105, -4105,  1552,  1552, -4105,   268, -4105,
   -4105, -4105, -4105,  1545, 57464, 25631,  3413,  3624, -4105,  3067,
   -4105, -4105,  3378,  3360, -4105,  2680,  3352, -4105, -4105, 57464,
   57464,  2061, 57464, 57464,  2721,  2725,  2727,  1956,  1956, -4105,
   -4105,   292, -4105, -4105, -4105,  3844, -4105, -4105,  2111, -4105,
     845,  3718, -4105, -4105, -4105, -4105,  1298, -4105,   279, -4105,
   -4105, -4105, -4105, -4105,   279, -4105, -4105, -4105, -4105,  3445,
   -4105, -4105, -4105,  3730,  3487, -4105, -4105, -4105, -4105, -4105,
   39020, -4105, -4105, -4105, -4105, -4105, -4105, -4105, 11987,  3939,
    3475, 57464,   116, -4105, 65096, 65096, 57464, -4105, -4105, -4105,
   -4105,  6301, -4105, -4105,   875, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105,  4071, -4105,  3444, -4105,
   -4105,  3450,  1493, -4105, -4105, 57464, 56828,  1892, 57464, -4105,
    3735,   186,  2154, -4105,  3933,  2164, -4105, -4105, 11987, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,  1199,
   -4105, -4105, 26909,  2724, -4105,  2680, -4105,  2121, -4105, -4105,
   -4105,  3544,   870,   870,  3969,  3972,   870,   870,   870,   870,
    3461,  2867, -4105,  3954, -4105, -4105, 11987, -4105, -4105,  2185,
    3700, -4105,  4045,  1266,  2185, 57464,  2185, 57464, -4105,  3924,
    3924, -4105, -4105, -4105,  6054,  3926,  1438, -4105, -4105, -4105,
      67,  3470,  2212, -4105,  2123,  2147,  2161, -4105,  2171,  2177,
   -4105, -4105, -4105, -4105,   292,  3474, -4105, 57464, -4105, -4105,
   -4105,    81, -4105, -4105,  2184, -4105,  2204,  2551, -4105,  3445,
   -4105,  3476, -4105, -4105, -4105, -4105,  2185, 11987, -4105, 11987,
    3499, -4105, -4105,  3932, 57464, -4105, -4105, -4105, -4105, 11987,
   -4105, 63824, 63824, -4105, -4105, -4105, -4105,  4099,   -24,  4070,
    3752,  4072, -4105, -4105,  2210, -4105, -4105,  -163,   870, -4105,
    1892, -4105, -4105, -4105,   870,   324,  3488,  3741, -4105,   186,
   -4105, -4105, -4105,  2154, -4105, -4105, -4105,  2480,   324, -4105,
   -4105,  3491, -4105,   870, -4105,  3494, -4105, -4105, 57464,  3492,
   -4105,  -163,  -163,   870,   870,  3551,  3551,  2680, 48560,  3602,
   -4105, -4105,   870,   324, 57464, -4105,  1277,  3861, -4105,  2218,
    2230,  1146, -4105, -4105,  3582, -4105, -4105,  3710,  6054, -4105,
   -4105, -4105, -4105,  3712, -4105,  1892, -4105, -4105, -4105,  3352,
   -4105,   872,   872,   235,   279,   235, -4105,  3498, -4105, -4105,
    2185,  2185, -4105,   243, -4105, -4105,  3904,  3995, 11987,  2185,
   60644,  3496, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, 64460, 11987, -4105,   875,  4071,
   -4105,  3776, -4105,  3778, -4105, 56828, -4105,  2924,  1103, -4105,
   39656, -4105, -4105,  1571,  1103, -4105,  1103, -4105, -4105, 26909,
   15935,  2493, -4105,  3540, -4105,  3509, -4105, -4105,   777, -4105,
   -4105,  -163,  -163, -4105, -4105, -4105, -4105, -4105,  2247, -4105,
   48560, -4105, -4105,  4109,  4115,  4008,  4116,  1277, -4105,  -114,
   -4105, -4105, -4105,  4119, -4105,  4120,  3516,  3519, -4105, -4105,
   -4105,  4035, 63824, -4105,  4027, -4105,   -24, -4105,  1892, -4105,
     186,  2154,  2254, -4105,  4172, -4105,   154,  3801,  3804, -4105,
   -4105, -4105, -4105,  3528,  3560, 11987, 63824, -4105,  4024, -4105,
    3951,  2058,  3893,  3529, -4105,  3527,  1404,  4060, 65096, 65096,
   -4105, -4105, -4105, -4105, -4105,  3907,  4182, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,  2259,
   -4105, 16593, -4105, -4105, -4105, -4105, -4105, 48560, -4105,  3602,
   -4105,  3541,   279,   279,  4148,   279, -4105,  4149,  4150,  -114,
   -4105, -4105, -4105, 53648, 53648, -4105, -4105,  4046, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,  3601,  4064,
    -121, -4105,   251, -4105,  2185, 61280,  4152, 57464, -4105, -4105,
   -4105, -4105, 11987, -4105, 49832, 61916,  3545, -4105, -4105, -4105,
   -4105, -4105,  3733, -4105,  3509, -4105,  3559, -4105,  2546,  2867,
   -4105, -4105,  3564, -4105, -4105,   279, -4105,   279,   279, -4105,
    3565,  2268,  3736, -4105,  3582,   872,   872, -4105, -4105,   124,
   11987, -4105,  4052,  3647, -4105,  3566, -4105, 63824,  2181, 63824,
   -4105, -4105,  4007,  3568,  1724, -4105,  3570, -4105,  3993,  4045,
   -4105, 16593,  3571, -4105, 11987,  3577,  3575, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, 63824, -4105, -4105,  -163,  3971, -4105,
     124, -4105,  2185,  4180, 63824, 57464, 58736,  3784, 62552,  4043,
   57464,  6054,  4047,  4048, -4105,  4193,  3861, -4105, -4105,  2185,
   -4105, -4105, 63824, -4105, -4105, -4105, -4105,  3676, -4105, 59372,
   -4105,  2773, -4105,  3617, -4105, -4105,  4117,  2874, -4105,   279,
    4013, -4105, -4105, -4105, 63824, 63824, -4105, -4105, -4105, 37748,
   11987, -4105, -4105, -4105, -4105, -4105,  1056, -4105,  3879,  3599,
   60008, 63188, -4105, -4105, -4105, 32653, -4105, -4105, -4105,  4054,
   -4105,  2185, -4105,    51, 21783,  3760, 37748, -4105, -4105, -4105,
   -4105, -4105, -4105, 48560,  2281, -4105, -4105, 26909, -4105, -4105,
   -4105, -4105, 24990,  3600, -4105,   870, -4105, 26909, -4105, -4105,
   15935, -4105, -4105
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4105, -4105, -4105, -4105, -4105,    97, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105,  1893, -4105, -4105, -4105, -4105, -4105,
    1586, -4105,   471, -2377,  -501,  3282, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105,   751,  1697,  3224,
   -4105,   365, -4105,    11, -4105, -4105, -4105, -2982,  -119,  -319,
   -4105, -4105,   718,    27,  3212,  -314, -4096, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105,   371,   376, -4105, -4105,
     209, -4105, -4105, -2849, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105,  -485,  -444,  1859, -4105, -4105, -4105,  4236, -4105,
    3684, -4105, -1813,  2356, -4105, -4105, -4105, -4105, -4105,  2425,
   -1747, -4105, -4105, -4105,  1462, -4105, -4105, -4105,  -638,   296,
   -4105,   299, -4105,   301, -4105,   302, -4105,   304,   305,   306,
     307, -4105,   310, -4105, -4105,  -430, -4105, -4105, -4105, -4105,
     313, -4105, -4105, -4105, -4105, -4105, -4105, -4105,  -292, -4105,
   -4105,  -102, -4105, -4105,  -290,   318, -4105,  -225,   320, -4105,
     321, -4105,  -122, -4105,  -120, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105,  3215, -4105, -4105,
   -4105, -2335, -4105, -4105, -2264,  2739, -4105, -1811, -4105, -4105,
   -1972, -4105, -4105, -1869,  1058, -4105, -4105,   976,  -308, -4105,
   -1396, -1986, -1968, -4105, -4105, -4105, -2052, -2038,  -788,  2491,
   -1182, -2336, -4105, -4105, -4105, -4105,    63, -4105, -4105,   242,
    1690,  2213, -4105, -2531, -4105, -4105,   883, -4105, -4105,  1478,
     724,  1476, -4105,  1052,  2970, -1260, -4105, -4105, -4105, -4105,
   -4105, -4105,   -19,   311,  -118, -4105, -3813,   728, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4104, -4105, -4105, -4105,
    -327, -4105, -4105,  -222, -4105, -4105,  -283, -4105,   117, -2380,
   -4105, -4105, -4105, -4105,  2730, -1374, -4105,  3717, -4105,  -504,
   -4105,   445,  1727, -2443, -2003, -4105,  -950,  -942, -2946, -4105,
   -4105, -4105, -1988,   997,  1283, -4105,   680,  1725, -2451, -4105,
   -4105, -4105, -4105, -4105,  1282, -4105, -4105,   442, -4105,   436,
   -4105, -4105, -4105, -4105, -4105,  -325, -4105,   -42, -3174, -4105,
   -4105, -4105, -2993,  1195,   631, -4105, -4105, -4105, -1502, -2995,
    -833, -4105,   255, -2585, -2516,   600, -4105, -4105,   397, -3814,
   -4105,  -569, -2159, -2487,   -89, -4105, -4105,   413, -3175,  1845,
   -4105, -4105, -4105, -3384, -2784,  1605, -4105, -4105,  1159, -4105,
   -1651,  1149, -4105, -4105, -4105,  1162, -4105,    -5, -4105, -4105,
   -4105, -4105, -2928, -4105, -4105, -1562, -2766, -4105, -4105,  4378,
    4379, -1584, -3092, -3380,  -116,  -115, -4105, -4105, -4105,  2199,
   -1204,    65,    55,    58,  1700, -1527,   213,  1005, -1687, -4105,
     278, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,  1768, -1769,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -3159, -2909, -4105,
   -4105,  1334, -4105, -4105, -4105, -2452, -2087, -2081, -2434,  3384,
   -4105, -4105, -4105, -4105,  3338, -2268, -3790, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105,  2896,  1084, -4105, -4105,  1900, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105,   475,  1981, -4105, -4105,
   -4105, -4105,  2286, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105,   -30, -4105, -4105, -4105,   719,  2802, -4105, -4105, -4105,
      -9, -4105, -4105, -4105, -4105,  2498, -4105, -4105, -4105, -4105,
    2829, -4105, -4105, -4105, -4105, -4105, -4105,  1576, -4105,  2016,
   -4105, -1570, -4105, -4105,  1140, -1040,  1971,  -611,  2104,   428,
   -4105,  3805, -4105, -4105, -4105, -1750, -2528, -4105,  3489,  -896,
   -2696,  2482,  -570, -1927,  1184,   145,  1577,  1150,  4006, -4105,
   -1184, -1181, -4105, -4105,  -669, -4105, -4105, -4105, -4105, -4105,
    2205,  2214,  -623, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105,  1621, -4105, -4105, -4105, -4105, -1245,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105,  1691, -4105, -2117,
   -4105, -4105,  -481, -4105,  3288, -4105, -4105, -4105, -2357, -1998,
    1915,  1095, -4105, -4105, -4105, -4105, -4105, -4105, -4105,  1925,
   -4105, -1610, -4105, -2802, -4105, -4105, -4105, -4105, -4105,  2124,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -1671, -4105, -2036,
     192, -4105,   377, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
    -137,   941,  -134, -2861, -1103,  1738, -4105, -4105, -1326,  3307,
   -2376, -4105, -4105, -4105,  2109, -4105, -4105, -4105, -4105, -4105,
     748, -3008,  2927, -4105, -4105, -3259,  -956, -2350,  -932, -4105,
   -1411,  1530,   576, -4105, -1962, -1131, -1468, -2985, -2417, -4105,
    1400, -4105, -4105, -4105, -4105,  -241, -4105, -4105, -4105,   596,
    2017, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105,  -528,  -905, -4105, -4105,  2277,  -493, -4105,  3440, -4105,
   -4105,  3465, -4105, -4105, -4105, -4105,  3121,  3097,  2080, -4105,
   -4105, -2644, -4105, -4105,  2042, -4105,   863,  -944,   105,  1186,
   -4105, -4105,  1188, -3260, -4105, -4105,  3466, -4105, -4105, -4105,
    1137, -4105,    46,  3899,  3468, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105,  2878, -1082,  3827, -4105, -4105, -4105, -4105,
   -4105, -4105,  2494, -4105, -4105, -4105, -4105, -4105, -4105,  3052,
    3918,  -599, -1361, -4105,  -783,  2495,  2021,  -837, -4105, -4105,
   -4105, -4105,  3922, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105,  2672,   804, -4105, -4105, -4105, -4105,  3132,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105,  1242,  -143, -4105,    41,  -177, -4105,   -49, -4105, -4105,
   -4105, -4105, -4105,  -251, -4105, -4105,  -254, -4105, -1038,  3750,
   -1422,   567, -1296, -2580, -4105,  1236,  3114, -3383,  -672, -1211,
   -1218, -2700,    91, -4105, -4105,  3659,    87,  -480,  -365,    -6,
   -2879,  -103,  -574,  -628,  -749, -4105, -2077, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105,  2055, -4105, -4105, -4105,  1210,
   -4105,  3944, -4105,  2760,  1212,  3948, -1403,  2580,  2072,  2077,
   -4105, -4105,  2082, -2236, -4105, -4105,   157,  3968, -4105,  2654,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105,  3723,  -464,  -461,
    3150,  3970,  3643, -4105,  3219, -4105, -4105, -4105, -4105, -4105,
     536, -4105,   -96,  2117, -1258, -2317, -4105, -4105,  2942,   979,
   -4105,  1737,  -310,  -616, -4105, -4105,   532, -4105, -4105,   330,
    3977,  3644, -4105, -4105, -4105, -4105, -4105, -2828,  -914, -4105,
   -3498, -2844, -1749, -4105, -4105, -2214, -3080, -4105, -4105, -1061,
   -4105, -4105, -4105, -4105, -2053, -4105, -4105, -4105,   -14,  3943,
    3946,  3949, -4105,  -825, -4105, -4105, -4105, -4105, -4105, -4105,
   -4105,  3534, -4105, -4105, -4105, -4105,  3543, -4105, -4105, -4105,
   -4105, -4105,  3546, -4105, -4105, -4105, -4105, -4105,  1540, -4105,
   -4105, -4105, -4105, -4105, -4105, -4105, -4105, -4105
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2766
static const yytype_int16 yytable[] =
{
     516,  1002,  1769,  1101,  1556,  1432,  1435,  1563,   895,  1768,
    1743,   559,  1034,   558,  1054,  1418,  1448,   566,  1676,  2462,
    2463,   577,  1859,  2198,   673,   649,  2132,   580,   585,  2638,
     955,   998,  2321,   514,   592,  2639,  2135,   595,  1900,  1639,
    1468,  1498,   592,  1973,  2006,  2194,  2195,  1285,  2840,   613,
    2982,  3306,   828,   829,   830,  2005,   832,  2873,   834,  1791,
    2732,   836,   816,   838,  1720,  1468,  1799,  1174,  1053,  1126,
    1801,  1802,  2739,  1858,  1805,  1806,  1807,  1808,  3049,  1810,
    1811,  1813,  1815,  1816,  1817,  1818,  1819,  1871,  1289,  3425,
    3122,   140,  2821,   638,  3659,  3233,  3486,  1685,   870,  1568,
    3342,   871,  1008,  1835,  3493,  1015,  1109,  1569,  2797,  2897,
    2367,  1519,  1909,  2628,   564,  2740,  2013,   641,  2445,   516,
     659,   516,   648,   654,  3005,  3870,  2937,  3426,  2573,   870,
    2941,  2993,   925,  1462,  2691,  2561,  2026,  1268,  4031,  3165,
    1090,  1093,  3520,  3014,  2029,  2030,  2574,  3018,  2692,  2993,
    2993,  3348,   643,  2946,   645,  1380,  3587,  2103,  3033,  1235,
    1236,  1499,  2955,  3501,  4002,   522,  1348,  3814,  3985,  1904,
    3044,  3537,  1226,  1227,  1228,  1592,  3224,  1114,  1115,  1116,
    2090,  3551,  3711,  2187,  1269,  3137,   576,  1235,  1236,  3053,
     637,  3953,  2068,   584,  3802,  2458,  2357,  1348,  1915,   670,
    2688,  2679,  2103,   605,  2709,  3160,  3161,  4687,  1565,  3328,
    2214,  3167,   870,  3169,  1542,  1550,  1500,  4401,  2689,  2550,
    1342,   602,  1235,  1236,  2175,  2308,   572, -1560,  3301,  -476,
    2997,  2998,  3362,   964,   945,  3001, -2114,  3527,  -934,  1235,
    1236,  1235,  1236,  1235,  1236,  3399,  2357,  1357,  2916,  1235,
    1236,  3528,  1339, -2717,  1589,   877, -2265,  3527,  2642,  2993,
    2993,  1607,  3703,  2793,  1872,  3529,  1451, -1560,  1494,  4327,
    1094,  3528,  2407,  4264,  1937,  3389,   964,   945,  2494,  1964,
    3891,  3186, -2647,  3564,  4647,  3529,  4596,  1046,  4499,  1361,
    1565,  1565,  3225,  3316,   660,  2569,   964,   945,  1954,  3606,
    2973,  3476,  3606,  3387,  3690,  1526,  1009,   907, -1600,  3766,
    3595,  4272,  1349,  3063,  3403,  4302,   881,  1021,  2695,  2433,
    -572,  -573,   911,   684,  3084,  3844,  1955,  1536,  1021,   122,
    4769,  3150,  2120,  3152,  1466,  3054,  2985,  1273,  3294,  2371,
    3128,  3129,  3363,  1349, -2291,  3664,  1292,   573,  2788,  1473,
    1235,  1236,  1965,   622,  3946,  3951,  1235,  1236,  3952,  3868,
   -2483,  4560,   569, -2717,  4564,   139,  1104,   135,  1154,   870,
    1206,   520,   594,  2086,  1508,   521,  1958,  3962,  1469,  3082,
    1912,  2523,   685,  1608,  3984,  1099,  1100,  1609,  3527,  1235,
    1236, -2565,  3093,  2063,  2092,  1235,  1236,  1479,  1610,  4526,
    2780,   139,  3528,  1235,  1236,   882,  3390,  4526,  1621,  4081,
    2408, -2411,  1235,  1236,   141,  4577,  3529,   273,  2086,   275,
    3224,  3135,  2064,  1235,  1236,  1913,  2781,   964,  3947,  3083,
     677,  2285,  1470,  1622,  3356,  4019,   912,  1393,  2181,   523,
    4385,  2928,  1235,  1236,  2056,  2372,  2435,  2436,  4328,  4578,
     124,  2121,  2104,   136,  3094,  2986,  1509,  2891,  1155,   868,
    1207,  3665,  1375,  4063,   880, -2566,   570,   908,   661,  1540,
    1548, -1600,  1235,  1236,  3085,  2217,   883,  4303,  2696,  2309,
    2954,  1873,  3477,  2053,  4398,  1684,  1956,  3300,  4050,  1493,
     868,  1938,  2823,  1831,  1362,  1968,   664,  2104,  3064,  1174,
    1022,  1023,  4648,  4064,  1603,  1010, -2565,  1709,  1527,  1627,
    1710,  1022,  1023,   913,  3314,  3315,   686,  3845,  1047,  3607,
    4670,   623,  3607,  1281,  4597,  3924,  4770,   648,  1237,   654,
    1611,  1238,  3317,  1235,  1236, -2483,  3225,  3384,  1555,  1235,
    1236,  1235,  1236,  3650,  1832,  1048,   654,  3654,  4499,  2890,
    1272,  1959,  1235,  1236,   139,  3932,   648,   875,  3389,  2495,
    1966,   648,  2963,   885,  2480, -2114,  4121,  1235,  1236,  3311,
    3312,  3313,  1416,   868,  4505,  4125,   903,  1796,  1495,  1095,
   -2566,  1235,  1236,  1358,  2573, -2265,  4512,   648,  1867,  1235,
    1236,  1237,  3565,   956,  1238,  3375,  3915,  4040,  3617,  4141,
    2103,  2058,  2574,  1017,  4143,  2358,   667,   139,  1237, -1600,
    1237,  1238,  1237,  1238,  2409,  1238,  1568,   878,  1237,  1452,
    1874,  1238,  1037,  3226,  1569,  2628,  3687,  3391,  2338,  1612,
    1874,  1804,  4070,  2691,  2008,  1859,   648,  2011,  1059,  2341,
   -1560,  2014,  2344,  2017,  1235,  1236,  1860,  2692,  1825,  1835,
    3887,   516,  2643,  1653,  1654,  2358,   638,   886,  1088,  3624,
    3662,  1934,   638,   638,  2993,  3385,  2502,  1102,  1059,  1568,
     648,  2032,  2033, -2291,   648,  1235,  1236,  1569,  3331,  1708,
    2995,  1121,  2215,  4402,  1075,  1953,  1858,  1721,  1340,  1723,
     667,  3103,  2090,   667,   606,  3387,  3108,  1018,  3364,  2688,
    2163,  1736,  1737,  1738,  3116,  3117,  3130,  3696,  3149,  1742,
    3124,  2898,   603,  3329,   839,   993,  2993,  2689,  2572,  1237,
    2028,  4688,  1238,  3704,  3705,  1237,  1343,  -476,  1238,  2066,
     868,  1284, -2114,  1175,   893,  1537,  -934,  3708, -1895,  3234,
   -2411,  1916,  2335,  3839,  3055,  3954,  3949,   574,  1905,  4189,
    1604, -2647, -2265,  1085,  3766,  2188,   927,  2999,  1237,   593,
    4199,  1238,  2511,  1838,  1237,  2189,  3803,  1238,  1019,  1235,
    1236,  1109,  1237,  3519,  3138,  1238,  3627,  2175,  3537,  2414,
   -2647,  1237,  1239,  1935,  1238,   604,  3157,  3000,  2091,  3923,
    2687,  4238,  1237,  2068,  1232,  1238,  1234,  3512,  4056,  1605,
    1833,  2324,  3227,  3848,  3502,  4003, -1600,  3392,  1849,  3530,
    1239,  1237,  1474, -1600,  1238,  4348,  2086,  4337,  -572,  -573,
    4440,  1277,   516,  1279,  1280,  1059,   516,   648,   648,  3530,
     516,   648,  2180,  2231,  3982,  2845,  1324,  1053,  2945,  1902,
   -2291,  1237,  1076,  1024,  1238,  1239,  1433,  2012,  1436,  3881,
    3882,  1439,  1444,  4373,  1214,  1278,  1922,  1605, -2565,  1282,
    1480,  2310,  1239,  1287,  1239,  4052,  1239,  3226,  1465,  3157,
    3513,  4412,  1239,  1353,  1235,  1236,  4065,  1776,  1777,  4601,
    2232,  1776,  2250,  1503,  2042,  3245,   638,  4726,  2286, -2565,
    1928,  1235,  1236,  1235,  1236,  2104,  1538,  2929,   648,   638,
    2512,  1053,  1237,   638,  4259,  1238,  2092, -2411,  1237,  3693,
    1237,  1238,  2960,  1238,   519,  3346,  3347,  2513,  1235,  1236,
    2873,  1237,  1235,  1236,  1238,  4513,  2824,  2426,  3286,  2514,
    3700,  3119, -2566,  3479,  1270,  2426,  1237,  3140, -2765,  1238,
    3682,  2086,  1832,   648,  2427,   648,  1235,  1236,   648,   648,
    1237,  1988,  2427,  1238,  1252,  1451,  1711,  3165,  1237,  1712,
    3530,  1238,  3645, -2566,  3630,   648,  2060,  2061,  2062,  1235,
    1236,  1235,  1236,  1239,  1513, -2641,  1779,  3658,  1605,  1239,
   -2084,  3948,  3763,  1364,  2638,  1377,  1235,  1236,  3649,  2205,
    2639,  2181,  3653,  3629,  2289,  2290,  1383,  2103,  1317,  3368,
    1389,  2070,  3925,   899,  2694,  1235,  1236,  1070,  4590,  2469,
     638,  2515,  1239,  1237,  2573,  4509,  1238,  4220,  1239,  4519,
    3005,  4521,  4016,   887,  3809,  4061,  1239,  1554,  2223,  2484,
    3032,  3844,  2574,  3812,  2225,  1239,  1428,  4221,  3033,  1564,
    2893,  2306,  2307,   526,  1237,  4278,  1239,  1238,  1235,  1236,
    2802,  2803,  2043,  1109,  2257,  3406,  2044,  3408,  1235,  1236,
    3554,  3190,  3191,   638,  3419,  1239,  2498,  1832,  2628,  3309,
    2006,  3205,  2006,  2006,   638,  2753,  4451,   667,  3432,   667,
    2206,  2367,  2691,  2933,  2934,  3443,  3445,   520,  2356,  4458,
    1468,   521,  1235,  1236,  4257,  1239,  2692, -2624,  3462,  3464,
    3466,  2528,  4562,  1428,  3467,  3445,  2063,  3141,  1628,  1629,
    1630,  1635, -2628,   993,  4481,  2576,  2042,  1235,  1236,  2831,
    3369, -2627,  2711,  1235,  1236,  1468,  3646,  2516,  4591,  2894,
    1786,  2455,  1235,  1236,  1434,  2065,  3937,  3938,  1237, -2625,
    3509,  1238,  2938,  3165,  1780,  2400,  3165,  3165,  2688,  2801,
    1255,  1175,  1071,  2090,  1210,  4293,  1239,  2860,   870,   614,
    1584,  2183,  1239,  3165,  1239,  1175,  2689,  1824,  4311,  2422,
    2423,  3207,  3208,  2428,  2572,  1239,  2496,  3963,  2228,  3242,
    3243,  2428,  1832,  3983,  3986,  3988,  3989,  3120,  3106,  2501,
    1239,  2229,  2504,  2505,  3893,  2321, -2626,  2517,  1833,  2343,
    4555,  4208,  4142,  3894,  1239,  4144,  2230,  3939,  1633,  1466,
    3940,   615,  1239,  2086,  1770,  3002,  1861,  1568,  1592,  1769,
    2237,  1235,  1236,  3845,  1270,  1569,   560,   648,  2238,  1504,
    2568,  1514,  2856, -2631,  1235,  1236,  2806,  2807,   993,  4514,
    3959,  3960,  3961,  1237,  1211,  4279,  1238,  2609,  3964,  1271,
     676,  1235,  1236,  3694, -2641,   680,  3990,  2345,  2473,  1860,
    1237,   879,  1237,  1238,   648,  1238,   578,  1239,   833,  1828,
    3585,  2800,  1914,   837,  3280,  4306,  4307,  2328,  1235,  1236,
     900,  2810,  2175,  2248,  2043,   638,   616,  1237,  2044,  2687,
    1238,  1237,  2104, -1922,  1238,  2612,  1235,  1236,  1239,  3469,
    2091,   904,  1769,  3370,  1235,  1236,  1235,  1236,  1452,  2958,
    1096,  2360,  1175,   648,  2249,  1237,  3344,   888,  1238,  1235,
    1236,  4085,  2336,  1833,   582,  2082,  3121,  3504,  3846,  4312,
    3029,   648,  1235,  1236,  4515,  2413,  1235,  1236,  1237,   648,
    1237,  1238,  3895,  1238,  1885,  2349,  1888,  2363,  4280,   638,
    1235,  1236,  2429,  2350,  1126,  1237,  1235,  1236,  1238,  4493,
    2429,   638,  1505,  1235,  1236,  1429,  4516,  2092,  3142,   648,
    1235,  1236,  3806,  2133,  1237,  1995, -2624,  1238,   638,   638,
    4473,  4474,  1235,  1236,  4379,  2180,  4380,  1506,  2317,  2601,
    1097, -2628,  1239,  1642,  1235,  1236,   667,  2134,  2693,  4378,
   -2627,  1235,  1236, -1922,   648,   648,  4494,  2218,  1940,  1605,
    3371,  1235,  1236,  1235,  1236,   625,  1948,  1237, -2625,  1949,
    1238,  1235,  1236,  1235,  1236,  1235,  1236,  1237,   648,   607,
    1238,  4558,  1429,  2300,  4391,  1996,  4483,  3926,  1833,  1969,
     956,   628,   609,  1892,  1235,  1236,  1389,  4484,  3397,  3397,
     516,   516,   516,   638,   516,   638,  1264,  1265,  1266,  1267,
    2007,  1237,  2329,  4435,  1238,  4548,  2009,   516,   870,   648,
    2072,  2446,   626,   516,  4518, -2626,  1389,  4209,   667,  2083,
    1235,  1236,  3002,  1989,  1990,  1991,  1237,  1993,  2772,  1238,
    4349,  2035,  1237,  3847,   638,  1238,  2181,  1239,  2515,  4347,
    2010,  1237,  3071,  2694,  1238,  4313,  2016,  1235,  1236,  3848,
    2006,   679, -2631,  2253,  1239,  2474,  1239,  4270,  4271,   868,
    -578,  3350,  3523,   629,  1235,  1236,  1643,  3523,   835,  3206,
    4791,  4084,  2265,  4495,  4570,  3030,  2914,  3428,  1985,  1271,
     617,  1239,    44, -2717,  3127,  1239,   610,  4319,  3405,   638,
    1992,  3031,  1994,  4613,  2680,  3340,  2318,  2272,  4320,  2532,
    2455,  2276,   618,   639,   520,  2015,  4241,   648,   521,  1239,
    4350,  4273,  2036,  4086,  3435,  3436,  3581,  3271,  3272,  3273,
    3583,  3088,   638,  1642,  3611,  2277,  1859,  2128,   638,   642,
    1237,  2027,  1239,  1238,  1239,  2921,  3089,  3029,   619,   638,
    1235,  1236,  3849,  1237,  2572,  -212,  1238,  2222,  1053,  1239,
    2279,  2456, -1922,  3429,  3341,   583,   648,  1642,  1235,  1236,
    1237,   648,  1997,  1238,  3241,  2280,  3151,  1642,  1239,  3612,
    1121,   644,  2204,  1370,  3355,  3695,  1371,  1858,  2042,  1481,
    2133,  1235,  1236, -1922,  2284,  4015,  2067,  1237,   657,  1769,
    1238,  1537,  3997, -2717,  1235,  1236,  3297,   620,  2922,  4618,
    4618,  1820,  4485,  1642,  2134,  1237,  2102,  2378,  1238,  3709,
    1482,  1239,  2333,  1237,  2330,  1237,  1238,  4605,  1238,  2122,
    3713,  1239,  2433,  3715,  3524,  2130,  1669,  2302,  1237,  3524,
    2331,  1238,  1627,  1235,  1236,  3955,  2224,  3081,  3956,  1289,
     124,  1237,  4240,  4261,  1238,  1237,  1941,  3688,  1238,  2845,
      58,  3691,  3692,  2805,  3430,  1239,  1665,  4685,  4686,  1237,
    1175,  2258,  1238,  2993,  1483,  1237,  2221,  1272,  1238,  1484,
    3291,  3188,  1237,  1235,  1236,  1238,  3174,  2361,  2687,  1237,
    1239,   670,  1238,  1235,  1236,   664,  1239,  2736,  2056,  1670,
    1728,  1237,  2741,  3351,  1238,  1239,  3189,  2923,  1076, -1922,
    1732,  2091,  3200,  1237,  3525,  2747,  1238,  1235,  1236,  3535,
    1237,  3210,   672,  1238,  1235,  1236,  4321,  2384,  1671,  2385,
    1237,  2327,  1237,  1238,  1372,  1238,  1235,  1236,   674,  3893,
    1237,  2133,  1237,  1238,  1237,  1238,  1756,  1238,  3894,  2762,
    4112,  1252,   273,  1109,   275,   675,  2043,  3266,  4696,  2349,
    4698, -1922,  1538,  1237,  4702,  2134,  1238,  3325,  3031,   681,
    3998,  2885,   826,  2351,   638,  1235,  1236,  3509,  1769,   868,
    3397,   648,  1627,   638,   648,  3441,  4703,  2924,  2321,  1942,
    4486,  2450,  2451,  2452,  1239,  4719,   638,  2468,  1672,  1237,
    4083,  1324,  1238,  2698, -2765,  1062,  1324,  1239, -1806,  2374,
    3211,  2968,  1147,  1148,  1235,  1236,  2382,  2382,  2816,  2382,
    1235,  1236,  2239,  4024,  1239,  1053,  1237,  2699,  4048,  1238,
    1821,  1485,  1235,  1236,  2969,  4750,  4751,  2251,   648,  2301,
    2180,   638,   682,  1237,  3796,   638,  1238,  2693,  4113,   589,
    2716,  1239,  4069,  1822,  2219, -1806,   683,   589,  1063,   831,
    3032,  2199,   648,   648,   638,   638,  2240,   955,  4179,  1239,
     876,  2352,  1235,  1236,  2908,  1175,   648,  1239,  1673,  1239,
    1973,  2382,  2382,  2382,  2247,   667,  1217,  3895,  1235,  1236,
     842,  4114,  1239,  3822,   648,  2909,  1235,  1236,  2993,  2993,
    2220,  1272,  2694,  2251,   890,  1239,  1486,  2261,   896,  1239,
    3828,   956,  1669,  2381,  2381,  1418,  2381,  1235,  1236,  1237,
    2262,  3334,  1238,  1239,  2266,  4327,  1235,  1236,   916,  1239,
    3526,  2910,  2491,  1235,  1236,  3526,  1239,  1237,  2405,  3453,
    1238,  3454,  1364,  1239,  2270,  1468,  1333,  1255,  3914,  1064,
    2093,  2271,  4552,  2421,  4553,  1239,  1235,  1236,  2275,   898,
    1237,  1383,  2425,  1238,  3354,  3647,   918,  1239,  2226,  2227,
    2278,  1487,   638,  1237,  1239,  1670,  1238,   908,  2381,  2381,
    2381,  1007,  2281,  2993,  1239,  3455,  1239,  1014,  2510,  2293,
    3810,  1235,  1236,  1035,  1239,   638,  1239,  1036,  1239,  2312,
    3521,  3154,  2774,  2925,  2987,   516,   516,  3456,  2534,   516,
    1042,  3178,  1237,  3184,   273,  1238,   275,  1239,  1823,   629,
    2487,   879,  4205,  4206,  4207,  1235,  1236,  4179,  4179,  3556,
    3557,  2681,  3185,   964,   945,   720,  1769,  2697,  2530,  2531,
    3578,  2168,  1512,  1061,  3457,  2069,  1235,  1236,  1517,  1518,
    3570,  3337,  1237,  1239,  1050,  1238,  2720,  3917,  3918,  2094,
    1235,  1236,  1237,  3177,  3293,  1238,  1433,   638,  3192,  2503,
    1069,  1581,  1582,   273,  2988,   275,  4234,  4235,  1433,  1076,
    1239,  1086,  2721,  1089,  1769,  1108,  1237,  1235,  1236,  1238,
    1488,  2958,  2522,  1237,  1674,  3196,  1238,  1239,   725,  1107,
    4236,  1257,  1258,  1455,  4328,  1237,  1029,  1030,  1238,  1031,
    2539,  1032,  3197,  1235,  1236,  2776,  1625,  2244,  1272,  2546,
    2547,  1123,  1235,  1236,  2536,  2537,   648,  1489,   648,  1124,
    2551,  2552,  2553,  2554,   648,  2562,  2563,  1125,  1792,  2722,
    2705,  2548,  2723,  2708,  1237,  1127, -1806,  1238,  1235,  1236,
    2724,  1572,  1235,  1236,  2989,  2252,  1272,  1128,  2566,  2567,
    1860,  1456,  1675,   648,  1065,  2142,  2143,  1129,  2725,  2254,
    1272,  2808,  2798,  1239,  2511,   648,  3941,  2255,  1726,  3944,
    3945,  2156,  1132,  1237,  4179,  4179,  1238,  4327,  3198,  1237,
    1457,  1239,  1238, -1806,  2345,  1133,  3957,   738,  2511,  2710,
    2086,  1237,  2820,  1328,  1238,  1272,  3199,  1275,  1935,  1935,
    1935,  1109,  1109,  1109,  1239,  4010,  4011,  2267,  1272,   993,
    2268,  1272, -1923,  2674,  2675,  2676,  2677,  1239,  2095,  3201,
    1066,  1024,  1067,  3699,  2269,  1272,  4033,  4355,  1134,  2096,
    1135,  1237,  3204,  1136,  1238,  1137,  2097,  1138,  3458,  1260,
    1261,  1262,  1263,  1264,  1265,  1266,  1267,  1237,  1276,  -671,
    1238,  1139,  1053,  1053,  1053,  1237,  1239,  1868,  1238,   648,
    1869,  2726,  3240,  1870,  1140,  3002,  1141,   754,  1142,  1186,
    1293,  3209,  2273,  1272,  1329,  1143,  1237,  3003,  1144,  1238,
    1330,  4697,  3459,  4179,  2817,  1237,  2693,  1327,  1238,   648,
    1252,  1205,  1237,  3619, -1895,  1238,  1239,  1145,  4179,  1149,
    2158,  2159,  2512,   122,  1218,  1219,  1239,  1099,  1100,  1690,
    2169,   648,  2006,  1793,  1151,  1237,  1832,  1336,  1238,  2513,
    3643,  3212, -1923,  4013,  1331,   273,  2512,   275,  3775,  4091,
    1239,  2514,  1345,  4034,  4035,  2098,  1152,  1239,  4036,  4037,
    1769,  1332,  1153,  2513,  1468,  3214,  2854,  3297,  1156,  1239,
    1237,  1325,  3216,  1238,  1157,  2514,  4328,  1235,  1236,  1158,
    2990,  2564,  2565,  1334,  3218,  4179,  2727,  2790,  1272,  2829,
    2830,  2878,  2086,  2468,  1433,  2881,  3151,  3173,  2227,  1159,
    -671,  1160,   648,   648,  1237,   529,  2170,  1238,  1239,  4179,
    3176,  1272,  2168,  1337,    13,  3417,  2902,  1458,  2904,  4621,
    1161,  4179,  4179,  3219,  4620,  1237,   123,  1162,  1238,  1163,
    2103,  1694,  1164,  2515,  1165,  1252,  1168,  2698,  1169,  1237,
     956,  1170,  1238,  2133,   124,  4543,  2007,  1239,  2007,  2007,
    2099,  1176,  1769,  1239,  2321,  1177,  3879,  2515,  1178,  3441,
    3388,  2699,  3220,  4249,  4250,  1239,  1237,  2134,  3400,  1238,
    1179,  1607,  3202,  1272,  1770,  3303,  3304,  3307,  3308,  1346,
    3575,  3819,  1180,  2966, -2760,  3407,   516,  2168,  4179,  1181,
     648,   648,  1237, -1895,  1182,  1238,  1183,  3421,  4179,  3423,
    3424,  1237,  1184,   783,  1238,  1239,  1255,   993,  1187,  2901,
    1188,  3437,  1189,   125,   964,   945,  3156,  1347,  1832,  2971,
    3576,  1239,  4265,  4266,    25,  4268,  4269,  1237,  1190,  1239,
    1238,  1237,  2728,  1191,  1238,  1695,  3577,  3589,  1272,  1698,
    4179,   930,  4179,  2103,  3821,  1794,  1699,  3614,  3615,  2516,
    1239, -1923,  3780,  3781,  3788,  3789,  1459,  3799,  3807,  1239,
    2171,  1795,  1192,  4354,  1356,  3827,  1239,  4179, -1895,  3823,
    1272,  2086,  1193,  2516,  3829,  3065,  1194,  4179,  1460,  4179,
    1354,  4179, -1923,  1195,  4100,  4609,  1196,  2683,  1197,  1239,
    3080,  1198,  1833,  1608,  1199,  4179,  2512,  1609,   126,  1200,
    2168,  2729,  4179,  1360,  3101,  3004,  3840,  1272,  1610,  1252,
    3856,  3857,  1201,  2513,  4006,  2565,  1202,  4179,  4179,  2517,
    1461,  -671,  4184,  4185,  1239,  2951,  4187,  4188,  1700,  1203,
    2730,  1255,  4100,  4179,  4179,  4191,  4188,  1204,  4179,  3830,
    1669,  3013,  1935,  2517,  3016,  3017,  2086,  3019,  4192,  4188,
    3022,  3023,  1368,  1252,  3026,   638,   638,   638,  1239,  3035,
    1257,  1258,  4248,  3308,  3039,  3040,  3041,  3042,  3043,  1252,
    3563,  1208,  3047,  3048,   931,  3050,  4267,  4188,  1209,  1239,
    1212,  3059,  3060,  3061,  3062,  1251,  1702,  3066,  3067,   993,
    3069,  2169,  1213,  1239,  3831,  1216,  1053,  1832, -1923,  1220,
    2683,  3104,  3105,  1670,  3107,  1221,  3109,  3110,  3111,  3112,
    3113,  3114,  3115,  1222,   930,  3118,  1223,  2073,  3123,   534,
    1239,  3126,  3590,   955,  1224,  2104,  4276,  4277,  -671,  1225,
     127,  2074,  1671,    38,  1378,  3832,  4357,  4358,  4392,  3615,
    1611,  1274,  4731,  1390,  3002,  1408,  1239,  1392,  3133,  2433,
   -1923,   932,  3145,  3146,  3147,  1239,  3003,  2434,  1410,  2086,
    1411,  4088,  4393,  4188,    44,  1412,  2169,  2170,  1416,  1669,
    4200,  1413,  1832,  1419,  1833,  2274,  4394,  4188,  1646,  1647,
    1648,  1239,  1324,  1424,  2374,  1239,  4396,  4188,  1353,   648,
     648,   648,  4397,  4188,  1425,  1666,  1445,   638,  1252,  4403,
    4404,  -671,  1672,   128,   693,  1255,  2549,  1449,  1260,  1261,
    1262,  1263,  1264,  1265,  1266,  1267,  2854,   648,  1450,  4405,
    4404,  1770,  2856,  2952,  4792,  4444,  4445,  1729,  1703,  1454,
    1733,  1466,  1670,  4491,  3308,  1475,  1175, -2760,  2104,  1612,
     648,   648,   648,  1476,  1705,  4492,  3308,   931,  3539,  1255,
    1477,  1752,  1753,  3324,  1478,  1757,  1497,  3965,  1501,  -671,
    1502,  1671,  4568,  4569,   529,  1255,   129,  1507,   993,  4594,
    3615,  1515,  1771,  1772,  4623,  4624,  2435,  2436,  1516,  2169,
      54,  1521,  1673,  4682,  3506,  1832,  2007,  3702,  4094,  4735,
    4736,  1522,  2820,  2517,  3279,   720,  4781,  4782,  1524,  2075,
    4025,  4026,  2133,  3966,  1253,  3540,  1759,  1760,  3541,  1529,
    4222,  3633,  3634,  3967,  4263,  1534,  3542,  2437,  4223,  3804,
    1565,  2171,  3597,  3598,   932,  1571,  2134,  1254,   638,  3080,
    1573,  1672,    58, -2760,  3543,  1262,  1263,  1264,  1265,  1266,
    1267,  3854,  3855,   993,  1575,  4224,  3323,  4340,  4344,  1578,
    1579,   724,  1583,  1833,  1769,  1587,  1588,  3080,   725,  1257,
    1258,  4353,  3968,  2555,  1593,  1594,  3404,  3402,  3080,  1595,
    1616,  1617,  3414,  1618,  3413,  2076,  1624, -2107,  1626,  3544,
    1627,  1636,  1638,  1270,  1642,  2678,  1649,   729,   730,   648,
    3413, -1895,  1668,  1679,  1255,  3434,  3438,  4140,  1714,  1725,
    1770,  2077,  3449,  1257,  1258,  1726,  1727,  1750,  3451,  3452,
     638,  1673,  1767,  2555,  1778,  1099,  1100,  1787,  1803,  1257,
    1258,  1830,  3413,  1809,  1829,  3373,  2556,  1622,  1833,  3080,
    3475,  1836,  1837,  1840,  1847,  3488,  1843,  3545,  1348,  1844,
    4285,   516,  1845,  1846,  4356,  3498,  4285,  1848,   933,   934,
    3413,   936,  1850,   938,  1851,  2557,   993,   738,  1862,  3900,
    3134,   273,  1863,   275,  2078,  1893,  4225,  1865,   939,  3415,
    3416,  4119,  4120,  1864,  3494,  1898,  2556,  1901,  1910,  1918,
    -671,  1920,  1919,  1921,  4123,  1925,  3511,  1930,  1931,  1932,
    3418,  4126,  1256,  -853,  1933,  4340,  1944,  3448,  1674,  4344,
    1950,  1974,  3518,  3427,  1982,  2557,  1983,  3450,  1261,  1262,
    1263,  1264,  1265,  1266,  1267,  1987,  4407,  4145,  4146,  2018,
    2020,   749,  2021, -1600,  2019,  2558,  2024,  2023,  3487,  2025,
    2040,  2054,  4129,  2071,  2117,  2123,   753,   754,  2137,  3546,
    2124,  1833,  3547,  2138,  2164,  2182,  2185,  4226,  1257,  1258,
    2184,  1260,  1261,  1262,  1263,  1264,  1265,  1266,  1267,  2196,
    2079,  2202,  2243,  2235,  1259,  4227,  4406,  1260,  1261,  1262,
    1263,  1264,  1265,  1266,  1267,  2558,  3638,  2245,   534,  2251,
   -1600,  1242,  1243,  2256,  1349,  2940,  3514,  2142,  2143,  4228,
    2208,  3588,  2210,  2322,  1099,  1100,  4475,  2211,  2212,  2902,
    3970,  1769,  2234,  2156,  2236,  2559,  2241,  3971,  4353,  2291,
    2242,  2260,  2264, -1600,  2282, -1600,  2292,  2283,  1244,  2288,
    3548,   933,   934,   935,   936,   937,   938,  1674,  2303,  2304,
    1245, -1600,  2305,   693,  2326,  1235,  1236, -1600, -1281,  2854,
    2332,   939,  1267,  2342,  2362,  1154, -1424,  3972,  2377,  1206,
    4043,  1210,  2397, -1600,  2406,  2559,  -679,  1605,  2878,  3626,
    -671, -1600,  3628,  3965,   648,  4053,  4340,  4344, -1600,  2412,
    1252,  1246,  2555,   648,  1433,  3442,  2415,  2418, -1600,  2817,
    2441,  2442,  2447,  1247,  2448,  2449,   956,   956,  2472,  2464,
   -1600,  2470,  2901,  2471,  2207, -1600,  1260,  1261,  1262,  1263,
    1264,  1265,  1266,  1267, -1600,  2475,  1770,  2477,  1418,  3966,
    1248,  2476,  1348,  2488,  2478,  2479,  2490,  4094,  2492,  3967,
    3973,  3674,  2493,  2506,   720,  2497,  4520,  2507,   638,   528,
     775,  2520,  2158,  2159,  4095,  2556,  2521,  4096,  2524,  3683,
    4628,  1686,  1687,  1688,  1689,  1690,  2525,  4181,   781,  3080,
    4450,  2527,   588,   783,  2529,  2538,   784,  3549,  3413,  2545,
    2648,  3080,  2540,  2644,  2557,  2541,   993,  2542,  3968,  4460,
    2543,   648, -1600,  1249,  2544,  3413,  2650,  3080,  3080,  2259,
     724,  2652,  4229,  2263,  2673,  3644,  3550,   725,  1433,  2653,
    2654,  3080,  3413,  2655,  2656, -1600,  2657, -1600,  2658,  2659,
    2660,  2661,  2682,  3413,  2662, -1600,  3413,  2287,  4233,  2663,
    2664,  2665,  2666,  4097,  4098,   529,   729,   730,  2667,  2668,
    2669,  2560,  2670,  2671,  2672,  3676,  2701,  3974,  2702,  2703,
    3718,  2706,  2511,   638,  2558,  2710,  2714, -1600,  3774,  2719,
    2742,  3969,  2743,  2744,  1691,  1692,  1693,  1694,  2754,  2350,
    4628,  2755,   544,  -884, -1600,  2767,  2789,  2796,  1349,  2804,
    3101,  2813,  1252,  2827,  2814,  3701,  1255,   273,  2828,   275,
    2832,  2560,  2833,  2834,  3707,  2835,  1686,  1687,  1688,  1689,
    1690,  2836,  2837,  2846,  2843,   648,   738,  2848, -1600, -1600,
    2849,  2850,  3875,  2857,  4633,  4634,   844,  4636,  2861,  -853,
    2858,   530,  2863,  1905,  2862, -1600,  1769,  2864,  2868,  2882,
     545, -1600, -1600,  4776,  2559,  2883,  2886,  2887,  2888,  1769,
    2456,  2455,  2906,  2907,  1769,  2555,  4785,  1959,  3444,  1769,
    3719,  4776,  1958,  2917,  2932, -1600,  4785,  2935,  2947,   546,
    2948,  2949, -1600,  3777,  2964,  2555,  2555,  2972,  3461,  3463,
     749,  1695, -1600,  1696,  1697,  1698,  2983,  4678, -1600,  4679,
    4680,  2984,  1699,  3015, -1600,   753,   754,  3864,  3193, -1600,
    2512,  3002,  1770,  3250,  3020,  3021,   547,  3024, -1600,  1691,
    1692,  1693,  1694,  3251,  3025,  3027,   845,  2513,  2556,   648,
    3028,  3034,  4233,  3036,  3037,  3038,  3046,  3045,  3252,  2514,
    1099,  1100,  3051,   531,  1237,  3052,  3970,  1238,  2556,  2556,
    3253,  3254,  3255,  3971, -1600,  3087,  3132,  2557,   847,  3091,
    1257,  1258,  3057,  3058,   548,  2073, -1600, -1600,  3096,  3256,
    3068,  2555,   848,  3080,  3465,  3102,  3136,  2557,  2557,  2074,
    1669,  3148,  3131,  2203,  1700,  3168, -1600, -1600,  3170, -1600,
    3157,  4747,  3413,  3972,  3162,  1876,  3080,  3231,  1255,  1877,
    3171,  1433,  3172,  3179,  1770,  3180,  4762,  3232,  3413, -1600,
     638,  1878,  3235, -1600, -1600,  4501,  3221, -1600, -1600, -1600,
    3239,  2515,  4498,  3237,  3244,   532,  1695,  2558,  1696,  1697,
    1698,  3247,  3249,   852,  2556,  3268,  3269,  1699,  3274,  3281,
    3276,  1701,  1702,  1670,  3883,  3284,   533,  2558,  2558,  3285,
    1370, -1600,  3299,  3288,  3302,  3321,  3305,  3310,  3322,  3326,
    3327,   853,  3905,  2557,  3338,  3330,  3973,  3345,   854,   534,
    2560,  3339,  2987,  3638,  3349,  3996,  3352,  3360,  4001,  2609,
    3361,  3420,  4533,  3422,  3484,  4009,  4009,  4009,  2007,  3489,
    3492,   -67,  3495,  3496,  3500,  3505,   549,  4533,   648,   775,
    3506,  3510, -1600,  4095,  2056,  1295,  4096,  2559,   855,   535,
    1262,  1263,  1264,  1265,  1266,  1267,  4503,   781,  3536,  1700,
    3555,  3558,   783,  3559,  3566,   784, -1600,  2559,  2559,  3579,
    3567,  2309,  3592,  2558,  3226,  3593,  3594,  2516,  1296,   895,
    3603,  4788,  2988,  3605,  3618,  3610,  2433,  2075,   550,  3616,
    3631,   536,  1257,  1258,  3651,  3652,  3663,  3639,  3669,   537,
    3675,  3679,  3670,  2468,  4586,  3677,  3678,  3685,  3686,   551,
     648,  3684, -1600,  3974,  3698,  3706,  1701,  1702,  3710,  3716,
    2881,  3717,  4097,  4098,  1703,  2642,  3776,  3778,  3257,  3794,
    3785,  3791,  4053,  3786,  3792,  3801,  3805,  3674,  1239,  1704,
    1705,  3797,  3793,  3808,  3798,  3811,  3258,  2517,  1297,  3813,
    4009,  3799,  3800,  2559,  3815,  3080,  3824,  3826,  3825,  3843,
    4104,   638,  2989,  2076,  3841,  3859,  3816,  3325, -1600,  4109,
    3871,  3860,   552,  1298,  3817,  3820,  3834,  1299,   553,  3872,
    3852, -1600,  1879,  3835,  3869, -1510,  1099,  1100,  3877,  2077,
    1433,  3857, -1515,  3892,  3901,  3886,  3910,   554,  1394,  3876,
     648, -1600,   858, -1600,  3919,  3920,  3916,  4533,  1395,  3902,
    1880,  3935,  3903,  1300,  3927,  4501,  3906,  4666,  1881,  4071,
    3942,  3985,   555,  1396,  3992,  4017,  4147, -1600, -1600,  4021,
    3807, -1600, -1600,  4022,  1301,  1397,  1398,  1399,  4027,   556,
    1260,  1261,  1262,  1263,  1264,  1265,  1266,  1267,   861,  1302,
    4028,  4023,  2078,  4029,  1400,  4030,  4041,  4042,  4102,  1703,
    3259,   862,  1882,  2560,  4046,  4045,  4110,  4058,  4060,  4073,
    4233,  4072,  4132,  4089,  1704,  1705,   638,  4133,  3260,  4219,
    4090,  4092,  2386,  2560,  2560,  4093,  4713,   648,  3982,  4107,
    4118,  4122,  4134,  4124,  4128,  4135,  4136,  1303,  4533,  4138,
    4533,  4139,  4674,  4148,  4182,  4193,  2387,  4194,  4254,   638,
    4759,  1883,  4195,  4202,  4733,  4190,  4198,  4197,  4201,  2388,
    4204,  4533,  1304,  4009,  4009,  4215,  4009,  4009,  4212,  1295,
    4258,  2389,  4245,  4247,  4275,  4281,  4289,  4759,  3261,  4287,
    4297,  4290,   865,  -352,  4315,  4318,  4336,  4317,  2079,  4346,
    4360,  4363,  4533,  4533,  4364,  4369,  3262,  4767,  4372,  4374,
    4376,  4381,  1296,  4386,   866,  4390,   867,  4412,  4399,  2560,
    4409,  4415,  -370,  4213,  4295,  4441,  4442,  4443,  2990,  4453,
    4489,  4674,  2390,  4452,  2391,  4301,  4465,  4459,  4477,  4462,
    4308,  2575,  3479,  4522,  4529,  4530,  4534,  2576,  4572,  2577,
    4540,  2578,  4541,  4558,  4573,  4575,  4255,  4574,  4581,  4582,
    4583,  2392,  2579,  4584,  2580,  4585,  4588,  4595,  4598,  4322,
    4326,  4599,  4009,  4600,  4606,  4608,  4610,  1305,  4601,  4611,
   -2462,  4614,  1297,  2601,  2576,  4632,  1306,  4635,  4637,  4638,
    4646,  4642,   824,  4645,  2581,  4667,  1770,  4654,  4668,  2582,
    2583,  1307,  4693,  4683,  4694,  4671,  2584,  1298,  4790, -1684,
    4681,  1299,  4695,  4699,  4700,  4705,  4708,  4294,  2585,  1308,
    4704,  4711,  4710,  1401,  4715,  4718,  2586,  2393,  4722,  2881,
    4724,  2881,  4729,  4734,  4727,  4728,  2587,  4738,  4748,  4740,
    4763,  1402,  4768,  4764,  4777,  2822,  4787,  1300,  4310,  3125,
    4005,  3790,  2996,  2588,  1547,  4476,  4076,  4387,  4504,  4643,
    4074,  4400,  1577,  1309,  1496,  4644,  1310,  1565,  1301,  4078,
    2589,  4779,  4253,  4742,   601,  1006,  2444,  2370,  2590,  2591,
    3264,  4159,  2394,  1302,  4160,  2592,  4162,  4163,  4416,  4165,
    4166,  4167,  4168,  2593,  1311,  4169,  4752,  -961,  4170,  2594,
    4651,  4527,  4652,  4173,  4619,  4174,  4175,  4539,  4538,  1620,
    2595,  2115,  2353,  4389,  4260,  3072,  1312,  4361,  4362,  2626,
    3712,  4365,  4366,  4367,  4368,  3287,  3862,  3609,  3292,  4464,
    2596,  1303,  1908,  3865,  4707,  4557,  4673,  4631,  4371,  2167,
    1043,   824,  4219,  4082,  4214,  3070,   824,  3667,  3474,  3909,
    3481,  3077,   648,  4101,  4103,  4716,  1304,  4523,  4482,  3552,
    3950,  4283,  4556,  3991,  4137,  1313,   273,  2820,   275,  4127,
    3584,  2981,  2597,  1403,  2598,  3580,  3223,  3582,  4507,   540,
     541,  2700,  2599,   824,  4592,  4449,  4593,  4455,  4457,  3144,
    3689,  4335,  4286,  3074,  1520,  3473,  2939,  2600,  4106,  2647,
     824,  1585,  2041,  2865,  4446,  4542,  3922,  2165,  2424,  3278,
    3604,  2844,  2795,  2129,  2889,  4180,  2454,  1033,  2139,  3591,
    1423,  2601,  2735,  4447,  4408,  3246,  2959,  2733,  3648,  4326,
    2953,  2794,  4383,  1404,  4550,  4251,  4640,  3787,  4469,  4470,
    4641,  1667,  2811,  1770,   824,   824,   824,   824,  3930,  1724,
    2057,  1405,  3335,  4062,  4630,  2602,   824,  3468,  4471,  4472,
    4732,  1305,  4055,  2704,   648,  2896,  1891,  4480,  2871,  2842,
    1306,  3867,  1923,  2603,  1557,  3622,  3621,  2604,  2140,  3657,
    2141,  2142,  2143,  2144,  2145,  1307,  2146,  2147,  2148,  2149,
    2150,  2151,  2152,  2153,  2154,  4554,  2155,  2156,  2157,  1558,
    1559,  1020,  1560,  1308,  2201,  1122,  1999,  2499,  1001,  2500,
    3934,  2936,  1004,  2364,  1929,  3608,  4706,  2605,  4576,  4730,
    4639,  4786,  2606,  4789,  1215,  4131,  1947,  4549,  2915,  2607,
    3625,  2608,  3641,   958,  2325,  3642,  2609,   959,  2913,  2610,
    2482,  2905,  2912,   906,   824,  2411,  1283,  1309,  4565,  4566,
    1310,   648,  1939,   926,  1409,  2884,  1884,  3265,  4203,  2191,
    4211,   928,  1415,  1039,  1551,     0,  1040,  3101,  3101,  1041,
    2611,     0,     0,  1552,     0,     0,  1553,     0,  1311,     0,
       0,     0,     0,     0,  2612,  2613,  2614,  2615,     0,     0,
       0,  4656,     0,     0,     0,     0,     0,   520,  4664,     0,
    1312,   521,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2616,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2158,  2159,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1313,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4780,     0,     0,     0,     0,     0,     0,  2617,  2618,  2619,
       0,     0,     0,     0,  2620,     0,     0,     0,     0,  4720,
       0,     0,     0,     0,  4725,     0,     0,     0,     0,     0,
    2621,     0,     0,  1130,  2622,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2623,     0,     0,     0,     0,  2624,     0,
       0,     0,     0,  4760,     0,     0,     0,     0,     0,     0,
    1167,  2625,     0,     0,     0,   824,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,  1770,     0,
    4760,     0,     0,     0,     0,     0,     0,   648,     0,     0,
       0,  1770,     0,     0,  4714,     0,  1770,     0,     0,     0,
       0,  1770,   824,   824,     0,     0,     0,     0,     0,     0,
       0,   824,   824,   824,   824,   824,   824,   824,   824,   824,
     824,   824,   824,     0,  1229,  -961,     0,     0,     0,     0,
       0,   824,   824,     0,   824,   824,     0,     0,     0,   824,
       0,     0,   824,   824,   824,   824,     0,   824,   824,   824,
       0,     0,     0,     0,     0,     0,   824,   824,     0,   824,
     824,   824,   824,   824,     0,     0,   824,   824,   824,   824,
     824,   824,   824,   824,   824,   824,   824,     0,   824,     0,
       0,   824,   824,     0,     0,     0,   824,     0,     0,     0,
     824,   824,   824,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   824,   824,   824,     0,     0,     0,     0,     0,
       0,   824,     0,     0,     0,     0,     0,     0,   824,   824,
     824,  1369,   824,     0,     0,     0,     0,     0,     0,   824,
     824,   824,     0,   824,   824,   824,   824,   824,     0,   824,
     824,   824,   824,   824,   824,   824,   824,     0,     0,     0,
     824,   824,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   824,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2579,     0,  2580,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   824,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   824,  1601,     0,  -818,  -818,     0,  2582,     0,     0,
       0,     0,     0,     0,     0,     0,  -818,   824,     0,     0,
       0,   824,     0,     0,     0,     0,  2585,     0,     0,     0,
       0,     0,     0,     0,  2586,     0,     0,     0,     0,  1640,
    1641,     0,     0,     0,     0,     0,     0,     0,  1651,  1652,
       0,     0,  1655,  1656,  1657,  1658,  1661,  1662,  1663,  1664,
       0,  2588,     0,     0,     0,     0,     0,     0,  1680,  1681,
       0,  1682,  1683,     0,     0,  1565,   824,     0,  2589,  1716,
    1717,  1718,  1719,     0,     0,  1722,     0,     0,     0,     0,
       0,     0,     0,  1730,  1731,     0,  1734,  1735,     0,     0,
       0,     0,     0,  1739,  1740,  1741,     0,  2594,  1744,  1745,
    1746,  1747,  1748,  1749,     0,  1751,     0,     0,  1754,  1755,
       0,     0,     0,  1758,     0,     0,     0,  1761,  1765,  1766,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1773,
    1774,  1775,     0,     0,     0,     0,     0,     0,  1783,     0,
       0,     0,     0,     0,     0,  1788,  1789,  1790,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   273,     0,   275,     0,     0,     0,
       0,     0,  2598,     0,     0,     0,     0,     0,  1826,     0,
    2599,     0,     0,     0,     0,     0,     0,  2579,     0,  2580,
       0,     0,     0,     0,     0,  2600,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   824,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  -818,  -818,     0,  2582,     0,     0,  2579,     0,  2580,
       0,     0,     0,  -818,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2585,     0,     0,     0,     0,     0,     0,
       0,  2586,     0,  2602,     0,     0,     0,     0,     0,     0,
       0,  -818,  -818,     0,  2582,  1895,     0,     0,     0,     0,
       0,  2603,     0,  -818,     0,     0,     0,     0,  2588,     0,
       0,     0,     0,  2585,     0,     0,     0,     0,     0,     0,
       0,  2586,  1565,     0,     0,  2589,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2588,     0,
       0,   824,   824,   824,  2594,     0,     0,  2607,  1946,  2608,
       0,     0,  1565,     0,     0,  2589,   824,  2610,  1952,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1980,     0,     0,     0,  1986,     0,
       0,     0,   824,     0,  2594,     0,     0,     0,   824,     0,
       0,   824,     0,   824,     0,     0,     0,     0,     0,   824,
       0,   824,   824,     0,     0,     0,     0,     0,     0,     0,
       0,   273,     0,   275,     0,     0,     0,     0,     0,  2598,
       0,     0,     0,     0,     0,     0,     0,  2599,     0,  2616,
       0,     0,     0,  2031,     0,     0,     0,     0,     0,     0,
       0,     0,  2600,     0,     0,     0,     0,     0,     0,     0,
       0,   273,     0,   275,     0,     0,  2974,     0,     0,  2598,
       0,     0,     0,     0,     0,     0,     0,  2599,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2600,     0,     0,  2617,  2618,  2619,     0,     0,
       0,     0,  2620,     0,   824,     0,     0,     0,     0,     0,
    2602,     0,     0,     0,     0,     0,     0,     0,  2621,     0,
       0,     0,  2622,     0,     1,     0,     2,     0,  2603,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2623,     0,     3,     0,     0,     0,     4,     0,     0,
    2602,     0,     0,     0,     0,     0,     0,   824,     0,  2625,
       0,     5,     6,     0,     0,     0,   824,     0,  2603,     7,
       0,     0,     0,     0,     8,     9,     0,     0,     0,     0,
       0,     0,     0,     0,  2607,  2213,  2608,     0,     0,     0,
       0,     0,     0,     0,  2610,    10,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    11,     0,     0,     0,     0,  3383,
       0,     0,     0,     0,  2607,     0,  2608,     0,     0,     0,
       0,     0,     0,     0,  2610,     0,     0,     0,    12,     0,
       0,     0,     0,     0,     0,     0,    13,    14,    15,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    16,
      17,     0,     0,     0,     0,     0,  2616,     0,     0,     0,
       0,     0,    18,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    19,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2295,  2297,
    2299,     0,     0,     0,    20,  2641,  2616,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    21,
       0,    22,  2617,  2618,  2619,     0,    23,   824,     0,  2620,
      24,     0,     0,     0,     0,     0,     0,     0,     0,  2334,
       0,     0,     0,     0,     0,  2621,     0,     0,  2339,  2622,
    2340,     0,     0,     0,     0,     0,    25,     0,    26,     0,
       0,     0,  2617,  2618,  2619,     0,     0,     0,  2623,  2620,
       0,     0,     0,     0,    27,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2621,  2625,     0,     0,  2622,
       0,     0,    28,     0,   824,     0,    29,     0,   824,     0,
       0,     0,     0,   824,   824,     0,     0,     0,  2623,     0,
       0,     0,   824,     0,   824,     0,   824,   824,   824,   824,
       0,     0,   824,     0,     0,     0,  2625,     0,     0,     0,
       0,     0,   824,     0,   824,   824,     0,   824,   824,   824,
     824,     0,   824,     0,  2975,   824,     0,     0,     0,     0,
       0,  2420,     0,     0,   824,     0,     0,     0,     0,     0,
       0,   824,     0,   824,     0,   824,   824,     0,   824,   824,
       0,     0,     0,   824,   824,   824,     0,     0,     0,   824,
     824,   824,     0,   824,     0,   824,     0,   824,     0,   824,
       0,   824,    30,     0,     0,     0,   824,     0,     0,     0,
       0,     0,     0,     0,  2481,     0,     0,     0,     0,    31,
       0,    32,     0,     0,     0,   824,     0,     0,     0,     0,
       0,     0,   824,     0,    33,   824,     0,     0,     0,     0,
       0,   824,     0,     0,   824,    34,     0,     0,   824,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,     0,     0,
      36,     0,    37,     0,     0,    38,     0,     0,    39,    40,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    41,
       0,     0,    42,     0,     0,     0,     0,     0,     0,     0,
      43,     0,     0,     0,     0,     0,    44,     0,     0,     0,
       0,     0,   824,     0,    45,     0,     0,     0,     0,    46,
      47,    48,     0,     0,     0,     0,     0,     0,     0,  3720,
    3721,     0,     0,     0,     0,  3722,     0,  3723,     0,  3724,
    3725,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    49,     0,     0,     0,     0,  3539,     0,    50,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,  2651,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    51,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3726,     0,    52,  3727,     0,     0,    53,
       0,     0,    54,     0,  3728,     0,     0,     0,    55,     0,
       0,     0,     0,     0,  2641,     0,     0,     0,     0,     0,
       0,     0,  3729,     0,     0,     0,     0,  2994,     0,     0,
       0,  2713,     0,     0,     0,  2715,     0,     0,    56,  3730,
    2717,  2718,     0,     0,    57,  2994,  2994,     0,     0,  1658,
       0,  2734,     0,  1658,    58,  2737,  2738,     0,     0,     0,
       0,     0,     0,     0,     0,  3731,     0,  3732,     0,  2745,
       0,  2746,     0,     0,  2748,  2749,  2750,  2751,     0,  2752,
    3733,  3734,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2756,     0,     0,     0,     0,     0,     0,  2757,     0,
    2758,     0,  2759,  2760,     0,  2761,     0,  2641,     0,     0,
    2764,  2765,  2766,     0,     0,     0,  2768,  2769,  2770,     0,
    2771,     0,  2773,     0,  2775,  3735,  2777,     0,  2778,     0,
       0,     0,     0,  2779,     0,     1,     0,     2,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2799,     0,  3736,  2994,  2994,     0,     4,     0,
       0,     0,     0,  3737,  3738,     0,  3739,     0,  2809,     0,
       0,  2812,     5,     6,     0,     0,     0,     0,     0,     0,
       7,     0,     0,     0,     0,     8,     9,     0,     0,     0,
       0,   824,     0,     0,     0,   824,     0,     0,     0,     0,
    3740,  3741,  3742,     0,     0,     0,    10,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3743,
    3744,  3745,   824,   824,     0,    11,     0,  3746,     0,     0,
    3747,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   824,     0,     0,     0,     0,  3748,  3749,    12,
       0,   824,     0,   824,     0,   824,     0,    13,    14,    15,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      16,    17,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   824,  3750,  3751,     0,     0,   824,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    19,     0,
       0,     0,     0,     0,     0,   961,     0,     0,  3752,     0,
    1980,     0,     0,     0,     0,    20,     0,   962,   824,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   899,   963,
      21,     0,    22,     0,     0,     0,     0,    23,     0,     0,
       0,    24,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   964,   945,     0,     0,     0,     0,     0,
       0,   965,     0,     0,  3753,     0,   966,    25,  3754,    26,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3755,     0,     0,    27,     0,     0,     0,     0,
       0,     0,   967,   824,   968,     0,   969,     0,     0,     0,
       0,     0,     0,    28,     0,     0,     0,    29,   970,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    14,
      15,     0,     0,     0,     0,     0,     0,     0,     0,  3756,
       0,     0,  3757,     0,   824,  3758,  3759,  3760,  3761,     0,
       0,     0,     0,     0,     0, -1895,   971,     0,     0,  2641,
       0,   972,     0,     0,   973,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3762,
    3763,     0,   974,     0,   975,     0,     0,     0,     0,     0,
       0,     0,   976,    30,   977,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3764,     0,     0,     0,
      31,     0,    32,     0,     0,     0,     0,     0,     0,     0,
     978,   979,   980,     0,     0,    33,     0,     0,  3153,     0,
       0,     0,  3155,     0,     0,     0,    34,     0,     0,     0,
    2641,     0,     0,   981,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,   824,     0,     0,     0,    35,  3182,
    3183,    36,     0,    37,     0,   982,    38,     0,     0,    39,
      40,     0,     0,     0,     0,     0,     0,     0,     0,  3203,
      41,     0,     0,    42,     0,     0,     0,     0,  3213,     0,
    3215,    43,  3217,     0,     0,   983,     0,    44,     0,     0,
       0,     0,  2994,     0,     0,    45,     0,     0,     0,     0,
      46,    47,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   824,     0,     0,     0,     0,
       0,  2579,     0,  2580,     0,     0,     0,     0,     0,     0,
       0,     0,    49,     0,     0,     0,     0,     0,     0,    50,
       0,     0,     0,     0,     0,  3275,     0,   824,   824,     0,
     824,     0,     0,   984,     0,     0,     0,     0,  2582,   824,
       0,     0,     0,     0,   824,     0,     0,   824,     0,   824,
     824,     0,     0,     0,     0,     0,     0,  2585,     0,   985,
       0,     0,     0,     0,    51,  2586,     0,     0,     0,     0,
     986,   987,     0,     0,   988,   989,    52,     0,     0,     0,
      53,     0,   824,    54,     0,     0,     0,     0,     0,    55,
       0,  3471,  2588,     0,     0,   990,     0,  2576,     0,  2577,
    1980,     0,     0,     0,     0,     0,  1565,     0,     0,  2589,
       0,     0,  2579,   824,  2580,     0,     0,     0,     0,    56,
       0,     0,     0,     0,     0,    57,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    58,     0,   824,  2594,     0,
       0,     0,     0,   991,  2581,     0,     0,     0,     0,  2582,
       0,  3357,     0,     0,     0,     0,   992,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2585,     0,
       0,     0,     0,     0,     0,     0,  2586,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2587, -2502,     0,     0,
       0,   993,     0,   824,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2588,     0,   273,     0,   275,     0,   994,
     995,     0,     0,  2598,     0,     0,     0,  1565,     0,     0,
    2589,  2599,  2641,     0,     0,     0,     0,     0,  2590,     0,
       0,     0,     0,     0,     0,  3472,  2600,     0,     0,     0,
       0,     0,     0,  2593,     0,     0,     0,     0,     0,  2594,
       0,     0,     0,     0,     0,     0,     0,     0,   996,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2502,
    3490,  3491,     0,     0,     0,     0,     0,   997,     0,     0,
    2596,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2602,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2603,     0,     0,     0,   273,     0,   275,     0,
       0,     0,     0,     0,  2598,     0,     0,     0,     0,     0,
       0,     0,  2599,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3522,     0,     0,     0,     0,  2600,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2607,     0,
    2608,  2601,     0,     0,  3561,  3562,     0,     0,  2610,     0,
       0,     0,     0,     0,     0,     0,  3569,     0,     0,     0,
       0,  3571,     0,     0,  3572,     0,  3573,  3574,     0,     0,
       0,     0,     0,     0,     0,  2602,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2603,     0,     0,     0,  2604,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2616,     0,     0,     0,     0,     0,     0,     0,   824,     0,
    3600,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2606,     0,     0,     0,     0,     0,     0,  2607,
       0,  2608,     0,     0,  3600,     0,     0,     0,     0,  2610,
       0,     0,     0,     0,   824,     0,     0,     0,     0,     0,
       0,     0,   824,     0,     0,     0,  2617,  2618,  2619,     0,
       0,     0,     0,  2620,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   824,     0,     0,     0,     0,     0,  2621,
       0,     0,     0,  2622,     0,  2613,     0,     0,     0,     0,
    3600,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2623,     0,     0,     0,     0,     0,     0,     0,
       0,  2616,     0,     0,     0,     0,     0,     0,     0,     0,
    2625,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3981,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2617,  2618,  2619,
       0,     0,     0,     0,  2620,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2621,     0,     0,     0,  2622,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   824,     0,     0,
       0,   824,     0,  2623,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2625,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   824,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     824,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2641,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3600,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3981,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4177,     0,     0,     0,     0,     0,
       0,  3885,     0,     0,     0,     0,     0,     0,     0,  3357,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3913,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   824,     0,     0,     0,     0,     0,     0,     0,
     824,     0,     0,     0,     0,     0,   824,     0,   824,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   824,     0,     0,
       0,     0,     0,  4177,  4177,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3357,     0,     0,     0,  4020,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4334,     0,     0,     0,
    4334,  4334,     0,     0,     0,     0,     0,   824,     0,     0,
       0,     0,     0,  3600,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3357,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   824,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   824,     0,   824,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   824,     0,
    4177,  4177,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4334,
       0,     0,     0,     0,     0,     0,     0,     0,  4334,     0,
       0,     0,  4334,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4334,     0,     0,  4239,     0,     0,
       0,     0,     0,  4244,     0,  4246,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   824,     0,  4177,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4177,   824,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4551,     0,     0,     0,     0,     0,     0,   824,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4296,     0,     0,     0,     0,     0,
       0,  4177,     0,     0,     0,     0,     0,  4334,     0,  4334,
    4334,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   824,  4177,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4177,  4177,     0,
       0,     0,     0,     0,  3357,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     824,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3357,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4177,     0,     0,     0,     0,     0,
       0,   824,     0,     0,  4177,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4410,     0,  4411,     0,     0,     0,   824,
       0,     0,     0,     0,     0,  4419,  4177,     0,  4177,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     824,     0,     0,   824,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4177,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4177,     0,  4177,     0,  4177,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4177,     0,     0,     0,     0,     0,     0,  4177,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4177,  4177,     0,     0,     0,     0,   824,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4177,
    4177,     0,     0,     0,  4177,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4531,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4536,     0,     0,     0,     0,     0,     0,   824,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3600,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4604,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4658,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4692,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4709,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   142,     0,   143,   689,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   690,
       0,   152,   153,   154,   155,   156,   157,   691,   159,     0,
     160,     0,     0,   692,   161,   693,   694,   695,   162,   696,
       0,   163,   164,   165,  1762,   166,  4761,   167,   168,     0,
       0,   169,   697,   698,   170,   171,     0,   172,   699,   700,
     174,   175,     0,   176,   177,   178,   179,   180,   701,   182,
       0,   702,   184,   703,   704,   705,   706,   707,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   708,   204,  3600,   205,   709,   710,
     206,     0,     0,   207,   711,   208,   712,   713,   209,     0,
     210,   714,   715,     0,   211,   212,   213,   716,   717,   718,
       0,     0,     0,     0,   719,   216,   720,     0,     0,   721,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   722,     0,   244,   245,   246,
     247,   723,   724,   248,   249,     0,   250,   251,   252,   725,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   726,   260,   727,   262,   263,     0,   264,
       0,   728,     0,   265,   266,   267,     0,   268,   729,   730,
       0,   269,   270,     0,     0,     0,   731,   272,   273,   274,
     275,   732,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,   733,   281,   282,   734,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   735,     0,  1763,   292,     0,   736,
     293,   294,     0,     0,     0,     0,     0,   737,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,   738,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   739,   321,   322,   323,   324,   740,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     741,   332,     0,     0,   742,   334,   743,   335,     0,   336,
     744,   745,   746,   747,   748,   341,   342,   343,   344,   345,
     346,     0,   749,   347,   348,     0,     0,   349,   350,   351,
     352,   750,   751,   752,   353,   354,     0,   753,   754,   355,
       0,   356,   357,   755,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,   756,   368,     0,   369,     0,   370,
     371,   757,   373,   374,   375,   376,   758,   759,   379,   760,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   761,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,   762,   763,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   764,     0,   765,   416,   417,
     418,   419,   420,   421,   766,   767,   424,   425,   426,   427,
       0,   768,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,   769,   770,   455,   456,     0,   457,   458,
     771,   460,   461,   462,   772,   773,   463,   464,   465,   466,
     774,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,   775,   474,   475,     0,   776,   777,   778,   779,     0,
       0,     0,     0,  1764,   480,   481,   482,     0,   780,   781,
     782,   484,   485,   486,   783,   487,   488,   784,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   785,   497,   498,     0,     0,   786,   787,   788,
     789,   499,     0,     0,   500,   790,     0,   791,   501,   502,
     503,   504,   505,   792,   793,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   794,
       0,     0,     0,     0,   795,   796,     0,     0,     0,     0,
     797,   798,     0,     0,   799,   800,     0,     0,   801,   802,
     142,     0,   143,   689,   145,   146,   147,   148,  1976,     0,
     149,     0,     0,     0,   150,     0,     0,   690,     0,   152,
     153,   154,   155,   156,   157,   691,   159,     0,   160,     0,
       0,  1977,   161,   693,   694,   695,   162,   696,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
     697,   698,   170,   171,     0,   172,   699,   700,   174,   175,
       0,   176,   177,   178,   179,   180,   701,   182,     0,   702,
     184,   703,   704,   705,   706,   707,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   708,   204,     0,   205,   709,   710,   206,     0,
       0,   207,   711,   208,   712,   713,   209,     0,   210,   714,
     715,     0,   211,   212,   213,   716,   717,   718,     0,     0,
       0,     0,   719,   216,   720,     0,     0,  1978,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   722,     0,   244,   245,   246,   247,   723,
     724,   248,   249,     0,   250,   251,   252,   725,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   726,   260,   727,   262,   263,     0,   264,     0,   728,
       0,   265,   266,   267,     0,   268,   729,   730,     0,   269,
     270,     0,     0,     0,   731,   272,   273,   274,   275,   732,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,   733,   281,   282,   734,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   735,     0,     0,   292,     0,   736,   293,   294,
       0,     0,     0,     0,     0,   737,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   738,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   739,   321,   322,   323,   324,   740,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   741,   332,
       0,     0,   742,   334,   743,   335,     0,   336,   744,   745,
     746,   747,   748,   341,   342,   343,   344,   345,   346,     0,
     749,   347,   348,     0,     0,   349,   350,   351,   352,   750,
     751,   752,   353,   354,     0,   753,   754,   355,     0,   356,
     357,   755,  1979,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,   756,   368,     0,   369,     0,   370,   371,   757,
     373,   374,   375,   376,   758,   759,   379,   760,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   761,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,   762,
     763,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   764,     0,   765,   416,   417,   418,   419,
     420,   421,   766,   767,   424,   425,   426,   427,     0,   768,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,   769,   770,   455,   456,     0,   457,   458,   771,   460,
     461,   462,   772,   773,   463,   464,   465,   466,   774,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   775,
     474,   475,     0,   776,   777,   778,   779,     0,     0,     0,
       0,     0,   480,   481,   482,     0,   780,   781,   782,   484,
     485,   486,   783,   487,   488,   784,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     785,   497,   498,     0,     0,   786,   787,   788,   789,   499,
       0,     0,   500,   790,     0,   791,   501,   502,   503,   504,
     505,   792,   793,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   794,     0,     0,
       0,     0,   795,   796,     0,     0,     0,     0,   797,   798,
       0,     0,   799,   800,     0,     0,   801,   802,   142,     0,
     143,   689,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   690,     0,   152,   153,   154,
     155,   156,   157,   691,   159,     0,   160,     0,     0,   692,
     161,   693,   694,   695,   162,   696,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,   697,   698,
     170,   171,     0,   172,   699,   700,   174,   175,     0,   176,
     177,   178,   179,   180,   701,   182,     0,   702,   184,   703,
     704,   705,   706,   707,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     708,   204,     0,   205,   709,   710,   206,     0,     0,   207,
     711,   208,   712,   713,   209,     0,   210,   714,   715,     0,
     211,   212,   213,   716,   717,   718,     0,     0,     0,     0,
     719,   216,   720,     0,     0,   721,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   722,     0,   244,   245,   246,   247,   723,   724,   248,
     249,     0,   250,   251,   252,   725,     0,   253,     0,     0,
       0,   254,  2294,   255,     0,   256,     0,   257,   258,   726,
     260,   727,   262,   263,     0,   264,     0,   728,     0,   265,
     266,   267,     0,   268,   729,   730,     0,   269,   270,     0,
       0,     0,   731,   272,   273,   274,   275,   732,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,   733,
     281,   282,   734,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     735,     0,     0,   292,     0,   736,   293,   294,     0,     0,
       0,     0,     0,   737,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,   738,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
     739,   321,   322,   323,   324,   740,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   741,   332,     0,     0,
     742,   334,   743,   335,     0,   336,   744,   745,   746,   747,
     748,   341,   342,   343,   344,   345,   346,     0,   749,   347,
     348,     0,     0,   349,   350,   351,   352,   750,   751,   752,
     353,   354,     0,   753,   754,   355,     0,   356,   357,   755,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
     756,   368,     0,   369,     0,   370,   371,   757,   373,   374,
     375,   376,   758,   759,   379,   760,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   761,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,   762,   763,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   764,     0,   765,   416,   417,   418,   419,   420,   421,
     766,   767,   424,   425,   426,   427,     0,   768,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,   769,
     770,   455,   456,     0,   457,   458,   771,   460,   461,   462,
     772,   773,   463,   464,   465,   466,   774,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   775,   474,   475,
       0,   776,   777,   778,   779,     0,     0,     0,     0,     0,
     480,   481,   482,     0,   780,   781,   782,   484,   485,   486,
     783,   487,   488,   784,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   785,   497,
     498,     0,     0,   786,   787,   788,   789,   499,     0,     0,
     500,   790,     0,   791,   501,   502,   503,   504,   505,   792,
     793,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   794,     0,     0,     0,     0,
     795,   796,     0,     0,     0,     0,   797,   798,     0,     0,
     799,   800,     0,     0,   801,   802,   142,     0,   143,   689,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   690,     0,   152,   153,   154,   155,   156,
     157,   691,   159,     0,   160,     0,     0,   692,   161,   693,
     694,   695,   162,   696,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,   697,   698,   170,   171,
       0,   172,   699,   700,   174,   175,     0,   176,   177,   178,
     179,   180,   701,   182,     0,   702,   184,   703,   704,   705,
     706,   707,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   708,   204,
       0,   205,   709,   710,   206,     0,     0,   207,   711,   208,
     712,   713,   209,     0,   210,   714,   715,     0,   211,   212,
     213,   716,   717,   718,     0,     0,     0,     0,   719,   216,
     720,     0,     0,   721,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   722,
       0,   244,   245,   246,   247,   723,   724,   248,   249,     0,
     250,   251,   252,   725,     0,   253,     0,     0,     0,   254,
    2296,   255,     0,   256,     0,   257,   258,   726,   260,   727,
     262,   263,     0,   264,     0,   728,     0,   265,   266,   267,
       0,   268,   729,   730,     0,   269,   270,     0,     0,     0,
     731,   272,   273,   274,   275,   732,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,   733,   281,   282,
     734,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   735,     0,
       0,   292,     0,   736,   293,   294,     0,     0,     0,     0,
       0,   737,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,   738,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   739,   321,
     322,   323,   324,   740,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   741,   332,     0,     0,   742,   334,
     743,   335,     0,   336,   744,   745,   746,   747,   748,   341,
     342,   343,   344,   345,   346,     0,   749,   347,   348,     0,
       0,   349,   350,   351,   352,   750,   751,   752,   353,   354,
       0,   753,   754,   355,     0,   356,   357,   755,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,   756,   368,
       0,   369,     0,   370,   371,   757,   373,   374,   375,   376,
     758,   759,   379,   760,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   761,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,   762,   763,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   764,
       0,   765,   416,   417,   418,   419,   420,   421,   766,   767,
     424,   425,   426,   427,     0,   768,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,   769,   770,   455,
     456,     0,   457,   458,   771,   460,   461,   462,   772,   773,
     463,   464,   465,   466,   774,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,   775,   474,   475,     0,   776,
     777,   778,   779,     0,     0,     0,     0,     0,   480,   481,
     482,     0,   780,   781,   782,   484,   485,   486,   783,   487,
     488,   784,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   785,   497,   498,     0,
       0,   786,   787,   788,   789,   499,     0,     0,   500,   790,
       0,   791,   501,   502,   503,   504,   505,   792,   793,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   794,     0,     0,     0,     0,   795,   796,
       0,     0,     0,     0,   797,   798,     0,     0,   799,   800,
       0,     0,   801,   802,   142,     0,   143,   689,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   690,     0,   152,   153,   154,   155,   156,   157,   691,
     159,     0,   160,     0,     0,   692,   161,   693,   694,   695,
     162,   696,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,   697,   698,   170,   171,     0,   172,
     699,   700,   174,   175,     0,   176,   177,   178,   179,   180,
     701,   182,     0,   702,   184,   703,   704,   705,   706,   707,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   708,   204,     0,   205,
     709,   710,   206,     0,     0,   207,   711,   208,   712,   713,
     209,     0,   210,   714,   715,     0,   211,   212,   213,   716,
     717,   718,     0,     0,     0,     0,   719,   216,   720,     0,
       0,   721,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   722,     0,   244,
     245,   246,   247,   723,   724,   248,   249,     0,   250,   251,
     252,   725,     0,   253,     0,     0,     0,   254,  2298,   255,
       0,   256,     0,   257,   258,   726,   260,   727,   262,   263,
       0,   264,     0,   728,     0,   265,   266,   267,     0,   268,
     729,   730,     0,   269,   270,     0,     0,     0,   731,   272,
     273,   274,   275,   732,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,   733,   281,   282,   734,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   735,     0,     0,   292,
       0,   736,   293,   294,     0,     0,     0,     0,     0,   737,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
     738,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   739,   321,   322,   323,
     324,   740,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   741,   332,     0,     0,   742,   334,   743,   335,
       0,   336,   744,   745,   746,   747,   748,   341,   342,   343,
     344,   345,   346,     0,   749,   347,   348,     0,     0,   349,
     350,   351,   352,   750,   751,   752,   353,   354,     0,   753,
     754,   355,     0,   356,   357,   755,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,   756,   368,     0,   369,
       0,   370,   371,   757,   373,   374,   375,   376,   758,   759,
     379,   760,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   761,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,   762,   763,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   764,     0,   765,
     416,   417,   418,   419,   420,   421,   766,   767,   424,   425,
     426,   427,     0,   768,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,   769,   770,   455,   456,     0,
     457,   458,   771,   460,   461,   462,   772,   773,   463,   464,
     465,   466,   774,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   775,   474,   475,     0,   776,   777,   778,
     779,     0,     0,     0,     0,     0,   480,   481,   482,     0,
     780,   781,   782,   484,   485,   486,   783,   487,   488,   784,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   785,   497,   498,     0,     0,   786,
     787,   788,   789,   499,     0,     0,   500,   790,     0,   791,
     501,   502,   503,   504,   505,   792,   793,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   794,     0,     0,     0,     0,   795,   796,     0,     0,
       0,     0,   797,   798,     0,     0,   799,   800,     0,     0,
     801,   802,   142,     0,   143,   689,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   690,
       0,   152,   153,   154,   155,   156,   157,   691,   159,     0,
     160,     0,     0,   692,   161,   693,   694,   695,   162,   696,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,   697,   698,   170,   171,     0,   172,   699,   700,
     174,   175,     0,   176,   177,   178,   179,   180,   701,   182,
       0,   702,   184,   703,   704,   705,   706,   707,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   708,   204,     0,   205,   709,   710,
     206,     0,     0,   207,   711,   208,   712,   713,   209,     0,
     210,   714,   715,     0,   211,   212,   213,   716,   717,   718,
       0,     0,     0,     0,   719,   216,   720,     0,     0,   721,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   722,     0,   244,   245,   246,
     247,   723,   724,   248,   249,     0,   250,   251,   252,   725,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   726,   260,   727,   262,   263,     0,   264,
       0,   728,     0,   265,   266,   267,     0,   268,   729,   730,
       0,   269,   270,     0,     0,     0,   731,   272,   273,   274,
     275,   732,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,   733,   281,   282,   734,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   735,     0,     0,   292,     0,   736,
     293,   294,     0,     0,     0,     0,     0,   737,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,   738,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   739,   321,   322,   323,   324,   740,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     741,   332,     0,     0,   742,   334,   743,   335,     0,   336,
     744,   745,   746,   747,   748,   341,   342,   343,   344,   345,
     346,     0,   749,   347,   348,     0,     0,   349,   350,   351,
     352,   750,   751,   752,   353,   354,     0,   753,   754,   355,
       0,   356,   357,   755,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,   756,   368,     0,   369,     0,   370,
     371,   757,   373,   374,   375,   376,   758,   759,   379,   760,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   761,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,   762,   763,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   764,     0,   765,   416,   417,
     418,   419,   420,   421,   766,   767,   424,   425,   426,   427,
       0,   768,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,   769,   770,   455,   456,     0,   457,   458,
     771,   460,   461,   462,   772,   773,   463,   464,   465,   466,
     774,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,   775,   474,   475,     0,   776,   777,   778,   779,     0,
       0,     0,     0,     0,   480,   481,   482,     0,   780,   781,
     782,   484,   485,   486,   783,   487,   488,   784,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   785,   497,   498,     0,     0,   786,   787,   788,
     789,   499,     0,     0,   500,   790,     0,   791,   501,   502,
     503,   504,   505,   792,   793,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   794,
       0,     0,     0,     0,   795,   796,     0,     0,     0,     0,
     797,   798,     0,     0,   799,   800,     0,     0,   801,   802,
     142,     0,   143,   689,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   690,     0,   152,
     153,   154,   155,   156,   157,   691,   159,     0,   160,     0,
       0,   692,   161,   693,   694,   695,   162,   696,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
     697,   698,   170,   171,     0,   172,   699,   700,   174,   175,
       0,   176,   177,   178,   179,   180,   701,   182,     0,   702,
     184,   703,   704,   705,   706,   707,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   708,   204,     0,   205,   709,   710,   206,     0,
       0,   207,   711,   208,   712,   713,   209,     0,   210,   714,
     715,     0,   211,   212,   213,   716,   717,   718,     0,     0,
       0,     0,   719,   216,   720,     0,     0,   721,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   722,     0,   244,   245,   246,   247,   723,
     724,   248,   249,     0,   250,   251,   252,   725,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   726,   260,   727,   262,   263,     0,   264,     0,   728,
       0,   265,   266,   267,     0,   268,   729,   730,     0,   269,
     270,     0,     0,     0,   731,   272,   273,   274,   275,   732,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,   733,   281,   282,   734,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   735,     0,     0,   292,     0,   736,   293,   294,
       0,     0,     0,     0,     0,   737,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   738,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   739,   321,   322,   323,   324,   740,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   741,   332,
       0,     0,   742,   334,   743,   335,     0,   336,   744,   745,
     746,   747,   748,   341,   342,   343,   344,   345,   346,     0,
     749,   347,   348,     0,     0,   349,   350,   351,   352,   750,
     751,   752,   353,   354,     0,   753,   754,   355,     0,   356,
     357,   755,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,   756,   368,     0,   369,     0,   370,   371,   757,
     373,   374,   375,   376,   758,   759,   379,   760,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   761,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,   762,
     763,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   764,     0,   765,   416,   417,   418,   419,
     420,   421,   766,   767,   424,   425,   426,   427,     0,   768,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,   769,   770,   455,   456,     0,   457,   458,   771,   460,
     461,   462,   772,   773,   463,   464,   465,   466,   774,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   775,
     474,   475,     0,   776,   777,   778,   779,     0,     0,     0,
       0,     0,   480,   481,   482,     0,   780,   781,   782,   484,
     485,   486,   783,   487,   488,   784,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     785,   497,   498,     0,     0,   786,   787,   788,   789,   499,
       0,     0,   500,   790,     0,   791,   501,   502,   503,   504,
     505,   792,   793,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   794,     0,     0,
       0,     0,   795,   796,     0,     0,     0,     0,   797,  1166,
       0,     0,   799,   800,     0,     0,   801,   802,   142,     0,
     143,   689,   145,   146,   147,   148,  1797,     0,   149,     0,
       0,     0,  1798,     0,     0,   690,     0,   152,   153,   154,
     155,   156,   157,   691,   159,     0,   160,     0,     0,   692,
     161,   693,   694,   695,   162,   696,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,   697,   698,
     170,   171,     0,   172,   699,   700,   174,   175,     0,   176,
     177,   178,   179,   180,   701,   182,     0,   702,   184,   703,
     704,   705,   706,   707,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     708,   204,     0,   205,   709,   710,   206,     0,     0,   207,
     711,   208,   712,   713,   209,     0,   210,   714,   715,     0,
     211,   212,   213,   716,   717,   718,     0,     0,     0,     0,
     719,   216,   720,     0,     0,   721,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   722,     0,   244,   245,   246,   247,   723,   724,   248,
     249,     0,   250,   251,   252,   725,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   726,
     260,   727,   262,   263,     0,   264,     0,   728,     0,   265,
     266,   267,     0,   268,   729,   730,     0,   269,   270,     0,
       0,     0,   731,   272,   273,   274,   275,   732,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,   733,
     281,   282,   734,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     735,     0,     0,   292,     0,   736,   293,   294,     0,     0,
       0,     0,     0,   737,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,   738,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
     739,   321,   322,   323,   324,   740,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   741,   332,     0,     0,
     742,   334,   743,   335,     0,   336,   744,   745,   746,   747,
     748,   341,   342,   343,   344,   345,   346,     0,   749,   347,
     348,     0,     0,   349,   350,   351,   352,   750,     0,   752,
     353,   354,     0,   753,   754,   355,     0,   356,   357,   755,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
     756,   368,     0,   369,     0,   370,   371,   757,   373,   374,
     375,   376,   758,   759,   379,   760,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   761,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,   762,   763,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   764,     0,   765,   416,   417,   418,   419,   420,   421,
     766,   767,   424,   425,   426,   427,     0,   768,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,   769,
     770,   455,   456,     0,   457,   458,   771,   460,   461,   462,
     772,   773,   463,   464,   465,   466,   774,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   775,   474,   475,
       0,   776,   777,   778,   779,     0,     0,     0,     0,     0,
     480,   481,   482,     0,   780,   781,   782,   484,   485,   486,
     783,   487,   488,   784,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   785,   497,
     498,     0,     0,   786,   787,   788,   789,   499,     0,     0,
     500,   790,     0,   791,   501,   502,   503,   504,   505,   792,
     793,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   794,     0,     0,     0,     0,
     795,   796,     0,     0,     0,     0,   797,   798,     0,     0,
     799,   800,     0,     0,   801,   802,   142,     0,   143,   689,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   690,     0,   152,   153,   154,   155,   156,
     157,   691,   159,     0,   160,     0,     0,   692,   161,   693,
     694,   695,   162,   696,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,   697,   698,   170,   171,
       0,   172,   699,   700,   174,   175,     0,   176,   177,   178,
     179,   180,   701,   182,     0,   702,   184,   703,   704,   705,
     706,   707,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   708,   204,
       0,   205,   709,   710,   206,     0,     0,   207,   711,   208,
     712,   713,   209,     0,   210,   714,   715,     0,   211,   212,
     213,   716,   717,   718,     0,     0,     0,     0,   719,   216,
     720,     0,     0,   721,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   722,
       0,   244,   245,   246,   247,   723,   724,   248,   249,     0,
     250,   251,   252,   725,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   726,   260,   727,
     262,   263,     0,   264,     0,   728,     0,   265,   266,   267,
       0,   268,   729,   730,     0,   269,   270,     0,     0,     0,
     731,   272,   273,   274,   275,   732,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,   733,   281,   282,
     734,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   735,     0,
       0,   292,     0,   736,   293,   294,     0,     0,     0,     0,
       0,   737,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,   738,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   739,   321,
     322,   323,   324,   740,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   741,   332,     0,     0,   742,   334,
     743,   335,     0,   336,   744,   745,   746,   747,   748,   341,
     342,   343,   344,   345,   346,     0,   749,   347,   348,     0,
       0,   349,   350,   351,   352,   750,   751,   752,   353,   354,
       0,   753,   754,   355,     0,   356,   357,   755,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,   756,   368,
       0,   369,     0,   370,   371,   757,   373,   374,   375,   376,
     758,   759,   379,   760,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   761,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,   762,   763,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   764,
       0,   765,   416,   417,   418,   419,   420,   421,   766,   767,
     424,   425,   426,   427,     0,   768,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,   769,   770,   455,
     456,     0,   457,   458,   771,   460,   461,   462,   772,   773,
     463,   464,   465,   466,   774,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,   775,   474,   475,     0,   776,
     777,   778,   779,     0,     0,     0,     0,     0,   480,   481,
     482,     0,   780,   781,   782,   484,   485,   486,   783,   487,
     488,   784,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,  1894,   497,   498,     0,
       0,   786,   787,   788,   789,   499,     0,     0,   500,   790,
       0,   791,   501,   502,   503,   504,   505,   792,   793,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   794,     0,     0,     0,     0,   795,   796,
       0,     0,     0,     0,   797,   798,     0,     0,   799,   800,
       0,     0,   801,   802,   142,     0,   143,   689,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   690,     0,   152,   153,   154,   155,   156,   157,   691,
     159,     0,   160,     0,     0,   692,   161,   693,   694,   695,
     162,   696,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,   697,   698,   170,   171,     0,   172,
     699,   700,   174,   175,     0,   176,   177,   178,   179,   180,
     701,   182,     0,   702,   184,   703,   704,   705,   706,   707,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   708,   204,     0,   205,
     709,   710,   206,     0,     0,   207,   711,   208,   712,   713,
     209,     0,   210,   714,   715,     0,   211,   212,   213,   716,
     717,   718,     0,     0,     0,     0,   719,   216,   720,     0,
       0,   721,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   722,     0,   244,
     245,   246,   247,   723,   724,   248,   249,     0,   250,   251,
     252,   725,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   726,   260,   727,   262,   263,
       0,   264,     0,   728,     0,   265,   266,   267,     0,   268,
     729,   730,     0,   269,   270,     0,     0,     0,   731,   272,
     273,   274,   275,   732,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,   733,   281,   282,  2712,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   735,     0,     0,   292,
       0,   736,   293,   294,     0,     0,     0,     0,     0,   737,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
     738,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   739,   321,   322,   323,
     324,   740,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   741,   332,     0,     0,   742,   334,   743,   335,
       0,   336,   744,   745,   746,   747,   748,   341,   342,   343,
     344,   345,   346,     0,   749,   347,   348,     0,     0,   349,
     350,   351,   352,   750,   751,   752,   353,   354,     0,   753,
     754,   355,     0,   356,   357,   755,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,   756,   368,     0,   369,
       0,   370,   371,   757,   373,   374,   375,   376,   758,   759,
     379,   760,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   761,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,   762,   763,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   764,     0,   765,
     416,   417,   418,   419,   420,   421,   766,   767,   424,   425,
     426,   427,     0,   768,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,   769,   770,   455,   456,     0,
     457,   458,   771,   460,   461,   462,   772,   773,   463,   464,
     465,   466,   774,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   775,   474,   475,     0,   776,   777,   778,
     779,     0,     0,     0,     0,     0,   480,   481,   482,     0,
     780,   781,   782,   484,   485,   486,   783,   487,   488,   784,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   785,   497,   498,     0,     0,   786,
     787,   788,   789,   499,     0,     0,   500,   790,     0,   791,
     501,   502,   503,   504,   505,   792,   793,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   794,     0,     0,     0,     0,   795,   796,     0,     0,
       0,     0,   797,   798,     0,     0,   799,   800,     0,     0,
     801,   802,   142,     0,   143,   689,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   690,
       0,   152,   153,   154,   155,   156,   157,   691,   159,     0,
     160,     0,     0,   692,   161,   693,   694,   695,   162,   696,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,   697,   698,   170,   171,     0,   172,   699,   700,
     174,   175,     0,   176,   177,   178,   179,   180,   701,   182,
       0,   702,   184,   703,   704,   705,   706,   707,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   708,   204,     0,   205,   709,   710,
     206,     0,     0,   207,   711,   208,   712,   713,   209,     0,
     210,   714,   715,     0,   211,   212,   213,   716,   717,   718,
       0,     0,     0,     0,   719,   216,   720,     0,     0,   721,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   722,     0,   244,   245,   246,
     247,   723,   724,   248,   249,     0,   250,   251,   252,   725,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   726,   260,   727,   262,   263,     0,   264,
       0,   728,     0,   265,   266,   267,     0,   268,   729,   730,
       0,   269,   270,     0,     0,     0,   731,   272,   273,   274,
     275,   732,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,   733,   281,   282,  2763,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   735,     0,     0,   292,     0,   736,
     293,   294,     0,     0,     0,     0,     0,   737,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,   738,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   739,   321,   322,   323,   324,   740,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     741,   332,     0,     0,   742,   334,   743,   335,     0,   336,
     744,   745,   746,   747,   748,   341,   342,   343,   344,   345,
     346,     0,   749,   347,   348,     0,     0,   349,   350,   351,
     352,   750,   751,   752,   353,   354,     0,   753,   754,   355,
       0,   356,   357,   755,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,   756,   368,     0,   369,     0,   370,
     371,   757,   373,   374,   375,   376,   758,   759,   379,   760,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   761,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,   762,   763,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   764,     0,   765,   416,   417,
     418,   419,   420,   421,   766,   767,   424,   425,   426,   427,
       0,   768,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,   769,   770,   455,   456,     0,   457,   458,
     771,   460,   461,   462,   772,   773,   463,   464,   465,   466,
     774,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,   775,   474,   475,     0,   776,   777,   778,   779,     0,
       0,     0,     0,     0,   480,   481,   482,     0,   780,   781,
     782,   484,   485,   486,   783,   487,   488,   784,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   785,   497,   498,     0,     0,   786,   787,   788,
     789,   499,     0,     0,   500,   790,     0,   791,   501,   502,
     503,   504,   505,   792,   793,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   794,
       0,     0,     0,     0,   795,   796,     0,     0,     0,     0,
     797,   798,     0,     0,   799,   800,     0,     0,   801,   802,
     142,     0,   143,   689,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   690,     0,   152,
     153,   154,   155,   156,   157,   691,   159,     0,   160,     0,
       0,   692,   161,   693,   694,   695,   162,   696,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
     697,   698,   170,   171,     0,   172,   699,   700,   174,   175,
       0,   176,   177,   178,   179,   180,   701,   182,     0,   702,
     184,   703,   704,   705,   706,   707,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   708,   204,     0,   205,   709,   710,   206,     0,
       0,   207,   711,   208,   712,   713,   209,     0,   210,   714,
     715,     0,   211,   212,   213,   716,   717,   718,     0,     0,
       0,     0,   719,   216,   720,     0,     0,  3599,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,   722,     0,   244,   245,   246,   247,   723,
     724,   248,   249,     0,   250,   251,   252,   725,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   726,   260,   727,   262,   263,     0,   264,     0,   728,
       0,   265,   266,   267,     0,   268,   729,   730,     0,   269,
     270,     0,     0,     0,   731,   272,   273,   274,   275,   732,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,   733,   281,   282,   734,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   735,     0,     0,   292,     0,   736,   293,   294,
       0,     0,     0,     0,     0,   737,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   738,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,   739,   321,   322,   323,   324,   740,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   741,   332,
       0,     0,   742,   334,   743,   335,     0,   336,   744,   745,
     746,   747,   748,   341,   342,   343,   344,   345,   346,     0,
     749,   347,   348,     0,     0,   349,   350,   351,   352,   750,
     751,   752,   353,   354,     0,   753,   754,   355,     0,   356,
     357,   755,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,   756,   368,     0,   369,     0,   370,   371,   757,
     373,   374,   375,   376,   758,   759,   379,   760,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   761,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,   762,
     763,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   764,     0,   765,   416,   417,   418,   419,
     420,   421,   766,   767,   424,   425,   426,   427,     0,   768,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,   769,   770,   455,   456,     0,   457,   458,   771,   460,
     461,   462,   772,   773,   463,   464,   465,   466,   774,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   775,
     474,   475,     0,   776,   777,   778,   779,     0,     0,     0,
       0,     0,   480,   481,   482,     0,   780,   781,   782,   484,
     485,   486,   783,   487,   488,   784,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     785,   497,   498,     0,     0,   786,   787,   788,   789,   499,
       0,     0,   500,   790,     0,   791,   501,   502,   503,   504,
     505,   792,   793,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   794,     0,     0,
       0,     0,   795,   796,     0,     0,     0,     0,   797,   798,
       0,     0,   799,   800,     0,     0,   801,   802,   142,     0,
     143,   689,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   690,     0,   152,   153,   154,
     155,   156,   157,   691,   159,     0,   160,     0,     0,   692,
     161,   693,   694,   695,   162,   696,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,   697,   698,
     170,   171,     0,   172,   699,   700,   174,   175,     0,   176,
     177,   178,   179,   180,   701,   182,     0,   702,   184,   703,
     704,   705,   706,   707,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     708,   204,     0,   205,   709,   710,   206,     0,     0,   207,
     711,   208,   712,   713,   209,     0,   210,   714,   715,     0,
     211,   212,   213,   716,   717,   718,     0,     0,     0,     0,
     719,   216,   720,     0,     0,   721,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,   722,     0,   244,   245,   246,   247,   723,   724,   248,
     249,     0,   250,   251,   252,   725,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   726,
     260,   727,   262,   263,     0,   264,     0,   728,     0,   265,
     266,   267,     0,   268,   729,   730,     0,   269,   270,     0,
       0,     0,   731,   272,   273,   274,   275,   732,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,   733,
     281,   282,   734,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     735,     0,     0,   292,     0,   736,   293,   294,     0,     0,
       0,     0,     0,   737,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,   738,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
     739,   321,   322,   323,   324,   740,   325,   326,  4625,     0,
       0,     0,   327,   328,   329,   330,   741,   332,     0,     0,
     742,   334,   743,   335,     0,   336,   744,   745,   746,   747,
     748,   341,   342,   343,   344,   345,   346,     0,   749,   347,
     348,     0,     0,   349,   350,   351,   352,   750,     0,   752,
     353,   354,     0,   753,   754,   355,     0,   356,   357,   755,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
     756,   368,     0,   369,     0,   370,   371,   757,   373,   374,
     375,   376,   758,   759,   379,   760,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   761,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,   762,   763,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   764,     0,   765,   416,   417,   418,   419,   420,   421,
     766,   767,   424,   425,   426,   427,     0,   768,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,   769,
     770,   455,   456,     0,   457,   458,   771,   460,   461,   462,
     772,   773,   463,   464,   465,   466,   774,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   775,   474,   475,
       0,   776,   777,   778,   779,     0,     0,     0,     0,     0,
     480,   481,   482,     0,   780,   781,   782,   484,   485,   486,
     783,   487,   488,   784,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   785,   497,
     498,     0,     0,   786,   787,   788,   789,   499,     0,     0,
     500,   790,     0,   791,   501,   502,   503,   504,   505,   792,
     793,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   794,     0,     0,     0,     0,
     795,   796,     0,     0,     0,     0,   797,   798,     0,     0,
     799,   800,     0,     0,   801,   802,   142,     0,   143,   689,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   690,     0,   152,   153,   154,   155,   156,
     157,   691,   159,     0,   160,     0,     0,   692,   161,   693,
     694,   695,   162,   696,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,   697,   698,   170,   171,
       0,   172,   699,   700,   174,   175,     0,   176,   177,   178,
     179,   180,   701,   182,     0,   702,   184,   703,   704,   705,
     706,   707,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   708,   204,
       0,   205,   709,   710,   206,     0,     0,   207,   711,   208,
     712,   713,   209,     0,   210,   714,   715,     0,   211,   212,
     213,   716,   717,   718,     0,     0,     0,     0,   719,   216,
     720,     0,     0,   721,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,   722,
       0,   244,   245,   246,   247,   723,   724,   248,   249,     0,
     250,   251,   252,   725,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   726,   260,   727,
     262,   263,     0,   264,     0,   728,     0,   265,   266,   267,
       0,   268,   729,   730,     0,   269,   270,     0,     0,     0,
     731,   272,   273,   274,   275,   732,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,   733,   281,   282,
     734,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   735,     0,
       0,   292,     0,   736,   293,   294,     0,     0,     0,     0,
       0,   737,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,   738,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,   739,   321,
     322,   323,   324,   740,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   741,   332,     0,     0,   742,   334,
     743,   335,     0,   336,   744,   745,   746,   747,   748,   341,
     342,   343,   344,   345,   346,     0,   749,   347,   348,     0,
       0,   349,   350,   351,   352,   750,     0,   752,   353,   354,
       0,   753,   754,   355,     0,   356,   357,   755,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,   756,   368,
       0,   369,     0,   370,   371,   757,   373,   374,   375,   376,
     758,   759,   379,   760,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   761,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,   762,   763,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   764,
       0,   765,   416,   417,   418,   419,   420,   421,   766,   767,
     424,   425,   426,   427,     0,   768,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,   769,   770,   455,
     456,     0,   457,   458,   771,   460,   461,   462,   772,   773,
     463,   464,   465,   466,   774,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,   775,   474,   475,     0,   776,
     777,   778,   779,     0,     0,     0,     0,     0,   480,   481,
     482,     0,   780,   781,   782,   484,   485,   486,   783,   487,
     488,   784,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   785,   497,   498,     0,
       0,   786,   787,   788,   789,   499,     0,     0,   500,   790,
       0,   791,   501,   502,   503,   504,   505,   792,   793,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   794,     0,     0,     0,     0,   795,   796,
       0,     0,     0,     0,   797,   798,     0,     0,   799,   800,
       0,     0,   801,   802,   142,     0,   143,   689,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   690,     0,   152,   153,   154,   155,   156,   157,   691,
     159,     0,   160,     0,     0,   692,   161,   693,   694,   695,
     162,   696,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,   697,   698,   170,   171,     0,   172,
     699,   700,   174,   175,     0,   176,   177,   178,   179,   180,
     701,   182,     0,   702,   184,   703,   704,   705,   706,   707,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   708,   204,     0,   205,
     709,   710,   206,     0,     0,   207,   711,   208,   712,   713,
     209,     0,   210,   714,   715,     0,   211,   212,   213,   716,
     717,   718,     0,     0,     0,     0,   719,   216,   720,     0,
       0,   721,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,   722,     0,   244,
     245,   246,   247,   723,   724,   248,   249,     0,   250,   251,
     252,   725,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   726,   260,   727,   262,   263,
       0,   264,     0,   728,     0,   265,   266,   267,     0,   268,
     729,   730,     0,   269,   270,     0,     0,     0,   731,   272,
     273,   274,   275,   732,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,   733,   281,   282,  1812,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   735,     0,     0,   292,
       0,   736,   293,   294,     0,     0,     0,     0,     0,   737,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
     738,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,   739,   321,   322,   323,
     324,   740,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   741,   332,     0,     0,   742,   334,   743,   335,
       0,   336,   744,   745,   746,   747,   748,   341,   342,   343,
     344,   345,   346,     0,   749,   347,   348,     0,     0,   349,
     350,   351,   352,   750,     0,   752,   353,   354,     0,   753,
     754,   355,     0,   356,   357,   755,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,   756,   368,     0,   369,
       0,   370,   371,   757,   373,   374,   375,   376,   758,   759,
     379,   760,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   761,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,   762,   763,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   764,     0,   765,
     416,   417,   418,   419,   420,   421,   766,   767,   424,   425,
     426,   427,     0,   768,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,   769,   770,   455,   456,     0,
     457,   458,   771,   460,   461,   462,   772,   773,   463,   464,
     465,   466,   774,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   775,   474,   475,     0,   776,   777,   778,
     779,     0,     0,     0,     0,     0,   480,   481,   482,     0,
     780,   781,   782,   484,   485,   486,   783,   487,   488,   784,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   785,   497,   498,     0,     0,   786,
     787,   788,   789,   499,     0,     0,   500,   790,     0,   791,
     501,   502,   503,   504,   505,   792,   793,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   794,     0,     0,     0,     0,   795,   796,     0,     0,
       0,     0,   797,   798,     0,     0,   799,   800,     0,     0,
     801,   802,   142,     0,   143,   689,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   690,
       0,   152,   153,   154,   155,   156,   157,   691,   159,     0,
     160,     0,     0,   692,   161,   693,   694,   695,   162,   696,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,   697,   698,   170,   171,     0,   172,   699,   700,
     174,   175,     0,   176,   177,   178,   179,   180,   701,   182,
       0,   702,   184,   703,   704,   705,   706,   707,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   708,   204,     0,   205,   709,   710,
     206,     0,     0,   207,   711,   208,   712,   713,   209,     0,
     210,   714,   715,     0,   211,   212,   213,   716,   717,   718,
       0,     0,     0,     0,   719,   216,   720,     0,     0,   721,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,   722,     0,   244,   245,   246,
     247,   723,   724,   248,   249,     0,   250,   251,   252,   725,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   726,   260,   727,   262,   263,     0,   264,
       0,   728,     0,   265,   266,   267,     0,   268,   729,   730,
       0,   269,   270,     0,     0,     0,   731,   272,   273,   274,
     275,   732,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,   733,   281,   282,  1814,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   735,     0,     0,   292,     0,   736,
     293,   294,     0,     0,     0,     0,     0,   737,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,   738,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,   739,   321,   322,   323,   324,   740,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     741,   332,     0,     0,   742,   334,   743,   335,     0,   336,
     744,   745,   746,   747,   748,   341,   342,   343,   344,   345,
     346,     0,   749,   347,   348,     0,     0,   349,   350,   351,
     352,   750,     0,   752,   353,   354,     0,   753,   754,   355,
       0,   356,   357,   755,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,   756,   368,     0,   369,     0,   370,
     371,   757,   373,   374,   375,   376,   758,   759,   379,   760,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   761,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,   762,   763,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   764,     0,   765,   416,   417,
     418,   419,   420,   421,   766,   767,   424,   425,   426,   427,
       0,   768,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,   769,   770,   455,   456,     0,   457,   458,
     771,   460,   461,   462,   772,   773,   463,   464,   465,   466,
     774,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,   775,   474,   475,     0,   776,   777,   778,   779,     0,
       0,     0,     0,     0,   480,   481,   482,     0,   780,   781,
     782,   484,   485,   486,   783,   487,   488,   784,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   785,   497,   498,     0,     0,   786,   787,   788,
     789,   499,     0,     0,   500,   790,     0,   791,   501,   502,
     503,   504,   505,   792,   793,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   794,
       0,     0,     0,     0,   795,   796,     0,     0,     0,     0,
     797,   798,     0,     0,   799,   800,     0,     0,   801,   802,
     142,     0,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,   693,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,  1853,     0,     0,
       0,     0,   215,   216,   720,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
     724,   248,   249,     0,   250,   251,   252,   725,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,   729,   730,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,   738,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
     749,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,   753,   754,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   775,
     474,   475,     0,  1854,   477,   478,  1855,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,   781,   483,   484,
     485,   486,   783,   487,   488,   784,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   513,     0,     0,
       0,   142,     0,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,   801,   802,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,  3003,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,   529,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,  2133,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,  2134,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,  3374,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,  2433,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,   534,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,     0,   513,     0,
     142,     0,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,  3076,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,  3003,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,   529,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,  2133,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,  2134,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
     534,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,     0,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   513,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,  3076,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
    2433,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,     0,   513,     0,   142,     0,
     143,   144,   145,   146,   147,   148,     0,     0,   149,  2872,
       0,     0,   150,     0,     0,   151,   802,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,     0,   264,     0,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
     353,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
       0,   368,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,     0,     0,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,     0,   428,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,     0,
       0,   455,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,     0,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,   483,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   513,     0,     0,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,  4772,   149,
       0,     0,     0,   150,  4773,   802,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,     0,   513,     0,     0,     0,
     142,     0,   143,   144,   145,   146,   147,   148,  1171,     0,
     149,     0,     0,     0,   150,     0,   802,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,  1385,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,     0,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   513,     0,   142,
       0,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,   563,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,     0,   513,     0,     0,     0,
       0,     0,     0,  2380,   142,     0,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,   563,     0,   150,     0,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,     0,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   513,     0,     0,     0,   142,     0,   143,   144,   145,
     146,   147,   148,  3075,     0,   149,     0,     0,     0,   150,
       0,  3076,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,     0,   513,     0,     0,     0,   142,     0,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,  4773,   802,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,     0,     0,   347,   348,     0,
       0,   349,   350,   351,   352,     0,     0,     0,   353,   354,
       0,     0,     0,   355,     0,   356,   357,   358,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,     0,   368,
       0,   369,     0,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,     0,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,     0,     0,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   415,
       0,     0,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,     0,   428,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,     0,     0,   455,
     456,     0,   457,   458,   459,   460,   461,   462,     0,     0,
     463,   464,   465,   466,     0,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,     0,   474,   475,     0,   476,
     477,   478,   479,     0,     0,     0,     0,     0,   480,   481,
     482,     0,     0,     0,   483,   484,   485,   486,     0,   487,
     488,     0,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   496,   497,   498,     0,
       0,     0,     0,     0,     0,   499,     0,     0,   500,     0,
       0,     0,   501,   502,   503,   504,   505,   506,   507,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   513,     0,   142,     0,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,   563,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   634,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   635,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,     0,   513,     0,   142,     0,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,   563,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,     0,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,     0,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   513,     0,   142,     0,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,   802,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,     0,
     513,     0,   142,     0,   143,   144,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   151,
    3076,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   944,   945,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,   946,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   947,     0,   264,
       0,     0,     0,   265,   266,   267,     0,   268,     0,     0,
       0,   269,   270,     0,     0,     0,   271,   272,   273,   274,
     275,     0,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,   282,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   291,     0,     0,   292,     0,     0,
     293,   294,     0,     0,     0,     0,     0,   295,   296,     0,
     948,     0,   298,     0,   299,   300,     0,     0,     0,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   949,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,     0,     0,     0,   353,   354,     0,     0,     0,   355,
       0,   356,   357,   358,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,     0,   368,     0,   369,     0,   370,
     371,   950,   373,   374,   375,   376,   377,   378,   379,     0,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,     0,     0,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   415,     0,     0,   951,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
       0,   428,   429,     0,     0,     0,   430,   431,   952,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,     0,     0,   455,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,     0,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   953,   481,   482,     0,     0,     0,
     483,   484,   485,   486,     0,   487,   488,     0,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   513,
     142,     0,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,   954,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
     646,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,   139,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   513,   142,     0,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,   151,  1438,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,     0,   264,     0,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,   646,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
     353,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
       0,   368,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,     0,     0,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,     0,   428,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,     0,
       0,   455,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,   139,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,   483,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   513,   142,     0,   143,   144,
     145,   146,   147,   148,     0,     0,   149,     0,     0,     0,
     150,     0,     0,   151,  1784,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   944,   945,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,   946,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   947,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   948,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   949,   345,   346,     0,     0,   347,   348,     0,
       0,   349,   350,   351,   352,     0,     0,     0,   353,   354,
       0,     0,     0,   355,     0,   356,   357,   358,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,     0,   368,
       0,   369,     0,   370,   371,   950,   373,   374,   375,   376,
     377,   378,   379,     0,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,     0,     0,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   415,
       0,     0,   951,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,     0,   428,   429,     0,     0,     0,
     430,   431,   952,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,     0,     0,   455,
     456,     0,   457,   458,   459,   460,   461,   462,     0,     0,
     463,   464,   465,   466,     0,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,     0,   474,   475,     0,   476,
     477,   478,   479,     0,     0,     0,     0,     0,   480,   481,
     482,     0,     0,     0,   483,   484,   485,   486,     0,   487,
     488,     0,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   496,   497,   498,     0,
       0,     0,     0,     0,     0,   499,     0,     0,   500,     0,
       0,     0,   501,   502,   503,   504,   505,   506,   507,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,     0,   513,   142,     0,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,     0,
       0,   151,   954,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,     0,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,   646,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   139,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
       0,   513,   142,     0,   143,   144,   145,   146,   147,   148,
       0,     0,   149,     0,     0,     0,   150,     0,     0,   151,
    3635,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,  1318,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,     0,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   263,     0,   264,
       0,     0,     0,   265,   266,   267,     0,   268,     0,     0,
       0,   269,   270,     0,     0,     0,   271,   272,   273,   274,
     275,     0,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,   282,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   291,     0,     0,   292,     0,     0,
     293,   294,     0,     0,     0,     0,     0,   295,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,     0,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,     0,     0,     0,   353,   354,     0,     0,     0,   355,
       0,   356,   357,   358,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,     0,   368,     0,   369,     0,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,     0,     0,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   415,     0,     0,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
       0,   428,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,     0,     0,   455,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,     0,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   480,   481,   482,     0,     0,     0,
     483,   484,   485,   486,     0,   487,   488,     0,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,     0,   513,
     142,     0,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,     0,   150,     0,     0,   151,  1319,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,     0,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,     0,   513,   142,     0,
     143,   144,   145,   146,   147,   148,     0,     0,   149,     0,
       0,     0,   150,     0,     0,     0,  1319,   152,   153,   154,
     155,   156,   157,   158,     0,     0,  -372,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,     0,     0,     0,     0,   169,  4150,     0,
     170,   171,     0,   172,     0,     0,     0,     0,     0,   176,
     177,   178,   179,  4151,   181,   182,     0,   183,   184,     0,
       0,     0,     0,     0,     0,   190,     0,   192,     0,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
       0,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,     0,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,     0,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,     0,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,     0,
       0,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,  4152,   250,   251,   252,     0,     0,     0,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,     0,   263,     0,   264,     0,     0,     0,     0,
     266,   267,     0,     0,     0,     0,     0,     0,   270,     0,
       0,     0,   271,   272,   273,   274,   275,  4153,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,     0,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,  4154,     0,     0,   288,     0,     0,     0,   290,
     291,     0,     0,   292,  4155,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,  -327,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
       0,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,  4156,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   366,   367,     0,
       0,     0,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,     0,     0,     0,     0,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,     0,     0,   405,     0,   407,  -327,     0,   408,
       0,     0,     0,   410,     0,     0,   412,   413,     0,   414,
    4157,   415,     0,     0,   416,     0,   418,   419,   420,   421,
     422,   423,   424,     0,   426,   427,     0,   428,     0,     0,
       0,     0,   430,   431,   432,     0,     0,     0,     0,   434,
       0,     0,     0,     0,     0,     0,   437,     0,     0,   440,
     441,     0,   442,     0,   444,     0,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,     0,     0,     0,     0,   454,     0,
       0,     0,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,     0,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,     0,     0,     0,
       0,   493,     0,     0,   494,     0,     0,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,  -327,     0,     0,     0,   508,     0,     0,
     510,     0,   512,     0,   142,   513,   143,   144,   145,   146,
     147,   148,     0,     0,   149,     0,     0,     0,   150,  4766,
       0,   151,     0,   152,   153,   154,   155,   156,   157,   158,
     159,     0,   160,     0,     0,     0,   161,     0,     0,     0,
     162,     0,     0,   163,   164,   165,     0,   166,     0,   167,
     168,     0,     0,   169,     0,     0,   170,   171,     0,   172,
     173,     0,   174,   175,     0,   176,   177,   178,   179,   180,
     181,   182,     0,   183,   184,   185,   186,   187,   188,   189,
       0,   190,   191,   192,   193,   194,   195,   196,   197,     0,
     198,   199,     0,   200,   201,   202,   203,   204,     0,   205,
       0,     0,   206,     0,     0,   207,     0,   208,  1051,     0,
     209,     0,   210,     0,     0,     0,   211,   212,   213,     0,
       0,   214,     0,     0,     0,     0,   215,   216,     0,     0,
       0,     0,   217,     0,   218,     0,     0,     0,   219,     0,
     220,   221,   222,   223,   224,     0,     0,     0,   225,     0,
       0,   226,   227,   228,     0,     0,     0,   229,     0,   230,
     231,     0,   232,   233,   234,     0,     0,   235,   236,     0,
     237,   238,   239,   240,   241,   242,   243,     0,     0,   244,
     245,   246,   247,     0,     0,   248,   249,     0,   250,   251,
     252,     0,     0,   253,     0,     0,     0,   254,     0,   255,
       0,   256,     0,   257,   258,   259,   260,   261,   262,   263,
       0,   264,     0,     0,     0,   265,   266,   267,     0,   268,
       0,     0,     0,   269,   270,     0,     0,     0,   271,   272,
     273,   274,   275,     0,     0,   276,   277,   278,     0,   279,
       0,   280,     0,     0,     0,     0,   281,   282,     0,     0,
       0,   283,     0,   284,   285,     0,   286,   287,     0,     0,
       0,   288,     0,     0,   289,   290,   291,     0,     0,   292,
       0,     0,   293,   294,   646,     0,     0,     0,     0,   295,
     296,     0,   297,     0,   298,     0,   299,   300,     0,     0,
       0,     0,     0,     0,     0,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,   312,   313,   314,   315,
     316,     0,   317,   318,   319,   320,     0,   321,   322,   323,
     324,     0,   325,   326,     0,     0,     0,     0,   327,   328,
     329,   330,   331,   332,     0,     0,   333,   334,     0,   335,
       0,   336,     0,   337,   338,   339,   340,   341,   342,   343,
     344,   345,   346,     0,     0,   347,   348,     0,     0,   349,
     350,   351,   352,     0,     0,     0,   353,   354,     0,     0,
       0,   355,     0,   356,   357,   358,     0,   359,   360,   361,
     362,     0,   363,   364,     0,     0,     0,     0,     0,     0,
       0,     0,   365,   366,   367,     0,     0,   368,     0,   369,
       0,   370,   371,   372,   373,   374,   375,   376,   377,   378,
     379,     0,     0,   380,   381,   382,     0,   383,     0,   384,
     385,   386,   387,   388,     0,   389,   390,   391,     0,     0,
     392,     0,     0,     0,   393,   394,   395,   396,   397,     0,
       0,   398,   399,   400,   401,   402,     0,   403,   404,     0,
     405,   406,   407,     0,     0,   408,     0,   409,     0,   410,
     411,     0,   412,   413,     0,   414,     0,   415,     0,     0,
     416,   417,   418,   419,   420,   421,   422,   423,   424,   425,
     426,   427,     0,   428,   429,     0,     0,     0,   430,   431,
     432,   433,     0,     0,     0,   434,     0,     0,     0,   435,
       0,   436,   437,   438,   439,   440,   441,     0,   442,   443,
     444,   445,   446,   447,     0,     0,     0,     0,     0,     0,
     448,   449,     0,   450,     0,     0,   451,     0,     0,   452,
     453,     0,     0,     0,   454,     0,     0,   455,   456,     0,
     457,   458,   459,   460,   461,   462,     0,     0,   463,   464,
     465,   466,     0,   467,   468,     0,   469,     0,   470,   471,
     472,   473,     0,   139,   474,   475,     0,   476,   477,   478,
     479,     0,     0,     0,     0,     0,   480,   481,   482,     0,
       0,     0,   483,   484,   485,   486,     0,   487,   488,     0,
     489,   490,     0,   491,   492,     0,     0,   493,     0,     0,
     494,     0,   495,     0,   496,   497,   498,     0,     0,     0,
       0,     0,     0,   499,     0,     0,   500,     0,     0,     0,
     501,   502,   503,   504,   505,   506,   507,     0,     0,     0,
       0,     0,     0,   508,   509,     0,   510,   511,   512,     0,
     142,   513,   143,   144,   145,   146,   147,   148,     0,     0,
     149,     0,     0,  1216,   150,     0,     0,   151,     0,   152,
     153,   154,   155,   156,   157,   158,   159,     0,   160,     0,
       0,     0,   161,     0,     0,     0,   162,     0,     0,   163,
     164,   165,     0,   166,     0,   167,   168,     0,     0,   169,
       0,     0,   170,   171,     0,   172,   173,     0,   174,   175,
       0,   176,   177,   178,   179,   180,   181,   182,     0,   183,
     184,   185,   186,   187,   188,   189,     0,   190,   191,   192,
     193,   194,   195,   196,   197,     0,   198,   199,     0,   200,
     201,   202,   203,   204,     0,   205,     0,     0,   206,     0,
       0,   207,     0,   208,     0,     0,   209,     0,   210,     0,
       0,     0,   211,   212,   213,     0,     0,   214,     0,     0,
       0,     0,   215,   216,     0,     0,     0,     0,   217,     0,
     218,     0,     0,     0,   219,     0,   220,   221,   222,   223,
     224,     0,     0,     0,   225,     0,     0,   226,   227,   228,
       0,     0,     0,   229,     0,   230,   231,     0,   232,   233,
     234,     0,     0,   235,   236,     0,   237,   238,   239,   240,
     241,   242,   243,     0,     0,   244,   245,   246,   247,     0,
       0,   248,   249,     0,   250,   251,   252,     0,     0,   253,
       0,     0,     0,   254,     0,   255,     0,   256,     0,   257,
     258,   259,   260,   261,   262,   263,     0,   264,     0,     0,
       0,   265,   266,   267,     0,   268,     0,     0,     0,   269,
     270,     0,     0,     0,   271,   272,   273,   274,   275,     0,
       0,   276,   277,   278,     0,   279,     0,   280,     0,     0,
       0,     0,   281,   282,     0,     0,     0,   283,     0,   284,
     285,     0,   286,   287,     0,     0,     0,   288,     0,     0,
     289,   290,   291,     0,     0,   292,     0,     0,   293,   294,
       0,     0,     0,     0,     0,   295,   296,     0,   297,     0,
     298,     0,   299,   300,     0,     0,     0,     0,     0,     0,
       0,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,   312,   313,   314,   315,   316,     0,   317,   318,
     319,   320,     0,   321,   322,   323,   324,     0,   325,   326,
       0,     0,     0,     0,   327,   328,   329,   330,   331,   332,
       0,     0,   333,   334,     0,   335,     0,   336,     0,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,     0,
       0,   347,   348,     0,     0,   349,   350,   351,   352,     0,
       0,     0,   353,   354,     0,     0,     0,   355,     0,   356,
     357,   358,     0,   359,   360,   361,   362,     0,   363,   364,
       0,     0,     0,     0,     0,     0,     0,     0,   365,   366,
     367,     0,     0,   368,     0,   369,     0,   370,   371,   372,
     373,   374,   375,   376,   377,   378,   379,     0,     0,   380,
     381,   382,     0,   383,     0,   384,   385,   386,   387,   388,
       0,   389,   390,   391,     0,     0,   392,     0,     0,     0,
     393,   394,   395,   396,   397,     0,     0,   398,   399,   400,
     401,   402,     0,   403,   404,     0,   405,   406,   407,     0,
       0,   408,     0,   409,     0,   410,   411,     0,   412,   413,
       0,   414,     0,   415,     0,     0,   416,   417,   418,   419,
     420,   421,   422,   423,   424,   425,   426,   427,     0,   428,
     429,     0,     0,     0,   430,   431,   432,   433,     0,     0,
       0,   434,     0,     0,     0,   435,     0,   436,   437,   438,
     439,   440,   441,     0,   442,   443,   444,   445,   446,   447,
       0,     0,     0,     0,     0,     0,   448,   449,     0,   450,
       0,     0,   451,     0,     0,   452,   453,     0,     0,     0,
     454,     0,     0,   455,   456,     0,   457,   458,   459,   460,
     461,   462,     0,     0,   463,   464,   465,   466,     0,   467,
     468,     0,   469,     0,   470,   471,   472,   473,     0,     0,
     474,   475,     0,   476,   477,   478,   479,     0,     0,     0,
       0,     0,   480,   481,   482,     0,     0,     0,   483,   484,
     485,   486,     0,   487,   488,     0,   489,   490,     0,   491,
     492,     0,     0,   493,     0,     0,   494,     0,   495,     0,
     496,   497,   498,     0,     0,     0,     0,     0,     0,   499,
       0,     0,   500,     0,     0,     0,   501,   502,   503,   504,
     505,   506,   507,     0,     0,     0,     0,     0,     0,   508,
     509,     0,   510,   511,   512,     0,   142,   513,   143,   144,
     145,   146,   147,   148,  2203,     0,   149,     0,     0,     0,
     150,     0,     0,   151,     0,   152,   153,   154,   155,   156,
     157,   158,   159,     0,   160,     0,     0,     0,   161,     0,
       0,     0,   162,     0,     0,   163,   164,   165,     0,   166,
       0,   167,   168,     0,     0,   169,     0,     0,   170,   171,
       0,   172,   173,     0,   174,   175,     0,   176,   177,   178,
     179,   180,   181,   182,     0,   183,   184,   185,   186,   187,
     188,   189,     0,   190,   191,   192,   193,   194,   195,   196,
     197,     0,   198,   199,     0,   200,   201,   202,   203,   204,
       0,   205,     0,     0,   206,     0,     0,   207,     0,   208,
       0,     0,   209,     0,   210,     0,     0,     0,   211,   212,
     213,     0,     0,   214,     0,     0,     0,     0,   215,   216,
       0,     0,     0,     0,   217,     0,   218,     0,     0,     0,
     219,     0,   220,   221,   222,   223,   224,     0,     0,     0,
     225,     0,     0,   226,   227,   228,     0,     0,     0,   229,
       0,   230,   231,     0,   232,   233,   234,     0,     0,   235,
     236,     0,   237,   238,   239,   240,   241,   242,   243,     0,
       0,   244,   245,   246,   247,     0,     0,   248,   249,     0,
     250,   251,   252,     0,     0,   253,     0,     0,     0,   254,
       0,   255,     0,   256,     0,   257,   258,   259,   260,   261,
     262,   263,     0,   264,     0,     0,     0,   265,   266,   267,
       0,   268,     0,     0,     0,   269,   270,     0,     0,     0,
     271,   272,   273,   274,   275,     0,     0,   276,   277,   278,
       0,   279,     0,   280,     0,     0,     0,     0,   281,   282,
       0,     0,     0,   283,     0,   284,   285,     0,   286,   287,
       0,     0,     0,   288,     0,     0,   289,   290,   291,     0,
       0,   292,     0,     0,   293,   294,     0,     0,     0,     0,
       0,   295,   296,     0,   297,     0,   298,     0,   299,   300,
       0,     0,     0,     0,     0,     0,     0,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,   312,   313,
     314,   315,   316,     0,   317,   318,   319,   320,     0,   321,
     322,   323,   324,     0,   325,   326,     0,     0,     0,     0,
     327,   328,   329,   330,   331,   332,     0,     0,   333,   334,
       0,   335,     0,   336,     0,   337,   338,   339,   340,   341,
     342,   343,   344,   345,   346,     0,     0,   347,   348,     0,
       0,   349,   350,   351,   352,     0,     0,     0,   353,   354,
       0,     0,     0,   355,     0,   356,   357,   358,     0,   359,
     360,   361,   362,     0,   363,   364,     0,     0,     0,     0,
       0,     0,     0,     0,   365,   366,   367,     0,     0,   368,
       0,   369,     0,   370,   371,   372,   373,   374,   375,   376,
     377,   378,   379,     0,     0,   380,   381,   382,     0,   383,
       0,   384,   385,   386,   387,   388,     0,   389,   390,   391,
       0,     0,   392,     0,     0,     0,   393,   394,   395,   396,
     397,     0,     0,   398,   399,   400,   401,   402,     0,   403,
     404,     0,   405,   406,   407,     0,     0,   408,     0,   409,
       0,   410,   411,     0,   412,   413,     0,   414,     0,   415,
       0,     0,   416,   417,   418,   419,   420,   421,   422,   423,
     424,   425,   426,   427,     0,   428,   429,     0,     0,     0,
     430,   431,   432,   433,     0,     0,     0,   434,     0,     0,
       0,   435,     0,   436,   437,   438,   439,   440,   441,     0,
     442,   443,   444,   445,   446,   447,     0,     0,     0,     0,
       0,     0,   448,   449,     0,   450,     0,     0,   451,     0,
       0,   452,   453,     0,     0,     0,   454,     0,     0,   455,
     456,     0,   457,   458,   459,   460,   461,   462,     0,     0,
     463,   464,   465,   466,     0,   467,   468,     0,   469,     0,
     470,   471,   472,   473,     0,     0,   474,   475,     0,   476,
     477,   478,   479,     0,     0,     0,     0,     0,   480,   481,
     482,     0,     0,     0,   483,   484,   485,   486,     0,   487,
     488,     0,   489,   490,     0,   491,   492,     0,     0,   493,
       0,     0,   494,     0,   495,     0,   496,   497,   498,     0,
       0,     0,     0,     0,     0,   499,     0,     0,   500,     0,
       0,     0,   501,   502,   503,   504,   505,   506,   507,     0,
       0,     0,     0,     0,     0,   508,   509,     0,   510,   511,
     512,     0,   142,   513,   143,   144,   145,   146,   147,   148,
    2903,     0,   149,     0,     0,     0,   150,     0,     0,   151,
       0,   152,   153,   154,   155,   156,   157,   158,   159,     0,
     160,     0,     0,     0,   161,     0,     0,     0,   162,     0,
       0,   163,   164,   165,     0,   166,     0,   167,   168,     0,
       0,   169,     0,     0,   170,   171,     0,   172,   173,     0,
     174,   175,     0,   176,   177,   178,   179,   180,   181,   182,
       0,   183,   184,   185,   186,   187,   188,   189,     0,   190,
     191,   192,   193,   194,   195,   196,   197,     0,   198,   199,
       0,   200,   201,   202,   203,   204,     0,   205,     0,     0,
     206,     0,     0,   207,     0,   208,     0,     0,   209,     0,
     210,     0,     0,     0,   211,   212,   213,     0,     0,   214,
       0,     0,     0,     0,   215,   216,     0,     0,     0,     0,
     217,     0,   218,     0,     0,     0,   219,     0,   220,   221,
     222,   223,   224,     0,     0,     0,   225,     0,     0,   226,
     227,   228,     0,     0,     0,   229,     0,   230,   231,     0,
     232,   233,   234,     0,     0,   235,   236,     0,   237,   238,
     239,   240,   241,   242,   243,     0,     0,   244,   245,   246,
     247,     0,     0,   248,   249,     0,   250,   251,   252,     0,
       0,   253,     0,     0,     0,   254,     0,   255,     0,   256,
       0,   257,   258,   259,   260,   261,   262,   263,     0,   264,
       0,     0,     0,   265,   266,   267,     0,   268,     0,     0,
       0,   269,   270,     0,     0,     0,   271,   272,   273,   274,
     275,     0,     0,   276,   277,   278,     0,   279,     0,   280,
       0,     0,     0,     0,   281,   282,     0,     0,     0,   283,
       0,   284,   285,     0,   286,   287,     0,     0,     0,   288,
       0,     0,   289,   290,   291,     0,     0,   292,     0,     0,
     293,   294,     0,     0,     0,     0,     0,   295,   296,     0,
     297,     0,   298,     0,   299,   300,     0,     0,     0,     0,
       0,     0,     0,   301,   302,   303,   304,   305,   306,   307,
     308,   309,   310,   311,   312,   313,   314,   315,   316,     0,
     317,   318,   319,   320,     0,   321,   322,   323,   324,     0,
     325,   326,     0,     0,     0,     0,   327,   328,   329,   330,
     331,   332,     0,     0,   333,   334,     0,   335,     0,   336,
       0,   337,   338,   339,   340,   341,   342,   343,   344,   345,
     346,     0,     0,   347,   348,     0,     0,   349,   350,   351,
     352,     0,     0,     0,   353,   354,     0,     0,     0,   355,
       0,   356,   357,   358,     0,   359,   360,   361,   362,     0,
     363,   364,     0,     0,     0,     0,     0,     0,     0,     0,
     365,   366,   367,     0,     0,   368,     0,   369,     0,   370,
     371,   372,   373,   374,   375,   376,   377,   378,   379,     0,
       0,   380,   381,   382,     0,   383,     0,   384,   385,   386,
     387,   388,     0,   389,   390,   391,     0,     0,   392,     0,
       0,     0,   393,   394,   395,   396,   397,     0,     0,   398,
     399,   400,   401,   402,     0,   403,   404,     0,   405,   406,
     407,     0,     0,   408,     0,   409,     0,   410,   411,     0,
     412,   413,     0,   414,     0,   415,     0,     0,   416,   417,
     418,   419,   420,   421,   422,   423,   424,   425,   426,   427,
       0,   428,   429,     0,     0,     0,   430,   431,   432,   433,
       0,     0,     0,   434,     0,     0,     0,   435,     0,   436,
     437,   438,   439,   440,   441,     0,   442,   443,   444,   445,
     446,   447,     0,     0,     0,     0,     0,     0,   448,   449,
       0,   450,     0,     0,   451,     0,     0,   452,   453,     0,
       0,     0,   454,     0,     0,   455,   456,     0,   457,   458,
     459,   460,   461,   462,     0,     0,   463,   464,   465,   466,
       0,   467,   468,     0,   469,     0,   470,   471,   472,   473,
       0,     0,   474,   475,     0,   476,   477,   478,   479,     0,
       0,     0,     0,     0,   480,   481,   482,     0,     0,     0,
     483,   484,   485,   486,     0,   487,   488,     0,   489,   490,
       0,   491,   492,     0,     0,   493,     0,     0,   494,     0,
     495,     0,   496,   497,   498,     0,     0,     0,     0,     0,
       0,   499,     0,     0,   500,     0,     0,     0,   501,   502,
     503,   504,   505,   506,   507,     0,     0,     0,     0,     0,
       0,   508,   509,     0,   510,   511,   512,     0,   142,   513,
     143,   144,   145,   146,   147,   148,  3270,     0,   149,     0,
       0,     0,   150,     0,     0,   151,     0,   152,   153,   154,
     155,   156,   157,   158,   159,     0,   160,     0,     0,     0,
     161,     0,     0,     0,   162,     0,     0,   163,   164,   165,
       0,   166,     0,   167,   168,     0,     0,   169,     0,     0,
     170,   171,     0,   172,   173,     0,   174,   175,     0,   176,
     177,   178,   179,   180,   181,   182,     0,   183,   184,   185,
     186,   187,   188,   189,     0,   190,   191,   192,   193,   194,
     195,   196,   197,     0,   198,   199,     0,   200,   201,   202,
     203,   204,     0,   205,     0,     0,   206,     0,     0,   207,
       0,   208,     0,     0,   209,     0,   210,     0,     0,     0,
     211,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,   217,     0,   218,     0,
       0,     0,   219,     0,   220,   221,   222,   223,   224,     0,
       0,     0,   225,     0,     0,   226,   227,   228,     0,     0,
       0,   229,     0,   230,   231,     0,   232,   233,   234,     0,
       0,   235,   236,     0,   237,   238,   239,   240,   241,   242,
     243,     0,     0,   244,   245,   246,   247,     0,     0,   248,
     249,     0,   250,   251,   252,     0,     0,   253,     0,     0,
       0,   254,     0,   255,     0,   256,     0,   257,   258,   259,
     260,   261,   262,   263,     0,   264,     0,     0,     0,   265,
     266,   267,     0,   268,     0,     0,     0,   269,   270,     0,
       0,     0,   271,   272,   273,   274,   275,     0,     0,   276,
     277,   278,     0,   279,     0,   280,     0,     0,     0,     0,
     281,   282,     0,     0,     0,   283,     0,   284,   285,     0,
     286,   287,     0,     0,     0,   288,     0,     0,   289,   290,
     291,     0,     0,   292,     0,     0,   293,   294,     0,     0,
       0,     0,     0,   295,   296,     0,   297,     0,   298,     0,
     299,   300,     0,     0,     0,     0,     0,     0,     0,   301,
     302,   303,   304,   305,   306,   307,   308,   309,   310,   311,
     312,   313,   314,   315,   316,     0,   317,   318,   319,   320,
       0,   321,   322,   323,   324,     0,   325,   326,     0,     0,
       0,     0,   327,   328,   329,   330,   331,   332,     0,     0,
     333,   334,     0,   335,     0,   336,     0,   337,   338,   339,
     340,   341,   342,   343,   344,   345,   346,     0,     0,   347,
     348,     0,     0,   349,   350,   351,   352,     0,     0,     0,
     353,   354,     0,     0,     0,   355,     0,   356,   357,   358,
       0,   359,   360,   361,   362,     0,   363,   364,     0,     0,
       0,     0,     0,     0,     0,     0,   365,   366,   367,     0,
       0,   368,     0,   369,     0,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,     0,     0,   380,   381,   382,
       0,   383,     0,   384,   385,   386,   387,   388,     0,   389,
     390,   391,     0,     0,   392,     0,     0,     0,   393,   394,
     395,   396,   397,     0,     0,   398,   399,   400,   401,   402,
       0,   403,   404,     0,   405,   406,   407,     0,     0,   408,
       0,   409,     0,   410,   411,     0,   412,   413,     0,   414,
       0,   415,     0,     0,   416,   417,   418,   419,   420,   421,
     422,   423,   424,   425,   426,   427,     0,   428,   429,     0,
       0,     0,   430,   431,   432,   433,     0,     0,     0,   434,
       0,     0,     0,   435,     0,   436,   437,   438,   439,   440,
     441,     0,   442,   443,   444,   445,   446,   447,     0,     0,
       0,     0,     0,     0,   448,   449,     0,   450,     0,     0,
     451,     0,     0,   452,   453,     0,     0,     0,   454,     0,
       0,   455,   456,     0,   457,   458,   459,   460,   461,   462,
       0,     0,   463,   464,   465,   466,     0,   467,   468,     0,
     469,     0,   470,   471,   472,   473,     0,     0,   474,   475,
       0,   476,   477,   478,   479,     0,     0,     0,     0,     0,
     480,   481,   482,     0,     0,     0,   483,   484,   485,   486,
       0,   487,   488,     0,   489,   490,     0,   491,   492,     0,
       0,   493,     0,     0,   494,     0,   495,     0,   496,   497,
     498,     0,     0,     0,     0,     0,     0,   499,     0,     0,
     500,     0,     0,     0,   501,   502,   503,   504,   505,   506,
     507,     0,     0,     0,     0,     0,     0,   508,   509,     0,
     510,   511,   512,     0,     0,   513,     0,     0,     0,     0,
       0,   142,  3640,   143,   144,   145,   146,   147,   148,   843,
     844,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
     845,     0,   207,     0,   208,     0,   846,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,   847,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,   848,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   849,
     240,   241,   242,   850,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   851,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,   852,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,   853,   279,     0,   280,     0,
       0,     0,   854,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   646,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,   855,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   856,   385,   386,   387,
     857,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,   858,     0,   398,   399,
     400,   401,   402,     0,   859,   404,     0,   405,   406,   407,
       0,     0,   860,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,   861,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,   862,   863,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   864,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
     139,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,   865,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,   866,   495,
     867,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   920,
     144,   145,   146,   147,   148,   921,   844,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,   845,     0,   207,     0,
     208,     0,   846,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,   847,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,   848,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   849,   240,   241,   242,   850,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   851,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,   852,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,   853,   279,     0,   280,     0,     0,     0,   854,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,   646,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,   855,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   856,   385,   386,   387,   922,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,   858,     0,   398,   399,   400,   401,   402,     0,
     859,   404,     0,   405,   406,   407,     0,     0,   860,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,   861,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,   862,   863,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   864,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,   139,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,   865,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,   866,   495,   867,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,  2555,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
    2556,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,  2557,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,  2558,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,  1099,  1100,     0,   353,   354,     0,     0,  2559,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,  4753,   588,  4754,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,  2560,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,  1669,     0,     0,  3485,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,  1670,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,  2987,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,  2988,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,  2989,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,   139,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,  2990,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,  1669,
       0,     0,  4292,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,  1670,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,  2987,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,  2988,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,  2989,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,   139,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,  2990,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,  1669,     0,     0,  4547,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,  1670,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,  2987,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,  2988,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,  2989,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
     139,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,  2990,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,  1426,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,  1427,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,  1428,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,   646,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,  1429,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,   139,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,  1051,   846,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,   646,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,   139,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
    1440,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,  1441,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   646,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,   139,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,  1021,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,  1022,  1023,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,  1024,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,  2000,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,  2001,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,   756,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,  2002,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,  2003,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,  2000,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,  2001,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,   756,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,  2003,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,  1426,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
    1427,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,   646,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,   139,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,  2000,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,  2001,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,   756,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,  4012,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,  2003,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
     846,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   646,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,   139,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,  1051,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,   646,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
     139,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,  1463,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,   646,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,   139,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
    2465,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,   646,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,   139,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
    1426,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,   646,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,   139,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,   646,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,   139,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,  2899,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
     139,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,  4660,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,  4661,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,   588,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,  1117,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,   946,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,  1970,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,  2126,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,   946,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,  3097,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,   139,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,  3401,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
     251,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,  3409,
       0,   149,     0,     0,     0,   150,     0,     0,   151,     0,
     152,   153,   154,   155,   156,   157,   158,   159,     0,   160,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,   167,   168,     0,     0,
     169,     0,     0,   170,   171,     0,   172,   173,     0,   174,
     175,     0,   176,   177,   178,   179,   180,   181,   182,     0,
     183,   184,   185,   186,   187,   188,   189,     0,   190,   191,
     192,   193,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,   203,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,   216,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,   225,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,   230,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,   242,   243,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
     253,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,   262,   263,     0,   264,     0,
       0,     0,   265,   266,   267,     0,   268,     0,     0,     0,
     269,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,   282,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,   289,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,   353,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,   362,     0,   363,
     364,     0,     0,     0,     0,     0,     0,     0,     0,   365,
     366,   367,     0,     0,   368,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,   379,     0,     0,
     380,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,   404,     0,   405,   406,   407,
       0,     0,   408,     0,   409,     0,   410,   411,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,   417,   418,
     419,   420,   421,   422,   423,   424,   425,   426,   427,     0,
     428,   429,     0,     0,     0,   430,   431,   432,   433,     0,
       0,     0,   434,     0,     0,     0,   435,     0,   436,   437,
     438,   439,   440,   441,     0,   442,   443,   444,   445,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,   453,     0,     0,
       0,   454,     0,     0,   455,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,   483,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
     491,   492,     0,     0,   493,     0,     0,   494,     0,   495,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,   509,     0,   510,   511,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,   151,     0,   152,   153,   154,   155,
     156,   157,   158,   159,     0,   160,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,   167,   168,     0,     0,   169,     0,     0,   170,
     171,     0,   172,   173,     0,   174,   175,     0,   176,   177,
     178,   179,   180,   181,   182,     0,   183,   184,   185,   186,
     187,   188,   189,     0,   190,   191,   192,   193,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,   203,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,  3433,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,   225,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,   230,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,   242,   243,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
       0,   250,   251,   252,     0,     0,   253,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,   262,   263,     0,   264,     0,     0,     0,   265,   266,
     267,     0,   268,     0,     0,     0,   269,   270,     0,     0,
       0,   271,   272,   273,   274,   275,     0,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
     282,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,     0,     0,     0,   288,     0,     0,   289,   290,   291,
       0,     0,   292,     0,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,     0,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,   353,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,   362,     0,   363,   364,     0,     0,     0,
       0,     0,     0,     0,     0,   365,   366,   367,     0,     0,
     368,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,   379,     0,     0,   380,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,   404,     0,   405,   406,   407,     0,     0,   408,     0,
     409,     0,   410,   411,     0,   412,   413,     0,   414,     0,
     415,     0,     0,   416,   417,   418,   419,   420,   421,   422,
     423,   424,   425,   426,   427,     0,   428,   429,     0,     0,
       0,   430,   431,   432,   433,     0,     0,     0,   434,     0,
       0,     0,   435,     0,   436,   437,   438,   439,   440,   441,
       0,   442,   443,   444,   445,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,   453,     0,     0,     0,   454,     0,     0,
     455,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,   483,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,   491,   492,     0,     0,
     493,     0,     0,   494,     0,   495,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,     0,     0,     0,     0,   508,   509,     0,   510,
     511,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
     151,     0,   152,   153,   154,   155,   156,   157,   158,   159,
       0,   160,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,   167,   168,
       0,     0,   169,     0,     0,   170,   171,     0,   172,   173,
       0,   174,   175,     0,   176,   177,   178,   179,   180,   181,
     182,     0,   183,   184,   185,   186,   187,   188,   189,     0,
     190,   191,   192,   193,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,   203,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,   216,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,   225,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,   230,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,   242,   243,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,     0,   250,   251,   252,
       0,     0,   253,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,   262,   263,     0,
     264,     0,     0,     0,   265,   266,   267,     0,   268,     0,
       0,     0,   269,   270,     0,     0,     0,   271,   272,   273,
     274,   275,     0,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,   282,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,     0,     0,     0,
     288,     0,     0,   289,   290,   291,     0,     0,   292,     0,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,     0,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,   353,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,   362,
       0,   363,   364,     0,     0,     0,     0,     0,     0,     0,
       0,   365,   366,   367,     0,     0,   368,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,   379,
       0,     0,   380,   381,   382,  4323,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,   404,     0,   405,
     406,   407,     0,     0,   408,     0,   409,     0,   410,   411,
       0,   412,   413,     0,   414,     0,   415,     0,     0,   416,
     417,   418,   419,   420,   421,   422,   423,   424,   425,   426,
     427,     0,   428,   429,     0,     0,     0,   430,   431,   432,
     433,     0,     0,     0,   434,     0,     0,     0,   435,     0,
     436,   437,   438,   439,   440,   441,     0,   442,   443,   444,
     445,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,   453,
       0,     0,     0,   454,     0,     0,   455,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,   483,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,   491,   492,     0,     0,   493,     0,     0,   494,
       0,   495,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,     0,     0,
       0,     0,   508,   509,     0,   510,   511,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,   151,     0,   152,   153,
     154,   155,   156,   157,   158,   159,     0,   160,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,   167,   168,     0,     0,   169,     0,
       0,   170,   171,     0,   172,   173,     0,   174,   175,     0,
     176,   177,   178,   179,   180,   181,   182,     0,   183,   184,
     185,   186,   187,   188,   189,     0,   190,   191,   192,   193,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,   203,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,   216,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,   225,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,   230,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
     242,   243,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,     0,   250,   251,   252,     0,     0,   253,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,   262,   263,     0,   264,     0,     0,     0,
     265,   266,   267,     0,   268,     0,     0,     0,   269,   270,
       0,     0,     0,   271,   272,   273,   274,   275,     0,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,   282,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,     0,     0,     0,   288,     0,     0,   289,
     290,   291,     0,     0,   292,     0,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,     0,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,   353,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,   362,     0,   363,   364,     0,
       0,     0,     0,     0,     0,     0,     0,   365,   366,   367,
       0,     0,   368,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,   379,     0,     0,   380,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,   404,     0,   405,   406,   407,     0,     0,
     408,     0,   409,     0,   410,   411,     0,   412,   413,     0,
     414,     0,   415,     0,     0,   416,   417,   418,   419,   420,
     421,   422,   423,   424,   425,   426,   427,     0,   428,   429,
       0,     0,     0,   430,   431,   432,   433,     0,     0,     0,
     434,     0,     0,     0,   435,     0,   436,   437,   438,   439,
     440,   441,     0,   442,   443,   444,   445,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,   453,     0,     0,     0,   454,
       0,     0,   455,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,   483,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,   491,   492,
       0,     0,   493,     0,     0,   494,     0,   495,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,     0,     0,     0,     0,   508,   509,
       0,   510,   511,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,   151,     0,   152,   153,   154,   155,   156,   157,
     158,   159,     0,   160,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
     167,   168,     0,     0,   169,     0,     0,   170,   171,     0,
     172,   173,     0,   174,   175,     0,   176,   177,   178,   179,
     180,   181,   182,     0,   183,   184,   185,   186,   187,   188,
     189,     0,   190,   191,   192,   193,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,   203,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,   216,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,   225,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
     230,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,   242,   243,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,     0,   250,
    1886,   252,     0,     0,   253,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,   262,
     263,     0,   264,     0,     0,     0,   265,   266,   267,     0,
     268,     0,     0,     0,   269,   270,     0,     0,     0,   271,
     272,   273,   274,   275,     0,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,   282,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,     0,
       0,     0,   288,     0,     0,   289,   290,   291,     0,     0,
     292,     0,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,     0,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,  1887,   351,   352,     0,     0,     0,   353,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,   362,     0,   363,   364,     0,     0,     0,     0,     0,
       0,     0,     0,   365,   366,   367,     0,     0,   368,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,   379,     0,     0,   380,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,   404,
       0,   405,   406,   407,     0,     0,   408,     0,   409,     0,
     410,   411,     0,   412,   413,     0,   414,     0,   415,     0,
       0,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,     0,   428,   429,     0,     0,     0,   430,
     431,   432,   433,     0,     0,     0,   434,     0,     0,     0,
     435,     0,   436,   437,   438,   439,   440,   441,     0,   442,
     443,   444,   445,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,   453,     0,     0,     0,   454,     0,     0,   455,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,   483,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,   491,   492,     0,     0,   493,     0,
       0,   494,     0,   495,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
       0,     0,     0,     0,   508,   509,     0,   510,   511,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,     0,     0,
     152,   153,   154,   155,   156,   157,   158,     0,     0,  -372,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,     0,     0,     0,     0,
     169,  4150,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,   176,   177,   178,   179,  4151,   181,   182,     0,
     183,   184,     0,     0,     0,     0,     0,     0,   190,     0,
     192,     0,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,     0,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   226,   227,
     228,     0,  -342,  -342,   229,     0,  -342,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,     0,     0,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,  4152,   250,   251,   252,     0,     0,
       0,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,     0,   263,     0,   264,     0,
       0,     0,     0,   266,   267,     0,     0,     0,     0,     0,
       0,   270,     0,     0,     0,   271,   272,   273,   274,   275,
    4153,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,     0,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,  4154,     0,     0,   288,     0,
       0,     0,   290,   291,     0,     0,   292,  4155,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,  -327,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,     0,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,  4156,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     366,   367,     0,     0,     0,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,     0,
       0,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,     0,     0,   405,     0,   407,
    -327,     0,   408,     0,     0,     0,   410,     0,     0,   412,
     413,     0,   414,  4157,   415,     0,     0,   416,     0,   418,
     419,   420,   421,   422,   423,   424,     0,   426,   427,     0,
     428,     0,     0,     0,     0,   430,   431,   432,     0,     0,
       0,     0,   434,     0,     0,     0,     0,     0,     0,   437,
       0,     0,   440,   441,     0,   442,     0,   444,     0,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,     0,     0,     0,
       0,   454,     0,     0,     0,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
       0,     0,     0,     0,   493,     0,     0,   494,     0,     0,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,  -327,     0,     0,     0,
     508,     0,     0,   510,     0,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,     0,     0,   152,   153,   154,   155,
     156,   157,   158,     0,     0,  -372,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,     0,     0,     0,     0,   169,  4150,     0,   170,
     171,     0,   172,     0,     0,     0,     0,     0,   176,   177,
     178,   179,  4151,   181,   182,     0,   183,   184,     0,     0,
       0,     0,     0,     0,   190,     0,   192,     0,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,     0,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
       0,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,     0,     0,     0,   226,   227,   228,     0,  -363,     0,
     229,     0,  -363,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,     0,     0,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
    4152,   250,   251,   252,     0,     0,     0,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,     0,   263,     0,   264,     0,     0,     0,     0,   266,
     267,     0,     0,     0,     0,     0,     0,   270,     0,     0,
       0,   271,   272,   273,   274,   275,  4153,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
       0,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,  4154,     0,     0,   288,     0,     0,     0,   290,   291,
       0,     0,   292,  4155,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,  -327,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,     0,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,  4156,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   366,   367,     0,     0,
       0,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,     0,     0,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,     0,     0,   405,     0,   407,  -327,     0,   408,     0,
       0,     0,   410,     0,     0,   412,   413,     0,   414,  4157,
     415,     0,     0,   416,     0,   418,   419,   420,   421,   422,
     423,   424,     0,   426,   427,     0,   428,     0,     0,     0,
       0,   430,   431,   432,     0,     0,     0,     0,   434,     0,
       0,     0,     0,     0,     0,   437,     0,     0,   440,   441,
       0,   442,     0,   444,     0,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,     0,     0,     0,     0,   454,     0,     0,
       0,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,     0,     0,     0,     0,
     493,     0,     0,   494,     0,     0,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
    -363,     0,  -327,     0,     0,     0,   508,     0,     0,   510,
       0,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
       0,     0,   152,   153,   154,   155,   156,   157,   158,     0,
       0,  -372,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,     0,     0,
       0,     0,   169,  4150,     0,   170,   171,     0,   172,     0,
       0,     0,     0,     0,   176,   177,   178,   179,  4151,   181,
     182,     0,   183,   184,     0,     0,     0,     0,     0,     0,
     190,     0,   192,     0,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,     0,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,     0,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,     0,     0,     0,
     226,   227,   228,     0,  -360,     0,   229,     0,  -360,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,     0,     0,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,  4152,   250,   251,   252,
       0,     0,     0,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,     0,   263,     0,
     264,     0,     0,     0,     0,   266,   267,     0,     0,     0,
       0,     0,     0,   270,     0,     0,     0,   271,   272,   273,
     274,   275,  4153,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,     0,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,  4154,     0,     0,
     288,     0,     0,     0,   290,   291,     0,     0,   292,  4155,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,  -327,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,     0,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,  4156,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   366,   367,     0,     0,     0,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,     0,     0,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,     0,     0,   405,
       0,   407,  -327,     0,   408,     0,     0,     0,   410,     0,
       0,   412,   413,     0,   414,  4157,   415,     0,     0,   416,
       0,   418,   419,   420,   421,   422,   423,   424,     0,   426,
     427,     0,   428,     0,     0,     0,     0,   430,   431,   432,
       0,     0,     0,     0,   434,     0,     0,     0,     0,     0,
       0,   437,     0,     0,   440,   441,     0,   442,     0,   444,
       0,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,     0,
       0,     0,     0,   454,     0,     0,     0,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,     0,     0,     0,     0,   493,     0,     0,   494,
       0,     0,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,  -360,     0,  -327,     0,
       0,     0,   508,     0,     0,   510,     0,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,     0,     0,   152,   153,
     154,   155,   156,   157,   158,     0,     0,  -372,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,     0,     0,     0,     0,   169,  4150,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
     176,   177,   178,   179,  4151,   181,   182,     0,   183,   184,
       0,     0,     0,     0,     0,     0,   190,     0,   192,     0,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,     0,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,  4532,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
       0,     0,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,  4152,   250,   251,   252,     0,     0,     0,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,     0,   263,     0,   264,     0,     0,     0,
       0,   266,   267,     0,     0,     0,     0,     0,     0,   270,
       0,     0,     0,   271,   272,   273,   274,   275,  4153,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,     0,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,  4154,     0,     0,   288,     0,     0,     0,
     290,   291,     0,     0,   292,  4155,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,  -327,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,     0,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,  4156,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   366,   367,
       0,     0,     0,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,     0,     0,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,     0,     0,   405,     0,   407,  -327,     0,
     408,     0,     0,     0,   410,     0,     0,   412,   413,     0,
     414,  4157,   415,     0,     0,   416,     0,   418,   419,   420,
     421,   422,   423,   424,     0,   426,   427,     0,   428,     0,
       0,     0,     0,   430,   431,   432,     0,     0,     0,     0,
     434,     0,     0,     0,     0,     0,     0,   437,     0,     0,
     440,   441,     0,   442,     0,   444,     0,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,     0,     0,     0,     0,   454,
       0,     0,     0,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,     0,     0,
       0,     0,   493,     0,     0,   494,     0,     0,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,  -327,     0,     0,     0,   508,     0,
       0,   510,     0,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,     0,     0,   152,   153,   154,   155,   156,   157,
     158,     0,     0,  -372,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
       0,     0,     0,     0,   169,  4150,     0,   170,   171,     0,
     172,     0,     0,     0,     0,     0,   176,   177,   178,   179,
    4151,   181,   182,     0,   183,   184,     0,     0,     0,     0,
       0,     0,   190,     0,   192,     0,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,     0,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
    -365,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,     0,     0,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,  4152,   250,
     251,   252,     0,     0,     0,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,     0,
     263,     0,   264,     0,     0,     0,     0,   266,   267,     0,
       0,     0,     0,     0,     0,   270,     0,     0,     0,   271,
     272,   273,   274,   275,  4153,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,     0,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,  4154,
       0,     0,   288,     0,     0,     0,   290,   291,     0,     0,
     292,  4155,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,  -327,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,     0,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,  4156,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   366,   367,     0,     0,     0,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,     0,     0,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,     0,
       0,   405,     0,   407,  -327,     0,   408,     0,     0,     0,
     410,     0,     0,   412,   413,     0,   414,  4157,   415,     0,
       0,   416,     0,   418,   419,   420,   421,   422,   423,   424,
       0,   426,   427,     0,   428,     0,     0,     0,     0,   430,
     431,   432,     0,     0,     0,     0,   434,     0,     0,     0,
       0,     0,     0,   437,     0,     0,   440,   441,     0,   442,
       0,   444,     0,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,     0,     0,     0,     0,   454,     0,     0,     0,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,     0,     0,     0,     0,   493,     0,
       0,   494,     0,     0,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
    -327,     0,     0,     0,   508,     0,     0,   510,     0,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,     0,     0,
     152,   153,   154,   155,   156,   157,   158,     0,     0,  -372,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,     0,     0,     0,     0,
     169,  4150,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,   176,   177,   178,   179,  4151,   181,   182,     0,
     183,   184,     0,     0,     0,     0,     0,     0,   190,     0,
     192,     0,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,     0,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,  4665,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,     0,     0,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,  4152,   250,   251,   252,     0,     0,
       0,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,     0,   263,     0,   264,     0,
       0,     0,     0,   266,   267,     0,     0,     0,     0,     0,
       0,   270,     0,     0,     0,   271,   272,   273,   274,   275,
    4153,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,     0,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,  4154,     0,     0,   288,     0,
       0,     0,   290,   291,     0,     0,   292,  4155,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,  -327,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,     0,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,  4156,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     366,   367,     0,     0,     0,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,     0,
       0,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,     0,     0,   405,     0,   407,
    -327,     0,   408,     0,     0,     0,   410,     0,     0,   412,
     413,     0,   414,  4157,   415,     0,     0,   416,     0,   418,
     419,   420,   421,   422,   423,   424,     0,   426,   427,     0,
     428,     0,     0,     0,     0,   430,   431,   432,     0,     0,
       0,     0,   434,     0,     0,     0,     0,     0,     0,   437,
       0,     0,   440,   441,     0,   442,     0,   444,     0,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,     0,     0,     0,
       0,   454,     0,     0,     0,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
       0,     0,     0,     0,   493,     0,     0,   494,     0,     0,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,  -327,     0,     0,     0,
     508,     0,     0,   510,     0,   512,     0,   142,   513,   143,
     144,   145,   146,   147,   148,     0,     0,   149,     0,     0,
       0,   150,     0,     0,     0,     0,   152,   153,   154,   155,
     156,   157,   158,     0,     0,  -372,     0,     0,     0,   161,
       0,     0,     0,   162,     0,     0,   163,   164,   165,     0,
     166,     0,     0,     0,     0,     0,   169,  4150,     0,   170,
     171,     0,   172,     0,     0,     0,     0,     0,   176,   177,
     178,   179,  4151,   181,   182,     0,   183,   184,     0,     0,
       0,     0,     0,     0,   190,     0,   192,     0,   194,   195,
     196,   197,     0,   198,   199,     0,   200,   201,   202,     0,
     204,     0,   205,     0,     0,   206,     0,     0,   207,     0,
     208,     0,     0,   209,     0,   210,     0,     0,     0,   211,
     212,   213,     0,     0,   214,     0,     0,     0,     0,   215,
       0,     0,     0,     0,     0,   217,     0,   218,     0,     0,
       0,   219,     0,   220,   221,   222,   223,   224,     0,     0,
       0,     0,     0,     0,   226,   227,   228,     0,     0,     0,
     229,     0,  4723,   231,     0,   232,   233,   234,     0,     0,
     235,   236,     0,   237,   238,   239,   240,   241,     0,     0,
       0,     0,   244,   245,   246,   247,     0,     0,   248,   249,
    4152,   250,   251,   252,     0,     0,     0,     0,     0,     0,
     254,     0,   255,     0,   256,     0,   257,   258,   259,   260,
     261,     0,   263,     0,   264,     0,     0,     0,     0,   266,
     267,     0,     0,     0,     0,     0,     0,   270,     0,     0,
       0,   271,   272,   273,   274,   275,  4153,     0,   276,   277,
     278,     0,   279,     0,   280,     0,     0,     0,     0,   281,
       0,     0,     0,     0,   283,     0,   284,   285,     0,   286,
     287,  4154,     0,     0,   288,     0,     0,     0,   290,   291,
       0,     0,   292,  4155,     0,   293,   294,     0,     0,     0,
       0,     0,   295,   296,     0,   297,     0,   298,     0,   299,
     300,     0,     0,     0,     0,  -327,     0,     0,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,   312,
     313,   314,   315,   316,     0,   317,   318,   319,   320,     0,
     321,   322,   323,   324,     0,   325,   326,     0,     0,     0,
       0,   327,   328,   329,   330,   331,   332,     0,     0,   333,
     334,     0,   335,     0,   336,     0,   337,   338,   339,   340,
     341,   342,   343,   344,   345,   346,     0,     0,   347,   348,
       0,     0,   349,   350,   351,   352,     0,     0,     0,     0,
     354,     0,     0,     0,   355,     0,   356,   357,   358,     0,
     359,   360,   361,  4156,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   366,   367,     0,     0,
       0,     0,   369,     0,   370,   371,   372,   373,   374,   375,
     376,   377,   378,     0,     0,     0,     0,   381,   382,     0,
     383,     0,   384,   385,   386,   387,   388,     0,   389,   390,
     391,     0,     0,   392,     0,     0,     0,   393,   394,   395,
     396,   397,     0,     0,   398,   399,   400,   401,   402,     0,
     403,     0,     0,   405,     0,   407,  -327,     0,   408,     0,
       0,     0,   410,     0,     0,   412,   413,     0,   414,  4157,
     415,     0,     0,   416,     0,   418,   419,   420,   421,   422,
     423,   424,     0,   426,   427,     0,   428,     0,     0,     0,
       0,   430,   431,   432,     0,     0,     0,     0,   434,     0,
       0,     0,     0,     0,     0,   437,     0,     0,   440,   441,
       0,   442,     0,   444,     0,   446,   447,     0,     0,     0,
       0,     0,     0,   448,   449,     0,   450,     0,     0,   451,
       0,     0,   452,     0,     0,     0,     0,   454,     0,     0,
       0,   456,     0,   457,   458,   459,   460,   461,   462,     0,
       0,   463,   464,   465,   466,     0,   467,   468,     0,   469,
       0,   470,   471,   472,   473,     0,     0,   474,   475,     0,
     476,   477,   478,   479,     0,     0,     0,     0,     0,   480,
     481,   482,     0,     0,     0,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,     0,     0,     0,     0,     0,
     493,     0,     0,   494,     0,     0,     0,   496,   497,   498,
       0,     0,     0,     0,     0,     0,   499,     0,     0,   500,
       0,     0,     0,   501,   502,   503,   504,   505,   506,   507,
       0,     0,  -327,     0,     0,     0,   508,     0,     0,   510,
       0,   512,     0,   142,   513,   143,   144,   145,   146,   147,
     148,     0,     0,   149,     0,     0,     0,   150,     0,     0,
       0,     0,   152,   153,   154,   155,   156,   157,   158,     0,
       0,  -372,     0,     0,     0,   161,     0,     0,     0,   162,
       0,     0,   163,   164,   165,     0,   166,     0,     0,     0,
       0,     0,   169,  4150,     0,   170,   171,     0,   172,     0,
       0,     0,     0,     0,   176,   177,   178,   179,  4151,   181,
     182,     0,   183,   184,     0,     0,     0,     0,     0,     0,
     190,     0,   192,     0,   194,   195,   196,   197,     0,   198,
     199,     0,   200,   201,   202,     0,   204,     0,   205,     0,
       0,   206,     0,     0,   207,     0,   208,     0,     0,   209,
       0,   210,     0,     0,     0,   211,   212,   213,     0,     0,
     214,     0,     0,     0,     0,   215,     0,     0,     0,     0,
       0,   217,     0,   218,     0,     0,     0,   219,     0,   220,
     221,   222,   223,   224,     0,     0,     0,     0,     0,     0,
     226,   227,   228,     0,     0,     0,   229,     0,  -346,   231,
       0,   232,   233,   234,     0,     0,   235,   236,     0,   237,
     238,   239,   240,   241,     0,     0,     0,     0,   244,   245,
     246,   247,     0,     0,   248,   249,  4152,   250,   251,   252,
       0,     0,     0,     0,     0,     0,   254,     0,   255,     0,
     256,     0,   257,   258,   259,   260,   261,     0,   263,     0,
     264,     0,     0,     0,     0,   266,   267,     0,     0,     0,
       0,     0,     0,   270,     0,     0,     0,   271,   272,   273,
     274,   275,  4153,     0,   276,   277,   278,     0,   279,     0,
     280,     0,     0,     0,     0,   281,     0,     0,     0,     0,
     283,     0,   284,   285,     0,   286,   287,  4154,     0,     0,
     288,     0,     0,     0,   290,   291,     0,     0,   292,  4155,
       0,   293,   294,     0,     0,     0,     0,     0,   295,   296,
       0,   297,     0,   298,     0,   299,   300,     0,     0,     0,
       0,  -327,     0,     0,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   312,   313,   314,   315,   316,
       0,   317,   318,   319,   320,     0,   321,   322,   323,   324,
       0,   325,   326,     0,     0,     0,     0,   327,   328,   329,
     330,   331,   332,     0,     0,   333,   334,     0,   335,     0,
     336,     0,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,     0,     0,   347,   348,     0,     0,   349,   350,
     351,   352,     0,     0,     0,     0,   354,     0,     0,     0,
     355,     0,   356,   357,   358,     0,   359,   360,   361,  4156,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   366,   367,     0,     0,     0,     0,   369,     0,
     370,   371,   372,   373,   374,   375,   376,   377,   378,     0,
       0,     0,     0,   381,   382,     0,   383,     0,   384,   385,
     386,   387,   388,     0,   389,   390,   391,     0,     0,   392,
       0,     0,     0,   393,   394,   395,   396,   397,     0,     0,
     398,   399,   400,   401,   402,     0,   403,     0,     0,   405,
       0,   407,  -327,     0,   408,     0,     0,     0,   410,     0,
       0,   412,   413,     0,   414,  4157,   415,     0,     0,   416,
       0,   418,   419,   420,   421,   422,   423,   424,     0,   426,
     427,     0,   428,     0,     0,     0,     0,   430,   431,   432,
       0,     0,     0,     0,   434,     0,     0,     0,     0,     0,
       0,   437,     0,     0,   440,   441,     0,   442,     0,   444,
       0,   446,   447,     0,     0,     0,     0,     0,     0,   448,
     449,     0,   450,     0,     0,   451,     0,     0,   452,     0,
       0,     0,     0,   454,     0,     0,     0,   456,     0,   457,
     458,   459,   460,   461,   462,     0,     0,   463,   464,   465,
     466,     0,   467,   468,     0,   469,     0,   470,   471,   472,
     473,     0,     0,   474,   475,     0,   476,   477,   478,   479,
       0,     0,     0,     0,     0,   480,   481,   482,     0,     0,
       0,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,     0,     0,     0,     0,     0,   493,     0,     0,   494,
       0,     0,     0,   496,   497,   498,     0,     0,     0,     0,
       0,     0,   499,     0,     0,   500,     0,     0,     0,   501,
     502,   503,   504,   505,   506,   507,     0,     0,  -327,     0,
       0,     0,   508,     0,     0,   510,     0,   512,     0,   142,
     513,   143,   144,   145,   146,   147,   148,     0,     0,   149,
       0,     0,     0,   150,     0,     0,     0,     0,   152,   153,
     154,   155,   156,   157,   158,     0,     0,  -372,     0,     0,
       0,   161,     0,     0,     0,   162,     0,     0,   163,   164,
     165,     0,   166,     0,     0,     0,     0,     0,   169,  4150,
       0,   170,   171,     0,   172,     0,     0,     0,     0,     0,
     176,   177,   178,   179,  4151,   181,   182,     0,   183,   184,
       0,     0,     0,     0,     0,     0,   190,     0,   192,     0,
     194,   195,   196,   197,     0,   198,   199,     0,   200,   201,
     202,     0,   204,     0,   205,     0,     0,   206,     0,     0,
     207,     0,   208,     0,     0,   209,     0,   210,     0,     0,
       0,   211,   212,   213,     0,     0,   214,     0,     0,     0,
       0,   215,     0,     0,     0,     0,     0,   217,     0,   218,
       0,     0,     0,   219,     0,   220,   221,   222,   223,   224,
       0,     0,     0,     0,     0,     0,   226,   227,   228,     0,
       0,     0,   229,     0,     0,   231,     0,   232,   233,   234,
       0,     0,   235,   236,     0,   237,   238,   239,   240,   241,
       0,     0,     0,     0,   244,   245,   246,   247,     0,     0,
     248,   249,  4152,   250,   251,   252,     0,     0,     0,     0,
       0,     0,   254,     0,   255,     0,   256,     0,   257,   258,
     259,   260,   261,     0,   263,     0,   264,     0,     0,     0,
       0,   266,   267,     0,     0,     0,     0,     0,     0,   270,
       0,     0,     0,   271,   272,   273,   274,   275,  4153,     0,
     276,   277,   278,     0,   279,     0,   280,     0,     0,     0,
       0,   281,     0,     0,     0,     0,   283,     0,   284,   285,
       0,   286,   287,  4154,     0,     0,   288,     0,     0,     0,
     290,   291,     0,     0,   292,  4155,     0,   293,   294,     0,
       0,     0,     0,     0,   295,   296,     0,   297,     0,   298,
       0,   299,   300,     0,     0,     0,     0,  -327,     0,     0,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,   312,   313,   314,   315,   316,     0,   317,   318,   319,
     320,     0,   321,   322,   323,   324,     0,   325,   326,     0,
       0,     0,     0,   327,   328,   329,   330,   331,   332,     0,
       0,   333,   334,     0,   335,     0,   336,     0,   337,   338,
     339,   340,   341,   342,   343,   344,   345,   346,     0,     0,
     347,   348,     0,     0,   349,   350,   351,   352,     0,     0,
       0,     0,   354,     0,     0,     0,   355,     0,   356,   357,
     358,     0,   359,   360,   361,  4156,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   366,   367,
       0,     0,     0,     0,   369,     0,   370,   371,   372,   373,
     374,   375,   376,   377,   378,     0,     0,     0,     0,   381,
     382,     0,   383,     0,   384,   385,   386,   387,   388,     0,
     389,   390,   391,     0,     0,   392,     0,     0,     0,   393,
     394,   395,   396,   397,     0,     0,   398,   399,   400,   401,
     402,     0,   403,     0,     0,   405,     0,   407,  -327,     0,
     408,     0,     0,     0,   410,     0,     0,   412,   413,     0,
     414,  4157,   415,     0,     0,   416,     0,   418,   419,   420,
     421,   422,   423,   424,     0,   426,   427,     0,   428,     0,
       0,     0,     0,   430,   431,   432,     0,     0,     0,     0,
     434,     0,     0,     0,     0,     0,     0,   437,     0,     0,
     440,   441,     0,   442,     0,   444,     0,   446,   447,     0,
       0,     0,     0,     0,     0,   448,   449,     0,   450,     0,
       0,   451,     0,     0,   452,     0,     0,     0,     0,   454,
       0,     0,     0,   456,     0,   457,   458,   459,   460,   461,
     462,     0,     0,   463,   464,   465,   466,     0,   467,   468,
       0,   469,     0,   470,   471,   472,   473,     0,     0,   474,
     475,     0,   476,   477,   478,   479,     0,     0,     0,     0,
       0,   480,   481,   482,     0,     0,     0,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,     0,     0,     0,
       0,     0,   493,     0,     0,   494,     0,     0,     0,   496,
     497,   498,     0,     0,     0,     0,     0,     0,   499,     0,
       0,   500,     0,     0,     0,   501,   502,   503,   504,   505,
     506,   507,     0,     0,  -327,     0,     0,     0,   508,     0,
       0,   510,     0,   512,     0,   142,   513,   143,   144,   145,
     146,   147,   148,     0,     0,   149,     0,     0,     0,   150,
       0,     0,     0,     0,   152,   153,   154,   155,   156,   157,
     158,     0,     0,  -372,     0,     0,     0,   161,     0,     0,
       0,   162,     0,     0,   163,   164,   165,     0,   166,     0,
       0,     0,     0,     0,   169,  4150,     0,   170,   171,     0,
     172,     0,     0,     0,     0,     0,   176,   177,   178,   179,
    4151,   181,   182,     0,   183,   184,     0,     0,     0,     0,
       0,     0,   190,     0,   192,     0,   194,   195,   196,   197,
       0,   198,   199,     0,   200,   201,   202,     0,   204,     0,
     205,     0,     0,   206,     0,     0,   207,     0,   208,     0,
       0,   209,     0,   210,     0,     0,     0,   211,   212,   213,
       0,     0,   214,     0,     0,     0,     0,   215,     0,     0,
       0,     0,     0,   217,     0,   218,     0,     0,     0,   219,
       0,   220,   221,   222,   223,   224,     0,     0,     0,     0,
       0,     0,   226,   227,   228,     0,     0,     0,   229,     0,
       0,   231,     0,   232,   233,   234,     0,     0,   235,   236,
       0,   237,   238,   239,   240,   241,     0,     0,     0,     0,
     244,   245,   246,   247,     0,     0,   248,   249,  4152,   250,
     251,   252,     0,     0,     0,     0,     0,     0,   254,     0,
     255,     0,   256,     0,   257,   258,   259,   260,   261,     0,
     263,     0,   264,     0,     0,     0,     0,   266,   267,     0,
       0,     0,     0,     0,     0,   270,     0,     0,     0,   271,
     272,   273,   274,   275,  4153,     0,   276,   277,   278,     0,
     279,     0,   280,     0,     0,     0,     0,   281,     0,     0,
       0,     0,   283,     0,   284,   285,     0,   286,   287,  4154,
       0,     0,   288,     0,     0,     0,   290,   291,     0,     0,
     292,  4155,     0,   293,   294,     0,     0,     0,     0,     0,
     295,   296,     0,   297,     0,   298,     0,   299,   300,     0,
       0,     0,     0,  -327,     0,     0,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,     0,   317,   318,   319,   320,     0,   321,   322,
     323,   324,     0,   325,   326,     0,     0,     0,     0,   327,
     328,   329,   330,   331,   332,     0,     0,   333,   334,     0,
     335,     0,   336,     0,   337,   338,   339,   340,   341,   342,
     343,   344,   345,   346,     0,     0,   347,   348,     0,     0,
     349,   350,   351,   352,     0,     0,     0,     0,   354,     0,
       0,     0,   355,     0,   356,   357,   358,     0,   359,   360,
     361,  4156,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   366,   367,     0,     0,     0,     0,
     369,     0,   370,   371,   372,   373,   374,   375,   376,   377,
     378,     0,     0,     0,     0,   381,   382,     0,   383,     0,
     384,   385,   386,   387,   388,     0,   389,   390,   391,     0,
       0,   392,     0,     0,     0,   393,   394,   395,   396,   397,
       0,     0,   398,   399,   400,   401,   402,     0,   403,     0,
       0,   405,     0,   407,  -327,     0,   408,     0,     0,     0,
     410,     0,     0,   412,   413,     0,   414,  4157,   415,     0,
       0,   416,     0,   418,   419,   420,   421,   422,   423,   424,
       0,   426,   427,     0,   428,     0,     0,     0,     0,   430,
     431,   432,     0,     0,     0,     0,   434,     0,     0,     0,
       0,     0,     0,   437,     0,     0,   440,   441,     0,   442,
       0,   444,     0,   446,   447,     0,     0,     0,     0,     0,
       0,   448,   449,     0,   450,     0,     0,   451,     0,     0,
     452,     0,     0,     0,     0,   454,     0,     0,     0,   456,
       0,   457,   458,   459,   460,   461,   462,     0,     0,   463,
     464,   465,   466,     0,   467,   468,     0,   469,     0,   470,
     471,   472,   473,     0,     0,   474,   475,     0,   476,   477,
     478,   479,     0,     0,     0,     0,     0,   480,   481,   482,
       0,     0,     0,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,     0,     0,     0,     0,     0,   493,     0,
       0,  4535,     0,     0,     0,   496,   497,   498,     0,     0,
       0,     0,     0,     0,   499,     0,     0,   500,     0,     0,
       0,   501,   502,   503,   504,   505,   506,   507,     0,     0,
    -327,     0,     0,     0,   508,     0,     0,   510,     0,   512,
       0,   142,   513,   143,   144,   145,   146,   147,   148,     0,
       0,   149,     0,     0,     0,   150,     0,     0,     0,     0,
     152,   153,   154,   155,   156,   157,   158,     0,     0,     0,
       0,     0,     0,   161,     0,     0,     0,   162,     0,     0,
     163,   164,   165,     0,   166,     0,     0,     0,     0,     0,
     169,     0,     0,   170,   171,     0,   172,     0,     0,     0,
       0,     0,   176,   177,   178,   179,     0,   181,   182,     0,
     183,   184,     0,     0,     0,     0,     0,     0,   190,     0,
     192,     0,   194,   195,   196,   197,     0,   198,   199,     0,
     200,   201,   202,     0,   204,     0,   205,     0,     0,   206,
       0,     0,   207,     0,   208,     0,     0,   209,     0,   210,
       0,     0,     0,   211,   212,   213,     0,     0,   214,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,   217,
       0,   218,     0,     0,     0,   219,     0,   220,   221,   222,
     223,   224,     0,     0,     0,     0,     0,     0,   226,   227,
     228,     0,     0,     0,   229,     0,     0,   231,     0,   232,
     233,   234,     0,     0,   235,   236,     0,   237,   238,   239,
     240,   241,     0,     0,     0,     0,   244,   245,   246,   247,
       0,     0,   248,   249,     0,   250,   251,   252,     0,     0,
       0,     0,     0,     0,   254,     0,   255,     0,   256,     0,
     257,   258,   259,   260,   261,     0,   263,     0,   264,     0,
       0,     0,     0,   266,   267,     0,     0,     0,     0,     0,
       0,   270,     0,     0,     0,   271,   272,   273,   274,   275,
       0,     0,   276,   277,   278,     0,   279,     0,   280,     0,
       0,     0,     0,   281,     0,     0,     0,     0,   283,     0,
     284,   285,     0,   286,   287,     0,     0,     0,   288,     0,
       0,     0,   290,   291,     0,     0,   292,     0,     0,   293,
     294,     0,     0,     0,     0,     0,   295,   296,     0,   297,
       0,   298,     0,   299,   300,     0,     0,     0,     0,     0,
       0,     0,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,   312,   313,   314,   315,   316,     0,   317,
     318,   319,   320,     0,   321,   322,   323,   324,     0,   325,
     326,     0,     0,     0,     0,   327,   328,   329,   330,   331,
     332,     0,     0,   333,   334,     0,   335,     0,   336,     0,
     337,   338,   339,   340,   341,   342,   343,   344,   345,   346,
       0,     0,   347,   348,     0,     0,   349,   350,   351,   352,
       0,     0,     0,     0,   354,     0,     0,     0,   355,     0,
     356,   357,   358,     0,   359,   360,   361,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     366,   367,     0,     0,     0,     0,   369,     0,   370,   371,
     372,   373,   374,   375,   376,   377,   378,     0,     0,     0,
       0,   381,   382,     0,   383,     0,   384,   385,   386,   387,
     388,     0,   389,   390,   391,     0,     0,   392,     0,     0,
       0,   393,   394,   395,   396,   397,     0,     0,   398,   399,
     400,   401,   402,     0,   403,     0,     0,   405,     0,   407,
       0,     0,   408,     0,     0,     0,   410,     0,     0,   412,
     413,     0,   414,     0,   415,     0,     0,   416,     0,   418,
     419,   420,   421,   422,   423,   424,     0,   426,   427,     0,
     428,     0,     0,     0,     0,   430,   431,   432,     0,     0,
       0,     0,   434,     0,     0,     0,     0,     0,     0,   437,
       0,     0,   440,   441,     0,   442,     0,   444,     0,   446,
     447,     0,     0,     0,     0,     0,     0,   448,   449,     0,
     450,     0,     0,   451,     0,     0,   452,     0,     0,     0,
       0,   454,     0,     0,     0,   456,     0,   457,   458,   459,
     460,   461,   462,     0,     0,   463,   464,   465,   466,     0,
     467,   468,     0,   469,     0,   470,   471,   472,   473,     0,
       0,   474,   475,     0,   476,   477,   478,   479,     0,     0,
       0,     0,     0,   480,   481,   482,     0,     0,     0,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,     0,
       0,     0,     0,     0,   493,     0,     0,   494,     0,     0,
       0,   496,   497,   498,     0,     0,     0,     0,     0,     0,
     499,     0,     0,   500,     0,     0,     0,   501,   502,   503,
     504,   505,   506,   507,     0,     0,     0,     0,     0,     0,
     508,     0,     0,   510,     0,   512,     0,     0,   513
};

static const yytype_int16 yycheck[] =
{
       6,   600,  1220,   672,  1044,   949,   950,  1045,   578,  1220,
    1191,    20,   623,    19,   642,   929,   960,    23,  1149,  1946,
    1947,    30,  1318,  1633,   528,   128,  1596,    33,    37,  2116,
     599,   600,  1781,     6,    40,  2116,  1598,    43,  1364,  1121,
     972,   997,    48,  1446,  1466,  1629,  1630,   835,  2398,    55,
    2537,  2879,   545,   546,   547,  1466,   549,  2437,   551,  1243,
    2219,   554,   543,   556,  1167,   997,  1250,   739,   642,   692,
    1251,  1252,  2231,  1318,  1255,  1256,  1257,  1258,  2609,  1260,
    1261,  1262,  1263,  1264,  1265,  1266,  1267,  1345,   837,  3035,
    2670,     4,  2360,    99,  3354,  2791,  3081,  1158,   562,  1049,
    2944,   562,   603,  1285,  3086,   606,   680,  1049,  2322,  2459,
    1857,  1016,  1372,  2116,    23,  2232,  1477,   123,  1931,   125,
     134,   127,   128,   129,  2575,  3623,  2502,  3036,  2114,   593,
    2507,  2548,   593,   970,  2186,  2097,  1497,   806,    18,  2724,
     668,   669,  3150,  2577,  1505,  1506,  2114,  2581,  2186,  2566,
    2567,  2953,   125,  2510,   127,   904,  3236,    26,  2592,    17,
      18,   998,  2519,    13,    13,     8,    20,  3551,    36,    75,
    2604,  3166,   795,   796,   797,  1080,    21,   681,   682,   683,
    1576,  3174,  3441,    49,   807,    20,    29,    17,    18,    20,
      99,    62,  1566,    36,    22,  1945,    53,    20,    32,    18,
    2186,  2173,    26,    13,  2202,  2721,  2722,    83,   132,    84,
     156,  2727,   676,  2729,  1039,  1040,   999,   136,  2186,  2088,
     116,    13,    17,    18,  1620,    20,   118,   195,  2872,   162,
    2566,  2567,   136,    61,    62,  2570,   166,    22,   162,    17,
      18,    17,    18,    17,    18,  3011,    53,    91,  2484,    17,
      18,    36,    68,   277,  1079,    70,   166,    22,    87,  2676,
    2677,    60,  3421,  2316,   202,    50,   276,   235,   225,    83,
      58,    36,   294,  4086,   202,    65,    61,    62,   375,   210,
    3663,   387,   162,    45,   405,    50,   132,   331,  4384,    89,
     132,   132,   137,   152,   137,  2106,    61,    62,   376,   235,
     466,     9,   235,  3003,  3396,   260,   432,   134,   162,  3483,
     457,  4101,   166,   145,  3014,   199,   134,    38,   404,   486,
     162,   162,   313,   235,    24,    66,   404,    11,    38,    12,
     279,  2707,   133,  2709,   277,   166,   133,   817,  2866,   372,
    2676,  2677,   246,   166,   166,    21,   839,   239,  2310,    72,
      17,    18,   283,   486,  3738,  3739,    17,    18,  3742,  3619,
     257,  4465,   408,   387,  4468,   564,   674,   283,   564,   833,
     564,   554,    42,   242,   535,   558,   257,  3761,   199,   365,
     218,  2052,   294,   182,  3768,   364,   365,   186,    22,    17,
      18,   162,    13,   173,  1576,    17,    18,    72,   197,   156,
      36,   564,    36,    17,    18,   223,   196,   156,   631,  3907,
     432,   166,    17,    18,   239,   529,    50,   231,   242,   233,
      21,  2685,   202,    17,    18,   263,    62,    61,    62,   415,
     533,   199,   253,   656,  2962,  3818,   427,   917,  1620,   622,
    4254,   169,    17,    18,   387,   478,   613,   614,   262,   563,
     133,   252,   321,   369,    75,   252,   617,  2455,   654,   562,
     654,   137,   661,   195,   567,   162,   512,   294,   138,  1039,
    1040,   294,    17,    18,   174,    20,   294,   361,   564,   274,
    2516,   419,   190,  1521,  4274,  1157,   564,   654,  3871,   990,
     593,   419,   197,  1281,   294,  1439,   662,   321,   330,  1171,
     221,   222,   623,   235,   182,   631,   277,   119,   463,   656,
     122,   221,   222,   504,  2890,  2891,   428,   258,   562,   455,
    4624,   654,   455,   831,   370,  3700,   475,   533,   386,   535,
     329,   389,   391,    17,    18,   432,   137,  2980,  1042,    17,
      18,    17,    18,  3345,   368,   589,   552,  3349,  4644,   151,
     656,   432,    17,    18,   564,  3714,   562,   563,    65,   656,
     491,   567,  2524,   569,  1967,   495,  3950,    17,    18,  2886,
    2887,  2888,   596,   676,  4388,  3959,   582,  1246,   535,   367,
     277,    17,    18,   427,  2570,   495,  4399,   593,  1337,    17,
      18,   386,   354,   599,   389,  2975,  3688,  3857,  3294,  3983,
      26,  1533,  2570,   609,  3988,   462,   519,   564,   386,   432,
     386,   389,   386,   389,   636,   389,  1566,   432,   386,   629,
     558,   389,   628,   468,  1566,  2628,  3392,   417,  1809,   428,
     558,  1254,  3891,  2685,  1471,  1931,   642,  1474,   644,  1820,
     608,  1478,  1823,  1480,    17,    18,  1318,  2685,  1271,  1831,
    3658,   657,   481,  1134,  1135,   462,   662,   570,   664,  3303,
    3356,  1410,   668,   669,  3081,  3000,  2027,   673,   674,  1619,
     676,  1508,  1509,   495,   680,    17,    18,  1619,  2914,  1160,
    2549,   687,   628,   602,   657,  1434,  1931,  1168,   504,  1170,
     603,  2653,  2088,   606,   504,  3395,  2658,   610,   602,  2685,
    1605,  1182,  1183,  1184,  2666,  2667,  2678,  3407,  2706,  1190,
    2672,  2461,   504,   588,   557,   539,  3133,  2685,  2114,   386,
    1503,   597,   389,  3423,  3424,   386,   622,   660,   389,  1554,
     833,   834,   662,   739,   577,   419,   660,  3437,   164,  2792,
     495,   575,  1803,  3587,   575,   616,  3739,   639,   654,  4008,
     428,   631,   662,   662,  3928,   621,   575,  2568,   386,    41,
    4019,   389,   105,  1291,   386,   631,   594,   389,   611,    17,
      18,  1345,   386,  3149,   609,   389,  3307,  2173,  3773,  1910,
     660,   386,   640,  1411,   389,   577,   654,   656,  1576,  3698,
    2186,  4050,   386,  2167,   800,   389,   802,  3133,  3878,   656,
     624,   659,   647,   544,   654,   654,   660,   597,  1309,   594,
     640,   386,   535,   636,   389,  4198,   242,   631,   660,   660,
    4318,   827,   828,   829,   830,   831,   832,   833,   834,   594,
     836,   837,  1620,   609,   619,  2405,   842,  1411,  2509,  1367,
     662,   386,   526,   564,   389,   640,   949,  1475,   951,  3651,
    3652,   954,   955,  4236,   564,   828,  1384,   656,   629,   832,
     535,   656,   640,   836,   640,  3873,   640,   468,   971,   654,
    3134,   628,   640,   879,    17,    18,   608,   655,   656,   628,
     656,   655,   656,    75,   486,  2812,   892,  4701,   656,   660,
    1391,    17,    18,    17,    18,   321,   580,   625,   904,   905,
     243,  1475,   386,   909,  4079,   389,  2088,   662,   386,   150,
     386,   389,  2522,   389,   313,  2951,  2952,   260,    17,    18,
    3300,   386,    17,    18,   389,    53,   631,   182,  2855,   272,
    3417,   111,   629,   440,    73,   182,   386,    48,   622,   389,
    3383,   242,   368,   949,   199,   951,    17,    18,   954,   955,
     386,  1455,   199,   389,   147,   276,   568,  3542,   386,   571,
     594,   389,  3339,   660,  3314,   971,  1536,  1537,  1538,    17,
      18,    17,    18,   640,   379,   377,   486,  3353,   656,   640,
     381,   615,   616,   892,  3071,   898,    17,    18,  3345,   656,
    3071,  2173,  3349,  3310,   655,   656,   905,    26,   841,   130,
     909,  1570,  3702,    36,  2186,    17,    18,   235,  4506,  1953,
    1016,   354,   640,   386,  3000,  4395,   389,   253,   640,  4403,
    3471,  4405,  3806,   217,  3540,  3886,   640,  1041,   656,  1973,
    2592,    66,  3000,  3549,   656,   640,   166,   273,  3472,  1045,
     197,   655,   656,   634,   386,   200,   640,   389,    17,    18,
     655,   656,   654,  1627,  1726,  3017,   658,  3019,    17,    18,
    3177,   655,   656,  1069,  3026,   640,  2022,   368,  3071,  2882,
    2492,   197,  2494,  2495,  1080,  2256,  4335,   990,  3040,   992,
     655,  2828,  3134,  2494,  2495,  3047,  3048,   554,  1837,  4348,
    2022,   558,    17,    18,  4076,   640,  3134,   377,  3060,  3061,
    3062,  2057,   325,   166,  3066,  3067,   173,   218,  1114,  1115,
    1116,  1117,   377,   539,  4373,    12,   486,    17,    18,  2377,
     251,   377,  2204,    17,    18,  2057,  3340,   470,  4508,   286,
    1233,   199,    17,    18,   197,   202,  3721,  3722,   386,   377,
    3102,   389,  2503,  3728,   654,  1894,  3731,  3732,  3134,  2333,
     343,  1157,   380,  2549,   564,  4140,   640,  2417,  1622,    33,
    1069,  1622,   640,  3748,   640,  1171,  3134,  1270,   293,  1918,
    1919,   655,   656,   428,  2570,   640,  2013,  3762,   656,   655,
     656,   428,   368,  3768,  3769,  3770,  3771,   367,  2656,  2026,
     640,   656,  2029,  2030,   244,  2944,   377,   540,   624,  1822,
    4460,   371,  3986,   253,   640,  3989,   656,  3723,  1117,   277,
    3726,    85,   640,   242,  1220,    81,  1319,  2167,  2123,  2437,
     656,    17,    18,   258,    73,  2167,   108,  1233,   656,   421,
     656,   636,  2413,   377,    17,    18,  2339,  2340,   539,   367,
    3756,  3757,  3758,   386,   654,   400,   389,   401,  3764,   388,
     532,    17,    18,   494,   656,   537,  3772,  1827,   379,  1931,
     386,   662,   386,   389,  1270,   389,   654,   640,   550,  1275,
    3232,  2332,  1375,   555,  2844,  4154,  4155,   185,    17,    18,
     313,  2342,  2678,   656,   654,  1291,   160,   386,   658,  2685,
     389,   386,   321,   136,   389,   449,    17,    18,   640,  3068,
    2088,   583,  2520,   434,    17,    18,    17,    18,   629,  2520,
     367,  1839,  1318,  1319,   656,   386,   659,   511,   389,    17,
      18,   402,   171,   624,   480,   437,   506,  3096,   363,   454,
     196,  1337,    17,    18,   462,  1905,    17,    18,   386,  1345,
     386,   389,   392,   389,  1350,   654,  1352,  1848,   503,  1355,
      17,    18,   607,   662,  1977,   386,    17,    18,   389,   213,
     607,  1367,   554,    17,    18,   495,   494,  2549,   479,  1375,
      17,    18,  3531,   239,   386,   288,   656,   389,  1384,  1385,
    4365,  4366,    17,    18,  4245,  2173,  4247,   579,   486,   286,
     447,   656,   640,    13,    17,    18,  1309,   263,  2186,  4243,
     656,    17,    18,   246,  1410,  1411,   260,   655,  1414,   656,
     541,    17,    18,    17,    18,     0,  1422,   386,   656,  1425,
     389,    17,    18,    17,    18,    17,    18,   386,  1434,   558,
     389,   654,   495,   199,  4262,   348,   159,  3705,   624,  1445,
    1446,   414,   408,  1356,    17,    18,  1355,   170,  3010,  3011,
    1456,  1457,  1458,  1459,  1460,  1461,   649,   650,   651,   652,
    1466,   386,   370,  4312,   389,  4450,  1472,  1473,  1932,  1475,
    1573,  1932,   162,  1479,  4402,   656,  1385,   647,  1391,   591,
      17,    18,    81,  1456,  1457,  1458,   386,  1460,   199,   389,
     291,   446,   386,   528,  1500,   389,  2678,   640,   354,  4195,
    1473,   386,   656,  2685,   389,   630,  1479,    17,    18,   544,
    2932,   535,   656,   656,   640,   636,   640,  4097,  4098,  1622,
     558,   377,   129,   561,    17,    18,   146,   129,   552,   655,
    4790,  3911,   656,   387,  4480,   401,  2480,   190,  1451,   388,
     414,   640,   486,   277,  2675,   640,   512,    54,  3016,  1555,
    1459,   417,  1461,   149,  2182,   596,   654,   656,    65,  2063,
     199,   656,   436,   166,   554,  1478,  4053,  1573,   558,   640,
     371,  4102,   527,   654,  3042,  3043,  3227,  2835,  2836,  2837,
    3231,   143,  1588,    13,   218,   656,  2882,  1593,  1594,   166,
     386,  1500,   640,   389,   640,   129,   158,   196,   472,  1605,
      17,    18,   637,   386,  3000,   655,   389,   655,  2182,   640,
     656,   250,   455,   266,   655,   605,  1622,    13,    17,    18,
     386,  1627,   535,   389,  2808,   656,  2708,    13,   640,   263,
    1636,   213,  1638,   278,  2960,  3404,   281,  2882,   486,    13,
     239,    17,    18,   486,   656,  3804,  1555,   386,   173,  2867,
     389,   419,   486,   387,    17,    18,  2867,   531,   192,  4538,
    4539,    34,   385,    13,   263,   386,  1579,   631,   389,  3438,
      44,   640,    18,   386,   582,   386,   389,  4526,   389,  1588,
    3449,   640,   486,  3452,   291,  1594,   129,   656,   386,   291,
     598,   389,   656,    17,    18,   616,   655,  2641,   619,  2448,
     133,   386,  4052,  4083,   389,   386,    13,  3394,   389,  3279,
     654,  3398,  3399,  2336,   367,   640,   146,  4645,  4646,   386,
    1726,  1727,   389,  4140,    98,   386,   655,   656,   389,   103,
    2861,   656,   386,    17,    18,   389,    20,  1840,  3134,   386,
     640,    18,   389,    17,    18,   662,   640,  2228,   387,   192,
     146,   386,  2233,   609,   389,   640,   656,   291,   526,   602,
     146,  2549,   656,   386,   371,  2246,   389,    17,    18,   371,
     386,   656,   234,   389,    17,    18,   283,  1873,   221,  1875,
     386,  1787,   386,   389,   429,   389,    17,    18,   213,   244,
     386,   239,   386,   389,   386,   389,   146,   389,   253,  2280,
     502,   147,   231,  2377,   233,   455,   654,   631,  4657,   654,
    4659,   654,   580,   386,    90,   263,   389,   662,   417,   239,
     654,  2449,   234,  1829,  1830,    17,    18,  3789,  3046,  1932,
    3392,  1837,   656,  1839,  1840,  3046,   112,   371,  3587,   146,
     563,  1937,  1938,  1939,   640,  4694,  1852,  1950,   291,   386,
     654,  1857,   389,   585,   622,     6,  1862,   640,   609,  1865,
     656,     9,   712,   713,    17,    18,  1872,  1873,  2349,  1875,
      17,    18,   655,  3835,   640,  2449,   386,   609,  3866,   389,
     253,   255,    17,    18,    32,  4734,  4735,   648,  1894,   655,
    2678,  1897,   239,   386,   655,  1901,   389,  2685,   600,    40,
     567,   640,  3890,   276,   609,   656,   239,    48,    59,   213,
    3472,   662,  1918,  1919,  1920,  1921,   655,  2486,  3995,   640,
     381,  1830,    17,    18,   432,  1931,  1932,   640,   371,   640,
    3333,  1937,  1938,  1939,   655,  1848,   786,   392,    17,    18,
     141,   643,   640,   656,  1950,   453,    17,    18,  4365,  4366,
     655,   656,  3134,   648,   250,   640,   330,   655,    49,   640,
     655,  1967,   129,  1872,  1873,  2879,  1875,    17,    18,   386,
     655,  2927,   389,   640,   655,    83,    17,    18,   614,   640,
     587,   489,  1988,    17,    18,   587,   640,   386,  1897,    86,
     389,    88,  1901,   640,   655,  2927,   846,   343,  3685,   150,
     115,   655,  4454,  1916,  4456,   640,    17,    18,   655,   199,
     386,  1920,  1921,   389,  2958,  3341,   494,   640,   655,   656,
     655,   395,  2028,   386,   640,   192,   389,   294,  1937,  1938,
    1939,   505,   655,  4450,   640,   132,   640,   505,  2044,   655,
    3542,    17,    18,   655,   640,  2051,   640,   660,   640,   655,
    3153,   655,   199,   587,   221,  2061,  2062,   154,  2064,  2065,
     558,   655,   386,   655,   231,   389,   233,   640,   441,   561,
    1983,   662,  4034,  4035,  4036,    17,    18,  4154,  4155,  3182,
    3183,  2184,   655,    61,    62,   129,  3304,  2190,  2061,  2062,
    3221,    83,  1008,   383,   191,    73,    17,    18,  1014,  1015,
    3203,  2938,   386,   640,   603,   389,    36,  3691,  3692,   224,
      17,    18,   386,    20,  2863,   389,  2219,  2123,   655,  2028,
     558,  1063,  1064,   231,   291,   233,   632,   633,  2231,   526,
     640,   654,    62,   575,  3352,     6,   386,    17,    18,   389,
     514,  3352,  2051,   386,   587,   655,   389,   640,   192,   196,
     656,   497,   498,   115,   262,   386,   616,   617,   389,   619,
    2073,   621,   655,    17,    18,   199,  1108,   655,   656,  2082,
    2083,   654,    17,    18,  2069,  2070,  2182,   551,  2184,   654,
    2093,  2094,  2095,  2096,  2190,  2098,  2099,   654,   185,   119,
    2196,  2086,   122,  2199,   386,   654,   609,   389,    17,    18,
     130,  1051,    17,    18,   371,   655,   656,   654,  2103,  2104,
    2882,   173,   655,  2219,   365,   299,   300,   654,   148,   655,
     656,    18,  2325,   640,   105,  2231,  3728,   655,   656,  3731,
    3732,   315,   654,   386,  4311,  4312,   389,    83,   655,   386,
     202,   640,   389,   656,  2814,   654,  3748,   291,   105,   662,
     242,   386,  2355,   474,   389,   656,   655,   662,  2886,  2887,
    2888,  2835,  2836,  2837,   640,  3792,  3793,   655,   656,   539,
     655,   656,   136,  2168,  2169,  2170,  2171,   640,   393,   655,
     431,   564,   433,  3414,   655,   656,   211,  4214,   654,   404,
     654,   386,   655,   654,   389,   654,   411,   654,   395,   645,
     646,   647,   648,   649,   650,   651,   652,   386,   178,    65,
     389,   654,  2886,  2887,  2888,   386,   640,  1338,   389,  2325,
    1341,   251,  2803,  1344,   654,    81,   654,   371,   654,   752,
     609,   655,   655,   656,   555,   654,   386,    93,   654,   389,
     561,   160,   439,  4420,  2350,   386,  3134,   474,   389,  2355,
     147,   774,   386,  3297,   164,   389,   640,   654,  4435,   654,
     444,   445,   243,    12,   787,   788,   640,   364,   365,   127,
     362,  2377,  3794,   370,   654,   386,   368,   554,   389,   260,
    3336,   655,   246,  3794,   605,   231,   243,   233,  3491,  3916,
     640,   272,   575,   318,   319,   510,   654,   640,   323,   324,
    3618,   622,   654,   260,  3336,   655,  2412,  3618,   654,   640,
     386,   418,   655,   389,   654,   272,   262,    17,    18,   654,
     587,   655,   656,   384,   655,  4502,   356,   655,   656,   655,
     656,  2437,   242,  2536,  2537,  2441,  3518,   655,   656,   654,
     196,   654,  2448,  2449,   386,   201,   438,   389,   640,  4526,
     655,   656,    83,   377,   136,  3024,  2462,   419,  2464,  4546,
     654,  4538,  4539,   655,  4545,   386,   115,   654,   389,   654,
      26,   229,   654,   354,   654,   147,   654,   585,   654,   386,
    2486,   654,   389,   239,   133,  4447,  2492,   640,  2494,  2495,
     605,   654,  3710,   640,  4243,   654,   377,   354,   654,  3710,
    3004,   609,   655,  4065,  4066,   640,   386,   263,  3012,   389,
     654,    60,   655,   656,  2520,   655,   656,   655,   656,   377,
     655,  3559,   654,  2529,   173,  3018,  2532,    83,  4605,   654,
    2536,  2537,   386,   164,   654,   389,   654,  3030,  4615,  3032,
    3033,   386,   654,   587,   389,   640,   343,   539,   654,  2462,
     654,  3044,   654,   202,    61,    62,   567,   656,   368,  2532,
     655,   640,  4089,  4090,   246,  4092,  4093,   386,   654,   640,
     389,   386,   502,   654,   389,   333,   655,   655,   656,   337,
    4657,    13,  4659,    26,   655,   582,   344,   655,   656,   470,
     640,   455,   655,   656,   655,   656,   558,   655,   656,   640,
     592,   598,   654,  4213,   512,   655,   640,  4684,   164,   655,
     656,   242,   654,   470,   655,  2621,   654,  4694,   580,  4696,
     235,  4698,   486,   654,  3920,   567,   654,   183,   654,   640,
    2636,   654,   624,   182,   654,  4712,   243,   186,   287,   654,
      83,   571,  4719,    51,  2650,   401,   655,   656,   197,   147,
     655,   656,   654,   260,   655,   656,   654,  4734,  4735,   540,
     622,   417,   655,   656,   640,   272,   655,   656,   426,   654,
     600,   343,  3968,  4750,  4751,   655,   656,   654,  4755,   655,
     129,  2576,  3310,   540,  2579,  2580,   242,  2582,   655,   656,
    2585,  2586,   655,   147,  2589,  2701,  2702,  2703,   640,  2594,
     497,   498,   655,   656,  2599,  2600,  2601,  2602,  2603,   147,
    3191,   654,  2607,  2608,   146,  2610,   655,   656,   654,   640,
     654,  2616,  2617,  2618,  2619,    34,   484,  2622,  2623,   539,
    2625,   362,   654,   640,   655,   654,  3310,   368,   602,   654,
     183,  2654,  2655,   192,  2657,   654,  2659,  2660,  2661,  2662,
    2663,  2664,  2665,   654,    13,  2668,   654,    83,  2671,   515,
     640,  2674,  3243,  3332,   654,   321,   655,   656,    65,   654,
     419,    97,   221,   455,   288,   655,   655,   656,   655,   656,
     329,   654,  4709,    51,    81,   384,   640,   656,  2683,   486,
     654,   223,  2701,  2702,  2703,   640,    93,   494,   377,   242,
     199,   655,   655,   656,   486,   377,   362,   438,   596,   129,
     655,   480,   368,   649,   624,   253,   655,   656,  1127,  1128,
    1129,   640,  2828,   494,  2830,   640,   655,   656,  2834,  2835,
    2836,  2837,   655,   656,   662,  1144,   662,  2843,   147,   655,
     656,   597,   291,   492,    38,   343,   656,   505,   645,   646,
     647,   648,   649,   650,   651,   652,  2862,  2863,   172,   655,
     656,  2867,  4043,   470,  4791,   655,   656,  1176,   626,   654,
    1179,   277,   192,   655,   656,   197,  2882,   526,   321,   428,
    2886,  2887,  2888,   535,   642,   655,   656,   146,    62,   343,
     554,  1200,  1201,  2899,   512,  1204,   535,    27,   288,   196,
     163,   221,   655,   656,   201,   343,   555,   197,   539,   655,
     656,    92,  1221,  1222,   655,   656,   613,   614,   656,   362,
     602,   656,   371,   655,   656,   368,  2932,  3420,   122,   156,
     157,   378,  3035,   540,  2843,   129,   655,   656,   550,   265,
    3836,  3837,   239,    73,   253,   119,  1208,  1209,   122,   655,
      83,  3316,  3317,    83,  4085,   162,   130,   654,    91,  3528,
     132,   592,  3272,  3273,   223,   118,   263,   276,  2974,  2975,
     661,   291,   654,   622,   148,   647,   648,   649,   650,   651,
     652,  3597,  3598,   539,     6,   118,  2899,  4191,  4192,   654,
     117,   185,     4,   624,  4212,   485,   622,  3003,   192,   497,
     498,  4212,   132,   129,   253,   656,  3015,  3013,  3014,   401,
      58,   447,  3021,   178,  3020,   341,   118,   232,   232,   193,
     656,   656,   662,    73,    13,   656,   628,   221,   222,  3035,
    3036,   164,   655,   655,   343,  3041,  3045,  3981,   146,    10,
    3046,   367,  3051,   497,   498,   656,   662,   655,  3057,  3058,
    3056,   371,   655,   129,   655,   364,   365,   662,   654,   497,
     498,   377,  3068,   276,   662,  2974,   192,   656,   624,  3075,
    3076,   164,   656,   661,    51,  3081,   288,   251,    20,   288,
    4118,  3087,   288,   288,  4215,  3091,  4124,   288,   520,   521,
    3096,   523,   288,   525,   656,   221,   539,   291,   656,  3669,
     656,   231,   166,   233,   430,   230,   239,   654,   540,  3022,
    3023,  3944,  3945,   554,  3087,   283,   192,   656,   402,   656,
     417,   656,   575,   575,  3957,   401,  3132,   656,   166,   197,
    3025,  3964,   441,   263,   656,  4339,   656,  3050,   587,  4343,
      73,   656,  3148,  3038,   535,   221,   253,  3056,   646,   647,
     648,   649,   650,   651,   652,   649,  4287,  3990,  3991,   254,
     187,   355,   197,   105,   552,   291,   172,   656,  3081,   535,
     509,   406,   366,   142,   377,   656,   370,   371,   655,   353,
     405,   624,   356,   656,   603,     7,   608,   320,   497,   498,
     635,   645,   646,   647,   648,   649,   650,   651,   652,   656,
     526,   199,   199,   649,   513,   338,   655,   645,   646,   647,
     648,   649,   650,   651,   652,   291,  3319,   656,   515,   648,
     162,   166,   167,   654,   166,   297,  3139,   299,   300,   362,
     655,  3237,   655,   596,   364,   365,  4367,   655,   655,  3245,
     370,  4459,   655,   315,   655,   371,   655,   377,  4459,   656,
     655,   655,   655,   195,   655,   197,   656,   655,   203,   655,
     434,   520,   521,   522,   523,   524,   525,   587,   655,   655,
     215,   213,   655,    38,   495,    17,    18,   219,   654,  3285,
     654,   540,   652,   654,   656,   564,   655,   417,   575,   564,
    3860,   564,   629,   235,   241,   371,    20,   656,  3304,  3305,
     597,   243,  3308,    27,  3310,  3874,  4510,  4511,   250,   654,
     147,   256,   129,  3319,  3417,   132,   546,    12,   260,  3325,
     654,    13,   211,   268,   199,   656,  3332,  3333,   274,   662,
     272,   654,  3245,   654,  1643,   277,   645,   646,   647,   648,
     649,   650,   651,   652,   286,   656,  3352,   662,  4262,    73,
     295,   656,    20,   199,   662,   662,   655,   122,   176,    83,
     490,  3367,   475,   656,   129,   427,  4404,   601,  3374,   115,
     564,   494,   444,   445,   568,   192,   656,   571,   656,  3388,
    4561,   123,   124,   125,   126,   127,   197,  3998,   582,  3395,
    4334,    49,   518,   587,   202,   352,   590,   571,  3404,   485,
     197,  3407,   526,   450,   221,   526,   539,   526,   132,  4353,
     526,  3417,   354,   358,   526,  3421,   654,  3423,  3424,  1728,
     185,   166,   555,  1732,   656,  3338,   600,   192,  3531,   166,
     166,  3437,  3438,   166,   166,   377,   166,   105,   166,   166,
     166,   166,   287,  3449,   166,   387,  3452,  1756,  4047,   166,
     166,   166,   166,   647,   648,   201,   221,   222,   166,   166,
     166,   587,   166,   166,   166,  3374,   377,   597,   377,   377,
    3476,   609,   105,  3479,   291,   662,   655,   419,  3484,   160,
     655,   205,   249,   249,   226,   227,   228,   229,   655,   662,
    4671,   655,   115,   239,   162,   655,   655,   655,   166,   655,
    3506,   655,   147,   166,   656,  3418,   343,   231,   656,   233,
       7,   587,   662,   662,  3427,   575,   123,   124,   125,   126,
     127,   575,   575,   564,   656,  3531,   291,   636,   470,   197,
     283,    89,  3635,    49,  4572,  4573,    14,  4575,   166,   263,
     654,   287,   575,   654,   654,   213,  4764,   349,   654,   166,
     173,   219,   494,  4764,   371,   384,   199,   199,   199,  4777,
     250,   199,   564,   564,  4782,   129,  4777,   432,   132,  4787,
    3479,  4782,   257,   656,   176,   243,  4787,   371,   260,   202,
     260,   390,   250,  3496,   334,   129,   129,   654,   132,   132,
     355,   333,   260,   335,   336,   337,   118,  4635,   540,  4637,
    4638,   118,   344,   401,   272,   370,   371,  3613,   253,   277,
     243,    81,  3618,    57,   401,   401,   239,   575,   286,   226,
     227,   228,   229,    67,   142,   261,   104,   260,   192,  3635,
     555,   261,  4231,   401,   555,   142,    49,   401,    82,   272,
     364,   365,   401,   389,   386,   403,   370,   389,   192,   192,
      94,    95,    96,   377,   596,   575,   213,   221,   136,   654,
     497,   498,   401,   401,   287,    83,   608,   609,   654,   113,
     401,   129,   150,  3679,   132,   654,   564,   221,   221,    97,
     129,   662,   383,   649,   426,   251,   354,   629,   251,   631,
     654,  4729,  3698,   417,   654,   173,  3702,   656,   343,   177,
     655,  3804,   655,   655,  3710,   655,  4746,   656,  3714,   377,
    3716,   189,   655,   655,   656,  4384,   654,   659,   660,   387,
     655,   354,   140,   662,   655,   471,   333,   291,   335,   336,
     337,   655,   432,   211,   192,   384,   649,   344,   654,   235,
     377,   483,   484,   192,   377,   655,   492,   291,   291,   656,
     278,   419,   656,   401,   655,   602,   662,   199,   253,   655,
     655,   239,  3675,   221,   166,   432,   490,   260,   246,   515,
     587,   656,   221,  3876,   260,  3781,   656,   466,  3784,   401,
     654,   263,  4420,   263,   662,  3791,  3792,  3793,  3794,   415,
     377,   414,   377,    83,    20,   655,   419,  4435,  3804,   564,
     656,   654,   470,   568,   387,    36,   571,   371,   286,   555,
     647,   648,   649,   650,   651,   652,  4386,   582,   654,   426,
     655,    49,   587,   488,   655,   590,   494,   371,   371,   655,
     631,   274,   181,   291,   468,   286,   211,   470,    69,  4409,
     153,  4785,   291,   270,   656,   655,   486,   265,   471,   655,
     213,   597,   497,   498,   260,   260,   656,   496,   377,   605,
     512,   656,   377,  3966,  4502,   655,   655,   263,   263,   492,
    3876,   654,   540,   597,   656,   631,   483,   484,   656,   654,
    3886,   655,   647,   648,   626,    87,   504,   149,   332,   277,
     238,   654,  4461,   655,   654,    36,    36,  3903,   640,   641,
     642,   655,   654,   371,   655,    62,   350,   540,   139,   251,
    3916,   655,   655,   371,   655,  3921,   340,   427,   265,   384,
    3929,  3927,   371,   341,    18,   250,   655,   662,   596,  3935,
      49,   654,   555,   164,   655,   655,   655,   168,   561,   219,
     631,   609,   420,   656,   655,   609,   364,   365,   340,   367,
    4053,   656,   609,   512,   481,   654,    20,   580,    57,   656,
    3966,   629,   440,   631,   132,   132,   654,  4605,    67,   655,
     448,   654,   656,   204,   558,  4644,   655,  4615,   456,  3892,
     413,    36,   605,    82,   662,   371,  3992,   655,   656,   340,
     656,   659,   660,   180,   225,    94,    95,    96,   143,   622,
     645,   646,   647,   648,   649,   650,   651,   652,   486,   240,
     564,   655,   430,   564,   113,   564,   263,   558,  3927,   626,
     464,   499,   500,   587,   613,   654,   317,   609,   609,   656,
    4629,   655,    15,   654,   641,   642,  4042,   602,   482,  4045,
     654,   654,   166,   587,   587,   654,  4684,  4053,   619,   655,
     654,   619,   132,   654,  3967,   263,    20,   288,  4696,   263,
    4698,   370,  4632,   530,   631,   176,   190,   475,  4074,  4075,
    4739,   549,   465,    63,  4712,   654,   656,   655,   655,   203,
     384,  4719,   313,  4089,  4090,   545,  4092,  4093,   602,    36,
     466,   215,   654,   654,   250,   377,   366,  4766,   542,   654,
     161,   614,   580,   628,    33,   655,   371,   663,   526,   176,
     566,   142,  4750,  4751,   142,   654,   560,  4755,   164,   419,
      75,   197,    69,   197,   602,   655,   604,   628,   654,   587,
     654,   199,    33,  4042,  4140,    65,   384,    65,   587,   398,
     279,  4711,   266,   655,   268,  4151,   654,   656,   546,   655,
    4156,     6,   440,   655,   250,   160,   660,    12,    49,    14,
     384,    16,   384,   654,    49,    49,  4075,   159,    49,    49,
     654,   295,    27,   654,    29,   140,   149,     5,   377,  4185,
    4186,   377,  4188,   655,   160,   234,   293,   418,   628,   660,
     663,   131,   139,   286,    12,   654,   427,    49,    49,    49,
     136,   155,   543,   602,    59,   660,  4212,    55,   475,    64,
      65,   442,   160,   477,   567,   656,    71,   164,  4788,   655,
     655,   168,   656,   216,   656,   232,   655,  4140,    83,   460,
     660,   656,   655,   332,   263,    55,    91,   361,   454,  4245,
     197,  4247,    49,   567,   197,   197,   101,   630,   235,   132,
     371,   350,   198,   654,   494,  2362,   656,   204,  4161,  2673,
    3789,  3510,  2565,   118,  1040,  4368,  3901,  4256,  4387,  4588,
    3899,  4277,  1060,   504,   992,  4589,   507,   132,   225,  3903,
     135,  4766,  4073,  4727,    48,   601,  1930,  1862,   143,   144,
    2828,  3995,   416,   240,  3995,   150,  3995,  3995,  4304,  3995,
    3995,  3995,  3995,   158,   535,  3995,  4736,   162,  3995,   164,
    4602,  4413,  4602,  3995,  4539,  3995,  3995,  4439,  4438,  1104,
     175,  1582,  1831,  4260,  4082,  2635,   557,  4222,  4223,  2116,
    3447,  4226,  4227,  4228,  4229,  2857,  3612,  3285,  2862,  4358,
     195,   288,  1372,  3615,  4671,  4463,  4629,  4569,  4231,  1619,
     633,   692,  4358,  3908,  4043,  2628,   697,  3360,  3075,  3679,
    3078,  2636,  4368,  3921,  3928,  4690,   313,  4409,  4374,  3174,
    3739,  4116,  4461,  3773,  3977,   606,   231,  4480,   233,  3966,
    3231,  2536,   237,   482,   239,  3223,  2781,  3228,  4393,    11,
      11,  2192,   247,   734,  4510,  4330,  4511,  4339,  4343,  2699,
    3395,  4188,  4124,  2635,  1020,  3071,  2506,   262,  3933,  2123,
     751,  1073,  1516,  2432,  4327,  4445,  3697,  1615,  1920,  2843,
    3280,  2405,  2318,  1594,  2453,  3997,  1944,   622,   236,  3245,
     941,   286,  2227,  4328,  4289,  2814,  2521,  2223,  3343,  4445,
    2515,  2317,  4250,   542,  4450,  4068,  4583,  3506,  4361,  4362,
    4584,  1144,  2343,  4459,   795,   796,   797,   798,  3710,  1171,
    1533,   560,  2932,  3887,  4567,   320,   807,  3067,  4363,  4364,
    4711,   418,  3876,  2196,  4480,  2458,  1355,  4372,  2436,  2399,
     427,  3618,  1385,   338,  1044,  3299,  3298,   342,   296,  3352,
     298,   299,   300,   301,   302,   442,   304,   305,   306,   307,
     308,   309,   310,   311,   312,  4459,   314,   315,   316,  1044,
    1044,   612,  1044,   460,  1636,   688,  1464,  2023,   600,  2024,
    3716,  2500,   600,  1851,  1392,  3283,  4669,   382,  4487,  4706,
    4579,  4782,   387,  4787,   784,  3968,  1422,  4450,  2483,   394,
    3304,   396,  3332,   599,  1784,  3333,   401,   599,  2476,   404,
    1970,  2469,  2475,   585,   895,  1901,   833,   504,  4471,  4472,
     507,  4567,  1412,   593,   921,  2448,  1347,  2830,  4032,  1627,
    4038,   594,   928,   630,  1040,    -1,   630,  4583,  4584,   630,
     435,    -1,    -1,  1040,    -1,    -1,  1040,    -1,   535,    -1,
      -1,    -1,    -1,    -1,   449,   450,   451,   452,    -1,    -1,
      -1,  4607,    -1,    -1,    -1,    -1,    -1,   554,  4614,    -1,
     557,   558,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   476,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   444,   445,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   606,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4773,    -1,    -1,    -1,    -1,    -1,    -1,   532,   533,   534,
      -1,    -1,    -1,    -1,   539,    -1,    -1,    -1,    -1,  4695,
      -1,    -1,    -1,    -1,  4700,    -1,    -1,    -1,    -1,    -1,
     555,    -1,    -1,   697,   559,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   578,    -1,    -1,    -1,    -1,   583,    -1,
      -1,    -1,    -1,  4739,    -1,    -1,    -1,    -1,    -1,    -1,
     734,   596,    -1,    -1,    -1,  1086,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   751,  4764,    -1,
    4766,    -1,    -1,    -1,    -1,    -1,    -1,  4773,    -1,    -1,
      -1,  4777,    -1,    -1,  4687,    -1,  4782,    -1,    -1,    -1,
      -1,  4787,  1123,  1124,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1132,  1133,  1134,  1135,  1136,  1137,  1138,  1139,  1140,
    1141,  1142,  1143,    -1,   798,   660,    -1,    -1,    -1,    -1,
      -1,  1152,  1153,    -1,  1155,  1156,    -1,    -1,    -1,  1160,
      -1,    -1,  1163,  1164,  1165,  1166,    -1,  1168,  1169,  1170,
      -1,    -1,    -1,    -1,    -1,    -1,  1177,  1178,    -1,  1180,
    1181,  1182,  1183,  1184,    -1,    -1,  1187,  1188,  1189,  1190,
    1191,  1192,  1193,  1194,  1195,  1196,  1197,    -1,  1199,    -1,
      -1,  1202,  1203,    -1,    -1,    -1,  1207,    -1,    -1,    -1,
    1211,  1212,  1213,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1223,  1224,  1225,    -1,    -1,    -1,    -1,    -1,
      -1,  1232,    -1,    -1,    -1,    -1,    -1,    -1,  1239,  1240,
    1241,   895,  1243,    -1,    -1,    -1,    -1,    -1,    -1,  1250,
    1251,  1252,    -1,  1254,  1255,  1256,  1257,  1258,    -1,  1260,
    1261,  1262,  1263,  1264,  1265,  1266,  1267,    -1,    -1,    -1,
    1271,  1272,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1359,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      27,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1422,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1432,  1086,    -1,    61,    62,    -1,    64,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    73,  1448,    -1,    -1,
      -1,  1452,    -1,    -1,    -1,    -1,    83,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    91,    -1,    -1,    -1,    -1,  1123,
    1124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1132,  1133,
      -1,    -1,  1136,  1137,  1138,  1139,  1140,  1141,  1142,  1143,
      -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,  1152,  1153,
      -1,  1155,  1156,    -1,    -1,   132,  1507,    -1,   135,  1163,
    1164,  1165,  1166,    -1,    -1,  1169,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1177,  1178,    -1,  1180,  1181,    -1,    -1,
      -1,    -1,    -1,  1187,  1188,  1189,    -1,   164,  1192,  1193,
    1194,  1195,  1196,  1197,    -1,  1199,    -1,    -1,  1202,  1203,
      -1,    -1,    -1,  1207,    -1,    -1,    -1,  1211,  1212,  1213,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1223,
    1224,  1225,    -1,    -1,    -1,    -1,    -1,    -1,  1232,    -1,
      -1,    -1,    -1,    -1,    -1,  1239,  1240,  1241,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   231,    -1,   233,    -1,    -1,    -1,
      -1,    -1,   239,    -1,    -1,    -1,    -1,    -1,  1272,    -1,
     247,    -1,    -1,    -1,    -1,    -1,    -1,    27,    -1,    29,
      -1,    -1,    -1,    -1,    -1,   262,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1649,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    61,    62,    -1,    64,    -1,    -1,    27,    -1,    29,
      -1,    -1,    -1,    73,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,    -1,   320,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    61,    62,    -1,    64,  1359,    -1,    -1,    -1,    -1,
      -1,   338,    -1,    73,    -1,    -1,    -1,    -1,   118,    -1,
      -1,    -1,    -1,    83,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    91,   132,    -1,    -1,   135,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,
      -1,  1762,  1763,  1764,   164,    -1,    -1,   394,  1422,   396,
      -1,    -1,   132,    -1,    -1,   135,  1777,   404,  1432,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1448,    -1,    -1,    -1,  1452,    -1,
      -1,    -1,  1803,    -1,   164,    -1,    -1,    -1,  1809,    -1,
      -1,  1812,    -1,  1814,    -1,    -1,    -1,    -1,    -1,  1820,
      -1,  1822,  1823,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   231,    -1,   233,    -1,    -1,    -1,    -1,    -1,   239,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   247,    -1,   476,
      -1,    -1,    -1,  1507,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   262,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   231,    -1,   233,    -1,    -1,   276,    -1,    -1,   239,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   247,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   262,    -1,    -1,   532,   533,   534,    -1,    -1,
      -1,    -1,   539,    -1,  1915,    -1,    -1,    -1,    -1,    -1,
     320,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   555,    -1,
      -1,    -1,   559,    -1,    14,    -1,    16,    -1,   338,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   578,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
     320,    -1,    -1,    -1,    -1,    -1,    -1,  1968,    -1,   596,
      -1,    51,    52,    -1,    -1,    -1,  1977,    -1,   338,    59,
      -1,    -1,    -1,    -1,    64,    65,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   394,  1649,   396,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   404,    85,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   104,    -1,    -1,    -1,    -1,   656,
      -1,    -1,    -1,    -1,   394,    -1,   396,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   404,    -1,    -1,    -1,   128,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   136,   137,   138,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   149,
     150,    -1,    -1,    -1,    -1,    -1,   476,    -1,    -1,    -1,
      -1,    -1,   162,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   177,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1762,  1763,
    1764,    -1,    -1,    -1,   194,  2116,   476,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   209,
      -1,   211,   532,   533,   534,    -1,   216,  2138,    -1,   539,
     220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1803,
      -1,    -1,    -1,    -1,    -1,   555,    -1,    -1,  1812,   559,
    1814,    -1,    -1,    -1,    -1,    -1,   246,    -1,   248,    -1,
      -1,    -1,   532,   533,   534,    -1,    -1,    -1,   578,   539,
      -1,    -1,    -1,    -1,   264,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   555,   596,    -1,    -1,   559,
      -1,    -1,   282,    -1,  2205,    -1,   286,    -1,  2209,    -1,
      -1,    -1,    -1,  2214,  2215,    -1,    -1,    -1,   578,    -1,
      -1,    -1,  2223,    -1,  2225,    -1,  2227,  2228,  2229,  2230,
      -1,    -1,  2233,    -1,    -1,    -1,   596,    -1,    -1,    -1,
      -1,    -1,  2243,    -1,  2245,  2246,    -1,  2248,  2249,  2250,
    2251,    -1,  2253,    -1,   654,  2256,    -1,    -1,    -1,    -1,
      -1,  1915,    -1,    -1,  2265,    -1,    -1,    -1,    -1,    -1,
      -1,  2272,    -1,  2274,    -1,  2276,  2277,    -1,  2279,  2280,
      -1,    -1,    -1,  2284,  2285,  2286,    -1,    -1,    -1,  2290,
    2291,  2292,    -1,  2294,    -1,  2296,    -1,  2298,    -1,  2300,
      -1,  2302,   382,    -1,    -1,    -1,  2307,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1968,    -1,    -1,    -1,    -1,   399,
      -1,   401,    -1,    -1,    -1,  2326,    -1,    -1,    -1,    -1,
      -1,    -1,  2333,    -1,   414,  2336,    -1,    -1,    -1,    -1,
      -1,  2342,    -1,    -1,  2345,   425,    -1,    -1,  2349,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   447,    -1,    -1,
     450,    -1,   452,    -1,    -1,   455,    -1,    -1,   458,   459,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   469,
      -1,    -1,   472,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     480,    -1,    -1,    -1,    -1,    -1,   486,    -1,    -1,    -1,
      -1,    -1,  2413,    -1,   494,    -1,    -1,    -1,    -1,   499,
     500,   501,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    35,
      36,    -1,    -1,    -1,    -1,    41,    -1,    43,    -1,    45,
      46,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   531,    -1,    -1,    -1,    -1,    62,    -1,   538,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2484,  2138,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   583,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   119,    -1,   595,   122,    -1,    -1,   599,
      -1,    -1,   602,    -1,   130,    -1,    -1,    -1,   608,    -1,
      -1,    -1,    -1,    -1,  2535,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   148,    -1,    -1,    -1,    -1,  2548,    -1,    -1,
      -1,  2205,    -1,    -1,    -1,  2209,    -1,    -1,   638,   165,
    2214,  2215,    -1,    -1,   644,  2566,  2567,    -1,    -1,  2223,
      -1,  2225,    -1,  2227,   654,  2229,  2230,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   191,    -1,   193,    -1,  2243,
      -1,  2245,    -1,    -1,  2248,  2249,  2250,  2251,    -1,  2253,
     206,   207,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  2265,    -1,    -1,    -1,    -1,    -1,    -1,  2272,    -1,
    2274,    -1,  2276,  2277,    -1,  2279,    -1,  2628,    -1,    -1,
    2284,  2285,  2286,    -1,    -1,    -1,  2290,  2291,  2292,    -1,
    2294,    -1,  2296,    -1,  2298,   251,  2300,    -1,  2302,    -1,
      -1,    -1,    -1,  2307,    -1,    14,    -1,    16,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2326,    -1,   280,  2676,  2677,    -1,    37,    -1,
      -1,    -1,    -1,   289,   290,    -1,   292,    -1,  2342,    -1,
      -1,  2345,    51,    52,    -1,    -1,    -1,    -1,    -1,    -1,
      59,    -1,    -1,    -1,    -1,    64,    65,    -1,    -1,    -1,
      -1,  2712,    -1,    -1,    -1,  2716,    -1,    -1,    -1,    -1,
     326,   327,   328,    -1,    -1,    -1,    85,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   345,
     346,   347,  2743,  2744,    -1,   104,    -1,   353,    -1,    -1,
     356,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2763,    -1,    -1,    -1,    -1,   373,   374,   128,
      -1,  2772,    -1,  2774,    -1,  2776,    -1,   136,   137,   138,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     149,   150,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  2803,   409,   410,    -1,    -1,  2808,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   177,    -1,
      -1,    -1,    -1,    -1,    -1,    13,    -1,    -1,   434,    -1,
    2484,    -1,    -1,    -1,    -1,   194,    -1,    25,  2839,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    36,    37,
     209,    -1,   211,    -1,    -1,    -1,    -1,   216,    -1,    -1,
      -1,   220,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    61,    62,    -1,    -1,    -1,    -1,    -1,
      -1,    69,    -1,    -1,   490,    -1,    74,   246,   494,   248,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   508,    -1,    -1,   264,    -1,    -1,    -1,    -1,
      -1,    -1,   100,  2914,   102,    -1,   104,    -1,    -1,    -1,
      -1,    -1,    -1,   282,    -1,    -1,    -1,   286,   116,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   137,
     138,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   565,
      -1,    -1,   568,    -1,  2965,   571,   572,   573,   574,    -1,
      -1,    -1,    -1,    -1,    -1,   163,   164,    -1,    -1,  2980,
      -1,   169,    -1,    -1,   172,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   615,
     616,    -1,   200,    -1,   202,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   210,   382,   212,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   642,    -1,    -1,    -1,
     399,    -1,   401,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     238,   239,   240,    -1,    -1,   414,    -1,    -1,  2712,    -1,
      -1,    -1,  2716,    -1,    -1,    -1,   425,    -1,    -1,    -1,
    3071,    -1,    -1,   261,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3084,  3085,    -1,    -1,    -1,   447,  2743,
    2744,   450,    -1,   452,    -1,   283,   455,    -1,    -1,   458,
     459,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2763,
     469,    -1,    -1,   472,    -1,    -1,    -1,    -1,  2772,    -1,
    2774,   480,  2776,    -1,    -1,   313,    -1,   486,    -1,    -1,
      -1,    -1,  3133,    -1,    -1,   494,    -1,    -1,    -1,    -1,
     499,   500,   501,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3156,    -1,    -1,    -1,    -1,
      -1,    27,    -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   531,    -1,    -1,    -1,    -1,    -1,    -1,   538,
      -1,    -1,    -1,    -1,    -1,  2839,    -1,  3188,  3189,    -1,
    3191,    -1,    -1,   381,    -1,    -1,    -1,    -1,    64,  3200,
      -1,    -1,    -1,    -1,  3205,    -1,    -1,  3208,    -1,  3210,
    3211,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,   407,
      -1,    -1,    -1,    -1,   583,    91,    -1,    -1,    -1,    -1,
     418,   419,    -1,    -1,   422,   423,   595,    -1,    -1,    -1,
     599,    -1,  3243,   602,    -1,    -1,    -1,    -1,    -1,   608,
      -1,     6,   118,    -1,    -1,   443,    -1,    12,    -1,    14,
    2914,    -1,    -1,    -1,    -1,    -1,   132,    -1,    -1,   135,
      -1,    -1,    27,  3274,    29,    -1,    -1,    -1,    -1,   638,
      -1,    -1,    -1,    -1,    -1,   644,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   654,    -1,  3298,   164,    -1,
      -1,    -1,    -1,   491,    59,    -1,    -1,    -1,    -1,    64,
      -1,  2965,    -1,    -1,    -1,    -1,   504,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    83,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    91,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   101,   535,    -1,    -1,
      -1,   539,    -1,  3354,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   118,    -1,   231,    -1,   233,    -1,   557,
     558,    -1,    -1,   239,    -1,    -1,    -1,   132,    -1,    -1,
     135,   247,  3383,    -1,    -1,    -1,    -1,    -1,   143,    -1,
      -1,    -1,    -1,    -1,    -1,   150,   262,    -1,    -1,    -1,
      -1,    -1,    -1,   158,    -1,    -1,    -1,    -1,    -1,   164,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   606,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   617,
    3084,  3085,    -1,    -1,    -1,    -1,    -1,   625,    -1,    -1,
     195,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   320,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   338,    -1,    -1,    -1,   231,    -1,   233,    -1,
      -1,    -1,    -1,    -1,   239,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   247,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3156,    -1,    -1,    -1,    -1,   262,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   394,    -1,
     396,   286,    -1,    -1,  3188,  3189,    -1,    -1,   404,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3200,    -1,    -1,    -1,
      -1,  3205,    -1,    -1,  3208,    -1,  3210,  3211,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   320,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   338,    -1,    -1,    -1,   342,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     476,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3619,    -1,
    3274,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   387,    -1,    -1,    -1,    -1,    -1,    -1,   394,
      -1,   396,    -1,    -1,  3298,    -1,    -1,    -1,    -1,   404,
      -1,    -1,    -1,    -1,  3655,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3663,    -1,    -1,    -1,   532,   533,   534,    -1,
      -1,    -1,    -1,   539,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3684,    -1,    -1,    -1,    -1,    -1,   555,
      -1,    -1,    -1,   559,    -1,   450,    -1,    -1,    -1,    -1,
    3354,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   578,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   476,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     596,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3766,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   532,   533,   534,
      -1,    -1,    -1,    -1,   539,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     555,    -1,    -1,    -1,   559,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3818,    -1,    -1,
      -1,  3822,    -1,   578,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   596,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3857,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3871,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3908,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3619,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3977,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3995,    -1,    -1,    -1,    -1,    -1,
      -1,  3655,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3663,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3684,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4043,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4051,    -1,    -1,    -1,    -1,    -1,  4057,    -1,  4059,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4148,    -1,    -1,
      -1,    -1,    -1,  4154,  4155,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3818,    -1,    -1,    -1,  3822,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4187,    -1,    -1,    -1,
    4191,  4192,    -1,    -1,    -1,    -1,    -1,  4198,    -1,    -1,
      -1,    -1,    -1,  3857,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3871,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4236,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4297,    -1,  4299,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4309,    -1,
    4311,  4312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4330,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4339,    -1,
      -1,    -1,  4343,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4395,    -1,    -1,  4051,    -1,    -1,
      -1,    -1,    -1,  4057,    -1,  4059,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4418,    -1,  4420,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4435,  4436,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4453,    -1,    -1,    -1,    -1,    -1,    -1,  4460,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4148,    -1,    -1,    -1,    -1,    -1,
      -1,  4502,    -1,    -1,    -1,    -1,    -1,  4508,    -1,  4510,
    4511,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4525,  4526,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4538,  4539,    -1,
      -1,    -1,    -1,    -1,  4198,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4561,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4236,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4605,    -1,    -1,    -1,    -1,    -1,
      -1,  4612,    -1,    -1,  4615,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4297,    -1,  4299,    -1,    -1,    -1,  4650,
      -1,    -1,    -1,    -1,    -1,  4309,  4657,    -1,  4659,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4671,    -1,    -1,  4674,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4684,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4694,    -1,  4696,    -1,  4698,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4712,    -1,    -1,    -1,    -1,    -1,    -1,  4719,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4734,  4735,    -1,    -1,    -1,    -1,  4740,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4750,
    4751,    -1,    -1,    -1,  4755,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4418,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4436,    -1,    -1,    -1,    -1,    -1,    -1,  4790,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4460,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4525,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4612,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4650,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4674,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    47,    48,  4740,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,  4790,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,   191,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
      -1,   204,   205,   206,   207,   208,   209,   210,    -1,   212,
      -1,   214,    -1,   216,   217,   218,    -1,   220,   221,   222,
      -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,   232,
     233,   234,    -1,   236,   237,   238,    -1,   240,    -1,   242,
      -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,
      -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,
      -1,    -1,   265,   266,   267,    -1,   269,   270,    -1,   272,
     273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,
     283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,
     333,   334,    -1,    -1,   337,   338,   339,   340,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,    -1,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,   372,
      -1,   374,   375,   376,    -1,   378,   379,   380,   381,    -1,
     383,   384,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     393,   394,   395,    -1,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
      -1,   414,   415,   416,    -1,   418,    -1,   420,   421,   422,
     423,   424,    -1,   426,   427,   428,    -1,    -1,   431,    -1,
      -1,    -1,   435,   436,   437,   438,   439,    -1,    -1,   442,
     443,   444,   445,   446,    -1,   448,   449,    -1,   451,   452,
     453,   454,   455,   456,    -1,   458,    -1,   460,   461,    -1,
     463,   464,    -1,   466,    -1,   468,    -1,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
      -1,   484,   485,    -1,    -1,    -1,   489,   490,   491,   492,
      -1,    -1,    -1,   496,    -1,    -1,    -1,   500,    -1,   502,
     503,   504,   505,   506,   507,    -1,   509,   510,   511,   512,
     513,   514,    -1,    -1,    -1,    -1,    -1,    -1,   521,   522,
      -1,   524,    -1,    -1,   527,    -1,    -1,   530,   531,    -1,
      -1,    -1,   535,   536,   537,   538,   539,    -1,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,    -1,   557,    -1,   559,   560,   561,   562,
      -1,   564,   565,   566,    -1,   568,   569,   570,   571,    -1,
      -1,    -1,    -1,   576,   577,   578,   579,    -1,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
      -1,   594,   595,    -1,    -1,   598,    -1,    -1,   601,    -1,
     603,    -1,   605,   606,   607,    -1,    -1,   610,   611,   612,
     613,   614,    -1,    -1,   617,   618,    -1,   620,   621,   622,
     623,   624,   625,   626,   627,    -1,    -1,    -1,    -1,    -1,
      -1,   634,   635,    -1,   637,   638,   639,    -1,    -1,   642,
      -1,    -1,    -1,    -1,   647,   648,    -1,    -1,    -1,    -1,
     653,   654,    -1,    -1,   657,   658,    -1,    -1,   661,   662,
       5,    -1,     7,     8,     9,    10,    11,    12,    13,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,   214,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,   234,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,   272,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,   339,   340,    -1,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,    -1,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,   372,    -1,   374,
     375,   376,   377,   378,   379,   380,   381,    -1,   383,   384,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,
     395,    -1,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,    -1,   414,
     415,   416,    -1,   418,    -1,   420,   421,   422,   423,   424,
      -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,   439,    -1,    -1,   442,   443,   444,
     445,   446,    -1,   448,   449,    -1,   451,   452,   453,   454,
     455,   456,    -1,   458,    -1,   460,   461,    -1,   463,   464,
      -1,   466,    -1,   468,    -1,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,    -1,   484,
     485,    -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,
      -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,    -1,   509,   510,   511,   512,   513,   514,
      -1,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,
      -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,
     535,   536,   537,   538,   539,    -1,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,    -1,   557,    -1,   559,   560,   561,   562,    -1,   564,
     565,   566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,
      -1,    -1,   577,   578,   579,    -1,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,    -1,   594,
     595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,
     605,   606,   607,    -1,    -1,   610,   611,   612,   613,   614,
      -1,    -1,   617,   618,    -1,   620,   621,   622,   623,   624,
     625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,
     635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,    -1,
      -1,    -1,   647,   648,    -1,    -1,    -1,    -1,   653,   654,
      -1,    -1,   657,   658,    -1,    -1,   661,   662,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,    -1,   106,
     107,   108,   109,   110,   111,    -1,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,   178,    -1,   180,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,
      -1,   198,   199,   200,    -1,   202,    -1,   204,   205,   206,
     207,   208,   209,   210,    -1,   212,    -1,   214,    -1,   216,
     217,   218,    -1,   220,   221,   222,    -1,   224,   225,    -1,
      -1,    -1,   229,   230,   231,   232,   233,   234,    -1,   236,
     237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,
     247,   248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,
     257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,
      -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,   330,   331,   332,   333,   334,    -1,    -1,
     337,   338,   339,   340,    -1,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,    -1,   355,   356,
     357,    -1,    -1,   360,   361,   362,   363,   364,   365,   366,
     367,   368,    -1,   370,   371,   372,    -1,   374,   375,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,    -1,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,   412,    -1,   414,   415,   416,
      -1,   418,    -1,   420,   421,   422,   423,   424,    -1,   426,
     427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,
     437,   438,   439,    -1,    -1,   442,   443,   444,   445,   446,
      -1,   448,   449,    -1,   451,   452,   453,   454,   455,   456,
      -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,   466,
      -1,   468,    -1,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,    -1,   484,   485,    -1,
      -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,   496,
      -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,   506,
     507,    -1,   509,   510,   511,   512,   513,   514,    -1,    -1,
      -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,    -1,
     527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,   536,
     537,   538,   539,    -1,   541,   542,   543,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,    -1,
     557,    -1,   559,   560,   561,   562,    -1,   564,   565,   566,
      -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,    -1,
     577,   578,   579,    -1,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,    -1,   594,   595,    -1,
      -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,   606,
     607,    -1,    -1,   610,   611,   612,   613,   614,    -1,    -1,
     617,   618,    -1,   620,   621,   622,   623,   624,   625,   626,
     627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,    -1,
     637,   638,   639,    -1,    -1,   642,    -1,    -1,    -1,    -1,
     647,   648,    -1,    -1,    -1,    -1,   653,   654,    -1,    -1,
     657,   658,    -1,    -1,   661,   662,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,
     199,   200,    -1,   202,    -1,   204,   205,   206,   207,   208,
     209,   210,    -1,   212,    -1,   214,    -1,   216,   217,   218,
      -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,
     229,   230,   231,   232,   233,   234,    -1,   236,   237,   238,
      -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,
     249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,
      -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,
      -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,
      -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,
     329,   330,   331,   332,   333,   334,    -1,    -1,   337,   338,
     339,   340,    -1,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,    -1,   355,   356,   357,    -1,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,   372,    -1,   374,   375,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   393,   394,   395,    -1,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,   407,   408,
     409,   410,   411,   412,    -1,   414,   415,   416,    -1,   418,
      -1,   420,   421,   422,   423,   424,    -1,   426,   427,   428,
      -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,
     439,    -1,    -1,   442,   443,   444,   445,   446,    -1,   448,
     449,    -1,   451,   452,   453,   454,   455,   456,    -1,   458,
      -1,   460,   461,    -1,   463,   464,    -1,   466,    -1,   468,
      -1,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,    -1,   484,   485,    -1,    -1,    -1,
     489,   490,   491,   492,    -1,    -1,    -1,   496,    -1,    -1,
      -1,   500,    -1,   502,   503,   504,   505,   506,   507,    -1,
     509,   510,   511,   512,   513,   514,    -1,    -1,    -1,    -1,
      -1,    -1,   521,   522,    -1,   524,    -1,    -1,   527,    -1,
      -1,   530,   531,    -1,    -1,    -1,   535,   536,   537,   538,
     539,    -1,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,    -1,   557,    -1,
     559,   560,   561,   562,    -1,   564,   565,   566,    -1,   568,
     569,   570,   571,    -1,    -1,    -1,    -1,    -1,   577,   578,
     579,    -1,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,    -1,   594,   595,    -1,    -1,   598,
      -1,    -1,   601,    -1,   603,    -1,   605,   606,   607,    -1,
      -1,   610,   611,   612,   613,   614,    -1,    -1,   617,   618,
      -1,   620,   621,   622,   623,   624,   625,   626,   627,    -1,
      -1,    -1,    -1,    -1,    -1,   634,   635,    -1,   637,   638,
     639,    -1,    -1,   642,    -1,    -1,    -1,    -1,   647,   648,
      -1,    -1,    -1,    -1,   653,   654,    -1,    -1,   657,   658,
      -1,    -1,   661,   662,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
     191,   192,    -1,   194,    -1,    -1,    -1,   198,   199,   200,
      -1,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
      -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,   220,
     221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,
     231,   232,   233,   234,    -1,   236,   237,   238,    -1,   240,
      -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,
      -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,
      -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,
     281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,
     331,   332,   333,   334,    -1,    -1,   337,   338,   339,   340,
      -1,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,    -1,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,   372,    -1,   374,   375,   376,    -1,   378,   379,   380,
     381,    -1,   383,   384,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   393,   394,   395,    -1,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,   412,    -1,   414,   415,   416,    -1,   418,    -1,   420,
     421,   422,   423,   424,    -1,   426,   427,   428,    -1,    -1,
     431,    -1,    -1,    -1,   435,   436,   437,   438,   439,    -1,
      -1,   442,   443,   444,   445,   446,    -1,   448,   449,    -1,
     451,   452,   453,   454,   455,   456,    -1,   458,    -1,   460,
     461,    -1,   463,   464,    -1,   466,    -1,   468,    -1,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,    -1,   484,   485,    -1,    -1,    -1,   489,   490,
     491,   492,    -1,    -1,    -1,   496,    -1,    -1,    -1,   500,
      -1,   502,   503,   504,   505,   506,   507,    -1,   509,   510,
     511,   512,   513,   514,    -1,    -1,    -1,    -1,    -1,    -1,
     521,   522,    -1,   524,    -1,    -1,   527,    -1,    -1,   530,
     531,    -1,    -1,    -1,   535,   536,   537,   538,   539,    -1,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,    -1,   557,    -1,   559,   560,
     561,   562,    -1,   564,   565,   566,    -1,   568,   569,   570,
     571,    -1,    -1,    -1,    -1,    -1,   577,   578,   579,    -1,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,    -1,   594,   595,    -1,    -1,   598,    -1,    -1,
     601,    -1,   603,    -1,   605,   606,   607,    -1,    -1,   610,
     611,   612,   613,   614,    -1,    -1,   617,   618,    -1,   620,
     621,   622,   623,   624,   625,   626,   627,    -1,    -1,    -1,
      -1,    -1,    -1,   634,   635,    -1,   637,   638,   639,    -1,
      -1,   642,    -1,    -1,    -1,    -1,   647,   648,    -1,    -1,
      -1,    -1,   653,   654,    -1,    -1,   657,   658,    -1,    -1,
     661,   662,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,   191,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
      -1,   204,   205,   206,   207,   208,   209,   210,    -1,   212,
      -1,   214,    -1,   216,   217,   218,    -1,   220,   221,   222,
      -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,   232,
     233,   234,    -1,   236,   237,   238,    -1,   240,    -1,   242,
      -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,
      -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,
      -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,
     273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,
     283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,
     333,   334,    -1,    -1,   337,   338,   339,   340,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,    -1,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,   372,
      -1,   374,   375,   376,    -1,   378,   379,   380,   381,    -1,
     383,   384,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     393,   394,   395,    -1,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
      -1,   414,   415,   416,    -1,   418,    -1,   420,   421,   422,
     423,   424,    -1,   426,   427,   428,    -1,    -1,   431,    -1,
      -1,    -1,   435,   436,   437,   438,   439,    -1,    -1,   442,
     443,   444,   445,   446,    -1,   448,   449,    -1,   451,   452,
     453,   454,   455,   456,    -1,   458,    -1,   460,   461,    -1,
     463,   464,    -1,   466,    -1,   468,    -1,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
      -1,   484,   485,    -1,    -1,    -1,   489,   490,   491,   492,
      -1,    -1,    -1,   496,    -1,    -1,    -1,   500,    -1,   502,
     503,   504,   505,   506,   507,    -1,   509,   510,   511,   512,
     513,   514,    -1,    -1,    -1,    -1,    -1,    -1,   521,   522,
      -1,   524,    -1,    -1,   527,    -1,    -1,   530,   531,    -1,
      -1,    -1,   535,   536,   537,   538,   539,    -1,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,    -1,   557,    -1,   559,   560,   561,   562,
      -1,   564,   565,   566,    -1,   568,   569,   570,   571,    -1,
      -1,    -1,    -1,    -1,   577,   578,   579,    -1,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
      -1,   594,   595,    -1,    -1,   598,    -1,    -1,   601,    -1,
     603,    -1,   605,   606,   607,    -1,    -1,   610,   611,   612,
     613,   614,    -1,    -1,   617,   618,    -1,   620,   621,   622,
     623,   624,   625,   626,   627,    -1,    -1,    -1,    -1,    -1,
      -1,   634,   635,    -1,   637,   638,   639,    -1,    -1,   642,
      -1,    -1,    -1,    -1,   647,   648,    -1,    -1,    -1,    -1,
     653,   654,    -1,    -1,   657,   658,    -1,    -1,   661,   662,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,   214,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,   234,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,   272,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,   339,   340,    -1,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,    -1,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,   372,    -1,   374,
     375,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,
     395,    -1,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,    -1,   414,
     415,   416,    -1,   418,    -1,   420,   421,   422,   423,   424,
      -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,   439,    -1,    -1,   442,   443,   444,
     445,   446,    -1,   448,   449,    -1,   451,   452,   453,   454,
     455,   456,    -1,   458,    -1,   460,   461,    -1,   463,   464,
      -1,   466,    -1,   468,    -1,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,    -1,   484,
     485,    -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,
      -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,    -1,   509,   510,   511,   512,   513,   514,
      -1,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,
      -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,
     535,   536,   537,   538,   539,    -1,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,    -1,   557,    -1,   559,   560,   561,   562,    -1,   564,
     565,   566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,
      -1,    -1,   577,   578,   579,    -1,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,    -1,   594,
     595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,
     605,   606,   607,    -1,    -1,   610,   611,   612,   613,   614,
      -1,    -1,   617,   618,    -1,   620,   621,   622,   623,   624,
     625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,
     635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,    -1,
      -1,    -1,   647,   648,    -1,    -1,    -1,    -1,   653,   654,
      -1,    -1,   657,   658,    -1,    -1,   661,   662,     5,    -1,
       7,     8,     9,    10,    11,    12,    13,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,    -1,   106,
     107,   108,   109,   110,   111,    -1,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,   178,    -1,   180,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,   206,
     207,   208,   209,   210,    -1,   212,    -1,   214,    -1,   216,
     217,   218,    -1,   220,   221,   222,    -1,   224,   225,    -1,
      -1,    -1,   229,   230,   231,   232,   233,   234,    -1,   236,
     237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,
     247,   248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,
     257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,
      -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,    -1,    -1,
      -1,    -1,   329,   330,   331,   332,   333,   334,    -1,    -1,
     337,   338,   339,   340,    -1,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,    -1,   355,   356,
     357,    -1,    -1,   360,   361,   362,   363,   364,    -1,   366,
     367,   368,    -1,   370,   371,   372,    -1,   374,   375,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,    -1,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,   412,    -1,   414,   415,   416,
      -1,   418,    -1,   420,   421,   422,   423,   424,    -1,   426,
     427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,
     437,   438,   439,    -1,    -1,   442,   443,   444,   445,   446,
      -1,   448,   449,    -1,   451,   452,   453,   454,   455,   456,
      -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,   466,
      -1,   468,    -1,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,    -1,   484,   485,    -1,
      -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,   496,
      -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,   506,
     507,    -1,   509,   510,   511,   512,   513,   514,    -1,    -1,
      -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,    -1,
     527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,   536,
     537,   538,   539,    -1,   541,   542,   543,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,    -1,
     557,    -1,   559,   560,   561,   562,    -1,   564,   565,   566,
      -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,    -1,
     577,   578,   579,    -1,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,    -1,   594,   595,    -1,
      -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,   606,
     607,    -1,    -1,   610,   611,   612,   613,   614,    -1,    -1,
     617,   618,    -1,   620,   621,   622,   623,   624,   625,   626,
     627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,    -1,
     637,   638,   639,    -1,    -1,   642,    -1,    -1,    -1,    -1,
     647,   648,    -1,    -1,    -1,    -1,   653,   654,    -1,    -1,
     657,   658,    -1,    -1,   661,   662,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,    -1,   204,   205,   206,   207,   208,
     209,   210,    -1,   212,    -1,   214,    -1,   216,   217,   218,
      -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,
     229,   230,   231,   232,   233,   234,    -1,   236,   237,   238,
      -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,
     249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,
      -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,
      -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,
      -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,
     329,   330,   331,   332,   333,   334,    -1,    -1,   337,   338,
     339,   340,    -1,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,    -1,   355,   356,   357,    -1,
      -1,   360,   361,   362,   363,   364,   365,   366,   367,   368,
      -1,   370,   371,   372,    -1,   374,   375,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   393,   394,   395,    -1,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,   407,   408,
     409,   410,   411,   412,    -1,   414,   415,   416,    -1,   418,
      -1,   420,   421,   422,   423,   424,    -1,   426,   427,   428,
      -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,
     439,    -1,    -1,   442,   443,   444,   445,   446,    -1,   448,
     449,    -1,   451,   452,   453,   454,   455,   456,    -1,   458,
      -1,   460,   461,    -1,   463,   464,    -1,   466,    -1,   468,
      -1,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,    -1,   484,   485,    -1,    -1,    -1,
     489,   490,   491,   492,    -1,    -1,    -1,   496,    -1,    -1,
      -1,   500,    -1,   502,   503,   504,   505,   506,   507,    -1,
     509,   510,   511,   512,   513,   514,    -1,    -1,    -1,    -1,
      -1,    -1,   521,   522,    -1,   524,    -1,    -1,   527,    -1,
      -1,   530,   531,    -1,    -1,    -1,   535,   536,   537,   538,
     539,    -1,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,    -1,   557,    -1,
     559,   560,   561,   562,    -1,   564,   565,   566,    -1,   568,
     569,   570,   571,    -1,    -1,    -1,    -1,    -1,   577,   578,
     579,    -1,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,    -1,   594,   595,    -1,    -1,   598,
      -1,    -1,   601,    -1,   603,    -1,   605,   606,   607,    -1,
      -1,   610,   611,   612,   613,   614,    -1,    -1,   617,   618,
      -1,   620,   621,   622,   623,   624,   625,   626,   627,    -1,
      -1,    -1,    -1,    -1,    -1,   634,   635,    -1,   637,   638,
     639,    -1,    -1,   642,    -1,    -1,    -1,    -1,   647,   648,
      -1,    -1,    -1,    -1,   653,   654,    -1,    -1,   657,   658,
      -1,    -1,   661,   662,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
     191,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
      -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,   220,
     221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,
     231,   232,   233,   234,    -1,   236,   237,   238,    -1,   240,
      -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,
      -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,
      -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,
     281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,
     331,   332,   333,   334,    -1,    -1,   337,   338,   339,   340,
      -1,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,    -1,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,   365,   366,   367,   368,    -1,   370,
     371,   372,    -1,   374,   375,   376,    -1,   378,   379,   380,
     381,    -1,   383,   384,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   393,   394,   395,    -1,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,   412,    -1,   414,   415,   416,    -1,   418,    -1,   420,
     421,   422,   423,   424,    -1,   426,   427,   428,    -1,    -1,
     431,    -1,    -1,    -1,   435,   436,   437,   438,   439,    -1,
      -1,   442,   443,   444,   445,   446,    -1,   448,   449,    -1,
     451,   452,   453,   454,   455,   456,    -1,   458,    -1,   460,
     461,    -1,   463,   464,    -1,   466,    -1,   468,    -1,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,    -1,   484,   485,    -1,    -1,    -1,   489,   490,
     491,   492,    -1,    -1,    -1,   496,    -1,    -1,    -1,   500,
      -1,   502,   503,   504,   505,   506,   507,    -1,   509,   510,
     511,   512,   513,   514,    -1,    -1,    -1,    -1,    -1,    -1,
     521,   522,    -1,   524,    -1,    -1,   527,    -1,    -1,   530,
     531,    -1,    -1,    -1,   535,   536,   537,   538,   539,    -1,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,    -1,   557,    -1,   559,   560,
     561,   562,    -1,   564,   565,   566,    -1,   568,   569,   570,
     571,    -1,    -1,    -1,    -1,    -1,   577,   578,   579,    -1,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,    -1,   594,   595,    -1,    -1,   598,    -1,    -1,
     601,    -1,   603,    -1,   605,   606,   607,    -1,    -1,   610,
     611,   612,   613,   614,    -1,    -1,   617,   618,    -1,   620,
     621,   622,   623,   624,   625,   626,   627,    -1,    -1,    -1,
      -1,    -1,    -1,   634,   635,    -1,   637,   638,   639,    -1,
      -1,   642,    -1,    -1,    -1,    -1,   647,   648,    -1,    -1,
      -1,    -1,   653,   654,    -1,    -1,   657,   658,    -1,    -1,
     661,   662,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,   191,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
      -1,   204,   205,   206,   207,   208,   209,   210,    -1,   212,
      -1,   214,    -1,   216,   217,   218,    -1,   220,   221,   222,
      -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,   232,
     233,   234,    -1,   236,   237,   238,    -1,   240,    -1,   242,
      -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,
      -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,
      -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,
     273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,
     283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,
     333,   334,    -1,    -1,   337,   338,   339,   340,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,    -1,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,   365,   366,   367,   368,    -1,   370,   371,   372,
      -1,   374,   375,   376,    -1,   378,   379,   380,   381,    -1,
     383,   384,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     393,   394,   395,    -1,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
      -1,   414,   415,   416,    -1,   418,    -1,   420,   421,   422,
     423,   424,    -1,   426,   427,   428,    -1,    -1,   431,    -1,
      -1,    -1,   435,   436,   437,   438,   439,    -1,    -1,   442,
     443,   444,   445,   446,    -1,   448,   449,    -1,   451,   452,
     453,   454,   455,   456,    -1,   458,    -1,   460,   461,    -1,
     463,   464,    -1,   466,    -1,   468,    -1,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
      -1,   484,   485,    -1,    -1,    -1,   489,   490,   491,   492,
      -1,    -1,    -1,   496,    -1,    -1,    -1,   500,    -1,   502,
     503,   504,   505,   506,   507,    -1,   509,   510,   511,   512,
     513,   514,    -1,    -1,    -1,    -1,    -1,    -1,   521,   522,
      -1,   524,    -1,    -1,   527,    -1,    -1,   530,   531,    -1,
      -1,    -1,   535,   536,   537,   538,   539,    -1,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,    -1,   557,    -1,   559,   560,   561,   562,
      -1,   564,   565,   566,    -1,   568,   569,   570,   571,    -1,
      -1,    -1,    -1,    -1,   577,   578,   579,    -1,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
      -1,   594,   595,    -1,    -1,   598,    -1,    -1,   601,    -1,
     603,    -1,   605,   606,   607,    -1,    -1,   610,   611,   612,
     613,   614,    -1,    -1,   617,   618,    -1,   620,   621,   622,
     623,   624,   625,   626,   627,    -1,    -1,    -1,    -1,    -1,
      -1,   634,   635,    -1,   637,   638,   639,    -1,    -1,   642,
      -1,    -1,    -1,    -1,   647,   648,    -1,    -1,    -1,    -1,
     653,   654,    -1,    -1,   657,   658,    -1,    -1,   661,   662,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    36,    37,    38,    39,    40,    41,    42,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      55,    56,    57,    58,    -1,    60,    61,    62,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,   101,   102,   103,    -1,
      -1,   106,   107,   108,   109,   110,   111,    -1,   113,   114,
     115,    -1,   117,   118,   119,   120,   121,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,   132,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,   178,    -1,   180,   181,   182,   183,   184,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,   214,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,   234,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,   246,   247,   248,   249,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,   272,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,   339,   340,    -1,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,    -1,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,   364,
     365,   366,   367,   368,    -1,   370,   371,   372,    -1,   374,
     375,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,
     395,    -1,   397,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,    -1,   414,
     415,   416,    -1,   418,    -1,   420,   421,   422,   423,   424,
      -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,   439,    -1,    -1,   442,   443,   444,
     445,   446,    -1,   448,   449,    -1,   451,   452,   453,   454,
     455,   456,    -1,   458,    -1,   460,   461,    -1,   463,   464,
      -1,   466,    -1,   468,    -1,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,    -1,   484,
     485,    -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,
      -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,    -1,   509,   510,   511,   512,   513,   514,
      -1,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,
      -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,
     535,   536,   537,   538,   539,    -1,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,    -1,   557,    -1,   559,   560,   561,   562,    -1,   564,
     565,   566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,
      -1,    -1,   577,   578,   579,    -1,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,    -1,   594,
     595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,
     605,   606,   607,    -1,    -1,   610,   611,   612,   613,   614,
      -1,    -1,   617,   618,    -1,   620,   621,   622,   623,   624,
     625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,
     635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,    -1,
      -1,    -1,   647,   648,    -1,    -1,    -1,    -1,   653,   654,
      -1,    -1,   657,   658,    -1,    -1,   661,   662,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,    -1,
      -1,    -1,    19,    -1,    -1,    22,    -1,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    36,
      37,    38,    39,    40,    41,    42,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    55,    56,
      57,    58,    -1,    60,    61,    62,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,   101,   102,   103,    -1,    -1,   106,
     107,   108,   109,   110,   111,    -1,   113,   114,   115,    -1,
     117,   118,   119,   120,   121,   122,    -1,    -1,    -1,    -1,
     127,   128,   129,    -1,    -1,   132,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,   178,    -1,   180,   181,   182,   183,   184,   185,   186,
     187,    -1,   189,   190,   191,   192,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,   206,
     207,   208,   209,   210,    -1,   212,    -1,   214,    -1,   216,
     217,   218,    -1,   220,   221,   222,    -1,   224,   225,    -1,
      -1,    -1,   229,   230,   231,   232,   233,   234,    -1,   236,
     237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,   246,
     247,   248,   249,    -1,    -1,   252,    -1,   254,   255,    -1,
     257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,   272,   273,   274,    -1,    -1,
      -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,
     287,   288,    -1,    -1,   291,    -1,    -1,    -1,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,   313,   314,   315,   316,
     317,   318,   319,   320,   321,   322,   323,   324,   325,    -1,
      -1,    -1,   329,   330,   331,   332,   333,   334,    -1,    -1,
     337,   338,   339,   340,    -1,   342,   343,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,    -1,   355,   356,
     357,    -1,    -1,   360,   361,   362,   363,   364,    -1,   366,
     367,   368,    -1,   370,   371,   372,    -1,   374,   375,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,    -1,
     397,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,   412,    -1,   414,   415,   416,
      -1,   418,    -1,   420,   421,   422,   423,   424,    -1,   426,
     427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,
     437,   438,   439,    -1,    -1,   442,   443,   444,   445,   446,
      -1,   448,   449,    -1,   451,   452,   453,   454,   455,   456,
      -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,   466,
      -1,   468,    -1,   470,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,    -1,   484,   485,    -1,
      -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,   496,
      -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,   506,
     507,    -1,   509,   510,   511,   512,   513,   514,    -1,    -1,
      -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,    -1,
     527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,   536,
     537,   538,   539,    -1,   541,   542,   543,   544,   545,   546,
     547,   548,   549,   550,   551,   552,   553,   554,   555,    -1,
     557,    -1,   559,   560,   561,   562,    -1,   564,   565,   566,
      -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,    -1,
     577,   578,   579,    -1,   581,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,    -1,   594,   595,    -1,
      -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,   606,
     607,    -1,    -1,   610,   611,   612,   613,   614,    -1,    -1,
     617,   618,    -1,   620,   621,   622,   623,   624,   625,   626,
     627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,    -1,
     637,   638,   639,    -1,    -1,   642,    -1,    -1,    -1,    -1,
     647,   648,    -1,    -1,    -1,    -1,   653,   654,    -1,    -1,
     657,   658,    -1,    -1,   661,   662,     5,    -1,     7,     8,
       9,    10,    11,    12,    -1,    -1,    15,    -1,    -1,    -1,
      19,    -1,    -1,    22,    -1,    24,    25,    26,    27,    28,
      29,    30,    31,    -1,    33,    -1,    -1,    36,    37,    38,
      39,    40,    41,    42,    -1,    44,    45,    46,    -1,    48,
      -1,    50,    51,    -1,    -1,    54,    55,    56,    57,    58,
      -1,    60,    61,    62,    63,    64,    -1,    66,    67,    68,
      69,    70,    71,    72,    -1,    74,    75,    76,    77,    78,
      79,    80,    -1,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    91,    92,    -1,    94,    95,    96,    97,    98,
      -1,   100,   101,   102,   103,    -1,    -1,   106,   107,   108,
     109,   110,   111,    -1,   113,   114,   115,    -1,   117,   118,
     119,   120,   121,   122,    -1,    -1,    -1,    -1,   127,   128,
     129,    -1,    -1,   132,   133,    -1,   135,    -1,    -1,    -1,
     139,    -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,
     149,    -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,
      -1,   160,   161,    -1,   163,   164,   165,    -1,    -1,   168,
     169,    -1,   171,   172,   173,   174,   175,   176,   177,   178,
      -1,   180,   181,   182,   183,   184,   185,   186,   187,    -1,
     189,   190,   191,   192,    -1,   194,    -1,    -1,    -1,   198,
      -1,   200,    -1,   202,    -1,   204,   205,   206,   207,   208,
     209,   210,    -1,   212,    -1,   214,    -1,   216,   217,   218,
      -1,   220,   221,   222,    -1,   224,   225,    -1,    -1,    -1,
     229,   230,   231,   232,   233,   234,    -1,   236,   237,   238,
      -1,   240,    -1,   242,    -1,    -1,    -1,   246,   247,   248,
     249,    -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,
      -1,    -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,
      -1,   270,    -1,   272,   273,   274,    -1,    -1,    -1,    -1,
      -1,   280,   281,    -1,   283,    -1,   285,    -1,   287,   288,
      -1,    -1,   291,    -1,    -1,    -1,    -1,   296,   297,   298,
     299,   300,   301,   302,   303,   304,   305,   306,   307,   308,
     309,   310,   311,    -1,   313,   314,   315,   316,   317,   318,
     319,   320,   321,   322,   323,   324,    -1,    -1,    -1,    -1,
     329,   330,   331,   332,   333,   334,    -1,    -1,   337,   338,
     339,   340,    -1,   342,   343,   344,   345,   346,   347,   348,
     349,   350,   351,   352,   353,    -1,   355,   356,   357,    -1,
      -1,   360,   361,   362,   363,   364,    -1,   366,   367,   368,
      -1,   370,   371,   372,    -1,   374,   375,   376,    -1,   378,
     379,   380,   381,    -1,   383,   384,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   393,   394,   395,    -1,   397,   398,
      -1,   400,    -1,   402,   403,   404,   405,   406,   407,   408,
     409,   410,   411,   412,    -1,   414,   415,   416,    -1,   418,
      -1,   420,   421,   422,   423,   424,    -1,   426,   427,   428,
      -1,    -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,
     439,    -1,    -1,   442,   443,   444,   445,   446,    -1,   448,
     449,    -1,   451,   452,   453,   454,   455,   456,    -1,   458,
      -1,   460,   461,    -1,   463,   464,    -1,   466,    -1,   468,
      -1,   470,   471,   472,   473,   474,   475,   476,   477,   478,
     479,   480,   481,   482,    -1,   484,   485,    -1,    -1,    -1,
     489,   490,   491,   492,    -1,    -1,    -1,   496,    -1,    -1,
      -1,   500,    -1,   502,   503,   504,   505,   506,   507,    -1,
     509,   510,   511,   512,   513,   514,    -1,    -1,    -1,    -1,
      -1,    -1,   521,   522,    -1,   524,    -1,    -1,   527,    -1,
      -1,   530,   531,    -1,    -1,    -1,   535,   536,   537,   538,
     539,    -1,   541,   542,   543,   544,   545,   546,   547,   548,
     549,   550,   551,   552,   553,   554,   555,    -1,   557,    -1,
     559,   560,   561,   562,    -1,   564,   565,   566,    -1,   568,
     569,   570,   571,    -1,    -1,    -1,    -1,    -1,   577,   578,
     579,    -1,   581,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,    -1,   594,   595,    -1,    -1,   598,
      -1,    -1,   601,    -1,   603,    -1,   605,   606,   607,    -1,
      -1,   610,   611,   612,   613,   614,    -1,    -1,   617,   618,
      -1,   620,   621,   622,   623,   624,   625,   626,   627,    -1,
      -1,    -1,    -1,    -1,    -1,   634,   635,    -1,   637,   638,
     639,    -1,    -1,   642,    -1,    -1,    -1,    -1,   647,   648,
      -1,    -1,    -1,    -1,   653,   654,    -1,    -1,   657,   658,
      -1,    -1,   661,   662,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,    -1,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    36,    37,    38,    39,    40,
      41,    42,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    55,    56,    57,    58,    -1,    60,
      61,    62,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
     101,   102,   103,    -1,    -1,   106,   107,   108,   109,   110,
     111,    -1,   113,   114,   115,    -1,   117,   118,   119,   120,
     121,   122,    -1,    -1,    -1,    -1,   127,   128,   129,    -1,
      -1,   132,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,   178,    -1,   180,
     181,   182,   183,   184,   185,   186,   187,    -1,   189,   190,
     191,   192,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
      -1,   212,    -1,   214,    -1,   216,   217,   218,    -1,   220,
     221,   222,    -1,   224,   225,    -1,    -1,    -1,   229,   230,
     231,   232,   233,   234,    -1,   236,   237,   238,    -1,   240,
      -1,   242,    -1,    -1,    -1,   246,   247,   248,   249,    -1,
      -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,
      -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,   272,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,
     281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,
     291,    -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,   313,   314,   315,   316,   317,   318,   319,   320,
     321,   322,   323,   324,    -1,    -1,    -1,    -1,   329,   330,
     331,   332,   333,   334,    -1,    -1,   337,   338,   339,   340,
      -1,   342,   343,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,    -1,   355,   356,   357,    -1,    -1,   360,
     361,   362,   363,   364,    -1,   366,   367,   368,    -1,   370,
     371,   372,    -1,   374,   375,   376,    -1,   378,   379,   380,
     381,    -1,   383,   384,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   393,   394,   395,    -1,   397,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,   412,    -1,   414,   415,   416,    -1,   418,    -1,   420,
     421,   422,   423,   424,    -1,   426,   427,   428,    -1,    -1,
     431,    -1,    -1,    -1,   435,   436,   437,   438,   439,    -1,
      -1,   442,   443,   444,   445,   446,    -1,   448,   449,    -1,
     451,   452,   453,   454,   455,   456,    -1,   458,    -1,   460,
     461,    -1,   463,   464,    -1,   466,    -1,   468,    -1,   470,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,    -1,   484,   485,    -1,    -1,    -1,   489,   490,
     491,   492,    -1,    -1,    -1,   496,    -1,    -1,    -1,   500,
      -1,   502,   503,   504,   505,   506,   507,    -1,   509,   510,
     511,   512,   513,   514,    -1,    -1,    -1,    -1,    -1,    -1,
     521,   522,    -1,   524,    -1,    -1,   527,    -1,    -1,   530,
     531,    -1,    -1,    -1,   535,   536,   537,   538,   539,    -1,
     541,   542,   543,   544,   545,   546,   547,   548,   549,   550,
     551,   552,   553,   554,   555,    -1,   557,    -1,   559,   560,
     561,   562,    -1,   564,   565,   566,    -1,   568,   569,   570,
     571,    -1,    -1,    -1,    -1,    -1,   577,   578,   579,    -1,
     581,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,    -1,   594,   595,    -1,    -1,   598,    -1,    -1,
     601,    -1,   603,    -1,   605,   606,   607,    -1,    -1,   610,
     611,   612,   613,   614,    -1,    -1,   617,   618,    -1,   620,
     621,   622,   623,   624,   625,   626,   627,    -1,    -1,    -1,
      -1,    -1,    -1,   634,   635,    -1,   637,   638,   639,    -1,
      -1,   642,    -1,    -1,    -1,    -1,   647,   648,    -1,    -1,
      -1,    -1,   653,   654,    -1,    -1,   657,   658,    -1,    -1,
     661,   662,     5,    -1,     7,     8,     9,    10,    11,    12,
      -1,    -1,    15,    -1,    -1,    -1,    19,    -1,    -1,    22,
      -1,    24,    25,    26,    27,    28,    29,    30,    31,    -1,
      33,    -1,    -1,    36,    37,    38,    39,    40,    41,    42,
      -1,    44,    45,    46,    -1,    48,    -1,    50,    51,    -1,
      -1,    54,    55,    56,    57,    58,    -1,    60,    61,    62,
      63,    64,    -1,    66,    67,    68,    69,    70,    71,    72,
      -1,    74,    75,    76,    77,    78,    79,    80,    -1,    82,
      83,    84,    85,    86,    87,    88,    89,    -1,    91,    92,
      -1,    94,    95,    96,    97,    98,    -1,   100,   101,   102,
     103,    -1,    -1,   106,   107,   108,   109,   110,   111,    -1,
     113,   114,   115,    -1,   117,   118,   119,   120,   121,   122,
      -1,    -1,    -1,    -1,   127,   128,   129,    -1,    -1,   132,
     133,    -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,
     143,   144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,
     153,   154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,
     163,   164,   165,    -1,    -1,   168,   169,    -1,   171,   172,
     173,   174,   175,   176,   177,   178,    -1,   180,   181,   182,
     183,   184,   185,   186,   187,    -1,   189,   190,   191,   192,
      -1,   194,    -1,    -1,    -1,   198,    -1,   200,    -1,   202,
      -1,   204,   205,   206,   207,   208,   209,   210,    -1,   212,
      -1,   214,    -1,   216,   217,   218,    -1,   220,   221,   222,
      -1,   224,   225,    -1,    -1,    -1,   229,   230,   231,   232,
     233,   234,    -1,   236,   237,   238,    -1,   240,    -1,   242,
      -1,    -1,    -1,   246,   247,   248,   249,    -1,    -1,   252,
      -1,   254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,
      -1,    -1,   265,   266,   267,    -1,    -1,   270,    -1,   272,
     273,   274,    -1,    -1,    -1,    -1,    -1,   280,   281,    -1,
     283,    -1,   285,    -1,   287,   288,    -1,    -1,   291,    -1,
      -1,    -1,    -1,   296,   297,   298,   299,   300,   301,   302,
     303,   304,   305,   306,   307,   308,   309,   310,   311,    -1,
     313,   314,   315,   316,   317,   318,   319,   320,   321,   322,
     323,   324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,
     333,   334,    -1,    -1,   337,   338,   339,   340,    -1,   342,
     343,   344,   345,   346,   347,   348,   349,   350,   351,   352,
     353,    -1,   355,   356,   357,    -1,    -1,   360,   361,   362,
     363,   364,    -1,   366,   367,   368,    -1,   370,   371,   372,
      -1,   374,   375,   376,    -1,   378,   379,   380,   381,    -1,
     383,   384,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     393,   394,   395,    -1,   397,   398,    -1,   400,    -1,   402,
     403,   404,   405,   406,   407,   408,   409,   410,   411,   412,
      -1,   414,   415,   416,    -1,   418,    -1,   420,   421,   422,
     423,   424,    -1,   426,   427,   428,    -1,    -1,   431,    -1,
      -1,    -1,   435,   436,   437,   438,   439,    -1,    -1,   442,
     443,   444,   445,   446,    -1,   448,   449,    -1,   451,   452,
     453,   454,   455,   456,    -1,   458,    -1,   460,   461,    -1,
     463,   464,    -1,   466,    -1,   468,    -1,   470,   471,   472,
     473,   474,   475,   476,   477,   478,   479,   480,   481,   482,
      -1,   484,   485,    -1,    -1,    -1,   489,   490,   491,   492,
      -1,    -1,    -1,   496,    -1,    -1,    -1,   500,    -1,   502,
     503,   504,   505,   506,   507,    -1,   509,   510,   511,   512,
     513,   514,    -1,    -1,    -1,    -1,    -1,    -1,   521,   522,
      -1,   524,    -1,    -1,   527,    -1,    -1,   530,   531,    -1,
      -1,    -1,   535,   536,   537,   538,   539,    -1,   541,   542,
     543,   544,   545,   546,   547,   548,   549,   550,   551,   552,
     553,   554,   555,    -1,   557,    -1,   559,   560,   561,   562,
      -1,   564,   565,   566,    -1,   568,   569,   570,   571,    -1,
      -1,    -1,    -1,    -1,   577,   578,   579,    -1,   581,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
      -1,   594,   595,    -1,    -1,   598,    -1,    -1,   601,    -1,
     603,    -1,   605,   606,   607,    -1,    -1,   610,   611,   612,
     613,   614,    -1,    -1,   617,   618,    -1,   620,   621,   622,
     623,   624,   625,   626,   627,    -1,    -1,    -1,    -1,    -1,
      -1,   634,   635,    -1,   637,   638,   639,    -1,    -1,   642,
      -1,    -1,    -1,    -1,   647,   648,    -1,    -1,    -1,    -1,
     653,   654,    -1,    -1,   657,   658,    -1,    -1,   661,   662,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    -1,    37,    38,    -1,    -1,    41,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,
      -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,
      -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,
      -1,    -1,   127,   128,   129,    -1,    -1,    -1,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,    -1,    -1,   180,   181,   182,   183,    -1,
     185,   186,   187,    -1,   189,   190,   191,   192,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,    -1,
      -1,   216,   217,   218,    -1,   220,   221,   222,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,    -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,   291,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,    -1,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,    -1,
     355,   356,   357,    -1,    -1,   360,   361,   362,   363,    -1,
      -1,    -1,   367,   368,    -1,   370,   371,   372,    -1,   374,
     375,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,
     395,    -1,    -1,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,    -1,    -1,   414,
     415,   416,    -1,   418,    -1,   420,   421,   422,   423,   424,
      -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,   439,    -1,    -1,   442,   443,   444,
     445,   446,    -1,   448,   449,    -1,   451,   452,   453,    -1,
      -1,   456,    -1,   458,    -1,   460,   461,    -1,   463,   464,
      -1,   466,    -1,   468,    -1,    -1,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,    -1,   484,
     485,    -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,
      -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,    -1,   509,   510,   511,   512,   513,   514,
      -1,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,
      -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,
     535,    -1,    -1,   538,   539,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,   551,   552,    -1,   554,
     555,    -1,   557,    -1,   559,   560,   561,   562,    -1,   564,
     565,   566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,
      -1,    -1,   577,   578,   579,    -1,    -1,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,    -1,   594,
     595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,
     605,   606,   607,    -1,    -1,    -1,    -1,    -1,    -1,   614,
      -1,    -1,   617,    -1,    -1,    -1,   621,   622,   623,   624,
     625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,
     635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,    -1,
      -1,     5,    -1,     7,     8,     9,    10,    11,    12,    -1,
      -1,    15,    -1,    -1,    -1,    19,   661,   662,    22,    -1,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    33,
      -1,    -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,
      44,    45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,
      54,    -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,
      64,    -1,    66,    67,    68,    69,    70,    71,    72,    -1,
      74,    75,    76,    77,    78,    79,    80,    -1,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    91,    92,    93,
      94,    95,    96,    97,    98,    -1,   100,    -1,    -1,   103,
      -1,    -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,
      -1,    -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,
      -1,    -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,
      -1,   135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,
     144,   145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,
     154,    -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,
     164,   165,    -1,    -1,   168,   169,    -1,   171,   172,   173,
     174,   175,   176,   177,    -1,    -1,   180,   181,   182,   183,
      -1,    -1,   186,   187,    -1,   189,   190,   191,    -1,    -1,
     194,    -1,    -1,    -1,   198,    -1,   200,   201,   202,    -1,
     204,   205,   206,   207,   208,   209,   210,    -1,   212,    -1,
      -1,    -1,   216,   217,   218,    -1,   220,    -1,    -1,    -1,
     224,   225,    -1,    -1,    -1,   229,   230,   231,   232,   233,
      -1,    -1,   236,   237,   238,   239,   240,    -1,   242,    -1,
      -1,    -1,    -1,   247,   248,    -1,    -1,    -1,   252,    -1,
     254,   255,    -1,   257,   258,    -1,    -1,    -1,   262,   263,
      -1,   265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,
     274,    -1,   276,    -1,    -1,    -1,   280,   281,    -1,   283,
      -1,   285,    -1,   287,   288,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   296,   297,   298,   299,   300,   301,   302,   303,
     304,   305,   306,   307,   308,   309,   310,   311,    -1,   313,
     314,   315,   316,    -1,   318,   319,   320,   321,    -1,   323,
     324,    -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,
     334,    -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,
     344,   345,   346,   347,   348,   349,   350,   351,   352,   353,
      -1,    -1,   356,   357,    -1,    -1,   360,   361,   362,   363,
      -1,    -1,    -1,   367,   368,    -1,    -1,    -1,   372,    -1,
     374,   375,   376,    -1,   378,   379,   380,   381,    -1,   383,
     384,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,
     394,   395,    -1,    -1,   398,    -1,   400,    -1,   402,   403,
     404,   405,   406,   407,   408,   409,   410,   411,    -1,    -1,
     414,   415,   416,    -1,   418,    -1,   420,   421,   422,   423,
     424,    -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,
      -1,   435,   436,   437,   438,   439,    -1,    -1,   442,   443,
     444,   445,   446,    -1,   448,   449,    -1,   451,   452,   453,
      -1,    -1,   456,    -1,   458,    -1,   460,   461,    -1,   463,
     464,    -1,   466,    -1,   468,    -1,    -1,   471,   472,   473,
     474,   475,   476,   477,   478,   479,   480,   481,   482,    -1,
     484,   485,   486,    -1,    -1,   489,   490,   491,   492,    -1,
      -1,    -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,
     504,   505,   506,   507,    -1,   509,   510,   511,   512,   513,
     514,   515,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,
     524,    -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,
      -1,   535,    -1,    -1,   538,   539,    -1,   541,   542,   543,
     544,   545,   546,    -1,    -1,   549,   550,   551,   552,    -1,
     554,   555,    -1,   557,    -1,   559,   560,   561,   562,    -1,
      -1,   565,   566,    -1,   568,   569,   570,   571,    -1,    -1,
      -1,    -1,    -1,   577,   578,   579,    -1,    -1,    -1,   583,
     584,   585,   586,    -1,   588,   589,    -1,   591,   592,    -1,
     594,   595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,
      -1,   605,   606,   607,    -1,    -1,    -1,    -1,    -1,    -1,
     614,    -1,    -1,   617,    -1,    -1,    -1,   621,   622,   623,
     624,   625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,
     634,   635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,
       5,    -1,     7,     8,     9,    10,    11,    12,    -1,    -1,
      15,    -1,    -1,    -1,    19,    -1,    -1,    22,   662,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    93,    94,
      95,    96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,
      -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,
      -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,
      -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,    -1,    -1,   180,   181,   182,   183,    -1,
      -1,   186,   187,    -1,   189,   190,   191,    -1,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,   201,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,    -1,
      -1,   216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,
      -1,   236,   237,   238,   239,   240,    -1,   242,    -1,    -1,
      -1,    -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,   263,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,    -1,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,    -1,
      -1,   356,   357,    -1,    -1,   360,   361,   362,   363,    -1,
      -1,    -1,   367,   368,    -1,    -1,    -1,   372,    -1,   374,
     375,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,
     395,    -1,    -1,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,    -1,    -1,   414,
     415,   416,    -1,   418,    -1,   420,   421,   422,   423,   424,
      -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,   439,    -1,    -1,   442,   443,   444,
     445,   446,    -1,   448,   449,    -1,   451,   452,   453,    -1,
      -1,   456,    -1,   458,    -1,   460,   461,    -1,   463,   464,
      -1,   466,    -1,   468,    -1,    -1,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,    -1,   484,
     485,    -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,
      -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,    -1,   509,   510,   511,   512,   513,   514,
     515,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,
      -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,
     535,    -1,    -1,   538,   539,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,   551,   552,    -1,   554,
     555,    -1,   557,    -1,   559,   560,   561,   562,    -1,    -1,
     565,   566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,
      -1,    -1,   577,   578,   579,    -1,    -1,    -1,   583,   584,
     585,   586,    -1,   588,   589,    -1,   591,   592,    -1,   594,
     595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,
     605,   606,   607,    -1,    -1,    -1,    -1,    -1,    -1,   614,
      -1,    -1,   617,    -1,    -1,    -1,   621,   622,   623,   624,
     625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,
     635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,   662,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,   180,   181,   182,   183,    -1,    -1,
     186,   187,    -1,   189,   190,   191,    -1,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
      -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,    -1,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,    -1,    -1,
     356,   357,    -1,    -1,   360,   361,   362,   363,    -1,    -1,
      -1,   367,   368,    -1,    -1,    -1,   372,    -1,   374,   375,
     376,    -1,   378,   379,   380,   381,    -1,   383,   384,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,
      -1,    -1,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,    -1,    -1,   414,   415,
     416,    -1,   418,    -1,   420,   421,   422,   423,   424,    -1,
     426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,
     436,   437,   438,   439,    -1,    -1,   442,   443,   444,   445,
     446,    -1,   448,   449,    -1,   451,   452,   453,    -1,    -1,
     456,    -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,
     466,    -1,   468,    -1,    -1,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,    -1,   484,   485,
     486,    -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,
     496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,    -1,   509,   510,   511,   512,   513,   514,    -1,
      -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,
      -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,
      -1,    -1,   538,   539,    -1,   541,   542,   543,   544,   545,
     546,    -1,    -1,   549,   550,   551,   552,    -1,   554,   555,
      -1,   557,    -1,   559,   560,   561,   562,    -1,    -1,   565,
     566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,
      -1,   577,   578,   579,    -1,    -1,    -1,   583,   584,   585,
     586,    -1,   588,   589,    -1,   591,   592,    -1,   594,   595,
      -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,
     606,   607,    -1,    -1,    -1,    -1,    -1,    -1,   614,    -1,
      -1,   617,    -1,    -1,    -1,   621,   622,   623,   624,   625,
     626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,
      -1,   637,   638,   639,    -1,    -1,   642,    -1,     5,    -1,
       7,     8,     9,    10,    11,    12,    -1,    -1,    15,   655,
      -1,    -1,    19,    -1,    -1,    22,   662,    24,    25,    26,
      27,    28,    29,    30,    31,    -1,    33,    -1,    -1,    -1,
      37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,    46,
      -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,    -1,
      57,    58,    -1,    60,    61,    -1,    63,    64,    -1,    66,
      67,    68,    69,    70,    71,    72,    -1,    74,    75,    76,
      77,    78,    79,    80,    -1,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    91,    92,    -1,    94,    95,    96,
      97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,   106,
      -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,    -1,
     117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,    -1,
     127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,    -1,
      -1,    -1,   139,    -1,   141,   142,   143,   144,   145,    -1,
      -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,    -1,
      -1,   158,    -1,   160,   161,    -1,   163,   164,   165,    -1,
      -1,   168,   169,    -1,   171,   172,   173,   174,   175,   176,
     177,    -1,    -1,   180,   181,   182,   183,    -1,    -1,   186,
     187,    -1,   189,   190,   191,    -1,    -1,   194,    -1,    -1,
      -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,   206,
     207,   208,   209,   210,    -1,   212,    -1,    -1,    -1,   216,
     217,   218,    -1,   220,    -1,    -1,    -1,   224,   225,    -1,
      -1,    -1,   229,   230,   231,   232,   233,    -1,    -1,   236,
     237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,    -1,
     247,   248,    -1,    -1,    -1,   252,    -1,   254,   255,    -1,
     257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,   266,
     267,    -1,    -1,   270,    -1,    -1,   273,   274,    -1,    -1,
      -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,    -1,
     287,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   296,
     297,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,    -1,   313,   314,   315,   316,
      -1,   318,   319,   320,   321,    -1,   323,   324,    -1,    -1,
      -1,    -1,   329,   330,   331,   332,   333,   334,    -1,    -1,
     337,   338,    -1,   340,    -1,   342,    -1,   344,   345,   346,
     347,   348,   349,   350,   351,   352,   353,    -1,    -1,   356,
     357,    -1,    -1,   360,   361,   362,   363,    -1,    -1,    -1,
     367,   368,    -1,    -1,    -1,   372,    -1,   374,   375,   376,
      -1,   378,   379,   380,   381,    -1,   383,   384,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,    -1,
      -1,   398,    -1,   400,    -1,   402,   403,   404,   405,   406,
     407,   408,   409,   410,   411,    -1,    -1,   414,   415,   416,
      -1,   418,    -1,   420,   421,   422,   423,   424,    -1,   426,
     427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,   436,
     437,   438,   439,    -1,    -1,   442,   443,   444,   445,   446,
      -1,   448,   449,    -1,   451,   452,   453,    -1,    -1,   456,
      -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,   466,
      -1,   468,    -1,    -1,   471,   472,   473,   474,   475,   476,
     477,   478,   479,   480,   481,   482,    -1,   484,   485,    -1,
      -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,   496,
      -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,   506,
     507,    -1,   509,   510,   511,   512,   513,   514,    -1,    -1,
      -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,    -1,
     527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,    -1,
      -1,   538,   539,    -1,   541,   542,   543,   544,   545,   546,
      -1,    -1,   549,   550,   551,   552,    -1,   554,   555,    -1,
     557,    -1,   559,   560,   561,   562,    -1,    -1,   565,   566,
      -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,    -1,
     577,   578,   579,    -1,    -1,    -1,   583,   584,   585,   586,
      -1,   588,   589,    -1,   591,   592,    -1,   594,   595,    -1,
      -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,   606,
     607,    -1,    -1,    -1,    -1,    -1,    -1,   614,    -1,    -1,
     617,    -1,    -1,    -1,   621,   622,   623,   624,   625,   626,
     627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,    -1,
     637,   638,   639,    -1,    -1,   642,    -1,    -1,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,   655,    15,
      -1,    -1,    -1,    19,   661,   662,    22,    -1,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,   180,   181,   182,   183,    -1,    -1,
     186,   187,    -1,   189,   190,   191,    -1,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
      -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,    -1,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,    -1,    -1,
     356,   357,    -1,    -1,   360,   361,   362,   363,    -1,    -1,
      -1,   367,   368,    -1,    -1,    -1,   372,    -1,   374,   375,
     376,    -1,   378,   379,   380,   381,    -1,   383,   384,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,
      -1,    -1,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,    -1,    -1,   414,   415,
     416,    -1,   418,    -1,   420,   421,   422,   423,   424,    -1,
     426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,
     436,   437,   438,   439,    -1,    -1,   442,   443,   444,   445,
     446,    -1,   448,   449,    -1,   451,   452,   453,    -1,    -1,
     456,    -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,
     466,    -1,   468,    -1,    -1,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,    -1,   484,   485,
      -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,
     496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,    -1,   509,   510,   511,   512,   513,   514,    -1,
      -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,
      -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,
      -1,    -1,   538,   539,    -1,   541,   542,   543,   544,   545,
     546,    -1,    -1,   549,   550,   551,   552,    -1,   554,   555,
      -1,   557,    -1,   559,   560,   561,   562,    -1,    -1,   565,
     566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,
      -1,   577,   578,   579,    -1,    -1,    -1,   583,   584,   585,
     586,    -1,   588,   589,    -1,   591,   592,    -1,   594,   595,
      -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,
     606,   607,    -1,    -1,    -1,    -1,    -1,    -1,   614,    -1,
      -1,   617,    -1,    -1,    -1,   621,   622,   623,   624,   625,
     626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,
      -1,   637,   638,   639,    -1,    -1,   642,    -1,    -1,    -1,
       5,    -1,     7,     8,     9,    10,    11,    12,   654,    -1,
      15,    -1,    -1,    -1,    19,    -1,   662,    22,    -1,    24,
      25,    26,    27,    28,    29,    30,    31,    -1,    33,    -1,
      -1,    -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,
      45,    46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,
      -1,    -1,    57,    58,    -1,    60,    61,    -1,    63,    64,
      -1,    66,    67,    68,    69,    70,    71,    72,    -1,    74,
      75,    76,    77,    78,    79,    80,    -1,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,    91,    92,    -1,    94,
      95,    96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,
      -1,   106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,
      -1,    -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,
      -1,    -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,
     135,    -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,
     145,    -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,
      -1,    -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,
     165,    -1,    -1,   168,   169,    -1,   171,   172,   173,   174,
     175,   176,   177,    -1,    -1,   180,   181,   182,   183,    -1,
      -1,   186,   187,    -1,   189,   190,   191,    -1,    -1,   194,
      -1,    -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,
     205,   206,   207,   208,   209,   210,    -1,   212,    -1,    -1,
      -1,   216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,
     225,    -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,
      -1,   236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,
      -1,    -1,   247,   248,    -1,   250,    -1,   252,    -1,   254,
     255,    -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,
     265,   266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,
      -1,    -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,
     285,    -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,    -1,   313,   314,
     315,   316,    -1,   318,   319,   320,   321,    -1,   323,   324,
      -1,    -1,    -1,    -1,   329,   330,   331,   332,   333,   334,
      -1,    -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,    -1,
      -1,   356,   357,    -1,    -1,   360,   361,   362,   363,    -1,
      -1,    -1,   367,   368,    -1,    -1,    -1,   372,    -1,   374,
     375,   376,    -1,   378,   379,   380,   381,    -1,   383,   384,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,
     395,    -1,    -1,   398,    -1,   400,    -1,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,    -1,    -1,   414,
     415,   416,    -1,   418,    -1,   420,   421,   422,   423,   424,
      -1,   426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,
     435,   436,   437,   438,   439,    -1,    -1,   442,   443,   444,
     445,   446,    -1,   448,   449,    -1,   451,   452,   453,    -1,
      -1,   456,    -1,   458,    -1,   460,   461,    -1,   463,   464,
      -1,   466,    -1,   468,    -1,    -1,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,    -1,   484,
     485,    -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,
      -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,   506,   507,    -1,   509,   510,   511,   512,   513,   514,
      -1,    -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,
      -1,    -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,
     535,    -1,    -1,   538,   539,    -1,   541,   542,   543,   544,
     545,   546,    -1,    -1,   549,   550,   551,   552,    -1,   554,
     555,    -1,   557,    -1,   559,   560,   561,   562,    -1,    -1,
     565,   566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,
      -1,    -1,   577,   578,   579,    -1,    -1,    -1,   583,   584,
     585,   586,    -1,   588,   589,    -1,   591,   592,    -1,   594,
     595,    -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,
     605,   606,   607,    -1,    -1,    -1,    -1,    -1,    -1,   614,
      -1,    -1,   617,    -1,    -1,    -1,   621,   622,   623,   624,
     625,   626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,
     635,    -1,   637,   638,   639,    -1,    -1,   642,    -1,     5,
      -1,     7,     8,     9,    10,    11,    12,    -1,    -1,    15,
      -1,    -1,    -1,    19,    -1,    -1,    22,   662,    24,    25,
      26,    27,    28,    29,    30,    31,    -1,    33,    -1,    -1,
      -1,    37,    -1,    -1,    -1,    41,    -1,    -1,    44,    45,
      46,    -1,    48,    -1,    50,    51,    -1,    -1,    54,    -1,
      -1,    57,    58,    -1,    60,    61,    -1,    63,    64,    -1,
      66,    67,    68,    69,    70,    71,    72,    -1,    74,    75,
      76,    77,    78,    79,    80,    -1,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    91,    92,    -1,    94,    95,
      96,    97,    98,    -1,   100,    -1,    -1,   103,    -1,    -1,
     106,    -1,   108,    -1,    -1,   111,    -1,   113,    -1,    -1,
      -1,   117,   118,   119,    -1,    -1,   122,    -1,    -1,    -1,
      -1,   127,   128,    -1,    -1,    -1,    -1,   133,    -1,   135,
      -1,    -1,    -1,   139,    -1,   141,   142,   143,   144,   145,
      -1,    -1,    -1,   149,    -1,    -1,   152,   153,   154,    -1,
      -1,    -1,   158,    -1,   160,   161,    -1,   163,   164,   165,
      -1,    -1,   168,   169,    -1,   171,   172,   173,   174,   175,
     176,   177,    -1,    -1,   180,   181,   182,   183,    -1,    -1,
     186,   187,    -1,   189,   190,   191,    -1,    -1,   194,    -1,
      -1,    -1,   198,    -1,   200,    -1,   202,    -1,   204,   205,
     206,   207,   208,   209,   210,    -1,   212,    -1,    -1,    -1,
     216,   217,   218,    -1,   220,    -1,    -1,    -1,   224,   225,
      -1,    -1,    -1,   229,   230,   231,   232,   233,    -1,    -1,
     236,   237,   238,    -1,   240,    -1,   242,    -1,    -1,    -1,
      -1,   247,   248,    -1,    -1,    -1,   252,    -1,   254,   255,
      -1,   257,   258,    -1,    -1,    -1,   262,    -1,    -1,   265,
     266,   267,    -1,    -1,   270,    -1,    -1,   273,   274,    -1,
      -1,    -1,    -1,    -1,   280,   281,    -1,   283,    -1,   285,
      -1,   287,   288,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     296,   297,   298,   299,   300,   301,   302,   303,   304,   305,
     306,   307,   308,   309,   310,   311,    -1,   313,   314,   315,
     316,    -1,   318,   319,   320,   321,    -1,   323,   324,    -1,
      -1,    -1,    -1,   329,   330,   331,   332,   333,   334,    -1,
      -1,   337,   338,    -1,   340,    -1,   342,    -1,   344,   345,
     346,   347,   348,   349,   350,   351,   352,   353,    -1,    -1,
     356,   357,    -1,    -1,   360,   361,   362,   363,    -1,    -1,
      -1,   367,   368,    -1,    -1,    -1,   372,    -1,   374,   375,
     376,    -1,   378,   379,   380,   381,    -1,   383,   384,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   393,   394,   395,
      -1,    -1,   398,    -1,   400,    -1,   402,   403,   404,   405,
     406,   407,   408,   409,   410,   411,    -1,    -1,   414,   415,
     416,    -1,   418,    -1,   420,   421,   422,   423,   424,    -1,
     426,   427,   428,    -1,    -1,   431,    -1,    -1,    -1,   435,
     436,   437,   438,   439,    -1,    -1,   442,   443,   444,   445,
     446,    -1,   448,   449,    -1,   451,   452,   453,    -1,    -1,
     456,    -1,   458,    -1,   460,   461,    -1,   463,   464,    -1,
     466,    -1,   468,    -1,    -1,   471,   472,   473,   474,   475,
     476,   477,   478,   479,   480,   481,   482,    -1,   484,   485,
      -1,    -1,    -1,   489,   490,   491,   492,    -1,    -1,    -1,
     496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,   505,
     506,   507,    -1,   509,   510,   511,   512,   513,   514,    -1,
      -1,    -1,    -1,    -1,    -1,   521,   522,    -1,   524,    -1,
      -1,   527,    -1,    -1,   530,   531,    -1,    -1,    -1,   535,
      -1,    -1,   538,   539,    -1,   541,   542,   543,   544,   545,
     546,    -1,    -1,   549,   550,   551,   552,    -1,   554,   555,
      -1,   557,    -1,   559,   560,   561,   562,    -1,    -1,   565,
     566,    -1,   568,   569,   570,   571,    -1,    -1,    -1,    -1,
      -1,   577,   578,   579,    -1,    -1,    -1,   583,   584,   585,
     586,    -1,   588,   589,    -1,   591,   592,    -1,   594,   595,
      -1,    -1,   598,    -1,    -1,   601,    -1,   603,    -1,   605,
     606,   607,    -1,    -1,    -1,    -1,    -1,    -1,   614,    -1,
      -1,   617,    -1,    -1,    -1,   621,   622,   623,   624,   625,
     626,   627,    -1,    -1,    -1,    -1,    -1,    -1,   634,   635,
      -1,   637,   638,   639,    -1,    -1,   642,    -1,    -1,    -1,
      -1,    -1,    -1,   649,     5,    -1,     7,     8,     9,    10,
      11,    12,    -1,    -1,    15,    -1,   662,    -1,    19,    -1,
      -1,    22,    -1,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,    -1,
      41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,    50,
      51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,    60,
      61,    -1,    63,    64,    -1,    66,    67,    68,    69,    70,
      71,    72,    -1,    74,    75,    76,    77,    78,    79,    80,
      -1,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      91,    92,    -1,    94,    95,    96,    97,    98,    -1,   100,
      -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,    -1,
     111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,    -1,
      -1,   122,    -1,    -1,    -1,    -1,   127,   128,    -1,    -1,
      -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,    -1,
     141,   142,   143,   144,   145,    -1,    -1,    -1,   149,    -1,
      -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,   160,
     161,    -1,   163,   164,   165,    -1,    -1,   168,   169,    -1,
     171,   172,   173,   174,   175,   176,   177,    -1,    -1,   180,
     181,   182,   183,    -1,    -1,   186,   187,    -1,   189,   190,
     191,    -1,    -1,   194,    -1,    -1,    -1,   198,    -1,   200,
      -1,   202,    -1,   204,   205,   206,   207,   208,   209,   210,
      -1,   212,    -1,    -1,    -1,   216,   217,   218,    -1,   220,
      -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,   230,
     231,   232,   233,    -1,    -1,   236,   237,   238,    -1,   240,
      -1,   242,    -1,    -1,    -1,    -1,   247,   248,    -1,    -1,
      -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,    -1,
      -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,   270,
      -1,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,   280,
     281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   296,   297,   298,   299,   300,
     301,   302,   303,   304,   305,   306,   307,   308,   309,   310,
     311,    -1,   313,   314,   315,   316,    -1,   318,   319,   320,
     321,    -1,   323,   324,    -1,    -1,    -1,    -1,   329,   330,
     331,   332,   333,   334,    -1,    -1,   337,   338,    -1,   340,
      -1,   342,    -1,   344,   345,   346,   347,   348,   349,   350,
     351,   352,   353,    -1,    -1,   356,   357,    -1,    -1,   360,
     361,   362,   363,    -1,    -1,    -1,   367,   368,    -1,    -1,
      -1,   372,    -1,   374,   375,   376,    -1,   378,   379,   380,
     381,    -1,   383,   384,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   393,   394,   395,    -1,    -1,   398,    -1,   400,
      -1,   402,   403,   404,   405,   406,   407,   408,   409,   410,
     411,    -1,    -1,   414,   415,   416,    -1,   418,    -1,   420,
     421,   422,   423,   424,    -1,   426,   427,   428,    -1,    -1,
     431,    -1,    -1,    -1,   435,   436,   437,   438,   439,    -1,
      -1,   442,   443,   444,   445,   446,    -1,   448,   449,    -1,
     451,   452,   453,    -1,    -1,   456,    -1,   458,    -1,   460,
     461,    -1,   463,   464,    -1,   466,    -1,   468,    -1,    -1,
     471,   472,   473,   474,   475,   476,   477,   478,   479,   480,
     481,   482,    -1,   484,   485,    -1,    -1,    -1,   489,   490,
     491,   492,    -1,    -1,    -1,   496,    -1,    -1,    -1,   500,
      -1,   502,   503,   504,   505,   506,   507,    -1,   509,   510,
     511,   512,   513,   514,    -1,    -1,    -1,    -1,    -1,    -1,
     521,   522,    -1,   524,    -1,    -1,   527,    -1,    -1,   530,
     531,    -1,    -1,    -1,   535,    -1,    -1,   538,   539,    -1,
     541,   542,   543,   544,   545,   546,    -1,    -1,   549,   550,
     551,   552,    -1,   554,   555,    -1,   557,    -1,   559,   560,
     561,   562,    -1,    -1,   565,   566,    -1,   568,   569,   570,
     571,    -1,    -1,    -1,    -1,    -1,   577,   578,   579,    -1,
      -1,    -1,   583,   584,   585,   586,    -1,   588,   589,    -1,
     591,   592,    -1,   594,   595,    -1,    -1,   598,    -1,    -1,
     601,    -1,   603,    -1,   605,   606,   607,    -1,    -1,    -1,
      -1,    -1,    -1,   614,    -1,    -1,   617,    -1,    -1,    -1,
     621,   622,   623,   624,   625,   626,   627,    -1,    -1,    -1,
      -1,    -1,    -1,   634,   635,    -1,   637,   638,   639,    -1,
      -1,   642,    -1,    -1,    -1,     5,    -1,     7,     8,     9,
      10,    11,    12,   654,    -1,    15,    -1,    -1,    -1,    19,
      -1,   662,    22,    -1,    24,    25,    26,    27,    28,    29,
      30,    31,    -1,    33,    -1,    -1,    -1,    37,    -1,    -1,
      -1,    41,    -1,    -1,    44,    45,    46,    -1,    48,    -1,
      50,    51,    -1,    -1,    54,    -1,    -1,    57,    58,    -1,
      60,    61,    -1,    63,    64,    -1,    66,    67,    68,    69,
      70,    71,    72,    -1,    74,    75,    76,    77,    78,    79,
      80,    -1,    82,    83,    84,    85,    86,    87,    88,    89,
      -1,    91,    92,    -1,    94,    95,    96,    97,    98,    -1,
     100,    -1,    -1,   103,    -1,    -1,   106,    -1,   108,    -1,
      -1,   111,    -1,   113,    -1,    -1,    -1,   117,   118,   119,
      -1,    -1,   122,    -1,    -1,    -1,    -1,   127,   128,    -1,
      -1,    -1,    -1,   133,    -1,   135,    -1,    -1,    -1,   139,
      -1,   141,   142,   143,   144,   145,    -1,    -1,    -1,   149,
      -1,    -1,   152,   153,   154,    -1,    -1,    -1,   158,    -1,
     160,   161,    -1,   163,   164,   165,    -1,    -1,   168,   169,
      -1,   171,   172,   173,   174,   175,   176,   177,    -1,    -1,
     180,   181,   182,   183,    -1,    -1,   186,   187,    -1,   189,
     190,   191,    -1,    -1,   194,    -1,    -1,    -1,   198,    -1,
     200,    -1,   202,    -1,   204,   205,   206,   207,   208,   209,
     210,    -1,   212,    -1,    -1,    -1,   216,   217,   218,    -1,
     220,    -1,    -1,    -1,   224,   225,    -1,    -1,    -1,   229,
     230,   231,   232,   233,    -1,    -1,   236,   237,   238,    -1,
     240,    -1,   242,    -1,    -1,    -1,    -1,   247,   248,    -1,
      -1,    -1,   252,    -1,   254,   255,    -1,   257,   258,    -1,
      -1,    -1,   262,    -1,    -1,   265,   266,   267,    -1,    -1,
     270,    -1,    -1,   273,   274,    -1,    -1,    -1,    -1,    -1,
     280,   281,    -1,   283,    -1,   285,    -1,   287,   288,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   296,   297,   298,   299,
     300,   301,   302,   303,   304,   305,   306,   307,   308,   309,
     310,   311,    -1,   313,   314,   315,   316,    -1,   318,   319,
     320,   321,    -1,   323,   324,    -1,    -1,    -1,    -1,   329,
     330,   331,   332,   333,   334,    -1,    -1,   337,   338,    -1,
     340,    -1,   342,    -1,   344,   345,   346,   347,   348,   349,
     350,   351,   352,   353,    -1,    -1,   356,   357,    -1,    -1,
     360,   361,   362,   363,    -1,    -1,    -1,   367,   368,    -1,
      -1,    -1,   372,    -1,   374,   375,   376,    -1,   378,   379,
     380,   381,    -1,   383,   384,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   393,   394,   395,    -1,    -1,   398,    -1,
     400,    -1,   402,   403,   404,   405,   406,   407,   408,   409,
     410,   411,    -1,    -1,   414,   415,   416,    -1,   418,    -1,
     420,   421,   422,   423,   424,    -1,   426,   427,   428,    -1,
      -1,   431,    -1,    -1,    -1,   435,   436,   437,   438,   439,
      -1,    -1,   442,   443,   444,   445,   446,    -1,   448,   449,
      -1,   451,   452,   453,    -1,    -1,   456,    -1,   458,    -1,
     460,   461,    -1,   463,   464,    -1,   466,    -1,   468,    -1,
      -1,   471,   472,   473,   474,   475,   476,   477,   478,   479,
     480,   481,   482,    -1,   484,   485,   