; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-linux-gnu -global-isel -verify-machineinstrs < %s -o - | FileCheck %s --check-prefix=X64

define i64 @test_ashr_i64(i64 %arg1, i64 %arg2) {
; X64-LABEL: test_ashr_i64:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq %rsi, %rcx
; X64-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NEXT:    sarq %cl, %rax
; X64-NEXT:    retq
  %res = ashr i64 %arg1, %arg2
  ret i64 %res
}

define i64 @test_ashr_i64_imm(i64 %arg1) {
; X64-LABEL: test_ashr_i64_imm:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq $5, %rcx
; X64-NEXT:    sarq %cl, %rax
; X64-NEXT:    retq
  %res = ashr i64 %arg1, 5
  ret i64 %res
}

define i64 @test_ashr_i64_imm1(i64 %arg1) {
; X64-LABEL: test_ashr_i64_imm1:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    sarq %rax
; X64-NEXT:    retq
  %res = ashr i64 %arg1, 1
  ret i64 %res
}

define i32 @test_ashr_i32(i32 %arg1, i32 %arg2) {
; X64-LABEL: test_ashr_i32:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movl %esi, %ecx
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    sarl %cl, %eax
; X64-NEXT:    retq
  %res = ashr i32 %arg1, %arg2
  ret i32 %res
}

define i32 @test_ashr_i32_imm(i32 %arg1) {
; X64-LABEL: test_ashr_i32_imm:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movl $5, %ecx
; X64-NEXT:    sarl %cl, %eax
; X64-NEXT:    retq
  %res = ashr i32 %arg1, 5
  ret i32 %res
}

define i32 @test_ashr_i32_imm1(i32 %arg1) {
; X64-LABEL: test_ashr_i32_imm1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    sarl %eax
; X64-NEXT:    retq
  %res = ashr i32 %arg1, 1
  ret i32 %res
}

define i16 @test_ashr_i16(i32 %arg1, i32 %arg2) {
; X64-LABEL: test_ashr_i16:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movl %esi, %ecx
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    sarw %cl, %ax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %a = trunc i32 %arg1 to i16
  %a2 = trunc i32 %arg2 to i16
  %res = ashr i16 %a, %a2
  ret i16 %res
}

define i16 @test_ashr_i16_imm(i32 %arg1) {
; X64-LABEL: test_ashr_i16_imm:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movw $5, %cx
; X64-NEXT:    sarw %cl, %ax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %a = trunc i32 %arg1 to i16
  %res = ashr i16 %a, 5
  ret i16 %res
}

define i16 @test_ashr_i16_imm1(i32 %arg1) {
; X64-LABEL: test_ashr_i16_imm1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    sarw %ax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
  %a = trunc i32 %arg1 to i16
  %res = ashr i16 %a, 1
  ret i16 %res
}

define i8 @test_ashr_i8(i32 %arg1, i32 %arg2) {
; X64-LABEL: test_ashr_i8:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movl %esi, %ecx
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    sarb %cl, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %a = trunc i32 %arg1 to i8
  %a2 = trunc i32 %arg2 to i8
  %res = ashr i8 %a, %a2
  ret i8 %res
}

define i8 @test_ashr_i8_imm(i32 %arg1) {
; X64-LABEL: test_ashr_i8_imm:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    sarb $5, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %a = trunc i32 %arg1 to i8
  %res = ashr i8 %a, 5
  ret i8 %res
}

define i8 @test_ashr_i8_imm1(i32 %arg1) {
; X64-LABEL: test_ashr_i8_imm1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    sarb %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %a = trunc i32 %arg1 to i8
  %res = ashr i8 %a, 1
  ret i8 %res
}

define i1 @test_ashr_i1(i32 %arg1, i32 %arg2) {
; X64-LABEL: test_ashr_i1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movl %esi, %ecx
; X64-NEXT:    shlb $7, %al
; X64-NEXT:    sarb $7, %al
; X64-NEXT:    andb $1, %cl
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    sarb %cl, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %a = trunc i32 %arg1 to i1
  %a2 = trunc i32 %arg2 to i1
  %res = ashr i1 %a, %a2
  ret i1 %res
}

define i1 @test_ashr_i1_imm1(i32 %arg1) {
; X64-LABEL: test_ashr_i1_imm1:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    movb $-1, %cl
; X64-NEXT:    shlb $7, %al
; X64-NEXT:    sarb $7, %al
; X64-NEXT:    andb $1, %cl
; X64-NEXT:    sarb %cl, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %a = trunc i32 %arg1 to i1
  %res = ashr i1 %a, 1
  ret i1 %res
}
