; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc < %s -mtriple=aarch64-none-eabi | FileCheck %s

define i1 @load_bv_v4i8(i1 zeroext %a) {
; CHECK-LABEL: load_bv_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ret
  %b = zext i1 %a to i32
  %c = icmp eq i32 %b, 1
  ret i1 %c
}

define noundef i1 @logger(i32 noundef %logLevel, ptr %ea, ptr %pll) {
; CHECK-LABEL: logger:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ldr w8, [x2]
; CHECK-NEXT:    cmp w8, w0
; CHECK-NEXT:    b.ls .LBB1_2
; CHECK-NEXT:  // %bb.1:
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB1_2: // %land.rhs
; CHECK-NEXT:    ldr x8, [x1]
; CHECK-NEXT:    ldrb w8, [x8]
; CHECK-NEXT:    cmp w8, #0
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
entry:
  %0 = load i32, ptr %pll, align 4
  %cmp.not = icmp ugt i32 %0, %logLevel
  br i1 %cmp.not, label %land.end, label %land.rhs

land.rhs:                                         ; preds = %entry
  %1 = load ptr, ptr %ea, align 8
  %2 = load i8, ptr %1, align 1, !range !14, !noundef !15
  %tobool.i = icmp ne i8 %2, 0
  br label %land.end

land.end:                                         ; preds = %land.rhs, %entry
  %3 = phi i1 [ false, %entry ], [ %tobool.i, %land.rhs ]
  ret i1 %3
}
!14 = !{i8 0, i8 2}
!15 = !{}


declare i64 @llvm.ctlz.i64(i64 %in, i1)
define i1 @lshr_ctlz_undef_cmpeq_one_i64(i64 %in) {
; CHECK-LABEL: lshr_ctlz_undef_cmpeq_one_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    clz x8, x0
; CHECK-NEXT:    lsr x8, x8, #6
; CHECK-NEXT:    cmp x8, #1
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %ctlz = call i64 @llvm.ctlz.i64(i64 %in, i1 -1)
  %lshr = lshr i64 %ctlz, 6
  %icmp = icmp eq i64 %lshr, 1
  ret i1 %icmp
}

define i32 @PR17487(i1 %tobool) {
; CHECK-LABEL: PR17487:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v0.2s, w0
; CHECK-NEXT:    mov w8, #1 // =0x1
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    bic v0.16b, v1.16b, v0.16b
; CHECK-NEXT:    mov x8, v0.d[1]
; CHECK-NEXT:    cmp x8, #1
; CHECK-NEXT:    cset w0, ne
; CHECK-NEXT:    ret
  %tmp = insertelement <2 x i1> undef, i1 %tobool, i32 1
  %tmp1 = zext <2 x i1> %tmp to <2 x i64>
  %tmp2 = xor <2 x i64> %tmp1, <i64 1, i64 1>
  %tmp3 = extractelement <2 x i64> %tmp2, i32 1
  %add = add nsw i64 0, %tmp3
  %cmp6 = icmp ne i64 %add, 1
  %conv7 = zext i1 %cmp6 to i32
  ret i32 %conv7
}
