; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=aarch64-apple-ios %s -o - -aarch64-enable-nonlazybind | FileCheck %s --check-prefix=MACHO
; RUN: llc -mtriple=aarch64-apple-ios %s -o - | FileCheck %s --check-prefix=MACHO-NORMAL
; RUN: llc -mtriple=aarch64 -fast-isel %s -o - | FileCheck %s --check-prefixes=ELF,ELF-FI
; RUN: llc -mtriple=aarch64 -global-isel %s -o - | FileCheck %s --check-prefixes=ELF,ELF-GI
; RUN: llc -mtriple=aarch64 %s -o - | FileCheck %s --check-prefixes=ELF,ELF-SDAG

declare void @external() nonlazybind

define void @test_laziness(ptr %a) nounwind {
;
; MACHO-LABEL: test_laziness:
; MACHO:       ; %bb.0:
; MACHO-NEXT:    stp x20, x19, [sp, #-32]! ; 16-byte Folded Spill
; MACHO-NEXT:    stp x29, x30, [sp, #16] ; 16-byte Folded Spill
; MACHO-NEXT:  Lloh0:
; MACHO-NEXT:    adrp x8, _external@GOTPAGE
; MACHO-NEXT:    mov x19, x0
; MACHO-NEXT:  Lloh1:
; MACHO-NEXT:    ldr x8, [x8, _external@GOTPAGEOFF]
; MACHO-NEXT:    blr x8
; MACHO-NEXT:    mov x0, x19
; MACHO-NEXT:    mov w1, #1 ; =0x1
; MACHO-NEXT:    mov w2, #1000 ; =0x3e8
; MACHO-NEXT:    bl _memset
; MACHO-NEXT:    ldp x29, x30, [sp, #16] ; 16-byte Folded Reload
; MACHO-NEXT:    ldp x20, x19, [sp], #32 ; 16-byte Folded Reload
; MACHO-NEXT:    ret
; MACHO-NEXT:    .loh AdrpLdrGot Lloh0, Lloh1
;
; MACHO-NORMAL-LABEL: test_laziness:
; MACHO-NORMAL:       ; %bb.0:
; MACHO-NORMAL-NEXT:    stp x20, x19, [sp, #-32]! ; 16-byte Folded Spill
; MACHO-NORMAL-NEXT:    stp x29, x30, [sp, #16] ; 16-byte Folded Spill
; MACHO-NORMAL-NEXT:    mov x19, x0
; MACHO-NORMAL-NEXT:    bl _external
; MACHO-NORMAL-NEXT:    mov x0, x19
; MACHO-NORMAL-NEXT:    mov w1, #1 ; =0x1
; MACHO-NORMAL-NEXT:    mov w2, #1000 ; =0x3e8
; MACHO-NORMAL-NEXT:    bl _memset
; MACHO-NORMAL-NEXT:    ldp x29, x30, [sp, #16] ; 16-byte Folded Reload
; MACHO-NORMAL-NEXT:    ldp x20, x19, [sp], #32 ; 16-byte Folded Reload
; MACHO-NORMAL-NEXT:    ret
;
; ELF-FI-LABEL: test_laziness:
; ELF-FI:       // %bb.0:
; ELF-FI-NEXT:    stp x30, x19, [sp, #-16]! // 16-byte Folded Spill
; ELF-FI-NEXT:    mov x19, x0
; ELF-FI-NEXT:    bl external
; ELF-FI-NEXT:    mov w8, #1 // =0x1
; ELF-FI-NEXT:    mov x0, x19
; ELF-FI-NEXT:    mov x2, #1000 // =0x3e8
; ELF-FI-NEXT:    uxtb w1, w8
; ELF-FI-NEXT:    bl memset
; ELF-FI-NEXT:    ldp x30, x19, [sp], #16 // 16-byte Folded Reload
; ELF-FI-NEXT:    ret
;
; ELF-GI-LABEL: test_laziness:
; ELF-GI:       // %bb.0:
; ELF-GI-NEXT:    stp x30, x19, [sp, #-16]! // 16-byte Folded Spill
; ELF-GI-NEXT:    mov x19, x0
; ELF-GI-NEXT:    bl external
; ELF-GI-NEXT:    mov x0, x19
; ELF-GI-NEXT:    mov w1, #1 // =0x1
; ELF-GI-NEXT:    mov w2, #1000 // =0x3e8
; ELF-GI-NEXT:    bl memset
; ELF-GI-NEXT:    ldp x30, x19, [sp], #16 // 16-byte Folded Reload
; ELF-GI-NEXT:    ret
;
; ELF-SDAG-LABEL: test_laziness:
; ELF-SDAG:       // %bb.0:
; ELF-SDAG-NEXT:    stp x30, x19, [sp, #-16]! // 16-byte Folded Spill
; ELF-SDAG-NEXT:    mov x19, x0
; ELF-SDAG-NEXT:    bl external
; ELF-SDAG-NEXT:    mov x0, x19
; ELF-SDAG-NEXT:    mov w1, #1 // =0x1
; ELF-SDAG-NEXT:    mov w2, #1000 // =0x3e8
; ELF-SDAG-NEXT:    bl memset
; ELF-SDAG-NEXT:    ldp x30, x19, [sp], #16 // 16-byte Folded Reload
; ELF-SDAG-NEXT:    ret
  call void @external()
  call void @llvm.memset.p0.i64(ptr align 1 %a, i8 1, i64 1000, i1 false)
  ret void
}

define void @test_laziness_tail() nounwind {
; MACHO-LABEL: test_laziness_tail:
; MACHO:       ; %bb.0:
; MACHO-NEXT:  Lloh2:
; MACHO-NEXT:    adrp x0, _external@GOTPAGE
; MACHO-NEXT:  Lloh3:
; MACHO-NEXT:    ldr x0, [x0, _external@GOTPAGEOFF]
; MACHO-NEXT:    br x0
; MACHO-NEXT:    .loh AdrpLdrGot Lloh2, Lloh3
;
; MACHO-NORMAL-LABEL: test_laziness_tail:
; MACHO-NORMAL:       ; %bb.0:
; MACHO-NORMAL-NEXT:    b _external
;
; ELF-LABEL: test_laziness_tail:
; ELF:       // %bb.0:
; ELF-NEXT:    b external
  tail call void @external()
  ret void
}

declare void @llvm.memset.p0.i64(ptr nocapture writeonly, i8, i64, i1 immarg)

!llvm.module.flags = !{!0}
!0 = !{i32 7, !"RtLibUseGOT", i32 1}
