; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-- < %s | FileCheck %s

; Check if this causes infinite loop when estimation disabled
define <4 x float> @repeated_fp_divisor_noest(float %a, <4 x float> %b) {
; CHECK-LABEL: repeated_fp_divisor_noest:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xscvdpspn 0, 1
; CHECK-NEXT:    addis 3, 2, .LCPI0_1@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI0_1@toc@l
; CHECK-NEXT:    lxvd2x 1, 0, 3
; CHECK-NEXT:    addis 3, 2, .LCPI0_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI0_0@toc@l
; CHECK-NEXT:    xxspltw 0, 0, 0
; CHECK-NEXT:    xvdivsp 0, 1, 0
; CHECK-NEXT:    lxvd2x 1, 0, 3
; CHECK-NEXT:    xxswapd 35, 1
; CHECK-NEXT:    xvmulsp 1, 34, 35
; CHECK-NEXT:    xvmulsp 34, 1, 0
; CHECK-NEXT:    blr
  %ins = insertelement <4 x float> undef, float %a, i32 0
  %splat = shufflevector <4 x float> %ins, <4 x float> undef, <4 x i32> zeroinitializer
  %t1 = fmul reassoc <4 x float> %b, <float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 0x3FF028F5C0000000>
  %mul = fdiv reassoc arcp nsz <4 x float> %t1, %splat
  ret <4 x float> %mul
}

define <4 x float> @repeated_fp_divisor(float %a, <4 x float> %b) {
; CHECK-LABEL: repeated_fp_divisor:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xscvdpspn 0, 1
; CHECK-NEXT:    addis 3, 2, .LCPI1_0@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI1_0@toc@l
; CHECK-NEXT:    lxvd2x 2, 0, 3
; CHECK-NEXT:    addis 3, 2, .LCPI1_1@toc@ha
; CHECK-NEXT:    addi 3, 3, .LCPI1_1@toc@l
; CHECK-NEXT:    xxspltw 0, 0, 0
; CHECK-NEXT:    xvresp 1, 0
; CHECK-NEXT:    xvmaddasp 2, 0, 1
; CHECK-NEXT:    lxvd2x 0, 0, 3
; CHECK-NEXT:    xxswapd 35, 0
; CHECK-NEXT:    xvnmsubasp 1, 1, 2
; CHECK-NEXT:    xvmulsp 0, 34, 35
; CHECK-NEXT:    xvmulsp 34, 0, 1
; CHECK-NEXT:    blr
  %ins = insertelement <4 x float> undef, float %a, i32 0
  %splat = shufflevector <4 x float> %ins, <4 x float> undef, <4 x i32> zeroinitializer
  %t1 = fmul contract reassoc <4 x float> %b, <float 1.000000e+00, float 1.000000e+00, float 1.000000e+00, float 0x3FF028F5C0000000>
  %mul = fdiv contract reassoc arcp nsz ninf <4 x float> %t1, %splat
  ret <4 x float> %mul
}

