; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2             | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse4.2           | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2             | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f          | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f,avx512vl | FileCheck %s --check-prefixes=AVX512,AVX512VL

define <4 x float> @fadd_v4f32(<4 x i1> %b, <4 x float> noundef %x, <4 x float> noundef %y) {
; SSE2-LABEL: fadd_v4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    addps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fadd_v4f32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; SSE42-NEXT:    blendvps %xmm0, %xmm2, %xmm3
; SSE42-NEXT:    addps %xmm1, %xmm3
; SSE42-NEXT:    movaps %xmm3, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fadd_v4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm3, %xmm0
; AVX2-NEXT:    vaddps %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fadd_v4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} xmm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vaddps %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fadd_v4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vaddps %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovaps %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x float> %y, <4 x float> <float -0.0, float -0.0, float -0.0, float -0.0>
  %r = fadd <4 x float> %x, %s
  ret <4 x float> %r
}

define <8 x float> @fadd_v8f32_commute(<8 x i1> %b, <8 x float> noundef %x, <8 x float> noundef %y) {
; SSE2-LABEL: fadd_v8f32_commute:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm5
; SSE2-NEXT:    psrad $31, %xmm5
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; SSE2-NEXT:    pand %xmm5, %xmm4
; SSE2-NEXT:    pandn %xmm6, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm3
; SSE2-NEXT:    pandn %xmm6, %xmm0
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    addps %xmm1, %xmm0
; SSE2-NEXT:    addps %xmm2, %xmm5
; SSE2-NEXT:    movaps %xmm5, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fadd_v8f32_commute:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm6 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; SSE42-NEXT:    movaps %xmm6, %xmm7
; SSE42-NEXT:    blendvps %xmm0, %xmm3, %xmm7
; SSE42-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm4, %xmm6
; SSE42-NEXT:    addps %xmm1, %xmm7
; SSE42-NEXT:    addps %xmm2, %xmm6
; SSE42-NEXT:    movaps %xmm7, %xmm0
; SSE42-NEXT:    movaps %xmm6, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fadd_v8f32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX2-NEXT:    vblendvps %ymm0, %ymm2, %ymm3, %ymm0
; AVX2-NEXT:    vaddps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fadd_v8f32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm0 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vaddps %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fadd_v8f32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vaddps %ymm2, %ymm1, %ymm1 {%k1}
; AVX512VL-NEXT:    vmovaps %ymm1, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>
  %r = fadd <8 x float> %s, %x
  ret <8 x float> %r
}

define <16 x float> @fadd_v16f32_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; SSE2-LABEL: fadd_v16f32_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm10
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm10, %xmm8
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm8
; SSE2-NEXT:    movdqa %xmm8, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm9
; SSE2-NEXT:    por %xmm8, %xmm9
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm10
; SSE2-NEXT:    movdqa %xmm10, %xmm8
; SSE2-NEXT:    psrad $31, %xmm8
; SSE2-NEXT:    pandn %xmm7, %xmm8
; SSE2-NEXT:    por %xmm10, %xmm8
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm10
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm10
; SSE2-NEXT:    movdqa %xmm10, %xmm7
; SSE2-NEXT:    psrad $31, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    por %xmm10, %xmm7
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    psrad $31, %xmm6
; SSE2-NEXT:    pandn %xmm5, %xmm6
; SSE2-NEXT:    por %xmm6, %xmm0
; SSE2-NEXT:    addps %xmm1, %xmm0
; SSE2-NEXT:    addps %xmm2, %xmm7
; SSE2-NEXT:    addps %xmm3, %xmm8
; SSE2-NEXT:    addps %xmm4, %xmm9
; SSE2-NEXT:    movaps %xmm7, %xmm1
; SSE2-NEXT:    movaps %xmm8, %xmm2
; SSE2-NEXT:    movaps %xmm9, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fadd_v16f32_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movaps %xmm3, %xmm8
; SSE42-NEXT:    movdqa %xmm0, %xmm9
; SSE42-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm10 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm7
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm6
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm5
; SSE42-NEXT:    addps %xmm1, %xmm5
; SSE42-NEXT:    addps %xmm2, %xmm6
; SSE42-NEXT:    addps %xmm8, %xmm7
; SSE42-NEXT:    addps %xmm4, %xmm3
; SSE42-NEXT:    movaps %xmm5, %xmm0
; SSE42-NEXT:    movaps %xmm6, %xmm1
; SSE42-NEXT:    movaps %xmm7, %xmm2
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fadd_v16f32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm6 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX2-NEXT:    vblendvps %ymm5, %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vaddps %ymm3, %ymm1, %ymm0
; AVX2-NEXT:    vaddps %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fadd_v16f32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vaddps %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>, <16 x float> %y
  %r = fadd <16 x float> %x, %s
  ret <16 x float> %r
}

define <16 x float> @fadd_v16f32_commute_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; SSE2-LABEL: fadd_v16f32_commute_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm10
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm10, %xmm8
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm8
; SSE2-NEXT:    movdqa %xmm8, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm9
; SSE2-NEXT:    por %xmm8, %xmm9
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm10
; SSE2-NEXT:    movdqa %xmm10, %xmm8
; SSE2-NEXT:    psrad $31, %xmm8
; SSE2-NEXT:    pandn %xmm7, %xmm8
; SSE2-NEXT:    por %xmm10, %xmm8
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm10
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm10
; SSE2-NEXT:    movdqa %xmm10, %xmm7
; SSE2-NEXT:    psrad $31, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    por %xmm10, %xmm7
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    psrad $31, %xmm6
; SSE2-NEXT:    pandn %xmm5, %xmm6
; SSE2-NEXT:    por %xmm6, %xmm0
; SSE2-NEXT:    addps %xmm1, %xmm0
; SSE2-NEXT:    addps %xmm2, %xmm7
; SSE2-NEXT:    addps %xmm3, %xmm8
; SSE2-NEXT:    addps %xmm4, %xmm9
; SSE2-NEXT:    movaps %xmm7, %xmm1
; SSE2-NEXT:    movaps %xmm8, %xmm2
; SSE2-NEXT:    movaps %xmm9, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fadd_v16f32_commute_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movaps %xmm3, %xmm8
; SSE42-NEXT:    movdqa %xmm0, %xmm9
; SSE42-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm10 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm7
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm6
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm5
; SSE42-NEXT:    addps %xmm1, %xmm5
; SSE42-NEXT:    addps %xmm2, %xmm6
; SSE42-NEXT:    addps %xmm8, %xmm7
; SSE42-NEXT:    addps %xmm4, %xmm3
; SSE42-NEXT:    movaps %xmm5, %xmm0
; SSE42-NEXT:    movaps %xmm6, %xmm1
; SSE42-NEXT:    movaps %xmm7, %xmm2
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fadd_v16f32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm6 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX2-NEXT:    vblendvps %ymm5, %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vaddps %ymm1, %ymm3, %ymm0
; AVX2-NEXT:    vaddps %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fadd_v16f32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vaddps %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>, <16 x float> %y
  %r = fadd <16 x float> %s, %x
  ret <16 x float> %r
}

define <4 x float> @fsub_v4f32(<4 x i1> %b, <4 x float> noundef %x, <4 x float> noundef %y) {
; SSE-LABEL: fsub_v4f32:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $31, %xmm0
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    subps %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX2-LABEL: fsub_v4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vsubps %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fsub_v4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vsubps %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fsub_v4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vsubps %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovaps %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x float> %y, <4 x float> zeroinitializer
  %r = fsub <4 x float> %x, %s
  ret <4 x float> %r
}

; negative test - fsub is not commutative; there is no identity constant for operand 0

define <8 x float> @fsub_v8f32_commute(<8 x i1> %b, <8 x float> noundef %x, <8 x float> noundef %y) {
; SSE2-LABEL: fsub_v8f32_commute:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm5
; SSE2-NEXT:    psrad $31, %xmm5
; SSE2-NEXT:    pand %xmm4, %xmm5
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    subps %xmm1, %xmm0
; SSE2-NEXT:    subps %xmm2, %xmm5
; SSE2-NEXT:    movaps %xmm5, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fsub_v8f32_commute:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE42-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    psrad $31, %xmm5
; SSE42-NEXT:    pand %xmm4, %xmm5
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    psrad $31, %xmm0
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    subps %xmm1, %xmm0
; SSE42-NEXT:    subps %xmm2, %xmm5
; SSE42-NEXT:    movaps %xmm5, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fsub_v8f32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vsubps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fsub_v8f32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vsubps %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fsub_v8f32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vmovaps %ymm2, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vsubps %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> zeroinitializer
  %r = fsub <8 x float> %s, %x
  ret <8 x float> %r
}

define <16 x float> @fsub_v16f32_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; SSE2-LABEL: fsub_v16f32_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm9
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm9, %xmm8
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm8
; SSE2-NEXT:    psrad $31, %xmm8
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm8
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    pandn %xmm7, %xmm9
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm7
; SSE2-NEXT:    psrad $31, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pandn %xmm5, %xmm0
; SSE2-NEXT:    subps %xmm0, %xmm1
; SSE2-NEXT:    subps %xmm7, %xmm2
; SSE2-NEXT:    subps %xmm9, %xmm3
; SSE2-NEXT:    subps %xmm8, %xmm4
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    movaps %xmm2, %xmm1
; SSE2-NEXT:    movaps %xmm3, %xmm2
; SSE2-NEXT:    movaps %xmm4, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fsub_v16f32_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm8 = xmm8[0],zero,zero,zero,xmm8[1],zero,zero,zero,xmm8[2],zero,zero,zero,xmm8[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm8
; SSE42-NEXT:    psrad $31, %xmm8
; SSE42-NEXT:    pandn %xmm7, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,xmm7[1],zero,zero,zero,xmm7[2],zero,zero,zero,xmm7[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm7
; SSE42-NEXT:    psrad $31, %xmm7
; SSE42-NEXT:    pandn %xmm6, %xmm7
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm6 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm6
; SSE42-NEXT:    psrad $31, %xmm6
; SSE42-NEXT:    pandn %xmm5, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    psrad $31, %xmm0
; SSE42-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm0
; SSE42-NEXT:    subps %xmm6, %xmm1
; SSE42-NEXT:    subps %xmm7, %xmm2
; SSE42-NEXT:    subps %xmm8, %xmm3
; SSE42-NEXT:    subps %xmm0, %xmm4
; SSE42-NEXT:    movaps %xmm1, %xmm0
; SSE42-NEXT:    movaps %xmm2, %xmm1
; SSE42-NEXT:    movaps %xmm3, %xmm2
; SSE42-NEXT:    movaps %xmm4, %xmm3
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fsub_v16f32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vsubps %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vsubps %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fsub_v16f32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vsubps %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> zeroinitializer, <16 x float> %y
  %r = fsub <16 x float> %x, %s
  ret <16 x float> %r
}

; negative test - fsub is not commutative; there is no identity constant for operand 0

define <16 x float> @fsub_v16f32_commute_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; SSE2-LABEL: fsub_v16f32_commute_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps %xmm2, %xmm8
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm2, %xmm9
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm9 = xmm9[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm9
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    pandn %xmm7, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm7
; SSE2-NEXT:    psrad $31, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pandn %xmm5, %xmm0
; SSE2-NEXT:    subps %xmm1, %xmm0
; SSE2-NEXT:    subps %xmm8, %xmm7
; SSE2-NEXT:    subps %xmm3, %xmm2
; SSE2-NEXT:    subps %xmm4, %xmm9
; SSE2-NEXT:    movaps %xmm7, %xmm1
; SSE2-NEXT:    movaps %xmm9, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fsub_v16f32_commute_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movaps %xmm2, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm2
; SSE42-NEXT:    psrad $31, %xmm2
; SSE42-NEXT:    pandn %xmm7, %xmm2
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,xmm7[1],zero,zero,zero,xmm7[2],zero,zero,zero,xmm7[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm7
; SSE42-NEXT:    psrad $31, %xmm7
; SSE42-NEXT:    pandn %xmm6, %xmm7
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm6 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm6
; SSE42-NEXT:    psrad $31, %xmm6
; SSE42-NEXT:    pandn %xmm5, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    psrad $31, %xmm5
; SSE42-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm5
; SSE42-NEXT:    subps %xmm1, %xmm6
; SSE42-NEXT:    subps %xmm8, %xmm7
; SSE42-NEXT:    subps %xmm3, %xmm2
; SSE42-NEXT:    subps %xmm4, %xmm5
; SSE42-NEXT:    movaps %xmm6, %xmm0
; SSE42-NEXT:    movaps %xmm7, %xmm1
; SSE42-NEXT:    movaps %xmm5, %xmm3
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fsub_v16f32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vsubps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vsubps %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fsub_v16f32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmovaps %zmm2, %zmm0 {%k1} {z}
; AVX512-NEXT:    vsubps %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> zeroinitializer, <16 x float> %y
  %r = fsub <16 x float> %s, %x
  ret <16 x float> %r
}

define <4 x float> @fmul_v4f32(<4 x i1> %b, <4 x float> noundef %x, <4 x float> noundef %y) {
; SSE2-LABEL: fmul_v4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    mulps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fmul_v4f32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE42-NEXT:    blendvps %xmm0, %xmm2, %xmm3
; SSE42-NEXT:    mulps %xmm1, %xmm3
; SSE42-NEXT:    movaps %xmm3, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fmul_v4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm3, %xmm0
; AVX2-NEXT:    vmulps %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fmul_v4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} xmm0 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vmulps %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fmul_v4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vmulps %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovaps %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x float> %y, <4 x float> <float 1.0, float 1.0, float 1.0, float 1.0>
  %r = fmul <4 x float> %x, %s
  ret <4 x float> %r
}

define <8 x float> @fmul_v8f32_commute(<8 x i1> %b, <8 x float> noundef %x, <8 x float> noundef %y) {
; SSE2-LABEL: fmul_v8f32_commute:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm5
; SSE2-NEXT:    psrad $31, %xmm5
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE2-NEXT:    pand %xmm5, %xmm4
; SSE2-NEXT:    pandn %xmm6, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm3
; SSE2-NEXT:    pandn %xmm6, %xmm0
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    mulps %xmm1, %xmm0
; SSE2-NEXT:    mulps %xmm2, %xmm5
; SSE2-NEXT:    movaps %xmm5, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fmul_v8f32_commute:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE42-NEXT:    movaps %xmm6, %xmm7
; SSE42-NEXT:    blendvps %xmm0, %xmm3, %xmm7
; SSE42-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm4, %xmm6
; SSE42-NEXT:    mulps %xmm1, %xmm7
; SSE42-NEXT:    mulps %xmm2, %xmm6
; SSE42-NEXT:    movaps %xmm7, %xmm0
; SSE42-NEXT:    movaps %xmm6, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fmul_v8f32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm0, %ymm2, %ymm3, %ymm0
; AVX2-NEXT:    vmulps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fmul_v8f32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm0 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vmulps %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fmul_v8f32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vmulps %ymm2, %ymm1, %ymm1 {%k1}
; AVX512VL-NEXT:    vmovaps %ymm1, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>
  %r = fmul <8 x float> %s, %x
  ret <8 x float> %r
}

define <16 x float> @fmul_v16f32_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; SSE2-LABEL: fmul_v16f32_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps %xmm2, %xmm8
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm2, %xmm10
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm10
; SSE2-NEXT:    psrad $31, %xmm10
; SSE2-NEXT:    movdqa {{.*#+}} xmm11 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE2-NEXT:    movdqa %xmm11, %xmm9
; SSE2-NEXT:    pand %xmm10, %xmm9
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm10
; SSE2-NEXT:    por %xmm9, %xmm10
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    movdqa %xmm11, %xmm9
; SSE2-NEXT:    pand %xmm2, %xmm9
; SSE2-NEXT:    pandn %xmm7, %xmm2
; SSE2-NEXT:    por %xmm9, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm9
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm9 = xmm9[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    movdqa %xmm11, %xmm7
; SSE2-NEXT:    pand %xmm9, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm9
; SSE2-NEXT:    por %xmm7, %xmm9
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm11
; SSE2-NEXT:    pandn %xmm5, %xmm0
; SSE2-NEXT:    por %xmm11, %xmm0
; SSE2-NEXT:    mulps %xmm1, %xmm0
; SSE2-NEXT:    mulps %xmm8, %xmm9
; SSE2-NEXT:    mulps %xmm3, %xmm2
; SSE2-NEXT:    mulps %xmm4, %xmm10
; SSE2-NEXT:    movaps %xmm9, %xmm1
; SSE2-NEXT:    movaps %xmm10, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fmul_v16f32_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movaps %xmm3, %xmm8
; SSE42-NEXT:    movdqa %xmm0, %xmm9
; SSE42-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm10 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm7
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm6
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm5
; SSE42-NEXT:    mulps %xmm1, %xmm5
; SSE42-NEXT:    mulps %xmm2, %xmm6
; SSE42-NEXT:    mulps %xmm8, %xmm7
; SSE42-NEXT:    mulps %xmm4, %xmm3
; SSE42-NEXT:    movaps %xmm5, %xmm0
; SSE42-NEXT:    movaps %xmm6, %xmm1
; SSE42-NEXT:    movaps %xmm7, %xmm2
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fmul_v16f32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm5, %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vmulps %ymm3, %ymm1, %ymm0
; AVX2-NEXT:    vmulps %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fmul_v16f32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmulps %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>, <16 x float> %y
  %r = fmul <16 x float> %x, %s
  ret <16 x float> %r
}

define <16 x float> @fmul_v16f32_commute_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; SSE2-LABEL: fmul_v16f32_commute_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps %xmm2, %xmm8
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm2, %xmm10
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm10
; SSE2-NEXT:    psrad $31, %xmm10
; SSE2-NEXT:    movdqa {{.*#+}} xmm11 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE2-NEXT:    movdqa %xmm11, %xmm9
; SSE2-NEXT:    pand %xmm10, %xmm9
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm10
; SSE2-NEXT:    por %xmm9, %xmm10
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    movdqa %xmm11, %xmm9
; SSE2-NEXT:    pand %xmm2, %xmm9
; SSE2-NEXT:    pandn %xmm7, %xmm2
; SSE2-NEXT:    por %xmm9, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm9
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm9 = xmm9[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    movdqa %xmm11, %xmm7
; SSE2-NEXT:    pand %xmm9, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm9
; SSE2-NEXT:    por %xmm7, %xmm9
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm11
; SSE2-NEXT:    pandn %xmm5, %xmm0
; SSE2-NEXT:    por %xmm11, %xmm0
; SSE2-NEXT:    mulps %xmm1, %xmm0
; SSE2-NEXT:    mulps %xmm8, %xmm9
; SSE2-NEXT:    mulps %xmm3, %xmm2
; SSE2-NEXT:    mulps %xmm4, %xmm10
; SSE2-NEXT:    movaps %xmm9, %xmm1
; SSE2-NEXT:    movaps %xmm10, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fmul_v16f32_commute_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movaps %xmm3, %xmm8
; SSE42-NEXT:    movdqa %xmm0, %xmm9
; SSE42-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm10 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm7
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm6
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm5
; SSE42-NEXT:    mulps %xmm1, %xmm5
; SSE42-NEXT:    mulps %xmm2, %xmm6
; SSE42-NEXT:    mulps %xmm8, %xmm7
; SSE42-NEXT:    mulps %xmm4, %xmm3
; SSE42-NEXT:    movaps %xmm5, %xmm0
; SSE42-NEXT:    movaps %xmm6, %xmm1
; SSE42-NEXT:    movaps %xmm7, %xmm2
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fmul_v16f32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm5, %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vmulps %ymm1, %ymm3, %ymm0
; AVX2-NEXT:    vmulps %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fmul_v16f32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmulps %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>, <16 x float> %y
  %r = fmul <16 x float> %s, %x
  ret <16 x float> %r
}

define <4 x float> @fdiv_v4f32(<4 x i1> %b, <4 x float> noundef %x, <4 x float> noundef %y) {
; SSE2-LABEL: fdiv_v4f32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    divps %xmm0, %xmm1
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fdiv_v4f32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE42-NEXT:    blendvps %xmm0, %xmm2, %xmm3
; SSE42-NEXT:    divps %xmm3, %xmm1
; SSE42-NEXT:    movaps %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fdiv_v4f32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm3, %xmm0
; AVX2-NEXT:    vdivps %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fdiv_v4f32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} xmm0 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vdivps %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fdiv_v4f32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vdivps %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovaps %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x float> %y, <4 x float> <float 1.0, float 1.0, float 1.0, float 1.0>
  %r = fdiv <4 x float> %x, %s
  ret <4 x float> %r
}

define <8 x float> @fdiv_v8f32_commute(<8 x i1> %b, <8 x float> noundef %x, <8 x float> noundef %y) {
; SSE2-LABEL: fdiv_v8f32_commute:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm5
; SSE2-NEXT:    psrad $31, %xmm5
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE2-NEXT:    pand %xmm5, %xmm4
; SSE2-NEXT:    pandn %xmm6, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm3
; SSE2-NEXT:    pandn %xmm6, %xmm0
; SSE2-NEXT:    por %xmm3, %xmm0
; SSE2-NEXT:    divps %xmm1, %xmm0
; SSE2-NEXT:    divps %xmm2, %xmm5
; SSE2-NEXT:    movaps %xmm5, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fdiv_v8f32_commute:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE42-NEXT:    movaps %xmm6, %xmm7
; SSE42-NEXT:    blendvps %xmm0, %xmm3, %xmm7
; SSE42-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm4, %xmm6
; SSE42-NEXT:    divps %xmm1, %xmm7
; SSE42-NEXT:    divps %xmm2, %xmm6
; SSE42-NEXT:    movaps %xmm7, %xmm0
; SSE42-NEXT:    movaps %xmm6, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fdiv_v8f32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm0, %ymm2, %ymm3, %ymm0
; AVX2-NEXT:    vdivps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fdiv_v8f32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm0 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512F-NEXT:    vmovaps %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vdivps %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fdiv_v8f32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vbroadcastss {{.*#+}} ymm0 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512VL-NEXT:    vmovaps %ymm2, %ymm0 {%k1}
; AVX512VL-NEXT:    vdivps %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>
  %r = fdiv <8 x float> %s, %x
  ret <8 x float> %r
}

define <16 x float> @fdiv_v16f32_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; SSE2-LABEL: fdiv_v16f32_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm9
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm9, %xmm8
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm8
; SSE2-NEXT:    psrad $31, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE2-NEXT:    movdqa %xmm10, %xmm11
; SSE2-NEXT:    pand %xmm8, %xmm11
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm8
; SSE2-NEXT:    por %xmm11, %xmm8
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    movdqa %xmm10, %xmm11
; SSE2-NEXT:    pand %xmm9, %xmm11
; SSE2-NEXT:    pandn %xmm7, %xmm9
; SSE2-NEXT:    por %xmm11, %xmm9
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm7
; SSE2-NEXT:    psrad $31, %xmm7
; SSE2-NEXT:    movdqa %xmm10, %xmm11
; SSE2-NEXT:    pand %xmm7, %xmm11
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    por %xmm11, %xmm7
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm10
; SSE2-NEXT:    pandn %xmm5, %xmm0
; SSE2-NEXT:    por %xmm10, %xmm0
; SSE2-NEXT:    divps %xmm0, %xmm1
; SSE2-NEXT:    divps %xmm7, %xmm2
; SSE2-NEXT:    divps %xmm9, %xmm3
; SSE2-NEXT:    divps %xmm8, %xmm4
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    movaps %xmm2, %xmm1
; SSE2-NEXT:    movaps %xmm3, %xmm2
; SSE2-NEXT:    movaps %xmm4, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fdiv_v16f32_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm8
; SSE42-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm9
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm10 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm9
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm8[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm7
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm8[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm6
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm8[0],zero,zero,zero,xmm8[1],zero,zero,zero,xmm8[2],zero,zero,zero,xmm8[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm5
; SSE42-NEXT:    divps %xmm5, %xmm1
; SSE42-NEXT:    divps %xmm6, %xmm2
; SSE42-NEXT:    divps %xmm7, %xmm3
; SSE42-NEXT:    divps %xmm9, %xmm4
; SSE42-NEXT:    movaps %xmm1, %xmm0
; SSE42-NEXT:    movaps %xmm2, %xmm1
; SSE42-NEXT:    movaps %xmm3, %xmm2
; SSE42-NEXT:    movaps %xmm4, %xmm3
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fdiv_v16f32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm5, %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vdivps %ymm3, %ymm1, %ymm0
; AVX2-NEXT:    vdivps %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fdiv_v16f32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vdivps %zmm2, %zmm1, %zmm0
; AVX512-NEXT:    vmovaps %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>, <16 x float> %y
  %r = fdiv <16 x float> %x, %s
  ret <16 x float> %r
}

define <16 x float> @fdiv_v16f32_commute_swap(<16 x i1> %b, <16 x float> noundef %x, <16 x float> noundef %y) {
; SSE2-LABEL: fdiv_v16f32_commute_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movaps %xmm2, %xmm8
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm2, %xmm10
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm10 = xmm10[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm10
; SSE2-NEXT:    psrad $31, %xmm10
; SSE2-NEXT:    movdqa {{.*#+}} xmm11 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE2-NEXT:    movdqa %xmm11, %xmm9
; SSE2-NEXT:    pand %xmm10, %xmm9
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm10
; SSE2-NEXT:    por %xmm9, %xmm10
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    movdqa %xmm11, %xmm9
; SSE2-NEXT:    pand %xmm2, %xmm9
; SSE2-NEXT:    pandn %xmm7, %xmm2
; SSE2-NEXT:    por %xmm9, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm9
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm9 = xmm9[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    movdqa %xmm11, %xmm7
; SSE2-NEXT:    pand %xmm9, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm9
; SSE2-NEXT:    por %xmm7, %xmm9
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm11
; SSE2-NEXT:    pandn %xmm5, %xmm0
; SSE2-NEXT:    por %xmm11, %xmm0
; SSE2-NEXT:    divps %xmm1, %xmm0
; SSE2-NEXT:    divps %xmm8, %xmm9
; SSE2-NEXT:    divps %xmm3, %xmm2
; SSE2-NEXT:    divps %xmm4, %xmm10
; SSE2-NEXT:    movaps %xmm9, %xmm1
; SSE2-NEXT:    movaps %xmm10, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fdiv_v16f32_commute_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movaps %xmm3, %xmm8
; SSE42-NEXT:    movdqa %xmm0, %xmm9
; SSE42-NEXT:    movaps {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm10 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm7
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm9[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm6
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm9[0],zero,zero,zero,xmm9[1],zero,zero,zero,xmm9[2],zero,zero,zero,xmm9[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm10, %xmm5
; SSE42-NEXT:    divps %xmm1, %xmm5
; SSE42-NEXT:    divps %xmm2, %xmm6
; SSE42-NEXT:    divps %xmm8, %xmm7
; SSE42-NEXT:    divps %xmm4, %xmm3
; SSE42-NEXT:    movaps %xmm5, %xmm0
; SSE42-NEXT:    movaps %xmm6, %xmm1
; SSE42-NEXT:    movaps %xmm7, %xmm2
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fdiv_v16f32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm5, %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm0 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vblendvps %ymm0, %ymm6, %ymm4, %ymm4
; AVX2-NEXT:    vdivps %ymm1, %ymm3, %ymm0
; AVX2-NEXT:    vdivps %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fdiv_v16f32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vbroadcastss {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2 {%k1}
; AVX512-NEXT:    vdivps %zmm1, %zmm2, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>, <16 x float> %y
  %r = fdiv <16 x float> %s, %x
  ret <16 x float> %r
}

define <8 x float> @fadd_v8f32_cast_cond(i8 noundef zeroext %pb, <8 x float> noundef %x, <8 x float> noundef %y) {
; SSE2-LABEL: fadd_v8f32_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [16,32,64,128]
; SSE2-NEXT:    movdqa %xmm4, %xmm6
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; SSE2-NEXT:    pand %xmm6, %xmm3
; SSE2-NEXT:    pandn %xmm5, %xmm6
; SSE2-NEXT:    por %xmm3, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8]
; SSE2-NEXT:    pand %xmm3, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    pandn %xmm5, %xmm4
; SSE2-NEXT:    por %xmm2, %xmm4
; SSE2-NEXT:    addps %xmm4, %xmm0
; SSE2-NEXT:    addps %xmm6, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fadd_v8f32_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movaps %xmm0, %xmm4
; SSE42-NEXT:    movd %edi, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,0,0,0]
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [16,32,64,128]
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    pand %xmm6, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm6, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm6 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; SSE42-NEXT:    movaps %xmm6, %xmm7
; SSE42-NEXT:    blendvps %xmm0, %xmm3, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm0 = [1,2,4,8]
; SSE42-NEXT:    pand %xmm0, %xmm5
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm2, %xmm6
; SSE42-NEXT:    addps %xmm4, %xmm6
; SSE42-NEXT:    addps %xmm7, %xmm1
; SSE42-NEXT:    movaps %xmm6, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fadd_v8f32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX2-NEXT:    vblendvps %ymm2, %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vaddps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fadd_v8f32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm2 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX512F-NEXT:    vmovaps %zmm1, %zmm2 {%k1}
; AVX512F-NEXT:    vaddps %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fadd_v8f32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vaddps %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> <float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0, float -0.0>
  %r = fadd <8 x float> %x, %s
  ret <8 x float> %r
}

define <8 x double> @fadd_v8f64_cast_cond(i8 noundef zeroext %pb, <8 x double> noundef %x, <8 x double> noundef %y) {
; SSE2-LABEL: fadd_v8f64_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [64,128]
; SSE2-NEXT:    movdqa %xmm9, %xmm10
; SSE2-NEXT:    pand %xmm8, %xmm10
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm10[1,0,3,2]
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [-0.0E+0,-0.0E+0]
; SSE2-NEXT:    pand %xmm8, %xmm7
; SSE2-NEXT:    pandn %xmm10, %xmm8
; SSE2-NEXT:    por %xmm7, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm7 = [16,32]
; SSE2-NEXT:    movdqa %xmm9, %xmm11
; SSE2-NEXT:    pand %xmm7, %xmm11
; SSE2-NEXT:    pcmpeqd %xmm7, %xmm11
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm11[1,0,3,2]
; SSE2-NEXT:    pand %xmm11, %xmm7
; SSE2-NEXT:    pand %xmm7, %xmm6
; SSE2-NEXT:    pandn %xmm10, %xmm7
; SSE2-NEXT:    por %xmm6, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE2-NEXT:    movdqa %xmm9, %xmm11
; SSE2-NEXT:    pand %xmm6, %xmm11
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm11
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm11[1,0,3,2]
; SSE2-NEXT:    pand %xmm11, %xmm6
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    pandn %xmm10, %xmm6
; SSE2-NEXT:    por %xmm5, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[1,0,3,2]
; SSE2-NEXT:    pand %xmm9, %xmm5
; SSE2-NEXT:    pand %xmm5, %xmm4
; SSE2-NEXT:    pandn %xmm10, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    addpd %xmm5, %xmm0
; SSE2-NEXT:    addpd %xmm6, %xmm1
; SSE2-NEXT:    addpd %xmm7, %xmm2
; SSE2-NEXT:    addpd %xmm8, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fadd_v8f64_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movapd %xmm0, %xmm8
; SSE42-NEXT:    movd %edi, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm10 = xmm0[0,1,0,1]
; SSE42-NEXT:    movdqa {{.*#+}} xmm9 = [64,128]
; SSE42-NEXT:    movdqa %xmm10, %xmm0
; SSE42-NEXT:    pand %xmm9, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm9, %xmm0
; SSE42-NEXT:    movapd {{.*#+}} xmm9 = [-0.0E+0,-0.0E+0]
; SSE42-NEXT:    movapd %xmm9, %xmm11
; SSE42-NEXT:    blendvpd %xmm0, %xmm7, %xmm11
; SSE42-NEXT:    movdqa {{.*#+}} xmm7 = [16,32]
; SSE42-NEXT:    movdqa %xmm10, %xmm0
; SSE42-NEXT:    pand %xmm7, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm7, %xmm0
; SSE42-NEXT:    movapd %xmm9, %xmm7
; SSE42-NEXT:    blendvpd %xmm0, %xmm6, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE42-NEXT:    movdqa %xmm10, %xmm0
; SSE42-NEXT:    pand %xmm6, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm6, %xmm0
; SSE42-NEXT:    movapd %xmm9, %xmm6
; SSE42-NEXT:    blendvpd %xmm0, %xmm5, %xmm6
; SSE42-NEXT:    movdqa {{.*#+}} xmm0 = [1,2]
; SSE42-NEXT:    pand %xmm0, %xmm10
; SSE42-NEXT:    pcmpeqq %xmm0, %xmm10
; SSE42-NEXT:    movdqa %xmm10, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm4, %xmm9
; SSE42-NEXT:    addpd %xmm8, %xmm9
; SSE42-NEXT:    addpd %xmm6, %xmm1
; SSE42-NEXT:    addpd %xmm7, %xmm2
; SSE42-NEXT:    addpd %xmm11, %xmm3
; SSE42-NEXT:    movapd %xmm9, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fadd_v8f64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [-0.0E+0,-0.0E+0,-0.0E+0,-0.0E+0]
; AVX2-NEXT:    vblendvpd %ymm5, %ymm3, %ymm6, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm2, %ymm6, %ymm2
; AVX2-NEXT:    vaddpd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vaddpd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fadd_v8f64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vaddpd %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x double> %y, <8 x double> <double -0.0, double -0.0, double -0.0, double -0.0, double -0.0, double -0.0, double -0.0, double -0.0>
  %r = fadd <8 x double> %x, %s
  ret <8 x double> %r
}

define <8 x float> @fsub_v8f32_cast_cond(i8 noundef zeroext %pb, <8 x float> noundef %x, <8 x float> noundef %y) {
; SSE-LABEL: fsub_v8f32_cast_cond:
; SSE:       # %bb.0:
; SSE-NEXT:    movd %edi, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [16,32,64,128]
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pand %xmm5, %xmm6
; SSE-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8]
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    subps %xmm4, %xmm0
; SSE-NEXT:    subps %xmm6, %xmm1
; SSE-NEXT:    retq
;
; AVX2-LABEL: fsub_v8f32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vsubps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fsub_v8f32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vmovaps %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vsubps %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fsub_v8f32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vsubps %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> zeroinitializer
  %r = fsub <8 x float> %x, %s
  ret <8 x float> %r
}

define <8 x double> @fsub_v8f64_cast_cond(i8 noundef zeroext %pb, <8 x double> noundef %x, <8 x double> noundef %y) {
; SSE2-LABEL: fsub_v8f64_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [64,128]
; SSE2-NEXT:    movdqa %xmm9, %xmm8
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm8[1,0,3,2]
; SSE2-NEXT:    pand %xmm7, %xmm8
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [16,32]
; SSE2-NEXT:    movdqa %xmm9, %xmm7
; SSE2-NEXT:    pand %xmm10, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm7[1,0,3,2]
; SSE2-NEXT:    pand %xmm6, %xmm7
; SSE2-NEXT:    pand %xmm10, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE2-NEXT:    movdqa %xmm9, %xmm10
; SSE2-NEXT:    pand %xmm6, %xmm10
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm10[1,0,3,2]
; SSE2-NEXT:    pand %xmm5, %xmm10
; SSE2-NEXT:    pand %xmm6, %xmm10
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[1,0,3,2]
; SSE2-NEXT:    pand %xmm4, %xmm9
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    subpd %xmm9, %xmm0
; SSE2-NEXT:    subpd %xmm10, %xmm1
; SSE2-NEXT:    subpd %xmm7, %xmm2
; SSE2-NEXT:    subpd %xmm8, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fsub_v8f64_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movd %edi, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE42-NEXT:    movdqa {{.*#+}} xmm10 = [64,128]
; SSE42-NEXT:    movdqa %xmm9, %xmm8
; SSE42-NEXT:    pand %xmm10, %xmm8
; SSE42-NEXT:    pcmpeqq %xmm10, %xmm8
; SSE42-NEXT:    pand %xmm7, %xmm8
; SSE42-NEXT:    movdqa {{.*#+}} xmm7 = [16,32]
; SSE42-NEXT:    movdqa %xmm9, %xmm10
; SSE42-NEXT:    pand %xmm7, %xmm10
; SSE42-NEXT:    pcmpeqq %xmm7, %xmm10
; SSE42-NEXT:    pand %xmm6, %xmm10
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE42-NEXT:    movdqa %xmm9, %xmm7
; SSE42-NEXT:    pand %xmm6, %xmm7
; SSE42-NEXT:    pcmpeqq %xmm6, %xmm7
; SSE42-NEXT:    pand %xmm5, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE42-NEXT:    pand %xmm5, %xmm9
; SSE42-NEXT:    pcmpeqq %xmm5, %xmm9
; SSE42-NEXT:    pand %xmm4, %xmm9
; SSE42-NEXT:    subpd %xmm9, %xmm0
; SSE42-NEXT:    subpd %xmm7, %xmm1
; SSE42-NEXT:    subpd %xmm10, %xmm2
; SSE42-NEXT:    subpd %xmm8, %xmm3
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fsub_v8f64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpand %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vsubpd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vsubpd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fsub_v8f64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vsubpd %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x double> %y, <8 x double> zeroinitializer
  %r = fsub <8 x double> %x, %s
  ret <8 x double> %r
}

define <8 x float> @fmul_v8f32_cast_cond(i8 noundef zeroext %pb, <8 x float> noundef %x, <8 x float> noundef %y) {
; SSE2-LABEL: fmul_v8f32_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [16,32,64,128]
; SSE2-NEXT:    movdqa %xmm4, %xmm6
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE2-NEXT:    pand %xmm6, %xmm3
; SSE2-NEXT:    pandn %xmm5, %xmm6
; SSE2-NEXT:    por %xmm3, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8]
; SSE2-NEXT:    pand %xmm3, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    pandn %xmm5, %xmm4
; SSE2-NEXT:    por %xmm2, %xmm4
; SSE2-NEXT:    mulps %xmm4, %xmm0
; SSE2-NEXT:    mulps %xmm6, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fmul_v8f32_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movaps %xmm0, %xmm4
; SSE42-NEXT:    movd %edi, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,0,0,0]
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [16,32,64,128]
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    pand %xmm6, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm6, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE42-NEXT:    movaps %xmm6, %xmm7
; SSE42-NEXT:    blendvps %xmm0, %xmm3, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm0 = [1,2,4,8]
; SSE42-NEXT:    pand %xmm0, %xmm5
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm2, %xmm6
; SSE42-NEXT:    mulps %xmm4, %xmm6
; SSE42-NEXT:    mulps %xmm7, %xmm1
; SSE42-NEXT:    movaps %xmm6, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fmul_v8f32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm2, %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vmulps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fmul_v8f32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm2 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512F-NEXT:    vmovaps %zmm1, %zmm2 {%k1}
; AVX512F-NEXT:    vmulps %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fmul_v8f32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vmulps %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>
  %r = fmul <8 x float> %x, %s
  ret <8 x float> %r
}

define <8 x double> @fmul_v8f64_cast_cond(i8 noundef zeroext %pb, <8 x double> noundef %x, <8 x double> noundef %y) {
; SSE2-LABEL: fmul_v8f64_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [64,128]
; SSE2-NEXT:    movdqa %xmm9, %xmm10
; SSE2-NEXT:    pand %xmm8, %xmm10
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm10[1,0,3,2]
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [1.0E+0,1.0E+0]
; SSE2-NEXT:    pand %xmm8, %xmm7
; SSE2-NEXT:    pandn %xmm10, %xmm8
; SSE2-NEXT:    por %xmm7, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm7 = [16,32]
; SSE2-NEXT:    movdqa %xmm9, %xmm11
; SSE2-NEXT:    pand %xmm7, %xmm11
; SSE2-NEXT:    pcmpeqd %xmm7, %xmm11
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm11[1,0,3,2]
; SSE2-NEXT:    pand %xmm11, %xmm7
; SSE2-NEXT:    pand %xmm7, %xmm6
; SSE2-NEXT:    pandn %xmm10, %xmm7
; SSE2-NEXT:    por %xmm6, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE2-NEXT:    movdqa %xmm9, %xmm11
; SSE2-NEXT:    pand %xmm6, %xmm11
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm11
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm11[1,0,3,2]
; SSE2-NEXT:    pand %xmm11, %xmm6
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    pandn %xmm10, %xmm6
; SSE2-NEXT:    por %xmm5, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[1,0,3,2]
; SSE2-NEXT:    pand %xmm9, %xmm5
; SSE2-NEXT:    pand %xmm5, %xmm4
; SSE2-NEXT:    pandn %xmm10, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    mulpd %xmm5, %xmm0
; SSE2-NEXT:    mulpd %xmm6, %xmm1
; SSE2-NEXT:    mulpd %xmm7, %xmm2
; SSE2-NEXT:    mulpd %xmm8, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fmul_v8f64_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movapd %xmm0, %xmm8
; SSE42-NEXT:    movd %edi, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm10 = xmm0[0,1,0,1]
; SSE42-NEXT:    movdqa {{.*#+}} xmm9 = [64,128]
; SSE42-NEXT:    movdqa %xmm10, %xmm0
; SSE42-NEXT:    pand %xmm9, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm9, %xmm0
; SSE42-NEXT:    movapd {{.*#+}} xmm9 = [1.0E+0,1.0E+0]
; SSE42-NEXT:    movapd %xmm9, %xmm11
; SSE42-NEXT:    blendvpd %xmm0, %xmm7, %xmm11
; SSE42-NEXT:    movdqa {{.*#+}} xmm7 = [16,32]
; SSE42-NEXT:    movdqa %xmm10, %xmm0
; SSE42-NEXT:    pand %xmm7, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm7, %xmm0
; SSE42-NEXT:    movapd %xmm9, %xmm7
; SSE42-NEXT:    blendvpd %xmm0, %xmm6, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE42-NEXT:    movdqa %xmm10, %xmm0
; SSE42-NEXT:    pand %xmm6, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm6, %xmm0
; SSE42-NEXT:    movapd %xmm9, %xmm6
; SSE42-NEXT:    blendvpd %xmm0, %xmm5, %xmm6
; SSE42-NEXT:    movdqa {{.*#+}} xmm0 = [1,2]
; SSE42-NEXT:    pand %xmm0, %xmm10
; SSE42-NEXT:    pcmpeqq %xmm0, %xmm10
; SSE42-NEXT:    movdqa %xmm10, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm4, %xmm9
; SSE42-NEXT:    mulpd %xmm8, %xmm9
; SSE42-NEXT:    mulpd %xmm6, %xmm1
; SSE42-NEXT:    mulpd %xmm7, %xmm2
; SSE42-NEXT:    mulpd %xmm11, %xmm3
; SSE42-NEXT:    movapd %xmm9, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fmul_v8f64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvpd %ymm5, %ymm3, %ymm6, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm2, %ymm6, %ymm2
; AVX2-NEXT:    vmulpd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vmulpd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fmul_v8f64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vmulpd %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x double> %y, <8 x double> <double 1.0, double 1.0, double 1.0, double 1.0, double 1.0, double 1.0, double 1.0, double 1.0>
  %r = fmul <8 x double> %x, %s
  ret <8 x double> %r
}

define <8 x float> @fdiv_v8f32_cast_cond(i8 noundef zeroext %pb, <8 x float> noundef %x, <8 x float> noundef %y) {
; SSE2-LABEL: fdiv_v8f32_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [16,32,64,128]
; SSE2-NEXT:    movdqa %xmm4, %xmm6
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE2-NEXT:    pand %xmm6, %xmm3
; SSE2-NEXT:    pandn %xmm5, %xmm6
; SSE2-NEXT:    por %xmm3, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8]
; SSE2-NEXT:    pand %xmm3, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    pandn %xmm5, %xmm4
; SSE2-NEXT:    por %xmm2, %xmm4
; SSE2-NEXT:    divps %xmm4, %xmm0
; SSE2-NEXT:    divps %xmm6, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fdiv_v8f32_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movaps %xmm0, %xmm4
; SSE42-NEXT:    movd %edi, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,0,0,0]
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [16,32,64,128]
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    pand %xmm6, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm6, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; SSE42-NEXT:    movaps %xmm6, %xmm7
; SSE42-NEXT:    blendvps %xmm0, %xmm3, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm0 = [1,2,4,8]
; SSE42-NEXT:    pand %xmm0, %xmm5
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm2, %xmm6
; SSE42-NEXT:    divps %xmm6, %xmm4
; SSE42-NEXT:    divps %xmm7, %xmm1
; SSE42-NEXT:    movaps %xmm4, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fdiv_v8f32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvps %ymm2, %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vdivps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: fdiv_v8f32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vbroadcastss {{.*#+}} ymm2 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX512F-NEXT:    vmovaps %zmm1, %zmm2 {%k1}
; AVX512F-NEXT:    vdivps %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: fdiv_v8f32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vdivps %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x float> %y, <8 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>
  %r = fdiv <8 x float> %x, %s
  ret <8 x float> %r
}

define <8 x double> @fdiv_v8f64_cast_cond(i8 noundef zeroext %pb, <8 x double> noundef %x, <8 x double> noundef %y) {
; SSE2-LABEL: fdiv_v8f64_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [64,128]
; SSE2-NEXT:    movdqa %xmm9, %xmm10
; SSE2-NEXT:    pand %xmm8, %xmm10
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm10[1,0,3,2]
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [1.0E+0,1.0E+0]
; SSE2-NEXT:    pand %xmm8, %xmm7
; SSE2-NEXT:    pandn %xmm10, %xmm8
; SSE2-NEXT:    por %xmm7, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm7 = [16,32]
; SSE2-NEXT:    movdqa %xmm9, %xmm11
; SSE2-NEXT:    pand %xmm7, %xmm11
; SSE2-NEXT:    pcmpeqd %xmm7, %xmm11
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm11[1,0,3,2]
; SSE2-NEXT:    pand %xmm11, %xmm7
; SSE2-NEXT:    pand %xmm7, %xmm6
; SSE2-NEXT:    pandn %xmm10, %xmm7
; SSE2-NEXT:    por %xmm6, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE2-NEXT:    movdqa %xmm9, %xmm11
; SSE2-NEXT:    pand %xmm6, %xmm11
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm11
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm11[1,0,3,2]
; SSE2-NEXT:    pand %xmm11, %xmm6
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    pandn %xmm10, %xmm6
; SSE2-NEXT:    por %xmm5, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[1,0,3,2]
; SSE2-NEXT:    pand %xmm9, %xmm5
; SSE2-NEXT:    pand %xmm5, %xmm4
; SSE2-NEXT:    pandn %xmm10, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    divpd %xmm5, %xmm0
; SSE2-NEXT:    divpd %xmm6, %xmm1
; SSE2-NEXT:    divpd %xmm7, %xmm2
; SSE2-NEXT:    divpd %xmm8, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: fdiv_v8f64_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movapd %xmm0, %xmm8
; SSE42-NEXT:    movd %edi, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm9 = xmm0[0,1,0,1]
; SSE42-NEXT:    movdqa {{.*#+}} xmm10 = [64,128]
; SSE42-NEXT:    movdqa %xmm9, %xmm0
; SSE42-NEXT:    pand %xmm10, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm10, %xmm0
; SSE42-NEXT:    movapd {{.*#+}} xmm11 = [1.0E+0,1.0E+0]
; SSE42-NEXT:    movapd %xmm11, %xmm10
; SSE42-NEXT:    blendvpd %xmm0, %xmm7, %xmm10
; SSE42-NEXT:    movdqa {{.*#+}} xmm7 = [16,32]
; SSE42-NEXT:    movdqa %xmm9, %xmm0
; SSE42-NEXT:    pand %xmm7, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm7, %xmm0
; SSE42-NEXT:    movapd %xmm11, %xmm7
; SSE42-NEXT:    blendvpd %xmm0, %xmm6, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE42-NEXT:    movdqa %xmm9, %xmm0
; SSE42-NEXT:    pand %xmm6, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm6, %xmm0
; SSE42-NEXT:    movapd %xmm11, %xmm6
; SSE42-NEXT:    blendvpd %xmm0, %xmm5, %xmm6
; SSE42-NEXT:    movdqa {{.*#+}} xmm0 = [1,2]
; SSE42-NEXT:    pand %xmm0, %xmm9
; SSE42-NEXT:    pcmpeqq %xmm0, %xmm9
; SSE42-NEXT:    movdqa %xmm9, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm4, %xmm11
; SSE42-NEXT:    divpd %xmm11, %xmm8
; SSE42-NEXT:    divpd %xmm6, %xmm1
; SSE42-NEXT:    divpd %xmm7, %xmm2
; SSE42-NEXT:    divpd %xmm10, %xmm3
; SSE42-NEXT:    movapd %xmm8, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: fdiv_v8f64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [1.0E+0,1.0E+0,1.0E+0,1.0E+0]
; AVX2-NEXT:    vblendvpd %ymm5, %ymm3, %ymm6, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm2, %ymm6, %ymm2
; AVX2-NEXT:    vdivpd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vdivpd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: fdiv_v8f64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vdivpd %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x double> %y, <8 x double> <double 1.0, double 1.0, double 1.0, double 1.0, double 1.0, double 1.0, double 1.0, double 1.0>
  %r = fdiv <8 x double> %x, %s
  ret <8 x double> %r
}

define <4 x i32> @add_v4i32(<4 x i1> %b, <4 x i32> noundef %x, <4 x i32> noundef %y) {
; SSE-LABEL: add_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $31, %xmm0
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    paddd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX2-LABEL: add_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: add_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: add_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpaddd %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x i32> %y, <4 x i32> zeroinitializer
  %r = add <4 x i32> %x, %s
  ret <4 x i32> %r
}

define <8 x i32> @add_v8i32_commute(<8 x i1> %b, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; SSE2-LABEL: add_v8i32_commute:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm5
; SSE2-NEXT:    psrad $31, %xmm5
; SSE2-NEXT:    pand %xmm4, %xmm5
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    paddd %xmm1, %xmm0
; SSE2-NEXT:    paddd %xmm2, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: add_v8i32_commute:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE42-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    psrad $31, %xmm5
; SSE42-NEXT:    pand %xmm4, %xmm5
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    psrad $31, %xmm0
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    paddd %xmm1, %xmm0
; SSE42-NEXT:    paddd %xmm2, %xmm5
; SSE42-NEXT:    movdqa %xmm5, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: add_v8i32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: add_v8i32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: add_v8i32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vpaddd %ymm2, %ymm1, %ymm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = add <8 x i32> %s, %x
  ret <8 x i32> %r
}

define <8 x i32> @add_v8i32_cast_cond(i8 noundef zeroext %pb, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; SSE-LABEL: add_v8i32_cast_cond:
; SSE:       # %bb.0:
; SSE-NEXT:    movd %edi, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [16,32,64,128]
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pand %xmm5, %xmm6
; SSE-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8]
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    paddd %xmm4, %xmm0
; SSE-NEXT:    paddd %xmm6, %xmm1
; SSE-NEXT:    retq
;
; AVX2-LABEL: add_v8i32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: add_v8i32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: add_v8i32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpaddd %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = add <8 x i32> %x, %s
  ret <8 x i32> %r
}

define <8 x i64> @add_v8i64_cast_cond(i8 noundef zeroext %pb, <8 x i64> noundef %x, <8 x i64> noundef %y) {
; SSE2-LABEL: add_v8i64_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [64,128]
; SSE2-NEXT:    movdqa %xmm9, %xmm8
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm8[1,0,3,2]
; SSE2-NEXT:    pand %xmm7, %xmm8
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [16,32]
; SSE2-NEXT:    movdqa %xmm9, %xmm7
; SSE2-NEXT:    pand %xmm10, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm7[1,0,3,2]
; SSE2-NEXT:    pand %xmm6, %xmm7
; SSE2-NEXT:    pand %xmm10, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE2-NEXT:    movdqa %xmm9, %xmm10
; SSE2-NEXT:    pand %xmm6, %xmm10
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm10[1,0,3,2]
; SSE2-NEXT:    pand %xmm5, %xmm10
; SSE2-NEXT:    pand %xmm6, %xmm10
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[1,0,3,2]
; SSE2-NEXT:    pand %xmm4, %xmm9
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    paddq %xmm9, %xmm0
; SSE2-NEXT:    paddq %xmm10, %xmm1
; SSE2-NEXT:    paddq %xmm7, %xmm2
; SSE2-NEXT:    paddq %xmm8, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: add_v8i64_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movd %edi, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE42-NEXT:    movdqa {{.*#+}} xmm10 = [64,128]
; SSE42-NEXT:    movdqa %xmm9, %xmm8
; SSE42-NEXT:    pand %xmm10, %xmm8
; SSE42-NEXT:    pcmpeqq %xmm10, %xmm8
; SSE42-NEXT:    pand %xmm7, %xmm8
; SSE42-NEXT:    movdqa {{.*#+}} xmm7 = [16,32]
; SSE42-NEXT:    movdqa %xmm9, %xmm10
; SSE42-NEXT:    pand %xmm7, %xmm10
; SSE42-NEXT:    pcmpeqq %xmm7, %xmm10
; SSE42-NEXT:    pand %xmm6, %xmm10
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE42-NEXT:    movdqa %xmm9, %xmm7
; SSE42-NEXT:    pand %xmm6, %xmm7
; SSE42-NEXT:    pcmpeqq %xmm6, %xmm7
; SSE42-NEXT:    pand %xmm5, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE42-NEXT:    pand %xmm5, %xmm9
; SSE42-NEXT:    pcmpeqq %xmm5, %xmm9
; SSE42-NEXT:    pand %xmm4, %xmm9
; SSE42-NEXT:    paddq %xmm9, %xmm0
; SSE42-NEXT:    paddq %xmm7, %xmm1
; SSE42-NEXT:    paddq %xmm10, %xmm2
; SSE42-NEXT:    paddq %xmm8, %xmm3
; SSE42-NEXT:    retq
;
; AVX2-LABEL: add_v8i64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpand %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: add_v8i64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vpaddq %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i64> %y, <8 x i64> zeroinitializer
  %r = add <8 x i64> %x, %s
  ret <8 x i64> %r
}

define <4 x i32> @sub_v4i32(<4 x i1> %b, <4 x i32> noundef %x, <4 x i32> noundef %y) {
; SSE-LABEL: sub_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pslld $31, %xmm0
; SSE-NEXT:    psrad $31, %xmm0
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    psubd %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX2-LABEL: sub_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpsubd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sub_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsubd %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sub_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpsubd %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x i32> %y, <4 x i32> zeroinitializer
  %r = sub <4 x i32> %x, %s
  ret <4 x i32> %r
}

; negative test - sub is not commutative; there is no identity constant for operand 0

define <8 x i32> @sub_v8i32_commute(<8 x i1> %b, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; SSE2-LABEL: sub_v8i32_commute:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm5
; SSE2-NEXT:    psrad $31, %xmm5
; SSE2-NEXT:    pand %xmm4, %xmm5
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    psubd %xmm1, %xmm0
; SSE2-NEXT:    psubd %xmm2, %xmm5
; SSE2-NEXT:    movdqa %xmm5, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: sub_v8i32_commute:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE42-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    psrad $31, %xmm5
; SSE42-NEXT:    pand %xmm4, %xmm5
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    psrad $31, %xmm0
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    psubd %xmm1, %xmm0
; SSE42-NEXT:    psubd %xmm2, %xmm5
; SSE42-NEXT:    movdqa %xmm5, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: sub_v8i32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sub_v8i32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sub_v8i32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vmovdqa32 %ymm2, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = sub <8 x i32> %s, %x
  ret <8 x i32> %r
}

define <16 x i32> @sub_v16i32_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; SSE2-LABEL: sub_v16i32_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm9
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm9, %xmm8
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm8
; SSE2-NEXT:    psrad $31, %xmm8
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm8
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    pandn %xmm7, %xmm9
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm7
; SSE2-NEXT:    psrad $31, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pandn %xmm5, %xmm0
; SSE2-NEXT:    psubd %xmm0, %xmm1
; SSE2-NEXT:    psubd %xmm7, %xmm2
; SSE2-NEXT:    psubd %xmm9, %xmm3
; SSE2-NEXT:    psubd %xmm8, %xmm4
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    movdqa %xmm4, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: sub_v16i32_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm8 = xmm8[0],zero,zero,zero,xmm8[1],zero,zero,zero,xmm8[2],zero,zero,zero,xmm8[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm8
; SSE42-NEXT:    psrad $31, %xmm8
; SSE42-NEXT:    pandn %xmm7, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,xmm7[1],zero,zero,zero,xmm7[2],zero,zero,zero,xmm7[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm7
; SSE42-NEXT:    psrad $31, %xmm7
; SSE42-NEXT:    pandn %xmm6, %xmm7
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm6 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm6
; SSE42-NEXT:    psrad $31, %xmm6
; SSE42-NEXT:    pandn %xmm5, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    psrad $31, %xmm0
; SSE42-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm0
; SSE42-NEXT:    psubd %xmm6, %xmm1
; SSE42-NEXT:    psubd %xmm7, %xmm2
; SSE42-NEXT:    psubd %xmm8, %xmm3
; SSE42-NEXT:    psubd %xmm0, %xmm4
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    movdqa %xmm2, %xmm1
; SSE42-NEXT:    movdqa %xmm3, %xmm2
; SSE42-NEXT:    movdqa %xmm4, %xmm3
; SSE42-NEXT:    retq
;
; AVX2-LABEL: sub_v16i32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsubd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsubd %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sub_v16i32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vpsubd %zmm2, %zmm1, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = sub <16 x i32> %x, %s
  ret <16 x i32> %r
}

; negative test - sub is not commutative; there is no identity constant for operand 0

define <16 x i32> @sub_v16i32_commute_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; SSE2-LABEL: sub_v16i32_commute_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm2, %xmm8
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm2, %xmm9
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm9 = xmm9[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm9
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    pandn %xmm7, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm7
; SSE2-NEXT:    psrad $31, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pandn %xmm5, %xmm0
; SSE2-NEXT:    psubd %xmm1, %xmm0
; SSE2-NEXT:    psubd %xmm8, %xmm7
; SSE2-NEXT:    psubd %xmm3, %xmm2
; SSE2-NEXT:    psubd %xmm4, %xmm9
; SSE2-NEXT:    movdqa %xmm7, %xmm1
; SSE2-NEXT:    movdqa %xmm9, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: sub_v16i32_commute_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm2, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm2 = xmm2[0],zero,zero,zero,xmm2[1],zero,zero,zero,xmm2[2],zero,zero,zero,xmm2[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm2
; SSE42-NEXT:    psrad $31, %xmm2
; SSE42-NEXT:    pandn %xmm7, %xmm2
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,xmm7[1],zero,zero,zero,xmm7[2],zero,zero,zero,xmm7[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm7
; SSE42-NEXT:    psrad $31, %xmm7
; SSE42-NEXT:    pandn %xmm6, %xmm7
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm6 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm6
; SSE42-NEXT:    psrad $31, %xmm6
; SSE42-NEXT:    pandn %xmm5, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    psrad $31, %xmm5
; SSE42-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm5
; SSE42-NEXT:    psubd %xmm1, %xmm6
; SSE42-NEXT:    psubd %xmm8, %xmm7
; SSE42-NEXT:    psubd %xmm3, %xmm2
; SSE42-NEXT:    psubd %xmm4, %xmm5
; SSE42-NEXT:    movdqa %xmm6, %xmm0
; SSE42-NEXT:    movdqa %xmm7, %xmm1
; SSE42-NEXT:    movdqa %xmm5, %xmm3
; SSE42-NEXT:    retq
;
; AVX2-LABEL: sub_v16i32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsubd %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sub_v16i32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512-NEXT:    vpsubd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = sub <16 x i32> %s, %x
  ret <16 x i32> %r
}

define <8 x i32> @sub_v8i32_cast_cond(i8 noundef zeroext %pb, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; SSE-LABEL: sub_v8i32_cast_cond:
; SSE:       # %bb.0:
; SSE-NEXT:    movd %edi, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [16,32,64,128]
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pand %xmm5, %xmm6
; SSE-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8]
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    psubd %xmm4, %xmm0
; SSE-NEXT:    psubd %xmm6, %xmm1
; SSE-NEXT:    retq
;
; AVX2-LABEL: sub_v8i32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: sub_v8i32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: sub_v8i32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpsubd %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = sub <8 x i32> %x, %s
  ret <8 x i32> %r
}

define <8 x i64> @sub_v8i64_cast_cond(i8 noundef zeroext %pb, <8 x i64> noundef %x, <8 x i64> noundef %y) {
; SSE2-LABEL: sub_v8i64_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [64,128]
; SSE2-NEXT:    movdqa %xmm9, %xmm8
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm8[1,0,3,2]
; SSE2-NEXT:    pand %xmm7, %xmm8
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [16,32]
; SSE2-NEXT:    movdqa %xmm9, %xmm7
; SSE2-NEXT:    pand %xmm10, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm7[1,0,3,2]
; SSE2-NEXT:    pand %xmm6, %xmm7
; SSE2-NEXT:    pand %xmm10, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE2-NEXT:    movdqa %xmm9, %xmm10
; SSE2-NEXT:    pand %xmm6, %xmm10
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm10[1,0,3,2]
; SSE2-NEXT:    pand %xmm5, %xmm10
; SSE2-NEXT:    pand %xmm6, %xmm10
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[1,0,3,2]
; SSE2-NEXT:    pand %xmm4, %xmm9
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    psubq %xmm9, %xmm0
; SSE2-NEXT:    psubq %xmm10, %xmm1
; SSE2-NEXT:    psubq %xmm7, %xmm2
; SSE2-NEXT:    psubq %xmm8, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: sub_v8i64_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movd %edi, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE42-NEXT:    movdqa {{.*#+}} xmm10 = [64,128]
; SSE42-NEXT:    movdqa %xmm9, %xmm8
; SSE42-NEXT:    pand %xmm10, %xmm8
; SSE42-NEXT:    pcmpeqq %xmm10, %xmm8
; SSE42-NEXT:    pand %xmm7, %xmm8
; SSE42-NEXT:    movdqa {{.*#+}} xmm7 = [16,32]
; SSE42-NEXT:    movdqa %xmm9, %xmm10
; SSE42-NEXT:    pand %xmm7, %xmm10
; SSE42-NEXT:    pcmpeqq %xmm7, %xmm10
; SSE42-NEXT:    pand %xmm6, %xmm10
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE42-NEXT:    movdqa %xmm9, %xmm7
; SSE42-NEXT:    pand %xmm6, %xmm7
; SSE42-NEXT:    pcmpeqq %xmm6, %xmm7
; SSE42-NEXT:    pand %xmm5, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE42-NEXT:    pand %xmm5, %xmm9
; SSE42-NEXT:    pcmpeqq %xmm5, %xmm9
; SSE42-NEXT:    pand %xmm4, %xmm9
; SSE42-NEXT:    psubq %xmm9, %xmm0
; SSE42-NEXT:    psubq %xmm7, %xmm1
; SSE42-NEXT:    psubq %xmm10, %xmm2
; SSE42-NEXT:    psubq %xmm8, %xmm3
; SSE42-NEXT:    retq
;
; AVX2-LABEL: sub_v8i64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpand %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpsubq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: sub_v8i64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i64> %y, <8 x i64> zeroinitializer
  %r = sub <8 x i64> %x, %s
  ret <8 x i64> %r
}

define <4 x i32> @mul_v4i32(<4 x i1> %b, <4 x i32> noundef %x, <4 x i32> noundef %y) {
; SSE2-LABEL: mul_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm2
; SSE2-NEXT:    paddd %xmm0, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE2-NEXT:    psubd %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm2, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: mul_v4i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm3 = [1,1,1,1]
; SSE42-NEXT:    blendvps %xmm0, %xmm2, %xmm3
; SSE42-NEXT:    pmulld %xmm1, %xmm3
; SSE42-NEXT:    movdqa %xmm3, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: mul_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} xmm3 = [1,1,1,1]
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm3, %xmm0
; AVX2-NEXT:    vpmulld %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: mul_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} xmm0 = [1,1,1,1]
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vpmulld %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: mul_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpmulld %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x i32> %y, <4 x i32> <i32 1, i32 1, i32 1, i32 1>
  %r = mul <4 x i32> %x, %s
  ret <4 x i32> %r
}

define <8 x i32> @mul_v8i32_commute(<8 x i1> %b, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; SSE2-LABEL: mul_v8i32_commute:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm5
; SSE2-NEXT:    psrad $31, %xmm5
; SSE2-NEXT:    pand %xmm5, %xmm4
; SSE2-NEXT:    paddd %xmm5, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm5
; SSE2-NEXT:    psubd %xmm5, %xmm4
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm0, %xmm3
; SSE2-NEXT:    paddd %xmm0, %xmm3
; SSE2-NEXT:    psubd %xmm5, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm1, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm5, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm4[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: mul_v8i32_commute:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm6 = [1,1,1,1]
; SSE42-NEXT:    movaps %xmm6, %xmm7
; SSE42-NEXT:    blendvps %xmm0, %xmm3, %xmm7
; SSE42-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm4, %xmm6
; SSE42-NEXT:    pmulld %xmm1, %xmm7
; SSE42-NEXT:    pmulld %xmm2, %xmm6
; SSE42-NEXT:    movdqa %xmm7, %xmm0
; SSE42-NEXT:    movdqa %xmm6, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: mul_v8i32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1]
; AVX2-NEXT:    vblendvps %ymm0, %ymm2, %ymm3, %ymm0
; AVX2-NEXT:    vpmulld %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: mul_v8i32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} ymm0 = [1,1,1,1,1,1,1,1]
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1}
; AVX512F-NEXT:    vpmulld %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: mul_v8i32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vpmulld %ymm2, %ymm1, %ymm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %ymm1, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %r = mul <8 x i32> %s, %x
  ret <8 x i32> %r
}

define <8 x i32> @mul_v8i32_cast_cond(i8 noundef zeroext %pb, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; SSE2-LABEL: mul_v8i32_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [16,32,64,128]
; SSE2-NEXT:    movdqa %xmm4, %xmm6
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE2-NEXT:    pand %xmm6, %xmm3
; SSE2-NEXT:    paddd %xmm6, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm5
; SSE2-NEXT:    psubd %xmm5, %xmm3
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [1,2,4,8]
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-NEXT:    pand %xmm4, %xmm2
; SSE2-NEXT:    paddd %xmm4, %xmm2
; SSE2-NEXT:    psubd %xmm5, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm2, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm4, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm2, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: mul_v8i32_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm4
; SSE42-NEXT:    movd %edi, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,0,0,0]
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [16,32,64,128]
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    pand %xmm6, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm6, %xmm0
; SSE42-NEXT:    movaps {{.*#+}} xmm6 = [1,1,1,1]
; SSE42-NEXT:    movaps %xmm6, %xmm7
; SSE42-NEXT:    blendvps %xmm0, %xmm3, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm0 = [1,2,4,8]
; SSE42-NEXT:    pand %xmm0, %xmm5
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm5
; SSE42-NEXT:    movdqa %xmm5, %xmm0
; SSE42-NEXT:    blendvps %xmm0, %xmm2, %xmm6
; SSE42-NEXT:    pmulld %xmm4, %xmm6
; SSE42-NEXT:    pmulld %xmm7, %xmm1
; SSE42-NEXT:    movdqa %xmm6, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: mul_v8i32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vbroadcastss {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1]
; AVX2-NEXT:    vblendvps %ymm2, %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vpmulld %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: mul_v8i32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} ymm2 = [1,1,1,1,1,1,1,1]
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm2 {%k1}
; AVX512F-NEXT:    vpmulld %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: mul_v8i32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpmulld %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %r = mul <8 x i32> %x, %s
  ret <8 x i32> %r
}

define <8 x i64> @mul_v8i64_cast_cond(i8 noundef zeroext %pb, <8 x i64> noundef %x, <8 x i64> noundef %y) {
; SSE2-LABEL: mul_v8i64_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm8 = [64,128]
; SSE2-NEXT:    movdqa %xmm9, %xmm10
; SSE2-NEXT:    pand %xmm8, %xmm10
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm10[1,0,3,2]
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [1,1]
; SSE2-NEXT:    pand %xmm8, %xmm7
; SSE2-NEXT:    pandn %xmm10, %xmm8
; SSE2-NEXT:    por %xmm7, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm7 = [16,32]
; SSE2-NEXT:    movdqa %xmm9, %xmm11
; SSE2-NEXT:    pand %xmm7, %xmm11
; SSE2-NEXT:    pcmpeqd %xmm7, %xmm11
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm11[1,0,3,2]
; SSE2-NEXT:    pand %xmm11, %xmm7
; SSE2-NEXT:    pand %xmm7, %xmm6
; SSE2-NEXT:    pandn %xmm10, %xmm7
; SSE2-NEXT:    por %xmm6, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE2-NEXT:    movdqa %xmm9, %xmm11
; SSE2-NEXT:    pand %xmm6, %xmm11
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm11
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm11[1,0,3,2]
; SSE2-NEXT:    pand %xmm11, %xmm6
; SSE2-NEXT:    pand %xmm6, %xmm5
; SSE2-NEXT:    pandn %xmm10, %xmm6
; SSE2-NEXT:    por %xmm5, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[1,0,3,2]
; SSE2-NEXT:    pand %xmm9, %xmm5
; SSE2-NEXT:    pand %xmm5, %xmm4
; SSE2-NEXT:    pandn %xmm10, %xmm5
; SSE2-NEXT:    por %xmm4, %xmm5
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    psrlq $32, %xmm4
; SSE2-NEXT:    pmuludq %xmm5, %xmm4
; SSE2-NEXT:    movdqa %xmm5, %xmm9
; SSE2-NEXT:    psrlq $32, %xmm9
; SSE2-NEXT:    pmuludq %xmm0, %xmm9
; SSE2-NEXT:    paddq %xmm4, %xmm9
; SSE2-NEXT:    psllq $32, %xmm9
; SSE2-NEXT:    pmuludq %xmm5, %xmm0
; SSE2-NEXT:    paddq %xmm9, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    psrlq $32, %xmm4
; SSE2-NEXT:    pmuludq %xmm6, %xmm4
; SSE2-NEXT:    movdqa %xmm6, %xmm5
; SSE2-NEXT:    psrlq $32, %xmm5
; SSE2-NEXT:    pmuludq %xmm1, %xmm5
; SSE2-NEXT:    paddq %xmm4, %xmm5
; SSE2-NEXT:    psllq $32, %xmm5
; SSE2-NEXT:    pmuludq %xmm6, %xmm1
; SSE2-NEXT:    paddq %xmm5, %xmm1
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    psrlq $32, %xmm4
; SSE2-NEXT:    pmuludq %xmm7, %xmm4
; SSE2-NEXT:    movdqa %xmm7, %xmm5
; SSE2-NEXT:    psrlq $32, %xmm5
; SSE2-NEXT:    pmuludq %xmm2, %xmm5
; SSE2-NEXT:    paddq %xmm4, %xmm5
; SSE2-NEXT:    psllq $32, %xmm5
; SSE2-NEXT:    pmuludq %xmm7, %xmm2
; SSE2-NEXT:    paddq %xmm5, %xmm2
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    psrlq $32, %xmm4
; SSE2-NEXT:    pmuludq %xmm8, %xmm4
; SSE2-NEXT:    movdqa %xmm8, %xmm5
; SSE2-NEXT:    psrlq $32, %xmm5
; SSE2-NEXT:    pmuludq %xmm3, %xmm5
; SSE2-NEXT:    paddq %xmm4, %xmm5
; SSE2-NEXT:    psllq $32, %xmm5
; SSE2-NEXT:    pmuludq %xmm8, %xmm3
; SSE2-NEXT:    paddq %xmm5, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: mul_v8i64_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm8
; SSE42-NEXT:    movd %edi, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm10 = xmm0[0,1,0,1]
; SSE42-NEXT:    movdqa {{.*#+}} xmm9 = [64,128]
; SSE42-NEXT:    movdqa %xmm10, %xmm0
; SSE42-NEXT:    pand %xmm9, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm9, %xmm0
; SSE42-NEXT:    movapd {{.*#+}} xmm9 = [1,1]
; SSE42-NEXT:    movapd %xmm9, %xmm11
; SSE42-NEXT:    blendvpd %xmm0, %xmm7, %xmm11
; SSE42-NEXT:    movdqa {{.*#+}} xmm7 = [16,32]
; SSE42-NEXT:    movdqa %xmm10, %xmm0
; SSE42-NEXT:    pand %xmm7, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm7, %xmm0
; SSE42-NEXT:    movapd %xmm9, %xmm7
; SSE42-NEXT:    blendvpd %xmm0, %xmm6, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE42-NEXT:    movdqa %xmm10, %xmm0
; SSE42-NEXT:    pand %xmm6, %xmm0
; SSE42-NEXT:    pcmpeqq %xmm6, %xmm0
; SSE42-NEXT:    movapd %xmm9, %xmm6
; SSE42-NEXT:    blendvpd %xmm0, %xmm5, %xmm6
; SSE42-NEXT:    movdqa {{.*#+}} xmm0 = [1,2]
; SSE42-NEXT:    pand %xmm0, %xmm10
; SSE42-NEXT:    pcmpeqq %xmm0, %xmm10
; SSE42-NEXT:    movdqa %xmm10, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm4, %xmm9
; SSE42-NEXT:    movdqa %xmm8, %xmm0
; SSE42-NEXT:    psrlq $32, %xmm0
; SSE42-NEXT:    pmuludq %xmm9, %xmm0
; SSE42-NEXT:    movdqa %xmm9, %xmm4
; SSE42-NEXT:    psrlq $32, %xmm4
; SSE42-NEXT:    pmuludq %xmm8, %xmm4
; SSE42-NEXT:    paddq %xmm0, %xmm4
; SSE42-NEXT:    psllq $32, %xmm4
; SSE42-NEXT:    pmuludq %xmm8, %xmm9
; SSE42-NEXT:    paddq %xmm4, %xmm9
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    psrlq $32, %xmm0
; SSE42-NEXT:    pmuludq %xmm6, %xmm0
; SSE42-NEXT:    movdqa %xmm6, %xmm4
; SSE42-NEXT:    psrlq $32, %xmm4
; SSE42-NEXT:    pmuludq %xmm1, %xmm4
; SSE42-NEXT:    paddq %xmm0, %xmm4
; SSE42-NEXT:    psllq $32, %xmm4
; SSE42-NEXT:    pmuludq %xmm6, %xmm1
; SSE42-NEXT:    paddq %xmm4, %xmm1
; SSE42-NEXT:    movdqa %xmm2, %xmm0
; SSE42-NEXT:    psrlq $32, %xmm0
; SSE42-NEXT:    pmuludq %xmm7, %xmm0
; SSE42-NEXT:    movdqa %xmm7, %xmm4
; SSE42-NEXT:    psrlq $32, %xmm4
; SSE42-NEXT:    pmuludq %xmm2, %xmm4
; SSE42-NEXT:    paddq %xmm0, %xmm4
; SSE42-NEXT:    psllq $32, %xmm4
; SSE42-NEXT:    pmuludq %xmm7, %xmm2
; SSE42-NEXT:    paddq %xmm4, %xmm2
; SSE42-NEXT:    movdqa %xmm3, %xmm0
; SSE42-NEXT:    psrlq $32, %xmm0
; SSE42-NEXT:    pmuludq %xmm11, %xmm0
; SSE42-NEXT:    movdqa %xmm11, %xmm4
; SSE42-NEXT:    psrlq $32, %xmm4
; SSE42-NEXT:    pmuludq %xmm3, %xmm4
; SSE42-NEXT:    paddq %xmm0, %xmm4
; SSE42-NEXT:    psllq $32, %xmm4
; SSE42-NEXT:    pmuludq %xmm11, %xmm3
; SSE42-NEXT:    paddq %xmm4, %xmm3
; SSE42-NEXT:    movdqa %xmm9, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: mul_v8i64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [1,1,1,1]
; AVX2-NEXT:    vblendvpd %ymm5, %ymm3, %ymm6, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm2, %ymm6, %ymm2
; AVX2-NEXT:    vpsrlq $32, %ymm0, %ymm4
; AVX2-NEXT:    vpmuludq %ymm2, %ymm4, %ymm4
; AVX2-NEXT:    vpsrlq $32, %ymm2, %ymm5
; AVX2-NEXT:    vpmuludq %ymm5, %ymm0, %ymm5
; AVX2-NEXT:    vpaddq %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpsllq $32, %ymm4, %ymm4
; AVX2-NEXT:    vpmuludq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddq %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlq $32, %ymm1, %ymm2
; AVX2-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX2-NEXT:    vpmuludq %ymm4, %ymm1, %ymm4
; AVX2-NEXT:    vpaddq %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX2-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: mul_v8i64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vpsrlq $32, %zmm1, %zmm2
; AVX512-NEXT:    vpmuludq %zmm2, %zmm0, %zmm2
; AVX512-NEXT:    vpsrlq $32, %zmm0, %zmm3
; AVX512-NEXT:    vpmuludq %zmm1, %zmm3, %zmm3
; AVX512-NEXT:    vpaddq %zmm3, %zmm2, %zmm2
; AVX512-NEXT:    vpsllq $32, %zmm2, %zmm2
; AVX512-NEXT:    vpmuludq %zmm1, %zmm0, %zmm1
; AVX512-NEXT:    vpaddq %zmm2, %zmm1, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i64> %y, <8 x i64> <i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1>
  %r = mul <8 x i64> %x, %s
  ret <8 x i64> %r
}

define <4 x i32> @shl_v4i32(<4 x i1> %b, <4 x i32> noundef %x, <4 x i32> noundef %y) {
; SSE2-LABEL: shl_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pslld $23, %xmm0
; SSE2-NEXT:    paddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    cvttps2dq %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm2, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: shl_v4i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    psrad $31, %xmm0
; SSE42-NEXT:    pand %xmm2, %xmm0
; SSE42-NEXT:    pslld $23, %xmm0
; SSE42-NEXT:    paddd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE42-NEXT:    cvttps2dq %xmm0, %xmm0
; SSE42-NEXT:    pmulld %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: shl_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpsllvd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: shl_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsllvd %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shl_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpsllvd %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x i32> %y, <4 x i32> zeroinitializer
  %r = shl <4 x i32> %x, %s
  ret <4 x i32> %r
}

; negative test - shl is not commutative; there is no identity constant for operand 0

define <8 x i32> @shl_v8i32_commute(<8 x i1> %b, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; SSE2-LABEL: shl_v8i32_commute:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm5
; SSE2-NEXT:    psrad $31, %xmm5
; SSE2-NEXT:    pand %xmm4, %xmm5
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pslld $23, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [1065353216,1065353216,1065353216,1065353216]
; SSE2-NEXT:    paddd %xmm3, %xmm1
; SSE2-NEXT:    cvttps2dq %xmm1, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm4, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    pslld $23, %xmm2
; SSE2-NEXT:    paddd %xmm3, %xmm2
; SSE2-NEXT:    cvttps2dq %xmm2, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm2, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: shl_v8i32_commute:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pmovzxwd {{.*#+}} xmm5 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE42-NEXT:    punpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    psrad $31, %xmm0
; SSE42-NEXT:    pand %xmm4, %xmm0
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    psrad $31, %xmm5
; SSE42-NEXT:    pand %xmm3, %xmm5
; SSE42-NEXT:    pslld $23, %xmm1
; SSE42-NEXT:    movdqa {{.*#+}} xmm4 = [1065353216,1065353216,1065353216,1065353216]
; SSE42-NEXT:    paddd %xmm4, %xmm1
; SSE42-NEXT:    cvttps2dq %xmm1, %xmm3
; SSE42-NEXT:    pmulld %xmm5, %xmm3
; SSE42-NEXT:    pslld $23, %xmm2
; SSE42-NEXT:    paddd %xmm4, %xmm2
; SSE42-NEXT:    cvttps2dq %xmm2, %xmm1
; SSE42-NEXT:    pmulld %xmm0, %xmm1
; SSE42-NEXT:    movdqa %xmm3, %xmm0
; SSE42-NEXT:    retq
;
; AVX2-LABEL: shl_v8i32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: shl_v8i32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shl_v8i32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vmovdqa32 %ymm2, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = shl <8 x i32> %s, %x
  ret <8 x i32> %r
}

define <16 x i32> @shl_v16i32_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; SSE2-LABEL: shl_v16i32_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm9
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm9, %xmm8
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm8
; SSE2-NEXT:    psrad $31, %xmm8
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm8
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    pandn %xmm7, %xmm9
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm7
; SSE2-NEXT:    psrad $31, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pandn %xmm5, %xmm0
; SSE2-NEXT:    pslld $23, %xmm0
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1065353216,1065353216,1065353216,1065353216]
; SSE2-NEXT:    paddd %xmm5, %xmm0
; SSE2-NEXT:    cvttps2dq %xmm0, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm6, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm6[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm10, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    pslld $23, %xmm7
; SSE2-NEXT:    paddd %xmm5, %xmm7
; SSE2-NEXT:    cvttps2dq %xmm7, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm2[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm6, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm7, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE2-NEXT:    pslld $23, %xmm9
; SSE2-NEXT:    paddd %xmm5, %xmm9
; SSE2-NEXT:    cvttps2dq %xmm9, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm3[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm6, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm7, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; SSE2-NEXT:    pslld $23, %xmm8
; SSE2-NEXT:    paddd %xmm5, %xmm8
; SSE2-NEXT:    cvttps2dq %xmm8, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm4[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm4[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm6, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: shl_v16i32_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm8 = xmm8[0],zero,zero,zero,xmm8[1],zero,zero,zero,xmm8[2],zero,zero,zero,xmm8[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm8
; SSE42-NEXT:    psrad $31, %xmm8
; SSE42-NEXT:    pandn %xmm7, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,xmm7[1],zero,zero,zero,xmm7[2],zero,zero,zero,xmm7[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm7
; SSE42-NEXT:    psrad $31, %xmm7
; SSE42-NEXT:    pandn %xmm6, %xmm7
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm6 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm6
; SSE42-NEXT:    psrad $31, %xmm6
; SSE42-NEXT:    pandn %xmm5, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    psrad $31, %xmm5
; SSE42-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm5
; SSE42-NEXT:    pslld $23, %xmm6
; SSE42-NEXT:    movdqa {{.*#+}} xmm9 = [1065353216,1065353216,1065353216,1065353216]
; SSE42-NEXT:    paddd %xmm9, %xmm6
; SSE42-NEXT:    cvttps2dq %xmm6, %xmm0
; SSE42-NEXT:    pmulld %xmm1, %xmm0
; SSE42-NEXT:    pslld $23, %xmm7
; SSE42-NEXT:    paddd %xmm9, %xmm7
; SSE42-NEXT:    cvttps2dq %xmm7, %xmm1
; SSE42-NEXT:    pmulld %xmm2, %xmm1
; SSE42-NEXT:    pslld $23, %xmm8
; SSE42-NEXT:    paddd %xmm9, %xmm8
; SSE42-NEXT:    cvttps2dq %xmm8, %xmm2
; SSE42-NEXT:    pmulld %xmm3, %xmm2
; SSE42-NEXT:    pslld $23, %xmm5
; SSE42-NEXT:    paddd %xmm9, %xmm5
; SSE42-NEXT:    cvttps2dq %xmm5, %xmm3
; SSE42-NEXT:    pmulld %xmm4, %xmm3
; SSE42-NEXT:    retq
;
; AVX2-LABEL: shl_v16i32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsllvd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsllvd %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: shl_v16i32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vpsllvd %zmm2, %zmm1, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = shl <16 x i32> %x, %s
  ret <16 x i32> %r
}

; negative test - shl is not commutative; there is no identity constant for operand 0

define <16 x i32> @shl_v16i32_commute_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; SSE2-LABEL: shl_v16i32_commute_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm9
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm9, %xmm8
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm8 = xmm8[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm8
; SSE2-NEXT:    psrad $31, %xmm8
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm8
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm9 = xmm9[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    pandn %xmm7, %xmm9
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm7
; SSE2-NEXT:    psrad $31, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pandn %xmm5, %xmm0
; SSE2-NEXT:    pslld $23, %xmm1
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1065353216,1065353216,1065353216,1065353216]
; SSE2-NEXT:    paddd %xmm5, %xmm1
; SSE2-NEXT:    cvttps2dq %xmm1, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm6, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1]
; SSE2-NEXT:    pslld $23, %xmm2
; SSE2-NEXT:    paddd %xmm5, %xmm2
; SSE2-NEXT:    cvttps2dq %xmm2, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm2, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm6, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE2-NEXT:    pslld $23, %xmm3
; SSE2-NEXT:    paddd %xmm5, %xmm3
; SSE2-NEXT:    cvttps2dq %xmm3, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm9[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm9[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm6, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; SSE2-NEXT:    pslld $23, %xmm4
; SSE2-NEXT:    paddd %xmm5, %xmm4
; SSE2-NEXT:    cvttps2dq %xmm4, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm4, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm8[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm3 = xmm3[0],xmm4[0],xmm3[1],xmm4[1]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: shl_v16i32_commute_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm8 = xmm8[0],zero,zero,zero,xmm8[1],zero,zero,zero,xmm8[2],zero,zero,zero,xmm8[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm8
; SSE42-NEXT:    psrad $31, %xmm8
; SSE42-NEXT:    pandn %xmm7, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,xmm7[1],zero,zero,zero,xmm7[2],zero,zero,zero,xmm7[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm7
; SSE42-NEXT:    psrad $31, %xmm7
; SSE42-NEXT:    pandn %xmm6, %xmm7
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm6 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm6
; SSE42-NEXT:    psrad $31, %xmm6
; SSE42-NEXT:    pandn %xmm5, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    psrad $31, %xmm5
; SSE42-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm5
; SSE42-NEXT:    pslld $23, %xmm1
; SSE42-NEXT:    movdqa {{.*#+}} xmm9 = [1065353216,1065353216,1065353216,1065353216]
; SSE42-NEXT:    paddd %xmm9, %xmm1
; SSE42-NEXT:    cvttps2dq %xmm1, %xmm0
; SSE42-NEXT:    pmulld %xmm6, %xmm0
; SSE42-NEXT:    pslld $23, %xmm2
; SSE42-NEXT:    paddd %xmm9, %xmm2
; SSE42-NEXT:    cvttps2dq %xmm2, %xmm1
; SSE42-NEXT:    pmulld %xmm7, %xmm1
; SSE42-NEXT:    pslld $23, %xmm3
; SSE42-NEXT:    paddd %xmm9, %xmm3
; SSE42-NEXT:    cvttps2dq %xmm3, %xmm2
; SSE42-NEXT:    pmulld %xmm8, %xmm2
; SSE42-NEXT:    pslld $23, %xmm4
; SSE42-NEXT:    paddd %xmm9, %xmm4
; SSE42-NEXT:    cvttps2dq %xmm4, %xmm3
; SSE42-NEXT:    pmulld %xmm5, %xmm3
; SSE42-NEXT:    retq
;
; AVX2-LABEL: shl_v16i32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsllvd %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: shl_v16i32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512-NEXT:    vpsllvd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = shl <16 x i32> %s, %x
  ret <16 x i32> %r
}

define <8 x i32> @shl_v8i32_cast_cond(i8 noundef zeroext %pb, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; SSE2-LABEL: shl_v8i32_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [16,32,64,128]
; SSE2-NEXT:    movdqa %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-NEXT:    pand %xmm3, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8]
; SSE2-NEXT:    pand %xmm3, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm5
; SSE2-NEXT:    pand %xmm2, %xmm5
; SSE2-NEXT:    pslld $23, %xmm5
; SSE2-NEXT:    movdqa {{.*#+}} xmm2 = [1065353216,1065353216,1065353216,1065353216]
; SSE2-NEXT:    paddd %xmm2, %xmm5
; SSE2-NEXT:    cvttps2dq %xmm5, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm5, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm3[0],xmm0[1],xmm3[1]
; SSE2-NEXT:    pslld $23, %xmm4
; SSE2-NEXT:    paddd %xmm2, %xmm4
; SSE2-NEXT:    cvttps2dq %xmm4, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm2, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE2-NEXT:    pmuludq %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm1 = xmm1[0],xmm2[0],xmm1[1],xmm2[1]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: shl_v8i32_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movd %edi, %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,0,0,0]
; SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [16,32,64,128]
; SSE42-NEXT:    movdqa %xmm4, %xmm6
; SSE42-NEXT:    pand %xmm5, %xmm6
; SSE42-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE42-NEXT:    pand %xmm3, %xmm6
; SSE42-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8]
; SSE42-NEXT:    pand %xmm3, %xmm4
; SSE42-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE42-NEXT:    pand %xmm2, %xmm4
; SSE42-NEXT:    pslld $23, %xmm4
; SSE42-NEXT:    movdqa {{.*#+}} xmm2 = [1065353216,1065353216,1065353216,1065353216]
; SSE42-NEXT:    paddd %xmm2, %xmm4
; SSE42-NEXT:    cvttps2dq %xmm4, %xmm3
; SSE42-NEXT:    pmulld %xmm3, %xmm0
; SSE42-NEXT:    pslld $23, %xmm6
; SSE42-NEXT:    paddd %xmm2, %xmm6
; SSE42-NEXT:    cvttps2dq %xmm6, %xmm2
; SSE42-NEXT:    pmulld %xmm2, %xmm1
; SSE42-NEXT:    retq
;
; AVX2-LABEL: shl_v8i32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: shl_v8i32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: shl_v8i32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpsllvd %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = shl <8 x i32> %x, %s
  ret <8 x i32> %r
}

define <8 x i64> @shl_v8i64_cast_cond(i8 noundef zeroext %pb, <8 x i64> noundef %x, <8 x i64> noundef %y) {
; SSE2-LABEL: shl_v8i64_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [64,128]
; SSE2-NEXT:    movdqa %xmm9, %xmm8
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm8[1,0,3,2]
; SSE2-NEXT:    pand %xmm7, %xmm8
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [16,32]
; SSE2-NEXT:    movdqa %xmm9, %xmm7
; SSE2-NEXT:    pand %xmm10, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm7[1,0,3,2]
; SSE2-NEXT:    pand %xmm6, %xmm7
; SSE2-NEXT:    pand %xmm10, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE2-NEXT:    movdqa %xmm9, %xmm10
; SSE2-NEXT:    pand %xmm6, %xmm10
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm10[1,0,3,2]
; SSE2-NEXT:    pand %xmm5, %xmm10
; SSE2-NEXT:    pand %xmm6, %xmm10
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[1,0,3,2]
; SSE2-NEXT:    pand %xmm4, %xmm9
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    psllq %xmm9, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[2,3,2,3]
; SSE2-NEXT:    psllq %xmm5, %xmm0
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    psllq %xmm10, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[2,3,2,3]
; SSE2-NEXT:    psllq %xmm5, %xmm1
; SSE2-NEXT:    movsd {{.*#+}} xmm1 = xmm4[0],xmm1[1]
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    psllq %xmm7, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[2,3,2,3]
; SSE2-NEXT:    psllq %xmm5, %xmm2
; SSE2-NEXT:    movsd {{.*#+}} xmm2 = xmm4[0],xmm2[1]
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    psllq %xmm8, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[2,3,2,3]
; SSE2-NEXT:    psllq %xmm5, %xmm3
; SSE2-NEXT:    movsd {{.*#+}} xmm3 = xmm4[0],xmm3[1]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: shl_v8i64_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movd %edi, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE42-NEXT:    movdqa {{.*#+}} xmm10 = [64,128]
; SSE42-NEXT:    movdqa %xmm9, %xmm8
; SSE42-NEXT:    pand %xmm10, %xmm8
; SSE42-NEXT:    pcmpeqq %xmm10, %xmm8
; SSE42-NEXT:    pand %xmm7, %xmm8
; SSE42-NEXT:    movdqa {{.*#+}} xmm10 = [16,32]
; SSE42-NEXT:    movdqa %xmm9, %xmm7
; SSE42-NEXT:    pand %xmm10, %xmm7
; SSE42-NEXT:    pcmpeqq %xmm10, %xmm7
; SSE42-NEXT:    pand %xmm6, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE42-NEXT:    movdqa %xmm9, %xmm10
; SSE42-NEXT:    pand %xmm6, %xmm10
; SSE42-NEXT:    pcmpeqq %xmm6, %xmm10
; SSE42-NEXT:    pand %xmm5, %xmm10
; SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE42-NEXT:    pand %xmm5, %xmm9
; SSE42-NEXT:    pcmpeqq %xmm5, %xmm9
; SSE42-NEXT:    pand %xmm4, %xmm9
; SSE42-NEXT:    movdqa %xmm0, %xmm4
; SSE42-NEXT:    psllq %xmm9, %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[2,3,2,3]
; SSE42-NEXT:    psllq %xmm5, %xmm0
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm4[0,1,2,3],xmm0[4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm4
; SSE42-NEXT:    psllq %xmm10, %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[2,3,2,3]
; SSE42-NEXT:    psllq %xmm5, %xmm1
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm4[0,1,2,3],xmm1[4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm4
; SSE42-NEXT:    psllq %xmm7, %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[2,3,2,3]
; SSE42-NEXT:    psllq %xmm5, %xmm2
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm4[0,1,2,3],xmm2[4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm4
; SSE42-NEXT:    psllq %xmm8, %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[2,3,2,3]
; SSE42-NEXT:    psllq %xmm5, %xmm3
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm4[0,1,2,3],xmm3[4,5,6,7]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: shl_v8i64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpand %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpsllvq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsllvq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: shl_v8i64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vpsllvq %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i64> %y, <8 x i64> zeroinitializer
  %r = shl <8 x i64> %x, %s
  ret <8 x i64> %r
}

define <4 x i32> @lshr_v4i32(<4 x i1> %b, <4 x i32> noundef %x, <4 x i32> noundef %y) {
; SSE2-LABEL: lshr_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    psrld %xmm2, %xmm3
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psrld %xmm4, %xmm2
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm0[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    psrld %xmm3, %xmm4
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrld %xmm0, %xmm1
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm1 = xmm1[1],xmm4[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm1[0,3]
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: lshr_v4i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    psrad $31, %xmm0
; SSE42-NEXT:    pand %xmm2, %xmm0
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm3
; SSE42-NEXT:    psrld %xmm2, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm4 = xmm2[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm5
; SSE42-NEXT:    psrld %xmm4, %xmm5
; SSE42-NEXT:    pblendw {{.*#+}} xmm5 = xmm3[0,1,2,3],xmm5[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm0[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    psrld %xmm3, %xmm0
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrld %xmm2, %xmm1
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm5[2,3],xmm0[4,5],xmm5[6,7]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: lshr_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpsrlvd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: lshr_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsrlvd %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: lshr_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpsrlvd %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x i32> %y, <4 x i32> zeroinitializer
  %r = lshr <4 x i32> %x, %s
  ret <4 x i32> %r
}

; negative test - lshr is not commutative; there is no identity constant for operand 0

define <8 x i32> @lshr_v8i32_commute(<8 x i1> %b, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; SSE2-LABEL: lshr_v8i32_commute:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pand %xmm4, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm3[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    psrld %xmm4, %xmm6
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    psrld %xmm3, %xmm4
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm4 = xmm4[1],xmm6[1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    psrld %xmm3, %xmm6
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrld %xmm3, %xmm0
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm6[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm4[0,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm3[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrld %xmm4, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    psrld %xmm3, %xmm4
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm4 = xmm4[1],xmm5[1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm2[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrld %xmm3, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrld %xmm2, %xmm1
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm4[0,3]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: lshr_v8i32_commute:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE42-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    psrad $31, %xmm5
; SSE42-NEXT:    pand %xmm4, %xmm5
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    psrad $31, %xmm0
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm4 = xmm3[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm6
; SSE42-NEXT:    psrld %xmm4, %xmm6
; SSE42-NEXT:    pshuflw {{.*#+}} xmm4 = xmm1[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm7
; SSE42-NEXT:    psrld %xmm4, %xmm7
; SSE42-NEXT:    pblendw {{.*#+}} xmm7 = xmm7[0,1,2,3],xmm6[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm4
; SSE42-NEXT:    psrld %xmm3, %xmm4
; SSE42-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrld %xmm1, %xmm0
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm4[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm7[2,3],xmm0[4,5],xmm7[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm1[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm5, %xmm4
; SSE42-NEXT:    psrld %xmm3, %xmm4
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm2[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm5, %xmm6
; SSE42-NEXT:    psrld %xmm3, %xmm6
; SSE42-NEXT:    pblendw {{.*#+}} xmm6 = xmm6[0,1,2,3],xmm4[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm1[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm5, %xmm1
; SSE42-NEXT:    psrld %xmm3, %xmm1
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrld %xmm2, %xmm5
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm5[0,1,2,3],xmm1[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm6[2,3],xmm1[4,5],xmm6[6,7]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: lshr_v8i32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: lshr_v8i32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: lshr_v8i32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vmovdqa32 %ymm2, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = lshr <8 x i32> %s, %x
  ret <8 x i32> %r
}

define <16 x i32> @lshr_v16i32_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; SSE2-LABEL: lshr_v16i32_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm8
; SSE2-NEXT:    movdqa %xmm0, %xmm10
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm10, %xmm9
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm9 = xmm9[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm9
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm10
; SSE2-NEXT:    psrad $31, %xmm10
; SSE2-NEXT:    pandn %xmm7, %xmm10
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm8, %xmm7
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm7
; SSE2-NEXT:    psrad $31, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm8
; SSE2-NEXT:    psrad $31, %xmm8
; SSE2-NEXT:    pandn %xmm5, %xmm8
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm8[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrld %xmm0, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm8[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrld %xmm6, %xmm0
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm5[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm8
; SSE2-NEXT:    psrld %xmm6, %xmm8
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrld %xmm5, %xmm1
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm1 = xmm1[1],xmm8[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm1[0,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm7[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    psrld %xmm1, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm7[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    psrld %xmm6, %xmm1
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm2, %xmm7
; SSE2-NEXT:    psrld %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrld %xmm5, %xmm2
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm7[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm2[0,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm10[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm3, %xmm5
; SSE2-NEXT:    psrld %xmm2, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm10[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    psrld %xmm6, %xmm2
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm5[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm3, %xmm7
; SSE2-NEXT:    psrld %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrld %xmm5, %xmm3
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm3 = xmm3[1],xmm7[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm3[0,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm9[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    psrld %xmm3, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm9[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm4, %xmm3
; SSE2-NEXT:    psrld %xmm6, %xmm3
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm4, %xmm7
; SSE2-NEXT:    psrld %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrld %xmm5, %xmm4
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm4 = xmm4[1],xmm7[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,3],xmm4[0,3]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: lshr_v16i32_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm8 = xmm8[0],zero,zero,zero,xmm8[1],zero,zero,zero,xmm8[2],zero,zero,zero,xmm8[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm8
; SSE42-NEXT:    psrad $31, %xmm8
; SSE42-NEXT:    pandn %xmm7, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,xmm7[1],zero,zero,zero,xmm7[2],zero,zero,zero,xmm7[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm7
; SSE42-NEXT:    psrad $31, %xmm7
; SSE42-NEXT:    pandn %xmm6, %xmm7
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm6 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm6
; SSE42-NEXT:    psrad $31, %xmm6
; SSE42-NEXT:    pandn %xmm5, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    psrad $31, %xmm5
; SSE42-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm5
; SSE42-NEXT:    pshuflw {{.*#+}} xmm0 = xmm6[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm9
; SSE42-NEXT:    psrld %xmm0, %xmm9
; SSE42-NEXT:    pshufd {{.*#+}} xmm10 = xmm6[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm0 = xmm10[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm11
; SSE42-NEXT:    psrld %xmm0, %xmm11
; SSE42-NEXT:    pblendw {{.*#+}} xmm11 = xmm9[0,1,2,3],xmm11[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    psrld %xmm6, %xmm0
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm10[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrld %xmm6, %xmm1
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm11[2,3],xmm0[4,5],xmm11[6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm1 = xmm7[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm6
; SSE42-NEXT:    psrld %xmm1, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm9 = xmm7[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm1 = xmm9[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm10
; SSE42-NEXT:    psrld %xmm1, %xmm10
; SSE42-NEXT:    pblendw {{.*#+}} xmm10 = xmm6[0,1,2,3],xmm10[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm7[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm1
; SSE42-NEXT:    psrld %xmm6, %xmm1
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm9[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrld %xmm6, %xmm2
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm2[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm10[2,3],xmm1[4,5],xmm10[6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm8[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm6
; SSE42-NEXT:    psrld %xmm2, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm8[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm7[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm9
; SSE42-NEXT:    psrld %xmm2, %xmm9
; SSE42-NEXT:    pblendw {{.*#+}} xmm9 = xmm6[0,1,2,3],xmm9[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm8[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm2
; SSE42-NEXT:    psrld %xmm6, %xmm2
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm7[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrld %xmm6, %xmm3
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm3[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm9[2,3],xmm2[4,5],xmm9[6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm5[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm4, %xmm6
; SSE42-NEXT:    psrld %xmm3, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm5[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm7[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm4, %xmm8
; SSE42-NEXT:    psrld %xmm3, %xmm8
; SSE42-NEXT:    pblendw {{.*#+}} xmm8 = xmm6[0,1,2,3],xmm8[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm4, %xmm3
; SSE42-NEXT:    psrld %xmm5, %xmm3
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm7[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrld %xmm5, %xmm4
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1,2,3],xmm4[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1],xmm8[2,3],xmm3[4,5],xmm8[6,7]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: lshr_v16i32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlvd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsrlvd %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: lshr_v16i32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vpsrlvd %zmm2, %zmm1, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = lshr <16 x i32> %x, %s
  ret <16 x i32> %r
}

; negative test - lshr is not commutative; there is no identity constant for operand 0

define <16 x i32> @lshr_v16i32_commute_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; SSE2-LABEL: lshr_v16i32_commute_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm3, %xmm8
; SSE2-NEXT:    movdqa %xmm2, %xmm9
; SSE2-NEXT:    movdqa %xmm1, %xmm10
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm2, %xmm3
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm3
; SSE2-NEXT:    psrad $31, %xmm3
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm3
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    pandn %xmm7, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pandn %xmm6, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pandn %xmm5, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    psrld %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    psrld %xmm5, %xmm6
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm6 = xmm6[1],xmm7[1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm10[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    psrld %xmm5, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm10[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrld %xmm5, %xmm0
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm7[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm6[0,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm7
; SSE2-NEXT:    psrld %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm6
; SSE2-NEXT:    psrld %xmm5, %xmm6
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm6 = xmm6[1],xmm7[1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm9[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm7
; SSE2-NEXT:    psrld %xmm5, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm9[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrld %xmm5, %xmm1
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm7[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm6[0,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm2, %xmm7
; SSE2-NEXT:    psrld %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm2, %xmm6
; SSE2-NEXT:    psrld %xmm5, %xmm6
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm6 = xmm6[1],xmm7[1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm8[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm2, %xmm7
; SSE2-NEXT:    psrld %xmm5, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm8[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrld %xmm5, %xmm2
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm7[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm6[0,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm3, %xmm7
; SSE2-NEXT:    psrld %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm3, %xmm6
; SSE2-NEXT:    psrld %xmm5, %xmm6
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm6 = xmm6[1],xmm7[1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm4[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm3, %xmm7
; SSE2-NEXT:    psrld %xmm5, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrld %xmm4, %xmm3
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm7[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,3],xmm6[0,3]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: lshr_v16i32_commute_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm3, %xmm10
; SSE42-NEXT:    movdqa %xmm2, %xmm9
; SSE42-NEXT:    movdqa %xmm1, %xmm8
; SSE42-NEXT:    movdqa %xmm0, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm2 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm2
; SSE42-NEXT:    psrad $31, %xmm2
; SSE42-NEXT:    pandn %xmm7, %xmm2
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm1
; SSE42-NEXT:    psrad $31, %xmm1
; SSE42-NEXT:    pandn %xmm6, %xmm1
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    psrad $31, %xmm0
; SSE42-NEXT:    pandn %xmm5, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm3
; SSE42-NEXT:    psrad $31, %xmm3
; SSE42-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm7
; SSE42-NEXT:    psrld %xmm6, %xmm7
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm8[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm11
; SSE42-NEXT:    psrld %xmm6, %xmm11
; SSE42-NEXT:    pblendw {{.*#+}} xmm11 = xmm11[0,1,2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm6
; SSE42-NEXT:    psrld %xmm5, %xmm6
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm8[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrld %xmm5, %xmm0
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm6[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm11[2,3],xmm0[4,5],xmm11[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm7
; SSE42-NEXT:    psrld %xmm6, %xmm7
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm9[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm8
; SSE42-NEXT:    psrld %xmm6, %xmm8
; SSE42-NEXT:    pblendw {{.*#+}} xmm8 = xmm8[0,1,2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm6
; SSE42-NEXT:    psrld %xmm5, %xmm6
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm9[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrld %xmm5, %xmm1
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm6[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm8[2,3],xmm1[4,5],xmm8[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm7
; SSE42-NEXT:    psrld %xmm6, %xmm7
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm10[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm8
; SSE42-NEXT:    psrld %xmm6, %xmm8
; SSE42-NEXT:    pblendw {{.*#+}} xmm8 = xmm8[0,1,2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm6
; SSE42-NEXT:    psrld %xmm5, %xmm6
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm10[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrld %xmm5, %xmm2
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm6[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm8[2,3],xmm2[4,5],xmm8[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm7
; SSE42-NEXT:    psrld %xmm6, %xmm7
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm4[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm8
; SSE42-NEXT:    psrld %xmm6, %xmm8
; SSE42-NEXT:    pblendw {{.*#+}} xmm8 = xmm8[0,1,2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm6
; SSE42-NEXT:    psrld %xmm5, %xmm6
; SSE42-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrld %xmm4, %xmm3
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1,2,3],xmm6[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1],xmm8[2,3],xmm3[4,5],xmm8[6,7]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: lshr_v16i32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlvd %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: lshr_v16i32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512-NEXT:    vpsrlvd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = lshr <16 x i32> %s, %x
  ret <16 x i32> %r
}

define <8 x i32> @lshr_v8i32_cast_cond(i8 noundef zeroext %pb, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; SSE2-LABEL: lshr_v8i32_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [16,32,64,128]
; SSE2-NEXT:    movdqa %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-NEXT:    pand %xmm3, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8]
; SSE2-NEXT:    pand %xmm3, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm5
; SSE2-NEXT:    pand %xmm2, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    psrld %xmm2, %xmm3
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    psrld %xmm6, %xmm2
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm3[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    psrld %xmm5, %xmm6
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrld %xmm3, %xmm0
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm6[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm0[0,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm4[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrld %xmm0, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm4[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    psrld %xmm0, %xmm3
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrld %xmm4, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrld %xmm0, %xmm1
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm1 = xmm1[1],xmm5[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,3],xmm1[0,3]
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    movaps %xmm3, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: lshr_v8i32_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movd %edi, %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,0,0]
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [16,32,64,128]
; SSE42-NEXT:    movdqa %xmm5, %xmm4
; SSE42-NEXT:    pand %xmm6, %xmm4
; SSE42-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE42-NEXT:    pand %xmm3, %xmm4
; SSE42-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8]
; SSE42-NEXT:    pand %xmm3, %xmm5
; SSE42-NEXT:    pcmpeqd %xmm3, %xmm5
; SSE42-NEXT:    pand %xmm2, %xmm5
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm5[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm3
; SSE42-NEXT:    psrld %xmm2, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm2[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm7
; SSE42-NEXT:    psrld %xmm6, %xmm7
; SSE42-NEXT:    pblendw {{.*#+}} xmm7 = xmm3[0,1,2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm5[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    psrld %xmm3, %xmm5
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrld %xmm2, %xmm0
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm5[0,1,2,3],xmm0[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm7[2,3],xmm0[4,5],xmm7[6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm4[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm3
; SSE42-NEXT:    psrld %xmm2, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm2[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm6
; SSE42-NEXT:    psrld %xmm5, %xmm6
; SSE42-NEXT:    pblendw {{.*#+}} xmm6 = xmm3[0,1,2,3],xmm6[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm4[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm4
; SSE42-NEXT:    psrld %xmm3, %xmm4
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrld %xmm2, %xmm1
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm4[0,1,2,3],xmm1[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm6[2,3],xmm1[4,5],xmm6[6,7]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: lshr_v8i32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: lshr_v8i32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: lshr_v8i32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpsrlvd %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = lshr <8 x i32> %x, %s
  ret <8 x i32> %r
}

define <8 x i64> @lshr_v8i64_cast_cond(i8 noundef zeroext %pb, <8 x i64> noundef %x, <8 x i64> noundef %y) {
; SSE2-LABEL: lshr_v8i64_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [64,128]
; SSE2-NEXT:    movdqa %xmm9, %xmm8
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm8[1,0,3,2]
; SSE2-NEXT:    pand %xmm7, %xmm8
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [16,32]
; SSE2-NEXT:    movdqa %xmm9, %xmm7
; SSE2-NEXT:    pand %xmm10, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm7[1,0,3,2]
; SSE2-NEXT:    pand %xmm6, %xmm7
; SSE2-NEXT:    pand %xmm10, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE2-NEXT:    movdqa %xmm9, %xmm10
; SSE2-NEXT:    pand %xmm6, %xmm10
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm10
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm10[1,0,3,2]
; SSE2-NEXT:    pand %xmm5, %xmm10
; SSE2-NEXT:    pand %xmm6, %xmm10
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[1,0,3,2]
; SSE2-NEXT:    pand %xmm4, %xmm9
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    psrlq %xmm9, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[2,3,2,3]
; SSE2-NEXT:    psrlq %xmm5, %xmm0
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm4[0],xmm0[1]
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    psrlq %xmm10, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[2,3,2,3]
; SSE2-NEXT:    psrlq %xmm5, %xmm1
; SSE2-NEXT:    movsd {{.*#+}} xmm1 = xmm4[0],xmm1[1]
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    psrlq %xmm7, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[2,3,2,3]
; SSE2-NEXT:    psrlq %xmm5, %xmm2
; SSE2-NEXT:    movsd {{.*#+}} xmm2 = xmm4[0],xmm2[1]
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    psrlq %xmm8, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[2,3,2,3]
; SSE2-NEXT:    psrlq %xmm5, %xmm3
; SSE2-NEXT:    movsd {{.*#+}} xmm3 = xmm4[0],xmm3[1]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: lshr_v8i64_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movd %edi, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE42-NEXT:    movdqa {{.*#+}} xmm10 = [64,128]
; SSE42-NEXT:    movdqa %xmm9, %xmm8
; SSE42-NEXT:    pand %xmm10, %xmm8
; SSE42-NEXT:    pcmpeqq %xmm10, %xmm8
; SSE42-NEXT:    pand %xmm7, %xmm8
; SSE42-NEXT:    movdqa {{.*#+}} xmm10 = [16,32]
; SSE42-NEXT:    movdqa %xmm9, %xmm7
; SSE42-NEXT:    pand %xmm10, %xmm7
; SSE42-NEXT:    pcmpeqq %xmm10, %xmm7
; SSE42-NEXT:    pand %xmm6, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [4,8]
; SSE42-NEXT:    movdqa %xmm9, %xmm10
; SSE42-NEXT:    pand %xmm6, %xmm10
; SSE42-NEXT:    pcmpeqq %xmm6, %xmm10
; SSE42-NEXT:    pand %xmm5, %xmm10
; SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE42-NEXT:    pand %xmm5, %xmm9
; SSE42-NEXT:    pcmpeqq %xmm5, %xmm9
; SSE42-NEXT:    pand %xmm4, %xmm9
; SSE42-NEXT:    movdqa %xmm0, %xmm4
; SSE42-NEXT:    psrlq %xmm9, %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[2,3,2,3]
; SSE42-NEXT:    psrlq %xmm5, %xmm0
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm4[0,1,2,3],xmm0[4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm4
; SSE42-NEXT:    psrlq %xmm10, %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[2,3,2,3]
; SSE42-NEXT:    psrlq %xmm5, %xmm1
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm4[0,1,2,3],xmm1[4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm4
; SSE42-NEXT:    psrlq %xmm7, %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[2,3,2,3]
; SSE42-NEXT:    psrlq %xmm5, %xmm2
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm4[0,1,2,3],xmm2[4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm4
; SSE42-NEXT:    psrlq %xmm8, %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[2,3,2,3]
; SSE42-NEXT:    psrlq %xmm5, %xmm3
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm4[0,1,2,3],xmm3[4,5,6,7]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: lshr_v8i64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpand %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpsrlvq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlvq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: lshr_v8i64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vpsrlvq %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i64> %y, <8 x i64> zeroinitializer
  %r = lshr <8 x i64> %x, %s
  ret <8 x i64> %r
}

define <4 x i32> @ashr_v4i32(<4 x i1> %b, <4 x i32> noundef %x, <4 x i32> noundef %y) {
; SSE2-LABEL: ashr_v4i32:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    psrad %xmm2, %xmm3
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    psrad %xmm4, %xmm2
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm0[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    psrad %xmm3, %xmm4
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrad %xmm0, %xmm1
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm1 = xmm1[1],xmm4[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm1[0,3]
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: ashr_v4i32:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    psrad $31, %xmm0
; SSE42-NEXT:    pand %xmm2, %xmm0
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm0[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm3
; SSE42-NEXT:    psrad %xmm2, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm4 = xmm2[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm5
; SSE42-NEXT:    psrad %xmm4, %xmm5
; SSE42-NEXT:    pblendw {{.*#+}} xmm5 = xmm3[0,1,2,3],xmm5[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm0[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    psrad %xmm3, %xmm0
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrad %xmm2, %xmm1
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm5[2,3],xmm0[4,5],xmm5[6,7]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: ashr_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX2-NEXT:    vpand %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpsravd %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: ashr_v4i32:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm2 killed $xmm2 def $zmm2
; AVX512F-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsravd %xmm0, %xmm1, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: ashr_v4i32:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX512VL-NEXT:    vptestmd %xmm0, %xmm0, %k1
; AVX512VL-NEXT:    vpsravd %xmm2, %xmm1, %xmm1 {%k1}
; AVX512VL-NEXT:    vmovdqa %xmm1, %xmm0
; AVX512VL-NEXT:    retq
  %s = select <4 x i1> %b, <4 x i32> %y, <4 x i32> zeroinitializer
  %r = ashr <4 x i32> %x, %s
  ret <4 x i32> %r
}

; negative test - ashr is not commutative; there is no identity constant for operand 0

define <8 x i32> @ashr_v8i32_commute(<8 x i1> %b, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; SSE2-LABEL: ashr_v8i32_commute:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pand %xmm4, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pand %xmm3, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm3[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    psrad %xmm4, %xmm6
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    psrad %xmm3, %xmm4
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm4 = xmm4[1],xmm6[1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    psrad %xmm3, %xmm6
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrad %xmm3, %xmm0
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm6[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm4[0,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm3[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrad %xmm4, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    psrad %xmm3, %xmm4
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm4 = xmm4[1],xmm5[1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm2[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrad %xmm3, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrad %xmm2, %xmm1
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm4[0,3]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: ashr_v8i32_commute:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    pmovzxwd {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; SSE42-NEXT:    punpckhwd {{.*#+}} xmm5 = xmm5[4,4,5,5,6,6,7,7]
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    psrad $31, %xmm5
; SSE42-NEXT:    pand %xmm4, %xmm5
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    psrad $31, %xmm0
; SSE42-NEXT:    pand %xmm3, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm1[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm4 = xmm3[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm6
; SSE42-NEXT:    psrad %xmm4, %xmm6
; SSE42-NEXT:    pshuflw {{.*#+}} xmm4 = xmm1[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm7
; SSE42-NEXT:    psrad %xmm4, %xmm7
; SSE42-NEXT:    pblendw {{.*#+}} xmm7 = xmm7[0,1,2,3],xmm6[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm4
; SSE42-NEXT:    psrad %xmm3, %xmm4
; SSE42-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrad %xmm1, %xmm0
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm4[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm7[2,3],xmm0[4,5],xmm7[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm1[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm5, %xmm4
; SSE42-NEXT:    psrad %xmm3, %xmm4
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm2[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm5, %xmm6
; SSE42-NEXT:    psrad %xmm3, %xmm6
; SSE42-NEXT:    pblendw {{.*#+}} xmm6 = xmm6[0,1,2,3],xmm4[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm1[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm5, %xmm1
; SSE42-NEXT:    psrad %xmm3, %xmm1
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrad %xmm2, %xmm5
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm5[0,1,2,3],xmm1[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm6[2,3],xmm1[4,5],xmm6[6,7]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: ashr_v8i32_commute:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: ashr_v8i32_commute:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm2 killed $ymm2 def $zmm2
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512F-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: ashr_v8i32_commute:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vmovdqa32 %ymm2, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = ashr <8 x i32> %s, %x
  ret <8 x i32> %r
}

define <16 x i32> @ashr_v16i32_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; SSE2-LABEL: ashr_v16i32_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm8
; SSE2-NEXT:    movdqa %xmm0, %xmm10
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm10 = xmm10[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm10, %xmm9
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm9 = xmm9[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm9
; SSE2-NEXT:    psrad $31, %xmm9
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm9
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm10 = xmm10[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm10
; SSE2-NEXT:    psrad $31, %xmm10
; SSE2-NEXT:    pandn %xmm7, %xmm10
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm8 = xmm8[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm8, %xmm7
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm7 = xmm7[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm7
; SSE2-NEXT:    psrad $31, %xmm7
; SSE2-NEXT:    pandn %xmm6, %xmm7
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm8 = xmm8[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm8
; SSE2-NEXT:    psrad $31, %xmm8
; SSE2-NEXT:    pandn %xmm5, %xmm8
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm8[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrad %xmm0, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm8[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm0
; SSE2-NEXT:    psrad %xmm6, %xmm0
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm5[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm8
; SSE2-NEXT:    psrad %xmm6, %xmm8
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrad %xmm5, %xmm1
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm1 = xmm1[1],xmm8[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm1[0,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm1 = xmm7[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    psrad %xmm1, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm7[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm2, %xmm1
; SSE2-NEXT:    psrad %xmm6, %xmm1
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm2, %xmm7
; SSE2-NEXT:    psrad %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrad %xmm5, %xmm2
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm2 = xmm2[1],xmm7[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm2[0,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm10[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm3, %xmm5
; SSE2-NEXT:    psrad %xmm2, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm10[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm3, %xmm2
; SSE2-NEXT:    psrad %xmm6, %xmm2
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm5[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm3, %xmm7
; SSE2-NEXT:    psrad %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrad %xmm5, %xmm3
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm3 = xmm3[1],xmm7[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm3[0,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm9[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    psrad %xmm3, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm9[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm4, %xmm3
; SSE2-NEXT:    psrad %xmm6, %xmm3
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm4, %xmm7
; SSE2-NEXT:    psrad %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrad %xmm5, %xmm4
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm4 = xmm4[1],xmm7[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,3],xmm4[0,3]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: ashr_v16i32_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm8 = xmm8[0],zero,zero,zero,xmm8[1],zero,zero,zero,xmm8[2],zero,zero,zero,xmm8[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm8
; SSE42-NEXT:    psrad $31, %xmm8
; SSE42-NEXT:    pandn %xmm7, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm7 = xmm7[0],zero,zero,zero,xmm7[1],zero,zero,zero,xmm7[2],zero,zero,zero,xmm7[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm7
; SSE42-NEXT:    psrad $31, %xmm7
; SSE42-NEXT:    pandn %xmm6, %xmm7
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm6 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm6
; SSE42-NEXT:    psrad $31, %xmm6
; SSE42-NEXT:    pandn %xmm5, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm5 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm5
; SSE42-NEXT:    psrad $31, %xmm5
; SSE42-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm5
; SSE42-NEXT:    pshuflw {{.*#+}} xmm0 = xmm6[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm9
; SSE42-NEXT:    psrad %xmm0, %xmm9
; SSE42-NEXT:    pshufd {{.*#+}} xmm10 = xmm6[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm0 = xmm10[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm11
; SSE42-NEXT:    psrad %xmm0, %xmm11
; SSE42-NEXT:    pblendw {{.*#+}} xmm11 = xmm9[0,1,2,3],xmm11[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm6[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    psrad %xmm6, %xmm0
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm10[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrad %xmm6, %xmm1
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm1[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm11[2,3],xmm0[4,5],xmm11[6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm1 = xmm7[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm6
; SSE42-NEXT:    psrad %xmm1, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm9 = xmm7[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm1 = xmm9[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm10
; SSE42-NEXT:    psrad %xmm1, %xmm10
; SSE42-NEXT:    pblendw {{.*#+}} xmm10 = xmm6[0,1,2,3],xmm10[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm7[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm1
; SSE42-NEXT:    psrad %xmm6, %xmm1
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm9[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrad %xmm6, %xmm2
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm2[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm10[2,3],xmm1[4,5],xmm10[6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm8[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm6
; SSE42-NEXT:    psrad %xmm2, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm8[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm7[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm9
; SSE42-NEXT:    psrad %xmm2, %xmm9
; SSE42-NEXT:    pblendw {{.*#+}} xmm9 = xmm6[0,1,2,3],xmm9[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm8[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm2
; SSE42-NEXT:    psrad %xmm6, %xmm2
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm7[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrad %xmm6, %xmm3
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm3[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm9[2,3],xmm2[4,5],xmm9[6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm5[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm4, %xmm6
; SSE42-NEXT:    psrad %xmm3, %xmm6
; SSE42-NEXT:    pshufd {{.*#+}} xmm7 = xmm5[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm7[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm4, %xmm8
; SSE42-NEXT:    psrad %xmm3, %xmm8
; SSE42-NEXT:    pblendw {{.*#+}} xmm8 = xmm6[0,1,2,3],xmm8[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm4, %xmm3
; SSE42-NEXT:    psrad %xmm5, %xmm3
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm7[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrad %xmm5, %xmm4
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1,2,3],xmm4[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1],xmm8[2,3],xmm3[4,5],xmm8[6,7]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: ashr_v16i32_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsravd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsravd %ymm4, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ashr_v16i32_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vpsravd %zmm2, %zmm1, %zmm1 {%k1}
; AVX512-NEXT:    vmovdqa64 %zmm1, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = ashr <16 x i32> %x, %s
  ret <16 x i32> %r
}

; negative test - ashr is not commutative; there is no identity constant for operand 0

define <16 x i32> @ashr_v16i32_commute_swap(<16 x i1> %b, <16 x i32> noundef %x, <16 x i32> noundef %y) {
; SSE2-LABEL: ashr_v16i32_commute_swap:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm3, %xmm8
; SSE2-NEXT:    movdqa %xmm2, %xmm9
; SSE2-NEXT:    movdqa %xmm1, %xmm10
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    punpckhbw {{.*#+}} xmm2 = xmm2[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; SSE2-NEXT:    movdqa %xmm2, %xmm3
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm3 = xmm3[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm3
; SSE2-NEXT:    psrad $31, %xmm3
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm3
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm2 = xmm2[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm2
; SSE2-NEXT:    psrad $31, %xmm2
; SSE2-NEXT:    pandn %xmm7, %xmm2
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm1
; SSE2-NEXT:    punpckhwd {{.*#+}} xmm1 = xmm1[4,4,5,5,6,6,7,7]
; SSE2-NEXT:    pslld $31, %xmm1
; SSE2-NEXT:    psrad $31, %xmm1
; SSE2-NEXT:    pandn %xmm6, %xmm1
; SSE2-NEXT:    punpcklwd {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    psrad $31, %xmm0
; SSE2-NEXT:    pandn %xmm5, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    psrad %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    psrad %xmm5, %xmm6
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm6 = xmm6[1],xmm7[1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm10[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm7
; SSE2-NEXT:    psrad %xmm5, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm10[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrad %xmm5, %xmm0
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm7[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,3],xmm6[0,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm7
; SSE2-NEXT:    psrad %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm6
; SSE2-NEXT:    psrad %xmm5, %xmm6
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm6 = xmm6[1],xmm7[1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm9[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm7
; SSE2-NEXT:    psrad %xmm5, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm9[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrad %xmm5, %xmm1
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm7[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,3],xmm6[0,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm2, %xmm7
; SSE2-NEXT:    psrad %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm2, %xmm6
; SSE2-NEXT:    psrad %xmm5, %xmm6
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm6 = xmm6[1],xmm7[1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm8[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm2, %xmm7
; SSE2-NEXT:    psrad %xmm5, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm8[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrad %xmm5, %xmm2
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm7[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm6[0,3]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm3, %xmm7
; SSE2-NEXT:    psrad %xmm6, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm3, %xmm6
; SSE2-NEXT:    psrad %xmm5, %xmm6
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm6 = xmm6[1],xmm7[1]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm4[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm3, %xmm7
; SSE2-NEXT:    psrad %xmm5, %xmm7
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrad %xmm4, %xmm3
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm7[0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,3],xmm6[0,3]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: ashr_v16i32_commute_swap:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm3, %xmm10
; SSE42-NEXT:    movdqa %xmm2, %xmm9
; SSE42-NEXT:    movdqa %xmm1, %xmm8
; SSE42-NEXT:    movdqa %xmm0, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm2 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm2
; SSE42-NEXT:    psrad $31, %xmm2
; SSE42-NEXT:    pandn %xmm7, %xmm2
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[1,1,1,1]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm1 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm1
; SSE42-NEXT:    psrad $31, %xmm1
; SSE42-NEXT:    pandn %xmm6, %xmm1
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm0 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm0
; SSE42-NEXT:    psrad $31, %xmm0
; SSE42-NEXT:    pandn %xmm5, %xmm0
; SSE42-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[3,3,3,3]
; SSE42-NEXT:    pmovzxbd {{.*#+}} xmm3 = xmm3[0],zero,zero,zero,xmm3[1],zero,zero,zero,xmm3[2],zero,zero,zero,xmm3[3],zero,zero,zero
; SSE42-NEXT:    pslld $31, %xmm3
; SSE42-NEXT:    psrad $31, %xmm3
; SSE42-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm7
; SSE42-NEXT:    psrad %xmm6, %xmm7
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm8[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm11
; SSE42-NEXT:    psrad %xmm6, %xmm11
; SSE42-NEXT:    pblendw {{.*#+}} xmm11 = xmm11[0,1,2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm6
; SSE42-NEXT:    psrad %xmm5, %xmm6
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm8[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrad %xmm5, %xmm0
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1,2,3],xmm6[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm11[2,3],xmm0[4,5],xmm11[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm7
; SSE42-NEXT:    psrad %xmm6, %xmm7
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm9[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm8
; SSE42-NEXT:    psrad %xmm6, %xmm8
; SSE42-NEXT:    pblendw {{.*#+}} xmm8 = xmm8[0,1,2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm6
; SSE42-NEXT:    psrad %xmm5, %xmm6
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm9[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrad %xmm5, %xmm1
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1,2,3],xmm6[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm8[2,3],xmm1[4,5],xmm8[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm10[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm7
; SSE42-NEXT:    psrad %xmm6, %xmm7
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm10[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm8
; SSE42-NEXT:    psrad %xmm6, %xmm8
; SSE42-NEXT:    pblendw {{.*#+}} xmm8 = xmm8[0,1,2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm6
; SSE42-NEXT:    psrad %xmm5, %xmm6
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm10[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrad %xmm5, %xmm2
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1,2,3],xmm6[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm8[2,3],xmm2[4,5],xmm8[6,7]
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm7
; SSE42-NEXT:    psrad %xmm6, %xmm7
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm4[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm8
; SSE42-NEXT:    psrad %xmm6, %xmm8
; SSE42-NEXT:    pblendw {{.*#+}} xmm8 = xmm8[0,1,2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm6
; SSE42-NEXT:    psrad %xmm5, %xmm6
; SSE42-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrad %xmm4, %xmm3
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1,2,3],xmm6[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1],xmm8[2,3],xmm3[4,5],xmm8[6,7]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: ashr_v16i32_commute_swap:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpunpckhbw {{.*#+}} xmm5 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX2-NEXT:    vpslld $31, %ymm5, %ymm5
; AVX2-NEXT:    vpsrad $31, %ymm5, %ymm5
; AVX2-NEXT:    vpandn %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vpmovzxbd {{.*#+}} ymm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpandn %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsravd %ymm2, %ymm4, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ashr_v16i32_commute_swap:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k1
; AVX512-NEXT:    vmovdqa32 %zmm2, %zmm0 {%k1} {z}
; AVX512-NEXT:    vpsravd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %s = select <16 x i1> %b, <16 x i32> zeroinitializer, <16 x i32> %y
  %r = ashr <16 x i32> %s, %x
  ret <16 x i32> %r
}

define <8 x i32> @ashr_v8i32_cast_cond(i8 noundef zeroext %pb, <8 x i32> noundef %x, <8 x i32> noundef %y) {
; SSE2-LABEL: ashr_v8i32_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,0,0]
; SSE2-NEXT:    movdqa {{.*#+}} xmm6 = [16,32,64,128]
; SSE2-NEXT:    movdqa %xmm5, %xmm4
; SSE2-NEXT:    pand %xmm6, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE2-NEXT:    pand %xmm3, %xmm4
; SSE2-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8]
; SSE2-NEXT:    pand %xmm3, %xmm5
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm5
; SSE2-NEXT:    pand %xmm2, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm2 = xmm5[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm3
; SSE2-NEXT:    psrad %xmm2, %xmm3
; SSE2-NEXT:    pshuflw {{.*#+}} xmm6 = xmm5[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    psrad %xmm6, %xmm2
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm5 = xmm3[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm0, %xmm6
; SSE2-NEXT:    psrad %xmm5, %xmm6
; SSE2-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrad %xmm3, %xmm0
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm0 = xmm0[1],xmm6[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,3],xmm0[0,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm4[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrad %xmm0, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm4[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm3
; SSE2-NEXT:    psrad %xmm0, %xmm3
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[2,3,2,3]
; SSE2-NEXT:    pshuflw {{.*#+}} xmm4 = xmm0[2,3,3,3,4,5,6,7]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrad %xmm4, %xmm5
; SSE2-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,1,1,4,5,6,7]
; SSE2-NEXT:    psrad %xmm0, %xmm1
; SSE2-NEXT:    punpckhqdq {{.*#+}} xmm1 = xmm1[1],xmm5[1]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,3],xmm1[0,3]
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    movaps %xmm3, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: ashr_v8i32_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movd %edi, %xmm4
; SSE42-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,0,0]
; SSE42-NEXT:    movdqa {{.*#+}} xmm6 = [16,32,64,128]
; SSE42-NEXT:    movdqa %xmm5, %xmm4
; SSE42-NEXT:    pand %xmm6, %xmm4
; SSE42-NEXT:    pcmpeqd %xmm6, %xmm4
; SSE42-NEXT:    pand %xmm3, %xmm4
; SSE42-NEXT:    movdqa {{.*#+}} xmm3 = [1,2,4,8]
; SSE42-NEXT:    pand %xmm3, %xmm5
; SSE42-NEXT:    pcmpeqd %xmm3, %xmm5
; SSE42-NEXT:    pand %xmm2, %xmm5
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm5[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm3
; SSE42-NEXT:    psrad %xmm2, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm6 = xmm2[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm7
; SSE42-NEXT:    psrad %xmm6, %xmm7
; SSE42-NEXT:    pblendw {{.*#+}} xmm7 = xmm3[0,1,2,3],xmm7[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm5[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    psrad %xmm3, %xmm5
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrad %xmm2, %xmm0
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm5[0,1,2,3],xmm0[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm7[2,3],xmm0[4,5],xmm7[6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm4[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm3
; SSE42-NEXT:    psrad %xmm2, %xmm3
; SSE42-NEXT:    pshufd {{.*#+}} xmm2 = xmm4[2,3,2,3]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm5 = xmm2[2,3,3,3,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm6
; SSE42-NEXT:    psrad %xmm5, %xmm6
; SSE42-NEXT:    pblendw {{.*#+}} xmm6 = xmm3[0,1,2,3],xmm6[4,5,6,7]
; SSE42-NEXT:    pshuflw {{.*#+}} xmm3 = xmm4[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm4
; SSE42-NEXT:    psrad %xmm3, %xmm4
; SSE42-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,1,1,1,4,5,6,7]
; SSE42-NEXT:    psrad %xmm2, %xmm1
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm4[0,1,2,3],xmm1[4,5,6,7]
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm6[2,3],xmm1[4,5],xmm6[6,7]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: ashr_v8i32_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm2
; AVX2-NEXT:    vpbroadcastb %xmm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,2,4,8,16,32,64,128]
; AVX2-NEXT:    vpand %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpand %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: ashr_v8i32_cast_cond:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    kmovw %edi, %k1
; AVX512F-NEXT:    vmovdqa32 %zmm1, %zmm1 {%k1} {z}
; AVX512F-NEXT:    vpsravd %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: ashr_v8i32_cast_cond:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    kmovw %edi, %k1
; AVX512VL-NEXT:    vpsravd %ymm1, %ymm0, %ymm0 {%k1}
; AVX512VL-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i32> %y, <8 x i32> zeroinitializer
  %r = ashr <8 x i32> %x, %s
  ret <8 x i32> %r
}

define <8 x i64> @ashr_v8i64_cast_cond(i8 noundef zeroext %pb, <8 x i64> noundef %x, <8 x i64> noundef %y) {
; SSE2-LABEL: ashr_v8i64_cast_cond:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movd %edi, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [64,128]
; SSE2-NEXT:    movdqa %xmm9, %xmm8
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm8[1,0,3,2]
; SSE2-NEXT:    pand %xmm7, %xmm8
; SSE2-NEXT:    pand %xmm10, %xmm8
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [16,32]
; SSE2-NEXT:    movdqa %xmm9, %xmm7
; SSE2-NEXT:    pand %xmm10, %xmm7
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm7[1,0,3,2]
; SSE2-NEXT:    pand %xmm6, %xmm7
; SSE2-NEXT:    pand %xmm10, %xmm7
; SSE2-NEXT:    movdqa {{.*#+}} xmm10 = [4,8]
; SSE2-NEXT:    movdqa %xmm9, %xmm6
; SSE2-NEXT:    pand %xmm10, %xmm6
; SSE2-NEXT:    pcmpeqd %xmm10, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm6[1,0,3,2]
; SSE2-NEXT:    pand %xmm5, %xmm6
; SSE2-NEXT:    pand %xmm10, %xmm6
; SSE2-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    pcmpeqd %xmm5, %xmm9
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm9[1,0,3,2]
; SSE2-NEXT:    pand %xmm4, %xmm9
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    movdqa {{.*#+}} xmm4 = [9223372036854775808,9223372036854775808]
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    psrlq %xmm9, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm10 = xmm9[2,3,2,3]
; SSE2-NEXT:    movdqa %xmm4, %xmm11
; SSE2-NEXT:    psrlq %xmm10, %xmm11
; SSE2-NEXT:    movsd {{.*#+}} xmm11 = xmm5[0],xmm11[1]
; SSE2-NEXT:    movdqa %xmm0, %xmm5
; SSE2-NEXT:    psrlq %xmm9, %xmm5
; SSE2-NEXT:    psrlq %xmm10, %xmm0
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm5[0],xmm0[1]
; SSE2-NEXT:    xorpd %xmm11, %xmm0
; SSE2-NEXT:    psubq %xmm11, %xmm0
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    psrlq %xmm6, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm6[2,3,2,3]
; SSE2-NEXT:    movdqa %xmm4, %xmm10
; SSE2-NEXT:    psrlq %xmm9, %xmm10
; SSE2-NEXT:    movsd {{.*#+}} xmm10 = xmm5[0],xmm10[1]
; SSE2-NEXT:    movdqa %xmm1, %xmm5
; SSE2-NEXT:    psrlq %xmm6, %xmm5
; SSE2-NEXT:    psrlq %xmm9, %xmm1
; SSE2-NEXT:    movsd {{.*#+}} xmm1 = xmm5[0],xmm1[1]
; SSE2-NEXT:    xorpd %xmm10, %xmm1
; SSE2-NEXT:    psubq %xmm10, %xmm1
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    psrlq %xmm7, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[2,3,2,3]
; SSE2-NEXT:    movdqa %xmm4, %xmm9
; SSE2-NEXT:    psrlq %xmm6, %xmm9
; SSE2-NEXT:    movsd {{.*#+}} xmm9 = xmm5[0],xmm9[1]
; SSE2-NEXT:    movdqa %xmm2, %xmm5
; SSE2-NEXT:    psrlq %xmm7, %xmm5
; SSE2-NEXT:    psrlq %xmm6, %xmm2
; SSE2-NEXT:    movsd {{.*#+}} xmm2 = xmm5[0],xmm2[1]
; SSE2-NEXT:    xorpd %xmm9, %xmm2
; SSE2-NEXT:    psubq %xmm9, %xmm2
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    psrlq %xmm8, %xmm5
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm8[2,3,2,3]
; SSE2-NEXT:    psrlq %xmm6, %xmm4
; SSE2-NEXT:    movsd {{.*#+}} xmm4 = xmm5[0],xmm4[1]
; SSE2-NEXT:    movdqa %xmm3, %xmm5
; SSE2-NEXT:    psrlq %xmm8, %xmm5
; SSE2-NEXT:    psrlq %xmm6, %xmm3
; SSE2-NEXT:    movsd {{.*#+}} xmm3 = xmm5[0],xmm3[1]
; SSE2-NEXT:    xorpd %xmm4, %xmm3
; SSE2-NEXT:    psubq %xmm4, %xmm3
; SSE2-NEXT:    retq
;
; SSE42-LABEL: ashr_v8i64_cast_cond:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movd %edi, %xmm8
; SSE42-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[0,1,0,1]
; SSE42-NEXT:    movdqa {{.*#+}} xmm10 = [64,128]
; SSE42-NEXT:    movdqa %xmm9, %xmm8
; SSE42-NEXT:    pand %xmm10, %xmm8
; SSE42-NEXT:    pcmpeqq %xmm10, %xmm8
; SSE42-NEXT:    pand %xmm7, %xmm8
; SSE42-NEXT:    movdqa {{.*#+}} xmm10 = [16,32]
; SSE42-NEXT:    movdqa %xmm9, %xmm7
; SSE42-NEXT:    pand %xmm10, %xmm7
; SSE42-NEXT:    pcmpeqq %xmm10, %xmm7
; SSE42-NEXT:    pand %xmm6, %xmm7
; SSE42-NEXT:    movdqa {{.*#+}} xmm10 = [4,8]
; SSE42-NEXT:    movdqa %xmm9, %xmm6
; SSE42-NEXT:    pand %xmm10, %xmm6
; SSE42-NEXT:    pcmpeqq %xmm10, %xmm6
; SSE42-NEXT:    pand %xmm5, %xmm6
; SSE42-NEXT:    movdqa {{.*#+}} xmm5 = [1,2]
; SSE42-NEXT:    pand %xmm5, %xmm9
; SSE42-NEXT:    pcmpeqq %xmm5, %xmm9
; SSE42-NEXT:    pand %xmm4, %xmm9
; SSE42-NEXT:    movdqa {{.*#+}} xmm4 = [9223372036854775808,9223372036854775808]
; SSE42-NEXT:    movdqa %xmm4, %xmm5
; SSE42-NEXT:    psrlq %xmm9, %xmm5
; SSE42-NEXT:    pshufd {{.*#+}} xmm10 = xmm9[2,3,2,3]
; SSE42-NEXT:    movdqa %xmm4, %xmm11
; SSE42-NEXT:    psrlq %xmm10, %xmm11
; SSE42-NEXT:    pblendw {{.*#+}} xmm11 = xmm5[0,1,2,3],xmm11[4,5,6,7]
; SSE42-NEXT:    movdqa %xmm0, %xmm5
; SSE42-NEXT:    psrlq %xmm9, %xmm5
; SSE42-NEXT:    psrlq %xmm10, %xmm0
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm5[0,1,2,3],xmm0[4,5,6,7]
; SSE42-NEXT:    pxor %xmm11, %xmm0
; SSE42-NEXT:    psubq %xmm11, %xmm0
; SSE42-NEXT:    movdqa %xmm4, %xmm5
; SSE42-NEXT:    psrlq %xmm6, %xmm5
; SSE42-NEXT:    pshufd {{.*#+}} xmm9 = xmm6[2,3,2,3]
; SSE42-NEXT:    movdqa %xmm4, %xmm10
; SSE42-NEXT:    psrlq %xmm9, %xmm10
; SSE42-NEXT:    pblendw {{.*#+}} xmm10 = xmm5[0,1,2,3],xmm10[4,5,6,7]
; SSE42-NEXT:    movdqa %xmm1, %xmm5
; SSE42-NEXT:    psrlq %xmm6, %xmm5
; SSE42-NEXT:    psrlq %xmm9, %xmm1
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm5[0,1,2,3],xmm1[4,5,6,7]
; SSE42-NEXT:    pxor %xmm10, %xmm1
; SSE42-NEXT:    psubq %xmm10, %xmm1
; SSE42-NEXT:    movdqa %xmm4, %xmm5
; SSE42-NEXT:    psrlq %xmm7, %xmm5
; SSE42-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[2,3,2,3]
; SSE42-NEXT:    movdqa %xmm4, %xmm9
; SSE42-NEXT:    psrlq %xmm6, %xmm9
; SSE42-NEXT:    pblendw {{.*#+}} xmm9 = xmm5[0,1,2,3],xmm9[4,5,6,7]
; SSE42-NEXT:    movdqa %xmm2, %xmm5
; SSE42-NEXT:    psrlq %xmm7, %xmm5
; SSE42-NEXT:    psrlq %xmm6, %xmm2
; SSE42-NEXT:    pblendw {{.*#+}} xmm2 = xmm5[0,1,2,3],xmm2[4,5,6,7]
; SSE42-NEXT:    pxor %xmm9, %xmm2
; SSE42-NEXT:    psubq %xmm9, %xmm2
; SSE42-NEXT:    movdqa %xmm4, %xmm5
; SSE42-NEXT:    psrlq %xmm8, %xmm5
; SSE42-NEXT:    pshufd {{.*#+}} xmm6 = xmm8[2,3,2,3]
; SSE42-NEXT:    psrlq %xmm6, %xmm4
; SSE42-NEXT:    pblendw {{.*#+}} xmm4 = xmm5[0,1,2,3],xmm4[4,5,6,7]
; SSE42-NEXT:    movdqa %xmm3, %xmm5
; SSE42-NEXT:    psrlq %xmm8, %xmm5
; SSE42-NEXT:    psrlq %xmm6, %xmm3
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm5[0,1,2,3],xmm3[4,5,6,7]
; SSE42-NEXT:    pxor %xmm4, %xmm3
; SSE42-NEXT:    psubq %xmm4, %xmm3
; SSE42-NEXT:    retq
;
; AVX2-LABEL: ashr_v8i64_cast_cond:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovd %edi, %xmm4
; AVX2-NEXT:    vpbroadcastb %xmm4, %ymm4
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [16,32,64,128]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm6
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm6, %ymm5
; AVX2-NEXT:    vpand %ymm3, %ymm5, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm5 = [1,2,4,8]
; AVX2-NEXT:    vpand %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpcmpeqq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpand %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm4 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpsrlvq %ymm2, %ymm4, %ymm5
; AVX2-NEXT:    vpsrlvq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpsubq %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlvq %ymm3, %ymm4, %ymm2
; AVX2-NEXT:    vpsrlvq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: ashr_v8i64_cast_cond:
; AVX512:       # %bb.0:
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vpsravq %zmm1, %zmm0, %zmm0 {%k1}
; AVX512-NEXT:    retq
  %b = bitcast i8 %pb to <8 x i1>
  %s = select <8 x i1> %b, <8 x i64> %y, <8 x i64> zeroinitializer
  %r = ashr <8 x i64> %x, %s
  ret <8 x i64> %r
}

define <8 x i64> @select_sdiv_neutral_constant_v8i64(<8 x i1> %b, <8 x i64> %x, <8 x i64> %y) {
; SSE2-LABEL: select_sdiv_neutral_constant_v8i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm0[2,2,2,2]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,5,5,5,5]
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,0,2,2]
; SSE2-NEXT:    pslld $31, %xmm8
; SSE2-NEXT:    psrad $31, %xmm8
; SSE2-NEXT:    movdqa %xmm8, %xmm10
; SSE2-NEXT:    pandn %xmm7, %xmm10
; SSE2-NEXT:    movdqa {{.*#+}} xmm9 = [1,1]
; SSE2-NEXT:    pand %xmm9, %xmm8
; SSE2-NEXT:    por %xmm10, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm0[1,1,1,1]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,5,5,5,5]
; SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,0,2,2]
; SSE2-NEXT:    pslld $31, %xmm7
; SSE2-NEXT:    psrad $31, %xmm7
; SSE2-NEXT:    movdqa %xmm7, %xmm10
; SSE2-NEXT:    pandn %xmm6, %xmm10
; SSE2-NEXT:    pand %xmm9, %xmm7
; SSE2-NEXT:    por %xmm10, %xmm7
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm0[0,0,0,0]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm6 = xmm6[0,1,2,3,5,5,5,5]
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[0,0,2,2]
; SSE2-NEXT:    pslld $31, %xmm6
; SSE2-NEXT:    psrad $31, %xmm6
; SSE2-NEXT:    movdqa %xmm6, %xmm10
; SSE2-NEXT:    pandn %xmm5, %xmm10
; SSE2-NEXT:    pand %xmm9, %xmm6
; SSE2-NEXT:    por %xmm10, %xmm6
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE2-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,5,5,5,5]
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm0[0,0,2,2]
; SSE2-NEXT:    pslld $31, %xmm5
; SSE2-NEXT:    psrad $31, %xmm5
; SSE2-NEXT:    pand %xmm5, %xmm9
; SSE2-NEXT:    pandn {{[0-9]+}}(%rsp), %xmm5
; SSE2-NEXT:    por %xmm9, %xmm5
; SSE2-NEXT:    movq %xmm6, %rcx
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    cqto
; SSE2-NEXT:    idivq %rcx
; SSE2-NEXT:    movq %rax, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[2,3,2,3]
; SSE2-NEXT:    movq %xmm6, %rcx
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; SSE2-NEXT:    movq %xmm1, %rax
; SSE2-NEXT:    cqto
; SSE2-NEXT:    idivq %rcx
; SSE2-NEXT:    movq %rax, %xmm1
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    movq %xmm7, %rcx
; SSE2-NEXT:    movq %xmm2, %rax
; SSE2-NEXT:    cqto
; SSE2-NEXT:    idivq %rcx
; SSE2-NEXT:    movq %rax, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm7[2,3,2,3]
; SSE2-NEXT:    movq %xmm6, %rcx
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[2,3,2,3]
; SSE2-NEXT:    movq %xmm2, %rax
; SSE2-NEXT:    cqto
; SSE2-NEXT:    idivq %rcx
; SSE2-NEXT:    movq %rax, %xmm2
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE2-NEXT:    movq %xmm8, %rcx
; SSE2-NEXT:    movq %xmm3, %rax
; SSE2-NEXT:    cqto
; SSE2-NEXT:    idivq %rcx
; SSE2-NEXT:    movq %rax, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm6 = xmm8[2,3,2,3]
; SSE2-NEXT:    movq %xmm6, %rcx
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,3,2,3]
; SSE2-NEXT:    movq %xmm3, %rax
; SSE2-NEXT:    cqto
; SSE2-NEXT:    idivq %rcx
; SSE2-NEXT:    movq %rax, %xmm3
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm3[0]
; SSE2-NEXT:    movq %xmm5, %rcx
; SSE2-NEXT:    movq %xmm4, %rax
; SSE2-NEXT:    cqto
; SSE2-NEXT:    idivq %rcx
; SSE2-NEXT:    movq %rax, %xmm3
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[2,3,2,3]
; SSE2-NEXT:    movq %xmm5, %rcx
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,3,2,3]
; SSE2-NEXT:    movq %xmm4, %rax
; SSE2-NEXT:    cqto
; SSE2-NEXT:    idivq %rcx
; SSE2-NEXT:    movq %rax, %xmm4
; SSE2-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm4[0]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: select_sdiv_neutral_constant_v8i64:
; SSE42:       # %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm8
; SSE42-NEXT:    movapd {{[0-9]+}}(%rsp), %xmm9
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; SSE42-NEXT:    pmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; SSE42-NEXT:    psllq $63, %xmm0
; SSE42-NEXT:    movapd {{.*#+}} xmm10 = [1,1]
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm9
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm8[2,3,2,3]
; SSE42-NEXT:    pmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; SSE42-NEXT:    psllq $63, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm7
; SSE42-NEXT:    pshufd {{.*#+}} xmm0 = xmm8[1,1,1,1]
; SSE42-NEXT:    pmovzxwq {{.*#+}} xmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero
; SSE42-NEXT:    psllq $63, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm6
; SSE42-NEXT:    pmovzxwq {{.*#+}} xmm0 = xmm8[0],zero,zero,zero,xmm8[1],zero,zero,zero
; SSE42-NEXT:    psllq $63, %xmm0
; SSE42-NEXT:    blendvpd %xmm0, %xmm10, %xmm5
; SSE42-NEXT:    pextrq $1, %xmm5, %rcx
; SSE42-NEXT:    pextrq $1, %xmm1, %rax
; SSE42-NEXT:    cqto
; SSE42-NEXT:    idivq %rcx
; SSE42-NEXT:    movq %rax, %xmm8
; SSE42-NEXT:    movq %xmm5, %rcx
; SSE42-NEXT:    movq %xmm1, %rax
; SSE42-NEXT:    cqto
; SSE42-NEXT:    idivq %rcx
; SSE42-NEXT:    movq %rax, %xmm0
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm8[0]
; SSE42-NEXT:    pextrq $1, %xmm6, %rcx
; SSE42-NEXT:    pextrq $1, %xmm2, %rax
; SSE42-NEXT:    cqto
; SSE42-NEXT:    idivq %rcx
; SSE42-NEXT:    movq %rax, %xmm5
; SSE42-NEXT:    movq %xmm6, %rcx
; SSE42-NEXT:    movq %xmm2, %rax
; SSE42-NEXT:    cqto
; SSE42-NEXT:    idivq %rcx
; SSE42-NEXT:    movq %rax, %xmm1
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; SSE42-NEXT:    pextrq $1, %xmm7, %rcx
; SSE42-NEXT:    pextrq $1, %xmm3, %rax
; SSE42-NEXT:    cqto
; SSE42-NEXT:    idivq %rcx
; SSE42-NEXT:    movq %rax, %xmm5
; SSE42-NEXT:    movq %xmm7, %rcx
; SSE42-NEXT:    movq %xmm3, %rax
; SSE42-NEXT:    cqto
; SSE42-NEXT:    idivq %rcx
; SSE42-NEXT:    movq %rax, %xmm2
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm5[0]
; SSE42-NEXT:    pextrq $1, %xmm9, %rcx
; SSE42-NEXT:    pextrq $1, %xmm4, %rax
; SSE42-NEXT:    cqto
; SSE42-NEXT:    idivq %rcx
; SSE42-NEXT:    movq %rax, %xmm5
; SSE42-NEXT:    movq %xmm9, %rcx
; SSE42-NEXT:    movq %xmm4, %rax
; SSE42-NEXT:    cqto
; SSE42-NEXT:    idivq %rcx
; SSE42-NEXT:    movq %rax, %xmm3
; SSE42-NEXT:    punpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; SSE42-NEXT:    retq
;
; AVX2-LABEL: select_sdiv_neutral_constant_v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} xmm5 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX2-NEXT:    vpslld $31, %xmm5, %xmm5
; AVX2-NEXT:    vpmovsxdq %xmm5, %ymm5
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [1,1,1,1]
; AVX2-NEXT:    vblendvpd %ymm5, %ymm6, %ymm3, %ymm5
; AVX2-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; AVX2-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vblendvpd %ymm0, %ymm6, %ymm4, %ymm3
; AVX2-NEXT:    vextractf128 $1, %ymm5, %xmm0
; AVX2-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm4
; AVX2-NEXT:    vpextrq $1, %xmm4, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm6
; AVX2-NEXT:    vmovq %xmm0, %rcx
; AVX2-NEXT:    vmovq %xmm4, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm0
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm6[0]
; AVX2-NEXT:    vpextrq $1, %xmm5, %rcx
; AVX2-NEXT:    vpextrq $1, %xmm1, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm4
; AVX2-NEXT:    vmovq %xmm5, %rcx
; AVX2-NEXT:    vmovq %xmm1, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm4[0]
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-NEXT:    vextractf128 $1, %ymm3, %xmm1
; AVX2-NEXT:    vpextrq $1, %xmm1, %rcx
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm4
; AVX2-NEXT:    vpextrq $1, %xmm4, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm5
; AVX2-NEXT:    vmovq %xmm1, %rcx
; AVX2-NEXT:    vmovq %xmm4, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm5[0]
; AVX2-NEXT:    vpextrq $1, %xmm3, %rcx
; AVX2-NEXT:    vpextrq $1, %xmm2, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm4
; AVX2-NEXT:    vmovq %xmm3, %rcx
; AVX2-NEXT:    vmovq %xmm2, %rax
; AVX2-NEXT:    cqto
; AVX2-NEXT:    idivq %rcx
; AVX2-NEXT:    vmovq %rax, %xmm2
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm2[0],xmm4[0]
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: select_sdiv_neutral_constant_v8i64:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpbroadcastq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2 {%k1}
; AVX512F-NEXT:    vextracti32x4 $3, %zmm2, %xmm0
; AVX512F-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX512F-NEXT:    vextracti32x4 $3, %zmm1, %xmm3
; AVX512F-NEXT:    vpextrq $1, %xmm3, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm4
; AVX512F-NEXT:    vmovq %xmm0, %rcx
; AVX512F-NEXT:    vmovq %xmm3, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm0
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm4[0]
; AVX512F-NEXT:    vextracti32x4 $2, %zmm2, %xmm3
; AVX512F-NEXT:    vpextrq $1, %xmm3, %rcx
; AVX512F-NEXT:    vextracti32x4 $2, %zmm1, %xmm4
; AVX512F-NEXT:    vpextrq $1, %xmm4, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm5
; AVX512F-NEXT:    vmovq %xmm3, %rcx
; AVX512F-NEXT:    vmovq %xmm4, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm3
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512F-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512F-NEXT:    vpextrq $1, %xmm3, %rcx
; AVX512F-NEXT:    vextracti128 $1, %ymm1, %xmm4
; AVX512F-NEXT:    vpextrq $1, %xmm4, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm5
; AVX512F-NEXT:    vmovq %xmm3, %rcx
; AVX512F-NEXT:    vmovq %xmm4, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm3
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; AVX512F-NEXT:    vpextrq $1, %xmm2, %rcx
; AVX512F-NEXT:    vpextrq $1, %xmm1, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm4
; AVX512F-NEXT:    vmovq %xmm2, %rcx
; AVX512F-NEXT:    vmovq %xmm1, %rax
; AVX512F-NEXT:    cqto
; AVX512F-NEXT:    idivq %rcx
; AVX512F-NEXT:    vmovq %rax, %xmm1
; AVX512F-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm4[0]
; AVX512F-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512F-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: select_sdiv_neutral_constant_v8i64:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpmovsxwd %xmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vpbroadcastq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %zmm2 {%k1}
; AVX512VL-NEXT:    vextracti32x4 $3, %zmm2, %xmm0
; AVX512VL-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX512VL-NEXT:    vextracti32x4 $3, %zmm1, %xmm3
; AVX512VL-NEXT:    vpextrq $1, %xmm3, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm4
; AVX512VL-NEXT:    vmovq %xmm0, %rcx
; AVX512VL-NEXT:    vmovq %xmm3, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm0
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm4[0]
; AVX512VL-NEXT:    vextracti32x4 $2, %zmm2, %xmm3
; AVX512VL-NEXT:    vpextrq $1, %xmm3, %rcx
; AVX512VL-NEXT:    vextracti32x4 $2, %zmm1, %xmm4
; AVX512VL-NEXT:    vpextrq $1, %xmm4, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm5
; AVX512VL-NEXT:    vmovq %xmm3, %rcx
; AVX512VL-NEXT:    vmovq %xmm4, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm3
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; AVX512VL-NEXT:    vinserti128 $1, %xmm0, %ymm3, %ymm0
; AVX512VL-NEXT:    vextracti128 $1, %ymm2, %xmm3
; AVX512VL-NEXT:    vpextrq $1, %xmm3, %rcx
; AVX512VL-NEXT:    vextracti128 $1, %ymm1, %xmm4
; AVX512VL-NEXT:    vpextrq $1, %xmm4, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm5
; AVX512VL-NEXT:    vmovq %xmm3, %rcx
; AVX512VL-NEXT:    vmovq %xmm4, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm3
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm3 = xmm3[0],xmm5[0]
; AVX512VL-NEXT:    vpextrq $1, %xmm2, %rcx
; AVX512VL-NEXT:    vpextrq $1, %xmm1, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm4
; AVX512VL-NEXT:    vmovq %xmm2, %rcx
; AVX512VL-NEXT:    vmovq %xmm1, %rax
; AVX512VL-NEXT:    cqto
; AVX512VL-NEXT:    idivq %rcx
; AVX512VL-NEXT:    vmovq %rax, %xmm1
; AVX512VL-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm4[0]
; AVX512VL-NEXT:    vinserti128 $1, %xmm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512VL-NEXT:    retq
  %sel = select <8 x i1> %b, <8 x i64> <i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1>, <8 x i64> %y
  %r = sdiv <8 x i64> %x, %sel
  ret <8 x i64> %r
}
