; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -verify-machineinstrs -stop-after=finalize-isel -mtriple=powerpc64-ibm-aix-xcoff \
; RUN:   -mcpu=pwr4 < %s | FileCheck -check-prefix=AIX64 %s
; RUN: llc -verify-machineinstrs -stop-after=finalize-isel -mtriple=powerpc-ibm-aix-xcoff \
; RUN:   -mcpu=pwr4 < %s | FileCheck -check-prefix=AIX32 %s
; RUN: llc -verify-machineinstrs -stop-after=finalize-isel -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 < %s | FileCheck -check-prefix=LE64 %s

;; This file is copied from test/CodeGen/PowerPC/ctrloops.ll.
;; In this file, we are testing the CTR loops form after ISEL.

@a = common global i32 0, align 4

define void @test1(i32 %c) nounwind {
  ; AIX64-LABEL: name: test1
  ; AIX64: bb.0.entry:
  ; AIX64-NEXT:   successors: %bb.1(0x80000000)
  ; AIX64-NEXT:   liveins: $x3
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT:   [[COPY:%[0-9]+]]:g8rc = COPY $x3
  ; AIX64-NEXT:   [[COPY1:%[0-9]+]]:gprc = COPY [[COPY]].sub_32
  ; AIX64-NEXT:   [[LI8_:%[0-9]+]]:g8rc = LI8 2048
  ; AIX64-NEXT:   MTCTR8loop killed [[LI8_]], implicit-def dead $ctr8
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT: bb.1.for.body:
  ; AIX64-NEXT:   successors: %bb.1(0x7c000000), %bb.2(0x04000000)
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT:   [[LDtoc:%[0-9]+]]:g8rc_and_g8rc_nox0 = LDtoc @a, $x2 :: (load (s64) from got)
  ; AIX64-NEXT:   [[LWZ:%[0-9]+]]:gprc = LWZ 0, [[LDtoc]] :: (volatile dereferenceable load (s32) from @a)
  ; AIX64-NEXT:   [[ADD4_:%[0-9]+]]:gprc = nsw ADD4 killed [[LWZ]], [[COPY1]]
  ; AIX64-NEXT:   STW killed [[ADD4_]], 0, [[LDtoc]] :: (volatile store (s32) into @a)
  ; AIX64-NEXT:   [[DecreaseCTR8loop:%[0-9]+]]:crbitrc = DecreaseCTR8loop 1, implicit-def dead $ctr8, implicit $ctr8
  ; AIX64-NEXT:   BC killed [[DecreaseCTR8loop]], %bb.1
  ; AIX64-NEXT:   B %bb.2
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT: bb.2.for.end:
  ; AIX64-NEXT:   BLR8 implicit $lr8, implicit $rm
  ; AIX32-LABEL: name: test1
  ; AIX32: bb.0.entry:
  ; AIX32-NEXT:   successors: %bb.1(0x80000000)
  ; AIX32-NEXT:   liveins: $r3
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT:   [[COPY:%[0-9]+]]:gprc = COPY $r3
  ; AIX32-NEXT:   [[LI:%[0-9]+]]:gprc = LI 2048
  ; AIX32-NEXT:   MTCTRloop killed [[LI]], implicit-def dead $ctr
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT: bb.1.for.body:
  ; AIX32-NEXT:   successors: %bb.1(0x7c000000), %bb.2(0x04000000)
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT:   [[LWZtoc:%[0-9]+]]:gprc_and_gprc_nor0 = LWZtoc @a, $r2 :: (load (s32) from got)
  ; AIX32-NEXT:   [[LWZ:%[0-9]+]]:gprc = LWZ 0, [[LWZtoc]] :: (volatile dereferenceable load (s32) from @a)
  ; AIX32-NEXT:   [[ADD4_:%[0-9]+]]:gprc = nsw ADD4 killed [[LWZ]], [[COPY]]
  ; AIX32-NEXT:   STW killed [[ADD4_]], 0, [[LWZtoc]] :: (volatile store (s32) into @a)
  ; AIX32-NEXT:   [[DecreaseCTRloop:%[0-9]+]]:crbitrc = DecreaseCTRloop 1, implicit-def dead $ctr, implicit $ctr
  ; AIX32-NEXT:   BC killed [[DecreaseCTRloop]], %bb.1
  ; AIX32-NEXT:   B %bb.2
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT: bb.2.for.end:
  ; AIX32-NEXT:   BLR implicit $lr, implicit $rm
  ; LE64-LABEL: name: test1
  ; LE64: bb.0.entry:
  ; LE64-NEXT:   successors: %bb.1(0x80000000)
  ; LE64-NEXT:   liveins: $x3
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT:   [[COPY:%[0-9]+]]:g8rc = COPY $x3
  ; LE64-NEXT:   [[COPY1:%[0-9]+]]:gprc = COPY [[COPY]].sub_32
  ; LE64-NEXT:   [[LI8_:%[0-9]+]]:g8rc = LI8 2048
  ; LE64-NEXT:   MTCTR8loop killed [[LI8_]], implicit-def dead $ctr8
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT: bb.1.for.body:
  ; LE64-NEXT:   successors: %bb.1(0x7c000000), %bb.2(0x04000000)
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT:   [[ADDIStocHA8_:%[0-9]+]]:g8rc_and_g8rc_nox0 = ADDIStocHA8 $x2, @a
  ; LE64-NEXT:   [[LDtocL:%[0-9]+]]:g8rc_and_g8rc_nox0 = LDtocL @a, killed [[ADDIStocHA8_]] :: (load (s64) from got)
  ; LE64-NEXT:   [[LWZ:%[0-9]+]]:gprc = LWZ 0, [[LDtocL]] :: (volatile dereferenceable load (s32) from @a)
  ; LE64-NEXT:   [[ADD4_:%[0-9]+]]:gprc = nsw ADD4 killed [[LWZ]], [[COPY1]]
  ; LE64-NEXT:   STW killed [[ADD4_]], 0, [[LDtocL]] :: (volatile store (s32) into @a)
  ; LE64-NEXT:   [[DecreaseCTR8loop:%[0-9]+]]:crbitrc = DecreaseCTR8loop 1, implicit-def dead $ctr8, implicit $ctr8
  ; LE64-NEXT:   BC killed [[DecreaseCTR8loop]], %bb.1
  ; LE64-NEXT:   B %bb.2
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT: bb.2.for.end:
  ; LE64-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %i.01 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %0 = load volatile i32, ptr @a, align 4
  %add = add nsw i32 %0, %c
  store volatile i32 %add, ptr @a, align 4
  %inc = add nsw i32 %i.01, 1
  %exitcond = icmp eq i32 %inc, 2048
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body
  ret void
}

define void @test2(i32 %c, i32 %d) nounwind {
  ; AIX64-LABEL: name: test2
  ; AIX64: bb.0.entry:
  ; AIX64-NEXT:   successors: %bb.1(0x50000000), %bb.3(0x30000000)
  ; AIX64-NEXT:   liveins: $x3, $x4
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT:   [[COPY:%[0-9]+]]:g8rc = COPY $x4
  ; AIX64-NEXT:   [[COPY1:%[0-9]+]]:g8rc = COPY $x3
  ; AIX64-NEXT:   [[COPY2:%[0-9]+]]:gprc = COPY [[COPY1]].sub_32
  ; AIX64-NEXT:   [[COPY3:%[0-9]+]]:gprc_and_gprc_nor0 = COPY [[COPY]].sub_32
  ; AIX64-NEXT:   [[CMPWI:%[0-9]+]]:crrc = CMPWI [[COPY3]], 1
  ; AIX64-NEXT:   BCC 12, killed [[CMPWI]], %bb.3
  ; AIX64-NEXT:   B %bb.1
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT: bb.1.for.body.preheader:
  ; AIX64-NEXT:   successors: %bb.2(0x80000000)
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT:   [[ADDI:%[0-9]+]]:gprc = ADDI [[COPY3]], -1
  ; AIX64-NEXT:   [[DEF:%[0-9]+]]:g8rc = IMPLICIT_DEF
  ; AIX64-NEXT:   [[INSERT_SUBREG:%[0-9]+]]:g8rc = INSERT_SUBREG [[DEF]], killed [[ADDI]], %subreg.sub_32
  ; AIX64-NEXT:   [[RLDICL:%[0-9]+]]:g8rc_and_g8rc_nox0 = RLDICL killed [[INSERT_SUBREG]], 0, 32
  ; AIX64-NEXT:   [[ADDI8_:%[0-9]+]]:g8rc = nuw nsw ADDI8 killed [[RLDICL]], 1
  ; AIX64-NEXT:   MTCTR8loop killed [[ADDI8_]], implicit-def dead $ctr8
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT: bb.2.for.body:
  ; AIX64-NEXT:   successors: %bb.2(0x7c000000), %bb.3(0x04000000)
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT:   [[LDtoc:%[0-9]+]]:g8rc_and_g8rc_nox0 = LDtoc @a, $x2 :: (load (s64) from got)
  ; AIX64-NEXT:   [[LWZ:%[0-9]+]]:gprc = LWZ 0, [[LDtoc]] :: (volatile dereferenceable load (s32) from @a)
  ; AIX64-NEXT:   [[ADD4_:%[0-9]+]]:gprc = nsw ADD4 killed [[LWZ]], [[COPY2]]
  ; AIX64-NEXT:   STW killed [[ADD4_]], 0, [[LDtoc]] :: (volatile store (s32) into @a)
  ; AIX64-NEXT:   [[DecreaseCTR8loop:%[0-9]+]]:crbitrc = DecreaseCTR8loop 1, implicit-def dead $ctr8, implicit $ctr8
  ; AIX64-NEXT:   BC killed [[DecreaseCTR8loop]], %bb.2
  ; AIX64-NEXT:   B %bb.3
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT: bb.3.for.end:
  ; AIX64-NEXT:   BLR8 implicit $lr8, implicit $rm
  ; AIX32-LABEL: name: test2
  ; AIX32: bb.0.entry:
  ; AIX32-NEXT:   successors: %bb.1(0x50000000), %bb.3(0x30000000)
  ; AIX32-NEXT:   liveins: $r3, $r4
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT:   [[COPY:%[0-9]+]]:gprc = COPY $r4
  ; AIX32-NEXT:   [[COPY1:%[0-9]+]]:gprc = COPY $r3
  ; AIX32-NEXT:   [[CMPWI:%[0-9]+]]:crrc = CMPWI [[COPY]], 1
  ; AIX32-NEXT:   BCC 12, killed [[CMPWI]], %bb.3
  ; AIX32-NEXT:   B %bb.1
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT: bb.1.for.body.preheader:
  ; AIX32-NEXT:   successors: %bb.2(0x80000000)
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT:   MTCTRloop [[COPY]], implicit-def dead $ctr
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT: bb.2.for.body:
  ; AIX32-NEXT:   successors: %bb.2(0x7c000000), %bb.3(0x04000000)
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT:   [[LWZtoc:%[0-9]+]]:gprc_and_gprc_nor0 = LWZtoc @a, $r2 :: (load (s32) from got)
  ; AIX32-NEXT:   [[LWZ:%[0-9]+]]:gprc = LWZ 0, [[LWZtoc]] :: (volatile dereferenceable load (s32) from @a)
  ; AIX32-NEXT:   [[ADD4_:%[0-9]+]]:gprc = nsw ADD4 killed [[LWZ]], [[COPY1]]
  ; AIX32-NEXT:   STW killed [[ADD4_]], 0, [[LWZtoc]] :: (volatile store (s32) into @a)
  ; AIX32-NEXT:   [[DecreaseCTRloop:%[0-9]+]]:crbitrc = DecreaseCTRloop 1, implicit-def dead $ctr, implicit $ctr
  ; AIX32-NEXT:   BC killed [[DecreaseCTRloop]], %bb.2
  ; AIX32-NEXT:   B %bb.3
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT: bb.3.for.end:
  ; AIX32-NEXT:   BLR implicit $lr, implicit $rm
  ; LE64-LABEL: name: test2
  ; LE64: bb.0.entry:
  ; LE64-NEXT:   successors: %bb.1(0x50000000), %bb.3(0x30000000)
  ; LE64-NEXT:   liveins: $x3, $x4
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT:   [[COPY:%[0-9]+]]:g8rc = COPY $x4
  ; LE64-NEXT:   [[COPY1:%[0-9]+]]:g8rc = COPY $x3
  ; LE64-NEXT:   [[COPY2:%[0-9]+]]:gprc = COPY [[COPY1]].sub_32
  ; LE64-NEXT:   [[COPY3:%[0-9]+]]:gprc_and_gprc_nor0 = COPY [[COPY]].sub_32
  ; LE64-NEXT:   [[CMPWI:%[0-9]+]]:crrc = CMPWI [[COPY3]], 1
  ; LE64-NEXT:   BCC 12, killed [[CMPWI]], %bb.3
  ; LE64-NEXT:   B %bb.1
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT: bb.1.for.body.preheader:
  ; LE64-NEXT:   successors: %bb.2(0x80000000)
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT:   [[ADDI:%[0-9]+]]:gprc = ADDI [[COPY3]], -1
  ; LE64-NEXT:   [[DEF:%[0-9]+]]:g8rc = IMPLICIT_DEF
  ; LE64-NEXT:   [[INSERT_SUBREG:%[0-9]+]]:g8rc = INSERT_SUBREG [[DEF]], killed [[ADDI]], %subreg.sub_32
  ; LE64-NEXT:   [[RLDICL:%[0-9]+]]:g8rc_and_g8rc_nox0 = RLDICL killed [[INSERT_SUBREG]], 0, 32
  ; LE64-NEXT:   [[ADDI8_:%[0-9]+]]:g8rc = nuw nsw ADDI8 killed [[RLDICL]], 1
  ; LE64-NEXT:   MTCTR8loop killed [[ADDI8_]], implicit-def dead $ctr8
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT: bb.2.for.body:
  ; LE64-NEXT:   successors: %bb.2(0x7c000000), %bb.3(0x04000000)
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT:   [[ADDIStocHA8_:%[0-9]+]]:g8rc_and_g8rc_nox0 = ADDIStocHA8 $x2, @a
  ; LE64-NEXT:   [[LDtocL:%[0-9]+]]:g8rc_and_g8rc_nox0 = LDtocL @a, killed [[ADDIStocHA8_]] :: (load (s64) from got)
  ; LE64-NEXT:   [[LWZ:%[0-9]+]]:gprc = LWZ 0, [[LDtocL]] :: (volatile dereferenceable load (s32) from @a)
  ; LE64-NEXT:   [[ADD4_:%[0-9]+]]:gprc = nsw ADD4 killed [[LWZ]], [[COPY2]]
  ; LE64-NEXT:   STW killed [[ADD4_]], 0, [[LDtocL]] :: (volatile store (s32) into @a)
  ; LE64-NEXT:   [[DecreaseCTR8loop:%[0-9]+]]:crbitrc = DecreaseCTR8loop 1, implicit-def dead $ctr8, implicit $ctr8
  ; LE64-NEXT:   BC killed [[DecreaseCTR8loop]], %bb.2
  ; LE64-NEXT:   B %bb.3
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT: bb.3.for.end:
  ; LE64-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %cmp1 = icmp sgt i32 %d, 0
  br i1 %cmp1, label %for.body, label %for.end

for.body:                                         ; preds = %entry, %for.body
  %i.02 = phi i32 [ %inc, %for.body ], [ 0, %entry ]
  %0 = load volatile i32, ptr @a, align 4
  %add = add nsw i32 %0, %c
  store volatile i32 %add, ptr @a, align 4
  %inc = add nsw i32 %i.02, 1
  %exitcond = icmp eq i32 %inc, %d
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body, %entry
  ret void
}

define void @test3(i32 %c, i32 %d) nounwind {
  ; AIX64-LABEL: name: test3
  ; AIX64: bb.0.entry:
  ; AIX64-NEXT:   successors: %bb.1(0x50000000), %bb.3(0x30000000)
  ; AIX64-NEXT:   liveins: $x3, $x4
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT:   [[COPY:%[0-9]+]]:g8rc = COPY $x4
  ; AIX64-NEXT:   [[COPY1:%[0-9]+]]:g8rc = COPY $x3
  ; AIX64-NEXT:   [[COPY2:%[0-9]+]]:gprc = COPY [[COPY1]].sub_32
  ; AIX64-NEXT:   [[COPY3:%[0-9]+]]:gprc_and_gprc_nor0 = COPY [[COPY]].sub_32
  ; AIX64-NEXT:   [[CMPWI:%[0-9]+]]:crrc = CMPWI [[COPY3]], 1
  ; AIX64-NEXT:   BCC 12, killed [[CMPWI]], %bb.3
  ; AIX64-NEXT:   B %bb.1
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT: bb.1.for.body.preheader:
  ; AIX64-NEXT:   successors: %bb.2(0x80000000)
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT:   [[ADDI:%[0-9]+]]:gprc = ADDI [[COPY3]], -1
  ; AIX64-NEXT:   [[DEF:%[0-9]+]]:g8rc = IMPLICIT_DEF
  ; AIX64-NEXT:   [[INSERT_SUBREG:%[0-9]+]]:g8rc = INSERT_SUBREG [[DEF]], killed [[ADDI]], %subreg.sub_32
  ; AIX64-NEXT:   [[RLDICL:%[0-9]+]]:g8rc_and_g8rc_nox0 = RLDICL killed [[INSERT_SUBREG]], 0, 32
  ; AIX64-NEXT:   [[ADDI8_:%[0-9]+]]:g8rc = nuw nsw ADDI8 killed [[RLDICL]], 1
  ; AIX64-NEXT:   MTCTR8loop killed [[ADDI8_]], implicit-def dead $ctr8
  ; AIX64-NEXT:   [[LI:%[0-9]+]]:gprc = LI 0
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT: bb.2.for.body:
  ; AIX64-NEXT:   successors: %bb.2(0x7c000000), %bb.3(0x04000000)
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT:   [[PHI:%[0-9]+]]:gprc = PHI [[LI]], %bb.1, %1, %bb.2
  ; AIX64-NEXT:   [[LDtoc:%[0-9]+]]:g8rc_and_g8rc_nox0 = LDtoc @a, $x2 :: (load (s64) from got)
  ; AIX64-NEXT:   [[LWZ:%[0-9]+]]:gprc = LWZ 0, [[LDtoc]] :: (volatile dereferenceable load (s32) from @a)
  ; AIX64-NEXT:   [[ADD4_:%[0-9]+]]:gprc = ADD4 [[PHI]], killed [[LWZ]]
  ; AIX64-NEXT:   STW killed [[ADD4_]], 0, [[LDtoc]] :: (volatile store (s32) into @a)
  ; AIX64-NEXT:   [[ADD4_1:%[0-9]+]]:gprc = ADD4 [[PHI]], [[COPY2]]
  ; AIX64-NEXT:   [[DecreaseCTR8loop:%[0-9]+]]:crbitrc = DecreaseCTR8loop 1, implicit-def dead $ctr8, implicit $ctr8
  ; AIX64-NEXT:   BC killed [[DecreaseCTR8loop]], %bb.2
  ; AIX64-NEXT:   B %bb.3
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT: bb.3.for.end:
  ; AIX64-NEXT:   BLR8 implicit $lr8, implicit $rm
  ; AIX32-LABEL: name: test3
  ; AIX32: bb.0.entry:
  ; AIX32-NEXT:   successors: %bb.1(0x50000000), %bb.3(0x30000000)
  ; AIX32-NEXT:   liveins: $r3, $r4
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT:   [[COPY:%[0-9]+]]:gprc = COPY $r4
  ; AIX32-NEXT:   [[COPY1:%[0-9]+]]:gprc = COPY $r3
  ; AIX32-NEXT:   [[CMPWI:%[0-9]+]]:crrc = CMPWI [[COPY]], 1
  ; AIX32-NEXT:   BCC 12, killed [[CMPWI]], %bb.3
  ; AIX32-NEXT:   B %bb.1
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT: bb.1.for.body.preheader:
  ; AIX32-NEXT:   successors: %bb.2(0x80000000)
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT:   MTCTRloop [[COPY]], implicit-def dead $ctr
  ; AIX32-NEXT:   [[LI:%[0-9]+]]:gprc = LI 0
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT: bb.2.for.body:
  ; AIX32-NEXT:   successors: %bb.2(0x7c000000), %bb.3(0x04000000)
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT:   [[PHI:%[0-9]+]]:gprc = PHI [[LI]], %bb.1, %1, %bb.2
  ; AIX32-NEXT:   [[LWZtoc:%[0-9]+]]:gprc_and_gprc_nor0 = LWZtoc @a, $r2 :: (load (s32) from got)
  ; AIX32-NEXT:   [[LWZ:%[0-9]+]]:gprc = LWZ 0, [[LWZtoc]] :: (volatile dereferenceable load (s32) from @a)
  ; AIX32-NEXT:   [[ADD4_:%[0-9]+]]:gprc = ADD4 [[PHI]], killed [[LWZ]]
  ; AIX32-NEXT:   STW killed [[ADD4_]], 0, [[LWZtoc]] :: (volatile store (s32) into @a)
  ; AIX32-NEXT:   [[ADD4_1:%[0-9]+]]:gprc = ADD4 [[PHI]], [[COPY1]]
  ; AIX32-NEXT:   [[DecreaseCTRloop:%[0-9]+]]:crbitrc = DecreaseCTRloop 1, implicit-def dead $ctr, implicit $ctr
  ; AIX32-NEXT:   BC killed [[DecreaseCTRloop]], %bb.2
  ; AIX32-NEXT:   B %bb.3
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT: bb.3.for.end:
  ; AIX32-NEXT:   BLR implicit $lr, implicit $rm
  ; LE64-LABEL: name: test3
  ; LE64: bb.0.entry:
  ; LE64-NEXT:   successors: %bb.1(0x50000000), %bb.3(0x30000000)
  ; LE64-NEXT:   liveins: $x3, $x4
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT:   [[COPY:%[0-9]+]]:g8rc = COPY $x4
  ; LE64-NEXT:   [[COPY1:%[0-9]+]]:g8rc = COPY $x3
  ; LE64-NEXT:   [[COPY2:%[0-9]+]]:gprc = COPY [[COPY1]].sub_32
  ; LE64-NEXT:   [[COPY3:%[0-9]+]]:gprc_and_gprc_nor0 = COPY [[COPY]].sub_32
  ; LE64-NEXT:   [[CMPWI:%[0-9]+]]:crrc = CMPWI [[COPY3]], 1
  ; LE64-NEXT:   BCC 12, killed [[CMPWI]], %bb.3
  ; LE64-NEXT:   B %bb.1
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT: bb.1.for.body.preheader:
  ; LE64-NEXT:   successors: %bb.2(0x80000000)
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT:   [[ADDI:%[0-9]+]]:gprc = ADDI [[COPY3]], -1
  ; LE64-NEXT:   [[DEF:%[0-9]+]]:g8rc = IMPLICIT_DEF
  ; LE64-NEXT:   [[INSERT_SUBREG:%[0-9]+]]:g8rc = INSERT_SUBREG [[DEF]], killed [[ADDI]], %subreg.sub_32
  ; LE64-NEXT:   [[RLDICL:%[0-9]+]]:g8rc_and_g8rc_nox0 = RLDICL killed [[INSERT_SUBREG]], 0, 32
  ; LE64-NEXT:   [[ADDI8_:%[0-9]+]]:g8rc = nuw nsw ADDI8 killed [[RLDICL]], 1
  ; LE64-NEXT:   MTCTR8loop killed [[ADDI8_]], implicit-def dead $ctr8
  ; LE64-NEXT:   [[LI:%[0-9]+]]:gprc = LI 0
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT: bb.2.for.body:
  ; LE64-NEXT:   successors: %bb.2(0x7c000000), %bb.3(0x04000000)
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT:   [[PHI:%[0-9]+]]:gprc = PHI [[LI]], %bb.1, %1, %bb.2
  ; LE64-NEXT:   [[ADDIStocHA8_:%[0-9]+]]:g8rc_and_g8rc_nox0 = ADDIStocHA8 $x2, @a
  ; LE64-NEXT:   [[LDtocL:%[0-9]+]]:g8rc_and_g8rc_nox0 = LDtocL @a, killed [[ADDIStocHA8_]] :: (load (s64) from got)
  ; LE64-NEXT:   [[LWZ:%[0-9]+]]:gprc = LWZ 0, [[LDtocL]] :: (volatile dereferenceable load (s32) from @a)
  ; LE64-NEXT:   [[ADD4_:%[0-9]+]]:gprc = ADD4 [[PHI]], killed [[LWZ]]
  ; LE64-NEXT:   STW killed [[ADD4_]], 0, [[LDtocL]] :: (volatile store (s32) into @a)
  ; LE64-NEXT:   [[ADD4_1:%[0-9]+]]:gprc = ADD4 [[PHI]], [[COPY2]]
  ; LE64-NEXT:   [[DecreaseCTR8loop:%[0-9]+]]:crbitrc = DecreaseCTR8loop 1, implicit-def dead $ctr8, implicit $ctr8
  ; LE64-NEXT:   BC killed [[DecreaseCTR8loop]], %bb.2
  ; LE64-NEXT:   B %bb.3
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT: bb.3.for.end:
  ; LE64-NEXT:   BLR8 implicit $lr8, implicit $rm
entry:
  %cmp1 = icmp sgt i32 %d, 0
  br i1 %cmp1, label %for.body, label %for.end

for.body:                                         ; preds = %entry, %for.body
  %i.02 = phi i32 [ %inc, %for.body ], [ 0, %entry ]
  %mul = mul nsw i32 %i.02, %c
  %0 = load volatile i32, ptr @a, align 4
  %add = add nsw i32 %0, %mul
  store volatile i32 %add, ptr @a, align 4
  %inc = add nsw i32 %i.02, 1
  %exitcond = icmp eq i32 %inc, %d
  br i1 %exitcond, label %for.end, label %for.body

for.end:                                          ; preds = %for.body, %entry
  ret void
}

@tls_var = external thread_local global i8

define i32 @test4(i32 %inp) {
  ; AIX64-LABEL: name: test4
  ; AIX64: bb.0.entry:
  ; AIX64-NEXT:   successors: %bb.1(0x80000000)
  ; AIX64-NEXT:   liveins: $x3
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT:   [[COPY:%[0-9]+]]:g8rc = COPY $x3
  ; AIX64-NEXT:   [[COPY1:%[0-9]+]]:gprc_and_gprc_nor0 = COPY [[COPY]].sub_32
  ; AIX64-NEXT:   [[CMPWI:%[0-9]+]]:crrc = CMPWI [[COPY1]], 1
  ; AIX64-NEXT:   [[LI:%[0-9]+]]:gprc_and_gprc_nor0 = LI 1
  ; AIX64-NEXT:   [[ISEL:%[0-9]+]]:gprc = ISEL [[COPY1]], [[LI]], [[CMPWI]].sub_lt
  ; AIX64-NEXT:   [[SUBF:%[0-9]+]]:gprc = SUBF [[ISEL]], [[COPY1]]
  ; AIX64-NEXT:   [[DEF:%[0-9]+]]:g8rc = IMPLICIT_DEF
  ; AIX64-NEXT:   [[INSERT_SUBREG:%[0-9]+]]:g8rc = INSERT_SUBREG [[DEF]], killed [[SUBF]], %subreg.sub_32
  ; AIX64-NEXT:   [[RLDICL:%[0-9]+]]:g8rc_and_g8rc_nox0 = RLDICL killed [[INSERT_SUBREG]], 0, 32
  ; AIX64-NEXT:   [[ADDI8_:%[0-9]+]]:g8rc = nuw nsw ADDI8 killed [[RLDICL]], 1
  ; AIX64-NEXT:   MTCTR8loop killed [[ADDI8_]], implicit-def dead $ctr8
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT: bb.1.for.body:
  ; AIX64-NEXT:   successors: %bb.1(0x7c000000), %bb.2(0x04000000)
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT:   [[DecreaseCTR8loop:%[0-9]+]]:crbitrc = DecreaseCTR8loop 1, implicit-def dead $ctr8, implicit $ctr8
  ; AIX64-NEXT:   BC killed [[DecreaseCTR8loop]], %bb.1
  ; AIX64-NEXT:   B %bb.2
  ; AIX64-NEXT: {{  $}}
  ; AIX64-NEXT: bb.2.return:
  ; AIX64-NEXT:   [[LDtoc:%[0-9]+]]:g8rc = LDtoc target-flags(ppc-lo) @tls_var, $x2 :: (load (s64) from got)
  ; AIX64-NEXT:   [[LDtoc1:%[0-9]+]]:g8rc = LDtoc target-flags(ppc-tlsgd) @tls_var, $x2 :: (load (s64) from got)
  ; AIX64-NEXT:   [[TLSGDAIX8_:%[0-9]+]]:g8rc = TLSGDAIX8 killed [[LDtoc1]], killed [[LDtoc]]
  ; AIX64-NEXT:   [[COPY2:%[0-9]+]]:gprc = COPY [[TLSGDAIX8_]].sub_32
  ; AIX64-NEXT:   [[ADD4_:%[0-9]+]]:gprc = ADD4 killed [[COPY2]], [[ISEL]]
  ; AIX64-NEXT:   [[DEF1:%[0-9]+]]:g8rc = IMPLICIT_DEF
  ; AIX64-NEXT:   [[INSERT_SUBREG1:%[0-9]+]]:g8rc = INSERT_SUBREG [[DEF1]], killed [[ADD4_]], %subreg.sub_32
  ; AIX64-NEXT:   $x3 = COPY [[INSERT_SUBREG1]]
  ; AIX64-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
  ; AIX32-LABEL: name: test4
  ; AIX32: bb.0.entry:
  ; AIX32-NEXT:   successors: %bb.1(0x80000000)
  ; AIX32-NEXT:   liveins: $r3
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT:   [[COPY:%[0-9]+]]:gprc_and_gprc_nor0 = COPY $r3
  ; AIX32-NEXT:   [[CMPWI:%[0-9]+]]:crrc = CMPWI [[COPY]], 1
  ; AIX32-NEXT:   [[LI:%[0-9]+]]:gprc_and_gprc_nor0 = LI 1
  ; AIX32-NEXT:   [[ISEL:%[0-9]+]]:gprc = ISEL [[COPY]], [[LI]], [[CMPWI]].sub_lt
  ; AIX32-NEXT:   [[SUBF:%[0-9]+]]:gprc_and_gprc_nor0 = SUBF [[ISEL]], [[COPY]]
  ; AIX32-NEXT:   [[ADDI:%[0-9]+]]:gprc = ADDI killed [[SUBF]], 1
  ; AIX32-NEXT:   MTCTRloop killed [[ADDI]], implicit-def dead $ctr
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT: bb.1.for.body:
  ; AIX32-NEXT:   successors: %bb.1(0x7c000000), %bb.2(0x04000000)
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT:   [[DecreaseCTRloop:%[0-9]+]]:crbitrc = DecreaseCTRloop 1, implicit-def dead $ctr, implicit $ctr
  ; AIX32-NEXT:   BC killed [[DecreaseCTRloop]], %bb.1
  ; AIX32-NEXT:   B %bb.2
  ; AIX32-NEXT: {{  $}}
  ; AIX32-NEXT: bb.2.return:
  ; AIX32-NEXT:   [[LWZtoc:%[0-9]+]]:gprc = LWZtoc target-flags(ppc-lo) @tls_var, $r2 :: (load (s32) from got)
  ; AIX32-NEXT:   [[LWZtoc1:%[0-9]+]]:gprc = LWZtoc target-flags(ppc-tlsgd) @tls_var, $r2 :: (load (s32) from got)
  ; AIX32-NEXT:   [[TLSGDAIX:%[0-9]+]]:gprc = TLSGDAIX killed [[LWZtoc1]], killed [[LWZtoc]]
  ; AIX32-NEXT:   [[ADD4_:%[0-9]+]]:gprc = ADD4 killed [[TLSGDAIX]], [[ISEL]]
  ; AIX32-NEXT:   $r3 = COPY [[ADD4_]]
  ; AIX32-NEXT:   BLR implicit $lr, implicit $rm, implicit $r3
  ; LE64-LABEL: name: test4
  ; LE64: bb.0.entry:
  ; LE64-NEXT:   successors: %bb.1(0x80000000)
  ; LE64-NEXT:   liveins: $x3
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT:   [[COPY:%[0-9]+]]:g8rc = COPY $x3
  ; LE64-NEXT:   [[COPY1:%[0-9]+]]:gprc_and_gprc_nor0 = COPY [[COPY]].sub_32
  ; LE64-NEXT:   [[CMPWI:%[0-9]+]]:crrc = CMPWI [[COPY1]], 1
  ; LE64-NEXT:   [[LI:%[0-9]+]]:gprc_and_gprc_nor0 = LI 1
  ; LE64-NEXT:   [[ISEL:%[0-9]+]]:gprc = ISEL [[COPY1]], [[LI]], [[CMPWI]].sub_lt
  ; LE64-NEXT:   [[SUBF:%[0-9]+]]:gprc = SUBF [[ISEL]], [[COPY1]]
  ; LE64-NEXT:   [[DEF:%[0-9]+]]:g8rc = IMPLICIT_DEF
  ; LE64-NEXT:   [[INSERT_SUBREG:%[0-9]+]]:g8rc = INSERT_SUBREG [[DEF]], killed [[SUBF]], %subreg.sub_32
  ; LE64-NEXT:   [[RLDICL:%[0-9]+]]:g8rc_and_g8rc_nox0 = RLDICL killed [[INSERT_SUBREG]], 0, 32
  ; LE64-NEXT:   [[ADDI8_:%[0-9]+]]:g8rc = nuw nsw ADDI8 killed [[RLDICL]], 1
  ; LE64-NEXT:   MTCTR8loop killed [[ADDI8_]], implicit-def dead $ctr8
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT: bb.1.for.body:
  ; LE64-NEXT:   successors: %bb.1(0x7c000000), %bb.2(0x04000000)
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT:   [[DecreaseCTR8loop:%[0-9]+]]:crbitrc = DecreaseCTR8loop 1, implicit-def dead $ctr8, implicit $ctr8
  ; LE64-NEXT:   BC killed [[DecreaseCTR8loop]], %bb.1
  ; LE64-NEXT:   B %bb.2
  ; LE64-NEXT: {{  $}}
  ; LE64-NEXT: bb.2.return:
  ; LE64-NEXT:   [[ADDISgotTprelHA:%[0-9]+]]:g8rc_and_g8rc_nox0 = ADDISgotTprelHA $x2, @tls_var
  ; LE64-NEXT:   [[LDgotTprelL:%[0-9]+]]:g8rc_and_g8rc_nox0 = LDgotTprelL @tls_var, killed [[ADDISgotTprelHA]]
  ; LE64-NEXT:   [[ADD8TLS:%[0-9]+]]:g8rc = ADD8TLS killed [[LDgotTprelL]], target-flags(ppc-tls) @tls_var
  ; LE64-NEXT:   [[COPY2:%[0-9]+]]:gprc = COPY [[ADD8TLS]].sub_32
  ; LE64-NEXT:   [[ADD4_:%[0-9]+]]:gprc = ADD4 killed [[COPY2]], [[ISEL]]
  ; LE64-NEXT:   [[DEF1:%[0-9]+]]:g8rc = IMPLICIT_DEF
  ; LE64-NEXT:   [[INSERT_SUBREG1:%[0-9]+]]:g8rc = INSERT_SUBREG [[DEF1]], killed [[ADD4_]], %subreg.sub_32
  ; LE64-NEXT:   $x3 = COPY [[INSERT_SUBREG1]]
  ; LE64-NEXT:   BLR8 implicit $lr8, implicit $rm, implicit $x3
entry:
  br label %for.body

for.body:                                         ; preds = %for.body, %entry
  %phi = phi i32 [ %dec, %for.body ], [ %inp, %entry ]
  %load = ptrtoint ptr @tls_var to i32
  %val = add i32 %load, %phi
  %dec = add i32 %phi, -1
  %cmp = icmp sgt i32 %phi, 1
  br i1 %cmp, label %for.body, label %return

return:                                           ; preds = %for.body
  ret i32 %val
}
