; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+avx      | FileCheck %s --check-prefixes=AVX1
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+avx2     | FileCheck %s --check-prefixes=AVX2
; RUN: llc < %s -mtriple=x86_64-linux -mattr=+avx512vl | FileCheck %s --check-prefixes=AVX512

;
; trunc(abs(sub(sext(a),sext(b)))) -> abds(a,b)
;

define <32 x i8> @abd_ext_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; AVX1-LABEL: abd_ext_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm4, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm3, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm5, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxbq %xmm4, %xmm10
; AVX1-NEXT:    vpmovsxbw %xmm0, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm4[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm5, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm4, %xmm11
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm4
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm8
; AVX1-NEXT:    vpmovsxbq %xmm8, %xmm3
; AVX1-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm8 = xmm3[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm8, %xmm12
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm12[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpshufd {{.*#+}} xmm13 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm13, %xmm14
; AVX1-NEXT:    vpshufd {{.*#+}} xmm15 = xmm14[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm15, %xmm15
; AVX1-NEXT:    vpsubq %xmm15, %xmm6, %xmm0
; AVX1-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpshufd {{.*#+}} xmm15 = xmm14[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm15, %xmm15
; AVX1-NEXT:    vpsubq %xmm15, %xmm7, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm14, %xmm14
; AVX1-NEXT:    vpsubq %xmm14, %xmm2, %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpmovsxbq %xmm13, %xmm2
; AVX1-NEXT:    vpsubq %xmm2, %xmm10, %xmm6
; AVX1-NEXT:    vpmovsxbw %xmm1, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm13 = xmm2[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm13, %xmm13
; AVX1-NEXT:    vpsubq %xmm13, %xmm5, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm2, %xmm2
; AVX1-NEXT:    vpsubq %xmm2, %xmm11, %xmm11
; AVX1-NEXT:    vpmovsxbq %xmm1, %xmm2
; AVX1-NEXT:    vpsubq %xmm2, %xmm4, %xmm0
; AVX1-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpsrld $16, %xmm1, %xmm2
; AVX1-NEXT:    vpmovsxbq %xmm2, %xmm2
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpsubq %xmm2, %xmm0, %xmm10
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm1, %xmm13
; AVX1-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm14, %xmm14
; AVX1-NEXT:    vpsubq %xmm14, %xmm9, %xmm9
; AVX1-NEXT:    vpshufd {{.*#+}} xmm14 = xmm12[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm14, %xmm14
; AVX1-NEXT:    vpshufd {{.*#+}} xmm15 = xmm13[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm15, %xmm15
; AVX1-NEXT:    vpsubq %xmm15, %xmm14, %xmm15
; AVX1-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm12, %xmm12
; AVX1-NEXT:    vpmovsxbq %xmm8, %xmm14
; AVX1-NEXT:    vpshufd {{.*#+}} xmm8 = xmm13[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm8, %xmm8
; AVX1-NEXT:    vpsubq %xmm8, %xmm12, %xmm8
; AVX1-NEXT:    vpmovsxbw %xmm3, %xmm12
; AVX1-NEXT:    vpmovsxbq %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm14, %xmm14
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm12[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxbw %xmm2, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm13 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm13, %xmm13
; AVX1-NEXT:    vpsubq %xmm13, %xmm1, %xmm13
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm12[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm0
; AVX1-NEXT:    vpsubq %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxbq %xmm3, %xmm0
; AVX1-NEXT:    vpmovsxbq %xmm2, %xmm12
; AVX1-NEXT:    vpsubq %xmm12, %xmm0, %xmm12
; AVX1-NEXT:    vpsrld $16, %xmm3, %xmm0
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm0
; AVX1-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxbq %xmm2, %xmm2
; AVX1-NEXT:    vpsubq %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm4, %ymm3
; AVX1-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpsubq %xmm7, %xmm0, %xmm7
; AVX1-NEXT:    vpsubq %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm4, %ymm4
; AVX1-NEXT:    vblendvpd %ymm3, %ymm4, %ymm3, %ymm3
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm6, %ymm4
; AVX1-NEXT:    vpsubq %xmm6, %xmm0, %xmm6
; AVX1-NEXT:    vpsubq %xmm7, %xmm0, %xmm7
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm6, %ymm6
; AVX1-NEXT:    vblendvpd %ymm4, %ymm6, %ymm4, %ymm6
; AVX1-NEXT:    vinsertf128 $1, %xmm11, %ymm5, %ymm4
; AVX1-NEXT:    vpsubq %xmm11, %xmm0, %xmm7
; AVX1-NEXT:    vpsubq %xmm5, %xmm0, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm5, %ymm5
; AVX1-NEXT:    vblendvpd %ymm4, %ymm5, %ymm4, %ymm5
; AVX1-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX1-NEXT:    vinsertf128 $1, %xmm10, %ymm11, %ymm4
; AVX1-NEXT:    vpsubq %xmm10, %xmm0, %xmm7
; AVX1-NEXT:    vpsubq %xmm11, %xmm0, %xmm10
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm10, %ymm7
; AVX1-NEXT:    vblendvpd %ymm4, %ymm7, %ymm4, %ymm4
; AVX1-NEXT:    vinsertf128 $1, %xmm15, %ymm9, %ymm7
; AVX1-NEXT:    vpsubq %xmm15, %xmm0, %xmm10
; AVX1-NEXT:    vpsubq %xmm9, %xmm0, %xmm9
; AVX1-NEXT:    vinsertf128 $1, %xmm10, %ymm9, %ymm9
; AVX1-NEXT:    vblendvpd %ymm7, %ymm9, %ymm7, %ymm7
; AVX1-NEXT:    vinsertf128 $1, %xmm8, %ymm14, %ymm9
; AVX1-NEXT:    vpsubq %xmm14, %xmm0, %xmm10
; AVX1-NEXT:    vpsubq %xmm8, %xmm0, %xmm8
; AVX1-NEXT:    vinsertf128 $1, %xmm8, %ymm10, %ymm8
; AVX1-NEXT:    vblendvpd %ymm9, %ymm8, %ymm9, %ymm8
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm13, %ymm9
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsubq %xmm13, %xmm0, %xmm10
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm10, %ymm1
; AVX1-NEXT:    vblendvpd %ymm9, %ymm1, %ymm9, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm12, %ymm9
; AVX1-NEXT:    vpsubq %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpsubq %xmm12, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vblendvpd %ymm9, %ymm0, %ymm9, %ymm2
; AVX1-NEXT:    vmovapd {{.*#+}} ymm0 = [255,255,255,255]
; AVX1-NEXT:    vandpd %ymm0, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm9
; AVX1-NEXT:    vpackusdw %xmm9, %xmm2, %xmm2
; AVX1-NEXT:    vandpd %ymm0, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm9
; AVX1-NEXT:    vpackusdw %xmm9, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vandpd %ymm0, %ymm8, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm8
; AVX1-NEXT:    vpackusdw %xmm8, %xmm2, %xmm2
; AVX1-NEXT:    vandpd %ymm0, %ymm7, %ymm7
; AVX1-NEXT:    vextractf128 $1, %ymm7, %xmm8
; AVX1-NEXT:    vpackusdw %xmm8, %xmm7, %xmm7
; AVX1-NEXT:    vpackusdw %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpackuswb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vandpd %ymm0, %ymm4, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vpackusdw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vandpd %ymm0, %ymm5, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpackusdw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vandpd %ymm0, %ymm6, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vandpd %ymm0, %ymm3, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbw %xmm0, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm3, %ymm3
; AVX2-NEXT:    vpmovsxbq %xmm0, %ymm4
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm5, %ymm5
; AVX2-NEXT:    vpmovsxwq %xmm2, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vpmovsxbw %xmm0, %ymm6
; AVX2-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm7, %ymm7
; AVX2-NEXT:    vpmovsxbq %xmm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX2-NEXT:    vpshufd {{.*#+}} xmm8 = xmm6[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm8, %ymm8
; AVX2-NEXT:    vpmovsxwq %xmm6, %ymm6
; AVX2-NEXT:    vpmovsxbw %xmm1, %ymm9
; AVX2-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm10, %ymm10
; AVX2-NEXT:    vpsubq %ymm10, %ymm3, %ymm3
; AVX2-NEXT:    vpmovsxbq %xmm1, %ymm10
; AVX2-NEXT:    vpsubq %ymm10, %ymm4, %ymm4
; AVX2-NEXT:    vextracti128 $1, %ymm9, %xmm9
; AVX2-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm10, %ymm10
; AVX2-NEXT:    vpsubq %ymm10, %ymm5, %ymm5
; AVX2-NEXT:    vpmovsxwq %xmm9, %ymm9
; AVX2-NEXT:    vpsubq %ymm9, %ymm2, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-NEXT:    vpmovsxbw %xmm1, %ymm9
; AVX2-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm10, %ymm10
; AVX2-NEXT:    vpsubq %ymm10, %ymm7, %ymm7
; AVX2-NEXT:    vpmovsxbq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm9, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm9, %ymm9
; AVX2-NEXT:    vpsubq %ymm9, %ymm8, %ymm8
; AVX2-NEXT:    vpmovsxwq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm6, %ymm1
; AVX2-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX2-NEXT:    vpsubq %ymm3, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm3, %ymm9, %ymm3, %ymm3
; AVX2-NEXT:    vpsubq %ymm4, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm4, %ymm9, %ymm4, %ymm4
; AVX2-NEXT:    vpsubq %ymm5, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm5, %ymm9, %ymm5, %ymm5
; AVX2-NEXT:    vpsubq %ymm2, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm2, %ymm9, %ymm2, %ymm2
; AVX2-NEXT:    vpsubq %ymm7, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm7, %ymm9, %ymm7, %ymm7
; AVX2-NEXT:    vpsubq %ymm0, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm0, %ymm9, %ymm0, %ymm0
; AVX2-NEXT:    vpsubq %ymm8, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm8, %ymm9, %ymm8, %ymm8
; AVX2-NEXT:    vpsubq %ymm1, %ymm6, %ymm6
; AVX2-NEXT:    vblendvpd %ymm1, %ymm6, %ymm1, %ymm1
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [255,255,255,255]
; AVX2-NEXT:    vandpd %ymm6, %ymm1, %ymm1
; AVX2-NEXT:    vandpd %ymm6, %ymm8, %ymm8
; AVX2-NEXT:    vpackusdw %ymm8, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vandpd %ymm6, %ymm0, %ymm0
; AVX2-NEXT:    vandpd %ymm6, %ymm7, %ymm7
; AVX2-NEXT:    vpackusdw %ymm7, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vandpd %ymm6, %ymm2, %ymm1
; AVX2-NEXT:    vandpd %ymm6, %ymm5, %ymm2
; AVX2-NEXT:    vpackusdw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vandpd %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vandpd %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpackusdw %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-NEXT:    vpackusdw %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vpackuswb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbw %xmm0, %ymm2
; AVX512-NEXT:    vpmovsxwq %xmm2, %zmm3
; AVX512-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512-NEXT:    vpmovsxwq %xmm2, %zmm2
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpmovsxbw %xmm0, %ymm0
; AVX512-NEXT:    vpmovsxwq %xmm0, %zmm4
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512-NEXT:    vpmovsxbw %xmm1, %ymm5
; AVX512-NEXT:    vpmovsxwq %xmm5, %zmm6
; AVX512-NEXT:    vpsubq %zmm6, %zmm3, %zmm3
; AVX512-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX512-NEXT:    vpmovsxwq %xmm5, %zmm5
; AVX512-NEXT:    vpsubq %zmm5, %zmm2, %zmm2
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-NEXT:    vpmovsxbw %xmm1, %ymm1
; AVX512-NEXT:    vpmovsxwq %xmm1, %zmm5
; AVX512-NEXT:    vpsubq %zmm5, %zmm4, %zmm4
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm3, %zmm1
; AVX512-NEXT:    vpabsq %zmm2, %zmm2
; AVX512-NEXT:    vpabsq %zmm4, %zmm3
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpmovqb %zmm3, %xmm3
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm3[0],xmm0[0]
; AVX512-NEXT:    vpmovqb %zmm2, %xmm2
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    retq
  %aext = sext <32 x i8> %a to <32 x i64>
  %bext = sext <32 x i8> %b to <32 x i64>
  %sub = sub <32 x i64> %aext, %bext
  %abs = call <32 x i64> @llvm.abs.v32i64(<32 x i64> %sub, i1 false)
  %trunc = trunc <32 x i64> %abs to <32 x i8>
  ret <32 x i8> %trunc
}

define <32 x i8> @abd_ext_v32i8_undef(<32 x i8> %a, <32 x i8> %b) nounwind {
; AVX1-LABEL: abd_ext_v32i8_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm4, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm3, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm5, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxbq %xmm4, %xmm10
; AVX1-NEXT:    vpmovsxbw %xmm0, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm4[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm5, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm4 = xmm4[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm4, %xmm11
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm4
; AVX1-NEXT:    vpsrld $16, %xmm0, %xmm8
; AVX1-NEXT:    vpmovsxbq %xmm8, %xmm3
; AVX1-NEXT:    vmovdqa %xmm3, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm8 = xmm3[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm8, %xmm12
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm12[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpshufd {{.*#+}} xmm13 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm13, %xmm14
; AVX1-NEXT:    vpshufd {{.*#+}} xmm15 = xmm14[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm15, %xmm15
; AVX1-NEXT:    vpsubq %xmm15, %xmm6, %xmm0
; AVX1-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpshufd {{.*#+}} xmm15 = xmm14[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm15, %xmm15
; AVX1-NEXT:    vpsubq %xmm15, %xmm7, %xmm7
; AVX1-NEXT:    vpshufd {{.*#+}} xmm14 = xmm14[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm14, %xmm14
; AVX1-NEXT:    vpsubq %xmm14, %xmm2, %xmm0
; AVX1-NEXT:    vmovdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; AVX1-NEXT:    vpmovsxbq %xmm13, %xmm2
; AVX1-NEXT:    vpsubq %xmm2, %xmm10, %xmm6
; AVX1-NEXT:    vpmovsxbw %xmm1, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm13 = xmm2[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm13, %xmm13
; AVX1-NEXT:    vpsubq %xmm13, %xmm5, %xmm5
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm2, %xmm2
; AVX1-NEXT:    vpsubq %xmm2, %xmm11, %xmm11
; AVX1-NEXT:    vpmovsxbq %xmm1, %xmm2
; AVX1-NEXT:    vpsubq %xmm2, %xmm4, %xmm0
; AVX1-NEXT:    vmovdqu %ymm0, {{[-0-9]+}}(%r{{[sb]}}p) # 32-byte Spill
; AVX1-NEXT:    vpsrld $16, %xmm1, %xmm2
; AVX1-NEXT:    vpmovsxbq %xmm2, %xmm2
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; AVX1-NEXT:    vpsubq %xmm2, %xmm0, %xmm10
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm2[2,3,2,3]
; AVX1-NEXT:    vpmovsxbw %xmm1, %xmm13
; AVX1-NEXT:    vpshufd {{.*#+}} xmm14 = xmm13[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm14, %xmm14
; AVX1-NEXT:    vpsubq %xmm14, %xmm9, %xmm9
; AVX1-NEXT:    vpshufd {{.*#+}} xmm14 = xmm12[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm14, %xmm14
; AVX1-NEXT:    vpshufd {{.*#+}} xmm15 = xmm13[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm15, %xmm15
; AVX1-NEXT:    vpsubq %xmm15, %xmm14, %xmm15
; AVX1-NEXT:    vpshufd {{.*#+}} xmm12 = xmm12[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm12, %xmm12
; AVX1-NEXT:    vpmovsxbq %xmm8, %xmm14
; AVX1-NEXT:    vpshufd {{.*#+}} xmm8 = xmm13[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm8, %xmm8
; AVX1-NEXT:    vpsubq %xmm8, %xmm12, %xmm8
; AVX1-NEXT:    vpmovsxbw %xmm3, %xmm12
; AVX1-NEXT:    vpmovsxbq %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm14, %xmm14
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm12[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxbw %xmm2, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm13 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm13, %xmm13
; AVX1-NEXT:    vpsubq %xmm13, %xmm1, %xmm13
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm12[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm0
; AVX1-NEXT:    vpsubq %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vpmovsxbq %xmm3, %xmm0
; AVX1-NEXT:    vpmovsxbq %xmm2, %xmm12
; AVX1-NEXT:    vpsubq %xmm12, %xmm0, %xmm12
; AVX1-NEXT:    vpsrld $16, %xmm3, %xmm0
; AVX1-NEXT:    vpmovsxbq %xmm0, %xmm0
; AVX1-NEXT:    vpsrld $16, %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxbq %xmm2, %xmm2
; AVX1-NEXT:    vpsubq %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm4 # 32-byte Reload
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm4, %ymm3
; AVX1-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpsubq %xmm7, %xmm0, %xmm7
; AVX1-NEXT:    vpsubq %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm4, %ymm4
; AVX1-NEXT:    vblendvpd %ymm3, %ymm4, %ymm3, %ymm3
; AVX1-NEXT:    vmovdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm7 # 16-byte Reload
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm6, %ymm4
; AVX1-NEXT:    vpsubq %xmm6, %xmm0, %xmm6
; AVX1-NEXT:    vpsubq %xmm7, %xmm0, %xmm7
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm6, %ymm6
; AVX1-NEXT:    vblendvpd %ymm4, %ymm6, %ymm4, %ymm6
; AVX1-NEXT:    vinsertf128 $1, %xmm11, %ymm5, %ymm4
; AVX1-NEXT:    vpsubq %xmm11, %xmm0, %xmm7
; AVX1-NEXT:    vpsubq %xmm5, %xmm0, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm5, %ymm5
; AVX1-NEXT:    vblendvpd %ymm4, %ymm5, %ymm4, %ymm5
; AVX1-NEXT:    vmovdqu {{[-0-9]+}}(%r{{[sb]}}p), %ymm11 # 32-byte Reload
; AVX1-NEXT:    vinsertf128 $1, %xmm10, %ymm11, %ymm4
; AVX1-NEXT:    vpsubq %xmm10, %xmm0, %xmm7
; AVX1-NEXT:    vpsubq %xmm11, %xmm0, %xmm10
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm10, %ymm7
; AVX1-NEXT:    vblendvpd %ymm4, %ymm7, %ymm4, %ymm4
; AVX1-NEXT:    vinsertf128 $1, %xmm15, %ymm9, %ymm7
; AVX1-NEXT:    vpsubq %xmm15, %xmm0, %xmm10
; AVX1-NEXT:    vpsubq %xmm9, %xmm0, %xmm9
; AVX1-NEXT:    vinsertf128 $1, %xmm10, %ymm9, %ymm9
; AVX1-NEXT:    vblendvpd %ymm7, %ymm9, %ymm7, %ymm7
; AVX1-NEXT:    vinsertf128 $1, %xmm8, %ymm14, %ymm9
; AVX1-NEXT:    vpsubq %xmm14, %xmm0, %xmm10
; AVX1-NEXT:    vpsubq %xmm8, %xmm0, %xmm8
; AVX1-NEXT:    vinsertf128 $1, %xmm8, %ymm10, %ymm8
; AVX1-NEXT:    vblendvpd %ymm9, %ymm8, %ymm9, %ymm8
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm13, %ymm9
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpsubq %xmm13, %xmm0, %xmm10
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm10, %ymm1
; AVX1-NEXT:    vblendvpd %ymm9, %ymm1, %ymm9, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm12, %ymm9
; AVX1-NEXT:    vpsubq %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpsubq %xmm12, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vblendvpd %ymm9, %ymm0, %ymm9, %ymm2
; AVX1-NEXT:    vmovapd {{.*#+}} ymm0 = [255,255,255,255]
; AVX1-NEXT:    vandpd %ymm0, %ymm2, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm9
; AVX1-NEXT:    vpackusdw %xmm9, %xmm2, %xmm2
; AVX1-NEXT:    vandpd %ymm0, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm9
; AVX1-NEXT:    vpackusdw %xmm9, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vandpd %ymm0, %ymm8, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm8
; AVX1-NEXT:    vpackusdw %xmm8, %xmm2, %xmm2
; AVX1-NEXT:    vandpd %ymm0, %ymm7, %ymm7
; AVX1-NEXT:    vextractf128 $1, %ymm7, %xmm8
; AVX1-NEXT:    vpackusdw %xmm8, %xmm7, %xmm7
; AVX1-NEXT:    vpackusdw %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpackuswb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vandpd %ymm0, %ymm4, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vpackusdw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vandpd %ymm0, %ymm5, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpackusdw %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vandpd %ymm0, %ymm6, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vandpd %ymm0, %ymm3, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpackusdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackusdw %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpackuswb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v32i8_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovsxbw %xmm0, %ymm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm3 = xmm2[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm3, %ymm3
; AVX2-NEXT:    vpmovsxbq %xmm0, %ymm4
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm2[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm5, %ymm5
; AVX2-NEXT:    vpmovsxwq %xmm2, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vpmovsxbw %xmm0, %ymm6
; AVX2-NEXT:    vpshufd {{.*#+}} xmm7 = xmm6[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm7, %ymm7
; AVX2-NEXT:    vpmovsxbq %xmm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm6, %xmm6
; AVX2-NEXT:    vpshufd {{.*#+}} xmm8 = xmm6[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm8, %ymm8
; AVX2-NEXT:    vpmovsxwq %xmm6, %ymm6
; AVX2-NEXT:    vpmovsxbw %xmm1, %ymm9
; AVX2-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm10, %ymm10
; AVX2-NEXT:    vpsubq %ymm10, %ymm3, %ymm3
; AVX2-NEXT:    vpmovsxbq %xmm1, %ymm10
; AVX2-NEXT:    vpsubq %ymm10, %ymm4, %ymm4
; AVX2-NEXT:    vextracti128 $1, %ymm9, %xmm9
; AVX2-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm10, %ymm10
; AVX2-NEXT:    vpsubq %ymm10, %ymm5, %ymm5
; AVX2-NEXT:    vpmovsxwq %xmm9, %ymm9
; AVX2-NEXT:    vpsubq %ymm9, %ymm2, %ymm2
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-NEXT:    vpmovsxbw %xmm1, %ymm9
; AVX2-NEXT:    vpshufd {{.*#+}} xmm10 = xmm9[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm10, %ymm10
; AVX2-NEXT:    vpsubq %ymm10, %ymm7, %ymm7
; AVX2-NEXT:    vpmovsxbq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm9, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm9, %ymm9
; AVX2-NEXT:    vpsubq %ymm9, %ymm8, %ymm8
; AVX2-NEXT:    vpmovsxwq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm6, %ymm1
; AVX2-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX2-NEXT:    vpsubq %ymm3, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm3, %ymm9, %ymm3, %ymm3
; AVX2-NEXT:    vpsubq %ymm4, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm4, %ymm9, %ymm4, %ymm4
; AVX2-NEXT:    vpsubq %ymm5, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm5, %ymm9, %ymm5, %ymm5
; AVX2-NEXT:    vpsubq %ymm2, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm2, %ymm9, %ymm2, %ymm2
; AVX2-NEXT:    vpsubq %ymm7, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm7, %ymm9, %ymm7, %ymm7
; AVX2-NEXT:    vpsubq %ymm0, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm0, %ymm9, %ymm0, %ymm0
; AVX2-NEXT:    vpsubq %ymm8, %ymm6, %ymm9
; AVX2-NEXT:    vblendvpd %ymm8, %ymm9, %ymm8, %ymm8
; AVX2-NEXT:    vpsubq %ymm1, %ymm6, %ymm6
; AVX2-NEXT:    vblendvpd %ymm1, %ymm6, %ymm1, %ymm1
; AVX2-NEXT:    vbroadcastsd {{.*#+}} ymm6 = [255,255,255,255]
; AVX2-NEXT:    vandpd %ymm6, %ymm1, %ymm1
; AVX2-NEXT:    vandpd %ymm6, %ymm8, %ymm8
; AVX2-NEXT:    vpackusdw %ymm8, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vandpd %ymm6, %ymm0, %ymm0
; AVX2-NEXT:    vandpd %ymm6, %ymm7, %ymm7
; AVX2-NEXT:    vpackusdw %ymm7, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpackusdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vandpd %ymm6, %ymm2, %ymm1
; AVX2-NEXT:    vandpd %ymm6, %ymm5, %ymm2
; AVX2-NEXT:    vpackusdw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vandpd %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vandpd %ymm6, %ymm3, %ymm3
; AVX2-NEXT:    vpackusdw %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpermq {{.*#+}} ymm2 = ymm2[0,2,1,3]
; AVX2-NEXT:    vpackusdw %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vpackuswb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v32i8_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxbw %xmm0, %ymm2
; AVX512-NEXT:    vpmovsxwq %xmm2, %zmm3
; AVX512-NEXT:    vextracti128 $1, %ymm2, %xmm2
; AVX512-NEXT:    vpmovsxwq %xmm2, %zmm2
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpmovsxbw %xmm0, %ymm0
; AVX512-NEXT:    vpmovsxwq %xmm0, %zmm4
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512-NEXT:    vpmovsxbw %xmm1, %ymm5
; AVX512-NEXT:    vpmovsxwq %xmm5, %zmm6
; AVX512-NEXT:    vpsubq %zmm6, %zmm3, %zmm3
; AVX512-NEXT:    vextracti128 $1, %ymm5, %xmm5
; AVX512-NEXT:    vpmovsxwq %xmm5, %zmm5
; AVX512-NEXT:    vpsubq %zmm5, %zmm2, %zmm2
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-NEXT:    vpmovsxbw %xmm1, %ymm1
; AVX512-NEXT:    vpmovsxwq %xmm1, %zmm5
; AVX512-NEXT:    vpsubq %zmm5, %zmm4, %zmm4
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX512-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm3, %zmm1
; AVX512-NEXT:    vpabsq %zmm2, %zmm2
; AVX512-NEXT:    vpabsq %zmm4, %zmm3
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqb %zmm0, %xmm0
; AVX512-NEXT:    vpmovqb %zmm3, %xmm3
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm3[0],xmm0[0]
; AVX512-NEXT:    vpmovqb %zmm2, %xmm2
; AVX512-NEXT:    vpmovqb %zmm1, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    retq
  %aext = sext <32 x i8> %a to <32 x i64>
  %bext = sext <32 x i8> %b to <32 x i64>
  %sub = sub <32 x i64> %aext, %bext
  %abs = call <32 x i64> @llvm.abs.v32i64(<32 x i64> %sub, i1 true)
  %trunc = trunc <32 x i64> %abs to <32 x i8>
  ret <32 x i8> %trunc
}

define <16 x i16> @abd_ext_v16i16(<16 x i16> %a, <16 x i16> %b) nounwind {
; AVX1-LABEL: abd_ext_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm2, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm5, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm6, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm0[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm7, %xmm7
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm8
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm2, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm4, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm5, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm6, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm7, %xmm7
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm8, %xmm8
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm8, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm6, %ymm9
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm10
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm11
; AVX1-NEXT:    vpxor %xmm12, %xmm12, %xmm12
; AVX1-NEXT:    vpsubq %xmm3, %xmm12, %xmm3
; AVX1-NEXT:    vpsubq %xmm2, %xmm12, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-NEXT:    vblendvpd %ymm11, %ymm2, %ymm11, %ymm2
; AVX1-NEXT:    vpsubq %xmm5, %xmm12, %xmm3
; AVX1-NEXT:    vpsubq %xmm4, %xmm12, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-NEXT:    vblendvpd %ymm10, %ymm3, %ymm10, %ymm3
; AVX1-NEXT:    vpsubq %xmm7, %xmm12, %xmm4
; AVX1-NEXT:    vpsubq %xmm6, %xmm12, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX1-NEXT:    vblendvpd %ymm9, %ymm4, %ymm9, %ymm4
; AVX1-NEXT:    vpsubq %xmm0, %xmm12, %xmm0
; AVX1-NEXT:    vpsubq %xmm8, %xmm12, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm5, %ymm0
; AVX1-NEXT:    vblendvpd %ymm1, %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vmovapd {{.*#+}} ymm1 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandpd %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vandpd %ymm1, %ymm4, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpackusdw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vandpd %ymm1, %ymm3, %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vpackusdw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vandpd %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm2, %ymm2
; AVX2-NEXT:    vpmovsxwq %xmm0, %ymm3
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm4, %ymm4
; AVX2-NEXT:    vpmovsxwq %xmm0, %ymm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm5, %ymm5
; AVX2-NEXT:    vpsubq %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpmovsxwq %xmm1, %ymm5
; AVX2-NEXT:    vpsubq %ymm5, %ymm3, %ymm3
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm5, %ymm5
; AVX2-NEXT:    vpsubq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpmovsxwq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubq %ymm2, %ymm1, %ymm5
; AVX2-NEXT:    vblendvpd %ymm2, %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpsubq %ymm3, %ymm1, %ymm5
; AVX2-NEXT:    vblendvpd %ymm3, %ymm5, %ymm3, %ymm3
; AVX2-NEXT:    vpsubq %ymm4, %ymm1, %ymm5
; AVX2-NEXT:    vblendvpd %ymm4, %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpsubq %ymm0, %ymm1, %ymm5
; AVX2-NEXT:    vblendvpd %ymm0, %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7],ymm0[8],ymm1[9,10,11],ymm0[12],ymm1[13,14,15]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm1[1,2,3],ymm4[4],ymm1[5,6,7],ymm4[8],ymm1[9,10,11],ymm4[12],ymm1[13,14,15]
; AVX2-NEXT:    vpackusdw %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm1[1,2,3],ymm3[4],ymm1[5,6,7],ymm3[8],ymm1[9,10,11],ymm3[12],ymm1[13,14,15]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1,2,3],ymm2[4],ymm1[5,6,7],ymm2[8],ymm1[9,10,11],ymm2[12],ymm1[13,14,15]
; AVX2-NEXT:    vpackusdw %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vpackusdw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512-NEXT:    vpmovsxwq %xmm2, %zmm2
; AVX512-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm3
; AVX512-NEXT:    vpmovsxwq %xmm3, %zmm3
; AVX512-NEXT:    vpsubq %zmm3, %zmm2, %zmm2
; AVX512-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm2, %zmm1
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vpmovqw %zmm1, %xmm1
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %aext = sext <16 x i16> %a to <16 x i64>
  %bext = sext <16 x i16> %b to <16 x i64>
  %sub = sub <16 x i64> %aext, %bext
  %abs = call <16 x i64> @llvm.abs.v16i64(<16 x i64> %sub, i1 false)
  %trunc = trunc <16 x i64> %abs to <16 x i16>
  ret <16 x i16> %trunc
}

define <16 x i16> @abd_ext_v16i16_undef(<16 x i16> %a, <16 x i16> %b) nounwind {
; AVX1-LABEL: abd_ext_v16i16_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm2, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm3 = xmm0[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm5, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm6 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm6, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm7 = xmm0[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm7, %xmm7
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm8
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm0, %xmm0
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm2, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm3, %xmm3
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm4, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm5, %xmm5
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm6, %xmm6
; AVX1-NEXT:    vpshufd {{.*#+}} xmm9 = xmm1[3,3,3,3]
; AVX1-NEXT:    vpmovsxwq %xmm9, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm7, %xmm7
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm9
; AVX1-NEXT:    vpsubq %xmm9, %xmm8, %xmm8
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[1,1,1,1]
; AVX1-NEXT:    vpmovsxwq %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm8, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm7, %ymm6, %ymm9
; AVX1-NEXT:    vinsertf128 $1, %xmm5, %ymm4, %ymm10
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm11
; AVX1-NEXT:    vpxor %xmm12, %xmm12, %xmm12
; AVX1-NEXT:    vpsubq %xmm3, %xmm12, %xmm3
; AVX1-NEXT:    vpsubq %xmm2, %xmm12, %xmm2
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm2, %ymm2
; AVX1-NEXT:    vblendvpd %ymm11, %ymm2, %ymm11, %ymm2
; AVX1-NEXT:    vpsubq %xmm5, %xmm12, %xmm3
; AVX1-NEXT:    vpsubq %xmm4, %xmm12, %xmm4
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm4, %ymm3
; AVX1-NEXT:    vblendvpd %ymm10, %ymm3, %ymm10, %ymm3
; AVX1-NEXT:    vpsubq %xmm7, %xmm12, %xmm4
; AVX1-NEXT:    vpsubq %xmm6, %xmm12, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm5, %ymm4
; AVX1-NEXT:    vblendvpd %ymm9, %ymm4, %ymm9, %ymm4
; AVX1-NEXT:    vpsubq %xmm0, %xmm12, %xmm0
; AVX1-NEXT:    vpsubq %xmm8, %xmm12, %xmm5
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm5, %ymm0
; AVX1-NEXT:    vblendvpd %ymm1, %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vmovapd {{.*#+}} ymm1 = [65535,65535,65535,65535]
; AVX1-NEXT:    vandpd %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vandpd %ymm1, %ymm4, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vpackusdw %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpackusdw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vandpd %ymm1, %ymm3, %ymm3
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vpackusdw %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vandpd %ymm1, %ymm2, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackusdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackusdw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v16i16_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpshufd {{.*#+}} xmm2 = xmm0[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm2, %ymm2
; AVX2-NEXT:    vpmovsxwq %xmm0, %ymm3
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm4 = xmm0[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm4, %ymm4
; AVX2-NEXT:    vpmovsxwq %xmm0, %ymm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm5, %ymm5
; AVX2-NEXT:    vpsubq %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpmovsxwq %xmm1, %ymm5
; AVX2-NEXT:    vpsubq %ymm5, %ymm3, %ymm3
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm1
; AVX2-NEXT:    vpshufd {{.*#+}} xmm5 = xmm1[2,3,2,3]
; AVX2-NEXT:    vpmovsxwq %xmm5, %ymm5
; AVX2-NEXT:    vpsubq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpmovsxwq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubq %ymm2, %ymm1, %ymm5
; AVX2-NEXT:    vblendvpd %ymm2, %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vpsubq %ymm3, %ymm1, %ymm5
; AVX2-NEXT:    vblendvpd %ymm3, %ymm5, %ymm3, %ymm3
; AVX2-NEXT:    vpsubq %ymm4, %ymm1, %ymm5
; AVX2-NEXT:    vblendvpd %ymm4, %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vpsubq %ymm0, %ymm1, %ymm5
; AVX2-NEXT:    vblendvpd %ymm0, %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpblendw {{.*#+}} ymm0 = ymm0[0],ymm1[1,2,3],ymm0[4],ymm1[5,6,7],ymm0[8],ymm1[9,10,11],ymm0[12],ymm1[13,14,15]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm4 = ymm4[0],ymm1[1,2,3],ymm4[4],ymm1[5,6,7],ymm4[8],ymm1[9,10,11],ymm4[12],ymm1[13,14,15]
; AVX2-NEXT:    vpackusdw %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm3 = ymm3[0],ymm1[1,2,3],ymm3[4],ymm1[5,6,7],ymm3[8],ymm1[9,10,11],ymm3[12],ymm1[13,14,15]
; AVX2-NEXT:    vpblendw {{.*#+}} ymm1 = ymm2[0],ymm1[1,2,3],ymm2[4],ymm1[5,6,7],ymm2[8],ymm1[9,10,11],ymm2[12],ymm1[13,14,15]
; AVX2-NEXT:    vpackusdw %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vpermq {{.*#+}} ymm1 = ymm1[0,2,1,3]
; AVX2-NEXT:    vpackusdw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v16i16_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX512-NEXT:    vpmovsxwq %xmm2, %zmm2
; AVX512-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm3
; AVX512-NEXT:    vpmovsxwq %xmm3, %zmm3
; AVX512-NEXT:    vpsubq %zmm3, %zmm2, %zmm2
; AVX512-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm2, %zmm1
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqw %zmm0, %xmm0
; AVX512-NEXT:    vpmovqw %zmm1, %xmm1
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %aext = sext <16 x i16> %a to <16 x i64>
  %bext = sext <16 x i16> %b to <16 x i64>
  %sub = sub <16 x i64> %aext, %bext
  %abs = call <16 x i64> @llvm.abs.v16i64(<16 x i64> %sub, i1 true)
  %trunc = trunc <16 x i64> %abs to <16 x i16>
  ret <16 x i16> %trunc
}

define <8 x i32> @abd_ext_v8i32(<8 x i32> %a, <8 x i32> %b) nounwind {
; AVX1-LABEL: abd_ext_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpmovsxdq %xmm2, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpmovsxdq %xmm5, %xmm6
; AVX1-NEXT:    vpsubq %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm5, %xmm5
; AVX1-NEXT:    vpsubq %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm5
; AVX1-NEXT:    vpsubq %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm4, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm5
; AVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpsubq %xmm2, %xmm6, %xmm2
; AVX1-NEXT:    vpsubq %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vblendvpd %ymm5, %ymm2, %ymm5, %ymm2
; AVX1-NEXT:    vpsubq %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpsubq %xmm4, %xmm6, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX1-NEXT:    vblendvpd %ymm1, %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm2[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vpmovsxdq %xmm2, %ymm2
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm3
; AVX2-NEXT:    vpmovsxdq %xmm3, %ymm3
; AVX2-NEXT:    vpsubq %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubq %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vblendvpd %ymm2, %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpsubq %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vblendvpd %ymm0, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxdq %ymm0, %zmm0
; AVX512-NEXT:    vpmovsxdq %ymm1, %zmm1
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    retq
  %aext = sext <8 x i32> %a to <8 x i64>
  %bext = sext <8 x i32> %b to <8 x i64>
  %sub = sub <8 x i64> %aext, %bext
  %abs = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %sub, i1 false)
  %trunc = trunc <8 x i64> %abs to <8 x i32>
  ret <8 x i32> %trunc
}

define <8 x i32> @abd_ext_v8i32_undef(<8 x i32> %a, <8 x i32> %b) nounwind {
; AVX1-LABEL: abd_ext_v8i32_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpmovsxdq %xmm2, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm2 = xmm2[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpmovsxdq %xmm5, %xmm6
; AVX1-NEXT:    vpsubq %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpshufd {{.*#+}} xmm5 = xmm5[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm5, %xmm5
; AVX1-NEXT:    vpsubq %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm5
; AVX1-NEXT:    vpsubq %xmm5, %xmm4, %xmm4
; AVX1-NEXT:    vpshufd {{.*#+}} xmm1 = xmm1[2,3,2,3]
; AVX1-NEXT:    vpmovsxdq %xmm1, %xmm1
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm4, %ymm1
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm5
; AVX1-NEXT:    vpxor %xmm6, %xmm6, %xmm6
; AVX1-NEXT:    vpsubq %xmm2, %xmm6, %xmm2
; AVX1-NEXT:    vpsubq %xmm3, %xmm6, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm3, %ymm2
; AVX1-NEXT:    vblendvpd %ymm5, %ymm2, %ymm5, %ymm2
; AVX1-NEXT:    vpsubq %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpsubq %xmm4, %xmm6, %xmm3
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm3, %ymm0
; AVX1-NEXT:    vblendvpd %ymm1, %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm2[2,3]
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v8i32_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm2
; AVX2-NEXT:    vpmovsxdq %xmm2, %ymm2
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm3
; AVX2-NEXT:    vpmovsxdq %xmm3, %ymm3
; AVX2-NEXT:    vpsubq %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpmovsxdq %xmm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubq %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vblendvpd %ymm2, %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpsubq %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vblendvpd %ymm0, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vperm2f128 {{.*#+}} ymm1 = ymm0[2,3],ymm2[2,3]
; AVX2-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX2-NEXT:    vshufps {{.*#+}} ymm0 = ymm0[0,2],ymm1[0,2],ymm0[4,6],ymm1[4,6]
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v8i32_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovsxdq %ymm0, %zmm0
; AVX512-NEXT:    vpmovsxdq %ymm1, %zmm1
; AVX512-NEXT:    vpsubq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpabsq %zmm0, %zmm0
; AVX512-NEXT:    vpmovqd %zmm0, %ymm0
; AVX512-NEXT:    retq
  %aext = sext <8 x i32> %a to <8 x i64>
  %bext = sext <8 x i32> %b to <8 x i64>
  %sub = sub <8 x i64> %aext, %bext
  %abs = call <8 x i64> @llvm.abs.v8i64(<8 x i64> %sub, i1 true)
  %trunc = trunc <8 x i64> %abs to <8 x i32>
  ret <8 x i32> %trunc
}

define <4 x i64> @abd_ext_v4i64(<4 x i64> %a, <4 x i64> %b) nounwind {
; AVX1-LABEL: abd_ext_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:    pushq %r15
; AVX1-NEXT:    pushq %r14
; AVX1-NEXT:    pushq %r13
; AVX1-NEXT:    pushq %r12
; AVX1-NEXT:    pushq %rbx
; AVX1-NEXT:    vmovq %xmm0, %r11
; AVX1-NEXT:    movq %r11, %r10
; AVX1-NEXT:    sarq $63, %r10
; AVX1-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX1-NEXT:    movq %rcx, %r9
; AVX1-NEXT:    sarq $63, %r9
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, %rdx
; AVX1-NEXT:    movq %rdx, %r8
; AVX1-NEXT:    sarq $63, %r8
; AVX1-NEXT:    vpextrq $1, %xmm0, %rsi
; AVX1-NEXT:    movq %rsi, %rdi
; AVX1-NEXT:    sarq $63, %rdi
; AVX1-NEXT:    vmovq %xmm1, %rbx
; AVX1-NEXT:    movq %rbx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; AVX1-NEXT:    sarq $63, %rbx
; AVX1-NEXT:    vpextrq $1, %xmm1, %r14
; AVX1-NEXT:    movq %r14, %r15
; AVX1-NEXT:    sarq $63, %r15
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX1-NEXT:    vmovq %xmm0, %r12
; AVX1-NEXT:    movq %r12, %r13
; AVX1-NEXT:    sarq $63, %r13
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    movq %rax, %rbp
; AVX1-NEXT:    sarq $63, %rbp
; AVX1-NEXT:    subq %rax, %rsi
; AVX1-NEXT:    sbbq %rbp, %rdi
; AVX1-NEXT:    subq %r12, %rdx
; AVX1-NEXT:    sbbq %r13, %r8
; AVX1-NEXT:    subq %r14, %rcx
; AVX1-NEXT:    sbbq %r15, %r9
; AVX1-NEXT:    subq {{[-0-9]+}}(%r{{[sb]}}p), %r11 # 8-byte Folded Reload
; AVX1-NEXT:    sbbq %rbx, %r10
; AVX1-NEXT:    sarq $63, %r10
; AVX1-NEXT:    xorq %r10, %r11
; AVX1-NEXT:    subq %r10, %r11
; AVX1-NEXT:    sarq $63, %r9
; AVX1-NEXT:    xorq %r9, %rcx
; AVX1-NEXT:    subq %r9, %rcx
; AVX1-NEXT:    sarq $63, %r8
; AVX1-NEXT:    xorq %r8, %rdx
; AVX1-NEXT:    subq %r8, %rdx
; AVX1-NEXT:    sarq $63, %rdi
; AVX1-NEXT:    xorq %rdi, %rsi
; AVX1-NEXT:    subq %rdi, %rsi
; AVX1-NEXT:    vmovq %rsi, %xmm0
; AVX1-NEXT:    vmovq %rdx, %xmm1
; AVX1-NEXT:    vmovq %rcx, %xmm2
; AVX1-NEXT:    vmovq %r11, %xmm3
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm2[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    popq %rbx
; AVX1-NEXT:    popq %r12
; AVX1-NEXT:    popq %r13
; AVX1-NEXT:    popq %r14
; AVX1-NEXT:    popq %r15
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    pushq %r15
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %r13
; AVX2-NEXT:    pushq %r12
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    vmovq %xmm0, %r11
; AVX2-NEXT:    movq %r11, %r10
; AVX2-NEXT:    sarq $63, %r10
; AVX2-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %r9
; AVX2-NEXT:    sarq $63, %r9
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, %rdx
; AVX2-NEXT:    movq %rdx, %r8
; AVX2-NEXT:    sarq $63, %r8
; AVX2-NEXT:    vpextrq $1, %xmm0, %rsi
; AVX2-NEXT:    movq %rsi, %rdi
; AVX2-NEXT:    sarq $63, %rdi
; AVX2-NEXT:    vmovq %xmm1, %rbx
; AVX2-NEXT:    movq %rbx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; AVX2-NEXT:    sarq $63, %rbx
; AVX2-NEXT:    vpextrq $1, %xmm1, %r14
; AVX2-NEXT:    movq %r14, %r15
; AVX2-NEXT:    sarq $63, %r15
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm0
; AVX2-NEXT:    vmovq %xmm0, %r12
; AVX2-NEXT:    movq %r12, %r13
; AVX2-NEXT:    sarq $63, %r13
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    movq %rax, %rbp
; AVX2-NEXT:    sarq $63, %rbp
; AVX2-NEXT:    subq %rax, %rsi
; AVX2-NEXT:    sbbq %rbp, %rdi
; AVX2-NEXT:    subq %r12, %rdx
; AVX2-NEXT:    sbbq %r13, %r8
; AVX2-NEXT:    subq %r14, %rcx
; AVX2-NEXT:    sbbq %r15, %r9
; AVX2-NEXT:    subq {{[-0-9]+}}(%r{{[sb]}}p), %r11 # 8-byte Folded Reload
; AVX2-NEXT:    sbbq %rbx, %r10
; AVX2-NEXT:    sarq $63, %r10
; AVX2-NEXT:    xorq %r10, %r11
; AVX2-NEXT:    subq %r10, %r11
; AVX2-NEXT:    sarq $63, %r9
; AVX2-NEXT:    xorq %r9, %rcx
; AVX2-NEXT:    subq %r9, %rcx
; AVX2-NEXT:    sarq $63, %r8
; AVX2-NEXT:    xorq %r8, %rdx
; AVX2-NEXT:    subq %r8, %rdx
; AVX2-NEXT:    sarq $63, %rdi
; AVX2-NEXT:    xorq %rdi, %rsi
; AVX2-NEXT:    subq %rdi, %rsi
; AVX2-NEXT:    vmovq %rsi, %xmm0
; AVX2-NEXT:    vmovq %rdx, %xmm1
; AVX2-NEXT:    vmovq %rcx, %xmm2
; AVX2-NEXT:    vmovq %r11, %xmm3
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm2[0]
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r12
; AVX2-NEXT:    popq %r13
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    popq %r15
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    pushq %r15
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %r13
; AVX512-NEXT:    pushq %r12
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    vmovq %xmm0, %r11
; AVX512-NEXT:    movq %r11, %r10
; AVX512-NEXT:    sarq $63, %r10
; AVX512-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX512-NEXT:    movq %rcx, %r9
; AVX512-NEXT:    sarq $63, %r9
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vmovq %xmm0, %rdx
; AVX512-NEXT:    movq %rdx, %r8
; AVX512-NEXT:    sarq $63, %r8
; AVX512-NEXT:    vpextrq $1, %xmm0, %rsi
; AVX512-NEXT:    movq %rsi, %rdi
; AVX512-NEXT:    sarq $63, %rdi
; AVX512-NEXT:    vmovq %xmm1, %rbx
; AVX512-NEXT:    movq %rbx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; AVX512-NEXT:    sarq $63, %rbx
; AVX512-NEXT:    vpextrq $1, %xmm1, %r14
; AVX512-NEXT:    movq %r14, %r15
; AVX512-NEXT:    sarq $63, %r15
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm0
; AVX512-NEXT:    vmovq %xmm0, %r12
; AVX512-NEXT:    movq %r12, %r13
; AVX512-NEXT:    sarq $63, %r13
; AVX512-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512-NEXT:    movq %rax, %rbp
; AVX512-NEXT:    sarq $63, %rbp
; AVX512-NEXT:    subq %rax, %rsi
; AVX512-NEXT:    sbbq %rbp, %rdi
; AVX512-NEXT:    subq %r12, %rdx
; AVX512-NEXT:    sbbq %r13, %r8
; AVX512-NEXT:    subq %r14, %rcx
; AVX512-NEXT:    sbbq %r15, %r9
; AVX512-NEXT:    subq {{[-0-9]+}}(%r{{[sb]}}p), %r11 # 8-byte Folded Reload
; AVX512-NEXT:    sbbq %rbx, %r10
; AVX512-NEXT:    sarq $63, %r10
; AVX512-NEXT:    xorq %r10, %r11
; AVX512-NEXT:    subq %r10, %r11
; AVX512-NEXT:    sarq $63, %r9
; AVX512-NEXT:    xorq %r9, %rcx
; AVX512-NEXT:    subq %r9, %rcx
; AVX512-NEXT:    sarq $63, %r8
; AVX512-NEXT:    xorq %r8, %rdx
; AVX512-NEXT:    subq %r8, %rdx
; AVX512-NEXT:    sarq $63, %rdi
; AVX512-NEXT:    xorq %rdi, %rsi
; AVX512-NEXT:    subq %rdi, %rsi
; AVX512-NEXT:    vmovq %rsi, %xmm0
; AVX512-NEXT:    vmovq %rdx, %xmm1
; AVX512-NEXT:    vmovq %rcx, %xmm2
; AVX512-NEXT:    vmovq %r11, %xmm3
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm2[0]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r12
; AVX512-NEXT:    popq %r13
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    popq %r15
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %aext = sext <4 x i64> %a to <4 x i128>
  %bext = sext <4 x i64> %b to <4 x i128>
  %sub = sub <4 x i128> %aext, %bext
  %abs = call <4 x i128> @llvm.abs.v4i128(<4 x i128> %sub, i1 false)
  %trunc = trunc <4 x i128> %abs to <4 x i64>
  ret <4 x i64> %trunc
}

define <4 x i64> @abd_ext_v4i64_undef(<4 x i64> %a, <4 x i64> %b) nounwind {
; AVX1-LABEL: abd_ext_v4i64_undef:
; AVX1:       # %bb.0:
; AVX1-NEXT:    pushq %rbp
; AVX1-NEXT:    pushq %r15
; AVX1-NEXT:    pushq %r14
; AVX1-NEXT:    pushq %r13
; AVX1-NEXT:    pushq %r12
; AVX1-NEXT:    pushq %rbx
; AVX1-NEXT:    vmovq %xmm0, %r11
; AVX1-NEXT:    movq %r11, %r10
; AVX1-NEXT:    sarq $63, %r10
; AVX1-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX1-NEXT:    movq %rcx, %r9
; AVX1-NEXT:    sarq $63, %r9
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vmovq %xmm0, %rdx
; AVX1-NEXT:    movq %rdx, %r8
; AVX1-NEXT:    sarq $63, %r8
; AVX1-NEXT:    vpextrq $1, %xmm0, %rsi
; AVX1-NEXT:    movq %rsi, %rdi
; AVX1-NEXT:    sarq $63, %rdi
; AVX1-NEXT:    vmovq %xmm1, %rbx
; AVX1-NEXT:    movq %rbx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; AVX1-NEXT:    sarq $63, %rbx
; AVX1-NEXT:    vpextrq $1, %xmm1, %r14
; AVX1-NEXT:    movq %r14, %r15
; AVX1-NEXT:    sarq $63, %r15
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX1-NEXT:    vmovq %xmm0, %r12
; AVX1-NEXT:    movq %r12, %r13
; AVX1-NEXT:    sarq $63, %r13
; AVX1-NEXT:    vpextrq $1, %xmm0, %rax
; AVX1-NEXT:    movq %rax, %rbp
; AVX1-NEXT:    sarq $63, %rbp
; AVX1-NEXT:    subq %rax, %rsi
; AVX1-NEXT:    sbbq %rbp, %rdi
; AVX1-NEXT:    subq %r12, %rdx
; AVX1-NEXT:    sbbq %r13, %r8
; AVX1-NEXT:    subq %r14, %rcx
; AVX1-NEXT:    sbbq %r15, %r9
; AVX1-NEXT:    subq {{[-0-9]+}}(%r{{[sb]}}p), %r11 # 8-byte Folded Reload
; AVX1-NEXT:    sbbq %rbx, %r10
; AVX1-NEXT:    sarq $63, %r10
; AVX1-NEXT:    xorq %r10, %r11
; AVX1-NEXT:    subq %r10, %r11
; AVX1-NEXT:    sarq $63, %r9
; AVX1-NEXT:    xorq %r9, %rcx
; AVX1-NEXT:    subq %r9, %rcx
; AVX1-NEXT:    sarq $63, %r8
; AVX1-NEXT:    xorq %r8, %rdx
; AVX1-NEXT:    subq %r8, %rdx
; AVX1-NEXT:    sarq $63, %rdi
; AVX1-NEXT:    xorq %rdi, %rsi
; AVX1-NEXT:    subq %rdi, %rsi
; AVX1-NEXT:    vmovq %rsi, %xmm0
; AVX1-NEXT:    vmovq %rdx, %xmm1
; AVX1-NEXT:    vmovq %rcx, %xmm2
; AVX1-NEXT:    vmovq %r11, %xmm3
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm2[0]
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    popq %rbx
; AVX1-NEXT:    popq %r12
; AVX1-NEXT:    popq %r13
; AVX1-NEXT:    popq %r14
; AVX1-NEXT:    popq %r15
; AVX1-NEXT:    popq %rbp
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_ext_v4i64_undef:
; AVX2:       # %bb.0:
; AVX2-NEXT:    pushq %rbp
; AVX2-NEXT:    pushq %r15
; AVX2-NEXT:    pushq %r14
; AVX2-NEXT:    pushq %r13
; AVX2-NEXT:    pushq %r12
; AVX2-NEXT:    pushq %rbx
; AVX2-NEXT:    vmovq %xmm0, %r11
; AVX2-NEXT:    movq %r11, %r10
; AVX2-NEXT:    sarq $63, %r10
; AVX2-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX2-NEXT:    movq %rcx, %r9
; AVX2-NEXT:    sarq $63, %r9
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    vmovq %xmm0, %rdx
; AVX2-NEXT:    movq %rdx, %r8
; AVX2-NEXT:    sarq $63, %r8
; AVX2-NEXT:    vpextrq $1, %xmm0, %rsi
; AVX2-NEXT:    movq %rsi, %rdi
; AVX2-NEXT:    sarq $63, %rdi
; AVX2-NEXT:    vmovq %xmm1, %rbx
; AVX2-NEXT:    movq %rbx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; AVX2-NEXT:    sarq $63, %rbx
; AVX2-NEXT:    vpextrq $1, %xmm1, %r14
; AVX2-NEXT:    movq %r14, %r15
; AVX2-NEXT:    sarq $63, %r15
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm0
; AVX2-NEXT:    vmovq %xmm0, %r12
; AVX2-NEXT:    movq %r12, %r13
; AVX2-NEXT:    sarq $63, %r13
; AVX2-NEXT:    vpextrq $1, %xmm0, %rax
; AVX2-NEXT:    movq %rax, %rbp
; AVX2-NEXT:    sarq $63, %rbp
; AVX2-NEXT:    subq %rax, %rsi
; AVX2-NEXT:    sbbq %rbp, %rdi
; AVX2-NEXT:    subq %r12, %rdx
; AVX2-NEXT:    sbbq %r13, %r8
; AVX2-NEXT:    subq %r14, %rcx
; AVX2-NEXT:    sbbq %r15, %r9
; AVX2-NEXT:    subq {{[-0-9]+}}(%r{{[sb]}}p), %r11 # 8-byte Folded Reload
; AVX2-NEXT:    sbbq %rbx, %r10
; AVX2-NEXT:    sarq $63, %r10
; AVX2-NEXT:    xorq %r10, %r11
; AVX2-NEXT:    subq %r10, %r11
; AVX2-NEXT:    sarq $63, %r9
; AVX2-NEXT:    xorq %r9, %rcx
; AVX2-NEXT:    subq %r9, %rcx
; AVX2-NEXT:    sarq $63, %r8
; AVX2-NEXT:    xorq %r8, %rdx
; AVX2-NEXT:    subq %r8, %rdx
; AVX2-NEXT:    sarq $63, %rdi
; AVX2-NEXT:    xorq %rdi, %rsi
; AVX2-NEXT:    subq %rdi, %rsi
; AVX2-NEXT:    vmovq %rsi, %xmm0
; AVX2-NEXT:    vmovq %rdx, %xmm1
; AVX2-NEXT:    vmovq %rcx, %xmm2
; AVX2-NEXT:    vmovq %r11, %xmm3
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm2[0]
; AVX2-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX2-NEXT:    popq %rbx
; AVX2-NEXT:    popq %r12
; AVX2-NEXT:    popq %r13
; AVX2-NEXT:    popq %r14
; AVX2-NEXT:    popq %r15
; AVX2-NEXT:    popq %rbp
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_ext_v4i64_undef:
; AVX512:       # %bb.0:
; AVX512-NEXT:    pushq %rbp
; AVX512-NEXT:    pushq %r15
; AVX512-NEXT:    pushq %r14
; AVX512-NEXT:    pushq %r13
; AVX512-NEXT:    pushq %r12
; AVX512-NEXT:    pushq %rbx
; AVX512-NEXT:    vmovq %xmm0, %r11
; AVX512-NEXT:    movq %r11, %r10
; AVX512-NEXT:    sarq $63, %r10
; AVX512-NEXT:    vpextrq $1, %xmm0, %rcx
; AVX512-NEXT:    movq %rcx, %r9
; AVX512-NEXT:    sarq $63, %r9
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX512-NEXT:    vmovq %xmm0, %rdx
; AVX512-NEXT:    movq %rdx, %r8
; AVX512-NEXT:    sarq $63, %r8
; AVX512-NEXT:    vpextrq $1, %xmm0, %rsi
; AVX512-NEXT:    movq %rsi, %rdi
; AVX512-NEXT:    sarq $63, %rdi
; AVX512-NEXT:    vmovq %xmm1, %rbx
; AVX512-NEXT:    movq %rbx, {{[-0-9]+}}(%r{{[sb]}}p) # 8-byte Spill
; AVX512-NEXT:    sarq $63, %rbx
; AVX512-NEXT:    vpextrq $1, %xmm1, %r14
; AVX512-NEXT:    movq %r14, %r15
; AVX512-NEXT:    sarq $63, %r15
; AVX512-NEXT:    vextracti128 $1, %ymm1, %xmm0
; AVX512-NEXT:    vmovq %xmm0, %r12
; AVX512-NEXT:    movq %r12, %r13
; AVX512-NEXT:    sarq $63, %r13
; AVX512-NEXT:    vpextrq $1, %xmm0, %rax
; AVX512-NEXT:    movq %rax, %rbp
; AVX512-NEXT:    sarq $63, %rbp
; AVX512-NEXT:    subq %rax, %rsi
; AVX512-NEXT:    sbbq %rbp, %rdi
; AVX512-NEXT:    subq %r12, %rdx
; AVX512-NEXT:    sbbq %r13, %r8
; AVX512-NEXT:    subq %r14, %rcx
; AVX512-NEXT:    sbbq %r15, %r9
; AVX512-NEXT:    subq {{[-0-9]+}}(%r{{[sb]}}p), %r11 # 8-byte Folded Reload
; AVX512-NEXT:    sbbq %rbx, %r10
; AVX512-NEXT:    sarq $63, %r10
; AVX512-NEXT:    xorq %r10, %r11
; AVX512-NEXT:    subq %r10, %r11
; AVX512-NEXT:    sarq $63, %r9
; AVX512-NEXT:    xorq %r9, %rcx
; AVX512-NEXT:    subq %r9, %rcx
; AVX512-NEXT:    sarq $63, %r8
; AVX512-NEXT:    xorq %r8, %rdx
; AVX512-NEXT:    subq %r8, %rdx
; AVX512-NEXT:    sarq $63, %rdi
; AVX512-NEXT:    xorq %rdi, %rsi
; AVX512-NEXT:    subq %rdi, %rsi
; AVX512-NEXT:    vmovq %rsi, %xmm0
; AVX512-NEXT:    vmovq %rdx, %xmm1
; AVX512-NEXT:    vmovq %rcx, %xmm2
; AVX512-NEXT:    vmovq %r11, %xmm3
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm2[0]
; AVX512-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512-NEXT:    popq %rbx
; AVX512-NEXT:    popq %r12
; AVX512-NEXT:    popq %r13
; AVX512-NEXT:    popq %r14
; AVX512-NEXT:    popq %r15
; AVX512-NEXT:    popq %rbp
; AVX512-NEXT:    retq
  %aext = sext <4 x i64> %a to <4 x i128>
  %bext = sext <4 x i64> %b to <4 x i128>
  %sub = sub <4 x i128> %aext, %bext
  %abs = call <4 x i128> @llvm.abs.v4i128(<4 x i128> %sub, i1 true)
  %trunc = trunc <4 x i128> %abs to <4 x i64>
  ret <4 x i64> %trunc
}

;
; sub(smax(a,b),smin(a,b)) -> abds(a,b)
;

define <32 x i8> @abd_minmax_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; AVX1-LABEL: abd_minmax_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpminsb %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpminsb %xmm3, %xmm4, %xmm5
; AVX1-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsubb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpmaxsb %xmm3, %xmm4, %xmm1
; AVX1-NEXT:    vpsubb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_minmax_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsubb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_minmax_v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsubb %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %min = call <32 x i8> @llvm.smin.v32i8(<32 x i8> %a, <32 x i8> %b)
  %max = call <32 x i8> @llvm.smax.v32i8(<32 x i8> %a, <32 x i8> %b)
  %sub = sub <32 x i8> %max, %min
  ret <32 x i8> %sub
}

define <16 x i16> @abd_minmax_v16i16(<16 x i16> %a, <16 x i16> %b) nounwind {
; AVX1-LABEL: abd_minmax_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpminsw %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpminsw %xmm3, %xmm4, %xmm5
; AVX1-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsubw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpmaxsw %xmm3, %xmm4, %xmm1
; AVX1-NEXT:    vpsubw %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_minmax_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsubw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_minmax_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsubw %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %min = call <16 x i16> @llvm.smin.v16i16(<16 x i16> %a, <16 x i16> %b)
  %max = call <16 x i16> @llvm.smax.v16i16(<16 x i16> %a, <16 x i16> %b)
  %sub = sub <16 x i16> %max, %min
  ret <16 x i16> %sub
}

define <8 x i32> @abd_minmax_v8i32(<8 x i32> %a, <8 x i32> %b) nounwind {
; AVX1-LABEL: abd_minmax_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpminsd %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpminsd %xmm3, %xmm4, %xmm5
; AVX1-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsubd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpmaxsd %xmm3, %xmm4, %xmm1
; AVX1-NEXT:    vpsubd %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_minmax_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsubd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_minmax_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsubd %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %min = call <8 x i32> @llvm.smin.v8i32(<8 x i32> %a, <8 x i32> %b)
  %max = call <8 x i32> @llvm.smax.v8i32(<8 x i32> %a, <8 x i32> %b)
  %sub = sub <8 x i32> %max, %min
  ret <8 x i32> %sub
}

define <4 x i64> @abd_minmax_v4i64(<4 x i64> %a, <4 x i64> %b) nounwind {
; AVX1-LABEL: abd_minmax_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vblendvpd %xmm2, %xmm1, %xmm0, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm5
; AVX1-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm6
; AVX1-NEXT:    vblendvpd %xmm6, %xmm4, %xmm5, %xmm7
; AVX1-NEXT:    vblendvpd %xmm2, %xmm0, %xmm1, %xmm0
; AVX1-NEXT:    vpsubq %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vblendvpd %xmm6, %xmm5, %xmm4, %xmm1
; AVX1-NEXT:    vpsubq %xmm7, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_minmax_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsubq %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_minmax_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsq %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsubq %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %min = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %a, <4 x i64> %b)
  %max = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %a, <4 x i64> %b)
  %sub = sub <4 x i64> %max, %min
  ret <4 x i64> %sub
}

;
; abs(sub_nsw(x, y)) -> abds(a,b)
;

define <32 x i8> @abd_subnsw_v32i8(<32 x i8> %a, <32 x i8> %b) nounwind {
; AVX1-LABEL: abd_subnsw_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsubb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpabsb %xmm0, %xmm0
; AVX1-NEXT:    vpabsb %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_subnsw_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpabsb %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_subnsw_v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpabsb %ymm0, %ymm0
; AVX512-NEXT:    retq
  %sub = sub nsw <32 x i8> %a, %b
  %abs = call <32 x i8> @llvm.abs.v32i8(<32 x i8> %sub, i1 false)
  ret <32 x i8> %abs
}

define <16 x i16> @abd_subnsw_v16i16(<16 x i16> %a, <16 x i16> %b) nounwind {
; AVX1-LABEL: abd_subnsw_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsubw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpabsw %xmm0, %xmm0
; AVX1-NEXT:    vpabsw %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_subnsw_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpabsw %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_subnsw_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubw %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpabsw %ymm0, %ymm0
; AVX512-NEXT:    retq
  %sub = sub nsw <16 x i16> %a, %b
  %abs = call <16 x i16> @llvm.abs.v16i16(<16 x i16> %sub, i1 false)
  ret <16 x i16> %abs
}

define <8 x i32> @abd_subnsw_v8i32(<8 x i32> %a, <8 x i32> %b) nounwind {
; AVX1-LABEL: abd_subnsw_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsubd %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpabsd %xmm0, %xmm0
; AVX1-NEXT:    vpabsd %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_subnsw_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpabsd %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_subnsw_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpabsd %ymm0, %ymm0
; AVX512-NEXT:    retq
  %sub = sub nsw <8 x i32> %a, %b
  %abs = call <8 x i32> @llvm.abs.v8i32(<8 x i32> %sub, i1 false)
  ret <8 x i32> %abs
}

define <4 x i64> @abd_subnsw_v4i64(<4 x i64> %a, <4 x i64> %b) nounwind {
; AVX1-LABEL: abd_subnsw_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpsubq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm1
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpsubq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpsubq %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vblendvpd %ymm1, %ymm0, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: abd_subnsw_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpsubq %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vblendvpd %ymm0, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: abd_subnsw_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsubq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpabsq %ymm0, %ymm0
; AVX512-NEXT:    retq
  %sub = sub nsw <4 x i64> %a, %b
  %abs = call <4 x i64> @llvm.abs.v4i64(<4 x i64> %sub, i1 false)
  ret <4 x i64> %abs
}

declare <32 x i8> @llvm.abs.v32i8(<32 x i8>, i1)
declare <16 x i16> @llvm.abs.v16i16(<16 x i16>, i1)
declare <8 x i32> @llvm.abs.v8i32(<8 x i32>, i1)
declare <4 x i64> @llvm.abs.v4i64(<4 x i64>, i1)
declare <8 x i64> @llvm.abs.v8i64(<8 x i64>, i1)
declare <16 x i64> @llvm.abs.v16i64(<16 x i64>, i1)
declare <32 x i64> @llvm.abs.v32i64(<32 x i64>, i1)
declare <4 x i128> @llvm.abs.v4i128(<4 x i128>, i1)

declare <32 x i8> @llvm.smax.v32i8(<32 x i8>, <32 x i8>)
declare <16 x i16> @llvm.smax.v16i16(<16 x i16>, <16 x i16>)
declare <8 x i32> @llvm.smax.v8i32(<8 x i32>, <8 x i32>)
declare <4 x i64> @llvm.smax.v4i64(<4 x i64>, <4 x i64>)

declare <32 x i8> @llvm.smin.v32i8(<32 x i8>, <32 x i8>)
declare <16 x i16> @llvm.smin.v16i16(<16 x i16>, <16 x i16>)
declare <8 x i32> @llvm.smin.v8i32(<8 x i32>, <8 x i32>)
declare <4 x i64> @llvm.smin.v4i64(<4 x i64>, <4 x i64>)
