; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -S -mtriple=riscv64 -mattr=+v,+f,+d -riscv-v-vector-bits-min=-1 | FileCheck %s

define void @floor() {
; CHECK-LABEL: 'floor'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %1 = call float @llvm.floor.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %2 = call <2 x float> @llvm.floor.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %3 = call <4 x float> @llvm.floor.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %4 = call <8 x float> @llvm.floor.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %5 = call <16 x float> @llvm.floor.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %6 = call <vscale x 1 x float> @llvm.floor.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %7 = call <vscale x 2 x float> @llvm.floor.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %8 = call <vscale x 4 x float> @llvm.floor.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %9 = call <vscale x 8 x float> @llvm.floor.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %10 = call <vscale x 16 x float> @llvm.floor.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %11 = call double @llvm.floor.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %12 = call <2 x double> @llvm.floor.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %13 = call <4 x double> @llvm.floor.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %14 = call <8 x double> @llvm.floor.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %15 = call <16 x double> @llvm.floor.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %16 = call <vscale x 1 x double> @llvm.floor.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %17 = call <vscale x 2 x double> @llvm.floor.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %18 = call <vscale x 4 x double> @llvm.floor.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %19 = call <vscale x 8 x double> @llvm.floor.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.floor.f32(float undef)
  call <2 x float> @llvm.floor.v2f32(<2 x float> undef)
  call <4 x float> @llvm.floor.v4f32(<4 x float> undef)
  call <8 x float> @llvm.floor.v8f32(<8 x float> undef)
  call <16 x float> @llvm.floor.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.floor.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.floor.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.floor.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.floor.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.floor.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.floor.f64(double undef)
  call <2 x double> @llvm.floor.v2f64(<2 x double> undef)
  call <4 x double> @llvm.floor.v4f64(<4 x double> undef)
  call <8 x double> @llvm.floor.v8f64(<8 x double> undef)
  call <16 x double> @llvm.floor.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.floor.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.floor.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.floor.nvx5f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.floor.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

define void @ceil() {
; CHECK-LABEL: 'ceil'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %1 = call float @llvm.ceil.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %2 = call <2 x float> @llvm.ceil.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %3 = call <4 x float> @llvm.ceil.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %4 = call <8 x float> @llvm.ceil.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %5 = call <16 x float> @llvm.ceil.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %6 = call <vscale x 1 x float> @llvm.ceil.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %7 = call <vscale x 2 x float> @llvm.ceil.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %8 = call <vscale x 4 x float> @llvm.ceil.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %9 = call <vscale x 8 x float> @llvm.ceil.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %10 = call <vscale x 16 x float> @llvm.ceil.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %11 = call double @llvm.ceil.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %12 = call <2 x double> @llvm.ceil.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %13 = call <4 x double> @llvm.ceil.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %14 = call <8 x double> @llvm.ceil.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %15 = call <16 x double> @llvm.ceil.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %16 = call <vscale x 1 x double> @llvm.ceil.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %17 = call <vscale x 2 x double> @llvm.ceil.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %18 = call <vscale x 4 x double> @llvm.ceil.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %19 = call <vscale x 8 x double> @llvm.ceil.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.ceil.f32(float undef)
  call <2 x float> @llvm.ceil.v2f32(<2 x float> undef)
  call <4 x float> @llvm.ceil.v4f32(<4 x float> undef)
  call <8 x float> @llvm.ceil.v8f32(<8 x float> undef)
  call <16 x float> @llvm.ceil.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.ceil.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.ceil.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.ceil.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.ceil.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.ceil.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.ceil.f64(double undef)
  call <2 x double> @llvm.ceil.v2f64(<2 x double> undef)
  call <4 x double> @llvm.ceil.v4f64(<4 x double> undef)
  call <8 x double> @llvm.ceil.v8f64(<8 x double> undef)
  call <16 x double> @llvm.ceil.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.ceil.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.ceil.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.ceil.nvx5f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.ceil.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

define void @trunc() {
; CHECK-LABEL: 'trunc'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %1 = call float @llvm.trunc.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %2 = call <2 x float> @llvm.trunc.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %3 = call <4 x float> @llvm.trunc.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %4 = call <8 x float> @llvm.trunc.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %5 = call <16 x float> @llvm.trunc.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %6 = call <vscale x 1 x float> @llvm.trunc.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %7 = call <vscale x 2 x float> @llvm.trunc.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %8 = call <vscale x 4 x float> @llvm.trunc.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %9 = call <vscale x 8 x float> @llvm.trunc.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %10 = call <vscale x 16 x float> @llvm.trunc.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %11 = call double @llvm.trunc.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %12 = call <2 x double> @llvm.trunc.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %13 = call <4 x double> @llvm.trunc.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %14 = call <8 x double> @llvm.trunc.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %15 = call <16 x double> @llvm.trunc.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %16 = call <vscale x 1 x double> @llvm.trunc.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %17 = call <vscale x 2 x double> @llvm.trunc.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %18 = call <vscale x 4 x double> @llvm.trunc.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %19 = call <vscale x 8 x double> @llvm.trunc.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.trunc.f32(float undef)
  call <2 x float> @llvm.trunc.v2f32(<2 x float> undef)
  call <4 x float> @llvm.trunc.v4f32(<4 x float> undef)
  call <8 x float> @llvm.trunc.v8f32(<8 x float> undef)
  call <16 x float> @llvm.trunc.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.trunc.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.trunc.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.trunc.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.trunc.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.trunc.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.trunc.f64(double undef)
  call <2 x double> @llvm.trunc.v2f64(<2 x double> undef)
  call <4 x double> @llvm.trunc.v4f64(<4 x double> undef)
  call <8 x double> @llvm.trunc.v8f64(<8 x double> undef)
  call <16 x double> @llvm.trunc.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.trunc.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.trunc.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.trunc.nvx5f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.trunc.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

define void @rint() {
; CHECK-LABEL: 'rint'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %1 = call float @llvm.rint.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %2 = call <2 x float> @llvm.rint.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 39 for instruction: %3 = call <4 x float> @llvm.rint.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 79 for instruction: %4 = call <8 x float> @llvm.rint.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 159 for instruction: %5 = call <16 x float> @llvm.rint.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %6 = call <vscale x 1 x float> @llvm.rint.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %7 = call <vscale x 2 x float> @llvm.rint.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %8 = call <vscale x 4 x float> @llvm.rint.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %9 = call <vscale x 8 x float> @llvm.rint.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %10 = call <vscale x 16 x float> @llvm.rint.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %11 = call double @llvm.rint.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %12 = call <2 x double> @llvm.rint.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 39 for instruction: %13 = call <4 x double> @llvm.rint.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 79 for instruction: %14 = call <8 x double> @llvm.rint.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 159 for instruction: %15 = call <16 x double> @llvm.rint.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %16 = call <vscale x 1 x double> @llvm.rint.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %17 = call <vscale x 2 x double> @llvm.rint.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %18 = call <vscale x 4 x double> @llvm.rint.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %19 = call <vscale x 8 x double> @llvm.rint.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.rint.f32(float undef)
  call <2 x float> @llvm.rint.v2f32(<2 x float> undef)
  call <4 x float> @llvm.rint.v4f32(<4 x float> undef)
  call <8 x float> @llvm.rint.v8f32(<8 x float> undef)
  call <16 x float> @llvm.rint.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.rint.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.rint.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.rint.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.rint.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.rint.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.rint.f64(double undef)
  call <2 x double> @llvm.rint.v2f64(<2 x double> undef)
  call <4 x double> @llvm.rint.v4f64(<4 x double> undef)
  call <8 x double> @llvm.rint.v8f64(<8 x double> undef)
  call <16 x double> @llvm.rint.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.rint.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.rint.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.rint.nvx5f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.rint.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

define void @nearbyint() {
; CHECK-LABEL: 'nearbyint'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %1 = call float @llvm.nearbyint.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %2 = call <2 x float> @llvm.nearbyint.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %3 = call <4 x float> @llvm.nearbyint.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %4 = call <8 x float> @llvm.nearbyint.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %5 = call <16 x float> @llvm.nearbyint.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %6 = call <vscale x 1 x float> @llvm.nearbyint.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %7 = call <vscale x 2 x float> @llvm.nearbyint.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %8 = call <vscale x 4 x float> @llvm.nearbyint.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %9 = call <vscale x 8 x float> @llvm.nearbyint.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %10 = call <vscale x 16 x float> @llvm.nearbyint.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %11 = call double @llvm.nearbyint.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %12 = call <2 x double> @llvm.nearbyint.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 47 for instruction: %13 = call <4 x double> @llvm.nearbyint.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 95 for instruction: %14 = call <8 x double> @llvm.nearbyint.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 191 for instruction: %15 = call <16 x double> @llvm.nearbyint.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %16 = call <vscale x 1 x double> @llvm.nearbyint.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %17 = call <vscale x 2 x double> @llvm.nearbyint.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %18 = call <vscale x 4 x double> @llvm.nearbyint.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Invalid cost for instruction: %19 = call <vscale x 8 x double> @llvm.nearbyint.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.nearbyint.f32(float undef)
  call <2 x float> @llvm.nearbyint.v2f32(<2 x float> undef)
  call <4 x float> @llvm.nearbyint.v4f32(<4 x float> undef)
  call <8 x float> @llvm.nearbyint.v8f32(<8 x float> undef)
  call <16 x float> @llvm.nearbyint.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.nearbyint.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.nearbyint.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.nearbyint.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.nearbyint.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.nearbyint.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.nearbyint.f64(double undef)
  call <2 x double> @llvm.nearbyint.v2f64(<2 x double> undef)
  call <4 x double> @llvm.nearbyint.v4f64(<4 x double> undef)
  call <8 x double> @llvm.nearbyint.v8f64(<8 x double> undef)
  call <16 x double> @llvm.nearbyint.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.nearbyint.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.nearbyint.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.nearbyint.nvx5f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.nearbyint.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

define void @round() {
; CHECK-LABEL: 'round'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %1 = call float @llvm.round.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %2 = call <2 x float> @llvm.round.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %3 = call <4 x float> @llvm.round.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %4 = call <8 x float> @llvm.round.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %5 = call <16 x float> @llvm.round.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %6 = call <vscale x 1 x float> @llvm.round.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %7 = call <vscale x 2 x float> @llvm.round.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %8 = call <vscale x 4 x float> @llvm.round.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %9 = call <vscale x 8 x float> @llvm.round.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %10 = call <vscale x 16 x float> @llvm.round.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %11 = call double @llvm.round.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %12 = call <2 x double> @llvm.round.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %13 = call <4 x double> @llvm.round.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %14 = call <8 x double> @llvm.round.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %15 = call <16 x double> @llvm.round.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %16 = call <vscale x 1 x double> @llvm.round.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %17 = call <vscale x 2 x double> @llvm.round.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %18 = call <vscale x 4 x double> @llvm.round.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %19 = call <vscale x 8 x double> @llvm.round.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.round.f32(float undef)
  call <2 x float> @llvm.round.v2f32(<2 x float> undef)
  call <4 x float> @llvm.round.v4f32(<4 x float> undef)
  call <8 x float> @llvm.round.v8f32(<8 x float> undef)
  call <16 x float> @llvm.round.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.round.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.round.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.round.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.round.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.round.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.round.f64(double undef)
  call <2 x double> @llvm.round.v2f64(<2 x double> undef)
  call <4 x double> @llvm.round.v4f64(<4 x double> undef)
  call <8 x double> @llvm.round.v8f64(<8 x double> undef)
  call <16 x double> @llvm.round.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.round.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.round.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.round.nvx5f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.round.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

define void @roundeven() {
; CHECK-LABEL: 'roundeven'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %1 = call float @llvm.roundeven.f32(float undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %2 = call <2 x float> @llvm.roundeven.v2f32(<2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %3 = call <4 x float> @llvm.roundeven.v4f32(<4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %4 = call <8 x float> @llvm.roundeven.v8f32(<8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %5 = call <16 x float> @llvm.roundeven.v16f32(<16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %6 = call <vscale x 1 x float> @llvm.roundeven.nxv1f32(<vscale x 1 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %7 = call <vscale x 2 x float> @llvm.roundeven.nxv2f32(<vscale x 2 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %8 = call <vscale x 4 x float> @llvm.roundeven.nxv4f32(<vscale x 4 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %9 = call <vscale x 8 x float> @llvm.roundeven.nxv8f32(<vscale x 8 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %10 = call <vscale x 16 x float> @llvm.roundeven.nxv16f32(<vscale x 16 x float> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %11 = call double @llvm.roundeven.f64(double undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %12 = call <2 x double> @llvm.roundeven.v2f64(<2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %13 = call <4 x double> @llvm.roundeven.v4f64(<4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %14 = call <8 x double> @llvm.roundeven.v8f64(<8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %15 = call <16 x double> @llvm.roundeven.v16f64(<16 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %16 = call <vscale x 1 x double> @llvm.roundeven.nxv1f64(<vscale x 1 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %17 = call <vscale x 2 x double> @llvm.roundeven.nxv2f64(<vscale x 2 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %18 = call <vscale x 4 x double> @llvm.roundeven.nxv4f64(<vscale x 4 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %19 = call <vscale x 8 x double> @llvm.roundeven.nxv8f64(<vscale x 8 x double> undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call float @llvm.roundeven.f32(float undef)
  call <2 x float> @llvm.roundeven.v2f32(<2 x float> undef)
  call <4 x float> @llvm.roundeven.v4f32(<4 x float> undef)
  call <8 x float> @llvm.roundeven.v8f32(<8 x float> undef)
  call <16 x float> @llvm.roundeven.v16f32(<16 x float> undef)
  call <vscale x 1 x float> @llvm.roundeven.nvx1f32(<vscale x 1 x float> undef)
  call <vscale x 2 x float> @llvm.roundeven.nvx2f32(<vscale x 2 x float> undef)
  call <vscale x 4 x float> @llvm.roundeven.nvx4f32(<vscale x 4 x float> undef)
  call <vscale x 8 x float> @llvm.roundeven.nvx8f32(<vscale x 8 x float> undef)
  call <vscale x 16 x float> @llvm.roundeven.nvx16f32(<vscale x 16 x float> undef)
  call double @llvm.roundeven.f64(double undef)
  call <2 x double> @llvm.roundeven.v2f64(<2 x double> undef)
  call <4 x double> @llvm.roundeven.v4f64(<4 x double> undef)
  call <8 x double> @llvm.roundeven.v8f64(<8 x double> undef)
  call <16 x double> @llvm.roundeven.v16f64(<16 x double> undef)
  call <vscale x 1 x double> @llvm.roundeven.nvx1f64(<vscale x 1 x double> undef)
  call <vscale x 2 x double> @llvm.roundeven.nvx2f64(<vscale x 2 x double> undef)
  call <vscale x 4 x double> @llvm.roundeven.nvx5f64(<vscale x 4 x double> undef)
  call <vscale x 8 x double> @llvm.roundeven.nvx8f64(<vscale x 8 x double> undef)
  ret void
}

define void @vp_ceil() {
; CHECK-LABEL: 'vp_ceil'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %1 = call <2 x float> @llvm.vp.ceil.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %2 = call <4 x float> @llvm.vp.ceil.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %3 = call <8 x float> @llvm.vp.ceil.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %4 = call <16 x float> @llvm.vp.ceil.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %5 = call <vscale x 1 x float> @llvm.vp.ceil.nxv1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %6 = call <vscale x 2 x float> @llvm.vp.ceil.nxv2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %7 = call <vscale x 4 x float> @llvm.vp.ceil.nxv4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %8 = call <vscale x 8 x float> @llvm.vp.ceil.nxv8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %9 = call <vscale x 16 x float> @llvm.vp.ceil.nxv16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %10 = call <2 x double> @llvm.vp.ceil.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %11 = call <4 x double> @llvm.vp.ceil.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %12 = call <8 x double> @llvm.vp.ceil.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %13 = call <16 x double> @llvm.vp.ceil.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %14 = call <vscale x 1 x double> @llvm.vp.ceil.nxv1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %15 = call <vscale x 2 x double> @llvm.vp.ceil.nxv2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %16 = call <vscale x 4 x double> @llvm.vp.ceil.nxv4f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %17 = call <vscale x 8 x double> @llvm.vp.ceil.nxv8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call <2 x float> @llvm.vp.ceil.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
  call <4 x float> @llvm.vp.ceil.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
  call <8 x float> @llvm.vp.ceil.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
  call <16 x float> @llvm.vp.ceil.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x float> @llvm.vp.ceil.nvx1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x float> @llvm.vp.ceil.nvx2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x float> @llvm.vp.ceil.nvx4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x float> @llvm.vp.ceil.nvx8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
  call <vscale x 16 x float> @llvm.vp.ceil.nvx16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
  call <2 x double> @llvm.vp.ceil.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
  call <4 x double> @llvm.vp.ceil.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
  call <8 x double> @llvm.vp.ceil.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
  call <16 x double> @llvm.vp.ceil.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x double> @llvm.vp.ceil.nvx1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x double> @llvm.vp.ceil.nvx2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x double> @llvm.vp.ceil.nvx5f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x double> @llvm.vp.ceil.nvx8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
  ret void
}

define void @vp_floor() {
; CHECK-LABEL: 'vp_floor'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %1 = call <2 x float> @llvm.vp.floor.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %2 = call <4 x float> @llvm.vp.floor.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %3 = call <8 x float> @llvm.vp.floor.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %4 = call <16 x float> @llvm.vp.floor.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %5 = call <vscale x 1 x float> @llvm.vp.floor.nxv1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %6 = call <vscale x 2 x float> @llvm.vp.floor.nxv2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %7 = call <vscale x 4 x float> @llvm.vp.floor.nxv4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %8 = call <vscale x 8 x float> @llvm.vp.floor.nxv8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %9 = call <vscale x 16 x float> @llvm.vp.floor.nxv16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %10 = call <2 x double> @llvm.vp.floor.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %11 = call <4 x double> @llvm.vp.floor.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %12 = call <8 x double> @llvm.vp.floor.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %13 = call <16 x double> @llvm.vp.floor.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %14 = call <vscale x 1 x double> @llvm.vp.floor.nxv1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %15 = call <vscale x 2 x double> @llvm.vp.floor.nxv2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %16 = call <vscale x 4 x double> @llvm.vp.floor.nxv4f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %17 = call <vscale x 8 x double> @llvm.vp.floor.nxv8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call <2 x float> @llvm.vp.floor.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
  call <4 x float> @llvm.vp.floor.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
  call <8 x float> @llvm.vp.floor.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
  call <16 x float> @llvm.vp.floor.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x float> @llvm.vp.floor.nvx1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x float> @llvm.vp.floor.nvx2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x float> @llvm.vp.floor.nvx4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x float> @llvm.vp.floor.nvx8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
  call <vscale x 16 x float> @llvm.vp.floor.nvx16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
  call <2 x double> @llvm.vp.floor.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
  call <4 x double> @llvm.vp.floor.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
  call <8 x double> @llvm.vp.floor.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
  call <16 x double> @llvm.vp.floor.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x double> @llvm.vp.floor.nvx1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x double> @llvm.vp.floor.nvx2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x double> @llvm.vp.floor.nvx5f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x double> @llvm.vp.floor.nvx8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
  ret void
}

define void @vp_round() {
; CHECK-LABEL: 'vp_round'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %1 = call <2 x float> @llvm.vp.round.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %2 = call <4 x float> @llvm.vp.round.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %3 = call <8 x float> @llvm.vp.round.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %4 = call <16 x float> @llvm.vp.round.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %5 = call <vscale x 1 x float> @llvm.vp.round.nxv1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %6 = call <vscale x 2 x float> @llvm.vp.round.nxv2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %7 = call <vscale x 4 x float> @llvm.vp.round.nxv4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %8 = call <vscale x 8 x float> @llvm.vp.round.nxv8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %9 = call <vscale x 16 x float> @llvm.vp.round.nxv16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %10 = call <2 x double> @llvm.vp.round.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %11 = call <4 x double> @llvm.vp.round.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %12 = call <8 x double> @llvm.vp.round.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %13 = call <16 x double> @llvm.vp.round.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %14 = call <vscale x 1 x double> @llvm.vp.round.nxv1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %15 = call <vscale x 2 x double> @llvm.vp.round.nxv2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %16 = call <vscale x 4 x double> @llvm.vp.round.nxv4f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %17 = call <vscale x 8 x double> @llvm.vp.round.nxv8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call <2 x float> @llvm.vp.round.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
  call <4 x float> @llvm.vp.round.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
  call <8 x float> @llvm.vp.round.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
  call <16 x float> @llvm.vp.round.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x float> @llvm.vp.round.nvx1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x float> @llvm.vp.round.nvx2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x float> @llvm.vp.round.nvx4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x float> @llvm.vp.round.nvx8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
  call <vscale x 16 x float> @llvm.vp.round.nvx16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
  call <2 x double> @llvm.vp.round.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
  call <4 x double> @llvm.vp.round.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
  call <8 x double> @llvm.vp.round.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
  call <16 x double> @llvm.vp.round.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x double> @llvm.vp.round.nvx1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x double> @llvm.vp.round.nvx2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x double> @llvm.vp.round.nvx5f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x double> @llvm.vp.round.nvx8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
  ret void
}

define void @vp_roundeven() {
; CHECK-LABEL: 'vp_roundeven'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %1 = call <2 x float> @llvm.vp.roundeven.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %2 = call <4 x float> @llvm.vp.roundeven.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %3 = call <8 x float> @llvm.vp.roundeven.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %4 = call <16 x float> @llvm.vp.roundeven.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %5 = call <vscale x 1 x float> @llvm.vp.roundeven.nxv1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %6 = call <vscale x 2 x float> @llvm.vp.roundeven.nxv2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %7 = call <vscale x 4 x float> @llvm.vp.roundeven.nxv4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %8 = call <vscale x 8 x float> @llvm.vp.roundeven.nxv8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %9 = call <vscale x 16 x float> @llvm.vp.roundeven.nxv16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %10 = call <2 x double> @llvm.vp.roundeven.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %11 = call <4 x double> @llvm.vp.roundeven.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %12 = call <8 x double> @llvm.vp.roundeven.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %13 = call <16 x double> @llvm.vp.roundeven.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %14 = call <vscale x 1 x double> @llvm.vp.roundeven.nxv1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %15 = call <vscale x 2 x double> @llvm.vp.roundeven.nxv2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %16 = call <vscale x 4 x double> @llvm.vp.roundeven.nxv4f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %17 = call <vscale x 8 x double> @llvm.vp.roundeven.nxv8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call <2 x float> @llvm.vp.roundeven.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
  call <4 x float> @llvm.vp.roundeven.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
  call <8 x float> @llvm.vp.roundeven.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
  call <16 x float> @llvm.vp.roundeven.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x float> @llvm.vp.roundeven.nvx1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x float> @llvm.vp.roundeven.nvx2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x float> @llvm.vp.roundeven.nvx4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x float> @llvm.vp.roundeven.nvx8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
  call <vscale x 16 x float> @llvm.vp.roundeven.nvx16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
  call <2 x double> @llvm.vp.roundeven.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
  call <4 x double> @llvm.vp.roundeven.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
  call <8 x double> @llvm.vp.roundeven.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
  call <16 x double> @llvm.vp.roundeven.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x double> @llvm.vp.roundeven.nvx1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x double> @llvm.vp.roundeven.nvx2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x double> @llvm.vp.roundeven.nvx5f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x double> @llvm.vp.roundeven.nvx8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
  ret void
}

define void @vp_roundtozero() {
; CHECK-LABEL: 'vp_roundtozero'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %1 = call <2 x float> @llvm.vp.roundtozero.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %2 = call <4 x float> @llvm.vp.roundtozero.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %3 = call <8 x float> @llvm.vp.roundtozero.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %4 = call <16 x float> @llvm.vp.roundtozero.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %5 = call <vscale x 1 x float> @llvm.vp.roundtozero.nxv1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %6 = call <vscale x 2 x float> @llvm.vp.roundtozero.nxv2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %7 = call <vscale x 4 x float> @llvm.vp.roundtozero.nxv4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %8 = call <vscale x 8 x float> @llvm.vp.roundtozero.nxv8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %9 = call <vscale x 16 x float> @llvm.vp.roundtozero.nxv16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %10 = call <2 x double> @llvm.vp.roundtozero.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %11 = call <4 x double> @llvm.vp.roundtozero.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %12 = call <8 x double> @llvm.vp.roundtozero.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %13 = call <16 x double> @llvm.vp.roundtozero.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %14 = call <vscale x 1 x double> @llvm.vp.roundtozero.nxv1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %15 = call <vscale x 2 x double> @llvm.vp.roundtozero.nxv2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %16 = call <vscale x 4 x double> @llvm.vp.roundtozero.nxv4f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %17 = call <vscale x 8 x double> @llvm.vp.roundtozero.nxv8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call <2 x float> @llvm.vp.roundtozero.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
  call <4 x float> @llvm.vp.roundtozero.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
  call <8 x float> @llvm.vp.roundtozero.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
  call <16 x float> @llvm.vp.roundtozero.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x float> @llvm.vp.roundtozero.nvx1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x float> @llvm.vp.roundtozero.nvx2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x float> @llvm.vp.roundtozero.nvx4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x float> @llvm.vp.roundtozero.nvx8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
  call <vscale x 16 x float> @llvm.vp.roundtozero.nvx16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
  call <2 x double> @llvm.vp.roundtozero.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
  call <4 x double> @llvm.vp.roundtozero.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
  call <8 x double> @llvm.vp.roundtozero.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
  call <16 x double> @llvm.vp.roundtozero.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x double> @llvm.vp.roundtozero.nvx1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x double> @llvm.vp.roundtozero.nvx2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x double> @llvm.vp.roundtozero.nvx5f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x double> @llvm.vp.roundtozero.nvx8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
  ret void
}

define void @vp_rint() {
; CHECK-LABEL: 'vp_rint'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %1 = call <2 x float> @llvm.vp.rint.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %2 = call <4 x float> @llvm.vp.rint.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %3 = call <8 x float> @llvm.vp.rint.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %4 = call <16 x float> @llvm.vp.rint.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %5 = call <vscale x 1 x float> @llvm.vp.rint.nxv1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %6 = call <vscale x 2 x float> @llvm.vp.rint.nxv2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %7 = call <vscale x 4 x float> @llvm.vp.rint.nxv4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %8 = call <vscale x 8 x float> @llvm.vp.rint.nxv8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %9 = call <vscale x 16 x float> @llvm.vp.rint.nxv16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %10 = call <2 x double> @llvm.vp.rint.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %11 = call <4 x double> @llvm.vp.rint.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %12 = call <8 x double> @llvm.vp.rint.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %13 = call <16 x double> @llvm.vp.rint.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %14 = call <vscale x 1 x double> @llvm.vp.rint.nxv1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %15 = call <vscale x 2 x double> @llvm.vp.rint.nxv2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %16 = call <vscale x 4 x double> @llvm.vp.rint.nxv4f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %17 = call <vscale x 8 x double> @llvm.vp.rint.nxv8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call <2 x float> @llvm.vp.rint.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
  call <4 x float> @llvm.vp.rint.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
  call <8 x float> @llvm.vp.rint.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
  call <16 x float> @llvm.vp.rint.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x float> @llvm.vp.rint.nvx1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x float> @llvm.vp.rint.nvx2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x float> @llvm.vp.rint.nvx4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x float> @llvm.vp.rint.nvx8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
  call <vscale x 16 x float> @llvm.vp.rint.nvx16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
  call <2 x double> @llvm.vp.rint.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
  call <4 x double> @llvm.vp.rint.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
  call <8 x double> @llvm.vp.rint.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
  call <16 x double> @llvm.vp.rint.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x double> @llvm.vp.rint.nvx1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x double> @llvm.vp.rint.nvx2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x double> @llvm.vp.rint.nvx5f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x double> @llvm.vp.rint.nvx8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
  ret void
}

define void @vp_nearbyint() {
; CHECK-LABEL: 'vp_nearbyint'
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %1 = call <2 x float> @llvm.vp.nearbyint.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %2 = call <4 x float> @llvm.vp.nearbyint.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %3 = call <8 x float> @llvm.vp.nearbyint.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %4 = call <16 x float> @llvm.vp.nearbyint.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %5 = call <vscale x 1 x float> @llvm.vp.nearbyint.nxv1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %6 = call <vscale x 2 x float> @llvm.vp.nearbyint.nxv2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %7 = call <vscale x 4 x float> @llvm.vp.nearbyint.nxv4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %8 = call <vscale x 8 x float> @llvm.vp.nearbyint.nxv8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %9 = call <vscale x 16 x float> @llvm.vp.nearbyint.nxv16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %10 = call <2 x double> @llvm.vp.nearbyint.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %11 = call <4 x double> @llvm.vp.nearbyint.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %12 = call <8 x double> @llvm.vp.nearbyint.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %13 = call <16 x double> @llvm.vp.nearbyint.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %14 = call <vscale x 1 x double> @llvm.vp.nearbyint.nxv1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %15 = call <vscale x 2 x double> @llvm.vp.nearbyint.nxv2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %16 = call <vscale x 4 x double> @llvm.vp.nearbyint.nxv4f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %17 = call <vscale x 8 x double> @llvm.vp.nearbyint.nxv8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
; CHECK-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret void
;
  call <2 x float> @llvm.vp.nearbyint.v2f32(<2 x float> undef, <2 x i1> undef, i32 undef)
  call <4 x float> @llvm.vp.nearbyint.v4f32(<4 x float> undef, <4 x i1> undef, i32 undef)
  call <8 x float> @llvm.vp.nearbyint.v8f32(<8 x float> undef, <8 x i1> undef, i32 undef)
  call <16 x float> @llvm.vp.nearbyint.v16f32(<16 x float> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x float> @llvm.vp.nearbyint.nvx1f32(<vscale x 1 x float> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x float> @llvm.vp.nearbyint.nvx2f32(<vscale x 2 x float> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x float> @llvm.vp.nearbyint.nvx4f32(<vscale x 4 x float> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x float> @llvm.vp.nearbyint.nvx8f32(<vscale x 8 x float> undef, <vscale x 8 x i1> undef, i32 undef)
  call <vscale x 16 x float> @llvm.vp.nearbyint.nvx16f32(<vscale x 16 x float> undef, <vscale x 16 x i1> undef, i32 undef)
  call <2 x double> @llvm.vp.nearbyint.v2f64(<2 x double> undef, <2 x i1> undef, i32 undef)
  call <4 x double> @llvm.vp.nearbyint.v4f64(<4 x double> undef, <4 x i1> undef, i32 undef)
  call <8 x double> @llvm.vp.nearbyint.v8f64(<8 x double> undef, <8 x i1> undef, i32 undef)
  call <16 x double> @llvm.vp.nearbyint.v16f64(<16 x double> undef, <16 x i1> undef, i32 undef)
  call <vscale x 1 x double> @llvm.vp.nearbyint.nvx1f64(<vscale x 1 x double> undef, <vscale x 1 x i1> undef, i32 undef)
  call <vscale x 2 x double> @llvm.vp.nearbyint.nvx2f64(<vscale x 2 x double> undef, <vscale x 2 x i1> undef, i32 undef)
  call <vscale x 4 x double> @llvm.vp.nearbyint.nvx5f64(<vscale x 4 x double> undef, <vscale x 4 x i1> undef, i32 undef)
  call <vscale x 8 x double> @llvm.vp.nearbyint.nvx8f64(<vscale x 8 x double> undef, <vscale x 8 x i1> undef, i32 undef)
  ret void
}

declare float @llvm.floor.f32(float)
declare <2 x float> @llvm.floor.v2f32(<2 x float>)
declare <4 x float> @llvm.floor.v4f32(<4 x float>)
declare <8 x float> @llvm.floor.v8f32(<8 x float>)
declare <16 x float> @llvm.floor.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.floor.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.floor.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.floor.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.floor.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.floor.nvx16f32(<vscale x 16 x float>)
declare double @llvm.floor.f64(double)
declare <2 x double> @llvm.floor.v2f64(<2 x double>)
declare <4 x double> @llvm.floor.v4f64(<4 x double>)
declare <8 x double> @llvm.floor.v8f64(<8 x double>)
declare <16 x double> @llvm.floor.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.floor.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.floor.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.floor.nvx5f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.floor.nvx8f64(<vscale x 8 x double>)

declare float @llvm.ceil.f32(float)
declare <2 x float> @llvm.ceil.v2f32(<2 x float>)
declare <4 x float> @llvm.ceil.v4f32(<4 x float>)
declare <8 x float> @llvm.ceil.v8f32(<8 x float>)
declare <16 x float> @llvm.ceil.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.ceil.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.ceil.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.ceil.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.ceil.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.ceil.nvx16f32(<vscale x 16 x float>)
declare double @llvm.ceil.f64(double)
declare <2 x double> @llvm.ceil.v2f64(<2 x double>)
declare <4 x double> @llvm.ceil.v4f64(<4 x double>)
declare <8 x double> @llvm.ceil.v8f64(<8 x double>)
declare <16 x double> @llvm.ceil.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.ceil.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.ceil.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.ceil.nvx5f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.ceil.nvx8f64(<vscale x 8 x double>)

declare float @llvm.trunc.f32(float)
declare <2 x float> @llvm.trunc.v2f32(<2 x float>)
declare <4 x float> @llvm.trunc.v4f32(<4 x float>)
declare <8 x float> @llvm.trunc.v8f32(<8 x float>)
declare <16 x float> @llvm.trunc.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.trunc.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.trunc.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.trunc.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.trunc.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.trunc.nvx16f32(<vscale x 16 x float>)
declare double @llvm.trunc.f64(double)
declare <2 x double> @llvm.trunc.v2f64(<2 x double>)
declare <4 x double> @llvm.trunc.v4f64(<4 x double>)
declare <8 x double> @llvm.trunc.v8f64(<8 x double>)
declare <16 x double> @llvm.trunc.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.trunc.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.trunc.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.trunc.nvx5f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.trunc.nvx8f64(<vscale x 8 x double>)

declare float @llvm.rint.f32(float)
declare <2 x float> @llvm.rint.v2f32(<2 x float>)
declare <4 x float> @llvm.rint.v4f32(<4 x float>)
declare <8 x float> @llvm.rint.v8f32(<8 x float>)
declare <16 x float> @llvm.rint.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.rint.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.rint.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.rint.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.rint.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.rint.nvx16f32(<vscale x 16 x float>)
declare double @llvm.rint.f64(double)
declare <2 x double> @llvm.rint.v2f64(<2 x double>)
declare <4 x double> @llvm.rint.v4f64(<4 x double>)
declare <8 x double> @llvm.rint.v8f64(<8 x double>)
declare <16 x double> @llvm.rint.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.rint.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.rint.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.rint.nvx5f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.rint.nvx8f64(<vscale x 8 x double>)

declare float @llvm.nearbyint.f32(float)
declare <2 x float> @llvm.nearbyint.v2f32(<2 x float>)
declare <4 x float> @llvm.nearbyint.v4f32(<4 x float>)
declare <8 x float> @llvm.nearbyint.v8f32(<8 x float>)
declare <16 x float> @llvm.nearbyint.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.nearbyint.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.nearbyint.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.nearbyint.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.nearbyint.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.nearbyint.nvx16f32(<vscale x 16 x float>)
declare double @llvm.nearbyint.f64(double)
declare <2 x double> @llvm.nearbyint.v2f64(<2 x double>)
declare <4 x double> @llvm.nearbyint.v4f64(<4 x double>)
declare <8 x double> @llvm.nearbyint.v8f64(<8 x double>)
declare <16 x double> @llvm.nearbyint.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.nearbyint.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.nearbyint.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.nearbyint.nvx5f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.nearbyint.nvx8f64(<vscale x 8 x double>)

declare float @llvm.round.f32(float)
declare <2 x float> @llvm.round.v2f32(<2 x float>)
declare <4 x float> @llvm.round.v4f32(<4 x float>)
declare <8 x float> @llvm.round.v8f32(<8 x float>)
declare <16 x float> @llvm.round.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.round.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.round.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.round.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.round.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.round.nvx16f32(<vscale x 16 x float>)
declare double @llvm.round.f64(double)
declare <2 x double> @llvm.round.v2f64(<2 x double>)
declare <4 x double> @llvm.round.v4f64(<4 x double>)
declare <8 x double> @llvm.round.v8f64(<8 x double>)
declare <16 x double> @llvm.round.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.round.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.round.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.round.nvx5f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.round.nvx8f64(<vscale x 8 x double>)

declare float @llvm.roundeven.f32(float)
declare <2 x float> @llvm.roundeven.v2f32(<2 x float>)
declare <4 x float> @llvm.roundeven.v4f32(<4 x float>)
declare <8 x float> @llvm.roundeven.v8f32(<8 x float>)
declare <16 x float> @llvm.roundeven.v16f32(<16 x float>)
declare <vscale x 1 x float> @llvm.roundeven.nvx1f32(<vscale x 1 x float>)
declare <vscale x 2 x float> @llvm.roundeven.nvx2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.roundeven.nvx4f32(<vscale x 4 x float>)
declare <vscale x 8 x float> @llvm.roundeven.nvx8f32(<vscale x 8 x float>)
declare <vscale x 16 x float> @llvm.roundeven.nvx16f32(<vscale x 16 x float>)
declare double @llvm.roundeven.f64(double)
declare <2 x double> @llvm.roundeven.v2f64(<2 x double>)
declare <4 x double> @llvm.roundeven.v4f64(<4 x double>)
declare <8 x double> @llvm.roundeven.v8f64(<8 x double>)
declare <16 x double> @llvm.roundeven.v16f64(<16 x double>)
declare <vscale x 1 x double> @llvm.roundeven.nvx1f64(<vscale x 1 x double>)
declare <vscale x 2 x double> @llvm.roundeven.nvx2f64(<vscale x 2 x double>)
declare <vscale x 4 x double> @llvm.roundeven.nvx5f64(<vscale x 4 x double>)
declare <vscale x 8 x double> @llvm.roundeven.nvx8f64(<vscale x 8 x double>)

declare <2 x float> @llvm.vp.ceil.v2f32(<2 x float>, <2 x i1>, i32)
declare <4 x float> @llvm.vp.ceil.v4f32(<4 x float>, <4 x i1>, i32)
declare <8 x float> @llvm.vp.ceil.v8f32(<8 x float>, <8 x i1>, i32)
declare <16 x float> @llvm.vp.ceil.v16f32(<16 x float>, <16 x i1>, i32)
declare <vscale x 1 x float> @llvm.vp.ceil.nvx1f32(<vscale x 1 x float>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x float> @llvm.vp.ceil.nvx2f32(<vscale x 2 x float>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x float> @llvm.vp.ceil.nvx4f32(<vscale x 4 x float>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x float> @llvm.vp.ceil.nvx8f32(<vscale x 8 x float>, <vscale x 8 x i1>, i32)
declare <vscale x 16 x float> @llvm.vp.ceil.nvx16f32(<vscale x 16 x float>, <vscale x 16 x i1>, i32)
declare double @llvm.vp.ceil.f64(double)
declare <2 x double> @llvm.vp.ceil.v2f64(<2 x double>, <2 x i1>, i32)
declare <4 x double> @llvm.vp.ceil.v4f64(<4 x double>, <4 x i1>, i32)
declare <8 x double> @llvm.vp.ceil.v8f64(<8 x double>, <8 x i1>, i32)
declare <16 x double> @llvm.vp.ceil.v16f64(<16 x double>, <16 x i1>, i32)
declare <vscale x 1 x double> @llvm.vp.ceil.nvx1f64(<vscale x 1 x double>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x double> @llvm.vp.ceil.nvx2f64(<vscale x 2 x double>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x double> @llvm.vp.ceil.nvx5f64(<vscale x 4 x double>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x double> @llvm.vp.ceil.nvx8f64(<vscale x 8 x double>, <vscale x 8 x i1>, i32)

declare <2 x float> @llvm.vp.floor.v2f32(<2 x float>, <2 x i1>, i32)
declare <4 x float> @llvm.vp.floor.v4f32(<4 x float>, <4 x i1>, i32)
declare <8 x float> @llvm.vp.floor.v8f32(<8 x float>, <8 x i1>, i32)
declare <16 x float> @llvm.vp.floor.v16f32(<16 x float>, <16 x i1>, i32)
declare <vscale x 1 x float> @llvm.vp.floor.nvx1f32(<vscale x 1 x float>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x float> @llvm.vp.floor.nvx2f32(<vscale x 2 x float>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x float> @llvm.vp.floor.nvx4f32(<vscale x 4 x float>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x float> @llvm.vp.floor.nvx8f32(<vscale x 8 x float>, <vscale x 8 x i1>, i32)
declare <vscale x 16 x float> @llvm.vp.floor.nvx16f32(<vscale x 16 x float>, <vscale x 16 x i1>, i32)
declare double @llvm.vp.floor.f64(double)
declare <2 x double> @llvm.vp.floor.v2f64(<2 x double>, <2 x i1>, i32)
declare <4 x double> @llvm.vp.floor.v4f64(<4 x double>, <4 x i1>, i32)
declare <8 x double> @llvm.vp.floor.v8f64(<8 x double>, <8 x i1>, i32)
declare <16 x double> @llvm.vp.floor.v16f64(<16 x double>, <16 x i1>, i32)
declare <vscale x 1 x double> @llvm.vp.floor.nvx1f64(<vscale x 1 x double>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x double> @llvm.vp.floor.nvx2f64(<vscale x 2 x double>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x double> @llvm.vp.floor.nvx5f64(<vscale x 4 x double>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x double> @llvm.vp.floor.nvx8f64(<vscale x 8 x double>, <vscale x 8 x i1>, i32)

declare <2 x float> @llvm.vp.round.v2f32(<2 x float>, <2 x i1>, i32)
declare <4 x float> @llvm.vp.round.v4f32(<4 x float>, <4 x i1>, i32)
declare <8 x float> @llvm.vp.round.v8f32(<8 x float>, <8 x i1>, i32)
declare <16 x float> @llvm.vp.round.v16f32(<16 x float>, <16 x i1>, i32)
declare <vscale x 1 x float> @llvm.vp.round.nvx1f32(<vscale x 1 x float>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x float> @llvm.vp.round.nvx2f32(<vscale x 2 x float>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x float> @llvm.vp.round.nvx4f32(<vscale x 4 x float>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x float> @llvm.vp.round.nvx8f32(<vscale x 8 x float>, <vscale x 8 x i1>, i32)
declare <vscale x 16 x float> @llvm.vp.round.nvx16f32(<vscale x 16 x float>, <vscale x 16 x i1>, i32)
declare double @llvm.vp.round.f64(double)
declare <2 x double> @llvm.vp.round.v2f64(<2 x double>, <2 x i1>, i32)
declare <4 x double> @llvm.vp.round.v4f64(<4 x double>, <4 x i1>, i32)
declare <8 x double> @llvm.vp.round.v8f64(<8 x double>, <8 x i1>, i32)
declare <16 x double> @llvm.vp.round.v16f64(<16 x double>, <16 x i1>, i32)
declare <vscale x 1 x double> @llvm.vp.round.nvx1f64(<vscale x 1 x double>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x double> @llvm.vp.round.nvx2f64(<vscale x 2 x double>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x double> @llvm.vp.round.nvx5f64(<vscale x 4 x double>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x double> @llvm.vp.round.nvx8f64(<vscale x 8 x double>, <vscale x 8 x i1>, i32)

declare <2 x float> @llvm.vp.roundeven.v2f32(<2 x float>, <2 x i1>, i32)
declare <4 x float> @llvm.vp.roundeven.v4f32(<4 x float>, <4 x i1>, i32)
declare <8 x float> @llvm.vp.roundeven.v8f32(<8 x float>, <8 x i1>, i32)
declare <16 x float> @llvm.vp.roundeven.v16f32(<16 x float>, <16 x i1>, i32)
declare <vscale x 1 x float> @llvm.vp.roundeven.nvx1f32(<vscale x 1 x float>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x float> @llvm.vp.roundeven.nvx2f32(<vscale x 2 x float>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x float> @llvm.vp.roundeven.nvx4f32(<vscale x 4 x float>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x float> @llvm.vp.roundeven.nvx8f32(<vscale x 8 x float>, <vscale x 8 x i1>, i32)
declare <vscale x 16 x float> @llvm.vp.roundeven.nvx16f32(<vscale x 16 x float>, <vscale x 16 x i1>, i32)
declare double @llvm.vp.roundeven.f64(double)
declare <2 x double> @llvm.vp.roundeven.v2f64(<2 x double>, <2 x i1>, i32)
declare <4 x double> @llvm.vp.roundeven.v4f64(<4 x double>, <4 x i1>, i32)
declare <8 x double> @llvm.vp.roundeven.v8f64(<8 x double>, <8 x i1>, i32)
declare <16 x double> @llvm.vp.roundeven.v16f64(<16 x double>, <16 x i1>, i32)
declare <vscale x 1 x double> @llvm.vp.roundeven.nvx1f64(<vscale x 1 x double>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x double> @llvm.vp.roundeven.nvx2f64(<vscale x 2 x double>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x double> @llvm.vp.roundeven.nvx5f64(<vscale x 4 x double>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x double> @llvm.vp.roundeven.nvx8f64(<vscale x 8 x double>, <vscale x 8 x i1>, i32)

declare <2 x float> @llvm.vp.roundtozero.v2f32(<2 x float>, <2 x i1>, i32)
declare <4 x float> @llvm.vp.roundtozero.v4f32(<4 x float>, <4 x i1>, i32)
declare <8 x float> @llvm.vp.roundtozero.v8f32(<8 x float>, <8 x i1>, i32)
declare <16 x float> @llvm.vp.roundtozero.v16f32(<16 x float>, <16 x i1>, i32)
declare <vscale x 1 x float> @llvm.vp.roundtozero.nvx1f32(<vscale x 1 x float>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x float> @llvm.vp.roundtozero.nvx2f32(<vscale x 2 x float>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x float> @llvm.vp.roundtozero.nvx4f32(<vscale x 4 x float>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x float> @llvm.vp.roundtozero.nvx8f32(<vscale x 8 x float>, <vscale x 8 x i1>, i32)
declare <vscale x 16 x float> @llvm.vp.roundtozero.nvx16f32(<vscale x 16 x float>, <vscale x 16 x i1>, i32)
declare double @llvm.vp.roundtozero.f64(double)
declare <2 x double> @llvm.vp.roundtozero.v2f64(<2 x double>, <2 x i1>, i32)
declare <4 x double> @llvm.vp.roundtozero.v4f64(<4 x double>, <4 x i1>, i32)
declare <8 x double> @llvm.vp.roundtozero.v8f64(<8 x double>, <8 x i1>, i32)
declare <16 x double> @llvm.vp.roundtozero.v16f64(<16 x double>, <16 x i1>, i32)
declare <vscale x 1 x double> @llvm.vp.roundtozero.nvx1f64(<vscale x 1 x double>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x double> @llvm.vp.roundtozero.nvx2f64(<vscale x 2 x double>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x double> @llvm.vp.roundtozero.nvx5f64(<vscale x 4 x double>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x double> @llvm.vp.roundtozero.nvx8f64(<vscale x 8 x double>, <vscale x 8 x i1>, i32)

declare <2 x float> @llvm.vp.rint.v2f32(<2 x float>, <2 x i1>, i32)
declare <4 x float> @llvm.vp.rint.v4f32(<4 x float>, <4 x i1>, i32)
declare <8 x float> @llvm.vp.rint.v8f32(<8 x float>, <8 x i1>, i32)
declare <16 x float> @llvm.vp.rint.v16f32(<16 x float>, <16 x i1>, i32)
declare <vscale x 1 x float> @llvm.vp.rint.nvx1f32(<vscale x 1 x float>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x float> @llvm.vp.rint.nvx2f32(<vscale x 2 x float>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x float> @llvm.vp.rint.nvx4f32(<vscale x 4 x float>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x float> @llvm.vp.rint.nvx8f32(<vscale x 8 x float>, <vscale x 8 x i1>, i32)
declare <vscale x 16 x float> @llvm.vp.rint.nvx16f32(<vscale x 16 x float>, <vscale x 16 x i1>, i32)
declare double @llvm.vp.rint.f64(double)
declare <2 x double> @llvm.vp.rint.v2f64(<2 x double>, <2 x i1>, i32)
declare <4 x double> @llvm.vp.rint.v4f64(<4 x double>, <4 x i1>, i32)
declare <8 x double> @llvm.vp.rint.v8f64(<8 x double>, <8 x i1>, i32)
declare <16 x double> @llvm.vp.rint.v16f64(<16 x double>, <16 x i1>, i32)
declare <vscale x 1 x double> @llvm.vp.rint.nvx1f64(<vscale x 1 x double>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x double> @llvm.vp.rint.nvx2f64(<vscale x 2 x double>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x double> @llvm.vp.rint.nvx5f64(<vscale x 4 x double>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x double> @llvm.vp.rint.nvx8f64(<vscale x 8 x double>, <vscale x 8 x i1>, i32)

declare <2 x float> @llvm.vp.nearbyint.v2f32(<2 x float>, <2 x i1>, i32)
declare <4 x float> @llvm.vp.nearbyint.v4f32(<4 x float>, <4 x i1>, i32)
declare <8 x float> @llvm.vp.nearbyint.v8f32(<8 x float>, <8 x i1>, i32)
declare <16 x float> @llvm.vp.nearbyint.v16f32(<16 x float>, <16 x i1>, i32)
declare <vscale x 1 x float> @llvm.vp.nearbyint.nvx1f32(<vscale x 1 x float>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x float> @llvm.vp.nearbyint.nvx2f32(<vscale x 2 x float>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x float> @llvm.vp.nearbyint.nvx4f32(<vscale x 4 x float>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x float> @llvm.vp.nearbyint.nvx8f32(<vscale x 8 x float>, <vscale x 8 x i1>, i32)
declare <vscale x 16 x float> @llvm.vp.nearbyint.nvx16f32(<vscale x 16 x float>, <vscale x 16 x i1>, i32)
declare double @llvm.vp.nearbyint.f64(double)
declare <2 x double> @llvm.vp.nearbyint.v2f64(<2 x double>, <2 x i1>, i32)
declare <4 x double> @llvm.vp.nearbyint.v4f64(<4 x double>, <4 x i1>, i32)
declare <8 x double> @llvm.vp.nearbyint.v8f64(<8 x double>, <8 x i1>, i32)
declare <16 x double> @llvm.vp.nearbyint.v16f64(<16 x double>, <16 x i1>, i32)
declare <vscale x 1 x double> @llvm.vp.nearbyint.nvx1f64(<vscale x 1 x double>, <vscale x 1 x i1>, i32)
declare <vscale x 2 x double> @llvm.vp.nearbyint.nvx2f64(<vscale x 2 x double>, <vscale x 2 x i1>, i32)
declare <vscale x 4 x double> @llvm.vp.nearbyint.nvx5f64(<vscale x 4 x double>, <vscale x 4 x i1>, i32)
declare <vscale x 8 x double> @llvm.vp.nearbyint.nvx8f64(<vscale x 8 x double>, <vscale x 8 x i1>, i32)
