; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; NOTE: The SelectionDAG checks have been added by hand.

; RUN: llc < %s -mtriple=mips-linux-gnu -verify-machineinstrs  \
; RUN:   | FileCheck %s --check-prefix=O32
; RUN: llc < %s -mtriple=mips64-linux-gnu -target-abi n32 -verify-machineinstrs \
; RUN:    | FileCheck %s --check-prefix=N32
; RUN: llc < %s -mtriple=mips64-linux-gnu -target-abi n64 -verify-machineinstrs \
; RUN:    | FileCheck %s --check-prefix=N64

; RUN: llc < %s -mtriple=mips-linux-gnu -verify-machineinstrs -debug 2>&1 \
; RUN:   | FileCheck %s --check-prefix=O32-SDAG
; RUN: llc < %s -mtriple=mips64-linux-gnu -target-abi n32 -verify-machineinstrs \
; RUN:   -debug 2>&1 | FileCheck %s --check-prefix=N32-SDAG
; RUN: llc < %s -mtriple=mips64-linux-gnu -target-abi n64 -verify-machineinstrs \
; RUN:   -debug 2>&1 | FileCheck %s --check-prefix=N64-SDAG

; REQUIRES: asserts

; Test that reserved argument area is shared between the memcpy call and the
; call to f2. This eliminates the nested call sequence nodes.

; Also, test that a basic call to memcpy reserves its outgoing argument area.

; FIXME: We should also be explicit about testing that the loads for the
;        arguments are scheduled after the memcpy, but that wasn't enforced in
;        this patch.

%struct.S1 = type { [65520 x i8] }

; O32-SDAG-LABEL: Initial selection DAG: %bb.0 'g:entry'
; O32-SDAG: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i32<{{.*}}>
; O32-SDAG-NOT: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i32<{{.*}}>
; O32-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetExternalSymbol:i32'memcpy'
; O32-SDAG-NOT: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i32<{{.*}}>
; O32-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetGlobalAddress:i32<ptr @f2>
; O32-SDAG: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i32<{{.*}}>

; N32-SDAG-LABEL: Initial selection DAG: %bb.0 'g:entry'
; N32-SDAG: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i32<{{.*}}>
; N32-SDAG-NOT: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i32<{{.*}}>
; N32-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetExternalSymbol:i32'memcpy'
; N32-SDAG-NOT: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i32<{{.*}}>
; N32-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetGlobalAddress:i32<ptr @f2>
; N32-SDAG: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i32<{{.*}}>

; N64-SDAG-LABEL: Initial selection DAG: %bb.0 'g:entry'
; N64-SDAG: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i64<{{.*}}>
; N64-SDAG-NOT: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i64<{{.*}}>
; N64-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetExternalSymbol:i64'memcpy'
; N64-SDAG-NOT: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i64<{{.*}}>
; N64-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetGlobalAddress:i64<ptr @f2>
; N64-SDAG: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i64<{{.*}}>

define dso_local void @g() #0 {
; O32-LABEL: g:
; O32:       # %bb.0: # %entry
; O32-NEXT:    lui $1, 1
; O32-NEXT:    subu $sp, $sp, $1
; O32-NEXT:    .cfi_def_cfa_offset 65536
; O32-NEXT:    lui $1, 1
; O32-NEXT:    addu $1, $sp, $1
; O32-NEXT:    sw $ra, -4($1) # 4-byte Folded Spill
; O32-NEXT:    .cfi_offset 31, -4
; O32-NEXT:    ori $1, $zero, 65520
; O32-NEXT:    subu $sp, $sp, $1
; O32-NEXT:    addiu $1, $sp, 8
; O32-NEXT:    addiu $5, $1, 16
; O32-NEXT:    addiu $4, $sp, 16
; O32-NEXT:    jal memcpy
; O32-NEXT:    ori $6, $zero, 65504
; O32-NEXT:    lw $7, 20($sp)
; O32-NEXT:    lw $6, 16($sp)
; O32-NEXT:    lw $5, 12($sp)
; O32-NEXT:    jal f2
; O32-NEXT:    lw $4, 8($sp)
; O32-NEXT:    ori $1, $zero, 65520
; O32-NEXT:    addu $sp, $sp, $1
; O32-NEXT:    lui $1, 1
; O32-NEXT:    addu $1, $sp, $1
; O32-NEXT:    lw $ra, -4($1) # 4-byte Folded Reload
; O32-NEXT:    lui $1, 1
; O32-NEXT:    jr $ra
; O32-NEXT:    addu $sp, $sp, $1
;
; N32-LABEL: g:
; N32:       # %bb.0: # %entry
; N32-NEXT:    lui $1, 1
; N32-NEXT:    subu $sp, $sp, $1
; N32-NEXT:    .cfi_def_cfa_offset 65536
; N32-NEXT:    lui $1, 1
; N32-NEXT:    addu $1, $sp, $1
; N32-NEXT:    sd $ra, -8($1) # 8-byte Folded Spill
; N32-NEXT:    .cfi_offset 31, -8
; N32-NEXT:    ori $1, $zero, 65456
; N32-NEXT:    subu $sp, $sp, $1
; N32-NEXT:    addiu $1, $sp, 8
; N32-NEXT:    addiu $5, $1, 64
; N32-NEXT:    ori $6, $zero, 65456
; N32-NEXT:    jal memcpy
; N32-NEXT:    move $4, $sp
; N32-NEXT:    ld $11, 64($sp)
; N32-NEXT:    ld $10, 56($sp)
; N32-NEXT:    ld $9, 48($sp)
; N32-NEXT:    ld $8, 40($sp)
; N32-NEXT:    ld $7, 32($sp)
; N32-NEXT:    ld $6, 24($sp)
; N32-NEXT:    ld $5, 16($sp)
; N32-NEXT:    jal f2
; N32-NEXT:    ld $4, 8($sp)
; N32-NEXT:    ori $1, $zero, 65456
; N32-NEXT:    addu $sp, $sp, $1
; N32-NEXT:    lui $1, 1
; N32-NEXT:    addu $1, $sp, $1
; N32-NEXT:    ld $ra, -8($1) # 8-byte Folded Reload
; N32-NEXT:    lui $1, 1
; N32-NEXT:    jr $ra
; N32-NEXT:    addu $sp, $sp, $1
;
; N64-LABEL: g:
; N64:       # %bb.0: # %entry
; N64-NEXT:    lui $1, 1
; N64-NEXT:    dsubu $sp, $sp, $1
; N64-NEXT:    .cfi_def_cfa_offset 65536
; N64-NEXT:    lui $1, 1
; N64-NEXT:    daddu $1, $sp, $1
; N64-NEXT:    sd $ra, -8($1) # 8-byte Folded Spill
; N64-NEXT:    .cfi_offset 31, -8
; N64-NEXT:    ori $1, $zero, 65456
; N64-NEXT:    dsubu $sp, $sp, $1
; N64-NEXT:    daddiu $1, $sp, 8
; N64-NEXT:    daddiu $5, $1, 64
; N64-NEXT:    ori $6, $zero, 65456
; N64-NEXT:    jal memcpy
; N64-NEXT:    move $4, $sp
; N64-NEXT:    ld $11, 64($sp)
; N64-NEXT:    ld $10, 56($sp)
; N64-NEXT:    ld $9, 48($sp)
; N64-NEXT:    ld $8, 40($sp)
; N64-NEXT:    ld $7, 32($sp)
; N64-NEXT:    ld $6, 24($sp)
; N64-NEXT:    ld $5, 16($sp)
; N64-NEXT:    jal f2
; N64-NEXT:    ld $4, 8($sp)
; N64-NEXT:    ori $1, $zero, 65456
; N64-NEXT:    daddu $sp, $sp, $1
; N64-NEXT:    lui $1, 1
; N64-NEXT:    daddu $1, $sp, $1
; N64-NEXT:    ld $ra, -8($1) # 8-byte Folded Reload
; N64-NEXT:    lui $1, 1
; N64-NEXT:    jr $ra
; N64-NEXT:    daddu $sp, $sp, $1
entry:
  %a = alloca %struct.S1, align 4
  call void @f2(ptr byval(%struct.S1) align 4 %a)
  ret void
}

declare dso_local void @f2(ptr byval(%struct.S1) align 4) #1

; O32-SDAG-LABEL: Initial selection DAG: %bb.0 'g2:entry'
; O32-SDAG: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i32<{{.*}}>
; O32-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetExternalSymbol:i32'memcpy'
; O32-SDAG: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i32<{{.*}}>
; O32-SDAG: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i32<{{.*}}>
; O32-SDAG-NOT: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i32<{{.*}}>
; O32-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetExternalSymbol:i32'memcpy'
; O32-SDAG-NOT: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i32<{{.*}}>
; O32-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetGlobalAddress:i32<ptr @f2>
; O32-SDAG: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i32<{{.*}}>

; N32-SDAG-LABEL: Initial selection DAG: %bb.0 'g2:entry'
; N32-SDAG: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i32<{{.*}}>
; N32-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetExternalSymbol:i32'memcpy'
; N32-SDAG: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i32<{{.*}}>
; N32-SDAG: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i32<{{.*}}>
; N32-SDAG-NOT: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i32<{{.*}}>
; N32-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetExternalSymbol:i32'memcpy'
; N32-SDAG-NOT: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i32<{{.*}}>
; N32-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetGlobalAddress:i32<ptr @f2>
; N32-SDAG: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i32<{{.*}}>

; N64-SDAG-LABEL: Initial selection DAG: %bb.0 'g2:entry'
; N64-SDAG: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i64<{{.*}}>
; N64-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetExternalSymbol:i64'memcpy'
; N64-SDAG: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i64<{{.*}}>
; N64-SDAG: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i64<{{.*}}>
; N64-SDAG-NOT: t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i64<{{.*}}>
; N64-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetExternalSymbol:i64'memcpy'
; N64-SDAG-NOT: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i64<{{.*}}>
; N64-SDAG: t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetGlobalAddress:i64<ptr @f2>
; N64-SDAG: t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i64<{{.*}}>

define dso_local void @g2(ptr %a) {
; O32-LABEL: g2:
; O32:       # %bb.0: # %entry
; O32-NEXT:    lui $1, 1
; O32-NEXT:    addiu $1, $1, 8
; O32-NEXT:    subu $sp, $sp, $1
; O32-NEXT:    .cfi_def_cfa_offset 65544
; O32-NEXT:    lui $1, 1
; O32-NEXT:    addu $1, $sp, $1
; O32-NEXT:    sw $ra, 4($1) # 4-byte Folded Spill
; O32-NEXT:    lui $1, 1
; O32-NEXT:    addu $1, $sp, $1
; O32-NEXT:    sw $16, 0($1) # 4-byte Folded Spill
; O32-NEXT:    .cfi_offset 31, -4
; O32-NEXT:    .cfi_offset 16, -8
; O32-NEXT:    move $5, $4
; O32-NEXT:    lui $1, 1
; O32-NEXT:    addu $1, $sp, $1
; O32-NEXT:    sw $4, -4($1)
; O32-NEXT:    addiu $sp, $sp, -16
; O32-NEXT:    addiu $16, $sp, 8
; O32-NEXT:    ori $6, $zero, 65520
; O32-NEXT:    jal memcpy
; O32-NEXT:    move $4, $16
; O32-NEXT:    addiu $sp, $sp, 16
; O32-NEXT:    ori $1, $zero, 65520
; O32-NEXT:    subu $sp, $sp, $1
; O32-NEXT:    addiu $5, $16, 16
; O32-NEXT:    addiu $4, $sp, 16
; O32-NEXT:    jal memcpy
; O32-NEXT:    ori $6, $zero, 65504
; O32-NEXT:    lw $7, 20($sp)
; O32-NEXT:    lw $6, 16($sp)
; O32-NEXT:    lw $5, 12($sp)
; O32-NEXT:    jal f2
; O32-NEXT:    lw $4, 8($sp)
; O32-NEXT:    ori $1, $zero, 65520
; O32-NEXT:    addu $sp, $sp, $1
; O32-NEXT:    lui $1, 1
; O32-NEXT:    addu $1, $sp, $1
; O32-NEXT:    lw $16, 0($1) # 4-byte Folded Reload
; O32-NEXT:    lui $1, 1
; O32-NEXT:    addu $1, $sp, $1
; O32-NEXT:    lw $ra, 4($1) # 4-byte Folded Reload
; O32-NEXT:    lui $1, 1
; O32-NEXT:    addiu $1, $1, 8
; O32-NEXT:    jr $ra
; O32-NEXT:    addu $sp, $sp, $1
;
; N32-LABEL: g2:
; N32:       # %bb.0: # %entry
; N32-NEXT:    lui $1, 1
; N32-NEXT:    addiu $1, $1, 16
; N32-NEXT:    subu $sp, $sp, $1
; N32-NEXT:    .cfi_def_cfa_offset 65552
; N32-NEXT:    lui $1, 1
; N32-NEXT:    addu $1, $sp, $1
; N32-NEXT:    sd $ra, 8($1) # 8-byte Folded Spill
; N32-NEXT:    lui $1, 1
; N32-NEXT:    addu $1, $sp, $1
; N32-NEXT:    sd $16, 0($1) # 8-byte Folded Spill
; N32-NEXT:    .cfi_offset 31, -8
; N32-NEXT:    .cfi_offset 16, -16
; N32-NEXT:    move $5, $4
; N32-NEXT:    lui $1, 1
; N32-NEXT:    addu $1, $sp, $1
; N32-NEXT:    sw $4, -4($1)
; N32-NEXT:    addiu $16, $sp, 8
; N32-NEXT:    ori $6, $zero, 65520
; N32-NEXT:    jal memcpy
; N32-NEXT:    move $4, $16
; N32-NEXT:    addiu $5, $16, 64
; N32-NEXT:    ori $1, $zero, 65456
; N32-NEXT:    subu $sp, $sp, $1
; N32-NEXT:    ori $6, $zero, 65456
; N32-NEXT:    jal memcpy
; N32-NEXT:    move $4, $sp
; N32-NEXT:    ld $11, 64($sp)
; N32-NEXT:    ld $10, 56($sp)
; N32-NEXT:    ld $9, 48($sp)
; N32-NEXT:    ld $8, 40($sp)
; N32-NEXT:    ld $7, 32($sp)
; N32-NEXT:    ld $6, 24($sp)
; N32-NEXT:    ld $5, 16($sp)
; N32-NEXT:    jal f2
; N32-NEXT:    ld $4, 8($sp)
; N32-NEXT:    ori $1, $zero, 65456
; N32-NEXT:    addu $sp, $sp, $1
; N32-NEXT:    lui $1, 1
; N32-NEXT:    addu $1, $sp, $1
; N32-NEXT:    ld $16, 0($1) # 8-byte Folded Reload
; N32-NEXT:    lui $1, 1
; N32-NEXT:    addu $1, $sp, $1
; N32-NEXT:    ld $ra, 8($1) # 8-byte Folded Reload
; N32-NEXT:    lui $1, 1
; N32-NEXT:    addiu $1, $1, 16
; N32-NEXT:    jr $ra
; N32-NEXT:    addu $sp, $sp, $1
;
; N64-LABEL: g2:
; N64:       # %bb.0: # %entry
; N64-NEXT:    lui $1, 1
; N64-NEXT:    daddiu $1, $1, 16
; N64-NEXT:    dsubu $sp, $sp, $1
; N64-NEXT:    .cfi_def_cfa_offset 65552
; N64-NEXT:    lui $1, 1
; N64-NEXT:    daddu $1, $sp, $1
; N64-NEXT:    sd $ra, 8($1) # 8-byte Folded Spill
; N64-NEXT:    lui $1, 1
; N64-NEXT:    daddu $1, $sp, $1
; N64-NEXT:    sd $16, 0($1) # 8-byte Folded Spill
; N64-NEXT:    .cfi_offset 31, -8
; N64-NEXT:    .cfi_offset 16, -16
; N64-NEXT:    move $5, $4
; N64-NEXT:    lui $1, 1
; N64-NEXT:    daddu $1, $sp, $1
; N64-NEXT:    sd $4, -8($1)
; N64-NEXT:    daddiu $16, $sp, 8
; N64-NEXT:    ori $6, $zero, 65520
; N64-NEXT:    jal memcpy
; N64-NEXT:    move $4, $16
; N64-NEXT:    ori $1, $zero, 65456
; N64-NEXT:    dsubu $sp, $sp, $1
; N64-NEXT:    daddiu $5, $16, 64
; N64-NEXT:    ori $6, $zero, 65456
; N64-NEXT:    jal memcpy
; N64-NEXT:    move $4, $sp
; N64-NEXT:    ld $11, 64($sp)
; N64-NEXT:    ld $10, 56($sp)
; N64-NEXT:    ld $9, 48($sp)
; N64-NEXT:    ld $8, 40($sp)
; N64-NEXT:    ld $7, 32($sp)
; N64-NEXT:    ld $6, 24($sp)
; N64-NEXT:    ld $5, 16($sp)
; N64-NEXT:    jal f2
; N64-NEXT:    ld $4, 8($sp)
; N64-NEXT:    ori $1, $zero, 65456
; N64-NEXT:    daddu $sp, $sp, $1
; N64-NEXT:    lui $1, 1
; N64-NEXT:    daddu $1, $sp, $1
; N64-NEXT:    ld $16, 0($1) # 8-byte Folded Reload
; N64-NEXT:    lui $1, 1
; N64-NEXT:    daddu $1, $sp, $1
; N64-NEXT:    ld $ra, 8($1) # 8-byte Folded Reload
; N64-NEXT:    lui $1, 1
; N64-NEXT:    daddiu $1, $1, 16
; N64-NEXT:    jr $ra
; N64-NEXT:    daddu $sp, $sp, $1
entry:
  %a.addr = alloca ptr, align 4
  %byval-temp = alloca %struct.S1, align 4
  store ptr %a, ptr %a.addr, align 4
  %0 = load ptr, ptr %a.addr, align 4
  call void @llvm.memcpy.p0.p0.i32(ptr align 4 %byval-temp, ptr align 1 %0, i32 65520, i1 false)
  call void @f2(ptr byval(%struct.S1) align 4 %byval-temp)
  ret void
}

; O32-SDAG-LABEL: Initial selection DAG: %bb.0 'g3:entry'
; O32-SDAG:   t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i32<16>
; O32-SDAG:   t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetExternalSymbol:i32'memcpy'
; O32-SDAG:   t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i32<16>

; N32-SDAG-LABEL: Initial selection DAG: %bb.0 'g3:entry'
; N32-SDAG:   t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i32<0>
; N32-SDAG:   t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetExternalSymbol:i32'memcpy'
; N32-SDAG:   t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i32<0>

; N64-SDAG-LABEL: Initial selection DAG: %bb.0 'g3:entry'
; N64-SDAG:   t{{.*}}: ch,glue = callseq_start t{{.*}}, TargetConstant:i64<0>
; N64-SDAG:   t{{.*}}: ch,glue = MipsISD::JmpLink t{{.*}}, TargetExternalSymbol:i64'memcpy'
; N64-SDAG:   t{{.*}}: ch,glue = callseq_end t{{.*}}, TargetConstant:i64<0>

define dso_local i32 @g3(ptr %a, ptr %b) #0 {
; O32-LABEL: g3:
; O32:       # %bb.0: # %entry
; O32-NEXT:    addiu $sp, $sp, -32
; O32-NEXT:    .cfi_def_cfa_offset 32
; O32-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; O32-NEXT:    .cfi_offset 31, -4
; O32-NEXT:    sw $5, 20($sp)
; O32-NEXT:    sw $4, 24($sp)
; O32-NEXT:    jal memcpy
; O32-NEXT:    ori $6, $zero, 65520
; O32-NEXT:    addiu $2, $zero, 4
; O32-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; O32-NEXT:    jr $ra
; O32-NEXT:    addiu $sp, $sp, 32
;
; N32-LABEL: g3:
; N32:       # %bb.0: # %entry
; N32-NEXT:    addiu $sp, $sp, -16
; N32-NEXT:    .cfi_def_cfa_offset 16
; N32-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; N32-NEXT:    .cfi_offset 31, -8
; N32-NEXT:    sw $5, 0($sp)
; N32-NEXT:    sw $4, 4($sp)
; N32-NEXT:    jal memcpy
; N32-NEXT:    ori $6, $zero, 65520
; N32-NEXT:    addiu $2, $zero, 4
; N32-NEXT:    ld $ra, 8($sp) # 8-byte Folded Reload
; N32-NEXT:    jr $ra
; N32-NEXT:    addiu $sp, $sp, 16
;
; N64-LABEL: g3:
; N64:       # %bb.0: # %entry
; N64-NEXT:    daddiu $sp, $sp, -32
; N64-NEXT:    .cfi_def_cfa_offset 32
; N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; N64-NEXT:    .cfi_offset 31, -8
; N64-NEXT:    sd $5, 8($sp)
; N64-NEXT:    sd $4, 16($sp)
; N64-NEXT:    jal memcpy
; N64-NEXT:    ori $6, $zero, 65520
; N64-NEXT:    addiu $2, $zero, 4
; N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; N64-NEXT:    jr $ra
; N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %a.addr = alloca ptr, align 4
  %b.addr = alloca ptr, align 4
  store ptr %a, ptr %a.addr, align 4
  store ptr %b, ptr %b.addr, align 4
  %0 = load ptr, ptr %a.addr, align 4
  %1 = load ptr, ptr %b.addr, align 4
  call void @llvm.memcpy.p0.p0.i32(ptr align 1 %0, ptr align 1 %1, i32 65520, i1 false)
  ret i32 4
}

declare void @llvm.memcpy.p0.p0.i32(ptr nocapture writeonly, ptr nocapture readonly, i32, i1) #2
