; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=tahiti -verify-machineinstrs < %s | FileCheck --check-prefixes=SI %s
; RUN: llc -march=amdgcn -mcpu=fiji -verify-machineinstrs < %s | FileCheck --check-prefixes=VI %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck --check-prefixes=GFX11 %s

; IEEE bit enabled for compute kernel, so shouldn't use.
define amdgpu_kernel void @v_omod_div2_f32_enable_ieee_signed_zeros(ptr addrspace(1) %out, ptr addrspace(1) %aptr) #4 {
; SI-LABEL: v_omod_div2_f32_enable_ieee_signed_zeros:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v2, 0.5, v2
; SI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_f32_enable_ieee_signed_zeros:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v3
; VI-NEXT:    v_mul_f32_e32 v2, 0.5, v2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_f32_enable_ieee_signed_zeros:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v1, 0.5, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep0 = getelementptr float, ptr addrspace(1) %aptr, i32 %tid
  %out.gep = getelementptr float, ptr addrspace(1) %out, i32 %tid
  %a = load float, ptr addrspace(1) %gep0
  %add = fadd float %a, 1.0
  %div2 = fmul float %add, 0.5
  store float %div2, ptr addrspace(1) %out.gep
  ret void
}

; IEEE bit enabled for compute kernel, so shouldn't use.
define amdgpu_kernel void @v_omod_div2_f64_enable_ieee_signed_zeros(ptr addrspace(1) %out, ptr addrspace(1) %aptr) #4 {
; SI-LABEL: v_omod_div2_f64_enable_ieee_signed_zeros:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-NEXT:    buffer_load_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[0:3], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_f64_enable_ieee_signed_zeros:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:    v_mul_f64 v[0:1], v[0:1], 0.5
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_f64_enable_ieee_signed_zeros:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], 0.5
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep0 = getelementptr double, ptr addrspace(1) %aptr, i32 %tid
  %out.gep = getelementptr double, ptr addrspace(1) %out, i32 %tid
  %a = load double, ptr addrspace(1) %gep0
  %add = fadd double %a, 1.0
  %div2 = fmul double %add, 0.5
  store double %div2, ptr addrspace(1) %out.gep
  ret void
}

; IEEE bit enabled for compute kernel, so shouldn't use even though nsz is allowed
define amdgpu_kernel void @v_omod_div2_f32_enable_ieee_nsz(ptr addrspace(1) %out, ptr addrspace(1) %aptr) #0 {
; SI-LABEL: v_omod_div2_f32_enable_ieee_nsz:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-NEXT:    buffer_load_dword v2, v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v2, 0.5, v2
; SI-NEXT:    buffer_store_dword v2, v[0:1], s[0:3], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_f32_enable_ieee_nsz:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v3
; VI-NEXT:    v_mul_f32_e32 v2, 0.5, v2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_f32_enable_ieee_nsz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v1, 0.5, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep0 = getelementptr float, ptr addrspace(1) %aptr, i32 %tid
  %out.gep = getelementptr float, ptr addrspace(1) %out, i32 %tid
  %a = load float, ptr addrspace(1) %gep0
  %add = fadd float %a, 1.0
  %div2 = fmul float %add, 0.5
  store float %div2, ptr addrspace(1) %out.gep
  ret void
}

; IEEE bit enabled for compute kernel, so shouldn't use even though nsz is allowed.
define amdgpu_kernel void @v_omod_div2_f64_enable_ieee_nsz(ptr addrspace(1) %out, ptr addrspace(1) %aptr) #5 {
; SI-LABEL: v_omod_div2_f64_enable_ieee_nsz:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, 0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 3, v0
; SI-NEXT:    v_mov_b32_e32 v1, 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b64 s[4:5], s[2:3]
; SI-NEXT:    buffer_load_dwordx2 v[2:3], v[0:1], s[4:7], 0 addr64
; SI-NEXT:    s_mov_b64 s[2:3], s[6:7]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-NEXT:    buffer_store_dwordx2 v[2:3], v[0:1], s[0:3], 0 addr64
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_f64_enable_ieee_nsz:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[0:1], 0x24
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:    v_mul_f64 v[0:1], v[0:1], 0.5
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_f64_enable_ieee_nsz:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[0:1], 0x24
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], 0.5
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %gep0 = getelementptr double, ptr addrspace(1) %aptr, i32 %tid
  %out.gep = getelementptr double, ptr addrspace(1) %out, i32 %tid
  %a = load double, ptr addrspace(1) %gep0
  %add = fadd double %a, 1.0
  %div2 = fmul double %add, 0.5
  store double %div2, ptr addrspace(1) %out.gep
  ret void
}

; Only allow without IEEE bit if signed zeros are significant.
define amdgpu_ps void @v_omod_div2_f32_signed_zeros(float %a) #4 {
; SI-LABEL: v_omod_div2_f32_signed_zeros:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v0, 0.5, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_f32_signed_zeros:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_mul_f32_e32 v0, 0.5, v0
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_f32_signed_zeros:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, 0.5, v0
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd float %a, 1.0
  %div2 = fmul float %add, 0.5
  store float %div2, ptr addrspace(1) undef
  ret void
}

; Only allow without IEEE bit if signed zeros are significant.
define amdgpu_ps void @v_omod_div2_f64_signed_zeros(double %a) #4 {
; SI-LABEL: v_omod_div2_f64_signed_zeros:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    v_mul_f64 v[0:1], v[0:1], 0.5
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_f64_signed_zeros:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:    v_mul_f64 v[0:1], v[0:1], 0.5
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_f64_signed_zeros:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], 0.5
; GFX11-NEXT:    global_store_b64 v[0:1], v[0:1], off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd double %a, 1.0
  %div2 = fmul double %add, 0.5
  store double %div2, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_div2_f32(float %a) #0 {
; SI-LABEL: v_omod_div2_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e64 v0, v0, 1.0 div:2
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e64 v0, v0, 1.0 div:2
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e64 v0, v0, 1.0 div:2
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd float %a, 1.0
  %div2 = fmul float %add, 0.5
  store float %div2, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_div2_f64(double %a) #5 {
; SI-LABEL: v_omod_div2_f64:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0 div:2
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_f64:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0 div:2
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0 div:2
; GFX11-NEXT:    global_store_b64 v[0:1], v[0:1], off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd nsz double %a, 1.0
  %div2 = fmul nsz double %add, 0.5
  store double %div2, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_mul2_f32(float %a) #0 {
; SI-LABEL: v_omod_mul2_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e64 v0, v0, 1.0 mul:2
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_mul2_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e64 v0, v0, 1.0 mul:2
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_mul2_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e64 v0, v0, 1.0 mul:2
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd float %a, 1.0
  %div2 = fmul float %add, 2.0
  store float %div2, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_mul2_med3(float %x, float %y, float %z) #0 {
; SI-LABEL: v_omod_mul2_med3:
; SI:       ; %bb.0:
; SI-NEXT:    v_med3_f32 v0, v0, v1, v2 mul:2
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_mul2_med3:
; VI:       ; %bb.0:
; VI-NEXT:    v_med3_f32 v0, v0, v1, v2 mul:2
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_mul2_med3:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_med3_f32 v0, v0, v1, v2 mul:2
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %fmed3 = call float @llvm.amdgcn.fmed3.f32(float %x, float %y, float %z)
  %div2 = fmul float %fmed3, 2.0
  store float %div2, float addrspace(1)* undef
  ret void
}

define amdgpu_ps void @v_omod_mul2_f64(double %a) #5 {
; SI-LABEL: v_omod_mul2_f64:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0 mul:2
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_mul2_f64:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0 mul:2
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_mul2_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0 mul:2
; GFX11-NEXT:    global_store_b64 v[0:1], v[0:1], off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd nsz double %a, 1.0
  %div2 = fmul nsz double %add, 2.0
  store double %div2, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_mul4_f32(float %a) #0 {
; SI-LABEL: v_omod_mul4_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e64 v0, v0, 1.0 mul:4
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_mul4_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e64 v0, v0, 1.0 mul:4
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_mul4_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e64 v0, v0, 1.0 mul:4
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd float %a, 1.0
  %div2 = fmul float %add, 4.0
  store float %div2, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_mul4_f64(double %a) #5 {
; SI-LABEL: v_omod_mul4_f64:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0 mul:4
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_mul4_f64:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0 mul:4
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_mul4_f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0 mul:4
; GFX11-NEXT:    global_store_b64 v[0:1], v[0:1], off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd nsz double %a, 1.0
  %div2 = fmul nsz double %add, 4.0
  store double %div2, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_mul4_multi_use_f32(float %a) #0 {
; SI-LABEL: v_omod_mul4_multi_use_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v1, 4.0, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v1, off, s[0:3], 0
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_mul4_multi_use_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_mul_f32_e32 v1, 4.0, v0
; VI-NEXT:    flat_store_dword v[0:1], v1
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_mul4_multi_use_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v1, 4.0, v0
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b32 v[0:1], v1, off
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd float %a, 1.0
  %div2 = fmul float %add, 4.0
  store float %div2, ptr addrspace(1) undef
  store volatile float %add, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_mul4_dbg_use_f32(float %a) #0 {
; SI-LABEL: v_omod_mul4_dbg_use_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e64 v0, v0, 1.0 mul:4
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_mul4_dbg_use_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e64 v0, v0, 1.0 mul:4
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_mul4_dbg_use_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e64 v0, v0, 1.0 mul:4
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd float %a, 1.0
  call void @llvm.dbg.value(metadata float %add, i64 0, metadata !4, metadata !9), !dbg !10
  %div2 = fmul float %add, 4.0
  store float %div2, ptr addrspace(1) undef
  ret void
}

; Clamp is applied after omod, folding both into instruction is OK.
define amdgpu_ps void @v_clamp_omod_div2_f32(float %a) #0 {
; SI-LABEL: v_clamp_omod_div2_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e64 v0, v0, 1.0 clamp div:2
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_clamp_omod_div2_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e64 v0, v0, 1.0 clamp div:2
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_clamp_omod_div2_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e64 v0, v0, 1.0 clamp div:2
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd float %a, 1.0
  %div2 = fmul float %add, 0.5

  %max = call float @llvm.maxnum.f32(float %div2, float 0.0)
  %clamp = call float @llvm.minnum.f32(float %max, float 1.0)
  store float %clamp, ptr addrspace(1) undef
  ret void
}

; Cannot fold omod into clamp
define amdgpu_ps void @v_omod_div2_clamp_f32(float %a) #0 {
; SI-LABEL: v_omod_div2_clamp_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e64 v0, v0, 1.0 clamp
; SI-NEXT:    v_mul_f32_e32 v0, 0.5, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_clamp_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e64 v0, v0, 1.0 clamp
; VI-NEXT:    v_mul_f32_e32 v0, 0.5, v0
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_clamp_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e64 v0, v0, 1.0 clamp
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, 0.5, v0
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd float %a, 1.0
  %max = call float @llvm.maxnum.f32(float %add, float 0.0)
  %clamp = call float @llvm.minnum.f32(float %max, float 1.0)
  %div2 = fmul float %clamp, 0.5
  store float %div2, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_div2_abs_src_f32(float %a) #0 {
; SI-LABEL: v_omod_div2_abs_src_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_mul_f32_e64 v0, |v0|, 0.5
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_abs_src_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_mul_f32_e64 v0, |v0|, 0.5
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_abs_src_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e64 v0, |v0|, 0.5
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd float %a, 1.0
  %abs.add = call float @llvm.fabs.f32(float %add)
  %div2 = fmul float %abs.add, 0.5
  store float %div2, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_add_self_clamp_f32(float %a) #0 {
; SI-LABEL: v_omod_add_self_clamp_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e64 v0, v0, v0 clamp
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_add_self_clamp_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e64 v0, v0, v0 clamp
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_add_self_clamp_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e64 v0, v0, v0 clamp
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd float %a, %a
  %max = call float @llvm.maxnum.f32(float %add, float 0.0)
  %clamp = call float @llvm.minnum.f32(float %max, float 1.0)
  store float %clamp, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_add_clamp_self_f32(float %a) #0 {
; SI-LABEL: v_omod_add_clamp_self_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_max_f32_e64 v0, v0, v0 clamp
; SI-NEXT:    v_add_f32_e32 v0, v0, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_add_clamp_self_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_max_f32_e64 v0, v0, v0 clamp
; VI-NEXT:    v_add_f32_e32 v0, v0, v0
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_add_clamp_self_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_max_f32_e64 v0, v0, v0 clamp
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v0
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %max = call float @llvm.maxnum.f32(float %a, float 0.0)
  %clamp = call float @llvm.minnum.f32(float %max, float 1.0)
  %add = fadd float %clamp, %clamp
  store float %add, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_add_abs_self_f32(float %a) #0 {
; SI-LABEL: v_omod_add_abs_self_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e64 v0, |v0|, |v0|
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_add_abs_self_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_add_f32_e64 v0, |v0|, |v0|
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_add_abs_self_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e64 v0, |v0|, |v0|
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %x = fadd float %a, 1.0
  %abs.x = call float @llvm.fabs.f32(float %x)
  %add = fadd float %abs.x, %abs.x
  store float %add, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_add_abs_x_x_f32(float %a) #0 {
; SI-LABEL: v_omod_add_abs_x_x_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e64 v0, |v0|, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_add_abs_x_x_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_add_f32_e64 v0, |v0|, v0
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_add_abs_x_x_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e64 v0, |v0|, v0
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %x = fadd float %a, 1.0
  %abs.x = call float @llvm.fabs.f32(float %x)
  %add = fadd float %abs.x, %x
  store float %add, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_add_x_abs_x_f32(float %a) #0 {
; SI-LABEL: v_omod_add_x_abs_x_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e64 v0, v0, |v0|
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_add_x_abs_x_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_add_f32_e64 v0, v0, |v0|
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_add_x_abs_x_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e64 v0, v0, |v0|
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %x = fadd float %a, 1.0
  %abs.x = call float @llvm.fabs.f32(float %x)
  %add = fadd float %x, %abs.x
  store float %add, ptr addrspace(1) undef
  ret void
}

; Don't fold omod into omod into another omod.
define amdgpu_ps void @v_omod_div2_omod_div2_f32(float %a) #0 {
; SI-LABEL: v_omod_div2_omod_div2_f32:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e64 v0, v0, 1.0 div:2
; SI-NEXT:    v_mul_f32_e32 v0, 0.5, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_omod_div2_f32:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e64 v0, v0, 1.0 div:2
; VI-NEXT:    v_mul_f32_e32 v0, 0.5, v0
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_omod_div2_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e64 v0, v0, 1.0 div:2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, 0.5, v0
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd float %a, 1.0
  %div2.0 = fmul float %add, 0.5
  %div2.1 = fmul float %div2.0, 0.5
  store float %div2.1, ptr addrspace(1) undef
  ret void
}

; Don't fold omod if denorms enabled
define amdgpu_ps void @v_omod_div2_f32_denormals(float %a) #2 {
; SI-LABEL: v_omod_div2_f32_denormals:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v0, 0.5, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_f32_denormals:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_mul_f32_e32 v0, 0.5, v0
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_f32_denormals:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, 0.5, v0
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd float %a, 1.0
  %div2 = fmul float %add, 0.5
  store float %div2, ptr addrspace(1) undef
  ret void
}

; Don't fold omod if denorms enabled.
define amdgpu_ps void @v_omod_div2_f64_denormals(double %a) #6 {
; SI-LABEL: v_omod_div2_f64_denormals:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    v_mul_f64 v[0:1], v[0:1], 0.5
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_f64_denormals:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:    v_mul_f64 v[0:1], v[0:1], 0.5
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_f64_denormals:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], 0.5
; GFX11-NEXT:    global_store_b64 v[0:1], v[0:1], off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd double %a, 1.0
  %div2 = fmul double %add, 0.5
  store double %div2, ptr addrspace(1) undef
  ret void
}

; Don't fold omod if denorms enabled for add form.
define amdgpu_ps void @v_omod_mul2_f32_denormals(float %a) #2 {
; SI-LABEL: v_omod_mul2_f32_denormals:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e32 v0, v0, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_mul2_f32_denormals:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_add_f32_e32 v0, v0, v0
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_mul2_f32_denormals:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v0
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd float %a, 1.0
  %mul2 = fadd float %add, %add
  store float %mul2, ptr addrspace(1) undef
  ret void
}

; Don't fold omod if denorms enabled for add form.
define amdgpu_ps void @v_omod_mul2_f64_denormals(double %a) #2 {
; SI-LABEL: v_omod_mul2_f64_denormals:
; SI:       ; %bb.0:
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], v[0:1]
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_mul2_f64_denormals:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], v[0:1]
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_mul2_f64_denormals:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    global_store_b64 v[0:1], v[0:1], off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd double %a, 1.0
  %mul2 = fadd double %add, %add
  store double %mul2, ptr addrspace(1) undef
  ret void
}

; Don't fold omod if denorms enabled
define amdgpu_ps void @v_omod_div2_f16_denormals(half %a) #0 {
; SI-LABEL: v_omod_div2_f16_denormals:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e64 v0, v0, 1.0 div:2
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_f16_denormals:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f16_e32 v0, 1.0, v0
; VI-NEXT:    v_mul_f16_e32 v0, 0.5, v0
; VI-NEXT:    flat_store_short v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_f16_denormals:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f16_e32 v0, 0.5, v0
; GFX11-NEXT:    global_store_b16 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd half %a, 1.0
  %div2 = fmul half %add, 0.5
  store half %div2, ptr addrspace(1) undef
  ret void
}

; Don't fold omod if denorms enabled for add form.
define amdgpu_ps void @v_omod_mul2_f16_denormals(half %a) #0 {
; SI-LABEL: v_omod_mul2_f16_denormals:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e64 v0, v0, 1.0 mul:2
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_mul2_f16_denormals:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f16_e32 v0, 1.0, v0
; VI-NEXT:    v_add_f16_e32 v0, v0, v0
; VI-NEXT:    flat_store_short v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_mul2_f16_denormals:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f16_e32 v0, 1.0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_f16_e32 v0, v0, v0
; GFX11-NEXT:    global_store_b16 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd half %a, 1.0
  %mul2 = fadd half %add, %add
  store half %mul2, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_div2_f16_no_denormals(half %a) #3 {
; SI-LABEL: v_omod_div2_f16_no_denormals:
; SI:       ; %bb.0:
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_add_f32_e64 v0, v0, 1.0 div:2
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_div2_f16_no_denormals:
; VI:       ; %bb.0:
; VI-NEXT:    v_add_f16_e64 v0, v0, 1.0 div:2
; VI-NEXT:    flat_store_short v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_div2_f16_no_denormals:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_add_f16_e64 v0, v0, 1.0 div:2
; GFX11-NEXT:    global_store_b16 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %add = fadd half %a, 1.0
  %div2 = fmul half %add, 0.5
  store half %div2, ptr addrspace(1) undef
  ret void
}

define amdgpu_ps void @v_omod_mac_to_mad(float %b, float %a) #0 {
; SI-LABEL: v_omod_mac_to_mad:
; SI:       ; %bb.0:
; SI-NEXT:    v_mad_f32 v1, v1, v1, v0 mul:2
; SI-NEXT:    v_mul_f32_e32 v0, v1, v0
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_omod_mac_to_mad:
; VI:       ; %bb.0:
; VI-NEXT:    v_mad_f32 v1, v1, v1, v0 mul:2
; VI-NEXT:    v_mul_f32_e32 v0, v1, v0
; VI-NEXT:    flat_store_dword v[0:1], v0
; VI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_omod_mac_to_mad:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    v_mul_f32_e32 v1, v1, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_f32_e64 v1, v1, v0 mul:2
; GFX11-NEXT:    v_mul_f32_e32 v0, v1, v0
; GFX11-NEXT:    global_store_b32 v[0:1], v0, off
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %mul = fmul float %a, %a
  %add = fadd float %mul, %b
  %mad = fmul float %add, 2.0
  %res = fmul float %mad, %b
  store float %res, ptr addrspace(1) undef
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x() #1
declare float @llvm.fabs.f32(float) #1
declare float @llvm.floor.f32(float) #1
declare float @llvm.minnum.f32(float, float) #1
declare float @llvm.maxnum.f32(float, float) #1
declare float @llvm.amdgcn.fmed3.f32(float, float, float) #1
declare double @llvm.fabs.f64(double) #1
declare double @llvm.minnum.f64(double, double) #1
declare double @llvm.maxnum.f64(double, double) #1
declare half @llvm.fabs.f16(half) #1
declare half @llvm.minnum.f16(half, half) #1
declare half @llvm.maxnum.f16(half, half) #1
declare void @llvm.dbg.value(metadata, i64, metadata, metadata) #1

attributes #0 = { nounwind "denormal-fp-math-f32"="preserve-sign,preserve-sign" "no-signed-zeros-fp-math"="true" }
attributes #1 = { nounwind readnone }
attributes #2 = { nounwind "denormal-fp-math-f32"="ieee,ieee" "no-signed-zeros-fp-math"="true" }
attributes #3 = { nounwind "denormal-fp-math"="preserve-sign,preserve-sign" "no-signed-zeros-fp-math"="true" }
attributes #4 = { nounwind "no-signed-zeros-fp-math"="false" }
attributes #5 = { nounwind "denormal-fp-math"="preserve-sign,preserve-sign" }
attributes #6 = { nounwind "denormal-fp-math"="ieee,ieee" "no-signed-zeros-fp-math"="true" }

!llvm.dbg.cu = !{!0}
!llvm.module.flags = !{!2, !3}

!0 = distinct !DICompileUnit(language: DW_LANG_C99, file: !1, isOptimized: true, runtimeVersion: 0, emissionKind: NoDebug)
!1 = !DIFile(filename: "/tmp/foo.cl", directory: "/dev/null")
!2 = !{i32 2, !"Dwarf Version", i32 4}
!3 = !{i32 2, !"Debug Info Version", i32 3}
!4 = !DILocalVariable(name: "add", arg: 1, scope: !5, file: !1, line: 1)
!5 = distinct !DISubprogram(name: "foo", scope: !1, file: !1, line: 1, type: !6, isLocal: false, isDefinition: true, scopeLine: 2, flags: DIFlagPrototyped, isOptimized: true, unit: !0)
!6 = !DISubroutineType(types: !7)
!7 = !{null, !8}
!8 = !DIBasicType(name: "float", size: 32, align: 32)
!9 = !DIExpression()
!10 = !DILocation(line: 1, column: 42, scope: !5)
