; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-unknown-linux-gnu < %s | FileCheck %s

; The mask is all-ones, potentially shifted.

;------------------------------------------------------------------------------;
; 128-bit vector; 8-bit elements = 16 elements
;------------------------------------------------------------------------------;

; lshr

define <16 x i8> @test_128_i8_x_16_7_mask_lshr_1(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_7_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #7
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #1
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %t1 = lshr <16 x i8> %t0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  ret <16 x i8> %t1
}

define <16 x i8> @test_128_i8_x_16_28_mask_lshr_1(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_28_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #28
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #1
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28>
  %t1 = lshr <16 x i8> %t0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_28_mask_lshr_2(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_28_mask_lshr_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #28
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #2
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28>
  %t1 = lshr <16 x i8> %t0, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_28_mask_lshr_3(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_28_mask_lshr_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #28
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #3
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28>
  %t1 = lshr <16 x i8> %t0, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_28_mask_lshr_4(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_28_mask_lshr_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #28
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #4
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28>
  %t1 = lshr <16 x i8> %t0, <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>
  ret <16 x i8> %t1
}

define <16 x i8> @test_128_i8_x_16_224_mask_lshr_1(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_224_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #224
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #1
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224>
  %t1 = lshr <16 x i8> %t0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_224_mask_lshr_4(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_224_mask_lshr_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #224
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #4
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224>
  %t1 = lshr <16 x i8> %t0, <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_224_mask_lshr_5(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_224_mask_lshr_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.16b, v0.16b, #5
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224>
  %t1 = lshr <16 x i8> %t0, <i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_224_mask_lshr_6(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_224_mask_lshr_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.16b, v0.16b, #6
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224>
  %t1 = lshr <16 x i8> %t0, <i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6>
  ret <16 x i8> %t1
}

; ashr

define <16 x i8> @test_128_i8_x_16_7_mask_ashr_1(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_7_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #7
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #1
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %t1 = ashr <16 x i8> %t0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  ret <16 x i8> %t1
}

define <16 x i8> @test_128_i8_x_16_28_mask_ashr_1(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_28_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #28
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #1
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28>
  %t1 = ashr <16 x i8> %t0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_28_mask_ashr_2(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_28_mask_ashr_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #28
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #2
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28>
  %t1 = ashr <16 x i8> %t0, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_28_mask_ashr_3(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_28_mask_ashr_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #28
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #3
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28>
  %t1 = ashr <16 x i8> %t0, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_28_mask_ashr_4(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_28_mask_ashr_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #28
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.16b, v0.16b, #4
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28>
  %t1 = ashr <16 x i8> %t0, <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>
  ret <16 x i8> %t1
}

define <16 x i8> @test_128_i8_x_16_224_mask_ashr_1(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_224_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #224
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    sshr v0.16b, v0.16b, #1
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224>
  %t1 = ashr <16 x i8> %t0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_224_mask_ashr_4(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_224_mask_ashr_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #224
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    sshr v0.16b, v0.16b, #4
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224>
  %t1 = ashr <16 x i8> %t0, <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_224_mask_ashr_5(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_224_mask_ashr_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshr v0.16b, v0.16b, #5
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224>
  %t1 = ashr <16 x i8> %t0, <i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_224_mask_ashr_6(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_224_mask_ashr_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshr v0.16b, v0.16b, #6
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224>
  %t1 = ashr <16 x i8> %t0, <i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6>
  ret <16 x i8> %t1
}

; shl

define <16 x i8> @test_128_i8_x_16_7_mask_shl_1(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_7_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #7
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.16b, v0.16b, #1
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %t1 = shl <16 x i8> %t0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_7_mask_shl_4(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_7_mask_shl_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #7
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.16b, v0.16b, #4
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %t1 = shl <16 x i8> %t0, <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_7_mask_shl_5(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_7_mask_shl_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shl v0.16b, v0.16b, #5
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %t1 = shl <16 x i8> %t0, <i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_7_mask_shl_6(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_7_mask_shl_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shl v0.16b, v0.16b, #6
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7, i8 7>
  %t1 = shl <16 x i8> %t0, <i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6, i8 6>
  ret <16 x i8> %t1
}

define <16 x i8> @test_128_i8_x_16_28_mask_shl_1(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_28_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #28
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.16b, v0.16b, #1
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28>
  %t1 = shl <16 x i8> %t0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_28_mask_shl_2(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_28_mask_shl_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #28
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.16b, v0.16b, #2
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28>
  %t1 = shl <16 x i8> %t0, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_28_mask_shl_3(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_28_mask_shl_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #28
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.16b, v0.16b, #3
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28>
  %t1 = shl <16 x i8> %t0, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  ret <16 x i8> %t1
}
define <16 x i8> @test_128_i8_x_16_28_mask_shl_4(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_28_mask_shl_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #28
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.16b, v0.16b, #4
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28, i8 28>
  %t1 = shl <16 x i8> %t0, <i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4, i8 4>
  ret <16 x i8> %t1
}

define <16 x i8> @test_128_i8_x_16_224_mask_shl_1(<16 x i8> %a0) {
; CHECK-LABEL: test_128_i8_x_16_224_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.16b, #224
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.16b, v0.16b, #1
; CHECK-NEXT:    ret
  %t0 = and <16 x i8> %a0, <i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224, i8 224>
  %t1 = shl <16 x i8> %t0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  ret <16 x i8> %t1
}

;------------------------------------------------------------------------------;
; 128-bit vector; 16-bit elements = 8 elements
;------------------------------------------------------------------------------;

; lshr

define <8 x i16> @test_128_i16_x_8_127_mask_lshr_1(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_127_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8h, #127
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.8h, v0.8h, #1
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %t1 = lshr <8 x i16> %t0, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  ret <8 x i16> %t1
}

define <8 x i16> @test_128_i16_x_8_2032_mask_lshr_3(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_2032_mask_lshr_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2032
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.8h, v0.8h, #3
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032>
  %t1 = lshr <8 x i16> %t0, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_2032_mask_lshr_4(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_2032_mask_lshr_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2032
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.8h, v0.8h, #4
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032>
  %t1 = lshr <8 x i16> %t0, <i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_2032_mask_lshr_5(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_2032_mask_lshr_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2032
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.8h, v0.8h, #5
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032>
  %t1 = lshr <8 x i16> %t0, <i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_2032_mask_lshr_6(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_2032_mask_lshr_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2032
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.8h, v0.8h, #6
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032>
  %t1 = lshr <8 x i16> %t0, <i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6>
  ret <8 x i16> %t1
}

define <8 x i16> @test_128_i16_x_8_65024_mask_lshr_1(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_65024_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8h, #254, lsl #8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.8h, v0.8h, #1
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024>
  %t1 = lshr <8 x i16> %t0, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_65024_mask_lshr_8(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_65024_mask_lshr_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8h, #254, lsl #8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.8h, v0.8h, #8
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024>
  %t1 = lshr <8 x i16> %t0, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_65024_mask_lshr_9(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_65024_mask_lshr_9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.8h, v0.8h, #9
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024>
  %t1 = lshr <8 x i16> %t0, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_65024_mask_lshr_10(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_65024_mask_lshr_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.8h, v0.8h, #10
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024>
  %t1 = lshr <8 x i16> %t0, <i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10>
  ret <8 x i16> %t1
}

; ashr

define <8 x i16> @test_128_i16_x_8_127_mask_ashr_1(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_127_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8h, #127
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.8h, v0.8h, #1
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %t1 = ashr <8 x i16> %t0, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  ret <8 x i16> %t1
}

define <8 x i16> @test_128_i16_x_8_2032_mask_ashr_3(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_2032_mask_ashr_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2032
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.8h, v0.8h, #3
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032>
  %t1 = ashr <8 x i16> %t0, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_2032_mask_ashr_4(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_2032_mask_ashr_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2032
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.8h, v0.8h, #4
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032>
  %t1 = ashr <8 x i16> %t0, <i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_2032_mask_ashr_5(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_2032_mask_ashr_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2032
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.8h, v0.8h, #5
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032>
  %t1 = ashr <8 x i16> %t0, <i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_2032_mask_ashr_6(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_2032_mask_ashr_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2032
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.8h, v0.8h, #6
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032>
  %t1 = ashr <8 x i16> %t0, <i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6>
  ret <8 x i16> %t1
}

define <8 x i16> @test_128_i16_x_8_65024_mask_ashr_1(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_65024_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8h, #254, lsl #8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    sshr v0.8h, v0.8h, #1
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024>
  %t1 = ashr <8 x i16> %t0, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_65024_mask_ashr_8(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_65024_mask_ashr_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8h, #254, lsl #8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    sshr v0.8h, v0.8h, #8
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024>
  %t1 = ashr <8 x i16> %t0, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_65024_mask_ashr_9(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_65024_mask_ashr_9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshr v0.8h, v0.8h, #9
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024>
  %t1 = ashr <8 x i16> %t0, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_65024_mask_ashr_10(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_65024_mask_ashr_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshr v0.8h, v0.8h, #10
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024>
  %t1 = ashr <8 x i16> %t0, <i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10>
  ret <8 x i16> %t1
}

; shl

define <8 x i16> @test_128_i16_x_8_127_mask_shl_1(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_127_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8h, #127
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.8h, v0.8h, #1
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %t1 = shl <8 x i16> %t0, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_127_mask_shl_8(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_127_mask_shl_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8h, #127
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.8h, v0.8h, #8
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %t1 = shl <8 x i16> %t0, <i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8, i16 8>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_127_mask_shl_9(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_127_mask_shl_9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shl v0.8h, v0.8h, #9
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %t1 = shl <8 x i16> %t0, <i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9, i16 9>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_127_mask_shl_10(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_127_mask_shl_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shl v0.8h, v0.8h, #10
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127, i16 127>
  %t1 = shl <8 x i16> %t0, <i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10, i16 10>
  ret <8 x i16> %t1
}

define <8 x i16> @test_128_i16_x_8_2032_mask_shl_3(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_2032_mask_shl_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2032
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.8h, v0.8h, #3
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032>
  %t1 = shl <8 x i16> %t0, <i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3, i16 3>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_2032_mask_shl_4(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_2032_mask_shl_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2032
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.8h, v0.8h, #4
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032>
  %t1 = shl <8 x i16> %t0, <i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4, i16 4>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_2032_mask_shl_5(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_2032_mask_shl_5:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2032
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.8h, v0.8h, #5
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032>
  %t1 = shl <8 x i16> %t0, <i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5>
  ret <8 x i16> %t1
}
define <8 x i16> @test_128_i16_x_8_2032_mask_shl_6(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_2032_mask_shl_6:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2032
; CHECK-NEXT:    dup v1.8h, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.8h, v0.8h, #6
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032, i16 2032>
  %t1 = shl <8 x i16> %t0, <i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6, i16 6>
  ret <8 x i16> %t1
}

define <8 x i16> @test_128_i16_x_8_65024_mask_shl_1(<8 x i16> %a0) {
; CHECK-LABEL: test_128_i16_x_8_65024_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.8h, #254, lsl #8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.8h, v0.8h, #1
; CHECK-NEXT:    ret
  %t0 = and <8 x i16> %a0, <i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024, i16 65024>
  %t1 = shl <8 x i16> %t0, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  ret <8 x i16> %t1
}

;------------------------------------------------------------------------------;
; 128-bit vector; 32-bit elements = 4 elements
;------------------------------------------------------------------------------;

; lshr

define <4 x i32> @test_128_i32_x_4_32767_mask_lshr_1(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_32767_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.4s, #127, msl #8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.4s, v0.4s, #1
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 32767, i32 32767, i32 32767, i32 32767>
  %t1 = lshr <4 x i32> %t0, <i32 1, i32 1, i32 1, i32 1>
  ret <4 x i32> %t1
}

define <4 x i32> @test_128_i32_x_4_8388352_mask_lshr_7(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_8388352_mask_lshr_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #8388352
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.4s, v0.4s, #7
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 8388352, i32 8388352, i32 8388352, i32 8388352>
  %t1 = lshr <4 x i32> %t0, <i32 7, i32 7, i32 7, i32 7>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_8388352_mask_lshr_8(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_8388352_mask_lshr_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #8388352
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.4s, v0.4s, #8
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 8388352, i32 8388352, i32 8388352, i32 8388352>
  %t1 = lshr <4 x i32> %t0, <i32 8, i32 8, i32 8, i32 8>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_8388352_mask_lshr_9(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_8388352_mask_lshr_9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #8388352
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.4s, v0.4s, #9
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 8388352, i32 8388352, i32 8388352, i32 8388352>
  %t1 = lshr <4 x i32> %t0, <i32 9, i32 9, i32 9, i32 9>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_8388352_mask_lshr_10(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_8388352_mask_lshr_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #8388352
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.4s, v0.4s, #10
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 8388352, i32 8388352, i32 8388352, i32 8388352>
  %t1 = lshr <4 x i32> %t0, <i32 10, i32 10, i32 10, i32 10>
  ret <4 x i32> %t1
}

define <4 x i32> @test_128_i32_x_4_4294836224_mask_lshr_1(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_4294836224_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mvni v1.4s, #1, msl #16
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.4s, v0.4s, #1
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 4294836224, i32 4294836224, i32 4294836224, i32 4294836224>
  %t1 = lshr <4 x i32> %t0, <i32 1, i32 1, i32 1, i32 1>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_4294836224_mask_lshr_16(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_4294836224_mask_lshr_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mvni v1.4s, #1, msl #16
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.4s, v0.4s, #16
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 4294836224, i32 4294836224, i32 4294836224, i32 4294836224>
  %t1 = lshr <4 x i32> %t0, <i32 16, i32 16, i32 16, i32 16>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_4294836224_mask_lshr_17(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_4294836224_mask_lshr_17:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.4s, v0.4s, #17
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 4294836224, i32 4294836224, i32 4294836224, i32 4294836224>
  %t1 = lshr <4 x i32> %t0, <i32 17, i32 17, i32 17, i32 17>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_4294836224_mask_lshr_18(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_4294836224_mask_lshr_18:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.4s, v0.4s, #18
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 4294836224, i32 4294836224, i32 4294836224, i32 4294836224>
  %t1 = lshr <4 x i32> %t0, <i32 18, i32 18, i32 18, i32 18>
  ret <4 x i32> %t1
}

; ashr

define <4 x i32> @test_128_i32_x_4_32767_mask_ashr_1(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_32767_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.4s, #127, msl #8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.4s, v0.4s, #1
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 32767, i32 32767, i32 32767, i32 32767>
  %t1 = ashr <4 x i32> %t0, <i32 1, i32 1, i32 1, i32 1>
  ret <4 x i32> %t1
}

define <4 x i32> @test_128_i32_x_4_8388352_mask_ashr_7(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_8388352_mask_ashr_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #8388352
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.4s, v0.4s, #7
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 8388352, i32 8388352, i32 8388352, i32 8388352>
  %t1 = ashr <4 x i32> %t0, <i32 7, i32 7, i32 7, i32 7>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_8388352_mask_ashr_8(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_8388352_mask_ashr_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #8388352
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.4s, v0.4s, #8
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 8388352, i32 8388352, i32 8388352, i32 8388352>
  %t1 = ashr <4 x i32> %t0, <i32 8, i32 8, i32 8, i32 8>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_8388352_mask_ashr_9(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_8388352_mask_ashr_9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #8388352
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.4s, v0.4s, #9
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 8388352, i32 8388352, i32 8388352, i32 8388352>
  %t1 = ashr <4 x i32> %t0, <i32 9, i32 9, i32 9, i32 9>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_8388352_mask_ashr_10(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_8388352_mask_ashr_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #8388352
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.4s, v0.4s, #10
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 8388352, i32 8388352, i32 8388352, i32 8388352>
  %t1 = ashr <4 x i32> %t0, <i32 10, i32 10, i32 10, i32 10>
  ret <4 x i32> %t1
}

define <4 x i32> @test_128_i32_x_4_4294836224_mask_ashr_1(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_4294836224_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mvni v1.4s, #1, msl #16
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    sshr v0.4s, v0.4s, #1
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 4294836224, i32 4294836224, i32 4294836224, i32 4294836224>
  %t1 = ashr <4 x i32> %t0, <i32 1, i32 1, i32 1, i32 1>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_4294836224_mask_ashr_16(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_4294836224_mask_ashr_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mvni v1.4s, #1, msl #16
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    sshr v0.4s, v0.4s, #16
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 4294836224, i32 4294836224, i32 4294836224, i32 4294836224>
  %t1 = ashr <4 x i32> %t0, <i32 16, i32 16, i32 16, i32 16>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_4294836224_mask_ashr_17(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_4294836224_mask_ashr_17:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshr v0.4s, v0.4s, #17
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 4294836224, i32 4294836224, i32 4294836224, i32 4294836224>
  %t1 = ashr <4 x i32> %t0, <i32 17, i32 17, i32 17, i32 17>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_4294836224_mask_ashr_18(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_4294836224_mask_ashr_18:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshr v0.4s, v0.4s, #18
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 4294836224, i32 4294836224, i32 4294836224, i32 4294836224>
  %t1 = ashr <4 x i32> %t0, <i32 18, i32 18, i32 18, i32 18>
  ret <4 x i32> %t1
}

; shl

define <4 x i32> @test_128_i32_x_4_32767_mask_shl_1(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_32767_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.4s, #127, msl #8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.4s, v0.4s, #1
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 32767, i32 32767, i32 32767, i32 32767>
  %t1 = shl <4 x i32> %t0, <i32 1, i32 1, i32 1, i32 1>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_32767_mask_shl_16(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_32767_mask_shl_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.4s, #127, msl #8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.4s, v0.4s, #16
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 32767, i32 32767, i32 32767, i32 32767>
  %t1 = shl <4 x i32> %t0, <i32 16, i32 16, i32 16, i32 16>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_32767_mask_shl_17(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_32767_mask_shl_17:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shl v0.4s, v0.4s, #17
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 32767, i32 32767, i32 32767, i32 32767>
  %t1 = shl <4 x i32> %t0, <i32 17, i32 17, i32 17, i32 17>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_32767_mask_shl_18(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_32767_mask_shl_18:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shl v0.4s, v0.4s, #18
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 32767, i32 32767, i32 32767, i32 32767>
  %t1 = shl <4 x i32> %t0, <i32 18, i32 18, i32 18, i32 18>
  ret <4 x i32> %t1
}

define <4 x i32> @test_128_i32_x_4_8388352_mask_shl_7(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_8388352_mask_shl_7:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #8388352
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.4s, v0.4s, #7
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 8388352, i32 8388352, i32 8388352, i32 8388352>
  %t1 = shl <4 x i32> %t0, <i32 7, i32 7, i32 7, i32 7>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_8388352_mask_shl_8(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_8388352_mask_shl_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #8388352
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.4s, v0.4s, #8
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 8388352, i32 8388352, i32 8388352, i32 8388352>
  %t1 = shl <4 x i32> %t0, <i32 8, i32 8, i32 8, i32 8>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_8388352_mask_shl_9(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_8388352_mask_shl_9:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #8388352
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.4s, v0.4s, #9
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 8388352, i32 8388352, i32 8388352, i32 8388352>
  %t1 = shl <4 x i32> %t0, <i32 9, i32 9, i32 9, i32 9>
  ret <4 x i32> %t1
}
define <4 x i32> @test_128_i32_x_4_8388352_mask_shl_10(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_8388352_mask_shl_10:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #8388352
; CHECK-NEXT:    dup v1.4s, w8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.4s, v0.4s, #10
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 8388352, i32 8388352, i32 8388352, i32 8388352>
  %t1 = shl <4 x i32> %t0, <i32 10, i32 10, i32 10, i32 10>
  ret <4 x i32> %t1
}

define <4 x i32> @test_128_i32_x_4_4294836224_mask_shl_1(<4 x i32> %a0) {
; CHECK-LABEL: test_128_i32_x_4_4294836224_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mvni v1.4s, #1, msl #16
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.4s, v0.4s, #1
; CHECK-NEXT:    ret
  %t0 = and <4 x i32> %a0, <i32 4294836224, i32 4294836224, i32 4294836224, i32 4294836224>
  %t1 = shl <4 x i32> %t0, <i32 1, i32 1, i32 1, i32 1>
  ret <4 x i32> %t1
}

;------------------------------------------------------------------------------;
; 128-bit vector; 64-bit elements = 2 elements
;------------------------------------------------------------------------------;

; lshr

define <2 x i64> @test_128_i64_x_2_2147483647_mask_lshr_1(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_2147483647_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2147483647
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.2d, v0.2d, #1
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 2147483647, i64 2147483647>
  %t1 = lshr <2 x i64> %t0, <i64 1, i64 1>
  ret <2 x i64> %t1
}

define <2 x i64> @test_128_i64_x_2_140737488289792_mask_lshr_15(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_140737488289792_mask_lshr_15:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #140737488289792
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.2d, v0.2d, #15
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 140737488289792, i64 140737488289792>
  %t1 = lshr <2 x i64> %t0, <i64 15, i64 15>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_140737488289792_mask_lshr_16(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_140737488289792_mask_lshr_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #140737488289792
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.2d, v0.2d, #16
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 140737488289792, i64 140737488289792>
  %t1 = lshr <2 x i64> %t0, <i64 16, i64 16>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_140737488289792_mask_lshr_17(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_140737488289792_mask_lshr_17:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #140737488289792
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.2d, v0.2d, #17
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 140737488289792, i64 140737488289792>
  %t1 = lshr <2 x i64> %t0, <i64 17, i64 17>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_140737488289792_mask_lshr_18(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_140737488289792_mask_lshr_18:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #140737488289792
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.2d, v0.2d, #18
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 140737488289792, i64 140737488289792>
  %t1 = lshr <2 x i64> %t0, <i64 18, i64 18>
  ret <2 x i64> %t1
}

define <2 x i64> @test_128_i64_x_2_18446744065119617024_mask_lshr_1(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_18446744065119617024_mask_lshr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-8589934592
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.2d, v0.2d, #1
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 18446744065119617024, i64 18446744065119617024>
  %t1 = lshr <2 x i64> %t0, <i64 1, i64 1>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_18446744065119617024_mask_lshr_32(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_18446744065119617024_mask_lshr_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-8589934592
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.2d, v0.2d, #32
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 18446744065119617024, i64 18446744065119617024>
  %t1 = lshr <2 x i64> %t0, <i64 32, i64 32>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_18446744065119617024_mask_lshr_33(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_18446744065119617024_mask_lshr_33:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.2d, v0.2d, #33
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 18446744065119617024, i64 18446744065119617024>
  %t1 = lshr <2 x i64> %t0, <i64 33, i64 33>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_18446744065119617024_mask_lshr_34(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_18446744065119617024_mask_lshr_34:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.2d, v0.2d, #34
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 18446744065119617024, i64 18446744065119617024>
  %t1 = lshr <2 x i64> %t0, <i64 34, i64 34>
  ret <2 x i64> %t1
}

; ashr

define <2 x i64> @test_128_i64_x_2_2147483647_mask_ashr_1(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_2147483647_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2147483647
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.2d, v0.2d, #1
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 2147483647, i64 2147483647>
  %t1 = ashr <2 x i64> %t0, <i64 1, i64 1>
  ret <2 x i64> %t1
}

define <2 x i64> @test_128_i64_x_2_140737488289792_mask_ashr_15(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_140737488289792_mask_ashr_15:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #140737488289792
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.2d, v0.2d, #15
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 140737488289792, i64 140737488289792>
  %t1 = ashr <2 x i64> %t0, <i64 15, i64 15>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_140737488289792_mask_ashr_16(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_140737488289792_mask_ashr_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #140737488289792
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.2d, v0.2d, #16
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 140737488289792, i64 140737488289792>
  %t1 = ashr <2 x i64> %t0, <i64 16, i64 16>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_140737488289792_mask_ashr_17(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_140737488289792_mask_ashr_17:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #140737488289792
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.2d, v0.2d, #17
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 140737488289792, i64 140737488289792>
  %t1 = ashr <2 x i64> %t0, <i64 17, i64 17>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_140737488289792_mask_ashr_18(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_140737488289792_mask_ashr_18:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #140737488289792
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ushr v0.2d, v0.2d, #18
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 140737488289792, i64 140737488289792>
  %t1 = ashr <2 x i64> %t0, <i64 18, i64 18>
  ret <2 x i64> %t1
}

define <2 x i64> @test_128_i64_x_2_18446744065119617024_mask_ashr_1(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_18446744065119617024_mask_ashr_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-8589934592
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    sshr v0.2d, v0.2d, #1
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 18446744065119617024, i64 18446744065119617024>
  %t1 = ashr <2 x i64> %t0, <i64 1, i64 1>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_18446744065119617024_mask_ashr_32(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_18446744065119617024_mask_ashr_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-8589934592
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    sshr v0.2d, v0.2d, #32
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 18446744065119617024, i64 18446744065119617024>
  %t1 = ashr <2 x i64> %t0, <i64 32, i64 32>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_18446744065119617024_mask_ashr_33(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_18446744065119617024_mask_ashr_33:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshr v0.2d, v0.2d, #33
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 18446744065119617024, i64 18446744065119617024>
  %t1 = ashr <2 x i64> %t0, <i64 33, i64 33>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_18446744065119617024_mask_ashr_34(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_18446744065119617024_mask_ashr_34:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshr v0.2d, v0.2d, #34
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 18446744065119617024, i64 18446744065119617024>
  %t1 = ashr <2 x i64> %t0, <i64 34, i64 34>
  ret <2 x i64> %t1
}

; shl

define <2 x i64> @test_128_i64_x_2_2147483647_mask_shl_1(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_2147483647_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2147483647
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.2d, v0.2d, #1
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 2147483647, i64 2147483647>
  %t1 = shl <2 x i64> %t0, <i64 1, i64 1>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_2147483647_mask_shl_32(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_2147483647_mask_shl_32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2147483647
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.2d, v0.2d, #32
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 2147483647, i64 2147483647>
  %t1 = shl <2 x i64> %t0, <i64 32, i64 32>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_2147483647_mask_shl_33(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_2147483647_mask_shl_33:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shl v0.2d, v0.2d, #33
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 2147483647, i64 2147483647>
  %t1 = shl <2 x i64> %t0, <i64 33, i64 33>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_2147483647_mask_shl_34(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_2147483647_mask_shl_34:
; CHECK:       // %bb.0:
; CHECK-NEXT:    shl v0.2d, v0.2d, #34
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 2147483647, i64 2147483647>
  %t1 = shl <2 x i64> %t0, <i64 34, i64 34>
  ret <2 x i64> %t1
}

define <2 x i64> @test_128_i64_x_2_140737488289792_mask_shl_15(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_140737488289792_mask_shl_15:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #140737488289792
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.2d, v0.2d, #15
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 140737488289792, i64 140737488289792>
  %t1 = shl <2 x i64> %t0, <i64 15, i64 15>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_140737488289792_mask_shl_16(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_140737488289792_mask_shl_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #140737488289792
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.2d, v0.2d, #16
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 140737488289792, i64 140737488289792>
  %t1 = shl <2 x i64> %t0, <i64 16, i64 16>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_140737488289792_mask_shl_17(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_140737488289792_mask_shl_17:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #140737488289792
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.2d, v0.2d, #17
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 140737488289792, i64 140737488289792>
  %t1 = shl <2 x i64> %t0, <i64 17, i64 17>
  ret <2 x i64> %t1
}
define <2 x i64> @test_128_i64_x_2_140737488289792_mask_shl_18(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_140737488289792_mask_shl_18:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #140737488289792
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.2d, v0.2d, #18
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 140737488289792, i64 140737488289792>
  %t1 = shl <2 x i64> %t0, <i64 18, i64 18>
  ret <2 x i64> %t1
}

define <2 x i64> @test_128_i64_x_2_18446744065119617024_mask_shl_1(<2 x i64> %a0) {
; CHECK-LABEL: test_128_i64_x_2_18446744065119617024_mask_shl_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-8589934592
; CHECK-NEXT:    dup v1.2d, x8
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    shl v0.2d, v0.2d, #1
; CHECK-NEXT:    ret
  %t0 = and <2 x i64> %a0, <i64 18446744065119617024, i64 18446744065119617024>
  %t1 = shl <2 x i64> %t0, <i64 1, i64 1>
  ret <2 x i64> %t1
}
