; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; NOTE: Test functions have been generated by multivalue-stackify.py.

; RUN: llc < %s -verify-machineinstrs -mattr=+multivalue | FileCheck %s

; Test that the multivalue stackification works

target triple = "wasm32-unknown-unknown"

declare {i32} @op_0_to_1()
declare {i32, i32} @op_0_to_2()
declare {i32, i32, i32} @op_0_to_3()
declare void @op_1_to_0(i32 %t0)
declare {i32} @op_1_to_1(i32 %t0)
declare {i32, i32} @op_1_to_2(i32 %t0)
declare {i32, i32, i32} @op_1_to_3(i32 %t0)
declare void @op_2_to_0(i32 %t0, i32 %t1)
declare {i32} @op_2_to_1(i32 %t0, i32 %t1)
declare {i32, i32} @op_2_to_2(i32 %t0, i32 %t1)
declare {i32, i32, i32} @op_2_to_3(i32 %t0, i32 %t1)

define void @f2() {
; CHECK-LABEL: f2:
; CHECK:         .functype f2 () -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    drop
; CHECK-NEXT:    drop
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  ret void
}

define void @f3() {
; CHECK-LABEL: f3:
; CHECK:         .functype f3 () -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    drop
; CHECK-NEXT:    drop
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  ret void
}

define void @f12() {
; CHECK-LABEL: f12:
; CHECK:         .functype f12 () -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    drop
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  ret void
}

define void @f13() {
; CHECK-LABEL: f13:
; CHECK:         .functype f13 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  ret void
}

define void @f14() {
; CHECK-LABEL: f14:
; CHECK:         .functype f14 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.tee 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  ret void
}

define void @f15() {
; CHECK-LABEL: f15:
; CHECK:         .functype f15 () -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  ret void
}

define void @f16() {
; CHECK-LABEL: f16:
; CHECK:         .functype f16 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  ret void
}

define void @f17() {
; CHECK-LABEL: f17:
; CHECK:         .functype f17 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  ret void
}

define void @f25() {
; CHECK-LABEL: f25:
; CHECK:         .functype f25 () -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    drop
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  ret void
}

define void @f26() {
; CHECK-LABEL: f26:
; CHECK:         .functype f26 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  ret void
}

define void @f27() {
; CHECK-LABEL: f27:
; CHECK:         .functype f27 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t1)
  ret void
}

define void @f28() {
; CHECK-LABEL: f28:
; CHECK:         .functype f28 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.tee 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  ret void
}

define void @f29() {
; CHECK-LABEL: f29:
; CHECK:         .functype f29 () -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  ret void
}

define void @f30() {
; CHECK-LABEL: f30:
; CHECK:         .functype f30 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  ret void
}

define void @f31() {
; CHECK-LABEL: f31:
; CHECK:         .functype f31 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  ret void
}

define void @f32() {
; CHECK-LABEL: f32:
; CHECK:         .functype f32 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  ret void
}

define void @f33() {
; CHECK-LABEL: f33:
; CHECK:         .functype f33 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  ret void
}

define void @f34() {
; CHECK-LABEL: f34:
; CHECK:         .functype f34 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  ret void
}

define void @f35() {
; CHECK-LABEL: f35:
; CHECK:         .functype f35 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  ret void
}

define void @f36() {
; CHECK-LABEL: f36:
; CHECK:         .functype f36 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  ret void
}

define void @f129() {
; CHECK-LABEL: f129:
; CHECK:         .functype f129 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t2)
  ret void
}

define void @f131() {
; CHECK-LABEL: f131:
; CHECK:         .functype f131 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32} %t0, 0
  %t3 = extractvalue {i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f132() {
; CHECK-LABEL: f132:
; CHECK:         .functype f132 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32} %t0, 1
  %t3 = extractvalue {i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f133() {
; CHECK-LABEL: f133:
; CHECK:         .functype f133 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32} %t0, 1
  %t3 = extractvalue {i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f141() {
; CHECK-LABEL: f141:
; CHECK:         .functype f141 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t2)
  ret void
}

define void @f143() {
; CHECK-LABEL: f143:
; CHECK:         .functype f143 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32} %t0, 0
  %t3 = extractvalue {i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f144() {
; CHECK-LABEL: f144:
; CHECK:         .functype f144 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32} %t0, 0
  %t3 = extractvalue {i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f145() {
; CHECK-LABEL: f145:
; CHECK:         .functype f145 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32} %t0, 1
  %t3 = extractvalue {i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f155() {
; CHECK-LABEL: f155:
; CHECK:         .functype f155 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f159() {
; CHECK-LABEL: f159:
; CHECK:         .functype f159 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f167() {
; CHECK-LABEL: f167:
; CHECK:         .functype f167 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f168() {
; CHECK-LABEL: f168:
; CHECK:         .functype f168 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f171() {
; CHECK-LABEL: f171:
; CHECK:         .functype f171 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f180() {
; CHECK-LABEL: f180:
; CHECK:         .functype f180 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f181() {
; CHECK-LABEL: f181:
; CHECK:         .functype f181 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f183() {
; CHECK-LABEL: f183:
; CHECK:         .functype f183 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f193() {
; CHECK-LABEL: f193:
; CHECK:         .functype f193 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f195() {
; CHECK-LABEL: f195:
; CHECK:         .functype f195 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32} @op_0_to_2()
  %t1 = extractvalue {i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f291() {
; CHECK-LABEL: f291:
; CHECK:         .functype f291 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t2)
  ret void
}

define void @f292() {
; CHECK-LABEL: f292:
; CHECK:         .functype f292 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t2)
  ret void
}

define void @f294() {
; CHECK-LABEL: f294:
; CHECK:         .functype f294 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f295() {
; CHECK-LABEL: f295:
; CHECK:         .functype f295 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f296() {
; CHECK-LABEL: f296:
; CHECK:         .functype f296 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f297() {
; CHECK-LABEL: f297:
; CHECK:         .functype f297 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f298() {
; CHECK-LABEL: f298:
; CHECK:         .functype f298 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f299() {
; CHECK-LABEL: f299:
; CHECK:         .functype f299 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f300() {
; CHECK-LABEL: f300:
; CHECK:         .functype f300 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f301() {
; CHECK-LABEL: f301:
; CHECK:         .functype f301 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f302() {
; CHECK-LABEL: f302:
; CHECK:         .functype f302 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t2)
  ret void
}

define void @f304() {
; CHECK-LABEL: f304:
; CHECK:         .functype f304 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t2)
  ret void
}

define void @f305() {
; CHECK-LABEL: f305:
; CHECK:         .functype f305 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f306() {
; CHECK-LABEL: f306:
; CHECK:         .functype f306 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f307() {
; CHECK-LABEL: f307:
; CHECK:         .functype f307 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f308() {
; CHECK-LABEL: f308:
; CHECK:         .functype f308 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f310() {
; CHECK-LABEL: f310:
; CHECK:         .functype f310 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f311() {
; CHECK-LABEL: f311:
; CHECK:         .functype f311 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f312() {
; CHECK-LABEL: f312:
; CHECK:         .functype f312 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f313() {
; CHECK-LABEL: f313:
; CHECK:         .functype f313 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f314() {
; CHECK-LABEL: f314:
; CHECK:         .functype f314 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t2)
  ret void
}

define void @f315() {
; CHECK-LABEL: f315:
; CHECK:         .functype f315 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t2)
  ret void
}

define void @f317() {
; CHECK-LABEL: f317:
; CHECK:         .functype f317 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f318() {
; CHECK-LABEL: f318:
; CHECK:         .functype f318 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f319() {
; CHECK-LABEL: f319:
; CHECK:         .functype f319 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f320() {
; CHECK-LABEL: f320:
; CHECK:         .functype f320 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f321() {
; CHECK-LABEL: f321:
; CHECK:         .functype f321 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f322() {
; CHECK-LABEL: f322:
; CHECK:         .functype f322 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f323() {
; CHECK-LABEL: f323:
; CHECK:         .functype f323 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f324() {
; CHECK-LABEL: f324:
; CHECK:         .functype f324 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t1)
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t2, i32 %t3)
  ret void
}

define void @f327() {
; CHECK-LABEL: f327:
; CHECK:         .functype f327 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f328() {
; CHECK-LABEL: f328:
; CHECK:         .functype f328 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f333() {
; CHECK-LABEL: f333:
; CHECK:         .functype f333 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f334() {
; CHECK-LABEL: f334:
; CHECK:         .functype f334 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f336() {
; CHECK-LABEL: f336:
; CHECK:         .functype f336 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f337() {
; CHECK-LABEL: f337:
; CHECK:         .functype f337 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f338() {
; CHECK-LABEL: f338:
; CHECK:         .functype f338 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f339() {
; CHECK-LABEL: f339:
; CHECK:         .functype f339 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f340() {
; CHECK-LABEL: f340:
; CHECK:         .functype f340 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f343() {
; CHECK-LABEL: f343:
; CHECK:         .functype f343 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f344() {
; CHECK-LABEL: f344:
; CHECK:         .functype f344 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f346() {
; CHECK-LABEL: f346:
; CHECK:         .functype f346 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f347() {
; CHECK-LABEL: f347:
; CHECK:         .functype f347 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f348() {
; CHECK-LABEL: f348:
; CHECK:         .functype f348 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f349() {
; CHECK-LABEL: f349:
; CHECK:         .functype f349 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f350() {
; CHECK-LABEL: f350:
; CHECK:         .functype f350 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f351() {
; CHECK-LABEL: f351:
; CHECK:         .functype f351 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f352() {
; CHECK-LABEL: f352:
; CHECK:         .functype f352 () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f354() {
; CHECK-LABEL: f354:
; CHECK:         .functype f354 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f356() {
; CHECK-LABEL: f356:
; CHECK:         .functype f356 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.tee 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f357() {
; CHECK-LABEL: f357:
; CHECK:         .functype f357 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f358() {
; CHECK-LABEL: f358:
; CHECK:         .functype f358 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f359() {
; CHECK-LABEL: f359:
; CHECK:         .functype f359 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.tee 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f360() {
; CHECK-LABEL: f360:
; CHECK:         .functype f360 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 0
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f362() {
; CHECK-LABEL: f362:
; CHECK:         .functype f362 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f363() {
; CHECK-LABEL: f363:
; CHECK:         .functype f363 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f364() {
; CHECK-LABEL: f364:
; CHECK:         .functype f364 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f366() {
; CHECK-LABEL: f366:
; CHECK:         .functype f366 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f367() {
; CHECK-LABEL: f367:
; CHECK:         .functype f367 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f370() {
; CHECK-LABEL: f370:
; CHECK:         .functype f370 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f371() {
; CHECK-LABEL: f371:
; CHECK:         .functype f371 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f372() {
; CHECK-LABEL: f372:
; CHECK:         .functype f372 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f373() {
; CHECK-LABEL: f373:
; CHECK:         .functype f373 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f374() {
; CHECK-LABEL: f374:
; CHECK:         .functype f374 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f376() {
; CHECK-LABEL: f376:
; CHECK:         .functype f376 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f377() {
; CHECK-LABEL: f377:
; CHECK:         .functype f377 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f379() {
; CHECK-LABEL: f379:
; CHECK:         .functype f379 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f383() {
; CHECK-LABEL: f383:
; CHECK:         .functype f383 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f385() {
; CHECK-LABEL: f385:
; CHECK:         .functype f385 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f386() {
; CHECK-LABEL: f386:
; CHECK:         .functype f386 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f387() {
; CHECK-LABEL: f387:
; CHECK:         .functype f387 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f388() {
; CHECK-LABEL: f388:
; CHECK:         .functype f388 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f389() {
; CHECK-LABEL: f389:
; CHECK:         .functype f389 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f390() {
; CHECK-LABEL: f390:
; CHECK:         .functype f390 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f391() {
; CHECK-LABEL: f391:
; CHECK:         .functype f391 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f392() {
; CHECK-LABEL: f392:
; CHECK:         .functype f392 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f395() {
; CHECK-LABEL: f395:
; CHECK:         .functype f395 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f396() {
; CHECK-LABEL: f396:
; CHECK:         .functype f396 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 1
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f398() {
; CHECK-LABEL: f398:
; CHECK:         .functype f398 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f399() {
; CHECK-LABEL: f399:
; CHECK:         .functype f399 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f400() {
; CHECK-LABEL: f400:
; CHECK:         .functype f400 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f402() {
; CHECK-LABEL: f402:
; CHECK:         .functype f402 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f403() {
; CHECK-LABEL: f403:
; CHECK:         .functype f403 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f404() {
; CHECK-LABEL: f404:
; CHECK:         .functype f404 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f405() {
; CHECK-LABEL: f405:
; CHECK:         .functype f405 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f406() {
; CHECK-LABEL: f406:
; CHECK:         .functype f406 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f408() {
; CHECK-LABEL: f408:
; CHECK:         .functype f408 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f410() {
; CHECK-LABEL: f410:
; CHECK:         .functype f410 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f411() {
; CHECK-LABEL: f411:
; CHECK:         .functype f411 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f412() {
; CHECK-LABEL: f412:
; CHECK:         .functype f412 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f413() {
; CHECK-LABEL: f413:
; CHECK:         .functype f413 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f414() {
; CHECK-LABEL: f414:
; CHECK:         .functype f414 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f415() {
; CHECK-LABEL: f415:
; CHECK:         .functype f415 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f416() {
; CHECK-LABEL: f416:
; CHECK:         .functype f416 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f418() {
; CHECK-LABEL: f418:
; CHECK:         .functype f418 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f419() {
; CHECK-LABEL: f419:
; CHECK:         .functype f419 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 2
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f422() {
; CHECK-LABEL: f422:
; CHECK:         .functype f422 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f423() {
; CHECK-LABEL: f423:
; CHECK:         .functype f423 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_1_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_1_to_0(i32 %t3)
  ret void
}

define void @f425() {
; CHECK-LABEL: f425:
; CHECK:         .functype f425 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f426() {
; CHECK-LABEL: f426:
; CHECK:         .functype f426 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 0
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f428() {
; CHECK-LABEL: f428:
; CHECK:         .functype f428 () -> ()
; CHECK-NEXT:    .local i32, i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 2
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    local.get 2
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 0
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}

define void @f429() {
; CHECK-LABEL: f429:
; CHECK:         .functype f429 () -> ()
; CHECK-NEXT:    .local i32, i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    call op_0_to_3
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    local.set 0
; CHECK-NEXT:    drop
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    call op_2_to_0
; CHECK-NEXT:    # fallthrough-return
  %t0 = call {i32, i32, i32} @op_0_to_3()
  %t1 = extractvalue {i32, i32, i32} %t0, 2
  %t2 = extractvalue {i32, i32, i32} %t0, 2
  call void @op_2_to_0(i32 %t1, i32 %t2)
  %t3 = extractvalue {i32, i32, i32} %t0, 1
  %t4 = extractvalue {i32, i32, i32} %t0, 1
  call void @op_2_to_0(i32 %t3, i32 %t4)
  ret void
}
