/* hashset.c generated by valac 0.18.0.57-8d977, the Vala compiler
 * generated from hashset.vala, do not modify */

/* hashset.vala
 *
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 * Copyright (C) 1997-2000  GLib Team and others
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_TYPE_ABSTRACT_SET (gee_abstract_set_get_type ())
#define GEE_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSet))
#define GEE_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))
#define GEE_IS_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_SET))
#define GEE_IS_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_SET))
#define GEE_ABSTRACT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))

typedef struct _GeeAbstractSet GeeAbstractSet;
typedef struct _GeeAbstractSetClass GeeAbstractSetClass;
typedef struct _GeeAbstractSetPrivate GeeAbstractSetPrivate;

#define GEE_TYPE_HASH_SET (gee_hash_set_get_type ())
#define GEE_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_HASH_SET, GeeHashSet))
#define GEE_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_HASH_SET, GeeHashSetClass))
#define GEE_IS_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_HASH_SET))
#define GEE_IS_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_HASH_SET))
#define GEE_HASH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_HASH_SET, GeeHashSetClass))

typedef struct _GeeHashSet GeeHashSet;
typedef struct _GeeHashSetClass GeeHashSetClass;
typedef struct _GeeHashSetPrivate GeeHashSetPrivate;
typedef struct _GeeHashSetNode GeeHashSetNode;

#define GEE_HASH_SET_TYPE_ITERATOR (gee_hash_set_iterator_get_type ())
#define GEE_HASH_SET_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator))
#define GEE_HASH_SET_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorClass))
#define GEE_HASH_SET_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_HASH_SET_TYPE_ITERATOR))
#define GEE_HASH_SET_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_HASH_SET_TYPE_ITERATOR))
#define GEE_HASH_SET_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorClass))

typedef struct _GeeHashSetIterator GeeHashSetIterator;
typedef struct _GeeHashSetIteratorClass GeeHashSetIteratorClass;
#define _gee_hash_set_node_free0(var) ((var == NULL) ? NULL : (var = (gee_hash_set_node_free (var), NULL)))
typedef struct _GeeHashSetIteratorPrivate GeeHashSetIteratorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_read_only_view) (GeeSet* self);
};

struct _GeeAbstractSet {
	GeeAbstractCollection parent_instance;
	GeeAbstractSetPrivate * priv;
};

struct _GeeAbstractSetClass {
	GeeAbstractCollectionClass parent_class;
	GeeSet* (*get_read_only_view) (GeeAbstractSet* self);
};

struct _GeeHashSet {
	GeeAbstractSet parent_instance;
	GeeHashSetPrivate * priv;
};

struct _GeeHashSetClass {
	GeeAbstractSetClass parent_class;
};

struct _GeeHashSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GHashFunc _hash_func;
	GEqualFunc _equal_func;
	gint _array_size;
	gint _nnodes;
	GeeHashSetNode** _nodes;
	gint _nodes_length1;
	gint __nodes_size_;
	gint _stamp;
};

struct _GeeHashSetNode {
	gpointer key;
	GeeHashSetNode* next;
	guint key_hash;
};

struct _GeeHashSetIterator {
	GObject parent_instance;
	GeeHashSetIteratorPrivate * priv;
};

struct _GeeHashSetIteratorClass {
	GObjectClass parent_class;
};

struct _GeeHashSetIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeHashSet* _set;
	gint _index;
	GeeHashSetNode* _node;
	GeeHashSetNode* _next;
	gint _stamp;
};


static gpointer gee_hash_set_parent_class = NULL;
static gpointer gee_hash_set_iterator_parent_class = NULL;
static GeeIteratorIface* gee_hash_set_iterator_gee_iterator_parent_iface = NULL;

GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_set_get_type (void) G_GNUC_CONST;
GType gee_abstract_set_get_type (void) G_GNUC_CONST;
GType gee_hash_set_get_type (void) G_GNUC_CONST;
static void gee_hash_set_node_free (GeeHashSetNode* self);
#define GEE_HASH_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_HASH_SET, GeeHashSetPrivate))
enum  {
	GEE_HASH_SET_DUMMY_PROPERTY,
	GEE_HASH_SET_G_TYPE,
	GEE_HASH_SET_G_DUP_FUNC,
	GEE_HASH_SET_G_DESTROY_FUNC,
	GEE_HASH_SET_SIZE,
	GEE_HASH_SET_HASH_FUNC,
	GEE_HASH_SET_EQUAL_FUNC
};
void gee_abstract_collection_clear (GeeAbstractCollection* self);
#define GEE_HASH_SET_MIN_SIZE 11
#define GEE_HASH_SET_MAX_SIZE 13845163
GeeHashSet* gee_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
GeeHashSet* gee_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
GeeAbstractSet* gee_abstract_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GHashFunc gee_functions_get_hash_func_for (GType t);
GEqualFunc gee_functions_get_equal_func_for (GType t);
static void gee_hash_set_set_hash_func (GeeHashSet* self, GHashFunc value);
static void gee_hash_set_set_equal_func (GeeHashSet* self, GEqualFunc value);
static GeeHashSetNode** gee_hash_set_lookup_node (GeeHashSet* self, gconstpointer key);
GHashFunc gee_hash_set_get_hash_func (GeeHashSet* self);
GEqualFunc gee_hash_set_get_equal_func (GeeHashSet* self);
static gboolean gee_hash_set_real_contains (GeeAbstractCollection* base, gconstpointer key);
static GeeIterator* gee_hash_set_real_iterator (GeeAbstractCollection* base);
static GeeHashSetIterator* gee_hash_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set);
static GeeHashSetIterator* gee_hash_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set);
static GType gee_hash_set_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean gee_hash_set_real_add (GeeAbstractCollection* base, gconstpointer key);
static GeeHashSetNode* gee_hash_set_node_new (gpointer k, guint hash);
static GeeHashSetNode* gee_hash_set_node_new (gpointer k, guint hash);
static void gee_hash_set_resize (GeeHashSet* self);
static gboolean gee_hash_set_real_remove (GeeAbstractCollection* base, gconstpointer key);
static inline gboolean gee_hash_set_remove_helper (GeeHashSet* self, gconstpointer key);
static void gee_hash_set_real_clear (GeeAbstractCollection* base);
static void gee_hash_set_node_instance_init (GeeHashSetNode * self);
#define GEE_HASH_SET_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIteratorPrivate))
enum  {
	GEE_HASH_SET_ITERATOR_DUMMY_PROPERTY,
	GEE_HASH_SET_ITERATOR_G_TYPE,
	GEE_HASH_SET_ITERATOR_G_DUP_FUNC,
	GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_hash_set_iterator_real_next (GeeIterator* base);
gboolean gee_iterator_has_next (GeeIterator* self);
static gboolean gee_hash_set_iterator_real_has_next (GeeIterator* base);
static gboolean gee_hash_set_iterator_real_first (GeeIterator* base);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
static gpointer gee_hash_set_iterator_real_get (GeeIterator* base);
static void gee_hash_set_iterator_real_remove (GeeIterator* base);
static void gee_hash_set_iterator_finalize (GObject* obj);
static void _vala_gee_hash_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_hash_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_hash_set_finalize (GObject* obj);
static void _vala_gee_hash_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_hash_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Constructs a new, empty hash set.
 *
 * If not provided, the functions parameters are requested to the
 * {@link Functions} function factory methods.
 *
 * @param hash_func an optional hash function
 * @param equal_func an optional equality testing function
 */
GeeHashSet* gee_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func) {
	GeeHashSet * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp2_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	gint _tmp6_;
	GeeHashSetNode** _tmp7_ = NULL;
#line 73 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) gee_abstract_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 73 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->g_type = g_type;
#line 73 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 73 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 74 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = hash_func;
#line 74 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp0_ == NULL) {
#line 333 "hashset.c"
		GHashFunc _tmp1_ = NULL;
#line 75 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp1_ = gee_functions_get_hash_func_for (g_type);
#line 75 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		hash_func = _tmp1_;
#line 339 "hashset.c"
	}
#line 77 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = equal_func;
#line 77 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp2_ == NULL) {
#line 345 "hashset.c"
		GEqualFunc _tmp3_ = NULL;
#line 78 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp3_ = gee_functions_get_equal_func_for (g_type);
#line 78 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		equal_func = _tmp3_;
#line 351 "hashset.c"
	}
#line 80 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4_ = hash_func;
#line 80 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_set_hash_func (self, _tmp4_);
#line 81 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp5_ = equal_func;
#line 81 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_set_equal_func (self, _tmp5_);
#line 82 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_array_size = GEE_HASH_SET_MIN_SIZE;
#line 83 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp6_ = self->priv->_array_size;
#line 83 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp7_ = g_new0 (GeeHashSetNode*, _tmp6_ + 1);
#line 83 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
#line 83 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_nodes = _tmp7_;
#line 83 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_nodes_length1 = _tmp6_;
#line 83 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->__nodes_size_ = self->priv->_nodes_length1;
#line 73 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return self;
#line 377 "hashset.c"
}


GeeHashSet* gee_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func) {
#line 73 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return gee_hash_set_construct (GEE_TYPE_HASH_SET, g_type, g_dup_func, g_destroy_func, hash_func, equal_func);
#line 384 "hashset.c"
}


static GeeHashSetNode** gee_hash_set_lookup_node (GeeHashSet* self, gconstpointer key) {
	GeeHashSetNode** result = NULL;
	GHashFunc _tmp0_;
	GHashFunc _tmp1_;
	gconstpointer _tmp2_;
	guint _tmp3_ = 0U;
	guint hash_value;
	GeeHashSetNode** _tmp4_;
	gint _tmp4__length1;
	guint _tmp5_;
	gint _tmp6_;
	GeeHashSetNode** node;
	GeeHashSetNode** _tmp22_;
#line 86 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = gee_hash_set_get_hash_func (self);
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = _tmp0_;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = key;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = _tmp1_ (_tmp2_);
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	hash_value = _tmp3_;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4_ = self->priv->_nodes;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4__length1 = self->priv->_nodes_length1;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp5_ = hash_value;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp6_ = self->priv->_array_size;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	node = &_tmp4_[_tmp5_ % _tmp6_];
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	while (TRUE) {
#line 425 "hashset.c"
		gboolean _tmp7_ = FALSE;
		GeeHashSetNode** _tmp8_;
		gboolean _tmp20_;
		GeeHashSetNode** _tmp21_;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp8_ = node;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		if ((*_tmp8_) != NULL) {
#line 434 "hashset.c"
			gboolean _tmp9_ = FALSE;
			guint _tmp10_;
			GeeHashSetNode** _tmp11_;
			guint _tmp12_;
			gboolean _tmp19_;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp10_ = hash_value;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp11_ = node;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp12_ = (*_tmp11_)->key_hash;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			if (_tmp10_ != _tmp12_) {
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp9_ = TRUE;
#line 450 "hashset.c"
			} else {
				GEqualFunc _tmp13_;
				GEqualFunc _tmp14_;
				GeeHashSetNode** _tmp15_;
				gconstpointer _tmp16_;
				gconstpointer _tmp17_;
				gboolean _tmp18_ = FALSE;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp13_ = gee_hash_set_get_equal_func (self);
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp14_ = _tmp13_;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp15_ = node;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp16_ = (*_tmp15_)->key;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp17_ = key;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp18_ = _tmp14_ (_tmp16_, _tmp17_);
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp9_ = !_tmp18_;
#line 472 "hashset.c"
			}
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp19_ = _tmp9_;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp7_ = _tmp19_;
#line 478 "hashset.c"
		} else {
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp7_ = FALSE;
#line 482 "hashset.c"
		}
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp20_ = _tmp7_;
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		if (!_tmp20_) {
#line 89 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			break;
#line 490 "hashset.c"
		}
#line 90 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp21_ = node;
#line 90 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		node = &(*_tmp21_)->next;
#line 496 "hashset.c"
	}
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp22_ = node;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp22_;
#line 92 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 504 "hashset.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_hash_set_real_contains (GeeAbstractCollection* base, gconstpointer key) {
	GeeHashSet * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	GeeHashSetNode** _tmp1_ = NULL;
	GeeHashSetNode** node;
#line 98 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) base;
#line 99 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = key;
#line 99 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = gee_hash_set_lookup_node (self, _tmp0_);
#line 99 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	node = _tmp1_;
#line 100 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = (*node) != NULL;
#line 100 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 529 "hashset.c"
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_hash_set_real_iterator (GeeAbstractCollection* base) {
	GeeHashSet * self;
	GeeIterator* result = NULL;
	GeeHashSetIterator* _tmp0_;
#line 106 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) base;
#line 107 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = gee_hash_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 107 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = (GeeIterator*) _tmp0_;
#line 107 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 548 "hashset.c"
}


/**
 * {@inheritDoc}
 */
static gboolean gee_hash_set_real_add (GeeAbstractCollection* base, gconstpointer key) {
	GeeHashSet * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	GeeHashSetNode** _tmp1_ = NULL;
	GeeHashSetNode** node;
	GeeHashSetNode** _tmp2_;
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) base;
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = key;
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = gee_hash_set_lookup_node (self, _tmp0_);
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	node = _tmp1_;
#line 115 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = node;
#line 115 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if ((*_tmp2_) != NULL) {
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		result = FALSE;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		return result;
#line 578 "hashset.c"
	} else {
		GHashFunc _tmp3_;
		GHashFunc _tmp4_;
		gconstpointer _tmp5_;
		guint _tmp6_ = 0U;
		guint hash_value;
		GeeHashSetNode** _tmp7_;
		gconstpointer _tmp8_;
		gpointer _tmp9_;
		guint _tmp10_;
		GeeHashSetNode* _tmp11_;
		GeeHashSetNode* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp3_ = gee_hash_set_get_hash_func (self);
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp4_ = _tmp3_;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp5_ = key;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp6_ = _tmp4_ (_tmp5_);
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		hash_value = _tmp6_;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp7_ = node;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp8_ = key;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp9_ = ((_tmp8_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp8_) : ((gpointer) _tmp8_);
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp10_ = hash_value;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp11_ = gee_hash_set_node_new (_tmp9_, _tmp10_);
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		*_tmp7_ = _tmp11_;
#line 119 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp12_ = *_tmp7_;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp13_ = self->priv->_nnodes;
#line 120 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_nnodes = _tmp13_ + 1;
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		gee_hash_set_resize (self);
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp14_ = self->priv->_stamp;
#line 122 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_stamp = _tmp14_ + 1;
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		result = TRUE;
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		return result;
#line 631 "hashset.c"
	}
}


/**
 * {@inheritDoc}
 */
static gboolean gee_hash_set_real_remove (GeeAbstractCollection* base, gconstpointer key) {
	GeeHashSet * self;
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean b;
	gboolean _tmp2_;
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) base;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = key;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = gee_hash_set_remove_helper (self, _tmp0_);
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	b = _tmp1_;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = b;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp2_) {
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		gee_hash_set_resize (self);
#line 660 "hashset.c"
	}
#line 135 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = b;
#line 135 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 666 "hashset.c"
}


/**
 * {@inheritDoc}
 */
static void gee_hash_set_real_clear (GeeAbstractCollection* base) {
	GeeHashSet * self;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) base;
#line 677 "hashset.c"
	{
		gint i;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		i = 0;
#line 682 "hashset.c"
		{
			gboolean _tmp0_;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp0_ = TRUE;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			while (TRUE) {
#line 689 "hashset.c"
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				GeeHashSetNode** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				GeeHashSetNode* _tmp7_;
				GeeHashSetNode* node;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp1_ = _tmp0_;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				if (!_tmp1_) {
#line 702 "hashset.c"
					gint _tmp2_;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp2_ = i;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					i = _tmp2_ + 1;
#line 708 "hashset.c"
				}
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp0_ = FALSE;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp3_ = i;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp4_ = self->priv->_array_size;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					break;
#line 720 "hashset.c"
				}
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp5_ = self->priv->_nodes;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp5__length1 = self->priv->_nodes_length1;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp6_ = i;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp7_ = _tmp5_[_tmp6_];
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp5_[_tmp6_] = NULL;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				node = _tmp7_;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				while (TRUE) {
#line 736 "hashset.c"
					GeeHashSetNode* _tmp8_;
					GeeHashSetNode* _tmp9_;
					GeeHashSetNode* _tmp10_;
					GeeHashSetNode* next;
					GeeHashSetNode* _tmp11_;
					GeeHashSetNode* _tmp12_;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp8_ = node;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					if (!(_tmp8_ != NULL)) {
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						break;
#line 749 "hashset.c"
					}
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp9_ = node;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp10_ = _tmp9_->next;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp9_->next = NULL;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					next = _tmp10_;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp11_ = node;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					((_tmp11_->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp11_->key = (self->priv->g_destroy_func (_tmp11_->key), NULL));
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp11_->key = NULL;
#line 147 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp12_ = next;
#line 147 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					next = NULL;
#line 147 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_gee_hash_set_node_free0 (node);
#line 147 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					node = _tmp12_;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_gee_hash_set_node_free0 (next);
#line 775 "hashset.c"
				}
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_gee_hash_set_node_free0 (node);
#line 779 "hashset.c"
			}
		}
	}
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_nnodes = 0;
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_resize (self);
#line 787 "hashset.c"
}


static inline gboolean gee_hash_set_remove_helper (GeeHashSet* self, gconstpointer key) {
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	GeeHashSetNode** _tmp1_ = NULL;
	GeeHashSetNode** node;
	GeeHashSetNode** _tmp2_;
#line 154 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = key;
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = gee_hash_set_lookup_node (self, _tmp0_);
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	node = _tmp1_;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = node;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if ((*_tmp2_) != NULL) {
#line 809 "hashset.c"
		GeeHashSetNode** _tmp3_;
		GeeHashSetNode** _tmp4_;
		GeeHashSetNode* _tmp5_;
		GeeHashSetNode* next;
		GeeHashSetNode** _tmp6_;
		GeeHashSetNode** _tmp7_;
		GeeHashSetNode** _tmp8_;
		GeeHashSetNode* _tmp9_;
		GeeHashSetNode* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp3_ = node;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_vala_assert ((*_tmp3_) != NULL, "*node != null");
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp4_ = node;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp5_ = (*_tmp4_)->next;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		(*_tmp4_)->next = NULL;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		next = _tmp5_;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp6_ = node;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		(((*_tmp6_)->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp6_)->key = (self->priv->g_destroy_func ((*_tmp6_)->key), NULL));
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		(*_tmp6_)->key = NULL;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp7_ = node;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		gee_hash_set_node_free (*_tmp7_);
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp8_ = node;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp9_ = next;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		next = NULL;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		*_tmp8_ = _tmp9_;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp10_ = *_tmp8_;
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp11_ = self->priv->_nnodes;
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_nnodes = _tmp11_ - 1;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp12_ = self->priv->_stamp;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_stamp = _tmp12_ + 1;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		result = TRUE;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_gee_hash_set_node_free0 (next);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		return result;
#line 867 "hashset.c"
	}
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = FALSE;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 873 "hashset.c"
}


static void gee_hash_set_resize (GeeHashSet* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp5_;
	gboolean _tmp11_;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_if_fail (self != NULL);
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = self->priv->_array_size;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = self->priv->_nnodes;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp2_ >= (3 * _tmp3_)) {
#line 892 "hashset.c"
		gint _tmp4_;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp4_ = self->priv->_array_size;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp1_ = _tmp4_ >= GEE_HASH_SET_MIN_SIZE;
#line 898 "hashset.c"
	} else {
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp1_ = FALSE;
#line 902 "hashset.c"
	}
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp5_ = _tmp1_;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp5_) {
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp0_ = TRUE;
#line 910 "hashset.c"
	} else {
		gboolean _tmp6_ = FALSE;
		gint _tmp7_;
		gint _tmp8_;
		gboolean _tmp10_;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp7_ = self->priv->_array_size;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp8_ = self->priv->_nnodes;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		if ((3 * _tmp7_) <= _tmp8_) {
#line 922 "hashset.c"
			gint _tmp9_;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp9_ = self->priv->_array_size;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp6_ = _tmp9_ < GEE_HASH_SET_MAX_SIZE;
#line 928 "hashset.c"
		} else {
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp6_ = FALSE;
#line 932 "hashset.c"
		}
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp10_ = _tmp6_;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp0_ = _tmp10_;
#line 938 "hashset.c"
	}
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp11_ = _tmp0_;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp11_) {
#line 944 "hashset.c"
		gint _tmp12_;
		guint _tmp13_ = 0U;
		gint new_array_size;
		gint _tmp14_;
		gint _tmp15_ = 0;
		gint _tmp16_;
		GeeHashSetNode** _tmp17_ = NULL;
		GeeHashSetNode** new_nodes;
		gint new_nodes_length1;
		gint _new_nodes_size_;
		GeeHashSetNode** _tmp43_;
		gint _tmp43__length1;
		gint _tmp44_;
#line 175 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp12_ = self->priv->_nnodes;
#line 175 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp13_ = g_spaced_primes_closest ((guint) _tmp12_);
#line 175 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		new_array_size = (gint) _tmp13_;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp14_ = new_array_size;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp15_ = CLAMP (_tmp14_, GEE_HASH_SET_MIN_SIZE, GEE_HASH_SET_MAX_SIZE);
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		new_array_size = _tmp15_;
#line 178 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp16_ = new_array_size;
#line 178 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp17_ = g_new0 (GeeHashSetNode*, _tmp16_ + 1);
#line 178 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		new_nodes = _tmp17_;
#line 178 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		new_nodes_length1 = _tmp16_;
#line 178 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_new_nodes_size_ = new_nodes_length1;
#line 980 "hashset.c"
		{
			gint i;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			i = 0;
#line 985 "hashset.c"
			{
				gboolean _tmp18_;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp18_ = TRUE;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				while (TRUE) {
#line 992 "hashset.c"
					gboolean _tmp19_;
					gint _tmp21_;
					gint _tmp22_;
					GeeHashSetNode* node = NULL;
					GeeHashSetNode* next;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp19_ = _tmp18_;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					if (!_tmp19_) {
#line 1002 "hashset.c"
						gint _tmp20_;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp20_ = i;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						i = _tmp20_ + 1;
#line 1008 "hashset.c"
					}
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp18_ = FALSE;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp21_ = i;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_tmp22_ = self->priv->_array_size;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					if (!(_tmp21_ < _tmp22_)) {
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						break;
#line 1020 "hashset.c"
					}
#line 182 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					next = NULL;
#line 1024 "hashset.c"
					{
						GeeHashSetNode** _tmp23_;
						gint _tmp23__length1;
						gint _tmp24_;
						GeeHashSetNode* _tmp25_;
						gboolean _tmp26_;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp23_ = self->priv->_nodes;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp23__length1 = self->priv->_nodes_length1;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp24_ = i;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp25_ = _tmp23_[_tmp24_];
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp23_[_tmp24_] = NULL;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_gee_hash_set_node_free0 (node);
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						node = _tmp25_;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						_tmp26_ = TRUE;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
						while (TRUE) {
#line 1049 "hashset.c"
							gboolean _tmp27_;
							GeeHashSetNode* _tmp29_;
							GeeHashSetNode* _tmp30_;
							GeeHashSetNode* _tmp31_;
							GeeHashSetNode* _tmp32_;
							guint _tmp33_;
							gint _tmp34_;
							guint hash_val;
							GeeHashSetNode* _tmp35_;
							GeeHashSetNode** _tmp36_;
							gint _tmp36__length1;
							guint _tmp37_;
							GeeHashSetNode* _tmp38_;
							GeeHashSetNode** _tmp39_;
							gint _tmp39__length1;
							guint _tmp40_;
							GeeHashSetNode* _tmp41_;
							GeeHashSetNode* _tmp42_;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp27_ = _tmp26_;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							if (!_tmp27_) {
#line 1072 "hashset.c"
								GeeHashSetNode* _tmp28_;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
								_tmp28_ = next;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
								next = NULL;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
								_gee_hash_set_node_free0 (node);
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
								node = _tmp28_;
#line 1082 "hashset.c"
							}
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp26_ = FALSE;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp29_ = node;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							if (!(_tmp29_ != NULL)) {
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
								break;
#line 1092 "hashset.c"
							}
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp30_ = node;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp31_ = _tmp30_->next;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp30_->next = NULL;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_gee_hash_set_node_free0 (next);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							next = _tmp31_;
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp32_ = node;
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp33_ = _tmp32_->key_hash;
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp34_ = new_array_size;
#line 185 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							hash_val = _tmp33_ % _tmp34_;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp35_ = node;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp36_ = new_nodes;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp36__length1 = new_nodes_length1;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp37_ = hash_val;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp38_ = _tmp36_[_tmp37_];
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp36_[_tmp37_] = NULL;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_gee_hash_set_node_free0 (_tmp35_->next);
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp35_->next = _tmp38_;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp39_ = new_nodes;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp39__length1 = new_nodes_length1;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp40_ = hash_val;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp41_ = node;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							node = NULL;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_gee_hash_set_node_free0 (_tmp39_[_tmp40_]);
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp39_[_tmp40_] = _tmp41_;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
							_tmp42_ = _tmp39_[_tmp40_];
#line 1144 "hashset.c"
						}
					}
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_gee_hash_set_node_free0 (next);
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
					_gee_hash_set_node_free0 (node);
#line 1151 "hashset.c"
				}
			}
		}
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp43_ = new_nodes;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp43__length1 = new_nodes_length1;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		new_nodes = NULL;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_nodes = _tmp43_;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_nodes_length1 = _tmp43__length1;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->__nodes_size_ = self->priv->_nodes_length1;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp44_ = new_array_size;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_array_size = _tmp44_;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		new_nodes = (_vala_array_free (new_nodes, new_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
#line 1175 "hashset.c"
	}
}


static gint gee_hash_set_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeHashSet* self;
	gint _tmp0_;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSet*) base;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_nnodes;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp0_;
#line 41 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1192 "hashset.c"
}


GHashFunc gee_hash_set_get_hash_func (GeeHashSet* self) {
	GHashFunc result;
	GHashFunc _tmp0_;
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_hash_func;
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp0_;
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1207 "hashset.c"
}


static void gee_hash_set_set_hash_func (GeeHashSet* self, GHashFunc value) {
	GHashFunc _tmp0_;
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_if_fail (self != NULL);
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = value;
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_hash_func = _tmp0_;
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_notify ((GObject *) self, "hash-func");
#line 1221 "hashset.c"
}


GEqualFunc gee_hash_set_get_equal_func (GeeHashSet* self) {
	GEqualFunc result;
	GEqualFunc _tmp0_;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_equal_func;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp0_;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1236 "hashset.c"
}


static void gee_hash_set_set_equal_func (GeeHashSet* self, GEqualFunc value) {
	GEqualFunc _tmp0_;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_if_fail (self != NULL);
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = value;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_equal_func = _tmp0_;
#line 52 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_notify ((GObject *) self, "equal-func");
#line 1250 "hashset.c"
}


static GeeHashSetNode* gee_hash_set_node_new (gpointer k, guint hash) {
	GeeHashSetNode* self;
	gpointer _tmp0_;
	guint _tmp1_;
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = g_slice_new0 (GeeHashSetNode);
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_node_instance_init (self);
#line 206 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = k;
#line 206 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	k = NULL;
#line 206 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->key = _tmp0_;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = hash;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->key_hash = _tmp1_;
#line 205 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return self;
#line 1274 "hashset.c"
}


static void gee_hash_set_node_instance_init (GeeHashSetNode * self) {
}


static void gee_hash_set_node_free (GeeHashSetNode* self) {
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_gee_hash_set_node_free0 (self->next);
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_slice_free (GeeHashSetNode, self);
#line 1287 "hashset.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return self ? g_object_ref (self) : NULL;
#line 1294 "hashset.c"
}


static GeeHashSetIterator* gee_hash_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set) {
	GeeHashSetIterator * self = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeHashSet* _tmp2_;
	gint _tmp3_;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_return_val_if_fail (set != NULL, NULL);
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) g_object_new (object_type, NULL);
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->g_type = g_type;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->g_dup_func = g_dup_func;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = set;
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_g_object_unref0 (self->priv->_set);
#line 221 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_set = _tmp1_;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = self->priv->_set;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = _tmp2_->priv->_stamp;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_stamp = _tmp3_;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return self;
#line 1330 "hashset.c"
}


static GeeHashSetIterator* gee_hash_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashSet* set) {
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return gee_hash_set_iterator_construct (GEE_HASH_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set);
#line 1337 "hashset.c"
}


static gboolean gee_hash_set_iterator_real_next (GeeIterator* base) {
	GeeHashSetIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeHashSet* _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	GeeHashSetNode* _tmp4_;
	GeeHashSetNode* _tmp5_;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) base;
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_stamp;
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = self->priv->_set;
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
#line 227 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = gee_iterator_has_next ((GeeIterator*) self);
#line 227 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (!_tmp3_) {
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		result = FALSE;
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		return result;
#line 1368 "hashset.c"
	}
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4_ = self->priv->_next;
#line 230 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_node = _tmp4_;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_next = NULL;
#line 232 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp5_ = self->priv->_node;
#line 232 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp5_ != NULL;
#line 232 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1382 "hashset.c"
}


static gboolean gee_hash_set_iterator_real_has_next (GeeIterator* base) {
	GeeHashSetIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeHashSet* _tmp1_;
	gint _tmp2_;
	GeeHashSetNode* _tmp3_;
	GeeHashSetNode* _tmp19_;
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) base;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_stamp;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = self->priv->_set;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = self->priv->_next;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp3_ == NULL) {
#line 1408 "hashset.c"
		GeeHashSetNode* _tmp4_;
		GeeHashSetNode* _tmp5_;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp4_ = self->priv->_node;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->_next = _tmp4_;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		_tmp5_ = self->priv->_next;
#line 239 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		if (_tmp5_ != NULL) {
#line 1419 "hashset.c"
			GeeHashSetNode* _tmp6_;
			GeeHashSetNode* _tmp7_;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp6_ = self->priv->_next;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp7_ = _tmp6_->next;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			self->priv->_next = _tmp7_;
#line 1428 "hashset.c"
		}
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		while (TRUE) {
#line 1432 "hashset.c"
			gboolean _tmp8_ = FALSE;
			GeeHashSetNode* _tmp9_;
			gboolean _tmp13_;
			gint _tmp14_;
			GeeHashSet* _tmp15_;
			GeeHashSetNode** _tmp16_;
			gint _tmp16__length1;
			gint _tmp17_;
			GeeHashSetNode* _tmp18_;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp9_ = self->priv->_next;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			if (_tmp9_ == NULL) {
#line 1446 "hashset.c"
				gint _tmp10_;
				GeeHashSet* _tmp11_;
				gint _tmp12_;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp10_ = self->priv->_index;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp11_ = self->priv->_set;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp12_ = _tmp11_->priv->_array_size;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp8_ = (_tmp10_ + 1) < _tmp12_;
#line 1458 "hashset.c"
			} else {
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				_tmp8_ = FALSE;
#line 1462 "hashset.c"
			}
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp13_ = _tmp8_;
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			if (!_tmp13_) {
#line 242 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
				break;
#line 1470 "hashset.c"
			}
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp14_ = self->priv->_index;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			self->priv->_index = _tmp14_ + 1;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp15_ = self->priv->_set;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp16_ = _tmp15_->priv->_nodes;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp16__length1 = _tmp15_->priv->_nodes_length1;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp17_ = self->priv->_index;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			_tmp18_ = _tmp16_[_tmp17_];
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
			self->priv->_next = _tmp18_;
#line 1488 "hashset.c"
		}
	}
#line 247 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp19_ = self->priv->_next;
#line 247 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp19_ != NULL;
#line 247 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1497 "hashset.c"
}


static gboolean gee_hash_set_iterator_real_first (GeeIterator* base) {
	GeeHashSetIterator * self;
	gboolean result = FALSE;
	gint _tmp0_;
	GeeHashSet* _tmp1_;
	gint _tmp2_;
	GeeHashSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp6_ = FALSE;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) base;
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_stamp;
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = self->priv->_set;
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = self->priv->_set;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp5_ = _tmp4_;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	if (_tmp5_ == 0) {
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		result = FALSE;
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		return result;
#line 1533 "hashset.c"
	}
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_index = -1;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_next = NULL;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp6_ = gee_iterator_next ((GeeIterator*) self);
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp6_;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1545 "hashset.c"
}


static gpointer gee_hash_set_iterator_real_get (GeeIterator* base) {
	GeeHashSetIterator * self;
	gpointer result = NULL;
	gint _tmp0_;
	GeeHashSet* _tmp1_;
	gint _tmp2_;
	GeeHashSetNode* _tmp3_;
	GeeHashSetNode* _tmp4_;
	gconstpointer _tmp5_;
	gpointer _tmp6_;
#line 260 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) base;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_stamp;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = self->priv->_set;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = self->priv->_node;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp3_ != NULL, "_node != null");
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4_ = self->priv->_node;
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp5_ = _tmp4_->key;
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp6_ = ((_tmp5_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp5_) : ((gpointer) _tmp5_);
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	result = _tmp6_;
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	return result;
#line 1583 "hashset.c"
}


static void gee_hash_set_iterator_real_remove (GeeIterator* base) {
	GeeHashSetIterator * self;
	gint _tmp0_;
	GeeHashSet* _tmp1_;
	gint _tmp2_;
	GeeHashSetNode* _tmp3_;
	GeeHashSet* _tmp4_;
	GeeHashSetNode* _tmp5_;
	gconstpointer _tmp6_;
	GeeHashSet* _tmp7_;
	gint _tmp8_;
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = (GeeHashSetIterator*) base;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp0_ = self->priv->_stamp;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp1_ = self->priv->_set;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp2_ = _tmp1_->priv->_stamp;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp0_ == _tmp2_, "_stamp == _set._stamp");
#line 268 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp3_ = self->priv->_node;
#line 268 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_vala_assert (_tmp3_ != NULL, "_node != null");
#line 269 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_iterator_has_next ((GeeIterator*) self);
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp4_ = self->priv->_set;
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp5_ = self->priv->_node;
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp6_ = _tmp5_->key;
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_remove_helper (_tmp4_, _tmp6_);
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_node = NULL;
#line 272 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp7_ = self->priv->_set;
#line 272 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_tmp8_ = _tmp7_->priv->_stamp;
#line 272 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_stamp = _tmp8_;
#line 1630 "hashset.c"
}


static void gee_hash_set_iterator_class_init (GeeHashSetIteratorClass * klass) {
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_iterator_parent_class = g_type_class_peek_parent (klass);
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_type_class_add_private (klass, sizeof (GeeHashSetIteratorPrivate));
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_hash_set_iterator_get_property;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_hash_set_iterator_set_property;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (klass)->finalize = gee_hash_set_iterator_finalize;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 1651 "hashset.c"
}


static void gee_hash_set_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->next = (gboolean (*)(GeeIterator*)) gee_hash_set_iterator_real_next;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->has_next = (gboolean (*)(GeeIterator*)) gee_hash_set_iterator_real_has_next;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->first = (gboolean (*)(GeeIterator*)) gee_hash_set_iterator_real_first;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->get = (gpointer (*)(GeeIterator*)) gee_hash_set_iterator_real_get;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	iface->remove = (void (*)(GeeIterator*)) gee_hash_set_iterator_real_remove;
#line 1668 "hashset.c"
}


static void gee_hash_set_iterator_instance_init (GeeHashSetIterator * self) {
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv = GEE_HASH_SET_ITERATOR_GET_PRIVATE (self);
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_index = -1;
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_stamp = 0;
#line 1679 "hashset.c"
}


static void gee_hash_set_iterator_finalize (GObject* obj) {
	GeeHashSetIterator * self;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator);
#line 212 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	_g_object_unref0 (self->priv->_set);
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (gee_hash_set_iterator_parent_class)->finalize (obj);
#line 1691 "hashset.c"
}


static GType gee_hash_set_iterator_get_type (void) {
	static volatile gsize gee_hash_set_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_hash_set_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeHashSetIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_hash_set_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeHashSetIterator), 0, (GInstanceInitFunc) gee_hash_set_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_hash_set_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_hash_set_iterator_type_id;
		gee_hash_set_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeHashSetIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_hash_set_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_once_init_leave (&gee_hash_set_iterator_type_id__volatile, gee_hash_set_iterator_type_id);
	}
	return gee_hash_set_iterator_type_id__volatile;
}


static void _vala_gee_hash_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeHashSetIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator);
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	switch (property_id) {
#line 1714 "hashset.c"
		default:
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 1720 "hashset.c"
	}
}


static void _vala_gee_hash_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeHashSetIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_HASH_SET_TYPE_ITERATOR, GeeHashSetIterator);
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	switch (property_id) {
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_ITERATOR_G_TYPE:
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_ITERATOR_G_DUP_FUNC:
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_ITERATOR_G_DESTROY_FUNC:
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 1748 "hashset.c"
		default:
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 1754 "hashset.c"
	}
}


static void gee_hash_set_class_init (GeeHashSetClass * klass) {
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_hash_set_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_type_class_add_private (klass, sizeof (GeeHashSetPrivate));
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_hash_set_real_contains;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_hash_set_real_iterator;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_hash_set_real_add;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_hash_set_real_remove;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_hash_set_real_clear;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_hash_set_real_get_size;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_hash_set_get_property;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_hash_set_set_property;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (klass)->finalize = gee_hash_set_finalize;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 1788 "hashset.c"
	/**
	 * {@inheritDoc}
	 */
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1794 "hashset.c"
	/**
	 * The elements' hash function.
	 */
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_HASH_FUNC, g_param_spec_pointer ("hash-func", "hash-func", "hash-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1800 "hashset.c"
	/**
	 * The elements' equality testing function.
	 */
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_HASH_SET_EQUAL_FUNC, g_param_spec_pointer ("equal-func", "equal-func", "equal-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1806 "hashset.c"
}


static void gee_hash_set_instance_init (GeeHashSet * self) {
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv = GEE_HASH_SET_GET_PRIVATE (self);
#line 59 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_stamp = 0;
#line 1815 "hashset.c"
}


static void gee_hash_set_finalize (GObject* obj) {
	GeeHashSet * self;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_HASH_SET, GeeHashSet);
#line 196 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) self);
#line 56 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) gee_hash_set_node_free), NULL);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	G_OBJECT_CLASS (gee_hash_set_parent_class)->finalize (obj);
#line 1829 "hashset.c"
}


/**
 * Hash table implementation of the {@link Set} interface.
 *
 * This implementation is better fit for highly heterogenous values.
 * In case of high value hashes redundancy or higher amount of data prefer using
 * tree implementation like {@link TreeSet}.
 *
 * @see TreeSet
 */
GType gee_hash_set_get_type (void) {
	static volatile gsize gee_hash_set_type_id__volatile = 0;
	if (g_once_init_enter (&gee_hash_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeHashSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_hash_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeHashSet), 0, (GInstanceInitFunc) gee_hash_set_instance_init, NULL };
		GType gee_hash_set_type_id;
		gee_hash_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_SET, "GeeHashSet", &g_define_type_info, 0);
		g_once_init_leave (&gee_hash_set_type_id__volatile, gee_hash_set_type_id);
	}
	return gee_hash_set_type_id__volatile;
}


static void _vala_gee_hash_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeHashSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_HASH_SET, GeeHashSet);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	switch (property_id) {
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_SIZE:
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_HASH_FUNC:
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		g_value_set_pointer (value, gee_hash_set_get_hash_func (self));
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_EQUAL_FUNC:
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		g_value_set_pointer (value, gee_hash_set_get_equal_func (self));
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 1877 "hashset.c"
		default:
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 1883 "hashset.c"
	}
}


static void _vala_gee_hash_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeHashSet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_HASH_SET, GeeHashSet);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
	switch (property_id) {
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_HASH_FUNC:
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		gee_hash_set_set_hash_func (self, g_value_get_pointer (value));
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_EQUAL_FUNC:
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		gee_hash_set_set_equal_func (self, g_value_get_pointer (value));
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_G_TYPE:
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->g_type = g_value_get_gtype (value);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_G_DUP_FUNC:
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->g_dup_func = g_value_get_pointer (value);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		case GEE_HASH_SET_G_DESTROY_FUNC:
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		self->priv->g_destroy_func = g_value_get_pointer (value);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 1923 "hashset.c"
		default:
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/hashset.vala"
		break;
#line 1929 "hashset.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



