/* multimap.c generated by valac 0.17.7, the Vala compiler
 * generated from multimap.vala, do not modify */

/* multimap.vala
 *
 * Copyright (C) 2009  Ali Sabil
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Ali Sabil <ali.sabil@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_MULTI_MAP (gee_multi_map_get_type ())
#define GEE_MULTI_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MULTI_MAP, GeeMultiMap))
#define GEE_IS_MULTI_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MULTI_MAP))
#define GEE_MULTI_MAP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MULTI_MAP, GeeMultiMapIface))

typedef struct _GeeMultiMap GeeMultiMap;
typedef struct _GeeMultiMapIface GeeMultiMapIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_TYPE_MULTI_SET (gee_multi_set_get_type ())
#define GEE_MULTI_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MULTI_SET, GeeMultiSet))
#define GEE_IS_MULTI_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MULTI_SET))
#define GEE_MULTI_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MULTI_SET, GeeMultiSetIface))

typedef struct _GeeMultiSet GeeMultiSet;
typedef struct _GeeMultiSetIface GeeMultiSetIface;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_read_only_view) (GeeSet* self);
};

struct _GeeMultiSetIface {
	GTypeInterface parent_iface;
	gint (*count) (GeeMultiSet* self, gconstpointer item);
};

struct _GeeMultiMapIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_keys) (GeeMultiMap* self);
	GeeMultiSet* (*get_all_keys) (GeeMultiMap* self);
	GeeCollection* (*get_values) (GeeMultiMap* self);
	gboolean (*contains) (GeeMultiMap* self, gconstpointer key);
	GeeCollection* (*get) (GeeMultiMap* self, gconstpointer key);
	void (*set) (GeeMultiMap* self, gconstpointer key, gconstpointer value);
	gboolean (*remove) (GeeMultiMap* self, gconstpointer key, gconstpointer value);
	gboolean (*remove_all) (GeeMultiMap* self, gconstpointer key);
	void (*clear) (GeeMultiMap* self);
	gint (*get_size) (GeeMultiMap* self);
};



GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_set_get_type (void) G_GNUC_CONST;
GType gee_multi_set_get_type (void) G_GNUC_CONST;
GType gee_multi_map_get_type (void) G_GNUC_CONST;
GeeSet* gee_multi_map_get_keys (GeeMultiMap* self);
GeeMultiSet* gee_multi_map_get_all_keys (GeeMultiMap* self);
GeeCollection* gee_multi_map_get_values (GeeMultiMap* self);
gboolean gee_multi_map_contains (GeeMultiMap* self, gconstpointer key);
GeeCollection* gee_multi_map_get (GeeMultiMap* self, gconstpointer key);
void gee_multi_map_set (GeeMultiMap* self, gconstpointer key, gconstpointer value);
gboolean gee_multi_map_remove (GeeMultiMap* self, gconstpointer key, gconstpointer value);
gboolean gee_multi_map_remove_all (GeeMultiMap* self, gconstpointer key);
void gee_multi_map_clear (GeeMultiMap* self);
gint gee_multi_map_get_size (GeeMultiMap* self);


/**
 * Returns the keys of this multimap as a read-only set.
 *
 * @return the keys of the map
 */
GeeSet* gee_multi_map_get_keys (GeeMultiMap* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_MULTI_MAP_GET_INTERFACE (self)->get_keys (self);
}


/**
 * Returns the keys of this multimap as a read-only set.
 *
 * @return the keys of the map
 */
GeeMultiSet* gee_multi_map_get_all_keys (GeeMultiMap* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_MULTI_MAP_GET_INTERFACE (self)->get_all_keys (self);
}


/**
 * Returns the values of this map as a read-only collection.
 *
 * @return the values of the map
 */
GeeCollection* gee_multi_map_get_values (GeeMultiMap* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_MULTI_MAP_GET_INTERFACE (self)->get_values (self);
}


/**
 * Determines whether this map contains the specified key.
 *
 * @param key the key to locate in the map
 *
 * @return    ``true`` if key is found, ``false`` otherwise
 */
gboolean gee_multi_map_contains (GeeMultiMap* self, gconstpointer key) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_MULTI_MAP_GET_INTERFACE (self)->contains (self, key);
}


/**
 * Returns the values for the specified key in this map.
 *
 * @param key the key whose values are to be retrieved
 *
 * @return    a Collection of values associated with the given key
 */
GeeCollection* gee_multi_map_get (GeeMultiMap* self, gconstpointer key) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_MULTI_MAP_GET_INTERFACE (self)->get (self, key);
}


/**
 * Inserts a key/value pair into this map.
 *
 * @param key   the key to insert
 * @param value the value to associate with the key
 */
void gee_multi_map_set (GeeMultiMap* self, gconstpointer key, gconstpointer value) {
	g_return_if_fail (self != NULL);
	GEE_MULTI_MAP_GET_INTERFACE (self)->set (self, key, value);
}


/**
 * Removes the specified key/value pair from this multimap.
 *
 * @param key   the key to remove from the map
 * @param value the value to remove from the map
 *
 * @return      ``true`` if the map has been changed, ``false`` otherwise
 */
gboolean gee_multi_map_remove (GeeMultiMap* self, gconstpointer key, gconstpointer value) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_MULTI_MAP_GET_INTERFACE (self)->remove (self, key, value);
}


/**
 * Removes the specified key and all the associated values from this
 * multimap.
 *
 * @param key the key to remove from the map
 *
 * @return    ``true`` if the map has been changed, ``false`` otherwise
 */
gboolean gee_multi_map_remove_all (GeeMultiMap* self, gconstpointer key) {
	g_return_val_if_fail (self != NULL, FALSE);
	return GEE_MULTI_MAP_GET_INTERFACE (self)->remove_all (self, key);
}


/**
 * Removes all items from this collection.
 */
void gee_multi_map_clear (GeeMultiMap* self) {
	g_return_if_fail (self != NULL);
	GEE_MULTI_MAP_GET_INTERFACE (self)->clear (self);
}


gint gee_multi_map_get_size (GeeMultiMap* self) {
	g_return_val_if_fail (self != NULL, 0);
	return GEE_MULTI_MAP_GET_INTERFACE (self)->get_size (self);
}


static void gee_multi_map_base_init (GeeMultiMapIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		 * The number of key/value pairs in this map.
		 */
		g_object_interface_install_property (iface, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


/**
 * A map with multiple values per key.
 */
GType gee_multi_map_get_type (void) {
	static volatile gsize gee_multi_map_type_id__volatile = 0;
	if (g_once_init_enter (&gee_multi_map_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeMultiMapIface), (GBaseInitFunc) gee_multi_map_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_multi_map_type_id;
		gee_multi_map_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeMultiMap", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_multi_map_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_multi_map_type_id__volatile, gee_multi_map_type_id);
	}
	return gee_multi_map_type_id__volatile;
}



