%define with_python3 1
%define with_gtk_doc 1
%define with_btrfs 1
%define with_crypto 1
%define with_dm 1
%define with_loop 1
%define with_lvm 1
%define with_lvm_dbus 1
%define with_mdraid 1
%define with_mpath 1
%define with_swap 1
%define with_part 1
%define with_fs 1
%define with_nvdimm 1
%define with_gi 1
%define with_escrow 1
%define with_tools 1
%define with_nvme 1

# btrfs is not available on RHEL > 7
%if 0%{?rhel} > 7 || %{with_btrfs} == 0
%define with_btrfs 0
%define btrfs_copts --without-btrfs
%endif

%if %{with_btrfs} != 1
%define btrfs_copts --without-btrfs
%endif
%if %{with_crypto} != 1
%define crypto_copts --without-crypto
%else
%if %{with_escrow} != 1
%define crypto_copts --without-escrow
%endif
%endif
%if %{with_dm} != 1
%define dm_copts --without-dm
%else
%endif
%if %{with_loop} != 1
%define loop_copts --without-loop
%endif
%if %{with_lvm} != 1
%define lvm_copts --without-lvm
%endif
%if %{with_lvm_dbus} != 1
%define lvm_dbus_copts --without-lvm_dbus
%endif
%if %{with_mdraid} != 1
%define mdraid_copts --without-mdraid
%endif
%if %{with_mpath} != 1
%define mpath_copts --without-mpath
%endif
%if %{with_swap} != 1
%define swap_copts --without-swap
%endif
%if %{with_part} != 1
%define part_copts --without-part
%endif
%if %{with_fs} != 1
%define fs_copts --without-fs
%endif
%if %{with_nvdimm} != 1
%define nvdimm_copts --without-nvdimm
%endif
%if %{with_tools} != 1
%define tools_copts --without-tools
%endif
%if %{with_gi} != 1
%define gi_copts --disable-introspection
%endif
%if %{with_nvme} != 1
%define nvme_copts --without-nvme
%endif

%define configure_opts %{?python3_copts} %{?lvm_dbus_copts} %{?btrfs_copts} %{?crypto_copts} %{?dm_copts} %{?loop_copts} %{?lvm_copts} %{?lvm_dbus_copts} %{?mdraid_copts} %{?mpath_copts} %{?swap_copts} %{?part_copts} %{?fs_copts} %{?nvdimm_copts} %{?tools_copts} %{?gi_copts} %{?nvme_copts}

Name:        libblockdev
Version:     3.0.2
Release:     1%{?dist}
Summary:     A library for low-level manipulation with block devices
License:     LGPL-2.1-or-later
URL:         https://github.com/storaged-project/libblockdev
Source0:     https://github.com/storaged-project/libblockdev/releases/download/%{version}-%{release}/%{name}-%{version}.tar.gz

BuildRequires: make
BuildRequires: glib2-devel
%if %{with_gi}
BuildRequires: gobject-introspection-devel
%endif
%if %{with_python3}
BuildRequires: python3-devel
%endif
%if %{with_gtk_doc}
BuildRequires: gtk-doc
%endif
BuildRequires: glib2-doc
BuildRequires: autoconf-archive

# obsolete removed subpackages to allow upgrades
Provides: libblockdev-kbd = %{version}-%{release}
Obsoletes: libblockdev-kbd < %{version}-%{release}
Provides: libblockdev-kbd-devel = %{version}-%{release}
Obsoletes: libblockdev-kbd-devel < %{version}-%{release}

Requires: %{name}-utils%{?_isa} = %{version}-%{release}

%description
The libblockdev is a C library with GObject introspection support that can be
used for doing low-level operations with block devices like setting up LVM,
BTRFS, LUKS or MD RAID. The library uses plugins (LVM, BTRFS,...) and serves as
a thin wrapper around its plugins' functionality. All the plugins, however, can
be used as standalone libraries. One of the core principles of libblockdev is
that it is stateless from the storage configuration's perspective (e.g. it has
no information about VGs when creating an LV).

%package devel
Summary:     Development files for libblockdev
Requires: %{name}%{?_isa} = %{version}-%{release}
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description devel
This package contains header files and pkg-config files needed for development
with the libblockdev library.

%if %{with_python3}
%package -n python3-blockdev
Summary:     Python3 gobject-introspection bindings for libblockdev
Requires: %{name}%{?_isa} = %{version}-%{release}
Requires: python3-gobject-base
Requires: python3-bytesize
%{?python_provide:%python_provide python3-blockdev}

%description -n python3-blockdev
This package contains enhancements to the gobject-introspection bindings for
libblockdev in Python3.
%endif

%package utils
BuildRequires: kmod-devel
Summary:     A library with utility functions for the libblockdev library

%description utils
The libblockdev-utils is a library providing utility functions used by the
libblockdev library and its plugins.

%package utils-devel
Summary:     Development files for libblockdev-utils
Requires: %{name}-utils%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description utils-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-utils library.


%if %{with_btrfs}
%package btrfs
BuildRequires: libbytesize-devel
Summary:     The BTRFS plugin for the libblockdev library
Requires: %{name}-utils%{?_isa} = %{version}-%{release}
Requires: btrfs-progs

%description btrfs
The libblockdev library plugin (and in the same time a standalone library)
providing the BTRFS-related functionality.

%package btrfs-devel
Summary:     Development files for the libblockdev-btrfs plugin/library
Requires: %{name}-btrfs%{?_isa} = %{version}-%{release}
Requires: glib2-devel
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}

%description btrfs-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-btrfs plugin/library.
%endif


%if %{with_crypto}
%package crypto
Requires: %{name}-utils%{?_isa} = %{version}-%{release}
BuildRequires: cryptsetup-devel >= 2.3.0
BuildRequires: libblkid-devel
BuildRequires: keyutils-libs-devel

%if %{with_escrow}
BuildRequires: volume_key-devel >= 0.3.9-7
BuildRequires: nss-devel
%endif

Summary:     The crypto plugin for the libblockdev library

%description crypto
The libblockdev library plugin (and in the same time a standalone library)
providing the functionality related to encrypted devices (LUKS).

%package crypto-devel
Summary:     Development files for the libblockdev-crypto plugin/library
Requires: %{name}-crypto%{?_isa} = %{version}-%{release}
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description crypto-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-crypto plugin/library.
%endif


%if %{with_dm}
%package dm
BuildRequires: device-mapper-devel
BuildRequires: systemd-devel
Summary:     The Device Mapper plugin for the libblockdev library
Requires: %{name}-utils%{?_isa} = %{version}-%{release}
Requires: device-mapper

%description dm
The libblockdev library plugin (and in the same time a standalone library)
providing the functionality related to Device Mapper.

%package dm-devel
Summary:     Development files for the libblockdev-dm plugin/library
Requires: %{name}-dm%{?_isa} = %{version}-%{release}
Requires: glib2-devel
Requires: device-mapper-devel
Requires: systemd-devel
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}

%description dm-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-dm plugin/library.
%endif


%if %{with_fs}
%package fs
BuildRequires: libblkid-devel
BuildRequires: libmount-devel
BuildRequires: libuuid-devel
BuildRequires: e2fsprogs-devel
Summary:     The FS plugin for the libblockdev library
Requires: %{name}-utils%{?_isa} = %{version}-%{release}

%description fs
The libblockdev library plugin (and in the same time a standalone library)
providing the functionality related to operations with file systems.

%package fs-devel
Summary:     Development files for the libblockdev-fs plugin/library
Requires: %{name}-fs%{?_isa} = %{version}-%{release}
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description fs-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-fs plugin/library.
%endif


%if %{with_loop}
%package loop
Summary:     The loop plugin for the libblockdev library
Requires: %{name}-utils%{?_isa} = %{version}-%{release}

%description loop
The libblockdev library plugin (and in the same time a standalone library)
providing the functionality related to loop devices.

%package loop-devel
Summary:     Development files for the libblockdev-loop plugin/library
Requires: %{name}-loop%{?_isa} = %{version}-%{release}
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description loop-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-loop plugin/library.
%endif


%if %{with_lvm}
%package lvm
BuildRequires: device-mapper-devel
Summary:     The LVM plugin for the libblockdev library
Requires: %{name}-utils%{?_isa} = %{version}-%{release}
Requires: lvm2

%description lvm
The libblockdev library plugin (and in the same time a standalone library)
providing the LVM-related functionality.

%package lvm-devel
Summary:     Development files for the libblockdev-lvm plugin/library
Requires: %{name}-lvm%{?_isa} = %{version}-%{release}
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description lvm-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-lvm plugin/library.
%endif

%if %{with_lvm_dbus}
%package lvm-dbus
BuildRequires: device-mapper-devel
Summary:     The LVM plugin for the libblockdev library
Requires: %{name}-utils%{?_isa} = %{version}-%{release}
Requires: lvm2-dbusd >= 2.02.156

%description lvm-dbus
The libblockdev library plugin (and in the same time a standalone library)
providing the LVM-related functionality utilizing the LVM DBus API.

%package lvm-dbus-devel
Summary:     Development files for the libblockdev-lvm-dbus plugin/library
Requires: %{name}-lvm-dbus%{?_isa} = %{version}-%{release}
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description lvm-dbus-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-lvm-dbus plugin/library.
%endif


%if %{with_mdraid}
%package mdraid
BuildRequires: libbytesize-devel
Summary:     The MD RAID plugin for the libblockdev library
Requires: %{name}-utils%{?_isa} = %{version}-%{release}
Requires: mdadm

%description mdraid
The libblockdev library plugin (and in the same time a standalone library)
providing the functionality related to MD RAID.

%package mdraid-devel
Summary:     Development files for the libblockdev-mdraid plugin/library
Requires: %{name}-mdraid%{?_isa} = %{version}-%{release}
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description mdraid-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-mdraid plugin/library.
%endif


%if %{with_mpath}
%package mpath
BuildRequires: device-mapper-devel
Summary:     The multipath plugin for the libblockdev library
Requires: %{name}-utils%{?_isa} = %{version}-%{release}
Recommends: device-mapper-multipath

%description mpath
The libblockdev library plugin (and in the same time a standalone library)
providing the functionality related to multipath devices.

%package mpath-devel
Summary:     Development files for the libblockdev-mpath plugin/library
Requires: %{name}-mpath%{?_isa} = %{version}-%{release}
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description mpath-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-mpath plugin/library.
%endif

%if %{with_nvdimm}
%package nvdimm
BuildRequires: ndctl-devel
BuildRequires: libuuid-devel
Summary:     The NVDIMM plugin for the libblockdev library
Requires: %{name}-utils%{?_isa} = %{version}-%{release}
Requires: ndctl

%description nvdimm
The libblockdev library plugin (and in the same time a standalone library)
providing the functionality related to operations with NVDIMM devices.

%package nvdimm-devel
Summary:     Development files for the libblockdev-nvdimm plugin/library
Requires: %{name}-nvdimm%{?_isa} = %{version}-%{release}
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description nvdimm-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-nvdimm plugin/library.
%endif


%if %{with_nvme}
%package nvme
BuildRequires: libnvme-devel
BuildRequires: libuuid-devel
Summary:     The NVMe plugin for the libblockdev library
Requires: %{name}-utils%{?_isa} = %{version}-%{release}

%description nvme
The libblockdev library plugin (and in the same time a standalone library)
providing the functionality related to operations with NVMe devices.

%package nvme-devel
Summary:     Development files for the libblockdev-nvme plugin/library
Requires: %{name}-nvme%{?_isa} = %{version}-%{release}
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description nvme-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-nvme plugin/library.
%endif


%if %{with_part}
%package part
BuildRequires: libfdisk-devel
Summary:     The partitioning plugin for the libblockdev library
Requires: %{name}-utils%{?_isa} = %{version}-%{release}
Requires: util-linux

%description part
The libblockdev library plugin (and in the same time a standalone library)
providing the functionality related to partitioning.

%package part-devel
Summary:     Development files for the libblockdev-part plugin/library
Requires: %{name}-part%{?_isa} = %{version}-%{release}
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description part-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-part plugin/library.
%endif


%if %{with_swap}
%package swap
BuildRequires: libblkid-devel
Summary:     The swap plugin for the libblockdev library
Requires: %{name}-utils%{?_isa} = %{version}-%{release}
Requires: util-linux

%description swap
The libblockdev library plugin (and in the same time a standalone library)
providing the functionality related to swap devices.

%package swap-devel
Summary:     Development files for the libblockdev-swap plugin/library
Requires: %{name}-swap%{?_isa} = %{version}-%{release}
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description swap-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-swap plugin/library.
%endif

%if %{with_tools}
%package tools
Summary:    Various nice tools based on libblockdev
Requires:   %{name} = %{version}-%{release}
Requires:   %{name}-lvm = %{version}-%{release}
BuildRequires: libbytesize-devel
BuildRequires: parted-devel
%if %{with_lvm_dbus} == 1
Recommends: %{name}-lvm-dbus
%endif

%description tools
Various nice storage-related tools based on libblockdev.

%endif

%ifarch s390 s390x
%package s390
Summary:    The s390 plugin for the libblockdev library
Requires: %{name}-utils%{?_isa} = %{version}-%{release}
Requires: s390utils

%description s390
The libblockdev library plugin (and in the same time a standalone library)
providing the functionality related to s390 devices.

%package s390-devel
Summary:     Development files for the libblockdev-s390 plugin/library
Requires: %{name}-s390%{?_isa} = %{version}-%{release}
Requires: %{name}-utils-devel%{?_isa} = %{version}-%{release}
Requires: glib2-devel

%description s390-devel
This package contains header files and pkg-config files needed for development
with the libblockdev-s390 plugin/library.
%endif

%package plugins-all
Summary:     Meta-package that pulls all the libblockdev plugins as dependencies
Requires: %{name}%{?_isa} = %{version}-%{release}

%if %{with_btrfs}
Requires: %{name}-btrfs%{?_isa} = %{version}-%{release}
%endif

%if %{with_crypto}
Requires: %{name}-crypto%{?_isa} = %{version}-%{release}
%endif

%if %{with_dm}
Requires: %{name}-dm%{?_isa} = %{version}-%{release}
%endif

%if %{with_fs}
Requires: %{name}-fs%{?_isa} = %{version}-%{release}
%endif

%if %{with_loop}
Requires: %{name}-loop%{?_isa} = %{version}-%{release}
%endif

%if %{with_lvm}
Requires: %{name}-lvm%{?_isa} = %{version}-%{release}
%endif

%if %{with_mdraid}
Requires: %{name}-mdraid%{?_isa} = %{version}-%{release}
%endif

%if %{with_mpath}
Requires: %{name}-mpath%{?_isa} = %{version}-%{release}
%endif

%if %{with_nvdimm}
Requires: %{name}-nvdimm%{?_isa} = %{version}-%{release}
%endif

%if %{with_nvme}
Requires: %{name}-nvme%{?_isa} = %{version}-%{release}
%endif

%if %{with_part}
Requires: %{name}-part%{?_isa} = %{version}-%{release}
%endif

%if %{with_swap}
Requires: %{name}-swap%{?_isa} = %{version}-%{release}
%endif

%ifarch s390 s390x
Requires: %{name}-s390%{?_isa} = %{version}-%{release}
%endif

%description plugins-all
A meta-package that pulls all the libblockdev plugins as dependencies.


%prep
%autosetup -n %{name}-%{version} -p1

%build
autoreconf -ivf
%configure %{?configure_opts}
%{__make} %{?_smp_mflags}

%install
%{make_install}
find %{buildroot} -type f -name "*.la" | xargs %{__rm}


%ldconfig_scriptlets
%ldconfig_scriptlets utils

%if %{with_btrfs}
%ldconfig_scriptlets btrfs
%endif

%if %{with_crypto}
%ldconfig_scriptlets crypto
%endif

%if %{with_dm}
%ldconfig_scriptlets dm
%endif

%if %{with_fs}
%ldconfig_scriptlets fs
%endif

%if %{with_loop}
%ldconfig_scriptlets loop
%endif

%if %{with_lvm}
%ldconfig_scriptlets lvm
%endif

%if %{with_lvm_dbus}
%ldconfig_scriptlets lvm-dbus
%endif

%if %{with_mdraid}
%ldconfig_scriptlets mdraid
%endif

%if %{with_mpath}
%ldconfig_scriptlets mpath
%endif

%if %{with_nvdimm}
%ldconfig_scriptlets nvdimm
%endif

%if %{with_nvme}
%ldconfig_scriptlets nvme
%endif

%if %{with_part}
%ldconfig_scriptlets part
%endif

%if %{with_swap}
%ldconfig_scriptlets swap
%endif

%ifarch s390 s390x
%ldconfig_scriptlets s390
%endif


%files
%{!?_licensedir:%global license %%doc}
%license LICENSE
%{_libdir}/libblockdev.so.*
%if %{with_gi}
%{_libdir}/girepository*/BlockDev*.typelib
%endif
%dir %{_sysconfdir}/libblockdev
%dir %{_sysconfdir}/libblockdev/3/conf.d
%config %{_sysconfdir}/libblockdev/3/conf.d/00-default.cfg

%files devel
%{_libdir}/libblockdev.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/blockdev.h
%{_includedir}/blockdev/plugins.h
%{_libdir}/pkgconfig/blockdev.pc
%if %{with_gtk_doc}
%{_datadir}/gtk-doc/html/libblockdev
%endif
%if %{with_gi}
%{_datadir}/gir*/BlockDev*.gir
%endif

%if %{with_python3}
%files -n python3-blockdev
%{python3_sitearch}/gi/overrides/BlockDev*
%{python3_sitearch}/gi/overrides/__pycache__/BlockDev*
%endif

%files utils
%{_libdir}/libbd_utils.so.*

%files utils-devel
%{_libdir}/libbd_utils.so
%{_libdir}/pkgconfig/blockdev-utils.pc
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/utils.h
%{_includedir}/blockdev/sizes.h
%{_includedir}/blockdev/exec.h
%{_includedir}/blockdev/extra_arg.h
%{_includedir}/blockdev/dev_utils.h
%{_includedir}/blockdev/module.h
%{_includedir}/blockdev/dbus.h
%{_includedir}/blockdev/logging.h


%if %{with_btrfs}
%files btrfs
%{_libdir}/libbd_btrfs.so.*

%files btrfs-devel
%{_libdir}/libbd_btrfs.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/btrfs.h
%endif


%if %{with_crypto}
%files crypto
%{_libdir}/libbd_crypto.so.*

%files crypto-devel
%{_libdir}/libbd_crypto.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/crypto.h
%endif


%if %{with_dm}
%files dm
%{_libdir}/libbd_dm.so.*

%files dm-devel
%{_libdir}/libbd_dm.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/dm.h
%endif


%if %{with_fs}
%files fs
%{_libdir}/libbd_fs.so.*

%files fs-devel
%{_libdir}/libbd_fs.so
%dir %{_includedir}/blockdev
%dir %{_includedir}/blockdev/fs
%{_includedir}/blockdev/fs.h
%{_includedir}/blockdev/fs/*.h
%endif


%if %{with_loop}
%files loop
%{_libdir}/libbd_loop.so.*

%files loop-devel
%{_libdir}/libbd_loop.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/loop.h
%endif


%if %{with_lvm}
%files lvm
%{_libdir}/libbd_lvm.so.*

%files lvm-devel
%{_libdir}/libbd_lvm.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/lvm.h
%endif


%if %{with_lvm_dbus}
%files lvm-dbus
%{_libdir}/libbd_lvm-dbus.so.*
%config %{_sysconfdir}/libblockdev/3/conf.d/10-lvm-dbus.cfg

%files lvm-dbus-devel
%{_libdir}/libbd_lvm-dbus.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/lvm.h
%endif


%if %{with_mdraid}
%files mdraid
%{_libdir}/libbd_mdraid.so.*

%files mdraid-devel
%{_libdir}/libbd_mdraid.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/mdraid.h
%endif


%if %{with_mpath}
%files mpath
%{_libdir}/libbd_mpath.so.*

%files mpath-devel
%{_libdir}/libbd_mpath.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/mpath.h
%endif


%if %{with_nvdimm}
%files nvdimm
%{_libdir}/libbd_nvdimm.so.*

%files nvdimm-devel
%{_libdir}/libbd_nvdimm.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/nvdimm.h
%endif


%if %{with_nvme}
%files nvme
%{_libdir}/libbd_nvme.so.*

%files nvme-devel
%{_libdir}/libbd_nvme.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/nvme.h
%endif


%if %{with_part}
%files part
%{_libdir}/libbd_part.so.*

%files part-devel
%{_libdir}/libbd_part.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/part.h
%endif


%if %{with_swap}
%files swap
%{_libdir}/libbd_swap.so.*

%files swap-devel
%{_libdir}/libbd_swap.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/swap.h
%endif


%if %{with_tools}
%files tools
%{_bindir}/lvm-cache-stats
%{_bindir}/vfat-resize
%endif

%ifarch s390 s390x
%files s390
%{_libdir}/libbd_s390.so.*

%files s390-devel
%{_libdir}/libbd_s390.so
%dir %{_includedir}/blockdev
%{_includedir}/blockdev/s390.h
%endif

%files plugins-all

%changelog
* Thu Jul 20 2023 Vojtech Trefny <vtrefny@redhat.com> - 3.0.2-1
- fs: Avoid excess logging in extract_e2fsck_progress (vtrefny)
- loop: Report BD_LOOP_ERROR_DEVICE on empty loop devices (tbzatek)
- lib: Silence the missing DEFAULT_CONF_DIR_PATH (tbzatek)
- fs: Document that generic functions can mount filesystems (vtrefny)
- fs: Use read-only mount where possible for generic FS functions (vtrefny)
- docs: Fix test quotation (marecki)
- fs: Fix unused error in extract_e2fsck_progress (vtrefny)
- Use ntfsinfo instead of ntfscluster for faster bd_fs_ntfs_get_info (amubtdx)
- Restrict list of exported symbols via -export-symbols-regex (biebl)
- Fix formatting in NEWS.rst (vtrefny)

* Tue Jul 04 2023 Vojtech Trefny <vtrefny@redhat.com> - 3.0.1-1
- fs: Simplify struct BDFSInfo (tbzatek)
- boilerplate_generator: Annotate stub func args as G_GNUC_UNUSED (tbzatek)
- crypto: Remove stray struct redefinition (tbzatek)
- loop: Remove unused variable (tbzatek)
- build: Exit before AC_OUTPUT on error (tbzatek)
- loop: define LOOP_SET_BLOCK_SIZE is not defined (giulio.benetti)
- Make the conf.d directory versioned (vtrefny)
- configure: Fix MAJOR_VER macro (vtrefny)
- spec: Add dependency on libblockdev-utils to the s390 plugin (vtrefny)
- nvme: Mark private symbols as hidden (tbzatek)
- dist: Sync spec with downstream (vtrefny)
- misc: Update steps and Dockerfile for Python documentation (vtrefny)
- fs: Add missing copy and free functions to the header file (vtrefny)
- lvm: Add bd_lvm_segdata_copy/free to the header file (vtrefny)
- loop: Remove bd_loop_get_autoclear definition (vtrefny)
- lvm: Fix declaration for bd_lvm_vdolvpoolname (vtrefny)
- lvm: Make _vglock_start_stop static (vtrefny)
- vdo_stats: Remove unused libparted include (vtrefny)

* Fri Jun 23 2023 Vojtech Trefny <vtrefny@redhat.com> - 3.0-1
- Libblockdev 3.0 release
