#include <glib.h>
#include <blockdev/utils.h>


GQuark  bd_mpath_error_quark (void);


#define BD_MPATH_ERROR bd_mpath_error_quark ()
typedef enum {
    BD_MPATH_ERROR_FLUSH,
    BD_MPATH_ERROR_NOT_ROOT,
    BD_MPATH_ERROR_DM_ERROR,
    BD_MPATH_ERROR_INVAL,
    BD_MPATH_ERROR_TECH_UNAVAIL,
} BDMpathError;

typedef enum {
    BD_MPATH_TECH_BASE = 0,
    BD_MPATH_TECH_FRIENDLY_NAMES,
} BDMpathTech;

typedef enum {
    BD_MPATH_TECH_MODE_QUERY  = 1 << 0,
    BD_MPATH_TECH_MODE_MODIFY = 1 << 1,
} BDMpathTechMode;

/**
 * bd_mpath_is_tech_avail:
 * @tech: the queried tech
 * @mode: a bit mask of queried modes of operation for @tech
 * @error: (out): place to store error (details about why the @tech-@mode combination is not available)
 *
 * Returns: whether the @tech-@mode combination is avaible -- supported by the
 *          plugin implementation and having all the runtime dependencies available
 */
gboolean  bd_mpath_is_tech_avail (BDMpathTech tech, guint64 mode, GError **error);


/**
 * bd_mpath_flush_mpaths:
 * @error: (out): place to store error (if any)
 *
 * Returns: whether multipath device maps were successfully flushed or not
 *
 * Flushes all unused multipath device maps.
 *
 * Tech category: %BD_MPATH_TECH_BASE-%BD_MPATH_TECH_MODE_MODIFY
 */
gboolean  bd_mpath_flush_mpaths (GError **error);


/**
 * bd_mpath_is_mpath_member:
 * @device: device to test
 * @error: (out): place to store error (if any)
 *
 * Returns: %TRUE if the device is a multipath member, %FALSE if not or an error
 * appeared when queried (@error is set in those cases)
 *
 * Tech category: %BD_MPATH_TECH_BASE-%BD_MPATH_TECH_MODE_QUERY
 */
gboolean  bd_mpath_is_mpath_member (const gchar *device, GError **error);


/**
 * bd_mpath_get_mpath_members:
 * @error: (out): place to store error (if any)
 *
 * Returns: (transfer full) (array zero-terminated=1): list of names of all devices that are
 *                                                     members of the mpath mappings (or %NULL
 *                                                     in case of error)
 *
 * Tech category: %BD_MPATH_TECH_BASE-%BD_MPATH_TECH_MODE_QUERY
 */
gchar** bd_mpath_get_mpath_members (GError **error);


/**
 * bd_mpath_set_friendly_names:
 * @enabled: whether friendly names should be enabled or not
 * @error: (out): place to store error (if any)
 *
 * Returns: if successfully set or not
 *
 * Tech category: %BD_MPATH_TECH_FRIENDLY_NAMES-%BD_MPATH_TECH_MODE_MODIFY
 */
gboolean  bd_mpath_set_friendly_names (gboolean enabled, GError **error);

