/*
    This file is part of kdepim.

    Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <tqbuttongroup.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqradiobutton.h>

#include <kaccelmanager.h>
#include <kdialog.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>

#include "wizards-config.h"
#include "egroupwarewizard.h"
#include "kolabwizard.h"
#include "sloxwizard.h"
#include "exchangewizard.h"

#include "overviewpage.h"

OverViewPage::OverViewPage( TQWidget *parent, const char *name )
  : TQWidget( parent, name )
{
  TQGridLayout *tqlayout = new TQGridLayout( this, 7, 4, KDialog::marginHint(),
                                         KDialog::spacingHint() );

  const TQString msg = i18n( "KDE Groupware Wizard" );
  TQLabel *label = new TQLabel( "<qt><b><u><h2>" + msg + "</h2></u></b></qt>" , this );
  tqlayout->addMultiCellWidget( label, 0, 0, 0, 2 );

  label = new TQLabel( this );
  label->setPixmap( KGlobal::iconLoader()->loadIcon( "network", KIcon::Desktop ) );
  tqlayout->addWidget( label, 0, 3 );

  label = new TQLabel( "", this );
  tqlayout->addWidget( label, 1, 0 );
  tqlayout->setRowSpacing( 1, 20 );

  label = new TQLabel( i18n( "Select the type of server you want connect your KDE to:" ), this );
  tqlayout->addMultiCellWidget( label, 2, 2, 0, 3 );

  TQPushButton *button;

#ifdef WITH_EGROUPWARE
  button = new TQPushButton( i18n("eGroupware"), this );
  tqlayout->addMultiCellWidget( button, 3, 3, 0, 3 );
  connect( button, TQT_SIGNAL( clicked() ), TQT_SLOT( showWizardEGroupware() ) );
#endif

  // FIXME: Maybe hyperlinks would be better than buttons.

#ifdef WITH_KOLAB
  button = new TQPushButton( i18n("Kolab"), this );
  tqlayout->addMultiCellWidget( button, 4, 4, 0, 3 );
  connect( button, TQT_SIGNAL( clicked() ), TQT_SLOT( showWizardKolab() ) );
#endif

#ifdef WITH_SLOX
  button = new TQPushButton( i18n("SUSE Linux Openexchange (SLOX)"), this );
  tqlayout->addMultiCellWidget( button, 5, 5, 0, 3 );
  connect( button, TQT_SIGNAL( clicked() ), TQT_SLOT( showWizardSlox() ) );
#endif

#ifdef WITH_NEWEXCHANGE
  button = new TQPushButton( i18n("Microsoft Exchange"), this );
  button->hide(); // not quite ready yet
  tqlayout->addMultiCellWidget( button, 6, 6, 0, 3 );
  connect( button, TQT_SIGNAL( clicked() ), TQT_SLOT( showWizardExchange() ) );
#endif

  TQFrame *frame = new TQFrame( this );
  frame->setFrameStyle( TQFrame::HLine | TQFrame::Sunken );
  tqlayout->addMultiCellWidget( frame, 7, 7, 0, 3 );

  TQPushButton *cancelButton = new KPushButton( KStdGuiItem::close(), this );
  tqlayout->addWidget( cancelButton, 8, 3 );

  connect( cancelButton, TQT_SIGNAL( clicked() ), this, TQT_SIGNAL( cancel() ) );

  tqlayout->setRowStretch( 7, 1 );

  KAcceleratorManager::manage( this );
}

OverViewPage::~OverViewPage()
{
}

void OverViewPage::showWizardEGroupware()
{
#ifdef WITH_EGROUPWARE
  EGroupwareWizard wizard;
  wizard.exec();
#endif
}

void OverViewPage::showWizardKolab()
{
#ifdef WITH_KOLAB
  KolabWizard wizard;
  wizard.exec();
#endif
}

void OverViewPage::showWizardSlox()
{
#ifdef WITH_SLOX
  SloxWizard wizard;
  wizard.exec();
#endif
}

void OverViewPage::showWizardExchange()
{
#ifdef WITH_NEWEXCHANGE
  ExchangeWizard wizard;
  wizard.exec();
#endif
}

#include "overviewpage.moc"
