#include "qutf7codec.h"
#include "qutf7codec.cpp"
#include <tqtextstream.h>
#include <string.h>
#include <assert.h>
#include <iostream>

int main( int argc, char * argv[] ) {
  if ( argc == 1 ) {
    (void)new TQUtf7Codec;

    TQTextCodec * codec = TQTextCodec::codecForName("utf-7");
    assert(codec);

    TQTextIStream my_cin(stdin);

    TQTextOStream my_cout(stdout);
    my_cout.setCodec(codec);
    
    TQString buffer = my_cin.read();

    //    qDebug("buffer == " + buffer);

#ifdef USE_STREAM
    my_cout << buffer << endl;
#else
    TQTextEncoder * enc = codec->makeEncoder();
#ifdef CHAR_WISE
    int len;
    for ( int i = 0 ; i < buffer.length() ; i++ ) {
      len = 1;
      cout << (enc->fromUnicode(TQString(buffer[i]),len)).data();
    }
    std::cout << std::endl;
#else
    int len = buffer.length();
    std::cout << (enc->fromUnicode(buffer,len)).data() << std::endl;;
#endif // CHAR_WISE
    delete enc;
#endif // else USE_STREAM
  } else {
    qWarning("usage: testutf7encoder2 < infile > outfile\n");
  }
  TQTextCodec::deleteAllCodecs();
}
