#ifndef __KPIM_STATUSBARPROGRESSWIDGET_H
#define __KPIM_STATUSBARPROGRESSWIDGET_H
/*
  statusbarprogresswidget.h

  This file is part of KMail, the KDE mail client.

  (C) 2004 KMail Authors

  KMail is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  KMail is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  In addition, as a special exception, the copyright holders give
  permission to link the code of this program with any edition of
  the TQt library by Trolltech AS, Norway (or with modified versions
  of TQt that use the same license as TQt), and distribute linked
  combinations including the two.  You must obey the GNU General
  Public License in all respects for all of the code used other than
  TQt.  If you modify this file, you may extend this exception to
  your version of the file, but you are not obligated to do so.  If
  you do not wish to do so, delete this exception statement from
  your version.
*/
/**
  *  A specialized progress widget class, heavily based on
  *  kio_littleprogress_dlg (it looks similar)
  */

#include <kdepimmacros.h>

class KMMainWidget;
class KProgress;
class TQPushButton;
class TQWidgetStack;
class TQBoxLayout;
class TQLabel;
class TQTimer;

namespace KPIM {
class SSLLabel;
class ProgressItem;
class ProgressDialog;

class KDE_EXPORT StatusbarProgressWidget : public TQFrame {

  Q_OBJECT
  TQ_OBJECT

public:

  StatusbarProgressWidget( ProgressDialog* progressDialog, TQWidget* parent, bool button = true );

public slots:

  void slotClean();
  void slotSetSSL( bool );

  void slotProgressItemAdded( KPIM::ProgressItem *i );
  void slotProgressItemCompleted( KPIM::ProgressItem *i );
  void slotProgressItemProgress( KPIM::ProgressItem *i, unsigned int value );

protected slots:
  void slotProgressDialogVisible( bool );
  void slotShowItemDelayed();
  void slotBusyIndicator();
  void updateBusyMode();

protected:
  void setMode();
  void connectSingleItem();
  void activateSingleItemMode();

  virtual bool eventFilter( TQObject *, TQEvent * );

private:
  KProgress* m_pProgressBar;
  TQLabel* m_pLabel;
  SSLLabel* m_sslLabel;
  TQPushButton* m_pButton;

  enum Mode { None, /*Label,*/ Progress };

  uint mode;
  bool m_bShowButton;

  TQBoxLayout *box;
  TQWidgetStack *stack;
  ProgressItem *mCurrentItem;
  ProgressDialog* mProgressDialog;
  TQTimer *mDelayTimer;
  TQTimer *mBusyTimer;
};

} // namespace

#endif
