/*
    This file is part of KOrganizer.

    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef KOTIMESPANVIEW_H
#define KOTIMESPANVIEW_H

#include "koeventview.h"

class KConfig;
class TimeSpanWidget;

class KOTimeSpanView : public KOEventView
{
    Q_OBJECT
  TQ_OBJECT
  public:
    KOTimeSpanView( Calendar *calendar, TQWidget *parent = 0,
                    const char *name = 0 );
    ~KOTimeSpanView();

    virtual int maxDatesHint();
    virtual int tqcurrentDateCount();
    virtual Incidence::List selectedIncidences();
    DateList selectedDates() { return DateList(); }

    void readSettings();
    void writeSettings( KConfig * );

  public slots:
    virtual void updateView();
    virtual void showDates( const TQDate &start, const TQDate &end );
    virtual void showIncidences( const Incidence::List &incidenceList );

    void changeIncidenceDisplay(Incidence *, int);

  private:
    void insertItems( const TQDate &start, const TQDate & end );

    TimeSpanWidget *mTimeSpanWidget;
};

#endif
