/*
    This file is part of KOrganizer.

    Copyright (c) 2000, 2001 Cornelius Schumacher <schumacher@kde.org>
    Copyright (C) 2003-2004 Reinhold Kainhofer <reinhold@kainhofer.com>
    Copyright (c) 2005 Rafal Rzepecki <divide@users.sourceforge.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef KOTODOVIEWITEM_H
#define KOTODOVIEWITEM_H

#include <tqmap.h>
#include <tqlistview.h>
#include <tqpalette.h>
#include <tqdatetime.h>

namespace KCal {
class Todo;
}
using namespace KCal;

class KOTodoView;

/**
  This class provides a way of displaying a single Event of Todo-Type in a
  KTodoView.

  @author Cornelius Schumacher <schumacher@kde.org>
  @see KOTodoView
*/
class KOTodoViewItem : public TQCheckListItem
{
  public:
    /**
      Constructor.

      @param parent is the list view to which this item belongs.
      @param todo is the todo to have the item display information for.
      @param kotodo is a pointer to the KOTodoView object.
    */
    KOTodoViewItem(TQListView *parent, Todo *todo, KOTodoView *kotodo);
    KOTodoViewItem(KOTodoViewItem *parent, Todo *todo, KOTodoView *kotodo);
    virtual ~KOTodoViewItem() {}

    void construct();

    Todo *todo() const { return mTodo; }

    bool isAlternate();
    int compare( TQListViewItem *i, int col, bool ascending ) const;
    virtual void paintCell(TQPainter *p, const TQColorGroup &cg,
      int column, int width, int tqalignment);

  protected:
    void paintBranches(TQPainter *p,const TQColorGroup & cg,int w,int y,int h);
  virtual void stateChange(bool);

  private:
    Todo *mTodo;
    KOTodoView *mTodoView;
    TQDateTime mEffectiveDueDate;
    int compareDueDates( const KOTodoViewItem *b ) const;

    uint m_odd : 1;
    uint m_known : 1;
    uint m_unused : 30;
    bool m_init;
};

#endif
