/*
   This file is part of KDE Kontact.

   Copyright (C) 2004 Tobias Koenig <tokoe@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include <tqdragobject.h>

#include "dropwidget.h"

DropWidget::DropWidget( TQWidget *parent, const char *name )
  : TQWidget( parent, name )
{
  setAcceptDrops( true );
}

void DropWidget::dragEnterEvent( TQDragEnterEvent *event )
{
  event->accept( TQTextDrag::canDecode( event ) );
}

void DropWidget::dropEvent( TQDropEvent *event )
{
  int tqalignment = ( event->pos().x() < (width() / 2) ? TQt::AlignLeft : TQt::AlignRight );
  tqalignment |= ( event->pos().y() < (height() / 2) ? TQt::AlignTop : TQt::AlignBottom );
  emit summaryWidgetDropped( this, event->source(), tqalignment );
}

#include "dropwidget.moc"
