/*
    This file is part of Kontact.
    Copyright (c) 2003 Kontact Developer

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef KMAIL_PLUGIN_H
#define KMAIL_PLUGIN_H

#include <klocale.h>
#include <kparts/part.h>

#include "kmailIface_stub.h"
#include <plugin.h>
#include <summary.h>
#include <uniqueapphandler.h>

class TQMimeSource;
class TQDropEvent;

class KMailUniqueAppHandler : public Kontact::UniqueAppHandler
{
public:
    KMailUniqueAppHandler( Kontact::Plugin* plugin ) : Kontact::UniqueAppHandler( plugin ) {}
    virtual void loadCommandLineOptions();
    virtual int newInstance();
};

class KMailPlugin : public Kontact::Plugin
{
  Q_OBJECT
  TQ_OBJECT

  public:
    KMailPlugin( Kontact::Core *core, const char *name, const TQStringList& );
    ~KMailPlugin();

    virtual bool isRunningStandalone();
    virtual bool createDCOPInterface( const TQString& serviceType );
    virtual Kontact::Summary *createSummaryWidget( TQWidget *parent );
    virtual TQString tipFile() const;
    int weight() const { return 200; }

    virtual TQStringList invisibleToolbarActions() const;
    virtual bool queryClose() const;

    //override
    void loadProfile( const TQString& profileDirectory );

    //override
    void saveToProfile( const TQString& profileDirectory );

  protected:
    virtual KParts::ReadOnlyPart* createPart();
    void openComposer( const KURL& = KURL() );
    void openComposer( const TQString& to );
    bool canDecodeDrag( TQMimeSource * );
    void processDropEvent( TQDropEvent * );


  protected slots:
    void slotNewMail();
    void slotSyncFolders();

  private:
    KMailIface_stub *mStub;
    Kontact::UniqueAppWatcher *mUniqueAppWatcher;
};

#endif
