/*******************************************************************
 KNotes -- Notes for the KDE project

 Copyright (c) 2003, Daniel Martin <daniel.martin@pirack.com>
               2004, 2006, Michael Brade <brade@kde.org>

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

 In addition, as a special exception, the copyright holders give
 permission to link the code of this program with any edition of
 the TQt library by Trolltech AS, Norway (or with modified versions
 of TQt that use the same license as TQt), and distribute linked
 combinations including the two.  You must obey the GNU General
 Public License in all respects for all of the code used other than
 TQt.  If you modify this file, you may extend this exception to
 your version of the file, but you are not obligated to do so.  If
 you do not wish to do so, delete this exception statement from
 your version.
*******************************************************************/

#ifndef KNOTESNETSEND_H
#define KNOTESNETSEND_H

#include <tqcstring.h>

#include <kbufferedsocket.h>
#include <ksocketaddress.h>

using namespace KNetwork;

class KNotesNetworkSender : public KNetwork::KBufferedSocket
{
    Q_OBJECT
  TQ_OBJECT
public:
    KNotesNetworkSender( const TQString& host, int port );

    void setSenderId( const TQString& sender );
    void setNote( const TQString& title, const TQString& text );

protected slots:
    void slotConnected( const KResolverEntry& );
    void slotError( int );
    void slotClosed();

    void slotReadyWrite();

private:
    TQCString m_note;
    TQCString m_title;
    TQCString m_sender;
    uint m_index;
};

#endif
