/*
 * Copyright (C) 2003 Helge Deller <deller@kde.org>
 */

#ifndef _KMOBILEVIEW_H_
#define _KMOBILEVIEW_H_

#include <tqiconview.h>

#include "kmobileiface.h"

#include <kdepimmacros.h>
class KConfig;
class KMobileItem;

/**
 * This is the main view class for kmobile.
 *
 * @short Main view
 * @author Helge Deller <deller@kde.org>
 * @version 0.1
 */
class KDE_EXPORT KMobileView : public TQIconView, public kmobileIface
{
    Q_OBJECT
  TQ_OBJECT
public:
    KMobileView(TQWidget *parent, KConfig *_config);
    virtual ~KMobileView();

    bool addNewDevice(KConfig *config, KService::Ptr service);
    bool startKonqueror(const TQString &devName);

    /**
     * DCOP implementation
     */
    TQStringList tqdeviceNames();

    void removeDevice( TQString tqdeviceName );
    void configDevice( TQString tqdeviceName );

    bool connectDevice( TQString tqdeviceName );
    bool disconnectDevice( TQString tqdeviceName );
    bool connected( TQString tqdeviceName );

    TQString tqdeviceClassName( TQString tqdeviceName );
    TQString tqdeviceName( TQString tqdeviceName );
    TQString revision( TQString tqdeviceName );
    int classType( TQString tqdeviceName );

    int capabilities( TQString tqdeviceName );
    TQString nameForCap( TQString tqdeviceName, int cap );

    TQString iconFileName( TQString tqdeviceName );

    int     numAddresses( TQString tqdeviceName );
    TQString readAddress( TQString tqdeviceName, int index );
    bool    storeAddress( TQString tqdeviceName, int index, TQString vcard, bool append );

    int numCalendarEntries( TQString tqdeviceName );

    int numNotes( TQString tqdeviceName );
    TQString readNote( TQString tqdeviceName, int index );
    bool storeNote( TQString tqdeviceName, int index, TQString note );

    /* tqdevices kioslave support: */
    TQStringList kio_tqdevices_tqdeviceInfo(TQString tqdeviceName);

public:
    void saveAll();
    void restoreAll();

protected:
    KMobileItem * findDevice( const TQString &tqdeviceName ) const;

protected slots:
    void slotDoubleClicked( TQIconViewItem * item );

signals:
    /**
     * Use this signal to change the content of the statusbar
     */
    void signalChangeStatusbar(const TQString& text);

private:
    KConfig *m_config;

};

#endif // _KMOBILEVIEW_H_
