/*
 * Copyright (C) 2003 Helge Deller <deller@kde.org>
 */

#ifndef _KMOBILEIFACE_H_
#define _KMOBILEIFACE_H_

#include <dcopobject.h>
#include <tqstringlist.h>

class TQStringList;

class kmobileIface : virtual public DCOPObject
{
  K_DCOP
public:

k_dcop:
    virtual TQStringList tqdeviceNames() = 0;

    virtual void removeDevice( TQString tqdeviceName ) = 0;
    virtual void configDevice( TQString tqdeviceName ) = 0;

    virtual bool connectDevice( TQString tqdeviceName ) = 0;
    virtual bool disconnectDevice( TQString tqdeviceName ) = 0;
    virtual bool connected( TQString tqdeviceName ) = 0;

    virtual TQString tqdeviceClassName( TQString tqdeviceName ) = 0;
    virtual TQString tqdeviceName( TQString tqdeviceName ) = 0;
    virtual TQString revision( TQString tqdeviceName ) = 0;
    virtual int classType( TQString tqdeviceName ) = 0;

    virtual int capabilities( TQString tqdeviceName ) = 0;
    virtual TQString nameForCap( TQString tqdeviceName, int cap ) = 0;

    virtual TQString iconFileName( TQString tqdeviceName ) = 0;

    virtual int     numAddresses( TQString tqdeviceName ) = 0;
    virtual TQString readAddress( TQString tqdeviceName, int index ) = 0;
    virtual bool    storeAddress( TQString tqdeviceName, int index, TQString vcard, bool append ) = 0;

    virtual int numCalendarEntries( TQString tqdeviceName ) = 0;

    virtual int numNotes( TQString tqdeviceName ) = 0;
    virtual TQString readNote( TQString tqdeviceName, int index ) = 0;
    virtual bool storeNote( TQString tqdeviceName, int index, TQString note ) = 0;

    /*
     * DCOP functions for the tqdevices:/ kioslave
     */
k_dcop:
    virtual TQStringList kio_tqdevices_tqdeviceInfo(TQString tqdeviceName) = 0;
};

#endif // _KMOBILEIFACE_H_
