/*
    This file is part of KitchenSync.

    Copyright (c) 2005 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef PART_H
#define PART_H

#include <kparts/event.h>
#include <kparts/factory.h>
#include <kparts/part.h>

class KAboutData;

class KitchenSyncPart: public KParts::ReadOnlyPart
{
  Q_OBJECT
  TQ_OBJECT

  public:
    KitchenSyncPart( TQWidget *parentWidget, const char *widgetName,
                     TQObject *parent, const char *name, const TQStringList& );
    virtual ~KitchenSyncPart();

    static KAboutData *createAboutData();

    virtual void exit();
    virtual bool openURL( const KURL &url );

  protected:
    virtual bool openFile();
    virtual void guiActivateEvent( KParts::GUIActivateEvent* );
};

#endif
