/*
    This file is part of KAddressBook.
    Copyright (c) 2002 Mike Pilone <mpilone@slac.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <tqlabel.h>

#include <kcombobox.h>
#include <kdialog.h>
#include <klocale.h>

#include "filterselectionwidget.h"

FilterSelectionWidget::FilterSelectionWidget( TQWidget *parent, const char *name )
  : TQHBox( parent, name )
{
  setSpacing( KDialog::spacingHint() );

  TQLabel *label = new TQLabel( i18n( "Filter:" ), this, "kde toolbar widget" );

  mFilterCombo = new KComboBox( this );
  label->setBuddy( mFilterCombo );
  connect( mFilterCombo, TQT_SIGNAL( activated( int ) ),
           this, TQT_SIGNAL( filterActivated( int ) ) );
}

FilterSelectionWidget::~FilterSelectionWidget()
{
}

int FilterSelectionWidget::currentItem() const
{
  return mFilterCombo->currentItem();
}

void FilterSelectionWidget::setCurrentItem( int index )
{
  mFilterCombo->setCurrentItem( index );
}

void FilterSelectionWidget::setItems( const TQStringList &names )
{
  mFilterCombo->clear();
  mFilterCombo->insertStringList( names );
}

#include "filterselectionwidget.moc"
