/*
    This file is part of KAddressBook.
    Copyright (c) 2002 Mike Pilone <mpilone@slac.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef KABPREFS_H
#define KABPREFS_H

#include <tqstringlist.h>
#include <kdepimmacros.h>
#include "kabprefs_base.h"

class KConfig;

class KDE_EXPORT KABPrefs : public KABPrefsBase
{
  public:
    virtual ~KABPrefs();

    static KABPrefs *instance();

    void usrReadConfig();
    void usrWriteConfig();

    void setLocationMapURL( const TQString &locationMapURL )
    {
      if ( !isImmutable( TQString::tqfromLatin1( "LocationMapURL" ) ) )
        mLocationMapURL = locationMapURL;
    }

    TQString locationMapURL() const
    {
      return mLocationMapURL;
    }

    void setLocationMapURLs( const TQStringList &locationMapURLs )
    {
      if ( !isImmutable( TQString::tqfromLatin1( "LocationMapURLs" ) ) )
        mLocationMapURLs = locationMapURLs;
    }

    TQStringList locationMapURLs() const
    {
      return mLocationMapURLs;
    }

    TQStringList customCategories() const
    {
      return mCustomCategories;
    }

    void setCustomCategories(const TQStringList & s)
    {
      mCustomCategories = s;
    }

    void setCategoryDefaults();

  private:
    KABPrefs();

    static KABPrefs *mInstance;

    TQString mLocationMapURL;
    TQStringList mLocationMapURLs;
};

#endif
