/*
    This file is part of Akregator.

    Copyright (C) 2005 Frank Osterfeld <frank.osterfeld@kdemail.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef AKREGATOR_DRAGOBJECTS_H
#define AKREGATOR_DRAGOBJECTS_H

#include "article.h"

#include <kurl.h>
#include <kurldrag.h>

#include <tqstring.h>
#include <tqvaluelist.h>

#include <tqcstring.h>

namespace Akregator {

class Article;

struct ArticleDragItem
{
    TQString feedURL;
    TQString guid;
};

class ArticleDrag : public KURLDrag
{

public:

    ArticleDrag(const TQValueList<Article>& articles, TQWidget* dragSource=0, const char* name=0);

    static bool canDecode(const TQMimeSource* e);
    static bool decode(const TQMimeSource* e, TQValueList<ArticleDragItem>& articles);

protected:

    virtual TQByteArray tqencodedData(const char* mime) const;
    virtual const char* format(int i) const;

private:

    static TQValueList<ArticleDragItem> articlesToDragItems(const TQValueList<Article>& articles);
    static KURL::List articleURLs(const TQValueList<Article>& articles);
    TQValueList<ArticleDragItem> m_items;
};

} // namespace Akregator

#endif // AKREGATOR_DRAGOBJECTS_H
