#include "tags.h"
#include "tagsgetter.h"
#include <klocale.h>
#include <tqslider.h>
#include <tqspinbox.h>
#include <kconfig.h>
#include <tqlayout.h>
#include <tqhbox.h>
#include <tqlabel.h>
#include <tqtimer.h>
#include <noatun/player.h>
#include <tqcheckbox.h>

TagsGetter *Tags::getter=0;

TagsGetter::TagsGetter()
{
	new Control(this);
	connect(napp->player(), TQT_SIGNAL(newSong()), TQT_SLOT(newSong()));
}

int TagsGetter::interval() const
{
	KGlobal::config()->setGroup("Tags");
	return KGlobal::config()->readNumEntry("interval", 250);
}

bool TagsGetter::loadAuto() const
{
	KGlobal::config()->setGroup("Tags");
	return KGlobal::config()->readBoolEntry("LoadAuto", true);
}

void TagsGetter::added(PlaylistItem &i)
{
	items += i;
	killTimers();
	startTimer(interval());
}

void TagsGetter::removed(PlaylistItem &i)
{
	items.remove(i);
}

void TagsGetter::getSongs()
{
	items = napp->playlist()->select("Tags::tagged_", "", -1, true, true);
	killTimers();
	startTimer(interval());
}

void TagsGetter::timerEvent(TQTimerEvent *)
{
	if (!items.size())
	{
		killTimers();
		return;
	}

	PlaylistItem item=items.first();
	for (Tags *i=tags.first(); i; i=tags.next())
	{
		if (i->update(item))
		{
			item.setProperty("Tags::tagged_", "1");
			if (item==napp->player()->current())
				napp->player()->handleButtons();
		}
	}

	items.remove(items.begin());
}

void TagsGetter::newSong()
{
	PlaylistItem item=napp->player()->current();
	if (!item) return;
	
	for (Tags *i=tags.first(); i; i=tags.next())
	{
		if (i->update(item))
		{
			item.setProperty("Tags::tagged_", "1");
			napp->player()->handleButtons();
		}
	}
	items.remove(item);
}

void TagsGetter::setInterval(int ms)
{
	killTimers();
	startTimer(ms);
	
	KGlobal::config()->setGroup("Tags");
	KGlobal::config()->writeEntry("interval", ms);
	KGlobal::config()->sync();
}

void TagsGetter::setLoadAuto(bool eh)
{
	
	KGlobal::config()->setGroup("Tags");
	KGlobal::config()->writeEntry("LoadAuto", eh);
	KGlobal::config()->sync();
	
	killTimers();
	
	if (eh) startTimer(interval());
}

void TagsGetter::associate(Tags *t)
{
	tags.append(t);
	sortPriority();
//	getSongs();
	TQTimer::singleShot(interval(), this, TQT_SLOT(getSongs()));
}

void TagsGetter::sortPriority()
{
	// find the lowest one, since it comes first
	
	int lowest=0;
	for (Tags *i=tags.first(); i; i=tags.next())
	{
		if (lowest>i->mPriority)
			lowest=i->mPriority;
	}
	
	TQPtrList<Tags> sorted;
	while (tags.count())
	{
		// find the one equal to myself
		for (Tags *i=tags.first(); i;)
		{
			if (lowest==i->mPriority)
			{
				sorted.append(i);
				tags.removeRef(i);
				i=tags.first();
			}
			else
			{
				i=tags.next();
			}
		}
		lowest++;
	}
	
	tags=sorted;
}

bool TagsGetter::unassociate(Tags *t)
{
	tags.removeRef(t);
	if (tags.count()==0)
	{
		delete this;
		return true;
	}
	return false;
}

Tags::Tags(int priority) : mPriority(priority)
{
	if (!getter)
		getter=new TagsGetter;
	getter->associate(this);
}

Tags::~Tags()
{
	if (getter->unassociate(this))
		getter=0;
}


Control::Control(TagsGetter *parent)
	: CModule(i18n("Tagging"), i18n("Settings for Tag Loaders"), "edit", parent)
{
	// todo
	(void)I18N_NOOP("Rescan All Tags");
	
	TQVBoxLayout *l=new TQVBoxLayout(this);
	TQCheckBox *onPlay;
	{
		onPlay=new TQCheckBox(i18n("Load tags &automatically"), this);
		l->addWidget(onPlay);
		onPlay->show();
	}
	
	{
		TQHBox *intervalLine=new TQHBox(this);
		l->addWidget(intervalLine);
		l->addStretch();
	
		new TQLabel(i18n(
				"The time between each time noatun scans for a new file"
				", and updates tags (e.g., ID3)",
				"Interval:"), intervalLine);
		TQSlider *slider=new TQSlider(
				0, 2000, 100, 0,Qt::Horizontal, intervalLine
			);
		TQSpinBox *spin=new TQSpinBox(
				0, 2000, 10, intervalLine
			);
		
		spin->setSuffix(i18n("Milliseconds", " ms"));
		
		
		connect(slider, TQT_SIGNAL(valueChanged(int)), spin, TQT_SLOT(setValue(int)));
		connect(spin, TQT_SIGNAL(valueChanged(int)), slider, TQT_SLOT(setValue(int)));
		slider->setValue(parent->interval());
		connect(slider, TQT_SIGNAL(valueChanged(int)), parent, TQT_SLOT(setInterval(int)));
	
		connect(onPlay, TQT_SIGNAL(toggled(bool)), intervalLine, TQT_SLOT(setEnabled(bool)));
	}
	connect(onPlay, TQT_SIGNAL(toggled(bool)), parent, TQT_SLOT(setLoadAuto(bool)));

	onPlay->setChecked(parent->loadAuto());
}




#include "tagsgetter.moc"

