#ifndef ViewDockAreaPopup_h
#define ViewDockAreaPopup_h

#include "viewbase.h"

class TQMouseEvent;
class TQGridLayout;
class TQWidget;
class TQPushButton;

class Mixer;
class KMixDockWidget;
class MixDeviceWidget;
class MixDevice;
class TQFrame;
class TQTime;

class ViewDockAreaPopup : public ViewBase
{
    Q_OBJECT
  TQ_OBJECT
public:
    ViewDockAreaPopup(TQWidget* parent, const char* name, Mixer* mixer, ViewBase::ViewFlags vflags, KMixDockWidget *dockW);
    ~ViewDockAreaPopup();
    MixDevice* dockDevice();

    virtual int count();
    virtual int advice();
    virtual void setMixSet(MixSet *mixset);
    virtual TQWidget* add(MixDevice *mdw);
    virtual void constructionFinished();
    virtual void refreshVolumeLevels();
    virtual void showContextMenu();

    TQSize tqsizeHint() const;
    bool justHidden();

protected:
    MixDeviceWidget *_mdw;
    KMixDockWidget  *_dock;
    MixDevice       *_dockDevice;
	 TQPushButton     *_showPanelBox;

    void mousePressEvent(TQMouseEvent *e);
    void wheelEvent ( TQWheelEvent * e );

private:
    TQGridLayout* _layoutMDW;
    TQFrame *_frame;
    TQTime *_hideTimer;

private slots:
	 void showPanelSlot();

};

#endif

