/*
 * KMix -- KDE's full featured mini mixer
 *
 *
 * Copyright (C) 2003-2004 Christian Esken <esken@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "verticaltext.h"
#include <tqpainter.h>
#include <kdebug.h>


VerticalText::VerticalText(TQWidget * parent, const char * name, WFlags f) : TQWidget(parent,name,f)
{
	resize(20,100 /*parent->height() */ );
	setMinimumSize(20,10); // neccesary for smooth integration into layouts (we only care for the widths).
}

VerticalText::~VerticalText() {
}


void VerticalText::paintEvent ( TQPaintEvent * /*event*/ ) {
	//kdDebug(67100) << "paintEvent(). height()=" <<  height() << "\n";
	TQPainter paint(this);
	paint.rotate(270);
        paint.translate(0,-4); // Silly "solution" to make underlengths work

	// Fix for bug 72520
	//-       paint.drawText(-height()+2,width(),name());
	//+       paint.drawText( -height()+2, width(), TQString::fromUtf8(name()) );
	paint.drawText( -height()+2, width(), TQString::fromUtf8(name()) );
}

TQSize VerticalText::tqsizeHint() const {
    return TQSize(20,100); // !! UGLY. Should be reworked
}

TQSizePolicy VerticalText::sizePolicy () const
{
    return TQSizePolicy(TQSizePolicy::Fixed, TQSizePolicy::Preferred);
}

