/**************************************************************************

    kdisptext.h  - The widget that displays the karaoke/lyrics text
    Copyright (C) 1997,98  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    Send comments and bug fixes to larrosa@kde.org
    or to Antonio Larrosa, Rio Arnoya, 10 5B, 29006 Malaga, Spain

***************************************************************************/
#ifndef _kdisptext_h_
#define _kdisptext_h_

#include <tqwidget.h>
#include <tqscrollview.h>
#include <libkmid/player.h>

struct kdispt_ev 
{
    SpecialEvent *spev;
    int xpos;
    class TQRect r;
    kdispt_ev *next;
};

struct kdispt_line
{
    kdispt_ev *ev;
    int num;
    int ypos;
    kdispt_line *next;
};

class TQFont;
class TQFontMetrics;
class TQScrollBar;

class KDisplayText : public TQScrollView 
{
    Q_OBJECT
  TQ_OBJECT
private:
    TQTextCodec *lyrics_codec;    

    TQFontMetrics *qfmetr;
    TQFont *qtextfont;
    
    int typeoftextevents;
    
    kdispt_line *linked_list_[2];
    int nlines_[2];
    kdispt_line *first_line_[2];
    kdispt_line *cursor_line_[2];
    kdispt_ev *cursor_[2];
    
    kdispt_line *linked_list; 
    kdispt_line *cursor_line;
    kdispt_ev *cursor;
    
    kdispt_line *first_line; // Pointer to first text at first visible line
    
    int nlines;     // Total number of lines
    int nvisiblelines; // Number of visible lines
    
    void RemoveLine(kdispt_line *tmpl);
    void RemoveLinkedList(void);
    
    int IsLineFeed(char c,int type=0);
    virtual void drawContents(TQPainter *qpaint,int clipx,int clipy,int clipw,int cliph);

    kdispt_line * searchYOffset(int y, kdispt_line *start);
    
    int maxX[2];
    int maxY[2];
    int autoscrollv;

protected:
    virtual void resizeEvent(TQResizeEvent *qre);
    virtual void timerEvent(TQTimerEvent *e);
    
public:
    KDisplayText(TQWidget *parent,const char *name);
    virtual ~KDisplayText();
    
    void ClearEv(bool totally=true);
    void AddEv(SpecialEvent *ev);
    void calculatePositions(void);
    
    void CursorToHome(void);
    
    void ChangeTypeOfTextEvents(int type); 
    int ChooseTypeOfTextEvents(void);
    void PaintIn(int type);
    void gotomsec(ulong i);
    
    TQFont *getFont(void);
    void fontChanged(void);
    
    void saveLyrics(FILE *fh);
    
    void setLyricsEncoding(const TQString &enc);

//    TQSize tqsizeHint();
 
public slots:
    void ScrollDown();
    void ScrollUp();
    void ScrollPageDown();
    void ScrollPageUp();
    
};

#endif
