/*

    Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    */

#include "choosebusdlg.h"

#include <artsflow.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqlistbox.h>
#include <tqpushbutton.h>

#include <kbuttonbox.h>
#include <kseparator.h>
#include <klineedit.h>
#include <klocale.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kstdguiitem.h>

using namespace std;

static void min_size(TQWidget *w) {
  w->setMinimumSize(w->tqsizeHint());
}

ChooseBusDlg::ChooseBusDlg(TQWidget *parent)
	: KDialog(parent,"X", TRUE)
	, _newbusitemindex( -1 )
{
	setCaption(i18n("Choose Bus"));

	TQVBoxLayout *maintqlayout = new TQVBoxLayout(this);

// caption label: "Synthesis running..."

	maintqlayout->addSpacing(5);
	TQLabel *captionlabel = new TQLabel(this);
	TQFont labelfont(captionlabel->font());
	labelfont.setPointSize(labelfont.pointSize()*3/2);
	captionlabel->setFont(labelfont);
	captionlabel->setText(TQString(" ")+i18n("Available busses:")+TQString(" "));
	captionlabel->tqsetAlignment(AlignCenter);
	min_size(captionlabel);
	maintqlayout->addWidget(captionlabel);

// hruler

	maintqlayout->addSpacing(5);
	KSeparator *ruler2 = new KSeparator( KSeparator::HLine, this);
	maintqlayout->addWidget(ruler2);

	maintqlayout->addSpacing(5);

// listwidget


	listbox = new TQListBox(this);
    listbox->setMinimumSize(300,200);

	Arts::AudioManager aman = Arts::Reference("global:Arts_AudioManager");

	if(!aman.isNull())
	{
		vector<string> *destinations = aman.destinations();
		unsigned long i;
		for(i=0;i<destinations->size();i++)
			listbox->insertItem((*destinations)[i].c_str());
		delete destinations;
	}
	if( listbox->count() > 0 )
		listbox->setCurrentItem( 0 );

	maintqlayout->addWidget(listbox);

// hruler

	maintqlayout->addSpacing(5);
	KSeparator *ruler = new KSeparator( KSeparator::HLine, this);
	maintqlayout->addWidget(ruler);
	maintqlayout->addSpacing(5);

// new bus lineedit

	TQBoxLayout * tqlayout2 = new TQHBoxLayout( maintqlayout );
	//maintqlayout->addLayout( tqlayout2 );
	TQLabel * newbuslabel = new TQLabel( i18n( "New bus:" ), this );
	tqlayout2->addWidget( newbuslabel );
	lineedit = new KLineEdit( this );
	connect( lineedit, TQT_SIGNAL( textChanged( const TQString & ) ), TQT_SLOT( textChanged( const TQString & ) ) );
	tqlayout2->addWidget( lineedit );

// hruler

	maintqlayout->addSpacing(5);
	KSeparator *ruler3 = new KSeparator( KSeparator::HLine, this);
	maintqlayout->addWidget(ruler3);

	maintqlayout->addSpacing(5);

// buttons

	maintqlayout->addSpacing(5);
	TQHBoxLayout *buttontqlayout = new TQHBoxLayout( maintqlayout );
	//maintqlayout->addLayout(buttontqlayout);
	maintqlayout->addSpacing(5);

	buttontqlayout->addSpacing(5);
	KButtonBox *bbox = new KButtonBox(this);

	bbox->addButton(KStdGuiItem::help(), TQT_TQOBJECT(this), TQT_SLOT( help() ));
	bbox->addStretch(1);

	TQPushButton * okbutton = bbox->addButton(KStdGuiItem::ok());
	okbutton->setDefault( true );
	connect( okbutton, TQT_SIGNAL( clicked() ), TQT_SLOT(accept() ) );

	TQButton *cancelbutton = bbox->addButton(KStdGuiItem::cancel());
	connect( cancelbutton, TQT_SIGNAL( clicked() ), TQT_SLOT(reject() ) );

	bbox->tqlayout();

	buttontqlayout->addWidget(bbox);
	buttontqlayout->addSpacing(5);

	maintqlayout->freeze();
}

TQString ChooseBusDlg::result()
{
	if(listbox->currentItem() != -1)
	{
		return(listbox->text(listbox->currentItem()));
	}
	return(0);
}

void ChooseBusDlg::help()
{
	KApplication::kApplication()->invokeHelp("", "artsbuilder");
}

void ChooseBusDlg::textChanged( const TQString & busname )
{
	if( ! busname.isEmpty() )
	{
		if( _newbusitemindex > -1 )
			listbox->changeItem( busname, _newbusitemindex );
		else
		{
			_newbusitemindex = listbox->count();
			listbox->insertItem( busname, _newbusitemindex );
			listbox->setCurrentItem( _newbusitemindex );
		}
	}
	else
	{
		listbox->removeItem( _newbusitemindex );
		listbox->setCurrentItem( _newbusitemindex - 1 );
		_newbusitemindex = -1;
	}
}

#include "choosebusdlg.moc"

// vim: sw=4 ts=4
