/***************************************************************************

                   language properties dialog page

    -----------------------------------------------------------------------

    begin          : Wed Oct 13 18:37:13 1999

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef LangPropPage_included
#define LangPropPage_included

#include "LangPropPageForm.h"

#include <grammarmanager.h>

class kvoctrainDoc;

class LangPropPage : public LangPropPageForm
{
  Q_OBJECT
  TQ_OBJECT

public:

  LangPropPage
  (
    kvoctrainDoc      *doc,
    TQString            curr_lang,
    const Conjugation &conjugations,
    const Article     &article,
    TQWidget           *parent = NULL,
    const char        *name = NULL
  );

  Conjugation getConjugation();
  Article getArticle() const { return articles; }

protected slots:

  void secondPluralChanged(const TQString&);
  void secondSingularChanged(const TQString&);
  void thirdNSingularChanged(const TQString&);
  void thirdFPluralChanged(const TQString&);
  void thirdMSingularChanged(const TQString&);
  void thirdFSingularChanged(const TQString&);
  void thirdMPluralChanged(const TQString&);
  void thirdNPluralChanged(const TQString&);
  void firstPluralChanged(const TQString&);
  void firstSingularChanged(const TQString&);
  void slotThirdSCommonToggled(bool);
  void slotThirdPCommonToggled(bool);

  void defNaturalChanged(const TQString& );
  void indefMaleChanged(const TQString& );
  void indefNaturalChanged(const TQString& );
  void defFemaleChanged(const TQString& );
  void indefFemaleChanged(const TQString& );
  void defMaleChanged(const TQString& );

protected:

  kvoctrainDoc  *doc;
  Conjugation    conjugations;
  Article        articles;
};

#endif // LangPropPage_included
