/***************************************************************************
                          kverbos.h  -  description
                             -------------------
    begin                : Fre Dez 14 19:28:09 CET 2001
    copyright            : (C) 2001 by Arnold Kraschinski
    email                : arnold.k67@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KVERBOS_H
#define KVERBOS_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for TQt

// include files for KDE
#include <kapplication.h>
#include <kmainwindow.h>
#include <kaction.h>

// include files for the application
#include "verbspanish.h"

// forward declaration of the KVerbos classes
class KVerbosDoc;
class KVerbosView;
class KErfassen;
class KVerbEdit;
class KFeederControl;

/**
  * The base class for KVerbos application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KVerbosView creates your center view, which is connected
  * to the window's Doc object.
  * KVerbosApp reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
class KVerbosApp : public KMainWindow
{
  Q_OBJECT
  TQ_OBJECT

  friend class KVerbosView;

  public:
    /** construtor of KVerbosApp, calls all init functions to create the application.
     */
    KVerbosApp(TQWidget* parent=0, const char* name=0);
    ~KVerbosApp();
    /** opens a file specified by commandline option
     */
    void openDocumentFile(const KURL& url/*=0*/);
    /** returns a pointer to the current document connected to the KTMainWindow instance and is used by
     * the View class to access the document object's methods
     */	
    KVerbosDoc *getDocument() const; 	
    /** returns the array with the time options
     */
    void getTimeOptions(bool op[][3]);
    bool doitStrict() const { return correctStrict; }

  protected:
    /** save general Options like all bar positions and status as well as the tqgeometry and the recent file list to the configuration
     * file
     */ 	
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();
    /** initializes the KActions of the application */
    void initActions();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();
    /** initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */
    void initDocument();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
    void initView();
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryClose();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryExit();
    /** saves the window properties for each open window during session end to the session config file, including saving the currently
     * opened file by a temporary filename provided by KApplication.
     * @see KTMainWindow#saveProperties
     */
    virtual void saveProperties(KConfig *_cfg);
    /** reads the session config file and restores the application's state including the last opened files and documents by reading the
     * temporary files saved by saveProperties()
     * @see KTMainWindow#readProperties
     */
    virtual void readProperties(KConfig *_cfg);

  signals:
    /** Dieses Signal zeigt dem Dokument an, dass die Statuszeile mit der richtigen
     *  Verbanzahl aktualisiert werden sollte.
     */
    void testAnzahl(int);
  public slots:
    /** open a new application window by creating a new instance of KVerbosApp */
    void slotFileNewWindow();
    /** clears the document in the actual view to reuse it as the new document */
    void slotFileNew();
    /** open a file and load it into the document*/
    void slotFileOpen();
    /** opens a file from the recent files menu */
    void slotFileOpenRecent(const KURL& url);
    /** opens the standard verb file that is delivered with KVerbos. */
    void slotFileOpenStandard();
    /** save a document */
    void slotFileSave();
    /** save a document by a new filename*/
    void slotFileSaveAs();
    /** asks for saving if the file is modified, then closes the actual file and window*/
    void slotFileClose();
    /** print the actual file */
    void slotFilePrint();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
    void slotFileQuit();
    /** put the marked text/object into the clipboard and remove
     *	it from the document
     */
    void slotEditCut();
    /** put the marked text/object into the clipboard
     */
    void slotEditCopy();
    /** paste the clipboard into the document
     */
    void slotEditPaste();
    /** changes the statusbar contents for the standard label permanently, used to indicate
     *  current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const TQString &text);
    /** Gibt die Anzahl der Verben in der Statuszeile aus */
    void slotStatusVerbMsg(int);
    /** Gibt die Anzahl der gebten Verben in der Statuszeile aus.
      */
    void slotStatusTrainedMsg(int);
    /** Gibt die Anzahl der richtig eingegebenen Verben in der Statuszeile aus.
      */
    void slotStatusCorrectMsg(int);
    /** ffnet einen Dialog mit dem neue Verben erfasst werden knnen.
     */
    void slotEditErfassen();
    /** ffnet einen Dialog, der die Liste der Verben anzeigt. Die Verbliste
     *  kann dann bearbeitet werden, Verben lschen, Verben hinzufgen, Eintrge
     *  verndern.
     */
    void slotEditBearbeiten();
    /** Opens a dialog. The user can select which times should be trained.
     */
    void slotSettingsOptions();
    /** Opens a dialog. The user can insert his name. Then a user object will be created
     */
    void slotSettingsUsername();
    void slotFeedIt(int n);
    /** Opens a dialog and shows the user his latest ten results. */
    void slotUserResults();

  private:
    /** the configuration object of the application */
    KConfig *config;
    /** in this array are the times stored that should be learned
     */
    bool timeOptions[MAX_TIEMPOS][MAX_SUBTYPES];
    /** If 'correctStrict' is true then every missing accent is regarded as an error.
      * If 'correctStrict' is false the program doesn't care about missing accents
      */
    bool correctStrict;
    /** If 'useKFeeder' is true then the KFeeder is used to show the results
      */
    bool useKFeeder;
    /** Is 'true' if the splash screen of the KFeeder should be displayed */
    bool showKFeederSplash;
    /** Is 'true' if automatic food animations are uses for the KFeeder */
    bool automaticKFeeder;
    KFeederControl* kfeederControl;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    KVerbosView *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
    KVerbosDoc *doc;

    // KAction pointers to enable/disable actions
    KPopupMenu* menuUser;
    KAction* fileNewWindow;
    KAction* fileNew;
    KAction* fileOpen;
    KRecentFilesAction* fileOpenRecent;
	KAction* fileOpenStandard;
    KAction* fileSave;
    KAction* fileSaveAs;
    KAction* fileClose;
    KAction* filePrint;
    KAction* fileQuit;
    KAction* editCut;
    KAction* editCopy;
    KAction* editPaste;
    KAction* editErfassen;
    KAction* editBearbeiten;
    KAction* settingOptions;
    KAction* userUsername;
    KAction* userResults;



    static int kverbosCounter;
};
 
#endif // KVERBOS_H
