/***************************************************************************
                          modcalcequinox.cpp  -  description
                             -------------------
    begin                : dom apr 18 2002
    copyright            : (C) 2004 by Pablo de Vicente
    email                : p.devicentea@wanadoo.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "modcalcequinox.h"

#include "modcalcequinox.moc"
#include "dms.h"
#include "dmsbox.h"
#include "kstars.h"
#include "kstarsdata.h"
#include "kstarsdatetime.h"
#include "kssun.h"
#include "libkdeedu/extdate/extdatetimeedit.h"

#include <tqcombobox.h>
#include <tqstring.h>
#include <tqtextstream.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>

modCalcEquinox::modCalcEquinox(TQWidget *parentSplit, const char *name) 
		: modCalcEquinoxDlg (parentSplit,name) {
	showCurrentYear();
	show();
}

modCalcEquinox::~modCalcEquinox(){
}

int modCalcEquinox::getYear (TQString eName)
{
	bool ok = FALSE;
	int equinoxYear = eName.toInt(&ok);
	if ( ok ) 
		return equinoxYear;
	else {
		kdDebug() << i18n( "Could not parse epoch string; assuming J2000" ) << endl;
		return 2000;
	}
}

void modCalcEquinox::showCurrentYear (void)
{
	KStarsDateTime dt( KStarsDateTime::tqcurrentDateTime() );
	yearEdit->setText( TQString( "%1").tqarg( dt.date().year() ) );
}

void modCalcEquinox::slotComputeEquinoxesAndSolstices (void)
{
	long double julianDay = 0., jdf = 0.;
	float deltaJd;
	KStarsData *kd = (KStarsData*) parent()->parent()->parent();
	KSSun *Sun = new KSSun(kd);
	int year0 = getYear( yearEdit->text() );
	
	if (equinoxSolsticesComboBox->currentItem() == 0 ) {
		julianDay = Sun->springEquinox(year0);
		jdf = Sun->summerSolstice(year0);
	}
	else if(equinoxSolsticesComboBox->currentItem() == 1) {
		julianDay = Sun->summerSolstice(year0);
		jdf = Sun->autumnEquinox(year0);
	}
	else if (equinoxSolsticesComboBox->currentItem() == 2 ) {
		julianDay = Sun->autumnEquinox(year0);
		jdf = Sun->winterSolstice(year0);
	}
	else if(equinoxSolsticesComboBox->currentItem() == 3) {
		julianDay = Sun->winterSolstice(year0);
		jdf = Sun->springEquinox(year0+1);
	}
	
	deltaJd = (float) (jdf - julianDay);
	showStartDateTime(julianDay);
	showSeasonDuration(deltaJd);
	
}

void modCalcEquinox::slotClear(void){
	yearEdit->setText("");
	seasonDuration->setText("");
}

void modCalcEquinox::showStartDateTime(long double jd)
{
	KStarsDateTime dt( jd );
	startDateTimeEquinox->setDateTime( dt );
}

void modCalcEquinox::showSeasonDuration(float deltaJd)
{
	seasonDuration->setText( TQString( "%1").tqarg( deltaJd ) );
}

void modCalcEquinox::slotYearCheckedBatch(){
	if ( yearCheckBatch->isChecked() )
		yearCheckBatch->setEnabled( false );
	else {
		yearCheckBatch->setEnabled( true );
	}
}

void modCalcEquinox::slotInputFile() {
	TQString inputFileName;
	inputFileName = KFileDialog::getOpenFileName( );
	InputLineEditBatch->setText( inputFileName );
}

void modCalcEquinox::slotOutputFile() {
	TQString outputFileName;
	outputFileName = KFileDialog::getSaveFileName( );
	OutputLineEditBatch->setText( outputFileName );
}

void modCalcEquinox::slotRunBatch() {

	TQString inputFileName;

	inputFileName = InputLineEditBatch->text();

	// We open the input file and read its content

	if ( TQFile::exists(inputFileName) ) {
		TQFile f( inputFileName );
		if ( !f.open( IO_ReadOnly) ) {
			TQString message = i18n( "Could not open file %1.").tqarg( f.name() );
			KMessageBox::sorry( 0, message, i18n( "Could Not Open File" ) );
			inputFileName = "";
			return;
		}

//		processLines(&f);
		TQTextStream istream(&f);
		processLines(istream);
//		readFile( istream );
		f.close();
	} else  {
		TQString message = i18n( "Invalid file: %1" ).tqarg( inputFileName );
		KMessageBox::sorry( 0, message, i18n( "Invalid file" ) );
		inputFileName = "";
		InputLineEditBatch->setText( inputFileName );
		return;
	}
}

void modCalcEquinox::processLines( TQTextStream &istream ) {

	// we open the output file

//	TQTextStream istream(&fIn);
	TQString outputFileName;
	outputFileName = OutputLineEditBatch->text();
	TQFile fOut( outputFileName );
	fOut.open(IO_WriteOnly);
	TQTextStream ostream(&fOut);

	TQString line;
	TQString space = " ";
	int yearB;
	int i = 0;
	long double jdsp = 0., jdsu = 0., jdau = 0., jdwin = 0., jdsp1 = 0.;
	KStarsData *kd = (KStarsData*) parent()->parent()->parent();
	KSSun *Sun = new KSSun(kd);

	while ( ! istream.eof() ) {
		line = istream.readLine();
		line.stripWhiteSpace();

		//Go through the line, looking for parameters

		TQStringList fields = TQStringList::split( " ", line );

		i = 0;

		// Read year and write in ostream if corresponds

		if(yearCheckBatch->isChecked() ) {
			yearB = fields[i].toInt();
			i++;
		} else
			yearB = yearEditBatch->text().toInt();

		if ( allRadioBatch->isChecked() )
			ostream << yearB << space;
		else
			if(yearCheckBatch->isChecked() )
				ostream << yearB << space;

		jdsp = Sun->springEquinox(yearB);
		jdsu = Sun->summerSolstice(yearB);
		jdau = Sun->autumnEquinox(yearB);
		jdwin = Sun->winterSolstice(yearB);
		jdsp1 = Sun->springEquinox(yearB+1);

		KStarsDateTime dts( jdsp );
		KStarsDateTime dtu( jdsu );
		KStarsDateTime dta( jdau );
		KStarsDateTime dtw( jdwin );

		ostream << dts.toString(Qt::ISODate) << space << (float)(jdsu - jdsp) << space 
						<< dtu.toString(Qt::ISODate) << space << (float)(jdau - jdsu) << space 
						<< dta.toString(Qt::ISODate) << space << (float)(jdwin - jdau) << space 
						<< dtw.toString(Qt::ISODate) << space << (float)(jdsp1 - jdwin) << endl;
	}


	fOut.close();
}
