// (c) 2000 Peter Putzer

#include <tqstring.h>
#include <tqcstring.h>

#include <kurl.h>

#include "Data.h"
#include "ksvdraglist.h"
#include "ksvdrag.h"

class KSVDrag::Private
{
public:
  TQByteArray mNative;
  TQString mText;
  KURL mURL;
};

KSVDrag::KSVDrag (const KSVData& item, TQWidget* source, const char* name)
  : TQDragObject (source, name),
    d (new Private())
{
  TQDataStream ds (d->mNative, IO_ReadWrite);
  ds << item;

  d->mText = item.filenameAndPath ();
  d->mURL.setPath (item.path() + "/" + item.filename());
}

KSVDrag::KSVDrag (const KSVItem& item, TQWidget* source, const char* name)
  : TQDragObject (source, name),
    d (new Private())
{
  TQDataStream ds (d->mNative, IO_ReadWrite);
  ds << *item.data();

  d->mText = item.toString();
  d->mURL.setPath (item.path() + "/" + item.filename());
}

KSVDrag::~KSVDrag ()
{
  delete d;
}

const char* KSVDrag::format (int i) const
{
  switch (i)
	{
	case Native:
	  return "application/x-ksysv";
	  break;
	  
	case Text:
	  return "text/plain";
	  break;
	  
	case URL:
	  return "text/uri-list";
	  break;
	  
	default:
	  return 0L;
	}
}

TQByteArray KSVDrag::tqencodedData (const char* format) const
{
  TQByteArray res;

  if (!strcmp (format, "application/x-ksysv"))
    {
      res = d->mNative;
    }
  else if (!strcmp (format, "text/plain"))
    {
      TQDataStream ds (res, IO_ReadWrite);
	  ds << d->mText;
    }
  else if (!strcmp (format, "text/uri-list"))
    {
      res = TQCString(d->mURL.url().latin1()).copy();
    }

  return res;
}

bool KSVDrag::decodeNative (const TQMimeSource* mime, KSVData& data)
{
  if (mime && mime->provides ("application/x-ksysv"))
	{
	  TQDataStream ds (mime->tqencodedData ("application/x-ksysv"), IO_ReadOnly);
	  ds >> data;

	  return true;
	}

  return false;
}

#include "ksvdrag.moc"
