//
//  kjots
//
//  Copyright (C) 1997 Christoph Neerfeld
//  Copyright (C) 2002-2004 Aaron J. Seigo
//  Copyright (C) 2003 Stanislav Kljuhhin
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

#ifndef KJotsMain_included
#define KJotsMain_included

#include <qlayout.h>
#include <qpushbutton.h>

#include <kdialogbase.h>
#include <kmainwindow.h>

class QGroupBox;
class QWidgetStack;
class KTextBrowser;
class KAccel;
class KJotsMain;
class KToolBar;
class KListBox;
class KListView;
class KPopupMenu;
class ConfigureDialog;
class KEdFind;
class KEdReplace;
class QTimer;

class KJotsSubject;
class KJotsBook;
class KJotsEntryBase;
class KJotsEdit;

//
// KJotsMain
//

class KJotsMain : public KMainWindow
{
    Q_OBJECT

    public:
        KJotsMain( const char* name = 0 );

        QString currentTitle();
        QString currentBookmarkURL();

    public:
        void updateCaption();

    protected slots:
        void slotSetupInterface();
        bool createFolder();
        void deleteFolder();
        void newEntry();
        void deleteEntry();
        void slotRenameEntry();
        void configure();
        void updateConfiguration();

        void copySelection();
        void insertDate();
        void slotPrint();
        void slotSearch();
        void slotRepeatSearch();
        void slotReplace();
        void slotQuit();
        void slotFindSuccessful();

        void slotExpandBook(QListViewItem* item);
        void slotCollapseBook(QListViewItem* item);
        void jumpToEntry(QListViewItem* entry);
        void slotItemRenamed(QListViewItem*,const QString&,int);
        void slotItemMoved(QListViewItem*,QListViewItem*,QListViewItem*);
        void writeBook();
        void writeBookToHTML();
        void saveBookToFile(bool plainText);
        void writePage();
        void writePageToHTML();
        void savePageToFile(bool plainText);

        void nextBook();
        void prevBook();
        void nextPage();
        void prevPage();
        QListViewItem* findNextBookItem();
        QListViewItem* findPrevBookItem();

        // handling page changes in the listview
        void showListviewContextenu(KListView* l, QListViewItem* i, const QPoint& p);
        void bookLinkClicked(const QString&);
        void autoSave();

        // bookmarks
        void jumpToBookmark(const QString& page);

    protected:
        void saveProperties();
        bool queryClose();
        void syncTextWithEntry(KJotsSubject* entry);
        void syncEntryWithText(KJotsSubject* entry);
        void updateMenu();
        void loadBooks();
        KJotsBook* currentBook();
        KJotsSubject* currentSubject();

        QHBoxLayout   *bg_top_layout;
        QButtonGroup  *bg_top;
        KJotsEdit   *me_text;
        KTextBrowser *roTextView;
        KListView     *subjectList;
        KJotsEntryBase *currentEntry;
        QSplitter *splitter;
        QWidgetStack *textStack;
        QFont m_font;
        bool    wantAutoSave;
        int     autoSaveInterval;
        QTimer*  m_autosaveTimer;
};

#endif // KJotsMain_included
/* ex: set tabstop=4 softtabstop=4 shiftwidth=4 expandtab: */
