//
// Class: documentRenderer
//
// Abstract Widget for displaying document types
// Needs to be implemented from the actual parts
// using kviewshell 
// Part of KViewshell - A generic interface for document viewers.
//
// (C) 2004 Wilfried Huss, Stefan Kebekus. Distributed under the GPL.

#include <kdebug.h>

#include "documentRenderer.h"
#include "documentPage.h"


documentRenderer::documentRenderer(QWidget* par)
  : parentWidget(par)
{
  numPages = 0;
}


documentRenderer::~documentRenderer()
{
  ;
}


void documentRenderer::clear()
{
  numPages = 0;
  pageSizes.clear();
  anchorList.clear();
}


simplePageSize documentRenderer::sizeOfPage(PageNumber page) const
{
  if (page.isInvalid()) {
    kdError(4300) << "documentRenderer::sizeOfPage(..) called with invalid page number" << endl;
    return simplePageSize();
  }
  if (page > totalPages()) {
    //    kdError(4300) << "documentRenderer::sizeOfPage( " << page << " ) called, but the document contains only " << totalPages() << " pages" << endl;
    return simplePageSize();
  }

  if (page > pageSizes.size())
    return simplePageSize();
  return pageSizes[page-1];
}


void documentRenderer::drawThumbnail(double resolution, documentPage* page)
{
  drawPage(resolution, page);
}


bool documentRenderer::isValidFile(const QString)
{
  return true;
}


anchor documentRenderer::parseReference(const QString &)
{
  return anchor();
}


anchor documentRenderer::findAnchor(const QString &locallink)
{
  QMap<QString,anchor>::Iterator it = anchorList.find(locallink);
  if (it != anchorList.end())
    return *it;
  else
    return anchor();
}


#include "documentRenderer.moc"
