/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report.javap;

import com.sun.tools.javap.Main;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class JavapClassReader {
    private static URLClassLoader classLoader = null;
    private static Method method;
    private static Object instance;
    private static File toolsJar;

    public static void read(String filePath, String jarPath, PrintWriter pw) {
        try {
            if (jarPath == null) {
                Main.run(new String[]{"-c", "-p", filePath}, pw);
            } else {
                Main.run(new String[]{"-c", "-p", "-classpath", jarPath, filePath}, pw);
            }
        }
        catch (NoClassDefFoundError error) {
            if (classLoader == null) {
                File javaHome = new File(System.getProperty("java.home"));
                if (javaHome.getName().equals("jre")) {
                    toolsJar = new File(new File(javaHome = javaHome.getParentFile(), "lib"), "tools.jar");
                    if (toolsJar.exists()) {
                        try {
                            classLoader = new URLClassLoader(new URL[]{toolsJar.toURI().toURL()}, ClassLoader.getSystemClassLoader());
                            Class<?> classToLoad = Class.forName("com.sun.tools.javap.Main", true, classLoader);
                            method = classToLoad.getDeclaredMethod("run", String[].class, PrintWriter.class);
                            instance = classToLoad.newInstance();
                            String[] params = null;
                            params = jarPath == null ? new String[]{"-c", "-p", filePath} : new String[]{"-c", "-p", "-classpath", jarPath, filePath};
                            try {
                                Object result = method.invoke(instance, params, pw);
                            }
                            catch (Exception ex) {
                                JavapClassReader.printToolsJarError();
                            }
                        }
                        catch (Exception e) {
                            JavapClassReader.printToolsJarError();
                        }
                    }
                    JavapClassReader.printToolsJarError();
                }
                System.err.println("cannot execute javap, perhaps jdk7+/lib/tools.jar is missing from the classpath");
                System.err.println("example: java -cp jcov.jar:tools.jar com.sun.tdk.jcov.RepGen -javap path_to_classes -o path_to_javap_output path_to_result.xml");
                return;
            }
            String[] params = null;
            params = jarPath == null ? new String[]{"-c", "-p", filePath} : new String[]{"-c", "-p", "-classpath", jarPath, filePath};
            try {
                Object result = method.invoke(instance, params, pw);
            }
            catch (Exception ex) {
                JavapClassReader.printToolsJarError();
            }
        }
    }

    private static void printToolsJarError() {
        System.err.println("cannot execute javap, perhaps jdk7+/lib/tools.jar is missing from the classpath and from java.home");
        System.err.println("example: java -cp jcov.jar:tools.jar com.sun.tdk.jcov.RepGen -javap path_to_classes -o path_to_javap_output path_to_result.xml");
    }
}

