/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.jcov.report;

import com.sun.tdk.jcov.instrument.DataBlock;
import com.sun.tdk.jcov.instrument.DataBlockTarget;
import com.sun.tdk.jcov.instrument.DataBlockTargetCond;
import com.sun.tdk.jcov.instrument.DataMethod;
import com.sun.tdk.jcov.report.CoverageData;
import com.sun.tdk.jcov.report.DataType;
import com.sun.tdk.jcov.report.ItemCoverage;
import com.sun.tdk.jcov.report.LineCoverage;
import com.sun.tdk.jcov.report.MemberCoverage;
import com.sun.tdk.jcov.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCoverage
extends MemberCoverage
implements Iterable<ItemCoverage> {
    private LineCoverage lineCoverage = new LineCoverage();
    private List<ItemCoverage> items = new ArrayList<ItemCoverage>();
    private boolean inAnonymClass = false;
    private boolean anonymon = false;
    private DataType[] supportedColumns = new DataType[]{DataType.METHOD, DataType.BLOCK, DataType.BRANCH, DataType.LINE};
    public static final int CT_FIRST_KIND = 1;
    public static final int CT_METHOD = 1;
    public static final int CT_FIKT_METHOD = 2;
    public static final int CT_BLOCK = 3;
    public static final int CT_FIKT_RET = 4;
    public static final int CT_CASE = 5;
    public static final int CT_SWITCH_WO_DEF = 6;
    public static final int CT_BRANCH_TRUE = 7;
    public static final int CT_BRANCH_FALSE = 8;
    public static final int CT_LINE = 9;
    public static final int CT_LAST_KIND = 9;

    public MethodCoverage(DataMethod method) {
        this(method, false);
    }

    public MethodCoverage(DataMethod method, boolean countBlocks) {
        this.modifiers = Arrays.deepToString(method.getAccessFlags());
        this.name = method.getName();
        this.scale = method.getScale();
        this.signature = method.getVmSignature();
        this.access = method.getAccess();
        if (this.signature == null) {
            this.signature = "";
        }
        this.count = method.getCount();
        MethodCoverage.detectItems(method, this.items);
        List<DataMethod.LineEntry> lineTable = method.getLineTable();
        if (lineTable != null) {
            if (lineTable.size() > 0) {
                this.startLine = lineTable.get((int)0).line;
            }
            this.lineCoverage.processLineTable(lineTable);
            for (ItemCoverage item : this.items) {
                for (DataMethod.LineEntry le : lineTable) {
                    if (le.bci < item.startLine || le.bci > item.endLine) continue;
                    if (item.count > 0L) {
                        this.lineCoverage.hitLine(le.line);
                    }
                    if (item.getSourceLine() >= 0) continue;
                    item.setSrcLine(le.line);
                }
            }
        }
    }

    public void setAnonymOn(boolean anonym) {
        this.anonymon = anonym;
    }

    public void setInAnonymClass(boolean inAnonymClass) {
        this.inAnonymClass = inAnonymClass;
    }

    public boolean isInAnonymClass() {
        return this.inAnonymClass;
    }

    static void detectItems(DataMethod m, List<ItemCoverage> list) {
        boolean isNew;
        ItemCoverage item;
        int type;
        HashMap<DataBlock, ItemCoverage> added = new HashMap<DataBlock, ItemCoverage>();
        for (DataBlock dataBlock : m.getBlocks()) {
            if (dataBlock instanceof DataBlockTarget) continue;
            type = MethodCoverage.type(dataBlock);
            item = null;
            item = type == 3 ? ItemCoverage.createBlockCoverageItem(dataBlock.startBCI(), dataBlock.endBCI(), dataBlock.getCount(), dataBlock.getScale()) : ItemCoverage.createBranchCoverageItem(dataBlock.startBCI(), dataBlock.endBCI(), dataBlock.getCount(), dataBlock.getScale());
            isNew = true;
            for (DataBlock d : added.keySet()) {
                if (d.startBCI() != dataBlock.startBCI() || MethodCoverage.type(d) != MethodCoverage.type(dataBlock) || !((ItemCoverage)added.get(d)).isBlock()) continue;
                ((ItemCoverage)added.get((Object)d)).count += dataBlock.getCount();
                isNew = false;
                break;
            }
            if (!isNew) continue;
            added.put(dataBlock, item);
            if (type == 1) continue;
            list.add(item);
        }
        for (DataBlockTarget dataBlockTarget : m.getBranchTargets()) {
            type = MethodCoverage.type(dataBlockTarget);
            item = null;
            item = type == 3 ? ItemCoverage.createBlockCoverageItem(dataBlockTarget.startBCI(), dataBlockTarget.endBCI(), dataBlockTarget.getCount(), dataBlockTarget.getScale()) : ItemCoverage.createBranchCoverageItem(dataBlockTarget.startBCI(), dataBlockTarget.endBCI(), dataBlockTarget.getCount(), dataBlockTarget.getScale());
            isNew = true;
            for (DataBlock d : added.keySet()) {
                if (d.startBCI() != dataBlockTarget.startBCI() || MethodCoverage.type(d) != MethodCoverage.type(dataBlockTarget) || !((ItemCoverage)added.get(d)).isBlock()) continue;
                ((ItemCoverage)added.get((Object)d)).count += dataBlockTarget.getCount();
                isNew = false;
                break;
            }
            if (!isNew) continue;
            added.put(dataBlockTarget, item);
            list.add(item);
        }
        for (DataBlock dataBlock : added.keySet()) {
            ItemCoverage i = (ItemCoverage)added.get(dataBlock);
            if (i.isBlock()) continue;
            ItemCoverage i2 = ItemCoverage.createBlockCoverageItem(i.startLine, i.endLine, i.count, dataBlock.getScale());
            isNew = true;
            for (DataBlock d : added.keySet()) {
                if (d.startBCI() != dataBlock.startBCI() || !((ItemCoverage)added.get(d)).isBlock()) continue;
                ((ItemCoverage)added.get((Object)d)).count += dataBlock.getCount();
                isNew = false;
                break;
            }
            if (!isNew) continue;
            added.put(dataBlock, i2);
            list.add(i2);
        }
    }

    public static int type(DataBlock db) {
        String type = db.kind();
        if (type.equals("methenter")) {
            return 1;
        }
        if (type.equals("cond")) {
            DataBlockTargetCond cond = (DataBlockTargetCond)db;
            return cond.side() ? 7 : 8;
        }
        if (type.equals("case")) {
            return 5;
        }
        if (type.equals("default")) {
            return 6;
        }
        return 3;
    }

    public List<ItemCoverage> getItems() {
        return this.items;
    }

    @Override
    public Iterator<ItemCoverage> iterator() {
        return this.items.iterator();
    }

    public LineCoverage getLineCoverage() {
        return this.lineCoverage;
    }

    @Override
    public DataType getDataType() {
        return DataType.METHOD;
    }

    @Override
    public CoverageData getData(DataType column) {
        return this.getData(column, -1);
    }

    @Override
    public CoverageData getData(DataType column, int testNumber) {
        switch (column) {
            case METHOD: {
                if (this.inAnonymClass && !this.anonymon) {
                    return new CoverageData(0, 0);
                }
                if (testNumber > -1) {
                    return new CoverageData(this.count > 0L && this.isCoveredByTest(testNumber) ? 1 : 0, 1);
                }
                return new CoverageData(this.count > 0L ? 1 : 0, 1);
            }
            case BLOCK: 
            case BRANCH: {
                CoverageData result = new CoverageData(0, 0);
                for (ItemCoverage item : this.items) {
                    if (testNumber < 0 || item.isCoveredByTest(testNumber)) {
                        result.add(item.getData(column));
                        continue;
                    }
                    result.add(new CoverageData(0, item.getData(column).getTotal()));
                }
                return result;
            }
            case LINE: {
                return this.lineCoverage;
            }
        }
        return new CoverageData();
    }

    @Override
    protected DataType[] getDataTypes() {
        return this.supportedColumns;
    }

    @Override
    public String getReadableSignature() {
        return Utils.convertVMtoJLS(this.name, this.signature);
    }

    public boolean isLineCovered(int lineNumber) {
        return this.lineCoverage.isLineCovered(lineNumber);
    }
}

